/* SearchPaths.c generated by valac 0.56.17, the Vala compiler
 * generated from SearchPaths.vala, do not modify */

/*
Copyright (C) 2012 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>

#define BIRD_FONT_PREFIX "/usr"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _BirdFontParamSpecSearchPaths BirdFontParamSpecSearchPaths;

struct _BirdFontParamSpecSearchPaths {
	GParamSpec parent_instance;
};

static gpointer bird_font_search_paths_parent_class = NULL;
static gchar* bird_font_search_paths_resources_folder;
static gchar* bird_font_search_paths_resources_folder = NULL;

static GFile* bird_font_search_paths_get_file (const gchar* path,
                                        const gchar* name);
static gboolean bird_font_search_paths_exists (const gchar* file);
static void bird_font_search_paths_finalize (BirdFontSearchPaths * obj);
static GType bird_font_search_paths_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

GFile*
bird_font_search_paths_find_file (const gchar* dir,
                                  const gchar* name)
{
	GFile* f = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = bird_font_search_paths_search_file (dir, name);
	f = _tmp0_;
	_tmp1_ = f;
	if (!g_file_query_exists (_tmp1_, NULL)) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = string_to_string (name);
		_tmp3_ = g_strconcat ("Did not find file ", _tmp2_, NULL);
		_tmp4_ = _tmp3_;
		g_warning ("SearchPaths.vala:26: %s", _tmp4_);
		_g_free0 (_tmp4_);
	}
	result = f;
	return result;
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

GFile*
bird_font_search_paths_search_file (const gchar* dir,
                                    const gchar* name)
{
	GFile* f = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* d = NULL;
	gchar* _tmp1_;
	gchar* resources = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_;
	gchar* bundle_path = NULL;
	gchar* _tmp5_;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_;
	gchar* _tmp9_;
	gchar* current_program = NULL;
	const gchar* _tmp15_;
	const gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	const gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	GFile* _tmp49_;
	GFile* _tmp50_;
	const gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	GFile* _tmp54_;
	GFile* _tmp55_;
	GFile* _tmp56_;
	GFile* _tmp57_;
	const gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	GFile* _tmp63_;
	GFile* _tmp64_;
	const gchar* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	const gchar* _tmp68_;
	gchar* _tmp69_;
	gchar* _tmp70_;
	gchar* _tmp71_;
	gchar* _tmp72_;
	GFile* _tmp73_;
	GFile* _tmp74_;
	const gchar* _tmp75_;
	gchar* _tmp76_;
	gchar* _tmp77_;
	gchar* _tmp78_;
	gchar* _tmp79_;
	GFile* _tmp80_;
	GFile* _tmp81_;
	const gchar* _tmp82_;
	gchar* _tmp83_;
	gchar* _tmp84_;
	const gchar* _tmp85_;
	gchar* _tmp86_;
	gchar* _tmp87_;
	gchar* _tmp88_;
	gchar* _tmp89_;
	GFile* _tmp90_;
	GFile* _tmp91_;
	const gchar* _tmp92_;
	gchar* _tmp93_;
	gchar* _tmp94_;
	gchar* _tmp95_;
	gchar* _tmp96_;
	GFile* _tmp97_;
	GFile* _tmp98_;
	const gchar* _tmp99_;
	gchar* _tmp100_;
	gchar* _tmp101_;
	const gchar* _tmp102_;
	gchar* _tmp103_;
	gchar* _tmp104_;
	gchar* _tmp105_;
	gchar* _tmp106_;
	GFile* _tmp107_;
	GFile* _tmp108_;
	const gchar* _tmp109_;
	gchar* _tmp110_;
	gchar* _tmp111_;
	gchar* _tmp112_;
	gchar* _tmp113_;
	GFile* _tmp114_;
	GFile* _tmp115_;
	const gchar* _tmp116_;
	gchar* _tmp117_;
	gchar* _tmp118_;
	gchar* _tmp119_;
	gchar* _tmp120_;
	GFile* _tmp121_;
	GFile* _tmp122_;
	const gchar* _tmp123_;
	gchar* _tmp124_;
	gchar* _tmp125_;
	gchar* _tmp126_;
	gchar* _tmp127_;
	GFile* _tmp128_;
	GFile* _tmp129_;
	const gchar* _tmp130_;
	gchar* _tmp131_;
	gchar* _tmp132_;
	gchar* _tmp133_;
	gchar* _tmp134_;
	GFile* _tmp135_;
	GFile* _tmp136_;
	GFile* _tmp137_;
	GFile* _tmp138_;
	const gchar* _tmp139_;
	gchar* _tmp140_;
	gchar* _tmp141_;
	GFile* _tmp142_;
	GFile* _tmp143_;
	const gchar* _tmp144_;
	gchar* _tmp145_;
	gchar* _tmp146_;
	const gchar* _tmp147_;
	gchar* _tmp148_;
	gchar* _tmp149_;
	gchar* _tmp150_;
	gchar* _tmp151_;
	GFile* _tmp152_;
	GFile* _tmp153_;
	const gchar* _tmp154_;
	gchar* _tmp155_;
	gchar* _tmp156_;
	gchar* _tmp157_;
	gchar* _tmp158_;
	GFile* _tmp159_;
	GFile* _tmp160_;
	GFile* _tmp161_;
	GFile* _tmp162_;
	const gchar* _tmp163_;
	gchar* _tmp164_;
	gchar* _tmp165_;
	gchar* _tmp166_;
	gchar* _tmp167_;
	GFile* _tmp168_;
	GFile* _tmp169_;
	GError* _inner_error0_ = NULL;
	GFile* result;
	g_return_val_if_fail (name != NULL, NULL);
	if (dir == NULL) {
		_tmp0_ = "";
	} else {
		_tmp0_ = (const gchar*) dir;
	}
	_tmp1_ = g_strdup (_tmp0_);
	d = _tmp1_;
	_tmp3_ = bird_font_bird_font_bundle_path;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = bird_font_bird_font_bundle_path;
		_tmp2_ = (const gchar*) _tmp4_;
	} else {
		_tmp2_ = "";
	}
	_tmp5_ = g_strdup (_tmp2_);
	bundle_path = _tmp5_;
	_tmp7_ = bird_font_search_paths_resources_folder;
	if (bird_font_is_null (_tmp7_)) {
		_tmp6_ = "";
	} else {
		const gchar* _tmp8_;
		_tmp8_ = bird_font_search_paths_resources_folder;
		_tmp6_ = _tmp8_;
	}
	_tmp9_ = g_strdup (_tmp6_);
	_g_free0 (resources);
	resources = _tmp9_;
	{
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp11_ = g_file_read_link ("/proc/self/exe", &_inner_error0_);
		_tmp10_ = _tmp11_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp12_ = _tmp10_;
		_tmp10_ = NULL;
		_g_free0 (current_program);
		current_program = _tmp12_;
		_g_free0 (_tmp10_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_warning ("SearchPaths.vala:44: %s", _tmp14_);
		_g_free0 (current_program);
		current_program = NULL;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (current_program);
		_g_free0 (bundle_path);
		_g_free0 (resources);
		_g_free0 (d);
		_g_object_unref0 (f);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp15_ = current_program;
	if (_tmp15_ != NULL) {
		gchar* program = NULL;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gint separator = 0;
		const gchar* _tmp18_;
		_tmp16_ = current_program;
		_tmp17_ = g_strdup ((const gchar*) _tmp16_);
		program = _tmp17_;
		_tmp18_ = program;
		separator = string_last_index_of (_tmp18_, "/", 0);
		if (separator > -1) {
			gchar* folder = NULL;
			const gchar* _tmp19_;
			gchar* _tmp20_;
			const gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			GFile* _tmp29_;
			GFile* _tmp30_;
			const gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			GFile* _tmp34_;
			GFile* _tmp35_;
			const gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			GFile* _tmp39_;
			GFile* _tmp40_;
			_tmp19_ = program;
			_tmp20_ = string_substring (_tmp19_, (glong) 0, (glong) separator);
			folder = _tmp20_;
			_tmp21_ = folder;
			_tmp22_ = g_strconcat (_tmp21_, "/../", NULL);
			_tmp23_ = _tmp22_;
			_tmp24_ = d;
			_tmp25_ = g_strconcat (_tmp23_, _tmp24_, NULL);
			_tmp26_ = _tmp25_;
			_tmp27_ = g_strconcat (_tmp26_, "/", NULL);
			_tmp28_ = _tmp27_;
			_tmp29_ = bird_font_search_paths_get_file (_tmp28_, name);
			_g_object_unref0 (f);
			f = _tmp29_;
			_g_free0 (_tmp28_);
			_g_free0 (_tmp26_);
			_g_free0 (_tmp23_);
			_tmp30_ = f;
			if (g_file_query_exists (_tmp30_, NULL)) {
				result = f;
				_g_free0 (folder);
				_g_free0 (program);
				_g_free0 (current_program);
				_g_free0 (bundle_path);
				_g_free0 (resources);
				_g_free0 (d);
				return result;
			}
			_tmp31_ = folder;
			_tmp32_ = g_strconcat (_tmp31_, "/../", NULL);
			_tmp33_ = _tmp32_;
			_tmp34_ = bird_font_search_paths_get_file (_tmp33_, name);
			_g_object_unref0 (f);
			f = _tmp34_;
			_g_free0 (_tmp33_);
			_tmp35_ = f;
			if (g_file_query_exists (_tmp35_, NULL)) {
				result = f;
				_g_free0 (folder);
				_g_free0 (program);
				_g_free0 (current_program);
				_g_free0 (bundle_path);
				_g_free0 (resources);
				_g_free0 (d);
				return result;
			}
			_tmp36_ = folder;
			_tmp37_ = g_strconcat (_tmp36_, "/../share/birdfont/", NULL);
			_tmp38_ = _tmp37_;
			_tmp39_ = bird_font_search_paths_get_file (_tmp38_, name);
			_g_object_unref0 (f);
			f = _tmp39_;
			_g_free0 (_tmp38_);
			_tmp40_ = f;
			if (g_file_query_exists (_tmp40_, NULL)) {
				result = f;
				_g_free0 (folder);
				_g_free0 (program);
				_g_free0 (current_program);
				_g_free0 (bundle_path);
				_g_free0 (resources);
				_g_free0 (d);
				return result;
			}
			_g_free0 (folder);
		}
		_g_free0 (program);
	}
	_tmp41_ = resources;
	_tmp42_ = g_strconcat (_tmp41_, "/", NULL);
	_tmp43_ = _tmp42_;
	_tmp44_ = d;
	_tmp45_ = g_strconcat (_tmp43_, _tmp44_, NULL);
	_tmp46_ = _tmp45_;
	_tmp47_ = g_strconcat (_tmp46_, "/", NULL);
	_tmp48_ = _tmp47_;
	_tmp49_ = bird_font_search_paths_get_file (_tmp48_, name);
	_g_object_unref0 (f);
	f = _tmp49_;
	_g_free0 (_tmp48_);
	_g_free0 (_tmp46_);
	_g_free0 (_tmp43_);
	_tmp50_ = f;
	if (g_file_query_exists (_tmp50_, NULL)) {
		result = f;
		_g_free0 (current_program);
		_g_free0 (bundle_path);
		_g_free0 (resources);
		_g_free0 (d);
		return result;
	}
	_tmp51_ = resources;
	_tmp52_ = g_strconcat (_tmp51_, "/", NULL);
	_tmp53_ = _tmp52_;
	_tmp54_ = bird_font_search_paths_get_file (_tmp53_, name);
	_g_object_unref0 (f);
	f = _tmp54_;
	_g_free0 (_tmp53_);
	_tmp55_ = f;
	if (g_file_query_exists (_tmp55_, NULL)) {
		result = f;
		_g_free0 (current_program);
		_g_free0 (bundle_path);
		_g_free0 (resources);
		_g_free0 (d);
		return result;
	}
	_tmp56_ = bird_font_search_paths_get_file ("resources/", name);
	_g_object_unref0 (f);
	f = _tmp56_;
	_tmp57_ = f;
	if (g_file_query_exists (_tmp57_, NULL)) {
		result = f;
		_g_free0 (current_program);
		_g_free0 (bundle_path);
		_g_free0 (resources);
		_g_free0 (d);
		return result;
	}
	_tmp58_ = resources;
	_tmp59_ = g_strconcat (_tmp58_, "/", NULL);
	_tmp60_ = _tmp59_;
	_tmp61_ = g_strconcat (name, "/", NULL);
	_tmp62_ = _tmp61_;
	_tmp63_ = bird_font_search_paths_get_file (_tmp60_, _tmp62_);
	_g_object_unref0 (f);
	f = _tmp63_;
	_g_free0 (_tmp62_);
	_g_free0 (_tmp60_);
	_tmp64_ = f;
	if (g_file_query_exists (_tmp64_, NULL)) {
		result = f;
		_g_free0 (current_program);
		_g_free0 (bundle_path);
		_g_free0 (resources);
		_g_free0 (d);
		return result;
	}
	_tmp65_ = bird_font_bird_font_exec_path;
	_tmp66_ = g_strconcat (_tmp65_, "/", NULL);
	_tmp67_ = _tmp66_;
	_tmp68_ = d;
	_tmp69_ = g_strconcat (_tmp67_, _tmp68_, NULL);
	_tmp70_ = _tmp69_;
	_tmp71_ = g_strconcat (_tmp70_, "/", NULL);
	_tmp72_ = _tmp71_;
	_tmp73_ = bird_font_search_paths_get_file (_tmp72_, name);
	_g_object_unref0 (f);
	f = _tmp73_;
	_g_free0 (_tmp72_);
	_g_free0 (_tmp70_);
	_g_free0 (_tmp67_);
	_tmp74_ = f;
	if (g_file_query_exists (_tmp74_, NULL)) {
		result = f;
		_g_free0 (current_program);
		_g_free0 (bundle_path);
		_g_free0 (resources);
		_g_free0 (d);
		return result;
	}
	_tmp75_ = bird_font_bird_font_exec_path;
	_tmp76_ = g_strconcat (_tmp75_, "/", NULL);
	_tmp77_ = _tmp76_;
	_tmp78_ = g_strconcat (name, "/", NULL);
	_tmp79_ = _tmp78_;
	_tmp80_ = bird_font_search_paths_get_file (_tmp77_, _tmp79_);
	_g_object_unref0 (f);
	f = _tmp80_;
	_g_free0 (_tmp79_);
	_g_free0 (_tmp77_);
	_tmp81_ = f;
	if (g_file_query_exists (_tmp81_, NULL)) {
		result = f;
		_g_free0 (current_program);
		_g_free0 (bundle_path);
		_g_free0 (resources);
		_g_free0 (d);
		return result;
	}
	_tmp82_ = bird_font_bird_font_exec_path;
	_tmp83_ = g_strconcat (_tmp82_, "\\", NULL);
	_tmp84_ = _tmp83_;
	_tmp85_ = d;
	_tmp86_ = g_strconcat (_tmp84_, _tmp85_, NULL);
	_tmp87_ = _tmp86_;
	_tmp88_ = g_strconcat (_tmp87_, "\\", NULL);
	_tmp89_ = _tmp88_;
	_tmp90_ = bird_font_search_paths_get_file (_tmp89_, name);
	_g_object_unref0 (f);
	f = _tmp90_;
	_g_free0 (_tmp89_);
	_g_free0 (_tmp87_);
	_g_free0 (_tmp84_);
	_tmp91_ = f;
	if (g_file_query_exists (_tmp91_, NULL)) {
		result = f;
		_g_free0 (current_program);
		_g_free0 (bundle_path);
		_g_free0 (resources);
		_g_free0 (d);
		return result;
	}
	_tmp92_ = bird_font_bird_font_exec_path;
	_tmp93_ = g_strconcat (_tmp92_, "\\", NULL);
	_tmp94_ = _tmp93_;
	_tmp95_ = g_strconcat (name, "\\", NULL);
	_tmp96_ = _tmp95_;
	_tmp97_ = bird_font_search_paths_get_file (_tmp94_, _tmp96_);
	_g_object_unref0 (f);
	f = _tmp97_;
	_g_free0 (_tmp96_);
	_g_free0 (_tmp94_);
	_tmp98_ = f;
	if (g_file_query_exists (_tmp98_, NULL)) {
		result = f;
		_g_free0 (current_program);
		_g_free0 (bundle_path);
		_g_free0 (resources);
		_g_free0 (d);
		return result;
	}
	_tmp99_ = bundle_path;
	_tmp100_ = g_strconcat (_tmp99_, "/Contents/Resources/birdfont_resources/", NULL);
	_tmp101_ = _tmp100_;
	_tmp102_ = d;
	_tmp103_ = g_strconcat (_tmp102_, "/", NULL);
	_tmp104_ = _tmp103_;
	_tmp105_ = g_strconcat (_tmp104_, name, NULL);
	_tmp106_ = _tmp105_;
	_tmp107_ = bird_font_search_paths_get_file (_tmp101_, _tmp106_);
	_g_object_unref0 (f);
	f = _tmp107_;
	_g_free0 (_tmp106_);
	_g_free0 (_tmp104_);
	_g_free0 (_tmp101_);
	_tmp108_ = f;
	if (g_file_query_exists (_tmp108_, NULL)) {
		result = f;
		_g_free0 (current_program);
		_g_free0 (bundle_path);
		_g_free0 (resources);
		_g_free0 (d);
		return result;
	}
	_tmp109_ = bundle_path;
	_tmp110_ = g_strconcat (_tmp109_, "/Contents/Resources/birdfont_resources/", NULL);
	_tmp111_ = _tmp110_;
	_tmp112_ = g_strconcat (name, "/", NULL);
	_tmp113_ = _tmp112_;
	_tmp114_ = bird_font_search_paths_get_file (_tmp111_, _tmp113_);
	_g_object_unref0 (f);
	f = _tmp114_;
	_g_free0 (_tmp113_);
	_g_free0 (_tmp111_);
	_tmp115_ = f;
	if (g_file_query_exists (_tmp115_, NULL)) {
		result = f;
		_g_free0 (current_program);
		_g_free0 (bundle_path);
		_g_free0 (resources);
		_g_free0 (d);
		return result;
	}
	_tmp116_ = d;
	_tmp117_ = g_strconcat ("./", _tmp116_, NULL);
	_tmp118_ = _tmp117_;
	_tmp119_ = g_strconcat (_tmp118_, "/", NULL);
	_tmp120_ = _tmp119_;
	_tmp121_ = bird_font_search_paths_get_file (_tmp120_, name);
	_g_object_unref0 (f);
	f = _tmp121_;
	_g_free0 (_tmp120_);
	_g_free0 (_tmp118_);
	_tmp122_ = f;
	if (g_file_query_exists (_tmp122_, NULL)) {
		result = f;
		_g_free0 (current_program);
		_g_free0 (bundle_path);
		_g_free0 (resources);
		_g_free0 (d);
		return result;
	}
	_tmp123_ = d;
	_tmp124_ = g_strconcat ("../", _tmp123_, NULL);
	_tmp125_ = _tmp124_;
	_tmp126_ = g_strconcat (_tmp125_, "/", NULL);
	_tmp127_ = _tmp126_;
	_tmp128_ = bird_font_search_paths_get_file (_tmp127_, name);
	_g_object_unref0 (f);
	f = _tmp128_;
	_g_free0 (_tmp127_);
	_g_free0 (_tmp125_);
	_tmp129_ = f;
	if (g_file_query_exists (_tmp129_, NULL)) {
		result = f;
		_g_free0 (current_program);
		_g_free0 (bundle_path);
		_g_free0 (resources);
		_g_free0 (d);
		return result;
	}
	_tmp130_ = d;
	_tmp131_ = g_strconcat (".\\", _tmp130_, NULL);
	_tmp132_ = _tmp131_;
	_tmp133_ = g_strconcat (_tmp132_, "\\", NULL);
	_tmp134_ = _tmp133_;
	_tmp135_ = bird_font_search_paths_get_file (_tmp134_, name);
	_g_object_unref0 (f);
	f = _tmp135_;
	_g_free0 (_tmp134_);
	_g_free0 (_tmp132_);
	_tmp136_ = f;
	if (g_file_query_exists (_tmp136_, NULL)) {
		result = f;
		_g_free0 (current_program);
		_g_free0 (bundle_path);
		_g_free0 (resources);
		_g_free0 (d);
		return result;
	}
	_tmp137_ = bird_font_search_paths_get_file ("", name);
	_g_object_unref0 (f);
	f = _tmp137_;
	_tmp138_ = f;
	if (g_file_query_exists (_tmp138_, NULL)) {
		result = f;
		_g_free0 (current_program);
		_g_free0 (bundle_path);
		_g_free0 (resources);
		_g_free0 (d);
		return result;
	}
	_tmp139_ = d;
	_tmp140_ = g_strconcat (_tmp139_, "\\", NULL);
	_tmp141_ = _tmp140_;
	_tmp142_ = bird_font_search_paths_get_file (_tmp141_, name);
	_g_object_unref0 (f);
	f = _tmp142_;
	_g_free0 (_tmp141_);
	_tmp143_ = f;
	if (g_file_query_exists (_tmp143_, NULL)) {
		result = f;
		_g_free0 (current_program);
		_g_free0 (bundle_path);
		_g_free0 (resources);
		_g_free0 (d);
		return result;
	}
	_tmp144_ = string_to_string (BIRD_FONT_PREFIX);
	_tmp145_ = g_strconcat (_tmp144_, "/share/birdfont/", NULL);
	_tmp146_ = _tmp145_;
	_tmp147_ = d;
	_tmp148_ = g_strconcat (_tmp146_, _tmp147_, NULL);
	_tmp149_ = _tmp148_;
	_tmp150_ = g_strconcat (_tmp149_, "/", NULL);
	_tmp151_ = _tmp150_;
	_tmp152_ = bird_font_search_paths_get_file (_tmp151_, name);
	_g_object_unref0 (f);
	f = _tmp152_;
	_g_free0 (_tmp151_);
	_g_free0 (_tmp149_);
	_g_free0 (_tmp146_);
	_tmp153_ = f;
	if (g_file_query_exists (_tmp153_, NULL)) {
		result = f;
		_g_free0 (current_program);
		_g_free0 (bundle_path);
		_g_free0 (resources);
		_g_free0 (d);
		return result;
	}
	_tmp154_ = d;
	_tmp155_ = g_strconcat ("/usr/local/share/birdfont/", _tmp154_, NULL);
	_tmp156_ = _tmp155_;
	_tmp157_ = g_strconcat (_tmp156_, "/", NULL);
	_tmp158_ = _tmp157_;
	_tmp159_ = bird_font_search_paths_get_file (_tmp158_, name);
	_g_object_unref0 (f);
	f = _tmp159_;
	_g_free0 (_tmp158_);
	_g_free0 (_tmp156_);
	_tmp160_ = f;
	if (g_file_query_exists (_tmp160_, NULL)) {
		result = f;
		_g_free0 (current_program);
		_g_free0 (bundle_path);
		_g_free0 (resources);
		_g_free0 (d);
		return result;
	}
	_tmp161_ = bird_font_search_paths_get_file ("resources/linux/", name);
	_g_object_unref0 (f);
	f = _tmp161_;
	_tmp162_ = f;
	if (g_file_query_exists (_tmp162_, NULL)) {
		result = f;
		_g_free0 (current_program);
		_g_free0 (bundle_path);
		_g_free0 (resources);
		_g_free0 (d);
		return result;
	}
	_tmp163_ = d;
	_tmp164_ = g_strconcat ("/usr/share/birdfont/", _tmp163_, NULL);
	_tmp165_ = _tmp164_;
	_tmp166_ = g_strconcat (_tmp165_, "/", NULL);
	_tmp167_ = _tmp166_;
	_tmp168_ = bird_font_search_paths_get_file (_tmp167_, name);
	_g_object_unref0 (f);
	f = _tmp168_;
	_g_free0 (_tmp167_);
	_g_free0 (_tmp165_);
	_tmp169_ = f;
	if (g_file_query_exists (_tmp169_, NULL)) {
		result = f;
		_g_free0 (current_program);
		_g_free0 (bundle_path);
		_g_free0 (resources);
		_g_free0 (d);
		return result;
	}
	result = f;
	_g_free0 (current_program);
	_g_free0 (bundle_path);
	_g_free0 (resources);
	_g_free0 (d);
	return result;
}

gchar*
bird_font_search_paths_get_locale_directory (void)
{
	gchar* f = NULL;
	gchar* _tmp0_;
	gchar* resources = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	gchar* bundle_path = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp14_;
	gchar* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp37_;
	gchar* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp42_;
	gchar* _tmp43_;
	const gchar* _tmp44_;
	gchar* _tmp47_;
	gchar* result;
	_tmp0_ = g_strdup ("");
	f = _tmp0_;
	_tmp2_ = bird_font_bird_font_bundle_path;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = bird_font_bird_font_bundle_path;
		_tmp1_ = (const gchar*) _tmp3_;
	} else {
		_tmp1_ = "";
	}
	_tmp4_ = g_strdup (_tmp1_);
	bundle_path = _tmp4_;
	_tmp6_ = bird_font_search_paths_resources_folder;
	if (bird_font_is_null (_tmp6_)) {
		_tmp5_ = "";
	} else {
		const gchar* _tmp7_;
		_tmp7_ = bird_font_search_paths_resources_folder;
		_tmp5_ = _tmp7_;
	}
	_tmp8_ = g_strdup (_tmp5_);
	_g_free0 (resources);
	resources = _tmp8_;
	_tmp9_ = resources;
	_tmp10_ = g_strconcat (_tmp9_, "\\locale\\sv\\LC_MESSAGES\\birdfont.mo", NULL);
	_g_free0 (f);
	f = _tmp10_;
	_tmp11_ = f;
	if (bird_font_search_paths_exists (_tmp11_)) {
		const gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp12_ = resources;
		_tmp13_ = g_strconcat (_tmp12_, "\\locale", NULL);
		result = _tmp13_;
		_g_free0 (bundle_path);
		_g_free0 (resources);
		_g_free0 (f);
		return result;
	}
	_tmp14_ = bird_font_bird_font_exec_path;
	if (!bird_font_is_null (_tmp14_)) {
		const gchar* _tmp15_;
		gchar* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		const gchar* _tmp22_;
		_tmp15_ = bird_font_bird_font_exec_path;
		_tmp16_ = g_strconcat (_tmp15_, "/Contents/Resources/birdfont_resources/locale/sv/LC_MESSAGES/birdfont." \
"mo", NULL);
		_g_free0 (f);
		f = _tmp16_;
		_tmp17_ = f;
		if (bird_font_search_paths_exists (_tmp17_)) {
			const gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp18_ = bird_font_bird_font_exec_path;
			_tmp19_ = g_strconcat (_tmp18_, "/Contents/birdfont_resources/Resources/locale", NULL);
			result = _tmp19_;
			_g_free0 (bundle_path);
			_g_free0 (resources);
			_g_free0 (f);
			return result;
		}
		_tmp20_ = bird_font_bird_font_exec_path;
		_tmp21_ = g_strconcat (_tmp20_, "\\locale\\sv\\LC_MESSAGES\\birdfont.mo", NULL);
		_g_free0 (f);
		f = _tmp21_;
		_tmp22_ = f;
		if (bird_font_search_paths_exists (_tmp22_)) {
			const gchar* _tmp23_;
			gchar* _tmp24_;
			_tmp23_ = bird_font_bird_font_exec_path;
			_tmp24_ = g_strconcat (_tmp23_, "\\locale", NULL);
			result = _tmp24_;
			_g_free0 (bundle_path);
			_g_free0 (resources);
			_g_free0 (f);
			return result;
		}
	}
	_tmp25_ = g_strdup ("./build/locale/sv/LC_MESSAGES/birdfont.mo");
	_g_free0 (f);
	f = _tmp25_;
	_tmp26_ = f;
	if (bird_font_search_paths_exists (_tmp26_)) {
		gchar* _tmp27_;
		_tmp27_ = g_strdup ("./build/locale");
		result = _tmp27_;
		_g_free0 (bundle_path);
		_g_free0 (resources);
		_g_free0 (f);
		return result;
	}
	_tmp28_ = g_strdup (".\\locale\\sv\\LC_MESSAGES\\birdfont.mo");
	_g_free0 (f);
	f = _tmp28_;
	_tmp29_ = f;
	if (bird_font_search_paths_exists (_tmp29_)) {
		gchar* _tmp30_;
		_tmp30_ = g_strdup (".\\locale");
		result = _tmp30_;
		_g_free0 (bundle_path);
		_g_free0 (resources);
		_g_free0 (f);
		return result;
	}
	_tmp31_ = g_strdup (BIRD_FONT_PREFIX "/share/locale/sv/LC_MESSAGES/birdfont.mo");
	_g_free0 (f);
	f = _tmp31_;
	_tmp32_ = f;
	if (bird_font_search_paths_exists (_tmp32_)) {
		gchar* _tmp33_;
		_tmp33_ = g_strdup (BIRD_FONT_PREFIX "/share/locale/");
		result = _tmp33_;
		_g_free0 (bundle_path);
		_g_free0 (resources);
		_g_free0 (f);
		return result;
	}
	_tmp34_ = g_strdup ("/usr/share/locale/sv/LC_MESSAGES/birdfont.mo");
	_g_free0 (f);
	f = _tmp34_;
	_tmp35_ = f;
	if (bird_font_search_paths_exists (_tmp35_)) {
		gchar* _tmp36_;
		_tmp36_ = g_strdup ("/usr/share/locale");
		result = _tmp36_;
		_g_free0 (bundle_path);
		_g_free0 (resources);
		_g_free0 (f);
		return result;
	}
	_tmp37_ = bird_font_bird_font_exec_path;
	_tmp38_ = g_strconcat (_tmp37_, "/Contents/Resources/birdfont_resources/locale", NULL);
	_g_free0 (f);
	f = _tmp38_;
	_tmp39_ = f;
	if (bird_font_search_paths_exists (_tmp39_)) {
		const gchar* _tmp40_;
		gchar* _tmp41_;
		_tmp40_ = bird_font_bird_font_exec_path;
		_tmp41_ = g_strconcat (_tmp40_, "/Contents/Resources/birdfont_resources/locale", NULL);
		result = _tmp41_;
		_g_free0 (bundle_path);
		_g_free0 (resources);
		_g_free0 (f);
		return result;
	}
	_tmp42_ = bundle_path;
	_tmp43_ = g_strconcat (_tmp42_, "/Contents/Resources/birdfont_resources/locale", NULL);
	_g_free0 (f);
	f = _tmp43_;
	_tmp44_ = f;
	if (bird_font_search_paths_exists (_tmp44_)) {
		const gchar* _tmp45_;
		gchar* _tmp46_;
		_tmp45_ = bundle_path;
		_tmp46_ = g_strconcat (_tmp45_, "/Contents/Resources/birdfont_resources/locale", NULL);
		result = _tmp46_;
		_g_free0 (bundle_path);
		_g_free0 (resources);
		_g_free0 (f);
		return result;
	}
	g_warning ("SearchPaths.vala:180: translations not found");
	_tmp47_ = g_strdup ("/usr/share/locale");
	result = _tmp47_;
	_g_free0 (bundle_path);
	_g_free0 (resources);
	_g_free0 (f);
	return result;
}

GFile*
bird_font_search_paths_get_char_database (void)
{
	GFile* f = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* bundle_path = NULL;
	gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GFile* _tmp17_;
	GFile* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	GFile* _tmp22_;
	GFile* _tmp23_;
	GFile* _tmp24_;
	GFile* _tmp25_;
	GFile* result;
	_tmp1_ = bird_font_bird_font_bundle_path;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = bird_font_bird_font_bundle_path;
		_tmp0_ = (const gchar*) _tmp2_;
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = g_strdup (_tmp0_);
	bundle_path = _tmp3_;
	_tmp4_ = g_file_new_for_path ("./resources/NamesList.txt");
	_g_object_unref0 (f);
	f = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, g_file_get_type (), GFile);
	_tmp5_ = f;
	if (g_file_query_exists (_tmp5_, NULL)) {
		result = f;
		_g_free0 (bundle_path);
		return result;
	}
	_tmp6_ = g_file_new_for_path (BIRD_FONT_PREFIX "/share/unicode/NamesList.txt");
	_g_object_unref0 (f);
	f = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, g_file_get_type (), GFile);
	_tmp7_ = f;
	if (g_file_query_exists (_tmp7_, NULL)) {
		result = f;
		_g_free0 (bundle_path);
		return result;
	}
	_tmp8_ = g_file_new_for_path (BIRD_FONT_PREFIX "/share/unicode/ucd/NamesList.txt");
	_g_object_unref0 (f);
	f = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, g_file_get_type (), GFile);
	_tmp9_ = f;
	if (g_file_query_exists (_tmp9_, NULL)) {
		result = f;
		_g_free0 (bundle_path);
		return result;
	}
	_tmp10_ = g_file_new_for_path (".\\NamesList.txt");
	_g_object_unref0 (f);
	f = G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, g_file_get_type (), GFile);
	_tmp11_ = f;
	if (g_file_query_exists (_tmp11_, NULL)) {
		result = f;
		_g_free0 (bundle_path);
		return result;
	}
	_tmp12_ = g_file_new_for_path ("/usr/share/unicode/NamesList.txt");
	_g_object_unref0 (f);
	f = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, g_file_get_type (), GFile);
	_tmp13_ = f;
	if (g_file_query_exists (_tmp13_, NULL)) {
		result = f;
		_g_free0 (bundle_path);
		return result;
	}
	_tmp14_ = bird_font_bird_font_exec_path;
	_tmp15_ = g_strconcat (_tmp14_, "/Contents/Resources/NamesList.txt", NULL);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_file_new_for_path (_tmp16_);
	_g_object_unref0 (f);
	f = G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, g_file_get_type (), GFile);
	_g_free0 (_tmp16_);
	_tmp18_ = f;
	if (g_file_query_exists (_tmp18_, NULL)) {
		result = f;
		_g_free0 (bundle_path);
		return result;
	}
	_tmp19_ = bundle_path;
	_tmp20_ = g_strconcat (_tmp19_, "/Contents/Resources/NamesList.txt", NULL);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_file_new_for_path (_tmp21_);
	_g_object_unref0 (f);
	f = G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, g_file_get_type (), GFile);
	_g_free0 (_tmp21_);
	_tmp23_ = f;
	if (g_file_query_exists (_tmp23_, NULL)) {
		result = f;
		_g_free0 (bundle_path);
		return result;
	}
	_tmp24_ = g_file_new_for_path ("/usr/share/unicode/ucd/NamesList.txt");
	_g_object_unref0 (f);
	f = G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, g_file_get_type (), GFile);
	_tmp25_ = f;
	if (g_file_query_exists (_tmp25_, NULL)) {
		result = f;
		_g_free0 (bundle_path);
		return result;
	}
	g_warning ("SearchPaths.vala:228: ucd not found");
	result = f;
	_g_free0 (bundle_path);
	return result;
}

static GFile*
bird_font_search_paths_get_file (const gchar* path,
                                 const gchar* name)
{
	GString* fn = NULL;
	GString* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* p = NULL;
	gchar* _tmp2_;
	GString* _tmp3_;
	GString* _tmp4_;
	GString* _tmp5_;
	const gchar* _tmp6_;
	GFile* _tmp7_;
	GFile* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_string_new ("");
	fn = _tmp0_;
	if (path == NULL) {
		_tmp1_ = "";
	} else {
		_tmp1_ = (const gchar*) path;
	}
	_tmp2_ = g_strdup (_tmp1_);
	p = _tmp2_;
	_tmp3_ = fn;
	g_string_append (_tmp3_, p);
	_tmp4_ = fn;
	g_string_append (_tmp4_, (const gchar*) name);
	_tmp5_ = fn;
	_tmp6_ = _tmp5_->str;
	_tmp7_ = g_file_new_for_path (_tmp6_);
	result = _tmp7_;
	_g_free0 (p);
	_g_string_free0 (fn);
	return result;
}

static gboolean
bird_font_search_paths_exists (const gchar* file)
{
	GFile* f = NULL;
	GFile* _tmp0_;
	gboolean result;
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp0_ = g_file_new_for_path (file);
	f = _tmp0_;
	result = g_file_query_exists (f, NULL);
	_g_object_unref0 (f);
	return result;
}

void
bird_font_search_paths_set_resources_folder (const gchar* res)
{
	gchar* _tmp0_;
	g_return_if_fail (res != NULL);
	_tmp0_ = g_strdup (res);
	_g_free0 (bird_font_search_paths_resources_folder);
	bird_font_search_paths_resources_folder = _tmp0_;
}

BirdFontSearchPaths*
bird_font_search_paths_construct (GType object_type)
{
	BirdFontSearchPaths* self = NULL;
	self = (BirdFontSearchPaths*) g_type_create_instance (object_type);
	return self;
}

BirdFontSearchPaths*
bird_font_search_paths_new (void)
{
	return bird_font_search_paths_construct (BIRD_FONT_TYPE_SEARCH_PATHS);
}

static void
bird_font_value_search_paths_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
bird_font_value_search_paths_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		bird_font_search_paths_unref (value->data[0].v_pointer);
	}
}

static void
bird_font_value_search_paths_copy_value (const GValue* src_value,
                                         GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = bird_font_search_paths_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
bird_font_value_search_paths_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
bird_font_value_search_paths_collect_value (GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BirdFontSearchPaths * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = bird_font_search_paths_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
bird_font_value_search_paths_lcopy_value (const GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	BirdFontSearchPaths ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = bird_font_search_paths_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
bird_font_param_spec_search_paths (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags)
{
	BirdFontParamSpecSearchPaths* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BIRD_FONT_TYPE_SEARCH_PATHS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
bird_font_value_get_search_paths (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TYPE_SEARCH_PATHS), NULL);
	return value->data[0].v_pointer;
}

void
bird_font_value_set_search_paths (GValue* value,
                                  gpointer v_object)
{
	BirdFontSearchPaths * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TYPE_SEARCH_PATHS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BIRD_FONT_TYPE_SEARCH_PATHS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		bird_font_search_paths_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		bird_font_search_paths_unref (old);
	}
}

void
bird_font_value_take_search_paths (GValue* value,
                                   gpointer v_object)
{
	BirdFontSearchPaths * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TYPE_SEARCH_PATHS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BIRD_FONT_TYPE_SEARCH_PATHS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		bird_font_search_paths_unref (old);
	}
}

static void
bird_font_search_paths_class_init (BirdFontSearchPathsClass * klass,
                                   gpointer klass_data)
{
	gchar* _tmp0_;
	bird_font_search_paths_parent_class = g_type_class_peek_parent (klass);
	((BirdFontSearchPathsClass *) klass)->finalize = bird_font_search_paths_finalize;
	_tmp0_ = g_strdup ("");
	bird_font_search_paths_resources_folder = _tmp0_;
}

static void
bird_font_search_paths_instance_init (BirdFontSearchPaths * self,
                                      gpointer klass)
{
	self->ref_count = 1;
}

static void
bird_font_search_paths_finalize (BirdFontSearchPaths * obj)
{
	BirdFontSearchPaths * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_SEARCH_PATHS, BirdFontSearchPaths);
	g_signal_handlers_destroy (self);
}

/** Look for files in default folders on different operating systems. */
static GType
bird_font_search_paths_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { bird_font_value_search_paths_init, bird_font_value_search_paths_free_value, bird_font_value_search_paths_copy_value, bird_font_value_search_paths_peek_pointer, "p", bird_font_value_search_paths_collect_value, "p", bird_font_value_search_paths_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontSearchPathsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_search_paths_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontSearchPaths), 0, (GInstanceInitFunc) bird_font_search_paths_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType bird_font_search_paths_type_id;
	bird_font_search_paths_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BirdFontSearchPaths", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return bird_font_search_paths_type_id;
}

GType
bird_font_search_paths_get_type (void)
{
	static volatile gsize bird_font_search_paths_type_id__once = 0;
	if (g_once_init_enter (&bird_font_search_paths_type_id__once)) {
		GType bird_font_search_paths_type_id;
		bird_font_search_paths_type_id = bird_font_search_paths_get_type_once ();
		g_once_init_leave (&bird_font_search_paths_type_id__once, bird_font_search_paths_type_id);
	}
	return bird_font_search_paths_type_id__once;
}

gpointer
bird_font_search_paths_ref (gpointer instance)
{
	BirdFontSearchPaths * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
bird_font_search_paths_unref (gpointer instance)
{
	BirdFontSearchPaths * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BIRD_FONT_SEARCH_PATHS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

