/* workspace_manager.c generated by valac 0.56.17, the Vala compiler
 * generated from workspace_manager.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2011 ~ 2018 Deepin, Inc.
 *               2011 ~ 2018 Wang Yong
 *
 * Author:     Wang Yong <wangyong@deepin.com>
 * Maintainer: Wang Yong <wangyong@deepin.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gee.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>

#define GETTEXT_PACKAGE "deepin-terminal-gtk"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define WIDGETS_TYPE_WORKSPACE_MANAGER (widgets_workspace_manager_get_type ())
#define WIDGETS_WORKSPACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_WORKSPACE_MANAGER, WidgetsWorkspaceManager))
#define WIDGETS_WORKSPACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_WORKSPACE_MANAGER, WidgetsWorkspaceManagerClass))
#define WIDGETS_IS_WORKSPACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_WORKSPACE_MANAGER))
#define WIDGETS_IS_WORKSPACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_WORKSPACE_MANAGER))
#define WIDGETS_WORKSPACE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_WORKSPACE_MANAGER, WidgetsWorkspaceManagerClass))

typedef struct _WidgetsWorkspaceManager WidgetsWorkspaceManager;
typedef struct _WidgetsWorkspaceManagerClass WidgetsWorkspaceManagerClass;
typedef struct _WidgetsWorkspaceManagerPrivate WidgetsWorkspaceManagerPrivate;

#define WIDGETS_TYPE_WORKSPACE (widgets_workspace_get_type ())
#define WIDGETS_WORKSPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_WORKSPACE, WidgetsWorkspace))
#define WIDGETS_WORKSPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_WORKSPACE, WidgetsWorkspaceClass))
#define WIDGETS_IS_WORKSPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_WORKSPACE))
#define WIDGETS_IS_WORKSPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_WORKSPACE))
#define WIDGETS_WORKSPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_WORKSPACE, WidgetsWorkspaceClass))

typedef struct _WidgetsWorkspace WidgetsWorkspace;
typedef struct _WidgetsWorkspaceClass WidgetsWorkspaceClass;

#define WIDGETS_TYPE_TABBAR (widgets_tabbar_get_type ())
#define WIDGETS_TABBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_TABBAR, WidgetsTabbar))
#define WIDGETS_TABBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_TABBAR, WidgetsTabbarClass))
#define WIDGETS_IS_TABBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_TABBAR))
#define WIDGETS_IS_TABBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_TABBAR))
#define WIDGETS_TABBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_TABBAR, WidgetsTabbarClass))

typedef struct _WidgetsTabbar WidgetsTabbar;
typedef struct _WidgetsTabbarClass WidgetsTabbarClass;

#define WIDGETS_TYPE_TERM (widgets_term_get_type ())
#define WIDGETS_TERM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_TERM, WidgetsTerm))
#define WIDGETS_TERM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_TERM, WidgetsTermClass))
#define WIDGETS_IS_TERM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_TERM))
#define WIDGETS_IS_TERM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_TERM))
#define WIDGETS_TERM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_TERM, WidgetsTermClass))

typedef struct _WidgetsTerm WidgetsTerm;
typedef struct _WidgetsTermClass WidgetsTermClass;
enum  {
	WIDGETS_WORKSPACE_MANAGER_0_PROPERTY,
	WIDGETS_WORKSPACE_MANAGER_NUM_PROPERTIES
};
static GParamSpec* widgets_workspace_manager_properties[WIDGETS_WORKSPACE_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _WidgetsTabbarPrivate WidgetsTabbarPrivate;

#define WIDGETS_TYPE_CONFIG_WINDOW (widgets_config_window_get_type ())
#define WIDGETS_CONFIG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindow))
#define WIDGETS_CONFIG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindowClass))
#define WIDGETS_IS_CONFIG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_CONFIG_WINDOW))
#define WIDGETS_IS_CONFIG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_CONFIG_WINDOW))
#define WIDGETS_CONFIG_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindowClass))

typedef struct _WidgetsConfigWindow WidgetsConfigWindow;
typedef struct _WidgetsConfigWindowClass WidgetsConfigWindowClass;
typedef struct _WidgetsConfigWindowPrivate WidgetsConfigWindowPrivate;

#define CONFIG_TYPE_CONFIG (config_config_get_type ())
#define CONFIG_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_CONFIG, ConfigConfig))
#define CONFIG_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_CONFIG, ConfigConfigClass))
#define CONFIG_IS_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_CONFIG))
#define CONFIG_IS_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_CONFIG))
#define CONFIG_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_CONFIG, ConfigConfigClass))

typedef struct _ConfigConfig ConfigConfig;
typedef struct _ConfigConfigClass ConfigConfigClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _WidgetsWorkspaceManager {
	GtkBox parent_instance;
	WidgetsWorkspaceManagerPrivate * priv;
	GeeHashMap* workspace_map;
	WidgetsTabbar* tabbar;
	WidgetsWorkspace* focus_workspace;
	gint workspace_index;
};

struct _WidgetsWorkspaceManagerClass {
	GtkBoxClass parent_class;
};

struct _WidgetsWorkspaceManagerPrivate {
	WidgetsTerm* first_term;
	gboolean has_first_term_created;
};

struct _WidgetsTabbar {
	GtkDrawingArea parent_instance;
	WidgetsTabbarPrivate * priv;
	GdkRGBA tab_split_dark_color;
	GdkRGBA tab_split_light_color;
	GeeHashMap* tab_highlight_map;
	GeeArrayList* tab_list;
	GdkRGBA hover_arrow_color;
	GdkRGBA inactive_arrow_color;
	GdkRGBA tab_text_color;
	GdkRGBA text_active_color;
	GdkRGBA text_dark_color;
	GdkRGBA text_highlight_color;
	GdkRGBA text_hover_dark_color;
	GdkRGBA text_hover_light_color;
	GdkRGBA text_light_color;
	GeeHashMap* tab_name_map;
	PangoFontDescription* font_description;
	gboolean allowed_add_tab;
	gint font_size;
	gint height;
	gint hover_clip_right_offset;
	gint min_tab_width;
	gint tab_index;
};

struct _WidgetsTabbarClass {
	GtkDrawingAreaClass parent_class;
};

struct _WidgetsConfigWindow {
	GtkWindow parent_instance;
	WidgetsConfigWindowPrivate * priv;
	ConfigConfig* config;
	GdkRGBA title_line_dark_color;
	GdkRGBA title_line_light_color;
	GdkScreen* screen_monitor;
	GtkBox* box;
	GtkBox* top_box;
	GtkBox* window_frame_box;
	GtkBox* window_widget_box;
	WidgetsWorkspaceManager* workspace_manager;
	gboolean quake_mode;
	gboolean show_quake_menu;
	gboolean* config_theme_is_light;
	gint active_tab_underline_width;
	gint active_tab_underline_x;
	gint cache_height;
	gint cache_width;
	gint reset_timeout_delay;
	gint resize_cache_x;
	gint resize_cache_y;
	gint resize_cache_width;
	gint resize_cache_height;
	gint resize_timeout_delay;
	guint* reset_timeout_source_id;
	guint* resize_timeout_source_id;
};

struct _WidgetsConfigWindowClass {
	GtkWindowClass parent_class;
	void (*toggle_fullscreen) (WidgetsConfigWindow* self);
	void (*window_save_before_quit) (WidgetsConfigWindow* self);
	GdkCursorType* (*get_frame_cursor_type) (WidgetsConfigWindow* self, gdouble x, gdouble y);
	void (*update_frame) (WidgetsConfigWindow* self);
	GdkCursorType* (*get_cursor_type) (WidgetsConfigWindow* self, gdouble x, gdouble y);
};

static gint WidgetsWorkspaceManager_private_offset;
static gpointer widgets_workspace_manager_parent_class = NULL;

VALA_EXTERN GType widgets_workspace_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsWorkspaceManager, g_object_unref)
VALA_EXTERN GType widgets_workspace_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsWorkspace, g_object_unref)
VALA_EXTERN GType widgets_tabbar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsTabbar, g_object_unref)
VALA_EXTERN GType widgets_term_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsTerm, g_object_unref)
VALA_EXTERN WidgetsWorkspaceManager* widgets_workspace_manager_new (WidgetsTabbar* t,
                                                        const gchar* work_directory);
VALA_EXTERN WidgetsWorkspaceManager* widgets_workspace_manager_construct (GType object_type,
                                                              WidgetsTabbar* t,
                                                              const gchar* work_directory);
VALA_EXTERN void widgets_workspace_manager_new_workspace (WidgetsWorkspaceManager* self,
                                              const gchar* work_directory,
                                              gboolean remote_serve_action);
VALA_EXTERN void widgets_workspace_manager_set_first_term (WidgetsWorkspaceManager* self,
                                               WidgetsTerm* term);
VALA_EXTERN gboolean widgets_workspace_manager_is_first_term (WidgetsWorkspaceManager* self,
                                                  WidgetsTerm* term);
VALA_EXTERN void widgets_workspace_manager_pack_workspace (WidgetsWorkspaceManager* self,
                                               WidgetsWorkspace* workspace);
VALA_EXTERN void widgets_workspace_select_focus_terminal (WidgetsWorkspace* self);
VALA_EXTERN void widgets_workspace_manager_new_workspace_with_current_directory (WidgetsWorkspaceManager* self,
                                                                     gboolean remote_serve_action);
VALA_EXTERN WidgetsTerm* widgets_workspace_get_focus_term (WidgetsWorkspace* self,
                                               GtkContainer* container);
VALA_EXTERN gchar* widgets_term_get_cwd (WidgetsTerm* self);
VALA_EXTERN void utils_remove_all_children (GtkContainer* container);
VALA_EXTERN void widgets_tabbar_add_tab (WidgetsTabbar* self,
                             const gchar* tab_name,
                             gint tab_id);
VALA_EXTERN WidgetsWorkspace* widgets_workspace_new (gint workspace_index,
                                         const gchar* work_directory,
                                         WidgetsWorkspaceManager* manager);
VALA_EXTERN WidgetsWorkspace* widgets_workspace_construct (GType object_type,
                                               gint workspace_index,
                                               const gchar* work_directory,
                                               WidgetsWorkspaceManager* manager);
static void ___lambda87_ (WidgetsWorkspaceManager* self,
                   WidgetsWorkspace* workspace,
                   gint index,
                   const gchar* dir);
VALA_EXTERN void widgets_tabbar_rename_tab (WidgetsTabbar* self,
                                gint tab_id,
                                const gchar* tab_name);
static void ____lambda87__widgets_workspace_change_title (WidgetsWorkspace* _sender,
                                                   gint index,
                                                   const gchar* dir,
                                                   gpointer self);
static void ___lambda88_ (WidgetsWorkspaceManager* self,
                   WidgetsWorkspace* workspace,
                   gint index);
VALA_EXTERN void widgets_tabbar_highlight_tab (WidgetsTabbar* self,
                                   gint tab_id);
static void ____lambda88__widgets_workspace_highlight_tab (WidgetsWorkspace* _sender,
                                                    gint index,
                                                    gpointer self);
static void ___lambda89_ (WidgetsWorkspaceManager* self,
                   WidgetsWorkspace* workspace,
                   gint index);
VALA_EXTERN void widgets_tabbar_close_current_tab (WidgetsTabbar* self);
static void ____lambda89__widgets_workspace_exit (WidgetsWorkspace* _sender,
                                           gint index,
                                           gpointer self);
VALA_EXTERN void widgets_tabbar_select_tab_with_id (WidgetsTabbar* self,
                                        gint tab_id);
VALA_EXTERN GType widgets_config_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsConfigWindow, g_object_unref)
VALA_EXTERN GType config_config_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigConfig, g_object_unref)
VALA_EXTERN void widgets_workspace_manager_switch_workspace_with_index (WidgetsWorkspaceManager* self,
                                                            gint index);
VALA_EXTERN void widgets_tabbar_select_first_tab (WidgetsTabbar* self);
VALA_EXTERN void widgets_tabbar_select_end_tab (WidgetsTabbar* self);
VALA_EXTERN void widgets_tabbar_select_nth_tab (WidgetsTabbar* self,
                                    gint index);
VALA_EXTERN void widgets_workspace_manager_switch_workspace (WidgetsWorkspaceManager* self,
                                                 gint workspace_index);
VALA_EXTERN void widgets_workspace_manager_remove_workspace (WidgetsWorkspaceManager* self,
                                                 gint index);
VALA_EXTERN void widgets_config_window_quit (WidgetsConfigWindow* self);
VALA_EXTERN gboolean widgets_workspace_manager_has_active_term (WidgetsWorkspaceManager* self);
VALA_EXTERN gboolean widgets_workspace_has_active_term (WidgetsWorkspace* self);
static void widgets_workspace_manager_finalize (GObject * obj);
static GType widgets_workspace_manager_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
widgets_workspace_manager_get_instance_private (WidgetsWorkspaceManager* self)
{
	return G_STRUCT_MEMBER_P (self, WidgetsWorkspaceManager_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

WidgetsWorkspaceManager*
widgets_workspace_manager_construct (GType object_type,
                                     WidgetsTabbar* t,
                                     const gchar* work_directory)
{
	WidgetsWorkspaceManager * self = NULL;
	WidgetsTabbar* _tmp0_;
	GeeHashMap* _tmp1_;
	g_return_val_if_fail (t != NULL, NULL);
	self = (WidgetsWorkspaceManager*) g_object_new (object_type, NULL);
	bindtextdomain (GETTEXT_PACKAGE, "/usr/share/locale");
	_tmp0_ = _g_object_ref0 (t);
	_g_object_unref0 (self->tabbar);
	self->tabbar = _tmp0_;
	self->workspace_index = 0;
	_tmp1_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, WIDGETS_TYPE_WORKSPACE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->workspace_map);
	self->workspace_map = _tmp1_;
	self->priv->has_first_term_created = FALSE;
	widgets_workspace_manager_new_workspace (self, work_directory, FALSE);
	return self;
}

WidgetsWorkspaceManager*
widgets_workspace_manager_new (WidgetsTabbar* t,
                               const gchar* work_directory)
{
	return widgets_workspace_manager_construct (WIDGETS_TYPE_WORKSPACE_MANAGER, t, work_directory);
}

void
widgets_workspace_manager_set_first_term (WidgetsWorkspaceManager* self,
                                          WidgetsTerm* term)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (term != NULL);
	if (!self->priv->has_first_term_created) {
		WidgetsTerm* _tmp0_;
		_tmp0_ = _g_object_ref0 (term);
		_g_object_unref0 (self->priv->first_term);
		self->priv->first_term = _tmp0_;
		self->priv->has_first_term_created = TRUE;
	}
}

gboolean
widgets_workspace_manager_is_first_term (WidgetsWorkspaceManager* self,
                                         WidgetsTerm* term)
{
	WidgetsTerm* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (term != NULL, FALSE);
	_tmp0_ = self->priv->first_term;
	if (_tmp0_ == NULL) {
		result = TRUE;
		return result;
	} else {
		WidgetsTerm* _tmp1_;
		_tmp1_ = self->priv->first_term;
		result = _tmp1_ == term;
		return result;
	}
}

void
widgets_workspace_manager_pack_workspace (WidgetsWorkspaceManager* self,
                                          WidgetsWorkspace* workspace)
{
	WidgetsWorkspace* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (workspace != NULL);
	_tmp0_ = _g_object_ref0 (workspace);
	_g_object_unref0 (self->focus_workspace);
	self->focus_workspace = _tmp0_;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) workspace, TRUE, TRUE, (guint) 0);
	widgets_workspace_select_focus_terminal (workspace);
}

void
widgets_workspace_manager_new_workspace_with_current_directory (WidgetsWorkspaceManager* self,
                                                                gboolean remote_serve_action)
{
	WidgetsTerm* focus_term = NULL;
	WidgetsWorkspace* _tmp0_;
	WidgetsTerm* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->focus_workspace;
	_tmp1_ = widgets_workspace_get_focus_term (_tmp0_, (GtkContainer*) self);
	focus_term = _tmp1_;
	_tmp2_ = widgets_term_get_cwd (focus_term);
	_tmp3_ = _tmp2_;
	widgets_workspace_manager_new_workspace (self, _tmp3_, remote_serve_action);
	_g_free0 (_tmp3_);
	_g_object_unref0 (focus_term);
}

static void
___lambda87_ (WidgetsWorkspaceManager* self,
              WidgetsWorkspace* workspace,
              gint index,
              const gchar* dir)
{
	WidgetsTabbar* _tmp0_;
	g_return_if_fail (workspace != NULL);
	g_return_if_fail (dir != NULL);
	_tmp0_ = self->tabbar;
	widgets_tabbar_rename_tab (_tmp0_, index, dir);
}

static void
____lambda87__widgets_workspace_change_title (WidgetsWorkspace* _sender,
                                              gint index,
                                              const gchar* dir,
                                              gpointer self)
{
	___lambda87_ ((WidgetsWorkspaceManager*) self, _sender, index, dir);
}

static void
___lambda88_ (WidgetsWorkspaceManager* self,
              WidgetsWorkspace* workspace,
              gint index)
{
	WidgetsTabbar* _tmp0_;
	g_return_if_fail (workspace != NULL);
	_tmp0_ = self->tabbar;
	widgets_tabbar_highlight_tab (_tmp0_, index);
}

static void
____lambda88__widgets_workspace_highlight_tab (WidgetsWorkspace* _sender,
                                               gint index,
                                               gpointer self)
{
	___lambda88_ ((WidgetsWorkspaceManager*) self, _sender, index);
}

static void
___lambda89_ (WidgetsWorkspaceManager* self,
              WidgetsWorkspace* workspace,
              gint index)
{
	WidgetsTabbar* _tmp0_;
	g_return_if_fail (workspace != NULL);
	_tmp0_ = self->tabbar;
	widgets_tabbar_close_current_tab (_tmp0_);
}

static void
____lambda89__widgets_workspace_exit (WidgetsWorkspace* _sender,
                                      gint index,
                                      gpointer self)
{
	___lambda89_ ((WidgetsWorkspaceManager*) self, _sender, index);
}

void
widgets_workspace_manager_new_workspace (WidgetsWorkspaceManager* self,
                                         const gchar* work_directory,
                                         gboolean remote_serve_action)
{
	gboolean _tmp0_ = FALSE;
	WidgetsTabbar* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->tabbar;
	if (_tmp1_->allowed_add_tab) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = remote_serve_action;
	}
	if (_tmp0_) {
		gint _tmp2_;
		WidgetsTabbar* _tmp3_;
		WidgetsWorkspace* workspace = NULL;
		WidgetsWorkspace* _tmp4_;
		GeeHashMap* _tmp5_;
		WidgetsWorkspace* _tmp6_;
		WidgetsWorkspace* _tmp7_;
		WidgetsWorkspace* _tmp8_;
		WidgetsWorkspace* _tmp9_;
		WidgetsWorkspace* _tmp10_;
		WidgetsTabbar* _tmp11_;
		utils_remove_all_children ((GtkContainer*) self);
		_tmp2_ = self->workspace_index;
		self->workspace_index = _tmp2_ + 1;
		_tmp3_ = self->tabbar;
		widgets_tabbar_add_tab (_tmp3_, "", self->workspace_index);
		_tmp4_ = widgets_workspace_new (self->workspace_index, work_directory, self);
		g_object_ref_sink (_tmp4_);
		workspace = _tmp4_;
		_tmp5_ = self->workspace_map;
		_tmp6_ = workspace;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp5_, (gpointer) ((gintptr) self->workspace_index), _tmp6_);
		_tmp7_ = workspace;
		g_signal_connect_object (_tmp7_, "change-title", (GCallback) ____lambda87__widgets_workspace_change_title, self, 0);
		_tmp8_ = workspace;
		g_signal_connect_object (_tmp8_, "highlight-tab", (GCallback) ____lambda88__widgets_workspace_highlight_tab, self, 0);
		_tmp9_ = workspace;
		g_signal_connect_object (_tmp9_, "exit", (GCallback) ____lambda89__widgets_workspace_exit, self, 0);
		_tmp10_ = workspace;
		widgets_workspace_manager_pack_workspace (self, _tmp10_);
		_tmp11_ = self->tabbar;
		widgets_tabbar_select_tab_with_id (_tmp11_, self->workspace_index);
		gtk_widget_show_all ((GtkWidget*) self);
		_g_object_unref0 (workspace);
	} else {
		WidgetsConfigWindow* config_window = NULL;
		GtkWidget* _tmp12_;
		WidgetsConfigWindow* _tmp13_;
		WidgetsConfigWindow* _tmp14_;
		_tmp12_ = gtk_widget_get_toplevel ((GtkWidget*) self);
		_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindow));
		config_window = _tmp13_;
		_tmp14_ = config_window;
		if (!_tmp14_->quake_mode) {
			{
				GAppInfo* appinfo = NULL;
				GAppInfo* _tmp24_;
				if (work_directory != NULL) {
					GAppInfo* _tmp15_ = NULL;
					gchar* _tmp16_;
					gchar* _tmp17_;
					GAppInfo* _tmp18_;
					GAppInfo* _tmp19_;
					GAppInfo* _tmp20_;
					_tmp16_ = g_strdup_printf ("deepin-terminal-gtk --work-directory=%s", work_directory);
					_tmp17_ = _tmp16_;
					_tmp18_ = g_app_info_create_from_commandline (_tmp17_, NULL, G_APP_INFO_CREATE_NONE, &_inner_error0_);
					_tmp19_ = _tmp18_;
					_g_free0 (_tmp17_);
					_tmp15_ = _tmp19_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (appinfo);
						goto __catch0_g_error;
					}
					_tmp20_ = _tmp15_;
					_tmp15_ = NULL;
					_g_object_unref0 (appinfo);
					appinfo = _tmp20_;
					_g_object_unref0 (_tmp15_);
				} else {
					GAppInfo* _tmp21_ = NULL;
					GAppInfo* _tmp22_;
					GAppInfo* _tmp23_;
					_tmp22_ = g_app_info_create_from_commandline ("deepin-terminal-gtk", NULL, G_APP_INFO_CREATE_NONE, &_inner_error0_);
					_tmp21_ = _tmp22_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (appinfo);
						goto __catch0_g_error;
					}
					_tmp23_ = _tmp21_;
					_tmp21_ = NULL;
					_g_object_unref0 (appinfo);
					appinfo = _tmp23_;
					_g_object_unref0 (_tmp21_);
				}
				_tmp24_ = appinfo;
				g_app_info_launch (_tmp24_, NULL, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (appinfo);
					goto __catch0_g_error;
				}
				_g_object_unref0 (appinfo);
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp25_;
				const gchar* _tmp26_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp25_ = e;
				_tmp26_ = _tmp25_->message;
				g_print ("new_workspace: %s\n", _tmp26_);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (config_window);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_g_object_unref0 (config_window);
	}
}

void
widgets_workspace_manager_switch_workspace_with_index (WidgetsWorkspaceManager* self,
                                                       gint index)
{
	g_return_if_fail (self != NULL);
	if (index == 1) {
		WidgetsTabbar* _tmp0_;
		_tmp0_ = self->tabbar;
		widgets_tabbar_select_first_tab (_tmp0_);
	} else {
		if (index == 9) {
			WidgetsTabbar* _tmp1_;
			_tmp1_ = self->tabbar;
			widgets_tabbar_select_end_tab (_tmp1_);
		} else {
			gboolean _tmp2_ = FALSE;
			if (index > 0) {
				WidgetsTabbar* _tmp3_;
				GeeArrayList* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				_tmp3_ = self->tabbar;
				_tmp4_ = _tmp3_->tab_list;
				_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
				_tmp6_ = _tmp5_;
				_tmp2_ = index <= _tmp6_;
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				WidgetsTabbar* _tmp7_;
				_tmp7_ = self->tabbar;
				widgets_tabbar_select_nth_tab (_tmp7_, index - 1);
			}
		}
	}
}

void
widgets_workspace_manager_switch_workspace (WidgetsWorkspaceManager* self,
                                            gint workspace_index)
{
	WidgetsWorkspace* workspace = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	g_return_if_fail (self != NULL);
	utils_remove_all_children ((GtkContainer*) self);
	_tmp0_ = self->workspace_map;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, (gpointer) ((gintptr) workspace_index));
	workspace = (WidgetsWorkspace*) _tmp1_;
	widgets_workspace_manager_pack_workspace (self, workspace);
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (workspace);
}

void
widgets_workspace_manager_remove_workspace (WidgetsWorkspaceManager* self,
                                            gint index)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	WidgetsWorkspace* _tmp2_;
	GeeHashMap* _tmp3_;
	WidgetsTabbar* _tmp4_;
	GeeArrayList* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->workspace_map;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, (gpointer) ((gintptr) index));
	_tmp2_ = (WidgetsWorkspace*) _tmp1_;
	gtk_widget_destroy ((GtkWidget*) _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = self->workspace_map;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp3_, (gpointer) ((gintptr) index), NULL);
	_tmp4_ = self->tabbar;
	_tmp5_ = _tmp4_->tab_list;
	_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == 0) {
		WidgetsConfigWindow* config_window = NULL;
		GtkWidget* _tmp8_;
		WidgetsConfigWindow* _tmp9_;
		WidgetsConfigWindow* _tmp10_;
		_tmp8_ = gtk_widget_get_toplevel ((GtkWidget*) self);
		_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindow));
		config_window = _tmp9_;
		_tmp10_ = config_window;
		widgets_config_window_quit (_tmp10_);
		_g_object_unref0 (config_window);
	} else {
		gint workspace_index = 0;
		WidgetsTabbar* _tmp11_;
		GeeArrayList* _tmp12_;
		WidgetsTabbar* _tmp13_;
		gpointer _tmp14_;
		WidgetsWorkspace* workspace = NULL;
		GeeHashMap* _tmp15_;
		gpointer _tmp16_;
		WidgetsWorkspace* _tmp17_;
		_tmp11_ = self->tabbar;
		_tmp12_ = _tmp11_->tab_list;
		_tmp13_ = self->tabbar;
		_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp13_->tab_index);
		workspace_index = (gint) ((gintptr) _tmp14_);
		utils_remove_all_children ((GtkContainer*) self);
		_tmp15_ = self->workspace_map;
		_tmp16_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp15_, (gpointer) ((gintptr) workspace_index));
		workspace = (WidgetsWorkspace*) _tmp16_;
		_tmp17_ = workspace;
		widgets_workspace_manager_pack_workspace (self, _tmp17_);
		gtk_widget_show_all ((GtkWidget*) self);
		_g_object_unref0 (workspace);
	}
}

gboolean
widgets_workspace_manager_has_active_term (WidgetsWorkspaceManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GeeIterator* _workspace_entry_it = NULL;
		GeeHashMap* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = self->workspace_map;
		_tmp1_ = gee_abstract_map_get_entries ((GeeAbstractMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_workspace_entry_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			GeeMapEntry* workspace_entry = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			GeeMapEntry* _tmp9_;
			gconstpointer _tmp10_;
			gconstpointer _tmp11_;
			_tmp6_ = _workspace_entry_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _workspace_entry_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			workspace_entry = (GeeMapEntry*) _tmp8_;
			_tmp9_ = workspace_entry;
			_tmp10_ = gee_map_entry_get_value (_tmp9_);
			_tmp11_ = _tmp10_;
			if (widgets_workspace_has_active_term ((WidgetsWorkspace*) _tmp11_)) {
				result = TRUE;
				_g_object_unref0 (workspace_entry);
				_g_object_unref0 (_workspace_entry_it);
				return result;
			}
			_g_object_unref0 (workspace_entry);
		}
		_g_object_unref0 (_workspace_entry_it);
	}
	result = FALSE;
	return result;
}

static void
widgets_workspace_manager_class_init (WidgetsWorkspaceManagerClass * klass,
                                      gpointer klass_data)
{
	widgets_workspace_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &WidgetsWorkspaceManager_private_offset);
	G_OBJECT_CLASS (klass)->finalize = widgets_workspace_manager_finalize;
}

static void
widgets_workspace_manager_instance_init (WidgetsWorkspaceManager * self,
                                         gpointer klass)
{
	self->priv = widgets_workspace_manager_get_instance_private (self);
}

static void
widgets_workspace_manager_finalize (GObject * obj)
{
	WidgetsWorkspaceManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WIDGETS_TYPE_WORKSPACE_MANAGER, WidgetsWorkspaceManager);
	_g_object_unref0 (self->priv->first_term);
	_g_object_unref0 (self->workspace_map);
	_g_object_unref0 (self->tabbar);
	_g_object_unref0 (self->focus_workspace);
	G_OBJECT_CLASS (widgets_workspace_manager_parent_class)->finalize (obj);
}

static GType
widgets_workspace_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WidgetsWorkspaceManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) widgets_workspace_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WidgetsWorkspaceManager), 0, (GInstanceInitFunc) widgets_workspace_manager_instance_init, NULL };
	GType widgets_workspace_manager_type_id;
	widgets_workspace_manager_type_id = g_type_register_static (gtk_box_get_type (), "WidgetsWorkspaceManager", &g_define_type_info, 0);
	WidgetsWorkspaceManager_private_offset = g_type_add_instance_private (widgets_workspace_manager_type_id, sizeof (WidgetsWorkspaceManagerPrivate));
	return widgets_workspace_manager_type_id;
}

GType
widgets_workspace_manager_get_type (void)
{
	static volatile gsize widgets_workspace_manager_type_id__once = 0;
	if (g_once_init_enter (&widgets_workspace_manager_type_id__once)) {
		GType widgets_workspace_manager_type_id;
		widgets_workspace_manager_type_id = widgets_workspace_manager_get_type_once ();
		g_once_init_leave (&widgets_workspace_manager_type_id__once, widgets_workspace_manager_type_id);
	}
	return widgets_workspace_manager_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

