/* BackendRclone.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from BackendRclone.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */

#include "deja.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <libsecret/secret.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	DEJA_DUP_BACKEND_RCLONE_0_PROPERTY,
	DEJA_DUP_BACKEND_RCLONE_NUM_PROPERTIES
};
static GParamSpec* deja_dup_backend_rclone_properties[DEJA_DUP_BACKEND_RCLONE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _DejaDupBackendRcloneIsReadyData DejaDupBackendRcloneIsReadyData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _DejaDupBackendRcloneIsRcloneConfigEncryptedData DejaDupBackendRcloneIsRcloneConfigEncryptedData;
typedef struct _DejaDupBackendRcloneIsRcloneConfigPasswordValidData DejaDupBackendRcloneIsRcloneConfigPasswordValidData;
typedef struct _DejaDupBackendRcloneIsRemoteValidData DejaDupBackendRcloneIsRemoteValidData;
#define _secret_schema_unref0(var) ((var == NULL) ? NULL : (var = (secret_schema_unref (var), NULL)))
typedef struct _DejaDupBackendRcloneLookupConfigPasswordData DejaDupBackendRcloneLookupConfigPasswordData;
typedef struct _DejaDupBackendRcloneStoreConfigPasswordData DejaDupBackendRcloneStoreConfigPasswordData;
typedef struct _DejaDupBackendRcloneClearConfigPasswordData DejaDupBackendRcloneClearConfigPasswordData;
typedef struct _DejaDupBackendRclonePrepareData DejaDupBackendRclonePrepareData;
typedef struct _DejaDupBackendRcloneProvideBackendPasswordData DejaDupBackendRcloneProvideBackendPasswordData;
typedef struct _DejaDupBackendRcloneGetSpaceData DejaDupBackendRcloneGetSpaceData;
typedef struct _DejaDupBackendRclonePeekAtFilesData DejaDupBackendRclonePeekAtFilesData;

struct _DejaDupBackendRclonePrivate {
	GSourceFunc config_password_callback;
	gpointer config_password_callback_target;
	GDestroyNotify config_password_callback_target_destroy_notify;
	gchar* config_password;
};

struct _DejaDupBackendRcloneIsReadyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackendRclone* self;
	gchar* reason;
	gchar* message;
	gboolean result;
	gchar* _tmp0_;
	gchar* _tmp1_;
	DejaDupNetwork* _tmp2_;
	DejaDupNetwork* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
};

struct _DejaDupBackendRcloneIsRcloneConfigEncryptedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackendRclone* self;
	gboolean result;
	GSubprocess* rclone;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	GSubprocess* _tmp5_;
	GSubprocess* _tmp6_;
	GSubprocess* _tmp7_;
	GSubprocess* _tmp8_;
	GError* err;
	GError* _tmp9_;
	const gchar* _tmp10_;
	gboolean _tmp11_;
	GSubprocess* _tmp12_;
	GSubprocess* _tmp13_;
	GError* _inner_error0_;
};

struct _DejaDupBackendRcloneIsRcloneConfigPasswordValidData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackendRclone* self;
	gboolean result;
	const gchar* _tmp0_;
	GSubprocess* rclone;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	GSubprocess* _tmp6_;
	GSubprocess* _tmp7_;
	GSubprocess* _tmp8_;
	GSubprocess* _tmp9_;
	GError* err;
	GError* _tmp10_;
	const gchar* _tmp11_;
	gboolean _tmp12_;
	GSubprocess* _tmp13_;
	GSubprocess* _tmp14_;
	GError* _inner_error0_;
};

struct _DejaDupBackendRcloneIsRemoteValidData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackendRclone* self;
	gboolean result;
	gchar* remote;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GSubprocess* rclone;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	GSubprocess* _tmp8_;
	GSubprocess* _tmp9_;
	GSubprocess* _tmp10_;
	GInputStream* stdout_raw;
	GSubprocess* _tmp11_;
	GInputStream* _tmp12_;
	GInputStream* _tmp13_;
	GDataInputStream* stdout;
	GInputStream* _tmp14_;
	GDataInputStream* _tmp15_;
	gboolean found_it;
	gchar* line;
	GDataInputStream* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	GError* err;
	GError* _tmp21_;
	const gchar* _tmp22_;
	GSubprocess* _tmp23_;
	GError* _inner_error0_;
};

struct _DejaDupBackendRcloneLookupConfigPasswordData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackendRclone* self;
	gchar* result;
	SecretSchema* schema;
	SecretSchema* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GError* _inner_error0_;
};

struct _DejaDupBackendRcloneStoreConfigPasswordData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackendRclone* self;
	SecretSchema* schema;
	SecretSchema* _tmp0_;
	const gchar* _tmp1_;
	GError* e;
	GError* _tmp2_;
	const gchar* _tmp3_;
	GError* _inner_error0_;
};

struct _DejaDupBackendRcloneClearConfigPasswordData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackendRclone* self;
	SecretSchema* schema;
	SecretSchema* _tmp0_;
	DejaDupBackendWatcher* _tmp1_;
	DejaDupBackendWatcher* _tmp2_;
	GError* _inner_error0_;
};

struct _DejaDupBackendRclonePrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackendRclone* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean repeat;
	const gchar* _tmp2_;
	gchar* msg;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	GError* _tmp8_;
	GError* _inner_error0_;
};

struct _DejaDupBackendRcloneProvideBackendPasswordData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackendRclone* self;
	gchar* password;
	gboolean save;
	gchar* _tmp0_;
	GSourceFunc _tmp1_;
	gpointer _tmp1__target;
	GSourceFunc _tmp2_;
	gpointer _tmp2__target;
};

struct _DejaDupBackendRcloneGetSpaceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackendRclone* self;
	guint64 free;
	guint64 total;
	guint64 _tmp0_;
	guint64 _tmp1_;
};

struct _DejaDupBackendRclonePeekAtFilesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackendRclone* self;
	GList* result;
	GList* _tmp0_;
};

static gint DejaDupBackendRclone_private_offset;
static gpointer deja_dup_backend_rclone_parent_class = NULL;

static gboolean deja_dup_backend_rclone_real_is_native (DejaDupBackend* base);
static gchar** deja_dup_backend_rclone_real_get_dependencies (DejaDupBackend* base,
                                                       gint* result_length1);
static GIcon* deja_dup_backend_rclone_real_get_icon (DejaDupBackend* base);
static void deja_dup_backend_rclone_real_is_ready_data_free (gpointer _data);
static void deja_dup_backend_rclone_real_is_ready (DejaDupBackend* base,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
static gboolean deja_dup_backend_rclone_real_is_ready_co (DejaDupBackendRcloneIsReadyData* _data_);
static gchar* deja_dup_backend_rclone_get_remote (DejaDupBackendRclone* self);
static gchar* deja_dup_backend_rclone_get_folder (DejaDupBackendRclone* self);
static gchar* deja_dup_backend_rclone_real_get_location_pretty (DejaDupBackend* base);
static gchar* deja_dup_backend_rclone_real_get_unique_location (DejaDupBackend* base);
static gboolean deja_dup_backend_rclone_real_is_acceptable (DejaDupBackend* base,
                                                     gchar** reason);
static void deja_dup_backend_rclone_is_rclone_config_encrypted_data_free (gpointer _data);
static void deja_dup_backend_rclone_is_rclone_config_encrypted (DejaDupBackendRclone* self,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_);
static gboolean deja_dup_backend_rclone_is_rclone_config_encrypted_finish (DejaDupBackendRclone* self,
                                                                    GAsyncResult* _res_);
static gboolean deja_dup_backend_rclone_is_rclone_config_encrypted_co (DejaDupBackendRcloneIsRcloneConfigEncryptedData* _data_);
VALA_EXTERN void rclone_run (gchar** argv,
                 gint argv_length1,
                 DejaDupBackend* backend,
                 gboolean add_target,
                 GAsyncReadyCallback _callback_,
                 gpointer _user_data_);
VALA_EXTERN GSubprocess* rclone_run_finish (GAsyncResult* _res_);
static void deja_dup_backend_rclone_is_rclone_config_encrypted_ready (GObject* source_object,
                                                               GAsyncResult* _res_,
                                                               gpointer _user_data_);
static void deja_dup_backend_rclone_is_rclone_config_password_valid_data_free (gpointer _data);
static void deja_dup_backend_rclone_is_rclone_config_password_valid (DejaDupBackendRclone* self,
                                                              GAsyncReadyCallback _callback_,
                                                              gpointer _user_data_);
static gboolean deja_dup_backend_rclone_is_rclone_config_password_valid_finish (DejaDupBackendRclone* self,
                                                                         GAsyncResult* _res_);
static gboolean deja_dup_backend_rclone_is_rclone_config_password_valid_co (DejaDupBackendRcloneIsRcloneConfigPasswordValidData* _data_);
static void deja_dup_backend_rclone_is_rclone_config_password_valid_ready (GObject* source_object,
                                                                    GAsyncResult* _res_,
                                                                    gpointer _user_data_);
static void deja_dup_backend_rclone_is_remote_valid_data_free (gpointer _data);
static void deja_dup_backend_rclone_is_remote_valid (DejaDupBackendRclone* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static gboolean deja_dup_backend_rclone_is_remote_valid_finish (DejaDupBackendRclone* self,
                                                         GAsyncResult* _res_);
static gboolean deja_dup_backend_rclone_is_remote_valid_co (DejaDupBackendRcloneIsRemoteValidData* _data_);
static void deja_dup_backend_rclone_is_remote_valid_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static SecretSchema* deja_dup_backend_rclone_get_secret_schema (DejaDupBackendRclone* self);
static void deja_dup_backend_rclone_lookup_config_password_data_free (gpointer _data);
static gboolean deja_dup_backend_rclone_lookup_config_password_co (DejaDupBackendRcloneLookupConfigPasswordData* _data_);
static void deja_dup_backend_rclone_store_config_password_data_free (gpointer _data);
static void deja_dup_backend_rclone_store_config_password (DejaDupBackendRclone* self,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
static void deja_dup_backend_rclone_store_config_password_finish (DejaDupBackendRclone* self,
                                                           GAsyncResult* _res_);
static gboolean deja_dup_backend_rclone_store_config_password_co (DejaDupBackendRcloneStoreConfigPasswordData* _data_);
static void deja_dup_backend_rclone_clear_config_password_data_free (gpointer _data);
static gboolean deja_dup_backend_rclone_clear_config_password_co (DejaDupBackendRcloneClearConfigPasswordData* _data_);
static void deja_dup_backend_rclone_real_prepare_data_free (gpointer _data);
static void deja_dup_backend_rclone_real_prepare (DejaDupBackend* base,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static gboolean deja_dup_backend_rclone_real_prepare_co (DejaDupBackendRclonePrepareData* _data_);
static void deja_dup_backend_rclone_prepare_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static gboolean _deja_dup_backend_rclone_real_prepare_co_gsource_func (gpointer self);
static void deja_dup_backend_rclone_real_provide_backend_password_data_free (gpointer _data);
static void deja_dup_backend_rclone_real_provide_backend_password (DejaDupBackend* base,
                                                            const gchar* password,
                                                            gboolean save,
                                                            GAsyncReadyCallback _callback_,
                                                            gpointer _user_data_);
static gboolean deja_dup_backend_rclone_real_provide_backend_password_co (DejaDupBackendRcloneProvideBackendPasswordData* _data_);
static void deja_dup_backend_rclone_provide_backend_password_ready (GObject* source_object,
                                                             GAsyncResult* _res_,
                                                             gpointer _user_data_);
static void deja_dup_backend_rclone_real_get_space_data_free (gpointer _data);
static void deja_dup_backend_rclone_real_get_space (DejaDupBackend* base,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
static gboolean deja_dup_backend_rclone_real_get_space_co (DejaDupBackendRcloneGetSpaceData* _data_);
VALA_EXTERN void rclone_get_space (DejaDupBackend* backend,
                       GAsyncReadyCallback _callback_,
                       gpointer _user_data_);
VALA_EXTERN void rclone_get_space_finish (GAsyncResult* _res_,
                              guint64* free,
                              guint64* total);
static void deja_dup_backend_rclone_get_space_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
static void deja_dup_backend_rclone_real_peek_at_files_data_free (gpointer _data);
static void deja_dup_backend_rclone_real_peek_at_files (DejaDupBackend* base,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
static gboolean deja_dup_backend_rclone_real_peek_at_files_co (DejaDupBackendRclonePeekAtFilesData* _data_);
VALA_EXTERN void rclone_list_files (DejaDupBackend* backend,
                        gint max,
                        GAsyncReadyCallback _callback_,
                        gpointer _user_data_);
VALA_EXTERN GList* rclone_list_files_finish (GAsyncResult* _res_);
static void deja_dup_backend_rclone_peek_at_files_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_);
static void deja_dup_backend_rclone_finalize (GObject * obj);
static GType deja_dup_backend_rclone_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
deja_dup_backend_rclone_get_instance_private (DejaDupBackendRclone* self)
{
	return G_STRUCT_MEMBER_P (self, DejaDupBackendRclone_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

DejaDupBackendRclone*
deja_dup_backend_rclone_construct (GType object_type,
                                   GSettings* settings)
{
	DejaDupBackendRclone * self = NULL;
	GSettings* _tmp0_ = NULL;
	if (settings != NULL) {
		GSettings* _tmp1_;
		_tmp1_ = _g_object_ref0 (settings);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		DejaDupFilteredSettings* _tmp2_;
		_tmp2_ = deja_dup_get_settings (DEJA_DUP_RCLONE_ROOT);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = (GSettings*) _tmp2_;
	}
	self = (DejaDupBackendRclone*) g_object_new (object_type, "kind", DEJA_DUP_BACKEND_KIND_RCLONE, "settings", _tmp0_, NULL);
	_g_object_unref0 (_tmp0_);
	return self;
}

DejaDupBackendRclone*
deja_dup_backend_rclone_new (GSettings* settings)
{
	return deja_dup_backend_rclone_construct (DEJA_DUP_TYPE_BACKEND_RCLONE, settings);
}

static gboolean
deja_dup_backend_rclone_real_is_native (DejaDupBackend* base)
{
	DejaDupBackendRclone * self;
	gboolean result;
	self = (DejaDupBackendRclone*) base;
	result = FALSE;
	return result;
}

static gchar**
deja_dup_backend_rclone_real_get_dependencies (DejaDupBackend* base,
                                               gint* result_length1)
{
	DejaDupBackendRclone * self;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** result;
	self = (DejaDupBackendRclone*) base;
	_tmp1_ = _tmp0_ = g_strsplit (RCLONE_PACKAGES, ",", 0);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _vala_array_length (_tmp0_);
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static GIcon*
deja_dup_backend_rclone_real_get_icon (DejaDupBackend* base)
{
	DejaDupBackendRclone * self;
	GThemedIcon* _tmp0_;
	GIcon* result;
	self = (DejaDupBackendRclone*) base;
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("deja-dup-rclone");
	result = (GIcon*) _tmp0_;
	return result;
}

static void
deja_dup_backend_rclone_real_is_ready_data_free (gpointer _data)
{
	DejaDupBackendRcloneIsReadyData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendRcloneIsReadyData, _data_);
}

static void
deja_dup_backend_rclone_real_is_ready (DejaDupBackend* base,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	DejaDupBackendRclone * self;
	DejaDupBackendRcloneIsReadyData* _data_;
	DejaDupBackendRclone* _tmp0_;
	self = (DejaDupBackendRclone*) base;
	_data_ = g_slice_new0 (DejaDupBackendRcloneIsReadyData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_backend_rclone_real_is_ready_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_rclone_real_is_ready_co (_data_);
}

static gboolean
deja_dup_backend_rclone_is_ready_finish (DejaDupBackend* base,
                                         GAsyncResult* _res_,
                                         gchar** reason,
                                         gchar** message)
{
	gboolean result;
	DejaDupBackendRcloneIsReadyData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (reason) {
		*reason = _data_->reason;
	} else {
		_g_free0 (_data_->reason);
	}
	_data_->reason = NULL;
	if (message) {
		*message = _data_->message;
	} else {
		_g_free0 (_data_->message);
	}
	_data_->message = NULL;
	result = _data_->result;
	return result;
}

static gboolean
deja_dup_backend_rclone_real_is_ready_co (DejaDupBackendRcloneIsReadyData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_strdup ("rclone-reachable");
	_g_free0 (_data_->reason);
	_data_->reason = _data_->_tmp0_;
	_data_->_tmp1_ = g_strdup (_ ("Backup will begin when a network connection becomes available."));
	_g_free0 (_data_->message);
	_data_->message = _data_->_tmp1_;
	_data_->_tmp2_ = deja_dup_network_get ();
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = deja_dup_network_get_connected (_data_->_tmp3_);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = _data_->_tmp5_;
	_g_object_unref0 (_data_->_tmp3_);
	_data_->result = _data_->_tmp6_;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
deja_dup_backend_rclone_get_remote (DejaDupBackendRclone* self)
{
	gchar* remote = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = deja_dup_backend_get_settings ((DejaDupBackend*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_settings_get_string (_tmp1_, DEJA_DUP_RCLONE_REMOTE_KEY);
	remote = _tmp2_;
	_tmp3_ = remote;
	if (g_str_has_suffix (_tmp3_, ":")) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gchar* _tmp8_;
		_tmp4_ = remote;
		_tmp5_ = remote;
		_tmp6_ = strlen (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = string_substring (_tmp4_, (glong) 0, (glong) (_tmp7_ - 1));
		result = _tmp8_;
		_g_free0 (remote);
		return result;
	}
	result = remote;
	return result;
}

static gchar*
deja_dup_backend_rclone_get_folder (DejaDupBackendRclone* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = deja_dup_backend_get_settings ((DejaDupBackend*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = deja_dup_get_folder_key (_tmp1_, DEJA_DUP_RCLONE_FOLDER_KEY, TRUE);
	result = _tmp2_;
	return result;
}

static gchar*
deja_dup_backend_rclone_real_get_location_pretty (DejaDupBackend* base)
{
	DejaDupBackendRclone * self;
	gchar* remote = NULL;
	gchar* _tmp0_;
	gchar* folder = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* result;
	self = (DejaDupBackendRclone*) base;
	_tmp0_ = deja_dup_backend_rclone_get_remote (self);
	remote = _tmp0_;
	_tmp1_ = deja_dup_backend_rclone_get_folder (self);
	folder = _tmp1_;
	_tmp2_ = remote;
	if (g_strcmp0 (_tmp2_, "") == 0) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup (_ ("Rclone"));
		result = _tmp3_;
		_g_free0 (folder);
		_g_free0 (remote);
		return result;
	} else {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp4_ = remote;
		_tmp5_ = folder;
		_tmp6_ = g_strdup_printf ("%s:%s", _tmp4_, _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup_printf (_ ("%s with Rclone"), _tmp7_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		result = _tmp9_;
		_g_free0 (folder);
		_g_free0 (remote);
		return result;
	}
}

static gchar*
deja_dup_backend_rclone_real_get_unique_location (DejaDupBackend* base)
{
	DejaDupBackendRclone * self;
	gchar* remote = NULL;
	gchar* _tmp0_;
	gchar* folder = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	self = (DejaDupBackendRclone*) base;
	_tmp0_ = deja_dup_backend_rclone_get_remote (self);
	remote = _tmp0_;
	_tmp1_ = deja_dup_backend_rclone_get_folder (self);
	folder = _tmp1_;
	_tmp2_ = g_strdup_printf ("rclone:%s:%s", remote, folder);
	result = _tmp2_;
	_g_free0 (folder);
	_g_free0 (remote);
	return result;
}

static gboolean
deja_dup_backend_rclone_real_is_acceptable (DejaDupBackend* base,
                                            gchar** reason)
{
	DejaDupBackendRclone * self;
	gchar* _vala_reason = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	self = (DejaDupBackendRclone*) base;
	_g_free0 (_vala_reason);
	_vala_reason = NULL;
	_tmp0_ = deja_dup_backend_rclone_get_remote (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strcmp0 (_tmp1_, "") == 0;
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup (_ ("An Rclone remote needs to be set."));
		_g_free0 (_vala_reason);
		_vala_reason = _tmp3_;
		result = FALSE;
		if (reason) {
			*reason = _vala_reason;
		} else {
			_g_free0 (_vala_reason);
		}
		return result;
	}
	result = TRUE;
	if (reason) {
		*reason = _vala_reason;
	} else {
		_g_free0 (_vala_reason);
	}
	return result;
}

static void
deja_dup_backend_rclone_is_rclone_config_encrypted_data_free (gpointer _data)
{
	DejaDupBackendRcloneIsRcloneConfigEncryptedData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendRcloneIsRcloneConfigEncryptedData, _data_);
}

static void
deja_dup_backend_rclone_is_rclone_config_encrypted (DejaDupBackendRclone* self,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_)
{
	DejaDupBackendRcloneIsRcloneConfigEncryptedData* _data_;
	DejaDupBackendRclone* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (DejaDupBackendRcloneIsRcloneConfigEncryptedData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_backend_rclone_is_rclone_config_encrypted_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_rclone_is_rclone_config_encrypted_co (_data_);
}

static gboolean
deja_dup_backend_rclone_is_rclone_config_encrypted_finish (DejaDupBackendRclone* self,
                                                           GAsyncResult* _res_)
{
	gboolean result;
	DejaDupBackendRcloneIsRcloneConfigEncryptedData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
deja_dup_backend_rclone_is_rclone_config_encrypted_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_)
{
	DejaDupBackendRcloneIsRcloneConfigEncryptedData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_rclone_is_rclone_config_encrypted_co (_data_);
}

static gboolean
deja_dup_backend_rclone_is_rclone_config_encrypted_co (DejaDupBackendRcloneIsRcloneConfigEncryptedData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_strdup ("config");
	_data_->_tmp1_ = g_strdup ("encryption");
	_data_->_tmp2_ = g_strdup ("remove");
	_data_->_tmp3_ = g_new0 (gchar*, 3 + 1);
	_data_->_tmp3_[0] = _data_->_tmp0_;
	_data_->_tmp3_[1] = _data_->_tmp1_;
	_data_->_tmp3_[2] = _data_->_tmp2_;
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp4__length1 = 3;
	_data_->_state_ = 1;
	rclone_run (_data_->_tmp4_, (gint) 3, NULL, TRUE, deja_dup_backend_rclone_is_rclone_config_encrypted_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp5_ = rclone_run_finish (_data_->_res_);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp4_ = (_vala_array_free (_data_->_tmp4_, _data_->_tmp4__length1, (GDestroyNotify) g_free), NULL);
	_data_->rclone = _data_->_tmp6_;
	_data_->_tmp7_ = _data_->rclone;
	if (_data_->_tmp7_ == NULL) {
		_data_->result = FALSE;
		_g_object_unref0 (_data_->rclone);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp8_ = _data_->rclone;
		_data_->_state_ = 2;
		g_subprocess_wait_async (_data_->_tmp8_, NULL, deja_dup_backend_rclone_is_rclone_config_encrypted_ready, _data_);
		return FALSE;
		_state_2:
		g_subprocess_wait_finish (_data_->_tmp8_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp9_ = _data_->err;
		_data_->_tmp10_ = _data_->_tmp9_->message;
		g_warning ("BackendRclone.vala:105: Could not check if Rclone config is encrypted:" \
" %s", _data_->_tmp10_);
		_data_->result = FALSE;
		_g_error_free0 (_data_->err);
		_g_object_unref0 (_data_->rclone);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->rclone);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp12_ = _data_->rclone;
	if (g_subprocess_get_if_exited (_data_->_tmp12_)) {
		_data_->_tmp13_ = _data_->rclone;
		_data_->_tmp11_ = g_subprocess_get_exit_status (_data_->_tmp13_) != 0;
	} else {
		_data_->_tmp11_ = FALSE;
	}
	_data_->result = _data_->_tmp11_;
	_g_object_unref0 (_data_->rclone);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
deja_dup_backend_rclone_is_rclone_config_password_valid_data_free (gpointer _data)
{
	DejaDupBackendRcloneIsRcloneConfigPasswordValidData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendRcloneIsRcloneConfigPasswordValidData, _data_);
}

static void
deja_dup_backend_rclone_is_rclone_config_password_valid (DejaDupBackendRclone* self,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_)
{
	DejaDupBackendRcloneIsRcloneConfigPasswordValidData* _data_;
	DejaDupBackendRclone* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (DejaDupBackendRcloneIsRcloneConfigPasswordValidData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_backend_rclone_is_rclone_config_password_valid_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_rclone_is_rclone_config_password_valid_co (_data_);
}

static gboolean
deja_dup_backend_rclone_is_rclone_config_password_valid_finish (DejaDupBackendRclone* self,
                                                                GAsyncResult* _res_)
{
	gboolean result;
	DejaDupBackendRcloneIsRcloneConfigPasswordValidData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
deja_dup_backend_rclone_is_rclone_config_password_valid_ready (GObject* source_object,
                                                               GAsyncResult* _res_,
                                                               gpointer _user_data_)
{
	DejaDupBackendRcloneIsRcloneConfigPasswordValidData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_rclone_is_rclone_config_password_valid_co (_data_);
}

static gboolean
deja_dup_backend_rclone_is_rclone_config_password_valid_co (DejaDupBackendRcloneIsRcloneConfigPasswordValidData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->config_password;
	if (_data_->_tmp0_ == NULL) {
		_data_->result = FALSE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = g_strdup ("config");
	_data_->_tmp2_ = g_strdup ("encryption");
	_data_->_tmp3_ = g_strdup ("check");
	_data_->_tmp4_ = g_new0 (gchar*, 3 + 1);
	_data_->_tmp4_[0] = _data_->_tmp1_;
	_data_->_tmp4_[1] = _data_->_tmp2_;
	_data_->_tmp4_[2] = _data_->_tmp3_;
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp5__length1 = 3;
	_data_->_state_ = 1;
	rclone_run (_data_->_tmp5_, (gint) 3, (DejaDupBackend*) _data_->self, FALSE, deja_dup_backend_rclone_is_rclone_config_password_valid_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp6_ = rclone_run_finish (_data_->_res_);
	_data_->_tmp7_ = _data_->_tmp6_;
	_data_->_tmp5_ = (_vala_array_free (_data_->_tmp5_, _data_->_tmp5__length1, (GDestroyNotify) g_free), NULL);
	_data_->rclone = _data_->_tmp7_;
	_data_->_tmp8_ = _data_->rclone;
	if (_data_->_tmp8_ == NULL) {
		_data_->result = FALSE;
		_g_object_unref0 (_data_->rclone);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp9_ = _data_->rclone;
		_data_->_state_ = 2;
		g_subprocess_wait_async (_data_->_tmp9_, NULL, deja_dup_backend_rclone_is_rclone_config_password_valid_ready, _data_);
		return FALSE;
		_state_2:
		g_subprocess_wait_finish (_data_->_tmp9_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp10_ = _data_->err;
		_data_->_tmp11_ = _data_->_tmp10_->message;
		g_warning ("BackendRclone.vala:124: Could not check if Rclone password is valid: %" \
"s", _data_->_tmp11_);
		_data_->result = FALSE;
		_g_error_free0 (_data_->err);
		_g_object_unref0 (_data_->rclone);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->rclone);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp13_ = _data_->rclone;
	if (g_subprocess_get_if_exited (_data_->_tmp13_)) {
		_data_->_tmp14_ = _data_->rclone;
		_data_->_tmp12_ = g_subprocess_get_exit_status (_data_->_tmp14_) == 0;
	} else {
		_data_->_tmp12_ = FALSE;
	}
	_data_->result = _data_->_tmp12_;
	_g_object_unref0 (_data_->rclone);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
deja_dup_backend_rclone_is_remote_valid_data_free (gpointer _data)
{
	DejaDupBackendRcloneIsRemoteValidData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendRcloneIsRemoteValidData, _data_);
}

static void
deja_dup_backend_rclone_is_remote_valid (DejaDupBackendRclone* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	DejaDupBackendRcloneIsRemoteValidData* _data_;
	DejaDupBackendRclone* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (DejaDupBackendRcloneIsRemoteValidData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_backend_rclone_is_remote_valid_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_rclone_is_remote_valid_co (_data_);
}

static gboolean
deja_dup_backend_rclone_is_remote_valid_finish (DejaDupBackendRclone* self,
                                                GAsyncResult* _res_)
{
	gboolean result;
	DejaDupBackendRcloneIsRemoteValidData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static void
deja_dup_backend_rclone_is_remote_valid_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	DejaDupBackendRcloneIsRemoteValidData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_rclone_is_remote_valid_co (_data_);
}

static gboolean
deja_dup_backend_rclone_is_remote_valid_co (DejaDupBackendRcloneIsRemoteValidData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = deja_dup_backend_rclone_get_remote (_data_->self);
	_data_->remote = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->remote;
	if (g_strcmp0 (_data_->_tmp1_, "") == 0) {
		_data_->result = FALSE;
		_g_free0 (_data_->remote);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->remote;
	if (string_get (_data_->_tmp2_, (glong) 0) == ':') {
		_data_->result = TRUE;
		_g_free0 (_data_->remote);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->remote;
	_data_->_tmp4_ = g_strconcat (_data_->_tmp3_, ":", NULL);
	_g_free0 (_data_->remote);
	_data_->remote = _data_->_tmp4_;
	_data_->_tmp5_ = g_strdup ("listremotes");
	_data_->_tmp6_ = g_new0 (gchar*, 1 + 1);
	_data_->_tmp6_[0] = _data_->_tmp5_;
	_data_->_tmp7_ = _data_->_tmp6_;
	_data_->_tmp7__length1 = 1;
	_data_->_state_ = 1;
	rclone_run (_data_->_tmp7_, (gint) 1, (DejaDupBackend*) _data_->self, FALSE, deja_dup_backend_rclone_is_remote_valid_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp8_ = rclone_run_finish (_data_->_res_);
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp7_ = (_vala_array_free (_data_->_tmp7_, _data_->_tmp7__length1, (GDestroyNotify) g_free), NULL);
	_data_->rclone = _data_->_tmp9_;
	_data_->_tmp10_ = _data_->rclone;
	if (_data_->_tmp10_ == NULL) {
		_data_->result = FALSE;
		_g_object_unref0 (_data_->rclone);
		_g_free0 (_data_->remote);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp11_ = _data_->rclone;
	_data_->_tmp12_ = g_subprocess_get_stdout_pipe (_data_->_tmp11_);
	_data_->_tmp13_ = _g_object_ref0 (_data_->_tmp12_);
	_data_->stdout_raw = _data_->_tmp13_;
	_data_->_tmp14_ = _data_->stdout_raw;
	_data_->_tmp15_ = g_data_input_stream_new (_data_->_tmp14_);
	_data_->stdout = _data_->_tmp15_;
	_data_->found_it = FALSE;
	while (TRUE) {
		{
			_data_->_tmp16_ = _data_->stdout;
			_data_->_state_ = 2;
			g_data_input_stream_read_line_async (_data_->_tmp16_, G_PRIORITY_LOW, NULL, deja_dup_backend_rclone_is_remote_valid_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp17_ = g_data_input_stream_read_line_finish_utf8 (_data_->_tmp16_, _data_->_res_, NULL, &_data_->_inner_error0_);
			_data_->line = _data_->_tmp17_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp18_ = _data_->line;
			if (_data_->_tmp18_ == NULL) {
				_g_free0 (_data_->line);
				break;
			}
			_data_->_tmp19_ = _data_->line;
			_data_->_tmp20_ = _data_->remote;
			if (g_strcmp0 (_data_->_tmp19_, _data_->_tmp20_) == 0) {
				_data_->found_it = TRUE;
				_g_free0 (_data_->line);
				break;
			}
			_g_free0 (_data_->line);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp21_ = _data_->err;
			_data_->_tmp22_ = _data_->_tmp21_->message;
			g_warning ("BackendRclone.vala:162: Could not parse Rclone output: %s", _data_->_tmp22_);
			_g_error_free0 (_data_->err);
			break;
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->stdout);
			_g_object_unref0 (_data_->stdout_raw);
			_g_object_unref0 (_data_->rclone);
			_g_free0 (_data_->remote);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp23_ = _data_->rclone;
	g_subprocess_force_exit (_data_->_tmp23_);
	_data_->result = _data_->found_it;
	_g_object_unref0 (_data_->stdout);
	_g_object_unref0 (_data_->stdout_raw);
	_g_object_unref0 (_data_->rclone);
	_g_free0 (_data_->remote);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static SecretSchema*
deja_dup_backend_rclone_get_secret_schema (DejaDupBackendRclone* self)
{
	SecretSchema* _tmp0_;
	SecretSchema* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = secret_schema_new (APPLICATION_ID ".Rclone", SECRET_SCHEMA_NONE, NULL);
	result = _tmp0_;
	return result;
}

static void
deja_dup_backend_rclone_lookup_config_password_data_free (gpointer _data)
{
	DejaDupBackendRcloneLookupConfigPasswordData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendRcloneLookupConfigPasswordData, _data_);
}

void
deja_dup_backend_rclone_lookup_config_password (DejaDupBackendRclone* self,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	DejaDupBackendRcloneLookupConfigPasswordData* _data_;
	DejaDupBackendRclone* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (DejaDupBackendRcloneLookupConfigPasswordData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_backend_rclone_lookup_config_password_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_rclone_lookup_config_password_co (_data_);
}

gchar*
deja_dup_backend_rclone_lookup_config_password_finish (DejaDupBackendRclone* self,
                                                       GAsyncResult* _res_)
{
	gchar* result;
	DejaDupBackendRcloneLookupConfigPasswordData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
deja_dup_backend_rclone_lookup_config_password_co (DejaDupBackendRcloneLookupConfigPasswordData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = deja_dup_backend_rclone_get_secret_schema (_data_->self);
	_data_->schema = _data_->_tmp0_;
	{
		_data_->_tmp2_ = secret_password_lookup_sync (_data_->schema, NULL, &_data_->_inner_error0_, NULL);
		_data_->_tmp1_ = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp3_ = _data_->_tmp1_;
		_data_->_tmp1_ = NULL;
		_data_->result = _data_->_tmp3_;
		_g_free0 (_data_->_tmp1_);
		_secret_schema_unref0 (_data_->schema);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
		_data_->result = NULL;
		_secret_schema_unref0 (_data_->schema);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	_secret_schema_unref0 (_data_->schema);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
	g_clear_error (&_data_->_inner_error0_);
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
deja_dup_backend_rclone_store_config_password_data_free (gpointer _data)
{
	DejaDupBackendRcloneStoreConfigPasswordData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendRcloneStoreConfigPasswordData, _data_);
}

static void
deja_dup_backend_rclone_store_config_password (DejaDupBackendRclone* self,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	DejaDupBackendRcloneStoreConfigPasswordData* _data_;
	DejaDupBackendRclone* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (DejaDupBackendRcloneStoreConfigPasswordData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_backend_rclone_store_config_password_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_rclone_store_config_password_co (_data_);
}

static void
deja_dup_backend_rclone_store_config_password_finish (DejaDupBackendRclone* self,
                                                      GAsyncResult* _res_)
{
	DejaDupBackendRcloneStoreConfigPasswordData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
deja_dup_backend_rclone_store_config_password_co (DejaDupBackendRcloneStoreConfigPasswordData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = deja_dup_backend_rclone_get_secret_schema (_data_->self);
	_data_->schema = _data_->_tmp0_;
	{
		_data_->_tmp1_ = _data_->self->priv->config_password;
		secret_password_store_sync (_data_->schema, SECRET_COLLECTION_DEFAULT, _ ("Rclone config encryption password"), _data_->_tmp1_, NULL, &_data_->_inner_error0_, NULL);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp2_ = _data_->e;
		_data_->_tmp3_ = _data_->_tmp2_->message;
		g_warning ("BackendRclone.vala:199: %s\n", _data_->_tmp3_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_secret_schema_unref0 (_data_->schema);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_secret_schema_unref0 (_data_->schema);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
deja_dup_backend_rclone_clear_config_password_data_free (gpointer _data)
{
	DejaDupBackendRcloneClearConfigPasswordData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendRcloneClearConfigPasswordData, _data_);
}

void
deja_dup_backend_rclone_clear_config_password (DejaDupBackendRclone* self,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	DejaDupBackendRcloneClearConfigPasswordData* _data_;
	DejaDupBackendRclone* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (DejaDupBackendRcloneClearConfigPasswordData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_backend_rclone_clear_config_password_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_rclone_clear_config_password_co (_data_);
}

void
deja_dup_backend_rclone_clear_config_password_finish (DejaDupBackendRclone* self,
                                                      GAsyncResult* _res_)
{
	DejaDupBackendRcloneClearConfigPasswordData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
deja_dup_backend_rclone_clear_config_password_co (DejaDupBackendRcloneClearConfigPasswordData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = deja_dup_backend_rclone_get_secret_schema (_data_->self);
	_data_->schema = _data_->_tmp0_;
	{
		secret_password_clear_sync (_data_->schema, NULL, &_data_->_inner_error0_, NULL);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp1_ = deja_dup_backend_watcher_get_instance ();
		_data_->_tmp2_ = _data_->_tmp1_;
		g_signal_emit_by_name (_data_->_tmp2_, "changed");
		_g_object_unref0 (_data_->_tmp2_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_secret_schema_unref0 (_data_->schema);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_secret_schema_unref0 (_data_->schema);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
deja_dup_backend_rclone_real_prepare_data_free (gpointer _data)
{
	DejaDupBackendRclonePrepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendRclonePrepareData, _data_);
}

static void
deja_dup_backend_rclone_real_prepare (DejaDupBackend* base,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	DejaDupBackendRclone * self;
	DejaDupBackendRclonePrepareData* _data_;
	DejaDupBackendRclone* _tmp0_;
	self = (DejaDupBackendRclone*) base;
	_data_ = g_slice_new0 (DejaDupBackendRclonePrepareData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_backend_rclone_real_prepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_rclone_real_prepare_co (_data_);
}

static void
deja_dup_backend_rclone_prepare_finish (DejaDupBackend* base,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	DejaDupBackendRclonePrepareData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
deja_dup_backend_rclone_prepare_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	DejaDupBackendRclonePrepareData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_rclone_real_prepare_co (_data_);
}

static gboolean
_deja_dup_backend_rclone_real_prepare_co_gsource_func (gpointer self)
{
	gboolean result;
	result = deja_dup_backend_rclone_real_prepare_co (self);
	return result;
}

static gboolean
deja_dup_backend_rclone_real_prepare_co (DejaDupBackendRclonePrepareData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	deja_dup_backend_rclone_is_rclone_config_encrypted (_data_->self, deja_dup_backend_rclone_prepare_ready, _data_);
	return FALSE;
	_state_1:
	if (deja_dup_backend_rclone_is_rclone_config_encrypted_finish (_data_->self, _data_->_res_)) {
		_data_->_tmp0_ = _data_->self->priv->config_password;
		if (_data_->_tmp0_ == NULL) {
			_data_->_state_ = 2;
			deja_dup_backend_rclone_lookup_config_password (_data_->self, deja_dup_backend_rclone_prepare_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp1_ = deja_dup_backend_rclone_lookup_config_password_finish (_data_->self, _data_->_res_);
			_g_free0 (_data_->self->priv->config_password);
			_data_->self->priv->config_password = _data_->_tmp1_;
		}
		_data_->repeat = FALSE;
		while (TRUE) {
			_data_->_state_ = 3;
			deja_dup_backend_rclone_is_rclone_config_password_valid (_data_->self, deja_dup_backend_rclone_prepare_ready, _data_);
			return FALSE;
			_state_3:
			if (!(!deja_dup_backend_rclone_is_rclone_config_password_valid_finish (_data_->self, _data_->_res_))) {
				break;
			}
			(_data_->self->priv->config_password_callback_target_destroy_notify == NULL) ? NULL : (_data_->self->priv->config_password_callback_target_destroy_notify (_data_->self->priv->config_password_callback_target), NULL);
			_data_->self->priv->config_password_callback = NULL;
			_data_->self->priv->config_password_callback_target = NULL;
			_data_->self->priv->config_password_callback_target_destroy_notify = NULL;
			_data_->self->priv->config_password_callback = _deja_dup_backend_rclone_real_prepare_co_gsource_func;
			_data_->self->priv->config_password_callback_target = _data_;
			_data_->self->priv->config_password_callback_target_destroy_notify = NULL;
			deja_dup_backend_set_needs_backend_password ((DejaDupBackend*) _data_->self, TRUE);
			if (_data_->repeat) {
				_data_->_tmp2_ = _ ("Wrong Rclone config encryption password. Try again.");
			} else {
				_data_->_tmp2_ = NULL;
			}
			g_signal_emit_by_name ((DejaDupBackend*) _data_->self, "show-backend-password-page", _ ("Your Rclone config file is encrypted. Please provide its password."), _ ("Rclone Config Encryption _Password"), _data_->_tmp2_);
			_data_->_state_ = 4;
			return FALSE;
			_state_4:
			;
			_data_->repeat = TRUE;
		}
	}
	_data_->_state_ = 5;
	deja_dup_backend_rclone_is_remote_valid (_data_->self, deja_dup_backend_rclone_prepare_ready, _data_);
	return FALSE;
	_state_5:
	if (!deja_dup_backend_rclone_is_remote_valid_finish (_data_->self, _data_->_res_)) {
		_data_->_tmp3_ = deja_dup_backend_rclone_get_remote (_data_->self);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp5_ = g_strdup_printf (_ ("Rclone remote '%s' needs to be configured in Rclone first."), _data_->_tmp4_);
		_data_->_tmp6_ = _data_->_tmp5_;
		_g_free0 (_data_->_tmp4_);
		_data_->msg = _data_->_tmp6_;
		_data_->_tmp7_ = _data_->msg;
		_data_->_tmp8_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "%s", _data_->_tmp7_);
		_data_->_inner_error0_ = _data_->_tmp8_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->msg);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
deja_dup_backend_rclone_real_provide_backend_password_data_free (gpointer _data)
{
	DejaDupBackendRcloneProvideBackendPasswordData* _data_;
	_data_ = _data;
	_g_free0 (_data_->password);
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendRcloneProvideBackendPasswordData, _data_);
}

static void
deja_dup_backend_rclone_real_provide_backend_password (DejaDupBackend* base,
                                                       const gchar* password,
                                                       gboolean save,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_)
{
	DejaDupBackendRclone * self;
	DejaDupBackendRcloneProvideBackendPasswordData* _data_;
	DejaDupBackendRclone* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (password != NULL);
	self = (DejaDupBackendRclone*) base;
	_data_ = g_slice_new0 (DejaDupBackendRcloneProvideBackendPasswordData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_backend_rclone_real_provide_backend_password_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (password);
	_g_free0 (_data_->password);
	_data_->password = _tmp1_;
	_data_->save = save;
	deja_dup_backend_rclone_real_provide_backend_password_co (_data_);
}

static void
deja_dup_backend_rclone_provide_backend_password_finish (DejaDupBackend* base,
                                                         GAsyncResult* _res_)
{
	DejaDupBackendRcloneProvideBackendPasswordData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
deja_dup_backend_rclone_provide_backend_password_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_)
{
	DejaDupBackendRcloneProvideBackendPasswordData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_rclone_real_provide_backend_password_co (_data_);
}

static gboolean
deja_dup_backend_rclone_real_provide_backend_password_co (DejaDupBackendRcloneProvideBackendPasswordData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	deja_dup_backend_set_needs_backend_password ((DejaDupBackend*) _data_->self, FALSE);
	_data_->_tmp0_ = g_strdup (_data_->password);
	_g_free0 (_data_->self->priv->config_password);
	_data_->self->priv->config_password = _data_->_tmp0_;
	if (_data_->save) {
		_data_->_state_ = 1;
		deja_dup_backend_rclone_store_config_password (_data_->self, deja_dup_backend_rclone_provide_backend_password_ready, _data_);
		return FALSE;
		_state_1:
		deja_dup_backend_rclone_store_config_password_finish (_data_->self, _data_->_res_);
	} else {
		_data_->_state_ = 2;
		deja_dup_backend_rclone_clear_config_password (_data_->self, deja_dup_backend_rclone_provide_backend_password_ready, _data_);
		return FALSE;
		_state_2:
		deja_dup_backend_rclone_clear_config_password_finish (_data_->self, _data_->_res_);
	}
	_data_->_tmp1_ = _data_->self->priv->config_password_callback;
	_data_->_tmp1__target = _data_->self->priv->config_password_callback_target;
	if (_data_->_tmp1_ != NULL) {
		_data_->_tmp2_ = _data_->self->priv->config_password_callback;
		_data_->_tmp2__target = _data_->self->priv->config_password_callback_target;
		_data_->_tmp2_ (_data_->_tmp2__target);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
deja_dup_backend_rclone_real_get_space_data_free (gpointer _data)
{
	DejaDupBackendRcloneGetSpaceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendRcloneGetSpaceData, _data_);
}

static void
deja_dup_backend_rclone_real_get_space (DejaDupBackend* base,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	DejaDupBackendRclone * self;
	DejaDupBackendRcloneGetSpaceData* _data_;
	DejaDupBackendRclone* _tmp0_;
	self = (DejaDupBackendRclone*) base;
	_data_ = g_slice_new0 (DejaDupBackendRcloneGetSpaceData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_backend_rclone_real_get_space_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_rclone_real_get_space_co (_data_);
}

static void
deja_dup_backend_rclone_get_space_finish (DejaDupBackend* base,
                                          GAsyncResult* _res_,
                                          guint64* free,
                                          guint64* total)
{
	DejaDupBackendRcloneGetSpaceData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (free) {
		*free = _data_->free;
	}
	if (total) {
		*total = _data_->total;
	}
}

static void
deja_dup_backend_rclone_get_space_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	DejaDupBackendRcloneGetSpaceData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_rclone_real_get_space_co (_data_);
}

static gboolean
deja_dup_backend_rclone_real_get_space_co (DejaDupBackendRcloneGetSpaceData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = 0ULL;
	_data_->_tmp1_ = 0ULL;
	_data_->_state_ = 1;
	rclone_get_space ((DejaDupBackend*) _data_->self, deja_dup_backend_rclone_get_space_ready, _data_);
	return FALSE;
	_state_1:
	rclone_get_space_finish (_data_->_res_, &_data_->_tmp0_, &_data_->_tmp1_);
	_data_->free = _data_->_tmp0_;
	_data_->total = _data_->_tmp1_;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

static void
deja_dup_backend_rclone_real_peek_at_files_data_free (gpointer _data)
{
	DejaDupBackendRclonePeekAtFilesData* _data_;
	_data_ = _data;
	(_data_->result == NULL) ? NULL : (_data_->result = (_g_list_free__g_free0_ (_data_->result), NULL));
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendRclonePeekAtFilesData, _data_);
}

static void
deja_dup_backend_rclone_real_peek_at_files (DejaDupBackend* base,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	DejaDupBackendRclone * self;
	DejaDupBackendRclonePeekAtFilesData* _data_;
	DejaDupBackendRclone* _tmp0_;
	self = (DejaDupBackendRclone*) base;
	_data_ = g_slice_new0 (DejaDupBackendRclonePeekAtFilesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_backend_rclone_real_peek_at_files_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_rclone_real_peek_at_files_co (_data_);
}

static GList*
deja_dup_backend_rclone_peek_at_files_finish (DejaDupBackend* base,
                                              GAsyncResult* _res_)
{
	GList* result;
	DejaDupBackendRclonePeekAtFilesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
deja_dup_backend_rclone_peek_at_files_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_)
{
	DejaDupBackendRclonePeekAtFilesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_rclone_real_peek_at_files_co (_data_);
}

static gboolean
deja_dup_backend_rclone_real_peek_at_files_co (DejaDupBackendRclonePeekAtFilesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	rclone_list_files ((DejaDupBackend*) _data_->self, 20, deja_dup_backend_rclone_peek_at_files_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = rclone_list_files_finish (_data_->_res_);
	_data_->result = _data_->_tmp0_;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

gchar*
deja_dup_backend_rclone_fill_envp (DejaDupBackendRclone* self,
                                   GList** envp)
{
	const gchar* _tmp0_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->config_password;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->priv->config_password;
		_tmp2_ = g_strconcat ("RCLONE_CONFIG_PASS=", _tmp1_, NULL);
		*envp = g_list_append (*envp, _tmp2_);
	}
	_tmp3_ = deja_dup_backend_rclone_get_remote (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = deja_dup_backend_rclone_get_folder (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf ("%s:%s", _tmp4_, _tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	result = _tmp8_;
	return result;
}

static void
deja_dup_backend_rclone_class_init (DejaDupBackendRcloneClass * klass,
                                    gpointer klass_data)
{
	deja_dup_backend_rclone_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DejaDupBackendRclone_private_offset);
	((DejaDupBackendClass *) klass)->is_native = (gboolean (*) (DejaDupBackend*)) deja_dup_backend_rclone_real_is_native;
	((DejaDupBackendClass *) klass)->get_dependencies = (gchar** (*) (DejaDupBackend*, gint*)) deja_dup_backend_rclone_real_get_dependencies;
	((DejaDupBackendClass *) klass)->get_icon = (GIcon* (*) (DejaDupBackend*)) deja_dup_backend_rclone_real_get_icon;
	((DejaDupBackendClass *) klass)->is_ready = (void (*) (DejaDupBackend*, GAsyncReadyCallback, gpointer)) deja_dup_backend_rclone_real_is_ready;
	((DejaDupBackendClass *) klass)->is_ready_finish = (gboolean (*) (DejaDupBackend*, GAsyncResult*, gchar**, gchar**)) deja_dup_backend_rclone_is_ready_finish;
	((DejaDupBackendClass *) klass)->get_location_pretty = (gchar* (*) (DejaDupBackend*)) deja_dup_backend_rclone_real_get_location_pretty;
	((DejaDupBackendClass *) klass)->get_unique_location = (gchar* (*) (DejaDupBackend*)) deja_dup_backend_rclone_real_get_unique_location;
	((DejaDupBackendClass *) klass)->is_acceptable = (gboolean (*) (DejaDupBackend*, gchar**)) deja_dup_backend_rclone_real_is_acceptable;
	((DejaDupBackendClass *) klass)->prepare = (void (*) (DejaDupBackend*, GAsyncReadyCallback, gpointer)) deja_dup_backend_rclone_real_prepare;
	((DejaDupBackendClass *) klass)->prepare_finish = (void (*) (DejaDupBackend*, GAsyncResult*, GError**)) deja_dup_backend_rclone_prepare_finish;
	((DejaDupBackendClass *) klass)->provide_backend_password = (void (*) (DejaDupBackend*, const gchar*, gboolean, GAsyncReadyCallback, gpointer)) deja_dup_backend_rclone_real_provide_backend_password;
	((DejaDupBackendClass *) klass)->provide_backend_password_finish = (void (*) (DejaDupBackend*, GAsyncResult*)) deja_dup_backend_rclone_provide_backend_password_finish;
	((DejaDupBackendClass *) klass)->get_space = (void (*) (DejaDupBackend*, GAsyncReadyCallback, gpointer)) deja_dup_backend_rclone_real_get_space;
	((DejaDupBackendClass *) klass)->get_space_finish = (void (*) (DejaDupBackend*, GAsyncResult*, guint64*, guint64*)) deja_dup_backend_rclone_get_space_finish;
	((DejaDupBackendClass *) klass)->peek_at_files = (void (*) (DejaDupBackend*, GAsyncReadyCallback, gpointer)) deja_dup_backend_rclone_real_peek_at_files;
	((DejaDupBackendClass *) klass)->peek_at_files_finish = (GList* (*) (DejaDupBackend*, GAsyncResult*)) deja_dup_backend_rclone_peek_at_files_finish;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_backend_rclone_finalize;
}

static void
deja_dup_backend_rclone_instance_init (DejaDupBackendRclone * self,
                                       gpointer klass)
{
	self->priv = deja_dup_backend_rclone_get_instance_private (self);
}

static void
deja_dup_backend_rclone_finalize (GObject * obj)
{
	DejaDupBackendRclone * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DEJA_DUP_TYPE_BACKEND_RCLONE, DejaDupBackendRclone);
	(self->priv->config_password_callback_target_destroy_notify == NULL) ? NULL : (self->priv->config_password_callback_target_destroy_notify (self->priv->config_password_callback_target), NULL);
	self->priv->config_password_callback = NULL;
	self->priv->config_password_callback_target = NULL;
	self->priv->config_password_callback_target_destroy_notify = NULL;
	_g_free0 (self->priv->config_password);
	G_OBJECT_CLASS (deja_dup_backend_rclone_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
deja_dup_backend_rclone_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DejaDupBackendRcloneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_backend_rclone_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupBackendRclone), 0, (GInstanceInitFunc) deja_dup_backend_rclone_instance_init, NULL };
	GType deja_dup_backend_rclone_type_id;
	deja_dup_backend_rclone_type_id = g_type_register_static (DEJA_DUP_TYPE_BACKEND, "DejaDupBackendRclone", &g_define_type_info, 0);
	DejaDupBackendRclone_private_offset = g_type_add_instance_private (deja_dup_backend_rclone_type_id, sizeof (DejaDupBackendRclonePrivate));
	return deja_dup_backend_rclone_type_id;
}

GType
deja_dup_backend_rclone_get_type (void)
{
	static gsize deja_dup_backend_rclone_type_id__once = 0;
	if (g_once_init_enter (&deja_dup_backend_rclone_type_id__once)) {
		GType deja_dup_backend_rclone_type_id;
		deja_dup_backend_rclone_type_id = deja_dup_backend_rclone_get_type_once ();
		g_once_init_leave (&deja_dup_backend_rclone_type_id__once, deja_dup_backend_rclone_type_id);
	}
	return deja_dup_backend_rclone_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

