/* BackupInterface.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from BackupInterface.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */
/* Just a thin convenience class to talk to the main backup process and ask it*/
/* to start or stop backups.*/

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "deja.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ACTIONS_INTERFACE (actions_interface_get_type ())
#define ACTIONS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACTIONS_INTERFACE, ActionsInterface))
#define IS_ACTIONS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACTIONS_INTERFACE))
#define ACTIONS_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ACTIONS_INTERFACE, ActionsInterfaceIface))

typedef struct _ActionsInterface ActionsInterface;
typedef struct _ActionsInterfaceIface ActionsInterfaceIface;

#define TYPE_ACTIONS_INTERFACE_PROXY (actions_interface_proxy_get_type ())
typedef GDBusProxy ActionsInterfaceProxy;
typedef GDBusProxyClass ActionsInterfaceProxyClass;
typedef struct _ActionsInterfaceActivateReadyData ActionsInterfaceActivateReadyData;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define TYPE_BACKUP_INTERFACE (backup_interface_get_type ())
#define BACKUP_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKUP_INTERFACE, BackupInterface))
#define BACKUP_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKUP_INTERFACE, BackupInterfaceClass))
#define IS_BACKUP_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKUP_INTERFACE))
#define IS_BACKUP_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKUP_INTERFACE))
#define BACKUP_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKUP_INTERFACE, BackupInterfaceClass))

typedef struct _BackupInterface BackupInterface;
typedef struct _BackupInterfaceClass BackupInterfaceClass;
typedef struct _BackupInterfacePrivate BackupInterfacePrivate;
enum  {
	BACKUP_INTERFACE_0_PROPERTY,
	BACKUP_INTERFACE_NUM_PROPERTIES
};
static GParamSpec* backup_interface_properties[BACKUP_INTERFACE_NUM_PROPERTIES];
typedef struct _BackupInterfaceNotifyNotReadyData BackupInterfaceNotifyNotReadyData;
typedef struct _BackupInterfaceStartAutoData BackupInterfaceStartAutoData;
typedef struct _BackupInterfaceStopAutoData BackupInterfaceStopAutoData;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BackupInterfaceActivateActionData BackupInterfaceActivateActionData;

struct _ActionsInterfaceIface {
	GTypeInterface parent_iface;
	void (*activate) (ActionsInterface* self, const gchar* action, GVariant** paramters, gint paramters_length1, GHashTable* platform_data, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*activate_finish) (ActionsInterface* self, GAsyncResult* _res_, GError** error);
};

struct _ActionsInterfaceActivateReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar* action;
	GVariant** paramters;
	gint paramters_length1;
	GHashTable* platform_data;
};

struct _BackupInterface {
	GObject parent_instance;
	BackupInterfacePrivate * priv;
};

struct _BackupInterfaceClass {
	GObjectClass parent_class;
};

struct _BackupInterfaceNotifyNotReadyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gchar* message;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
};

struct _BackupInterfaceStartAutoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
};

struct _BackupInterfaceStopAutoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
};

struct _BackupInterfaceActivateActionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gchar* command;
	GDBusConnection* connection;
	GDBusConnection* _tmp0_;
	ActionsInterface* iface;
	GDBusConnection* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	ActionsInterface* _tmp4_;
	ActionsInterface* _tmp5_;
	GVariant** parameters;
	GVariant** _tmp6_;
	gint parameters_length1;
	gint _parameters_size_;
	GHashTable* platform_data;
	GHashFunc _tmp7_;
	GEqualFunc _tmp8_;
	GHashTable* _tmp9_;
	ActionsInterface* _tmp10_;
	GVariant** _tmp11_;
	gint _tmp11__length1;
	GHashTable* _tmp12_;
	GError* _error_;
	GError* _tmp13_;
	const gchar* _tmp14_;
	GError* _inner_error0_;
};

static gpointer backup_interface_parent_class = NULL;

VALA_EXTERN GType actions_interface_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint actions_interface_register_object (void* object,
                                         GDBusConnection* connection,
                                         const gchar* path,
                                         GError** error);
VALA_EXTERN GType actions_interface_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ActionsInterface, g_object_unref)
VALA_EXTERN void actions_interface_activate (ActionsInterface* self,
                                 const gchar* action,
                                 GVariant** paramters,
                                 gint paramters_length1,
                                 GHashTable* platform_data,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
VALA_EXTERN void actions_interface_activate_finish (ActionsInterface* self,
                                        GAsyncResult* _res_,
                                        GError** error);
static GType actions_interface_get_type_once (void);
static void actions_interface_proxy_g_signal (GDBusProxy* proxy,
                                       const gchar* sender_name,
                                       const gchar* signal_name,
                                       GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object,
                                   GAsyncResult *res,
                                   void *user_data);
static void actions_interface_proxy_activate_async (ActionsInterface* self,
                                             const gchar* action,
                                             GVariant** paramters,
                                             gint paramters_length1,
                                             GHashTable* platform_data,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
static void actions_interface_proxy_activate_finish (ActionsInterface* self,
                                              GAsyncResult* _res_,
                                              GError** error);
static void actions_interface_proxy_actions_interface_interface_init (ActionsInterfaceIface* iface);
static void _dbus_actions_interface_activate (ActionsInterface* self,
                                       GVariant* _parameters_,
                                       GDBusMethodInvocation* invocation);
static void _dbus_actions_interface_activate_ready (GObject * source_object,
                                             GAsyncResult * _res_,
                                             gpointer _user_data_);
static void actions_interface_dbus_interface_method_call (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* method_name,
                                                   GVariant* parameters,
                                                   GDBusMethodInvocation* invocation,
                                                   gpointer user_data);
static GVariant* actions_interface_dbus_interface_get_property (GDBusConnection* connection,
                                                         const gchar* sender,
                                                         const gchar* object_path,
                                                         const gchar* interface_name,
                                                         const gchar* property_name,
                                                         GError** error,
                                                         gpointer user_data);
static gboolean actions_interface_dbus_interface_set_property (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* property_name,
                                                        GVariant* value,
                                                        GError** error,
                                                        gpointer user_data);
static void _actions_interface_unregister_object (gpointer user_data);
VALA_EXTERN GType backup_interface_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BackupInterface, g_object_unref)
static void backup_interface_notify_not_ready_data_free (gpointer _data);
VALA_EXTERN void backup_interface_notify_not_ready (const gchar* message,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
VALA_EXTERN void backup_interface_notify_not_ready_finish (GAsyncResult* _res_);
static gboolean backup_interface_notify_not_ready_co (BackupInterfaceNotifyNotReadyData* _data_);
static void backup_interface_start_auto_data_free (gpointer _data);
VALA_EXTERN void backup_interface_start_auto (GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
VALA_EXTERN void backup_interface_start_auto_finish (GAsyncResult* _res_);
static gboolean backup_interface_start_auto_co (BackupInterfaceStartAutoData* _data_);
static void backup_interface_stop_auto_data_free (gpointer _data);
VALA_EXTERN void backup_interface_stop_auto (GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
VALA_EXTERN void backup_interface_stop_auto_finish (GAsyncResult* _res_);
static gboolean backup_interface_stop_auto_co (BackupInterfaceStopAutoData* _data_);
static void backup_interface_activate_action (const gchar* command,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
static void backup_interface_activate_action_finish (GAsyncResult* _res_);
static void backup_interface_stop_auto_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_);
static void backup_interface_activate_action_data_free (gpointer _data);
static gboolean backup_interface_activate_action_co (BackupInterfaceActivateActionData* _data_);
static void backup_interface_activate_action_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
VALA_EXTERN BackupInterface* backup_interface_new (void);
VALA_EXTERN BackupInterface* backup_interface_construct (GType object_type);
static GType backup_interface_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GDBusArgInfo _actions_interface_dbus_arg_info_activate_action = {-1, "action", "s", NULL};
static const GDBusArgInfo _actions_interface_dbus_arg_info_activate_paramters = {-1, "paramters", "av", NULL};
static const GDBusArgInfo _actions_interface_dbus_arg_info_activate_platform_data = {-1, "platform_data", "a{sv}", NULL};
static const GDBusArgInfo * const _actions_interface_dbus_arg_info_activate_in[] = {&_actions_interface_dbus_arg_info_activate_action, &_actions_interface_dbus_arg_info_activate_paramters, &_actions_interface_dbus_arg_info_activate_platform_data, NULL};
static const GDBusArgInfo * const _actions_interface_dbus_arg_info_activate_out[] = {NULL};
static const GDBusMethodInfo _actions_interface_dbus_method_info_activate = {-1, "Activate", (GDBusArgInfo **) (&_actions_interface_dbus_arg_info_activate_in), (GDBusArgInfo **) (&_actions_interface_dbus_arg_info_activate_out), NULL};
static const GDBusMethodInfo * const _actions_interface_dbus_method_info[] = {&_actions_interface_dbus_method_info_activate, NULL};
static const GDBusSignalInfo * const _actions_interface_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _actions_interface_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _actions_interface_dbus_interface_info = {-1, "org.gtk.Actions", (GDBusMethodInfo **) (&_actions_interface_dbus_method_info), (GDBusSignalInfo **) (&_actions_interface_dbus_signal_info), (GDBusPropertyInfo **) (&_actions_interface_dbus_property_info), NULL};
static const GDBusInterfaceVTable _actions_interface_dbus_interface_vtable = {actions_interface_dbus_interface_method_call, actions_interface_dbus_interface_get_property, actions_interface_dbus_interface_set_property};

void
actions_interface_activate (ActionsInterface* self,
                            const gchar* action,
                            GVariant** paramters,
                            gint paramters_length1,
                            GHashTable* platform_data,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	ActionsInterfaceIface* _iface_;
	_iface_ = ACTIONS_INTERFACE_GET_INTERFACE (self);
	if (_iface_->activate) {
		_iface_->activate (self, action, paramters, paramters_length1, platform_data, _callback_, _user_data_);
	}
}

void
actions_interface_activate_finish (ActionsInterface* self,
                                   GAsyncResult* _res_,
                                   GError** error)
{
	ActionsInterfaceIface* _iface_;
	_iface_ = ACTIONS_INTERFACE_GET_INTERFACE (self);
	if (_iface_->activate_finish) {
		_iface_->activate_finish (self, _res_, error);
	}
}

static void
actions_interface_default_init (ActionsInterfaceIface * iface,
                                gpointer iface_data)
{
}

 G_GNUC_NO_INLINE static GType
actions_interface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ActionsInterfaceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) actions_interface_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType actions_interface_type_id;
	actions_interface_type_id = g_type_register_static (G_TYPE_INTERFACE, "ActionsInterface", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (actions_interface_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (actions_interface_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) actions_interface_proxy_get_type);
	g_type_set_qdata (actions_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gtk.Actions");
	g_type_set_qdata (actions_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_actions_interface_dbus_interface_info));
	g_type_set_qdata (actions_interface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) actions_interface_register_object);
	return actions_interface_type_id;
}

GType
actions_interface_get_type (void)
{
	static gsize actions_interface_type_id__once = 0;
	if (g_once_init_enter (&actions_interface_type_id__once)) {
		GType actions_interface_type_id;
		actions_interface_type_id = actions_interface_get_type_once ();
		g_once_init_leave (&actions_interface_type_id__once, actions_interface_type_id);
	}
	return actions_interface_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (ActionsInterfaceProxy, actions_interface_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_ACTIONS_INTERFACE, actions_interface_proxy_actions_interface_interface_init) )
static void
actions_interface_proxy_class_init (ActionsInterfaceProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = actions_interface_proxy_g_signal;
}

static void
actions_interface_proxy_g_signal (GDBusProxy* proxy,
                                  const gchar* sender_name,
                                  const gchar* signal_name,
                                  GVariant* parameters)
{
}

static void
actions_interface_proxy_init (ActionsInterfaceProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_actions_interface_dbus_interface_info));
}

static void
_vala_g_async_ready_callback (GObject *source_object,
                              GAsyncResult *res,
                              void *user_data)
{
	g_task_return_pointer (user_data, g_object_ref (res), g_object_unref);
	g_object_unref (user_data);
}

static void
actions_interface_proxy_activate_async (ActionsInterface* self,
                                        const gchar* action,
                                        GVariant** paramters,
                                        gint paramters_length1,
                                        GHashTable* platform_data,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariant** _tmp0_;
	GVariantBuilder _tmp1_;
	gint _tmp2_;
	GVariantBuilder _tmp3_;
	GHashTableIter _tmp4_;
	gpointer _tmp5_;
	gpointer _tmp6_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gtk.Actions", "Activate");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (action));
	_tmp0_ = paramters;
	g_variant_builder_init (&_tmp1_, G_VARIANT_TYPE ("av"));
	for (_tmp2_ = 0; _tmp2_ < paramters_length1; _tmp2_++) {
		g_variant_builder_add_value (&_tmp1_, g_variant_new_variant (*_tmp0_));
		_tmp0_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp1_));
	g_hash_table_iter_init (&_tmp4_, platform_data);
	g_variant_builder_init (&_tmp3_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp4_, &_tmp5_, &_tmp6_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp5_;
		_value = (GVariant*) _tmp6_;
		g_variant_builder_add (&_tmp3_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp3_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
actions_interface_proxy_activate_finish (ActionsInterface* self,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
actions_interface_proxy_actions_interface_interface_init (ActionsInterfaceIface* iface)
{
	iface->activate = actions_interface_proxy_activate_async;
	iface->activate_finish = actions_interface_proxy_activate_finish;
}

static void
_dbus_actions_interface_activate (ActionsInterface* self,
                                  GVariant* _parameters_,
                                  GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	ActionsInterfaceActivateReadyData* _ready_data;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	GVariant** _tmp9_;
	gint _tmp9__length;
	gint _tmp9__size;
	gint _tmp9__length1;
	GVariantIter _tmp10_;
	GVariant* _tmp11_;
	GVariant* _tmp12_;
	GHashTable* _tmp13_;
	GVariantIter _tmp14_;
	GVariant* _tmp15_;
	GVariant* _tmp16_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (ActionsInterfaceActivateReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp7_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->action = g_variant_dup_string (_tmp7_, NULL);
	g_variant_unref (_tmp7_);
	_tmp8_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp9_ = g_new (GVariant*, 5);
	_tmp9__length = 0;
	_tmp9__size = 4;
	_tmp9__length1 = 0;
	g_variant_iter_init (&_tmp10_, _tmp8_);
	for (; (_tmp11_ = g_variant_iter_next_value (&_tmp10_)) != NULL; _tmp9__length1++) {
		if (_tmp9__size == _tmp9__length) {
			_tmp9__size = 2 * _tmp9__size;
			_tmp9_ = g_renew (GVariant*, _tmp9_, _tmp9__size + 1);
		}
		_tmp9_[_tmp9__length++] = g_variant_get_variant (_tmp11_);
		g_variant_unref (_tmp11_);
	}
	_ready_data->paramters_length1 = _tmp9__length1;
	_tmp9_[_tmp9__length] = NULL;
	_ready_data->paramters = _tmp9_;
	g_variant_unref (_tmp8_);
	_tmp12_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp13_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
	g_variant_iter_init (&_tmp14_, _tmp12_);
	while (g_variant_iter_loop (&_tmp14_, "{?*}", &_tmp15_, &_tmp16_)) {
		g_hash_table_insert (_tmp13_, g_variant_dup_string (_tmp15_, NULL), g_variant_get_variant (_tmp16_));
	}
	_ready_data->platform_data = _tmp13_;
	g_variant_unref (_tmp12_);
	actions_interface_activate (self, _ready_data->action, _ready_data->paramters, _ready_data->paramters_length1, _ready_data->platform_data, (GAsyncReadyCallback) _dbus_actions_interface_activate_ready, _ready_data);
	_error:
	;
}

static void
_dbus_actions_interface_activate_ready (GObject * source_object,
                                        GAsyncResult * _res_,
                                        gpointer _user_data_)
{
	ActionsInterfaceActivateReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	actions_interface_activate_finish ((ActionsInterface*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->action);
	_ready_data->paramters = (_vala_array_free (_ready_data->paramters, _ready_data->paramters_length1, (GDestroyNotify) g_variant_unref), NULL);
	_g_hash_table_unref0 (_ready_data->platform_data);
	g_slice_free (ActionsInterfaceActivateReadyData, _ready_data);
}

static void
actions_interface_dbus_interface_method_call (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* method_name,
                                              GVariant* parameters,
                                              GDBusMethodInvocation* invocation,
                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Activate") == 0) {
		_dbus_actions_interface_activate (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
actions_interface_dbus_interface_get_property (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* property_name,
                                               GError** error,
                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
actions_interface_dbus_interface_set_property (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* property_name,
                                               GVariant* value,
                                               GError** error,
                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
actions_interface_register_object (gpointer object,
                                   GDBusConnection* connection,
                                   const gchar* path,
                                   GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_actions_interface_dbus_interface_info), &_actions_interface_dbus_interface_vtable, data, _actions_interface_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_actions_interface_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
backup_interface_notify_not_ready_data_free (gpointer _data)
{
	BackupInterfaceNotifyNotReadyData* _data_;
	_data_ = _data;
	_g_free0 (_data_->message);
	g_slice_free (BackupInterfaceNotifyNotReadyData, _data_);
}

void
backup_interface_notify_not_ready (const gchar* message,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	BackupInterfaceNotifyNotReadyData* _data_;
	gchar* _tmp0_;
	g_return_if_fail (message != NULL);
	_data_ = g_slice_new0 (BackupInterfaceNotifyNotReadyData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, backup_interface_notify_not_ready_data_free);
	_tmp0_ = g_strdup (message);
	_g_free0 (_data_->message);
	_data_->message = _tmp0_;
	backup_interface_notify_not_ready_co (_data_);
}

void
backup_interface_notify_not_ready_finish (GAsyncResult* _res_)
{
	BackupInterfaceNotifyNotReadyData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
backup_interface_notify_not_ready_co (BackupInterfaceNotifyNotReadyData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_strdup ("deja-dup");
	_data_->_tmp1_ = g_strdup ("--delay");
	_data_->_tmp2_ = g_strdup (_data_->message);
	_data_->_tmp3_ = g_new0 (gchar*, 3 + 1);
	_data_->_tmp3_[0] = _data_->_tmp0_;
	_data_->_tmp3_[1] = _data_->_tmp1_;
	_data_->_tmp3_[2] = _data_->_tmp2_;
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp4__length1 = 3;
	deja_dup_run_command (_data_->_tmp4_, (gint) 3);
	_data_->_tmp4_ = (_vala_array_free (_data_->_tmp4_, _data_->_tmp4__length1, (GDestroyNotify) g_free), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
backup_interface_start_auto_data_free (gpointer _data)
{
	BackupInterfaceStartAutoData* _data_;
	_data_ = _data;
	g_slice_free (BackupInterfaceStartAutoData, _data_);
}

void
backup_interface_start_auto (GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	BackupInterfaceStartAutoData* _data_;
	_data_ = g_slice_new0 (BackupInterfaceStartAutoData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, backup_interface_start_auto_data_free);
	backup_interface_start_auto_co (_data_);
}

void
backup_interface_start_auto_finish (GAsyncResult* _res_)
{
	BackupInterfaceStartAutoData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
backup_interface_start_auto_co (BackupInterfaceStartAutoData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (deja_dup_in_testing_mode ()) {
		deja_dup_update_last_run_timestamp (DEJA_DUP_LAST_BACKUP_KEY);
	} else {
		_data_->_tmp0_ = g_strdup ("deja-dup");
		_data_->_tmp1_ = g_strdup ("--backup");
		_data_->_tmp2_ = g_strdup ("--auto");
		_data_->_tmp3_ = g_new0 (gchar*, 3 + 1);
		_data_->_tmp3_[0] = _data_->_tmp0_;
		_data_->_tmp3_[1] = _data_->_tmp1_;
		_data_->_tmp3_[2] = _data_->_tmp2_;
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp4__length1 = 3;
		deja_dup_run_command (_data_->_tmp4_, (gint) 3);
		_data_->_tmp4_ = (_vala_array_free (_data_->_tmp4_, _data_->_tmp4__length1, (GDestroyNotify) g_free), NULL);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
backup_interface_stop_auto_data_free (gpointer _data)
{
	BackupInterfaceStopAutoData* _data_;
	_data_ = _data;
	g_slice_free (BackupInterfaceStopAutoData, _data_);
}

void
backup_interface_stop_auto (GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	BackupInterfaceStopAutoData* _data_;
	_data_ = g_slice_new0 (BackupInterfaceStopAutoData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, backup_interface_stop_auto_data_free);
	backup_interface_stop_auto_co (_data_);
}

void
backup_interface_stop_auto_finish (GAsyncResult* _res_)
{
	BackupInterfaceStopAutoData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
backup_interface_stop_auto_ready (GObject* source_object,
                                  GAsyncResult* _res_,
                                  gpointer _user_data_)
{
	BackupInterfaceStopAutoData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	backup_interface_stop_auto_co (_data_);
}

static gboolean
backup_interface_stop_auto_co (BackupInterfaceStopAutoData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (!deja_dup_in_testing_mode ()) {
		_data_->_state_ = 1;
		backup_interface_activate_action ("backup-auto-stop", backup_interface_stop_auto_ready, _data_);
		return FALSE;
		_state_1:
		backup_interface_activate_action_finish (_data_->_res_);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
backup_interface_activate_action_data_free (gpointer _data)
{
	BackupInterfaceActivateActionData* _data_;
	_data_ = _data;
	_g_free0 (_data_->command);
	g_slice_free (BackupInterfaceActivateActionData, _data_);
}

static void
backup_interface_activate_action (const gchar* command,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	BackupInterfaceActivateActionData* _data_;
	gchar* _tmp0_;
	g_return_if_fail (command != NULL);
	_data_ = g_slice_new0 (BackupInterfaceActivateActionData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, backup_interface_activate_action_data_free);
	_tmp0_ = g_strdup (command);
	_g_free0 (_data_->command);
	_data_->command = _tmp0_;
	backup_interface_activate_action_co (_data_);
}

static void
backup_interface_activate_action_finish (GAsyncResult* _res_)
{
	BackupInterfaceActivateActionData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
backup_interface_activate_action_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	BackupInterfaceActivateActionData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	backup_interface_activate_action_co (_data_);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_variant_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}

static gboolean
backup_interface_activate_action_co (BackupInterfaceActivateActionData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		g_bus_get (G_BUS_TYPE_SESSION, NULL, backup_interface_activate_action_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp0_ = g_bus_get_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->connection = _data_->_tmp0_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp1_ = _data_->connection;
		_data_->_tmp2_ = deja_dup_get_application_path ();
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_state_ = 2;
		g_async_initable_new_async (TYPE_ACTIONS_INTERFACE_PROXY, 0, NULL, backup_interface_activate_action_ready, _data_, "g-flags", 0, "g-name", APPLICATION_ID, "g-connection", _data_->_tmp1_, "g-object-path", _data_->_tmp3_, "g-interface-name", "org.gtk.Actions", NULL);
		return FALSE;
		_state_2:
		_data_->_tmp4_ = (ActionsInterface*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp5_ = (ActionsInterface*) _data_->_tmp4_;
		_g_free0 (_data_->_tmp3_);
		_data_->iface = _data_->_tmp5_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->connection);
			goto __catch0_g_error;
		}
		_data_->_tmp6_ = g_new0 (GVariant*, 0 + 1);
		_data_->parameters = _data_->_tmp6_;
		_data_->parameters_length1 = 0;
		_data_->_parameters_size_ = _data_->parameters_length1;
		_data_->_tmp7_ = g_str_hash;
		_data_->_tmp8_ = g_str_equal;
		_data_->_tmp9_ = g_hash_table_new_full (_data_->_tmp7_, _data_->_tmp8_, _g_free0_, _g_variant_unref0_);
		_data_->platform_data = _data_->_tmp9_;
		_data_->_tmp10_ = _data_->iface;
		_data_->_tmp11_ = _data_->parameters;
		_data_->_tmp11__length1 = _data_->parameters_length1;
		_data_->_tmp12_ = _data_->platform_data;
		_data_->_state_ = 3;
		actions_interface_activate (_data_->_tmp10_, _data_->command, _data_->_tmp11_, (gint) _data_->_tmp11__length1, _data_->_tmp12_, backup_interface_activate_action_ready, _data_);
		return FALSE;
		_state_3:
		actions_interface_activate_finish (_data_->_tmp10_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_hash_table_unref0 (_data_->platform_data);
			_data_->parameters = (_vala_array_free (_data_->parameters, _data_->parameters_length1, (GDestroyNotify) g_variant_unref), NULL);
			_g_object_unref0 (_data_->iface);
			_g_object_unref0 (_data_->connection);
			goto __catch0_g_error;
		}
		_g_hash_table_unref0 (_data_->platform_data);
		_data_->parameters = (_vala_array_free (_data_->parameters, _data_->parameters_length1, (GDestroyNotify) g_variant_unref), NULL);
		_g_object_unref0 (_data_->iface);
		_g_object_unref0 (_data_->connection);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp13_ = _data_->_error_;
		_data_->_tmp14_ = _data_->_tmp13_->message;
		g_warning ("BackupInterface.vala:64: %s", _data_->_tmp14_);
		_g_error_free0 (_data_->_error_);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

BackupInterface*
backup_interface_construct (GType object_type)
{
	BackupInterface * self = NULL;
	self = (BackupInterface*) g_object_new (object_type, NULL);
	return self;
}

BackupInterface*
backup_interface_new (void)
{
	return backup_interface_construct (TYPE_BACKUP_INTERFACE);
}

static void
backup_interface_class_init (BackupInterfaceClass * klass,
                             gpointer klass_data)
{
	backup_interface_parent_class = g_type_class_peek_parent (klass);
}

static void
backup_interface_instance_init (BackupInterface * self,
                                gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
backup_interface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BackupInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) backup_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BackupInterface), 0, (GInstanceInitFunc) backup_interface_instance_init, NULL };
	GType backup_interface_type_id;
	backup_interface_type_id = g_type_register_static (G_TYPE_OBJECT, "BackupInterface", &g_define_type_info, 0);
	return backup_interface_type_id;
}

GType
backup_interface_get_type (void)
{
	static gsize backup_interface_type_id__once = 0;
	if (g_once_init_enter (&backup_interface_type_id__once)) {
		GType backup_interface_type_id;
		backup_interface_type_id = backup_interface_get_type_once ();
		g_once_init_leave (&backup_interface_type_id__once, backup_interface_type_id);
	}
	return backup_interface_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

