/* Generated by wayland-scanner 1.24.0 */

#ifndef STREAM_CLIENT_PROTOCOL_H
#define STREAM_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_stream The stream protocol
 * @section page_ifaces_stream Interfaces
 * - @subpage page_iface_wl_eglstream - 
 * - @subpage page_iface_wl_eglstream_display - 
 * @section page_copyright_stream Copyright
 * <pre>
 *
 * Copyright (c) 2014-2019, NVIDIA CORPORATION. All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct wl_buffer;
struct wl_eglstream;
struct wl_eglstream_display;

#ifndef WL_EGLSTREAM_INTERFACE
#define WL_EGLSTREAM_INTERFACE
/**
 * @page page_iface_wl_eglstream wl_eglstream
 * @section page_iface_wl_eglstream_api API
 * See @ref iface_wl_eglstream.
 */
/**
 * @defgroup iface_wl_eglstream The wl_eglstream interface
 */
extern const struct wl_interface wl_eglstream_interface;
#endif
#ifndef WL_EGLSTREAM_DISPLAY_INTERFACE
#define WL_EGLSTREAM_DISPLAY_INTERFACE
/**
 * @page page_iface_wl_eglstream_display wl_eglstream_display
 * @section page_iface_wl_eglstream_display_api API
 * See @ref iface_wl_eglstream_display.
 */
/**
 * @defgroup iface_wl_eglstream_display The wl_eglstream_display interface
 */
extern const struct wl_interface wl_eglstream_display_interface;
#endif

#ifndef WL_EGLSTREAM_ERROR_ENUM
#define WL_EGLSTREAM_ERROR_ENUM
enum wl_eglstream_error {
	/**
	 * Bad allocation error
	 */
	WL_EGLSTREAM_ERROR_BAD_ALLOC = 0,
	/**
	 * Bad handle error
	 */
	WL_EGLSTREAM_ERROR_BAD_HANDLE = 1,
	/**
	 * Bad attributes error
	 */
	WL_EGLSTREAM_ERROR_BAD_ATTRIBS = 2,
	/**
	 * Bad IP address error
	 */
	WL_EGLSTREAM_ERROR_BAD_ADDRESS = 3,
};
#endif /* WL_EGLSTREAM_ERROR_ENUM */

#ifndef WL_EGLSTREAM_HANDLE_TYPE_ENUM
#define WL_EGLSTREAM_HANDLE_TYPE_ENUM
/**
 * @ingroup iface_wl_eglstream
 * Stream handle type
 *
 * - fd:     The given handle represents a file descriptor, and the
 * EGLStream connection must be done as described in
 * EGL_KHR_stream_cross_process_fd
 *
 * - inet:   The EGLStream connection must be done using an inet address
 * and port as described in EGL_NV_stream_socket. The given
 * handle can be ignored, but both inet address and port must
 * be given as attributes.
 *
 * - socket: The given handle represents a unix socket, and the EGLStream
 * connection must be done as described in EGL_NV_stream_socket.
 */
enum wl_eglstream_handle_type {
	/**
	 * File descriptor
	 */
	WL_EGLSTREAM_HANDLE_TYPE_FD = 0,
	/**
	 * Inet connection
	 */
	WL_EGLSTREAM_HANDLE_TYPE_INET = 1,
	/**
	 * Unix socket
	 */
	WL_EGLSTREAM_HANDLE_TYPE_SOCKET = 2,
};
#endif /* WL_EGLSTREAM_HANDLE_TYPE_ENUM */

#ifndef WL_EGLSTREAM_ATTRIB_ENUM
#define WL_EGLSTREAM_ATTRIB_ENUM
/**
 * @ingroup iface_wl_eglstream
 * Stream creation attributes
 *
 * - inet_addr:  The given attribute encodes an IPv4 address of a client
 * socket. Both IPv4 address and port must be set at the same
 * time.
 *
 * - inet_port:  The given attribute encodes a port of a client socket.
 * Both IPv4 address and port must be set at the same time.
 *
 * - y_inverted: The given attribute encodes the default value for a
 * stream's image inversion relative to wayland protocol
 * convention. Vulkan apps will be set to 'true', while
 * OpenGL apps will be set to 'false'.
 * NOTE: EGL_NV_stream_origin is the authorative source of
 * truth regarding a stream's frame orientation and should be
 * queried for an accurate value. The given attribute is a
 * 'best guess' fallback mechanism which should only be used
 * when a query to EGL_NV_stream_origin fails.
 */
enum wl_eglstream_attrib {
	/**
	 * Inet IPv4 address
	 */
	WL_EGLSTREAM_ATTRIB_INET_ADDR = 0,
	/**
	 * IP port
	 */
	WL_EGLSTREAM_ATTRIB_INET_PORT = 1,
	/**
	 * Image Y-inversion bit
	 */
	WL_EGLSTREAM_ATTRIB_Y_INVERTED = 2,
};
#endif /* WL_EGLSTREAM_ATTRIB_ENUM */



/** @ingroup iface_wl_eglstream */
static inline void
wl_eglstream_set_user_data(struct wl_eglstream *wl_eglstream, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) wl_eglstream, user_data);
}

/** @ingroup iface_wl_eglstream */
static inline void *
wl_eglstream_get_user_data(struct wl_eglstream *wl_eglstream)
{
	return wl_proxy_get_user_data((struct wl_proxy *) wl_eglstream);
}

static inline uint32_t
wl_eglstream_get_version(struct wl_eglstream *wl_eglstream)
{
	return wl_proxy_get_version((struct wl_proxy *) wl_eglstream);
}

/** @ingroup iface_wl_eglstream */
static inline void
wl_eglstream_destroy(struct wl_eglstream *wl_eglstream)
{
	wl_proxy_destroy((struct wl_proxy *) wl_eglstream);
}

#ifndef WL_EGLSTREAM_DISPLAY_CAP_ENUM
#define WL_EGLSTREAM_DISPLAY_CAP_ENUM
/**
 * @ingroup iface_wl_eglstream_display
 * wl_eglstream_display capability codes
 *
 * This enum values should be used as bit masks.
 *
 * - stream_fd:     The server supports EGLStream connections as described
 * in EGL_KHR_stream_cross_process_fd
 *
 * - stream_inet:   The server supports EGLStream inet connections as
 * described in EGL_NV_stream_socket.
 *
 * - stream_socket: The server supports EGLStream unix socket connections
 * as described in EGL_NV_stream_socket.
 */
enum wl_eglstream_display_cap {
	/**
	 * Stream connection with FD
	 */
	WL_EGLSTREAM_DISPLAY_CAP_STREAM_FD = 1,
	/**
	 * Stream inet connection
	 */
	WL_EGLSTREAM_DISPLAY_CAP_STREAM_INET = 2,
	/**
	 * Stream unix connection
	 */
	WL_EGLSTREAM_DISPLAY_CAP_STREAM_SOCKET = 4,
};
#endif /* WL_EGLSTREAM_DISPLAY_CAP_ENUM */

/**
 * @ingroup iface_wl_eglstream_display
 * @struct wl_eglstream_display_listener
 */
struct wl_eglstream_display_listener {
	/**
	 * Server capabilities event
	 *
	 * The capabilities event is sent out at wl_eglstream_display
	 * binding time. It allows the server to advertise what features it
	 * supports so clients may know what is safe to be used.
	 * @param caps Capabilities mask
	 */
	void (*caps)(void *data,
		     struct wl_eglstream_display *wl_eglstream_display,
		     int32_t caps);
	/**
	 * Server Swap interval override event
	 *
	 * The swapinterval_override event is sent out whenever a client
	 * requests a swapinterval setting through swap_interval() and
	 * there is an override in place that will make such request to be
	 * ignored. The swapinterval_override event will provide the
	 * override value so that the client is made aware of it.
	 * @param swapinterval Server swap interval override value
	 * @param stream wl_buffer corresponding to an EGLStream
	 */
	void (*swapinterval_override)(void *data,
				      struct wl_eglstream_display *wl_eglstream_display,
				      int32_t swapinterval,
				      struct wl_buffer *stream);
};

/**
 * @ingroup iface_wl_eglstream_display
 */
static inline int
wl_eglstream_display_add_listener(struct wl_eglstream_display *wl_eglstream_display,
				  const struct wl_eglstream_display_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) wl_eglstream_display,
				     (void (**)(void)) listener, data);
}

#define WL_EGLSTREAM_DISPLAY_CREATE_STREAM 0
#define WL_EGLSTREAM_DISPLAY_SWAP_INTERVAL 1

/**
 * @ingroup iface_wl_eglstream_display
 */
#define WL_EGLSTREAM_DISPLAY_CAPS_SINCE_VERSION 1
/**
 * @ingroup iface_wl_eglstream_display
 */
#define WL_EGLSTREAM_DISPLAY_SWAPINTERVAL_OVERRIDE_SINCE_VERSION 1

/**
 * @ingroup iface_wl_eglstream_display
 */
#define WL_EGLSTREAM_DISPLAY_CREATE_STREAM_SINCE_VERSION 1
/**
 * @ingroup iface_wl_eglstream_display
 */
#define WL_EGLSTREAM_DISPLAY_SWAP_INTERVAL_SINCE_VERSION 1

/** @ingroup iface_wl_eglstream_display */
static inline void
wl_eglstream_display_set_user_data(struct wl_eglstream_display *wl_eglstream_display, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) wl_eglstream_display, user_data);
}

/** @ingroup iface_wl_eglstream_display */
static inline void *
wl_eglstream_display_get_user_data(struct wl_eglstream_display *wl_eglstream_display)
{
	return wl_proxy_get_user_data((struct wl_proxy *) wl_eglstream_display);
}

static inline uint32_t
wl_eglstream_display_get_version(struct wl_eglstream_display *wl_eglstream_display)
{
	return wl_proxy_get_version((struct wl_proxy *) wl_eglstream_display);
}

/** @ingroup iface_wl_eglstream_display */
static inline void
wl_eglstream_display_destroy(struct wl_eglstream_display *wl_eglstream_display)
{
	wl_proxy_destroy((struct wl_proxy *) wl_eglstream_display);
}

/**
 * @ingroup iface_wl_eglstream_display
 *
 * It contains key-value pairs compatible with intptr_t type. A key must
 * be one of wl_eglstream_display_attrib enumeration values. What a value
 * represents is attribute-specific.
 */
static inline struct wl_buffer *
wl_eglstream_display_create_stream(struct wl_eglstream_display *wl_eglstream_display, int32_t width, int32_t height, int32_t handle, int32_t type, struct wl_array *attribs)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) wl_eglstream_display,
			 WL_EGLSTREAM_DISPLAY_CREATE_STREAM, &wl_buffer_interface, wl_proxy_get_version((struct wl_proxy *) wl_eglstream_display), 0, NULL, width, height, handle, type, attribs);

	return (struct wl_buffer *) id;
}

/**
 * @ingroup iface_wl_eglstream_display
 *
 * Set the swap interval for the consumer of the given EGLStream. The swap
 * interval is silently clamped to the valid range on the server side.
 */
static inline void
wl_eglstream_display_swap_interval(struct wl_eglstream_display *wl_eglstream_display, struct wl_buffer *stream, int32_t interval)
{
	wl_proxy_marshal_flags((struct wl_proxy *) wl_eglstream_display,
			 WL_EGLSTREAM_DISPLAY_SWAP_INTERVAL, NULL, wl_proxy_get_version((struct wl_proxy *) wl_eglstream_display), 0, stream, interval);
}

#ifdef  __cplusplus
}
#endif

#endif
