/* bluez-persona.c generated by valac 0.56.18, the Vala compiler
 * generated from bluez-persona.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *          Arun Raghavan <arun.raghavan@collabora.co.uk>
 *          Jeremy Whiting <jeremy.whiting@collabora.com>
 *          Simon McVittie <simon.mcvittie@collabora.co.uk>
 *          Matthieu Bouron <matthieu.bouron@collabora.com>
 *
 * Based on kf-persona.vala by:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include "bluez.h"
#include "folks/small-set.h"
#include <glib-object.h>
#include "folks/folks.h"
#include <gee.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <libebook-contacts/libebook-contacts.h>
#include "folks-internal.h"
#include "folks/small-set-internal.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	FOLKS_BACKENDS_BLUE_Z_PERSONA_0_PROPERTY,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_LINKABLE_PROPERTIES_PROPERTY,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_URLS_PROPERTY,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_AVATAR_PROPERTY,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_WRITEABLE_PROPERTIES_PROPERTY,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_PHONE_NUMBERS_PROPERTY,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_STRUCTURED_NAME_PROPERTY,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_FULL_NAME_PROPERTY,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_NICKNAME_PROPERTY,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_EMAIL_ADDRESSES_PROPERTY,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_NUM_PROPERTIES
};
static GParamSpec* folks_backends_blue_z_persona_properties[FOLKS_BACKENDS_BLUE_Z_PERSONA_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_EVCardAttribute_free0(var) ((var == NULL) ? NULL : (var = (_vala_EVCardAttribute_free (var), NULL)))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))

struct _FolksBackendsBlueZPersonaPrivate {
	FolksSmallSet* _urls;
	GeeSet* _urls_ro;
	GLoadableIcon* _avatar;
	FolksSmallSet* _phone_numbers;
	GeeSet* _phone_numbers_ro;
	FolksStructuredName* _structured_name;
	gchar* _full_name;
	gchar* _nickname;
	FolksSmallSet* _email_addresses;
	GeeSet* _email_addresses_ro;
};

static gint FolksBackendsBlueZPersona_private_offset;
static gpointer folks_backends_blue_z_persona_parent_class = NULL;
static gchar** folks_backends_blue_z_persona__writeable_properties;
static gint folks_backends_blue_z_persona__writeable_properties_length1;
static gchar** folks_backends_blue_z_persona__writeable_properties = NULL;
static gint folks_backends_blue_z_persona__writeable_properties_length1 = 0;
static gint _folks_backends_blue_z_persona__writeable_properties_size_ = 0;
static FolksAvatarDetailsIface * folks_backends_blue_z_persona_folks_avatar_details_parent_iface = NULL;
static FolksEmailDetailsIface * folks_backends_blue_z_persona_folks_email_details_parent_iface = NULL;
static FolksNameDetailsIface * folks_backends_blue_z_persona_folks_name_details_parent_iface = NULL;
static FolksPhoneDetailsIface * folks_backends_blue_z_persona_folks_phone_details_parent_iface = NULL;
static FolksUrlDetailsIface * folks_backends_blue_z_persona_folks_url_details_parent_iface = NULL;

VALA_EXTERN gboolean folks_backends_blue_z_persona_update_from_vcard (FolksBackendsBlueZPersona* self,
                                                          EVCard* card);
static void _folks_backends_blue_z_persona_update_params (FolksBackendsBlueZPersona* self,
                                                   FolksAbstractFieldDetails* details,
                                                   EVCardAttribute* attr);
static guint _folks_abstract_field_details_hash_static_gee_hash_data_func (gconstpointer v,
                                                                    gpointer self);
static gboolean _folks_abstract_field_details_equal_static_gee_equal_data_func (gconstpointer a,
                                                                         gconstpointer b,
                                                                         gpointer self);
static EVCardAttribute* _vala_EVCardAttribute_copy (EVCardAttribute* self);
static void _vala_EVCardAttribute_free (EVCardAttribute* self);
static void folks_backends_blue_z_persona_real_linkable_property_to_links (FolksPersona* base,
                                                                    const gchar* prop_name,
                                                                    FolksPersonaLinkablePropertyCallback callback,
                                                                    gpointer callback_target);
static GObject * folks_backends_blue_z_persona_constructor (GType type,
                                                     guint n_construct_properties,
                                                     GObjectConstructParam * construct_properties);
static void folks_backends_blue_z_persona_finalize (GObject * obj);
static GType folks_backends_blue_z_persona_get_type_once (void);
static void _vala_folks_backends_blue_z_persona_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_folks_backends_blue_z_persona_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec);

static const gchar* FOLKS_BACKENDS_BLUE_Z_PERSONA__linkable_properties[2] = {"phone-numbers", "email-addresses"};

static inline gpointer
folks_backends_blue_z_persona_get_instance_private (FolksBackendsBlueZPersona* self)
{
	return G_STRUCT_MEMBER_P (self, FolksBackendsBlueZPersona_private_offset);
}

/**
   * Create a new persona.
   *
   * Create a new persona for the {@link PersonaStore} ``store``, representing
   * the Persona in the given ``vcard``.
   *
   * @param vcard the vCard stored as a string
   * @param card a parsed version of the vCard
   * @param store the store to which the Persona belongs.
   * @param is_user whether the Persona is the user itself or not.
   * @param iid pre-calculated IID for the persona
   *
   * @since 0.9.6
   */
FolksBackendsBlueZPersona*
folks_backends_blue_z_persona_construct (GType object_type,
                                         const gchar* vcard,
                                         EVCard* card,
                                         FolksPersonaStore* store,
                                         gboolean is_user,
                                         const gchar* iid)
{
	FolksBackendsBlueZPersona * self = NULL;
	gchar* uid = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (vcard != NULL, NULL);
	g_return_val_if_fail (card != NULL, NULL);
	g_return_val_if_fail (store != NULL, NULL);
	g_return_val_if_fail (iid != NULL, NULL);
	_tmp0_ = folks_persona_store_get_id (store);
	_tmp1_ = _tmp0_;
	_tmp2_ = folks_persona_build_uid ("bluez", _tmp1_, iid);
	uid = _tmp2_;
	self = (FolksBackendsBlueZPersona*) g_object_new (object_type, "display-id", iid, "iid", iid, "uid", uid, "store", store, "is-user", is_user, NULL);
	folks_backends_blue_z_persona_update_from_vcard (self, card);
	_g_free0 (uid);
	return self;
}

FolksBackendsBlueZPersona*
folks_backends_blue_z_persona_new (const gchar* vcard,
                                   EVCard* card,
                                   FolksPersonaStore* store,
                                   gboolean is_user,
                                   const gchar* iid)
{
	return folks_backends_blue_z_persona_construct (FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA, vcard, card, store, is_user, iid);
}

static void
_folks_backends_blue_z_persona_update_params (FolksBackendsBlueZPersona* self,
                                              FolksAbstractFieldDetails* details,
                                              EVCardAttribute* attr)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (details != NULL);
	g_return_if_fail (attr != NULL);
	_tmp0_ = e_vcard_attribute_get_params (attr);
	{
		GList* param_collection = NULL;
		GList* param_it = NULL;
		param_collection = _tmp0_;
		for (param_it = param_collection; param_it != NULL; param_it = param_it->next) {
			EVCardAttributeParam* param = NULL;
			param = (EVCardAttributeParam*) param_it->data;
			{
				EVCardAttributeParam* _tmp1_;
				GList* _tmp2_;
				_tmp1_ = param;
				_tmp2_ = e_vcard_attribute_param_get_values (_tmp1_);
				{
					GList* param_value_collection = NULL;
					GList* param_value_it = NULL;
					param_value_collection = _tmp2_;
					for (param_value_it = param_value_collection; param_value_it != NULL; param_value_it = param_value_it->next) {
						const gchar* param_value = NULL;
						param_value = (const gchar*) param_value_it->data;
						{
							EVCardAttributeParam* _tmp3_;
							const gchar* _tmp4_;
							gchar* _tmp5_;
							gchar* _tmp6_;
							const gchar* _tmp7_;
							gchar* _tmp8_;
							gchar* _tmp9_;
							_tmp3_ = param;
							_tmp4_ = e_vcard_attribute_param_get_name (_tmp3_);
							_tmp5_ = g_utf8_strdown (_tmp4_, (gssize) -1);
							_tmp6_ = _tmp5_;
							_tmp7_ = param_value;
							_tmp8_ = g_utf8_strdown (_tmp7_, (gssize) -1);
							_tmp9_ = _tmp8_;
							folks_abstract_field_details_add_parameter (details, _tmp6_, _tmp9_);
							_g_free0 (_tmp9_);
							_g_free0 (_tmp6_);
						}
					}
				}
			}
		}
	}
}

/**
   * Update the Persona’s properties from a vCard.
   *
   * Parse the given ``vcard`` and set the persona’s properties from it. This
   * emits property change notifications as appropriate.
   *
   * @param vcard pre-parsed vCard
   * @return ``true`` if any properties were changed, ``false`` otherwise
   *
   * @since 0.9.7
   */
static guint
_folks_abstract_field_details_hash_static_gee_hash_data_func (gconstpointer v,
                                                              gpointer self)
{
	guint result;
	result = folks_abstract_field_details_hash_static ((FolksAbstractFieldDetails*) v);
	return result;
}

static gboolean
_folks_abstract_field_details_equal_static_gee_equal_data_func (gconstpointer a,
                                                                gconstpointer b,
                                                                gpointer self)
{
	gboolean result;
	result = folks_abstract_field_details_equal_static ((FolksAbstractFieldDetails*) a, (FolksAbstractFieldDetails*) b);
	return result;
}

static EVCardAttribute*
_vala_EVCardAttribute_copy (EVCardAttribute* self)
{
	return g_boxed_copy (e_vcard_attribute_get_type (), self);
}

static gpointer
__vala_EVCardAttribute_copy0 (gpointer self)
{
	return self ? _vala_EVCardAttribute_copy (self) : NULL;
}

static void
_vala_EVCardAttribute_free (EVCardAttribute* self)
{
	g_boxed_free (e_vcard_attribute_get_type (), self);
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

gboolean
folks_backends_blue_z_persona_update_from_vcard (FolksBackendsBlueZPersona* self,
                                                 EVCard* card)
{
	gboolean properties_changed = FALSE;
	FolksSmallSet* new_phone_numbers = NULL;
	FolksSmallSet* _tmp0_;
	FolksSmallSet* new_uris = NULL;
	FolksSmallSet* _tmp1_;
	FolksSmallSet* new_email_addresses = NULL;
	FolksSmallSet* _tmp2_;
	GBytesIcon* new_avatar = NULL;
	gchar* new_full_name = NULL;
	gchar* _tmp3_;
	gchar* new_nickname = NULL;
	gchar* _tmp4_;
	FolksStructuredName* new_structured_name = NULL;
	GList* attrs = NULL;
	GList* _tmp5_;
	GList* _tmp6_;
	FolksSmallSet* _tmp114_;
	FolksSmallSet* _tmp115_;
	FolksSmallSet* _tmp121_;
	FolksSmallSet* _tmp122_;
	FolksSmallSet* _tmp128_;
	FolksSmallSet* _tmp129_;
	gboolean _tmp135_ = FALSE;
	GBytesIcon* _tmp136_;
	GLoadableIcon* _tmp137_;
	const gchar* _tmp146_;
	const gchar* _tmp147_;
	const gchar* _tmp150_;
	const gchar* _tmp151_;
	gboolean _tmp154_ = FALSE;
	FolksStructuredName* _tmp155_;
	FolksStructuredName* _tmp156_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (card != NULL, FALSE);
	properties_changed = FALSE;
	_tmp0_ = folks_small_set_new (FOLKS_TYPE_PHONE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
	new_phone_numbers = _tmp0_;
	_tmp1_ = folks_small_set_new (FOLKS_TYPE_URL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
	new_uris = _tmp1_;
	_tmp2_ = folks_small_set_new (FOLKS_TYPE_EMAIL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
	new_email_addresses = _tmp2_;
	new_avatar = NULL;
	_tmp3_ = g_strdup ("");
	new_full_name = _tmp3_;
	_tmp4_ = g_strdup ("");
	new_nickname = _tmp4_;
	new_structured_name = NULL;
	_tmp5_ = e_vcard_get_attributes (card);
	attrs = _tmp5_;
	_tmp6_ = attrs;
	{
		GList* attr_collection = NULL;
		GList* attr_it = NULL;
		attr_collection = _tmp6_;
		for (attr_it = attr_collection; attr_it != NULL; attr_it = attr_it->next) {
			EVCardAttribute* _tmp7_;
			EVCardAttribute* attr = NULL;
			_tmp7_ = __vala_EVCardAttribute_copy0 ((EVCardAttribute*) attr_it->data);
			attr = _tmp7_;
			{
				const gchar* attr_name = NULL;
				EVCardAttribute* _tmp8_;
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				_tmp8_ = attr;
				_tmp9_ = e_vcard_attribute_get_name (_tmp8_);
				attr_name = _tmp9_;
				_tmp10_ = attr_name;
				if (g_strcmp0 (_tmp10_, "TEL") == 0) {
					gchar* val = NULL;
					EVCardAttribute* _tmp11_;
					gchar* _tmp12_;
					gboolean _tmp13_ = FALSE;
					const gchar* _tmp14_;
					FolksPhoneFieldDetails* new_field_details = NULL;
					const gchar* _tmp16_;
					FolksPhoneFieldDetails* _tmp17_;
					FolksPhoneFieldDetails* _tmp18_;
					EVCardAttribute* _tmp19_;
					FolksSmallSet* _tmp20_;
					FolksPhoneFieldDetails* _tmp21_;
					_tmp11_ = attr;
					_tmp12_ = e_vcard_attribute_get_value (_tmp11_);
					val = _tmp12_;
					_tmp14_ = val;
					if (_tmp14_ == NULL) {
						_tmp13_ = TRUE;
					} else {
						const gchar* _tmp15_;
						_tmp15_ = val;
						_tmp13_ = g_strcmp0 ((const gchar*) _tmp15_, "") == 0;
					}
					if (_tmp13_) {
						_g_free0 (val);
						__vala_EVCardAttribute_free0 (attr);
						continue;
					}
					_tmp16_ = val;
					_tmp17_ = folks_phone_field_details_new ((const gchar*) _tmp16_, NULL);
					new_field_details = _tmp17_;
					_tmp18_ = new_field_details;
					_tmp19_ = attr;
					_folks_backends_blue_z_persona_update_params (self, (FolksAbstractFieldDetails*) _tmp18_, _tmp19_);
					_tmp20_ = new_phone_numbers;
					_tmp21_ = new_field_details;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, _tmp21_);
					_g_object_unref0 (new_field_details);
					_g_free0 (val);
				} else {
					const gchar* _tmp22_;
					_tmp22_ = attr_name;
					if (g_strcmp0 (_tmp22_, "URL") == 0) {
						gchar* val = NULL;
						EVCardAttribute* _tmp23_;
						gchar* _tmp24_;
						gboolean _tmp25_ = FALSE;
						const gchar* _tmp26_;
						FolksUrlFieldDetails* new_field_details = NULL;
						const gchar* _tmp28_;
						FolksUrlFieldDetails* _tmp29_;
						FolksUrlFieldDetails* _tmp30_;
						EVCardAttribute* _tmp31_;
						FolksSmallSet* _tmp32_;
						FolksUrlFieldDetails* _tmp33_;
						_tmp23_ = attr;
						_tmp24_ = e_vcard_attribute_get_value (_tmp23_);
						val = _tmp24_;
						_tmp26_ = val;
						if (_tmp26_ == NULL) {
							_tmp25_ = TRUE;
						} else {
							const gchar* _tmp27_;
							_tmp27_ = val;
							_tmp25_ = g_strcmp0 ((const gchar*) _tmp27_, "") == 0;
						}
						if (_tmp25_) {
							_g_free0 (val);
							__vala_EVCardAttribute_free0 (attr);
							continue;
						}
						_tmp28_ = val;
						_tmp29_ = folks_url_field_details_new ((const gchar*) _tmp28_, NULL);
						new_field_details = _tmp29_;
						_tmp30_ = new_field_details;
						_tmp31_ = attr;
						_folks_backends_blue_z_persona_update_params (self, (FolksAbstractFieldDetails*) _tmp30_, _tmp31_);
						_tmp32_ = new_uris;
						_tmp33_ = new_field_details;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp32_, _tmp33_);
						_g_object_unref0 (new_field_details);
						_g_free0 (val);
					} else {
						const gchar* _tmp34_;
						_tmp34_ = attr_name;
						if (g_strcmp0 (_tmp34_, "EMAIL") == 0) {
							gchar* val = NULL;
							EVCardAttribute* _tmp35_;
							gchar* _tmp36_;
							gboolean _tmp37_ = FALSE;
							const gchar* _tmp38_;
							FolksEmailFieldDetails* new_field_details = NULL;
							const gchar* _tmp40_;
							FolksEmailFieldDetails* _tmp41_;
							FolksEmailFieldDetails* _tmp42_;
							EVCardAttribute* _tmp43_;
							FolksSmallSet* _tmp44_;
							FolksEmailFieldDetails* _tmp45_;
							_tmp35_ = attr;
							_tmp36_ = e_vcard_attribute_get_value (_tmp35_);
							val = _tmp36_;
							_tmp38_ = val;
							if (_tmp38_ == NULL) {
								_tmp37_ = TRUE;
							} else {
								const gchar* _tmp39_;
								_tmp39_ = val;
								_tmp37_ = g_strcmp0 ((const gchar*) _tmp39_, "") == 0;
							}
							if (_tmp37_) {
								_g_free0 (val);
								__vala_EVCardAttribute_free0 (attr);
								continue;
							}
							_tmp40_ = val;
							_tmp41_ = folks_email_field_details_new ((const gchar*) _tmp40_, NULL);
							new_field_details = _tmp41_;
							_tmp42_ = new_field_details;
							_tmp43_ = attr;
							_folks_backends_blue_z_persona_update_params (self, (FolksAbstractFieldDetails*) _tmp42_, _tmp43_);
							_tmp44_ = new_email_addresses;
							_tmp45_ = new_field_details;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp44_, _tmp45_);
							_g_object_unref0 (new_field_details);
							_g_free0 (val);
						} else {
							const gchar* _tmp46_;
							_tmp46_ = attr_name;
							if (g_strcmp0 (_tmp46_, "PHOTO") == 0) {
								gchar* encoded_data = NULL;
								EVCardAttribute* _tmp47_;
								gchar* _tmp48_;
								gchar* _tmp49_;
								guint8* _tmp50_;
								gint _tmp50__length1;
								gint _tmp51_ = 0;
								guint8* _tmp52_;
								gint _tmp52__length1;
								gchar* _tmp53_;
								gchar* _tmp54_;
								GBytes* bytes = NULL;
								const gchar* _tmp55_;
								gsize _tmp56_ = 0;
								guchar* _tmp57_;
								guchar* _tmp58_;
								gint _tmp58__length1;
								GBytes* _tmp59_;
								GBytes* _tmp60_;
								GBytes* _tmp61_;
								GBytesIcon* _tmp62_;
								_tmp47_ = attr;
								_tmp48_ = e_vcard_attribute_get_value (_tmp47_);
								_tmp49_ = _tmp48_;
								_tmp50_ = string_get_data (_tmp49_, &_tmp51_);
								_tmp50__length1 = _tmp51_;
								_tmp52_ = _tmp50_;
								_tmp52__length1 = _tmp50__length1;
								_tmp53_ = g_strdup ((const gchar*) _tmp52_);
								_tmp54_ = _tmp53_;
								_g_free0 (_tmp49_);
								encoded_data = _tmp54_;
								_tmp55_ = encoded_data;
								_tmp57_ = g_base64_decode (_tmp55_, &_tmp56_);
								_tmp58_ = _tmp57_;
								_tmp58__length1 = _tmp56_;
								_tmp59_ = g_bytes_new (_tmp58_, _tmp56_);
								_tmp60_ = _tmp59_;
								_tmp58_ = (g_free (_tmp58_), NULL);
								bytes = _tmp60_;
								_tmp61_ = bytes;
								_tmp62_ = (GBytesIcon*) g_bytes_icon_new (_tmp61_);
								_g_object_unref0 (new_avatar);
								new_avatar = _tmp62_;
								_g_bytes_unref0 (bytes);
								_g_free0 (encoded_data);
							} else {
								const gchar* _tmp63_;
								_tmp63_ = attr_name;
								if (g_strcmp0 (_tmp63_, "FN") == 0) {
									EVCardAttribute* _tmp64_;
									gchar* _tmp65_;
									_tmp64_ = attr;
									_tmp65_ = e_vcard_attribute_get_value (_tmp64_);
									_g_free0 (new_full_name);
									new_full_name = _tmp65_;
								} else {
									const gchar* _tmp66_;
									_tmp66_ = attr_name;
									if (g_strcmp0 (_tmp66_, "NICKNAME") == 0) {
										EVCardAttribute* _tmp67_;
										gchar* _tmp68_;
										_tmp67_ = attr;
										_tmp68_ = e_vcard_attribute_get_value (_tmp67_);
										_g_free0 (new_nickname);
										new_nickname = _tmp68_;
									} else {
										const gchar* _tmp69_;
										_tmp69_ = attr_name;
										if (g_strcmp0 (_tmp69_, "N") == 0) {
											GList* values = NULL;
											EVCardAttribute* _tmp70_;
											GList* _tmp71_;
											const gchar* family_name = NULL;
											const gchar* given_name = NULL;
											const gchar* additional_names = NULL;
											const gchar* prefixes = NULL;
											const gchar* suffixes = NULL;
											GList* _tmp72_;
											GList* _tmp77_;
											GList* _tmp82_;
											GList* _tmp87_;
											GList* _tmp92_;
											gboolean _tmp97_ = FALSE;
											const gchar* _tmp98_;
											const gchar* _tmp102_;
											const gchar* _tmp103_;
											const gchar* _tmp104_;
											const gchar* _tmp105_;
											const gchar* _tmp106_;
											FolksStructuredName* _tmp107_;
											_tmp70_ = attr;
											_tmp71_ = e_vcard_attribute_get_values (_tmp70_);
											values = _tmp71_;
											family_name = NULL;
											given_name = NULL;
											additional_names = NULL;
											prefixes = NULL;
											suffixes = NULL;
											_tmp72_ = values;
											if (_tmp72_ != NULL) {
												GList* _tmp73_;
												gconstpointer _tmp74_;
												GList* _tmp75_;
												GList* _tmp76_;
												_tmp73_ = values;
												_tmp74_ = _tmp73_->data;
												family_name = (const gchar*) _tmp74_;
												_tmp75_ = values;
												_tmp76_ = _tmp75_->next;
												values = _tmp76_;
											}
											_tmp77_ = values;
											if (_tmp77_ != NULL) {
												GList* _tmp78_;
												gconstpointer _tmp79_;
												GList* _tmp80_;
												GList* _tmp81_;
												_tmp78_ = values;
												_tmp79_ = _tmp78_->data;
												given_name = (const gchar*) _tmp79_;
												_tmp80_ = values;
												_tmp81_ = _tmp80_->next;
												values = _tmp81_;
											}
											_tmp82_ = values;
											if (_tmp82_ != NULL) {
												GList* _tmp83_;
												gconstpointer _tmp84_;
												GList* _tmp85_;
												GList* _tmp86_;
												_tmp83_ = values;
												_tmp84_ = _tmp83_->data;
												additional_names = (const gchar*) _tmp84_;
												_tmp85_ = values;
												_tmp86_ = _tmp85_->next;
												values = _tmp86_;
											}
											_tmp87_ = values;
											if (_tmp87_ != NULL) {
												GList* _tmp88_;
												gconstpointer _tmp89_;
												GList* _tmp90_;
												GList* _tmp91_;
												_tmp88_ = values;
												_tmp89_ = _tmp88_->data;
												prefixes = (const gchar*) _tmp89_;
												_tmp90_ = values;
												_tmp91_ = _tmp90_->next;
												values = _tmp91_;
											}
											_tmp92_ = values;
											if (_tmp92_ != NULL) {
												GList* _tmp93_;
												gconstpointer _tmp94_;
												GList* _tmp95_;
												GList* _tmp96_;
												_tmp93_ = values;
												_tmp94_ = _tmp93_->data;
												suffixes = (const gchar*) _tmp94_;
												_tmp95_ = values;
												_tmp96_ = _tmp95_->next;
												values = _tmp96_;
											}
											_tmp98_ = suffixes;
											if (_tmp98_ == NULL) {
												_tmp97_ = TRUE;
											} else {
												GList* _tmp99_;
												_tmp99_ = values;
												_tmp97_ = _tmp99_ != NULL;
											}
											if (_tmp97_) {
												const gchar* _tmp100_ = NULL;
												const gchar* _tmp101_;
												_tmp101_ = suffixes;
												if (_tmp101_ == NULL) {
													_tmp100_ = "fewer";
												} else {
													_tmp100_ = "more";
												}
												g_debug ("Expected 5 components in N attribute of vCard, " "but got %s.", _tmp100_);
											}
											_tmp102_ = family_name;
											_tmp103_ = given_name;
											_tmp104_ = additional_names;
											_tmp105_ = prefixes;
											_tmp106_ = suffixes;
											_tmp107_ = folks_structured_name_new (_tmp102_, _tmp103_, _tmp104_, _tmp105_, _tmp106_);
											_g_object_unref0 (new_structured_name);
											new_structured_name = _tmp107_;
										} else {
											gboolean _tmp108_ = FALSE;
											const gchar* _tmp109_;
											_tmp109_ = attr_name;
											if (g_strcmp0 (_tmp109_, "VERSION") != 0) {
												const gchar* _tmp110_;
												_tmp110_ = attr_name;
												_tmp108_ = g_strcmp0 (_tmp110_, "UID") != 0;
											} else {
												_tmp108_ = FALSE;
											}
											if (_tmp108_) {
												const gchar* _tmp111_;
												const gchar* _tmp112_;
												const gchar* _tmp113_;
												_tmp111_ = attr_name;
												_tmp112_ = folks_persona_get_uid ((FolksPersona*) self);
												_tmp113_ = _tmp112_;
												g_warning ("bluez-persona.vala:360: Unknown attribute ‘%s’ in vCard for persona %s" \
".", _tmp111_, _tmp113_);
											}
										}
									}
								}
							}
						}
					}
				}
				__vala_EVCardAttribute_free0 (attr);
			}
		}
	}
	g_object_freeze_notify ((GObject*) self);
	_tmp114_ = self->priv->_phone_numbers;
	_tmp115_ = new_phone_numbers;
	if (!folks_utils_set_string_afd_equal ((GeeSet*) _tmp114_, (GeeSet*) _tmp115_)) {
		FolksSmallSet* _tmp116_;
		FolksSmallSet* _tmp117_;
		FolksSmallSet* _tmp118_;
		GeeSet* _tmp119_;
		GeeSet* _tmp120_;
		_tmp116_ = new_phone_numbers;
		_tmp117_ = _g_object_ref0 (_tmp116_);
		_g_object_unref0 (self->priv->_phone_numbers);
		self->priv->_phone_numbers = _tmp117_;
		_tmp118_ = new_phone_numbers;
		_tmp119_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp118_);
		_tmp120_ = _tmp119_;
		_g_object_unref0 (self->priv->_phone_numbers_ro);
		self->priv->_phone_numbers_ro = _tmp120_;
		g_object_notify ((GObject*) self, "phone-numbers");
		properties_changed = TRUE;
	}
	_tmp121_ = self->priv->_urls;
	_tmp122_ = new_uris;
	if (!folks_internal_equal_sets (FOLKS_TYPE_URL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GeeSet*) _tmp121_, (GeeSet*) _tmp122_)) {
		FolksSmallSet* _tmp123_;
		FolksSmallSet* _tmp124_;
		FolksSmallSet* _tmp125_;
		GeeSet* _tmp126_;
		GeeSet* _tmp127_;
		_tmp123_ = new_uris;
		_tmp124_ = _g_object_ref0 (_tmp123_);
		_g_object_unref0 (self->priv->_urls);
		self->priv->_urls = _tmp124_;
		_tmp125_ = new_uris;
		_tmp126_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp125_);
		_tmp127_ = _tmp126_;
		_g_object_unref0 (self->priv->_urls_ro);
		self->priv->_urls_ro = _tmp127_;
		g_object_notify ((GObject*) self, "urls");
		properties_changed = TRUE;
	}
	_tmp128_ = self->priv->_email_addresses;
	_tmp129_ = new_email_addresses;
	if (!folks_internal_equal_sets (FOLKS_TYPE_EMAIL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GeeSet*) _tmp128_, (GeeSet*) _tmp129_)) {
		FolksSmallSet* _tmp130_;
		FolksSmallSet* _tmp131_;
		FolksSmallSet* _tmp132_;
		GeeSet* _tmp133_;
		GeeSet* _tmp134_;
		_tmp130_ = new_email_addresses;
		_tmp131_ = _g_object_ref0 (_tmp130_);
		_g_object_unref0 (self->priv->_email_addresses);
		self->priv->_email_addresses = _tmp131_;
		_tmp132_ = new_email_addresses;
		_tmp133_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp132_);
		_tmp134_ = _tmp133_;
		_g_object_unref0 (self->priv->_email_addresses_ro);
		self->priv->_email_addresses_ro = _tmp134_;
		g_object_notify ((GObject*) self, "email-addresses");
		properties_changed = TRUE;
	}
	_tmp136_ = new_avatar;
	_tmp137_ = self->priv->_avatar;
	if ((_tmp136_ == NULL) != (_tmp137_ == NULL)) {
		_tmp135_ = TRUE;
	} else {
		gboolean _tmp138_ = FALSE;
		gboolean _tmp139_ = FALSE;
		GBytesIcon* _tmp140_;
		_tmp140_ = new_avatar;
		if (_tmp140_ != NULL) {
			GLoadableIcon* _tmp141_;
			_tmp141_ = self->priv->_avatar;
			_tmp139_ = _tmp141_ != NULL;
		} else {
			_tmp139_ = FALSE;
		}
		if (_tmp139_) {
			GBytesIcon* _tmp142_;
			GLoadableIcon* _tmp143_;
			_tmp142_ = new_avatar;
			_tmp143_ = self->priv->_avatar;
			_tmp138_ = !g_icon_equal ((GIcon*) _tmp142_, (GIcon*) _tmp143_);
		} else {
			_tmp138_ = FALSE;
		}
		_tmp135_ = _tmp138_;
	}
	if (_tmp135_) {
		GBytesIcon* _tmp144_;
		GLoadableIcon* _tmp145_;
		_tmp144_ = new_avatar;
		_tmp145_ = _g_object_ref0 ((GLoadableIcon*) _tmp144_);
		_g_object_unref0 (self->priv->_avatar);
		self->priv->_avatar = _tmp145_;
		g_object_notify ((GObject*) self, "avatar");
		properties_changed = TRUE;
	}
	_tmp146_ = self->priv->_full_name;
	_tmp147_ = new_full_name;
	if (g_strcmp0 (_tmp146_, _tmp147_) != 0) {
		const gchar* _tmp148_;
		gchar* _tmp149_;
		_tmp148_ = new_full_name;
		_tmp149_ = g_strdup (_tmp148_);
		_g_free0 (self->priv->_full_name);
		self->priv->_full_name = _tmp149_;
		g_object_notify ((GObject*) self, "full-name");
		properties_changed = TRUE;
	}
	_tmp150_ = self->priv->_nickname;
	_tmp151_ = new_nickname;
	if (g_strcmp0 (_tmp150_, _tmp151_) != 0) {
		const gchar* _tmp152_;
		gchar* _tmp153_;
		_tmp152_ = new_nickname;
		_tmp153_ = g_strdup (_tmp152_);
		_g_free0 (self->priv->_nickname);
		self->priv->_nickname = _tmp153_;
		g_object_notify ((GObject*) self, "nickname");
		properties_changed = TRUE;
	}
	_tmp155_ = new_structured_name;
	_tmp156_ = self->priv->_structured_name;
	if ((_tmp155_ == NULL) != (_tmp156_ == NULL)) {
		_tmp154_ = TRUE;
	} else {
		gboolean _tmp157_ = FALSE;
		gboolean _tmp158_ = FALSE;
		FolksStructuredName* _tmp159_;
		_tmp159_ = new_structured_name;
		if (_tmp159_ != NULL) {
			FolksStructuredName* _tmp160_;
			_tmp160_ = self->priv->_structured_name;
			_tmp158_ = _tmp160_ != NULL;
		} else {
			_tmp158_ = FALSE;
		}
		if (_tmp158_) {
			FolksStructuredName* _tmp161_;
			FolksStructuredName* _tmp162_;
			_tmp161_ = new_structured_name;
			_tmp162_ = self->priv->_structured_name;
			_tmp157_ = !folks_structured_name_equal (_tmp161_, _tmp162_);
		} else {
			_tmp157_ = FALSE;
		}
		_tmp154_ = _tmp157_;
	}
	if (_tmp154_) {
		FolksStructuredName* _tmp163_;
		FolksStructuredName* _tmp164_;
		_tmp163_ = new_structured_name;
		_tmp164_ = _g_object_ref0 (_tmp163_);
		_g_object_unref0 (self->priv->_structured_name);
		self->priv->_structured_name = _tmp164_;
		g_object_notify ((GObject*) self, "structured-name");
		properties_changed = TRUE;
	}
	g_object_thaw_notify ((GObject*) self);
	result = properties_changed;
	_g_object_unref0 (new_structured_name);
	_g_free0 (new_nickname);
	_g_free0 (new_full_name);
	_g_object_unref0 (new_avatar);
	_g_object_unref0 (new_email_addresses);
	_g_object_unref0 (new_uris);
	_g_object_unref0 (new_phone_numbers);
	return result;
}

/**
   * {@inheritDoc}
   *
   * @since 0.9.6
   */
static void
folks_backends_blue_z_persona_real_linkable_property_to_links (FolksPersona* base,
                                                               const gchar* prop_name,
                                                               FolksPersonaLinkablePropertyCallback callback,
                                                               gpointer callback_target)
{
	FolksBackendsBlueZPersona * self;
	self = (FolksBackendsBlueZPersona*) base;
	g_return_if_fail (prop_name != NULL);
	if (g_strcmp0 (prop_name, "phone-numbers") == 0) {
		{
			FolksSmallSet* _phone_number_list = NULL;
			FolksSmallSet* _tmp0_;
			gint _phone_number_size = 0;
			FolksSmallSet* _tmp1_;
			gint _tmp2_;
			gint _tmp3_;
			gint _phone_number_index = 0;
			_tmp0_ = self->priv->_phone_numbers;
			_phone_number_list = _tmp0_;
			_tmp1_ = _phone_number_list;
			_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
			_tmp3_ = _tmp2_;
			_phone_number_size = _tmp3_;
			_phone_number_index = -1;
			while (TRUE) {
				gint _tmp4_;
				gint _tmp5_;
				FolksPhoneFieldDetails* phone_number = NULL;
				FolksSmallSet* _tmp6_;
				gconstpointer _tmp7_;
				FolksPhoneFieldDetails* _tmp8_;
				FolksPhoneFieldDetails* _tmp9_;
				gconstpointer _tmp10_;
				gconstpointer _tmp11_;
				_phone_number_index = _phone_number_index + 1;
				_tmp4_ = _phone_number_index;
				_tmp5_ = _phone_number_size;
				if (!(_tmp4_ < _tmp5_)) {
					break;
				}
				_tmp6_ = _phone_number_list;
				_tmp7_ = folks_small_set_get (_tmp6_, _phone_number_index);
				_tmp8_ = _g_object_ref0 ((FolksPhoneFieldDetails*) _tmp7_);
				phone_number = _tmp8_;
				_tmp9_ = phone_number;
				_tmp10_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp9_);
				_tmp11_ = _tmp10_;
				if (((const gchar*) _tmp11_) != NULL) {
					FolksPhoneFieldDetails* _tmp12_;
					gconstpointer _tmp13_;
					gconstpointer _tmp14_;
					_tmp12_ = phone_number;
					_tmp13_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp12_);
					_tmp14_ = _tmp13_;
					callback ((const gchar*) _tmp14_, callback_target);
				}
				_g_object_unref0 (phone_number);
			}
		}
	} else {
		if (g_strcmp0 (prop_name, "email-addresses") == 0) {
			{
				FolksSmallSet* _email_address_list = NULL;
				FolksSmallSet* _tmp15_;
				gint _email_address_size = 0;
				FolksSmallSet* _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
				gint _email_address_index = 0;
				_tmp15_ = self->priv->_email_addresses;
				_email_address_list = _tmp15_;
				_tmp16_ = _email_address_list;
				_tmp17_ = gee_collection_get_size ((GeeCollection*) _tmp16_);
				_tmp18_ = _tmp17_;
				_email_address_size = _tmp18_;
				_email_address_index = -1;
				while (TRUE) {
					gint _tmp19_;
					gint _tmp20_;
					FolksEmailFieldDetails* email_address = NULL;
					FolksSmallSet* _tmp21_;
					gconstpointer _tmp22_;
					FolksEmailFieldDetails* _tmp23_;
					FolksEmailFieldDetails* _tmp24_;
					gconstpointer _tmp25_;
					gconstpointer _tmp26_;
					_email_address_index = _email_address_index + 1;
					_tmp19_ = _email_address_index;
					_tmp20_ = _email_address_size;
					if (!(_tmp19_ < _tmp20_)) {
						break;
					}
					_tmp21_ = _email_address_list;
					_tmp22_ = folks_small_set_get (_tmp21_, _email_address_index);
					_tmp23_ = _g_object_ref0 ((FolksEmailFieldDetails*) _tmp22_);
					email_address = _tmp23_;
					_tmp24_ = email_address;
					_tmp25_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp24_);
					_tmp26_ = _tmp25_;
					if (((const gchar*) _tmp26_) != NULL) {
						FolksEmailFieldDetails* _tmp27_;
						gconstpointer _tmp28_;
						gconstpointer _tmp29_;
						_tmp27_ = email_address;
						_tmp28_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp27_);
						_tmp29_ = _tmp28_;
						callback ((const gchar*) _tmp29_, callback_target);
					}
					_g_object_unref0 (email_address);
				}
			}
		} else {
			FOLKS_PERSONA_CLASS (folks_backends_blue_z_persona_parent_class)->linkable_property_to_links (G_TYPE_CHECK_INSTANCE_CAST (self, FOLKS_TYPE_PERSONA, FolksPersona), prop_name, callback, callback_target);
		}
	}
}

static gchar**
folks_backends_blue_z_persona_real_get_linkable_properties (FolksPersona* base,
                                                            gint* result_length1)
{
	gchar** result;
	FolksBackendsBlueZPersona* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	self = (FolksBackendsBlueZPersona*) base;
	_tmp0_ = FOLKS_BACKENDS_BLUE_Z_PERSONA__linkable_properties;
	_tmp0__length1 = G_N_ELEMENTS (FOLKS_BACKENDS_BLUE_Z_PERSONA__linkable_properties);
	if (result_length1) {
		*result_length1 = _tmp0__length1;
	}
	result = _tmp0_;
	return result;
}

static GeeSet*
folks_backends_blue_z_persona_real_get_urls (FolksUrlDetails* base)
{
	GeeSet* result;
	FolksBackendsBlueZPersona* self;
	GeeSet* _tmp0_;
	self = (FolksBackendsBlueZPersona*) base;
	_tmp0_ = self->priv->_urls_ro;
	result = _tmp0_;
	return result;
}

static void
folks_backends_blue_z_persona_real_set_urls (FolksUrlDetails* base,
                                             GeeSet* value)
{
	FolksBackendsBlueZPersona* self;
	self = (FolksBackendsBlueZPersona*) base;
	folks_url_details_change_urls ((FolksUrlDetails*) self, value, NULL, NULL);
}

static GLoadableIcon*
folks_backends_blue_z_persona_real_get_avatar (FolksAvatarDetails* base)
{
	GLoadableIcon* result;
	FolksBackendsBlueZPersona* self;
	GLoadableIcon* _tmp0_;
	self = (FolksBackendsBlueZPersona*) base;
	_tmp0_ = self->priv->_avatar;
	result = _tmp0_;
	return result;
}

static void
folks_backends_blue_z_persona_real_set_avatar (FolksAvatarDetails* base,
                                               GLoadableIcon* value)
{
	FolksBackendsBlueZPersona* self;
	self = (FolksBackendsBlueZPersona*) base;
	folks_avatar_details_change_avatar ((FolksAvatarDetails*) self, value, NULL, NULL);
}

static gchar**
folks_backends_blue_z_persona_real_get_writeable_properties (FolksPersona* base,
                                                             gint* result_length1)
{
	gchar** result;
	FolksBackendsBlueZPersona* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	self = (FolksBackendsBlueZPersona*) base;
	_tmp0_ = folks_backends_blue_z_persona__writeable_properties;
	_tmp0__length1 = folks_backends_blue_z_persona__writeable_properties_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static GeeSet*
folks_backends_blue_z_persona_real_get_phone_numbers (FolksPhoneDetails* base)
{
	GeeSet* result;
	FolksBackendsBlueZPersona* self;
	GeeSet* _tmp0_;
	self = (FolksBackendsBlueZPersona*) base;
	_tmp0_ = self->priv->_phone_numbers_ro;
	result = _tmp0_;
	return result;
}

static void
folks_backends_blue_z_persona_real_set_phone_numbers (FolksPhoneDetails* base,
                                                      GeeSet* value)
{
	FolksBackendsBlueZPersona* self;
	self = (FolksBackendsBlueZPersona*) base;
	folks_phone_details_change_phone_numbers ((FolksPhoneDetails*) self, value, NULL, NULL);
}

static FolksStructuredName*
folks_backends_blue_z_persona_real_get_structured_name (FolksNameDetails* base)
{
	FolksStructuredName* result;
	FolksBackendsBlueZPersona* self;
	FolksStructuredName* _tmp0_;
	self = (FolksBackendsBlueZPersona*) base;
	_tmp0_ = self->priv->_structured_name;
	result = _tmp0_;
	return result;
}

static void
folks_backends_blue_z_persona_real_set_structured_name (FolksNameDetails* base,
                                                        FolksStructuredName* value)
{
	FolksBackendsBlueZPersona* self;
	self = (FolksBackendsBlueZPersona*) base;
	folks_name_details_change_structured_name ((FolksNameDetails*) self, value, NULL, NULL);
}

static const gchar*
folks_backends_blue_z_persona_real_get_full_name (FolksNameDetails* base)
{
	const gchar* result;
	FolksBackendsBlueZPersona* self;
	const gchar* _tmp0_;
	self = (FolksBackendsBlueZPersona*) base;
	_tmp0_ = self->priv->_full_name;
	result = _tmp0_;
	return result;
}

static void
folks_backends_blue_z_persona_real_set_full_name (FolksNameDetails* base,
                                                  const gchar* value)
{
	FolksBackendsBlueZPersona* self;
	self = (FolksBackendsBlueZPersona*) base;
	folks_name_details_change_full_name ((FolksNameDetails*) self, value, NULL, NULL);
}

static const gchar*
folks_backends_blue_z_persona_real_get_nickname (FolksNameDetails* base)
{
	const gchar* result;
	FolksBackendsBlueZPersona* self;
	const gchar* _tmp0_;
	self = (FolksBackendsBlueZPersona*) base;
	_tmp0_ = self->priv->_nickname;
	result = _tmp0_;
	return result;
}

static void
folks_backends_blue_z_persona_real_set_nickname (FolksNameDetails* base,
                                                 const gchar* value)
{
	FolksBackendsBlueZPersona* self;
	self = (FolksBackendsBlueZPersona*) base;
	folks_name_details_change_nickname ((FolksNameDetails*) self, value, NULL, NULL);
}

static GeeSet*
folks_backends_blue_z_persona_real_get_email_addresses (FolksEmailDetails* base)
{
	GeeSet* result;
	FolksBackendsBlueZPersona* self;
	GeeSet* _tmp0_;
	self = (FolksBackendsBlueZPersona*) base;
	_tmp0_ = self->priv->_email_addresses_ro;
	result = _tmp0_;
	return result;
}

static void
folks_backends_blue_z_persona_real_set_email_addresses (FolksEmailDetails* base,
                                                        GeeSet* value)
{
	FolksBackendsBlueZPersona* self;
	self = (FolksBackendsBlueZPersona*) base;
	folks_email_details_change_email_addresses ((FolksEmailDetails*) self, value, NULL, NULL);
}

static GObject *
folks_backends_blue_z_persona_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FolksBackendsBlueZPersona * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	FolksSmallSet* _tmp4_;
	FolksSmallSet* _tmp5_;
	GeeSet* _tmp6_;
	GeeSet* _tmp7_;
	FolksSmallSet* _tmp8_;
	FolksSmallSet* _tmp9_;
	GeeSet* _tmp10_;
	GeeSet* _tmp11_;
	FolksSmallSet* _tmp12_;
	FolksSmallSet* _tmp13_;
	GeeSet* _tmp14_;
	GeeSet* _tmp15_;
	parent_class = G_OBJECT_CLASS (folks_backends_blue_z_persona_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA, FolksBackendsBlueZPersona);
	_tmp0_ = folks_persona_get_uid ((FolksPersona*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = folks_persona_get_iid ((FolksPersona*) self);
	_tmp3_ = _tmp2_;
	g_debug ("bluez-persona.vala:204: Adding BlueZ Persona '%s' (IID '%s')", _tmp1_, _tmp3_);
	_tmp4_ = folks_small_set_new (FOLKS_TYPE_PHONE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
	_g_object_unref0 (self->priv->_phone_numbers);
	self->priv->_phone_numbers = _tmp4_;
	_tmp5_ = self->priv->_phone_numbers;
	_tmp6_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp5_);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (self->priv->_phone_numbers_ro);
	self->priv->_phone_numbers_ro = _tmp7_;
	_tmp8_ = folks_small_set_new (FOLKS_TYPE_EMAIL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
	_g_object_unref0 (self->priv->_email_addresses);
	self->priv->_email_addresses = _tmp8_;
	_tmp9_ = self->priv->_email_addresses;
	_tmp10_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp9_);
	_tmp11_ = _tmp10_;
	_g_object_unref0 (self->priv->_email_addresses_ro);
	self->priv->_email_addresses_ro = _tmp11_;
	_tmp12_ = folks_small_set_new (FOLKS_TYPE_URL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
	_g_object_unref0 (self->priv->_urls);
	self->priv->_urls = _tmp12_;
	_tmp13_ = self->priv->_urls;
	_tmp14_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp13_);
	_tmp15_ = _tmp14_;
	_g_object_unref0 (self->priv->_urls_ro);
	self->priv->_urls_ro = _tmp15_;
	return obj;
}

static void
folks_backends_blue_z_persona_class_init (FolksBackendsBlueZPersonaClass * klass,
                                          gpointer klass_data)
{
	gchar** _tmp0_;
	folks_backends_blue_z_persona_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FolksBackendsBlueZPersona_private_offset);
	((FolksPersonaClass *) klass)->linkable_property_to_links = (void (*) (FolksPersona*, const gchar*, FolksPersonaLinkablePropertyCallback, gpointer)) folks_backends_blue_z_persona_real_linkable_property_to_links;
	FOLKS_PERSONA_CLASS (klass)->get_linkable_properties = (gchar** (*) (FolksPersona*, gint*)) folks_backends_blue_z_persona_real_get_linkable_properties;
	FOLKS_PERSONA_CLASS (klass)->get_writeable_properties = (gchar** (*) (FolksPersona*, gint*)) folks_backends_blue_z_persona_real_get_writeable_properties;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_backends_blue_z_persona_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_backends_blue_z_persona_set_property;
	G_OBJECT_CLASS (klass)->constructor = folks_backends_blue_z_persona_constructor;
	G_OBJECT_CLASS (klass)->finalize = folks_backends_blue_z_persona_finalize;
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_LINKABLE_PROPERTIES_PROPERTY, folks_backends_blue_z_persona_properties[FOLKS_BACKENDS_BLUE_Z_PERSONA_LINKABLE_PROPERTIES_PROPERTY] = g_param_spec_boxed ("linkable-properties", "linkable-properties", "linkable-properties", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_URLS_PROPERTY, folks_backends_blue_z_persona_properties[FOLKS_BACKENDS_BLUE_Z_PERSONA_URLS_PROPERTY] = g_param_spec_object ("urls", "urls", "urls", GEE_TYPE_SET, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	/**
	  * {@inheritDoc}
	  *
	  * @since 0.9.6
	  */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_AVATAR_PROPERTY, folks_backends_blue_z_persona_properties[FOLKS_BACKENDS_BLUE_Z_PERSONA_AVATAR_PROPERTY] = g_param_spec_object ("avatar", "avatar", "avatar", g_loadable_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	/**
	  * {@inheritDoc}
	  *
	  * @since 0.9.6
	  */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_WRITEABLE_PROPERTIES_PROPERTY, folks_backends_blue_z_persona_properties[FOLKS_BACKENDS_BLUE_Z_PERSONA_WRITEABLE_PROPERTIES_PROPERTY] = g_param_spec_boxed ("writeable-properties", "writeable-properties", "writeable-properties", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_PHONE_NUMBERS_PROPERTY, folks_backends_blue_z_persona_properties[FOLKS_BACKENDS_BLUE_Z_PERSONA_PHONE_NUMBERS_PROPERTY] = g_param_spec_object ("phone-numbers", "phone-numbers", "phone-numbers", GEE_TYPE_SET, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_STRUCTURED_NAME_PROPERTY, folks_backends_blue_z_persona_properties[FOLKS_BACKENDS_BLUE_Z_PERSONA_STRUCTURED_NAME_PROPERTY] = g_param_spec_object ("structured-name", "structured-name", "structured-name", FOLKS_TYPE_STRUCTURED_NAME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_FULL_NAME_PROPERTY, folks_backends_blue_z_persona_properties[FOLKS_BACKENDS_BLUE_Z_PERSONA_FULL_NAME_PROPERTY] = g_param_spec_string ("full-name", "full-name", "full-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_NICKNAME_PROPERTY, folks_backends_blue_z_persona_properties[FOLKS_BACKENDS_BLUE_Z_PERSONA_NICKNAME_PROPERTY] = g_param_spec_string ("nickname", "nickname", "nickname", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_EMAIL_ADDRESSES_PROPERTY, folks_backends_blue_z_persona_properties[FOLKS_BACKENDS_BLUE_Z_PERSONA_EMAIL_ADDRESSES_PROPERTY] = g_param_spec_object ("email-addresses", "email-addresses", "email-addresses", GEE_TYPE_SET, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	folks_backends_blue_z_persona__writeable_properties = _tmp0_;
	folks_backends_blue_z_persona__writeable_properties_length1 = 0;
	_folks_backends_blue_z_persona__writeable_properties_size_ = folks_backends_blue_z_persona__writeable_properties_length1;
}

static void
folks_backends_blue_z_persona_folks_avatar_details_interface_init (FolksAvatarDetailsIface * iface,
                                                                   gpointer iface_data)
{
	folks_backends_blue_z_persona_folks_avatar_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_avatar = folks_backends_blue_z_persona_real_get_avatar;
	iface->set_avatar = folks_backends_blue_z_persona_real_set_avatar;
}

static void
folks_backends_blue_z_persona_folks_email_details_interface_init (FolksEmailDetailsIface * iface,
                                                                  gpointer iface_data)
{
	folks_backends_blue_z_persona_folks_email_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_email_addresses = folks_backends_blue_z_persona_real_get_email_addresses;
	iface->set_email_addresses = folks_backends_blue_z_persona_real_set_email_addresses;
}

static void
folks_backends_blue_z_persona_folks_name_details_interface_init (FolksNameDetailsIface * iface,
                                                                 gpointer iface_data)
{
	folks_backends_blue_z_persona_folks_name_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_structured_name = folks_backends_blue_z_persona_real_get_structured_name;
	iface->set_structured_name = folks_backends_blue_z_persona_real_set_structured_name;
	iface->get_full_name = folks_backends_blue_z_persona_real_get_full_name;
	iface->set_full_name = folks_backends_blue_z_persona_real_set_full_name;
	iface->get_nickname = folks_backends_blue_z_persona_real_get_nickname;
	iface->set_nickname = folks_backends_blue_z_persona_real_set_nickname;
}

static void
folks_backends_blue_z_persona_folks_phone_details_interface_init (FolksPhoneDetailsIface * iface,
                                                                  gpointer iface_data)
{
	folks_backends_blue_z_persona_folks_phone_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_phone_numbers = folks_backends_blue_z_persona_real_get_phone_numbers;
	iface->set_phone_numbers = folks_backends_blue_z_persona_real_set_phone_numbers;
}

static void
folks_backends_blue_z_persona_folks_url_details_interface_init (FolksUrlDetailsIface * iface,
                                                                gpointer iface_data)
{
	folks_backends_blue_z_persona_folks_url_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_urls = folks_backends_blue_z_persona_real_get_urls;
	iface->set_urls = folks_backends_blue_z_persona_real_set_urls;
}

static void
folks_backends_blue_z_persona_instance_init (FolksBackendsBlueZPersona * self,
                                             gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = folks_backends_blue_z_persona_get_instance_private (self);
	self->priv->_urls = NULL;
	self->priv->_avatar = NULL;
	self->priv->_phone_numbers = NULL;
	self->priv->_structured_name = NULL;
	_tmp0_ = g_strdup ("");
	self->priv->_full_name = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_nickname = _tmp1_;
	self->priv->_email_addresses = NULL;
}

static void
folks_backends_blue_z_persona_finalize (GObject * obj)
{
	FolksBackendsBlueZPersona * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA, FolksBackendsBlueZPersona);
	_g_object_unref0 (self->priv->_urls);
	_g_object_unref0 (self->priv->_urls_ro);
	_g_object_unref0 (self->priv->_avatar);
	_g_object_unref0 (self->priv->_phone_numbers);
	_g_object_unref0 (self->priv->_phone_numbers_ro);
	_g_object_unref0 (self->priv->_structured_name);
	_g_free0 (self->priv->_full_name);
	_g_free0 (self->priv->_nickname);
	_g_object_unref0 (self->priv->_email_addresses);
	_g_object_unref0 (self->priv->_email_addresses_ro);
	G_OBJECT_CLASS (folks_backends_blue_z_persona_parent_class)->finalize (obj);
}

/**
 * A persona subclass which represents a single persona from a simple key file.
 *
 * @since 0.9.6
 */
static GType
folks_backends_blue_z_persona_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksBackendsBlueZPersonaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_backends_blue_z_persona_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksBackendsBlueZPersona), 0, (GInstanceInitFunc) folks_backends_blue_z_persona_instance_init, NULL };
	static const GInterfaceInfo folks_avatar_details_info = { (GInterfaceInitFunc) folks_backends_blue_z_persona_folks_avatar_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo folks_email_details_info = { (GInterfaceInitFunc) folks_backends_blue_z_persona_folks_email_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo folks_name_details_info = { (GInterfaceInitFunc) folks_backends_blue_z_persona_folks_name_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo folks_phone_details_info = { (GInterfaceInitFunc) folks_backends_blue_z_persona_folks_phone_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo folks_url_details_info = { (GInterfaceInitFunc) folks_backends_blue_z_persona_folks_url_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType folks_backends_blue_z_persona_type_id;
	folks_backends_blue_z_persona_type_id = g_type_register_static (FOLKS_TYPE_PERSONA, "FolksBackendsBlueZPersona", &g_define_type_info, 0);
	g_type_add_interface_static (folks_backends_blue_z_persona_type_id, FOLKS_TYPE_AVATAR_DETAILS, &folks_avatar_details_info);
	g_type_add_interface_static (folks_backends_blue_z_persona_type_id, FOLKS_TYPE_EMAIL_DETAILS, &folks_email_details_info);
	g_type_add_interface_static (folks_backends_blue_z_persona_type_id, FOLKS_TYPE_NAME_DETAILS, &folks_name_details_info);
	g_type_add_interface_static (folks_backends_blue_z_persona_type_id, FOLKS_TYPE_PHONE_DETAILS, &folks_phone_details_info);
	g_type_add_interface_static (folks_backends_blue_z_persona_type_id, FOLKS_TYPE_URL_DETAILS, &folks_url_details_info);
	FolksBackendsBlueZPersona_private_offset = g_type_add_instance_private (folks_backends_blue_z_persona_type_id, sizeof (FolksBackendsBlueZPersonaPrivate));
	return folks_backends_blue_z_persona_type_id;
}

GType
folks_backends_blue_z_persona_get_type (void)
{
	static volatile gsize folks_backends_blue_z_persona_type_id__once = 0;
	if (g_once_init_enter (&folks_backends_blue_z_persona_type_id__once)) {
		GType folks_backends_blue_z_persona_type_id;
		folks_backends_blue_z_persona_type_id = folks_backends_blue_z_persona_get_type_once ();
		g_once_init_leave (&folks_backends_blue_z_persona_type_id__once, folks_backends_blue_z_persona_type_id);
	}
	return folks_backends_blue_z_persona_type_id__once;
}

static void
_vala_folks_backends_blue_z_persona_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	FolksBackendsBlueZPersona * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA, FolksBackendsBlueZPersona);
	switch (property_id) {
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_LINKABLE_PROPERTIES_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, folks_persona_get_linkable_properties ((FolksPersona*) self, &length));
		}
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_URLS_PROPERTY:
		g_value_set_object (value, folks_url_details_get_urls ((FolksUrlDetails*) self));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_AVATAR_PROPERTY:
		g_value_set_object (value, folks_avatar_details_get_avatar ((FolksAvatarDetails*) self));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_WRITEABLE_PROPERTIES_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, folks_persona_get_writeable_properties ((FolksPersona*) self, &length));
		}
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_PHONE_NUMBERS_PROPERTY:
		g_value_set_object (value, folks_phone_details_get_phone_numbers ((FolksPhoneDetails*) self));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_STRUCTURED_NAME_PROPERTY:
		g_value_set_object (value, folks_name_details_get_structured_name ((FolksNameDetails*) self));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_FULL_NAME_PROPERTY:
		g_value_set_string (value, folks_name_details_get_full_name ((FolksNameDetails*) self));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_NICKNAME_PROPERTY:
		g_value_set_string (value, folks_name_details_get_nickname ((FolksNameDetails*) self));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_EMAIL_ADDRESSES_PROPERTY:
		g_value_set_object (value, folks_email_details_get_email_addresses ((FolksEmailDetails*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_folks_backends_blue_z_persona_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec)
{
	FolksBackendsBlueZPersona * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA, FolksBackendsBlueZPersona);
	switch (property_id) {
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_URLS_PROPERTY:
		folks_url_details_set_urls ((FolksUrlDetails*) self, g_value_get_object (value));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_AVATAR_PROPERTY:
		folks_avatar_details_set_avatar ((FolksAvatarDetails*) self, g_value_get_object (value));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_PHONE_NUMBERS_PROPERTY:
		folks_phone_details_set_phone_numbers ((FolksPhoneDetails*) self, g_value_get_object (value));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_STRUCTURED_NAME_PROPERTY:
		folks_name_details_set_structured_name ((FolksNameDetails*) self, g_value_get_object (value));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_FULL_NAME_PROPERTY:
		folks_name_details_set_full_name ((FolksNameDetails*) self, g_value_get_string (value));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_NICKNAME_PROPERTY:
		folks_name_details_set_nickname ((FolksNameDetails*) self, g_value_get_string (value));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_EMAIL_ADDRESSES_PROPERTY:
		folks_email_details_set_email_addresses ((FolksEmailDetails*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

