/* Paned.c generated by valac 0.56.18, the Vala compiler
 * generated from Paned.vala, do not modify */

/* Paned.vala
 *
 * Copyright (C) 2009-2024 Jerry Casiano
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.
 *
 * If not, see <http://www.gnu.org/licenses/gpl-3.0.txt>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include "font-manager.h"
#include <gio/gio.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FONT_MANAGER_TYPE_PANED (font_manager_paned_get_type ())
#define FONT_MANAGER_PANED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_PANED, FontManagerPaned))
#define FONT_MANAGER_PANED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_PANED, FontManagerPanedClass))
#define FONT_MANAGER_IS_PANED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_PANED))
#define FONT_MANAGER_IS_PANED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_PANED))
#define FONT_MANAGER_PANED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_PANED, FontManagerPanedClass))

typedef struct _FontManagerPaned FontManagerPaned;
typedef struct _FontManagerPanedClass FontManagerPanedClass;
typedef struct _FontManagerPanedPrivate FontManagerPanedPrivate;
enum  {
	FONT_MANAGER_PANED_0_PROPERTY,
	FONT_MANAGER_PANED_POSITION_PROPERTY,
	FONT_MANAGER_PANED_ORIENTATION_PROPERTY,
	FONT_MANAGER_PANED_NUM_PROPERTIES
};
static GParamSpec* font_manager_paned_properties[FONT_MANAGER_PANED_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define FONT_MANAGER_TYPE_DUAL_PANED (font_manager_dual_paned_get_type ())
#define FONT_MANAGER_DUAL_PANED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_DUAL_PANED, FontManagerDualPaned))
#define FONT_MANAGER_DUAL_PANED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_DUAL_PANED, FontManagerDualPanedClass))
#define FONT_MANAGER_IS_DUAL_PANED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_DUAL_PANED))
#define FONT_MANAGER_IS_DUAL_PANED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_DUAL_PANED))
#define FONT_MANAGER_DUAL_PANED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_DUAL_PANED, FontManagerDualPanedClass))

typedef struct _FontManagerDualPaned FontManagerDualPaned;
typedef struct _FontManagerDualPanedClass FontManagerDualPanedClass;
typedef struct _FontManagerDualPanedPrivate FontManagerDualPanedPrivate;
enum  {
	FONT_MANAGER_DUAL_PANED_0_PROPERTY,
	FONT_MANAGER_DUAL_PANED_SETTINGS_PROPERTY,
	FONT_MANAGER_DUAL_PANED_ORIENTATION_PROPERTY,
	FONT_MANAGER_DUAL_PANED_SIDEBAR_POSITION_PROPERTY,
	FONT_MANAGER_DUAL_PANED_CONTENT_POSITION_PROPERTY,
	FONT_MANAGER_DUAL_PANED_CONTENT_SIZE_PROPERTY,
	FONT_MANAGER_DUAL_PANED_SIDEBAR_SIZE_PROPERTY,
	FONT_MANAGER_DUAL_PANED_HOR_CONTENT_SIZE_PROPERTY,
	FONT_MANAGER_DUAL_PANED_HOR_SIDEBAR_SIZE_PROPERTY,
	FONT_MANAGER_DUAL_PANED_NUM_PROPERTIES
};
static GParamSpec* font_manager_dual_paned_properties[FONT_MANAGER_DUAL_PANED_NUM_PROPERTIES];

struct _FontManagerPaned {
	GtkWidget parent_instance;
	FontManagerPanedPrivate * priv;
};

struct _FontManagerPanedClass {
	GtkWidgetClass parent_class;
};

struct _FontManagerPanedPrivate {
	gdouble _position;
	GtkOrientation _orientation;
	GtkPaned* child;
};

struct _FontManagerDualPaned {
	GtkWidget parent_instance;
	FontManagerDualPanedPrivate * priv;
	GtkOverlay* overlay;
};

struct _FontManagerDualPanedClass {
	GtkWidgetClass parent_class;
	void (*on_map) (FontManagerDualPaned* self);
};

struct _FontManagerDualPanedPrivate {
	GSettings* _settings;
	GtkOrientation _orientation;
	gdouble _content_size;
	gdouble _sidebar_size;
	gdouble _hor_content_size;
	gdouble _hor_sidebar_size;
	FontManagerPaned* main_pane;
	FontManagerPaned* content_pane;
	GtkBox* content_area;
	GtkBox* list_area;
	GtkBox* sidebar_area;
};

static gint FontManagerPaned_private_offset;
static gpointer font_manager_paned_parent_class = NULL;
static gint FontManagerDualPaned_private_offset;
static gpointer font_manager_dual_paned_parent_class = NULL;

VALA_EXTERN GType font_manager_paned_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerPaned, g_object_unref)
VALA_EXTERN GtkWidget* font_manager_paned_get_start_child (FontManagerPaned* self);
VALA_EXTERN GtkWidget* font_manager_paned_get_end_child (FontManagerPaned* self);
VALA_EXTERN void font_manager_paned_set_start_child (FontManagerPaned* self,
                                         GtkWidget* widget);
VALA_EXTERN void font_manager_paned_set_end_child (FontManagerPaned* self,
                                       GtkWidget* widget);
static void font_manager_paned_on_map (FontManagerPaned* self);
static gboolean __lambda4_ (FontManagerPaned* self);
static void font_manager_paned_on_position_set (FontManagerPaned* self);
static gboolean ___lambda4__gsource_func (gpointer self);
static gboolean __lambda5_ (FontManagerPaned* self);
static gboolean ___lambda5__gsource_func (gpointer self);
static gint font_manager_paned_get_alloc (FontManagerPaned* self);
VALA_EXTERN GtkOrientation font_manager_paned_get_orientation (FontManagerPaned* self);
VALA_EXTERN gdouble font_manager_paned_get_position (FontManagerPaned* self);
static void font_manager_paned_on_child_position_changed (FontManagerPaned* self);
VALA_EXTERN void font_manager_paned_set_position (FontManagerPaned* self,
                                      gdouble value);
VALA_EXTERN FontManagerPaned* font_manager_paned_new (void);
VALA_EXTERN FontManagerPaned* font_manager_paned_construct (GType object_type);
VALA_EXTERN void font_manager_paned_set_orientation (FontManagerPaned* self,
                                         GtkOrientation value);
static GObject * font_manager_paned_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static void _font_manager_paned_on_position_set_g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self);
static void _font_manager_paned_on_child_position_changed_g_object_notify (GObject* _sender,
                                                                    GParamSpec* pspec,
                                                                    gpointer self);
static void _font_manager_paned_on_map_gtk_widget_map (GtkWidget* _sender,
                                                gpointer self);
static void font_manager_paned_finalize (GObject * obj);
static GType font_manager_paned_get_type_once (void);
static void _vala_font_manager_paned_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_font_manager_paned_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
VALA_EXTERN GType font_manager_dual_paned_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerDualPaned, g_object_unref)
VALA_EXTERN void font_manager_dual_paned_on_map (FontManagerDualPaned* self);
VALA_EXTERN FontManagerDualPaned* font_manager_dual_paned_new (GSettings* settings);
VALA_EXTERN FontManagerDualPaned* font_manager_dual_paned_construct (GType object_type,
                                                         GSettings* settings);
static void __lambda6_ (FontManagerDualPaned* self,
                 GObject* obj,
                 GParamSpec* pspec);
VALA_EXTERN GtkOrientation font_manager_dual_paned_get_orientation (FontManagerDualPaned* self);
VALA_EXTERN void font_manager_dual_paned_set_hor_sidebar_size (FontManagerDualPaned* self,
                                                   gdouble value);
VALA_EXTERN void font_manager_dual_paned_set_sidebar_size (FontManagerDualPaned* self,
                                               gdouble value);
static void ___lambda6__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void __lambda7_ (FontManagerDualPaned* self,
                 GObject* obj,
                 GParamSpec* pspec);
VALA_EXTERN void font_manager_dual_paned_set_hor_content_size (FontManagerDualPaned* self,
                                                   gdouble value);
VALA_EXTERN void font_manager_dual_paned_set_content_size (FontManagerDualPaned* self,
                                               gdouble value);
static void ___lambda7__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void __lambda8_ (FontManagerDualPaned* self);
VALA_EXTERN gdouble font_manager_dual_paned_get_hor_sidebar_size (FontManagerDualPaned* self);
VALA_EXTERN gdouble font_manager_dual_paned_get_hor_content_size (FontManagerDualPaned* self);
VALA_EXTERN gdouble font_manager_dual_paned_get_sidebar_size (FontManagerDualPaned* self);
VALA_EXTERN gdouble font_manager_dual_paned_get_content_size (FontManagerDualPaned* self);
static void ___lambda8__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void _font_manager_dual_paned_on_map_gtk_widget_map (GtkWidget* _sender,
                                                     gpointer self);
static void font_manager_dual_paned_real_on_map (FontManagerDualPaned* self);
VALA_EXTERN GSettings* font_manager_dual_paned_get_settings (FontManagerDualPaned* self);
VALA_EXTERN void font_manager_dual_paned_set_sidebar_position (FontManagerDualPaned* self,
                                                   gdouble value);
VALA_EXTERN void font_manager_dual_paned_set_content_position (FontManagerDualPaned* self,
                                                   gdouble value);
VALA_EXTERN GtkWidget* font_manager_dual_paned_get_content_widget (FontManagerDualPaned* self);
VALA_EXTERN GtkWidget* font_manager_dual_paned_get_list_widget (FontManagerDualPaned* self);
VALA_EXTERN GtkWidget* font_manager_dual_paned_get_sidebar_widget (FontManagerDualPaned* self);
VALA_EXTERN void font_manager_dual_paned_set_content_widget (FontManagerDualPaned* self,
                                                 GtkWidget* widget);
static void font_manager_dual_paned_set_child (FontManagerDualPaned* self,
                                        GtkBox* parent,
                                        GtkWidget* child);
VALA_EXTERN void font_manager_dual_paned_set_list_widget (FontManagerDualPaned* self,
                                              GtkWidget* widget);
VALA_EXTERN void font_manager_dual_paned_set_sidebar_widget (FontManagerDualPaned* self,
                                                 GtkWidget* widget);
VALA_EXTERN void font_manager_dual_paned_set_settings (FontManagerDualPaned* self,
                                           GSettings* value);
VALA_EXTERN void font_manager_dual_paned_set_orientation (FontManagerDualPaned* self,
                                              GtkOrientation value);
VALA_EXTERN gdouble font_manager_dual_paned_get_sidebar_position (FontManagerDualPaned* self);
VALA_EXTERN gdouble font_manager_dual_paned_get_content_position (FontManagerDualPaned* self);
static GObject * font_manager_dual_paned_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void font_manager_dual_paned_finalize (GObject * obj);
static GType font_manager_dual_paned_get_type_once (void);
static void _vala_font_manager_dual_paned_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_font_manager_dual_paned_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
font_manager_paned_get_instance_private (FontManagerPaned* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerPaned_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GtkWidget*
font_manager_paned_get_start_child (FontManagerPaned* self)
{
	GtkPaned* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->child;
	_tmp1_ = gtk_paned_get_start_child (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

GtkWidget*
font_manager_paned_get_end_child (FontManagerPaned* self)
{
	GtkPaned* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->child;
	_tmp1_ = gtk_paned_get_end_child (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

void
font_manager_paned_set_start_child (FontManagerPaned* self,
                                    GtkWidget* widget)
{
	GtkPaned* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->child;
	gtk_paned_set_start_child (_tmp0_, widget);
	return;
}

void
font_manager_paned_set_end_child (FontManagerPaned* self,
                                  GtkWidget* widget)
{
	GtkPaned* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->child;
	gtk_paned_set_end_child (_tmp0_, widget);
	return;
}

static gboolean
__lambda4_ (FontManagerPaned* self)
{
	gboolean result;
	font_manager_paned_on_position_set (self);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda4__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda4_ ((FontManagerPaned*) self);
	return result;
}

static gboolean
__lambda5_ (FontManagerPaned* self)
{
	GtkPaned* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->child;
	gtk_widget_queue_resize ((GtkWidget*) _tmp0_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda5__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda5_ ((FontManagerPaned*) self);
	return result;
}

static void
font_manager_paned_on_map (FontManagerPaned* self)
{
	g_return_if_fail (self != NULL);
	g_idle_add_full (G_PRIORITY_LOW, ___lambda4__gsource_func, g_object_ref (self), g_object_unref);
	g_idle_add_full (G_PRIORITY_LOW, ___lambda5__gsource_func, g_object_ref (self), g_object_unref);
	return;
}

static gint
font_manager_paned_get_alloc (FontManagerPaned* self)
{
	gint _tmp0_ = 0;
	GtkOrientation _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->priv->_orientation;
	if (_tmp1_ == GTK_ORIENTATION_HORIZONTAL) {
		_tmp0_ = gtk_widget_get_width ((GtkWidget*) self);
	} else {
		_tmp0_ = gtk_widget_get_height ((GtkWidget*) self);
	}
	result = _tmp0_;
	return result;
}

static void
font_manager_paned_on_position_set (FontManagerPaned* self)
{
	GtkPaned* _tmp0_;
	gdouble _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->child;
	_tmp1_ = self->priv->_position;
	gtk_paned_set_position (_tmp0_, (gint) ((_tmp1_ / 100) * ((gdouble) font_manager_paned_get_alloc (self))));
	return;
}

static void
font_manager_paned_on_child_position_changed (FontManagerPaned* self)
{
	gdouble new_position = 0.0;
	GtkPaned* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gdouble _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->child;
	_tmp1_ = gtk_paned_get_position (_tmp0_);
	_tmp2_ = _tmp1_;
	new_position = (((gdouble) _tmp2_) / ((gdouble) font_manager_paned_get_alloc (self))) * 100;
	_tmp3_ = self->priv->_position;
	if (_tmp3_ != new_position) {
		font_manager_paned_set_position (self, new_position);
	}
	return;
}

FontManagerPaned*
font_manager_paned_construct (GType object_type)
{
	FontManagerPaned * self = NULL;
	self = (FontManagerPaned*) g_object_new (object_type, NULL);
	return self;
}

FontManagerPaned*
font_manager_paned_new (void)
{
	return font_manager_paned_construct (FONT_MANAGER_TYPE_PANED);
}

gdouble
font_manager_paned_get_position (FontManagerPaned* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_position;
	return result;
}

void
font_manager_paned_set_position (FontManagerPaned* self,
                                 gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_paned_get_position (self);
	if (old_value != value) {
		self->priv->_position = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_paned_properties[FONT_MANAGER_PANED_POSITION_PROPERTY]);
	}
}

GtkOrientation
font_manager_paned_get_orientation (FontManagerPaned* self)
{
	GtkOrientation result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_orientation;
	return result;
}

void
font_manager_paned_set_orientation (FontManagerPaned* self,
                                    GtkOrientation value)
{
	GtkOrientation old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_paned_get_orientation (self);
	if (old_value != value) {
		self->priv->_orientation = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_paned_properties[FONT_MANAGER_PANED_ORIENTATION_PROPERTY]);
	}
}

static void
_font_manager_paned_on_position_set_g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self)
{
	font_manager_paned_on_position_set ((FontManagerPaned*) self);
}

static void
_font_manager_paned_on_child_position_changed_g_object_notify (GObject* _sender,
                                                               GParamSpec* pspec,
                                                               gpointer self)
{
	font_manager_paned_on_child_position_changed ((FontManagerPaned*) self);
}

static void
_font_manager_paned_on_map_gtk_widget_map (GtkWidget* _sender,
                                           gpointer self)
{
	font_manager_paned_on_map ((FontManagerPaned*) self);
}

static GObject *
font_manager_paned_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FontManagerPaned * self;
	GtkBoxLayout* _tmp0_;
	GtkOrientation _tmp1_;
	GtkPaned* _tmp2_;
	GtkPaned* _tmp3_;
	GBindingFlags flags = 0U;
	GtkPaned* _tmp4_;
	GtkPaned* _tmp5_;
	parent_class = G_OBJECT_CLASS (font_manager_paned_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_PANED, FontManagerPaned);
	_tmp0_ = (GtkBoxLayout*) gtk_box_layout_new (GTK_ORIENTATION_HORIZONTAL);
	gtk_widget_set_layout_manager ((GtkWidget*) self, (GtkLayoutManager*) _tmp0_);
	font_manager_widget_set_expand ((GtkWidget*) self, TRUE);
	_tmp1_ = self->priv->_orientation;
	_tmp2_ = (GtkPaned*) gtk_paned_new (_tmp1_);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->child);
	self->priv->child = _tmp2_;
	_tmp3_ = self->priv->child;
	gtk_widget_set_parent ((GtkWidget*) _tmp3_, (GtkWidget*) self);
	flags = G_BINDING_DEFAULT;
	_tmp4_ = self->priv->child;
	g_object_bind_property_with_closures ((GObject*) self, "orientation", (GObject*) _tmp4_, "orientation", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	g_signal_connect_object ((GObject*) self, "notify::position", (GCallback) _font_manager_paned_on_position_set_g_object_notify, self, 0);
	_tmp5_ = self->priv->child;
	g_signal_connect_object ((GObject*) _tmp5_, "notify::position", (GCallback) _font_manager_paned_on_child_position_changed_g_object_notify, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "map", (GCallback) _font_manager_paned_on_map_gtk_widget_map, self, G_CONNECT_AFTER);
	return obj;
}

static void
font_manager_paned_class_init (FontManagerPanedClass * klass,
                               gpointer klass_data)
{
	font_manager_paned_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerPaned_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_paned_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_paned_set_property;
	G_OBJECT_CLASS (klass)->constructor = font_manager_paned_constructor;
	G_OBJECT_CLASS (klass)->finalize = font_manager_paned_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_PANED_POSITION_PROPERTY, font_manager_paned_properties[FONT_MANAGER_PANED_POSITION_PROPERTY] = g_param_spec_double ("position", "position", "position", -G_MAXDOUBLE, G_MAXDOUBLE, (gdouble) 50, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_PANED_ORIENTATION_PROPERTY, font_manager_paned_properties[FONT_MANAGER_PANED_ORIENTATION_PROPERTY] = g_param_spec_enum ("orientation", "orientation", "orientation", gtk_orientation_get_type (), GTK_ORIENTATION_HORIZONTAL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
font_manager_paned_instance_init (FontManagerPaned * self,
                                  gpointer klass)
{
	self->priv = font_manager_paned_get_instance_private (self);
	self->priv->_position = (gdouble) 50;
	self->priv->_orientation = GTK_ORIENTATION_HORIZONTAL;
}

static void
font_manager_paned_finalize (GObject * obj)
{
	FontManagerPaned * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_PANED, FontManagerPaned);
	_g_object_unref0 (self->priv->child);
	G_OBJECT_CLASS (font_manager_paned_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_paned_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerPanedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_paned_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerPaned), 0, (GInstanceInitFunc) font_manager_paned_instance_init, NULL };
	GType font_manager_paned_type_id;
	font_manager_paned_type_id = g_type_register_static (gtk_widget_get_type (), "FontManagerPaned", &g_define_type_info, 0);
	FontManagerPaned_private_offset = g_type_add_instance_private (font_manager_paned_type_id, sizeof (FontManagerPanedPrivate));
	return font_manager_paned_type_id;
}

GType
font_manager_paned_get_type (void)
{
	static volatile gsize font_manager_paned_type_id__once = 0;
	if (g_once_init_enter (&font_manager_paned_type_id__once)) {
		GType font_manager_paned_type_id;
		font_manager_paned_type_id = font_manager_paned_get_type_once ();
		g_once_init_leave (&font_manager_paned_type_id__once, font_manager_paned_type_id);
	}
	return font_manager_paned_type_id__once;
}

static void
_vala_font_manager_paned_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	FontManagerPaned * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_PANED, FontManagerPaned);
	switch (property_id) {
		case FONT_MANAGER_PANED_POSITION_PROPERTY:
		g_value_set_double (value, font_manager_paned_get_position (self));
		break;
		case FONT_MANAGER_PANED_ORIENTATION_PROPERTY:
		g_value_set_enum (value, font_manager_paned_get_orientation (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_paned_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	FontManagerPaned * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_PANED, FontManagerPaned);
	switch (property_id) {
		case FONT_MANAGER_PANED_POSITION_PROPERTY:
		font_manager_paned_set_position (self, g_value_get_double (value));
		break;
		case FONT_MANAGER_PANED_ORIENTATION_PROPERTY:
		font_manager_paned_set_orientation (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
font_manager_dual_paned_get_instance_private (FontManagerDualPaned* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerDualPaned_private_offset);
}

static void
__lambda6_ (FontManagerDualPaned* self,
            GObject* obj,
            GParamSpec* pspec)
{
	GtkOrientation _tmp0_;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->_orientation;
	if (_tmp0_ == GTK_ORIENTATION_HORIZONTAL) {
		FontManagerPaned* _tmp1_;
		gdouble _tmp2_;
		gdouble _tmp3_;
		_tmp1_ = self->priv->main_pane;
		_tmp2_ = font_manager_paned_get_position (_tmp1_);
		_tmp3_ = _tmp2_;
		font_manager_dual_paned_set_hor_sidebar_size (self, _tmp3_);
	} else {
		FontManagerPaned* _tmp4_;
		gdouble _tmp5_;
		gdouble _tmp6_;
		_tmp4_ = self->priv->main_pane;
		_tmp5_ = font_manager_paned_get_position (_tmp4_);
		_tmp6_ = _tmp5_;
		font_manager_dual_paned_set_sidebar_size (self, _tmp6_);
	}
}

static void
___lambda6__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda6_ ((FontManagerDualPaned*) self, _sender, pspec);
}

static void
__lambda7_ (FontManagerDualPaned* self,
            GObject* obj,
            GParamSpec* pspec)
{
	GtkOrientation _tmp0_;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->_orientation;
	if (_tmp0_ == GTK_ORIENTATION_HORIZONTAL) {
		FontManagerPaned* _tmp1_;
		gdouble _tmp2_;
		gdouble _tmp3_;
		_tmp1_ = self->priv->content_pane;
		_tmp2_ = font_manager_paned_get_position (_tmp1_);
		_tmp3_ = _tmp2_;
		font_manager_dual_paned_set_hor_content_size (self, _tmp3_);
	} else {
		FontManagerPaned* _tmp4_;
		gdouble _tmp5_;
		gdouble _tmp6_;
		_tmp4_ = self->priv->content_pane;
		_tmp5_ = font_manager_paned_get_position (_tmp4_);
		_tmp6_ = _tmp5_;
		font_manager_dual_paned_set_content_size (self, _tmp6_);
	}
}

static void
___lambda7__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda7_ ((FontManagerDualPaned*) self, _sender, pspec);
}

static void
__lambda8_ (FontManagerDualPaned* self)
{
	GtkOrientation _tmp0_;
	_tmp0_ = self->priv->_orientation;
	if (_tmp0_ == GTK_ORIENTATION_HORIZONTAL) {
		FontManagerPaned* _tmp1_;
		gdouble _tmp2_;
		FontManagerPaned* _tmp3_;
		gdouble _tmp4_;
		_tmp1_ = self->priv->main_pane;
		_tmp2_ = self->priv->_hor_sidebar_size;
		font_manager_paned_set_position (_tmp1_, _tmp2_);
		_tmp3_ = self->priv->content_pane;
		_tmp4_ = self->priv->_hor_content_size;
		font_manager_paned_set_position (_tmp3_, _tmp4_);
	} else {
		FontManagerPaned* _tmp5_;
		gdouble _tmp6_;
		FontManagerPaned* _tmp7_;
		gdouble _tmp8_;
		_tmp5_ = self->priv->main_pane;
		_tmp6_ = self->priv->_sidebar_size;
		font_manager_paned_set_position (_tmp5_, _tmp6_);
		_tmp7_ = self->priv->content_pane;
		_tmp8_ = self->priv->_content_size;
		font_manager_paned_set_position (_tmp7_, _tmp8_);
	}
}

static void
___lambda8__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda8_ ((FontManagerDualPaned*) self);
}

static void
_font_manager_dual_paned_on_map_gtk_widget_map (GtkWidget* _sender,
                                                gpointer self)
{
	font_manager_dual_paned_on_map ((FontManagerDualPaned*) self);
}

FontManagerDualPaned*
font_manager_dual_paned_construct (GType object_type,
                                   GSettings* settings)
{
	FontManagerDualPaned * self = NULL;
	FontManagerPaned* _tmp0_;
	FontManagerPaned* _tmp1_;
	FontManagerPaned* _tmp2_;
	FontManagerPaned* _tmp3_;
	GtkOverlay* _tmp4_;
	FontManagerPaned* _tmp5_;
	GtkBox* _tmp6_;
	GtkBox* _tmp7_;
	GtkBox* _tmp8_;
	GtkBox* _tmp9_;
	GtkBox* _tmp10_;
	GtkBox* _tmp11_;
	FontManagerPaned* _tmp12_;
	GtkBox* _tmp13_;
	FontManagerPaned* _tmp14_;
	GtkBox* _tmp15_;
	FontManagerPaned* _tmp16_;
	GtkBox* _tmp17_;
	FontManagerPaned* _tmp18_;
	FontManagerPaned* _tmp19_;
	GBindingFlags flags = 0U;
	FontManagerPaned* _tmp20_;
	FontManagerPaned* _tmp21_;
	FontManagerPaned* _tmp22_;
	self = (FontManagerDualPaned*) g_object_new (object_type, "settings", settings, NULL);
	_tmp0_ = font_manager_paned_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->main_pane);
	self->priv->main_pane = _tmp0_;
	_tmp1_ = font_manager_paned_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->content_pane);
	self->priv->content_pane = _tmp1_;
	_tmp2_ = self->priv->main_pane;
	_tmp3_ = self->priv->content_pane;
	font_manager_paned_set_end_child (_tmp2_, (GtkWidget*) _tmp3_);
	_tmp4_ = self->overlay;
	_tmp5_ = self->priv->main_pane;
	gtk_overlay_set_child (_tmp4_, (GtkWidget*) _tmp5_);
	_tmp6_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->content_area);
	self->priv->content_area = _tmp6_;
	_tmp7_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->list_area);
	self->priv->list_area = _tmp7_;
	_tmp8_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->sidebar_area);
	self->priv->sidebar_area = _tmp8_;
	_tmp9_ = self->priv->content_area;
	gtk_widget_set_size_request ((GtkWidget*) _tmp9_, -1, 250);
	_tmp10_ = self->priv->list_area;
	gtk_widget_set_size_request ((GtkWidget*) _tmp10_, -1, 250);
	_tmp11_ = self->priv->sidebar_area;
	gtk_widget_set_size_request ((GtkWidget*) _tmp11_, -1, 250);
	_tmp12_ = self->priv->main_pane;
	_tmp13_ = self->priv->sidebar_area;
	font_manager_paned_set_start_child (_tmp12_, (GtkWidget*) _tmp13_);
	_tmp14_ = self->priv->content_pane;
	_tmp15_ = self->priv->list_area;
	font_manager_paned_set_start_child (_tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = self->priv->content_pane;
	_tmp17_ = self->priv->content_area;
	font_manager_paned_set_end_child (_tmp16_, (GtkWidget*) _tmp17_);
	_tmp18_ = self->priv->main_pane;
	g_signal_connect_object ((GObject*) _tmp18_, "notify::position", (GCallback) ___lambda6__g_object_notify, self, 0);
	_tmp19_ = self->priv->content_pane;
	g_signal_connect_object ((GObject*) _tmp19_, "notify::position", (GCallback) ___lambda7__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::orientation", (GCallback) ___lambda8__g_object_notify, self, 0);
	flags = G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE;
	_tmp20_ = self->priv->content_pane;
	g_object_bind_property_with_closures ((GObject*) self, "orientation", (GObject*) _tmp20_, "orientation", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp21_ = self->priv->main_pane;
	g_object_bind_property_with_closures ((GObject*) self, "sidebar-position", (GObject*) _tmp21_, "position", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp22_ = self->priv->content_pane;
	g_object_bind_property_with_closures ((GObject*) self, "content-position", (GObject*) _tmp22_, "position", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	g_signal_connect_object ((GtkWidget*) self, "map", (GCallback) _font_manager_dual_paned_on_map_gtk_widget_map, self, G_CONNECT_AFTER);
	return self;
}

FontManagerDualPaned*
font_manager_dual_paned_new (GSettings* settings)
{
	return font_manager_dual_paned_construct (FONT_MANAGER_TYPE_DUAL_PANED, settings);
}

static void
font_manager_dual_paned_real_on_map (FontManagerDualPaned* self)
{
	GSettings* _tmp0_;
	GtkOrientation _tmp1_;
	GSettingsBindFlags flags = 0U;
	GSettings* _tmp6_;
	GSettings* _tmp7_;
	GSettings* _tmp8_;
	GSettings* _tmp9_;
	_tmp0_ = self->priv->_settings;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->_orientation;
	if (_tmp1_ == GTK_ORIENTATION_HORIZONTAL) {
		GSettings* _tmp2_;
		GSettings* _tmp3_;
		_tmp2_ = self->priv->_settings;
		font_manager_dual_paned_set_sidebar_position (self, g_settings_get_double (_tmp2_, "hor-sidebar-size"));
		_tmp3_ = self->priv->_settings;
		font_manager_dual_paned_set_content_position (self, g_settings_get_double (_tmp3_, "hor-content-size"));
	} else {
		GSettings* _tmp4_;
		GSettings* _tmp5_;
		_tmp4_ = self->priv->_settings;
		font_manager_dual_paned_set_sidebar_position (self, g_settings_get_double (_tmp4_, "sidebar-size"));
		_tmp5_ = self->priv->_settings;
		font_manager_dual_paned_set_content_position (self, g_settings_get_double (_tmp5_, "content-size"));
	}
	flags = G_SETTINGS_BIND_DEFAULT;
	_tmp6_ = self->priv->_settings;
	g_settings_bind (_tmp6_, "sidebar-size", (GObject*) self, "sidebar-size", flags);
	_tmp7_ = self->priv->_settings;
	g_settings_bind (_tmp7_, "content-size", (GObject*) self, "content-size", flags);
	_tmp8_ = self->priv->_settings;
	g_settings_bind (_tmp8_, "hor-sidebar-size", (GObject*) self, "hor-sidebar-size", flags);
	_tmp9_ = self->priv->_settings;
	g_settings_bind (_tmp9_, "hor-content-size", (GObject*) self, "hor-content-size", flags);
	return;
}

void
font_manager_dual_paned_on_map (FontManagerDualPaned* self)
{
	FontManagerDualPanedClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FONT_MANAGER_DUAL_PANED_GET_CLASS (self);
	if (_klass_->on_map) {
		_klass_->on_map (self);
	}
}

GtkWidget*
font_manager_dual_paned_get_content_widget (FontManagerDualPaned* self)
{
	GtkBox* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->content_area;
	_tmp1_ = gtk_widget_get_first_child ((GtkWidget*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

GtkWidget*
font_manager_dual_paned_get_list_widget (FontManagerDualPaned* self)
{
	GtkBox* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->list_area;
	_tmp1_ = gtk_widget_get_first_child ((GtkWidget*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

GtkWidget*
font_manager_dual_paned_get_sidebar_widget (FontManagerDualPaned* self)
{
	GtkBox* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sidebar_area;
	_tmp1_ = gtk_widget_get_first_child ((GtkWidget*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

void
font_manager_dual_paned_set_content_widget (FontManagerDualPaned* self,
                                            GtkWidget* widget)
{
	GtkBox* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->content_area;
	font_manager_dual_paned_set_child (self, _tmp0_, widget);
	return;
}

void
font_manager_dual_paned_set_list_widget (FontManagerDualPaned* self,
                                         GtkWidget* widget)
{
	GtkBox* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->list_area;
	font_manager_dual_paned_set_child (self, _tmp0_, widget);
	return;
}

void
font_manager_dual_paned_set_sidebar_widget (FontManagerDualPaned* self,
                                            GtkWidget* widget)
{
	GtkBox* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->sidebar_area;
	font_manager_dual_paned_set_child (self, _tmp0_, widget);
	return;
}

static void
font_manager_dual_paned_set_child (FontManagerDualPaned* self,
                                   GtkBox* parent,
                                   GtkWidget* child)
{
	GtkWidget* current_child = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	_tmp0_ = gtk_widget_get_first_child ((GtkWidget*) parent);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	current_child = _tmp1_;
	_tmp2_ = current_child;
	if (_tmp2_ != NULL) {
		GtkWidget* _tmp3_;
		_tmp3_ = current_child;
		gtk_box_remove (parent, _tmp3_);
	}
	if (child != NULL) {
		font_manager_widget_set_expand (child, TRUE);
		gtk_box_append (parent, child);
	}
	_g_object_unref0 (current_child);
	return;
}

GSettings*
font_manager_dual_paned_get_settings (FontManagerDualPaned* self)
{
	GSettings* result;
	GSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_settings;
	result = _tmp0_;
	return result;
}

void
font_manager_dual_paned_set_settings (FontManagerDualPaned* self,
                                      GSettings* value)
{
	GSettings* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_dual_paned_get_settings (self);
	if (old_value != value) {
		GSettings* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_settings);
		self->priv->_settings = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_dual_paned_properties[FONT_MANAGER_DUAL_PANED_SETTINGS_PROPERTY]);
	}
}

GtkOrientation
font_manager_dual_paned_get_orientation (FontManagerDualPaned* self)
{
	GtkOrientation result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_orientation;
	return result;
}

void
font_manager_dual_paned_set_orientation (FontManagerDualPaned* self,
                                         GtkOrientation value)
{
	GtkOrientation old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_dual_paned_get_orientation (self);
	if (old_value != value) {
		self->priv->_orientation = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_dual_paned_properties[FONT_MANAGER_DUAL_PANED_ORIENTATION_PROPERTY]);
	}
}

gdouble
font_manager_dual_paned_get_sidebar_position (FontManagerDualPaned* self)
{
	gdouble result;
	gdouble _tmp0_ = 0.0;
	GtkOrientation _tmp1_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp1_ = self->priv->_orientation;
	if (_tmp1_ == GTK_ORIENTATION_HORIZONTAL) {
		gdouble _tmp2_;
		_tmp2_ = self->priv->_hor_sidebar_size;
		_tmp0_ = _tmp2_;
	} else {
		gdouble _tmp3_;
		_tmp3_ = self->priv->_sidebar_size;
		_tmp0_ = _tmp3_;
	}
	result = _tmp0_;
	return result;
}

void
font_manager_dual_paned_set_sidebar_position (FontManagerDualPaned* self,
                                              gdouble value)
{
	GtkOrientation _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_orientation;
	if (_tmp0_ == GTK_ORIENTATION_HORIZONTAL) {
		font_manager_dual_paned_set_hor_sidebar_size (self, value);
	} else {
		font_manager_dual_paned_set_sidebar_size (self, value);
	}
	g_object_notify ((GObject*) self, "sidebar-position");
	g_object_notify_by_pspec ((GObject *) self, font_manager_dual_paned_properties[FONT_MANAGER_DUAL_PANED_SIDEBAR_POSITION_PROPERTY]);
}

gdouble
font_manager_dual_paned_get_content_position (FontManagerDualPaned* self)
{
	gdouble result;
	gdouble _tmp0_ = 0.0;
	GtkOrientation _tmp1_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp1_ = self->priv->_orientation;
	if (_tmp1_ == GTK_ORIENTATION_HORIZONTAL) {
		gdouble _tmp2_;
		_tmp2_ = self->priv->_hor_content_size;
		_tmp0_ = _tmp2_;
	} else {
		gdouble _tmp3_;
		_tmp3_ = self->priv->_content_size;
		_tmp0_ = _tmp3_;
	}
	result = _tmp0_;
	return result;
}

void
font_manager_dual_paned_set_content_position (FontManagerDualPaned* self,
                                              gdouble value)
{
	GtkOrientation _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_orientation;
	if (_tmp0_ == GTK_ORIENTATION_HORIZONTAL) {
		font_manager_dual_paned_set_hor_content_size (self, value);
	} else {
		font_manager_dual_paned_set_content_size (self, value);
	}
	g_object_notify ((GObject*) self, "content-position");
	g_object_notify_by_pspec ((GObject *) self, font_manager_dual_paned_properties[FONT_MANAGER_DUAL_PANED_CONTENT_POSITION_PROPERTY]);
}

gdouble
font_manager_dual_paned_get_content_size (FontManagerDualPaned* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_content_size;
	return result;
}

void
font_manager_dual_paned_set_content_size (FontManagerDualPaned* self,
                                          gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_dual_paned_get_content_size (self);
	if (old_value != value) {
		self->priv->_content_size = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_dual_paned_properties[FONT_MANAGER_DUAL_PANED_CONTENT_SIZE_PROPERTY]);
	}
}

gdouble
font_manager_dual_paned_get_sidebar_size (FontManagerDualPaned* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_sidebar_size;
	return result;
}

void
font_manager_dual_paned_set_sidebar_size (FontManagerDualPaned* self,
                                          gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_dual_paned_get_sidebar_size (self);
	if (old_value != value) {
		self->priv->_sidebar_size = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_dual_paned_properties[FONT_MANAGER_DUAL_PANED_SIDEBAR_SIZE_PROPERTY]);
	}
}

gdouble
font_manager_dual_paned_get_hor_content_size (FontManagerDualPaned* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_hor_content_size;
	return result;
}

void
font_manager_dual_paned_set_hor_content_size (FontManagerDualPaned* self,
                                              gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_dual_paned_get_hor_content_size (self);
	if (old_value != value) {
		self->priv->_hor_content_size = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_dual_paned_properties[FONT_MANAGER_DUAL_PANED_HOR_CONTENT_SIZE_PROPERTY]);
	}
}

gdouble
font_manager_dual_paned_get_hor_sidebar_size (FontManagerDualPaned* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_hor_sidebar_size;
	return result;
}

void
font_manager_dual_paned_set_hor_sidebar_size (FontManagerDualPaned* self,
                                              gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_dual_paned_get_hor_sidebar_size (self);
	if (old_value != value) {
		self->priv->_hor_sidebar_size = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_dual_paned_properties[FONT_MANAGER_DUAL_PANED_HOR_SIDEBAR_SIZE_PROPERTY]);
	}
}

static GObject *
font_manager_dual_paned_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FontManagerDualPaned * self;
	GtkBoxLayout* _tmp0_;
	GtkOverlay* _tmp1_;
	GtkOverlay* _tmp2_;
	parent_class = G_OBJECT_CLASS (font_manager_dual_paned_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_DUAL_PANED, FontManagerDualPaned);
	_tmp0_ = (GtkBoxLayout*) gtk_box_layout_new (GTK_ORIENTATION_HORIZONTAL);
	gtk_widget_set_layout_manager ((GtkWidget*) self, (GtkLayoutManager*) _tmp0_);
	font_manager_widget_set_expand ((GtkWidget*) self, TRUE);
	_tmp1_ = (GtkOverlay*) gtk_overlay_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->overlay);
	self->overlay = _tmp1_;
	_tmp2_ = self->overlay;
	gtk_widget_set_parent ((GtkWidget*) _tmp2_, (GtkWidget*) self);
	return obj;
}

static void
font_manager_dual_paned_class_init (FontManagerDualPanedClass * klass,
                                    gpointer klass_data)
{
	font_manager_dual_paned_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerDualPaned_private_offset);
	((FontManagerDualPanedClass *) klass)->on_map = (void (*) (FontManagerDualPaned*)) font_manager_dual_paned_real_on_map;
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_dual_paned_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_dual_paned_set_property;
	G_OBJECT_CLASS (klass)->constructor = font_manager_dual_paned_constructor;
	G_OBJECT_CLASS (klass)->finalize = font_manager_dual_paned_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_DUAL_PANED_SETTINGS_PROPERTY, font_manager_dual_paned_properties[FONT_MANAGER_DUAL_PANED_SETTINGS_PROPERTY] = g_param_spec_object ("settings", "settings", "settings", g_settings_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_DUAL_PANED_ORIENTATION_PROPERTY, font_manager_dual_paned_properties[FONT_MANAGER_DUAL_PANED_ORIENTATION_PROPERTY] = g_param_spec_enum ("orientation", "orientation", "orientation", gtk_orientation_get_type (), GTK_ORIENTATION_VERTICAL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_DUAL_PANED_SIDEBAR_POSITION_PROPERTY, font_manager_dual_paned_properties[FONT_MANAGER_DUAL_PANED_SIDEBAR_POSITION_PROPERTY] = g_param_spec_double ("sidebar-position", "sidebar-position", "sidebar-position", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_DUAL_PANED_CONTENT_POSITION_PROPERTY, font_manager_dual_paned_properties[FONT_MANAGER_DUAL_PANED_CONTENT_POSITION_PROPERTY] = g_param_spec_double ("content-position", "content-position", "content-position", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_DUAL_PANED_CONTENT_SIZE_PROPERTY, font_manager_dual_paned_properties[FONT_MANAGER_DUAL_PANED_CONTENT_SIZE_PROPERTY] = g_param_spec_double ("content-size", "content-size", "content-size", -G_MAXDOUBLE, G_MAXDOUBLE, (gdouble) 40, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_DUAL_PANED_SIDEBAR_SIZE_PROPERTY, font_manager_dual_paned_properties[FONT_MANAGER_DUAL_PANED_SIDEBAR_SIZE_PROPERTY] = g_param_spec_double ("sidebar-size", "sidebar-size", "sidebar-size", -G_MAXDOUBLE, G_MAXDOUBLE, (gdouble) 33, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_DUAL_PANED_HOR_CONTENT_SIZE_PROPERTY, font_manager_dual_paned_properties[FONT_MANAGER_DUAL_PANED_HOR_CONTENT_SIZE_PROPERTY] = g_param_spec_double ("hor-content-size", "hor-content-size", "hor-content-size", -G_MAXDOUBLE, G_MAXDOUBLE, (gdouble) 36, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_DUAL_PANED_HOR_SIDEBAR_SIZE_PROPERTY, font_manager_dual_paned_properties[FONT_MANAGER_DUAL_PANED_HOR_SIDEBAR_SIZE_PROPERTY] = g_param_spec_double ("hor-sidebar-size", "hor-sidebar-size", "hor-sidebar-size", -G_MAXDOUBLE, G_MAXDOUBLE, (gdouble) 20, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
font_manager_dual_paned_instance_init (FontManagerDualPaned * self,
                                       gpointer klass)
{
	self->priv = font_manager_dual_paned_get_instance_private (self);
	self->priv->_settings = NULL;
	self->priv->_orientation = GTK_ORIENTATION_VERTICAL;
	self->priv->_content_size = (gdouble) 40;
	self->priv->_sidebar_size = (gdouble) 33;
	self->priv->_hor_content_size = (gdouble) 36;
	self->priv->_hor_sidebar_size = (gdouble) 20;
}

static void
font_manager_dual_paned_finalize (GObject * obj)
{
	FontManagerDualPaned * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_DUAL_PANED, FontManagerDualPaned);
	_g_object_unref0 (self->priv->_settings);
	_g_object_unref0 (self->overlay);
	_g_object_unref0 (self->priv->main_pane);
	_g_object_unref0 (self->priv->content_pane);
	_g_object_unref0 (self->priv->content_area);
	_g_object_unref0 (self->priv->list_area);
	_g_object_unref0 (self->priv->sidebar_area);
	G_OBJECT_CLASS (font_manager_dual_paned_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_dual_paned_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerDualPanedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_dual_paned_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerDualPaned), 0, (GInstanceInitFunc) font_manager_dual_paned_instance_init, NULL };
	GType font_manager_dual_paned_type_id;
	font_manager_dual_paned_type_id = g_type_register_static (gtk_widget_get_type (), "FontManagerDualPaned", &g_define_type_info, 0);
	FontManagerDualPaned_private_offset = g_type_add_instance_private (font_manager_dual_paned_type_id, sizeof (FontManagerDualPanedPrivate));
	return font_manager_dual_paned_type_id;
}

GType
font_manager_dual_paned_get_type (void)
{
	static volatile gsize font_manager_dual_paned_type_id__once = 0;
	if (g_once_init_enter (&font_manager_dual_paned_type_id__once)) {
		GType font_manager_dual_paned_type_id;
		font_manager_dual_paned_type_id = font_manager_dual_paned_get_type_once ();
		g_once_init_leave (&font_manager_dual_paned_type_id__once, font_manager_dual_paned_type_id);
	}
	return font_manager_dual_paned_type_id__once;
}

static void
_vala_font_manager_dual_paned_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	FontManagerDualPaned * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_DUAL_PANED, FontManagerDualPaned);
	switch (property_id) {
		case FONT_MANAGER_DUAL_PANED_SETTINGS_PROPERTY:
		g_value_set_object (value, font_manager_dual_paned_get_settings (self));
		break;
		case FONT_MANAGER_DUAL_PANED_ORIENTATION_PROPERTY:
		g_value_set_enum (value, font_manager_dual_paned_get_orientation (self));
		break;
		case FONT_MANAGER_DUAL_PANED_SIDEBAR_POSITION_PROPERTY:
		g_value_set_double (value, font_manager_dual_paned_get_sidebar_position (self));
		break;
		case FONT_MANAGER_DUAL_PANED_CONTENT_POSITION_PROPERTY:
		g_value_set_double (value, font_manager_dual_paned_get_content_position (self));
		break;
		case FONT_MANAGER_DUAL_PANED_CONTENT_SIZE_PROPERTY:
		g_value_set_double (value, font_manager_dual_paned_get_content_size (self));
		break;
		case FONT_MANAGER_DUAL_PANED_SIDEBAR_SIZE_PROPERTY:
		g_value_set_double (value, font_manager_dual_paned_get_sidebar_size (self));
		break;
		case FONT_MANAGER_DUAL_PANED_HOR_CONTENT_SIZE_PROPERTY:
		g_value_set_double (value, font_manager_dual_paned_get_hor_content_size (self));
		break;
		case FONT_MANAGER_DUAL_PANED_HOR_SIDEBAR_SIZE_PROPERTY:
		g_value_set_double (value, font_manager_dual_paned_get_hor_sidebar_size (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_dual_paned_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	FontManagerDualPaned * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_DUAL_PANED, FontManagerDualPaned);
	switch (property_id) {
		case FONT_MANAGER_DUAL_PANED_SETTINGS_PROPERTY:
		font_manager_dual_paned_set_settings (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_DUAL_PANED_ORIENTATION_PROPERTY:
		font_manager_dual_paned_set_orientation (self, g_value_get_enum (value));
		break;
		case FONT_MANAGER_DUAL_PANED_SIDEBAR_POSITION_PROPERTY:
		font_manager_dual_paned_set_sidebar_position (self, g_value_get_double (value));
		break;
		case FONT_MANAGER_DUAL_PANED_CONTENT_POSITION_PROPERTY:
		font_manager_dual_paned_set_content_position (self, g_value_get_double (value));
		break;
		case FONT_MANAGER_DUAL_PANED_CONTENT_SIZE_PROPERTY:
		font_manager_dual_paned_set_content_size (self, g_value_get_double (value));
		break;
		case FONT_MANAGER_DUAL_PANED_SIDEBAR_SIZE_PROPERTY:
		font_manager_dual_paned_set_sidebar_size (self, g_value_get_double (value));
		break;
		case FONT_MANAGER_DUAL_PANED_HOR_CONTENT_SIZE_PROPERTY:
		font_manager_dual_paned_set_hor_content_size (self, g_value_get_double (value));
		break;
		case FONT_MANAGER_DUAL_PANED_HOR_SIDEBAR_SIZE_PROPERTY:
		font_manager_dual_paned_set_hor_sidebar_size (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

