/* KeyboardManager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from KeyboardManager.vala, do not modify */

/*
 * Copyright 2016 Santiago León
 * Copyright 2023-2025 elementary, Inc. <https://elementary.io>
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include <glib-object.h>
#include <meta/display.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <meta/window.h>
#include <clutter/clutter.h>
#include <meta/keybindings.h>
#include <meta/compositor.h>
#include <meta/meta-backend.h>
#include <meta/meta-context.h>
#include <meta/prefs.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_KEYBOARD_MANAGER (gala_keyboard_manager_get_type ())
#define GALA_KEYBOARD_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_KEYBOARD_MANAGER, GalaKeyboardManager))
#define GALA_KEYBOARD_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_KEYBOARD_MANAGER, GalaKeyboardManagerClass))
#define GALA_IS_KEYBOARD_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_KEYBOARD_MANAGER))
#define GALA_IS_KEYBOARD_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_KEYBOARD_MANAGER))
#define GALA_KEYBOARD_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_KEYBOARD_MANAGER, GalaKeyboardManagerClass))

typedef struct _GalaKeyboardManager GalaKeyboardManager;
typedef struct _GalaKeyboardManagerClass GalaKeyboardManagerClass;
typedef struct _GalaKeyboardManagerPrivate GalaKeyboardManagerPrivate;
enum  {
	GALA_KEYBOARD_MANAGER_0_PROPERTY,
	GALA_KEYBOARD_MANAGER_DISPLAY_PROPERTY,
	GALA_KEYBOARD_MANAGER_NUM_PROPERTIES
};
static GParamSpec* gala_keyboard_manager_properties[GALA_KEYBOARD_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GalaKeyboardManager {
	GObject parent_instance;
	GalaKeyboardManagerPrivate * priv;
};

struct _GalaKeyboardManagerClass {
	GObjectClass parent_class;
};

struct _GalaKeyboardManagerPrivate {
	MetaDisplay* _display;
	GSettings* settings;
};

static gint GalaKeyboardManager_private_offset;
static gpointer gala_keyboard_manager_parent_class = NULL;

VALA_EXTERN GType gala_keyboard_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaKeyboardManager, g_object_unref)
VALA_EXTERN GalaKeyboardManager* gala_keyboard_manager_new (MetaDisplay* display);
VALA_EXTERN GalaKeyboardManager* gala_keyboard_manager_construct (GType object_type,
                                                      MetaDisplay* display);
static void gala_keyboard_manager_handle_keybinding (GalaKeyboardManager* self,
                                              MetaDisplay* display,
                                              MetaWindow* window,
                                              ClutterKeyEvent* event,
                                              MetaKeyBinding* binding);
static gboolean gala_keyboard_manager_switch_input_source (GalaKeyboardManager* self,
                                                    gboolean backward);
static MetaDisplay* gala_keyboard_manager_get_display (GalaKeyboardManager* self);
static void gala_keyboard_manager_on_settings_changed (GalaKeyboardManager* self,
                                                const gchar* key);
static void _vala_array_add6 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add7 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static gboolean _vala_string_array_contains (const gchar* * stack,
                                      gssize stack_length,
                                      const const gchar* needle);
static void _vala_array_add8 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void gala_keyboard_manager_set_display (GalaKeyboardManager* self,
                                        MetaDisplay* value);
static GObject * gala_keyboard_manager_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static void _gala_keyboard_manager_on_settings_changed_g_settings_changed (GSettings* _sender,
                                                                    const gchar* key,
                                                                    gpointer self);
static gboolean _gala_keyboard_manager___lambda93_ (GalaKeyboardManager* self);
static gboolean __gala_keyboard_manager___lambda93__meta_display_modifiers_accelerator_activated (MetaDisplay* _sender,
                                                                                           gpointer self);
static void _gala_keyboard_manager_handle_keybinding_meta_key_handler_func (MetaDisplay* display,
                                                                     MetaWindow* window,
                                                                     const ClutterKeyEvent* event,
                                                                     MetaKeyBinding* binding,
                                                                     gpointer self);
static void gala_keyboard_manager_finalize (GObject * obj);
static GType gala_keyboard_manager_get_type_once (void);
static void _vala_gala_keyboard_manager_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_gala_keyboard_manager_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const gchar* GALA_KEYBOARD_MANAGER_BLOCKED_OPTIONS[8] = {"grp:alt_caps_toggle", "grp:alt_shift_toggle", "grp:alt_space_toggle", "grp:shifts_toggle", "grp:caps_toggle", "grp:ctrl_alt_toggle", "grp:ctrl_shift_toggle", "grp:shift_caps_toggle"};

static inline gpointer
gala_keyboard_manager_get_instance_private (GalaKeyboardManager* self)
{
	return G_STRUCT_MEMBER_P (self, GalaKeyboardManager_private_offset);
}

GalaKeyboardManager*
gala_keyboard_manager_construct (GType object_type,
                                 MetaDisplay* display)
{
	GalaKeyboardManager * self = NULL;
	g_return_val_if_fail (display != NULL, NULL);
	self = (GalaKeyboardManager*) g_object_new (object_type, "display", display, NULL);
	return self;
}

GalaKeyboardManager*
gala_keyboard_manager_new (MetaDisplay* display)
{
	return gala_keyboard_manager_construct (GALA_TYPE_KEYBOARD_MANAGER, display);
}

static void
gala_keyboard_manager_handle_keybinding (GalaKeyboardManager* self,
                                         MetaDisplay* display,
                                         MetaWindow* window,
                                         ClutterKeyEvent* event,
                                         MetaKeyBinding* binding)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (display != NULL);
	g_return_if_fail (binding != NULL);
	_tmp0_ = meta_key_binding_get_name (binding);
	gala_keyboard_manager_switch_input_source (self, g_str_has_suffix (_tmp0_, "-backward"));
}

static gboolean
gala_keyboard_manager_switch_input_source (GalaKeyboardManager* self,
                                           gboolean backward)
{
	MetaDisplay* _tmp0_;
	MetaCompositor* _tmp1_;
	MetaBackend* _tmp2_;
	MetaBackend* _tmp3_;
	MetaBackend* _tmp4_;
	MetaDisplay* _tmp5_;
	GVariant* sources = NULL;
	GSettings* _tmp6_;
	GVariant* _tmp7_;
	guint n_sources = 0U;
	GVariant* _tmp8_;
	guint current = 0U;
	GSettings* _tmp9_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_display;
	_tmp1_ = meta_display_get_compositor (_tmp0_);
	g_object_get (_tmp1_, "backend", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->_display;
	meta_backend_ungrab_keyboard (_tmp4_, meta_display_get_current_time (_tmp5_));
	_g_object_unref0 (_tmp4_);
	_tmp6_ = self->priv->settings;
	_tmp7_ = g_settings_get_value (_tmp6_, "sources");
	sources = _tmp7_;
	_tmp8_ = sources;
	n_sources = (guint) g_variant_n_children (_tmp8_);
	if (n_sources < ((guint) 2)) {
		result = TRUE;
		_g_variant_unref0 (sources);
		return result;
	}
	_tmp9_ = self->priv->settings;
	current = g_settings_get_uint (_tmp9_, "current");
	if (!backward) {
		GSettings* _tmp10_;
		_tmp10_ = self->priv->settings;
		g_settings_set_uint (_tmp10_, "current", (current + 1) % n_sources);
	} else {
		GSettings* _tmp11_;
		_tmp11_ = self->priv->settings;
		g_settings_set_uint (_tmp11_, "current", (current - 1) % n_sources);
	}
	result = TRUE;
	_g_variant_unref0 (sources);
	return result;
}

static void
_vala_array_add6 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add7 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
_vala_string_array_contains (const gchar* * stack,
                             gssize stack_length,
                             const const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
_vala_array_add8 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static void
gala_keyboard_manager_on_settings_changed (GalaKeyboardManager* self,
                                           const gchar* key)
{
	MetaBackend* backend = NULL;
	MetaDisplay* _tmp0_;
	MetaContext* _tmp1_;
	MetaBackend* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->_display;
	_tmp1_ = meta_display_get_context (_tmp0_);
	_tmp2_ = meta_context_get_backend (_tmp1_);
	backend = _tmp2_;
	if (g_strcmp0 (key, "sources") == 0) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = g_strcmp0 (key, "xkb-options") == 0;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = g_strcmp0 (key, "xkb-model") == 0;
	}
	if (_tmp3_) {
		gchar** layouts = NULL;
		gchar** _tmp5_;
		gint layouts_length1;
		gint _layouts_size_;
		gchar** variants = NULL;
		gchar** _tmp6_;
		gint variants_length1;
		gint _variants_size_;
		GVariant* sources = NULL;
		GSettings* _tmp7_;
		GVariant* _tmp8_;
		gchar** _tmp26_;
		gint _tmp26__length1;
		gchar** xkb_options = NULL;
		gchar** _tmp31_;
		gint xkb_options_length1;
		gint _xkb_options_size_;
		gchar** _tmp32_;
		gint _tmp32__length1;
		gchar* layout = NULL;
		gchar** _tmp42_;
		gint _tmp42__length1;
		gchar* _tmp43_;
		gchar* variant = NULL;
		gchar** _tmp44_;
		gint _tmp44__length1;
		gchar* _tmp45_;
		gchar* options = NULL;
		gchar** _tmp46_;
		gint _tmp46__length1;
		gchar* _tmp47_;
		MetaBackend* _tmp48_;
		const gchar* _tmp49_;
		const gchar* _tmp50_;
		const gchar* _tmp51_;
		GSettings* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		_tmp5_ = g_new0 (gchar*, 0 + 1);
		layouts = _tmp5_;
		layouts_length1 = 0;
		_layouts_size_ = layouts_length1;
		_tmp6_ = g_new0 (gchar*, 0 + 1);
		variants = _tmp6_;
		variants_length1 = 0;
		_variants_size_ = variants_length1;
		_tmp7_ = self->priv->settings;
		_tmp8_ = g_settings_get_value (_tmp7_, "sources");
		sources = _tmp8_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp9_ = FALSE;
				_tmp9_ = TRUE;
				while (TRUE) {
					GVariant* _tmp11_;
					const gchar* type = NULL;
					const gchar* name = NULL;
					GVariant* _tmp12_;
					const gchar* _tmp13_ = NULL;
					const gchar* _tmp14_ = NULL;
					const gchar* _tmp15_;
					if (!_tmp9_) {
						gint _tmp10_;
						_tmp10_ = i;
						i = _tmp10_ + 1;
					}
					_tmp9_ = FALSE;
					_tmp11_ = sources;
					if (!(((gsize) i) < g_variant_n_children (_tmp11_))) {
						break;
					}
					type = NULL;
					name = NULL;
					_tmp12_ = sources;
					g_variant_get_child (_tmp12_, (gsize) i, "(&s&s)", &_tmp13_, &_tmp14_, NULL);
					type = _tmp13_;
					name = _tmp14_;
					_tmp15_ = type;
					if (g_strcmp0 (_tmp15_, "xkb") == 0) {
						gchar** arr = NULL;
						const gchar* _tmp16_;
						gchar** _tmp17_;
						gchar** _tmp18_;
						gint arr_length1;
						gint _arr_size_;
						gchar** _tmp19_;
						gint _tmp19__length1;
						const gchar* _tmp20_;
						gchar* _tmp21_;
						const gchar* _tmp22_ = NULL;
						gchar** _tmp23_;
						gint _tmp23__length1;
						const gchar* _tmp24_;
						gchar* _tmp25_;
						_tmp16_ = name;
						_tmp18_ = _tmp17_ = g_strsplit (_tmp16_, "+", 2);
						arr = _tmp18_;
						arr_length1 = _vala_array_length (_tmp17_);
						_arr_size_ = arr_length1;
						_tmp19_ = arr;
						_tmp19__length1 = arr_length1;
						_tmp20_ = _tmp19_[0];
						_tmp21_ = g_strdup (_tmp20_);
						_vala_array_add6 (&layouts, &layouts_length1, &_layouts_size_, _tmp21_);
						_tmp23_ = arr;
						_tmp23__length1 = arr_length1;
						_tmp24_ = _tmp23_[1];
						_tmp22_ = _tmp24_;
						if (_tmp22_ == NULL) {
							_tmp22_ = "";
						}
						_tmp25_ = g_strdup (_tmp22_);
						_vala_array_add7 (&variants, &variants_length1, &_variants_size_, _tmp25_);
						arr = (_vala_array_free (arr, arr_length1, (GDestroyNotify) g_free), NULL);
					}
				}
			}
		}
		_tmp26_ = layouts;
		_tmp26__length1 = layouts_length1;
		if (_tmp26__length1 == 0) {
			gchar* _tmp27_;
			gchar** _tmp28_;
			gchar* _tmp29_;
			gchar** _tmp30_;
			_tmp27_ = g_strdup ("us");
			_tmp28_ = g_new0 (gchar*, 1 + 1);
			_tmp28_[0] = _tmp27_;
			layouts = (_vala_array_free (layouts, layouts_length1, (GDestroyNotify) g_free), NULL);
			layouts = _tmp28_;
			layouts_length1 = 1;
			_layouts_size_ = layouts_length1;
			_tmp29_ = g_strdup ("");
			_tmp30_ = g_new0 (gchar*, 1 + 1);
			_tmp30_[0] = _tmp29_;
			variants = (_vala_array_free (variants, variants_length1, (GDestroyNotify) g_free), NULL);
			variants = _tmp30_;
			variants_length1 = 1;
			_variants_size_ = variants_length1;
		}
		_tmp31_ = g_new0 (gchar*, 0 + 1);
		xkb_options = _tmp31_;
		xkb_options_length1 = 0;
		_xkb_options_size_ = xkb_options_length1;
		_tmp32_ = layouts;
		_tmp32__length1 = layouts_length1;
		if (_tmp32__length1 == 1) {
			GSettings* _tmp33_;
			gchar** _tmp34_;
			gchar** _tmp35_;
			_tmp33_ = self->priv->settings;
			_tmp35_ = _tmp34_ = g_settings_get_strv (_tmp33_, "xkb-options");
			{
				gchar** option_collection = NULL;
				gint option_collection_length1 = 0;
				gint _option_collection_size_ = 0;
				gint option_it = 0;
				option_collection = _tmp35_;
				option_collection_length1 = _vala_array_length (_tmp34_);
				for (option_it = 0; option_it < option_collection_length1; option_it = option_it + 1) {
					const gchar* option = NULL;
					option = option_collection[option_it];
					{
						const gchar* _tmp36_;
						_tmp36_ = option;
						if (!_vala_string_array_contains (GALA_KEYBOARD_MANAGER_BLOCKED_OPTIONS, G_N_ELEMENTS (GALA_KEYBOARD_MANAGER_BLOCKED_OPTIONS), _tmp36_)) {
							const gchar* _tmp37_;
							gchar* _tmp38_;
							_tmp37_ = option;
							_tmp38_ = g_strdup (_tmp37_);
							_vala_array_add8 (&xkb_options, &xkb_options_length1, &_xkb_options_size_, _tmp38_);
						}
					}
				}
				option_collection = (_vala_array_free (option_collection, option_collection_length1, (GDestroyNotify) g_free), NULL);
			}
		} else {
			GSettings* _tmp39_;
			gchar** _tmp40_;
			gchar** _tmp41_;
			_tmp39_ = self->priv->settings;
			_tmp41_ = _tmp40_ = g_settings_get_strv (_tmp39_, "xkb-options");
			xkb_options = (_vala_array_free (xkb_options, xkb_options_length1, (GDestroyNotify) g_free), NULL);
			xkb_options = _tmp41_;
			xkb_options_length1 = _vala_array_length (_tmp40_);
			_xkb_options_size_ = xkb_options_length1;
		}
		_tmp42_ = layouts;
		_tmp42__length1 = layouts_length1;
		_tmp43_ = _vala_g_strjoinv (",", _tmp42_, (gint) _tmp42__length1);
		layout = _tmp43_;
		_tmp44_ = variants;
		_tmp44__length1 = variants_length1;
		_tmp45_ = _vala_g_strjoinv (",", _tmp44_, (gint) _tmp44__length1);
		variant = _tmp45_;
		_tmp46_ = xkb_options;
		_tmp46__length1 = xkb_options_length1;
		_tmp47_ = _vala_g_strjoinv (",", _tmp46_, (gint) _tmp46__length1);
		options = _tmp47_;
		_tmp48_ = backend;
		_tmp49_ = layout;
		_tmp50_ = variant;
		_tmp51_ = options;
		_tmp52_ = self->priv->settings;
		_tmp53_ = g_settings_get_string (_tmp52_, "xkb-model");
		_tmp54_ = _tmp53_;
		meta_backend_set_keymap (_tmp48_, _tmp49_, _tmp50_, _tmp51_, _tmp54_);
		_g_free0 (_tmp54_);
		_g_free0 (options);
		_g_free0 (variant);
		_g_free0 (layout);
		xkb_options = (_vala_array_free (xkb_options, xkb_options_length1, (GDestroyNotify) g_free), NULL);
		_g_variant_unref0 (sources);
		variants = (_vala_array_free (variants, variants_length1, (GDestroyNotify) g_free), NULL);
		layouts = (_vala_array_free (layouts, layouts_length1, (GDestroyNotify) g_free), NULL);
	} else {
		if (g_strcmp0 (key, "current") == 0) {
			MetaBackend* _tmp55_;
			GSettings* _tmp56_;
			_tmp55_ = backend;
			_tmp56_ = self->priv->settings;
			meta_backend_lock_layout_group (_tmp55_, g_settings_get_uint (_tmp56_, "current"));
		}
	}
}

static MetaDisplay*
gala_keyboard_manager_get_display (GalaKeyboardManager* self)
{
	MetaDisplay* result;
	MetaDisplay* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gala_keyboard_manager_set_display (GalaKeyboardManager* self,
                                   MetaDisplay* value)
{
	MetaDisplay* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_keyboard_manager_get_display (self);
	if (old_value != value) {
		MetaDisplay* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_display);
		self->priv->_display = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_keyboard_manager_properties[GALA_KEYBOARD_MANAGER_DISPLAY_PROPERTY]);
	}
}

static void
_gala_keyboard_manager_on_settings_changed_g_settings_changed (GSettings* _sender,
                                                               const gchar* key,
                                                               gpointer self)
{
	gala_keyboard_manager_on_settings_changed ((GalaKeyboardManager*) self, key);
}

static gboolean
_gala_keyboard_manager___lambda93_ (GalaKeyboardManager* self)
{
	gboolean result;
	result = gala_keyboard_manager_switch_input_source (self, FALSE);
	return result;
}

static gboolean
__gala_keyboard_manager___lambda93__meta_display_modifiers_accelerator_activated (MetaDisplay* _sender,
                                                                                  gpointer self)
{
	gboolean result;
	result = _gala_keyboard_manager___lambda93_ ((GalaKeyboardManager*) self);
	return result;
}

static void
_gala_keyboard_manager_handle_keybinding_meta_key_handler_func (MetaDisplay* display,
                                                                MetaWindow* window,
                                                                const ClutterKeyEvent* event,
                                                                MetaKeyBinding* binding,
                                                                gpointer self)
{
	gala_keyboard_manager_handle_keybinding ((GalaKeyboardManager*) self, display, window, event, binding);
}

static GObject *
gala_keyboard_manager_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaKeyboardManager * self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	MetaDisplay* _tmp2_;
	GSettings* keybinding_settings = NULL;
	GSettings* _tmp3_;
	MetaDisplay* _tmp4_;
	GSettings* _tmp5_;
	MetaDisplay* _tmp6_;
	GSettings* _tmp7_;
	parent_class = G_OBJECT_CLASS (gala_keyboard_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_KEYBOARD_MANAGER, GalaKeyboardManager);
	_tmp0_ = g_settings_new ("org.gnome.desktop.input-sources");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	gala_keyboard_manager_on_settings_changed (self, "sources");
	gala_keyboard_manager_on_settings_changed (self, "current");
	_tmp1_ = self->priv->settings;
	g_signal_connect_object (_tmp1_, "changed", (GCallback) _gala_keyboard_manager_on_settings_changed_g_settings_changed, self, 0);
	_tmp2_ = self->priv->_display;
	g_signal_connect_object (_tmp2_, "modifiers-accelerator-activated", (GCallback) __gala_keyboard_manager___lambda93__meta_display_modifiers_accelerator_activated, self, 0);
	_tmp3_ = g_settings_new ("io.elementary.desktop.wm.keybindings");
	keybinding_settings = _tmp3_;
	_tmp4_ = self->priv->_display;
	_tmp5_ = keybinding_settings;
	meta_display_add_keybinding (_tmp4_, "switch-input-source", _tmp5_, META_KEY_BINDING_IGNORE_AUTOREPEAT, _gala_keyboard_manager_handle_keybinding_meta_key_handler_func, g_object_ref (self), g_object_unref);
	_tmp6_ = self->priv->_display;
	_tmp7_ = keybinding_settings;
	meta_display_add_keybinding (_tmp6_, "switch-input-source-backward", _tmp7_, META_KEY_BINDING_IGNORE_AUTOREPEAT, _gala_keyboard_manager_handle_keybinding_meta_key_handler_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (keybinding_settings);
	return obj;
}

static void
gala_keyboard_manager_class_init (GalaKeyboardManagerClass * klass,
                                  gpointer klass_data)
{
	gala_keyboard_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaKeyboardManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_keyboard_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_keyboard_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_keyboard_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_keyboard_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_KEYBOARD_MANAGER_DISPLAY_PROPERTY, gala_keyboard_manager_properties[GALA_KEYBOARD_MANAGER_DISPLAY_PROPERTY] = g_param_spec_object ("display", "display", "display", meta_display_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
gala_keyboard_manager_instance_init (GalaKeyboardManager * self,
                                     gpointer klass)
{
	self->priv = gala_keyboard_manager_get_instance_private (self);
}

static void
gala_keyboard_manager_finalize (GObject * obj)
{
	GalaKeyboardManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_KEYBOARD_MANAGER, GalaKeyboardManager);
	_g_object_unref0 (self->priv->_display);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (gala_keyboard_manager_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gala_keyboard_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaKeyboardManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_keyboard_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaKeyboardManager), 0, (GInstanceInitFunc) gala_keyboard_manager_instance_init, NULL };
	GType gala_keyboard_manager_type_id;
	gala_keyboard_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaKeyboardManager", &g_define_type_info, 0);
	GalaKeyboardManager_private_offset = g_type_add_instance_private (gala_keyboard_manager_type_id, sizeof (GalaKeyboardManagerPrivate));
	return gala_keyboard_manager_type_id;
}

GType
gala_keyboard_manager_get_type (void)
{
	static gsize gala_keyboard_manager_type_id__once = 0;
	if (g_once_init_enter (&gala_keyboard_manager_type_id__once)) {
		GType gala_keyboard_manager_type_id;
		gala_keyboard_manager_type_id = gala_keyboard_manager_get_type_once ();
		g_once_init_leave (&gala_keyboard_manager_type_id__once, gala_keyboard_manager_type_id);
	}
	return gala_keyboard_manager_type_id__once;
}

static void
_vala_gala_keyboard_manager_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	GalaKeyboardManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_KEYBOARD_MANAGER, GalaKeyboardManager);
	switch (property_id) {
		case GALA_KEYBOARD_MANAGER_DISPLAY_PROPERTY:
		g_value_set_object (value, gala_keyboard_manager_get_display (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_keyboard_manager_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	GalaKeyboardManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_KEYBOARD_MANAGER, GalaKeyboardManager);
	switch (property_id) {
		case GALA_KEYBOARD_MANAGER_DISPLAY_PROPERTY:
		gala_keyboard_manager_set_display (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

