/* gitg-diff-view.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-diff-view.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2015 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include "libgitg.h"
#include <gtk/gtk.h>
#include <glib-object.h>
#include <libgit2-glib/ggit.h>
#include <gio/gio.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include <stdio.h>
#include <cairo-gobject.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS (gitg_diff_view_commit_details_get_type ())
#define GITG_DIFF_VIEW_COMMIT_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS, GitgDiffViewCommitDetails))
#define GITG_DIFF_VIEW_COMMIT_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS, GitgDiffViewCommitDetailsClass))
#define GITG_IS_DIFF_VIEW_COMMIT_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS))
#define GITG_IS_DIFF_VIEW_COMMIT_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS))
#define GITG_DIFF_VIEW_COMMIT_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS, GitgDiffViewCommitDetailsClass))

typedef struct _GitgDiffViewCommitDetails GitgDiffViewCommitDetails;
typedef struct _GitgDiffViewCommitDetailsClass GitgDiffViewCommitDetailsClass;
enum  {
	GITG_DIFF_VIEW_0_PROPERTY,
	GITG_DIFF_VIEW_OPTIONS_PROPERTY,
	GITG_DIFF_VIEW_HAS_SELECTION_PROPERTY,
	GITG_DIFF_VIEW_DIFF_PROPERTY,
	GITG_DIFF_VIEW_COMMIT_PROPERTY,
	GITG_DIFF_VIEW_WRAP_LINES_PROPERTY,
	GITG_DIFF_VIEW_STAGED_PROPERTY,
	GITG_DIFF_VIEW_UNSTAGED_PROPERTY,
	GITG_DIFF_VIEW_SHOW_PARENTS_PROPERTY,
	GITG_DIFF_VIEW_DEFAULT_COLLAPSE_ALL_PROPERTY,
	GITG_DIFF_VIEW_USE_GRAVATAR_PROPERTY,
	GITG_DIFF_VIEW_TAB_WIDTH_PROPERTY,
	GITG_DIFF_VIEW_HANDLE_SELECTION_PROPERTY,
	GITG_DIFF_VIEW_HIGHLIGHT_PROPERTY,
	GITG_DIFF_VIEW_REPOSITORY_PROPERTY,
	GITG_DIFF_VIEW_NEW_IS_WORKDIR_PROPERTY,
	GITG_DIFF_VIEW_IGNORE_WHITESPACE_PROPERTY,
	GITG_DIFF_VIEW_CHANGES_INLINE_PROPERTY,
	GITG_DIFF_VIEW_CONTEXT_LINES_PROPERTY,
	GITG_DIFF_VIEW_NUM_PROPERTIES
};
static GParamSpec* gitg_diff_view_properties[GITG_DIFF_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define GITG_TYPE_DIFF_VIEW_FILE (gitg_diff_view_file_get_type ())
#define GITG_DIFF_VIEW_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW_FILE, GitgDiffViewFile))
#define GITG_DIFF_VIEW_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_VIEW_FILE, GitgDiffViewFileClass))
#define GITG_IS_DIFF_VIEW_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW_FILE))
#define GITG_IS_DIFF_VIEW_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_VIEW_FILE))
#define GITG_DIFF_VIEW_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_VIEW_FILE, GitgDiffViewFileClass))

typedef struct _GitgDiffViewFile GitgDiffViewFile;
typedef struct _GitgDiffViewFileClass GitgDiffViewFileClass;
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_GdkEventButton_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkEventButton_free (var), NULL)))
#define __vala_GdkEventTouch_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkEventTouch_free (var), NULL)))
#define __vala_GdkRGBA_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkRGBA_free (var), NULL)))
#define __vala_GgitOId_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL)))
typedef struct _Block12Data Block12Data;
typedef struct _Block13Data Block13Data;
#define _ggit_diff_file_unref0(var) ((var == NULL) ? NULL : (var = (ggit_diff_file_unref (var), NULL)))

#define GITG_TYPE_DIFF_VIEW_FILE_INFO (gitg_diff_view_file_info_get_type ())
#define GITG_DIFF_VIEW_FILE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW_FILE_INFO, GitgDiffViewFileInfo))
#define GITG_DIFF_VIEW_FILE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_VIEW_FILE_INFO, GitgDiffViewFileInfoClass))
#define GITG_IS_DIFF_VIEW_FILE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW_FILE_INFO))
#define GITG_IS_DIFF_VIEW_FILE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_VIEW_FILE_INFO))
#define GITG_DIFF_VIEW_FILE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_VIEW_FILE_INFO, GitgDiffViewFileInfoClass))

typedef struct _GitgDiffViewFileInfo GitgDiffViewFileInfo;
typedef struct _GitgDiffViewFileInfoClass GitgDiffViewFileInfoClass;
typedef void (*GitgDiffViewAnon) (gpointer user_data);
typedef struct _Block14Data Block14Data;
typedef struct _Block15Data Block15Data;
#define _ggit_diff_delta_unref0(var) ((var == NULL) ? NULL : (var = (ggit_diff_delta_unref (var), NULL)))
typedef struct _Block16Data Block16Data;
#define _ggit_diff_hunk_unref0(var) ((var == NULL) ? NULL : (var = (ggit_diff_hunk_unref (var), NULL)))
typedef struct _Block17Data Block17Data;

#define GITG_TYPE_DIFF_VIEW_FILE_RENDERER (gitg_diff_view_file_renderer_get_type ())
#define GITG_DIFF_VIEW_FILE_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER, GitgDiffViewFileRenderer))
#define GITG_IS_DIFF_VIEW_FILE_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER))
#define GITG_DIFF_VIEW_FILE_RENDERER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER, GitgDiffViewFileRendererIface))

typedef struct _GitgDiffViewFileRenderer GitgDiffViewFileRenderer;
typedef struct _GitgDiffViewFileRendererIface GitgDiffViewFileRendererIface;

#define GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXTABLE (gitg_diff_view_file_renderer_textable_get_type ())
#define GITG_DIFF_VIEW_FILE_RENDERER_TEXTABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXTABLE, GitgDiffViewFileRendererTextable))
#define GITG_IS_DIFF_VIEW_FILE_RENDERER_TEXTABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXTABLE))
#define GITG_DIFF_VIEW_FILE_RENDERER_TEXTABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXTABLE, GitgDiffViewFileRendererTextableIface))

typedef struct _GitgDiffViewFileRendererTextable GitgDiffViewFileRendererTextable;
typedef struct _GitgDiffViewFileRendererTextableIface GitgDiffViewFileRendererTextableIface;

#define GITG_TYPE_DIFF_SELECTABLE (gitg_diff_selectable_get_type ())
#define GITG_DIFF_SELECTABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_SELECTABLE, GitgDiffSelectable))
#define GITG_IS_DIFF_SELECTABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_SELECTABLE))
#define GITG_DIFF_SELECTABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_TYPE_DIFF_SELECTABLE, GitgDiffSelectableIface))

typedef struct _GitgDiffSelectable GitgDiffSelectable;
typedef struct _GitgDiffSelectableIface GitgDiffSelectableIface;
enum  {
	GITG_DIFF_VIEW_OPTIONS_CHANGED_SIGNAL,
	GITG_DIFF_VIEW_NUM_SIGNALS
};
static guint gitg_diff_view_signals[GITG_DIFF_VIEW_NUM_SIGNALS] = {0};

struct _GitgDiffViewPrivate {
	GitgDiffViewCommitDetails* d_commit_details;
	GtkScrolledWindow* d_scrolledwindow;
	GtkGrid* d_grid_files;
	GtkEventBox* d_event_box;
	GtkRevealer* d_revealer_options;
	GitgDiffViewOptions* d_diff_view_options;
	GtkTextView* d_text_view_message;
	GgitDiff* d_diff;
	GitgCommit* d_commit;
	GgitDiffOptions* d_options;
	GCancellable* d_cancellable;
	gulong d_expanded_notify;
	gulong d_parent_commit_notify;
	gboolean d_changes_inline;
	GdkRGBA d_color_link;
	GdkRGBA color_hovered_link;
	gboolean hovering_over_link;
	GtkTextTag* hover_tag;
	guint d_reveal_options_timeout;
	guint d_unreveal_options_timeout;
	gboolean _has_selection;
	gboolean _wrap_lines;
	gboolean _staged;
	gboolean _unstaged;
	gboolean _show_parents;
	gboolean _default_collapse_all;
	gboolean _use_gravatar;
	gint _tab_width;
	gboolean _handle_selection;
	gboolean _highlight;
	GitgRepository* d_repository;
	GRegex* regex_custom_links;
	gboolean _new_is_workdir;
	GRegex* regex_url;
};

struct _Block12Data {
	int _ref_count_;
	GitgDiffView* self;
	GtkTextBuffer* buffer;
};

struct _Block13Data {
	int _ref_count_;
	Block12Data * _data12_;
	GgitConfig* conf;
};

struct _Block14Data {
	int _ref_count_;
	GitgDiffView* self;
	gint nqueries;
	gboolean finished;
	GeeHashMap* infomap;
	GitgDiffViewAnon check_finish;
	gpointer check_finish_target;
	GDestroyNotify check_finish_target_destroy_notify;
	GgitDiff* diff;
	gboolean preserve_expanded;
	GCancellable* cancellable;
};

struct _Block15Data {
	int _ref_count_;
	Block14Data * _data14_;
	GgitDiffDelta* delta;
	GitgDiffViewFileInfo* info;
};

struct _Block16Data {
	int _ref_count_;
	GitgDiffView* self;
	GeeArrayList* files;
	GitgDiffViewFile* current_file;
	GgitDiffHunk* current_hunk;
	GeeArrayList* current_lines;
	gboolean current_is_binary;
	gint maxlines;
	GitgDiffViewAnon add_hunk;
	gpointer add_hunk_target;
	GDestroyNotify add_hunk_target_destroy_notify;
	GitgDiffViewAnon add_file;
	gpointer add_file_target;
	GDestroyNotify add_file_target_destroy_notify;
	GeeHashMap* infomap;
	GCancellable* cancellable;
};

struct _Block17Data {
	int _ref_count_;
	Block16Data * _data16_;
	GitgDiffViewFileInfo* info;
	gchar* deltakey;
};

struct _GitgDiffViewFileRendererIface {
	GTypeInterface parent_iface;
	void (*add_hunk) (GitgDiffViewFileRenderer* self, GgitDiffHunk* hunk, GeeArrayList* lines);
};

struct _GitgDiffSelectableIface {
	GTypeInterface parent_iface;
	void (*clear_selection) (GitgDiffSelectable* self);
	gboolean (*get_has_selection) (GitgDiffSelectable* self);
	gboolean (*get_can_select) (GitgDiffSelectable* self);
	void (*set_can_select) (GitgDiffSelectable* self, gboolean value);
	GitgPatchSet* (*get_selection) (GitgDiffSelectable* self);
};

struct _GitgDiffViewFileRendererTextableIface {
	GTypeInterface parent_iface;
	gboolean (*get_wrap_lines) (GitgDiffViewFileRendererTextable* self);
	void (*set_wrap_lines) (GitgDiffViewFileRendererTextable* self, gboolean value);
	gint (*get_tab_width) (GitgDiffViewFileRendererTextable* self);
	void (*set_tab_width) (GitgDiffViewFileRendererTextable* self, gint value);
	gint (*get_maxlines) (GitgDiffViewFileRendererTextable* self);
	void (*set_maxlines) (GitgDiffViewFileRendererTextable* self, gint value);
	gboolean (*get_highlight) (GitgDiffViewFileRendererTextable* self);
	void (*set_highlight) (GitgDiffViewFileRendererTextable* self, gboolean value);
};

static gint GitgDiffView_private_offset;
static gpointer gitg_diff_view_parent_class = NULL;
static GeeHashSet* gitg_diff_view_s_image_mime_types;
static GeeHashSet* gitg_diff_view_s_image_mime_types = NULL;
static GRegex* gitg_diff_view_s_message_regexp;
static GRegex* gitg_diff_view_s_message_regexp = NULL;

VALA_EXTERN GType gitg_diff_view_commit_details_get_type (void) G_GNUC_CONST ;
static gboolean gitg_diff_view_flag_get (GitgDiffView* self,
                                  GgitDiffOption f);
static void gitg_diff_view_flag_set (GitgDiffView* self,
                              GgitDiffOption f,
                              gboolean val);
static void gitg_diff_view_real_constructed (GObject* base);
static void gitg_diff_view_update_expanded_files (GitgDiffView* self);
static void _gitg_diff_view_update_expanded_files_g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self);
static void gitg_diff_view_parent_commit_changed (GitgDiffView* self);
static void _gitg_diff_view_parent_commit_changed_g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self);
static void gitg_diff_view_on_event_after (GitgDiffView* self,
                                    GtkWidget* widget,
                                    GdkEvent* evt);
static void _gitg_diff_view_on_event_after_gtk_widget_event_after (GtkWidget* _sender,
                                                            GdkEvent* event,
                                                            gpointer self);
static gboolean gitg_diff_view_on_key_press (GitgDiffView* self,
                                      GtkWidget* widget,
                                      GdkEventKey* evt);
static gboolean _gitg_diff_view_on_key_press_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                  GdkEventKey* event,
                                                                  gpointer self);
static gboolean gitg_diff_view_on_motion_notify_event (GitgDiffView* self,
                                                GtkWidget* widget,
                                                GdkEventMotion* evt);
static gboolean _gitg_diff_view_on_motion_notify_event_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                                GdkEventMotion* event,
                                                                                gpointer self);
static gboolean gitg_diff_view_on_query_tooltip_event (GitgDiffView* self,
                                                gint x,
                                                gint y,
                                                gboolean keyboard_tooltip,
                                                GtkTooltip* tooltip);
static gboolean _gitg_diff_view_on_query_tooltip_event_gtk_widget_query_tooltip (GtkWidget* _sender,
                                                                          gint x,
                                                                          gint y,
                                                                          gboolean keyboard_tooltip,
                                                                          GtkTooltip* tooltip,
                                                                          gpointer self);
static void gitg_diff_view_load_colors_from_theme (GitgDiffView* self,
                                            GtkWidget* widget);
static void _gitg_diff_view_load_colors_from_theme_gtk_widget_style_updated (GtkWidget* _sender,
                                                                      gpointer self);
static gboolean gitg_diff_view_motion_notify_event_on_event_box (GitgDiffView* self,
                                                          GtkWidget* widget,
                                                          GdkEventMotion* event);
static gboolean _gitg_diff_view_motion_notify_event_on_event_box_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                                          GdkEventMotion* event,
                                                                                          gpointer self);
static void gitg_diff_view_real_dispose (GObject* base);
static void gitg_diff_view_update (GitgDiffView* self,
                            gboolean preserve_expanded);
VALA_EXTERN gboolean gitg_diff_view_commit_details_get_expanded (GitgDiffViewCommitDetails* self);
VALA_EXTERN GType gitg_diff_view_file_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void gitg_diff_view_file_set_expanded (GitgDiffViewFile* self,
                                       gboolean value);
static gchar* gitg_diff_view_message_without_subject (GitgDiffView* self,
                                               GitgCommit* commit);
static GdkRGBA* _vala_GdkRGBA_copy (GdkRGBA* self);
static void _vala_GdkRGBA_free (GdkRGBA* self);
static void __lambda77_ (GitgDiffView* self,
                  GtkTextTag* tag);
static void ___lambda77__gtk_text_tag_table_foreach (GtkTextTag* tag,
                                              gpointer self);
static GdkEventButton* _vala_GdkEventButton_copy (GdkEventButton* self);
static void _vala_GdkEventButton_free (GdkEventButton* self);
static GdkEventTouch* _vala_GdkEventTouch_copy (GdkEventTouch* self);
static void _vala_GdkEventTouch_free (GdkEventTouch* self);
static void gitg_diff_view_restore_tag_color_link (GitgDiffView* self,
                                            GtkTextTag* tag);
VALA_EXTERN void gitg_diff_view_commit_details_set_commit (GitgDiffViewCommitDetails* self,
                                               GgitCommit* value);
VALA_EXTERN GgitCommit* gitg_diff_view_commit_details_get_parent_commit (GitgDiffViewCommitDetails* self);
static void _vala_GgitOId_free (GgitOId* self);
static void gitg_diff_view_parse_smart_text (GitgDiffView* self,
                                      GtkTextBuffer* buffer);
static void gitg_diff_view_update_diff (GitgDiffView* self,
                                 GgitDiff* diff,
                                 gboolean preserve_expanded,
                                 GCancellable* cancellable);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
static gint ____lambda64_ (Block13Data* _data13_,
                    GMatchInfo* match_info,
                    const gchar* value);
static gint _____lambda64__ggit_config_match_callback (GMatchInfo* match_info,
                                                const gchar* value,
                                                gpointer self);
static void gitg_diff_view_auto_change_expanded (GitgDiffView* self,
                                          gboolean expanded);
VALA_EXTERN void gitg_diff_view_commit_details_set_expanded (GitgDiffViewCommitDetails* self,
                                                 gboolean value);
static void gitg_diff_view_on_selection_changed (GitgDiffView* self);
VALA_EXTERN gboolean gitg_diff_view_file_has_selection (GitgDiffViewFile* self);
static void gitg_diff_view_set_has_selection (GitgDiffView* self,
                                       gboolean value);
static gchar* gitg_diff_view_primary_path (GitgDiffView* self,
                                    GgitDiffDelta* delta);
static gchar* gitg_diff_view_key_for_delta (GitgDiffView* self,
                                     GgitDiffDelta* delta);
VALA_EXTERN GType gitg_diff_view_file_info_get_type (void) G_GNUC_CONST ;
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
static void __lambda65_ (Block14Data* _data14_);
static void gitg_diff_view_update_diff_hunks (GitgDiffView* self,
                                       GgitDiff* diff,
                                       gboolean preserve_expanded,
                                       GeeHashMap* infomap,
                                       GCancellable* cancellable);
static void ___lambda65__gitg_diff_view_anon (gpointer self);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
VALA_EXTERN GitgDiffViewFileInfo* gitg_diff_view_file_info_new (GitgRepository* repository,
                                                    GgitDiffDelta* delta,
                                                    gboolean from_workdir);
VALA_EXTERN GitgDiffViewFileInfo* gitg_diff_view_file_info_construct (GType object_type,
                                                          GitgRepository* repository,
                                                          GgitDiffDelta* delta,
                                                          gboolean from_workdir);
VALA_EXTERN void gitg_diff_view_file_info_query (GitgDiffViewFileInfo* self,
                                     GCancellable* cancellable,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
VALA_EXTERN void gitg_diff_view_file_info_query_finish (GitgDiffViewFileInfo* self,
                                            GAsyncResult* _res_);
static void _____lambda76_ (Block15Data* _data15_,
                     GObject* obj,
                     GAsyncResult* res);
static void ______lambda76__gasync_ready_callback (GObject* source_object,
                                            GAsyncResult* res,
                                            gpointer self);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
static void __lambda66_ (Block16Data* _data16_);
VALA_EXTERN void gitg_diff_view_file_add_hunk (GitgDiffViewFile* self,
                                   GgitDiffHunk* hunk,
                                   GeeArrayList* lines);
static void ___lambda66__gitg_diff_view_anon (gpointer self);
static void __lambda67_ (Block16Data* _data16_);
static void ___lambda67__gitg_diff_view_anon (gpointer self);
static gint ___lambda68_ (Block16Data* _data16_,
                   GgitDiffDelta* delta,
                   gfloat progress);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
VALA_EXTERN const gchar* gitg_diff_view_file_info_get_new_file_content_type (GitgDiffViewFileInfo* self);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
VALA_EXTERN GitgDiffViewFile* gitg_diff_view_file_new (GitgDiffViewFileInfo* info);
VALA_EXTERN GitgDiffViewFile* gitg_diff_view_file_construct (GType object_type,
                                                 GitgDiffViewFileInfo* info);
VALA_EXTERN void gitg_diff_view_file_add_image_renderer (GitgDiffViewFile* self);
VALA_EXTERN void gitg_diff_view_file_add_text_renderer (GitgDiffViewFile* self,
                                            gboolean handle_selection);
VALA_EXTERN GType gitg_diff_view_file_renderer_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GeeArrayList* gitg_diff_view_file_get_renderer_list (GitgDiffViewFile* self);
VALA_EXTERN GType gitg_diff_selectable_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType gitg_diff_view_file_renderer_textable_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void gitg_diff_view_file_renderer_textable_set_maxlines (GitgDiffViewFileRendererTextable* self,
                                                         gint value);
static void _gitg_diff_view_on_selection_changed_g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self);
static gint _____lambda69_ (Block17Data* _data17_,
                     GgitDiffDelta* delta,
                     gfloat progress);
static gint ______lambda69__ggit_diff_file_callback (GgitDiffDelta* delta,
                                              gfloat progress,
                                              gpointer self);
static gint _____lambda70_ (Block17Data* _data17_,
                     GgitDiffDelta* delta,
                     GgitDiffBinary* binary);
static gint ______lambda70__ggit_diff_binary_callback (GgitDiffDelta* delta,
                                                GgitDiffBinary* binary,
                                                gpointer self);
static gint _____lambda71_ (Block17Data* _data17_,
                     GgitDiffDelta* delta,
                     GgitDiffHunk* hunk);
static gint ______lambda71__ggit_diff_hunk_callback (GgitDiffDelta* delta,
                                              GgitDiffHunk* hunk,
                                              gpointer self);
static gint _____lambda72_ (Block17Data* _data17_,
                     GgitDiffDelta* delta,
                     GgitDiffHunk* hunk,
                     GgitDiffLine* line);
static gint ______lambda72__ggit_diff_line_callback (GgitDiffDelta* delta,
                                              GgitDiffHunk* hunk,
                                              GgitDiffLine* line,
                                              gpointer self);
VALA_EXTERN void gitg_diff_view_file_add_binary_renderer (GitgDiffViewFile* self);
static gint ____lambda68__ggit_diff_file_callback (GgitDiffDelta* delta,
                                            gfloat progress,
                                            gpointer self);
static gint ___lambda73_ (Block16Data* _data16_,
                   GgitDiffDelta* delta,
                   GgitDiffBinary* binary);
static gint ____lambda73__ggit_diff_binary_callback (GgitDiffDelta* delta,
                                              GgitDiffBinary* binary,
                                              gpointer self);
static gint ___lambda74_ (Block16Data* _data16_,
                   GgitDiffDelta* delta,
                   GgitDiffHunk* hunk);
static gint ____lambda74__ggit_diff_hunk_callback (GgitDiffDelta* delta,
                                            GgitDiffHunk* hunk,
                                            gpointer self);
static gint ___lambda75_ (Block16Data* _data16_,
                   GgitDiffDelta* delta,
                   GgitDiffHunk* hunk,
                   GgitDiffLine* line);
static gint ____lambda75__ggit_diff_line_callback (GgitDiffDelta* delta,
                                            GgitDiffHunk* hunk,
                                            GgitDiffLine* line,
                                            gpointer self);
VALA_EXTERN gboolean gitg_diff_view_file_get_expanded (GitgDiffViewFile* self);
VALA_EXTERN GitgDiffViewFileInfo* gitg_diff_view_file_get_info (GitgDiffViewFile* self);
VALA_EXTERN GgitDiffDelta* gitg_diff_view_file_info_get_delta (GitgDiffViewFileInfo* self);
VALA_EXTERN void gitg_diff_view_commit_details_set_expander_visible (GitgDiffViewCommitDetails* self,
                                                         gboolean value);
static void gitg_diff_view_auto_update_expanded (GitgDiffView* self);
static void _gitg_diff_view_auto_update_expanded_g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self);
VALA_EXTERN GitgPatchSet* gitg_diff_view_file_get_selection (GitgDiffViewFile* self);
static void _vala_array_add7 (GitgPatchSet** * array,
                       gint* length,
                       gint* size,
                       GitgPatchSet* value);
VALA_EXTERN void gitg_diff_view_file_clear_selection (GitgDiffViewFile* self);
static void gitg_diff_view_update_hide_show_options (GitgDiffView* self,
                                              GdkWindow* window,
                                              gint ex,
                                              gint ey);
static gboolean ___lambda78_ (GitgDiffView* self);
static gboolean ____lambda78__gsource_func (gpointer self);
static gboolean _____lambda79_ (GitgDiffView* self);
static gboolean ______lambda79__gsource_func (gpointer self);
static gboolean gitg_diff_view_leave_notify_event_on_event_box (GitgDiffView* self,
                                                         GtkWidget* widget,
                                                         GdkEventCrossing* event);
static gboolean _gitg_diff_view_leave_notify_event_on_event_box_gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                                                        GdkEventCrossing* event,
                                                                                        gpointer self);
static gboolean gitg_diff_view_enter_notify_event_on_event_box (GitgDiffView* self,
                                                         GtkWidget* widget,
                                                         GdkEventCrossing* event);
static gboolean _gitg_diff_view_enter_notify_event_on_event_box_gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                                                        GdkEventCrossing* event,
                                                                                        gpointer self);
VALA_EXTERN void gitg_diff_view_commit_details_set_repository (GitgDiffViewCommitDetails* self,
                                                   GitgRepository* value);
static void gitg_diff_view_real_options_changed (GitgDiffView* self);
static GObject * gitg_diff_view_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties);
static void gitg_diff_view_finalize (GObject * obj);
static GType gitg_diff_view_get_type_once (void);
static void _vala_gitg_diff_view_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_gitg_diff_view_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static GRegex* _tmp_regex_0 = NULL;
static GRegex* _tmp_regex_1 = NULL;

static inline gpointer
gitg_diff_view_get_instance_private (GitgDiffView* self)
{
	return G_STRUCT_MEMBER_P (self, GitgDiffView_private_offset);
}

static inline GRegex*
_thread_safe_regex_init (GRegex** re,
                         const gchar * pattern,
                         GRegexCompileFlags compile_flags)
{
	if (g_once_init_enter ((gsize*) re)) {
		GRegex* val = g_regex_new (pattern, compile_flags, 0, NULL);
		g_once_init_leave ((gsize*) re, (gsize) val);
	}
	return *re;
}

static gpointer
_g_regex_ref0 (gpointer self)
{
	return self ? g_regex_ref (self) : NULL;
}

static gboolean
gitg_diff_view_flag_get (GitgDiffView* self,
                         GgitDiffOption f)
{
	GgitDiffOptions* _tmp0_;
	GgitDiffOptions* _tmp1_;
	GgitDiffOption _tmp2_;
	GgitDiffOption _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gitg_diff_view_get_options (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = ggit_diff_options_get_flags (_tmp1_);
	_tmp3_ = _tmp2_;
	result = (_tmp3_ & f) != 0;
	return result;
}

static void
gitg_diff_view_flag_set (GitgDiffView* self,
                         GgitDiffOption f,
                         gboolean val)
{
	GgitDiffOption flags = 0U;
	GgitDiffOptions* _tmp0_;
	GgitDiffOptions* _tmp1_;
	GgitDiffOption _tmp2_;
	GgitDiffOption _tmp3_;
	GgitDiffOptions* _tmp4_;
	GgitDiffOptions* _tmp5_;
	GgitDiffOption _tmp6_;
	GgitDiffOption _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gitg_diff_view_get_options (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = ggit_diff_options_get_flags (_tmp1_);
	_tmp3_ = _tmp2_;
	flags = _tmp3_;
	if (val) {
		flags |= f;
	} else {
		flags &= ~f;
	}
	_tmp4_ = gitg_diff_view_get_options (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = ggit_diff_options_get_flags (_tmp5_);
	_tmp7_ = _tmp6_;
	if (flags != _tmp7_) {
		GgitDiffOptions* _tmp8_;
		GgitDiffOptions* _tmp9_;
		_tmp8_ = gitg_diff_view_get_options (self);
		_tmp9_ = _tmp8_;
		ggit_diff_options_set_flags (_tmp9_, flags);
		g_signal_emit (self, gitg_diff_view_signals[GITG_DIFF_VIEW_OPTIONS_CHANGED_SIGNAL], 0);
	}
}

static void
_gitg_diff_view_update_expanded_files_g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self)
{
	gitg_diff_view_update_expanded_files ((GitgDiffView*) self);
}

static void
_gitg_diff_view_parent_commit_changed_g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self)
{
	gitg_diff_view_parent_commit_changed ((GitgDiffView*) self);
}

static void
_gitg_diff_view_on_event_after_gtk_widget_event_after (GtkWidget* _sender,
                                                       GdkEvent* event,
                                                       gpointer self)
{
	gitg_diff_view_on_event_after ((GitgDiffView*) self, _sender, event);
}

static gboolean
_gitg_diff_view_on_key_press_gtk_widget_key_press_event (GtkWidget* _sender,
                                                         GdkEventKey* event,
                                                         gpointer self)
{
	gboolean result;
	result = gitg_diff_view_on_key_press ((GitgDiffView*) self, _sender, event);
	return result;
}

static gboolean
_gitg_diff_view_on_motion_notify_event_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                       GdkEventMotion* event,
                                                                       gpointer self)
{
	gboolean result;
	result = gitg_diff_view_on_motion_notify_event ((GitgDiffView*) self, _sender, event);
	return result;
}

static gboolean
_gitg_diff_view_on_query_tooltip_event_gtk_widget_query_tooltip (GtkWidget* _sender,
                                                                 gint x,
                                                                 gint y,
                                                                 gboolean keyboard_tooltip,
                                                                 GtkTooltip* tooltip,
                                                                 gpointer self)
{
	gboolean result;
	result = gitg_diff_view_on_query_tooltip_event ((GitgDiffView*) self, x, y, keyboard_tooltip, tooltip);
	return result;
}

static void
_gitg_diff_view_load_colors_from_theme_gtk_widget_style_updated (GtkWidget* _sender,
                                                                 gpointer self)
{
	gitg_diff_view_load_colors_from_theme ((GitgDiffView*) self, _sender);
}

static gboolean
_gitg_diff_view_motion_notify_event_on_event_box_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                                 GdkEventMotion* event,
                                                                                 gpointer self)
{
	gboolean result;
	result = gitg_diff_view_motion_notify_event_on_event_box ((GitgDiffView*) self, _sender, event);
	return result;
}

static void
gitg_diff_view_real_constructed (GObject* base)
{
	GitgDiffView * self;
	GitgDiffViewCommitDetails* _tmp0_;
	gulong _tmp1_;
	GitgDiffViewCommitDetails* _tmp2_;
	gulong _tmp3_;
	GitgDiffViewCommitDetails* _tmp4_;
	GtkTextView* _tmp5_;
	GtkTextView* _tmp6_;
	GtkTextView* _tmp7_;
	GtkTextView* _tmp8_;
	GtkTextView* _tmp9_;
	GtkTextView* _tmp10_;
	GtkTextView* _tmp11_;
	GtkEventBox* _tmp12_;
	GitgDiffViewOptions* _tmp13_;
	self = (GitgDiffView*) base;
	_tmp0_ = self->priv->d_commit_details;
	_tmp1_ = g_signal_connect_object ((GObject*) _tmp0_, "notify::expanded", (GCallback) _gitg_diff_view_update_expanded_files_g_object_notify, self, 0);
	self->priv->d_expanded_notify = _tmp1_;
	_tmp2_ = self->priv->d_commit_details;
	_tmp3_ = g_signal_connect_object ((GObject*) _tmp2_, "notify::parent-commit", (GCallback) _gitg_diff_view_parent_commit_changed_g_object_notify, self, 0);
	self->priv->d_parent_commit_notify = _tmp3_;
	_tmp4_ = self->priv->d_commit_details;
	g_object_bind_property_with_closures ((GObject*) self, "use-gravatar", (GObject*) _tmp4_, "use-gravatar", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp5_ = self->priv->d_text_view_message;
	g_signal_connect_object ((GtkWidget*) _tmp5_, "event-after", (GCallback) _gitg_diff_view_on_event_after_gtk_widget_event_after, self, 0);
	_tmp6_ = self->priv->d_text_view_message;
	g_signal_connect_object ((GtkWidget*) _tmp6_, "key-press-event", (GCallback) _gitg_diff_view_on_key_press_gtk_widget_key_press_event, self, 0);
	_tmp7_ = self->priv->d_text_view_message;
	g_signal_connect_object ((GtkWidget*) _tmp7_, "motion-notify-event", (GCallback) _gitg_diff_view_on_motion_notify_event_gtk_widget_motion_notify_event, self, 0);
	_tmp8_ = self->priv->d_text_view_message;
	gtk_widget_set_has_tooltip ((GtkWidget*) _tmp8_, TRUE);
	_tmp9_ = self->priv->d_text_view_message;
	g_signal_connect_object ((GtkWidget*) _tmp9_, "query-tooltip", (GCallback) _gitg_diff_view_on_query_tooltip_event_gtk_widget_query_tooltip, self, 0);
	_tmp10_ = self->priv->d_text_view_message;
	g_signal_connect_object ((GtkWidget*) _tmp10_, "style-updated", (GCallback) _gitg_diff_view_load_colors_from_theme_gtk_widget_style_updated, self, 0);
	_tmp11_ = self->priv->d_text_view_message;
	gitg_diff_view_load_colors_from_theme (self, (GtkWidget*) _tmp11_);
	_tmp12_ = self->priv->d_event_box;
	g_signal_connect_object ((GtkWidget*) _tmp12_, "motion-notify-event", (GCallback) _gitg_diff_view_motion_notify_event_on_event_box_gtk_widget_motion_notify_event, self, 0);
	_tmp13_ = self->priv->d_diff_view_options;
	gitg_diff_view_options_set_view (_tmp13_, self);
}

static void
gitg_diff_view_real_dispose (GObject* base)
{
	GitgDiffView * self;
	GCancellable* _tmp0_;
	self = (GitgDiffView*) base;
	_tmp0_ = self->priv->d_cancellable;
	if (_tmp0_ != NULL) {
		GCancellable* _tmp1_;
		_tmp1_ = self->priv->d_cancellable;
		g_cancellable_cancel (_tmp1_);
	}
	G_OBJECT_CLASS (gitg_diff_view_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_grid_get_type (), GtkGrid));
}

static void
gitg_diff_view_parent_commit_changed (GitgDiffView* self)
{
	g_return_if_fail (self != NULL);
	gitg_diff_view_update (self, FALSE);
}

static void
gitg_diff_view_update_expanded_files (GitgDiffView* self)
{
	gboolean expanded = FALSE;
	GitgDiffViewCommitDetails* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GtkGrid* _tmp3_;
	GList* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_commit_details;
	_tmp1_ = gitg_diff_view_commit_details_get_expanded (_tmp0_);
	_tmp2_ = _tmp1_;
	expanded = _tmp2_;
	_tmp3_ = self->priv->d_grid_files;
	_tmp4_ = gtk_container_get_children ((GtkContainer*) _tmp3_);
	{
		GList* file_collection = NULL;
		GList* file_it = NULL;
		file_collection = _tmp4_;
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
			GtkWidget* file = NULL;
			file = (GtkWidget*) file_it->data;
			{
				GtkWidget* _tmp5_;
				_tmp5_ = file;
				gitg_diff_view_file_set_expanded (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GITG_TYPE_DIFF_VIEW_FILE, GitgDiffViewFile), expanded);
			}
		}
		(file_collection == NULL) ? NULL : (file_collection = (g_list_free (file_collection), NULL));
	}
}

static gchar*
gitg_diff_view_message_without_subject (GitgDiffView* self,
                                        GitgCommit* commit)
{
	gchar* message = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GMatchInfo* minfo = NULL;
	GRegex* _tmp2_;
	const gchar* _tmp3_;
	GMatchInfo* _tmp4_ = NULL;
	gboolean _tmp5_;
	gchar* _tmp8_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (commit != NULL, NULL);
	_tmp0_ = ggit_commit_get_message ((GgitCommit*) commit);
	_tmp1_ = g_strdup (_tmp0_);
	message = _tmp1_;
	_tmp2_ = gitg_diff_view_s_message_regexp;
	_tmp3_ = message;
	_tmp5_ = g_regex_match (_tmp2_, _tmp3_, 0, &_tmp4_);
	_g_match_info_unref0 (minfo);
	minfo = _tmp4_;
	if (_tmp5_) {
		GMatchInfo* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = minfo;
		_tmp7_ = g_match_info_fetch_named (_tmp6_, "message");
		result = _tmp7_;
		_g_match_info_unref0 (minfo);
		_g_free0 (message);
		return result;
	}
	_tmp8_ = g_strdup ("");
	result = _tmp8_;
	_g_match_info_unref0 (minfo);
	_g_free0 (message);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
gitg_diff_view_on_query_tooltip_event (GitgDiffView* self,
                                       gint x,
                                       gint y,
                                       gboolean keyboard_tooltip,
                                       GtkTooltip* tooltip)
{
	GtkTextIter iter = {0};
	GtkTextView* _tmp0_;
	GtkTextIter _tmp1_ = {0};
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tooltip != NULL, FALSE);
	_tmp0_ = self->priv->d_text_view_message;
	_tmp2_ = gtk_text_view_get_iter_at_location (_tmp0_, &_tmp1_, x, y);
	iter = _tmp1_;
	if (_tmp2_) {
		GSList* tags = NULL;
		GSList* _tmp3_;
		GSList* _tmp4_;
		_tmp3_ = gtk_text_iter_get_tags (&iter);
		tags = _tmp3_;
		_tmp4_ = tags;
		{
			GSList* tag_collection = NULL;
			GSList* tag_it = NULL;
			tag_collection = _tmp4_;
			for (tag_it = tag_collection; tag_it != NULL; tag_it = tag_it->next) {
				GtkTextTag* _tmp5_;
				GtkTextTag* tag = NULL;
				_tmp5_ = _g_object_ref0 ((GtkTextTag*) tag_it->data);
				tag = _tmp5_;
				{
					gboolean _tmp6_ = FALSE;
					GtkTextTag* _tmp7_;
					gconstpointer _tmp8_;
					_tmp7_ = tag;
					_tmp8_ = g_object_get_data ((GObject*) _tmp7_, "type");
					if (g_strcmp0 ((const gchar*) _tmp8_, "url") == 0) {
						GtkTextTag* _tmp9_;
						gconstpointer _tmp10_;
						_tmp9_ = tag;
						_tmp10_ = g_object_get_data ((GObject*) _tmp9_, "is_custom_link");
						_tmp6_ = (gboolean) ((gintptr) _tmp10_);
					} else {
						_tmp6_ = FALSE;
					}
					if (_tmp6_) {
						gchar* url = NULL;
						GtkTextTag* _tmp11_;
						gconstpointer _tmp12_;
						gchar* _tmp13_;
						const gchar* _tmp14_;
						_tmp11_ = tag;
						_tmp12_ = g_object_get_data ((GObject*) _tmp11_, "url");
						_tmp13_ = g_strdup ((const gchar*) _tmp12_);
						url = _tmp13_;
						_tmp14_ = url;
						gtk_tooltip_set_text (tooltip, _tmp14_);
						result = TRUE;
						_g_free0 (url);
						_g_object_unref0 (tag);
						(tags == NULL) ? NULL : (tags = (g_slist_free (tags), NULL));
						return result;
					}
					_g_object_unref0 (tag);
				}
			}
		}
		(tags == NULL) ? NULL : (tags = (g_slist_free (tags), NULL));
	}
	result = FALSE;
	return result;
}

static GdkRGBA*
_vala_GdkRGBA_copy (GdkRGBA* self)
{
	return g_boxed_copy (gdk_rgba_get_type (), self);
}

static gpointer
__vala_GdkRGBA_copy0 (gpointer self)
{
	return self ? _vala_GdkRGBA_copy (self) : NULL;
}

static void
_vala_GdkRGBA_free (GdkRGBA* self)
{
	g_boxed_free (gdk_rgba_get_type (), self);
}

void
gitg_diff_view_apply_link_tags (GitgDiffView* self,
                                GtkTextBuffer* buffer,
                                GRegex* regex,
                                const gchar* replacement,
                                GdkRGBA* custom_color_link,
                                gboolean is_custom_color,
                                gboolean is_custom_link)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (buffer != NULL);
	g_return_if_fail (regex != NULL);
	g_return_if_fail (custom_color_link != NULL);
	{
		GMatchInfo* matchInfo = NULL;
		gchar* buffer_text = NULL;
		gchar* _tmp0_;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		GMatchInfo* _tmp3_ = NULL;
		g_object_get (buffer, "text", &_tmp0_, NULL);
		_tmp1_ = _tmp0_;
		buffer_text = _tmp1_;
		_tmp2_ = buffer_text;
		g_regex_match (regex, _tmp2_, 0, &_tmp3_);
		_g_match_info_unref0 (matchInfo);
		matchInfo = _tmp3_;
		while (TRUE) {
			GMatchInfo* _tmp4_;
			GtkTextIter start = {0};
			GtkTextIter end = {0};
			gint start_pos = 0;
			gint end_pos = 0;
			gchar* text = NULL;
			GMatchInfo* _tmp5_;
			gchar* _tmp6_;
			GMatchInfo* _tmp7_;
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			GtkTextIter _tmp10_ = {0};
			GtkTextIter _tmp11_ = {0};
			GtkTextTag* tag = NULL;
			GtkTextTag* _tmp12_;
			GtkTextTag* _tmp13_;
			GtkTextTag* _tmp14_;
			GdkRGBA _tmp15_;
			GtkTextTag* _tmp16_;
			gchar* _tmp17_;
			GtkTextTag* _tmp18_;
			GdkRGBA _tmp19_;
			GdkRGBA* _tmp20_;
			GtkTextTag* _tmp28_;
			const gchar* _tmp29_;
			gchar* _tmp30_;
			GtkTextTag* _tmp31_;
			GtkTextTag* _tmp32_;
			GtkTextTag* _tmp33_;
			GtkTextIter _tmp34_;
			GtkTextIter _tmp35_;
			GMatchInfo* _tmp36_;
			_tmp4_ = matchInfo;
			if (!g_match_info_matches (_tmp4_)) {
				break;
			}
			_tmp5_ = matchInfo;
			_tmp6_ = g_match_info_fetch (_tmp5_, 0);
			text = _tmp6_;
			_tmp7_ = matchInfo;
			g_match_info_fetch_pos (_tmp7_, 0, &_tmp8_, &_tmp9_);
			start_pos = _tmp8_;
			end_pos = _tmp9_;
			gtk_text_buffer_get_iter_at_offset (buffer, &_tmp10_, start_pos - 1);
			start = _tmp10_;
			gtk_text_buffer_get_iter_at_offset (buffer, &_tmp11_, end_pos - 1);
			end = _tmp11_;
			_tmp12_ = gtk_text_buffer_create_tag (buffer, NULL, "underline", PANGO_UNDERLINE_SINGLE, NULL);
			_tmp13_ = _g_object_ref0 (_tmp12_);
			tag = _tmp13_;
			_tmp14_ = tag;
			_tmp15_ = *custom_color_link;
			g_object_set (_tmp14_, "foreground-rgba", &_tmp15_, NULL);
			_tmp16_ = tag;
			_tmp17_ = g_strdup ("url");
			g_object_set_data_full ((GObject*) _tmp16_, "type", _tmp17_, g_free);
			_tmp18_ = tag;
			_tmp19_ = *custom_color_link;
			_tmp20_ = __vala_GdkRGBA_copy0 (&_tmp19_);
			g_object_set_data_full ((GObject*) _tmp18_, "color_link", _tmp20_, _vala_GdkRGBA_free);
			if (replacement != NULL) {
				gchar* _tmp21_ = NULL;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				gint _tmp24_;
				gint _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				_tmp22_ = text;
				_tmp23_ = text;
				_tmp24_ = strlen (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = g_regex_replace (regex, _tmp22_, (gssize) _tmp25_, 0, replacement, 0, &_inner_error0_);
				_tmp21_ = _tmp26_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (tag);
					_g_free0 (text);
					_g_free0 (buffer_text);
					_g_match_info_unref0 (matchInfo);
					goto __catch0_g_error;
				}
				_tmp27_ = _tmp21_;
				_tmp21_ = NULL;
				_g_free0 (text);
				text = _tmp27_;
				_g_free0 (_tmp21_);
			}
			_tmp28_ = tag;
			_tmp29_ = text;
			_tmp30_ = g_strdup (_tmp29_);
			g_object_set_data_full ((GObject*) _tmp28_, "url", _tmp30_, g_free);
			_tmp31_ = tag;
			g_object_set_data_full ((GObject*) _tmp31_, "is_custom_color_link", (gpointer) ((gintptr) is_custom_color), NULL);
			_tmp32_ = tag;
			g_object_set_data_full ((GObject*) _tmp32_, "is_custom_link", (gpointer) ((gintptr) is_custom_link), NULL);
			_tmp33_ = tag;
			_tmp34_ = start;
			_tmp35_ = end;
			gtk_text_buffer_apply_tag (buffer, _tmp33_, &_tmp34_, &_tmp35_);
			_tmp36_ = matchInfo;
			g_match_info_next (_tmp36_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (tag);
				_g_free0 (text);
				_g_free0 (buffer_text);
				_g_match_info_unref0 (matchInfo);
				goto __catch0_g_error;
			}
			_g_object_unref0 (tag);
			_g_free0 (text);
		}
		_g_free0 (buffer_text);
		_g_match_info_unref0 (matchInfo);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
__lambda77_ (GitgDiffView* self,
             GtkTextTag* tag)
{
	gconstpointer _tmp0_;
	g_return_if_fail (tag != NULL);
	_tmp0_ = g_object_get_data ((GObject*) tag, "is_custom_color_link");
	if (!((gboolean) ((gintptr) _tmp0_))) {
		GdkRGBA _tmp1_;
		GdkRGBA* _tmp2_;
		GdkRGBA _tmp3_;
		_tmp1_ = self->priv->d_color_link;
		_tmp2_ = __vala_GdkRGBA_copy0 (&_tmp1_);
		g_object_set_data_full ((GObject*) tag, "color_link", _tmp2_, _vala_GdkRGBA_free);
		_tmp3_ = self->priv->d_color_link;
		g_object_set (tag, "foreground-rgba", &_tmp3_, NULL);
	}
}

static void
___lambda77__gtk_text_tag_table_foreach (GtkTextTag* tag,
                                         gpointer self)
{
	__lambda77_ ((GitgDiffView*) self, tag);
}

static void
gitg_diff_view_load_colors_from_theme (GitgDiffView* self,
                                       GtkWidget* widget)
{
	GtkTextView* textview = NULL;
	GtkTextView* _tmp0_;
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp1_;
	GtkStyleContext* _tmp2_;
	GdkRGBA _tmp3_ = {0};
	GdkRGBA _tmp4_ = {0};
	GtkTextBuffer* _tmp5_;
	GtkTextBuffer* _tmp6_;
	GtkTextTagTable* _tmp7_;
	GtkTextTagTable* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (widget, gtk_text_view_get_type (), GtkTextView));
	textview = _tmp0_;
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) textview);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	context = _tmp2_;
	gtk_style_context_save (context);
	gtk_style_context_set_state (context, GTK_STATE_FLAG_LINK);
	gtk_style_context_get_color (context, gtk_style_context_get_state (context), &_tmp3_);
	self->priv->d_color_link = _tmp3_;
	gtk_style_context_set_state (context, GTK_STATE_FLAG_LINK | GTK_STATE_FLAG_PRELIGHT);
	gtk_style_context_get_color (context, gtk_style_context_get_state (context), &_tmp4_);
	self->priv->color_hovered_link = _tmp4_;
	gtk_style_context_restore (context);
	_tmp5_ = gtk_text_view_get_buffer (textview);
	_tmp6_ = _tmp5_;
	_tmp7_ = gtk_text_buffer_get_tag_table (_tmp6_);
	_tmp8_ = _tmp7_;
	gtk_text_tag_table_foreach (_tmp8_, ___lambda77__gtk_text_tag_table_foreach, self);
	_g_object_unref0 (context);
	_g_object_unref0 (textview);
}

static gboolean
gitg_diff_view_on_key_press (GitgDiffView* self,
                             GtkWidget* widget,
                             GdkEventKey* evt)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	if (evt->keyval == GDK_KEY_Return) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = evt->keyval == GDK_KEY_KP_Enter;
	}
	if (_tmp0_) {
		GtkTextIter iter = {0};
		GtkTextView* textview = NULL;
		GtkTextView* _tmp1_;
		GtkTextView* _tmp2_;
		GtkTextBuffer* _tmp3_;
		GtkTextBuffer* _tmp4_;
		GtkTextView* _tmp5_;
		GtkTextBuffer* _tmp6_;
		GtkTextBuffer* _tmp7_;
		GtkTextMark* _tmp8_;
		GtkTextIter _tmp9_ = {0};
		GtkTextIter _tmp10_;
		_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (widget, gtk_text_view_get_type (), GtkTextView));
		textview = _tmp1_;
		_tmp2_ = textview;
		_tmp3_ = gtk_text_view_get_buffer (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = textview;
		_tmp6_ = gtk_text_view_get_buffer (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = gtk_text_buffer_get_insert (_tmp7_);
		gtk_text_buffer_get_iter_at_mark (_tmp4_, &_tmp9_, _tmp8_);
		iter = _tmp9_;
		_tmp10_ = iter;
		gitg_diff_view_follow_if_link (self, widget, &_tmp10_);
		_g_object_unref0 (textview);
	}
	result = FALSE;
	return result;
}

void
gitg_diff_view_follow_if_link (GitgDiffView* self,
                               GtkWidget* texview,
                               GtkTextIter* iter)
{
	GSList* tags = NULL;
	GSList* _tmp0_;
	GSList* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (texview != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = gtk_text_iter_get_tags (iter);
	tags = _tmp0_;
	_tmp1_ = tags;
	{
		GSList* tag_collection = NULL;
		GSList* tag_it = NULL;
		tag_collection = _tmp1_;
		for (tag_it = tag_collection; tag_it != NULL; tag_it = tag_it->next) {
			GtkTextTag* _tmp2_;
			GtkTextTag* tag = NULL;
			_tmp2_ = _g_object_ref0 ((GtkTextTag*) tag_it->data);
			tag = _tmp2_;
			{
				GtkTextTag* _tmp3_;
				gconstpointer _tmp4_;
				_tmp3_ = tag;
				_tmp4_ = g_object_get_data ((GObject*) _tmp3_, "type");
				if (g_strcmp0 ((const gchar*) _tmp4_, "url") == 0) {
					gchar* url = NULL;
					GtkTextTag* _tmp5_;
					gconstpointer _tmp6_;
					gchar* _tmp7_;
					_tmp5_ = tag;
					_tmp6_ = g_object_get_data ((GObject*) _tmp5_, "url");
					_tmp7_ = g_strdup ((const gchar*) _tmp6_);
					url = _tmp7_;
					{
						const gchar* _tmp8_;
						_tmp8_ = url;
						g_app_info_launch_default_for_uri (_tmp8_, NULL, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch0_g_error;
						}
					}
					goto __finally0;
					__catch0_g_error:
					{
						GError* e = NULL;
						const gchar* _tmp9_;
						GError* _tmp10_;
						const gchar* _tmp11_;
						e = _inner_error0_;
						_inner_error0_ = NULL;
						_tmp9_ = url;
						_tmp10_ = e;
						_tmp11_ = _tmp10_->message;
						g_warning ("gitg-diff-view.vala:400: Cannot open %s: %s", _tmp9_, _tmp11_);
						_g_error_free0 (e);
					}
					__finally0:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (url);
						_g_object_unref0 (tag);
						(tags == NULL) ? NULL : (tags = (g_slist_free (tags), NULL));
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
					_g_free0 (url);
				}
				_g_object_unref0 (tag);
			}
		}
	}
	(tags == NULL) ? NULL : (tags = (g_slist_free (tags), NULL));
}

static GdkEventButton*
_vala_GdkEventButton_copy (GdkEventButton* self)
{
	return g_boxed_copy (gdk_event_get_type (), self);
}

static gpointer
__vala_GdkEventButton_copy0 (gpointer self)
{
	return self ? _vala_GdkEventButton_copy (self) : NULL;
}

static void
_vala_GdkEventButton_free (GdkEventButton* self)
{
	g_boxed_free (gdk_event_get_type (), self);
}

static GdkEventTouch*
_vala_GdkEventTouch_copy (GdkEventTouch* self)
{
	return g_boxed_copy (gdk_event_get_type (), self);
}

static gpointer
__vala_GdkEventTouch_copy0 (gpointer self)
{
	return self ? _vala_GdkEventTouch_copy (self) : NULL;
}

static void
_vala_GdkEventTouch_free (GdkEventTouch* self)
{
	g_boxed_free (gdk_event_get_type (), self);
}

static void
gitg_diff_view_on_event_after (GitgDiffView* self,
                               GtkWidget* widget,
                               GdkEvent* evt)
{
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter iter = {0};
	GtkTextBuffer* buffer = NULL;
	gdouble ex = 0.0;
	gdouble ey = 0.0;
	gint x = 0;
	gint y = 0;
	GtkTextView* textview = NULL;
	GtkTextView* _tmp7_;
	GtkTextView* _tmp8_;
	GtkTextBuffer* _tmp9_;
	GtkTextBuffer* _tmp10_;
	GtkTextBuffer* _tmp11_;
	GtkTextBuffer* _tmp12_;
	GtkTextIter _tmp13_ = {0};
	GtkTextIter _tmp14_ = {0};
	GtkTextView* _tmp15_;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	GtkTextView* _tmp18_;
	GtkTextIter _tmp19_ = {0};
	gboolean _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (evt != NULL);
	if (evt->type == GDK_BUTTON_RELEASE) {
		GdkEventButton* event = NULL;
		GdkEventButton* _tmp0_;
		GdkEventButton* _tmp1_;
		GdkEventButton* _tmp2_;
		GdkEventButton* _tmp3_;
		_tmp0_ = __vala_GdkEventButton_copy0 ((GdkEventButton*) evt);
		__vala_GdkEventButton_free0 (event);
		event = _tmp0_;
		_tmp1_ = event;
		if (_tmp1_->button != ((guint) GDK_BUTTON_PRIMARY)) {
			__vala_GdkEventButton_free0 (event);
			_g_object_unref0 (buffer);
			return;
		}
		_tmp2_ = event;
		ex = _tmp2_->x;
		_tmp3_ = event;
		ey = _tmp3_->y;
		__vala_GdkEventButton_free0 (event);
	} else {
		if (evt->type == GDK_TOUCH_END) {
			GdkEventTouch* event = NULL;
			GdkEventTouch* _tmp4_;
			GdkEventTouch* _tmp5_;
			GdkEventTouch* _tmp6_;
			_tmp4_ = __vala_GdkEventTouch_copy0 ((GdkEventTouch*) evt);
			__vala_GdkEventTouch_free0 (event);
			event = _tmp4_;
			_tmp5_ = event;
			ex = _tmp5_->x;
			_tmp6_ = event;
			ey = _tmp6_->y;
			__vala_GdkEventTouch_free0 (event);
		} else {
			_g_object_unref0 (buffer);
			return;
		}
	}
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (widget, gtk_text_view_get_type (), GtkTextView));
	textview = _tmp7_;
	_tmp8_ = textview;
	_tmp9_ = gtk_text_view_get_buffer (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _g_object_ref0 (_tmp10_);
	_g_object_unref0 (buffer);
	buffer = _tmp11_;
	_tmp12_ = buffer;
	gtk_text_buffer_get_selection_bounds (_tmp12_, &_tmp13_, &_tmp14_);
	start = _tmp13_;
	end = _tmp14_;
	if (gtk_text_iter_get_offset (&start) != gtk_text_iter_get_offset (&end)) {
		_g_object_unref0 (textview);
		_g_object_unref0 (buffer);
		return;
	}
	_tmp15_ = textview;
	gtk_text_view_window_to_buffer_coords (_tmp15_, GTK_TEXT_WINDOW_WIDGET, (gint) ex, (gint) ey, &_tmp16_, &_tmp17_);
	x = _tmp16_;
	y = _tmp17_;
	_tmp18_ = textview;
	_tmp20_ = gtk_text_view_get_iter_at_location (_tmp18_, &_tmp19_, x, y);
	iter = _tmp19_;
	if (_tmp20_) {
		GtkTextView* _tmp21_;
		GtkTextIter _tmp22_;
		_tmp21_ = textview;
		_tmp22_ = iter;
		gitg_diff_view_follow_if_link (self, (GtkWidget*) _tmp21_, &_tmp22_);
	}
	_g_object_unref0 (textview);
	_g_object_unref0 (buffer);
}

static gboolean
gitg_diff_view_on_motion_notify_event (GitgDiffView* self,
                                       GtkWidget* widget,
                                       GdkEventMotion* evt)
{
	gint x = 0;
	gint y = 0;
	GtkTextView* textview = NULL;
	GtkTextView* _tmp0_;
	GtkTextView* _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GtkTextIter iter = {0};
	gboolean hovering = FALSE;
	GtkTextView* _tmp4_;
	GtkTextIter _tmp5_ = {0};
	gboolean _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (widget, gtk_text_view_get_type (), GtkTextView));
	textview = _tmp0_;
	_tmp1_ = textview;
	gtk_text_view_window_to_buffer_coords (_tmp1_, GTK_TEXT_WINDOW_WIDGET, (gint) evt->x, (gint) evt->y, &_tmp2_, &_tmp3_);
	x = _tmp2_;
	y = _tmp3_;
	hovering = FALSE;
	_tmp4_ = textview;
	_tmp6_ = gtk_text_view_get_iter_at_location (_tmp4_, &_tmp5_, x, y);
	iter = _tmp5_;
	if (_tmp6_) {
		GSList* tags = NULL;
		GSList* _tmp7_;
		GSList* _tmp8_;
		_tmp7_ = gtk_text_iter_get_tags (&iter);
		tags = _tmp7_;
		_tmp8_ = tags;
		{
			GSList* tag_collection = NULL;
			GSList* tag_it = NULL;
			tag_collection = _tmp8_;
			for (tag_it = tag_collection; tag_it != NULL; tag_it = tag_it->next) {
				GtkTextTag* _tmp9_;
				GtkTextTag* tag = NULL;
				_tmp9_ = _g_object_ref0 ((GtkTextTag*) tag_it->data);
				tag = _tmp9_;
				{
					GtkTextTag* _tmp10_;
					gconstpointer _tmp11_;
					_tmp10_ = tag;
					_tmp11_ = g_object_get_data ((GObject*) _tmp10_, "type");
					if (g_strcmp0 ((const gchar*) _tmp11_, "url") == 0) {
						gboolean _tmp12_ = FALSE;
						GtkTextTag* _tmp13_;
						GtkTextTag* _tmp17_;
						GtkTextTag* _tmp18_;
						hovering = TRUE;
						_tmp13_ = self->priv->hover_tag;
						if (_tmp13_ != NULL) {
							GtkTextTag* _tmp14_;
							GtkTextTag* _tmp15_;
							_tmp14_ = self->priv->hover_tag;
							_tmp15_ = tag;
							_tmp12_ = _tmp14_ != _tmp15_;
						} else {
							_tmp12_ = FALSE;
						}
						if (_tmp12_) {
							GtkTextTag* _tmp16_;
							_tmp16_ = self->priv->hover_tag;
							gitg_diff_view_restore_tag_color_link (self, _tmp16_);
							self->priv->hovering_over_link = FALSE;
						}
						_tmp17_ = tag;
						_tmp18_ = _g_object_ref0 (_tmp17_);
						_g_object_unref0 (self->priv->hover_tag);
						self->priv->hover_tag = _tmp18_;
						_g_object_unref0 (tag);
						break;
					}
					_g_object_unref0 (tag);
				}
			}
		}
		(tags == NULL) ? NULL : (tags = (g_slist_free (tags), NULL));
	}
	if (hovering != self->priv->hovering_over_link) {
		GdkDisplay* display = NULL;
		GtkTextView* _tmp19_;
		GdkDisplay* _tmp20_;
		GdkDisplay* _tmp21_;
		GdkCursor* hand_cursor = NULL;
		GdkDisplay* _tmp22_;
		GdkCursor* _tmp23_;
		GdkCursor* regular_cursor = NULL;
		GdkDisplay* _tmp24_;
		GdkCursor* _tmp25_;
		GdkWindow* window = NULL;
		GtkTextView* _tmp26_;
		GdkWindow* _tmp27_;
		GdkWindow* _tmp28_;
		self->priv->hovering_over_link = hovering;
		_tmp19_ = textview;
		_tmp20_ = gtk_widget_get_display ((GtkWidget*) _tmp19_);
		_tmp21_ = _g_object_ref0 (_tmp20_);
		display = _tmp21_;
		_tmp22_ = display;
		_tmp23_ = gdk_cursor_new_from_name (_tmp22_, "pointer");
		hand_cursor = _tmp23_;
		_tmp24_ = display;
		_tmp25_ = gdk_cursor_new_from_name (_tmp24_, "text");
		regular_cursor = _tmp25_;
		_tmp26_ = textview;
		_tmp27_ = gtk_text_view_get_window (_tmp26_, GTK_TEXT_WINDOW_TEXT);
		_tmp28_ = _g_object_ref0 (_tmp27_);
		window = _tmp28_;
		if (self->priv->hovering_over_link) {
			GdkWindow* _tmp29_;
			GdkCursor* _tmp30_;
			GtkTextTag* _tmp31_;
			_tmp29_ = window;
			_tmp30_ = hand_cursor;
			gdk_window_set_cursor (_tmp29_, _tmp30_);
			_tmp31_ = self->priv->hover_tag;
			if (_tmp31_ != NULL) {
				GtkTextTag* _tmp32_;
				GdkRGBA _tmp33_;
				_tmp32_ = self->priv->hover_tag;
				_tmp33_ = self->priv->color_hovered_link;
				g_object_set (_tmp32_, "foreground-rgba", &_tmp33_, NULL);
			}
		} else {
			GdkWindow* _tmp34_;
			GdkCursor* _tmp35_;
			GtkTextTag* _tmp36_;
			_tmp34_ = window;
			_tmp35_ = regular_cursor;
			gdk_window_set_cursor (_tmp34_, _tmp35_);
			_tmp36_ = self->priv->hover_tag;
			if (_tmp36_ != NULL) {
				GtkTextTag* _tmp37_;
				_tmp37_ = self->priv->hover_tag;
				gitg_diff_view_restore_tag_color_link (self, _tmp37_);
				_g_object_unref0 (self->priv->hover_tag);
				self->priv->hover_tag = NULL;
			}
		}
		_g_object_unref0 (window);
		_g_object_unref0 (regular_cursor);
		_g_object_unref0 (hand_cursor);
		_g_object_unref0 (display);
	}
	result = TRUE;
	_g_object_unref0 (textview);
	return result;
}

static void
gitg_diff_view_restore_tag_color_link (GitgDiffView* self,
                                       GtkTextTag* tag)
{
	GdkRGBA* color = NULL;
	gconstpointer _tmp0_;
	GdkRGBA* _tmp1_;
	GdkRGBA _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag != NULL);
	_tmp0_ = g_object_get_data ((GObject*) tag, "color_link");
	_tmp1_ = __vala_GdkRGBA_copy0 ((GdkRGBA*) _tmp0_);
	color = _tmp1_;
	_tmp2_ = *color;
	g_object_set (tag, "foreground-rgba", &_tmp2_, NULL);
	__vala_GdkRGBA_free0 (color);
}

static void
_vala_GgitOId_free (GgitOId* self)
{
	g_boxed_free (ggit_oid_get_type (), self);
}

static void
gitg_diff_view_update (GitgDiffView* self,
                       gboolean preserve_expanded)
{
	gboolean _tmp0_ = FALSE;
	GgitDiff* _tmp1_;
	GitgDiffViewCommitDetails* _tmp5_;
	GtkScrolledWindow* _tmp6_;
	GCancellable* _tmp7_;
	GCancellable* _tmp8_;
	GitgCommit* _tmp9_;
	GgitDiff* _tmp56_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->d_diff;
	if (_tmp1_ == NULL) {
		GitgCommit* _tmp2_;
		_tmp2_ = self->priv->d_commit;
		_tmp0_ = _tmp2_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GitgDiffViewCommitDetails* _tmp3_;
		GtkScrolledWindow* _tmp4_;
		_tmp3_ = self->priv->d_commit_details;
		gtk_widget_hide ((GtkWidget*) _tmp3_);
		_tmp4_ = self->priv->d_scrolledwindow;
		gtk_widget_hide ((GtkWidget*) _tmp4_);
		return;
	}
	_tmp5_ = self->priv->d_commit_details;
	gtk_widget_show ((GtkWidget*) _tmp5_);
	_tmp6_ = self->priv->d_scrolledwindow;
	gtk_widget_show ((GtkWidget*) _tmp6_);
	_tmp7_ = self->priv->d_cancellable;
	g_cancellable_cancel (_tmp7_);
	_tmp8_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->d_cancellable);
	self->priv->d_cancellable = _tmp8_;
	_tmp9_ = self->priv->d_commit;
	if (_tmp9_ != NULL) {
		GitgDiffViewCommitDetails* _tmp10_;
		GitgDiffViewCommitDetails* _tmp11_;
		GitgCommit* _tmp12_;
		GitgDiffViewCommitDetails* _tmp13_;
		gint parent = 0;
		GgitCommitParents* parents = NULL;
		GitgCommit* _tmp14_;
		GgitCommitParents* _tmp15_;
		GgitCommit* parent_commit = NULL;
		GitgDiffViewCommitDetails* _tmp16_;
		GgitCommit* _tmp17_;
		GgitCommit* _tmp18_;
		GgitCommit* _tmp19_;
		GgitCommit* _tmp20_;
		GitgCommit* _tmp33_;
		GgitDiffOptions* _tmp34_;
		GgitDiffOptions* _tmp35_;
		GgitDiff* _tmp36_;
		GitgDiffViewCommitDetails* _tmp37_;
		gchar* message = NULL;
		GitgCommit* _tmp38_;
		gchar* _tmp39_;
		GtkTextView* _tmp40_;
		GtkTextBuffer* _tmp41_;
		GtkTextBuffer* _tmp42_;
		const gchar* _tmp43_;
		GtkTextBuffer* buffer = NULL;
		GtkTextView* _tmp44_;
		GtkTextBuffer* _tmp45_;
		GtkTextBuffer* _tmp46_;
		GtkTextBuffer* _tmp47_;
		GRegex* _tmp48_;
		GdkRGBA _tmp49_;
		GtkTextBuffer* _tmp50_;
		GtkTextView* _tmp51_;
		const gchar* _tmp52_;
		_tmp10_ = self->priv->d_commit_details;
		g_signal_handler_block (_tmp10_, self->priv->d_parent_commit_notify);
		_tmp11_ = self->priv->d_commit_details;
		_tmp12_ = self->priv->d_commit;
		gitg_diff_view_commit_details_set_commit (_tmp11_, (GgitCommit*) _tmp12_);
		_tmp13_ = self->priv->d_commit_details;
		g_signal_handler_unblock (_tmp13_, self->priv->d_parent_commit_notify);
		parent = 0;
		_tmp14_ = self->priv->d_commit;
		_tmp15_ = ggit_commit_get_parents ((GgitCommit*) _tmp14_);
		parents = _tmp15_;
		_tmp16_ = self->priv->d_commit_details;
		_tmp17_ = gitg_diff_view_commit_details_get_parent_commit (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = _g_object_ref0 (_tmp18_);
		parent_commit = _tmp19_;
		_tmp20_ = parent_commit;
		if (_tmp20_ != NULL) {
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp21_ = FALSE;
					_tmp21_ = TRUE;
					while (TRUE) {
						GgitCommitParents* _tmp23_;
						guint _tmp24_;
						guint _tmp25_;
						GgitOId* id = NULL;
						GgitCommitParents* _tmp26_;
						GgitOId* _tmp27_;
						GgitOId* _tmp28_;
						GgitCommit* _tmp29_;
						GgitOId* _tmp30_;
						GgitOId* _tmp31_;
						gboolean _tmp32_;
						if (!_tmp21_) {
							gint _tmp22_;
							_tmp22_ = i;
							i = _tmp22_ + 1;
						}
						_tmp21_ = FALSE;
						_tmp23_ = parents;
						_tmp24_ = ggit_commit_parents_get_size (_tmp23_);
						_tmp25_ = _tmp24_;
						if (!(((guint) i) < _tmp25_)) {
							break;
						}
						_tmp26_ = parents;
						_tmp27_ = ggit_commit_parents_get_id (_tmp26_, (guint) i);
						id = _tmp27_;
						_tmp28_ = id;
						_tmp29_ = parent_commit;
						_tmp30_ = ggit_object_get_id ((GgitObject*) _tmp29_);
						_tmp31_ = _tmp30_;
						_tmp32_ = ggit_oid_equal (_tmp28_, _tmp31_);
						__vala_GgitOId_free0 (_tmp31_);
						if (_tmp32_) {
							parent = i;
							__vala_GgitOId_free0 (id);
							break;
						}
						__vala_GgitOId_free0 (id);
					}
				}
			}
		}
		_tmp33_ = self->priv->d_commit;
		_tmp34_ = gitg_diff_view_get_options (self);
		_tmp35_ = _tmp34_;
		_tmp36_ = gitg_commit_get_diff (_tmp33_, _tmp35_, parent);
		_g_object_unref0 (self->priv->d_diff);
		self->priv->d_diff = _tmp36_;
		_tmp37_ = self->priv->d_commit_details;
		gtk_widget_show ((GtkWidget*) _tmp37_);
		_tmp38_ = self->priv->d_commit;
		_tmp39_ = gitg_diff_view_message_without_subject (self, _tmp38_);
		message = _tmp39_;
		_tmp40_ = self->priv->d_text_view_message;
		_tmp41_ = gtk_text_view_get_buffer (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = message;
		gtk_text_buffer_set_text (_tmp42_, _tmp43_, -1);
		_tmp44_ = self->priv->d_text_view_message;
		_tmp45_ = gtk_text_view_get_buffer (_tmp44_);
		_tmp46_ = _g_object_ref0 (_tmp45_);
		buffer = _tmp46_;
		_tmp47_ = buffer;
		_tmp48_ = self->priv->regex_url;
		_tmp49_ = self->priv->d_color_link;
		gitg_diff_view_apply_link_tags (self, _tmp47_, _tmp48_, NULL, &_tmp49_, FALSE, FALSE);
		_tmp50_ = buffer;
		gitg_diff_view_parse_smart_text (self, _tmp50_);
		_tmp51_ = self->priv->d_text_view_message;
		_tmp52_ = message;
		gtk_widget_set_visible ((GtkWidget*) _tmp51_, g_strcmp0 (_tmp52_, "") != 0);
		_g_object_unref0 (buffer);
		_g_free0 (message);
		_g_object_unref0 (parent_commit);
		_g_object_unref0 (parents);
	} else {
		GitgDiffViewCommitDetails* _tmp53_;
		GitgDiffViewCommitDetails* _tmp54_;
		GtkTextView* _tmp55_;
		_tmp53_ = self->priv->d_commit_details;
		gitg_diff_view_commit_details_set_commit (_tmp53_, NULL);
		_tmp54_ = self->priv->d_commit_details;
		gtk_widget_hide ((GtkWidget*) _tmp54_);
		_tmp55_ = self->priv->d_text_view_message;
		gtk_widget_hide ((GtkWidget*) _tmp55_);
	}
	_tmp56_ = self->priv->d_diff;
	if (_tmp56_ != NULL) {
		GgitDiff* _tmp57_;
		GCancellable* _tmp58_;
		_tmp57_ = self->priv->d_diff;
		_tmp58_ = self->priv->d_cancellable;
		gitg_diff_view_update_diff (self, _tmp57_, preserve_expanded, _tmp58_);
	}
}

static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		GitgDiffView* self;
		self = _data12_->self;
		_g_object_unref0 (_data12_->buffer);
		_g_object_unref0 (self);
		g_slice_free (Block12Data, _data12_);
	}
}

static Block13Data*
block13_data_ref (Block13Data* _data13_)
{
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}

static void
block13_data_unref (void * _userdata_)
{
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		GitgDiffView* self;
		self = _data13_->_data12_->self;
		_g_object_unref0 (_data13_->conf);
		block12_data_unref (_data13_->_data12_);
		_data13_->_data12_ = NULL;
		g_slice_free (Block13Data, _data13_);
	}
}

static gint
____lambda64_ (Block13Data* _data13_,
               GMatchInfo* match_info,
               const gchar* value)
{
	Block12Data* _data12_;
	GitgDiffView* self;
	gchar* group = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* custom_link_regexp = NULL;
	gchar* _tmp2_;
	gchar* replacement_key = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GError* _inner_error0_ = NULL;
	gint result;
	_data12_ = _data13_->_data12_;
	self = _data12_->self;
	g_return_val_if_fail (match_info != NULL, 0);
	g_return_val_if_fail (value != NULL, 0);
	_tmp0_ = g_match_info_fetch (match_info, 1);
	group = _tmp0_;
	_tmp1_ = group;
	g_debug ("gitg-diff-view.vala:606: found custom-link group: %s", _tmp1_);
	_tmp2_ = g_strdup (value);
	custom_link_regexp = _tmp2_;
	_tmp3_ = group;
	_tmp4_ = g_strdup_printf ("gitg.custom-link.%s.replacement", _tmp3_);
	replacement_key = _tmp4_;
	{
		gchar* custom_link_replacement = NULL;
		GgitConfig* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* color_key = NULL;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* custom_color = NULL;
		GgitConfig* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		GdkRGBA color = {0};
		GdkRGBA _tmp15_;
		gboolean is_custom_color = FALSE;
		const gchar* _tmp16_;
		GRegex* _tmp18_ = NULL;
		const gchar* _tmp19_;
		GRegex* _tmp20_;
		const gchar* _tmp21_;
		GdkRGBA _tmp22_;
		_tmp5_ = _data13_->conf;
		_tmp6_ = replacement_key;
		_tmp7_ = ggit_config_get_string (_tmp5_, _tmp6_, &_inner_error0_);
		_tmp8_ = g_strdup (_tmp7_);
		custom_link_replacement = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp9_ = group;
		_tmp10_ = g_strdup_printf ("gitg.custom-link.%s.color", _tmp9_);
		color_key = _tmp10_;
		_tmp11_ = _data13_->conf;
		_tmp12_ = color_key;
		_tmp13_ = ggit_config_get_string (_tmp11_, _tmp12_, &_inner_error0_);
		_tmp14_ = g_strdup (_tmp13_);
		custom_color = _tmp14_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (color_key);
			_g_free0 (custom_link_replacement);
			goto __catch0_g_error;
		}
		_tmp15_ = self->priv->d_color_link;
		color = _tmp15_;
		_tmp16_ = custom_color;
		is_custom_color = _tmp16_ != NULL;
		if (is_custom_color) {
			const gchar* _tmp17_;
			memset (&color, 0, sizeof (GdkRGBA));
			_tmp17_ = custom_color;
			gdk_rgba_parse (&color, _tmp17_);
		}
		_tmp19_ = custom_link_regexp;
		_tmp20_ = g_regex_new (_tmp19_, 0, 0, &_inner_error0_);
		_tmp18_ = _tmp20_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (custom_color);
			_g_free0 (color_key);
			_g_free0 (custom_link_replacement);
			goto __catch0_g_error;
		}
		_tmp21_ = custom_link_replacement;
		_tmp22_ = color;
		gitg_diff_view_apply_link_tags (self, _data12_->buffer, _tmp18_, _tmp21_, &_tmp22_, is_custom_color, TRUE);
		_g_regex_unref0 (_tmp18_);
		_g_free0 (custom_color);
		_g_free0 (color_key);
		_g_free0 (custom_link_replacement);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp23_;
		const gchar* _tmp24_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp23_ = e;
		_tmp24_ = _tmp23_->message;
		g_warning ("gitg-diff-view.vala:624: Cannot read git config: %s", _tmp24_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp25_ = -1;
		_g_free0 (replacement_key);
		_g_free0 (custom_link_regexp);
		_g_free0 (group);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp25_;
	}
	result = 0;
	_g_free0 (replacement_key);
	_g_free0 (custom_link_regexp);
	_g_free0 (group);
	return result;
}

static gint
_____lambda64__ggit_config_match_callback (GMatchInfo* match_info,
                                           const gchar* value,
                                           gpointer self)
{
	gint result;
	result = ____lambda64_ (self, match_info, value);
	return result;
}

static void
gitg_diff_view_parse_smart_text (GitgDiffView* self,
                                 GtkTextBuffer* buffer)
{
	Block12Data* _data12_;
	GtkTextBuffer* _tmp0_;
	GitgRepository* _tmp1_;
	GitgRepository* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (buffer != NULL);
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_data12_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (buffer);
	_g_object_unref0 (_data12_->buffer);
	_data12_->buffer = _tmp0_;
	_tmp1_ = gitg_diff_view_get_repository (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		{
			Block13Data* _data13_;
			GgitConfig* _tmp3_ = NULL;
			GitgRepository* _tmp4_;
			GitgRepository* _tmp5_;
			GgitConfig* _tmp6_;
			GgitConfig* _tmp7_;
			GgitConfig* _tmp8_;
			GRegex* _tmp9_;
			_data13_ = g_slice_new0 (Block13Data);
			_data13_->_ref_count_ = 1;
			_data13_->_data12_ = block12_data_ref (_data12_);
			_tmp4_ = gitg_diff_view_get_repository (self);
			_tmp5_ = _tmp4_;
			_tmp6_ = ggit_repository_get_config ((GgitRepository*) _tmp5_, &_inner_error0_);
			_tmp3_ = _tmp6_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				block13_data_unref (_data13_);
				_data13_ = NULL;
				goto __catch0_g_error;
			}
			_tmp7_ = ggit_config_snapshot (_tmp3_, &_inner_error0_);
			_data13_->conf = _tmp7_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (_tmp3_);
				block13_data_unref (_data13_);
				_data13_ = NULL;
				goto __catch0_g_error;
			}
			_tmp8_ = _data13_->conf;
			_tmp9_ = self->priv->regex_custom_links;
			ggit_config_match_foreach (_tmp8_, _tmp9_, _____lambda64__ggit_config_match_callback, _data13_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (_tmp3_);
				block13_data_unref (_data13_);
				_data13_ = NULL;
				goto __catch0_g_error;
			}
			_g_object_unref0 (_tmp3_);
			block13_data_unref (_data13_);
			_data13_ = NULL;
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp10_;
			const gchar* _tmp11_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp10_ = e;
			_tmp11_ = _tmp10_->message;
			g_warning ("gitg-diff-view.vala:630: Cannot read git config: %s", _tmp11_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			block12_data_unref (_data12_);
			_data12_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	block12_data_unref (_data12_);
	_data12_ = NULL;
}

static void
gitg_diff_view_auto_change_expanded (GitgDiffView* self,
                                     gboolean expanded)
{
	GitgDiffViewCommitDetails* _tmp0_;
	GitgDiffViewCommitDetails* _tmp1_;
	GitgDiffViewCommitDetails* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_commit_details;
	g_signal_handler_block (_tmp0_, self->priv->d_expanded_notify);
	_tmp1_ = self->priv->d_commit_details;
	gitg_diff_view_commit_details_set_expanded (_tmp1_, expanded);
	_tmp2_ = self->priv->d_commit_details;
	g_signal_handler_unblock (_tmp2_, self->priv->d_expanded_notify);
}

static void
gitg_diff_view_on_selection_changed (GitgDiffView* self)
{
	gboolean something_selected = FALSE;
	GtkGrid* _tmp0_;
	GList* _tmp1_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	something_selected = FALSE;
	_tmp0_ = self->priv->d_grid_files;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	{
		GList* file_collection = NULL;
		GList* file_it = NULL;
		file_collection = _tmp1_;
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
			GtkWidget* file = NULL;
			file = (GtkWidget*) file_it->data;
			{
				GtkWidget* _tmp2_;
				_tmp2_ = file;
				if (gitg_diff_view_file_has_selection (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GITG_TYPE_DIFF_VIEW_FILE, GitgDiffViewFile))) {
					something_selected = TRUE;
					break;
				}
			}
		}
		(file_collection == NULL) ? NULL : (file_collection = (g_list_free (file_collection), NULL));
	}
	_tmp3_ = self->priv->_has_selection;
	if (_tmp3_ != something_selected) {
		gitg_diff_view_set_has_selection (self, something_selected);
	}
}

static gchar*
gitg_diff_view_primary_path (GitgDiffView* self,
                             GgitDiffDelta* delta)
{
	gchar* path = NULL;
	GgitDiffFile* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (delta != NULL, NULL);
	_tmp0_ = ggit_diff_delta_get_old_file (delta);
	_tmp1_ = ggit_diff_file_get_path (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	path = _tmp2_;
	_tmp3_ = path;
	if (_tmp3_ == NULL) {
		GgitDiffFile* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = ggit_diff_delta_get_new_file (delta);
		_tmp5_ = ggit_diff_file_get_path (_tmp4_);
		_tmp6_ = g_strdup (_tmp5_);
		_g_free0 (path);
		path = _tmp6_;
	}
	result = path;
	return result;
}

static gpointer
_ggit_diff_file_ref0 (gpointer self)
{
	return self ? ggit_diff_file_ref (self) : NULL;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gchar*
gitg_diff_view_key_for_delta (GitgDiffView* self,
                              GgitDiffDelta* delta)
{
	GgitDiffFile* new_file = NULL;
	GgitDiffFile* _tmp0_;
	GgitDiffFile* _tmp1_;
	gchar* new_path = NULL;
	GgitDiffFile* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	GgitDiffFile* old_file = NULL;
	GgitDiffFile* _tmp9_;
	GgitDiffFile* _tmp10_;
	gchar* old_path = NULL;
	GgitDiffFile* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp18_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (delta != NULL, NULL);
	_tmp0_ = ggit_diff_delta_get_new_file (delta);
	_tmp1_ = _ggit_diff_file_ref0 (_tmp0_);
	new_file = _tmp1_;
	_tmp2_ = new_file;
	_tmp3_ = ggit_diff_file_get_path (_tmp2_);
	_tmp4_ = g_strdup (_tmp3_);
	new_path = _tmp4_;
	_tmp5_ = new_path;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp6_ = new_path;
		_tmp7_ = string_to_string (_tmp6_);
		_tmp8_ = g_strconcat ("path:", _tmp7_, NULL);
		result = _tmp8_;
		_g_free0 (new_path);
		_ggit_diff_file_unref0 (new_file);
		return result;
	}
	_tmp9_ = ggit_diff_delta_get_old_file (delta);
	_tmp10_ = _ggit_diff_file_ref0 (_tmp9_);
	old_file = _tmp10_;
	_tmp11_ = old_file;
	_tmp12_ = ggit_diff_file_get_path (_tmp11_);
	_tmp13_ = g_strdup (_tmp12_);
	old_path = _tmp13_;
	_tmp14_ = old_path;
	if (_tmp14_ != NULL) {
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp15_ = old_path;
		_tmp16_ = string_to_string (_tmp15_);
		_tmp17_ = g_strconcat ("path:", _tmp16_, NULL);
		result = _tmp17_;
		_g_free0 (old_path);
		_ggit_diff_file_unref0 (old_file);
		_g_free0 (new_path);
		_ggit_diff_file_unref0 (new_file);
		return result;
	}
	_tmp18_ = g_strdup ("");
	result = _tmp18_;
	_g_free0 (old_path);
	_ggit_diff_file_unref0 (old_file);
	_g_free0 (new_path);
	_ggit_diff_file_unref0 (new_file);
	return result;
}

static Block14Data*
block14_data_ref (Block14Data* _data14_)
{
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}

static void
block14_data_unref (void * _userdata_)
{
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		GitgDiffView* self;
		self = _data14_->self;
		(_data14_->check_finish_target_destroy_notify == NULL) ? NULL : (_data14_->check_finish_target_destroy_notify (_data14_->check_finish_target), NULL);
		_data14_->check_finish = NULL;
		_data14_->check_finish_target = NULL;
		_data14_->check_finish_target_destroy_notify = NULL;
		_g_object_unref0 (_data14_->infomap);
		_g_object_unref0 (_data14_->diff);
		_g_object_unref0 (_data14_->cancellable);
		_g_object_unref0 (self);
		g_slice_free (Block14Data, _data14_);
	}
}

static void
__lambda65_ (Block14Data* _data14_)
{
	GitgDiffView* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	self = _data14_->self;
	if (_data14_->nqueries == 0) {
		_tmp1_ = _data14_->finished;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp2_ = FALSE;
		if (_data14_->cancellable == NULL) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = !g_cancellable_is_cancelled (_data14_->cancellable);
		}
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GeeHashMap* _tmp3_;
		_data14_->finished = FALSE;
		_tmp3_ = _data14_->infomap;
		gitg_diff_view_update_diff_hunks (self, _data14_->diff, _data14_->preserve_expanded, _tmp3_, _data14_->cancellable);
	}
}

static void
___lambda65__gitg_diff_view_anon (gpointer self)
{
	__lambda65_ (self);
}

static Block15Data*
block15_data_ref (Block15Data* _data15_)
{
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}

static void
block15_data_unref (void * _userdata_)
{
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		GitgDiffView* self;
		self = _data15_->_data14_->self;
		_g_object_unref0 (_data15_->info);
		_ggit_diff_delta_unref0 (_data15_->delta);
		block14_data_unref (_data15_->_data14_);
		_data15_->_data14_ = NULL;
		g_slice_free (Block15Data, _data15_);
	}
}

static void
_____lambda76_ (Block15Data* _data15_,
                GObject* obj,
                GAsyncResult* res)
{
	Block14Data* _data14_;
	GitgDiffView* self;
	GitgDiffViewFileInfo* _tmp0_;
	GeeHashMap* _tmp1_;
	GgitDiffDelta* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GitgDiffViewFileInfo* _tmp5_;
	gint _tmp6_;
	GitgDiffViewAnon _tmp7_;
	gpointer _tmp7__target;
	_data14_ = _data15_->_data14_;
	self = _data14_->self;
	g_return_if_fail (res != NULL);
	_tmp0_ = _data15_->info;
	gitg_diff_view_file_info_query_finish (_tmp0_, res);
	_tmp1_ = _data14_->infomap;
	_tmp2_ = _data15_->delta;
	_tmp3_ = gitg_diff_view_key_for_delta (self, _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _data15_->info;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp1_, _tmp4_, _tmp5_);
	_g_free0 (_tmp4_);
	_tmp6_ = _data14_->nqueries;
	_data14_->nqueries = _tmp6_ - 1;
	_tmp7_ = _data14_->check_finish;
	_tmp7__target = _data14_->check_finish_target;
	_tmp7_ (_tmp7__target);
}

static void
______lambda76__gasync_ready_callback (GObject* source_object,
                                       GAsyncResult* res,
                                       gpointer self)
{
	_____lambda76_ (self, source_object, res);
	block15_data_unref (self);
}

static void
gitg_diff_view_update_diff (GitgDiffView* self,
                            GgitDiff* diff,
                            gboolean preserve_expanded,
                            GCancellable* cancellable)
{
	Block14Data* _data14_;
	GgitDiff* _tmp0_;
	GCancellable* _tmp1_;
	GeeHashMap* _tmp2_;
	GitgDiffViewAnon _tmp14_;
	gpointer _tmp14__target;
	g_return_if_fail (self != NULL);
	g_return_if_fail (diff != NULL);
	_data14_ = g_slice_new0 (Block14Data);
	_data14_->_ref_count_ = 1;
	_data14_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (diff);
	_g_object_unref0 (_data14_->diff);
	_data14_->diff = _tmp0_;
	_data14_->preserve_expanded = preserve_expanded;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data14_->cancellable);
	_data14_->cancellable = _tmp1_;
	_data14_->nqueries = 0;
	_data14_->finished = FALSE;
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GITG_TYPE_DIFF_VIEW_FILE_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_data14_->infomap = _tmp2_;
	_data14_->check_finish = ___lambda65__gitg_diff_view_anon;
	_data14_->check_finish_target = block14_data_ref (_data14_);
	_data14_->check_finish_target_destroy_notify = block14_data_unref;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				Block15Data* _data15_;
				GgitDiffDelta* _tmp5_;
				GitgRepository* _tmp6_;
				GitgRepository* _tmp7_;
				GgitDiffDelta* _tmp8_;
				gboolean _tmp9_;
				GitgDiffViewFileInfo* _tmp10_;
				gint _tmp11_;
				GitgDiffViewFileInfo* _tmp12_;
				GCancellable* _tmp13_;
				_data15_ = g_slice_new0 (Block15Data);
				_data15_->_ref_count_ = 1;
				_data15_->_data14_ = block14_data_ref (_data14_);
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				if (!(((gsize) i) < ggit_diff_get_num_deltas (_data14_->diff))) {
					block15_data_unref (_data15_);
					_data15_ = NULL;
					break;
				}
				_tmp5_ = ggit_diff_get_delta (_data14_->diff, (gsize) i);
				_data15_->delta = _tmp5_;
				_tmp6_ = gitg_diff_view_get_repository (self);
				_tmp7_ = _tmp6_;
				_tmp8_ = _data15_->delta;
				_tmp9_ = self->priv->_new_is_workdir;
				_tmp10_ = gitg_diff_view_file_info_new (_tmp7_, _tmp8_, _tmp9_);
				_data15_->info = _tmp10_;
				_tmp11_ = _data14_->nqueries;
				_data14_->nqueries = _tmp11_ + 1;
				_tmp12_ = _data15_->info;
				_tmp13_ = _data14_->cancellable;
				gitg_diff_view_file_info_query (_tmp12_, _tmp13_, ______lambda76__gasync_ready_callback, block15_data_ref (_data15_));
				block15_data_unref (_data15_);
				_data15_ = NULL;
			}
		}
	}
	_data14_->finished = TRUE;
	_tmp14_ = _data14_->check_finish;
	_tmp14__target = _data14_->check_finish_target;
	_tmp14_ (_tmp14__target);
	block14_data_unref (_data14_);
	_data14_ = NULL;
}

static Block16Data*
block16_data_ref (Block16Data* _data16_)
{
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}

static void
block16_data_unref (void * _userdata_)
{
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		GitgDiffView* self;
		self = _data16_->self;
		(_data16_->add_file_target_destroy_notify == NULL) ? NULL : (_data16_->add_file_target_destroy_notify (_data16_->add_file_target), NULL);
		_data16_->add_file = NULL;
		_data16_->add_file_target = NULL;
		_data16_->add_file_target_destroy_notify = NULL;
		(_data16_->add_hunk_target_destroy_notify == NULL) ? NULL : (_data16_->add_hunk_target_destroy_notify (_data16_->add_hunk_target), NULL);
		_data16_->add_hunk = NULL;
		_data16_->add_hunk_target = NULL;
		_data16_->add_hunk_target_destroy_notify = NULL;
		_g_object_unref0 (_data16_->current_lines);
		_ggit_diff_hunk_unref0 (_data16_->current_hunk);
		_g_object_unref0 (_data16_->current_file);
		_g_object_unref0 (_data16_->files);
		_g_object_unref0 (_data16_->infomap);
		_g_object_unref0 (_data16_->cancellable);
		_g_object_unref0 (self);
		g_slice_free (Block16Data, _data16_);
	}
}

static void
__lambda66_ (Block16Data* _data16_)
{
	GitgDiffView* self;
	self = _data16_->self;
	if (_data16_->current_hunk != NULL) {
		gitg_diff_view_file_add_hunk (_data16_->current_file, _data16_->current_hunk, _data16_->current_lines);
		_g_object_unref0 (_data16_->current_lines);
		_data16_->current_lines = NULL;
		_ggit_diff_hunk_unref0 (_data16_->current_hunk);
		_data16_->current_hunk = NULL;
	}
}

static void
___lambda66__gitg_diff_view_anon (gpointer self)
{
	__lambda66_ (self);
}

static void
__lambda67_ (Block16Data* _data16_)
{
	GitgDiffView* self;
	self = _data16_->self;
	_data16_->add_hunk (_data16_->add_hunk_target);
	if (_data16_->current_file != NULL) {
		gtk_widget_show ((GtkWidget*) _data16_->current_file);
		gee_abstract_collection_add ((GeeAbstractCollection*) _data16_->files, _data16_->current_file);
		_g_object_unref0 (_data16_->current_file);
		_data16_->current_file = NULL;
	}
}

static void
___lambda67__gitg_diff_view_anon (gpointer self)
{
	__lambda67_ (self);
}

static Block17Data*
block17_data_ref (Block17Data* _data17_)
{
	g_atomic_int_inc (&_data17_->_ref_count_);
	return _data17_;
}

static void
block17_data_unref (void * _userdata_)
{
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
		GitgDiffView* self;
		self = _data17_->_data16_->self;
		_g_free0 (_data17_->deltakey);
		_g_object_unref0 (_data17_->info);
		block16_data_unref (_data17_->_data16_);
		_data17_->_data16_ = NULL;
		g_slice_free (Block17Data, _data17_);
	}
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
_gitg_diff_view_on_selection_changed_g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self)
{
	gitg_diff_view_on_selection_changed ((GitgDiffView*) self);
}

static gint
_____lambda69_ (Block17Data* _data17_,
                GgitDiffDelta* delta,
                gfloat progress)
{
	Block16Data* _data16_;
	GitgDiffView* self;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GitgDiffViewFileInfo* _tmp9_;
	GitgDiffViewFile* _tmp10_;
	gboolean _tmp11_;
	gint result;
	_data16_ = _data17_->_data16_;
	self = _data16_->self;
	g_return_val_if_fail (delta != NULL, 0);
	if (_data16_->cancellable != NULL) {
		_tmp0_ = g_cancellable_is_cancelled (_data16_->cancellable);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 1;
		return result;
	}
	_tmp1_ = gitg_diff_view_key_for_delta (self, delta);
	_g_free0 (_data17_->deltakey);
	_data17_->deltakey = _tmp1_;
	_tmp2_ = _data17_->deltakey;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _data16_->infomap, _tmp2_)) {
		const gchar* _tmp3_;
		gpointer _tmp4_;
		_tmp3_ = _data17_->deltakey;
		_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) _data16_->infomap, _tmp3_);
		_g_object_unref0 (_data17_->info);
		_data17_->info = (GitgDiffViewFileInfo*) _tmp4_;
	} else {
		GitgRepository* _tmp5_;
		GitgRepository* _tmp6_;
		gboolean _tmp7_;
		GitgDiffViewFileInfo* _tmp8_;
		_tmp5_ = gitg_diff_view_get_repository (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->priv->_new_is_workdir;
		_tmp8_ = gitg_diff_view_file_info_new (_tmp6_, delta, _tmp7_);
		_g_object_unref0 (_data17_->info);
		_data17_->info = _tmp8_;
	}
	_tmp9_ = _data17_->info;
	_tmp10_ = gitg_diff_view_file_new (_tmp9_);
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (_data16_->current_file);
	_data16_->current_file = _tmp10_;
	_tmp11_ = self->priv->_handle_selection;
	gitg_diff_view_file_add_text_renderer (_data16_->current_file, _tmp11_);
	result = 0;
	return result;
}

static gint
______lambda69__ggit_diff_file_callback (GgitDiffDelta* delta,
                                         gfloat progress,
                                         gpointer self)
{
	gint result;
	result = _____lambda69_ (self, delta, progress);
	return result;
}

static gint
_____lambda70_ (Block17Data* _data17_,
                GgitDiffDelta* delta,
                GgitDiffBinary* binary)
{
	Block16Data* _data16_;
	GitgDiffView* self;
	gboolean _tmp0_ = FALSE;
	gint result;
	_data16_ = _data17_->_data16_;
	self = _data16_->self;
	g_return_val_if_fail (delta != NULL, 0);
	g_return_val_if_fail (binary != NULL, 0);
	if (_data16_->cancellable != NULL) {
		_tmp0_ = g_cancellable_is_cancelled (_data16_->cancellable);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 1;
		return result;
	}
	result = 0;
	return result;
}

static gint
______lambda70__ggit_diff_binary_callback (GgitDiffDelta* delta,
                                           GgitDiffBinary* binary,
                                           gpointer self)
{
	gint result;
	result = _____lambda70_ (self, delta, binary);
	return result;
}

static gpointer
_ggit_diff_hunk_ref0 (gpointer self)
{
	return self ? ggit_diff_hunk_ref (self) : NULL;
}

static gint
_____lambda71_ (Block17Data* _data17_,
                GgitDiffDelta* delta,
                GgitDiffHunk* hunk)
{
	Block16Data* _data16_;
	GitgDiffView* self;
	gboolean _tmp0_ = FALSE;
	gint result;
	_data16_ = _data17_->_data16_;
	self = _data16_->self;
	g_return_val_if_fail (delta != NULL, 0);
	g_return_val_if_fail (hunk != NULL, 0);
	if (_data16_->cancellable != NULL) {
		_tmp0_ = g_cancellable_is_cancelled (_data16_->cancellable);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 1;
		return result;
	}
	if (!_data16_->current_is_binary) {
		GgitDiffHunk* _tmp1_;
		GeeArrayList* _tmp2_;
		_data16_->maxlines = MAX (_data16_->maxlines, ggit_diff_hunk_get_old_start (hunk) + ggit_diff_hunk_get_old_lines (hunk));
		_data16_->maxlines = MAX (_data16_->maxlines, ggit_diff_hunk_get_new_start (hunk) + ggit_diff_hunk_get_new_lines (hunk));
		_data16_->add_hunk (_data16_->add_hunk_target);
		_tmp1_ = _ggit_diff_hunk_ref0 (hunk);
		_ggit_diff_hunk_unref0 (_data16_->current_hunk);
		_data16_->current_hunk = _tmp1_;
		_tmp2_ = gee_array_list_new (ggit_diff_line_get_type (), (GBoxedCopyFunc) ggit_diff_line_ref, (GDestroyNotify) ggit_diff_line_unref, NULL, NULL, NULL);
		_g_object_unref0 (_data16_->current_lines);
		_data16_->current_lines = _tmp2_;
	}
	result = 0;
	return result;
}

static gint
______lambda71__ggit_diff_hunk_callback (GgitDiffDelta* delta,
                                         GgitDiffHunk* hunk,
                                         gpointer self)
{
	gint result;
	result = _____lambda71_ (self, delta, hunk);
	return result;
}

static gint
_____lambda72_ (Block17Data* _data17_,
                GgitDiffDelta* delta,
                GgitDiffHunk* hunk,
                GgitDiffLine* line)
{
	Block16Data* _data16_;
	GitgDiffView* self;
	gboolean _tmp0_ = FALSE;
	gint result;
	_data16_ = _data17_->_data16_;
	self = _data16_->self;
	g_return_val_if_fail (delta != NULL, 0);
	g_return_val_if_fail (line != NULL, 0);
	if (_data16_->cancellable != NULL) {
		_tmp0_ = g_cancellable_is_cancelled (_data16_->cancellable);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 1;
		return result;
	}
	if (!_data16_->current_is_binary) {
		gee_abstract_collection_add ((GeeAbstractCollection*) _data16_->current_lines, line);
	}
	result = 0;
	return result;
}

static gint
______lambda72__ggit_diff_line_callback (GgitDiffDelta* delta,
                                         GgitDiffHunk* hunk,
                                         GgitDiffLine* line,
                                         gpointer self)
{
	gint result;
	result = _____lambda72_ (self, delta, hunk, line);
	return result;
}

static gint
___lambda68_ (Block16Data* _data16_,
              GgitDiffDelta* delta,
              gfloat progress)
{
	GitgDiffView* self;
	Block17Data* _data17_;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar** known_binary_files_types = NULL;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gint known_binary_files_types_length1;
	gint _known_binary_files_types_size_;
	gboolean _tmp11_ = FALSE;
	GitgDiffViewFileInfo* _tmp12_;
	gchar* mime_type_for_image = NULL;
	gboolean _tmp17_ = FALSE;
	GitgDiffViewFileInfo* _tmp18_;
	gboolean _tmp39_ = FALSE;
	const gchar* _tmp40_;
	gboolean can_diff_as_image = FALSE;
	gboolean can_diff_as_text = FALSE;
	const gchar* _tmp43_;
	GitgDiffViewFileInfo* _tmp44_;
	GitgDiffViewFile* _tmp45_;
	gboolean _tmp46_ = FALSE;
	gboolean _tmp47_ = FALSE;
	GError* _inner_error0_ = NULL;
	gint result;
	self = _data16_->self;
	g_return_val_if_fail (delta != NULL, 0);
	_data17_ = g_slice_new0 (Block17Data);
	_data17_->_ref_count_ = 1;
	_data17_->_data16_ = block16_data_ref (_data16_);
	if (_data16_->cancellable != NULL) {
		_tmp0_ = g_cancellable_is_cancelled (_data16_->cancellable);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 1;
		block17_data_unref (_data17_);
		_data17_ = NULL;
		return result;
	}
	_data16_->add_file (_data16_->add_file_target);
	_data17_->info = NULL;
	_tmp1_ = gitg_diff_view_key_for_delta (self, delta);
	_data17_->deltakey = _tmp1_;
	_tmp2_ = _data17_->deltakey;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _data16_->infomap, _tmp2_)) {
		const gchar* _tmp3_;
		gpointer _tmp4_;
		_tmp3_ = _data17_->deltakey;
		_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) _data16_->infomap, _tmp3_);
		_g_object_unref0 (_data17_->info);
		_data17_->info = (GitgDiffViewFileInfo*) _tmp4_;
	} else {
		GitgRepository* _tmp5_;
		GitgRepository* _tmp6_;
		gboolean _tmp7_;
		GitgDiffViewFileInfo* _tmp8_;
		_tmp5_ = gitg_diff_view_get_repository (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->priv->_new_is_workdir;
		_tmp8_ = gitg_diff_view_file_info_new (_tmp6_, delta, _tmp7_);
		_g_object_unref0 (_data17_->info);
		_data17_->info = _tmp8_;
	}
	_data16_->current_is_binary = (ggit_diff_delta_get_flags (delta) & GGIT_DIFF_FLAG_BINARY) != 0;
	_tmp9_ = g_strdup ("application/pdf");
	_tmp10_ = g_new0 (gchar*, 1 + 1);
	_tmp10_[0] = _tmp9_;
	known_binary_files_types = _tmp10_;
	known_binary_files_types_length1 = 1;
	_known_binary_files_types_size_ = known_binary_files_types_length1;
	_tmp12_ = _data17_->info;
	if (_tmp12_ != NULL) {
		GitgDiffViewFileInfo* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		gchar** _tmp16_;
		gint _tmp16__length1;
		_tmp13_ = _data17_->info;
		_tmp14_ = gitg_diff_view_file_info_get_new_file_content_type (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = known_binary_files_types;
		_tmp16__length1 = known_binary_files_types_length1;
		_tmp11_ = _vala_string_array_contains (_tmp16_, _tmp16__length1, _tmp15_);
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		_data16_->current_is_binary = TRUE;
	}
	mime_type_for_image = NULL;
	_tmp18_ = _data17_->info;
	if (_tmp18_ == NULL) {
		_tmp17_ = TRUE;
	} else {
		GitgDiffViewFileInfo* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		_tmp19_ = _data17_->info;
		_tmp20_ = gitg_diff_view_file_info_get_new_file_content_type (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp17_ = _tmp21_ == NULL;
	}
	if (_tmp17_) {
		gchar* oldpath = NULL;
		GgitDiffFile* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		const gchar* _tmp25_;
		_tmp22_ = ggit_diff_delta_get_old_file (delta);
		_tmp23_ = ggit_diff_file_get_path (_tmp22_);
		_tmp24_ = g_strdup (_tmp23_);
		oldpath = _tmp24_;
		_tmp25_ = oldpath;
		if (_tmp25_ != NULL) {
			gboolean uncertain = FALSE;
			gchar* ctype = NULL;
			const gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			gboolean _tmp29_ = FALSE;
			gchar* _tmp30_;
			gchar* _tmp31_;
			const gchar* _tmp32_;
			_tmp26_ = oldpath;
			_tmp27_ = g_path_get_basename (_tmp26_);
			_tmp28_ = _tmp27_;
			_tmp30_ = g_content_type_guess (_tmp28_, NULL, (gsize) 0, &_tmp29_);
			uncertain = _tmp29_;
			_tmp31_ = _tmp30_;
			_g_free0 (_tmp28_);
			ctype = _tmp31_;
			_tmp32_ = ctype;
			if (_tmp32_ != NULL) {
				const gchar* _tmp33_;
				gchar* _tmp34_;
				_tmp33_ = ctype;
				_tmp34_ = g_content_type_get_mime_type (_tmp33_);
				_g_free0 (mime_type_for_image);
				mime_type_for_image = _tmp34_;
			}
			_g_free0 (ctype);
		}
		_g_free0 (oldpath);
	} else {
		GitgDiffViewFileInfo* _tmp35_;
		const gchar* _tmp36_;
		const gchar* _tmp37_;
		gchar* _tmp38_;
		_tmp35_ = _data17_->info;
		_tmp36_ = gitg_diff_view_file_info_get_new_file_content_type (_tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = g_content_type_get_mime_type (_tmp37_);
		_g_free0 (mime_type_for_image);
		mime_type_for_image = _tmp38_;
	}
	_tmp40_ = mime_type_for_image;
	if (_tmp40_ != NULL) {
		GeeHashSet* _tmp41_;
		const gchar* _tmp42_;
		_tmp41_ = gitg_diff_view_s_image_mime_types;
		_tmp42_ = mime_type_for_image;
		_tmp39_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp41_, _tmp42_);
	} else {
		_tmp39_ = FALSE;
	}
	can_diff_as_image = _tmp39_;
	_tmp43_ = mime_type_for_image;
	can_diff_as_text = g_content_type_is_mime_type (_tmp43_, "text/plain");
	_tmp44_ = _data17_->info;
	_tmp45_ = gitg_diff_view_file_new (_tmp44_);
	g_object_ref_sink (_tmp45_);
	_g_object_unref0 (_data16_->current_file);
	_data16_->current_file = _tmp45_;
	if (can_diff_as_image) {
		gitg_diff_view_file_add_image_renderer (_data16_->current_file);
	}
	if (!can_diff_as_image) {
		_tmp47_ = !_data16_->current_is_binary;
	} else {
		_tmp47_ = FALSE;
	}
	if (_tmp47_) {
		_tmp46_ = !can_diff_as_text;
	} else {
		_tmp46_ = FALSE;
	}
	if (_tmp46_) {
		can_diff_as_text = TRUE;
	}
	if (can_diff_as_text) {
		gboolean _tmp48_;
		GeeArrayList* renderer_list = NULL;
		GeeArrayList* _tmp49_;
		GeeArrayList* _tmp50_;
		GeeArrayList* _tmp51_;
		_tmp48_ = self->priv->_handle_selection;
		gitg_diff_view_file_add_text_renderer (_data16_->current_file, _tmp48_);
		_tmp49_ = gitg_diff_view_file_get_renderer_list (_data16_->current_file);
		_tmp50_ = _tmp49_;
		_tmp51_ = _g_object_ref0 (_tmp50_);
		renderer_list = _tmp51_;
		{
			GeeArrayList* _renderer_list = NULL;
			GeeArrayList* _tmp52_;
			gint _renderer_size = 0;
			GeeArrayList* _tmp53_;
			gint _tmp54_;
			gint _tmp55_;
			gint _renderer_index = 0;
			_tmp52_ = renderer_list;
			_renderer_list = _tmp52_;
			_tmp53_ = _renderer_list;
			_tmp54_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp53_);
			_tmp55_ = _tmp54_;
			_renderer_size = _tmp55_;
			_renderer_index = -1;
			while (TRUE) {
				gint _tmp56_;
				gint _tmp57_;
				GitgDiffViewFileRenderer* renderer = NULL;
				GeeArrayList* _tmp58_;
				gpointer _tmp59_;
				GitgDiffViewFileRendererTextable* renderer_text = NULL;
				GitgDiffViewFileRenderer* _tmp60_;
				GitgDiffViewFileRendererTextable* _tmp61_;
				GitgDiffViewFileRendererTextable* _tmp62_;
				_renderer_index = _renderer_index + 1;
				_tmp56_ = _renderer_index;
				_tmp57_ = _renderer_size;
				if (!(_tmp56_ < _tmp57_)) {
					break;
				}
				_tmp58_ = _renderer_list;
				_tmp59_ = gee_abstract_list_get ((GeeAbstractList*) _tmp58_, _renderer_index);
				renderer = (GitgDiffViewFileRenderer*) _tmp59_;
				_tmp60_ = renderer;
				_tmp61_ = _g_object_ref0 (GITG_IS_DIFF_VIEW_FILE_RENDERER_TEXTABLE (_tmp60_) ? ((GitgDiffViewFileRendererTextable*) _tmp60_) : NULL);
				renderer_text = _tmp61_;
				_tmp62_ = renderer_text;
				if (_tmp62_ != NULL) {
					GitgDiffViewFileRendererTextable* _tmp63_;
					GitgDiffViewFileRendererTextable* _tmp64_;
					GitgDiffViewFileRendererTextable* _tmp65_;
					GitgDiffViewFileRendererTextable* _tmp66_;
					GitgDiffViewFileRendererTextable* _tmp67_;
					_tmp63_ = renderer_text;
					g_object_bind_property_with_closures ((GObject*) self, "highlight", (GObject*) _tmp63_, "highlight", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
					_tmp64_ = renderer_text;
					g_object_bind_property_with_closures ((GObject*) self, "wrap-lines", (GObject*) _tmp64_, "wrap-lines", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
					_tmp65_ = renderer_text;
					g_object_bind_property_with_closures ((GObject*) self, "tab-width", (GObject*) _tmp65_, "tab-width", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
					_tmp66_ = renderer_text;
					gitg_diff_view_file_renderer_textable_set_maxlines (_tmp66_, _data16_->maxlines);
					_tmp67_ = renderer_text;
					g_signal_connect_object ((GObject*) _tmp67_, "notify::has-selection", (GCallback) _gitg_diff_view_on_selection_changed_g_object_notify, self, 0);
				}
				_g_object_unref0 (renderer_text);
				_g_object_unref0 (renderer);
			}
		}
		gitg_diff_view_on_selection_changed (self);
		_g_object_unref0 (renderer_list);
	}
	if (_data16_->current_is_binary) {
		{
			GgitDiffFile* new_file = NULL;
			GgitDiffFile* _tmp68_;
			GgitDiffFile* _tmp69_;
			GgitDiffFile* old_file = NULL;
			GgitDiffFile* _tmp70_;
			GgitDiffFile* _tmp71_;
			gboolean _tmp72_ = FALSE;
			GitgRepository* _tmp73_;
			GitgRepository* _tmp74_;
			GgitDiffFile* _tmp75_;
			_tmp68_ = ggit_diff_delta_get_new_file (delta);
			_tmp69_ = _ggit_diff_file_ref0 (_tmp68_);
			new_file = _tmp69_;
			_tmp70_ = ggit_diff_delta_get_old_file (delta);
			_tmp71_ = _ggit_diff_file_ref0 (_tmp70_);
			old_file = _tmp71_;
			_tmp73_ = gitg_diff_view_get_repository (self);
			_tmp74_ = _tmp73_;
			_tmp75_ = old_file;
			if (gitg_text_conv_has_textconv_command (_tmp74_, _tmp75_)) {
				_tmp72_ = TRUE;
			} else {
				GitgRepository* _tmp76_;
				GitgRepository* _tmp77_;
				GgitDiffFile* _tmp78_;
				_tmp76_ = gitg_diff_view_get_repository (self);
				_tmp77_ = _tmp76_;
				_tmp78_ = new_file;
				_tmp72_ = gitg_text_conv_has_textconv_command (_tmp77_, _tmp78_);
			}
			if (_tmp72_) {
				guint8* n_textconv = NULL;
				GitgRepository* _tmp79_;
				GitgRepository* _tmp80_;
				GgitDiffFile* _tmp81_;
				gint _tmp82_ = 0;
				guint8* _tmp83_;
				gint n_textconv_length1;
				gint _n_textconv_size_;
				guint8* o_textconv = NULL;
				GitgRepository* _tmp84_;
				GitgRepository* _tmp85_;
				GgitDiffFile* _tmp86_;
				gint _tmp87_ = 0;
				guint8* _tmp88_;
				gint o_textconv_length1;
				gint _o_textconv_size_;
				GgitDiffOptions* opts = NULL;
				GgitDiffOptions* _tmp89_;
				GgitDiffOptions* _tmp90_;
				GgitDiffOptions* _tmp91_;
				GgitDiffOptions* _tmp92_;
				GgitDiff* bdiff = NULL;
				guint8* _tmp93_;
				gint _tmp93__length1;
				GgitDiffFile* _tmp94_;
				const gchar* _tmp95_;
				guint8* _tmp96_;
				gint _tmp96__length1;
				GgitDiffFile* _tmp97_;
				const gchar* _tmp98_;
				GgitDiffOptions* _tmp99_;
				GgitDiff* _tmp100_;
				GgitDiff* _tmp101_;
				_tmp79_ = gitg_diff_view_get_repository (self);
				_tmp80_ = _tmp79_;
				_tmp81_ = new_file;
				_tmp83_ = gitg_text_conv_get_textconv_content (_tmp80_, _tmp81_, &_tmp82_);
				n_textconv = _tmp83_;
				n_textconv_length1 = _tmp82_;
				_n_textconv_size_ = n_textconv_length1;
				_tmp84_ = gitg_diff_view_get_repository (self);
				_tmp85_ = _tmp84_;
				_tmp86_ = old_file;
				_tmp88_ = gitg_text_conv_get_textconv_content (_tmp85_, _tmp86_, &_tmp87_);
				o_textconv = _tmp88_;
				o_textconv_length1 = _tmp87_;
				_o_textconv_size_ = o_textconv_length1;
				_data16_->current_is_binary = FALSE;
				_tmp89_ = ggit_diff_options_new ();
				opts = _tmp89_;
				_tmp90_ = opts;
				ggit_diff_options_set_flags (_tmp90_, ((GGIT_DIFF_INCLUDE_UNTRACKED | GGIT_DIFF_IGNORE_WHITESPACE) | GGIT_DIFF_DISABLE_PATHSPEC_MATCH) | GGIT_DIFF_RECURSE_UNTRACKED_DIRS);
				_tmp91_ = opts;
				ggit_diff_options_set_n_context_lines (_tmp91_, 3);
				_tmp92_ = opts;
				ggit_diff_options_set_n_interhunk_lines (_tmp92_, 3);
				_tmp93_ = o_textconv;
				_tmp93__length1 = o_textconv_length1;
				_tmp94_ = old_file;
				_tmp95_ = ggit_diff_file_get_path (_tmp94_);
				_tmp96_ = n_textconv;
				_tmp96__length1 = n_textconv_length1;
				_tmp97_ = new_file;
				_tmp98_ = ggit_diff_file_get_path (_tmp97_);
				_tmp99_ = opts;
				_tmp100_ = ggit_diff_new_buffers (_tmp93_, _tmp93__length1, _tmp95_, _tmp96_, _tmp96__length1, _tmp98_, _tmp99_, &_inner_error0_);
				bdiff = _tmp100_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (opts);
					o_textconv = (g_free (o_textconv), NULL);
					n_textconv = (g_free (n_textconv), NULL);
					_ggit_diff_file_unref0 (old_file);
					_ggit_diff_file_unref0 (new_file);
					goto __catch0_g_error;
				}
				_tmp101_ = bdiff;
				ggit_diff_foreach (_tmp101_, ______lambda69__ggit_diff_file_callback, ______lambda70__ggit_diff_binary_callback, ______lambda71__ggit_diff_hunk_callback, ______lambda72__ggit_diff_line_callback, _data17_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (bdiff);
					_g_object_unref0 (opts);
					o_textconv = (g_free (o_textconv), NULL);
					n_textconv = (g_free (n_textconv), NULL);
					_ggit_diff_file_unref0 (old_file);
					_ggit_diff_file_unref0 (new_file);
					goto __catch0_g_error;
				}
				_data16_->add_hunk (_data16_->add_hunk_target);
				_data16_->add_file (_data16_->add_file_target);
				_g_object_unref0 (bdiff);
				_g_object_unref0 (opts);
				o_textconv = (g_free (o_textconv), NULL);
				n_textconv = (g_free (n_textconv), NULL);
			}
			_ggit_diff_file_unref0 (old_file);
			_ggit_diff_file_unref0 (new_file);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* _error_ = NULL;
			FILE* _tmp102_;
			GError* _tmp103_;
			const gchar* _tmp104_;
			const gchar* _tmp105_;
			gchar* _tmp106_;
			gchar* _tmp107_;
			_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp102_ = stderr;
			_tmp103_ = _error_;
			_tmp104_ = _tmp103_->message;
			_tmp105_ = string_to_string (_tmp104_);
			_tmp106_ = g_strconcat ("Error: ", _tmp105_, "\n", NULL);
			_tmp107_ = _tmp106_;
			fprintf (_tmp102_, "%s", _tmp107_);
			_g_free0 (_tmp107_);
			_g_error_free0 (_error_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp108_ = -1;
			_g_free0 (mime_type_for_image);
			known_binary_files_types = (_vala_array_free (known_binary_files_types, known_binary_files_types_length1, (GDestroyNotify) g_free), NULL);
			block17_data_unref (_data17_);
			_data17_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp108_;
		}
		if (_data16_->current_is_binary) {
			gitg_diff_view_file_add_binary_renderer (_data16_->current_file);
		}
	}
	result = 0;
	_g_free0 (mime_type_for_image);
	known_binary_files_types = (_vala_array_free (known_binary_files_types, known_binary_files_types_length1, (GDestroyNotify) g_free), NULL);
	block17_data_unref (_data17_);
	_data17_ = NULL;
	return result;
}

static gint
____lambda68__ggit_diff_file_callback (GgitDiffDelta* delta,
                                       gfloat progress,
                                       gpointer self)
{
	gint result;
	result = ___lambda68_ (self, delta, progress);
	return result;
}

static gint
___lambda73_ (Block16Data* _data16_,
              GgitDiffDelta* delta,
              GgitDiffBinary* binary)
{
	GitgDiffView* self;
	gboolean _tmp0_ = FALSE;
	gint result;
	self = _data16_->self;
	g_return_val_if_fail (delta != NULL, 0);
	g_return_val_if_fail (binary != NULL, 0);
	if (_data16_->cancellable != NULL) {
		_tmp0_ = g_cancellable_is_cancelled (_data16_->cancellable);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 1;
		return result;
	}
	result = 0;
	return result;
}

static gint
____lambda73__ggit_diff_binary_callback (GgitDiffDelta* delta,
                                         GgitDiffBinary* binary,
                                         gpointer self)
{
	gint result;
	result = ___lambda73_ (self, delta, binary);
	return result;
}

static gint
___lambda74_ (Block16Data* _data16_,
              GgitDiffDelta* delta,
              GgitDiffHunk* hunk)
{
	GitgDiffView* self;
	gboolean _tmp0_ = FALSE;
	gint result;
	self = _data16_->self;
	g_return_val_if_fail (delta != NULL, 0);
	g_return_val_if_fail (hunk != NULL, 0);
	if (_data16_->cancellable != NULL) {
		_tmp0_ = g_cancellable_is_cancelled (_data16_->cancellable);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 1;
		return result;
	}
	if (!_data16_->current_is_binary) {
		GgitDiffHunk* _tmp1_;
		GeeArrayList* _tmp2_;
		_data16_->maxlines = MAX (_data16_->maxlines, ggit_diff_hunk_get_old_start (hunk) + ggit_diff_hunk_get_old_lines (hunk));
		_data16_->maxlines = MAX (_data16_->maxlines, ggit_diff_hunk_get_new_start (hunk) + ggit_diff_hunk_get_new_lines (hunk));
		_data16_->add_hunk (_data16_->add_hunk_target);
		_tmp1_ = _ggit_diff_hunk_ref0 (hunk);
		_ggit_diff_hunk_unref0 (_data16_->current_hunk);
		_data16_->current_hunk = _tmp1_;
		_tmp2_ = gee_array_list_new (ggit_diff_line_get_type (), (GBoxedCopyFunc) ggit_diff_line_ref, (GDestroyNotify) ggit_diff_line_unref, NULL, NULL, NULL);
		_g_object_unref0 (_data16_->current_lines);
		_data16_->current_lines = _tmp2_;
	}
	result = 0;
	return result;
}

static gint
____lambda74__ggit_diff_hunk_callback (GgitDiffDelta* delta,
                                       GgitDiffHunk* hunk,
                                       gpointer self)
{
	gint result;
	result = ___lambda74_ (self, delta, hunk);
	return result;
}

static gint
___lambda75_ (Block16Data* _data16_,
              GgitDiffDelta* delta,
              GgitDiffHunk* hunk,
              GgitDiffLine* line)
{
	GitgDiffView* self;
	gboolean _tmp0_ = FALSE;
	gint result;
	self = _data16_->self;
	g_return_val_if_fail (delta != NULL, 0);
	g_return_val_if_fail (line != NULL, 0);
	if (_data16_->cancellable != NULL) {
		_tmp0_ = g_cancellable_is_cancelled (_data16_->cancellable);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 1;
		return result;
	}
	if (!_data16_->current_is_binary) {
		gee_abstract_collection_add ((GeeAbstractCollection*) _data16_->current_lines, line);
	}
	result = 0;
	return result;
}

static gint
____lambda75__ggit_diff_line_callback (GgitDiffDelta* delta,
                                       GgitDiffHunk* hunk,
                                       GgitDiffLine* line,
                                       gpointer self)
{
	gint result;
	result = ___lambda75_ (self, delta, hunk, line);
	return result;
}

static void
_gitg_diff_view_auto_update_expanded_g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self)
{
	gitg_diff_view_auto_update_expanded ((GitgDiffView*) self);
}

static void
gitg_diff_view_update_diff_hunks (GitgDiffView* self,
                                  GgitDiff* diff,
                                  gboolean preserve_expanded,
                                  GeeHashMap* infomap,
                                  GCancellable* cancellable)
{
	Block16Data* _data16_;
	GeeHashMap* _tmp0_;
	GCancellable* _tmp1_;
	GeeArrayList* _tmp2_;
	GList* file_widgets = NULL;
	GtkGrid* _tmp3_;
	GList* _tmp4_;
	GeeHashSet* was_expanded = NULL;
	GeeHashSet* _tmp5_;
	GList* _tmp6_;
	gboolean _tmp22_ = FALSE;
	gint _tmp23_;
	gint _tmp24_;
	GitgDiffViewCommitDetails* _tmp26_;
	GitgDiffViewCommitDetails* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (diff != NULL);
	g_return_if_fail (infomap != NULL);
	_data16_ = g_slice_new0 (Block16Data);
	_data16_->_ref_count_ = 1;
	_data16_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (infomap);
	_g_object_unref0 (_data16_->infomap);
	_data16_->infomap = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data16_->cancellable);
	_data16_->cancellable = _tmp1_;
	_tmp2_ = gee_array_list_new (GITG_TYPE_DIFF_VIEW_FILE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_data16_->files = _tmp2_;
	_data16_->current_file = NULL;
	_data16_->current_hunk = NULL;
	_data16_->current_lines = NULL;
	_data16_->current_is_binary = FALSE;
	_data16_->maxlines = 0;
	_data16_->add_hunk = ___lambda66__gitg_diff_view_anon;
	_data16_->add_hunk_target = block16_data_ref (_data16_);
	_data16_->add_hunk_target_destroy_notify = block16_data_unref;
	_data16_->add_file = ___lambda67__gitg_diff_view_anon;
	_data16_->add_file_target = block16_data_ref (_data16_);
	_data16_->add_file_target_destroy_notify = block16_data_unref;
	{
		ggit_diff_foreach (diff, ____lambda68__ggit_diff_file_callback, ____lambda73__ggit_diff_binary_callback, ____lambda74__ggit_diff_hunk_callback, ____lambda75__ggit_diff_line_callback, _data16_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		block16_data_unref (_data16_);
		_data16_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_data16_->add_hunk (_data16_->add_hunk_target);
	_data16_->add_file (_data16_->add_file_target);
	_tmp3_ = self->priv->d_grid_files;
	_tmp4_ = gtk_container_get_children ((GtkContainer*) _tmp3_);
	file_widgets = _tmp4_;
	_tmp5_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	was_expanded = _tmp5_;
	_tmp6_ = file_widgets;
	{
		GList* file_collection = NULL;
		GList* file_it = NULL;
		file_collection = _tmp6_;
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
			GtkWidget* file = NULL;
			file = (GtkWidget*) file_it->data;
			{
				GitgDiffViewFile* f = NULL;
				GtkWidget* _tmp7_;
				gboolean _tmp8_ = FALSE;
				GitgDiffViewFile* _tmp21_;
				_tmp7_ = file;
				f = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GITG_TYPE_DIFF_VIEW_FILE, GitgDiffViewFile);
				if (preserve_expanded) {
					GitgDiffViewFile* _tmp9_;
					gboolean _tmp10_;
					gboolean _tmp11_;
					_tmp9_ = f;
					_tmp10_ = gitg_diff_view_file_get_expanded (_tmp9_);
					_tmp11_ = _tmp10_;
					_tmp8_ = _tmp11_;
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					gchar* path = NULL;
					GitgDiffViewFile* _tmp12_;
					GitgDiffViewFileInfo* _tmp13_;
					GitgDiffViewFileInfo* _tmp14_;
					GgitDiffDelta* _tmp15_;
					GgitDiffDelta* _tmp16_;
					gchar* _tmp17_;
					const gchar* _tmp18_;
					_tmp12_ = f;
					_tmp13_ = gitg_diff_view_file_get_info (_tmp12_);
					_tmp14_ = _tmp13_;
					_tmp15_ = gitg_diff_view_file_info_get_delta (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp17_ = gitg_diff_view_primary_path (self, _tmp16_);
					path = _tmp17_;
					_tmp18_ = path;
					if (_tmp18_ != NULL) {
						GeeHashSet* _tmp19_;
						const gchar* _tmp20_;
						_tmp19_ = was_expanded;
						_tmp20_ = path;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, _tmp20_);
					}
					_g_free0 (path);
				}
				_tmp21_ = f;
				gtk_widget_destroy ((GtkWidget*) _tmp21_);
			}
		}
	}
	_tmp23_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data16_->files);
	_tmp24_ = _tmp23_;
	if (_tmp24_ <= 1) {
		_tmp22_ = TRUE;
	} else {
		gboolean _tmp25_;
		_tmp25_ = self->priv->_default_collapse_all;
		_tmp22_ = !_tmp25_;
	}
	_tmp26_ = self->priv->d_commit_details;
	gitg_diff_view_commit_details_set_expanded (_tmp26_, _tmp22_);
	_tmp27_ = self->priv->d_commit_details;
	_tmp28_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data16_->files);
	_tmp29_ = _tmp28_;
	gitg_diff_view_commit_details_set_expander_visible (_tmp27_, _tmp29_ > 1);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp30_ = FALSE;
			_tmp30_ = TRUE;
			while (TRUE) {
				gint _tmp32_;
				gint _tmp33_;
				GitgDiffViewFile* file = NULL;
				gpointer _tmp34_;
				gchar* path = NULL;
				GitgDiffViewFile* _tmp35_;
				GitgDiffViewFileInfo* _tmp36_;
				GitgDiffViewFileInfo* _tmp37_;
				GgitDiffDelta* _tmp38_;
				GgitDiffDelta* _tmp39_;
				gchar* _tmp40_;
				gboolean _tmp41_ = FALSE;
				GitgDiffViewCommitDetails* _tmp42_;
				gboolean _tmp43_;
				gboolean _tmp44_;
				GitgDiffViewFile* _tmp49_;
				gint _tmp50_;
				gint _tmp51_;
				GtkGrid* _tmp53_;
				GitgDiffViewFile* _tmp54_;
				GitgDiffViewFile* _tmp55_;
				if (!_tmp30_) {
					gint _tmp31_;
					_tmp31_ = i;
					i = _tmp31_ + 1;
				}
				_tmp30_ = FALSE;
				_tmp32_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data16_->files);
				_tmp33_ = _tmp32_;
				if (!(i < _tmp33_)) {
					break;
				}
				_tmp34_ = gee_abstract_list_get ((GeeAbstractList*) _data16_->files, i);
				file = (GitgDiffViewFile*) _tmp34_;
				_tmp35_ = file;
				_tmp36_ = gitg_diff_view_file_get_info (_tmp35_);
				_tmp37_ = _tmp36_;
				_tmp38_ = gitg_diff_view_file_info_get_delta (_tmp37_);
				_tmp39_ = _tmp38_;
				_tmp40_ = gitg_diff_view_primary_path (self, _tmp39_);
				path = _tmp40_;
				_tmp42_ = self->priv->d_commit_details;
				_tmp43_ = gitg_diff_view_commit_details_get_expanded (_tmp42_);
				_tmp44_ = _tmp43_;
				if (_tmp44_) {
					_tmp41_ = TRUE;
				} else {
					gboolean _tmp45_ = FALSE;
					const gchar* _tmp46_;
					_tmp46_ = path;
					if (_tmp46_ != NULL) {
						GeeHashSet* _tmp47_;
						const gchar* _tmp48_;
						_tmp47_ = was_expanded;
						_tmp48_ = path;
						_tmp45_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp47_, _tmp48_);
					} else {
						_tmp45_ = FALSE;
					}
					_tmp41_ = _tmp45_;
				}
				_tmp49_ = file;
				gitg_diff_view_file_set_expanded (_tmp49_, _tmp41_);
				_tmp50_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data16_->files);
				_tmp51_ = _tmp50_;
				if (i == (_tmp51_ - 1)) {
					GitgDiffViewFile* _tmp52_;
					_tmp52_ = file;
					gtk_widget_set_vexpand ((GtkWidget*) _tmp52_, TRUE);
				}
				_tmp53_ = self->priv->d_grid_files;
				_tmp54_ = file;
				gtk_container_add ((GtkContainer*) _tmp53_, (GtkWidget*) _tmp54_);
				_tmp55_ = file;
				g_signal_connect_object ((GObject*) _tmp55_, "notify::expanded", (GCallback) _gitg_diff_view_auto_update_expanded_g_object_notify, self, 0);
				_g_free0 (path);
				_g_object_unref0 (file);
			}
		}
	}
	_g_object_unref0 (was_expanded);
	(file_widgets == NULL) ? NULL : (file_widgets = (g_list_free (file_widgets), NULL));
	block16_data_unref (_data16_);
	_data16_ = NULL;
}

static void
gitg_diff_view_auto_update_expanded (GitgDiffView* self)
{
	GtkGrid* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_grid_files;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	{
		GList* file_collection = NULL;
		GList* file_it = NULL;
		file_collection = _tmp1_;
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
			GtkWidget* file = NULL;
			file = (GtkWidget*) file_it->data;
			{
				GtkWidget* _tmp2_;
				gboolean _tmp3_;
				gboolean _tmp4_;
				_tmp2_ = file;
				_tmp3_ = gitg_diff_view_file_get_expanded (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GITG_TYPE_DIFF_VIEW_FILE, GitgDiffViewFile));
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gitg_diff_view_auto_change_expanded (self, FALSE);
					(file_collection == NULL) ? NULL : (file_collection = (g_list_free (file_collection), NULL));
					return;
				}
			}
		}
		(file_collection == NULL) ? NULL : (file_collection = (g_list_free (file_collection), NULL));
	}
	gitg_diff_view_auto_change_expanded (self, TRUE);
}

static void
_vala_array_add7 (GitgPatchSet** * array,
                  gint* length,
                  gint* size,
                  GitgPatchSet* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GitgPatchSet*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

GitgPatchSet**
gitg_diff_view_get_selection (GitgDiffView* self,
                              gint* result_length1)
{
	GitgPatchSet** ret = NULL;
	GitgPatchSet** _tmp0_;
	gint ret_length1;
	gint _ret_size_;
	GtkGrid* _tmp1_;
	GList* _tmp2_;
	GitgPatchSet** _tmp5_;
	gint _tmp5__length1;
	GitgPatchSet** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (GitgPatchSet*, 0 + 1);
	ret = _tmp0_;
	ret_length1 = 0;
	_ret_size_ = ret_length1;
	_tmp1_ = self->priv->d_grid_files;
	_tmp2_ = gtk_container_get_children ((GtkContainer*) _tmp1_);
	{
		GList* file_collection = NULL;
		GList* file_it = NULL;
		file_collection = _tmp2_;
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
			GtkWidget* file = NULL;
			file = (GtkWidget*) file_it->data;
			{
				GtkWidget* _tmp3_;
				GitgPatchSet* _tmp4_;
				_tmp3_ = file;
				_tmp4_ = gitg_diff_view_file_get_selection (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GITG_TYPE_DIFF_VIEW_FILE, GitgDiffViewFile));
				_vala_array_add7 (&ret, &ret_length1, &_ret_size_, _tmp4_);
			}
		}
		(file_collection == NULL) ? NULL : (file_collection = (g_list_free (file_collection), NULL));
	}
	_tmp5_ = ret;
	_tmp5__length1 = ret_length1;
	if (result_length1) {
		*result_length1 = _tmp5__length1;
	}
	result = _tmp5_;
	return result;
}

void
gitg_diff_view_clear_selection (GitgDiffView* self)
{
	GtkGrid* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_grid_files;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	{
		GList* file_collection = NULL;
		GList* file_it = NULL;
		file_collection = _tmp1_;
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
			GtkWidget* file = NULL;
			file = (GtkWidget*) file_it->data;
			{
				GtkWidget* _tmp2_;
				_tmp2_ = file;
				gitg_diff_view_file_clear_selection (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GITG_TYPE_DIFF_VIEW_FILE, GitgDiffViewFile));
			}
		}
		(file_collection == NULL) ? NULL : (file_collection = (g_list_free (file_collection), NULL));
	}
}

static gboolean
___lambda78_ (GitgDiffView* self)
{
	GtkRevealer* _tmp0_;
	gboolean result;
	self->priv->d_reveal_options_timeout = (guint) 0;
	_tmp0_ = self->priv->d_revealer_options;
	gtk_revealer_set_reveal_child (_tmp0_, TRUE);
	result = FALSE;
	return result;
}

static gboolean
____lambda78__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda78_ ((GitgDiffView*) self);
	return result;
}

static gboolean
_____lambda79_ (GitgDiffView* self)
{
	GtkRevealer* _tmp0_;
	gboolean result;
	self->priv->d_unreveal_options_timeout = (guint) 0;
	_tmp0_ = self->priv->d_revealer_options;
	gtk_revealer_set_reveal_child (_tmp0_, FALSE);
	result = FALSE;
	return result;
}

static gboolean
______lambda79__gsource_func (gpointer self)
{
	gboolean result;
	result = _____lambda79_ ((GitgDiffView*) self);
	return result;
}

static void
gitg_diff_view_update_hide_show_options (GitgDiffView* self,
                                         GdkWindow* window,
                                         gint ex,
                                         gint ey)
{
	void* data = NULL;
	void* _tmp0_ = NULL;
	GtkWidget* w = NULL;
	void* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	gint x = 0;
	gint y = 0;
	GtkWidget* _tmp4_;
	GtkEventBox* _tmp5_;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	GtkAllocation alloc = {0};
	GtkAllocation revealer_alloc = {0};
	GtkEventBox* _tmp8_;
	GtkAllocation _tmp9_ = {0};
	GtkRevealer* _tmp10_;
	GtkAllocation _tmp11_ = {0};
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	GtkRevealer* _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	gdk_window_get_user_data (window, &_tmp0_);
	data = _tmp0_;
	_tmp1_ = data;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp1_) : NULL);
	w = _tmp2_;
	_tmp3_ = w;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (w);
		return;
	}
	_tmp4_ = w;
	_tmp5_ = self->priv->d_event_box;
	gtk_widget_translate_coordinates (_tmp4_, (GtkWidget*) _tmp5_, ex, ey, &_tmp6_, &_tmp7_);
	x = _tmp6_;
	y = _tmp7_;
	_tmp8_ = self->priv->d_event_box;
	gtk_widget_get_allocation ((GtkWidget*) _tmp8_, &_tmp9_);
	alloc = _tmp9_;
	_tmp10_ = self->priv->d_revealer_options;
	gtk_widget_get_allocation ((GtkWidget*) _tmp10_, &_tmp11_);
	revealer_alloc = _tmp11_;
	_tmp15_ = self->priv->d_revealer_options;
	_tmp16_ = gtk_revealer_get_reveal_child (_tmp15_);
	_tmp17_ = _tmp16_;
	if (!_tmp17_) {
		GtkAllocation _tmp18_;
		_tmp18_ = alloc;
		_tmp14_ = y >= (_tmp18_.height - 18);
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		GtkAllocation _tmp19_;
		_tmp19_ = alloc;
		_tmp13_ = x >= (_tmp19_.width - 150);
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		_tmp12_ = self->priv->d_reveal_options_timeout == ((guint) 0);
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		if (self->priv->d_unreveal_options_timeout != ((guint) 0)) {
			g_source_remove (self->priv->d_unreveal_options_timeout);
			self->priv->d_unreveal_options_timeout = (guint) 0;
		}
		self->priv->d_reveal_options_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 300, ____lambda78__gsource_func, g_object_ref (self), g_object_unref);
	} else {
		GtkRevealer* _tmp20_;
		gboolean _tmp21_;
		gboolean _tmp22_;
		_tmp20_ = self->priv->d_revealer_options;
		_tmp21_ = gtk_revealer_get_reveal_child (_tmp20_);
		_tmp22_ = _tmp21_;
		if (_tmp22_) {
			gboolean above = FALSE;
			GtkAllocation _tmp23_;
			GtkAllocation _tmp24_;
			gboolean _tmp25_ = FALSE;
			_tmp23_ = alloc;
			_tmp24_ = revealer_alloc;
			above = y <= ((_tmp23_.height - 6) - _tmp24_.height);
			if (above) {
				_tmp25_ = self->priv->d_unreveal_options_timeout == ((guint) 0);
			} else {
				_tmp25_ = FALSE;
			}
			if (_tmp25_) {
				if (self->priv->d_reveal_options_timeout != ((guint) 0)) {
					g_source_remove (self->priv->d_reveal_options_timeout);
					self->priv->d_reveal_options_timeout = (guint) 0;
				}
				self->priv->d_unreveal_options_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 1000, ______lambda79__gsource_func, g_object_ref (self), g_object_unref);
			} else {
				gboolean _tmp26_ = FALSE;
				if (!above) {
					_tmp26_ = self->priv->d_unreveal_options_timeout != ((guint) 0);
				} else {
					_tmp26_ = FALSE;
				}
				if (_tmp26_) {
					g_source_remove (self->priv->d_unreveal_options_timeout);
					self->priv->d_unreveal_options_timeout = (guint) 0;
				}
			}
		}
	}
	_g_object_unref0 (w);
}

static gboolean
gitg_diff_view_leave_notify_event_on_event_box (GitgDiffView* self,
                                                GtkWidget* widget,
                                                GdkEventCrossing* event)
{
	GdkWindow* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event->window;
	gitg_diff_view_update_hide_show_options (self, _tmp0_, (gint) event->x, (gint) event->y);
	result = FALSE;
	return result;
}

static gboolean
_gitg_diff_view_leave_notify_event_on_event_box_gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                                               GdkEventCrossing* event,
                                                                               gpointer self)
{
	gboolean result;
	result = gitg_diff_view_leave_notify_event_on_event_box ((GitgDiffView*) self, _sender, event);
	return result;
}

static gboolean
gitg_diff_view_enter_notify_event_on_event_box (GitgDiffView* self,
                                                GtkWidget* widget,
                                                GdkEventCrossing* event)
{
	GdkWindow* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event->window;
	gitg_diff_view_update_hide_show_options (self, _tmp0_, (gint) event->x, (gint) event->y);
	result = FALSE;
	return result;
}

static gboolean
_gitg_diff_view_enter_notify_event_on_event_box_gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                                               GdkEventCrossing* event,
                                                                               gpointer self)
{
	gboolean result;
	result = gitg_diff_view_enter_notify_event_on_event_box ((GitgDiffView*) self, _sender, event);
	return result;
}

static gboolean
gitg_diff_view_motion_notify_event_on_event_box (GitgDiffView* self,
                                                 GtkWidget* widget,
                                                 GdkEventMotion* event)
{
	GdkWindow* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event->window;
	gitg_diff_view_update_hide_show_options (self, _tmp0_, (gint) event->x, (gint) event->y);
	result = FALSE;
	return result;
}

GitgDiffView*
gitg_diff_view_construct (GType object_type)
{
	GitgDiffView * self = NULL;
	self = (GitgDiffView*) g_object_new (object_type, NULL);
	return self;
}

GitgDiffView*
gitg_diff_view_new (void)
{
	return gitg_diff_view_construct (GITG_TYPE_DIFF_VIEW);
}

GgitDiffOptions*
gitg_diff_view_get_options (GitgDiffView* self)
{
	GgitDiffOptions* result;
	GgitDiffOptions* _tmp0_;
	GgitDiffOptions* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_options;
	if (_tmp0_ == NULL) {
		GgitDiffOptions* _tmp1_;
		_tmp1_ = ggit_diff_options_new ();
		_g_object_unref0 (self->priv->d_options);
		self->priv->d_options = _tmp1_;
	}
	_tmp2_ = self->priv->d_options;
	result = _tmp2_;
	return result;
}

gboolean
gitg_diff_view_get_has_selection (GitgDiffView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_selection;
	return result;
}

static void
gitg_diff_view_set_has_selection (GitgDiffView* self,
                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_diff_view_get_has_selection (self);
	if (old_value != value) {
		self->priv->_has_selection = value;
		g_object_notify_by_pspec ((GObject *) self, gitg_diff_view_properties[GITG_DIFF_VIEW_HAS_SELECTION_PROPERTY]);
	}
}

GgitDiff*
gitg_diff_view_get_diff (GitgDiffView* self)
{
	GgitDiff* result;
	GgitDiff* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_diff;
	result = _tmp0_;
	return result;
}

void
gitg_diff_view_set_diff (GitgDiffView* self,
                         GgitDiff* value)
{
	GgitDiff* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_diff;
	if (_tmp0_ != value) {
		GgitDiff* _tmp1_;
		_tmp1_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->d_diff);
		self->priv->d_diff = _tmp1_;
		_g_object_unref0 (self->priv->d_commit);
		self->priv->d_commit = NULL;
	}
	gitg_diff_view_update (self, FALSE);
	g_object_notify_by_pspec ((GObject *) self, gitg_diff_view_properties[GITG_DIFF_VIEW_DIFF_PROPERTY]);
}

GitgCommit*
gitg_diff_view_get_commit (GitgDiffView* self)
{
	GitgCommit* result;
	GitgCommit* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_commit;
	result = _tmp0_;
	return result;
}

void
gitg_diff_view_set_commit (GitgDiffView* self,
                           GitgCommit* value)
{
	GitgCommit* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_commit;
	if (_tmp0_ != value) {
		GitgCommit* _tmp1_;
		_tmp1_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->d_commit);
		self->priv->d_commit = _tmp1_;
		_g_object_unref0 (self->priv->d_diff);
		self->priv->d_diff = NULL;
	}
	gitg_diff_view_update (self, FALSE);
	g_object_notify_by_pspec ((GObject *) self, gitg_diff_view_properties[GITG_DIFF_VIEW_COMMIT_PROPERTY]);
}

gboolean
gitg_diff_view_get_wrap_lines (GitgDiffView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_wrap_lines;
	return result;
}

void
gitg_diff_view_set_wrap_lines (GitgDiffView* self,
                               gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_diff_view_get_wrap_lines (self);
	if (old_value != value) {
		self->priv->_wrap_lines = value;
		g_object_notify_by_pspec ((GObject *) self, gitg_diff_view_properties[GITG_DIFF_VIEW_WRAP_LINES_PROPERTY]);
	}
}

gboolean
gitg_diff_view_get_staged (GitgDiffView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_staged;
	return result;
}

void
gitg_diff_view_set_staged (GitgDiffView* self,
                           gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_diff_view_get_staged (self);
	if (old_value != value) {
		self->priv->_staged = value;
		g_object_notify_by_pspec ((GObject *) self, gitg_diff_view_properties[GITG_DIFF_VIEW_STAGED_PROPERTY]);
	}
}

gboolean
gitg_diff_view_get_unstaged (GitgDiffView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_unstaged;
	return result;
}

void
gitg_diff_view_set_unstaged (GitgDiffView* self,
                             gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_diff_view_get_unstaged (self);
	if (old_value != value) {
		self->priv->_unstaged = value;
		g_object_notify_by_pspec ((GObject *) self, gitg_diff_view_properties[GITG_DIFF_VIEW_UNSTAGED_PROPERTY]);
	}
}

gboolean
gitg_diff_view_get_show_parents (GitgDiffView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_parents;
	return result;
}

void
gitg_diff_view_set_show_parents (GitgDiffView* self,
                                 gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_diff_view_get_show_parents (self);
	if (old_value != value) {
		self->priv->_show_parents = value;
		g_object_notify_by_pspec ((GObject *) self, gitg_diff_view_properties[GITG_DIFF_VIEW_SHOW_PARENTS_PROPERTY]);
	}
}

gboolean
gitg_diff_view_get_default_collapse_all (GitgDiffView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_default_collapse_all;
	return result;
}

void
gitg_diff_view_set_default_collapse_all (GitgDiffView* self,
                                         gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_diff_view_get_default_collapse_all (self);
	if (old_value != value) {
		self->priv->_default_collapse_all = value;
		g_object_notify_by_pspec ((GObject *) self, gitg_diff_view_properties[GITG_DIFF_VIEW_DEFAULT_COLLAPSE_ALL_PROPERTY]);
	}
}

gboolean
gitg_diff_view_get_use_gravatar (GitgDiffView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_use_gravatar;
	return result;
}

void
gitg_diff_view_set_use_gravatar (GitgDiffView* self,
                                 gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_diff_view_get_use_gravatar (self);
	if (old_value != value) {
		self->priv->_use_gravatar = value;
		g_object_notify_by_pspec ((GObject *) self, gitg_diff_view_properties[GITG_DIFF_VIEW_USE_GRAVATAR_PROPERTY]);
	}
}

gint
gitg_diff_view_get_tab_width (GitgDiffView* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_tab_width;
	return result;
}

void
gitg_diff_view_set_tab_width (GitgDiffView* self,
                              gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_diff_view_get_tab_width (self);
	if (old_value != value) {
		self->priv->_tab_width = value;
		g_object_notify_by_pspec ((GObject *) self, gitg_diff_view_properties[GITG_DIFF_VIEW_TAB_WIDTH_PROPERTY]);
	}
}

gboolean
gitg_diff_view_get_handle_selection (GitgDiffView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_handle_selection;
	return result;
}

void
gitg_diff_view_set_handle_selection (GitgDiffView* self,
                                     gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_diff_view_get_handle_selection (self);
	if (old_value != value) {
		self->priv->_handle_selection = value;
		g_object_notify_by_pspec ((GObject *) self, gitg_diff_view_properties[GITG_DIFF_VIEW_HANDLE_SELECTION_PROPERTY]);
	}
}

gboolean
gitg_diff_view_get_highlight (GitgDiffView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_highlight;
	return result;
}

void
gitg_diff_view_set_highlight (GitgDiffView* self,
                              gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_diff_view_get_highlight (self);
	if (old_value != value) {
		self->priv->_highlight = value;
		g_object_notify_by_pspec ((GObject *) self, gitg_diff_view_properties[GITG_DIFF_VIEW_HIGHLIGHT_PROPERTY]);
	}
}

GitgRepository*
gitg_diff_view_get_repository (GitgDiffView* self)
{
	GitgRepository* result;
	GitgRepository* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_repository;
	result = _tmp0_;
	return result;
}

void
gitg_diff_view_set_repository (GitgDiffView* self,
                               GitgRepository* value)
{
	GitgRepository* _tmp0_;
	GitgRepository* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->d_repository);
	self->priv->d_repository = _tmp0_;
	_tmp1_ = self->priv->d_repository;
	if (_tmp1_ != NULL) {
		GitgDiffViewCommitDetails* _tmp2_;
		GitgRepository* _tmp3_;
		_tmp2_ = self->priv->d_commit_details;
		_tmp3_ = self->priv->d_repository;
		gitg_diff_view_commit_details_set_repository (_tmp2_, _tmp3_);
	}
	g_object_notify_by_pspec ((GObject *) self, gitg_diff_view_properties[GITG_DIFF_VIEW_REPOSITORY_PROPERTY]);
}

gboolean
gitg_diff_view_get_new_is_workdir (GitgDiffView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_new_is_workdir;
	return result;
}

void
gitg_diff_view_set_new_is_workdir (GitgDiffView* self,
                                   gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_diff_view_get_new_is_workdir (self);
	if (old_value != value) {
		self->priv->_new_is_workdir = value;
		g_object_notify_by_pspec ((GObject *) self, gitg_diff_view_properties[GITG_DIFF_VIEW_NEW_IS_WORKDIR_PROPERTY]);
	}
}

gboolean
gitg_diff_view_get_ignore_whitespace (GitgDiffView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = gitg_diff_view_flag_get (self, GGIT_DIFF_IGNORE_WHITESPACE);
	return result;
}

void
gitg_diff_view_set_ignore_whitespace (GitgDiffView* self,
                                      gboolean value)
{
	g_return_if_fail (self != NULL);
	gitg_diff_view_flag_set (self, GGIT_DIFF_IGNORE_WHITESPACE, value);
	g_object_notify_by_pspec ((GObject *) self, gitg_diff_view_properties[GITG_DIFF_VIEW_IGNORE_WHITESPACE_PROPERTY]);
}

gboolean
gitg_diff_view_get_changes_inline (GitgDiffView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->d_changes_inline;
	return result;
}

void
gitg_diff_view_set_changes_inline (GitgDiffView* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	if (self->priv->d_changes_inline != value) {
		self->priv->d_changes_inline = value;
	}
	g_object_notify_by_pspec ((GObject *) self, gitg_diff_view_properties[GITG_DIFF_VIEW_CHANGES_INLINE_PROPERTY]);
}

gint
gitg_diff_view_get_context_lines (GitgDiffView* self)
{
	gint result;
	GgitDiffOptions* _tmp0_;
	GgitDiffOptions* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = gitg_diff_view_get_options (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = ggit_diff_options_get_n_context_lines (_tmp1_);
	_tmp3_ = _tmp2_;
	result = _tmp3_;
	return result;
}

void
gitg_diff_view_set_context_lines (GitgDiffView* self,
                                  gint value)
{
	GgitDiffOptions* _tmp0_;
	GgitDiffOptions* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gitg_diff_view_get_options (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = ggit_diff_options_get_n_context_lines (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != value) {
		GgitDiffOptions* _tmp4_;
		GgitDiffOptions* _tmp5_;
		GgitDiffOptions* _tmp6_;
		GgitDiffOptions* _tmp7_;
		_tmp4_ = gitg_diff_view_get_options (self);
		_tmp5_ = _tmp4_;
		ggit_diff_options_set_n_context_lines (_tmp5_, value);
		_tmp6_ = gitg_diff_view_get_options (self);
		_tmp7_ = _tmp6_;
		ggit_diff_options_set_n_interhunk_lines (_tmp7_, value);
		g_signal_emit (self, gitg_diff_view_signals[GITG_DIFF_VIEW_OPTIONS_CHANGED_SIGNAL], 0);
	}
	g_object_notify_by_pspec ((GObject *) self, gitg_diff_view_properties[GITG_DIFF_VIEW_CONTEXT_LINES_PROPERTY]);
}

static void
gitg_diff_view_real_options_changed (GitgDiffView* self)
{
	GitgCommit* _tmp0_;
	_tmp0_ = self->priv->d_commit;
	if (_tmp0_ != NULL) {
		gitg_diff_view_update (self, TRUE);
	}
}

static GObject *
gitg_diff_view_constructor (GType type,
                            guint n_construct_properties,
                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GitgDiffView * self;
	parent_class = G_OBJECT_CLASS (gitg_diff_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_DIFF_VIEW, GitgDiffView);
	gitg_diff_view_set_context_lines (self, 3);
	return obj;
}

static void
gitg_diff_view_class_init (GitgDiffViewClass * klass,
                           gpointer klass_data)
{
	GeeHashSet* _tmp0_;
	GSList* _tmp1_;
	GError* _inner_error0_ = NULL;
	gitg_diff_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgDiffView_private_offset);
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) gitg_diff_view_real_constructed;
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) gitg_diff_view_real_dispose;
	((GitgDiffViewClass *) klass)->options_changed = gitg_diff_view_real_options_changed;
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_diff_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_diff_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = gitg_diff_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = gitg_diff_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_OPTIONS_PROPERTY, gitg_diff_view_properties[GITG_DIFF_VIEW_OPTIONS_PROPERTY] = g_param_spec_object ("options", "options", "options", ggit_diff_options_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_HAS_SELECTION_PROPERTY, gitg_diff_view_properties[GITG_DIFF_VIEW_HAS_SELECTION_PROPERTY] = g_param_spec_boolean ("has-selection", "has-selection", "has-selection", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_DIFF_PROPERTY, gitg_diff_view_properties[GITG_DIFF_VIEW_DIFF_PROPERTY] = g_param_spec_object ("diff", "diff", "diff", ggit_diff_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_COMMIT_PROPERTY, gitg_diff_view_properties[GITG_DIFF_VIEW_COMMIT_PROPERTY] = g_param_spec_object ("commit", "commit", "commit", GITG_TYPE_COMMIT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_WRAP_LINES_PROPERTY, gitg_diff_view_properties[GITG_DIFF_VIEW_WRAP_LINES_PROPERTY] = g_param_spec_boolean ("wrap-lines", "wrap-lines", "wrap-lines", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_STAGED_PROPERTY, gitg_diff_view_properties[GITG_DIFF_VIEW_STAGED_PROPERTY] = g_param_spec_boolean ("staged", "staged", "staged", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_UNSTAGED_PROPERTY, gitg_diff_view_properties[GITG_DIFF_VIEW_UNSTAGED_PROPERTY] = g_param_spec_boolean ("unstaged", "unstaged", "unstaged", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_SHOW_PARENTS_PROPERTY, gitg_diff_view_properties[GITG_DIFF_VIEW_SHOW_PARENTS_PROPERTY] = g_param_spec_boolean ("show-parents", "show-parents", "show-parents", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_DEFAULT_COLLAPSE_ALL_PROPERTY, gitg_diff_view_properties[GITG_DIFF_VIEW_DEFAULT_COLLAPSE_ALL_PROPERTY] = g_param_spec_boolean ("default-collapse-all", "default-collapse-all", "default-collapse-all", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_USE_GRAVATAR_PROPERTY, gitg_diff_view_properties[GITG_DIFF_VIEW_USE_GRAVATAR_PROPERTY] = g_param_spec_boolean ("use-gravatar", "use-gravatar", "use-gravatar", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_TAB_WIDTH_PROPERTY, gitg_diff_view_properties[GITG_DIFF_VIEW_TAB_WIDTH_PROPERTY] = g_param_spec_int ("tab-width", "tab-width", "tab-width", G_MININT, G_MAXINT, 4, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_HANDLE_SELECTION_PROPERTY, gitg_diff_view_properties[GITG_DIFF_VIEW_HANDLE_SELECTION_PROPERTY] = g_param_spec_boolean ("handle-selection", "handle-selection", "handle-selection", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_HIGHLIGHT_PROPERTY, gitg_diff_view_properties[GITG_DIFF_VIEW_HIGHLIGHT_PROPERTY] = g_param_spec_boolean ("highlight", "highlight", "highlight", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_REPOSITORY_PROPERTY, gitg_diff_view_properties[GITG_DIFF_VIEW_REPOSITORY_PROPERTY] = g_param_spec_object ("repository", "repository", "repository", GITG_TYPE_REPOSITORY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_NEW_IS_WORKDIR_PROPERTY, gitg_diff_view_properties[GITG_DIFF_VIEW_NEW_IS_WORKDIR_PROPERTY] = g_param_spec_boolean ("new-is-workdir", "new-is-workdir", "new-is-workdir", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_IGNORE_WHITESPACE_PROPERTY, gitg_diff_view_properties[GITG_DIFF_VIEW_IGNORE_WHITESPACE_PROPERTY] = g_param_spec_boolean ("ignore-whitespace", "ignore-whitespace", "ignore-whitespace", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_CHANGES_INLINE_PROPERTY, gitg_diff_view_properties[GITG_DIFF_VIEW_CHANGES_INLINE_PROPERTY] = g_param_spec_boolean ("changes-inline", "changes-inline", "changes-inline", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_CONTEXT_LINES_PROPERTY, gitg_diff_view_properties[GITG_DIFF_VIEW_CONTEXT_LINES_PROPERTY] = g_param_spec_int ("context-lines", "context-lines", "context-lines", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/gitg/ui/gitg-diff-view.ui");
	gitg_diff_view_signals[GITG_DIFF_VIEW_OPTIONS_CHANGED_SIGNAL] = g_signal_new ("options-changed", GITG_TYPE_DIFF_VIEW, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GitgDiffViewClass, options_changed), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "commit_details", FALSE, GitgDiffView_private_offset + G_STRUCT_OFFSET (GitgDiffViewPrivate, d_commit_details));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "scrolledwindow", FALSE, GitgDiffView_private_offset + G_STRUCT_OFFSET (GitgDiffViewPrivate, d_scrolledwindow));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "grid_files", FALSE, GitgDiffView_private_offset + G_STRUCT_OFFSET (GitgDiffViewPrivate, d_grid_files));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "event_box", FALSE, GitgDiffView_private_offset + G_STRUCT_OFFSET (GitgDiffViewPrivate, d_event_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "revealer_options", FALSE, GitgDiffView_private_offset + G_STRUCT_OFFSET (GitgDiffViewPrivate, d_revealer_options));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "diff_view_options", FALSE, GitgDiffView_private_offset + G_STRUCT_OFFSET (GitgDiffViewPrivate, d_diff_view_options));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "text_view_message", FALSE, GitgDiffView_private_offset + G_STRUCT_OFFSET (GitgDiffViewPrivate, d_text_view_message));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "leave_notify_event_on_event_box", G_CALLBACK(_gitg_diff_view_leave_notify_event_on_event_box_gtk_widget_leave_notify_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "enter_notify_event_on_event_box", G_CALLBACK(_gitg_diff_view_enter_notify_event_on_event_box_gtk_widget_enter_notify_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "motion_notify_event_on_event_box", G_CALLBACK(_gitg_diff_view_motion_notify_event_on_event_box_gtk_widget_motion_notify_event));
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (gitg_diff_view_s_image_mime_types);
	gitg_diff_view_s_image_mime_types = _tmp0_;
	_tmp1_ = gdk_pixbuf_get_formats ();
	{
		GSList* format_collection = NULL;
		GSList* format_it = NULL;
		format_collection = _tmp1_;
		for (format_it = format_collection; format_it != NULL; format_it = format_it->next) {
			GdkPixbufFormat* format = NULL;
			format = (GdkPixbufFormat*) format_it->data;
			{
				GdkPixbufFormat* _tmp2_;
				gchar** _tmp3_;
				gchar** _tmp4_;
				_tmp2_ = format;
				_tmp4_ = _tmp3_ = gdk_pixbuf_format_get_mime_types (_tmp2_);
				{
					gchar** mime_type_collection = NULL;
					gint mime_type_collection_length1 = 0;
					gint _mime_type_collection_size_ = 0;
					gint mime_type_it = 0;
					mime_type_collection = _tmp4_;
					mime_type_collection_length1 = _vala_array_length (_tmp3_);
					for (mime_type_it = 0; mime_type_it < mime_type_collection_length1; mime_type_it = mime_type_it + 1) {
						gchar* _tmp5_;
						gchar* mime_type = NULL;
						_tmp5_ = g_strdup (mime_type_collection[mime_type_it]);
						mime_type = _tmp5_;
						{
							GeeHashSet* _tmp6_;
							const gchar* _tmp7_;
							_tmp6_ = gitg_diff_view_s_image_mime_types;
							_tmp7_ = mime_type;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, _tmp7_);
							_g_free0 (mime_type);
						}
					}
					mime_type_collection = (_vala_array_free (mime_type_collection, mime_type_collection_length1, (GDestroyNotify) g_free), NULL);
				}
			}
		}
		(format_collection == NULL) ? NULL : (format_collection = (g_slist_free (format_collection), NULL));
	}
	{
		GRegex* _tmp8_ = NULL;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		_tmp9_ = g_regex_new (".*(\\R|\\s)*(?P<message>(?:.|\\R)*?)\\s*$", 0, 0, &_inner_error0_);
		_tmp8_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp10_ = _tmp8_;
		_tmp8_ = NULL;
		_g_regex_unref0 (gitg_diff_view_s_message_regexp);
		gitg_diff_view_s_message_regexp = _tmp10_;
		_g_regex_unref0 (_tmp8_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp11_;
		GError* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = stderr;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		_tmp14_ = string_to_string (_tmp13_);
		_tmp15_ = g_strconcat ("Failed to compile regex: ", _tmp14_, "\n", NULL);
		_tmp16_ = _tmp15_;
		fprintf (_tmp11_, "%s", _tmp16_);
		_g_free0 (_tmp16_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
}

static void
gitg_diff_view_instance_init (GitgDiffView * self,
                              gpointer klass)
{
	GRegex* _tmp0_;
	GRegex* _tmp1_;
	self->priv = gitg_diff_view_get_instance_private (self);
	self->priv->hovering_over_link = FALSE;
	self->priv->hover_tag = NULL;
	self->priv->_wrap_lines = TRUE;
	self->priv->_staged = FALSE;
	self->priv->_unstaged = FALSE;
	self->priv->_show_parents = FALSE;
	self->priv->_default_collapse_all = TRUE;
	self->priv->_use_gravatar = TRUE;
	self->priv->_tab_width = 4;
	self->priv->_handle_selection = FALSE;
	self->priv->_highlight = TRUE;
	_tmp0_ = _g_regex_ref0 (_thread_safe_regex_init (&_tmp_regex_0, "gitg\\.custom-link\\.(.+)\\.regex", 0));
	self->priv->regex_custom_links = _tmp0_;
	_tmp1_ = _g_regex_ref0 (_thread_safe_regex_init (&_tmp_regex_1, "\\w+:(\\/?\\/?)[^\\s]+", 0));
	self->priv->regex_url = _tmp1_;
	g_type_ensure (GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS);
	g_type_ensure (GITG_TYPE_DIFF_VIEW_OPTIONS);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
gitg_diff_view_finalize (GObject * obj)
{
	GitgDiffView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_DIFF_VIEW, GitgDiffView);
	_g_object_unref0 (self->priv->d_diff);
	_g_object_unref0 (self->priv->d_commit);
	_g_object_unref0 (self->priv->d_options);
	_g_object_unref0 (self->priv->d_cancellable);
	_g_object_unref0 (self->priv->hover_tag);
	_g_object_unref0 (self->priv->d_repository);
	_g_regex_unref0 (self->priv->regex_custom_links);
	_g_regex_unref0 (self->priv->regex_url);
	G_OBJECT_CLASS (gitg_diff_view_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_diff_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgDiffViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_diff_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgDiffView), 0, (GInstanceInitFunc) gitg_diff_view_instance_init, NULL };
	GType gitg_diff_view_type_id;
	gitg_diff_view_type_id = g_type_register_static (gtk_grid_get_type (), "GitgDiffView", &g_define_type_info, 0);
	GitgDiffView_private_offset = g_type_add_instance_private (gitg_diff_view_type_id, sizeof (GitgDiffViewPrivate));
	return gitg_diff_view_type_id;
}

GType
gitg_diff_view_get_type (void)
{
	static gsize gitg_diff_view_type_id__once = 0;
	if (g_once_init_enter (&gitg_diff_view_type_id__once)) {
		GType gitg_diff_view_type_id;
		gitg_diff_view_type_id = gitg_diff_view_get_type_once ();
		g_once_init_leave (&gitg_diff_view_type_id__once, gitg_diff_view_type_id);
	}
	return gitg_diff_view_type_id__once;
}

static void
_vala_gitg_diff_view_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	GitgDiffView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_DIFF_VIEW, GitgDiffView);
	switch (property_id) {
		case GITG_DIFF_VIEW_OPTIONS_PROPERTY:
		g_value_set_object (value, gitg_diff_view_get_options (self));
		break;
		case GITG_DIFF_VIEW_HAS_SELECTION_PROPERTY:
		g_value_set_boolean (value, gitg_diff_view_get_has_selection (self));
		break;
		case GITG_DIFF_VIEW_DIFF_PROPERTY:
		g_value_set_object (value, gitg_diff_view_get_diff (self));
		break;
		case GITG_DIFF_VIEW_COMMIT_PROPERTY:
		g_value_set_object (value, gitg_diff_view_get_commit (self));
		break;
		case GITG_DIFF_VIEW_WRAP_LINES_PROPERTY:
		g_value_set_boolean (value, gitg_diff_view_get_wrap_lines (self));
		break;
		case GITG_DIFF_VIEW_STAGED_PROPERTY:
		g_value_set_boolean (value, gitg_diff_view_get_staged (self));
		break;
		case GITG_DIFF_VIEW_UNSTAGED_PROPERTY:
		g_value_set_boolean (value, gitg_diff_view_get_unstaged (self));
		break;
		case GITG_DIFF_VIEW_SHOW_PARENTS_PROPERTY:
		g_value_set_boolean (value, gitg_diff_view_get_show_parents (self));
		break;
		case GITG_DIFF_VIEW_DEFAULT_COLLAPSE_ALL_PROPERTY:
		g_value_set_boolean (value, gitg_diff_view_get_default_collapse_all (self));
		break;
		case GITG_DIFF_VIEW_USE_GRAVATAR_PROPERTY:
		g_value_set_boolean (value, gitg_diff_view_get_use_gravatar (self));
		break;
		case GITG_DIFF_VIEW_TAB_WIDTH_PROPERTY:
		g_value_set_int (value, gitg_diff_view_get_tab_width (self));
		break;
		case GITG_DIFF_VIEW_HANDLE_SELECTION_PROPERTY:
		g_value_set_boolean (value, gitg_diff_view_get_handle_selection (self));
		break;
		case GITG_DIFF_VIEW_HIGHLIGHT_PROPERTY:
		g_value_set_boolean (value, gitg_diff_view_get_highlight (self));
		break;
		case GITG_DIFF_VIEW_REPOSITORY_PROPERTY:
		g_value_set_object (value, gitg_diff_view_get_repository (self));
		break;
		case GITG_DIFF_VIEW_NEW_IS_WORKDIR_PROPERTY:
		g_value_set_boolean (value, gitg_diff_view_get_new_is_workdir (self));
		break;
		case GITG_DIFF_VIEW_IGNORE_WHITESPACE_PROPERTY:
		g_value_set_boolean (value, gitg_diff_view_get_ignore_whitespace (self));
		break;
		case GITG_DIFF_VIEW_CHANGES_INLINE_PROPERTY:
		g_value_set_boolean (value, gitg_diff_view_get_changes_inline (self));
		break;
		case GITG_DIFF_VIEW_CONTEXT_LINES_PROPERTY:
		g_value_set_int (value, gitg_diff_view_get_context_lines (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gitg_diff_view_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	GitgDiffView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_DIFF_VIEW, GitgDiffView);
	switch (property_id) {
		case GITG_DIFF_VIEW_HAS_SELECTION_PROPERTY:
		gitg_diff_view_set_has_selection (self, g_value_get_boolean (value));
		break;
		case GITG_DIFF_VIEW_DIFF_PROPERTY:
		gitg_diff_view_set_diff (self, g_value_get_object (value));
		break;
		case GITG_DIFF_VIEW_COMMIT_PROPERTY:
		gitg_diff_view_set_commit (self, g_value_get_object (value));
		break;
		case GITG_DIFF_VIEW_WRAP_LINES_PROPERTY:
		gitg_diff_view_set_wrap_lines (self, g_value_get_boolean (value));
		break;
		case GITG_DIFF_VIEW_STAGED_PROPERTY:
		gitg_diff_view_set_staged (self, g_value_get_boolean (value));
		break;
		case GITG_DIFF_VIEW_UNSTAGED_PROPERTY:
		gitg_diff_view_set_unstaged (self, g_value_get_boolean (value));
		break;
		case GITG_DIFF_VIEW_SHOW_PARENTS_PROPERTY:
		gitg_diff_view_set_show_parents (self, g_value_get_boolean (value));
		break;
		case GITG_DIFF_VIEW_DEFAULT_COLLAPSE_ALL_PROPERTY:
		gitg_diff_view_set_default_collapse_all (self, g_value_get_boolean (value));
		break;
		case GITG_DIFF_VIEW_USE_GRAVATAR_PROPERTY:
		gitg_diff_view_set_use_gravatar (self, g_value_get_boolean (value));
		break;
		case GITG_DIFF_VIEW_TAB_WIDTH_PROPERTY:
		gitg_diff_view_set_tab_width (self, g_value_get_int (value));
		break;
		case GITG_DIFF_VIEW_HANDLE_SELECTION_PROPERTY:
		gitg_diff_view_set_handle_selection (self, g_value_get_boolean (value));
		break;
		case GITG_DIFF_VIEW_HIGHLIGHT_PROPERTY:
		gitg_diff_view_set_highlight (self, g_value_get_boolean (value));
		break;
		case GITG_DIFF_VIEW_REPOSITORY_PROPERTY:
		gitg_diff_view_set_repository (self, g_value_get_object (value));
		break;
		case GITG_DIFF_VIEW_NEW_IS_WORKDIR_PROPERTY:
		gitg_diff_view_set_new_is_workdir (self, g_value_get_boolean (value));
		break;
		case GITG_DIFF_VIEW_IGNORE_WHITESPACE_PROPERTY:
		gitg_diff_view_set_ignore_whitespace (self, g_value_get_boolean (value));
		break;
		case GITG_DIFF_VIEW_CHANGES_INLINE_PROPERTY:
		gitg_diff_view_set_changes_inline (self, g_value_get_boolean (value));
		break;
		case GITG_DIFF_VIEW_CONTEXT_LINES_PROPERTY:
		gitg_diff_view_set_context_lines (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

