/* playstation-game-factory.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from playstation-game-factory.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include "games-playstation-plugin.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "gnome-games.h"
#include <glib-object.h>
#include <gio/gio.h>

#define GAMES_PLAY_STATION_GAME_FACTORY_CUE_MIME_TYPE "application/x-cue"
#define GAMES_PLAY_STATION_GAME_FACTORY_PHONY_MIME_TYPE "application/x-playstation-rom"
#define GAMES_PLAY_STATION_GAME_FACTORY_ICON_NAME "media-optical-symbolic"
#define GAMES_PLAY_STATION_GAME_FACTORY_GAMEINFO "resource:///org/gnome/Games/plugin/playstation/playstation.gameinfo.xm" \
"l"
#define GAMES_PLAY_STATION_GAME_FACTORY_PLATFORM_UID_PREFIX "playstation"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GAMES_PLAY_STATION_GAME_FACTORY_0_PROPERTY,
	GAMES_PLAY_STATION_GAME_FACTORY_NUM_PROPERTIES
};
static GParamSpec* games_play_station_game_factory_properties[GAMES_PLAY_STATION_GAME_FACTORY_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define GAMES_TYPE_PLAY_STATION_HEADER (games_play_station_header_get_type ())
#define GAMES_PLAY_STATION_HEADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_PLAY_STATION_HEADER, GamesPlayStationHeader))
#define GAMES_PLAY_STATION_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_PLAY_STATION_HEADER, GamesPlayStationHeaderClass))
#define GAMES_IS_PLAY_STATION_HEADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_PLAY_STATION_HEADER))
#define GAMES_IS_PLAY_STATION_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_PLAY_STATION_HEADER))
#define GAMES_PLAY_STATION_HEADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_PLAY_STATION_HEADER, GamesPlayStationHeaderClass))

typedef struct _GamesPlayStationHeader GamesPlayStationHeader;
typedef struct _GamesPlayStationHeaderClass GamesPlayStationHeaderClass;
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GamesPlayStationGameFactoryPrivate {
	GHashTable* media_for_disc_id;
	GHashTable* game_for_uri;
	GHashTable* game_for_disc_set_id;
	GHashTable* games;
	GamesRetroPlatform* platform;
	GamesGameCallback game_added_callback;
	gpointer game_added_callback_target;
};

struct _Block1Data {
	int _ref_count_;
	GamesPlayStationGameFactory* self;
	gboolean is_complete;
};

struct _Block2Data {
	int _ref_count_;
	GamesPlayStationGameFactory* self;
	GamesGameCallback game_callback;
	gpointer game_callback_target;
};

struct _Block3Data {
	int _ref_count_;
	GHashTable* self;
	GFunc func;
	gpointer func_target;
};

static gint GamesPlayStationGameFactory_private_offset;
static gpointer games_play_station_game_factory_parent_class = NULL;
static GamesGameinfoDoc* games_play_station_game_factory_gameinfo;
static GamesGameinfoDoc* games_play_station_game_factory_gameinfo = NULL;
static GamesUriGameFactoryIface * games_play_station_game_factory_games_uri_game_factory_parent_iface = NULL;
static GType games_play_station_game_factory_type_id = 0;

static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static guint _games_uri_hash_ghash_func (gconstpointer key);
static gboolean _games_uri_equal_gequal_func (gconstpointer a,
                                       gconstpointer b);
static void _games_uri_unref0_ (gpointer var);
static gchar** games_play_station_game_factory_real_get_mime_types (GamesUriGameFactory* base,
                                                             gint* result_length1);
static GamesGame* games_play_station_game_factory_real_query_game_for_uri (GamesUriGameFactory* base,
                                                                    GamesUri* uri);
static void games_play_station_game_factory_real_add_uri (GamesUriGameFactory* base,
                                                   GamesUri* uri);
static void games_play_station_game_factory_add_uri_with_error (GamesPlayStationGameFactory* self,
                                                         GamesUri* uri,
                                                         GError** error);
GType games_play_station_header_register_type (GTypeModule * module);
VALA_EXTERN GType games_play_station_header_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesPlayStationHeader* games_play_station_header_new (GFile* file);
VALA_EXTERN GamesPlayStationHeader* games_play_station_header_construct (GType object_type,
                                                             GFile* file);
VALA_EXTERN void games_play_station_header_check_validity (GamesPlayStationHeader* self,
                                               GError** error);
VALA_EXTERN const gchar* games_play_station_header_get_disc_id (GamesPlayStationHeader* self);
static GamesGameinfoDoc* games_play_station_game_factory_get_gameinfo (GError** error);
static void games_play_station_game_factory_try_add_game (GamesPlayStationGameFactory* self,
                                                   GamesGame* game);
static void _vala_array_add1 (GamesMedia** * array,
                       gint* length,
                       gint* size,
                       GamesMedia* value);
static GamesGame* games_play_station_game_factory_create_game (GamesPlayStationGameFactory* self,
                                                        GamesMediaSet* media_set,
                                                        const gchar* disc_set_id,
                                                        GamesUri* uri,
                                                        GError** error);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda4_ (Block1Data* _data1_,
                 GamesMedia* media);
static void ___lambda4__games_media_set_media_callback (GamesMedia* media,
                                                 gpointer self);
static void games_play_station_game_factory_real_foreach_game (GamesUriGameFactory* base,
                                                        GamesGameCallback game_callback,
                                                        gpointer game_callback_target);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void ___lambda2__gh_func (gconstpointer key,
                          gconstpointer value,
                          gpointer self);
static void __lambda5_ (Block2Data* _data2_,
                 GamesGame* game);
static void ___lambda5__gfunc (gconstpointer data,
                        gpointer self);
static void games_play_station_game_factory_real_set_game_added_callback (GamesUriGameFactory* base,
                                                                   GamesGameCallback game_callback,
                                                                   gpointer game_callback_target);
static void games_play_station_game_factory_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
games_play_station_game_factory_get_instance_private (GamesPlayStationGameFactory* self)
{
	return G_STRUCT_MEMBER_P (self, GamesPlayStationGameFactory_private_offset);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static guint
_games_uri_hash_ghash_func (gconstpointer key)
{
	guint result;
	result = games_uri_hash ((GamesUri*) key);
	return result;
}

static gboolean
_games_uri_equal_gequal_func (gconstpointer a,
                              gconstpointer b)
{
	gboolean result;
	result = games_uri_equal ((GamesUri*) a, (GamesUri*) b);
	return result;
}

static void
_games_uri_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (games_uri_unref (var), NULL));
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GamesPlayStationGameFactory*
games_play_station_game_factory_construct (GType object_type,
                                           GamesRetroPlatform* platform)
{
	GamesPlayStationGameFactory * self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	GHashFunc _tmp4_;
	GEqualFunc _tmp5_;
	GHashTable* _tmp6_;
	GHashFunc _tmp7_;
	GEqualFunc _tmp8_;
	GHashTable* _tmp9_;
	GamesRetroPlatform* _tmp10_;
	g_return_val_if_fail (platform != NULL, NULL);
	self = (GamesPlayStationGameFactory*) g_object_new (object_type, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->media_for_disc_id);
	self->priv->media_for_disc_id = _tmp2_;
	_tmp3_ = g_hash_table_new_full (_games_uri_hash_ghash_func, _games_uri_equal_gequal_func, _games_uri_unref0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->game_for_uri);
	self->priv->game_for_uri = _tmp3_;
	_tmp4_ = g_str_hash;
	_tmp5_ = g_str_equal;
	_tmp6_ = g_hash_table_new_full (_tmp4_, _tmp5_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->game_for_disc_set_id);
	self->priv->game_for_disc_set_id = _tmp6_;
	_tmp7_ = g_direct_hash;
	_tmp8_ = g_direct_equal;
	_tmp9_ = g_hash_table_new_full (_tmp7_, _tmp8_, NULL, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->games);
	self->priv->games = _tmp9_;
	_tmp10_ = _g_object_ref0 (platform);
	_g_object_unref0 (self->priv->platform);
	self->priv->platform = _tmp10_;
	return self;
}

GamesPlayStationGameFactory*
games_play_station_game_factory_new (GamesRetroPlatform* platform)
{
	return games_play_station_game_factory_construct (GAMES_TYPE_PLAY_STATION_GAME_FACTORY, platform);
}

static gchar**
games_play_station_game_factory_real_get_mime_types (GamesUriGameFactory* base,
                                                     gint* result_length1)
{
	GamesPlayStationGameFactory * self;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** result;
	self = (GamesPlayStationGameFactory*) base;
	_tmp0_ = g_strdup (GAMES_PLAY_STATION_GAME_FACTORY_CUE_MIME_TYPE);
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static GamesGame*
games_play_station_game_factory_real_query_game_for_uri (GamesUriGameFactory* base,
                                                         GamesUri* uri)
{
	GamesPlayStationGameFactory * self;
	GHashTable* _tmp0_;
	GamesGame* result;
	self = (GamesPlayStationGameFactory*) base;
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = self->priv->game_for_uri;
	if (g_hash_table_contains (_tmp0_, uri)) {
		GHashTable* _tmp1_;
		gconstpointer _tmp2_;
		GamesGame* _tmp3_;
		_tmp1_ = self->priv->game_for_uri;
		_tmp2_ = g_hash_table_lookup (_tmp1_, uri);
		_tmp3_ = _g_object_ref0 ((GamesGame*) _tmp2_);
		result = _tmp3_;
		return result;
	}
	result = NULL;
	return result;
}

static void
games_play_station_game_factory_real_add_uri (GamesUriGameFactory* base,
                                              GamesUri* uri)
{
	GamesPlayStationGameFactory * self;
	GError* _inner_error0_ = NULL;
	self = (GamesPlayStationGameFactory*) base;
	g_return_if_fail (uri != NULL);
	{
		games_play_station_game_factory_add_uri_with_error (self, uri, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_debug ("playstation-game-factory.vala:43: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gpointer
_games_uri_ref0 (gpointer self)
{
	return self ? games_uri_ref (self) : NULL;
}

static void
_vala_array_add1 (GamesMedia** * array,
                  gint* length,
                  gint* size,
                  GamesMedia* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GamesMedia*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
games_play_station_game_factory_add_uri_with_error (GamesPlayStationGameFactory* self,
                                                    GamesUri* uri,
                                                    GError** error)
{
	GHashTable* _tmp0_;
	GFile* file = NULL;
	GFile* _tmp1_;
	GFileInfo* file_info = NULL;
	GFile* _tmp2_;
	GFileInfo* _tmp3_;
	gchar* mime_type = NULL;
	GFileInfo* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GFile* bin_file = NULL;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GQuark _tmp10_ = 0U;
	static GQuark _tmp9_label0 = 0;
	GamesPlayStationHeader* header = NULL;
	GFile* _tmp31_;
	GamesPlayStationHeader* _tmp32_;
	GamesPlayStationHeader* _tmp33_;
	gchar* disc_id = NULL;
	GamesPlayStationHeader* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	GamesGameinfoDoc* gameinfo = NULL;
	GamesGameinfoDoc* _tmp38_;
	gchar* disc_set_id = NULL;
	GamesGameinfoDoc* _tmp39_;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	GHashTable* _tmp42_;
	const gchar* _tmp43_;
	GHashTable* _tmp44_;
	const gchar* _tmp45_;
	GHashTable* _tmp46_;
	const gchar* _tmp47_;
	GHashTable* new_medias = NULL;
	GHashFunc _tmp61_;
	GEqualFunc _tmp62_;
	GHashTable* _tmp63_;
	GamesMedia** new_medias_array = NULL;
	GamesMedia** _tmp64_;
	gint new_medias_array_length1;
	gint _new_medias_array_size_;
	gchar** new_disc_ids = NULL;
	GamesGameinfoDoc* _tmp65_;
	const gchar* _tmp66_;
	gint _tmp67_ = 0;
	gchar** _tmp68_;
	gint new_disc_ids_length1;
	gint _new_disc_ids_size_;
	gchar** _tmp69_;
	gint _tmp69__length1;
	GamesMedia* media = NULL;
	GHashTable* _tmp85_;
	const gchar* _tmp86_;
	gconstpointer _tmp87_;
	GamesMedia* _tmp88_;
	GamesMedia* _tmp89_;
	GamesMediaSet* media_set = NULL;
	GamesMediaSet* _tmp90_;
	GamesMedia** _tmp91_;
	gint _tmp91__length1;
	GamesMediaSet* _tmp95_;
	GamesGame* game = NULL;
	GamesMediaSet* _tmp96_;
	const gchar* _tmp97_;
	GamesGame* _tmp98_;
	GHashTable* _tmp99_;
	GList* _tmp100_;
	GHashTable* _tmp108_;
	GamesUri* _tmp109_;
	GamesGame* _tmp110_;
	GamesGame* _tmp111_;
	GHashTable* _tmp112_;
	const gchar* _tmp113_;
	gchar* _tmp114_;
	GamesGame* _tmp115_;
	GamesGame* _tmp116_;
	GHashTable* _tmp117_;
	GamesGame* _tmp118_;
	GamesGame* _tmp119_;
	GamesGame* _tmp120_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = self->priv->game_for_uri;
	if (g_hash_table_contains (_tmp0_, uri)) {
		return;
	}
	_tmp1_ = games_uri_to_file (uri);
	file = _tmp1_;
	_tmp2_ = file;
	_tmp3_ = g_file_query_info (_tmp2_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
	file_info = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (file);
		return;
	}
	_tmp4_ = file_info;
	_tmp5_ = g_file_info_get_content_type (_tmp4_);
	_tmp6_ = g_strdup (_tmp5_);
	mime_type = _tmp6_;
	_tmp7_ = mime_type;
	_tmp8_ = _tmp7_;
	_tmp10_ = (NULL == _tmp8_) ? 0 : g_quark_from_string (_tmp8_);
	if (_tmp10_ == ((0 != _tmp9_label0) ? _tmp9_label0 : (_tmp9_label0 = g_quark_from_static_string (GAMES_PLAY_STATION_GAME_FACTORY_CUE_MIME_TYPE)))) {
		switch (0) {
			default:
			{
				GamesCueSheet* cue = NULL;
				GFile* _tmp11_;
				GamesCueSheet* _tmp12_;
				GamesCueSheet* _tmp13_;
				guint _tmp14_;
				guint _tmp15_;
				GamesCueSheetTrackNode* track = NULL;
				GamesCueSheet* _tmp16_;
				GamesCueSheetTrackNode* _tmp17_;
				gboolean _tmp18_ = FALSE;
				GamesCueSheetTrackNode* _tmp19_;
				GamesCueSheetTrackMode _tmp20_;
				GamesCueSheetTrackMode _tmp21_;
				GamesCueSheetTrackNode* _tmp25_;
				GamesCueSheetFileNode* _tmp26_;
				GamesCueSheetFileNode* _tmp27_;
				GFile* _tmp28_;
				GFile* _tmp29_;
				GFile* _tmp30_;
				_tmp11_ = file;
				_tmp12_ = games_cue_sheet_new (_tmp11_, &_inner_error0_);
				cue = _tmp12_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (bin_file);
					_g_free0 (mime_type);
					_g_object_unref0 (file_info);
					_g_object_unref0 (file);
					return;
				}
				_tmp13_ = cue;
				_tmp14_ = games_cue_sheet_get_tracks_number (_tmp13_);
				_tmp15_ = _tmp14_;
				if (_tmp15_ == ((guint) 0)) {
					_g_object_unref0 (cue);
					_g_object_unref0 (bin_file);
					_g_free0 (mime_type);
					_g_object_unref0 (file_info);
					_g_object_unref0 (file);
					return;
				}
				_tmp16_ = cue;
				_tmp17_ = games_cue_sheet_get_track (_tmp16_, (guint) 0, &_inner_error0_);
				track = _tmp17_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (cue);
					_g_object_unref0 (bin_file);
					_g_free0 (mime_type);
					_g_object_unref0 (file_info);
					_g_object_unref0 (file);
					return;
				}
				_tmp19_ = track;
				_tmp20_ = games_cue_sheet_track_node_get_track_mode (_tmp19_);
				_tmp21_ = _tmp20_;
				if (_tmp21_ != GAMES_CUE_SHEET_TRACK_MODE_MODE1_2352) {
					GamesCueSheetTrackNode* _tmp22_;
					GamesCueSheetTrackMode _tmp23_;
					GamesCueSheetTrackMode _tmp24_;
					_tmp22_ = track;
					_tmp23_ = games_cue_sheet_track_node_get_track_mode (_tmp22_);
					_tmp24_ = _tmp23_;
					_tmp18_ = _tmp24_ != GAMES_CUE_SHEET_TRACK_MODE_MODE2_2352;
				} else {
					_tmp18_ = FALSE;
				}
				if (_tmp18_) {
					_g_object_unref0 (track);
					_g_object_unref0 (cue);
					_g_object_unref0 (bin_file);
					_g_free0 (mime_type);
					_g_object_unref0 (file_info);
					_g_object_unref0 (file);
					return;
				}
				_tmp25_ = track;
				_tmp26_ = games_cue_sheet_track_node_get_file (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = games_cue_sheet_file_node_get_file (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = _g_object_ref0 (_tmp29_);
				_g_object_unref0 (bin_file);
				bin_file = _tmp30_;
				_g_object_unref0 (track);
				_g_object_unref0 (cue);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				_g_object_unref0 (bin_file);
				_g_free0 (mime_type);
				_g_object_unref0 (file_info);
				_g_object_unref0 (file);
				return;
			}
		}
	}
	_tmp31_ = bin_file;
	_tmp32_ = games_play_station_header_new (_tmp31_);
	header = _tmp32_;
	_tmp33_ = header;
	games_play_station_header_check_validity (_tmp33_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (header);
		_g_object_unref0 (bin_file);
		_g_free0 (mime_type);
		_g_object_unref0 (file_info);
		_g_object_unref0 (file);
		return;
	}
	_tmp34_ = header;
	_tmp35_ = games_play_station_header_get_disc_id (_tmp34_);
	_tmp36_ = _tmp35_;
	_tmp37_ = g_strdup (_tmp36_);
	disc_id = _tmp37_;
	_tmp38_ = games_play_station_game_factory_get_gameinfo (&_inner_error0_);
	gameinfo = _tmp38_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (disc_id);
		_g_object_unref0 (header);
		_g_object_unref0 (bin_file);
		_g_free0 (mime_type);
		_g_object_unref0 (file_info);
		_g_object_unref0 (file);
		return;
	}
	_tmp39_ = gameinfo;
	_tmp40_ = disc_id;
	_tmp41_ = games_gameinfo_doc_get_disc_set_id_for_disc_id (_tmp39_, _tmp40_, &_inner_error0_);
	disc_set_id = _tmp41_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (gameinfo);
		_g_free0 (disc_id);
		_g_object_unref0 (header);
		_g_object_unref0 (bin_file);
		_g_free0 (mime_type);
		_g_object_unref0 (file_info);
		_g_object_unref0 (file);
		return;
	}
	_tmp42_ = self->priv->media_for_disc_id;
	_tmp43_ = disc_id;
	_tmp44_ = self->priv->game_for_disc_set_id;
	_tmp45_ = disc_set_id;
	g_return_if_fail (g_hash_table_contains (_tmp42_, _tmp43_) == g_hash_table_contains (_tmp44_, _tmp45_));
	_tmp46_ = self->priv->media_for_disc_id;
	_tmp47_ = disc_id;
	if (g_hash_table_contains (_tmp46_, _tmp47_)) {
		GamesMedia* media = NULL;
		GHashTable* _tmp48_;
		const gchar* _tmp49_;
		gconstpointer _tmp50_;
		GamesMedia* _tmp51_;
		GamesMedia* _tmp52_;
		GHashTable* _tmp53_;
		GamesUri* _tmp54_;
		GHashTable* _tmp55_;
		const gchar* _tmp56_;
		gconstpointer _tmp57_;
		GamesGame* _tmp58_;
		GHashTable* _tmp59_;
		gconstpointer _tmp60_;
		_tmp48_ = self->priv->media_for_disc_id;
		_tmp49_ = disc_id;
		_tmp50_ = g_hash_table_lookup (_tmp48_, _tmp49_);
		_tmp51_ = _g_object_ref0 ((GamesMedia*) _tmp50_);
		media = _tmp51_;
		_tmp52_ = media;
		games_media_add_uri (_tmp52_, uri);
		_tmp53_ = self->priv->game_for_uri;
		_tmp54_ = _games_uri_ref0 (uri);
		_tmp55_ = self->priv->game_for_disc_set_id;
		_tmp56_ = disc_set_id;
		_tmp57_ = g_hash_table_lookup (_tmp55_, _tmp56_);
		_tmp58_ = _g_object_ref0 ((GamesGame*) _tmp57_);
		g_hash_table_insert (_tmp53_, _tmp54_, _tmp58_);
		_tmp59_ = self->priv->game_for_uri;
		_tmp60_ = g_hash_table_lookup (_tmp59_, uri);
		games_play_station_game_factory_try_add_game (self, (GamesGame*) _tmp60_);
		_g_object_unref0 (media);
		_g_free0 (disc_set_id);
		_g_object_unref0 (gameinfo);
		_g_free0 (disc_id);
		_g_object_unref0 (header);
		_g_object_unref0 (bin_file);
		_g_free0 (mime_type);
		_g_object_unref0 (file_info);
		_g_object_unref0 (file);
		return;
	}
	_tmp61_ = g_str_hash;
	_tmp62_ = g_str_equal;
	_tmp63_ = g_hash_table_new_full (_tmp61_, _tmp62_, _g_free0_, _g_object_unref0_);
	new_medias = _tmp63_;
	_tmp64_ = g_new0 (GamesMedia*, 0 + 1);
	new_medias_array = _tmp64_;
	new_medias_array_length1 = 0;
	_new_medias_array_size_ = new_medias_array_length1;
	_tmp65_ = gameinfo;
	_tmp66_ = disc_id;
	_tmp68_ = games_gameinfo_doc_get_disc_set_ids_for_disc_id (_tmp65_, _tmp66_, &_tmp67_, &_inner_error0_);
	new_disc_ids = _tmp68_;
	new_disc_ids_length1 = _tmp67_;
	_new_disc_ids_size_ = new_disc_ids_length1;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		new_medias_array = (_vala_array_free (new_medias_array, new_medias_array_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_hash_table_unref0 (new_medias);
		_g_free0 (disc_set_id);
		_g_object_unref0 (gameinfo);
		_g_free0 (disc_id);
		_g_object_unref0 (header);
		_g_object_unref0 (bin_file);
		_g_free0 (mime_type);
		_g_object_unref0 (file_info);
		_g_object_unref0 (file);
		return;
	}
	_tmp69_ = new_disc_ids;
	_tmp69__length1 = new_disc_ids_length1;
	{
		gchar** new_disc_id_collection = NULL;
		gint new_disc_id_collection_length1 = 0;
		gint _new_disc_id_collection_size_ = 0;
		gint new_disc_id_it = 0;
		new_disc_id_collection = _tmp69_;
		new_disc_id_collection_length1 = _tmp69__length1;
		for (new_disc_id_it = 0; new_disc_id_it < new_disc_id_collection_length1; new_disc_id_it = new_disc_id_it + 1) {
			gchar* _tmp70_;
			gchar* new_disc_id = NULL;
			_tmp70_ = g_strdup (new_disc_id_collection[new_disc_id_it]);
			new_disc_id = _tmp70_;
			{
				GHashTable* _tmp71_;
				const gchar* _tmp72_;
				GamesGameinfoDiscIdDiscTitle* title = NULL;
				GamesGameinfoDoc* _tmp73_;
				const gchar* _tmp74_;
				GamesGameinfoDiscIdDiscTitle* _tmp75_;
				GamesMedia* media = NULL;
				GamesGameinfoDiscIdDiscTitle* _tmp76_;
				GamesMedia* _tmp77_;
				GamesMedia* _tmp78_;
				GamesMedia* _tmp79_;
				GHashTable* _tmp80_;
				const gchar* _tmp81_;
				gchar* _tmp82_;
				GamesMedia* _tmp83_;
				GamesMedia* _tmp84_;
				_tmp71_ = self->priv->media_for_disc_id;
				_tmp72_ = new_disc_id;
				_vala_assert (!g_hash_table_contains (_tmp71_, _tmp72_), "!media_for_disc_id.contains (new_disc_id)");
				_tmp73_ = gameinfo;
				_tmp74_ = new_disc_id;
				_tmp75_ = games_gameinfo_disc_id_disc_title_new (_tmp73_, _tmp74_, NULL);
				title = _tmp75_;
				_tmp76_ = title;
				_tmp77_ = games_media_new ((GamesTitle*) _tmp76_);
				media = _tmp77_;
				_tmp78_ = media;
				_tmp79_ = _g_object_ref0 (_tmp78_);
				_vala_array_add1 (&new_medias_array, &new_medias_array_length1, &_new_medias_array_size_, _tmp79_);
				_tmp80_ = new_medias;
				_tmp81_ = new_disc_id;
				_tmp82_ = g_strdup (_tmp81_);
				_tmp83_ = media;
				_tmp84_ = _g_object_ref0 (_tmp83_);
				g_hash_table_insert (_tmp80_, _tmp82_, _tmp84_);
				_g_object_unref0 (media);
				_g_object_unref0 (title);
				_g_free0 (new_disc_id);
			}
		}
	}
	_tmp85_ = new_medias;
	_tmp86_ = disc_id;
	_tmp87_ = g_hash_table_lookup (_tmp85_, _tmp86_);
	_tmp88_ = _g_object_ref0 ((GamesMedia*) _tmp87_);
	media = _tmp88_;
	_tmp89_ = media;
	games_media_add_uri (_tmp89_, uri);
	_tmp90_ = games_media_set_new ();
	media_set = _tmp90_;
	_tmp91_ = new_medias_array;
	_tmp91__length1 = new_medias_array_length1;
	{
		GamesMedia** game_media_collection = NULL;
		gint game_media_collection_length1 = 0;
		gint _game_media_collection_size_ = 0;
		gint game_media_it = 0;
		game_media_collection = _tmp91_;
		game_media_collection_length1 = _tmp91__length1;
		for (game_media_it = 0; game_media_it < game_media_collection_length1; game_media_it = game_media_it + 1) {
			GamesMedia* _tmp92_;
			GamesMedia* game_media = NULL;
			_tmp92_ = _g_object_ref0 (game_media_collection[game_media_it]);
			game_media = _tmp92_;
			{
				GamesMediaSet* _tmp93_;
				GamesMedia* _tmp94_;
				_tmp93_ = media_set;
				_tmp94_ = game_media;
				games_media_set_add_media (_tmp93_, _tmp94_);
				_g_object_unref0 (game_media);
			}
		}
	}
	_tmp95_ = media_set;
	games_media_set_set_icon_name (_tmp95_, GAMES_PLAY_STATION_GAME_FACTORY_ICON_NAME);
	_tmp96_ = media_set;
	_tmp97_ = disc_set_id;
	_tmp98_ = games_play_station_game_factory_create_game (self, _tmp96_, _tmp97_, uri, &_inner_error0_);
	game = _tmp98_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (media_set);
		_g_object_unref0 (media);
		new_disc_ids = (_vala_array_free (new_disc_ids, new_disc_ids_length1, (GDestroyNotify) g_free), NULL);
		new_medias_array = (_vala_array_free (new_medias_array, new_medias_array_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_hash_table_unref0 (new_medias);
		_g_free0 (disc_set_id);
		_g_object_unref0 (gameinfo);
		_g_free0 (disc_id);
		_g_object_unref0 (header);
		_g_object_unref0 (bin_file);
		_g_free0 (mime_type);
		_g_object_unref0 (file_info);
		_g_object_unref0 (file);
		return;
	}
	_tmp99_ = new_medias;
	_tmp100_ = g_hash_table_get_keys (_tmp99_);
	{
		GList* new_disc_id_collection = NULL;
		GList* new_disc_id_it = NULL;
		new_disc_id_collection = _tmp100_;
		for (new_disc_id_it = new_disc_id_collection; new_disc_id_it != NULL; new_disc_id_it = new_disc_id_it->next) {
			const gchar* new_disc_id = NULL;
			new_disc_id = (const gchar*) new_disc_id_it->data;
			{
				GHashTable* _tmp101_;
				const gchar* _tmp102_;
				gchar* _tmp103_;
				GHashTable* _tmp104_;
				const gchar* _tmp105_;
				gconstpointer _tmp106_;
				GamesMedia* _tmp107_;
				_tmp101_ = self->priv->media_for_disc_id;
				_tmp102_ = new_disc_id;
				_tmp103_ = g_strdup (_tmp102_);
				_tmp104_ = new_medias;
				_tmp105_ = new_disc_id;
				_tmp106_ = g_hash_table_lookup (_tmp104_, _tmp105_);
				_tmp107_ = _g_object_ref0 ((GamesMedia*) _tmp106_);
				g_hash_table_insert (_tmp101_, _tmp103_, _tmp107_);
			}
		}
		(new_disc_id_collection == NULL) ? NULL : (new_disc_id_collection = (g_list_free (new_disc_id_collection), NULL));
	}
	_tmp108_ = self->priv->game_for_uri;
	_tmp109_ = _games_uri_ref0 (uri);
	_tmp110_ = game;
	_tmp111_ = _g_object_ref0 (_tmp110_);
	g_hash_table_insert (_tmp108_, _tmp109_, _tmp111_);
	_tmp112_ = self->priv->game_for_disc_set_id;
	_tmp113_ = disc_set_id;
	_tmp114_ = g_strdup (_tmp113_);
	_tmp115_ = game;
	_tmp116_ = _g_object_ref0 (_tmp115_);
	g_hash_table_insert (_tmp112_, _tmp114_, _tmp116_);
	_tmp117_ = self->priv->games;
	_tmp118_ = game;
	_tmp119_ = _g_object_ref0 (_tmp118_);
	g_hash_table_add (_tmp117_, _tmp119_);
	_tmp120_ = game;
	games_play_station_game_factory_try_add_game (self, _tmp120_);
	_g_object_unref0 (game);
	_g_object_unref0 (media_set);
	_g_object_unref0 (media);
	new_disc_ids = (_vala_array_free (new_disc_ids, new_disc_ids_length1, (GDestroyNotify) g_free), NULL);
	new_medias_array = (_vala_array_free (new_medias_array, new_medias_array_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_hash_table_unref0 (new_medias);
	_g_free0 (disc_set_id);
	_g_object_unref0 (gameinfo);
	_g_free0 (disc_id);
	_g_object_unref0 (header);
	_g_object_unref0 (bin_file);
	_g_free0 (mime_type);
	_g_object_unref0 (file_info);
	_g_object_unref0 (file);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		GamesPlayStationGameFactory* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda4_ (Block1Data* _data1_,
            GamesMedia* media)
{
	GamesPlayStationGameFactory* self;
	gint _tmp0_ = 0;
	GamesUri** _tmp1_;
	GamesUri** _tmp2_;
	gint _tmp2__length1;
	self = _data1_->self;
	g_return_if_fail (media != NULL);
	_tmp1_ = games_media_get_uris (media, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	_data1_->is_complete &= _tmp0_ != 0;
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) games_uri_unref), NULL);
}

static void
___lambda4__games_media_set_media_callback (GamesMedia* media,
                                            gpointer self)
{
	__lambda4_ (self, media);
}

static void
games_play_station_game_factory_try_add_game (GamesPlayStationGameFactory* self,
                                              GamesGame* game)
{
	Block1Data* _data1_;
	GamesGameCallback _tmp0_;
	gpointer _tmp0__target;
	GamesMediaSet* _tmp1_;
	GamesMediaSet* _tmp2_;
	GamesGameCallback _tmp3_;
	gpointer _tmp3__target;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = self->priv->game_added_callback;
	_tmp0__target = self->priv->game_added_callback_target;
	if (_tmp0_ == NULL) {
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return;
	}
	_data1_->is_complete = TRUE;
	_tmp1_ = games_game_get_media_set (game);
	_tmp2_ = _tmp1_;
	games_media_set_foreach_media (_tmp2_, ___lambda4__games_media_set_media_callback, _data1_);
	if (!_data1_->is_complete) {
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return;
	}
	_tmp3_ = self->priv->game_added_callback;
	_tmp3__target = self->priv->game_added_callback_target;
	_tmp3_ (game, _tmp3__target);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		GamesPlayStationGameFactory* self;
		self = _data2_->self;
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		GHashTable* self;
		self = _data3_->self;
		_g_hash_table_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
__lambda2_ (Block3Data* _data3_,
            gconstpointer k,
            gconstpointer v)
{
	GHashTable* self;
	self = _data3_->self;
	_data3_->func (v, _data3_->func_target);
}

static void
___lambda2__gh_func (gconstpointer key,
                     gconstpointer value,
                     gpointer self)
{
	__lambda2_ (self, key, value);
}

static void
_vala_g_hash_set_foreach (GHashTable* self,
                          GFunc func,
                          gpointer func_target)
{
	Block3Data* _data3_;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_hash_table_ref (self);
	_data3_->func = func;
	_data3_->func_target = func_target;
	g_hash_table_foreach ((GHashTable*) self, ___lambda2__gh_func, _data3_);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static void
__lambda5_ (Block2Data* _data2_,
            GamesGame* game)
{
	GamesPlayStationGameFactory* self;
	self = _data2_->self;
	g_return_if_fail (game != NULL);
	_data2_->game_callback (game, _data2_->game_callback_target);
}

static void
___lambda5__gfunc (gconstpointer data,
                   gpointer self)
{
	__lambda5_ (self, (GamesGame*) data);
}

static void
games_play_station_game_factory_real_foreach_game (GamesUriGameFactory* base,
                                                   GamesGameCallback game_callback,
                                                   gpointer game_callback_target)
{
	GamesPlayStationGameFactory * self;
	Block2Data* _data2_;
	GHashTable* _tmp0_;
	self = (GamesPlayStationGameFactory*) base;
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_data2_->game_callback = game_callback;
	_data2_->game_callback_target = game_callback_target;
	_tmp0_ = self->priv->games;
	_vala_g_hash_set_foreach (_tmp0_, ___lambda5__gfunc, _data2_);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static GamesGame*
games_play_station_game_factory_create_game (GamesPlayStationGameFactory* self,
                                             GamesMediaSet* media_set,
                                             const gchar* disc_set_id,
                                             GamesUri* uri,
                                             GError** error)
{
	gchar* uid_string = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GamesGameinfoDoc* gameinfo = NULL;
	GamesGameinfoDoc* _tmp6_;
	GamesUid* uid = NULL;
	GamesUid* _tmp7_;
	GamesCompositeTitle* title = NULL;
	GamesGameinfoDiscIdGameTitle* _tmp8_;
	GamesFilenameTitle* _tmp9_;
	GamesTitle** _tmp10_;
	GamesTitle** _tmp11_;
	gint _tmp11__length1;
	GamesCompositeTitle* _tmp12_;
	GamesCompositeTitle* _tmp13_;
	GamesGriloMedia* media = NULL;
	GamesCompositeTitle* _tmp14_;
	GamesGriloMedia* _tmp15_;
	GamesCompositeCover* cover = NULL;
	GamesLocalCover* _tmp16_;
	GamesGriloMedia* _tmp17_;
	GamesUid* _tmp18_;
	GamesGriloCover* _tmp19_;
	GamesCover** _tmp20_;
	GamesCover** _tmp21_;
	gint _tmp21__length1;
	GamesCompositeCover* _tmp22_;
	GamesCompositeCover* _tmp23_;
	GamesGame* game = NULL;
	GamesUid* _tmp24_;
	GamesCompositeTitle* _tmp25_;
	GamesRetroPlatform* _tmp26_;
	GamesGame* _tmp27_;
	GamesGame* _tmp28_;
	GamesCompositeCover* _tmp29_;
	GamesGame* _tmp30_;
	GError* _inner_error0_ = NULL;
	GamesGame* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (media_set != NULL, NULL);
	g_return_val_if_fail (disc_set_id != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = string_to_string (GAMES_PLAY_STATION_GAME_FACTORY_PLATFORM_UID_PREFIX);
	_tmp1_ = string_to_string (disc_set_id);
	_tmp2_ = g_strconcat (_tmp0_, "-", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_utf8_strdown (_tmp3_, (gssize) -1);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	uid_string = _tmp5_;
	_tmp6_ = games_play_station_game_factory_get_gameinfo (&_inner_error0_);
	gameinfo = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (uid_string);
		return NULL;
	}
	_tmp7_ = games_uid_new (uid_string);
	uid = _tmp7_;
	_tmp8_ = games_gameinfo_disc_id_game_title_new (gameinfo, disc_set_id, NULL);
	_tmp9_ = games_filename_title_new (uri);
	_tmp10_ = g_new0 (GamesTitle*, 2 + 1);
	_tmp10_[0] = (GamesTitle*) _tmp8_;
	_tmp10_[1] = (GamesTitle*) _tmp9_;
	_tmp11_ = _tmp10_;
	_tmp11__length1 = 2;
	_tmp12_ = games_composite_title_new (_tmp11_, 2);
	_tmp13_ = _tmp12_;
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_object_unref), NULL);
	title = _tmp13_;
	_tmp14_ = title;
	_tmp15_ = games_grilo_media_new ((GamesTitle*) _tmp14_, GAMES_PLAY_STATION_GAME_FACTORY_PHONY_MIME_TYPE);
	media = _tmp15_;
	_tmp16_ = games_local_cover_new (uri);
	_tmp17_ = media;
	_tmp18_ = uid;
	_tmp19_ = games_grilo_cover_new (_tmp17_, _tmp18_);
	_tmp20_ = g_new0 (GamesCover*, 2 + 1);
	_tmp20_[0] = (GamesCover*) _tmp16_;
	_tmp20_[1] = (GamesCover*) _tmp19_;
	_tmp21_ = _tmp20_;
	_tmp21__length1 = 2;
	_tmp22_ = games_composite_cover_new (_tmp21_, 2);
	_tmp23_ = _tmp22_;
	_tmp21_ = (_vala_array_free (_tmp21_, _tmp21__length1, (GDestroyNotify) g_object_unref), NULL);
	cover = _tmp23_;
	_tmp24_ = uid;
	_tmp25_ = title;
	_tmp26_ = self->priv->platform;
	_tmp27_ = games_game_new (_tmp24_, uri, (GamesTitle*) _tmp25_, (GamesPlatform*) _tmp26_);
	game = _tmp27_;
	_tmp28_ = game;
	_tmp29_ = cover;
	games_game_set_cover (_tmp28_, (GamesCover*) _tmp29_);
	_tmp30_ = game;
	games_game_set_media_set (_tmp30_, media_set);
	result = game;
	_g_object_unref0 (cover);
	_g_object_unref0 (media);
	_g_object_unref0 (title);
	_g_object_unref0 (uid);
	_g_object_unref0 (gameinfo);
	_g_free0 (uid_string);
	return result;
}

static GamesGameinfoDoc*
games_play_station_game_factory_get_gameinfo (GError** error)
{
	GamesGameinfoDoc* _tmp0_;
	GFile* file = NULL;
	GFile* _tmp3_;
	GFileInputStream* input_stream = NULL;
	GFile* _tmp4_;
	GFileInputStream* _tmp5_;
	GFileInputStream* _tmp6_;
	gint64 length = 0LL;
	GFileInputStream* _tmp7_;
	GFileInputStream* _tmp8_;
	guint8* buffer = NULL;
	guint8* _tmp9_;
	gint buffer_length1;
	gint _buffer_size_;
	gsize size = 0UL;
	GFileInputStream* _tmp10_;
	guint8* _tmp11_;
	gint _tmp11__length1;
	gsize _tmp12_ = 0UL;
	GamesGameinfoDoc* _tmp13_ = NULL;
	guint8* _tmp14_;
	gint _tmp14__length1;
	GamesGameinfoDoc* _tmp15_;
	GamesGameinfoDoc* _tmp16_;
	GamesGameinfoDoc* _tmp17_;
	GamesGameinfoDoc* _tmp18_;
	GError* _inner_error0_ = NULL;
	GamesGameinfoDoc* result;
	_tmp0_ = games_play_station_game_factory_gameinfo;
	if (_tmp0_ != NULL) {
		GamesGameinfoDoc* _tmp1_;
		GamesGameinfoDoc* _tmp2_;
		_tmp1_ = games_play_station_game_factory_gameinfo;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = g_file_new_for_uri (GAMES_PLAY_STATION_GAME_FACTORY_GAMEINFO);
	file = _tmp3_;
	_tmp4_ = file;
	_tmp5_ = g_file_read (_tmp4_, NULL, &_inner_error0_);
	input_stream = _tmp5_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp6_ = input_stream;
	G_TYPE_INSTANCE_GET_CLASS (_tmp6_, g_file_input_stream_get_type (), GFileInputStreamClass)->seek (_tmp6_, (gint64) 0, G_SEEK_END, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (input_stream);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp7_ = input_stream;
	length = G_TYPE_INSTANCE_GET_CLASS (_tmp7_, g_file_input_stream_get_type (), GFileInputStreamClass)->tell (_tmp7_);
	_tmp8_ = input_stream;
	G_TYPE_INSTANCE_GET_CLASS (_tmp8_, g_file_input_stream_get_type (), GFileInputStreamClass)->seek (_tmp8_, (gint64) 0, G_SEEK_SET, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (input_stream);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp9_ = g_new0 (guint8, length);
	buffer = _tmp9_;
	buffer_length1 = length;
	_buffer_size_ = buffer_length1;
	size = (gsize) 0;
	_tmp10_ = input_stream;
	_tmp11_ = buffer;
	_tmp11__length1 = buffer_length1;
	g_input_stream_read_all ((GInputStream*) _tmp10_, _tmp11_, (gsize) _tmp11__length1, &_tmp12_, NULL, &_inner_error0_);
	size = _tmp12_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		buffer = (g_free (buffer), NULL);
		_g_object_unref0 (input_stream);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp14_ = buffer;
	_tmp14__length1 = buffer_length1;
	_tmp15_ = games_gameinfo_doc_new_from_data (_tmp14_, _tmp14__length1, &_inner_error0_);
	_tmp13_ = _tmp15_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		buffer = (g_free (buffer), NULL);
		_g_object_unref0 (input_stream);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp16_ = _tmp13_;
	_tmp13_ = NULL;
	_g_object_unref0 (games_play_station_game_factory_gameinfo);
	games_play_station_game_factory_gameinfo = _tmp16_;
	_tmp17_ = games_play_station_game_factory_gameinfo;
	_tmp18_ = _g_object_ref0 (_tmp17_);
	result = _tmp18_;
	_g_object_unref0 (_tmp13_);
	buffer = (g_free (buffer), NULL);
	_g_object_unref0 (input_stream);
	_g_object_unref0 (file);
	return result;
}

static void
games_play_station_game_factory_real_set_game_added_callback (GamesUriGameFactory* base,
                                                              GamesGameCallback game_callback,
                                                              gpointer game_callback_target)
{
	GamesPlayStationGameFactory * self;
	self = (GamesPlayStationGameFactory*) base;
	self->priv->game_added_callback = game_callback;
	self->priv->game_added_callback_target = game_callback_target;
}

static void
games_play_station_game_factory_class_init (GamesPlayStationGameFactoryClass * klass,
                                            gpointer klass_data)
{
	games_play_station_game_factory_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesPlayStationGameFactory_private_offset);
	G_OBJECT_CLASS (klass)->finalize = games_play_station_game_factory_finalize;
}

static void
games_play_station_game_factory_games_uri_game_factory_interface_init (GamesUriGameFactoryIface * iface,
                                                                       gpointer iface_data)
{
	games_play_station_game_factory_games_uri_game_factory_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_mime_types = (gchar** (*) (GamesUriGameFactory*, gint*)) games_play_station_game_factory_real_get_mime_types;
	iface->query_game_for_uri = (GamesGame* (*) (GamesUriGameFactory*, GamesUri*)) games_play_station_game_factory_real_query_game_for_uri;
	iface->add_uri = (void (*) (GamesUriGameFactory*, GamesUri*)) games_play_station_game_factory_real_add_uri;
	iface->foreach_game = (void (*) (GamesUriGameFactory*, GamesGameCallback, gpointer)) games_play_station_game_factory_real_foreach_game;
	iface->set_game_added_callback = (void (*) (GamesUriGameFactory*, GamesGameCallback, gpointer)) games_play_station_game_factory_real_set_game_added_callback;
}

static void
games_play_station_game_factory_instance_init (GamesPlayStationGameFactory * self,
                                               gpointer klass)
{
	self->priv = games_play_station_game_factory_get_instance_private (self);
}

static void
games_play_station_game_factory_finalize (GObject * obj)
{
	GamesPlayStationGameFactory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_PLAY_STATION_GAME_FACTORY, GamesPlayStationGameFactory);
	_g_hash_table_unref0 (self->priv->media_for_disc_id);
	_g_hash_table_unref0 (self->priv->game_for_uri);
	_g_hash_table_unref0 (self->priv->game_for_disc_set_id);
	_g_hash_table_unref0 (self->priv->games);
	_g_object_unref0 (self->priv->platform);
	G_OBJECT_CLASS (games_play_station_game_factory_parent_class)->finalize (obj);
}

GType
games_play_station_game_factory_get_type (void)
{
	return games_play_station_game_factory_type_id;
}

GType
games_play_station_game_factory_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesPlayStationGameFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_play_station_game_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesPlayStationGameFactory), 0, (GInstanceInitFunc) games_play_station_game_factory_instance_init, NULL };
	static const GInterfaceInfo games_uri_game_factory_info = { (GInterfaceInitFunc) games_play_station_game_factory_games_uri_game_factory_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	games_play_station_game_factory_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GamesPlayStationGameFactory", &g_define_type_info, 0);
	g_type_module_add_interface (module, games_play_station_game_factory_type_id, GAMES_TYPE_URI_GAME_FACTORY, &games_uri_game_factory_info);
	GamesPlayStationGameFactory_private_offset = sizeof (GamesPlayStationGameFactoryPrivate);
	return games_play_station_game_factory_type_id;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

