/* keyboard-mapping-manager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from keyboard-mapping-manager.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib-object.h>
#include <retro-gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "gnome-games.h"

#define GAMES_KEYBOARD_MAPPING_MANAGER_MAPPING_FILE_NAME "keyboard-mapping.txt"
#define GAMES_KEYBOARD_MAPPING_MANAGER_GROUP_NAME "KeyboardMapping"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GAMES_TYPE_KEYBOARD_MAPPING_MANAGER (games_keyboard_mapping_manager_get_type ())
#define GAMES_KEYBOARD_MAPPING_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_KEYBOARD_MAPPING_MANAGER, GamesKeyboardMappingManager))
#define GAMES_KEYBOARD_MAPPING_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_KEYBOARD_MAPPING_MANAGER, GamesKeyboardMappingManagerClass))
#define GAMES_IS_KEYBOARD_MAPPING_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_KEYBOARD_MAPPING_MANAGER))
#define GAMES_IS_KEYBOARD_MAPPING_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_KEYBOARD_MAPPING_MANAGER))
#define GAMES_KEYBOARD_MAPPING_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_KEYBOARD_MAPPING_MANAGER, GamesKeyboardMappingManagerClass))

typedef struct _GamesKeyboardMappingManager GamesKeyboardMappingManager;
typedef struct _GamesKeyboardMappingManagerClass GamesKeyboardMappingManagerClass;
typedef struct _GamesKeyboardMappingManagerPrivate GamesKeyboardMappingManagerPrivate;
enum  {
	GAMES_KEYBOARD_MAPPING_MANAGER_0_PROPERTY,
	GAMES_KEYBOARD_MAPPING_MANAGER_MAPPING_PROPERTY,
	GAMES_KEYBOARD_MAPPING_MANAGER_NUM_PROPERTIES
};
static GParamSpec* games_keyboard_mapping_manager_properties[GAMES_KEYBOARD_MAPPING_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))
enum  {
	GAMES_KEYBOARD_MAPPING_MANAGER_CHANGED_SIGNAL,
	GAMES_KEYBOARD_MAPPING_MANAGER_NUM_SIGNALS
};
static guint games_keyboard_mapping_manager_signals[GAMES_KEYBOARD_MAPPING_MANAGER_NUM_SIGNALS] = {0};

struct _GamesKeyboardMappingManager {
	GObject parent_instance;
	GamesKeyboardMappingManagerPrivate * priv;
};

struct _GamesKeyboardMappingManagerClass {
	GObjectClass parent_class;
};

struct _GamesKeyboardMappingManagerPrivate {
	RetroKeyJoypadMapping* _mapping;
	GFile* mapping_file;
	GFileMonitor* mapping_monitor;
};

static gint GamesKeyboardMappingManager_private_offset;
static gpointer games_keyboard_mapping_manager_parent_class = NULL;

VALA_EXTERN GType games_keyboard_mapping_manager_get_type (void) G_GNUC_CONST ;
static void games_keyboard_mapping_manager_load_mapping (GamesKeyboardMappingManager* self);
static void games_keyboard_mapping_manager_set_mapping (GamesKeyboardMappingManager* self,
                                                 RetroKeyJoypadMapping* value);
VALA_EXTERN RetroKeyJoypadMapping* games_keyboard_mapping_manager_get_mapping (GamesKeyboardMappingManager* self);
VALA_EXTERN gboolean games_keyboard_mapping_manager_is_default (GamesKeyboardMappingManager* self);
VALA_EXTERN void games_keyboard_mapping_manager_save_mapping (GamesKeyboardMappingManager* self,
                                                  RetroKeyJoypadMapping* mapping);
VALA_EXTERN void games_keyboard_mapping_manager_delete_mapping (GamesKeyboardMappingManager* self);
VALA_EXTERN GamesKeyboardMappingManager* games_keyboard_mapping_manager_new (void);
VALA_EXTERN GamesKeyboardMappingManager* games_keyboard_mapping_manager_construct (GType object_type);
static GObject * games_keyboard_mapping_manager_constructor (GType type,
                                                      guint n_construct_properties,
                                                      GObjectConstructParam * construct_properties);
static void _games_keyboard_mapping_manager_load_mapping_g_file_monitor_changed (GFileMonitor* _sender,
                                                                          GFile* file,
                                                                          GFile* other_file,
                                                                          GFileMonitorEvent event_type,
                                                                          gpointer self);
static void games_keyboard_mapping_manager_finalize (GObject * obj);
static GType games_keyboard_mapping_manager_get_type_once (void);
static void _vala_games_keyboard_mapping_manager_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec);
static void _vala_games_keyboard_mapping_manager_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
games_keyboard_mapping_manager_get_instance_private (GamesKeyboardMappingManager* self)
{
	return G_STRUCT_MEMBER_P (self, GamesKeyboardMappingManager_private_offset);
}

static void
games_keyboard_mapping_manager_load_mapping (GamesKeyboardMappingManager* self)
{
	GFile* _tmp0_;
	RetroKeyJoypadMapping* _tmp3_;
	RetroKeyJoypadMapping* _tmp4_;
	GKeyFile* mapping_key_file = NULL;
	GKeyFile* _tmp5_;
	GEnumClass* enumc = NULL;
	GTypeClass* _tmp12_;
	GEnumClass* _tmp13_;
	GEnumValue* _tmp14_;
	gint _tmp14__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mapping_file;
	if (!g_file_query_exists (_tmp0_, NULL)) {
		RetroKeyJoypadMapping* _tmp1_;
		RetroKeyJoypadMapping* _tmp2_;
		g_debug ("keyboard-mapping-manager.vala:30: User keyboard mapping file doesn't e" \
"xist.");
		_tmp1_ = retro_key_joypad_mapping_new_default ();
		_tmp2_ = _tmp1_;
		games_keyboard_mapping_manager_set_mapping (self, _tmp2_);
		_g_object_unref0 (_tmp2_);
		g_signal_emit (self, games_keyboard_mapping_manager_signals[GAMES_KEYBOARD_MAPPING_MANAGER_CHANGED_SIGNAL], 0);
		return;
	}
	_tmp3_ = retro_key_joypad_mapping_new ();
	_tmp4_ = _tmp3_;
	games_keyboard_mapping_manager_set_mapping (self, _tmp4_);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = g_key_file_new ();
	mapping_key_file = _tmp5_;
	{
		GKeyFile* _tmp6_;
		GFile* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp6_ = mapping_key_file;
		_tmp7_ = self->priv->mapping_file;
		_tmp8_ = g_file_get_path (_tmp7_);
		_tmp9_ = _tmp8_;
		g_key_file_load_from_file (_tmp6_, _tmp9_, G_KEY_FILE_NONE, &_inner_error0_);
		_g_free0 (_tmp9_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_critical ("keyboard-mapping-manager.vala:43: %s", _tmp11_);
		g_signal_emit (self, games_keyboard_mapping_manager_signals[GAMES_KEYBOARD_MAPPING_MANAGER_CHANGED_SIGNAL], 0);
		_g_error_free0 (e);
		_g_key_file_unref0 (mapping_key_file);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_key_file_unref0 (mapping_key_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp12_ = g_type_class_ref (retro_joypad_id_get_type ());
	enumc = (GEnumClass*) _tmp12_;
	_tmp13_ = enumc;
	_tmp14_ = _tmp13_->values;
	_tmp14__length1 = _tmp13_->n_values;
	{
		GEnumValue* id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
		id_collection = _tmp14_;
		id_collection_length1 = _tmp14__length1;
		for (id_it = 0; id_it < id_collection_length1; id_it = id_it + 1) {
			GEnumValue id = {0};
			id = id_collection[id_it];
			{
				gchar* button = NULL;
				GEnumValue _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				_tmp15_ = id;
				_tmp16_ = _tmp15_.value_nick;
				_tmp17_ = g_strdup (_tmp16_);
				button = _tmp17_;
				{
					gint key = 0;
					GKeyFile* _tmp18_;
					const gchar* _tmp19_;
					RetroKeyJoypadMapping* _tmp20_;
					GEnumValue _tmp21_;
					_tmp18_ = mapping_key_file;
					_tmp19_ = button;
					key = g_key_file_get_integer (_tmp18_, GAMES_KEYBOARD_MAPPING_MANAGER_GROUP_NAME, _tmp19_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch1_g_error;
					}
					_tmp20_ = self->priv->_mapping;
					_tmp21_ = id;
					retro_key_joypad_mapping_set_button_key (_tmp20_, (RetroJoypadId) _tmp21_.value, (guint16) key);
				}
				goto __finally1;
				__catch1_g_error:
				{
					GError* e = NULL;
					GError* _tmp22_;
					const gchar* _tmp23_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp22_ = e;
					_tmp23_ = _tmp22_->message;
					g_critical ("keyboard-mapping-manager.vala:58: %s", _tmp23_);
					_g_error_free0 (e);
				}
				__finally1:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (button);
					_g_type_class_unref0 (enumc);
					_g_key_file_unref0 (mapping_key_file);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_g_free0 (button);
			}
		}
	}
	g_signal_emit (self, games_keyboard_mapping_manager_signals[GAMES_KEYBOARD_MAPPING_MANAGER_CHANGED_SIGNAL], 0);
	_g_type_class_unref0 (enumc);
	_g_key_file_unref0 (mapping_key_file);
}

gboolean
games_keyboard_mapping_manager_is_default (GamesKeyboardMappingManager* self)
{
	GFile* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->mapping_file;
	result = !g_file_query_exists (_tmp0_, NULL);
	return result;
}

void
games_keyboard_mapping_manager_save_mapping (GamesKeyboardMappingManager* self,
                                             RetroKeyJoypadMapping* mapping)
{
	gchar* config_dir = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GKeyFile* mapping_key_file = NULL;
	GKeyFile* _tmp2_;
	GEnumClass* enumc = NULL;
	GTypeClass* _tmp3_;
	GEnumClass* _tmp4_;
	GEnumValue* _tmp5_;
	gint _tmp5__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mapping != NULL);
	_tmp0_ = games_application_get_config_dir ();
	config_dir = _tmp0_;
	_tmp1_ = config_dir;
	games_application_try_make_dir (_tmp1_);
	_tmp2_ = g_key_file_new ();
	mapping_key_file = _tmp2_;
	_tmp3_ = g_type_class_ref (retro_joypad_id_get_type ());
	enumc = (GEnumClass*) _tmp3_;
	_tmp4_ = enumc;
	_tmp5_ = _tmp4_->values;
	_tmp5__length1 = _tmp4_->n_values;
	{
		GEnumValue* id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
		id_collection = _tmp5_;
		id_collection_length1 = _tmp5__length1;
		for (id_it = 0; id_it < id_collection_length1; id_it = id_it + 1) {
			GEnumValue id = {0};
			id = id_collection[id_it];
			{
				gchar* button = NULL;
				GEnumValue _tmp6_;
				const gchar* _tmp7_;
				gchar* _tmp8_;
				guint16 key = 0U;
				GEnumValue _tmp9_;
				GKeyFile* _tmp10_;
				const gchar* _tmp11_;
				_tmp6_ = id;
				_tmp7_ = _tmp6_.value_nick;
				_tmp8_ = g_strdup (_tmp7_);
				button = _tmp8_;
				_tmp9_ = id;
				key = retro_key_joypad_mapping_get_button_key (mapping, (RetroJoypadId) _tmp9_.value);
				_tmp10_ = mapping_key_file;
				_tmp11_ = button;
				g_key_file_set_integer (_tmp10_, GAMES_KEYBOARD_MAPPING_MANAGER_GROUP_NAME, _tmp11_, (gint) key);
				_g_free0 (button);
			}
		}
	}
	{
		GKeyFile* _tmp12_;
		GFile* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp12_ = mapping_key_file;
		_tmp13_ = self->priv->mapping_file;
		_tmp14_ = g_file_get_path (_tmp13_);
		_tmp15_ = _tmp14_;
		g_key_file_save_to_file (_tmp12_, _tmp15_, &_inner_error0_);
		_g_free0 (_tmp15_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_critical ("keyboard-mapping-manager.vala:86: %s", _tmp17_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_type_class_unref0 (enumc);
		_g_key_file_unref0 (mapping_key_file);
		_g_free0 (config_dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_type_class_unref0 (enumc);
	_g_key_file_unref0 (mapping_key_file);
	_g_free0 (config_dir);
}

void
games_keyboard_mapping_manager_delete_mapping (GamesKeyboardMappingManager* self)
{
	GFile* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mapping_file;
	if (!g_file_query_exists (_tmp0_, NULL)) {
		return;
	}
	{
		GFile* _tmp1_;
		_tmp1_ = self->priv->mapping_file;
		g_file_delete (_tmp1_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_critical ("keyboard-mapping-manager.vala:98: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

GamesKeyboardMappingManager*
games_keyboard_mapping_manager_construct (GType object_type)
{
	GamesKeyboardMappingManager * self = NULL;
	self = (GamesKeyboardMappingManager*) g_object_new (object_type, NULL);
	return self;
}

GamesKeyboardMappingManager*
games_keyboard_mapping_manager_new (void)
{
	return games_keyboard_mapping_manager_construct (GAMES_TYPE_KEYBOARD_MAPPING_MANAGER);
}

RetroKeyJoypadMapping*
games_keyboard_mapping_manager_get_mapping (GamesKeyboardMappingManager* self)
{
	RetroKeyJoypadMapping* result;
	RetroKeyJoypadMapping* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_mapping;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
games_keyboard_mapping_manager_set_mapping (GamesKeyboardMappingManager* self,
                                            RetroKeyJoypadMapping* value)
{
	RetroKeyJoypadMapping* old_value;
	g_return_if_fail (self != NULL);
	old_value = games_keyboard_mapping_manager_get_mapping (self);
	if (old_value != value) {
		RetroKeyJoypadMapping* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_mapping);
		self->priv->_mapping = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, games_keyboard_mapping_manager_properties[GAMES_KEYBOARD_MAPPING_MANAGER_MAPPING_PROPERTY]);
	}
}

static void
_games_keyboard_mapping_manager_load_mapping_g_file_monitor_changed (GFileMonitor* _sender,
                                                                     GFile* file,
                                                                     GFile* other_file,
                                                                     GFileMonitorEvent event_type,
                                                                     gpointer self)
{
	games_keyboard_mapping_manager_load_mapping ((GamesKeyboardMappingManager*) self);
}

static GObject *
games_keyboard_mapping_manager_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GamesKeyboardMappingManager * self;
	gchar* config_dir = NULL;
	gchar* _tmp0_;
	gchar* path = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (games_keyboard_mapping_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_KEYBOARD_MAPPING_MANAGER, GamesKeyboardMappingManager);
	_tmp0_ = games_application_get_config_dir ();
	config_dir = _tmp0_;
	_tmp1_ = config_dir;
	_tmp2_ = g_build_filename (_tmp1_, GAMES_KEYBOARD_MAPPING_MANAGER_MAPPING_FILE_NAME, NULL);
	path = _tmp2_;
	_tmp3_ = path;
	_tmp4_ = g_file_new_for_path (_tmp3_);
	_g_object_unref0 (self->priv->mapping_file);
	self->priv->mapping_file = _tmp4_;
	{
		GFileMonitor* _tmp5_ = NULL;
		GFile* _tmp6_;
		GFileMonitor* _tmp7_;
		GFileMonitor* _tmp8_;
		GFileMonitor* _tmp9_;
		_tmp6_ = self->priv->mapping_file;
		_tmp7_ = g_file_monitor (_tmp6_, G_FILE_MONITOR_NONE, NULL, &_inner_error0_);
		_tmp5_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp8_ = _tmp5_;
		_tmp5_ = NULL;
		_g_object_unref0 (self->priv->mapping_monitor);
		self->priv->mapping_monitor = _tmp8_;
		_tmp9_ = self->priv->mapping_monitor;
		g_signal_connect_object (_tmp9_, "changed", (GCallback) _games_keyboard_mapping_manager_load_mapping_g_file_monitor_changed, self, 0);
		_g_object_unref0 (_tmp5_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_critical ("keyboard-mapping-manager.vala:22: %s", _tmp11_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (path);
		_g_free0 (config_dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	games_keyboard_mapping_manager_load_mapping (self);
	_g_free0 (path);
	_g_free0 (config_dir);
	return obj;
}

static void
games_keyboard_mapping_manager_class_init (GamesKeyboardMappingManagerClass * klass,
                                           gpointer klass_data)
{
	games_keyboard_mapping_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesKeyboardMappingManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_games_keyboard_mapping_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_games_keyboard_mapping_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = games_keyboard_mapping_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = games_keyboard_mapping_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_KEYBOARD_MAPPING_MANAGER_MAPPING_PROPERTY, games_keyboard_mapping_manager_properties[GAMES_KEYBOARD_MAPPING_MANAGER_MAPPING_PROPERTY] = g_param_spec_object ("mapping", "mapping", "mapping", retro_key_joypad_mapping_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	games_keyboard_mapping_manager_signals[GAMES_KEYBOARD_MAPPING_MANAGER_CHANGED_SIGNAL] = g_signal_new ("changed", GAMES_TYPE_KEYBOARD_MAPPING_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
games_keyboard_mapping_manager_instance_init (GamesKeyboardMappingManager * self,
                                              gpointer klass)
{
	self->priv = games_keyboard_mapping_manager_get_instance_private (self);
}

static void
games_keyboard_mapping_manager_finalize (GObject * obj)
{
	GamesKeyboardMappingManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_KEYBOARD_MAPPING_MANAGER, GamesKeyboardMappingManager);
	_g_object_unref0 (self->priv->_mapping);
	_g_object_unref0 (self->priv->mapping_file);
	_g_object_unref0 (self->priv->mapping_monitor);
	G_OBJECT_CLASS (games_keyboard_mapping_manager_parent_class)->finalize (obj);
}

static GType
games_keyboard_mapping_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesKeyboardMappingManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_keyboard_mapping_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesKeyboardMappingManager), 0, (GInstanceInitFunc) games_keyboard_mapping_manager_instance_init, NULL };
	GType games_keyboard_mapping_manager_type_id;
	games_keyboard_mapping_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesKeyboardMappingManager", &g_define_type_info, 0);
	GamesKeyboardMappingManager_private_offset = g_type_add_instance_private (games_keyboard_mapping_manager_type_id, sizeof (GamesKeyboardMappingManagerPrivate));
	return games_keyboard_mapping_manager_type_id;
}

GType
games_keyboard_mapping_manager_get_type (void)
{
	static volatile gsize games_keyboard_mapping_manager_type_id__once = 0;
	if (g_once_init_enter (&games_keyboard_mapping_manager_type_id__once)) {
		GType games_keyboard_mapping_manager_type_id;
		games_keyboard_mapping_manager_type_id = games_keyboard_mapping_manager_get_type_once ();
		g_once_init_leave (&games_keyboard_mapping_manager_type_id__once, games_keyboard_mapping_manager_type_id);
	}
	return games_keyboard_mapping_manager_type_id__once;
}

static void
_vala_games_keyboard_mapping_manager_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec)
{
	GamesKeyboardMappingManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_KEYBOARD_MAPPING_MANAGER, GamesKeyboardMappingManager);
	switch (property_id) {
		case GAMES_KEYBOARD_MAPPING_MANAGER_MAPPING_PROPERTY:
		g_value_set_object (value, games_keyboard_mapping_manager_get_mapping (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_games_keyboard_mapping_manager_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec)
{
	GamesKeyboardMappingManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_KEYBOARD_MAPPING_MANAGER, GamesKeyboardMappingManager);
	switch (property_id) {
		case GAMES_KEYBOARD_MAPPING_MANAGER_MAPPING_PROPERTY:
		games_keyboard_mapping_manager_set_mapping (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

