/* logger.c generated by valac 0.56.18, the Vala compiler
 * generated from logger.vala, do not modify */

/*///////////////////////////////////////////////////////////////////////*/
/* Copyright 2011-2021 Simon Schneegans*/
/**/
/* Permission is hereby granted, free of charge, to any person obtaining*/
/* a copy of this software and associated documentation files (the*/
/* "Software"), to deal in the Software without restriction, including*/
/* without limitation the rights to use, copy, modify, merge, publish,*/
/* distribute, sublicense, and/or sell copies of the Software, and to*/
/* permit persons to whom the Software is furnished to do so, subject to*/
/* the following conditions:*/
/* */
/* The above copyright notice and this permission notice shall be*/
/* included in all copies or substantial portions of the Software.*/
/* */
/* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,*/
/* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF*/
/* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.*/
/* IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY*/
/* CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,*/
/* TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE*/
/* SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.*/
/*///////////////////////////////////////////////////////////////////////*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>

#define GNOME_PIE_LOGGER_display_debug TRUE
#define GNOME_PIE_LOGGER_display_warning TRUE
#define GNOME_PIE_LOGGER_display_error TRUE
#define GNOME_PIE_LOGGER_display_message TRUE
#define GNOME_PIE_LOGGER_log_debug FALSE
#define GNOME_PIE_LOGGER_log_warning TRUE
#define GNOME_PIE_LOGGER_log_error TRUE
#define GNOME_PIE_LOGGER_log_message TRUE
#define GNOME_PIE_LOGGER_display_time FALSE
#define GNOME_PIE_LOGGER_log_time TRUE
#define GNOME_PIE_LOGGER_display_file FALSE
#define GNOME_PIE_LOGGER_log_file FALSE
#define GNOME_PIE_LOGGER_max_log_length 1000000
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GNOME_PIE_TYPE_LOGGER (gnome_pie_logger_get_type ())
#define GNOME_PIE_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_PIE_TYPE_LOGGER, GnomePieLogger))
#define GNOME_PIE_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_PIE_TYPE_LOGGER, GnomePieLoggerClass))
#define GNOME_PIE_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_PIE_TYPE_LOGGER))
#define GNOME_PIE_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_PIE_TYPE_LOGGER))
#define GNOME_PIE_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_PIE_TYPE_LOGGER, GnomePieLoggerClass))

typedef struct _GnomePieLogger GnomePieLogger;
typedef struct _GnomePieLoggerClass GnomePieLoggerClass;
typedef struct _GnomePieLoggerPrivate GnomePieLoggerPrivate;
typedef enum  {
	GNOME_PIE_LOGGER_COLOR_BLACK,
	GNOME_PIE_LOGGER_COLOR_RED,
	GNOME_PIE_LOGGER_COLOR_GREEN,
	GNOME_PIE_LOGGER_COLOR_YELLOW,
	GNOME_PIE_LOGGER_COLOR_BLUE,
	GNOME_PIE_LOGGER_COLOR_PURPLE,
	GNOME_PIE_LOGGER_COLOR_TURQUOISE,
	GNOME_PIE_LOGGER_COLOR_WHITE
} GnomePieLoggerColor;

#define GNOME_PIE_LOGGER_TYPE_COLOR (gnome_pie_logger_color_get_type ())
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _GnomePieParamSpecLogger GnomePieParamSpecLogger;

struct _GnomePieLogger {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GnomePieLoggerPrivate * priv;
};

struct _GnomePieLoggerClass {
	GTypeClass parent_class;
	void (*finalize) (GnomePieLogger *self);
};

struct _GnomePieParamSpecLogger {
	GParamSpec parent_instance;
};

static gpointer gnome_pie_logger_parent_class = NULL;
static GRegex* gnome_pie_logger_regex;
static GRegex* gnome_pie_logger_regex = NULL;
static gint gnome_pie_logger_log_length;
static gint gnome_pie_logger_log_length = 0;

VALA_EXTERN gpointer gnome_pie_logger_ref (gpointer instance);
VALA_EXTERN void gnome_pie_logger_unref (gpointer instance);
VALA_EXTERN GParamSpec* gnome_pie_param_spec_logger (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
VALA_EXTERN void gnome_pie_value_set_logger (GValue* value,
                                 gpointer v_object);
VALA_EXTERN void gnome_pie_value_take_logger (GValue* value,
                                  gpointer v_object);
VALA_EXTERN gpointer gnome_pie_value_get_logger (const GValue* value);
VALA_EXTERN GType gnome_pie_logger_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GnomePieLogger, gnome_pie_logger_unref)
static GType gnome_pie_logger_color_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
VALA_EXTERN void gnome_pie_logger_init (void);
static void gnome_pie_logger_log_func (const gchar* d,
                                GLogLevelFlags flags,
                                const gchar* text);
static void _gnome_pie_logger_log_func_glog_func (const gchar* log_domain,
                                           GLogLevelFlags log_levels,
                                           const gchar* message,
                                           gpointer self);
static void gnome_pie_logger_write_log_line (const gchar* line);
VALA_EXTERN const gchar* gnome_pie_paths_get_log (void);
static void gnome_pie_logger_message (const gchar* message,
                               const gchar* message_log);
static gchar* gnome_pie_logger_get_time (void);
static gchar* gnome_pie_logger_set_color (GnomePieLoggerColor color,
                                   gboolean bold);
static void gnome_pie_logger_debug (const gchar* message,
                             const gchar* message_log);
static void gnome_pie_logger_warning (const gchar* message,
                               const gchar* message_log);
static void gnome_pie_logger_error (const gchar* message,
                             const gchar* message_log);
static gchar* gnome_pie_logger_reset_color (void);
static gchar* gnome_pie_logger_create_message (const gchar* message);
static gchar* gnome_pie_logger_create_log_message (const gchar* message);
VALA_EXTERN GnomePieLogger* gnome_pie_logger_new (void);
VALA_EXTERN GnomePieLogger* gnome_pie_logger_construct (GType object_type);
static void gnome_pie_logger_finalize (GnomePieLogger * obj);
static GType gnome_pie_logger_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static GType
gnome_pie_logger_color_get_type_once (void)
{
	static const GEnumValue values[] = {{GNOME_PIE_LOGGER_COLOR_BLACK, "GNOME_PIE_LOGGER_COLOR_BLACK", "black"}, {GNOME_PIE_LOGGER_COLOR_RED, "GNOME_PIE_LOGGER_COLOR_RED", "red"}, {GNOME_PIE_LOGGER_COLOR_GREEN, "GNOME_PIE_LOGGER_COLOR_GREEN", "green"}, {GNOME_PIE_LOGGER_COLOR_YELLOW, "GNOME_PIE_LOGGER_COLOR_YELLOW", "yellow"}, {GNOME_PIE_LOGGER_COLOR_BLUE, "GNOME_PIE_LOGGER_COLOR_BLUE", "blue"}, {GNOME_PIE_LOGGER_COLOR_PURPLE, "GNOME_PIE_LOGGER_COLOR_PURPLE", "purple"}, {GNOME_PIE_LOGGER_COLOR_TURQUOISE, "GNOME_PIE_LOGGER_COLOR_TURQUOISE", "turquoise"}, {GNOME_PIE_LOGGER_COLOR_WHITE, "GNOME_PIE_LOGGER_COLOR_WHITE", "white"}, {0, NULL, NULL}};
	GType gnome_pie_logger_color_type_id;
	gnome_pie_logger_color_type_id = g_enum_register_static ("GnomePieLoggerColor", values);
	return gnome_pie_logger_color_type_id;
}

static GType
gnome_pie_logger_color_get_type (void)
{
	static volatile gsize gnome_pie_logger_color_type_id__once = 0;
	if (g_once_init_enter (&gnome_pie_logger_color_type_id__once)) {
		GType gnome_pie_logger_color_type_id;
		gnome_pie_logger_color_type_id = gnome_pie_logger_color_get_type_once ();
		g_once_init_leave (&gnome_pie_logger_color_type_id__once, gnome_pie_logger_color_type_id);
	}
	return gnome_pie_logger_color_type_id__once;
}

static void
_gnome_pie_logger_log_func_glog_func (const gchar* log_domain,
                                      GLogLevelFlags log_levels,
                                      const gchar* message,
                                      gpointer self)
{
	gnome_pie_logger_log_func (log_domain, log_levels, message);
}

void
gnome_pie_logger_init (void)
{
	GError* _inner_error0_ = NULL;
	gnome_pie_logger_log_length = -1;
	{
		GRegex* _tmp0_ = NULL;
		GRegex* _tmp1_;
		GRegex* _tmp2_;
		_tmp1_ = g_regex_new ("(.*)\\.vala(:\\d+): (.*)", 0, 0, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_regex_unref0 (gnome_pie_logger_regex);
		gnome_pie_logger_regex = _tmp2_;
		_g_regex_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_log_set_handler (NULL, G_LOG_LEVEL_MASK, _gnome_pie_logger_log_func_glog_func, NULL);
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static void
gnome_pie_logger_write_log_line (const gchar* line)
{
	FILE* log = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	FILE* _tmp2_;
	FILE* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (line != NULL);
	_tmp0_ = gnome_pie_paths_get_log ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_fopen (_tmp1_, "a");
	log = _tmp2_;
	_tmp3_ = log;
	if (_tmp3_ != NULL) {
		FILE* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		if (gnome_pie_logger_log_length == -1) {
			FILE* _tmp4_;
			_tmp4_ = log;
			gnome_pie_logger_log_length = (gint) ftell (_tmp4_);
		}
		_tmp5_ = log;
		fputs (line, _tmp5_);
		_tmp6_ = strlen (line);
		_tmp7_ = _tmp6_;
		gnome_pie_logger_log_length = gnome_pie_logger_log_length + _tmp7_;
	}
	if (gnome_pie_logger_log_length > GNOME_PIE_LOGGER_max_log_length) {
		gchar* content = NULL;
		gchar* _tmp8_;
		_tmp8_ = g_strdup ("");
		content = _tmp8_;
		{
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_ = NULL;
			gint split_index = 0;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp9_ = gnome_pie_paths_get_log ();
			_tmp10_ = _tmp9_;
			g_file_get_contents (_tmp10_, &_tmp11_, NULL, &_inner_error0_);
			_g_free0 (content);
			content = _tmp11_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch0_g_file_error;
				}
				_g_free0 (content);
				_fclose0 (log);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp12_ = content;
			split_index = string_index_of_char (_tmp12_, (gunichar) '\n', gnome_pie_logger_log_length - ((gint) (GNOME_PIE_LOGGER_max_log_length * 0.9)));
			_tmp13_ = gnome_pie_paths_get_log ();
			_tmp14_ = _tmp13_;
			_tmp15_ = content;
			_tmp16_ = string_substring (_tmp15_, (glong) (split_index + 1), (glong) -1);
			_tmp17_ = _tmp16_;
			g_file_set_contents (_tmp14_, _tmp17_, (gssize) -1, &_inner_error0_);
			_g_free0 (_tmp17_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch0_g_file_error;
				}
				_g_free0 (content);
				_fclose0 (log);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			gnome_pie_logger_log_length = gnome_pie_logger_log_length - (split_index + 1);
		}
		goto __finally0;
		__catch0_g_file_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (content);
			_fclose0 (log);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_free0 (content);
	}
	_fclose0 (log);
}

static void
gnome_pie_logger_message (const gchar* message,
                          const gchar* message_log)
{
	g_return_if_fail (message != NULL);
	g_return_if_fail (message_log != NULL);
	if (GNOME_PIE_LOGGER_display_message) {
		gchar* _tmp0_ = NULL;
		FILE* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		if (GNOME_PIE_LOGGER_display_time) {
			gchar* _tmp1_;
			gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp1_ = gnome_pie_logger_get_time ();
			_tmp2_ = _tmp1_;
			_tmp3_ = g_strconcat (_tmp2_, " ", NULL);
			_g_free0 (_tmp0_);
			_tmp0_ = _tmp3_;
			_g_free0 (_tmp2_);
		} else {
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("");
			_g_free0 (_tmp0_);
			_tmp0_ = _tmp4_;
		}
		_tmp5_ = stdout;
		_tmp6_ = gnome_pie_logger_set_color (GNOME_PIE_LOGGER_COLOR_GREEN, FALSE);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat (_tmp7_, "[", NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat (_tmp9_, _tmp0_, NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strconcat (_tmp11_, "MESSAGE]", NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat (_tmp13_, message, NULL);
		_tmp15_ = _tmp14_;
		fprintf (_tmp5_, "%s", _tmp15_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
		_g_free0 (_tmp0_);
	}
	if (GNOME_PIE_LOGGER_log_message) {
		gchar* _tmp16_ = NULL;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		if (GNOME_PIE_LOGGER_log_time) {
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp17_ = gnome_pie_logger_get_time ();
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strconcat (_tmp18_, " ", NULL);
			_g_free0 (_tmp16_);
			_tmp16_ = _tmp19_;
			_g_free0 (_tmp18_);
		} else {
			gchar* _tmp20_;
			_tmp20_ = g_strdup ("");
			_g_free0 (_tmp16_);
			_tmp16_ = _tmp20_;
		}
		_tmp21_ = g_strconcat ("[", _tmp16_, NULL);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strconcat (_tmp22_, "MESSAGE]", NULL);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_strconcat (_tmp24_, message_log, NULL);
		_tmp26_ = _tmp25_;
		gnome_pie_logger_write_log_line (_tmp26_);
		_g_free0 (_tmp26_);
		_g_free0 (_tmp24_);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp16_);
	}
}

static void
gnome_pie_logger_debug (const gchar* message,
                        const gchar* message_log)
{
	g_return_if_fail (message != NULL);
	g_return_if_fail (message_log != NULL);
	if (GNOME_PIE_LOGGER_display_debug) {
		gchar* _tmp0_ = NULL;
		FILE* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		if (GNOME_PIE_LOGGER_display_time) {
			gchar* _tmp1_;
			gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp1_ = gnome_pie_logger_get_time ();
			_tmp2_ = _tmp1_;
			_tmp3_ = g_strconcat (_tmp2_, " ", NULL);
			_g_free0 (_tmp0_);
			_tmp0_ = _tmp3_;
			_g_free0 (_tmp2_);
		} else {
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("");
			_g_free0 (_tmp0_);
			_tmp0_ = _tmp4_;
		}
		_tmp5_ = stdout;
		_tmp6_ = gnome_pie_logger_set_color (GNOME_PIE_LOGGER_COLOR_BLUE, FALSE);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat (_tmp7_, "[", NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat (_tmp9_, _tmp0_, NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strconcat (_tmp11_, " DEBUG ]", NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat (_tmp13_, message, NULL);
		_tmp15_ = _tmp14_;
		fprintf (_tmp5_, "%s", _tmp15_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
		_g_free0 (_tmp0_);
	}
	if (GNOME_PIE_LOGGER_log_debug) {
		gchar* _tmp16_ = NULL;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		if (GNOME_PIE_LOGGER_log_time) {
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp17_ = gnome_pie_logger_get_time ();
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strconcat (_tmp18_, " ", NULL);
			_g_free0 (_tmp16_);
			_tmp16_ = _tmp19_;
			_g_free0 (_tmp18_);
		} else {
			gchar* _tmp20_;
			_tmp20_ = g_strdup ("");
			_g_free0 (_tmp16_);
			_tmp16_ = _tmp20_;
		}
		_tmp21_ = g_strconcat ("[", _tmp16_, NULL);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strconcat (_tmp22_, " DEBUG ]", NULL);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_strconcat (_tmp24_, message_log, NULL);
		_tmp26_ = _tmp25_;
		gnome_pie_logger_write_log_line (_tmp26_);
		_g_free0 (_tmp26_);
		_g_free0 (_tmp24_);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp16_);
	}
}

static void
gnome_pie_logger_warning (const gchar* message,
                          const gchar* message_log)
{
	g_return_if_fail (message != NULL);
	g_return_if_fail (message_log != NULL);
	if (GNOME_PIE_LOGGER_display_warning) {
		gchar* _tmp0_ = NULL;
		FILE* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		if (GNOME_PIE_LOGGER_display_time) {
			gchar* _tmp1_;
			gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp1_ = gnome_pie_logger_get_time ();
			_tmp2_ = _tmp1_;
			_tmp3_ = g_strconcat (_tmp2_, " ", NULL);
			_g_free0 (_tmp0_);
			_tmp0_ = _tmp3_;
			_g_free0 (_tmp2_);
		} else {
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("");
			_g_free0 (_tmp0_);
			_tmp0_ = _tmp4_;
		}
		_tmp5_ = stdout;
		_tmp6_ = gnome_pie_logger_set_color (GNOME_PIE_LOGGER_COLOR_YELLOW, FALSE);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat (_tmp7_, "[", NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat (_tmp9_, _tmp0_, NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strconcat (_tmp11_, "WARNING]", NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat (_tmp13_, message, NULL);
		_tmp15_ = _tmp14_;
		fprintf (_tmp5_, "%s", _tmp15_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
		_g_free0 (_tmp0_);
	}
	if (GNOME_PIE_LOGGER_log_warning) {
		gchar* _tmp16_ = NULL;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		if (GNOME_PIE_LOGGER_log_time) {
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp17_ = gnome_pie_logger_get_time ();
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strconcat (_tmp18_, " ", NULL);
			_g_free0 (_tmp16_);
			_tmp16_ = _tmp19_;
			_g_free0 (_tmp18_);
		} else {
			gchar* _tmp20_;
			_tmp20_ = g_strdup ("");
			_g_free0 (_tmp16_);
			_tmp16_ = _tmp20_;
		}
		_tmp21_ = g_strconcat ("[", _tmp16_, NULL);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strconcat (_tmp22_, "WARNING]", NULL);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_strconcat (_tmp24_, message_log, NULL);
		_tmp26_ = _tmp25_;
		gnome_pie_logger_write_log_line (_tmp26_);
		_g_free0 (_tmp26_);
		_g_free0 (_tmp24_);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp16_);
	}
}

static void
gnome_pie_logger_error (const gchar* message,
                        const gchar* message_log)
{
	g_return_if_fail (message != NULL);
	g_return_if_fail (message_log != NULL);
	if (GNOME_PIE_LOGGER_display_error) {
		gchar* _tmp0_ = NULL;
		FILE* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		if (GNOME_PIE_LOGGER_display_time) {
			gchar* _tmp1_;
			gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp1_ = gnome_pie_logger_get_time ();
			_tmp2_ = _tmp1_;
			_tmp3_ = g_strconcat (_tmp2_, " ", NULL);
			_g_free0 (_tmp0_);
			_tmp0_ = _tmp3_;
			_g_free0 (_tmp2_);
		} else {
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("");
			_g_free0 (_tmp0_);
			_tmp0_ = _tmp4_;
		}
		_tmp5_ = stdout;
		_tmp6_ = gnome_pie_logger_set_color (GNOME_PIE_LOGGER_COLOR_RED, FALSE);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat (_tmp7_, "[", NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat (_tmp9_, _tmp0_, NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strconcat (_tmp11_, " ERROR ]", NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat (_tmp13_, message, NULL);
		_tmp15_ = _tmp14_;
		fprintf (_tmp5_, "%s", _tmp15_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
		_g_free0 (_tmp0_);
	}
	if (GNOME_PIE_LOGGER_log_error) {
		gchar* _tmp16_ = NULL;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		if (GNOME_PIE_LOGGER_log_time) {
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp17_ = gnome_pie_logger_get_time ();
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strconcat (_tmp18_, " ", NULL);
			_g_free0 (_tmp16_);
			_tmp16_ = _tmp19_;
			_g_free0 (_tmp18_);
		} else {
			gchar* _tmp20_;
			_tmp20_ = g_strdup ("");
			_g_free0 (_tmp16_);
			_tmp16_ = _tmp20_;
		}
		_tmp21_ = g_strconcat ("[", _tmp16_, NULL);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strconcat (_tmp22_, " ERROR ]", NULL);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_strconcat (_tmp24_, message_log, NULL);
		_tmp26_ = _tmp25_;
		gnome_pie_logger_write_log_line (_tmp26_);
		_g_free0 (_tmp26_);
		_g_free0 (_tmp24_);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp16_);
	}
}

static gchar*
gnome_pie_logger_reset_color (void)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_strdup ("\x001b[0m");
	result = _tmp0_;
	return result;
}

static gchar*
gnome_pie_logger_set_color (GnomePieLoggerColor color,
                            gboolean bold)
{
	gchar* result;
	if (bold) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup_printf ("\x001b[1;%dm", ((gint) color) + 30);
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup_printf ("\x001b[0;%dm", ((gint) color) + 30);
		result = _tmp1_;
		return result;
	}
}

static gchar*
gnome_pie_logger_get_time (void)
{
	GDateTime* now = NULL;
	GDateTime* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	_tmp0_ = g_date_time_new_now_local ();
	now = _tmp0_;
	_tmp1_ = g_strdup_printf ("%.4d:%.2d:%.2d:%.2d:%.2d:%.2d:%.6d", g_date_time_get_year (now), g_date_time_get_month (now), g_date_time_get_day_of_month (now), g_date_time_get_hour (now), g_date_time_get_minute (now), g_date_time_get_second (now), g_date_time_get_microsecond (now));
	result = _tmp1_;
	_g_date_time_unref0 (now);
	return result;
}

static gchar*
gnome_pie_logger_create_message (const gchar* message)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gchar* result;
	g_return_val_if_fail (message != NULL, NULL);
	if (GNOME_PIE_LOGGER_display_file) {
		GRegex* _tmp2_;
		_tmp2_ = gnome_pie_logger_regex;
		_tmp1_ = _tmp2_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GRegex* _tmp3_;
		_tmp3_ = gnome_pie_logger_regex;
		_tmp0_ = g_regex_match (_tmp3_, message, 0, NULL);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar** parts = NULL;
		GRegex* _tmp4_;
		gchar** _tmp5_;
		gchar** _tmp6_;
		gint parts_length1;
		gint _parts_size_;
		gchar** _tmp7_;
		gint _tmp7__length1;
		const gchar* _tmp8_;
		gchar** _tmp9_;
		gint _tmp9__length1;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar** _tmp13_;
		gint _tmp13__length1;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp4_ = gnome_pie_logger_regex;
		_tmp6_ = _tmp5_ = g_regex_split (_tmp4_, message, 0);
		parts = _tmp6_;
		parts_length1 = _vala_array_length (_tmp5_);
		_parts_size_ = parts_length1;
		_tmp7_ = parts;
		_tmp7__length1 = parts_length1;
		_tmp8_ = _tmp7_[1];
		_tmp9_ = parts;
		_tmp9__length1 = parts_length1;
		_tmp10_ = _tmp9_[2];
		_tmp11_ = gnome_pie_logger_reset_color ();
		_tmp12_ = _tmp11_;
		_tmp13_ = parts;
		_tmp13__length1 = parts_length1;
		_tmp14_ = _tmp13_[3];
		_tmp15_ = g_strdup_printf (" [%s%s]%s %s\n", _tmp8_, _tmp10_, _tmp12_, _tmp14_);
		_tmp16_ = _tmp15_;
		_g_free0 (_tmp12_);
		result = _tmp16_;
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		return result;
	} else {
		gboolean _tmp17_ = FALSE;
		GRegex* _tmp18_;
		_tmp18_ = gnome_pie_logger_regex;
		if (_tmp18_ != NULL) {
			GRegex* _tmp19_;
			_tmp19_ = gnome_pie_logger_regex;
			_tmp17_ = g_regex_match (_tmp19_, message, 0, NULL);
		} else {
			_tmp17_ = FALSE;
		}
		if (_tmp17_) {
			gchar** parts = NULL;
			GRegex* _tmp20_;
			gchar** _tmp21_;
			gchar** _tmp22_;
			gint parts_length1;
			gint _parts_size_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar** _tmp25_;
			gint _tmp25__length1;
			const gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			_tmp20_ = gnome_pie_logger_regex;
			_tmp22_ = _tmp21_ = g_regex_split (_tmp20_, message, 0);
			parts = _tmp22_;
			parts_length1 = _vala_array_length (_tmp21_);
			_parts_size_ = parts_length1;
			_tmp23_ = gnome_pie_logger_reset_color ();
			_tmp24_ = _tmp23_;
			_tmp25_ = parts;
			_tmp25__length1 = parts_length1;
			_tmp26_ = _tmp25_[3];
			_tmp27_ = g_strdup_printf ("%s %s\n", _tmp24_, _tmp26_);
			_tmp28_ = _tmp27_;
			_g_free0 (_tmp24_);
			result = _tmp28_;
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			return result;
		} else {
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			_tmp29_ = gnome_pie_logger_reset_color ();
			_tmp30_ = _tmp29_;
			_tmp31_ = g_strconcat (_tmp30_, " ", NULL);
			_tmp32_ = _tmp31_;
			_tmp33_ = g_strconcat (_tmp32_, message, NULL);
			_tmp34_ = _tmp33_;
			_tmp35_ = g_strconcat (_tmp34_, "\n", NULL);
			_tmp36_ = _tmp35_;
			_g_free0 (_tmp34_);
			_g_free0 (_tmp32_);
			_g_free0 (_tmp30_);
			result = _tmp36_;
			return result;
		}
	}
}

static gchar*
gnome_pie_logger_create_log_message (const gchar* message)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gchar* result;
	g_return_val_if_fail (message != NULL, NULL);
	if (GNOME_PIE_LOGGER_log_file) {
		GRegex* _tmp2_;
		_tmp2_ = gnome_pie_logger_regex;
		_tmp1_ = _tmp2_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GRegex* _tmp3_;
		_tmp3_ = gnome_pie_logger_regex;
		_tmp0_ = g_regex_match (_tmp3_, message, 0, NULL);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar** parts = NULL;
		GRegex* _tmp4_;
		gchar** _tmp5_;
		gchar** _tmp6_;
		gint parts_length1;
		gint _parts_size_;
		gchar** _tmp7_;
		gint _tmp7__length1;
		const gchar* _tmp8_;
		gchar** _tmp9_;
		gint _tmp9__length1;
		const gchar* _tmp10_;
		gchar** _tmp11_;
		gint _tmp11__length1;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp4_ = gnome_pie_logger_regex;
		_tmp6_ = _tmp5_ = g_regex_split (_tmp4_, message, 0);
		parts = _tmp6_;
		parts_length1 = _vala_array_length (_tmp5_);
		_parts_size_ = parts_length1;
		_tmp7_ = parts;
		_tmp7__length1 = parts_length1;
		_tmp8_ = _tmp7_[1];
		_tmp9_ = parts;
		_tmp9__length1 = parts_length1;
		_tmp10_ = _tmp9_[2];
		_tmp11_ = parts;
		_tmp11__length1 = parts_length1;
		_tmp12_ = _tmp11_[3];
		_tmp13_ = g_strdup_printf (" [%s%s] %s\n", _tmp8_, _tmp10_, _tmp12_);
		result = _tmp13_;
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		return result;
	} else {
		gboolean _tmp14_ = FALSE;
		GRegex* _tmp15_;
		_tmp15_ = gnome_pie_logger_regex;
		if (_tmp15_ != NULL) {
			GRegex* _tmp16_;
			_tmp16_ = gnome_pie_logger_regex;
			_tmp14_ = g_regex_match (_tmp16_, message, 0, NULL);
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			gchar** parts = NULL;
			GRegex* _tmp17_;
			gchar** _tmp18_;
			gchar** _tmp19_;
			gint parts_length1;
			gint _parts_size_;
			gchar** _tmp20_;
			gint _tmp20__length1;
			const gchar* _tmp21_;
			gchar* _tmp22_;
			_tmp17_ = gnome_pie_logger_regex;
			_tmp19_ = _tmp18_ = g_regex_split (_tmp17_, message, 0);
			parts = _tmp19_;
			parts_length1 = _vala_array_length (_tmp18_);
			_parts_size_ = parts_length1;
			_tmp20_ = parts;
			_tmp20__length1 = parts_length1;
			_tmp21_ = _tmp20_[3];
			_tmp22_ = g_strdup_printf (" %s\n", _tmp21_);
			result = _tmp22_;
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			return result;
		} else {
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp23_ = g_strconcat (" ", message, NULL);
			_tmp24_ = _tmp23_;
			_tmp25_ = g_strconcat (_tmp24_, "\n", NULL);
			_tmp26_ = _tmp25_;
			_g_free0 (_tmp24_);
			result = _tmp26_;
			return result;
		}
	}
}

static void
gnome_pie_logger_log_func (const gchar* d,
                           GLogLevelFlags flags,
                           const gchar* text)
{
	g_return_if_fail (text != NULL);
	switch (flags) {
		case G_LOG_LEVEL_ERROR:
		case G_LOG_LEVEL_CRITICAL:
		{
			gchar* _tmp0_;
			gchar* _tmp1_;
			gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp0_ = gnome_pie_logger_create_message (text);
			_tmp1_ = _tmp0_;
			_tmp2_ = gnome_pie_logger_create_log_message (text);
			_tmp3_ = _tmp2_;
			gnome_pie_logger_error (_tmp1_, _tmp3_);
			_g_free0 (_tmp3_);
			_g_free0 (_tmp1_);
			break;
		}
		case G_LOG_LEVEL_INFO:
		case G_LOG_LEVEL_MESSAGE:
		{
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp4_ = gnome_pie_logger_create_message (text);
			_tmp5_ = _tmp4_;
			_tmp6_ = gnome_pie_logger_create_log_message (text);
			_tmp7_ = _tmp6_;
			gnome_pie_logger_message (_tmp5_, _tmp7_);
			_g_free0 (_tmp7_);
			_g_free0 (_tmp5_);
			break;
		}
		case G_LOG_LEVEL_DEBUG:
		{
			gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp8_ = gnome_pie_logger_create_message (text);
			_tmp9_ = _tmp8_;
			_tmp10_ = gnome_pie_logger_create_log_message (text);
			_tmp11_ = _tmp10_;
			gnome_pie_logger_debug (_tmp9_, _tmp11_);
			_g_free0 (_tmp11_);
			_g_free0 (_tmp9_);
			break;
		}
		default:
		case G_LOG_LEVEL_WARNING:
		{
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp12_ = gnome_pie_logger_create_message (text);
			_tmp13_ = _tmp12_;
			_tmp14_ = gnome_pie_logger_create_log_message (text);
			_tmp15_ = _tmp14_;
			gnome_pie_logger_warning (_tmp13_, _tmp15_);
			_g_free0 (_tmp15_);
			_g_free0 (_tmp13_);
			break;
		}
	}
}

GnomePieLogger*
gnome_pie_logger_construct (GType object_type)
{
	GnomePieLogger* self = NULL;
	self = (GnomePieLogger*) g_type_create_instance (object_type);
	return self;
}

GnomePieLogger*
gnome_pie_logger_new (void)
{
	return gnome_pie_logger_construct (GNOME_PIE_TYPE_LOGGER);
}

static void
gnome_pie_value_logger_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gnome_pie_value_logger_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gnome_pie_logger_unref (value->data[0].v_pointer);
	}
}

static void
gnome_pie_value_logger_copy_value (const GValue* src_value,
                                   GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gnome_pie_logger_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gnome_pie_value_logger_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gnome_pie_value_logger_collect_value (GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GnomePieLogger * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gnome_pie_logger_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gnome_pie_value_logger_lcopy_value (const GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	GnomePieLogger ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gnome_pie_logger_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
gnome_pie_param_spec_logger (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags)
{
	GnomePieParamSpecLogger* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GNOME_PIE_TYPE_LOGGER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
gnome_pie_value_get_logger (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GNOME_PIE_TYPE_LOGGER), NULL);
	return value->data[0].v_pointer;
}

void
gnome_pie_value_set_logger (GValue* value,
                            gpointer v_object)
{
	GnomePieLogger * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GNOME_PIE_TYPE_LOGGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GNOME_PIE_TYPE_LOGGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gnome_pie_logger_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gnome_pie_logger_unref (old);
	}
}

void
gnome_pie_value_take_logger (GValue* value,
                             gpointer v_object)
{
	GnomePieLogger * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GNOME_PIE_TYPE_LOGGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GNOME_PIE_TYPE_LOGGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gnome_pie_logger_unref (old);
	}
}

static void
gnome_pie_logger_class_init (GnomePieLoggerClass * klass,
                             gpointer klass_data)
{
	gnome_pie_logger_parent_class = g_type_class_peek_parent (klass);
	((GnomePieLoggerClass *) klass)->finalize = gnome_pie_logger_finalize;
}

static void
gnome_pie_logger_instance_init (GnomePieLogger * self,
                                gpointer klass)
{
	self->ref_count = 1;
}

static void
gnome_pie_logger_finalize (GnomePieLogger * obj)
{
	GnomePieLogger * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GNOME_PIE_TYPE_LOGGER, GnomePieLogger);
	g_signal_handlers_destroy (self);
}

static GType
gnome_pie_logger_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { gnome_pie_value_logger_init, gnome_pie_value_logger_free_value, gnome_pie_value_logger_copy_value, gnome_pie_value_logger_peek_pointer, "p", gnome_pie_value_logger_collect_value, "p", gnome_pie_value_logger_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GnomePieLoggerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_pie_logger_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomePieLogger), 0, (GInstanceInitFunc) gnome_pie_logger_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType gnome_pie_logger_type_id;
	gnome_pie_logger_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GnomePieLogger", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return gnome_pie_logger_type_id;
}

GType
gnome_pie_logger_get_type (void)
{
	static volatile gsize gnome_pie_logger_type_id__once = 0;
	if (g_once_init_enter (&gnome_pie_logger_type_id__once)) {
		GType gnome_pie_logger_type_id;
		gnome_pie_logger_type_id = gnome_pie_logger_get_type_once ();
		g_once_init_leave (&gnome_pie_logger_type_id__once, gnome_pie_logger_type_id);
	}
	return gnome_pie_logger_type_id__once;
}

gpointer
gnome_pie_logger_ref (gpointer instance)
{
	GnomePieLogger * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
gnome_pie_logger_unref (gpointer instance)
{
	GnomePieLogger * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GNOME_PIE_LOGGER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

