/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_interleave = R"doc(interleave N inputs into a single output

This block interleaves blocks of samples. For each input connection, the samples are interleaved successively to the output connection. By default, the block interleaves a single sample from each input to the output unless blocksize is given in the constructor.

Constructor Specific Documentation:

Make a stream interleave block.

Args:
    itemsize : stream itemsize
    blocksize : size of block of samples to interleave)doc";


static const char* __doc_gr_blocks_interleave_interleave = R"doc()doc";


static const char* __doc_gr_blocks_interleave_make = R"doc(interleave N inputs into a single output

This block interleaves blocks of samples. For each input connection, the samples are interleaved successively to the output connection. By default, the block interleaves a single sample from each input to the output unless blocksize is given in the constructor.

Constructor Specific Documentation:

Make a stream interleave block.

Args:
    itemsize : stream itemsize
    blocksize : size of block of samples to interleave)doc";
