// Copyright Istio Authors
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.10
// 	protoc        (unknown)
// source: networking/v1alpha3/envoy_filter.proto

// $schema: istio.networking.v1alpha3.EnvoyFilter
// $title: Envoy Filter
// $description: Customizing Envoy configuration generated by Istio.
// $location: https://istio.io/docs/reference/config/networking/envoy-filter.html
// $aliases: [/docs/reference/config/networking/v1alpha3/envoy-filter]

// `EnvoyFilter` provides a mechanism to customize the Envoy
// configuration generated by istiod. Use EnvoyFilter to modify
// values for certain fields, add specific filters, or even add
// entirely new listeners, clusters, etc. This feature must be used
// with care, as incorrect configurations could potentially
// destabilize the entire mesh. Unlike other Istio networking objects,
// EnvoyFilters are additively applied. Any number of EnvoyFilters can
// exist for a given workload in a specific namespace. The order of
// application of these EnvoyFilters is as follows: all EnvoyFilters
// in the config [root
// namespace](https://istio.io/docs/reference/config/istio.mesh.v1alpha1/#MeshConfig),
// followed by all matching EnvoyFilters in the workload's namespace.
//
// **NOTE 1**: Some aspects of this API are deeply tied to the internal
// implementation in Istio networking subsystem as well as Envoy's XDS
// API. While the EnvoyFilter API by itself will maintain backward
// compatibility, any envoy configuration provided through this
// mechanism should be carefully monitored across Istio proxy version
// upgrades, to ensure that deprecated fields are removed and replaced
// appropriately.
//
// **NOTE 2**: When multiple EnvoyFilters are bound to the same
// workload in a given namespace, all patches will be processed
// sequentially in order of creation time.  The behavior is undefined
// if multiple EnvoyFilter configurations conflict with each other.
//
// **NOTE 3**: To apply an EnvoyFilter resource to all workloads
// (sidecars and gateways) in the system, define the resource in the
// config [root
// namespace](https://istio.io/docs/reference/config/istio.mesh.v1alpha1/#MeshConfig),
// without a workloadSelector.
//
// The example below declares a global default EnvoyFilter resource in
// the root namespace called `istio-config`, that adds a custom
// protocol filter on all sidecars in the system, for outbound port
// 9307. The filter should be added before the terminating tcp_proxy
// filter to take effect. In addition, it sets a 30s idle timeout for
// all HTTP connections in both gateways and sidecars.
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: EnvoyFilter
// metadata:
//   name: custom-protocol
//   namespace: istio-config # as defined in meshConfig resource.
// spec:
//   configPatches:
//   - applyTo: NETWORK_FILTER
//     match:
//       context: SIDECAR_OUTBOUND # will match outbound listeners in all sidecars
//       listener:
//         portNumber: 9307
//         filterChain:
//           filter:
//             name: "envoy.filters.network.tcp_proxy"
//     patch:
//       operation: INSERT_BEFORE
//       value:
//         # This is the full filter config including the name and typed_config section.
//         name: "envoy.extensions.filters.network.mongo_proxy"
//         typed_config:
//           "@type": "type.googleapis.com/envoy.extensions.filters.network.mongo_proxy.v3.MongoProxy"
//           ...
//   - applyTo: NETWORK_FILTER # http connection manager is a filter in Envoy
//     match:
//       # context omitted so that this applies to both sidecars and gateways
//       listener:
//         filterChain:
//           filter:
//             name: "envoy.filters.network.http_connection_manager"
//     patch:
//       operation: MERGE
//       value:
//         name: "envoy.filters.network.http_connection_manager"
//         typed_config:
//           "@type": "type.googleapis.com/envoy.extensions.filters.network.http_connection_manager.v3.HttpConnectionManager"
//           common_http_protocol_options:
//             idle_timeout: 30s
// ```
//
// The following example enables Envoy's Lua filter for all inbound
// HTTP calls arriving at service port 8080 of the reviews service pod
// with labels "app: reviews", in the bookinfo namespace. The lua
// filter calls out to an external service internal.org.net:8888 that
// requires a special cluster definition in envoy. The cluster is also
// added to the sidecar as part of this configuration.
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: EnvoyFilter
// metadata:
//   name: reviews-lua
//   namespace: bookinfo
// spec:
//   workloadSelector:
//     labels:
//       app: reviews
//   configPatches:
//     # The first patch adds the lua filter to the listener/http connection manager
//   - applyTo: HTTP_FILTER
//     match:
//       context: SIDECAR_INBOUND
//       listener:
//         portNumber: 8080
//         filterChain:
//           filter:
//             name: "envoy.filters.network.http_connection_manager"
//             subFilter:
//               name: "envoy.filters.http.router"
//     patch:
//       operation: INSERT_BEFORE
//       value: # lua filter specification
//        name: envoy.filters.http.lua
//        typed_config:
//           "@type": "type.googleapis.com/envoy.extensions.filters.http.lua.v3.Lua"
//           defaultSourceCode:
//             inlineString: |
//               function envoy_on_request(request_handle)
//                 -- Make an HTTP call to an upstream host with the following headers, body, and timeout.
//                 local headers, body = request_handle:httpCall(
//                  "lua_cluster",
//                  {
//                   [":method"] = "POST",
//                   [":path"] = "/acl",
//                   [":authority"] = "internal.org.net"
//                  },
//                 "authorize call",
//                 5000)
//               end
//   # The second patch adds the cluster that is referenced by the lua code
//   # cds match is omitted as a new cluster is being added
//   - applyTo: CLUSTER
//     match:
//       context: SIDECAR_OUTBOUND
//     patch:
//       operation: ADD
//       value: # cluster specification
//         name: "lua_cluster"
//         type: STRICT_DNS
//         connect_timeout: 0.5s
//         lb_policy: ROUND_ROBIN
//         load_assignment:
//           cluster_name: lua_cluster
//           endpoints:
//           - lb_endpoints:
//             - endpoint:
//                 address:
//                   socket_address:
//                     protocol: TCP
//                     address: "internal.org.net"
//                     port_value: 8888
// ```
//
// The following example overwrites certain fields (HTTP idle timeout
// and X-Forward-For trusted hops) in the HTTP connection manager in a
// listener on the ingress gateway in istio-system namespace for the
// SNI host app.example.com:
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: EnvoyFilter
// metadata:
//   name: hcm-tweaks
//   namespace: istio-system
// spec:
//   workloadSelector:
//     labels:
//       istio: ingressgateway
//   configPatches:
//   - applyTo: NETWORK_FILTER # http connection manager is a filter in Envoy
//     match:
//       context: GATEWAY
//       listener:
//         filterChain:
//           sni: app.example.com
//           filter:
//             name: "envoy.filters.network.http_connection_manager"
//     patch:
//       operation: MERGE
//       value:
//         typed_config:
//           "@type": "type.googleapis.com/envoy.extensions.filters.network.http_connection_manager.v3.HttpConnectionManager"
//           xff_num_trusted_hops: 5
//           common_http_protocol_options:
//             idle_timeout: 30s
// ```
//
// The following example inserts an attributegen filter
// that produces `istio_operationId` attribute which is consumed
// by the istio.stats filter. `filterClass: STATS` encodes this dependency.
//
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: EnvoyFilter
// metadata:
//   name: reviews-request-operation
//   namespace: myns
// spec:
//   workloadSelector:
//     labels:
//       app: reviews
//   configPatches:
//   - applyTo: HTTP_FILTER
//     match:
//       context: SIDECAR_INBOUND
//     patch:
//       operation: ADD
//       filterClass: STATS # This filter will run *before* the Istio stats filter.
//       value:
//         name: istio.request_operation
//         typed_config:
//          "@type": type.googleapis.com/udpa.type.v1.TypedStruct
//          type_url: type.googleapis.com/envoy.extensions.filters.http.wasm.v3.Wasm
//          value:
//            config:
//              configuration: |
//                {
//                  "attributes": [
//                    {
//                      "output_attribute": "istio_operationId",
//                      "match": [
//                        {
//                          "value": "ListReviews",
//                          "condition": "request.url_path == '/reviews' && request.method == 'GET'"
//                        }]
//                    }]
//                }
//              vm_config:
//                runtime: envoy.wasm.runtime.null
//                code:
//                  local: { inline_string: "envoy.wasm.attributegen" }
// ```
//
// The following example inserts an http ext_authz filter in the `myns` namespace.
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: EnvoyFilter
// metadata:
//   name: myns-ext-authz
//   namespace: myns
// spec:
//   configPatches:
//   - applyTo: HTTP_FILTER
//     match:
//       context: SIDECAR_INBOUND
//     patch:
//       operation: ADD
//       filterClass: AUTHZ # This filter will run *after* the Istio authz filter.
//       value:
//         name: envoy.filters.http.ext_authz
//         typed_config:
//           "@type": type.googleapis.com/envoy.extensions.filters.http.ext_authz.v3.ExtAuthz
//           grpc_service:
//             envoy_grpc:
//               cluster_name: acme-ext-authz
//             initial_metadata:
//             - key: foo
//               value: myauth.acme # required by local ext auth server.
// ```
//
// A workload in the `myns` namespace needs to access a different ext_auth server
// that does not accept initial metadata. Since proto merge cannot remove fields, the
// following configuration uses the `REPLACE` operation. If you do not need to inherit
// fields, REPLACE is preferred over MERGE.
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: EnvoyFilter
// metadata:
//   name: mysvc-ext-authz
//   namespace: myns
// spec:
//   workloadSelector:
//     labels:
//       app: mysvc
//   configPatches:
//   - applyTo: HTTP_FILTER
//     match:
//       context: SIDECAR_INBOUND
//     patch:
//       operation: REPLACE
//       value:
//         name: envoy.filters.http.ext_authz
//         typed_config:
//           "@type": type.googleapis.com/envoy.extensions.filters.http.ext_authz.v3.ExtAuthz
//           grpc_service:
//             envoy_grpc:
//               cluster_name: acme-ext-authz-alt
// ```
//
// The following example deploys a Wasm extension for all inbound sidecar HTTP requests.
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: EnvoyFilter
// metadata:
//   name: wasm-example
//   namespace: myns
// spec:
//   configPatches:
//   # The first patch defines a named Wasm extension and provides a URL to fetch Wasm binary from,
//   # and the binary configuration. It should come before the next patch that applies it.
//   # This resource is visible to all proxies in the namespace "myns". It is possible to provide
//   # multiple definitions for the same name "my-wasm-extension" in multiple namespaces. We recommend that:
//   # - if overriding is desired, then the root level definition can be overridden per namespace with REPLACE.
//   # - if overriding is not desired, then the name should be qualified with the namespace "myns/my-wasm-extension",
//   #   to avoid accidental name collisions.
//   - applyTo: EXTENSION_CONFIG
//     patch:
//       operation: ADD
//       value:
//         name: my-wasm-extension
//         typed_config:
//           "@type": type.googleapis.com/envoy.extensions.filters.http.wasm.v3.Wasm
//           config:
//             root_id: my-wasm-root-id
//             vm_config:
//               vm_id: my-wasm-vm-id
//               runtime: envoy.wasm.runtime.v8
//               code:
//                 remote:
//                   http_uri:
//                     uri: http://my-wasm-binary-uri
//             configuration:
//               "@type": "type.googleapis.com/google.protobuf.StringValue"
//               value: |
//                 {}
//   # The second patch instructs to apply the above Wasm filter to the listener/http connection manager.
//   - applyTo: HTTP_FILTER
//     match:
//       listener:
//         filterChain:
//           filter:
//             name: envoy.filters.network.http_connection_manager
//             subFilter:
//               name: envoy.filters.http.router
//     patch:
//       operation: INSERT_BEFORE
//       value:
//         name: my-wasm-extension # This must match the name above
//         config_discovery:
//           config_source:
//             ads: {}
//           type_urls: ["type.googleapis.com/envoy.extensions.filters.http.wasm.v3.Wasm"]
// ```
//
// The following example inserts an `envoy.filters.listener.proxy_protocol` listener filter before the `envoy.filters.listener.tls_inspector`.
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: EnvoyFilter
// metadata:
//   name: listener-filter-example
//   namespace: myns
// spec:
//   configPatches:
//   - applyTo: LISTENER_FILTER
//     match:
//       context: SIDECAR_INBOUND # will match inbound listeners in all sidecars
//       listener:
//         portNumber: 15006
//         listenerFilter: "envoy.filters.listener.tls_inspector"
//     patch:
//       operation: INSERT_BEFORE
//       value:
//         # This is the full filter config including the name and typed_config section.
//         name: "envoy.filters.listener.proxy_protocol"
//         typed_config:
//           "@type": "type.googleapis.com/envoy.extensions.filters.listener.proxy_protocol.v3.ProxyProtocol"
// ```
//
// The following example configures ratelimits for the domain `foo.com`.
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: EnvoyFilter
// metadata:
//   name: domain-match-example
//   namespace: myns
// spec:
//   configPatches:
//   - applyTo: VIRTUAL_HOST
//     match:
//       context: GATEWAY
//       routeConfiguration:
//         vhost:
//           domainName: 'foo.com'
//     patch:
//       operation: MERGE
//       value:
//         rate_limits:
//           actions:
//             - request_headers:
//                 header_name: "authorization"
//                 descriptor_key: "jwt"
//             - request_headers:
//                 header_name: ":path"
//                 descriptor_key: "path"

package v1alpha3

import (
	_struct "github.com/golang/protobuf/ptypes/struct"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	v1beta1 "istio.io/api/type/v1beta1"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// `ApplyTo` specifies where in the Envoy configuration, the given patch should be applied.
type EnvoyFilter_ApplyTo int32

const (
	EnvoyFilter_INVALID EnvoyFilter_ApplyTo = 0
	// Applies the patch to the listener.
	EnvoyFilter_LISTENER EnvoyFilter_ApplyTo = 1
	// Applies the patch to the filter chain.
	EnvoyFilter_FILTER_CHAIN EnvoyFilter_ApplyTo = 2
	// Applies the patch to the network filter chain, to modify an
	// existing filter or add a new filter.
	EnvoyFilter_NETWORK_FILTER EnvoyFilter_ApplyTo = 3
	// Applies the patch to the HTTP filter chain in the http
	// connection manager, to modify an existing filter or add a new
	// filter.
	EnvoyFilter_HTTP_FILTER EnvoyFilter_ApplyTo = 4
	// Applies the patch to the Route configuration (rds output)
	// inside a HTTP connection manager. This does not apply to the
	// virtual host. Currently, only `MERGE` operation is allowed on the
	// route configuration objects.
	EnvoyFilter_ROUTE_CONFIGURATION EnvoyFilter_ApplyTo = 5
	// Applies the patch to a virtual host inside a route configuration.
	EnvoyFilter_VIRTUAL_HOST EnvoyFilter_ApplyTo = 6
	// Applies the patch to a route object inside the matched virtual
	// host in a route configuration.
	EnvoyFilter_HTTP_ROUTE EnvoyFilter_ApplyTo = 7
	// Applies the patch to a cluster in a CDS output. Also used to add new clusters.
	EnvoyFilter_CLUSTER EnvoyFilter_ApplyTo = 8
	// Applies the patch to or adds an extension config in ECDS output. Note that ECDS
	// is only supported by HTTP filters.
	EnvoyFilter_EXTENSION_CONFIG EnvoyFilter_ApplyTo = 9
	// DEPRECATED. Applies the patch to bootstrap configuration.
	EnvoyFilter_BOOTSTRAP EnvoyFilter_ApplyTo = 10
	// Applies the patch to the listener filter.
	EnvoyFilter_LISTENER_FILTER EnvoyFilter_ApplyTo = 11
)

// Enum value maps for EnvoyFilter_ApplyTo.
var (
	EnvoyFilter_ApplyTo_name = map[int32]string{
		0:  "INVALID",
		1:  "LISTENER",
		2:  "FILTER_CHAIN",
		3:  "NETWORK_FILTER",
		4:  "HTTP_FILTER",
		5:  "ROUTE_CONFIGURATION",
		6:  "VIRTUAL_HOST",
		7:  "HTTP_ROUTE",
		8:  "CLUSTER",
		9:  "EXTENSION_CONFIG",
		10: "BOOTSTRAP",
		11: "LISTENER_FILTER",
	}
	EnvoyFilter_ApplyTo_value = map[string]int32{
		"INVALID":             0,
		"LISTENER":            1,
		"FILTER_CHAIN":        2,
		"NETWORK_FILTER":      3,
		"HTTP_FILTER":         4,
		"ROUTE_CONFIGURATION": 5,
		"VIRTUAL_HOST":        6,
		"HTTP_ROUTE":          7,
		"CLUSTER":             8,
		"EXTENSION_CONFIG":    9,
		"BOOTSTRAP":           10,
		"LISTENER_FILTER":     11,
	}
)

func (x EnvoyFilter_ApplyTo) Enum() *EnvoyFilter_ApplyTo {
	p := new(EnvoyFilter_ApplyTo)
	*p = x
	return p
}

func (x EnvoyFilter_ApplyTo) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EnvoyFilter_ApplyTo) Descriptor() protoreflect.EnumDescriptor {
	return file_networking_v1alpha3_envoy_filter_proto_enumTypes[0].Descriptor()
}

func (EnvoyFilter_ApplyTo) Type() protoreflect.EnumType {
	return &file_networking_v1alpha3_envoy_filter_proto_enumTypes[0]
}

func (x EnvoyFilter_ApplyTo) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EnvoyFilter_ApplyTo.Descriptor instead.
func (EnvoyFilter_ApplyTo) EnumDescriptor() ([]byte, []int) {
	return file_networking_v1alpha3_envoy_filter_proto_rawDescGZIP(), []int{0, 0}
}

// PatchContext selects a class of configurations based on the
// traffic flow direction and workload type.
type EnvoyFilter_PatchContext int32

const (
	// All listeners/routes/clusters in both sidecars and gateways.
	EnvoyFilter_ANY EnvoyFilter_PatchContext = 0
	// Inbound listener/route/cluster in sidecar.
	EnvoyFilter_SIDECAR_INBOUND EnvoyFilter_PatchContext = 1
	// Outbound listener/route/cluster in sidecar.
	EnvoyFilter_SIDECAR_OUTBOUND EnvoyFilter_PatchContext = 2
	// Gateway listener/route/cluster.
	EnvoyFilter_GATEWAY EnvoyFilter_PatchContext = 3
)

// Enum value maps for EnvoyFilter_PatchContext.
var (
	EnvoyFilter_PatchContext_name = map[int32]string{
		0: "ANY",
		1: "SIDECAR_INBOUND",
		2: "SIDECAR_OUTBOUND",
		3: "GATEWAY",
	}
	EnvoyFilter_PatchContext_value = map[string]int32{
		"ANY":              0,
		"SIDECAR_INBOUND":  1,
		"SIDECAR_OUTBOUND": 2,
		"GATEWAY":          3,
	}
)

func (x EnvoyFilter_PatchContext) Enum() *EnvoyFilter_PatchContext {
	p := new(EnvoyFilter_PatchContext)
	*p = x
	return p
}

func (x EnvoyFilter_PatchContext) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EnvoyFilter_PatchContext) Descriptor() protoreflect.EnumDescriptor {
	return file_networking_v1alpha3_envoy_filter_proto_enumTypes[1].Descriptor()
}

func (EnvoyFilter_PatchContext) Type() protoreflect.EnumType {
	return &file_networking_v1alpha3_envoy_filter_proto_enumTypes[1]
}

func (x EnvoyFilter_PatchContext) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EnvoyFilter_PatchContext.Descriptor instead.
func (EnvoyFilter_PatchContext) EnumDescriptor() ([]byte, []int) {
	return file_networking_v1alpha3_envoy_filter_proto_rawDescGZIP(), []int{0, 1}
}

// Action refers to the route action taken by Envoy when a http route matches.
type EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action int32

const (
	// All three route actions
	EnvoyFilter_RouteConfigurationMatch_RouteMatch_ANY EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action = 0
	// Route traffic to a cluster / weighted clusters.
	EnvoyFilter_RouteConfigurationMatch_RouteMatch_ROUTE EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action = 1
	// Redirect request.
	EnvoyFilter_RouteConfigurationMatch_RouteMatch_REDIRECT EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action = 2
	// directly respond to a request with specific payload.
	EnvoyFilter_RouteConfigurationMatch_RouteMatch_DIRECT_RESPONSE EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action = 3
)

// Enum value maps for EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action.
var (
	EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action_name = map[int32]string{
		0: "ANY",
		1: "ROUTE",
		2: "REDIRECT",
		3: "DIRECT_RESPONSE",
	}
	EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action_value = map[string]int32{
		"ANY":             0,
		"ROUTE":           1,
		"REDIRECT":        2,
		"DIRECT_RESPONSE": 3,
	}
)

func (x EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action) Enum() *EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action {
	p := new(EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action)
	*p = x
	return p
}

func (x EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action) Descriptor() protoreflect.EnumDescriptor {
	return file_networking_v1alpha3_envoy_filter_proto_enumTypes[2].Descriptor()
}

func (EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action) Type() protoreflect.EnumType {
	return &file_networking_v1alpha3_envoy_filter_proto_enumTypes[2]
}

func (x EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action.Descriptor instead.
func (EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action) EnumDescriptor() ([]byte, []int) {
	return file_networking_v1alpha3_envoy_filter_proto_rawDescGZIP(), []int{0, 2, 0, 0}
}

// Operation denotes how the patch should be applied to the selected
// configuration.
type EnvoyFilter_Patch_Operation int32

const (
	EnvoyFilter_Patch_INVALID EnvoyFilter_Patch_Operation = 0
	// Merge the provided config with the generated config using
	// proto merge semantics. If you are specifying config in its
	// entirety, use `REPLACE` instead.
	EnvoyFilter_Patch_MERGE EnvoyFilter_Patch_Operation = 1
	// Add the provided config to an existing list (of listeners,
	// clusters, virtual hosts, network filters, or http
	// filters). This operation will be ignored when `applyTo` is set
	// to `ROUTE_CONFIGURATION`, or `HTTP_ROUTE`.
	EnvoyFilter_Patch_ADD EnvoyFilter_Patch_Operation = 2
	// Remove the selected object from the list (of listeners,
	// clusters, virtual hosts, network filters, routes, or http
	// filters). Does not require a value to be specified. This
	// operation will be ignored when `applyTo` is set to
	// `ROUTE_CONFIGURATION`, or `HTTP_ROUTE`.
	EnvoyFilter_Patch_REMOVE EnvoyFilter_Patch_Operation = 3
	// Insert operation on an array of named objects. This operation
	// is typically useful only in the context of filters or routes,
	// where the order of elements matter. Routes should be ordered
	// based on most to least specific matching criteria since the
	// first matching element is selected. For clusters and virtual hosts,
	// order of the element in the array does not matter. Insert
	// before the selected filter or sub filter. If no filter is
	// selected, the specified filter will be inserted at the front
	// of the list.
	EnvoyFilter_Patch_INSERT_BEFORE EnvoyFilter_Patch_Operation = 4
	// Insert operation on an array of named objects. This operation
	// is typically useful only in the context of filters or routes,
	// where the order of elements matter. Routes should be ordered
	// based on most to least specific matching criteria since the
	// first matching element is selected. For clusters and virtual hosts,
	// order of the element in the array does not matter. Insert
	// after the selected filter or sub filter. If no filter is
	// selected, the specified filter will be inserted at the end
	// of the list.
	EnvoyFilter_Patch_INSERT_AFTER EnvoyFilter_Patch_Operation = 5
	// Insert operation on an array of named objects. This operation
	// is typically useful only in the context of filters or routes,
	// where the order of elements matter. Routes should be ordered
	// based on most to least specific matching criteria since the
	// first matching element is selected. For clusters and virtual hosts,
	// order of the element in the array does not matter. Insert
	// first in the list based on the presence of selected filter or not.
	// This is specifically useful when you want your filter first in the
	// list based on a match condition specified in Match clause.
	EnvoyFilter_Patch_INSERT_FIRST EnvoyFilter_Patch_Operation = 6
	// Replace contents of a named filter with new contents.
	// `REPLACE` operation is only valid for `HTTP_FILTER` and
	// `NETWORK_FILTER`. If the named filter is not found, this operation
	// has no effect.
	EnvoyFilter_Patch_REPLACE EnvoyFilter_Patch_Operation = 7
)

// Enum value maps for EnvoyFilter_Patch_Operation.
var (
	EnvoyFilter_Patch_Operation_name = map[int32]string{
		0: "INVALID",
		1: "MERGE",
		2: "ADD",
		3: "REMOVE",
		4: "INSERT_BEFORE",
		5: "INSERT_AFTER",
		6: "INSERT_FIRST",
		7: "REPLACE",
	}
	EnvoyFilter_Patch_Operation_value = map[string]int32{
		"INVALID":       0,
		"MERGE":         1,
		"ADD":           2,
		"REMOVE":        3,
		"INSERT_BEFORE": 4,
		"INSERT_AFTER":  5,
		"INSERT_FIRST":  6,
		"REPLACE":       7,
	}
)

func (x EnvoyFilter_Patch_Operation) Enum() *EnvoyFilter_Patch_Operation {
	p := new(EnvoyFilter_Patch_Operation)
	*p = x
	return p
}

func (x EnvoyFilter_Patch_Operation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EnvoyFilter_Patch_Operation) Descriptor() protoreflect.EnumDescriptor {
	return file_networking_v1alpha3_envoy_filter_proto_enumTypes[3].Descriptor()
}

func (EnvoyFilter_Patch_Operation) Type() protoreflect.EnumType {
	return &file_networking_v1alpha3_envoy_filter_proto_enumTypes[3]
}

func (x EnvoyFilter_Patch_Operation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EnvoyFilter_Patch_Operation.Descriptor instead.
func (EnvoyFilter_Patch_Operation) EnumDescriptor() ([]byte, []int) {
	return file_networking_v1alpha3_envoy_filter_proto_rawDescGZIP(), []int{0, 4, 0}
}

// FilterClass determines the filter insertion point in the filter chain
// relative to the filters implicitly inserted by the control plane.
// It is used in conjunction with the `ADD` operation.
// This is the preferred insertion mechanism for adding filters over
// the `INSERT_*` operations since those operations rely on potentially unstable
// filter names.
// Filter ordering is important if your filter depends on or affects the
// functioning of a another filter in the filter chain.
// Within a filter class, filters are inserted in the order of processing.
type EnvoyFilter_Patch_FilterClass int32

const (
	// Control plane decides where to insert the filter.
	// Do not specify `FilterClass` if the filter is independent of others.
	EnvoyFilter_Patch_UNSPECIFIED EnvoyFilter_Patch_FilterClass = 0
	// Insert filter after Istio authentication filters.
	EnvoyFilter_Patch_AUTHN EnvoyFilter_Patch_FilterClass = 1
	// Insert filter after Istio authorization filters.
	EnvoyFilter_Patch_AUTHZ EnvoyFilter_Patch_FilterClass = 2
	// Insert filter before Istio stats filters.
	EnvoyFilter_Patch_STATS EnvoyFilter_Patch_FilterClass = 3
)

// Enum value maps for EnvoyFilter_Patch_FilterClass.
var (
	EnvoyFilter_Patch_FilterClass_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "AUTHN",
		2: "AUTHZ",
		3: "STATS",
	}
	EnvoyFilter_Patch_FilterClass_value = map[string]int32{
		"UNSPECIFIED": 0,
		"AUTHN":       1,
		"AUTHZ":       2,
		"STATS":       3,
	}
)

func (x EnvoyFilter_Patch_FilterClass) Enum() *EnvoyFilter_Patch_FilterClass {
	p := new(EnvoyFilter_Patch_FilterClass)
	*p = x
	return p
}

func (x EnvoyFilter_Patch_FilterClass) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EnvoyFilter_Patch_FilterClass) Descriptor() protoreflect.EnumDescriptor {
	return file_networking_v1alpha3_envoy_filter_proto_enumTypes[4].Descriptor()
}

func (EnvoyFilter_Patch_FilterClass) Type() protoreflect.EnumType {
	return &file_networking_v1alpha3_envoy_filter_proto_enumTypes[4]
}

func (x EnvoyFilter_Patch_FilterClass) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EnvoyFilter_Patch_FilterClass.Descriptor instead.
func (EnvoyFilter_Patch_FilterClass) EnumDescriptor() ([]byte, []int) {
	return file_networking_v1alpha3_envoy_filter_proto_rawDescGZIP(), []int{0, 4, 1}
}

// EnvoyFilter provides a mechanism to customize the Envoy configuration
// generated by istiod.
//
// <!-- crd generation tags
// +cue-gen:EnvoyFilter:groupName:networking.istio.io
// +cue-gen:EnvoyFilter:versions:v1alpha3
// +cue-gen:EnvoyFilter:storageVersion
// +cue-gen:EnvoyFilter:annotations:helm.sh/resource-policy=keep
// +cue-gen:EnvoyFilter:labels:app=istio-pilot,chart=istio,heritage=Tiller,release=istio
// +cue-gen:EnvoyFilter:subresource:status
// +cue-gen:EnvoyFilter:scope:Namespaced
// +cue-gen:EnvoyFilter:releaseChannel:extended
// +cue-gen:EnvoyFilter:resource:categories=istio-io,networking-istio-io
// +cue-gen:EnvoyFilter:preserveUnknownFields:configPatches.[].patch.value
// -->
//
// <!-- go code generation tags
// +kubetype-gen
// +kubetype-gen:groupVersion=networking.istio.io/v1alpha3
// +genclient
// +k8s:deepcopy-gen=true
// -->
// +kubebuilder:validation:XValidation:message="only one of targetRefs or workloadSelector can be set",rule="oneof(self.workloadSelector, self.targetRefs)"
type EnvoyFilter struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Criteria used to select the specific set of pods/VMs on which
	// this patch configuration should be applied. If omitted, the set
	// of patches in this configuration will be applied to all workload
	// instances in the same namespace. If the `EnvoyFilter` is present
	// in the config root namespace, it will be applied to all applicable
	// workloads in any namespace.
	WorkloadSelector *WorkloadSelector `protobuf:"bytes,3,opt,name=workload_selector,json=workloadSelector,proto3" json:"workload_selector,omitempty"`
	// Optional. The targetRefs specifies a list of resources the policy should be
	// applied to. The targeted resources specified will determine which workloads
	// the policy applies to.
	//
	// Currently, the following resource attachment types are supported:
	// * `kind: Gateway` with `group: gateway.networking.k8s.io` in the same namespace.
	// * `kind: GatewayClass` with `group: gateway.networking.k8s.io` in the root namespace.
	// * `kind: Service` with `""` in the same namespace. This type is only supported for waypoints.
	// * `kind: ServiceEntry` with `group: networking.istio.io` in the same namespace.
	//
	// If not set, the policy is applied as defined by the selector.
	// At most one of the selector and targetRefs can be set.
	//
	// NOTE: If you are using the `targetRefs` field in a multi-revision environment with Istio versions prior to 1.22,
	// it is highly recommended that you pin the policy to a revision running 1.22+ via the `istio.io/rev` label.
	// This is to prevent proxies connected to older control planes (that don't know about the `targetRefs` field)
	// from misinterpreting the policy as namespace-wide during the upgrade process.
	//
	// NOTE: Waypoint proxies are required to use this field for policies to apply; `selector` policies will be ignored.
	// +kubebuilder:validation:MaxItems=16
	TargetRefs []*v1beta1.PolicyTargetReference `protobuf:"bytes,6,rep,name=targetRefs,proto3" json:"targetRefs,omitempty"`
	// One or more patches with match conditions.
	ConfigPatches []*EnvoyFilter_EnvoyConfigObjectPatch `protobuf:"bytes,4,rep,name=config_patches,json=configPatches,proto3" json:"config_patches,omitempty"`
	// Priority defines the order in which patch sets are applied within a context.
	// When one patch depends on another patch, the order of patch application
	// is significant. The API provides two primary ways to order patches.
	// Patch sets in the root namespace are applied before the patch sets in the
	// workload namespace. Patches within a patch set are processed in the order
	// that they appear in the `configPatches` list.
	//
	// The default value for priority is 0 and the range is [ min-int32, max-int32 ].
	// A patch set with a negative priority is processed before the default. A patch
	// set with a positive priority is processed after the default.
	//
	// It is recommended to start with priority values that are multiples of 10
	// to leave room for further insertion.
	//
	// Patch sets are sorted in the following ascending key order:
	// priority, creation time, fully qualified resource name.
	Priority      int32 `protobuf:"varint,5,opt,name=priority,proto3" json:"priority,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EnvoyFilter) Reset() {
	*x = EnvoyFilter{}
	mi := &file_networking_v1alpha3_envoy_filter_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EnvoyFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnvoyFilter) ProtoMessage() {}

func (x *EnvoyFilter) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_envoy_filter_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnvoyFilter.ProtoReflect.Descriptor instead.
func (*EnvoyFilter) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_envoy_filter_proto_rawDescGZIP(), []int{0}
}

func (x *EnvoyFilter) GetWorkloadSelector() *WorkloadSelector {
	if x != nil {
		return x.WorkloadSelector
	}
	return nil
}

func (x *EnvoyFilter) GetTargetRefs() []*v1beta1.PolicyTargetReference {
	if x != nil {
		return x.TargetRefs
	}
	return nil
}

func (x *EnvoyFilter) GetConfigPatches() []*EnvoyFilter_EnvoyConfigObjectPatch {
	if x != nil {
		return x.ConfigPatches
	}
	return nil
}

func (x *EnvoyFilter) GetPriority() int32 {
	if x != nil {
		return x.Priority
	}
	return 0
}

// One or more properties of the proxy to match on.
type EnvoyFilter_ProxyMatch struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// A regular expression in golang regex format (RE2) that can be
	// used to select proxies using a specific version of istio
	// proxy. The Istio version for a given proxy is obtained from the
	// node metadata field `ISTIO_VERSION` supplied by the proxy when
	// connecting to istiod. This value is embedded as an environment
	// variable (`ISTIO_META_ISTIO_VERSION`) in the Istio proxy docker
	// image. Custom proxy implementations should provide this metadata
	// variable to take advantage of the Istio version check option.
	ProxyVersion string `protobuf:"bytes,1,opt,name=proxy_version,json=proxyVersion,proto3" json:"proxy_version,omitempty"`
	// Match on the node metadata supplied by a proxy when connecting
	// to istiod. Note that while Envoy's node metadata is of
	// type Struct, only string key-value pairs are processed by
	// istiod. All keys specified in the metadata must match with exact
	// values. The match will fail if any of the specified keys are
	// absent or the values fail to match.
	Metadata      map[string]string `protobuf:"bytes,2,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EnvoyFilter_ProxyMatch) Reset() {
	*x = EnvoyFilter_ProxyMatch{}
	mi := &file_networking_v1alpha3_envoy_filter_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EnvoyFilter_ProxyMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnvoyFilter_ProxyMatch) ProtoMessage() {}

func (x *EnvoyFilter_ProxyMatch) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_envoy_filter_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnvoyFilter_ProxyMatch.ProtoReflect.Descriptor instead.
func (*EnvoyFilter_ProxyMatch) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_envoy_filter_proto_rawDescGZIP(), []int{0, 0}
}

func (x *EnvoyFilter_ProxyMatch) GetProxyVersion() string {
	if x != nil {
		return x.ProxyVersion
	}
	return ""
}

func (x *EnvoyFilter_ProxyMatch) GetMetadata() map[string]string {
	if x != nil {
		return x.Metadata
	}
	return nil
}

// Conditions specified in `ClusterMatch` must be met for the patch
// to be applied to a cluster.
type EnvoyFilter_ClusterMatch struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The service port for which this cluster was generated.  If
	// omitted, applies to clusters for any port.
	// **Note:** for inbound cluster, it is the service target port.
	PortNumber uint32 `protobuf:"varint,1,opt,name=port_number,json=portNumber,proto3" json:"port_number,omitempty"`
	// The fully qualified service name for this cluster. If omitted,
	// applies to clusters for any service. For services defined
	// through service entries, the service name is same as the hosts
	// defined in the service entry.
	// **Note:** for inbound cluster, this is ignored.
	Service string `protobuf:"bytes,2,opt,name=service,proto3" json:"service,omitempty"`
	// The subset associated with the service. If omitted, applies to
	// clusters for any subset of a service.
	Subset string `protobuf:"bytes,3,opt,name=subset,proto3" json:"subset,omitempty"`
	// The exact name of the cluster to match. To match a specific
	// cluster by name, such as the internally generated `Passthrough`
	// cluster, leave all fields in clusterMatch empty, except the
	// name.
	Name          string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EnvoyFilter_ClusterMatch) Reset() {
	*x = EnvoyFilter_ClusterMatch{}
	mi := &file_networking_v1alpha3_envoy_filter_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EnvoyFilter_ClusterMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnvoyFilter_ClusterMatch) ProtoMessage() {}

func (x *EnvoyFilter_ClusterMatch) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_envoy_filter_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnvoyFilter_ClusterMatch.ProtoReflect.Descriptor instead.
func (*EnvoyFilter_ClusterMatch) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_envoy_filter_proto_rawDescGZIP(), []int{0, 1}
}

func (x *EnvoyFilter_ClusterMatch) GetPortNumber() uint32 {
	if x != nil {
		return x.PortNumber
	}
	return 0
}

func (x *EnvoyFilter_ClusterMatch) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *EnvoyFilter_ClusterMatch) GetSubset() string {
	if x != nil {
		return x.Subset
	}
	return ""
}

func (x *EnvoyFilter_ClusterMatch) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Conditions specified in RouteConfigurationMatch must be met for
// the patch to be applied to a route configuration object or a
// specific virtual host within the route configuration.
type EnvoyFilter_RouteConfigurationMatch struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The service port number or gateway server port number for which
	// this route configuration was generated. If omitted, applies to
	// route configurations for all ports.
	PortNumber uint32 `protobuf:"varint,1,opt,name=port_number,json=portNumber,proto3" json:"port_number,omitempty"`
	// Applicable only for GATEWAY context. The gateway server port
	// name for which this route configuration was generated.
	PortName string `protobuf:"bytes,2,opt,name=port_name,json=portName,proto3" json:"port_name,omitempty"`
	// The Istio gateway config's namespace/name for which this route
	// configuration was generated. Applies only if the context is
	// GATEWAY. Should be in the namespace/name format. Use this field
	// in conjunction with the `portNumber` and `portName` to accurately
	// select the Envoy route configuration for a specific HTTPS
	// server within a gateway config object.
	Gateway string `protobuf:"bytes,3,opt,name=gateway,proto3" json:"gateway,omitempty"`
	// Match a specific virtual host in a route configuration and
	// apply the patch to the virtual host.
	Vhost *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch `protobuf:"bytes,4,opt,name=vhost,proto3" json:"vhost,omitempty"`
	// Route configuration name to match on. Can be used to match a
	// specific route configuration by name, such as the internally
	// generated `http_proxy` route configuration for all sidecars.
	Name          string `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EnvoyFilter_RouteConfigurationMatch) Reset() {
	*x = EnvoyFilter_RouteConfigurationMatch{}
	mi := &file_networking_v1alpha3_envoy_filter_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EnvoyFilter_RouteConfigurationMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnvoyFilter_RouteConfigurationMatch) ProtoMessage() {}

func (x *EnvoyFilter_RouteConfigurationMatch) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_envoy_filter_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnvoyFilter_RouteConfigurationMatch.ProtoReflect.Descriptor instead.
func (*EnvoyFilter_RouteConfigurationMatch) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_envoy_filter_proto_rawDescGZIP(), []int{0, 2}
}

func (x *EnvoyFilter_RouteConfigurationMatch) GetPortNumber() uint32 {
	if x != nil {
		return x.PortNumber
	}
	return 0
}

func (x *EnvoyFilter_RouteConfigurationMatch) GetPortName() string {
	if x != nil {
		return x.PortName
	}
	return ""
}

func (x *EnvoyFilter_RouteConfigurationMatch) GetGateway() string {
	if x != nil {
		return x.Gateway
	}
	return ""
}

func (x *EnvoyFilter_RouteConfigurationMatch) GetVhost() *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch {
	if x != nil {
		return x.Vhost
	}
	return nil
}

func (x *EnvoyFilter_RouteConfigurationMatch) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Conditions specified in a listener match must be met for the
// patch to be applied to a specific listener across all filter
// chains, or a specific filter chain inside the listener.
type EnvoyFilter_ListenerMatch struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The service port/gateway port to which traffic is being
	// sent/received. If not specified, matches all listeners. Even though
	// inbound listeners are generated for the instance/pod ports, only
	// service ports should be used to match listeners.
	PortNumber uint32 `protobuf:"varint,1,opt,name=port_number,json=portNumber,proto3" json:"port_number,omitempty"`
	// Instead of using specific port numbers, a set of ports matching
	// a given service's port name can be selected. Matching is case
	// insensitive.
	// Not implemented.
	// $hide_from_docs
	PortName string `protobuf:"bytes,2,opt,name=port_name,json=portName,proto3" json:"port_name,omitempty"`
	// Match a specific filter chain in a listener. If specified, the
	// patch will be applied to the filter chain (and a specific
	// filter if specified) and not to other filter chains in the
	// listener.
	FilterChain *EnvoyFilter_ListenerMatch_FilterChainMatch `protobuf:"bytes,3,opt,name=filter_chain,json=filterChain,proto3" json:"filter_chain,omitempty"`
	// Match a specific listener filter. If specified, the
	// patch will be applied to the listener filter.
	ListenerFilter string `protobuf:"bytes,5,opt,name=listener_filter,json=listenerFilter,proto3" json:"listener_filter,omitempty"`
	// Match a specific listener by its name. The listeners generated
	// by istiod are typically named as IP:Port.
	Name          string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EnvoyFilter_ListenerMatch) Reset() {
	*x = EnvoyFilter_ListenerMatch{}
	mi := &file_networking_v1alpha3_envoy_filter_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EnvoyFilter_ListenerMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnvoyFilter_ListenerMatch) ProtoMessage() {}

func (x *EnvoyFilter_ListenerMatch) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_envoy_filter_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnvoyFilter_ListenerMatch.ProtoReflect.Descriptor instead.
func (*EnvoyFilter_ListenerMatch) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_envoy_filter_proto_rawDescGZIP(), []int{0, 3}
}

func (x *EnvoyFilter_ListenerMatch) GetPortNumber() uint32 {
	if x != nil {
		return x.PortNumber
	}
	return 0
}

func (x *EnvoyFilter_ListenerMatch) GetPortName() string {
	if x != nil {
		return x.PortName
	}
	return ""
}

func (x *EnvoyFilter_ListenerMatch) GetFilterChain() *EnvoyFilter_ListenerMatch_FilterChainMatch {
	if x != nil {
		return x.FilterChain
	}
	return nil
}

func (x *EnvoyFilter_ListenerMatch) GetListenerFilter() string {
	if x != nil {
		return x.ListenerFilter
	}
	return ""
}

func (x *EnvoyFilter_ListenerMatch) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Patch specifies how the selected object should be modified.
type EnvoyFilter_Patch struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Determines how the patch should be applied.
	Operation EnvoyFilter_Patch_Operation `protobuf:"varint,1,opt,name=operation,proto3,enum=istio.networking.v1alpha3.EnvoyFilter_Patch_Operation" json:"operation,omitempty"`
	// The JSON config of the object being patched. This will be merged using
	// proto merge semantics with the existing proto in the path.
	Value *_struct.Struct `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// Determines the filter insertion order.
	FilterClass   EnvoyFilter_Patch_FilterClass `protobuf:"varint,3,opt,name=filter_class,json=filterClass,proto3,enum=istio.networking.v1alpha3.EnvoyFilter_Patch_FilterClass" json:"filter_class,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EnvoyFilter_Patch) Reset() {
	*x = EnvoyFilter_Patch{}
	mi := &file_networking_v1alpha3_envoy_filter_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EnvoyFilter_Patch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnvoyFilter_Patch) ProtoMessage() {}

func (x *EnvoyFilter_Patch) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_envoy_filter_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnvoyFilter_Patch.ProtoReflect.Descriptor instead.
func (*EnvoyFilter_Patch) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_envoy_filter_proto_rawDescGZIP(), []int{0, 4}
}

func (x *EnvoyFilter_Patch) GetOperation() EnvoyFilter_Patch_Operation {
	if x != nil {
		return x.Operation
	}
	return EnvoyFilter_Patch_INVALID
}

func (x *EnvoyFilter_Patch) GetValue() *_struct.Struct {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *EnvoyFilter_Patch) GetFilterClass() EnvoyFilter_Patch_FilterClass {
	if x != nil {
		return x.FilterClass
	}
	return EnvoyFilter_Patch_UNSPECIFIED
}

// One or more match conditions to be met before a patch is applied
// to the generated configuration for a given proxy.
type EnvoyFilter_EnvoyConfigObjectMatch struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The specific config generation context to match on. istiod
	// generates envoy configuration in the context of a gateway,
	// inbound traffic to sidecar and outbound traffic from sidecar.
	Context EnvoyFilter_PatchContext `protobuf:"varint,1,opt,name=context,proto3,enum=istio.networking.v1alpha3.EnvoyFilter_PatchContext" json:"context,omitempty"`
	// Match on properties associated with a proxy.
	Proxy *EnvoyFilter_ProxyMatch `protobuf:"bytes,2,opt,name=proxy,proto3" json:"proxy,omitempty"`
	// Types that are valid to be assigned to ObjectTypes:
	//
	//	*EnvoyFilter_EnvoyConfigObjectMatch_Listener
	//	*EnvoyFilter_EnvoyConfigObjectMatch_RouteConfiguration
	//	*EnvoyFilter_EnvoyConfigObjectMatch_Cluster
	ObjectTypes   isEnvoyFilter_EnvoyConfigObjectMatch_ObjectTypes `protobuf_oneof:"object_types"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EnvoyFilter_EnvoyConfigObjectMatch) Reset() {
	*x = EnvoyFilter_EnvoyConfigObjectMatch{}
	mi := &file_networking_v1alpha3_envoy_filter_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EnvoyFilter_EnvoyConfigObjectMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnvoyFilter_EnvoyConfigObjectMatch) ProtoMessage() {}

func (x *EnvoyFilter_EnvoyConfigObjectMatch) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_envoy_filter_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnvoyFilter_EnvoyConfigObjectMatch.ProtoReflect.Descriptor instead.
func (*EnvoyFilter_EnvoyConfigObjectMatch) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_envoy_filter_proto_rawDescGZIP(), []int{0, 5}
}

func (x *EnvoyFilter_EnvoyConfigObjectMatch) GetContext() EnvoyFilter_PatchContext {
	if x != nil {
		return x.Context
	}
	return EnvoyFilter_ANY
}

func (x *EnvoyFilter_EnvoyConfigObjectMatch) GetProxy() *EnvoyFilter_ProxyMatch {
	if x != nil {
		return x.Proxy
	}
	return nil
}

func (x *EnvoyFilter_EnvoyConfigObjectMatch) GetObjectTypes() isEnvoyFilter_EnvoyConfigObjectMatch_ObjectTypes {
	if x != nil {
		return x.ObjectTypes
	}
	return nil
}

func (x *EnvoyFilter_EnvoyConfigObjectMatch) GetListener() *EnvoyFilter_ListenerMatch {
	if x != nil {
		if x, ok := x.ObjectTypes.(*EnvoyFilter_EnvoyConfigObjectMatch_Listener); ok {
			return x.Listener
		}
	}
	return nil
}

func (x *EnvoyFilter_EnvoyConfigObjectMatch) GetRouteConfiguration() *EnvoyFilter_RouteConfigurationMatch {
	if x != nil {
		if x, ok := x.ObjectTypes.(*EnvoyFilter_EnvoyConfigObjectMatch_RouteConfiguration); ok {
			return x.RouteConfiguration
		}
	}
	return nil
}

func (x *EnvoyFilter_EnvoyConfigObjectMatch) GetCluster() *EnvoyFilter_ClusterMatch {
	if x != nil {
		if x, ok := x.ObjectTypes.(*EnvoyFilter_EnvoyConfigObjectMatch_Cluster); ok {
			return x.Cluster
		}
	}
	return nil
}

type isEnvoyFilter_EnvoyConfigObjectMatch_ObjectTypes interface {
	isEnvoyFilter_EnvoyConfigObjectMatch_ObjectTypes()
}

type EnvoyFilter_EnvoyConfigObjectMatch_Listener struct {
	// Match on envoy listener attributes.
	Listener *EnvoyFilter_ListenerMatch `protobuf:"bytes,3,opt,name=listener,proto3,oneof"`
}

type EnvoyFilter_EnvoyConfigObjectMatch_RouteConfiguration struct {
	// Match on envoy HTTP route configuration attributes.
	RouteConfiguration *EnvoyFilter_RouteConfigurationMatch `protobuf:"bytes,4,opt,name=route_configuration,json=routeConfiguration,proto3,oneof"`
}

type EnvoyFilter_EnvoyConfigObjectMatch_Cluster struct {
	// Match on envoy cluster attributes.
	Cluster *EnvoyFilter_ClusterMatch `protobuf:"bytes,5,opt,name=cluster,proto3,oneof"`
}

func (*EnvoyFilter_EnvoyConfigObjectMatch_Listener) isEnvoyFilter_EnvoyConfigObjectMatch_ObjectTypes() {
}

func (*EnvoyFilter_EnvoyConfigObjectMatch_RouteConfiguration) isEnvoyFilter_EnvoyConfigObjectMatch_ObjectTypes() {
}

func (*EnvoyFilter_EnvoyConfigObjectMatch_Cluster) isEnvoyFilter_EnvoyConfigObjectMatch_ObjectTypes() {
}

// Changes to be made to various envoy config objects.
type EnvoyFilter_EnvoyConfigObjectPatch struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Specifies where in the Envoy configuration, the patch should be
	// applied.  The match is expected to select the appropriate
	// object based on applyTo.  For example, an applyTo with
	// `HTTP_FILTER` is expected to have a match condition on the
	// listeners, with a network filter selection on
	// `envoy.filters.network.http_connection_manager` and a sub filter selection on the
	// HTTP filter relative to which the insertion should be
	// performed. Similarly, an applyTo on `CLUSTER` should have a match
	// (if provided) on the cluster and not on a listener.
	ApplyTo EnvoyFilter_ApplyTo `protobuf:"varint,1,opt,name=apply_to,json=applyTo,proto3,enum=istio.networking.v1alpha3.EnvoyFilter_ApplyTo" json:"apply_to,omitempty"`
	// Match on listener/route configuration/cluster.
	Match *EnvoyFilter_EnvoyConfigObjectMatch `protobuf:"bytes,2,opt,name=match,proto3" json:"match,omitempty"`
	// The patch to apply along with the operation.
	Patch         *EnvoyFilter_Patch `protobuf:"bytes,3,opt,name=patch,proto3" json:"patch,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EnvoyFilter_EnvoyConfigObjectPatch) Reset() {
	*x = EnvoyFilter_EnvoyConfigObjectPatch{}
	mi := &file_networking_v1alpha3_envoy_filter_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EnvoyFilter_EnvoyConfigObjectPatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnvoyFilter_EnvoyConfigObjectPatch) ProtoMessage() {}

func (x *EnvoyFilter_EnvoyConfigObjectPatch) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_envoy_filter_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnvoyFilter_EnvoyConfigObjectPatch.ProtoReflect.Descriptor instead.
func (*EnvoyFilter_EnvoyConfigObjectPatch) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_envoy_filter_proto_rawDescGZIP(), []int{0, 6}
}

func (x *EnvoyFilter_EnvoyConfigObjectPatch) GetApplyTo() EnvoyFilter_ApplyTo {
	if x != nil {
		return x.ApplyTo
	}
	return EnvoyFilter_INVALID
}

func (x *EnvoyFilter_EnvoyConfigObjectPatch) GetMatch() *EnvoyFilter_EnvoyConfigObjectMatch {
	if x != nil {
		return x.Match
	}
	return nil
}

func (x *EnvoyFilter_EnvoyConfigObjectPatch) GetPatch() *EnvoyFilter_Patch {
	if x != nil {
		return x.Patch
	}
	return nil
}

// Match a specific route inside a virtual host in a route configuration.
type EnvoyFilter_RouteConfigurationMatch_RouteMatch struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The Route objects generated by default are named as
	// default.  Route objects generated using a virtual service
	// will carry the name used in the virtual service's HTTP
	// routes.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Match a route with specific action type.
	Action        EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action `protobuf:"varint,2,opt,name=action,proto3,enum=istio.networking.v1alpha3.EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action" json:"action,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EnvoyFilter_RouteConfigurationMatch_RouteMatch) Reset() {
	*x = EnvoyFilter_RouteConfigurationMatch_RouteMatch{}
	mi := &file_networking_v1alpha3_envoy_filter_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EnvoyFilter_RouteConfigurationMatch_RouteMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnvoyFilter_RouteConfigurationMatch_RouteMatch) ProtoMessage() {}

func (x *EnvoyFilter_RouteConfigurationMatch_RouteMatch) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_envoy_filter_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnvoyFilter_RouteConfigurationMatch_RouteMatch.ProtoReflect.Descriptor instead.
func (*EnvoyFilter_RouteConfigurationMatch_RouteMatch) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_envoy_filter_proto_rawDescGZIP(), []int{0, 2, 0}
}

func (x *EnvoyFilter_RouteConfigurationMatch_RouteMatch) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EnvoyFilter_RouteConfigurationMatch_RouteMatch) GetAction() EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action {
	if x != nil {
		return x.Action
	}
	return EnvoyFilter_RouteConfigurationMatch_RouteMatch_ANY
}

// Match a specific virtual host inside a route configuration.
type EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The VirtualHosts objects generated by Istio are named as
	// host:port, where the host typically corresponds to the
	// VirtualService's host field or the hostname of a service in the
	// registry.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Match a domain name in a virtual host. If this domain name is part of
	// the list of domains that the virtual host serves, the patch will be
	// applied.
	DomainName string `protobuf:"bytes,3,opt,name=domain_name,json=domainName,proto3" json:"domain_name,omitempty"`
	// Match a specific route within the virtual host.
	Route         *EnvoyFilter_RouteConfigurationMatch_RouteMatch `protobuf:"bytes,2,opt,name=route,proto3" json:"route,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) Reset() {
	*x = EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch{}
	mi := &file_networking_v1alpha3_envoy_filter_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) ProtoMessage() {}

func (x *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_envoy_filter_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch.ProtoReflect.Descriptor instead.
func (*EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_envoy_filter_proto_rawDescGZIP(), []int{0, 2, 1}
}

func (x *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) GetDomainName() string {
	if x != nil {
		return x.DomainName
	}
	return ""
}

func (x *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) GetRoute() *EnvoyFilter_RouteConfigurationMatch_RouteMatch {
	if x != nil {
		return x.Route
	}
	return nil
}

// For listeners with multiple filter chains (e.g., inbound
// listeners on sidecars with permissive mTLS, gateway listeners
// with multiple SNI matches), the filter chain match can be used
// to select a specific filter chain to patch.
type EnvoyFilter_ListenerMatch_FilterChainMatch struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The name assigned to the filter chain.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The SNI value used by a filter chain's match condition.  This
	// condition will evaluate to false if the filter chain has no
	// sni match.
	Sni string `protobuf:"bytes,2,opt,name=sni,proto3" json:"sni,omitempty"`
	// Applies only to `SIDECAR_INBOUND` context. If non-empty, a
	// transport protocol to consider when determining a filter
	// chain match.  This value will be compared against the
	// transport protocol of a new connection, when it's detected by
	// the `tls_inspector` listener filter.
	//
	// Accepted values include:
	//
	// * `raw_buffer` - default, used when no transport protocol is detected.
	// * `tls` - set when TLS protocol is detected by the TLS inspector.
	TransportProtocol string `protobuf:"bytes,3,opt,name=transport_protocol,json=transportProtocol,proto3" json:"transport_protocol,omitempty"`
	// Applies only to sidecars. If non-empty, a comma separated set
	// of application protocols to consider when determining a
	// filter chain match.  This value will be compared against the
	// application protocols of a new connection, when it's detected
	// by one of the listener filters such as the `http_inspector`.
	//
	// Accepted values include: h2, http/1.1, http/1.0
	ApplicationProtocols string `protobuf:"bytes,4,opt,name=application_protocols,json=applicationProtocols,proto3" json:"application_protocols,omitempty"`
	// The name of a specific filter to apply the patch to. Set this
	// to `envoy.filters.network.http_connection_manager` to add a filter or apply a
	// patch to the HTTP connection manager.
	Filter *EnvoyFilter_ListenerMatch_FilterMatch `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
	// The destination_port value used by a filter chain's match condition.
	// This condition will evaluate to false if the filter chain has no destination_port match.
	DestinationPort uint32 `protobuf:"varint,6,opt,name=destination_port,json=destinationPort,proto3" json:"destination_port,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *EnvoyFilter_ListenerMatch_FilterChainMatch) Reset() {
	*x = EnvoyFilter_ListenerMatch_FilterChainMatch{}
	mi := &file_networking_v1alpha3_envoy_filter_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EnvoyFilter_ListenerMatch_FilterChainMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnvoyFilter_ListenerMatch_FilterChainMatch) ProtoMessage() {}

func (x *EnvoyFilter_ListenerMatch_FilterChainMatch) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_envoy_filter_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnvoyFilter_ListenerMatch_FilterChainMatch.ProtoReflect.Descriptor instead.
func (*EnvoyFilter_ListenerMatch_FilterChainMatch) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_envoy_filter_proto_rawDescGZIP(), []int{0, 3, 0}
}

func (x *EnvoyFilter_ListenerMatch_FilterChainMatch) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EnvoyFilter_ListenerMatch_FilterChainMatch) GetSni() string {
	if x != nil {
		return x.Sni
	}
	return ""
}

func (x *EnvoyFilter_ListenerMatch_FilterChainMatch) GetTransportProtocol() string {
	if x != nil {
		return x.TransportProtocol
	}
	return ""
}

func (x *EnvoyFilter_ListenerMatch_FilterChainMatch) GetApplicationProtocols() string {
	if x != nil {
		return x.ApplicationProtocols
	}
	return ""
}

func (x *EnvoyFilter_ListenerMatch_FilterChainMatch) GetFilter() *EnvoyFilter_ListenerMatch_FilterMatch {
	if x != nil {
		return x.Filter
	}
	return nil
}

func (x *EnvoyFilter_ListenerMatch_FilterChainMatch) GetDestinationPort() uint32 {
	if x != nil {
		return x.DestinationPort
	}
	return 0
}

// Conditions to match a specific filter within a filter chain.
type EnvoyFilter_ListenerMatch_FilterMatch struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The filter name to match on.
	// For standard Envoy filters, [canonical filter](https://www.envoyproxy.io/docs/envoy/latest/version_history/v1.14.0#deprecated)
	// names should be used.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The next level filter within this filter to match
	// upon. Typically used for HTTP Connection Manager filters and
	// Thrift filters.
	SubFilter     *EnvoyFilter_ListenerMatch_SubFilterMatch `protobuf:"bytes,2,opt,name=sub_filter,json=subFilter,proto3" json:"sub_filter,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EnvoyFilter_ListenerMatch_FilterMatch) Reset() {
	*x = EnvoyFilter_ListenerMatch_FilterMatch{}
	mi := &file_networking_v1alpha3_envoy_filter_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EnvoyFilter_ListenerMatch_FilterMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnvoyFilter_ListenerMatch_FilterMatch) ProtoMessage() {}

func (x *EnvoyFilter_ListenerMatch_FilterMatch) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_envoy_filter_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnvoyFilter_ListenerMatch_FilterMatch.ProtoReflect.Descriptor instead.
func (*EnvoyFilter_ListenerMatch_FilterMatch) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_envoy_filter_proto_rawDescGZIP(), []int{0, 3, 1}
}

func (x *EnvoyFilter_ListenerMatch_FilterMatch) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EnvoyFilter_ListenerMatch_FilterMatch) GetSubFilter() *EnvoyFilter_ListenerMatch_SubFilterMatch {
	if x != nil {
		return x.SubFilter
	}
	return nil
}

// Conditions to match a specific filter within another
// filter. This field is typically useful to match a HTTP filter
// inside the `envoy.filters.network.http_connection_manager` network filter.
// This could also be applicable for thrift filters.
type EnvoyFilter_ListenerMatch_SubFilterMatch struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The filter name to match on.
	Name          string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EnvoyFilter_ListenerMatch_SubFilterMatch) Reset() {
	*x = EnvoyFilter_ListenerMatch_SubFilterMatch{}
	mi := &file_networking_v1alpha3_envoy_filter_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EnvoyFilter_ListenerMatch_SubFilterMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnvoyFilter_ListenerMatch_SubFilterMatch) ProtoMessage() {}

func (x *EnvoyFilter_ListenerMatch_SubFilterMatch) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_envoy_filter_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnvoyFilter_ListenerMatch_SubFilterMatch.ProtoReflect.Descriptor instead.
func (*EnvoyFilter_ListenerMatch_SubFilterMatch) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_envoy_filter_proto_rawDescGZIP(), []int{0, 3, 2}
}

func (x *EnvoyFilter_ListenerMatch_SubFilterMatch) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

var File_networking_v1alpha3_envoy_filter_proto protoreflect.FileDescriptor

const file_networking_v1alpha3_envoy_filter_proto_rawDesc = "" +
	"\n" +
	"&networking/v1alpha3/envoy_filter.proto\x12\x19istio.networking.v1alpha3\x1a\x1cgoogle/protobuf/struct.proto\x1a!networking/v1alpha3/sidecar.proto\x1a\x1btype/v1beta1/selector.proto\"\x86\x1b\n" +
	"\vEnvoyFilter\x12X\n" +
	"\x11workload_selector\x18\x03 \x01(\v2+.istio.networking.v1alpha3.WorkloadSelectorR\x10workloadSelector\x12I\n" +
	"\n" +
	"targetRefs\x18\x06 \x03(\v2).istio.type.v1beta1.PolicyTargetReferenceR\n" +
	"targetRefs\x12d\n" +
	"\x0econfig_patches\x18\x04 \x03(\v2=.istio.networking.v1alpha3.EnvoyFilter.EnvoyConfigObjectPatchR\rconfigPatches\x12\x1a\n" +
	"\bpriority\x18\x05 \x01(\x05R\bpriority\x1a\xcb\x01\n" +
	"\n" +
	"ProxyMatch\x12#\n" +
	"\rproxy_version\x18\x01 \x01(\tR\fproxyVersion\x12[\n" +
	"\bmetadata\x18\x02 \x03(\v2?.istio.networking.v1alpha3.EnvoyFilter.ProxyMatch.MetadataEntryR\bmetadata\x1a;\n" +
	"\rMetadataEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\x1au\n" +
	"\fClusterMatch\x12\x1f\n" +
	"\vport_number\x18\x01 \x01(\rR\n" +
	"portNumber\x12\x18\n" +
	"\aservice\x18\x02 \x01(\tR\aservice\x12\x16\n" +
	"\x06subset\x18\x03 \x01(\tR\x06subset\x12\x12\n" +
	"\x04name\x18\x04 \x01(\tR\x04name\x1a\xe5\x04\n" +
	"\x17RouteConfigurationMatch\x12\x1f\n" +
	"\vport_number\x18\x01 \x01(\rR\n" +
	"portNumber\x12\x1b\n" +
	"\tport_name\x18\x02 \x01(\tR\bportName\x12\x18\n" +
	"\agateway\x18\x03 \x01(\tR\agateway\x12e\n" +
	"\x05vhost\x18\x04 \x01(\v2O.istio.networking.v1alpha3.EnvoyFilter.RouteConfigurationMatch.VirtualHostMatchR\x05vhost\x12\x12\n" +
	"\x04name\x18\x05 \x01(\tR\x04name\x1a\xcb\x01\n" +
	"\n" +
	"RouteMatch\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12h\n" +
	"\x06action\x18\x02 \x01(\x0e2P.istio.networking.v1alpha3.EnvoyFilter.RouteConfigurationMatch.RouteMatch.ActionR\x06action\"?\n" +
	"\x06Action\x12\a\n" +
	"\x03ANY\x10\x00\x12\t\n" +
	"\x05ROUTE\x10\x01\x12\f\n" +
	"\bREDIRECT\x10\x02\x12\x13\n" +
	"\x0fDIRECT_RESPONSE\x10\x03\x1a\xa8\x01\n" +
	"\x10VirtualHostMatch\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x1f\n" +
	"\vdomain_name\x18\x03 \x01(\tR\n" +
	"domainName\x12_\n" +
	"\x05route\x18\x02 \x01(\v2I.istio.networking.v1alpha3.EnvoyFilter.RouteConfigurationMatch.RouteMatchR\x05route\x1a\xc6\x05\n" +
	"\rListenerMatch\x12\x1f\n" +
	"\vport_number\x18\x01 \x01(\rR\n" +
	"portNumber\x12\x1b\n" +
	"\tport_name\x18\x02 \x01(\tR\bportName\x12h\n" +
	"\ffilter_chain\x18\x03 \x01(\v2E.istio.networking.v1alpha3.EnvoyFilter.ListenerMatch.FilterChainMatchR\vfilterChain\x12'\n" +
	"\x0flistener_filter\x18\x05 \x01(\tR\x0elistenerFilter\x12\x12\n" +
	"\x04name\x18\x04 \x01(\tR\x04name\x1a\xa1\x02\n" +
	"\x10FilterChainMatch\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x10\n" +
	"\x03sni\x18\x02 \x01(\tR\x03sni\x12-\n" +
	"\x12transport_protocol\x18\x03 \x01(\tR\x11transportProtocol\x123\n" +
	"\x15application_protocols\x18\x04 \x01(\tR\x14applicationProtocols\x12X\n" +
	"\x06filter\x18\x05 \x01(\v2@.istio.networking.v1alpha3.EnvoyFilter.ListenerMatch.FilterMatchR\x06filter\x12)\n" +
	"\x10destination_port\x18\x06 \x01(\rR\x0fdestinationPort\x1a\x85\x01\n" +
	"\vFilterMatch\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12b\n" +
	"\n" +
	"sub_filter\x18\x02 \x01(\v2C.istio.networking.v1alpha3.EnvoyFilter.ListenerMatch.SubFilterMatchR\tsubFilter\x1a$\n" +
	"\x0eSubFilterMatch\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x1a\xa8\x03\n" +
	"\x05Patch\x12T\n" +
	"\toperation\x18\x01 \x01(\x0e26.istio.networking.v1alpha3.EnvoyFilter.Patch.OperationR\toperation\x12-\n" +
	"\x05value\x18\x02 \x01(\v2\x17.google.protobuf.StructR\x05value\x12[\n" +
	"\ffilter_class\x18\x03 \x01(\x0e28.istio.networking.v1alpha3.EnvoyFilter.Patch.FilterClassR\vfilterClass\"|\n" +
	"\tOperation\x12\v\n" +
	"\aINVALID\x10\x00\x12\t\n" +
	"\x05MERGE\x10\x01\x12\a\n" +
	"\x03ADD\x10\x02\x12\n" +
	"\n" +
	"\x06REMOVE\x10\x03\x12\x11\n" +
	"\rINSERT_BEFORE\x10\x04\x12\x10\n" +
	"\fINSERT_AFTER\x10\x05\x12\x10\n" +
	"\fINSERT_FIRST\x10\x06\x12\v\n" +
	"\aREPLACE\x10\a\"?\n" +
	"\vFilterClass\x12\x0f\n" +
	"\vUNSPECIFIED\x10\x00\x12\t\n" +
	"\x05AUTHN\x10\x01\x12\t\n" +
	"\x05AUTHZ\x10\x02\x12\t\n" +
	"\x05STATS\x10\x03\x1a\xd8\x03\n" +
	"\x16EnvoyConfigObjectMatch\x12M\n" +
	"\acontext\x18\x01 \x01(\x0e23.istio.networking.v1alpha3.EnvoyFilter.PatchContextR\acontext\x12G\n" +
	"\x05proxy\x18\x02 \x01(\v21.istio.networking.v1alpha3.EnvoyFilter.ProxyMatchR\x05proxy\x12R\n" +
	"\blistener\x18\x03 \x01(\v24.istio.networking.v1alpha3.EnvoyFilter.ListenerMatchH\x00R\blistener\x12q\n" +
	"\x13route_configuration\x18\x04 \x01(\v2>.istio.networking.v1alpha3.EnvoyFilter.RouteConfigurationMatchH\x00R\x12routeConfiguration\x12O\n" +
	"\acluster\x18\x05 \x01(\v23.istio.networking.v1alpha3.EnvoyFilter.ClusterMatchH\x00R\aclusterB\x0e\n" +
	"\fobject_types\x1a\xfc\x01\n" +
	"\x16EnvoyConfigObjectPatch\x12I\n" +
	"\bapply_to\x18\x01 \x01(\x0e2..istio.networking.v1alpha3.EnvoyFilter.ApplyToR\aapplyTo\x12S\n" +
	"\x05match\x18\x02 \x01(\v2=.istio.networking.v1alpha3.EnvoyFilter.EnvoyConfigObjectMatchR\x05match\x12B\n" +
	"\x05patch\x18\x03 \x01(\v2,.istio.networking.v1alpha3.EnvoyFilter.PatchR\x05patch\"\xdd\x01\n" +
	"\aApplyTo\x12\v\n" +
	"\aINVALID\x10\x00\x12\f\n" +
	"\bLISTENER\x10\x01\x12\x10\n" +
	"\fFILTER_CHAIN\x10\x02\x12\x12\n" +
	"\x0eNETWORK_FILTER\x10\x03\x12\x0f\n" +
	"\vHTTP_FILTER\x10\x04\x12\x17\n" +
	"\x13ROUTE_CONFIGURATION\x10\x05\x12\x10\n" +
	"\fVIRTUAL_HOST\x10\x06\x12\x0e\n" +
	"\n" +
	"HTTP_ROUTE\x10\a\x12\v\n" +
	"\aCLUSTER\x10\b\x12\x14\n" +
	"\x10EXTENSION_CONFIG\x10\t\x12\r\n" +
	"\tBOOTSTRAP\x10\n" +
	"\x12\x13\n" +
	"\x0fLISTENER_FILTER\x10\v\"O\n" +
	"\fPatchContext\x12\a\n" +
	"\x03ANY\x10\x00\x12\x13\n" +
	"\x0fSIDECAR_INBOUND\x10\x01\x12\x14\n" +
	"\x10SIDECAR_OUTBOUND\x10\x02\x12\v\n" +
	"\aGATEWAY\x10\x03J\x04\b\x01\x10\x02J\x04\b\x02\x10\x03R\afiltersR\x0fworkload_labelsB\"Z istio.io/api/networking/v1alpha3b\x06proto3"

var (
	file_networking_v1alpha3_envoy_filter_proto_rawDescOnce sync.Once
	file_networking_v1alpha3_envoy_filter_proto_rawDescData []byte
)

func file_networking_v1alpha3_envoy_filter_proto_rawDescGZIP() []byte {
	file_networking_v1alpha3_envoy_filter_proto_rawDescOnce.Do(func() {
		file_networking_v1alpha3_envoy_filter_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_networking_v1alpha3_envoy_filter_proto_rawDesc), len(file_networking_v1alpha3_envoy_filter_proto_rawDesc)))
	})
	return file_networking_v1alpha3_envoy_filter_proto_rawDescData
}

var file_networking_v1alpha3_envoy_filter_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_networking_v1alpha3_envoy_filter_proto_msgTypes = make([]protoimpl.MessageInfo, 14)
var file_networking_v1alpha3_envoy_filter_proto_goTypes = []any{
	(EnvoyFilter_ApplyTo)(0),                                   // 0: istio.networking.v1alpha3.EnvoyFilter.ApplyTo
	(EnvoyFilter_PatchContext)(0),                              // 1: istio.networking.v1alpha3.EnvoyFilter.PatchContext
	(EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action)(0), // 2: istio.networking.v1alpha3.EnvoyFilter.RouteConfigurationMatch.RouteMatch.Action
	(EnvoyFilter_Patch_Operation)(0),                           // 3: istio.networking.v1alpha3.EnvoyFilter.Patch.Operation
	(EnvoyFilter_Patch_FilterClass)(0),                         // 4: istio.networking.v1alpha3.EnvoyFilter.Patch.FilterClass
	(*EnvoyFilter)(nil),                                        // 5: istio.networking.v1alpha3.EnvoyFilter
	(*EnvoyFilter_ProxyMatch)(nil),                             // 6: istio.networking.v1alpha3.EnvoyFilter.ProxyMatch
	(*EnvoyFilter_ClusterMatch)(nil),                           // 7: istio.networking.v1alpha3.EnvoyFilter.ClusterMatch
	(*EnvoyFilter_RouteConfigurationMatch)(nil),                // 8: istio.networking.v1alpha3.EnvoyFilter.RouteConfigurationMatch
	(*EnvoyFilter_ListenerMatch)(nil),                          // 9: istio.networking.v1alpha3.EnvoyFilter.ListenerMatch
	(*EnvoyFilter_Patch)(nil),                                  // 10: istio.networking.v1alpha3.EnvoyFilter.Patch
	(*EnvoyFilter_EnvoyConfigObjectMatch)(nil),                 // 11: istio.networking.v1alpha3.EnvoyFilter.EnvoyConfigObjectMatch
	(*EnvoyFilter_EnvoyConfigObjectPatch)(nil),                 // 12: istio.networking.v1alpha3.EnvoyFilter.EnvoyConfigObjectPatch
	nil, // 13: istio.networking.v1alpha3.EnvoyFilter.ProxyMatch.MetadataEntry
	(*EnvoyFilter_RouteConfigurationMatch_RouteMatch)(nil),       // 14: istio.networking.v1alpha3.EnvoyFilter.RouteConfigurationMatch.RouteMatch
	(*EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch)(nil), // 15: istio.networking.v1alpha3.EnvoyFilter.RouteConfigurationMatch.VirtualHostMatch
	(*EnvoyFilter_ListenerMatch_FilterChainMatch)(nil),           // 16: istio.networking.v1alpha3.EnvoyFilter.ListenerMatch.FilterChainMatch
	(*EnvoyFilter_ListenerMatch_FilterMatch)(nil),                // 17: istio.networking.v1alpha3.EnvoyFilter.ListenerMatch.FilterMatch
	(*EnvoyFilter_ListenerMatch_SubFilterMatch)(nil),             // 18: istio.networking.v1alpha3.EnvoyFilter.ListenerMatch.SubFilterMatch
	(*WorkloadSelector)(nil),                                     // 19: istio.networking.v1alpha3.WorkloadSelector
	(*v1beta1.PolicyTargetReference)(nil),                        // 20: istio.type.v1beta1.PolicyTargetReference
	(*_struct.Struct)(nil),                                       // 21: google.protobuf.Struct
}
var file_networking_v1alpha3_envoy_filter_proto_depIdxs = []int32{
	19, // 0: istio.networking.v1alpha3.EnvoyFilter.workload_selector:type_name -> istio.networking.v1alpha3.WorkloadSelector
	20, // 1: istio.networking.v1alpha3.EnvoyFilter.targetRefs:type_name -> istio.type.v1beta1.PolicyTargetReference
	12, // 2: istio.networking.v1alpha3.EnvoyFilter.config_patches:type_name -> istio.networking.v1alpha3.EnvoyFilter.EnvoyConfigObjectPatch
	13, // 3: istio.networking.v1alpha3.EnvoyFilter.ProxyMatch.metadata:type_name -> istio.networking.v1alpha3.EnvoyFilter.ProxyMatch.MetadataEntry
	15, // 4: istio.networking.v1alpha3.EnvoyFilter.RouteConfigurationMatch.vhost:type_name -> istio.networking.v1alpha3.EnvoyFilter.RouteConfigurationMatch.VirtualHostMatch
	16, // 5: istio.networking.v1alpha3.EnvoyFilter.ListenerMatch.filter_chain:type_name -> istio.networking.v1alpha3.EnvoyFilter.ListenerMatch.FilterChainMatch
	3,  // 6: istio.networking.v1alpha3.EnvoyFilter.Patch.operation:type_name -> istio.networking.v1alpha3.EnvoyFilter.Patch.Operation
	21, // 7: istio.networking.v1alpha3.EnvoyFilter.Patch.value:type_name -> google.protobuf.Struct
	4,  // 8: istio.networking.v1alpha3.EnvoyFilter.Patch.filter_class:type_name -> istio.networking.v1alpha3.EnvoyFilter.Patch.FilterClass
	1,  // 9: istio.networking.v1alpha3.EnvoyFilter.EnvoyConfigObjectMatch.context:type_name -> istio.networking.v1alpha3.EnvoyFilter.PatchContext
	6,  // 10: istio.networking.v1alpha3.EnvoyFilter.EnvoyConfigObjectMatch.proxy:type_name -> istio.networking.v1alpha3.EnvoyFilter.ProxyMatch
	9,  // 11: istio.networking.v1alpha3.EnvoyFilter.EnvoyConfigObjectMatch.listener:type_name -> istio.networking.v1alpha3.EnvoyFilter.ListenerMatch
	8,  // 12: istio.networking.v1alpha3.EnvoyFilter.EnvoyConfigObjectMatch.route_configuration:type_name -> istio.networking.v1alpha3.EnvoyFilter.RouteConfigurationMatch
	7,  // 13: istio.networking.v1alpha3.EnvoyFilter.EnvoyConfigObjectMatch.cluster:type_name -> istio.networking.v1alpha3.EnvoyFilter.ClusterMatch
	0,  // 14: istio.networking.v1alpha3.EnvoyFilter.EnvoyConfigObjectPatch.apply_to:type_name -> istio.networking.v1alpha3.EnvoyFilter.ApplyTo
	11, // 15: istio.networking.v1alpha3.EnvoyFilter.EnvoyConfigObjectPatch.match:type_name -> istio.networking.v1alpha3.EnvoyFilter.EnvoyConfigObjectMatch
	10, // 16: istio.networking.v1alpha3.EnvoyFilter.EnvoyConfigObjectPatch.patch:type_name -> istio.networking.v1alpha3.EnvoyFilter.Patch
	2,  // 17: istio.networking.v1alpha3.EnvoyFilter.RouteConfigurationMatch.RouteMatch.action:type_name -> istio.networking.v1alpha3.EnvoyFilter.RouteConfigurationMatch.RouteMatch.Action
	14, // 18: istio.networking.v1alpha3.EnvoyFilter.RouteConfigurationMatch.VirtualHostMatch.route:type_name -> istio.networking.v1alpha3.EnvoyFilter.RouteConfigurationMatch.RouteMatch
	17, // 19: istio.networking.v1alpha3.EnvoyFilter.ListenerMatch.FilterChainMatch.filter:type_name -> istio.networking.v1alpha3.EnvoyFilter.ListenerMatch.FilterMatch
	18, // 20: istio.networking.v1alpha3.EnvoyFilter.ListenerMatch.FilterMatch.sub_filter:type_name -> istio.networking.v1alpha3.EnvoyFilter.ListenerMatch.SubFilterMatch
	21, // [21:21] is the sub-list for method output_type
	21, // [21:21] is the sub-list for method input_type
	21, // [21:21] is the sub-list for extension type_name
	21, // [21:21] is the sub-list for extension extendee
	0,  // [0:21] is the sub-list for field type_name
}

func init() { file_networking_v1alpha3_envoy_filter_proto_init() }
func file_networking_v1alpha3_envoy_filter_proto_init() {
	if File_networking_v1alpha3_envoy_filter_proto != nil {
		return
	}
	file_networking_v1alpha3_sidecar_proto_init()
	file_networking_v1alpha3_envoy_filter_proto_msgTypes[6].OneofWrappers = []any{
		(*EnvoyFilter_EnvoyConfigObjectMatch_Listener)(nil),
		(*EnvoyFilter_EnvoyConfigObjectMatch_RouteConfiguration)(nil),
		(*EnvoyFilter_EnvoyConfigObjectMatch_Cluster)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_networking_v1alpha3_envoy_filter_proto_rawDesc), len(file_networking_v1alpha3_envoy_filter_proto_rawDesc)),
			NumEnums:      5,
			NumMessages:   14,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_networking_v1alpha3_envoy_filter_proto_goTypes,
		DependencyIndexes: file_networking_v1alpha3_envoy_filter_proto_depIdxs,
		EnumInfos:         file_networking_v1alpha3_envoy_filter_proto_enumTypes,
		MessageInfos:      file_networking_v1alpha3_envoy_filter_proto_msgTypes,
	}.Build()
	File_networking_v1alpha3_envoy_filter_proto = out.File
	file_networking_v1alpha3_envoy_filter_proto_goTypes = nil
	file_networking_v1alpha3_envoy_filter_proto_depIdxs = nil
}
