
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kjobwidgets_wrapper.h"

// Argument includes
#include <qobject.h>
#include <qwidget.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KJobWidgets_Type = nullptr;
static PyTypeObject *Sbk_KJobWidgets_TypeF(void)
{
    return _Sbk_KJobWidgets_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int Sbk_KJobWidgets_Init(PyObject *, PyObject *, PyObject *)
{
    Shiboken::Errors::setInstantiateNamespace("KJobWidgets");
    return -1;
}

static PyObject *Sbk_KJobWidgetsFunc_setWindow(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setWindow", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KJobWidgets::setWindow(QObject*,QWidget*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1])))) {
        overloadId = 0; // setWindow(QObject*,QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setWindow", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKJobWidgets_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QWidget *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setWindow(QObject*,QWidget*)
            ::KJobWidgets::setWindow(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KJobWidgetsFunc_setWindowHandle(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setWindowHandle", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KJobWidgets::setWindowHandle(QObject*,QWindow*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QWindow_IDX]), (pyArgs[1])))) {
        overloadId = 0; // setWindowHandle(QObject*,QWindow*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setWindowHandle", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKJobWidgets_IDX]);

    // Call function/method
    {
        Shiboken::Warnings::warnDeprecated("KJobWidgets", "setWindowHandle(QObject *job, QWindow *window)");
        if (Shiboken::Errors::occurred() != nullptr)
            return {};
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QWindow *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setWindowHandle(QObject*,QWindow*)
            ::KJobWidgets::setWindowHandle(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KJobWidgetsFunc_updateUserTimestamp(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "updateUserTimestamp", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KJobWidgets::updateUserTimestamp(QObject*,ulong)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), (pyArgs[1])))) {
        overloadId = 0; // updateUserTimestamp(QObject*,ulong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "updateUserTimestamp", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKJobWidgets_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned long cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // updateUserTimestamp(QObject*,ulong)
            ::KJobWidgets::updateUserTimestamp(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KJobWidgetsFunc_userTimestamp(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KJobWidgets::userTimestamp(QObject*)->unsigned long
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArg)))) {
        overloadId = 0; // userTimestamp(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "userTimestamp", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKJobWidgets_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QObject *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // userTimestamp(QObject*)
            unsigned long cppResult = ::KJobWidgets::userTimestamp(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KJobWidgetsFunc_window(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KJobWidgets::window(QObject*)->QWidget*
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArg)))) {
        overloadId = 0; // window(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "window", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKJobWidgets_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QObject *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // window(QObject*)
            QWidget * cppResult = ::KJobWidgets::window(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KJobWidgetsFunc_windowHandle(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KJobWidgets::windowHandle(QObject*)->QWindow*
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArg)))) {
        overloadId = 0; // windowHandle(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "windowHandle", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKJobWidgets_IDX]);

    // Call function/method
    {
        Shiboken::Warnings::warnDeprecated("KJobWidgets", "windowHandle(QObject *job)");
        if (Shiboken::Errors::occurred() != nullptr)
            return {};
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QObject *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // windowHandle(QObject*)
            QWindow * cppResult = ::KJobWidgets::windowHandle(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QWindow_IDX]), cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KJobWidgets_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KJobWidgets_methods[] = {
    {"setWindow", reinterpret_cast<PyCFunction>(Sbk_KJobWidgetsFunc_setWindow), METH_VARARGS|METH_STATIC, nullptr},
    {"setWindowHandle", reinterpret_cast<PyCFunction>(Sbk_KJobWidgetsFunc_setWindowHandle), METH_VARARGS|METH_STATIC, nullptr},
    {"updateUserTimestamp", reinterpret_cast<PyCFunction>(Sbk_KJobWidgetsFunc_updateUserTimestamp), METH_VARARGS|METH_STATIC, nullptr},
    {"userTimestamp", reinterpret_cast<PyCFunction>(Sbk_KJobWidgetsFunc_userTimestamp), METH_O|METH_STATIC, nullptr},
    {"window", reinterpret_cast<PyCFunction>(Sbk_KJobWidgetsFunc_window), METH_O|METH_STATIC, nullptr},
    {"windowHandle", reinterpret_cast<PyCFunction>(Sbk_KJobWidgetsFunc_windowHandle), METH_O|METH_STATIC, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KJobWidgets_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KJobWidgets_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KJobWidgets_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(Sbk_object_dealloc /* PYSIDE-832: Prevent replacement of "0" with subtype_dealloc. */)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KJobWidgets_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KJobWidgets_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KJobWidgets_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KJobWidgets_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkDummyNew /* PYSIDE-595: Prevent replacement of "0" with base->tp_new. */)},
    {0, nullptr}
};
static PyType_Spec Sbk_KJobWidgets_spec = {
    "1:KWidgetsAddons.KJobWidgets",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KJobWidgets_slots
};

} //extern "C"

// Type conversion functions.

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KWidgetsAddonsKJobWidgets_SignatureStrings[] = {
    "KWidgetsAddons.KJobWidgets.setWindow(job:PySide6.QtCore.QObject,widget:PySide6.QtWidgets.QWidget)",
    "KWidgetsAddons.KJobWidgets.setWindowHandle(job:PySide6.QtCore.QObject,window:PySide6.QtGui.QWindow)",
    "KWidgetsAddons.KJobWidgets.updateUserTimestamp(job:PySide6.QtCore.QObject,time:unsigned long)",
    "KWidgetsAddons.KJobWidgets.userTimestamp(job:PySide6.QtCore.QObject)->unsigned long",
    "KWidgetsAddons.KJobWidgets.window(job:PySide6.QtCore.QObject)->PySide6.QtWidgets.QWidget",
    "KWidgetsAddons.KJobWidgets.windowHandle(job:PySide6.QtCore.QObject)->PySide6.QtGui.QWindow",
    nullptr}; // Sentinel
#else
static constexpr size_t KWidgetsAddonsKJobWidgets_SignatureByteSize = 173;
static constexpr uint8_t KWidgetsAddonsKJobWidgets_SignatureBytes[173] = {
    0x78, 0xda, 0x8d, 0x90, 0x3d, 0x0b, 0xc2, 0x30, 0x10, 0x86, 0xf7, 0xfe, 0x0a, 0x47, 0x0b, 0x9a,
    0xd1, 0xa1, 0x83, 0x20, 0x0e, 0x8a, 0x19, 0xb4, 0xa8, 0x74, 0x4e, 0xbd, 0xa3, 0xa4, 0xb4, 0x49,
    0x69, 0xae, 0x04, 0xff, 0xbd, 0x8d, 0x1f, 0x90, 0x0e, 0x26, 0xdd, 0x8e, 0xbb, 0xf7, 0x9e, 0x07,
    0x5e, 0x5e, 0x48, 0xa8, 0x90, 0xcc, 0x0e, 0x40, 0x2b, 0xc3, 0xf8, 0x49, 0x97, 0xdf, 0x0d, 0x33,
    0x48, 0x85, 0x54, 0xa0, 0xed, 0xb2, 0xd6, 0x65, 0x76, 0x79, 0x5e, 0x25, 0xe0, 0x86, 0xe5, 0xb4,
    0xd7, 0x3d, 0xb2, 0xfc, 0x5c, 0xd6, 0xf8, 0xa0, 0x95, 0x7d, 0x87, 0xbd, 0xeb, 0xef, 0x3b, 0xff,
    0x0c, 0x69, 0xc2, 0x67, 0x18, 0x8e, 0x42, 0x41, 0x83, 0x61, 0x8f, 0xcb, 0x79, 0xd7, 0xc3, 0x20,
    0x9d, 0xc3, 0x6d, 0x83, 0x8e, 0xa1, 0x03, 0x41, 0x78, 0x37, 0xd8, 0xdf, 0x64, 0x8b, 0x86, 0x44,
    0xdb, 0x85, 0x3c, 0x34, 0x86, 0xb2, 0x41, 0x19, 0x59, 0x29, 0x84, 0x45, 0xa3, 0x55, 0x15, 0xa6,
    0xcf, 0xe4, 0xa6, 0xeb, 0xed, 0x04, 0x1a, 0x62, 0xda, 0x58, 0xe9, 0x23, 0xec, 0x6f, 0xdf, 0x71,
    0x70, 0xb4, 0xeb, 0x09, 0xde, 0xab, 0x39, 0x79, 0x01, 0x60, 0xac, 0xca, 0x16
};
#endif

PyTypeObject *init_KWidgetsAddonsKJobWidgets(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKJobWidgets_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKJobWidgets_IDX].type;

    Shiboken::AutoDecRef Sbk_KJobWidgets_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KJobWidgets_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KJobWidgets",
        "KJobWidgets",
        &Sbk_KJobWidgets_spec,
        nullptr,
        Sbk_KJobWidgets_Type_bases.object(),
        0);
    auto *pyType = Sbk_KJobWidgets_TypeF(); // references _Sbk_KJobWidgets_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KWidgetsAddonsKJobWidgets_SignatureStrings);
#else
    InitSignatureBytes(pyType, KWidgetsAddonsKJobWidgets_SignatureBytes, KWidgetsAddonsKJobWidgets_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KJobWidgets_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKJobWidgets_IDX].type = pyType;



    return pyType;
}
