/* keymap.c generated by valac 0.56.17, the Vala compiler
 * generated from keymap.vala, do not modify */

/*
 * Copyright (C) 2011-2018 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2018 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "libskk/libskk.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define SKK_TYPE_KEYMAP (skk_keymap_get_type ())
#define SKK_KEYMAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_KEYMAP, SkkKeymap))
#define SKK_KEYMAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_KEYMAP, SkkKeymapClass))
#define SKK_IS_KEYMAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_KEYMAP))
#define SKK_IS_KEYMAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_KEYMAP))
#define SKK_KEYMAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_KEYMAP, SkkKeymapClass))

typedef struct _SkkKeymap SkkKeymap;
typedef struct _SkkKeymapClass SkkKeymapClass;
typedef struct _SkkKeymapPrivate SkkKeymapPrivate;
enum  {
	SKK_KEYMAP_0_PROPERTY,
	SKK_KEYMAP_NUM_PROPERTIES
};
static GParamSpec* skk_keymap_properties[SKK_KEYMAP_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SkkKeymap {
	GObject parent_instance;
	SkkKeymapPrivate * priv;
};

struct _SkkKeymapClass {
	GObjectClass parent_class;
};

struct _SkkKeymapPrivate {
	GeeMap* entries;
};

static gint SkkKeymap_private_offset;
static gpointer skk_keymap_parent_class = NULL;

VALA_EXTERN GType skk_keymap_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void skk_keymap_set (SkkKeymap* self,
                     const gchar* key,
                     const gchar* command);
VALA_EXTERN gchar* skk_keymap_lookup_key (SkkKeymap* self,
                              SkkKeyEvent* key);
VALA_EXTERN SkkKeyEvent* skk_keymap_where_is (SkkKeymap* self,
                                  const gchar* command);
VALA_EXTERN SkkKeymap* skk_keymap_new (void);
VALA_EXTERN SkkKeymap* skk_keymap_construct (GType object_type);
static void skk_keymap_finalize (GObject * obj);
static GType skk_keymap_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
skk_keymap_get_instance_private (SkkKeymap* self)
{
	return G_STRUCT_MEMBER_P (self, SkkKeymap_private_offset);
}

void
skk_keymap_set (SkkKeymap* self,
                const gchar* key,
                const gchar* command)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (command != NULL);
	{
		SkkKeyEvent* ev = NULL;
		SkkKeyEvent* _tmp0_;
		GeeMap* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp0_ = skk_key_event_new_from_string (key, &_inner_error0_);
		ev = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == SKK_KEY_EVENT_FORMAT_ERROR) {
				goto __catch0_skk_key_event_format_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp1_ = self->priv->entries;
		_tmp2_ = skk_key_event_to_string (ev);
		_tmp3_ = _tmp2_;
		gee_map_set (_tmp1_, _tmp3_, command);
		_g_free0 (_tmp3_);
		_g_object_unref0 (ev);
	}
	goto __finally0;
	__catch0_skk_key_event_format_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("keymap.vala:29: can't get key event from string %s: %s", key, _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

gchar*
skk_keymap_lookup_key (SkkKeymap* self,
                       SkkKeyEvent* key)
{
	GeeMap* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gpointer _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = self->priv->entries;
	_tmp1_ = skk_key_event_to_string (key);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_map_get (_tmp0_, _tmp2_);
	_tmp4_ = (gchar*) _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}

SkkKeyEvent*
skk_keymap_where_is (SkkKeymap* self,
                     const gchar* command)
{
	GeeMapIterator* iter = NULL;
	GeeMap* _tmp0_;
	GeeMapIterator* _tmp1_;
	GError* _inner_error0_ = NULL;
	SkkKeyEvent* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (command != NULL, NULL);
	_tmp0_ = self->priv->entries;
	_tmp1_ = gee_map_map_iterator (_tmp0_);
	iter = _tmp1_;
	while (TRUE) {
		GeeMapIterator* _tmp2_;
		GeeMapIterator* _tmp3_;
		gpointer _tmp4_;
		gchar* _tmp5_;
		gboolean _tmp6_;
		_tmp2_ = iter;
		if (!gee_map_iterator_next (_tmp2_)) {
			break;
		}
		_tmp3_ = iter;
		_tmp4_ = gee_map_iterator_get_value (_tmp3_);
		_tmp5_ = (gchar*) _tmp4_;
		_tmp6_ = g_strcmp0 (_tmp5_, command) == 0;
		_g_free0 (_tmp5_);
		if (_tmp6_) {
			gchar* key = NULL;
			GeeMapIterator* _tmp7_;
			gpointer _tmp8_;
			_tmp7_ = iter;
			_tmp8_ = gee_map_iterator_get_key (_tmp7_);
			key = (gchar*) _tmp8_;
			{
				SkkKeyEvent* _tmp9_ = NULL;
				const gchar* _tmp10_;
				SkkKeyEvent* _tmp11_;
				SkkKeyEvent* _tmp12_;
				_tmp10_ = key;
				_tmp11_ = skk_key_event_new_from_string (_tmp10_, &_inner_error0_);
				_tmp9_ = _tmp11_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == SKK_KEY_EVENT_FORMAT_ERROR) {
						goto __catch0_skk_key_event_format_error;
					}
					_g_free0 (key);
					_g_object_unref0 (iter);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				_tmp12_ = _tmp9_;
				_tmp9_ = NULL;
				result = _tmp12_;
				_g_object_unref0 (_tmp9_);
				_g_free0 (key);
				_g_object_unref0 (iter);
				return result;
			}
			goto __finally0;
			__catch0_skk_key_event_format_error:
			{
				GError* e = NULL;
				const gchar* _tmp13_;
				GError* _tmp14_;
				const gchar* _tmp15_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp13_ = key;
				_tmp14_ = e;
				_tmp15_ = _tmp14_->message;
				g_warning ("keymap.vala:46: can't get key event from string %s: %s", _tmp13_, _tmp15_);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (key);
				_g_object_unref0 (iter);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_g_free0 (key);
		}
	}
	result = NULL;
	_g_object_unref0 (iter);
	return result;
}

SkkKeymap*
skk_keymap_construct (GType object_type)
{
	SkkKeymap * self = NULL;
	self = (SkkKeymap*) g_object_new (object_type, NULL);
	return self;
}

SkkKeymap*
skk_keymap_new (void)
{
	return skk_keymap_construct (SKK_TYPE_KEYMAP);
}

static void
skk_keymap_class_init (SkkKeymapClass * klass,
                       gpointer klass_data)
{
	skk_keymap_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SkkKeymap_private_offset);
	G_OBJECT_CLASS (klass)->finalize = skk_keymap_finalize;
}

static void
skk_keymap_instance_init (SkkKeymap * self,
                          gpointer klass)
{
	GeeHashMap* _tmp0_;
	self->priv = skk_keymap_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->entries = (GeeMap*) _tmp0_;
}

static void
skk_keymap_finalize (GObject * obj)
{
	SkkKeymap * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SKK_TYPE_KEYMAP, SkkKeymap);
	_g_object_unref0 (self->priv->entries);
	G_OBJECT_CLASS (skk_keymap_parent_class)->finalize (obj);
}

static GType
skk_keymap_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SkkKeymapClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_keymap_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkKeymap), 0, (GInstanceInitFunc) skk_keymap_instance_init, NULL };
	GType skk_keymap_type_id;
	skk_keymap_type_id = g_type_register_static (G_TYPE_OBJECT, "SkkKeymap", &g_define_type_info, 0);
	SkkKeymap_private_offset = g_type_add_instance_private (skk_keymap_type_id, sizeof (SkkKeymapPrivate));
	return skk_keymap_type_id;
}

GType
skk_keymap_get_type (void)
{
	static volatile gsize skk_keymap_type_id__once = 0;
	if (g_once_init_enter (&skk_keymap_type_id__once)) {
		GType skk_keymap_type_id;
		skk_keymap_type_id = skk_keymap_get_type_once ();
		g_once_init_leave (&skk_keymap_type_id__once, skk_keymap_type_id);
	}
	return skk_keymap_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

