/* Tag.c generated by valac 0.56.14, the Vala compiler
 * generated from Tag.vala, do not modify */

/*
    Copyright (C) 2014 2015 Johan Mattsson

    This library is free software; you can redistribute it and/or modify 
    it under the terms of the GNU Lesser General Public License as 
    published by the Free Software Foundation; either version 3 of the 
    License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful, but 
    WITHOUT ANY WARRANTY; without even the implied warranty of 
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
    Lesser General Public License for more details.
*/

#include "xmlbird.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define B_NONE 0

#define B_TYPE_XML_STRING (b_xml_string_get_type ())
#define B_XML_STRING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), B_TYPE_XML_STRING, BXmlString))
#define B_XML_STRING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), B_TYPE_XML_STRING, BXmlStringClass))
#define B_IS_XML_STRING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), B_TYPE_XML_STRING))
#define B_IS_XML_STRING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), B_TYPE_XML_STRING))
#define B_XML_STRING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), B_TYPE_XML_STRING, BXmlStringClass))

typedef struct _BXmlString BXmlString;
typedef struct _BXmlStringClass BXmlStringClass;
enum  {
	B_TAG_0_PROPERTY,
	B_TAG_ERROR_PROPERTY,
	B_TAG_NUM_PROPERTIES
};
static GParamSpec* b_tag_properties[B_TAG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define B_TYPE_XML_DATA (b_xml_data_get_type ())
#define B_XML_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), B_TYPE_XML_DATA, BXmlData))
#define B_XML_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), B_TYPE_XML_DATA, BXmlDataClass))
#define B_IS_XML_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), B_TYPE_XML_DATA))
#define B_IS_XML_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), B_TYPE_XML_DATA))
#define B_XML_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), B_TYPE_XML_DATA, BXmlDataClass))

typedef struct _BXmlData BXmlData;
typedef struct _BXmlDataClass BXmlDataClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _BXmlStringPrivate BXmlStringPrivate;
enum  {
	B_TAG_ITERATOR_0_PROPERTY,
	B_TAG_ITERATOR_NUM_PROPERTIES
};
static GParamSpec* b_tag_iterator_properties[B_TAG_ITERATOR_NUM_PROPERTIES];

struct _BTagPrivate {
	gint tag_index;
	gint attribute_index;
	gboolean has_tags;
	gboolean has_attributes;
	BXmlString* name;
	BXmlString* data;
	BXmlString* attributes;
	BTag* next_tag;
	BAttribute* next_attribute;
	gboolean parser_error;
	gboolean parsed;
	BTag* parent;
};

struct _BXmlString {
	GObject parent_instance;
	BXmlStringPrivate * priv;
	gint length;
	gchar* data;
};

struct _BXmlStringClass {
	GObjectClass parent_class;
};

struct _BTagIteratorPrivate {
	BTag* tag;
	BTag* next_tag;
};

static gint BTag_private_offset;
static gpointer b_tag_parent_class = NULL;
static gint BTagIterator_private_offset;
static gpointer b_tag_iterator_parent_class = NULL;

VALA_EXTERN GType b_xml_string_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType b_xml_data_get_type (void) G_GNUC_CONST ;
VALA_EXTERN BTag* b_tag_new (BXmlString* name,
                 BXmlString* attributes,
                 BXmlString* content,
                 gint log_level,
                 BXmlData* entire_file,
                 BTag* parent);
VALA_EXTERN BTag* b_tag_construct (GType object_type,
                       BXmlString* name,
                       BXmlString* attributes,
                       BXmlString* content,
                       gint log_level,
                       BXmlData* entire_file,
                       BTag* parent);
VALA_EXTERN gboolean b_tag_get_error (BTag* self);
VALA_EXTERN BTag* b_tag_new_empty (void);
VALA_EXTERN BTag* b_tag_construct_empty (GType object_type);
VALA_EXTERN BXmlData* b_xml_data_new (gchar* data,
                          gint length,
                          gint log_level);
VALA_EXTERN BXmlData* b_xml_data_construct (GType object_type,
                                gchar* data,
                                gint length,
                                gint log_level);
VALA_EXTERN BXmlString* b_xml_string_new (gchar* data,
                              gint length);
VALA_EXTERN BXmlString* b_xml_string_construct (GType object_type,
                                    gchar* data,
                                    gint length);
VALA_EXTERN BAttributes* b_attributes_new (BTag* t);
VALA_EXTERN BAttributes* b_attributes_construct (GType object_type,
                                     BTag* t);
VALA_EXTERN BTagIterator* b_tag_iterator_new (BTag* t);
VALA_EXTERN BTagIterator* b_tag_iterator_construct (GType object_type,
                                        BTag* t);
static BTag* b_tag_obtain_next_tag (BTag* self);
VALA_EXTERN void b_tag_reparse_attributes (BTag* self);
VALA_EXTERN BAttribute* b_tag_obtain_next_attribute (BTag* self);
VALA_EXTERN gchar* b_xml_string_to_string (BXmlString* self);
VALA_EXTERN gboolean b_tag_has_more_tags (BTag* self);
VALA_EXTERN BTag* b_tag_get_next_tag (BTag* self);
VALA_EXTERN gboolean b_tag_has_more_attributes (BTag* self);
VALA_EXTERN BAttribute* b_tag_get_next_attribute (BTag* self);
VALA_EXTERN BAttribute* b_attribute_new_empty (void);
VALA_EXTERN BAttribute* b_attribute_construct_empty (GType object_type);
VALA_EXTERN gboolean b_tag_has_failed (BTag* self);
static BTag* b_tag_find_next_tag (BTag* self,
                           gint start,
                           gint* end_tag_index);
VALA_EXTERN void b_tag_warn (BTag* self,
                 const gchar* message);
VALA_EXTERN void b_tag_set_error (BTag* self,
                      gboolean value);
VALA_EXTERN gboolean b_xml_string_get_next_ascii_char (BXmlString* self,
                                           gint* index,
                                           gunichar* c);
VALA_EXTERN gint b_xml_string_find_next_tag_separator (BXmlString* self,
                                           gint start);
VALA_EXTERN BXmlString* b_xml_string_substring (BXmlString* self,
                                    gint offset,
                                    gint len);
VALA_EXTERN gboolean b_xml_string_has_prefix (BXmlString* self,
                                  const gchar* prefix);
static gint b_tag_find_end_of_tag (BTag* self,
                            gint start);
VALA_EXTERN gboolean b_xml_string_has_suffix (BXmlString* self,
                                  const gchar* suffix);
static gint b_tag_find_closing_tag (BTag* self,
                             BXmlString* name,
                             gint start);
static gint b_tag_find_end_quote (BTag* self,
                           gint start);
VALA_EXTERN gint b_xml_string_index_of (BXmlString* self,
                            const gchar* needle,
                            gint offset);
VALA_EXTERN gint b_xml_data_get_index (BXmlData* self,
                           BXmlString* start);
VALA_EXTERN gint b_xml_data_find_next_tag_token (BXmlData* self,
                                     gint index);
static gchar* b_tag_parse_name (BTag* self,
                         BXmlData* data,
                         gint index);
VALA_EXTERN gint b_tag_get_row (BTag* self,
                    gsize pos);
static gboolean b_tag_is_tag (BTag* self,
                       BXmlString* tag,
                       BXmlString* name,
                       gint start);
static gboolean b_tag_is_self_closing (BTag* self,
                                BXmlData* tag,
                                gint start);
VALA_EXTERN BAttribute* b_attribute_new (BXmlString* ns,
                             BXmlString* name,
                             BXmlString* content);
VALA_EXTERN BAttribute* b_attribute_construct (GType object_type,
                                   BXmlString* ns,
                                   BXmlString* name,
                                   BXmlString* content);
VALA_EXTERN void b_xml_parser_warning (const gchar* message);
static void b_tag_iterator_finalize (GObject * obj);
static GType b_tag_iterator_get_type_once (void);
static void b_tag_finalize (GObject * obj);
static GType b_tag_get_type_once (void);
static void _vala_b_tag_get_property (GObject * object,
                               guint property_id,
                               GValue * value,
                               GParamSpec * pspec);
static void _vala_b_tag_set_property (GObject * object,
                               guint property_id,
                               const GValue * value,
                               GParamSpec * pspec);

static inline gpointer
b_tag_get_instance_private (BTag* self)
{
	return G_STRUCT_MEMBER_P (self, BTag_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BTag*
b_tag_construct (GType object_type,
                 BXmlString* name,
                 BXmlString* attributes,
                 BXmlString* content,
                 gint log_level,
                 BXmlData* entire_file,
                 BTag* parent)
{
	BTag * self = NULL;
	BXmlData* _tmp0_;
	BXmlString* _tmp1_;
	BXmlString* _tmp2_;
	BXmlString* _tmp3_;
	BTag* _tmp4_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (attributes != NULL, NULL);
	g_return_val_if_fail (content != NULL, NULL);
	g_return_val_if_fail (entire_file != NULL, NULL);
	self = (BTag*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (entire_file);
	_g_object_unref0 (self->entire_file);
	self->entire_file = _tmp0_;
	self->log_level = log_level;
	_tmp1_ = _g_object_ref0 (name);
	_g_object_unref0 (self->priv->name);
	self->priv->name = _tmp1_;
	_tmp2_ = _g_object_ref0 (content);
	_g_object_unref0 (self->priv->data);
	self->priv->data = _tmp2_;
	_tmp3_ = _g_object_ref0 (attributes);
	_g_object_unref0 (self->priv->attributes);
	self->priv->attributes = _tmp3_;
	_tmp4_ = _g_object_ref0 (parent);
	_g_object_unref0 (self->priv->parent);
	self->priv->parent = _tmp4_;
	if (parent != NULL) {
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp5_ = b_tag_get_error (G_TYPE_CHECK_INSTANCE_CAST (parent, B_TYPE_TAG, BTag));
		_tmp6_ = _tmp5_;
		self->priv->parser_error = _tmp6_;
	}
	return self;
}

BTag*
b_tag_new (BXmlString* name,
           BXmlString* attributes,
           BXmlString* content,
           gint log_level,
           BXmlData* entire_file,
           BTag* parent)
{
	return b_tag_construct (B_TYPE_TAG, name, attributes, content, log_level, entire_file, parent);
}

BTag*
b_tag_construct_empty (GType object_type)
{
	BTag * self = NULL;
	BXmlData* _tmp0_;
	BXmlString* _tmp1_;
	BXmlString* _tmp2_;
	BXmlString* _tmp3_;
	self = (BTag*) g_object_new (object_type, NULL);
	_tmp0_ = b_xml_data_new ("", 0, B_NONE);
	_g_object_unref0 (self->entire_file);
	self->entire_file = _tmp0_;
	_tmp1_ = b_xml_string_new ("", 0);
	_g_object_unref0 (self->priv->data);
	self->priv->data = _tmp1_;
	_tmp2_ = b_xml_string_new ("", 0);
	_g_object_unref0 (self->priv->attributes);
	self->priv->attributes = _tmp2_;
	_tmp3_ = b_xml_string_new ("", 0);
	_g_object_unref0 (self->priv->name);
	self->priv->name = _tmp3_;
	self->priv->parser_error = TRUE;
	return self;
}

BTag*
b_tag_new_empty (void)
{
	return b_tag_construct_empty (B_TYPE_TAG);
}

/** 
 * Get attributes for this tag. 
 * @return a container with all the attributes
 */
BAttributes*
b_tag_get_attributes (BTag* self)
{
	BAttributes* _tmp0_;
	BAttributes* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = b_attributes_new (self);
	result = _tmp0_;
	return result;
}

/** 
 * Iterate over all tags inside of this tag.
 */
BTagIterator*
b_tag_iterator (BTag* self)
{
	BTagIterator* _tmp0_;
	BTagIterator* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = b_tag_iterator_new (self);
	result = _tmp0_;
	return result;
}

/** 
 * Reset the parser and start from the beginning XML tag.
 */
void
b_tag_reparse (BTag* self)
{
	BTag* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->tag_index = 0;
	_tmp0_ = b_tag_obtain_next_tag (self);
	_g_object_unref0 (self->priv->next_tag);
	self->priv->next_tag = _tmp0_;
	self->priv->parsed = TRUE;
}

void
b_tag_reparse_attributes (BTag* self)
{
	BAttribute* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->attribute_index = 0;
	_tmp0_ = b_tag_obtain_next_attribute (self);
	_g_object_unref0 (self->priv->next_attribute);
	self->priv->next_attribute = _tmp0_;
}

/** 
 * Get the name of the tag.
 * @return the name of this tag. 
 */
static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

gchar*
b_tag_get_namespace (BTag* self)
{
	gchar* name = NULL;
	BXmlString* _tmp0_;
	gchar* _tmp1_;
	gint namespace_separator = 0;
	const gchar* _tmp2_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->name;
	_tmp1_ = b_xml_string_to_string (_tmp0_);
	name = _tmp1_;
	_tmp2_ = name;
	namespace_separator = string_index_of (_tmp2_, ":", 0);
	if (namespace_separator == -1) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("");
		result = _tmp3_;
		_g_free0 (name);
		return result;
	}
	_tmp4_ = name;
	_tmp5_ = string_substring (_tmp4_, (glong) 0, (glong) namespace_separator);
	result = _tmp5_;
	_g_free0 (name);
	return result;
}

/** @return namespace for this tag. */
gchar*
b_tag_get_name (BTag* self)
{
	gchar* name = NULL;
	BXmlString* _tmp0_;
	gchar* _tmp1_;
	gint namespace_separator = 0;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gchar* _tmp6_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->name;
	_tmp1_ = b_xml_string_to_string (_tmp0_);
	name = _tmp1_;
	_tmp2_ = name;
	namespace_separator = string_index_of (_tmp2_, ":", 0);
	if (namespace_separator == -1) {
		result = name;
		return result;
	}
	_tmp3_ = name;
	_tmp4_ = strlen (":");
	_tmp5_ = _tmp4_;
	_tmp6_ = string_substring (_tmp3_, (glong) (namespace_separator + _tmp5_), (glong) -1);
	result = _tmp6_;
	_g_free0 (name);
	return result;
}

/** 
 * Get tag content.
 * @return data between the start and end tags.
 */
gchar*
b_tag_get_content (BTag* self)
{
	BXmlString* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->data;
	_tmp1_ = b_xml_string_to_string (_tmp0_);
	result = _tmp1_;
	return result;
}

/** 
 * @return true if there is one more tags left
 */
gboolean
b_tag_has_more_tags (BTag* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!self->priv->parsed) {
		b_tag_reparse (self);
		b_tag_reparse_attributes (self);
	}
	if (self->priv->has_tags) {
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = b_tag_get_error (self);
		_tmp2_ = _tmp1_;
		_tmp0_ = !_tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

/** @return the next tag. **/
BTag*
b_tag_get_next_tag (BTag* self)
{
	BTag* _tmp0_ = NULL;
	BTag* _tmp1_;
	BTag* r = NULL;
	BTag* _tmp5_;
	BTag* _tmp6_;
	BTag* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (!self->priv->parsed) {
		b_tag_reparse (self);
		b_tag_reparse_attributes (self);
	}
	_tmp1_ = self->priv->next_tag;
	if (_tmp1_ == NULL) {
		BTag* _tmp2_;
		_tmp2_ = b_tag_new_empty ();
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp2_;
	} else {
		BTag* _tmp3_;
		BTag* _tmp4_;
		_tmp3_ = self->priv->next_tag;
		_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, B_TYPE_TAG, BTag));
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = _g_object_ref0 (_tmp0_);
	r = _tmp5_;
	_tmp6_ = b_tag_obtain_next_tag (self);
	_g_object_unref0 (self->priv->next_tag);
	self->priv->next_tag = _tmp6_;
	result = r;
	_g_object_unref0 (_tmp0_);
	return result;
}

/** @return true is there is one or more attributes to obtain with get_next_attribute */
gboolean
b_tag_has_more_attributes (BTag* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!self->priv->parsed) {
		b_tag_reparse (self);
		b_tag_reparse_attributes (self);
	}
	if (self->priv->has_attributes) {
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = b_tag_get_error (self);
		_tmp2_ = _tmp1_;
		_tmp0_ = !_tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

/** @return next attribute. */
BAttribute*
b_tag_get_next_attribute (BTag* self)
{
	BAttribute* _tmp0_ = NULL;
	BAttribute* _tmp1_;
	BAttribute* r = NULL;
	BAttribute* _tmp5_;
	BAttribute* _tmp6_;
	BAttribute* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (!self->priv->parsed) {
		b_tag_reparse (self);
		b_tag_reparse_attributes (self);
	}
	_tmp1_ = self->priv->next_attribute;
	if (_tmp1_ == NULL) {
		BAttribute* _tmp2_;
		_tmp2_ = b_attribute_new_empty ();
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp2_;
	} else {
		BAttribute* _tmp3_;
		BAttribute* _tmp4_;
		_tmp3_ = self->priv->next_attribute;
		_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, B_TYPE_ATTRIBUTE, BAttribute));
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = _g_object_ref0 (_tmp0_);
	r = _tmp5_;
	_tmp6_ = b_tag_obtain_next_attribute (self);
	_g_object_unref0 (self->priv->next_attribute);
	self->priv->next_attribute = _tmp6_;
	result = r;
	_g_object_unref0 (_tmp0_);
	return result;
}

gboolean
b_tag_has_failed (BTag* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = b_tag_get_error (self);
	_tmp1_ = _tmp0_;
	result = _tmp1_;
	return result;
}

static BTag*
b_tag_obtain_next_tag (BTag* self)
{
	gint end_tag_index = 0;
	BTag* tag = NULL;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gint _tmp3_ = 0;
	BTag* _tmp4_;
	gboolean _tmp5_ = FALSE;
	BTag* _tmp8_;
	BTag* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = b_tag_get_error (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		BTag* _tmp2_;
		self->priv->has_tags = FALSE;
		_tmp2_ = b_tag_new_empty ();
		result = _tmp2_;
		_g_object_unref0 (tag);
		return result;
	}
	_tmp4_ = b_tag_find_next_tag (self, self->priv->tag_index, &_tmp3_);
	end_tag_index = _tmp3_;
	_g_object_unref0 (tag);
	tag = _tmp4_;
	if (end_tag_index != -1) {
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp6_ = b_tag_get_error (self);
		_tmp7_ = _tmp6_;
		_tmp5_ = _tmp7_ == FALSE;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		self->priv->tag_index = end_tag_index;
		self->priv->has_tags = TRUE;
		result = tag;
		return result;
	}
	self->priv->has_tags = FALSE;
	_tmp8_ = b_tag_new_empty ();
	result = _tmp8_;
	_g_object_unref0 (tag);
	return result;
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static BTag*
b_tag_find_next_tag (BTag* self,
                     gint start,
                     gint* end_tag_index)
{
	gint _vala_end_tag_index = 0;
	gint index = 0;
	gunichar c = 0U;
	gint separator = 0;
	gint end = 0;
	gint closing_tag = 0;
	BXmlString* d = NULL;
	BXmlString* name = NULL;
	BXmlString* attributes = NULL;
	BXmlString* content = NULL;
	gchar* tag_name = NULL;
	gboolean _tmp0_;
	gboolean _tmp1_;
	BXmlString* _tmp4_;
	BXmlString* _tmp5_;
	BXmlString* _tmp6_;
	BTag* _tmp55_;
	BTag* result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_end_tag_index = -1;
	_tmp0_ = b_tag_get_error (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		BTag* _tmp2_;
		_tmp2_ = b_tag_new_empty ();
		result = _tmp2_;
		_g_free0 (tag_name);
		_g_object_unref0 (content);
		_g_object_unref0 (attributes);
		_g_object_unref0 (name);
		_g_object_unref0 (d);
		if (end_tag_index) {
			*end_tag_index = _vala_end_tag_index;
		}
		return result;
	}
	if (G_UNLIKELY (start < 0)) {
		BTag* _tmp3_;
		b_tag_warn (self, "Negative index.");
		b_tag_set_error (self, TRUE);
		_tmp3_ = b_tag_new_empty ();
		result = _tmp3_;
		_g_free0 (tag_name);
		_g_object_unref0 (content);
		_g_object_unref0 (attributes);
		_g_object_unref0 (name);
		_g_object_unref0 (d);
		if (end_tag_index) {
			*end_tag_index = _vala_end_tag_index;
		}
		return result;
	}
	index = start;
	_tmp4_ = self->priv->data;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (d);
	d = _tmp5_;
	_tmp6_ = d;
	if (G_UNLIKELY (_tmp6_ == NULL)) {
		BTag* _tmp7_;
		b_tag_warn (self, "No data in xml string.");
		b_tag_set_error (self, TRUE);
		_tmp7_ = b_tag_new_empty ();
		result = _tmp7_;
		_g_free0 (tag_name);
		_g_object_unref0 (content);
		_g_object_unref0 (attributes);
		_g_object_unref0 (name);
		_g_object_unref0 (d);
		if (end_tag_index) {
			*end_tag_index = _vala_end_tag_index;
		}
		return result;
	}
	while (TRUE) {
		BXmlString* _tmp8_;
		gunichar _tmp9_ = 0U;
		gboolean _tmp10_;
		_tmp8_ = self->priv->data;
		_tmp10_ = b_xml_string_get_next_ascii_char (_tmp8_, &index, &_tmp9_);
		c = _tmp9_;
		if (!_tmp10_) {
			break;
		}
		if (c == ((gunichar) '<')) {
			BXmlString* _tmp11_;
			BXmlString* _tmp13_;
			BXmlString* _tmp14_;
			BXmlString* _tmp15_;
			gchar* _tmp16_;
			const gchar* _tmp17_;
			BXmlString* _tmp19_;
			BXmlString* _tmp20_;
			BXmlString* _tmp23_;
			BXmlString* _tmp24_;
			BXmlString* _tmp25_;
			BXmlString* _tmp50_;
			BXmlString* _tmp51_;
			BXmlString* _tmp52_;
			BXmlData* _tmp53_;
			BTag* _tmp54_;
			_tmp11_ = self->priv->data;
			separator = b_xml_string_find_next_tag_separator (_tmp11_, index);
			if (G_UNLIKELY (separator < 0)) {
				BTag* _tmp12_;
				b_tag_set_error (self, TRUE);
				b_tag_warn (self, "Expecting a separator.");
				_tmp12_ = b_tag_new_empty ();
				result = _tmp12_;
				_g_free0 (tag_name);
				_g_object_unref0 (content);
				_g_object_unref0 (attributes);
				_g_object_unref0 (name);
				_g_object_unref0 (d);
				if (end_tag_index) {
					*end_tag_index = _vala_end_tag_index;
				}
				return result;
			}
			_tmp13_ = self->priv->data;
			_tmp14_ = b_xml_string_substring (_tmp13_, index, separator - index);
			_g_object_unref0 (name);
			name = _tmp14_;
			_tmp15_ = name;
			_tmp16_ = b_xml_string_to_string (_tmp15_);
			_g_free0 (tag_name);
			tag_name = _tmp16_;
			_tmp17_ = tag_name;
			if (G_UNLIKELY (g_strcmp0 (_tmp17_, "") == 0)) {
				BTag* _tmp18_;
				b_tag_warn (self, "A tag without a name.");
				b_tag_set_error (self, TRUE);
				_tmp18_ = b_tag_new_empty ();
				result = _tmp18_;
				_g_free0 (tag_name);
				_g_object_unref0 (content);
				_g_object_unref0 (attributes);
				_g_object_unref0 (name);
				_g_object_unref0 (d);
				if (end_tag_index) {
					*end_tag_index = _vala_end_tag_index;
				}
				return result;
			}
			_tmp19_ = name;
			if (b_xml_string_has_prefix (_tmp19_, "!")) {
				continue;
			}
			_tmp20_ = name;
			if (G_UNLIKELY (b_xml_string_has_prefix (_tmp20_, "/"))) {
				BTag* _tmp21_;
				b_tag_warn (self, "Expecting a new tag. Found a closing tag.");
				b_tag_set_error (self, TRUE);
				_tmp21_ = b_tag_new_empty ();
				result = _tmp21_;
				_g_free0 (tag_name);
				_g_object_unref0 (content);
				_g_object_unref0 (attributes);
				_g_object_unref0 (name);
				_g_object_unref0 (d);
				if (end_tag_index) {
					*end_tag_index = _vala_end_tag_index;
				}
				return result;
			}
			end = b_tag_find_end_of_tag (self, separator);
			if (G_UNLIKELY (end == -1)) {
				BTag* _tmp22_;
				b_tag_set_error (self, TRUE);
				b_tag_warn (self, "Expecting >.");
				_tmp22_ = b_tag_new_empty ();
				result = _tmp22_;
				_g_free0 (tag_name);
				_g_object_unref0 (content);
				_g_object_unref0 (attributes);
				_g_object_unref0 (name);
				_g_object_unref0 (d);
				if (end_tag_index) {
					*end_tag_index = _vala_end_tag_index;
				}
				return result;
			}
			_tmp23_ = self->priv->data;
			_tmp24_ = b_xml_string_substring (_tmp23_, separator, end - separator);
			_g_object_unref0 (attributes);
			attributes = _tmp24_;
			_tmp25_ = attributes;
			if (b_xml_string_has_suffix (_tmp25_, "/")) {
				BXmlString* _tmp26_;
				BXmlString* _tmp27_;
				gunichar _tmp28_ = 0U;
				_tmp26_ = b_xml_string_new ("", 0);
				_g_object_unref0 (content);
				content = _tmp26_;
				_vala_end_tag_index = b_tag_find_end_of_tag (self, index);
				_tmp27_ = self->priv->data;
				b_xml_string_get_next_ascii_char (_tmp27_, &_vala_end_tag_index, &_tmp28_);
				c = _tmp28_;
			} else {
				BXmlString* _tmp29_;
				gunichar _tmp30_ = 0U;
				gboolean _tmp31_;
				BXmlString* _tmp37_;
				gboolean _tmp38_ = FALSE;
				BXmlString* _tmp45_;
				BXmlString* _tmp46_;
				BXmlString* _tmp48_;
				gunichar _tmp49_ = 0U;
				_tmp29_ = self->priv->data;
				_tmp31_ = b_xml_string_get_next_ascii_char (_tmp29_, &end, &_tmp30_);
				c = _tmp30_;
				if (G_UNLIKELY (!_tmp31_)) {
					b_tag_warn (self, "Unexpected end of data.");
					b_tag_set_error (self, TRUE);
					break;
				}
				if (G_UNLIKELY (c != ((gunichar) '>'))) {
					gchar* _tmp32_;
					gchar* _tmp33_;
					const gchar* _tmp34_;
					gchar* _tmp35_;
					gchar* _tmp36_;
					_tmp32_ = g_unichar_to_string (c);
					_tmp33_ = (gchar*) _tmp32_;
					_tmp34_ = string_to_string (_tmp33_);
					_tmp35_ = g_strconcat ("Expecting '>' found ", _tmp34_, NULL);
					_tmp36_ = _tmp35_;
					b_tag_warn (self, _tmp36_);
					_g_free0 (_tmp36_);
					_g_free0 (_tmp33_);
					b_tag_set_error (self, TRUE);
					break;
				}
				_tmp37_ = name;
				closing_tag = b_tag_find_closing_tag (self, _tmp37_, end);
				if (closing_tag == -1) {
					_tmp38_ = TRUE;
				} else {
					BXmlString* _tmp39_;
					_tmp39_ = self->priv->data;
					_tmp38_ = closing_tag >= _tmp39_->length;
				}
				if (G_UNLIKELY (_tmp38_)) {
					BXmlString* _tmp40_;
					gchar* _tmp41_;
					gchar* _tmp42_;
					gchar* _tmp43_;
					gchar* _tmp44_;
					_tmp40_ = name;
					_tmp41_ = b_xml_string_to_string (_tmp40_);
					_tmp42_ = _tmp41_;
					_tmp43_ = g_strconcat ("No closing tag for ", _tmp42_, NULL);
					_tmp44_ = _tmp43_;
					b_tag_warn (self, _tmp44_);
					_g_free0 (_tmp44_);
					_g_free0 (_tmp42_);
					b_tag_set_error (self, TRUE);
					break;
				}
				_tmp45_ = self->priv->data;
				_tmp46_ = b_xml_string_substring (_tmp45_, end, closing_tag - end);
				_g_object_unref0 (content);
				content = _tmp46_;
				_vala_end_tag_index = b_tag_find_end_of_tag (self, closing_tag);
				if (G_UNLIKELY (_vala_end_tag_index == -1)) {
					BTag* _tmp47_;
					b_tag_set_error (self, TRUE);
					b_tag_warn (self, "Expecting > for the closing tag.");
					_tmp47_ = b_tag_new_empty ();
					result = _tmp47_;
					_g_free0 (tag_name);
					_g_object_unref0 (content);
					_g_object_unref0 (attributes);
					_g_object_unref0 (name);
					_g_object_unref0 (d);
					if (end_tag_index) {
						*end_tag_index = _vala_end_tag_index;
					}
					return result;
				}
				_tmp48_ = self->priv->data;
				b_xml_string_get_next_ascii_char (_tmp48_, &_vala_end_tag_index, &_tmp49_);
				c = _tmp49_;
			}
			_tmp50_ = name;
			_tmp51_ = attributes;
			_tmp52_ = content;
			_tmp53_ = self->entire_file;
			_tmp54_ = b_tag_new (_tmp50_, _tmp51_, _tmp52_, self->log_level, _tmp53_, self);
			result = _tmp54_;
			_g_free0 (tag_name);
			_g_object_unref0 (content);
			_g_object_unref0 (attributes);
			_g_object_unref0 (name);
			_g_object_unref0 (d);
			if (end_tag_index) {
				*end_tag_index = _vala_end_tag_index;
			}
			return result;
		}
	}
	_tmp55_ = b_tag_new_empty ();
	result = _tmp55_;
	_g_free0 (tag_name);
	_g_object_unref0 (content);
	_g_object_unref0 (attributes);
	_g_object_unref0 (name);
	_g_object_unref0 (d);
	if (end_tag_index) {
		*end_tag_index = _vala_end_tag_index;
	}
	return result;
}

static gint
b_tag_find_end_of_tag (BTag* self,
                       gint start)
{
	gint index = 0;
	gint current = 0;
	gunichar c = 0U;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	index = start;
	current = start;
	while (TRUE) {
		BXmlString* _tmp0_;
		gunichar _tmp1_ = 0U;
		gboolean _tmp2_;
		_tmp0_ = self->priv->data;
		_tmp2_ = b_xml_string_get_next_ascii_char (_tmp0_, &index, &_tmp1_);
		c = _tmp1_;
		if (!_tmp2_) {
			break;
		}
		if (c == ((gunichar) '>')) {
			result = current;
			return result;
		}
		if (c == ((gunichar) '"')) {
			BXmlString* _tmp3_;
			gunichar _tmp4_ = 0U;
			index = b_tag_find_end_quote (self, index);
			if (index == -1) {
				break;
			}
			_tmp3_ = self->priv->data;
			b_xml_string_get_next_ascii_char (_tmp3_, &index, &_tmp4_);
			c = _tmp4_;
		}
		current = index;
	}
	b_tag_set_error (self, TRUE);
	b_tag_warn (self, "Tag not closed.");
	result = -1;
	return result;
}

static gint
b_tag_find_end_quote (BTag* self,
                      gint start)
{
	gint i = 0;
	BXmlString* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->data;
	i = b_xml_string_index_of (_tmp0_, "\"", start);
	if (G_UNLIKELY (i == -1)) {
		b_tag_warn (self, "Expecting end quote.");
		b_tag_set_error (self, TRUE);
	}
	result = i;
	return result;
}

static gint
b_tag_find_closing_tag (BTag* self,
                        BXmlString* name,
                        gint start)
{
	gint index = 0;
	gint slash_index = 0;
	gint previous_index = 0;
	gunichar c = 0U;
	gunichar slash = 0U;
	gint start_count = 0;
	gint tag_start = 0;
	gchar* tag_name = NULL;
	BXmlData* _tmp0_;
	BXmlString* _tmp1_;
	BXmlData* _tmp2_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	const gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (name != NULL, 0);
	index = start;
	slash_index = start;
	start_count = 1;
	if (G_UNLIKELY (name->length == 0)) {
		b_tag_set_error (self, TRUE);
		b_tag_warn (self, "No name for tag.");
		result = -1;
		_g_free0 (tag_name);
		return result;
	}
	_tmp0_ = self->entire_file;
	_tmp1_ = self->priv->data;
	index = b_xml_data_get_index (_tmp0_, _tmp1_) + start;
	_tmp2_ = self->entire_file;
	if (G_UNLIKELY (index >= ((BXmlString*) _tmp2_)->length)) {
		b_tag_warn (self, "Unexpected end of file");
		b_tag_set_error (self, TRUE);
		result = -1;
		_g_free0 (tag_name);
		return result;
	}
	while (TRUE) {
		BXmlData* _tmp16_;
		BXmlString* _tmp17_;
		BXmlData* _tmp18_;
		gunichar _tmp19_ = 0U;
		gboolean _tmp20_;
		while (TRUE) {
			gboolean _tmp3_ = FALSE;
			BXmlData* _tmp4_;
			BXmlData* _tmp11_;
			BXmlString* _tmp12_;
			BXmlString* _tmp13_;
			gboolean _tmp14_;
			BXmlData* _tmp15_;
			_tmp4_ = self->entire_file;
			if (index >= ((BXmlString*) _tmp4_)->length) {
				_tmp3_ = TRUE;
			} else {
				_tmp3_ = index == -1;
			}
			if (G_UNLIKELY (_tmp3_)) {
				gchar* _tmp5_;
				gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				_tmp5_ = b_xml_string_to_string (name);
				_tmp6_ = _tmp5_;
				_tmp7_ = g_strdup_printf ("%i", index);
				_tmp8_ = _tmp7_;
				_tmp9_ = g_strconcat ("No end tag for ", _tmp6_, ", end of file. index: ", _tmp8_, NULL);
				_tmp10_ = _tmp9_;
				b_tag_warn (self, _tmp10_);
				_g_free0 (_tmp10_);
				_g_free0 (_tmp8_);
				_g_free0 (_tmp6_);
				b_tag_set_error (self, TRUE);
				result = -1;
				_g_free0 (tag_name);
				return result;
			}
			_tmp11_ = self->entire_file;
			_tmp12_ = b_xml_string_substring ((BXmlString*) _tmp11_, index, -1);
			_tmp13_ = _tmp12_;
			_tmp14_ = b_xml_string_has_prefix (_tmp13_, "<");
			_g_object_unref0 (_tmp13_);
			if (_tmp14_) {
				break;
			}
			_tmp15_ = self->entire_file;
			index = b_xml_data_find_next_tag_token (_tmp15_, index + 1);
		}
		_tmp16_ = self->entire_file;
		_tmp17_ = self->priv->data;
		previous_index = index - b_xml_data_get_index (_tmp16_, _tmp17_);
		_tmp18_ = self->entire_file;
		_tmp20_ = b_xml_string_get_next_ascii_char ((BXmlString*) _tmp18_, &index, &_tmp19_);
		c = _tmp19_;
		if (G_UNLIKELY (!_tmp20_)) {
			b_tag_warn (self, "Unexpected end of file");
			b_tag_set_error (self, TRUE);
			break;
		}
		if (c == ((gunichar) '<')) {
			BXmlData* _tmp21_;
			gunichar _tmp22_ = 0U;
			BXmlData* _tmp23_;
			gchar* _tmp24_;
			const gchar* _tmp25_;
			gboolean _tmp30_ = FALSE;
			tag_start = index;
			slash_index = index;
			_tmp21_ = self->entire_file;
			b_xml_string_get_next_ascii_char ((BXmlString*) _tmp21_, &slash_index, &_tmp22_);
			slash = _tmp22_;
			_tmp23_ = self->entire_file;
			_tmp24_ = b_tag_parse_name (self, _tmp23_, tag_start);
			_g_free0 (tag_name);
			tag_name = _tmp24_;
			_tmp25_ = tag_name;
			if (G_UNLIKELY (g_strcmp0 (_tmp25_, "") == 0)) {
				gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				b_tag_warn (self, "Tag without name.");
				_tmp26_ = g_strdup_printf ("%i", b_tag_get_row (self, (gsize) tag_start));
				_tmp27_ = _tmp26_;
				_tmp28_ = g_strconcat ("Row: ", _tmp27_, NULL);
				_tmp29_ = _tmp28_;
				b_tag_warn (self, _tmp29_);
				_g_free0 (_tmp29_);
				_g_free0 (_tmp27_);
				b_tag_set_error (self, TRUE);
				result = -1;
				_g_free0 (tag_name);
				return result;
			}
			if (slash == ((gunichar) '/')) {
				BXmlData* _tmp31_;
				_tmp31_ = self->entire_file;
				_tmp30_ = b_tag_is_tag (self, (BXmlString*) _tmp31_, name, slash_index);
			} else {
				_tmp30_ = FALSE;
			}
			if (_tmp30_) {
				if (start_count == 1) {
					result = previous_index;
					_g_free0 (tag_name);
					return result;
				} else {
					gint _tmp32_;
					_tmp32_ = start_count;
					start_count = _tmp32_ - 1;
					if (start_count == 0) {
						result = previous_index;
						_g_free0 (tag_name);
						return result;
					}
				}
			} else {
				BXmlData* _tmp33_;
				_tmp33_ = self->entire_file;
				if (b_tag_is_tag (self, (BXmlString*) _tmp33_, name, tag_start)) {
					BXmlData* _tmp34_;
					_tmp34_ = self->entire_file;
					if (!b_tag_is_self_closing (self, _tmp34_, tag_start)) {
						gint _tmp35_;
						_tmp35_ = start_count;
						start_count = _tmp35_ + 1;
					}
				}
			}
		}
	}
	b_tag_set_error (self, TRUE);
	_tmp36_ = b_xml_string_to_string (name);
	_tmp37_ = _tmp36_;
	_tmp38_ = string_to_string (_tmp37_);
	_tmp39_ = g_strconcat ("No closing tag for ", _tmp38_, NULL);
	_tmp40_ = _tmp39_;
	b_tag_warn (self, _tmp40_);
	_g_free0 (_tmp40_);
	_g_free0 (_tmp37_);
	result = -1;
	_g_free0 (tag_name);
	return result;
}

static gboolean
string_get_prev_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (0 < (*index)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_prev_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		_vala_c = (gunichar) 0;
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

static gboolean
b_tag_is_self_closing (BTag* self,
                       BXmlData* tag,
                       gint start)
{
	BTag* all_tags = NULL;
	BTag* _tmp0_;
	BTag* _tmp1_;
	BXmlData* _tmp2_;
	BXmlData* _tmp3_;
	BTag* _tmp4_;
	BXmlData* _tmp5_;
	BXmlString* _tmp6_;
	gint index = 0;
	BTag* _tmp7_;
	gint end = 0;
	gunichar c_data = 0U;
	const gchar* s = NULL;
	const gchar* n = NULL;
	gchar* _tmp8_;
	gint closing_slash = 0;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tag != NULL, FALSE);
	_tmp0_ = b_tag_new_empty ();
	all_tags = _tmp0_;
	_tmp1_ = all_tags;
	_tmp2_ = self->entire_file;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_tmp1_->entire_file);
	_tmp1_->entire_file = _tmp3_;
	_tmp4_ = all_tags;
	_tmp5_ = self->entire_file;
	_tmp6_ = _g_object_ref0 ((BXmlString*) _tmp5_);
	_g_object_unref0 (_tmp4_->priv->data);
	_tmp4_->priv->data = _tmp6_;
	_tmp7_ = all_tags;
	index = b_tag_find_end_of_tag (_tmp7_, start);
	end = index;
	_tmp8_ = ((BXmlString*) tag)->data;
	n = (const gchar*) _tmp8_;
	closing_slash = start;
	_tmp9_ = n;
	g_return_val_if_fail (_tmp9_ != NULL, TRUE);
	_tmp10_ = n;
	s = (const gchar*) _tmp10_;
	while (TRUE) {
		gboolean _tmp11_ = FALSE;
		const gchar* _tmp12_;
		gunichar _tmp13_ = 0U;
		gboolean _tmp14_;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_ = FALSE;
		_tmp12_ = s;
		_tmp14_ = string_get_prev_char (_tmp12_, &index, &_tmp13_);
		c_data = _tmp13_;
		if (_tmp14_) {
			_tmp11_ = index > start;
		} else {
			_tmp11_ = FALSE;
		}
		if (!_tmp11_) {
			break;
		}
		if (c_data == ((gunichar) '>')) {
			_tmp18_ = TRUE;
		} else {
			_tmp18_ = c_data == ((gunichar) ' ');
		}
		if (_tmp18_) {
			_tmp17_ = TRUE;
		} else {
			_tmp17_ = c_data == ((gunichar) '\t');
		}
		if (_tmp17_) {
			_tmp16_ = TRUE;
		} else {
			_tmp16_ = c_data == ((gunichar) '\n');
		}
		if (_tmp16_) {
			_tmp15_ = TRUE;
		} else {
			_tmp15_ = c_data == ((gunichar) '\r');
		}
		if (_tmp15_) {
			continue;
		}
		if (c_data == ((gunichar) '/')) {
			result = TRUE;
			_g_object_unref0 (all_tags);
			return result;
		} else {
			result = FALSE;
			_g_object_unref0 (all_tags);
			return result;
		}
	}
	result = FALSE;
	_g_object_unref0 (all_tags);
	return result;
}

static gchar*
b_tag_parse_name (BTag* self,
                  BXmlData* data,
                  gint index)
{
	gint slash_offset = 0;
	BXmlString* _tmp0_;
	BXmlString* _tmp1_;
	gboolean _tmp2_;
	gint separator = 0;
	gint _tmp5_;
	BXmlString* _tmp7_;
	BXmlString* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	slash_offset = 0;
	_tmp0_ = b_xml_string_substring ((BXmlString*) data, index, -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = b_xml_string_has_prefix (_tmp1_, "/");
	_g_object_unref0 (_tmp1_);
	if (_tmp2_) {
		gint _tmp3_;
		gint _tmp4_;
		_tmp3_ = strlen ("/");
		_tmp4_ = _tmp3_;
		slash_offset = _tmp4_;
		index = index + slash_offset;
	}
	separator = b_xml_string_find_next_tag_separator ((BXmlString*) data, index);
	_tmp5_ = separator;
	if (G_UNLIKELY (!((0 <= _tmp5_) && (_tmp5_ < ((BXmlString*) data)->length)))) {
		gchar* _tmp6_;
		b_tag_warn (self, "Tag without name.");
		_tmp6_ = g_strdup ("");
		result = _tmp6_;
		return result;
	}
	_tmp7_ = b_xml_string_substring ((BXmlString*) data, index - slash_offset, (separator - index) + slash_offset);
	_tmp8_ = _tmp7_;
	_tmp9_ = b_xml_string_to_string (_tmp8_);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp8_);
	result = _tmp10_;
	return result;
}

static gboolean
b_tag_is_tag (BTag* self,
              BXmlString* tag,
              BXmlString* name,
              gint start)
{
	gint index = 0;
	gint data_index = 0;
	gunichar c = 0U;
	gunichar c_data = 0U;
	gunichar _tmp4_ = 0U;
	gboolean _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tag != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	index = 0;
	data_index = start;
	while (TRUE) {
		gunichar _tmp0_ = 0U;
		gboolean _tmp1_;
		gunichar _tmp2_ = 0U;
		gboolean _tmp3_;
		_tmp1_ = b_xml_string_get_next_ascii_char (name, &index, &_tmp0_);
		c = _tmp0_;
		if (!_tmp1_) {
			break;
		}
		_tmp3_ = b_xml_string_get_next_ascii_char (tag, &data_index, &_tmp2_);
		c_data = _tmp2_;
		if (_tmp3_) {
			if (c_data != c) {
				result = FALSE;
				return result;
			}
		}
	}
	_tmp5_ = b_xml_string_get_next_ascii_char (tag, &data_index, &_tmp4_);
	c_data = _tmp4_;
	if (_tmp5_) {
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		if (c_data == ((gunichar) '>')) {
			_tmp10_ = TRUE;
		} else {
			_tmp10_ = c_data == ((gunichar) ' ');
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			_tmp9_ = c_data == ((gunichar) '\t');
		}
		if (_tmp9_) {
			_tmp8_ = TRUE;
		} else {
			_tmp8_ = c_data == ((gunichar) '\n');
		}
		if (_tmp8_) {
			_tmp7_ = TRUE;
		} else {
			_tmp7_ = c_data == ((gunichar) '\r');
		}
		if (_tmp7_) {
			_tmp6_ = TRUE;
		} else {
			_tmp6_ = c_data == ((gunichar) '/');
		}
		result = _tmp6_;
		return result;
	}
	result = FALSE;
	return result;
}

BAttribute*
b_tag_obtain_next_attribute (BTag* self)
{
	gint previous_index = 0;
	gint index = 0;
	gint name_start = 0;
	BXmlString* attribute_name = NULL;
	BXmlString* ns = NULL;
	BXmlString* content = NULL;
	gint ns_separator = 0;
	gint content_start = 0;
	gint content_stop = 0;
	gunichar quote = 0U;
	gunichar c = 0U;
	gboolean _tmp0_;
	gboolean _tmp1_;
	BXmlString* _tmp24_;
	BXmlString* _tmp25_;
	BXmlString* _tmp26_;
	BXmlString* _tmp27_;
	BXmlString* _tmp28_;
	BXmlString* _tmp73_;
	BXmlString* _tmp74_;
	BXmlString* _tmp75_;
	BXmlString* _tmp76_;
	BXmlString* _tmp77_;
	BAttribute* _tmp78_;
	BAttribute* result;
	g_return_val_if_fail (self != NULL, NULL);
	index = self->priv->attribute_index;
	_tmp0_ = b_tag_get_error (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		BAttribute* _tmp2_;
		_tmp2_ = b_attribute_new_empty ();
		result = _tmp2_;
		_g_object_unref0 (content);
		_g_object_unref0 (ns);
		_g_object_unref0 (attribute_name);
		return result;
	}
	while (TRUE) {
		BXmlString* _tmp3_;
		gunichar _tmp4_ = 0U;
		gboolean _tmp5_;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		previous_index = index;
		_tmp3_ = self->priv->attributes;
		_tmp5_ = b_xml_string_get_next_ascii_char (_tmp3_, &index, &_tmp4_);
		c = _tmp4_;
		if (!_tmp5_) {
			BAttribute* _tmp6_;
			self->priv->has_attributes = FALSE;
			_tmp6_ = b_attribute_new_empty ();
			result = _tmp6_;
			_g_object_unref0 (content);
			_g_object_unref0 (ns);
			_g_object_unref0 (attribute_name);
			return result;
		}
		if (c == ((gunichar) ' ')) {
			_tmp10_ = TRUE;
		} else {
			_tmp10_ = c == ((gunichar) '\t');
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			_tmp9_ = c == ((gunichar) '\n');
		}
		if (_tmp9_) {
			_tmp8_ = TRUE;
		} else {
			_tmp8_ = c == ((gunichar) '\r');
		}
		if (_tmp8_) {
			_tmp7_ = TRUE;
		} else {
			_tmp7_ = c == ((gunichar) '/');
		}
		if (!_tmp7_) {
			break;
		}
	}
	name_start = previous_index;
	while (TRUE) {
		BXmlString* _tmp11_;
		gunichar _tmp12_ = 0U;
		gboolean _tmp13_;
		gboolean _tmp20_ = FALSE;
		gboolean _tmp21_ = FALSE;
		gboolean _tmp22_ = FALSE;
		gboolean _tmp23_ = FALSE;
		previous_index = index;
		_tmp11_ = self->priv->attributes;
		_tmp13_ = b_xml_string_get_next_ascii_char (_tmp11_, &index, &_tmp12_);
		c = _tmp12_;
		if (!_tmp13_) {
			BXmlString* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			BAttribute* _tmp19_;
			b_tag_set_error (self, TRUE);
			_tmp14_ = self->priv->name;
			_tmp15_ = b_xml_string_to_string (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = g_strconcat ("Unexpected end of attributes in tag ", _tmp16_, NULL);
			_tmp18_ = _tmp17_;
			b_tag_warn (self, _tmp18_);
			_g_free0 (_tmp18_);
			_g_free0 (_tmp16_);
			self->priv->has_attributes = FALSE;
			_tmp19_ = b_attribute_new_empty ();
			result = _tmp19_;
			_g_object_unref0 (content);
			_g_object_unref0 (ns);
			_g_object_unref0 (attribute_name);
			return result;
		}
		if (c == ((gunichar) ' ')) {
			_tmp23_ = TRUE;
		} else {
			_tmp23_ = c == ((gunichar) '\t');
		}
		if (_tmp23_) {
			_tmp22_ = TRUE;
		} else {
			_tmp22_ = c == ((gunichar) '=');
		}
		if (_tmp22_) {
			_tmp21_ = TRUE;
		} else {
			_tmp21_ = c == ((gunichar) '\n');
		}
		if (_tmp21_) {
			_tmp20_ = TRUE;
		} else {
			_tmp20_ = c == ((gunichar) '\r');
		}
		if (_tmp20_) {
			break;
		}
	}
	_tmp24_ = self->priv->attributes;
	_tmp25_ = b_xml_string_substring (_tmp24_, name_start, previous_index - name_start);
	_g_object_unref0 (attribute_name);
	attribute_name = _tmp25_;
	_tmp26_ = attribute_name;
	index = name_start + _tmp26_->length;
	_tmp27_ = b_xml_string_new ("", 0);
	_g_object_unref0 (ns);
	ns = _tmp27_;
	_tmp28_ = attribute_name;
	ns_separator = b_xml_string_index_of (_tmp28_, ":", 0);
	if (ns_separator != -1) {
		BXmlString* _tmp29_;
		BXmlString* _tmp30_;
		BXmlString* _tmp31_;
		BXmlString* _tmp32_;
		_tmp29_ = attribute_name;
		_tmp30_ = b_xml_string_substring (_tmp29_, 0, ns_separator);
		_g_object_unref0 (ns);
		ns = _tmp30_;
		_tmp31_ = attribute_name;
		_tmp32_ = b_xml_string_substring (_tmp31_, ns_separator + 1, -1);
		_g_object_unref0 (attribute_name);
		attribute_name = _tmp32_;
	}
	while (TRUE) {
		BXmlString* _tmp33_;
		gunichar _tmp34_ = 0U;
		gboolean _tmp35_;
		gboolean _tmp36_ = FALSE;
		gboolean _tmp37_ = FALSE;
		gboolean _tmp38_ = FALSE;
		_tmp33_ = self->priv->attributes;
		_tmp35_ = b_xml_string_get_next_ascii_char (_tmp33_, &index, &_tmp34_);
		c = _tmp34_;
		if (!_tmp35_) {
			break;
		}
		if (c == ((gunichar) ' ')) {
			_tmp38_ = TRUE;
		} else {
			_tmp38_ = c == ((gunichar) '\t');
		}
		if (_tmp38_) {
			_tmp37_ = TRUE;
		} else {
			_tmp37_ = c == ((gunichar) '\n');
		}
		if (_tmp37_) {
			_tmp36_ = TRUE;
		} else {
			_tmp36_ = c == ((gunichar) '\r');
		}
		if (!_tmp36_) {
			if (G_LIKELY (c == ((gunichar) '='))) {
				break;
			} else {
				BXmlString* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				BXmlString* _tmp44_;
				gchar* _tmp45_;
				gchar* _tmp46_;
				gchar* _tmp47_;
				gchar* _tmp48_;
				gchar* _tmp49_;
				BAttribute* _tmp50_;
				self->priv->has_attributes = FALSE;
				b_tag_set_error (self, TRUE);
				_tmp39_ = attribute_name;
				_tmp40_ = b_xml_string_to_string (_tmp39_);
				_tmp41_ = _tmp40_;
				_tmp42_ = g_strconcat ("Expecting equal sign for attribute ", _tmp41_, ".", NULL);
				_tmp43_ = _tmp42_;
				b_tag_warn (self, _tmp43_);
				_g_free0 (_tmp43_);
				_g_free0 (_tmp41_);
				_tmp44_ = self->priv->attributes;
				_tmp45_ = _tmp44_->data;
				_tmp46_ = g_strdup_printf ("%i", b_tag_get_row (self, ((gsize) _tmp45_) + index));
				_tmp47_ = _tmp46_;
				_tmp48_ = g_strconcat ("Row: ", _tmp47_, NULL);
				_tmp49_ = _tmp48_;
				b_tag_warn (self, _tmp49_);
				_g_free0 (_tmp49_);
				_g_free0 (_tmp47_);
				_tmp50_ = b_attribute_new_empty ();
				result = _tmp50_;
				_g_object_unref0 (content);
				_g_object_unref0 (ns);
				_g_object_unref0 (attribute_name);
				return result;
			}
		}
	}
	while (TRUE) {
		BXmlString* _tmp51_;
		gunichar _tmp52_ = 0U;
		gboolean _tmp53_;
		gboolean _tmp54_ = FALSE;
		gboolean _tmp55_ = FALSE;
		gboolean _tmp56_ = FALSE;
		_tmp51_ = self->priv->attributes;
		_tmp53_ = b_xml_string_get_next_ascii_char (_tmp51_, &index, &_tmp52_);
		c = _tmp52_;
		if (!_tmp53_) {
			break;
		}
		if (c == ((gunichar) ' ')) {
			_tmp56_ = TRUE;
		} else {
			_tmp56_ = c == ((gunichar) '\t');
		}
		if (_tmp56_) {
			_tmp55_ = TRUE;
		} else {
			_tmp55_ = c == ((gunichar) '\n');
		}
		if (_tmp55_) {
			_tmp54_ = TRUE;
		} else {
			_tmp54_ = c == ((gunichar) '\r');
		}
		if (!_tmp54_) {
			gboolean _tmp57_ = FALSE;
			if (c == ((gunichar) '"')) {
				_tmp57_ = TRUE;
			} else {
				_tmp57_ = c == ((gunichar) '\'');
			}
			if (G_LIKELY (_tmp57_)) {
				break;
			} else {
				BXmlString* _tmp58_;
				gchar* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				gchar* _tmp62_;
				BAttribute* _tmp63_;
				self->priv->has_attributes = FALSE;
				b_tag_set_error (self, TRUE);
				_tmp58_ = attribute_name;
				_tmp59_ = b_xml_string_to_string (_tmp58_);
				_tmp60_ = _tmp59_;
				_tmp61_ = g_strconcat ("Expecting quote for attribute ", _tmp60_, ".", NULL);
				_tmp62_ = _tmp61_;
				b_tag_warn (self, _tmp62_);
				_g_free0 (_tmp62_);
				_g_free0 (_tmp60_);
				_tmp63_ = b_attribute_new_empty ();
				result = _tmp63_;
				_g_object_unref0 (content);
				_g_object_unref0 (ns);
				_g_object_unref0 (attribute_name);
				return result;
			}
		}
	}
	quote = c;
	content_start = index;
	while (TRUE) {
		BXmlString* _tmp64_;
		gunichar _tmp65_ = 0U;
		gboolean _tmp66_;
		_tmp64_ = self->priv->attributes;
		_tmp66_ = b_xml_string_get_next_ascii_char (_tmp64_, &index, &_tmp65_);
		c = _tmp65_;
		if (G_UNLIKELY (!_tmp66_)) {
			BXmlString* _tmp67_;
			gchar* _tmp68_;
			gchar* _tmp69_;
			gchar* _tmp70_;
			gchar* _tmp71_;
			BAttribute* _tmp72_;
			self->priv->has_attributes = FALSE;
			b_tag_set_error (self, TRUE);
			_tmp67_ = attribute_name;
			_tmp68_ = b_xml_string_to_string (_tmp67_);
			_tmp69_ = _tmp68_;
			_tmp70_ = g_strconcat ("Expecting end quote for attribute ", _tmp69_, ".", NULL);
			_tmp71_ = _tmp70_;
			b_tag_warn (self, _tmp71_);
			_g_free0 (_tmp71_);
			_g_free0 (_tmp69_);
			_tmp72_ = b_attribute_new_empty ();
			result = _tmp72_;
			_g_object_unref0 (content);
			_g_object_unref0 (ns);
			_g_object_unref0 (attribute_name);
			return result;
		}
		if (c == quote) {
			break;
		}
	}
	content_stop = index - 1;
	_tmp73_ = self->priv->attributes;
	_tmp74_ = b_xml_string_substring (_tmp73_, content_start, content_stop - content_start);
	_g_object_unref0 (content);
	content = _tmp74_;
	self->priv->has_attributes = TRUE;
	self->priv->attribute_index = content_stop + 1;
	_tmp75_ = ns;
	_tmp76_ = attribute_name;
	_tmp77_ = content;
	_tmp78_ = b_attribute_new (_tmp75_, _tmp76_, _tmp77_);
	result = _tmp78_;
	_g_object_unref0 (content);
	_g_object_unref0 (ns);
	_g_object_unref0 (attribute_name);
	return result;
}

gint
b_tag_get_row (BTag* self,
               gsize pos)
{
	gint index = 0;
	gunichar c = 0U;
	gint row = 0;
	gsize e = 0UL;
	BXmlData* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	index = 0;
	row = 1;
	_tmp0_ = self->entire_file;
	_tmp1_ = ((BXmlString*) _tmp0_)->data;
	e = (gsize) _tmp1_;
	while (TRUE) {
		BXmlData* _tmp2_;
		gunichar _tmp3_ = 0U;
		gboolean _tmp4_;
		_tmp2_ = self->entire_file;
		_tmp4_ = b_xml_string_get_next_ascii_char ((BXmlString*) _tmp2_, &index, &_tmp3_);
		c = _tmp3_;
		if (!_tmp4_) {
			break;
		}
		if (c == ((gunichar) '\n')) {
			gint _tmp5_;
			_tmp5_ = row;
			row = _tmp5_ + 1;
		}
		if ((e + index) >= pos) {
			break;
		}
	}
	result = row;
	return result;
}

void
b_tag_warn (BTag* self,
            const gchar* message)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	b_xml_parser_warning (message);
}

gboolean
b_tag_get_error (BTag* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->parser_error;
	return result;
}

void
b_tag_set_error (BTag* self,
                 gboolean value)
{
	BTag* t = NULL;
	BTag* _tmp0_;
	BTag* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (self);
	t = _tmp0_;
	_tmp1_ = t;
	_tmp1_->priv->parser_error = value;
	while (TRUE) {
		BTag* _tmp2_;
		BTag* _tmp3_;
		BTag* _tmp4_;
		BTag* _tmp5_;
		BTag* _tmp6_;
		BTag* _tmp7_;
		_tmp2_ = t;
		_tmp3_ = _tmp2_->priv->parent;
		if (!(_tmp3_ != NULL)) {
			break;
		}
		_tmp4_ = t;
		_tmp5_ = _tmp4_->priv->parent;
		_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, B_TYPE_TAG, BTag));
		_g_object_unref0 (t);
		t = _tmp6_;
		_tmp7_ = t;
		_tmp7_->priv->parser_error = value;
	}
	_g_object_unref0 (t);
	g_object_notify_by_pspec ((GObject *) self, b_tag_properties[B_TAG_ERROR_PROPERTY]);
}

static inline gpointer
b_tag_iterator_get_instance_private (BTagIterator* self)
{
	return G_STRUCT_MEMBER_P (self, BTagIterator_private_offset);
}

BTagIterator*
b_tag_iterator_construct (GType object_type,
                          BTag* t)
{
	BTagIterator * self = NULL;
	BTag* _tmp0_;
	BTag* _tmp1_;
	g_return_val_if_fail (t != NULL, NULL);
	self = (BTagIterator*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (t);
	_g_object_unref0 (self->priv->tag);
	self->priv->tag = _tmp0_;
	_tmp1_ = self->priv->tag;
	b_tag_reparse (_tmp1_);
	return self;
}

BTagIterator*
b_tag_iterator_new (BTag* t)
{
	return b_tag_iterator_construct (B_TAG_TYPE_ITERATOR, t);
}

gboolean
b_tag_iterator_next (BTagIterator* self)
{
	BTag* _tmp0_;
	gboolean _tmp3_ = FALSE;
	BTag* _tmp4_;
	BTag* _tmp9_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->tag;
	if (b_tag_has_more_tags (_tmp0_)) {
		BTag* _tmp1_;
		BTag* _tmp2_;
		_tmp1_ = self->priv->tag;
		_tmp2_ = b_tag_get_next_tag (_tmp1_);
		_g_object_unref0 (self->priv->next_tag);
		self->priv->next_tag = _tmp2_;
	} else {
		_g_object_unref0 (self->priv->next_tag);
		self->priv->next_tag = NULL;
	}
	_tmp4_ = self->priv->next_tag;
	if (_tmp4_ != NULL) {
		BTag* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = self->priv->next_tag;
		_tmp6_ = b_tag_get_error (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, B_TYPE_TAG, BTag));
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_;
	} else {
		_tmp3_ = FALSE;
	}
	if (G_UNLIKELY (_tmp3_)) {
		BTag* _tmp8_;
		_g_object_unref0 (self->priv->next_tag);
		self->priv->next_tag = NULL;
		_tmp8_ = self->priv->tag;
		b_tag_set_error (_tmp8_, TRUE);
	}
	_tmp9_ = self->priv->next_tag;
	result = _tmp9_ != NULL;
	return result;
}

BTag*
b_tag_iterator_get (BTagIterator* self)
{
	BTag* _tmp0_;
	BTag* _tmp2_;
	BTag* _tmp3_;
	BTag* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->next_tag;
	if (G_UNLIKELY (_tmp0_ == NULL)) {
		BTag* _tmp1_;
		b_xml_parser_warning ("No tag is parsed yet.");
		_tmp1_ = b_tag_new_empty ();
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->priv->next_tag;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, B_TYPE_TAG, BTag));
	result = _tmp3_;
	return result;
}

static void
b_tag_iterator_class_init (BTagIteratorClass * klass,
                           gpointer klass_data)
{
	b_tag_iterator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BTagIterator_private_offset);
	G_OBJECT_CLASS (klass)->finalize = b_tag_iterator_finalize;
}

static void
b_tag_iterator_instance_init (BTagIterator * self,
                              gpointer klass)
{
	self->priv = b_tag_iterator_get_instance_private (self);
	self->priv->next_tag = NULL;
}

static void
b_tag_iterator_finalize (GObject * obj)
{
	BTagIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, B_TAG_TYPE_ITERATOR, BTagIterator);
	_g_object_unref0 (self->priv->tag);
	_g_object_unref0 (self->priv->next_tag);
	G_OBJECT_CLASS (b_tag_iterator_parent_class)->finalize (obj);
}

static GType
b_tag_iterator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BTagIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) b_tag_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BTagIterator), 0, (GInstanceInitFunc) b_tag_iterator_instance_init, NULL };
	GType b_tag_iterator_type_id;
	b_tag_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "BTagIterator", &g_define_type_info, 0);
	BTagIterator_private_offset = g_type_add_instance_private (b_tag_iterator_type_id, sizeof (BTagIteratorPrivate));
	return b_tag_iterator_type_id;
}

GType
b_tag_iterator_get_type (void)
{
	static volatile gsize b_tag_iterator_type_id__once = 0;
	if (g_once_init_enter (&b_tag_iterator_type_id__once)) {
		GType b_tag_iterator_type_id;
		b_tag_iterator_type_id = b_tag_iterator_get_type_once ();
		g_once_init_leave (&b_tag_iterator_type_id__once, b_tag_iterator_type_id);
	}
	return b_tag_iterator_type_id__once;
}

static void
b_tag_class_init (BTagClass * klass,
                  gpointer klass_data)
{
	b_tag_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BTag_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_b_tag_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_b_tag_set_property;
	G_OBJECT_CLASS (klass)->finalize = b_tag_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), B_TAG_ERROR_PROPERTY, b_tag_properties[B_TAG_ERROR_PROPERTY] = g_param_spec_boolean ("error", "error", "error", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
b_tag_instance_init (BTag * self,
                     gpointer klass)
{
	self->priv = b_tag_get_instance_private (self);
	self->priv->next_tag = NULL;
	self->priv->next_attribute = NULL;
	self->priv->parsed = FALSE;
	self->priv->parent = NULL;
}

static void
b_tag_finalize (GObject * obj)
{
	BTag * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, B_TYPE_TAG, BTag);
	_g_object_unref0 (self->entire_file);
	_g_object_unref0 (self->priv->name);
	_g_object_unref0 (self->priv->data);
	_g_object_unref0 (self->priv->attributes);
	_g_object_unref0 (self->priv->next_tag);
	_g_object_unref0 (self->priv->next_attribute);
	_g_object_unref0 (self->priv->parent);
	G_OBJECT_CLASS (b_tag_parent_class)->finalize (obj);
}

/**
 * Representation of one XML tag.
 */
static GType
b_tag_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BTagClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) b_tag_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BTag), 0, (GInstanceInitFunc) b_tag_instance_init, NULL };
	GType b_tag_type_id;
	b_tag_type_id = g_type_register_static (G_TYPE_OBJECT, "BTag", &g_define_type_info, 0);
	BTag_private_offset = g_type_add_instance_private (b_tag_type_id, sizeof (BTagPrivate));
	return b_tag_type_id;
}

GType
b_tag_get_type (void)
{
	static volatile gsize b_tag_type_id__once = 0;
	if (g_once_init_enter (&b_tag_type_id__once)) {
		GType b_tag_type_id;
		b_tag_type_id = b_tag_get_type_once ();
		g_once_init_leave (&b_tag_type_id__once, b_tag_type_id);
	}
	return b_tag_type_id__once;
}

static void
_vala_b_tag_get_property (GObject * object,
                          guint property_id,
                          GValue * value,
                          GParamSpec * pspec)
{
	BTag * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, B_TYPE_TAG, BTag);
	switch (property_id) {
		case B_TAG_ERROR_PROPERTY:
		g_value_set_boolean (value, b_tag_get_error (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_b_tag_set_property (GObject * object,
                          guint property_id,
                          const GValue * value,
                          GParamSpec * pspec)
{
	BTag * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, B_TYPE_TAG, BTag);
	switch (property_id) {
		case B_TAG_ERROR_PROPERTY:
		b_tag_set_error (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

