#include "nv_push_cl906f.h"

#include <stdio.h>






const char*
P_PARSE_NV906F_MTHD(uint16_t idx)
{
    switch (idx) {


    case NV906F_SET_OBJECT:
        return "NV906F_SET_OBJECT";
    case NV906F_ILLEGAL:
        return "NV906F_ILLEGAL";
    case NV906F_NOP:
        return "NV906F_NOP";
    case NV906F_SEMAPHOREA:
        return "NV906F_SEMAPHOREA";
    case NV906F_SEMAPHOREB:
        return "NV906F_SEMAPHOREB";
    case NV906F_SEMAPHOREC:
        return "NV906F_SEMAPHOREC";
    case NV906F_SEMAPHORED:
        return "NV906F_SEMAPHORED";
    case NV906F_NON_STALL_INTERRUPT:
        return "NV906F_NON_STALL_INTERRUPT";
    case NV906F_FB_FLUSH:
        return "NV906F_FB_FLUSH";
    case NV906F_MEM_OP_A:
        return "NV906F_MEM_OP_A";
    case NV906F_MEM_OP_B:
        return "NV906F_MEM_OP_B";
    case NV906F_SET_REFERENCE:
        return "NV906F_SET_REFERENCE";
    case NV906F_CRC_CHECK:
        return "NV906F_CRC_CHECK";
    case NV906F_YIELD:
        return "NV906F_YIELD";

    default:
        return "unknown method";
    }
}

void
P_DUMP_NV906F_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                         const char *prefix)
{
    UNUSED uint32_t parsed;
    switch (idx) {


  
    case NV906F_SET_OBJECT:

    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.NVCLASS = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 5) - 1);
        fprintf(fp, "%s.ENGINE = ", prefix);
        switch (parsed) {
        case NV906F_SET_OBJECT_ENGINE_SW:
            fprintf(fp, "SW\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
  
    case NV906F_ILLEGAL:

    
        parsed = data;
        fprintf(fp, "%s.HANDLE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NV906F_NOP:

    
        parsed = data;
        fprintf(fp, "%s.HANDLE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NV906F_SEMAPHOREA:

    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NV906F_SEMAPHOREB:

    
        parsed = (data >> 2) & ((1u << 30) - 1);
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NV906F_SEMAPHOREC:

    
        parsed = data;
        fprintf(fp, "%s.PAYLOAD = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NV906F_SEMAPHORED:

    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.OPERATION = ", prefix);
        switch (parsed) {
        case NV906F_SEMAPHORED_OPERATION_ACQUIRE:
            fprintf(fp, "ACQUIRE\n");
            break;
        case NV906F_SEMAPHORED_OPERATION_RELEASE:
            fprintf(fp, "RELEASE\n");
            break;
        case NV906F_SEMAPHORED_OPERATION_ACQ_GEQ:
            fprintf(fp, "ACQ_GEQ\n");
            break;
        case NV906F_SEMAPHORED_OPERATION_ACQ_AND:
            fprintf(fp, "ACQ_AND\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.ACQUIRE_SWITCH = ", prefix);
        switch (parsed) {
        case NV906F_SEMAPHORED_ACQUIRE_SWITCH_DISABLED:
            fprintf(fp, "DISABLED\n");
            break;
        case NV906F_SEMAPHORED_ACQUIRE_SWITCH_ENABLED:
            fprintf(fp, "ENABLED\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 20) & ((1u << 1) - 1);
        fprintf(fp, "%s.RELEASE_WFI = ", prefix);
        switch (parsed) {
        case NV906F_SEMAPHORED_RELEASE_WFI_EN:
            fprintf(fp, "EN\n");
            break;
        case NV906F_SEMAPHORED_RELEASE_WFI_DIS:
            fprintf(fp, "DIS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 24) & ((1u << 1) - 1);
        fprintf(fp, "%s.RELEASE_SIZE = ", prefix);
        switch (parsed) {
        case NV906F_SEMAPHORED_RELEASE_SIZE_16BYTE:
            fprintf(fp, "16BYTE\n");
            break;
        case NV906F_SEMAPHORED_RELEASE_SIZE_4BYTE:
            fprintf(fp, "4BYTE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
  
    case NV906F_NON_STALL_INTERRUPT:

    
        parsed = data;
        fprintf(fp, "%s.HANDLE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NV906F_FB_FLUSH:

    
        parsed = data;
        fprintf(fp, "%s.HANDLE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NV906F_MEM_OP_A:

    
        parsed = (data >> 2) & ((1u << 30) - 1);
        fprintf(fp, "%s.OPERAND_LOW = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 2) & ((1u << 28) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_ADDR = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 30) & ((1u << 2) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_TARGET = ", prefix);
        switch (parsed) {
        case NV906F_MEM_OP_A_TLB_INVALIDATE_TARGET_VID_MEM:
            fprintf(fp, "VID_MEM\n");
            break;
        case NV906F_MEM_OP_A_TLB_INVALIDATE_TARGET_SYS_MEM_COHERENT:
            fprintf(fp, "SYS_MEM_COHERENT\n");
            break;
        case NV906F_MEM_OP_A_TLB_INVALIDATE_TARGET_SYS_MEM_NONCOHERENT:
            fprintf(fp, "SYS_MEM_NONCOHERENT\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
  
    case NV906F_MEM_OP_B:

    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OPERAND_HIGH = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 27) & ((1u << 5) - 1);
        fprintf(fp, "%s.OPERATION = ", prefix);
        switch (parsed) {
        case NV906F_MEM_OP_B_OPERATION_SYSMEMBAR_FLUSH:
            fprintf(fp, "SYSMEMBAR_FLUSH\n");
            break;
        case NV906F_MEM_OP_B_OPERATION_SOFT_FLUSH:
            fprintf(fp, "SOFT_FLUSH\n");
            break;
        case NV906F_MEM_OP_B_OPERATION_MMU_TLB_INVALIDATE:
            fprintf(fp, "MMU_TLB_INVALIDATE\n");
            break;
        case NV906F_MEM_OP_B_OPERATION_L2_PEERMEM_INVALIDATE:
            fprintf(fp, "L2_PEERMEM_INVALIDATE\n");
            break;
        case NV906F_MEM_OP_B_OPERATION_L2_SYSMEM_INVALIDATE:
            fprintf(fp, "L2_SYSMEM_INVALIDATE\n");
            break;
        case NV906F_MEM_OP_B_OPERATION_L2_CLEAN_COMPTAGS:
            fprintf(fp, "L2_CLEAN_COMPTAGS\n");
            break;
        case NV906F_MEM_OP_B_OPERATION_L2_FLUSH_DIRTY:
            fprintf(fp, "L2_FLUSH_DIRTY\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.MMU_TLB_INVALIDATE_PDB = ", prefix);
        switch (parsed) {
        case NV906F_MEM_OP_B_MMU_TLB_INVALIDATE_PDB_ONE:
            fprintf(fp, "ONE\n");
            break;
        case NV906F_MEM_OP_B_MMU_TLB_INVALIDATE_PDB_ALL:
            fprintf(fp, "ALL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.MMU_TLB_INVALIDATE_GPC = ", prefix);
        switch (parsed) {
        case NV906F_MEM_OP_B_MMU_TLB_INVALIDATE_GPC_ENABLE:
            fprintf(fp, "ENABLE\n");
            break;
        case NV906F_MEM_OP_B_MMU_TLB_INVALIDATE_GPC_DISABLE:
            fprintf(fp, "DISABLE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
  
    case NV906F_SET_REFERENCE:

    
        parsed = data;
        fprintf(fp, "%s.COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NV906F_CRC_CHECK:

    
        parsed = data;
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NV906F_YIELD:

    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.OP = ", prefix);
        switch (parsed) {
        case NV906F_YIELD_OP_NOP:
            fprintf(fp, "NOP\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    default:
        fprintf(fp, "%s.VALUE = 0x%x\n", prefix, data);
        break;
    }
}
