/*---------------------------------------------------------*\
| RGBControllerKeyNames.h                                   |
|                                                           |
|   List of standardized names to represent keyboard keys   |
|   when naming LEDs on keyboard devices                    |
|                                                           |
|   Chris M (Dr_No)                             25 Jan 2022 |
|                                                           |
|   This file is part of the OpenRGB project                |
|   SPDX-License-Identifier: GPL-2.0-only                   |
\*---------------------------------------------------------*/

#pragma once

extern const char* KEY_EN_UNUSED;
extern const char* ZONE_EN_KEYBOARD;

extern const char* KEY_EN_ESCAPE;
extern const char* KEY_EN_F1;
extern const char* KEY_EN_F2;
extern const char* KEY_EN_F3;
extern const char* KEY_EN_F4;
extern const char* KEY_EN_F5;
extern const char* KEY_EN_F6;
extern const char* KEY_EN_F7;
extern const char* KEY_EN_F8;
extern const char* KEY_EN_F9;
extern const char* KEY_EN_F10;
extern const char* KEY_EN_F11;
extern const char* KEY_EN_F12;
extern const char* KEY_EN_PRINT_SCREEN;
extern const char* KEY_EN_SCROLL_LOCK;
extern const char* KEY_EN_PAUSE_BREAK;
extern const char* KEY_EN_POWER;

extern const char* KEY_EN_BACK_TICK;
extern const char* KEY_EN_1;
extern const char* KEY_EN_2;
extern const char* KEY_EN_3;
extern const char* KEY_EN_4;
extern const char* KEY_EN_5;
extern const char* KEY_EN_6;
extern const char* KEY_EN_7;
extern const char* KEY_EN_8;
extern const char* KEY_EN_9;
extern const char* KEY_EN_0;
extern const char* KEY_EN_MINUS;
extern const char* KEY_EN_PLUS;
extern const char* KEY_EN_EQUALS;
extern const char* KEY_EN_BACKSPACE;
extern const char* KEY_EN_INSERT;
extern const char* KEY_EN_HOME;
extern const char* KEY_EN_PAGE_UP;

extern const char* KEY_EN_TAB;
extern const char* KEY_EN_Q;
extern const char* KEY_EN_W;
extern const char* KEY_EN_E;
extern const char* KEY_EN_R;
extern const char* KEY_EN_T;
extern const char* KEY_EN_Y;
extern const char* KEY_EN_U;
extern const char* KEY_EN_I;
extern const char* KEY_EN_O;
extern const char* KEY_EN_P;
extern const char* KEY_EN_LEFT_BRACKET;
extern const char* KEY_EN_RIGHT_BRACKET;
extern const char* KEY_EN_BACK_SLASH;
extern const char* KEY_EN_ANSI_BACK_SLASH;
extern const char* KEY_EN_DELETE;
extern const char* KEY_EN_END;
extern const char* KEY_EN_PAGE_DOWN;

extern const char* KEY_EN_CAPS_LOCK;
extern const char* KEY_EN_A;
extern const char* KEY_EN_S;
extern const char* KEY_EN_D;
extern const char* KEY_EN_F;
extern const char* KEY_EN_G;
extern const char* KEY_EN_H;
extern const char* KEY_EN_J;
extern const char* KEY_EN_K;
extern const char* KEY_EN_L;
extern const char* KEY_EN_SEMICOLON;
extern const char* KEY_EN_QUOTE;
extern const char* KEY_EN_POUND;
extern const char* KEY_EN_ANSI_ENTER;
extern const char* KEY_EN_ISO_ENTER;

extern const char* KEY_EN_LEFT_SHIFT;
extern const char* KEY_EN_ISO_BACK_SLASH;
extern const char* KEY_EN_Z;
extern const char* KEY_EN_X;
extern const char* KEY_EN_C;
extern const char* KEY_EN_V;
extern const char* KEY_EN_B;
extern const char* KEY_EN_N;
extern const char* KEY_EN_M;
extern const char* KEY_EN_COMMA;
extern const char* KEY_EN_PERIOD;
extern const char* KEY_EN_FORWARD_SLASH;
extern const char* KEY_EN_RIGHT_SHIFT;
extern const char* KEY_EN_UP_ARROW;

extern const char* KEY_EN_LEFT_CONTROL;
extern const char* KEY_EN_LEFT_WINDOWS;
extern const char* KEY_EN_LEFT_FUNCTION;
extern const char* KEY_EN_LEFT_ALT;
extern const char* KEY_EN_SPACE;
extern const char* KEY_EN_RIGHT_ALT;
extern const char* KEY_EN_RIGHT_FUNCTION;
extern const char* KEY_EN_RIGHT_WINDOWS;
extern const char* KEY_EN_MENU;
extern const char* KEY_EN_RIGHT_CONTROL;
extern const char* KEY_EN_LEFT_ARROW;
extern const char* KEY_EN_DOWN_ARROW;
extern const char* KEY_EN_RIGHT_ARROW;

extern const char* KEY_EN_NUMPAD_LOCK;
extern const char* KEY_EN_NUMPAD_DIVIDE;
extern const char* KEY_EN_NUMPAD_TIMES;
extern const char* KEY_EN_NUMPAD_MINUS;
extern const char* KEY_EN_NUMPAD_PLUS;
extern const char* KEY_EN_NUMPAD_PERIOD;
extern const char* KEY_EN_NUMPAD_ENTER;
extern const char* KEY_EN_NUMPAD_0;
extern const char* KEY_EN_NUMPAD_1;
extern const char* KEY_EN_NUMPAD_2;
extern const char* KEY_EN_NUMPAD_3;
extern const char* KEY_EN_NUMPAD_4;
extern const char* KEY_EN_NUMPAD_5;
extern const char* KEY_EN_NUMPAD_6;
extern const char* KEY_EN_NUMPAD_7;
extern const char* KEY_EN_NUMPAD_8;
extern const char* KEY_EN_NUMPAD_9;

extern const char* KEY_EN_MEDIA_PLAY_PAUSE;
extern const char* KEY_EN_MEDIA_PREVIOUS;
extern const char* KEY_EN_MEDIA_NEXT;
extern const char* KEY_EN_MEDIA_STOP;
extern const char* KEY_EN_MEDIA_MUTE;
extern const char* KEY_EN_MEDIA_VOLUME_DOWN;
extern const char* KEY_EN_MEDIA_VOLUME_UP;

extern const char* KEY_JP_RO;
extern const char* KEY_JP_EJ;
extern const char* KEY_JP_ZENKAKU;
extern const char* KEY_JP_KANA;
extern const char* KEY_JP_HENKAN;
extern const char* KEY_JP_MUHENKAN;
extern const char* KEY_JP_YEN;
extern const char* KEY_JP_AT;
extern const char* KEY_JP_CHEVRON;
extern const char* KEY_JP_COLON;

extern const char* KEY_KR_HAN;
extern const char* KEY_KR_HANJA;

extern const char* KEY_NORD_AAL;
extern const char* KEY_NORD_A_OE;
extern const char* KEY_NORD_O_AE;
extern const char* KEY_NORD_HALF;
extern const char* KEY_NORD_HYPHEN;
extern const char* KEY_NORD_PLUS_QUESTION;
extern const char* KEY_NORD_ACUTE_GRAVE;
extern const char* KEY_NORD_DOTS_CARET;
extern const char* KEY_NORD_QUOTE;
extern const char* KEY_NORD_ANGLE_BRACKET;

extern const char* KEY_DE_ESZETT;
extern const char* KEY_DE_DIAERESIS_A;
extern const char* KEY_DE_DIAERESIS_O;
extern const char* KEY_DE_DIAERESIS_U;

extern const char* KEY_FR_SUPER_2;
extern const char* KEY_FR_AMPERSAND;
extern const char* KEY_FR_ACUTE_E;
extern const char* KEY_FR_DOUBLEQUOTE;
extern const char* KEY_FR_LEFT_PARENTHESIS;
extern const char* KEY_FR_GRAVE_E;
extern const char* KEY_FR_UNDERSCORE;
extern const char* KEY_FR_CEDILLA_C;
extern const char* KEY_FR_GRAVE_A;
extern const char* KEY_FR_RIGHT_PARENTHESIS;
extern const char* KEY_FR_DOLLAR;
extern const char* KEY_FR_GRAVE_U;
extern const char* KEY_FR_ASTERIX;
extern const char* KEY_FR_EXCLAIMATION;

extern const char* KEY_ES_OPEN_QUESTION_MARK;
extern const char* KEY_ES_TILDE;
extern const char* KEY_ES_ENIE;
extern const char* KEY_BR_TILDE;
