/* ChessEffect.c generated by valac 0.56.18, the Vala compiler
 * generated from ChessEffect.vala, do not modify */

/*
* Copyright (c) 2011-2013 Yorba Foundation
*               2013 Jens Bav
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "pantheon-photos-transitions.h"
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "io.elementary.photos.h"
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#define CHESS_EFFECT_DESIRED_FPS 25
#define CHESS_EFFECT_MIN_FPS 10
#define CHESS_EFFECT_SQUARE_SIZE 100
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define TYPE_CHESS_EFFECT_DESCRIPTOR (chess_effect_descriptor_get_type ())
#define CHESS_EFFECT_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_EFFECT_DESCRIPTOR, ChessEffectDescriptor))
#define CHESS_EFFECT_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_EFFECT_DESCRIPTOR, ChessEffectDescriptorClass))
#define IS_CHESS_EFFECT_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_EFFECT_DESCRIPTOR))
#define IS_CHESS_EFFECT_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_EFFECT_DESCRIPTOR))
#define CHESS_EFFECT_DESCRIPTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_EFFECT_DESCRIPTOR, ChessEffectDescriptorClass))

typedef struct _ChessEffectDescriptor ChessEffectDescriptor;
typedef struct _ChessEffectDescriptorClass ChessEffectDescriptorClass;
typedef struct _ChessEffectDescriptorPrivate ChessEffectDescriptorPrivate;
enum  {
	CHESS_EFFECT_DESCRIPTOR_0_PROPERTY,
	CHESS_EFFECT_DESCRIPTOR_NUM_PROPERTIES
};
static GParamSpec* chess_effect_descriptor_properties[CHESS_EFFECT_DESCRIPTOR_NUM_PROPERTIES];

#define TYPE_CHESS_EFFECT (chess_effect_get_type ())
#define CHESS_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_EFFECT, ChessEffect))
#define CHESS_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_EFFECT, ChessEffectClass))
#define IS_CHESS_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_EFFECT))
#define IS_CHESS_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_EFFECT))
#define CHESS_EFFECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_EFFECT, ChessEffectClass))

typedef struct _ChessEffect ChessEffect;
typedef struct _ChessEffectClass ChessEffectClass;
typedef struct _ChessEffectPrivate ChessEffectPrivate;
enum  {
	CHESS_EFFECT_0_PROPERTY,
	CHESS_EFFECT_NUM_PROPERTIES
};
static GParamSpec* chess_effect_properties[CHESS_EFFECT_NUM_PROPERTIES];

struct _ChessEffectDescriptor {
	ShotwellTransitionDescriptor parent_instance;
	ChessEffectDescriptorPrivate * priv;
};

struct _ChessEffectDescriptorClass {
	ShotwellTransitionDescriptorClass parent_class;
};

struct _ChessEffect {
	GObject parent_instance;
	ChessEffectPrivate * priv;
};

struct _ChessEffectClass {
	GObjectClass parent_class;
};

struct _ChessEffectPrivate {
	gdouble square_count_x;
	gdouble square_count_y;
};

static gpointer chess_effect_descriptor_parent_class = NULL;
static gint ChessEffect_private_offset;
static gpointer chess_effect_parent_class = NULL;
static SpitTransitionsEffectIface * chess_effect_spit_transitions_effect_parent_iface = NULL;

VALA_EXTERN GType chess_effect_descriptor_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ChessEffectDescriptor* chess_effect_descriptor_new (GFile* resource_directory);
VALA_EXTERN ChessEffectDescriptor* chess_effect_descriptor_construct (GType object_type,
                                                          GFile* resource_directory);
static const gchar* chess_effect_descriptor_real_get_id (ShotwellTransitionDescriptor* base);
static const gchar* chess_effect_descriptor_real_get_pluggable_name (ShotwellTransitionDescriptor* base);
static SpitTransitionsEffect* chess_effect_descriptor_real_create (ShotwellTransitionDescriptor* base,
                                                            SpitHostInterface* host);
VALA_EXTERN ChessEffect* chess_effect_new (void);
VALA_EXTERN ChessEffect* chess_effect_construct (GType object_type);
VALA_EXTERN GType chess_effect_get_type (void) G_GNUC_CONST ;
static GType chess_effect_descriptor_get_type_once (void);
static void chess_effect_real_get_fps (SpitTransitionsEffect* base,
                                gint* desired_fps,
                                gint* min_fps);
static void chess_effect_real_start (SpitTransitionsEffect* base,
                              SpitTransitionsVisuals* visuals,
                              SpitTransitionsMotion* motion);
static gboolean chess_effect_real_needs_clear_background (SpitTransitionsEffect* base);
static void chess_effect_real_paint (SpitTransitionsEffect* base,
                              SpitTransitionsVisuals* visuals,
                              SpitTransitionsMotion* motion,
                              cairo_t* ctx,
                              gint width,
                              gint height,
                              gint frame_number);
static void chess_effect_real_advance (SpitTransitionsEffect* base,
                                SpitTransitionsVisuals* visuals,
                                SpitTransitionsMotion* motion,
                                gint frame_number);
static void chess_effect_real_cancel (SpitTransitionsEffect* base);
static void chess_effect_finalize (GObject * obj);
static GType chess_effect_get_type_once (void);

ChessEffectDescriptor*
chess_effect_descriptor_construct (GType object_type,
                                   GFile* resource_directory)
{
	ChessEffectDescriptor * self = NULL;
	g_return_val_if_fail (resource_directory != NULL, NULL);
	self = (ChessEffectDescriptor*) shotwell_transition_descriptor_construct (object_type, resource_directory);
	return self;
}

ChessEffectDescriptor*
chess_effect_descriptor_new (GFile* resource_directory)
{
	return chess_effect_descriptor_construct (TYPE_CHESS_EFFECT_DESCRIPTOR, resource_directory);
}

static const gchar*
chess_effect_descriptor_real_get_id (ShotwellTransitionDescriptor* base)
{
	ChessEffectDescriptor * self;
	const gchar* result;
	self = (ChessEffectDescriptor*) base;
	result = "io.elementary.photos.transitions.chess";
	return result;
}

static const gchar*
chess_effect_descriptor_real_get_pluggable_name (ShotwellTransitionDescriptor* base)
{
	ChessEffectDescriptor * self;
	const gchar* result;
	self = (ChessEffectDescriptor*) base;
	result = _ ("Chess");
	return result;
}

static SpitTransitionsEffect*
chess_effect_descriptor_real_create (ShotwellTransitionDescriptor* base,
                                     SpitHostInterface* host)
{
	ChessEffectDescriptor * self;
	ChessEffect* _tmp0_;
	SpitTransitionsEffect* result;
	self = (ChessEffectDescriptor*) base;
	g_return_val_if_fail (host != NULL, NULL);
	_tmp0_ = chess_effect_new ();
	result = (SpitTransitionsEffect*) _tmp0_;
	return result;
}

static void
chess_effect_descriptor_class_init (ChessEffectDescriptorClass * klass,
                                    gpointer klass_data)
{
	chess_effect_descriptor_parent_class = g_type_class_peek_parent (klass);
	((ShotwellTransitionDescriptorClass *) klass)->get_id = (const gchar* (*) (ShotwellTransitionDescriptor*)) chess_effect_descriptor_real_get_id;
	((ShotwellTransitionDescriptorClass *) klass)->get_pluggable_name = (const gchar* (*) (ShotwellTransitionDescriptor*)) chess_effect_descriptor_real_get_pluggable_name;
	((ShotwellTransitionDescriptorClass *) klass)->create = (SpitTransitionsEffect* (*) (ShotwellTransitionDescriptor*, SpitHostInterface*)) chess_effect_descriptor_real_create;
}

static void
chess_effect_descriptor_instance_init (ChessEffectDescriptor * self,
                                       gpointer klass)
{
}

static GType
chess_effect_descriptor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ChessEffectDescriptorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_effect_descriptor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessEffectDescriptor), 0, (GInstanceInitFunc) chess_effect_descriptor_instance_init, NULL };
	GType chess_effect_descriptor_type_id;
	chess_effect_descriptor_type_id = g_type_register_static (TYPE_SHOTWELL_TRANSITION_DESCRIPTOR, "ChessEffectDescriptor", &g_define_type_info, 0);
	return chess_effect_descriptor_type_id;
}

GType
chess_effect_descriptor_get_type (void)
{
	static volatile gsize chess_effect_descriptor_type_id__once = 0;
	if (g_once_init_enter (&chess_effect_descriptor_type_id__once)) {
		GType chess_effect_descriptor_type_id;
		chess_effect_descriptor_type_id = chess_effect_descriptor_get_type_once ();
		g_once_init_leave (&chess_effect_descriptor_type_id__once, chess_effect_descriptor_type_id);
	}
	return chess_effect_descriptor_type_id__once;
}

static inline gpointer
chess_effect_get_instance_private (ChessEffect* self)
{
	return G_STRUCT_MEMBER_P (self, ChessEffect_private_offset);
}

ChessEffect*
chess_effect_construct (GType object_type)
{
	ChessEffect * self = NULL;
	self = (ChessEffect*) g_object_new (object_type, NULL);
	return self;
}

ChessEffect*
chess_effect_new (void)
{
	return chess_effect_construct (TYPE_CHESS_EFFECT);
}

static void
chess_effect_real_get_fps (SpitTransitionsEffect* base,
                           gint* desired_fps,
                           gint* min_fps)
{
	ChessEffect * self;
	gint _vala_desired_fps = 0;
	gint _vala_min_fps = 0;
	self = (ChessEffect*) base;
	_vala_desired_fps = CHESS_EFFECT_DESIRED_FPS;
	_vala_min_fps = CHESS_EFFECT_MIN_FPS;
	if (desired_fps) {
		*desired_fps = _vala_desired_fps;
	}
	if (min_fps) {
		*min_fps = _vala_min_fps;
	}
}

static void
chess_effect_real_start (SpitTransitionsEffect* base,
                         SpitTransitionsVisuals* visuals,
                         SpitTransitionsMotion* motion)
{
	ChessEffect * self;
	GdkRectangle _tmp0_ = {0};
	GdkRectangle _tmp1_;
	GdkRectangle _tmp2_ = {0};
	GdkRectangle _tmp3_;
	self = (ChessEffect*) base;
	g_return_if_fail (visuals != NULL);
	g_return_if_fail (motion != NULL);
	spit_transitions_visuals_get_to_pos (visuals, &_tmp0_);
	_tmp1_ = _tmp0_;
	self->priv->square_count_y = (gdouble) ((_tmp1_.height / CHESS_EFFECT_SQUARE_SIZE) + 2);
	spit_transitions_visuals_get_to_pos (visuals, &_tmp2_);
	_tmp3_ = _tmp2_;
	self->priv->square_count_x = (gdouble) ((_tmp3_.width / CHESS_EFFECT_SQUARE_SIZE) + 2);
}

static gboolean
chess_effect_real_needs_clear_background (SpitTransitionsEffect* base)
{
	ChessEffect * self;
	gboolean result;
	self = (ChessEffect*) base;
	result = TRUE;
	return result;
}

static void
chess_effect_real_paint (SpitTransitionsEffect* base,
                         SpitTransitionsVisuals* visuals,
                         SpitTransitionsMotion* motion,
                         cairo_t* ctx,
                         gint width,
                         gint height,
                         gint frame_number)
{
	ChessEffect * self;
	gdouble alpha = 0.0;
	gdouble size = 0.0;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp8_;
	GdkPixbuf* _tmp9_;
	self = (ChessEffect*) base;
	g_return_if_fail (visuals != NULL);
	g_return_if_fail (motion != NULL);
	g_return_if_fail (ctx != NULL);
	alpha = spit_transitions_motion_get_alpha (motion, frame_number);
	size = (2 * alpha) * CHESS_EFFECT_SQUARE_SIZE;
	_tmp0_ = spit_transitions_visuals_get_from_pixbuf (visuals);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		GdkPixbuf* _tmp2_;
		GdkPixbuf* _tmp3_;
		GdkRectangle _tmp4_ = {0};
		GdkRectangle _tmp5_;
		GdkRectangle _tmp6_ = {0};
		GdkRectangle _tmp7_;
		_tmp2_ = spit_transitions_visuals_get_from_pixbuf (visuals);
		_tmp3_ = _tmp2_;
		spit_transitions_visuals_get_from_pos (visuals, &_tmp4_);
		_tmp5_ = _tmp4_;
		spit_transitions_visuals_get_from_pos (visuals, &_tmp6_);
		_tmp7_ = _tmp6_;
		gdk_cairo_set_source_pixbuf (ctx, _tmp3_, (gdouble) _tmp5_.x, (gdouble) _tmp7_.y);
		cairo_paint_with_alpha (ctx, 1 - alpha);
	}
	_tmp8_ = spit_transitions_visuals_get_to_pixbuf (visuals);
	_tmp9_ = _tmp8_;
	if (_tmp9_ != NULL) {
		GdkPixbuf* _tmp10_;
		GdkPixbuf* _tmp11_;
		GdkRectangle _tmp12_ = {0};
		GdkRectangle _tmp13_;
		GdkRectangle _tmp14_ = {0};
		GdkRectangle _tmp15_;
		_tmp10_ = spit_transitions_visuals_get_to_pixbuf (visuals);
		_tmp11_ = _tmp10_;
		spit_transitions_visuals_get_to_pos (visuals, &_tmp12_);
		_tmp13_ = _tmp12_;
		spit_transitions_visuals_get_to_pos (visuals, &_tmp14_);
		_tmp15_ = _tmp14_;
		gdk_cairo_set_source_pixbuf (ctx, _tmp11_, (gdouble) _tmp13_.x, (gdouble) _tmp15_.y);
		{
			gdouble y = 0.0;
			y = (gdouble) 0;
			{
				gboolean _tmp16_ = FALSE;
				_tmp16_ = TRUE;
				while (TRUE) {
					if (!_tmp16_) {
						gdouble _tmp17_;
						_tmp17_ = y;
						y = _tmp17_ + 1;
					}
					_tmp16_ = FALSE;
					if (!(y <= self->priv->square_count_y)) {
						break;
					}
					{
						gdouble x = 0.0;
						x = (gdouble) 0;
						{
							gboolean _tmp18_ = FALSE;
							_tmp18_ = TRUE;
							while (TRUE) {
								gdouble _tmp20_ = 0.0;
								gdouble translation = 0.0;
								SpitTransitionsDirection _tmp21_;
								SpitTransitionsDirection _tmp22_;
								if (!_tmp18_) {
									gdouble _tmp19_;
									_tmp19_ = x;
									x = _tmp19_ + 1;
								}
								_tmp18_ = FALSE;
								if (!(x <= self->priv->square_count_x)) {
									break;
								}
								if (fmod (x + y, 2) == ((gdouble) 0)) {
									_tmp20_ = (-1.5) * CHESS_EFFECT_SQUARE_SIZE;
								} else {
									_tmp20_ = 1.5 * CHESS_EFFECT_SQUARE_SIZE;
								}
								translation = _tmp20_;
								_tmp21_ = spit_transitions_motion_get_direction (motion);
								_tmp22_ = _tmp21_;
								if (_tmp22_ == SPIT_TRANSITIONS_DIRECTION_FORWARD) {
									GdkRectangle _tmp23_ = {0};
									GdkRectangle _tmp24_;
									GdkRectangle _tmp25_ = {0};
									GdkRectangle _tmp26_;
									spit_transitions_visuals_get_to_pos (visuals, &_tmp23_);
									_tmp24_ = _tmp23_;
									spit_transitions_visuals_get_to_pos (visuals, &_tmp25_);
									_tmp26_ = _tmp25_;
									cairo_rectangle (ctx, (_tmp24_.x + translation) + (x * CHESS_EFFECT_SQUARE_SIZE), _tmp26_.y + (y * CHESS_EFFECT_SQUARE_SIZE), size, (gdouble) CHESS_EFFECT_SQUARE_SIZE);
								} else {
									GdkRectangle _tmp27_ = {0};
									GdkRectangle _tmp28_;
									GdkRectangle _tmp29_ = {0};
									GdkRectangle _tmp30_;
									GdkRectangle _tmp31_ = {0};
									GdkRectangle _tmp32_;
									spit_transitions_visuals_get_to_pos (visuals, &_tmp27_);
									_tmp28_ = _tmp27_;
									spit_transitions_visuals_get_to_pos (visuals, &_tmp29_);
									_tmp30_ = _tmp29_;
									spit_transitions_visuals_get_to_pos (visuals, &_tmp31_);
									_tmp32_ = _tmp31_;
									cairo_rectangle (ctx, (((_tmp28_.x + _tmp30_.width) + translation) - (x * CHESS_EFFECT_SQUARE_SIZE)) - size, _tmp32_.y + (y * CHESS_EFFECT_SQUARE_SIZE), size, (gdouble) CHESS_EFFECT_SQUARE_SIZE);
								}
							}
						}
					}
				}
			}
		}
		cairo_clip (ctx);
		cairo_paint_with_alpha (ctx, alpha);
	}
}

static void
chess_effect_real_advance (SpitTransitionsEffect* base,
                           SpitTransitionsVisuals* visuals,
                           SpitTransitionsMotion* motion,
                           gint frame_number)
{
	ChessEffect * self;
	self = (ChessEffect*) base;
	g_return_if_fail (visuals != NULL);
	g_return_if_fail (motion != NULL);
}

static void
chess_effect_real_cancel (SpitTransitionsEffect* base)
{
	ChessEffect * self;
	self = (ChessEffect*) base;
}

static void
chess_effect_class_init (ChessEffectClass * klass,
                         gpointer klass_data)
{
	chess_effect_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ChessEffect_private_offset);
	G_OBJECT_CLASS (klass)->finalize = chess_effect_finalize;
}

static void
chess_effect_spit_transitions_effect_interface_init (SpitTransitionsEffectIface * iface,
                                                     gpointer iface_data)
{
	chess_effect_spit_transitions_effect_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_fps = (void (*) (SpitTransitionsEffect*, gint*, gint*)) chess_effect_real_get_fps;
	iface->start = (void (*) (SpitTransitionsEffect*, SpitTransitionsVisuals*, SpitTransitionsMotion*)) chess_effect_real_start;
	iface->needs_clear_background = (gboolean (*) (SpitTransitionsEffect*)) chess_effect_real_needs_clear_background;
	iface->paint = (void (*) (SpitTransitionsEffect*, SpitTransitionsVisuals*, SpitTransitionsMotion*, cairo_t*, gint, gint, gint)) chess_effect_real_paint;
	iface->advance = (void (*) (SpitTransitionsEffect*, SpitTransitionsVisuals*, SpitTransitionsMotion*, gint)) chess_effect_real_advance;
	iface->cancel = (void (*) (SpitTransitionsEffect*)) chess_effect_real_cancel;
}

static void
chess_effect_instance_init (ChessEffect * self,
                            gpointer klass)
{
	self->priv = chess_effect_get_instance_private (self);
}

static void
chess_effect_finalize (GObject * obj)
{
	ChessEffect * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_EFFECT, ChessEffect);
	G_OBJECT_CLASS (chess_effect_parent_class)->finalize (obj);
}

static GType
chess_effect_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ChessEffectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_effect_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessEffect), 0, (GInstanceInitFunc) chess_effect_instance_init, NULL };
	static const GInterfaceInfo spit_transitions_effect_info = { (GInterfaceInitFunc) chess_effect_spit_transitions_effect_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType chess_effect_type_id;
	chess_effect_type_id = g_type_register_static (G_TYPE_OBJECT, "ChessEffect", &g_define_type_info, 0);
	g_type_add_interface_static (chess_effect_type_id, SPIT_TRANSITIONS_TYPE_EFFECT, &spit_transitions_effect_info);
	ChessEffect_private_offset = g_type_add_instance_private (chess_effect_type_id, sizeof (ChessEffectPrivate));
	return chess_effect_type_id;
}

GType
chess_effect_get_type (void)
{
	static volatile gsize chess_effect_type_id__once = 0;
	if (g_once_init_enter (&chess_effect_type_id__once)) {
		GType chess_effect_type_id;
		chess_effect_type_id = chess_effect_get_type_once ();
		g_once_init_leave (&chess_effect_type_id__once, chess_effect_type_id);
	}
	return chess_effect_type_id__once;
}

