/* Branch.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Branch.vala, do not modify */

/*
* Copyright (c) 2011-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SEARCHES_BRANCH_0_PROPERTY,
	SEARCHES_BRANCH_NUM_PROPERTIES
};
static GParamSpec* searches_branch_properties[SEARCHES_BRANCH_NUM_PROPERTIES];
#define _saved_search_table_unref0(var) ((var == NULL) ? NULL : (var = (saved_search_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	SEARCHES_GROUPING_0_PROPERTY,
	SEARCHES_GROUPING_NUM_PROPERTIES
};
static GParamSpec* searches_grouping_properties[SEARCHES_GROUPING_NUM_PROPERTIES];
enum  {
	SEARCHES_SIDEBAR_ENTRY_0_PROPERTY,
	SEARCHES_SIDEBAR_ENTRY_NUM_PROPERTIES
};
static GParamSpec* searches_sidebar_entry_properties[SEARCHES_SIDEBAR_ENTRY_NUM_PROPERTIES];
#define _command_manager_unref0(var) ((var == NULL) ? NULL : (var = (command_manager_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SearchesBranchPrivate {
	GeeHashMap* entry_map;
};

struct _SearchesGroupingPrivate {
	GtkMenu* context_menu;
};

struct _SearchesSidebarEntryPrivate {
	SavedSearch* search;
};

static gint SearchesBranch_private_offset;
static gpointer searches_branch_parent_class = NULL;
static gint SearchesGrouping_private_offset;
static gpointer searches_grouping_parent_class = NULL;
static SidebarContextableIface * searches_grouping_sidebar_contextable_parent_iface = NULL;
static gint SearchesSidebarEntry_private_offset;
static gpointer searches_sidebar_entry_parent_class = NULL;
static GIcon* searches_sidebar_entry_single_search_icon;
static GIcon* searches_sidebar_entry_single_search_icon = NULL;
static SidebarRenameableEntryIface * searches_sidebar_entry_sidebar_renameable_entry_parent_iface = NULL;
static SidebarDestroyableEntryIface * searches_sidebar_entry_sidebar_destroyable_entry_parent_iface = NULL;

static void searches_branch_on_saved_search_added (SearchesBranch* self,
                                            SavedSearch* search);
static void _searches_branch_on_saved_search_added_saved_search_table_search_added (SavedSearchTable* _sender,
                                                                             SavedSearch* search,
                                                                             gpointer self);
static void searches_branch_on_saved_search_removed (SearchesBranch* self,
                                              SavedSearch* search);
static void _searches_branch_on_saved_search_removed_saved_search_table_search_removed (SavedSearchTable* _sender,
                                                                                 SavedSearch* search,
                                                                                 gpointer self);
static gint searches_branch_comparator (SidebarEntry* a,
                                 SidebarEntry* b);
static gint _searches_branch_comparator_gcompare_func (gconstpointer a,
                                                gconstpointer b);
static void searches_branch_finalize (GObject * obj);
static GType searches_branch_get_type_once (void);
static GtkMenu* searches_grouping_real_get_sidebar_context_menu (SidebarContextable* base,
                                                          GdkEventButton* event);
static void ___lambda97_ (SearchesGrouping* self);
static void searches_grouping_on_new_search (SearchesGrouping* self);
static void ____lambda97__gtk_menu_item_activate (GtkMenuItem* _sender,
                                           gpointer self);
static void searches_grouping_finalize (GObject * obj);
static GType searches_grouping_get_type_once (void);
static gchar* searches_sidebar_entry_real_get_sidebar_name (SidebarSimplePageEntry* base);
static GIcon* searches_sidebar_entry_real_get_sidebar_icon (SidebarSimplePageEntry* base);
static Page* searches_sidebar_entry_real_create_page (SidebarSimplePageEntry* base);
static void searches_sidebar_entry_real_rename (SidebarRenameableEntry* base,
                                         const gchar* new_name);
static void searches_sidebar_entry_real_destroy_source (SidebarDestroyableEntry* base);
static void searches_sidebar_entry_finalize (GObject * obj);
static GType searches_sidebar_entry_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
searches_branch_get_instance_private (SearchesBranch* self)
{
	return G_STRUCT_MEMBER_P (self, SearchesBranch_private_offset);
}

static void
_searches_branch_on_saved_search_added_saved_search_table_search_added (SavedSearchTable* _sender,
                                                                        SavedSearch* search,
                                                                        gpointer self)
{
	searches_branch_on_saved_search_added ((SearchesBranch*) self, search);
}

static void
_searches_branch_on_saved_search_removed_saved_search_table_search_removed (SavedSearchTable* _sender,
                                                                            SavedSearch* search,
                                                                            gpointer self)
{
	searches_branch_on_saved_search_removed ((SearchesBranch*) self, search);
}

static gint
_searches_branch_comparator_gcompare_func (gconstpointer a,
                                           gconstpointer b)
{
	gint result;
	result = searches_branch_comparator ((SidebarEntry*) a, (SidebarEntry*) b);
	return result;
}

SearchesBranch*
searches_branch_construct (GType object_type)
{
	SearchesBranch * self = NULL;
	SearchesGrouping* _tmp0_;
	SearchesGrouping* _tmp1_;
	SavedSearchTable* _tmp12_;
	SavedSearchTable* _tmp13_;
	SavedSearchTable* _tmp14_;
	SavedSearchTable* _tmp15_;
	_tmp0_ = searches_grouping_new ();
	_tmp1_ = _tmp0_;
	self = (SearchesBranch*) sidebar_branch_construct (object_type, (SidebarEntry*) _tmp1_, (SIDEBAR_BRANCH_OPTIONS_HIDE_IF_EMPTY | SIDEBAR_BRANCH_OPTIONS_AUTO_OPEN_ON_NEW_CHILD) | SIDEBAR_BRANCH_OPTIONS_STARTUP_EXPAND_TO_FIRST_CHILD, _searches_branch_comparator_gcompare_func, NULL);
	_g_object_unref0 (_tmp1_);
	{
		GeeIterator* _search_it = NULL;
		SavedSearchTable* _tmp2_;
		SavedSearchTable* _tmp3_;
		GeeCollection* _tmp4_;
		GeeCollection* _tmp5_;
		GeeIterator* _tmp6_;
		GeeIterator* _tmp7_;
		_tmp2_ = saved_search_table_get_instance ();
		_tmp3_ = _tmp2_;
		_tmp4_ = saved_search_table_get_all (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
		_saved_search_table_unref0 (_tmp3_);
		_search_it = _tmp7_;
		while (TRUE) {
			GeeIterator* _tmp8_;
			SavedSearch* search = NULL;
			GeeIterator* _tmp9_;
			gpointer _tmp10_;
			SavedSearch* _tmp11_;
			_tmp8_ = _search_it;
			if (!gee_iterator_next (_tmp8_)) {
				break;
			}
			_tmp9_ = _search_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			search = (SavedSearch*) _tmp10_;
			_tmp11_ = search;
			searches_branch_on_saved_search_added (self, _tmp11_);
			_g_object_unref0 (search);
		}
		_g_object_unref0 (_search_it);
	}
	_tmp12_ = saved_search_table_get_instance ();
	_tmp13_ = _tmp12_;
	g_signal_connect_object (_tmp13_, "search-added", (GCallback) _searches_branch_on_saved_search_added_saved_search_table_search_added, self, 0);
	_saved_search_table_unref0 (_tmp13_);
	_tmp14_ = saved_search_table_get_instance ();
	_tmp15_ = _tmp14_;
	g_signal_connect_object (_tmp15_, "search-removed", (GCallback) _searches_branch_on_saved_search_removed_saved_search_table_search_removed, self, 0);
	_saved_search_table_unref0 (_tmp15_);
	return self;
}

SearchesBranch*
searches_branch_new (void)
{
	return searches_branch_construct (SEARCHES_TYPE_BRANCH);
}

SearchesSidebarEntry*
searches_branch_get_entry_for_saved_search (SearchesBranch* self,
                                            SavedSearch* search)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	SearchesSidebarEntry* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (search != NULL, NULL);
	_tmp0_ = self->priv->entry_map;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, search);
	result = (SearchesSidebarEntry*) _tmp1_;
	return result;
}

static gint
searches_branch_comparator (SidebarEntry* a,
                            SidebarEntry* b)
{
	SavedSearch* _tmp0_;
	SavedSearch* _tmp1_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	if (a == b) {
		result = 0;
		return result;
	}
	_tmp0_ = searches_sidebar_entry_for_saved_search (G_TYPE_CHECK_INSTANCE_CAST (a, SEARCHES_TYPE_SIDEBAR_ENTRY, SearchesSidebarEntry));
	_tmp1_ = searches_sidebar_entry_for_saved_search (G_TYPE_CHECK_INSTANCE_CAST (b, SEARCHES_TYPE_SIDEBAR_ENTRY, SearchesSidebarEntry));
	result = saved_search_compare_names (_tmp0_, _tmp1_);
	return result;
}

static void
searches_branch_on_saved_search_added (SearchesBranch* self,
                                       SavedSearch* search)
{
	SearchesSidebarEntry* entry = NULL;
	SearchesSidebarEntry* _tmp0_;
	GeeHashMap* _tmp1_;
	SidebarEntry* _tmp2_;
	SidebarEntry* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (search != NULL);
	g_debug ("Branch.vala:58: smart album added");
	_tmp0_ = searches_sidebar_entry_new (search);
	entry = _tmp0_;
	_tmp1_ = self->priv->entry_map;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp1_, search, entry);
	_tmp2_ = sidebar_branch_get_root ((SidebarBranch*) self);
	_tmp3_ = _tmp2_;
	sidebar_branch_graft ((SidebarBranch*) self, _tmp3_, (SidebarEntry*) entry, NULL);
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (entry);
}

static void
searches_branch_on_saved_search_removed (SearchesBranch* self,
                                         SavedSearch* search)
{
	SearchesSidebarEntry* entry = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	gboolean is_removed = FALSE;
	GeeHashMap* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (search != NULL);
	g_debug ("Branch.vala:65: smart album removed");
	_tmp0_ = self->priv->entry_map;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, search);
	entry = (SearchesSidebarEntry*) _tmp1_;
	_vala_assert (entry != NULL, "entry != null");
	_tmp2_ = self->priv->entry_map;
	is_removed = gee_abstract_map_unset ((GeeAbstractMap*) _tmp2_, search, NULL);
	_vala_assert (is_removed, "is_removed");
	sidebar_branch_prune ((SidebarBranch*) self, (SidebarEntry*) entry);
	_g_object_unref0 (entry);
}

static void
searches_branch_class_init (SearchesBranchClass * klass,
                            gpointer klass_data)
{
	searches_branch_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SearchesBranch_private_offset);
	G_OBJECT_CLASS (klass)->finalize = searches_branch_finalize;
}

static void
searches_branch_instance_init (SearchesBranch * self,
                               gpointer klass)
{
	GeeHashMap* _tmp0_;
	self->priv = searches_branch_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (TYPE_SAVED_SEARCH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, SEARCHES_TYPE_SIDEBAR_ENTRY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->entry_map = _tmp0_;
}

static void
searches_branch_finalize (GObject * obj)
{
	SearchesBranch * self;
	SavedSearchTable* _tmp0_;
	SavedSearchTable* _tmp1_;
	guint _tmp2_;
	SavedSearchTable* _tmp3_;
	SavedSearchTable* _tmp4_;
	guint _tmp5_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEARCHES_TYPE_BRANCH, SearchesBranch);
	_tmp0_ = saved_search_table_get_instance ();
	_tmp1_ = _tmp0_;
	g_signal_parse_name ("search-added", TYPE_SAVED_SEARCH_TABLE, &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _searches_branch_on_saved_search_added_saved_search_table_search_added, self);
	_saved_search_table_unref0 (_tmp1_);
	_tmp3_ = saved_search_table_get_instance ();
	_tmp4_ = _tmp3_;
	g_signal_parse_name ("search-removed", TYPE_SAVED_SEARCH_TABLE, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _searches_branch_on_saved_search_removed_saved_search_table_search_removed, self);
	_saved_search_table_unref0 (_tmp4_);
	_g_object_unref0 (self->priv->entry_map);
	G_OBJECT_CLASS (searches_branch_parent_class)->finalize (obj);
}

static GType
searches_branch_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SearchesBranchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) searches_branch_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchesBranch), 0, (GInstanceInitFunc) searches_branch_instance_init, NULL };
	GType searches_branch_type_id;
	searches_branch_type_id = g_type_register_static (SIDEBAR_TYPE_BRANCH, "SearchesBranch", &g_define_type_info, 0);
	SearchesBranch_private_offset = g_type_add_instance_private (searches_branch_type_id, sizeof (SearchesBranchPrivate));
	return searches_branch_type_id;
}

GType
searches_branch_get_type (void)
{
	static volatile gsize searches_branch_type_id__once = 0;
	if (g_once_init_enter (&searches_branch_type_id__once)) {
		GType searches_branch_type_id;
		searches_branch_type_id = searches_branch_get_type_once ();
		g_once_init_leave (&searches_branch_type_id__once, searches_branch_type_id);
	}
	return searches_branch_type_id__once;
}

static inline gpointer
searches_grouping_get_instance_private (SearchesGrouping* self)
{
	return G_STRUCT_MEMBER_P (self, SearchesGrouping_private_offset);
}

SearchesGrouping*
searches_grouping_construct (GType object_type)
{
	SearchesGrouping * self = NULL;
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("playlist-automatic");
	_tmp1_ = _tmp0_;
	self = (SearchesGrouping*) sidebar_grouping_construct (object_type, _ ("Smart Albums"), (GIcon*) _tmp1_, NULL);
	_g_object_unref0 (_tmp1_);
	return self;
}

SearchesGrouping*
searches_grouping_new (void)
{
	return searches_grouping_construct (SEARCHES_TYPE_GROUPING);
}

static void
___lambda97_ (SearchesGrouping* self)
{
}

static void
____lambda97__gtk_menu_item_activate (GtkMenuItem* _sender,
                                      gpointer self)
{
	___lambda97_ ((SearchesGrouping*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GtkMenu*
searches_grouping_real_get_sidebar_context_menu (SidebarContextable* base,
                                                 GdkEventButton* event)
{
	SearchesGrouping * self;
	GtkMenu* _tmp0_;
	GtkMenu* _tmp7_;
	GtkMenu* _tmp8_;
	GtkMenu* result;
	self = (SearchesGrouping*) base;
	_tmp0_ = self->priv->context_menu;
	if (_tmp0_ == NULL) {
		GtkMenu* _tmp1_;
		GtkMenuItem* new_search_menu_item = NULL;
		GtkMenuItem* _tmp2_;
		GtkMenuItem* _tmp3_;
		GtkMenu* _tmp4_;
		GtkMenuItem* _tmp5_;
		GtkMenu* _tmp6_;
		_tmp1_ = (GtkMenu*) gtk_menu_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->context_menu);
		self->priv->context_menu = _tmp1_;
		_tmp2_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("New Smart Album…"));
		g_object_ref_sink (_tmp2_);
		new_search_menu_item = _tmp2_;
		_tmp3_ = new_search_menu_item;
		g_signal_connect_object (_tmp3_, "activate", (GCallback) ____lambda97__gtk_menu_item_activate, self, 0);
		_tmp4_ = self->priv->context_menu;
		_tmp5_ = new_search_menu_item;
		gtk_container_add ((GtkContainer*) _tmp4_, (GtkWidget*) _tmp5_);
		_tmp6_ = self->priv->context_menu;
		gtk_widget_show_all ((GtkWidget*) _tmp6_);
		_g_object_unref0 (new_search_menu_item);
	}
	_tmp7_ = self->priv->context_menu;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	result = _tmp8_;
	return result;
}

static void
searches_grouping_on_new_search (SearchesGrouping* self)
{
	SavedSearchDialog* _tmp0_;
	SavedSearchDialog* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = saved_search_dialog_new ();
	_tmp1_ = _tmp0_;
	saved_search_dialog_show (_tmp1_);
	_g_object_unref0 (_tmp1_);
}

static void
searches_grouping_class_init (SearchesGroupingClass * klass,
                              gpointer klass_data)
{
	searches_grouping_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SearchesGrouping_private_offset);
	G_OBJECT_CLASS (klass)->finalize = searches_grouping_finalize;
}

static void
searches_grouping_sidebar_contextable_interface_init (SidebarContextableIface * iface,
                                                      gpointer iface_data)
{
	searches_grouping_sidebar_contextable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_sidebar_context_menu = (GtkMenu* (*) (SidebarContextable*, GdkEventButton*)) searches_grouping_real_get_sidebar_context_menu;
}

static void
searches_grouping_instance_init (SearchesGrouping * self,
                                 gpointer klass)
{
	self->priv = searches_grouping_get_instance_private (self);
	self->priv->context_menu = NULL;
}

static void
searches_grouping_finalize (GObject * obj)
{
	SearchesGrouping * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEARCHES_TYPE_GROUPING, SearchesGrouping);
	_g_object_unref0 (self->priv->context_menu);
	G_OBJECT_CLASS (searches_grouping_parent_class)->finalize (obj);
}

static GType
searches_grouping_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SearchesGroupingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) searches_grouping_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchesGrouping), 0, (GInstanceInitFunc) searches_grouping_instance_init, NULL };
	static const GInterfaceInfo sidebar_contextable_info = { (GInterfaceInitFunc) searches_grouping_sidebar_contextable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType searches_grouping_type_id;
	searches_grouping_type_id = g_type_register_static (SIDEBAR_TYPE_GROUPING, "SearchesGrouping", &g_define_type_info, 0);
	g_type_add_interface_static (searches_grouping_type_id, SIDEBAR_TYPE_CONTEXTABLE, &sidebar_contextable_info);
	SearchesGrouping_private_offset = g_type_add_instance_private (searches_grouping_type_id, sizeof (SearchesGroupingPrivate));
	return searches_grouping_type_id;
}

GType
searches_grouping_get_type (void)
{
	static volatile gsize searches_grouping_type_id__once = 0;
	if (g_once_init_enter (&searches_grouping_type_id__once)) {
		GType searches_grouping_type_id;
		searches_grouping_type_id = searches_grouping_get_type_once ();
		g_once_init_leave (&searches_grouping_type_id__once, searches_grouping_type_id);
	}
	return searches_grouping_type_id__once;
}

static inline gpointer
searches_sidebar_entry_get_instance_private (SearchesSidebarEntry* self)
{
	return G_STRUCT_MEMBER_P (self, SearchesSidebarEntry_private_offset);
}

SearchesSidebarEntry*
searches_sidebar_entry_construct (GType object_type,
                                  SavedSearch* search)
{
	SearchesSidebarEntry * self = NULL;
	SavedSearch* _tmp0_;
	g_return_val_if_fail (search != NULL, NULL);
	self = (SearchesSidebarEntry*) sidebar_simple_page_entry_construct (object_type);
	_tmp0_ = _g_object_ref0 (search);
	_g_object_unref0 (self->priv->search);
	self->priv->search = _tmp0_;
	return self;
}

SearchesSidebarEntry*
searches_sidebar_entry_new (SavedSearch* search)
{
	return searches_sidebar_entry_construct (SEARCHES_TYPE_SIDEBAR_ENTRY, search);
}

SavedSearch*
searches_sidebar_entry_for_saved_search (SearchesSidebarEntry* self)
{
	SavedSearch* _tmp0_;
	SavedSearch* _tmp1_;
	SavedSearch* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->search;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
searches_sidebar_entry_real_get_sidebar_name (SidebarSimplePageEntry* base)
{
	SearchesSidebarEntry * self;
	SavedSearch* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (SearchesSidebarEntry*) base;
	_tmp0_ = self->priv->search;
	_tmp1_ = data_object_get_name ((DataObject*) _tmp0_);
	result = _tmp1_;
	return result;
}

static GIcon*
searches_sidebar_entry_real_get_sidebar_icon (SidebarSimplePageEntry* base)
{
	SearchesSidebarEntry * self;
	GIcon* _tmp0_;
	GIcon* _tmp1_;
	GIcon* result;
	self = (SearchesSidebarEntry*) base;
	_tmp0_ = searches_sidebar_entry_single_search_icon;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static Page*
searches_sidebar_entry_real_create_page (SidebarSimplePageEntry* base)
{
	SearchesSidebarEntry * self;
	SavedSearch* _tmp0_;
	SavedSearchPage* _tmp1_;
	Page* result;
	self = (SearchesSidebarEntry*) base;
	_tmp0_ = self->priv->search;
	_tmp1_ = saved_search_page_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	result = (Page*) _tmp1_;
	return result;
}

static void
searches_sidebar_entry_real_rename (SidebarRenameableEntry* base,
                                    const gchar* new_name)
{
	SearchesSidebarEntry * self;
	SavedSearchTable* _tmp0_;
	SavedSearchTable* _tmp1_;
	gboolean _tmp2_;
	self = (SearchesSidebarEntry*) base;
	g_return_if_fail (new_name != NULL);
	_tmp0_ = saved_search_table_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = !saved_search_table_exists (_tmp1_, new_name);
	_saved_search_table_unref0 (_tmp1_);
	if (_tmp2_) {
		CommandManager* _tmp3_;
		CommandManager* _tmp4_;
		SavedSearch* _tmp5_;
		RenameSavedSearchCommand* _tmp6_;
		RenameSavedSearchCommand* _tmp7_;
		_tmp3_ = app_window_get_command_manager ();
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->search;
		_tmp6_ = rename_saved_search_command_new (_tmp5_, new_name);
		_tmp7_ = _tmp6_;
		command_manager_execute (_tmp4_, (Command*) _tmp7_);
		_g_object_unref0 (_tmp7_);
		_command_manager_unref0 (_tmp4_);
	} else {
		SavedSearch* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gboolean _tmp11_;
		_tmp8_ = self->priv->search;
		_tmp9_ = data_object_get_name ((DataObject*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strcmp0 (new_name, _tmp10_) != 0;
		_g_free0 (_tmp10_);
		if (_tmp11_) {
			gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp12_ = resources_rename_search_exists_message (new_name);
			_tmp13_ = _tmp12_;
			app_window_error_message (_tmp13_, NULL, NULL);
			_g_free0 (_tmp13_);
		}
	}
}

static void
searches_sidebar_entry_real_destroy_source (SidebarDestroyableEntry* base)
{
	SearchesSidebarEntry * self;
	SavedSearch* _tmp0_;
	self = (SearchesSidebarEntry*) base;
	_tmp0_ = self->priv->search;
	if (dialogs_confirm_delete_saved_search (_tmp0_)) {
		CommandManager* _tmp1_;
		CommandManager* _tmp2_;
		SavedSearch* _tmp3_;
		DeleteSavedSearchCommand* _tmp4_;
		DeleteSavedSearchCommand* _tmp5_;
		_tmp1_ = app_window_get_command_manager ();
		_tmp2_ = _tmp1_;
		_tmp3_ = self->priv->search;
		_tmp4_ = delete_saved_search_command_new (_tmp3_);
		_tmp5_ = _tmp4_;
		command_manager_execute (_tmp2_, (Command*) _tmp5_);
		_g_object_unref0 (_tmp5_);
		_command_manager_unref0 (_tmp2_);
	}
}

static void
searches_sidebar_entry_base_init (SearchesSidebarEntryClass * klass)
{
	GThemedIcon* _tmp0_;
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("playlist-automatic");
	_g_object_unref0 (searches_sidebar_entry_single_search_icon);
	searches_sidebar_entry_single_search_icon = (GIcon*) _tmp0_;
}

static void
searches_sidebar_entry_class_init (SearchesSidebarEntryClass * klass,
                                   gpointer klass_data)
{
	searches_sidebar_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SearchesSidebarEntry_private_offset);
	((SidebarSimplePageEntryClass *) klass)->get_sidebar_name = (gchar* (*) (SidebarSimplePageEntry*)) searches_sidebar_entry_real_get_sidebar_name;
	((SidebarSimplePageEntryClass *) klass)->get_sidebar_icon = (GIcon* (*) (SidebarSimplePageEntry*)) searches_sidebar_entry_real_get_sidebar_icon;
	((SidebarSimplePageEntryClass *) klass)->create_page = (Page* (*) (SidebarSimplePageEntry*)) searches_sidebar_entry_real_create_page;
	G_OBJECT_CLASS (klass)->finalize = searches_sidebar_entry_finalize;
}

static void
searches_sidebar_entry_sidebar_renameable_entry_interface_init (SidebarRenameableEntryIface * iface,
                                                                gpointer iface_data)
{
	searches_sidebar_entry_sidebar_renameable_entry_parent_iface = g_type_interface_peek_parent (iface);
	iface->rename = (void (*) (SidebarRenameableEntry*, const gchar*)) searches_sidebar_entry_real_rename;
}

static void
searches_sidebar_entry_sidebar_destroyable_entry_interface_init (SidebarDestroyableEntryIface * iface,
                                                                 gpointer iface_data)
{
	searches_sidebar_entry_sidebar_destroyable_entry_parent_iface = g_type_interface_peek_parent (iface);
	iface->destroy_source = (void (*) (SidebarDestroyableEntry*)) searches_sidebar_entry_real_destroy_source;
}

static void
searches_sidebar_entry_instance_init (SearchesSidebarEntry * self,
                                      gpointer klass)
{
	self->priv = searches_sidebar_entry_get_instance_private (self);
}

static void
searches_sidebar_entry_finalize (GObject * obj)
{
	SearchesSidebarEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEARCHES_TYPE_SIDEBAR_ENTRY, SearchesSidebarEntry);
	_g_object_unref0 (self->priv->search);
	G_OBJECT_CLASS (searches_sidebar_entry_parent_class)->finalize (obj);
}

static GType
searches_sidebar_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SearchesSidebarEntryClass), (GBaseInitFunc) searches_sidebar_entry_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) searches_sidebar_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchesSidebarEntry), 0, (GInstanceInitFunc) searches_sidebar_entry_instance_init, NULL };
	static const GInterfaceInfo sidebar_renameable_entry_info = { (GInterfaceInitFunc) searches_sidebar_entry_sidebar_renameable_entry_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo sidebar_destroyable_entry_info = { (GInterfaceInitFunc) searches_sidebar_entry_sidebar_destroyable_entry_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType searches_sidebar_entry_type_id;
	searches_sidebar_entry_type_id = g_type_register_static (SIDEBAR_TYPE_SIMPLE_PAGE_ENTRY, "SearchesSidebarEntry", &g_define_type_info, 0);
	g_type_add_interface_static (searches_sidebar_entry_type_id, SIDEBAR_TYPE_RENAMEABLE_ENTRY, &sidebar_renameable_entry_info);
	g_type_add_interface_static (searches_sidebar_entry_type_id, SIDEBAR_TYPE_DESTROYABLE_ENTRY, &sidebar_destroyable_entry_info);
	SearchesSidebarEntry_private_offset = g_type_add_instance_private (searches_sidebar_entry_type_id, sizeof (SearchesSidebarEntryPrivate));
	return searches_sidebar_entry_type_id;
}

GType
searches_sidebar_entry_get_type (void)
{
	static volatile gsize searches_sidebar_entry_type_id__once = 0;
	if (g_once_init_enter (&searches_sidebar_entry_type_id__once)) {
		GType searches_sidebar_entry_type_id;
		searches_sidebar_entry_type_id = searches_sidebar_entry_get_type_once ();
		g_once_init_leave (&searches_sidebar_entry_type_id__once, searches_sidebar_entry_type_id);
	}
	return searches_sidebar_entry_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

