/* MainWindow.c generated by valac 0.56.18, the Vala compiler
 * generated from MainWindow.vala, do not modify */

/*
* Copyright 2019-2022 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <granite-7.h>
#include <float.h>
#include <math.h>
#include <flatpak.h>
#include <gio/gdesktopappinfo.h>

#define SIDELOAD_MAIN_WINDOW_BUNDLE_CONTENT_TYPE "application/vnd.flatpak"
#define SIDELOAD_MAIN_WINDOW_REF_CONTENT_TYPE "application/vnd.flatpak.ref"
#define SIDELOAD_MAIN_WINDOW_FLATPAK_HTTPS_CONTENT_TYPE "x-scheme-handler/flatpak+https"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SIDELOAD_TYPE_MAIN_WINDOW (sideload_main_window_get_type ())
#define SIDELOAD_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDELOAD_TYPE_MAIN_WINDOW, SideloadMainWindow))
#define SIDELOAD_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDELOAD_TYPE_MAIN_WINDOW, SideloadMainWindowClass))
#define SIDELOAD_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDELOAD_TYPE_MAIN_WINDOW))
#define SIDELOAD_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDELOAD_TYPE_MAIN_WINDOW))
#define SIDELOAD_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDELOAD_TYPE_MAIN_WINDOW, SideloadMainWindowClass))

typedef struct _SideloadMainWindow SideloadMainWindow;
typedef struct _SideloadMainWindowClass SideloadMainWindowClass;
typedef struct _SideloadMainWindowPrivate SideloadMainWindowPrivate;

#define SIDELOAD_TYPE_FLATPAK_FILE (sideload_flatpak_file_get_type ())
#define SIDELOAD_FLATPAK_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDELOAD_TYPE_FLATPAK_FILE, SideloadFlatpakFile))
#define SIDELOAD_FLATPAK_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDELOAD_TYPE_FLATPAK_FILE, SideloadFlatpakFileClass))
#define SIDELOAD_IS_FLATPAK_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDELOAD_TYPE_FLATPAK_FILE))
#define SIDELOAD_IS_FLATPAK_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDELOAD_TYPE_FLATPAK_FILE))
#define SIDELOAD_FLATPAK_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDELOAD_TYPE_FLATPAK_FILE, SideloadFlatpakFileClass))

typedef struct _SideloadFlatpakFile SideloadFlatpakFile;
typedef struct _SideloadFlatpakFileClass SideloadFlatpakFileClass;

#define TYPE_ABSTRACT_VIEW (abstract_view_get_type ())
#define ABSTRACT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ABSTRACT_VIEW, AbstractView))
#define ABSTRACT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ABSTRACT_VIEW, AbstractViewClass))
#define IS_ABSTRACT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ABSTRACT_VIEW))
#define IS_ABSTRACT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ABSTRACT_VIEW))
#define ABSTRACT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ABSTRACT_VIEW, AbstractViewClass))

typedef struct _AbstractView AbstractView;
typedef struct _AbstractViewClass AbstractViewClass;

#define SIDELOAD_TYPE_MAIN_VIEW (sideload_main_view_get_type ())
#define SIDELOAD_MAIN_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDELOAD_TYPE_MAIN_VIEW, SideloadMainView))
#define SIDELOAD_MAIN_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDELOAD_TYPE_MAIN_VIEW, SideloadMainViewClass))
#define SIDELOAD_IS_MAIN_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDELOAD_TYPE_MAIN_VIEW))
#define SIDELOAD_IS_MAIN_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDELOAD_TYPE_MAIN_VIEW))
#define SIDELOAD_MAIN_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDELOAD_TYPE_MAIN_VIEW, SideloadMainViewClass))

typedef struct _SideloadMainView SideloadMainView;
typedef struct _SideloadMainViewClass SideloadMainViewClass;

#define SIDELOAD_TYPE_PROGRESS_VIEW (sideload_progress_view_get_type ())
#define SIDELOAD_PROGRESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDELOAD_TYPE_PROGRESS_VIEW, SideloadProgressView))
#define SIDELOAD_PROGRESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDELOAD_TYPE_PROGRESS_VIEW, SideloadProgressViewClass))
#define SIDELOAD_IS_PROGRESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDELOAD_TYPE_PROGRESS_VIEW))
#define SIDELOAD_IS_PROGRESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDELOAD_TYPE_PROGRESS_VIEW))
#define SIDELOAD_PROGRESS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDELOAD_TYPE_PROGRESS_VIEW, SideloadProgressViewClass))

typedef struct _SideloadProgressView SideloadProgressView;
typedef struct _SideloadProgressViewClass SideloadProgressViewClass;
enum  {
	SIDELOAD_MAIN_WINDOW_0_PROPERTY,
	SIDELOAD_MAIN_WINDOW_FILE_PROPERTY,
	SIDELOAD_MAIN_WINDOW_FLATPAK_FILE_PROPERTY,
	SIDELOAD_MAIN_WINDOW_NUM_PROPERTIES
};
static GParamSpec* sideload_main_window_properties[SIDELOAD_MAIN_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SideloadMainWindowGetDetailsData SideloadMainWindowGetDetailsData;

#define SIDELOAD_TYPE_FLATPAK_REF_FILE (sideload_flatpak_ref_file_get_type ())
#define SIDELOAD_FLATPAK_REF_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDELOAD_TYPE_FLATPAK_REF_FILE, SideloadFlatpakRefFile))
#define SIDELOAD_FLATPAK_REF_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDELOAD_TYPE_FLATPAK_REF_FILE, SideloadFlatpakRefFileClass))
#define SIDELOAD_IS_FLATPAK_REF_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDELOAD_TYPE_FLATPAK_REF_FILE))
#define SIDELOAD_IS_FLATPAK_REF_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDELOAD_TYPE_FLATPAK_REF_FILE))
#define SIDELOAD_FLATPAK_REF_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDELOAD_TYPE_FLATPAK_REF_FILE, SideloadFlatpakRefFileClass))

typedef struct _SideloadFlatpakRefFile SideloadFlatpakRefFile;
typedef struct _SideloadFlatpakRefFileClass SideloadFlatpakRefFileClass;

#define SIDELOAD_TYPE_SUCCESS_VIEW (sideload_success_view_get_type ())
#define SIDELOAD_SUCCESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDELOAD_TYPE_SUCCESS_VIEW, SideloadSuccessView))
#define SIDELOAD_SUCCESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDELOAD_TYPE_SUCCESS_VIEW, SideloadSuccessViewClass))
#define SIDELOAD_IS_SUCCESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDELOAD_TYPE_SUCCESS_VIEW))
#define SIDELOAD_IS_SUCCESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDELOAD_TYPE_SUCCESS_VIEW))
#define SIDELOAD_SUCCESS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDELOAD_TYPE_SUCCESS_VIEW, SideloadSuccessViewClass))

typedef struct _SideloadSuccessView SideloadSuccessView;
typedef struct _SideloadSuccessViewClass SideloadSuccessViewClass;
typedef enum  {
	SIDELOAD_SUCCESS_VIEW_SUCCESS_TYPE_INSTALLED,
	SIDELOAD_SUCCESS_VIEW_SUCCESS_TYPE_ALREADY_INSTALLED
} SideloadSuccessViewSuccessType;

#define SIDELOAD_SUCCESS_VIEW_TYPE_SUCCESS_TYPE (sideload_success_view_success_type_get_type ())

#define SIDELOAD_TYPE_ERROR_VIEW (sideload_error_view_get_type ())
#define SIDELOAD_ERROR_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDELOAD_TYPE_ERROR_VIEW, SideloadErrorView))
#define SIDELOAD_ERROR_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDELOAD_TYPE_ERROR_VIEW, SideloadErrorViewClass))
#define SIDELOAD_IS_ERROR_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDELOAD_TYPE_ERROR_VIEW))
#define SIDELOAD_IS_ERROR_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDELOAD_TYPE_ERROR_VIEW))
#define SIDELOAD_ERROR_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDELOAD_TYPE_ERROR_VIEW, SideloadErrorViewClass))

typedef struct _SideloadErrorView SideloadErrorView;
typedef struct _SideloadErrorViewClass SideloadErrorViewClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define SIDELOAD_TYPE_FLATPAK_BUNDLE_FILE (sideload_flatpak_bundle_file_get_type ())
#define SIDELOAD_FLATPAK_BUNDLE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDELOAD_TYPE_FLATPAK_BUNDLE_FILE, SideloadFlatpakBundleFile))
#define SIDELOAD_FLATPAK_BUNDLE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDELOAD_TYPE_FLATPAK_BUNDLE_FILE, SideloadFlatpakBundleFileClass))
#define SIDELOAD_IS_FLATPAK_BUNDLE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDELOAD_TYPE_FLATPAK_BUNDLE_FILE))
#define SIDELOAD_IS_FLATPAK_BUNDLE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDELOAD_TYPE_FLATPAK_BUNDLE_FILE))
#define SIDELOAD_FLATPAK_BUNDLE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDELOAD_TYPE_FLATPAK_BUNDLE_FILE, SideloadFlatpakBundleFileClass))

typedef struct _SideloadFlatpakBundleFile SideloadFlatpakBundleFile;
typedef struct _SideloadFlatpakBundleFileClass SideloadFlatpakBundleFileClass;
typedef struct _SideloadFlatpakFilePrivate SideloadFlatpakFilePrivate;
typedef enum  {
	SIDELOAD_PROGRESS_VIEW_PROGRESS_TYPE_BUNDLE_INSTALL,
	SIDELOAD_PROGRESS_VIEW_PROGRESS_TYPE_REF_INSTALL
} SideloadProgressViewProgressType;

#define SIDELOAD_PROGRESS_VIEW_TYPE_PROGRESS_TYPE (sideload_progress_view_progress_type_get_type ())
typedef enum  {
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_DEVICES = 1 << 0,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_DOWNLOADS_FULL = 1 << 1,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_DOWNLOADS_READ = 1 << 2,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_ESCAPE_SANDBOX = 1 << 3,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_FILESYSTEM_FULL = 1 << 4,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_FILESYSTEM_OTHER = 1 << 5,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_FILESYSTEM_READ = 1 << 6,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_HOME_FULL = 1 << 7,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_HOME_READ = 1 << 8,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_NETWORK = 1 << 9,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_NONE = 1 << 10,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_SESSION_BUS = 1 << 11,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_SETTINGS = 1 << 12,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_SYSTEM_BUS = 1 << 13,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_UNKNOWN = 1 << 14,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_X11 = 1 << 15
} SideloadFlatpakFilePermissionsFlags;

#define SIDELOAD_FLATPAK_FILE_TYPE_PERMISSIONS_FLAGS (sideload_flatpak_file_permissions_flags_get_type ())

struct _SideloadMainWindow {
	GtkApplicationWindow parent_instance;
	SideloadMainWindowPrivate * priv;
};

struct _SideloadMainWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _SideloadMainWindowPrivate {
	GFile* _file;
	SideloadFlatpakFile* _flatpak_file;
	GCancellable* current_cancellable;
	GtkStack* stack;
	SideloadMainView* main_view;
	SideloadProgressView* progress_view;
	gchar* app_name;
	gchar* app_id;
};

struct _SideloadMainWindowGetDetailsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SideloadMainWindow* self;
	SideloadFlatpakFile* _tmp0_;
	SideloadFlatpakFile* _tmp1_;
	gchar* _tmp2_;
	SideloadFlatpakFile* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	SideloadProgressView* _tmp6_;
	const gchar* _tmp7_;
	SideloadMainView* _tmp8_;
	const gchar* _tmp9_;
};

struct _SideloadFlatpakFile {
	GObject parent_instance;
	SideloadFlatpakFilePrivate * priv;
	gchar* appdata_name;
	gint error_code;
	gchar* error_message;
};

struct _SideloadFlatpakFileClass {
	GObjectClass parent_class;
	void (*get_id) (SideloadFlatpakFile* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar* (*get_id_finish) (SideloadFlatpakFile* self, GAsyncResult* _res_);
	void (*get_name) (SideloadFlatpakFile* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar* (*get_name_finish) (SideloadFlatpakFile* self, GAsyncResult* _res_);
	void (*get_details) (SideloadFlatpakFile* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*get_details_finish) (SideloadFlatpakFile* self, GAsyncResult* _res_);
	void (*install) (SideloadFlatpakFile* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*install_finish) (SideloadFlatpakFile* self, GAsyncResult* _res_, GError** error);
	void (*launch) (SideloadFlatpakFile* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*launch_finish) (SideloadFlatpakFile* self, GAsyncResult* _res_);
};

static gint SideloadMainWindow_private_offset;
static gpointer sideload_main_window_parent_class = NULL;

VALA_EXTERN GType sideload_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SideloadMainWindow, g_object_unref)
VALA_EXTERN GType sideload_flatpak_file_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SideloadFlatpakFile, g_object_unref)
VALA_EXTERN GType abstract_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AbstractView, g_object_unref)
VALA_EXTERN GType sideload_main_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SideloadMainView, g_object_unref)
VALA_EXTERN GType sideload_progress_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SideloadProgressView, g_object_unref)
VALA_EXTERN SideloadMainWindow* sideload_main_window_new (GtkApplication* application,
                                              GFile* file);
VALA_EXTERN SideloadMainWindow* sideload_main_window_construct (GType object_type,
                                                    GtkApplication* application,
                                                    GFile* file);
static void sideload_main_window_get_details_data_free (gpointer _data);
static void sideload_main_window_get_details (SideloadMainWindow* self,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
static void sideload_main_window_get_details_finish (SideloadMainWindow* self,
                                              GAsyncResult* _res_);
static gboolean sideload_main_window_get_details_co (SideloadMainWindowGetDetailsData* _data_);
VALA_EXTERN SideloadFlatpakFile* sideload_main_window_get_flatpak_file (SideloadMainWindow* self);
VALA_EXTERN void sideload_flatpak_file_get_details (SideloadFlatpakFile* self,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
VALA_EXTERN void sideload_flatpak_file_get_details_finish (SideloadFlatpakFile* self,
                                               GAsyncResult* _res_);
static void sideload_main_window_get_details_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
VALA_EXTERN void sideload_flatpak_file_get_name (SideloadFlatpakFile* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
VALA_EXTERN gchar* sideload_flatpak_file_get_name_finish (SideloadFlatpakFile* self,
                                              GAsyncResult* _res_);
VALA_EXTERN void sideload_flatpak_file_get_id (SideloadFlatpakFile* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
VALA_EXTERN gchar* sideload_flatpak_file_get_id_finish (SideloadFlatpakFile* self,
                                            GAsyncResult* _res_);
VALA_EXTERN void sideload_progress_view_set_app_name (SideloadProgressView* self,
                                          const gchar* value);
VALA_EXTERN void sideload_main_view_set_app_name (SideloadMainView* self,
                                      const gchar* value);
static void sideload_main_window_on_install_button_clicked (SideloadMainWindow* self);
VALA_EXTERN void sideload_flatpak_file_install (SideloadFlatpakFile* self,
                                    GCancellable* cancellable,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
VALA_EXTERN void sideload_flatpak_file_install_finish (SideloadFlatpakFile* self,
                                           GAsyncResult* _res_,
                                           GError** error);
VALA_EXTERN GType sideload_flatpak_ref_file_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SideloadFlatpakRefFile, g_object_unref)
static void sideload_main_window_on_progress_changed (SideloadMainWindow* self,
                                               const gchar* description,
                                               gdouble progress);
VALA_EXTERN void sideload_progress_view_set_status (SideloadProgressView* self,
                                        const gchar* value);
VALA_EXTERN void sideload_progress_view_set_progress (SideloadProgressView* self,
                                          gdouble value);
static void sideload_main_window_on_install_failed (SideloadMainWindow* self,
                                             gint error_code,
                                             const gchar* error_message);
VALA_EXTERN GType sideload_success_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SideloadSuccessView, g_object_unref)
VALA_EXTERN GType sideload_success_view_success_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SideloadSuccessView* sideload_success_view_new (const gchar* app_name,
                                                SideloadSuccessViewSuccessType type);
VALA_EXTERN SideloadSuccessView* sideload_success_view_construct (GType object_type,
                                                      const gchar* app_name,
                                                      SideloadSuccessViewSuccessType type);
VALA_EXTERN GType sideload_error_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SideloadErrorView, g_object_unref)
VALA_EXTERN SideloadErrorView* sideload_error_view_new (gint error_code,
                                            const gchar* error_message);
VALA_EXTERN SideloadErrorView* sideload_error_view_construct (GType object_type,
                                                  gint error_code,
                                                  const gchar* error_message);
static void sideload_main_window_on_install_succeeded (SideloadMainWindow* self);
static GIcon* sideload_main_window_get_application_icon (SideloadMainWindow* self);
VALA_EXTERN GFile* sideload_main_window_get_file (SideloadMainWindow* self);
static void sideload_main_window_set_file (SideloadMainWindow* self,
                                    GFile* value);
static void sideload_main_window_set_flatpak_file (SideloadMainWindow* self,
                                            SideloadFlatpakFile* value);
static GObject * sideload_main_window_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
VALA_EXTERN SideloadMainView* sideload_main_view_new (void);
VALA_EXTERN SideloadMainView* sideload_main_view_construct (GType object_type);
static void _sideload_main_window___lambda21_ (SideloadMainWindow* self);
static void __sideload_main_window___lambda21__g_application_shutdown (GApplication* _sender,
                                                                gpointer self);
static gboolean _vala_string_array_contains (const gchar* * stack,
                                      gssize stack_length,
                                      const const gchar* needle);
VALA_EXTERN SideloadFlatpakRefFile* sideload_flatpak_ref_file_new (GFile* file);
VALA_EXTERN SideloadFlatpakRefFile* sideload_flatpak_ref_file_construct (GType object_type,
                                                             GFile* file);
VALA_EXTERN SideloadFlatpakBundleFile* sideload_flatpak_bundle_file_new (GFile* file);
VALA_EXTERN SideloadFlatpakBundleFile* sideload_flatpak_bundle_file_construct (GType object_type,
                                                                   GFile* file);
VALA_EXTERN GType sideload_flatpak_bundle_file_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SideloadFlatpakBundleFile, g_object_unref)
VALA_EXTERN const gchar* sideload_flatpak_file_get_size (SideloadFlatpakFile* self);
VALA_EXTERN GType sideload_progress_view_progress_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SideloadProgressView* sideload_progress_view_new (SideloadProgressViewProgressType type);
VALA_EXTERN SideloadProgressView* sideload_progress_view_construct (GType object_type,
                                                        SideloadProgressViewProgressType type);
static void _sideload_main_window_on_install_button_clicked_sideload_main_view_install_request (SideloadMainView* _sender,
                                                                                         gpointer self);
static void _sideload_main_window_on_progress_changed_sideload_flatpak_file_progress_changed (SideloadFlatpakFile* _sender,
                                                                                       const gchar* description,
                                                                                       gdouble progress,
                                                                                       gpointer self);
static void _sideload_main_window_on_install_failed_sideload_flatpak_file_installation_failed (SideloadFlatpakFile* _sender,
                                                                                        gint error_code,
                                                                                        const gchar* message,
                                                                                        gpointer self);
static void _sideload_main_window_on_install_succeeded_sideload_flatpak_file_installation_succeeded (SideloadFlatpakFile* _sender,
                                                                                              gpointer self);
static void _sideload_main_window___lambda29_ (SideloadMainWindow* self);
VALA_EXTERN gboolean sideload_flatpak_file_get_already_installed (SideloadFlatpakFile* self);
VALA_EXTERN GType sideload_flatpak_file_permissions_flags_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void sideload_main_view_display_ref_details (SideloadMainView* self,
                                             const gchar* size,
                                             gboolean extra_repo,
                                             SideloadFlatpakFilePermissionsFlags permissions_flags);
VALA_EXTERN gboolean sideload_flatpak_file_get_extra_remotes_needed (SideloadFlatpakFile* self);
VALA_EXTERN SideloadFlatpakFilePermissionsFlags sideload_flatpak_file_get_permissions_flags (SideloadFlatpakFile* self);
VALA_EXTERN void sideload_main_view_display_bundle_details (SideloadMainView* self,
                                                const gchar* size,
                                                gboolean has_repo,
                                                gboolean extra_repo);
VALA_EXTERN gboolean sideload_flatpak_bundle_file_get_has_remote (SideloadFlatpakBundleFile* self);
static void __sideload_main_window___lambda29__sideload_flatpak_file_details_ready (SideloadFlatpakFile* _sender,
                                                                             gpointer self);
static void sideload_main_window_finalize (GObject * obj);
static GType sideload_main_window_get_type_once (void);
static void _vala_sideload_main_window_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_sideload_main_window_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);

static const gchar* SIDELOAD_MAIN_WINDOW_SUPPORTED_CONTENT_TYPES[3] = {SIDELOAD_MAIN_WINDOW_BUNDLE_CONTENT_TYPE, SIDELOAD_MAIN_WINDOW_REF_CONTENT_TYPE, SIDELOAD_MAIN_WINDOW_FLATPAK_HTTPS_CONTENT_TYPE};

static inline gpointer
sideload_main_window_get_instance_private (SideloadMainWindow* self)
{
	return G_STRUCT_MEMBER_P (self, SideloadMainWindow_private_offset);
}

SideloadMainWindow*
sideload_main_window_construct (GType object_type,
                                GtkApplication* application,
                                GFile* file)
{
	SideloadMainWindow * self = NULL;
	g_return_val_if_fail (application != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	self = (SideloadMainWindow*) g_object_new (object_type, "application", application, "icon-name", "io.elementary.sideload", "resizable", FALSE, "title", _ ("Install Untrusted App"), "file", file, NULL);
	return self;
}

SideloadMainWindow*
sideload_main_window_new (GtkApplication* application,
                          GFile* file)
{
	return sideload_main_window_construct (SIDELOAD_TYPE_MAIN_WINDOW, application, file);
}

static void
sideload_main_window_get_details_data_free (gpointer _data)
{
	SideloadMainWindowGetDetailsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SideloadMainWindowGetDetailsData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
sideload_main_window_get_details (SideloadMainWindow* self,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	SideloadMainWindowGetDetailsData* _data_;
	SideloadMainWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SideloadMainWindowGetDetailsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, sideload_main_window_get_details_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	sideload_main_window_get_details_co (_data_);
}

static void
sideload_main_window_get_details_finish (SideloadMainWindow* self,
                                         GAsyncResult* _res_)
{
	SideloadMainWindowGetDetailsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
sideload_main_window_get_details_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	SideloadMainWindowGetDetailsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	sideload_main_window_get_details_co (_data_);
}

static gboolean
sideload_main_window_get_details_co (SideloadMainWindowGetDetailsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_flatpak_file;
	_data_->_state_ = 1;
	sideload_flatpak_file_get_details (_data_->_tmp0_, NULL, sideload_main_window_get_details_ready, _data_);
	return FALSE;
	_state_1:
	sideload_flatpak_file_get_details_finish (_data_->_tmp0_, _data_->_res_);
	_data_->_tmp1_ = _data_->self->priv->_flatpak_file;
	_data_->_state_ = 2;
	sideload_flatpak_file_get_name (_data_->_tmp1_, sideload_main_window_get_details_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp2_ = sideload_flatpak_file_get_name_finish (_data_->_tmp1_, _data_->_res_);
	_g_free0 (_data_->self->priv->app_name);
	_data_->self->priv->app_name = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->self->priv->_flatpak_file;
	_data_->_state_ = 3;
	sideload_flatpak_file_get_id (_data_->_tmp3_, sideload_main_window_get_details_ready, _data_);
	return FALSE;
	_state_3:
	_data_->_tmp4_ = sideload_flatpak_file_get_id_finish (_data_->_tmp3_, _data_->_res_);
	_g_free0 (_data_->self->priv->app_id);
	_data_->self->priv->app_id = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->self->priv->app_name;
	if (_data_->_tmp5_ != NULL) {
		_data_->_tmp6_ = _data_->self->priv->progress_view;
		_data_->_tmp7_ = _data_->self->priv->app_name;
		sideload_progress_view_set_app_name (_data_->_tmp6_, _data_->_tmp7_);
		_data_->_tmp8_ = _data_->self->priv->main_view;
		_data_->_tmp9_ = _data_->self->priv->app_name;
		sideload_main_view_set_app_name (_data_->_tmp8_, _data_->_tmp9_);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
sideload_main_window_on_install_button_clicked (SideloadMainWindow* self)
{
	GCancellable* _tmp0_;
	SideloadFlatpakFile* _tmp1_;
	GCancellable* _tmp2_;
	GtkStack* _tmp3_;
	SideloadProgressView* _tmp4_;
	SideloadFlatpakFile* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->current_cancellable);
	self->priv->current_cancellable = _tmp0_;
	_tmp1_ = self->priv->_flatpak_file;
	_tmp2_ = self->priv->current_cancellable;
	sideload_flatpak_file_install (_tmp1_, _tmp2_, NULL, NULL);
	_tmp3_ = self->priv->stack;
	_tmp4_ = self->priv->progress_view;
	gtk_stack_set_visible_child (_tmp3_, (GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->_flatpak_file;
	if (SIDELOAD_IS_FLATPAK_REF_FILE (_tmp5_)) {
		granite_services_application_set_progress_visible (TRUE, NULL, NULL);
	}
}

static void
sideload_main_window_on_progress_changed (SideloadMainWindow* self,
                                          const gchar* description,
                                          gdouble progress)
{
	SideloadProgressView* _tmp0_;
	SideloadProgressView* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (description != NULL);
	_tmp0_ = self->priv->progress_view;
	sideload_progress_view_set_status (_tmp0_, description);
	_tmp1_ = self->priv->progress_view;
	sideload_progress_view_set_progress (_tmp1_, progress);
	granite_services_application_set_progress (progress, NULL, NULL);
}

static void
sideload_main_window_on_install_failed (SideloadMainWindow* self,
                                        gint error_code,
                                        const gchar* error_message)
{
	SideloadFlatpakFile* _tmp11_;
	g_return_if_fail (self != NULL);
	switch (error_code) {
		case FLATPAK_ERROR_ALREADY_INSTALLED:
		{
			SideloadSuccessView* success_view = NULL;
			const gchar* _tmp0_;
			SideloadSuccessView* _tmp1_;
			GtkStack* _tmp2_;
			SideloadSuccessView* _tmp3_;
			GtkStack* _tmp4_;
			SideloadSuccessView* _tmp5_;
			_tmp0_ = self->priv->app_name;
			_tmp1_ = sideload_success_view_new (_tmp0_, SIDELOAD_SUCCESS_VIEW_SUCCESS_TYPE_ALREADY_INSTALLED);
			g_object_ref_sink (_tmp1_);
			success_view = _tmp1_;
			_tmp2_ = self->priv->stack;
			_tmp3_ = success_view;
			gtk_stack_add_child (_tmp2_, (GtkWidget*) _tmp3_);
			_tmp4_ = self->priv->stack;
			_tmp5_ = success_view;
			gtk_stack_set_visible_child (_tmp4_, (GtkWidget*) _tmp5_);
			_g_object_unref0 (success_view);
			break;
		}
		case FLATPAK_ERROR_ABORTED:
		{
			break;
		}
		default:
		{
			SideloadErrorView* error_view = NULL;
			SideloadErrorView* _tmp6_;
			GtkStack* _tmp7_;
			SideloadErrorView* _tmp8_;
			GtkStack* _tmp9_;
			SideloadErrorView* _tmp10_;
			_tmp6_ = sideload_error_view_new (error_code, error_message);
			g_object_ref_sink (_tmp6_);
			error_view = _tmp6_;
			_tmp7_ = self->priv->stack;
			_tmp8_ = error_view;
			gtk_stack_add_child (_tmp7_, (GtkWidget*) _tmp8_);
			_tmp9_ = self->priv->stack;
			_tmp10_ = error_view;
			gtk_stack_set_visible_child (_tmp9_, (GtkWidget*) _tmp10_);
			_g_object_unref0 (error_view);
			break;
		}
	}
	_tmp11_ = self->priv->_flatpak_file;
	if (SIDELOAD_IS_FLATPAK_REF_FILE (_tmp11_)) {
		granite_services_application_set_progress_visible (FALSE, NULL, NULL);
	}
}

static void
sideload_main_window_on_install_succeeded (SideloadMainWindow* self)
{
	SideloadSuccessView* success_view = NULL;
	const gchar* _tmp0_;
	SideloadSuccessView* _tmp1_;
	GtkStack* _tmp2_;
	SideloadSuccessView* _tmp3_;
	GtkStack* _tmp4_;
	SideloadSuccessView* _tmp5_;
	SideloadFlatpakFile* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->app_name;
	_tmp1_ = sideload_success_view_new (_tmp0_, SIDELOAD_SUCCESS_VIEW_SUCCESS_TYPE_INSTALLED);
	g_object_ref_sink (_tmp1_);
	success_view = _tmp1_;
	_tmp2_ = self->priv->stack;
	_tmp3_ = success_view;
	gtk_stack_add_child (_tmp2_, (GtkWidget*) _tmp3_);
	_tmp4_ = self->priv->stack;
	_tmp5_ = success_view;
	gtk_stack_set_visible_child (_tmp4_, (GtkWidget*) _tmp5_);
	_tmp6_ = self->priv->_flatpak_file;
	if (SIDELOAD_IS_FLATPAK_REF_FILE (_tmp6_)) {
		granite_services_application_set_progress_visible (FALSE, NULL, NULL);
	}
	g_object_get ((GtkWindow*) self, "is-active", &_tmp7_, NULL);
	_tmp8_ = _tmp7_;
	if (!_tmp8_) {
		GNotification* notification = NULL;
		GNotification* _tmp9_;
		const gchar* _tmp10_;
		GIcon* icon = NULL;
		GIcon* _tmp16_;
		GIcon* _tmp17_;
		GtkApplication* _tmp20_;
		GtkApplication* _tmp21_;
		GNotification* _tmp22_;
		_tmp9_ = g_notification_new (_ ("App installed"));
		notification = _tmp9_;
		_tmp10_ = self->priv->app_name;
		if (_tmp10_ != NULL) {
			GNotification* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp11_ = notification;
			_tmp12_ = self->priv->app_name;
			_tmp13_ = g_strdup_printf (_ ("Installed “%s”"), _tmp12_);
			_tmp14_ = _tmp13_;
			g_notification_set_body (_tmp11_, _tmp14_);
			_g_free0 (_tmp14_);
		} else {
			GNotification* _tmp15_;
			_tmp15_ = notification;
			g_notification_set_body (_tmp15_, _ ("The app was installed"));
		}
		_tmp16_ = sideload_main_window_get_application_icon (self);
		icon = _tmp16_;
		_tmp17_ = icon;
		if (_tmp17_ != NULL) {
			GNotification* _tmp18_;
			GIcon* _tmp19_;
			_tmp18_ = notification;
			_tmp19_ = icon;
			g_notification_set_icon (_tmp18_, _tmp19_);
		}
		_tmp20_ = gtk_window_get_application ((GtkWindow*) self);
		_tmp21_ = _tmp20_;
		_tmp22_ = notification;
		g_application_send_notification ((GApplication*) _tmp21_, "installed", _tmp22_);
		_g_object_unref0 (icon);
		_g_object_unref0 (notification);
	}
	_g_object_unref0 (success_view);
}

static GIcon*
sideload_main_window_get_application_icon (SideloadMainWindow* self)
{
	GDesktopAppInfo* desktop_info = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GDesktopAppInfo* _tmp3_;
	GDesktopAppInfo* _tmp4_;
	GDesktopAppInfo* _tmp5_;
	GIcon* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->app_id;
	_tmp1_ = g_strconcat (_tmp0_, ".desktop", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_desktop_app_info_new (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	desktop_info = _tmp4_;
	_tmp5_ = desktop_info;
	if (_tmp5_ != NULL) {
		GDesktopAppInfo* _tmp6_;
		GIcon* _tmp7_;
		GIcon* _tmp8_;
		_tmp6_ = desktop_info;
		_tmp7_ = g_app_info_get_icon ((GAppInfo*) _tmp6_);
		_tmp8_ = _g_object_ref0 (_tmp7_);
		result = _tmp8_;
		_g_object_unref0 (desktop_info);
		return result;
	}
	result = NULL;
	_g_object_unref0 (desktop_info);
	return result;
}

GFile*
sideload_main_window_get_file (SideloadMainWindow* self)
{
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_file;
	result = _tmp0_;
	return result;
}

static void
sideload_main_window_set_file (SideloadMainWindow* self,
                               GFile* value)
{
	GFile* old_value;
	g_return_if_fail (self != NULL);
	old_value = sideload_main_window_get_file (self);
	if (old_value != value) {
		GFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_file);
		self->priv->_file = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sideload_main_window_properties[SIDELOAD_MAIN_WINDOW_FILE_PROPERTY]);
	}
}

SideloadFlatpakFile*
sideload_main_window_get_flatpak_file (SideloadMainWindow* self)
{
	SideloadFlatpakFile* result;
	SideloadFlatpakFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_flatpak_file;
	result = _tmp0_;
	return result;
}

static void
sideload_main_window_set_flatpak_file (SideloadMainWindow* self,
                                       SideloadFlatpakFile* value)
{
	SideloadFlatpakFile* old_value;
	g_return_if_fail (self != NULL);
	old_value = sideload_main_window_get_flatpak_file (self);
	if (old_value != value) {
		SideloadFlatpakFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_flatpak_file);
		self->priv->_flatpak_file = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sideload_main_window_properties[SIDELOAD_MAIN_WINDOW_FLATPAK_FILE_PROPERTY]);
	}
}

static void
_sideload_main_window___lambda21_ (SideloadMainWindow* self)
{
	GCancellable* _tmp0_;
	_tmp0_ = self->priv->current_cancellable;
	if (_tmp0_ != NULL) {
		GCancellable* _tmp1_;
		_tmp1_ = self->priv->current_cancellable;
		g_cancellable_cancel (_tmp1_);
	}
}

static void
__sideload_main_window___lambda21__g_application_shutdown (GApplication* _sender,
                                                           gpointer self)
{
	_sideload_main_window___lambda21_ ((SideloadMainWindow*) self);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gboolean
_vala_string_array_contains (const gchar* * stack,
                             gssize stack_length,
                             const const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
_sideload_main_window_on_install_button_clicked_sideload_main_view_install_request (SideloadMainView* _sender,
                                                                                    gpointer self)
{
	sideload_main_window_on_install_button_clicked ((SideloadMainWindow*) self);
}

static void
_sideload_main_window_on_progress_changed_sideload_flatpak_file_progress_changed (SideloadFlatpakFile* _sender,
                                                                                  const gchar* description,
                                                                                  gdouble progress,
                                                                                  gpointer self)
{
	sideload_main_window_on_progress_changed ((SideloadMainWindow*) self, description, progress);
}

static void
_sideload_main_window_on_install_failed_sideload_flatpak_file_installation_failed (SideloadFlatpakFile* _sender,
                                                                                   gint error_code,
                                                                                   const gchar* message,
                                                                                   gpointer self)
{
	sideload_main_window_on_install_failed ((SideloadMainWindow*) self, error_code, message);
}

static void
_sideload_main_window_on_install_succeeded_sideload_flatpak_file_installation_succeeded (SideloadFlatpakFile* _sender,
                                                                                         gpointer self)
{
	sideload_main_window_on_install_succeeded ((SideloadMainWindow*) self);
}

static void
_sideload_main_window___lambda29_ (SideloadMainWindow* self)
{
	SideloadFlatpakFile* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_tmp0_ = self->priv->_flatpak_file;
	_tmp1_ = sideload_flatpak_file_get_already_installed (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		SideloadSuccessView* success_view = NULL;
		const gchar* _tmp3_;
		SideloadSuccessView* _tmp4_;
		GtkStack* _tmp5_;
		SideloadSuccessView* _tmp6_;
		GtkStack* _tmp7_;
		SideloadSuccessView* _tmp8_;
		_tmp3_ = self->priv->app_name;
		_tmp4_ = sideload_success_view_new (_tmp3_, SIDELOAD_SUCCESS_VIEW_SUCCESS_TYPE_ALREADY_INSTALLED);
		g_object_ref_sink (_tmp4_);
		success_view = _tmp4_;
		_tmp5_ = self->priv->stack;
		_tmp6_ = success_view;
		gtk_stack_add_child (_tmp5_, (GtkWidget*) _tmp6_);
		_tmp7_ = self->priv->stack;
		_tmp8_ = success_view;
		gtk_stack_set_visible_child (_tmp7_, (GtkWidget*) _tmp8_);
		_g_object_unref0 (success_view);
	} else {
		SideloadFlatpakFile* _tmp9_;
		_tmp9_ = self->priv->_flatpak_file;
		if (SIDELOAD_IS_FLATPAK_REF_FILE (_tmp9_)) {
			SideloadMainView* _tmp10_;
			SideloadFlatpakFile* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			SideloadFlatpakFile* _tmp14_;
			gboolean _tmp15_;
			gboolean _tmp16_;
			SideloadFlatpakFile* _tmp17_;
			SideloadFlatpakFilePermissionsFlags _tmp18_;
			SideloadFlatpakFilePermissionsFlags _tmp19_;
			_tmp10_ = self->priv->main_view;
			_tmp11_ = self->priv->_flatpak_file;
			_tmp12_ = sideload_flatpak_file_get_size (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = self->priv->_flatpak_file;
			_tmp15_ = sideload_flatpak_file_get_extra_remotes_needed (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = self->priv->_flatpak_file;
			_tmp18_ = sideload_flatpak_file_get_permissions_flags (_tmp17_);
			_tmp19_ = _tmp18_;
			sideload_main_view_display_ref_details (_tmp10_, _tmp13_, _tmp16_, _tmp19_);
		} else {
			SideloadFlatpakFile* _tmp20_;
			_tmp20_ = self->priv->_flatpak_file;
			if (SIDELOAD_IS_FLATPAK_BUNDLE_FILE (_tmp20_)) {
				SideloadMainView* _tmp21_;
				SideloadFlatpakFile* _tmp22_;
				const gchar* _tmp23_;
				const gchar* _tmp24_;
				SideloadFlatpakFile* _tmp25_;
				gboolean _tmp26_;
				gboolean _tmp27_;
				SideloadFlatpakFile* _tmp28_;
				gboolean _tmp29_;
				gboolean _tmp30_;
				_tmp21_ = self->priv->main_view;
				_tmp22_ = self->priv->_flatpak_file;
				_tmp23_ = sideload_flatpak_file_get_size (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = self->priv->_flatpak_file;
				_tmp26_ = sideload_flatpak_bundle_file_get_has_remote (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, SIDELOAD_TYPE_FLATPAK_BUNDLE_FILE, SideloadFlatpakBundleFile));
				_tmp27_ = _tmp26_;
				_tmp28_ = self->priv->_flatpak_file;
				_tmp29_ = sideload_flatpak_file_get_extra_remotes_needed (_tmp28_);
				_tmp30_ = _tmp29_;
				sideload_main_view_display_bundle_details (_tmp21_, _tmp24_, _tmp27_, _tmp30_);
			}
		}
	}
}

static void
__sideload_main_window___lambda29__sideload_flatpak_file_details_ready (SideloadFlatpakFile* _sender,
                                                                        gpointer self)
{
	_sideload_main_window___lambda29_ ((SideloadMainWindow*) self);
}

static GObject *
sideload_main_window_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SideloadMainWindow * self;
	GtkImage* image = NULL;
	GtkImage* _tmp0_ = NULL;
	SideloadMainView* _tmp1_;
	GtkStack* _tmp2_ = NULL;
	GtkStack* _tmp3_;
	SideloadMainView* _tmp4_;
	GtkStack* _tmp5_;
	SideloadMainView* _tmp6_;
	GtkWindowHandle* window_handle = NULL;
	GtkStack* _tmp7_;
	GtkWidget* _tmp8_;
	GtkWindowHandle* _tmp9_ = NULL;
	GtkWindowHandle* _tmp10_;
	GtkGrid* null_title = NULL;
	GtkGrid* _tmp11_ = NULL;
	GtkGrid* _tmp12_;
	GApplication* _tmp13_;
	GFile* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gboolean _tmp17_;
	GFileInfo* file_info = NULL;
	GFileInfo* _tmp68_;
	gchar* content_type = NULL;
	GFileInfo* _tmp76_;
	gchar* _tmp77_;
	const gchar* _tmp78_;
	const gchar* _tmp86_;
	const gchar* _tmp94_;
	const gchar* _tmp95_;
	GQuark _tmp97_ = 0U;
	static GQuark _tmp96_label0 = 0;
	static GQuark _tmp96_label1 = 0;
	static GQuark _tmp96_label2 = 0;
	SideloadFlatpakFile* _tmp104_;
	const gchar* _tmp105_;
	const gchar* _tmp106_;
	SideloadFlatpakFile* _tmp115_;
	GtkStack* _tmp124_;
	SideloadProgressView* _tmp125_;
	SideloadMainView* _tmp126_;
	SideloadFlatpakFile* _tmp127_;
	SideloadFlatpakFile* _tmp128_;
	SideloadFlatpakFile* _tmp129_;
	SideloadFlatpakFile* _tmp130_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (sideload_main_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SIDELOAD_TYPE_MAIN_WINDOW, SideloadMainWindow);
	_tmp0_ = (GtkImage*) gtk_image_new_from_icon_name ("io.elementary.sideload");
	gtk_image_set_pixel_size (_tmp0_, 48);
	gtk_widget_set_valign ((GtkWidget*) _tmp0_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp0_);
	image = _tmp0_;
	_tmp1_ = sideload_main_view_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->main_view);
	self->priv->main_view = _tmp1_;
	_tmp2_ = (GtkStack*) gtk_stack_new ();
	gtk_stack_set_transition_type (_tmp2_, GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT_RIGHT);
	gtk_stack_set_vhomogeneous (_tmp2_, FALSE);
	gtk_stack_set_interpolate_size (_tmp2_, TRUE);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->stack);
	self->priv->stack = _tmp2_;
	_tmp3_ = self->priv->stack;
	_tmp4_ = self->priv->main_view;
	gtk_stack_add_child (_tmp3_, (GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->stack;
	_tmp6_ = self->priv->main_view;
	gtk_stack_set_visible_child (_tmp5_, (GtkWidget*) _tmp6_);
	_tmp7_ = self->priv->stack;
	_tmp8_ = _g_object_ref0 ((GtkWidget*) _tmp7_);
	_tmp9_ = (GtkWindowHandle*) gtk_window_handle_new ();
	gtk_window_handle_set_child (_tmp9_, _tmp8_);
	_g_object_unref0 (_tmp8_);
	g_object_ref_sink (_tmp9_);
	window_handle = _tmp9_;
	_tmp10_ = window_handle;
	gtk_window_set_child ((GtkWindow*) self, (GtkWidget*) _tmp10_);
	_tmp11_ = (GtkGrid*) gtk_grid_new ();
	gtk_widget_set_visible ((GtkWidget*) _tmp11_, FALSE);
	g_object_ref_sink (_tmp11_);
	null_title = _tmp11_;
	_tmp12_ = null_title;
	gtk_window_set_titlebar ((GtkWindow*) self, (GtkWidget*) _tmp12_);
	gtk_widget_add_css_class ((GtkWidget*) self, "dialog");
	gtk_widget_add_css_class ((GtkWidget*) self, GRANITE_STYLE_CLASS_MESSAGE_DIALOG);
	_tmp13_ = g_application_get_default ();
	g_signal_connect_object (_tmp13_, "shutdown", (GCallback) __sideload_main_window___lambda21__g_application_shutdown, self, 0);
	_tmp14_ = self->priv->_file;
	_tmp15_ = g_file_get_uri (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_str_has_prefix (_tmp16_, "flatpak+https://");
	_g_free0 (_tmp16_);
	if (_tmp17_) {
		gchar* uri = NULL;
		GFile* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* path = NULL;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		GFile* remote_file = NULL;
		const gchar* _tmp29_;
		GFile* _tmp30_;
		GFile* local_file = NULL;
		const gchar* _tmp31_;
		GFile* _tmp32_;
		GFile* _tmp54_;
		_tmp18_ = self->priv->_file;
		_tmp19_ = g_file_get_uri (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = string_replace (_tmp20_, "flatpak+https://", "https://");
		_tmp22_ = _tmp21_;
		_g_free0 (_tmp20_);
		uri = _tmp22_;
		_tmp23_ = g_get_user_special_dir (G_USER_DIRECTORY_DOWNLOAD);
		_tmp24_ = uri;
		_tmp25_ = g_path_get_basename (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = g_build_filename (_tmp23_, _tmp26_, NULL);
		_tmp28_ = _tmp27_;
		_g_free0 (_tmp26_);
		path = _tmp28_;
		_tmp29_ = uri;
		_tmp30_ = g_file_new_for_uri (_tmp29_);
		remote_file = _tmp30_;
		_tmp31_ = path;
		_tmp32_ = g_file_new_for_path (_tmp31_);
		local_file = _tmp32_;
		{
			gboolean _tmp33_ = FALSE;
			GFile* _tmp34_;
			GFile* _tmp35_;
			_tmp34_ = remote_file;
			_tmp35_ = local_file;
			_tmp33_ = g_file_copy (_tmp34_, _tmp35_, G_FILE_COPY_OVERWRITE, NULL, NULL, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			if (!_tmp33_) {
				gchar* message = NULL;
				const gchar* _tmp36_;
				gchar* _tmp37_;
				SideloadErrorView* error_view = NULL;
				const gchar* _tmp38_;
				SideloadErrorView* _tmp39_;
				GtkStack* _tmp40_;
				SideloadErrorView* _tmp41_;
				GtkStack* _tmp42_;
				SideloadErrorView* _tmp43_;
				_tmp36_ = uri;
				_tmp37_ = g_strdup_printf (_ ("Failed to download file from %s"), _tmp36_);
				message = _tmp37_;
				_tmp38_ = message;
				_tmp39_ = sideload_error_view_new (-1, _tmp38_);
				g_object_ref_sink (_tmp39_);
				error_view = _tmp39_;
				_tmp40_ = self->priv->stack;
				_tmp41_ = error_view;
				gtk_stack_add_child (_tmp40_, (GtkWidget*) _tmp41_);
				_tmp42_ = self->priv->stack;
				_tmp43_ = error_view;
				gtk_stack_set_visible_child (_tmp42_, (GtkWidget*) _tmp43_);
				_g_object_unref0 (error_view);
				_g_free0 (message);
				_g_object_unref0 (local_file);
				_g_object_unref0 (remote_file);
				_g_free0 (path);
				_g_free0 (uri);
				_g_object_unref0 (null_title);
				_g_object_unref0 (window_handle);
				_g_object_unref0 (image);
				return obj;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			gchar* message = NULL;
			const gchar* _tmp44_;
			GError* _tmp45_;
			const gchar* _tmp46_;
			gchar* _tmp47_;
			SideloadErrorView* error_view = NULL;
			const gchar* _tmp48_;
			SideloadErrorView* _tmp49_;
			GtkStack* _tmp50_;
			SideloadErrorView* _tmp51_;
			GtkStack* _tmp52_;
			SideloadErrorView* _tmp53_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp44_ = uri;
			_tmp45_ = e;
			_tmp46_ = _tmp45_->message;
			_tmp47_ = g_strdup_printf (_ ("Failed to download file from %s: %s"), _tmp44_, _tmp46_);
			message = _tmp47_;
			_tmp48_ = message;
			_tmp49_ = sideload_error_view_new (-1, _tmp48_);
			g_object_ref_sink (_tmp49_);
			error_view = _tmp49_;
			_tmp50_ = self->priv->stack;
			_tmp51_ = error_view;
			gtk_stack_add_child (_tmp50_, (GtkWidget*) _tmp51_);
			_tmp52_ = self->priv->stack;
			_tmp53_ = error_view;
			gtk_stack_set_visible_child (_tmp52_, (GtkWidget*) _tmp53_);
			_g_object_unref0 (error_view);
			_g_free0 (message);
			_g_error_free0 (e);
			_g_object_unref0 (local_file);
			_g_object_unref0 (remote_file);
			_g_free0 (path);
			_g_free0 (uri);
			_g_object_unref0 (null_title);
			_g_object_unref0 (window_handle);
			_g_object_unref0 (image);
			return obj;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (local_file);
			_g_object_unref0 (remote_file);
			_g_free0 (path);
			_g_free0 (uri);
			_g_object_unref0 (null_title);
			_g_object_unref0 (window_handle);
			_g_object_unref0 (image);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		_tmp54_ = local_file;
		sideload_main_window_set_file (self, _tmp54_);
		_g_object_unref0 (local_file);
		_g_object_unref0 (remote_file);
		_g_free0 (path);
		_g_free0 (uri);
	}
	file_info = NULL;
	{
		GFileInfo* _tmp55_ = NULL;
		GFile* _tmp56_;
		GFileInfo* _tmp57_;
		GFileInfo* _tmp58_;
		_tmp56_ = self->priv->_file;
		_tmp57_ = g_file_query_info (_tmp56_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		_tmp55_ = _tmp57_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp58_ = _tmp55_;
		_tmp55_ = NULL;
		_g_object_unref0 (file_info);
		file_info = _tmp58_;
		_g_object_unref0 (_tmp55_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		gchar* message = NULL;
		GError* _tmp59_;
		const gchar* _tmp60_;
		gchar* _tmp61_;
		SideloadErrorView* error_view = NULL;
		const gchar* _tmp62_;
		SideloadErrorView* _tmp63_;
		GtkStack* _tmp64_;
		SideloadErrorView* _tmp65_;
		GtkStack* _tmp66_;
		SideloadErrorView* _tmp67_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp59_ = e;
		_tmp60_ = _tmp59_->message;
		_tmp61_ = g_strdup_printf (_ ("Unable to query content type of provided file: %s"), _tmp60_);
		message = _tmp61_;
		_tmp62_ = message;
		_tmp63_ = sideload_error_view_new (-1, _tmp62_);
		g_object_ref_sink (_tmp63_);
		error_view = _tmp63_;
		_tmp64_ = self->priv->stack;
		_tmp65_ = error_view;
		gtk_stack_add_child (_tmp64_, (GtkWidget*) _tmp65_);
		_tmp66_ = self->priv->stack;
		_tmp67_ = error_view;
		gtk_stack_set_visible_child (_tmp66_, (GtkWidget*) _tmp67_);
		_g_object_unref0 (error_view);
		_g_free0 (message);
		_g_error_free0 (e);
		_g_object_unref0 (file_info);
		_g_object_unref0 (null_title);
		_g_object_unref0 (window_handle);
		_g_object_unref0 (image);
		return obj;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (file_info);
		_g_object_unref0 (null_title);
		_g_object_unref0 (window_handle);
		_g_object_unref0 (image);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp68_ = file_info;
	if (_tmp68_ == NULL) {
		gchar* message = NULL;
		gchar* _tmp69_;
		SideloadErrorView* error_view = NULL;
		const gchar* _tmp70_;
		SideloadErrorView* _tmp71_;
		GtkStack* _tmp72_;
		SideloadErrorView* _tmp73_;
		GtkStack* _tmp74_;
		SideloadErrorView* _tmp75_;
		_tmp69_ = g_strdup (_ ("Unable to query content type of provided file"));
		message = _tmp69_;
		_tmp70_ = message;
		_tmp71_ = sideload_error_view_new (-1, _tmp70_);
		g_object_ref_sink (_tmp71_);
		error_view = _tmp71_;
		_tmp72_ = self->priv->stack;
		_tmp73_ = error_view;
		gtk_stack_add_child (_tmp72_, (GtkWidget*) _tmp73_);
		_tmp74_ = self->priv->stack;
		_tmp75_ = error_view;
		gtk_stack_set_visible_child (_tmp74_, (GtkWidget*) _tmp75_);
		_g_object_unref0 (error_view);
		_g_free0 (message);
		_g_object_unref0 (file_info);
		_g_object_unref0 (null_title);
		_g_object_unref0 (window_handle);
		_g_object_unref0 (image);
		return obj;
	}
	_tmp76_ = file_info;
	_tmp77_ = g_file_info_get_attribute_as_string (_tmp76_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE);
	content_type = _tmp77_;
	_tmp78_ = content_type;
	if (_tmp78_ == NULL) {
		gchar* message = NULL;
		gchar* _tmp79_;
		SideloadErrorView* error_view = NULL;
		const gchar* _tmp80_;
		SideloadErrorView* _tmp81_;
		GtkStack* _tmp82_;
		SideloadErrorView* _tmp83_;
		GtkStack* _tmp84_;
		SideloadErrorView* _tmp85_;
		_tmp79_ = g_strdup (_ ("Unable to query content type of provided file"));
		message = _tmp79_;
		_tmp80_ = message;
		_tmp81_ = sideload_error_view_new (-1, _tmp80_);
		g_object_ref_sink (_tmp81_);
		error_view = _tmp81_;
		_tmp82_ = self->priv->stack;
		_tmp83_ = error_view;
		gtk_stack_add_child (_tmp82_, (GtkWidget*) _tmp83_);
		_tmp84_ = self->priv->stack;
		_tmp85_ = error_view;
		gtk_stack_set_visible_child (_tmp84_, (GtkWidget*) _tmp85_);
		_g_object_unref0 (error_view);
		_g_free0 (message);
		_g_free0 (content_type);
		_g_object_unref0 (file_info);
		_g_object_unref0 (null_title);
		_g_object_unref0 (window_handle);
		_g_object_unref0 (image);
		return obj;
	}
	_tmp86_ = content_type;
	if (!_vala_string_array_contains (SIDELOAD_MAIN_WINDOW_SUPPORTED_CONTENT_TYPES, G_N_ELEMENTS (SIDELOAD_MAIN_WINDOW_SUPPORTED_CONTENT_TYPES), _tmp86_)) {
		gchar* message = NULL;
		gchar* _tmp87_;
		SideloadErrorView* error_view = NULL;
		const gchar* _tmp88_;
		SideloadErrorView* _tmp89_;
		GtkStack* _tmp90_;
		SideloadErrorView* _tmp91_;
		GtkStack* _tmp92_;
		SideloadErrorView* _tmp93_;
		_tmp87_ = g_strdup (_ ("This does not appear to be a valid flatpak/flatpakref file"));
		message = _tmp87_;
		_tmp88_ = message;
		_tmp89_ = sideload_error_view_new (-1, _tmp88_);
		g_object_ref_sink (_tmp89_);
		error_view = _tmp89_;
		_tmp90_ = self->priv->stack;
		_tmp91_ = error_view;
		gtk_stack_add_child (_tmp90_, (GtkWidget*) _tmp91_);
		_tmp92_ = self->priv->stack;
		_tmp93_ = error_view;
		gtk_stack_set_visible_child (_tmp92_, (GtkWidget*) _tmp93_);
		_g_object_unref0 (error_view);
		_g_free0 (message);
		_g_free0 (content_type);
		_g_object_unref0 (file_info);
		_g_object_unref0 (null_title);
		_g_object_unref0 (window_handle);
		_g_object_unref0 (image);
		return obj;
	}
	_tmp94_ = content_type;
	_tmp95_ = _tmp94_;
	_tmp97_ = (NULL == _tmp95_) ? 0 : g_quark_from_string (_tmp95_);
	if ((_tmp97_ == ((0 != _tmp96_label0) ? _tmp96_label0 : (_tmp96_label0 = g_quark_from_static_string (SIDELOAD_MAIN_WINDOW_REF_CONTENT_TYPE)))) || (_tmp97_ == ((0 != _tmp96_label1) ? _tmp96_label1 : (_tmp96_label1 = g_quark_from_static_string (SIDELOAD_MAIN_WINDOW_FLATPAK_HTTPS_CONTENT_TYPE))))) {
		switch (0) {
			default:
			{
				GFile* _tmp98_;
				SideloadFlatpakRefFile* _tmp99_;
				SideloadFlatpakRefFile* _tmp100_;
				_tmp98_ = self->priv->_file;
				_tmp99_ = sideload_flatpak_ref_file_new (_tmp98_);
				_tmp100_ = _tmp99_;
				sideload_main_window_set_flatpak_file (self, (SideloadFlatpakFile*) _tmp100_);
				_g_object_unref0 (_tmp100_);
				break;
			}
		}
	} else if (_tmp97_ == ((0 != _tmp96_label2) ? _tmp96_label2 : (_tmp96_label2 = g_quark_from_static_string (SIDELOAD_MAIN_WINDOW_BUNDLE_CONTENT_TYPE)))) {
		switch (0) {
			default:
			{
				GFile* _tmp101_;
				SideloadFlatpakBundleFile* _tmp102_;
				SideloadFlatpakBundleFile* _tmp103_;
				_tmp101_ = self->priv->_file;
				_tmp102_ = sideload_flatpak_bundle_file_new (_tmp101_);
				_tmp103_ = _tmp102_;
				sideload_main_window_set_flatpak_file (self, (SideloadFlatpakFile*) _tmp103_);
				_g_object_unref0 (_tmp103_);
				break;
			}
		}
	}
	_tmp104_ = self->priv->_flatpak_file;
	_tmp105_ = sideload_flatpak_file_get_size (_tmp104_);
	_tmp106_ = _tmp105_;
	if (g_strcmp0 (_tmp106_, "0") == 0) {
		SideloadErrorView* error_view = NULL;
		SideloadFlatpakFile* _tmp107_;
		SideloadFlatpakFile* _tmp108_;
		const gchar* _tmp109_;
		SideloadErrorView* _tmp110_;
		GtkStack* _tmp111_;
		SideloadErrorView* _tmp112_;
		GtkStack* _tmp113_;
		SideloadErrorView* _tmp114_;
		_tmp107_ = self->priv->_flatpak_file;
		_tmp108_ = self->priv->_flatpak_file;
		_tmp109_ = _tmp108_->error_message;
		_tmp110_ = sideload_error_view_new (_tmp107_->error_code, _tmp109_);
		g_object_ref_sink (_tmp110_);
		error_view = _tmp110_;
		_tmp111_ = self->priv->stack;
		_tmp112_ = error_view;
		gtk_stack_add_child (_tmp111_, (GtkWidget*) _tmp112_);
		_tmp113_ = self->priv->stack;
		_tmp114_ = error_view;
		gtk_stack_set_visible_child (_tmp113_, (GtkWidget*) _tmp114_);
		_g_object_unref0 (error_view);
		_g_free0 (content_type);
		_g_object_unref0 (file_info);
		_g_object_unref0 (null_title);
		_g_object_unref0 (window_handle);
		_g_object_unref0 (image);
		return obj;
	}
	_tmp115_ = self->priv->_flatpak_file;
	if (SIDELOAD_IS_FLATPAK_REF_FILE (_tmp115_)) {
		SideloadProgressView* _tmp116_;
		_tmp116_ = sideload_progress_view_new (SIDELOAD_PROGRESS_VIEW_PROGRESS_TYPE_REF_INSTALL);
		g_object_ref_sink (_tmp116_);
		_g_object_unref0 (self->priv->progress_view);
		self->priv->progress_view = _tmp116_;
	} else {
		SideloadProgressView* _tmp117_;
		SideloadProgressView* _tmp118_;
		SideloadFlatpakFile* _tmp119_;
		const gchar* _tmp120_;
		const gchar* _tmp121_;
		gchar* _tmp122_;
		gchar* _tmp123_;
		_tmp117_ = sideload_progress_view_new (SIDELOAD_PROGRESS_VIEW_PROGRESS_TYPE_BUNDLE_INSTALL);
		g_object_ref_sink (_tmp117_);
		_g_object_unref0 (self->priv->progress_view);
		self->priv->progress_view = _tmp117_;
		_tmp118_ = self->priv->progress_view;
		_tmp119_ = self->priv->_flatpak_file;
		_tmp120_ = sideload_flatpak_file_get_size (_tmp119_);
		_tmp121_ = _tmp120_;
		_tmp122_ = g_strdup_printf (_ ("Installing %s. Unable to estimate time remaining."), _tmp121_);
		_tmp123_ = _tmp122_;
		sideload_progress_view_set_status (_tmp118_, _tmp123_);
		_g_free0 (_tmp123_);
	}
	_tmp124_ = self->priv->stack;
	_tmp125_ = self->priv->progress_view;
	gtk_stack_add_child (_tmp124_, (GtkWidget*) _tmp125_);
	_tmp126_ = self->priv->main_view;
	g_signal_connect_object (_tmp126_, "install-request", (GCallback) _sideload_main_window_on_install_button_clicked_sideload_main_view_install_request, self, 0);
	_tmp127_ = self->priv->_flatpak_file;
	g_signal_connect_object (_tmp127_, "progress-changed", (GCallback) _sideload_main_window_on_progress_changed_sideload_flatpak_file_progress_changed, self, 0);
	_tmp128_ = self->priv->_flatpak_file;
	g_signal_connect_object (_tmp128_, "installation-failed", (GCallback) _sideload_main_window_on_install_failed_sideload_flatpak_file_installation_failed, self, 0);
	_tmp129_ = self->priv->_flatpak_file;
	g_signal_connect_object (_tmp129_, "installation-succeeded", (GCallback) _sideload_main_window_on_install_succeeded_sideload_flatpak_file_installation_succeeded, self, 0);
	_tmp130_ = self->priv->_flatpak_file;
	g_signal_connect_object (_tmp130_, "details-ready", (GCallback) __sideload_main_window___lambda29__sideload_flatpak_file_details_ready, self, 0);
	sideload_main_window_get_details (self, NULL, NULL);
	_g_free0 (content_type);
	_g_object_unref0 (file_info);
	_g_object_unref0 (null_title);
	_g_object_unref0 (window_handle);
	_g_object_unref0 (image);
	return obj;
}

static void
sideload_main_window_class_init (SideloadMainWindowClass * klass,
                                 gpointer klass_data)
{
	sideload_main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SideloadMainWindow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_sideload_main_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sideload_main_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = sideload_main_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = sideload_main_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDELOAD_MAIN_WINDOW_FILE_PROPERTY, sideload_main_window_properties[SIDELOAD_MAIN_WINDOW_FILE_PROPERTY] = g_param_spec_object ("file", "file", "file", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDELOAD_MAIN_WINDOW_FLATPAK_FILE_PROPERTY, sideload_main_window_properties[SIDELOAD_MAIN_WINDOW_FLATPAK_FILE_PROPERTY] = g_param_spec_object ("flatpak-file", "flatpak-file", "flatpak-file", SIDELOAD_TYPE_FLATPAK_FILE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
sideload_main_window_instance_init (SideloadMainWindow * self,
                                    gpointer klass)
{
	self->priv = sideload_main_window_get_instance_private (self);
	self->priv->current_cancellable = NULL;
	self->priv->app_name = NULL;
	self->priv->app_id = NULL;
}

static void
sideload_main_window_finalize (GObject * obj)
{
	SideloadMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SIDELOAD_TYPE_MAIN_WINDOW, SideloadMainWindow);
	_g_object_unref0 (self->priv->_file);
	_g_object_unref0 (self->priv->_flatpak_file);
	_g_object_unref0 (self->priv->current_cancellable);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->main_view);
	_g_object_unref0 (self->priv->progress_view);
	_g_free0 (self->priv->app_name);
	_g_free0 (self->priv->app_id);
	G_OBJECT_CLASS (sideload_main_window_parent_class)->finalize (obj);
}

static GType
sideload_main_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SideloadMainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sideload_main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SideloadMainWindow), 0, (GInstanceInitFunc) sideload_main_window_instance_init, NULL };
	GType sideload_main_window_type_id;
	sideload_main_window_type_id = g_type_register_static (gtk_application_window_get_type (), "SideloadMainWindow", &g_define_type_info, 0);
	SideloadMainWindow_private_offset = g_type_add_instance_private (sideload_main_window_type_id, sizeof (SideloadMainWindowPrivate));
	return sideload_main_window_type_id;
}

GType
sideload_main_window_get_type (void)
{
	static volatile gsize sideload_main_window_type_id__once = 0;
	if (g_once_init_enter (&sideload_main_window_type_id__once)) {
		GType sideload_main_window_type_id;
		sideload_main_window_type_id = sideload_main_window_get_type_once ();
		g_once_init_leave (&sideload_main_window_type_id__once, sideload_main_window_type_id);
	}
	return sideload_main_window_type_id__once;
}

static void
_vala_sideload_main_window_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	SideloadMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SIDELOAD_TYPE_MAIN_WINDOW, SideloadMainWindow);
	switch (property_id) {
		case SIDELOAD_MAIN_WINDOW_FILE_PROPERTY:
		g_value_set_object (value, sideload_main_window_get_file (self));
		break;
		case SIDELOAD_MAIN_WINDOW_FLATPAK_FILE_PROPERTY:
		g_value_set_object (value, sideload_main_window_get_flatpak_file (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_sideload_main_window_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	SideloadMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SIDELOAD_TYPE_MAIN_WINDOW, SideloadMainWindow);
	switch (property_id) {
		case SIDELOAD_MAIN_WINDOW_FILE_PROPERTY:
		sideload_main_window_set_file (self, g_value_get_object (value));
		break;
		case SIDELOAD_MAIN_WINDOW_FLATPAK_FILE_PROPERTY:
		sideload_main_window_set_flatpak_file (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

