// python wrapper for vtkPVDataDeliveryManager
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVDataDeliveryManager.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVDataDeliveryManager(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVDataDeliveryManager_ClassNew(); }


static PyObject *
PyvtkPVDataDeliveryManager_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVDataDeliveryManager::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataDeliveryManager_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataDeliveryManager *op = static_cast<vtkPVDataDeliveryManager *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVDataDeliveryManager::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataDeliveryManager_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVDataDeliveryManager *tempr = vtkPVDataDeliveryManager::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataDeliveryManager_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataDeliveryManager *op = static_cast<vtkPVDataDeliveryManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVDataDeliveryManager *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVDataDeliveryManager::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataDeliveryManager_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVDataDeliveryManager::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataDeliveryManager_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataDeliveryManager *op = static_cast<vtkPVDataDeliveryManager *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVDataDeliveryManager::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataDeliveryManager_SetView(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetView");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataDeliveryManager *op = static_cast<vtkPVDataDeliveryManager *>(vp);

  vtkPVView *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVView"))
  {
    if (ap.IsBound())
    {
      op->SetView(temp0);
    }
    else
    {
      op->vtkPVDataDeliveryManager::SetView(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataDeliveryManager_GetView(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetView");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataDeliveryManager *op = static_cast<vtkPVDataDeliveryManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVView *tempr = (ap.IsBound() ?
      op->GetView() :
      op->vtkPVDataDeliveryManager::GetView());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataDeliveryManager_GetSynchronizationMagicNumber(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSynchronizationMagicNumber");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataDeliveryManager *op = static_cast<vtkPVDataDeliveryManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetSynchronizationMagicNumber() :
      op->vtkPVDataDeliveryManager::GetSynchronizationMagicNumber());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataDeliveryManager_RegisterRepresentation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RegisterRepresentation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataDeliveryManager *op = static_cast<vtkPVDataDeliveryManager *>(vp);

  vtkPVDataRepresentation *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVDataRepresentation"))
  {
    if (ap.IsBound())
    {
      op->RegisterRepresentation(temp0);
    }
    else
    {
      op->vtkPVDataDeliveryManager::RegisterRepresentation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataDeliveryManager_UnRegisterRepresentation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UnRegisterRepresentation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataDeliveryManager *op = static_cast<vtkPVDataDeliveryManager *>(vp);

  vtkPVDataRepresentation *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVDataRepresentation"))
  {
    if (ap.IsBound())
    {
      op->UnRegisterRepresentation(temp0);
    }
    else
    {
      op->vtkPVDataDeliveryManager::UnRegisterRepresentation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataDeliveryManager_GetRepresentation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRepresentation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataDeliveryManager *op = static_cast<vtkPVDataDeliveryManager *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkPVDataRepresentation *tempr = (ap.IsBound() ?
      op->GetRepresentation(temp0) :
      op->vtkPVDataDeliveryManager::GetRepresentation(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataDeliveryManager_SetPiece(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPiece");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataDeliveryManager *op = static_cast<vtkPVDataDeliveryManager *>(vp);

  vtkPVDataRepresentation *temp0 = nullptr;
  vtkDataObject *temp1 = nullptr;
  bool temp2 = false;
  unsigned long temp3 = 0;
  int temp4 = 0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3, 5) &&
      ap.GetVTKObject(temp0, "vtkPVDataRepresentation") &&
      ap.GetVTKObject(temp1, "vtkDataObject") &&
      ap.GetValue(temp2) &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp4)))
  {
    if (ap.IsBound())
    {
      op->SetPiece(temp0, temp1, temp2, temp3, temp4);
    }
    else
    {
      op->vtkPVDataDeliveryManager::SetPiece(temp0, temp1, temp2, temp3, temp4);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataDeliveryManager_HasPiece(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HasPiece");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataDeliveryManager *op = static_cast<vtkPVDataDeliveryManager *>(vp);

  vtkPVDataRepresentation *temp0 = nullptr;
  bool temp1 = false;
  int temp2 = 0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 3) &&
      ap.GetVTKObject(temp0, "vtkPVDataRepresentation") &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)))
  {
    bool tempr = (ap.IsBound() ?
      op->HasPiece(temp0, temp1, temp2) :
      op->vtkPVDataDeliveryManager::HasPiece(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataDeliveryManager_GetPiece(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPiece");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataDeliveryManager *op = static_cast<vtkPVDataDeliveryManager *>(vp);

  vtkPVDataRepresentation *temp0 = nullptr;
  bool temp1 = false;
  int temp2 = 0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2, 3) &&
      ap.GetVTKObject(temp0, "vtkPVDataRepresentation") &&
      ap.GetValue(temp1) &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)))
  {
    vtkDataObject *tempr = (ap.IsBound() ?
      op->GetPiece(temp0, temp1, temp2) :
      op->vtkPVDataDeliveryManager::GetPiece(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataDeliveryManager_GetDeliveredPiece(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDeliveredPiece");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataDeliveryManager *op = static_cast<vtkPVDataDeliveryManager *>(vp);

  vtkPVDataRepresentation *temp0 = nullptr;
  bool temp1 = false;
  int temp2 = 0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2, 3) &&
      ap.GetVTKObject(temp0, "vtkPVDataRepresentation") &&
      ap.GetValue(temp1) &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)))
  {
    vtkDataObject *tempr = (ap.IsBound() ?
      op->GetDeliveredPiece(temp0, temp1, temp2) :
      op->vtkPVDataDeliveryManager::GetDeliveredPiece(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataDeliveryManager_ClearCache(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearCache");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataDeliveryManager *op = static_cast<vtkPVDataDeliveryManager *>(vp);

  vtkPVDataRepresentation *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVDataRepresentation"))
  {
    if (ap.IsBound())
    {
      op->ClearCache(temp0);
    }
    else
    {
      op->vtkPVDataDeliveryManager::ClearCache(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataDeliveryManager_GetProducer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetProducer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataDeliveryManager *op = static_cast<vtkPVDataDeliveryManager *>(vp);

  vtkPVDataRepresentation *temp0 = nullptr;
  bool temp1 = false;
  int temp2 = 0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2, 3) &&
      ap.GetVTKObject(temp0, "vtkPVDataRepresentation") &&
      ap.GetValue(temp1) &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)))
  {
    vtkAlgorithmOutput *tempr = (ap.IsBound() ?
      op->GetProducer(temp0, temp1, temp2) :
      op->vtkPVDataDeliveryManager::GetProducer(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataDeliveryManager_GetPieceInformation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPieceInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataDeliveryManager *op = static_cast<vtkPVDataDeliveryManager *>(vp);

  vtkPVDataRepresentation *temp0 = nullptr;
  bool temp1 = false;
  int temp2 = 0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2, 3) &&
      ap.GetVTKObject(temp0, "vtkPVDataRepresentation") &&
      ap.GetValue(temp1) &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)))
  {
    vtkInformation *tempr = (ap.IsBound() ?
      op->GetPieceInformation(temp0, temp1, temp2) :
      op->vtkPVDataDeliveryManager::GetPieceInformation(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataDeliveryManager_GetNumberOfPorts(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfPorts");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataDeliveryManager *op = static_cast<vtkPVDataDeliveryManager *>(vp);

  vtkPVDataRepresentation *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVDataRepresentation"))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfPorts(temp0) :
      op->vtkPVDataDeliveryManager::GetNumberOfPorts(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataDeliveryManager_GetVisibleDataSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetVisibleDataSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataDeliveryManager *op = static_cast<vtkPVDataDeliveryManager *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    unsigned long tempr = (ap.IsBound() ?
      op->GetVisibleDataSize(temp0) :
      op->vtkPVDataDeliveryManager::GetVisibleDataSize(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataDeliveryManager_NeedsDelivery(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NeedsDelivery");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataDeliveryManager *op = static_cast<vtkPVDataDeliveryManager *>(vp);

  unsigned long temp0;
  std::vector<unsigned int> temp1(ap.GetArgSize(1));
  bool temp2 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1.data(), temp1.size()) &&
      ap.GetValue(temp2))
  {
    bool tempr = (ap.IsBound() ?
      op->NeedsDelivery(temp0, temp1, temp2) :
      op->vtkPVDataDeliveryManager::NeedsDelivery(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      PyObject *vec = (temp1.empty() ?
        PyTuple_New(0) :
        vtkPythonArgs::BuildTuple(temp1.data(), temp1.size()));
      ap.SetContents(1, vec);
      Py_DECREF(vec);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataDeliveryManager_Deliver(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Deliver");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataDeliveryManager *op = static_cast<vtkPVDataDeliveryManager *>(vp);

  int temp0;
  unsigned int temp1;
  size_t size2 = ap.GetArgSize(2);
  vtkPythonArgs::Array<unsigned int> store2(2*size2);
  unsigned int *temp2 = store2.Data();
  unsigned int *save2 = (size2 == 0 ? nullptr : temp2 + size2);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetArray(temp2, size2))
  {
    vtkPythonArgs::Save(temp2, save2, size2);

    if (ap.IsBound())
    {
      op->Deliver(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVDataDeliveryManager::Deliver(temp0, temp1, temp2);
    }

    if (vtkPythonArgs::HasChanged(temp2, save2, size2) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(2, temp2, size2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataDeliveryManager_GetDeliveredDataKey(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDeliveredDataKey");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataDeliveryManager *op = static_cast<vtkPVDataDeliveryManager *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDeliveredDataKey(temp0) :
      op->vtkPVDataDeliveryManager::GetDeliveredDataKey(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPVDataDeliveryManager_Methods[] = {
  {"IsTypeOf", PyvtkPVDataDeliveryManager_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVDataDeliveryManager_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVDataDeliveryManager_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVDataDeliveryManager\nC++: static vtkPVDataDeliveryManager *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVDataDeliveryManager_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVDataDeliveryManager\nC++: vtkPVDataDeliveryManager *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVDataDeliveryManager_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVDataDeliveryManager_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetView", PyvtkPVDataDeliveryManager_SetView, METH_VARARGS,
   "SetView(self, __a:vtkPVView) -> None\nC++: void SetView(vtkPVView *)\n\nGet/Set the render-view. The view is not reference counted.\n"},
  {"GetView", PyvtkPVDataDeliveryManager_GetView, METH_VARARGS,
   "GetView(self) -> vtkPVView\nC++: vtkPVView *GetView()\n\n"},
  {"GetSynchronizationMagicNumber", PyvtkPVDataDeliveryManager_GetSynchronizationMagicNumber, METH_VARARGS,
   "GetSynchronizationMagicNumber(self) -> int\nC++: int GetSynchronizationMagicNumber()\n\nReturned a hash number that can be used to verify that both\nclient and server side are in synch representation wise for\ndelivery.\n"},
  {"RegisterRepresentation", PyvtkPVDataDeliveryManager_RegisterRepresentation, METH_VARARGS,
   "RegisterRepresentation(self, repr:vtkPVDataRepresentation) -> None\nC++: void RegisterRepresentation(vtkPVDataRepresentation *repr)\n\nView uses these methods to register a representation with the\nstorage. This makes it possible for representations to\ncommunicate with the storage directly using a self pointer, while\nenables views on different processes to communicate information\nabout representations using their unique ids.\n"},
  {"UnRegisterRepresentation", PyvtkPVDataDeliveryManager_UnRegisterRepresentation, METH_VARARGS,
   "UnRegisterRepresentation(self, __a:vtkPVDataRepresentation)\n    -> None\nC++: void UnRegisterRepresentation(vtkPVDataRepresentation *)\n\n"},
  {"GetRepresentation", PyvtkPVDataDeliveryManager_GetRepresentation, METH_VARARGS,
   "GetRepresentation(self, __a:int) -> vtkPVDataRepresentation\nC++: vtkPVDataRepresentation *GetRepresentation(unsigned int)\n\n"},
  {"SetPiece", PyvtkPVDataDeliveryManager_SetPiece, METH_VARARGS,
   "SetPiece(self, repr:vtkPVDataRepresentation, data:vtkDataObject,\n    low_res:bool, trueSize:int=0, port:int=0) -> None\nC++: void SetPiece(vtkPVDataRepresentation *repr,\n    vtkDataObject *data, bool low_res, unsigned long trueSize=0,\n    int port=0)\n\nRepresentations (indirectly via vtkPVRenderView::SetPiece()) call\nthis method to register the geometry type they are rendering.\nEvery representation that requires delivering of any geometry\nmust register with the vtkPVDataDeliveryManager and never manage\nthe delivery on its own.\n"},
  {"HasPiece", PyvtkPVDataDeliveryManager_HasPiece, METH_VARARGS,
   "HasPiece(self, repr:vtkPVDataRepresentation, low_res:bool=False,\n    port:int=0) -> bool\nC++: bool HasPiece(vtkPVDataRepresentation *repr,\n    bool low_res=false, int port=0)\n\n"},
  {"GetPiece", PyvtkPVDataDeliveryManager_GetPiece, METH_VARARGS,
   "GetPiece(self, repr:vtkPVDataRepresentation, low_res:bool,\n    port:int=0) -> vtkDataObject\nC++: vtkDataObject *GetPiece(vtkPVDataRepresentation *repr,\n    bool low_res, int port=0)\n\nReturns the local data object set by calling `SetPiece` (or from\nthe cache). This is the data object pre-delivery.\n"},
  {"GetDeliveredPiece", PyvtkPVDataDeliveryManager_GetDeliveredPiece, METH_VARARGS,
   "GetDeliveredPiece(self, repr:vtkPVDataRepresentation,\n    low_res:bool, port:int=0) -> vtkDataObject\nC++: vtkDataObject *GetDeliveredPiece(\n    vtkPVDataRepresentation *repr, bool low_res, int port=0)\n\nReturns the data object post-delivery.\n"},
  {"ClearCache", PyvtkPVDataDeliveryManager_ClearCache, METH_VARARGS,
   "ClearCache(self, repr:vtkPVDataRepresentation) -> None\nC++: void ClearCache(vtkPVDataRepresentation *repr)\n\nClear all cached data objects for the given representation.\n"},
  {"GetProducer", PyvtkPVDataDeliveryManager_GetProducer, METH_VARARGS,
   "GetProducer(self, __a:vtkPVDataRepresentation, low_res:bool,\n    port:int=0) -> vtkAlgorithmOutput\nC++: vtkAlgorithmOutput *GetProducer(vtkPVDataRepresentation *,\n    bool low_res, int port=0)\n\nProvides access to the producer port for the geometry of a\nregistered representation. Representations use these methods\n(indirectly via vtkPVRenderView::GetPieceProducer() and\nGetPieceProducerLOD()) to obtain the geometry producer for the\ngeometry to be rendered.\n"},
  {"GetPieceInformation", PyvtkPVDataDeliveryManager_GetPieceInformation, METH_VARARGS,
   "GetPieceInformation(self, repr:vtkPVDataRepresentation,\n    low_res:bool, port:int=0) -> vtkInformation\nC++: vtkInformation *GetPieceInformation(\n    vtkPVDataRepresentation *repr, bool low_res, int port=0)\n\nSet/Get meta-data container for the specific piece. Views can use\nit to store arbitrary metadata for each piece.\n"},
  {"GetNumberOfPorts", PyvtkPVDataDeliveryManager_GetNumberOfPorts, METH_VARARGS,
   "GetNumberOfPorts(self, repr:vtkPVDataRepresentation) -> int\nC++: int GetNumberOfPorts(vtkPVDataRepresentation *repr)\n\nReturns number of known port for the representation.\n"},
  {"GetVisibleDataSize", PyvtkPVDataDeliveryManager_GetVisibleDataSize, METH_VARARGS,
   "GetVisibleDataSize(self, low_res:bool) -> int\nC++: unsigned long GetVisibleDataSize(bool low_res)\n\nReturns the size for all visible geometry. If low_res is true,\nand low-res data is not available for a particular\nrepresentation, then it's high-res data size will be used\nassuming that the representation is going to render the high-res\ngeometry for low-res rendering as well.\n"},
  {"NeedsDelivery", PyvtkPVDataDeliveryManager_NeedsDelivery, METH_VARARGS,
   "NeedsDelivery(self, timestamp:int, keys_to_deliver:[int, ...],\n    use_lod:bool) -> bool\nC++: bool NeedsDelivery(vtkMTimeType timestamp,\n    std::vector<unsigned int> &keys_to_deliver, bool use_lod)\n\nInternal method used to determine the list of representations\nthat need their geometry delivered. This is done on the \"client\"\nside, with the client decide what geometries it needs and then\nrequests those from the server-sides using Deliver().\n"},
  {"Deliver", PyvtkPVDataDeliveryManager_Deliver, METH_VARARGS,
   "Deliver(self, use_low_res:int, size:int, keys:[int, ...]) -> None\nC++: void Deliver(int use_low_res, unsigned int size,\n    unsigned int *keys)\n\nTriggers delivery for the geometries of indicated\nrepresentations.\n"},
  {"GetDeliveredDataKey", PyvtkPVDataDeliveryManager_GetDeliveredDataKey, METH_VARARGS,
   "GetDeliveredDataKey(self, low_res:bool) -> int\nC++: virtual int GetDeliveredDataKey(bool low_res)\n\nViews that support changing of which ranks do the rendering at\nruntime based on things like data sizes, etc. may override this\nmethod to provide a unique key for each different mode. This\nmakes it possible to keep delivered data object for each mode\nseparate and thus avoid transfers if the mode is changed on the\nfly.\n\nDefault implementation simply returns 0.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVDataDeliveryManager_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("view"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataDeliveryManager_GetView(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVDataDeliveryManager_SetView(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVDataDeliveryManager_SetView(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetView/SetView\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("synchronization_magic_number"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataDeliveryManager_GetSynchronizationMagicNumber(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetSynchronizationMagicNumber\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVDataDeliveryManager_Doc =
  "vtkPVDataDeliveryManager - manager for data-delivery.\n\n"
  "Superclass: vtkObject\n\n"
  "ParaView's multi-configuration / multi-process modes pose a challenge\n"
  "for views. At runtime, the current configuration will determine which\n"
  "processes have what parts of data and which processes are expected to\n"
  "\"render\" that data. While views and their representations may add\n"
  "certain qualifiers to this statement, generally speaking, all views\n"
  "have to support taking the data from the data-processing nodes and\n"
  "delivering it to the rendering nodes. This is where\n"
  "vtkPVDataDeliveryManager comes in play. It helps views (viz.\n"
  "vtkPVView subclasses) move the data.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVDataDeliveryManager_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkPVDataDeliveryManager", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVDataDeliveryManager_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

PyObject *PyvtkPVDataDeliveryManager_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVDataDeliveryManager_Type, PyvtkPVDataDeliveryManager_Methods,
    "vtkPVDataDeliveryManager",
 nullptr);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVDataDeliveryManager_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVDataDeliveryManager(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVDataDeliveryManager_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVDataDeliveryManager", o) != 0)
  {
    Py_DECREF(o);
  }

}

