/* DefaultApplicationDockItemProvider.c generated by valac 0.56.17, the Vala compiler
 * generated from DefaultApplicationDockItemProvider.vala, do not modify */

/**/
/*  Copyright (C) 2013 Rico Tzschichholz*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "plank.h"
#include <glib.h>
#include <libbamf/libbamf.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <libwnck/libwnck.h>
#include <gee.h>
#include "plank-internal.h"
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PLANK_DEFAULT_APPLICATION_DOCK_ITEM_PROVIDER_0_PROPERTY,
	PLANK_DEFAULT_APPLICATION_DOCK_ITEM_PROVIDER_PREFS_PROPERTY,
	PLANK_DEFAULT_APPLICATION_DOCK_ITEM_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* plank_default_application_dock_item_provider_properties[PLANK_DEFAULT_APPLICATION_DOCK_ITEM_PROVIDER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _PlankDefaultApplicationDockItemProviderPrivate {
	PlankDockPreferences* _Prefs;
	gboolean current_workspace_only;
};

static gint PlankDefaultApplicationDockItemProvider_private_offset;
static gpointer plank_default_application_dock_item_provider_parent_class = NULL;

static void plank_default_application_dock_item_provider_handle_setting_changed (PlankDefaultApplicationDockItemProvider* self);
static void _plank_default_application_dock_item_provider_handle_setting_changed_g_object_notify (GObject* _sender,
                                                                                           GParamSpec* pspec,
                                                                                           gpointer self);
static void plank_default_application_dock_item_provider_handle_pinned_only_changed (PlankDefaultApplicationDockItemProvider* self);
static void _plank_default_application_dock_item_provider_handle_pinned_only_changed_g_object_notify (GObject* _sender,
                                                                                               GParamSpec* pspec,
                                                                                               gpointer self);
static void plank_default_application_dock_item_provider_disconnect_wnck (PlankDefaultApplicationDockItemProvider* self);
static void plank_default_application_dock_item_provider_real_update_visible_elements (PlankDockContainer* base);
VALA_EXTERN BamfApplication* plank_application_dock_item_get_App (PlankApplicationDockItem* self);
static void plank_default_application_dock_item_provider_real_prepare (PlankDockContainer* base);
static void plank_default_application_dock_item_provider_add_transient_items (PlankDefaultApplicationDockItemProvider* self);
static void plank_default_application_dock_item_provider_real_app_opened (PlankApplicationDockItemProvider* base,
                                                                   BamfApplication* app);
VALA_EXTERN void plank_application_dock_item_set_App (PlankApplicationDockItem* self,
                                          BamfApplication* value);
VALA_EXTERN PlankTransientDockItem* plank_transient_dock_item_new_with_application (BamfApplication* app);
VALA_EXTERN PlankTransientDockItem* plank_transient_dock_item_construct_with_application (GType object_type,
                                                                              BamfApplication* app);
static void plank_default_application_dock_item_provider_app_closed (PlankDefaultApplicationDockItemProvider* self,
                                                              PlankDockItem* item);
static void plank_default_application_dock_item_provider_connect_wnck (PlankDefaultApplicationDockItemProvider* self);
static void plank_default_application_dock_item_provider_handle_window_changed (WnckScreen* screen,
                                                                         WnckWindow* previous,
                                                                         PlankDefaultApplicationDockItemProvider* self);
static void _plank_default_application_dock_item_provider_handle_window_changed_wnck_screen_active_window_changed (WnckScreen* _sender,
                                                                                                            WnckWindow* previous_window,
                                                                                                            gpointer self);
static void plank_default_application_dock_item_provider_handle_workspace_changed (WnckScreen* screen,
                                                                            WnckWorkspace* previous,
                                                                            PlankDefaultApplicationDockItemProvider* self);
static void _plank_default_application_dock_item_provider_handle_workspace_changed_wnck_screen_active_workspace_changed (WnckScreen* _sender,
                                                                                                                  WnckWorkspace* previous_workspace,
                                                                                                                  gpointer self);
static void plank_default_application_dock_item_provider_handle_viewports_changed (WnckScreen* screen,
                                                                            PlankDefaultApplicationDockItemProvider* self);
static void _plank_default_application_dock_item_provider_handle_viewports_changed_wnck_screen_viewports_changed (WnckScreen* _sender,
                                                                                                           gpointer self);
static void plank_default_application_dock_item_provider_remove_transient_items (PlankDefaultApplicationDockItemProvider* self);
static void plank_default_application_dock_item_provider_real_connect_element (PlankDockContainer* base,
                                                                        PlankDockElement* element);
static void _plank_default_application_dock_item_provider_app_closed_plank_application_dock_item_app_closed (PlankApplicationDockItem* _sender,
                                                                                                      gpointer self);
static void _plank_default_application_dock_item_provider_pin_item_plank_application_dock_item_pin_launcher (PlankApplicationDockItem* _sender,
                                                                                                      gpointer self);
static void plank_default_application_dock_item_provider_real_disconnect_element (PlankDockContainer* base,
                                                                           PlankDockElement* element);
static void plank_default_application_dock_item_provider_real_handle_item_deleted (PlankDockItemProvider* base,
                                                                            PlankDockItem* item);
static GObject * plank_default_application_dock_item_provider_constructor (GType type,
                                                                    guint n_construct_properties,
                                                                    GObjectConstructParam * construct_properties);
static void plank_default_application_dock_item_provider_finalize (GObject * obj);
static GType plank_default_application_dock_item_provider_get_type_once (void);
static void _vala_plank_default_application_dock_item_provider_get_property (GObject * object,
                                                                      guint property_id,
                                                                      GValue * value,
                                                                      GParamSpec * pspec);
static void _vala_plank_default_application_dock_item_provider_set_property (GObject * object,
                                                                      guint property_id,
                                                                      const GValue * value,
                                                                      GParamSpec * pspec);

static inline gpointer
plank_default_application_dock_item_provider_get_instance_private (PlankDefaultApplicationDockItemProvider* self)
{
	return G_STRUCT_MEMBER_P (self, PlankDefaultApplicationDockItemProvider_private_offset);
}

static void
_plank_default_application_dock_item_provider_handle_setting_changed_g_object_notify (GObject* _sender,
                                                                                      GParamSpec* pspec,
                                                                                      gpointer self)
{
	plank_default_application_dock_item_provider_handle_setting_changed ((PlankDefaultApplicationDockItemProvider*) self);
}

static void
_plank_default_application_dock_item_provider_handle_pinned_only_changed_g_object_notify (GObject* _sender,
                                                                                          GParamSpec* pspec,
                                                                                          gpointer self)
{
	plank_default_application_dock_item_provider_handle_pinned_only_changed ((PlankDefaultApplicationDockItemProvider*) self);
}

/**
 * Creates the default container for dock items.
 *
 * @param prefs the preferences of the dock which owns this provider
 */
PlankDefaultApplicationDockItemProvider*
plank_default_application_dock_item_provider_construct (GType object_type,
                                                        PlankDockPreferences* prefs,
                                                        GFile* launchers_dir)
{
	PlankDefaultApplicationDockItemProvider * self = NULL;
	g_return_val_if_fail (prefs != NULL, NULL);
	g_return_val_if_fail (launchers_dir != NULL, NULL);
	self = (PlankDefaultApplicationDockItemProvider*) g_object_new (object_type, "Prefs", prefs, "LaunchersDir", launchers_dir, NULL);
	return self;
}

PlankDefaultApplicationDockItemProvider*
plank_default_application_dock_item_provider_new (PlankDockPreferences* prefs,
                                                  GFile* launchers_dir)
{
	return plank_default_application_dock_item_provider_construct (PLANK_TYPE_DEFAULT_APPLICATION_DOCK_ITEM_PROVIDER, prefs, launchers_dir);
}

static void
plank_default_application_dock_item_provider_real_update_visible_elements (PlankDockContainer* base)
{
	PlankDefaultApplicationDockItemProvider * self;
	PlankDockPreferences* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = (PlankDefaultApplicationDockItemProvider*) base;
	plank_logger_verbose ("DefaultDockItemProvider.update_visible_items ()", NULL);
	_tmp0_ = self->priv->_Prefs;
	_tmp1_ = plank_dock_preferences_get_CurrentWorkspaceOnly (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		WnckWorkspace* active_workspace = NULL;
		WnckScreen* _tmp3_;
		WnckWorkspace* _tmp4_;
		_tmp3_ = wnck_screen_get_default ();
		_tmp4_ = wnck_screen_get_active_workspace (_tmp3_);
		active_workspace = _tmp4_;
		{
			GeeArrayList* _item_list = NULL;
			GeeArrayList* _tmp5_;
			gint _item_size = 0;
			GeeArrayList* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gint _item_index = 0;
			_tmp5_ = ((PlankDockContainer*) self)->internal_elements;
			_item_list = _tmp5_;
			_tmp6_ = _item_list;
			_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
			_tmp8_ = _tmp7_;
			_item_size = _tmp8_;
			_item_index = -1;
			while (TRUE) {
				gint _tmp9_;
				gint _tmp10_;
				PlankDockElement* item = NULL;
				GeeArrayList* _tmp11_;
				gpointer _tmp12_;
				PlankTransientDockItem* transient = NULL;
				PlankDockElement* _tmp13_;
				gboolean _tmp14_ = FALSE;
				gboolean _tmp15_ = FALSE;
				gboolean _tmp16_ = FALSE;
				PlankTransientDockItem* _tmp17_;
				PlankDockElement* _tmp26_;
				_item_index = _item_index + 1;
				_tmp9_ = _item_index;
				_tmp10_ = _item_size;
				if (!(_tmp9_ < _tmp10_)) {
					break;
				}
				_tmp11_ = _item_list;
				_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _item_index);
				item = (PlankDockElement*) _tmp12_;
				_tmp13_ = item;
				transient = PLANK_IS_TRANSIENT_DOCK_ITEM (_tmp13_) ? ((PlankTransientDockItem*) _tmp13_) : NULL;
				_tmp17_ = transient;
				if (_tmp17_ == NULL) {
					_tmp16_ = TRUE;
				} else {
					PlankTransientDockItem* _tmp18_;
					BamfApplication* _tmp19_;
					BamfApplication* _tmp20_;
					_tmp18_ = transient;
					_tmp19_ = plank_application_dock_item_get_App ((PlankApplicationDockItem*) _tmp18_);
					_tmp20_ = _tmp19_;
					_tmp16_ = _tmp20_ == NULL;
				}
				if (_tmp16_) {
					_tmp15_ = TRUE;
				} else {
					WnckWorkspace* _tmp21_;
					_tmp21_ = active_workspace;
					_tmp15_ = _tmp21_ == NULL;
				}
				if (_tmp15_) {
					_tmp14_ = TRUE;
				} else {
					PlankTransientDockItem* _tmp22_;
					BamfApplication* _tmp23_;
					BamfApplication* _tmp24_;
					WnckWorkspace* _tmp25_;
					_tmp22_ = transient;
					_tmp23_ = plank_application_dock_item_get_App ((PlankApplicationDockItem*) _tmp22_);
					_tmp24_ = _tmp23_;
					_tmp25_ = active_workspace;
					_tmp14_ = plank_window_control_has_window_on_workspace (_tmp24_, _tmp25_);
				}
				_tmp26_ = item;
				plank_dock_element_set_IsAttached (_tmp26_, _tmp14_);
				_g_object_unref0 (item);
			}
		}
	} else {
		{
			GeeArrayList* _item_list = NULL;
			GeeArrayList* _tmp27_;
			gint _item_size = 0;
			GeeArrayList* _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			gint _item_index = 0;
			_tmp27_ = ((PlankDockContainer*) self)->internal_elements;
			_item_list = _tmp27_;
			_tmp28_ = _item_list;
			_tmp29_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp28_);
			_tmp30_ = _tmp29_;
			_item_size = _tmp30_;
			_item_index = -1;
			while (TRUE) {
				gint _tmp31_;
				gint _tmp32_;
				PlankDockElement* item = NULL;
				GeeArrayList* _tmp33_;
				gpointer _tmp34_;
				PlankDockElement* _tmp35_;
				_item_index = _item_index + 1;
				_tmp31_ = _item_index;
				_tmp32_ = _item_size;
				if (!(_tmp31_ < _tmp32_)) {
					break;
				}
				_tmp33_ = _item_list;
				_tmp34_ = gee_abstract_list_get ((GeeAbstractList*) _tmp33_, _item_index);
				item = (PlankDockElement*) _tmp34_;
				_tmp35_ = item;
				plank_dock_element_set_IsAttached (_tmp35_, TRUE);
				_g_object_unref0 (item);
			}
		}
	}
	PLANK_DOCK_CONTAINER_CLASS (plank_default_application_dock_item_provider_parent_class)->update_visible_elements ((PlankDockContainer*) G_TYPE_CHECK_INSTANCE_CAST (self, PLANK_TYPE_APPLICATION_DOCK_ITEM_PROVIDER, PlankApplicationDockItemProvider));
}

/**
 * {@inheritDoc}
 */
static void
plank_default_application_dock_item_provider_real_prepare (PlankDockContainer* base)
{
	PlankDefaultApplicationDockItemProvider * self;
	PlankDockPreferences* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GeeArrayList* favs = NULL;
	GeeArrayList* _tmp3_;
	PlankMatcher* _tmp20_;
	PlankMatcher* _tmp21_;
	GeeArrayList* _tmp22_;
	self = (PlankDefaultApplicationDockItemProvider*) base;
	_tmp0_ = self->priv->_Prefs;
	_tmp1_ = plank_dock_preferences_get_PinnedOnly (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		plank_default_application_dock_item_provider_add_transient_items (self);
	}
	_tmp3_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	favs = _tmp3_;
	{
		GeeArrayList* _element_list = NULL;
		GeeArrayList* _tmp4_;
		gint _element_size = 0;
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _element_index = 0;
		_tmp4_ = ((PlankDockContainer*) self)->internal_elements;
		_element_list = _tmp4_;
		_tmp5_ = _element_list;
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_element_size = _tmp7_;
		_element_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			PlankDockElement* element = NULL;
			GeeArrayList* _tmp10_;
			gpointer _tmp11_;
			PlankApplicationDockItem* item = NULL;
			PlankDockElement* _tmp12_;
			gboolean _tmp13_ = FALSE;
			PlankApplicationDockItem* _tmp14_;
			_element_index = _element_index + 1;
			_tmp8_ = _element_index;
			_tmp9_ = _element_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _element_list;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _element_index);
			element = (PlankDockElement*) _tmp11_;
			_tmp12_ = element;
			item = PLANK_IS_APPLICATION_DOCK_ITEM (_tmp12_) ? ((PlankApplicationDockItem*) _tmp12_) : NULL;
			_tmp14_ = item;
			if (_tmp14_ != NULL) {
				PlankApplicationDockItem* _tmp15_;
				_tmp15_ = item;
				_tmp13_ = !PLANK_IS_TRANSIENT_DOCK_ITEM (_tmp15_);
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				GeeArrayList* _tmp16_;
				PlankApplicationDockItem* _tmp17_;
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				_tmp16_ = favs;
				_tmp17_ = item;
				_tmp18_ = plank_dock_item_get_Launcher ((PlankDockItem*) _tmp17_);
				_tmp19_ = _tmp18_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, _tmp19_);
			}
			_g_object_unref0 (element);
		}
	}
	_tmp20_ = plank_matcher_get_default ();
	_tmp21_ = _tmp20_;
	_tmp22_ = favs;
	plank_matcher_set_favorites (_tmp21_, _tmp22_);
	_g_object_unref0 (_tmp21_);
	_g_object_unref0 (favs);
}

static void
plank_default_application_dock_item_provider_real_app_opened (PlankApplicationDockItemProvider* base,
                                                              BamfApplication* app)
{
	PlankDefaultApplicationDockItemProvider * self;
	PlankApplicationDockItem* found = NULL;
	PlankApplicationDockItem* _tmp0_;
	PlankApplicationDockItem* _tmp1_;
	PlankDockPreferences* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	PlankTransientDockItem* new_item = NULL;
	PlankTransientDockItem* _tmp6_;
	PlankTransientDockItem* _tmp7_;
	self = (PlankDefaultApplicationDockItemProvider*) base;
	g_return_if_fail (app != NULL);
	_tmp0_ = plank_application_dock_item_provider_item_for_application ((PlankApplicationDockItemProvider*) self, app);
	found = _tmp0_;
	_tmp1_ = found;
	if (_tmp1_ != NULL) {
		PlankApplicationDockItem* _tmp2_;
		_tmp2_ = found;
		plank_application_dock_item_set_App (_tmp2_, app);
		return;
	}
	_tmp3_ = self->priv->_Prefs;
	_tmp4_ = plank_dock_preferences_get_PinnedOnly (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		return;
	}
	_tmp6_ = plank_transient_dock_item_new_with_application (app);
	new_item = _tmp6_;
	_tmp7_ = new_item;
	plank_dock_container_add ((PlankDockContainer*) self, (PlankDockElement*) _tmp7_, NULL);
	_g_object_unref0 (new_item);
}

static void
plank_default_application_dock_item_provider_app_closed (PlankDefaultApplicationDockItemProvider* self,
                                                         PlankDockItem* item)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	if (PLANK_IS_TRANSIENT_DOCK_ITEM (item)) {
		_tmp0_ = !plank_application_dock_item_has_unity_info ((PlankApplicationDockItem*) G_TYPE_CHECK_INSTANCE_CAST (item, PLANK_TYPE_TRANSIENT_DOCK_ITEM, PlankTransientDockItem));
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		plank_dock_container_remove ((PlankDockContainer*) self, (PlankDockElement*) item);
	}
}

static void
_plank_default_application_dock_item_provider_handle_window_changed_wnck_screen_active_window_changed (WnckScreen* _sender,
                                                                                                       WnckWindow* previous_window,
                                                                                                       gpointer self)
{
	plank_default_application_dock_item_provider_handle_window_changed (_sender, previous_window, (PlankDefaultApplicationDockItemProvider*) self);
}

static void
_plank_default_application_dock_item_provider_handle_workspace_changed_wnck_screen_active_workspace_changed (WnckScreen* _sender,
                                                                                                             WnckWorkspace* previous_workspace,
                                                                                                             gpointer self)
{
	plank_default_application_dock_item_provider_handle_workspace_changed (_sender, previous_workspace, (PlankDefaultApplicationDockItemProvider*) self);
}

static void
_plank_default_application_dock_item_provider_handle_viewports_changed_wnck_screen_viewports_changed (WnckScreen* _sender,
                                                                                                      gpointer self)
{
	plank_default_application_dock_item_provider_handle_viewports_changed (_sender, (PlankDefaultApplicationDockItemProvider*) self);
}

static void
plank_default_application_dock_item_provider_connect_wnck (PlankDefaultApplicationDockItemProvider* self)
{
	WnckScreen* screen = NULL;
	WnckScreen* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = wnck_screen_get_default ();
	screen = _tmp0_;
	g_signal_connect_object (screen, "active-window-changed", (GCallback) _plank_default_application_dock_item_provider_handle_window_changed_wnck_screen_active_window_changed, self, G_CONNECT_AFTER);
	g_signal_connect_object (screen, "active-workspace-changed", (GCallback) _plank_default_application_dock_item_provider_handle_workspace_changed_wnck_screen_active_workspace_changed, self, G_CONNECT_AFTER);
	g_signal_connect_object (screen, "viewports-changed", (GCallback) _plank_default_application_dock_item_provider_handle_viewports_changed_wnck_screen_viewports_changed, self, G_CONNECT_AFTER);
}

static void
plank_default_application_dock_item_provider_disconnect_wnck (PlankDefaultApplicationDockItemProvider* self)
{
	WnckScreen* screen = NULL;
	WnckScreen* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = wnck_screen_get_default ();
	screen = _tmp0_;
	g_signal_parse_name ("active-window-changed", wnck_screen_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (screen, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _plank_default_application_dock_item_provider_handle_window_changed_wnck_screen_active_window_changed, self);
	g_signal_parse_name ("active-workspace-changed", wnck_screen_get_type (), &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (screen, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _plank_default_application_dock_item_provider_handle_workspace_changed_wnck_screen_active_workspace_changed, self);
	g_signal_parse_name ("viewports-changed", wnck_screen_get_type (), &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (screen, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _plank_default_application_dock_item_provider_handle_viewports_changed_wnck_screen_viewports_changed, self);
}

static void
plank_default_application_dock_item_provider_handle_window_changed (WnckScreen* screen,
                                                                    WnckWindow* previous,
                                                                    PlankDefaultApplicationDockItemProvider* self)
{
	WnckWorkspace* active_workspace = NULL;
	WnckWorkspace* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (screen != NULL);
	_tmp0_ = wnck_screen_get_active_workspace (screen);
	active_workspace = _tmp0_;
	if (previous == NULL) {
		_tmp2_ = TRUE;
	} else {
		WnckWorkspace* _tmp3_;
		_tmp3_ = active_workspace;
		_tmp2_ = _tmp3_ == NULL;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		WnckWorkspace* _tmp4_;
		WnckWorkspace* _tmp5_;
		_tmp4_ = wnck_window_get_workspace (previous);
		_tmp5_ = active_workspace;
		_tmp1_ = _tmp4_ == _tmp5_;
	}
	if (_tmp1_) {
		return;
	}
	plank_dock_container_update_visible_elements ((PlankDockContainer*) self);
}

static void
plank_default_application_dock_item_provider_handle_workspace_changed (WnckScreen* screen,
                                                                       WnckWorkspace* previous,
                                                                       PlankDefaultApplicationDockItemProvider* self)
{
	WnckWorkspace* active_workspace = NULL;
	WnckWorkspace* _tmp0_;
	gboolean _tmp1_ = FALSE;
	WnckWorkspace* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (screen != NULL);
	_tmp0_ = wnck_screen_get_active_workspace (screen);
	active_workspace = _tmp0_;
	_tmp2_ = active_workspace;
	if (_tmp2_ != NULL) {
		WnckWorkspace* _tmp3_;
		_tmp3_ = active_workspace;
		_tmp1_ = wnck_workspace_is_virtual (_tmp3_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		return;
	}
	plank_dock_container_update_visible_elements ((PlankDockContainer*) self);
}

static void
plank_default_application_dock_item_provider_handle_viewports_changed (WnckScreen* screen,
                                                                       PlankDefaultApplicationDockItemProvider* self)
{
	WnckWorkspace* active_workspace = NULL;
	WnckWorkspace* _tmp0_;
	gboolean _tmp1_ = FALSE;
	WnckWorkspace* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (screen != NULL);
	_tmp0_ = wnck_screen_get_active_workspace (screen);
	active_workspace = _tmp0_;
	_tmp2_ = active_workspace;
	if (_tmp2_ != NULL) {
		WnckWorkspace* _tmp3_;
		_tmp3_ = active_workspace;
		_tmp1_ = !wnck_workspace_is_virtual (_tmp3_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		return;
	}
	plank_dock_container_update_visible_elements ((PlankDockContainer*) self);
}

static void
plank_default_application_dock_item_provider_handle_setting_changed (PlankDefaultApplicationDockItemProvider* self)
{
	PlankDockPreferences* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	PlankDockPreferences* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_Prefs;
	_tmp1_ = plank_dock_preferences_get_CurrentWorkspaceOnly (_tmp0_);
	_tmp2_ = _tmp1_;
	if (self->priv->current_workspace_only == _tmp2_) {
		return;
	}
	_tmp3_ = self->priv->_Prefs;
	_tmp4_ = plank_dock_preferences_get_CurrentWorkspaceOnly (_tmp3_);
	_tmp5_ = _tmp4_;
	self->priv->current_workspace_only = _tmp5_;
	if (self->priv->current_workspace_only) {
		plank_default_application_dock_item_provider_connect_wnck (self);
	} else {
		plank_default_application_dock_item_provider_disconnect_wnck (self);
	}
	plank_dock_container_update_visible_elements ((PlankDockContainer*) self);
}

static void
plank_default_application_dock_item_provider_handle_pinned_only_changed (PlankDefaultApplicationDockItemProvider* self)
{
	PlankDockPreferences* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_Prefs;
	_tmp1_ = plank_dock_preferences_get_PinnedOnly (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		plank_default_application_dock_item_provider_remove_transient_items (self);
	} else {
		plank_default_application_dock_item_provider_add_transient_items (self);
	}
}

static void
plank_default_application_dock_item_provider_add_transient_items (PlankDefaultApplicationDockItemProvider* self)
{
	GeeArrayList* transient_items = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp22_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_array_list_new (PLANK_TYPE_DOCK_ELEMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	transient_items = _tmp0_;
	{
		GeeArrayList* _app_list = NULL;
		PlankMatcher* _tmp1_;
		PlankMatcher* _tmp2_;
		GeeArrayList* _tmp3_;
		GeeArrayList* _tmp4_;
		gint _app_size = 0;
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _app_index = 0;
		_tmp1_ = plank_matcher_get_default ();
		_tmp2_ = _tmp1_;
		_tmp3_ = plank_matcher_active_launchers (_tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_app_list = _tmp4_;
		_tmp5_ = _app_list;
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_app_size = _tmp7_;
		_app_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			BamfApplication* app = NULL;
			GeeArrayList* _tmp10_;
			gpointer _tmp11_;
			PlankApplicationDockItem* found = NULL;
			BamfApplication* _tmp12_;
			PlankApplicationDockItem* _tmp13_;
			PlankApplicationDockItem* _tmp14_;
			BamfApplication* _tmp17_;
			GeeArrayList* _tmp18_;
			BamfApplication* _tmp19_;
			PlankTransientDockItem* _tmp20_;
			PlankTransientDockItem* _tmp21_;
			_app_index = _app_index + 1;
			_tmp8_ = _app_index;
			_tmp9_ = _app_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _app_list;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _app_index);
			app = (BamfApplication*) _tmp11_;
			_tmp12_ = app;
			_tmp13_ = plank_application_dock_item_provider_item_for_application ((PlankApplicationDockItemProvider*) self, _tmp12_);
			found = _tmp13_;
			_tmp14_ = found;
			if (_tmp14_ != NULL) {
				PlankApplicationDockItem* _tmp15_;
				BamfApplication* _tmp16_;
				_tmp15_ = found;
				_tmp16_ = app;
				plank_application_dock_item_set_App (_tmp15_, _tmp16_);
				_g_object_unref0 (app);
				continue;
			}
			_tmp17_ = app;
			if (!bamf_view_is_user_visible ((BamfView*) _tmp17_)) {
				_g_object_unref0 (app);
				continue;
			}
			_tmp18_ = transient_items;
			_tmp19_ = app;
			_tmp20_ = plank_transient_dock_item_new_with_application (_tmp19_);
			_tmp21_ = _tmp20_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, (PlankDockElement*) _tmp21_);
			_g_object_unref0 (_tmp21_);
			_g_object_unref0 (app);
		}
		_g_object_unref0 (_app_list);
	}
	_tmp22_ = transient_items;
	plank_dock_container_add_all ((PlankDockContainer*) self, _tmp22_);
	_g_object_unref0 (transient_items);
}

static void
plank_default_application_dock_item_provider_remove_transient_items (PlankDefaultApplicationDockItemProvider* self)
{
	GeeArrayList* transient_items = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_array_list_new (PLANK_TYPE_DOCK_ELEMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	transient_items = _tmp0_;
	{
		GeeArrayList* _element_list = NULL;
		GeeArrayList* _tmp1_;
		gint _element_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _element_index = 0;
		_tmp1_ = ((PlankDockContainer*) self)->internal_elements;
		_element_list = _tmp1_;
		_tmp2_ = _element_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_element_size = _tmp4_;
		_element_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			PlankDockElement* element = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			PlankDockElement* _tmp9_;
			_element_index = _element_index + 1;
			_tmp5_ = _element_index;
			_tmp6_ = _element_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _element_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _element_index);
			element = (PlankDockElement*) _tmp8_;
			_tmp9_ = element;
			if (PLANK_IS_TRANSIENT_DOCK_ITEM (_tmp9_)) {
				GeeArrayList* _tmp10_;
				PlankDockElement* _tmp11_;
				_tmp10_ = transient_items;
				_tmp11_ = element;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp11_);
			}
			_g_object_unref0 (element);
		}
	}
	_tmp12_ = transient_items;
	plank_dock_container_remove_all ((PlankDockContainer*) self, _tmp12_);
	_g_object_unref0 (transient_items);
}

static void
_plank_default_application_dock_item_provider_app_closed_plank_application_dock_item_app_closed (PlankApplicationDockItem* _sender,
                                                                                                 gpointer self)
{
	plank_default_application_dock_item_provider_app_closed ((PlankDefaultApplicationDockItemProvider*) self, _sender);
}

static void
_plank_default_application_dock_item_provider_pin_item_plank_application_dock_item_pin_launcher (PlankApplicationDockItem* _sender,
                                                                                                 gpointer self)
{
	plank_default_application_dock_item_provider_pin_item ((PlankDefaultApplicationDockItemProvider*) self, _sender);
}

static void
plank_default_application_dock_item_provider_real_connect_element (PlankDockContainer* base,
                                                                   PlankDockElement* element)
{
	PlankDefaultApplicationDockItemProvider * self;
	PlankApplicationDockItem* appitem = NULL;
	PlankApplicationDockItem* _tmp0_;
	self = (PlankDefaultApplicationDockItemProvider*) base;
	g_return_if_fail (element != NULL);
	PLANK_DOCK_CONTAINER_CLASS (plank_default_application_dock_item_provider_parent_class)->connect_element ((PlankDockContainer*) G_TYPE_CHECK_INSTANCE_CAST (self, PLANK_TYPE_APPLICATION_DOCK_ITEM_PROVIDER, PlankApplicationDockItemProvider), element);
	appitem = PLANK_IS_APPLICATION_DOCK_ITEM (element) ? ((PlankApplicationDockItem*) element) : NULL;
	_tmp0_ = appitem;
	if (_tmp0_ != NULL) {
		PlankApplicationDockItem* _tmp1_;
		PlankApplicationDockItem* _tmp2_;
		_tmp1_ = appitem;
		g_signal_connect_object (_tmp1_, "app-closed", (GCallback) _plank_default_application_dock_item_provider_app_closed_plank_application_dock_item_app_closed, self, 0);
		_tmp2_ = appitem;
		g_signal_connect_object (_tmp2_, "pin-launcher", (GCallback) _plank_default_application_dock_item_provider_pin_item_plank_application_dock_item_pin_launcher, self, 0);
	}
}

static void
plank_default_application_dock_item_provider_real_disconnect_element (PlankDockContainer* base,
                                                                      PlankDockElement* element)
{
	PlankDefaultApplicationDockItemProvider * self;
	PlankApplicationDockItem* appitem = NULL;
	PlankApplicationDockItem* _tmp0_;
	self = (PlankDefaultApplicationDockItemProvider*) base;
	g_return_if_fail (element != NULL);
	PLANK_DOCK_CONTAINER_CLASS (plank_default_application_dock_item_provider_parent_class)->disconnect_element ((PlankDockContainer*) G_TYPE_CHECK_INSTANCE_CAST (self, PLANK_TYPE_APPLICATION_DOCK_ITEM_PROVIDER, PlankApplicationDockItemProvider), element);
	appitem = PLANK_IS_APPLICATION_DOCK_ITEM (element) ? ((PlankApplicationDockItem*) element) : NULL;
	_tmp0_ = appitem;
	if (_tmp0_ != NULL) {
		PlankApplicationDockItem* _tmp1_;
		guint _tmp2_;
		PlankApplicationDockItem* _tmp3_;
		guint _tmp4_;
		_tmp1_ = appitem;
		g_signal_parse_name ("app-closed", PLANK_TYPE_APPLICATION_DOCK_ITEM, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _plank_default_application_dock_item_provider_app_closed_plank_application_dock_item_app_closed, self);
		_tmp3_ = appitem;
		g_signal_parse_name ("pin-launcher", PLANK_TYPE_APPLICATION_DOCK_ITEM, &_tmp4_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _plank_default_application_dock_item_provider_pin_item_plank_application_dock_item_pin_launcher, self);
	}
}

static void
plank_default_application_dock_item_provider_real_handle_item_deleted (PlankDockItemProvider* base,
                                                                       PlankDockItem* item)
{
	PlankDefaultApplicationDockItemProvider * self;
	BamfApplication* app = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	BamfApplication* _tmp4_;
	PlankTransientDockItem* new_item = NULL;
	BamfApplication* _tmp9_;
	PlankTransientDockItem* _tmp10_;
	PlankTransientDockItem* _tmp11_;
	PlankTransientDockItem* _tmp12_;
	self = (PlankDefaultApplicationDockItemProvider*) base;
	g_return_if_fail (item != NULL);
	app = NULL;
	if (PLANK_IS_APPLICATION_DOCK_ITEM (item)) {
		BamfApplication* _tmp0_;
		BamfApplication* _tmp1_;
		_tmp0_ = plank_application_dock_item_get_App (G_TYPE_CHECK_INSTANCE_CAST (item, PLANK_TYPE_APPLICATION_DOCK_ITEM, PlankApplicationDockItem));
		_tmp1_ = _tmp0_;
		app = _tmp1_;
	}
	_tmp4_ = app;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		BamfApplication* _tmp5_;
		_tmp5_ = app;
		_tmp3_ = !bamf_view_is_running ((BamfView*) _tmp5_);
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		PlankDockPreferences* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp6_ = self->priv->_Prefs;
		_tmp7_ = plank_dock_preferences_get_PinnedOnly (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_;
	}
	if (_tmp2_) {
		plank_dock_container_remove ((PlankDockContainer*) self, (PlankDockElement*) item);
		return;
	}
	_tmp9_ = app;
	_tmp10_ = plank_transient_dock_item_new_with_application (_tmp9_);
	new_item = _tmp10_;
	_tmp11_ = new_item;
	plank_dock_item_copy_values_to (item, (PlankDockItem*) _tmp11_);
	_tmp12_ = new_item;
	plank_dock_container_replace ((PlankDockContainer*) self, (PlankDockElement*) _tmp12_, (PlankDockElement*) item);
	_g_object_unref0 (new_item);
}

void
plank_default_application_dock_item_provider_pin_item (PlankDefaultApplicationDockItemProvider* self,
                                                       PlankDockItem* item)
{
	GeeArrayList* _tmp0_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	PlankApplicationDockItem* app_item = NULL;
	PlankApplicationDockItem* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = ((PlankDockContainer*) self)->internal_elements;
	if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, (PlankDockElement*) item)) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = plank_dock_element_get_Text ((PlankDockElement*) item);
		_tmp2_ = _tmp1_;
		g_critical ("DefaultApplicationDockItemProvider.vala:269: Item '%s' does not exist " \
"in this DockItemProvider.", _tmp2_);
		return;
	}
	_tmp3_ = plank_dock_element_get_Text ((PlankDockElement*) item);
	_tmp4_ = _tmp3_;
	_tmp5_ = plank_dock_item_get_DockItemFilename (item);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	plank_logger_verbose ("DefaultDockItemProvider.pin_item ('%s[%s]')", _tmp4_, _tmp7_, NULL);
	_g_free0 (_tmp7_);
	app_item = PLANK_IS_APPLICATION_DOCK_ITEM (item) ? ((PlankApplicationDockItem*) item) : NULL;
	_tmp8_ = app_item;
	if (_tmp8_ == NULL) {
		return;
	}
	plank_application_dock_item_provider_delay_items_monitor ((PlankApplicationDockItemProvider*) self);
	if (PLANK_IS_TRANSIENT_DOCK_ITEM (item)) {
		GFile* dockitem_file = NULL;
		PlankItemFactory* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		GFile* _tmp12_;
		GFile* _tmp13_;
		GFile* _tmp14_;
		GFile* _tmp15_;
		PlankApplicationDockItem* new_item = NULL;
		GFile* _tmp16_;
		PlankApplicationDockItem* _tmp17_;
		PlankApplicationDockItem* _tmp18_;
		PlankApplicationDockItem* _tmp19_;
		_tmp9_ = plank_factory_item_factory;
		_tmp10_ = plank_dock_item_get_Launcher (item);
		_tmp11_ = _tmp10_;
		_tmp12_ = plank_application_dock_item_provider_get_LaunchersDir ((PlankApplicationDockItemProvider*) self);
		_tmp13_ = _tmp12_;
		_tmp14_ = plank_item_factory_make_dock_item (_tmp9_, _tmp11_, _tmp13_);
		dockitem_file = _tmp14_;
		_tmp15_ = dockitem_file;
		if (_tmp15_ == NULL) {
			_g_object_unref0 (dockitem_file);
			return;
		}
		_tmp16_ = dockitem_file;
		_tmp17_ = plank_application_dock_item_new_with_dockitem_file (_tmp16_);
		new_item = _tmp17_;
		_tmp18_ = new_item;
		plank_dock_item_copy_values_to (item, (PlankDockItem*) _tmp18_);
		_tmp19_ = new_item;
		plank_dock_container_replace ((PlankDockContainer*) self, (PlankDockElement*) _tmp19_, (PlankDockElement*) item);
		_g_object_unref0 (new_item);
		_g_object_unref0 (dockitem_file);
	} else {
		gboolean _tmp20_ = FALSE;
		PlankApplicationDockItem* _tmp21_;
		_tmp21_ = app_item;
		if (plank_application_dock_item_is_running (_tmp21_)) {
			_tmp20_ = TRUE;
		} else {
			PlankApplicationDockItem* _tmp22_;
			_tmp22_ = app_item;
			_tmp20_ = plank_application_dock_item_has_unity_info (_tmp22_);
		}
		if (!_tmp20_) {
			plank_dock_container_remove ((PlankDockContainer*) self, (PlankDockElement*) item);
		}
		plank_dock_item_delete (item);
	}
	plank_application_dock_item_provider_resume_items_monitor ((PlankApplicationDockItemProvider*) self);
}

PlankDockPreferences*
plank_default_application_dock_item_provider_get_Prefs (PlankDefaultApplicationDockItemProvider* self)
{
	PlankDockPreferences* result;
	PlankDockPreferences* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_Prefs;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
plank_default_application_dock_item_provider_set_Prefs (PlankDefaultApplicationDockItemProvider* self,
                                                        PlankDockPreferences* value)
{
	PlankDockPreferences* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_default_application_dock_item_provider_get_Prefs (self);
	if (old_value != value) {
		PlankDockPreferences* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_Prefs);
		self->priv->_Prefs = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_default_application_dock_item_provider_properties[PLANK_DEFAULT_APPLICATION_DOCK_ITEM_PROVIDER_PREFS_PROPERTY]);
	}
}

static GObject *
plank_default_application_dock_item_provider_constructor (GType type,
                                                          guint n_construct_properties,
                                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PlankDefaultApplicationDockItemProvider * self;
	PlankDockPreferences* _tmp0_;
	PlankDockPreferences* _tmp1_;
	PlankDockPreferences* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	parent_class = G_OBJECT_CLASS (plank_default_application_dock_item_provider_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_DEFAULT_APPLICATION_DOCK_ITEM_PROVIDER, PlankDefaultApplicationDockItemProvider);
	_tmp0_ = self->priv->_Prefs;
	g_signal_connect_object ((GObject*) _tmp0_, "notify::CurrentWorkspaceOnly", (GCallback) _plank_default_application_dock_item_provider_handle_setting_changed_g_object_notify, self, 0);
	_tmp1_ = self->priv->_Prefs;
	g_signal_connect_object ((GObject*) _tmp1_, "notify::PinnedOnly", (GCallback) _plank_default_application_dock_item_provider_handle_pinned_only_changed_g_object_notify, self, 0);
	_tmp2_ = self->priv->_Prefs;
	_tmp3_ = plank_dock_preferences_get_CurrentWorkspaceOnly (_tmp2_);
	_tmp4_ = _tmp3_;
	self->priv->current_workspace_only = _tmp4_;
	if (self->priv->current_workspace_only) {
		plank_default_application_dock_item_provider_connect_wnck (self);
	}
	return obj;
}

static void
plank_default_application_dock_item_provider_class_init (PlankDefaultApplicationDockItemProviderClass * klass,
                                                         gpointer klass_data)
{
	plank_default_application_dock_item_provider_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PlankDefaultApplicationDockItemProvider_private_offset);
	((PlankDockContainerClass *) klass)->update_visible_elements = (void (*) (PlankDockContainer*)) plank_default_application_dock_item_provider_real_update_visible_elements;
	((PlankDockContainerClass *) klass)->prepare = (void (*) (PlankDockContainer*)) plank_default_application_dock_item_provider_real_prepare;
	((PlankApplicationDockItemProviderClass *) klass)->app_opened = (void (*) (PlankApplicationDockItemProvider*, BamfApplication*)) plank_default_application_dock_item_provider_real_app_opened;
	((PlankDockContainerClass *) klass)->connect_element = (void (*) (PlankDockContainer*, PlankDockElement*)) plank_default_application_dock_item_provider_real_connect_element;
	((PlankDockContainerClass *) klass)->disconnect_element = (void (*) (PlankDockContainer*, PlankDockElement*)) plank_default_application_dock_item_provider_real_disconnect_element;
	((PlankDockItemProviderClass *) klass)->handle_item_deleted = (void (*) (PlankDockItemProvider*, PlankDockItem*)) plank_default_application_dock_item_provider_real_handle_item_deleted;
	G_OBJECT_CLASS (klass)->get_property = _vala_plank_default_application_dock_item_provider_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_plank_default_application_dock_item_provider_set_property;
	G_OBJECT_CLASS (klass)->constructor = plank_default_application_dock_item_provider_constructor;
	G_OBJECT_CLASS (klass)->finalize = plank_default_application_dock_item_provider_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DEFAULT_APPLICATION_DOCK_ITEM_PROVIDER_PREFS_PROPERTY, plank_default_application_dock_item_provider_properties[PLANK_DEFAULT_APPLICATION_DOCK_ITEM_PROVIDER_PREFS_PROPERTY] = g_param_spec_object ("Prefs", "Prefs", "Prefs", PLANK_TYPE_DOCK_PREFERENCES, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
plank_default_application_dock_item_provider_instance_init (PlankDefaultApplicationDockItemProvider * self,
                                                            gpointer klass)
{
	self->priv = plank_default_application_dock_item_provider_get_instance_private (self);
}

static void
plank_default_application_dock_item_provider_finalize (GObject * obj)
{
	PlankDefaultApplicationDockItemProvider * self;
	PlankDockPreferences* _tmp0_;
	guint _tmp1_;
	GQuark _tmp2_;
	PlankDockPreferences* _tmp3_;
	guint _tmp4_;
	GQuark _tmp5_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_DEFAULT_APPLICATION_DOCK_ITEM_PROVIDER, PlankDefaultApplicationDockItemProvider);
	_tmp0_ = self->priv->_Prefs;
	g_signal_parse_name ("notify::CurrentWorkspaceOnly", G_TYPE_OBJECT, &_tmp1_, &_tmp2_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, _tmp2_, NULL, (GCallback) _plank_default_application_dock_item_provider_handle_setting_changed_g_object_notify, self);
	_tmp3_ = self->priv->_Prefs;
	g_signal_parse_name ("notify::PinnedOnly", G_TYPE_OBJECT, &_tmp4_, &_tmp5_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, _tmp5_, NULL, (GCallback) _plank_default_application_dock_item_provider_handle_pinned_only_changed_g_object_notify, self);
	if (self->priv->current_workspace_only) {
		plank_default_application_dock_item_provider_disconnect_wnck (self);
	}
	_g_object_unref0 (self->priv->_Prefs);
	G_OBJECT_CLASS (plank_default_application_dock_item_provider_parent_class)->finalize (obj);
}

/**
 * The default container and controller class for managing application dock items on a dock.
 */
static GType
plank_default_application_dock_item_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankDefaultApplicationDockItemProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_default_application_dock_item_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankDefaultApplicationDockItemProvider), 0, (GInstanceInitFunc) plank_default_application_dock_item_provider_instance_init, NULL };
	GType plank_default_application_dock_item_provider_type_id;
	plank_default_application_dock_item_provider_type_id = g_type_register_static (PLANK_TYPE_APPLICATION_DOCK_ITEM_PROVIDER, "PlankDefaultApplicationDockItemProvider", &g_define_type_info, 0);
	PlankDefaultApplicationDockItemProvider_private_offset = g_type_add_instance_private (plank_default_application_dock_item_provider_type_id, sizeof (PlankDefaultApplicationDockItemProviderPrivate));
	return plank_default_application_dock_item_provider_type_id;
}

GType
plank_default_application_dock_item_provider_get_type (void)
{
	static volatile gsize plank_default_application_dock_item_provider_type_id__once = 0;
	if (g_once_init_enter (&plank_default_application_dock_item_provider_type_id__once)) {
		GType plank_default_application_dock_item_provider_type_id;
		plank_default_application_dock_item_provider_type_id = plank_default_application_dock_item_provider_get_type_once ();
		g_once_init_leave (&plank_default_application_dock_item_provider_type_id__once, plank_default_application_dock_item_provider_type_id);
	}
	return plank_default_application_dock_item_provider_type_id__once;
}

static void
_vala_plank_default_application_dock_item_provider_get_property (GObject * object,
                                                                 guint property_id,
                                                                 GValue * value,
                                                                 GParamSpec * pspec)
{
	PlankDefaultApplicationDockItemProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_DEFAULT_APPLICATION_DOCK_ITEM_PROVIDER, PlankDefaultApplicationDockItemProvider);
	switch (property_id) {
		case PLANK_DEFAULT_APPLICATION_DOCK_ITEM_PROVIDER_PREFS_PROPERTY:
		g_value_set_object (value, plank_default_application_dock_item_provider_get_Prefs (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_plank_default_application_dock_item_provider_set_property (GObject * object,
                                                                 guint property_id,
                                                                 const GValue * value,
                                                                 GParamSpec * pspec)
{
	PlankDefaultApplicationDockItemProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_DEFAULT_APPLICATION_DOCK_ITEM_PROVIDER, PlankDefaultApplicationDockItemProvider);
	switch (property_id) {
		case PLANK_DEFAULT_APPLICATION_DOCK_ITEM_PROVIDER_PREFS_PROPERTY:
		plank_default_application_dock_item_provider_set_Prefs (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

