/* PoofWindow.c generated by valac 0.56.17, the Vala compiler
 * generated from PoofWindow.vala, do not modify */

/**/
/*  Copyright (C) 2011-2012 Robert Dyer, Rico Tzschichholz*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "plank.h"
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <cairo-gobject.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>

#define PLANK_POOF_WINDOW_RUN_LENGTH (300 * 1000)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PLANK_POOF_WINDOW_0_PROPERTY,
	PLANK_POOF_WINDOW_NUM_PROPERTIES
};
static GParamSpec* plank_poof_window_properties[PLANK_POOF_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _PlankPoofWindowPrivate {
	GdkPixbuf* poof_image;
	gint poof_size;
	gint poof_frames;
	gint64 start_time;
	gint64 frame_time;
	guint animation_timer_id;
};

static gint PlankPoofWindow_private_offset;
static gpointer plank_poof_window_parent_class = NULL;
static PlankPoofWindow* plank_poof_window_instance;
static PlankPoofWindow* plank_poof_window_instance = NULL;

static gboolean __lambda59_ (PlankPoofWindow* self);
static gboolean ___lambda59__gsource_func (gpointer self);
static gboolean plank_poof_window_real_draw (GtkWidget* base,
                                      cairo_t* cr);
static GObject * plank_poof_window_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static void plank_poof_window_finalize (GObject * obj);
static GType plank_poof_window_get_type_once (void);

static inline gpointer
plank_poof_window_get_instance_private (PlankPoofWindow* self)
{
	return G_STRUCT_MEMBER_P (self, PlankPoofWindow_private_offset);
}

PlankPoofWindow*
plank_poof_window_get_default (void)
{
	PlankPoofWindow* _tmp0_;
	PlankPoofWindow* _tmp2_;
	PlankPoofWindow* result;
	_tmp0_ = plank_poof_window_instance;
	if (_tmp0_ == NULL) {
		PlankPoofWindow* _tmp1_;
		_tmp1_ = plank_poof_window_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (plank_poof_window_instance);
		plank_poof_window_instance = _tmp1_;
	}
	_tmp2_ = plank_poof_window_instance;
	result = _tmp2_;
	return result;
}

/**
 * Creates a new poof window at the screen-relative coordinates specified.
 */
PlankPoofWindow*
plank_poof_window_construct (GType object_type)
{
	PlankPoofWindow * self = NULL;
	self = (PlankPoofWindow*) g_object_new (object_type, "type", GTK_WINDOW_TOPLEVEL, "type-hint", GDK_WINDOW_TYPE_HINT_DOCK, NULL);
	return self;
}

PlankPoofWindow*
plank_poof_window_new (void)
{
	return plank_poof_window_construct (PLANK_TYPE_POOF_WINDOW);
}

/**
 * Show the animated poof-window at the given coordinates
 *
 * @param x the x position of the poof window
 * @param y the y position of the poof window
 */
static gboolean
__lambda59_ (PlankPoofWindow* self)
{
	gboolean result;
	self->priv->frame_time = g_get_monotonic_time ();
	if ((self->priv->frame_time - self->priv->start_time) <= ((gint64) PLANK_POOF_WINDOW_RUN_LENGTH)) {
		gtk_widget_queue_draw ((GtkWidget*) self);
		result = TRUE;
		return result;
	}
	self->priv->animation_timer_id = 0U;
	gtk_widget_hide ((GtkWidget*) self);
	result = FALSE;
	return result;
}

static gboolean
___lambda59__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda59_ ((PlankPoofWindow*) self);
	return result;
}

void
plank_poof_window_show_at (PlankPoofWindow* self,
                           gint x,
                           gint y)
{
	gboolean _tmp0_ = FALSE;
	GdkPixbuf* _tmp1_;
	g_return_if_fail (self != NULL);
	if (self->priv->animation_timer_id > 0U) {
		g_source_remove (self->priv->animation_timer_id);
	}
	_tmp1_ = self->priv->poof_image;
	if (_tmp1_ == NULL) {
		_tmp0_ = self->priv->poof_frames > 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	plank_logger_verbose ("Show animation: size = %ipx, frame-count = %i, duration = %ims", self->priv->poof_size, self->priv->poof_frames, PLANK_POOF_WINDOW_RUN_LENGTH / 1000, NULL);
	self->priv->start_time = g_get_monotonic_time ();
	self->priv->frame_time = self->priv->start_time;
	gtk_widget_show ((GtkWidget*) self);
	gtk_window_move ((GtkWindow*) self, x - (self->priv->poof_size / 2), y - (self->priv->poof_size / 2));
	self->priv->animation_timer_id = gdk_threads_add_timeout ((guint) 30, ___lambda59__gsource_func, self);
}

static gboolean
plank_poof_window_real_draw (GtkWidget* base,
                             cairo_t* cr)
{
	PlankPoofWindow * self;
	GdkPixbuf* _tmp0_;
	gboolean result;
	self = (PlankPoofWindow*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	cairo_set_operator (cr, CAIRO_OPERATOR_SOURCE);
	_tmp0_ = self->priv->poof_image;
	gdk_cairo_set_source_pixbuf (cr, _tmp0_, (gdouble) 0, (gdouble) ((-self->priv->poof_size) * ((gint) ((self->priv->poof_frames * (self->priv->frame_time - self->priv->start_time)) / ((gdouble) PLANK_POOF_WINDOW_RUN_LENGTH)))));
	cairo_paint (cr);
	result = GDK_EVENT_STOP;
	return result;
}

static GObject *
plank_poof_window_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PlankPoofWindow * self;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (plank_poof_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_POOF_WINDOW, PlankPoofWindow);
	gtk_window_set_accept_focus ((GtkWindow*) self, FALSE);
	gtk_widget_set_can_focus ((GtkWidget*) self, FALSE);
	gtk_window_set_keep_above ((GtkWindow*) self, TRUE);
	{
		GdkPixbuf* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		GdkPixbuf* _tmp3_;
		GdkPixbuf* _tmp4_;
		GdkPixbuf* _tmp5_;
		GdkPixbuf* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		GdkPixbuf* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		_tmp1_ = g_strdup_printf ("%s/img/poof.svg", PLANK_G_RESOURCE_PATH);
		_tmp2_ = _tmp1_;
		_tmp3_ = gdk_pixbuf_new_from_resource (_tmp2_, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->poof_image);
		self->priv->poof_image = _tmp5_;
		_tmp6_ = self->priv->poof_image;
		_tmp7_ = gdk_pixbuf_get_width (_tmp6_);
		_tmp8_ = _tmp7_;
		self->priv->poof_size = _tmp8_;
		_tmp9_ = self->priv->poof_image;
		_tmp10_ = gdk_pixbuf_get_height (_tmp9_);
		_tmp11_ = _tmp10_;
		self->priv->poof_frames = (gint) floor ((gdouble) (_tmp11_ / self->priv->poof_size));
		g_debug ("PoofWindow.vala:67: Loaded animation: size = %ipx, frame-count = %i, d" \
"uration = %ims", self->priv->poof_size, self->priv->poof_frames, PLANK_POOF_WINDOW_RUN_LENGTH / 1000);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_g_object_unref0 (self->priv->poof_image);
		self->priv->poof_image = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_critical ("PoofWindow.vala:70: Unable to load poof animation image: %s", _tmp13_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	gtk_widget_set_size_request ((GtkWidget*) self, self->priv->poof_size, self->priv->poof_size);
	return obj;
}

static void
plank_poof_window_class_init (PlankPoofWindowClass * klass,
                              gpointer klass_data)
{
	plank_poof_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PlankPoofWindow_private_offset);
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) plank_poof_window_real_draw;
	G_OBJECT_CLASS (klass)->constructor = plank_poof_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = plank_poof_window_finalize;
}

static void
plank_poof_window_instance_init (PlankPoofWindow * self,
                                 gpointer klass)
{
	self->priv = plank_poof_window_get_instance_private (self);
	self->priv->start_time = 0LL;
	self->priv->frame_time = 0LL;
	self->priv->animation_timer_id = 0U;
}

static void
plank_poof_window_finalize (GObject * obj)
{
	PlankPoofWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_POOF_WINDOW, PlankPoofWindow);
	if (self->priv->animation_timer_id > 0U) {
		g_source_remove (self->priv->animation_timer_id);
		self->priv->animation_timer_id = 0U;
	}
	_g_object_unref0 (self->priv->poof_image);
	G_OBJECT_CLASS (plank_poof_window_parent_class)->finalize (obj);
}

/**
 * An animated window that draws a 'poof' animation.
 * Used when dragging items off the dock.
 */
static GType
plank_poof_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankPoofWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_poof_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankPoofWindow), 0, (GInstanceInitFunc) plank_poof_window_instance_init, NULL };
	GType plank_poof_window_type_id;
	plank_poof_window_type_id = g_type_register_static (PLANK_TYPE_COMPOSITED_WINDOW, "PlankPoofWindow", &g_define_type_info, 0);
	PlankPoofWindow_private_offset = g_type_add_instance_private (plank_poof_window_type_id, sizeof (PlankPoofWindowPrivate));
	return plank_poof_window_type_id;
}

GType
plank_poof_window_get_type (void)
{
	static volatile gsize plank_poof_window_type_id__once = 0;
	if (g_once_init_enter (&plank_poof_window_type_id__once)) {
		GType plank_poof_window_type_id;
		plank_poof_window_type_id = plank_poof_window_get_type_once ();
		g_once_init_leave (&plank_poof_window_type_id__once, plank_poof_window_type_id);
	}
	return plank_poof_window_type_id__once;
}

