/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.14.0
 *
 * Copyright (c) 2025 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtBluetooth.h"

#line 28 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtBluetooth/qbluetoothuuid.sip"
#include <qbluetoothuuid.h>
#line 29 "/build/pyqt6/src/pyqt6-6.10.1/build/QtBluetooth/sipQtBluetoothQBluetoothUuid.cpp"

#line 26 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtBluetooth/qpybluetooth_quint128.sip"
#include <qbluetoothuuid.h>
#line 33 "/build/pyqt6/src/pyqt6-6.10.1/build/QtBluetooth/sipQtBluetoothQBluetoothUuid.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qsysinfo.sip"
#include <qsysinfo.h>
#line 36 "/build/pyqt6/src/pyqt6-6.10.1/build/QtBluetooth/sipQtBluetoothQBluetoothUuid.cpp"
#line 24 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qstring.sip"
#include <qstring.h>
#line 39 "/build/pyqt6/src/pyqt6-6.10.1/build/QtBluetooth/sipQtBluetoothQBluetoothUuid.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/quuid.sip"
#include <quuid.h>
#line 42 "/build/pyqt6/src/pyqt6-6.10.1/build/QtBluetooth/sipQtBluetoothQBluetoothUuid.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qanystringview.sip"
#include <qanystringview.h>
#line 45 "/build/pyqt6/src/pyqt6-6.10.1/build/QtBluetooth/sipQtBluetoothQBluetoothUuid.cpp"
#line 24 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qbytearrayview.sip"
#include <qbytearrayview.h>
#line 48 "/build/pyqt6/src/pyqt6-6.10.1/build/QtBluetooth/sipQtBluetoothQBluetoothUuid.cpp"
#line 30 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qbytearray.sip"
#include <qbytearray.h>
#line 51 "/build/pyqt6/src/pyqt6-6.10.1/build/QtBluetooth/sipQtBluetoothQBluetoothUuid.cpp"


PyDoc_STRVAR(doc_QBluetoothUuid_minimumSize, "minimumSize(self) -> int");

extern "C" {static PyObject *meth_QBluetoothUuid_minimumSize(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothUuid_minimumSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothUuid *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QBluetoothUuid, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->minimumSize();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothUuid, sipName_minimumSize, doc_QBluetoothUuid_minimumSize);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothUuid_toUInt16, "toUInt16(self) -> (int, Optional[bool])");

extern "C" {static PyObject *meth_QBluetoothUuid_toUInt16(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QBluetoothUuid_toUInt16(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        const ::QBluetoothUuid *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "B", &sipSelf, sipType_QBluetoothUuid, &sipCpp))
        {
            ::quint16 sipRes;

            sipRes = sipCpp->toUInt16(&a0);

            return sipBuildResult(0, "(tb)", sipRes, a0);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothUuid, sipName_toUInt16, doc_QBluetoothUuid_toUInt16);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothUuid_toUInt32, "toUInt32(self) -> (int, Optional[bool])");

extern "C" {static PyObject *meth_QBluetoothUuid_toUInt32(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QBluetoothUuid_toUInt32(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        const ::QBluetoothUuid *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "B", &sipSelf, sipType_QBluetoothUuid, &sipCpp))
        {
            ::quint32 sipRes;

            sipRes = sipCpp->toUInt32(&a0);

            return sipBuildResult(0, "(ub)", sipRes, a0);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothUuid, sipName_toUInt32, doc_QBluetoothUuid_toUInt32);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothUuid_toUInt128, "toUInt128(self) -> tuple[int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int]");

extern "C" {static PyObject *meth_QBluetoothUuid_toUInt128(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothUuid_toUInt128(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothUuid *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QBluetoothUuid, &sipCpp))
        {
            ::quint128*sipRes;

            sipRes = new ::quint128(sipCpp->toUInt128());

            return sipConvertFromNewType(sipRes, sipType_quint128, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothUuid, sipName_toUInt128, doc_QBluetoothUuid_toUInt128);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothUuid_serviceClassToString, "serviceClassToString(uuid: QBluetoothUuid.ServiceClassUuid) -> str");

extern "C" {static PyObject *meth_QBluetoothUuid_serviceClassToString(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothUuid_serviceClassToString(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QBluetoothUuid::ServiceClassUuid a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "CE", &sipSelf, sipType_QBluetoothUuid_ServiceClassUuid, &a0))
        {
            ::QString*sipRes;

            sipRes = new ::QString(::QBluetoothUuid::serviceClassToString(a0));

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothUuid, sipName_serviceClassToString, doc_QBluetoothUuid_serviceClassToString);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothUuid_protocolToString, "protocolToString(uuid: QBluetoothUuid.ProtocolUuid) -> str");

extern "C" {static PyObject *meth_QBluetoothUuid_protocolToString(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothUuid_protocolToString(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QBluetoothUuid::ProtocolUuid a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "CE", &sipSelf, sipType_QBluetoothUuid_ProtocolUuid, &a0))
        {
            ::QString*sipRes;

            sipRes = new ::QString(::QBluetoothUuid::protocolToString(a0));

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothUuid, sipName_protocolToString, doc_QBluetoothUuid_protocolToString);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothUuid_characteristicToString, "characteristicToString(uuid: QBluetoothUuid.CharacteristicType) -> str");

extern "C" {static PyObject *meth_QBluetoothUuid_characteristicToString(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothUuid_characteristicToString(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QBluetoothUuid::CharacteristicType a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "CE", &sipSelf, sipType_QBluetoothUuid_CharacteristicType, &a0))
        {
            ::QString*sipRes;

            sipRes = new ::QString(::QBluetoothUuid::characteristicToString(a0));

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothUuid, sipName_characteristicToString, doc_QBluetoothUuid_characteristicToString);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothUuid_descriptorToString, "descriptorToString(uuid: QBluetoothUuid.DescriptorType) -> str");

extern "C" {static PyObject *meth_QBluetoothUuid_descriptorToString(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothUuid_descriptorToString(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QBluetoothUuid::DescriptorType a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "CE", &sipSelf, sipType_QBluetoothUuid_DescriptorType, &a0))
        {
            ::QString*sipRes;

            sipRes = new ::QString(::QBluetoothUuid::descriptorToString(a0));

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothUuid, sipName_descriptorToString, doc_QBluetoothUuid_descriptorToString);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QBluetoothUuid___eq__(PyObject *, PyObject *);}
static PyObject *slot_QBluetoothUuid___eq__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QBluetoothUuid *sipCpp = reinterpret_cast< ::QBluetoothUuid *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QBluetoothUuid));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothUuid* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QBluetoothUuid, &a0))
        {
            bool sipRes;

            sipRes = operator==((*sipCpp), *a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtBluetooth, eq_slot, sipType_QBluetoothUuid, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QBluetoothUuid___ne__(PyObject *, PyObject *);}
static PyObject *slot_QBluetoothUuid___ne__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QBluetoothUuid *sipCpp = reinterpret_cast< ::QBluetoothUuid *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QBluetoothUuid));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothUuid* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QBluetoothUuid, &a0))
        {
            bool sipRes;

            sipRes = operator!=((*sipCpp), *a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtBluetooth, ne_slot, sipType_QBluetoothUuid, sipSelf, sipArg);
}


extern "C" {static Py_hash_t slot_QBluetoothUuid___hash__(PyObject *);}
static Py_hash_t slot_QBluetoothUuid___hash__(PyObject *sipSelf)
{
    ::QBluetoothUuid *sipCpp = reinterpret_cast< ::QBluetoothUuid *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QBluetoothUuid));

    if (!sipCpp)
        return 0;


    {
        {
            Py_hash_t sipRes = 0;

#line 343 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtBluetooth/qbluetoothuuid.sip"
        sipRes = qHash(*sipCpp);
#line 337 "/build/pyqt6/src/pyqt6-6.10.1/build/QtBluetooth/sipQtBluetoothQBluetoothUuid.cpp"

            return sipRes;
        }
    }

    return 0;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_QBluetoothUuid(void *, const sipTypeDef *);}
static void *cast_QBluetoothUuid(void *sipCppV, const sipTypeDef *targetType)
{
    ::QBluetoothUuid *sipCpp = reinterpret_cast< ::QBluetoothUuid *>(sipCppV);

    if (targetType == sipType_QBluetoothUuid)
        return sipCppV;

    if (targetType == sipType_QUuid)
        return static_cast< ::QUuid *>(sipCpp);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QBluetoothUuid(void *, int);}
static void release_QBluetoothUuid(void *sipCppV, int)
{
    delete reinterpret_cast< ::QBluetoothUuid *>(sipCppV);
}


extern "C" {static void *array_QBluetoothUuid(Py_ssize_t);}
static void *array_QBluetoothUuid(Py_ssize_t sipNrElem)
{
    return new ::QBluetoothUuid[sipNrElem];
}


extern "C" {static void array_delete_QBluetoothUuid(void *);}
static void array_delete_QBluetoothUuid(void *sipCpp)
{
    delete[] reinterpret_cast< ::QBluetoothUuid *>(sipCpp);
}


extern "C" {static void assign_QBluetoothUuid(void *, Py_ssize_t, void *);}
static void assign_QBluetoothUuid(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QBluetoothUuid *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QBluetoothUuid *>(sipSrc);
}


extern "C" {static void *copy_QBluetoothUuid(const void *, Py_ssize_t);}
static void *copy_QBluetoothUuid(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QBluetoothUuid(reinterpret_cast<const ::QBluetoothUuid *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QBluetoothUuid(sipSimpleWrapper *);}
static void dealloc_QBluetoothUuid(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QBluetoothUuid(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QBluetoothUuid(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QBluetoothUuid(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QBluetoothUuid *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new ::QBluetoothUuid();

            return sipCpp;
        }
    }

    {
        ::QBluetoothUuid::ProtocolUuid a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "E", sipType_QBluetoothUuid_ProtocolUuid, &a0))
        {
            sipCpp = new ::QBluetoothUuid(a0);

            return sipCpp;
        }
    }

    {
        ::QBluetoothUuid::ServiceClassUuid a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "E", sipType_QBluetoothUuid_ServiceClassUuid, &a0))
        {
            sipCpp = new ::QBluetoothUuid(a0);

            return sipCpp;
        }
    }

    {
        ::QBluetoothUuid::CharacteristicType a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "E", sipType_QBluetoothUuid_CharacteristicType, &a0))
        {
            sipCpp = new ::QBluetoothUuid(a0);

            return sipCpp;
        }
    }

    {
        ::QBluetoothUuid::DescriptorType a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "E", sipType_QBluetoothUuid_DescriptorType, &a0))
        {
            sipCpp = new ::QBluetoothUuid(a0);

            return sipCpp;
        }
    }

    {
        ::quint32 a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "u", &a0))
        {
            sipCpp = new ::QBluetoothUuid(a0);

            return sipCpp;
        }
    }

    {
        ::quint128* a0;
        int a0State = 0;
        ::QSysInfo::Endian a1 = QSysInfo::BigEndian;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_order,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1|E", sipType_quint128, &a0, &a0State, sipType_QSysInfo_Endian, &a1))
        {
            sipCpp = new ::QBluetoothUuid(*a0, a1);
            sipReleaseType(a0, sipType_quint128, a0State);

            return sipCpp;
        }
    }

    {
        const ::QString* a0;
        int a0State = 0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J1", sipType_QString, &a0, &a0State))
        {
            sipCpp = new ::QBluetoothUuid(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return sipCpp;
        }
    }

    {
        const ::QBluetoothUuid* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QBluetoothUuid, &a0))
        {
            sipCpp = new ::QBluetoothUuid(*a0);

            return sipCpp;
        }
    }

    {
        const ::QUuid* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QUuid, &a0))
        {
            sipCpp = new ::QBluetoothUuid(*a0);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_QBluetoothUuid[] = {{13, 0, 1}};


/* Define this type's Python slots. */
static sipPySlotDef slots_QBluetoothUuid[] = {
    {(void *)slot_QBluetoothUuid___eq__, eq_slot},
    {(void *)slot_QBluetoothUuid___ne__, ne_slot},
    {(void *)slot_QBluetoothUuid___hash__, hash_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QBluetoothUuid[] = {
    {sipName_characteristicToString, meth_QBluetoothUuid_characteristicToString, METH_VARARGS, doc_QBluetoothUuid_characteristicToString},
    {sipName_descriptorToString, meth_QBluetoothUuid_descriptorToString, METH_VARARGS, doc_QBluetoothUuid_descriptorToString},
    {sipName_minimumSize, meth_QBluetoothUuid_minimumSize, METH_VARARGS, doc_QBluetoothUuid_minimumSize},
    {sipName_protocolToString, meth_QBluetoothUuid_protocolToString, METH_VARARGS, doc_QBluetoothUuid_protocolToString},
    {sipName_serviceClassToString, meth_QBluetoothUuid_serviceClassToString, METH_VARARGS, doc_QBluetoothUuid_serviceClassToString},
    {sipName_toUInt128, meth_QBluetoothUuid_toUInt128, METH_VARARGS, doc_QBluetoothUuid_toUInt128},
    {sipName_toUInt16, SIP_MLMETH_CAST(meth_QBluetoothUuid_toUInt16), METH_VARARGS|METH_KEYWORDS, doc_QBluetoothUuid_toUInt16},
    {sipName_toUInt32, SIP_MLMETH_CAST(meth_QBluetoothUuid_toUInt32), METH_VARARGS|METH_KEYWORDS, doc_QBluetoothUuid_toUInt32}
};


/* Define the enum members and ints to be added to this type. */
static sipIntInstanceDef intInstances_QBluetoothUuid[] = {
    {sipName_DeviceName, static_cast<int>(::QBluetoothUuid::CharacteristicType::DeviceName)},
    {sipName_Appearance, static_cast<int>(::QBluetoothUuid::CharacteristicType::Appearance)},
    {sipName_PeripheralPrivacyFlag, static_cast<int>(::QBluetoothUuid::CharacteristicType::PeripheralPrivacyFlag)},
    {sipName_ReconnectionAddress, static_cast<int>(::QBluetoothUuid::CharacteristicType::ReconnectionAddress)},
    {sipName_PeripheralPreferredConnectionParameters, static_cast<int>(::QBluetoothUuid::CharacteristicType::PeripheralPreferredConnectionParameters)},
    {sipName_ServiceChanged, static_cast<int>(::QBluetoothUuid::CharacteristicType::ServiceChanged)},
    {sipName_AlertLevel, static_cast<int>(::QBluetoothUuid::CharacteristicType::AlertLevel)},
    {sipName_TxPowerLevel, static_cast<int>(::QBluetoothUuid::CharacteristicType::TxPowerLevel)},
    {sipName_DateTime, static_cast<int>(::QBluetoothUuid::CharacteristicType::DateTime)},
    {sipName_DayOfWeek, static_cast<int>(::QBluetoothUuid::CharacteristicType::DayOfWeek)},
    {sipName_DayDateTime, static_cast<int>(::QBluetoothUuid::CharacteristicType::DayDateTime)},
    {sipName_ExactTime256, static_cast<int>(::QBluetoothUuid::CharacteristicType::ExactTime256)},
    {sipName_DSTOffset, static_cast<int>(::QBluetoothUuid::CharacteristicType::DSTOffset)},
    {sipName_TimeZone, static_cast<int>(::QBluetoothUuid::CharacteristicType::TimeZone)},
    {sipName_LocalTimeInformation, static_cast<int>(::QBluetoothUuid::CharacteristicType::LocalTimeInformation)},
    {sipName_TimeWithDST, static_cast<int>(::QBluetoothUuid::CharacteristicType::TimeWithDST)},
    {sipName_TimeAccuracy, static_cast<int>(::QBluetoothUuid::CharacteristicType::TimeAccuracy)},
    {sipName_TimeSource, static_cast<int>(::QBluetoothUuid::CharacteristicType::TimeSource)},
    {sipName_ReferenceTimeInformation, static_cast<int>(::QBluetoothUuid::CharacteristicType::ReferenceTimeInformation)},
    {sipName_TimeUpdateControlPoint, static_cast<int>(::QBluetoothUuid::CharacteristicType::TimeUpdateControlPoint)},
    {sipName_TimeUpdateState, static_cast<int>(::QBluetoothUuid::CharacteristicType::TimeUpdateState)},
    {sipName_GlucoseMeasurement, static_cast<int>(::QBluetoothUuid::CharacteristicType::GlucoseMeasurement)},
    {sipName_BatteryLevel, static_cast<int>(::QBluetoothUuid::CharacteristicType::BatteryLevel)},
    {sipName_TemperatureMeasurement, static_cast<int>(::QBluetoothUuid::CharacteristicType::TemperatureMeasurement)},
    {sipName_TemperatureType, static_cast<int>(::QBluetoothUuid::CharacteristicType::TemperatureType)},
    {sipName_IntermediateTemperature, static_cast<int>(::QBluetoothUuid::CharacteristicType::IntermediateTemperature)},
    {sipName_MeasurementInterval, static_cast<int>(::QBluetoothUuid::CharacteristicType::MeasurementInterval)},
    {sipName_BootKeyboardInputReport, static_cast<int>(::QBluetoothUuid::CharacteristicType::BootKeyboardInputReport)},
    {sipName_SystemID, static_cast<int>(::QBluetoothUuid::CharacteristicType::SystemID)},
    {sipName_ModelNumberString, static_cast<int>(::QBluetoothUuid::CharacteristicType::ModelNumberString)},
    {sipName_SerialNumberString, static_cast<int>(::QBluetoothUuid::CharacteristicType::SerialNumberString)},
    {sipName_FirmwareRevisionString, static_cast<int>(::QBluetoothUuid::CharacteristicType::FirmwareRevisionString)},
    {sipName_HardwareRevisionString, static_cast<int>(::QBluetoothUuid::CharacteristicType::HardwareRevisionString)},
    {sipName_SoftwareRevisionString, static_cast<int>(::QBluetoothUuid::CharacteristicType::SoftwareRevisionString)},
    {sipName_ManufacturerNameString, static_cast<int>(::QBluetoothUuid::CharacteristicType::ManufacturerNameString)},
    {sipName_IEEE1107320601RegulatoryCertificationDataList, static_cast<int>(::QBluetoothUuid::CharacteristicType::IEEE1107320601RegulatoryCertificationDataList)},
    {sipName_CurrentTime, static_cast<int>(::QBluetoothUuid::CharacteristicType::CurrentTime)},
    {sipName_MagneticDeclination, static_cast<int>(::QBluetoothUuid::CharacteristicType::MagneticDeclination)},
    {sipName_ScanRefresh, static_cast<int>(::QBluetoothUuid::CharacteristicType::ScanRefresh)},
    {sipName_BootKeyboardOutputReport, static_cast<int>(::QBluetoothUuid::CharacteristicType::BootKeyboardOutputReport)},
    {sipName_BootMouseInputReport, static_cast<int>(::QBluetoothUuid::CharacteristicType::BootMouseInputReport)},
    {sipName_GlucoseMeasurementContext, static_cast<int>(::QBluetoothUuid::CharacteristicType::GlucoseMeasurementContext)},
    {sipName_BloodPressureMeasurement, static_cast<int>(::QBluetoothUuid::CharacteristicType::BloodPressureMeasurement)},
    {sipName_IntermediateCuffPressure, static_cast<int>(::QBluetoothUuid::CharacteristicType::IntermediateCuffPressure)},
    {sipName_HeartRateMeasurement, static_cast<int>(::QBluetoothUuid::CharacteristicType::HeartRateMeasurement)},
    {sipName_BodySensorLocation, static_cast<int>(::QBluetoothUuid::CharacteristicType::BodySensorLocation)},
    {sipName_HeartRateControlPoint, static_cast<int>(::QBluetoothUuid::CharacteristicType::HeartRateControlPoint)},
    {sipName_AlertStatus, static_cast<int>(::QBluetoothUuid::CharacteristicType::AlertStatus)},
    {sipName_RingerControlPoint, static_cast<int>(::QBluetoothUuid::CharacteristicType::RingerControlPoint)},
    {sipName_RingerSetting, static_cast<int>(::QBluetoothUuid::CharacteristicType::RingerSetting)},
    {sipName_AlertCategoryIDBitMask, static_cast<int>(::QBluetoothUuid::CharacteristicType::AlertCategoryIDBitMask)},
    {sipName_AlertCategoryID, static_cast<int>(::QBluetoothUuid::CharacteristicType::AlertCategoryID)},
    {sipName_AlertNotificationControlPoint, static_cast<int>(::QBluetoothUuid::CharacteristicType::AlertNotificationControlPoint)},
    {sipName_UnreadAlertStatus, static_cast<int>(::QBluetoothUuid::CharacteristicType::UnreadAlertStatus)},
    {sipName_NewAlert, static_cast<int>(::QBluetoothUuid::CharacteristicType::NewAlert)},
    {sipName_SupportedNewAlertCategory, static_cast<int>(::QBluetoothUuid::CharacteristicType::SupportedNewAlertCategory)},
    {sipName_SupportedUnreadAlertCategory, static_cast<int>(::QBluetoothUuid::CharacteristicType::SupportedUnreadAlertCategory)},
    {sipName_BloodPressureFeature, static_cast<int>(::QBluetoothUuid::CharacteristicType::BloodPressureFeature)},
    {sipName_HIDInformation, static_cast<int>(::QBluetoothUuid::CharacteristicType::HIDInformation)},
    {sipName_ReportMap, static_cast<int>(::QBluetoothUuid::CharacteristicType::ReportMap)},
    {sipName_HIDControlPoint, static_cast<int>(::QBluetoothUuid::CharacteristicType::HIDControlPoint)},
    {sipName_Report, static_cast<int>(::QBluetoothUuid::CharacteristicType::Report)},
    {sipName_ProtocolMode, static_cast<int>(::QBluetoothUuid::CharacteristicType::ProtocolMode)},
    {sipName_ScanIntervalWindow, static_cast<int>(::QBluetoothUuid::CharacteristicType::ScanIntervalWindow)},
    {sipName_PnPID, static_cast<int>(::QBluetoothUuid::CharacteristicType::PnPID)},
    {sipName_GlucoseFeature, static_cast<int>(::QBluetoothUuid::CharacteristicType::GlucoseFeature)},
    {sipName_RecordAccessControlPoint, static_cast<int>(::QBluetoothUuid::CharacteristicType::RecordAccessControlPoint)},
    {sipName_RSCMeasurement, static_cast<int>(::QBluetoothUuid::CharacteristicType::RSCMeasurement)},
    {sipName_RSCFeature, static_cast<int>(::QBluetoothUuid::CharacteristicType::RSCFeature)},
    {sipName_SCControlPoint, static_cast<int>(::QBluetoothUuid::CharacteristicType::SCControlPoint)},
    {sipName_CSCMeasurement, static_cast<int>(::QBluetoothUuid::CharacteristicType::CSCMeasurement)},
    {sipName_CSCFeature, static_cast<int>(::QBluetoothUuid::CharacteristicType::CSCFeature)},
    {sipName_SensorLocation, static_cast<int>(::QBluetoothUuid::CharacteristicType::SensorLocation)},
    {sipName_CyclingPowerMeasurement, static_cast<int>(::QBluetoothUuid::CharacteristicType::CyclingPowerMeasurement)},
    {sipName_CyclingPowerVector, static_cast<int>(::QBluetoothUuid::CharacteristicType::CyclingPowerVector)},
    {sipName_CyclingPowerFeature, static_cast<int>(::QBluetoothUuid::CharacteristicType::CyclingPowerFeature)},
    {sipName_CyclingPowerControlPoint, static_cast<int>(::QBluetoothUuid::CharacteristicType::CyclingPowerControlPoint)},
    {sipName_LocationAndSpeed, static_cast<int>(::QBluetoothUuid::CharacteristicType::LocationAndSpeed)},
    {sipName_Navigation, static_cast<int>(::QBluetoothUuid::CharacteristicType::Navigation)},
    {sipName_PositionQuality, static_cast<int>(::QBluetoothUuid::CharacteristicType::PositionQuality)},
    {sipName_LNFeature, static_cast<int>(::QBluetoothUuid::CharacteristicType::LNFeature)},
    {sipName_LNControlPoint, static_cast<int>(::QBluetoothUuid::CharacteristicType::LNControlPoint)},
    {sipName_Elevation, static_cast<int>(::QBluetoothUuid::CharacteristicType::Elevation)},
    {sipName_Pressure, static_cast<int>(::QBluetoothUuid::CharacteristicType::Pressure)},
    {sipName_Temperature, static_cast<int>(::QBluetoothUuid::CharacteristicType::Temperature)},
    {sipName_Humidity, static_cast<int>(::QBluetoothUuid::CharacteristicType::Humidity)},
    {sipName_TrueWindSpeed, static_cast<int>(::QBluetoothUuid::CharacteristicType::TrueWindSpeed)},
    {sipName_TrueWindDirection, static_cast<int>(::QBluetoothUuid::CharacteristicType::TrueWindDirection)},
    {sipName_ApparentWindSpeed, static_cast<int>(::QBluetoothUuid::CharacteristicType::ApparentWindSpeed)},
    {sipName_ApparentWindDirection, static_cast<int>(::QBluetoothUuid::CharacteristicType::ApparentWindDirection)},
    {sipName_GustFactor, static_cast<int>(::QBluetoothUuid::CharacteristicType::GustFactor)},
    {sipName_PollenConcentration, static_cast<int>(::QBluetoothUuid::CharacteristicType::PollenConcentration)},
    {sipName_UVIndex, static_cast<int>(::QBluetoothUuid::CharacteristicType::UVIndex)},
    {sipName_Irradiance, static_cast<int>(::QBluetoothUuid::CharacteristicType::Irradiance)},
    {sipName_Rainfall, static_cast<int>(::QBluetoothUuid::CharacteristicType::Rainfall)},
    {sipName_WindChill, static_cast<int>(::QBluetoothUuid::CharacteristicType::WindChill)},
    {sipName_HeatIndex, static_cast<int>(::QBluetoothUuid::CharacteristicType::HeatIndex)},
    {sipName_DewPoint, static_cast<int>(::QBluetoothUuid::CharacteristicType::DewPoint)},
    {sipName_DescriptorValueChanged, static_cast<int>(::QBluetoothUuid::CharacteristicType::DescriptorValueChanged)},
    {sipName_AerobicHeartRateLowerLimit, static_cast<int>(::QBluetoothUuid::CharacteristicType::AerobicHeartRateLowerLimit)},
    {sipName_AerobicThreshold, static_cast<int>(::QBluetoothUuid::CharacteristicType::AerobicThreshold)},
    {sipName_Age, static_cast<int>(::QBluetoothUuid::CharacteristicType::Age)},
    {sipName_AnaerobicHeartRateLowerLimit, static_cast<int>(::QBluetoothUuid::CharacteristicType::AnaerobicHeartRateLowerLimit)},
    {sipName_AnaerobicHeartRateUpperLimit, static_cast<int>(::QBluetoothUuid::CharacteristicType::AnaerobicHeartRateUpperLimit)},
    {sipName_AnaerobicThreshold, static_cast<int>(::QBluetoothUuid::CharacteristicType::AnaerobicThreshold)},
    {sipName_AerobicHeartRateUpperLimit, static_cast<int>(::QBluetoothUuid::CharacteristicType::AerobicHeartRateUpperLimit)},
    {sipName_DateOfBirth, static_cast<int>(::QBluetoothUuid::CharacteristicType::DateOfBirth)},
    {sipName_DateOfThresholdAssessment, static_cast<int>(::QBluetoothUuid::CharacteristicType::DateOfThresholdAssessment)},
    {sipName_EmailAddress, static_cast<int>(::QBluetoothUuid::CharacteristicType::EmailAddress)},
    {sipName_FatBurnHeartRateLowerLimit, static_cast<int>(::QBluetoothUuid::CharacteristicType::FatBurnHeartRateLowerLimit)},
    {sipName_FatBurnHeartRateUpperLimit, static_cast<int>(::QBluetoothUuid::CharacteristicType::FatBurnHeartRateUpperLimit)},
    {sipName_FirstName, static_cast<int>(::QBluetoothUuid::CharacteristicType::FirstName)},
    {sipName_FiveZoneHeartRateLimits, static_cast<int>(::QBluetoothUuid::CharacteristicType::FiveZoneHeartRateLimits)},
    {sipName_Gender, static_cast<int>(::QBluetoothUuid::CharacteristicType::Gender)},
    {sipName_HeartRateMax, static_cast<int>(::QBluetoothUuid::CharacteristicType::HeartRateMax)},
    {sipName_Height, static_cast<int>(::QBluetoothUuid::CharacteristicType::Height)},
    {sipName_HipCircumference, static_cast<int>(::QBluetoothUuid::CharacteristicType::HipCircumference)},
    {sipName_LastName, static_cast<int>(::QBluetoothUuid::CharacteristicType::LastName)},
    {sipName_MaximumRecommendedHeartRate, static_cast<int>(::QBluetoothUuid::CharacteristicType::MaximumRecommendedHeartRate)},
    {sipName_RestingHeartRate, static_cast<int>(::QBluetoothUuid::CharacteristicType::RestingHeartRate)},
    {sipName_SportTypeForAerobicAnaerobicThresholds, static_cast<int>(::QBluetoothUuid::CharacteristicType::SportTypeForAerobicAnaerobicThresholds)},
    {sipName_ThreeZoneHeartRateLimits, static_cast<int>(::QBluetoothUuid::CharacteristicType::ThreeZoneHeartRateLimits)},
    {sipName_TwoZoneHeartRateLimits, static_cast<int>(::QBluetoothUuid::CharacteristicType::TwoZoneHeartRateLimits)},
    {sipName_VO2Max, static_cast<int>(::QBluetoothUuid::CharacteristicType::VO2Max)},
    {sipName_WaistCircumference, static_cast<int>(::QBluetoothUuid::CharacteristicType::WaistCircumference)},
    {sipName_Weight, static_cast<int>(::QBluetoothUuid::CharacteristicType::Weight)},
    {sipName_DatabaseChangeIncrement, static_cast<int>(::QBluetoothUuid::CharacteristicType::DatabaseChangeIncrement)},
    {sipName_UserIndex, static_cast<int>(::QBluetoothUuid::CharacteristicType::UserIndex)},
    {sipName_BodyCompositionFeature, static_cast<int>(::QBluetoothUuid::CharacteristicType::BodyCompositionFeature)},
    {sipName_BodyCompositionMeasurement, static_cast<int>(::QBluetoothUuid::CharacteristicType::BodyCompositionMeasurement)},
    {sipName_WeightMeasurement, static_cast<int>(::QBluetoothUuid::CharacteristicType::WeightMeasurement)},
    {sipName_WeightScaleFeature, static_cast<int>(::QBluetoothUuid::CharacteristicType::WeightScaleFeature)},
    {sipName_UserControlPoint, static_cast<int>(::QBluetoothUuid::CharacteristicType::UserControlPoint)},
    {sipName_MagneticFluxDensity2D, static_cast<int>(::QBluetoothUuid::CharacteristicType::MagneticFluxDensity2D)},
    {sipName_MagneticFluxDensity3D, static_cast<int>(::QBluetoothUuid::CharacteristicType::MagneticFluxDensity3D)},
    {sipName_Language, static_cast<int>(::QBluetoothUuid::CharacteristicType::Language)},
    {sipName_BarometricPressureTrend, static_cast<int>(::QBluetoothUuid::CharacteristicType::BarometricPressureTrend)},
    {sipName_UnknownDescriptorType, static_cast<int>(::QBluetoothUuid::DescriptorType::UnknownDescriptorType)},
    {sipName_CharacteristicExtendedProperties, static_cast<int>(::QBluetoothUuid::DescriptorType::CharacteristicExtendedProperties)},
    {sipName_CharacteristicUserDescription, static_cast<int>(::QBluetoothUuid::DescriptorType::CharacteristicUserDescription)},
    {sipName_ClientCharacteristicConfiguration, static_cast<int>(::QBluetoothUuid::DescriptorType::ClientCharacteristicConfiguration)},
    {sipName_ServerCharacteristicConfiguration, static_cast<int>(::QBluetoothUuid::DescriptorType::ServerCharacteristicConfiguration)},
    {sipName_CharacteristicPresentationFormat, static_cast<int>(::QBluetoothUuid::DescriptorType::CharacteristicPresentationFormat)},
    {sipName_CharacteristicAggregateFormat, static_cast<int>(::QBluetoothUuid::DescriptorType::CharacteristicAggregateFormat)},
    {sipName_ValidRange, static_cast<int>(::QBluetoothUuid::DescriptorType::ValidRange)},
    {sipName_ExternalReportReference, static_cast<int>(::QBluetoothUuid::DescriptorType::ExternalReportReference)},
    {sipName_ReportReference, static_cast<int>(::QBluetoothUuid::DescriptorType::ReportReference)},
    {sipName_EnvironmentalSensingConfiguration, static_cast<int>(::QBluetoothUuid::DescriptorType::EnvironmentalSensingConfiguration)},
    {sipName_EnvironmentalSensingMeasurement, static_cast<int>(::QBluetoothUuid::DescriptorType::EnvironmentalSensingMeasurement)},
    {sipName_EnvironmentalSensingTriggerSetting, static_cast<int>(::QBluetoothUuid::DescriptorType::EnvironmentalSensingTriggerSetting)},
    {sipName_Sdp, static_cast<int>(::QBluetoothUuid::ProtocolUuid::Sdp)},
    {sipName_Udp, static_cast<int>(::QBluetoothUuid::ProtocolUuid::Udp)},
    {sipName_Rfcomm, static_cast<int>(::QBluetoothUuid::ProtocolUuid::Rfcomm)},
    {sipName_Tcp, static_cast<int>(::QBluetoothUuid::ProtocolUuid::Tcp)},
    {sipName_TcsBin, static_cast<int>(::QBluetoothUuid::ProtocolUuid::TcsBin)},
    {sipName_TcsAt, static_cast<int>(::QBluetoothUuid::ProtocolUuid::TcsAt)},
    {sipName_Att, static_cast<int>(::QBluetoothUuid::ProtocolUuid::Att)},
    {sipName_Obex, static_cast<int>(::QBluetoothUuid::ProtocolUuid::Obex)},
    {sipName_Ip, static_cast<int>(::QBluetoothUuid::ProtocolUuid::Ip)},
    {sipName_Ftp, static_cast<int>(::QBluetoothUuid::ProtocolUuid::Ftp)},
    {sipName_Http, static_cast<int>(::QBluetoothUuid::ProtocolUuid::Http)},
    {sipName_Wsp, static_cast<int>(::QBluetoothUuid::ProtocolUuid::Wsp)},
    {sipName_Bnep, static_cast<int>(::QBluetoothUuid::ProtocolUuid::Bnep)},
    {sipName_Upnp, static_cast<int>(::QBluetoothUuid::ProtocolUuid::Upnp)},
    {sipName_Hidp, static_cast<int>(::QBluetoothUuid::ProtocolUuid::Hidp)},
    {sipName_HardcopyControlChannel, static_cast<int>(::QBluetoothUuid::ProtocolUuid::HardcopyControlChannel)},
    {sipName_HardcopyDataChannel, static_cast<int>(::QBluetoothUuid::ProtocolUuid::HardcopyDataChannel)},
    {sipName_HardcopyNotification, static_cast<int>(::QBluetoothUuid::ProtocolUuid::HardcopyNotification)},
    {sipName_Avctp, static_cast<int>(::QBluetoothUuid::ProtocolUuid::Avctp)},
    {sipName_Avdtp, static_cast<int>(::QBluetoothUuid::ProtocolUuid::Avdtp)},
    {sipName_Cmtp, static_cast<int>(::QBluetoothUuid::ProtocolUuid::Cmtp)},
    {sipName_UdiCPlain, static_cast<int>(::QBluetoothUuid::ProtocolUuid::UdiCPlain)},
    {sipName_McapControlChannel, static_cast<int>(::QBluetoothUuid::ProtocolUuid::McapControlChannel)},
    {sipName_McapDataChannel, static_cast<int>(::QBluetoothUuid::ProtocolUuid::McapDataChannel)},
    {sipName_L2cap, static_cast<int>(::QBluetoothUuid::ProtocolUuid::L2cap)},
    {sipName_ServiceDiscoveryServer, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::ServiceDiscoveryServer)},
    {sipName_BrowseGroupDescriptor, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::BrowseGroupDescriptor)},
    {sipName_PublicBrowseGroup, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::PublicBrowseGroup)},
    {sipName_SerialPort, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::SerialPort)},
    {sipName_LANAccessUsingPPP, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::LANAccessUsingPPP)},
    {sipName_DialupNetworking, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::DialupNetworking)},
    {sipName_IrMCSync, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::IrMCSync)},
    {sipName_ObexObjectPush, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::ObexObjectPush)},
    {sipName_OBEXFileTransfer, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::OBEXFileTransfer)},
    {sipName_IrMCSyncCommand, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::IrMCSyncCommand)},
    {sipName_Headset, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::Headset)},
    {sipName_AudioSource, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::AudioSource)},
    {sipName_AudioSink, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::AudioSink)},
    {sipName_AV_RemoteControlTarget, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::AV_RemoteControlTarget)},
    {sipName_AdvancedAudioDistribution, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::AdvancedAudioDistribution)},
    {sipName_AV_RemoteControl, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::AV_RemoteControl)},
    {sipName_AV_RemoteControlController, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::AV_RemoteControlController)},
    {sipName_HeadsetAG, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::HeadsetAG)},
    {sipName_PANU, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::PANU)},
    {sipName_NAP, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::NAP)},
    {sipName_GN, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::GN)},
    {sipName_DirectPrinting, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::DirectPrinting)},
    {sipName_ReferencePrinting, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::ReferencePrinting)},
    {sipName_BasicImage, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::BasicImage)},
    {sipName_ImagingResponder, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::ImagingResponder)},
    {sipName_ImagingAutomaticArchive, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::ImagingAutomaticArchive)},
    {sipName_ImagingReferenceObjects, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::ImagingReferenceObjects)},
    {sipName_Handsfree, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::Handsfree)},
    {sipName_HandsfreeAudioGateway, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::HandsfreeAudioGateway)},
    {sipName_DirectPrintingReferenceObjectsService, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::DirectPrintingReferenceObjectsService)},
    {sipName_ReflectedUI, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::ReflectedUI)},
    {sipName_BasicPrinting, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::BasicPrinting)},
    {sipName_PrintingStatus, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::PrintingStatus)},
    {sipName_HumanInterfaceDeviceService, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::HumanInterfaceDeviceService)},
    {sipName_HardcopyCableReplacement, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::HardcopyCableReplacement)},
    {sipName_HCRPrint, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::HCRPrint)},
    {sipName_HCRScan, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::HCRScan)},
    {sipName_SIMAccess, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::SIMAccess)},
    {sipName_PhonebookAccessPCE, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::PhonebookAccessPCE)},
    {sipName_PhonebookAccessPSE, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::PhonebookAccessPSE)},
    {sipName_PhonebookAccess, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::PhonebookAccess)},
    {sipName_HeadsetHS, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::HeadsetHS)},
    {sipName_MessageAccessServer, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::MessageAccessServer)},
    {sipName_MessageNotificationServer, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::MessageNotificationServer)},
    {sipName_MessageAccessProfile, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::MessageAccessProfile)},
    {sipName_GNSS, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::GNSS)},
    {sipName_GNSSServer, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::GNSSServer)},
    {sipName_Display3D, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::Display3D)},
    {sipName_Glasses3D, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::Glasses3D)},
    {sipName_Synchronization3D, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::Synchronization3D)},
    {sipName_MPSProfile, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::MPSProfile)},
    {sipName_MPSService, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::MPSService)},
    {sipName_PnPInformation, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::PnPInformation)},
    {sipName_GenericNetworking, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::GenericNetworking)},
    {sipName_GenericFileTransfer, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::GenericFileTransfer)},
    {sipName_GenericAudio, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::GenericAudio)},
    {sipName_GenericTelephony, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::GenericTelephony)},
    {sipName_VideoSource, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::VideoSource)},
    {sipName_VideoSink, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::VideoSink)},
    {sipName_VideoDistribution, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::VideoDistribution)},
    {sipName_HDP, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::HDP)},
    {sipName_HDPSource, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::HDPSource)},
    {sipName_HDPSink, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::HDPSink)},
    {sipName_GenericAccess, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::GenericAccess)},
    {sipName_GenericAttribute, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::GenericAttribute)},
    {sipName_ImmediateAlert, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::ImmediateAlert)},
    {sipName_LinkLoss, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::LinkLoss)},
    {sipName_TxPower, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::TxPower)},
    {sipName_CurrentTimeService, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::CurrentTimeService)},
    {sipName_ReferenceTimeUpdateService, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::ReferenceTimeUpdateService)},
    {sipName_NextDSTChangeService, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::NextDSTChangeService)},
    {sipName_Glucose, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::Glucose)},
    {sipName_HealthThermometer, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::HealthThermometer)},
    {sipName_DeviceInformation, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::DeviceInformation)},
    {sipName_HeartRate, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::HeartRate)},
    {sipName_PhoneAlertStatusService, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::PhoneAlertStatusService)},
    {sipName_BatteryService, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::BatteryService)},
    {sipName_BloodPressure, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::BloodPressure)},
    {sipName_AlertNotificationService, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::AlertNotificationService)},
    {sipName_HumanInterfaceDevice, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::HumanInterfaceDevice)},
    {sipName_ScanParameters, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::ScanParameters)},
    {sipName_RunningSpeedAndCadence, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::RunningSpeedAndCadence)},
    {sipName_CyclingSpeedAndCadence, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::CyclingSpeedAndCadence)},
    {sipName_CyclingPower, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::CyclingPower)},
    {sipName_LocationAndNavigation, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::LocationAndNavigation)},
    {sipName_EnvironmentalSensing, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::EnvironmentalSensing)},
    {sipName_BodyComposition, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::BodyComposition)},
    {sipName_UserData, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::UserData)},
    {sipName_WeightScale, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::WeightScale)},
    {sipName_BondManagement, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::BondManagement)},
    {sipName_ContinuousGlucoseMonitoring, static_cast<int>(::QBluetoothUuid::ServiceClassUuid::ContinuousGlucoseMonitoring)},
    {0, 0}
};

PyDoc_STRVAR(doc_QBluetoothUuid, "\1QBluetoothUuid()\n"
"QBluetoothUuid(uuid: QBluetoothUuid.ProtocolUuid)\n"
"QBluetoothUuid(uuid: QBluetoothUuid.ServiceClassUuid)\n"
"QBluetoothUuid(uuid: QBluetoothUuid.CharacteristicType)\n"
"QBluetoothUuid(uuid: QBluetoothUuid.DescriptorType)\n"
"QBluetoothUuid(uuid: int)\n"
"QBluetoothUuid(uuid: tuple[int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int], order: QSysInfo.Endian = QSysInfo.BigEndian)\n"
"QBluetoothUuid(uuid: Optional[str])\n"
"QBluetoothUuid(uuid: QBluetoothUuid)\n"
"QBluetoothUuid(uuid: QUuid)");


sipClassTypeDef sipTypeDef_QtBluetooth_QBluetoothUuid = {
    {
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QBluetoothUuid,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_QBluetoothUuid,
        {0, 0, 1},
        8, methods_QBluetoothUuid,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, intInstances_QBluetoothUuid, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QBluetoothUuid,
    -1,
    -1,
    supers_QBluetoothUuid,
    slots_QBluetoothUuid,
    init_type_QBluetoothUuid,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QBluetoothUuid,
    assign_QBluetoothUuid,
    array_QBluetoothUuid,
    copy_QBluetoothUuid,
    release_QBluetoothUuid,
    cast_QBluetoothUuid,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QBluetoothUuid,
    sizeof (::QBluetoothUuid),
};
