/* rygel-video-item.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from rygel-video-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-server.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <libgupnp-av/gupnp-av.h>
#include "rygel-core.h"
#include <libgupnp/gupnp.h>
#include <libgssdp/gssdp.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	RYGEL_VIDEO_ITEM_0_PROPERTY,
	RYGEL_VIDEO_ITEM_AUTHOR_PROPERTY,
	RYGEL_VIDEO_ITEM_WIDTH_PROPERTY,
	RYGEL_VIDEO_ITEM_HEIGHT_PROPERTY,
	RYGEL_VIDEO_ITEM_COLOR_DEPTH_PROPERTY,
	RYGEL_VIDEO_ITEM_THUMBNAILS_PROPERTY,
	RYGEL_VIDEO_ITEM_SUBTITLES_PROPERTY,
	RYGEL_VIDEO_ITEM_NUM_PROPERTIES
};
static GParamSpec* rygel_video_item_properties[RYGEL_VIDEO_ITEM_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_SUBTITLE_MANAGER (rygel_subtitle_manager_get_type ())
#define RYGEL_SUBTITLE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManager))
#define RYGEL_SUBTITLE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManagerClass))
#define RYGEL_IS_SUBTITLE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE_MANAGER))
#define RYGEL_IS_SUBTITLE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE_MANAGER))
#define RYGEL_SUBTITLE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManagerClass))

typedef struct _RygelSubtitleManager RygelSubtitleManager;
typedef struct _RygelSubtitleManagerClass RygelSubtitleManagerClass;
#define _rygel_subtitle_unref0(var) ((var == NULL) ? NULL : (var = (rygel_subtitle_unref (var), NULL)))
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))

struct _RygelVideoItemPrivate {
	gchar* _author;
	gint _width;
	gint _height;
	gint _color_depth;
	GeeArrayList* _thumbnails;
	GeeArrayList* _subtitles;
};

static gint RygelVideoItem_private_offset;
static gpointer rygel_video_item_parent_class = NULL;
static RygelVisualItemIface * rygel_video_item_rygel_visual_item_parent_iface = NULL;

VALA_EXTERN gint rygel_media_object_compare_by_property (RygelMediaObject* self,
                                             RygelMediaObject* media_object,
                                             const gchar* property);
VALA_EXTERN void rygel_media_object_apply_didl_lite (RygelMediaObject* self,
                                         GUPnPDIDLLiteObject* didl_object);
VALA_EXTERN void rygel_video_item_add_subtitle_resources (RygelVideoItem* self,
                                              RygelHTTPServer* http_server);
VALA_EXTERN void rygel_media_file_item_add_additional_resources (RygelMediaFileItem* self,
                                                     RygelHTTPServer* server);
static void rygel_video_item_real_constructed (GObject* base);
static void rygel_video_item_real_add_uri (RygelMediaObject* base,
                                    const gchar* uri);
VALA_EXTERN void rygel_visual_item_add_thumbnail_for_uri (RygelVisualItem* self,
                                              const gchar* uri);
VALA_EXTERN GType rygel_subtitle_manager_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelSubtitleManager* rygel_subtitle_manager_get_default (void);
VALA_EXTERN GeeArrayList* rygel_subtitle_manager_get_subtitles (RygelSubtitleManager* self,
                                                    const gchar* uri,
                                                    GError** error);
static RygelMediaResource* rygel_video_item_real_get_primary_resource (RygelMediaFileItem* base);
VALA_EXTERN void rygel_visual_item_set_visual_resource_properties (RygelVisualItem* self,
                                                       RygelMediaResource* res);
static gint rygel_video_item_real_compare_by_property (RygelMediaObject* base,
                                                RygelMediaObject* media_object,
                                                const gchar* property);
static gchar* rygel_video_item_get_first (RygelVideoItem* self,
                                   GList* contributors);
static void rygel_video_item_real_apply_didl_lite (RygelMediaObject* base,
                                            GUPnPDIDLLiteObject* didl_object);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static GUPnPDIDLLiteObject* rygel_video_item_real_serialize (RygelMediaObject* base,
                                                      RygelSerializer* serializer,
                                                      RygelHTTPServer* http_server,
                                                      GError** error);
VALA_EXTERN gchar* rygel_media_object_get_protocol_for_uri (RygelMediaObject* self,
                                                const gchar* uri,
                                                GError** error);
VALA_EXTERN gchar* rygel_http_server_create_uri_for_object (RygelHTTPServer* self,
                                                RygelMediaObject* object,
                                                gint thumbnail_index,
                                                gint subtitle_index,
                                                const gchar* resource_name);
VALA_EXTERN void rygel_subtitle_add_didl_node (RygelSubtitle* self,
                                   GUPnPDIDLLiteItem* didl_item);
static void rygel_video_item_real_add_subtitle_resources (RygelVideoItem* self,
                                                   RygelHTTPServer* http_server);
VALA_EXTERN RygelMediaResource* rygel_subtitle_get_resource (RygelSubtitle* self,
                                                 const gchar* protocol,
                                                 gint index);
VALA_EXTERN gchar* rygel_http_server_get_protocol (RygelHTTPServer* self);
static void rygel_video_item_real_add_additional_resources (RygelMediaFileItem* base,
                                                     RygelHTTPServer* server);
VALA_EXTERN void rygel_visual_item_add_thumbnail_resources (RygelVisualItem* self,
                                                RygelHTTPServer* http_server);
static void rygel_video_item_finalize (GObject * obj);
static GType rygel_video_item_get_type_once (void);
static void _vala_rygel_video_item_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_rygel_video_item_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);

static inline gpointer
rygel_video_item_get_instance_private (RygelVideoItem* self)
{
	return G_STRUCT_MEMBER_P (self, RygelVideoItem_private_offset);
}

RygelVideoItem*
rygel_video_item_construct (GType object_type,
                            const gchar* id,
                            RygelMediaContainer* parent,
                            const gchar* title,
                            const gchar* upnp_class)
{
	RygelVideoItem * self = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (upnp_class != NULL, NULL);
	self = (RygelVideoItem*) g_object_new (object_type, "id", id, "parent", parent, "title", title, "upnp-class", upnp_class, NULL);
	return self;
}

RygelVideoItem*
rygel_video_item_new (const gchar* id,
                      RygelMediaContainer* parent,
                      const gchar* title,
                      const gchar* upnp_class)
{
	return rygel_video_item_construct (RYGEL_TYPE_VIDEO_ITEM, id, parent, title, upnp_class);
}

static void
rygel_video_item_real_constructed (GObject* base)
{
	RygelVideoItem * self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	self = (RygelVideoItem*) base;
	G_OBJECT_CLASS (rygel_video_item_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem));
	_tmp0_ = gee_array_list_new (RYGEL_TYPE_THUMBNAIL, (GBoxedCopyFunc) rygel_icon_info_ref, (GDestroyNotify) rygel_icon_info_unref, NULL, NULL, NULL);
	_tmp1_ = _tmp0_;
	rygel_visual_item_set_thumbnails ((RygelVisualItem*) self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = gee_array_list_new (RYGEL_TYPE_SUBTITLE, (GBoxedCopyFunc) rygel_subtitle_ref, (GDestroyNotify) rygel_subtitle_unref, NULL, NULL, NULL);
	_tmp3_ = _tmp2_;
	rygel_video_item_set_subtitles (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
}

static void
rygel_video_item_real_add_uri (RygelMediaObject* base,
                               const gchar* uri)
{
	RygelVideoItem * self;
	RygelSubtitleManager* subtitle_manager = NULL;
	RygelSubtitleManager* _tmp0_;
	RygelSubtitleManager* _tmp1_;
	GError* _inner_error0_ = NULL;
	self = (RygelVideoItem*) base;
	g_return_if_fail (uri != NULL);
	RYGEL_MEDIA_OBJECT_CLASS (rygel_video_item_parent_class)->add_uri ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem), uri);
	rygel_visual_item_add_thumbnail_for_uri ((RygelVisualItem*) self, uri);
	_tmp0_ = rygel_subtitle_manager_get_default ();
	subtitle_manager = _tmp0_;
	_tmp1_ = subtitle_manager;
	if (_tmp1_ != NULL) {
		{
			GeeArrayList* subtitles = NULL;
			RygelSubtitleManager* _tmp2_;
			GeeArrayList* _tmp3_;
			GeeArrayList* _tmp4_;
			GeeArrayList* _tmp5_;
			_tmp2_ = subtitle_manager;
			_tmp3_ = rygel_subtitle_manager_get_subtitles (_tmp2_, uri, &_inner_error0_);
			subtitles = _tmp3_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp4_ = self->priv->_subtitles;
			_tmp5_ = subtitles;
			gee_array_list_add_all (_tmp4_, (GeeCollection*) _tmp5_);
			_g_object_unref0 (subtitles);
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (subtitle_manager);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_object_unref0 (subtitle_manager);
}

static RygelMediaResource*
rygel_video_item_real_get_primary_resource (RygelMediaFileItem* base)
{
	RygelVideoItem * self;
	RygelMediaResource* res = NULL;
	RygelMediaResource* _tmp0_;
	RygelMediaResource* result;
	self = (RygelVideoItem*) base;
	_tmp0_ = RYGEL_MEDIA_FILE_ITEM_CLASS (rygel_video_item_parent_class)->get_primary_resource ((RygelMediaFileItem*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem));
	res = _tmp0_;
	rygel_visual_item_set_visual_resource_properties ((RygelVisualItem*) self, res);
	result = res;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gint
rygel_video_item_real_compare_by_property (RygelMediaObject* base,
                                           RygelMediaObject* media_object,
                                           const gchar* property)
{
	RygelVideoItem * self;
	RygelVideoItem* item = NULL;
	RygelVideoItem* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	gint result;
	self = (RygelVideoItem*) base;
	g_return_val_if_fail (media_object != NULL, 0);
	g_return_val_if_fail (property != NULL, 0);
	if (!RYGEL_IS_VIDEO_ITEM (media_object)) {
		result = 1;
		return result;
	}
	_tmp0_ = _g_object_ref0 (RYGEL_IS_VIDEO_ITEM (media_object) ? ((RygelVideoItem*) media_object) : NULL);
	item = _tmp0_;
	_tmp1_ = property;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("upnp:author")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp4_;
				RygelVideoItem* _tmp5_;
				const gchar* _tmp6_;
				_tmp4_ = self->priv->_author;
				_tmp5_ = item;
				_tmp6_ = _tmp5_->priv->_author;
				result = rygel_media_object_compare_string_props ((RygelMediaObject*) self, _tmp4_, _tmp6_);
				_g_object_unref0 (item);
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				RygelVideoItem* _tmp7_;
				_tmp7_ = item;
				result = RYGEL_MEDIA_OBJECT_CLASS (rygel_video_item_parent_class)->compare_by_property ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem), (RygelMediaObject*) _tmp7_, property);
				_g_object_unref0 (item);
				return result;
			}
		}
	}
}

static gchar*
rygel_video_item_get_first (RygelVideoItem* self,
                            GList* contributors)
{
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (contributors != NULL) {
		gconstpointer _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp0_ = contributors->data;
		_tmp1_ = gupnp_didl_lite_contributor_get_name ((GUPnPDIDLLiteContributor*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strdup (_tmp2_);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = g_strdup ("");
	result = _tmp4_;
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
rygel_video_item_real_apply_didl_lite (RygelMediaObject* base,
                                       GUPnPDIDLLiteObject* didl_object)
{
	RygelVideoItem * self;
	GList* _tmp0_;
	GList* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	self = (RygelVideoItem*) base;
	g_return_if_fail (didl_object != NULL);
	RYGEL_MEDIA_OBJECT_CLASS (rygel_video_item_parent_class)->apply_didl_lite ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem), didl_object);
	_tmp0_ = gupnp_didl_lite_object_get_authors (didl_object);
	_tmp1_ = _tmp0_;
	_tmp2_ = rygel_video_item_get_first (self, _tmp1_);
	_tmp3_ = _tmp2_;
	rygel_video_item_set_author (self, _tmp3_);
	_g_free0 (_tmp3_);
	(_tmp1_ == NULL) ? NULL : (_tmp1_ = (_g_list_free__g_object_unref0_ (_tmp1_), NULL));
}

static gpointer
_rygel_subtitle_ref0 (gpointer self)
{
	return self ? rygel_subtitle_ref (self) : NULL;
}

static GUPnPDIDLLiteObject*
rygel_video_item_real_serialize (RygelMediaObject* base,
                                 RygelSerializer* serializer,
                                 RygelHTTPServer* http_server,
                                 GError** error)
{
	RygelVideoItem * self;
	GUPnPDIDLLiteObject* _tmp0_ = NULL;
	GUPnPDIDLLiteObject* _tmp1_;
	GUPnPDIDLLiteItem* didl_item = NULL;
	GUPnPDIDLLiteItem* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	GError* _inner_error0_ = NULL;
	GUPnPDIDLLiteObject* result;
	self = (RygelVideoItem*) base;
	g_return_val_if_fail (serializer != NULL, NULL);
	g_return_val_if_fail (http_server != NULL, NULL);
	_tmp1_ = RYGEL_MEDIA_OBJECT_CLASS (rygel_video_item_parent_class)->serialize ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem), serializer, http_server, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gupnp_didl_lite_item_get_type ()) ? ((GUPnPDIDLLiteItem*) _tmp0_) : NULL);
	didl_item = _tmp2_;
	_tmp4_ = self->priv->_author;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		_tmp5_ = self->priv->_author;
		_tmp3_ = g_strcmp0 (_tmp5_, "") != 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GUPnPDIDLLiteContributor* contributor = NULL;
		GUPnPDIDLLiteItem* _tmp6_;
		GUPnPDIDLLiteContributor* _tmp7_;
		GUPnPDIDLLiteContributor* _tmp8_;
		const gchar* _tmp9_;
		_tmp6_ = didl_item;
		_tmp7_ = gupnp_didl_lite_object_add_author ((GUPnPDIDLLiteObject*) _tmp6_);
		contributor = _tmp7_;
		_tmp8_ = contributor;
		_tmp9_ = self->priv->_author;
		gupnp_didl_lite_contributor_set_name (_tmp8_, _tmp9_);
		_g_object_unref0 (contributor);
	}
	_tmp10_ = rygel_media_file_item_get_place_holder ((RygelMediaFileItem*) self);
	_tmp11_ = _tmp10_;
	if (!_tmp11_) {
		RygelSubtitle* main_subtitle = NULL;
		gpointer _tmp12_;
		RygelSubtitle* _tmp13_;
		RygelSubtitle* _tmp60_;
		GeeArrayList* _tmp80_;
		GeeArrayList* _tmp81_;
		gint _tmp82_;
		gint _tmp83_;
		_tmp12_ = NULL;
		_tmp13_ = _rygel_subtitle_ref0 (RYGEL_IS_SUBTITLE (_tmp12_) ? ((RygelSubtitle*) _tmp12_) : NULL);
		main_subtitle = _tmp13_;
		{
			GeeArrayList* _subtitle_list = NULL;
			GeeArrayList* _tmp14_;
			gint _subtitle_size = 0;
			GeeArrayList* _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			gint _subtitle_index = 0;
			_tmp14_ = self->priv->_subtitles;
			_subtitle_list = _tmp14_;
			_tmp15_ = _subtitle_list;
			_tmp16_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp15_);
			_tmp17_ = _tmp16_;
			_subtitle_size = _tmp17_;
			_subtitle_index = -1;
			while (TRUE) {
				gint _tmp18_;
				gint _tmp19_;
				RygelSubtitle* subtitle = NULL;
				GeeArrayList* _tmp20_;
				gpointer _tmp21_;
				gchar* protocol = NULL;
				RygelSubtitle* _tmp29_;
				const gchar* _tmp30_;
				gboolean _tmp56_ = FALSE;
				_subtitle_index = _subtitle_index + 1;
				_tmp18_ = _subtitle_index;
				_tmp19_ = _subtitle_size;
				if (!(_tmp18_ < _tmp19_)) {
					break;
				}
				_tmp20_ = _subtitle_list;
				_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, _subtitle_index);
				subtitle = (RygelSubtitle*) _tmp21_;
				{
					gchar* _tmp22_ = NULL;
					RygelSubtitle* _tmp23_;
					const gchar* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					_tmp23_ = subtitle;
					_tmp24_ = _tmp23_->uri;
					_tmp25_ = rygel_media_object_get_protocol_for_uri ((RygelMediaObject*) self, _tmp24_, &_inner_error0_);
					_tmp22_ = _tmp25_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_tmp26_ = _tmp22_;
					_tmp22_ = NULL;
					_g_free0 (protocol);
					protocol = _tmp26_;
					_g_free0 (_tmp22_);
				}
				goto __finally0;
				__catch0_g_error:
				{
					RygelSubtitle* _tmp27_;
					const gchar* _tmp28_;
					g_clear_error (&_inner_error0_);
					_tmp27_ = subtitle;
					_tmp28_ = _tmp27_->uri;
					g_message ("rygel-video-item.vala:155: Could not determine protocol for URI %s", _tmp28_);
					_g_free0 (protocol);
					_rygel_subtitle_unref0 (subtitle);
					continue;
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (protocol);
					_rygel_subtitle_unref0 (subtitle);
					_rygel_subtitle_unref0 (main_subtitle);
					_g_object_unref0 (didl_item);
					_g_object_unref0 (_tmp0_);
					return NULL;
				}
				_tmp29_ = subtitle;
				_tmp30_ = _tmp29_->uri;
				if (rygel_http_server_need_proxy (http_server, _tmp30_)) {
					gchar* uri = NULL;
					RygelSubtitle* _tmp31_;
					const gchar* _tmp32_;
					gchar* _tmp33_;
					gint index = 0;
					GeeArrayList* _tmp34_;
					RygelSubtitle* _tmp35_;
					RygelSubtitle* _tmp36_;
					gchar* _tmp37_;
					RygelSubtitle* _tmp38_;
					GUPnPDIDLLiteItem* _tmp39_;
					RygelSubtitle* _tmp40_;
					RygelSubtitle* _tmp50_;
					const gchar* _tmp51_;
					gchar* _tmp52_;
					_tmp31_ = subtitle;
					_tmp32_ = _tmp31_->uri;
					_tmp33_ = g_strdup (_tmp32_);
					uri = _tmp33_;
					_tmp34_ = self->priv->_subtitles;
					_tmp35_ = subtitle;
					index = gee_abstract_list_index_of ((GeeAbstractList*) _tmp34_, _tmp35_);
					_tmp36_ = subtitle;
					_tmp37_ = rygel_http_server_create_uri_for_object (http_server, (RygelMediaObject*) self, -1, index, NULL);
					_g_free0 (_tmp36_->uri);
					_tmp36_->uri = _tmp37_;
					_tmp38_ = subtitle;
					_tmp39_ = didl_item;
					rygel_subtitle_add_didl_node (_tmp38_, _tmp39_);
					_tmp40_ = main_subtitle;
					if (_tmp40_ == NULL) {
						RygelSubtitle* _tmp41_;
						const gchar* _tmp42_;
						RygelSubtitle* _tmp43_;
						const gchar* _tmp44_;
						RygelSubtitle* _tmp45_;
						RygelSubtitle* _tmp46_;
						RygelSubtitle* _tmp47_;
						const gchar* _tmp48_;
						gchar* _tmp49_;
						_tmp41_ = subtitle;
						_tmp42_ = _tmp41_->mime_type;
						_tmp43_ = subtitle;
						_tmp44_ = _tmp43_->caption_type;
						_tmp45_ = rygel_subtitle_new (_tmp42_, _tmp44_, "srt");
						_rygel_subtitle_unref0 (main_subtitle);
						main_subtitle = _tmp45_;
						_tmp46_ = main_subtitle;
						_tmp47_ = subtitle;
						_tmp48_ = _tmp47_->uri;
						_tmp49_ = g_strdup (_tmp48_);
						_g_free0 (_tmp46_->uri);
						_tmp46_->uri = _tmp49_;
					}
					_tmp50_ = subtitle;
					_tmp51_ = uri;
					_tmp52_ = g_strdup (_tmp51_);
					_g_free0 (_tmp50_->uri);
					_tmp50_->uri = _tmp52_;
					_g_free0 (uri);
				} else {
					RygelSubtitle* _tmp53_;
					_tmp53_ = main_subtitle;
					if (_tmp53_ == NULL) {
						RygelSubtitle* _tmp54_;
						RygelSubtitle* _tmp55_;
						_tmp54_ = subtitle;
						_tmp55_ = _rygel_subtitle_ref0 (_tmp54_);
						_rygel_subtitle_unref0 (main_subtitle);
						main_subtitle = _tmp55_;
					}
				}
				if (rygel_http_server_is_local (http_server)) {
					_tmp56_ = TRUE;
				} else {
					const gchar* _tmp57_;
					_tmp57_ = protocol;
					_tmp56_ = g_strcmp0 (_tmp57_, "internal") != 0;
				}
				if (_tmp56_) {
					RygelSubtitle* _tmp58_;
					GUPnPDIDLLiteItem* _tmp59_;
					_tmp58_ = subtitle;
					_tmp59_ = didl_item;
					rygel_subtitle_add_didl_node (_tmp58_, _tmp59_);
				}
				_g_free0 (protocol);
				_rygel_subtitle_unref0 (subtitle);
			}
		}
		_tmp60_ = main_subtitle;
		if (_tmp60_ != NULL) {
			GList* resources = NULL;
			GUPnPDIDLLiteItem* _tmp61_;
			GList* _tmp62_;
			GList* _tmp63_;
			_tmp61_ = didl_item;
			_tmp62_ = gupnp_didl_lite_object_get_resources ((GUPnPDIDLLiteObject*) _tmp61_);
			resources = _tmp62_;
			_tmp63_ = resources;
			{
				GList* resource_collection = NULL;
				GList* resource_it = NULL;
				resource_collection = _tmp63_;
				for (resource_it = resource_collection; resource_it != NULL; resource_it = resource_it->next) {
					GUPnPDIDLLiteResource* _tmp64_;
					GUPnPDIDLLiteResource* resource = NULL;
					_tmp64_ = _g_object_ref0 ((GUPnPDIDLLiteResource*) resource_it->data);
					resource = _tmp64_;
					{
						GUPnPDIDLLiteResource* _tmp65_;
						GUPnPProtocolInfo* _tmp66_;
						GUPnPProtocolInfo* _tmp67_;
						const gchar* _tmp68_;
						const gchar* _tmp69_;
						RygelSubtitle* _tmp70_;
						const gchar* _tmp71_;
						GUPnPDIDLLiteResource* _tmp72_;
						RygelSubtitle* _tmp73_;
						const gchar* _tmp74_;
						gchar* _tmp75_;
						gchar* _tmp76_;
						GUPnPDIDLLiteResource* _tmp77_;
						RygelSubtitle* _tmp78_;
						const gchar* _tmp79_;
						_tmp65_ = resource;
						_tmp66_ = gupnp_didl_lite_resource_get_protocol_info (_tmp65_);
						_tmp67_ = _tmp66_;
						_tmp68_ = gupnp_protocol_info_get_mime_type (_tmp67_);
						_tmp69_ = _tmp68_;
						_tmp70_ = main_subtitle;
						_tmp71_ = _tmp70_->mime_type;
						if (g_strcmp0 (_tmp69_, _tmp71_) == 0) {
							_g_object_unref0 (resource);
							continue;
						}
						_tmp72_ = resource;
						_tmp73_ = main_subtitle;
						_tmp74_ = _tmp73_->caption_type;
						_tmp75_ = g_utf8_strup (_tmp74_, (gssize) -1);
						_tmp76_ = _tmp75_;
						gupnp_didl_lite_resource_set_subtitle_file_type (_tmp72_, _tmp76_);
						_g_free0 (_tmp76_);
						_tmp77_ = resource;
						_tmp78_ = main_subtitle;
						_tmp79_ = _tmp78_->uri;
						gupnp_didl_lite_resource_set_subtitle_file_uri (_tmp77_, _tmp79_);
						_g_object_unref0 (resource);
					}
				}
			}
			(resources == NULL) ? NULL : (resources = (_g_list_free__g_object_unref0_ (resources), NULL));
		}
		_tmp80_ = rygel_visual_item_get_thumbnails ((RygelVisualItem*) self);
		_tmp81_ = _tmp80_;
		_tmp82_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp81_);
		_tmp83_ = _tmp82_;
		if (_tmp83_ != 0) {
			gchar* protocol = NULL;
			GeeArrayList* _tmp84_;
			GeeArrayList* _tmp85_;
			gpointer _tmp86_;
			RygelThumbnail* _tmp87_;
			const gchar* _tmp88_;
			gchar* _tmp89_;
			gchar* _tmp90_;
			gboolean _tmp91_ = FALSE;
			_tmp84_ = rygel_visual_item_get_thumbnails ((RygelVisualItem*) self);
			_tmp85_ = _tmp84_;
			_tmp86_ = gee_abstract_list_get ((GeeAbstractList*) _tmp85_, 0);
			_tmp87_ = (RygelThumbnail*) _tmp86_;
			_tmp88_ = ((RygelIconInfo*) _tmp87_)->uri;
			_tmp89_ = rygel_media_object_get_protocol_for_uri ((RygelMediaObject*) self, _tmp88_, &_inner_error0_);
			_tmp90_ = _tmp89_;
			_rygel_icon_info_unref0 (_tmp87_);
			protocol = _tmp90_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_rygel_subtitle_unref0 (main_subtitle);
				_g_object_unref0 (didl_item);
				_g_object_unref0 (_tmp0_);
				return NULL;
			}
			if (rygel_http_server_is_local (http_server)) {
				_tmp91_ = TRUE;
			} else {
				const gchar* _tmp92_;
				_tmp92_ = protocol;
				_tmp91_ = g_strcmp0 (_tmp92_, "internal") != 0;
			}
			if (_tmp91_) {
				GUPnPDIDLLiteItem* _tmp93_;
				GeeArrayList* _tmp94_;
				GeeArrayList* _tmp95_;
				gpointer _tmp96_;
				RygelThumbnail* _tmp97_;
				const gchar* _tmp98_;
				_tmp93_ = didl_item;
				_tmp94_ = rygel_visual_item_get_thumbnails ((RygelVisualItem*) self);
				_tmp95_ = _tmp94_;
				_tmp96_ = gee_abstract_list_get ((GeeAbstractList*) _tmp95_, 0);
				_tmp97_ = (RygelThumbnail*) _tmp96_;
				_tmp98_ = ((RygelIconInfo*) _tmp97_)->uri;
				gupnp_didl_lite_object_set_album_art ((GUPnPDIDLLiteObject*) _tmp93_, _tmp98_);
				_rygel_icon_info_unref0 (_tmp97_);
			} else {
				gchar* http_uri = NULL;
				gchar* _tmp99_;
				gchar* _tmp100_ = NULL;
				GRegex* _tmp101_;
				const gchar* _tmp102_;
				GUPnPContext* _tmp103_;
				GInetAddress* _tmp104_;
				GInetAddress* _tmp105_;
				GInetAddress* _tmp106_;
				gchar* _tmp107_;
				gchar* _tmp108_;
				gchar* _tmp109_;
				gchar* _tmp110_;
				GUPnPDIDLLiteItem* _tmp111_;
				_tmp99_ = rygel_http_server_create_uri_for_object (http_server, (RygelMediaObject*) self, 0, -1, NULL);
				http_uri = _tmp99_;
				_tmp101_ = rygel_media_file_item_address_regex;
				_tmp102_ = http_uri;
				_tmp103_ = http_server->context;
				_tmp104_ = gssdp_client_get_address ((GSSDPClient*) _tmp103_);
				_tmp105_ = _tmp104_;
				_tmp106_ = _tmp105_;
				_tmp107_ = g_inet_address_to_string (_tmp106_);
				_tmp108_ = _tmp107_;
				_tmp109_ = g_regex_replace_literal (_tmp101_, _tmp102_, (gssize) -1, 0, _tmp108_, 0, &_inner_error0_);
				_tmp110_ = _tmp109_;
				_g_free0 (_tmp108_);
				_g_object_unref0 (_tmp106_);
				_tmp100_ = _tmp110_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (http_uri);
					_g_free0 (protocol);
					_rygel_subtitle_unref0 (main_subtitle);
					_g_object_unref0 (didl_item);
					_g_object_unref0 (_tmp0_);
					return NULL;
				}
				_tmp111_ = didl_item;
				gupnp_didl_lite_object_set_album_art ((GUPnPDIDLLiteObject*) _tmp111_, _tmp100_);
				_g_free0 (_tmp100_);
				_g_free0 (http_uri);
			}
			_g_free0 (protocol);
		}
		_rygel_subtitle_unref0 (main_subtitle);
	}
	result = (GUPnPDIDLLiteObject*) didl_item;
	_g_object_unref0 (_tmp0_);
	return result;
}

static void
rygel_video_item_real_add_subtitle_resources (RygelVideoItem* self,
                                              RygelHTTPServer* http_server)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (http_server != NULL);
	_tmp0_ = rygel_media_file_item_get_place_holder ((RygelMediaFileItem*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				RygelSubtitle* subtitle = NULL;
				GeeArrayList* _tmp7_;
				gpointer _tmp8_;
				gchar* protocol = NULL;
				RygelMediaResource* subtitle_resource = NULL;
				RygelSubtitle* _tmp16_;
				const gchar* _tmp17_;
				RygelMediaResource* _tmp18_;
				RygelMediaResource* _tmp19_;
				RygelSubtitle* _tmp20_;
				const gchar* _tmp21_;
				GeeList* _tmp22_;
				GeeList* _tmp23_;
				RygelMediaResource* _tmp24_;
				RygelSubtitle* _tmp25_;
				const gchar* _tmp26_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = self->priv->_subtitles;
				_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
				_tmp6_ = _tmp5_;
				if (!(i < _tmp6_)) {
					break;
				}
				_tmp7_ = self->priv->_subtitles;
				_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, i);
				subtitle = (RygelSubtitle*) _tmp8_;
				{
					gchar* _tmp9_ = NULL;
					RygelSubtitle* _tmp10_;
					const gchar* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					_tmp10_ = subtitle;
					_tmp11_ = _tmp10_->uri;
					_tmp12_ = rygel_media_object_get_protocol_for_uri ((RygelMediaObject*) self, _tmp11_, &_inner_error0_);
					_tmp9_ = _tmp12_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_tmp13_ = _tmp9_;
					_tmp9_ = NULL;
					_g_free0 (protocol);
					protocol = _tmp13_;
					_g_free0 (_tmp9_);
				}
				goto __finally0;
				__catch0_g_error:
				{
					RygelSubtitle* _tmp14_;
					const gchar* _tmp15_;
					g_clear_error (&_inner_error0_);
					_tmp14_ = subtitle;
					_tmp15_ = _tmp14_->uri;
					g_message (_ ("Could not determine protocol for URI %s"), _tmp15_);
					_g_free0 (protocol);
					_rygel_subtitle_unref0 (subtitle);
					continue;
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (protocol);
					_rygel_subtitle_unref0 (subtitle);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_tmp16_ = subtitle;
				_tmp17_ = protocol;
				_tmp18_ = rygel_subtitle_get_resource (_tmp16_, _tmp17_, i);
				subtitle_resource = _tmp18_;
				_tmp19_ = subtitle_resource;
				_tmp20_ = subtitle;
				_tmp21_ = _tmp20_->uri;
				rygel_media_resource_set_uri (_tmp19_, _tmp21_);
				_tmp22_ = rygel_media_object_get_resource_list ((RygelMediaObject*) self);
				_tmp23_ = _tmp22_;
				_tmp24_ = subtitle_resource;
				gee_collection_add ((GeeCollection*) _tmp23_, _tmp24_);
				_g_object_unref0 (_tmp23_);
				_tmp25_ = subtitle;
				_tmp26_ = _tmp25_->uri;
				if (rygel_http_server_need_proxy (http_server, _tmp26_)) {
					RygelMediaResource* http_sub_res = NULL;
					RygelSubtitle* _tmp27_;
					gchar* _tmp28_;
					gchar* _tmp29_;
					RygelMediaResource* _tmp30_;
					RygelMediaResource* _tmp31_;
					RygelMediaResource* _tmp32_;
					gchar* _tmp33_;
					gchar* _tmp34_;
					GeeList* _tmp35_;
					GeeList* _tmp36_;
					RygelMediaResource* _tmp37_;
					_tmp27_ = subtitle;
					_tmp28_ = rygel_http_server_get_protocol (http_server);
					_tmp29_ = _tmp28_;
					_tmp30_ = rygel_subtitle_get_resource (_tmp27_, _tmp29_, i);
					_tmp31_ = _tmp30_;
					_g_free0 (_tmp29_);
					http_sub_res = _tmp31_;
					_tmp32_ = http_sub_res;
					_tmp33_ = rygel_http_server_create_uri_for_object (http_server, (RygelMediaObject*) self, -1, i, NULL);
					_tmp34_ = _tmp33_;
					rygel_media_resource_set_uri (_tmp32_, _tmp34_);
					_g_free0 (_tmp34_);
					_tmp35_ = rygel_media_object_get_resource_list ((RygelMediaObject*) self);
					_tmp36_ = _tmp35_;
					_tmp37_ = http_sub_res;
					gee_collection_add ((GeeCollection*) _tmp36_, _tmp37_);
					_g_object_unref0 (_tmp36_);
					_g_object_unref0 (http_sub_res);
				}
				_g_object_unref0 (subtitle_resource);
				_g_free0 (protocol);
				_rygel_subtitle_unref0 (subtitle);
			}
		}
	}
}

void
rygel_video_item_add_subtitle_resources (RygelVideoItem* self,
                                         RygelHTTPServer* http_server)
{
	RygelVideoItemClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = RYGEL_VIDEO_ITEM_GET_CLASS (self);
	if (_klass_->add_subtitle_resources) {
		_klass_->add_subtitle_resources (self, http_server);
	}
}

static void
rygel_video_item_real_add_additional_resources (RygelMediaFileItem* base,
                                                RygelHTTPServer* server)
{
	RygelVideoItem * self;
	self = (RygelVideoItem*) base;
	g_return_if_fail (server != NULL);
	RYGEL_MEDIA_FILE_ITEM_CLASS (rygel_video_item_parent_class)->add_additional_resources ((RygelMediaFileItem*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem), server);
	rygel_visual_item_add_thumbnail_resources ((RygelVisualItem*) self, server);
	rygel_video_item_add_subtitle_resources (self, server);
}

const gchar*
rygel_video_item_get_author (RygelVideoItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_author;
	result = _tmp0_;
	return result;
}

void
rygel_video_item_set_author (RygelVideoItem* self,
                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_video_item_get_author (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_author);
		self->priv->_author = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_video_item_properties[RYGEL_VIDEO_ITEM_AUTHOR_PROPERTY]);
	}
}

static gint
rygel_video_item_real_get_width (RygelVisualItem* base)
{
	gint result;
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	result = self->priv->_width;
	return result;
}

static void
rygel_video_item_real_set_width (RygelVisualItem* base,
                                 gint value)
{
	RygelVideoItem* self;
	gint old_value;
	self = (RygelVideoItem*) base;
	old_value = rygel_video_item_real_get_width (base);
	if (old_value != value) {
		self->priv->_width = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_video_item_properties[RYGEL_VIDEO_ITEM_WIDTH_PROPERTY]);
	}
}

static gint
rygel_video_item_real_get_height (RygelVisualItem* base)
{
	gint result;
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	result = self->priv->_height;
	return result;
}

static void
rygel_video_item_real_set_height (RygelVisualItem* base,
                                  gint value)
{
	RygelVideoItem* self;
	gint old_value;
	self = (RygelVideoItem*) base;
	old_value = rygel_video_item_real_get_height (base);
	if (old_value != value) {
		self->priv->_height = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_video_item_properties[RYGEL_VIDEO_ITEM_HEIGHT_PROPERTY]);
	}
}

static gint
rygel_video_item_real_get_color_depth (RygelVisualItem* base)
{
	gint result;
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	result = self->priv->_color_depth;
	return result;
}

static void
rygel_video_item_real_set_color_depth (RygelVisualItem* base,
                                       gint value)
{
	RygelVideoItem* self;
	gint old_value;
	self = (RygelVideoItem*) base;
	old_value = rygel_video_item_real_get_color_depth (base);
	if (old_value != value) {
		self->priv->_color_depth = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_video_item_properties[RYGEL_VIDEO_ITEM_COLOR_DEPTH_PROPERTY]);
	}
}

static GeeArrayList*
rygel_video_item_real_get_thumbnails (RygelVisualItem* base)
{
	GeeArrayList* result;
	RygelVideoItem* self;
	GeeArrayList* _tmp0_;
	self = (RygelVideoItem*) base;
	_tmp0_ = self->priv->_thumbnails;
	result = _tmp0_;
	return result;
}

static void
rygel_video_item_real_set_thumbnails (RygelVisualItem* base,
                                      GeeArrayList* value)
{
	RygelVideoItem* self;
	GeeArrayList* old_value;
	self = (RygelVideoItem*) base;
	old_value = rygel_video_item_real_get_thumbnails (base);
	if (old_value != value) {
		GeeArrayList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_thumbnails);
		self->priv->_thumbnails = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_video_item_properties[RYGEL_VIDEO_ITEM_THUMBNAILS_PROPERTY]);
	}
}

GeeArrayList*
rygel_video_item_get_subtitles (RygelVideoItem* self)
{
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_subtitles;
	result = _tmp0_;
	return result;
}

void
rygel_video_item_set_subtitles (RygelVideoItem* self,
                                GeeArrayList* value)
{
	GeeArrayList* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_video_item_get_subtitles (self);
	if (old_value != value) {
		GeeArrayList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_subtitles);
		self->priv->_subtitles = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_video_item_properties[RYGEL_VIDEO_ITEM_SUBTITLES_PROPERTY]);
	}
}

static void
rygel_video_item_class_init (RygelVideoItemClass * klass,
                             gpointer klass_data)
{
	rygel_video_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelVideoItem_private_offset);
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) rygel_video_item_real_constructed;
	((RygelMediaObjectClass *) klass)->add_uri = (void (*) (RygelMediaObject*, const gchar*)) rygel_video_item_real_add_uri;
	((RygelMediaFileItemClass *) klass)->get_primary_resource = (RygelMediaResource* (*) (RygelMediaFileItem*)) rygel_video_item_real_get_primary_resource;
	((RygelMediaObjectClass *) klass)->compare_by_property = (gint (*) (RygelMediaObject*, RygelMediaObject*, const gchar*)) rygel_video_item_real_compare_by_property;
	((RygelMediaObjectClass *) klass)->apply_didl_lite = (void (*) (RygelMediaObject*, GUPnPDIDLLiteObject*)) rygel_video_item_real_apply_didl_lite;
	((RygelMediaObjectClass *) klass)->serialize = (GUPnPDIDLLiteObject* (*) (RygelMediaObject*, RygelSerializer*, RygelHTTPServer*, GError**)) rygel_video_item_real_serialize;
	((RygelVideoItemClass *) klass)->add_subtitle_resources = (void (*) (RygelVideoItem*, RygelHTTPServer*)) rygel_video_item_real_add_subtitle_resources;
	((RygelMediaFileItemClass *) klass)->add_additional_resources = (void (*) (RygelMediaFileItem*, RygelHTTPServer*)) rygel_video_item_real_add_additional_resources;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_video_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_video_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_video_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_VIDEO_ITEM_AUTHOR_PROPERTY, rygel_video_item_properties[RYGEL_VIDEO_ITEM_AUTHOR_PROPERTY] = g_param_spec_string ("author", "author", "author", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The width of the item source content (this.uri) in pixels
	     * A value of -1 means that the width is unknown
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_VIDEO_ITEM_WIDTH_PROPERTY, rygel_video_item_properties[RYGEL_VIDEO_ITEM_WIDTH_PROPERTY] = g_param_spec_int ("width", "width", "width", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The height of the item source content (this.uri) in pixels
	     * A value of -1 means that the height is unknown
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_VIDEO_ITEM_HEIGHT_PROPERTY, rygel_video_item_properties[RYGEL_VIDEO_ITEM_HEIGHT_PROPERTY] = g_param_spec_int ("height", "height", "height", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The number of bits per pixel in the source video resource (this.uri)
	     * A value of -1 means that the color depth is unknown
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_VIDEO_ITEM_COLOR_DEPTH_PROPERTY, rygel_video_item_properties[RYGEL_VIDEO_ITEM_COLOR_DEPTH_PROPERTY] = g_param_spec_int ("color-depth", "color-depth", "color-depth", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Thumbnail pictures to represent the video.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_VIDEO_ITEM_THUMBNAILS_PROPERTY, rygel_video_item_properties[RYGEL_VIDEO_ITEM_THUMBNAILS_PROPERTY] = g_param_spec_object ("thumbnails", "thumbnails", "thumbnails", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_VIDEO_ITEM_SUBTITLES_PROPERTY, rygel_video_item_properties[RYGEL_VIDEO_ITEM_SUBTITLES_PROPERTY] = g_param_spec_object ("subtitles", "subtitles", "subtitles", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
rygel_video_item_rygel_visual_item_interface_init (RygelVisualItemIface * iface,
                                                   gpointer iface_data)
{
	rygel_video_item_rygel_visual_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_width = rygel_video_item_real_get_width;
	iface->set_width = rygel_video_item_real_set_width;
	iface->get_height = rygel_video_item_real_get_height;
	iface->set_height = rygel_video_item_real_set_height;
	iface->get_color_depth = rygel_video_item_real_get_color_depth;
	iface->set_color_depth = rygel_video_item_real_set_color_depth;
	iface->get_thumbnails = rygel_video_item_real_get_thumbnails;
	iface->set_thumbnails = rygel_video_item_real_set_thumbnails;
}

static void
rygel_video_item_instance_init (RygelVideoItem * self,
                                gpointer klass)
{
	self->priv = rygel_video_item_get_instance_private (self);
	self->priv->_width = -1;
	self->priv->_height = -1;
	self->priv->_color_depth = -1;
}

static void
rygel_video_item_finalize (GObject * obj)
{
	RygelVideoItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem);
	_g_free0 (self->priv->_author);
	_g_object_unref0 (self->priv->_thumbnails);
	_g_object_unref0 (self->priv->_subtitles);
	G_OBJECT_CLASS (rygel_video_item_parent_class)->finalize (obj);
}

/**
 * Represents a video item.
 */
 G_GNUC_NO_INLINE static GType
rygel_video_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelVideoItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_video_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelVideoItem), 0, (GInstanceInitFunc) rygel_video_item_instance_init, NULL };
	static const GInterfaceInfo rygel_visual_item_info = { (GInterfaceInitFunc) rygel_video_item_rygel_visual_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType rygel_video_item_type_id;
	rygel_video_item_type_id = g_type_register_static (RYGEL_TYPE_AUDIO_ITEM, "RygelVideoItem", &g_define_type_info, 0);
	g_type_add_interface_static (rygel_video_item_type_id, RYGEL_TYPE_VISUAL_ITEM, &rygel_visual_item_info);
	RygelVideoItem_private_offset = g_type_add_instance_private (rygel_video_item_type_id, sizeof (RygelVideoItemPrivate));
	return rygel_video_item_type_id;
}

GType
rygel_video_item_get_type (void)
{
	static volatile gsize rygel_video_item_type_id__once = 0;
	if (g_once_init_enter (&rygel_video_item_type_id__once)) {
		GType rygel_video_item_type_id;
		rygel_video_item_type_id = rygel_video_item_get_type_once ();
		g_once_init_leave (&rygel_video_item_type_id__once, rygel_video_item_type_id);
	}
	return rygel_video_item_type_id__once;
}

static void
_vala_rygel_video_item_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	RygelVideoItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem);
	switch (property_id) {
		case RYGEL_VIDEO_ITEM_AUTHOR_PROPERTY:
		g_value_set_string (value, rygel_video_item_get_author (self));
		break;
		case RYGEL_VIDEO_ITEM_WIDTH_PROPERTY:
		g_value_set_int (value, rygel_visual_item_get_width ((RygelVisualItem*) self));
		break;
		case RYGEL_VIDEO_ITEM_HEIGHT_PROPERTY:
		g_value_set_int (value, rygel_visual_item_get_height ((RygelVisualItem*) self));
		break;
		case RYGEL_VIDEO_ITEM_COLOR_DEPTH_PROPERTY:
		g_value_set_int (value, rygel_visual_item_get_color_depth ((RygelVisualItem*) self));
		break;
		case RYGEL_VIDEO_ITEM_THUMBNAILS_PROPERTY:
		g_value_set_object (value, rygel_visual_item_get_thumbnails ((RygelVisualItem*) self));
		break;
		case RYGEL_VIDEO_ITEM_SUBTITLES_PROPERTY:
		g_value_set_object (value, rygel_video_item_get_subtitles (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_video_item_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	RygelVideoItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem);
	switch (property_id) {
		case RYGEL_VIDEO_ITEM_AUTHOR_PROPERTY:
		rygel_video_item_set_author (self, g_value_get_string (value));
		break;
		case RYGEL_VIDEO_ITEM_WIDTH_PROPERTY:
		rygel_visual_item_set_width ((RygelVisualItem*) self, g_value_get_int (value));
		break;
		case RYGEL_VIDEO_ITEM_HEIGHT_PROPERTY:
		rygel_visual_item_set_height ((RygelVisualItem*) self, g_value_get_int (value));
		break;
		case RYGEL_VIDEO_ITEM_COLOR_DEPTH_PROPERTY:
		rygel_visual_item_set_color_depth ((RygelVisualItem*) self, g_value_get_int (value));
		break;
		case RYGEL_VIDEO_ITEM_THUMBNAILS_PROPERTY:
		rygel_visual_item_set_thumbnails ((RygelVisualItem*) self, g_value_get_object (value));
		break;
		case RYGEL_VIDEO_ITEM_SUBTITLES_PROPERTY:
		rygel_video_item_set_subtitles (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

