/* s3 compat server functions auto-generated by pidl */
#include "bin/default/librpc/gen_ndr/ndr_ntsvcs.h"
#include "bin/default/librpc/gen_ndr/ndr_ntsvcs_scompat.h"
#include <librpc/rpc/dcesrv_core.h>
#include <rpc_server/rpc_config.h>
#include <rpc_server/rpc_server.h>
#include <util/debug.h>

enum s3compat_rpc_dispatch {
	S3COMPAT_RPC_DISPATCH_EXTERNAL = 0x00000001,
	S3COMPAT_RPC_DISPATCH_INTERNAL = 0x00000002,
};

/* ntsvcs - dcerpc server boilerplate generated by pidl */
static NTSTATUS ntsvcs__op_bind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_NTSVCS_BIND
	return DCESRV_INTERFACE_NTSVCS_BIND(context,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void ntsvcs__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_NTSVCS_UNBIND
	DCESRV_INTERFACE_NTSVCS_UNBIND(context, iface);
#else
	return;
#endif
}

NTSTATUS ntsvcs__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= ndr_table_ntsvcs.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_named(mem_ctx, ndr_table_ntsvcs.calls[opnum].struct_size, "struct %s", ndr_table_ntsvcs.calls[opnum].name);
	NT_STATUS_HAVE_NO_MEMORY(*r);

	/* unravel the NDR for the packet */
	ndr_err = ndr_table_ntsvcs.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS ntsvcs__op_dispatch_internal(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r, enum s3compat_rpc_dispatch dispatch)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;
	struct pipes_struct *p = NULL;
	NTSTATUS status = NT_STATUS_OK;
	bool impersonated = false;

	/* Retrieve pipes struct */
	p = dcesrv_get_pipes_struct(dce_call->conn);
	p->dce_call = dce_call;
	p->mem_ctx = mem_ctx;
	/* Reset pipes struct fault state */
	p->fault_state = 0;

	/* Impersonate */
	if (dispatch == S3COMPAT_RPC_DISPATCH_EXTERNAL) {
		impersonated = become_authenticated_pipe_user(dce_call->auth_state->session_info);
		if (!impersonated) {
			dce_call->fault_code = DCERPC_FAULT_ACCESS_DENIED;
			status = NT_STATUS_NET_WRITE_FAULT;
			goto fail;
		}
	}

	switch (opnum) {
	case 0: { /* PNP_Disconnect */
		struct PNP_Disconnect *r2 = (struct PNP_Disconnect *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_Disconnect, NDR_IN, r2);
		}
		r2->out.result = _PNP_Disconnect(p, r2);
		break;
	}
	case 1: { /* PNP_Connect */
		struct PNP_Connect *r2 = (struct PNP_Connect *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_Connect, NDR_IN, r2);
		}
		r2->out.result = _PNP_Connect(p, r2);
		break;
	}
	case 2: { /* PNP_GetVersion */
		struct PNP_GetVersion *r2 = (struct PNP_GetVersion *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetVersion, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.version = talloc_zero(r2, uint16_t);
		if (r2->out.version == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _PNP_GetVersion(p, r2);
		break;
	}
	case 3: { /* PNP_GetGlobalState */
		struct PNP_GetGlobalState *r2 = (struct PNP_GetGlobalState *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetGlobalState, NDR_IN, r2);
		}
		r2->out.result = _PNP_GetGlobalState(p, r2);
		break;
	}
	case 4: { /* PNP_InitDetection */
		struct PNP_InitDetection *r2 = (struct PNP_InitDetection *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_InitDetection, NDR_IN, r2);
		}
		r2->out.result = _PNP_InitDetection(p, r2);
		break;
	}
	case 5: { /* PNP_ReportLogOn */
		struct PNP_ReportLogOn *r2 = (struct PNP_ReportLogOn *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_ReportLogOn, NDR_IN, r2);
		}
		r2->out.result = _PNP_ReportLogOn(p, r2);
		break;
	}
	case 6: { /* PNP_ValidateDeviceInstance */
		struct PNP_ValidateDeviceInstance *r2 = (struct PNP_ValidateDeviceInstance *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_ValidateDeviceInstance, NDR_IN, r2);
		}
		r2->out.result = _PNP_ValidateDeviceInstance(p, r2);
		break;
	}
	case 7: { /* PNP_GetRootDeviceInstance */
		struct PNP_GetRootDeviceInstance *r2 = (struct PNP_GetRootDeviceInstance *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetRootDeviceInstance, NDR_IN, r2);
		}
		r2->out.result = _PNP_GetRootDeviceInstance(p, r2);
		break;
	}
	case 8: { /* PNP_GetRelatedDeviceInstance */
		struct PNP_GetRelatedDeviceInstance *r2 = (struct PNP_GetRelatedDeviceInstance *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetRelatedDeviceInstance, NDR_IN, r2);
		}
		r2->out.result = _PNP_GetRelatedDeviceInstance(p, r2);
		break;
	}
	case 9: { /* PNP_EnumerateSubKeys */
		struct PNP_EnumerateSubKeys *r2 = (struct PNP_EnumerateSubKeys *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_EnumerateSubKeys, NDR_IN, r2);
		}
		r2->out.result = _PNP_EnumerateSubKeys(p, r2);
		break;
	}
	case 10: { /* PNP_GetDeviceList */
		struct PNP_GetDeviceList *r2 = (struct PNP_GetDeviceList *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetDeviceList, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.length = r2->in.length;
		r2->out.buffer = talloc_zero_array(r2, uint16_t, *r2->out.length);
		if (r2->out.buffer == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _PNP_GetDeviceList(p, r2);
		break;
	}
	case 11: { /* PNP_GetDeviceListSize */
		struct PNP_GetDeviceListSize *r2 = (struct PNP_GetDeviceListSize *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetDeviceListSize, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.size = talloc_zero(r2, uint32_t);
		if (r2->out.size == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _PNP_GetDeviceListSize(p, r2);
		break;
	}
	case 12: { /* PNP_GetDepth */
		struct PNP_GetDepth *r2 = (struct PNP_GetDepth *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetDepth, NDR_IN, r2);
		}
		r2->out.result = _PNP_GetDepth(p, r2);
		break;
	}
	case 13: { /* PNP_GetDeviceRegProp */
		struct PNP_GetDeviceRegProp *r2 = (struct PNP_GetDeviceRegProp *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetDeviceRegProp, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.reg_data_type = r2->in.reg_data_type;
		r2->out.buffer_size = r2->in.buffer_size;
		r2->out.needed = r2->in.needed;
		r2->out.buffer = talloc_zero_array(r2, uint8_t, *r2->out.buffer_size);
		if (r2->out.buffer == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _PNP_GetDeviceRegProp(p, r2);
		break;
	}
	case 14: { /* PNP_SetDeviceRegProp */
		struct PNP_SetDeviceRegProp *r2 = (struct PNP_SetDeviceRegProp *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_SetDeviceRegProp, NDR_IN, r2);
		}
		r2->out.result = _PNP_SetDeviceRegProp(p, r2);
		break;
	}
	case 15: { /* PNP_GetClassInstance */
		struct PNP_GetClassInstance *r2 = (struct PNP_GetClassInstance *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetClassInstance, NDR_IN, r2);
		}
		r2->out.result = _PNP_GetClassInstance(p, r2);
		break;
	}
	case 16: { /* PNP_CreateKey */
		struct PNP_CreateKey *r2 = (struct PNP_CreateKey *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_CreateKey, NDR_IN, r2);
		}
		r2->out.result = _PNP_CreateKey(p, r2);
		break;
	}
	case 17: { /* PNP_DeleteRegistryKey */
		struct PNP_DeleteRegistryKey *r2 = (struct PNP_DeleteRegistryKey *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_DeleteRegistryKey, NDR_IN, r2);
		}
		r2->out.result = _PNP_DeleteRegistryKey(p, r2);
		break;
	}
	case 18: { /* PNP_GetClassCount */
		struct PNP_GetClassCount *r2 = (struct PNP_GetClassCount *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetClassCount, NDR_IN, r2);
		}
		r2->out.result = _PNP_GetClassCount(p, r2);
		break;
	}
	case 19: { /* PNP_GetClassName */
		struct PNP_GetClassName *r2 = (struct PNP_GetClassName *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetClassName, NDR_IN, r2);
		}
		r2->out.result = _PNP_GetClassName(p, r2);
		break;
	}
	case 20: { /* PNP_DeleteClassKey */
		struct PNP_DeleteClassKey *r2 = (struct PNP_DeleteClassKey *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_DeleteClassKey, NDR_IN, r2);
		}
		r2->out.result = _PNP_DeleteClassKey(p, r2);
		break;
	}
	case 21: { /* PNP_GetInterfaceDeviceAlias */
		struct PNP_GetInterfaceDeviceAlias *r2 = (struct PNP_GetInterfaceDeviceAlias *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetInterfaceDeviceAlias, NDR_IN, r2);
		}
		r2->out.result = _PNP_GetInterfaceDeviceAlias(p, r2);
		break;
	}
	case 22: { /* PNP_GetInterfaceDeviceList */
		struct PNP_GetInterfaceDeviceList *r2 = (struct PNP_GetInterfaceDeviceList *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetInterfaceDeviceList, NDR_IN, r2);
		}
		r2->out.result = _PNP_GetInterfaceDeviceList(p, r2);
		break;
	}
	case 23: { /* PNP_GetInterfaceDeviceListSize */
		struct PNP_GetInterfaceDeviceListSize *r2 = (struct PNP_GetInterfaceDeviceListSize *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetInterfaceDeviceListSize, NDR_IN, r2);
		}
		r2->out.result = _PNP_GetInterfaceDeviceListSize(p, r2);
		break;
	}
	case 24: { /* PNP_RegisterDeviceClassAssociation */
		struct PNP_RegisterDeviceClassAssociation *r2 = (struct PNP_RegisterDeviceClassAssociation *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_RegisterDeviceClassAssociation, NDR_IN, r2);
		}
		r2->out.result = _PNP_RegisterDeviceClassAssociation(p, r2);
		break;
	}
	case 25: { /* PNP_UnregisterDeviceClassAssociation */
		struct PNP_UnregisterDeviceClassAssociation *r2 = (struct PNP_UnregisterDeviceClassAssociation *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_UnregisterDeviceClassAssociation, NDR_IN, r2);
		}
		r2->out.result = _PNP_UnregisterDeviceClassAssociation(p, r2);
		break;
	}
	case 26: { /* PNP_GetClassRegProp */
		struct PNP_GetClassRegProp *r2 = (struct PNP_GetClassRegProp *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetClassRegProp, NDR_IN, r2);
		}
		r2->out.result = _PNP_GetClassRegProp(p, r2);
		break;
	}
	case 27: { /* PNP_SetClassRegProp */
		struct PNP_SetClassRegProp *r2 = (struct PNP_SetClassRegProp *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_SetClassRegProp, NDR_IN, r2);
		}
		r2->out.result = _PNP_SetClassRegProp(p, r2);
		break;
	}
	case 28: { /* PNP_CreateDevInst */
		struct PNP_CreateDevInst *r2 = (struct PNP_CreateDevInst *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_CreateDevInst, NDR_IN, r2);
		}
		r2->out.result = _PNP_CreateDevInst(p, r2);
		break;
	}
	case 29: { /* PNP_DeviceInstanceAction */
		struct PNP_DeviceInstanceAction *r2 = (struct PNP_DeviceInstanceAction *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_DeviceInstanceAction, NDR_IN, r2);
		}
		r2->out.result = _PNP_DeviceInstanceAction(p, r2);
		break;
	}
	case 30: { /* PNP_GetDeviceStatus */
		struct PNP_GetDeviceStatus *r2 = (struct PNP_GetDeviceStatus *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetDeviceStatus, NDR_IN, r2);
		}
		r2->out.result = _PNP_GetDeviceStatus(p, r2);
		break;
	}
	case 31: { /* PNP_SetDeviceProblem */
		struct PNP_SetDeviceProblem *r2 = (struct PNP_SetDeviceProblem *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_SetDeviceProblem, NDR_IN, r2);
		}
		r2->out.result = _PNP_SetDeviceProblem(p, r2);
		break;
	}
	case 32: { /* PNP_DisableDevInst */
		struct PNP_DisableDevInst *r2 = (struct PNP_DisableDevInst *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_DisableDevInst, NDR_IN, r2);
		}
		r2->out.result = _PNP_DisableDevInst(p, r2);
		break;
	}
	case 33: { /* PNP_UninstallDevInst */
		struct PNP_UninstallDevInst *r2 = (struct PNP_UninstallDevInst *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_UninstallDevInst, NDR_IN, r2);
		}
		r2->out.result = _PNP_UninstallDevInst(p, r2);
		break;
	}
	case 34: { /* PNP_AddID */
		struct PNP_AddID *r2 = (struct PNP_AddID *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_AddID, NDR_IN, r2);
		}
		r2->out.result = _PNP_AddID(p, r2);
		break;
	}
	case 35: { /* PNP_RegisterDriver */
		struct PNP_RegisterDriver *r2 = (struct PNP_RegisterDriver *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_RegisterDriver, NDR_IN, r2);
		}
		r2->out.result = _PNP_RegisterDriver(p, r2);
		break;
	}
	case 36: { /* PNP_QueryRemove */
		struct PNP_QueryRemove *r2 = (struct PNP_QueryRemove *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_QueryRemove, NDR_IN, r2);
		}
		r2->out.result = _PNP_QueryRemove(p, r2);
		break;
	}
	case 37: { /* PNP_RequestDeviceEject */
		struct PNP_RequestDeviceEject *r2 = (struct PNP_RequestDeviceEject *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_RequestDeviceEject, NDR_IN, r2);
		}
		r2->out.result = _PNP_RequestDeviceEject(p, r2);
		break;
	}
	case 38: { /* PNP_IsDockStationPresent */
		struct PNP_IsDockStationPresent *r2 = (struct PNP_IsDockStationPresent *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_IsDockStationPresent, NDR_IN, r2);
		}
		r2->out.result = _PNP_IsDockStationPresent(p, r2);
		break;
	}
	case 39: { /* PNP_RequestEjectPC */
		struct PNP_RequestEjectPC *r2 = (struct PNP_RequestEjectPC *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_RequestEjectPC, NDR_IN, r2);
		}
		r2->out.result = _PNP_RequestEjectPC(p, r2);
		break;
	}
	case 40: { /* PNP_HwProfFlags */
		struct PNP_HwProfFlags *r2 = (struct PNP_HwProfFlags *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_HwProfFlags, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.profile_flags = r2->in.profile_flags;
		r2->out.veto_type = r2->in.veto_type;
		r2->out.unknown5a = talloc_zero(r2, const char *);
		if (r2->out.unknown5a == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _PNP_HwProfFlags(p, r2);
		break;
	}
	case 41: { /* PNP_GetHwProfInfo */
		struct PNP_GetHwProfInfo *r2 = (struct PNP_GetHwProfInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetHwProfInfo, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info = r2->in.info;
		r2->out.result = _PNP_GetHwProfInfo(p, r2);
		break;
	}
	case 42: { /* PNP_AddEmptyLogConf */
		struct PNP_AddEmptyLogConf *r2 = (struct PNP_AddEmptyLogConf *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_AddEmptyLogConf, NDR_IN, r2);
		}
		r2->out.result = _PNP_AddEmptyLogConf(p, r2);
		break;
	}
	case 43: { /* PNP_FreeLogConf */
		struct PNP_FreeLogConf *r2 = (struct PNP_FreeLogConf *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_FreeLogConf, NDR_IN, r2);
		}
		r2->out.result = _PNP_FreeLogConf(p, r2);
		break;
	}
	case 44: { /* PNP_GetFirstLogConf */
		struct PNP_GetFirstLogConf *r2 = (struct PNP_GetFirstLogConf *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetFirstLogConf, NDR_IN, r2);
		}
		r2->out.result = _PNP_GetFirstLogConf(p, r2);
		break;
	}
	case 45: { /* PNP_GetNextLogConf */
		struct PNP_GetNextLogConf *r2 = (struct PNP_GetNextLogConf *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetNextLogConf, NDR_IN, r2);
		}
		r2->out.result = _PNP_GetNextLogConf(p, r2);
		break;
	}
	case 46: { /* PNP_GetLogConfPriority */
		struct PNP_GetLogConfPriority *r2 = (struct PNP_GetLogConfPriority *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetLogConfPriority, NDR_IN, r2);
		}
		r2->out.result = _PNP_GetLogConfPriority(p, r2);
		break;
	}
	case 47: { /* PNP_AddResDes */
		struct PNP_AddResDes *r2 = (struct PNP_AddResDes *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_AddResDes, NDR_IN, r2);
		}
		r2->out.result = _PNP_AddResDes(p, r2);
		break;
	}
	case 48: { /* PNP_FreeResDes */
		struct PNP_FreeResDes *r2 = (struct PNP_FreeResDes *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_FreeResDes, NDR_IN, r2);
		}
		r2->out.result = _PNP_FreeResDes(p, r2);
		break;
	}
	case 49: { /* PNP_GetNextResDes */
		struct PNP_GetNextResDes *r2 = (struct PNP_GetNextResDes *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetNextResDes, NDR_IN, r2);
		}
		r2->out.result = _PNP_GetNextResDes(p, r2);
		break;
	}
	case 50: { /* PNP_GetResDesData */
		struct PNP_GetResDesData *r2 = (struct PNP_GetResDesData *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetResDesData, NDR_IN, r2);
		}
		r2->out.result = _PNP_GetResDesData(p, r2);
		break;
	}
	case 51: { /* PNP_GetResDesDataSize */
		struct PNP_GetResDesDataSize *r2 = (struct PNP_GetResDesDataSize *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetResDesDataSize, NDR_IN, r2);
		}
		r2->out.result = _PNP_GetResDesDataSize(p, r2);
		break;
	}
	case 52: { /* PNP_ModifyResDes */
		struct PNP_ModifyResDes *r2 = (struct PNP_ModifyResDes *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_ModifyResDes, NDR_IN, r2);
		}
		r2->out.result = _PNP_ModifyResDes(p, r2);
		break;
	}
	case 53: { /* PNP_DetectResourceLimit */
		struct PNP_DetectResourceLimit *r2 = (struct PNP_DetectResourceLimit *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_DetectResourceLimit, NDR_IN, r2);
		}
		r2->out.result = _PNP_DetectResourceLimit(p, r2);
		break;
	}
	case 54: { /* PNP_QueryResConfList */
		struct PNP_QueryResConfList *r2 = (struct PNP_QueryResConfList *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_QueryResConfList, NDR_IN, r2);
		}
		r2->out.result = _PNP_QueryResConfList(p, r2);
		break;
	}
	case 55: { /* PNP_SetHwProf */
		struct PNP_SetHwProf *r2 = (struct PNP_SetHwProf *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_SetHwProf, NDR_IN, r2);
		}
		r2->out.result = _PNP_SetHwProf(p, r2);
		break;
	}
	case 56: { /* PNP_QueryArbitratorFreeData */
		struct PNP_QueryArbitratorFreeData *r2 = (struct PNP_QueryArbitratorFreeData *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_QueryArbitratorFreeData, NDR_IN, r2);
		}
		r2->out.result = _PNP_QueryArbitratorFreeData(p, r2);
		break;
	}
	case 57: { /* PNP_QueryArbitratorFreeSize */
		struct PNP_QueryArbitratorFreeSize *r2 = (struct PNP_QueryArbitratorFreeSize *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_QueryArbitratorFreeSize, NDR_IN, r2);
		}
		r2->out.result = _PNP_QueryArbitratorFreeSize(p, r2);
		break;
	}
	case 58: { /* PNP_RunDetection */
		struct PNP_RunDetection *r2 = (struct PNP_RunDetection *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_RunDetection, NDR_IN, r2);
		}
		r2->out.result = _PNP_RunDetection(p, r2);
		break;
	}
	case 59: { /* PNP_RegisterNotification */
		struct PNP_RegisterNotification *r2 = (struct PNP_RegisterNotification *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_RegisterNotification, NDR_IN, r2);
		}
		r2->out.result = _PNP_RegisterNotification(p, r2);
		break;
	}
	case 60: { /* PNP_UnregisterNotification */
		struct PNP_UnregisterNotification *r2 = (struct PNP_UnregisterNotification *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_UnregisterNotification, NDR_IN, r2);
		}
		r2->out.result = _PNP_UnregisterNotification(p, r2);
		break;
	}
	case 61: { /* PNP_GetCustomDevProp */
		struct PNP_GetCustomDevProp *r2 = (struct PNP_GetCustomDevProp *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetCustomDevProp, NDR_IN, r2);
		}
		r2->out.result = _PNP_GetCustomDevProp(p, r2);
		break;
	}
	case 62: { /* PNP_GetVersionInternal */
		struct PNP_GetVersionInternal *r2 = (struct PNP_GetVersionInternal *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetVersionInternal, NDR_IN, r2);
		}
		r2->out.result = _PNP_GetVersionInternal(p, r2);
		break;
	}
	case 63: { /* PNP_GetBlockedDriverInfo */
		struct PNP_GetBlockedDriverInfo *r2 = (struct PNP_GetBlockedDriverInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetBlockedDriverInfo, NDR_IN, r2);
		}
		r2->out.result = _PNP_GetBlockedDriverInfo(p, r2);
		break;
	}
	case 64: { /* PNP_GetServerSideDeviceInstallFlags */
		struct PNP_GetServerSideDeviceInstallFlags *r2 = (struct PNP_GetServerSideDeviceInstallFlags *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetServerSideDeviceInstallFlags, NDR_IN, r2);
		}
		r2->out.result = _PNP_GetServerSideDeviceInstallFlags(p, r2);
		break;
	}
	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

fail:
	/* Unimpersonate */
	if (impersonated) {
		unbecome_authenticated_pipe_user();
	}

	p->dce_call = NULL;
	p->mem_ctx = NULL;
	/* Check pipes struct fault state */
	if (p->fault_state != 0) {
		dce_call->fault_code = p->fault_state;
	}
	if (dce_call->fault_code != 0) {
		status = NT_STATUS_NET_WRITE_FAULT;
	}

	return status;
}

NTSTATUS ntsvcs__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	return ntsvcs__op_dispatch_internal(dce_call, mem_ctx, r, S3COMPAT_RPC_DISPATCH_EXTERNAL);
}

NTSTATUS ntsvcs__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: { /* PNP_Disconnect */
		struct PNP_Disconnect *r2 = (struct PNP_Disconnect *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_Disconnect replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_Disconnect, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_Disconnect\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 1: { /* PNP_Connect */
		struct PNP_Connect *r2 = (struct PNP_Connect *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_Connect replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_Connect, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_Connect\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 2: { /* PNP_GetVersion */
		struct PNP_GetVersion *r2 = (struct PNP_GetVersion *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetVersion replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetVersion, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_GetVersion\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 3: { /* PNP_GetGlobalState */
		struct PNP_GetGlobalState *r2 = (struct PNP_GetGlobalState *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetGlobalState replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetGlobalState, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_GetGlobalState\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 4: { /* PNP_InitDetection */
		struct PNP_InitDetection *r2 = (struct PNP_InitDetection *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_InitDetection replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_InitDetection, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_InitDetection\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 5: { /* PNP_ReportLogOn */
		struct PNP_ReportLogOn *r2 = (struct PNP_ReportLogOn *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_ReportLogOn replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_ReportLogOn, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_ReportLogOn\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 6: { /* PNP_ValidateDeviceInstance */
		struct PNP_ValidateDeviceInstance *r2 = (struct PNP_ValidateDeviceInstance *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_ValidateDeviceInstance replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_ValidateDeviceInstance, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_ValidateDeviceInstance\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 7: { /* PNP_GetRootDeviceInstance */
		struct PNP_GetRootDeviceInstance *r2 = (struct PNP_GetRootDeviceInstance *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetRootDeviceInstance replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetRootDeviceInstance, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_GetRootDeviceInstance\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 8: { /* PNP_GetRelatedDeviceInstance */
		struct PNP_GetRelatedDeviceInstance *r2 = (struct PNP_GetRelatedDeviceInstance *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetRelatedDeviceInstance replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetRelatedDeviceInstance, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_GetRelatedDeviceInstance\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 9: { /* PNP_EnumerateSubKeys */
		struct PNP_EnumerateSubKeys *r2 = (struct PNP_EnumerateSubKeys *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_EnumerateSubKeys replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_EnumerateSubKeys, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_EnumerateSubKeys\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 10: { /* PNP_GetDeviceList */
		struct PNP_GetDeviceList *r2 = (struct PNP_GetDeviceList *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetDeviceList replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetDeviceList, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_GetDeviceList\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 11: { /* PNP_GetDeviceListSize */
		struct PNP_GetDeviceListSize *r2 = (struct PNP_GetDeviceListSize *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetDeviceListSize replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetDeviceListSize, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_GetDeviceListSize\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 12: { /* PNP_GetDepth */
		struct PNP_GetDepth *r2 = (struct PNP_GetDepth *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetDepth replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetDepth, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_GetDepth\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 13: { /* PNP_GetDeviceRegProp */
		struct PNP_GetDeviceRegProp *r2 = (struct PNP_GetDeviceRegProp *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetDeviceRegProp replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetDeviceRegProp, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_GetDeviceRegProp\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 14: { /* PNP_SetDeviceRegProp */
		struct PNP_SetDeviceRegProp *r2 = (struct PNP_SetDeviceRegProp *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_SetDeviceRegProp replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_SetDeviceRegProp, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_SetDeviceRegProp\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 15: { /* PNP_GetClassInstance */
		struct PNP_GetClassInstance *r2 = (struct PNP_GetClassInstance *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetClassInstance replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetClassInstance, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_GetClassInstance\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 16: { /* PNP_CreateKey */
		struct PNP_CreateKey *r2 = (struct PNP_CreateKey *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_CreateKey replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_CreateKey, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_CreateKey\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 17: { /* PNP_DeleteRegistryKey */
		struct PNP_DeleteRegistryKey *r2 = (struct PNP_DeleteRegistryKey *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_DeleteRegistryKey replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_DeleteRegistryKey, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_DeleteRegistryKey\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 18: { /* PNP_GetClassCount */
		struct PNP_GetClassCount *r2 = (struct PNP_GetClassCount *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetClassCount replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetClassCount, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_GetClassCount\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 19: { /* PNP_GetClassName */
		struct PNP_GetClassName *r2 = (struct PNP_GetClassName *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetClassName replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetClassName, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_GetClassName\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 20: { /* PNP_DeleteClassKey */
		struct PNP_DeleteClassKey *r2 = (struct PNP_DeleteClassKey *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_DeleteClassKey replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_DeleteClassKey, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_DeleteClassKey\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 21: { /* PNP_GetInterfaceDeviceAlias */
		struct PNP_GetInterfaceDeviceAlias *r2 = (struct PNP_GetInterfaceDeviceAlias *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetInterfaceDeviceAlias replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetInterfaceDeviceAlias, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_GetInterfaceDeviceAlias\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 22: { /* PNP_GetInterfaceDeviceList */
		struct PNP_GetInterfaceDeviceList *r2 = (struct PNP_GetInterfaceDeviceList *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetInterfaceDeviceList replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetInterfaceDeviceList, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_GetInterfaceDeviceList\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 23: { /* PNP_GetInterfaceDeviceListSize */
		struct PNP_GetInterfaceDeviceListSize *r2 = (struct PNP_GetInterfaceDeviceListSize *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetInterfaceDeviceListSize replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetInterfaceDeviceListSize, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_GetInterfaceDeviceListSize\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 24: { /* PNP_RegisterDeviceClassAssociation */
		struct PNP_RegisterDeviceClassAssociation *r2 = (struct PNP_RegisterDeviceClassAssociation *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_RegisterDeviceClassAssociation replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_RegisterDeviceClassAssociation, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_RegisterDeviceClassAssociation\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 25: { /* PNP_UnregisterDeviceClassAssociation */
		struct PNP_UnregisterDeviceClassAssociation *r2 = (struct PNP_UnregisterDeviceClassAssociation *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_UnregisterDeviceClassAssociation replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_UnregisterDeviceClassAssociation, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_UnregisterDeviceClassAssociation\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 26: { /* PNP_GetClassRegProp */
		struct PNP_GetClassRegProp *r2 = (struct PNP_GetClassRegProp *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetClassRegProp replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetClassRegProp, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_GetClassRegProp\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 27: { /* PNP_SetClassRegProp */
		struct PNP_SetClassRegProp *r2 = (struct PNP_SetClassRegProp *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_SetClassRegProp replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_SetClassRegProp, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_SetClassRegProp\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 28: { /* PNP_CreateDevInst */
		struct PNP_CreateDevInst *r2 = (struct PNP_CreateDevInst *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_CreateDevInst replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_CreateDevInst, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_CreateDevInst\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 29: { /* PNP_DeviceInstanceAction */
		struct PNP_DeviceInstanceAction *r2 = (struct PNP_DeviceInstanceAction *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_DeviceInstanceAction replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_DeviceInstanceAction, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_DeviceInstanceAction\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 30: { /* PNP_GetDeviceStatus */
		struct PNP_GetDeviceStatus *r2 = (struct PNP_GetDeviceStatus *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetDeviceStatus replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetDeviceStatus, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_GetDeviceStatus\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 31: { /* PNP_SetDeviceProblem */
		struct PNP_SetDeviceProblem *r2 = (struct PNP_SetDeviceProblem *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_SetDeviceProblem replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_SetDeviceProblem, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_SetDeviceProblem\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 32: { /* PNP_DisableDevInst */
		struct PNP_DisableDevInst *r2 = (struct PNP_DisableDevInst *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_DisableDevInst replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_DisableDevInst, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_DisableDevInst\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 33: { /* PNP_UninstallDevInst */
		struct PNP_UninstallDevInst *r2 = (struct PNP_UninstallDevInst *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_UninstallDevInst replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_UninstallDevInst, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_UninstallDevInst\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 34: { /* PNP_AddID */
		struct PNP_AddID *r2 = (struct PNP_AddID *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_AddID replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_AddID, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_AddID\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 35: { /* PNP_RegisterDriver */
		struct PNP_RegisterDriver *r2 = (struct PNP_RegisterDriver *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_RegisterDriver replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_RegisterDriver, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_RegisterDriver\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 36: { /* PNP_QueryRemove */
		struct PNP_QueryRemove *r2 = (struct PNP_QueryRemove *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_QueryRemove replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_QueryRemove, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_QueryRemove\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 37: { /* PNP_RequestDeviceEject */
		struct PNP_RequestDeviceEject *r2 = (struct PNP_RequestDeviceEject *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_RequestDeviceEject replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_RequestDeviceEject, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_RequestDeviceEject\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 38: { /* PNP_IsDockStationPresent */
		struct PNP_IsDockStationPresent *r2 = (struct PNP_IsDockStationPresent *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_IsDockStationPresent replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_IsDockStationPresent, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_IsDockStationPresent\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 39: { /* PNP_RequestEjectPC */
		struct PNP_RequestEjectPC *r2 = (struct PNP_RequestEjectPC *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_RequestEjectPC replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_RequestEjectPC, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_RequestEjectPC\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 40: { /* PNP_HwProfFlags */
		struct PNP_HwProfFlags *r2 = (struct PNP_HwProfFlags *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_HwProfFlags replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_HwProfFlags, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_HwProfFlags\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 41: { /* PNP_GetHwProfInfo */
		struct PNP_GetHwProfInfo *r2 = (struct PNP_GetHwProfInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetHwProfInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetHwProfInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_GetHwProfInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 42: { /* PNP_AddEmptyLogConf */
		struct PNP_AddEmptyLogConf *r2 = (struct PNP_AddEmptyLogConf *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_AddEmptyLogConf replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_AddEmptyLogConf, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_AddEmptyLogConf\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 43: { /* PNP_FreeLogConf */
		struct PNP_FreeLogConf *r2 = (struct PNP_FreeLogConf *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_FreeLogConf replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_FreeLogConf, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_FreeLogConf\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 44: { /* PNP_GetFirstLogConf */
		struct PNP_GetFirstLogConf *r2 = (struct PNP_GetFirstLogConf *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetFirstLogConf replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetFirstLogConf, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_GetFirstLogConf\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 45: { /* PNP_GetNextLogConf */
		struct PNP_GetNextLogConf *r2 = (struct PNP_GetNextLogConf *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetNextLogConf replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetNextLogConf, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_GetNextLogConf\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 46: { /* PNP_GetLogConfPriority */
		struct PNP_GetLogConfPriority *r2 = (struct PNP_GetLogConfPriority *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetLogConfPriority replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetLogConfPriority, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_GetLogConfPriority\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 47: { /* PNP_AddResDes */
		struct PNP_AddResDes *r2 = (struct PNP_AddResDes *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_AddResDes replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_AddResDes, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_AddResDes\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 48: { /* PNP_FreeResDes */
		struct PNP_FreeResDes *r2 = (struct PNP_FreeResDes *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_FreeResDes replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_FreeResDes, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_FreeResDes\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 49: { /* PNP_GetNextResDes */
		struct PNP_GetNextResDes *r2 = (struct PNP_GetNextResDes *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetNextResDes replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetNextResDes, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_GetNextResDes\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 50: { /* PNP_GetResDesData */
		struct PNP_GetResDesData *r2 = (struct PNP_GetResDesData *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetResDesData replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetResDesData, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_GetResDesData\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 51: { /* PNP_GetResDesDataSize */
		struct PNP_GetResDesDataSize *r2 = (struct PNP_GetResDesDataSize *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetResDesDataSize replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetResDesDataSize, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_GetResDesDataSize\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 52: { /* PNP_ModifyResDes */
		struct PNP_ModifyResDes *r2 = (struct PNP_ModifyResDes *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_ModifyResDes replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_ModifyResDes, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_ModifyResDes\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 53: { /* PNP_DetectResourceLimit */
		struct PNP_DetectResourceLimit *r2 = (struct PNP_DetectResourceLimit *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_DetectResourceLimit replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_DetectResourceLimit, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_DetectResourceLimit\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 54: { /* PNP_QueryResConfList */
		struct PNP_QueryResConfList *r2 = (struct PNP_QueryResConfList *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_QueryResConfList replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_QueryResConfList, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_QueryResConfList\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 55: { /* PNP_SetHwProf */
		struct PNP_SetHwProf *r2 = (struct PNP_SetHwProf *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_SetHwProf replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_SetHwProf, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_SetHwProf\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 56: { /* PNP_QueryArbitratorFreeData */
		struct PNP_QueryArbitratorFreeData *r2 = (struct PNP_QueryArbitratorFreeData *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_QueryArbitratorFreeData replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_QueryArbitratorFreeData, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_QueryArbitratorFreeData\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 57: { /* PNP_QueryArbitratorFreeSize */
		struct PNP_QueryArbitratorFreeSize *r2 = (struct PNP_QueryArbitratorFreeSize *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_QueryArbitratorFreeSize replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_QueryArbitratorFreeSize, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_QueryArbitratorFreeSize\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 58: { /* PNP_RunDetection */
		struct PNP_RunDetection *r2 = (struct PNP_RunDetection *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_RunDetection replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_RunDetection, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_RunDetection\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 59: { /* PNP_RegisterNotification */
		struct PNP_RegisterNotification *r2 = (struct PNP_RegisterNotification *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_RegisterNotification replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_RegisterNotification, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_RegisterNotification\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 60: { /* PNP_UnregisterNotification */
		struct PNP_UnregisterNotification *r2 = (struct PNP_UnregisterNotification *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_UnregisterNotification replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_UnregisterNotification, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_UnregisterNotification\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 61: { /* PNP_GetCustomDevProp */
		struct PNP_GetCustomDevProp *r2 = (struct PNP_GetCustomDevProp *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetCustomDevProp replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetCustomDevProp, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_GetCustomDevProp\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 62: { /* PNP_GetVersionInternal */
		struct PNP_GetVersionInternal *r2 = (struct PNP_GetVersionInternal *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetVersionInternal replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetVersionInternal, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_GetVersionInternal\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 63: { /* PNP_GetBlockedDriverInfo */
		struct PNP_GetBlockedDriverInfo *r2 = (struct PNP_GetBlockedDriverInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetBlockedDriverInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetBlockedDriverInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_GetBlockedDriverInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 64: { /* PNP_GetServerSideDeviceInstallFlags */
		struct PNP_GetServerSideDeviceInstallFlags *r2 = (struct PNP_GetServerSideDeviceInstallFlags *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetServerSideDeviceInstallFlags replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetServerSideDeviceInstallFlags, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in PNP_GetServerSideDeviceInstallFlags\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

NTSTATUS ntsvcs__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	ndr_err = ndr_table_ntsvcs.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

NTSTATUS ntsvcs__op_local(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	return ntsvcs__op_dispatch_internal(dce_call, mem_ctx, r, S3COMPAT_RPC_DISPATCH_INTERNAL);
}

static const struct dcesrv_interface dcesrv_ntsvcs_interface = {
	.name      = "ntsvcs",
	.syntax_id = {{0x8d9f4e40,0xa03d,0x11ce,{0x8f,0x69},{0x08,0x00,0x3e,0x30,0x05,0x1b}},1.0},
	.bind      = ntsvcs__op_bind,
	.unbind    = ntsvcs__op_unbind,
	.ndr_pull  = ntsvcs__op_ndr_pull,
	.dispatch  = ntsvcs__op_dispatch,
	.reply     = ntsvcs__op_reply,
	.ndr_push  = ntsvcs__op_ndr_push,
	.local     = ntsvcs__op_local,
#ifdef DCESRV_INTERFACE_NTSVCS_FLAGS
	.flags     = DCESRV_INTERFACE_NTSVCS_FLAGS
#else
	.flags     = 0
#endif
};

static NTSTATUS ntsvcs__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	uint32_t i;
	NTSTATUS ret;

#ifdef DCESRV_INTERFACE_NTSVCS_NCACN_NP_SECONDARY_ENDPOINT
	const char *ncacn_np_secondary_endpoint = DCESRV_INTERFACE_NTSVCS_NCACN_NP_SECONDARY_ENDPOINT;
#else
	const char *ncacn_np_secondary_endpoint = NULL;
#endif

	for (i=0;i<ndr_table_ntsvcs.endpoints->count;i++) {
		const char *name = ndr_table_ntsvcs.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, ncacn_np_secondary_endpoint, &dcesrv_ntsvcs_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DBG_ERR("Failed to register endpoint '%s'\n",name);
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static NTSTATUS ntsvcs__op_shutdown_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	return NT_STATUS_OK;
}

static bool ntsvcs__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_ntsvcs_interface.syntax_id.if_version == if_version && GUID_equal(&dcesrv_ntsvcs_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_ntsvcs_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static bool ntsvcs__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_ntsvcs_interface.name, name)==0) {
		memcpy(iface, &dcesrv_ntsvcs_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static const struct dcesrv_endpoint_server ntsvcs_ep_server = {
	/* fill in our name */
	.name = "ntsvcs",

	/* Initialization flag */
	.initialized = false,

	/* fill in all the operations */
#ifdef DCESRV_INTERFACE_NTSVCS_INIT_SERVER
	.init_server = DCESRV_INTERFACE_NTSVCS_INIT_SERVER,
#else
	.init_server = ntsvcs__op_init_server,
#endif
#ifdef DCESRV_INTERFACE_NTSVCS_SHUTDOWN_SERVER
	.shutdown_server = DCESRV_INTERFACE_NTSVCS_SHUTDOWN_SERVER,
#else
	.shutdown_server = ntsvcs__op_shutdown_server,
#endif
	.interface_by_uuid = ntsvcs__op_interface_by_uuid,
	.interface_by_name = ntsvcs__op_interface_by_name
};

const struct dcesrv_endpoint_server *ntsvcs_get_ep_server(void)
{
	return &ntsvcs_ep_server;
}
