
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/librpc/gen_ndr/ndr_winbind.h"
#include "bin/default/librpc/gen_ndr/ndr_winbind_c.h"

/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

#include "librpc/gen_ndr/lsa.h"
#include "librpc/gen_ndr/netlogon.h"
#include "librpc/gen_ndr/samr.h"
#include "librpc/gen_ndr/misc.h"
#include "librpc/gen_ndr/security.h"
#include "librpc/gen_ndr/idmap.h"
static PyTypeObject wbint_TransID_Type;
static PyTypeObject wbint_TransIDArray_Type;
static PyTypeObject wbint_userinfo_Type;
static PyTypeObject wbint_SidArray_Type;
static PyTypeObject wbint_RidArray_Type;
static PyTypeObject wbint_Principal_Type;
static PyTypeObject wbint_Principals_Type;
static PyTypeObject wbint_userinfos_Type;
static PyTypeObject wbint_Validation_Type;
static PyTypeObject wbint_AuthUserInfo_Type;
static PyTypeObject wbint_PamAuthCrapValidation_Type;
static PyTypeObject winbind_InterfaceType;
static PyTypeObject wbint_Ping_Type;
static PyTypeObject wbint_LookupSid_Type;
static PyTypeObject wbint_LookupSids_Type;
static PyTypeObject wbint_LookupName_Type;
static PyTypeObject wbint_Sids2UnixIDs_Type;
static PyTypeObject wbint_UnixIDs2Sids_Type;
static PyTypeObject wbint_AllocateUid_Type;
static PyTypeObject wbint_AllocateGid_Type;
static PyTypeObject wbint_GetNssInfo_Type;
static PyTypeObject wbint_LookupUserAliases_Type;
static PyTypeObject wbint_LookupUserGroups_Type;
static PyTypeObject wbint_QuerySequenceNumber_Type;
static PyTypeObject wbint_LookupGroupMembers_Type;
static PyTypeObject wbint_LookupAliasMembers_Type;
static PyTypeObject wbint_QueryGroupList_Type;
static PyTypeObject wbint_QueryUserRidList_Type;
static PyTypeObject wbint_DsGetDcName_Type;
static PyTypeObject wbint_LookupRids_Type;
static PyTypeObject wbint_CheckMachineAccount_Type;
static PyTypeObject wbint_ChangeMachineAccount_Type;
static PyTypeObject wbint_PingDc_Type;
static PyTypeObject wbint_ListTrustedDomains_Type;
static PyTypeObject wbint_PamAuth_Type;
static PyTypeObject wbint_PamAuthCrap_Type;
static PyTypeObject wbint_PamLogOff_Type;
static PyTypeObject wbint_PamAuthCrapChangePassword_Type;
static PyTypeObject wbint_PamAuthChangePassword_Type;
static PyTypeObject wbint_InitConnection_Type;
static PyTypeObject wbint_NormalizeNameMap_Type;
static PyTypeObject wbint_NormalizeNameUnmap_Type;
static PyTypeObject winbind_SamLogon_Type;
static PyTypeObject winbind_DsrUpdateReadOnlyServerDnsRecords_Type;
static PyTypeObject winbind_LogonControl_Type;
static PyTypeObject winbind_GetForestTrustInformation_Type;
static PyTypeObject winbind_SendToSam_Type;

static PyTypeObject *unixid_Type;
static PyTypeObject *BaseObject_Type;
static PyTypeObject *dom_sid_Type;
static PyTypeObject *netr_Validation_Type;
static PyTypeObject *lsa_SidArray_Type;
static PyTypeObject *lsa_RefDomainList_Type;
static PyTypeObject *lsa_TransNameArray_Type;
static PyTypeObject *GUID_Type;
static PyTypeObject *netr_DsRGetDCNameInfo_Type;
static PyTypeObject *netr_DomainTrustList_Type;
static PyTypeObject *samr_DomInfo1_Type;
static PyTypeObject *netr_LogonLevel_Type;
static PyTypeObject *NL_DNS_NAME_INFO_ARRAY_Type;
static PyTypeObject *netr_CONTROL_DATA_INFORMATION_Type;
static PyTypeObject *netr_CONTROL_QUERY_INFORMATION_Type;
static PyTypeObject *lsa_ForestTrustInformation_Type;
static PyTypeObject *netr_SendToSamBase_Type;
static PyTypeObject *ClientConnection_Type;
static PyTypeObject *ndr_syntax_id_Type;

static PyObject *py_wbint_TransID_get_type_hint(PyObject *obj, void *closure)
{
	struct wbint_TransID *object = pytalloc_get_ptr(obj);
	PyObject *py_type_hint;
	py_type_hint = PyLong_FromLong((uint16_t)(object->type_hint));
	return py_type_hint;
}

static int py_wbint_TransID_set_type_hint(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_TransID *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->type_hint");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->type_hint));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->type_hint = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wbint_TransID_get_domain_index(PyObject *obj, void *closure)
{
	struct wbint_TransID *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_index;
	py_domain_index = PyLong_FromUnsignedLongLong((uint32_t)(object->domain_index));
	return py_domain_index;
}

static int py_wbint_TransID_set_domain_index(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_TransID *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->domain_index");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->domain_index));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->domain_index = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wbint_TransID_get_rid(PyObject *obj, void *closure)
{
	struct wbint_TransID *object = pytalloc_get_ptr(obj);
	PyObject *py_rid;
	py_rid = PyLong_FromUnsignedLongLong((uint32_t)(object->rid));
	return py_rid;
}

static int py_wbint_TransID_set_rid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_TransID *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->rid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->rid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->rid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wbint_TransID_get_xid(PyObject *obj, void *closure)
{
	struct wbint_TransID *object = pytalloc_get_ptr(obj);
	PyObject *py_xid;
	py_xid = pytalloc_reference_ex(unixid_Type, pytalloc_get_mem_ctx(obj), &object->xid);
	return py_xid;
}

static int py_wbint_TransID_set_xid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_TransID *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->xid");
		return -1;
	}
	PY_CHECK_TYPE(unixid_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->xid = *(struct unixid *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_wbint_TransID_getsetters[] = {
	{
		.name = discard_const_p(char, "type_hint"),
		.get = py_wbint_TransID_get_type_hint,
		.set = py_wbint_TransID_set_type_hint,
		.doc = discard_const_p(char, "PIDL-generated element of base type id_type")
	},
	{
		.name = discard_const_p(char, "domain_index"),
		.get = py_wbint_TransID_get_domain_index,
		.set = py_wbint_TransID_set_domain_index,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "rid"),
		.get = py_wbint_TransID_get_rid,
		.set = py_wbint_TransID_set_rid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "xid"),
		.get = py_wbint_TransID_get_xid,
		.set = py_wbint_TransID_set_xid,
		.doc = discard_const_p(char, "PIDL-generated element of base type unixid")
	},
	{ .name = NULL }
};

static PyObject *py_wbint_TransID_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wbint_TransID, type);
}


static PyTypeObject wbint_TransID_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.wbint_TransID",
	.tp_getset = py_wbint_TransID_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wbint_TransID_new,
};


static PyObject *py_wbint_TransIDArray_get_num_ids(PyObject *obj, void *closure)
{
	struct wbint_TransIDArray *object = pytalloc_get_ptr(obj);
	PyObject *py_num_ids;
	py_num_ids = PyLong_FromUnsignedLongLong((uint32_t)(object->num_ids));
	return py_num_ids;
}

static int py_wbint_TransIDArray_set_num_ids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_TransIDArray *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_ids");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_ids));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_ids = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wbint_TransIDArray_get_ids(PyObject *obj, void *closure)
{
	struct wbint_TransIDArray *object = pytalloc_get_ptr(obj);
	PyObject *py_ids;
	py_ids = PyList_New(object->num_ids);
	if (py_ids == NULL) {
		return NULL;
	}
	{
		int ids_cntr_0;
		for (ids_cntr_0 = 0; ids_cntr_0 < (object->num_ids); ids_cntr_0++) {
			PyObject *py_ids_0;
			py_ids_0 = pytalloc_reference_ex(&wbint_TransID_Type, object->ids, &(object->ids)[ids_cntr_0]);
			PyList_SetItem(py_ids, ids_cntr_0, py_ids_0);
		}
	}
	return py_ids;
}

static int py_wbint_TransIDArray_set_ids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_TransIDArray *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ids");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int ids_cntr_0;
		object->ids = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->ids, PyList_GET_SIZE(value));
		if (!object->ids) { return -1; }
		talloc_set_name_const(object->ids, "ARRAY: object->ids");
		for (ids_cntr_0 = 0; ids_cntr_0 < PyList_GET_SIZE(value); ids_cntr_0++) {
			if (PyList_GET_ITEM(value, ids_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->ids)[ids_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&wbint_TransID_Type, PyList_GET_ITEM(value, ids_cntr_0), return -1;);
			if (talloc_reference(object->ids, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, ids_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->ids)[ids_cntr_0] = *(struct wbint_TransID *)pytalloc_get_ptr(PyList_GET_ITEM(value, ids_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_wbint_TransIDArray_getsetters[] = {
	{
		.name = discard_const_p(char, "num_ids"),
		.get = py_wbint_TransIDArray_get_num_ids,
		.set = py_wbint_TransIDArray_set_num_ids,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "ids"),
		.get = py_wbint_TransIDArray_get_ids,
		.set = py_wbint_TransIDArray_set_ids,
		.doc = discard_const_p(char, "PIDL-generated element of base type wbint_TransID")
	},
	{ .name = NULL }
};

static PyObject *py_wbint_TransIDArray_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wbint_TransIDArray, type);
}


static PyTypeObject wbint_TransIDArray_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.wbint_TransIDArray",
	.tp_getset = py_wbint_TransIDArray_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wbint_TransIDArray_new,
};


static PyObject *py_wbint_userinfo_get_domain_name(PyObject *obj, void *closure)
{
	struct wbint_userinfo *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	if (object->domain_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->domain_name == NULL) {
		py_domain_name = Py_None;
		Py_INCREF(py_domain_name);
	} else {
		if (object->domain_name == NULL) {
			py_domain_name = Py_None;
			Py_INCREF(py_domain_name);
		} else {
			py_domain_name = PyUnicode_Decode(object->domain_name, strlen(object->domain_name), "utf-8", "ignore");
		}
	}
	return py_domain_name;
}

static int py_wbint_userinfo_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_userinfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->domain_name");
		return -1;
	}
	if (value == Py_None) {
		object->domain_name = NULL;
	} else {
		object->domain_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->domain_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wbint_userinfo_get_acct_name(PyObject *obj, void *closure)
{
	struct wbint_userinfo *object = pytalloc_get_ptr(obj);
	PyObject *py_acct_name;
	if (object->acct_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->acct_name == NULL) {
		py_acct_name = Py_None;
		Py_INCREF(py_acct_name);
	} else {
		if (object->acct_name == NULL) {
			py_acct_name = Py_None;
			Py_INCREF(py_acct_name);
		} else {
			py_acct_name = PyUnicode_Decode(object->acct_name, strlen(object->acct_name), "utf-8", "ignore");
		}
	}
	return py_acct_name;
}

static int py_wbint_userinfo_set_acct_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_userinfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->acct_name");
		return -1;
	}
	if (value == Py_None) {
		object->acct_name = NULL;
	} else {
		object->acct_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->acct_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wbint_userinfo_get_full_name(PyObject *obj, void *closure)
{
	struct wbint_userinfo *object = pytalloc_get_ptr(obj);
	PyObject *py_full_name;
	if (object->full_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->full_name == NULL) {
		py_full_name = Py_None;
		Py_INCREF(py_full_name);
	} else {
		if (object->full_name == NULL) {
			py_full_name = Py_None;
			Py_INCREF(py_full_name);
		} else {
			py_full_name = PyUnicode_Decode(object->full_name, strlen(object->full_name), "utf-8", "ignore");
		}
	}
	return py_full_name;
}

static int py_wbint_userinfo_set_full_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_userinfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->full_name");
		return -1;
	}
	if (value == Py_None) {
		object->full_name = NULL;
	} else {
		object->full_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->full_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wbint_userinfo_get_homedir(PyObject *obj, void *closure)
{
	struct wbint_userinfo *object = pytalloc_get_ptr(obj);
	PyObject *py_homedir;
	if (object->homedir == NULL) {
		Py_RETURN_NONE;
	}
	if (object->homedir == NULL) {
		py_homedir = Py_None;
		Py_INCREF(py_homedir);
	} else {
		if (object->homedir == NULL) {
			py_homedir = Py_None;
			Py_INCREF(py_homedir);
		} else {
			py_homedir = PyUnicode_Decode(object->homedir, strlen(object->homedir), "utf-8", "ignore");
		}
	}
	return py_homedir;
}

static int py_wbint_userinfo_set_homedir(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_userinfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->homedir");
		return -1;
	}
	if (value == Py_None) {
		object->homedir = NULL;
	} else {
		object->homedir = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->homedir = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wbint_userinfo_get_shell(PyObject *obj, void *closure)
{
	struct wbint_userinfo *object = pytalloc_get_ptr(obj);
	PyObject *py_shell;
	if (object->shell == NULL) {
		Py_RETURN_NONE;
	}
	if (object->shell == NULL) {
		py_shell = Py_None;
		Py_INCREF(py_shell);
	} else {
		if (object->shell == NULL) {
			py_shell = Py_None;
			Py_INCREF(py_shell);
		} else {
			py_shell = PyUnicode_Decode(object->shell, strlen(object->shell), "utf-8", "ignore");
		}
	}
	return py_shell;
}

static int py_wbint_userinfo_set_shell(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_userinfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->shell");
		return -1;
	}
	if (value == Py_None) {
		object->shell = NULL;
	} else {
		object->shell = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->shell = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wbint_userinfo_get_uid(PyObject *obj, void *closure)
{
	struct wbint_userinfo *object = pytalloc_get_ptr(obj);
	PyObject *py_uid;
	py_uid = PyLong_FromUnsignedLongLong(object->uid);
	return py_uid;
}

static int py_wbint_userinfo_set_uid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_userinfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->uid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->uid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->uid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wbint_userinfo_get_primary_gid(PyObject *obj, void *closure)
{
	struct wbint_userinfo *object = pytalloc_get_ptr(obj);
	PyObject *py_primary_gid;
	py_primary_gid = PyLong_FromUnsignedLongLong(object->primary_gid);
	return py_primary_gid;
}

static int py_wbint_userinfo_set_primary_gid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_userinfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->primary_gid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->primary_gid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->primary_gid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wbint_userinfo_get_primary_group_name(PyObject *obj, void *closure)
{
	struct wbint_userinfo *object = pytalloc_get_ptr(obj);
	PyObject *py_primary_group_name;
	if (object->primary_group_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->primary_group_name == NULL) {
		py_primary_group_name = Py_None;
		Py_INCREF(py_primary_group_name);
	} else {
		if (object->primary_group_name == NULL) {
			py_primary_group_name = Py_None;
			Py_INCREF(py_primary_group_name);
		} else {
			py_primary_group_name = PyUnicode_Decode(object->primary_group_name, strlen(object->primary_group_name), "utf-8", "ignore");
		}
	}
	return py_primary_group_name;
}

static int py_wbint_userinfo_set_primary_group_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_userinfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->primary_group_name");
		return -1;
	}
	if (value == Py_None) {
		object->primary_group_name = NULL;
	} else {
		object->primary_group_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->primary_group_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wbint_userinfo_get_user_sid(PyObject *obj, void *closure)
{
	struct wbint_userinfo *object = pytalloc_get_ptr(obj);
	PyObject *py_user_sid;
	py_user_sid = pytalloc_reference_ex(dom_sid_Type, pytalloc_get_mem_ctx(obj), &object->user_sid);
	return py_user_sid;
}

static int py_wbint_userinfo_set_user_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_userinfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->user_sid");
		return -1;
	}
	PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->user_sid = *(struct dom_sid *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_wbint_userinfo_get_group_sid(PyObject *obj, void *closure)
{
	struct wbint_userinfo *object = pytalloc_get_ptr(obj);
	PyObject *py_group_sid;
	py_group_sid = pytalloc_reference_ex(dom_sid_Type, pytalloc_get_mem_ctx(obj), &object->group_sid);
	return py_group_sid;
}

static int py_wbint_userinfo_set_group_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_userinfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->group_sid");
		return -1;
	}
	PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->group_sid = *(struct dom_sid *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_wbint_userinfo_getsetters[] = {
	{
		.name = discard_const_p(char, "domain_name"),
		.get = py_wbint_userinfo_get_domain_name,
		.set = py_wbint_userinfo_set_domain_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "acct_name"),
		.get = py_wbint_userinfo_get_acct_name,
		.set = py_wbint_userinfo_set_acct_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "full_name"),
		.get = py_wbint_userinfo_get_full_name,
		.set = py_wbint_userinfo_set_full_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "homedir"),
		.get = py_wbint_userinfo_get_homedir,
		.set = py_wbint_userinfo_set_homedir,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "shell"),
		.get = py_wbint_userinfo_get_shell,
		.set = py_wbint_userinfo_set_shell,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "uid"),
		.get = py_wbint_userinfo_get_uid,
		.set = py_wbint_userinfo_set_uid,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "primary_gid"),
		.get = py_wbint_userinfo_get_primary_gid,
		.set = py_wbint_userinfo_set_primary_gid,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "primary_group_name"),
		.get = py_wbint_userinfo_get_primary_group_name,
		.set = py_wbint_userinfo_set_primary_group_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "user_sid"),
		.get = py_wbint_userinfo_get_user_sid,
		.set = py_wbint_userinfo_set_user_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid")
	},
	{
		.name = discard_const_p(char, "group_sid"),
		.get = py_wbint_userinfo_get_group_sid,
		.set = py_wbint_userinfo_set_group_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid")
	},
	{ .name = NULL }
};

static PyObject *py_wbint_userinfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wbint_userinfo, type);
}

static PyObject *py_wbint_userinfo_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct wbint_userinfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_wbint_userinfo);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_wbint_userinfo_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct wbint_userinfo *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_wbint_userinfo);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_wbint_userinfo);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_wbint_userinfo_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct wbint_userinfo *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_wbint_userinfo, "wbint_userinfo", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_wbint_userinfo, "wbint_userinfo", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_wbint_userinfo_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_wbint_userinfo_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_userinfo_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_userinfo_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wbint_userinfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.wbint_userinfo",
	.tp_getset = py_wbint_userinfo_getsetters,
	.tp_methods = py_wbint_userinfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wbint_userinfo_new,
};


static PyObject *py_wbint_SidArray_get_num_sids(PyObject *obj, void *closure)
{
	struct wbint_SidArray *object = pytalloc_get_ptr(obj);
	PyObject *py_num_sids;
	py_num_sids = PyLong_FromUnsignedLongLong((uint32_t)(object->num_sids));
	return py_num_sids;
}

static int py_wbint_SidArray_set_num_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_SidArray *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_sids");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_sids));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_sids = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wbint_SidArray_get_sids(PyObject *obj, void *closure)
{
	struct wbint_SidArray *object = pytalloc_get_ptr(obj);
	PyObject *py_sids;
	py_sids = PyList_New(object->num_sids);
	if (py_sids == NULL) {
		return NULL;
	}
	{
		int sids_cntr_0;
		for (sids_cntr_0 = 0; sids_cntr_0 < (object->num_sids); sids_cntr_0++) {
			PyObject *py_sids_0;
			py_sids_0 = pytalloc_reference_ex(dom_sid_Type, object->sids, &(object->sids)[sids_cntr_0]);
			PyList_SetItem(py_sids, sids_cntr_0, py_sids_0);
		}
	}
	return py_sids;
}

static int py_wbint_SidArray_set_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_SidArray *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sids");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int sids_cntr_0;
		object->sids = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->sids, PyList_GET_SIZE(value));
		if (!object->sids) { return -1; }
		talloc_set_name_const(object->sids, "ARRAY: object->sids");
		for (sids_cntr_0 = 0; sids_cntr_0 < PyList_GET_SIZE(value); sids_cntr_0++) {
			if (PyList_GET_ITEM(value, sids_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->sids)[sids_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(dom_sid_Type, PyList_GET_ITEM(value, sids_cntr_0), return -1;);
			if (talloc_reference(object->sids, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, sids_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->sids)[sids_cntr_0] = *(struct dom_sid *)pytalloc_get_ptr(PyList_GET_ITEM(value, sids_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_wbint_SidArray_getsetters[] = {
	{
		.name = discard_const_p(char, "num_sids"),
		.get = py_wbint_SidArray_get_num_sids,
		.set = py_wbint_SidArray_set_num_sids,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sids"),
		.get = py_wbint_SidArray_get_sids,
		.set = py_wbint_SidArray_set_sids,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid")
	},
	{ .name = NULL }
};

static PyObject *py_wbint_SidArray_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wbint_SidArray, type);
}

static PyObject *py_wbint_SidArray_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct wbint_SidArray *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_wbint_SidArray);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_wbint_SidArray_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct wbint_SidArray *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_wbint_SidArray);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_wbint_SidArray);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_wbint_SidArray_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct wbint_SidArray *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_wbint_SidArray, "wbint_SidArray", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_wbint_SidArray, "wbint_SidArray", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_wbint_SidArray_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_wbint_SidArray_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_SidArray_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_SidArray_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wbint_SidArray_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.wbint_SidArray",
	.tp_getset = py_wbint_SidArray_getsetters,
	.tp_methods = py_wbint_SidArray_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wbint_SidArray_new,
};


static PyObject *py_wbint_RidArray_get_num_rids(PyObject *obj, void *closure)
{
	struct wbint_RidArray *object = pytalloc_get_ptr(obj);
	PyObject *py_num_rids;
	py_num_rids = PyLong_FromUnsignedLongLong((uint32_t)(object->num_rids));
	return py_num_rids;
}

static int py_wbint_RidArray_set_num_rids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_RidArray *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_rids");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_rids));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_rids = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wbint_RidArray_get_rids(PyObject *obj, void *closure)
{
	struct wbint_RidArray *object = pytalloc_get_ptr(obj);
	PyObject *py_rids;
	py_rids = PyList_New(object->num_rids);
	if (py_rids == NULL) {
		return NULL;
	}
	{
		int rids_cntr_0;
		for (rids_cntr_0 = 0; rids_cntr_0 < (object->num_rids); rids_cntr_0++) {
			PyObject *py_rids_0;
			py_rids_0 = PyLong_FromUnsignedLongLong((uint32_t)((object->rids)[rids_cntr_0]));
			PyList_SetItem(py_rids, rids_cntr_0, py_rids_0);
		}
	}
	return py_rids;
}

static int py_wbint_RidArray_set_rids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_RidArray *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->rids");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int rids_cntr_0;
		object->rids = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->rids, PyList_GET_SIZE(value));
		if (!object->rids) { return -1; }
		talloc_set_name_const(object->rids, "ARRAY: object->rids");
		for (rids_cntr_0 = 0; rids_cntr_0 < PyList_GET_SIZE(value); rids_cntr_0++) {
			if (PyList_GET_ITEM(value, rids_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->rids)[rids_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->rids)[rids_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, rids_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, rids_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->rids)[rids_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_wbint_RidArray_getsetters[] = {
	{
		.name = discard_const_p(char, "num_rids"),
		.get = py_wbint_RidArray_get_num_rids,
		.set = py_wbint_RidArray_set_num_rids,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "rids"),
		.get = py_wbint_RidArray_get_rids,
		.set = py_wbint_RidArray_set_rids,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_wbint_RidArray_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wbint_RidArray, type);
}

static PyObject *py_wbint_RidArray_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct wbint_RidArray *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_wbint_RidArray);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_wbint_RidArray_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct wbint_RidArray *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_wbint_RidArray);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_wbint_RidArray);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_wbint_RidArray_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct wbint_RidArray *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_wbint_RidArray, "wbint_RidArray", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_wbint_RidArray, "wbint_RidArray", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_wbint_RidArray_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_wbint_RidArray_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_RidArray_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_RidArray_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wbint_RidArray_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.wbint_RidArray",
	.tp_getset = py_wbint_RidArray_getsetters,
	.tp_methods = py_wbint_RidArray_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wbint_RidArray_new,
};


static PyObject *py_wbint_Principal_get_sid(PyObject *obj, void *closure)
{
	struct wbint_Principal *object = pytalloc_get_ptr(obj);
	PyObject *py_sid;
	py_sid = pytalloc_reference_ex(dom_sid_Type, pytalloc_get_mem_ctx(obj), &object->sid);
	return py_sid;
}

static int py_wbint_Principal_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_Principal *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sid");
		return -1;
	}
	PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->sid = *(struct dom_sid *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_wbint_Principal_get_type(PyObject *obj, void *closure)
{
	struct wbint_Principal *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyLong_FromLong((uint16_t)(object->type));
	return py_type;
}

static int py_wbint_Principal_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_Principal *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wbint_Principal_get_name(PyObject *obj, void *closure)
{
	struct wbint_Principal *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	if (object->name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->name == NULL) {
		py_name = Py_None;
		Py_INCREF(py_name);
	} else {
		if (object->name == NULL) {
			py_name = Py_None;
			Py_INCREF(py_name);
		} else {
			py_name = PyUnicode_Decode(object->name, strlen(object->name), "utf-8", "ignore");
		}
	}
	return py_name;
}

static int py_wbint_Principal_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_Principal *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->name");
		return -1;
	}
	if (value == Py_None) {
		object->name = NULL;
	} else {
		object->name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->name = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_wbint_Principal_getsetters[] = {
	{
		.name = discard_const_p(char, "sid"),
		.get = py_wbint_Principal_get_sid,
		.set = py_wbint_Principal_set_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid")
	},
	{
		.name = discard_const_p(char, "type"),
		.get = py_wbint_Principal_get_type,
		.set = py_wbint_Principal_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_SidType")
	},
	{
		.name = discard_const_p(char, "name"),
		.get = py_wbint_Principal_get_name,
		.set = py_wbint_Principal_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_wbint_Principal_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wbint_Principal, type);
}

static PyObject *py_wbint_Principal_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct wbint_Principal *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_wbint_Principal);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_wbint_Principal_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct wbint_Principal *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_wbint_Principal);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_wbint_Principal);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_wbint_Principal_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct wbint_Principal *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_wbint_Principal, "wbint_Principal", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_wbint_Principal, "wbint_Principal", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_wbint_Principal_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_wbint_Principal_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_Principal_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_Principal_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wbint_Principal_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.wbint_Principal",
	.tp_getset = py_wbint_Principal_getsetters,
	.tp_methods = py_wbint_Principal_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wbint_Principal_new,
};


static PyObject *py_wbint_Principals_get_num_principals(PyObject *obj, void *closure)
{
	struct wbint_Principals *object = pytalloc_get_ptr(obj);
	PyObject *py_num_principals;
	py_num_principals = PyLong_FromUnsignedLongLong((uint32_t)(object->num_principals));
	return py_num_principals;
}

static int py_wbint_Principals_set_num_principals(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_Principals *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_principals");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_principals));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_principals = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wbint_Principals_get_principals(PyObject *obj, void *closure)
{
	struct wbint_Principals *object = pytalloc_get_ptr(obj);
	PyObject *py_principals;
	py_principals = PyList_New(object->num_principals);
	if (py_principals == NULL) {
		return NULL;
	}
	{
		int principals_cntr_0;
		for (principals_cntr_0 = 0; principals_cntr_0 < (object->num_principals); principals_cntr_0++) {
			PyObject *py_principals_0;
			py_principals_0 = pytalloc_reference_ex(&wbint_Principal_Type, object->principals, &(object->principals)[principals_cntr_0]);
			PyList_SetItem(py_principals, principals_cntr_0, py_principals_0);
		}
	}
	return py_principals;
}

static int py_wbint_Principals_set_principals(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_Principals *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->principals");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int principals_cntr_0;
		object->principals = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->principals, PyList_GET_SIZE(value));
		if (!object->principals) { return -1; }
		talloc_set_name_const(object->principals, "ARRAY: object->principals");
		for (principals_cntr_0 = 0; principals_cntr_0 < PyList_GET_SIZE(value); principals_cntr_0++) {
			if (PyList_GET_ITEM(value, principals_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->principals)[principals_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&wbint_Principal_Type, PyList_GET_ITEM(value, principals_cntr_0), return -1;);
			if (talloc_reference(object->principals, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, principals_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->principals)[principals_cntr_0] = *(struct wbint_Principal *)pytalloc_get_ptr(PyList_GET_ITEM(value, principals_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_wbint_Principals_getsetters[] = {
	{
		.name = discard_const_p(char, "num_principals"),
		.get = py_wbint_Principals_get_num_principals,
		.set = py_wbint_Principals_set_num_principals,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "principals"),
		.get = py_wbint_Principals_get_principals,
		.set = py_wbint_Principals_set_principals,
		.doc = discard_const_p(char, "PIDL-generated element of base type wbint_Principal")
	},
	{ .name = NULL }
};

static PyObject *py_wbint_Principals_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wbint_Principals, type);
}

static PyObject *py_wbint_Principals_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct wbint_Principals *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_wbint_Principals);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_wbint_Principals_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct wbint_Principals *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_wbint_Principals);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_wbint_Principals);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_wbint_Principals_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct wbint_Principals *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_wbint_Principals, "wbint_Principals", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_wbint_Principals, "wbint_Principals", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_wbint_Principals_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_wbint_Principals_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_Principals_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_Principals_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wbint_Principals_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.wbint_Principals",
	.tp_getset = py_wbint_Principals_getsetters,
	.tp_methods = py_wbint_Principals_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wbint_Principals_new,
};


static PyObject *py_wbint_userinfos_get_num_userinfos(PyObject *obj, void *closure)
{
	struct wbint_userinfos *object = pytalloc_get_ptr(obj);
	PyObject *py_num_userinfos;
	py_num_userinfos = PyLong_FromUnsignedLongLong((uint32_t)(object->num_userinfos));
	return py_num_userinfos;
}

static int py_wbint_userinfos_set_num_userinfos(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_userinfos *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_userinfos");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_userinfos));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_userinfos = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wbint_userinfos_get_userinfos(PyObject *obj, void *closure)
{
	struct wbint_userinfos *object = pytalloc_get_ptr(obj);
	PyObject *py_userinfos;
	py_userinfos = PyList_New(object->num_userinfos);
	if (py_userinfos == NULL) {
		return NULL;
	}
	{
		int userinfos_cntr_0;
		for (userinfos_cntr_0 = 0; userinfos_cntr_0 < (object->num_userinfos); userinfos_cntr_0++) {
			PyObject *py_userinfos_0;
			py_userinfos_0 = pytalloc_reference_ex(&wbint_userinfo_Type, object->userinfos, &(object->userinfos)[userinfos_cntr_0]);
			PyList_SetItem(py_userinfos, userinfos_cntr_0, py_userinfos_0);
		}
	}
	return py_userinfos;
}

static int py_wbint_userinfos_set_userinfos(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_userinfos *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->userinfos");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int userinfos_cntr_0;
		object->userinfos = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->userinfos, PyList_GET_SIZE(value));
		if (!object->userinfos) { return -1; }
		talloc_set_name_const(object->userinfos, "ARRAY: object->userinfos");
		for (userinfos_cntr_0 = 0; userinfos_cntr_0 < PyList_GET_SIZE(value); userinfos_cntr_0++) {
			if (PyList_GET_ITEM(value, userinfos_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->userinfos)[userinfos_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&wbint_userinfo_Type, PyList_GET_ITEM(value, userinfos_cntr_0), return -1;);
			if (talloc_reference(object->userinfos, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, userinfos_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->userinfos)[userinfos_cntr_0] = *(struct wbint_userinfo *)pytalloc_get_ptr(PyList_GET_ITEM(value, userinfos_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_wbint_userinfos_getsetters[] = {
	{
		.name = discard_const_p(char, "num_userinfos"),
		.get = py_wbint_userinfos_get_num_userinfos,
		.set = py_wbint_userinfos_set_num_userinfos,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "userinfos"),
		.get = py_wbint_userinfos_get_userinfos,
		.set = py_wbint_userinfos_set_userinfos,
		.doc = discard_const_p(char, "PIDL-generated element of base type wbint_userinfo")
	},
	{ .name = NULL }
};

static PyObject *py_wbint_userinfos_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wbint_userinfos, type);
}

static PyObject *py_wbint_userinfos_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct wbint_userinfos *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_wbint_userinfos);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_wbint_userinfos_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct wbint_userinfos *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_wbint_userinfos);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_wbint_userinfos);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_wbint_userinfos_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct wbint_userinfos *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_wbint_userinfos, "wbint_userinfos", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_wbint_userinfos, "wbint_userinfos", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_wbint_userinfos_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_wbint_userinfos_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_userinfos_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_userinfos_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wbint_userinfos_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.wbint_userinfos",
	.tp_getset = py_wbint_userinfos_getsetters,
	.tp_methods = py_wbint_userinfos_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wbint_userinfos_new,
};


static PyObject *py_wbint_Validation_get_level(PyObject *obj, void *closure)
{
	struct wbint_Validation *object = pytalloc_get_ptr(obj);
	PyObject *py_level;
	py_level = PyLong_FromLong((uint16_t)(object->level));
	return py_level;
}

static int py_wbint_Validation_set_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_Validation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wbint_Validation_get_validation(PyObject *obj, void *closure)
{
	struct wbint_Validation *object = pytalloc_get_ptr(obj);
	PyObject *py_validation;
	if (object->validation == NULL) {
		Py_RETURN_NONE;
	}
	if (object->validation == NULL) {
		py_validation = Py_None;
		Py_INCREF(py_validation);
	} else {
		py_validation = pyrpc_import_union(netr_Validation_Type, object->validation, object->level, object->validation, "union netr_Validation");
		if (py_validation == NULL) {
			return NULL;
		}
	}
	return py_validation;
}

static int py_wbint_Validation_set_validation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_Validation *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->validation));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->validation");
		return -1;
	}
	if (value == Py_None) {
		object->validation = NULL;
	} else {
		object->validation = NULL;
		{
			union netr_Validation *validation_switch_1;
			validation_switch_1 = (union netr_Validation *)pyrpc_export_union(netr_Validation_Type, pytalloc_get_mem_ctx(py_obj), object->level, value, "union netr_Validation");
			if (validation_switch_1 == NULL) {
				return -1;
			}
			object->validation = validation_switch_1;
		}
	}
	return 0;
}

static PyObject *py_wbint_Validation_get_krb5ccname(PyObject *obj, void *closure)
{
	struct wbint_Validation *object = pytalloc_get_ptr(obj);
	PyObject *py_krb5ccname;
	if (object->krb5ccname == NULL) {
		Py_RETURN_NONE;
	}
	if (object->krb5ccname == NULL) {
		py_krb5ccname = Py_None;
		Py_INCREF(py_krb5ccname);
	} else {
		if (object->krb5ccname == NULL) {
			py_krb5ccname = Py_None;
			Py_INCREF(py_krb5ccname);
		} else {
			py_krb5ccname = PyUnicode_Decode(object->krb5ccname, strlen(object->krb5ccname), "utf-8", "ignore");
		}
	}
	return py_krb5ccname;
}

static int py_wbint_Validation_set_krb5ccname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_Validation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->krb5ccname");
		return -1;
	}
	if (value == Py_None) {
		object->krb5ccname = NULL;
	} else {
		object->krb5ccname = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->krb5ccname = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_wbint_Validation_getsetters[] = {
	{
		.name = discard_const_p(char, "level"),
		.get = py_wbint_Validation_get_level,
		.set = py_wbint_Validation_set_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "validation"),
		.get = py_wbint_Validation_get_validation,
		.set = py_wbint_Validation_set_validation,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_Validation")
	},
	{
		.name = discard_const_p(char, "krb5ccname"),
		.get = py_wbint_Validation_get_krb5ccname,
		.set = py_wbint_Validation_set_krb5ccname,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_wbint_Validation_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wbint_Validation, type);
}

static PyObject *py_wbint_Validation_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct wbint_Validation *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_wbint_Validation);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_wbint_Validation_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct wbint_Validation *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_wbint_Validation);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_wbint_Validation);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_wbint_Validation_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct wbint_Validation *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_wbint_Validation, "wbint_Validation", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_wbint_Validation, "wbint_Validation", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_wbint_Validation_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_wbint_Validation_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_Validation_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_Validation_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wbint_Validation_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.wbint_Validation",
	.tp_getset = py_wbint_Validation_getsetters,
	.tp_methods = py_wbint_Validation_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wbint_Validation_new,
};


static PyObject *py_wbint_AuthUserInfo_get_username(PyObject *obj, void *closure)
{
	struct wbint_AuthUserInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_username;
	if (object->username == NULL) {
		Py_RETURN_NONE;
	}
	if (object->username == NULL) {
		py_username = Py_None;
		Py_INCREF(py_username);
	} else {
		if (object->username == NULL) {
			py_username = Py_None;
			Py_INCREF(py_username);
		} else {
			py_username = PyUnicode_Decode(object->username, strlen(object->username), "utf-8", "ignore");
		}
	}
	return py_username;
}

static int py_wbint_AuthUserInfo_set_username(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_AuthUserInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->username");
		return -1;
	}
	if (value == Py_None) {
		object->username = NULL;
	} else {
		object->username = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->username = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wbint_AuthUserInfo_get_password(PyObject *obj, void *closure)
{
	struct wbint_AuthUserInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_password;
	if (object->password == NULL) {
		Py_RETURN_NONE;
	}
	if (object->password == NULL) {
		py_password = Py_None;
		Py_INCREF(py_password);
	} else {
		if (object->password == NULL) {
			py_password = Py_None;
			Py_INCREF(py_password);
		} else {
			py_password = PyUnicode_Decode(object->password, strlen(object->password), "utf-8", "ignore");
		}
	}
	return py_password;
}

static int py_wbint_AuthUserInfo_set_password(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_AuthUserInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->password");
		return -1;
	}
	if (value == Py_None) {
		object->password = NULL;
	} else {
		object->password = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->password = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wbint_AuthUserInfo_get_krb5_cc_type(PyObject *obj, void *closure)
{
	struct wbint_AuthUserInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_krb5_cc_type;
	if (object->krb5_cc_type == NULL) {
		Py_RETURN_NONE;
	}
	if (object->krb5_cc_type == NULL) {
		py_krb5_cc_type = Py_None;
		Py_INCREF(py_krb5_cc_type);
	} else {
		if (object->krb5_cc_type == NULL) {
			py_krb5_cc_type = Py_None;
			Py_INCREF(py_krb5_cc_type);
		} else {
			py_krb5_cc_type = PyUnicode_Decode(object->krb5_cc_type, strlen(object->krb5_cc_type), "utf-8", "ignore");
		}
	}
	return py_krb5_cc_type;
}

static int py_wbint_AuthUserInfo_set_krb5_cc_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_AuthUserInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->krb5_cc_type");
		return -1;
	}
	if (value == Py_None) {
		object->krb5_cc_type = NULL;
	} else {
		object->krb5_cc_type = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->krb5_cc_type = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wbint_AuthUserInfo_get_uid(PyObject *obj, void *closure)
{
	struct wbint_AuthUserInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_uid;
	py_uid = PyLong_FromUnsignedLongLong(object->uid);
	return py_uid;
}

static int py_wbint_AuthUserInfo_set_uid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_AuthUserInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->uid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->uid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->uid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_wbint_AuthUserInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "username"),
		.get = py_wbint_AuthUserInfo_get_username,
		.set = py_wbint_AuthUserInfo_set_username,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "password"),
		.get = py_wbint_AuthUserInfo_get_password,
		.set = py_wbint_AuthUserInfo_set_password,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "krb5_cc_type"),
		.get = py_wbint_AuthUserInfo_get_krb5_cc_type,
		.set = py_wbint_AuthUserInfo_set_krb5_cc_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "uid"),
		.get = py_wbint_AuthUserInfo_get_uid,
		.set = py_wbint_AuthUserInfo_set_uid,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{ .name = NULL }
};

static PyObject *py_wbint_AuthUserInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wbint_AuthUserInfo, type);
}

static PyObject *py_wbint_AuthUserInfo_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct wbint_AuthUserInfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_wbint_AuthUserInfo);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_wbint_AuthUserInfo_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct wbint_AuthUserInfo *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_wbint_AuthUserInfo);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_wbint_AuthUserInfo);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_wbint_AuthUserInfo_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct wbint_AuthUserInfo *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_wbint_AuthUserInfo, "wbint_AuthUserInfo", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_wbint_AuthUserInfo, "wbint_AuthUserInfo", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_wbint_AuthUserInfo_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_wbint_AuthUserInfo_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_AuthUserInfo_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_AuthUserInfo_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wbint_AuthUserInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.wbint_AuthUserInfo",
	.tp_getset = py_wbint_AuthUserInfo_getsetters,
	.tp_methods = py_wbint_AuthUserInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wbint_AuthUserInfo_new,
};


static PyObject *py_wbint_PamAuthCrapValidation_get_level(PyObject *obj, void *closure)
{
	struct wbint_PamAuthCrapValidation *object = pytalloc_get_ptr(obj);
	PyObject *py_level;
	py_level = PyLong_FromLong((uint16_t)(object->level));
	return py_level;
}

static int py_wbint_PamAuthCrapValidation_set_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamAuthCrapValidation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wbint_PamAuthCrapValidation_get_validation(PyObject *obj, void *closure)
{
	struct wbint_PamAuthCrapValidation *object = pytalloc_get_ptr(obj);
	PyObject *py_validation;
	if (object->validation == NULL) {
		Py_RETURN_NONE;
	}
	if (object->validation == NULL) {
		py_validation = Py_None;
		Py_INCREF(py_validation);
	} else {
		py_validation = pyrpc_import_union(netr_Validation_Type, object->validation, object->level, object->validation, "union netr_Validation");
		if (py_validation == NULL) {
			return NULL;
		}
	}
	return py_validation;
}

static int py_wbint_PamAuthCrapValidation_set_validation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamAuthCrapValidation *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->validation));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->validation");
		return -1;
	}
	if (value == Py_None) {
		object->validation = NULL;
	} else {
		object->validation = NULL;
		{
			union netr_Validation *validation_switch_1;
			validation_switch_1 = (union netr_Validation *)pyrpc_export_union(netr_Validation_Type, pytalloc_get_mem_ctx(py_obj), object->level, value, "union netr_Validation");
			if (validation_switch_1 == NULL) {
				return -1;
			}
			object->validation = validation_switch_1;
		}
	}
	return 0;
}

static PyGetSetDef py_wbint_PamAuthCrapValidation_getsetters[] = {
	{
		.name = discard_const_p(char, "level"),
		.get = py_wbint_PamAuthCrapValidation_get_level,
		.set = py_wbint_PamAuthCrapValidation_set_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "validation"),
		.get = py_wbint_PamAuthCrapValidation_get_validation,
		.set = py_wbint_PamAuthCrapValidation_set_validation,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_Validation")
	},
	{ .name = NULL }
};

static PyObject *py_wbint_PamAuthCrapValidation_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct wbint_PamAuthCrapValidation, type);
}

static PyObject *py_wbint_PamAuthCrapValidation_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct wbint_PamAuthCrapValidation *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_wbint_PamAuthCrapValidation);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_wbint_PamAuthCrapValidation_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct wbint_PamAuthCrapValidation *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_wbint_PamAuthCrapValidation);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_wbint_PamAuthCrapValidation);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_wbint_PamAuthCrapValidation_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct wbint_PamAuthCrapValidation *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_wbint_PamAuthCrapValidation, "wbint_PamAuthCrapValidation", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_wbint_PamAuthCrapValidation, "wbint_PamAuthCrapValidation", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_wbint_PamAuthCrapValidation_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_wbint_PamAuthCrapValidation_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_PamAuthCrapValidation_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_PamAuthCrapValidation_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wbint_PamAuthCrapValidation_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.wbint_PamAuthCrapValidation",
	.tp_getset = py_wbint_PamAuthCrapValidation_getsetters,
	.tp_methods = py_wbint_PamAuthCrapValidation_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wbint_PamAuthCrapValidation_new,
};



static PyObject *py_wbint_Ping_in_get_in_data(PyObject *obj, void *closure)
{
	struct wbint_Ping *object = pytalloc_get_ptr(obj);
	PyObject *py_in_data;
	py_in_data = PyLong_FromUnsignedLongLong((uint32_t)(object->in.in_data));
	return py_in_data;
}

static int py_wbint_Ping_in_set_in_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_Ping *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.in_data");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.in_data));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.in_data = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wbint_Ping_out_get_out_data(PyObject *obj, void *closure)
{
	struct wbint_Ping *object = pytalloc_get_ptr(obj);
	PyObject *py_out_data;
	if (object->out.out_data == NULL) {
		Py_RETURN_NONE;
	}
	py_out_data = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.out_data));
	return py_out_data;
}

static int py_wbint_Ping_out_set_out_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_Ping *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.out_data));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.out_data");
		return -1;
	}
	object->out.out_data = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.out_data);
	if (object->out.out_data == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.out_data));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.out_data = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wbint_Ping_get_result(PyObject *obj, void *closure)
{
	struct wbint_Ping *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_wbint_Ping_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_Ping *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wbint_Ping_getsetters[] = {
	{
		.name = discard_const_p(char, "in_in_data"),
		.get = py_wbint_Ping_in_get_in_data,
		.set = py_wbint_Ping_in_set_in_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_out_data"),
		.get = py_wbint_Ping_out_get_out_data,
		.set = py_wbint_Ping_out_set_out_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wbint_Ping_get_result,
		.set = py_wbint_Ping_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_wbint_Ping_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wbint_Ping, type);
	struct wbint_Ping *_self = (struct wbint_Ping *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.out_data = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_wbint_Ping_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(0);
}

static PyObject *py_wbint_Ping_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_Ping *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_Ping_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[0];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wbint_Ping_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_Ping_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wbint_Ping_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_Ping_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wbint_Ping_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_Ping *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_Ping_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[0];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wbint_Ping_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_Ping_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_Ping_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_Ping_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_Ping_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_Ping *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winbind.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_Ping_ndr_print");
		return NULL;
	}
	call = &ndr_table_winbind.calls[0];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wbint_Ping_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_Ping_ndr_print(py_obj, args, kwargs, "wbint_Ping_in", NDR_IN);
}

static PyObject *py_wbint_Ping_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_Ping_ndr_print(py_obj, args, kwargs, "wbint_Ping_out", NDR_OUT);
}

static PyMethodDef py_wbint_Ping_methods[] = {
	{ "opnum", (PyCFunction)py_wbint_Ping_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winbind.wbint_Ping.opnum() -> 0 (0x00) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_Ping_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_Ping_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_Ping_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_Ping_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_Ping_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_Ping_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wbint_Ping_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.wbint_Ping",
	.tp_getset = py_wbint_Ping_getsetters,
	.tp_methods = py_wbint_Ping_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wbint_Ping_new,
};

static bool pack_py_wbint_Ping_args_in(PyObject *args, PyObject *kwargs, struct wbint_Ping *r)
{
	PyObject *py_in_data;
	const char *kwnames[] = {
		"in_data", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:wbint_Ping", discard_const_p(char *, kwnames), &py_in_data)) {
		return false;
	}

	if (py_in_data == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.in_data");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.in_data));
		if (PyLong_Check(py_in_data)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_in_data);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.in_data = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_wbint_Ping_args_out(struct wbint_Ping *r, bool raise_result_exception)
{
	PyObject *py_out_data = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_out_data = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.out_data));
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_out_data);
	}
	if (result_size == 1) {
		result = py_out_data;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_wbint_LookupSid_in_get_sid(PyObject *obj, void *closure)
{
	struct wbint_LookupSid *object = pytalloc_get_ptr(obj);
	PyObject *py_sid;
	if (object->in.sid == NULL) {
		Py_RETURN_NONE;
	}
	py_sid = pytalloc_reference_ex(dom_sid_Type, object->in.sid, object->in.sid);
	return py_sid;
}

static int py_wbint_LookupSid_in_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_LookupSid *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.sid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.sid");
		return -1;
	}
	object->in.sid = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.sid);
	if (object->in.sid == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.sid = (struct dom_sid *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_wbint_LookupSid_out_get_type(PyObject *obj, void *closure)
{
	struct wbint_LookupSid *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	if (object->out.type == NULL) {
		Py_RETURN_NONE;
	}
	py_type = PyLong_FromLong((uint16_t)(*object->out.type));
	return py_type;
}

static int py_wbint_LookupSid_out_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_LookupSid *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.type));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.type");
		return -1;
	}
	object->out.type = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.type);
	if (object->out.type == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wbint_LookupSid_out_get_domain(PyObject *obj, void *closure)
{
	struct wbint_LookupSid *object = pytalloc_get_ptr(obj);
	PyObject *py_domain;
	if (object->out.domain == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.domain == NULL) {
		py_domain = Py_None;
		Py_INCREF(py_domain);
	} else {
		if (*object->out.domain == NULL) {
			py_domain = Py_None;
			Py_INCREF(py_domain);
		} else {
			py_domain = PyUnicode_Decode(*object->out.domain, strlen(*object->out.domain), "utf-8", "ignore");
		}
	}
	return py_domain;
}

static int py_wbint_LookupSid_out_set_domain(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_LookupSid *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.domain));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.domain");
		return -1;
	}
	object->out.domain = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.domain);
	if (object->out.domain == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.domain = NULL;
	} else {
		*object->out.domain = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			*object->out.domain = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wbint_LookupSid_out_get_name(PyObject *obj, void *closure)
{
	struct wbint_LookupSid *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	if (object->out.name == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.name == NULL) {
		py_name = Py_None;
		Py_INCREF(py_name);
	} else {
		if (*object->out.name == NULL) {
			py_name = Py_None;
			Py_INCREF(py_name);
		} else {
			py_name = PyUnicode_Decode(*object->out.name, strlen(*object->out.name), "utf-8", "ignore");
		}
	}
	return py_name;
}

static int py_wbint_LookupSid_out_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_LookupSid *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.name));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.name");
		return -1;
	}
	object->out.name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.name);
	if (object->out.name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.name = NULL;
	} else {
		*object->out.name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			*object->out.name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wbint_LookupSid_get_result(PyObject *obj, void *closure)
{
	struct wbint_LookupSid *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_wbint_LookupSid_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_LookupSid *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wbint_LookupSid_getsetters[] = {
	{
		.name = discard_const_p(char, "in_sid"),
		.get = py_wbint_LookupSid_in_get_sid,
		.set = py_wbint_LookupSid_in_set_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid")
	},
	{
		.name = discard_const_p(char, "out_type"),
		.get = py_wbint_LookupSid_out_get_type,
		.set = py_wbint_LookupSid_out_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_SidType")
	},
	{
		.name = discard_const_p(char, "out_domain"),
		.get = py_wbint_LookupSid_out_get_domain,
		.set = py_wbint_LookupSid_out_set_domain,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "out_name"),
		.get = py_wbint_LookupSid_out_get_name,
		.set = py_wbint_LookupSid_out_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wbint_LookupSid_get_result,
		.set = py_wbint_LookupSid_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_wbint_LookupSid_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wbint_LookupSid, type);
	struct wbint_LookupSid *_self = (struct wbint_LookupSid *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.sid = talloc_zero(mem_ctx, struct dom_sid);
	_self->out.type = talloc_zero(mem_ctx, enum lsa_SidType);
	return self;
}

static PyObject *py_wbint_LookupSid_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(1);
}

static PyObject *py_wbint_LookupSid_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_LookupSid *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_LookupSid_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[1];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wbint_LookupSid_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_LookupSid_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wbint_LookupSid_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_LookupSid_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wbint_LookupSid_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_LookupSid *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_LookupSid_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[1];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wbint_LookupSid_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_LookupSid_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_LookupSid_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_LookupSid_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_LookupSid_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_LookupSid *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winbind.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_LookupSid_ndr_print");
		return NULL;
	}
	call = &ndr_table_winbind.calls[1];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wbint_LookupSid_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_LookupSid_ndr_print(py_obj, args, kwargs, "wbint_LookupSid_in", NDR_IN);
}

static PyObject *py_wbint_LookupSid_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_LookupSid_ndr_print(py_obj, args, kwargs, "wbint_LookupSid_out", NDR_OUT);
}

static PyMethodDef py_wbint_LookupSid_methods[] = {
	{ "opnum", (PyCFunction)py_wbint_LookupSid_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winbind.wbint_LookupSid.opnum() -> 1 (0x01) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupSid_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupSid_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupSid_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupSid_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupSid_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupSid_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wbint_LookupSid_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.wbint_LookupSid",
	.tp_getset = py_wbint_LookupSid_getsetters,
	.tp_methods = py_wbint_LookupSid_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wbint_LookupSid_new,
};

static bool pack_py_wbint_LookupSid_args_in(PyObject *args, PyObject *kwargs, struct wbint_LookupSid *r)
{
	PyObject *py_sid;
	const char *kwnames[] = {
		"sid", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:wbint_LookupSid", discard_const_p(char *, kwnames), &py_sid)) {
		return false;
	}

	if (py_sid == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.sid");
		return false;
	}
	r->in.sid = talloc_ptrtype(r, r->in.sid);
	if (r->in.sid == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(dom_sid_Type, py_sid, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_sid)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.sid = (struct dom_sid *)pytalloc_get_ptr(py_sid);
	return true;
}

static PyObject *unpack_py_wbint_LookupSid_args_out(struct wbint_LookupSid *r, bool raise_result_exception)
{
	PyObject *py_type = NULL;
	PyObject *py_domain = NULL;
	PyObject *py_name = NULL;
	PyObject *result = NULL;
	size_t result_size = 3;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_type = PyLong_FromLong((uint16_t)(*r->out.type));
	PyTuple_SetItem(result, 0, py_type);

	if (*r->out.domain == NULL) {
		py_domain = Py_None;
		Py_INCREF(py_domain);
	} else {
		if (*r->out.domain == NULL) {
			py_domain = Py_None;
			Py_INCREF(py_domain);
		} else {
			py_domain = PyUnicode_Decode(*r->out.domain, strlen(*r->out.domain), "utf-8", "ignore");
		}
	}
	PyTuple_SetItem(result, 1, py_domain);

	if (*r->out.name == NULL) {
		py_name = Py_None;
		Py_INCREF(py_name);
	} else {
		if (*r->out.name == NULL) {
			py_name = Py_None;
			Py_INCREF(py_name);
		} else {
			py_name = PyUnicode_Decode(*r->out.name, strlen(*r->out.name), "utf-8", "ignore");
		}
	}
	PyTuple_SetItem(result, 2, py_name);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 3, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_wbint_LookupSids_in_get_sids(PyObject *obj, void *closure)
{
	struct wbint_LookupSids *object = pytalloc_get_ptr(obj);
	PyObject *py_sids;
	if (object->in.sids == NULL) {
		Py_RETURN_NONE;
	}
	py_sids = pytalloc_reference_ex(lsa_SidArray_Type, object->in.sids, object->in.sids);
	return py_sids;
}

static int py_wbint_LookupSids_in_set_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_LookupSids *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.sids));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.sids");
		return -1;
	}
	object->in.sids = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.sids);
	if (object->in.sids == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(lsa_SidArray_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.sids = (struct lsa_SidArray *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_wbint_LookupSids_out_get_domains(PyObject *obj, void *closure)
{
	struct wbint_LookupSids *object = pytalloc_get_ptr(obj);
	PyObject *py_domains;
	if (object->out.domains == NULL) {
		Py_RETURN_NONE;
	}
	py_domains = pytalloc_reference_ex(lsa_RefDomainList_Type, object->out.domains, object->out.domains);
	return py_domains;
}

static int py_wbint_LookupSids_out_set_domains(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_LookupSids *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.domains));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.domains");
		return -1;
	}
	object->out.domains = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.domains);
	if (object->out.domains == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(lsa_RefDomainList_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.domains = (struct lsa_RefDomainList *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_wbint_LookupSids_out_get_names(PyObject *obj, void *closure)
{
	struct wbint_LookupSids *object = pytalloc_get_ptr(obj);
	PyObject *py_names;
	if (object->out.names == NULL) {
		Py_RETURN_NONE;
	}
	py_names = pytalloc_reference_ex(lsa_TransNameArray_Type, object->out.names, object->out.names);
	return py_names;
}

static int py_wbint_LookupSids_out_set_names(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_LookupSids *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.names));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.names");
		return -1;
	}
	object->out.names = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.names);
	if (object->out.names == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(lsa_TransNameArray_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.names = (struct lsa_TransNameArray *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_wbint_LookupSids_get_result(PyObject *obj, void *closure)
{
	struct wbint_LookupSids *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_wbint_LookupSids_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_LookupSids *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wbint_LookupSids_getsetters[] = {
	{
		.name = discard_const_p(char, "in_sids"),
		.get = py_wbint_LookupSids_in_get_sids,
		.set = py_wbint_LookupSids_in_set_sids,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_SidArray")
	},
	{
		.name = discard_const_p(char, "out_domains"),
		.get = py_wbint_LookupSids_out_get_domains,
		.set = py_wbint_LookupSids_out_set_domains,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_RefDomainList")
	},
	{
		.name = discard_const_p(char, "out_names"),
		.get = py_wbint_LookupSids_out_get_names,
		.set = py_wbint_LookupSids_out_set_names,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TransNameArray")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wbint_LookupSids_get_result,
		.set = py_wbint_LookupSids_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_wbint_LookupSids_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wbint_LookupSids, type);
	struct wbint_LookupSids *_self = (struct wbint_LookupSids *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.sids = talloc_zero(mem_ctx, struct lsa_SidArray);
	_self->out.domains = talloc_zero(mem_ctx, struct lsa_RefDomainList);
	_self->out.names = talloc_zero(mem_ctx, struct lsa_TransNameArray);
	return self;
}

static PyObject *py_wbint_LookupSids_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(2);
}

static PyObject *py_wbint_LookupSids_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_LookupSids *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_LookupSids_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[2];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wbint_LookupSids_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_LookupSids_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wbint_LookupSids_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_LookupSids_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wbint_LookupSids_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_LookupSids *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_LookupSids_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[2];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wbint_LookupSids_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_LookupSids_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_LookupSids_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_LookupSids_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_LookupSids_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_LookupSids *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winbind.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_LookupSids_ndr_print");
		return NULL;
	}
	call = &ndr_table_winbind.calls[2];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wbint_LookupSids_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_LookupSids_ndr_print(py_obj, args, kwargs, "wbint_LookupSids_in", NDR_IN);
}

static PyObject *py_wbint_LookupSids_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_LookupSids_ndr_print(py_obj, args, kwargs, "wbint_LookupSids_out", NDR_OUT);
}

static PyMethodDef py_wbint_LookupSids_methods[] = {
	{ "opnum", (PyCFunction)py_wbint_LookupSids_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winbind.wbint_LookupSids.opnum() -> 2 (0x02) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupSids_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupSids_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupSids_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupSids_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupSids_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupSids_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wbint_LookupSids_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.wbint_LookupSids",
	.tp_getset = py_wbint_LookupSids_getsetters,
	.tp_methods = py_wbint_LookupSids_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wbint_LookupSids_new,
};

static bool pack_py_wbint_LookupSids_args_in(PyObject *args, PyObject *kwargs, struct wbint_LookupSids *r)
{
	PyObject *py_sids;
	const char *kwnames[] = {
		"sids", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:wbint_LookupSids", discard_const_p(char *, kwnames), &py_sids)) {
		return false;
	}

	if (py_sids == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.sids");
		return false;
	}
	r->in.sids = talloc_ptrtype(r, r->in.sids);
	if (r->in.sids == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(lsa_SidArray_Type, py_sids, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_sids)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.sids = (struct lsa_SidArray *)pytalloc_get_ptr(py_sids);
	return true;
}

static PyObject *unpack_py_wbint_LookupSids_args_out(struct wbint_LookupSids *r, bool raise_result_exception)
{
	PyObject *py_domains = NULL;
	PyObject *py_names = NULL;
	PyObject *result = NULL;
	size_t result_size = 2;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_domains = pytalloc_reference_ex(lsa_RefDomainList_Type, r->out.domains, r->out.domains);
	PyTuple_SetItem(result, 0, py_domains);

	py_names = pytalloc_reference_ex(lsa_TransNameArray_Type, r->out.names, r->out.names);
	PyTuple_SetItem(result, 1, py_names);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 2, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_wbint_LookupName_in_get_domain(PyObject *obj, void *closure)
{
	struct wbint_LookupName *object = pytalloc_get_ptr(obj);
	PyObject *py_domain;
	if (object->in.domain == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.domain == NULL) {
		py_domain = Py_None;
		Py_INCREF(py_domain);
	} else {
		py_domain = PyUnicode_Decode(object->in.domain, strlen(object->in.domain), "utf-8", "ignore");
	}
	return py_domain;
}

static int py_wbint_LookupName_in_set_domain(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_LookupName *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.domain");
		return -1;
	}
	object->in.domain = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.domain);
	if (object->in.domain == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.domain = talloc_str;
	}
	return 0;
}

static PyObject *py_wbint_LookupName_in_get_name(PyObject *obj, void *closure)
{
	struct wbint_LookupName *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	if (object->in.name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.name == NULL) {
		py_name = Py_None;
		Py_INCREF(py_name);
	} else {
		py_name = PyUnicode_Decode(object->in.name, strlen(object->in.name), "utf-8", "ignore");
	}
	return py_name;
}

static int py_wbint_LookupName_in_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_LookupName *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.name");
		return -1;
	}
	object->in.name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.name);
	if (object->in.name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.name = talloc_str;
	}
	return 0;
}

static PyObject *py_wbint_LookupName_in_get_flags(PyObject *obj, void *closure)
{
	struct wbint_LookupName *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->in.flags));
	return py_flags;
}

static int py_wbint_LookupName_in_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_LookupName *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wbint_LookupName_out_get_type(PyObject *obj, void *closure)
{
	struct wbint_LookupName *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	if (object->out.type == NULL) {
		Py_RETURN_NONE;
	}
	py_type = PyLong_FromLong((uint16_t)(*object->out.type));
	return py_type;
}

static int py_wbint_LookupName_out_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_LookupName *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.type));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.type");
		return -1;
	}
	object->out.type = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.type);
	if (object->out.type == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wbint_LookupName_out_get_sid(PyObject *obj, void *closure)
{
	struct wbint_LookupName *object = pytalloc_get_ptr(obj);
	PyObject *py_sid;
	if (object->out.sid == NULL) {
		Py_RETURN_NONE;
	}
	py_sid = pytalloc_reference_ex(dom_sid_Type, object->out.sid, object->out.sid);
	return py_sid;
}

static int py_wbint_LookupName_out_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_LookupName *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.sid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.sid");
		return -1;
	}
	object->out.sid = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.sid);
	if (object->out.sid == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.sid = (struct dom_sid *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_wbint_LookupName_get_result(PyObject *obj, void *closure)
{
	struct wbint_LookupName *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_wbint_LookupName_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_LookupName *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wbint_LookupName_getsetters[] = {
	{
		.name = discard_const_p(char, "in_domain"),
		.get = py_wbint_LookupName_in_get_domain,
		.set = py_wbint_LookupName_in_set_domain,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_name"),
		.get = py_wbint_LookupName_in_get_name,
		.set = py_wbint_LookupName_in_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_flags"),
		.get = py_wbint_LookupName_in_get_flags,
		.set = py_wbint_LookupName_in_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_type"),
		.get = py_wbint_LookupName_out_get_type,
		.set = py_wbint_LookupName_out_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_SidType")
	},
	{
		.name = discard_const_p(char, "out_sid"),
		.get = py_wbint_LookupName_out_get_sid,
		.set = py_wbint_LookupName_out_set_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wbint_LookupName_get_result,
		.set = py_wbint_LookupName_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_wbint_LookupName_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wbint_LookupName, type);
	struct wbint_LookupName *_self = (struct wbint_LookupName *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.type = talloc_zero(mem_ctx, enum lsa_SidType);
	_self->out.sid = talloc_zero(mem_ctx, struct dom_sid);
	return self;
}

static PyObject *py_wbint_LookupName_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(3);
}

static PyObject *py_wbint_LookupName_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_LookupName *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_LookupName_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[3];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wbint_LookupName_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_LookupName_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wbint_LookupName_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_LookupName_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wbint_LookupName_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_LookupName *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_LookupName_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[3];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wbint_LookupName_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_LookupName_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_LookupName_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_LookupName_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_LookupName_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_LookupName *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winbind.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_LookupName_ndr_print");
		return NULL;
	}
	call = &ndr_table_winbind.calls[3];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wbint_LookupName_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_LookupName_ndr_print(py_obj, args, kwargs, "wbint_LookupName_in", NDR_IN);
}

static PyObject *py_wbint_LookupName_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_LookupName_ndr_print(py_obj, args, kwargs, "wbint_LookupName_out", NDR_OUT);
}

static PyMethodDef py_wbint_LookupName_methods[] = {
	{ "opnum", (PyCFunction)py_wbint_LookupName_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winbind.wbint_LookupName.opnum() -> 3 (0x03) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupName_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupName_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupName_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupName_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupName_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupName_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wbint_LookupName_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.wbint_LookupName",
	.tp_getset = py_wbint_LookupName_getsetters,
	.tp_methods = py_wbint_LookupName_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wbint_LookupName_new,
};

static bool pack_py_wbint_LookupName_args_in(PyObject *args, PyObject *kwargs, struct wbint_LookupName *r)
{
	PyObject *py_domain;
	PyObject *py_name;
	PyObject *py_flags;
	const char *kwnames[] = {
		"domain", "name", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:wbint_LookupName", discard_const_p(char *, kwnames), &py_domain, &py_name, &py_flags)) {
		return false;
	}

	if (py_domain == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.domain");
		return false;
	}
	r->in.domain = talloc_ptrtype(r, r->in.domain);
	if (r->in.domain == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_domain)) {
			unicode = PyUnicode_AsEncodedString(py_domain, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_domain)) {
			test_str = PyBytes_AS_STRING(py_domain);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_domain)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.domain = talloc_str;
	}
	if (py_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.name");
		return false;
	}
	r->in.name = talloc_ptrtype(r, r->in.name);
	if (r->in.name == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_name)) {
			unicode = PyUnicode_AsEncodedString(py_name, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_name)) {
			test_str = PyBytes_AS_STRING(py_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_name)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.name = talloc_str;
	}
	if (py_flags == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.flags");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.flags));
		if (PyLong_Check(py_flags)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_flags);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_wbint_LookupName_args_out(struct wbint_LookupName *r, bool raise_result_exception)
{
	PyObject *py_type = NULL;
	PyObject *py_sid = NULL;
	PyObject *result = NULL;
	size_t result_size = 2;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_type = PyLong_FromLong((uint16_t)(*r->out.type));
	PyTuple_SetItem(result, 0, py_type);

	py_sid = pytalloc_reference_ex(dom_sid_Type, r->out.sid, r->out.sid);
	PyTuple_SetItem(result, 1, py_sid);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 2, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_wbint_Sids2UnixIDs_in_get_domains(PyObject *obj, void *closure)
{
	struct wbint_Sids2UnixIDs *object = pytalloc_get_ptr(obj);
	PyObject *py_domains;
	if (object->in.domains == NULL) {
		Py_RETURN_NONE;
	}
	py_domains = pytalloc_reference_ex(lsa_RefDomainList_Type, object->in.domains, object->in.domains);
	return py_domains;
}

static int py_wbint_Sids2UnixIDs_in_set_domains(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_Sids2UnixIDs *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.domains));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.domains");
		return -1;
	}
	object->in.domains = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.domains);
	if (object->in.domains == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(lsa_RefDomainList_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.domains = (struct lsa_RefDomainList *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_wbint_Sids2UnixIDs_in_get_ids(PyObject *obj, void *closure)
{
	struct wbint_Sids2UnixIDs *object = pytalloc_get_ptr(obj);
	PyObject *py_ids;
	if (object->in.ids == NULL) {
		Py_RETURN_NONE;
	}
	py_ids = pytalloc_reference_ex(&wbint_TransIDArray_Type, object->in.ids, object->in.ids);
	return py_ids;
}

static int py_wbint_Sids2UnixIDs_in_set_ids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_Sids2UnixIDs *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.ids));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.ids");
		return -1;
	}
	object->in.ids = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.ids);
	if (object->in.ids == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&wbint_TransIDArray_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.ids = (struct wbint_TransIDArray *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_wbint_Sids2UnixIDs_out_get_ids(PyObject *obj, void *closure)
{
	struct wbint_Sids2UnixIDs *object = pytalloc_get_ptr(obj);
	PyObject *py_ids;
	if (object->out.ids == NULL) {
		Py_RETURN_NONE;
	}
	py_ids = pytalloc_reference_ex(&wbint_TransIDArray_Type, object->out.ids, object->out.ids);
	return py_ids;
}

static int py_wbint_Sids2UnixIDs_out_set_ids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_Sids2UnixIDs *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.ids));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.ids");
		return -1;
	}
	object->out.ids = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.ids);
	if (object->out.ids == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&wbint_TransIDArray_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.ids = (struct wbint_TransIDArray *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_wbint_Sids2UnixIDs_get_result(PyObject *obj, void *closure)
{
	struct wbint_Sids2UnixIDs *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_wbint_Sids2UnixIDs_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_Sids2UnixIDs *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wbint_Sids2UnixIDs_getsetters[] = {
	{
		.name = discard_const_p(char, "in_domains"),
		.get = py_wbint_Sids2UnixIDs_in_get_domains,
		.set = py_wbint_Sids2UnixIDs_in_set_domains,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_RefDomainList")
	},
	{
		.name = discard_const_p(char, "in_ids"),
		.get = py_wbint_Sids2UnixIDs_in_get_ids,
		.set = py_wbint_Sids2UnixIDs_in_set_ids,
		.doc = discard_const_p(char, "PIDL-generated element of base type wbint_TransIDArray")
	},
	{
		.name = discard_const_p(char, "out_ids"),
		.get = py_wbint_Sids2UnixIDs_out_get_ids,
		.set = py_wbint_Sids2UnixIDs_out_set_ids,
		.doc = discard_const_p(char, "PIDL-generated element of base type wbint_TransIDArray")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wbint_Sids2UnixIDs_get_result,
		.set = py_wbint_Sids2UnixIDs_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_wbint_Sids2UnixIDs_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wbint_Sids2UnixIDs, type);
	struct wbint_Sids2UnixIDs *_self = (struct wbint_Sids2UnixIDs *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.domains = talloc_zero(mem_ctx, struct lsa_RefDomainList);
	_self->in.ids = talloc_zero(mem_ctx, struct wbint_TransIDArray);
	_self->out.ids = talloc_zero(mem_ctx, struct wbint_TransIDArray);
	return self;
}

static PyObject *py_wbint_Sids2UnixIDs_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(4);
}

static PyObject *py_wbint_Sids2UnixIDs_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_Sids2UnixIDs *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 5) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_Sids2UnixIDs_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[4];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wbint_Sids2UnixIDs_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_Sids2UnixIDs_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wbint_Sids2UnixIDs_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_Sids2UnixIDs_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wbint_Sids2UnixIDs_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_Sids2UnixIDs *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 5) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_Sids2UnixIDs_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[4];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wbint_Sids2UnixIDs_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_Sids2UnixIDs_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_Sids2UnixIDs_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_Sids2UnixIDs_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_Sids2UnixIDs_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_Sids2UnixIDs *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winbind.num_calls < 5) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_Sids2UnixIDs_ndr_print");
		return NULL;
	}
	call = &ndr_table_winbind.calls[4];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wbint_Sids2UnixIDs_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_Sids2UnixIDs_ndr_print(py_obj, args, kwargs, "wbint_Sids2UnixIDs_in", NDR_IN);
}

static PyObject *py_wbint_Sids2UnixIDs_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_Sids2UnixIDs_ndr_print(py_obj, args, kwargs, "wbint_Sids2UnixIDs_out", NDR_OUT);
}

static PyMethodDef py_wbint_Sids2UnixIDs_methods[] = {
	{ "opnum", (PyCFunction)py_wbint_Sids2UnixIDs_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winbind.wbint_Sids2UnixIDs.opnum() -> 4 (0x04) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_Sids2UnixIDs_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_Sids2UnixIDs_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_Sids2UnixIDs_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_Sids2UnixIDs_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_Sids2UnixIDs_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_Sids2UnixIDs_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wbint_Sids2UnixIDs_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.wbint_Sids2UnixIDs",
	.tp_getset = py_wbint_Sids2UnixIDs_getsetters,
	.tp_methods = py_wbint_Sids2UnixIDs_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wbint_Sids2UnixIDs_new,
};

static bool pack_py_wbint_Sids2UnixIDs_args_in(PyObject *args, PyObject *kwargs, struct wbint_Sids2UnixIDs *r)
{
	PyObject *py_domains;
	PyObject *py_ids;
	const char *kwnames[] = {
		"domains", "ids", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:wbint_Sids2UnixIDs", discard_const_p(char *, kwnames), &py_domains, &py_ids)) {
		return false;
	}

	if (py_domains == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.domains");
		return false;
	}
	r->in.domains = talloc_ptrtype(r, r->in.domains);
	if (r->in.domains == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(lsa_RefDomainList_Type, py_domains, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_domains)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.domains = (struct lsa_RefDomainList *)pytalloc_get_ptr(py_domains);
	if (py_ids == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.ids");
		return false;
	}
	r->in.ids = talloc_ptrtype(r, r->in.ids);
	if (r->in.ids == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&wbint_TransIDArray_Type, py_ids, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ids)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ids = (struct wbint_TransIDArray *)pytalloc_get_ptr(py_ids);
	return true;
}

static PyObject *unpack_py_wbint_Sids2UnixIDs_args_out(struct wbint_Sids2UnixIDs *r, bool raise_result_exception)
{
	PyObject *py_ids = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_ids = pytalloc_reference_ex(&wbint_TransIDArray_Type, r->out.ids, r->out.ids);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_ids);
	}
	if (result_size == 1) {
		result = py_ids;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_wbint_UnixIDs2Sids_in_get_domain_name(PyObject *obj, void *closure)
{
	struct wbint_UnixIDs2Sids *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	if (object->in.domain_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.domain_name == NULL) {
		py_domain_name = Py_None;
		Py_INCREF(py_domain_name);
	} else {
		py_domain_name = PyUnicode_Decode(object->in.domain_name, strlen(object->in.domain_name), "utf-8", "ignore");
	}
	return py_domain_name;
}

static int py_wbint_UnixIDs2Sids_in_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_UnixIDs2Sids *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.domain_name");
		return -1;
	}
	object->in.domain_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.domain_name);
	if (object->in.domain_name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.domain_name = talloc_str;
	}
	return 0;
}

static PyObject *py_wbint_UnixIDs2Sids_in_get_domain_sid(PyObject *obj, void *closure)
{
	struct wbint_UnixIDs2Sids *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_sid;
	py_domain_sid = pytalloc_reference_ex(dom_sid_Type, pytalloc_get_mem_ctx(obj), &object->in.domain_sid);
	return py_domain_sid;
}

static int py_wbint_UnixIDs2Sids_in_set_domain_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_UnixIDs2Sids *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.domain_sid");
		return -1;
	}
	PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.domain_sid = *(struct dom_sid *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_wbint_UnixIDs2Sids_in_get_num_ids(PyObject *obj, void *closure)
{
	struct wbint_UnixIDs2Sids *object = pytalloc_get_ptr(obj);
	PyObject *py_num_ids;
	py_num_ids = PyLong_FromUnsignedLongLong((uint32_t)(object->in.num_ids));
	return py_num_ids;
}

static int py_wbint_UnixIDs2Sids_in_set_num_ids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_UnixIDs2Sids *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.num_ids");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.num_ids));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.num_ids = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wbint_UnixIDs2Sids_in_get_xids(PyObject *obj, void *closure)
{
	struct wbint_UnixIDs2Sids *object = pytalloc_get_ptr(obj);
	PyObject *py_xids;
	py_xids = PyList_New(object->in.num_ids);
	if (py_xids == NULL) {
		return NULL;
	}
	{
		int xids_cntr_0;
		for (xids_cntr_0 = 0; xids_cntr_0 < (object->in.num_ids); xids_cntr_0++) {
			PyObject *py_xids_0;
			py_xids_0 = pytalloc_reference_ex(unixid_Type, object->in.xids, &(object->in.xids)[xids_cntr_0]);
			PyList_SetItem(py_xids, xids_cntr_0, py_xids_0);
		}
	}
	return py_xids;
}

static int py_wbint_UnixIDs2Sids_in_set_xids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_UnixIDs2Sids *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.xids");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int xids_cntr_0;
		object->in.xids = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.xids, PyList_GET_SIZE(value));
		if (!object->in.xids) { return -1; }
		talloc_set_name_const(object->in.xids, "ARRAY: object->in.xids");
		for (xids_cntr_0 = 0; xids_cntr_0 < PyList_GET_SIZE(value); xids_cntr_0++) {
			if (PyList_GET_ITEM(value, xids_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->in.xids)[xids_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(unixid_Type, PyList_GET_ITEM(value, xids_cntr_0), return -1;);
			if (talloc_reference(object->in.xids, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, xids_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->in.xids)[xids_cntr_0] = *(struct unixid *)pytalloc_get_ptr(PyList_GET_ITEM(value, xids_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_wbint_UnixIDs2Sids_out_get_xids(PyObject *obj, void *closure)
{
	struct wbint_UnixIDs2Sids *object = pytalloc_get_ptr(obj);
	PyObject *py_xids;
	py_xids = PyList_New(object->in.num_ids);
	if (py_xids == NULL) {
		return NULL;
	}
	{
		int xids_cntr_0;
		for (xids_cntr_0 = 0; xids_cntr_0 < (object->in.num_ids); xids_cntr_0++) {
			PyObject *py_xids_0;
			py_xids_0 = pytalloc_reference_ex(unixid_Type, object->out.xids, &(object->out.xids)[xids_cntr_0]);
			PyList_SetItem(py_xids, xids_cntr_0, py_xids_0);
		}
	}
	return py_xids;
}

static int py_wbint_UnixIDs2Sids_out_set_xids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_UnixIDs2Sids *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.xids");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int xids_cntr_0;
		object->out.xids = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.xids, PyList_GET_SIZE(value));
		if (!object->out.xids) { return -1; }
		talloc_set_name_const(object->out.xids, "ARRAY: object->out.xids");
		for (xids_cntr_0 = 0; xids_cntr_0 < PyList_GET_SIZE(value); xids_cntr_0++) {
			if (PyList_GET_ITEM(value, xids_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->out.xids)[xids_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(unixid_Type, PyList_GET_ITEM(value, xids_cntr_0), return -1;);
			if (talloc_reference(object->out.xids, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, xids_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->out.xids)[xids_cntr_0] = *(struct unixid *)pytalloc_get_ptr(PyList_GET_ITEM(value, xids_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_wbint_UnixIDs2Sids_out_get_sids(PyObject *obj, void *closure)
{
	struct wbint_UnixIDs2Sids *object = pytalloc_get_ptr(obj);
	PyObject *py_sids;
	py_sids = PyList_New(object->in.num_ids);
	if (py_sids == NULL) {
		return NULL;
	}
	{
		int sids_cntr_0;
		for (sids_cntr_0 = 0; sids_cntr_0 < (object->in.num_ids); sids_cntr_0++) {
			PyObject *py_sids_0;
			py_sids_0 = pytalloc_reference_ex(dom_sid_Type, object->out.sids, &(object->out.sids)[sids_cntr_0]);
			PyList_SetItem(py_sids, sids_cntr_0, py_sids_0);
		}
	}
	return py_sids;
}

static int py_wbint_UnixIDs2Sids_out_set_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_UnixIDs2Sids *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.sids");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int sids_cntr_0;
		object->out.sids = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.sids, PyList_GET_SIZE(value));
		if (!object->out.sids) { return -1; }
		talloc_set_name_const(object->out.sids, "ARRAY: object->out.sids");
		for (sids_cntr_0 = 0; sids_cntr_0 < PyList_GET_SIZE(value); sids_cntr_0++) {
			if (PyList_GET_ITEM(value, sids_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->out.sids)[sids_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(dom_sid_Type, PyList_GET_ITEM(value, sids_cntr_0), return -1;);
			if (talloc_reference(object->out.sids, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, sids_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->out.sids)[sids_cntr_0] = *(struct dom_sid *)pytalloc_get_ptr(PyList_GET_ITEM(value, sids_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_wbint_UnixIDs2Sids_get_result(PyObject *obj, void *closure)
{
	struct wbint_UnixIDs2Sids *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_wbint_UnixIDs2Sids_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_UnixIDs2Sids *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wbint_UnixIDs2Sids_getsetters[] = {
	{
		.name = discard_const_p(char, "in_domain_name"),
		.get = py_wbint_UnixIDs2Sids_in_get_domain_name,
		.set = py_wbint_UnixIDs2Sids_in_set_domain_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_domain_sid"),
		.get = py_wbint_UnixIDs2Sids_in_get_domain_sid,
		.set = py_wbint_UnixIDs2Sids_in_set_domain_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid")
	},
	{
		.name = discard_const_p(char, "in_num_ids"),
		.get = py_wbint_UnixIDs2Sids_in_get_num_ids,
		.set = py_wbint_UnixIDs2Sids_in_set_num_ids,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_xids"),
		.get = py_wbint_UnixIDs2Sids_in_get_xids,
		.set = py_wbint_UnixIDs2Sids_in_set_xids,
		.doc = discard_const_p(char, "PIDL-generated element of base type unixid")
	},
	{
		.name = discard_const_p(char, "out_xids"),
		.get = py_wbint_UnixIDs2Sids_out_get_xids,
		.set = py_wbint_UnixIDs2Sids_out_set_xids,
		.doc = discard_const_p(char, "PIDL-generated element of base type unixid")
	},
	{
		.name = discard_const_p(char, "out_sids"),
		.get = py_wbint_UnixIDs2Sids_out_get_sids,
		.set = py_wbint_UnixIDs2Sids_out_set_sids,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wbint_UnixIDs2Sids_get_result,
		.set = py_wbint_UnixIDs2Sids_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_wbint_UnixIDs2Sids_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wbint_UnixIDs2Sids, type);
	return self;
}

static PyObject *py_wbint_UnixIDs2Sids_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(5);
}

static PyObject *py_wbint_UnixIDs2Sids_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_UnixIDs2Sids *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 6) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_UnixIDs2Sids_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[5];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wbint_UnixIDs2Sids_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_UnixIDs2Sids_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wbint_UnixIDs2Sids_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_UnixIDs2Sids_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wbint_UnixIDs2Sids_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_UnixIDs2Sids *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 6) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_UnixIDs2Sids_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[5];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wbint_UnixIDs2Sids_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_UnixIDs2Sids_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_UnixIDs2Sids_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_UnixIDs2Sids_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_UnixIDs2Sids_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_UnixIDs2Sids *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winbind.num_calls < 6) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_UnixIDs2Sids_ndr_print");
		return NULL;
	}
	call = &ndr_table_winbind.calls[5];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wbint_UnixIDs2Sids_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_UnixIDs2Sids_ndr_print(py_obj, args, kwargs, "wbint_UnixIDs2Sids_in", NDR_IN);
}

static PyObject *py_wbint_UnixIDs2Sids_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_UnixIDs2Sids_ndr_print(py_obj, args, kwargs, "wbint_UnixIDs2Sids_out", NDR_OUT);
}

static PyMethodDef py_wbint_UnixIDs2Sids_methods[] = {
	{ "opnum", (PyCFunction)py_wbint_UnixIDs2Sids_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winbind.wbint_UnixIDs2Sids.opnum() -> 5 (0x05) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_UnixIDs2Sids_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_UnixIDs2Sids_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_UnixIDs2Sids_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_UnixIDs2Sids_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_UnixIDs2Sids_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_UnixIDs2Sids_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wbint_UnixIDs2Sids_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.wbint_UnixIDs2Sids",
	.tp_getset = py_wbint_UnixIDs2Sids_getsetters,
	.tp_methods = py_wbint_UnixIDs2Sids_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wbint_UnixIDs2Sids_new,
};

static bool pack_py_wbint_UnixIDs2Sids_args_in(PyObject *args, PyObject *kwargs, struct wbint_UnixIDs2Sids *r)
{
	PyObject *py_domain_name;
	PyObject *py_domain_sid;
	PyObject *py_num_ids;
	PyObject *py_xids;
	const char *kwnames[] = {
		"domain_name", "domain_sid", "num_ids", "xids", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:wbint_UnixIDs2Sids", discard_const_p(char *, kwnames), &py_domain_name, &py_domain_sid, &py_num_ids, &py_xids)) {
		return false;
	}

	if (py_domain_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.domain_name");
		return false;
	}
	r->in.domain_name = talloc_ptrtype(r, r->in.domain_name);
	if (r->in.domain_name == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_domain_name)) {
			unicode = PyUnicode_AsEncodedString(py_domain_name, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_domain_name)) {
			test_str = PyBytes_AS_STRING(py_domain_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_domain_name)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.domain_name = talloc_str;
	}
	if (py_domain_sid == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.domain_sid");
		return false;
	}
	PY_CHECK_TYPE(dom_sid_Type, py_domain_sid, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_domain_sid)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.domain_sid = *(struct dom_sid *)pytalloc_get_ptr(py_domain_sid);
	if (py_num_ids == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.num_ids");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.num_ids));
		if (PyLong_Check(py_num_ids)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_num_ids);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.num_ids = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_xids == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.xids");
		return false;
	}
	PY_CHECK_TYPE(&PyList_Type, py_xids, return false;);
	{
		int xids_cntr_0;
		r->in.xids = talloc_array_ptrtype(r, r->in.xids, PyList_GET_SIZE(py_xids));
		if (!r->in.xids) { return false; }
		talloc_set_name_const(r->in.xids, "ARRAY: r->in.xids");
		for (xids_cntr_0 = 0; xids_cntr_0 < PyList_GET_SIZE(py_xids); xids_cntr_0++) {
			if (PyList_GET_ITEM(py_xids, xids_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (r->in.xids)[xids_cntr_0]");
				return false;
			}
			PY_CHECK_TYPE(unixid_Type, PyList_GET_ITEM(py_xids, xids_cntr_0), return false;);
			if (talloc_reference(r->in.xids, pytalloc_get_mem_ctx(PyList_GET_ITEM(py_xids, xids_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return false;
			}
			(r->in.xids)[xids_cntr_0] = *(struct unixid *)pytalloc_get_ptr(PyList_GET_ITEM(py_xids, xids_cntr_0));
		}
	}
	return true;
}

static PyObject *unpack_py_wbint_UnixIDs2Sids_args_out(struct wbint_UnixIDs2Sids *r, bool raise_result_exception)
{
	PyObject *py_xids = NULL;
	PyObject *py_sids = NULL;
	PyObject *result = NULL;
	size_t result_size = 2;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_xids = PyList_New(r->in.num_ids);
	if (py_xids == NULL) {
		return NULL;
	}
	{
		int xids_cntr_0;
		for (xids_cntr_0 = 0; xids_cntr_0 < (r->in.num_ids); xids_cntr_0++) {
			PyObject *py_xids_0;
			py_xids_0 = pytalloc_reference_ex(unixid_Type, r->out.xids, &(r->out.xids)[xids_cntr_0]);
			PyList_SetItem(py_xids, xids_cntr_0, py_xids_0);
		}
	}
	PyTuple_SetItem(result, 0, py_xids);

	py_sids = PyList_New(r->in.num_ids);
	if (py_sids == NULL) {
		return NULL;
	}
	{
		int sids_cntr_0;
		for (sids_cntr_0 = 0; sids_cntr_0 < (r->in.num_ids); sids_cntr_0++) {
			PyObject *py_sids_0;
			py_sids_0 = pytalloc_reference_ex(dom_sid_Type, r->out.sids, &(r->out.sids)[sids_cntr_0]);
			PyList_SetItem(py_sids, sids_cntr_0, py_sids_0);
		}
	}
	PyTuple_SetItem(result, 1, py_sids);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 2, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_wbint_AllocateUid_out_get_uid(PyObject *obj, void *closure)
{
	struct wbint_AllocateUid *object = pytalloc_get_ptr(obj);
	PyObject *py_uid;
	if (object->out.uid == NULL) {
		Py_RETURN_NONE;
	}
	py_uid = PyLong_FromUnsignedLongLong(*object->out.uid);
	return py_uid;
}

static int py_wbint_AllocateUid_out_set_uid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_AllocateUid *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.uid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.uid");
		return -1;
	}
	object->out.uid = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.uid);
	if (object->out.uid == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.uid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.uid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wbint_AllocateUid_get_result(PyObject *obj, void *closure)
{
	struct wbint_AllocateUid *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_wbint_AllocateUid_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_AllocateUid *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wbint_AllocateUid_getsetters[] = {
	{
		.name = discard_const_p(char, "out_uid"),
		.get = py_wbint_AllocateUid_out_get_uid,
		.set = py_wbint_AllocateUid_out_set_uid,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wbint_AllocateUid_get_result,
		.set = py_wbint_AllocateUid_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_wbint_AllocateUid_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wbint_AllocateUid, type);
	struct wbint_AllocateUid *_self = (struct wbint_AllocateUid *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.uid = talloc_zero(mem_ctx, uint64_t);
	return self;
}

static PyObject *py_wbint_AllocateUid_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(6);
}

static PyObject *py_wbint_AllocateUid_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_AllocateUid *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 7) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_AllocateUid_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[6];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wbint_AllocateUid_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_AllocateUid_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wbint_AllocateUid_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_AllocateUid_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wbint_AllocateUid_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_AllocateUid *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 7) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_AllocateUid_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[6];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wbint_AllocateUid_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_AllocateUid_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_AllocateUid_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_AllocateUid_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_AllocateUid_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_AllocateUid *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winbind.num_calls < 7) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_AllocateUid_ndr_print");
		return NULL;
	}
	call = &ndr_table_winbind.calls[6];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wbint_AllocateUid_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_AllocateUid_ndr_print(py_obj, args, kwargs, "wbint_AllocateUid_in", NDR_IN);
}

static PyObject *py_wbint_AllocateUid_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_AllocateUid_ndr_print(py_obj, args, kwargs, "wbint_AllocateUid_out", NDR_OUT);
}

static PyMethodDef py_wbint_AllocateUid_methods[] = {
	{ "opnum", (PyCFunction)py_wbint_AllocateUid_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winbind.wbint_AllocateUid.opnum() -> 6 (0x06) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_AllocateUid_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_AllocateUid_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_AllocateUid_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_AllocateUid_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_AllocateUid_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_AllocateUid_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wbint_AllocateUid_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.wbint_AllocateUid",
	.tp_getset = py_wbint_AllocateUid_getsetters,
	.tp_methods = py_wbint_AllocateUid_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wbint_AllocateUid_new,
};

static bool pack_py_wbint_AllocateUid_args_in(PyObject *args, PyObject *kwargs, struct wbint_AllocateUid *r)
{
	const char *kwnames[] = {
		NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":wbint_AllocateUid", discard_const_p(char *, kwnames))) {
		return false;
	}

	return true;
}

static PyObject *unpack_py_wbint_AllocateUid_args_out(struct wbint_AllocateUid *r, bool raise_result_exception)
{
	PyObject *py_uid = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_uid = PyLong_FromUnsignedLongLong(*r->out.uid);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_uid);
	}
	if (result_size == 1) {
		result = py_uid;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_wbint_AllocateGid_out_get_gid(PyObject *obj, void *closure)
{
	struct wbint_AllocateGid *object = pytalloc_get_ptr(obj);
	PyObject *py_gid;
	if (object->out.gid == NULL) {
		Py_RETURN_NONE;
	}
	py_gid = PyLong_FromUnsignedLongLong(*object->out.gid);
	return py_gid;
}

static int py_wbint_AllocateGid_out_set_gid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_AllocateGid *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.gid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.gid");
		return -1;
	}
	object->out.gid = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.gid);
	if (object->out.gid == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.gid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.gid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wbint_AllocateGid_get_result(PyObject *obj, void *closure)
{
	struct wbint_AllocateGid *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_wbint_AllocateGid_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_AllocateGid *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wbint_AllocateGid_getsetters[] = {
	{
		.name = discard_const_p(char, "out_gid"),
		.get = py_wbint_AllocateGid_out_get_gid,
		.set = py_wbint_AllocateGid_out_set_gid,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wbint_AllocateGid_get_result,
		.set = py_wbint_AllocateGid_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_wbint_AllocateGid_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wbint_AllocateGid, type);
	struct wbint_AllocateGid *_self = (struct wbint_AllocateGid *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.gid = talloc_zero(mem_ctx, uint64_t);
	return self;
}

static PyObject *py_wbint_AllocateGid_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(7);
}

static PyObject *py_wbint_AllocateGid_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_AllocateGid *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 8) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_AllocateGid_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[7];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wbint_AllocateGid_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_AllocateGid_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wbint_AllocateGid_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_AllocateGid_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wbint_AllocateGid_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_AllocateGid *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 8) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_AllocateGid_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[7];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wbint_AllocateGid_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_AllocateGid_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_AllocateGid_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_AllocateGid_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_AllocateGid_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_AllocateGid *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winbind.num_calls < 8) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_AllocateGid_ndr_print");
		return NULL;
	}
	call = &ndr_table_winbind.calls[7];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wbint_AllocateGid_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_AllocateGid_ndr_print(py_obj, args, kwargs, "wbint_AllocateGid_in", NDR_IN);
}

static PyObject *py_wbint_AllocateGid_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_AllocateGid_ndr_print(py_obj, args, kwargs, "wbint_AllocateGid_out", NDR_OUT);
}

static PyMethodDef py_wbint_AllocateGid_methods[] = {
	{ "opnum", (PyCFunction)py_wbint_AllocateGid_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winbind.wbint_AllocateGid.opnum() -> 7 (0x07) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_AllocateGid_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_AllocateGid_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_AllocateGid_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_AllocateGid_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_AllocateGid_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_AllocateGid_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wbint_AllocateGid_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.wbint_AllocateGid",
	.tp_getset = py_wbint_AllocateGid_getsetters,
	.tp_methods = py_wbint_AllocateGid_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wbint_AllocateGid_new,
};

static bool pack_py_wbint_AllocateGid_args_in(PyObject *args, PyObject *kwargs, struct wbint_AllocateGid *r)
{
	const char *kwnames[] = {
		NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":wbint_AllocateGid", discard_const_p(char *, kwnames))) {
		return false;
	}

	return true;
}

static PyObject *unpack_py_wbint_AllocateGid_args_out(struct wbint_AllocateGid *r, bool raise_result_exception)
{
	PyObject *py_gid = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_gid = PyLong_FromUnsignedLongLong(*r->out.gid);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_gid);
	}
	if (result_size == 1) {
		result = py_gid;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_wbint_GetNssInfo_in_get_info(PyObject *obj, void *closure)
{
	struct wbint_GetNssInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->in.info == NULL) {
		Py_RETURN_NONE;
	}
	py_info = pytalloc_reference_ex(&wbint_userinfo_Type, object->in.info, object->in.info);
	return py_info;
}

static int py_wbint_GetNssInfo_in_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_GetNssInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.info");
		return -1;
	}
	object->in.info = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.info);
	if (object->in.info == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&wbint_userinfo_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.info = (struct wbint_userinfo *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_wbint_GetNssInfo_out_get_info(PyObject *obj, void *closure)
{
	struct wbint_GetNssInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->out.info == NULL) {
		Py_RETURN_NONE;
	}
	py_info = pytalloc_reference_ex(&wbint_userinfo_Type, object->out.info, object->out.info);
	return py_info;
}

static int py_wbint_GetNssInfo_out_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_GetNssInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.info");
		return -1;
	}
	object->out.info = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.info);
	if (object->out.info == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&wbint_userinfo_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.info = (struct wbint_userinfo *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_wbint_GetNssInfo_get_result(PyObject *obj, void *closure)
{
	struct wbint_GetNssInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_wbint_GetNssInfo_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_GetNssInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wbint_GetNssInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "in_info"),
		.get = py_wbint_GetNssInfo_in_get_info,
		.set = py_wbint_GetNssInfo_in_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type wbint_userinfo")
	},
	{
		.name = discard_const_p(char, "out_info"),
		.get = py_wbint_GetNssInfo_out_get_info,
		.set = py_wbint_GetNssInfo_out_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type wbint_userinfo")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wbint_GetNssInfo_get_result,
		.set = py_wbint_GetNssInfo_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_wbint_GetNssInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wbint_GetNssInfo, type);
	struct wbint_GetNssInfo *_self = (struct wbint_GetNssInfo *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.info = talloc_zero(mem_ctx, struct wbint_userinfo);
	_self->out.info = talloc_zero(mem_ctx, struct wbint_userinfo);
	return self;
}

static PyObject *py_wbint_GetNssInfo_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(8);
}

static PyObject *py_wbint_GetNssInfo_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_GetNssInfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 9) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_GetNssInfo_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[8];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wbint_GetNssInfo_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_GetNssInfo_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wbint_GetNssInfo_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_GetNssInfo_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wbint_GetNssInfo_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_GetNssInfo *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 9) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_GetNssInfo_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[8];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wbint_GetNssInfo_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_GetNssInfo_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_GetNssInfo_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_GetNssInfo_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_GetNssInfo_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_GetNssInfo *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winbind.num_calls < 9) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_GetNssInfo_ndr_print");
		return NULL;
	}
	call = &ndr_table_winbind.calls[8];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wbint_GetNssInfo_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_GetNssInfo_ndr_print(py_obj, args, kwargs, "wbint_GetNssInfo_in", NDR_IN);
}

static PyObject *py_wbint_GetNssInfo_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_GetNssInfo_ndr_print(py_obj, args, kwargs, "wbint_GetNssInfo_out", NDR_OUT);
}

static PyMethodDef py_wbint_GetNssInfo_methods[] = {
	{ "opnum", (PyCFunction)py_wbint_GetNssInfo_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winbind.wbint_GetNssInfo.opnum() -> 8 (0x08) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_GetNssInfo_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_GetNssInfo_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_GetNssInfo_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_GetNssInfo_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_GetNssInfo_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_GetNssInfo_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wbint_GetNssInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.wbint_GetNssInfo",
	.tp_getset = py_wbint_GetNssInfo_getsetters,
	.tp_methods = py_wbint_GetNssInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wbint_GetNssInfo_new,
};

static bool pack_py_wbint_GetNssInfo_args_in(PyObject *args, PyObject *kwargs, struct wbint_GetNssInfo *r)
{
	PyObject *py_info;
	const char *kwnames[] = {
		"info", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:wbint_GetNssInfo", discard_const_p(char *, kwnames), &py_info)) {
		return false;
	}

	if (py_info == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.info");
		return false;
	}
	r->in.info = talloc_ptrtype(r, r->in.info);
	if (r->in.info == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&wbint_userinfo_Type, py_info, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_info)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.info = (struct wbint_userinfo *)pytalloc_get_ptr(py_info);
	return true;
}

static PyObject *unpack_py_wbint_GetNssInfo_args_out(struct wbint_GetNssInfo *r, bool raise_result_exception)
{
	PyObject *py_info = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_info = pytalloc_reference_ex(&wbint_userinfo_Type, r->out.info, r->out.info);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_info);
	}
	if (result_size == 1) {
		result = py_info;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_wbint_LookupUserAliases_in_get_sids(PyObject *obj, void *closure)
{
	struct wbint_LookupUserAliases *object = pytalloc_get_ptr(obj);
	PyObject *py_sids;
	if (object->in.sids == NULL) {
		Py_RETURN_NONE;
	}
	py_sids = pytalloc_reference_ex(&wbint_SidArray_Type, object->in.sids, object->in.sids);
	return py_sids;
}

static int py_wbint_LookupUserAliases_in_set_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_LookupUserAliases *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.sids));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.sids");
		return -1;
	}
	object->in.sids = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.sids);
	if (object->in.sids == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&wbint_SidArray_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.sids = (struct wbint_SidArray *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_wbint_LookupUserAliases_out_get_rids(PyObject *obj, void *closure)
{
	struct wbint_LookupUserAliases *object = pytalloc_get_ptr(obj);
	PyObject *py_rids;
	if (object->out.rids == NULL) {
		Py_RETURN_NONE;
	}
	py_rids = pytalloc_reference_ex(&wbint_RidArray_Type, object->out.rids, object->out.rids);
	return py_rids;
}

static int py_wbint_LookupUserAliases_out_set_rids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_LookupUserAliases *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.rids));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.rids");
		return -1;
	}
	object->out.rids = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.rids);
	if (object->out.rids == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&wbint_RidArray_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.rids = (struct wbint_RidArray *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_wbint_LookupUserAliases_get_result(PyObject *obj, void *closure)
{
	struct wbint_LookupUserAliases *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_wbint_LookupUserAliases_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_LookupUserAliases *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wbint_LookupUserAliases_getsetters[] = {
	{
		.name = discard_const_p(char, "in_sids"),
		.get = py_wbint_LookupUserAliases_in_get_sids,
		.set = py_wbint_LookupUserAliases_in_set_sids,
		.doc = discard_const_p(char, "PIDL-generated element of base type wbint_SidArray")
	},
	{
		.name = discard_const_p(char, "out_rids"),
		.get = py_wbint_LookupUserAliases_out_get_rids,
		.set = py_wbint_LookupUserAliases_out_set_rids,
		.doc = discard_const_p(char, "PIDL-generated element of base type wbint_RidArray")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wbint_LookupUserAliases_get_result,
		.set = py_wbint_LookupUserAliases_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_wbint_LookupUserAliases_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wbint_LookupUserAliases, type);
	struct wbint_LookupUserAliases *_self = (struct wbint_LookupUserAliases *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.sids = talloc_zero(mem_ctx, struct wbint_SidArray);
	_self->out.rids = talloc_zero(mem_ctx, struct wbint_RidArray);
	return self;
}

static PyObject *py_wbint_LookupUserAliases_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(9);
}

static PyObject *py_wbint_LookupUserAliases_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_LookupUserAliases *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 10) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_LookupUserAliases_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[9];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wbint_LookupUserAliases_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_LookupUserAliases_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wbint_LookupUserAliases_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_LookupUserAliases_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wbint_LookupUserAliases_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_LookupUserAliases *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 10) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_LookupUserAliases_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[9];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wbint_LookupUserAliases_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_LookupUserAliases_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_LookupUserAliases_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_LookupUserAliases_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_LookupUserAliases_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_LookupUserAliases *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winbind.num_calls < 10) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_LookupUserAliases_ndr_print");
		return NULL;
	}
	call = &ndr_table_winbind.calls[9];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wbint_LookupUserAliases_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_LookupUserAliases_ndr_print(py_obj, args, kwargs, "wbint_LookupUserAliases_in", NDR_IN);
}

static PyObject *py_wbint_LookupUserAliases_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_LookupUserAliases_ndr_print(py_obj, args, kwargs, "wbint_LookupUserAliases_out", NDR_OUT);
}

static PyMethodDef py_wbint_LookupUserAliases_methods[] = {
	{ "opnum", (PyCFunction)py_wbint_LookupUserAliases_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winbind.wbint_LookupUserAliases.opnum() -> 9 (0x09) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupUserAliases_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupUserAliases_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupUserAliases_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupUserAliases_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupUserAliases_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupUserAliases_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wbint_LookupUserAliases_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.wbint_LookupUserAliases",
	.tp_getset = py_wbint_LookupUserAliases_getsetters,
	.tp_methods = py_wbint_LookupUserAliases_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wbint_LookupUserAliases_new,
};

static bool pack_py_wbint_LookupUserAliases_args_in(PyObject *args, PyObject *kwargs, struct wbint_LookupUserAliases *r)
{
	PyObject *py_sids;
	const char *kwnames[] = {
		"sids", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:wbint_LookupUserAliases", discard_const_p(char *, kwnames), &py_sids)) {
		return false;
	}

	if (py_sids == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.sids");
		return false;
	}
	r->in.sids = talloc_ptrtype(r, r->in.sids);
	if (r->in.sids == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&wbint_SidArray_Type, py_sids, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_sids)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.sids = (struct wbint_SidArray *)pytalloc_get_ptr(py_sids);
	return true;
}

static PyObject *unpack_py_wbint_LookupUserAliases_args_out(struct wbint_LookupUserAliases *r, bool raise_result_exception)
{
	PyObject *py_rids = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_rids = pytalloc_reference_ex(&wbint_RidArray_Type, r->out.rids, r->out.rids);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_rids);
	}
	if (result_size == 1) {
		result = py_rids;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_wbint_LookupUserGroups_in_get_sid(PyObject *obj, void *closure)
{
	struct wbint_LookupUserGroups *object = pytalloc_get_ptr(obj);
	PyObject *py_sid;
	if (object->in.sid == NULL) {
		Py_RETURN_NONE;
	}
	py_sid = pytalloc_reference_ex(dom_sid_Type, object->in.sid, object->in.sid);
	return py_sid;
}

static int py_wbint_LookupUserGroups_in_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_LookupUserGroups *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.sid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.sid");
		return -1;
	}
	object->in.sid = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.sid);
	if (object->in.sid == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.sid = (struct dom_sid *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_wbint_LookupUserGroups_out_get_sids(PyObject *obj, void *closure)
{
	struct wbint_LookupUserGroups *object = pytalloc_get_ptr(obj);
	PyObject *py_sids;
	if (object->out.sids == NULL) {
		Py_RETURN_NONE;
	}
	py_sids = pytalloc_reference_ex(&wbint_SidArray_Type, object->out.sids, object->out.sids);
	return py_sids;
}

static int py_wbint_LookupUserGroups_out_set_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_LookupUserGroups *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.sids));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.sids");
		return -1;
	}
	object->out.sids = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.sids);
	if (object->out.sids == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&wbint_SidArray_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.sids = (struct wbint_SidArray *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_wbint_LookupUserGroups_get_result(PyObject *obj, void *closure)
{
	struct wbint_LookupUserGroups *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_wbint_LookupUserGroups_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_LookupUserGroups *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wbint_LookupUserGroups_getsetters[] = {
	{
		.name = discard_const_p(char, "in_sid"),
		.get = py_wbint_LookupUserGroups_in_get_sid,
		.set = py_wbint_LookupUserGroups_in_set_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid")
	},
	{
		.name = discard_const_p(char, "out_sids"),
		.get = py_wbint_LookupUserGroups_out_get_sids,
		.set = py_wbint_LookupUserGroups_out_set_sids,
		.doc = discard_const_p(char, "PIDL-generated element of base type wbint_SidArray")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wbint_LookupUserGroups_get_result,
		.set = py_wbint_LookupUserGroups_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_wbint_LookupUserGroups_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wbint_LookupUserGroups, type);
	struct wbint_LookupUserGroups *_self = (struct wbint_LookupUserGroups *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.sid = talloc_zero(mem_ctx, struct dom_sid);
	_self->out.sids = talloc_zero(mem_ctx, struct wbint_SidArray);
	return self;
}

static PyObject *py_wbint_LookupUserGroups_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(10);
}

static PyObject *py_wbint_LookupUserGroups_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_LookupUserGroups *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 11) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_LookupUserGroups_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[10];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wbint_LookupUserGroups_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_LookupUserGroups_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wbint_LookupUserGroups_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_LookupUserGroups_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wbint_LookupUserGroups_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_LookupUserGroups *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 11) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_LookupUserGroups_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[10];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wbint_LookupUserGroups_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_LookupUserGroups_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_LookupUserGroups_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_LookupUserGroups_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_LookupUserGroups_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_LookupUserGroups *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winbind.num_calls < 11) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_LookupUserGroups_ndr_print");
		return NULL;
	}
	call = &ndr_table_winbind.calls[10];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wbint_LookupUserGroups_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_LookupUserGroups_ndr_print(py_obj, args, kwargs, "wbint_LookupUserGroups_in", NDR_IN);
}

static PyObject *py_wbint_LookupUserGroups_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_LookupUserGroups_ndr_print(py_obj, args, kwargs, "wbint_LookupUserGroups_out", NDR_OUT);
}

static PyMethodDef py_wbint_LookupUserGroups_methods[] = {
	{ "opnum", (PyCFunction)py_wbint_LookupUserGroups_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winbind.wbint_LookupUserGroups.opnum() -> 10 (0x0a) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupUserGroups_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupUserGroups_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupUserGroups_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupUserGroups_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupUserGroups_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupUserGroups_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wbint_LookupUserGroups_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.wbint_LookupUserGroups",
	.tp_getset = py_wbint_LookupUserGroups_getsetters,
	.tp_methods = py_wbint_LookupUserGroups_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wbint_LookupUserGroups_new,
};

static bool pack_py_wbint_LookupUserGroups_args_in(PyObject *args, PyObject *kwargs, struct wbint_LookupUserGroups *r)
{
	PyObject *py_sid;
	const char *kwnames[] = {
		"sid", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:wbint_LookupUserGroups", discard_const_p(char *, kwnames), &py_sid)) {
		return false;
	}

	if (py_sid == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.sid");
		return false;
	}
	r->in.sid = talloc_ptrtype(r, r->in.sid);
	if (r->in.sid == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(dom_sid_Type, py_sid, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_sid)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.sid = (struct dom_sid *)pytalloc_get_ptr(py_sid);
	return true;
}

static PyObject *unpack_py_wbint_LookupUserGroups_args_out(struct wbint_LookupUserGroups *r, bool raise_result_exception)
{
	PyObject *py_sids = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_sids = pytalloc_reference_ex(&wbint_SidArray_Type, r->out.sids, r->out.sids);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_sids);
	}
	if (result_size == 1) {
		result = py_sids;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_wbint_QuerySequenceNumber_out_get_sequence(PyObject *obj, void *closure)
{
	struct wbint_QuerySequenceNumber *object = pytalloc_get_ptr(obj);
	PyObject *py_sequence;
	if (object->out.sequence == NULL) {
		Py_RETURN_NONE;
	}
	py_sequence = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.sequence));
	return py_sequence;
}

static int py_wbint_QuerySequenceNumber_out_set_sequence(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_QuerySequenceNumber *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.sequence));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.sequence");
		return -1;
	}
	object->out.sequence = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.sequence);
	if (object->out.sequence == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.sequence));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.sequence = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wbint_QuerySequenceNumber_get_result(PyObject *obj, void *closure)
{
	struct wbint_QuerySequenceNumber *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_wbint_QuerySequenceNumber_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_QuerySequenceNumber *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wbint_QuerySequenceNumber_getsetters[] = {
	{
		.name = discard_const_p(char, "out_sequence"),
		.get = py_wbint_QuerySequenceNumber_out_get_sequence,
		.set = py_wbint_QuerySequenceNumber_out_set_sequence,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wbint_QuerySequenceNumber_get_result,
		.set = py_wbint_QuerySequenceNumber_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_wbint_QuerySequenceNumber_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wbint_QuerySequenceNumber, type);
	struct wbint_QuerySequenceNumber *_self = (struct wbint_QuerySequenceNumber *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.sequence = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_wbint_QuerySequenceNumber_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(11);
}

static PyObject *py_wbint_QuerySequenceNumber_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_QuerySequenceNumber *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 12) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_QuerySequenceNumber_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[11];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wbint_QuerySequenceNumber_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_QuerySequenceNumber_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wbint_QuerySequenceNumber_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_QuerySequenceNumber_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wbint_QuerySequenceNumber_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_QuerySequenceNumber *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 12) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_QuerySequenceNumber_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[11];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wbint_QuerySequenceNumber_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_QuerySequenceNumber_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_QuerySequenceNumber_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_QuerySequenceNumber_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_QuerySequenceNumber_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_QuerySequenceNumber *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winbind.num_calls < 12) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_QuerySequenceNumber_ndr_print");
		return NULL;
	}
	call = &ndr_table_winbind.calls[11];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wbint_QuerySequenceNumber_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_QuerySequenceNumber_ndr_print(py_obj, args, kwargs, "wbint_QuerySequenceNumber_in", NDR_IN);
}

static PyObject *py_wbint_QuerySequenceNumber_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_QuerySequenceNumber_ndr_print(py_obj, args, kwargs, "wbint_QuerySequenceNumber_out", NDR_OUT);
}

static PyMethodDef py_wbint_QuerySequenceNumber_methods[] = {
	{ "opnum", (PyCFunction)py_wbint_QuerySequenceNumber_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winbind.wbint_QuerySequenceNumber.opnum() -> 11 (0x0b) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_QuerySequenceNumber_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_QuerySequenceNumber_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_QuerySequenceNumber_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_QuerySequenceNumber_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_QuerySequenceNumber_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_QuerySequenceNumber_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wbint_QuerySequenceNumber_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.wbint_QuerySequenceNumber",
	.tp_getset = py_wbint_QuerySequenceNumber_getsetters,
	.tp_methods = py_wbint_QuerySequenceNumber_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wbint_QuerySequenceNumber_new,
};

static bool pack_py_wbint_QuerySequenceNumber_args_in(PyObject *args, PyObject *kwargs, struct wbint_QuerySequenceNumber *r)
{
	const char *kwnames[] = {
		NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":wbint_QuerySequenceNumber", discard_const_p(char *, kwnames))) {
		return false;
	}

	return true;
}

static PyObject *unpack_py_wbint_QuerySequenceNumber_args_out(struct wbint_QuerySequenceNumber *r, bool raise_result_exception)
{
	PyObject *py_sequence = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_sequence = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.sequence));
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_sequence);
	}
	if (result_size == 1) {
		result = py_sequence;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_wbint_LookupGroupMembers_in_get_sid(PyObject *obj, void *closure)
{
	struct wbint_LookupGroupMembers *object = pytalloc_get_ptr(obj);
	PyObject *py_sid;
	if (object->in.sid == NULL) {
		Py_RETURN_NONE;
	}
	py_sid = pytalloc_reference_ex(dom_sid_Type, object->in.sid, object->in.sid);
	return py_sid;
}

static int py_wbint_LookupGroupMembers_in_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_LookupGroupMembers *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.sid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.sid");
		return -1;
	}
	object->in.sid = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.sid);
	if (object->in.sid == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.sid = (struct dom_sid *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_wbint_LookupGroupMembers_in_get_type(PyObject *obj, void *closure)
{
	struct wbint_LookupGroupMembers *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyLong_FromLong((uint16_t)(object->in.type));
	return py_type;
}

static int py_wbint_LookupGroupMembers_in_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_LookupGroupMembers *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wbint_LookupGroupMembers_out_get_members(PyObject *obj, void *closure)
{
	struct wbint_LookupGroupMembers *object = pytalloc_get_ptr(obj);
	PyObject *py_members;
	if (object->out.members == NULL) {
		Py_RETURN_NONE;
	}
	py_members = pytalloc_reference_ex(&wbint_Principals_Type, object->out.members, object->out.members);
	return py_members;
}

static int py_wbint_LookupGroupMembers_out_set_members(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_LookupGroupMembers *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.members));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.members");
		return -1;
	}
	object->out.members = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.members);
	if (object->out.members == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&wbint_Principals_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.members = (struct wbint_Principals *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_wbint_LookupGroupMembers_get_result(PyObject *obj, void *closure)
{
	struct wbint_LookupGroupMembers *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_wbint_LookupGroupMembers_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_LookupGroupMembers *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wbint_LookupGroupMembers_getsetters[] = {
	{
		.name = discard_const_p(char, "in_sid"),
		.get = py_wbint_LookupGroupMembers_in_get_sid,
		.set = py_wbint_LookupGroupMembers_in_set_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid")
	},
	{
		.name = discard_const_p(char, "in_type"),
		.get = py_wbint_LookupGroupMembers_in_get_type,
		.set = py_wbint_LookupGroupMembers_in_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_SidType")
	},
	{
		.name = discard_const_p(char, "out_members"),
		.get = py_wbint_LookupGroupMembers_out_get_members,
		.set = py_wbint_LookupGroupMembers_out_set_members,
		.doc = discard_const_p(char, "PIDL-generated element of base type wbint_Principals")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wbint_LookupGroupMembers_get_result,
		.set = py_wbint_LookupGroupMembers_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_wbint_LookupGroupMembers_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wbint_LookupGroupMembers, type);
	struct wbint_LookupGroupMembers *_self = (struct wbint_LookupGroupMembers *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.sid = talloc_zero(mem_ctx, struct dom_sid);
	_self->out.members = talloc_zero(mem_ctx, struct wbint_Principals);
	return self;
}

static PyObject *py_wbint_LookupGroupMembers_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(12);
}

static PyObject *py_wbint_LookupGroupMembers_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_LookupGroupMembers *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 13) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_LookupGroupMembers_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[12];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wbint_LookupGroupMembers_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_LookupGroupMembers_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wbint_LookupGroupMembers_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_LookupGroupMembers_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wbint_LookupGroupMembers_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_LookupGroupMembers *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 13) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_LookupGroupMembers_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[12];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wbint_LookupGroupMembers_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_LookupGroupMembers_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_LookupGroupMembers_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_LookupGroupMembers_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_LookupGroupMembers_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_LookupGroupMembers *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winbind.num_calls < 13) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_LookupGroupMembers_ndr_print");
		return NULL;
	}
	call = &ndr_table_winbind.calls[12];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wbint_LookupGroupMembers_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_LookupGroupMembers_ndr_print(py_obj, args, kwargs, "wbint_LookupGroupMembers_in", NDR_IN);
}

static PyObject *py_wbint_LookupGroupMembers_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_LookupGroupMembers_ndr_print(py_obj, args, kwargs, "wbint_LookupGroupMembers_out", NDR_OUT);
}

static PyMethodDef py_wbint_LookupGroupMembers_methods[] = {
	{ "opnum", (PyCFunction)py_wbint_LookupGroupMembers_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winbind.wbint_LookupGroupMembers.opnum() -> 12 (0x0c) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupGroupMembers_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupGroupMembers_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupGroupMembers_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupGroupMembers_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupGroupMembers_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupGroupMembers_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wbint_LookupGroupMembers_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.wbint_LookupGroupMembers",
	.tp_getset = py_wbint_LookupGroupMembers_getsetters,
	.tp_methods = py_wbint_LookupGroupMembers_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wbint_LookupGroupMembers_new,
};

static bool pack_py_wbint_LookupGroupMembers_args_in(PyObject *args, PyObject *kwargs, struct wbint_LookupGroupMembers *r)
{
	PyObject *py_sid;
	PyObject *py_type;
	const char *kwnames[] = {
		"sid", "type", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:wbint_LookupGroupMembers", discard_const_p(char *, kwnames), &py_sid, &py_type)) {
		return false;
	}

	if (py_sid == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.sid");
		return false;
	}
	r->in.sid = talloc_ptrtype(r, r->in.sid);
	if (r->in.sid == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(dom_sid_Type, py_sid, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_sid)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.sid = (struct dom_sid *)pytalloc_get_ptr(py_sid);
	if (py_type == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.type");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.type));
		if (PyLong_Check(py_type)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_type);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_wbint_LookupGroupMembers_args_out(struct wbint_LookupGroupMembers *r, bool raise_result_exception)
{
	PyObject *py_members = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_members = pytalloc_reference_ex(&wbint_Principals_Type, r->out.members, r->out.members);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_members);
	}
	if (result_size == 1) {
		result = py_members;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_wbint_LookupAliasMembers_in_get_sid(PyObject *obj, void *closure)
{
	struct wbint_LookupAliasMembers *object = pytalloc_get_ptr(obj);
	PyObject *py_sid;
	if (object->in.sid == NULL) {
		Py_RETURN_NONE;
	}
	py_sid = pytalloc_reference_ex(dom_sid_Type, object->in.sid, object->in.sid);
	return py_sid;
}

static int py_wbint_LookupAliasMembers_in_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_LookupAliasMembers *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.sid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.sid");
		return -1;
	}
	object->in.sid = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.sid);
	if (object->in.sid == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.sid = (struct dom_sid *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_wbint_LookupAliasMembers_in_get_type(PyObject *obj, void *closure)
{
	struct wbint_LookupAliasMembers *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyLong_FromLong((uint16_t)(object->in.type));
	return py_type;
}

static int py_wbint_LookupAliasMembers_in_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_LookupAliasMembers *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wbint_LookupAliasMembers_out_get_sids(PyObject *obj, void *closure)
{
	struct wbint_LookupAliasMembers *object = pytalloc_get_ptr(obj);
	PyObject *py_sids;
	if (object->out.sids == NULL) {
		Py_RETURN_NONE;
	}
	py_sids = pytalloc_reference_ex(&wbint_SidArray_Type, object->out.sids, object->out.sids);
	return py_sids;
}

static int py_wbint_LookupAliasMembers_out_set_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_LookupAliasMembers *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.sids));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.sids");
		return -1;
	}
	object->out.sids = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.sids);
	if (object->out.sids == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&wbint_SidArray_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.sids = (struct wbint_SidArray *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_wbint_LookupAliasMembers_get_result(PyObject *obj, void *closure)
{
	struct wbint_LookupAliasMembers *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_wbint_LookupAliasMembers_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_LookupAliasMembers *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wbint_LookupAliasMembers_getsetters[] = {
	{
		.name = discard_const_p(char, "in_sid"),
		.get = py_wbint_LookupAliasMembers_in_get_sid,
		.set = py_wbint_LookupAliasMembers_in_set_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid")
	},
	{
		.name = discard_const_p(char, "in_type"),
		.get = py_wbint_LookupAliasMembers_in_get_type,
		.set = py_wbint_LookupAliasMembers_in_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_SidType")
	},
	{
		.name = discard_const_p(char, "out_sids"),
		.get = py_wbint_LookupAliasMembers_out_get_sids,
		.set = py_wbint_LookupAliasMembers_out_set_sids,
		.doc = discard_const_p(char, "PIDL-generated element of base type wbint_SidArray")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wbint_LookupAliasMembers_get_result,
		.set = py_wbint_LookupAliasMembers_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_wbint_LookupAliasMembers_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wbint_LookupAliasMembers, type);
	struct wbint_LookupAliasMembers *_self = (struct wbint_LookupAliasMembers *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.sid = talloc_zero(mem_ctx, struct dom_sid);
	_self->out.sids = talloc_zero(mem_ctx, struct wbint_SidArray);
	return self;
}

static PyObject *py_wbint_LookupAliasMembers_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(13);
}

static PyObject *py_wbint_LookupAliasMembers_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_LookupAliasMembers *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 14) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_LookupAliasMembers_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[13];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wbint_LookupAliasMembers_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_LookupAliasMembers_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wbint_LookupAliasMembers_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_LookupAliasMembers_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wbint_LookupAliasMembers_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_LookupAliasMembers *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 14) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_LookupAliasMembers_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[13];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wbint_LookupAliasMembers_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_LookupAliasMembers_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_LookupAliasMembers_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_LookupAliasMembers_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_LookupAliasMembers_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_LookupAliasMembers *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winbind.num_calls < 14) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_LookupAliasMembers_ndr_print");
		return NULL;
	}
	call = &ndr_table_winbind.calls[13];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wbint_LookupAliasMembers_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_LookupAliasMembers_ndr_print(py_obj, args, kwargs, "wbint_LookupAliasMembers_in", NDR_IN);
}

static PyObject *py_wbint_LookupAliasMembers_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_LookupAliasMembers_ndr_print(py_obj, args, kwargs, "wbint_LookupAliasMembers_out", NDR_OUT);
}

static PyMethodDef py_wbint_LookupAliasMembers_methods[] = {
	{ "opnum", (PyCFunction)py_wbint_LookupAliasMembers_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winbind.wbint_LookupAliasMembers.opnum() -> 13 (0x0d) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupAliasMembers_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupAliasMembers_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupAliasMembers_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupAliasMembers_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupAliasMembers_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupAliasMembers_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wbint_LookupAliasMembers_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.wbint_LookupAliasMembers",
	.tp_getset = py_wbint_LookupAliasMembers_getsetters,
	.tp_methods = py_wbint_LookupAliasMembers_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wbint_LookupAliasMembers_new,
};

static bool pack_py_wbint_LookupAliasMembers_args_in(PyObject *args, PyObject *kwargs, struct wbint_LookupAliasMembers *r)
{
	PyObject *py_sid;
	PyObject *py_type;
	const char *kwnames[] = {
		"sid", "type", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:wbint_LookupAliasMembers", discard_const_p(char *, kwnames), &py_sid, &py_type)) {
		return false;
	}

	if (py_sid == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.sid");
		return false;
	}
	r->in.sid = talloc_ptrtype(r, r->in.sid);
	if (r->in.sid == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(dom_sid_Type, py_sid, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_sid)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.sid = (struct dom_sid *)pytalloc_get_ptr(py_sid);
	if (py_type == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.type");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.type));
		if (PyLong_Check(py_type)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_type);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_wbint_LookupAliasMembers_args_out(struct wbint_LookupAliasMembers *r, bool raise_result_exception)
{
	PyObject *py_sids = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_sids = pytalloc_reference_ex(&wbint_SidArray_Type, r->out.sids, r->out.sids);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_sids);
	}
	if (result_size == 1) {
		result = py_sids;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_wbint_QueryGroupList_out_get_groups(PyObject *obj, void *closure)
{
	struct wbint_QueryGroupList *object = pytalloc_get_ptr(obj);
	PyObject *py_groups;
	if (object->out.groups == NULL) {
		Py_RETURN_NONE;
	}
	py_groups = pytalloc_reference_ex(&wbint_Principals_Type, object->out.groups, object->out.groups);
	return py_groups;
}

static int py_wbint_QueryGroupList_out_set_groups(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_QueryGroupList *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.groups));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.groups");
		return -1;
	}
	object->out.groups = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.groups);
	if (object->out.groups == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&wbint_Principals_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.groups = (struct wbint_Principals *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_wbint_QueryGroupList_get_result(PyObject *obj, void *closure)
{
	struct wbint_QueryGroupList *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_wbint_QueryGroupList_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_QueryGroupList *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wbint_QueryGroupList_getsetters[] = {
	{
		.name = discard_const_p(char, "out_groups"),
		.get = py_wbint_QueryGroupList_out_get_groups,
		.set = py_wbint_QueryGroupList_out_set_groups,
		.doc = discard_const_p(char, "PIDL-generated element of base type wbint_Principals")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wbint_QueryGroupList_get_result,
		.set = py_wbint_QueryGroupList_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_wbint_QueryGroupList_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wbint_QueryGroupList, type);
	struct wbint_QueryGroupList *_self = (struct wbint_QueryGroupList *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.groups = talloc_zero(mem_ctx, struct wbint_Principals);
	return self;
}

static PyObject *py_wbint_QueryGroupList_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(14);
}

static PyObject *py_wbint_QueryGroupList_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_QueryGroupList *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 15) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_QueryGroupList_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[14];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wbint_QueryGroupList_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_QueryGroupList_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wbint_QueryGroupList_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_QueryGroupList_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wbint_QueryGroupList_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_QueryGroupList *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 15) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_QueryGroupList_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[14];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wbint_QueryGroupList_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_QueryGroupList_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_QueryGroupList_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_QueryGroupList_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_QueryGroupList_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_QueryGroupList *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winbind.num_calls < 15) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_QueryGroupList_ndr_print");
		return NULL;
	}
	call = &ndr_table_winbind.calls[14];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wbint_QueryGroupList_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_QueryGroupList_ndr_print(py_obj, args, kwargs, "wbint_QueryGroupList_in", NDR_IN);
}

static PyObject *py_wbint_QueryGroupList_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_QueryGroupList_ndr_print(py_obj, args, kwargs, "wbint_QueryGroupList_out", NDR_OUT);
}

static PyMethodDef py_wbint_QueryGroupList_methods[] = {
	{ "opnum", (PyCFunction)py_wbint_QueryGroupList_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winbind.wbint_QueryGroupList.opnum() -> 14 (0x0e) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_QueryGroupList_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_QueryGroupList_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_QueryGroupList_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_QueryGroupList_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_QueryGroupList_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_QueryGroupList_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wbint_QueryGroupList_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.wbint_QueryGroupList",
	.tp_getset = py_wbint_QueryGroupList_getsetters,
	.tp_methods = py_wbint_QueryGroupList_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wbint_QueryGroupList_new,
};

static bool pack_py_wbint_QueryGroupList_args_in(PyObject *args, PyObject *kwargs, struct wbint_QueryGroupList *r)
{
	const char *kwnames[] = {
		NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":wbint_QueryGroupList", discard_const_p(char *, kwnames))) {
		return false;
	}

	return true;
}

static PyObject *unpack_py_wbint_QueryGroupList_args_out(struct wbint_QueryGroupList *r, bool raise_result_exception)
{
	PyObject *py_groups = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_groups = pytalloc_reference_ex(&wbint_Principals_Type, r->out.groups, r->out.groups);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_groups);
	}
	if (result_size == 1) {
		result = py_groups;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_wbint_QueryUserRidList_out_get_rids(PyObject *obj, void *closure)
{
	struct wbint_QueryUserRidList *object = pytalloc_get_ptr(obj);
	PyObject *py_rids;
	if (object->out.rids == NULL) {
		Py_RETURN_NONE;
	}
	py_rids = pytalloc_reference_ex(&wbint_RidArray_Type, object->out.rids, object->out.rids);
	return py_rids;
}

static int py_wbint_QueryUserRidList_out_set_rids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_QueryUserRidList *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.rids));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.rids");
		return -1;
	}
	object->out.rids = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.rids);
	if (object->out.rids == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&wbint_RidArray_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.rids = (struct wbint_RidArray *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_wbint_QueryUserRidList_get_result(PyObject *obj, void *closure)
{
	struct wbint_QueryUserRidList *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_wbint_QueryUserRidList_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_QueryUserRidList *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wbint_QueryUserRidList_getsetters[] = {
	{
		.name = discard_const_p(char, "out_rids"),
		.get = py_wbint_QueryUserRidList_out_get_rids,
		.set = py_wbint_QueryUserRidList_out_set_rids,
		.doc = discard_const_p(char, "PIDL-generated element of base type wbint_RidArray")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wbint_QueryUserRidList_get_result,
		.set = py_wbint_QueryUserRidList_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_wbint_QueryUserRidList_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wbint_QueryUserRidList, type);
	struct wbint_QueryUserRidList *_self = (struct wbint_QueryUserRidList *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.rids = talloc_zero(mem_ctx, struct wbint_RidArray);
	return self;
}

static PyObject *py_wbint_QueryUserRidList_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(15);
}

static PyObject *py_wbint_QueryUserRidList_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_QueryUserRidList *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 16) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_QueryUserRidList_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[15];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wbint_QueryUserRidList_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_QueryUserRidList_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wbint_QueryUserRidList_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_QueryUserRidList_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wbint_QueryUserRidList_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_QueryUserRidList *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 16) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_QueryUserRidList_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[15];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wbint_QueryUserRidList_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_QueryUserRidList_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_QueryUserRidList_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_QueryUserRidList_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_QueryUserRidList_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_QueryUserRidList *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winbind.num_calls < 16) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_QueryUserRidList_ndr_print");
		return NULL;
	}
	call = &ndr_table_winbind.calls[15];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wbint_QueryUserRidList_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_QueryUserRidList_ndr_print(py_obj, args, kwargs, "wbint_QueryUserRidList_in", NDR_IN);
}

static PyObject *py_wbint_QueryUserRidList_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_QueryUserRidList_ndr_print(py_obj, args, kwargs, "wbint_QueryUserRidList_out", NDR_OUT);
}

static PyMethodDef py_wbint_QueryUserRidList_methods[] = {
	{ "opnum", (PyCFunction)py_wbint_QueryUserRidList_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winbind.wbint_QueryUserRidList.opnum() -> 15 (0x0f) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_QueryUserRidList_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_QueryUserRidList_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_QueryUserRidList_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_QueryUserRidList_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_QueryUserRidList_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_QueryUserRidList_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wbint_QueryUserRidList_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.wbint_QueryUserRidList",
	.tp_getset = py_wbint_QueryUserRidList_getsetters,
	.tp_methods = py_wbint_QueryUserRidList_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wbint_QueryUserRidList_new,
};

static bool pack_py_wbint_QueryUserRidList_args_in(PyObject *args, PyObject *kwargs, struct wbint_QueryUserRidList *r)
{
	const char *kwnames[] = {
		NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":wbint_QueryUserRidList", discard_const_p(char *, kwnames))) {
		return false;
	}

	return true;
}

static PyObject *unpack_py_wbint_QueryUserRidList_args_out(struct wbint_QueryUserRidList *r, bool raise_result_exception)
{
	PyObject *py_rids = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_rids = pytalloc_reference_ex(&wbint_RidArray_Type, r->out.rids, r->out.rids);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_rids);
	}
	if (result_size == 1) {
		result = py_rids;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_wbint_DsGetDcName_in_get_domain_name(PyObject *obj, void *closure)
{
	struct wbint_DsGetDcName *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	if (object->in.domain_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.domain_name == NULL) {
		py_domain_name = Py_None;
		Py_INCREF(py_domain_name);
	} else {
		py_domain_name = PyUnicode_Decode(object->in.domain_name, strlen(object->in.domain_name), "utf-8", "ignore");
	}
	return py_domain_name;
}

static int py_wbint_DsGetDcName_in_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_DsGetDcName *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.domain_name");
		return -1;
	}
	object->in.domain_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.domain_name);
	if (object->in.domain_name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.domain_name = talloc_str;
	}
	return 0;
}

static PyObject *py_wbint_DsGetDcName_in_get_domain_guid(PyObject *obj, void *closure)
{
	struct wbint_DsGetDcName *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_guid;
	if (object->in.domain_guid == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.domain_guid == NULL) {
		py_domain_guid = Py_None;
		Py_INCREF(py_domain_guid);
	} else {
		py_domain_guid = pytalloc_reference_ex(GUID_Type, object->in.domain_guid, object->in.domain_guid);
	}
	return py_domain_guid;
}

static int py_wbint_DsGetDcName_in_set_domain_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_DsGetDcName *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.domain_guid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.domain_guid");
		return -1;
	}
	if (value == Py_None) {
		object->in.domain_guid = NULL;
	} else {
		object->in.domain_guid = NULL;
		PY_CHECK_TYPE(GUID_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.domain_guid = (struct GUID *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_wbint_DsGetDcName_in_get_site_name(PyObject *obj, void *closure)
{
	struct wbint_DsGetDcName *object = pytalloc_get_ptr(obj);
	PyObject *py_site_name;
	if (object->in.site_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.site_name == NULL) {
		py_site_name = Py_None;
		Py_INCREF(py_site_name);
	} else {
		if (object->in.site_name == NULL) {
			py_site_name = Py_None;
			Py_INCREF(py_site_name);
		} else {
			py_site_name = PyUnicode_Decode(object->in.site_name, strlen(object->in.site_name), "utf-8", "ignore");
		}
	}
	return py_site_name;
}

static int py_wbint_DsGetDcName_in_set_site_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_DsGetDcName *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.site_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.site_name = NULL;
	} else {
		object->in.site_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.site_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wbint_DsGetDcName_in_get_flags(PyObject *obj, void *closure)
{
	struct wbint_DsGetDcName *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->in.flags));
	return py_flags;
}

static int py_wbint_DsGetDcName_in_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_DsGetDcName *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wbint_DsGetDcName_out_get_dc_info(PyObject *obj, void *closure)
{
	struct wbint_DsGetDcName *object = pytalloc_get_ptr(obj);
	PyObject *py_dc_info;
	if (object->out.dc_info == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.dc_info == NULL) {
		py_dc_info = Py_None;
		Py_INCREF(py_dc_info);
	} else {
		py_dc_info = pytalloc_reference_ex(netr_DsRGetDCNameInfo_Type, *object->out.dc_info, *object->out.dc_info);
	}
	return py_dc_info;
}

static int py_wbint_DsGetDcName_out_set_dc_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_DsGetDcName *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.dc_info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.dc_info");
		return -1;
	}
	object->out.dc_info = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.dc_info);
	if (object->out.dc_info == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.dc_info = NULL;
	} else {
		*object->out.dc_info = NULL;
		PY_CHECK_TYPE(netr_DsRGetDCNameInfo_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		*object->out.dc_info = (struct netr_DsRGetDCNameInfo *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_wbint_DsGetDcName_get_result(PyObject *obj, void *closure)
{
	struct wbint_DsGetDcName *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_wbint_DsGetDcName_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_DsGetDcName *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wbint_DsGetDcName_getsetters[] = {
	{
		.name = discard_const_p(char, "in_domain_name"),
		.get = py_wbint_DsGetDcName_in_get_domain_name,
		.set = py_wbint_DsGetDcName_in_set_domain_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_domain_guid"),
		.get = py_wbint_DsGetDcName_in_get_domain_guid,
		.set = py_wbint_DsGetDcName_in_set_domain_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "in_site_name"),
		.get = py_wbint_DsGetDcName_in_get_site_name,
		.set = py_wbint_DsGetDcName_in_set_site_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_flags"),
		.get = py_wbint_DsGetDcName_in_get_flags,
		.set = py_wbint_DsGetDcName_in_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_dc_info"),
		.get = py_wbint_DsGetDcName_out_get_dc_info,
		.set = py_wbint_DsGetDcName_out_set_dc_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_DsRGetDCNameInfo")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wbint_DsGetDcName_get_result,
		.set = py_wbint_DsGetDcName_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_wbint_DsGetDcName_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wbint_DsGetDcName, type);
	struct wbint_DsGetDcName *_self = (struct wbint_DsGetDcName *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	/* a pointer to a NULL pointer */
	_self->out.dc_info = talloc_zero(mem_ctx, struct netr_DsRGetDCNameInfo *);
	return self;
}

static PyObject *py_wbint_DsGetDcName_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(16);
}

static PyObject *py_wbint_DsGetDcName_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_DsGetDcName *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 17) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_DsGetDcName_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[16];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wbint_DsGetDcName_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_DsGetDcName_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wbint_DsGetDcName_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_DsGetDcName_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wbint_DsGetDcName_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_DsGetDcName *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 17) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_DsGetDcName_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[16];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wbint_DsGetDcName_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_DsGetDcName_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_DsGetDcName_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_DsGetDcName_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_DsGetDcName_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_DsGetDcName *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winbind.num_calls < 17) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_DsGetDcName_ndr_print");
		return NULL;
	}
	call = &ndr_table_winbind.calls[16];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wbint_DsGetDcName_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_DsGetDcName_ndr_print(py_obj, args, kwargs, "wbint_DsGetDcName_in", NDR_IN);
}

static PyObject *py_wbint_DsGetDcName_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_DsGetDcName_ndr_print(py_obj, args, kwargs, "wbint_DsGetDcName_out", NDR_OUT);
}

static PyMethodDef py_wbint_DsGetDcName_methods[] = {
	{ "opnum", (PyCFunction)py_wbint_DsGetDcName_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winbind.wbint_DsGetDcName.opnum() -> 16 (0x10) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_DsGetDcName_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_DsGetDcName_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_DsGetDcName_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_DsGetDcName_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_DsGetDcName_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_DsGetDcName_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wbint_DsGetDcName_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.wbint_DsGetDcName",
	.tp_getset = py_wbint_DsGetDcName_getsetters,
	.tp_methods = py_wbint_DsGetDcName_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wbint_DsGetDcName_new,
};

static bool pack_py_wbint_DsGetDcName_args_in(PyObject *args, PyObject *kwargs, struct wbint_DsGetDcName *r)
{
	PyObject *py_domain_name;
	PyObject *py_domain_guid;
	PyObject *py_site_name;
	PyObject *py_flags;
	const char *kwnames[] = {
		"domain_name", "domain_guid", "site_name", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:wbint_DsGetDcName", discard_const_p(char *, kwnames), &py_domain_name, &py_domain_guid, &py_site_name, &py_flags)) {
		return false;
	}

	if (py_domain_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.domain_name");
		return false;
	}
	r->in.domain_name = talloc_ptrtype(r, r->in.domain_name);
	if (r->in.domain_name == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_domain_name)) {
			unicode = PyUnicode_AsEncodedString(py_domain_name, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_domain_name)) {
			test_str = PyBytes_AS_STRING(py_domain_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_domain_name)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.domain_name = talloc_str;
	}
	if (py_domain_guid == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.domain_guid");
		return false;
	}
	if (py_domain_guid == Py_None) {
		r->in.domain_guid = NULL;
	} else {
		r->in.domain_guid = NULL;
		PY_CHECK_TYPE(GUID_Type, py_domain_guid, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_domain_guid)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.domain_guid = (struct GUID *)pytalloc_get_ptr(py_domain_guid);
	}
	if (py_site_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.site_name");
		return false;
	}
	if (py_site_name == Py_None) {
		r->in.site_name = NULL;
	} else {
		r->in.site_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_site_name)) {
				unicode = PyUnicode_AsEncodedString(py_site_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_site_name)) {
				test_str = PyBytes_AS_STRING(py_site_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_site_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.site_name = talloc_str;
		}
	}
	if (py_flags == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.flags");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.flags));
		if (PyLong_Check(py_flags)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_flags);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_wbint_DsGetDcName_args_out(struct wbint_DsGetDcName *r, bool raise_result_exception)
{
	PyObject *py_dc_info = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	if (*r->out.dc_info == NULL) {
		py_dc_info = Py_None;
		Py_INCREF(py_dc_info);
	} else {
		py_dc_info = pytalloc_reference_ex(netr_DsRGetDCNameInfo_Type, *r->out.dc_info, *r->out.dc_info);
	}
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_dc_info);
	}
	if (result_size == 1) {
		result = py_dc_info;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_wbint_LookupRids_in_get_domain_sid(PyObject *obj, void *closure)
{
	struct wbint_LookupRids *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_sid;
	if (object->in.domain_sid == NULL) {
		Py_RETURN_NONE;
	}
	py_domain_sid = pytalloc_reference_ex(dom_sid_Type, object->in.domain_sid, object->in.domain_sid);
	return py_domain_sid;
}

static int py_wbint_LookupRids_in_set_domain_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_LookupRids *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.domain_sid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.domain_sid");
		return -1;
	}
	object->in.domain_sid = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.domain_sid);
	if (object->in.domain_sid == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.domain_sid = (struct dom_sid *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_wbint_LookupRids_in_get_rids(PyObject *obj, void *closure)
{
	struct wbint_LookupRids *object = pytalloc_get_ptr(obj);
	PyObject *py_rids;
	if (object->in.rids == NULL) {
		Py_RETURN_NONE;
	}
	py_rids = pytalloc_reference_ex(&wbint_RidArray_Type, object->in.rids, object->in.rids);
	return py_rids;
}

static int py_wbint_LookupRids_in_set_rids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_LookupRids *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.rids));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.rids");
		return -1;
	}
	object->in.rids = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.rids);
	if (object->in.rids == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&wbint_RidArray_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.rids = (struct wbint_RidArray *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_wbint_LookupRids_out_get_domain_name(PyObject *obj, void *closure)
{
	struct wbint_LookupRids *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	if (object->out.domain_name == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.domain_name == NULL) {
		py_domain_name = Py_None;
		Py_INCREF(py_domain_name);
	} else {
		if (*object->out.domain_name == NULL) {
			py_domain_name = Py_None;
			Py_INCREF(py_domain_name);
		} else {
			py_domain_name = PyUnicode_Decode(*object->out.domain_name, strlen(*object->out.domain_name), "utf-8", "ignore");
		}
	}
	return py_domain_name;
}

static int py_wbint_LookupRids_out_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_LookupRids *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.domain_name));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.domain_name");
		return -1;
	}
	object->out.domain_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.domain_name);
	if (object->out.domain_name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.domain_name = NULL;
	} else {
		*object->out.domain_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			*object->out.domain_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wbint_LookupRids_out_get_names(PyObject *obj, void *closure)
{
	struct wbint_LookupRids *object = pytalloc_get_ptr(obj);
	PyObject *py_names;
	if (object->out.names == NULL) {
		Py_RETURN_NONE;
	}
	py_names = pytalloc_reference_ex(&wbint_Principals_Type, object->out.names, object->out.names);
	return py_names;
}

static int py_wbint_LookupRids_out_set_names(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_LookupRids *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.names));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.names");
		return -1;
	}
	object->out.names = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.names);
	if (object->out.names == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&wbint_Principals_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.names = (struct wbint_Principals *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_wbint_LookupRids_get_result(PyObject *obj, void *closure)
{
	struct wbint_LookupRids *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_wbint_LookupRids_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_LookupRids *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wbint_LookupRids_getsetters[] = {
	{
		.name = discard_const_p(char, "in_domain_sid"),
		.get = py_wbint_LookupRids_in_get_domain_sid,
		.set = py_wbint_LookupRids_in_set_domain_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid")
	},
	{
		.name = discard_const_p(char, "in_rids"),
		.get = py_wbint_LookupRids_in_get_rids,
		.set = py_wbint_LookupRids_in_set_rids,
		.doc = discard_const_p(char, "PIDL-generated element of base type wbint_RidArray")
	},
	{
		.name = discard_const_p(char, "out_domain_name"),
		.get = py_wbint_LookupRids_out_get_domain_name,
		.set = py_wbint_LookupRids_out_set_domain_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "out_names"),
		.get = py_wbint_LookupRids_out_get_names,
		.set = py_wbint_LookupRids_out_set_names,
		.doc = discard_const_p(char, "PIDL-generated element of base type wbint_Principals")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wbint_LookupRids_get_result,
		.set = py_wbint_LookupRids_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_wbint_LookupRids_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wbint_LookupRids, type);
	struct wbint_LookupRids *_self = (struct wbint_LookupRids *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.domain_sid = talloc_zero(mem_ctx, struct dom_sid);
	_self->in.rids = talloc_zero(mem_ctx, struct wbint_RidArray);
	_self->out.names = talloc_zero(mem_ctx, struct wbint_Principals);
	return self;
}

static PyObject *py_wbint_LookupRids_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(17);
}

static PyObject *py_wbint_LookupRids_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_LookupRids *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 18) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_LookupRids_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[17];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wbint_LookupRids_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_LookupRids_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wbint_LookupRids_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_LookupRids_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wbint_LookupRids_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_LookupRids *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 18) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_LookupRids_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[17];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wbint_LookupRids_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_LookupRids_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_LookupRids_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_LookupRids_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_LookupRids_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_LookupRids *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winbind.num_calls < 18) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_LookupRids_ndr_print");
		return NULL;
	}
	call = &ndr_table_winbind.calls[17];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wbint_LookupRids_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_LookupRids_ndr_print(py_obj, args, kwargs, "wbint_LookupRids_in", NDR_IN);
}

static PyObject *py_wbint_LookupRids_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_LookupRids_ndr_print(py_obj, args, kwargs, "wbint_LookupRids_out", NDR_OUT);
}

static PyMethodDef py_wbint_LookupRids_methods[] = {
	{ "opnum", (PyCFunction)py_wbint_LookupRids_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winbind.wbint_LookupRids.opnum() -> 17 (0x11) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupRids_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupRids_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupRids_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupRids_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupRids_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_LookupRids_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wbint_LookupRids_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.wbint_LookupRids",
	.tp_getset = py_wbint_LookupRids_getsetters,
	.tp_methods = py_wbint_LookupRids_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wbint_LookupRids_new,
};

static bool pack_py_wbint_LookupRids_args_in(PyObject *args, PyObject *kwargs, struct wbint_LookupRids *r)
{
	PyObject *py_domain_sid;
	PyObject *py_rids;
	const char *kwnames[] = {
		"domain_sid", "rids", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:wbint_LookupRids", discard_const_p(char *, kwnames), &py_domain_sid, &py_rids)) {
		return false;
	}

	if (py_domain_sid == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.domain_sid");
		return false;
	}
	r->in.domain_sid = talloc_ptrtype(r, r->in.domain_sid);
	if (r->in.domain_sid == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(dom_sid_Type, py_domain_sid, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_domain_sid)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.domain_sid = (struct dom_sid *)pytalloc_get_ptr(py_domain_sid);
	if (py_rids == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.rids");
		return false;
	}
	r->in.rids = talloc_ptrtype(r, r->in.rids);
	if (r->in.rids == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&wbint_RidArray_Type, py_rids, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_rids)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.rids = (struct wbint_RidArray *)pytalloc_get_ptr(py_rids);
	return true;
}

static PyObject *unpack_py_wbint_LookupRids_args_out(struct wbint_LookupRids *r, bool raise_result_exception)
{
	PyObject *py_domain_name = NULL;
	PyObject *py_names = NULL;
	PyObject *result = NULL;
	size_t result_size = 2;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	if (*r->out.domain_name == NULL) {
		py_domain_name = Py_None;
		Py_INCREF(py_domain_name);
	} else {
		if (*r->out.domain_name == NULL) {
			py_domain_name = Py_None;
			Py_INCREF(py_domain_name);
		} else {
			py_domain_name = PyUnicode_Decode(*r->out.domain_name, strlen(*r->out.domain_name), "utf-8", "ignore");
		}
	}
	PyTuple_SetItem(result, 0, py_domain_name);

	py_names = pytalloc_reference_ex(&wbint_Principals_Type, r->out.names, r->out.names);
	PyTuple_SetItem(result, 1, py_names);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 2, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_wbint_CheckMachineAccount_get_result(PyObject *obj, void *closure)
{
	struct wbint_CheckMachineAccount *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_wbint_CheckMachineAccount_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_CheckMachineAccount *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wbint_CheckMachineAccount_getsetters[] = {
	{
		.name = discard_const_p(char, "result"),
		.get = py_wbint_CheckMachineAccount_get_result,
		.set = py_wbint_CheckMachineAccount_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_wbint_CheckMachineAccount_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wbint_CheckMachineAccount, type);
	return self;
}

static PyObject *py_wbint_CheckMachineAccount_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(18);
}

static PyObject *py_wbint_CheckMachineAccount_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_CheckMachineAccount *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 19) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_CheckMachineAccount_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[18];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wbint_CheckMachineAccount_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_CheckMachineAccount_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wbint_CheckMachineAccount_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_CheckMachineAccount_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wbint_CheckMachineAccount_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_CheckMachineAccount *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 19) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_CheckMachineAccount_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[18];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wbint_CheckMachineAccount_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_CheckMachineAccount_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_CheckMachineAccount_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_CheckMachineAccount_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_CheckMachineAccount_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_CheckMachineAccount *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winbind.num_calls < 19) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_CheckMachineAccount_ndr_print");
		return NULL;
	}
	call = &ndr_table_winbind.calls[18];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wbint_CheckMachineAccount_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_CheckMachineAccount_ndr_print(py_obj, args, kwargs, "wbint_CheckMachineAccount_in", NDR_IN);
}

static PyObject *py_wbint_CheckMachineAccount_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_CheckMachineAccount_ndr_print(py_obj, args, kwargs, "wbint_CheckMachineAccount_out", NDR_OUT);
}

static PyMethodDef py_wbint_CheckMachineAccount_methods[] = {
	{ "opnum", (PyCFunction)py_wbint_CheckMachineAccount_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winbind.wbint_CheckMachineAccount.opnum() -> 18 (0x12) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_CheckMachineAccount_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_CheckMachineAccount_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_CheckMachineAccount_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_CheckMachineAccount_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_CheckMachineAccount_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_CheckMachineAccount_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wbint_CheckMachineAccount_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.wbint_CheckMachineAccount",
	.tp_getset = py_wbint_CheckMachineAccount_getsetters,
	.tp_methods = py_wbint_CheckMachineAccount_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wbint_CheckMachineAccount_new,
};

static bool pack_py_wbint_CheckMachineAccount_args_in(PyObject *args, PyObject *kwargs, struct wbint_CheckMachineAccount *r)
{
	const char *kwnames[] = {
		NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":wbint_CheckMachineAccount", discard_const_p(char *, kwnames))) {
		return false;
	}

	return true;
}

static PyObject *unpack_py_wbint_CheckMachineAccount_args_out(struct wbint_CheckMachineAccount *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromNTSTATUS(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_wbint_ChangeMachineAccount_in_get_dcname(PyObject *obj, void *closure)
{
	struct wbint_ChangeMachineAccount *object = pytalloc_get_ptr(obj);
	PyObject *py_dcname;
	if (object->in.dcname == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.dcname == NULL) {
		py_dcname = Py_None;
		Py_INCREF(py_dcname);
	} else {
		if (object->in.dcname == NULL) {
			py_dcname = Py_None;
			Py_INCREF(py_dcname);
		} else {
			py_dcname = PyUnicode_Decode(object->in.dcname, strlen(object->in.dcname), "utf-8", "ignore");
		}
	}
	return py_dcname;
}

static int py_wbint_ChangeMachineAccount_in_set_dcname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_ChangeMachineAccount *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.dcname");
		return -1;
	}
	if (value == Py_None) {
		object->in.dcname = NULL;
	} else {
		object->in.dcname = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.dcname = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wbint_ChangeMachineAccount_get_result(PyObject *obj, void *closure)
{
	struct wbint_ChangeMachineAccount *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_wbint_ChangeMachineAccount_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_ChangeMachineAccount *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wbint_ChangeMachineAccount_getsetters[] = {
	{
		.name = discard_const_p(char, "in_dcname"),
		.get = py_wbint_ChangeMachineAccount_in_get_dcname,
		.set = py_wbint_ChangeMachineAccount_in_set_dcname,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wbint_ChangeMachineAccount_get_result,
		.set = py_wbint_ChangeMachineAccount_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_wbint_ChangeMachineAccount_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wbint_ChangeMachineAccount, type);
	return self;
}

static PyObject *py_wbint_ChangeMachineAccount_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(19);
}

static PyObject *py_wbint_ChangeMachineAccount_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_ChangeMachineAccount *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 20) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_ChangeMachineAccount_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[19];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wbint_ChangeMachineAccount_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_ChangeMachineAccount_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wbint_ChangeMachineAccount_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_ChangeMachineAccount_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wbint_ChangeMachineAccount_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_ChangeMachineAccount *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 20) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_ChangeMachineAccount_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[19];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wbint_ChangeMachineAccount_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_ChangeMachineAccount_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_ChangeMachineAccount_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_ChangeMachineAccount_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_ChangeMachineAccount_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_ChangeMachineAccount *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winbind.num_calls < 20) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_ChangeMachineAccount_ndr_print");
		return NULL;
	}
	call = &ndr_table_winbind.calls[19];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wbint_ChangeMachineAccount_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_ChangeMachineAccount_ndr_print(py_obj, args, kwargs, "wbint_ChangeMachineAccount_in", NDR_IN);
}

static PyObject *py_wbint_ChangeMachineAccount_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_ChangeMachineAccount_ndr_print(py_obj, args, kwargs, "wbint_ChangeMachineAccount_out", NDR_OUT);
}

static PyMethodDef py_wbint_ChangeMachineAccount_methods[] = {
	{ "opnum", (PyCFunction)py_wbint_ChangeMachineAccount_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winbind.wbint_ChangeMachineAccount.opnum() -> 19 (0x13) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_ChangeMachineAccount_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_ChangeMachineAccount_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_ChangeMachineAccount_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_ChangeMachineAccount_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_ChangeMachineAccount_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_ChangeMachineAccount_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wbint_ChangeMachineAccount_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.wbint_ChangeMachineAccount",
	.tp_getset = py_wbint_ChangeMachineAccount_getsetters,
	.tp_methods = py_wbint_ChangeMachineAccount_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wbint_ChangeMachineAccount_new,
};

static bool pack_py_wbint_ChangeMachineAccount_args_in(PyObject *args, PyObject *kwargs, struct wbint_ChangeMachineAccount *r)
{
	PyObject *py_dcname;
	const char *kwnames[] = {
		"dcname", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:wbint_ChangeMachineAccount", discard_const_p(char *, kwnames), &py_dcname)) {
		return false;
	}

	if (py_dcname == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.dcname");
		return false;
	}
	if (py_dcname == Py_None) {
		r->in.dcname = NULL;
	} else {
		r->in.dcname = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_dcname)) {
				unicode = PyUnicode_AsEncodedString(py_dcname, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_dcname)) {
				test_str = PyBytes_AS_STRING(py_dcname);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_dcname)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.dcname = talloc_str;
		}
	}
	return true;
}

static PyObject *unpack_py_wbint_ChangeMachineAccount_args_out(struct wbint_ChangeMachineAccount *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromNTSTATUS(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_wbint_PingDc_out_get_dcname(PyObject *obj, void *closure)
{
	struct wbint_PingDc *object = pytalloc_get_ptr(obj);
	PyObject *py_dcname;
	if (object->out.dcname == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.dcname == NULL) {
		py_dcname = Py_None;
		Py_INCREF(py_dcname);
	} else {
		if (*object->out.dcname == NULL) {
			py_dcname = Py_None;
			Py_INCREF(py_dcname);
		} else {
			py_dcname = PyUnicode_Decode(*object->out.dcname, strlen(*object->out.dcname), "utf-8", "ignore");
		}
	}
	return py_dcname;
}

static int py_wbint_PingDc_out_set_dcname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PingDc *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.dcname));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.dcname");
		return -1;
	}
	object->out.dcname = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.dcname);
	if (object->out.dcname == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.dcname = NULL;
	} else {
		*object->out.dcname = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			*object->out.dcname = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wbint_PingDc_get_result(PyObject *obj, void *closure)
{
	struct wbint_PingDc *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_wbint_PingDc_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PingDc *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wbint_PingDc_getsetters[] = {
	{
		.name = discard_const_p(char, "out_dcname"),
		.get = py_wbint_PingDc_out_get_dcname,
		.set = py_wbint_PingDc_out_set_dcname,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wbint_PingDc_get_result,
		.set = py_wbint_PingDc_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_wbint_PingDc_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wbint_PingDc, type);
	return self;
}

static PyObject *py_wbint_PingDc_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(20);
}

static PyObject *py_wbint_PingDc_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_PingDc *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 21) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_PingDc_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[20];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wbint_PingDc_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_PingDc_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wbint_PingDc_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_PingDc_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wbint_PingDc_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_PingDc *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 21) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_PingDc_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[20];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wbint_PingDc_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_PingDc_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_PingDc_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_PingDc_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_PingDc_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_PingDc *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winbind.num_calls < 21) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_PingDc_ndr_print");
		return NULL;
	}
	call = &ndr_table_winbind.calls[20];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wbint_PingDc_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_PingDc_ndr_print(py_obj, args, kwargs, "wbint_PingDc_in", NDR_IN);
}

static PyObject *py_wbint_PingDc_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_PingDc_ndr_print(py_obj, args, kwargs, "wbint_PingDc_out", NDR_OUT);
}

static PyMethodDef py_wbint_PingDc_methods[] = {
	{ "opnum", (PyCFunction)py_wbint_PingDc_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winbind.wbint_PingDc.opnum() -> 20 (0x14) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_PingDc_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_PingDc_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_PingDc_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_PingDc_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_PingDc_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_PingDc_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wbint_PingDc_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.wbint_PingDc",
	.tp_getset = py_wbint_PingDc_getsetters,
	.tp_methods = py_wbint_PingDc_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wbint_PingDc_new,
};

static bool pack_py_wbint_PingDc_args_in(PyObject *args, PyObject *kwargs, struct wbint_PingDc *r)
{
	const char *kwnames[] = {
		NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":wbint_PingDc", discard_const_p(char *, kwnames))) {
		return false;
	}

	return true;
}

static PyObject *unpack_py_wbint_PingDc_args_out(struct wbint_PingDc *r, bool raise_result_exception)
{
	PyObject *py_dcname = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	if (*r->out.dcname == NULL) {
		py_dcname = Py_None;
		Py_INCREF(py_dcname);
	} else {
		if (*r->out.dcname == NULL) {
			py_dcname = Py_None;
			Py_INCREF(py_dcname);
		} else {
			py_dcname = PyUnicode_Decode(*r->out.dcname, strlen(*r->out.dcname), "utf-8", "ignore");
		}
	}
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_dcname);
	}
	if (result_size == 1) {
		result = py_dcname;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_wbint_ListTrustedDomains_in_get_client_name(PyObject *obj, void *closure)
{
	struct wbint_ListTrustedDomains *object = pytalloc_get_ptr(obj);
	PyObject *py_client_name;
	if (object->in.client_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.client_name == NULL) {
		py_client_name = Py_None;
		Py_INCREF(py_client_name);
	} else {
		py_client_name = PyUnicode_Decode(object->in.client_name, strlen(object->in.client_name), "utf-8", "ignore");
	}
	return py_client_name;
}

static int py_wbint_ListTrustedDomains_in_set_client_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_ListTrustedDomains *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.client_name");
		return -1;
	}
	object->in.client_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.client_name);
	if (object->in.client_name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.client_name = talloc_str;
	}
	return 0;
}

static PyObject *py_wbint_ListTrustedDomains_in_get_client_pid(PyObject *obj, void *closure)
{
	struct wbint_ListTrustedDomains *object = pytalloc_get_ptr(obj);
	PyObject *py_client_pid;
	py_client_pid = PyLong_FromUnsignedLongLong(object->in.client_pid);
	return py_client_pid;
}

static int py_wbint_ListTrustedDomains_in_set_client_pid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_ListTrustedDomains *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.client_pid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.client_pid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.client_pid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wbint_ListTrustedDomains_out_get_domains(PyObject *obj, void *closure)
{
	struct wbint_ListTrustedDomains *object = pytalloc_get_ptr(obj);
	PyObject *py_domains;
	if (object->out.domains == NULL) {
		Py_RETURN_NONE;
	}
	py_domains = pytalloc_reference_ex(netr_DomainTrustList_Type, object->out.domains, object->out.domains);
	return py_domains;
}

static int py_wbint_ListTrustedDomains_out_set_domains(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_ListTrustedDomains *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.domains));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.domains");
		return -1;
	}
	object->out.domains = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.domains);
	if (object->out.domains == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(netr_DomainTrustList_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.domains = (struct netr_DomainTrustList *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_wbint_ListTrustedDomains_get_result(PyObject *obj, void *closure)
{
	struct wbint_ListTrustedDomains *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_wbint_ListTrustedDomains_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_ListTrustedDomains *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wbint_ListTrustedDomains_getsetters[] = {
	{
		.name = discard_const_p(char, "in_client_name"),
		.get = py_wbint_ListTrustedDomains_in_get_client_name,
		.set = py_wbint_ListTrustedDomains_in_set_client_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_client_pid"),
		.get = py_wbint_ListTrustedDomains_in_get_client_pid,
		.set = py_wbint_ListTrustedDomains_in_set_client_pid,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "out_domains"),
		.get = py_wbint_ListTrustedDomains_out_get_domains,
		.set = py_wbint_ListTrustedDomains_out_set_domains,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_DomainTrustList")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wbint_ListTrustedDomains_get_result,
		.set = py_wbint_ListTrustedDomains_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_wbint_ListTrustedDomains_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wbint_ListTrustedDomains, type);
	struct wbint_ListTrustedDomains *_self = (struct wbint_ListTrustedDomains *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.domains = talloc_zero(mem_ctx, struct netr_DomainTrustList);
	return self;
}

static PyObject *py_wbint_ListTrustedDomains_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(21);
}

static PyObject *py_wbint_ListTrustedDomains_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_ListTrustedDomains *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 22) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_ListTrustedDomains_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[21];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wbint_ListTrustedDomains_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_ListTrustedDomains_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wbint_ListTrustedDomains_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_ListTrustedDomains_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wbint_ListTrustedDomains_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_ListTrustedDomains *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 22) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_ListTrustedDomains_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[21];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wbint_ListTrustedDomains_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_ListTrustedDomains_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_ListTrustedDomains_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_ListTrustedDomains_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_ListTrustedDomains_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_ListTrustedDomains *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winbind.num_calls < 22) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_ListTrustedDomains_ndr_print");
		return NULL;
	}
	call = &ndr_table_winbind.calls[21];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wbint_ListTrustedDomains_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_ListTrustedDomains_ndr_print(py_obj, args, kwargs, "wbint_ListTrustedDomains_in", NDR_IN);
}

static PyObject *py_wbint_ListTrustedDomains_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_ListTrustedDomains_ndr_print(py_obj, args, kwargs, "wbint_ListTrustedDomains_out", NDR_OUT);
}

static PyMethodDef py_wbint_ListTrustedDomains_methods[] = {
	{ "opnum", (PyCFunction)py_wbint_ListTrustedDomains_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winbind.wbint_ListTrustedDomains.opnum() -> 21 (0x15) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_ListTrustedDomains_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_ListTrustedDomains_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_ListTrustedDomains_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_ListTrustedDomains_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_ListTrustedDomains_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_ListTrustedDomains_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wbint_ListTrustedDomains_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.wbint_ListTrustedDomains",
	.tp_getset = py_wbint_ListTrustedDomains_getsetters,
	.tp_methods = py_wbint_ListTrustedDomains_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wbint_ListTrustedDomains_new,
};

static bool pack_py_wbint_ListTrustedDomains_args_in(PyObject *args, PyObject *kwargs, struct wbint_ListTrustedDomains *r)
{
	PyObject *py_client_name;
	PyObject *py_client_pid;
	const char *kwnames[] = {
		"client_name", "client_pid", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:wbint_ListTrustedDomains", discard_const_p(char *, kwnames), &py_client_name, &py_client_pid)) {
		return false;
	}

	if (py_client_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.client_name");
		return false;
	}
	r->in.client_name = talloc_ptrtype(r, r->in.client_name);
	if (r->in.client_name == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_client_name)) {
			unicode = PyUnicode_AsEncodedString(py_client_name, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_client_name)) {
			test_str = PyBytes_AS_STRING(py_client_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_client_name)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.client_name = talloc_str;
	}
	if (py_client_pid == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.client_pid");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.client_pid));
		if (PyLong_Check(py_client_pid)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_client_pid);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.client_pid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_wbint_ListTrustedDomains_args_out(struct wbint_ListTrustedDomains *r, bool raise_result_exception)
{
	PyObject *py_domains = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_domains = pytalloc_reference_ex(netr_DomainTrustList_Type, r->out.domains, r->out.domains);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_domains);
	}
	if (result_size == 1) {
		result = py_domains;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_wbint_PamAuth_in_get_client_name(PyObject *obj, void *closure)
{
	struct wbint_PamAuth *object = pytalloc_get_ptr(obj);
	PyObject *py_client_name;
	if (object->in.client_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.client_name == NULL) {
		py_client_name = Py_None;
		Py_INCREF(py_client_name);
	} else {
		py_client_name = PyUnicode_Decode(object->in.client_name, strlen(object->in.client_name), "utf-8", "ignore");
	}
	return py_client_name;
}

static int py_wbint_PamAuth_in_set_client_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamAuth *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.client_name");
		return -1;
	}
	object->in.client_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.client_name);
	if (object->in.client_name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.client_name = talloc_str;
	}
	return 0;
}

static PyObject *py_wbint_PamAuth_in_get_client_pid(PyObject *obj, void *closure)
{
	struct wbint_PamAuth *object = pytalloc_get_ptr(obj);
	PyObject *py_client_pid;
	py_client_pid = PyLong_FromUnsignedLongLong(object->in.client_pid);
	return py_client_pid;
}

static int py_wbint_PamAuth_in_set_client_pid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamAuth *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.client_pid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.client_pid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.client_pid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wbint_PamAuth_in_get_flags(PyObject *obj, void *closure)
{
	struct wbint_PamAuth *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->in.flags));
	return py_flags;
}

static int py_wbint_PamAuth_in_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamAuth *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wbint_PamAuth_in_get_info(PyObject *obj, void *closure)
{
	struct wbint_PamAuth *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->in.info == NULL) {
		Py_RETURN_NONE;
	}
	py_info = pytalloc_reference_ex(&wbint_AuthUserInfo_Type, object->in.info, object->in.info);
	return py_info;
}

static int py_wbint_PamAuth_in_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamAuth *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.info");
		return -1;
	}
	object->in.info = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.info);
	if (object->in.info == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&wbint_AuthUserInfo_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.info = (struct wbint_AuthUserInfo *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_wbint_PamAuth_in_get_require_membership_of_sid(PyObject *obj, void *closure)
{
	struct wbint_PamAuth *object = pytalloc_get_ptr(obj);
	PyObject *py_require_membership_of_sid;
	if (object->in.require_membership_of_sid == NULL) {
		Py_RETURN_NONE;
	}
	py_require_membership_of_sid = pytalloc_reference_ex(&wbint_SidArray_Type, object->in.require_membership_of_sid, object->in.require_membership_of_sid);
	return py_require_membership_of_sid;
}

static int py_wbint_PamAuth_in_set_require_membership_of_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamAuth *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.require_membership_of_sid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.require_membership_of_sid");
		return -1;
	}
	object->in.require_membership_of_sid = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.require_membership_of_sid);
	if (object->in.require_membership_of_sid == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&wbint_SidArray_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.require_membership_of_sid = (struct wbint_SidArray *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_wbint_PamAuth_out_get_validation(PyObject *obj, void *closure)
{
	struct wbint_PamAuth *object = pytalloc_get_ptr(obj);
	PyObject *py_validation;
	if (object->out.validation == NULL) {
		Py_RETURN_NONE;
	}
	py_validation = pytalloc_reference_ex(&wbint_Validation_Type, object->out.validation, object->out.validation);
	return py_validation;
}

static int py_wbint_PamAuth_out_set_validation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamAuth *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.validation));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.validation");
		return -1;
	}
	object->out.validation = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.validation);
	if (object->out.validation == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&wbint_Validation_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.validation = (struct wbint_Validation *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_wbint_PamAuth_get_result(PyObject *obj, void *closure)
{
	struct wbint_PamAuth *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_wbint_PamAuth_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamAuth *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wbint_PamAuth_getsetters[] = {
	{
		.name = discard_const_p(char, "in_client_name"),
		.get = py_wbint_PamAuth_in_get_client_name,
		.set = py_wbint_PamAuth_in_set_client_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_client_pid"),
		.get = py_wbint_PamAuth_in_get_client_pid,
		.set = py_wbint_PamAuth_in_set_client_pid,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "in_flags"),
		.get = py_wbint_PamAuth_in_get_flags,
		.set = py_wbint_PamAuth_in_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_info"),
		.get = py_wbint_PamAuth_in_get_info,
		.set = py_wbint_PamAuth_in_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type wbint_AuthUserInfo")
	},
	{
		.name = discard_const_p(char, "in_require_membership_of_sid"),
		.get = py_wbint_PamAuth_in_get_require_membership_of_sid,
		.set = py_wbint_PamAuth_in_set_require_membership_of_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type wbint_SidArray")
	},
	{
		.name = discard_const_p(char, "out_validation"),
		.get = py_wbint_PamAuth_out_get_validation,
		.set = py_wbint_PamAuth_out_set_validation,
		.doc = discard_const_p(char, "PIDL-generated element of base type wbint_Validation")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wbint_PamAuth_get_result,
		.set = py_wbint_PamAuth_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_wbint_PamAuth_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wbint_PamAuth, type);
	struct wbint_PamAuth *_self = (struct wbint_PamAuth *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.info = talloc_zero(mem_ctx, struct wbint_AuthUserInfo);
	_self->in.require_membership_of_sid = talloc_zero(mem_ctx, struct wbint_SidArray);
	_self->out.validation = talloc_zero(mem_ctx, struct wbint_Validation);
	return self;
}

static PyObject *py_wbint_PamAuth_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(22);
}

static PyObject *py_wbint_PamAuth_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_PamAuth *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 23) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_PamAuth_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[22];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wbint_PamAuth_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_PamAuth_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wbint_PamAuth_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_PamAuth_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wbint_PamAuth_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_PamAuth *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 23) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_PamAuth_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[22];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wbint_PamAuth_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_PamAuth_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_PamAuth_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_PamAuth_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_PamAuth_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_PamAuth *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winbind.num_calls < 23) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_PamAuth_ndr_print");
		return NULL;
	}
	call = &ndr_table_winbind.calls[22];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wbint_PamAuth_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_PamAuth_ndr_print(py_obj, args, kwargs, "wbint_PamAuth_in", NDR_IN);
}

static PyObject *py_wbint_PamAuth_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_PamAuth_ndr_print(py_obj, args, kwargs, "wbint_PamAuth_out", NDR_OUT);
}

static PyMethodDef py_wbint_PamAuth_methods[] = {
	{ "opnum", (PyCFunction)py_wbint_PamAuth_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winbind.wbint_PamAuth.opnum() -> 22 (0x16) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_PamAuth_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_PamAuth_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_PamAuth_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_PamAuth_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_PamAuth_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_PamAuth_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wbint_PamAuth_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.wbint_PamAuth",
	.tp_getset = py_wbint_PamAuth_getsetters,
	.tp_methods = py_wbint_PamAuth_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wbint_PamAuth_new,
};

static bool pack_py_wbint_PamAuth_args_in(PyObject *args, PyObject *kwargs, struct wbint_PamAuth *r)
{
	PyObject *py_client_name;
	PyObject *py_client_pid;
	PyObject *py_flags;
	PyObject *py_info;
	PyObject *py_require_membership_of_sid;
	const char *kwnames[] = {
		"client_name", "client_pid", "flags", "info", "require_membership_of_sid", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:wbint_PamAuth", discard_const_p(char *, kwnames), &py_client_name, &py_client_pid, &py_flags, &py_info, &py_require_membership_of_sid)) {
		return false;
	}

	if (py_client_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.client_name");
		return false;
	}
	r->in.client_name = talloc_ptrtype(r, r->in.client_name);
	if (r->in.client_name == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_client_name)) {
			unicode = PyUnicode_AsEncodedString(py_client_name, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_client_name)) {
			test_str = PyBytes_AS_STRING(py_client_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_client_name)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.client_name = talloc_str;
	}
	if (py_client_pid == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.client_pid");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.client_pid));
		if (PyLong_Check(py_client_pid)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_client_pid);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.client_pid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_flags == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.flags");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.flags));
		if (PyLong_Check(py_flags)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_flags);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_info == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.info");
		return false;
	}
	r->in.info = talloc_ptrtype(r, r->in.info);
	if (r->in.info == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&wbint_AuthUserInfo_Type, py_info, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_info)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.info = (struct wbint_AuthUserInfo *)pytalloc_get_ptr(py_info);
	if (py_require_membership_of_sid == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.require_membership_of_sid");
		return false;
	}
	r->in.require_membership_of_sid = talloc_ptrtype(r, r->in.require_membership_of_sid);
	if (r->in.require_membership_of_sid == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&wbint_SidArray_Type, py_require_membership_of_sid, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_require_membership_of_sid)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.require_membership_of_sid = (struct wbint_SidArray *)pytalloc_get_ptr(py_require_membership_of_sid);
	return true;
}

static PyObject *unpack_py_wbint_PamAuth_args_out(struct wbint_PamAuth *r, bool raise_result_exception)
{
	PyObject *py_validation = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_validation = pytalloc_reference_ex(&wbint_Validation_Type, r->out.validation, r->out.validation);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_validation);
	}
	if (result_size == 1) {
		result = py_validation;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_wbint_PamAuthCrap_in_get_client_name(PyObject *obj, void *closure)
{
	struct wbint_PamAuthCrap *object = pytalloc_get_ptr(obj);
	PyObject *py_client_name;
	if (object->in.client_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.client_name == NULL) {
		py_client_name = Py_None;
		Py_INCREF(py_client_name);
	} else {
		py_client_name = PyUnicode_Decode(object->in.client_name, strlen(object->in.client_name), "utf-8", "ignore");
	}
	return py_client_name;
}

static int py_wbint_PamAuthCrap_in_set_client_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamAuthCrap *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.client_name");
		return -1;
	}
	object->in.client_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.client_name);
	if (object->in.client_name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.client_name = talloc_str;
	}
	return 0;
}

static PyObject *py_wbint_PamAuthCrap_in_get_client_pid(PyObject *obj, void *closure)
{
	struct wbint_PamAuthCrap *object = pytalloc_get_ptr(obj);
	PyObject *py_client_pid;
	py_client_pid = PyLong_FromUnsignedLongLong(object->in.client_pid);
	return py_client_pid;
}

static int py_wbint_PamAuthCrap_in_set_client_pid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamAuthCrap *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.client_pid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.client_pid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.client_pid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wbint_PamAuthCrap_in_get_flags(PyObject *obj, void *closure)
{
	struct wbint_PamAuthCrap *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->in.flags));
	return py_flags;
}

static int py_wbint_PamAuthCrap_in_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamAuthCrap *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wbint_PamAuthCrap_in_get_user(PyObject *obj, void *closure)
{
	struct wbint_PamAuthCrap *object = pytalloc_get_ptr(obj);
	PyObject *py_user;
	if (object->in.user == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.user == NULL) {
		py_user = Py_None;
		Py_INCREF(py_user);
	} else {
		py_user = PyUnicode_Decode(object->in.user, strlen(object->in.user), "utf-8", "ignore");
	}
	return py_user;
}

static int py_wbint_PamAuthCrap_in_set_user(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamAuthCrap *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.user");
		return -1;
	}
	object->in.user = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.user);
	if (object->in.user == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.user = talloc_str;
	}
	return 0;
}

static PyObject *py_wbint_PamAuthCrap_in_get_domain(PyObject *obj, void *closure)
{
	struct wbint_PamAuthCrap *object = pytalloc_get_ptr(obj);
	PyObject *py_domain;
	if (object->in.domain == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.domain == NULL) {
		py_domain = Py_None;
		Py_INCREF(py_domain);
	} else {
		py_domain = PyUnicode_Decode(object->in.domain, strlen(object->in.domain), "utf-8", "ignore");
	}
	return py_domain;
}

static int py_wbint_PamAuthCrap_in_set_domain(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamAuthCrap *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.domain");
		return -1;
	}
	object->in.domain = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.domain);
	if (object->in.domain == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.domain = talloc_str;
	}
	return 0;
}

static PyObject *py_wbint_PamAuthCrap_in_get_workstation(PyObject *obj, void *closure)
{
	struct wbint_PamAuthCrap *object = pytalloc_get_ptr(obj);
	PyObject *py_workstation;
	if (object->in.workstation == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.workstation == NULL) {
		py_workstation = Py_None;
		Py_INCREF(py_workstation);
	} else {
		py_workstation = PyUnicode_Decode(object->in.workstation, strlen(object->in.workstation), "utf-8", "ignore");
	}
	return py_workstation;
}

static int py_wbint_PamAuthCrap_in_set_workstation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamAuthCrap *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.workstation");
		return -1;
	}
	object->in.workstation = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.workstation);
	if (object->in.workstation == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.workstation = talloc_str;
	}
	return 0;
}

static PyObject *py_wbint_PamAuthCrap_in_get_lm_resp(PyObject *obj, void *closure)
{
	struct wbint_PamAuthCrap *object = pytalloc_get_ptr(obj);
	PyObject *py_lm_resp;
	py_lm_resp = PyBytes_FromStringAndSize((char *)(object->in.lm_resp).data, (object->in.lm_resp).length);
	return py_lm_resp;
}

static int py_wbint_PamAuthCrap_in_set_lm_resp(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamAuthCrap *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.lm_resp");
		return -1;
	}
	object->in.lm_resp = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyObject *py_wbint_PamAuthCrap_in_get_nt_resp(PyObject *obj, void *closure)
{
	struct wbint_PamAuthCrap *object = pytalloc_get_ptr(obj);
	PyObject *py_nt_resp;
	py_nt_resp = PyBytes_FromStringAndSize((char *)(object->in.nt_resp).data, (object->in.nt_resp).length);
	return py_nt_resp;
}

static int py_wbint_PamAuthCrap_in_set_nt_resp(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamAuthCrap *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.nt_resp");
		return -1;
	}
	object->in.nt_resp = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyObject *py_wbint_PamAuthCrap_in_get_chal(PyObject *obj, void *closure)
{
	struct wbint_PamAuthCrap *object = pytalloc_get_ptr(obj);
	PyObject *py_chal;
	py_chal = PyBytes_FromStringAndSize((char *)(object->in.chal).data, (object->in.chal).length);
	return py_chal;
}

static int py_wbint_PamAuthCrap_in_set_chal(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamAuthCrap *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.chal");
		return -1;
	}
	object->in.chal = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyObject *py_wbint_PamAuthCrap_in_get_logon_parameters(PyObject *obj, void *closure)
{
	struct wbint_PamAuthCrap *object = pytalloc_get_ptr(obj);
	PyObject *py_logon_parameters;
	py_logon_parameters = PyLong_FromUnsignedLongLong((uint32_t)(object->in.logon_parameters));
	return py_logon_parameters;
}

static int py_wbint_PamAuthCrap_in_set_logon_parameters(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamAuthCrap *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.logon_parameters");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.logon_parameters));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.logon_parameters = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wbint_PamAuthCrap_in_get_require_membership_of_sid(PyObject *obj, void *closure)
{
	struct wbint_PamAuthCrap *object = pytalloc_get_ptr(obj);
	PyObject *py_require_membership_of_sid;
	if (object->in.require_membership_of_sid == NULL) {
		Py_RETURN_NONE;
	}
	py_require_membership_of_sid = pytalloc_reference_ex(&wbint_SidArray_Type, object->in.require_membership_of_sid, object->in.require_membership_of_sid);
	return py_require_membership_of_sid;
}

static int py_wbint_PamAuthCrap_in_set_require_membership_of_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamAuthCrap *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.require_membership_of_sid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.require_membership_of_sid");
		return -1;
	}
	object->in.require_membership_of_sid = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.require_membership_of_sid);
	if (object->in.require_membership_of_sid == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&wbint_SidArray_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.require_membership_of_sid = (struct wbint_SidArray *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_wbint_PamAuthCrap_out_get_authoritative(PyObject *obj, void *closure)
{
	struct wbint_PamAuthCrap *object = pytalloc_get_ptr(obj);
	PyObject *py_authoritative;
	if (object->out.authoritative == NULL) {
		Py_RETURN_NONE;
	}
	py_authoritative = PyLong_FromLong((uint16_t)(*object->out.authoritative));
	return py_authoritative;
}

static int py_wbint_PamAuthCrap_out_set_authoritative(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamAuthCrap *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.authoritative));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.authoritative");
		return -1;
	}
	object->out.authoritative = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.authoritative);
	if (object->out.authoritative == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.authoritative));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.authoritative = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wbint_PamAuthCrap_out_get_validation(PyObject *obj, void *closure)
{
	struct wbint_PamAuthCrap *object = pytalloc_get_ptr(obj);
	PyObject *py_validation;
	if (object->out.validation == NULL) {
		Py_RETURN_NONE;
	}
	py_validation = pytalloc_reference_ex(&wbint_PamAuthCrapValidation_Type, object->out.validation, object->out.validation);
	return py_validation;
}

static int py_wbint_PamAuthCrap_out_set_validation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamAuthCrap *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.validation));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.validation");
		return -1;
	}
	object->out.validation = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.validation);
	if (object->out.validation == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&wbint_PamAuthCrapValidation_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.validation = (struct wbint_PamAuthCrapValidation *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_wbint_PamAuthCrap_get_result(PyObject *obj, void *closure)
{
	struct wbint_PamAuthCrap *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_wbint_PamAuthCrap_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamAuthCrap *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wbint_PamAuthCrap_getsetters[] = {
	{
		.name = discard_const_p(char, "in_client_name"),
		.get = py_wbint_PamAuthCrap_in_get_client_name,
		.set = py_wbint_PamAuthCrap_in_set_client_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_client_pid"),
		.get = py_wbint_PamAuthCrap_in_get_client_pid,
		.set = py_wbint_PamAuthCrap_in_set_client_pid,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "in_flags"),
		.get = py_wbint_PamAuthCrap_in_get_flags,
		.set = py_wbint_PamAuthCrap_in_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_user"),
		.get = py_wbint_PamAuthCrap_in_get_user,
		.set = py_wbint_PamAuthCrap_in_set_user,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_domain"),
		.get = py_wbint_PamAuthCrap_in_get_domain,
		.set = py_wbint_PamAuthCrap_in_set_domain,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_workstation"),
		.get = py_wbint_PamAuthCrap_in_get_workstation,
		.set = py_wbint_PamAuthCrap_in_set_workstation,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_lm_resp"),
		.get = py_wbint_PamAuthCrap_in_get_lm_resp,
		.set = py_wbint_PamAuthCrap_in_set_lm_resp,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{
		.name = discard_const_p(char, "in_nt_resp"),
		.get = py_wbint_PamAuthCrap_in_get_nt_resp,
		.set = py_wbint_PamAuthCrap_in_set_nt_resp,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{
		.name = discard_const_p(char, "in_chal"),
		.get = py_wbint_PamAuthCrap_in_get_chal,
		.set = py_wbint_PamAuthCrap_in_set_chal,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{
		.name = discard_const_p(char, "in_logon_parameters"),
		.get = py_wbint_PamAuthCrap_in_get_logon_parameters,
		.set = py_wbint_PamAuthCrap_in_set_logon_parameters,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_require_membership_of_sid"),
		.get = py_wbint_PamAuthCrap_in_get_require_membership_of_sid,
		.set = py_wbint_PamAuthCrap_in_set_require_membership_of_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type wbint_SidArray")
	},
	{
		.name = discard_const_p(char, "out_authoritative"),
		.get = py_wbint_PamAuthCrap_out_get_authoritative,
		.set = py_wbint_PamAuthCrap_out_set_authoritative,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "out_validation"),
		.get = py_wbint_PamAuthCrap_out_get_validation,
		.set = py_wbint_PamAuthCrap_out_set_validation,
		.doc = discard_const_p(char, "PIDL-generated element of base type wbint_PamAuthCrapValidation")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wbint_PamAuthCrap_get_result,
		.set = py_wbint_PamAuthCrap_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_wbint_PamAuthCrap_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wbint_PamAuthCrap, type);
	struct wbint_PamAuthCrap *_self = (struct wbint_PamAuthCrap *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.require_membership_of_sid = talloc_zero(mem_ctx, struct wbint_SidArray);
	_self->out.authoritative = talloc_zero(mem_ctx, uint8_t);
	_self->out.validation = talloc_zero(mem_ctx, struct wbint_PamAuthCrapValidation);
	return self;
}

static PyObject *py_wbint_PamAuthCrap_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(23);
}

static PyObject *py_wbint_PamAuthCrap_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_PamAuthCrap *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 24) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_PamAuthCrap_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[23];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wbint_PamAuthCrap_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_PamAuthCrap_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wbint_PamAuthCrap_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_PamAuthCrap_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wbint_PamAuthCrap_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_PamAuthCrap *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 24) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_PamAuthCrap_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[23];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wbint_PamAuthCrap_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_PamAuthCrap_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_PamAuthCrap_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_PamAuthCrap_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_PamAuthCrap_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_PamAuthCrap *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winbind.num_calls < 24) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_PamAuthCrap_ndr_print");
		return NULL;
	}
	call = &ndr_table_winbind.calls[23];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wbint_PamAuthCrap_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_PamAuthCrap_ndr_print(py_obj, args, kwargs, "wbint_PamAuthCrap_in", NDR_IN);
}

static PyObject *py_wbint_PamAuthCrap_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_PamAuthCrap_ndr_print(py_obj, args, kwargs, "wbint_PamAuthCrap_out", NDR_OUT);
}

static PyMethodDef py_wbint_PamAuthCrap_methods[] = {
	{ "opnum", (PyCFunction)py_wbint_PamAuthCrap_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winbind.wbint_PamAuthCrap.opnum() -> 23 (0x17) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_PamAuthCrap_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_PamAuthCrap_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_PamAuthCrap_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_PamAuthCrap_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_PamAuthCrap_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_PamAuthCrap_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wbint_PamAuthCrap_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.wbint_PamAuthCrap",
	.tp_getset = py_wbint_PamAuthCrap_getsetters,
	.tp_methods = py_wbint_PamAuthCrap_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wbint_PamAuthCrap_new,
};

static bool pack_py_wbint_PamAuthCrap_args_in(PyObject *args, PyObject *kwargs, struct wbint_PamAuthCrap *r)
{
	PyObject *py_client_name;
	PyObject *py_client_pid;
	PyObject *py_flags;
	PyObject *py_user;
	PyObject *py_domain;
	PyObject *py_workstation;
	PyObject *py_lm_resp;
	PyObject *py_nt_resp;
	PyObject *py_chal;
	PyObject *py_logon_parameters;
	PyObject *py_require_membership_of_sid;
	const char *kwnames[] = {
		"client_name", "client_pid", "flags", "user", "domain", "workstation", "lm_resp", "nt_resp", "chal", "logon_parameters", "require_membership_of_sid", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOOOOOO:wbint_PamAuthCrap", discard_const_p(char *, kwnames), &py_client_name, &py_client_pid, &py_flags, &py_user, &py_domain, &py_workstation, &py_lm_resp, &py_nt_resp, &py_chal, &py_logon_parameters, &py_require_membership_of_sid)) {
		return false;
	}

	if (py_client_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.client_name");
		return false;
	}
	r->in.client_name = talloc_ptrtype(r, r->in.client_name);
	if (r->in.client_name == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_client_name)) {
			unicode = PyUnicode_AsEncodedString(py_client_name, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_client_name)) {
			test_str = PyBytes_AS_STRING(py_client_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_client_name)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.client_name = talloc_str;
	}
	if (py_client_pid == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.client_pid");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.client_pid));
		if (PyLong_Check(py_client_pid)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_client_pid);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.client_pid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_flags == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.flags");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.flags));
		if (PyLong_Check(py_flags)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_flags);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_user == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.user");
		return false;
	}
	r->in.user = talloc_ptrtype(r, r->in.user);
	if (r->in.user == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_user)) {
			unicode = PyUnicode_AsEncodedString(py_user, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_user)) {
			test_str = PyBytes_AS_STRING(py_user);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_user)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.user = talloc_str;
	}
	if (py_domain == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.domain");
		return false;
	}
	r->in.domain = talloc_ptrtype(r, r->in.domain);
	if (r->in.domain == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_domain)) {
			unicode = PyUnicode_AsEncodedString(py_domain, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_domain)) {
			test_str = PyBytes_AS_STRING(py_domain);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_domain)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.domain = talloc_str;
	}
	if (py_workstation == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.workstation");
		return false;
	}
	r->in.workstation = talloc_ptrtype(r, r->in.workstation);
	if (r->in.workstation == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_workstation)) {
			unicode = PyUnicode_AsEncodedString(py_workstation, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_workstation)) {
			test_str = PyBytes_AS_STRING(py_workstation);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_workstation)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.workstation = talloc_str;
	}
	if (py_lm_resp == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.lm_resp");
		return false;
	}
	r->in.lm_resp = data_blob_talloc(r, PyBytes_AS_STRING(py_lm_resp), PyBytes_GET_SIZE(py_lm_resp));
	if (py_nt_resp == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.nt_resp");
		return false;
	}
	r->in.nt_resp = data_blob_talloc(r, PyBytes_AS_STRING(py_nt_resp), PyBytes_GET_SIZE(py_nt_resp));
	if (py_chal == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.chal");
		return false;
	}
	r->in.chal = data_blob_talloc(r, PyBytes_AS_STRING(py_chal), PyBytes_GET_SIZE(py_chal));
	if (py_logon_parameters == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.logon_parameters");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.logon_parameters));
		if (PyLong_Check(py_logon_parameters)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_logon_parameters);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.logon_parameters = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_require_membership_of_sid == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.require_membership_of_sid");
		return false;
	}
	r->in.require_membership_of_sid = talloc_ptrtype(r, r->in.require_membership_of_sid);
	if (r->in.require_membership_of_sid == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&wbint_SidArray_Type, py_require_membership_of_sid, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_require_membership_of_sid)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.require_membership_of_sid = (struct wbint_SidArray *)pytalloc_get_ptr(py_require_membership_of_sid);
	return true;
}

static PyObject *unpack_py_wbint_PamAuthCrap_args_out(struct wbint_PamAuthCrap *r, bool raise_result_exception)
{
	PyObject *py_authoritative = NULL;
	PyObject *py_validation = NULL;
	PyObject *result = NULL;
	size_t result_size = 2;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_authoritative = PyLong_FromLong((uint16_t)(*r->out.authoritative));
	PyTuple_SetItem(result, 0, py_authoritative);

	py_validation = pytalloc_reference_ex(&wbint_PamAuthCrapValidation_Type, r->out.validation, r->out.validation);
	PyTuple_SetItem(result, 1, py_validation);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 2, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_wbint_PamLogOff_in_get_client_name(PyObject *obj, void *closure)
{
	struct wbint_PamLogOff *object = pytalloc_get_ptr(obj);
	PyObject *py_client_name;
	if (object->in.client_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.client_name == NULL) {
		py_client_name = Py_None;
		Py_INCREF(py_client_name);
	} else {
		py_client_name = PyUnicode_Decode(object->in.client_name, strlen(object->in.client_name), "utf-8", "ignore");
	}
	return py_client_name;
}

static int py_wbint_PamLogOff_in_set_client_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamLogOff *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.client_name");
		return -1;
	}
	object->in.client_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.client_name);
	if (object->in.client_name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.client_name = talloc_str;
	}
	return 0;
}

static PyObject *py_wbint_PamLogOff_in_get_client_pid(PyObject *obj, void *closure)
{
	struct wbint_PamLogOff *object = pytalloc_get_ptr(obj);
	PyObject *py_client_pid;
	py_client_pid = PyLong_FromUnsignedLongLong(object->in.client_pid);
	return py_client_pid;
}

static int py_wbint_PamLogOff_in_set_client_pid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamLogOff *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.client_pid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.client_pid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.client_pid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wbint_PamLogOff_in_get_flags(PyObject *obj, void *closure)
{
	struct wbint_PamLogOff *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->in.flags));
	return py_flags;
}

static int py_wbint_PamLogOff_in_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamLogOff *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wbint_PamLogOff_in_get_user(PyObject *obj, void *closure)
{
	struct wbint_PamLogOff *object = pytalloc_get_ptr(obj);
	PyObject *py_user;
	if (object->in.user == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.user == NULL) {
		py_user = Py_None;
		Py_INCREF(py_user);
	} else {
		py_user = PyUnicode_Decode(object->in.user, strlen(object->in.user), "utf-8", "ignore");
	}
	return py_user;
}

static int py_wbint_PamLogOff_in_set_user(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamLogOff *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.user");
		return -1;
	}
	object->in.user = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.user);
	if (object->in.user == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.user = talloc_str;
	}
	return 0;
}

static PyObject *py_wbint_PamLogOff_in_get_krb5ccname(PyObject *obj, void *closure)
{
	struct wbint_PamLogOff *object = pytalloc_get_ptr(obj);
	PyObject *py_krb5ccname;
	if (object->in.krb5ccname == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.krb5ccname == NULL) {
		py_krb5ccname = Py_None;
		Py_INCREF(py_krb5ccname);
	} else {
		py_krb5ccname = PyUnicode_Decode(object->in.krb5ccname, strlen(object->in.krb5ccname), "utf-8", "ignore");
	}
	return py_krb5ccname;
}

static int py_wbint_PamLogOff_in_set_krb5ccname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamLogOff *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.krb5ccname");
		return -1;
	}
	object->in.krb5ccname = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.krb5ccname);
	if (object->in.krb5ccname == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.krb5ccname = talloc_str;
	}
	return 0;
}

static PyObject *py_wbint_PamLogOff_in_get_uid(PyObject *obj, void *closure)
{
	struct wbint_PamLogOff *object = pytalloc_get_ptr(obj);
	PyObject *py_uid;
	py_uid = PyLong_FromUnsignedLongLong(object->in.uid);
	return py_uid;
}

static int py_wbint_PamLogOff_in_set_uid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamLogOff *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.uid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.uid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.uid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wbint_PamLogOff_get_result(PyObject *obj, void *closure)
{
	struct wbint_PamLogOff *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_wbint_PamLogOff_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamLogOff *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wbint_PamLogOff_getsetters[] = {
	{
		.name = discard_const_p(char, "in_client_name"),
		.get = py_wbint_PamLogOff_in_get_client_name,
		.set = py_wbint_PamLogOff_in_set_client_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_client_pid"),
		.get = py_wbint_PamLogOff_in_get_client_pid,
		.set = py_wbint_PamLogOff_in_set_client_pid,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "in_flags"),
		.get = py_wbint_PamLogOff_in_get_flags,
		.set = py_wbint_PamLogOff_in_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_user"),
		.get = py_wbint_PamLogOff_in_get_user,
		.set = py_wbint_PamLogOff_in_set_user,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_krb5ccname"),
		.get = py_wbint_PamLogOff_in_get_krb5ccname,
		.set = py_wbint_PamLogOff_in_set_krb5ccname,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_uid"),
		.get = py_wbint_PamLogOff_in_get_uid,
		.set = py_wbint_PamLogOff_in_set_uid,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wbint_PamLogOff_get_result,
		.set = py_wbint_PamLogOff_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_wbint_PamLogOff_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wbint_PamLogOff, type);
	return self;
}

static PyObject *py_wbint_PamLogOff_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(24);
}

static PyObject *py_wbint_PamLogOff_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_PamLogOff *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 25) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_PamLogOff_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[24];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wbint_PamLogOff_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_PamLogOff_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wbint_PamLogOff_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_PamLogOff_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wbint_PamLogOff_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_PamLogOff *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 25) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_PamLogOff_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[24];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wbint_PamLogOff_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_PamLogOff_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_PamLogOff_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_PamLogOff_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_PamLogOff_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_PamLogOff *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winbind.num_calls < 25) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_PamLogOff_ndr_print");
		return NULL;
	}
	call = &ndr_table_winbind.calls[24];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wbint_PamLogOff_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_PamLogOff_ndr_print(py_obj, args, kwargs, "wbint_PamLogOff_in", NDR_IN);
}

static PyObject *py_wbint_PamLogOff_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_PamLogOff_ndr_print(py_obj, args, kwargs, "wbint_PamLogOff_out", NDR_OUT);
}

static PyMethodDef py_wbint_PamLogOff_methods[] = {
	{ "opnum", (PyCFunction)py_wbint_PamLogOff_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winbind.wbint_PamLogOff.opnum() -> 24 (0x18) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_PamLogOff_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_PamLogOff_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_PamLogOff_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_PamLogOff_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_PamLogOff_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_PamLogOff_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wbint_PamLogOff_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.wbint_PamLogOff",
	.tp_getset = py_wbint_PamLogOff_getsetters,
	.tp_methods = py_wbint_PamLogOff_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wbint_PamLogOff_new,
};

static bool pack_py_wbint_PamLogOff_args_in(PyObject *args, PyObject *kwargs, struct wbint_PamLogOff *r)
{
	PyObject *py_client_name;
	PyObject *py_client_pid;
	PyObject *py_flags;
	PyObject *py_user;
	PyObject *py_krb5ccname;
	PyObject *py_uid;
	const char *kwnames[] = {
		"client_name", "client_pid", "flags", "user", "krb5ccname", "uid", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:wbint_PamLogOff", discard_const_p(char *, kwnames), &py_client_name, &py_client_pid, &py_flags, &py_user, &py_krb5ccname, &py_uid)) {
		return false;
	}

	if (py_client_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.client_name");
		return false;
	}
	r->in.client_name = talloc_ptrtype(r, r->in.client_name);
	if (r->in.client_name == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_client_name)) {
			unicode = PyUnicode_AsEncodedString(py_client_name, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_client_name)) {
			test_str = PyBytes_AS_STRING(py_client_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_client_name)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.client_name = talloc_str;
	}
	if (py_client_pid == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.client_pid");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.client_pid));
		if (PyLong_Check(py_client_pid)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_client_pid);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.client_pid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_flags == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.flags");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.flags));
		if (PyLong_Check(py_flags)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_flags);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_user == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.user");
		return false;
	}
	r->in.user = talloc_ptrtype(r, r->in.user);
	if (r->in.user == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_user)) {
			unicode = PyUnicode_AsEncodedString(py_user, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_user)) {
			test_str = PyBytes_AS_STRING(py_user);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_user)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.user = talloc_str;
	}
	if (py_krb5ccname == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.krb5ccname");
		return false;
	}
	r->in.krb5ccname = talloc_ptrtype(r, r->in.krb5ccname);
	if (r->in.krb5ccname == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_krb5ccname)) {
			unicode = PyUnicode_AsEncodedString(py_krb5ccname, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_krb5ccname)) {
			test_str = PyBytes_AS_STRING(py_krb5ccname);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_krb5ccname)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.krb5ccname = talloc_str;
	}
	if (py_uid == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.uid");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.uid));
		if (PyLong_Check(py_uid)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_uid);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.uid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_wbint_PamLogOff_args_out(struct wbint_PamLogOff *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromNTSTATUS(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_wbint_PamAuthCrapChangePassword_in_get_client_name(PyObject *obj, void *closure)
{
	struct wbint_PamAuthCrapChangePassword *object = pytalloc_get_ptr(obj);
	PyObject *py_client_name;
	if (object->in.client_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.client_name == NULL) {
		py_client_name = Py_None;
		Py_INCREF(py_client_name);
	} else {
		py_client_name = PyUnicode_Decode(object->in.client_name, strlen(object->in.client_name), "utf-8", "ignore");
	}
	return py_client_name;
}

static int py_wbint_PamAuthCrapChangePassword_in_set_client_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamAuthCrapChangePassword *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.client_name");
		return -1;
	}
	object->in.client_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.client_name);
	if (object->in.client_name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.client_name = talloc_str;
	}
	return 0;
}

static PyObject *py_wbint_PamAuthCrapChangePassword_in_get_client_pid(PyObject *obj, void *closure)
{
	struct wbint_PamAuthCrapChangePassword *object = pytalloc_get_ptr(obj);
	PyObject *py_client_pid;
	py_client_pid = PyLong_FromUnsignedLongLong(object->in.client_pid);
	return py_client_pid;
}

static int py_wbint_PamAuthCrapChangePassword_in_set_client_pid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamAuthCrapChangePassword *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.client_pid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.client_pid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.client_pid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wbint_PamAuthCrapChangePassword_in_get_user(PyObject *obj, void *closure)
{
	struct wbint_PamAuthCrapChangePassword *object = pytalloc_get_ptr(obj);
	PyObject *py_user;
	if (object->in.user == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.user == NULL) {
		py_user = Py_None;
		Py_INCREF(py_user);
	} else {
		py_user = PyUnicode_Decode(object->in.user, strlen(object->in.user), "utf-8", "ignore");
	}
	return py_user;
}

static int py_wbint_PamAuthCrapChangePassword_in_set_user(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamAuthCrapChangePassword *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.user");
		return -1;
	}
	object->in.user = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.user);
	if (object->in.user == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.user = talloc_str;
	}
	return 0;
}

static PyObject *py_wbint_PamAuthCrapChangePassword_in_get_domain(PyObject *obj, void *closure)
{
	struct wbint_PamAuthCrapChangePassword *object = pytalloc_get_ptr(obj);
	PyObject *py_domain;
	if (object->in.domain == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.domain == NULL) {
		py_domain = Py_None;
		Py_INCREF(py_domain);
	} else {
		py_domain = PyUnicode_Decode(object->in.domain, strlen(object->in.domain), "utf-8", "ignore");
	}
	return py_domain;
}

static int py_wbint_PamAuthCrapChangePassword_in_set_domain(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamAuthCrapChangePassword *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.domain");
		return -1;
	}
	object->in.domain = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.domain);
	if (object->in.domain == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.domain = talloc_str;
	}
	return 0;
}

static PyObject *py_wbint_PamAuthCrapChangePassword_in_get_new_nt_pswd(PyObject *obj, void *closure)
{
	struct wbint_PamAuthCrapChangePassword *object = pytalloc_get_ptr(obj);
	PyObject *py_new_nt_pswd;
	py_new_nt_pswd = PyBytes_FromStringAndSize((char *)(object->in.new_nt_pswd).data, (object->in.new_nt_pswd).length);
	return py_new_nt_pswd;
}

static int py_wbint_PamAuthCrapChangePassword_in_set_new_nt_pswd(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamAuthCrapChangePassword *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.new_nt_pswd");
		return -1;
	}
	object->in.new_nt_pswd = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyObject *py_wbint_PamAuthCrapChangePassword_in_get_old_nt_hash_enc(PyObject *obj, void *closure)
{
	struct wbint_PamAuthCrapChangePassword *object = pytalloc_get_ptr(obj);
	PyObject *py_old_nt_hash_enc;
	py_old_nt_hash_enc = PyBytes_FromStringAndSize((char *)(object->in.old_nt_hash_enc).data, (object->in.old_nt_hash_enc).length);
	return py_old_nt_hash_enc;
}

static int py_wbint_PamAuthCrapChangePassword_in_set_old_nt_hash_enc(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamAuthCrapChangePassword *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.old_nt_hash_enc");
		return -1;
	}
	object->in.old_nt_hash_enc = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyObject *py_wbint_PamAuthCrapChangePassword_in_get_new_lm_pswd(PyObject *obj, void *closure)
{
	struct wbint_PamAuthCrapChangePassword *object = pytalloc_get_ptr(obj);
	PyObject *py_new_lm_pswd;
	py_new_lm_pswd = PyBytes_FromStringAndSize((char *)(object->in.new_lm_pswd).data, (object->in.new_lm_pswd).length);
	return py_new_lm_pswd;
}

static int py_wbint_PamAuthCrapChangePassword_in_set_new_lm_pswd(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamAuthCrapChangePassword *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.new_lm_pswd");
		return -1;
	}
	object->in.new_lm_pswd = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyObject *py_wbint_PamAuthCrapChangePassword_in_get_old_lm_hash_enc(PyObject *obj, void *closure)
{
	struct wbint_PamAuthCrapChangePassword *object = pytalloc_get_ptr(obj);
	PyObject *py_old_lm_hash_enc;
	py_old_lm_hash_enc = PyBytes_FromStringAndSize((char *)(object->in.old_lm_hash_enc).data, (object->in.old_lm_hash_enc).length);
	return py_old_lm_hash_enc;
}

static int py_wbint_PamAuthCrapChangePassword_in_set_old_lm_hash_enc(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamAuthCrapChangePassword *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.old_lm_hash_enc");
		return -1;
	}
	object->in.old_lm_hash_enc = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyObject *py_wbint_PamAuthCrapChangePassword_get_result(PyObject *obj, void *closure)
{
	struct wbint_PamAuthCrapChangePassword *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_wbint_PamAuthCrapChangePassword_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamAuthCrapChangePassword *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wbint_PamAuthCrapChangePassword_getsetters[] = {
	{
		.name = discard_const_p(char, "in_client_name"),
		.get = py_wbint_PamAuthCrapChangePassword_in_get_client_name,
		.set = py_wbint_PamAuthCrapChangePassword_in_set_client_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_client_pid"),
		.get = py_wbint_PamAuthCrapChangePassword_in_get_client_pid,
		.set = py_wbint_PamAuthCrapChangePassword_in_set_client_pid,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "in_user"),
		.get = py_wbint_PamAuthCrapChangePassword_in_get_user,
		.set = py_wbint_PamAuthCrapChangePassword_in_set_user,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_domain"),
		.get = py_wbint_PamAuthCrapChangePassword_in_get_domain,
		.set = py_wbint_PamAuthCrapChangePassword_in_set_domain,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_new_nt_pswd"),
		.get = py_wbint_PamAuthCrapChangePassword_in_get_new_nt_pswd,
		.set = py_wbint_PamAuthCrapChangePassword_in_set_new_nt_pswd,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{
		.name = discard_const_p(char, "in_old_nt_hash_enc"),
		.get = py_wbint_PamAuthCrapChangePassword_in_get_old_nt_hash_enc,
		.set = py_wbint_PamAuthCrapChangePassword_in_set_old_nt_hash_enc,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{
		.name = discard_const_p(char, "in_new_lm_pswd"),
		.get = py_wbint_PamAuthCrapChangePassword_in_get_new_lm_pswd,
		.set = py_wbint_PamAuthCrapChangePassword_in_set_new_lm_pswd,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{
		.name = discard_const_p(char, "in_old_lm_hash_enc"),
		.get = py_wbint_PamAuthCrapChangePassword_in_get_old_lm_hash_enc,
		.set = py_wbint_PamAuthCrapChangePassword_in_set_old_lm_hash_enc,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wbint_PamAuthCrapChangePassword_get_result,
		.set = py_wbint_PamAuthCrapChangePassword_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_wbint_PamAuthCrapChangePassword_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wbint_PamAuthCrapChangePassword, type);
	return self;
}

static PyObject *py_wbint_PamAuthCrapChangePassword_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(25);
}

static PyObject *py_wbint_PamAuthCrapChangePassword_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_PamAuthCrapChangePassword *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 26) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_PamAuthCrapChangePassword_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[25];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wbint_PamAuthCrapChangePassword_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_PamAuthCrapChangePassword_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wbint_PamAuthCrapChangePassword_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_PamAuthCrapChangePassword_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wbint_PamAuthCrapChangePassword_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_PamAuthCrapChangePassword *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 26) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_PamAuthCrapChangePassword_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[25];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wbint_PamAuthCrapChangePassword_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_PamAuthCrapChangePassword_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_PamAuthCrapChangePassword_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_PamAuthCrapChangePassword_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_PamAuthCrapChangePassword_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_PamAuthCrapChangePassword *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winbind.num_calls < 26) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_PamAuthCrapChangePassword_ndr_print");
		return NULL;
	}
	call = &ndr_table_winbind.calls[25];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wbint_PamAuthCrapChangePassword_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_PamAuthCrapChangePassword_ndr_print(py_obj, args, kwargs, "wbint_PamAuthCrapChangePassword_in", NDR_IN);
}

static PyObject *py_wbint_PamAuthCrapChangePassword_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_PamAuthCrapChangePassword_ndr_print(py_obj, args, kwargs, "wbint_PamAuthCrapChangePassword_out", NDR_OUT);
}

static PyMethodDef py_wbint_PamAuthCrapChangePassword_methods[] = {
	{ "opnum", (PyCFunction)py_wbint_PamAuthCrapChangePassword_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winbind.wbint_PamAuthCrapChangePassword.opnum() -> 25 (0x19) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_PamAuthCrapChangePassword_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_PamAuthCrapChangePassword_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_PamAuthCrapChangePassword_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_PamAuthCrapChangePassword_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_PamAuthCrapChangePassword_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_PamAuthCrapChangePassword_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wbint_PamAuthCrapChangePassword_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.wbint_PamAuthCrapChangePassword",
	.tp_getset = py_wbint_PamAuthCrapChangePassword_getsetters,
	.tp_methods = py_wbint_PamAuthCrapChangePassword_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wbint_PamAuthCrapChangePassword_new,
};

static bool pack_py_wbint_PamAuthCrapChangePassword_args_in(PyObject *args, PyObject *kwargs, struct wbint_PamAuthCrapChangePassword *r)
{
	PyObject *py_client_name;
	PyObject *py_client_pid;
	PyObject *py_user;
	PyObject *py_domain;
	PyObject *py_new_nt_pswd;
	PyObject *py_old_nt_hash_enc;
	PyObject *py_new_lm_pswd;
	PyObject *py_old_lm_hash_enc;
	const char *kwnames[] = {
		"client_name", "client_pid", "user", "domain", "new_nt_pswd", "old_nt_hash_enc", "new_lm_pswd", "old_lm_hash_enc", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOOO:wbint_PamAuthCrapChangePassword", discard_const_p(char *, kwnames), &py_client_name, &py_client_pid, &py_user, &py_domain, &py_new_nt_pswd, &py_old_nt_hash_enc, &py_new_lm_pswd, &py_old_lm_hash_enc)) {
		return false;
	}

	if (py_client_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.client_name");
		return false;
	}
	r->in.client_name = talloc_ptrtype(r, r->in.client_name);
	if (r->in.client_name == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_client_name)) {
			unicode = PyUnicode_AsEncodedString(py_client_name, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_client_name)) {
			test_str = PyBytes_AS_STRING(py_client_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_client_name)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.client_name = talloc_str;
	}
	if (py_client_pid == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.client_pid");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.client_pid));
		if (PyLong_Check(py_client_pid)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_client_pid);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.client_pid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_user == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.user");
		return false;
	}
	r->in.user = talloc_ptrtype(r, r->in.user);
	if (r->in.user == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_user)) {
			unicode = PyUnicode_AsEncodedString(py_user, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_user)) {
			test_str = PyBytes_AS_STRING(py_user);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_user)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.user = talloc_str;
	}
	if (py_domain == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.domain");
		return false;
	}
	r->in.domain = talloc_ptrtype(r, r->in.domain);
	if (r->in.domain == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_domain)) {
			unicode = PyUnicode_AsEncodedString(py_domain, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_domain)) {
			test_str = PyBytes_AS_STRING(py_domain);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_domain)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.domain = talloc_str;
	}
	if (py_new_nt_pswd == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.new_nt_pswd");
		return false;
	}
	r->in.new_nt_pswd = data_blob_talloc(r, PyBytes_AS_STRING(py_new_nt_pswd), PyBytes_GET_SIZE(py_new_nt_pswd));
	if (py_old_nt_hash_enc == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.old_nt_hash_enc");
		return false;
	}
	r->in.old_nt_hash_enc = data_blob_talloc(r, PyBytes_AS_STRING(py_old_nt_hash_enc), PyBytes_GET_SIZE(py_old_nt_hash_enc));
	if (py_new_lm_pswd == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.new_lm_pswd");
		return false;
	}
	r->in.new_lm_pswd = data_blob_talloc(r, PyBytes_AS_STRING(py_new_lm_pswd), PyBytes_GET_SIZE(py_new_lm_pswd));
	if (py_old_lm_hash_enc == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.old_lm_hash_enc");
		return false;
	}
	r->in.old_lm_hash_enc = data_blob_talloc(r, PyBytes_AS_STRING(py_old_lm_hash_enc), PyBytes_GET_SIZE(py_old_lm_hash_enc));
	return true;
}

static PyObject *unpack_py_wbint_PamAuthCrapChangePassword_args_out(struct wbint_PamAuthCrapChangePassword *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromNTSTATUS(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_wbint_PamAuthChangePassword_in_get_client_name(PyObject *obj, void *closure)
{
	struct wbint_PamAuthChangePassword *object = pytalloc_get_ptr(obj);
	PyObject *py_client_name;
	if (object->in.client_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.client_name == NULL) {
		py_client_name = Py_None;
		Py_INCREF(py_client_name);
	} else {
		py_client_name = PyUnicode_Decode(object->in.client_name, strlen(object->in.client_name), "utf-8", "ignore");
	}
	return py_client_name;
}

static int py_wbint_PamAuthChangePassword_in_set_client_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamAuthChangePassword *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.client_name");
		return -1;
	}
	object->in.client_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.client_name);
	if (object->in.client_name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.client_name = talloc_str;
	}
	return 0;
}

static PyObject *py_wbint_PamAuthChangePassword_in_get_client_pid(PyObject *obj, void *closure)
{
	struct wbint_PamAuthChangePassword *object = pytalloc_get_ptr(obj);
	PyObject *py_client_pid;
	py_client_pid = PyLong_FromUnsignedLongLong(object->in.client_pid);
	return py_client_pid;
}

static int py_wbint_PamAuthChangePassword_in_set_client_pid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamAuthChangePassword *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.client_pid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.client_pid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.client_pid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wbint_PamAuthChangePassword_in_get_flags(PyObject *obj, void *closure)
{
	struct wbint_PamAuthChangePassword *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->in.flags));
	return py_flags;
}

static int py_wbint_PamAuthChangePassword_in_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamAuthChangePassword *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wbint_PamAuthChangePassword_in_get_user(PyObject *obj, void *closure)
{
	struct wbint_PamAuthChangePassword *object = pytalloc_get_ptr(obj);
	PyObject *py_user;
	if (object->in.user == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.user == NULL) {
		py_user = Py_None;
		Py_INCREF(py_user);
	} else {
		py_user = PyUnicode_Decode(object->in.user, strlen(object->in.user), "utf-8", "ignore");
	}
	return py_user;
}

static int py_wbint_PamAuthChangePassword_in_set_user(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamAuthChangePassword *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.user");
		return -1;
	}
	object->in.user = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.user);
	if (object->in.user == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.user = talloc_str;
	}
	return 0;
}

static PyObject *py_wbint_PamAuthChangePassword_in_get_old_password(PyObject *obj, void *closure)
{
	struct wbint_PamAuthChangePassword *object = pytalloc_get_ptr(obj);
	PyObject *py_old_password;
	if (object->in.old_password == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.old_password == NULL) {
		py_old_password = Py_None;
		Py_INCREF(py_old_password);
	} else {
		py_old_password = PyUnicode_Decode(object->in.old_password, strlen(object->in.old_password), "utf-8", "ignore");
	}
	return py_old_password;
}

static int py_wbint_PamAuthChangePassword_in_set_old_password(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamAuthChangePassword *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.old_password");
		return -1;
	}
	object->in.old_password = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.old_password);
	if (object->in.old_password == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.old_password = talloc_str;
	}
	return 0;
}

static PyObject *py_wbint_PamAuthChangePassword_in_get_new_password(PyObject *obj, void *closure)
{
	struct wbint_PamAuthChangePassword *object = pytalloc_get_ptr(obj);
	PyObject *py_new_password;
	if (object->in.new_password == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.new_password == NULL) {
		py_new_password = Py_None;
		Py_INCREF(py_new_password);
	} else {
		py_new_password = PyUnicode_Decode(object->in.new_password, strlen(object->in.new_password), "utf-8", "ignore");
	}
	return py_new_password;
}

static int py_wbint_PamAuthChangePassword_in_set_new_password(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamAuthChangePassword *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.new_password");
		return -1;
	}
	object->in.new_password = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.new_password);
	if (object->in.new_password == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.new_password = talloc_str;
	}
	return 0;
}

static PyObject *py_wbint_PamAuthChangePassword_out_get_dominfo(PyObject *obj, void *closure)
{
	struct wbint_PamAuthChangePassword *object = pytalloc_get_ptr(obj);
	PyObject *py_dominfo;
	if (object->out.dominfo == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.dominfo == NULL) {
		py_dominfo = Py_None;
		Py_INCREF(py_dominfo);
	} else {
		py_dominfo = pytalloc_reference_ex(samr_DomInfo1_Type, *object->out.dominfo, *object->out.dominfo);
	}
	return py_dominfo;
}

static int py_wbint_PamAuthChangePassword_out_set_dominfo(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamAuthChangePassword *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.dominfo));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.dominfo");
		return -1;
	}
	object->out.dominfo = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.dominfo);
	if (object->out.dominfo == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.dominfo = NULL;
	} else {
		*object->out.dominfo = NULL;
		PY_CHECK_TYPE(samr_DomInfo1_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		*object->out.dominfo = (struct samr_DomInfo1 *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_wbint_PamAuthChangePassword_out_get_reject_reason(PyObject *obj, void *closure)
{
	struct wbint_PamAuthChangePassword *object = pytalloc_get_ptr(obj);
	PyObject *py_reject_reason;
	if (object->out.reject_reason == NULL) {
		Py_RETURN_NONE;
	}
	py_reject_reason = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.reject_reason));
	return py_reject_reason;
}

static int py_wbint_PamAuthChangePassword_out_set_reject_reason(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamAuthChangePassword *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.reject_reason));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.reject_reason");
		return -1;
	}
	object->out.reject_reason = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.reject_reason);
	if (object->out.reject_reason == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.reject_reason));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.reject_reason = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wbint_PamAuthChangePassword_get_result(PyObject *obj, void *closure)
{
	struct wbint_PamAuthChangePassword *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_wbint_PamAuthChangePassword_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_PamAuthChangePassword *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wbint_PamAuthChangePassword_getsetters[] = {
	{
		.name = discard_const_p(char, "in_client_name"),
		.get = py_wbint_PamAuthChangePassword_in_get_client_name,
		.set = py_wbint_PamAuthChangePassword_in_set_client_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_client_pid"),
		.get = py_wbint_PamAuthChangePassword_in_get_client_pid,
		.set = py_wbint_PamAuthChangePassword_in_set_client_pid,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "in_flags"),
		.get = py_wbint_PamAuthChangePassword_in_get_flags,
		.set = py_wbint_PamAuthChangePassword_in_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_user"),
		.get = py_wbint_PamAuthChangePassword_in_get_user,
		.set = py_wbint_PamAuthChangePassword_in_set_user,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_old_password"),
		.get = py_wbint_PamAuthChangePassword_in_get_old_password,
		.set = py_wbint_PamAuthChangePassword_in_set_old_password,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_new_password"),
		.get = py_wbint_PamAuthChangePassword_in_get_new_password,
		.set = py_wbint_PamAuthChangePassword_in_set_new_password,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "out_dominfo"),
		.get = py_wbint_PamAuthChangePassword_out_get_dominfo,
		.set = py_wbint_PamAuthChangePassword_out_set_dominfo,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_DomInfo1")
	},
	{
		.name = discard_const_p(char, "out_reject_reason"),
		.get = py_wbint_PamAuthChangePassword_out_get_reject_reason,
		.set = py_wbint_PamAuthChangePassword_out_set_reject_reason,
		.doc = discard_const_p(char, "PIDL-generated element of base type samPwdChangeReason")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wbint_PamAuthChangePassword_get_result,
		.set = py_wbint_PamAuthChangePassword_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_wbint_PamAuthChangePassword_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wbint_PamAuthChangePassword, type);
	struct wbint_PamAuthChangePassword *_self = (struct wbint_PamAuthChangePassword *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	/* a pointer to a NULL pointer */
	_self->out.dominfo = talloc_zero(mem_ctx, struct samr_DomInfo1 *);
	_self->out.reject_reason = talloc_zero(mem_ctx, enum samPwdChangeReason);
	return self;
}

static PyObject *py_wbint_PamAuthChangePassword_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(26);
}

static PyObject *py_wbint_PamAuthChangePassword_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_PamAuthChangePassword *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 27) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_PamAuthChangePassword_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[26];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wbint_PamAuthChangePassword_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_PamAuthChangePassword_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wbint_PamAuthChangePassword_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_PamAuthChangePassword_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wbint_PamAuthChangePassword_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_PamAuthChangePassword *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 27) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_PamAuthChangePassword_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[26];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wbint_PamAuthChangePassword_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_PamAuthChangePassword_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_PamAuthChangePassword_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_PamAuthChangePassword_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_PamAuthChangePassword_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_PamAuthChangePassword *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winbind.num_calls < 27) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_PamAuthChangePassword_ndr_print");
		return NULL;
	}
	call = &ndr_table_winbind.calls[26];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wbint_PamAuthChangePassword_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_PamAuthChangePassword_ndr_print(py_obj, args, kwargs, "wbint_PamAuthChangePassword_in", NDR_IN);
}

static PyObject *py_wbint_PamAuthChangePassword_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_PamAuthChangePassword_ndr_print(py_obj, args, kwargs, "wbint_PamAuthChangePassword_out", NDR_OUT);
}

static PyMethodDef py_wbint_PamAuthChangePassword_methods[] = {
	{ "opnum", (PyCFunction)py_wbint_PamAuthChangePassword_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winbind.wbint_PamAuthChangePassword.opnum() -> 26 (0x1a) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_PamAuthChangePassword_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_PamAuthChangePassword_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_PamAuthChangePassword_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_PamAuthChangePassword_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_PamAuthChangePassword_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_PamAuthChangePassword_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wbint_PamAuthChangePassword_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.wbint_PamAuthChangePassword",
	.tp_getset = py_wbint_PamAuthChangePassword_getsetters,
	.tp_methods = py_wbint_PamAuthChangePassword_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wbint_PamAuthChangePassword_new,
};

static bool pack_py_wbint_PamAuthChangePassword_args_in(PyObject *args, PyObject *kwargs, struct wbint_PamAuthChangePassword *r)
{
	PyObject *py_client_name;
	PyObject *py_client_pid;
	PyObject *py_flags;
	PyObject *py_user;
	PyObject *py_old_password;
	PyObject *py_new_password;
	const char *kwnames[] = {
		"client_name", "client_pid", "flags", "user", "old_password", "new_password", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:wbint_PamAuthChangePassword", discard_const_p(char *, kwnames), &py_client_name, &py_client_pid, &py_flags, &py_user, &py_old_password, &py_new_password)) {
		return false;
	}

	if (py_client_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.client_name");
		return false;
	}
	r->in.client_name = talloc_ptrtype(r, r->in.client_name);
	if (r->in.client_name == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_client_name)) {
			unicode = PyUnicode_AsEncodedString(py_client_name, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_client_name)) {
			test_str = PyBytes_AS_STRING(py_client_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_client_name)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.client_name = talloc_str;
	}
	if (py_client_pid == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.client_pid");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.client_pid));
		if (PyLong_Check(py_client_pid)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_client_pid);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.client_pid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_flags == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.flags");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.flags));
		if (PyLong_Check(py_flags)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_flags);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_user == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.user");
		return false;
	}
	r->in.user = talloc_ptrtype(r, r->in.user);
	if (r->in.user == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_user)) {
			unicode = PyUnicode_AsEncodedString(py_user, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_user)) {
			test_str = PyBytes_AS_STRING(py_user);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_user)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.user = talloc_str;
	}
	if (py_old_password == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.old_password");
		return false;
	}
	r->in.old_password = talloc_ptrtype(r, r->in.old_password);
	if (r->in.old_password == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_old_password)) {
			unicode = PyUnicode_AsEncodedString(py_old_password, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_old_password)) {
			test_str = PyBytes_AS_STRING(py_old_password);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_old_password)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.old_password = talloc_str;
	}
	if (py_new_password == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.new_password");
		return false;
	}
	r->in.new_password = talloc_ptrtype(r, r->in.new_password);
	if (r->in.new_password == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_new_password)) {
			unicode = PyUnicode_AsEncodedString(py_new_password, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_new_password)) {
			test_str = PyBytes_AS_STRING(py_new_password);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_new_password)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.new_password = talloc_str;
	}
	return true;
}

static PyObject *unpack_py_wbint_PamAuthChangePassword_args_out(struct wbint_PamAuthChangePassword *r, bool raise_result_exception)
{
	PyObject *py_dominfo = NULL;
	PyObject *py_reject_reason = NULL;
	PyObject *result = NULL;
	size_t result_size = 2;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	if (*r->out.dominfo == NULL) {
		py_dominfo = Py_None;
		Py_INCREF(py_dominfo);
	} else {
		py_dominfo = pytalloc_reference_ex(samr_DomInfo1_Type, *r->out.dominfo, *r->out.dominfo);
	}
	PyTuple_SetItem(result, 0, py_dominfo);

	py_reject_reason = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.reject_reason));
	PyTuple_SetItem(result, 1, py_reject_reason);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 2, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_wbint_InitConnection_in_get_dcname(PyObject *obj, void *closure)
{
	struct wbint_InitConnection *object = pytalloc_get_ptr(obj);
	PyObject *py_dcname;
	if (object->in.dcname == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.dcname == NULL) {
		py_dcname = Py_None;
		Py_INCREF(py_dcname);
	} else {
		py_dcname = PyUnicode_Decode(object->in.dcname, strlen(object->in.dcname), "utf-8", "ignore");
	}
	return py_dcname;
}

static int py_wbint_InitConnection_in_set_dcname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_InitConnection *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.dcname");
		return -1;
	}
	object->in.dcname = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.dcname);
	if (object->in.dcname == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.dcname = talloc_str;
	}
	return 0;
}

static PyObject *py_wbint_InitConnection_out_get_name(PyObject *obj, void *closure)
{
	struct wbint_InitConnection *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	if (object->out.name == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.name == NULL) {
		py_name = Py_None;
		Py_INCREF(py_name);
	} else {
		if (*object->out.name == NULL) {
			py_name = Py_None;
			Py_INCREF(py_name);
		} else {
			py_name = PyUnicode_Decode(*object->out.name, strlen(*object->out.name), "utf-8", "ignore");
		}
	}
	return py_name;
}

static int py_wbint_InitConnection_out_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_InitConnection *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.name));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.name");
		return -1;
	}
	object->out.name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.name);
	if (object->out.name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.name = NULL;
	} else {
		*object->out.name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			*object->out.name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wbint_InitConnection_out_get_alt_name(PyObject *obj, void *closure)
{
	struct wbint_InitConnection *object = pytalloc_get_ptr(obj);
	PyObject *py_alt_name;
	if (object->out.alt_name == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.alt_name == NULL) {
		py_alt_name = Py_None;
		Py_INCREF(py_alt_name);
	} else {
		if (*object->out.alt_name == NULL) {
			py_alt_name = Py_None;
			Py_INCREF(py_alt_name);
		} else {
			py_alt_name = PyUnicode_Decode(*object->out.alt_name, strlen(*object->out.alt_name), "utf-8", "ignore");
		}
	}
	return py_alt_name;
}

static int py_wbint_InitConnection_out_set_alt_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_InitConnection *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.alt_name));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.alt_name");
		return -1;
	}
	object->out.alt_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.alt_name);
	if (object->out.alt_name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.alt_name = NULL;
	} else {
		*object->out.alt_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			*object->out.alt_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wbint_InitConnection_out_get_sid(PyObject *obj, void *closure)
{
	struct wbint_InitConnection *object = pytalloc_get_ptr(obj);
	PyObject *py_sid;
	if (object->out.sid == NULL) {
		Py_RETURN_NONE;
	}
	py_sid = pytalloc_reference_ex(dom_sid_Type, object->out.sid, object->out.sid);
	return py_sid;
}

static int py_wbint_InitConnection_out_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_InitConnection *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.sid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.sid");
		return -1;
	}
	object->out.sid = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.sid);
	if (object->out.sid == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.sid = (struct dom_sid *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_wbint_InitConnection_out_get_flags(PyObject *obj, void *closure)
{
	struct wbint_InitConnection *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	if (object->out.flags == NULL) {
		Py_RETURN_NONE;
	}
	py_flags = PyLong_FromLong((uint16_t)(*object->out.flags));
	return py_flags;
}

static int py_wbint_InitConnection_out_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_InitConnection *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.flags));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.flags");
		return -1;
	}
	object->out.flags = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.flags);
	if (object->out.flags == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_wbint_InitConnection_get_result(PyObject *obj, void *closure)
{
	struct wbint_InitConnection *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_wbint_InitConnection_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_InitConnection *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wbint_InitConnection_getsetters[] = {
	{
		.name = discard_const_p(char, "in_dcname"),
		.get = py_wbint_InitConnection_in_get_dcname,
		.set = py_wbint_InitConnection_in_set_dcname,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "out_name"),
		.get = py_wbint_InitConnection_out_get_name,
		.set = py_wbint_InitConnection_out_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "out_alt_name"),
		.get = py_wbint_InitConnection_out_get_alt_name,
		.set = py_wbint_InitConnection_out_set_alt_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "out_sid"),
		.get = py_wbint_InitConnection_out_get_sid,
		.set = py_wbint_InitConnection_out_set_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid")
	},
	{
		.name = discard_const_p(char, "out_flags"),
		.get = py_wbint_InitConnection_out_get_flags,
		.set = py_wbint_InitConnection_out_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type DomainInfoFlags")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wbint_InitConnection_get_result,
		.set = py_wbint_InitConnection_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_wbint_InitConnection_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wbint_InitConnection, type);
	struct wbint_InitConnection *_self = (struct wbint_InitConnection *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.sid = talloc_zero(mem_ctx, struct dom_sid);
	_self->out.flags = talloc_zero(mem_ctx, enum DomainInfoFlags);
	return self;
}

static PyObject *py_wbint_InitConnection_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(27);
}

static PyObject *py_wbint_InitConnection_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_InitConnection *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 28) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_InitConnection_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[27];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wbint_InitConnection_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_InitConnection_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wbint_InitConnection_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_InitConnection_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wbint_InitConnection_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_InitConnection *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 28) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_InitConnection_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[27];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wbint_InitConnection_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_InitConnection_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_InitConnection_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_InitConnection_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_InitConnection_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_InitConnection *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winbind.num_calls < 28) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_InitConnection_ndr_print");
		return NULL;
	}
	call = &ndr_table_winbind.calls[27];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wbint_InitConnection_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_InitConnection_ndr_print(py_obj, args, kwargs, "wbint_InitConnection_in", NDR_IN);
}

static PyObject *py_wbint_InitConnection_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_InitConnection_ndr_print(py_obj, args, kwargs, "wbint_InitConnection_out", NDR_OUT);
}

static PyMethodDef py_wbint_InitConnection_methods[] = {
	{ "opnum", (PyCFunction)py_wbint_InitConnection_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winbind.wbint_InitConnection.opnum() -> 27 (0x1b) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_InitConnection_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_InitConnection_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_InitConnection_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_InitConnection_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_InitConnection_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_InitConnection_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wbint_InitConnection_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.wbint_InitConnection",
	.tp_getset = py_wbint_InitConnection_getsetters,
	.tp_methods = py_wbint_InitConnection_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wbint_InitConnection_new,
};

static bool pack_py_wbint_InitConnection_args_in(PyObject *args, PyObject *kwargs, struct wbint_InitConnection *r)
{
	PyObject *py_dcname;
	const char *kwnames[] = {
		"dcname", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:wbint_InitConnection", discard_const_p(char *, kwnames), &py_dcname)) {
		return false;
	}

	if (py_dcname == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.dcname");
		return false;
	}
	r->in.dcname = talloc_ptrtype(r, r->in.dcname);
	if (r->in.dcname == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_dcname)) {
			unicode = PyUnicode_AsEncodedString(py_dcname, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_dcname)) {
			test_str = PyBytes_AS_STRING(py_dcname);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_dcname)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.dcname = talloc_str;
	}
	return true;
}

static PyObject *unpack_py_wbint_InitConnection_args_out(struct wbint_InitConnection *r, bool raise_result_exception)
{
	PyObject *py_name = NULL;
	PyObject *py_alt_name = NULL;
	PyObject *py_sid = NULL;
	PyObject *py_flags = NULL;
	PyObject *result = NULL;
	size_t result_size = 4;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	if (*r->out.name == NULL) {
		py_name = Py_None;
		Py_INCREF(py_name);
	} else {
		if (*r->out.name == NULL) {
			py_name = Py_None;
			Py_INCREF(py_name);
		} else {
			py_name = PyUnicode_Decode(*r->out.name, strlen(*r->out.name), "utf-8", "ignore");
		}
	}
	PyTuple_SetItem(result, 0, py_name);

	if (*r->out.alt_name == NULL) {
		py_alt_name = Py_None;
		Py_INCREF(py_alt_name);
	} else {
		if (*r->out.alt_name == NULL) {
			py_alt_name = Py_None;
			Py_INCREF(py_alt_name);
		} else {
			py_alt_name = PyUnicode_Decode(*r->out.alt_name, strlen(*r->out.alt_name), "utf-8", "ignore");
		}
	}
	PyTuple_SetItem(result, 1, py_alt_name);

	py_sid = pytalloc_reference_ex(dom_sid_Type, r->out.sid, r->out.sid);
	PyTuple_SetItem(result, 2, py_sid);

	py_flags = PyLong_FromLong((uint16_t)(*r->out.flags));
	PyTuple_SetItem(result, 3, py_flags);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 4, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_wbint_NormalizeNameMap_in_get_domain_name(PyObject *obj, void *closure)
{
	struct wbint_NormalizeNameMap *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	if (object->in.domain_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.domain_name == NULL) {
		py_domain_name = Py_None;
		Py_INCREF(py_domain_name);
	} else {
		py_domain_name = PyUnicode_Decode(object->in.domain_name, strlen(object->in.domain_name), "utf-8", "ignore");
	}
	return py_domain_name;
}

static int py_wbint_NormalizeNameMap_in_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_NormalizeNameMap *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.domain_name");
		return -1;
	}
	object->in.domain_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.domain_name);
	if (object->in.domain_name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.domain_name = talloc_str;
	}
	return 0;
}

static PyObject *py_wbint_NormalizeNameMap_in_get_name(PyObject *obj, void *closure)
{
	struct wbint_NormalizeNameMap *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	if (object->in.name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.name == NULL) {
		py_name = Py_None;
		Py_INCREF(py_name);
	} else {
		py_name = PyUnicode_Decode(object->in.name, strlen(object->in.name), "utf-8", "ignore");
	}
	return py_name;
}

static int py_wbint_NormalizeNameMap_in_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_NormalizeNameMap *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.name");
		return -1;
	}
	object->in.name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.name);
	if (object->in.name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.name = talloc_str;
	}
	return 0;
}

static PyObject *py_wbint_NormalizeNameMap_out_get_mapped_name(PyObject *obj, void *closure)
{
	struct wbint_NormalizeNameMap *object = pytalloc_get_ptr(obj);
	PyObject *py_mapped_name;
	if (object->out.mapped_name == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.mapped_name == NULL) {
		py_mapped_name = Py_None;
		Py_INCREF(py_mapped_name);
	} else {
		if (*object->out.mapped_name == NULL) {
			py_mapped_name = Py_None;
			Py_INCREF(py_mapped_name);
		} else {
			py_mapped_name = PyUnicode_Decode(*object->out.mapped_name, strlen(*object->out.mapped_name), "utf-8", "ignore");
		}
	}
	return py_mapped_name;
}

static int py_wbint_NormalizeNameMap_out_set_mapped_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_NormalizeNameMap *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.mapped_name));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.mapped_name");
		return -1;
	}
	object->out.mapped_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.mapped_name);
	if (object->out.mapped_name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.mapped_name = NULL;
	} else {
		*object->out.mapped_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			*object->out.mapped_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wbint_NormalizeNameMap_get_result(PyObject *obj, void *closure)
{
	struct wbint_NormalizeNameMap *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_wbint_NormalizeNameMap_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_NormalizeNameMap *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wbint_NormalizeNameMap_getsetters[] = {
	{
		.name = discard_const_p(char, "in_domain_name"),
		.get = py_wbint_NormalizeNameMap_in_get_domain_name,
		.set = py_wbint_NormalizeNameMap_in_set_domain_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_name"),
		.get = py_wbint_NormalizeNameMap_in_get_name,
		.set = py_wbint_NormalizeNameMap_in_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "out_mapped_name"),
		.get = py_wbint_NormalizeNameMap_out_get_mapped_name,
		.set = py_wbint_NormalizeNameMap_out_set_mapped_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wbint_NormalizeNameMap_get_result,
		.set = py_wbint_NormalizeNameMap_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_wbint_NormalizeNameMap_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wbint_NormalizeNameMap, type);
	return self;
}

static PyObject *py_wbint_NormalizeNameMap_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(28);
}

static PyObject *py_wbint_NormalizeNameMap_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_NormalizeNameMap *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 29) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_NormalizeNameMap_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[28];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wbint_NormalizeNameMap_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_NormalizeNameMap_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wbint_NormalizeNameMap_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_NormalizeNameMap_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wbint_NormalizeNameMap_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_NormalizeNameMap *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 29) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_NormalizeNameMap_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[28];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wbint_NormalizeNameMap_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_NormalizeNameMap_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_NormalizeNameMap_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_NormalizeNameMap_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_NormalizeNameMap_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_NormalizeNameMap *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winbind.num_calls < 29) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_NormalizeNameMap_ndr_print");
		return NULL;
	}
	call = &ndr_table_winbind.calls[28];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wbint_NormalizeNameMap_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_NormalizeNameMap_ndr_print(py_obj, args, kwargs, "wbint_NormalizeNameMap_in", NDR_IN);
}

static PyObject *py_wbint_NormalizeNameMap_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_NormalizeNameMap_ndr_print(py_obj, args, kwargs, "wbint_NormalizeNameMap_out", NDR_OUT);
}

static PyMethodDef py_wbint_NormalizeNameMap_methods[] = {
	{ "opnum", (PyCFunction)py_wbint_NormalizeNameMap_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winbind.wbint_NormalizeNameMap.opnum() -> 28 (0x1c) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_NormalizeNameMap_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_NormalizeNameMap_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_NormalizeNameMap_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_NormalizeNameMap_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_NormalizeNameMap_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_NormalizeNameMap_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wbint_NormalizeNameMap_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.wbint_NormalizeNameMap",
	.tp_getset = py_wbint_NormalizeNameMap_getsetters,
	.tp_methods = py_wbint_NormalizeNameMap_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wbint_NormalizeNameMap_new,
};

static bool pack_py_wbint_NormalizeNameMap_args_in(PyObject *args, PyObject *kwargs, struct wbint_NormalizeNameMap *r)
{
	PyObject *py_domain_name;
	PyObject *py_name;
	const char *kwnames[] = {
		"domain_name", "name", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:wbint_NormalizeNameMap", discard_const_p(char *, kwnames), &py_domain_name, &py_name)) {
		return false;
	}

	if (py_domain_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.domain_name");
		return false;
	}
	r->in.domain_name = talloc_ptrtype(r, r->in.domain_name);
	if (r->in.domain_name == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_domain_name)) {
			unicode = PyUnicode_AsEncodedString(py_domain_name, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_domain_name)) {
			test_str = PyBytes_AS_STRING(py_domain_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_domain_name)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.domain_name = talloc_str;
	}
	if (py_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.name");
		return false;
	}
	r->in.name = talloc_ptrtype(r, r->in.name);
	if (r->in.name == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_name)) {
			unicode = PyUnicode_AsEncodedString(py_name, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_name)) {
			test_str = PyBytes_AS_STRING(py_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_name)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.name = talloc_str;
	}
	return true;
}

static PyObject *unpack_py_wbint_NormalizeNameMap_args_out(struct wbint_NormalizeNameMap *r, bool raise_result_exception)
{
	PyObject *py_mapped_name = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	if (*r->out.mapped_name == NULL) {
		py_mapped_name = Py_None;
		Py_INCREF(py_mapped_name);
	} else {
		if (*r->out.mapped_name == NULL) {
			py_mapped_name = Py_None;
			Py_INCREF(py_mapped_name);
		} else {
			py_mapped_name = PyUnicode_Decode(*r->out.mapped_name, strlen(*r->out.mapped_name), "utf-8", "ignore");
		}
	}
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_mapped_name);
	}
	if (result_size == 1) {
		result = py_mapped_name;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_wbint_NormalizeNameUnmap_in_get_name(PyObject *obj, void *closure)
{
	struct wbint_NormalizeNameUnmap *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	if (object->in.name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.name == NULL) {
		py_name = Py_None;
		Py_INCREF(py_name);
	} else {
		py_name = PyUnicode_Decode(object->in.name, strlen(object->in.name), "utf-8", "ignore");
	}
	return py_name;
}

static int py_wbint_NormalizeNameUnmap_in_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_NormalizeNameUnmap *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.name");
		return -1;
	}
	object->in.name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.name);
	if (object->in.name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.name = talloc_str;
	}
	return 0;
}

static PyObject *py_wbint_NormalizeNameUnmap_out_get_unmapped_name(PyObject *obj, void *closure)
{
	struct wbint_NormalizeNameUnmap *object = pytalloc_get_ptr(obj);
	PyObject *py_unmapped_name;
	if (object->out.unmapped_name == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.unmapped_name == NULL) {
		py_unmapped_name = Py_None;
		Py_INCREF(py_unmapped_name);
	} else {
		if (*object->out.unmapped_name == NULL) {
			py_unmapped_name = Py_None;
			Py_INCREF(py_unmapped_name);
		} else {
			py_unmapped_name = PyUnicode_Decode(*object->out.unmapped_name, strlen(*object->out.unmapped_name), "utf-8", "ignore");
		}
	}
	return py_unmapped_name;
}

static int py_wbint_NormalizeNameUnmap_out_set_unmapped_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_NormalizeNameUnmap *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.unmapped_name));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.unmapped_name");
		return -1;
	}
	object->out.unmapped_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.unmapped_name);
	if (object->out.unmapped_name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.unmapped_name = NULL;
	} else {
		*object->out.unmapped_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			*object->out.unmapped_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_wbint_NormalizeNameUnmap_get_result(PyObject *obj, void *closure)
{
	struct wbint_NormalizeNameUnmap *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_wbint_NormalizeNameUnmap_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct wbint_NormalizeNameUnmap *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_wbint_NormalizeNameUnmap_getsetters[] = {
	{
		.name = discard_const_p(char, "in_name"),
		.get = py_wbint_NormalizeNameUnmap_in_get_name,
		.set = py_wbint_NormalizeNameUnmap_in_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "out_unmapped_name"),
		.get = py_wbint_NormalizeNameUnmap_out_get_unmapped_name,
		.set = py_wbint_NormalizeNameUnmap_out_set_unmapped_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_wbint_NormalizeNameUnmap_get_result,
		.set = py_wbint_NormalizeNameUnmap_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_wbint_NormalizeNameUnmap_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct wbint_NormalizeNameUnmap, type);
	return self;
}

static PyObject *py_wbint_NormalizeNameUnmap_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(29);
}

static PyObject *py_wbint_NormalizeNameUnmap_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_NormalizeNameUnmap *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 30) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_NormalizeNameUnmap_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[29];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_wbint_NormalizeNameUnmap_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_NormalizeNameUnmap_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_wbint_NormalizeNameUnmap_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_wbint_NormalizeNameUnmap_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_wbint_NormalizeNameUnmap_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_NormalizeNameUnmap *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 30) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_NormalizeNameUnmap_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[29];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_wbint_NormalizeNameUnmap_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_NormalizeNameUnmap_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_NormalizeNameUnmap_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_wbint_NormalizeNameUnmap_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_wbint_NormalizeNameUnmap_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct wbint_NormalizeNameUnmap *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winbind.num_calls < 30) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_wbint_NormalizeNameUnmap_ndr_print");
		return NULL;
	}
	call = &ndr_table_winbind.calls[29];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_wbint_NormalizeNameUnmap_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_NormalizeNameUnmap_ndr_print(py_obj, args, kwargs, "wbint_NormalizeNameUnmap_in", NDR_IN);
}

static PyObject *py_wbint_NormalizeNameUnmap_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_wbint_NormalizeNameUnmap_ndr_print(py_obj, args, kwargs, "wbint_NormalizeNameUnmap_out", NDR_OUT);
}

static PyMethodDef py_wbint_NormalizeNameUnmap_methods[] = {
	{ "opnum", (PyCFunction)py_wbint_NormalizeNameUnmap_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winbind.wbint_NormalizeNameUnmap.opnum() -> 29 (0x1d) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_NormalizeNameUnmap_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_NormalizeNameUnmap_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_NormalizeNameUnmap_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_NormalizeNameUnmap_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_NormalizeNameUnmap_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_wbint_NormalizeNameUnmap_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject wbint_NormalizeNameUnmap_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.wbint_NormalizeNameUnmap",
	.tp_getset = py_wbint_NormalizeNameUnmap_getsetters,
	.tp_methods = py_wbint_NormalizeNameUnmap_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_wbint_NormalizeNameUnmap_new,
};

static bool pack_py_wbint_NormalizeNameUnmap_args_in(PyObject *args, PyObject *kwargs, struct wbint_NormalizeNameUnmap *r)
{
	PyObject *py_name;
	const char *kwnames[] = {
		"name", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:wbint_NormalizeNameUnmap", discard_const_p(char *, kwnames), &py_name)) {
		return false;
	}

	if (py_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.name");
		return false;
	}
	r->in.name = talloc_ptrtype(r, r->in.name);
	if (r->in.name == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_name)) {
			unicode = PyUnicode_AsEncodedString(py_name, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_name)) {
			test_str = PyBytes_AS_STRING(py_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_name)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.name = talloc_str;
	}
	return true;
}

static PyObject *unpack_py_wbint_NormalizeNameUnmap_args_out(struct wbint_NormalizeNameUnmap *r, bool raise_result_exception)
{
	PyObject *py_unmapped_name = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	if (*r->out.unmapped_name == NULL) {
		py_unmapped_name = Py_None;
		Py_INCREF(py_unmapped_name);
	} else {
		if (*r->out.unmapped_name == NULL) {
			py_unmapped_name = Py_None;
			Py_INCREF(py_unmapped_name);
		} else {
			py_unmapped_name = PyUnicode_Decode(*r->out.unmapped_name, strlen(*r->out.unmapped_name), "utf-8", "ignore");
		}
	}
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_unmapped_name);
	}
	if (result_size == 1) {
		result = py_unmapped_name;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_winbind_SamLogon_in_get_internal_flags(PyObject *obj, void *closure)
{
	struct winbind_SamLogon *object = pytalloc_get_ptr(obj);
	PyObject *py_internal_flags;
	py_internal_flags = PyLong_FromLong((uint16_t)(object->in.internal_flags));
	return py_internal_flags;
}

static int py_winbind_SamLogon_in_set_internal_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winbind_SamLogon *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.internal_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.internal_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.internal_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winbind_SamLogon_in_get_logon_level(PyObject *obj, void *closure)
{
	struct winbind_SamLogon *object = pytalloc_get_ptr(obj);
	PyObject *py_logon_level;
	py_logon_level = PyLong_FromLong((uint16_t)(object->in.logon_level));
	return py_logon_level;
}

static int py_winbind_SamLogon_in_set_logon_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winbind_SamLogon *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.logon_level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.logon_level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.logon_level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winbind_SamLogon_in_get_logon(PyObject *obj, void *closure)
{
	struct winbind_SamLogon *object = pytalloc_get_ptr(obj);
	PyObject *py_logon;
	py_logon = pyrpc_import_union(netr_LogonLevel_Type, pytalloc_get_mem_ctx(obj), object->in.logon_level, &object->in.logon, "union netr_LogonLevel");
	if (py_logon == NULL) {
		return NULL;
	}
	return py_logon;
}

static int py_winbind_SamLogon_in_set_logon(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winbind_SamLogon *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.logon");
		return -1;
	}
	{
		union netr_LogonLevel *logon_switch_0;
		logon_switch_0 = (union netr_LogonLevel *)pyrpc_export_union(netr_LogonLevel_Type, pytalloc_get_mem_ctx(py_obj), object->in.logon_level, value, "union netr_LogonLevel");
		if (logon_switch_0 == NULL) {
			return -1;
		}
		object->in.logon = *logon_switch_0;
	}
	return 0;
}

static PyObject *py_winbind_SamLogon_in_get_validation_level(PyObject *obj, void *closure)
{
	struct winbind_SamLogon *object = pytalloc_get_ptr(obj);
	PyObject *py_validation_level;
	py_validation_level = PyLong_FromLong((uint16_t)(object->in.validation_level));
	return py_validation_level;
}

static int py_winbind_SamLogon_in_set_validation_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winbind_SamLogon *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.validation_level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.validation_level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.validation_level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winbind_SamLogon_out_get_validation(PyObject *obj, void *closure)
{
	struct winbind_SamLogon *object = pytalloc_get_ptr(obj);
	PyObject *py_validation;
	py_validation = pyrpc_import_union(netr_Validation_Type, pytalloc_get_mem_ctx(obj), object->in.validation_level, &object->out.validation, "union netr_Validation");
	if (py_validation == NULL) {
		return NULL;
	}
	return py_validation;
}

static int py_winbind_SamLogon_out_set_validation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winbind_SamLogon *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.validation");
		return -1;
	}
	{
		union netr_Validation *validation_switch_0;
		validation_switch_0 = (union netr_Validation *)pyrpc_export_union(netr_Validation_Type, pytalloc_get_mem_ctx(py_obj), object->in.validation_level, value, "union netr_Validation");
		if (validation_switch_0 == NULL) {
			return -1;
		}
		object->out.validation = *validation_switch_0;
	}
	return 0;
}

static PyObject *py_winbind_SamLogon_out_get_authoritative(PyObject *obj, void *closure)
{
	struct winbind_SamLogon *object = pytalloc_get_ptr(obj);
	PyObject *py_authoritative;
	py_authoritative = PyLong_FromLong((uint16_t)(object->out.authoritative));
	return py_authoritative;
}

static int py_winbind_SamLogon_out_set_authoritative(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winbind_SamLogon *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.authoritative");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->out.authoritative));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->out.authoritative = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winbind_SamLogon_get_result(PyObject *obj, void *closure)
{
	struct winbind_SamLogon *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_winbind_SamLogon_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winbind_SamLogon *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winbind_SamLogon_getsetters[] = {
	{
		.name = discard_const_p(char, "in_internal_flags"),
		.get = py_winbind_SamLogon_in_get_internal_flags,
		.set = py_winbind_SamLogon_in_set_internal_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type winbind_SamLogonInternalFlags")
	},
	{
		.name = discard_const_p(char, "in_logon_level"),
		.get = py_winbind_SamLogon_in_get_logon_level,
		.set = py_winbind_SamLogon_in_set_logon_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_logon"),
		.get = py_winbind_SamLogon_in_get_logon,
		.set = py_winbind_SamLogon_in_set_logon,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_LogonLevel")
	},
	{
		.name = discard_const_p(char, "in_validation_level"),
		.get = py_winbind_SamLogon_in_get_validation_level,
		.set = py_winbind_SamLogon_in_set_validation_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "out_validation"),
		.get = py_winbind_SamLogon_out_get_validation,
		.set = py_winbind_SamLogon_out_set_validation,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_Validation")
	},
	{
		.name = discard_const_p(char, "out_authoritative"),
		.get = py_winbind_SamLogon_out_get_authoritative,
		.set = py_winbind_SamLogon_out_set_authoritative,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winbind_SamLogon_get_result,
		.set = py_winbind_SamLogon_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_winbind_SamLogon_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winbind_SamLogon, type);
	return self;
}

static PyObject *py_winbind_SamLogon_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(30);
}

static PyObject *py_winbind_SamLogon_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winbind_SamLogon *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 31) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winbind_SamLogon_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[30];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winbind_SamLogon_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winbind_SamLogon_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winbind_SamLogon_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winbind_SamLogon_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winbind_SamLogon_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winbind_SamLogon *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 31) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winbind_SamLogon_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[30];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winbind_SamLogon_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winbind_SamLogon_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winbind_SamLogon_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winbind_SamLogon_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winbind_SamLogon_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winbind_SamLogon *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winbind.num_calls < 31) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winbind_SamLogon_ndr_print");
		return NULL;
	}
	call = &ndr_table_winbind.calls[30];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winbind_SamLogon_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winbind_SamLogon_ndr_print(py_obj, args, kwargs, "winbind_SamLogon_in", NDR_IN);
}

static PyObject *py_winbind_SamLogon_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winbind_SamLogon_ndr_print(py_obj, args, kwargs, "winbind_SamLogon_out", NDR_OUT);
}

static PyMethodDef py_winbind_SamLogon_methods[] = {
	{ "opnum", (PyCFunction)py_winbind_SamLogon_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winbind.SamLogon.opnum() -> 30 (0x1e) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winbind_SamLogon_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winbind_SamLogon_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winbind_SamLogon_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winbind_SamLogon_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winbind_SamLogon_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winbind_SamLogon_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winbind_SamLogon_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.SamLogon",
	.tp_getset = py_winbind_SamLogon_getsetters,
	.tp_methods = py_winbind_SamLogon_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winbind_SamLogon_new,
};

static bool pack_py_winbind_SamLogon_args_in(PyObject *args, PyObject *kwargs, struct winbind_SamLogon *r)
{
	PyObject *py_internal_flags;
	PyObject *py_logon_level;
	PyObject *py_logon;
	PyObject *py_validation_level;
	const char *kwnames[] = {
		"internal_flags", "logon_level", "logon", "validation_level", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:winbind_SamLogon", discard_const_p(char *, kwnames), &py_internal_flags, &py_logon_level, &py_logon, &py_validation_level)) {
		return false;
	}

	if (py_internal_flags == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.internal_flags");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.internal_flags));
		if (PyLong_Check(py_internal_flags)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_internal_flags);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.internal_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_logon_level == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.logon_level");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.logon_level));
		if (PyLong_Check(py_logon_level)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_logon_level);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.logon_level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_logon == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.logon");
		return false;
	}
	{
		union netr_LogonLevel *logon_switch_0;
		logon_switch_0 = (union netr_LogonLevel *)pyrpc_export_union(netr_LogonLevel_Type, r, r->in.logon_level, py_logon, "union netr_LogonLevel");
		if (logon_switch_0 == NULL) {
			return false;
		}
		r->in.logon = *logon_switch_0;
	}
	if (py_validation_level == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.validation_level");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.validation_level));
		if (PyLong_Check(py_validation_level)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_validation_level);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.validation_level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_winbind_SamLogon_args_out(struct winbind_SamLogon *r, bool raise_result_exception)
{
	PyObject *py_validation = NULL;
	PyObject *py_authoritative = NULL;
	PyObject *result = NULL;
	size_t result_size = 2;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_validation = pyrpc_import_union(netr_Validation_Type, r, r->in.validation_level, &r->out.validation, "union netr_Validation");
	if (py_validation == NULL) {
		return NULL;
	}
	PyTuple_SetItem(result, 0, py_validation);

	py_authoritative = PyLong_FromLong((uint16_t)(r->out.authoritative));
	PyTuple_SetItem(result, 1, py_authoritative);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 2, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_winbind_DsrUpdateReadOnlyServerDnsRecords_in_get_site_name(PyObject *obj, void *closure)
{
	struct winbind_DsrUpdateReadOnlyServerDnsRecords *object = pytalloc_get_ptr(obj);
	PyObject *py_site_name;
	if (object->in.site_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.site_name == NULL) {
		py_site_name = Py_None;
		Py_INCREF(py_site_name);
	} else {
		if (object->in.site_name == NULL) {
			py_site_name = Py_None;
			Py_INCREF(py_site_name);
		} else {
			py_site_name = PyUnicode_Decode(object->in.site_name, strlen(object->in.site_name), "utf-8", "ignore");
		}
	}
	return py_site_name;
}

static int py_winbind_DsrUpdateReadOnlyServerDnsRecords_in_set_site_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winbind_DsrUpdateReadOnlyServerDnsRecords *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.site_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.site_name = NULL;
	} else {
		object->in.site_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.site_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_winbind_DsrUpdateReadOnlyServerDnsRecords_in_get_dns_ttl(PyObject *obj, void *closure)
{
	struct winbind_DsrUpdateReadOnlyServerDnsRecords *object = pytalloc_get_ptr(obj);
	PyObject *py_dns_ttl;
	py_dns_ttl = PyLong_FromUnsignedLongLong((uint32_t)(object->in.dns_ttl));
	return py_dns_ttl;
}

static int py_winbind_DsrUpdateReadOnlyServerDnsRecords_in_set_dns_ttl(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winbind_DsrUpdateReadOnlyServerDnsRecords *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.dns_ttl");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.dns_ttl));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.dns_ttl = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winbind_DsrUpdateReadOnlyServerDnsRecords_in_get_dns_names(PyObject *obj, void *closure)
{
	struct winbind_DsrUpdateReadOnlyServerDnsRecords *object = pytalloc_get_ptr(obj);
	PyObject *py_dns_names;
	if (object->in.dns_names == NULL) {
		Py_RETURN_NONE;
	}
	py_dns_names = pytalloc_reference_ex(NL_DNS_NAME_INFO_ARRAY_Type, object->in.dns_names, object->in.dns_names);
	return py_dns_names;
}

static int py_winbind_DsrUpdateReadOnlyServerDnsRecords_in_set_dns_names(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winbind_DsrUpdateReadOnlyServerDnsRecords *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.dns_names));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.dns_names");
		return -1;
	}
	object->in.dns_names = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.dns_names);
	if (object->in.dns_names == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(NL_DNS_NAME_INFO_ARRAY_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.dns_names = (struct NL_DNS_NAME_INFO_ARRAY *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winbind_DsrUpdateReadOnlyServerDnsRecords_out_get_dns_names(PyObject *obj, void *closure)
{
	struct winbind_DsrUpdateReadOnlyServerDnsRecords *object = pytalloc_get_ptr(obj);
	PyObject *py_dns_names;
	if (object->out.dns_names == NULL) {
		Py_RETURN_NONE;
	}
	py_dns_names = pytalloc_reference_ex(NL_DNS_NAME_INFO_ARRAY_Type, object->out.dns_names, object->out.dns_names);
	return py_dns_names;
}

static int py_winbind_DsrUpdateReadOnlyServerDnsRecords_out_set_dns_names(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winbind_DsrUpdateReadOnlyServerDnsRecords *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.dns_names));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.dns_names");
		return -1;
	}
	object->out.dns_names = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.dns_names);
	if (object->out.dns_names == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(NL_DNS_NAME_INFO_ARRAY_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.dns_names = (struct NL_DNS_NAME_INFO_ARRAY *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winbind_DsrUpdateReadOnlyServerDnsRecords_get_result(PyObject *obj, void *closure)
{
	struct winbind_DsrUpdateReadOnlyServerDnsRecords *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_winbind_DsrUpdateReadOnlyServerDnsRecords_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winbind_DsrUpdateReadOnlyServerDnsRecords *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winbind_DsrUpdateReadOnlyServerDnsRecords_getsetters[] = {
	{
		.name = discard_const_p(char, "in_site_name"),
		.get = py_winbind_DsrUpdateReadOnlyServerDnsRecords_in_get_site_name,
		.set = py_winbind_DsrUpdateReadOnlyServerDnsRecords_in_set_site_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_dns_ttl"),
		.get = py_winbind_DsrUpdateReadOnlyServerDnsRecords_in_get_dns_ttl,
		.set = py_winbind_DsrUpdateReadOnlyServerDnsRecords_in_set_dns_ttl,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_dns_names"),
		.get = py_winbind_DsrUpdateReadOnlyServerDnsRecords_in_get_dns_names,
		.set = py_winbind_DsrUpdateReadOnlyServerDnsRecords_in_set_dns_names,
		.doc = discard_const_p(char, "PIDL-generated element of base type NL_DNS_NAME_INFO_ARRAY")
	},
	{
		.name = discard_const_p(char, "out_dns_names"),
		.get = py_winbind_DsrUpdateReadOnlyServerDnsRecords_out_get_dns_names,
		.set = py_winbind_DsrUpdateReadOnlyServerDnsRecords_out_set_dns_names,
		.doc = discard_const_p(char, "PIDL-generated element of base type NL_DNS_NAME_INFO_ARRAY")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winbind_DsrUpdateReadOnlyServerDnsRecords_get_result,
		.set = py_winbind_DsrUpdateReadOnlyServerDnsRecords_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_winbind_DsrUpdateReadOnlyServerDnsRecords_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winbind_DsrUpdateReadOnlyServerDnsRecords, type);
	struct winbind_DsrUpdateReadOnlyServerDnsRecords *_self = (struct winbind_DsrUpdateReadOnlyServerDnsRecords *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.dns_names = talloc_zero(mem_ctx, struct NL_DNS_NAME_INFO_ARRAY);
	_self->out.dns_names = talloc_zero(mem_ctx, struct NL_DNS_NAME_INFO_ARRAY);
	return self;
}

static PyObject *py_winbind_DsrUpdateReadOnlyServerDnsRecords_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(31);
}

static PyObject *py_winbind_DsrUpdateReadOnlyServerDnsRecords_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winbind_DsrUpdateReadOnlyServerDnsRecords *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 32) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winbind_DsrUpdateReadOnlyServerDnsRecords_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[31];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winbind_DsrUpdateReadOnlyServerDnsRecords_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winbind_DsrUpdateReadOnlyServerDnsRecords_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winbind_DsrUpdateReadOnlyServerDnsRecords_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winbind_DsrUpdateReadOnlyServerDnsRecords_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winbind_DsrUpdateReadOnlyServerDnsRecords_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winbind_DsrUpdateReadOnlyServerDnsRecords *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 32) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winbind_DsrUpdateReadOnlyServerDnsRecords_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[31];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winbind_DsrUpdateReadOnlyServerDnsRecords_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winbind_DsrUpdateReadOnlyServerDnsRecords_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winbind_DsrUpdateReadOnlyServerDnsRecords_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winbind_DsrUpdateReadOnlyServerDnsRecords_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winbind_DsrUpdateReadOnlyServerDnsRecords_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winbind_DsrUpdateReadOnlyServerDnsRecords *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winbind.num_calls < 32) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winbind_DsrUpdateReadOnlyServerDnsRecords_ndr_print");
		return NULL;
	}
	call = &ndr_table_winbind.calls[31];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winbind_DsrUpdateReadOnlyServerDnsRecords_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winbind_DsrUpdateReadOnlyServerDnsRecords_ndr_print(py_obj, args, kwargs, "winbind_DsrUpdateReadOnlyServerDnsRecords_in", NDR_IN);
}

static PyObject *py_winbind_DsrUpdateReadOnlyServerDnsRecords_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winbind_DsrUpdateReadOnlyServerDnsRecords_ndr_print(py_obj, args, kwargs, "winbind_DsrUpdateReadOnlyServerDnsRecords_out", NDR_OUT);
}

static PyMethodDef py_winbind_DsrUpdateReadOnlyServerDnsRecords_methods[] = {
	{ "opnum", (PyCFunction)py_winbind_DsrUpdateReadOnlyServerDnsRecords_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winbind.DsrUpdateReadOnlyServerDnsRecords.opnum() -> 31 (0x1f) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winbind_DsrUpdateReadOnlyServerDnsRecords_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winbind_DsrUpdateReadOnlyServerDnsRecords_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winbind_DsrUpdateReadOnlyServerDnsRecords_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winbind_DsrUpdateReadOnlyServerDnsRecords_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winbind_DsrUpdateReadOnlyServerDnsRecords_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winbind_DsrUpdateReadOnlyServerDnsRecords_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winbind_DsrUpdateReadOnlyServerDnsRecords_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.DsrUpdateReadOnlyServerDnsRecords",
	.tp_getset = py_winbind_DsrUpdateReadOnlyServerDnsRecords_getsetters,
	.tp_methods = py_winbind_DsrUpdateReadOnlyServerDnsRecords_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winbind_DsrUpdateReadOnlyServerDnsRecords_new,
};

static bool pack_py_winbind_DsrUpdateReadOnlyServerDnsRecords_args_in(PyObject *args, PyObject *kwargs, struct winbind_DsrUpdateReadOnlyServerDnsRecords *r)
{
	PyObject *py_site_name;
	PyObject *py_dns_ttl;
	PyObject *py_dns_names;
	const char *kwnames[] = {
		"site_name", "dns_ttl", "dns_names", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:winbind_DsrUpdateReadOnlyServerDnsRecords", discard_const_p(char *, kwnames), &py_site_name, &py_dns_ttl, &py_dns_names)) {
		return false;
	}

	if (py_site_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.site_name");
		return false;
	}
	if (py_site_name == Py_None) {
		r->in.site_name = NULL;
	} else {
		r->in.site_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_site_name)) {
				unicode = PyUnicode_AsEncodedString(py_site_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_site_name)) {
				test_str = PyBytes_AS_STRING(py_site_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_site_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.site_name = talloc_str;
		}
	}
	if (py_dns_ttl == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.dns_ttl");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.dns_ttl));
		if (PyLong_Check(py_dns_ttl)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_dns_ttl);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.dns_ttl = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_dns_names == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.dns_names");
		return false;
	}
	r->in.dns_names = talloc_ptrtype(r, r->in.dns_names);
	if (r->in.dns_names == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(NL_DNS_NAME_INFO_ARRAY_Type, py_dns_names, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_dns_names)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.dns_names = (struct NL_DNS_NAME_INFO_ARRAY *)pytalloc_get_ptr(py_dns_names);
	return true;
}

static PyObject *unpack_py_winbind_DsrUpdateReadOnlyServerDnsRecords_args_out(struct winbind_DsrUpdateReadOnlyServerDnsRecords *r, bool raise_result_exception)
{
	PyObject *py_dns_names = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_dns_names = pytalloc_reference_ex(NL_DNS_NAME_INFO_ARRAY_Type, r->out.dns_names, r->out.dns_names);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_dns_names);
	}
	if (result_size == 1) {
		result = py_dns_names;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_winbind_LogonControl_in_get_function_code(PyObject *obj, void *closure)
{
	struct winbind_LogonControl *object = pytalloc_get_ptr(obj);
	PyObject *py_function_code;
	py_function_code = PyLong_FromUnsignedLongLong((uint32_t)(object->in.function_code));
	return py_function_code;
}

static int py_winbind_LogonControl_in_set_function_code(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winbind_LogonControl *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.function_code");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.function_code));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.function_code = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winbind_LogonControl_in_get_level(PyObject *obj, void *closure)
{
	struct winbind_LogonControl *object = pytalloc_get_ptr(obj);
	PyObject *py_level;
	py_level = PyLong_FromUnsignedLongLong((uint32_t)(object->in.level));
	return py_level;
}

static int py_winbind_LogonControl_in_set_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winbind_LogonControl *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winbind_LogonControl_in_get_data(PyObject *obj, void *closure)
{
	struct winbind_LogonControl *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	if (object->in.data == NULL) {
		Py_RETURN_NONE;
	}
	py_data = pyrpc_import_union(netr_CONTROL_DATA_INFORMATION_Type, object->in.data, object->in.function_code, object->in.data, "union netr_CONTROL_DATA_INFORMATION");
	if (py_data == NULL) {
		return NULL;
	}
	return py_data;
}

static int py_winbind_LogonControl_in_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winbind_LogonControl *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.data));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.data");
		return -1;
	}
	object->in.data = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.data);
	if (object->in.data == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		union netr_CONTROL_DATA_INFORMATION *data_switch_1;
		data_switch_1 = (union netr_CONTROL_DATA_INFORMATION *)pyrpc_export_union(netr_CONTROL_DATA_INFORMATION_Type, pytalloc_get_mem_ctx(py_obj), object->in.function_code, value, "union netr_CONTROL_DATA_INFORMATION");
		if (data_switch_1 == NULL) {
			return -1;
		}
		object->in.data = data_switch_1;
	}
	return 0;
}

static PyObject *py_winbind_LogonControl_out_get_query(PyObject *obj, void *closure)
{
	struct winbind_LogonControl *object = pytalloc_get_ptr(obj);
	PyObject *py_query;
	if (object->out.query == NULL) {
		Py_RETURN_NONE;
	}
	py_query = pyrpc_import_union(netr_CONTROL_QUERY_INFORMATION_Type, object->out.query, object->in.level, object->out.query, "union netr_CONTROL_QUERY_INFORMATION");
	if (py_query == NULL) {
		return NULL;
	}
	return py_query;
}

static int py_winbind_LogonControl_out_set_query(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winbind_LogonControl *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.query));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.query");
		return -1;
	}
	object->out.query = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.query);
	if (object->out.query == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		union netr_CONTROL_QUERY_INFORMATION *query_switch_1;
		query_switch_1 = (union netr_CONTROL_QUERY_INFORMATION *)pyrpc_export_union(netr_CONTROL_QUERY_INFORMATION_Type, pytalloc_get_mem_ctx(py_obj), object->in.level, value, "union netr_CONTROL_QUERY_INFORMATION");
		if (query_switch_1 == NULL) {
			return -1;
		}
		object->out.query = query_switch_1;
	}
	return 0;
}

static PyObject *py_winbind_LogonControl_get_result(PyObject *obj, void *closure)
{
	struct winbind_LogonControl *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winbind_LogonControl_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winbind_LogonControl *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winbind_LogonControl_getsetters[] = {
	{
		.name = discard_const_p(char, "in_function_code"),
		.get = py_winbind_LogonControl_in_get_function_code,
		.set = py_winbind_LogonControl_in_set_function_code,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_LogonControlCode")
	},
	{
		.name = discard_const_p(char, "in_level"),
		.get = py_winbind_LogonControl_in_get_level,
		.set = py_winbind_LogonControl_in_set_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_data"),
		.get = py_winbind_LogonControl_in_get_data,
		.set = py_winbind_LogonControl_in_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_CONTROL_DATA_INFORMATION")
	},
	{
		.name = discard_const_p(char, "out_query"),
		.get = py_winbind_LogonControl_out_get_query,
		.set = py_winbind_LogonControl_out_set_query,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_CONTROL_QUERY_INFORMATION")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winbind_LogonControl_get_result,
		.set = py_winbind_LogonControl_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winbind_LogonControl_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winbind_LogonControl, type);
	struct winbind_LogonControl *_self = (struct winbind_LogonControl *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.data = talloc_zero(mem_ctx, union netr_CONTROL_DATA_INFORMATION);
	_self->out.query = talloc_zero(mem_ctx, union netr_CONTROL_QUERY_INFORMATION);
	return self;
}

static PyObject *py_winbind_LogonControl_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(32);
}

static PyObject *py_winbind_LogonControl_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winbind_LogonControl *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 33) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winbind_LogonControl_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[32];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winbind_LogonControl_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winbind_LogonControl_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winbind_LogonControl_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winbind_LogonControl_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winbind_LogonControl_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winbind_LogonControl *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 33) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winbind_LogonControl_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[32];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winbind_LogonControl_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winbind_LogonControl_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winbind_LogonControl_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winbind_LogonControl_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winbind_LogonControl_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winbind_LogonControl *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winbind.num_calls < 33) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winbind_LogonControl_ndr_print");
		return NULL;
	}
	call = &ndr_table_winbind.calls[32];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winbind_LogonControl_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winbind_LogonControl_ndr_print(py_obj, args, kwargs, "winbind_LogonControl_in", NDR_IN);
}

static PyObject *py_winbind_LogonControl_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winbind_LogonControl_ndr_print(py_obj, args, kwargs, "winbind_LogonControl_out", NDR_OUT);
}

static PyMethodDef py_winbind_LogonControl_methods[] = {
	{ "opnum", (PyCFunction)py_winbind_LogonControl_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winbind.LogonControl.opnum() -> 32 (0x20) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winbind_LogonControl_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winbind_LogonControl_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winbind_LogonControl_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winbind_LogonControl_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winbind_LogonControl_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winbind_LogonControl_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winbind_LogonControl_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.LogonControl",
	.tp_getset = py_winbind_LogonControl_getsetters,
	.tp_methods = py_winbind_LogonControl_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winbind_LogonControl_new,
};

static bool pack_py_winbind_LogonControl_args_in(PyObject *args, PyObject *kwargs, struct winbind_LogonControl *r)
{
	PyObject *py_function_code;
	PyObject *py_level;
	PyObject *py_data;
	const char *kwnames[] = {
		"function_code", "level", "data", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:winbind_LogonControl", discard_const_p(char *, kwnames), &py_function_code, &py_level, &py_data)) {
		return false;
	}

	if (py_function_code == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.function_code");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.function_code));
		if (PyLong_Check(py_function_code)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_function_code);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.function_code = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_level == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.level");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.level));
		if (PyLong_Check(py_level)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_level);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_data == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.data");
		return false;
	}
	r->in.data = talloc_ptrtype(r, r->in.data);
	if (r->in.data == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		union netr_CONTROL_DATA_INFORMATION *data_switch_1;
		data_switch_1 = (union netr_CONTROL_DATA_INFORMATION *)pyrpc_export_union(netr_CONTROL_DATA_INFORMATION_Type, r, r->in.function_code, py_data, "union netr_CONTROL_DATA_INFORMATION");
		if (data_switch_1 == NULL) {
			return false;
		}
		r->in.data = data_switch_1;
	}
	return true;
}

static PyObject *unpack_py_winbind_LogonControl_args_out(struct winbind_LogonControl *r, bool raise_result_exception)
{
	PyObject *py_query = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_query = pyrpc_import_union(netr_CONTROL_QUERY_INFORMATION_Type, r->out.query, r->in.level, r->out.query, "union netr_CONTROL_QUERY_INFORMATION");
	if (py_query == NULL) {
		return NULL;
	}
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_query);
	}
	if (result_size == 1) {
		result = py_query;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winbind_GetForestTrustInformation_in_get_trusted_domain_name(PyObject *obj, void *closure)
{
	struct winbind_GetForestTrustInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_trusted_domain_name;
	if (object->in.trusted_domain_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.trusted_domain_name == NULL) {
		py_trusted_domain_name = Py_None;
		Py_INCREF(py_trusted_domain_name);
	} else {
		if (object->in.trusted_domain_name == NULL) {
			py_trusted_domain_name = Py_None;
			Py_INCREF(py_trusted_domain_name);
		} else {
			py_trusted_domain_name = PyUnicode_Decode(object->in.trusted_domain_name, strlen(object->in.trusted_domain_name), "utf-8", "ignore");
		}
	}
	return py_trusted_domain_name;
}

static int py_winbind_GetForestTrustInformation_in_set_trusted_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winbind_GetForestTrustInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.trusted_domain_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.trusted_domain_name = NULL;
	} else {
		object->in.trusted_domain_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.trusted_domain_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_winbind_GetForestTrustInformation_in_get_flags(PyObject *obj, void *closure)
{
	struct winbind_GetForestTrustInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->in.flags));
	return py_flags;
}

static int py_winbind_GetForestTrustInformation_in_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winbind_GetForestTrustInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winbind_GetForestTrustInformation_out_get_forest_trust_info(PyObject *obj, void *closure)
{
	struct winbind_GetForestTrustInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_forest_trust_info;
	if (object->out.forest_trust_info == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.forest_trust_info == NULL) {
		py_forest_trust_info = Py_None;
		Py_INCREF(py_forest_trust_info);
	} else {
		py_forest_trust_info = pytalloc_reference_ex(lsa_ForestTrustInformation_Type, *object->out.forest_trust_info, *object->out.forest_trust_info);
	}
	return py_forest_trust_info;
}

static int py_winbind_GetForestTrustInformation_out_set_forest_trust_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winbind_GetForestTrustInformation *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.forest_trust_info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.forest_trust_info");
		return -1;
	}
	object->out.forest_trust_info = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.forest_trust_info);
	if (object->out.forest_trust_info == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.forest_trust_info = NULL;
	} else {
		*object->out.forest_trust_info = NULL;
		PY_CHECK_TYPE(lsa_ForestTrustInformation_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		*object->out.forest_trust_info = (struct lsa_ForestTrustInformation *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_winbind_GetForestTrustInformation_get_result(PyObject *obj, void *closure)
{
	struct winbind_GetForestTrustInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winbind_GetForestTrustInformation_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winbind_GetForestTrustInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winbind_GetForestTrustInformation_getsetters[] = {
	{
		.name = discard_const_p(char, "in_trusted_domain_name"),
		.get = py_winbind_GetForestTrustInformation_in_get_trusted_domain_name,
		.set = py_winbind_GetForestTrustInformation_in_set_trusted_domain_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_flags"),
		.get = py_winbind_GetForestTrustInformation_in_get_flags,
		.set = py_winbind_GetForestTrustInformation_in_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_forest_trust_info"),
		.get = py_winbind_GetForestTrustInformation_out_get_forest_trust_info,
		.set = py_winbind_GetForestTrustInformation_out_set_forest_trust_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_ForestTrustInformation")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winbind_GetForestTrustInformation_get_result,
		.set = py_winbind_GetForestTrustInformation_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winbind_GetForestTrustInformation_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winbind_GetForestTrustInformation, type);
	struct winbind_GetForestTrustInformation *_self = (struct winbind_GetForestTrustInformation *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	/* a pointer to a NULL pointer */
	_self->out.forest_trust_info = talloc_zero(mem_ctx, struct lsa_ForestTrustInformation *);
	return self;
}

static PyObject *py_winbind_GetForestTrustInformation_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(33);
}

static PyObject *py_winbind_GetForestTrustInformation_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winbind_GetForestTrustInformation *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 34) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winbind_GetForestTrustInformation_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[33];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winbind_GetForestTrustInformation_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winbind_GetForestTrustInformation_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winbind_GetForestTrustInformation_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winbind_GetForestTrustInformation_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winbind_GetForestTrustInformation_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winbind_GetForestTrustInformation *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 34) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winbind_GetForestTrustInformation_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[33];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winbind_GetForestTrustInformation_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winbind_GetForestTrustInformation_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winbind_GetForestTrustInformation_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winbind_GetForestTrustInformation_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winbind_GetForestTrustInformation_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winbind_GetForestTrustInformation *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winbind.num_calls < 34) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winbind_GetForestTrustInformation_ndr_print");
		return NULL;
	}
	call = &ndr_table_winbind.calls[33];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winbind_GetForestTrustInformation_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winbind_GetForestTrustInformation_ndr_print(py_obj, args, kwargs, "winbind_GetForestTrustInformation_in", NDR_IN);
}

static PyObject *py_winbind_GetForestTrustInformation_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winbind_GetForestTrustInformation_ndr_print(py_obj, args, kwargs, "winbind_GetForestTrustInformation_out", NDR_OUT);
}

static PyMethodDef py_winbind_GetForestTrustInformation_methods[] = {
	{ "opnum", (PyCFunction)py_winbind_GetForestTrustInformation_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winbind.GetForestTrustInformation.opnum() -> 33 (0x21) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winbind_GetForestTrustInformation_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winbind_GetForestTrustInformation_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winbind_GetForestTrustInformation_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winbind_GetForestTrustInformation_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winbind_GetForestTrustInformation_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winbind_GetForestTrustInformation_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winbind_GetForestTrustInformation_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.GetForestTrustInformation",
	.tp_getset = py_winbind_GetForestTrustInformation_getsetters,
	.tp_methods = py_winbind_GetForestTrustInformation_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winbind_GetForestTrustInformation_new,
};

static bool pack_py_winbind_GetForestTrustInformation_args_in(PyObject *args, PyObject *kwargs, struct winbind_GetForestTrustInformation *r)
{
	PyObject *py_trusted_domain_name;
	PyObject *py_flags;
	const char *kwnames[] = {
		"trusted_domain_name", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winbind_GetForestTrustInformation", discard_const_p(char *, kwnames), &py_trusted_domain_name, &py_flags)) {
		return false;
	}

	if (py_trusted_domain_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.trusted_domain_name");
		return false;
	}
	if (py_trusted_domain_name == Py_None) {
		r->in.trusted_domain_name = NULL;
	} else {
		r->in.trusted_domain_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_trusted_domain_name)) {
				unicode = PyUnicode_AsEncodedString(py_trusted_domain_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_trusted_domain_name)) {
				test_str = PyBytes_AS_STRING(py_trusted_domain_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_trusted_domain_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.trusted_domain_name = talloc_str;
		}
	}
	if (py_flags == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.flags");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.flags));
		if (PyLong_Check(py_flags)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_flags);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_winbind_GetForestTrustInformation_args_out(struct winbind_GetForestTrustInformation *r, bool raise_result_exception)
{
	PyObject *py_forest_trust_info = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	if (*r->out.forest_trust_info == NULL) {
		py_forest_trust_info = Py_None;
		Py_INCREF(py_forest_trust_info);
	} else {
		py_forest_trust_info = pytalloc_reference_ex(lsa_ForestTrustInformation_Type, *r->out.forest_trust_info, *r->out.forest_trust_info);
	}
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_forest_trust_info);
	}
	if (result_size == 1) {
		result = py_forest_trust_info;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winbind_SendToSam_in_get_message(PyObject *obj, void *closure)
{
	struct winbind_SendToSam *object = pytalloc_get_ptr(obj);
	PyObject *py_message;
	py_message = pytalloc_reference_ex(netr_SendToSamBase_Type, pytalloc_get_mem_ctx(obj), &object->in.message);
	return py_message;
}

static int py_winbind_SendToSam_in_set_message(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winbind_SendToSam *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.message");
		return -1;
	}
	PY_CHECK_TYPE(netr_SendToSamBase_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.message = *(struct netr_SendToSamBase *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winbind_SendToSam_get_result(PyObject *obj, void *closure)
{
	struct winbind_SendToSam *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_winbind_SendToSam_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winbind_SendToSam *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winbind_SendToSam_getsetters[] = {
	{
		.name = discard_const_p(char, "in_message"),
		.get = py_winbind_SendToSam_in_get_message,
		.set = py_winbind_SendToSam_in_set_message,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_SendToSamBase")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winbind_SendToSam_get_result,
		.set = py_winbind_SendToSam_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_winbind_SendToSam_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winbind_SendToSam, type);
	return self;
}

static PyObject *py_winbind_SendToSam_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(34);
}

static PyObject *py_winbind_SendToSam_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winbind_SendToSam *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 35) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winbind_SendToSam_ndr_pack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[34];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winbind_SendToSam_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winbind_SendToSam_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winbind_SendToSam_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winbind_SendToSam_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winbind_SendToSam_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winbind_SendToSam *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_winbind.num_calls < 35) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winbind_SendToSam_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_winbind.calls[34];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winbind_SendToSam_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winbind_SendToSam_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winbind_SendToSam_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winbind_SendToSam_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winbind_SendToSam_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winbind_SendToSam *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_winbind.num_calls < 35) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winbind_SendToSam_ndr_print");
		return NULL;
	}
	call = &ndr_table_winbind.calls[34];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winbind_SendToSam_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winbind_SendToSam_ndr_print(py_obj, args, kwargs, "winbind_SendToSam_in", NDR_IN);
}

static PyObject *py_winbind_SendToSam_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winbind_SendToSam_ndr_print(py_obj, args, kwargs, "winbind_SendToSam_out", NDR_OUT);
}

static PyMethodDef py_winbind_SendToSam_methods[] = {
	{ "opnum", (PyCFunction)py_winbind_SendToSam_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winbind.SendToSam.opnum() -> 34 (0x22) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winbind_SendToSam_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winbind_SendToSam_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winbind_SendToSam_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winbind_SendToSam_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winbind_SendToSam_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winbind_SendToSam_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winbind_SendToSam_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.SendToSam",
	.tp_getset = py_winbind_SendToSam_getsetters,
	.tp_methods = py_winbind_SendToSam_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winbind_SendToSam_new,
};

static bool pack_py_winbind_SendToSam_args_in(PyObject *args, PyObject *kwargs, struct winbind_SendToSam *r)
{
	PyObject *py_message;
	const char *kwnames[] = {
		"message", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:winbind_SendToSam", discard_const_p(char *, kwnames), &py_message)) {
		return false;
	}

	if (py_message == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.message");
		return false;
	}
	PY_CHECK_TYPE(netr_SendToSamBase_Type, py_message, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_message)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.message = *(struct netr_SendToSamBase *)pytalloc_get_ptr(py_message);
	return true;
}

static PyObject *unpack_py_winbind_SendToSam_args_out(struct winbind_SendToSam *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromNTSTATUS(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_winbind_methods[] = {
	{
		.name = "wbint_Ping",
		.doc = "S.wbint_Ping(in_data) -> out_data",
		.call = (py_dcerpc_call_fn)dcerpc_wbint_Ping_r,
		.pack_in_data = (py_data_pack_fn)pack_py_wbint_Ping_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_wbint_Ping_args_out,
		.opnum = 0,
		.table = &ndr_table_winbind,
	},
	{
		.name = "wbint_LookupSid",
		.doc = "S.wbint_LookupSid(sid) -> (type, domain, name)",
		.call = (py_dcerpc_call_fn)dcerpc_wbint_LookupSid_r,
		.pack_in_data = (py_data_pack_fn)pack_py_wbint_LookupSid_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_wbint_LookupSid_args_out,
		.opnum = 1,
		.table = &ndr_table_winbind,
	},
	{
		.name = "wbint_LookupSids",
		.doc = "S.wbint_LookupSids(sids) -> (domains, names)",
		.call = (py_dcerpc_call_fn)dcerpc_wbint_LookupSids_r,
		.pack_in_data = (py_data_pack_fn)pack_py_wbint_LookupSids_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_wbint_LookupSids_args_out,
		.opnum = 2,
		.table = &ndr_table_winbind,
	},
	{
		.name = "wbint_LookupName",
		.doc = "S.wbint_LookupName(domain, name, flags) -> (type, sid)",
		.call = (py_dcerpc_call_fn)dcerpc_wbint_LookupName_r,
		.pack_in_data = (py_data_pack_fn)pack_py_wbint_LookupName_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_wbint_LookupName_args_out,
		.opnum = 3,
		.table = &ndr_table_winbind,
	},
	{
		.name = "wbint_Sids2UnixIDs",
		.doc = "S.wbint_Sids2UnixIDs(domains, ids) -> ids",
		.call = (py_dcerpc_call_fn)dcerpc_wbint_Sids2UnixIDs_r,
		.pack_in_data = (py_data_pack_fn)pack_py_wbint_Sids2UnixIDs_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_wbint_Sids2UnixIDs_args_out,
		.opnum = 4,
		.table = &ndr_table_winbind,
	},
	{
		.name = "wbint_UnixIDs2Sids",
		.doc = "S.wbint_UnixIDs2Sids(domain_name, domain_sid, num_ids, xids) -> (xids, sids)",
		.call = (py_dcerpc_call_fn)dcerpc_wbint_UnixIDs2Sids_r,
		.pack_in_data = (py_data_pack_fn)pack_py_wbint_UnixIDs2Sids_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_wbint_UnixIDs2Sids_args_out,
		.opnum = 5,
		.table = &ndr_table_winbind,
	},
	{
		.name = "wbint_AllocateUid",
		.doc = "S.wbint_AllocateUid() -> uid",
		.call = (py_dcerpc_call_fn)dcerpc_wbint_AllocateUid_r,
		.pack_in_data = (py_data_pack_fn)pack_py_wbint_AllocateUid_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_wbint_AllocateUid_args_out,
		.opnum = 6,
		.table = &ndr_table_winbind,
	},
	{
		.name = "wbint_AllocateGid",
		.doc = "S.wbint_AllocateGid() -> gid",
		.call = (py_dcerpc_call_fn)dcerpc_wbint_AllocateGid_r,
		.pack_in_data = (py_data_pack_fn)pack_py_wbint_AllocateGid_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_wbint_AllocateGid_args_out,
		.opnum = 7,
		.table = &ndr_table_winbind,
	},
	{
		.name = "wbint_GetNssInfo",
		.doc = "S.wbint_GetNssInfo(info) -> info",
		.call = (py_dcerpc_call_fn)dcerpc_wbint_GetNssInfo_r,
		.pack_in_data = (py_data_pack_fn)pack_py_wbint_GetNssInfo_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_wbint_GetNssInfo_args_out,
		.opnum = 8,
		.table = &ndr_table_winbind,
	},
	{
		.name = "wbint_LookupUserAliases",
		.doc = "S.wbint_LookupUserAliases(sids) -> rids",
		.call = (py_dcerpc_call_fn)dcerpc_wbint_LookupUserAliases_r,
		.pack_in_data = (py_data_pack_fn)pack_py_wbint_LookupUserAliases_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_wbint_LookupUserAliases_args_out,
		.opnum = 9,
		.table = &ndr_table_winbind,
	},
	{
		.name = "wbint_LookupUserGroups",
		.doc = "S.wbint_LookupUserGroups(sid) -> sids",
		.call = (py_dcerpc_call_fn)dcerpc_wbint_LookupUserGroups_r,
		.pack_in_data = (py_data_pack_fn)pack_py_wbint_LookupUserGroups_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_wbint_LookupUserGroups_args_out,
		.opnum = 10,
		.table = &ndr_table_winbind,
	},
	{
		.name = "wbint_QuerySequenceNumber",
		.doc = "S.wbint_QuerySequenceNumber() -> sequence",
		.call = (py_dcerpc_call_fn)dcerpc_wbint_QuerySequenceNumber_r,
		.pack_in_data = (py_data_pack_fn)pack_py_wbint_QuerySequenceNumber_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_wbint_QuerySequenceNumber_args_out,
		.opnum = 11,
		.table = &ndr_table_winbind,
	},
	{
		.name = "wbint_LookupGroupMembers",
		.doc = "S.wbint_LookupGroupMembers(sid, type) -> members",
		.call = (py_dcerpc_call_fn)dcerpc_wbint_LookupGroupMembers_r,
		.pack_in_data = (py_data_pack_fn)pack_py_wbint_LookupGroupMembers_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_wbint_LookupGroupMembers_args_out,
		.opnum = 12,
		.table = &ndr_table_winbind,
	},
	{
		.name = "wbint_LookupAliasMembers",
		.doc = "S.wbint_LookupAliasMembers(sid, type) -> sids",
		.call = (py_dcerpc_call_fn)dcerpc_wbint_LookupAliasMembers_r,
		.pack_in_data = (py_data_pack_fn)pack_py_wbint_LookupAliasMembers_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_wbint_LookupAliasMembers_args_out,
		.opnum = 13,
		.table = &ndr_table_winbind,
	},
	{
		.name = "wbint_QueryGroupList",
		.doc = "S.wbint_QueryGroupList() -> groups",
		.call = (py_dcerpc_call_fn)dcerpc_wbint_QueryGroupList_r,
		.pack_in_data = (py_data_pack_fn)pack_py_wbint_QueryGroupList_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_wbint_QueryGroupList_args_out,
		.opnum = 14,
		.table = &ndr_table_winbind,
	},
	{
		.name = "wbint_QueryUserRidList",
		.doc = "S.wbint_QueryUserRidList() -> rids",
		.call = (py_dcerpc_call_fn)dcerpc_wbint_QueryUserRidList_r,
		.pack_in_data = (py_data_pack_fn)pack_py_wbint_QueryUserRidList_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_wbint_QueryUserRidList_args_out,
		.opnum = 15,
		.table = &ndr_table_winbind,
	},
	{
		.name = "wbint_DsGetDcName",
		.doc = "S.wbint_DsGetDcName(domain_name, domain_guid, site_name, flags) -> dc_info",
		.call = (py_dcerpc_call_fn)dcerpc_wbint_DsGetDcName_r,
		.pack_in_data = (py_data_pack_fn)pack_py_wbint_DsGetDcName_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_wbint_DsGetDcName_args_out,
		.opnum = 16,
		.table = &ndr_table_winbind,
	},
	{
		.name = "wbint_LookupRids",
		.doc = "S.wbint_LookupRids(domain_sid, rids) -> (domain_name, names)",
		.call = (py_dcerpc_call_fn)dcerpc_wbint_LookupRids_r,
		.pack_in_data = (py_data_pack_fn)pack_py_wbint_LookupRids_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_wbint_LookupRids_args_out,
		.opnum = 17,
		.table = &ndr_table_winbind,
	},
	{
		.name = "wbint_CheckMachineAccount",
		.doc = "S.wbint_CheckMachineAccount() -> None",
		.call = (py_dcerpc_call_fn)dcerpc_wbint_CheckMachineAccount_r,
		.pack_in_data = (py_data_pack_fn)pack_py_wbint_CheckMachineAccount_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_wbint_CheckMachineAccount_args_out,
		.opnum = 18,
		.table = &ndr_table_winbind,
	},
	{
		.name = "wbint_ChangeMachineAccount",
		.doc = "S.wbint_ChangeMachineAccount(dcname) -> None",
		.call = (py_dcerpc_call_fn)dcerpc_wbint_ChangeMachineAccount_r,
		.pack_in_data = (py_data_pack_fn)pack_py_wbint_ChangeMachineAccount_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_wbint_ChangeMachineAccount_args_out,
		.opnum = 19,
		.table = &ndr_table_winbind,
	},
	{
		.name = "wbint_PingDc",
		.doc = "S.wbint_PingDc() -> dcname",
		.call = (py_dcerpc_call_fn)dcerpc_wbint_PingDc_r,
		.pack_in_data = (py_data_pack_fn)pack_py_wbint_PingDc_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_wbint_PingDc_args_out,
		.opnum = 20,
		.table = &ndr_table_winbind,
	},
	{
		.name = "wbint_ListTrustedDomains",
		.doc = "S.wbint_ListTrustedDomains(client_name, client_pid) -> domains",
		.call = (py_dcerpc_call_fn)dcerpc_wbint_ListTrustedDomains_r,
		.pack_in_data = (py_data_pack_fn)pack_py_wbint_ListTrustedDomains_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_wbint_ListTrustedDomains_args_out,
		.opnum = 21,
		.table = &ndr_table_winbind,
	},
	{
		.name = "wbint_PamAuth",
		.doc = "S.wbint_PamAuth(client_name, client_pid, flags, info, require_membership_of_sid) -> validation",
		.call = (py_dcerpc_call_fn)dcerpc_wbint_PamAuth_r,
		.pack_in_data = (py_data_pack_fn)pack_py_wbint_PamAuth_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_wbint_PamAuth_args_out,
		.opnum = 22,
		.table = &ndr_table_winbind,
	},
	{
		.name = "wbint_PamAuthCrap",
		.doc = "S.wbint_PamAuthCrap(client_name, client_pid, flags, user, domain, workstation, lm_resp, nt_resp, chal, logon_parameters, require_membership_of_sid) -> (authoritative, validation)",
		.call = (py_dcerpc_call_fn)dcerpc_wbint_PamAuthCrap_r,
		.pack_in_data = (py_data_pack_fn)pack_py_wbint_PamAuthCrap_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_wbint_PamAuthCrap_args_out,
		.opnum = 23,
		.table = &ndr_table_winbind,
	},
	{
		.name = "wbint_PamLogOff",
		.doc = "S.wbint_PamLogOff(client_name, client_pid, flags, user, krb5ccname, uid) -> None",
		.call = (py_dcerpc_call_fn)dcerpc_wbint_PamLogOff_r,
		.pack_in_data = (py_data_pack_fn)pack_py_wbint_PamLogOff_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_wbint_PamLogOff_args_out,
		.opnum = 24,
		.table = &ndr_table_winbind,
	},
	{
		.name = "wbint_PamAuthCrapChangePassword",
		.doc = "S.wbint_PamAuthCrapChangePassword(client_name, client_pid, user, domain, new_nt_pswd, old_nt_hash_enc, new_lm_pswd, old_lm_hash_enc) -> None",
		.call = (py_dcerpc_call_fn)dcerpc_wbint_PamAuthCrapChangePassword_r,
		.pack_in_data = (py_data_pack_fn)pack_py_wbint_PamAuthCrapChangePassword_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_wbint_PamAuthCrapChangePassword_args_out,
		.opnum = 25,
		.table = &ndr_table_winbind,
	},
	{
		.name = "wbint_PamAuthChangePassword",
		.doc = "S.wbint_PamAuthChangePassword(client_name, client_pid, flags, user, old_password, new_password) -> (dominfo, reject_reason)",
		.call = (py_dcerpc_call_fn)dcerpc_wbint_PamAuthChangePassword_r,
		.pack_in_data = (py_data_pack_fn)pack_py_wbint_PamAuthChangePassword_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_wbint_PamAuthChangePassword_args_out,
		.opnum = 26,
		.table = &ndr_table_winbind,
	},
	{
		.name = "wbint_InitConnection",
		.doc = "S.wbint_InitConnection(dcname) -> (name, alt_name, sid, flags)",
		.call = (py_dcerpc_call_fn)dcerpc_wbint_InitConnection_r,
		.pack_in_data = (py_data_pack_fn)pack_py_wbint_InitConnection_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_wbint_InitConnection_args_out,
		.opnum = 27,
		.table = &ndr_table_winbind,
	},
	{
		.name = "wbint_NormalizeNameMap",
		.doc = "S.wbint_NormalizeNameMap(domain_name, name) -> mapped_name",
		.call = (py_dcerpc_call_fn)dcerpc_wbint_NormalizeNameMap_r,
		.pack_in_data = (py_data_pack_fn)pack_py_wbint_NormalizeNameMap_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_wbint_NormalizeNameMap_args_out,
		.opnum = 28,
		.table = &ndr_table_winbind,
	},
	{
		.name = "wbint_NormalizeNameUnmap",
		.doc = "S.wbint_NormalizeNameUnmap(name) -> unmapped_name",
		.call = (py_dcerpc_call_fn)dcerpc_wbint_NormalizeNameUnmap_r,
		.pack_in_data = (py_data_pack_fn)pack_py_wbint_NormalizeNameUnmap_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_wbint_NormalizeNameUnmap_args_out,
		.opnum = 29,
		.table = &ndr_table_winbind,
	},
	{
		.name = "SamLogon",
		.doc = "S.SamLogon(internal_flags, logon_level, logon, validation_level) -> (validation, authoritative)",
		.call = (py_dcerpc_call_fn)dcerpc_winbind_SamLogon_r,
		.pack_in_data = (py_data_pack_fn)pack_py_winbind_SamLogon_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_winbind_SamLogon_args_out,
		.opnum = 30,
		.table = &ndr_table_winbind,
	},
	{
		.name = "DsrUpdateReadOnlyServerDnsRecords",
		.doc = "S.DsrUpdateReadOnlyServerDnsRecords(site_name, dns_ttl, dns_names) -> dns_names",
		.call = (py_dcerpc_call_fn)dcerpc_winbind_DsrUpdateReadOnlyServerDnsRecords_r,
		.pack_in_data = (py_data_pack_fn)pack_py_winbind_DsrUpdateReadOnlyServerDnsRecords_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_winbind_DsrUpdateReadOnlyServerDnsRecords_args_out,
		.opnum = 31,
		.table = &ndr_table_winbind,
	},
	{
		.name = "LogonControl",
		.doc = "S.LogonControl(function_code, level, data) -> query",
		.call = (py_dcerpc_call_fn)dcerpc_winbind_LogonControl_r,
		.pack_in_data = (py_data_pack_fn)pack_py_winbind_LogonControl_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_winbind_LogonControl_args_out,
		.opnum = 32,
		.table = &ndr_table_winbind,
	},
	{
		.name = "GetForestTrustInformation",
		.doc = "S.GetForestTrustInformation(trusted_domain_name, flags) -> forest_trust_info",
		.call = (py_dcerpc_call_fn)dcerpc_winbind_GetForestTrustInformation_r,
		.pack_in_data = (py_data_pack_fn)pack_py_winbind_GetForestTrustInformation_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_winbind_GetForestTrustInformation_args_out,
		.opnum = 33,
		.table = &ndr_table_winbind,
	},
	{
		.name = "SendToSam",
		.doc = "S.SendToSam(message) -> None",
		.call = (py_dcerpc_call_fn)dcerpc_winbind_SendToSam_r,
		.pack_in_data = (py_data_pack_fn)pack_py_winbind_SendToSam_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_winbind_SendToSam_args_out,
		.opnum = 34,
		.table = &ndr_table_winbind,
	},
	{
		.name = NULL,
	},
};

static PyObject *interface_winbind_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_winbind);
}

#define PY_DOC_WINBIND "winbind parent-child protocol"
static PyTypeObject winbind_InterfaceType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.winbind",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "winbind(binding, lp_ctx=None, credentials=None, basis_connection=None) -> connection\n"
"\n\n"
"Parameters\n"
"----------\n"
"binding : str\n"
"    A DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx : param.LoadParm\n"
"    Should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials : credentials.Credentials, optional\n"
"    A credentials.Credentials object (default is None).\n"
"basis_connection : samba.dcerpc.ClientConnection, optional\n"
"    A winbind client connection object (default is None).\n"
"\n\n"
"Returns\n"
"-------\n"
"samba.dcerpc.ClientConnection\n"
"    A ClientConnection object\n"
"\n\n"
"Raises\n"
"------\n"
"samba.NTSTATUSError\n"
"    An NTSTATUS error\n"
"\n"PY_DOC_WINBIND,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_winbind_new,
};

static PyObject *syntax_winbind_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_syntax_init_helper(type, args, kwargs, &ndr_table_winbind.syntax_id);
}

#define PY_DOC_WINBIND_SYNTAX "winbind parent-child protocol"
static PyTypeObject winbind_SyntaxType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winbind.winbind_abstract_syntax",
	.tp_doc = "winbind_abstract_syntax()\n"PY_DOC_WINBIND_SYNTAX,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = syntax_winbind_new,
};

static PyMethodDef winbind_methods[] = {
	{ NULL, NULL, 0, NULL }
};

static struct PyModuleDef moduledef = {
	PyModuleDef_HEAD_INIT,
	.m_name = "winbind",
	.m_doc = "winbind DCE/RPC",
	.m_size = -1,
	.m_methods = winbind_methods,
};
MODULE_INIT_FUNC(winbind)
{
	PyObject *m = NULL;
	PyObject *dep_samba_dcerpc_lsa = NULL;
	PyObject *dep_samba_dcerpc_netlogon = NULL;
	PyObject *dep_samba_dcerpc_samr = NULL;
	PyObject *dep_samba_dcerpc_misc = NULL;
	PyObject *dep_samba_dcerpc_security = NULL;
	PyObject *dep_samba_dcerpc_idmap = NULL;
	PyObject *dep_talloc = NULL;
	PyObject *dep_samba_dcerpc_base = NULL;

	dep_samba_dcerpc_lsa = PyImport_ImportModule("samba.dcerpc.lsa");
	if (dep_samba_dcerpc_lsa == NULL)
		goto out;

	dep_samba_dcerpc_netlogon = PyImport_ImportModule("samba.dcerpc.netlogon");
	if (dep_samba_dcerpc_netlogon == NULL)
		goto out;

	dep_samba_dcerpc_samr = PyImport_ImportModule("samba.dcerpc.samr");
	if (dep_samba_dcerpc_samr == NULL)
		goto out;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		goto out;

	dep_samba_dcerpc_security = PyImport_ImportModule("samba.dcerpc.security");
	if (dep_samba_dcerpc_security == NULL)
		goto out;

	dep_samba_dcerpc_idmap = PyImport_ImportModule("samba.dcerpc.idmap");
	if (dep_samba_dcerpc_idmap == NULL)
		goto out;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		goto out;

	dep_samba_dcerpc_base = PyImport_ImportModule("samba.dcerpc.base");
	if (dep_samba_dcerpc_base == NULL)
		goto out;

	unixid_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_idmap, "unixid");
	if (unixid_Type == NULL)
		goto out;

	BaseObject_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "BaseObject");
	if (BaseObject_Type == NULL)
		goto out;

	dom_sid_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_security, "dom_sid");
	if (dom_sid_Type == NULL)
		goto out;

	netr_Validation_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_netlogon, "netr_Validation");
	if (netr_Validation_Type == NULL)
		goto out;

	lsa_SidArray_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_lsa, "SidArray");
	if (lsa_SidArray_Type == NULL)
		goto out;

	lsa_RefDomainList_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_lsa, "RefDomainList");
	if (lsa_RefDomainList_Type == NULL)
		goto out;

	lsa_TransNameArray_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_lsa, "TransNameArray");
	if (lsa_TransNameArray_Type == NULL)
		goto out;

	GUID_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "GUID");
	if (GUID_Type == NULL)
		goto out;

	netr_DsRGetDCNameInfo_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_netlogon, "netr_DsRGetDCNameInfo");
	if (netr_DsRGetDCNameInfo_Type == NULL)
		goto out;

	netr_DomainTrustList_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_netlogon, "netr_DomainTrustList");
	if (netr_DomainTrustList_Type == NULL)
		goto out;

	samr_DomInfo1_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_samr, "DomInfo1");
	if (samr_DomInfo1_Type == NULL)
		goto out;

	netr_LogonLevel_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_netlogon, "netr_LogonLevel");
	if (netr_LogonLevel_Type == NULL)
		goto out;

	NL_DNS_NAME_INFO_ARRAY_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_netlogon, "NL_DNS_NAME_INFO_ARRAY");
	if (NL_DNS_NAME_INFO_ARRAY_Type == NULL)
		goto out;

	netr_CONTROL_DATA_INFORMATION_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_netlogon, "netr_CONTROL_DATA_INFORMATION");
	if (netr_CONTROL_DATA_INFORMATION_Type == NULL)
		goto out;

	netr_CONTROL_QUERY_INFORMATION_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_netlogon, "netr_CONTROL_QUERY_INFORMATION");
	if (netr_CONTROL_QUERY_INFORMATION_Type == NULL)
		goto out;

	lsa_ForestTrustInformation_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_lsa, "ForestTrustInformation");
	if (lsa_ForestTrustInformation_Type == NULL)
		goto out;

	netr_SendToSamBase_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_netlogon, "netr_SendToSamBase");
	if (netr_SendToSamBase_Type == NULL)
		goto out;

	ClientConnection_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_base, "ClientConnection");
	if (ClientConnection_Type == NULL)
		goto out;

	ndr_syntax_id_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "ndr_syntax_id");
	if (ndr_syntax_id_Type == NULL)
		goto out;

	wbint_TransID_Type.tp_base = BaseObject_Type;
	wbint_TransID_Type.tp_basicsize = pytalloc_BaseObject_size();

	wbint_TransIDArray_Type.tp_base = BaseObject_Type;
	wbint_TransIDArray_Type.tp_basicsize = pytalloc_BaseObject_size();

	wbint_userinfo_Type.tp_base = BaseObject_Type;
	wbint_userinfo_Type.tp_basicsize = pytalloc_BaseObject_size();

	wbint_SidArray_Type.tp_base = BaseObject_Type;
	wbint_SidArray_Type.tp_basicsize = pytalloc_BaseObject_size();

	wbint_RidArray_Type.tp_base = BaseObject_Type;
	wbint_RidArray_Type.tp_basicsize = pytalloc_BaseObject_size();

	wbint_Principal_Type.tp_base = BaseObject_Type;
	wbint_Principal_Type.tp_basicsize = pytalloc_BaseObject_size();

	wbint_Principals_Type.tp_base = BaseObject_Type;
	wbint_Principals_Type.tp_basicsize = pytalloc_BaseObject_size();

	wbint_userinfos_Type.tp_base = BaseObject_Type;
	wbint_userinfos_Type.tp_basicsize = pytalloc_BaseObject_size();

	wbint_Validation_Type.tp_base = BaseObject_Type;
	wbint_Validation_Type.tp_basicsize = pytalloc_BaseObject_size();

	wbint_AuthUserInfo_Type.tp_base = BaseObject_Type;
	wbint_AuthUserInfo_Type.tp_basicsize = pytalloc_BaseObject_size();

	wbint_PamAuthCrapValidation_Type.tp_base = BaseObject_Type;
	wbint_PamAuthCrapValidation_Type.tp_basicsize = pytalloc_BaseObject_size();

	wbint_Ping_Type.tp_base = BaseObject_Type;
	wbint_Ping_Type.tp_basicsize = pytalloc_BaseObject_size();

	wbint_LookupSid_Type.tp_base = BaseObject_Type;
	wbint_LookupSid_Type.tp_basicsize = pytalloc_BaseObject_size();

	wbint_LookupSids_Type.tp_base = BaseObject_Type;
	wbint_LookupSids_Type.tp_basicsize = pytalloc_BaseObject_size();

	wbint_LookupName_Type.tp_base = BaseObject_Type;
	wbint_LookupName_Type.tp_basicsize = pytalloc_BaseObject_size();

	wbint_Sids2UnixIDs_Type.tp_base = BaseObject_Type;
	wbint_Sids2UnixIDs_Type.tp_basicsize = pytalloc_BaseObject_size();

	wbint_UnixIDs2Sids_Type.tp_base = BaseObject_Type;
	wbint_UnixIDs2Sids_Type.tp_basicsize = pytalloc_BaseObject_size();

	wbint_AllocateUid_Type.tp_base = BaseObject_Type;
	wbint_AllocateUid_Type.tp_basicsize = pytalloc_BaseObject_size();

	wbint_AllocateGid_Type.tp_base = BaseObject_Type;
	wbint_AllocateGid_Type.tp_basicsize = pytalloc_BaseObject_size();

	wbint_GetNssInfo_Type.tp_base = BaseObject_Type;
	wbint_GetNssInfo_Type.tp_basicsize = pytalloc_BaseObject_size();

	wbint_LookupUserAliases_Type.tp_base = BaseObject_Type;
	wbint_LookupUserAliases_Type.tp_basicsize = pytalloc_BaseObject_size();

	wbint_LookupUserGroups_Type.tp_base = BaseObject_Type;
	wbint_LookupUserGroups_Type.tp_basicsize = pytalloc_BaseObject_size();

	wbint_QuerySequenceNumber_Type.tp_base = BaseObject_Type;
	wbint_QuerySequenceNumber_Type.tp_basicsize = pytalloc_BaseObject_size();

	wbint_LookupGroupMembers_Type.tp_base = BaseObject_Type;
	wbint_LookupGroupMembers_Type.tp_basicsize = pytalloc_BaseObject_size();

	wbint_LookupAliasMembers_Type.tp_base = BaseObject_Type;
	wbint_LookupAliasMembers_Type.tp_basicsize = pytalloc_BaseObject_size();

	wbint_QueryGroupList_Type.tp_base = BaseObject_Type;
	wbint_QueryGroupList_Type.tp_basicsize = pytalloc_BaseObject_size();

	wbint_QueryUserRidList_Type.tp_base = BaseObject_Type;
	wbint_QueryUserRidList_Type.tp_basicsize = pytalloc_BaseObject_size();

	wbint_DsGetDcName_Type.tp_base = BaseObject_Type;
	wbint_DsGetDcName_Type.tp_basicsize = pytalloc_BaseObject_size();

	wbint_LookupRids_Type.tp_base = BaseObject_Type;
	wbint_LookupRids_Type.tp_basicsize = pytalloc_BaseObject_size();

	wbint_CheckMachineAccount_Type.tp_base = BaseObject_Type;
	wbint_CheckMachineAccount_Type.tp_basicsize = pytalloc_BaseObject_size();

	wbint_ChangeMachineAccount_Type.tp_base = BaseObject_Type;
	wbint_ChangeMachineAccount_Type.tp_basicsize = pytalloc_BaseObject_size();

	wbint_PingDc_Type.tp_base = BaseObject_Type;
	wbint_PingDc_Type.tp_basicsize = pytalloc_BaseObject_size();

	wbint_ListTrustedDomains_Type.tp_base = BaseObject_Type;
	wbint_ListTrustedDomains_Type.tp_basicsize = pytalloc_BaseObject_size();

	wbint_PamAuth_Type.tp_base = BaseObject_Type;
	wbint_PamAuth_Type.tp_basicsize = pytalloc_BaseObject_size();

	wbint_PamAuthCrap_Type.tp_base = BaseObject_Type;
	wbint_PamAuthCrap_Type.tp_basicsize = pytalloc_BaseObject_size();

	wbint_PamLogOff_Type.tp_base = BaseObject_Type;
	wbint_PamLogOff_Type.tp_basicsize = pytalloc_BaseObject_size();

	wbint_PamAuthCrapChangePassword_Type.tp_base = BaseObject_Type;
	wbint_PamAuthCrapChangePassword_Type.tp_basicsize = pytalloc_BaseObject_size();

	wbint_PamAuthChangePassword_Type.tp_base = BaseObject_Type;
	wbint_PamAuthChangePassword_Type.tp_basicsize = pytalloc_BaseObject_size();

	wbint_InitConnection_Type.tp_base = BaseObject_Type;
	wbint_InitConnection_Type.tp_basicsize = pytalloc_BaseObject_size();

	wbint_NormalizeNameMap_Type.tp_base = BaseObject_Type;
	wbint_NormalizeNameMap_Type.tp_basicsize = pytalloc_BaseObject_size();

	wbint_NormalizeNameUnmap_Type.tp_base = BaseObject_Type;
	wbint_NormalizeNameUnmap_Type.tp_basicsize = pytalloc_BaseObject_size();

	winbind_SamLogon_Type.tp_base = BaseObject_Type;
	winbind_SamLogon_Type.tp_basicsize = pytalloc_BaseObject_size();

	winbind_DsrUpdateReadOnlyServerDnsRecords_Type.tp_base = BaseObject_Type;
	winbind_DsrUpdateReadOnlyServerDnsRecords_Type.tp_basicsize = pytalloc_BaseObject_size();

	winbind_LogonControl_Type.tp_base = BaseObject_Type;
	winbind_LogonControl_Type.tp_basicsize = pytalloc_BaseObject_size();

	winbind_GetForestTrustInformation_Type.tp_base = BaseObject_Type;
	winbind_GetForestTrustInformation_Type.tp_basicsize = pytalloc_BaseObject_size();

	winbind_SendToSam_Type.tp_base = BaseObject_Type;
	winbind_SendToSam_Type.tp_basicsize = pytalloc_BaseObject_size();

	winbind_InterfaceType.tp_base = ClientConnection_Type;

	winbind_SyntaxType.tp_base = ndr_syntax_id_Type;
	winbind_SyntaxType.tp_basicsize = pytalloc_BaseObject_size();

	if (PyType_Ready(&wbint_TransID_Type) < 0)
		goto out;
	if (PyType_Ready(&wbint_TransIDArray_Type) < 0)
		goto out;
	if (PyType_Ready(&wbint_userinfo_Type) < 0)
		goto out;
	if (PyType_Ready(&wbint_SidArray_Type) < 0)
		goto out;
	if (PyType_Ready(&wbint_RidArray_Type) < 0)
		goto out;
	if (PyType_Ready(&wbint_Principal_Type) < 0)
		goto out;
	if (PyType_Ready(&wbint_Principals_Type) < 0)
		goto out;
	if (PyType_Ready(&wbint_userinfos_Type) < 0)
		goto out;
	if (PyType_Ready(&wbint_Validation_Type) < 0)
		goto out;
	if (PyType_Ready(&wbint_AuthUserInfo_Type) < 0)
		goto out;
	if (PyType_Ready(&wbint_PamAuthCrapValidation_Type) < 0)
		goto out;
	if (PyType_Ready(&wbint_Ping_Type) < 0)
		goto out;
	if (PyType_Ready(&wbint_LookupSid_Type) < 0)
		goto out;
	if (PyType_Ready(&wbint_LookupSids_Type) < 0)
		goto out;
	if (PyType_Ready(&wbint_LookupName_Type) < 0)
		goto out;
	if (PyType_Ready(&wbint_Sids2UnixIDs_Type) < 0)
		goto out;
	if (PyType_Ready(&wbint_UnixIDs2Sids_Type) < 0)
		goto out;
	if (PyType_Ready(&wbint_AllocateUid_Type) < 0)
		goto out;
	if (PyType_Ready(&wbint_AllocateGid_Type) < 0)
		goto out;
	if (PyType_Ready(&wbint_GetNssInfo_Type) < 0)
		goto out;
	if (PyType_Ready(&wbint_LookupUserAliases_Type) < 0)
		goto out;
	if (PyType_Ready(&wbint_LookupUserGroups_Type) < 0)
		goto out;
	if (PyType_Ready(&wbint_QuerySequenceNumber_Type) < 0)
		goto out;
	if (PyType_Ready(&wbint_LookupGroupMembers_Type) < 0)
		goto out;
	if (PyType_Ready(&wbint_LookupAliasMembers_Type) < 0)
		goto out;
	if (PyType_Ready(&wbint_QueryGroupList_Type) < 0)
		goto out;
	if (PyType_Ready(&wbint_QueryUserRidList_Type) < 0)
		goto out;
	if (PyType_Ready(&wbint_DsGetDcName_Type) < 0)
		goto out;
	if (PyType_Ready(&wbint_LookupRids_Type) < 0)
		goto out;
	if (PyType_Ready(&wbint_CheckMachineAccount_Type) < 0)
		goto out;
	if (PyType_Ready(&wbint_ChangeMachineAccount_Type) < 0)
		goto out;
	if (PyType_Ready(&wbint_PingDc_Type) < 0)
		goto out;
	if (PyType_Ready(&wbint_ListTrustedDomains_Type) < 0)
		goto out;
	if (PyType_Ready(&wbint_PamAuth_Type) < 0)
		goto out;
	if (PyType_Ready(&wbint_PamAuthCrap_Type) < 0)
		goto out;
	if (PyType_Ready(&wbint_PamLogOff_Type) < 0)
		goto out;
	if (PyType_Ready(&wbint_PamAuthCrapChangePassword_Type) < 0)
		goto out;
	if (PyType_Ready(&wbint_PamAuthChangePassword_Type) < 0)
		goto out;
	if (PyType_Ready(&wbint_InitConnection_Type) < 0)
		goto out;
	if (PyType_Ready(&wbint_NormalizeNameMap_Type) < 0)
		goto out;
	if (PyType_Ready(&wbint_NormalizeNameUnmap_Type) < 0)
		goto out;
	if (PyType_Ready(&winbind_SamLogon_Type) < 0)
		goto out;
	if (PyType_Ready(&winbind_DsrUpdateReadOnlyServerDnsRecords_Type) < 0)
		goto out;
	if (PyType_Ready(&winbind_LogonControl_Type) < 0)
		goto out;
	if (PyType_Ready(&winbind_GetForestTrustInformation_Type) < 0)
		goto out;
	if (PyType_Ready(&winbind_SendToSam_Type) < 0)
		goto out;
	if (PyType_Ready(&winbind_InterfaceType) < 0)
		goto out;
	if (PyType_Ready(&winbind_SyntaxType) < 0)
		goto out;
	if (!PyInterface_AddNdrRpcMethods(&winbind_InterfaceType, py_ndr_winbind_methods))
		return NULL;

#ifdef PY_WBINT_TRANSID_PATCH
	PY_WBINT_TRANSID_PATCH(&wbint_TransID_Type);
#endif
#ifdef PY_WBINT_TRANSIDARRAY_PATCH
	PY_WBINT_TRANSIDARRAY_PATCH(&wbint_TransIDArray_Type);
#endif
#ifdef PY_WBINT_USERINFO_PATCH
	PY_WBINT_USERINFO_PATCH(&wbint_userinfo_Type);
#endif
#ifdef PY_WBINT_SIDARRAY_PATCH
	PY_WBINT_SIDARRAY_PATCH(&wbint_SidArray_Type);
#endif
#ifdef PY_WBINT_RIDARRAY_PATCH
	PY_WBINT_RIDARRAY_PATCH(&wbint_RidArray_Type);
#endif
#ifdef PY_WBINT_PRINCIPAL_PATCH
	PY_WBINT_PRINCIPAL_PATCH(&wbint_Principal_Type);
#endif
#ifdef PY_WBINT_PRINCIPALS_PATCH
	PY_WBINT_PRINCIPALS_PATCH(&wbint_Principals_Type);
#endif
#ifdef PY_WBINT_USERINFOS_PATCH
	PY_WBINT_USERINFOS_PATCH(&wbint_userinfos_Type);
#endif
#ifdef PY_WBINT_VALIDATION_PATCH
	PY_WBINT_VALIDATION_PATCH(&wbint_Validation_Type);
#endif
#ifdef PY_WBINT_AUTHUSERINFO_PATCH
	PY_WBINT_AUTHUSERINFO_PATCH(&wbint_AuthUserInfo_Type);
#endif
#ifdef PY_WBINT_PAMAUTHCRAPVALIDATION_PATCH
	PY_WBINT_PAMAUTHCRAPVALIDATION_PATCH(&wbint_PamAuthCrapValidation_Type);
#endif
#ifdef PY_WBINT_PING_PATCH
	PY_WBINT_PING_PATCH(&wbint_Ping_Type);
#endif
#ifdef PY_WBINT_LOOKUPSID_PATCH
	PY_WBINT_LOOKUPSID_PATCH(&wbint_LookupSid_Type);
#endif
#ifdef PY_WBINT_LOOKUPSIDS_PATCH
	PY_WBINT_LOOKUPSIDS_PATCH(&wbint_LookupSids_Type);
#endif
#ifdef PY_WBINT_LOOKUPNAME_PATCH
	PY_WBINT_LOOKUPNAME_PATCH(&wbint_LookupName_Type);
#endif
#ifdef PY_WBINT_SIDS2UNIXIDS_PATCH
	PY_WBINT_SIDS2UNIXIDS_PATCH(&wbint_Sids2UnixIDs_Type);
#endif
#ifdef PY_WBINT_UNIXIDS2SIDS_PATCH
	PY_WBINT_UNIXIDS2SIDS_PATCH(&wbint_UnixIDs2Sids_Type);
#endif
#ifdef PY_WBINT_ALLOCATEUID_PATCH
	PY_WBINT_ALLOCATEUID_PATCH(&wbint_AllocateUid_Type);
#endif
#ifdef PY_WBINT_ALLOCATEGID_PATCH
	PY_WBINT_ALLOCATEGID_PATCH(&wbint_AllocateGid_Type);
#endif
#ifdef PY_WBINT_GETNSSINFO_PATCH
	PY_WBINT_GETNSSINFO_PATCH(&wbint_GetNssInfo_Type);
#endif
#ifdef PY_WBINT_LOOKUPUSERALIASES_PATCH
	PY_WBINT_LOOKUPUSERALIASES_PATCH(&wbint_LookupUserAliases_Type);
#endif
#ifdef PY_WBINT_LOOKUPUSERGROUPS_PATCH
	PY_WBINT_LOOKUPUSERGROUPS_PATCH(&wbint_LookupUserGroups_Type);
#endif
#ifdef PY_WBINT_QUERYSEQUENCENUMBER_PATCH
	PY_WBINT_QUERYSEQUENCENUMBER_PATCH(&wbint_QuerySequenceNumber_Type);
#endif
#ifdef PY_WBINT_LOOKUPGROUPMEMBERS_PATCH
	PY_WBINT_LOOKUPGROUPMEMBERS_PATCH(&wbint_LookupGroupMembers_Type);
#endif
#ifdef PY_WBINT_LOOKUPALIASMEMBERS_PATCH
	PY_WBINT_LOOKUPALIASMEMBERS_PATCH(&wbint_LookupAliasMembers_Type);
#endif
#ifdef PY_WBINT_QUERYGROUPLIST_PATCH
	PY_WBINT_QUERYGROUPLIST_PATCH(&wbint_QueryGroupList_Type);
#endif
#ifdef PY_WBINT_QUERYUSERRIDLIST_PATCH
	PY_WBINT_QUERYUSERRIDLIST_PATCH(&wbint_QueryUserRidList_Type);
#endif
#ifdef PY_WBINT_DSGETDCNAME_PATCH
	PY_WBINT_DSGETDCNAME_PATCH(&wbint_DsGetDcName_Type);
#endif
#ifdef PY_WBINT_LOOKUPRIDS_PATCH
	PY_WBINT_LOOKUPRIDS_PATCH(&wbint_LookupRids_Type);
#endif
#ifdef PY_WBINT_CHECKMACHINEACCOUNT_PATCH
	PY_WBINT_CHECKMACHINEACCOUNT_PATCH(&wbint_CheckMachineAccount_Type);
#endif
#ifdef PY_WBINT_CHANGEMACHINEACCOUNT_PATCH
	PY_WBINT_CHANGEMACHINEACCOUNT_PATCH(&wbint_ChangeMachineAccount_Type);
#endif
#ifdef PY_WBINT_PINGDC_PATCH
	PY_WBINT_PINGDC_PATCH(&wbint_PingDc_Type);
#endif
#ifdef PY_WBINT_LISTTRUSTEDDOMAINS_PATCH
	PY_WBINT_LISTTRUSTEDDOMAINS_PATCH(&wbint_ListTrustedDomains_Type);
#endif
#ifdef PY_WBINT_PAMAUTH_PATCH
	PY_WBINT_PAMAUTH_PATCH(&wbint_PamAuth_Type);
#endif
#ifdef PY_WBINT_PAMAUTHCRAP_PATCH
	PY_WBINT_PAMAUTHCRAP_PATCH(&wbint_PamAuthCrap_Type);
#endif
#ifdef PY_WBINT_PAMLOGOFF_PATCH
	PY_WBINT_PAMLOGOFF_PATCH(&wbint_PamLogOff_Type);
#endif
#ifdef PY_WBINT_PAMAUTHCRAPCHANGEPASSWORD_PATCH
	PY_WBINT_PAMAUTHCRAPCHANGEPASSWORD_PATCH(&wbint_PamAuthCrapChangePassword_Type);
#endif
#ifdef PY_WBINT_PAMAUTHCHANGEPASSWORD_PATCH
	PY_WBINT_PAMAUTHCHANGEPASSWORD_PATCH(&wbint_PamAuthChangePassword_Type);
#endif
#ifdef PY_WBINT_INITCONNECTION_PATCH
	PY_WBINT_INITCONNECTION_PATCH(&wbint_InitConnection_Type);
#endif
#ifdef PY_WBINT_NORMALIZENAMEMAP_PATCH
	PY_WBINT_NORMALIZENAMEMAP_PATCH(&wbint_NormalizeNameMap_Type);
#endif
#ifdef PY_WBINT_NORMALIZENAMEUNMAP_PATCH
	PY_WBINT_NORMALIZENAMEUNMAP_PATCH(&wbint_NormalizeNameUnmap_Type);
#endif
#ifdef PY_SAMLOGON_PATCH
	PY_SAMLOGON_PATCH(&winbind_SamLogon_Type);
#endif
#ifdef PY_DSRUPDATEREADONLYSERVERDNSRECORDS_PATCH
	PY_DSRUPDATEREADONLYSERVERDNSRECORDS_PATCH(&winbind_DsrUpdateReadOnlyServerDnsRecords_Type);
#endif
#ifdef PY_LOGONCONTROL_PATCH
	PY_LOGONCONTROL_PATCH(&winbind_LogonControl_Type);
#endif
#ifdef PY_GETFORESTTRUSTINFORMATION_PATCH
	PY_GETFORESTTRUSTINFORMATION_PATCH(&winbind_GetForestTrustInformation_Type);
#endif
#ifdef PY_SENDTOSAM_PATCH
	PY_SENDTOSAM_PATCH(&winbind_SendToSam_Type);
#endif
#ifdef PY_WINBIND_PATCH
	PY_WINBIND_PATCH(&winbind_InterfaceType);
#endif
#ifdef PY_WINBIND_ABSTRACT_SYNTAX_PATCH
	PY_WINBIND_ABSTRACT_SYNTAX_PATCH(&winbind_SyntaxType);
#endif
#ifdef PY_ABSTRACT_SYNTAX_PATCH
	PY_ABSTRACT_SYNTAX_PATCH(&winbind_SyntaxType);
#endif

	m = PyModule_Create(&moduledef);
	if (m == NULL)
		goto out;

	PyModule_AddObject(m, "WB_DOMINFO_DOMAIN_UNKNOWN", PyLong_FromLong((uint16_t)(WB_DOMINFO_DOMAIN_UNKNOWN)));
	PyModule_AddObject(m, "WB_DOMINFO_DOMAIN_NATIVE", PyLong_FromLong((uint16_t)(WB_DOMINFO_DOMAIN_NATIVE)));
	PyModule_AddObject(m, "WB_DOMINFO_DOMAIN_AD", PyLong_FromLong((uint16_t)(WB_DOMINFO_DOMAIN_AD)));
	PyModule_AddObject(m, "WB_DOMINFO_DOMAIN_PRIMARY", PyLong_FromLong((uint16_t)(WB_DOMINFO_DOMAIN_PRIMARY)));
	PyModule_AddObject(m, "WB_DOMINFO_DOMAIN_OFFLINE", PyLong_FromLong((uint16_t)(WB_DOMINFO_DOMAIN_OFFLINE)));
	PyModule_AddObject(m, "WB_SAMLOGON_FOR_NETLOGON", PyLong_FromLong((uint16_t)(WB_SAMLOGON_FOR_NETLOGON)));
	Py_INCREF((PyObject *)(void *)&wbint_TransID_Type);
	PyModule_AddObject(m, "wbint_TransID", (PyObject *)(void *)&wbint_TransID_Type);
	Py_INCREF((PyObject *)(void *)&wbint_TransIDArray_Type);
	PyModule_AddObject(m, "wbint_TransIDArray", (PyObject *)(void *)&wbint_TransIDArray_Type);
	Py_INCREF((PyObject *)(void *)&wbint_userinfo_Type);
	PyModule_AddObject(m, "wbint_userinfo", (PyObject *)(void *)&wbint_userinfo_Type);
	Py_INCREF((PyObject *)(void *)&wbint_SidArray_Type);
	PyModule_AddObject(m, "wbint_SidArray", (PyObject *)(void *)&wbint_SidArray_Type);
	Py_INCREF((PyObject *)(void *)&wbint_RidArray_Type);
	PyModule_AddObject(m, "wbint_RidArray", (PyObject *)(void *)&wbint_RidArray_Type);
	Py_INCREF((PyObject *)(void *)&wbint_Principal_Type);
	PyModule_AddObject(m, "wbint_Principal", (PyObject *)(void *)&wbint_Principal_Type);
	Py_INCREF((PyObject *)(void *)&wbint_Principals_Type);
	PyModule_AddObject(m, "wbint_Principals", (PyObject *)(void *)&wbint_Principals_Type);
	Py_INCREF((PyObject *)(void *)&wbint_userinfos_Type);
	PyModule_AddObject(m, "wbint_userinfos", (PyObject *)(void *)&wbint_userinfos_Type);
	Py_INCREF((PyObject *)(void *)&wbint_Validation_Type);
	PyModule_AddObject(m, "wbint_Validation", (PyObject *)(void *)&wbint_Validation_Type);
	Py_INCREF((PyObject *)(void *)&wbint_AuthUserInfo_Type);
	PyModule_AddObject(m, "wbint_AuthUserInfo", (PyObject *)(void *)&wbint_AuthUserInfo_Type);
	Py_INCREF((PyObject *)(void *)&wbint_PamAuthCrapValidation_Type);
	PyModule_AddObject(m, "wbint_PamAuthCrapValidation", (PyObject *)(void *)&wbint_PamAuthCrapValidation_Type);
	Py_INCREF((PyObject *)(void *)&wbint_Ping_Type);
	PyModule_AddObject(m, "wbint_Ping", (PyObject *)(void *)&wbint_Ping_Type);
	Py_INCREF((PyObject *)(void *)&wbint_LookupSid_Type);
	PyModule_AddObject(m, "wbint_LookupSid", (PyObject *)(void *)&wbint_LookupSid_Type);
	Py_INCREF((PyObject *)(void *)&wbint_LookupSids_Type);
	PyModule_AddObject(m, "wbint_LookupSids", (PyObject *)(void *)&wbint_LookupSids_Type);
	Py_INCREF((PyObject *)(void *)&wbint_LookupName_Type);
	PyModule_AddObject(m, "wbint_LookupName", (PyObject *)(void *)&wbint_LookupName_Type);
	Py_INCREF((PyObject *)(void *)&wbint_Sids2UnixIDs_Type);
	PyModule_AddObject(m, "wbint_Sids2UnixIDs", (PyObject *)(void *)&wbint_Sids2UnixIDs_Type);
	Py_INCREF((PyObject *)(void *)&wbint_UnixIDs2Sids_Type);
	PyModule_AddObject(m, "wbint_UnixIDs2Sids", (PyObject *)(void *)&wbint_UnixIDs2Sids_Type);
	Py_INCREF((PyObject *)(void *)&wbint_AllocateUid_Type);
	PyModule_AddObject(m, "wbint_AllocateUid", (PyObject *)(void *)&wbint_AllocateUid_Type);
	Py_INCREF((PyObject *)(void *)&wbint_AllocateGid_Type);
	PyModule_AddObject(m, "wbint_AllocateGid", (PyObject *)(void *)&wbint_AllocateGid_Type);
	Py_INCREF((PyObject *)(void *)&wbint_GetNssInfo_Type);
	PyModule_AddObject(m, "wbint_GetNssInfo", (PyObject *)(void *)&wbint_GetNssInfo_Type);
	Py_INCREF((PyObject *)(void *)&wbint_LookupUserAliases_Type);
	PyModule_AddObject(m, "wbint_LookupUserAliases", (PyObject *)(void *)&wbint_LookupUserAliases_Type);
	Py_INCREF((PyObject *)(void *)&wbint_LookupUserGroups_Type);
	PyModule_AddObject(m, "wbint_LookupUserGroups", (PyObject *)(void *)&wbint_LookupUserGroups_Type);
	Py_INCREF((PyObject *)(void *)&wbint_QuerySequenceNumber_Type);
	PyModule_AddObject(m, "wbint_QuerySequenceNumber", (PyObject *)(void *)&wbint_QuerySequenceNumber_Type);
	Py_INCREF((PyObject *)(void *)&wbint_LookupGroupMembers_Type);
	PyModule_AddObject(m, "wbint_LookupGroupMembers", (PyObject *)(void *)&wbint_LookupGroupMembers_Type);
	Py_INCREF((PyObject *)(void *)&wbint_LookupAliasMembers_Type);
	PyModule_AddObject(m, "wbint_LookupAliasMembers", (PyObject *)(void *)&wbint_LookupAliasMembers_Type);
	Py_INCREF((PyObject *)(void *)&wbint_QueryGroupList_Type);
	PyModule_AddObject(m, "wbint_QueryGroupList", (PyObject *)(void *)&wbint_QueryGroupList_Type);
	Py_INCREF((PyObject *)(void *)&wbint_QueryUserRidList_Type);
	PyModule_AddObject(m, "wbint_QueryUserRidList", (PyObject *)(void *)&wbint_QueryUserRidList_Type);
	Py_INCREF((PyObject *)(void *)&wbint_DsGetDcName_Type);
	PyModule_AddObject(m, "wbint_DsGetDcName", (PyObject *)(void *)&wbint_DsGetDcName_Type);
	Py_INCREF((PyObject *)(void *)&wbint_LookupRids_Type);
	PyModule_AddObject(m, "wbint_LookupRids", (PyObject *)(void *)&wbint_LookupRids_Type);
	Py_INCREF((PyObject *)(void *)&wbint_CheckMachineAccount_Type);
	PyModule_AddObject(m, "wbint_CheckMachineAccount", (PyObject *)(void *)&wbint_CheckMachineAccount_Type);
	Py_INCREF((PyObject *)(void *)&wbint_ChangeMachineAccount_Type);
	PyModule_AddObject(m, "wbint_ChangeMachineAccount", (PyObject *)(void *)&wbint_ChangeMachineAccount_Type);
	Py_INCREF((PyObject *)(void *)&wbint_PingDc_Type);
	PyModule_AddObject(m, "wbint_PingDc", (PyObject *)(void *)&wbint_PingDc_Type);
	Py_INCREF((PyObject *)(void *)&wbint_ListTrustedDomains_Type);
	PyModule_AddObject(m, "wbint_ListTrustedDomains", (PyObject *)(void *)&wbint_ListTrustedDomains_Type);
	Py_INCREF((PyObject *)(void *)&wbint_PamAuth_Type);
	PyModule_AddObject(m, "wbint_PamAuth", (PyObject *)(void *)&wbint_PamAuth_Type);
	Py_INCREF((PyObject *)(void *)&wbint_PamAuthCrap_Type);
	PyModule_AddObject(m, "wbint_PamAuthCrap", (PyObject *)(void *)&wbint_PamAuthCrap_Type);
	Py_INCREF((PyObject *)(void *)&wbint_PamLogOff_Type);
	PyModule_AddObject(m, "wbint_PamLogOff", (PyObject *)(void *)&wbint_PamLogOff_Type);
	Py_INCREF((PyObject *)(void *)&wbint_PamAuthCrapChangePassword_Type);
	PyModule_AddObject(m, "wbint_PamAuthCrapChangePassword", (PyObject *)(void *)&wbint_PamAuthCrapChangePassword_Type);
	Py_INCREF((PyObject *)(void *)&wbint_PamAuthChangePassword_Type);
	PyModule_AddObject(m, "wbint_PamAuthChangePassword", (PyObject *)(void *)&wbint_PamAuthChangePassword_Type);
	Py_INCREF((PyObject *)(void *)&wbint_InitConnection_Type);
	PyModule_AddObject(m, "wbint_InitConnection", (PyObject *)(void *)&wbint_InitConnection_Type);
	Py_INCREF((PyObject *)(void *)&wbint_NormalizeNameMap_Type);
	PyModule_AddObject(m, "wbint_NormalizeNameMap", (PyObject *)(void *)&wbint_NormalizeNameMap_Type);
	Py_INCREF((PyObject *)(void *)&wbint_NormalizeNameUnmap_Type);
	PyModule_AddObject(m, "wbint_NormalizeNameUnmap", (PyObject *)(void *)&wbint_NormalizeNameUnmap_Type);
	Py_INCREF((PyObject *)(void *)&winbind_SamLogon_Type);
	PyModule_AddObject(m, "SamLogon", (PyObject *)(void *)&winbind_SamLogon_Type);
	Py_INCREF((PyObject *)(void *)&winbind_DsrUpdateReadOnlyServerDnsRecords_Type);
	PyModule_AddObject(m, "DsrUpdateReadOnlyServerDnsRecords", (PyObject *)(void *)&winbind_DsrUpdateReadOnlyServerDnsRecords_Type);
	Py_INCREF((PyObject *)(void *)&winbind_LogonControl_Type);
	PyModule_AddObject(m, "LogonControl", (PyObject *)(void *)&winbind_LogonControl_Type);
	Py_INCREF((PyObject *)(void *)&winbind_GetForestTrustInformation_Type);
	PyModule_AddObject(m, "GetForestTrustInformation", (PyObject *)(void *)&winbind_GetForestTrustInformation_Type);
	Py_INCREF((PyObject *)(void *)&winbind_SendToSam_Type);
	PyModule_AddObject(m, "SendToSam", (PyObject *)(void *)&winbind_SendToSam_Type);
	Py_INCREF((PyObject *)(void *)&winbind_InterfaceType);
	PyModule_AddObject(m, "winbind", (PyObject *)(void *)&winbind_InterfaceType);
	Py_INCREF((PyObject *)(void *)&winbind_SyntaxType);
	PyModule_AddObject(m, "winbind_abstract_syntax", (PyObject *)(void *)&winbind_SyntaxType);
	Py_INCREF((PyObject *)(void *)&winbind_SyntaxType);
	PyModule_AddObject(m, "abstract_syntax", (PyObject *)(void *)&winbind_SyntaxType);
#ifdef PY_MOD_WINBIND_PATCH
	PY_MOD_WINBIND_PATCH(m);
#endif
	out:
	Py_XDECREF(dep_samba_dcerpc_lsa);
	Py_XDECREF(dep_samba_dcerpc_netlogon);
	Py_XDECREF(dep_samba_dcerpc_samr);
	Py_XDECREF(dep_samba_dcerpc_misc);
	Py_XDECREF(dep_samba_dcerpc_security);
	Py_XDECREF(dep_samba_dcerpc_idmap);
	Py_XDECREF(dep_talloc);
	Py_XDECREF(dep_samba_dcerpc_base);
	return m;

}
