#ifndef __SOURCE4_DSDB_REPL_DREPL_SERVICE_PROTO_H__
#define __SOURCE4_DSDB_REPL_DREPL_SERVICE_PROTO_H__

#undef _PRINTF_ATTRIBUTE
#define _PRINTF_ATTRIBUTE(a1, a2) PRINTF_ATTRIBUTE(a1, a2)
/* This file was automatically generated by mkproto.pl. DO NOT EDIT */

/* this file contains prototypes for functions that are private 
 * to this subsystem or library. These functions should not be 
 * used outside this particular subsystem! */


/* The following definitions come from ../../source4/dsdb/repl/drepl_service.c  */


/**
 * Called when the auth code wants us to try and replicate
 * a users secrets
 */
NTSTATUS server_service_drepl_init(TALLOC_CTX *ctx);

/* The following definitions come from ../../source4/dsdb/repl/drepl_periodic.c  */

WERROR dreplsrv_periodic_schedule(struct dreplsrv_service *service, uint32_t next_interval);
void dreplsrv_run_pending_ops(struct dreplsrv_service *s);
void dreplsrv_pendingops_schedule_pull_now(struct dreplsrv_service *service);

/* The following definitions come from ../../source4/dsdb/repl/drepl_partitions.c  */

WERROR dreplsrv_load_partitions(struct dreplsrv_service *s);
WERROR dreplsrv_out_connection_attach(struct dreplsrv_service *s,
				      const struct repsFromTo1 *rft,
				      struct dreplsrv_out_connection **_conn);

/**
 * Find a partition when given a NC
 * If the NC can't be found it will return BAD_NC
 * Initial checks for invalid parameters have to be done beforehand
 */
WERROR dreplsrv_partition_find_for_nc(struct dreplsrv_service *s,
				      struct GUID *nc_guid,
				      struct dom_sid *nc_sid,
				      const char *nc_dn_str,
				      struct dreplsrv_partition **_p);
WERROR dreplsrv_partition_source_dsa_by_guid(struct dreplsrv_partition *p,
					     const struct GUID *dsa_guid,
					     struct dreplsrv_partition_source_dsa **_dsa);
WERROR dreplsrv_partition_source_dsa_by_dns(const struct dreplsrv_partition *p,
					    const char *dsa_dns,
					    struct dreplsrv_partition_source_dsa **_dsa);
WERROR dreplsrv_partition_source_dsa_temporary(struct dreplsrv_partition *p,
					       TALLOC_CTX *mem_ctx,
					       const struct GUID *dsa_guid,
					       struct dreplsrv_partition_source_dsa **_dsa);
WERROR dreplsrv_refresh_partitions(struct dreplsrv_service *s);

/* The following definitions come from ../../source4/dsdb/repl/drepl_out_pull.c  */

void drepl_reps_update(struct dreplsrv_service *s, const char *reps_attr,
		       struct ldb_dn *dn,
		       struct GUID *source_dsa_obj_guid, WERROR status);
WERROR dreplsrv_schedule_partition_pull_source(struct dreplsrv_service *s,
					       struct dreplsrv_partition_source_dsa *source,
					       uint32_t options,
					       enum drsuapi_DsExtendedOperation extended_op,
					       uint64_t fsmo_info,
					       dreplsrv_extended_callback_t callback,
					       void *cb_data);
WERROR dreplsrv_schedule_pull_replication(struct dreplsrv_service *s, TALLOC_CTX *mem_ctx);
void dreplsrv_run_pull_ops(struct dreplsrv_service *s);

/* The following definitions come from ../../source4/dsdb/repl/drepl_out_helpers.c  */

struct tevent_req *dreplsrv_out_drsuapi_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct dreplsrv_out_connection *conn);
NTSTATUS dreplsrv_out_drsuapi_recv(struct tevent_req *req);
struct tevent_req *dreplsrv_op_pull_source_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dreplsrv_out_operation *op);

/**
 * If processing a chunk of replication data fails, check if it is due to a
 * problem that can be fixed by setting extra flags in the GetNCChanges request,
 * i.e. GET_ANC or GET_TGT.
 * @returns NT_STATUS_OK if the request was retried, and an error code if not
 */
WERROR dreplsrv_op_pull_source_recv(struct tevent_req *req);

/* The following definitions come from ../../source4/dsdb/repl/drepl_notify.c  */

void dreplsrv_notify_run_ops(struct dreplsrv_service *s);
WERROR dreplsrv_notify_schedule(struct dreplsrv_service *service, uint32_t next_interval);

/* The following definitions come from ../../source4/dsdb/repl/drepl_ridalloc.c  */

WERROR dreplsrv_ridalloc_check_rid_pool(struct dreplsrv_service *service);
void dreplsrv_allocate_rid(struct imessaging_context *msg,
			   void *private_data,
			   uint32_t msg_type,
			   struct server_id server_id,
			   size_t num_fds,
			   int *fds,
			   DATA_BLOB *data);

/* The following definitions come from ../../source4/dsdb/repl/drepl_extended.c  */

WERROR drepl_request_extended_op(struct dreplsrv_service *service,
				 struct ldb_dn *nc_dn,
				 struct ldb_dn *source_dsa_dn,
				 enum drsuapi_DsExtendedOperation extended_op,
				 uint64_t fsmo_info,
				 uint64_t min_usn,
				 dreplsrv_extended_callback_t callback,
				 void *callback_data);

/* The following definitions come from ../../source4/dsdb/repl/drepl_fsmo.c  */

NTSTATUS drepl_take_FSMO_role(struct irpc_message *msg,
			      struct drepl_takeFSMORole *r);

/* The following definitions come from ../../source4/dsdb/repl/drepl_secret.c  */


/**
 * Called when the auth code wants us to try and replicate
 * a users secrets
 */
void drepl_repl_secret(struct dreplsrv_service *service,
		       const char *user_dn);

/* The following definitions come from ../../source4/dsdb/repl/drepl_replica.c  */

NTSTATUS drepl_replica_add(struct dreplsrv_service *service,
			   struct drsuapi_DsReplicaAdd *r);
NTSTATUS drepl_replica_del(struct dreplsrv_service *service,
			   struct drsuapi_DsReplicaDel *r);
NTSTATUS drepl_replica_mod(struct dreplsrv_service *service,
			   struct drsuapi_DsReplicaMod *r);
#undef _PRINTF_ATTRIBUTE
#define _PRINTF_ATTRIBUTE(a1, a2)

#endif /* __SOURCE4_DSDB_REPL_DREPL_SERVICE_PROTO_H__ */

