/* LanguageListBox.c generated by valac 0.56.18, the Vala compiler
 * generated from LanguageListBox.vala, do not modify */

/* Copyright 2015-2019 elementary, Inc. (https://elementary.io)
*
* This program is free software: you can redistribute it
* and/or modify it under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation, either version 3 of the
* License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
* Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program. If not, see http://www.gnu.org/licenses/.
*/

#include "io.elementary.settings.locale.h"
#include <gtk/gtk.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <granite-7.h>
#include <libgnome-desktop/gnome-languages.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_TYPE_LANGUAGE_ROW (switchboard_plug_locale_widgets_language_list_box_language_row_get_type ())
#define SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_TYPE_LANGUAGE_ROW, SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow))
#define SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_TYPE_LANGUAGE_ROW, SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRowClass))
#define SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_IS_LANGUAGE_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_TYPE_LANGUAGE_ROW))
#define SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_IS_LANGUAGE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_TYPE_LANGUAGE_ROW))
#define SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_TYPE_LANGUAGE_ROW, SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRowClass))

typedef struct _SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow;
typedef struct _SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRowClass SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRowClass;
enum  {
	SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_0_PROPERTY,
	SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LISTBOX_PROPERTY,
	SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_NUM_PROPERTIES
};
static GParamSpec* switchboard_plug_locale_widgets_language_list_box_properties[SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRowPrivate SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRowPrivate;
enum  {
	SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_0_PROPERTY,
	SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_CODE_PROPERTY,
	SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_TEXT_PROPERTY,
	SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_CURRENT_PROPERTY,
	SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_NUM_PROPERTIES
};
static GParamSpec* switchboard_plug_locale_widgets_language_list_box_language_row_properties[SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_NUM_PROPERTIES];

struct _SwitchboardPlugLocaleWidgetsLanguageListBoxPrivate {
	GtkListBox* _listbox;
	GeeHashMap* languages;
	SwitchboardPlugLocaleLocaleManager* lm;
	GraniteHeaderLabel* installed_languages_label;
};

struct _SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow {
	GtkListBoxRow parent_instance;
	SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRowPrivate * priv;
};

struct _SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRowClass {
	GtkListBoxRowClass parent_class;
};

struct _SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRowPrivate {
	gchar* _code;
	gchar* _text;
	GtkBox* box;
	GtkCheckButton* check_button;
};

static gint SwitchboardPlugLocaleWidgetsLanguageListBox_private_offset;
static gpointer switchboard_plug_locale_widgets_language_list_box_parent_class = NULL;
static gint SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow_private_offset;
static gpointer switchboard_plug_locale_widgets_language_list_box_language_row_parent_class = NULL;
static GtkCheckButton* switchboard_plug_locale_widgets_language_list_box_language_row_group_check_button;
static GtkCheckButton* switchboard_plug_locale_widgets_language_list_box_language_row_group_check_button = NULL;

static GType switchboard_plug_locale_widgets_language_list_box_language_row_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static gint __lambda9_ (SwitchboardPlugLocaleWidgetsLanguageListBox* self,
                 const gchar* a,
                 const gchar* b);
static gint ___lambda9__gcompare_data_func (gconstpointer a,
                                     gconstpointer b,
                                     gpointer self);
static void switchboard_plug_locale_widgets_language_list_box_add_language (SwitchboardPlugLocaleWidgetsLanguageListBox* self,
                                                                     const gchar* code,
                                                                     const gchar* locale);
static gboolean switchboard_plug_locale_widgets_language_list_box_language_row_get_current (SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* self);
static SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* switchboard_plug_locale_widgets_language_list_box_language_row_new (const gchar* code,
                                                                                                                            const gchar* text);
static SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* switchboard_plug_locale_widgets_language_list_box_language_row_construct (GType object_type,
                                                                                                                                  const gchar* code,
                                                                                                                                  const gchar* text);
static void switchboard_plug_locale_widgets_language_list_box_language_row_set_current (SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* self,
                                                                                 gboolean value);
static const gchar* switchboard_plug_locale_widgets_language_list_box_language_row_get_code (SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* self);
static void switchboard_plug_locale_widgets_language_list_box_update_headers (SwitchboardPlugLocaleWidgetsLanguageListBox* self,
                                                                       GtkListBoxRow* row,
                                                                       GtkListBoxRow* before);
static const gchar* switchboard_plug_locale_widgets_language_list_box_language_row_get_text (SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* self);
static void switchboard_plug_locale_widgets_language_list_box_set_listbox (SwitchboardPlugLocaleWidgetsLanguageListBox* self,
                                                                    GtkListBox* value);
static void switchboard_plug_locale_widgets_language_list_box_language_row_set_code (SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* self,
                                                                              const gchar* value);
static void switchboard_plug_locale_widgets_language_list_box_language_row_set_text (SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* self,
                                                                              const gchar* value);
static GObject * switchboard_plug_locale_widgets_language_list_box_language_row_constructor (GType type,
                                                                                      guint n_construct_properties,
                                                                                      GObjectConstructParam * construct_properties);
static void switchboard_plug_locale_widgets_language_list_box_language_row_finalize (GObject * obj);
static GType switchboard_plug_locale_widgets_language_list_box_language_row_get_type_once (void);
static void _vala_switchboard_plug_locale_widgets_language_list_box_language_row_get_property (GObject * object,
                                                                                        guint property_id,
                                                                                        GValue * value,
                                                                                        GParamSpec * pspec);
static void _vala_switchboard_plug_locale_widgets_language_list_box_language_row_set_property (GObject * object,
                                                                                        guint property_id,
                                                                                        const GValue * value,
                                                                                        GParamSpec * pspec);
static GObject * switchboard_plug_locale_widgets_language_list_box_constructor (GType type,
                                                                         guint n_construct_properties,
                                                                         GObjectConstructParam * construct_properties);
static void _switchboard_plug_locale_widgets_language_list_box_update_headers_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                                                        GtkListBoxRow* before,
                                                                                                        gpointer self);
static void switchboard_plug_locale_widgets_language_list_box_finalize (GObject * obj);
static GType switchboard_plug_locale_widgets_language_list_box_get_type_once (void);
static void _vala_switchboard_plug_locale_widgets_language_list_box_get_property (GObject * object,
                                                                           guint property_id,
                                                                           GValue * value,
                                                                           GParamSpec * pspec);
static void _vala_switchboard_plug_locale_widgets_language_list_box_set_property (GObject * object,
                                                                           guint property_id,
                                                                           const GValue * value,
                                                                           GParamSpec * pspec);

static inline gpointer
switchboard_plug_locale_widgets_language_list_box_get_instance_private (SwitchboardPlugLocaleWidgetsLanguageListBox* self)
{
	return G_STRUCT_MEMBER_P (self, SwitchboardPlugLocaleWidgetsLanguageListBox_private_offset);
}

static gint
__lambda9_ (SwitchboardPlugLocaleWidgetsLanguageListBox* self,
            const gchar* a,
            const gchar* b)
{
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	result = g_utf8_collate (a, b);
	return result;
}

static gint
___lambda9__gcompare_data_func (gconstpointer a,
                                gconstpointer b,
                                gpointer self)
{
	gint result;
	result = __lambda9_ ((SwitchboardPlugLocaleWidgetsLanguageListBox*) self, (const gchar*) a, (const gchar*) b);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
switchboard_plug_locale_widgets_language_list_box_reload_languages (SwitchboardPlugLocaleWidgetsLanguageListBox* self,
                                                                    GeeArrayList* langs)
{
	GeeHashMap* _tmp0_;
	GtkWidget* row = NULL;
	GtkListBox* _tmp18_;
	GtkWidget* _tmp19_;
	GtkWidget* _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (langs != NULL);
	_tmp0_ = self->priv->languages;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp0_);
	while (TRUE) {
		GtkListBox* _tmp1_;
		GtkWidget* _tmp2_;
		GtkListBox* _tmp3_;
		GtkListBox* _tmp4_;
		GtkWidget* _tmp5_;
		_tmp1_ = self->priv->_listbox;
		_tmp2_ = gtk_widget_get_first_child ((GtkWidget*) _tmp1_);
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp3_ = self->priv->_listbox;
		_tmp4_ = self->priv->_listbox;
		_tmp5_ = gtk_widget_get_first_child ((GtkWidget*) _tmp4_);
		gtk_list_box_remove (_tmp3_, _tmp5_);
	}
	gee_list_sort ((GeeList*) langs, ___lambda9__gcompare_data_func, g_object_ref (self), g_object_unref);
	{
		GeeArrayList* _locale_list = NULL;
		gint _locale_size = 0;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _locale_index = 0;
		_locale_list = langs;
		_tmp6_ = _locale_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_locale_size = _tmp8_;
		_locale_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gchar* locale = NULL;
			GeeArrayList* _tmp11_;
			gpointer _tmp12_;
			gchar* code = NULL;
			const gchar* _tmp13_;
			gchar* _tmp14_ = NULL;
			gboolean _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			_locale_index = _locale_index + 1;
			_tmp9_ = _locale_index;
			_tmp10_ = _locale_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _locale_list;
			_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _locale_index);
			locale = (gchar*) _tmp12_;
			_tmp13_ = locale;
			_tmp15_ = gnome_parse_locale (_tmp13_, &_tmp14_, NULL, NULL, NULL);
			_g_free0 (code);
			code = _tmp14_;
			if (!_tmp15_) {
				_g_free0 (code);
				_g_free0 (locale);
				continue;
			}
			_tmp16_ = code;
			_tmp17_ = locale;
			switchboard_plug_locale_widgets_language_list_box_add_language (self, _tmp16_, _tmp17_);
			_g_free0 (code);
			_g_free0 (locale);
		}
	}
	_tmp18_ = self->priv->_listbox;
	_tmp19_ = gtk_widget_get_first_child ((GtkWidget*) _tmp18_);
	_tmp20_ = _g_object_ref0 (_tmp19_);
	row = _tmp20_;
	while (TRUE) {
		GtkWidget* _tmp21_;
		gboolean _tmp22_ = FALSE;
		GtkWidget* _tmp23_;
		GtkWidget* _tmp29_;
		GtkWidget* _tmp30_;
		GtkWidget* _tmp31_;
		_tmp21_ = row;
		if (!(_tmp21_ != NULL)) {
			break;
		}
		_tmp23_ = row;
		if (SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_IS_LANGUAGE_ROW (_tmp23_)) {
			GtkWidget* _tmp24_;
			gboolean _tmp25_;
			gboolean _tmp26_;
			_tmp24_ = row;
			_tmp25_ = switchboard_plug_locale_widgets_language_list_box_language_row_get_current (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_TYPE_LANGUAGE_ROW, SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow));
			_tmp26_ = _tmp25_;
			_tmp22_ = _tmp26_;
		} else {
			_tmp22_ = FALSE;
		}
		if (_tmp22_) {
			GtkListBox* _tmp27_;
			GtkWidget* _tmp28_;
			_tmp27_ = self->priv->_listbox;
			_tmp28_ = row;
			gtk_list_box_select_row (_tmp27_, (GtkListBoxRow*) G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_TYPE_LANGUAGE_ROW, SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow));
		}
		_tmp29_ = row;
		_tmp30_ = gtk_widget_get_next_sibling (_tmp29_);
		_tmp31_ = _g_object_ref0 (_tmp30_);
		_g_object_unref0 (row);
		row = _tmp31_;
	}
	_g_object_unref0 (row);
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static void
switchboard_plug_locale_widgets_language_list_box_add_language (SwitchboardPlugLocaleWidgetsLanguageListBox* self,
                                                                const gchar* code,
                                                                const gchar* locale)
{
	GeeHashMap* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (code != NULL);
	g_return_if_fail (locale != NULL);
	_tmp0_ = self->priv->languages;
	if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, code)) {
		gchar* language_string = NULL;
		gchar* _tmp1_;
		GeeHashMap* _tmp2_;
		const gchar* _tmp3_;
		SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* _tmp4_;
		SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* _tmp5_;
		GtkListBox* _tmp6_;
		GeeHashMap* _tmp7_;
		gpointer _tmp8_;
		SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* _tmp9_;
		SwitchboardPlugLocaleLocaleManager* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gboolean _tmp15_;
		_tmp1_ = switchboard_plug_locale_utils_translate (code, locale);
		language_string = _tmp1_;
		_tmp2_ = self->priv->languages;
		_tmp3_ = language_string;
		_tmp4_ = switchboard_plug_locale_widgets_language_list_box_language_row_new (code, _tmp3_);
		g_object_ref_sink (_tmp4_);
		_tmp5_ = _tmp4_;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp2_, code, _tmp5_);
		_g_object_unref0 (_tmp5_);
		_tmp6_ = self->priv->_listbox;
		_tmp7_ = self->priv->languages;
		_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp7_, code);
		_tmp9_ = (SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow*) _tmp8_;
		gtk_list_box_append (_tmp6_, (GtkWidget*) _tmp9_);
		_g_object_unref0 (_tmp9_);
		_tmp10_ = self->priv->lm;
		_tmp11_ = switchboard_plug_locale_locale_manager_get_user_language (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = string_slice (_tmp12_, (glong) 0, (glong) 2);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strcmp0 (_tmp14_, code) == 0;
		_g_free0 (_tmp14_);
		_g_free0 (_tmp12_);
		if (_tmp15_) {
			GeeHashMap* _tmp16_;
			gpointer _tmp17_;
			SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* _tmp18_;
			_tmp16_ = self->priv->languages;
			_tmp17_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp16_, code);
			_tmp18_ = (SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow*) _tmp17_;
			switchboard_plug_locale_widgets_language_list_box_language_row_set_current (_tmp18_, TRUE);
			_g_object_unref0 (_tmp18_);
		}
		_g_free0 (language_string);
	}
}

void
switchboard_plug_locale_widgets_language_list_box_set_current (SwitchboardPlugLocaleWidgetsLanguageListBox* self,
                                                               const gchar* code)
{
	GtkWidget* row = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (code != NULL);
	_tmp0_ = gtk_widget_get_first_child ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	row = _tmp1_;
	while (TRUE) {
		GtkWidget* _tmp2_;
		GtkWidget* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		GtkWidget* _tmp8_;
		GtkWidget* _tmp9_;
		GtkWidget* _tmp10_;
		_tmp2_ = row;
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp3_ = row;
		_tmp4_ = switchboard_plug_locale_widgets_language_list_box_language_row_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_TYPE_LANGUAGE_ROW, SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow));
		_tmp5_ = _tmp4_;
		if (g_strcmp0 (_tmp5_, code) == 0) {
			GtkWidget* _tmp6_;
			_tmp6_ = row;
			switchboard_plug_locale_widgets_language_list_box_language_row_set_current (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_TYPE_LANGUAGE_ROW, SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow), TRUE);
		} else {
			GtkWidget* _tmp7_;
			_tmp7_ = row;
			switchboard_plug_locale_widgets_language_list_box_language_row_set_current (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_TYPE_LANGUAGE_ROW, SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow), FALSE);
		}
		_tmp8_ = row;
		_tmp9_ = gtk_widget_get_next_sibling (_tmp8_);
		_tmp10_ = _g_object_ref0 (_tmp9_);
		_g_object_unref0 (row);
		row = _tmp10_;
	}
	_g_object_unref0 (row);
}

static void
switchboard_plug_locale_widgets_language_list_box_update_headers (SwitchboardPlugLocaleWidgetsLanguageListBox* self,
                                                                  GtkListBoxRow* row,
                                                                  GtkListBoxRow* before)
{
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = self->priv->_listbox;
	_tmp1_ = gtk_list_box_get_row_at_index (_tmp0_, 0);
	if (row == _tmp1_) {
		GraniteHeaderLabel* _tmp2_;
		_tmp2_ = self->priv->installed_languages_label;
		gtk_list_box_row_set_header (row, (GtkWidget*) _tmp2_);
	}
}

gchar*
switchboard_plug_locale_widgets_language_list_box_get_selected_language_code (SwitchboardPlugLocaleWidgetsLanguageListBox* self)
{
	SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* selected_row = NULL;
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* _tmp2_;
	SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_listbox;
	_tmp1_ = gtk_list_box_get_selected_row (_tmp0_);
	_tmp2_ = _g_object_ref0 (SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_IS_LANGUAGE_ROW (_tmp1_) ? ((SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow*) _tmp1_) : NULL);
	selected_row = _tmp2_;
	_tmp3_ = selected_row;
	if (_tmp3_ != NULL) {
		SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp4_ = selected_row;
		_tmp5_ = switchboard_plug_locale_widgets_language_list_box_language_row_get_code (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strdup (_tmp6_);
		result = _tmp7_;
		_g_object_unref0 (selected_row);
		return result;
	} else {
		result = NULL;
		_g_object_unref0 (selected_row);
		return result;
	}
}

gchar*
switchboard_plug_locale_widgets_language_list_box_get_selected_language_name (SwitchboardPlugLocaleWidgetsLanguageListBox* self)
{
	SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* selected_row = NULL;
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* _tmp2_;
	SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_listbox;
	_tmp1_ = gtk_list_box_get_selected_row (_tmp0_);
	_tmp2_ = _g_object_ref0 (SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_IS_LANGUAGE_ROW (_tmp1_) ? ((SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow*) _tmp1_) : NULL);
	selected_row = _tmp2_;
	_tmp3_ = selected_row;
	if (_tmp3_ != NULL) {
		SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp4_ = selected_row;
		_tmp5_ = switchboard_plug_locale_widgets_language_list_box_language_row_get_text (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strdup (_tmp6_);
		result = _tmp7_;
		_g_object_unref0 (selected_row);
		return result;
	} else {
		result = NULL;
		_g_object_unref0 (selected_row);
		return result;
	}
}

SwitchboardPlugLocaleWidgetsLanguageListBox*
switchboard_plug_locale_widgets_language_list_box_construct (GType object_type)
{
	SwitchboardPlugLocaleWidgetsLanguageListBox * self = NULL;
	self = (SwitchboardPlugLocaleWidgetsLanguageListBox*) g_object_new (object_type, NULL);
	return self;
}

SwitchboardPlugLocaleWidgetsLanguageListBox*
switchboard_plug_locale_widgets_language_list_box_new (void)
{
	return switchboard_plug_locale_widgets_language_list_box_construct (SWITCHBOARD_PLUG_LOCALE_WIDGETS_TYPE_LANGUAGE_LIST_BOX);
}

GtkListBox*
switchboard_plug_locale_widgets_language_list_box_get_listbox (SwitchboardPlugLocaleWidgetsLanguageListBox* self)
{
	GtkListBox* result;
	GtkListBox* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_listbox;
	result = _tmp0_;
	return result;
}

static void
switchboard_plug_locale_widgets_language_list_box_set_listbox (SwitchboardPlugLocaleWidgetsLanguageListBox* self,
                                                               GtkListBox* value)
{
	GtkListBox* old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_plug_locale_widgets_language_list_box_get_listbox (self);
	if (old_value != value) {
		GtkListBox* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_listbox);
		self->priv->_listbox = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, switchboard_plug_locale_widgets_language_list_box_properties[SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LISTBOX_PROPERTY]);
	}
}

static inline gpointer
switchboard_plug_locale_widgets_language_list_box_language_row_get_instance_private (SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* self)
{
	return G_STRUCT_MEMBER_P (self, SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow_private_offset);
}

static SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow*
switchboard_plug_locale_widgets_language_list_box_language_row_construct (GType object_type,
                                                                          const gchar* code,
                                                                          const gchar* text)
{
	SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow * self = NULL;
	g_return_val_if_fail (code != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	self = (SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow*) g_object_new (object_type, "code", code, "text", text, NULL);
	return self;
}

static SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow*
switchboard_plug_locale_widgets_language_list_box_language_row_new (const gchar* code,
                                                                    const gchar* text)
{
	return switchboard_plug_locale_widgets_language_list_box_language_row_construct (SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_TYPE_LANGUAGE_ROW, code, text);
}

static const gchar*
switchboard_plug_locale_widgets_language_list_box_language_row_get_code (SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_code;
	result = _tmp0_;
	return result;
}

static void
switchboard_plug_locale_widgets_language_list_box_language_row_set_code (SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* self,
                                                                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_plug_locale_widgets_language_list_box_language_row_get_code (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_code);
		self->priv->_code = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, switchboard_plug_locale_widgets_language_list_box_language_row_properties[SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_CODE_PROPERTY]);
	}
}

static const gchar*
switchboard_plug_locale_widgets_language_list_box_language_row_get_text (SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_text;
	result = _tmp0_;
	return result;
}

static void
switchboard_plug_locale_widgets_language_list_box_language_row_set_text (SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* self,
                                                                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_plug_locale_widgets_language_list_box_language_row_get_text (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_text);
		self->priv->_text = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, switchboard_plug_locale_widgets_language_list_box_language_row_properties[SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_TEXT_PROPERTY]);
	}
}

static gboolean
switchboard_plug_locale_widgets_language_list_box_language_row_get_current (SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* self)
{
	gboolean result;
	GtkCheckButton* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->check_button;
	result = _tmp0_ != NULL;
	return result;
}

static void
switchboard_plug_locale_widgets_language_list_box_language_row_set_current (SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* self,
                                                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	if (value) {
		GtkCheckButton* _tmp0_;
		GtkCheckButton* _tmp1_;
		gchar* _tmp2_;
		GtkCheckButton* _tmp3_ = NULL;
		GtkBox* _tmp4_;
		GtkCheckButton* _tmp5_;
		_tmp0_ = switchboard_plug_locale_widgets_language_list_box_language_row_group_check_button;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_tmp2_ = g_strdup (_ ("Currently active language"));
		_tmp3_ = (GtkCheckButton*) gtk_check_button_new ();
		gtk_check_button_set_active (_tmp3_, TRUE);
		gtk_check_button_set_group (_tmp3_, _tmp1_);
		_g_object_unref0 (_tmp1_);
		gtk_widget_set_focusable ((GtkWidget*) _tmp3_, FALSE);
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp3_, _tmp2_);
		_g_free0 (_tmp2_);
		g_object_ref_sink (_tmp3_);
		_g_object_unref0 (self->priv->check_button);
		self->priv->check_button = _tmp3_;
		_tmp4_ = self->priv->box;
		_tmp5_ = self->priv->check_button;
		gtk_box_append (_tmp4_, (GtkWidget*) _tmp5_);
	} else {
		GtkBox* _tmp6_;
		GtkCheckButton* _tmp7_;
		_tmp6_ = self->priv->box;
		_tmp7_ = self->priv->check_button;
		gtk_box_remove (_tmp6_, (GtkWidget*) _tmp7_);
		_g_object_unref0 (self->priv->check_button);
		self->priv->check_button = NULL;
	}
	g_object_notify_by_pspec ((GObject *) self, switchboard_plug_locale_widgets_language_list_box_language_row_properties[SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_CURRENT_PROPERTY]);
}

static GObject *
switchboard_plug_locale_widgets_language_list_box_language_row_constructor (GType type,
                                                                            guint n_construct_properties,
                                                                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow * self;
	GtkLabel* label = NULL;
	const gchar* _tmp0_;
	GtkLabel* _tmp1_ = NULL;
	GtkBox* _tmp2_;
	GtkBox* _tmp3_;
	GtkLabel* _tmp4_;
	GtkBox* _tmp5_;
	parent_class = G_OBJECT_CLASS (switchboard_plug_locale_widgets_language_list_box_language_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_TYPE_LANGUAGE_ROW, SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow);
	_tmp0_ = self->priv->_text;
	_tmp1_ = (GtkLabel*) gtk_label_new (_tmp0_);
	gtk_widget_set_halign ((GtkWidget*) _tmp1_, GTK_ALIGN_START);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp1_, TRUE);
	g_object_ref_sink (_tmp1_);
	label = _tmp1_;
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->box);
	self->priv->box = _tmp2_;
	_tmp3_ = self->priv->box;
	_tmp4_ = label;
	gtk_box_append (_tmp3_, (GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->box;
	gtk_list_box_row_set_child ((GtkListBoxRow*) self, (GtkWidget*) _tmp5_);
	_g_object_unref0 (label);
	return obj;
}

static void
switchboard_plug_locale_widgets_language_list_box_language_row_class_init (SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRowClass * klass,
                                                                           gpointer klass_data)
{
	GtkCheckButton* _tmp0_;
	switchboard_plug_locale_widgets_language_list_box_language_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_switchboard_plug_locale_widgets_language_list_box_language_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_switchboard_plug_locale_widgets_language_list_box_language_row_set_property;
	G_OBJECT_CLASS (klass)->constructor = switchboard_plug_locale_widgets_language_list_box_language_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = switchboard_plug_locale_widgets_language_list_box_language_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_CODE_PROPERTY, switchboard_plug_locale_widgets_language_list_box_language_row_properties[SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_CODE_PROPERTY] = g_param_spec_string ("code", "code", "code", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_TEXT_PROPERTY, switchboard_plug_locale_widgets_language_list_box_language_row_properties[SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_TEXT_PROPERTY] = g_param_spec_string ("text", "text", "text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_CURRENT_PROPERTY, switchboard_plug_locale_widgets_language_list_box_language_row_properties[SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_CURRENT_PROPERTY] = g_param_spec_boolean ("current", "current", "current", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = (GtkCheckButton*) gtk_check_button_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (switchboard_plug_locale_widgets_language_list_box_language_row_group_check_button);
	switchboard_plug_locale_widgets_language_list_box_language_row_group_check_button = _tmp0_;
}

static void
switchboard_plug_locale_widgets_language_list_box_language_row_instance_init (SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow * self,
                                                                              gpointer klass)
{
	self->priv = switchboard_plug_locale_widgets_language_list_box_language_row_get_instance_private (self);
}

static void
switchboard_plug_locale_widgets_language_list_box_language_row_finalize (GObject * obj)
{
	SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_TYPE_LANGUAGE_ROW, SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow);
	_g_free0 (self->priv->_code);
	_g_free0 (self->priv->_text);
	_g_object_unref0 (self->priv->box);
	_g_object_unref0 (self->priv->check_button);
	G_OBJECT_CLASS (switchboard_plug_locale_widgets_language_list_box_language_row_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
switchboard_plug_locale_widgets_language_list_box_language_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) switchboard_plug_locale_widgets_language_list_box_language_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow), 0, (GInstanceInitFunc) switchboard_plug_locale_widgets_language_list_box_language_row_instance_init, NULL };
	GType switchboard_plug_locale_widgets_language_list_box_language_row_type_id;
	switchboard_plug_locale_widgets_language_list_box_language_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow", &g_define_type_info, 0);
	SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow_private_offset = g_type_add_instance_private (switchboard_plug_locale_widgets_language_list_box_language_row_type_id, sizeof (SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRowPrivate));
	return switchboard_plug_locale_widgets_language_list_box_language_row_type_id;
}

static GType
switchboard_plug_locale_widgets_language_list_box_language_row_get_type (void)
{
	static gsize switchboard_plug_locale_widgets_language_list_box_language_row_type_id__once = 0;
	if (g_once_init_enter (&switchboard_plug_locale_widgets_language_list_box_language_row_type_id__once)) {
		GType switchboard_plug_locale_widgets_language_list_box_language_row_type_id;
		switchboard_plug_locale_widgets_language_list_box_language_row_type_id = switchboard_plug_locale_widgets_language_list_box_language_row_get_type_once ();
		g_once_init_leave (&switchboard_plug_locale_widgets_language_list_box_language_row_type_id__once, switchboard_plug_locale_widgets_language_list_box_language_row_type_id);
	}
	return switchboard_plug_locale_widgets_language_list_box_language_row_type_id__once;
}

static void
_vala_switchboard_plug_locale_widgets_language_list_box_language_row_get_property (GObject * object,
                                                                                   guint property_id,
                                                                                   GValue * value,
                                                                                   GParamSpec * pspec)
{
	SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_TYPE_LANGUAGE_ROW, SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow);
	switch (property_id) {
		case SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_CODE_PROPERTY:
		g_value_set_string (value, switchboard_plug_locale_widgets_language_list_box_language_row_get_code (self));
		break;
		case SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_TEXT_PROPERTY:
		g_value_set_string (value, switchboard_plug_locale_widgets_language_list_box_language_row_get_text (self));
		break;
		case SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_CURRENT_PROPERTY:
		g_value_set_boolean (value, switchboard_plug_locale_widgets_language_list_box_language_row_get_current (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_switchboard_plug_locale_widgets_language_list_box_language_row_set_property (GObject * object,
                                                                                   guint property_id,
                                                                                   const GValue * value,
                                                                                   GParamSpec * pspec)
{
	SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_TYPE_LANGUAGE_ROW, SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow);
	switch (property_id) {
		case SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_CODE_PROPERTY:
		switchboard_plug_locale_widgets_language_list_box_language_row_set_code (self, g_value_get_string (value));
		break;
		case SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_TEXT_PROPERTY:
		switchboard_plug_locale_widgets_language_list_box_language_row_set_text (self, g_value_get_string (value));
		break;
		case SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_CURRENT_PROPERTY:
		switchboard_plug_locale_widgets_language_list_box_language_row_set_current (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_switchboard_plug_locale_widgets_language_list_box_update_headers_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                                                   GtkListBoxRow* before,
                                                                                                   gpointer self)
{
	switchboard_plug_locale_widgets_language_list_box_update_headers ((SwitchboardPlugLocaleWidgetsLanguageListBox*) self, row, before);
}

static GObject *
switchboard_plug_locale_widgets_language_list_box_constructor (GType type,
                                                               guint n_construct_properties,
                                                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SwitchboardPlugLocaleWidgetsLanguageListBox * self;
	GeeHashMap* _tmp0_;
	SwitchboardPlugLocaleLocaleManager* _tmp1_;
	SwitchboardPlugLocaleLocaleManager* _tmp2_;
	GtkListBox* _tmp3_ = NULL;
	GtkListBox* _tmp4_;
	GtkListBox* _tmp5_;
	GtkListBox* _tmp6_;
	GtkWidget* _tmp7_;
	GraniteHeaderLabel* _tmp8_ = NULL;
	GtkListBox* _tmp9_;
	parent_class = G_OBJECT_CLASS (switchboard_plug_locale_widgets_language_list_box_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_PLUG_LOCALE_WIDGETS_TYPE_LANGUAGE_LIST_BOX, SwitchboardPlugLocaleWidgetsLanguageListBox);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_TYPE_LANGUAGE_ROW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->languages);
	self->priv->languages = _tmp0_;
	_tmp1_ = switchboard_plug_locale_locale_manager_get_default ();
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->lm);
	self->priv->lm = _tmp2_;
	_tmp3_ = (GtkListBox*) gtk_list_box_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp3_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp3_, TRUE);
	g_object_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	switchboard_plug_locale_widgets_language_list_box_set_listbox (self, _tmp4_);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = self->priv->_listbox;
	gtk_list_box_set_header_func (_tmp5_, _switchboard_plug_locale_widgets_language_list_box_update_headers_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
	_tmp6_ = self->priv->_listbox;
	_tmp7_ = _g_object_ref0 ((GtkWidget*) _tmp6_);
	_tmp8_ = granite_header_label_new (_ ("Installed Languages"));
	granite_header_label_set_mnemonic_widget (_tmp8_, _tmp7_);
	_g_object_unref0 (_tmp7_);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->installed_languages_label);
	self->priv->installed_languages_label = _tmp8_;
	_tmp9_ = self->priv->_listbox;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp9_);
	return obj;
}

static void
switchboard_plug_locale_widgets_language_list_box_class_init (SwitchboardPlugLocaleWidgetsLanguageListBoxClass * klass,
                                                              gpointer klass_data)
{
	switchboard_plug_locale_widgets_language_list_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SwitchboardPlugLocaleWidgetsLanguageListBox_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_switchboard_plug_locale_widgets_language_list_box_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_switchboard_plug_locale_widgets_language_list_box_set_property;
	G_OBJECT_CLASS (klass)->constructor = switchboard_plug_locale_widgets_language_list_box_constructor;
	G_OBJECT_CLASS (klass)->finalize = switchboard_plug_locale_widgets_language_list_box_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LISTBOX_PROPERTY, switchboard_plug_locale_widgets_language_list_box_properties[SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LISTBOX_PROPERTY] = g_param_spec_object ("listbox", "listbox", "listbox", gtk_list_box_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
switchboard_plug_locale_widgets_language_list_box_instance_init (SwitchboardPlugLocaleWidgetsLanguageListBox * self,
                                                                 gpointer klass)
{
	self->priv = switchboard_plug_locale_widgets_language_list_box_get_instance_private (self);
}

static void
switchboard_plug_locale_widgets_language_list_box_finalize (GObject * obj)
{
	SwitchboardPlugLocaleWidgetsLanguageListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_PLUG_LOCALE_WIDGETS_TYPE_LANGUAGE_LIST_BOX, SwitchboardPlugLocaleWidgetsLanguageListBox);
	_g_object_unref0 (self->priv->_listbox);
	_g_object_unref0 (self->priv->languages);
	_g_object_unref0 (self->priv->lm);
	_g_object_unref0 (self->priv->installed_languages_label);
	G_OBJECT_CLASS (switchboard_plug_locale_widgets_language_list_box_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
switchboard_plug_locale_widgets_language_list_box_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SwitchboardPlugLocaleWidgetsLanguageListBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) switchboard_plug_locale_widgets_language_list_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwitchboardPlugLocaleWidgetsLanguageListBox), 0, (GInstanceInitFunc) switchboard_plug_locale_widgets_language_list_box_instance_init, NULL };
	GType switchboard_plug_locale_widgets_language_list_box_type_id;
	switchboard_plug_locale_widgets_language_list_box_type_id = g_type_register_static (gtk_box_get_type (), "SwitchboardPlugLocaleWidgetsLanguageListBox", &g_define_type_info, 0);
	SwitchboardPlugLocaleWidgetsLanguageListBox_private_offset = g_type_add_instance_private (switchboard_plug_locale_widgets_language_list_box_type_id, sizeof (SwitchboardPlugLocaleWidgetsLanguageListBoxPrivate));
	return switchboard_plug_locale_widgets_language_list_box_type_id;
}

GType
switchboard_plug_locale_widgets_language_list_box_get_type (void)
{
	static gsize switchboard_plug_locale_widgets_language_list_box_type_id__once = 0;
	if (g_once_init_enter (&switchboard_plug_locale_widgets_language_list_box_type_id__once)) {
		GType switchboard_plug_locale_widgets_language_list_box_type_id;
		switchboard_plug_locale_widgets_language_list_box_type_id = switchboard_plug_locale_widgets_language_list_box_get_type_once ();
		g_once_init_leave (&switchboard_plug_locale_widgets_language_list_box_type_id__once, switchboard_plug_locale_widgets_language_list_box_type_id);
	}
	return switchboard_plug_locale_widgets_language_list_box_type_id__once;
}

static void
_vala_switchboard_plug_locale_widgets_language_list_box_get_property (GObject * object,
                                                                      guint property_id,
                                                                      GValue * value,
                                                                      GParamSpec * pspec)
{
	SwitchboardPlugLocaleWidgetsLanguageListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHBOARD_PLUG_LOCALE_WIDGETS_TYPE_LANGUAGE_LIST_BOX, SwitchboardPlugLocaleWidgetsLanguageListBox);
	switch (property_id) {
		case SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LISTBOX_PROPERTY:
		g_value_set_object (value, switchboard_plug_locale_widgets_language_list_box_get_listbox (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_switchboard_plug_locale_widgets_language_list_box_set_property (GObject * object,
                                                                      guint property_id,
                                                                      const GValue * value,
                                                                      GParamSpec * pspec)
{
	SwitchboardPlugLocaleWidgetsLanguageListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHBOARD_PLUG_LOCALE_WIDGETS_TYPE_LANGUAGE_LIST_BOX, SwitchboardPlugLocaleWidgetsLanguageListBox);
	switch (property_id) {
		case SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LISTBOX_PROPERTY:
		switchboard_plug_locale_widgets_language_list_box_set_listbox (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

