/* InternetView.c generated by valac 0.56.17, the Vala compiler
 * generated from InternetView.vala, do not modify */

/*
 * SPDX-License-Identifier: LGPL-3.0-or-later
 * SPDX-FileCopyrightText: 2023 elementary, Inc. (https://elementary.io)
 *                         2015 Adam Bieńkowski
 */

#include "screentime-limits.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <act/act.h>
#include <gtk/gtk.h>
#include <granite-7.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <polkit/polkit.h>
#include <glib/gi18n-lib.h>

#define PC_WIDGETS_INTERNET_BOX_URL_REGEX "([^/w.])[-a-zA-Z0-9@:%._\\+~#=]{2,256}\\.[a-z]{1,3}([^/])\\b([-a-zA-Z0" \
"-9@:%_\\+.~#?&//=]*\\b)"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PC_WIDGETS_INTERNET_BOX_0_PROPERTY,
	PC_WIDGETS_INTERNET_BOX_USER_PROPERTY,
	PC_WIDGETS_INTERNET_BOX_NUM_PROPERTIES
};
static GParamSpec* pc_widgets_internet_box_properties[PC_WIDGETS_INTERNET_BOX_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _PcWidgetsInternetBoxLoadExistingData PcWidgetsInternetBoxLoadExistingData;

#define PC_WIDGETS_INTERNET_BOX_TYPE_URL_ENTRY (pc_widgets_internet_box_url_entry_get_type ())
#define PC_WIDGETS_INTERNET_BOX_URL_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PC_WIDGETS_INTERNET_BOX_TYPE_URL_ENTRY, PCWidgetsInternetBoxUrlEntry))
#define PC_WIDGETS_INTERNET_BOX_URL_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PC_WIDGETS_INTERNET_BOX_TYPE_URL_ENTRY, PCWidgetsInternetBoxUrlEntryClass))
#define PC_WIDGETS_INTERNET_BOX_IS_URL_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PC_WIDGETS_INTERNET_BOX_TYPE_URL_ENTRY))
#define PC_WIDGETS_INTERNET_BOX_IS_URL_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PC_WIDGETS_INTERNET_BOX_TYPE_URL_ENTRY))
#define PC_WIDGETS_INTERNET_BOX_URL_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PC_WIDGETS_INTERNET_BOX_TYPE_URL_ENTRY, PCWidgetsInternetBoxUrlEntryClass))

typedef struct _PCWidgetsInternetBoxUrlEntry PCWidgetsInternetBoxUrlEntry;
typedef struct _PCWidgetsInternetBoxUrlEntryClass PCWidgetsInternetBoxUrlEntryClass;
typedef struct _PCWidgetsInternetBoxUrlEntryPrivate PCWidgetsInternetBoxUrlEntryPrivate;
enum  {
	PC_WIDGETS_INTERNET_BOX_URL_ENTRY_0_PROPERTY,
	PC_WIDGETS_INTERNET_BOX_URL_ENTRY_URL_PROPERTY,
	PC_WIDGETS_INTERNET_BOX_URL_ENTRY_NUM_PROPERTIES
};
static GParamSpec* pc_widgets_internet_box_url_entry_properties[PC_WIDGETS_INTERNET_BOX_URL_ENTRY_NUM_PROPERTIES];

struct _PCWidgetsInternetBoxPrivate {
	gchar* entry_secondary_tooltip_text;
	ActUser* _user;
	GMatchInfo* pattern;
	GRegex* url_regex;
	GtkListBox* list_box;
	GraniteValidatedEntry* entry;
	GtkButton* add_button;
};

struct _PcWidgetsInternetBoxLoadExistingData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PCWidgetsInternetBox* self;
	gchar** block_urls;
	PCIParentalControls* _tmp0_;
	ActUser* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gchar** _tmp4_;
	gint block_urls_length1;
	gint _block_urls_size_;
	gchar** url_collection;
	gint url_collection_length1;
	gint _url_collection_size_;
	gint url_it;
	const gchar* url;
	const gchar* _tmp5_;
	GError* e;
	GError* _tmp6_;
	const gchar* _tmp7_;
	GError* _inner_error0_;
};

struct _PCWidgetsInternetBoxUrlEntry {
	GtkListBoxRow parent_instance;
	PCWidgetsInternetBoxUrlEntryPrivate * priv;
};

struct _PCWidgetsInternetBoxUrlEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _PCWidgetsInternetBoxUrlEntryPrivate {
	gchar* _url;
};

static gint PCWidgetsInternetBox_private_offset;
static gpointer pc_widgets_internet_box_parent_class = NULL;
static gint PCWidgetsInternetBoxUrlEntry_private_offset;
static gpointer pc_widgets_internet_box_url_entry_parent_class = NULL;

static void pc_widgets_internet_box_load_existing_data_free (gpointer _data);
static void pc_widgets_internet_box_load_existing (PCWidgetsInternetBox* self,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
static void pc_widgets_internet_box_load_existing_finish (PCWidgetsInternetBox* self,
                                                   GAsyncResult* _res_);
static gboolean pc_widgets_internet_box_load_existing_co (PcWidgetsInternetBoxLoadExistingData* _data_);
static void pc_widgets_internet_box_load_existing_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_);
static void pc_widgets_internet_box_add_entry (PCWidgetsInternetBox* self,
                                        const gchar* url);
static void pc_widgets_internet_box_update_block_urls (PCWidgetsInternetBox* self);
static GType pc_widgets_internet_box_url_entry_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static const gchar* pc_widgets_internet_box_url_entry_get_url (PCWidgetsInternetBoxUrlEntry* self);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void pc_widgets_internet_box_on_entry_activate (PCWidgetsInternetBox* self);
static void pc_widgets_internet_box_on_entry_changed (PCWidgetsInternetBox* self);
static PCWidgetsInternetBoxUrlEntry* pc_widgets_internet_box_url_entry_new (const gchar* url);
static PCWidgetsInternetBoxUrlEntry* pc_widgets_internet_box_url_entry_construct (GType object_type,
                                                                           const gchar* url);
static void __lambda15_ (PCWidgetsInternetBox* self);
static void ___lambda15__gtk_widget_destroy (GtkWidget* _sender,
                                      gpointer self);
static void pc_widgets_internet_box_url_entry_set_url (PCWidgetsInternetBoxUrlEntry* self,
                                                const gchar* value);
static GObject * pc_widgets_internet_box_url_entry_constructor (GType type,
                                                         guint n_construct_properties,
                                                         GObjectConstructParam * construct_properties);
static void _pc_widgets_internet_box_url_entry___lambda14_ (PCWidgetsInternetBoxUrlEntry* self);
static void __pc_widgets_internet_box_url_entry___lambda14__gtk_button_clicked (GtkButton* _sender,
                                                                         gpointer self);
static void pc_widgets_internet_box_url_entry_finalize (GObject * obj);
static GType pc_widgets_internet_box_url_entry_get_type_once (void);
static void _vala_pc_widgets_internet_box_url_entry_get_property (GObject * object,
                                                           guint property_id,
                                                           GValue * value,
                                                           GParamSpec * pspec);
static void _vala_pc_widgets_internet_box_url_entry_set_property (GObject * object,
                                                           guint property_id,
                                                           const GValue * value,
                                                           GParamSpec * pspec);
static GObject * pc_widgets_internet_box_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void _pc_widgets_internet_box_on_entry_activate_gtk_button_clicked (GtkButton* _sender,
                                                                    gpointer self);
static void _pc_widgets_internet_box___lambda16_ (PCWidgetsInternetBox* self);
static void __pc_widgets_internet_box___lambda16__g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self);
static void _pc_widgets_internet_box___lambda17_ (PCWidgetsInternetBox* self);
static void __pc_widgets_internet_box___lambda17__gtk_editable_changed (GtkEditable* _sender,
                                                                 gpointer self);
static void _pc_widgets_internet_box_on_entry_activate_gtk_entry_activate (GtkEntry* _sender,
                                                                    gpointer self);
static void pc_widgets_internet_box_finalize (GObject * obj);
static GType pc_widgets_internet_box_get_type_once (void);
static void _vala_pc_widgets_internet_box_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_pc_widgets_internet_box_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
pc_widgets_internet_box_get_instance_private (PCWidgetsInternetBox* self)
{
	return G_STRUCT_MEMBER_P (self, PCWidgetsInternetBox_private_offset);
}

PCWidgetsInternetBox*
pc_widgets_internet_box_construct (GType object_type,
                                   ActUser* user)
{
	PCWidgetsInternetBox * self = NULL;
	g_return_val_if_fail (user != NULL, NULL);
	self = (PCWidgetsInternetBox*) g_object_new (object_type, "user", user, NULL);
	return self;
}

PCWidgetsInternetBox*
pc_widgets_internet_box_new (ActUser* user)
{
	return pc_widgets_internet_box_construct (PC_WIDGETS_TYPE_INTERNET_BOX, user);
}

static void
pc_widgets_internet_box_load_existing_data_free (gpointer _data)
{
	PcWidgetsInternetBoxLoadExistingData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (PcWidgetsInternetBoxLoadExistingData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
pc_widgets_internet_box_load_existing (PCWidgetsInternetBox* self,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	PcWidgetsInternetBoxLoadExistingData* _data_;
	PCWidgetsInternetBox* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (PcWidgetsInternetBoxLoadExistingData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, pc_widgets_internet_box_load_existing_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	pc_widgets_internet_box_load_existing_co (_data_);
}

static void
pc_widgets_internet_box_load_existing_finish (PCWidgetsInternetBox* self,
                                              GAsyncResult* _res_)
{
	PcWidgetsInternetBoxLoadExistingData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
pc_widgets_internet_box_load_existing_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_)
{
	PcWidgetsInternetBoxLoadExistingData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	pc_widgets_internet_box_load_existing_co (_data_);
}

static gboolean
pc_widgets_internet_box_load_existing_co (PcWidgetsInternetBoxLoadExistingData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = pc_utils_get_api ();
		_data_->_tmp1_ = _data_->self->priv->_user;
		_data_->_tmp2_ = act_user_get_user_name (_data_->_tmp1_);
		_data_->_tmp3_ = 0;
		_data_->_state_ = 1;
		pc_iparental_controls_get_user_daemon_block_urls (_data_->_tmp0_, _data_->_tmp2_, pc_widgets_internet_box_load_existing_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp4_ = pc_iparental_controls_get_user_daemon_block_urls_finish (_data_->_tmp0_, _data_->_res_, &_data_->_tmp3_, &_data_->_inner_error0_);
		_data_->block_urls = _data_->_tmp4_;
		_data_->block_urls_length1 = _data_->_tmp3_;
		_data_->_block_urls_size_ = _data_->block_urls_length1;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		{
			_data_->url_collection_length1 = 0;
			_data_->_url_collection_size_ = 0;
			_data_->url_collection = _data_->block_urls;
			_data_->url_collection_length1 = _data_->block_urls_length1;
			for (_data_->url_it = 0; _data_->url_it < _data_->url_collection_length1; _data_->url_it = _data_->url_it + 1) {
				_data_->url = _data_->url_collection[_data_->url_it];
				{
					_data_->_tmp5_ = _data_->url;
					pc_widgets_internet_box_add_entry (_data_->self, _data_->_tmp5_);
				}
			}
		}
		_data_->block_urls = (_vala_array_free (_data_->block_urls, _data_->block_urls_length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp6_ = _data_->e;
		_data_->_tmp7_ = _data_->_tmp6_->message;
		g_critical ("InternetView.vala:97: %s", _data_->_tmp7_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
pc_widgets_internet_box_update_block_urls (PCWidgetsInternetBox* self)
{
	PolkitPermission* _tmp0_;
	gchar* formatted_url = NULL;
	GraniteValidatedEntry* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* input_url = NULL;
	GMatchInfo* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* block_url = NULL;
	gint i = 0;
	gchar** block_urls = NULL;
	gchar** _tmp7_;
	gint block_urls_length1;
	gint _block_urls_size_;
	GtkWidget* child = NULL;
	GtkListBox* _tmp8_;
	GtkWidget* _tmp9_;
	GraniteValidatedEntry* _tmp33_;
	PCIParentalControls* _tmp34_;
	ActUser* _tmp35_;
	const gchar* _tmp36_;
	PCIParentalControls* _tmp37_;
	ActUser* _tmp38_;
	const gchar* _tmp39_;
	gchar** _tmp40_;
	gint _tmp40__length1;
	PCIParentalControls* _tmp41_;
	ActUser* _tmp42_;
	const gchar* _tmp43_;
	g_return_if_fail (self != NULL);
	_tmp0_ = pc_utils_get_permission ();
	if (!g_permission_get_allowed ((GPermission*) _tmp0_)) {
		return;
	}
	_tmp1_ = self->priv->entry;
	_tmp2_ = gtk_editable_get_text ((GtkEditable*) _tmp1_);
	_tmp3_ = string_strip (_tmp2_);
	formatted_url = _tmp3_;
	_tmp4_ = self->priv->pattern;
	_tmp5_ = g_match_info_get_string (_tmp4_);
	_tmp6_ = g_strdup (_tmp5_);
	input_url = _tmp6_;
	i = 0;
	_tmp7_ = g_new0 (gchar*, 0 + 1);
	block_urls = _tmp7_;
	block_urls_length1 = 0;
	_block_urls_size_ = block_urls_length1;
	_tmp8_ = self->priv->list_box;
	_tmp9_ = gtk_widget_get_first_child ((GtkWidget*) _tmp8_);
	child = _tmp9_;
	while (TRUE) {
		GtkWidget* _tmp10_;
		GtkWidget* _tmp11_;
		GtkWidget* _tmp31_;
		GtkWidget* _tmp32_;
		_tmp10_ = child;
		if (!(_tmp10_ != NULL)) {
			break;
		}
		_tmp11_ = child;
		if (PC_WIDGETS_INTERNET_BOX_IS_URL_ENTRY (_tmp11_)) {
			GtkWidget* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp29_;
			gchar* _tmp30_;
			_tmp12_ = child;
			_tmp13_ = pc_widgets_internet_box_url_entry_get_url (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, PC_WIDGETS_INTERNET_BOX_TYPE_URL_ENTRY, PCWidgetsInternetBoxUrlEntry));
			_tmp14_ = _tmp13_;
			_tmp15_ = g_strdup (_tmp14_);
			_g_free0 (block_url);
			block_url = _tmp15_;
			_tmp16_ = block_url;
			_tmp17_ = formatted_url;
			if (string_contains (_tmp16_, _tmp17_)) {
				const gchar* _tmp18_;
				gint _tmp19_;
				gint _tmp20_;
				const gchar* _tmp21_;
				gint _tmp22_;
				gint _tmp23_;
				_tmp18_ = formatted_url;
				_tmp19_ = strlen (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = block_url;
				_tmp22_ = strlen (_tmp21_);
				_tmp23_ = _tmp22_;
				if (_tmp20_ == _tmp23_) {
					gint _tmp24_;
					_tmp24_ = i;
					i = _tmp24_ + 1;
					if (i > 1) {
						GtkListBox* _tmp25_;
						GtkWidget* _tmp26_;
						GraniteValidatedEntry* _tmp27_;
						const gchar* _tmp28_;
						_tmp25_ = self->priv->list_box;
						_tmp26_ = child;
						gtk_list_box_remove (_tmp25_, _tmp26_);
						_tmp27_ = self->priv->entry;
						_tmp28_ = input_url;
						gtk_editable_set_text ((GtkEditable*) _tmp27_, _tmp28_);
						block_urls = (_vala_array_free (block_urls, block_urls_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (block_url);
						_g_free0 (input_url);
						_g_free0 (formatted_url);
						return;
					}
				}
			}
			_tmp29_ = block_url;
			_tmp30_ = g_strdup (_tmp29_);
			_vala_array_add4 (&block_urls, &block_urls_length1, &_block_urls_size_, _tmp30_);
		}
		_tmp31_ = child;
		_tmp32_ = gtk_widget_get_next_sibling (_tmp31_);
		child = _tmp32_;
	}
	_tmp33_ = self->priv->entry;
	gtk_editable_set_text ((GtkEditable*) _tmp33_, "");
	_tmp34_ = pc_utils_get_api ();
	_tmp35_ = self->priv->_user;
	_tmp36_ = act_user_get_user_name (_tmp35_);
	pc_iparental_controls_set_user_daemon_active (_tmp34_, _tmp36_, FALSE, NULL, NULL);
	_tmp37_ = pc_utils_get_api ();
	_tmp38_ = self->priv->_user;
	_tmp39_ = act_user_get_user_name (_tmp38_);
	_tmp40_ = block_urls;
	_tmp40__length1 = block_urls_length1;
	pc_iparental_controls_set_user_daemon_block_urls (_tmp37_, _tmp39_, _tmp40_, (gint) _tmp40__length1, NULL, NULL);
	_tmp41_ = pc_utils_get_api ();
	_tmp42_ = self->priv->_user;
	_tmp43_ = act_user_get_user_name (_tmp42_);
	pc_iparental_controls_set_user_daemon_active (_tmp41_, _tmp43_, TRUE, NULL, NULL);
	block_urls = (_vala_array_free (block_urls, block_urls_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (block_url);
	_g_free0 (input_url);
	_g_free0 (formatted_url);
}

static void
pc_widgets_internet_box_on_entry_activate (PCWidgetsInternetBox* self)
{
	GRegex* _tmp0_;
	gchar* url = NULL;
	GraniteValidatedEntry* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GRegex* _tmp4_;
	const gchar* _tmp5_;
	gchar* formatted_url = NULL;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->url_regex;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->entry;
	_tmp2_ = gtk_editable_get_text ((GtkEditable*) _tmp1_);
	_tmp3_ = string_strip (_tmp2_);
	url = _tmp3_;
	_tmp4_ = self->priv->url_regex;
	_tmp5_ = url;
	if (!g_regex_match (_tmp4_, _tmp5_, 0, NULL)) {
		_g_free0 (url);
		return;
	}
	formatted_url = NULL;
	{
		{
			GRegex* _tmp6_;
			const gchar* _tmp7_;
			GMatchInfo* _tmp8_ = NULL;
			gboolean _tmp9_ = FALSE;
			_tmp6_ = self->priv->url_regex;
			_tmp7_ = url;
			g_regex_match (_tmp6_, _tmp7_, 0, &_tmp8_);
			_g_match_info_unref0 (self->priv->pattern);
			self->priv->pattern = _tmp8_;
			_tmp9_ = TRUE;
			while (TRUE) {
				GMatchInfo* _tmp11_;
				GMatchInfo* _tmp12_;
				gchar* _tmp13_;
				GraniteValidatedEntry* _tmp14_;
				const gchar* _tmp15_;
				if (!_tmp9_) {
					GMatchInfo* _tmp10_;
					_tmp10_ = self->priv->pattern;
					g_match_info_next (_tmp10_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
				}
				_tmp9_ = FALSE;
				_tmp11_ = self->priv->pattern;
				if (!g_match_info_matches (_tmp11_)) {
					break;
				}
				_tmp12_ = self->priv->pattern;
				_tmp13_ = g_match_info_fetch (_tmp12_, 0);
				_g_free0 (formatted_url);
				formatted_url = _tmp13_;
				_tmp14_ = self->priv->entry;
				_tmp15_ = formatted_url;
				gtk_editable_set_text ((GtkEditable*) _tmp14_, _tmp15_);
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = e->message;
		g_error ("InternetView.vala:163: Failed URL extraction using regex: %s", _tmp16_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (formatted_url);
		_g_free0 (url);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp17_ = formatted_url;
	if (_tmp17_ == NULL) {
		_g_free0 (formatted_url);
		_g_free0 (url);
		return;
	}
	_tmp18_ = formatted_url;
	pc_widgets_internet_box_add_entry (self, _tmp18_);
	pc_widgets_internet_box_update_block_urls (self);
	_g_free0 (formatted_url);
	_g_free0 (url);
}

static void
pc_widgets_internet_box_on_entry_changed (PCWidgetsInternetBox* self)
{
	GRegex* _tmp0_;
	gchar* entry_stripped_text = NULL;
	GraniteValidatedEntry* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean valid = FALSE;
	GRegex* _tmp4_;
	const gchar* _tmp5_;
	GtkButton* _tmp6_;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->url_regex;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->entry;
	_tmp2_ = gtk_editable_get_text ((GtkEditable*) _tmp1_);
	_tmp3_ = string_strip (_tmp2_);
	entry_stripped_text = _tmp3_;
	_tmp4_ = self->priv->url_regex;
	_tmp5_ = entry_stripped_text;
	valid = g_regex_match (_tmp4_, _tmp5_, 0, NULL);
	_tmp6_ = self->priv->add_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, valid);
	if (valid) {
		_tmp7_ = TRUE;
	} else {
		const gchar* _tmp8_;
		_tmp8_ = entry_stripped_text;
		_tmp7_ = g_strcmp0 (_tmp8_, "") == 0;
	}
	if (_tmp7_) {
		GraniteValidatedEntry* _tmp9_;
		GMatchInfo* _tmp10_;
		_tmp9_ = self->priv->entry;
		g_object_set ((GtkEntry*) _tmp9_, "secondary-icon-name", NULL, NULL);
		_tmp10_ = self->priv->pattern;
		if (_tmp10_ != NULL) {
			const gchar* _tmp11_;
			GMatchInfo* _tmp12_;
			const gchar* _tmp13_;
			_tmp11_ = entry_stripped_text;
			_tmp12_ = self->priv->pattern;
			_tmp13_ = g_match_info_get_string (_tmp12_);
			if (g_strcmp0 (_tmp11_, _tmp13_) == 0) {
				gchar* _tmp14_;
				GraniteValidatedEntry* _tmp15_;
				GtkButton* _tmp16_;
				_tmp14_ = g_strdup (_ ("The specified URL already exists in list"));
				_g_free0 (self->priv->entry_secondary_tooltip_text);
				self->priv->entry_secondary_tooltip_text = _tmp14_;
				_tmp15_ = self->priv->entry;
				g_object_set ((GtkEntry*) _tmp15_, "secondary-icon-name", "dialog-warning-symbolic", NULL);
				_tmp16_ = self->priv->add_button;
				gtk_widget_set_sensitive ((GtkWidget*) _tmp16_, FALSE);
			}
		}
	} else {
		gchar* _tmp17_;
		GraniteValidatedEntry* _tmp18_;
		_tmp17_ = g_strdup (_ ("Invalid URL"));
		_g_free0 (self->priv->entry_secondary_tooltip_text);
		self->priv->entry_secondary_tooltip_text = _tmp17_;
		_tmp18_ = self->priv->entry;
		g_object_set ((GtkEntry*) _tmp18_, "secondary-icon-name", "process-error-symbolic", NULL);
	}
	_g_free0 (entry_stripped_text);
}

static void
__lambda15_ (PCWidgetsInternetBox* self)
{
	pc_widgets_internet_box_update_block_urls (self);
}

static void
___lambda15__gtk_widget_destroy (GtkWidget* _sender,
                                 gpointer self)
{
	__lambda15_ ((PCWidgetsInternetBox*) self);
}

static void
pc_widgets_internet_box_add_entry (PCWidgetsInternetBox* self,
                                   const gchar* url)
{
	PCWidgetsInternetBoxUrlEntry* url_entry = NULL;
	PCWidgetsInternetBoxUrlEntry* _tmp0_;
	GtkListBox* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (url != NULL);
	_tmp0_ = pc_widgets_internet_box_url_entry_new (url);
	g_object_ref_sink (_tmp0_);
	url_entry = _tmp0_;
	g_signal_connect_object ((GtkWidget*) url_entry, "destroy", (GCallback) ___lambda15__gtk_widget_destroy, self, 0);
	_tmp1_ = self->priv->list_box;
	gtk_list_box_append (_tmp1_, (GtkWidget*) url_entry);
	_g_object_unref0 (url_entry);
}

ActUser*
pc_widgets_internet_box_get_user (PCWidgetsInternetBox* self)
{
	ActUser* result;
	ActUser* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_user;
	result = _tmp0_;
	return result;
}

static void
pc_widgets_internet_box_set_user (PCWidgetsInternetBox* self,
                                  ActUser* value)
{
	ActUser* old_value;
	g_return_if_fail (self != NULL);
	old_value = pc_widgets_internet_box_get_user (self);
	if (old_value != value) {
		self->priv->_user = value;
		g_object_notify_by_pspec ((GObject *) self, pc_widgets_internet_box_properties[PC_WIDGETS_INTERNET_BOX_USER_PROPERTY]);
	}
}

static inline gpointer
pc_widgets_internet_box_url_entry_get_instance_private (PCWidgetsInternetBoxUrlEntry* self)
{
	return G_STRUCT_MEMBER_P (self, PCWidgetsInternetBoxUrlEntry_private_offset);
}

static PCWidgetsInternetBoxUrlEntry*
pc_widgets_internet_box_url_entry_construct (GType object_type,
                                             const gchar* url)
{
	PCWidgetsInternetBoxUrlEntry * self = NULL;
	g_return_val_if_fail (url != NULL, NULL);
	self = (PCWidgetsInternetBoxUrlEntry*) g_object_new (object_type, "url", url, NULL);
	return self;
}

static PCWidgetsInternetBoxUrlEntry*
pc_widgets_internet_box_url_entry_new (const gchar* url)
{
	return pc_widgets_internet_box_url_entry_construct (PC_WIDGETS_INTERNET_BOX_TYPE_URL_ENTRY, url);
}

static const gchar*
pc_widgets_internet_box_url_entry_get_url (PCWidgetsInternetBoxUrlEntry* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_url;
	result = _tmp0_;
	return result;
}

static void
pc_widgets_internet_box_url_entry_set_url (PCWidgetsInternetBoxUrlEntry* self,
                                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = pc_widgets_internet_box_url_entry_get_url (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_url);
		self->priv->_url = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, pc_widgets_internet_box_url_entry_properties[PC_WIDGETS_INTERNET_BOX_URL_ENTRY_URL_PROPERTY]);
	}
}

static void
_pc_widgets_internet_box_url_entry___lambda14_ (PCWidgetsInternetBoxUrlEntry* self)
{
	gtk_widget_unparent ((GtkWidget*) self);
	g_signal_emit_by_name ((GtkWidget*) self, "destroy");
}

static void
__pc_widgets_internet_box_url_entry___lambda14__gtk_button_clicked (GtkButton* _sender,
                                                                    gpointer self)
{
	_pc_widgets_internet_box_url_entry___lambda14_ ((PCWidgetsInternetBoxUrlEntry*) self);
}

static GObject *
pc_widgets_internet_box_url_entry_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PCWidgetsInternetBoxUrlEntry * self;
	GtkButton* delete_button = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GtkButton* _tmp2_ = NULL;
	GtkButton* _tmp3_;
	GtkBox* main_box = NULL;
	GtkBox* _tmp4_ = NULL;
	GtkBox* _tmp5_;
	const gchar* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkBox* _tmp9_;
	GtkButton* _tmp10_;
	GtkBox* _tmp11_;
	parent_class = G_OBJECT_CLASS (pc_widgets_internet_box_url_entry_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PC_WIDGETS_INTERNET_BOX_TYPE_URL_ENTRY, PCWidgetsInternetBoxUrlEntry);
	_tmp0_ = self->priv->_url;
	_tmp1_ = g_strdup_printf (_ ("Unblock %s"), _tmp0_);
	_tmp2_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-delete-symbolic");
	gtk_widget_set_halign ((GtkWidget*) _tmp2_, GTK_ALIGN_END);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp2_, TRUE);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp2_, _tmp1_);
	_g_free0 (_tmp1_);
	g_object_ref_sink (_tmp2_);
	delete_button = _tmp2_;
	_tmp3_ = delete_button;
	g_signal_connect_object (_tmp3_, "clicked", (GCallback) __pc_widgets_internet_box_url_entry___lambda14__gtk_button_clicked, self, 0);
	_tmp4_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp4_, 6);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp4_, 6);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp4_, 6);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp4_, 6);
	g_object_ref_sink (_tmp4_);
	main_box = _tmp4_;
	_tmp5_ = main_box;
	_tmp6_ = self->priv->_url;
	_tmp7_ = (GtkLabel*) gtk_label_new (_tmp6_);
	g_object_ref_sink (_tmp7_);
	_tmp8_ = _tmp7_;
	gtk_box_append (_tmp5_, (GtkWidget*) _tmp8_);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = main_box;
	_tmp10_ = delete_button;
	gtk_box_append (_tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = main_box;
	gtk_list_box_row_set_child ((GtkListBoxRow*) self, (GtkWidget*) _tmp11_);
	_g_object_unref0 (main_box);
	_g_object_unref0 (delete_button);
	return obj;
}

static void
pc_widgets_internet_box_url_entry_class_init (PCWidgetsInternetBoxUrlEntryClass * klass,
                                              gpointer klass_data)
{
	pc_widgets_internet_box_url_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PCWidgetsInternetBoxUrlEntry_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_pc_widgets_internet_box_url_entry_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pc_widgets_internet_box_url_entry_set_property;
	G_OBJECT_CLASS (klass)->constructor = pc_widgets_internet_box_url_entry_constructor;
	G_OBJECT_CLASS (klass)->finalize = pc_widgets_internet_box_url_entry_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PC_WIDGETS_INTERNET_BOX_URL_ENTRY_URL_PROPERTY, pc_widgets_internet_box_url_entry_properties[PC_WIDGETS_INTERNET_BOX_URL_ENTRY_URL_PROPERTY] = g_param_spec_string ("url", "url", "url", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
pc_widgets_internet_box_url_entry_instance_init (PCWidgetsInternetBoxUrlEntry * self,
                                                 gpointer klass)
{
	self->priv = pc_widgets_internet_box_url_entry_get_instance_private (self);
}

static void
pc_widgets_internet_box_url_entry_finalize (GObject * obj)
{
	PCWidgetsInternetBoxUrlEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PC_WIDGETS_INTERNET_BOX_TYPE_URL_ENTRY, PCWidgetsInternetBoxUrlEntry);
	_g_free0 (self->priv->_url);
	G_OBJECT_CLASS (pc_widgets_internet_box_url_entry_parent_class)->finalize (obj);
}

static GType
pc_widgets_internet_box_url_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PCWidgetsInternetBoxUrlEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pc_widgets_internet_box_url_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PCWidgetsInternetBoxUrlEntry), 0, (GInstanceInitFunc) pc_widgets_internet_box_url_entry_instance_init, NULL };
	GType pc_widgets_internet_box_url_entry_type_id;
	pc_widgets_internet_box_url_entry_type_id = g_type_register_static (gtk_list_box_row_get_type (), "PCWidgetsInternetBoxUrlEntry", &g_define_type_info, 0);
	PCWidgetsInternetBoxUrlEntry_private_offset = g_type_add_instance_private (pc_widgets_internet_box_url_entry_type_id, sizeof (PCWidgetsInternetBoxUrlEntryPrivate));
	return pc_widgets_internet_box_url_entry_type_id;
}

static GType
pc_widgets_internet_box_url_entry_get_type (void)
{
	static volatile gsize pc_widgets_internet_box_url_entry_type_id__once = 0;
	if (g_once_init_enter (&pc_widgets_internet_box_url_entry_type_id__once)) {
		GType pc_widgets_internet_box_url_entry_type_id;
		pc_widgets_internet_box_url_entry_type_id = pc_widgets_internet_box_url_entry_get_type_once ();
		g_once_init_leave (&pc_widgets_internet_box_url_entry_type_id__once, pc_widgets_internet_box_url_entry_type_id);
	}
	return pc_widgets_internet_box_url_entry_type_id__once;
}

static void
_vala_pc_widgets_internet_box_url_entry_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec)
{
	PCWidgetsInternetBoxUrlEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PC_WIDGETS_INTERNET_BOX_TYPE_URL_ENTRY, PCWidgetsInternetBoxUrlEntry);
	switch (property_id) {
		case PC_WIDGETS_INTERNET_BOX_URL_ENTRY_URL_PROPERTY:
		g_value_set_string (value, pc_widgets_internet_box_url_entry_get_url (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_pc_widgets_internet_box_url_entry_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec)
{
	PCWidgetsInternetBoxUrlEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PC_WIDGETS_INTERNET_BOX_TYPE_URL_ENTRY, PCWidgetsInternetBoxUrlEntry);
	switch (property_id) {
		case PC_WIDGETS_INTERNET_BOX_URL_ENTRY_URL_PROPERTY:
		pc_widgets_internet_box_url_entry_set_url (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_pc_widgets_internet_box_on_entry_activate_gtk_button_clicked (GtkButton* _sender,
                                                               gpointer self)
{
	pc_widgets_internet_box_on_entry_activate ((PCWidgetsInternetBox*) self);
}

static void
_pc_widgets_internet_box___lambda16_ (PCWidgetsInternetBox* self)
{
	GraniteValidatedEntry* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_tmp0_ = self->priv->entry;
	_tmp1_ = granite_validated_entry_get_is_valid (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GraniteValidatedEntry* _tmp3_;
		_tmp3_ = self->priv->entry;
		g_object_set ((GtkEntry*) _tmp3_, "secondary-icon-tooltip-text", NULL, NULL);
	} else {
		GraniteValidatedEntry* _tmp4_;
		_tmp4_ = self->priv->entry;
		g_object_set ((GtkEntry*) _tmp4_, "secondary-icon-tooltip-text", _ ("Invalid URL"), NULL);
	}
}

static void
__pc_widgets_internet_box___lambda16__g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self)
{
	_pc_widgets_internet_box___lambda16_ ((PCWidgetsInternetBox*) self);
}

static void
_pc_widgets_internet_box___lambda17_ (PCWidgetsInternetBox* self)
{
	GraniteValidatedEntry* _tmp0_;
	const gchar* _tmp1_;
	pc_widgets_internet_box_on_entry_changed (self);
	_tmp0_ = self->priv->entry;
	_tmp1_ = self->priv->entry_secondary_tooltip_text;
	gtk_entry_set_icon_tooltip_text ((GtkEntry*) _tmp0_, GTK_ENTRY_ICON_SECONDARY, _tmp1_);
}

static void
__pc_widgets_internet_box___lambda17__gtk_editable_changed (GtkEditable* _sender,
                                                            gpointer self)
{
	_pc_widgets_internet_box___lambda17_ ((PCWidgetsInternetBox*) self);
}

static void
_pc_widgets_internet_box_on_entry_activate_gtk_entry_activate (GtkEntry* _sender,
                                                               gpointer self)
{
	pc_widgets_internet_box_on_entry_activate ((PCWidgetsInternetBox*) self);
}

static GObject *
pc_widgets_internet_box_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PCWidgetsInternetBox * self;
	GraniteHeaderLabel* info_label = NULL;
	GraniteHeaderLabel* _tmp5_;
	GtkListBox* _tmp6_ = NULL;
	GtkScrolledWindow* scrolled = NULL;
	GtkListBox* _tmp7_;
	GtkWidget* _tmp8_;
	GtkScrolledWindow* _tmp9_ = NULL;
	GtkButton* _tmp10_ = NULL;
	GtkButton* _tmp11_;
	GtkButton* _tmp12_;
	GRegex* _tmp13_;
	gchar* _tmp14_;
	GraniteValidatedEntry* _tmp15_ = NULL;
	GtkGrid* main_box = NULL;
	GtkGrid* _tmp16_ = NULL;
	GtkGrid* _tmp17_;
	GtkScrolledWindow* _tmp18_;
	GtkGrid* _tmp19_;
	GtkSeparator* _tmp20_;
	GtkSeparator* _tmp21_;
	GtkGrid* _tmp22_;
	GraniteValidatedEntry* _tmp23_;
	GtkGrid* _tmp24_;
	GtkButton* _tmp25_;
	GtkFrame* frame = NULL;
	GtkGrid* _tmp26_;
	GtkWidget* _tmp27_;
	GtkFrame* _tmp28_ = NULL;
	GtkFrame* _tmp29_;
	GraniteHeaderLabel* _tmp30_;
	GtkFrame* _tmp31_;
	GraniteValidatedEntry* _tmp32_;
	GtkButton* _tmp33_;
	GraniteValidatedEntry* _tmp34_;
	GraniteValidatedEntry* _tmp35_;
	GraniteValidatedEntry* _tmp36_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (pc_widgets_internet_box_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PC_WIDGETS_TYPE_INTERNET_BOX, PCWidgetsInternetBox);
	{
		GRegex* _tmp0_ = NULL;
		GRegex* _tmp1_;
		GRegex* _tmp2_;
		_tmp1_ = g_regex_new (PC_WIDGETS_INTERNET_BOX_URL_REGEX, G_REGEX_OPTIMIZE, 0, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_regex_unref0 (self->priv->url_regex);
		self->priv->url_regex = _tmp2_;
		_g_regex_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("InternetView.vala:26: %s\n", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp5_ = granite_header_label_new (_ ("Blocked Websites"));
	g_object_ref_sink (_tmp5_);
	info_label = _tmp5_;
	_tmp6_ = (GtkListBox*) gtk_list_box_new ();
	gtk_list_box_set_selection_mode (_tmp6_, GTK_SELECTION_NONE);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->list_box);
	self->priv->list_box = _tmp6_;
	_tmp7_ = self->priv->list_box;
	_tmp8_ = _g_object_ref0 ((GtkWidget*) _tmp7_);
	_tmp9_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	gtk_scrolled_window_set_child (_tmp9_, _tmp8_);
	_g_object_unref0 (_tmp8_);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp9_, TRUE);
	g_object_ref_sink (_tmp9_);
	scrolled = _tmp9_;
	_tmp10_ = (GtkButton*) gtk_button_new_with_label (_ ("Block URL"));
	gtk_widget_set_margin_end ((GtkWidget*) _tmp10_, 6);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp10_, FALSE);
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->add_button);
	self->priv->add_button = _tmp10_;
	_tmp11_ = self->priv->add_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp11_, GRANITE_STYLE_CLASS_SUGGESTED_ACTION);
	_tmp12_ = self->priv->add_button;
	g_signal_connect_object (_tmp12_, "clicked", (GCallback) _pc_widgets_internet_box_on_entry_activate_gtk_button_clicked, self, 0);
	_tmp13_ = self->priv->url_regex;
	_tmp14_ = g_strdup (_ ("example.com"));
	_tmp15_ = granite_validated_entry_new_from_regex (_tmp13_);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp15_, TRUE);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp15_, 6);
	gtk_entry_set_placeholder_text ((GtkEntry*) _tmp15_, _tmp14_);
	_g_free0 (_tmp14_);
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->entry);
	self->priv->entry = _tmp15_;
	_tmp16_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp16_, 6);
	gtk_grid_set_row_spacing (_tmp16_, 6);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp16_, 6);
	g_object_ref_sink (_tmp16_);
	main_box = _tmp16_;
	_tmp17_ = main_box;
	_tmp18_ = scrolled;
	gtk_grid_attach (_tmp17_, (GtkWidget*) _tmp18_, 0, 0, 2, 1);
	_tmp19_ = main_box;
	_tmp20_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp20_);
	_tmp21_ = _tmp20_;
	gtk_grid_attach (_tmp19_, (GtkWidget*) _tmp21_, 0, 1, 2, 1);
	_g_object_unref0 (_tmp21_);
	_tmp22_ = main_box;
	_tmp23_ = self->priv->entry;
	gtk_grid_attach (_tmp22_, (GtkWidget*) _tmp23_, 0, 3, 1, 1);
	_tmp24_ = main_box;
	_tmp25_ = self->priv->add_button;
	gtk_grid_attach (_tmp24_, (GtkWidget*) _tmp25_, 1, 3, 1, 1);
	_tmp26_ = main_box;
	_tmp27_ = _g_object_ref0 ((GtkWidget*) _tmp26_);
	_tmp28_ = (GtkFrame*) gtk_frame_new (NULL);
	gtk_frame_set_child (_tmp28_, _tmp27_);
	_g_object_unref0 (_tmp27_);
	g_object_ref_sink (_tmp28_);
	frame = _tmp28_;
	_tmp29_ = frame;
	gtk_widget_add_css_class ((GtkWidget*) _tmp29_, GRANITE_STYLE_CLASS_VIEW);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	gtk_box_set_spacing ((GtkBox*) self, 6);
	_tmp30_ = info_label;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp30_);
	_tmp31_ = frame;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp31_);
	pc_widgets_internet_box_load_existing (self, NULL, NULL);
	_tmp32_ = self->priv->entry;
	_tmp33_ = self->priv->add_button;
	g_object_bind_property_with_closures ((GObject*) _tmp32_, "is-valid", (GObject*) _tmp33_, "sensitive", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp34_ = self->priv->entry;
	g_signal_connect_object ((GObject*) _tmp34_, "notify::is-valid", (GCallback) __pc_widgets_internet_box___lambda16__g_object_notify, self, 0);
	_tmp35_ = self->priv->entry;
	g_signal_connect_object ((GtkEditable*) _tmp35_, "changed", (GCallback) __pc_widgets_internet_box___lambda17__gtk_editable_changed, self, 0);
	_tmp36_ = self->priv->entry;
	g_signal_connect_object ((GtkEntry*) _tmp36_, "activate", (GCallback) _pc_widgets_internet_box_on_entry_activate_gtk_entry_activate, self, 0);
	_g_object_unref0 (frame);
	_g_object_unref0 (main_box);
	_g_object_unref0 (scrolled);
	_g_object_unref0 (info_label);
	return obj;
}

static void
pc_widgets_internet_box_class_init (PCWidgetsInternetBoxClass * klass,
                                    gpointer klass_data)
{
	pc_widgets_internet_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PCWidgetsInternetBox_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_pc_widgets_internet_box_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pc_widgets_internet_box_set_property;
	G_OBJECT_CLASS (klass)->constructor = pc_widgets_internet_box_constructor;
	G_OBJECT_CLASS (klass)->finalize = pc_widgets_internet_box_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PC_WIDGETS_INTERNET_BOX_USER_PROPERTY, pc_widgets_internet_box_properties[PC_WIDGETS_INTERNET_BOX_USER_PROPERTY] = g_param_spec_object ("user", "user", "user", act_user_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
pc_widgets_internet_box_instance_init (PCWidgetsInternetBox * self,
                                       gpointer klass)
{
	self->priv = pc_widgets_internet_box_get_instance_private (self);
	self->priv->entry_secondary_tooltip_text = NULL;
	self->priv->pattern = NULL;
	self->priv->url_regex = NULL;
}

static void
pc_widgets_internet_box_finalize (GObject * obj)
{
	PCWidgetsInternetBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PC_WIDGETS_TYPE_INTERNET_BOX, PCWidgetsInternetBox);
	_g_free0 (self->priv->entry_secondary_tooltip_text);
	_g_match_info_unref0 (self->priv->pattern);
	_g_regex_unref0 (self->priv->url_regex);
	_g_object_unref0 (self->priv->list_box);
	_g_object_unref0 (self->priv->entry);
	_g_object_unref0 (self->priv->add_button);
	G_OBJECT_CLASS (pc_widgets_internet_box_parent_class)->finalize (obj);
}

static GType
pc_widgets_internet_box_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PCWidgetsInternetBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pc_widgets_internet_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PCWidgetsInternetBox), 0, (GInstanceInitFunc) pc_widgets_internet_box_instance_init, NULL };
	GType pc_widgets_internet_box_type_id;
	pc_widgets_internet_box_type_id = g_type_register_static (gtk_box_get_type (), "PCWidgetsInternetBox", &g_define_type_info, 0);
	PCWidgetsInternetBox_private_offset = g_type_add_instance_private (pc_widgets_internet_box_type_id, sizeof (PCWidgetsInternetBoxPrivate));
	return pc_widgets_internet_box_type_id;
}

GType
pc_widgets_internet_box_get_type (void)
{
	static volatile gsize pc_widgets_internet_box_type_id__once = 0;
	if (g_once_init_enter (&pc_widgets_internet_box_type_id__once)) {
		GType pc_widgets_internet_box_type_id;
		pc_widgets_internet_box_type_id = pc_widgets_internet_box_get_type_once ();
		g_once_init_leave (&pc_widgets_internet_box_type_id__once, pc_widgets_internet_box_type_id);
	}
	return pc_widgets_internet_box_type_id__once;
}

static void
_vala_pc_widgets_internet_box_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	PCWidgetsInternetBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PC_WIDGETS_TYPE_INTERNET_BOX, PCWidgetsInternetBox);
	switch (property_id) {
		case PC_WIDGETS_INTERNET_BOX_USER_PROPERTY:
		g_value_set_object (value, pc_widgets_internet_box_get_user (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_pc_widgets_internet_box_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	PCWidgetsInternetBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PC_WIDGETS_TYPE_INTERNET_BOX, PCWidgetsInternetBox);
	switch (property_id) {
		case PC_WIDGETS_INTERNET_BOX_USER_PROPERTY:
		pc_widgets_internet_box_set_user (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

