/* Plug.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Plug.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-2.0-or-later
 * SPDX-FileCopyrightText: 2011-2023 elementary, Inc. (https://elementary.io)
 */

#include "io.elementary.settings.sharing.h"
#include <gtk/gtk.h>
#include <switchboard.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <granite-7.h>
#include <adwaita.h>
#include <gmodule.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SHARING_PLUG_0_PROPERTY,
	SHARING_PLUG_NUM_PROPERTIES
};
static GParamSpec* sharing_plug_properties[SHARING_PLUG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
typedef struct _SharingPlugSearchData SharingPlugSearchData;

struct _SharingPlugPrivate {
	GtkStack* content;
};

struct _SharingPlugSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SharingPlug* self;
	gchar* search;
	GeeTreeMap* result;
	GeeTreeMap* search_results;
	GCompareFunc _tmp0_;
	GEqualFunc _tmp1_;
	GeeTreeMap* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
};

static gint SharingPlug_private_offset;
static gpointer sharing_plug_parent_class = NULL;

static GtkWidget* sharing_plug_real_get_widget (SwitchboardPlug* base);
static void ___lambda11_ (SharingPlug* self);
static void sharing_plug_update_content_view (SharingPlug* self);
static void ____lambda11__g_network_monitor_network_changed (GNetworkMonitor* _sender,
                                                      gboolean network_available,
                                                      gpointer self);
static void sharing_plug_real_shown (SwitchboardPlug* base);
static void sharing_plug_real_hidden (SwitchboardPlug* base);
static void sharing_plug_real_search_callback (SwitchboardPlug* base,
                                        const gchar* location);
static void sharing_plug_real_search_data_free (gpointer _data);
static void sharing_plug_real_search (SwitchboardPlug* base,
                               const gchar* search,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_);
static gboolean sharing_plug_real_search_co (SharingPlugSearchData* _data_);
static void sharing_plug_finalize (GObject * obj);
static GType sharing_plug_get_type_once (void);

static inline gpointer
sharing_plug_get_instance_private (SharingPlug* self)
{
	return G_STRUCT_MEMBER_P (self, SharingPlug_private_offset);
}

SharingPlug*
sharing_plug_construct (GType object_type)
{
	SharingPlug * self = NULL;
	GeeTreeMap* settings = NULL;
	GeeTreeMap* _tmp0_;
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	_tmp0_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	settings = _tmp0_;
	gee_abstract_map_set ((GeeAbstractMap*) settings, "network/share", NULL);
	self = (SharingPlug*) g_object_new (object_type, "category", SWITCHBOARD_PLUG_CATEGORY_NETWORK, "code-name", "io.elementary.settings.sharing", "display-name", _ ("Sharing"), "description", _ ("Configure file and media sharing"), "icon", "preferences-system-sharing", "supported-settings", settings, NULL);
	_g_object_unref0 (settings);
	return self;
}

SharingPlug*
sharing_plug_new (void)
{
	return sharing_plug_construct (SHARING_TYPE_PLUG);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
___lambda11_ (SharingPlug* self)
{
	sharing_plug_update_content_view (self);
}

static void
____lambda11__g_network_monitor_network_changed (GNetworkMonitor* _sender,
                                                 gboolean network_available,
                                                 gpointer self)
{
	___lambda11_ ((SharingPlug*) self);
}

static GtkWidget*
sharing_plug_real_get_widget (SwitchboardPlug* base)
{
	SharingPlug * self;
	GtkStack* _tmp0_;
	GtkStack* _tmp47_;
	GtkWidget* _tmp48_;
	GtkWidget* result;
	self = (SharingPlug*) base;
	_tmp0_ = self->priv->content;
	if (_tmp0_ == NULL) {
		GranitePlaceholder* network_alert_view = NULL;
		GThemedIcon* _tmp1_;
		gchar* _tmp2_;
		GranitePlaceholder* _tmp3_ = NULL;
		GranitePlaceholder* _tmp4_;
		GtkLinkButton* link_button = NULL;
		GtkLinkButton* _tmp5_;
		GtkLinkButton* _tmp6_;
		GtkLinkButton* _tmp7_;
		GtkGrid* network_grid_view = NULL;
		GtkGrid* _tmp8_ = NULL;
		GtkGrid* _tmp9_;
		GranitePlaceholder* _tmp10_;
		GtkGrid* _tmp11_;
		GtkLinkButton* _tmp12_;
		AdwHeaderBar* headerbar = NULL;
		AdwHeaderBar* _tmp13_ = NULL;
		AdwToolbarView* toolbarview = NULL;
		GtkGrid* _tmp14_;
		GtkWidget* _tmp15_;
		AdwToolbarView* _tmp16_ = NULL;
		AdwToolbarView* _tmp17_;
		AdwHeaderBar* _tmp18_;
		SharingWidgetsDLNAPage* dlna_page = NULL;
		SharingWidgetsDLNAPage* _tmp19_;
		SharingWidgetsBluetoothPage* bluetooth_page = NULL;
		SharingWidgetsBluetoothPage* _tmp20_;
		GtkStack* settings_view = NULL;
		GtkStack* _tmp21_;
		GtkStack* _tmp22_;
		SharingWidgetsDLNAPage* _tmp23_;
		GtkStack* _tmp24_;
		SharingWidgetsBluetoothPage* _tmp25_;
		SwitchboardSettingsSidebar* sidebar = NULL;
		GtkStack* _tmp26_;
		SwitchboardSettingsSidebar* _tmp27_ = NULL;
		GtkPaned* main_container = NULL;
		SwitchboardSettingsSidebar* _tmp28_;
		GtkWidget* _tmp29_;
		GtkStack* _tmp30_;
		GtkWidget* _tmp31_;
		GtkPaned* _tmp32_ = NULL;
		GSettingsSchema* sss = NULL;
		GSettingsSchemaSource* _tmp33_;
		GSettingsSchema* _tmp34_;
		gboolean _tmp35_ = FALSE;
		GSettingsSchema* _tmp36_;
		GtkStack* _tmp41_;
		GtkStack* _tmp42_;
		GtkPaned* _tmp43_;
		GtkStack* _tmp44_;
		AdwToolbarView* _tmp45_;
		GNetworkMonitor* _tmp46_;
		_tmp1_ = (GThemedIcon*) g_themed_icon_new ("network-error");
		_tmp2_ = g_strdup (_ ("While disconnected from the network, sharing services are not availabl" \
"e."));
		_tmp3_ = granite_placeholder_new (_ ("Network Is Not Available"));
		granite_placeholder_set_icon (_tmp3_, (GIcon*) _tmp1_);
		_g_object_unref0 (_tmp1_);
		granite_placeholder_set_description (_tmp3_, _tmp2_);
		_g_free0 (_tmp2_);
		gtk_widget_set_vexpand ((GtkWidget*) _tmp3_, TRUE);
		gtk_widget_set_hexpand ((GtkWidget*) _tmp3_, TRUE);
		g_object_ref_sink (_tmp3_);
		network_alert_view = _tmp3_;
		_tmp4_ = network_alert_view;
		gtk_widget_remove_css_class ((GtkWidget*) _tmp4_, GRANITE_STYLE_CLASS_VIEW);
		_tmp5_ = (GtkLinkButton*) gtk_link_button_new_with_label ("settings://network", _ ("Network settings…"));
		g_object_ref_sink (_tmp5_);
		link_button = _tmp5_;
		_tmp6_ = link_button;
		gtk_widget_set_halign ((GtkWidget*) _tmp6_, GTK_ALIGN_END);
		_tmp7_ = link_button;
		gtk_widget_set_valign ((GtkWidget*) _tmp7_, GTK_ALIGN_END);
		_tmp8_ = (GtkGrid*) gtk_grid_new ();
		gtk_widget_set_margin_top ((GtkWidget*) _tmp8_, 12);
		gtk_widget_set_margin_end ((GtkWidget*) _tmp8_, 12);
		gtk_widget_set_margin_start ((GtkWidget*) _tmp8_, 12);
		gtk_widget_set_margin_bottom ((GtkWidget*) _tmp8_, 12);
		g_object_ref_sink (_tmp8_);
		network_grid_view = _tmp8_;
		_tmp9_ = network_grid_view;
		_tmp10_ = network_alert_view;
		gtk_grid_attach (_tmp9_, (GtkWidget*) _tmp10_, 0, 0, 1, 1);
		_tmp11_ = network_grid_view;
		_tmp12_ = link_button;
		gtk_grid_attach (_tmp11_, (GtkWidget*) _tmp12_, 0, 1, 1, 1);
		_tmp13_ = (AdwHeaderBar*) adw_header_bar_new ();
		adw_header_bar_set_show_title (_tmp13_, FALSE);
		adw_header_bar_set_show_end_title_buttons (_tmp13_, TRUE);
		adw_header_bar_set_show_start_title_buttons (_tmp13_, TRUE);
		g_object_ref_sink (_tmp13_);
		headerbar = _tmp13_;
		_tmp14_ = network_grid_view;
		_tmp15_ = _g_object_ref0 ((GtkWidget*) _tmp14_);
		_tmp16_ = (AdwToolbarView*) adw_toolbar_view_new ();
		adw_toolbar_view_set_content (_tmp16_, _tmp15_);
		_g_object_unref0 (_tmp15_);
		adw_toolbar_view_set_top_bar_style (_tmp16_, ADW_TOOLBAR_FLAT);
		g_object_ref_sink (_tmp16_);
		toolbarview = _tmp16_;
		_tmp17_ = toolbarview;
		_tmp18_ = headerbar;
		adw_toolbar_view_add_top_bar (_tmp17_, (GtkWidget*) _tmp18_);
		_tmp19_ = sharing_widgets_dlna_page_new ();
		g_object_ref_sink (_tmp19_);
		dlna_page = _tmp19_;
		_tmp20_ = sharing_widgets_bluetooth_page_new ();
		g_object_ref_sink (_tmp20_);
		bluetooth_page = _tmp20_;
		_tmp21_ = (GtkStack*) gtk_stack_new ();
		g_object_ref_sink (_tmp21_);
		settings_view = _tmp21_;
		_tmp22_ = settings_view;
		_tmp23_ = dlna_page;
		gtk_stack_add_child (_tmp22_, (GtkWidget*) _tmp23_);
		_tmp24_ = settings_view;
		_tmp25_ = bluetooth_page;
		gtk_stack_add_child (_tmp24_, (GtkWidget*) _tmp25_);
		_tmp26_ = settings_view;
		_tmp27_ = switchboard_settings_sidebar_new (_tmp26_);
		switchboard_settings_sidebar_set_show_title_buttons (_tmp27_, TRUE);
		g_object_ref_sink (_tmp27_);
		sidebar = _tmp27_;
		_tmp28_ = sidebar;
		_tmp29_ = _g_object_ref0 ((GtkWidget*) _tmp28_);
		_tmp30_ = settings_view;
		_tmp31_ = _g_object_ref0 ((GtkWidget*) _tmp30_);
		_tmp32_ = (GtkPaned*) gtk_paned_new (GTK_ORIENTATION_HORIZONTAL);
		gtk_paned_set_start_child (_tmp32_, _tmp29_);
		_g_object_unref0 (_tmp29_);
		gtk_paned_set_end_child (_tmp32_, _tmp31_);
		_g_object_unref0 (_tmp31_);
		gtk_paned_set_resize_start_child (_tmp32_, FALSE);
		gtk_paned_set_shrink_end_child (_tmp32_, FALSE);
		gtk_paned_set_shrink_start_child (_tmp32_, FALSE);
		g_object_ref_sink (_tmp32_);
		main_container = _tmp32_;
		_tmp33_ = g_settings_schema_source_get_default ();
		_tmp34_ = g_settings_schema_source_lookup (_tmp33_, "io.elementary.settings", TRUE);
		sss = _tmp34_;
		_tmp36_ = sss;
		if (_tmp36_ != NULL) {
			GSettingsSchema* _tmp37_;
			_tmp37_ = sss;
			_tmp35_ = g_settings_schema_has_key (_tmp37_, "sidebar-position");
		} else {
			_tmp35_ = FALSE;
		}
		if (_tmp35_) {
			GSettings* settings = NULL;
			GSettings* _tmp38_;
			GSettings* _tmp39_;
			GtkPaned* _tmp40_;
			_tmp38_ = g_settings_new ("io.elementary.settings");
			settings = _tmp38_;
			_tmp39_ = settings;
			_tmp40_ = main_container;
			g_settings_bind (_tmp39_, "sidebar-position", (GObject*) _tmp40_, "position", G_SETTINGS_BIND_DEFAULT);
			_g_object_unref0 (settings);
		}
		_tmp41_ = (GtkStack*) gtk_stack_new ();
		g_object_ref_sink (_tmp41_);
		_g_object_unref0 (self->priv->content);
		self->priv->content = _tmp41_;
		_tmp42_ = self->priv->content;
		_tmp43_ = main_container;
		gtk_stack_add_named (_tmp42_, (GtkWidget*) _tmp43_, "main-container");
		_tmp44_ = self->priv->content;
		_tmp45_ = toolbarview;
		gtk_stack_add_named (_tmp44_, (GtkWidget*) _tmp45_, "network-alert-view");
		_tmp46_ = g_network_monitor_get_default ();
		g_signal_connect_object (_tmp46_, "network-changed", (GCallback) ____lambda11__g_network_monitor_network_changed, self, 0);
		sharing_plug_update_content_view (self);
		_g_settings_schema_unref0 (sss);
		_g_object_unref0 (main_container);
		_g_object_unref0 (sidebar);
		_g_object_unref0 (settings_view);
		_g_object_unref0 (bluetooth_page);
		_g_object_unref0 (dlna_page);
		_g_object_unref0 (toolbarview);
		_g_object_unref0 (headerbar);
		_g_object_unref0 (network_grid_view);
		_g_object_unref0 (link_button);
		_g_object_unref0 (network_alert_view);
	}
	_tmp47_ = self->priv->content;
	_tmp48_ = _g_object_ref0 ((GtkWidget*) _tmp47_);
	result = _tmp48_;
	return result;
}

static void
sharing_plug_real_shown (SwitchboardPlug* base)
{
	SharingPlug * self;
	self = (SharingPlug*) base;
}

static void
sharing_plug_real_hidden (SwitchboardPlug* base)
{
	SharingPlug * self;
	self = (SharingPlug*) base;
}

static void
sharing_plug_real_search_callback (SwitchboardPlug* base,
                                   const gchar* location)
{
	SharingPlug * self;
	self = (SharingPlug*) base;
	g_return_if_fail (location != NULL);
}

static void
sharing_plug_real_search_data_free (gpointer _data)
{
	SharingPlugSearchData* _data_;
	_data_ = _data;
	_g_free0 (_data_->search);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (SharingPlugSearchData, _data_);
}

static void
sharing_plug_real_search (SwitchboardPlug* base,
                          const gchar* search,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_)
{
	SharingPlug * self;
	SharingPlugSearchData* _data_;
	SharingPlug* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (search != NULL);
	self = (SharingPlug*) base;
	_data_ = g_slice_new0 (SharingPlugSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, sharing_plug_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (search);
	_g_free0 (_data_->search);
	_data_->search = _tmp1_;
	sharing_plug_real_search_co (_data_);
}

static GeeTreeMap*
sharing_plug_search_finish (SwitchboardPlug* base,
                            GAsyncResult* _res_)
{
	GeeTreeMap* result;
	SharingPlugSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
sharing_plug_real_search_co (SharingPlugSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = ((GCompareFunc) g_strcmp0);
	_data_->_tmp1_ = g_str_equal;
	_data_->_tmp2_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, (GCompareDataFunc) _data_->_tmp0_, NULL, NULL, (GeeEqualDataFunc) _data_->_tmp1_, NULL, NULL);
	_data_->search_results = _data_->_tmp2_;
	_data_->_tmp3_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = g_strdup_printf ("%s → %s", _data_->_tmp4_, _ ("Media Streaming"));
	_data_->_tmp6_ = _data_->_tmp5_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp6_, "");
	_g_free0 (_data_->_tmp6_);
	_data_->_tmp7_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = g_strdup_printf ("%s → %s", _data_->_tmp8_, _ ("DLNA and UPnP"));
	_data_->_tmp10_ = _data_->_tmp9_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp10_, "");
	_g_free0 (_data_->_tmp10_);
	_data_->_tmp11_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp12_ = _data_->_tmp11_;
	_data_->_tmp13_ = g_strdup_printf ("%s → %s", _data_->_tmp12_, _ ("Bluetooth"));
	_data_->_tmp14_ = _data_->_tmp13_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp14_, "");
	_g_free0 (_data_->_tmp14_);
	_data_->result = _data_->search_results;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
sharing_plug_update_content_view (SharingPlug* self)
{
	gboolean _tmp0_ = FALSE;
	GNetworkMonitor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = g_network_monitor_get_default ();
	if (g_network_monitor_get_network_available (_tmp1_)) {
		_tmp0_ = TRUE;
	} else {
		GNetworkMonitor* _tmp2_;
		_tmp2_ = g_network_monitor_get_default ();
		_tmp0_ = g_network_monitor_get_network_metered (_tmp2_);
	}
	if (_tmp0_) {
		GtkStack* _tmp3_;
		_tmp3_ = self->priv->content;
		gtk_stack_set_visible_child_name (_tmp3_, "main-container");
	} else {
		GtkStack* _tmp4_;
		_tmp4_ = self->priv->content;
		gtk_stack_set_visible_child_name (_tmp4_, "network-alert-view");
	}
}

static void
sharing_plug_class_init (SharingPlugClass * klass,
                         gpointer klass_data)
{
	sharing_plug_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SharingPlug_private_offset);
	((SwitchboardPlugClass *) klass)->get_widget = (GtkWidget* (*) (SwitchboardPlug*)) sharing_plug_real_get_widget;
	((SwitchboardPlugClass *) klass)->shown = (void (*) (SwitchboardPlug*)) sharing_plug_real_shown;
	((SwitchboardPlugClass *) klass)->hidden = (void (*) (SwitchboardPlug*)) sharing_plug_real_hidden;
	((SwitchboardPlugClass *) klass)->search_callback = (void (*) (SwitchboardPlug*, const gchar*)) sharing_plug_real_search_callback;
	((SwitchboardPlugClass *) klass)->search = (void (*) (SwitchboardPlug*, const gchar*, GAsyncReadyCallback, gpointer)) sharing_plug_real_search;
	((SwitchboardPlugClass *) klass)->search_finish = (GeeTreeMap* (*) (SwitchboardPlug*, GAsyncResult*)) sharing_plug_search_finish;
	G_OBJECT_CLASS (klass)->finalize = sharing_plug_finalize;
}

static void
sharing_plug_instance_init (SharingPlug * self,
                            gpointer klass)
{
	self->priv = sharing_plug_get_instance_private (self);
	self->priv->content = NULL;
}

static void
sharing_plug_finalize (GObject * obj)
{
	SharingPlug * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SHARING_TYPE_PLUG, SharingPlug);
	_g_object_unref0 (self->priv->content);
	G_OBJECT_CLASS (sharing_plug_parent_class)->finalize (obj);
}

static GType
sharing_plug_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SharingPlugClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sharing_plug_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SharingPlug), 0, (GInstanceInitFunc) sharing_plug_instance_init, NULL };
	GType sharing_plug_type_id;
	sharing_plug_type_id = g_type_register_static (SWITCHBOARD_TYPE_PLUG, "SharingPlug", &g_define_type_info, 0);
	SharingPlug_private_offset = g_type_add_instance_private (sharing_plug_type_id, sizeof (SharingPlugPrivate));
	return sharing_plug_type_id;
}

GType
sharing_plug_get_type (void)
{
	static volatile gsize sharing_plug_type_id__once = 0;
	if (g_once_init_enter (&sharing_plug_type_id__once)) {
		GType sharing_plug_type_id;
		sharing_plug_type_id = sharing_plug_get_type_once ();
		g_once_init_leave (&sharing_plug_type_id__once, sharing_plug_type_id);
	}
	return sharing_plug_type_id__once;
}

SwitchboardPlug*
get_plug (GModule* module)
{
	SharingPlug* plug = NULL;
	SharingPlug* _tmp0_;
	SwitchboardPlug* result;
	g_return_val_if_fail (module != NULL, NULL);
	g_debug ("Plug.vala:125: Activating Sharing plug");
	_tmp0_ = sharing_plug_new ();
	plug = _tmp0_;
	result = (SwitchboardPlug*) plug;
	return result;
}

