/* DeviceManagerWayland.c generated by valac 0.56.18, the Vala compiler
 * generated from DeviceManagerWayland.vala, do not modify */

/*
 * Copyright (c) 2019 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 */

#include "wacom.h"
#include <gee.h>
#include <glib-object.h>
#include <gudev/gudev.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk/wayland/gdkwayland.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	WACOM_BACKEND_DEVICE_MANAGER_WAYLAND_0_PROPERTY,
	WACOM_BACKEND_DEVICE_MANAGER_WAYLAND_NUM_PROPERTIES
};
static GParamSpec* wacom_backend_device_manager_wayland_properties[WACOM_BACKEND_DEVICE_MANAGER_WAYLAND_NUM_PROPERTIES];

#define WACOM_BACKEND_DEVICE_MANAGER_WAYLAND_TYPE_UDEV_ID_TABLE (wacom_backend_device_manager_wayland_udev_id_table_get_type ())
typedef struct _WacomBackendDeviceManagerWaylandUdevIDTable WacomBackendDeviceManagerWaylandUdevIDTable;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _WacomBackendDeviceManagerWaylandPrivate {
	GeeHashMap* devices;
	GUdevClient* client;
};

struct _WacomBackendDeviceManagerWaylandUdevIDTable {
	gchar* udev_id;
	WacomBackendDeviceDeviceType device_type;
};

static gint WacomBackendDeviceManagerWayland_private_offset;
static gpointer wacom_backend_device_manager_wayland_parent_class = NULL;

static GType wacom_backend_device_manager_wayland_udev_id_table_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static WacomBackendDeviceManagerWaylandUdevIDTable* wacom_backend_device_manager_wayland_udev_id_table_dup (const WacomBackendDeviceManagerWaylandUdevIDTable* self);
static void wacom_backend_device_manager_wayland_udev_id_table_free (WacomBackendDeviceManagerWaylandUdevIDTable* self);
static void wacom_backend_device_manager_wayland_udev_id_table_copy (const WacomBackendDeviceManagerWaylandUdevIDTable* self,
                                                              WacomBackendDeviceManagerWaylandUdevIDTable* dest);
static void wacom_backend_device_manager_wayland_udev_id_table_destroy (WacomBackendDeviceManagerWaylandUdevIDTable* self);
static void wacom_backend_device_manager_wayland_on_uevent (WacomBackendDeviceManagerWayland* self,
                                                     const gchar* action,
                                                     GUdevDevice* device);
static void _wacom_backend_device_manager_wayland_on_uevent_g_udev_client_uevent (GUdevClient* _sender,
                                                                           const gchar* action,
                                                                           GUdevDevice* device,
                                                                           gpointer self);
static gboolean wacom_backend_device_manager_wayland_device_is_evdev (GUdevDevice* device);
static void wacom_backend_device_manager_wayland_add_device (WacomBackendDeviceManagerWayland* self,
                                                      GUdevDevice* udev_device);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void wacom_backend_device_manager_wayland_remove_device (WacomBackendDeviceManagerWayland* self,
                                                         GUdevDevice* udev_device);
static WacomBackendDevice* wacom_backend_device_manager_wayland_create_device (WacomBackendDeviceManagerWayland* self,
                                                                        GUdevDevice* udev_device);
static WacomBackendDeviceDeviceType wacom_backend_device_manager_wayland_get_udev_device_type (GUdevDevice* device);
static GeeArrayList* wacom_backend_device_manager_wayland_real_list_devices (WacomBackendDeviceManager* base,
                                                                      WacomBackendDeviceDeviceType type);
static WacomBackendDevice* wacom_backend_device_manager_wayland_real_lookup_gdk_device (WacomBackendDeviceManager* base,
                                                                                 GdkDevice* device);
static void wacom_backend_device_manager_wayland_finalize (GObject * obj);
static GType wacom_backend_device_manager_wayland_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const WacomBackendDeviceManagerWaylandUdevIDTable WACOM_BACKEND_DEVICE_MANAGER_WAYLAND_UDEV_ID_TABLE[6] = {{"ID_INPUT_MOUSE", WACOM_BACKEND_DEVICE_DEVICE_TYPE_MOUSE}, {"ID_INPUT_KEYBOARD", WACOM_BACKEND_DEVICE_DEVICE_TYPE_KEYBOARD}, {"ID_INPUT_TOUCHPAD", WACOM_BACKEND_DEVICE_DEVICE_TYPE_TOUCHPAD}, {"ID_INPUT_TABLET", WACOM_BACKEND_DEVICE_DEVICE_TYPE_TABLET}, {"ID_INPUT_TOUCHSCREEN", WACOM_BACKEND_DEVICE_DEVICE_TYPE_TOUCHSCREEN}, {"ID_INPUT_TABLET_PAD", WACOM_BACKEND_DEVICE_DEVICE_TYPE_PAD}};

static inline gpointer
wacom_backend_device_manager_wayland_get_instance_private (WacomBackendDeviceManagerWayland* self)
{
	return G_STRUCT_MEMBER_P (self, WacomBackendDeviceManagerWayland_private_offset);
}

static void
_wacom_backend_device_manager_wayland_on_uevent_g_udev_client_uevent (GUdevClient* _sender,
                                                                      const gchar* action,
                                                                      GUdevDevice* device,
                                                                      gpointer self)
{
	wacom_backend_device_manager_wayland_on_uevent ((WacomBackendDeviceManagerWayland*) self, action, device);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

WacomBackendDeviceManagerWayland*
wacom_backend_device_manager_wayland_construct (GType object_type)
{
	WacomBackendDeviceManagerWayland * self = NULL;
	GeeHashMap* _tmp0_;
	gchar** subsystems = NULL;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint subsystems_length1;
	gint _subsystems_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	GUdevClient* _tmp4_;
	GUdevClient* _tmp5_;
	GList* devices = NULL;
	GUdevClient* _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	const gchar* _tmp8_;
	GList* _tmp9_;
	GList* _tmp10_;
	self = (WacomBackendDeviceManagerWayland*) wacom_backend_device_manager_construct (object_type);
	_tmp0_ = gee_hash_map_new (g_udev_device_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, WACOM_BACKEND_TYPE_DEVICE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->devices);
	self->priv->devices = _tmp0_;
	_tmp1_ = g_strdup ("input");
	_tmp2_ = g_new0 (gchar*, 1 + 1);
	_tmp2_[0] = _tmp1_;
	subsystems = _tmp2_;
	subsystems_length1 = 1;
	_subsystems_size_ = subsystems_length1;
	_tmp3_ = subsystems;
	_tmp3__length1 = subsystems_length1;
	_tmp4_ = g_udev_client_new (_tmp3_);
	_g_object_unref0 (self->priv->client);
	self->priv->client = _tmp4_;
	_tmp5_ = self->priv->client;
	g_signal_connect_object (_tmp5_, "uevent", (GCallback) _wacom_backend_device_manager_wayland_on_uevent_g_udev_client_uevent, self, 0);
	_tmp6_ = self->priv->client;
	_tmp7_ = subsystems;
	_tmp7__length1 = subsystems_length1;
	_tmp8_ = _tmp7_[0];
	_tmp9_ = g_udev_client_query_by_subsystem (_tmp6_, _tmp8_);
	devices = _tmp9_;
	_tmp10_ = devices;
	{
		GList* device_collection = NULL;
		GList* device_it = NULL;
		device_collection = _tmp10_;
		for (device_it = device_collection; device_it != NULL; device_it = device_it->next) {
			GUdevDevice* _tmp11_;
			GUdevDevice* device = NULL;
			_tmp11_ = _g_object_ref0 ((GUdevDevice*) device_it->data);
			device = _tmp11_;
			{
				GUdevDevice* _tmp12_;
				_tmp12_ = device;
				if (wacom_backend_device_manager_wayland_device_is_evdev (_tmp12_)) {
					GUdevDevice* _tmp13_;
					_tmp13_ = device;
					wacom_backend_device_manager_wayland_add_device (self, _tmp13_);
				}
				_g_object_unref0 (device);
			}
		}
	}
	(devices == NULL) ? NULL : (devices = (_g_list_free__g_object_unref0_ (devices), NULL));
	subsystems = (_vala_array_free (subsystems, subsystems_length1, (GDestroyNotify) g_free), NULL);
	return self;
}

WacomBackendDeviceManagerWayland*
wacom_backend_device_manager_wayland_new (void)
{
	return wacom_backend_device_manager_wayland_construct (WACOM_BACKEND_TYPE_DEVICE_MANAGER_WAYLAND);
}

static void
wacom_backend_device_manager_wayland_on_uevent (WacomBackendDeviceManagerWayland* self,
                                                const gchar* action,
                                                GUdevDevice* device)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (device != NULL);
	if (!wacom_backend_device_manager_wayland_device_is_evdev (device)) {
		return;
	}
	if (g_strcmp0 (action, "add") == 0) {
		wacom_backend_device_manager_wayland_add_device (self, device);
	} else {
		if (g_strcmp0 (action, "remove") == 0) {
			wacom_backend_device_manager_wayland_remove_device (self, device);
		}
	}
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
wacom_backend_device_manager_wayland_device_is_evdev (GUdevDevice* device)
{
	gchar* device_file = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean result;
	g_return_val_if_fail (device != NULL, FALSE);
	_tmp0_ = g_udev_device_get_device_file (device);
	_tmp1_ = g_strdup (_tmp0_);
	device_file = _tmp1_;
	_tmp3_ = device_file;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = device_file;
		_tmp2_ = !string_contains (_tmp4_, "/event");
	}
	if (_tmp2_) {
		result = FALSE;
		_g_free0 (device_file);
		return result;
	}
	result = g_udev_device_get_property_as_boolean (device, "ID_INPUT");
	_g_free0 (device_file);
	return result;
}

static void
wacom_backend_device_manager_wayland_add_device (WacomBackendDeviceManagerWayland* self,
                                                 GUdevDevice* udev_device)
{
	GUdevDevice* parent = NULL;
	GUdevDevice* _tmp0_;
	GUdevDevice* _tmp1_;
	WacomBackendDevice* device = NULL;
	WacomBackendDevice* _tmp2_;
	WacomBackendDevice* _tmp3_;
	GeeHashMap* _tmp4_;
	WacomBackendDevice* _tmp5_;
	WacomBackendDevice* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (udev_device != NULL);
	_tmp0_ = g_udev_device_get_parent (udev_device);
	parent = _tmp0_;
	_tmp1_ = parent;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (parent);
		return;
	}
	_tmp2_ = wacom_backend_device_manager_wayland_create_device (self, udev_device);
	device = _tmp2_;
	_tmp3_ = device;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (device);
		_g_object_unref0 (parent);
		return;
	}
	_tmp4_ = self->priv->devices;
	_tmp5_ = device;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp4_, udev_device, _tmp5_);
	_tmp6_ = device;
	g_signal_emit_by_name ((WacomBackendDeviceManager*) self, "device-added", _tmp6_);
	_g_object_unref0 (device);
	_g_object_unref0 (parent);
}

static void
wacom_backend_device_manager_wayland_remove_device (WacomBackendDeviceManagerWayland* self,
                                                    GUdevDevice* udev_device)
{
	WacomBackendDevice* device = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	WacomBackendDevice* _tmp2_;
	WacomBackendDevice* _tmp3_;
	GeeHashMap* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (udev_device != NULL);
	_tmp0_ = self->priv->devices;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, udev_device);
	device = (WacomBackendDevice*) _tmp1_;
	_tmp2_ = device;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (device);
		return;
	}
	_tmp3_ = device;
	g_signal_emit_by_name ((WacomBackendDeviceManager*) self, "device-removed", _tmp3_);
	_tmp4_ = self->priv->devices;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp4_, udev_device, NULL);
	_g_object_unref0 (device);
}

static WacomBackendDeviceDeviceType
wacom_backend_device_manager_wayland_get_udev_device_type (GUdevDevice* device)
{
	WacomBackendDeviceDeviceType type = 0U;
	WacomBackendDeviceDeviceType result;
	g_return_val_if_fail (device != NULL, 0U);
	type = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				WacomBackendDeviceManagerWaylandUdevIDTable _tmp2_;
				const gchar* _tmp3_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < G_N_ELEMENTS (WACOM_BACKEND_DEVICE_MANAGER_WAYLAND_UDEV_ID_TABLE))) {
					break;
				}
				_tmp2_ = WACOM_BACKEND_DEVICE_MANAGER_WAYLAND_UDEV_ID_TABLE[i];
				_tmp3_ = _tmp2_.udev_id;
				if (g_udev_device_get_property_as_boolean (device, _tmp3_)) {
					WacomBackendDeviceManagerWaylandUdevIDTable _tmp4_;
					_tmp4_ = WACOM_BACKEND_DEVICE_MANAGER_WAYLAND_UDEV_ID_TABLE[i];
					type |= _tmp4_.device_type;
				}
			}
		}
	}
	result = type;
	return result;
}

static WacomBackendDevice*
wacom_backend_device_manager_wayland_create_device (WacomBackendDeviceManagerWayland* self,
                                                    GUdevDevice* udev_device)
{
	WacomBackendDeviceDeviceType type = 0U;
	GUdevDevice* parent = NULL;
	GUdevDevice* _tmp0_;
	GUdevDevice* _tmp1_;
	gchar* vendor = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* product = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	WacomBackendDevice* device = NULL;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	WacomBackendDevice* _tmp19_ = NULL;
	WacomBackendDevice* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (udev_device != NULL, NULL);
	type = wacom_backend_device_manager_wayland_get_udev_device_type (udev_device);
	if (type == WACOM_BACKEND_DEVICE_DEVICE_TYPE_KEYBOARD) {
		result = NULL;
		return result;
	}
	_tmp0_ = g_udev_device_get_parent (udev_device);
	parent = _tmp0_;
	_tmp1_ = parent;
	if (_tmp1_ == NULL) {
		result = NULL;
		_g_object_unref0 (parent);
		return result;
	}
	_tmp2_ = g_udev_device_get_property (udev_device, "ID_VENDOR_ID");
	_tmp3_ = g_strdup (_tmp2_);
	vendor = _tmp3_;
	_tmp4_ = g_udev_device_get_property (udev_device, "ID_PRODUCT_ID");
	_tmp5_ = g_strdup (_tmp4_);
	product = _tmp5_;
	_tmp7_ = vendor;
	if (_tmp7_ == NULL) {
		_tmp6_ = TRUE;
	} else {
		const gchar* _tmp8_;
		_tmp8_ = product;
		_tmp6_ = _tmp8_ == NULL;
	}
	if (_tmp6_) {
		const gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp9_ = g_udev_device_get_sysfs_attr (udev_device, "device/id/vendor");
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (vendor);
		vendor = _tmp10_;
		_tmp11_ = g_udev_device_get_sysfs_attr (udev_device, "device/id/product");
		_tmp12_ = g_strdup (_tmp11_);
		_g_free0 (product);
		product = _tmp12_;
	}
	_tmp13_ = g_udev_device_get_device_file (udev_device);
	_tmp14_ = g_strdup (_tmp13_);
	_tmp15_ = vendor;
	_tmp16_ = g_strdup (_tmp15_);
	_tmp17_ = product;
	_tmp18_ = g_strdup (_tmp17_);
	_tmp19_ = wacom_backend_device_new ();
	wacom_backend_device_set_device_file (_tmp19_, _tmp14_);
	_g_free0 (_tmp14_);
	wacom_backend_device_set_vendor_id (_tmp19_, _tmp16_);
	_g_free0 (_tmp16_);
	wacom_backend_device_set_product_id (_tmp19_, _tmp18_);
	_g_free0 (_tmp18_);
	wacom_backend_device_set_dev_type (_tmp19_, type);
	device = _tmp19_;
	result = device;
	_g_free0 (product);
	_g_free0 (vendor);
	_g_object_unref0 (parent);
	return result;
}

static GeeArrayList*
wacom_backend_device_manager_wayland_real_list_devices (WacomBackendDeviceManager* base,
                                                        WacomBackendDeviceDeviceType type)
{
	WacomBackendDeviceManagerWayland * self;
	GeeArrayList* _result_ = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* result;
	self = (WacomBackendDeviceManagerWayland*) base;
	_tmp0_ = gee_array_list_new (WACOM_BACKEND_TYPE_DEVICE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_result_ = _tmp0_;
	{
		GeeIterator* _device_it = NULL;
		GeeHashMap* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
		_tmp1_ = self->priv->devices;
		_tmp2_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_device_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			WacomBackendDevice* device = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			WacomBackendDevice* _tmp10_;
			WacomBackendDeviceDeviceType _tmp11_;
			WacomBackendDeviceDeviceType _tmp12_;
			_tmp7_ = _device_it;
			if (!gee_iterator_next (_tmp7_)) {
				break;
			}
			_tmp8_ = _device_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			device = (WacomBackendDevice*) _tmp9_;
			_tmp10_ = device;
			_tmp11_ = wacom_backend_device_get_dev_type (_tmp10_);
			_tmp12_ = _tmp11_;
			if ((_tmp12_ & type) == type) {
				GeeArrayList* _tmp13_;
				WacomBackendDevice* _tmp14_;
				_tmp13_ = _result_;
				_tmp14_ = device;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp14_);
			}
			_g_object_unref0 (device);
		}
		_g_object_unref0 (_device_it);
	}
	result = _result_;
	return result;
}

static WacomBackendDevice*
wacom_backend_device_manager_wayland_real_lookup_gdk_device (WacomBackendDeviceManager* base,
                                                             GdkDevice* device)
{
	WacomBackendDeviceManagerWayland * self;
	GdkWaylandDevice* wayland_device = NULL;
	GdkWaylandDevice* _tmp0_;
	GdkWaylandDevice* _tmp1_;
	gchar* node_path = NULL;
	GdkWaylandDevice* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	WacomBackendDevice* result;
	self = (WacomBackendDeviceManagerWayland*) base;
	g_return_val_if_fail (device != NULL, NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (device, gdk_wayland_device_get_type ()) ? ((GdkWaylandDevice*) device) : NULL);
	wayland_device = _tmp0_;
	_tmp1_ = wayland_device;
	if (_tmp1_ == NULL) {
		result = NULL;
		_g_object_unref0 (wayland_device);
		return result;
	}
	_tmp2_ = wayland_device;
	_tmp3_ = gdk_wayland_device_get_node_path (_tmp2_);
	_tmp4_ = g_strdup (_tmp3_);
	node_path = _tmp4_;
	_tmp5_ = node_path;
	if (_tmp5_ == NULL) {
		result = NULL;
		_g_free0 (node_path);
		_g_object_unref0 (wayland_device);
		return result;
	}
	{
		GeeIterator* _dev_it = NULL;
		GeeHashMap* _tmp6_;
		GeeCollection* _tmp7_;
		GeeCollection* _tmp8_;
		GeeCollection* _tmp9_;
		GeeIterator* _tmp10_;
		GeeIterator* _tmp11_;
		_tmp6_ = self->priv->devices;
		_tmp7_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		_tmp10_ = gee_iterable_iterator ((GeeIterable*) _tmp9_);
		_tmp11_ = _tmp10_;
		_g_object_unref0 (_tmp9_);
		_dev_it = _tmp11_;
		while (TRUE) {
			GeeIterator* _tmp12_;
			WacomBackendDevice* dev = NULL;
			GeeIterator* _tmp13_;
			gpointer _tmp14_;
			WacomBackendDevice* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			_tmp12_ = _dev_it;
			if (!gee_iterator_next (_tmp12_)) {
				break;
			}
			_tmp13_ = _dev_it;
			_tmp14_ = gee_iterator_get (_tmp13_);
			dev = (WacomBackendDevice*) _tmp14_;
			_tmp15_ = dev;
			_tmp16_ = wacom_backend_device_get_device_file (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = node_path;
			if (g_strcmp0 (_tmp17_, _tmp18_) == 0) {
				result = dev;
				_g_object_unref0 (_dev_it);
				_g_free0 (node_path);
				_g_object_unref0 (wayland_device);
				return result;
			}
			_g_object_unref0 (dev);
		}
		_g_object_unref0 (_dev_it);
	}
	result = NULL;
	_g_free0 (node_path);
	_g_object_unref0 (wayland_device);
	return result;
}

static void
wacom_backend_device_manager_wayland_udev_id_table_copy (const WacomBackendDeviceManagerWaylandUdevIDTable* self,
                                                         WacomBackendDeviceManagerWaylandUdevIDTable* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = (*self).udev_id;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).udev_id);
	(*dest).udev_id = _tmp1_;
	(*dest).device_type = (*self).device_type;
}

static void
wacom_backend_device_manager_wayland_udev_id_table_destroy (WacomBackendDeviceManagerWaylandUdevIDTable* self)
{
	_g_free0 ((*self).udev_id);
}

static WacomBackendDeviceManagerWaylandUdevIDTable*
wacom_backend_device_manager_wayland_udev_id_table_dup (const WacomBackendDeviceManagerWaylandUdevIDTable* self)
{
	WacomBackendDeviceManagerWaylandUdevIDTable* dup;
	dup = g_new0 (WacomBackendDeviceManagerWaylandUdevIDTable, 1);
	wacom_backend_device_manager_wayland_udev_id_table_copy (self, dup);
	return dup;
}

static void
wacom_backend_device_manager_wayland_udev_id_table_free (WacomBackendDeviceManagerWaylandUdevIDTable* self)
{
	wacom_backend_device_manager_wayland_udev_id_table_destroy (self);
	g_free (self);
}

static GType
wacom_backend_device_manager_wayland_udev_id_table_get_type_once (void)
{
	GType wacom_backend_device_manager_wayland_udev_id_table_type_id;
	wacom_backend_device_manager_wayland_udev_id_table_type_id = g_boxed_type_register_static ("WacomBackendDeviceManagerWaylandUdevIDTable", (GBoxedCopyFunc) wacom_backend_device_manager_wayland_udev_id_table_dup, (GBoxedFreeFunc) wacom_backend_device_manager_wayland_udev_id_table_free);
	return wacom_backend_device_manager_wayland_udev_id_table_type_id;
}

static GType
wacom_backend_device_manager_wayland_udev_id_table_get_type (void)
{
	static volatile gsize wacom_backend_device_manager_wayland_udev_id_table_type_id__once = 0;
	if (g_once_init_enter (&wacom_backend_device_manager_wayland_udev_id_table_type_id__once)) {
		GType wacom_backend_device_manager_wayland_udev_id_table_type_id;
		wacom_backend_device_manager_wayland_udev_id_table_type_id = wacom_backend_device_manager_wayland_udev_id_table_get_type_once ();
		g_once_init_leave (&wacom_backend_device_manager_wayland_udev_id_table_type_id__once, wacom_backend_device_manager_wayland_udev_id_table_type_id);
	}
	return wacom_backend_device_manager_wayland_udev_id_table_type_id__once;
}

static void
wacom_backend_device_manager_wayland_class_init (WacomBackendDeviceManagerWaylandClass * klass,
                                                 gpointer klass_data)
{
	wacom_backend_device_manager_wayland_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &WacomBackendDeviceManagerWayland_private_offset);
	((WacomBackendDeviceManagerClass *) klass)->list_devices = (GeeArrayList* (*) (WacomBackendDeviceManager*, WacomBackendDeviceDeviceType)) wacom_backend_device_manager_wayland_real_list_devices;
	((WacomBackendDeviceManagerClass *) klass)->lookup_gdk_device = (WacomBackendDevice* (*) (WacomBackendDeviceManager*, GdkDevice*)) wacom_backend_device_manager_wayland_real_lookup_gdk_device;
	G_OBJECT_CLASS (klass)->finalize = wacom_backend_device_manager_wayland_finalize;
}

static void
wacom_backend_device_manager_wayland_instance_init (WacomBackendDeviceManagerWayland * self,
                                                    gpointer klass)
{
	self->priv = wacom_backend_device_manager_wayland_get_instance_private (self);
	self->priv->devices = NULL;
	self->priv->client = NULL;
}

static void
wacom_backend_device_manager_wayland_finalize (GObject * obj)
{
	WacomBackendDeviceManagerWayland * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WACOM_BACKEND_TYPE_DEVICE_MANAGER_WAYLAND, WacomBackendDeviceManagerWayland);
	_g_object_unref0 (self->priv->devices);
	_g_object_unref0 (self->priv->client);
	G_OBJECT_CLASS (wacom_backend_device_manager_wayland_parent_class)->finalize (obj);
}

static GType
wacom_backend_device_manager_wayland_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WacomBackendDeviceManagerWaylandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) wacom_backend_device_manager_wayland_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WacomBackendDeviceManagerWayland), 0, (GInstanceInitFunc) wacom_backend_device_manager_wayland_instance_init, NULL };
	GType wacom_backend_device_manager_wayland_type_id;
	wacom_backend_device_manager_wayland_type_id = g_type_register_static (WACOM_BACKEND_TYPE_DEVICE_MANAGER, "WacomBackendDeviceManagerWayland", &g_define_type_info, 0);
	WacomBackendDeviceManagerWayland_private_offset = g_type_add_instance_private (wacom_backend_device_manager_wayland_type_id, sizeof (WacomBackendDeviceManagerWaylandPrivate));
	return wacom_backend_device_manager_wayland_type_id;
}

GType
wacom_backend_device_manager_wayland_get_type (void)
{
	static volatile gsize wacom_backend_device_manager_wayland_type_id__once = 0;
	if (g_once_init_enter (&wacom_backend_device_manager_wayland_type_id__once)) {
		GType wacom_backend_device_manager_wayland_type_id;
		wacom_backend_device_manager_wayland_type_id = wacom_backend_device_manager_wayland_get_type_once ();
		g_once_init_leave (&wacom_backend_device_manager_wayland_type_id__once, wacom_backend_device_manager_wayland_type_id);
	}
	return wacom_backend_device_manager_wayland_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

