/* dbus-service.c generated by valac 0.56.17, the Vala compiler
 * generated from dbus-service.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include "synapse-core.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SYNAPSE_FREE_DESKTOP_DBUS_NAME_OWNER_CHANGED_SIGNAL,
	SYNAPSE_FREE_DESKTOP_DBUS_NUM_SIGNALS
};
static guint synapse_free_desktop_dbus_signals[SYNAPSE_FREE_DESKTOP_DBUS_NUM_SIGNALS] = {0};
typedef GDBusProxy SynapseFreeDesktopDBusProxy;
typedef GDBusProxyClass SynapseFreeDesktopDBusProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SynapseFreeDesktopDbusListQueuedOwnersReadyData SynapseFreeDesktopDbusListQueuedOwnersReadyData;
typedef struct _SynapseFreeDesktopDbusListNamesReadyData SynapseFreeDesktopDbusListNamesReadyData;
typedef struct _SynapseFreeDesktopDbusListActivatableNamesReadyData SynapseFreeDesktopDbusListActivatableNamesReadyData;
typedef struct _SynapseFreeDesktopDbusNameHasOwnerReadyData SynapseFreeDesktopDbusNameHasOwnerReadyData;
typedef struct _SynapseFreeDesktopDbusStartServiceByNameReadyData SynapseFreeDesktopDbusStartServiceByNameReadyData;
typedef struct _SynapseFreeDesktopDbusGetNameOwnerReadyData SynapseFreeDesktopDbusGetNameOwnerReadyData;
enum  {
	SYNAPSE_DBUS_SERVICE_0_PROPERTY,
	SYNAPSE_DBUS_SERVICE_NUM_PROPERTIES
};
static GParamSpec* synapse_dbus_service_properties[SYNAPSE_DBUS_SERVICE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _synapse_utils_async_once_unref0(var) ((var == NULL) ? NULL : (var = (synapse_utils_async_once_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SynapseDbusServiceInitializeData SynapseDbusServiceInitializeData;
enum  {
	SYNAPSE_DBUS_SERVICE_OWNER_CHANGED_SIGNAL,
	SYNAPSE_DBUS_SERVICE_NUM_SIGNALS
};
static guint synapse_dbus_service_signals[SYNAPSE_DBUS_SERVICE_NUM_SIGNALS] = {0};

struct _SynapseFreeDesktopDbusListQueuedOwnersReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar* name;
};

struct _SynapseFreeDesktopDbusListNamesReadyData {
	GDBusMethodInvocation* _invocation_;
};

struct _SynapseFreeDesktopDbusListActivatableNamesReadyData {
	GDBusMethodInvocation* _invocation_;
};

struct _SynapseFreeDesktopDbusNameHasOwnerReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar* name;
};

struct _SynapseFreeDesktopDbusStartServiceByNameReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar* name;
	guint32 flags;
};

struct _SynapseFreeDesktopDbusGetNameOwnerReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar* name;
};

struct _SynapseDBusServicePrivate {
	SynapseFreeDesktopDBus* proxy;
	GeeSet* owned_names;
	GeeSet* activatable_names;
	GeeSet* system_activatable_names;
	SynapseUtilsAsyncOnce* init_once;
};

struct _SynapseDbusServiceInitializeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseDBusService* self;
	SynapseUtilsAsyncOnce* _tmp0_;
	gboolean is_locked;
	SynapseUtilsAsyncOnce* _tmp1_;
	gchar** names;
	gint names_length1;
	gint _names_size_;
	SynapseFreeDesktopDBus* _tmp2_;
	SynapseFreeDesktopDBus* _tmp3_;
	SynapseFreeDesktopDBus* _tmp4_;
	SynapseFreeDesktopDBus* _tmp5_;
	gchar** _tmp6_;
	SynapseFreeDesktopDBus* _tmp7_;
	gint _tmp8_;
	gchar** _tmp9_;
	gint _tmp6__length1;
	gint __tmp6__size_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar** name_collection;
	gint name_collection_length1;
	gint _name_collection_size_;
	gint name_it;
	const gchar* name;
	const gchar* _tmp12_;
	GeeSet* _tmp13_;
	const gchar* _tmp14_;
	gchar** _tmp15_;
	SynapseFreeDesktopDBus* _tmp16_;
	gint _tmp17_;
	gchar** _tmp18_;
	gint _tmp15__length1;
	gint __tmp15__size_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	gchar** _tmp20_;
	gint _tmp20__length1;
	gchar** session_act_collection;
	gint session_act_collection_length1;
	gint _session_act_collection_size_;
	gint session_act_it;
	const gchar* session_act;
	GeeSet* _tmp21_;
	const gchar* _tmp22_;
	GError* err;
	GError* _tmp23_;
	const gchar* _tmp24_;
	SynapseFreeDesktopDBus* sys_proxy;
	SynapseFreeDesktopDBus* _tmp25_;
	gchar** _tmp26_;
	SynapseFreeDesktopDBus* _tmp27_;
	gint _tmp28_;
	gchar** _tmp29_;
	gint _tmp26__length1;
	gint __tmp26__size_;
	gchar** _tmp30_;
	gint _tmp30__length1;
	gchar** _tmp31_;
	gint _tmp31__length1;
	gchar** system_act_collection;
	gint system_act_collection_length1;
	gint _system_act_collection_size_;
	gint system_act_it;
	const gchar* system_act;
	GeeSet* _tmp32_;
	const gchar* _tmp33_;
	GError* sys_err;
	GError* _tmp34_;
	const gchar* _tmp35_;
	SynapseUtilsAsyncOnce* _tmp36_;
	GError* _inner_error0_;
};

static gint SynapseDBusService_private_offset;
static gpointer synapse_dbus_service_parent_class = NULL;
static SynapseDBusService* synapse_dbus_service_instance;
static SynapseDBusService* synapse_dbus_service_instance = NULL;

static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING (GClosure * closure,
                                                         GValue * return_value,
                                                         guint n_param_values,
                                                         const GValue * param_values,
                                                         gpointer invocation_hint,
                                                         gpointer marshal_data);
static GType synapse_free_desktop_dbus_get_type_once (void);
static void synapse_free_desktop_dbus_proxy_g_signal (GDBusProxy* proxy,
                                               const gchar* sender_name,
                                               const gchar* signal_name,
                                               GVariant* parameters);
static void _dbus_handle_synapse_free_desktop_dbus_name_owner_changed (SynapseFreeDesktopDBus* self,
                                                                GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object,
                                   GAsyncResult *res,
                                   void *user_data);
static void synapse_free_desktop_dbus_proxy_list_queued_owners_async (SynapseFreeDesktopDBus* self,
                                                               const gchar* name,
                                                               GAsyncReadyCallback _callback_,
                                                               gpointer _user_data_);
static gchar** synapse_free_desktop_dbus_proxy_list_queued_owners_finish (SynapseFreeDesktopDBus* self,
                                                                   GAsyncResult* _res_,
                                                                   gint* result_length1,
                                                                   GError** error);
static void synapse_free_desktop_dbus_proxy_list_names_async (SynapseFreeDesktopDBus* self,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
static gchar** synapse_free_desktop_dbus_proxy_list_names_finish (SynapseFreeDesktopDBus* self,
                                                           GAsyncResult* _res_,
                                                           gint* result_length1,
                                                           GError** error);
static void synapse_free_desktop_dbus_proxy_list_activatable_names_async (SynapseFreeDesktopDBus* self,
                                                                   GAsyncReadyCallback _callback_,
                                                                   gpointer _user_data_);
static gchar** synapse_free_desktop_dbus_proxy_list_activatable_names_finish (SynapseFreeDesktopDBus* self,
                                                                       GAsyncResult* _res_,
                                                                       gint* result_length1,
                                                                       GError** error);
static void synapse_free_desktop_dbus_proxy_name_has_owner_async (SynapseFreeDesktopDBus* self,
                                                           const gchar* name,
                                                           GAsyncReadyCallback _callback_,
                                                           gpointer _user_data_);
static gboolean synapse_free_desktop_dbus_proxy_name_has_owner_finish (SynapseFreeDesktopDBus* self,
                                                                GAsyncResult* _res_,
                                                                GError** error);
static void synapse_free_desktop_dbus_proxy_start_service_by_name_async (SynapseFreeDesktopDBus* self,
                                                                  const gchar* name,
                                                                  guint32 flags,
                                                                  GAsyncReadyCallback _callback_,
                                                                  gpointer _user_data_);
static guint32 synapse_free_desktop_dbus_proxy_start_service_by_name_finish (SynapseFreeDesktopDBus* self,
                                                                      GAsyncResult* _res_,
                                                                      GError** error);
static void synapse_free_desktop_dbus_proxy_get_name_owner_async (SynapseFreeDesktopDBus* self,
                                                           const gchar* name,
                                                           GAsyncReadyCallback _callback_,
                                                           gpointer _user_data_);
static gchar* synapse_free_desktop_dbus_proxy_get_name_owner_finish (SynapseFreeDesktopDBus* self,
                                                              GAsyncResult* _res_,
                                                              GError** error);
static void synapse_free_desktop_dbus_proxy_synapse_free_desktop_dbus_interface_init (SynapseFreeDesktopDBusIface* iface);
static void _dbus_synapse_free_desktop_dbus_list_queued_owners (SynapseFreeDesktopDBus* self,
                                                         GVariant* _parameters_,
                                                         GDBusMethodInvocation* invocation);
static void _dbus_synapse_free_desktop_dbus_list_queued_owners_ready (GObject * source_object,
                                                               GAsyncResult * _res_,
                                                               gpointer _user_data_);
static void _dbus_synapse_free_desktop_dbus_list_names (SynapseFreeDesktopDBus* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void _dbus_synapse_free_desktop_dbus_list_names_ready (GObject * source_object,
                                                       GAsyncResult * _res_,
                                                       gpointer _user_data_);
static void _dbus_synapse_free_desktop_dbus_list_activatable_names (SynapseFreeDesktopDBus* self,
                                                             GVariant* _parameters_,
                                                             GDBusMethodInvocation* invocation);
static void _dbus_synapse_free_desktop_dbus_list_activatable_names_ready (GObject * source_object,
                                                                   GAsyncResult * _res_,
                                                                   gpointer _user_data_);
static void _dbus_synapse_free_desktop_dbus_name_has_owner (SynapseFreeDesktopDBus* self,
                                                     GVariant* _parameters_,
                                                     GDBusMethodInvocation* invocation);
static void _dbus_synapse_free_desktop_dbus_name_has_owner_ready (GObject * source_object,
                                                           GAsyncResult * _res_,
                                                           gpointer _user_data_);
static void _dbus_synapse_free_desktop_dbus_start_service_by_name (SynapseFreeDesktopDBus* self,
                                                            GVariant* _parameters_,
                                                            GDBusMethodInvocation* invocation);
static void _dbus_synapse_free_desktop_dbus_start_service_by_name_ready (GObject * source_object,
                                                                  GAsyncResult * _res_,
                                                                  gpointer _user_data_);
static void _dbus_synapse_free_desktop_dbus_get_name_owner (SynapseFreeDesktopDBus* self,
                                                     GVariant* _parameters_,
                                                     GDBusMethodInvocation* invocation);
static void _dbus_synapse_free_desktop_dbus_get_name_owner_ready (GObject * source_object,
                                                           GAsyncResult * _res_,
                                                           gpointer _user_data_);
static void synapse_free_desktop_dbus_dbus_interface_method_call (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* method_name,
                                                           GVariant* parameters,
                                                           GDBusMethodInvocation* invocation,
                                                           gpointer user_data);
static GVariant* synapse_free_desktop_dbus_dbus_interface_get_property (GDBusConnection* connection,
                                                                 const gchar* sender,
                                                                 const gchar* object_path,
                                                                 const gchar* interface_name,
                                                                 const gchar* property_name,
                                                                 GError** error,
                                                                 gpointer user_data);
static gboolean synapse_free_desktop_dbus_dbus_interface_set_property (GDBusConnection* connection,
                                                                const gchar* sender,
                                                                const gchar* object_path,
                                                                const gchar* interface_name,
                                                                const gchar* property_name,
                                                                GVariant* value,
                                                                GError** error,
                                                                gpointer user_data);
static void _dbus_synapse_free_desktop_dbus_name_owner_changed (GObject* _sender,
                                                         const gchar* name,
                                                         const gchar* old_owner,
                                                         const gchar* new_owner,
                                                         gpointer* _data);
static void _synapse_free_desktop_dbus_unregister_object (gpointer user_data);
static SynapseDBusService* synapse_dbus_service_new (void);
static SynapseDBusService* synapse_dbus_service_construct (GType object_type);
static void synapse_dbus_service_name_owner_changed (SynapseDBusService* self,
                                              SynapseFreeDesktopDBus* sender,
                                              const gchar* name,
                                              const gchar* old_owner,
                                              const gchar* new_owner);
static void synapse_dbus_service_initialize_data_free (gpointer _data);
static gboolean synapse_dbus_service_initialize_co (SynapseDbusServiceInitializeData* _data_);
static void synapse_dbus_service_initialize_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static void _synapse_dbus_service_name_owner_changed_synapse_free_desktop_dbus_name_owner_changed (SynapseFreeDesktopDBus* _sender,
                                                                                            const gchar* name,
                                                                                            const gchar* old_owner,
                                                                                            const gchar* new_owner,
                                                                                            gpointer self);
static void g_cclosure_user_marshal_VOID__STRING_BOOLEAN (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data);
static GObject * synapse_dbus_service_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
static void synapse_dbus_service_finalize (GObject * obj);
static GType synapse_dbus_service_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GDBusArgInfo _synapse_free_desktop_dbus_dbus_arg_info_list_queued_owners_name = {-1, "name", "s", NULL};
static const GDBusArgInfo _synapse_free_desktop_dbus_dbus_arg_info_list_queued_owners_result = {-1, "result", "as", NULL};
static const GDBusArgInfo * const _synapse_free_desktop_dbus_dbus_arg_info_list_queued_owners_in[] = {&_synapse_free_desktop_dbus_dbus_arg_info_list_queued_owners_name, NULL};
static const GDBusArgInfo * const _synapse_free_desktop_dbus_dbus_arg_info_list_queued_owners_out[] = {&_synapse_free_desktop_dbus_dbus_arg_info_list_queued_owners_result, NULL};
static const GDBusMethodInfo _synapse_free_desktop_dbus_dbus_method_info_list_queued_owners = {-1, "ListQueuedOwners", (GDBusArgInfo **) (&_synapse_free_desktop_dbus_dbus_arg_info_list_queued_owners_in), (GDBusArgInfo **) (&_synapse_free_desktop_dbus_dbus_arg_info_list_queued_owners_out), NULL};
static const GDBusArgInfo _synapse_free_desktop_dbus_dbus_arg_info_list_names_result = {-1, "result", "as", NULL};
static const GDBusArgInfo * const _synapse_free_desktop_dbus_dbus_arg_info_list_names_in[] = {NULL};
static const GDBusArgInfo * const _synapse_free_desktop_dbus_dbus_arg_info_list_names_out[] = {&_synapse_free_desktop_dbus_dbus_arg_info_list_names_result, NULL};
static const GDBusMethodInfo _synapse_free_desktop_dbus_dbus_method_info_list_names = {-1, "ListNames", (GDBusArgInfo **) (&_synapse_free_desktop_dbus_dbus_arg_info_list_names_in), (GDBusArgInfo **) (&_synapse_free_desktop_dbus_dbus_arg_info_list_names_out), NULL};
static const GDBusArgInfo _synapse_free_desktop_dbus_dbus_arg_info_list_activatable_names_result = {-1, "result", "as", NULL};
static const GDBusArgInfo * const _synapse_free_desktop_dbus_dbus_arg_info_list_activatable_names_in[] = {NULL};
static const GDBusArgInfo * const _synapse_free_desktop_dbus_dbus_arg_info_list_activatable_names_out[] = {&_synapse_free_desktop_dbus_dbus_arg_info_list_activatable_names_result, NULL};
static const GDBusMethodInfo _synapse_free_desktop_dbus_dbus_method_info_list_activatable_names = {-1, "ListActivatableNames", (GDBusArgInfo **) (&_synapse_free_desktop_dbus_dbus_arg_info_list_activatable_names_in), (GDBusArgInfo **) (&_synapse_free_desktop_dbus_dbus_arg_info_list_activatable_names_out), NULL};
static const GDBusArgInfo _synapse_free_desktop_dbus_dbus_arg_info_name_has_owner_name = {-1, "name", "s", NULL};
static const GDBusArgInfo _synapse_free_desktop_dbus_dbus_arg_info_name_has_owner_result = {-1, "result", "b", NULL};
static const GDBusArgInfo * const _synapse_free_desktop_dbus_dbus_arg_info_name_has_owner_in[] = {&_synapse_free_desktop_dbus_dbus_arg_info_name_has_owner_name, NULL};
static const GDBusArgInfo * const _synapse_free_desktop_dbus_dbus_arg_info_name_has_owner_out[] = {&_synapse_free_desktop_dbus_dbus_arg_info_name_has_owner_result, NULL};
static const GDBusMethodInfo _synapse_free_desktop_dbus_dbus_method_info_name_has_owner = {-1, "NameHasOwner", (GDBusArgInfo **) (&_synapse_free_desktop_dbus_dbus_arg_info_name_has_owner_in), (GDBusArgInfo **) (&_synapse_free_desktop_dbus_dbus_arg_info_name_has_owner_out), NULL};
static const GDBusArgInfo _synapse_free_desktop_dbus_dbus_arg_info_start_service_by_name_name = {-1, "name", "s", NULL};
static const GDBusArgInfo _synapse_free_desktop_dbus_dbus_arg_info_start_service_by_name_flags = {-1, "flags", "u", NULL};
static const GDBusArgInfo _synapse_free_desktop_dbus_dbus_arg_info_start_service_by_name_result = {-1, "result", "u", NULL};
static const GDBusArgInfo * const _synapse_free_desktop_dbus_dbus_arg_info_start_service_by_name_in[] = {&_synapse_free_desktop_dbus_dbus_arg_info_start_service_by_name_name, &_synapse_free_desktop_dbus_dbus_arg_info_start_service_by_name_flags, NULL};
static const GDBusArgInfo * const _synapse_free_desktop_dbus_dbus_arg_info_start_service_by_name_out[] = {&_synapse_free_desktop_dbus_dbus_arg_info_start_service_by_name_result, NULL};
static const GDBusMethodInfo _synapse_free_desktop_dbus_dbus_method_info_start_service_by_name = {-1, "StartServiceByName", (GDBusArgInfo **) (&_synapse_free_desktop_dbus_dbus_arg_info_start_service_by_name_in), (GDBusArgInfo **) (&_synapse_free_desktop_dbus_dbus_arg_info_start_service_by_name_out), NULL};
static const GDBusArgInfo _synapse_free_desktop_dbus_dbus_arg_info_get_name_owner_name = {-1, "name", "s", NULL};
static const GDBusArgInfo _synapse_free_desktop_dbus_dbus_arg_info_get_name_owner_result = {-1, "result", "s", NULL};
static const GDBusArgInfo * const _synapse_free_desktop_dbus_dbus_arg_info_get_name_owner_in[] = {&_synapse_free_desktop_dbus_dbus_arg_info_get_name_owner_name, NULL};
static const GDBusArgInfo * const _synapse_free_desktop_dbus_dbus_arg_info_get_name_owner_out[] = {&_synapse_free_desktop_dbus_dbus_arg_info_get_name_owner_result, NULL};
static const GDBusMethodInfo _synapse_free_desktop_dbus_dbus_method_info_get_name_owner = {-1, "GetNameOwner", (GDBusArgInfo **) (&_synapse_free_desktop_dbus_dbus_arg_info_get_name_owner_in), (GDBusArgInfo **) (&_synapse_free_desktop_dbus_dbus_arg_info_get_name_owner_out), NULL};
static const GDBusMethodInfo * const _synapse_free_desktop_dbus_dbus_method_info[] = {&_synapse_free_desktop_dbus_dbus_method_info_list_queued_owners, &_synapse_free_desktop_dbus_dbus_method_info_list_names, &_synapse_free_desktop_dbus_dbus_method_info_list_activatable_names, &_synapse_free_desktop_dbus_dbus_method_info_name_has_owner, &_synapse_free_desktop_dbus_dbus_method_info_start_service_by_name, &_synapse_free_desktop_dbus_dbus_method_info_get_name_owner, NULL};
static const GDBusArgInfo _synapse_free_desktop_dbus_dbus_arg_info_name_owner_changed_name = {-1, "name", "s", NULL};
static const GDBusArgInfo _synapse_free_desktop_dbus_dbus_arg_info_name_owner_changed_old_owner = {-1, "old_owner", "s", NULL};
static const GDBusArgInfo _synapse_free_desktop_dbus_dbus_arg_info_name_owner_changed_new_owner = {-1, "new_owner", "s", NULL};
static const GDBusArgInfo * const _synapse_free_desktop_dbus_dbus_arg_info_name_owner_changed[] = {&_synapse_free_desktop_dbus_dbus_arg_info_name_owner_changed_name, &_synapse_free_desktop_dbus_dbus_arg_info_name_owner_changed_old_owner, &_synapse_free_desktop_dbus_dbus_arg_info_name_owner_changed_new_owner, NULL};
static const GDBusSignalInfo _synapse_free_desktop_dbus_dbus_signal_info_name_owner_changed = {-1, "NameOwnerChanged", (GDBusArgInfo **) (&_synapse_free_desktop_dbus_dbus_arg_info_name_owner_changed), NULL};
static const GDBusSignalInfo * const _synapse_free_desktop_dbus_dbus_signal_info[] = {&_synapse_free_desktop_dbus_dbus_signal_info_name_owner_changed, NULL};
static const GDBusPropertyInfo * const _synapse_free_desktop_dbus_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _synapse_free_desktop_dbus_dbus_interface_info = {-1, "org.freedesktop.DBus", (GDBusMethodInfo **) (&_synapse_free_desktop_dbus_dbus_method_info), (GDBusSignalInfo **) (&_synapse_free_desktop_dbus_dbus_signal_info), (GDBusPropertyInfo **) (&_synapse_free_desktop_dbus_dbus_property_info), NULL};
static const GDBusInterfaceVTable _synapse_free_desktop_dbus_dbus_interface_vtable = {synapse_free_desktop_dbus_dbus_interface_method_call, synapse_free_desktop_dbus_dbus_interface_get_property, synapse_free_desktop_dbus_dbus_interface_set_property};

void
synapse_free_desktop_dbus_list_queued_owners (SynapseFreeDesktopDBus* self,
                                              const gchar* name,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	SynapseFreeDesktopDBusIface* _iface_;
#line 24 "dbus-service.vala"
	_iface_ = SYNAPSE_FREE_DESKTOP_DBUS_GET_INTERFACE (self);
#line 24 "dbus-service.vala"
	if (_iface_->list_queued_owners) {
#line 24 "dbus-service.vala"
		_iface_->list_queued_owners (self, name, _callback_, _user_data_);
#line 407 "dbus-service.c"
	}
}

gchar**
synapse_free_desktop_dbus_list_queued_owners_finish (SynapseFreeDesktopDBus* self,
                                                     GAsyncResult* _res_,
                                                     gint* result_length1,
                                                     GError** error)
{
	SynapseFreeDesktopDBusIface* _iface_;
#line 24 "dbus-service.vala"
	_iface_ = SYNAPSE_FREE_DESKTOP_DBUS_GET_INTERFACE (self);
#line 24 "dbus-service.vala"
	if (_iface_->list_queued_owners_finish) {
#line 24 "dbus-service.vala"
		return _iface_->list_queued_owners_finish (self, _res_, result_length1, error);
#line 424 "dbus-service.c"
	}
#line 24 "dbus-service.vala"
	return NULL;
#line 428 "dbus-service.c"
}

void
synapse_free_desktop_dbus_list_names (SynapseFreeDesktopDBus* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	SynapseFreeDesktopDBusIface* _iface_;
#line 24 "dbus-service.vala"
	_iface_ = SYNAPSE_FREE_DESKTOP_DBUS_GET_INTERFACE (self);
#line 24 "dbus-service.vala"
	if (_iface_->list_names) {
#line 24 "dbus-service.vala"
		_iface_->list_names (self, _callback_, _user_data_);
#line 443 "dbus-service.c"
	}
}

gchar**
synapse_free_desktop_dbus_list_names_finish (SynapseFreeDesktopDBus* self,
                                             GAsyncResult* _res_,
                                             gint* result_length1,
                                             GError** error)
{
	SynapseFreeDesktopDBusIface* _iface_;
#line 24 "dbus-service.vala"
	_iface_ = SYNAPSE_FREE_DESKTOP_DBUS_GET_INTERFACE (self);
#line 24 "dbus-service.vala"
	if (_iface_->list_names_finish) {
#line 24 "dbus-service.vala"
		return _iface_->list_names_finish (self, _res_, result_length1, error);
#line 460 "dbus-service.c"
	}
#line 24 "dbus-service.vala"
	return NULL;
#line 464 "dbus-service.c"
}

void
synapse_free_desktop_dbus_list_activatable_names (SynapseFreeDesktopDBus* self,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	SynapseFreeDesktopDBusIface* _iface_;
#line 24 "dbus-service.vala"
	_iface_ = SYNAPSE_FREE_DESKTOP_DBUS_GET_INTERFACE (self);
#line 24 "dbus-service.vala"
	if (_iface_->list_activatable_names) {
#line 24 "dbus-service.vala"
		_iface_->list_activatable_names (self, _callback_, _user_data_);
#line 479 "dbus-service.c"
	}
}

gchar**
synapse_free_desktop_dbus_list_activatable_names_finish (SynapseFreeDesktopDBus* self,
                                                         GAsyncResult* _res_,
                                                         gint* result_length1,
                                                         GError** error)
{
	SynapseFreeDesktopDBusIface* _iface_;
#line 24 "dbus-service.vala"
	_iface_ = SYNAPSE_FREE_DESKTOP_DBUS_GET_INTERFACE (self);
#line 24 "dbus-service.vala"
	if (_iface_->list_activatable_names_finish) {
#line 24 "dbus-service.vala"
		return _iface_->list_activatable_names_finish (self, _res_, result_length1, error);
#line 496 "dbus-service.c"
	}
#line 24 "dbus-service.vala"
	return NULL;
#line 500 "dbus-service.c"
}

void
synapse_free_desktop_dbus_name_has_owner (SynapseFreeDesktopDBus* self,
                                          const gchar* name,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	SynapseFreeDesktopDBusIface* _iface_;
#line 24 "dbus-service.vala"
	_iface_ = SYNAPSE_FREE_DESKTOP_DBUS_GET_INTERFACE (self);
#line 24 "dbus-service.vala"
	if (_iface_->name_has_owner) {
#line 24 "dbus-service.vala"
		_iface_->name_has_owner (self, name, _callback_, _user_data_);
#line 516 "dbus-service.c"
	}
}

gboolean
synapse_free_desktop_dbus_name_has_owner_finish (SynapseFreeDesktopDBus* self,
                                                 GAsyncResult* _res_,
                                                 GError** error)
{
	SynapseFreeDesktopDBusIface* _iface_;
#line 24 "dbus-service.vala"
	_iface_ = SYNAPSE_FREE_DESKTOP_DBUS_GET_INTERFACE (self);
#line 24 "dbus-service.vala"
	if (_iface_->name_has_owner_finish) {
#line 24 "dbus-service.vala"
		return _iface_->name_has_owner_finish (self, _res_, error);
#line 532 "dbus-service.c"
	}
#line 24 "dbus-service.vala"
	return FALSE;
#line 536 "dbus-service.c"
}

void
synapse_free_desktop_dbus_start_service_by_name (SynapseFreeDesktopDBus* self,
                                                 const gchar* name,
                                                 guint32 flags,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	SynapseFreeDesktopDBusIface* _iface_;
#line 24 "dbus-service.vala"
	_iface_ = SYNAPSE_FREE_DESKTOP_DBUS_GET_INTERFACE (self);
#line 24 "dbus-service.vala"
	if (_iface_->start_service_by_name) {
#line 24 "dbus-service.vala"
		_iface_->start_service_by_name (self, name, flags, _callback_, _user_data_);
#line 553 "dbus-service.c"
	}
}

guint32
synapse_free_desktop_dbus_start_service_by_name_finish (SynapseFreeDesktopDBus* self,
                                                        GAsyncResult* _res_,
                                                        GError** error)
{
	SynapseFreeDesktopDBusIface* _iface_;
#line 24 "dbus-service.vala"
	_iface_ = SYNAPSE_FREE_DESKTOP_DBUS_GET_INTERFACE (self);
#line 24 "dbus-service.vala"
	if (_iface_->start_service_by_name_finish) {
#line 24 "dbus-service.vala"
		return _iface_->start_service_by_name_finish (self, _res_, error);
#line 569 "dbus-service.c"
	}
#line 24 "dbus-service.vala"
	return 0U;
#line 573 "dbus-service.c"
}

void
synapse_free_desktop_dbus_get_name_owner (SynapseFreeDesktopDBus* self,
                                          const gchar* name,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	SynapseFreeDesktopDBusIface* _iface_;
#line 24 "dbus-service.vala"
	_iface_ = SYNAPSE_FREE_DESKTOP_DBUS_GET_INTERFACE (self);
#line 24 "dbus-service.vala"
	if (_iface_->get_name_owner) {
#line 24 "dbus-service.vala"
		_iface_->get_name_owner (self, name, _callback_, _user_data_);
#line 589 "dbus-service.c"
	}
}

gchar*
synapse_free_desktop_dbus_get_name_owner_finish (SynapseFreeDesktopDBus* self,
                                                 GAsyncResult* _res_,
                                                 GError** error)
{
	SynapseFreeDesktopDBusIface* _iface_;
#line 24 "dbus-service.vala"
	_iface_ = SYNAPSE_FREE_DESKTOP_DBUS_GET_INTERFACE (self);
#line 24 "dbus-service.vala"
	if (_iface_->get_name_owner_finish) {
#line 24 "dbus-service.vala"
		return _iface_->get_name_owner_finish (self, _res_, error);
#line 605 "dbus-service.c"
	}
#line 24 "dbus-service.vala"
	return NULL;
#line 609 "dbus-service.c"
}

static void
g_cclosure_user_marshal_VOID__STRING_STRING_STRING (GClosure * closure,
                                                    GValue * return_value,
                                                    guint n_param_values,
                                                    const GValue * param_values,
                                                    gpointer invocation_hint,
                                                    gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, const char* arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 24 "dbus-service.vala"
	g_return_if_fail (n_param_values == 4);
#line 24 "dbus-service.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 24 "dbus-service.vala"
		data1 = closure->data;
#line 24 "dbus-service.vala"
		data2 = param_values->data[0].v_pointer;
#line 634 "dbus-service.c"
	} else {
#line 24 "dbus-service.vala"
		data1 = param_values->data[0].v_pointer;
#line 24 "dbus-service.vala"
		data2 = closure->data;
#line 640 "dbus-service.c"
	}
#line 24 "dbus-service.vala"
	callback = (GMarshalFunc_VOID__STRING_STRING_STRING) (marshal_data ? marshal_data : cc->callback);
#line 24 "dbus-service.vala"
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_string (param_values + 3), data2);
#line 646 "dbus-service.c"
}

static void
synapse_free_desktop_dbus_default_init (SynapseFreeDesktopDBusIface * iface,
                                        gpointer iface_data)
{
#line 24 "dbus-service.vala"
	synapse_free_desktop_dbus_signals[SYNAPSE_FREE_DESKTOP_DBUS_NAME_OWNER_CHANGED_SIGNAL] = g_signal_new ("name-owner-changed", SYNAPSE_TYPE_FREE_DESKTOP_DBUS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
#line 655 "dbus-service.c"
}

static GType
synapse_free_desktop_dbus_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseFreeDesktopDBusIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_free_desktop_dbus_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType synapse_free_desktop_dbus_type_id;
	synapse_free_desktop_dbus_type_id = g_type_register_static (G_TYPE_INTERFACE, "SynapseFreeDesktopDBus", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (synapse_free_desktop_dbus_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (synapse_free_desktop_dbus_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) synapse_free_desktop_dbus_proxy_get_type);
	g_type_set_qdata (synapse_free_desktop_dbus_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.DBus");
	g_type_set_qdata (synapse_free_desktop_dbus_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_synapse_free_desktop_dbus_dbus_interface_info));
	g_type_set_qdata (synapse_free_desktop_dbus_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) synapse_free_desktop_dbus_register_object);
	return synapse_free_desktop_dbus_type_id;
}

GType
synapse_free_desktop_dbus_get_type (void)
{
	static volatile gsize synapse_free_desktop_dbus_type_id__once = 0;
	if (g_once_init_enter (&synapse_free_desktop_dbus_type_id__once)) {
		GType synapse_free_desktop_dbus_type_id;
		synapse_free_desktop_dbus_type_id = synapse_free_desktop_dbus_get_type_once ();
		g_once_init_leave (&synapse_free_desktop_dbus_type_id__once, synapse_free_desktop_dbus_type_id);
	}
	return synapse_free_desktop_dbus_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (SynapseFreeDesktopDBusProxy, synapse_free_desktop_dbus_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (SYNAPSE_TYPE_FREE_DESKTOP_DBUS, synapse_free_desktop_dbus_proxy_synapse_free_desktop_dbus_interface_init) )
static void
synapse_free_desktop_dbus_proxy_class_init (SynapseFreeDesktopDBusProxyClass* klass)
{
#line 239 "data-sink.vala"
	G_DBUS_PROXY_CLASS (klass)->g_signal = synapse_free_desktop_dbus_proxy_g_signal;
#line 690 "dbus-service.c"
}

static void
_dbus_handle_synapse_free_desktop_dbus_name_owner_changed (SynapseFreeDesktopDBus* self,
                                                           GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* name = NULL;
	GVariant* _tmp0_;
	gchar* old_owner = NULL;
	GVariant* _tmp1_;
	gchar* new_owner = NULL;
	GVariant* _tmp2_;
#line 239 "data-sink.vala"
	g_variant_iter_init (&_arguments_iter, parameters);
#line 239 "data-sink.vala"
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
#line 239 "data-sink.vala"
	name = g_variant_dup_string (_tmp0_, NULL);
#line 239 "data-sink.vala"
	g_variant_unref (_tmp0_);
#line 239 "data-sink.vala"
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
#line 239 "data-sink.vala"
	old_owner = g_variant_dup_string (_tmp1_, NULL);
#line 239 "data-sink.vala"
	g_variant_unref (_tmp1_);
#line 239 "data-sink.vala"
	_tmp2_ = g_variant_iter_next_value (&_arguments_iter);
#line 239 "data-sink.vala"
	new_owner = g_variant_dup_string (_tmp2_, NULL);
#line 239 "data-sink.vala"
	g_variant_unref (_tmp2_);
#line 239 "data-sink.vala"
	g_signal_emit_by_name (self, "name-owner-changed", name, old_owner, new_owner);
#line 239 "data-sink.vala"
	_g_free0 (name);
#line 239 "data-sink.vala"
	_g_free0 (old_owner);
#line 239 "data-sink.vala"
	_g_free0 (new_owner);
#line 732 "dbus-service.c"
}

static void
synapse_free_desktop_dbus_proxy_g_signal (GDBusProxy* proxy,
                                          const gchar* sender_name,
                                          const gchar* signal_name,
                                          GVariant* parameters)
{
#line 239 "data-sink.vala"
	if (strcmp (signal_name, "NameOwnerChanged") == 0) {
#line 239 "data-sink.vala"
		_dbus_handle_synapse_free_desktop_dbus_name_owner_changed ((SynapseFreeDesktopDBus*) proxy, parameters);
#line 745 "dbus-service.c"
	}
}

static void
synapse_free_desktop_dbus_proxy_init (SynapseFreeDesktopDBusProxy* self)
{
#line 239 "data-sink.vala"
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_synapse_free_desktop_dbus_dbus_interface_info));
#line 754 "dbus-service.c"
}

static void
_vala_g_async_ready_callback (GObject *source_object,
                              GAsyncResult *res,
                              void *user_data)
{
#line 239 "data-sink.vala"
	g_task_return_pointer (user_data, g_object_ref (res), g_object_unref);
#line 239 "data-sink.vala"
	g_object_unref (user_data);
#line 766 "dbus-service.c"
}

static void
synapse_free_desktop_dbus_proxy_list_queued_owners_async (SynapseFreeDesktopDBus* self,
                                                          const gchar* name,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
#line 239 "data-sink.vala"
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.DBus", "ListQueuedOwners");
#line 239 "data-sink.vala"
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
#line 239 "data-sink.vala"
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (name));
#line 239 "data-sink.vala"
	_arguments = g_variant_builder_end (&_arguments_builder);
#line 239 "data-sink.vala"
	g_dbus_message_set_body (_message, _arguments);
#line 239 "data-sink.vala"
	if (_callback_ != NULL) {
#line 239 "data-sink.vala"
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
#line 792 "dbus-service.c"
	} else {
#line 239 "data-sink.vala"
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
#line 239 "data-sink.vala"
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
#line 798 "dbus-service.c"
	}
#line 239 "data-sink.vala"
	g_object_unref (_message);
#line 802 "dbus-service.c"
}

static gchar**
synapse_free_desktop_dbus_proxy_list_queued_owners_finish (SynapseFreeDesktopDBus* self,
                                                           GAsyncResult* _res_,
                                                           gint* result_length1,
                                                           GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar** _result = NULL;
	gint _result_length1;
	GVariant* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length;
	gint _tmp4__size;
	gint _tmp4__length1;
	GVariantIter _tmp5_;
	GVariant* _tmp6_;
#line 239 "data-sink.vala"
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
#line 239 "data-sink.vala"
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
#line 239 "data-sink.vala"
	g_object_unref (_inner_res);
#line 239 "data-sink.vala"
	if (!_reply_message) {
#line 239 "data-sink.vala"
		return NULL;
#line 834 "dbus-service.c"
	}
#line 239 "data-sink.vala"
	if (g_dbus_message_to_gerror (_reply_message, error)) {
#line 239 "data-sink.vala"
		g_object_unref (_reply_message);
#line 239 "data-sink.vala"
		return NULL;
#line 842 "dbus-service.c"
	}
#line 239 "data-sink.vala"
	_reply = g_dbus_message_get_body (_reply_message);
#line 239 "data-sink.vala"
	g_variant_iter_init (&_reply_iter, _reply);
#line 848 "dbus-service.c"
	_result_length1 = 0;
#line 239 "data-sink.vala"
	_tmp3_ = g_variant_iter_next_value (&_reply_iter);
#line 852 "dbus-service.c"
	_tmp4_ = g_new (gchar*, 5);
	_tmp4__length = 0;
	_tmp4__size = 4;
	_tmp4__length1 = 0;
#line 239 "data-sink.vala"
	g_variant_iter_init (&_tmp5_, _tmp3_);
#line 239 "data-sink.vala"
	for (; (_tmp6_ = g_variant_iter_next_value (&_tmp5_)) != NULL; _tmp4__length1++) {
#line 239 "data-sink.vala"
		if (_tmp4__size == _tmp4__length) {
#line 239 "data-sink.vala"
			_tmp4__size = 2 * _tmp4__size;
#line 239 "data-sink.vala"
			_tmp4_ = g_renew (gchar*, _tmp4_, _tmp4__size + 1);
#line 867 "dbus-service.c"
		}
#line 239 "data-sink.vala"
		_tmp4_[_tmp4__length++] = g_variant_dup_string (_tmp6_, NULL);
#line 239 "data-sink.vala"
		g_variant_unref (_tmp6_);
#line 873 "dbus-service.c"
	}
#line 239 "data-sink.vala"
	_result_length1 = _tmp4__length1;
#line 239 "data-sink.vala"
	_tmp4_[_tmp4__length] = NULL;
#line 239 "data-sink.vala"
	_result = _tmp4_;
#line 239 "data-sink.vala"
	g_variant_unref (_tmp3_);
#line 239 "data-sink.vala"
	*result_length1 = _result_length1;
#line 239 "data-sink.vala"
	g_object_unref (_reply_message);
#line 239 "data-sink.vala"
	return _result;
#line 889 "dbus-service.c"
}

static void
synapse_free_desktop_dbus_proxy_list_names_async (SynapseFreeDesktopDBus* self,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
#line 239 "data-sink.vala"
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.DBus", "ListNames");
#line 239 "data-sink.vala"
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
#line 239 "data-sink.vala"
	_arguments = g_variant_builder_end (&_arguments_builder);
#line 239 "data-sink.vala"
	g_dbus_message_set_body (_message, _arguments);
#line 239 "data-sink.vala"
	if (_callback_ != NULL) {
#line 239 "data-sink.vala"
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
#line 912 "dbus-service.c"
	} else {
#line 239 "data-sink.vala"
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
#line 239 "data-sink.vala"
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
#line 918 "dbus-service.c"
	}
#line 239 "data-sink.vala"
	g_object_unref (_message);
#line 922 "dbus-service.c"
}

static gchar**
synapse_free_desktop_dbus_proxy_list_names_finish (SynapseFreeDesktopDBus* self,
                                                   GAsyncResult* _res_,
                                                   gint* result_length1,
                                                   GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar** _result = NULL;
	gint _result_length1;
	GVariant* _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length;
	gint _tmp8__size;
	gint _tmp8__length1;
	GVariantIter _tmp9_;
	GVariant* _tmp10_;
#line 239 "data-sink.vala"
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
#line 239 "data-sink.vala"
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
#line 239 "data-sink.vala"
	g_object_unref (_inner_res);
#line 239 "data-sink.vala"
	if (!_reply_message) {
#line 239 "data-sink.vala"
		return NULL;
#line 954 "dbus-service.c"
	}
#line 239 "data-sink.vala"
	if (g_dbus_message_to_gerror (_reply_message, error)) {
#line 239 "data-sink.vala"
		g_object_unref (_reply_message);
#line 239 "data-sink.vala"
		return NULL;
#line 962 "dbus-service.c"
	}
#line 239 "data-sink.vala"
	_reply = g_dbus_message_get_body (_reply_message);
#line 239 "data-sink.vala"
	g_variant_iter_init (&_reply_iter, _reply);
#line 968 "dbus-service.c"
	_result_length1 = 0;
#line 239 "data-sink.vala"
	_tmp7_ = g_variant_iter_next_value (&_reply_iter);
#line 972 "dbus-service.c"
	_tmp8_ = g_new (gchar*, 5);
	_tmp8__length = 0;
	_tmp8__size = 4;
	_tmp8__length1 = 0;
#line 239 "data-sink.vala"
	g_variant_iter_init (&_tmp9_, _tmp7_);
#line 239 "data-sink.vala"
	for (; (_tmp10_ = g_variant_iter_next_value (&_tmp9_)) != NULL; _tmp8__length1++) {
#line 239 "data-sink.vala"
		if (_tmp8__size == _tmp8__length) {
#line 239 "data-sink.vala"
			_tmp8__size = 2 * _tmp8__size;
#line 239 "data-sink.vala"
			_tmp8_ = g_renew (gchar*, _tmp8_, _tmp8__size + 1);
#line 987 "dbus-service.c"
		}
#line 239 "data-sink.vala"
		_tmp8_[_tmp8__length++] = g_variant_dup_string (_tmp10_, NULL);
#line 239 "data-sink.vala"
		g_variant_unref (_tmp10_);
#line 993 "dbus-service.c"
	}
#line 239 "data-sink.vala"
	_result_length1 = _tmp8__length1;
#line 239 "data-sink.vala"
	_tmp8_[_tmp8__length] = NULL;
#line 239 "data-sink.vala"
	_result = _tmp8_;
#line 239 "data-sink.vala"
	g_variant_unref (_tmp7_);
#line 239 "data-sink.vala"
	*result_length1 = _result_length1;
#line 239 "data-sink.vala"
	g_object_unref (_reply_message);
#line 239 "data-sink.vala"
	return _result;
#line 1009 "dbus-service.c"
}

static void
synapse_free_desktop_dbus_proxy_list_activatable_names_async (SynapseFreeDesktopDBus* self,
                                                              GAsyncReadyCallback _callback_,
                                                              gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
#line 239 "data-sink.vala"
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.DBus", "ListActivatableNames");
#line 239 "data-sink.vala"
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
#line 239 "data-sink.vala"
	_arguments = g_variant_builder_end (&_arguments_builder);
#line 239 "data-sink.vala"
	g_dbus_message_set_body (_message, _arguments);
#line 239 "data-sink.vala"
	if (_callback_ != NULL) {
#line 239 "data-sink.vala"
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
#line 1032 "dbus-service.c"
	} else {
#line 239 "data-sink.vala"
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
#line 239 "data-sink.vala"
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
#line 1038 "dbus-service.c"
	}
#line 239 "data-sink.vala"
	g_object_unref (_message);
#line 1042 "dbus-service.c"
}

static gchar**
synapse_free_desktop_dbus_proxy_list_activatable_names_finish (SynapseFreeDesktopDBus* self,
                                                               GAsyncResult* _res_,
                                                               gint* result_length1,
                                                               GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar** _result = NULL;
	gint _result_length1;
	GVariant* _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length;
	gint _tmp12__size;
	gint _tmp12__length1;
	GVariantIter _tmp13_;
	GVariant* _tmp14_;
#line 239 "data-sink.vala"
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
#line 239 "data-sink.vala"
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
#line 239 "data-sink.vala"
	g_object_unref (_inner_res);
#line 239 "data-sink.vala"
	if (!_reply_message) {
#line 239 "data-sink.vala"
		return NULL;
#line 1074 "dbus-service.c"
	}
#line 239 "data-sink.vala"
	if (g_dbus_message_to_gerror (_reply_message, error)) {
#line 239 "data-sink.vala"
		g_object_unref (_reply_message);
#line 239 "data-sink.vala"
		return NULL;
#line 1082 "dbus-service.c"
	}
#line 239 "data-sink.vala"
	_reply = g_dbus_message_get_body (_reply_message);
#line 239 "data-sink.vala"
	g_variant_iter_init (&_reply_iter, _reply);
#line 1088 "dbus-service.c"
	_result_length1 = 0;
#line 239 "data-sink.vala"
	_tmp11_ = g_variant_iter_next_value (&_reply_iter);
#line 1092 "dbus-service.c"
	_tmp12_ = g_new (gchar*, 5);
	_tmp12__length = 0;
	_tmp12__size = 4;
	_tmp12__length1 = 0;
#line 239 "data-sink.vala"
	g_variant_iter_init (&_tmp13_, _tmp11_);
#line 239 "data-sink.vala"
	for (; (_tmp14_ = g_variant_iter_next_value (&_tmp13_)) != NULL; _tmp12__length1++) {
#line 239 "data-sink.vala"
		if (_tmp12__size == _tmp12__length) {
#line 239 "data-sink.vala"
			_tmp12__size = 2 * _tmp12__size;
#line 239 "data-sink.vala"
			_tmp12_ = g_renew (gchar*, _tmp12_, _tmp12__size + 1);
#line 1107 "dbus-service.c"
		}
#line 239 "data-sink.vala"
		_tmp12_[_tmp12__length++] = g_variant_dup_string (_tmp14_, NULL);
#line 239 "data-sink.vala"
		g_variant_unref (_tmp14_);
#line 1113 "dbus-service.c"
	}
#line 239 "data-sink.vala"
	_result_length1 = _tmp12__length1;
#line 239 "data-sink.vala"
	_tmp12_[_tmp12__length] = NULL;
#line 239 "data-sink.vala"
	_result = _tmp12_;
#line 239 "data-sink.vala"
	g_variant_unref (_tmp11_);
#line 239 "data-sink.vala"
	*result_length1 = _result_length1;
#line 239 "data-sink.vala"
	g_object_unref (_reply_message);
#line 239 "data-sink.vala"
	return _result;
#line 1129 "dbus-service.c"
}

static void
synapse_free_desktop_dbus_proxy_name_has_owner_async (SynapseFreeDesktopDBus* self,
                                                      const gchar* name,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
#line 239 "data-sink.vala"
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.DBus", "NameHasOwner");
#line 239 "data-sink.vala"
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
#line 239 "data-sink.vala"
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (name));
#line 239 "data-sink.vala"
	_arguments = g_variant_builder_end (&_arguments_builder);
#line 239 "data-sink.vala"
	g_dbus_message_set_body (_message, _arguments);
#line 239 "data-sink.vala"
	if (_callback_ != NULL) {
#line 239 "data-sink.vala"
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
#line 1155 "dbus-service.c"
	} else {
#line 239 "data-sink.vala"
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
#line 239 "data-sink.vala"
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
#line 1161 "dbus-service.c"
	}
#line 239 "data-sink.vala"
	g_object_unref (_message);
#line 1165 "dbus-service.c"
}

static gboolean
synapse_free_desktop_dbus_proxy_name_has_owner_finish (SynapseFreeDesktopDBus* self,
                                                       GAsyncResult* _res_,
                                                       GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _result = FALSE;
	GVariant* _tmp17_;
#line 239 "data-sink.vala"
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
#line 239 "data-sink.vala"
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
#line 239 "data-sink.vala"
	g_object_unref (_inner_res);
#line 239 "data-sink.vala"
	if (!_reply_message) {
#line 1187 "dbus-service.c"
		gboolean _tmp15_ = FALSE;
#line 239 "data-sink.vala"
		return _tmp15_;
#line 1191 "dbus-service.c"
	}
#line 239 "data-sink.vala"
	if (g_dbus_message_to_gerror (_reply_message, error)) {
#line 1195 "dbus-service.c"
		gboolean _tmp16_ = FALSE;
#line 239 "data-sink.vala"
		g_object_unref (_reply_message);
#line 239 "data-sink.vala"
		return _tmp16_;
#line 1201 "dbus-service.c"
	}
#line 239 "data-sink.vala"
	_reply = g_dbus_message_get_body (_reply_message);
#line 239 "data-sink.vala"
	g_variant_iter_init (&_reply_iter, _reply);
#line 239 "data-sink.vala"
	_tmp17_ = g_variant_iter_next_value (&_reply_iter);
#line 239 "data-sink.vala"
	_result = g_variant_get_boolean (_tmp17_);
#line 239 "data-sink.vala"
	g_variant_unref (_tmp17_);
#line 239 "data-sink.vala"
	g_object_unref (_reply_message);
#line 239 "data-sink.vala"
	return _result;
#line 1217 "dbus-service.c"
}

static void
synapse_free_desktop_dbus_proxy_start_service_by_name_async (SynapseFreeDesktopDBus* self,
                                                             const gchar* name,
                                                             guint32 flags,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
#line 239 "data-sink.vala"
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.DBus", "StartServiceByName");
#line 239 "data-sink.vala"
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
#line 239 "data-sink.vala"
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (name));
#line 239 "data-sink.vala"
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (flags));
#line 239 "data-sink.vala"
	_arguments = g_variant_builder_end (&_arguments_builder);
#line 239 "data-sink.vala"
	g_dbus_message_set_body (_message, _arguments);
#line 239 "data-sink.vala"
	if (_callback_ != NULL) {
#line 239 "data-sink.vala"
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
#line 1246 "dbus-service.c"
	} else {
#line 239 "data-sink.vala"
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
#line 239 "data-sink.vala"
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
#line 1252 "dbus-service.c"
	}
#line 239 "data-sink.vala"
	g_object_unref (_message);
#line 1256 "dbus-service.c"
}

static guint32
synapse_free_desktop_dbus_proxy_start_service_by_name_finish (SynapseFreeDesktopDBus* self,
                                                              GAsyncResult* _res_,
                                                              GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	guint32 _result = 0U;
	GVariant* _tmp20_;
#line 239 "data-sink.vala"
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
#line 239 "data-sink.vala"
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
#line 239 "data-sink.vala"
	g_object_unref (_inner_res);
#line 239 "data-sink.vala"
	if (!_reply_message) {
#line 1278 "dbus-service.c"
		guint32 _tmp18_ = 0U;
#line 239 "data-sink.vala"
		return _tmp18_;
#line 1282 "dbus-service.c"
	}
#line 239 "data-sink.vala"
	if (g_dbus_message_to_gerror (_reply_message, error)) {
#line 1286 "dbus-service.c"
		guint32 _tmp19_ = 0U;
#line 239 "data-sink.vala"
		g_object_unref (_reply_message);
#line 239 "data-sink.vala"
		return _tmp19_;
#line 1292 "dbus-service.c"
	}
#line 239 "data-sink.vala"
	_reply = g_dbus_message_get_body (_reply_message);
#line 239 "data-sink.vala"
	g_variant_iter_init (&_reply_iter, _reply);
#line 239 "data-sink.vala"
	_tmp20_ = g_variant_iter_next_value (&_reply_iter);
#line 239 "data-sink.vala"
	_result = g_variant_get_uint32 (_tmp20_);
#line 239 "data-sink.vala"
	g_variant_unref (_tmp20_);
#line 239 "data-sink.vala"
	g_object_unref (_reply_message);
#line 239 "data-sink.vala"
	return _result;
#line 1308 "dbus-service.c"
}

static void
synapse_free_desktop_dbus_proxy_get_name_owner_async (SynapseFreeDesktopDBus* self,
                                                      const gchar* name,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
#line 239 "data-sink.vala"
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.DBus", "GetNameOwner");
#line 239 "data-sink.vala"
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
#line 239 "data-sink.vala"
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (name));
#line 239 "data-sink.vala"
	_arguments = g_variant_builder_end (&_arguments_builder);
#line 239 "data-sink.vala"
	g_dbus_message_set_body (_message, _arguments);
#line 239 "data-sink.vala"
	if (_callback_ != NULL) {
#line 239 "data-sink.vala"
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
#line 1334 "dbus-service.c"
	} else {
#line 239 "data-sink.vala"
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
#line 239 "data-sink.vala"
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
#line 1340 "dbus-service.c"
	}
#line 239 "data-sink.vala"
	g_object_unref (_message);
#line 1344 "dbus-service.c"
}

static gchar*
synapse_free_desktop_dbus_proxy_get_name_owner_finish (SynapseFreeDesktopDBus* self,
                                                       GAsyncResult* _res_,
                                                       GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result = NULL;
	GVariant* _tmp21_;
#line 239 "data-sink.vala"
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
#line 239 "data-sink.vala"
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
#line 239 "data-sink.vala"
	g_object_unref (_inner_res);
#line 239 "data-sink.vala"
	if (!_reply_message) {
#line 239 "data-sink.vala"
		return NULL;
#line 1368 "dbus-service.c"
	}
#line 239 "data-sink.vala"
	if (g_dbus_message_to_gerror (_reply_message, error)) {
#line 239 "data-sink.vala"
		g_object_unref (_reply_message);
#line 239 "data-sink.vala"
		return NULL;
#line 1376 "dbus-service.c"
	}
#line 239 "data-sink.vala"
	_reply = g_dbus_message_get_body (_reply_message);
#line 239 "data-sink.vala"
	g_variant_iter_init (&_reply_iter, _reply);
#line 239 "data-sink.vala"
	_tmp21_ = g_variant_iter_next_value (&_reply_iter);
#line 239 "data-sink.vala"
	_result = g_variant_dup_string (_tmp21_, NULL);
#line 239 "data-sink.vala"
	g_variant_unref (_tmp21_);
#line 239 "data-sink.vala"
	g_object_unref (_reply_message);
#line 239 "data-sink.vala"
	return _result;
#line 1392 "dbus-service.c"
}

static void
synapse_free_desktop_dbus_proxy_synapse_free_desktop_dbus_interface_init (SynapseFreeDesktopDBusIface* iface)
{
#line 239 "data-sink.vala"
	iface->list_queued_owners = synapse_free_desktop_dbus_proxy_list_queued_owners_async;
#line 239 "data-sink.vala"
	iface->list_queued_owners_finish = synapse_free_desktop_dbus_proxy_list_queued_owners_finish;
#line 239 "data-sink.vala"
	iface->list_names = synapse_free_desktop_dbus_proxy_list_names_async;
#line 239 "data-sink.vala"
	iface->list_names_finish = synapse_free_desktop_dbus_proxy_list_names_finish;
#line 239 "data-sink.vala"
	iface->list_activatable_names = synapse_free_desktop_dbus_proxy_list_activatable_names_async;
#line 239 "data-sink.vala"
	iface->list_activatable_names_finish = synapse_free_desktop_dbus_proxy_list_activatable_names_finish;
#line 239 "data-sink.vala"
	iface->name_has_owner = synapse_free_desktop_dbus_proxy_name_has_owner_async;
#line 239 "data-sink.vala"
	iface->name_has_owner_finish = synapse_free_desktop_dbus_proxy_name_has_owner_finish;
#line 239 "data-sink.vala"
	iface->start_service_by_name = synapse_free_desktop_dbus_proxy_start_service_by_name_async;
#line 239 "data-sink.vala"
	iface->start_service_by_name_finish = synapse_free_desktop_dbus_proxy_start_service_by_name_finish;
#line 239 "data-sink.vala"
	iface->get_name_owner = synapse_free_desktop_dbus_proxy_get_name_owner_async;
#line 239 "data-sink.vala"
	iface->get_name_owner_finish = synapse_free_desktop_dbus_proxy_get_name_owner_finish;
#line 1422 "dbus-service.c"
}

static void
_dbus_synapse_free_desktop_dbus_list_queued_owners (SynapseFreeDesktopDBus* self,
                                                    GVariant* _parameters_,
                                                    GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	SynapseFreeDesktopDbusListQueuedOwnersReadyData* _ready_data;
	GVariant* _tmp22_;
#line 239 "data-sink.vala"
	g_variant_iter_init (&_arguments_iter, _parameters_);
#line 239 "data-sink.vala"
	_ready_data = g_slice_new0 (SynapseFreeDesktopDbusListQueuedOwnersReadyData);
#line 239 "data-sink.vala"
	_ready_data->_invocation_ = invocation;
#line 239 "data-sink.vala"
	_tmp22_ = g_variant_iter_next_value (&_arguments_iter);
#line 239 "data-sink.vala"
	_ready_data->name = g_variant_dup_string (_tmp22_, NULL);
#line 239 "data-sink.vala"
	g_variant_unref (_tmp22_);
#line 239 "data-sink.vala"
	synapse_free_desktop_dbus_list_queued_owners (self, _ready_data->name, (GAsyncReadyCallback) _dbus_synapse_free_desktop_dbus_list_queued_owners_ready, _ready_data);
#line 1447 "dbus-service.c"
	_error:
	;
}

static void
_dbus_synapse_free_desktop_dbus_list_queued_owners_ready (GObject * source_object,
                                                          GAsyncResult * _res_,
                                                          gpointer _user_data_)
{
	SynapseFreeDesktopDbusListQueuedOwnersReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	gint result_length1 = 0;
	gchar** _tmp23_;
	GVariantBuilder _tmp24_;
	gint _tmp25_;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
#line 239 "data-sink.vala"
	result = synapse_free_desktop_dbus_list_queued_owners_finish ((SynapseFreeDesktopDBus*) source_object, _res_, &result_length1, &error);
#line 239 "data-sink.vala"
	if (error) {
#line 239 "data-sink.vala"
		g_dbus_method_invocation_take_error (invocation, error);
#line 1476 "dbus-service.c"
		goto _error;
	}
#line 239 "data-sink.vala"
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
#line 239 "data-sink.vala"
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
#line 239 "data-sink.vala"
	_tmp23_ = result;
#line 239 "data-sink.vala"
	g_variant_builder_init (&_tmp24_, G_VARIANT_TYPE ("as"));
#line 239 "data-sink.vala"
	for (_tmp25_ = 0; _tmp25_ < result_length1; _tmp25_++) {
#line 239 "data-sink.vala"
		g_variant_builder_add_value (&_tmp24_, g_variant_new_string (*_tmp23_));
#line 239 "data-sink.vala"
		_tmp23_++;
#line 1493 "dbus-service.c"
	}
#line 239 "data-sink.vala"
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp24_));
#line 239 "data-sink.vala"
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
#line 239 "data-sink.vala"
	_reply = g_variant_builder_end (&_reply_builder);
#line 239 "data-sink.vala"
	g_dbus_message_set_body (_reply_message, _reply);
#line 239 "data-sink.vala"
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
#line 239 "data-sink.vala"
	g_object_unref (invocation);
#line 239 "data-sink.vala"
	g_object_unref (_reply_message);
#line 1509 "dbus-service.c"
	_error:
#line 239 "data-sink.vala"
	_g_free0 (_ready_data->name);
#line 239 "data-sink.vala"
	g_slice_free (SynapseFreeDesktopDbusListQueuedOwnersReadyData, _ready_data);
#line 1515 "dbus-service.c"
}

static void
_dbus_synapse_free_desktop_dbus_list_names (SynapseFreeDesktopDBus* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	SynapseFreeDesktopDbusListNamesReadyData* _ready_data;
#line 239 "data-sink.vala"
	g_variant_iter_init (&_arguments_iter, _parameters_);
#line 239 "data-sink.vala"
	_ready_data = g_slice_new0 (SynapseFreeDesktopDbusListNamesReadyData);
#line 239 "data-sink.vala"
	_ready_data->_invocation_ = invocation;
#line 239 "data-sink.vala"
	synapse_free_desktop_dbus_list_names (self, (GAsyncReadyCallback) _dbus_synapse_free_desktop_dbus_list_names_ready, _ready_data);
#line 1533 "dbus-service.c"
}

static void
_dbus_synapse_free_desktop_dbus_list_names_ready (GObject * source_object,
                                                  GAsyncResult * _res_,
                                                  gpointer _user_data_)
{
	SynapseFreeDesktopDbusListNamesReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	gint result_length1 = 0;
	gchar** _tmp26_;
	GVariantBuilder _tmp27_;
	gint _tmp28_;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
#line 239 "data-sink.vala"
	result = synapse_free_desktop_dbus_list_names_finish ((SynapseFreeDesktopDBus*) source_object, _res_, &result_length1, &error);
#line 239 "data-sink.vala"
	if (error) {
#line 239 "data-sink.vala"
		g_dbus_method_invocation_take_error (invocation, error);
#line 1560 "dbus-service.c"
		goto _error;
	}
#line 239 "data-sink.vala"
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
#line 239 "data-sink.vala"
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
#line 239 "data-sink.vala"
	_tmp26_ = result;
#line 239 "data-sink.vala"
	g_variant_builder_init (&_tmp27_, G_VARIANT_TYPE ("as"));
#line 239 "data-sink.vala"
	for (_tmp28_ = 0; _tmp28_ < result_length1; _tmp28_++) {
#line 239 "data-sink.vala"
		g_variant_builder_add_value (&_tmp27_, g_variant_new_string (*_tmp26_));
#line 239 "data-sink.vala"
		_tmp26_++;
#line 1577 "dbus-service.c"
	}
#line 239 "data-sink.vala"
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp27_));
#line 239 "data-sink.vala"
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
#line 239 "data-sink.vala"
	_reply = g_variant_builder_end (&_reply_builder);
#line 239 "data-sink.vala"
	g_dbus_message_set_body (_reply_message, _reply);
#line 239 "data-sink.vala"
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
#line 239 "data-sink.vala"
	g_object_unref (invocation);
#line 239 "data-sink.vala"
	g_object_unref (_reply_message);
#line 1593 "dbus-service.c"
	_error:
#line 239 "data-sink.vala"
	g_slice_free (SynapseFreeDesktopDbusListNamesReadyData, _ready_data);
#line 1597 "dbus-service.c"
}

static void
_dbus_synapse_free_desktop_dbus_list_activatable_names (SynapseFreeDesktopDBus* self,
                                                        GVariant* _parameters_,
                                                        GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	SynapseFreeDesktopDbusListActivatableNamesReadyData* _ready_data;
#line 239 "data-sink.vala"
	g_variant_iter_init (&_arguments_iter, _parameters_);
#line 239 "data-sink.vala"
	_ready_data = g_slice_new0 (SynapseFreeDesktopDbusListActivatableNamesReadyData);
#line 239 "data-sink.vala"
	_ready_data->_invocation_ = invocation;
#line 239 "data-sink.vala"
	synapse_free_desktop_dbus_list_activatable_names (self, (GAsyncReadyCallback) _dbus_synapse_free_desktop_dbus_list_activatable_names_ready, _ready_data);
#line 1615 "dbus-service.c"
}

static void
_dbus_synapse_free_desktop_dbus_list_activatable_names_ready (GObject * source_object,
                                                              GAsyncResult * _res_,
                                                              gpointer _user_data_)
{
	SynapseFreeDesktopDbusListActivatableNamesReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	gint result_length1 = 0;
	gchar** _tmp29_;
	GVariantBuilder _tmp30_;
	gint _tmp31_;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
#line 239 "data-sink.vala"
	result = synapse_free_desktop_dbus_list_activatable_names_finish ((SynapseFreeDesktopDBus*) source_object, _res_, &result_length1, &error);
#line 239 "data-sink.vala"
	if (error) {
#line 239 "data-sink.vala"
		g_dbus_method_invocation_take_error (invocation, error);
#line 1642 "dbus-service.c"
		goto _error;
	}
#line 239 "data-sink.vala"
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
#line 239 "data-sink.vala"
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
#line 239 "data-sink.vala"
	_tmp29_ = result;
#line 239 "data-sink.vala"
	g_variant_builder_init (&_tmp30_, G_VARIANT_TYPE ("as"));
#line 239 "data-sink.vala"
	for (_tmp31_ = 0; _tmp31_ < result_length1; _tmp31_++) {
#line 239 "data-sink.vala"
		g_variant_builder_add_value (&_tmp30_, g_variant_new_string (*_tmp29_));
#line 239 "data-sink.vala"
		_tmp29_++;
#line 1659 "dbus-service.c"
	}
#line 239 "data-sink.vala"
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp30_));
#line 239 "data-sink.vala"
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
#line 239 "data-sink.vala"
	_reply = g_variant_builder_end (&_reply_builder);
#line 239 "data-sink.vala"
	g_dbus_message_set_body (_reply_message, _reply);
#line 239 "data-sink.vala"
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
#line 239 "data-sink.vala"
	g_object_unref (invocation);
#line 239 "data-sink.vala"
	g_object_unref (_reply_message);
#line 1675 "dbus-service.c"
	_error:
#line 239 "data-sink.vala"
	g_slice_free (SynapseFreeDesktopDbusListActivatableNamesReadyData, _ready_data);
#line 1679 "dbus-service.c"
}

static void
_dbus_synapse_free_desktop_dbus_name_has_owner (SynapseFreeDesktopDBus* self,
                                                GVariant* _parameters_,
                                                GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	SynapseFreeDesktopDbusNameHasOwnerReadyData* _ready_data;
	GVariant* _tmp32_;
#line 239 "data-sink.vala"
	g_variant_iter_init (&_arguments_iter, _parameters_);
#line 239 "data-sink.vala"
	_ready_data = g_slice_new0 (SynapseFreeDesktopDbusNameHasOwnerReadyData);
#line 239 "data-sink.vala"
	_ready_data->_invocation_ = invocation;
#line 239 "data-sink.vala"
	_tmp32_ = g_variant_iter_next_value (&_arguments_iter);
#line 239 "data-sink.vala"
	_ready_data->name = g_variant_dup_string (_tmp32_, NULL);
#line 239 "data-sink.vala"
	g_variant_unref (_tmp32_);
#line 239 "data-sink.vala"
	synapse_free_desktop_dbus_name_has_owner (self, _ready_data->name, (GAsyncReadyCallback) _dbus_synapse_free_desktop_dbus_name_has_owner_ready, _ready_data);
#line 1704 "dbus-service.c"
	_error:
	;
}

static void
_dbus_synapse_free_desktop_dbus_name_has_owner_ready (GObject * source_object,
                                                      GAsyncResult * _res_,
                                                      gpointer _user_data_)
{
	SynapseFreeDesktopDbusNameHasOwnerReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
#line 239 "data-sink.vala"
	result = synapse_free_desktop_dbus_name_has_owner_finish ((SynapseFreeDesktopDBus*) source_object, _res_, &error);
#line 239 "data-sink.vala"
	if (error) {
#line 239 "data-sink.vala"
		g_dbus_method_invocation_take_error (invocation, error);
#line 1729 "dbus-service.c"
		goto _error;
	}
#line 239 "data-sink.vala"
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
#line 239 "data-sink.vala"
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
#line 239 "data-sink.vala"
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
#line 239 "data-sink.vala"
	_reply = g_variant_builder_end (&_reply_builder);
#line 239 "data-sink.vala"
	g_dbus_message_set_body (_reply_message, _reply);
#line 239 "data-sink.vala"
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
#line 239 "data-sink.vala"
	g_object_unref (invocation);
#line 239 "data-sink.vala"
	g_object_unref (_reply_message);
#line 1748 "dbus-service.c"
	_error:
#line 239 "data-sink.vala"
	_g_free0 (_ready_data->name);
#line 239 "data-sink.vala"
	g_slice_free (SynapseFreeDesktopDbusNameHasOwnerReadyData, _ready_data);
#line 1754 "dbus-service.c"
}

static void
_dbus_synapse_free_desktop_dbus_start_service_by_name (SynapseFreeDesktopDBus* self,
                                                       GVariant* _parameters_,
                                                       GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	SynapseFreeDesktopDbusStartServiceByNameReadyData* _ready_data;
	GVariant* _tmp33_;
	GVariant* _tmp34_;
#line 239 "data-sink.vala"
	g_variant_iter_init (&_arguments_iter, _parameters_);
#line 239 "data-sink.vala"
	_ready_data = g_slice_new0 (SynapseFreeDesktopDbusStartServiceByNameReadyData);
#line 239 "data-sink.vala"
	_ready_data->_invocation_ = invocation;
#line 239 "data-sink.vala"
	_tmp33_ = g_variant_iter_next_value (&_arguments_iter);
#line 239 "data-sink.vala"
	_ready_data->name = g_variant_dup_string (_tmp33_, NULL);
#line 239 "data-sink.vala"
	g_variant_unref (_tmp33_);
#line 239 "data-sink.vala"
	_tmp34_ = g_variant_iter_next_value (&_arguments_iter);
#line 239 "data-sink.vala"
	_ready_data->flags = g_variant_get_uint32 (_tmp34_);
#line 239 "data-sink.vala"
	g_variant_unref (_tmp34_);
#line 239 "data-sink.vala"
	synapse_free_desktop_dbus_start_service_by_name (self, _ready_data->name, _ready_data->flags, (GAsyncReadyCallback) _dbus_synapse_free_desktop_dbus_start_service_by_name_ready, _ready_data);
#line 1786 "dbus-service.c"
	_error:
	;
}

static void
_dbus_synapse_free_desktop_dbus_start_service_by_name_ready (GObject * source_object,
                                                             GAsyncResult * _res_,
                                                             gpointer _user_data_)
{
	SynapseFreeDesktopDbusStartServiceByNameReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint32 result;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
#line 239 "data-sink.vala"
	result = synapse_free_desktop_dbus_start_service_by_name_finish ((SynapseFreeDesktopDBus*) source_object, _res_, &error);
#line 239 "data-sink.vala"
	if (error) {
#line 239 "data-sink.vala"
		g_dbus_method_invocation_take_error (invocation, error);
#line 1811 "dbus-service.c"
		goto _error;
	}
#line 239 "data-sink.vala"
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
#line 239 "data-sink.vala"
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
#line 239 "data-sink.vala"
	g_variant_builder_add_value (&_reply_builder, g_variant_new_uint32 (result));
#line 239 "data-sink.vala"
	_reply = g_variant_builder_end (&_reply_builder);
#line 239 "data-sink.vala"
	g_dbus_message_set_body (_reply_message, _reply);
#line 239 "data-sink.vala"
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
#line 239 "data-sink.vala"
	g_object_unref (invocation);
#line 239 "data-sink.vala"
	g_object_unref (_reply_message);
#line 1830 "dbus-service.c"
	_error:
#line 239 "data-sink.vala"
	_g_free0 (_ready_data->name);
#line 239 "data-sink.vala"
	g_slice_free (SynapseFreeDesktopDbusStartServiceByNameReadyData, _ready_data);
#line 1836 "dbus-service.c"
}

static void
_dbus_synapse_free_desktop_dbus_get_name_owner (SynapseFreeDesktopDBus* self,
                                                GVariant* _parameters_,
                                                GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	SynapseFreeDesktopDbusGetNameOwnerReadyData* _ready_data;
	GVariant* _tmp35_;
#line 239 "data-sink.vala"
	g_variant_iter_init (&_arguments_iter, _parameters_);
#line 239 "data-sink.vala"
	_ready_data = g_slice_new0 (SynapseFreeDesktopDbusGetNameOwnerReadyData);
#line 239 "data-sink.vala"
	_ready_data->_invocation_ = invocation;
#line 239 "data-sink.vala"
	_tmp35_ = g_variant_iter_next_value (&_arguments_iter);
#line 239 "data-sink.vala"
	_ready_data->name = g_variant_dup_string (_tmp35_, NULL);
#line 239 "data-sink.vala"
	g_variant_unref (_tmp35_);
#line 239 "data-sink.vala"
	synapse_free_desktop_dbus_get_name_owner (self, _ready_data->name, (GAsyncReadyCallback) _dbus_synapse_free_desktop_dbus_get_name_owner_ready, _ready_data);
#line 1861 "dbus-service.c"
	_error:
	;
}

static void
_dbus_synapse_free_desktop_dbus_get_name_owner_ready (GObject * source_object,
                                                      GAsyncResult * _res_,
                                                      gpointer _user_data_)
{
	SynapseFreeDesktopDbusGetNameOwnerReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
#line 239 "data-sink.vala"
	result = synapse_free_desktop_dbus_get_name_owner_finish ((SynapseFreeDesktopDBus*) source_object, _res_, &error);
#line 239 "data-sink.vala"
	if (error) {
#line 239 "data-sink.vala"
		g_dbus_method_invocation_take_error (invocation, error);
#line 1886 "dbus-service.c"
		goto _error;
	}
#line 239 "data-sink.vala"
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
#line 239 "data-sink.vala"
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
#line 239 "data-sink.vala"
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
#line 239 "data-sink.vala"
	_g_free0 (result);
#line 239 "data-sink.vala"
	_reply = g_variant_builder_end (&_reply_builder);
#line 239 "data-sink.vala"
	g_dbus_message_set_body (_reply_message, _reply);
#line 239 "data-sink.vala"
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
#line 239 "data-sink.vala"
	g_object_unref (invocation);
#line 239 "data-sink.vala"
	g_object_unref (_reply_message);
#line 1907 "dbus-service.c"
	_error:
#line 239 "data-sink.vala"
	_g_free0 (_ready_data->name);
#line 239 "data-sink.vala"
	g_slice_free (SynapseFreeDesktopDbusGetNameOwnerReadyData, _ready_data);
#line 1913 "dbus-service.c"
}

static void
synapse_free_desktop_dbus_dbus_interface_method_call (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* method_name,
                                                      GVariant* parameters,
                                                      GDBusMethodInvocation* invocation,
                                                      gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
#line 239 "data-sink.vala"
	if (strcmp (method_name, "ListQueuedOwners") == 0) {
#line 239 "data-sink.vala"
		_dbus_synapse_free_desktop_dbus_list_queued_owners (object, parameters, invocation);
#line 1934 "dbus-service.c"
	} else if (strcmp (method_name, "ListNames") == 0) {
#line 239 "data-sink.vala"
		_dbus_synapse_free_desktop_dbus_list_names (object, parameters, invocation);
#line 1938 "dbus-service.c"
	} else if (strcmp (method_name, "ListActivatableNames") == 0) {
#line 239 "data-sink.vala"
		_dbus_synapse_free_desktop_dbus_list_activatable_names (object, parameters, invocation);
#line 1942 "dbus-service.c"
	} else if (strcmp (method_name, "NameHasOwner") == 0) {
#line 239 "data-sink.vala"
		_dbus_synapse_free_desktop_dbus_name_has_owner (object, parameters, invocation);
#line 1946 "dbus-service.c"
	} else if (strcmp (method_name, "StartServiceByName") == 0) {
#line 239 "data-sink.vala"
		_dbus_synapse_free_desktop_dbus_start_service_by_name (object, parameters, invocation);
#line 1950 "dbus-service.c"
	} else if (strcmp (method_name, "GetNameOwner") == 0) {
#line 239 "data-sink.vala"
		_dbus_synapse_free_desktop_dbus_get_name_owner (object, parameters, invocation);
#line 1954 "dbus-service.c"
	} else {
#line 239 "data-sink.vala"
		g_object_unref (invocation);
#line 1958 "dbus-service.c"
	}
}

static GVariant*
synapse_free_desktop_dbus_dbus_interface_get_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GError** error,
                                                       gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
#line 239 "data-sink.vala"
	return NULL;
#line 1977 "dbus-service.c"
}

static gboolean
synapse_free_desktop_dbus_dbus_interface_set_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GVariant* value,
                                                       GError** error,
                                                       gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
#line 239 "data-sink.vala"
	return FALSE;
#line 1996 "dbus-service.c"
}

static void
_dbus_synapse_free_desktop_dbus_name_owner_changed (GObject* _sender,
                                                    const gchar* name,
                                                    const gchar* old_owner,
                                                    const gchar* new_owner,
                                                    gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
#line 239 "data-sink.vala"
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
#line 239 "data-sink.vala"
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (name));
#line 239 "data-sink.vala"
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (old_owner));
#line 239 "data-sink.vala"
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (new_owner));
#line 239 "data-sink.vala"
	_arguments = g_variant_builder_end (&_arguments_builder);
#line 239 "data-sink.vala"
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.DBus", "NameOwnerChanged", _arguments, NULL);
#line 2024 "dbus-service.c"
}

guint
synapse_free_desktop_dbus_register_object (gpointer object,
                                           GDBusConnection* connection,
                                           const gchar* path,
                                           GError** error)
{
	guint result;
	gpointer *data;
#line 239 "data-sink.vala"
	data = g_new (gpointer, 3);
#line 239 "data-sink.vala"
	data[0] = g_object_ref (object);
#line 239 "data-sink.vala"
	data[1] = g_object_ref (connection);
#line 239 "data-sink.vala"
	data[2] = g_strdup (path);
#line 239 "data-sink.vala"
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_synapse_free_desktop_dbus_dbus_interface_info), &_synapse_free_desktop_dbus_dbus_interface_vtable, data, _synapse_free_desktop_dbus_unregister_object, error);
#line 239 "data-sink.vala"
	if (!result) {
#line 239 "data-sink.vala"
		return 0;
#line 2049 "dbus-service.c"
	}
#line 239 "data-sink.vala"
	g_signal_connect (object, "name-owner-changed", (GCallback) _dbus_synapse_free_desktop_dbus_name_owner_changed, data);
#line 239 "data-sink.vala"
	return result;
#line 2055 "dbus-service.c"
}

static void
_synapse_free_desktop_dbus_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
#line 239 "data-sink.vala"
	g_signal_handlers_disconnect_by_func (data[0], _dbus_synapse_free_desktop_dbus_name_owner_changed, data);
#line 239 "data-sink.vala"
	g_object_unref (data[0]);
#line 239 "data-sink.vala"
	g_object_unref (data[1]);
#line 239 "data-sink.vala"
	g_free (data[2]);
#line 239 "data-sink.vala"
	g_free (data);
#line 2073 "dbus-service.c"
}

static inline gpointer
synapse_dbus_service_get_instance_private (SynapseDBusService* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDBusService_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 53 "dbus-service.vala"
	return self ? g_object_ref (self) : NULL;
#line 2087 "dbus-service.c"
}

SynapseDBusService*
synapse_dbus_service_get_default (void)
{
	SynapseDBusService* _tmp0_ = NULL;
	SynapseDBusService* _tmp1_;
	SynapseDBusService* _tmp2_;
	SynapseDBusService* _tmp4_;
	SynapseDBusService* result;
#line 53 "dbus-service.vala"
	_tmp1_ = synapse_dbus_service_instance;
#line 53 "dbus-service.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 53 "dbus-service.vala"
	_tmp0_ = _tmp2_;
#line 53 "dbus-service.vala"
	if (_tmp0_ == NULL) {
#line 2106 "dbus-service.c"
		SynapseDBusService* _tmp3_;
#line 53 "dbus-service.vala"
		_tmp3_ = synapse_dbus_service_new ();
#line 53 "dbus-service.vala"
		_g_object_unref0 (_tmp0_);
#line 53 "dbus-service.vala"
		_tmp0_ = _tmp3_;
#line 2114 "dbus-service.c"
	}
#line 53 "dbus-service.vala"
	_tmp4_ = _tmp0_;
#line 53 "dbus-service.vala"
	_tmp0_ = NULL;
#line 53 "dbus-service.vala"
	result = _tmp4_;
#line 53 "dbus-service.vala"
	_g_object_unref0 (_tmp0_);
#line 53 "dbus-service.vala"
	return result;
#line 2126 "dbus-service.c"
}

static SynapseDBusService*
synapse_dbus_service_construct (GType object_type)
{
	SynapseDBusService * self = NULL;
#line 56 "dbus-service.vala"
	self = (SynapseDBusService*) g_object_new (object_type, NULL);
#line 56 "dbus-service.vala"
	return self;
#line 2137 "dbus-service.c"
}

static SynapseDBusService*
synapse_dbus_service_new (void)
{
#line 56 "dbus-service.vala"
	return synapse_dbus_service_construct (SYNAPSE_TYPE_DBUS_SERVICE);
#line 2145 "dbus-service.c"
}

static void
synapse_dbus_service_name_owner_changed (SynapseDBusService* self,
                                         SynapseFreeDesktopDBus* sender,
                                         const gchar* name,
                                         const gchar* old_owner,
                                         const gchar* new_owner)
{
#line 77 "dbus-service.vala"
	g_return_if_fail (self != NULL);
#line 77 "dbus-service.vala"
	g_return_if_fail (sender != NULL);
#line 77 "dbus-service.vala"
	g_return_if_fail (name != NULL);
#line 77 "dbus-service.vala"
	g_return_if_fail (old_owner != NULL);
#line 77 "dbus-service.vala"
	g_return_if_fail (new_owner != NULL);
#line 82 "dbus-service.vala"
	if (g_str_has_prefix (name, ":")) {
#line 82 "dbus-service.vala"
		return;
#line 2169 "dbus-service.c"
	}
#line 84 "dbus-service.vala"
	if (g_strcmp0 (old_owner, "") == 0) {
#line 2173 "dbus-service.c"
		GeeSet* _tmp0_;
#line 86 "dbus-service.vala"
		_tmp0_ = self->priv->owned_names;
#line 86 "dbus-service.vala"
		gee_collection_add ((GeeCollection*) _tmp0_, name);
#line 87 "dbus-service.vala"
		g_signal_emit (self, synapse_dbus_service_signals[SYNAPSE_DBUS_SERVICE_OWNER_CHANGED_SIGNAL], 0, name, TRUE);
#line 2181 "dbus-service.c"
	} else {
#line 89 "dbus-service.vala"
		if (g_strcmp0 (new_owner, "") == 0) {
#line 2185 "dbus-service.c"
			GeeSet* _tmp1_;
#line 91 "dbus-service.vala"
			_tmp1_ = self->priv->owned_names;
#line 91 "dbus-service.vala"
			gee_collection_remove ((GeeCollection*) _tmp1_, name);
#line 92 "dbus-service.vala"
			g_signal_emit (self, synapse_dbus_service_signals[SYNAPSE_DBUS_SERVICE_OWNER_CHANGED_SIGNAL], 0, name, FALSE);
#line 2193 "dbus-service.c"
		}
	}
}

gboolean
synapse_dbus_service_name_has_owner (SynapseDBusService* self,
                                     const gchar* name)
{
	GeeSet* _tmp0_;
	gboolean result;
#line 98 "dbus-service.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 98 "dbus-service.vala"
	g_return_val_if_fail (name != NULL, FALSE);
#line 100 "dbus-service.vala"
	_tmp0_ = self->priv->owned_names;
#line 100 "dbus-service.vala"
	result = gee_collection_contains ((GeeCollection*) _tmp0_, name);
#line 100 "dbus-service.vala"
	return result;
#line 2214 "dbus-service.c"
}

gboolean
synapse_dbus_service_name_is_activatable (SynapseDBusService* self,
                                          const gchar* name)
{
	GeeSet* _tmp0_;
	gboolean result;
#line 103 "dbus-service.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 103 "dbus-service.vala"
	g_return_val_if_fail (name != NULL, FALSE);
#line 105 "dbus-service.vala"
	_tmp0_ = self->priv->activatable_names;
#line 105 "dbus-service.vala"
	result = gee_collection_contains ((GeeCollection*) _tmp0_, name);
#line 105 "dbus-service.vala"
	return result;
#line 2233 "dbus-service.c"
}

gboolean
synapse_dbus_service_service_is_available (SynapseDBusService* self,
                                           const gchar* name)
{
	GeeSet* _tmp0_;
	gboolean result;
#line 108 "dbus-service.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 108 "dbus-service.vala"
	g_return_val_if_fail (name != NULL, FALSE);
#line 110 "dbus-service.vala"
	_tmp0_ = self->priv->system_activatable_names;
#line 110 "dbus-service.vala"
	result = gee_collection_contains ((GeeCollection*) _tmp0_, name);
#line 110 "dbus-service.vala"
	return result;
#line 2252 "dbus-service.c"
}

static void
synapse_dbus_service_initialize_data_free (gpointer _data)
{
	SynapseDbusServiceInitializeData* _data_;
	_data_ = _data;
#line 41 "dbus-service.vala"
	_g_object_unref0 (_data_->self);
#line 41 "dbus-service.vala"
	g_slice_free (SynapseDbusServiceInitializeData, _data_);
#line 2264 "dbus-service.c"
}

void
synapse_dbus_service_initialize (SynapseDBusService* self,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	SynapseDbusServiceInitializeData* _data_;
	SynapseDBusService* _tmp0_;
#line 41 "dbus-service.vala"
	g_return_if_fail (self != NULL);
#line 41 "dbus-service.vala"
	_data_ = g_slice_new0 (SynapseDbusServiceInitializeData);
#line 41 "dbus-service.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 41 "dbus-service.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_dbus_service_initialize_data_free);
#line 41 "dbus-service.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 41 "dbus-service.vala"
	_data_->self = _tmp0_;
#line 41 "dbus-service.vala"
	synapse_dbus_service_initialize_co (_data_);
#line 2288 "dbus-service.c"
}

void
synapse_dbus_service_initialize_finish (SynapseDBusService* self,
                                        GAsyncResult* _res_)
{
	SynapseDbusServiceInitializeData* _data_;
#line 41 "dbus-service.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 2298 "dbus-service.c"
}

static void
synapse_dbus_service_initialize_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	SynapseDbusServiceInitializeData* _data_;
#line 116 "dbus-service.vala"
	_data_ = _user_data_;
#line 116 "dbus-service.vala"
	_data_->_source_object_ = source_object;
#line 116 "dbus-service.vala"
	_data_->_res_ = _res_;
#line 116 "dbus-service.vala"
	synapse_dbus_service_initialize_co (_data_);
#line 2315 "dbus-service.c"
}

static void
_synapse_dbus_service_name_owner_changed_synapse_free_desktop_dbus_name_owner_changed (SynapseFreeDesktopDBus* _sender,
                                                                                       const gchar* name,
                                                                                       const gchar* old_owner,
                                                                                       const gchar* new_owner,
                                                                                       gpointer self)
{
#line 126 "dbus-service.vala"
	synapse_dbus_service_name_owner_changed ((SynapseDBusService*) self, _sender, name, old_owner, new_owner);
#line 2327 "dbus-service.c"
}

static gboolean
synapse_dbus_service_initialize_co (SynapseDbusServiceInitializeData* _data_)
{
#line 113 "dbus-service.vala"
	switch (_data_->_state_) {
#line 113 "dbus-service.vala"
		case 0:
#line 2337 "dbus-service.c"
		goto _state_0;
#line 113 "dbus-service.vala"
		case 1:
#line 2341 "dbus-service.c"
		goto _state_1;
#line 113 "dbus-service.vala"
		case 2:
#line 2345 "dbus-service.c"
		goto _state_2;
#line 113 "dbus-service.vala"
		case 3:
#line 2349 "dbus-service.c"
		goto _state_3;
#line 113 "dbus-service.vala"
		case 4:
#line 2353 "dbus-service.c"
		goto _state_4;
		default:
#line 113 "dbus-service.vala"
		g_assert_not_reached ();
#line 2358 "dbus-service.c"
	}
	_state_0:
#line 115 "dbus-service.vala"
	_data_->_tmp0_ = _data_->self->priv->init_once;
#line 115 "dbus-service.vala"
	if (synapse_utils_async_once_is_initialized (_data_->_tmp0_)) {
#line 115 "dbus-service.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 115 "dbus-service.vala"
		if (_data_->_state_ != 0) {
#line 115 "dbus-service.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 115 "dbus-service.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2373 "dbus-service.c"
			}
		}
#line 115 "dbus-service.vala"
		g_object_unref (_data_->_async_result);
#line 115 "dbus-service.vala"
		return FALSE;
#line 2380 "dbus-service.c"
	}
#line 116 "dbus-service.vala"
	_data_->_tmp1_ = _data_->self->priv->init_once;
#line 116 "dbus-service.vala"
	_data_->_state_ = 1;
#line 116 "dbus-service.vala"
	synapse_utils_async_once_enter (_data_->_tmp1_, synapse_dbus_service_initialize_ready, _data_);
#line 116 "dbus-service.vala"
	return FALSE;
#line 2390 "dbus-service.c"
	_state_1:
#line 116 "dbus-service.vala"
	_data_->is_locked = synapse_utils_async_once_enter_finish (_data_->_tmp1_, _data_->_res_);
#line 117 "dbus-service.vala"
	if (!_data_->is_locked) {
#line 117 "dbus-service.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 117 "dbus-service.vala"
		if (_data_->_state_ != 0) {
#line 117 "dbus-service.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 117 "dbus-service.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2404 "dbus-service.c"
			}
		}
#line 117 "dbus-service.vala"
		g_object_unref (_data_->_async_result);
#line 117 "dbus-service.vala"
		return FALSE;
#line 2411 "dbus-service.c"
	}
#line 119 "dbus-service.vala"
	_data_->names_length1 = 0;
#line 119 "dbus-service.vala"
	_data_->_names_size_ = 0;
#line 2417 "dbus-service.c"
	{
#line 122 "dbus-service.vala"
		_data_->_tmp3_ = (SynapseFreeDesktopDBus*) g_initable_new (SYNAPSE_TYPE_FREE_DESKTOP_DBUS_PROXY, NULL, &_data_->_inner_error0_, "g-flags", 0, "g-name", SYNAPSE_FREE_DESKTOP_DBUS_UNIQUE_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", SYNAPSE_FREE_DESKTOP_DBUS_OBJECT_PATH, "g-interface-name", "org.freedesktop.DBus", NULL);
#line 122 "dbus-service.vala"
		_data_->_tmp2_ = (SynapseFreeDesktopDBus*) _data_->_tmp3_;
#line 122 "dbus-service.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 2425 "dbus-service.c"
			goto __catch0_g_error;
		}
#line 122 "dbus-service.vala"
		_data_->_tmp4_ = _data_->_tmp2_;
#line 122 "dbus-service.vala"
		_data_->_tmp2_ = NULL;
#line 122 "dbus-service.vala"
		_g_object_unref0 (_data_->self->priv->proxy);
#line 122 "dbus-service.vala"
		_data_->self->priv->proxy = _data_->_tmp4_;
#line 126 "dbus-service.vala"
		_data_->_tmp5_ = _data_->self->priv->proxy;
#line 126 "dbus-service.vala"
		g_signal_connect_object (_data_->_tmp5_, "name-owner-changed", (GCallback) _synapse_dbus_service_name_owner_changed_synapse_free_desktop_dbus_name_owner_changed, _data_->self, 0);
#line 127 "dbus-service.vala"
		_data_->_tmp7_ = _data_->self->priv->proxy;
#line 127 "dbus-service.vala"
		_data_->_tmp8_ = 0;
#line 127 "dbus-service.vala"
		_data_->_state_ = 2;
#line 127 "dbus-service.vala"
		synapse_free_desktop_dbus_list_names (_data_->_tmp7_, synapse_dbus_service_initialize_ready, _data_);
#line 127 "dbus-service.vala"
		return FALSE;
#line 2450 "dbus-service.c"
		_state_2:
#line 127 "dbus-service.vala"
		_data_->_tmp9_ = synapse_free_desktop_dbus_list_names_finish (_data_->_tmp7_, _data_->_res_, &_data_->_tmp8_, &_data_->_inner_error0_);
#line 127 "dbus-service.vala"
		_data_->_tmp6_ = _data_->_tmp9_;
#line 127 "dbus-service.vala"
		_data_->_tmp6__length1 = _data_->_tmp8_;
#line 127 "dbus-service.vala"
		_data_->__tmp6__size_ = _data_->_tmp6__length1;
#line 127 "dbus-service.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 127 "dbus-service.vala"
			_g_object_unref0 (_data_->_tmp2_);
#line 2464 "dbus-service.c"
			goto __catch0_g_error;
		}
#line 127 "dbus-service.vala"
		_data_->_tmp10_ = _data_->_tmp6_;
#line 127 "dbus-service.vala"
		_data_->_tmp10__length1 = _data_->_tmp6__length1;
#line 127 "dbus-service.vala"
		_data_->_tmp6_ = NULL;
#line 127 "dbus-service.vala"
		_data_->_tmp6__length1 = 0;
#line 127 "dbus-service.vala"
		_data_->names = (_vala_array_free (_data_->names, _data_->names_length1, (GDestroyNotify) g_free), NULL);
#line 127 "dbus-service.vala"
		_data_->names = _data_->_tmp10_;
#line 127 "dbus-service.vala"
		_data_->names_length1 = _data_->_tmp10__length1;
#line 127 "dbus-service.vala"
		_data_->_names_size_ = _data_->names_length1;
#line 128 "dbus-service.vala"
		_data_->_tmp11_ = _data_->names;
#line 128 "dbus-service.vala"
		_data_->_tmp11__length1 = _data_->names_length1;
#line 2487 "dbus-service.c"
		{
#line 128 "dbus-service.vala"
			_data_->name_collection_length1 = 0;
#line 128 "dbus-service.vala"
			_data_->_name_collection_size_ = 0;
#line 128 "dbus-service.vala"
			_data_->name_collection = _data_->_tmp11_;
#line 128 "dbus-service.vala"
			_data_->name_collection_length1 = _data_->_tmp11__length1;
#line 128 "dbus-service.vala"
			for (_data_->name_it = 0; _data_->name_it < _data_->name_collection_length1; _data_->name_it = _data_->name_it + 1) {
#line 128 "dbus-service.vala"
				_data_->name = _data_->name_collection[_data_->name_it];
#line 2501 "dbus-service.c"
				{
#line 130 "dbus-service.vala"
					_data_->_tmp12_ = _data_->name;
#line 130 "dbus-service.vala"
					if (g_str_has_prefix (_data_->_tmp12_, ":")) {
#line 130 "dbus-service.vala"
						continue;
#line 2509 "dbus-service.c"
					}
#line 131 "dbus-service.vala"
					_data_->_tmp13_ = _data_->self->priv->owned_names;
#line 131 "dbus-service.vala"
					_data_->_tmp14_ = _data_->name;
#line 131 "dbus-service.vala"
					gee_collection_add ((GeeCollection*) _data_->_tmp13_, _data_->_tmp14_);
#line 2517 "dbus-service.c"
				}
			}
		}
#line 134 "dbus-service.vala"
		_data_->_tmp16_ = _data_->self->priv->proxy;
#line 134 "dbus-service.vala"
		_data_->_tmp17_ = 0;
#line 134 "dbus-service.vala"
		_data_->_state_ = 3;
#line 134 "dbus-service.vala"
		synapse_free_desktop_dbus_list_activatable_names (_data_->_tmp16_, synapse_dbus_service_initialize_ready, _data_);
#line 134 "dbus-service.vala"
		return FALSE;
#line 2531 "dbus-service.c"
		_state_3:
#line 134 "dbus-service.vala"
		_data_->_tmp18_ = synapse_free_desktop_dbus_list_activatable_names_finish (_data_->_tmp16_, _data_->_res_, &_data_->_tmp17_, &_data_->_inner_error0_);
#line 134 "dbus-service.vala"
		_data_->_tmp15_ = _data_->_tmp18_;
#line 134 "dbus-service.vala"
		_data_->_tmp15__length1 = _data_->_tmp17_;
#line 134 "dbus-service.vala"
		_data_->__tmp15__size_ = _data_->_tmp15__length1;
#line 134 "dbus-service.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 134 "dbus-service.vala"
			_data_->_tmp6_ = (_vala_array_free (_data_->_tmp6_, _data_->_tmp6__length1, (GDestroyNotify) g_free), NULL);
#line 134 "dbus-service.vala"
			_g_object_unref0 (_data_->_tmp2_);
#line 2547 "dbus-service.c"
			goto __catch0_g_error;
		}
#line 134 "dbus-service.vala"
		_data_->_tmp19_ = _data_->_tmp15_;
#line 134 "dbus-service.vala"
		_data_->_tmp19__length1 = _data_->_tmp15__length1;
#line 134 "dbus-service.vala"
		_data_->_tmp15_ = NULL;
#line 134 "dbus-service.vala"
		_data_->_tmp15__length1 = 0;
#line 134 "dbus-service.vala"
		_data_->names = (_vala_array_free (_data_->names, _data_->names_length1, (GDestroyNotify) g_free), NULL);
#line 134 "dbus-service.vala"
		_data_->names = _data_->_tmp19_;
#line 134 "dbus-service.vala"
		_data_->names_length1 = _data_->_tmp19__length1;
#line 134 "dbus-service.vala"
		_data_->_names_size_ = _data_->names_length1;
#line 135 "dbus-service.vala"
		_data_->_tmp20_ = _data_->names;
#line 135 "dbus-service.vala"
		_data_->_tmp20__length1 = _data_->names_length1;
#line 2570 "dbus-service.c"
		{
#line 135 "dbus-service.vala"
			_data_->session_act_collection_length1 = 0;
#line 135 "dbus-service.vala"
			_data_->_session_act_collection_size_ = 0;
#line 135 "dbus-service.vala"
			_data_->session_act_collection = _data_->_tmp20_;
#line 135 "dbus-service.vala"
			_data_->session_act_collection_length1 = _data_->_tmp20__length1;
#line 135 "dbus-service.vala"
			for (_data_->session_act_it = 0; _data_->session_act_it < _data_->session_act_collection_length1; _data_->session_act_it = _data_->session_act_it + 1) {
#line 135 "dbus-service.vala"
				_data_->session_act = _data_->session_act_collection[_data_->session_act_it];
#line 2584 "dbus-service.c"
				{
#line 137 "dbus-service.vala"
					_data_->_tmp21_ = _data_->self->priv->activatable_names;
#line 137 "dbus-service.vala"
					_data_->_tmp22_ = _data_->session_act;
#line 137 "dbus-service.vala"
					gee_collection_add ((GeeCollection*) _data_->_tmp21_, _data_->_tmp22_);
#line 2592 "dbus-service.c"
				}
			}
		}
#line 120 "dbus-service.vala"
		_data_->_tmp15_ = (_vala_array_free (_data_->_tmp15_, _data_->_tmp15__length1, (GDestroyNotify) g_free), NULL);
#line 120 "dbus-service.vala"
		_data_->_tmp6_ = (_vala_array_free (_data_->_tmp6_, _data_->_tmp6__length1, (GDestroyNotify) g_free), NULL);
#line 120 "dbus-service.vala"
		_g_object_unref0 (_data_->_tmp2_);
#line 2602 "dbus-service.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 120 "dbus-service.vala"
		_data_->err = _data_->_inner_error0_;
#line 120 "dbus-service.vala"
		_data_->_inner_error0_ = NULL;
#line 142 "dbus-service.vala"
		_data_->_tmp23_ = _data_->err;
#line 142 "dbus-service.vala"
		_data_->_tmp24_ = _data_->_tmp23_->message;
#line 142 "dbus-service.vala"
		g_warning ("dbus-service.vala:142: %s", _data_->_tmp24_);
#line 120 "dbus-service.vala"
		_g_error_free0 (_data_->err);
#line 2619 "dbus-service.c"
	}
	__finally0:
#line 120 "dbus-service.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 120 "dbus-service.vala"
		_data_->names = (_vala_array_free (_data_->names, _data_->names_length1, (GDestroyNotify) g_free), NULL);
#line 120 "dbus-service.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 120 "dbus-service.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 120 "dbus-service.vala"
		g_object_unref (_data_->_async_result);
#line 120 "dbus-service.vala"
		return FALSE;
#line 2634 "dbus-service.c"
	}
	{
#line 147 "dbus-service.vala"
		_data_->_tmp25_ = (SynapseFreeDesktopDBus*) g_initable_new (SYNAPSE_TYPE_FREE_DESKTOP_DBUS_PROXY, NULL, &_data_->_inner_error0_, "g-flags", 0, "g-name", SYNAPSE_FREE_DESKTOP_DBUS_UNIQUE_NAME, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", SYNAPSE_FREE_DESKTOP_DBUS_OBJECT_PATH, "g-interface-name", "org.freedesktop.DBus", NULL);
#line 147 "dbus-service.vala"
		_data_->sys_proxy = (SynapseFreeDesktopDBus*) _data_->_tmp25_;
#line 147 "dbus-service.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 2643 "dbus-service.c"
			goto __catch1_g_error;
		}
#line 152 "dbus-service.vala"
		_data_->_tmp27_ = _data_->sys_proxy;
#line 152 "dbus-service.vala"
		_data_->_tmp28_ = 0;
#line 152 "dbus-service.vala"
		_data_->_state_ = 4;
#line 152 "dbus-service.vala"
		synapse_free_desktop_dbus_list_activatable_names (_data_->_tmp27_, synapse_dbus_service_initialize_ready, _data_);
#line 152 "dbus-service.vala"
		return FALSE;
#line 2656 "dbus-service.c"
		_state_4:
#line 152 "dbus-service.vala"
		_data_->_tmp29_ = synapse_free_desktop_dbus_list_activatable_names_finish (_data_->_tmp27_, _data_->_res_, &_data_->_tmp28_, &_data_->_inner_error0_);
#line 152 "dbus-service.vala"
		_data_->_tmp26_ = _data_->_tmp29_;
#line 152 "dbus-service.vala"
		_data_->_tmp26__length1 = _data_->_tmp28_;
#line 152 "dbus-service.vala"
		_data_->__tmp26__size_ = _data_->_tmp26__length1;
#line 152 "dbus-service.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 152 "dbus-service.vala"
			_g_object_unref0 (_data_->sys_proxy);
#line 2670 "dbus-service.c"
			goto __catch1_g_error;
		}
#line 152 "dbus-service.vala"
		_data_->_tmp30_ = _data_->_tmp26_;
#line 152 "dbus-service.vala"
		_data_->_tmp30__length1 = _data_->_tmp26__length1;
#line 152 "dbus-service.vala"
		_data_->_tmp26_ = NULL;
#line 152 "dbus-service.vala"
		_data_->_tmp26__length1 = 0;
#line 152 "dbus-service.vala"
		_data_->names = (_vala_array_free (_data_->names, _data_->names_length1, (GDestroyNotify) g_free), NULL);
#line 152 "dbus-service.vala"
		_data_->names = _data_->_tmp30_;
#line 152 "dbus-service.vala"
		_data_->names_length1 = _data_->_tmp30__length1;
#line 152 "dbus-service.vala"
		_data_->_names_size_ = _data_->names_length1;
#line 153 "dbus-service.vala"
		_data_->_tmp31_ = _data_->names;
#line 153 "dbus-service.vala"
		_data_->_tmp31__length1 = _data_->names_length1;
#line 2693 "dbus-service.c"
		{
#line 153 "dbus-service.vala"
			_data_->system_act_collection_length1 = 0;
#line 153 "dbus-service.vala"
			_data_->_system_act_collection_size_ = 0;
#line 153 "dbus-service.vala"
			_data_->system_act_collection = _data_->_tmp31_;
#line 153 "dbus-service.vala"
			_data_->system_act_collection_length1 = _data_->_tmp31__length1;
#line 153 "dbus-service.vala"
			for (_data_->system_act_it = 0; _data_->system_act_it < _data_->system_act_collection_length1; _data_->system_act_it = _data_->system_act_it + 1) {
#line 153 "dbus-service.vala"
				_data_->system_act = _data_->system_act_collection[_data_->system_act_it];
#line 2707 "dbus-service.c"
				{
#line 155 "dbus-service.vala"
					_data_->_tmp32_ = _data_->self->priv->system_activatable_names;
#line 155 "dbus-service.vala"
					_data_->_tmp33_ = _data_->system_act;
#line 155 "dbus-service.vala"
					gee_collection_add ((GeeCollection*) _data_->_tmp32_, _data_->_tmp33_);
#line 2715 "dbus-service.c"
				}
			}
		}
#line 145 "dbus-service.vala"
		_data_->_tmp26_ = (_vala_array_free (_data_->_tmp26_, _data_->_tmp26__length1, (GDestroyNotify) g_free), NULL);
#line 145 "dbus-service.vala"
		_g_object_unref0 (_data_->sys_proxy);
#line 2723 "dbus-service.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
#line 145 "dbus-service.vala"
		_data_->sys_err = _data_->_inner_error0_;
#line 145 "dbus-service.vala"
		_data_->_inner_error0_ = NULL;
#line 160 "dbus-service.vala"
		_data_->_tmp34_ = _data_->sys_err;
#line 160 "dbus-service.vala"
		_data_->_tmp35_ = _data_->_tmp34_->message;
#line 160 "dbus-service.vala"
		g_warning ("dbus-service.vala:160: %s", _data_->_tmp35_);
#line 145 "dbus-service.vala"
		_g_error_free0 (_data_->sys_err);
#line 2740 "dbus-service.c"
	}
	__finally1:
#line 145 "dbus-service.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 145 "dbus-service.vala"
		_data_->names = (_vala_array_free (_data_->names, _data_->names_length1, (GDestroyNotify) g_free), NULL);
#line 145 "dbus-service.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 145 "dbus-service.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 145 "dbus-service.vala"
		g_object_unref (_data_->_async_result);
#line 145 "dbus-service.vala"
		return FALSE;
#line 2755 "dbus-service.c"
	}
#line 162 "dbus-service.vala"
	_data_->_tmp36_ = _data_->self->priv->init_once;
#line 162 "dbus-service.vala"
	synapse_utils_async_once_leave (_data_->_tmp36_, (gpointer) ((gintptr) TRUE));
#line 113 "dbus-service.vala"
	_data_->names = (_vala_array_free (_data_->names, _data_->names_length1, (GDestroyNotify) g_free), NULL);
#line 113 "dbus-service.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 113 "dbus-service.vala"
	if (_data_->_state_ != 0) {
#line 113 "dbus-service.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 113 "dbus-service.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2771 "dbus-service.c"
		}
	}
#line 113 "dbus-service.vala"
	g_object_unref (_data_->_async_result);
#line 113 "dbus-service.vala"
	return FALSE;
#line 2778 "dbus-service.c"
}

static void
g_cclosure_user_marshal_VOID__STRING_BOOLEAN (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_BOOLEAN) (gpointer data1, const char* arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 41 "dbus-service.vala"
	g_return_if_fail (n_param_values == 3);
#line 41 "dbus-service.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 41 "dbus-service.vala"
		data1 = closure->data;
#line 41 "dbus-service.vala"
		data2 = param_values->data[0].v_pointer;
#line 2803 "dbus-service.c"
	} else {
#line 41 "dbus-service.vala"
		data1 = param_values->data[0].v_pointer;
#line 41 "dbus-service.vala"
		data2 = closure->data;
#line 2809 "dbus-service.c"
	}
#line 41 "dbus-service.vala"
	callback = (GMarshalFunc_VOID__STRING_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
#line 41 "dbus-service.vala"
	callback (data1, g_value_get_string (param_values + 1), g_value_get_boolean (param_values + 2), data2);
#line 2815 "dbus-service.c"
}

static GObject *
synapse_dbus_service_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseDBusService * self;
	GeeHashSet* _tmp0_;
	GeeHashSet* _tmp1_;
	GeeHashSet* _tmp2_;
	SynapseUtilsAsyncOnce* _tmp3_;
#line 61 "dbus-service.vala"
	parent_class = G_OBJECT_CLASS (synapse_dbus_service_parent_class);
#line 61 "dbus-service.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 61 "dbus-service.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DBUS_SERVICE, SynapseDBusService);
#line 63 "dbus-service.vala"
	synapse_dbus_service_instance = self;
#line 64 "dbus-service.vala"
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 64 "dbus-service.vala"
	_g_object_unref0 (self->priv->owned_names);
#line 64 "dbus-service.vala"
	self->priv->owned_names = (GeeSet*) _tmp0_;
#line 65 "dbus-service.vala"
	_tmp1_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 65 "dbus-service.vala"
	_g_object_unref0 (self->priv->activatable_names);
#line 65 "dbus-service.vala"
	self->priv->activatable_names = (GeeSet*) _tmp1_;
#line 66 "dbus-service.vala"
	_tmp2_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 66 "dbus-service.vala"
	_g_object_unref0 (self->priv->system_activatable_names);
#line 66 "dbus-service.vala"
	self->priv->system_activatable_names = (GeeSet*) _tmp2_;
#line 67 "dbus-service.vala"
	_tmp3_ = synapse_utils_async_once_new (G_TYPE_BOOLEAN, NULL, NULL);
#line 67 "dbus-service.vala"
	_synapse_utils_async_once_unref0 (self->priv->init_once);
#line 67 "dbus-service.vala"
	self->priv->init_once = _tmp3_;
#line 69 "dbus-service.vala"
	synapse_dbus_service_initialize (self, NULL, NULL);
#line 61 "dbus-service.vala"
	return obj;
#line 2866 "dbus-service.c"
}

static void
synapse_dbus_service_class_init (SynapseDBusServiceClass * klass,
                                 gpointer klass_data)
{
#line 41 "dbus-service.vala"
	synapse_dbus_service_parent_class = g_type_class_peek_parent (klass);
#line 41 "dbus-service.vala"
	g_type_class_adjust_private_offset (klass, &SynapseDBusService_private_offset);
#line 41 "dbus-service.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_dbus_service_constructor;
#line 41 "dbus-service.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_dbus_service_finalize;
#line 41 "dbus-service.vala"
	synapse_dbus_service_signals[SYNAPSE_DBUS_SERVICE_OWNER_CHANGED_SIGNAL] = g_signal_new ("owner-changed", SYNAPSE_TYPE_DBUS_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_BOOLEAN);
#line 2883 "dbus-service.c"
}

static void
synapse_dbus_service_instance_init (SynapseDBusService * self,
                                    gpointer klass)
{
#line 41 "dbus-service.vala"
	self->priv = synapse_dbus_service_get_instance_private (self);
#line 2892 "dbus-service.c"
}

static void
synapse_dbus_service_finalize (GObject * obj)
{
	SynapseDBusService * self;
#line 41 "dbus-service.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DBUS_SERVICE, SynapseDBusService);
#line 74 "dbus-service.vala"
	synapse_dbus_service_instance = NULL;
#line 43 "dbus-service.vala"
	_g_object_unref0 (self->priv->proxy);
#line 44 "dbus-service.vala"
	_g_object_unref0 (self->priv->owned_names);
#line 45 "dbus-service.vala"
	_g_object_unref0 (self->priv->activatable_names);
#line 46 "dbus-service.vala"
	_g_object_unref0 (self->priv->system_activatable_names);
#line 48 "dbus-service.vala"
	_synapse_utils_async_once_unref0 (self->priv->init_once);
#line 41 "dbus-service.vala"
	G_OBJECT_CLASS (synapse_dbus_service_parent_class)->finalize (obj);
#line 2915 "dbus-service.c"
}

static GType
synapse_dbus_service_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDBusServiceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_dbus_service_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDBusService), 0, (GInstanceInitFunc) synapse_dbus_service_instance_init, NULL };
	GType synapse_dbus_service_type_id;
	synapse_dbus_service_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDBusService", &g_define_type_info, 0);
	SynapseDBusService_private_offset = g_type_add_instance_private (synapse_dbus_service_type_id, sizeof (SynapseDBusServicePrivate));
	return synapse_dbus_service_type_id;
}

GType
synapse_dbus_service_get_type (void)
{
	static volatile gsize synapse_dbus_service_type_id__once = 0;
	if (g_once_init_enter (&synapse_dbus_service_type_id__once)) {
		GType synapse_dbus_service_type_id;
		synapse_dbus_service_type_id = synapse_dbus_service_get_type_once ();
		g_once_init_leave (&synapse_dbus_service_type_id__once, synapse_dbus_service_type_id);
	}
	return synapse_dbus_service_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
#line 239 "data-sink.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 2947 "dbus-service.c"
		gssize i;
#line 239 "data-sink.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 239 "data-sink.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 239 "data-sink.vala"
				destroy_func (((gpointer*) array)[i]);
#line 2955 "dbus-service.c"
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
#line 239 "data-sink.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 239 "data-sink.vala"
	g_free (array);
#line 2970 "dbus-service.c"
}

