/* utils.c generated by valac 0.56.17, the Vala compiler
 * generated from utils.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 * Copyright (C) 2010 Alberto Aldegheri <albyrock87+dev@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *             Alberto Aldegheri <albyrock87+dev@gmail.com>
 *
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <synapse-core.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	SYNAPSE_GUI_STYLE_TYPE_BG,
	SYNAPSE_GUI_STYLE_TYPE_FG,
	SYNAPSE_GUI_STYLE_TYPE_BASE,
	SYNAPSE_GUI_STYLE_TYPE_TEXT
} SynapseGuiStyleType;

#define SYNAPSE_GUI_TYPE_STYLE_TYPE (synapse_gui_style_type_get_type ())
typedef enum  {
	SYNAPSE_GUI_MOD_NORMAL,
	SYNAPSE_GUI_MOD_LIGHTER,
	SYNAPSE_GUI_MOD_LIGHTEST,
	SYNAPSE_GUI_MOD_DARKER,
	SYNAPSE_GUI_MOD_DARKEST,
	SYNAPSE_GUI_MOD_INVERTED
} SynapseGuiMod;

#define SYNAPSE_GUI_TYPE_MOD (synapse_gui_mod_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))

#define SYNAPSE_GUI_UTILS_TYPE_COLOR_HELPER (synapse_gui_utils_color_helper_get_type ())
#define SYNAPSE_GUI_UTILS_COLOR_HELPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_GUI_UTILS_TYPE_COLOR_HELPER, SynapseGuiUtilsColorHelper))
#define SYNAPSE_GUI_UTILS_COLOR_HELPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_GUI_UTILS_TYPE_COLOR_HELPER, SynapseGuiUtilsColorHelperClass))
#define SYNAPSE_GUI_UTILS_IS_COLOR_HELPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_GUI_UTILS_TYPE_COLOR_HELPER))
#define SYNAPSE_GUI_UTILS_IS_COLOR_HELPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_GUI_UTILS_TYPE_COLOR_HELPER))
#define SYNAPSE_GUI_UTILS_COLOR_HELPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_GUI_UTILS_TYPE_COLOR_HELPER, SynapseGuiUtilsColorHelperClass))

typedef struct _SynapseGuiUtilsColorHelper SynapseGuiUtilsColorHelper;
typedef struct _SynapseGuiUtilsColorHelperClass SynapseGuiUtilsColorHelperClass;
typedef struct _SynapseGuiUtilsColorHelperPrivate SynapseGuiUtilsColorHelperPrivate;

#define SYNAPSE_GUI_UTILS_COLOR_HELPER_TYPE_COLOR (synapse_gui_utils_color_helper_color_get_type ())
#define SYNAPSE_GUI_UTILS_COLOR_HELPER_COLOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_GUI_UTILS_COLOR_HELPER_TYPE_COLOR, SynapseGuiUtilsColorHelperColor))
#define SYNAPSE_GUI_UTILS_COLOR_HELPER_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_GUI_UTILS_COLOR_HELPER_TYPE_COLOR, SynapseGuiUtilsColorHelperColorClass))
#define SYNAPSE_GUI_UTILS_COLOR_HELPER_IS_COLOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_GUI_UTILS_COLOR_HELPER_TYPE_COLOR))
#define SYNAPSE_GUI_UTILS_COLOR_HELPER_IS_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_GUI_UTILS_COLOR_HELPER_TYPE_COLOR))
#define SYNAPSE_GUI_UTILS_COLOR_HELPER_COLOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_GUI_UTILS_COLOR_HELPER_TYPE_COLOR, SynapseGuiUtilsColorHelperColorClass))

typedef struct _SynapseGuiUtilsColorHelperColor SynapseGuiUtilsColorHelperColor;
typedef struct _SynapseGuiUtilsColorHelperColorClass SynapseGuiUtilsColorHelperColorClass;
#define _synapse_gui_utils_color_helper_unref0(var) ((var == NULL) ? NULL : (var = (synapse_gui_utils_color_helper_unref (var), NULL)))
typedef struct _SynapseGuiUtilsColorHelperColorPrivate SynapseGuiUtilsColorHelperColorPrivate;
#define _synapse_gui_utils_color_helper_color_unref0(var) ((var == NULL) ? NULL : (var = (synapse_gui_utils_color_helper_color_unref (var), NULL)))
typedef struct _SynapseGuiUtilsColorHelperParamSpecColor SynapseGuiUtilsColorHelperParamSpecColor;
typedef struct _SynapseGuiUtilsParamSpecColorHelper SynapseGuiUtilsParamSpecColorHelper;
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
typedef struct _Block6Data Block6Data;

struct _SynapseGuiUtilsColorHelper {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SynapseGuiUtilsColorHelperPrivate * priv;
};

struct _SynapseGuiUtilsColorHelperClass {
	GTypeClass parent_class;
	void (*finalize) (SynapseGuiUtilsColorHelper *self);
};

struct _SynapseGuiUtilsColorHelperPrivate {
	GeeMap* colormap;
	GtkStyleContext* fg_context;
	GtkStyleContext* bg_context;
	gchar* current_theme;
};

struct _SynapseGuiUtilsColorHelperColor {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SynapseGuiUtilsColorHelperColorPrivate * priv;
	gdouble r;
	gdouble g;
	gdouble b;
};

struct _SynapseGuiUtilsColorHelperColorClass {
	GTypeClass parent_class;
	void (*finalize) (SynapseGuiUtilsColorHelperColor *self);
};

struct _SynapseGuiUtilsColorHelperParamSpecColor {
	GParamSpec parent_instance;
};

struct _SynapseGuiUtilsParamSpecColorHelper {
	GParamSpec parent_instance;
};

struct _Block6Data {
	int _ref_count_;
	gint i;
	GtkWindow* window;
};

VALA_EXTERN gchar* synapse_gui_utils_home_directory;
gchar* synapse_gui_utils_home_directory = NULL;
VALA_EXTERN glong synapse_gui_utils_home_directory_length;
glong synapse_gui_utils_home_directory_length = (glong) 0;
static gint SynapseGuiUtilsColorHelper_private_offset;
static gpointer synapse_gui_utils_color_helper_parent_class = NULL;
static SynapseGuiUtilsColorHelper* synapse_gui_utils_color_helper_instance;
static SynapseGuiUtilsColorHelper* synapse_gui_utils_color_helper_instance = NULL;
static gpointer synapse_gui_utils_color_helper_color_parent_class = NULL;

VALA_EXTERN GType synapse_gui_style_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType synapse_gui_mod_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* synapse_gui_utils_markup_string_with_search (const gchar* text,
                                                    const gchar* pattern,
                                                    const gchar* size,
                                                    gboolean show_not_found);
VALA_EXTERN gchar* synapse_gui_utils_get_printable_description (SynapseMatch* match);
VALA_EXTERN void synapse_gui_utils_update_layout_rtl (PangoLayout* layout,
                                          GtkTextDirection rtl);
VALA_EXTERN void synapse_gui_utils_get_draw_position (gint* x,
                                          gint* y,
                                          gint* width,
                                          gint* height,
                                          PangoLayout* layout,
                                          gboolean rtl,
                                          gint area_width,
                                          gint area_height,
                                          gfloat xalign,
                                          gfloat yalign);
VALA_EXTERN void synapse_gui_utils_make_transparent_bg (GtkWidget* widget);
VALA_EXTERN void synapse_gui_utils_on_style_updated (GtkWidget* widget);
VALA_EXTERN void synapse_gui_utils_on_composited_change (GtkWidget* widget);
VALA_EXTERN void synapse_gui_utils_ensure_transparent_bg (GtkWidget* widget);
static void _synapse_gui_utils_make_transparent_bg_gtk_widget_realize (GtkWidget* _sender,
                                                                gpointer self);
static void _synapse_gui_utils_on_style_updated_gtk_widget_style_updated (GtkWidget* _sender,
                                                                   gpointer self);
static void _synapse_gui_utils_on_composited_change_gtk_widget_composited_changed (GtkWidget* _sender,
                                                                            gpointer self);
VALA_EXTERN void synapse_gui_utils_get_current_monitor_geometry (GdkScreen* screen,
                                                     GdkRectangle* result);
VALA_EXTERN void synapse_gui_utils_move_window_to_center (GtkWindow* win);
VALA_EXTERN void synapse_gui_utils_rgb_invert_color (gdouble* r,
                                         gdouble* g,
                                         gdouble* b);
VALA_EXTERN void synapse_gui_utils_cairo_arrow (cairo_t* ctx,
                                    gboolean rtl,
                                    gdouble x,
                                    gdouble y,
                                    gdouble w,
                                    gdouble h);
VALA_EXTERN void synapse_gui_utils_cairo_rounded_rect (cairo_t* ctx,
                                           gdouble x,
                                           gdouble y,
                                           gdouble w,
                                           gdouble h,
                                           gdouble r);
VALA_EXTERN void synapse_gui_utils_add_shadow_stops (cairo_pattern_t* pat,
                                         gdouble r,
                                         gdouble g,
                                         gdouble b,
                                         gdouble size,
                                         gdouble alpha);
VALA_EXTERN void synapse_gui_utils_cairo_make_shadow_for_rect (cairo_t* ctx,
                                                   gdouble x1,
                                                   gdouble y1,
                                                   gdouble w,
                                                   gdouble h,
                                                   gdouble rad,
                                                   gdouble r,
                                                   gdouble g,
                                                   gdouble b,
                                                   gdouble size);
VALA_EXTERN gpointer synapse_gui_utils_color_helper_ref (gpointer instance);
VALA_EXTERN void synapse_gui_utils_color_helper_unref (gpointer instance);
VALA_EXTERN GParamSpec* synapse_gui_utils_param_spec_color_helper (const gchar* name,
                                                       const gchar* nick,
                                                       const gchar* blurb,
                                                       GType object_type,
                                                       GParamFlags flags);
VALA_EXTERN void synapse_gui_utils_value_set_color_helper (GValue* value,
                                               gpointer v_object);
VALA_EXTERN void synapse_gui_utils_value_take_color_helper (GValue* value,
                                                gpointer v_object);
VALA_EXTERN gpointer synapse_gui_utils_value_get_color_helper (const GValue* value);
VALA_EXTERN GType synapse_gui_utils_color_helper_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseGuiUtilsColorHelper, synapse_gui_utils_color_helper_unref)
static gpointer synapse_gui_utils_color_helper_color_ref (gpointer instance);
static void synapse_gui_utils_color_helper_color_unref (gpointer instance);
static GParamSpec* synapse_gui_utils_color_helper_param_spec_color (const gchar* name,
                                                             const gchar* nick,
                                                             const gchar* blurb,
                                                             GType object_type,
                                                             GParamFlags flags) G_GNUC_UNUSED ;
static void synapse_gui_utils_color_helper_value_set_color (GValue* value,
                                                     gpointer v_object) G_GNUC_UNUSED ;
static void synapse_gui_utils_color_helper_value_take_color (GValue* value,
                                                      gpointer v_object) G_GNUC_UNUSED ;
static gpointer synapse_gui_utils_color_helper_value_get_color (const GValue* value) G_GNUC_UNUSED ;
static GType synapse_gui_utils_color_helper_color_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseGuiUtilsColorHelperColor, synapse_gui_utils_color_helper_color_unref)
VALA_EXTERN SynapseGuiUtilsColorHelper* synapse_gui_utils_color_helper_get_default (void);
static SynapseGuiUtilsColorHelper* synapse_gui_utils_color_helper_new (void);
static SynapseGuiUtilsColorHelper* synapse_gui_utils_color_helper_construct (GType object_type);
static void synapse_gui_utils_color_helper_theme_changed (SynapseGuiUtilsColorHelper* self,
                                                   GObject* o,
                                                   GParamSpec* p);
static void _synapse_gui_utils_color_helper_theme_changed_g_object_notify (GObject* _sender,
                                                                    GParamSpec* pspec,
                                                                    gpointer self);
VALA_EXTERN void synapse_gui_utils_color_helper_get_color_colorized (SynapseGuiUtilsColorHelper* self,
                                                         gdouble* red,
                                                         gdouble* green,
                                                         gdouble* blue,
                                                         SynapseGuiStyleType t,
                                                         GtkStateFlags st,
                                                         SynapseGuiMod mod);
static SynapseGuiUtilsColorHelperColor* synapse_gui_utils_color_helper_get_color_from_map (SynapseGuiUtilsColorHelper* self,
                                                                                    SynapseGuiStyleType t,
                                                                                    GtkStateFlags st,
                                                                                    SynapseGuiMod mod);
static void synapse_gui_utils_color_helper_color_colorize (gdouble* r,
                                                    gdouble* g,
                                                    gdouble* b,
                                                    gdouble cr,
                                                    gdouble cg,
                                                    gdouble cb);
static SynapseGuiUtilsColorHelperColor* synapse_gui_utils_color_helper_color_new (void);
static SynapseGuiUtilsColorHelperColor* synapse_gui_utils_color_helper_color_construct (GType object_type);
static void synapse_gui_utils_color_helper_color_init_from_gdk_color (SynapseGuiUtilsColorHelperColor* self,
                                                               GdkRGBA* col);
static void synapse_gui_utils_color_helper_color_apply_mod (SynapseGuiUtilsColorHelperColor* self,
                                                     SynapseGuiMod k);
VALA_EXTERN void synapse_gui_utils_color_helper_set_source_rgba (SynapseGuiUtilsColorHelper* self,
                                                     cairo_t* ctx,
                                                     gdouble alpha,
                                                     SynapseGuiStyleType t,
                                                     GtkStateFlags st,
                                                     SynapseGuiMod mod);
VALA_EXTERN void synapse_gui_utils_color_helper_add_color_stop_rgba (SynapseGuiUtilsColorHelper* self,
                                                         cairo_pattern_t* pat,
                                                         gdouble val,
                                                         gdouble alpha,
                                                         SynapseGuiStyleType t,
                                                         GtkStateFlags st,
                                                         SynapseGuiMod mod);
VALA_EXTERN void synapse_gui_utils_color_helper_get_rgb_from_mix (SynapseGuiUtilsColorHelper* self,
                                                      SynapseGuiStyleType t,
                                                      GtkStateFlags st,
                                                      SynapseGuiMod mod,
                                                      SynapseGuiStyleType t2,
                                                      GtkStateFlags st2,
                                                      SynapseGuiMod mod2,
                                                      gdouble mix_pct,
                                                      gdouble* r,
                                                      gdouble* g,
                                                      gdouble* b);
static void synapse_gui_utils_color_helper_color_mix (SynapseGuiUtilsColorHelperColor* self,
                                               SynapseGuiUtilsColorHelperColor* target,
                                               gdouble mix_pct,
                                               gdouble* r,
                                               gdouble* g,
                                               gdouble* b);
VALA_EXTERN void synapse_gui_utils_color_helper_get_rgb (SynapseGuiUtilsColorHelper* self,
                                             gdouble* r,
                                             gdouble* g,
                                             gdouble* b,
                                             SynapseGuiStyleType t,
                                             GtkStateFlags st,
                                             SynapseGuiMod mod);
VALA_EXTERN gboolean synapse_gui_utils_color_helper_is_dark_color (SynapseGuiUtilsColorHelper* self,
                                                       SynapseGuiStyleType t,
                                                       GtkStateFlags st,
                                                       SynapseGuiMod mod);
static gboolean synapse_gui_utils_color_helper_color_is_dark_color (SynapseGuiUtilsColorHelperColor* self);
static void synapse_gui_utils_color_helper_color_shade (gdouble* r,
                                                 gdouble* g,
                                                 gdouble* b,
                                                 gdouble k);
static void synapse_gui_utils_color_helper_color_murrine_rgb_to_hls (gdouble* r,
                                                              gdouble* g,
                                                              gdouble* b);
static void synapse_gui_utils_color_helper_color_murrine_hls_to_rgb (gdouble* h,
                                                              gdouble* l,
                                                              gdouble* s);
static void synapse_gui_utils_color_helper_color_finalize (SynapseGuiUtilsColorHelperColor * obj);
static GType synapse_gui_utils_color_helper_color_get_type_once (void);
static void synapse_gui_utils_color_helper_finalize (SynapseGuiUtilsColorHelper * obj);
static GType synapse_gui_utils_color_helper_get_type_once (void);
VALA_EXTERN gboolean synapse_gui_utils_is_point_in_mask (GtkWidget* w,
                                             gint x,
                                             gint y);
VALA_EXTERN void synapse_gui_utils_present_window (GtkWindow* window);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static gboolean __lambda16_ (Block6Data* _data6_);
VALA_EXTERN gboolean synapse_gui_utils_try_grab_window (GtkWindow* window);
static gboolean ___lambda16__gsource_func (gpointer self);
VALA_EXTERN void synapse_gui_utils_unpresent_window (GtkWindow* window);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static GType
synapse_gui_style_type_get_type_once (void)
{
	static const GEnumValue values[] = {{SYNAPSE_GUI_STYLE_TYPE_BG, "SYNAPSE_GUI_STYLE_TYPE_BG", "bg"}, {SYNAPSE_GUI_STYLE_TYPE_FG, "SYNAPSE_GUI_STYLE_TYPE_FG", "fg"}, {SYNAPSE_GUI_STYLE_TYPE_BASE, "SYNAPSE_GUI_STYLE_TYPE_BASE", "base"}, {SYNAPSE_GUI_STYLE_TYPE_TEXT, "SYNAPSE_GUI_STYLE_TYPE_TEXT", "text"}, {0, NULL, NULL}};
	GType synapse_gui_style_type_type_id;
	synapse_gui_style_type_type_id = g_enum_register_static ("SynapseGuiStyleType", values);
	return synapse_gui_style_type_type_id;
}

GType
synapse_gui_style_type_get_type (void)
{
	static volatile gsize synapse_gui_style_type_type_id__once = 0;
	if (g_once_init_enter (&synapse_gui_style_type_type_id__once)) {
		GType synapse_gui_style_type_type_id;
		synapse_gui_style_type_type_id = synapse_gui_style_type_get_type_once ();
		g_once_init_leave (&synapse_gui_style_type_type_id__once, synapse_gui_style_type_type_id);
	}
	return synapse_gui_style_type_type_id__once;
}

static GType
synapse_gui_mod_get_type_once (void)
{
	static const GEnumValue values[] = {{SYNAPSE_GUI_MOD_NORMAL, "SYNAPSE_GUI_MOD_NORMAL", "normal"}, {SYNAPSE_GUI_MOD_LIGHTER, "SYNAPSE_GUI_MOD_LIGHTER", "lighter"}, {SYNAPSE_GUI_MOD_LIGHTEST, "SYNAPSE_GUI_MOD_LIGHTEST", "lightest"}, {SYNAPSE_GUI_MOD_DARKER, "SYNAPSE_GUI_MOD_DARKER", "darker"}, {SYNAPSE_GUI_MOD_DARKEST, "SYNAPSE_GUI_MOD_DARKEST", "darkest"}, {SYNAPSE_GUI_MOD_INVERTED, "SYNAPSE_GUI_MOD_INVERTED", "inverted"}, {0, NULL, NULL}};
	GType synapse_gui_mod_type_id;
	synapse_gui_mod_type_id = g_enum_register_static ("SynapseGuiMod", values);
	return synapse_gui_mod_type_id;
}

GType
synapse_gui_mod_get_type (void)
{
	static volatile gsize synapse_gui_mod_type_id__once = 0;
	if (g_once_init_enter (&synapse_gui_mod_type_id__once)) {
		GType synapse_gui_mod_type_id;
		synapse_gui_mod_type_id = synapse_gui_mod_get_type_once ();
		g_once_init_leave (&synapse_gui_mod_type_id__once, synapse_gui_mod_type_id);
	}
	return synapse_gui_mod_type_id__once;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
#line 1501 "glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1501 "glib-2.0.vapi"
	end = _tmp0_;
#line 1502 "glib-2.0.vapi"
	_tmp1_ = end;
#line 1502 "glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1503 "glib-2.0.vapi"
		result = maxlen;
#line 1503 "glib-2.0.vapi"
		return result;
#line 430 "utils.c"
	} else {
		gchar* _tmp2_;
#line 1505 "glib-2.0.vapi"
		_tmp2_ = end;
#line 1505 "glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1505 "glib-2.0.vapi"
		return result;
#line 439 "utils.c"
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
#line 1512 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1514 "glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1514 "glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 458 "utils.c"
	} else {
#line 1514 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 462 "utils.c"
	}
#line 1514 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1516 "glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 468 "utils.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1518 "glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1518 "glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1518 "glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 478 "utils.c"
	}
#line 1521 "glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 1522 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1523 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 486 "utils.c"
	} else {
#line 1525 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 490 "utils.c"
	}
#line 1527 "glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 1528 "glib-2.0.vapi"
		len = string_length - offset;
#line 496 "utils.c"
	}
#line 1530 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1531 "glib-2.0.vapi"
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1531 "glib-2.0.vapi"
	result = _tmp3_;
#line 1531 "glib-2.0.vapi"
	return result;
#line 506 "utils.c"
}

gchar*
synapse_gui_utils_markup_string_with_search (const gchar* text,
                                             const gchar* pattern,
                                             const gchar* size,
                                             gboolean show_not_found)
{
	gchar* markup = NULL;
	gchar* _tmp0_;
	GeeList* matchers = NULL;
	GeeList* _tmp12_;
	gchar* highlighted = NULL;
	const gchar* _tmp53_;
	gchar* result;
#line 48 "utils.vala"
	g_return_val_if_fail (text != NULL, NULL);
#line 48 "utils.vala"
	g_return_val_if_fail (pattern != NULL, NULL);
#line 48 "utils.vala"
	g_return_val_if_fail (size != NULL, NULL);
#line 51 "utils.vala"
	_tmp0_ = g_strdup ("%s");
#line 51 "utils.vala"
	markup = _tmp0_;
#line 52 "utils.vala"
	if (g_strcmp0 (size, "") != 0) {
#line 534 "utils.c"
		gchar* _tmp1_;
#line 54 "utils.vala"
		_tmp1_ = g_strdup_printf ("<span size=\"%s\">%s</span>", size, "%s");
#line 54 "utils.vala"
		_g_free0 (markup);
#line 54 "utils.vala"
		markup = _tmp1_;
#line 542 "utils.c"
	}
#line 56 "utils.vala"
	if (g_strcmp0 (pattern, "") == 0) {
#line 546 "utils.c"
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 58 "utils.vala"
		_tmp2_ = markup;
#line 58 "utils.vala"
		_tmp3_ = g_markup_escape_text (text, (gssize) -1);
#line 58 "utils.vala"
		_tmp4_ = _tmp3_;
#line 58 "utils.vala"
		_tmp5_ = g_strdup_printf (_tmp2_, _tmp4_);
#line 58 "utils.vala"
		_tmp6_ = _tmp5_;
#line 58 "utils.vala"
		_g_free0 (_tmp4_);
#line 58 "utils.vala"
		result = _tmp6_;
#line 58 "utils.vala"
		_g_free0 (markup);
#line 58 "utils.vala"
		return result;
#line 570 "utils.c"
	}
#line 61 "utils.vala"
	if (g_strcmp0 (text, "") == 0) {
#line 574 "utils.c"
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
#line 63 "utils.vala"
		_tmp7_ = markup;
#line 63 "utils.vala"
		_tmp8_ = g_markup_escape_text (pattern, (gssize) -1);
#line 63 "utils.vala"
		_tmp9_ = _tmp8_;
#line 63 "utils.vala"
		_tmp10_ = g_strdup_printf (_tmp7_, _tmp9_);
#line 63 "utils.vala"
		_tmp11_ = _tmp10_;
#line 63 "utils.vala"
		_g_free0 (_tmp9_);
#line 63 "utils.vala"
		result = _tmp11_;
#line 63 "utils.vala"
		_g_free0 (markup);
#line 63 "utils.vala"
		return result;
#line 598 "utils.c"
	}
#line 66 "utils.vala"
	_tmp12_ = synapse_query_get_matchers_for_query (pattern, 0, G_REGEX_OPTIMIZE | G_REGEX_CASELESS);
#line 66 "utils.vala"
	matchers = _tmp12_;
#line 69 "utils.vala"
	highlighted = NULL;
#line 606 "utils.c"
	{
		GeeList* _matcher_list = NULL;
		GeeList* _tmp13_;
		gint _matcher_size = 0;
		GeeList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _matcher_index = 0;
#line 70 "utils.vala"
		_tmp13_ = matchers;
#line 70 "utils.vala"
		_matcher_list = _tmp13_;
#line 70 "utils.vala"
		_tmp14_ = _matcher_list;
#line 70 "utils.vala"
		_tmp15_ = gee_collection_get_size ((GeeCollection*) _tmp14_);
#line 70 "utils.vala"
		_tmp16_ = _tmp15_;
#line 70 "utils.vala"
		_matcher_size = _tmp16_;
#line 70 "utils.vala"
		_matcher_index = -1;
#line 70 "utils.vala"
		while (TRUE) {
#line 631 "utils.c"
			gint _tmp17_;
			gint _tmp18_;
			GeeMapEntry* matcher = NULL;
			GeeList* _tmp19_;
			gpointer _tmp20_;
			GMatchInfo* mi = NULL;
			GeeMapEntry* _tmp21_;
			gconstpointer _tmp22_;
			gconstpointer _tmp23_;
			GMatchInfo* _tmp24_ = NULL;
			gboolean _tmp25_;
#line 70 "utils.vala"
			_matcher_index = _matcher_index + 1;
#line 70 "utils.vala"
			_tmp17_ = _matcher_index;
#line 70 "utils.vala"
			_tmp18_ = _matcher_size;
#line 70 "utils.vala"
			if (!(_tmp17_ < _tmp18_)) {
#line 70 "utils.vala"
				break;
#line 653 "utils.c"
			}
#line 70 "utils.vala"
			_tmp19_ = _matcher_list;
#line 70 "utils.vala"
			_tmp20_ = gee_list_get (_tmp19_, _matcher_index);
#line 70 "utils.vala"
			matcher = (GeeMapEntry*) _tmp20_;
#line 73 "utils.vala"
			_tmp21_ = matcher;
#line 73 "utils.vala"
			_tmp22_ = gee_map_entry_get_key (_tmp21_);
#line 73 "utils.vala"
			_tmp23_ = _tmp22_;
#line 73 "utils.vala"
			_tmp25_ = g_regex_match ((GRegex*) _tmp23_, text, 0, &_tmp24_);
#line 73 "utils.vala"
			_g_match_info_unref0 (mi);
#line 73 "utils.vala"
			mi = _tmp24_;
#line 73 "utils.vala"
			if (_tmp25_) {
#line 675 "utils.c"
				gint start_pos = 0;
				gint end_pos = 0;
				gint last_pos = 0;
				gint cnt = 0;
				GMatchInfo* _tmp26_;
				GString* res = NULL;
				GString* _tmp27_;
				GString* _tmp50_;
				const gchar* _tmp51_;
				gchar* _tmp52_;
#line 77 "utils.vala"
				last_pos = 0;
#line 78 "utils.vala"
				_tmp26_ = mi;
#line 78 "utils.vala"
				cnt = g_match_info_get_match_count (_tmp26_);
#line 79 "utils.vala"
				_tmp27_ = g_string_new ("");
#line 79 "utils.vala"
				res = _tmp27_;
#line 696 "utils.c"
				{
					gint i = 0;
#line 80 "utils.vala"
					i = 1;
#line 701 "utils.c"
					{
						gboolean _tmp28_ = FALSE;
#line 80 "utils.vala"
						_tmp28_ = TRUE;
#line 80 "utils.vala"
						while (TRUE) {
#line 708 "utils.c"
							GMatchInfo* _tmp30_;
							gint _tmp31_ = 0;
							gint _tmp32_ = 0;
							gboolean _tmp33_ = FALSE;
							GString* _tmp34_;
							gchar* _tmp35_;
							gchar* _tmp36_;
							gchar* _tmp37_;
							gchar* _tmp38_;
							GString* _tmp39_;
							GMatchInfo* _tmp40_;
							gchar* _tmp41_;
							gchar* _tmp42_;
							gchar* _tmp43_;
							gchar* _tmp44_;
#line 80 "utils.vala"
							if (!_tmp28_) {
#line 726 "utils.c"
								gint _tmp29_;
#line 80 "utils.vala"
								_tmp29_ = i;
#line 80 "utils.vala"
								i = _tmp29_ + 1;
#line 732 "utils.c"
							}
#line 80 "utils.vala"
							_tmp28_ = FALSE;
#line 80 "utils.vala"
							if (!(i < cnt)) {
#line 80 "utils.vala"
								break;
#line 740 "utils.c"
							}
#line 82 "utils.vala"
							_tmp30_ = mi;
#line 82 "utils.vala"
							g_match_info_fetch_pos (_tmp30_, i, &_tmp31_, &_tmp32_);
#line 82 "utils.vala"
							start_pos = _tmp31_;
#line 82 "utils.vala"
							end_pos = _tmp32_;
#line 83 "utils.vala"
							if (start_pos >= 0) {
#line 83 "utils.vala"
								_tmp33_ = end_pos >= 0;
#line 754 "utils.c"
							} else {
#line 83 "utils.vala"
								_tmp33_ = FALSE;
#line 758 "utils.c"
							}
#line 83 "utils.vala"
							g_warn_if_fail (_tmp33_);
#line 84 "utils.vala"
							_tmp34_ = res;
#line 84 "utils.vala"
							_tmp35_ = string_substring (text, (glong) last_pos, (glong) (start_pos - last_pos));
#line 84 "utils.vala"
							_tmp36_ = _tmp35_;
#line 84 "utils.vala"
							_tmp37_ = g_markup_escape_text (_tmp36_, (gssize) -1);
#line 84 "utils.vala"
							_tmp38_ = _tmp37_;
#line 84 "utils.vala"
							g_string_append (_tmp34_, _tmp38_);
#line 84 "utils.vala"
							_g_free0 (_tmp38_);
#line 84 "utils.vala"
							_g_free0 (_tmp36_);
#line 85 "utils.vala"
							last_pos = end_pos;
#line 86 "utils.vala"
							_tmp39_ = res;
#line 86 "utils.vala"
							_tmp40_ = mi;
#line 86 "utils.vala"
							_tmp41_ = g_match_info_fetch (_tmp40_, i);
#line 86 "utils.vala"
							_tmp42_ = _tmp41_;
#line 86 "utils.vala"
							_tmp43_ = g_markup_printf_escaped ("<u><b>%s</b></u>", _tmp42_);
#line 86 "utils.vala"
							_tmp44_ = _tmp43_;
#line 86 "utils.vala"
							g_string_append (_tmp39_, _tmp44_);
#line 86 "utils.vala"
							_g_free0 (_tmp44_);
#line 86 "utils.vala"
							_g_free0 (_tmp42_);
#line 87 "utils.vala"
							if (i == (cnt - 1)) {
#line 800 "utils.c"
								GString* _tmp45_;
								gchar* _tmp46_;
								gchar* _tmp47_;
								gchar* _tmp48_;
								gchar* _tmp49_;
#line 89 "utils.vala"
								_tmp45_ = res;
#line 89 "utils.vala"
								_tmp46_ = string_substring (text, (glong) last_pos, (glong) -1);
#line 89 "utils.vala"
								_tmp47_ = _tmp46_;
#line 89 "utils.vala"
								_tmp48_ = g_markup_escape_text (_tmp47_, (gssize) -1);
#line 89 "utils.vala"
								_tmp49_ = _tmp48_;
#line 89 "utils.vala"
								g_string_append (_tmp45_, _tmp49_);
#line 89 "utils.vala"
								_g_free0 (_tmp49_);
#line 89 "utils.vala"
								_g_free0 (_tmp47_);
#line 822 "utils.c"
							}
						}
					}
				}
#line 92 "utils.vala"
				_tmp50_ = res;
#line 92 "utils.vala"
				_tmp51_ = _tmp50_->str;
#line 92 "utils.vala"
				_tmp52_ = g_strdup (_tmp51_);
#line 92 "utils.vala"
				_g_free0 (highlighted);
#line 92 "utils.vala"
				highlighted = _tmp52_;
#line 93 "utils.vala"
				_g_string_free0 (res);
#line 93 "utils.vala"
				_g_match_info_unref0 (mi);
#line 93 "utils.vala"
				_g_object_unref0 (matcher);
#line 93 "utils.vala"
				break;
#line 845 "utils.c"
			}
#line 70 "utils.vala"
			_g_match_info_unref0 (mi);
#line 70 "utils.vala"
			_g_object_unref0 (matcher);
#line 851 "utils.c"
		}
	}
#line 96 "utils.vala"
	_tmp53_ = highlighted;
#line 96 "utils.vala"
	if (_tmp53_ != NULL) {
#line 858 "utils.c"
		const gchar* _tmp54_;
		const gchar* _tmp55_;
		gchar* _tmp56_;
#line 98 "utils.vala"
		_tmp54_ = markup;
#line 98 "utils.vala"
		_tmp55_ = highlighted;
#line 98 "utils.vala"
		_tmp56_ = g_strdup_printf (_tmp54_, _tmp55_);
#line 98 "utils.vala"
		result = _tmp56_;
#line 98 "utils.vala"
		_g_free0 (highlighted);
#line 98 "utils.vala"
		_g_object_unref0 (matchers);
#line 98 "utils.vala"
		_g_free0 (markup);
#line 98 "utils.vala"
		return result;
#line 878 "utils.c"
	} else {
#line 102 "utils.vala"
		if (show_not_found) {
#line 882 "utils.c"
			const gchar* _tmp57_;
			gchar* _tmp58_;
			gchar* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			gchar* _tmp64_;
			gchar* _tmp65_;
#line 103 "utils.vala"
			_tmp57_ = markup;
#line 103 "utils.vala"
			_tmp58_ = g_strdup_printf (_tmp57_, "%s <small><small>(%s)</small></small>");
#line 103 "utils.vala"
			_tmp59_ = _tmp58_;
#line 103 "utils.vala"
			_tmp60_ = g_markup_escape_text (text, (gssize) -1);
#line 103 "utils.vala"
			_tmp61_ = _tmp60_;
#line 103 "utils.vala"
			_tmp62_ = g_markup_escape_text (pattern, (gssize) -1);
#line 103 "utils.vala"
			_tmp63_ = _tmp62_;
#line 103 "utils.vala"
			_tmp64_ = g_strdup_printf (_tmp59_, _tmp61_, _tmp63_);
#line 103 "utils.vala"
			_tmp65_ = _tmp64_;
#line 103 "utils.vala"
			_g_free0 (_tmp63_);
#line 103 "utils.vala"
			_g_free0 (_tmp61_);
#line 103 "utils.vala"
			_g_free0 (_tmp59_);
#line 103 "utils.vala"
			result = _tmp65_;
#line 103 "utils.vala"
			_g_free0 (highlighted);
#line 103 "utils.vala"
			_g_object_unref0 (matchers);
#line 103 "utils.vala"
			_g_free0 (markup);
#line 103 "utils.vala"
			return result;
#line 926 "utils.c"
		} else {
			const gchar* _tmp66_;
			gchar* _tmp67_;
			gchar* _tmp68_;
			gchar* _tmp69_;
			gchar* _tmp70_;
#line 105 "utils.vala"
			_tmp66_ = markup;
#line 105 "utils.vala"
			_tmp67_ = g_markup_escape_text (text, (gssize) -1);
#line 105 "utils.vala"
			_tmp68_ = _tmp67_;
#line 105 "utils.vala"
			_tmp69_ = g_strdup_printf (_tmp66_, _tmp68_);
#line 105 "utils.vala"
			_tmp70_ = _tmp69_;
#line 105 "utils.vala"
			_g_free0 (_tmp68_);
#line 105 "utils.vala"
			result = _tmp70_;
#line 105 "utils.vala"
			_g_free0 (highlighted);
#line 105 "utils.vala"
			_g_object_unref0 (matchers);
#line 105 "utils.vala"
			_g_free0 (markup);
#line 105 "utils.vala"
			return result;
#line 955 "utils.c"
		}
	}
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
#line 1251 "glib-2.0.vapi"
	if (separator == NULL) {
#line 1252 "glib-2.0.vapi"
		separator = "";
#line 971 "utils.c"
	}
#line 1254 "glib-2.0.vapi"
	if (str_array != NULL) {
#line 975 "utils.c"
		gboolean _tmp1_ = FALSE;
#line 1254 "glib-2.0.vapi"
		if (str_array_length1 > 0) {
#line 1254 "glib-2.0.vapi"
			_tmp1_ = TRUE;
#line 981 "utils.c"
		} else {
			gboolean _tmp2_ = FALSE;
#line 1254 "glib-2.0.vapi"
			if (str_array_length1 == -1) {
#line 986 "utils.c"
				const gchar* _tmp3_;
#line 1254 "glib-2.0.vapi"
				_tmp3_ = str_array[0];
#line 1254 "glib-2.0.vapi"
				_tmp2_ = _tmp3_ != NULL;
#line 992 "utils.c"
			} else {
#line 1254 "glib-2.0.vapi"
				_tmp2_ = FALSE;
#line 996 "utils.c"
			}
#line 1254 "glib-2.0.vapi"
			_tmp1_ = _tmp2_;
#line 1000 "utils.c"
		}
#line 1254 "glib-2.0.vapi"
		_tmp0_ = _tmp1_;
#line 1004 "utils.c"
	} else {
#line 1254 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 1008 "utils.c"
	}
#line 1254 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1012 "utils.c"
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
#line 1256 "glib-2.0.vapi"
		len = (gsize) 1;
#line 1027 "utils.c"
		{
			gboolean _tmp4_ = FALSE;
#line 1257 "glib-2.0.vapi"
			i = 0;
#line 1257 "glib-2.0.vapi"
			_tmp4_ = TRUE;
#line 1257 "glib-2.0.vapi"
			while (TRUE) {
#line 1036 "utils.c"
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
#line 1257 "glib-2.0.vapi"
				if (!_tmp4_) {
#line 1043 "utils.c"
					gint _tmp5_;
#line 1257 "glib-2.0.vapi"
					_tmp5_ = i;
#line 1257 "glib-2.0.vapi"
					i = _tmp5_ + 1;
#line 1049 "utils.c"
				}
#line 1257 "glib-2.0.vapi"
				_tmp4_ = FALSE;
#line 1257 "glib-2.0.vapi"
				if (str_array_length1 != -1) {
#line 1257 "glib-2.0.vapi"
					_tmp7_ = i < str_array_length1;
#line 1057 "utils.c"
				} else {
#line 1257 "glib-2.0.vapi"
					_tmp7_ = FALSE;
#line 1061 "utils.c"
				}
#line 1257 "glib-2.0.vapi"
				if (_tmp7_) {
#line 1257 "glib-2.0.vapi"
					_tmp6_ = TRUE;
#line 1067 "utils.c"
				} else {
					gboolean _tmp8_ = FALSE;
#line 1257 "glib-2.0.vapi"
					if (str_array_length1 == -1) {
#line 1072 "utils.c"
						const gchar* _tmp9_;
#line 1257 "glib-2.0.vapi"
						_tmp9_ = str_array[i];
#line 1257 "glib-2.0.vapi"
						_tmp8_ = _tmp9_ != NULL;
#line 1078 "utils.c"
					} else {
#line 1257 "glib-2.0.vapi"
						_tmp8_ = FALSE;
#line 1082 "utils.c"
					}
#line 1257 "glib-2.0.vapi"
					_tmp6_ = _tmp8_;
#line 1086 "utils.c"
				}
#line 1257 "glib-2.0.vapi"
				if (!_tmp6_) {
#line 1257 "glib-2.0.vapi"
					break;
#line 1092 "utils.c"
				}
#line 1258 "glib-2.0.vapi"
				_tmp11_ = str_array[i];
#line 1258 "glib-2.0.vapi"
				if (_tmp11_ != NULL) {
#line 1098 "utils.c"
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
#line 1258 "glib-2.0.vapi"
					_tmp12_ = str_array[i];
#line 1258 "glib-2.0.vapi"
					_tmp13_ = strlen ((const gchar*) _tmp12_);
#line 1258 "glib-2.0.vapi"
					_tmp14_ = _tmp13_;
#line 1258 "glib-2.0.vapi"
					_tmp10_ = _tmp14_;
#line 1110 "utils.c"
				} else {
#line 1258 "glib-2.0.vapi"
					_tmp10_ = 0;
#line 1114 "utils.c"
				}
#line 1258 "glib-2.0.vapi"
				len += (gsize) _tmp10_;
#line 1118 "utils.c"
			}
		}
#line 1260 "glib-2.0.vapi"
		if (i == 0) {
#line 1123 "utils.c"
			gchar* _tmp15_;
#line 1261 "glib-2.0.vapi"
			_tmp15_ = g_strdup ("");
#line 1261 "glib-2.0.vapi"
			result = _tmp15_;
#line 1261 "glib-2.0.vapi"
			return result;
#line 1131 "utils.c"
		}
#line 1263 "glib-2.0.vapi"
		str_array_length1 = i;
#line 1264 "glib-2.0.vapi"
		_tmp16_ = strlen ((const gchar*) separator);
#line 1264 "glib-2.0.vapi"
		_tmp17_ = _tmp16_;
#line 1264 "glib-2.0.vapi"
		len += (gsize) (_tmp17_ * (i - 1));
#line 1266 "glib-2.0.vapi"
		_tmp18_ = g_malloc (len);
#line 1266 "glib-2.0.vapi"
		res = _tmp18_;
#line 1267 "glib-2.0.vapi"
		_tmp20_ = str_array[0];
#line 1267 "glib-2.0.vapi"
		if (_tmp20_ != NULL) {
#line 1149 "utils.c"
			const gchar* _tmp21_;
#line 1267 "glib-2.0.vapi"
			_tmp21_ = str_array[0];
#line 1267 "glib-2.0.vapi"
			_tmp19_ = (const gchar*) _tmp21_;
#line 1155 "utils.c"
		} else {
#line 1267 "glib-2.0.vapi"
			_tmp19_ = "";
#line 1159 "utils.c"
		}
#line 1267 "glib-2.0.vapi"
		_tmp22_ = res;
#line 1267 "glib-2.0.vapi"
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
#line 1267 "glib-2.0.vapi"
		ptr = _tmp23_;
#line 1167 "utils.c"
		{
			gboolean _tmp24_ = FALSE;
#line 1268 "glib-2.0.vapi"
			i = 1;
#line 1268 "glib-2.0.vapi"
			_tmp24_ = TRUE;
#line 1268 "glib-2.0.vapi"
			while (TRUE) {
#line 1176 "utils.c"
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
#line 1268 "glib-2.0.vapi"
				if (!_tmp24_) {
#line 1185 "utils.c"
					gint _tmp25_;
#line 1268 "glib-2.0.vapi"
					_tmp25_ = i;
#line 1268 "glib-2.0.vapi"
					i = _tmp25_ + 1;
#line 1191 "utils.c"
				}
#line 1268 "glib-2.0.vapi"
				_tmp24_ = FALSE;
#line 1268 "glib-2.0.vapi"
				if (!(i < str_array_length1)) {
#line 1268 "glib-2.0.vapi"
					break;
#line 1199 "utils.c"
				}
#line 1269 "glib-2.0.vapi"
				_tmp26_ = ptr;
#line 1269 "glib-2.0.vapi"
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
#line 1269 "glib-2.0.vapi"
				ptr = _tmp27_;
#line 1270 "glib-2.0.vapi"
				_tmp29_ = str_array[i];
#line 1270 "glib-2.0.vapi"
				if (_tmp29_ != NULL) {
#line 1211 "utils.c"
					const gchar* _tmp30_;
#line 1270 "glib-2.0.vapi"
					_tmp30_ = str_array[i];
#line 1270 "glib-2.0.vapi"
					_tmp28_ = (const gchar*) _tmp30_;
#line 1217 "utils.c"
				} else {
#line 1270 "glib-2.0.vapi"
					_tmp28_ = "";
#line 1221 "utils.c"
				}
#line 1270 "glib-2.0.vapi"
				_tmp31_ = ptr;
#line 1270 "glib-2.0.vapi"
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
#line 1270 "glib-2.0.vapi"
				ptr = _tmp32_;
#line 1229 "utils.c"
			}
		}
#line 1273 "glib-2.0.vapi"
		_tmp33_ = res;
#line 1273 "glib-2.0.vapi"
		res = NULL;
#line 1273 "glib-2.0.vapi"
		result = (gchar*) _tmp33_;
#line 1273 "glib-2.0.vapi"
		return result;
#line 1240 "utils.c"
	} else {
		gchar* _tmp34_;
#line 1275 "glib-2.0.vapi"
		_tmp34_ = g_strdup ("");
#line 1275 "glib-2.0.vapi"
		result = _tmp34_;
#line 1275 "glib-2.0.vapi"
		return result;
#line 1249 "utils.c"
	}
}

gchar*
synapse_gui_utils_get_printable_description (SynapseMatch* match)
{
	SynapseUriMatch* m = NULL;
	SynapseUriMatch* _tmp0_;
	SynapseUriMatch* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* desc_fixed = NULL;
	SynapseUriMatch* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	gchar** parts = NULL;
	const gchar* _tmp48_;
	gchar** _tmp49_;
	gchar** _tmp50_;
	gint parts_length1;
	gint _parts_size_;
	gchar** _tmp51_;
	gint _tmp51__length1;
	gchar* _tmp52_;
	gchar* result;
#line 109 "utils.vala"
	g_return_val_if_fail (match != NULL, NULL);
#line 111 "utils.vala"
	m = G_TYPE_CHECK_INSTANCE_TYPE (match, SYNAPSE_TYPE_URI_MATCH) ? ((SynapseUriMatch*) match) : NULL;
#line 112 "utils.vala"
	_tmp0_ = m;
#line 112 "utils.vala"
	if (_tmp0_ == NULL) {
#line 1287 "utils.c"
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
#line 114 "utils.vala"
		_tmp1_ = synapse_match_get_description (match);
#line 114 "utils.vala"
		_tmp2_ = _tmp1_;
#line 114 "utils.vala"
		_tmp3_ = g_strdup (_tmp2_);
#line 114 "utils.vala"
		result = _tmp3_;
#line 114 "utils.vala"
		return result;
#line 1301 "utils.c"
	}
#line 117 "utils.vala"
	_tmp4_ = m;
#line 117 "utils.vala"
	_tmp5_ = synapse_uri_match_get_uri (_tmp4_);
#line 117 "utils.vala"
	_tmp6_ = _tmp5_;
#line 117 "utils.vala"
	if (!g_str_has_prefix (_tmp6_, "file://")) {
#line 1311 "utils.c"
		SynapseUriMatch* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
#line 117 "utils.vala"
		_tmp7_ = m;
#line 117 "utils.vala"
		_tmp8_ = synapse_uri_match_get_uri (_tmp7_);
#line 117 "utils.vala"
		_tmp9_ = _tmp8_;
#line 117 "utils.vala"
		_tmp10_ = g_strdup (_tmp9_);
#line 117 "utils.vala"
		result = _tmp10_;
#line 117 "utils.vala"
		return result;
#line 1328 "utils.c"
	}
#line 122 "utils.vala"
	_tmp11_ = m;
#line 122 "utils.vala"
	_tmp12_ = synapse_match_get_description ((SynapseMatch*) _tmp11_);
#line 122 "utils.vala"
	_tmp13_ = _tmp12_;
#line 122 "utils.vala"
	_tmp14_ = g_strdup (_tmp13_);
#line 122 "utils.vala"
	desc_fixed = _tmp14_;
#line 124 "utils.vala"
	_tmp15_ = synapse_gui_utils_home_directory;
#line 124 "utils.vala"
	if (_tmp15_ == NULL) {
#line 1344 "utils.c"
		const gchar* _tmp16_;
		gchar* _tmp17_;
		const gchar* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
#line 126 "utils.vala"
		_tmp16_ = g_get_home_dir ();
#line 126 "utils.vala"
		_tmp17_ = g_strdup (_tmp16_);
#line 126 "utils.vala"
		_g_free0 (synapse_gui_utils_home_directory);
#line 126 "utils.vala"
		synapse_gui_utils_home_directory = _tmp17_;
#line 127 "utils.vala"
		_tmp18_ = synapse_gui_utils_home_directory;
#line 127 "utils.vala"
		_tmp19_ = strlen (_tmp18_);
#line 127 "utils.vala"
		_tmp20_ = _tmp19_;
#line 127 "utils.vala"
		synapse_gui_utils_home_directory_length = (glong) _tmp20_;
#line 1366 "utils.c"
	}
#line 129 "utils.vala"
	_tmp21_ = desc_fixed;
#line 129 "utils.vala"
	_tmp22_ = synapse_gui_utils_home_directory;
#line 129 "utils.vala"
	if (g_str_has_prefix (_tmp21_, _tmp22_)) {
#line 1374 "utils.c"
		const gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
#line 131 "utils.vala"
		_tmp23_ = desc_fixed;
#line 131 "utils.vala"
		_tmp24_ = string_substring (_tmp23_, synapse_gui_utils_home_directory_length, (glong) -1);
#line 131 "utils.vala"
		_tmp25_ = _tmp24_;
#line 131 "utils.vala"
		_tmp26_ = g_strconcat (_ ("Home"), _tmp25_, NULL);
#line 131 "utils.vala"
		_g_free0 (desc_fixed);
#line 131 "utils.vala"
		desc_fixed = _tmp26_;
#line 131 "utils.vala"
		_g_free0 (_tmp25_);
#line 1393 "utils.c"
	} else {
		SynapseVolumeService* vs = NULL;
		SynapseVolumeService* _tmp27_;
		gchar* volume_path = NULL;
		gchar* volume_name = NULL;
		SynapseVolumeService* _tmp28_;
		SynapseUriMatch* _tmp29_;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_;
		gboolean _tmp34_ = FALSE;
		const gchar* _tmp35_;
#line 135 "utils.vala"
		_tmp27_ = synapse_volume_service_get_default ();
#line 135 "utils.vala"
		vs = _tmp27_;
#line 137 "utils.vala"
		_tmp28_ = vs;
#line 137 "utils.vala"
		_tmp29_ = m;
#line 137 "utils.vala"
		_tmp30_ = synapse_uri_match_get_uri (_tmp29_);
#line 137 "utils.vala"
		_tmp31_ = _tmp30_;
#line 137 "utils.vala"
		_tmp33_ = synapse_volume_service_uri_to_volume_name (_tmp28_, _tmp31_, &_tmp32_);
#line 137 "utils.vala"
		_g_free0 (volume_path);
#line 137 "utils.vala"
		volume_path = _tmp32_;
#line 137 "utils.vala"
		volume_name = _tmp33_;
#line 139 "utils.vala"
		_tmp35_ = volume_path;
#line 139 "utils.vala"
		if (_tmp35_ != NULL) {
#line 1431 "utils.c"
			const gchar* _tmp36_;
			const gchar* _tmp37_;
#line 139 "utils.vala"
			_tmp36_ = desc_fixed;
#line 139 "utils.vala"
			_tmp37_ = volume_path;
#line 139 "utils.vala"
			_tmp34_ = g_str_has_prefix (_tmp36_, _tmp37_);
#line 1440 "utils.c"
		} else {
#line 139 "utils.vala"
			_tmp34_ = FALSE;
#line 1444 "utils.c"
		}
#line 139 "utils.vala"
		if (_tmp34_) {
#line 1448 "utils.c"
			const gchar* _tmp38_;
			const gchar* _tmp39_;
			const gchar* _tmp40_;
			gint _tmp41_;
			gint _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
#line 141 "utils.vala"
			_tmp38_ = volume_name;
#line 141 "utils.vala"
			_tmp39_ = desc_fixed;
#line 141 "utils.vala"
			_tmp40_ = volume_path;
#line 141 "utils.vala"
			_tmp41_ = strlen (_tmp40_);
#line 141 "utils.vala"
			_tmp42_ = _tmp41_;
#line 141 "utils.vala"
			_tmp43_ = string_substring (_tmp39_, (glong) _tmp42_, (glong) -1);
#line 141 "utils.vala"
			_tmp44_ = _tmp43_;
#line 141 "utils.vala"
			_tmp45_ = g_strconcat (_tmp38_, _tmp44_, NULL);
#line 141 "utils.vala"
			_g_free0 (desc_fixed);
#line 141 "utils.vala"
			desc_fixed = _tmp45_;
#line 141 "utils.vala"
			_g_free0 (_tmp44_);
#line 1479 "utils.c"
		} else {
			const gchar* _tmp46_;
			gchar* _tmp47_;
#line 145 "utils.vala"
			_tmp46_ = desc_fixed;
#line 145 "utils.vala"
			_tmp47_ = g_strconcat (_ ("Root"), _tmp46_, NULL);
#line 145 "utils.vala"
			_g_free0 (desc_fixed);
#line 145 "utils.vala"
			desc_fixed = _tmp47_;
#line 1491 "utils.c"
		}
#line 129 "utils.vala"
		_g_free0 (volume_name);
#line 129 "utils.vala"
		_g_free0 (volume_path);
#line 129 "utils.vala"
		_g_object_unref0 (vs);
#line 1499 "utils.c"
	}
#line 150 "utils.vala"
	_tmp48_ = desc_fixed;
#line 150 "utils.vala"
	_tmp50_ = _tmp49_ = g_regex_split_simple ("/", _tmp48_, 0, 0);
#line 150 "utils.vala"
	parts = _tmp50_;
#line 150 "utils.vala"
	parts_length1 = _vala_array_length (_tmp49_);
#line 150 "utils.vala"
	_parts_size_ = parts_length1;
#line 151 "utils.vala"
	_tmp51_ = parts;
#line 151 "utils.vala"
	_tmp51__length1 = parts_length1;
#line 151 "utils.vala"
	_tmp52_ = _vala_g_strjoinv (" > ", _tmp51_, (gint) _tmp51__length1);
#line 151 "utils.vala"
	_g_free0 (desc_fixed);
#line 151 "utils.vala"
	desc_fixed = _tmp52_;
#line 155 "utils.vala"
	result = desc_fixed;
#line 155 "utils.vala"
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 155 "utils.vala"
	return result;
#line 1527 "utils.c"
}

void
synapse_gui_utils_update_layout_rtl (PangoLayout* layout,
                                     GtkTextDirection rtl)
{
#line 158 "utils.vala"
	g_return_if_fail (layout != NULL);
#line 161 "utils.vala"
	pango_layout_set_auto_dir (layout, FALSE);
#line 162 "utils.vala"
	if (rtl == GTK_TEXT_DIR_RTL) {
#line 1540 "utils.c"
		PangoContext* _tmp0_;
#line 164 "utils.vala"
		pango_layout_set_alignment (layout, PANGO_ALIGN_RIGHT);
#line 165 "utils.vala"
		_tmp0_ = pango_layout_get_context (layout);
#line 165 "utils.vala"
		pango_context_set_base_dir (_tmp0_, PANGO_DIRECTION_RTL);
#line 1548 "utils.c"
	} else {
		PangoContext* _tmp1_;
#line 169 "utils.vala"
		pango_layout_set_alignment (layout, PANGO_ALIGN_LEFT);
#line 170 "utils.vala"
		_tmp1_ = pango_layout_get_context (layout);
#line 170 "utils.vala"
		pango_context_set_base_dir (_tmp1_, PANGO_DIRECTION_LTR);
#line 1557 "utils.c"
	}
#line 172 "utils.vala"
	pango_layout_context_changed (layout);
#line 1561 "utils.c"
}

void
synapse_gui_utils_get_draw_position (gint* x,
                                     gint* y,
                                     gint* width,
                                     gint* height,
                                     PangoLayout* layout,
                                     gboolean rtl,
                                     gint area_width,
                                     gint area_height,
                                     gfloat xalign,
                                     gfloat yalign)
{
	gint _vala_x = 0;
	gint _vala_y = 0;
	gint _vala_width = 0;
	gint _vala_height = 0;
	PangoRectangle logical_rect = {0};
	PangoRectangle _tmp0_ = {0};
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	PangoRectangle _tmp3_;
#line 175 "utils.vala"
	g_return_if_fail (layout != NULL);
#line 181 "utils.vala"
	if (rtl) {
#line 181 "utils.vala"
		xalign = 1.0f - xalign;
#line 1591 "utils.c"
	}
#line 184 "utils.vala"
	pango_layout_get_pixel_extents (layout, NULL, &_tmp0_);
#line 184 "utils.vala"
	logical_rect = _tmp0_;
#line 186 "utils.vala"
	pango_layout_get_pixel_size (layout, &_tmp1_, &_tmp2_);
#line 186 "utils.vala"
	_vala_width = _tmp1_;
#line 186 "utils.vala"
	_vala_height = _tmp2_;
#line 188 "utils.vala"
	_vala_y = (gint) (yalign * (area_height - _vala_height));
#line 189 "utils.vala"
	_vala_x = (gint) (xalign * (area_width - _vala_width));
#line 191 "utils.vala"
	if (rtl) {
#line 192 "utils.vala"
		_vala_x = MIN (_vala_x, area_width);
#line 1611 "utils.c"
	} else {
#line 194 "utils.vala"
		_vala_x = MAX (_vala_x, 0);
#line 1615 "utils.c"
	}
#line 195 "utils.vala"
	_tmp3_ = logical_rect;
#line 195 "utils.vala"
	_vala_x = _vala_x - _tmp3_.x;
#line 175 "utils.vala"
	if (x) {
#line 175 "utils.vala"
		*x = _vala_x;
#line 1625 "utils.c"
	}
#line 175 "utils.vala"
	if (y) {
#line 175 "utils.vala"
		*y = _vala_y;
#line 1631 "utils.c"
	}
#line 175 "utils.vala"
	if (width) {
#line 175 "utils.vala"
		*width = _vala_width;
#line 1637 "utils.c"
	}
#line 175 "utils.vala"
	if (height) {
#line 175 "utils.vala"
		*height = _vala_height;
#line 1643 "utils.c"
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 200 "utils.vala"
	return self ? g_object_ref (self) : NULL;
#line 1652 "utils.c"
}

void
synapse_gui_utils_make_transparent_bg (GtkWidget* widget)
{
	GdkWindow* window = NULL;
	GdkWindow* _tmp0_;
	GdkWindow* _tmp1_;
	GdkWindow* _tmp2_;
#line 198 "utils.vala"
	g_return_if_fail (widget != NULL);
#line 200 "utils.vala"
	_tmp0_ = gtk_widget_get_window (widget);
#line 200 "utils.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 200 "utils.vala"
	window = _tmp1_;
#line 201 "utils.vala"
	_tmp2_ = window;
#line 201 "utils.vala"
	if (_tmp2_ == NULL) {
#line 201 "utils.vala"
		_g_object_unref0 (window);
#line 201 "utils.vala"
		return;
#line 1678 "utils.c"
	}
#line 203 "utils.vala"
	if (gtk_widget_is_composited (widget)) {
#line 1682 "utils.c"
		GdkWindow* _tmp3_;
		GdkRGBA _tmp4_ = {0};
#line 205 "utils.vala"
		_tmp3_ = window;
#line 205 "utils.vala"
		_tmp4_.red = (gdouble) 0;
#line 205 "utils.vala"
		_tmp4_.green = (gdouble) 0;
#line 205 "utils.vala"
		_tmp4_.blue = (gdouble) 0;
#line 205 "utils.vala"
		_tmp4_.alpha = (gdouble) 0;
#line 205 "utils.vala"
		gdk_window_set_background_rgba (_tmp3_, &_tmp4_);
#line 1697 "utils.c"
	}
#line 198 "utils.vala"
	_g_object_unref0 (window);
#line 1701 "utils.c"
}

void
synapse_gui_utils_on_style_updated (GtkWidget* widget)
{
#line 209 "utils.vala"
	g_return_if_fail (widget != NULL);
#line 211 "utils.vala"
	if (gtk_widget_get_realized (widget)) {
#line 213 "utils.vala"
		synapse_gui_utils_make_transparent_bg (widget);
#line 214 "utils.vala"
		gtk_widget_queue_draw (widget);
#line 1715 "utils.c"
	}
}

void
synapse_gui_utils_on_composited_change (GtkWidget* widget)
{
#line 218 "utils.vala"
	g_return_if_fail (widget != NULL);
#line 220 "utils.vala"
	if (gtk_widget_is_composited (widget)) {
#line 220 "utils.vala"
		synapse_gui_utils_make_transparent_bg (widget);
#line 1728 "utils.c"
	} else {
#line 221 "utils.vala"
		gtk_widget_override_background_color (widget, GTK_STATE_FLAG_NORMAL, NULL);
#line 1732 "utils.c"
	}
}

static void
_synapse_gui_utils_make_transparent_bg_gtk_widget_realize (GtkWidget* _sender,
                                                           gpointer self)
{
#line 228 "utils.vala"
	synapse_gui_utils_make_transparent_bg (_sender);
#line 1742 "utils.c"
}

static void
_synapse_gui_utils_on_style_updated_gtk_widget_style_updated (GtkWidget* _sender,
                                                              gpointer self)
{
#line 229 "utils.vala"
	synapse_gui_utils_on_style_updated (_sender);
#line 1751 "utils.c"
}

static void
_synapse_gui_utils_on_composited_change_gtk_widget_composited_changed (GtkWidget* _sender,
                                                                       gpointer self)
{
#line 230 "utils.vala"
	synapse_gui_utils_on_composited_change (_sender);
#line 1760 "utils.c"
}

void
synapse_gui_utils_ensure_transparent_bg (GtkWidget* widget)
{
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
#line 224 "utils.vala"
	g_return_if_fail (widget != NULL);
#line 226 "utils.vala"
	if (gtk_widget_get_realized (widget)) {
#line 226 "utils.vala"
		synapse_gui_utils_make_transparent_bg (widget);
#line 1775 "utils.c"
	}
#line 228 "utils.vala"
	g_signal_parse_name ("realize", gtk_widget_get_type (), &_tmp0_, NULL, FALSE);
#line 228 "utils.vala"
	g_signal_handlers_disconnect_matched (widget, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _synapse_gui_utils_make_transparent_bg_gtk_widget_realize, NULL);
#line 229 "utils.vala"
	g_signal_parse_name ("style-updated", gtk_widget_get_type (), &_tmp1_, NULL, FALSE);
#line 229 "utils.vala"
	g_signal_handlers_disconnect_matched (widget, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _synapse_gui_utils_on_style_updated_gtk_widget_style_updated, NULL);
#line 230 "utils.vala"
	g_signal_parse_name ("composited-changed", gtk_widget_get_type (), &_tmp2_, NULL, FALSE);
#line 230 "utils.vala"
	g_signal_handlers_disconnect_matched (widget, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _synapse_gui_utils_on_composited_change_gtk_widget_composited_changed, NULL);
#line 232 "utils.vala"
	g_signal_connect (widget, "realize", (GCallback) _synapse_gui_utils_make_transparent_bg_gtk_widget_realize, NULL);
#line 233 "utils.vala"
	g_signal_connect (widget, "style-updated", (GCallback) _synapse_gui_utils_on_style_updated_gtk_widget_style_updated, NULL);
#line 234 "utils.vala"
	g_signal_connect (widget, "composited-changed", (GCallback) _synapse_gui_utils_on_composited_change_gtk_widget_composited_changed, NULL);
#line 1795 "utils.c"
}

void
synapse_gui_utils_get_current_monitor_geometry (GdkScreen* screen,
                                                GdkRectangle* result)
{
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp0_;
	GdkDisplay* _tmp1_;
	gint x = 0;
	gint y = 0;
	GdkScreen* screen_for_pointer = NULL;
	GdkDeviceManager* _tmp2_;
	GdkDevice* _tmp3_;
	GdkScreen* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	GdkScreen* _tmp7_;
	GdkRectangle rect = {0};
	GdkRectangle _tmp8_ = {0};
	GdkScreen* _tmp9_;
	GdkScreen* _tmp10_;
	GdkRectangle _tmp11_ = {0};
#line 237 "utils.vala"
	g_return_if_fail (screen != NULL);
#line 239 "utils.vala"
	_tmp0_ = gdk_screen_get_display (screen);
#line 239 "utils.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 239 "utils.vala"
	display = _tmp1_;
#line 240 "utils.vala"
	x = 0;
#line 240 "utils.vala"
	y = 0;
#line 241 "utils.vala"
	screen_for_pointer = NULL;
#line 242 "utils.vala"
	_tmp2_ = gdk_display_get_device_manager (display);
#line 242 "utils.vala"
	_tmp3_ = gdk_device_manager_get_client_pointer (_tmp2_);
#line 242 "utils.vala"
	gdk_device_get_position (_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
#line 242 "utils.vala"
	_g_object_unref0 (screen_for_pointer);
#line 242 "utils.vala"
	_tmp7_ = _g_object_ref0 (_tmp4_);
#line 242 "utils.vala"
	screen_for_pointer = _tmp7_;
#line 242 "utils.vala"
	x = _tmp5_;
#line 242 "utils.vala"
	y = _tmp6_;
#line 244 "utils.vala"
	rect = _tmp8_;
#line 245 "utils.vala"
	_tmp9_ = screen_for_pointer;
#line 245 "utils.vala"
	_tmp10_ = screen_for_pointer;
#line 245 "utils.vala"
	gdk_screen_get_monitor_geometry (_tmp9_, gdk_screen_get_monitor_at_point (_tmp10_, x, y), &_tmp11_);
#line 245 "utils.vala"
	rect = _tmp11_;
#line 247 "utils.vala"
	*result = rect;
#line 247 "utils.vala"
	_g_object_unref0 (screen_for_pointer);
#line 247 "utils.vala"
	_g_object_unref0 (display);
#line 247 "utils.vala"
	return;
#line 1867 "utils.c"
}

void
synapse_gui_utils_move_window_to_center (GtkWindow* win)
{
	GdkScreen* _tmp0_ = NULL;
	GdkScreen* _tmp1_;
	GdkScreen* screen = NULL;
	GdkScreen* _tmp3_;
	GdkScreen* _tmp4_;
	GdkRectangle rect = {0};
	GdkScreen* _tmp5_;
	GdkRectangle _tmp6_ = {0};
	gint width = 0;
	gint height = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	GdkRectangle _tmp9_;
	GdkRectangle _tmp10_;
	GdkRectangle _tmp11_;
	GdkRectangle _tmp12_;
#line 249 "utils.vala"
	g_return_if_fail (win != NULL);
#line 251 "utils.vala"
	_tmp1_ = gtk_window_get_screen (win);
#line 251 "utils.vala"
	_tmp0_ = _tmp1_;
#line 251 "utils.vala"
	if (_tmp0_ == NULL) {
#line 1897 "utils.c"
		GdkScreen* _tmp2_;
#line 251 "utils.vala"
		_tmp2_ = gdk_screen_get_default ();
#line 251 "utils.vala"
		_tmp0_ = _tmp2_;
#line 1903 "utils.c"
	}
#line 251 "utils.vala"
	_tmp3_ = _g_object_ref0 (_tmp0_);
#line 251 "utils.vala"
	screen = _tmp3_;
#line 252 "utils.vala"
	_tmp4_ = screen;
#line 252 "utils.vala"
	if (_tmp4_ == NULL) {
#line 253 "utils.vala"
		_g_object_unref0 (screen);
#line 253 "utils.vala"
		return;
#line 1917 "utils.c"
	}
#line 254 "utils.vala"
	_tmp5_ = screen;
#line 254 "utils.vala"
	synapse_gui_utils_get_current_monitor_geometry (_tmp5_, &_tmp6_);
#line 254 "utils.vala"
	rect = _tmp6_;
#line 257 "utils.vala"
	gtk_widget_get_preferred_width ((GtkWidget*) win, &_tmp7_, NULL);
#line 257 "utils.vala"
	width = _tmp7_;
#line 258 "utils.vala"
	gtk_widget_get_preferred_height ((GtkWidget*) win, &_tmp8_, NULL);
#line 258 "utils.vala"
	height = _tmp8_;
#line 259 "utils.vala"
	_tmp9_ = rect;
#line 259 "utils.vala"
	_tmp10_ = rect;
#line 259 "utils.vala"
	_tmp11_ = rect;
#line 259 "utils.vala"
	_tmp12_ = rect;
#line 259 "utils.vala"
	gtk_window_move (win, _tmp9_.x + ((_tmp10_.width - width) / 2), _tmp11_.y + ((_tmp12_.height - height) / 2));
#line 249 "utils.vala"
	_g_object_unref0 (screen);
#line 1945 "utils.c"
}

void
synapse_gui_utils_rgb_invert_color (gdouble* r,
                                    gdouble* g,
                                    gdouble* b)
{
#line 265 "utils.vala"
	if ((*r) >= 0.5) {
#line 265 "utils.vala"
		*r = (*r) / 4;
#line 1957 "utils.c"
	} else {
#line 265 "utils.vala"
		*r = 1 - ((*r) / 4);
#line 1961 "utils.c"
	}
#line 266 "utils.vala"
	if ((*g) >= 0.5) {
#line 266 "utils.vala"
		*g = (*g) / 4;
#line 1967 "utils.c"
	} else {
#line 266 "utils.vala"
		*g = 1 - ((*g) / 4);
#line 1971 "utils.c"
	}
#line 267 "utils.vala"
	if ((*b) >= 0.5) {
#line 267 "utils.vala"
		*b = (*b) / 4;
#line 1977 "utils.c"
	} else {
#line 267 "utils.vala"
		*b = 1 - ((*b) / 4);
#line 1981 "utils.c"
	}
}

void
synapse_gui_utils_cairo_arrow (cairo_t* ctx,
                               gboolean rtl,
                               gdouble x,
                               gdouble y,
                               gdouble w,
                               gdouble h)
{
	gdouble xh = 0.0;
	gdouble yh = 0.0;
#line 270 "utils.vala"
	g_return_if_fail (ctx != NULL);
#line 272 "utils.vala"
	xh = x + (w / 2);
#line 273 "utils.vala"
	yh = y + (h / 2);
#line 274 "utils.vala"
	cairo_new_path (ctx);
#line 275 "utils.vala"
	if (rtl) {
#line 277 "utils.vala"
		cairo_move_to (ctx, x + w, y);
#line 278 "utils.vala"
		cairo_curve_to (ctx, xh, yh, xh, yh, x + w, y + h);
#line 279 "utils.vala"
		cairo_line_to (ctx, x, yh);
#line 2011 "utils.c"
	} else {
#line 283 "utils.vala"
		cairo_move_to (ctx, x, y);
#line 284 "utils.vala"
		cairo_curve_to (ctx, xh, yh, xh, yh, x, y + h);
#line 285 "utils.vala"
		cairo_line_to (ctx, x + w, yh);
#line 2019 "utils.c"
	}
#line 287 "utils.vala"
	cairo_close_path (ctx);
#line 2023 "utils.c"
}

void
synapse_gui_utils_cairo_rounded_rect (cairo_t* ctx,
                                      gdouble x,
                                      gdouble y,
                                      gdouble w,
                                      gdouble h,
                                      gdouble r)
{
	gdouble y2 = 0.0;
	gdouble x2 = 0.0;
#line 290 "utils.vala"
	g_return_if_fail (ctx != NULL);
#line 292 "utils.vala"
	y2 = y + h;
#line 292 "utils.vala"
	x2 = x + w;
#line 293 "utils.vala"
	cairo_move_to (ctx, x, y2 - r);
#line 294 "utils.vala"
	cairo_arc (ctx, x + r, y + r, r, G_PI, G_PI * 1.5);
#line 295 "utils.vala"
	cairo_arc (ctx, x2 - r, y + r, r, G_PI * 1.5, G_PI * 2.0);
#line 296 "utils.vala"
	cairo_arc (ctx, x2 - r, y2 - r, r, (gdouble) 0, G_PI * 0.5);
#line 297 "utils.vala"
	cairo_arc (ctx, x + r, y2 - r, r, G_PI * 0.5, G_PI);
#line 2052 "utils.c"
}

void
synapse_gui_utils_add_shadow_stops (cairo_pattern_t* pat,
                                    gdouble r,
                                    gdouble g,
                                    gdouble b,
                                    gdouble size,
                                    gdouble alpha)
{
#line 300 "utils.vala"
	g_return_if_fail (pat != NULL);
#line 303 "utils.vala"
	cairo_pattern_add_color_stop_rgba (pat, 1.0, r, g, b, (gdouble) 0);
#line 304 "utils.vala"
	cairo_pattern_add_color_stop_rgba (pat, 0.8, r, g, b, alpha * 0.07);
#line 305 "utils.vala"
	cairo_pattern_add_color_stop_rgba (pat, 0.6, r, g, b, alpha * 0.24);
#line 306 "utils.vala"
	cairo_pattern_add_color_stop_rgba (pat, 0.4, r, g, b, alpha * 0.46);
#line 307 "utils.vala"
	cairo_pattern_add_color_stop_rgba (pat, 0.2, r, g, b, alpha * 0.77);
#line 308 "utils.vala"
	cairo_pattern_add_color_stop_rgba (pat, 0.0, r, g, b, alpha);
#line 2077 "utils.c"
}

void
synapse_gui_utils_cairo_make_shadow_for_rect (cairo_t* ctx,
                                              gdouble x1,
                                              gdouble y1,
                                              gdouble w,
                                              gdouble h,
                                              gdouble rad,
                                              gdouble r,
                                              gdouble g,
                                              gdouble b,
                                              gdouble size)
{
	gdouble a = 0.0;
	gdouble x2 = 0.0;
	gdouble x3 = 0.0;
	gdouble x4 = 0.0;
	gdouble y2 = 0.0;
	gdouble y3 = 0.0;
	gdouble y4 = 0.0;
	gdouble thick = 0.0;
	cairo_pattern_t* pat = NULL;
	cairo_pattern_t* _tmp0_;
	cairo_pattern_t* _tmp1_;
	cairo_pattern_t* _tmp2_;
	cairo_pattern_t* _tmp3_;
	cairo_pattern_t* _tmp4_;
	cairo_pattern_t* _tmp5_;
	cairo_pattern_t* _tmp6_;
	cairo_pattern_t* _tmp7_;
	cairo_pattern_t* _tmp8_;
	cairo_pattern_t* _tmp9_;
	cairo_pattern_t* _tmp10_;
	cairo_pattern_t* _tmp11_;
	cairo_pattern_t* _tmp12_;
	cairo_pattern_t* _tmp13_;
	cairo_pattern_t* _tmp14_;
	cairo_pattern_t* _tmp15_;
	cairo_pattern_t* _tmp16_;
	cairo_pattern_t* _tmp17_;
	cairo_pattern_t* _tmp18_;
	cairo_pattern_t* _tmp19_;
	cairo_pattern_t* _tmp20_;
	cairo_pattern_t* _tmp21_;
	cairo_pattern_t* _tmp22_;
	cairo_pattern_t* _tmp23_;
#line 311 "utils.vala"
	g_return_if_fail (ctx != NULL);
#line 314 "utils.vala"
	if (size < ((gdouble) 1)) {
#line 314 "utils.vala"
		return;
#line 2131 "utils.c"
	}
#line 315 "utils.vala"
	cairo_save (ctx);
#line 316 "utils.vala"
	a = 0.25;
#line 319 "utils.vala"
	cairo_translate (ctx, 0.5, 0.5);
#line 320 "utils.vala"
	w = w - 1;
#line 320 "utils.vala"
	h = h - 1;
#line 321 "utils.vala"
	x2 = x1 + rad;
#line 322 "utils.vala"
	x3 = (x1 + w) - rad;
#line 323 "utils.vala"
	x4 = x1 + w;
#line 324 "utils.vala"
	y2 = y1 + rad;
#line 325 "utils.vala"
	y3 = (y1 + h) - rad;
#line 326 "utils.vala"
	y4 = y1 + h;
#line 327 "utils.vala"
	thick = size + rad;
#line 339 "utils.vala"
	cairo_save (ctx);
#line 340 "utils.vala"
	_tmp0_ = cairo_pattern_create_radial (x2, y2, rad, x2, y2, thick);
#line 340 "utils.vala"
	_cairo_pattern_destroy0 (pat);
#line 340 "utils.vala"
	pat = _tmp0_;
#line 341 "utils.vala"
	_tmp1_ = pat;
#line 341 "utils.vala"
	synapse_gui_utils_add_shadow_stops (_tmp1_, r, g, b, size, a);
#line 342 "utils.vala"
	_tmp2_ = pat;
#line 342 "utils.vala"
	cairo_set_source (ctx, _tmp2_);
#line 343 "utils.vala"
	cairo_rectangle (ctx, x1 - size, y1 - size, thick, thick);
#line 344 "utils.vala"
	cairo_clip (ctx);
#line 345 "utils.vala"
	cairo_paint (ctx);
#line 346 "utils.vala"
	cairo_restore (ctx);
#line 348 "utils.vala"
	cairo_save (ctx);
#line 349 "utils.vala"
	_tmp3_ = cairo_pattern_create_radial (x2, y3, rad, x2, y3, thick);
#line 349 "utils.vala"
	_cairo_pattern_destroy0 (pat);
#line 349 "utils.vala"
	pat = _tmp3_;
#line 350 "utils.vala"
	_tmp4_ = pat;
#line 350 "utils.vala"
	synapse_gui_utils_add_shadow_stops (_tmp4_, r, g, b, size, a);
#line 351 "utils.vala"
	_tmp5_ = pat;
#line 351 "utils.vala"
	cairo_set_source (ctx, _tmp5_);
#line 352 "utils.vala"
	cairo_rectangle (ctx, x1 - size, y3, thick, thick);
#line 353 "utils.vala"
	cairo_clip (ctx);
#line 354 "utils.vala"
	cairo_paint (ctx);
#line 355 "utils.vala"
	cairo_restore (ctx);
#line 357 "utils.vala"
	cairo_save (ctx);
#line 358 "utils.vala"
	_tmp6_ = cairo_pattern_create_radial (x3, y2, rad, x3, y2, thick);
#line 358 "utils.vala"
	_cairo_pattern_destroy0 (pat);
#line 358 "utils.vala"
	pat = _tmp6_;
#line 359 "utils.vala"
	_tmp7_ = pat;
#line 359 "utils.vala"
	synapse_gui_utils_add_shadow_stops (_tmp7_, r, g, b, size, a);
#line 360 "utils.vala"
	_tmp8_ = pat;
#line 360 "utils.vala"
	cairo_set_source (ctx, _tmp8_);
#line 361 "utils.vala"
	cairo_rectangle (ctx, x3, y1 - size, thick, thick);
#line 362 "utils.vala"
	cairo_clip (ctx);
#line 363 "utils.vala"
	cairo_paint (ctx);
#line 364 "utils.vala"
	cairo_restore (ctx);
#line 366 "utils.vala"
	cairo_save (ctx);
#line 367 "utils.vala"
	_tmp9_ = cairo_pattern_create_radial (x3, y3, rad, x3, y3, thick);
#line 367 "utils.vala"
	_cairo_pattern_destroy0 (pat);
#line 367 "utils.vala"
	pat = _tmp9_;
#line 368 "utils.vala"
	_tmp10_ = pat;
#line 368 "utils.vala"
	synapse_gui_utils_add_shadow_stops (_tmp10_, r, g, b, size, a);
#line 369 "utils.vala"
	_tmp11_ = pat;
#line 369 "utils.vala"
	cairo_set_source (ctx, _tmp11_);
#line 370 "utils.vala"
	cairo_rectangle (ctx, x3, y3, thick, thick);
#line 371 "utils.vala"
	cairo_clip (ctx);
#line 372 "utils.vala"
	cairo_paint (ctx);
#line 373 "utils.vala"
	cairo_restore (ctx);
#line 375 "utils.vala"
	cairo_save (ctx);
#line 376 "utils.vala"
	_tmp12_ = cairo_pattern_create_linear (x4, (gdouble) 0, x4 + size, (gdouble) 0);
#line 376 "utils.vala"
	_cairo_pattern_destroy0 (pat);
#line 376 "utils.vala"
	pat = _tmp12_;
#line 377 "utils.vala"
	_tmp13_ = pat;
#line 377 "utils.vala"
	synapse_gui_utils_add_shadow_stops (_tmp13_, r, g, b, size, a);
#line 378 "utils.vala"
	_tmp14_ = pat;
#line 378 "utils.vala"
	cairo_set_source (ctx, _tmp14_);
#line 379 "utils.vala"
	cairo_rectangle (ctx, x4, y2, size, y3 - y2);
#line 380 "utils.vala"
	cairo_clip (ctx);
#line 381 "utils.vala"
	cairo_paint (ctx);
#line 382 "utils.vala"
	cairo_restore (ctx);
#line 384 "utils.vala"
	cairo_save (ctx);
#line 385 "utils.vala"
	_tmp15_ = cairo_pattern_create_linear (x1, (gdouble) 0, x1 - size, (gdouble) 0);
#line 385 "utils.vala"
	_cairo_pattern_destroy0 (pat);
#line 385 "utils.vala"
	pat = _tmp15_;
#line 386 "utils.vala"
	_tmp16_ = pat;
#line 386 "utils.vala"
	synapse_gui_utils_add_shadow_stops (_tmp16_, r, g, b, size, a);
#line 387 "utils.vala"
	_tmp17_ = pat;
#line 387 "utils.vala"
	cairo_set_source (ctx, _tmp17_);
#line 388 "utils.vala"
	cairo_rectangle (ctx, x1 - size, y2, size, y3 - y2);
#line 389 "utils.vala"
	cairo_clip (ctx);
#line 390 "utils.vala"
	cairo_paint (ctx);
#line 391 "utils.vala"
	cairo_restore (ctx);
#line 393 "utils.vala"
	cairo_save (ctx);
#line 394 "utils.vala"
	_tmp18_ = cairo_pattern_create_linear ((gdouble) 0, y4, (gdouble) 0, y4 + size);
#line 394 "utils.vala"
	_cairo_pattern_destroy0 (pat);
#line 394 "utils.vala"
	pat = _tmp18_;
#line 395 "utils.vala"
	_tmp19_ = pat;
#line 395 "utils.vala"
	synapse_gui_utils_add_shadow_stops (_tmp19_, r, g, b, size, a);
#line 396 "utils.vala"
	_tmp20_ = pat;
#line 396 "utils.vala"
	cairo_set_source (ctx, _tmp20_);
#line 397 "utils.vala"
	cairo_rectangle (ctx, x2, y4, x3 - x2, size);
#line 398 "utils.vala"
	cairo_clip (ctx);
#line 399 "utils.vala"
	cairo_paint (ctx);
#line 400 "utils.vala"
	cairo_restore (ctx);
#line 402 "utils.vala"
	cairo_save (ctx);
#line 403 "utils.vala"
	_tmp21_ = cairo_pattern_create_linear ((gdouble) 0, y1, (gdouble) 0, y1 - size);
#line 403 "utils.vala"
	_cairo_pattern_destroy0 (pat);
#line 403 "utils.vala"
	pat = _tmp21_;
#line 404 "utils.vala"
	_tmp22_ = pat;
#line 404 "utils.vala"
	synapse_gui_utils_add_shadow_stops (_tmp22_, r, g, b, size, a);
#line 405 "utils.vala"
	_tmp23_ = pat;
#line 405 "utils.vala"
	cairo_set_source (ctx, _tmp23_);
#line 406 "utils.vala"
	cairo_rectangle (ctx, x2, y1 - size, x3 - x2, size);
#line 407 "utils.vala"
	cairo_clip (ctx);
#line 408 "utils.vala"
	cairo_paint (ctx);
#line 409 "utils.vala"
	cairo_restore (ctx);
#line 411 "utils.vala"
	cairo_restore (ctx);
#line 311 "utils.vala"
	_cairo_pattern_destroy0 (pat);
#line 2353 "utils.c"
}

static inline gpointer
synapse_gui_utils_color_helper_get_instance_private (SynapseGuiUtilsColorHelper* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseGuiUtilsColorHelper_private_offset);
}

static gpointer
_synapse_gui_utils_color_helper_ref0 (gpointer self)
{
#line 427 "utils.vala"
	return self ? synapse_gui_utils_color_helper_ref (self) : NULL;
#line 2367 "utils.c"
}

SynapseGuiUtilsColorHelper*
synapse_gui_utils_color_helper_get_default (void)
{
	SynapseGuiUtilsColorHelper* _tmp0_;
	SynapseGuiUtilsColorHelper* _tmp2_;
	SynapseGuiUtilsColorHelper* _tmp3_;
	SynapseGuiUtilsColorHelper* result;
#line 425 "utils.vala"
	_tmp0_ = synapse_gui_utils_color_helper_instance;
#line 425 "utils.vala"
	if (_tmp0_ == NULL) {
#line 2381 "utils.c"
		SynapseGuiUtilsColorHelper* _tmp1_;
#line 426 "utils.vala"
		_tmp1_ = synapse_gui_utils_color_helper_new ();
#line 426 "utils.vala"
		_synapse_gui_utils_color_helper_unref0 (synapse_gui_utils_color_helper_instance);
#line 426 "utils.vala"
		synapse_gui_utils_color_helper_instance = _tmp1_;
#line 2389 "utils.c"
	}
#line 427 "utils.vala"
	_tmp2_ = synapse_gui_utils_color_helper_instance;
#line 427 "utils.vala"
	_tmp3_ = _synapse_gui_utils_color_helper_ref0 (_tmp2_);
#line 427 "utils.vala"
	result = _tmp3_;
#line 427 "utils.vala"
	return result;
#line 2399 "utils.c"
}

static void
_synapse_gui_utils_color_helper_theme_changed_g_object_notify (GObject* _sender,
                                                               GParamSpec* pspec,
                                                               gpointer self)
{
#line 445 "utils.vala"
	synapse_gui_utils_color_helper_theme_changed ((SynapseGuiUtilsColorHelper*) self, _sender, pspec);
#line 2409 "utils.c"
}

static SynapseGuiUtilsColorHelper*
synapse_gui_utils_color_helper_construct (GType object_type)
{
	SynapseGuiUtilsColorHelper* self = NULL;
	GeeHashMap* _tmp0_;
	GtkWindow* window = NULL;
	GtkWindow* _tmp1_;
	GtkBox* box = NULL;
	GtkBox* _tmp2_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp3_;
	GtkStyleContext* _tmp4_;
	GtkStyleContext* _tmp5_;
	GtkStyleContext* _tmp6_;
	GtkStyleContext* _tmp7_;
	GtkSettings* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GtkSettings* _tmp11_;
#line 430 "utils.vala"
	self = (SynapseGuiUtilsColorHelper*) g_type_create_instance (object_type);
#line 432 "utils.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, SYNAPSE_GUI_UTILS_COLOR_HELPER_TYPE_COLOR, (GBoxedCopyFunc) synapse_gui_utils_color_helper_color_ref, (GDestroyNotify) synapse_gui_utils_color_helper_color_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 432 "utils.vala"
	_g_object_unref0 (self->priv->colormap);
#line 432 "utils.vala"
	self->priv->colormap = (GeeMap*) _tmp0_;
#line 436 "utils.vala"
	_tmp1_ = (GtkWindow*) gtk_window_new (GTK_WINDOW_TOPLEVEL);
#line 436 "utils.vala"
	g_object_ref_sink (_tmp1_);
#line 436 "utils.vala"
	window = _tmp1_;
#line 437 "utils.vala"
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
#line 437 "utils.vala"
	g_object_ref_sink (_tmp2_);
#line 437 "utils.vala"
	box = _tmp2_;
#line 438 "utils.vala"
	_tmp3_ = (GtkLabel*) gtk_label_new (NULL);
#line 438 "utils.vala"
	g_object_ref_sink (_tmp3_);
#line 438 "utils.vala"
	label = _tmp3_;
#line 439 "utils.vala"
	gtk_container_add ((GtkContainer*) window, (GtkWidget*) box);
#line 440 "utils.vala"
	gtk_box_pack_start (box, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
#line 441 "utils.vala"
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) label);
#line 441 "utils.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 441 "utils.vala"
	_g_object_unref0 (self->priv->fg_context);
#line 441 "utils.vala"
	self->priv->fg_context = _tmp5_;
#line 442 "utils.vala"
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) window);
#line 442 "utils.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 442 "utils.vala"
	_g_object_unref0 (self->priv->bg_context);
#line 442 "utils.vala"
	self->priv->bg_context = _tmp7_;
#line 444 "utils.vala"
	_tmp8_ = gtk_settings_get_default ();
#line 444 "utils.vala"
	g_object_get (_tmp8_, "gtk-theme-name", &_tmp9_, NULL);
#line 444 "utils.vala"
	_tmp10_ = _tmp9_;
#line 444 "utils.vala"
	_g_free0 (self->priv->current_theme);
#line 444 "utils.vala"
	self->priv->current_theme = _tmp10_;
#line 445 "utils.vala"
	_tmp11_ = gtk_settings_get_default ();
#line 445 "utils.vala"
	g_signal_connect ((GObject*) _tmp11_, "notify::gtk-theme-name", (GCallback) _synapse_gui_utils_color_helper_theme_changed_g_object_notify, self);
#line 430 "utils.vala"
	_g_object_unref0 (label);
#line 430 "utils.vala"
	_g_object_unref0 (box);
#line 430 "utils.vala"
	_g_object_unref0 (window);
#line 430 "utils.vala"
	return self;
#line 2499 "utils.c"
}

static SynapseGuiUtilsColorHelper*
synapse_gui_utils_color_helper_new (void)
{
#line 430 "utils.vala"
	return synapse_gui_utils_color_helper_construct (SYNAPSE_GUI_UTILS_TYPE_COLOR_HELPER);
#line 2507 "utils.c"
}

static void
synapse_gui_utils_color_helper_theme_changed (SynapseGuiUtilsColorHelper* self,
                                              GObject* o,
                                              GParamSpec* p)
{
	gchar* new_theme = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GeeMap* _tmp6_;
#line 448 "utils.vala"
	g_return_if_fail (self != NULL);
#line 448 "utils.vala"
	g_return_if_fail (o != NULL);
#line 448 "utils.vala"
	g_return_if_fail (p != NULL);
#line 450 "utils.vala"
	g_object_get (G_TYPE_CHECK_INSTANCE_CAST (o, gtk_settings_get_type (), GtkSettings), "gtk-theme-name", &_tmp0_, NULL);
#line 450 "utils.vala"
	_tmp1_ = _tmp0_;
#line 450 "utils.vala"
	new_theme = _tmp1_;
#line 451 "utils.vala"
	_tmp2_ = new_theme;
#line 451 "utils.vala"
	_tmp3_ = self->priv->current_theme;
#line 451 "utils.vala"
	if (g_strcmp0 (_tmp2_, _tmp3_) == 0) {
#line 452 "utils.vala"
		_g_free0 (new_theme);
#line 452 "utils.vala"
		return;
#line 2545 "utils.c"
	}
#line 453 "utils.vala"
	_tmp4_ = new_theme;
#line 453 "utils.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 453 "utils.vala"
	_g_free0 (self->priv->current_theme);
#line 453 "utils.vala"
	self->priv->current_theme = _tmp5_;
#line 454 "utils.vala"
	_tmp6_ = self->priv->colormap;
#line 454 "utils.vala"
	gee_map_clear (_tmp6_);
#line 448 "utils.vala"
	_g_free0 (new_theme);
#line 2561 "utils.c"
}

void
synapse_gui_utils_color_helper_get_color_colorized (SynapseGuiUtilsColorHelper* self,
                                                    gdouble* red,
                                                    gdouble* green,
                                                    gdouble* blue,
                                                    SynapseGuiStyleType t,
                                                    GtkStateFlags st,
                                                    SynapseGuiMod mod)
{
	SynapseGuiUtilsColorHelperColor* col = NULL;
	SynapseGuiUtilsColorHelperColor* _tmp0_;
	gdouble r = 0.0;
	gdouble g = 0.0;
	gdouble b = 0.0;
#line 457 "utils.vala"
	g_return_if_fail (self != NULL);
#line 460 "utils.vala"
	_tmp0_ = synapse_gui_utils_color_helper_get_color_from_map (self, t, st, mod);
#line 460 "utils.vala"
	col = _tmp0_;
#line 461 "utils.vala"
	r = *red;
#line 461 "utils.vala"
	g = *green;
#line 461 "utils.vala"
	b = *blue;
#line 462 "utils.vala"
	synapse_gui_utils_color_helper_color_colorize (&r, &g, &b, col->r, col->g, col->b);
#line 463 "utils.vala"
	*red = r;
#line 464 "utils.vala"
	*green = g;
#line 465 "utils.vala"
	*blue = b;
#line 457 "utils.vala"
	_synapse_gui_utils_color_helper_color_unref0 (col);
#line 2600 "utils.c"
}

static SynapseGuiUtilsColorHelperColor*
synapse_gui_utils_color_helper_get_color_from_map (SynapseGuiUtilsColorHelper* self,
                                                   SynapseGuiStyleType t,
                                                   GtkStateFlags st,
                                                   SynapseGuiMod mod)
{
	SynapseGuiUtilsColorHelperColor* col = NULL;
	gchar* key = NULL;
	gchar* _tmp0_;
	GeeMap* _tmp1_;
	const gchar* _tmp2_;
	SynapseGuiUtilsColorHelperColor* result;
#line 468 "utils.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 471 "utils.vala"
	_tmp0_ = g_strdup_printf ("%d%d%d", (gint) t, (gint) st, (gint) mod);
#line 471 "utils.vala"
	key = _tmp0_;
#line 472 "utils.vala"
	_tmp1_ = self->priv->colormap;
#line 472 "utils.vala"
	_tmp2_ = key;
#line 472 "utils.vala"
	if (gee_map_has_key (_tmp1_, _tmp2_)) {
#line 2627 "utils.c"
		GeeMap* _tmp3_;
		const gchar* _tmp4_;
		gpointer _tmp5_;
#line 473 "utils.vala"
		_tmp3_ = self->priv->colormap;
#line 473 "utils.vala"
		_tmp4_ = key;
#line 473 "utils.vala"
		_tmp5_ = gee_map_get (_tmp3_, _tmp4_);
#line 473 "utils.vala"
		_synapse_gui_utils_color_helper_color_unref0 (col);
#line 473 "utils.vala"
		col = (SynapseGuiUtilsColorHelperColor*) _tmp5_;
#line 2641 "utils.c"
	} else {
		SynapseGuiUtilsColorHelperColor* _tmp6_;
		SynapseGuiUtilsColorHelperColor* _tmp13_;
		GeeMap* _tmp14_;
		const gchar* _tmp15_;
		SynapseGuiUtilsColorHelperColor* _tmp16_;
#line 476 "utils.vala"
		_tmp6_ = synapse_gui_utils_color_helper_color_new ();
#line 476 "utils.vala"
		_synapse_gui_utils_color_helper_color_unref0 (col);
#line 476 "utils.vala"
		col = _tmp6_;
#line 477 "utils.vala"
		switch (t) {
#line 477 "utils.vala"
			case SYNAPSE_GUI_STYLE_TYPE_BG:
#line 477 "utils.vala"
			case SYNAPSE_GUI_STYLE_TYPE_BASE:
#line 2660 "utils.c"
			{
				SynapseGuiUtilsColorHelperColor* _tmp7_;
				GtkStyleContext* _tmp8_;
				GdkRGBA _tmp9_ = {0};
#line 482 "utils.vala"
				_tmp7_ = col;
#line 482 "utils.vala"
				_tmp8_ = self->priv->bg_context;
#line 482 "utils.vala"
				gtk_style_context_get_background_color (_tmp8_, st, &_tmp9_);
#line 482 "utils.vala"
				synapse_gui_utils_color_helper_color_init_from_gdk_color (_tmp7_, &_tmp9_);
#line 483 "utils.vala"
				break;
#line 2675 "utils.c"
			}
#line 477 "utils.vala"
			case SYNAPSE_GUI_STYLE_TYPE_TEXT:
#line 477 "utils.vala"
			case SYNAPSE_GUI_STYLE_TYPE_FG:
#line 2681 "utils.c"
			{
				SynapseGuiUtilsColorHelperColor* _tmp10_;
				GtkStyleContext* _tmp11_;
				GdkRGBA _tmp12_ = {0};
#line 486 "utils.vala"
				_tmp10_ = col;
#line 486 "utils.vala"
				_tmp11_ = self->priv->fg_context;
#line 486 "utils.vala"
				gtk_style_context_get_color (_tmp11_, st, &_tmp12_);
#line 486 "utils.vala"
				synapse_gui_utils_color_helper_color_init_from_gdk_color (_tmp10_, &_tmp12_);
#line 487 "utils.vala"
				break;
#line 2696 "utils.c"
			}
			default:
#line 477 "utils.vala"
			break;
#line 2701 "utils.c"
		}
#line 489 "utils.vala"
		_tmp13_ = col;
#line 489 "utils.vala"
		synapse_gui_utils_color_helper_color_apply_mod (_tmp13_, mod);
#line 490 "utils.vala"
		_tmp14_ = self->priv->colormap;
#line 490 "utils.vala"
		_tmp15_ = key;
#line 490 "utils.vala"
		_tmp16_ = col;
#line 490 "utils.vala"
		gee_map_set (_tmp14_, _tmp15_, _tmp16_);
#line 2715 "utils.c"
	}
#line 492 "utils.vala"
	result = col;
#line 492 "utils.vala"
	_g_free0 (key);
#line 492 "utils.vala"
	return result;
#line 2723 "utils.c"
}

void
synapse_gui_utils_color_helper_set_source_rgba (SynapseGuiUtilsColorHelper* self,
                                                cairo_t* ctx,
                                                gdouble alpha,
                                                SynapseGuiStyleType t,
                                                GtkStateFlags st,
                                                SynapseGuiMod mod)
{
	SynapseGuiUtilsColorHelperColor* col = NULL;
	SynapseGuiUtilsColorHelperColor* _tmp0_;
#line 495 "utils.vala"
	g_return_if_fail (self != NULL);
#line 495 "utils.vala"
	g_return_if_fail (ctx != NULL);
#line 497 "utils.vala"
	_tmp0_ = synapse_gui_utils_color_helper_get_color_from_map (self, t, st, mod);
#line 497 "utils.vala"
	col = _tmp0_;
#line 498 "utils.vala"
	cairo_set_source_rgba (ctx, col->r, col->g, col->b, alpha);
#line 495 "utils.vala"
	_synapse_gui_utils_color_helper_color_unref0 (col);
#line 2748 "utils.c"
}

void
synapse_gui_utils_color_helper_add_color_stop_rgba (SynapseGuiUtilsColorHelper* self,
                                                    cairo_pattern_t* pat,
                                                    gdouble val,
                                                    gdouble alpha,
                                                    SynapseGuiStyleType t,
                                                    GtkStateFlags st,
                                                    SynapseGuiMod mod)
{
	SynapseGuiUtilsColorHelperColor* col = NULL;
	SynapseGuiUtilsColorHelperColor* _tmp0_;
#line 501 "utils.vala"
	g_return_if_fail (self != NULL);
#line 501 "utils.vala"
	g_return_if_fail (pat != NULL);
#line 503 "utils.vala"
	_tmp0_ = synapse_gui_utils_color_helper_get_color_from_map (self, t, st, mod);
#line 503 "utils.vala"
	col = _tmp0_;
#line 504 "utils.vala"
	cairo_pattern_add_color_stop_rgba (pat, val, col->r, col->g, col->b, alpha);
#line 501 "utils.vala"
	_synapse_gui_utils_color_helper_color_unref0 (col);
#line 2774 "utils.c"
}

void
synapse_gui_utils_color_helper_get_rgb_from_mix (SynapseGuiUtilsColorHelper* self,
                                                 SynapseGuiStyleType t,
                                                 GtkStateFlags st,
                                                 SynapseGuiMod mod,
                                                 SynapseGuiStyleType t2,
                                                 GtkStateFlags st2,
                                                 SynapseGuiMod mod2,
                                                 gdouble mix_pct,
                                                 gdouble* r,
                                                 gdouble* g,
                                                 gdouble* b)
{
	gdouble _vala_r = 0.0;
	gdouble _vala_g = 0.0;
	gdouble _vala_b = 0.0;
	SynapseGuiUtilsColorHelperColor* col = NULL;
	SynapseGuiUtilsColorHelperColor* _tmp0_;
	SynapseGuiUtilsColorHelperColor* col2 = NULL;
	SynapseGuiUtilsColorHelperColor* _tmp1_;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
#line 507 "utils.vala"
	g_return_if_fail (self != NULL);
#line 512 "utils.vala"
	_tmp0_ = synapse_gui_utils_color_helper_get_color_from_map (self, t, st, mod);
#line 512 "utils.vala"
	col = _tmp0_;
#line 513 "utils.vala"
	_tmp1_ = synapse_gui_utils_color_helper_get_color_from_map (self, t2, st2, mod2);
#line 513 "utils.vala"
	col2 = _tmp1_;
#line 514 "utils.vala"
	synapse_gui_utils_color_helper_color_mix (col, col2, mix_pct, &_tmp2_, &_tmp3_, &_tmp4_);
#line 514 "utils.vala"
	_vala_r = _tmp2_;
#line 514 "utils.vala"
	_vala_g = _tmp3_;
#line 514 "utils.vala"
	_vala_b = _tmp4_;
#line 507 "utils.vala"
	_synapse_gui_utils_color_helper_color_unref0 (col2);
#line 507 "utils.vala"
	_synapse_gui_utils_color_helper_color_unref0 (col);
#line 507 "utils.vala"
	if (r) {
#line 507 "utils.vala"
		*r = _vala_r;
#line 2826 "utils.c"
	}
#line 507 "utils.vala"
	if (g) {
#line 507 "utils.vala"
		*g = _vala_g;
#line 2832 "utils.c"
	}
#line 507 "utils.vala"
	if (b) {
#line 507 "utils.vala"
		*b = _vala_b;
#line 2838 "utils.c"
	}
}

void
synapse_gui_utils_color_helper_get_rgb (SynapseGuiUtilsColorHelper* self,
                                        gdouble* r,
                                        gdouble* g,
                                        gdouble* b,
                                        SynapseGuiStyleType t,
                                        GtkStateFlags st,
                                        SynapseGuiMod mod)
{
	gdouble _vala_r = 0.0;
	gdouble _vala_g = 0.0;
	gdouble _vala_b = 0.0;
	SynapseGuiUtilsColorHelperColor* col = NULL;
	SynapseGuiUtilsColorHelperColor* _tmp0_;
#line 517 "utils.vala"
	g_return_if_fail (self != NULL);
#line 519 "utils.vala"
	_tmp0_ = synapse_gui_utils_color_helper_get_color_from_map (self, t, st, mod);
#line 519 "utils.vala"
	col = _tmp0_;
#line 520 "utils.vala"
	_vala_r = col->r;
#line 521 "utils.vala"
	_vala_g = col->g;
#line 522 "utils.vala"
	_vala_b = col->b;
#line 517 "utils.vala"
	_synapse_gui_utils_color_helper_color_unref0 (col);
#line 517 "utils.vala"
	if (r) {
#line 517 "utils.vala"
		*r = _vala_r;
#line 2874 "utils.c"
	}
#line 517 "utils.vala"
	if (g) {
#line 517 "utils.vala"
		*g = _vala_g;
#line 2880 "utils.c"
	}
#line 517 "utils.vala"
	if (b) {
#line 517 "utils.vala"
		*b = _vala_b;
#line 2886 "utils.c"
	}
}

gboolean
synapse_gui_utils_color_helper_is_dark_color (SynapseGuiUtilsColorHelper* self,
                                              SynapseGuiStyleType t,
                                              GtkStateFlags st,
                                              SynapseGuiMod mod)
{
	SynapseGuiUtilsColorHelperColor* col = NULL;
	SynapseGuiUtilsColorHelperColor* _tmp0_;
	gboolean result;
#line 525 "utils.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 527 "utils.vala"
	_tmp0_ = synapse_gui_utils_color_helper_get_color_from_map (self, t, st, mod);
#line 527 "utils.vala"
	col = _tmp0_;
#line 528 "utils.vala"
	result = synapse_gui_utils_color_helper_color_is_dark_color (col);
#line 528 "utils.vala"
	_synapse_gui_utils_color_helper_color_unref0 (col);
#line 528 "utils.vala"
	return result;
#line 2911 "utils.c"
}

static SynapseGuiUtilsColorHelperColor*
synapse_gui_utils_color_helper_color_construct (GType object_type)
{
	SynapseGuiUtilsColorHelperColor* self = NULL;
#line 536 "utils.vala"
	self = (SynapseGuiUtilsColorHelperColor*) g_type_create_instance (object_type);
#line 538 "utils.vala"
	self->r = (gdouble) 0;
#line 539 "utils.vala"
	self->g = (gdouble) 0;
#line 540 "utils.vala"
	self->b = (gdouble) 0;
#line 536 "utils.vala"
	return self;
#line 2928 "utils.c"
}

static SynapseGuiUtilsColorHelperColor*
synapse_gui_utils_color_helper_color_new (void)
{
#line 536 "utils.vala"
	return synapse_gui_utils_color_helper_color_construct (SYNAPSE_GUI_UTILS_COLOR_HELPER_TYPE_COLOR);
#line 2936 "utils.c"
}

static void
synapse_gui_utils_color_helper_color_init_from_gdk_color (SynapseGuiUtilsColorHelperColor* self,
                                                          GdkRGBA* col)
{
	GdkRGBA _tmp0_;
	GdkRGBA _tmp1_;
	GdkRGBA _tmp2_;
#line 542 "utils.vala"
	g_return_if_fail (self != NULL);
#line 542 "utils.vala"
	g_return_if_fail (col != NULL);
#line 544 "utils.vala"
	_tmp0_ = *col;
#line 544 "utils.vala"
	self->r = _tmp0_.red;
#line 545 "utils.vala"
	_tmp1_ = *col;
#line 545 "utils.vala"
	self->g = _tmp1_.green;
#line 546 "utils.vala"
	_tmp2_ = *col;
#line 546 "utils.vala"
	self->b = _tmp2_.blue;
#line 2962 "utils.c"
}

static void
synapse_gui_utils_color_helper_color_mix (SynapseGuiUtilsColorHelperColor* self,
                                          SynapseGuiUtilsColorHelperColor* target,
                                          gdouble mix_pct,
                                          gdouble* r,
                                          gdouble* g,
                                          gdouble* b)
{
	gdouble _vala_r = 0.0;
	gdouble _vala_g = 0.0;
	gdouble _vala_b = 0.0;
#line 565 "utils.vala"
	g_return_if_fail (self != NULL);
#line 565 "utils.vala"
	g_return_if_fail (target != NULL);
#line 567 "utils.vala"
	_vala_r = target->r - self->r;
#line 568 "utils.vala"
	_vala_g = target->g - self->g;
#line 569 "utils.vala"
	_vala_b = target->b - self->b;
#line 570 "utils.vala"
	_vala_r = self->r + (_vala_r * mix_pct);
#line 571 "utils.vala"
	_vala_g = self->g + (_vala_g * mix_pct);
#line 572 "utils.vala"
	_vala_b = self->b + (_vala_b * mix_pct);
#line 565 "utils.vala"
	if (r) {
#line 565 "utils.vala"
		*r = _vala_r;
#line 2996 "utils.c"
	}
#line 565 "utils.vala"
	if (g) {
#line 565 "utils.vala"
		*g = _vala_g;
#line 3002 "utils.c"
	}
#line 565 "utils.vala"
	if (b) {
#line 565 "utils.vala"
		*b = _vala_b;
#line 3008 "utils.c"
	}
}

static void
synapse_gui_utils_color_helper_color_apply_mod (SynapseGuiUtilsColorHelperColor* self,
                                                SynapseGuiMod k)
{
#line 575 "utils.vala"
	g_return_if_fail (self != NULL);
#line 577 "utils.vala"
	switch (k) {
#line 577 "utils.vala"
		case SYNAPSE_GUI_MOD_INVERTED:
#line 3022 "utils.c"
		{
#line 580 "utils.vala"
			synapse_gui_utils_rgb_invert_color (&self->r, &self->g, &self->b);
#line 581 "utils.vala"
			break;
#line 3028 "utils.c"
		}
#line 577 "utils.vala"
		case SYNAPSE_GUI_MOD_LIGHTER:
#line 3032 "utils.c"
		{
#line 583 "utils.vala"
			synapse_gui_utils_color_helper_color_shade (&self->r, &self->g, &self->b, 1.08);
#line 584 "utils.vala"
			break;
#line 3038 "utils.c"
		}
#line 577 "utils.vala"
		case SYNAPSE_GUI_MOD_DARKER:
#line 3042 "utils.c"
		{
#line 586 "utils.vala"
			synapse_gui_utils_color_helper_color_shade (&self->r, &self->g, &self->b, 0.92);
#line 587 "utils.vala"
			break;
#line 3048 "utils.c"
		}
#line 577 "utils.vala"
		case SYNAPSE_GUI_MOD_LIGHTEST:
#line 3052 "utils.c"
		{
#line 589 "utils.vala"
			synapse_gui_utils_color_helper_color_shade (&self->r, &self->g, &self->b, 1.2);
#line 590 "utils.vala"
			break;
#line 3058 "utils.c"
		}
#line 577 "utils.vala"
		case SYNAPSE_GUI_MOD_DARKEST:
#line 3062 "utils.c"
		{
#line 592 "utils.vala"
			synapse_gui_utils_color_helper_color_shade (&self->r, &self->g, &self->b, 0.8);
#line 593 "utils.vala"
			break;
#line 3068 "utils.c"
		}
		default:
		{
#line 595 "utils.vala"
			break;
#line 3074 "utils.c"
		}
	}
}

static gboolean
synapse_gui_utils_color_helper_color_is_dark_color (SynapseGuiUtilsColorHelperColor* self)
{
	gdouble h = 0.0;
	gdouble l = 0.0;
	gdouble s = 0.0;
	gboolean result;
#line 599 "utils.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 605 "utils.vala"
	h = self->r;
#line 606 "utils.vala"
	l = self->g;
#line 607 "utils.vala"
	s = self->b;
#line 609 "utils.vala"
	synapse_gui_utils_color_helper_color_murrine_rgb_to_hls (&h, &l, &s);
#line 610 "utils.vala"
	result = l < 0.40;
#line 610 "utils.vala"
	return result;
#line 3100 "utils.c"
}

static void
synapse_gui_utils_color_helper_color_colorize (gdouble* r,
                                               gdouble* g,
                                               gdouble* b,
                                               gdouble cr,
                                               gdouble cg,
                                               gdouble cb)
{
	gboolean _tmp0_ = FALSE;
#line 616 "utils.vala"
	if ((*r) == (*g)) {
#line 616 "utils.vala"
		_tmp0_ = (*g) == (*b);
#line 3116 "utils.c"
	} else {
#line 616 "utils.vala"
		_tmp0_ = FALSE;
#line 3120 "utils.c"
	}
#line 616 "utils.vala"
	if (!_tmp0_) {
#line 616 "utils.vala"
		return;
#line 3126 "utils.c"
	}
#line 617 "utils.vala"
	synapse_gui_utils_color_helper_color_murrine_rgb_to_hls (r, g, b);
#line 618 "utils.vala"
	synapse_gui_utils_color_helper_color_murrine_rgb_to_hls (&cr, &cg, &cb);
#line 620 "utils.vala"
	*r = cr;
#line 621 "utils.vala"
	*b = ((*b) * 0.25) + (cb * 0.85);
#line 622 "utils.vala"
	*g = ((*g) * 0.4) + (cg * 0.6);
#line 624 "utils.vala"
	synapse_gui_utils_color_helper_color_murrine_hls_to_rgb (r, g, b);
#line 3140 "utils.c"
}

static void
synapse_gui_utils_color_helper_color_murrine_rgb_to_hls (gdouble* r,
                                                         gdouble* g,
                                                         gdouble* b)
{
	gdouble min = 0.0;
	gdouble max = 0.0;
	gdouble red = 0.0;
	gdouble green = 0.0;
	gdouble blue = 0.0;
	gdouble h = 0.0;
	gdouble l = 0.0;
	gdouble s = 0.0;
	gdouble delta = 0.0;
#line 638 "utils.vala"
	h = (gdouble) 0;
#line 638 "utils.vala"
	l = (gdouble) 0;
#line 638 "utils.vala"
	s = (gdouble) 0;
#line 641 "utils.vala"
	red = *r;
#line 642 "utils.vala"
	green = *g;
#line 643 "utils.vala"
	blue = *b;
#line 645 "utils.vala"
	if (red > green) {
#line 647 "utils.vala"
		if (red > blue) {
#line 648 "utils.vala"
			max = red;
#line 3175 "utils.c"
		} else {
#line 650 "utils.vala"
			max = blue;
#line 3179 "utils.c"
		}
#line 652 "utils.vala"
		if (green < blue) {
#line 653 "utils.vala"
			min = green;
#line 3185 "utils.c"
		} else {
#line 655 "utils.vala"
			min = blue;
#line 3189 "utils.c"
		}
	} else {
#line 659 "utils.vala"
		if (green > blue) {
#line 660 "utils.vala"
			max = green;
#line 3196 "utils.c"
		} else {
#line 662 "utils.vala"
			max = blue;
#line 3200 "utils.c"
		}
#line 664 "utils.vala"
		if (red < blue) {
#line 665 "utils.vala"
			min = red;
#line 3206 "utils.c"
		} else {
#line 667 "utils.vala"
			min = blue;
#line 3210 "utils.c"
		}
	}
#line 670 "utils.vala"
	l = (max + min) / 2;
#line 671 "utils.vala"
	if (fabs (max - min) < 0.0001) {
#line 673 "utils.vala"
		h = (gdouble) 0;
#line 674 "utils.vala"
		s = (gdouble) 0;
#line 3221 "utils.c"
	} else {
#line 678 "utils.vala"
		if (l <= 0.5) {
#line 679 "utils.vala"
			s = (max - min) / (max + min);
#line 3227 "utils.c"
		} else {
#line 681 "utils.vala"
			s = (max - min) / ((2 - max) - min);
#line 3231 "utils.c"
		}
#line 683 "utils.vala"
		delta = max - min;
#line 684 "utils.vala"
		if (red == max) {
#line 685 "utils.vala"
			h = (green - blue) / delta;
#line 3239 "utils.c"
		} else {
#line 686 "utils.vala"
			if (green == max) {
#line 687 "utils.vala"
				h = 2 + ((blue - red) / delta);
#line 3245 "utils.c"
			} else {
#line 688 "utils.vala"
				if (blue == max) {
#line 689 "utils.vala"
					h = 4 + ((red - green) / delta);
#line 3251 "utils.c"
				}
			}
		}
#line 691 "utils.vala"
		h *= (gdouble) 60;
#line 692 "utils.vala"
		if (h < 0.0) {
#line 693 "utils.vala"
			h += (gdouble) 360;
#line 3261 "utils.c"
		}
	}
#line 696 "utils.vala"
	*r = h;
#line 697 "utils.vala"
	*g = l;
#line 698 "utils.vala"
	*b = s;
#line 3270 "utils.c"
}

static void
synapse_gui_utils_color_helper_color_murrine_hls_to_rgb (gdouble* h,
                                                         gdouble* l,
                                                         gdouble* s)
{
	gdouble hue = 0.0;
	gdouble lightness = 0.0;
	gdouble saturation = 0.0;
	gdouble m1 = 0.0;
	gdouble m2 = 0.0;
	gdouble r = 0.0;
	gdouble g = 0.0;
	gdouble b = 0.0;
#line 709 "utils.vala"
	r = (gdouble) 0;
#line 709 "utils.vala"
	g = (gdouble) 0;
#line 709 "utils.vala"
	b = (gdouble) 0;
#line 711 "utils.vala"
	lightness = *l;
#line 712 "utils.vala"
	saturation = *s;
#line 714 "utils.vala"
	if (lightness <= 0.5) {
#line 715 "utils.vala"
		m2 = lightness * (1 + saturation);
#line 3300 "utils.c"
	} else {
#line 717 "utils.vala"
		m2 = (lightness + saturation) - (lightness * saturation);
#line 3304 "utils.c"
	}
#line 719 "utils.vala"
	m1 = (2 * lightness) - m2;
#line 721 "utils.vala"
	if (saturation == ((gdouble) 0)) {
#line 723 "utils.vala"
		*h = lightness;
#line 724 "utils.vala"
		*l = lightness;
#line 725 "utils.vala"
		*s = lightness;
#line 3316 "utils.c"
	} else {
#line 729 "utils.vala"
		hue = (*h) + 120;
#line 730 "utils.vala"
		while (TRUE) {
#line 730 "utils.vala"
			if (!(hue > ((gdouble) 360))) {
#line 730 "utils.vala"
				break;
#line 3326 "utils.c"
			}
#line 731 "utils.vala"
			hue -= (gdouble) 360;
#line 3330 "utils.c"
		}
#line 732 "utils.vala"
		while (TRUE) {
#line 732 "utils.vala"
			if (!(hue < ((gdouble) 0))) {
#line 732 "utils.vala"
				break;
#line 3338 "utils.c"
			}
#line 733 "utils.vala"
			hue += (gdouble) 360;
#line 3342 "utils.c"
		}
#line 735 "utils.vala"
		if (hue < ((gdouble) 60)) {
#line 736 "utils.vala"
			r = m1 + (((m2 - m1) * hue) / 60);
#line 3348 "utils.c"
		} else {
#line 737 "utils.vala"
			if (hue < ((gdouble) 180)) {
#line 738 "utils.vala"
				r = m2;
#line 3354 "utils.c"
			} else {
#line 739 "utils.vala"
				if (hue < ((gdouble) 240)) {
#line 740 "utils.vala"
					r = m1 + (((m2 - m1) * (240 - hue)) / 60);
#line 3360 "utils.c"
				} else {
#line 742 "utils.vala"
					r = m1;
#line 3364 "utils.c"
				}
			}
		}
#line 744 "utils.vala"
		hue = *h;
#line 745 "utils.vala"
		while (TRUE) {
#line 745 "utils.vala"
			if (!(hue > ((gdouble) 360))) {
#line 745 "utils.vala"
				break;
#line 3376 "utils.c"
			}
#line 746 "utils.vala"
			hue -= (gdouble) 360;
#line 3380 "utils.c"
		}
#line 747 "utils.vala"
		while (TRUE) {
#line 747 "utils.vala"
			if (!(hue < ((gdouble) 0))) {
#line 747 "utils.vala"
				break;
#line 3388 "utils.c"
			}
#line 748 "utils.vala"
			hue += (gdouble) 360;
#line 3392 "utils.c"
		}
#line 750 "utils.vala"
		if (hue < ((gdouble) 60)) {
#line 751 "utils.vala"
			g = m1 + (((m2 - m1) * hue) / 60);
#line 3398 "utils.c"
		} else {
#line 752 "utils.vala"
			if (hue < ((gdouble) 180)) {
#line 753 "utils.vala"
				g = m2;
#line 3404 "utils.c"
			} else {
#line 754 "utils.vala"
				if (hue < ((gdouble) 240)) {
#line 755 "utils.vala"
					g = m1 + (((m2 - m1) * (240 - hue)) / 60);
#line 3410 "utils.c"
				} else {
#line 757 "utils.vala"
					g = m1;
#line 3414 "utils.c"
				}
			}
		}
#line 759 "utils.vala"
		hue = (*h) - 120;
#line 760 "utils.vala"
		while (TRUE) {
#line 760 "utils.vala"
			if (!(hue > ((gdouble) 360))) {
#line 760 "utils.vala"
				break;
#line 3426 "utils.c"
			}
#line 761 "utils.vala"
			hue -= (gdouble) 360;
#line 3430 "utils.c"
		}
#line 762 "utils.vala"
		while (TRUE) {
#line 762 "utils.vala"
			if (!(hue < ((gdouble) 0))) {
#line 762 "utils.vala"
				break;
#line 3438 "utils.c"
			}
#line 763 "utils.vala"
			hue += (gdouble) 360;
#line 3442 "utils.c"
		}
#line 765 "utils.vala"
		if (hue < ((gdouble) 60)) {
#line 766 "utils.vala"
			b = m1 + (((m2 - m1) * hue) / 60);
#line 3448 "utils.c"
		} else {
#line 767 "utils.vala"
			if (hue < ((gdouble) 180)) {
#line 768 "utils.vala"
				b = m2;
#line 3454 "utils.c"
			} else {
#line 769 "utils.vala"
				if (hue < ((gdouble) 240)) {
#line 770 "utils.vala"
					b = m1 + (((m2 - m1) * (240 - hue)) / 60);
#line 3460 "utils.c"
				} else {
#line 772 "utils.vala"
					b = m1;
#line 3464 "utils.c"
				}
			}
		}
#line 774 "utils.vala"
		*h = r;
#line 775 "utils.vala"
		*l = g;
#line 776 "utils.vala"
		*s = b;
#line 3474 "utils.c"
	}
}

static void
synapse_gui_utils_color_helper_color_shade (gdouble* r,
                                            gdouble* g,
                                            gdouble* b,
                                            gdouble k)
{
	gdouble red = 0.0;
	gdouble green = 0.0;
	gdouble blue = 0.0;
#line 782 "utils.vala"
	if (k == 1.0) {
#line 782 "utils.vala"
		return;
#line 3491 "utils.c"
	}
#line 788 "utils.vala"
	red = *r;
#line 789 "utils.vala"
	green = *g;
#line 790 "utils.vala"
	blue = *b;
#line 792 "utils.vala"
	synapse_gui_utils_color_helper_color_murrine_rgb_to_hls (&red, &green, &blue);
#line 794 "utils.vala"
	k = k - 1.0;
#line 796 "utils.vala"
	green += k;
#line 797 "utils.vala"
	if (green > 1.0) {
#line 798 "utils.vala"
		green = 1.0;
#line 3509 "utils.c"
	} else {
#line 799 "utils.vala"
		if (green < 0.0) {
#line 800 "utils.vala"
			green = 0.0;
#line 3515 "utils.c"
		}
	}
#line 802 "utils.vala"
	blue += k;
#line 803 "utils.vala"
	if (blue > 1.0) {
#line 804 "utils.vala"
		blue = 1.0;
#line 3524 "utils.c"
	} else {
#line 805 "utils.vala"
		if (blue < 0.0) {
#line 806 "utils.vala"
			blue = 0.0;
#line 3530 "utils.c"
		}
	}
#line 808 "utils.vala"
	synapse_gui_utils_color_helper_color_murrine_hls_to_rgb (&red, &green, &blue);
#line 810 "utils.vala"
	*r = red;
#line 811 "utils.vala"
	*g = green;
#line 812 "utils.vala"
	*b = blue;
#line 3541 "utils.c"
}

static void
synapse_gui_utils_color_helper_value_color_init (GValue* value)
{
#line 531 "utils.vala"
	value->data[0].v_pointer = NULL;
#line 3549 "utils.c"
}

static void
synapse_gui_utils_color_helper_value_color_free_value (GValue* value)
{
#line 531 "utils.vala"
	if (value->data[0].v_pointer) {
#line 531 "utils.vala"
		synapse_gui_utils_color_helper_color_unref (value->data[0].v_pointer);
#line 3559 "utils.c"
	}
}

static void
synapse_gui_utils_color_helper_value_color_copy_value (const GValue* src_value,
                                                       GValue* dest_value)
{
#line 531 "utils.vala"
	if (src_value->data[0].v_pointer) {
#line 531 "utils.vala"
		dest_value->data[0].v_pointer = synapse_gui_utils_color_helper_color_ref (src_value->data[0].v_pointer);
#line 3571 "utils.c"
	} else {
#line 531 "utils.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3575 "utils.c"
	}
}

static gpointer
synapse_gui_utils_color_helper_value_color_peek_pointer (const GValue* value)
{
#line 531 "utils.vala"
	return value->data[0].v_pointer;
#line 3584 "utils.c"
}

static gchar*
synapse_gui_utils_color_helper_value_color_collect_value (GValue* value,
                                                          guint n_collect_values,
                                                          GTypeCValue* collect_values,
                                                          guint collect_flags)
{
#line 531 "utils.vala"
	if (collect_values[0].v_pointer) {
#line 3595 "utils.c"
		SynapseGuiUtilsColorHelperColor * object;
		object = collect_values[0].v_pointer;
#line 531 "utils.vala"
		if (object->parent_instance.g_class == NULL) {
#line 531 "utils.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3602 "utils.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 531 "utils.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3606 "utils.c"
		}
#line 531 "utils.vala"
		value->data[0].v_pointer = synapse_gui_utils_color_helper_color_ref (object);
#line 3610 "utils.c"
	} else {
#line 531 "utils.vala"
		value->data[0].v_pointer = NULL;
#line 3614 "utils.c"
	}
#line 531 "utils.vala"
	return NULL;
#line 3618 "utils.c"
}

static gchar*
synapse_gui_utils_color_helper_value_color_lcopy_value (const GValue* value,
                                                        guint n_collect_values,
                                                        GTypeCValue* collect_values,
                                                        guint collect_flags)
{
	SynapseGuiUtilsColorHelperColor ** object_p;
	object_p = collect_values[0].v_pointer;
#line 531 "utils.vala"
	if (!object_p) {
#line 531 "utils.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3633 "utils.c"
	}
#line 531 "utils.vala"
	if (!value->data[0].v_pointer) {
#line 531 "utils.vala"
		*object_p = NULL;
#line 3639 "utils.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 531 "utils.vala"
		*object_p = value->data[0].v_pointer;
#line 3643 "utils.c"
	} else {
#line 531 "utils.vala"
		*object_p = synapse_gui_utils_color_helper_color_ref (value->data[0].v_pointer);
#line 3647 "utils.c"
	}
#line 531 "utils.vala"
	return NULL;
#line 3651 "utils.c"
}

static GParamSpec*
synapse_gui_utils_color_helper_param_spec_color (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags)
{
	SynapseGuiUtilsColorHelperParamSpecColor* spec;
#line 531 "utils.vala"
	g_return_val_if_fail (g_type_is_a (object_type, SYNAPSE_GUI_UTILS_COLOR_HELPER_TYPE_COLOR), NULL);
#line 531 "utils.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 531 "utils.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 531 "utils.vala"
	return G_PARAM_SPEC (spec);
#line 3670 "utils.c"
}

static gpointer
synapse_gui_utils_color_helper_value_get_color (const GValue* value)
{
#line 531 "utils.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_GUI_UTILS_COLOR_HELPER_TYPE_COLOR), NULL);
#line 531 "utils.vala"
	return value->data[0].v_pointer;
#line 3680 "utils.c"
}

static void
synapse_gui_utils_color_helper_value_set_color (GValue* value,
                                                gpointer v_object)
{
	SynapseGuiUtilsColorHelperColor * old;
#line 531 "utils.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_GUI_UTILS_COLOR_HELPER_TYPE_COLOR));
#line 531 "utils.vala"
	old = value->data[0].v_pointer;
#line 531 "utils.vala"
	if (v_object) {
#line 531 "utils.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_GUI_UTILS_COLOR_HELPER_TYPE_COLOR));
#line 531 "utils.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 531 "utils.vala"
		value->data[0].v_pointer = v_object;
#line 531 "utils.vala"
		synapse_gui_utils_color_helper_color_ref (value->data[0].v_pointer);
#line 3702 "utils.c"
	} else {
#line 531 "utils.vala"
		value->data[0].v_pointer = NULL;
#line 3706 "utils.c"
	}
#line 531 "utils.vala"
	if (old) {
#line 531 "utils.vala"
		synapse_gui_utils_color_helper_color_unref (old);
#line 3712 "utils.c"
	}
}

static void
synapse_gui_utils_color_helper_value_take_color (GValue* value,
                                                 gpointer v_object)
{
	SynapseGuiUtilsColorHelperColor * old;
#line 531 "utils.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_GUI_UTILS_COLOR_HELPER_TYPE_COLOR));
#line 531 "utils.vala"
	old = value->data[0].v_pointer;
#line 531 "utils.vala"
	if (v_object) {
#line 531 "utils.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_GUI_UTILS_COLOR_HELPER_TYPE_COLOR));
#line 531 "utils.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 531 "utils.vala"
		value->data[0].v_pointer = v_object;
#line 3733 "utils.c"
	} else {
#line 531 "utils.vala"
		value->data[0].v_pointer = NULL;
#line 3737 "utils.c"
	}
#line 531 "utils.vala"
	if (old) {
#line 531 "utils.vala"
		synapse_gui_utils_color_helper_color_unref (old);
#line 3743 "utils.c"
	}
}

static void
synapse_gui_utils_color_helper_color_class_init (SynapseGuiUtilsColorHelperColorClass * klass,
                                                 gpointer klass_data)
{
#line 531 "utils.vala"
	synapse_gui_utils_color_helper_color_parent_class = g_type_class_peek_parent (klass);
#line 531 "utils.vala"
	((SynapseGuiUtilsColorHelperColorClass *) klass)->finalize = synapse_gui_utils_color_helper_color_finalize;
#line 3755 "utils.c"
}

static void
synapse_gui_utils_color_helper_color_instance_init (SynapseGuiUtilsColorHelperColor * self,
                                                    gpointer klass)
{
#line 531 "utils.vala"
	self->ref_count = 1;
#line 3764 "utils.c"
}

static void
synapse_gui_utils_color_helper_color_finalize (SynapseGuiUtilsColorHelperColor * obj)
{
	SynapseGuiUtilsColorHelperColor * self;
#line 531 "utils.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_GUI_UTILS_COLOR_HELPER_TYPE_COLOR, SynapseGuiUtilsColorHelperColor);
#line 531 "utils.vala"
	g_signal_handlers_destroy (self);
#line 3775 "utils.c"
}

static GType
synapse_gui_utils_color_helper_color_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { synapse_gui_utils_color_helper_value_color_init, synapse_gui_utils_color_helper_value_color_free_value, synapse_gui_utils_color_helper_value_color_copy_value, synapse_gui_utils_color_helper_value_color_peek_pointer, "p", synapse_gui_utils_color_helper_value_color_collect_value, "p", synapse_gui_utils_color_helper_value_color_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SynapseGuiUtilsColorHelperColorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_gui_utils_color_helper_color_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseGuiUtilsColorHelperColor), 0, (GInstanceInitFunc) synapse_gui_utils_color_helper_color_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType synapse_gui_utils_color_helper_color_type_id;
	synapse_gui_utils_color_helper_color_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SynapseGuiUtilsColorHelperColor", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return synapse_gui_utils_color_helper_color_type_id;
}

static GType
synapse_gui_utils_color_helper_color_get_type (void)
{
	static volatile gsize synapse_gui_utils_color_helper_color_type_id__once = 0;
	if (g_once_init_enter (&synapse_gui_utils_color_helper_color_type_id__once)) {
		GType synapse_gui_utils_color_helper_color_type_id;
		synapse_gui_utils_color_helper_color_type_id = synapse_gui_utils_color_helper_color_get_type_once ();
		g_once_init_leave (&synapse_gui_utils_color_helper_color_type_id__once, synapse_gui_utils_color_helper_color_type_id);
	}
	return synapse_gui_utils_color_helper_color_type_id__once;
}

static gpointer
synapse_gui_utils_color_helper_color_ref (gpointer instance)
{
	SynapseGuiUtilsColorHelperColor * self;
	self = instance;
#line 531 "utils.vala"
	g_atomic_int_inc (&self->ref_count);
#line 531 "utils.vala"
	return instance;
#line 3810 "utils.c"
}

static void
synapse_gui_utils_color_helper_color_unref (gpointer instance)
{
	SynapseGuiUtilsColorHelperColor * self;
	self = instance;
#line 531 "utils.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 531 "utils.vala"
		SYNAPSE_GUI_UTILS_COLOR_HELPER_COLOR_GET_CLASS (self)->finalize (self);
#line 531 "utils.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3824 "utils.c"
	}
}

static void
synapse_gui_utils_value_color_helper_init (GValue* value)
{
#line 414 "utils.vala"
	value->data[0].v_pointer = NULL;
#line 3833 "utils.c"
}

static void
synapse_gui_utils_value_color_helper_free_value (GValue* value)
{
#line 414 "utils.vala"
	if (value->data[0].v_pointer) {
#line 414 "utils.vala"
		synapse_gui_utils_color_helper_unref (value->data[0].v_pointer);
#line 3843 "utils.c"
	}
}

static void
synapse_gui_utils_value_color_helper_copy_value (const GValue* src_value,
                                                 GValue* dest_value)
{
#line 414 "utils.vala"
	if (src_value->data[0].v_pointer) {
#line 414 "utils.vala"
		dest_value->data[0].v_pointer = synapse_gui_utils_color_helper_ref (src_value->data[0].v_pointer);
#line 3855 "utils.c"
	} else {
#line 414 "utils.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3859 "utils.c"
	}
}

static gpointer
synapse_gui_utils_value_color_helper_peek_pointer (const GValue* value)
{
#line 414 "utils.vala"
	return value->data[0].v_pointer;
#line 3868 "utils.c"
}

static gchar*
synapse_gui_utils_value_color_helper_collect_value (GValue* value,
                                                    guint n_collect_values,
                                                    GTypeCValue* collect_values,
                                                    guint collect_flags)
{
#line 414 "utils.vala"
	if (collect_values[0].v_pointer) {
#line 3879 "utils.c"
		SynapseGuiUtilsColorHelper * object;
		object = collect_values[0].v_pointer;
#line 414 "utils.vala"
		if (object->parent_instance.g_class == NULL) {
#line 414 "utils.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3886 "utils.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 414 "utils.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3890 "utils.c"
		}
#line 414 "utils.vala"
		value->data[0].v_pointer = synapse_gui_utils_color_helper_ref (object);
#line 3894 "utils.c"
	} else {
#line 414 "utils.vala"
		value->data[0].v_pointer = NULL;
#line 3898 "utils.c"
	}
#line 414 "utils.vala"
	return NULL;
#line 3902 "utils.c"
}

static gchar*
synapse_gui_utils_value_color_helper_lcopy_value (const GValue* value,
                                                  guint n_collect_values,
                                                  GTypeCValue* collect_values,
                                                  guint collect_flags)
{
	SynapseGuiUtilsColorHelper ** object_p;
	object_p = collect_values[0].v_pointer;
#line 414 "utils.vala"
	if (!object_p) {
#line 414 "utils.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3917 "utils.c"
	}
#line 414 "utils.vala"
	if (!value->data[0].v_pointer) {
#line 414 "utils.vala"
		*object_p = NULL;
#line 3923 "utils.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 414 "utils.vala"
		*object_p = value->data[0].v_pointer;
#line 3927 "utils.c"
	} else {
#line 414 "utils.vala"
		*object_p = synapse_gui_utils_color_helper_ref (value->data[0].v_pointer);
#line 3931 "utils.c"
	}
#line 414 "utils.vala"
	return NULL;
#line 3935 "utils.c"
}

GParamSpec*
synapse_gui_utils_param_spec_color_helper (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags)
{
	SynapseGuiUtilsParamSpecColorHelper* spec;
#line 414 "utils.vala"
	g_return_val_if_fail (g_type_is_a (object_type, SYNAPSE_GUI_UTILS_TYPE_COLOR_HELPER), NULL);
#line 414 "utils.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 414 "utils.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 414 "utils.vala"
	return G_PARAM_SPEC (spec);
#line 3954 "utils.c"
}

gpointer
synapse_gui_utils_value_get_color_helper (const GValue* value)
{
#line 414 "utils.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_GUI_UTILS_TYPE_COLOR_HELPER), NULL);
#line 414 "utils.vala"
	return value->data[0].v_pointer;
#line 3964 "utils.c"
}

void
synapse_gui_utils_value_set_color_helper (GValue* value,
                                          gpointer v_object)
{
	SynapseGuiUtilsColorHelper * old;
#line 414 "utils.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_GUI_UTILS_TYPE_COLOR_HELPER));
#line 414 "utils.vala"
	old = value->data[0].v_pointer;
#line 414 "utils.vala"
	if (v_object) {
#line 414 "utils.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_GUI_UTILS_TYPE_COLOR_HELPER));
#line 414 "utils.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 414 "utils.vala"
		value->data[0].v_pointer = v_object;
#line 414 "utils.vala"
		synapse_gui_utils_color_helper_ref (value->data[0].v_pointer);
#line 3986 "utils.c"
	} else {
#line 414 "utils.vala"
		value->data[0].v_pointer = NULL;
#line 3990 "utils.c"
	}
#line 414 "utils.vala"
	if (old) {
#line 414 "utils.vala"
		synapse_gui_utils_color_helper_unref (old);
#line 3996 "utils.c"
	}
}

void
synapse_gui_utils_value_take_color_helper (GValue* value,
                                           gpointer v_object)
{
	SynapseGuiUtilsColorHelper * old;
#line 414 "utils.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_GUI_UTILS_TYPE_COLOR_HELPER));
#line 414 "utils.vala"
	old = value->data[0].v_pointer;
#line 414 "utils.vala"
	if (v_object) {
#line 414 "utils.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_GUI_UTILS_TYPE_COLOR_HELPER));
#line 414 "utils.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 414 "utils.vala"
		value->data[0].v_pointer = v_object;
#line 4017 "utils.c"
	} else {
#line 414 "utils.vala"
		value->data[0].v_pointer = NULL;
#line 4021 "utils.c"
	}
#line 414 "utils.vala"
	if (old) {
#line 414 "utils.vala"
		synapse_gui_utils_color_helper_unref (old);
#line 4027 "utils.c"
	}
}

static void
synapse_gui_utils_color_helper_class_init (SynapseGuiUtilsColorHelperClass * klass,
                                           gpointer klass_data)
{
#line 414 "utils.vala"
	synapse_gui_utils_color_helper_parent_class = g_type_class_peek_parent (klass);
#line 414 "utils.vala"
	((SynapseGuiUtilsColorHelperClass *) klass)->finalize = synapse_gui_utils_color_helper_finalize;
#line 414 "utils.vala"
	g_type_class_adjust_private_offset (klass, &SynapseGuiUtilsColorHelper_private_offset);
#line 4041 "utils.c"
}

static void
synapse_gui_utils_color_helper_instance_init (SynapseGuiUtilsColorHelper * self,
                                              gpointer klass)
{
#line 414 "utils.vala"
	self->priv = synapse_gui_utils_color_helper_get_instance_private (self);
#line 414 "utils.vala"
	self->ref_count = 1;
#line 4052 "utils.c"
}

static void
synapse_gui_utils_color_helper_finalize (SynapseGuiUtilsColorHelper * obj)
{
	SynapseGuiUtilsColorHelper * self;
#line 414 "utils.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_GUI_UTILS_TYPE_COLOR_HELPER, SynapseGuiUtilsColorHelper);
#line 414 "utils.vala"
	g_signal_handlers_destroy (self);
#line 416 "utils.vala"
	_g_object_unref0 (self->priv->colormap);
#line 417 "utils.vala"
	_g_object_unref0 (self->priv->fg_context);
#line 418 "utils.vala"
	_g_object_unref0 (self->priv->bg_context);
#line 420 "utils.vala"
	_g_free0 (self->priv->current_theme);
#line 4071 "utils.c"
}

static GType
synapse_gui_utils_color_helper_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { synapse_gui_utils_value_color_helper_init, synapse_gui_utils_value_color_helper_free_value, synapse_gui_utils_value_color_helper_copy_value, synapse_gui_utils_value_color_helper_peek_pointer, "p", synapse_gui_utils_value_color_helper_collect_value, "p", synapse_gui_utils_value_color_helper_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SynapseGuiUtilsColorHelperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_gui_utils_color_helper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseGuiUtilsColorHelper), 0, (GInstanceInitFunc) synapse_gui_utils_color_helper_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType synapse_gui_utils_color_helper_type_id;
	synapse_gui_utils_color_helper_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SynapseGuiUtilsColorHelper", &g_define_type_info, &g_define_type_fundamental_info, 0);
	SynapseGuiUtilsColorHelper_private_offset = g_type_add_instance_private (synapse_gui_utils_color_helper_type_id, sizeof (SynapseGuiUtilsColorHelperPrivate));
	return synapse_gui_utils_color_helper_type_id;
}

GType
synapse_gui_utils_color_helper_get_type (void)
{
	static volatile gsize synapse_gui_utils_color_helper_type_id__once = 0;
	if (g_once_init_enter (&synapse_gui_utils_color_helper_type_id__once)) {
		GType synapse_gui_utils_color_helper_type_id;
		synapse_gui_utils_color_helper_type_id = synapse_gui_utils_color_helper_get_type_once ();
		g_once_init_leave (&synapse_gui_utils_color_helper_type_id__once, synapse_gui_utils_color_helper_type_id);
	}
	return synapse_gui_utils_color_helper_type_id__once;
}

gpointer
synapse_gui_utils_color_helper_ref (gpointer instance)
{
	SynapseGuiUtilsColorHelper * self;
	self = instance;
#line 414 "utils.vala"
	g_atomic_int_inc (&self->ref_count);
#line 414 "utils.vala"
	return instance;
#line 4107 "utils.c"
}

void
synapse_gui_utils_color_helper_unref (gpointer instance)
{
	SynapseGuiUtilsColorHelper * self;
	self = instance;
#line 414 "utils.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 414 "utils.vala"
		SYNAPSE_GUI_UTILS_COLOR_HELPER_GET_CLASS (self)->finalize (self);
#line 414 "utils.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4121 "utils.c"
	}
}

gboolean
synapse_gui_utils_is_point_in_mask (GtkWidget* w,
                                    gint x,
                                    gint y)
{
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	cairo_surface_t* mask = NULL;
	GtkAllocation _tmp6_;
	GtkAllocation _tmp7_;
	cairo_surface_t* _tmp8_;
	cairo_t* cr = NULL;
	cairo_surface_t* _tmp9_;
	cairo_t* _tmp10_;
	cairo_t* _tmp11_;
	cairo_t* ctx = NULL;
	GdkWindow* _tmp12_;
	cairo_t* _tmp13_;
	cairo_t* _tmp14_;
	cairo_t* _tmp15_;
	cairo_surface_t* _tmp16_;
	cairo_t* _tmp17_;
	guchar* data = NULL;
	cairo_surface_t* _tmp18_;
	guchar* _tmp19_;
	guchar* _tmp20_;
	cairo_surface_t* _tmp21_;
	guchar _tmp22_;
	gboolean result;
#line 817 "utils.vala"
	g_return_val_if_fail (w != NULL, FALSE);
#line 820 "utils.vala"
	gtk_widget_get_allocation (w, &_tmp0_);
#line 820 "utils.vala"
	allocation = _tmp0_;
#line 822 "utils.vala"
	if (x < 0) {
#line 822 "utils.vala"
		_tmp3_ = TRUE;
#line 4167 "utils.c"
	} else {
#line 822 "utils.vala"
		_tmp3_ = y < 0;
#line 4171 "utils.c"
	}
#line 822 "utils.vala"
	if (_tmp3_) {
#line 822 "utils.vala"
		_tmp2_ = TRUE;
#line 4177 "utils.c"
	} else {
		GtkAllocation _tmp4_;
#line 822 "utils.vala"
		_tmp4_ = allocation;
#line 822 "utils.vala"
		_tmp2_ = x >= _tmp4_.width;
#line 4184 "utils.c"
	}
#line 822 "utils.vala"
	if (_tmp2_) {
#line 822 "utils.vala"
		_tmp1_ = TRUE;
#line 4190 "utils.c"
	} else {
		GtkAllocation _tmp5_;
#line 822 "utils.vala"
		_tmp5_ = allocation;
#line 822 "utils.vala"
		_tmp1_ = y >= _tmp5_.height;
#line 4197 "utils.c"
	}
#line 822 "utils.vala"
	if (_tmp1_) {
#line 822 "utils.vala"
		result = FALSE;
#line 822 "utils.vala"
		return result;
#line 4205 "utils.c"
	}
#line 823 "utils.vala"
	if (!gtk_widget_is_composited (w)) {
#line 823 "utils.vala"
		result = TRUE;
#line 823 "utils.vala"
		return result;
#line 4213 "utils.c"
	}
#line 826 "utils.vala"
	_tmp6_ = allocation;
#line 826 "utils.vala"
	_tmp7_ = allocation;
#line 826 "utils.vala"
	_tmp8_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, _tmp6_.width, _tmp7_.height);
#line 826 "utils.vala"
	mask = _tmp8_;
#line 827 "utils.vala"
	_tmp9_ = mask;
#line 827 "utils.vala"
	_tmp10_ = cairo_create (_tmp9_);
#line 827 "utils.vala"
	cr = _tmp10_;
#line 828 "utils.vala"
	_tmp11_ = cr;
#line 828 "utils.vala"
	cairo_set_operator (_tmp11_, CAIRO_OPERATOR_SOURCE);
#line 830 "utils.vala"
	_tmp12_ = gtk_widget_get_window (w);
#line 830 "utils.vala"
	_tmp13_ = gdk_cairo_create (_tmp12_);
#line 830 "utils.vala"
	ctx = _tmp13_;
#line 831 "utils.vala"
	_tmp14_ = cr;
#line 831 "utils.vala"
	_tmp15_ = ctx;
#line 831 "utils.vala"
	_tmp16_ = cairo_get_target (_tmp15_);
#line 831 "utils.vala"
	cairo_set_source_surface (_tmp14_, _tmp16_, (gdouble) 0, (gdouble) 0);
#line 832 "utils.vala"
	_tmp17_ = cr;
#line 832 "utils.vala"
	cairo_paint (_tmp17_);
#line 834 "utils.vala"
	_tmp18_ = mask;
#line 834 "utils.vala"
	_tmp19_ = cairo_image_surface_get_data (_tmp18_);
#line 834 "utils.vala"
	data = _tmp19_;
#line 835 "utils.vala"
	_tmp20_ = data;
#line 835 "utils.vala"
	_tmp21_ = mask;
#line 835 "utils.vala"
	_tmp22_ = _tmp20_[(3 + (x * 4)) + (cairo_image_surface_get_stride (_tmp21_) * y)];
#line 835 "utils.vala"
	result = ((gint) _tmp22_) != 0;
#line 835 "utils.vala"
	_cairo_destroy0 (ctx);
#line 835 "utils.vala"
	_cairo_destroy0 (cr);
#line 835 "utils.vala"
	_cairo_surface_destroy0 (mask);
#line 835 "utils.vala"
	return result;
#line 4273 "utils.c"
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
#line 839 "utils.vala"
	g_atomic_int_inc (&_data6_->_ref_count_);
#line 839 "utils.vala"
	return _data6_;
#line 4283 "utils.c"
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
#line 839 "utils.vala"
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
#line 839 "utils.vala"
		_g_object_unref0 (_data6_->window);
#line 839 "utils.vala"
		g_slice_free (Block6Data, _data6_);
#line 4297 "utils.c"
	}
}

static gboolean
__lambda16_ (Block6Data* _data6_)
{
	gint _tmp0_;
	gboolean result;
#line 851 "utils.vala"
	if (_data6_->i >= 100) {
#line 852 "utils.vala"
		result = FALSE;
#line 852 "utils.vala"
		return result;
#line 4312 "utils.c"
	}
#line 853 "utils.vala"
	_data6_->i = _data6_->i + 1;
#line 853 "utils.vala"
	_tmp0_ = _data6_->i;
#line 854 "utils.vala"
	result = !synapse_gui_utils_try_grab_window (_data6_->window);
#line 854 "utils.vala"
	return result;
#line 4322 "utils.c"
}

static gboolean
___lambda16__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda16_ (self);
#line 850 "utils.vala"
	return result;
#line 4332 "utils.c"
}

void
synapse_gui_utils_present_window (GtkWindow* window)
{
	Block6Data* _data6_;
	GtkWindow* _tmp0_;
	guint32 timestamp = 0U;
	GdkWindow* _tmp1_;
	GdkWindow* _tmp2_;
	SynapseUtilsLoggerLogLevel _tmp3_;
	SynapseUtilsLoggerLogLevel _tmp4_;
#line 839 "utils.vala"
	g_return_if_fail (window != NULL);
#line 839 "utils.vala"
	_data6_ = g_slice_new0 (Block6Data);
#line 839 "utils.vala"
	_data6_->_ref_count_ = 1;
#line 839 "utils.vala"
	_tmp0_ = _g_object_ref0 (window);
#line 839 "utils.vala"
	_g_object_unref0 (_data6_->window);
#line 839 "utils.vala"
	_data6_->window = _tmp0_;
#line 842 "utils.vala"
	timestamp = gtk_get_current_event_time ();
#line 843 "utils.vala"
	gtk_window_present_with_time (_data6_->window, timestamp);
#line 844 "utils.vala"
	_tmp1_ = gtk_widget_get_window ((GtkWidget*) _data6_->window);
#line 844 "utils.vala"
	gdk_window_raise (_tmp1_);
#line 845 "utils.vala"
	_tmp2_ = gtk_widget_get_window ((GtkWidget*) _data6_->window);
#line 845 "utils.vala"
	gdk_window_focus (_tmp2_, timestamp);
#line 847 "utils.vala"
	_tmp3_ = synapse_utils_logger_get_DisplayLevel ();
#line 847 "utils.vala"
	_tmp4_ = _tmp3_;
#line 847 "utils.vala"
	if (_tmp4_ == SYNAPSE_UTILS_LOGGER_LOG_LEVEL_DEBUG) {
#line 847 "utils.vala"
		block6_data_unref (_data6_);
#line 847 "utils.vala"
		_data6_ = NULL;
#line 847 "utils.vala"
		return;
#line 4381 "utils.c"
	}
#line 849 "utils.vala"
	_data6_->i = 0;
#line 850 "utils.vala"
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ___lambda16__gsource_func, block6_data_ref (_data6_), block6_data_unref);
#line 839 "utils.vala"
	block6_data_unref (_data6_);
#line 839 "utils.vala"
	_data6_ = NULL;
#line 4391 "utils.c"
}

void
synapse_gui_utils_unpresent_window (GtkWindow* window)
{
	SynapseUtilsLoggerLogLevel _tmp0_;
	SynapseUtilsLoggerLogLevel _tmp1_;
	guint32 time = 0U;
	GdkDevice* pointer = NULL;
	GdkDisplay* _tmp2_;
	GdkDeviceManager* _tmp3_;
	GdkDevice* _tmp4_;
	GdkDevice* _tmp5_;
	GdkDevice* keyboard = NULL;
	GdkDevice* _tmp6_;
	GdkDevice* _tmp7_;
	GdkDevice* _tmp8_;
	GdkDevice* _tmp9_;
	GdkDevice* _tmp10_;
	GdkDevice* _tmp11_;
#line 858 "utils.vala"
	g_return_if_fail (window != NULL);
#line 860 "utils.vala"
	_tmp0_ = synapse_utils_logger_get_DisplayLevel ();
#line 860 "utils.vala"
	_tmp1_ = _tmp0_;
#line 860 "utils.vala"
	if (_tmp1_ == SYNAPSE_UTILS_LOGGER_LOG_LEVEL_DEBUG) {
#line 860 "utils.vala"
		return;
#line 4422 "utils.c"
	}
#line 861 "utils.vala"
	time = gtk_get_current_event_time ();
#line 863 "utils.vala"
	_tmp2_ = gdk_display_get_default ();
#line 863 "utils.vala"
	_tmp3_ = gdk_display_get_device_manager (_tmp2_);
#line 863 "utils.vala"
	_tmp4_ = gdk_device_manager_get_client_pointer (_tmp3_);
#line 863 "utils.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 863 "utils.vala"
	pointer = _tmp5_;
#line 864 "utils.vala"
	_tmp6_ = pointer;
#line 864 "utils.vala"
	_tmp7_ = gdk_device_get_associated_device (_tmp6_);
#line 864 "utils.vala"
	_tmp8_ = _tmp7_;
#line 864 "utils.vala"
	_tmp9_ = _g_object_ref0 (_tmp8_);
#line 864 "utils.vala"
	keyboard = _tmp9_;
#line 866 "utils.vala"
	_tmp10_ = pointer;
#line 866 "utils.vala"
	gdk_device_ungrab (_tmp10_, time);
#line 867 "utils.vala"
	_tmp11_ = keyboard;
#line 867 "utils.vala"
	if (_tmp11_ != NULL) {
#line 4454 "utils.c"
		GdkDevice* _tmp12_;
#line 868 "utils.vala"
		_tmp12_ = keyboard;
#line 868 "utils.vala"
		gdk_device_ungrab (_tmp12_, time);
#line 4460 "utils.c"
	}
#line 869 "utils.vala"
	gtk_grab_remove ((GtkWidget*) window);
#line 858 "utils.vala"
	_g_object_unref0 (keyboard);
#line 858 "utils.vala"
	_g_object_unref0 (pointer);
#line 4468 "utils.c"
}

gboolean
synapse_gui_utils_try_grab_window (GtkWindow* window)
{
	guint time = 0U;
	GdkDevice* pointer = NULL;
	GdkDisplay* _tmp0_;
	GdkDeviceManager* _tmp1_;
	GdkDevice* _tmp2_;
	GdkDevice* _tmp3_;
	GdkDevice* keyboard = NULL;
	GdkDevice* _tmp4_;
	GdkDevice* _tmp5_;
	GdkDevice* _tmp6_;
	GdkDevice* _tmp7_;
	GdkDevice* _tmp8_;
	GdkWindow* _tmp9_;
	gboolean result;
#line 872 "utils.vala"
	g_return_val_if_fail (window != NULL, FALSE);
#line 874 "utils.vala"
	time = (guint) gtk_get_current_event_time ();
#line 875 "utils.vala"
	_tmp0_ = gdk_display_get_default ();
#line 875 "utils.vala"
	_tmp1_ = gdk_display_get_device_manager (_tmp0_);
#line 875 "utils.vala"
	_tmp2_ = gdk_device_manager_get_client_pointer (_tmp1_);
#line 875 "utils.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 875 "utils.vala"
	pointer = _tmp3_;
#line 876 "utils.vala"
	_tmp4_ = pointer;
#line 876 "utils.vala"
	_tmp5_ = gdk_device_get_associated_device (_tmp4_);
#line 876 "utils.vala"
	_tmp6_ = _tmp5_;
#line 876 "utils.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 876 "utils.vala"
	keyboard = _tmp7_;
#line 878 "utils.vala"
	_tmp8_ = pointer;
#line 878 "utils.vala"
	_tmp9_ = gtk_widget_get_window ((GtkWidget*) window);
#line 878 "utils.vala"
	if (gdk_device_grab (_tmp8_, _tmp9_, GDK_OWNERSHIP_NONE, TRUE, (GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK) | GDK_POINTER_MOTION_MASK, NULL, (guint32) time) == GDK_GRAB_SUCCESS) {
#line 4518 "utils.c"
		gboolean _tmp10_ = FALSE;
		GdkDevice* _tmp11_;
#line 887 "utils.vala"
		_tmp11_ = keyboard;
#line 887 "utils.vala"
		if (_tmp11_ != NULL) {
#line 4525 "utils.c"
			GdkDevice* _tmp12_;
			GdkWindow* _tmp13_;
#line 887 "utils.vala"
			_tmp12_ = keyboard;
#line 887 "utils.vala"
			_tmp13_ = gtk_widget_get_window ((GtkWidget*) window);
#line 887 "utils.vala"
			_tmp10_ = gdk_device_grab (_tmp12_, _tmp13_, GDK_OWNERSHIP_NONE, TRUE, GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK, NULL, (guint32) time) == GDK_GRAB_SUCCESS;
#line 4534 "utils.c"
		} else {
#line 887 "utils.vala"
			_tmp10_ = FALSE;
#line 4538 "utils.c"
		}
#line 887 "utils.vala"
		if (_tmp10_) {
#line 894 "utils.vala"
			gtk_grab_add ((GtkWidget*) window);
#line 895 "utils.vala"
			result = TRUE;
#line 895 "utils.vala"
			_g_object_unref0 (keyboard);
#line 895 "utils.vala"
			_g_object_unref0 (pointer);
#line 895 "utils.vala"
			return result;
#line 4552 "utils.c"
		} else {
			GdkDevice* _tmp14_;
#line 897 "utils.vala"
			_tmp14_ = pointer;
#line 897 "utils.vala"
			gdk_device_ungrab (_tmp14_, (guint32) time);
#line 898 "utils.vala"
			result = FALSE;
#line 898 "utils.vala"
			_g_object_unref0 (keyboard);
#line 898 "utils.vala"
			_g_object_unref0 (pointer);
#line 898 "utils.vala"
			return result;
#line 4567 "utils.c"
		}
	}
#line 901 "utils.vala"
	result = FALSE;
#line 901 "utils.vala"
	_g_object_unref0 (keyboard);
#line 901 "utils.vala"
	_g_object_unref0 (pointer);
#line 901 "utils.vala"
	return result;
#line 4578 "utils.c"
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
#line 24 "controller.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 4588 "utils.c"
		gssize i;
#line 24 "controller.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 24 "controller.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 24 "controller.vala"
				destroy_func (((gpointer*) array)[i]);
#line 4596 "utils.c"
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
#line 24 "controller.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 24 "controller.vala"
	g_free (array);
#line 4611 "utils.c"
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
#line 24 "controller.vala"
	if (array) {
#line 24 "controller.vala"
		while (((gpointer*) array)[length]) {
#line 24 "controller.vala"
			length++;
#line 4625 "utils.c"
		}
	}
#line 24 "controller.vala"
	return length;
#line 4630 "utils.c"
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
#line 24 "controller.vala"
	if (mem && byte_size != 0) {
#line 24 "controller.vala"
		new_mem = g_malloc (byte_size);
#line 24 "controller.vala"
		memcpy (new_mem, mem, byte_size);
#line 4644 "utils.c"
	} else {
#line 24 "controller.vala"
		new_mem = NULL;
#line 4648 "utils.c"
	}
#line 24 "controller.vala"
	return new_mem;
#line 4652 "utils.c"
}

