/* RsyncTask.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from RsyncTask.vala, do not modify */

/*
 * RsyncTask.vala
 *
 * Copyright 2012-2018 Tony George <teejeetech@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <gee.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ASYNC_TASK (async_task_get_type ())
#define ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASYNC_TASK, AsyncTask))
#define ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASYNC_TASK, AsyncTaskClass))
#define IS_ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASYNC_TASK))
#define IS_ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASYNC_TASK))
#define ASYNC_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASYNC_TASK, AsyncTaskClass))

typedef struct _AsyncTask AsyncTask;
typedef struct _AsyncTaskClass AsyncTaskClass;
typedef struct _AsyncTaskPrivate AsyncTaskPrivate;
typedef enum  {
	APP_STATUS_NOT_STARTED,
	APP_STATUS_RUNNING,
	APP_STATUS_PAUSED,
	APP_STATUS_FINISHED,
	APP_STATUS_CANCELLED,
	APP_STATUS_PASSWORD_REQUIRED
} AppStatus;

#define TYPE_APP_STATUS (app_status_get_type ())

#define TYPE_RSYNC_TASK (rsync_task_get_type ())
#define RSYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RSYNC_TASK, RsyncTask))
#define RSYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RSYNC_TASK, RsyncTaskClass))
#define IS_RSYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RSYNC_TASK))
#define IS_RSYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RSYNC_TASK))
#define RSYNC_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RSYNC_TASK, RsyncTaskClass))

typedef struct _RsyncTask RsyncTask;
typedef struct _RsyncTaskClass RsyncTaskClass;
typedef struct _RsyncTaskPrivate RsyncTaskPrivate;
enum  {
	RSYNC_TASK_0_PROPERTY,
	RSYNC_TASK_NUM_PROPERTIES
};
static GParamSpec* rsync_task_properties[RSYNC_TASK_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_FILE_ITEM (file_item_get_type ())
#define FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILE_ITEM, FileItem))
#define FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILE_ITEM, FileItemClass))
#define IS_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILE_ITEM))
#define IS_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILE_ITEM))
#define FILE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILE_ITEM, FileItemClass))

typedef struct _FileItem FileItem;
typedef struct _FileItemClass FileItemClass;
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
typedef struct _FileItemPrivate FileItemPrivate;

struct _AsyncTask {
	GObject parent_instance;
	AsyncTaskPrivate * priv;
	GDataOutputStream* dos_log;
	gboolean is_terminated;
	GPid child_pid;
	gchar* script_file;
	gchar* working_dir;
	gchar* log_file;
	gboolean background_mode;
	AppStatus status;
	GMutex status_line_mutex;
	gint exit_code;
	gchar* error_msg;
	GTimer* timer;
	gdouble progress;
	gdouble percent;
	gint64 prg_count;
	gint64 prg_count_total;
	gint64 prg_bytes;
	gint64 prg_bytes_total;
	gchar* eta;
};

struct _AsyncTaskClass {
	GObjectClass parent_class;
	void (*parse_stdout_line) (AsyncTask* self, const gchar* out_line);
	void (*parse_stderr_line) (AsyncTask* self, const gchar* err_line);
	void (*finish_task) (AsyncTask* self);
};

struct _RsyncTask {
	AsyncTask parent_instance;
	RsyncTaskPrivate * priv;
	gboolean delete_extra;
	gboolean delete_after;
	gboolean delete_excluded;
	gboolean relative;
	gchar* rsync_log_file;
	gchar* exclude_from_file;
	gchar* link_from_path;
	gchar* source_path;
	gchar* dest_path;
	gboolean verbose;
	gboolean io_nice;
	gboolean dry_run;
	GQueue* status_lines;
	gint64 status_line_count;
	gint64 total_size;
	gint64 count_created;
	gint64 count_deleted;
	gint64 count_modified;
	gint64 count_checksum;
	gint64 count_size;
	gint64 count_timestamp;
	gint64 count_permissions;
	gint64 count_owner;
	gint64 count_group;
	gint64 count_unchanged;
	GString* log;
};

struct _RsyncTaskClass {
	AsyncTaskClass parent_class;
};

struct _RsyncTaskPrivate {
	GeeHashMap* regex_list;
};

struct _FileItem {
	GObject parent_instance;
	FileItemPrivate * priv;
	gchar* file_name;
	gchar* file_location;
	gchar* file_path;
	gchar* file_path_prefix;
	GFileType file_type;
	GDateTime* modified;
	gchar* permissions;
	gchar* owner_user;
	gchar* owner_group;
	gchar* content_type;
	gchar* file_status;
	gboolean is_selected;
	gboolean is_symlink;
	gchar* symlink_target;
	glong file_count;
	glong dir_count;
	GIcon* icon;
};

struct _FileItemClass {
	GObjectClass parent_class;
};

static gint RsyncTask_private_offset;
static gpointer rsync_task_parent_class = NULL;

VALA_EXTERN GType async_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AsyncTask, g_object_unref)
VALA_EXTERN GType app_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType rsync_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RsyncTask, g_object_unref)
VALA_EXTERN void async_task_parse_stdout_line (AsyncTask* self,
                                   const gchar* out_line);
VALA_EXTERN void async_task_parse_stderr_line (AsyncTask* self,
                                   const gchar* err_line);
VALA_EXTERN void async_task_finish_task (AsyncTask* self);
static void _g_free0_ (gpointer var);
static inline void _g_queue_free__g_free0_ (GQueue* self);
VALA_EXTERN RsyncTask* rsync_task_new (void);
VALA_EXTERN RsyncTask* rsync_task_construct (GType object_type);
VALA_EXTERN AsyncTask* async_task_construct (GType object_type);
static void rsync_task_init_regular_expressions (RsyncTask* self);
VALA_EXTERN void tee_jee_logging_log_error (const gchar* message,
                                gboolean highlight,
                                gboolean is_warning);
VALA_EXTERN void rsync_task_prepare (RsyncTask* self);
static gchar* rsync_task_build_script (RsyncTask* self);
VALA_EXTERN void tee_jee_logging_log_debug (const gchar* message);
VALA_EXTERN gchar* tee_jee_process_helper_save_bash_script_temp (const gchar* commands,
                                                     const gchar* script_path,
                                                     gboolean force_locale,
                                                     gboolean supress_errors);
VALA_EXTERN gchar* tee_jee_file_system_escape_single_quote (const gchar* file_path);
VALA_EXTERN gchar* tee_jee_file_system_remove_trailing_slash (const gchar* path);
VALA_EXTERN GType file_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FileItem, g_object_unref)
VALA_EXTERN GeeArrayList* rsync_task_parse_log (RsyncTask* self,
                                    const gchar* log_file_path);
VALA_EXTERN gboolean tee_jee_file_system_file_exists (const gchar* file_path);
VALA_EXTERN gint64* tee_jee_file_system_file_line_count (const gchar* file_path);
static gint64* _int64_dup (gint64* self);
VALA_EXTERN gchar* tee_jee_file_system_path_combine (const gchar* path1,
                                         const gchar* path2);
VALA_EXTERN gchar* tee_jee_file_system_file_parent (const gchar* file_path);
VALA_EXTERN FileItem* file_item_new_from_disk_path_with_basic_info (const gchar* _file_path);
VALA_EXTERN FileItem* file_item_construct_from_disk_path_with_basic_info (GType object_type,
                                                              const gchar* _file_path);
VALA_EXTERN void tee_jee_logging_log_msg (const gchar* message,
                              gboolean highlight);
VALA_EXTERN gboolean tee_jee_file_system_file_gzip (const gchar* src_file);
VALA_EXTERN void rsync_task_execute (RsyncTask* self);
VALA_EXTERN gboolean async_task_begin (AsyncTask* self);
static void rsync_task_real_parse_stdout_line (AsyncTask* base,
                                        const gchar* out_line);
VALA_EXTERN gboolean rsync_task_update_progress_parse_console_output (RsyncTask* self,
                                                          const gchar* line);
static void rsync_task_real_parse_stderr_line (AsyncTask* base,
                                        const gchar* err_line);
VALA_EXTERN void async_task_set_status_line (AsyncTask* self,
                                 const gchar* value);
static void rsync_task_real_finish_task (AsyncTask* base);
VALA_EXTERN gboolean tee_jee_file_system_file_write (const gchar* file_path,
                                         const gchar* contents);
VALA_EXTERN gint rsync_task_read_status (RsyncTask* self);
VALA_EXTERN gchar* tee_jee_file_system_file_read (const gchar* file_path);
static void rsync_task_finalize (GObject * obj);
static GType rsync_task_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
rsync_task_get_instance_private (RsyncTask* self)
{
	return G_STRUCT_MEMBER_P (self, RsyncTask_private_offset);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_queue_free__g_free0_ (GQueue* self)
{
	g_queue_free_full (self, (GDestroyNotify) _g_free0_);
}

RsyncTask*
rsync_task_construct (GType object_type)
{
	RsyncTask * self = NULL;
	GQueue* _tmp0_;
	self = (RsyncTask*) async_task_construct (object_type);
	rsync_task_init_regular_expressions (self);
	_tmp0_ = g_queue_new ();
	(self->status_lines == NULL) ? NULL : (self->status_lines = (_g_queue_free__g_free0_ (self->status_lines), NULL));
	self->status_lines = _tmp0_;
	return self;
}

RsyncTask*
rsync_task_new (void)
{
	return rsync_task_construct (TYPE_RSYNC_TASK);
}

static void
rsync_task_init_regular_expressions (RsyncTask* self)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->regex_list;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_REGEX, (GBoxedCopyFunc) g_regex_ref, (GDestroyNotify) g_regex_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->regex_list);
	self->priv->regex_list = _tmp1_;
	{
		GRegex* _tmp2_ = NULL;
		GRegex* _tmp3_;
		GeeHashMap* _tmp4_;
		GRegex* _tmp5_ = NULL;
		GRegex* _tmp6_;
		GeeHashMap* _tmp7_;
		GRegex* _tmp8_ = NULL;
		GRegex* _tmp9_;
		GeeHashMap* _tmp10_;
		GRegex* _tmp11_ = NULL;
		GRegex* _tmp12_;
		GeeHashMap* _tmp13_;
		GRegex* _tmp14_ = NULL;
		GRegex* _tmp15_;
		GeeHashMap* _tmp16_;
		GRegex* _tmp17_ = NULL;
		GRegex* _tmp18_;
		GeeHashMap* _tmp19_;
		GRegex* _tmp20_ = NULL;
		GRegex* _tmp21_;
		GeeHashMap* _tmp22_;
		GRegex* _tmp23_ = NULL;
		GRegex* _tmp24_;
		GeeHashMap* _tmp25_;
		GRegex* _tmp26_ = NULL;
		GRegex* _tmp27_;
		GeeHashMap* _tmp28_;
		GRegex* _tmp29_ = NULL;
		GRegex* _tmp30_;
		GeeHashMap* _tmp31_;
		_tmp3_ = g_regex_new ("([<>ch.*])([.fdLDS])(c|\\+|\\.| )(s|\\+|\\.| )(t|\\+|\\.| )(p|\\+|\\.|" \
" )(o|\\+|\\.| )(g|\\+|\\.| )(u|\\+|\\.| )(a|\\+|\\.| )(x|\\+|\\.| ) (." \
"*)", 0, 0, &_inner_error0_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = self->priv->regex_list;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp4_, "status", _tmp2_);
		_tmp6_ = g_regex_new ("([<>ch.*])([.fdLDS])[+]{9} (.*)", 0, 0, &_inner_error0_);
		_tmp5_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (_tmp2_);
			goto __catch0_g_error;
		}
		_tmp7_ = self->priv->regex_list;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp7_, "created", _tmp5_);
		_tmp9_ = g_regex_new ("[0-9\\/]+ [0-9:.]+ \\[[0-9]+\\] ([<>ch.*])([.fdLDS])[+]{9} (.*)", 0, 0, &_inner_error0_);
		_tmp8_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (_tmp5_);
			_g_regex_unref0 (_tmp2_);
			goto __catch0_g_error;
		}
		_tmp10_ = self->priv->regex_list;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp10_, "log-created", _tmp8_);
		_tmp12_ = g_regex_new ("\\*deleting[ \\t]+(.*)", 0, 0, &_inner_error0_);
		_tmp11_ = _tmp12_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (_tmp8_);
			_g_regex_unref0 (_tmp5_);
			_g_regex_unref0 (_tmp2_);
			goto __catch0_g_error;
		}
		_tmp13_ = self->priv->regex_list;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp13_, "deleted", _tmp11_);
		_tmp15_ = g_regex_new ("[0-9\\/]+ [0-9:.]+ \\[[0-9]+\\] \\*deleting[ \\t]+(.*)", 0, 0, &_inner_error0_);
		_tmp14_ = _tmp15_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (_tmp11_);
			_g_regex_unref0 (_tmp8_);
			_g_regex_unref0 (_tmp5_);
			_g_regex_unref0 (_tmp2_);
			goto __catch0_g_error;
		}
		_tmp16_ = self->priv->regex_list;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp16_, "log-deleted", _tmp14_);
		_tmp18_ = g_regex_new ("([<>ch.])([.fdLDS])(c|\\+|\\.| )(s|\\+|\\.| )(t|\\+|\\.| )(p|\\+|\\.| " \
")(o|\\+|\\.| )(g|\\+|\\.| )(u|\\+|\\.| )(a|\\+|\\.| )(x|\\+|\\.) (.*)", 0, 0, &_inner_error0_);
		_tmp17_ = _tmp18_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (_tmp14_);
			_g_regex_unref0 (_tmp11_);
			_g_regex_unref0 (_tmp8_);
			_g_regex_unref0 (_tmp5_);
			_g_regex_unref0 (_tmp2_);
			goto __catch0_g_error;
		}
		_tmp19_ = self->priv->regex_list;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp19_, "modified", _tmp17_);
		_tmp21_ = g_regex_new ("[0-9\\/]+ [0-9:.]+ \\[[0-9]+\\] ([<>ch.])([.fdLDS])(c|\\+|\\.| )(s|\\+" \
"|\\.| )(t|\\+|\\.| )(p|\\+|\\.| )(o|\\+|\\.| )(g|\\+|\\.| )(u|\\+|\\.|" \
" )(a|\\+|\\.| )(x|\\+|\\.) (.*)", 0, 0, &_inner_error0_);
		_tmp20_ = _tmp21_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (_tmp17_);
			_g_regex_unref0 (_tmp14_);
			_g_regex_unref0 (_tmp11_);
			_g_regex_unref0 (_tmp8_);
			_g_regex_unref0 (_tmp5_);
			_g_regex_unref0 (_tmp2_);
			goto __catch0_g_error;
		}
		_tmp22_ = self->priv->regex_list;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp22_, "log-modified", _tmp20_);
		_tmp24_ = g_regex_new ("([.h])([.fdLDS])[ ]{9} (.*)", 0, 0, &_inner_error0_);
		_tmp23_ = _tmp24_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (_tmp20_);
			_g_regex_unref0 (_tmp17_);
			_g_regex_unref0 (_tmp14_);
			_g_regex_unref0 (_tmp11_);
			_g_regex_unref0 (_tmp8_);
			_g_regex_unref0 (_tmp5_);
			_g_regex_unref0 (_tmp2_);
			goto __catch0_g_error;
		}
		_tmp25_ = self->priv->regex_list;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp25_, "unchanged", _tmp23_);
		_tmp27_ = g_regex_new ("[0-9\\/]+ [0-9:.]+ \\[[0-9]+\\] ([.h])([.fdLDS])[ ]{9} (.*)", 0, 0, &_inner_error0_);
		_tmp26_ = _tmp27_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (_tmp23_);
			_g_regex_unref0 (_tmp20_);
			_g_regex_unref0 (_tmp17_);
			_g_regex_unref0 (_tmp14_);
			_g_regex_unref0 (_tmp11_);
			_g_regex_unref0 (_tmp8_);
			_g_regex_unref0 (_tmp5_);
			_g_regex_unref0 (_tmp2_);
			goto __catch0_g_error;
		}
		_tmp28_ = self->priv->regex_list;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp28_, "log-unchanged", _tmp26_);
		_tmp30_ = g_regex_new ("total size is ([0-9,]+)[ \\t]+speedup is [0-9.]+", 0, 0, &_inner_error0_);
		_tmp29_ = _tmp30_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (_tmp26_);
			_g_regex_unref0 (_tmp23_);
			_g_regex_unref0 (_tmp20_);
			_g_regex_unref0 (_tmp17_);
			_g_regex_unref0 (_tmp14_);
			_g_regex_unref0 (_tmp11_);
			_g_regex_unref0 (_tmp8_);
			_g_regex_unref0 (_tmp5_);
			_g_regex_unref0 (_tmp2_);
			goto __catch0_g_error;
		}
		_tmp31_ = self->priv->regex_list;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp31_, "total-size", _tmp29_);
		_g_regex_unref0 (_tmp29_);
		_g_regex_unref0 (_tmp26_);
		_g_regex_unref0 (_tmp23_);
		_g_regex_unref0 (_tmp20_);
		_g_regex_unref0 (_tmp17_);
		_g_regex_unref0 (_tmp14_);
		_g_regex_unref0 (_tmp11_);
		_g_regex_unref0 (_tmp8_);
		_g_regex_unref0 (_tmp5_);
		_g_regex_unref0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp32_;
		const gchar* _tmp33_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp32_ = e;
		_tmp33_ = _tmp32_->message;
		tee_jee_logging_log_error (_tmp33_, FALSE, FALSE);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
rsync_task_prepare (RsyncTask* self)
{
	gchar* script_text = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GString* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = rsync_task_build_script (self);
	script_text = _tmp0_;
	tee_jee_logging_log_debug (script_text);
	_tmp1_ = ((AsyncTask*) self)->script_file;
	_tmp2_ = tee_jee_process_helper_save_bash_script_temp (script_text, _tmp1_, TRUE, FALSE);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp3_);
	_tmp4_ = ((AsyncTask*) self)->script_file;
	_tmp5_ = g_strdup_printf ("RsyncTask:prepare(): saved: %s", _tmp4_);
	_tmp6_ = _tmp5_;
	tee_jee_logging_log_debug (_tmp6_);
	_g_free0 (_tmp6_);
	self->status_line_count = (gint64) 0;
	self->total_size = (gint64) 0;
	self->count_created = (gint64) 0;
	self->count_deleted = (gint64) 0;
	self->count_modified = (gint64) 0;
	self->count_checksum = (gint64) 0;
	self->count_size = (gint64) 0;
	self->count_timestamp = (gint64) 0;
	self->count_permissions = (gint64) 0;
	self->count_owner = (gint64) 0;
	self->count_group = (gint64) 0;
	self->count_unchanged = (gint64) 0;
	_tmp7_ = g_string_new ("");
	_g_string_free0 (self->log);
	self->log = _tmp7_;
	_g_free0 (script_text);
}

static gchar*
rsync_task_build_script (RsyncTask* self)
{
	gchar* cmd = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	const gchar* _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	const gchar* _tmp46_;
	gint _tmp47_;
	gint _tmp48_;
	const gchar* _tmp59_;
	gchar* _tmp60_;
	const gchar* _tmp61_;
	gchar* _tmp62_;
	const gchar* _tmp63_;
	const gchar* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	gchar* _tmp69_;
	const gchar* _tmp70_;
	const gchar* _tmp71_;
	gchar* _tmp72_;
	gchar* _tmp73_;
	gchar* _tmp74_;
	gchar* _tmp75_;
	gchar* _tmp76_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("export LC_ALL=C.UTF-8\n");
	cmd = _tmp0_;
	if (self->io_nice) {
	}
	_tmp1_ = cmd;
	_tmp2_ = g_strconcat (_tmp1_, "rsync -aii", NULL);
	_g_free0 (cmd);
	cmd = _tmp2_;
	_tmp3_ = cmd;
	_tmp4_ = g_strconcat (_tmp3_, " --recursive", NULL);
	_g_free0 (cmd);
	cmd = _tmp4_;
	if (self->verbose) {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = cmd;
		_tmp6_ = g_strconcat (_tmp5_, " --verbose", NULL);
		_g_free0 (cmd);
		cmd = _tmp6_;
	} else {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = cmd;
		_tmp8_ = g_strconcat (_tmp7_, " --quiet", NULL);
		_g_free0 (cmd);
		cmd = _tmp8_;
	}
	if (self->delete_extra) {
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp9_ = cmd;
		_tmp10_ = g_strconcat (_tmp9_, " --delete", NULL);
		_g_free0 (cmd);
		cmd = _tmp10_;
	}
	if (self->delete_after) {
		const gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp11_ = cmd;
		_tmp12_ = g_strconcat (_tmp11_, " --delete-after", NULL);
		_g_free0 (cmd);
		cmd = _tmp12_;
	}
	_tmp13_ = cmd;
	_tmp14_ = g_strconcat (_tmp13_, " --force", NULL);
	_g_free0 (cmd);
	cmd = _tmp14_;
	_tmp15_ = cmd;
	_tmp16_ = g_strconcat (_tmp15_, " --stats", NULL);
	_g_free0 (cmd);
	cmd = _tmp16_;
	_tmp17_ = cmd;
	_tmp18_ = g_strconcat (_tmp17_, " --sparse", NULL);
	_g_free0 (cmd);
	cmd = _tmp18_;
	if (self->delete_excluded) {
		const gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp19_ = cmd;
		_tmp20_ = g_strconcat (_tmp19_, " --delete-excluded", NULL);
		_g_free0 (cmd);
		cmd = _tmp20_;
	}
	if (self->dry_run) {
		const gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp21_ = cmd;
		_tmp22_ = g_strconcat (_tmp21_, " --dry-run", NULL);
		_g_free0 (cmd);
		cmd = _tmp22_;
	}
	_tmp23_ = self->link_from_path;
	_tmp24_ = strlen (_tmp23_);
	_tmp25_ = _tmp24_;
	if (_tmp25_ > 0) {
		const gchar* _tmp26_;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		_tmp26_ = self->link_from_path;
		if (!g_str_has_suffix (_tmp26_, "/")) {
			const gchar* _tmp27_;
			gchar* _tmp28_;
			_tmp27_ = self->link_from_path;
			_tmp28_ = g_strdup_printf ("%s/", _tmp27_);
			_g_free0 (self->link_from_path);
			self->link_from_path = _tmp28_;
		}
		_tmp29_ = cmd;
		_tmp30_ = self->link_from_path;
		_tmp31_ = tee_jee_file_system_escape_single_quote (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = g_strdup_printf (" --link-dest='%s'", _tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = g_strconcat (_tmp29_, _tmp34_, NULL);
		_g_free0 (cmd);
		cmd = _tmp35_;
		_g_free0 (_tmp34_);
		_g_free0 (_tmp32_);
	}
	_tmp36_ = self->rsync_log_file;
	_tmp37_ = strlen (_tmp36_);
	_tmp38_ = _tmp37_;
	if (_tmp38_ > 0) {
		const gchar* _tmp39_;
		const gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		_tmp39_ = cmd;
		_tmp40_ = self->rsync_log_file;
		_tmp41_ = tee_jee_file_system_escape_single_quote (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = g_strdup_printf (" --log-file='%s'", _tmp42_);
		_tmp44_ = _tmp43_;
		_tmp45_ = g_strconcat (_tmp39_, _tmp44_, NULL);
		_g_free0 (cmd);
		cmd = _tmp45_;
		_g_free0 (_tmp44_);
		_g_free0 (_tmp42_);
	}
	_tmp46_ = self->exclude_from_file;
	_tmp47_ = strlen (_tmp46_);
	_tmp48_ = _tmp47_;
	if (_tmp48_ > 0) {
		const gchar* _tmp49_;
		const gchar* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		gboolean _tmp56_ = FALSE;
		_tmp49_ = cmd;
		_tmp50_ = self->exclude_from_file;
		_tmp51_ = tee_jee_file_system_escape_single_quote (_tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = g_strdup_printf (" --exclude-from='%s'", _tmp52_);
		_tmp54_ = _tmp53_;
		_tmp55_ = g_strconcat (_tmp49_, _tmp54_, NULL);
		_g_free0 (cmd);
		cmd = _tmp55_;
		_g_free0 (_tmp54_);
		_g_free0 (_tmp52_);
		if (self->delete_extra) {
			_tmp56_ = self->delete_excluded;
		} else {
			_tmp56_ = FALSE;
		}
		if (_tmp56_) {
			const gchar* _tmp57_;
			gchar* _tmp58_;
			_tmp57_ = cmd;
			_tmp58_ = g_strconcat (_tmp57_, " --delete-excluded", NULL);
			_g_free0 (cmd);
			cmd = _tmp58_;
		}
	}
	_tmp59_ = self->source_path;
	_tmp60_ = tee_jee_file_system_remove_trailing_slash (_tmp59_);
	_g_free0 (self->source_path);
	self->source_path = _tmp60_;
	_tmp61_ = self->dest_path;
	_tmp62_ = tee_jee_file_system_remove_trailing_slash (_tmp61_);
	_g_free0 (self->dest_path);
	self->dest_path = _tmp62_;
	_tmp63_ = cmd;
	_tmp64_ = self->source_path;
	_tmp65_ = tee_jee_file_system_escape_single_quote (_tmp64_);
	_tmp66_ = _tmp65_;
	_tmp67_ = g_strdup_printf (" '%s/'", _tmp66_);
	_tmp68_ = _tmp67_;
	_tmp69_ = g_strconcat (_tmp63_, _tmp68_, NULL);
	_g_free0 (cmd);
	cmd = _tmp69_;
	_g_free0 (_tmp68_);
	_g_free0 (_tmp66_);
	_tmp70_ = cmd;
	_tmp71_ = self->dest_path;
	_tmp72_ = tee_jee_file_system_escape_single_quote (_tmp71_);
	_tmp73_ = _tmp72_;
	_tmp74_ = g_strdup_printf (" '%s/'", _tmp73_);
	_tmp75_ = _tmp74_;
	_tmp76_ = g_strconcat (_tmp70_, _tmp75_, NULL);
	_g_free0 (cmd);
	cmd = _tmp76_;
	_g_free0 (_tmp75_);
	_g_free0 (_tmp73_);
	result = cmd;
	return result;
}

static gint64*
_int64_dup (gint64* self)
{
	gint64* dup;
	dup = g_new0 (gint64, 1);
	memcpy (dup, self, sizeof (gint64));
	return dup;
}

static gpointer
__int64_dup0 (gpointer self)
{
	return self ? _int64_dup (self) : NULL;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

GeeArrayList*
rsync_task_parse_log (RsyncTask* self,
                      const gchar* log_file_path)
{
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	gchar* log_file = NULL;
	gchar* _tmp1_;
	GDataOutputStream* dos_changes = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gint64* _tmp20_ = NULL;
	const gchar* _tmp21_;
	gint64* _tmp22_;
	gint64* _tmp25_;
	gint64* _tmp26_;
	GDataOutputStream* _tmp201_;
	GError* _inner_error0_ = NULL;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (log_file_path != NULL, NULL);
	_tmp0_ = gee_array_list_new (TYPE_FILE_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	list = _tmp0_;
	_tmp1_ = g_strdup (log_file_path);
	log_file = _tmp1_;
	dos_changes = NULL;
	_tmp2_ = log_file;
	if (!g_str_has_suffix (_tmp2_, "-changes")) {
		gchar* log_file_changes = NULL;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = g_strconcat (log_file_path, "-changes", NULL);
		log_file_changes = _tmp3_;
		_tmp4_ = log_file_changes;
		if (tee_jee_file_system_file_exists (_tmp4_)) {
			const gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp5_ = log_file_changes;
			_tmp6_ = g_strdup (_tmp5_);
			_g_free0 (log_file);
			log_file = _tmp6_;
		} else {
			{
				GFile* file = NULL;
				const gchar* _tmp7_;
				GFile* _tmp8_;
				GFile* _tmp9_;
				GFileOutputStream* file_stream = NULL;
				GFile* _tmp11_;
				GFileOutputStream* _tmp12_;
				GFileOutputStream* _tmp13_;
				GDataOutputStream* _tmp14_;
				_tmp7_ = log_file_changes;
				_tmp8_ = g_file_new_for_path (_tmp7_);
				file = _tmp8_;
				_tmp9_ = file;
				if (g_file_query_exists (_tmp9_, NULL)) {
					GFile* _tmp10_;
					_tmp10_ = file;
					g_file_delete (_tmp10_, NULL, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (file);
						goto __catch0_g_error;
					}
				}
				_tmp11_ = file;
				_tmp12_ = g_file_create (_tmp11_, G_FILE_CREATE_REPLACE_DESTINATION, NULL, &_inner_error0_);
				file_stream = _tmp12_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (file);
					goto __catch0_g_error;
				}
				_tmp13_ = file_stream;
				_tmp14_ = g_data_output_stream_new ((GOutputStream*) _tmp13_);
				_g_object_unref0 (dos_changes);
				dos_changes = _tmp14_;
				_g_object_unref0 (file_stream);
				_g_object_unref0 (file);
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp15_;
				const gchar* _tmp16_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp15_ = e;
				_tmp16_ = _tmp15_->message;
				tee_jee_logging_log_error (_tmp16_, FALSE, FALSE);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (log_file_changes);
				_g_object_unref0 (dos_changes);
				_g_free0 (log_file);
				_g_object_unref0 (list);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_g_free0 (log_file_changes);
	}
	tee_jee_logging_log_debug ("RsyncTask: parse_log()");
	_tmp17_ = log_file;
	_tmp18_ = g_strdup_printf ("log_file = %s", _tmp17_);
	_tmp19_ = _tmp18_;
	tee_jee_logging_log_debug (_tmp19_);
	_g_free0 (_tmp19_);
	((AsyncTask*) self)->prg_count = (gint64) 0;
	_tmp21_ = log_file;
	_tmp22_ = tee_jee_file_system_file_line_count (_tmp21_);
	_tmp20_ = _tmp22_;
	if (_tmp20_ == NULL) {
		gint64 _tmp23_;
		gint64* _tmp24_;
		_tmp23_ = (gint64) 0;
		_tmp24_ = __int64_dup0 (&_tmp23_);
		_g_free0 (_tmp20_);
		_tmp20_ = _tmp24_;
	}
	_tmp25_ = _tmp20_;
	_tmp20_ = NULL;
	_tmp26_ = _tmp25_;
	((AsyncTask*) self)->prg_count_total = *_tmp26_;
	_g_free0 (_tmp26_);
	{
		gchar* line = NULL;
		GFile* file = NULL;
		const gchar* _tmp27_;
		GFile* _tmp28_;
		GFile* _tmp29_;
		GFileInputStream* _tmp35_ = NULL;
		GFile* _tmp36_;
		GFileInputStream* _tmp37_;
		GDataInputStream* dis = NULL;
		GDataInputStream* _tmp38_;
		gchar* item_path = NULL;
		gchar* _tmp39_;
		gchar* item_disk_path = NULL;
		gchar* _tmp40_;
		gchar* item_status = NULL;
		gchar* _tmp41_;
		gchar* item_basepath = NULL;
		gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		_tmp27_ = log_file;
		_tmp28_ = g_file_new_for_path (_tmp27_);
		file = _tmp28_;
		_tmp29_ = file;
		if (!g_file_query_exists (_tmp29_, NULL)) {
			const gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			_tmp30_ = log_file;
			_tmp31_ = g_strdup_printf (": %s", _tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = g_strconcat (_ ("File not found"), _tmp32_, NULL);
			_tmp34_ = _tmp33_;
			tee_jee_logging_log_error (_tmp34_, FALSE, FALSE);
			_g_free0 (_tmp34_);
			_g_free0 (_tmp32_);
			result = list;
			_g_object_unref0 (file);
			_g_free0 (line);
			_g_free0 (_tmp20_);
			_g_object_unref0 (dos_changes);
			_g_free0 (log_file);
			return result;
		}
		_tmp36_ = file;
		_tmp37_ = g_file_read (_tmp36_, NULL, &_inner_error0_);
		_tmp35_ = _tmp37_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			_g_free0 (line);
			goto __catch1_g_error;
		}
		_tmp38_ = g_data_input_stream_new ((GInputStream*) _tmp35_);
		dis = _tmp38_;
		_tmp39_ = g_strdup ("");
		item_path = _tmp39_;
		_tmp40_ = g_strdup ("");
		item_disk_path = _tmp40_;
		_tmp41_ = g_strdup ("");
		item_status = _tmp41_;
		_tmp42_ = tee_jee_file_system_file_parent (log_file_path);
		_tmp43_ = _tmp42_;
		_tmp44_ = tee_jee_file_system_path_combine (_tmp43_, "localhost");
		_tmp45_ = _tmp44_;
		_g_free0 (_tmp43_);
		item_basepath = _tmp45_;
		while (TRUE) {
			gchar* _tmp46_ = NULL;
			GDataInputStream* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			const gchar* _tmp50_;
			gint64 _tmp51_;
			const gchar* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			gint _tmp55_;
			gint _tmp56_;
			gboolean _tmp57_;
			gchar* _tmp58_;
			GMatchInfo* match = NULL;
			gboolean _tmp59_ = FALSE;
			GeeHashMap* _tmp60_;
			gpointer _tmp61_;
			GRegex* _tmp62_;
			const gchar* _tmp63_;
			GMatchInfo* _tmp64_ = NULL;
			gboolean _tmp65_;
			gboolean _tmp66_;
			gboolean _tmp182_ = FALSE;
			gboolean _tmp183_ = FALSE;
			const gchar* _tmp184_;
			gint _tmp185_;
			gint _tmp186_;
			_tmp47_ = dis;
			_tmp48_ = g_data_input_stream_read_line (_tmp47_, NULL, NULL, &_inner_error0_);
			_tmp46_ = _tmp48_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (item_basepath);
				_g_free0 (item_status);
				_g_free0 (item_disk_path);
				_g_free0 (item_path);
				_g_object_unref0 (dis);
				_g_object_unref0 (_tmp35_);
				_g_object_unref0 (file);
				_g_free0 (line);
				goto __catch1_g_error;
			}
			_tmp49_ = _tmp46_;
			_tmp46_ = NULL;
			_g_free0 (line);
			line = _tmp49_;
			_tmp50_ = line;
			if (!(_tmp50_ != NULL)) {
				_g_free0 (_tmp46_);
				break;
			}
			_tmp51_ = ((AsyncTask*) self)->prg_count;
			((AsyncTask*) self)->prg_count = _tmp51_ + 1;
			_tmp52_ = line;
			_tmp53_ = string_strip (_tmp52_);
			_tmp54_ = _tmp53_;
			_tmp55_ = strlen (_tmp54_);
			_tmp56_ = _tmp55_;
			_tmp57_ = _tmp56_ == 0;
			_g_free0 (_tmp54_);
			if (_tmp57_) {
				_g_free0 (_tmp46_);
				continue;
			}
			_tmp58_ = g_strdup ("");
			_g_free0 (item_path);
			item_path = _tmp58_;
			_tmp60_ = self->priv->regex_list;
			_tmp61_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp60_, "created");
			_tmp62_ = (GRegex*) _tmp61_;
			_tmp63_ = line;
			_tmp65_ = g_regex_match (_tmp62_, _tmp63_, 0, &_tmp64_);
			_g_match_info_unref0 (match);
			match = _tmp64_;
			_tmp66_ = _tmp65_;
			_g_regex_unref0 (_tmp62_);
			if (_tmp66_) {
				_tmp59_ = TRUE;
			} else {
				GeeHashMap* _tmp67_;
				gpointer _tmp68_;
				GRegex* _tmp69_;
				const gchar* _tmp70_;
				GMatchInfo* _tmp71_ = NULL;
				gboolean _tmp72_;
				_tmp67_ = self->priv->regex_list;
				_tmp68_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp67_, "log-created");
				_tmp69_ = (GRegex*) _tmp68_;
				_tmp70_ = line;
				_tmp72_ = g_regex_match (_tmp69_, _tmp70_, 0, &_tmp71_);
				_g_match_info_unref0 (match);
				match = _tmp71_;
				_tmp59_ = _tmp72_;
				_g_regex_unref0 (_tmp69_);
			}
			if (_tmp59_) {
				GDataOutputStream* _tmp73_;
				GMatchInfo* _tmp78_;
				gchar* _tmp79_;
				gchar* _tmp80_;
				gchar** _tmp81_;
				gchar** _tmp82_;
				gchar** _tmp83_;
				gint _tmp83__length1;
				const gchar* _tmp84_;
				gchar* _tmp85_;
				gchar* _tmp86_;
				_tmp73_ = dos_changes;
				if (_tmp73_ != NULL) {
					GDataOutputStream* _tmp74_;
					const gchar* _tmp75_;
					gchar* _tmp76_;
					gchar* _tmp77_;
					_tmp74_ = dos_changes;
					_tmp75_ = line;
					_tmp76_ = g_strdup_printf ("%s\n", _tmp75_);
					_tmp77_ = _tmp76_;
					g_data_output_stream_put_string (_tmp74_, _tmp77_, NULL, &_inner_error0_);
					_g_free0 (_tmp77_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_match_info_unref0 (match);
						_g_free0 (_tmp46_);
						_g_free0 (item_basepath);
						_g_free0 (item_status);
						_g_free0 (item_disk_path);
						_g_free0 (item_path);
						_g_object_unref0 (dis);
						_g_object_unref0 (_tmp35_);
						_g_object_unref0 (file);
						_g_free0 (line);
						goto __catch1_g_error;
					}
				}
				_tmp78_ = match;
				_tmp79_ = g_match_info_fetch (_tmp78_, 3);
				_tmp80_ = _tmp79_;
				_tmp82_ = _tmp81_ = g_strsplit (_tmp80_, " -> ", 0);
				_tmp83_ = _tmp82_;
				_tmp83__length1 = _vala_array_length (_tmp81_);
				_tmp84_ = _tmp83_[0];
				_tmp85_ = string_strip (_tmp84_);
				_g_free0 (item_path);
				item_path = _tmp85_;
				_tmp83_ = (_vala_array_free (_tmp83_, _tmp83__length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (_tmp80_);
				_tmp86_ = g_strdup ("created");
				_g_free0 (item_status);
				item_status = _tmp86_;
			} else {
				gboolean _tmp87_ = FALSE;
				GeeHashMap* _tmp88_;
				gpointer _tmp89_;
				GRegex* _tmp90_;
				const gchar* _tmp91_;
				GMatchInfo* _tmp92_ = NULL;
				gboolean _tmp93_;
				gboolean _tmp94_;
				_tmp88_ = self->priv->regex_list;
				_tmp89_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp88_, "log-deleted");
				_tmp90_ = (GRegex*) _tmp89_;
				_tmp91_ = line;
				_tmp93_ = g_regex_match (_tmp90_, _tmp91_, 0, &_tmp92_);
				_g_match_info_unref0 (match);
				match = _tmp92_;
				_tmp94_ = _tmp93_;
				_g_regex_unref0 (_tmp90_);
				if (_tmp94_) {
					_tmp87_ = TRUE;
				} else {
					GeeHashMap* _tmp95_;
					gpointer _tmp96_;
					GRegex* _tmp97_;
					const gchar* _tmp98_;
					GMatchInfo* _tmp99_ = NULL;
					gboolean _tmp100_;
					_tmp95_ = self->priv->regex_list;
					_tmp96_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp95_, "deleted");
					_tmp97_ = (GRegex*) _tmp96_;
					_tmp98_ = line;
					_tmp100_ = g_regex_match (_tmp97_, _tmp98_, 0, &_tmp99_);
					_g_match_info_unref0 (match);
					match = _tmp99_;
					_tmp87_ = _tmp100_;
					_g_regex_unref0 (_tmp97_);
				}
				if (_tmp87_) {
					GDataOutputStream* _tmp101_;
					GMatchInfo* _tmp106_;
					gchar* _tmp107_;
					gchar* _tmp108_;
					gchar** _tmp109_;
					gchar** _tmp110_;
					gchar** _tmp111_;
					gint _tmp111__length1;
					const gchar* _tmp112_;
					gchar* _tmp113_;
					gchar* _tmp114_;
					_tmp101_ = dos_changes;
					if (_tmp101_ != NULL) {
						GDataOutputStream* _tmp102_;
						const gchar* _tmp103_;
						gchar* _tmp104_;
						gchar* _tmp105_;
						_tmp102_ = dos_changes;
						_tmp103_ = line;
						_tmp104_ = g_strdup_printf ("%s\n", _tmp103_);
						_tmp105_ = _tmp104_;
						g_data_output_stream_put_string (_tmp102_, _tmp105_, NULL, &_inner_error0_);
						_g_free0 (_tmp105_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_match_info_unref0 (match);
							_g_free0 (_tmp46_);
							_g_free0 (item_basepath);
							_g_free0 (item_status);
							_g_free0 (item_disk_path);
							_g_free0 (item_path);
							_g_object_unref0 (dis);
							_g_object_unref0 (_tmp35_);
							_g_object_unref0 (file);
							_g_free0 (line);
							goto __catch1_g_error;
						}
					}
					_tmp106_ = match;
					_tmp107_ = g_match_info_fetch (_tmp106_, 1);
					_tmp108_ = _tmp107_;
					_tmp110_ = _tmp109_ = g_strsplit (_tmp108_, " -> ", 0);
					_tmp111_ = _tmp110_;
					_tmp111__length1 = _vala_array_length (_tmp109_);
					_tmp112_ = _tmp111_[0];
					_tmp113_ = string_strip (_tmp112_);
					_g_free0 (item_path);
					item_path = _tmp113_;
					_tmp111_ = (_vala_array_free (_tmp111_, _tmp111__length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (_tmp108_);
					_tmp114_ = g_strdup ("deleted");
					_g_free0 (item_status);
					item_status = _tmp114_;
				} else {
					gboolean _tmp115_ = FALSE;
					GeeHashMap* _tmp116_;
					gpointer _tmp117_;
					GRegex* _tmp118_;
					const gchar* _tmp119_;
					GMatchInfo* _tmp120_ = NULL;
					gboolean _tmp121_;
					gboolean _tmp122_;
					_tmp116_ = self->priv->regex_list;
					_tmp117_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp116_, "modified");
					_tmp118_ = (GRegex*) _tmp117_;
					_tmp119_ = line;
					_tmp121_ = g_regex_match (_tmp118_, _tmp119_, 0, &_tmp120_);
					_g_match_info_unref0 (match);
					match = _tmp120_;
					_tmp122_ = _tmp121_;
					_g_regex_unref0 (_tmp118_);
					if (_tmp122_) {
						_tmp115_ = TRUE;
					} else {
						GeeHashMap* _tmp123_;
						gpointer _tmp124_;
						GRegex* _tmp125_;
						const gchar* _tmp126_;
						GMatchInfo* _tmp127_ = NULL;
						gboolean _tmp128_;
						_tmp123_ = self->priv->regex_list;
						_tmp124_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp123_, "log-modified");
						_tmp125_ = (GRegex*) _tmp124_;
						_tmp126_ = line;
						_tmp128_ = g_regex_match (_tmp125_, _tmp126_, 0, &_tmp127_);
						_g_match_info_unref0 (match);
						match = _tmp127_;
						_tmp115_ = _tmp128_;
						_g_regex_unref0 (_tmp125_);
					}
					if (_tmp115_) {
						GDataOutputStream* _tmp129_;
						GMatchInfo* _tmp134_;
						gchar* _tmp135_;
						gchar* _tmp136_;
						gchar** _tmp137_;
						gchar** _tmp138_;
						gchar** _tmp139_;
						gint _tmp139__length1;
						const gchar* _tmp140_;
						gchar* _tmp141_;
						GMatchInfo* _tmp142_;
						gchar* _tmp143_;
						gchar* _tmp144_;
						gboolean _tmp145_;
						_tmp129_ = dos_changes;
						if (_tmp129_ != NULL) {
							GDataOutputStream* _tmp130_;
							const gchar* _tmp131_;
							gchar* _tmp132_;
							gchar* _tmp133_;
							_tmp130_ = dos_changes;
							_tmp131_ = line;
							_tmp132_ = g_strdup_printf ("%s\n", _tmp131_);
							_tmp133_ = _tmp132_;
							g_data_output_stream_put_string (_tmp130_, _tmp133_, NULL, &_inner_error0_);
							_g_free0 (_tmp133_);
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								_g_match_info_unref0 (match);
								_g_free0 (_tmp46_);
								_g_free0 (item_basepath);
								_g_free0 (item_status);
								_g_free0 (item_disk_path);
								_g_free0 (item_path);
								_g_object_unref0 (dis);
								_g_object_unref0 (_tmp35_);
								_g_object_unref0 (file);
								_g_free0 (line);
								goto __catch1_g_error;
							}
						}
						_tmp134_ = match;
						_tmp135_ = g_match_info_fetch (_tmp134_, 12);
						_tmp136_ = _tmp135_;
						_tmp138_ = _tmp137_ = g_strsplit (_tmp136_, " -> ", 0);
						_tmp139_ = _tmp138_;
						_tmp139__length1 = _vala_array_length (_tmp137_);
						_tmp140_ = _tmp139_[0];
						_tmp141_ = string_strip (_tmp140_);
						_g_free0 (item_path);
						item_path = _tmp141_;
						_tmp139_ = (_vala_array_free (_tmp139_, _tmp139__length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (_tmp136_);
						_tmp142_ = match;
						_tmp143_ = g_match_info_fetch (_tmp142_, 3);
						_tmp144_ = _tmp143_;
						_tmp145_ = g_strcmp0 (_tmp144_, "c") == 0;
						_g_free0 (_tmp144_);
						if (_tmp145_) {
							gchar* _tmp146_;
							_tmp146_ = g_strdup ("checksum");
							_g_free0 (item_status);
							item_status = _tmp146_;
						} else {
							GMatchInfo* _tmp147_;
							gchar* _tmp148_;
							gchar* _tmp149_;
							gboolean _tmp150_;
							_tmp147_ = match;
							_tmp148_ = g_match_info_fetch (_tmp147_, 4);
							_tmp149_ = _tmp148_;
							_tmp150_ = g_strcmp0 (_tmp149_, "s") == 0;
							_g_free0 (_tmp149_);
							if (_tmp150_) {
								gchar* _tmp151_;
								_tmp151_ = g_strdup ("size");
								_g_free0 (item_status);
								item_status = _tmp151_;
							} else {
								GMatchInfo* _tmp152_;
								gchar* _tmp153_;
								gchar* _tmp154_;
								gboolean _tmp155_;
								_tmp152_ = match;
								_tmp153_ = g_match_info_fetch (_tmp152_, 5);
								_tmp154_ = _tmp153_;
								_tmp155_ = g_strcmp0 (_tmp154_, "t") == 0;
								_g_free0 (_tmp154_);
								if (_tmp155_) {
									gchar* _tmp156_;
									_tmp156_ = g_strdup ("timestamp");
									_g_free0 (item_status);
									item_status = _tmp156_;
								} else {
									GMatchInfo* _tmp157_;
									gchar* _tmp158_;
									gchar* _tmp159_;
									gboolean _tmp160_;
									_tmp157_ = match;
									_tmp158_ = g_match_info_fetch (_tmp157_, 6);
									_tmp159_ = _tmp158_;
									_tmp160_ = g_strcmp0 (_tmp159_, "p") == 0;
									_g_free0 (_tmp159_);
									if (_tmp160_) {
										gchar* _tmp161_;
										_tmp161_ = g_strdup ("permissions");
										_g_free0 (item_status);
										item_status = _tmp161_;
									} else {
										GMatchInfo* _tmp162_;
										gchar* _tmp163_;
										gchar* _tmp164_;
										gboolean _tmp165_;
										_tmp162_ = match;
										_tmp163_ = g_match_info_fetch (_tmp162_, 7);
										_tmp164_ = _tmp163_;
										_tmp165_ = g_strcmp0 (_tmp164_, "o") == 0;
										_g_free0 (_tmp164_);
										if (_tmp165_) {
											gchar* _tmp166_;
											_tmp166_ = g_strdup ("owner");
											_g_free0 (item_status);
											item_status = _tmp166_;
										} else {
											GMatchInfo* _tmp167_;
											gchar* _tmp168_;
											gchar* _tmp169_;
											gboolean _tmp170_;
											_tmp167_ = match;
											_tmp168_ = g_match_info_fetch (_tmp167_, 8);
											_tmp169_ = _tmp168_;
											_tmp170_ = g_strcmp0 (_tmp169_, "g") == 0;
											_g_free0 (_tmp169_);
											if (_tmp170_) {
												gchar* _tmp171_;
												_tmp171_ = g_strdup ("group");
												_g_free0 (item_status);
												item_status = _tmp171_;
											}
										}
									}
								}
							}
						}
					} else {
						GeeHashMap* _tmp172_;
						gpointer _tmp173_;
						GRegex* _tmp174_;
						const gchar* _tmp175_;
						GMatchInfo* _tmp176_ = NULL;
						gboolean _tmp177_;
						gboolean _tmp178_;
						_tmp172_ = self->priv->regex_list;
						_tmp173_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp172_, "log-unchanged");
						_tmp174_ = (GRegex*) _tmp173_;
						_tmp175_ = line;
						_tmp177_ = g_regex_match (_tmp174_, _tmp175_, 0, &_tmp176_);
						_g_match_info_unref0 (match);
						match = _tmp176_;
						_tmp178_ = _tmp177_;
						_g_regex_unref0 (_tmp174_);
						if (_tmp178_) {
						} else {
							const gchar* _tmp179_;
							gchar* _tmp180_;
							gchar* _tmp181_;
							_tmp179_ = line;
							_tmp180_ = g_strdup_printf ("not-matched: %s", _tmp179_);
							_tmp181_ = _tmp180_;
							tee_jee_logging_log_debug (_tmp181_);
							_g_free0 (_tmp181_);
						}
					}
				}
			}
			_tmp184_ = item_path;
			_tmp185_ = strlen (_tmp184_);
			_tmp186_ = _tmp185_;
			if (_tmp186_ > 0) {
				const gchar* _tmp187_;
				_tmp187_ = item_path;
				_tmp183_ = g_strcmp0 (_tmp187_, "/./") != 0;
			} else {
				_tmp183_ = FALSE;
			}
			if (_tmp183_) {
				const gchar* _tmp188_;
				_tmp188_ = item_path;
				_tmp182_ = g_strcmp0 (_tmp188_, "./") != 0;
			} else {
				_tmp182_ = FALSE;
			}
			if (_tmp182_) {
				const gchar* _tmp189_;
				const gchar* _tmp190_;
				gchar* _tmp191_;
				FileItem* item = NULL;
				const gchar* _tmp192_;
				FileItem* _tmp193_;
				FileItem* _tmp194_;
				const gchar* _tmp195_;
				gchar* _tmp196_;
				GeeArrayList* _tmp197_;
				FileItem* _tmp198_;
				_tmp189_ = item_basepath;
				_tmp190_ = item_path;
				_tmp191_ = tee_jee_file_system_path_combine (_tmp189_, _tmp190_);
				_g_free0 (item_disk_path);
				item_disk_path = _tmp191_;
				_tmp192_ = item_disk_path;
				_tmp193_ = file_item_new_from_disk_path_with_basic_info (_tmp192_);
				item = _tmp193_;
				_tmp194_ = item;
				_tmp195_ = item_status;
				_tmp196_ = g_strdup (_tmp195_);
				_g_free0 (_tmp194_->file_status);
				_tmp194_->file_status = _tmp196_;
				_tmp197_ = list;
				_tmp198_ = item;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp197_, _tmp198_);
				_g_object_unref0 (item);
			}
			_g_match_info_unref0 (match);
			_g_free0 (_tmp46_);
		}
		_g_free0 (item_basepath);
		_g_free0 (item_status);
		_g_free0 (item_disk_path);
		_g_free0 (item_path);
		_g_object_unref0 (dis);
		_g_object_unref0 (_tmp35_);
		_g_object_unref0 (file);
		_g_free0 (line);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp199_;
		const gchar* _tmp200_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp199_ = e;
		_tmp200_ = _tmp199_->message;
		tee_jee_logging_log_error (_tmp200_, FALSE, FALSE);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (_tmp20_);
		_g_object_unref0 (dos_changes);
		_g_free0 (log_file);
		_g_object_unref0 (list);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp201_ = dos_changes;
	if (_tmp201_ != NULL) {
		gchar* _tmp202_;
		gchar* _tmp203_;
		_tmp202_ = g_strdup_printf ("Archiving: %s", log_file_path);
		_tmp203_ = _tmp202_;
		tee_jee_logging_log_msg (_tmp203_, FALSE);
		_g_free0 (_tmp203_);
		tee_jee_file_system_file_gzip (log_file_path);
	}
	tee_jee_logging_log_debug ("RsyncTask: parse_log(): exit");
	result = list;
	_g_free0 (_tmp20_);
	_g_object_unref0 (dos_changes);
	_g_free0 (log_file);
	return result;
}

void
rsync_task_execute (RsyncTask* self)
{
	g_return_if_fail (self != NULL);
	tee_jee_logging_log_debug ("RsyncTask:execute()");
	rsync_task_prepare (self);
	async_task_begin ((AsyncTask*) self);
}

static void
rsync_task_real_parse_stdout_line (AsyncTask* base,
                                   const gchar* out_line)
{
	RsyncTask * self;
	self = (RsyncTask*) base;
	g_return_if_fail (out_line != NULL);
	if (((AsyncTask*) self)->is_terminated) {
		return;
	}
	rsync_task_update_progress_parse_console_output (self, out_line);
}

static void
rsync_task_real_parse_stderr_line (AsyncTask* base,
                                   const gchar* err_line)
{
	RsyncTask * self;
	self = (RsyncTask*) base;
	g_return_if_fail (err_line != NULL);
	if (((AsyncTask*) self)->is_terminated) {
		return;
	}
	rsync_task_update_progress_parse_console_output (self, err_line);
}

static gint64
int64_parse (const gchar* str,
             guint _base)
{
	gint64 result;
	g_return_val_if_fail (str != NULL, 0LL);
	result = g_ascii_strtoll (str, NULL, _base);
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gboolean
rsync_task_update_progress_parse_console_output (RsyncTask* self,
                                                 const gchar* line)
{
	gboolean _tmp0_ = FALSE;
	gint64 _tmp3_;
	GMatchInfo* match = NULL;
	GeeHashMap* _tmp4_;
	gpointer _tmp5_;
	GRegex* _tmp6_;
	GMatchInfo* _tmp7_ = NULL;
	gboolean _tmp8_;
	gboolean _tmp9_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	if (line == NULL) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (line);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == 0;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp3_ = self->status_line_count;
	self->status_line_count = _tmp3_ + 1;
	if (((AsyncTask*) self)->prg_count_total > ((gint64) 0)) {
		((AsyncTask*) self)->prg_count = self->status_line_count;
		((AsyncTask*) self)->progress = (((AsyncTask*) self)->prg_count * 1.0) / ((AsyncTask*) self)->prg_count_total;
	}
	_tmp4_ = self->priv->regex_list;
	_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, "created");
	_tmp6_ = (GRegex*) _tmp5_;
	_tmp8_ = g_regex_match (_tmp6_, line, 0, &_tmp7_);
	_g_match_info_unref0 (match);
	match = _tmp7_;
	_tmp9_ = _tmp8_;
	_g_regex_unref0 (_tmp6_);
	if (_tmp9_) {
		gint64 _tmp10_;
		GMatchInfo* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar** _tmp14_;
		gchar** _tmp15_;
		gchar** _tmp16_;
		gint _tmp16__length1;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		GString* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp10_ = self->count_created;
		self->count_created = _tmp10_ + 1;
		_tmp11_ = match;
		_tmp12_ = g_match_info_fetch (_tmp11_, 3);
		_tmp13_ = _tmp12_;
		_tmp15_ = _tmp14_ = g_strsplit (_tmp13_, " -> ", 0);
		_tmp16_ = _tmp15_;
		_tmp16__length1 = _vala_array_length (_tmp14_);
		_tmp17_ = _tmp16_[0];
		_tmp18_ = string_strip (_tmp17_);
		_tmp19_ = _tmp18_;
		async_task_set_status_line ((AsyncTask*) self, _tmp19_);
		_g_free0 (_tmp19_);
		_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_tmp13_);
		_tmp20_ = self->log;
		_tmp21_ = g_strconcat (line, "\n", NULL);
		_tmp22_ = _tmp21_;
		g_string_append (_tmp20_, _tmp22_);
		_g_free0 (_tmp22_);
	} else {
		GeeHashMap* _tmp23_;
		gpointer _tmp24_;
		GRegex* _tmp25_;
		GMatchInfo* _tmp26_ = NULL;
		gboolean _tmp27_;
		gboolean _tmp28_;
		_tmp23_ = self->priv->regex_list;
		_tmp24_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp23_, "deleted");
		_tmp25_ = (GRegex*) _tmp24_;
		_tmp27_ = g_regex_match (_tmp25_, line, 0, &_tmp26_);
		_g_match_info_unref0 (match);
		match = _tmp26_;
		_tmp28_ = _tmp27_;
		_g_regex_unref0 (_tmp25_);
		if (_tmp28_) {
			gint64 _tmp29_;
			GMatchInfo* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			gchar** _tmp33_;
			gchar** _tmp34_;
			gchar** _tmp35_;
			gint _tmp35__length1;
			const gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			GString* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			_tmp29_ = self->count_deleted;
			self->count_deleted = _tmp29_ + 1;
			_tmp30_ = match;
			_tmp31_ = g_match_info_fetch (_tmp30_, 1);
			_tmp32_ = _tmp31_;
			_tmp34_ = _tmp33_ = g_strsplit (_tmp32_, " -> ", 0);
			_tmp35_ = _tmp34_;
			_tmp35__length1 = _vala_array_length (_tmp33_);
			_tmp36_ = _tmp35_[0];
			_tmp37_ = string_strip (_tmp36_);
			_tmp38_ = _tmp37_;
			async_task_set_status_line ((AsyncTask*) self, _tmp38_);
			_g_free0 (_tmp38_);
			_tmp35_ = (_vala_array_free (_tmp35_, _tmp35__length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (_tmp32_);
			_tmp39_ = self->log;
			_tmp40_ = g_strconcat (line, "\n", NULL);
			_tmp41_ = _tmp40_;
			g_string_append (_tmp39_, _tmp41_);
			_g_free0 (_tmp41_);
		} else {
			GeeHashMap* _tmp42_;
			gpointer _tmp43_;
			GRegex* _tmp44_;
			GMatchInfo* _tmp45_ = NULL;
			gboolean _tmp46_;
			gboolean _tmp47_;
			_tmp42_ = self->priv->regex_list;
			_tmp43_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp42_, "unchanged");
			_tmp44_ = (GRegex*) _tmp43_;
			_tmp46_ = g_regex_match (_tmp44_, line, 0, &_tmp45_);
			_g_match_info_unref0 (match);
			match = _tmp45_;
			_tmp47_ = _tmp46_;
			_g_regex_unref0 (_tmp44_);
			if (_tmp47_) {
				gint64 _tmp48_;
				GMatchInfo* _tmp49_;
				gchar* _tmp50_;
				gchar* _tmp51_;
				gchar** _tmp52_;
				gchar** _tmp53_;
				gchar** _tmp54_;
				gint _tmp54__length1;
				const gchar* _tmp55_;
				gchar* _tmp56_;
				gchar* _tmp57_;
				_tmp48_ = self->count_unchanged;
				self->count_unchanged = _tmp48_ + 1;
				_tmp49_ = match;
				_tmp50_ = g_match_info_fetch (_tmp49_, 3);
				_tmp51_ = _tmp50_;
				_tmp53_ = _tmp52_ = g_strsplit (_tmp51_, " -> ", 0);
				_tmp54_ = _tmp53_;
				_tmp54__length1 = _vala_array_length (_tmp52_);
				_tmp55_ = _tmp54_[0];
				_tmp56_ = string_strip (_tmp55_);
				_tmp57_ = _tmp56_;
				async_task_set_status_line ((AsyncTask*) self, _tmp57_);
				_g_free0 (_tmp57_);
				_tmp54_ = (_vala_array_free (_tmp54_, _tmp54__length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (_tmp51_);
			} else {
				GeeHashMap* _tmp58_;
				gpointer _tmp59_;
				GRegex* _tmp60_;
				GMatchInfo* _tmp61_ = NULL;
				gboolean _tmp62_;
				gboolean _tmp63_;
				_tmp58_ = self->priv->regex_list;
				_tmp59_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp58_, "modified");
				_tmp60_ = (GRegex*) _tmp59_;
				_tmp62_ = g_regex_match (_tmp60_, line, 0, &_tmp61_);
				_g_match_info_unref0 (match);
				match = _tmp61_;
				_tmp63_ = _tmp62_;
				_g_regex_unref0 (_tmp60_);
				if (_tmp63_) {
					gint64 _tmp64_;
					GMatchInfo* _tmp65_;
					gchar* _tmp66_;
					gchar* _tmp67_;
					gchar** _tmp68_;
					gchar** _tmp69_;
					gchar** _tmp70_;
					gint _tmp70__length1;
					const gchar* _tmp71_;
					gchar* _tmp72_;
					gchar* _tmp73_;
					GString* _tmp74_;
					gchar* _tmp75_;
					gchar* _tmp76_;
					GMatchInfo* _tmp77_;
					gchar* _tmp78_;
					gchar* _tmp79_;
					gboolean _tmp80_;
					_tmp64_ = self->count_modified;
					self->count_modified = _tmp64_ + 1;
					_tmp65_ = match;
					_tmp66_ = g_match_info_fetch (_tmp65_, 12);
					_tmp67_ = _tmp66_;
					_tmp69_ = _tmp68_ = g_strsplit (_tmp67_, " -> ", 0);
					_tmp70_ = _tmp69_;
					_tmp70__length1 = _vala_array_length (_tmp68_);
					_tmp71_ = _tmp70_[0];
					_tmp72_ = string_strip (_tmp71_);
					_tmp73_ = _tmp72_;
					async_task_set_status_line ((AsyncTask*) self, _tmp73_);
					_g_free0 (_tmp73_);
					_tmp70_ = (_vala_array_free (_tmp70_, _tmp70__length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (_tmp67_);
					_tmp74_ = self->log;
					_tmp75_ = g_strconcat (line, "\n", NULL);
					_tmp76_ = _tmp75_;
					g_string_append (_tmp74_, _tmp76_);
					_g_free0 (_tmp76_);
					_tmp77_ = match;
					_tmp78_ = g_match_info_fetch (_tmp77_, 3);
					_tmp79_ = _tmp78_;
					_tmp80_ = g_strcmp0 (_tmp79_, "c") == 0;
					_g_free0 (_tmp79_);
					if (_tmp80_) {
						gint64 _tmp81_;
						_tmp81_ = self->count_checksum;
						self->count_checksum = _tmp81_ + 1;
					} else {
						GMatchInfo* _tmp82_;
						gchar* _tmp83_;
						gchar* _tmp84_;
						gboolean _tmp85_;
						_tmp82_ = match;
						_tmp83_ = g_match_info_fetch (_tmp82_, 4);
						_tmp84_ = _tmp83_;
						_tmp85_ = g_strcmp0 (_tmp84_, "s") == 0;
						_g_free0 (_tmp84_);
						if (_tmp85_) {
							gint64 _tmp86_;
							_tmp86_ = self->count_size;
							self->count_size = _tmp86_ + 1;
						} else {
							GMatchInfo* _tmp87_;
							gchar* _tmp88_;
							gchar* _tmp89_;
							gboolean _tmp90_;
							_tmp87_ = match;
							_tmp88_ = g_match_info_fetch (_tmp87_, 5);
							_tmp89_ = _tmp88_;
							_tmp90_ = g_strcmp0 (_tmp89_, "t") == 0;
							_g_free0 (_tmp89_);
							if (_tmp90_) {
								gint64 _tmp91_;
								_tmp91_ = self->count_timestamp;
								self->count_timestamp = _tmp91_ + 1;
							} else {
								GMatchInfo* _tmp92_;
								gchar* _tmp93_;
								gchar* _tmp94_;
								gboolean _tmp95_;
								_tmp92_ = match;
								_tmp93_ = g_match_info_fetch (_tmp92_, 6);
								_tmp94_ = _tmp93_;
								_tmp95_ = g_strcmp0 (_tmp94_, "p") == 0;
								_g_free0 (_tmp94_);
								if (_tmp95_) {
									gint64 _tmp96_;
									_tmp96_ = self->count_permissions;
									self->count_permissions = _tmp96_ + 1;
								} else {
									GMatchInfo* _tmp97_;
									gchar* _tmp98_;
									gchar* _tmp99_;
									gboolean _tmp100_;
									_tmp97_ = match;
									_tmp98_ = g_match_info_fetch (_tmp97_, 7);
									_tmp99_ = _tmp98_;
									_tmp100_ = g_strcmp0 (_tmp99_, "o") == 0;
									_g_free0 (_tmp99_);
									if (_tmp100_) {
										gint64 _tmp101_;
										_tmp101_ = self->count_owner;
										self->count_owner = _tmp101_ + 1;
									} else {
										GMatchInfo* _tmp102_;
										gchar* _tmp103_;
										gchar* _tmp104_;
										gboolean _tmp105_;
										_tmp102_ = match;
										_tmp103_ = g_match_info_fetch (_tmp102_, 8);
										_tmp104_ = _tmp103_;
										_tmp105_ = g_strcmp0 (_tmp104_, "g") == 0;
										_g_free0 (_tmp104_);
										if (_tmp105_) {
											gint64 _tmp106_;
											_tmp106_ = self->count_group;
											self->count_group = _tmp106_ + 1;
										} else {
											gint64 _tmp107_;
											_tmp107_ = self->count_unchanged;
											self->count_unchanged = _tmp107_ + 1;
										}
									}
								}
							}
						}
					}
				} else {
					GeeHashMap* _tmp108_;
					gpointer _tmp109_;
					GRegex* _tmp110_;
					GMatchInfo* _tmp111_ = NULL;
					gboolean _tmp112_;
					gboolean _tmp113_;
					_tmp108_ = self->priv->regex_list;
					_tmp109_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp108_, "total-size");
					_tmp110_ = (GRegex*) _tmp109_;
					_tmp112_ = g_regex_match (_tmp110_, line, 0, &_tmp111_);
					_g_match_info_unref0 (match);
					match = _tmp111_;
					_tmp113_ = _tmp112_;
					_g_regex_unref0 (_tmp110_);
					if (_tmp113_) {
						GMatchInfo* _tmp114_;
						gchar* _tmp115_;
						gchar* _tmp116_;
						gchar* _tmp117_;
						gchar* _tmp118_;
						_tmp114_ = match;
						_tmp115_ = g_match_info_fetch (_tmp114_, 1);
						_tmp116_ = _tmp115_;
						_tmp117_ = string_replace (_tmp116_, ",", "");
						_tmp118_ = _tmp117_;
						self->total_size = int64_parse (_tmp118_, (guint) 0);
						_g_free0 (_tmp118_);
						_g_free0 (_tmp116_);
					} else {
					}
				}
			}
		}
	}
	result = TRUE;
	_g_match_info_unref0 (match);
	return result;
}

static void
rsync_task_real_finish_task (AsyncTask* base)
{
	RsyncTask * self;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GString* _tmp4_;
	const gchar* _tmp5_;
	self = (RsyncTask*) base;
	if (((AsyncTask*) self)->status != APP_STATUS_CANCELLED) {
		_tmp0_ = ((AsyncTask*) self)->status != APP_STATUS_PASSWORD_REQUIRED;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		((AsyncTask*) self)->status = APP_STATUS_FINISHED;
	}
	_tmp1_ = self->rsync_log_file;
	_tmp2_ = g_strconcat (_tmp1_, "-changes", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->log;
	_tmp5_ = _tmp4_->str;
	tee_jee_file_system_file_write (_tmp3_, _tmp5_);
	_g_free0 (_tmp3_);
}

gint
rsync_task_read_status (RsyncTask* self)
{
	gchar* status_file = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* f = NULL;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = ((AsyncTask*) self)->working_dir;
	_tmp1_ = g_strconcat (_tmp0_, "/status", NULL);
	status_file = _tmp1_;
	_tmp2_ = status_file;
	_tmp3_ = g_file_new_for_path (_tmp2_);
	f = _tmp3_;
	_tmp4_ = f;
	if (g_file_query_exists (_tmp4_, NULL)) {
		gchar* txt = NULL;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp5_ = status_file;
		_tmp6_ = tee_jee_file_system_file_read (_tmp5_);
		txt = _tmp6_;
		_tmp7_ = txt;
		result = atoi (_tmp7_);
		_g_free0 (txt);
		_g_object_unref0 (f);
		_g_free0 (status_file);
		return result;
	}
	result = -1;
	_g_object_unref0 (f);
	_g_free0 (status_file);
	return result;
}

static void
rsync_task_class_init (RsyncTaskClass * klass,
                       gpointer klass_data)
{
	rsync_task_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RsyncTask_private_offset);
	((AsyncTaskClass *) klass)->parse_stdout_line = (void (*) (AsyncTask*, const gchar*)) rsync_task_real_parse_stdout_line;
	((AsyncTaskClass *) klass)->parse_stderr_line = (void (*) (AsyncTask*, const gchar*)) rsync_task_real_parse_stderr_line;
	((AsyncTaskClass *) klass)->finish_task = (void (*) (AsyncTask*)) rsync_task_real_finish_task;
	G_OBJECT_CLASS (klass)->finalize = rsync_task_finalize;
}

static void
rsync_task_instance_init (RsyncTask * self,
                          gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	self->priv = rsync_task_get_instance_private (self);
	self->delete_extra = TRUE;
	self->delete_after = FALSE;
	self->delete_excluded = FALSE;
	self->relative = FALSE;
	_tmp0_ = g_strdup ("");
	self->rsync_log_file = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->exclude_from_file = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->link_from_path = _tmp2_;
	_tmp3_ = g_strdup ("");
	self->source_path = _tmp3_;
	_tmp4_ = g_strdup ("");
	self->dest_path = _tmp4_;
	self->verbose = TRUE;
	self->io_nice = TRUE;
	self->dry_run = FALSE;
	self->status_line_count = (gint64) 0;
	self->total_size = (gint64) 0;
}

static void
rsync_task_finalize (GObject * obj)
{
	RsyncTask * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RSYNC_TASK, RsyncTask);
	_g_free0 (self->rsync_log_file);
	_g_free0 (self->exclude_from_file);
	_g_free0 (self->link_from_path);
	_g_free0 (self->source_path);
	_g_free0 (self->dest_path);
	_g_object_unref0 (self->priv->regex_list);
	(self->status_lines == NULL) ? NULL : (self->status_lines = (_g_queue_free__g_free0_ (self->status_lines), NULL));
	_g_string_free0 (self->log);
	G_OBJECT_CLASS (rsync_task_parent_class)->finalize (obj);
}

static GType
rsync_task_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RsyncTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rsync_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RsyncTask), 0, (GInstanceInitFunc) rsync_task_instance_init, NULL };
	GType rsync_task_type_id;
	rsync_task_type_id = g_type_register_static (TYPE_ASYNC_TASK, "RsyncTask", &g_define_type_info, 0);
	RsyncTask_private_offset = g_type_add_instance_private (rsync_task_type_id, sizeof (RsyncTaskPrivate));
	return rsync_task_type_id;
}

GType
rsync_task_get_type (void)
{
	static volatile gsize rsync_task_type_id__once = 0;
	if (g_once_init_enter (&rsync_task_type_id__once)) {
		GType rsync_task_type_id;
		rsync_task_type_id = rsync_task_get_type_once ();
		g_once_init_leave (&rsync_task_type_id__once, rsync_task_type_id);
	}
	return rsync_task_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

