// python wrapper for ttkCinemaWriter
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkCinemaWriter.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkCinemaWriter(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkCinemaWriter_ClassNew(); }

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkCinemaWriter_FORMAT_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkCinemaWriter.ttkCinemaWriter.FORMAT", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyttkCinemaWriter_FORMAT_FromEnum(T val)
{
  return PyVTKEnum_New(&PyttkCinemaWriter_FORMAT_Type, static_cast<int>(val));
}


static PyObject *
PyttkCinemaWriter_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkCinemaWriter::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaWriter_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaWriter *op = static_cast<ttkCinemaWriter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkCinemaWriter::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaWriter_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkCinemaWriter *tempr = ttkCinemaWriter::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaWriter_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaWriter *op = static_cast<ttkCinemaWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkCinemaWriter *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkCinemaWriter::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaWriter_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkCinemaWriter::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaWriter_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaWriter *op = static_cast<ttkCinemaWriter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkCinemaWriter::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaWriter_SetDatabasePath(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDatabasePath");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaWriter *op = static_cast<ttkCinemaWriter *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDatabasePath(temp0);
    }
    else
    {
      op->ttkCinemaWriter::SetDatabasePath(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkCinemaWriter_GetDatabasePath(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDatabasePath");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaWriter *op = static_cast<ttkCinemaWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetDatabasePath() :
      op->ttkCinemaWriter::GetDatabasePath());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaWriter_SetFormat_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFormat");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaWriter *op = static_cast<ttkCinemaWriter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFormat(temp0);
    }
    else
    {
      op->ttkCinemaWriter::SetFormat(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkCinemaWriter_SetFormat_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFormat");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaWriter *op = static_cast<ttkCinemaWriter *>(vp);

  typedef ttkCinemaWriter::FORMAT temp0_type;
  temp0_type temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetEnumValue(temp0, "ttkCinemaWriter.FORMAT"))
  {
    if (ap.IsBound())
    {
      op->SetFormat(temp0);
    }
    else
    {
      op->ttkCinemaWriter::SetFormat(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyttkCinemaWriter_SetFormat_Methods[] = {
  {"SetFormat", PyttkCinemaWriter_SetFormat_s1, METH_VARARGS,
   "@i"},
  {"SetFormat", PyttkCinemaWriter_SetFormat_s2, METH_VARARGS,
   "@E ttkCinemaWriter.FORMAT"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyttkCinemaWriter_SetFormat(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyttkCinemaWriter_SetFormat_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetFormat");
  return nullptr;
}


static PyObject *
PyttkCinemaWriter_GetFormat(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFormat");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaWriter *op = static_cast<ttkCinemaWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    typedef ttkCinemaWriter::FORMAT tempr_type;
  tempr_type tempr = (ap.IsBound() ?
      op->GetFormat() :
      op->ttkCinemaWriter::GetFormat());

    if (!ap.ErrorOccurred())
    {
      result = PyttkCinemaWriter_FORMAT_FromEnum(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaWriter_SetCompressionLevel(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCompressionLevel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaWriter *op = static_cast<ttkCinemaWriter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCompressionLevel(temp0);
    }
    else
    {
      op->ttkCinemaWriter::SetCompressionLevel(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkCinemaWriter_GetCompressionLevel(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCompressionLevel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaWriter *op = static_cast<ttkCinemaWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetCompressionLevel() :
      op->ttkCinemaWriter::GetCompressionLevel());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaWriter_SetIterateMultiBlock(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetIterateMultiBlock");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaWriter *op = static_cast<ttkCinemaWriter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetIterateMultiBlock(temp0);
    }
    else
    {
      op->ttkCinemaWriter::SetIterateMultiBlock(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkCinemaWriter_GetIterateMultiBlock(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetIterateMultiBlock");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaWriter *op = static_cast<ttkCinemaWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetIterateMultiBlock() :
      op->ttkCinemaWriter::GetIterateMultiBlock());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaWriter_SetForwardInput(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetForwardInput");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaWriter *op = static_cast<ttkCinemaWriter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetForwardInput(temp0);
    }
    else
    {
      op->ttkCinemaWriter::SetForwardInput(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkCinemaWriter_GetForwardInput(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetForwardInput");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaWriter *op = static_cast<ttkCinemaWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetForwardInput() :
      op->ttkCinemaWriter::GetForwardInput());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaWriter_GetTolerance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTolerance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaWriter *op = static_cast<ttkCinemaWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetTolerance() :
      op->ttkCinemaWriter::GetTolerance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaWriter_SetTolerance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTolerance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaWriter *op = static_cast<ttkCinemaWriter *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTolerance(temp0);
    }
    else
    {
      op->ttkCinemaWriter::SetTolerance(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkCinemaWriter_GetMaximumError(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMaximumError");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaWriter *op = static_cast<ttkCinemaWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetMaximumError() :
      op->ttkCinemaWriter::GetMaximumError());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaWriter_SetMaximumError(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMaximumError");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaWriter *op = static_cast<ttkCinemaWriter *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMaximumError(temp0);
    }
    else
    {
      op->ttkCinemaWriter::SetMaximumError(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkCinemaWriter_GetZFPTolerance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetZFPTolerance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaWriter *op = static_cast<ttkCinemaWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetZFPTolerance() :
      op->ttkCinemaWriter::GetZFPTolerance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaWriter_SetZFPTolerance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetZFPTolerance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaWriter *op = static_cast<ttkCinemaWriter *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetZFPTolerance(temp0);
    }
    else
    {
      op->ttkCinemaWriter::SetZFPTolerance(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkCinemaWriter_GetZFPOnly(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetZFPOnly");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaWriter *op = static_cast<ttkCinemaWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetZFPOnly() :
      op->ttkCinemaWriter::GetZFPOnly());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaWriter_SetZFPOnly(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetZFPOnly");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaWriter *op = static_cast<ttkCinemaWriter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetZFPOnly(temp0);
    }
    else
    {
      op->ttkCinemaWriter::SetZFPOnly(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkCinemaWriter_GetCompressionType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCompressionType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaWriter *op = static_cast<ttkCinemaWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetCompressionType() :
      op->ttkCinemaWriter::GetCompressionType());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaWriter_SetCompressionType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCompressionType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaWriter *op = static_cast<ttkCinemaWriter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCompressionType(temp0);
    }
    else
    {
      op->ttkCinemaWriter::SetCompressionType(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkCinemaWriter_GetSubdivide(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSubdivide");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaWriter *op = static_cast<ttkCinemaWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetSubdivide() :
      op->ttkCinemaWriter::GetSubdivide());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaWriter_SetSubdivide(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSubdivide");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaWriter *op = static_cast<ttkCinemaWriter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSubdivide(temp0);
    }
    else
    {
      op->ttkCinemaWriter::SetSubdivide(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkCinemaWriter_GetUseTopologicalSimplification(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseTopologicalSimplification");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaWriter *op = static_cast<ttkCinemaWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseTopologicalSimplification() :
      op->ttkCinemaWriter::GetUseTopologicalSimplification());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaWriter_SetUseTopologicalSimplification(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseTopologicalSimplification");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaWriter *op = static_cast<ttkCinemaWriter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseTopologicalSimplification(temp0);
    }
    else
    {
      op->ttkCinemaWriter::SetUseTopologicalSimplification(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkCinemaWriter_SetSQMethodPV(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSQMethodPV");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaWriter *op = static_cast<ttkCinemaWriter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSQMethodPV(temp0);
    }
    else
    {
      op->ttkCinemaWriter::SetSQMethodPV(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkCinemaWriter_DeleteDatabase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DeleteDatabase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaWriter *op = static_cast<ttkCinemaWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->DeleteDatabase() :
      op->ttkCinemaWriter::DeleteDatabase());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaWriter_GetLockFilePath(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLockFilePath");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaWriter *op = static_cast<ttkCinemaWriter *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetLockFilePath(temp0) :
      op->ttkCinemaWriter::GetLockFilePath(temp0));

    if (!ap.ErrorOccurred())
    {
      ap.SetArgValue(0, temp0);
    }
    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaWriter_InitializeLockFile(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InitializeLockFile");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaWriter *op = static_cast<ttkCinemaWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->InitializeLockFile() :
      op->ttkCinemaWriter::InitializeLockFile());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkCinemaWriter_Methods[] = {
  {"IsTypeOf", PyttkCinemaWriter_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkCinemaWriter_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkCinemaWriter_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkCinemaWriter\nC++: static ttkCinemaWriter *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkCinemaWriter_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkCinemaWriter\nC++: ttkCinemaWriter *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkCinemaWriter_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkCinemaWriter_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetDatabasePath", PyttkCinemaWriter_SetDatabasePath, METH_VARARGS,
   "SetDatabasePath(self, _arg:str) -> None\nC++: virtual void SetDatabasePath(const std::string &_arg)\n\n"},
  {"GetDatabasePath", PyttkCinemaWriter_GetDatabasePath, METH_VARARGS,
   "GetDatabasePath(self) -> str\nC++: virtual std::string GetDatabasePath()\n\n"},
  {"SetFormat", PyttkCinemaWriter_SetFormat, METH_VARARGS,
   "SetFormat(self, _arg:int) -> None\nC++: virtual void SetFormat(int _arg)\nSetFormat(self, _arg:FORMAT) -> None\nC++: virtual void SetFormat(FORMAT _arg)\n\n"},
  {"GetFormat", PyttkCinemaWriter_GetFormat, METH_VARARGS,
   "GetFormat(self) -> FORMAT\nC++: virtual FORMAT GetFormat()\n\n"},
  {"SetCompressionLevel", PyttkCinemaWriter_SetCompressionLevel, METH_VARARGS,
   "SetCompressionLevel(self, _arg:int) -> None\nC++: virtual void SetCompressionLevel(int _arg)\n\n"},
  {"GetCompressionLevel", PyttkCinemaWriter_GetCompressionLevel, METH_VARARGS,
   "GetCompressionLevel(self) -> int\nC++: virtual int GetCompressionLevel()\n\n"},
  {"SetIterateMultiBlock", PyttkCinemaWriter_SetIterateMultiBlock, METH_VARARGS,
   "SetIterateMultiBlock(self, _arg:bool) -> None\nC++: virtual void SetIterateMultiBlock(bool _arg)\n\n"},
  {"GetIterateMultiBlock", PyttkCinemaWriter_GetIterateMultiBlock, METH_VARARGS,
   "GetIterateMultiBlock(self) -> bool\nC++: virtual bool GetIterateMultiBlock()\n\n"},
  {"SetForwardInput", PyttkCinemaWriter_SetForwardInput, METH_VARARGS,
   "SetForwardInput(self, _arg:bool) -> None\nC++: virtual void SetForwardInput(bool _arg)\n\n"},
  {"GetForwardInput", PyttkCinemaWriter_GetForwardInput, METH_VARARGS,
   "GetForwardInput(self) -> bool\nC++: virtual bool GetForwardInput()\n\n"},
  {"GetTolerance", PyttkCinemaWriter_GetTolerance, METH_VARARGS,
   "GetTolerance(self) -> float\nC++: virtual double GetTolerance()\n\n"},
  {"SetTolerance", PyttkCinemaWriter_SetTolerance, METH_VARARGS,
   "SetTolerance(self, _arg:float) -> None\nC++: virtual void SetTolerance(double _arg)\n\n"},
  {"GetMaximumError", PyttkCinemaWriter_GetMaximumError, METH_VARARGS,
   "GetMaximumError(self) -> float\nC++: virtual double GetMaximumError()\n\n"},
  {"SetMaximumError", PyttkCinemaWriter_SetMaximumError, METH_VARARGS,
   "SetMaximumError(self, _arg:float) -> None\nC++: virtual void SetMaximumError(double _arg)\n\n"},
  {"GetZFPTolerance", PyttkCinemaWriter_GetZFPTolerance, METH_VARARGS,
   "GetZFPTolerance(self) -> float\nC++: virtual double GetZFPTolerance()\n\n"},
  {"SetZFPTolerance", PyttkCinemaWriter_SetZFPTolerance, METH_VARARGS,
   "SetZFPTolerance(self, _arg:float) -> None\nC++: virtual void SetZFPTolerance(double _arg)\n\n"},
  {"GetZFPOnly", PyttkCinemaWriter_GetZFPOnly, METH_VARARGS,
   "GetZFPOnly(self) -> bool\nC++: virtual bool GetZFPOnly()\n\n"},
  {"SetZFPOnly", PyttkCinemaWriter_SetZFPOnly, METH_VARARGS,
   "SetZFPOnly(self, _arg:bool) -> None\nC++: virtual void SetZFPOnly(bool _arg)\n\n"},
  {"GetCompressionType", PyttkCinemaWriter_GetCompressionType, METH_VARARGS,
   "GetCompressionType(self) -> int\nC++: virtual int GetCompressionType()\n\n"},
  {"SetCompressionType", PyttkCinemaWriter_SetCompressionType, METH_VARARGS,
   "SetCompressionType(self, _arg:int) -> None\nC++: virtual void SetCompressionType(int _arg)\n\n"},
  {"GetSubdivide", PyttkCinemaWriter_GetSubdivide, METH_VARARGS,
   "GetSubdivide(self) -> bool\nC++: virtual bool GetSubdivide()\n\n"},
  {"SetSubdivide", PyttkCinemaWriter_SetSubdivide, METH_VARARGS,
   "SetSubdivide(self, _arg:bool) -> None\nC++: virtual void SetSubdivide(bool _arg)\n\n"},
  {"GetUseTopologicalSimplification", PyttkCinemaWriter_GetUseTopologicalSimplification, METH_VARARGS,
   "GetUseTopologicalSimplification(self) -> bool\nC++: virtual bool GetUseTopologicalSimplification()\n\n"},
  {"SetUseTopologicalSimplification", PyttkCinemaWriter_SetUseTopologicalSimplification, METH_VARARGS,
   "SetUseTopologicalSimplification(self, _arg:bool) -> None\nC++: virtual void SetUseTopologicalSimplification(bool _arg)\n\n"},
  {"SetSQMethodPV", PyttkCinemaWriter_SetSQMethodPV, METH_VARARGS,
   "SetSQMethodPV(self, _arg:int) -> None\nC++: virtual void SetSQMethodPV(int _arg)\n\n"},
  {"DeleteDatabase", PyttkCinemaWriter_DeleteDatabase, METH_VARARGS,
   "DeleteDatabase(self) -> int\nC++: int DeleteDatabase()\n\n"},
  {"GetLockFilePath", PyttkCinemaWriter_GetLockFilePath, METH_VARARGS,
   "GetLockFilePath(self, path:str) -> int\nC++: int GetLockFilePath(std::string &path)\n\n"},
  {"InitializeLockFile", PyttkCinemaWriter_InitializeLockFile, METH_VARARGS,
   "InitializeLockFile(self) -> int\nC++: int InitializeLockFile()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkCinemaWriter_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("database_path"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkCinemaWriter_GetDatabasePath(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkCinemaWriter_SetDatabasePath(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkCinemaWriter_SetDatabasePath(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDatabasePath/SetDatabasePath\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("format"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkCinemaWriter_SetFormat(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkCinemaWriter_SetFormat(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetFormat\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("format"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkCinemaWriter_GetFormat(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkCinemaWriter_SetFormat(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkCinemaWriter_SetFormat(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFormat/SetFormat\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("compression_level"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkCinemaWriter_GetCompressionLevel(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkCinemaWriter_SetCompressionLevel(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkCinemaWriter_SetCompressionLevel(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetCompressionLevel/SetCompressionLevel\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("iterate_multi_block"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkCinemaWriter_GetIterateMultiBlock(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkCinemaWriter_SetIterateMultiBlock(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkCinemaWriter_SetIterateMultiBlock(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetIterateMultiBlock/SetIterateMultiBlock\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("forward_input"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkCinemaWriter_GetForwardInput(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkCinemaWriter_SetForwardInput(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkCinemaWriter_SetForwardInput(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetForwardInput/SetForwardInput\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("tolerance"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkCinemaWriter_GetTolerance(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkCinemaWriter_SetTolerance(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkCinemaWriter_SetTolerance(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTolerance/SetTolerance\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("maximum_error"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkCinemaWriter_GetMaximumError(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkCinemaWriter_SetMaximumError(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkCinemaWriter_SetMaximumError(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMaximumError/SetMaximumError\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("zfp_tolerance"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkCinemaWriter_GetZFPTolerance(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkCinemaWriter_SetZFPTolerance(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkCinemaWriter_SetZFPTolerance(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetZFPTolerance/SetZFPTolerance\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("zfp_only"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkCinemaWriter_GetZFPOnly(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkCinemaWriter_SetZFPOnly(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkCinemaWriter_SetZFPOnly(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetZFPOnly/SetZFPOnly\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("compression_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkCinemaWriter_GetCompressionType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkCinemaWriter_SetCompressionType(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkCinemaWriter_SetCompressionType(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetCompressionType/SetCompressionType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("subdivide"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkCinemaWriter_GetSubdivide(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkCinemaWriter_SetSubdivide(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkCinemaWriter_SetSubdivide(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSubdivide/SetSubdivide\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_topological_simplification"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkCinemaWriter_GetUseTopologicalSimplification(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkCinemaWriter_SetUseTopologicalSimplification(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkCinemaWriter_SetUseTopologicalSimplification(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseTopologicalSimplification/SetUseTopologicalSimplification\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("sq_method_pv"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkCinemaWriter_SetSQMethodPV(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkCinemaWriter_SetSQMethodPV(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSQMethodPV\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkCinemaWriter_Doc =
  "ttkCinemaWriter - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Jonas Lukasczyk <jl@jluk.de>\\date 01.09.2018\n\n"
  "TTK VTK-filter that writes input to disk.\n\n"
  "This filter stores the input as a VTK dataset to disk and updates the\n"
  "data.csv file of a Cinema Spec D database.\n\n"
  "\\param Input vtkDataSet to be stored (vtkDataSet)\n\n"
  "Online examples:\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/cinemaIO/\">Cinema\n"
  "   IO example\\n\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkCinemaWriter_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkCinemaWriter.ttkCinemaWriter", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkCinemaWriter_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkCinemaWriter_StaticNew()
{
  return ttkCinemaWriter::New();
}

PyObject *PyttkCinemaWriter_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkCinemaWriter_Type, PyttkCinemaWriter_Methods,
    "ttkCinemaWriter",
 &PyttkCinemaWriter_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyttkCinemaWriter_FORMAT_Type);
  // members of ttkCinemaWriter::FORMAT
  {
    PyObject *enumval;
    PyObject *enumdict = PyDict_New();
    PyttkCinemaWriter_FORMAT_Type.tp_dict = enumdict;

    typedef ttkCinemaWriter::FORMAT cxx_enum_type;
    static const struct {
      const char *name; cxx_enum_type value;
    } constants[3] = {
      { "VTK", cxx_enum_type::VTK },
      { "PNG", cxx_enum_type::PNG },
      { "TTK", cxx_enum_type::TTK },
    };

    for (int c = 0; c < 3; c++)
    {
      enumval = PyttkCinemaWriter_FORMAT_FromEnum(constants[c].value);
      if (enumval)
      {
        PyDict_SetItemString(enumdict, constants[c].name, enumval);
        Py_DECREF(enumval);
      }
    }
  }

  PyVTKEnum_Add(&PyttkCinemaWriter_FORMAT_Type, "ttkCinemaWriter.FORMAT");

  o = (PyObject *)&PyttkCinemaWriter_FORMAT_Type;
  if (PyDict_SetItemString(d, "FORMAT", o) != 0)
  {
    Py_DECREF(o);
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkCinemaWriter_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkCinemaWriter(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkCinemaWriter_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkCinemaWriter", o) != 0)
  {
    Py_DECREF(o);
  }

}

