/* umockdev-spi.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from umockdev-spi.vala, do not modify */

/*
 * Copyright (C) 2021 Red Hat Inc.
 * Author: Benjamin Berg <bberg@redhat.com>
 *
 * umockdev is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * umockdev is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include "umockdev.h"
#include "linux/spi/spidev.h"
#include <glib/gstdio.h>
#include "linux/ioctl.h"
#include <errno.h>
#include <stdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define UMOCKDEV_TYPE_TRANSFER_CHUNK (umockdev_transfer_chunk_get_type ())
typedef struct _UMockdevTransferChunk UMockdevTransferChunk;

#define UMOCKDEV_TYPE_IOCTL_SPI_BASE (umockdev_ioctl_spi_base_get_type ())
#define UMOCKDEV_IOCTL_SPI_BASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UMOCKDEV_TYPE_IOCTL_SPI_BASE, UMockdevIoctlSpiBase))
#define UMOCKDEV_IOCTL_SPI_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UMOCKDEV_TYPE_IOCTL_SPI_BASE, UMockdevIoctlSpiBaseClass))
#define UMOCKDEV_IS_IOCTL_SPI_BASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UMOCKDEV_TYPE_IOCTL_SPI_BASE))
#define UMOCKDEV_IS_IOCTL_SPI_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UMOCKDEV_TYPE_IOCTL_SPI_BASE))
#define UMOCKDEV_IOCTL_SPI_BASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UMOCKDEV_TYPE_IOCTL_SPI_BASE, UMockdevIoctlSpiBaseClass))

typedef struct _UMockdevIoctlSpiBase UMockdevIoctlSpiBase;
typedef struct _UMockdevIoctlSpiBaseClass UMockdevIoctlSpiBaseClass;
typedef struct _UMockdevIoctlSpiBasePrivate UMockdevIoctlSpiBasePrivate;
enum  {
	UMOCKDEV_IOCTL_SPI_BASE_0_PROPERTY,
	UMOCKDEV_IOCTL_SPI_BASE_NUM_PROPERTIES
};
static GParamSpec* umockdev_ioctl_spi_base_properties[UMOCKDEV_IOCTL_SPI_BASE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define UMOCKDEV_TYPE_IOCTL_SPI_HANDLER (umockdev_ioctl_spi_handler_get_type ())
#define UMOCKDEV_IOCTL_SPI_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UMOCKDEV_TYPE_IOCTL_SPI_HANDLER, UMockdevIoctlSpiHandler))
#define UMOCKDEV_IOCTL_SPI_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UMOCKDEV_TYPE_IOCTL_SPI_HANDLER, UMockdevIoctlSpiHandlerClass))
#define UMOCKDEV_IS_IOCTL_SPI_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UMOCKDEV_TYPE_IOCTL_SPI_HANDLER))
#define UMOCKDEV_IS_IOCTL_SPI_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UMOCKDEV_TYPE_IOCTL_SPI_HANDLER))
#define UMOCKDEV_IOCTL_SPI_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UMOCKDEV_TYPE_IOCTL_SPI_HANDLER, UMockdevIoctlSpiHandlerClass))

typedef struct _UMockdevIoctlSpiHandler UMockdevIoctlSpiHandler;
typedef struct _UMockdevIoctlSpiHandlerClass UMockdevIoctlSpiHandlerClass;
typedef struct _UMockdevIoctlSpiHandlerPrivate UMockdevIoctlSpiHandlerPrivate;
enum  {
	UMOCKDEV_IOCTL_SPI_HANDLER_0_PROPERTY,
	UMOCKDEV_IOCTL_SPI_HANDLER_NUM_PROPERTIES
};
static GParamSpec* umockdev_ioctl_spi_handler_properties[UMOCKDEV_IOCTL_SPI_HANDLER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define UMOCKDEV_TYPE_IOCTL_SPI_RECORDER (umockdev_ioctl_spi_recorder_get_type ())
#define UMOCKDEV_IOCTL_SPI_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UMOCKDEV_TYPE_IOCTL_SPI_RECORDER, UMockdevIoctlSpiRecorder))
#define UMOCKDEV_IOCTL_SPI_RECORDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UMOCKDEV_TYPE_IOCTL_SPI_RECORDER, UMockdevIoctlSpiRecorderClass))
#define UMOCKDEV_IS_IOCTL_SPI_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UMOCKDEV_TYPE_IOCTL_SPI_RECORDER))
#define UMOCKDEV_IS_IOCTL_SPI_RECORDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UMOCKDEV_TYPE_IOCTL_SPI_RECORDER))
#define UMOCKDEV_IOCTL_SPI_RECORDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UMOCKDEV_TYPE_IOCTL_SPI_RECORDER, UMockdevIoctlSpiRecorderClass))

typedef struct _UMockdevIoctlSpiRecorder UMockdevIoctlSpiRecorder;
typedef struct _UMockdevIoctlSpiRecorderClass UMockdevIoctlSpiRecorderClass;
typedef struct _UMockdevIoctlSpiRecorderPrivate UMockdevIoctlSpiRecorderPrivate;
enum  {
	UMOCKDEV_IOCTL_SPI_RECORDER_0_PROPERTY,
	UMOCKDEV_IOCTL_SPI_RECORDER_NUM_PROPERTIES
};
static GParamSpec* umockdev_ioctl_spi_recorder_properties[UMOCKDEV_IOCTL_SPI_RECORDER_NUM_PROPERTIES];
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _UMockdevTransferChunk {
	guint8* tx;
	gint tx_length1;
	gint _tx_size_;
	guint8* rx;
	gint rx_length1;
	gint _rx_size_;
	gboolean cont;
};

struct _UMockdevIoctlSpiBase {
	UMockdevIoctlBase parent_instance;
	UMockdevIoctlSpiBasePrivate * priv;
};

struct _UMockdevIoctlSpiBaseClass {
	UMockdevIoctlBaseClass parent_class;
	glong (*handle_read_write) (UMockdevIoctlSpiBase* self, UMockdevIoctlData* tx, UMockdevIoctlData* rx, gboolean keep_cs_high);
};

struct _UMockdevIoctlSpiHandler {
	UMockdevIoctlSpiBase parent_instance;
	UMockdevIoctlSpiHandlerPrivate * priv;
};

struct _UMockdevIoctlSpiHandlerClass {
	UMockdevIoctlSpiBaseClass parent_class;
};

struct _UMockdevIoctlSpiHandlerPrivate {
	UMockdevTransferChunk* recording;
	gint recording_length1;
	gint _recording_size_;
	glong replay_chunk;
	glong replay_byte;
};

struct _UMockdevIoctlSpiRecorder {
	UMockdevIoctlSpiBase parent_instance;
	UMockdevIoctlSpiRecorderPrivate * priv;
};

struct _UMockdevIoctlSpiRecorderClass {
	UMockdevIoctlSpiBaseClass parent_class;
};

struct _UMockdevIoctlSpiRecorderPrivate {
	gboolean cs_is_high;
	FILE* log;
};

static gpointer umockdev_ioctl_spi_base_parent_class = NULL;
static gint UMockdevIoctlSpiHandler_private_offset;
static gpointer umockdev_ioctl_spi_handler_parent_class = NULL;
static gint UMockdevIoctlSpiRecorder_private_offset;
static gpointer umockdev_ioctl_spi_recorder_parent_class = NULL;

VALA_EXTERN guint8 umockdev_spi_hexdigit (gchar c);
VALA_EXTERN guint8* umockdev_spi_decode_hex (const gchar* data,
                                 gint* result_length1,
                                 GError** error);
VALA_EXTERN GType umockdev_transfer_chunk_get_type (void) G_GNUC_CONST ;
VALA_EXTERN UMockdevTransferChunk* umockdev_transfer_chunk_dup (const UMockdevTransferChunk* self);
VALA_EXTERN void umockdev_transfer_chunk_free (UMockdevTransferChunk* self);
VALA_EXTERN void umockdev_transfer_chunk_copy (const UMockdevTransferChunk* self,
                                   UMockdevTransferChunk* dest);
VALA_EXTERN void umockdev_transfer_chunk_destroy (UMockdevTransferChunk* self);
static guint8* _vala_array_dup7 (guint8* self,
                          gssize length);
static guint8* _vala_array_dup8 (guint8* self,
                          gssize length);
VALA_EXTERN GType umockdev_ioctl_spi_base_get_type (void) G_GNUC_CONST ;
VALA_EXTERN glong umockdev_ioctl_spi_base_handle_read_write (UMockdevIoctlSpiBase* self,
                                                 UMockdevIoctlData* tx,
                                                 UMockdevIoctlData* rx,
                                                 gboolean keep_cs_high);
VALA_EXTERN glong umockdev_ioctl_spi_base_iter_ioctl_vector (UMockdevIoctlSpiBase* self,
                                                 gulong count,
                                                 UMockdevIoctlData* data,
                                                 gboolean for_recording);
static glong umockdev_ioctl_spi_base_real_handle_read_write (UMockdevIoctlSpiBase* self,
                                                      UMockdevIoctlData* tx,
                                                      UMockdevIoctlData* rx,
                                                      gboolean keep_cs_high);
VALA_EXTERN UMockdevIoctlSpiBase* umockdev_ioctl_spi_base_construct (GType object_type);
static GType umockdev_ioctl_spi_base_get_type_once (void);
VALA_EXTERN GType umockdev_ioctl_spi_handler_get_type (void) G_GNUC_CONST ;
static void _vala_UMockdevTransferChunk_array_free (UMockdevTransferChunk * array,
                                             gssize array_length);
VALA_EXTERN UMockdevIoctlSpiHandler* umockdev_ioctl_spi_handler_new (const gchar* file);
VALA_EXTERN UMockdevIoctlSpiHandler* umockdev_ioctl_spi_handler_construct (GType object_type,
                                                               const gchar* file);
static void _vala_array_add25 (UMockdevTransferChunk* * array,
                        gint* length,
                        gint* size,
                        const UMockdevTransferChunk* value);
static void _vala_array_add26 (UMockdevTransferChunk* * array,
                        gint* length,
                        gint* size,
                        const UMockdevTransferChunk* value);
static gboolean umockdev_ioctl_spi_handler_real_handle_ioctl (UMockdevIoctlBase* base,
                                                       UMockdevIoctlClient* client);
static gboolean umockdev_ioctl_spi_handler_real_handle_read (UMockdevIoctlBase* base,
                                                      UMockdevIoctlClient* client);
static gboolean umockdev_ioctl_spi_handler_real_handle_write (UMockdevIoctlBase* base,
                                                       UMockdevIoctlClient* client);
static glong umockdev_ioctl_spi_handler_real_handle_read_write (UMockdevIoctlSpiBase* base,
                                                         UMockdevIoctlData* tx,
                                                         UMockdevIoctlData* rx,
                                                         gboolean keep_cs_high);
static void umockdev_ioctl_spi_handler_finalize (GObject * obj);
static GType umockdev_ioctl_spi_handler_get_type_once (void);
VALA_EXTERN GType umockdev_ioctl_spi_recorder_get_type (void) G_GNUC_CONST ;
VALA_EXTERN UMockdevIoctlSpiRecorder* umockdev_ioctl_spi_recorder_new (const gchar* device,
                                                           const gchar* file);
VALA_EXTERN UMockdevIoctlSpiRecorder* umockdev_ioctl_spi_recorder_construct (GType object_type,
                                                                 const gchar* device,
                                                                 const gchar* file);
static gboolean umockdev_ioctl_spi_recorder_real_handle_ioctl (UMockdevIoctlBase* base,
                                                        UMockdevIoctlClient* client);
static gboolean umockdev_ioctl_spi_recorder_real_handle_read (UMockdevIoctlBase* base,
                                                       UMockdevIoctlClient* client);
static gboolean umockdev_ioctl_spi_recorder_real_handle_write (UMockdevIoctlBase* base,
                                                        UMockdevIoctlClient* client);
static void umockdev_ioctl_spi_recorder_write_hex (UMockdevIoctlSpiRecorder* self,
                                            guint8* buf,
                                            gint buf_length1);
static glong umockdev_ioctl_spi_recorder_real_handle_read_write (UMockdevIoctlSpiBase* base,
                                                          UMockdevIoctlData* tx,
                                                          UMockdevIoctlData* rx,
                                                          gboolean keep_cs_high);
static void umockdev_ioctl_spi_recorder_finalize (GObject * obj);
static GType umockdev_ioctl_spi_recorder_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

guint8
umockdev_spi_hexdigit (gchar c)
{
	gint _tmp0_ = 0;
	guint8 result;
	if (c >= 'a') {
		_tmp0_ = (c - 'a') + 10;
	} else {
		gint _tmp1_ = 0;
		if (c >= 'A') {
			_tmp1_ = (c - 'A') + 10;
		} else {
			_tmp1_ = (gint) (c - '0');
		}
		_tmp0_ = _tmp1_;
	}
	result = (guint8) _tmp0_;
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

guint8*
umockdev_spi_decode_hex (const gchar* data,
                         gint* result_length1,
                         GError** error)
{
	gint _tmp0_;
	gint _tmp1_;
	gint len = 0;
	gint _tmp3_;
	gint _tmp4_;
	guint8* bin = NULL;
	guint8* _tmp5_;
	gint bin_length1;
	gint _bin_size_;
	guint8* _tmp10_;
	gint _tmp10__length1;
	GError* _inner_error0_ = NULL;
	guint8* result;
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = strlen (data);
	_tmp1_ = _tmp0_;
	if ((_tmp1_ % 2) != 0) {
		GError* _tmp2_;
		_tmp2_ = g_error_new (G_IO_ERROR, G_IO_ERROR_PARTIAL_INPUT, "malformed hexadecimal value: %s", data);
		_inner_error0_ = _tmp2_;
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp3_ = strlen (data);
	_tmp4_ = _tmp3_;
	len = _tmp4_;
	_tmp5_ = g_new0 (guint8, len / 2);
	bin = _tmp5_;
	bin_length1 = len / 2;
	_bin_size_ = bin_length1;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				guint8* _tmp8_;
				gint _tmp8__length1;
				guint8* _tmp9_;
				gint _tmp9__length1;
				if (!_tmp6_) {
					guint _tmp7_;
					i = i + 1;
					_tmp7_ = i;
				}
				_tmp6_ = FALSE;
				_tmp8_ = bin;
				_tmp8__length1 = bin_length1;
				if (!(i < ((guint) _tmp8__length1))) {
					break;
				}
				_tmp9_ = bin;
				_tmp9__length1 = bin_length1;
				_tmp9_[i] = (guint8) ((umockdev_spi_hexdigit (string_get (data, (glong) (i * 2))) << 4) | umockdev_spi_hexdigit (string_get (data, (glong) ((i * 2) + 1))));
			}
		}
	}
	_tmp10_ = bin;
	_tmp10__length1 = bin_length1;
	if (result_length1) {
		*result_length1 = _tmp10__length1;
	}
	result = _tmp10_;
	return result;
}

static guint8*
_vala_array_dup7 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static guint8*
_vala_array_dup8 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

void
umockdev_transfer_chunk_copy (const UMockdevTransferChunk* self,
                              UMockdevTransferChunk* dest)
{
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
	guint8* _tmp2_;
	gint _tmp2__length1;
	guint8* _tmp3_;
	gint _tmp3__length1;
	_tmp0_ = (*self).tx;
	_tmp0__length1 = (*self).tx_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup7 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	(*dest).tx = (g_free ((*dest).tx), NULL);
	(*dest).tx = _tmp1_;
	(*dest).tx_length1 = _tmp1__length1;
	(*dest)._tx_size_ = (*dest).tx_length1;
	_tmp2_ = (*self).rx;
	_tmp2__length1 = (*self).rx_length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup8 (_tmp2_, _tmp2__length1) : _tmp2_;
	_tmp3__length1 = _tmp2__length1;
	(*dest).rx = (g_free ((*dest).rx), NULL);
	(*dest).rx = _tmp3_;
	(*dest).rx_length1 = _tmp3__length1;
	(*dest)._rx_size_ = (*dest).rx_length1;
	(*dest).cont = (*self).cont;
}

void
umockdev_transfer_chunk_destroy (UMockdevTransferChunk* self)
{
	(*self).tx = (g_free ((*self).tx), NULL);
	(*self).rx = (g_free ((*self).rx), NULL);
}

UMockdevTransferChunk*
umockdev_transfer_chunk_dup (const UMockdevTransferChunk* self)
{
	UMockdevTransferChunk* dup;
	dup = g_new0 (UMockdevTransferChunk, 1);
	umockdev_transfer_chunk_copy (self, dup);
	return dup;
}

void
umockdev_transfer_chunk_free (UMockdevTransferChunk* self)
{
	umockdev_transfer_chunk_destroy (self);
	g_free (self);
}

static GType
umockdev_transfer_chunk_get_type_once (void)
{
	GType umockdev_transfer_chunk_type_id;
	umockdev_transfer_chunk_type_id = g_boxed_type_register_static ("UMockdevTransferChunk", (GBoxedCopyFunc) umockdev_transfer_chunk_dup, (GBoxedFreeFunc) umockdev_transfer_chunk_free);
	return umockdev_transfer_chunk_type_id;
}

GType
umockdev_transfer_chunk_get_type (void)
{
	static volatile gsize umockdev_transfer_chunk_type_id__once = 0;
	if (g_once_init_enter (&umockdev_transfer_chunk_type_id__once)) {
		GType umockdev_transfer_chunk_type_id;
		umockdev_transfer_chunk_type_id = umockdev_transfer_chunk_get_type_once ();
		g_once_init_leave (&umockdev_transfer_chunk_type_id__once, umockdev_transfer_chunk_type_id);
	}
	return umockdev_transfer_chunk_type_id__once;
}

glong
umockdev_ioctl_spi_base_iter_ioctl_vector (UMockdevIoctlSpiBase* self,
                                           gulong count,
                                           UMockdevIoctlData* data,
                                           gboolean for_recording)
{
	glong transferred = 0L;
	GError* _inner_error0_ = NULL;
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	g_return_val_if_fail (data != NULL, 0L);
	transferred = (glong) 0;
	{
		glong i = 0L;
		i = (glong) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				UMockdevIoctlData* tx = NULL;
				UMockdevIoctlData* rx = NULL;
				struct spi_ioc_transfer* transfer = NULL;
				guint8* _tmp2_;
				gint _tmp2__length1;
				struct spi_ioc_transfer* _tmp3_;
				struct spi_ioc_transfer* _tmp4_;
				struct spi_ioc_transfer* _tmp5_;
				glong res = 0L;
				gboolean keep_cs_high = FALSE;
				UMockdevIoctlData* _tmp23_;
				UMockdevIoctlData* _tmp24_;
				if (!_tmp0_) {
					glong _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(((gulong) i) < count)) {
					break;
				}
				tx = NULL;
				rx = NULL;
				_tmp2_ = data->data;
				_tmp2__length1 = data->data_len;
				transfer = &((struct spi_ioc_transfer*) _tmp2_)[i];
				_tmp3_ = transfer;
				_vala_assert (((gint) (*_tmp3_).bits_per_word) == 0, "transfer.bits_per_word == 0");
				_tmp4_ = transfer;
				_vala_assert (((gint) (*_tmp4_).tx_nbits) == 0, "transfer.tx_nbits == 0");
				_tmp5_ = transfer;
				_vala_assert (((gint) (*_tmp5_).rx_nbits) == 0, "transfer.rx_nbits == 0");
				{
					struct spi_ioc_transfer* _tmp6_;
					struct spi_ioc_transfer* _tmp12_;
					_tmp6_ = transfer;
					if ((*_tmp6_).tx_buf != ((guint64) 0)) {
						UMockdevIoctlData* _tmp7_ = NULL;
						guint8* _tmp8_;
						gint _tmp8__length1;
						struct spi_ioc_transfer* _tmp9_;
						UMockdevIoctlData* _tmp10_;
						_tmp8_ = data->data;
						_tmp8__length1 = data->data_len;
						_tmp9_ = transfer;
						_tmp10_ = umockdev_ioctl_data_resolve (data, (gsize) (((gulong) (&(*transfer).tx_buf)) - ((gulong) _tmp8_)), (gsize) (*_tmp9_).len, &_inner_error0_);
						_tmp7_ = _tmp10_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							glong _tmp11_ = -1L;
							if (_inner_error0_->domain == G_IO_ERROR) {
								goto __catch0_g_io_error;
							}
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return _tmp11_;
						}
						tx = _tmp7_;
						_g_object_unref0 (_tmp7_);
					}
					_tmp12_ = transfer;
					if ((*_tmp12_).rx_buf != ((guint64) 0)) {
						UMockdevIoctlData* _tmp13_ = NULL;
						guint8* _tmp14_;
						gint _tmp14__length1;
						struct spi_ioc_transfer* _tmp15_;
						UMockdevIoctlData* _tmp16_;
						_tmp14_ = data->data;
						_tmp14__length1 = data->data_len;
						_tmp15_ = transfer;
						_tmp16_ = umockdev_ioctl_data_resolve (data, (gsize) (((gulong) (&(*transfer).rx_buf)) - ((gulong) _tmp14_)), (gsize) (*_tmp15_).len, &_inner_error0_);
						_tmp13_ = _tmp16_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							glong _tmp17_ = -1L;
							if (_inner_error0_->domain == G_IO_ERROR) {
								goto __catch0_g_io_error;
							}
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return _tmp17_;
						}
						rx = _tmp13_;
						_g_object_unref0 (_tmp13_);
					}
				}
				goto __finally0;
				__catch0_g_io_error:
				{
					GError* e = NULL;
					GError* _tmp18_;
					const gchar* _tmp19_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp18_ = e;
					_tmp19_ = _tmp18_->message;
					g_warning ("umockdev-spi.vala:99: Error resolving IOCtl data: %s", _tmp19_);
					result = (glong) -100;
					_g_error_free0 (e);
					return result;
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					glong _tmp20_ = -1L;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp20_;
				}
				if (((gulong) i) == (count - 1)) {
					struct spi_ioc_transfer* _tmp21_;
					_tmp21_ = transfer;
					keep_cs_high = (gboolean) (*_tmp21_).cs_change;
				} else {
					struct spi_ioc_transfer* _tmp22_;
					_tmp22_ = transfer;
					keep_cs_high = !((gboolean) (*_tmp22_).cs_change);
				}
				_tmp23_ = tx;
				_tmp24_ = rx;
				res = umockdev_ioctl_spi_base_handle_read_write (self, _tmp23_, _tmp24_, keep_cs_high);
				if (res < ((glong) 0)) {
					result = res;
					return result;
				}
				transferred += res;
			}
		}
	}
	result = transferred;
	return result;
}

static glong
umockdev_ioctl_spi_base_real_handle_read_write (UMockdevIoctlSpiBase* self,
                                                UMockdevIoctlData* tx,
                                                UMockdevIoctlData* rx,
                                                gboolean keep_cs_high)
{
	glong _tmp0_ = 0L;
	g_critical ("Type `%s' does not implement abstract method `umockdev_ioctl_spi_base_handle_read_write'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

glong
umockdev_ioctl_spi_base_handle_read_write (UMockdevIoctlSpiBase* self,
                                           UMockdevIoctlData* tx,
                                           UMockdevIoctlData* rx,
                                           gboolean keep_cs_high)
{
	UMockdevIoctlSpiBaseClass* _klass_;
	g_return_val_if_fail (self != NULL, 0L);
	_klass_ = UMOCKDEV_IOCTL_SPI_BASE_GET_CLASS (self);
	if (_klass_->handle_read_write) {
		return _klass_->handle_read_write (self, tx, rx, keep_cs_high);
	}
	return -1L;
}

UMockdevIoctlSpiBase*
umockdev_ioctl_spi_base_construct (GType object_type)
{
	UMockdevIoctlSpiBase * self = NULL;
	self = (UMockdevIoctlSpiBase*) umockdev_ioctl_base_construct (object_type);
	return self;
}

static void
umockdev_ioctl_spi_base_class_init (UMockdevIoctlSpiBaseClass * klass,
                                    gpointer klass_data)
{
	umockdev_ioctl_spi_base_parent_class = g_type_class_peek_parent (klass);
	((UMockdevIoctlSpiBaseClass *) klass)->handle_read_write = (glong (*) (UMockdevIoctlSpiBase*, UMockdevIoctlData*, UMockdevIoctlData*, gboolean)) umockdev_ioctl_spi_base_real_handle_read_write;
}

static void
umockdev_ioctl_spi_base_instance_init (UMockdevIoctlSpiBase * self,
                                       gpointer klass)
{
}

static GType
umockdev_ioctl_spi_base_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UMockdevIoctlSpiBaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) umockdev_ioctl_spi_base_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UMockdevIoctlSpiBase), 0, (GInstanceInitFunc) umockdev_ioctl_spi_base_instance_init, NULL };
	GType umockdev_ioctl_spi_base_type_id;
	umockdev_ioctl_spi_base_type_id = g_type_register_static (UMOCKDEV_TYPE_IOCTL_BASE, "UMockdevIoctlSpiBase", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return umockdev_ioctl_spi_base_type_id;
}

GType
umockdev_ioctl_spi_base_get_type (void)
{
	static volatile gsize umockdev_ioctl_spi_base_type_id__once = 0;
	if (g_once_init_enter (&umockdev_ioctl_spi_base_type_id__once)) {
		GType umockdev_ioctl_spi_base_type_id;
		umockdev_ioctl_spi_base_type_id = umockdev_ioctl_spi_base_get_type_once ();
		g_once_init_leave (&umockdev_ioctl_spi_base_type_id__once, umockdev_ioctl_spi_base_type_id);
	}
	return umockdev_ioctl_spi_base_type_id__once;
}

static inline gpointer
umockdev_ioctl_spi_handler_get_instance_private (UMockdevIoctlSpiHandler* self)
{
	return G_STRUCT_MEMBER_P (self, UMockdevIoctlSpiHandler_private_offset);
}

static void
_vala_UMockdevTransferChunk_array_free (UMockdevTransferChunk * array,
                                        gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			umockdev_transfer_chunk_destroy (&array[i]);
		}
	}
	g_free (array);
}

static void
_vala_array_add25 (UMockdevTransferChunk* * array,
                   gint* length,
                   gint* size,
                   const UMockdevTransferChunk* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (UMockdevTransferChunk, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_array_add26 (UMockdevTransferChunk* * array,
                   gint* length,
                   gint* size,
                   const UMockdevTransferChunk* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (UMockdevTransferChunk, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

UMockdevIoctlSpiHandler*
umockdev_ioctl_spi_handler_construct (GType object_type,
                                      const gchar* file)
{
	UMockdevIoctlSpiHandler * self = NULL;
	gchar* val = NULL;
	gchar** lines = NULL;
	const gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint lines_length1;
	gint _lines_size_;
	UMockdevTransferChunk* chunk = NULL;
	gchar** _tmp5_;
	gint _tmp5__length1;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	self = (UMockdevIoctlSpiHandler*) umockdev_ioctl_spi_base_construct (object_type);
	{
		gchar* _tmp0_ = NULL;
		g_file_get_contents (file, &_tmp0_, NULL, &_inner_error0_);
		_g_free0 (val);
		val = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e->message;
		g_error ("umockdev-spi.vala:139: Could not read %s: %s", file, _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (val);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp2_ = val;
	_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, "\n", 0);
	lines = _tmp4_;
	lines_length1 = _vala_array_length (_tmp3_);
	_lines_size_ = lines_length1;
	chunk = NULL;
	_tmp5_ = lines;
	_tmp5__length1 = lines_length1;
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp5_;
		line_collection_length1 = _tmp5__length1;
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			const gchar* line = NULL;
			line = line_collection[line_it];
			{
				const gchar* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				gboolean _tmp9_ = FALSE;
				const gchar* _tmp10_;
				const gchar* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				const gchar* _tmp15_;
				gboolean _tmp45_ = FALSE;
				gboolean _tmp46_ = FALSE;
				UMockdevTransferChunk* _tmp47_;
				guint8* _tmp48_;
				gint _tmp48__length1;
				_tmp6_ = line;
				_tmp7_ = strlen (_tmp6_);
				_tmp8_ = _tmp7_;
				if (_tmp8_ == 0) {
					continue;
				}
				_tmp10_ = line;
				if (string_get (_tmp10_, (glong) 0) == '#') {
					_tmp9_ = TRUE;
				} else {
					const gchar* _tmp11_;
					_tmp11_ = line;
					_tmp9_ = string_get (_tmp11_, (glong) 0) == '@';
				}
				if (_tmp9_) {
					continue;
				}
				_tmp12_ = line;
				_tmp13_ = strlen (_tmp12_);
				_tmp14_ = _tmp13_;
				if (_tmp14_ < 3) {
					g_error ("umockdev-spi.vala:152: Invalid SPI transfer description");
				}
				_tmp15_ = line;
				if (string_get (_tmp15_, (glong) 0) == 'C') {
					UMockdevTransferChunk* _tmp16_;
					UMockdevTransferChunk _tmp17_ = {0};
					UMockdevTransferChunk* _tmp18_;
					gint _tmp18__length1;
					UMockdevTransferChunk* _tmp19_;
					gint _tmp19__length1;
					_tmp16_ = chunk;
					if (_tmp16_ != NULL) {
						(*chunk).cont = TRUE;
					} else {
						g_error ("umockdev-spi.vala:158: Invalid SPI transfer description, continuation " \
"without previous transfer");
					}
					memset (&_tmp17_, 0, sizeof (UMockdevTransferChunk));
					_vala_array_add25 (&self->priv->recording, &self->priv->recording_length1, &self->priv->_recording_size_, &_tmp17_);
					_tmp18_ = self->priv->recording;
					_tmp18__length1 = self->priv->recording_length1;
					_tmp19_ = self->priv->recording;
					_tmp19__length1 = self->priv->recording_length1;
					chunk = &_tmp18_[_tmp19__length1 - 1];
				} else {
					const gchar* _tmp20_;
					_tmp20_ = line;
					if (string_get (_tmp20_, (glong) 0) == 'T') {
						UMockdevTransferChunk* _tmp21_;
						UMockdevTransferChunk _tmp22_ = {0};
						UMockdevTransferChunk* _tmp23_;
						gint _tmp23__length1;
						UMockdevTransferChunk* _tmp24_;
						gint _tmp24__length1;
						_tmp21_ = chunk;
						if (_tmp21_ != NULL) {
							(*chunk).cont = FALSE;
						}
						memset (&_tmp22_, 0, sizeof (UMockdevTransferChunk));
						_vala_array_add26 (&self->priv->recording, &self->priv->recording_length1, &self->priv->_recording_size_, &_tmp22_);
						_tmp23_ = self->priv->recording;
						_tmp23__length1 = self->priv->recording_length1;
						_tmp24_ = self->priv->recording;
						_tmp24__length1 = self->priv->recording_length1;
						chunk = &_tmp23_[_tmp24__length1 - 1];
					} else {
						const gchar* _tmp25_;
						_tmp25_ = line;
						if (string_get (_tmp25_, (glong) 0) != ' ') {
							g_error ("umockdev-spi.vala:169: Invalid SPI transfer description");
						}
					}
				}
				{
					const gchar* _tmp26_;
					_tmp26_ = line;
					if (string_get (_tmp26_, (glong) 1) == 'W') {
						guint8* _tmp27_ = NULL;
						const gchar* _tmp28_;
						gchar* _tmp29_;
						gchar* _tmp30_;
						gint _tmp31_ = 0;
						guint8* _tmp32_;
						guint8* _tmp33_;
						gint _tmp33__length1;
						gint _tmp27__length1;
						gint __tmp27__size_;
						guint8* _tmp34_;
						gint _tmp34__length1;
						_tmp28_ = line;
						_tmp29_ = string_substring (_tmp28_, (glong) 3, (glong) -1);
						_tmp30_ = _tmp29_;
						_tmp32_ = umockdev_spi_decode_hex (_tmp30_, &_tmp31_, &_inner_error0_);
						_tmp33_ = _tmp32_;
						_tmp33__length1 = _tmp31_;
						_g_free0 (_tmp30_);
						_tmp27_ = _tmp33_;
						_tmp27__length1 = _tmp33__length1;
						__tmp27__size_ = _tmp27__length1;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							if (_inner_error0_->domain == G_IO_ERROR) {
								goto __catch1_g_io_error;
							}
							lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (val);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
						_tmp34_ = _tmp27_;
						_tmp34__length1 = _tmp27__length1;
						_tmp27_ = NULL;
						_tmp27__length1 = 0;
						(*chunk).tx = (g_free ((*chunk).tx), NULL);
						(*chunk).tx = _tmp34_;
						(*chunk).tx_length1 = _tmp34__length1;
						(*chunk)._tx_size_ = (*chunk).tx_length1;
						_tmp27_ = (g_free (_tmp27_), NULL);
					} else {
						const gchar* _tmp35_;
						_tmp35_ = line;
						if (string_get (_tmp35_, (glong) 1) == 'R') {
							guint8* _tmp36_ = NULL;
							const gchar* _tmp37_;
							gchar* _tmp38_;
							gchar* _tmp39_;
							gint _tmp40_ = 0;
							guint8* _tmp41_;
							guint8* _tmp42_;
							gint _tmp42__length1;
							gint _tmp36__length1;
							gint __tmp36__size_;
							guint8* _tmp43_;
							gint _tmp43__length1;
							_tmp37_ = line;
							_tmp38_ = string_substring (_tmp37_, (glong) 3, (glong) -1);
							_tmp39_ = _tmp38_;
							_tmp41_ = umockdev_spi_decode_hex (_tmp39_, &_tmp40_, &_inner_error0_);
							_tmp42_ = _tmp41_;
							_tmp42__length1 = _tmp40_;
							_g_free0 (_tmp39_);
							_tmp36_ = _tmp42_;
							_tmp36__length1 = _tmp42__length1;
							__tmp36__size_ = _tmp36__length1;
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								if (_inner_error0_->domain == G_IO_ERROR) {
									goto __catch1_g_io_error;
								}
								lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (val);
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return NULL;
							}
							_tmp43_ = _tmp36_;
							_tmp43__length1 = _tmp36__length1;
							_tmp36_ = NULL;
							_tmp36__length1 = 0;
							(*chunk).rx = (g_free ((*chunk).rx), NULL);
							(*chunk).rx = _tmp43_;
							(*chunk).rx_length1 = _tmp43__length1;
							(*chunk)._rx_size_ = (*chunk).rx_length1;
							_tmp36_ = (g_free (_tmp36_), NULL);
						} else {
							const gchar* _tmp44_;
							_tmp44_ = line;
							g_error ("umockdev-spi.vala:178: Invalid transfer type, expected R or W got %c", (gint) string_get (_tmp44_, (glong) 1));
						}
					}
				}
				goto __finally1;
				__catch1_g_io_error:
				{
					g_clear_error (&_inner_error0_);
					g_error ("umockdev-spi.vala:181: Invalid SPI transfer description, could not dec" \
"ode HEX string");
				}
				__finally1:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (val);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				_tmp47_ = chunk;
				_tmp48_ = (*_tmp47_).tx;
				_tmp48__length1 = (*_tmp47_).tx_length1;
				if (_tmp48_ != NULL) {
					UMockdevTransferChunk* _tmp49_;
					guint8* _tmp50_;
					gint _tmp50__length1;
					_tmp49_ = chunk;
					_tmp50_ = (*_tmp49_).rx;
					_tmp50__length1 = (*_tmp49_).rx_length1;
					_tmp46_ = _tmp50_ != NULL;
				} else {
					_tmp46_ = FALSE;
				}
				if (_tmp46_) {
					UMockdevTransferChunk* _tmp51_;
					guint8* _tmp52_;
					gint _tmp52__length1;
					UMockdevTransferChunk* _tmp53_;
					guint8* _tmp54_;
					gint _tmp54__length1;
					_tmp51_ = chunk;
					_tmp52_ = (*_tmp51_).tx;
					_tmp52__length1 = (*_tmp51_).tx_length1;
					_tmp53_ = chunk;
					_tmp54_ = (*_tmp53_).rx;
					_tmp54__length1 = (*_tmp53_).rx_length1;
					_tmp45_ = _tmp52__length1 != _tmp54__length1;
				} else {
					_tmp45_ = FALSE;
				}
				if (_tmp45_) {
					g_error ("umockdev-spi.vala:185: Invalid SPI transfer description, read/write le" \
"ngth need to be identical");
				}
			}
		}
	}
	self->priv->replay_chunk = (glong) 0;
	self->priv->replay_byte = (glong) 0;
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (val);
	return self;
}

UMockdevIoctlSpiHandler*
umockdev_ioctl_spi_handler_new (const gchar* file)
{
	return umockdev_ioctl_spi_handler_construct (UMOCKDEV_TYPE_IOCTL_SPI_HANDLER, file);
}

static gboolean
umockdev_ioctl_spi_handler_real_handle_ioctl (UMockdevIoctlBase* base,
                                              UMockdevIoctlClient* client)
{
	UMockdevIoctlSpiHandler * self;
	UMockdevIoctlData* data = NULL;
	gulong request = 0UL;
	gulong _tmp0_;
	gulong _tmp1_;
	gulong size = 0UL;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (UMockdevIoctlSpiHandler*) base;
	g_return_val_if_fail (client != NULL, FALSE);
	data = NULL;
	_tmp0_ = umockdev_ioctl_client_get_request (client);
	_tmp1_ = _tmp0_;
	request = _tmp1_;
	size = (request >> _IOC_SIZESHIFT) & ((1 << _IOC_SIZEBITS) - 1);
	{
		UMockdevIoctlData* _tmp2_ = NULL;
		UMockdevIoctlData* _tmp3_;
		UMockdevIoctlData* _tmp4_;
		UMockdevIoctlData* _tmp5_;
		UMockdevIoctlData* _tmp7_;
		_tmp3_ = umockdev_ioctl_client_get_arg (client);
		_tmp4_ = _tmp3_;
		_tmp5_ = umockdev_ioctl_data_resolve (_tmp4_, (gsize) 0, (gsize) size, &_inner_error0_);
		_tmp2_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp6_ = FALSE;
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			_g_object_unref0 (data);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp6_;
		}
		_tmp7_ = _tmp2_;
		_tmp2_ = NULL;
		_g_object_unref0 (data);
		data = _tmp7_;
		_g_object_unref0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("umockdev-spi.vala:200: Error resolving IOCtl data: %s", _tmp9_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (data);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp10_ = FALSE;
		_g_object_unref0 (data);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp10_;
	}
	if ((request & (~(((1 << _IOC_SIZEBITS) - 1) << _IOC_SIZESHIFT))) == ((gulong) SPI_IOC_MESSAGE (0))) {
		gulong count = 0UL;
		glong res = 0L;
		UMockdevIoctlData* _tmp11_;
		_vala_assert ((size % sizeof (struct spi_ioc_transfer)) == ((gulong) 0), "size % sizeof(Ioctl.spi_ioc_transfer) == 0");
		count = size / sizeof (struct spi_ioc_transfer);
		_tmp11_ = data;
		res = umockdev_ioctl_spi_base_iter_ioctl_vector ((UMockdevIoctlSpiBase*) self, count, _tmp11_, FALSE);
		if (res == ((glong) -100)) {
			umockdev_ioctl_client_complete (client, (glong) -100, 0);
		} else {
			if (res < ((glong) 0)) {
				umockdev_ioctl_client_complete (client, (glong) -1, -((gint) res));
			} else {
				umockdev_ioctl_client_complete (client, res, 0);
			}
		}
		result = TRUE;
		_g_object_unref0 (data);
		return result;
	} else {
		umockdev_ioctl_client_complete (client, (glong) -1, ENOTTY);
		result = TRUE;
		_g_object_unref0 (data);
		return result;
	}
}

static gboolean
umockdev_ioctl_spi_handler_real_handle_read (UMockdevIoctlBase* base,
                                             UMockdevIoctlClient* client)
{
	UMockdevIoctlSpiHandler * self;
	glong res = 0L;
	UMockdevIoctlData* _tmp0_;
	UMockdevIoctlData* _tmp1_;
	gboolean result;
	self = (UMockdevIoctlSpiHandler*) base;
	g_return_val_if_fail (client != NULL, FALSE);
	_tmp0_ = umockdev_ioctl_client_get_arg (client);
	_tmp1_ = _tmp0_;
	res = umockdev_ioctl_spi_base_handle_read_write ((UMockdevIoctlSpiBase*) self, NULL, _tmp1_, FALSE);
	if (res < ((glong) 0)) {
		umockdev_ioctl_client_complete (client, (glong) -1, -((gint) res));
	} else {
		umockdev_ioctl_client_complete (client, res, 0);
	}
	result = TRUE;
	return result;
}

static gboolean
umockdev_ioctl_spi_handler_real_handle_write (UMockdevIoctlBase* base,
                                              UMockdevIoctlClient* client)
{
	UMockdevIoctlSpiHandler * self;
	glong res = 0L;
	UMockdevIoctlData* _tmp0_;
	UMockdevIoctlData* _tmp1_;
	gboolean result;
	self = (UMockdevIoctlSpiHandler*) base;
	g_return_val_if_fail (client != NULL, FALSE);
	_tmp0_ = umockdev_ioctl_client_get_arg (client);
	_tmp1_ = _tmp0_;
	res = umockdev_ioctl_spi_base_handle_read_write ((UMockdevIoctlSpiBase*) self, _tmp1_, NULL, FALSE);
	if (res < ((glong) 0)) {
		umockdev_ioctl_client_complete (client, (glong) -1, -((gint) res));
	} else {
		umockdev_ioctl_client_complete (client, res, 0);
	}
	result = TRUE;
	return result;
}

static glong
umockdev_ioctl_spi_handler_real_handle_read_write (UMockdevIoctlSpiBase* base,
                                                   UMockdevIoctlData* tx,
                                                   UMockdevIoctlData* rx,
                                                   gboolean keep_cs_high)
{
	UMockdevIoctlSpiHandler * self;
	glong overall = 0L;
	glong offset = 0L;
	glong trans = 0L;
	glong left = 0L;
	glong len = 0L;
	glong result;
	self = (UMockdevIoctlSpiHandler*) base;
	overall = (glong) 0;
	offset = (glong) 0;
	if (tx != NULL) {
		guint8* _tmp0_;
		gint _tmp0__length1;
		_tmp0_ = tx->data;
		_tmp0__length1 = tx->data_len;
		len = (glong) _tmp0__length1;
	} else {
		guint8* _tmp1_;
		gint _tmp1__length1;
		_tmp1_ = rx->data;
		_tmp1__length1 = rx->data_len;
		len = (glong) _tmp1__length1;
	}
	while (TRUE) {
		UMockdevTransferChunk* chunk = NULL;
		UMockdevTransferChunk* _tmp2_;
		gint _tmp2__length1;
		UMockdevTransferChunk* _tmp3_;
		gint _tmp3__length1;
		UMockdevTransferChunk* _tmp4_;
		guint8* _tmp5_;
		gint _tmp5__length1;
		UMockdevTransferChunk* _tmp15_;
		guint8* _tmp16_;
		gint _tmp16__length1;
		if (!(len > ((glong) 0))) {
			break;
		}
		_tmp2_ = self->priv->recording;
		_tmp2__length1 = self->priv->recording_length1;
		if (self->priv->replay_chunk >= ((glong) _tmp2__length1)) {
			result = (glong) (-ENOENT);
			return result;
		}
		_tmp3_ = self->priv->recording;
		_tmp3__length1 = self->priv->recording_length1;
		chunk = &_tmp3_[self->priv->replay_chunk];
		left = (glong) -1;
		trans = len;
		_tmp4_ = chunk;
		_tmp5_ = (*_tmp4_).tx;
		_tmp5__length1 = (*_tmp4_).tx_length1;
		if (_tmp5_ != NULL) {
			UMockdevTransferChunk* _tmp6_;
			guint8* _tmp7_;
			gint _tmp7__length1;
			UMockdevTransferChunk* _tmp10_;
			guint8* _tmp11_;
			gint _tmp11__length1;
			guint8* _tmp12_;
			gint _tmp12__length1;
			UMockdevTransferChunk* _tmp13_;
			guint8* _tmp14_;
			gint _tmp14__length1;
			if (tx == NULL) {
				result = (glong) (-ENOMSG);
				return result;
			}
			_tmp6_ = chunk;
			_tmp7_ = (*_tmp6_).tx;
			_tmp7__length1 = (*_tmp6_).tx_length1;
			if (trans > (_tmp7__length1 - self->priv->replay_byte)) {
				UMockdevTransferChunk* _tmp8_;
				guint8* _tmp9_;
				gint _tmp9__length1;
				_tmp8_ = chunk;
				_tmp9_ = (*_tmp8_).tx;
				_tmp9__length1 = (*_tmp8_).tx_length1;
				trans = _tmp9__length1 - self->priv->replay_byte;
			}
			_tmp10_ = chunk;
			_tmp11_ = (*_tmp10_).tx;
			_tmp11__length1 = (*_tmp10_).tx_length1;
			left = (_tmp11__length1 - self->priv->replay_byte) - trans;
			_tmp12_ = tx->data;
			_tmp12__length1 = tx->data_len;
			_tmp13_ = chunk;
			_tmp14_ = (*_tmp13_).tx;
			_tmp14__length1 = (*_tmp13_).tx_length1;
			if (memcmp (&_tmp12_[offset], &_tmp14_[self->priv->replay_byte], (gsize) trans) != 0) {
				result = (glong) (-ENOMSG);
				return result;
			}
		}
		_tmp15_ = chunk;
		_tmp16_ = (*_tmp15_).rx;
		_tmp16__length1 = (*_tmp15_).rx_length1;
		if (_tmp16_ != NULL) {
			UMockdevTransferChunk* _tmp17_;
			guint8* _tmp18_;
			gint _tmp18__length1;
			UMockdevTransferChunk* _tmp21_;
			guint8* _tmp22_;
			gint _tmp22__length1;
			guint8* _tmp23_;
			gint _tmp23__length1;
			UMockdevTransferChunk* _tmp24_;
			guint8* _tmp25_;
			gint _tmp25__length1;
			if (rx == NULL) {
				result = (glong) (-ENOMSG);
				return result;
			}
			_tmp17_ = chunk;
			_tmp18_ = (*_tmp17_).rx;
			_tmp18__length1 = (*_tmp17_).rx_length1;
			if (trans > (_tmp18__length1 - self->priv->replay_byte)) {
				UMockdevTransferChunk* _tmp19_;
				guint8* _tmp20_;
				gint _tmp20__length1;
				_tmp19_ = chunk;
				_tmp20_ = (*_tmp19_).rx;
				_tmp20__length1 = (*_tmp19_).rx_length1;
				trans = _tmp20__length1 - self->priv->replay_byte;
			}
			_tmp21_ = chunk;
			_tmp22_ = (*_tmp21_).rx;
			_tmp22__length1 = (*_tmp21_).rx_length1;
			left = (_tmp22__length1 - self->priv->replay_byte) - trans;
			_tmp23_ = rx->data;
			_tmp23__length1 = rx->data_len;
			_tmp24_ = chunk;
			_tmp25_ = (*_tmp24_).rx;
			_tmp25__length1 = (*_tmp24_).rx_length1;
			memcpy (&_tmp23_[offset], &_tmp25_[self->priv->replay_byte], (gsize) trans);
		}
		_vala_assert (left >= ((glong) 0), "left >= 0");
		if (left == ((glong) 0)) {
			self->priv->replay_chunk = self->priv->replay_chunk + 1;
			self->priv->replay_byte = (glong) 0;
		} else {
			self->priv->replay_byte = self->priv->replay_byte + trans;
		}
		offset += trans;
		len -= trans;
		overall += trans;
	}
	result = overall;
	return result;
}

static void
umockdev_ioctl_spi_handler_class_init (UMockdevIoctlSpiHandlerClass * klass,
                                       gpointer klass_data)
{
	umockdev_ioctl_spi_handler_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UMockdevIoctlSpiHandler_private_offset);
	((UMockdevIoctlBaseClass *) klass)->handle_ioctl = (gboolean (*) (UMockdevIoctlBase*, UMockdevIoctlClient*)) umockdev_ioctl_spi_handler_real_handle_ioctl;
	((UMockdevIoctlBaseClass *) klass)->handle_read = (gboolean (*) (UMockdevIoctlBase*, UMockdevIoctlClient*)) umockdev_ioctl_spi_handler_real_handle_read;
	((UMockdevIoctlBaseClass *) klass)->handle_write = (gboolean (*) (UMockdevIoctlBase*, UMockdevIoctlClient*)) umockdev_ioctl_spi_handler_real_handle_write;
	((UMockdevIoctlSpiBaseClass *) klass)->handle_read_write = (glong (*) (UMockdevIoctlSpiBase*, UMockdevIoctlData*, UMockdevIoctlData*, gboolean)) umockdev_ioctl_spi_handler_real_handle_read_write;
	G_OBJECT_CLASS (klass)->finalize = umockdev_ioctl_spi_handler_finalize;
}

static void
umockdev_ioctl_spi_handler_instance_init (UMockdevIoctlSpiHandler * self,
                                          gpointer klass)
{
	self->priv = umockdev_ioctl_spi_handler_get_instance_private (self);
}

static void
umockdev_ioctl_spi_handler_finalize (GObject * obj)
{
	UMockdevIoctlSpiHandler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, UMOCKDEV_TYPE_IOCTL_SPI_HANDLER, UMockdevIoctlSpiHandler);
	self->priv->recording = (_vala_UMockdevTransferChunk_array_free (self->priv->recording, self->priv->recording_length1), NULL);
	G_OBJECT_CLASS (umockdev_ioctl_spi_handler_parent_class)->finalize (obj);
}

static GType
umockdev_ioctl_spi_handler_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UMockdevIoctlSpiHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) umockdev_ioctl_spi_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UMockdevIoctlSpiHandler), 0, (GInstanceInitFunc) umockdev_ioctl_spi_handler_instance_init, NULL };
	GType umockdev_ioctl_spi_handler_type_id;
	umockdev_ioctl_spi_handler_type_id = g_type_register_static (UMOCKDEV_TYPE_IOCTL_SPI_BASE, "UMockdevIoctlSpiHandler", &g_define_type_info, 0);
	UMockdevIoctlSpiHandler_private_offset = g_type_add_instance_private (umockdev_ioctl_spi_handler_type_id, sizeof (UMockdevIoctlSpiHandlerPrivate));
	return umockdev_ioctl_spi_handler_type_id;
}

GType
umockdev_ioctl_spi_handler_get_type (void)
{
	static volatile gsize umockdev_ioctl_spi_handler_type_id__once = 0;
	if (g_once_init_enter (&umockdev_ioctl_spi_handler_type_id__once)) {
		GType umockdev_ioctl_spi_handler_type_id;
		umockdev_ioctl_spi_handler_type_id = umockdev_ioctl_spi_handler_get_type_once ();
		g_once_init_leave (&umockdev_ioctl_spi_handler_type_id__once, umockdev_ioctl_spi_handler_type_id);
	}
	return umockdev_ioctl_spi_handler_type_id__once;
}

static inline gpointer
umockdev_ioctl_spi_recorder_get_instance_private (UMockdevIoctlSpiRecorder* self)
{
	return G_STRUCT_MEMBER_P (self, UMockdevIoctlSpiRecorder_private_offset);
}

UMockdevIoctlSpiRecorder*
umockdev_ioctl_spi_recorder_construct (GType object_type,
                                       const gchar* device,
                                       const gchar* file)
{
	UMockdevIoctlSpiRecorder * self = NULL;
	FILE* _tmp0_;
	FILE* _tmp1_;
	g_return_val_if_fail (device != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	self = (UMockdevIoctlSpiRecorder*) umockdev_ioctl_spi_base_construct (object_type);
	self->priv->cs_is_high = FALSE;
	_tmp0_ = fopen (file, "w");
	_fclose0 (self->priv->log);
	self->priv->log = _tmp0_;
	_tmp1_ = self->priv->log;
	fprintf (_tmp1_, "@DEV %s (SPI)\n", device);
	return self;
}

UMockdevIoctlSpiRecorder*
umockdev_ioctl_spi_recorder_new (const gchar* device,
                                 const gchar* file)
{
	return umockdev_ioctl_spi_recorder_construct (UMOCKDEV_TYPE_IOCTL_SPI_RECORDER, device, file);
}

static gboolean
umockdev_ioctl_spi_recorder_real_handle_ioctl (UMockdevIoctlBase* base,
                                               UMockdevIoctlClient* client)
{
	UMockdevIoctlSpiRecorder * self;
	UMockdevIoctlData* data = NULL;
	gulong request = 0UL;
	gulong _tmp0_;
	gulong _tmp1_;
	gulong size = 0UL;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (UMockdevIoctlSpiRecorder*) base;
	g_return_val_if_fail (client != NULL, FALSE);
	data = NULL;
	_tmp0_ = umockdev_ioctl_client_get_request (client);
	_tmp1_ = _tmp0_;
	request = _tmp1_;
	size = (request >> _IOC_SIZESHIFT) & ((1 << _IOC_SIZEBITS) - 1);
	{
		UMockdevIoctlData* _tmp2_ = NULL;
		UMockdevIoctlData* _tmp3_;
		UMockdevIoctlData* _tmp4_;
		UMockdevIoctlData* _tmp5_;
		UMockdevIoctlData* _tmp7_;
		_tmp3_ = umockdev_ioctl_client_get_arg (client);
		_tmp4_ = _tmp3_;
		_tmp5_ = umockdev_ioctl_data_resolve (_tmp4_, (gsize) 0, (gsize) size, &_inner_error0_);
		_tmp2_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp6_ = FALSE;
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			_g_object_unref0 (data);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp6_;
		}
		_tmp7_ = _tmp2_;
		_tmp2_ = NULL;
		_g_object_unref0 (data);
		data = _tmp7_;
		_g_object_unref0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("umockdev-spi.vala:348: Error resolving IOCtl data: %s", _tmp9_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (data);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp10_ = FALSE;
		_g_object_unref0 (data);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp10_;
	}
	if ((request & (~(((1 << _IOC_SIZEBITS) - 1) << _IOC_SIZESHIFT))) == ((gulong) SPI_IOC_MESSAGE (0))) {
		gint res = 0;
		gint my_errno = 0;
		gulong count = 0UL;
		UMockdevIoctlData* _tmp16_;
		_vala_assert ((size % sizeof (struct spi_ioc_transfer)) == ((gulong) 0), "size % sizeof(Ioctl.spi_ioc_transfer) == 0");
		count = size / sizeof (struct spi_ioc_transfer);
		{
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			gint _tmp13_;
			_tmp13_ = umockdev_ioctl_client_execute (client, &_tmp12_, &_inner_error0_);
			my_errno = _tmp12_;
			_tmp11_ = _tmp13_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp14_ = FALSE;
				if (_inner_error0_->domain == G_IO_ERROR) {
					goto __catch1_g_io_error;
				}
				_g_object_unref0 (data);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp14_;
			}
			res = _tmp11_;
		}
		goto __finally1;
		__catch1_g_io_error:
		{
			g_clear_error (&_inner_error0_);
			result = FALSE;
			_g_object_unref0 (data);
			return result;
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp15_ = FALSE;
			_g_object_unref0 (data);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp15_;
		}
		if (res < 0) {
			umockdev_ioctl_client_complete (client, (glong) -1, my_errno);
			result = TRUE;
			_g_object_unref0 (data);
			return result;
		}
		umockdev_ioctl_client_complete (client, (glong) res, 0);
		_tmp16_ = data;
		umockdev_ioctl_spi_base_iter_ioctl_vector ((UMockdevIoctlSpiBase*) self, count, _tmp16_, TRUE);
		result = TRUE;
		_g_object_unref0 (data);
		return result;
	} else {
		umockdev_ioctl_client_complete (client, (glong) -1, ENOTTY);
		result = TRUE;
		_g_object_unref0 (data);
		return result;
	}
}

static gboolean
umockdev_ioctl_spi_recorder_real_handle_read (UMockdevIoctlBase* base,
                                              UMockdevIoctlClient* client)
{
	UMockdevIoctlSpiRecorder * self;
	gint res = 0;
	gint my_errno = 0;
	UMockdevIoctlData* _tmp5_;
	UMockdevIoctlData* _tmp6_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (UMockdevIoctlSpiRecorder*) base;
	g_return_val_if_fail (client != NULL, FALSE);
	{
		gint _tmp0_ = 0;
		gint _tmp1_ = 0;
		gint _tmp2_;
		_tmp2_ = umockdev_ioctl_client_execute (client, &_tmp1_, &_inner_error0_);
		my_errno = _tmp1_;
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp3_ = FALSE;
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp3_;
		}
		res = _tmp0_;
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		g_clear_error (&_inner_error0_);
		result = FALSE;
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp4_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
	if (res < 0) {
		umockdev_ioctl_client_complete (client, (glong) -1, my_errno);
		result = TRUE;
		return result;
	}
	umockdev_ioctl_client_complete (client, (glong) res, 0);
	_tmp5_ = umockdev_ioctl_client_get_arg (client);
	_tmp6_ = _tmp5_;
	umockdev_ioctl_spi_base_handle_read_write ((UMockdevIoctlSpiBase*) self, NULL, _tmp6_, FALSE);
	result = TRUE;
	return result;
}

static gboolean
umockdev_ioctl_spi_recorder_real_handle_write (UMockdevIoctlBase* base,
                                               UMockdevIoctlClient* client)
{
	UMockdevIoctlSpiRecorder * self;
	gint res = 0;
	gint my_errno = 0;
	UMockdevIoctlData* _tmp5_;
	UMockdevIoctlData* _tmp6_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (UMockdevIoctlSpiRecorder*) base;
	g_return_val_if_fail (client != NULL, FALSE);
	{
		gint _tmp0_ = 0;
		gint _tmp1_ = 0;
		gint _tmp2_;
		_tmp2_ = umockdev_ioctl_client_execute (client, &_tmp1_, &_inner_error0_);
		my_errno = _tmp1_;
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp3_ = FALSE;
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp3_;
		}
		res = _tmp0_;
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		g_clear_error (&_inner_error0_);
		result = FALSE;
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp4_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
	if (res < 0) {
		umockdev_ioctl_client_complete (client, (glong) -1, my_errno);
		result = TRUE;
		return result;
	}
	umockdev_ioctl_client_complete (client, (glong) res, 0);
	_tmp5_ = umockdev_ioctl_client_get_arg (client);
	_tmp6_ = _tmp5_;
	umockdev_ioctl_spi_base_handle_read_write ((UMockdevIoctlSpiBase*) self, _tmp6_, NULL, FALSE);
	result = TRUE;
	return result;
}

static void
umockdev_ioctl_spi_recorder_write_hex (UMockdevIoctlSpiRecorder* self,
                                       guint8* buf,
                                       gint buf_length1)
{
	g_return_if_fail (self != NULL);
	{
		guint8* c_collection = NULL;
		gint c_collection_length1 = 0;
		gint _c_collection_size_ = 0;
		gint c_it = 0;
		c_collection = buf;
		c_collection_length1 = buf_length1;
		for (c_it = 0; c_it < c_collection_length1; c_it = c_it + 1) {
			guint8 c = 0U;
			c = c_collection[c_it];
			{
				FILE* _tmp0_;
				_tmp0_ = self->priv->log;
				fprintf (_tmp0_, "%02x", (guint) c);
			}
		}
	}
}

static glong
umockdev_ioctl_spi_recorder_real_handle_read_write (UMockdevIoctlSpiBase* base,
                                                    UMockdevIoctlData* tx,
                                                    UMockdevIoctlData* rx,
                                                    gboolean keep_cs_high)
{
	UMockdevIoctlSpiRecorder * self;
	gboolean indent = FALSE;
	glong result;
	self = (UMockdevIoctlSpiRecorder*) base;
	indent = FALSE;
	if (self->priv->cs_is_high) {
		FILE* _tmp0_;
		_tmp0_ = self->priv->log;
		fprintf (_tmp0_, "C");
	} else {
		FILE* _tmp1_;
		_tmp1_ = self->priv->log;
		fprintf (_tmp1_, "T");
	}
	if (tx != NULL) {
		FILE* _tmp2_;
		guint8* _tmp3_;
		gint _tmp3__length1;
		FILE* _tmp4_;
		_tmp2_ = self->priv->log;
		fprintf (_tmp2_, "W ");
		_tmp3_ = tx->data;
		_tmp3__length1 = tx->data_len;
		umockdev_ioctl_spi_recorder_write_hex (self, _tmp3_, (gint) _tmp3__length1);
		_tmp4_ = self->priv->log;
		fprintf (_tmp4_, "\n");
		indent = TRUE;
	}
	if (rx != NULL) {
		FILE* _tmp6_;
		guint8* _tmp7_;
		gint _tmp7__length1;
		FILE* _tmp8_;
		if (indent) {
			FILE* _tmp5_;
			_tmp5_ = self->priv->log;
			fprintf (_tmp5_, " ");
		}
		_tmp6_ = self->priv->log;
		fprintf (_tmp6_, "R ");
		_tmp7_ = rx->data;
		_tmp7__length1 = rx->data_len;
		umockdev_ioctl_spi_recorder_write_hex (self, _tmp7_, (gint) _tmp7__length1);
		_tmp8_ = self->priv->log;
		fprintf (_tmp8_, "\n");
	}
	self->priv->cs_is_high = keep_cs_high;
	result = (glong) 0;
	return result;
}

static void
umockdev_ioctl_spi_recorder_class_init (UMockdevIoctlSpiRecorderClass * klass,
                                        gpointer klass_data)
{
	umockdev_ioctl_spi_recorder_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UMockdevIoctlSpiRecorder_private_offset);
	((UMockdevIoctlBaseClass *) klass)->handle_ioctl = (gboolean (*) (UMockdevIoctlBase*, UMockdevIoctlClient*)) umockdev_ioctl_spi_recorder_real_handle_ioctl;
	((UMockdevIoctlBaseClass *) klass)->handle_read = (gboolean (*) (UMockdevIoctlBase*, UMockdevIoctlClient*)) umockdev_ioctl_spi_recorder_real_handle_read;
	((UMockdevIoctlBaseClass *) klass)->handle_write = (gboolean (*) (UMockdevIoctlBase*, UMockdevIoctlClient*)) umockdev_ioctl_spi_recorder_real_handle_write;
	((UMockdevIoctlSpiBaseClass *) klass)->handle_read_write = (glong (*) (UMockdevIoctlSpiBase*, UMockdevIoctlData*, UMockdevIoctlData*, gboolean)) umockdev_ioctl_spi_recorder_real_handle_read_write;
	G_OBJECT_CLASS (klass)->finalize = umockdev_ioctl_spi_recorder_finalize;
}

static void
umockdev_ioctl_spi_recorder_instance_init (UMockdevIoctlSpiRecorder * self,
                                           gpointer klass)
{
	self->priv = umockdev_ioctl_spi_recorder_get_instance_private (self);
}

static void
umockdev_ioctl_spi_recorder_finalize (GObject * obj)
{
	UMockdevIoctlSpiRecorder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, UMOCKDEV_TYPE_IOCTL_SPI_RECORDER, UMockdevIoctlSpiRecorder);
	_fclose0 (self->priv->log);
	G_OBJECT_CLASS (umockdev_ioctl_spi_recorder_parent_class)->finalize (obj);
}

static GType
umockdev_ioctl_spi_recorder_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UMockdevIoctlSpiRecorderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) umockdev_ioctl_spi_recorder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UMockdevIoctlSpiRecorder), 0, (GInstanceInitFunc) umockdev_ioctl_spi_recorder_instance_init, NULL };
	GType umockdev_ioctl_spi_recorder_type_id;
	umockdev_ioctl_spi_recorder_type_id = g_type_register_static (UMOCKDEV_TYPE_IOCTL_SPI_BASE, "UMockdevIoctlSpiRecorder", &g_define_type_info, 0);
	UMockdevIoctlSpiRecorder_private_offset = g_type_add_instance_private (umockdev_ioctl_spi_recorder_type_id, sizeof (UMockdevIoctlSpiRecorderPrivate));
	return umockdev_ioctl_spi_recorder_type_id;
}

GType
umockdev_ioctl_spi_recorder_get_type (void)
{
	static volatile gsize umockdev_ioctl_spi_recorder_type_id__once = 0;
	if (g_once_init_enter (&umockdev_ioctl_spi_recorder_type_id__once)) {
		GType umockdev_ioctl_spi_recorder_type_id;
		umockdev_ioctl_spi_recorder_type_id = umockdev_ioctl_spi_recorder_get_type_once ();
		g_once_init_leave (&umockdev_ioctl_spi_recorder_type_id__once, umockdev_ioctl_spi_recorder_type_id);
	}
	return umockdev_ioctl_spi_recorder_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

