/*
 * NB:  This file is machine generated, DO NOT EDIT!
 *
 * Edit builtin.vcl instead and run make
 *
 */
#include "config.h"
#include "mgt/mgt.h"

const char * const builtin_vcl =
 "#-\n"
 "# Copyright (c) 2006 Verdens Gang AS\n"
 "# Copyright (c) 2006-2015 Varnish Software AS\n"
 "# All rights reserved.\n"
 "#\n"
 "# Author: Poul-Henning Kamp <phk@phk.freebsd.dk>\n"
 "#\n"
 "# SPDX-License-Identifier: BSD-2-Clause\n"
 "#\n"
 "# Redistribution and use in source and binary forms, with or without\n"
 "# modification, are permitted provided that the following conditions\n"
 "# are met:\n"
 "# 1. Redistributions of source code must retain the above copyright\n"
 "#    notice, this list of conditions and the following disclaimer.\n"
 "# 2. Redistributions in binary form must reproduce the above copyright\n"
 "#    notice, this list of conditions and the following disclaimer in the\n"
 "#    documentation and/or other materials provided with the distribution.\n"
 "#\n"
 "# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND\n"
 "# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE\n"
 "# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE\n"
 "# ARE DISCLAIMED.  IN NO EVENT SHALL AUTHOR OR CONTRIBUTORS BE LIABLE\n"
 "# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL\n"
 "# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS\n"
 "# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)\n"
 "# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT\n"
 "# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY\n"
 "# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF\n"
 "# SUCH DAMAGE.\n"
 "#\n"
 "# This is the builtin VCL code\n"
 "\n"
 "vcl 4.0;\n"
 "\n"
 "#######################################################################\n"
 "# Client side\n"
 "\n"
 "sub vcl_recv {\n"
 "	call vcl_builtin_recv;\n"
 "	return (hash);\n"
 "}\n"
 "\n"
 "sub vcl_builtin_recv {\n"
 "	call vcl_req_host;\n"
 "	call vcl_req_method;\n"
 "	call vcl_req_authorization;\n"
 "	call vcl_req_cookie;\n"
 "}\n"
 "\n"
 "sub vcl_req_host {\n"
 "	if (req.http.host ~ \"[[:upper:]]\") {\n"
 "		set req.http.host = req.http.host.lower();\n"
 "	}\n"
 "	if (!req.http.host &&\n"
 "	    req.esi_level == 0 &&\n"
 "	    req.proto == \"HTTP/1.1\") {\n"
 "		# In HTTP/1.1, Host is required.\n"
 "		return (synth(400));\n"
 "	}\n"
 "}\n"
 "\n"
 "sub vcl_req_method {\n"
 "	if (req.method != \"GET\" &&\n"
 "	    req.method != \"HEAD\" &&\n"
 "	    req.method != \"PUT\" &&\n"
 "	    req.method != \"POST\" &&\n"
 "	    req.method != \"TRACE\" &&\n"
 "	    req.method != \"OPTIONS\" &&\n"
 "	    req.method != \"DELETE\" &&\n"
 "	    req.method != \"PATCH\") {\n"
 "		# Non-RFC2616 or CONNECT which is weird.\n"
 "		set req.http.Connection = \"close\";\n"
 "		return (synth(501));\n"
 "	}\n"
 "	if (req.method != \"GET\" && req.method != \"HEAD\") {\n"
 "		# We only deal with GET and HEAD by default.\n"
 "		return (pass);\n"
 "	}\n"
 "}\n"
 "\n"
 "sub vcl_req_authorization {\n"
 "	if (req.http.Authorization) {\n"
 "		# Not cacheable by default.\n"
 "		return (pass);\n"
 "	}\n"
 "}\n"
 "\n"
 "sub vcl_req_cookie {\n"
 "	if (req.http.Cookie) {\n"
 "		# Risky to cache by default.\n"
 "		return (pass);\n"
 "	}\n"
 "}\n"
 "\n"
 "sub vcl_pipe {\n"
 "	call vcl_builtin_pipe;\n"
 "	# By default \"Connection: close\" is set on all piped requests, to stop\n"
 "	# connection reuse from sending future requests directly to the\n"
 "	# (potentially) wrong backend. If you do want this to happen, you can\n"
 "	# undo it here:\n"
 "	# unset bereq.http.connection;\n"
 "	return (pipe);\n"
 "}\n"
 "\n"
 "sub vcl_builtin_pipe {\n"
 "}\n"
 "\n"
 "sub vcl_pass {\n"
 "	call vcl_builtin_pass;\n"
 "	return (fetch);\n"
 "}\n"
 "\n"
 "sub vcl_builtin_pass {\n"
 "}\n"
 "\n"
 "sub vcl_hash {\n"
 "	call vcl_builtin_hash;\n"
 "	return (lookup);\n"
 "}\n"
 "\n"
 "sub vcl_builtin_hash {\n"
 "	hash_data(req.url);\n"
 "	if (req.http.host) {\n"
 "		hash_data(req.http.host);\n"
 "	} else {\n"
 "		hash_data(server.ip);\n"
 "	}\n"
 "}\n"
 "\n"
 "sub vcl_purge {\n"
 "	call vcl_builtin_purge;\n"
 "	return (synth(200, \"Purged\"));\n"
 "}\n"
 "\n"
 "sub vcl_builtin_purge {\n"
 "}\n"
 "\n"
 "sub vcl_hit {\n"
 "	call vcl_builtin_hit;\n"
 "	return (deliver);\n"
 "}\n"
 "\n"
 "sub vcl_builtin_hit {\n"
 "}\n"
 "\n"
 "sub vcl_miss {\n"
 "	call vcl_builtin_miss;\n"
 "	return (fetch);\n"
 "}\n"
 "\n"
 "sub vcl_builtin_miss {\n"
 "}\n"
 "\n"
 "sub vcl_deliver {\n"
 "	call vcl_builtin_deliver;\n"
 "	return (deliver);\n"
 "}\n"
 "\n"
 "sub vcl_builtin_deliver {\n"
 "}\n"
 "\n"
 "#\n"
 "# We can come here \"invisibly\" with the following errors: 500 & 503\n"
 "#\n"
 "sub vcl_synth {\n"
 "	call vcl_builtin_synth;\n"
 "	return (deliver);\n"
 "}\n"
 "\n"
 "sub vcl_builtin_synth {\n"
 "	set resp.http.Content-Type = \"text/html; charset=utf-8\";\n"
 "	set resp.http.Retry-After = \"5\";\n"
 "	set resp.body = {\"<!DOCTYPE html>\n"
 "<html>\n"
 "  <head>\n"
 "    <title>\"} + resp.status + \" \" + resp.reason + {\"</title>\n"
 "  </head>\n"
 "  <body>\n"
 "    <h1>Error \"} + resp.status + \" \" + resp.reason + {\"</h1>\n"
 "    <p>\"} + resp.reason + {\"</p>\n"
 "    <h3>Guru Meditation:</h3>\n"
 "    <p>XID: \"} + req.xid + {\"</p>\n"
 "    <hr>\n"
 "    <p>Varnish cache server</p>\n"
 "  </body>\n"
 "</html>\n"
 "\"};\n"
 "}\n"
 "\n"
 "#######################################################################\n"
 "# Backend Fetch\n"
 "\n"
 "sub vcl_backend_fetch {\n"
 "	call vcl_builtin_backend_fetch;\n"
 "	return (fetch);\n"
 "}\n"
 "\n"
 "sub vcl_builtin_backend_fetch {\n"
 "	if (bereq.method == \"GET\") {\n"
 "		unset bereq.body;\n"
 "	}\n"
 "}\n"
 "\n"
 "sub vcl_backend_refresh {\n"
 "	call vcl_builtin_backend_refresh;\n"
 "	return (merge);\n"
 "}\n"
 "\n"
 "sub vcl_builtin_backend_refresh {\n"
 "	call vcl_refresh_valid;\n"
 "	call vcl_refresh_conditions;\n"
 "	call vcl_refresh_status;\n"
 "}\n"
 "\n"
 "# Check that the stale object was not invalidated under our feet\n"
 "sub vcl_refresh_valid {\n"
 "	if (!obj_stale.is_valid) {\n"
 "		return (error(503, \"Invalid object for refresh\"));\n"
 "	}\n"
 "}\n"
 "\n"
 "# Only allow revalidation if we asked for it\n"
 "sub vcl_refresh_conditions {\n"
 "	if (!bereq.http.if-modified-since &&\n"
 "	    !bereq.http.if-none-match) {\n"
 "		return (error(503, \"Unexpected 304\"));\n"
 "	}\n"
 "}\n"
 "\n"
 "# We currently only revalidate 200 responses\n"
 "sub vcl_refresh_status {\n"
 "	if (obj_stale.status != 200) {\n"
 "		return (error(503, \"Invalid object for refresh\"));\n"
 "	}\n"
 "}\n"
 "\n"
 "sub vcl_backend_response {\n"
 "	call vcl_builtin_backend_response;\n"
 "	return (deliver);\n"
 "}\n"
 "\n"
 "sub vcl_builtin_backend_response {\n"
 "	call vcl_beresp_range;\n"
 "	if (bereq.uncacheable) {\n"
 "		return (deliver);\n"
 "	}\n"
 "	call vcl_beresp_stale;\n"
 "	call vcl_beresp_cookie;\n"
 "	call vcl_beresp_control;\n"
 "	call vcl_beresp_vary;\n"
 "}\n"
 "\n"
 "sub vcl_beresp_stale {\n"
 "	if (beresp.ttl <= 0s) {\n"
 "		call vcl_beresp_hitmiss;\n"
 "	}\n"
 "}\n"
 "\n"
 "sub vcl_beresp_cookie {\n"
 "	if (beresp.http.Set-Cookie) {\n"
 "		call vcl_beresp_hitmiss;\n"
 "	}\n"
 "}\n"
 "\n"
 "sub vcl_beresp_control {\n"
 "	if (beresp.http.Surrogate-control ~ \"(?i)no-store\" ||\n"
 "	    (!beresp.http.Surrogate-Control &&\n"
 "	      beresp.http.Cache-Control ~ \"(?i:no-cache|no-store|private)\")) {\n"
 "		call vcl_beresp_hitmiss;\n"
 "	}\n"
 "}\n"
 "\n"
 "sub vcl_beresp_vary {\n"
 "	if (beresp.http.Vary == \"*\") {\n"
 "		call vcl_beresp_hitmiss;\n"
 "	}\n"
 "}\n"
 "\n"
 "sub vcl_beresp_range {\n"
 "	if (beresp.status != 206 && beresp.status != 416) {\n"
 "		# Content-Range has no meaning for these status codes\n"
 "		# Ref: https://www.rfc-editor.org/rfc/rfc9110.html#section-14.4\n"
 "		unset beresp.http.Content-Range;\n"
 "	}\n"
 "}\n"
 "\n"
 "sub vcl_beresp_hitmiss {\n"
 "	set beresp.ttl = param.uncacheable_ttl;\n"
 "	set beresp.uncacheable = true;\n"
 "	return (deliver);\n"
 "}\n"
 "\n"
 "sub vcl_backend_error {\n"
 "	call vcl_builtin_backend_error;\n"
 "	return (deliver);\n"
 "}\n"
 "\n"
 "sub vcl_builtin_backend_error {\n"
 "	set beresp.http.Content-Type = \"text/html; charset=utf-8\";\n"
 "	set beresp.http.Retry-After = \"5\";\n"
 "	set beresp.body = {\"<!DOCTYPE html>\n"
 "<html>\n"
 "  <head>\n"
 "    <title>\"} + beresp.status + \" \" + beresp.reason + {\"</title>\n"
 "  </head>\n"
 "  <body>\n"
 "    <h1>Error \"} + beresp.status + \" \" + beresp.reason + {\"</h1>\n"
 "    <p>\"} + beresp.reason + {\"</p>\n"
 "    <h3>Guru Meditation:</h3>\n"
 "    <p>XID: \"} + bereq.xid + {\"</p>\n"
 "    <hr>\n"
 "    <p>Varnish cache server</p>\n"
 "  </body>\n"
 "</html>\n"
 "\"};\n"
 "}\n"
 "\n"
 "#######################################################################\n"
 "# Housekeeping\n"
 "\n"
 "sub vcl_init {\n"
 "	return (ok);\n"
 "}\n"
 "\n"
 "sub vcl_fini {\n"
 "	return (ok);\n"
 "}\n"
;
