package kms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeApplicationAccessPoint invokes the kms.DescribeApplicationAccessPoint API synchronously
func (client *Client) DescribeApplicationAccessPoint(request *DescribeApplicationAccessPointRequest) (response *DescribeApplicationAccessPointResponse, err error) {
	response = CreateDescribeApplicationAccessPointResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeApplicationAccessPointWithChan invokes the kms.DescribeApplicationAccessPoint API asynchronously
func (client *Client) DescribeApplicationAccessPointWithChan(request *DescribeApplicationAccessPointRequest) (<-chan *DescribeApplicationAccessPointResponse, <-chan error) {
	responseChan := make(chan *DescribeApplicationAccessPointResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeApplicationAccessPoint(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeApplicationAccessPointWithCallback invokes the kms.DescribeApplicationAccessPoint API asynchronously
func (client *Client) DescribeApplicationAccessPointWithCallback(request *DescribeApplicationAccessPointRequest, callback func(response *DescribeApplicationAccessPointResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeApplicationAccessPointResponse
		var err error
		defer close(result)
		response, err = client.DescribeApplicationAccessPoint(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeApplicationAccessPointRequest is the request struct for api DescribeApplicationAccessPoint
type DescribeApplicationAccessPointRequest struct {
	*requests.RpcRequest
	Name string `position:"Query" name:"Name"`
}

// DescribeApplicationAccessPointResponse is the response struct for api DescribeApplicationAccessPoint
type DescribeApplicationAccessPointResponse struct {
	*responses.BaseResponse
	RequestId            string `json:"RequestId" xml:"RequestId"`
	Arn                  string `json:"Arn" xml:"Arn"`
	Name                 string `json:"Name" xml:"Name"`
	Description          string `json:"Description" xml:"Description"`
	AuthenticationMethod string `json:"AuthenticationMethod" xml:"AuthenticationMethod"`
	Policies             string `json:"Policies" xml:"Policies"`
}

// CreateDescribeApplicationAccessPointRequest creates a request to invoke DescribeApplicationAccessPoint API
func CreateDescribeApplicationAccessPointRequest() (request *DescribeApplicationAccessPointRequest) {
	request = &DescribeApplicationAccessPointRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Kms", "2016-01-20", "DescribeApplicationAccessPoint", "kms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeApplicationAccessPointResponse creates a response to parse from DescribeApplicationAccessPoint response
func CreateDescribeApplicationAccessPointResponse() (response *DescribeApplicationAccessPointResponse) {
	response = &DescribeApplicationAccessPointResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
