// This file is generated by "./lib/proto/generate"

package proto

/*

CSS

This domain exposes CSS read/write operations. All CSS objects (stylesheets, rules, and styles)
have an associated `id` used in subsequent operations on the related object. Each object type has
a specific `id` structure, and those are not interchangeable between objects of different kinds.
CSS objects can be loaded using the `get*ForNode()` calls (which accept a DOM node id). A client
can also keep track of stylesheets via the `styleSheetAdded`/`styleSheetRemoved` events and
subsequently load the required stylesheet contents using the `getStyleSheet[Text]()` methods.

*/

// CSSStyleSheetID ...
type CSSStyleSheetID string

// CSSStyleSheetOrigin Stylesheet type: "injected" for stylesheets injected via extension, "user-agent" for user-agent
// stylesheets, "inspector" for stylesheets created by the inspector (i.e. those holding the "via
// inspector" rules), "regular" for regular stylesheets.
type CSSStyleSheetOrigin string

const (
	// CSSStyleSheetOriginInjected enum const.
	CSSStyleSheetOriginInjected CSSStyleSheetOrigin = "injected"

	// CSSStyleSheetOriginUserAgent enum const.
	CSSStyleSheetOriginUserAgent CSSStyleSheetOrigin = "user-agent"

	// CSSStyleSheetOriginInspector enum const.
	CSSStyleSheetOriginInspector CSSStyleSheetOrigin = "inspector"

	// CSSStyleSheetOriginRegular enum const.
	CSSStyleSheetOriginRegular CSSStyleSheetOrigin = "regular"
)

// CSSPseudoElementMatches CSS rule collection for a single pseudo style.
type CSSPseudoElementMatches struct {
	// PseudoType Pseudo element type.
	PseudoType DOMPseudoType `json:"pseudoType"`

	// PseudoIdentifier (optional) Pseudo element custom ident.
	PseudoIdentifier string `json:"pseudoIdentifier,omitempty"`

	// Matches of CSS rules applicable to the pseudo style.
	Matches []*CSSRuleMatch `json:"matches"`
}

// CSSInheritedStyleEntry Inherited CSS rule collection from ancestor node.
type CSSInheritedStyleEntry struct {
	// InlineStyle (optional) The ancestor node's inline style, if any, in the style inheritance chain.
	InlineStyle *CSSCSSStyle `json:"inlineStyle,omitempty"`

	// MatchedCSSRules Matches of CSS rules matching the ancestor node in the style inheritance chain.
	MatchedCSSRules []*CSSRuleMatch `json:"matchedCSSRules"`
}

// CSSInheritedPseudoElementMatches Inherited pseudo element matches from pseudos of an ancestor node.
type CSSInheritedPseudoElementMatches struct {
	// PseudoElements Matches of pseudo styles from the pseudos of an ancestor node.
	PseudoElements []*CSSPseudoElementMatches `json:"pseudoElements"`
}

// CSSRuleMatch Match data for a CSS rule.
type CSSRuleMatch struct {
	// Rule CSS rule in the match.
	Rule *CSSCSSRule `json:"rule"`

	// MatchingSelectors Matching selector indices in the rule's selectorList selectors (0-based).
	MatchingSelectors []int `json:"matchingSelectors"`
}

// CSSValue Data for a simple selector (these are delimited by commas in a selector list).
type CSSValue struct {
	// Text Value text.
	Text string `json:"text"`

	// Range (optional) Value range in the underlying resource (if available).
	Range *CSSSourceRange `json:"range,omitempty"`

	// Specificity (experimental) (optional) Specificity of the selector.
	Specificity *CSSSpecificity `json:"specificity,omitempty"`
}

// CSSSpecificity (experimental) Specificity:
// https://drafts.csswg.org/selectors/#specificity-rules
type CSSSpecificity struct {
	// A The a component, which represents the number of ID selectors.
	A int `json:"a"`

	// B The b component, which represents the number of class selectors, attributes selectors, and
	// pseudo-classes.
	B int `json:"b"`

	// C The c component, which represents the number of type selectors and pseudo-elements.
	C int `json:"c"`
}

// CSSSelectorList Selector list data.
type CSSSelectorList struct {
	// Selectors in the list.
	Selectors []*CSSValue `json:"selectors"`

	// Text Rule selector text.
	Text string `json:"text"`
}

// CSSCSSStyleSheetHeader CSS stylesheet metainformation.
type CSSCSSStyleSheetHeader struct {
	// StyleSheetID The stylesheet identifier.
	StyleSheetID CSSStyleSheetID `json:"styleSheetId"`

	// FrameID Owner frame identifier.
	FrameID PageFrameID `json:"frameId"`

	// SourceURL Stylesheet resource URL. Empty if this is a constructed stylesheet created using
	// new CSSStyleSheet() (but non-empty if this is a constructed stylesheet imported
	// as a CSS module script).
	SourceURL string `json:"sourceURL"`

	// SourceMapURL (optional) URL of source map associated with the stylesheet (if any).
	SourceMapURL string `json:"sourceMapURL,omitempty"`

	// Origin Stylesheet origin.
	Origin CSSStyleSheetOrigin `json:"origin"`

	// Title Stylesheet title.
	Title string `json:"title"`

	// OwnerNode (optional) The backend id for the owner node of the stylesheet.
	OwnerNode DOMBackendNodeID `json:"ownerNode,omitempty"`

	// Disabled Denotes whether the stylesheet is disabled.
	Disabled bool `json:"disabled"`

	// HasSourceURL (optional) Whether the sourceURL field value comes from the sourceURL comment.
	HasSourceURL bool `json:"hasSourceURL,omitempty"`

	// IsInline Whether this stylesheet is created for STYLE tag by parser. This flag is not set for
	// document.written STYLE tags.
	IsInline bool `json:"isInline"`

	// IsMutable Whether this stylesheet is mutable. Inline stylesheets become mutable
	// after they have been modified via CSSOM API.
	// `<link>` element's stylesheets become mutable only if DevTools modifies them.
	// Constructed stylesheets (new CSSStyleSheet()) are mutable immediately after creation.
	IsMutable bool `json:"isMutable"`

	// IsConstructed True if this stylesheet is created through new CSSStyleSheet() or imported as a
	// CSS module script.
	IsConstructed bool `json:"isConstructed"`

	// StartLine Line offset of the stylesheet within the resource (zero based).
	StartLine float64 `json:"startLine"`

	// StartColumn Column offset of the stylesheet within the resource (zero based).
	StartColumn float64 `json:"startColumn"`

	// Length Size of the content (in characters).
	Length float64 `json:"length"`

	// EndLine Line offset of the end of the stylesheet within the resource (zero based).
	EndLine float64 `json:"endLine"`

	// EndColumn Column offset of the end of the stylesheet within the resource (zero based).
	EndColumn float64 `json:"endColumn"`

	// LoadingFailed (experimental) (optional) If the style sheet was loaded from a network resource, this indicates when the resource failed to load
	LoadingFailed bool `json:"loadingFailed,omitempty"`
}

// CSSCSSRule CSS rule representation.
type CSSCSSRule struct {
	// StyleSheetID (optional) The css style sheet identifier (absent for user agent stylesheet and user-specified
	// stylesheet rules) this rule came from.
	StyleSheetID CSSStyleSheetID `json:"styleSheetId,omitempty"`

	// SelectorList Rule selector data.
	SelectorList *CSSSelectorList `json:"selectorList"`

	// NestingSelectors (experimental) (optional) Array of selectors from ancestor style rules, sorted by distance from the current rule.
	NestingSelectors []string `json:"nestingSelectors,omitempty"`

	// Origin Parent stylesheet's origin.
	Origin CSSStyleSheetOrigin `json:"origin"`

	// Style Associated style declaration.
	Style *CSSCSSStyle `json:"style"`

	// Media (optional) Media list array (for rules involving media queries). The array enumerates media queries
	// starting with the innermost one, going outwards.
	Media []*CSSCSSMedia `json:"media,omitempty"`

	// ContainerQueries (experimental) (optional) Container query list array (for rules involving container queries).
	// The array enumerates container queries starting with the innermost one, going outwards.
	ContainerQueries []*CSSCSSContainerQuery `json:"containerQueries,omitempty"`

	// Supports (experimental) (optional) @supports CSS at-rule array.
	// The array enumerates @supports at-rules starting with the innermost one, going outwards.
	Supports []*CSSCSSSupports `json:"supports,omitempty"`

	// Layers (experimental) (optional) Cascade layer array. Contains the layer hierarchy that this rule belongs to starting
	// with the innermost layer and going outwards.
	Layers []*CSSCSSLayer `json:"layers,omitempty"`

	// Scopes (experimental) (optional) @scope CSS at-rule array.
	// The array enumerates @scope at-rules starting with the innermost one, going outwards.
	Scopes []*CSSCSSScope `json:"scopes,omitempty"`

	// RuleTypes (experimental) (optional) The array keeps the types of ancestor CSSRules from the innermost going outwards.
	RuleTypes []CSSCSSRuleType `json:"ruleTypes,omitempty"`
}

// CSSCSSRuleType (experimental) Enum indicating the type of a CSS rule, used to represent the order of a style rule's ancestors.
// This list only contains rule types that are collected during the ancestor rule collection.
type CSSCSSRuleType string

const (
	// CSSCSSRuleTypeMediaRule enum const.
	CSSCSSRuleTypeMediaRule CSSCSSRuleType = "MediaRule"

	// CSSCSSRuleTypeSupportsRule enum const.
	CSSCSSRuleTypeSupportsRule CSSCSSRuleType = "SupportsRule"

	// CSSCSSRuleTypeContainerRule enum const.
	CSSCSSRuleTypeContainerRule CSSCSSRuleType = "ContainerRule"

	// CSSCSSRuleTypeLayerRule enum const.
	CSSCSSRuleTypeLayerRule CSSCSSRuleType = "LayerRule"

	// CSSCSSRuleTypeScopeRule enum const.
	CSSCSSRuleTypeScopeRule CSSCSSRuleType = "ScopeRule"

	// CSSCSSRuleTypeStyleRule enum const.
	CSSCSSRuleTypeStyleRule CSSCSSRuleType = "StyleRule"
)

// CSSRuleUsage CSS coverage information.
type CSSRuleUsage struct {
	// StyleSheetID The css style sheet identifier (absent for user agent stylesheet and user-specified
	// stylesheet rules) this rule came from.
	StyleSheetID CSSStyleSheetID `json:"styleSheetId"`

	// StartOffset Offset of the start of the rule (including selector) from the beginning of the stylesheet.
	StartOffset float64 `json:"startOffset"`

	// EndOffset Offset of the end of the rule body from the beginning of the stylesheet.
	EndOffset float64 `json:"endOffset"`

	// Used Indicates whether the rule was actually used by some element in the page.
	Used bool `json:"used"`
}

// CSSSourceRange Text range within a resource. All numbers are zero-based.
type CSSSourceRange struct {
	// StartLine Start line of range.
	StartLine int `json:"startLine"`

	// StartColumn Start column of range (inclusive).
	StartColumn int `json:"startColumn"`

	// EndLine End line of range
	EndLine int `json:"endLine"`

	// EndColumn End column of range (exclusive).
	EndColumn int `json:"endColumn"`
}

// CSSShorthandEntry ...
type CSSShorthandEntry struct {
	// Name Shorthand name.
	Name string `json:"name"`

	// Value Shorthand value.
	Value string `json:"value"`

	// Important (optional) Whether the property has "!important" annotation (implies `false` if absent).
	Important bool `json:"important,omitempty"`
}

// CSSCSSComputedStyleProperty ...
type CSSCSSComputedStyleProperty struct {
	// Name Computed style property name.
	Name string `json:"name"`

	// Value Computed style property value.
	Value string `json:"value"`
}

// CSSCSSStyle CSS style representation.
type CSSCSSStyle struct {
	// StyleSheetID (optional) The css style sheet identifier (absent for user agent stylesheet and user-specified
	// stylesheet rules) this rule came from.
	StyleSheetID CSSStyleSheetID `json:"styleSheetId,omitempty"`

	// CSSProperties CSS properties in the style.
	CSSProperties []*CSSCSSProperty `json:"cssProperties"`

	// ShorthandEntries Computed values for all shorthands found in the style.
	ShorthandEntries []*CSSShorthandEntry `json:"shorthandEntries"`

	// CSSText (optional) Style declaration text (if available).
	CSSText string `json:"cssText,omitempty"`

	// Range (optional) Style declaration range in the enclosing stylesheet (if available).
	Range *CSSSourceRange `json:"range,omitempty"`
}

// CSSCSSProperty CSS property declaration data.
type CSSCSSProperty struct {
	// Name The property name.
	Name string `json:"name"`

	// Value The property value.
	Value string `json:"value"`

	// Important (optional) Whether the property has "!important" annotation (implies `false` if absent).
	Important bool `json:"important,omitempty"`

	// Implicit (optional) Whether the property is implicit (implies `false` if absent).
	Implicit bool `json:"implicit,omitempty"`

	// Text (optional) The full property text as specified in the style.
	Text string `json:"text,omitempty"`

	// ParsedOk (optional) Whether the property is understood by the browser (implies `true` if absent).
	ParsedOk bool `json:"parsedOk,omitempty"`

	// Disabled (optional) Whether the property is disabled by the user (present for source-based properties only).
	Disabled bool `json:"disabled,omitempty"`

	// Range (optional) The entire property range in the enclosing style declaration (if available).
	Range *CSSSourceRange `json:"range,omitempty"`

	// LonghandProperties (experimental) (optional) Parsed longhand components of this property if it is a shorthand.
	// This field will be empty if the given property is not a shorthand.
	LonghandProperties []*CSSCSSProperty `json:"longhandProperties,omitempty"`
}

// CSSCSSMediaSource enum.
type CSSCSSMediaSource string

const (
	// CSSCSSMediaSourceMediaRule enum const.
	CSSCSSMediaSourceMediaRule CSSCSSMediaSource = "mediaRule"

	// CSSCSSMediaSourceImportRule enum const.
	CSSCSSMediaSourceImportRule CSSCSSMediaSource = "importRule"

	// CSSCSSMediaSourceLinkedSheet enum const.
	CSSCSSMediaSourceLinkedSheet CSSCSSMediaSource = "linkedSheet"

	// CSSCSSMediaSourceInlineSheet enum const.
	CSSCSSMediaSourceInlineSheet CSSCSSMediaSource = "inlineSheet"
)

// CSSCSSMedia CSS media rule descriptor.
type CSSCSSMedia struct {
	// Text Media query text.
	Text string `json:"text"`

	// Source of the media query: "mediaRule" if specified by a @media rule, "importRule" if
	// specified by an @import rule, "linkedSheet" if specified by a "media" attribute in a linked
	// stylesheet's LINK tag, "inlineSheet" if specified by a "media" attribute in an inline
	// stylesheet's STYLE tag.
	Source CSSCSSMediaSource `json:"source"`

	// SourceURL (optional) URL of the document containing the media query description.
	SourceURL string `json:"sourceURL,omitempty"`

	// Range (optional) The associated rule (@media or @import) header range in the enclosing stylesheet (if
	// available).
	Range *CSSSourceRange `json:"range,omitempty"`

	// StyleSheetID (optional) Identifier of the stylesheet containing this object (if exists).
	StyleSheetID CSSStyleSheetID `json:"styleSheetId,omitempty"`

	// MediaList (optional) Array of media queries.
	MediaList []*CSSMediaQuery `json:"mediaList,omitempty"`
}

// CSSMediaQuery Media query descriptor.
type CSSMediaQuery struct {
	// Expressions Array of media query expressions.
	Expressions []*CSSMediaQueryExpression `json:"expressions"`

	// Active Whether the media query condition is satisfied.
	Active bool `json:"active"`
}

// CSSMediaQueryExpression Media query expression descriptor.
type CSSMediaQueryExpression struct {
	// Value Media query expression value.
	Value float64 `json:"value"`

	// Unit Media query expression units.
	Unit string `json:"unit"`

	// Feature Media query expression feature.
	Feature string `json:"feature"`

	// ValueRange (optional) The associated range of the value text in the enclosing stylesheet (if available).
	ValueRange *CSSSourceRange `json:"valueRange,omitempty"`

	// ComputedLength (optional) Computed length of media query expression (if applicable).
	ComputedLength *float64 `json:"computedLength,omitempty"`
}

// CSSCSSContainerQuery (experimental) CSS container query rule descriptor.
type CSSCSSContainerQuery struct {
	// Text Container query text.
	Text string `json:"text"`

	// Range (optional) The associated rule header range in the enclosing stylesheet (if
	// available).
	Range *CSSSourceRange `json:"range,omitempty"`

	// StyleSheetID (optional) Identifier of the stylesheet containing this object (if exists).
	StyleSheetID CSSStyleSheetID `json:"styleSheetId,omitempty"`

	// Name (optional) Optional name for the container.
	Name string `json:"name,omitempty"`

	// PhysicalAxes (optional) Optional physical axes queried for the container.
	PhysicalAxes DOMPhysicalAxes `json:"physicalAxes,omitempty"`

	// LogicalAxes (optional) Optional logical axes queried for the container.
	LogicalAxes DOMLogicalAxes `json:"logicalAxes,omitempty"`
}

// CSSCSSSupports (experimental) CSS Supports at-rule descriptor.
type CSSCSSSupports struct {
	// Text Supports rule text.
	Text string `json:"text"`

	// Active Whether the supports condition is satisfied.
	Active bool `json:"active"`

	// Range (optional) The associated rule header range in the enclosing stylesheet (if
	// available).
	Range *CSSSourceRange `json:"range,omitempty"`

	// StyleSheetID (optional) Identifier of the stylesheet containing this object (if exists).
	StyleSheetID CSSStyleSheetID `json:"styleSheetId,omitempty"`
}

// CSSCSSScope (experimental) CSS Scope at-rule descriptor.
type CSSCSSScope struct {
	// Text Scope rule text.
	Text string `json:"text"`

	// Range (optional) The associated rule header range in the enclosing stylesheet (if
	// available).
	Range *CSSSourceRange `json:"range,omitempty"`

	// StyleSheetID (optional) Identifier of the stylesheet containing this object (if exists).
	StyleSheetID CSSStyleSheetID `json:"styleSheetId,omitempty"`
}

// CSSCSSLayer (experimental) CSS Layer at-rule descriptor.
type CSSCSSLayer struct {
	// Text Layer name.
	Text string `json:"text"`

	// Range (optional) The associated rule header range in the enclosing stylesheet (if
	// available).
	Range *CSSSourceRange `json:"range,omitempty"`

	// StyleSheetID (optional) Identifier of the stylesheet containing this object (if exists).
	StyleSheetID CSSStyleSheetID `json:"styleSheetId,omitempty"`
}

// CSSCSSLayerData (experimental) CSS Layer data.
type CSSCSSLayerData struct {
	// Name Layer name.
	Name string `json:"name"`

	// SubLayers (optional) Direct sub-layers
	SubLayers []*CSSCSSLayerData `json:"subLayers,omitempty"`

	// Order Layer order. The order determines the order of the layer in the cascade order.
	// A higher number has higher priority in the cascade order.
	Order float64 `json:"order"`
}

// CSSPlatformFontUsage Information about amount of glyphs that were rendered with given font.
type CSSPlatformFontUsage struct {
	// FamilyName Font's family name reported by platform.
	FamilyName string `json:"familyName"`

	// PostScriptName Font's PostScript name reported by platform.
	PostScriptName string `json:"postScriptName"`

	// IsCustomFont Indicates if the font was downloaded or resolved locally.
	IsCustomFont bool `json:"isCustomFont"`

	// GlyphCount Amount of glyphs that were rendered with this font.
	GlyphCount float64 `json:"glyphCount"`
}

// CSSFontVariationAxis Information about font variation axes for variable fonts.
type CSSFontVariationAxis struct {
	// Tag The font-variation-setting tag (a.k.a. "axis tag").
	Tag string `json:"tag"`

	// Name Human-readable variation name in the default language (normally, "en").
	Name string `json:"name"`

	// MinValue The minimum value (inclusive) the font supports for this tag.
	MinValue float64 `json:"minValue"`

	// MaxValue The maximum value (inclusive) the font supports for this tag.
	MaxValue float64 `json:"maxValue"`

	// DefaultValue The default value.
	DefaultValue float64 `json:"defaultValue"`
}

// CSSFontFace Properties of a web font: https://www.w3.org/TR/2008/REC-CSS2-20080411/fonts.html#font-descriptions
// and additional information such as platformFontFamily and fontVariationAxes.
type CSSFontFace struct {
	// FontFamily The font-family.
	FontFamily string `json:"fontFamily"`

	// FontStyle The font-style.
	FontStyle string `json:"fontStyle"`

	// FontVariant The font-variant.
	FontVariant string `json:"fontVariant"`

	// FontWeight The font-weight.
	FontWeight string `json:"fontWeight"`

	// FontStretch The font-stretch.
	FontStretch string `json:"fontStretch"`

	// FontDisplay The font-display.
	FontDisplay string `json:"fontDisplay"`

	// UnicodeRange The unicode-range.
	UnicodeRange string `json:"unicodeRange"`

	// Src The src.
	Src string `json:"src"`

	// PlatformFontFamily The resolved platform font family
	PlatformFontFamily string `json:"platformFontFamily"`

	// FontVariationAxes (optional) Available variation settings (a.k.a. "axes").
	FontVariationAxes []*CSSFontVariationAxis `json:"fontVariationAxes,omitempty"`
}

// CSSCSSTryRule CSS try rule representation.
type CSSCSSTryRule struct {
	// StyleSheetID (optional) The css style sheet identifier (absent for user agent stylesheet and user-specified
	// stylesheet rules) this rule came from.
	StyleSheetID CSSStyleSheetID `json:"styleSheetId,omitempty"`

	// Origin Parent stylesheet's origin.
	Origin CSSStyleSheetOrigin `json:"origin"`

	// Style Associated style declaration.
	Style *CSSCSSStyle `json:"style"`
}

// CSSCSSPositionFallbackRule (deprecated) CSS position-fallback rule representation.
type CSSCSSPositionFallbackRule struct {
	// Name ...
	Name *CSSValue `json:"name"`

	// TryRules List of keyframes.
	TryRules []*CSSCSSTryRule `json:"tryRules"`
}

// CSSCSSPositionTryRule CSS @position-try rule representation.
type CSSCSSPositionTryRule struct {
	// Name The prelude dashed-ident name
	Name *CSSValue `json:"name"`

	// StyleSheetID (optional) The css style sheet identifier (absent for user agent stylesheet and user-specified
	// stylesheet rules) this rule came from.
	StyleSheetID CSSStyleSheetID `json:"styleSheetId,omitempty"`

	// Origin Parent stylesheet's origin.
	Origin CSSStyleSheetOrigin `json:"origin"`

	// Style Associated style declaration.
	Style *CSSCSSStyle `json:"style"`
}

// CSSCSSKeyframesRule CSS keyframes rule representation.
type CSSCSSKeyframesRule struct {
	// AnimationName Animation name.
	AnimationName *CSSValue `json:"animationName"`

	// Keyframes List of keyframes.
	Keyframes []*CSSCSSKeyframeRule `json:"keyframes"`
}

// CSSCSSPropertyRegistration Representation of a custom property registration through CSS.registerProperty.
type CSSCSSPropertyRegistration struct {
	// PropertyName ...
	PropertyName string `json:"propertyName"`

	// InitialValue (optional) ...
	InitialValue *CSSValue `json:"initialValue,omitempty"`

	// Inherits ...
	Inherits bool `json:"inherits"`

	// Syntax ...
	Syntax string `json:"syntax"`
}

// CSSCSSFontPaletteValuesRule CSS font-palette-values rule representation.
type CSSCSSFontPaletteValuesRule struct {
	// StyleSheetID (optional) The css style sheet identifier (absent for user agent stylesheet and user-specified
	// stylesheet rules) this rule came from.
	StyleSheetID CSSStyleSheetID `json:"styleSheetId,omitempty"`

	// Origin Parent stylesheet's origin.
	Origin CSSStyleSheetOrigin `json:"origin"`

	// FontPaletteName Associated font palette name.
	FontPaletteName *CSSValue `json:"fontPaletteName"`

	// Style Associated style declaration.
	Style *CSSCSSStyle `json:"style"`
}

// CSSCSSPropertyRule CSS property at-rule representation.
type CSSCSSPropertyRule struct {
	// StyleSheetID (optional) The css style sheet identifier (absent for user agent stylesheet and user-specified
	// stylesheet rules) this rule came from.
	StyleSheetID CSSStyleSheetID `json:"styleSheetId,omitempty"`

	// Origin Parent stylesheet's origin.
	Origin CSSStyleSheetOrigin `json:"origin"`

	// PropertyName Associated property name.
	PropertyName *CSSValue `json:"propertyName"`

	// Style Associated style declaration.
	Style *CSSCSSStyle `json:"style"`
}

// CSSCSSKeyframeRule CSS keyframe rule representation.
type CSSCSSKeyframeRule struct {
	// StyleSheetID (optional) The css style sheet identifier (absent for user agent stylesheet and user-specified
	// stylesheet rules) this rule came from.
	StyleSheetID CSSStyleSheetID `json:"styleSheetId,omitempty"`

	// Origin Parent stylesheet's origin.
	Origin CSSStyleSheetOrigin `json:"origin"`

	// KeyText Associated key text.
	KeyText *CSSValue `json:"keyText"`

	// Style Associated style declaration.
	Style *CSSCSSStyle `json:"style"`
}

// CSSStyleDeclarationEdit A descriptor of operation to mutate style declaration text.
type CSSStyleDeclarationEdit struct {
	// StyleSheetID The css style sheet identifier.
	StyleSheetID CSSStyleSheetID `json:"styleSheetId"`

	// Range The range of the style text in the enclosing stylesheet.
	Range *CSSSourceRange `json:"range"`

	// Text New style text.
	Text string `json:"text"`
}

// CSSAddRule Inserts a new rule with the given `ruleText` in a stylesheet with given `styleSheetId`, at the
// position specified by `location`.
type CSSAddRule struct {
	// StyleSheetID The css style sheet identifier where a new rule should be inserted.
	StyleSheetID CSSStyleSheetID `json:"styleSheetId"`

	// RuleText The text of a new rule.
	RuleText string `json:"ruleText"`

	// Location Text position of a new rule in the target style sheet.
	Location *CSSSourceRange `json:"location"`

	// NodeForPropertySyntaxValidation (experimental) (optional) NodeId for the DOM node in whose context custom property declarations for registered properties should be
	// validated. If omitted, declarations in the new rule text can only be validated statically, which may produce
	// incorrect results if the declaration contains a var() for example.
	NodeForPropertySyntaxValidation DOMNodeID `json:"nodeForPropertySyntaxValidation,omitempty"`
}

// ProtoReq name.
func (m CSSAddRule) ProtoReq() string { return "CSS.addRule" }

// Call the request.
func (m CSSAddRule) Call(c Client) (*CSSAddRuleResult, error) {
	var res CSSAddRuleResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// CSSAddRuleResult ...
type CSSAddRuleResult struct {
	// Rule The newly created rule.
	Rule *CSSCSSRule `json:"rule"`
}

// CSSCollectClassNames Returns all class names from specified stylesheet.
type CSSCollectClassNames struct {
	// StyleSheetID ...
	StyleSheetID CSSStyleSheetID `json:"styleSheetId"`
}

// ProtoReq name.
func (m CSSCollectClassNames) ProtoReq() string { return "CSS.collectClassNames" }

// Call the request.
func (m CSSCollectClassNames) Call(c Client) (*CSSCollectClassNamesResult, error) {
	var res CSSCollectClassNamesResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// CSSCollectClassNamesResult ...
type CSSCollectClassNamesResult struct {
	// ClassNames Class name list.
	ClassNames []string `json:"classNames"`
}

// CSSCreateStyleSheet Creates a new special "via-inspector" stylesheet in the frame with given `frameId`.
type CSSCreateStyleSheet struct {
	// FrameID Identifier of the frame where "via-inspector" stylesheet should be created.
	FrameID PageFrameID `json:"frameId"`
}

// ProtoReq name.
func (m CSSCreateStyleSheet) ProtoReq() string { return "CSS.createStyleSheet" }

// Call the request.
func (m CSSCreateStyleSheet) Call(c Client) (*CSSCreateStyleSheetResult, error) {
	var res CSSCreateStyleSheetResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// CSSCreateStyleSheetResult ...
type CSSCreateStyleSheetResult struct {
	// StyleSheetID Identifier of the created "via-inspector" stylesheet.
	StyleSheetID CSSStyleSheetID `json:"styleSheetId"`
}

// CSSDisable Disables the CSS agent for the given page.
type CSSDisable struct{}

// ProtoReq name.
func (m CSSDisable) ProtoReq() string { return "CSS.disable" }

// Call sends the request.
func (m CSSDisable) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// CSSEnable Enables the CSS agent for the given page. Clients should not assume that the CSS agent has been
// enabled until the result of this command is received.
type CSSEnable struct{}

// ProtoReq name.
func (m CSSEnable) ProtoReq() string { return "CSS.enable" }

// Call sends the request.
func (m CSSEnable) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// CSSForcePseudoState Ensures that the given node will have specified pseudo-classes whenever its style is computed by
// the browser.
type CSSForcePseudoState struct {
	// NodeID The element id for which to force the pseudo state.
	NodeID DOMNodeID `json:"nodeId"`

	// ForcedPseudoClasses Element pseudo classes to force when computing the element's style.
	ForcedPseudoClasses []string `json:"forcedPseudoClasses"`
}

// ProtoReq name.
func (m CSSForcePseudoState) ProtoReq() string { return "CSS.forcePseudoState" }

// Call sends the request.
func (m CSSForcePseudoState) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// CSSGetBackgroundColors ...
type CSSGetBackgroundColors struct {
	// NodeID Id of the node to get background colors for.
	NodeID DOMNodeID `json:"nodeId"`
}

// ProtoReq name.
func (m CSSGetBackgroundColors) ProtoReq() string { return "CSS.getBackgroundColors" }

// Call the request.
func (m CSSGetBackgroundColors) Call(c Client) (*CSSGetBackgroundColorsResult, error) {
	var res CSSGetBackgroundColorsResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// CSSGetBackgroundColorsResult ...
type CSSGetBackgroundColorsResult struct {
	// BackgroundColors (optional) The range of background colors behind this element, if it contains any visible text. If no
	// visible text is present, this will be undefined. In the case of a flat background color,
	// this will consist of simply that color. In the case of a gradient, this will consist of each
	// of the color stops. For anything more complicated, this will be an empty array. Images will
	// be ignored (as if the image had failed to load).
	BackgroundColors []string `json:"backgroundColors,omitempty"`

	// ComputedFontSize (optional) The computed font size for this node, as a CSS computed value string (e.g. '12px').
	ComputedFontSize string `json:"computedFontSize,omitempty"`

	// ComputedFontWeight (optional) The computed font weight for this node, as a CSS computed value string (e.g. 'normal' or
	// '100').
	ComputedFontWeight string `json:"computedFontWeight,omitempty"`
}

// CSSGetComputedStyleForNode Returns the computed style for a DOM node identified by `nodeId`.
type CSSGetComputedStyleForNode struct {
	// NodeID ...
	NodeID DOMNodeID `json:"nodeId"`
}

// ProtoReq name.
func (m CSSGetComputedStyleForNode) ProtoReq() string { return "CSS.getComputedStyleForNode" }

// Call the request.
func (m CSSGetComputedStyleForNode) Call(c Client) (*CSSGetComputedStyleForNodeResult, error) {
	var res CSSGetComputedStyleForNodeResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// CSSGetComputedStyleForNodeResult ...
type CSSGetComputedStyleForNodeResult struct {
	// ComputedStyle Computed style for the specified DOM node.
	ComputedStyle []*CSSCSSComputedStyleProperty `json:"computedStyle"`
}

// CSSGetInlineStylesForNode Returns the styles defined inline (explicitly in the "style" attribute and implicitly, using DOM
// attributes) for a DOM node identified by `nodeId`.
type CSSGetInlineStylesForNode struct {
	// NodeID ...
	NodeID DOMNodeID `json:"nodeId"`
}

// ProtoReq name.
func (m CSSGetInlineStylesForNode) ProtoReq() string { return "CSS.getInlineStylesForNode" }

// Call the request.
func (m CSSGetInlineStylesForNode) Call(c Client) (*CSSGetInlineStylesForNodeResult, error) {
	var res CSSGetInlineStylesForNodeResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// CSSGetInlineStylesForNodeResult ...
type CSSGetInlineStylesForNodeResult struct {
	// InlineStyle (optional) Inline style for the specified DOM node.
	InlineStyle *CSSCSSStyle `json:"inlineStyle,omitempty"`

	// AttributesStyle (optional) Attribute-defined element style (e.g. resulting from "width=20 height=100%").
	AttributesStyle *CSSCSSStyle `json:"attributesStyle,omitempty"`
}

// CSSGetMatchedStylesForNode Returns requested styles for a DOM node identified by `nodeId`.
type CSSGetMatchedStylesForNode struct {
	// NodeID ...
	NodeID DOMNodeID `json:"nodeId"`
}

// ProtoReq name.
func (m CSSGetMatchedStylesForNode) ProtoReq() string { return "CSS.getMatchedStylesForNode" }

// Call the request.
func (m CSSGetMatchedStylesForNode) Call(c Client) (*CSSGetMatchedStylesForNodeResult, error) {
	var res CSSGetMatchedStylesForNodeResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// CSSGetMatchedStylesForNodeResult ...
type CSSGetMatchedStylesForNodeResult struct {
	// InlineStyle (optional) Inline style for the specified DOM node.
	InlineStyle *CSSCSSStyle `json:"inlineStyle,omitempty"`

	// AttributesStyle (optional) Attribute-defined element style (e.g. resulting from "width=20 height=100%").
	AttributesStyle *CSSCSSStyle `json:"attributesStyle,omitempty"`

	// MatchedCSSRules (optional) CSS rules matching this node, from all applicable stylesheets.
	MatchedCSSRules []*CSSRuleMatch `json:"matchedCSSRules,omitempty"`

	// PseudoElements (optional) Pseudo style matches for this node.
	PseudoElements []*CSSPseudoElementMatches `json:"pseudoElements,omitempty"`

	// Inherited (optional) A chain of inherited styles (from the immediate node parent up to the DOM tree root).
	Inherited []*CSSInheritedStyleEntry `json:"inherited,omitempty"`

	// InheritedPseudoElements (optional) A chain of inherited pseudo element styles (from the immediate node parent up to the DOM tree root).
	InheritedPseudoElements []*CSSInheritedPseudoElementMatches `json:"inheritedPseudoElements,omitempty"`

	// CSSKeyframesRules (optional) A list of CSS keyframed animations matching this node.
	CSSKeyframesRules []*CSSCSSKeyframesRule `json:"cssKeyframesRules,omitempty"`

	// CSSPositionFallbackRules (deprecated) (optional) A list of CSS position fallbacks matching this node.
	CSSPositionFallbackRules []*CSSCSSPositionFallbackRule `json:"cssPositionFallbackRules,omitempty"`

	// CSSPositionTryRules (optional) A list of CSS @position-try rules matching this node, based on the position-try-options property.
	CSSPositionTryRules []*CSSCSSPositionTryRule `json:"cssPositionTryRules,omitempty"`

	// CSSPropertyRules (optional) A list of CSS at-property rules matching this node.
	CSSPropertyRules []*CSSCSSPropertyRule `json:"cssPropertyRules,omitempty"`

	// CSSPropertyRegistrations (optional) A list of CSS property registrations matching this node.
	CSSPropertyRegistrations []*CSSCSSPropertyRegistration `json:"cssPropertyRegistrations,omitempty"`

	// CSSFontPaletteValuesRule (optional) A font-palette-values rule matching this node.
	CSSFontPaletteValuesRule *CSSCSSFontPaletteValuesRule `json:"cssFontPaletteValuesRule,omitempty"`

	// ParentLayoutNodeID (experimental) (optional) Id of the first parent element that does not have display: contents.
	ParentLayoutNodeID DOMNodeID `json:"parentLayoutNodeId,omitempty"`
}

// CSSGetMediaQueries Returns all media queries parsed by the rendering engine.
type CSSGetMediaQueries struct{}

// ProtoReq name.
func (m CSSGetMediaQueries) ProtoReq() string { return "CSS.getMediaQueries" }

// Call the request.
func (m CSSGetMediaQueries) Call(c Client) (*CSSGetMediaQueriesResult, error) {
	var res CSSGetMediaQueriesResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// CSSGetMediaQueriesResult ...
type CSSGetMediaQueriesResult struct {
	// Medias ...
	Medias []*CSSCSSMedia `json:"medias"`
}

// CSSGetPlatformFontsForNode Requests information about platform fonts which we used to render child TextNodes in the given
// node.
type CSSGetPlatformFontsForNode struct {
	// NodeID ...
	NodeID DOMNodeID `json:"nodeId"`
}

// ProtoReq name.
func (m CSSGetPlatformFontsForNode) ProtoReq() string { return "CSS.getPlatformFontsForNode" }

// Call the request.
func (m CSSGetPlatformFontsForNode) Call(c Client) (*CSSGetPlatformFontsForNodeResult, error) {
	var res CSSGetPlatformFontsForNodeResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// CSSGetPlatformFontsForNodeResult ...
type CSSGetPlatformFontsForNodeResult struct {
	// Fonts Usage statistics for every employed platform font.
	Fonts []*CSSPlatformFontUsage `json:"fonts"`
}

// CSSGetStyleSheetText Returns the current textual content for a stylesheet.
type CSSGetStyleSheetText struct {
	// StyleSheetID ...
	StyleSheetID CSSStyleSheetID `json:"styleSheetId"`
}

// ProtoReq name.
func (m CSSGetStyleSheetText) ProtoReq() string { return "CSS.getStyleSheetText" }

// Call the request.
func (m CSSGetStyleSheetText) Call(c Client) (*CSSGetStyleSheetTextResult, error) {
	var res CSSGetStyleSheetTextResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// CSSGetStyleSheetTextResult ...
type CSSGetStyleSheetTextResult struct {
	// Text The stylesheet text.
	Text string `json:"text"`
}

// CSSGetLayersForNode (experimental) Returns all layers parsed by the rendering engine for the tree scope of a node.
// Given a DOM element identified by nodeId, getLayersForNode returns the root
// layer for the nearest ancestor document or shadow root. The layer root contains
// the full layer tree for the tree scope and their ordering.
type CSSGetLayersForNode struct {
	// NodeID ...
	NodeID DOMNodeID `json:"nodeId"`
}

// ProtoReq name.
func (m CSSGetLayersForNode) ProtoReq() string { return "CSS.getLayersForNode" }

// Call the request.
func (m CSSGetLayersForNode) Call(c Client) (*CSSGetLayersForNodeResult, error) {
	var res CSSGetLayersForNodeResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// CSSGetLayersForNodeResult (experimental) ...
type CSSGetLayersForNodeResult struct {
	// RootLayer ...
	RootLayer *CSSCSSLayerData `json:"rootLayer"`
}

// CSSGetLocationForSelector (experimental) Given a CSS selector text and a style sheet ID, getLocationForSelector
// returns an array of locations of the CSS selector in the style sheet.
type CSSGetLocationForSelector struct {
	// StyleSheetID ...
	StyleSheetID CSSStyleSheetID `json:"styleSheetId"`

	// SelectorText ...
	SelectorText string `json:"selectorText"`
}

// ProtoReq name.
func (m CSSGetLocationForSelector) ProtoReq() string { return "CSS.getLocationForSelector" }

// Call the request.
func (m CSSGetLocationForSelector) Call(c Client) (*CSSGetLocationForSelectorResult, error) {
	var res CSSGetLocationForSelectorResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// CSSGetLocationForSelectorResult (experimental) ...
type CSSGetLocationForSelectorResult struct {
	// Ranges ...
	Ranges []*CSSSourceRange `json:"ranges"`
}

// CSSTrackComputedStyleUpdates (experimental) Starts tracking the given computed styles for updates. The specified array of properties
// replaces the one previously specified. Pass empty array to disable tracking.
// Use takeComputedStyleUpdates to retrieve the list of nodes that had properties modified.
// The changes to computed style properties are only tracked for nodes pushed to the front-end
// by the DOM agent. If no changes to the tracked properties occur after the node has been pushed
// to the front-end, no updates will be issued for the node.
type CSSTrackComputedStyleUpdates struct {
	// PropertiesToTrack ...
	PropertiesToTrack []*CSSCSSComputedStyleProperty `json:"propertiesToTrack"`
}

// ProtoReq name.
func (m CSSTrackComputedStyleUpdates) ProtoReq() string { return "CSS.trackComputedStyleUpdates" }

// Call sends the request.
func (m CSSTrackComputedStyleUpdates) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// CSSTakeComputedStyleUpdates (experimental) Polls the next batch of computed style updates.
type CSSTakeComputedStyleUpdates struct{}

// ProtoReq name.
func (m CSSTakeComputedStyleUpdates) ProtoReq() string { return "CSS.takeComputedStyleUpdates" }

// Call the request.
func (m CSSTakeComputedStyleUpdates) Call(c Client) (*CSSTakeComputedStyleUpdatesResult, error) {
	var res CSSTakeComputedStyleUpdatesResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// CSSTakeComputedStyleUpdatesResult (experimental) ...
type CSSTakeComputedStyleUpdatesResult struct {
	// NodeIDs The list of node Ids that have their tracked computed styles updated.
	NodeIDs []DOMNodeID `json:"nodeIds"`
}

// CSSSetEffectivePropertyValueForNode Find a rule with the given active property for the given node and set the new value for this
// property.
type CSSSetEffectivePropertyValueForNode struct {
	// NodeID The element id for which to set property.
	NodeID DOMNodeID `json:"nodeId"`

	// PropertyName ...
	PropertyName string `json:"propertyName"`

	// Value ...
	Value string `json:"value"`
}

// ProtoReq name.
func (m CSSSetEffectivePropertyValueForNode) ProtoReq() string {
	return "CSS.setEffectivePropertyValueForNode"
}

// Call sends the request.
func (m CSSSetEffectivePropertyValueForNode) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// CSSSetPropertyRulePropertyName Modifies the property rule property name.
type CSSSetPropertyRulePropertyName struct {
	// StyleSheetID ...
	StyleSheetID CSSStyleSheetID `json:"styleSheetId"`

	// Range ...
	Range *CSSSourceRange `json:"range"`

	// PropertyName ...
	PropertyName string `json:"propertyName"`
}

// ProtoReq name.
func (m CSSSetPropertyRulePropertyName) ProtoReq() string { return "CSS.setPropertyRulePropertyName" }

// Call the request.
func (m CSSSetPropertyRulePropertyName) Call(c Client) (*CSSSetPropertyRulePropertyNameResult, error) {
	var res CSSSetPropertyRulePropertyNameResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// CSSSetPropertyRulePropertyNameResult ...
type CSSSetPropertyRulePropertyNameResult struct {
	// PropertyName The resulting key text after modification.
	PropertyName *CSSValue `json:"propertyName"`
}

// CSSSetKeyframeKey Modifies the keyframe rule key text.
type CSSSetKeyframeKey struct {
	// StyleSheetID ...
	StyleSheetID CSSStyleSheetID `json:"styleSheetId"`

	// Range ...
	Range *CSSSourceRange `json:"range"`

	// KeyText ...
	KeyText string `json:"keyText"`
}

// ProtoReq name.
func (m CSSSetKeyframeKey) ProtoReq() string { return "CSS.setKeyframeKey" }

// Call the request.
func (m CSSSetKeyframeKey) Call(c Client) (*CSSSetKeyframeKeyResult, error) {
	var res CSSSetKeyframeKeyResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// CSSSetKeyframeKeyResult ...
type CSSSetKeyframeKeyResult struct {
	// KeyText The resulting key text after modification.
	KeyText *CSSValue `json:"keyText"`
}

// CSSSetMediaText Modifies the rule selector.
type CSSSetMediaText struct {
	// StyleSheetID ...
	StyleSheetID CSSStyleSheetID `json:"styleSheetId"`

	// Range ...
	Range *CSSSourceRange `json:"range"`

	// Text ...
	Text string `json:"text"`
}

// ProtoReq name.
func (m CSSSetMediaText) ProtoReq() string { return "CSS.setMediaText" }

// Call the request.
func (m CSSSetMediaText) Call(c Client) (*CSSSetMediaTextResult, error) {
	var res CSSSetMediaTextResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// CSSSetMediaTextResult ...
type CSSSetMediaTextResult struct {
	// Media The resulting CSS media rule after modification.
	Media *CSSCSSMedia `json:"media"`
}

// CSSSetContainerQueryText (experimental) Modifies the expression of a container query.
type CSSSetContainerQueryText struct {
	// StyleSheetID ...
	StyleSheetID CSSStyleSheetID `json:"styleSheetId"`

	// Range ...
	Range *CSSSourceRange `json:"range"`

	// Text ...
	Text string `json:"text"`
}

// ProtoReq name.
func (m CSSSetContainerQueryText) ProtoReq() string { return "CSS.setContainerQueryText" }

// Call the request.
func (m CSSSetContainerQueryText) Call(c Client) (*CSSSetContainerQueryTextResult, error) {
	var res CSSSetContainerQueryTextResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// CSSSetContainerQueryTextResult (experimental) ...
type CSSSetContainerQueryTextResult struct {
	// ContainerQuery The resulting CSS container query rule after modification.
	ContainerQuery *CSSCSSContainerQuery `json:"containerQuery"`
}

// CSSSetSupportsText (experimental) Modifies the expression of a supports at-rule.
type CSSSetSupportsText struct {
	// StyleSheetID ...
	StyleSheetID CSSStyleSheetID `json:"styleSheetId"`

	// Range ...
	Range *CSSSourceRange `json:"range"`

	// Text ...
	Text string `json:"text"`
}

// ProtoReq name.
func (m CSSSetSupportsText) ProtoReq() string { return "CSS.setSupportsText" }

// Call the request.
func (m CSSSetSupportsText) Call(c Client) (*CSSSetSupportsTextResult, error) {
	var res CSSSetSupportsTextResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// CSSSetSupportsTextResult (experimental) ...
type CSSSetSupportsTextResult struct {
	// Supports The resulting CSS Supports rule after modification.
	Supports *CSSCSSSupports `json:"supports"`
}

// CSSSetScopeText (experimental) Modifies the expression of a scope at-rule.
type CSSSetScopeText struct {
	// StyleSheetID ...
	StyleSheetID CSSStyleSheetID `json:"styleSheetId"`

	// Range ...
	Range *CSSSourceRange `json:"range"`

	// Text ...
	Text string `json:"text"`
}

// ProtoReq name.
func (m CSSSetScopeText) ProtoReq() string { return "CSS.setScopeText" }

// Call the request.
func (m CSSSetScopeText) Call(c Client) (*CSSSetScopeTextResult, error) {
	var res CSSSetScopeTextResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// CSSSetScopeTextResult (experimental) ...
type CSSSetScopeTextResult struct {
	// Scope The resulting CSS Scope rule after modification.
	Scope *CSSCSSScope `json:"scope"`
}

// CSSSetRuleSelector Modifies the rule selector.
type CSSSetRuleSelector struct {
	// StyleSheetID ...
	StyleSheetID CSSStyleSheetID `json:"styleSheetId"`

	// Range ...
	Range *CSSSourceRange `json:"range"`

	// Selector ...
	Selector string `json:"selector"`
}

// ProtoReq name.
func (m CSSSetRuleSelector) ProtoReq() string { return "CSS.setRuleSelector" }

// Call the request.
func (m CSSSetRuleSelector) Call(c Client) (*CSSSetRuleSelectorResult, error) {
	var res CSSSetRuleSelectorResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// CSSSetRuleSelectorResult ...
type CSSSetRuleSelectorResult struct {
	// SelectorList The resulting selector list after modification.
	SelectorList *CSSSelectorList `json:"selectorList"`
}

// CSSSetStyleSheetText Sets the new stylesheet text.
type CSSSetStyleSheetText struct {
	// StyleSheetID ...
	StyleSheetID CSSStyleSheetID `json:"styleSheetId"`

	// Text ...
	Text string `json:"text"`
}

// ProtoReq name.
func (m CSSSetStyleSheetText) ProtoReq() string { return "CSS.setStyleSheetText" }

// Call the request.
func (m CSSSetStyleSheetText) Call(c Client) (*CSSSetStyleSheetTextResult, error) {
	var res CSSSetStyleSheetTextResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// CSSSetStyleSheetTextResult ...
type CSSSetStyleSheetTextResult struct {
	// SourceMapURL (optional) URL of source map associated with script (if any).
	SourceMapURL string `json:"sourceMapURL,omitempty"`
}

// CSSSetStyleTexts Applies specified style edits one after another in the given order.
type CSSSetStyleTexts struct {
	// Edits ...
	Edits []*CSSStyleDeclarationEdit `json:"edits"`

	// NodeForPropertySyntaxValidation (experimental) (optional) NodeId for the DOM node in whose context custom property declarations for registered properties should be
	// validated. If omitted, declarations in the new rule text can only be validated statically, which may produce
	// incorrect results if the declaration contains a var() for example.
	NodeForPropertySyntaxValidation DOMNodeID `json:"nodeForPropertySyntaxValidation,omitempty"`
}

// ProtoReq name.
func (m CSSSetStyleTexts) ProtoReq() string { return "CSS.setStyleTexts" }

// Call the request.
func (m CSSSetStyleTexts) Call(c Client) (*CSSSetStyleTextsResult, error) {
	var res CSSSetStyleTextsResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// CSSSetStyleTextsResult ...
type CSSSetStyleTextsResult struct {
	// Styles The resulting styles after modification.
	Styles []*CSSCSSStyle `json:"styles"`
}

// CSSStartRuleUsageTracking Enables the selector recording.
type CSSStartRuleUsageTracking struct{}

// ProtoReq name.
func (m CSSStartRuleUsageTracking) ProtoReq() string { return "CSS.startRuleUsageTracking" }

// Call sends the request.
func (m CSSStartRuleUsageTracking) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// CSSStopRuleUsageTracking Stop tracking rule usage and return the list of rules that were used since last call to
// `takeCoverageDelta` (or since start of coverage instrumentation).
type CSSStopRuleUsageTracking struct{}

// ProtoReq name.
func (m CSSStopRuleUsageTracking) ProtoReq() string { return "CSS.stopRuleUsageTracking" }

// Call the request.
func (m CSSStopRuleUsageTracking) Call(c Client) (*CSSStopRuleUsageTrackingResult, error) {
	var res CSSStopRuleUsageTrackingResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// CSSStopRuleUsageTrackingResult ...
type CSSStopRuleUsageTrackingResult struct {
	// RuleUsage ...
	RuleUsage []*CSSRuleUsage `json:"ruleUsage"`
}

// CSSTakeCoverageDelta Obtain list of rules that became used since last call to this method (or since start of coverage
// instrumentation).
type CSSTakeCoverageDelta struct{}

// ProtoReq name.
func (m CSSTakeCoverageDelta) ProtoReq() string { return "CSS.takeCoverageDelta" }

// Call the request.
func (m CSSTakeCoverageDelta) Call(c Client) (*CSSTakeCoverageDeltaResult, error) {
	var res CSSTakeCoverageDeltaResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// CSSTakeCoverageDeltaResult ...
type CSSTakeCoverageDeltaResult struct {
	// Coverage ...
	Coverage []*CSSRuleUsage `json:"coverage"`

	// Timestamp Monotonically increasing time, in seconds.
	Timestamp float64 `json:"timestamp"`
}

// CSSSetLocalFontsEnabled (experimental) Enables/disables rendering of local CSS fonts (enabled by default).
type CSSSetLocalFontsEnabled struct {
	// Enabled Whether rendering of local fonts is enabled.
	Enabled bool `json:"enabled"`
}

// ProtoReq name.
func (m CSSSetLocalFontsEnabled) ProtoReq() string { return "CSS.setLocalFontsEnabled" }

// Call sends the request.
func (m CSSSetLocalFontsEnabled) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// CSSFontsUpdated Fires whenever a web font is updated.  A non-empty font parameter indicates a successfully loaded
// web font.
type CSSFontsUpdated struct {
	// Font (optional) The web font that has loaded.
	Font *CSSFontFace `json:"font,omitempty"`
}

// ProtoEvent name.
func (evt CSSFontsUpdated) ProtoEvent() string {
	return "CSS.fontsUpdated"
}

// CSSMediaQueryResultChanged Fires whenever a MediaQuery result changes (for example, after a browser window has been
// resized.) The current implementation considers only viewport-dependent media features.
type CSSMediaQueryResultChanged struct{}

// ProtoEvent name.
func (evt CSSMediaQueryResultChanged) ProtoEvent() string {
	return "CSS.mediaQueryResultChanged"
}

// CSSStyleSheetAdded Fired whenever an active document stylesheet is added.
type CSSStyleSheetAdded struct {
	// Header Added stylesheet metainfo.
	Header *CSSCSSStyleSheetHeader `json:"header"`
}

// ProtoEvent name.
func (evt CSSStyleSheetAdded) ProtoEvent() string {
	return "CSS.styleSheetAdded"
}

// CSSStyleSheetChanged Fired whenever a stylesheet is changed as a result of the client operation.
type CSSStyleSheetChanged struct {
	// StyleSheetID ...
	StyleSheetID CSSStyleSheetID `json:"styleSheetId"`
}

// ProtoEvent name.
func (evt CSSStyleSheetChanged) ProtoEvent() string {
	return "CSS.styleSheetChanged"
}

// CSSStyleSheetRemoved Fired whenever an active document stylesheet is removed.
type CSSStyleSheetRemoved struct {
	// StyleSheetID Identifier of the removed stylesheet.
	StyleSheetID CSSStyleSheetID `json:"styleSheetId"`
}

// ProtoEvent name.
func (evt CSSStyleSheetRemoved) ProtoEvent() string {
	return "CSS.styleSheetRemoved"
}
