
#if defined(RT_ARCH_AMD64) || defined(RT_ARCH_X86)
# pragma pack(1)
#endif
typedef struct RTMSGENTRYINT
{
    uint64_t offDefine   : 17; /* max 0x1bfd6 */
    uint64_t cchDefine   :  6; /* max 0x28 */
    uint64_t offMsgShort : 17; /* max 0x1bfdc */
    uint64_t cchMsgShort :  8; /* max 0x8e */
    int64_t  iCode       : 16;
} RTMSGENTRYINT;
typedef RTMSGENTRYINT *PCRTMSGENTRYINT;
#if defined(RT_ARCH_AMD64) || defined(RT_ARCH_X86)
# pragma pack()
#endif

static const RTMSGENTRYINT g_aStatusMsgs[ /*2478*/ ] =
{
    { 0x015b55,  18, 0x0027db,  60,   -27018 }, /* VERR_FDT_AT_ROOT_LEVEL */
    { 0x00e64f,  27, 0x0096d4,  36,   -27017 }, /* VERR_FDT_DTB_PROP_STRING_NOT_TERMINATED */
    { 0x00f8c2,  25, 0x005069,  49,   -27016 }, /* VERR_FDT_DTB_PROP_SIZE_MALFORMED */
    { 0x00d2bf,  29, 0x005c40,  46,   -27015 }, /* VERR_FDT_DTB_PROP_NAME_OFF_TOO_LARGE */
    { 0x0095d8,  36, 0x008df6,  37,   -27014 }, /* VERR_FDT_DTB_STRUCTS_BLOCK_PREMATURE_END */
    { 0x007c14,  40, 0x005460,  48,   -27013 }, /* VERR_FDT_DTB_STRUCTS_BLOCK_MALFORMED_PADDING */
    { 0x009aa0,  36, 0x007658,  41,   -27012 }, /* VERR_FDT_DTB_STRUCTS_BLOCK_STRING_NOT_TERMINATED */
    { 0x007bec,  40, 0x00b2ca,  32,   -27011 }, /* VERR_FDT_DTB_STRUCTS_BLOCK_NODE_NAME_INVALID */
    { 0x0099a4,  36, 0x009d5d,  35,   -27010 }, /* VERR_FDT_DTB_STRUCTS_BLOCK_TOKEN_INVALID */
    { 0x00a818,  34, 0x006f03,  42,   -27009 }, /* VERR_FDT_DTB_STRINGS_BLOCK_NOT_TERMINATED */
    { 0x009b0a,  35, 0x000a6b,  84,   -27008 }, /* VERR_FDT_DTB_MEM_RSV_BLOCK_TERMINATOR_MISSING */
    { 0x00874a,  38, 0x006f03,  42,   -27007 }, /* VERR_FDT_DTB_HDR_STRINGS_BLOCK_OFF_INVALID */
    { 0x008fd7,  37, 0x007443,  41,   -27006 }, /* VERR_FDT_DTB_HDR_STRUCT_BLOCK_OFF_INVALID */
    { 0x00887a,  38, 0x00560a,  47,   -27005 }, /* VERR_FDT_DTB_HDR_MEM_RSV_BLOCK_OFF_INVALID */
    { 0x011f13,  22, 0x00369e,  56,   -27004 }, /* VERR_FDT_DTB_HDR_SIZE_INVALID */
    { 0x00a152,  34, 0x0071cd,  42,   -27003 }, /* VERR_FDT_DTB_HDR_LAST_COMPAT_VERSION_INVALID */
    { 0x01686f,  17, 0x00c8ee,  30,   -27002 }, /* VERR_FDT_DTB_HDR_VERSION_NOT_SUPPORTED */
    { 0x00ee33,  26, 0x00d6c3,  28,   -27001 }, /* VERR_FDT_DTB_HDR_MAGIC_INVALID */
    { 0x0155c7,  18, 0x00cd15,  29,   -27000 }, /* VERR_FDT_DTB_MALFORMED */
    { 0x014bfc,  19, 0x01771a,  16,   -26820 }, /* VERR_HARDAVL_UNBALANCED */
    { 0x016e6c,  16, 0x0195d7,  13,   -26819 }, /* VERR_HARDAVL_BAD_HEIGHT */
    { 0x0132ce,  21, 0x00d813,  28,   -26818 }, /* VERR_HARDAVL_LOOKUP_TOO_DEEP */
    { 0x00ee67,  26, 0x003b22,  54,   -26817 }, /* VERR_HARDAVL_TRAVERSED_TOO_MANY_NODES */
    { 0x013b19,  20, 0x00cd4f,  29,   -26816 }, /* VERR_HARDAVL_UNEXPECTED_NULL_RIGHT */
    { 0x014acc,  19, 0x00d6df,  28,   -26815 }, /* VERR_HARDAVL_UNEXPECTED_NULL_LEFT */
    { 0x013989,  20, 0x0167e7,  17,   -26814 }, /* VERR_HARDAVL_BAD_NEW_HEIGHT */
    { 0x012660,  22, 0x01473c,  19,   -26813 }, /* VERR_HARDAVL_BAD_RIGHT_HEIGHT */
    { 0x01313f,  21, 0x015ec7,  18,   -26812 }, /* VERR_HARDAVL_BAD_LEFT_HEIGHT */
    { 0x00f2df,  26, 0x009bdc,  35,   -26811 }, /* VERR_HARDAVL_INSERT_INVALID_KEY_RANGE */
    { 0x011c0b,  23, 0x00af0a,  32,   -26810 }, /* VERR_HARDAVL_STACK_OVERFLOW */
    { 0x01328f,  21, 0x00d7db,  28,   -26804 }, /* VERR_HARDAVL_NODE_IS_FREE */
    { 0x00e1e1,  27, 0x009090,  37,   -26803 }, /* VERR_HARDAVL_MISALIGNED_POINTER */
    { 0x00cab0,  30, 0x0077a0,  41,   -26802 }, /* VERR_HARDAVL_POINTER_OUT_OF_BOUNDS */
    { 0x00d97f,  28, 0x010608,  24,   -26801 }, /* VERR_HARDAVL_INDEX_OUT_OF_BOUNDS */
    { 0x00cd89,  29, 0x003fbf,  53,   -26602 }, /* VERR_TRACELOG_READER_ITERATOR_END */
    { 0x00b7c9,  32, 0x017f41,  15,   -26601 }, /* VERR_TRACELOG_READER_LOG_UNSUPPORTED */
    { 0x00ca92,  30, 0x012752,  22,   -26600 }, /* VERR_TRACELOG_READER_MALFORMED_LOG */
    { 0x01034e,  25, 0x01164c,  23,   -26406 }, /* VERR_FTP_CLIENT_LIMIT_REACHED */
    { 0x01900b,  14, 0x01b353,   9,   -26405 }, /* VERR_FTP_CLIENT_NOT_FOUND */
    { 0x00dd8b,  28, 0x00b1ca,  32,   -26404 }, /* VERR_FTP_DATA_CONN_LIMIT_REACHED */
    { 0x016b5b,  17, 0x015a59,  18,   -26403 }, /* VERR_FTP_DATA_CONN_NOT_FOUND */
    { 0x0137cf,  21, 0x015a59,  18,   -26402 }, /* VERR_FTP_DATA_CONN_INIT_FAILED */
    { 0x01a8b7,  11, 0x013c45,  20,   -26401 }, /* VERR_FTP_INIT_FAILED */
    { 0x013add,  20, 0x01614f,  18,   -26400 }, /* VERR_FTP_STATUS_SERVER_ERROR */
    { 0x019a76,  13, 0x00493c,  50,   -26203 }, /* VERR_IOQUEUE_BUSY */
    { 0x018791,  14, 0x00175c,  68,   -26202 }, /* VERR_IOQUEUE_EMPTY */
    { 0x019a42,  13, 0x0061eb,  45,   -26201 }, /* VERR_IOQUEUE_FULL */
    { 0x00e8bc,  27, 0x008b72,  38,   -26200 }, /* VERR_IOQUEUE_HANDLE_NOT_REGISTERED */
    { 0x00bebb,  31, 0x00ea51,  27,   -26000 }, /* VERR_SHMEM_MAXIMUM_MAPPINGS_REACHED */
    { 0x011c7e,  23, 0x006a7d,  43,   -25811 }, /* VERR_CR_CIPHER_OSSL_SET_TAG_FAILED */
    { 0x0112cc,  23, 0x0068cf,  43,   -25810 }, /* VERR_CR_CIPHER_OSSL_GET_TAG_FAILED */
    { 0x014271,  20, 0x019b95,  12,   -25809 }, /* VERR_CR_CIPHER_INVALID_TAG_LENGTH */
    { 0x0088c6,  38, 0x00c984,  30,   -25808 }, /* VERR_CR_CIPHER_INVALID_INITIALIZATION_VECTOR_LENGTH */
    { 0x013bf5,  20, 0x019edd,  12,   -25807 }, /* VERR_CR_CIPHER_INVALID_KEY_LENGTH */
    { 0x00cca1,  29, 0x0154b9,  18,   -25806 }, /* VERR_CR_CIPHER_OSSL_DECRYPT_FINAL_FAILED */
    { 0x00c65a,  30, 0x014d9e,  19,   -25805 }, /* VERR_CR_CIPHER_OSSL_DECRYPT_UPDATE_FAILED */
    { 0x00ddfb,  28, 0x016297,  17,   -25804 }, /* VERR_CR_CIPHER_OSSL_DECRYPT_INIT_FAILED */
    { 0x00d07b,  29, 0x015bd3,  18,   -25803 }, /* VERR_CR_CIPHER_OSSL_ENCRYPT_FINAL_FAILED */
    { 0x00c3a8,  30, 0x015212,  19,   -25802 }, /* VERR_CR_CIPHER_OSSL_ENCRYPT_UPDATE_FAILED */
    { 0x00d5ff,  28, 0x016d59,  17,   -25801 }, /* VERR_CR_CIPHER_OSSL_ENCRYPT_INIT_FAILED */
    { 0x01a896,  11, 0x01b7fc,   8,   -25800 }, /* VERR_CR_CIPHER_NOT_SUPPORTED */
    { 0x01aae6,  10, 0x01bde5,   5,   -25799 }, /* VERR_REST_INTERNAL_ERROR_9 */
    { 0x01ab9a,  10, 0x01bed0,   5,   -25798 }, /* VERR_REST_INTERNAL_ERROR_8 */
    { 0x01ac76,  10, 0x01be53,   5,   -25797 }, /* VERR_REST_INTERNAL_ERROR_7 */
    { 0x01abae,  10, 0x01be08,   5,   -25796 }, /* VERR_REST_INTERNAL_ERROR_6 */
    { 0x01abb8,  10, 0x01bdf4,   5,   -25795 }, /* VERR_REST_INTERNAL_ERROR_5 */
    { 0x01abe0,  10, 0x01becb,   5,   -25794 }, /* VERR_REST_INTERNAL_ERROR_4 */
    { 0x01ac12,  10, 0x01be8f,   5,   -25793 }, /* VERR_REST_INTERNAL_ERROR_3 */
    { 0x01ac1c,  10, 0x01be1c,   5,   -25792 }, /* VERR_REST_INTERNAL_ERROR_2 */
    { 0x01ac6c,  10, 0x01bdc7,   5,   -25791 }, /* VERR_REST_INTERNAL_ERROR_1 */
    { 0x0099c8,  36, 0x00da7b,  28,   -25713 }, /* VERR_REST_REQUIRED_HEADER_PARAMETER_NOT_SET */
    { 0x009bb9,  35, 0x00a924,  33,   -25712 }, /* VERR_REST_REQUIRED_QUERY_PARAMETER_NOT_SET */
    { 0x010015,  25, 0x014f2d,  19,   -25711 }, /* VERR_REST_PATH_PARAMETER_NOT_SET */
    { 0x00f59d,  26, 0x0166a4,  17,   -25710 }, /* VERR_REST_UNABLE_TO_PARSE_STRING_AS_BOOL */
    { 0x00e7e4,  27, 0x014ab9,  19,   -25709 }, /* VERR_REST_WRONG_JSON_TYPE_FOR_DATE */
    { 0x0106f8,  24, 0x01831f,  15,   -25708 }, /* VERR_REST_WRONG_JSON_TYPE_FOR_STRING */
    { 0x00ce37,  29, 0x0135c2,  21,   -25707 }, /* VERR_REST_WRONG_JSON_TYPE_FOR_DOUBLE */
    { 0x00c894,  30, 0x012492,  22,   -25706 }, /* VERR_REST_WRONG_JSON_TYPE_FOR_INTEGER */
    { 0x00ed7b,  27, 0x014bb0,  19,   -25705 }, /* VERR_REST_WRONG_JSON_TYPE_FOR_BOOL */
    { 0x00e469,  27, 0x01863a,  15,   -25704 }, /* VERR_REST_UNABLE_TO_DECODE_DATE */
    { 0x00a4e8,  34, 0x005db0,  46,   -25703 }, /* VERR_REST_RESPONSE_REPEAT_HEADER_FIELD */
    { 0x00a9ea,  33, 0x006612,  44,   -25702 }, /* VERR_REST_RESPONSE_EMBEDDED_ZERO_CHAR */
    { 0x011d30,  22, 0x00ebe6,  27,   -25701 }, /* VERR_REST_RESPONSE_INVALID_UTF8_ENCODING */
    { 0x00ea87,  27, 0x006fd5,  42,   -25700 }, /* VERR_REST_RESPONSE_CONTENT_TYPE_NOT_SUPPORTED */
    { 0x012e36,  21, 0x0047a7,  51,   -25501 }, /* VERR_SERIALPORT_INVALID_BAUDRATE */
    { 0x00f10b,  26, 0x005b2c,  46,   -25500 }, /* VERR_SERIALPORT_BREAK_DETECTED */
    { 0x01bf92,   4, 0x01b6de,   6,   -25395 }, /* VERR_ISOFS_IPE_5 */
    { 0x01beda,   4, 0x01b91e,   6,   -25394 }, /* VERR_ISOFS_IPE_4 */
    { 0x01bede,   4, 0x01b85e,   6,   -25393 }, /* VERR_ISOFS_IPE_3 */
    { 0x01bf62,   4, 0x01b76e,   6,   -25392 }, /* VERR_ISOFS_IPE_2 */
    { 0x01bf82,   4, 0x01b6ce,   6,   -25391 }, /* VERR_ISOFS_IPE_1 */
    { 0x015d71,  18, 0x013766,  21,   -25390 }, /* VERR_ISOFS_UDF_NOT_IMPLEMENTED */
    { 0x012d25,  21, 0x004873,  51,   -25352 }, /* VERR_ISOFS_NO_ADS_FOR_UDF_OBJECT */
    { 0x01612b,  18, 0x008074,  39,   -25351 }, /* VERR_ISOFS_NO_ADS_FOR_UDF_DIR */
    { 0x016bc1,  17, 0x01728a,  16,   -25350 }, /* VERR_ISOFS_BOGUS_UDF_DIR_SIZE */
    { 0x00fd8b,  25, 0x00fc5f,  25,   -25349 }, /* VERR_ISOFS_BOGUS_UDF_DSTRING_FIELD */
    { 0x01887f,  14, 0x013d99,  20,   -25348 }, /* VERR_ISOFS_TOO_MANY_FILE_FRAGMENTS */
    { 0x00b0ea,  32, 0x0022ce,  63,   -25347 }, /* VERR_ISOFS_BOGUS_ALLOCATION_EXTENT_LENGTH */
    { 0x011f6b,  22, 0x004e1d,  49,   -25346 }, /* VERR_ISOFS_BOGUS_NEXT_AD_LENGTH */
    { 0x01bebc,   5, 0x0198fd,  13,   -25345 }, /* VERR_ISOFS_UNKNOWN_FILE_TYPE */
    { 0x01abcc,  10, 0x019b35,  12,   -25344 }, /* VERR_ISOFS_WRONG_FILE_TYPE */
    { 0x01b49c,   8, 0x007aab,  41,   -25343 }, /* VERR_ISOFS_BAD_EXTAD */
    { 0x01a762,  11, 0x015fb1,  18,   -25342 }, /* VERR_ISO_FS_UNKNOWN_AD_TYPE */
    { 0x01b2f0,   9, 0x01b314,   9,   -25341 }, /* VERR_ISOFS_BAD_FILE_ENTRY */
    { 0x01bc49,   6, 0x01a6b2,  11,   -25340 }, /* VERR_ISOFS_UNSUPPORTED_ICB */
    { 0x015b67,  18, 0x0091b8,  37,   -25339 }, /* VERR_ISOFS_ICB_ENTRY_TOO_SMALL */
    { 0x0129b3,  21, 0x011bc6,  23,   -25338 }, /* VERR_ISOFS_TOO_DEEP_ICB_RECURSION */
    { 0x0140e1,  20, 0x00809b,  39,   -25337 }, /* VERR_ISOFS_TOO_MANY_ICB_INDIRECTIONS */
    { 0x012b03,  21, 0x0132a4,  21,   -25336 }, /* VERR_ISOFS_NO_DIRECT_ICB_ENTRIES */
    { 0x019be9,  12, 0x018ad9,  14,   -25335 }, /* VERR_ISOFS_ICB_TOO_SMALL */
    { 0x01acbc,  10, 0x01a05d,  12,   -25334 }, /* VERR_ISOFS_ICB_TOO_BIG */
    { 0x016232,  17, 0x00b6ca,  32,   -25333 }, /* VERR_ISOFS_FSD_NEXT_EXTENT */
    { 0x0150bc,  19, 0x007371,  42,   -25332 }, /* VERR_ISOFS_FSD_ZERO_ROOT_DIR */
    { 0x0182c5,  15, 0x016781,  17,   -25331 }, /* VERR_ISOFS_FSD_UNSUPPORTED_CHAR_SET */
    { 0x015d4d,  18, 0x00cc67,  29,   -25330 }, /* VERR_ISOFS_INVALID_PARTITION_INDEX */
    { 0x014249,  20, 0x004b94,  50,   -25329 }, /* VERR_ISOFS_BAD_LVD_DESC_CHAR_SET */
    { 0x00fed0,  25, 0x00e15a,  27,   -25327 }, /* VERR_ISOFS_BAD_LVD_FILE_SET_DESC_LOCATION */
    { 0x0179da,  16, 0x00b58a,  32,   -25326 }, /* VERR_ISOFS_BAD_LVD_DOMAIN_ID */
    { 0x0154dd,  18, 0x00adc8,  33,   -25325 }, /* VERR_ISOFS_UNSUPPORTED_LOGICAL_BLOCK_SIZE */
    { 0x01b81c,   8, 0x004c8e,  50,   -25324 }, /* VERR_ISOFS_MPM_NOT_SUPPORTED */
    { 0x01b8ec,   8, 0x004a04,  50,   -25323 }, /* VERR_ISOFS_SPM_NOT_SUPPORTED */
    { 0x01b5e4,   8, 0x004eb0,  49,   -25322 }, /* VERR_ISOFS_VPM_NOT_SUPPORTED */
    { 0x0171aa,  16, 0x006afe,  43,   -25321 }, /* VERR_ISOFS_UNKNOWN_PART_MAP_TYPE_ID */
    { 0x0152bd,  19, 0x012ec9,  21,   -25320 }, /* VERR_ISOFS_UNKNOWN_PART_MAP_ENTRY_TYPE */
    { 0x00e7ae,  27, 0x006a52,  43,   -25319 }, /* VERR_ISOFS_INCOMPLETE_PART_MAP_TABLE */
    { 0x018cc3,  14, 0x007419,  42,   -25318 }, /* VERR_ISOFS_PARTITION_NOT_FOUND */
    { 0x00f78b,  26, 0x005a43,  47,   -25317 }, /* VERR_ISOFS_MALFORMED_PART_MAP_TABLE */
    { 0x019729,  13, 0x007125,  42,   -25316 }, /* VERR_ISOFS_TOO_MANY_PART_MAPS */
    { 0x017b09,  15, 0x002aa8,  59,   -25315 }, /* VERR_ISOFS_MULTIPLE_LVDS */
    { 0x018469,  15, 0x002a32,  59,   -25314 }, /* VERR_ISOFS_MULTIPLE_PVDS */
    { 0x01be6c,   5, 0x010cb0,  24,   -25313 }, /* VERR_ISOFS_NO_PD */
    { 0x01bc9d,   6, 0x0115f0,  23,   -25312 }, /* VERR_ISOFS_NO_LVD */
    { 0x01bd75,   6, 0x01171b,  23,   -25311 }, /* VERR_ISOFS_NO_PVD */
    { 0x012d79,  21, 0x00a9a8,  33,   -25310 }, /* VERR_ISOFS_TOO_BIG_PARTMAP_IN_LVD */
    { 0x01b98c,   7, 0x00e6f1,  27,   -25309 }, /* VERR_ISOFS_TOO_MANY_PDS */
    { 0x01b534,   8, 0x00f6ef,  26,   -25308 }, /* VERR_ISOFS_TOO_MANY_LVDS */
    { 0x01b47c,   8, 0x00f7a5,  26,   -25307 }, /* VERR_ISOFS_TOO_MANY_PVDS */
    { 0x01a5f7,  11, 0x0093e0,  36,   -25306 }, /* VERR_ISOFS_UNEXPECTED_VDS_DESC */
    { 0x00b2aa,  32, 0x00f7f3,  26,   -25305 }, /* VERR_ISOFS_INSUFFICIENT_DATA_FOR_DESC_CRC */
    { 0x019ca9,  12, 0x010d10,  24,   -25304 }, /* VERR_ISOFS_DESC_CRC_MISMATCH */
    { 0x0188c5,  14, 0x00b7e8,  32,   -25303 }, /* VERR_ISOFS_TAG_SECTOR_MISMATCH */
    { 0x018031,  15, 0x018289,  15,   -25302 }, /* VERR_ISOFS_BAD_TAG_CHECKSUM */
    { 0x01b914,   8, 0x018b11,  14,   -25301 }, /* VERR_ISOFS_UNSUPPORTED_TAG_VERSION */
    { 0x015669,  18, 0x00f13f,  26,   -25300 }, /* VERR_ISOFS_TAG_IS_ALL_ZEROS */
    { 0x015f7b,  18, 0x008b00,  38,   -25160 }, /* VERR_ISOMK_IMPORT_UDF_SPARSE_FILE */
    { 0x010b78,  24, 0x000f51,  74,   -25159 }, /* VERR_ISOMK_IMPORT_UDF_DISCONTIGUOUS_ADS */
    { 0x017b81,  15, 0x013fa1,  20,   -25158 }, /* VERR_ISOMK_IMPORT_UDF_DIR_TOO_BIG */
    { 0x00a350,  34, 0x000c04,  80,   -25157 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_CONTINUATION_EOS */
    { 0x007d54,  40, 0x000911,  88,   -25156 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_CONTINUATION_WITH_NONE */
    { 0x009e98,  35, 0x000860,  89,   -25155 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_EXT_ENTRY_END_OF_SECTOR */
    { 0x0090ff,  37, 0x00230d,  63,   -25154 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_EXT_ENTRY_UNDEFINED_FLAGS */
    { 0x00fa39,  25, 0x000cf2,  78,   -25153 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_EXT_ENTRY_INVALID_ID */
    { 0x00b9a5,  31, 0x0062cc,  45,   -25152 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_DEF_ENTRY_INVALID_BOOT_IND */
    { 0x00e4ba,  27, 0x0018f4,  68,   -25151 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_MISSING_FINAL_OR_TOO_BIG */
    { 0x00f417,  26, 0x0064de,  44,   -25150 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_UNKNOWN_IMAGE_SIZE */
    { 0x009149,  37, 0x0025f5,  61,   -25149 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_IMAGE_OUT_OF_BOUNDS */
    { 0x009e52,  35, 0x00798c,  41,   -25148 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_USES_UNUSED_FIELD */
    { 0x00c127,  31, 0x0085c9,  39,   -25147 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_RESERVED_FLAG */
    { 0x00d8bb,  28, 0x008665,  39,   -25146 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_DEF_ENTRY_INVALID_FLAGS */
    { 0x00f90d,  25, 0x008110,  39,   -25145 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_INVALID_BOOT_MEDIA_TYPE */
    { 0x012802,  22, 0x009f47,  35,   -25144 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_UNKNOWN_HEADER_ID */
    { 0x00ae6a,  32, 0x004543,  51,   -25143 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_BAD_VALIDATION_CHECKSUM */
    { 0x00de87,  28, 0x005cca,  46,   -25142 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_BAD_VALIDATION_KEYS */
    { 0x00ac3c,  33, 0x0046db,  51,   -25141 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_BAD_VALIDATION_HEADER_ID */
    { 0x00f3e3,  26, 0x008fb2,  37,   -25140 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_BAD_OUT_OF_BOUNDS */
    { 0x00c8b2,  30, 0x002e1d,  59,   -25133 }, /* VERR_ISOMK_IMPORT_NON_CONTIGUOUS_MULTI_EXTENT */
    { 0x00edb1,  26, 0x001a87,  66,   -25132 }, /* VERR_ISOMK_IMPORT_MISALIGNED_MULTI_EXTENT */
    { 0x00c146,  31, 0x0017a0,  68,   -25131 }, /* VERR_ISOMK_IMPORT_MISMATCHING_MULTI_EXTENT_REC */
    { 0x010920,  24, 0x00460f,  51,   -25130 }, /* VERR_ISOMK_IMPORT_DIR_WITH_MORE_EXTENTS */
    { 0x00e541,  20, 0x01b62c,   8,   -25129 }, /* VERR_ISOMK_IMPORT_DOT_DIR_REC_BAD_NAME */
    { 0x00e541,  27, 0x01b62c,   8,   -25128 }, /* VERR_ISOMK_IMPORT_DOT_DIR_REC_BAD_NAME_LENGTH */
    { 0x015dcb,  18, 0x00d8f3,  28,   -25127 }, /* VERR_ISOMK_IMPORT_BAD_DIR_REC_LENGTH */
    { 0x00b986,  31, 0x00c2f4,  30,   -25126 }, /* VERR_ISOMK_IMPORT_DIR_REC_EXTENT_OUT_OF_BOUNDS */
    { 0x0110cf,  24, 0x005bb6,  46,   -25125 }, /* VERR_ISOMK_IMPORT_DIR_REC_VOLUME_SEQ_NO */
    { 0x015dcb,  11, 0x0156d5,  18,   -25124 }, /* VERR_ISOMK_IMPORT_BAD_DIR_REC */
    { 0x016a8f,  17, 0x012a85,  21,   -25123 }, /* VERR_ISOMK_IMPORT_TOO_DEEP_DIR_TREE */
    { 0x00e340,  27, 0x00c858,  30,   -25122 }, /* VERR_ISOMK_IMPORT_ROOT_DIR_IS_MULTI_EXTENT */
    { 0x00dbcb,  28, 0x00ba7e,  31,   -25121 }, /* VERR_ISOMK_IMPORT_ROOT_DIR_WITHOUT_DIR_FLAG */
    { 0x011c22,  23, 0x00a966,  33,   -25120 }, /* VERR_ISOMK_IMPORT_BAD_ROOT_DIR_REC_LENGTH */
    { 0x00b888,  32, 0x00a790,  34,   -25119 }, /* VERR_ISOMK_IMPORT_ROOT_DIR_EXTENT_OUT_OF_BOUNDS */
    { 0x013727,  21, 0x00645a,  44,   -25118 }, /* VERR_ISOMK_IMPORT_ROOT_VOLUME_SEQ_NO */
    { 0x01243b,  22, 0x00b34a,  32,   -25117 }, /* VERR_ISOMK_IMPORT_ZERO_SIZED_ROOT_DIR */
    { 0x011c22,  16, 0x01140e,  23,   -25116 }, /* VERR_ISOMK_IMPORT_BAD_ROOT_DIR_REC */
    { 0x0156f9,  18, 0x00253c,  62,   -25115 }, /* VERR_ISOMK_IMPORT_VOLUME_IN_SET_MISMATCH */
    { 0x014feb,  19, 0x001e18,  64,   -25114 }, /* VERR_ISOMK_IMPORT_VOLUME_SPACE_SIZE_MISMATCH */
    { 0x015f69,  18, 0x00f4e7,  26,   -25113 }, /* VERR_ISOMK_IMPORT_INVALID_VOLUMNE_SEQ_NO */
    { 0x00c3c6,  30, 0x012bab,  21,   -25112 }, /* VERR_ISOMK_IMPORT_MORE_THAN_ONE_VOLUME_IN_SET */
    { 0x0118b9,  23, 0x0067f6,  44,   -25111 }, /* VERR_ISOMK_IMPORT_LOGICAL_BLOCK_SIZE_NOT_2KB */
    { 0x01976a,  13, 0x009a58,  36,   -25110 }, /* VERR_ISOMK_IMPORT_BAD_SUP_VOL_DESC */
    { 0x012989,  21, 0x007963,  41,   -25109 }, /* VERR_IOSMK_IMPORT_SUP_VOL_DESC_VER */
    { 0x013dd5,  20, 0x00c61e,  30,   -25108 }, /* VERR_ISOMK_IMPORT_BAD_PRIMARY_VOL_DESC */
    { 0x00d963,  28, 0x009e2f,  35,   -25107 }, /* VERR_IOSMK_IMPORT_PRIMARY_VOL_DESC_VER */
    { 0x00c0ca,  31, 0x004741,  51,   -25106 }, /* VERR_ISOMK_IMPORT_SUPPLEMENTARY_BEFORE_PRIMARY */
    { 0x00dab3,  28, 0x008dd1,  37,   -25105 }, /* VERR_ISOMK_IMPORT_MULTIPLE_JOLIET_VOL_DESCS */
    { 0x00e6a0,  27, 0x008443,  39,   -25104 }, /* VERR_ISOMK_IMPORT_MULTIPLE_EL_TORITO_DESCS */
    { 0x00cf76,  29, 0x008b98,  38,   -25103 }, /* VERR_ISOMK_IMPORT_MULTIPLE_PRIMARY_VOL_DESCS */
    { 0x01742a,  16, 0x014963,  19,   -25102 }, /* VERR_ISOMK_IMPORT_INVALID_VOL_DESC_HDR */
    { 0x018f1d,  14, 0x00bdc3,  31,   -25101 }, /* VERR_ISOMK_IMPORT_TOO_MANY_VOL_DESCS */
    { 0x01abd6,  10, 0x0098a8,  36,   -25100 }, /* VERR_ISOMK_IMPORT_UNKNOWN_FORMAT */
    { 0x01757a,  16, 0x00d502,  29,   -25029 }, /* VERR_ISOMK_RR_SPILL_FILE_FULL */
    { 0x0199e7,  13, 0x00a76e,  34,   -25028 }, /* VERR_ISOMK_IPE_FINALIZE_1 */
    { 0x018559,  15, 0x00e1c6,  27,   -25027 }, /* VERR_ISOMK_IPE_READ_FILE_DATA_3 */
    { 0x01845a,  15, 0x00e7ff,  27,   -25026 }, /* VERR_ISOMK_IPE_READ_FILE_DATA_2 */
    { 0x01850e,  15, 0x00ecf4,  27,   -25025 }, /* VERR_ISOMK_IPE_READ_FILE_DATA_1 */
    { 0x014451,  20, 0x00863e,  39,   -25024 }, /* VERR_ISOMK_IPE_PRODUCE_TRANS_TBL */
    { 0x01751a,  16, 0x00b8a8,  32,   -25023 }, /* VERR_ISOMK_IPE_BOOT_CAT_FILE */
    { 0x01a6c8,  11, 0x012299,  22,   -25022 }, /* VERR_ISOMK_IPE_BUFFER_SIZE */
    { 0x019492,  13, 0x00ac1b,  33,   -25021 }, /* VERR_ISOMK_IPE_DESC_COUNT */
    { 0x019a35,  13, 0x00c25d,  31,   -25020 }, /* VERR_ISOMK_IPE_ROOT_SLASH */
    { 0x015ea3,  18, 0x00e81a,  27,   -25019 }, /* VERR_ISOMK_IPE_EMPTY_COMPONENT */
    { 0x01934d,  13, 0x013193,  21,   -25018 }, /* VERR_ISOMK_IPE_EMPTY_PATH */
    { 0x018f39,  14, 0x00bf37,  31,   -25017 }, /* VERR_ISOMK_IPE_NAMESPACE_6 */
    { 0x018f55,  14, 0x00bb19,  31,   -25016 }, /* VERR_ISOMK_IPE_NAMESPACE_5 */
    { 0x018f71,  14, 0x00c0ab,  31,   -25015 }, /* VERR_ISOMK_IPE_NAMESPACE_4 */
    { 0x018f63,  14, 0x00bb57,  31,   -25014 }, /* VERR_ISOMK_IPE_NAMESPACE_3 */
    { 0x0186db,  14, 0x00c1c2,  31,   -25013 }, /* VERR_ISOMK_IPE_NAMESPACE_2 */
    { 0x0186e9,  14, 0x00ba9d,  31,   -25012 }, /* VERR_ISOMK_IPE_NAMESPACE_1 */
    { 0x01b5fc,   8, 0x00b8e8,  32,   -25011 }, /* VERR_ISOMK_IPE_TABLE */
    { 0x01ae2e,  10, 0x00a460,  34,   -25010 }, /* VERR_ISOMK_IPE_RR_READ */
    { 0x0157d1,  18, 0x00a87e,  34,   -25009 }, /* VERR_ISOMK_RR_NO_SPACE_FOR_CE */
    { 0x00f159,  26, 0x003586,  56,   -25008 }, /* VERR_ISOMK_SYMLINK_SUPPORT_DISABLED */
    { 0x010638,  24, 0x002ae3,  59,   -25007 }, /* VERR_ISOMK_SYMLINK_REQ_ROCK_RIDGE */
    { 0x012f9b,  21, 0x001dd8,  64,   -25006 }, /* VERR_ISOMK_FILE_TOO_BIG_REQ_ISO_LEVEL_3 */
    { 0x010a88,  24, 0x010860,  24,   -25005 }, /* VERR_ISOMK_BOOT_CAT_ERRATIC_ENTRY */
    { 0x012de2,  21, 0x00ad02,  33,   -25004 }, /* VERR_ISOMK_BOOT_CAT_INVALID_SECTION_SIZE */
    { 0x01268c,  22, 0x011cab,  23,   -25003 }, /* VERR_ISOMK_BOOT_CAT_EMPTY_ENTRY */
    { 0x00a2c8,  34, 0x01b3d1,   9,   -25002 }, /* VERR_ISOMK_BOOT_CAT_EXPECTED_SECTION_HEADER */
    { 0x00f8f4,  25, 0x00fa20,  25,   -25001 }, /* VERR_ISOMK_BOOT_CAT_NO_DEFAULT_ENTRY */
    { 0x00d7f7,  28, 0x00d66f,  28,   -25000 }, /* VERR_ISOMK_BOOT_CAT_NO_VALIDATION_ENTRY */
    { 0x01a015,  12, 0x005c9c,  46,   -24804 }, /* VERR_VFS_UNSUPPORTED_CREATE_TYPE */
    { 0x01aa96,  10, 0x0172ca,  16,   -24803 }, /* VERR_VFS_UNSUPPORTED_FORMAT */
    { 0x017fb9,  15, 0x00d36d,  29,   -24802 }, /* VERR_VFS_BOGUS_OFFSET */
    { 0x017c62,  15, 0x00d098,  29,   -24801 }, /* VERR_VFS_BOGUS_FORMAT */
    { 0x01ab36,  10, 0x01739a,  16,   -24800 }, /* VERR_VFS_UNKNOWN_FORMAT */
    { 0x0171ca,  16, 0x01a854,  11,   -24707 }, /* VERR_JSON_INVALID_CODEPOINT */
    { 0x00c330,  30, 0x00b12a,  32,   -24706 }, /* VERR_JSON_BAD_SURROGATE_PAIR_SEQUENCE */
    { 0x0125b0,  22, 0x00c4d4,  30,   -24705 }, /* VERR_JSON_MISSING_SURROGATE_PAIR */
    { 0x00de33,  28, 0x010698,  24,   -24704 }, /* VERR_JSON_INVALID_UTF16_ESCAPE_SEQUENCE */
    { 0x018ddb,  14, 0x012ca7,  21,   -24703 }, /* VERR_JSON_IS_EMPTY */
    { 0x017c53,  15, 0x00f709,  26,   -24702 }, /* VERR_JSON_MALFORMED */
    { 0x015aa1,  18, 0x011384,  23,   -24701 }, /* VERR_JSON_ITERATOR_END */
    { 0x019107,  14, 0x007e6c,  40,   -24700 }, /* VERR_JSON_VALUE_INVALID_TYPE */
    { 0x0195b0,  13, 0x00e95e,  27,   -24610 }, /* VERR_URI_NOT_FILE_SCHEME */
    { 0x00cec8,  29, 0x0029bb,  60,   -24609 }, /* VERR_URI_MISSING_UTF8_CONTINUATION_BYTE */
    { 0x0098f0,  36, 0x0030d7,  58,   -24608 }, /* VERR_URI_INVALID_ESCAPED_UTF8_CONTINUATION_BYTE */
    { 0x00da0b,  28, 0x0052b0,  48,   -24607 }, /* VERR_URI_INVALID_ESCAPED_UTF8_LEAD_BYTE */
    { 0x00c402,  30, 0x0060dd,  45,   -24606 }, /* VERR_URI_ESCAPED_CHARS_NOT_VALID_UTF8 */
    { 0x016bf4,  17, 0x00450f,  52,   -24605 }, /* VERR_URI_ESCAPED_ZERO */
    { 0x01777a,  16, 0x016276,  17,   -24604 }, /* VERR_URI_INVALID_ESCAPE_SEQ */
    { 0x0168a2,  17, 0x019a4f,  13,   -24603 }, /* VERR_URI_INVALID_PORT_NUMBER */
    { 0x01a285,  12, 0x01b4ac,   8,   -24602 }, /* VERR_URI_INVALID_SCHEME */
    { 0x01aa0c,  11, 0x00e1ab,  27,   -24601 }, /* VERR_URI_TOO_SHORT */
    { 0x01ac4e,  10, 0x01a1d1,  12,   -24600 }, /* VERR_URI_EMPTY */
    { 0x012516,  22, 0x00bafa,  31,   -24403 }, /* VERR_PATH_GLOB_UNKNOWN_CHAR_CLASS */
    { 0x00b66a,  32, 0x005340,  48,   -24402 }, /* VERR_PATH_MATCH_FEATURE_NOT_IMPLEMENTED */
    { 0x01373c,  21, 0x017e6f,  15,   -24400 }, /* VERR_PATH_MATCH_UNKNOWN_VARIABLE */
    { 0x012500,  22, 0x008d3a,  38,   -24399 }, /* VERR_CR_MALFORMED_PEM_HEADER */
    { 0x01ab0e,  10, 0x005929,  47,   -24398 }, /* VERR_CR_RANDOM_FAILED */
    { 0x0177aa,  16, 0x005929,  47,   -24397 }, /* VERR_CR_RANDOM_SETUP_FAILED */
    { 0x00c4b6,  30, 0x00cb62,  29,   -24396 }, /* VERR_CR_PASSWORD_2_KEY_DERIVIATION_FAILED */
    { 0x017a9a,  16, 0x00ce54,  29,   -24395 }, /* VERR_CR_OPENSSL_VERSION_TOO_OLD */
    { 0x01bdd1,   5, 0x009914,  36,   -24205 }, /* VERR_CR_DIGEST_NOT_SUPPORTED */
    { 0x011bf4,  23, 0x00d573,  28,   -24204 }, /* VERR_CR_DIGEST_SEVERELY_COMPROMISED */
    { 0x018ef3,  14, 0x01474f,  19,   -24203 }, /* VERR_CR_DIGEST_COMPROMISED */
    { 0x0198af,  13, 0x015ae9,  18,   -24202 }, /* VERR_CR_DIGEST_DEPRECATED */
    { 0x0148a5,  19, 0x00ea6c,  27,   -24201 }, /* VERR_CR_DIGEST_OSSL_DIGEST_CTX_COPY_ERROR */
    { 0x01832e,  15, 0x00b4aa,  32,   -24200 }, /* VERR_CR_DIGEST_OSSL_DIGEST_INIT_ERROR */
    { 0x010222,  25, 0x005aa1,  47,   -24002 }, /* VERR_BIGNUM_NEGATIVE_EXPONENT */
    { 0x015238,  19, 0x01205d,  22,   -24001 }, /* VERR_BIGNUM_DIV_BY_ZERO */
    { 0x011b53,  23, 0x0021d2,  63,   -24000 }, /* VERR_BIGNUM_SENSITIVE_INPUT */
    { 0x017d7f,  15, 0x01bd4b,   6,   -23900 }, /* VERR_CR_RSA_GENERIC_ERROR */
    { 0x014d78,  19, 0x00a5d6,  34,   -23819 }, /* VERR_CR_KEY_ALGO_PARAMS_MISMATCH */
    { 0x00fd40,  25, 0x009124,  37,   -23818 }, /* VERR_CR_KEY_ALGO_PARAMS_UNKNOWN */
    { 0x014d2c,  19, 0x00758b,  41,   -23817 }, /* VERR_CR_KEY_ALGO_PARAMS_MISSING */
    { 0x00e063,  28, 0x00f243,  26,   -23816 }, /* VERR_CR_KEY_ALGO_PARAMS_UNEXPECTED */
    { 0x01860d,  15, 0x01486c,  19,   -23815 }, /* VERR_CR_KEY_GEN_FAILED_RSA */
    { 0x015fe7,  18, 0x0036d6,  56,   -23813 }, /* VERR_CR_KEY_DECRYPTION_FAILED */
    { 0x00fe9e,  25, 0x013871,  20,   -23812 }, /* VERR_CR_KEY_OSSL_DECRYPT_INIT_ERROR */
    { 0x0171ea,  16, 0x0098cc,  36,   -23811 }, /* VERR_CR_KEY_PASSWORD_ENCODING */
    { 0x00fcf5,  25, 0x003eb6,  53,   -23810 }, /* VERR_CR_KEY_MALFORMED_CIPHER_IV */
    { 0x01290a,  22, 0x00426b,  52,   -23809 }, /* VERR_CR_KEY_TOO_SHORT_CIPHER_IV */
    { 0x012a31,  21, 0x007fac,  40,   -23808 }, /* VERR_CR_KEY_MISSING_CIPHER_PARAMS */
    { 0x013b7d,  20, 0x0049d2,  50,   -23807 }, /* VERR_CR_KEY_UNEXPECTED_CIPHER_PARAMS */
    { 0x019820,  13, 0x011311,  23,   -23806 }, /* VERR_CR_KEY_UNSUPPORTED_CIPHER */
    { 0x014dfd,  19, 0x015a23,  18,   -23805 }, /* VERR_CR_KEY_DECRYPTION_NOT_SUPPORTED */
    { 0x01411d,  20, 0x00786d,  41,   -23804 }, /* VERR_CR_KEY_DEK_INFO_TOO_LONG */
    { 0x0184a5,  15, 0x00138f,  71,   -23803 }, /* VERR_CR_KEY_NO_DEK_INFO */
    { 0x018199,  15, 0x008dac,  37,   -23802 }, /* VERR_CR_KEY_ENCRYPTED */
    { 0x018211,  15, 0x019c0d,  12,   -23801 }, /* VERR_CR_KEY_FORMAT_NOT_SUPPORTED */
    { 0x01b8ac,   8, 0x00e217,  27,   -23800 }, /* VERR_CR_KEY_UNKNOWN_TYPE */
    { 0x016693,  17, 0x01b894,   8,   -23700 }, /* VERR_CR_STORE_GENERIC_ERROR */
    { 0x00df9f,  28, 0x00ad65,  33,   -23527 }, /* VERR_CR_PKIX_OSSL_D2I_KEY_PARAMS_FAILED */
    { 0x0105d8,  24, 0x0157f5,  18,   -23526 }, /* VERR_CR_PKIX_NOT_ECDSA_PUBLIC_KEY */
    { 0x00f958,  25, 0x014d52,  19,   -23525 }, /* VERR_CR_PKIX_NOT_ECDSA_PRIVATE_KEY */
    { 0x012047,  22, 0x01744a,  16,   -23524 }, /* VERR_CR_PKIX_NOT_RSA_PUBLIC_KEY */
    { 0x011607,  23, 0x016caf,  17,   -23523 }, /* VERR_CR_PKIX_NOT_RSA_PRIVATE_KEY */
    { 0x00bd66,  29, 0x00916e,  37,   -23522 }, /* VERR_CR_PKIX_OSSL_VS_IPRT_SIGNATURE */
    { 0x00bd66,  31, 0x00714f,  42,   -23521 }, /* VERR_CR_PKIX_OSSL_VS_IPRT_SIGNATURE_SIZE */
    { 0x010b30,  24, 0x00d51f,  28,   -23520 }, /* VERR_CR_PKIX_OSSL_SIGN_FINAL_FAILED */
    { 0x00ca56,  30, 0x00637e,  44,   -23519 }, /* VERR_CR_PKIX_OSSL_EVP_PKEY_RSA_PAD_ERROR */
    { 0x00cf3c,  29, 0x00ca38,  30,   -23518 }, /* VERR_CR_PKIX_OSSL_D2I_PRIVATE_KEY_FAILED */
    { 0x010800,  24, 0x01029f,  25,   -23517 }, /* VERR_CR_PKIX_OSSL_EVP_PKEY_TYPE_ERROR */
    { 0x00dbaf,  28, 0x00d3a7,  29,   -23516 }, /* VERR_CR_PKIX_OSSL_D2I_PUBLIC_KEY_FAILED */
    { 0x00efb9,  26, 0x0136fd,  21,   -23515 }, /* VERR_CR_PKIX_OSSL_VERIFY_FINAL_FAILED */
    { 0x00c9de,  30, 0x0096f8,  36,   -23514 }, /* VERR_CR_PKIX_OSSL_CIPHER_ALOG_INIT_FAILED */
    { 0x00a3d8,  34, 0x008a8e,  38,   -23513 }, /* VERR_CR_PKIX_OSSL_CIPHER_ALGO_NOT_KNOWN_EVP */
    { 0x00a3d8,  30, 0x00c74a,  30,   -23512 }, /* VERR_CR_PKIX_OSSL_CIPHER_ALGO_NOT_KNOWN */
    { 0x00f8db,  25, 0x0145a5,  20,   -23511 }, /* VERR_CR_PKIX_CIPHER_ALGO_NOT_KNOWN */
    { 0x00bcea,  31, 0x00793a,  41,   -23510 }, /* VERR_CR_PKIX_CIPHER_ALGO_PARAMS_NOT_IMPL */
    { 0x016107,  18, 0x0063aa,  44,   -23509 }, /* VERR_CR_PKIX_SIGNATURE_MISMATCH */
    { 0x010b60,  24, 0x016065,  18,   -23508 }, /* VERR_CR_PKIX_INVALID_SIGNATURE_LENGTH */
    { 0x00ff02,  25, 0x01323b,  21,   -23507 }, /* VERR_CR_PKIX_SIGNATURE_NEGATIVE */
    { 0x01112f,  23, 0x00895e,  38,   -23506 }, /* VERR_CR_PKIX_SIGNATURE_GE_KEY */
    { 0x0123a1,  22, 0x00a0c8,  35,   -23505 }, /* VERR_CR_PKIX_SIGNATURE_TOO_LONG */
    { 0x010380,  25, 0x005a72,  47,   -23504 }, /* VERR_CR_PKIX_HASH_TOO_LONG_FOR_KEY */
    { 0x01b1c7,   9, 0x01bfd0,   2,   -23503 }, /* VERR_CR_PKIX_INTERNAL_ERROR */
    { 0x01b018,  10, 0x019d2d,  12,   -23502 }, /* VERR_CR_PKIX_UNKNOWN_DIGEST_TYPE */
    { 0x00a72a,  34, 0x003aec,  54,   -23501 }, /* VERR_CR_PKIX_SIGNATURE_TAKES_NO_PARAMETERS */
    { 0x0178ea,  16, 0x01b022,  10,   -23500 }, /* VERR_CR_PKIX_GENERIC_ERROR */
    { 0x01201b,  22, 0x009cf4,  35,   -23416 }, /* VERR_CR_SPC_PEIMAGE_NO_CONTENT */
    { 0x00dfd7,  28, 0x013911,  20,   -23415 }, /* VERR_CR_SPC_PEIMAGE_URL_UNEXPECTED */
    { 0x0107a0,  24, 0x01532f,  19,   -23414 }, /* VERR_CR_SPC_PEIMAGE_UNKNOWN_ATTRIBUTE */
    { 0x00b24a,  32, 0x00f0a3,  26,   -23413 }, /* VERR_CR_SPC_PEIMAGE_MULTIPLE_HASH_TABS */
    { 0x015309,  19, 0x00fb97,  25,   -23412 }, /* VERR_CR_SPC_MONIKER_BAD_DATA */
    { 0x012e60,  21, 0x010b90,  24,   -23411 }, /* VERR_CR_SPC_BAD_MONIKER_CHOICE */
    { 0x014f53,  19, 0x014a93,  19,   -23410 }, /* VERR_CR_SPC_UNKNOWN_MONIKER_UUID */
    { 0x0149fb,  19, 0x00fd0e,  25,   -23409 }, /* VERR_CR_SPC_BAD_MONIKER_UUID */
    { 0x00ea1b,  27, 0x012bff,  21,   -23408 }, /* VERR_CR_SPC_PEIMAGE_DATA_NOT_PRESENT */
    { 0x00d5e3,  28, 0x00c8d0,  30,   -23407 }, /* VERR_CR_SPC_EXPECTED_PE_IMAGE_DATA */
    { 0x014fb2,  19, 0x00934f,  37,   -23406 }, /* VERR_CR_SPC_IND_DATA_DIGEST_SIZE_MISMATCH */
    { 0x01a081,  12, 0x017b54,  15,   -23405 }, /* VERR_CR_SPC_UNKNOWN_DIGEST_ALGO */
    { 0x00bc11,  31, 0x002250,  63,   -23404 }, /* VERR_CR_SPC_IND_DATA_DIGEST_ALGO_NOT_IN_DIGEST_ALGOS */
    { 0x00cee5,  29, 0x005eee,  45,   -23403 }, /* VERR_CR_SPC_SIGNED_IND_DATA_DIGEST_ALGO_MISMATCH */
    { 0x010c38,  24, 0x001b4d,  66,   -23402 }, /* VERR_CR_SPC_NOT_EXACTLY_ONE_DIGEST_ALGO */
    { 0x00be3f,  31, 0x004d24,  50,   -23401 }, /* VERR_CR_SPC_NOT_EXACTLY_ONE_SIGNER_INFOS */
    { 0x018685,  15, 0x01bcb5,   6,   -23400 }, /* VERR_CR_SPC_GENERIC_ERROR */
    { 0x00e29e,  27, 0x019f25,  12,   -23310 }, /* VERR_CR_PKCS7_SIGNATURE_VERIFICATION_FAILED */
    { 0x014b8a,  19, 0x003387,  57,   -23309 }, /* VERR_CR_PKCS7_BAD_MESSAGE_DIGEST_ATTRIB */
    { 0x0140f5,  20, 0x003516,  56,   -23308 }, /* VERR_CR_PKCS7_MESSAGE_DIGEST_ATTRIB_MISMATCH */
    { 0x013bb9,  20, 0x001718,  68,   -23307 }, /* VERR_CR_PKCS7_MISSING_MESSAGE_DIGEST_ATTRIB */
    { 0x01448d,  20, 0x0034a4,  57,   -23306 }, /* VERR_CR_PKCS7_BAD_CONTENT_TYPE_ATTRIB */
    { 0x0131e7,  21, 0x0031bf,  57,   -23305 }, /* VERR_CR_PKCS7_CONTENT_TYPE_ATTRIB_MISMATCH */
    { 0x0133ca,  21, 0x0018b0,  68,   -23304 }, /* VERR_CR_PKCS7_MISSING_CONTENT_TYPE_ATTRIB */
    { 0x0189cf,  14, 0x00b1aa,  32,   -23303 }, /* VERR_CR_PKCS7_KEY_USAGE_MISMATCH */
    { 0x011cd8,  22, 0x01a552,  11,   -23302 }, /* VERR_CR_PKCS7_SIGNED_DATA_CERT_NOT_FOUND */
    { 0x0174ca,  16, 0x008137,  39,   -23301 }, /* VERR_CR_PKCS7_NO_SIGNER_INFOS */
    { 0x01a11d,  12, 0x01b022,  10,   -23300 }, /* VERR_CR_PKCS7_GENERIC_ERROR */
    { 0x00fe6c,  25, 0x00b272,  24,   -23109 }, /* VERR_X509_NOT_SELFSIGNED_CERTIFICATE */
    { 0x00a708,  34, 0x01b524,   8,   -23108 }, /* VERR_X509_CERTIFICATE_VERIFICATION_FAILURE */
    { 0x0105f0,  24, 0x011b3c,  23,   -23107 }, /* VERR_X509_PRINT_EXTENSION_TO_BIO */
    { 0x00cdfd,  29, 0x00e0b7,  28,   -23106 }, /* VERR_X509_GETTING_DATA_FROM_EXTENSION */
    { 0x00d3e1,  29, 0x008a42,  38,   -23105 }, /* VERR_X509_GETTING_EXTENSION_FROM_CERT */
    { 0x012a9a,  21, 0x010367,  25,   -23104 }, /* VERR_X509_NO_BASIC_CONSTARAINTS */
    { 0x00f757,  26, 0x019f25,  12,   -23103 }, /* VERR_X509_RSA_VERIFICATION_FUILURE */
    { 0x00ccf8,  29, 0x00ab34,  33,   -23102 }, /* VERR_X509_EXTRACT_RSA_FROM_PUBLIC_KEY */
    { 0x00f66d,  26, 0x006879,  43,   -23101 }, /* VERR_X509_EXTRACT_PUBKEY_FROM_CERT */
    { 0x011874,  23, 0x00aab0,  33,   -23100 }, /* VERR_X509_READING_CERT_FROM_BIO */
    { 0x019a1b,  13, 0x015c09,  18,   -23090 }, /* VERR_CR_X509_OSSL_D2I_FAILED */
    { 0x0175da,  16, 0x00fb1a,  25,   -23037 }, /* VERR_CR_X509_CPB_BAD_CERT_CTX */
    { 0x00b1ea,  32, 0x003666,  56,   -23036 }, /* VERR_CR_X509_CPV_UNEXP_GENERAL_SUBTREE_MAX */
    { 0x00af4a,  32, 0x0035be,  56,   -23035 }, /* VERR_CR_X509_CPV_UNEXP_GENERAL_SUBTREE_MIN */
    { 0x009b2d,  35, 0x003cd2,  54,   -23034 }, /* VERR_CR_X509_CPV_UNEXP_GENERAL_SUBTREE_CHOICE */
    { 0x012bea,  21, 0x01143c,  23,   -23033 }, /* VERR_CR_X509_CPV_NOT_VALID_AT_TIME */
    { 0x01805e,  15, 0x00385c,  55,   -23032 }, /* VERR_CR_X509_CPV_ISSUER_MISMATCH */
    { 0x00f47f,  26, 0x00509a,  49,   -23031 }, /* VERR_CR_X509_CPV_ALT_NAME_NOT_PERMITTED */
    { 0x0122db,  22, 0x009271,  37,   -23030 }, /* VERR_CR_X509_CPV_NAME_NOT_PERMITTED */
    { 0x011328,  23, 0x008f43,  37,   -23029 }, /* VERR_CR_X509_CPV_NO_PERMITTED_NAMES */
    { 0x01256e,  22, 0x0082bd,  39,   -23028 }, /* VERR_CR_X509_CPV_INVALID_POLICY_MAPPING */
    { 0x017b90,  15, 0x009374,  36,   -23027 }, /* VERR_CR_X509_CPV_NOT_V3_CERT */
    { 0x017b45,  15, 0x0057e0,  47,   -23026 }, /* VERR_CR_X509_CPV_NOT_CA_CERT */
    { 0x012676,  22, 0x0048d8,  50,   -23025 }, /* VERR_CR_X509_CPV_MAX_PATH_LENGTH */
    { 0x0123cd,  22, 0x004c5c,  50,   -23024 }, /* VERR_CR_X509_CPV_MISSING_KEY_CERT_SIGN */
    { 0x00edcb,  26, 0x010eef,  24,   -23023 }, /* VERR_CR_X509_CPV_UNKNOWN_CRITICAL_EXTENSION */
    { 0x013a3d,  20, 0x015861,  18,   -23022 }, /* VERR_CR_X509_CPV_NO_VALID_POLICY */
    { 0x012920,  21, 0x0147ae,  19,   -23021 }, /* VERR_CR_X509_CPV_NO_TRUSTED_PATHS */
    { 0x011356,  23, 0x005c6e,  46,   -23020 }, /* VERR_CR_X509_NAME_MISSING_RDN_MAP_ENTRY */
    { 0x00c56a,  30, 0x013019,  21,   -23019 }, /* VERR_CR_X509_TBSCERT_DUPLICATE_EXTENSION */
    { 0x0151ff,  19, 0x00aeaa,  32,   -23018 }, /* VERR_CR_X509_VALIDITY_SWAPPED */
    { 0x01356e,  21, 0x010ed7,  24,   -23017 }, /* VERR_CR_X509_NAME_EMPTY_SUB_SET */
    { 0x0165e9,  17, 0x015141,  19,   -23016 }, /* VERR_CR_X509_NAME_EMPTY_SET */
    { 0x01ade8,  10, 0x01836a,  15,   -23015 }, /* VERR_CR_X509_NAME_NOT_STRING */
    { 0x0181e4,  15, 0x01b05e,  10,   -23014 }, /* VERR_CR_X509_NAME_EMPTY_STRING */
    { 0x01879f,  14, 0x01a43f,  11,   -23013 }, /* VERR_CR_X509_INVALID_NAME_STRING_TAG */
    { 0x0143d9,  20, 0x014e5c,  19,   -23012 }, /* VERR_CR_X509_PUBLIC_KEY_TOO_SMALL */
    { 0x019999,  13, 0x01bf9a,   3,   -23011 }, /* VERR_CR_X509_TBSCERT_UNSUPPORTED_VERSION */
    { 0x008ada,  38, 0x00ceab,  29,   -23010 }, /* VERR_CR_X509_TBSCERT_SERIAL_NUMBER_OUT_OF_BOUNDS */
    { 0x00debf,  28, 0x0082e4,  39,   -23009 }, /* VERR_CR_X509_TBSCERT_UNIQUE_IDS_REQ_V2 */
    { 0x0128c8,  22, 0x00b50a,  32,   -23008 }, /* VERR_CR_X509_TBSCERT_EXTS_REQ_V3 */
    { 0x0119cd,  23, 0x00157b,  69,   -23007 }, /* VERR_CR_X509_CERT_TBS_SIGN_ALGO_MISMATCH */
    { 0x014c48,  19, 0x013361,  21,   -23006 }, /* VERR_CR_X509_CERT_SIGN_ALGO_MISMATCH */
    { 0x0158cd,  18, 0x01bfac,   3,   -23005 }, /* VERR_CR_X509_UNKNOWN_CERT_SIGN_ALGO */
    { 0x0179ba,  16, 0x014041,  20,   -23004 }, /* VERR_CR_X509_NO_TRUST_ANCHOR */
    { 0x019e95,  12, 0x014a34,  19,   -23003 }, /* VERR_CR_X509_NOT_VERIFIED */
    { 0x01843c,  15, 0x01bcfd,   6,   -23002 }, /* VERR_CR_X509_CERTPATHS_INTERNAL_ERROR */
    { 0x01be62,   5, 0x01bcfd,   6,   -23001 }, /* VERR_CR_X509_INTERNAL_ERROR */
    { 0x01a23d,  12, 0x01bfb2,   3,   -23000 }, /* VERR_CR_X509_GENERIC_ERROR */
    { 0x00cfea,  29, 0x00d455,  29,   -22992 }, /* VERR_LDRLX_IMPORT_ORDINAL_OUT_OF_BOUNDS */
    { 0x01570b,  18, 0x00caec,  30,   -22991 }, /* VERR_LDRLX_NRICHAIN_NOT_SUPPORTED */
    { 0x016660,  17, 0x016ab1,  17,   -22990 }, /* VERR_LDRLX_BAD_FORWARDER */
    { 0x019051,  14, 0x01b5d4,   8,   -22989 }, /* VERR_LDRLX_BAD_SONAME */
    { 0x018d41,  14, 0x01b744,   8,   -22988 }, /* VERR_LDRLX_NO_SONAME */
    { 0x018e75,  14, 0x0199f4,  13,   -22987 }, /* VERR_LDRLX_BAD_BUNDLE */
    { 0x016a4b,  17, 0x00e592,  27,   -22986 }, /* VERR_LDRLX_BAD_ITERDATA2 */
    { 0x016a4b,  16, 0x0103b2,  25,   -22985 }, /* VERR_LDRLX_BAD_ITERDATA */
    { 0x01a399,  12, 0x00f9a3,  25,   -22984 }, /* VERR_LDRLX_BAD_PAGE_MAP */
    { 0x013b05,  20, 0x015400,  19,   -22983 }, /* VERR_LDRLX_BAD_OBJECT_TABLE */
    { 0x012bc0,  21, 0x0092e0,  37,   -22982 }, /* VERR_LDRLX_BAD_FIXUP_SECTION */
    { 0x011f97,  22, 0x00b52a,  32,   -22981 }, /* VERR_LDRLX_BAD_LOADER_SECTION */
    { 0x018713,  14, 0x0168d5,  17,   -22980 }, /* VERR_LDRLX_BAD_HEADER */
    { 0x01327a,  21, 0x01651d,  17,   -22979 }, /* VERR_LDR_ADDRESS_OVERFLOW */
    { 0x01a65a,  11, 0x019319,  13,   -22978 }, /* VERR_LDR_BAD_FIXUP */
    { 0x0179aa,  16, 0x01bbc3,   7,   -22977 }, /* VERR_LDR_NO_IMAGE_UUID */
    { 0x00eaf3,  27, 0x01154f,  23,   -22976 }, /* VERR_LDR_DUPLICATE_SEGMENT_NAME */
    { 0x01a880,  11, 0x00da43,  28,   -22975 }, /* VERR_LDRMACHO_BAD_SYMTAB_SIZE */
    { 0x01bc97,   6, 0x00e3fd,  27,   -22974 }, /* VERR_LDRMACHO_TODO */
    { 0x014b3e,  19, 0x007f34,  40,   -22973 }, /* VERR_LDRMACHO_NON_CONT_SEG_BITS */
    { 0x00ebb0,  27, 0x007d2c,  40,   -22972 }, /* VERR_LDRMACHO_MIXED_DEBUG_SECTION_FLAGS */
    { 0x01ab2c,  10, 0x019c31,  12,   -22971 }, /* VERR_LDRMACHO_UNSUPPORTED_FIXUP_TYPE */
    { 0x01b206,   9, 0x0184f0,  15,   -22970 }, /* VERR_LDRMACHO_BAD_SYMBOL */
    { 0x019115,  14, 0x01706b,  16,   -22969 }, /* VERR_LDRMACHO_BAD_OBJECT_FILE */
    { 0x01b152,   9, 0x006056,  45,   -22968 }, /* VERR_LDRMACHO_BIT_MIX */
    { 0x01758a,  16, 0x005987,  47,   -22967 }, /* VERR_LDRMACHO_BAD_SECTION_ORDER */
    { 0x01ab18,  10, 0x00d8d7,  28,   -22966 }, /* VERR_LDRMACHO_UNKNOWN_SECTION */
    { 0x0183f1,  15, 0x00fe08,  25,   -22965 }, /* VERR_LDRMACHO_UNSUPPORTED_TERM_SECTION */
    { 0x0180d6,  15, 0x0101d7,  25,   -22964 }, /* VERR_LDRMACHO_UNSUPPORTED_INIT_SECTION */
    { 0x01ad48,  10, 0x0104de,  25,   -22963 }, /* VERR_LDRMACHO_UNSUPPORTED_SECTION */
    { 0x01758a,  10, 0x01b31d,   9,   -22962 }, /* VERR_LDRMACHO_BAD_SECTION */
    { 0x01833d,  15, 0x00968c,  36,   -22961 }, /* VERR_LDRMACHO_UNSUPPORTED_LOAD_COMMAND */
    { 0x017c44,  15, 0x011b98,  23,   -22960 }, /* VERR_LDRMACHO_UNKNOWN_LOAD_COMMAND */
    { 0x018658,  15, 0x016210,  17,   -22959 }, /* VERR_LDRMACHO_BAD_LOAD_COMMAND */
    { 0x01afdc,  10, 0x004576,  51,   -22958 }, /* VERR_LDRMACHO_UNSUPPORTED_MACHINE */
    { 0x01bec1,   5, 0x01ae7e,  10,   -22957 }, /* VERR_LDRMACHO_UNSUPPORTED_FILE_TYPE */
    { 0x01b44f,   9, 0x006f57,  42,   -22956 }, /* VERR_LDRMACHO_BAD_HEADER */
    { 0x0164d9,  17, 0x0090b5,  37,   -22955 }, /* VERR_LDRMACHO_OTHER_ENDIAN_NOT_SUPPORTED */
    { 0x016185,  18, 0x00a019,  35,   -22954 }, /* VERR_LDR_FORWARDERS_NOT_SUPPORTED */
    { 0x013505,  21, 0x009e75,  35,   -22953 }, /* VERR_LDR_FORWARDER_CHAIN_TOO_LONG */
    { 0x017e8d,  15, 0x00f4cd,  26,   -22952 }, /* VERR_LDR_BAD_FORWARDER */
    { 0x017df7,  15, 0x0127ec,  22,   -22951 }, /* VERR_LDR_NOT_FORWARDER */
    { 0x013505,  14, 0x007ffc,  40,   -22950 }, /* VERR_LDR_FORWARDER */
    { 0x0189b3,  14, 0x00ad86,  33,   -22930 }, /* VERR_LDRVI_BAD_CERT_FORMAT */
    { 0x018fa9,  14, 0x014299,  20,   -22929 }, /* VERR_LDRVI_IMAGE_HASH_MISMATCH */
    { 0x01b3da,   9, 0x014d3f,  19,   -22928 }, /* VERR_LDRVI_PAGE_HASH_MISMATCH */
    { 0x00a262,  34, 0x004203,  52,   -22927 }, /* VERR_PAGE_HASH_TAB_HASHES_NON_SECTION_DATA */
    { 0x00d82f,  28, 0x009bff,  35,   -22926 }, /* VERR_LDRVI_PAGE_HASH_TAB_NOT_STRICTLY_SORTED */
    { 0x01682b,  17, 0x006402,  44,   -22925 }, /* VERR_LDRVI_PAGE_HASH_TAB_TOO_LONG */
    { 0x0127d6,  22, 0x00fc91,  25,   -22924 }, /* VERR_LDRVI_PAGE_HASH_TAB_SIZE_OVERFLOW */
    { 0x009884,  36, 0x0011e2,  72,   -22923 }, /* VERR_LDRVI_EXPECTED_INDIRECT_DATA_CONTENT_OID */
    { 0x01b834,   8, 0x01a0c9,  12,   -22922 }, /* VERR_LDRVI_PARSE_BER_ERROR */
    { 0x01bd5d,   6, 0x00d717,  28,   -22921 }, /* VERR_LDRVI_PARSE_IPE */
    { 0x01bb29,   7, 0x0122af,  22,   -22919 }, /* VERR_LDRVI_UNSUPPORTED_ARCH */
    { 0x00fbe2,  25, 0x008024,  40,   -22918 }, /* VERR_LDRVI_MACHINE_OPT_HDR_MAGIC_MISMATCH */
    { 0x00fbb0,  25, 0x006dae,  43,   -22917 }, /* VERR_LDRVI_SECTION_RAW_DATA_VALUES */
    { 0x016f8b,  16, 0x017a8a,  16,   -22916 }, /* VERR_LDRVI_INVALID_SECTION_COUNT */
    { 0x019ec5,  12, 0x017a3a,  16,   -22915 }, /* VERR_LDRVI_BAD_MZ_OFFSET */
    { 0x01729a,  16, 0x00c72c,  30,   -22914 }, /* VERR_LDRVI_BAD_CERT_MULTIPLE */
    { 0x01923c,  13, 0x017a3a,  16,   -22913 }, /* VERR_LDRVI_BAD_CERT_HDR_TYPE */
    { 0x014285,  20, 0x017a3a,  16,   -22912 }, /* VERR_LDRVI_BAD_CERT_HDR_REVISION */
    { 0x015b1f,  18, 0x017a3a,  16,   -22911 }, /* VERR_LDRVI_BAD_CERT_HDR_LENGTH */
    { 0x0134db,  21, 0x00ff98,  25,   -22910 }, /* VERR_LDRVI_INVALID_SECURITY_DIR_ENTRY */
    { 0x019f55,  12, 0x0097d0,  36,   -22909 }, /* VERR_LDRVI_NO_MEMORY_PARSE_OUTPUT */
    { 0x01ae10,  10, 0x00bd47,  31,   -22908 }, /* VERR_LDRVI_NO_MEMORY_SHDRS */
    { 0x018b9d,  14, 0x004acc,  50,   -22907 }, /* VERR_LDRVI_NO_MEMORY_SIGNATURE */
    { 0x01bd03,   6, 0x00d557,  28,   -22906 }, /* VERR_LDRVI_NO_MEMORY_STATE */
    { 0x01a7a4,  11, 0x00c7e0,  30,   -22905 }, /* VERR_LDRVI_FILE_LENGTH_ERROR */
    { 0x01979e,  13, 0x00e979,  27,   -22904 }, /* VERR_LDRVI_READ_ERROR_HASH */
    { 0x0159ff,  18, 0x005f1b,  45,   -22903 }, /* VERR_LDRVI_READ_ERROR_SIGNATURE */
    { 0x018c53,  14, 0x00ee19,  26,   -22902 }, /* VERR_LDRVI_READ_ERROR_SHDRS */
    { 0x019bc5,  12, 0x00edff,  26,   -22901 }, /* VERR_LDRVI_READ_ERROR_HDR */
    { 0x01b1d0,   9, 0x00b4ea,  32,   -22900 }, /* VERR_LDRVI_NOT_SIGNED */
    { 0x01bcc7,   6, 0x01bf72,   4,   -22899 }, /* VERR_ASN1_INTERNAL_ERROR_5 */
    { 0x01bccd,   6, 0x01bf72,   4,   -22898 }, /* VERR_ASN1_INTERNAL_ERROR_4 */
    { 0x01bcd3,   6, 0x01bf72,   4,   -22897 }, /* VERR_ASN1_INTERNAL_ERROR_3 */
    { 0x01bbd1,   6, 0x01bf72,   4,   -22896 }, /* VERR_ASN1_INTERNAL_ERROR_2 */
    { 0x01bbd7,   6, 0x01bf72,   4,   -22895 }, /* VERR_ASN1_INTERNAL_ERROR_1 */
    { 0x019b05,  12, 0x01bfdc,   2,   -22857 }, /* VERR_ASN1_INVALID_INTEGER_ENCODING */
    { 0x01b389,   9, 0x016b39,  17,   -22856 }, /* VERR_ASN1_UNEXPECTED_OBJ_ID */
    { 0x01797a,  16, 0x01bfda,   2,   -22855 }, /* VERR_ASN1_TOO_DEEPLY_NESTED */
    { 0x01825c,  15, 0x015633,  18,   -22854 }, /* VERR_ASN1_INVALID_DATA_POINTER */
    { 0x013f15,  20, 0x01a1dd,  12,   -22853 }, /* VERR_ASN1_EXPECTED_PRIMITIVE */
    { 0x01bb76,   7, 0x0065e5,   1,   -22852 }, /* VERR_ASN1_TOO_LONG */
    { 0x018fb7,  14, 0x01bfd8,   2,   -22851 }, /* VERR_ASN1_DUMMY_OBJECT */
    { 0x019176,  14, 0x0065e5,   1,   -22850 }, /* VERR_ASN1_DYNTYPE_BAD_TAG */
    { 0x0150e2,  19, 0x017e42,  15,   -22849 }, /* VERR_ASN1_DYNTYPE_TAG_NOT_IMPL */
    { 0x0186f7,  14, 0x01bfdc,   2,   -22848 }, /* VERR_ASN1_INVALID_BITSTRING_ENCODING */
    { 0x01b1e2,   9, 0x01bfdc,   2,   -22847 }, /* VERR_ASN1_INVALID_NULL_ENCODING */
    { 0x019c49,  12, 0x01bfdc,   2,   -22846 }, /* VERR_ASN1_INVALID_BOOLEAN_ENCODING */
    { 0x0130ac,  21, 0x01bfdc,   2,   -22845 }, /* VERR_ASN1_INVALID_GENERALIZED_TIME_ENCODING */
    { 0x0191ba,  13, 0x01bfdc,   2,   -22844 }, /* VERR_ASN1_INVALID_UTC_TIME_ENCODING */
    { 0x0158bb,  18, 0x01710a,  16,   -22843 }, /* VERR_ASN1_TIME_NORMALIZE_MISMATCH */
    { 0x015873,  18, 0x019924,  13,   -22842 }, /* VERR_ASN1_TIME_NORMALIZE_ERROR */
    { 0x0118e7,  23, 0x01bfd2,   2,   -22841 }, /* VERR_ASN1_TIME_BAD_NORMALIZE_INPUT */
    { 0x010286,  25, 0x0065e5,   1,   -22840 }, /* VERR_ASN1_BITSTRING_OUT_OF_BOUNDS */
    { 0x00ffca,  25, 0x01bfd8,   2,   -22839 }, /* VERR_ASN1_CURSOR_TAG_FLAG_CLASS_MISMATCH */
    { 0x018a23,  14, 0x01bfd8,   2,   -22838 }, /* VERR_ASN1_CURSOR_TAG_MISMATCH */
    { 0x00c7fe,  30, 0x006fff,  42,   -22837 }, /* VERR_ASN1_CURSOR_ILLEGAL_CONSTRUCTED_STRING */
    { 0x00f1f5,  26, 0x018ffd,  14,   -22836 }, /* VERR_ASN1_CURSOR_TOO_LITTLE_DATA_LEFT */
    { 0x014833,  19, 0x019bd1,  12,   -22835 }, /* VERR_ASN1_CURSOR_NO_MORE_DATA */
    { 0x015e13,  16, 0x0065e5,   1,   -22834 }, /* VERR_ASN1_CURSOR_BAD_LENGTH */
    { 0x00ec88,  27, 0x00906b,  37,   -22833 }, /* VERR_ASN1_CURSOR_BAD_INDEFINITE_LENGTH */
    { 0x00a570,  34, 0x00852d,  39,   -22832 }, /* VERR_ASN1_CURSOR_ILLEGAL_INDEFINITE_LENGTH */
    { 0x015e13,  18, 0x01bfd2,   2,   -22831 }, /* VERR_ASN1_CURSOR_BAD_LENGTH_ENCODING */
    { 0x0168c4,  17, 0x01bca9,   6,   -22830 }, /* VERR_ASN1_CURSOR_LONG_TAG */
    { 0x0175ba,  16, 0x0065ba,  44,   -22829 }, /* VERR_ASN1_CURSOR_NOT_AT_END */
    { 0x01b068,  10, 0x0065e5,   1,   -22828 }, /* VERR_ASN1_NOT_PRESENT */
    { 0x0125c6,  22, 0x0065e5,   1,   -22827 }, /* VERR_ASN1_NO_CHECK_SANITY_METHOD */
    { 0x01b0d4,   9, 0x0065e5,   1,   -22826 }, /* VERR_ASN1_NO_VTABLE */
    { 0x015525,  18, 0x0184e1,  15,   -22825 }, /* VERR_ASN1_TELETEX_UNSUPPORTED_CHARSET */
    { 0x015789,  18, 0x00ade9,  33,   -22824 }, /* VERR_ASN1_TELETEX_UNSUPPORTED_ESC_SEQ */
    { 0x0154cb,  18, 0x00abd9,  33,   -22823 }, /* VERR_ASN1_TELETEX_UNKNOWN_ESC_SEQ */
    { 0x01a309,  12, 0x011d46,  22,   -22820 }, /* VERR_ASN1_TIME_TAG_MISMATCH */
    { 0x01b30b,   9, 0x0155b5,  18,   -22819 }, /* VERR_ASN1_STRING_TAG_MISMATCH */
    { 0x012a07,  21, 0x00e928,  27,   -22818 }, /* VERR_ASN1_CONSTRUCTED_STRING_NOT_IMPL */
    { 0x0166d7,  17, 0x01816c,  15,   -22817 }, /* VERR_ASN1_OBJID_INVALID_DOTTED_STRING */
    { 0x014375,  20, 0x00e376,  27,   -22816 }, /* VERR_ASN1_OBJID_TOO_LONG_STRING_FORM */
    { 0x0139ed,  20, 0x01466b,  19,   -22815 }, /* VERR_ASN1_OBJID_TOO_MANY_COMPONENTS */
    { 0x0123b7,  22, 0x0174aa,  16,   -22814 }, /* VERR_ASN1_OBJID_COMPONENT_TOO_BIG */
    { 0x01ac44,  10, 0x01bfdc,   2,   -22813 }, /* VERR_ASN1_INVALID_OBJID_ENCODING */
    { 0x01ab04,  10, 0x01bfdc,   2,   -22812 }, /* VERR_ASN1_INVALID_BMP_STRING_ENCODING */
    { 0x016dfc,  16, 0x01bfdc,   2,   -22811 }, /* VERR_ASN1_INVALID_UNIVERSAL_STRING_ENCODING */
    { 0x018dcd,  14, 0x01bfdc,   2,   -22810 }, /* VERR_ASN1_INVALID_GENERAL_STRING_ENCODING */
    { 0x018927,  14, 0x01bfdc,   2,   -22809 }, /* VERR_ASN1_INVALID_VISIBLE_STRING_ENCODING */
    { 0x018af5,  14, 0x01bfdc,   2,   -22808 }, /* VERR_ASN1_INVALID_GRAPHIC_STRING_ENCODING */
    { 0x01b0b8,  10, 0x01bfdc,   2,   -22807 }, /* VERR_ASN1_INVALID_IA5_STRING_ENCODING */
    { 0x01804f,  15, 0x01bfdc,   2,   -22806 }, /* VERR_ASN1_INVALID_VIDEOTEX_STRING_ENCODING */
    { 0x01b086,  10, 0x01bfdc,   2,   -22805 }, /* VERR_ASN1_INVALID_T61_STRING_ENCODING */
    { 0x017ada,  16, 0x01bfdc,   2,   -22804 }, /* VERR_ASN1_INVALID_PRINTABLE_STRING_ENCODING */
    { 0x0186bf,  14, 0x01bfdc,   2,   -22803 }, /* VERR_ASN1_INVALID_NUMERIC_STRING_ENCODING */
    { 0x01aa59,  11, 0x01bfdc,   2,   -22802 }, /* VERR_ASN1_INVALID_UTF8_STRING_ENCODING */
    { 0x015b0d,  18, 0x01bf9d,   3,   -22801 }, /* VERR_ASN1_STRING_TYPE_NOT_IMPLEMENTED */
    { 0x01bfa0,   3, 0x0115ab,  23,   -22800 }, /* VERR_ASN1_ERROR */
    { 0x009da3,  35, 0x002817,  60,   -22739 }, /* VERR_XAR_ARCHIVED_AND_EXTRACTED_SIZES_MISMATCH */
    { 0x00fb7e,  25, 0x003b58,  54,   -22738 }, /* VERR_XAR_UNUSED_ARCHIVED_DATA */
    { 0x013b41,  20, 0x006772,  44,   -22737 }, /* VERR_XAR_ARCHIVED_HASH_MISMATCH */
    { 0x00fab6,  25, 0x00d19d,  29,   -22736 }, /* VERR_XAR_EXTRACTED_SIZE_EXCEEDED */
    { 0x012e9f,  21, 0x005e94,  45,   -22735 }, /* VERR_XAR_EXTRACTED_HASH_MISMATCH */
    { 0x01a7ba,  11, 0x0172aa,  16,   -22734 }, /* VERR_XAR_INVALID_FILE_NAME */
    { 0x01a29d,  12, 0x014846,  19,   -22733 }, /* VERR_XAR_BAD_FILE_INODE */
    { 0x016ffb,  16, 0x0143b1,  20,   -22732 }, /* VERR_XAR_BAD_FILE_DEVICE_NO */
    { 0x01adac,  10, 0x0130c1,  21,   -22731 }, /* VERR_XAR_BAD_FILE_GID */
    { 0x01afb4,  10, 0x0138fd,  20,   -22730 }, /* VERR_XAR_BAD_FILE_UID */
    { 0x01a993,  11, 0x0169f6,  17,   -22729 }, /* VERR_XAR_BAD_FILE_MODE */
    { 0x01776a,  16, 0x0131fc,  21,   -22728 }, /* VERR_XAR_BAD_FILE_TIMESTAMP */
    { 0x01b9cb,   7, 0x00be9c,  31,   -22727 }, /* VERR_XAR_NO_ENCODING */
    { 0x01b6bc,   8, 0x01b70c,   8,   -22726 }, /* VERR_XAR_UNKNOWN_FILE_TYPE */
    { 0x014a0e,  19, 0x013e25,  20,   -22725 }, /* VERR_XAR_MISSING_DATA_ELEMENT */
    { 0x018a5b,  14, 0x01600b,  18,   -22724 }, /* VERR_XAR_BAD_FILE_ELEMENT */
    { 0x014361,  20, 0x010079,  25,   -22723 }, /* VERR_XAR_BAD_LENGTH_ELEMENT */
    { 0x013544,  21, 0x00b928,  32,   -22722 }, /* VERR_XAR_MISSING_LENGTH_ELEMENT */
    { 0x017d52,  15, 0x01182f,  23,   -22721 }, /* VERR_XAR_BAD_SIZE_ELEMENT */
    { 0x0177ba,  16, 0x00c34e,  30,   -22720 }, /* VERR_XAR_MISSING_SIZE_ELEMENT */
    { 0x0138ad,  20, 0x010510,  25,   -22719 }, /* VERR_XAR_BAD_OFFSET_ELEMENT */
    { 0x012a5b,  21, 0x00b14a,  32,   -22718 }, /* VERR_XAR_MISSING_OFFSET_ELEMENT */
    { 0x00d472,  29, 0x0012ba,  71,   -22717 }, /* VERR_XAR_NOT_STREAMBLE_ELEMENT_ORDER */
    { 0x019555,  13, 0x01261e,  22,   -22716 }, /* VERR_XAR_BAD_DIGEST_LENGTH */
    { 0x013ca9,  20, 0x00724b,  42,   -22715 }, /* VERR_XAR_HASH_FUNCTION_MISMATCH */
    { 0x012584,  22, 0x00be01,  31,   -22714 }, /* VERR_XAR_BAD_CHECKSUM_ELEMENT */
    { 0x01a55d,  11, 0x0176fa,  16,   -22713 }, /* VERR_XAR_TOC_DIGEST_MISMATCH */
    { 0x00cc10,  29, 0x002632,  61,   -22712 }, /* VERR_XML_TOC_ELEMENT_HAS_SIBLINGS */
    { 0x016197,  18, 0x008b4c,  38,   -22711 }, /* VERR_XML_TOC_ELEMENT_MISSING */
    { 0x018121,  15, 0x00c83a,  30,   -22710 }, /* VERR_XAR_TOC_XML_PARSE_ERROR */
    { 0x017e33,  15, 0x012333,  22,   -22709 }, /* VERR_XAR_TOC_UTF8_ENCODING */
    { 0x016aa0,  17, 0x007a07,  41,   -22708 }, /* VERR_XAR_TOC_STRLEN_MISMATCH */
    { 0x015037,  19, 0x0033c0,  57,   -22707 }, /* VERR_XAR_TOC_UNCOMP_SIZE_MISMATCH */
    { 0x010ba8,  24, 0x012f08,  21,   -22706 }, /* VERR_XAR_TOC_TOO_BIG_COMPRESSED */
    { 0x010ba8,  13, 0x0179fa,  16,   -22705 }, /* VERR_XAR_TOC_TOO_BIG */
    { 0x017e9c,  15, 0x00729f,  42,   -22704 }, /* VERR_XAR_TOC_TOO_SMALL */
    { 0x0146dd,  19, 0x0157bf,  18,   -22703 }, /* VERR_XAR_UNSUPPORTED_HASH_FUNCTION */
    { 0x01bbbc,   7, 0x01b1f4,   9,   -22702 }, /* VERR_XAR_UNSUPPORTED_VERSION */
    { 0x01a644,  11, 0x01b9d2,   7,   -22701 }, /* VERR_XAR_BAD_HDR_SIZE */
    { 0x01772a,  16, 0x0191fb,  13,   -22700 }, /* VERR_XAR_WRONG_MAGIC */
    { 0x0150cf,  19, 0x008d14,  38,   -22600 }, /* VERR_FILESYSTEM_CORRUPT */
    { 0x01199f,  23, 0x01531c,  19,   -22503 }, /* VERR_SYS_UNSUPPORTED_FIRMWARE_PROPERTY */
    { 0x018577,  15, 0x01b036,  10,   -22502 }, /* VERR_SYS_SHUTDOWN_FAILED */
    { 0x012b81,  21, 0x0087e2,  38,   -22500 }, /* VERR_SYS_CANNOT_POWER_OFF */
    { 0x00f841,  26, 0x00346b,  57,   -22430 }, /* VERR_SYSTEM_INTEGRITY_POLICY_VIOLATION */
    { 0x017e7e,  15, 0x018478,  15,   -22429 }, /* VERR_INSTALLATION_FAILED */
    { 0x018e9f,  14, 0x016d15,  17,   -22428 }, /* VERR_REBOOT_NEEDED */
    { 0x017f32,  15, 0x00f639,  26,   -22427 }, /* VERR_FLOAT_OVERFLOW */
    { 0x0178da,  16, 0x00e66a,  27,   -22426 }, /* VERR_FLOAT_UNDERFLOW */
    { 0x0123f9,  22, 0x002de2,  59,   -22425 }, /* VERR_PROC_NO_ARG_TRANSLATION */
    { 0x012123,  22, 0x013583,  21,   -22424 }, /* VERR_THREAD_IS_TERMINATING */
    { 0x0191ee,  13, 0x010529,  25,   -22423 }, /* VERR_TOO_MANY_REFERENCES */
    { 0x01b7b4,   8, 0x019618,  13,   -22422 }, /* VERR_EMPTY_STRING */
    { 0x0188e1,  14, 0x0073ef,  42,   -22421 }, /* VERR_NO_STRING_TERMINATOR */
    { 0x013e11,  20, 0x008f1e,  37,   -22420 }, /* VERR_INCOMPATIBLE_CONFIG */
    { 0x010e78,  24, 0x00ede5,  26,   -22419 }, /* VERR_PROC_ELEVATION_REQUIRED */
    { 0x01a279,  12, 0x019dc9,  12,   -22418 }, /* VERR_INVALID_SESSION_ID */
    { 0x01a988,  11, 0x01a46b,  11,   -22417 }, /* VERR_INVALID_CLIENT_ID */
    { 0x015621,  18, 0x013598,  21,   -22416 }, /* VERR_WRONG_PARAMETER_TYPE */
    { 0x011ed1,  22, 0x011df6,  22,   -22415 }, /* VERR_WRONG_PARAMETER_COUNT */
    { 0x01ad2a,  10, 0x01748a,  16,   -22414 }, /* VERR_MP_TOO_MANY_CPUS */
    { 0x014bd6,  19, 0x000e72,  75,   -22413 }, /* VERR_PROC_IQ_PRIV_NOT_HELD */
    { 0x014415,  20, 0x000c54,  80,   -22412 }, /* VERR_PROC_APT_PRIV_NOT_HELD */
    { 0x013ac9,  20, 0x0003ea, 104,   -22411 }, /* VERR_PROC_TCB_PRIV_NOT_HELD */
    { 0x017aba,  16, 0x003029,  58,   -22410 }, /* VERR_PRIVILEGE_NOT_HELD */
    { 0x01b97c,   8, 0x01a93b,  11,   -22409 }, /* VERR_WRONG_TYPE */
    { 0x01bfd6,   2, 0x01b10a,   9,   -22408 }, /* VERR_MISMATCH */
    { 0x017a0a,  16, 0x0148de,  19,   -22407 }, /* VERR_ALLOCATION_TOO_BIG */
    { 0x00be20,  31, 0x005e3a,  45,   -22406 }, /* VERR_UNABLE_TO_SATISFY_REQUIREMENTS */
    { 0x014ea8,  19, 0x008912,  38,   -22405 }, /* VERR_ACCOUNT_RESTRICTED */
    { 0x01862b,  15, 0x009d17,  35,   -22404 }, /* VERR_PROC_DETACH_NOT_SUPPORTED */
    { 0x01a51b,  11, 0x007495,  41,   -22403 }, /* VERR_NOT_AVAILABLE */
    { 0x0198e3,  13, 0x0197d2,  13,   -22402 }, /* VERR_UNEVEN_INPUT */
    { 0x016561,  17, 0x016792,  17,   -22401 }, /* VERR_BUFFER_UNDERFLOW */
    { 0x01a59f,  11, 0x006e2f,  43,   -22400 }, /* VERR_UNEXPECTED_EXCEPTION */
    { 0x01b87c,   8, 0x016cf3,  17,   -22360 }, /* VERR_CR_PKCS7_NOT_DATA */
    { 0x00ffe3,  25, 0x007c64,  40,   -22359 }, /* VERR_CR_PKCS7_SIGNER_INFO_DIGEST_ENCRYPT_MISMATCH */
    { 0x0113e0,  23, 0x00857b,  39,   -22358 }, /* VERR_CR_PKCS7_SIGNER_CERT_NOT_SHIPPED */
    { 0x00b20a,  32, 0x005fcf,  45,   -22357 }, /* VERR_CR_PKCS7_SIGNER_INFO_NO_ISSUER_SERIAL_NO */
    { 0x01793a,  16, 0x00d333,  29,   -22356 }, /* VERR_CR_PKCS7_SIGNER_INFO_VERSION */
    { 0x00e577,  27, 0x005370,  48,   -22355 }, /* VERR_CR_PKCS7_EXPECTED_ONE_SIGNER_INFO */
    { 0x0162fd,  17, 0x00cbf3,  29,   -22354 }, /* VERR_CR_PKCS7_EXPECTED_NO_CRLS */
    { 0x01721a,  16, 0x00746c,  41,   -22353 }, /* VERR_CR_PKCS7_NO_CERTIFICATES */
    { 0x018f7f,  14, 0x010b00,  24,   -22352 }, /* VERR_CR_PKCS7_UNKNOWN_DIGEST_ALGORITHM */
    { 0x011cc2,  22, 0x00830b,  39,   -22351 }, /* VERR_CR_PKCS7_SIGNED_DATA_NO_DIGEST_ALGOS */
    { 0x016feb,  16, 0x00fda4,  25,   -22350 }, /* VERR_CR_PKCS7_SIGNED_DATA_VERSION */
    { 0x01af0a,  10, 0x009cd1,  35,   -22320 }, /* VERR_CR_PKCS7_DIGEST_CALC_ERROR */
    { 0x019e1d,  12, 0x0114f4,  23,   -22319 }, /* VERR_CR_PKCS7_DIGEST_CREATE_ERROR */
    { 0x01747a,  16, 0x006a27,  43,   -22318 }, /* VERR_CR_PKCS7_TOO_MANY_DIGEST_ALGORITHMS */
    { 0x0180c7,  15, 0x0075dd,  41,   -22317 }, /* VERR_CR_PKCS7_NO_DIGEST_ALGORITHMS */
    { 0x018301,  15, 0x010980,  24,   -22316 }, /* VERR_CR_PKCS7_NOT_SIGNED_DATA */
    { 0x014729,  19, 0x0026ac,  61,   -22315 }, /* VERR_CR_PKCS7_DIGEST_ALGO_NOT_FOUND_IN_LIST */
    { 0x017a2a,  16, 0x00629f,  45,   -22314 }, /* VERR_CR_PKCS7_DIGEST_PARAMS_NOT_IMPL */
    { 0x0173da,  16, 0x015cab,  18,   -22313 }, /* VERR_CR_PKCS7_OSSL_VERIFY_FAILED */
    { 0x019813,  13, 0x015154,  19,   -22312 }, /* VERR_CR_PKCS7_OSSL_D2I_FAILED */
    { 0x01be0d,   5, 0x01ad20,  10,   -22311 }, /* VERR_CR_PKCS7_INTERNAL_ERROR */
    { 0x01817b,  15, 0x00d1ba,  29,   -22300 }, /* VERR_LOG_REVISION_MISMATCH */
    { 0x0177da,  16, 0x00bd09,  31,   -22201 }, /* VERR_DVM_MAP_NO_VOLUME */
    { 0x018d25,  14, 0x00ae4a,  32,   -22200 }, /* VERR_DVM_MAP_EMPTY */
    { 0x0130d6,  21, 0x003231,  57,   -22158 }, /* VERR_VFS_CHAIN_TOO_SHORT_FOR_PARENT */
    { 0x018dbf,  14, 0x00ff66,  25,   -22157 }, /* VERR_VFS_CHAIN_NOT_PATH_ONLY */
    { 0x0165c7,  17, 0x00197b,  67,   -22156 }, /* VERR_VFS_CHAIN_TYPE_MISMATCH_PATH_ONLY */
    { 0x0191ad,  13, 0x000bb4,  80,   -22155 }, /* VERR_VFS_CHAIN_PATH_ONLY */
    { 0x015c63,  18, 0x0023c8,  62,   -22154 }, /* VERR_VFS_CHAIN_WRITE_ONLY_IOS */
    { 0x0163eb,  17, 0x00119a,  72,   -22153 }, /* VERR_VFS_CHAIN_READ_ONLY_IOS */
    { 0x00fa6b,  25, 0x001938,  67,   -22152 }, /* VERR_VFS_CHAIN_TAKES_DIR_OR_FSS_OR_VFS */
    { 0x015807,  18, 0x00666a,  44,   -22151 }, /* VERR_VFS_CHAIN_TAKES_DIR_OR_VFS */
    { 0x01a618,  11, 0x00983c,  36,   -22150 }, /* VERR_VFS_CHAIN_TAKES_VFS */
    { 0x019806,  13, 0x006cd7,  43,   -22149 }, /* VERR_VFS_CHAIN_TAKES_FSS */
    { 0x00fa6b,  13, 0x00d4c8,  29,   -22148 }, /* VERR_VFS_CHAIN_TAKES_DIR */
    { 0x016451,  17, 0x0077c9,  41,   -22147 }, /* VERR_VFS_CHAIN_TAKES_FILE_OR_IOS */
    { 0x018919,  14, 0x0119fb,  23,   -22146 }, /* VERR_VFS_CHAIN_TAKES_FILE */
    { 0x0167c5,  17, 0x002ecd,  58,   -22145 }, /* VERR_VFS_CHAIN_ONLY_DIR_OR_VFS */
    { 0x0116ed,  23, 0x002ecd,  58,   -22144 }, /* VERR_VFS_CHAIN_ONLY_FILE_OR_IOS_OR_DIR */
    { 0x01ae6a,  10, 0x007b24,  40,   -22143 }, /* VERR_VFS_CHAIN_ONLY_VFS */
    { 0x01a339,  12, 0x005782,  47,   -22142 }, /* VERR_VFS_CHAIN_ONLY_FSS */
    { 0x0167c5,  12, 0x00aa8f,  33,   -22141 }, /* VERR_VFS_CHAIN_ONLY_DIR */
    { 0x01a35d,  12, 0x006b29,  43,   -22140 }, /* VERR_VFS_CHAIN_ONLY_IOS */
    { 0x0116ed,  16, 0x006272,  45,   -22139 }, /* VERR_VFS_CHAIN_ONLY_FILE_OR_IOS */
    { 0x019367,  13, 0x012165,  22,   -22138 }, /* VERR_VFS_CHAIN_INVALID_ARGUMENT */
    { 0x01969a,  13, 0x010788,  24,   -22137 }, /* VERR_VFS_CHAIN_EMPTY_ARG */
    { 0x01af3c,  10, 0x015c75,  18,   -22136 }, /* VERR_VFS_CHAIN_TOO_MANY_ARGS */
    { 0x01998c,  13, 0x015c75,  18,   -22135 }, /* VERR_VFS_CHAIN_TOO_FEW_ARGS */
    { 0x0141d1,  20, 0x015c75,  18,   -22134 }, /* VERR_VFS_CHAIN_AT_MOST_SIX_ARGS */
    { 0x012cfb,  21, 0x015342,  19,   -22133 }, /* VERR_VFS_CHAIN_AT_LEAST_SIX_ARGS */
    { 0x019ce5,  12, 0x011846,  23,   -22132 }, /* VERR_VFS_CHAIN_SIX_ARGS */
    { 0x012c7d,  21, 0x015355,  19,   -22131 }, /* VERR_VFS_CHAIN_AT_MOST_FIVE_ARGS */
    { 0x012608,  22, 0x014019,  20,   -22130 }, /* VERR_VFS_CHAIN_AT_LEAST_FIVE_ARGS */
    { 0x0196f5,  13, 0x010f97,  24,   -22129 }, /* VERR_VFS_CHAIN_FIVE_ARGS */
    { 0x012c29,  21, 0x0151c6,  19,   -22128 }, /* VERR_VFS_CHAIN_AT_MOST_FOUR_ARGS */
    { 0x0126a2,  22, 0x014145,  20,   -22127 }, /* VERR_VFS_CHAIN_AT_LEAST_FOUR_ARGS */
    { 0x019666,  13, 0x01103f,  24,   -22126 }, /* VERR_VFS_CHAIN_FOUR_ARGS */
    { 0x012870,  22, 0x013fdd,  20,   -22125 }, /* VERR_VFS_CHAIN_AT_MOST_THREE_ARGS */
    { 0x011146,  23, 0x013409,  21,   -22124 }, /* VERR_VFS_CHAIN_AT_LEAST_THREE_ARGS */
    { 0x0187d7,  14, 0x01015a,  25,   -22123 }, /* VERR_VFS_CHAIN_THREE_ARGS */
    { 0x0141a9,  20, 0x015a8f,  18,   -22122 }, /* VERR_VFS_CHAIN_AT_MOST_TWO_ARGS */
    { 0x012da3,  21, 0x014dd7,  19,   -22121 }, /* VERR_VFS_CHAIN_AT_LEAST_TWO_ARGS */
    { 0x01a0e1,  12, 0x0111cf,  23,   -22120 }, /* VERR_VFS_CHAIN_TWO_ARGS */
    { 0x014091,  20, 0x00e13f,  27,   -22119 }, /* VERR_VFS_CHAIN_AT_LEAST_ONE_ARG */
    { 0x0151a0,  19, 0x00f88f,  26,   -22118 }, /* VERR_VFS_CHAIN_AT_MOST_ONE_ARG */
    { 0x01a686,  11, 0x00bda4,  31,   -22117 }, /* VERR_VFS_CHAIN_ONE_ARG */
    { 0x01b19a,   9, 0x018951,  14,   -22116 }, /* VERR_VFS_CHAIN_NO_ARGS */
    { 0x0193dc,  13, 0x00c1e1,  31,   -22115 }, /* VERR_VFS_CHAIN_FINAL_TYPE_MISMATCH */
    { 0x018496,  15, 0x018487,  15,   -22114 }, /* VERR_VFS_CHAIN_PROVIDER_NOT_FOUND */
    { 0x01b9a8,   7, 0x01b69c,   8,   -22113 }, /* VERR_VFS_CHAIN_IPE */
    { 0x01ad84,  10, 0x01b269,   9,   -22112 }, /* VERR_VFS_CHAIN_CAST_FAILED */
    { 0x00e619,  27, 0x00e175,  27,   -22111 }, /* VERR_VFS_CHAIN_CANNOT_BE_FIRST_ELEMENT */
    { 0x00fc46,  25, 0x006ed9,  42,   -22110 }, /* VERR_VFS_CHAIN_MUST_BE_FIRST_ELEMENT */
    { 0x011d1a,  22, 0x00bcac,  31,   -22109 }, /* VERR_VFS_CHAIN_TRAILING_SEPARATOR */
    { 0x012e21,  21, 0x00c45c,  30,   -22108 }, /* VERR_VFS_CHAIN_LEADING_SEPARATOR */
    { 0x01277e,  22, 0x0139b1,  20,   -22107 }, /* VERR_VFS_CHAIN_EXPECTED_SEPARATOR */
    { 0x00f021,  26, 0x016265,  17,   -22106 }, /* VERR_VFS_CHAIN_EXPECTED_PROVIDER_NAME */
    { 0x00cb0a,  30, 0x0137a5,  21,   -22105 }, /* VERR_VFS_CHAIN_EXPECTED_RIGHT_PARENTHESES */
    { 0x00d180,  29, 0x013c81,  20,   -22104 }, /* VERR_VFS_CHAIN_EXPECTED_LEFT_PARENTHESES */
    { 0x01bc85,   6, 0x019521,  13,   -22103 }, /* VERR_VFS_CHAIN_UNKNOWN_TYPE */
    { 0x013c95,  20, 0x01acb2,  10,   -22102 }, /* VERR_VFS_CHAIN_EXPECTED_ELEMENT */
    { 0x01969a,   9, 0x010092,  25,   -22101 }, /* VERR_VFS_CHAIN_EMPTY */
    { 0x01a8e3,  11, 0x007d04,  40,   -22100 }, /* VERR_VFS_CHAIN_NO_PREFIX */
    { 0x01a351,  12, 0x009ede,  35,   -22005 }, /* VERR_ZIP_BAD_HEADER */
    { 0x019c19,  12, 0x00acc0,  33,   -22004 }, /* VERR_ZIP_UNSUPPORTED_METHOD */
    { 0x01ba96,   7, 0x00a43e,  34,   -22003 }, /* VERR_ZIP_UNSUPPORTED_VERSION */
    { 0x01bb6f,   7, 0x006925,  43,   -22002 }, /* VERR_ZIP_NO_MEMORY */
    { 0x01880f,  14, 0x010680,  24,   -22001 }, /* VERR_ZIP_CORRUPTED */
    { 0x01bc19,   6, 0x01bd7b,   6,   -22000 }, /* VERR_ZIP_ERROR */
    { 0x0192e5,  13, 0x0062f9,  45,    -7602 }, /* VERR_GCM_NOT_HANDLED */
    { 0x0163da,  17, 0x009fb0,  35,    -7400 }, /* VERR_PLATFORM_ARCH_NOT_SUPPORTED */
    { 0x01bd90,   5, 0x01b664,   8,    -7399 }, /* VERR_IOMMU_IPE_9 */
    { 0x01bd95,   5, 0x01b93c,   8,    -7398 }, /* VERR_IOMMU_IPE_8 */
    { 0x01bd9a,   5, 0x01b83c,   8,    -7397 }, /* VERR_IOMMU_IPE_7 */
    { 0x01bd9f,   5, 0x01b74c,   8,    -7396 }, /* VERR_IOMMU_IPE_6 */
    { 0x01bda4,   5, 0x01b6dc,   8,    -7395 }, /* VERR_IOMMU_IPE_5 */
    { 0x01bda9,   5, 0x01b91c,   8,    -7394 }, /* VERR_IOMMU_IPE_4 */
    { 0x01bdae,   5, 0x01b85c,   8,    -7393 }, /* VERR_IOMMU_IPE_3 */
    { 0x01bdb3,   5, 0x01b76c,   8,    -7392 }, /* VERR_IOMMU_IPE_2 */
    { 0x01bdb8,   5, 0x01b6cc,   8,    -7391 }, /* VERR_IOMMU_IPE_1 */
    { 0x01bdfe,   5, 0x01b884,   8,    -7390 }, /* VERR_IOMMU_IPE_0 */
    { 0x014b05,  19, 0x000f9b,  74,    -7310 }, /* VERR_IOMMU_CANNOT_CALL_SELF */
    { 0x01a7fc,  11, 0x0196a7,  13,    -7309 }, /* VERR_IOMMU_NOT_PRESENT */
    { 0x01a4b8,  11, 0x00fc14,  25,    -7308 }, /* VERR_IOMMU_CMD_HW_ERROR */
    { 0x0187bb,  14, 0x006f81,  42,    -7307 }, /* VERR_IOMMU_CMD_INVALID_FORMAT */
    { 0x01b35c,   9, 0x01ad66,  10,    -7306 }, /* VERR_IOMMU_CMD_NOT_SUPPORTED */
    { 0x013dfd,  20, 0x0017e4,  68,    -7305 }, /* VERR_IOMMU_INTR_REMAP_DENIED */
    { 0x0185e0,  15, 0x0113f7,  23,    -7304 }, /* VERR_IOMMU_INTR_REMAP_FAILED */
    { 0x012a46,  21, 0x0106e0,  24,    -7303 }, /* VERR_IOMMU_ADDR_ACCESS_DENIED */
    { 0x013250,  21, 0x013082,  21,    -7302 }, /* VERR_IOMMU_ADDR_TRANSLATION_FAILED */
    { 0x01882b,  14, 0x01002e,  25,    -7301 }, /* VERR_IOMMU_DTE_BAD_OFFSET */
    { 0x019702,  13, 0x0110ff,  24,    -7300 }, /* VERR_IOMMU_DTE_READ_FAILED */
    { 0x0115c2,  23, 0x0083ce,  39,    -7206 }, /* VERR_PDM_CRITSECTRW_MISALIGNED */
    { 0x01795a,  16, 0x00bf94,  31,    -7205 }, /* VERR_PDM_CRITSECTRW_IPE */
    { 0x00f8a9,  25, 0x001d56,  65,    -7204 }, /* VERR_PDM_CRITSECTRW_TOO_MANY_RECURSIONS */
    { 0x011e0c,  22, 0x0068fa,  43,    -7203 }, /* VERR_PDM_CRITSECTRW_TOO_MANY_WRITERS */
    { 0x011efd,  22, 0x00663e,  44,    -7202 }, /* VERR_PDM_CRITSECTRW_TOO_MANY_READERS */
    { 0x0155fd,  18, 0x008e40,  37,    -7201 }, /* VERR_PDM_CRITSECT_ABORT_FAILED */
    { 0x019437,  13, 0x00c06d,  31,    -7153 }, /* VERR_SHCLPB_NO_DATA */
    { 0x018676,  15, 0x010141,  25,    -7152 }, /* VERR_SHCLPB_EVENT_FAILED */
    { 0x018379,  15, 0x0146f0,  19,    -7151 }, /* VERR_SHCLPB_GUEST_ERROR */
    { 0x012307,  22, 0x00bc8d,  31,    -7150 }, /* VERR_SHCLPB_TRANSFER_ID_NOT_FOUND */
    { 0x00f5d1,  26, 0x002da7,  59,    -7106 }, /* VERR_SHCLPB_MAX_EVENTS_REACHED */
    { 0x014788,  19, 0x00dc3b,  28,    -7105 }, /* VERR_SHCLPB_EVENT_ID_NOT_FOUND */
    { 0x00f54f,  26, 0x006d02,  43,    -7104 }, /* VERR_SHCLPB_OBJ_HANDLE_INVALID */
    { 0x00e994,  27, 0x007e94,  40,    -7103 }, /* VERR_SHCLPB_LIST_HANDLE_INVALID */
    { 0x00fbfb,  25, 0x006bd5,  43,    -7102 }, /* VERR_SHCLPB_MAX_LISTS_REACHED */
    { 0x00e24d,  27, 0x005f75,  45,    -7101 }, /* VERR_SHCLPB_MAX_OBJECTS_REACHED */
    { 0x00d48f,  29, 0x00496e,  50,    -7100 }, /* VERR_SHCLPB_MAX_TRANSFERS_REACHED */
    { 0x011027,  24, 0x007e1c,  40,    -7000 }, /* VERR_SUPDRV_NO_RAW_MODE_HYPER_V_ROOT */
    { 0x018d6b,  14, 0x01a70a,  11,    -6908 }, /* VERR_RECORDING_ENCODING_FAILED */
    { 0x01425d,  20, 0x0066ee,  44,    -6907 }, /* VERR_RECORDING_THROTTLED */
    { 0x010a58,  24, 0x00ae8a,  32,    -6906 }, /* VERR_RECORDING_LIMIT_REACHED */
    { 0x012aee,  21, 0x006746,  44,    -6905 }, /* VERR_RECORDING_RESTRICTED */
    { 0x014069,  20, 0x00f25d,  26,    -6904 }, /* VERR_RECORDING_FORMAT_NOT_SUPPORTED */
    { 0x014ce0,  19, 0x01b12e,   9,    -6903 }, /* VERR_RECORDING_CODEC_NOT_SUPPORTED */
    { 0x011594,  23, 0x011f29,  22,    -6902 }, /* VERR_RECORDING_CODEC_INIT_FAILED */
    { 0x016ac2,  17, 0x00f007,  26,    -6901 }, /* VERR_RECORDING_INIT_FAILED */
    { 0x015096,  19, 0x01b0ef,   9,    -6900 }, /* VERR_RECORDING_CODEC_NOT_FOUND */
    { 0x01be94,   5, 0x01b68c,   8,    -6899 }, /* VERR_NEM_IPE_9 */
    { 0x01be99,   5, 0x01b8a4,   8,    -6898 }, /* VERR_NEM_IPE_8 */
    { 0x01be9e,   5, 0x01b7c4,   8,    -6897 }, /* VERR_NEM_IPE_7 */
    { 0x01bea3,   5, 0x01b4fc,   8,    -6896 }, /* VERR_NEM_IPE_6 */
    { 0x01beb7,   5, 0x01b694,   8,    -6895 }, /* VERR_NEM_IPE_5 */
    { 0x01bea8,   5, 0x01b8e4,   8,    -6894 }, /* VERR_NEM_IPE_4 */
    { 0x01bead,   5, 0x01b7e4,   8,    -6893 }, /* VERR_NEM_IPE_3 */
    { 0x01beb2,   5, 0x01b51c,   8,    -6892 }, /* VERR_NEM_IPE_2 */
    { 0x01be17,   5, 0x01b66c,   8,    -6891 }, /* VERR_NEM_IPE_1 */
    { 0x01be49,   5, 0x01b874,   8,    -6890 }, /* VERR_NEM_IPE_0 */
    { 0x01a0d5,  12, 0x007dcc,  40,    -6817 }, /* VERR_NEM_MISSING_FEATURE */
    { 0x011988,  23, 0x0109e0,  24,    -6816 }, /* VERR_NEM_QUERY_DIRTY_BITMAP_FAILED */
    { 0x0168f7,  17, 0x00a6a2,  34,    -6815 }, /* VERR_NEM_MISSING_KERNEL_API_5 */
    { 0x01695d,  17, 0x00a32e,  34,    -6814 }, /* VERR_NEM_MISSING_KERNEL_API_4 */
    { 0x016990,  17, 0x00a394,  34,    -6813 }, /* VERR_NEM_MISSING_KERNEL_API_3 */
    { 0x01696e,  17, 0x00a130,  34,    -6812 }, /* VERR_NEM_MISSING_KERNEL_API_2 */
    { 0x01aea6,  10, 0x019d39,  12,    -6811 }, /* VERR_NEM_SET_TSC */
    { 0x019f61,  12, 0x0076d3,  41,    -6810 }, /* VERR_NEM_FLUSH_TLB */
    { 0x015777,  18, 0x015d3b,  18,    -6809 }, /* VERR_NEM_SET_REGISTERS_FAILED */
    { 0x015a47,  18, 0x015897,  18,    -6808 }, /* VERR_NEM_GET_REGISTERS_FAILED */
    { 0x01716a,  16, 0x00eb5f,  27,    -6807 }, /* VERR_NEM_UNMAP_PAGES_FAILED */
    { 0x018d95,  14, 0x00fc78,  25,    -6806 }, /* VERR_NEM_MAP_PAGES_FAILED */
    { 0x0193c2,  13, 0x00ba02,  31,    -6805 }, /* VERR_NEM_VM_CREATE_FAILED */
    { 0x01994b,  13, 0x00ba21,  31,    -6804 }, /* VERR_NEM_RING3_ONLY */
    { 0x01697f,  17, 0x00a85c,  34,    -6803 }, /* VERR_NEM_MISSING_KERNEL_API_1 */
    { 0x01b365,   9, 0x01b58c,   8,    -6802 }, /* VERR_NEM_INIT_FAILED */
    { 0x019673,  13, 0x018ead,  14,    -6801 }, /* VERR_NEM_NOT_AVAILABLE */
    { 0x01a7e6,  11, 0x01a02d,  12,    -6800 }, /* VERR_NEM_NOT_ENABLED */
    { 0x01b554,   8, 0x01b07c,  10,    -6707 }, /* VERR_APIC_IPE_2 */
    { 0x01b55c,   8, 0x01ad16,  10,    -6706 }, /* VERR_APIC_IPE_1 */
    { 0x01b564,   8, 0x01ae88,  10,    -6705 }, /* VERR_APIC_IPE_0 */
    { 0x014f79,  19, 0x00b36a,  32,    -6704 }, /* VERR_APIC_WRITE_INVALID */
    { 0x01a26d,  12, 0x012d64,  21,    -6703 }, /* VERR_APIC_INIT_FAILED */
    { 0x0141bd,  20, 0x00d733,  28,    -6702 }, /* VERR_APIC_INTR_DISCARDED */
    { 0x010758,  24, 0x00c010,  31,    -6701 }, /* VERR_APIC_INTR_MASKED_BY_TPR */
    { 0x014bc3,  19, 0x014e49,  19,    -6700 }, /* VERR_APIC_INTR_NOT_PENDING */
    { 0x00c27c,  30, 0x00490a,  50,    -6608 }, /* VERR_AUDIO_STREAM_INIT_IN_PROGRESS */
    { 0x0145cd,  20, 0x01367f,  21,    -6607 }, /* VERR_AUDIO_ENUMERATION_FAILED */
    { 0x00e4f0,  27, 0x01115c,  23,    -6606 }, /* VERR_AUDIO_STREAM_COULD_NOT_CREATE */
    { 0x013c1d,  20, 0x01609b,  18,    -6605 }, /* VERR_AUDIO_STREAM_NOT_READY */
    { 0x00cfcd,  29, 0x00a592,  34,    -6604 }, /* VERR_AUDIO_STREAM_PENDING_DISABLE */
    { 0x00e742,  27, 0x012b18,  21,    -6603 }, /* VERR_AUDIO_NO_FREE_OUTPUT_STREAMS */
    { 0x00f723,  26, 0x013c31,  20,    -6602 }, /* VERR_AUDIO_NO_FREE_INPUT_STREAMS */
    { 0x010a40,  24, 0x009ac4,  35,    -6601 }, /* VERR_AUDIO_BACKEND_NOT_ATTACHED */
    { 0x012ac4,  21, 0x009cae,  35,    -6600 }, /* VERR_AUDIO_BACKEND_INIT_FAILED */
    { 0x01a0a5,  12, 0x011de0,  22,    -6500 }, /* VERR_DND_GUEST_ERROR */
    { 0x00d90f,  28, 0x003e16,  54,    -6401 }, /* VERR_MAIN_CONFIG_CONSTRUCTOR_IPE */
    { 0x00c4f2,  30, 0x005e0c,  46,    -6400 }, /* VERR_MAIN_CONFIG_CONSTRUCTOR_COM_ERROR */
    { 0x012dcd,  21, 0x003825,  55,    -6318 }, /* VERR_GIM_INVALID_HYPERCALL_INSTR */
    { 0x011dca,  22, 0x00d268,  29,    -6315 }, /* VERR_GIM_NO_DEBUG_CONNECTION */
    { 0x01773a,  16, 0x013ba5,  20,    -6314 }, /* VERR_GIM_HYPERCALL_FAILED */
    { 0x010c80,  24, 0x0053a0,  48,    -6313 }, /* VERR_GIM_HYPERCALL_MEMORY_WRITE_FAILED */
    { 0x0114c6,  23, 0x00586d,  47,    -6312 }, /* VERR_GIM_HYPERCALL_MEMORY_READ_FAILED */
    { 0x00def7,  28, 0x00309d,  58,    -6311 }, /* VERR_GIM_HYPERCALL_ACCESS_DENIED */
    { 0x011b6a,  23, 0x0071f7,  42,    -6310 }, /* VERR_GIM_DEVICE_NOT_REGISTERED */
    { 0x0110b7,  24, 0x00e526,  27,    -6309 }, /* VERR_GIM_HYPERCALLS_NOT_ENABLED */
    { 0x00f687,  26, 0x00b848,  32,    -6308 }, /* VERR_GIM_HYPERCALLS_NOT_AVAILABLE */
    { 0x0172ba,  16, 0x018f9b,  14,    -6307 }, /* VERR_GIM_OPERATION_FAILED */
    { 0x0190cf,  14, 0x01740a,  16,    -6306 }, /* VERR_GIM_INVALID_PROVIDER */
    { 0x01544c,  19, 0x009668,  36,    -6305 }, /* VERR_GIM_PVTSC_NOT_ENABLED */
    { 0x012d8e,  21, 0x00781b,  41,    -6304 }, /* VERR_GIM_PVTSC_NOT_AVAILABLE */
    { 0x01ba11,   7, 0x01acd0,  10,    -6303 }, /* VERR_GIM_IPE_3 */
    { 0x01ba18,   7, 0x01ae74,  10,    -6302 }, /* VERR_GIM_IPE_2 */
    { 0x01ba1f,   7, 0x01af6e,  10,    -6301 }, /* VERR_GIM_IPE_1 */
    { 0x0194ed,  13, 0x009fd3,  35,    -6300 }, /* VERR_GIM_NOT_ENABLED */
    { 0x00ff4d,  25, 0x0086b2,  38,    -6225 }, /* VERR_GSTCTL_PROCESS_EXIT_CODE */
    { 0x00d2dc,  29, 0x0063d6,  44,    -6224 }, /* VERR_GSTCTL_MAX_CID_COUNT_REACHED */
    { 0x00bff1,  31, 0x00697b,  43,    -6223 }, /* VERR_GSTCTL_MAX_CID_OBJECTS_REACHED */
    { 0x00b6ea,  32, 0x006536,  44,    -6222 }, /* VERR_GSTCTL_MAX_CID_SESSIONS_REACHED */
    { 0x011971,  23, 0x011c39,  23,    -6221 }, /* VERR_GSTCTL_PROCESS_WRONG_STATE */
    { 0x01813f,  15, 0x011de0,  22,    -6200 }, /* VERR_GSTCTL_GUEST_ERROR */
    { 0x01631f,  17, 0x005490,  48,    -6001 }, /* VERR_EXTPACK_VBOX_VERSION_MISMATCH */
    { 0x010c20,  24, 0x01b22a,   9,    -6000 }, /* VERR_EXTPACK_UNSUPPORTED_HOST_UNINSTALL */
    { 0x01a2d9,  12, 0x011057,  24,    -5699 }, /* VERR_SUP_DRIVERLESS */
    { 0x008796,  38, 0x00063d,  95,    -5679 }, /* VERR_SUP_VP_NOT_SIGNED_WITH_SPECIALLY_TRUSTED_CERT */
    { 0x011943,  23, 0x00a4c6,  34,    -5678 }, /* VERR_SUP_VP_SET_HANDLE_NOINHERIT */
    { 0x01664f,  17, 0x01434d,  20,    -5677 }, /* VERR_SUP_VP_QUERY_HANDLE_TYPE */
    { 0x013655,  21, 0x014645,  19,    -5676 }, /* VERR_SUP_VP_UNDESIRABLE_MODULE */
    { 0x010bf0,  24, 0x003e4c,  53,    -5675 }, /* VERR_SUP_VP_CREATE_READ_EVT_SEM_FAILED */
    { 0x01b004,  10, 0x0171fa,  16,    -5674 }, /* VERR_SUP_VP_FILE_MODE_ERROR */
    { 0x01289c,  22, 0x00019d, 125,    -5673 }, /* VERR_SUP_VP_REPLACE_VIRTUAL_MEMORY_FAILED */
    { 0x01312a,  21, 0x0014aa,  70,    -5672 }, /* VERR_SUP_VP_STUB_THREAD_OPEN_ERROR */
    { 0x0162ca,  17, 0x0010c1,  73,    -5671 }, /* VERR_SUP_VP_STUB_THREAD_NOT_FOUND */
    { 0x018935,  14, 0x0020d6,  63,    -5670 }, /* VERR_SUP_VP_STUB_OPEN_ERROR */
    { 0x01ac94,  10, 0x001ac9,  66,    -5669 }, /* VERR_SUP_VP_STUB_NOT_FOUND */
    { 0x0193b5,  13, 0x014adf,  19,    -5668 }, /* VERR_SUP_VP_IMAGE_TOO_BIG */
    { 0x00ca1a,  30, 0x006c2b,  43,    -5667 }, /* VERR_SUP_VP_NOT_OWNED_BY_TRUSTED_INSTALLER */
    { 0x017d16,  15, 0x0091dd,  37,    -5666 }, /* VERR_SUP_VP_UNKOWN_MEM_TYPE */
    { 0x0128b2,  22, 0x00037d, 109,    -5665 }, /* VERR_SUP_VP_UNMAP_AND_PROTECT_FAILED */
    { 0x014c0f,  19, 0x000806,  90,    -5664 }, /* VERR_SUP_VP_FREE_VIRTUAL_MEMORY_FAILED */
    { 0x014f9f,  19, 0x011a57,  23,    -5663 }, /* VERR_SUP_VP_KERNEL32_ALREADY_MAPPED */
    { 0x019a90,  13, 0x001272,  72,    -5662 }, /* VERR_SUP_VP_SYSFER_DLL */
    { 0x00ce1a,  29, 0x0094b8,  36,    -5661 }, /* VERR_SUP_VP_SIGNATURE_CHECKS_NOT_ENFORCED */
    { 0x013b55,  20, 0x017d9d,  15,    -5660 }, /* VERR_SUP_VP_UNEXPECTED_VALID_PATH_COUNT */
    { 0x00bd85,  31, 0x0037ee,  55,    -5659 }, /* VERR_SUP_VP_NOT_VALID_KERNEL_CODE_SIGNATURE */
    { 0x015cf3,  18, 0x01055b,  25,    -5658 }, /* VERR_SUP_VP_NOT_BUILD_CERT_IPE */
    { 0x00ef03,  26, 0x004d56,  50,    -5657 }, /* VERR_SUP_VP_NOT_SIGNED_WITH_BUILD_CERT */
    { 0x011a29,  23, 0x0013d6,  71,    -5656 }, /* VERR_SUP_VP_WINTRUST_CAT_FAILURE */
    { 0x00e8a1,  27, 0x0108c0,  24,    -5655 }, /* VERR_SUP_VP_NT_QI_PROCESS_DBG_PORT_ERROR */
    { 0x00e8f2,  27, 0x00f395,  26,    -5654 }, /* VERR_SUP_VP_NT_QI_PROCESS_IMG_INFO_ERROR */
    { 0x00f055,  26, 0x003f55,  53,    -5653 }, /* VERR_SUP_VP_IMAGE_CHARECTERISTICS_MISMATCH */
    { 0x010cc8,  24, 0x002c45,  59,    -5652 }, /* VERR_SUP_VP_DLL_CHARECTERISTICS_MISMATCH */
    { 0x015bc1,  18, 0x008185,  39,    -5651 }, /* VERR_SUP_VP_EXE_MISSING_NX_COMPAT */
    { 0x01338b,  21, 0x00882e,  38,    -5650 }, /* VERR_SUP_VP_EXE_MISSING_DYNAMIC_BASE */
    { 0x0175ca,  16, 0x000ebd,  74,    -5649 }, /* VERR_SUP_VP_EXE_MISSING_FORCE_INTEGRITY */
    { 0x0164ea,  17, 0x00aaf2,  33,    -5648 }, /* VERR_SUP_VP_UNEXPECTED_SECTION_FLAGS */
    { 0x0165b6,  17, 0x00739b,  42,    -5647 }, /* VERR_SUP_VP_UNEXPECTED_IMAGE_MACHINE */
    { 0x0196c1,  13, 0x01493d,  19,    -5646 }, /* VERR_SUP_VP_TOO_MANY_SECTIONS */
    { 0x018d4f,  14, 0x00fffc,  25,    -5645 }, /* VERR_SUP_VP_TOO_MANY_MEMORY_REGIONS */
    { 0x015513,  18, 0x015cbd,  18,    -5644 }, /* VERR_SUP_VP_TOO_MANY_IMAGE_REGIONS */
    { 0x01788a,  16, 0x00e268,  27,    -5643 }, /* VERR_SUP_VP_TOO_MANY_DLLS_LOADED */
    { 0x016f3b,  16, 0x00ce71,  29,    -5642 }, /* VERR_SUP_VP_TOO_LARGE_REGION */
    { 0x014ef4,  19, 0x00c876,  30,    -5641 }, /* VERR_SUP_VP_TOO_HIGH_REGION_RVA */
    { 0x0178ca,  16, 0x00e7c9,  27,    -5640 }, /* VERR_SUP_VP_THREAD_NOT_ALONE */
    { 0x0176ea,  16, 0x00ad23,  33,    -5639 }, /* VERR_SUP_VP_SYSTEM32_PATH */
    { 0x011522,  23, 0x00b28a,  32,    -5638 }, /* VERR_SUP_VP_NT_QI_VIRTUAL_MEMORY_NM_ERROR */
    { 0x013e39,  20, 0x00be5e,  31,    -5637 }, /* VERR_SUP_VP_NT_QI_VIRTUAL_MEMORY_ERROR */
    { 0x0169e5,  17, 0x00b38a,  32,    -5636 }, /* VERR_SUP_VP_NT_QI_THREAD_ERROR */
    { 0x013601,  21, 0x0146a4,  19,    -5635 }, /* VERR_SUP_VP_NT_QI_PROCESS_NM_ERROR */
    { 0x00f229,  26, 0x006137,  45,    -5634 }, /* VERR_SUP_VP_NT_MAPPING_NAME_CHANGED */
    { 0x013cd1,  20, 0x00354e,  56,    -5633 }, /* VERR_SUP_VP_NOT_KNOWN_DLL_OR_EXE */
    { 0x014904,  19, 0x0043a3,  52,    -5632 }, /* VERR_SUP_VP_NON_SYSTEM32_DLL */
    { 0x0169c3,  17, 0x01afd2,  10,    -5631 }, /* VERR_SUP_VP_NO_NTDLL_MAPPING */
    { 0x01ba49,   7, 0x0070d1,  42,    -5630 }, /* VERR_SUP_VP_NO_MEMORY_STATE */
    { 0x01ba49,   5, 0x011e22,  22,    -5629 }, /* VERR_SUP_VP_NO_MEMORY */
    { 0x0139d9,  20, 0x019f6d,  12,    -5628 }, /* VERR_SUP_VP_NO_KERNEL32_MAPPING */
    { 0x011d88,  22, 0x00beda,  31,    -5627 }, /* VERR_SUP_VP_NO_IMAGE_MAPPING_NAME */
    { 0x015e7f,  18, 0x0045dc,  51,    -5626 }, /* VERR_SUP_VP_NO_FOUND_NO_EXE_MAPPING */
    { 0x01a9d5,  11, 0x0099ec,  36,    -5625 }, /* VERR_SUP_VP_MEMORY_READ_ERROR */
    { 0x011a40,  23, 0x00008e, 138,    -5624 }, /* VERR_SUP_VP_IMAGE_MAPPING_BASE_ERROR */
    { 0x014f66,  19, 0x0131bd,  21,    -5623 }, /* VERR_SUP_VP_IMAGE_HDR_READ_ERROR */
    { 0x01783a,  16, 0x015e5b,  18,    -5622 }, /* VERR_SUP_VP_IMAGE_FILE_OPEN_ERROR */
    { 0x016b4a,  17, 0x0132b9,  21,    -5621 }, /* VERR_SUP_VP_IMAGE_FILE_CLOSE_ERROR */
    { 0x00c420,  30, 0x002444,  62,    -5620 }, /* VERR_SUP_VP_FOUND_MORE_THAN_ONE_EXE_MAPPING */
    { 0x01a86a,  11, 0x0076aa,  41,    -5619 }, /* VERR_SUP_VP_FOUND_EXEC_MEMORY */
    { 0x013226,  21, 0x00815e,  39,    -5618 }, /* VERR_SUP_VP_EXE_VS_PROC_NAME_MISMATCH */
    { 0x012241,  22, 0x010060,  25,    -5617 }, /* VERR_SUP_VP_EMPTY_REGION_TOO_LARGE */
    { 0x010908,  24, 0x00ba5f,  31,    -5616 }, /* VERR_SUP_VP_DUPLICATE_DLL_MAPPING */
    { 0x01a5ec,  11, 0x012cd1,  21,    -5615 }, /* VERR_SUP_VP_DEBUGGED */
    { 0x01735a,  16, 0x01601d,  18,    -5614 }, /* VERR_SUP_VP_BAD_SIZE_OF_HEADERS */
    { 0x013751,  21, 0x015a11,  18,    -5613 }, /* VERR_SUP_VP_BAD_SECTION_VIRTUAL_SIZE */
    { 0x017b63,  15, 0x012c3e,  21,    -5612 }, /* VERR_SUP_VP_BAD_SECTION_RVA */
    { 0x018c29,  14, 0x017fd7,  15,    -5611 }, /* VERR_SUP_VP_BAD_SECTION_FILE_SIZE */
    { 0x00e5e3,  27, 0x010335,  25,    -5610 }, /* VERR_SUP_VP_BAD_SECTION_ALIGNMENT_VALUE */
    { 0x014e95,  19, 0x013d85,  20,    -5609 }, /* VERR_SUP_VP_BAD_OPTIONAL_HEADER */
    { 0x01927d,  13, 0x00dd37,  28,    -5608 }, /* VERR_SUP_VP_BAD_MZ_OFFSET */
    { 0x01a8ac,  11, 0x01ab86,  10,    -5607 }, /* VERR_SUP_VP_BAD_IMAGE_SIZE */
    { 0x014c35,  19, 0x018586,  15,    -5606 }, /* VERR_SUP_VP_BAD_IMAGE_SIGNATURE */
    { 0x0187e5,  14, 0x016119,  18,    -5605 }, /* VERR_SUP_VP_BAD_IMAGE_BASE */
    { 0x013d35,  20, 0x00fae8,  25,    -5604 }, /* VERR_SUP_VP_BAD_FILE_ALIGNMENT_VALUE */
    { 0x010c98,  24, 0x007777,  41,    -5603 }, /* VERR_SUP_VP_SECTION_NOT_FULLY_MAPPED */
    { 0x015d29,  18, 0x009d3a,  35,    -5602 }, /* VERR_SUP_VP_SECTION_NOT_MAPPED */
    { 0x011ab3,  23, 0x00518f,  49,    -5601 }, /* VERR_SUP_VP_SECTION_PROTECTION_MISMATCH */
    { 0x01afc8,  10, 0x013559,  21,    -5600 }, /* VERR_SUP_VP_MEMORY_VS_FILE_MISMATCH */
    { 0x0164c8,  17, 0x01ac8a,  10,    -5499 }, /* VERR_DBGC_PARSE_TOO_FEW_ARGUMENTS */
    { 0x018c1b,  14, 0x01bb84,   7,    -5498 }, /* VERR_DBGC_PARSE_TOO_MANY_ARGUMENTS */
    { 0x013f3d,  20, 0x00b00a,  32,    -5497 }, /* VERR_DBGC_PARSE_ARGUMENT_OVERFLOW */
    { 0x012cbc,  21, 0x0136e8,  21,    -5496 }, /* VERR_DBGC_PARSE_EXPECTED_BINARY_OP */
    { 0x016ad3,  17, 0x007179,  42,    -5494 }, /* VERR_DBGC_PARSE_NO_RANGE_ALLOWED */
    { 0x015070,  19, 0x012710,  22,    -5493 }, /* VERR_DBGC_PARSE_UNBALANCED_QUOTE */
    { 0x00ff34,  25, 0x00e5fe,  27,    -5492 }, /* VERR_DBGC_PARSE_UNBALANCED_PARENTHESIS */
    { 0x01694c,  17, 0x006aa8,  43,    -5491 }, /* VERR_DBGC_PARSE_EMPTY_ARGUMENT */
    { 0x01a0bd,  12, 0x0143c5,  20,    -5490 }, /* VERR_DBGC_PARSE_UNEXPECTED_OPERATOR */
    { 0x01ae38,  10, 0x018cfb,  14,    -5489 }, /* VERR_DBGC_PARSE_INVALID_NUMBER */
    { 0x01897b,  14, 0x013004,  21,    -5488 }, /* VERR_DBGC_PARSE_NUMBER_TOO_BIG */
    { 0x01983a,  13, 0x0171ba,  16,    -5487 }, /* VERR_DBGC_PARSE_INVALID_OPERATION */
    { 0x0188ef,  14, 0x018022,  15,    -5486 }, /* VERR_DBGC_PARSE_FUNCTION_NOT_FOUND */
    { 0x018b49,  14, 0x00dc57,  28,    -5485 }, /* VERR_DBGC_PARSE_NOT_A_FUNCTION */
    { 0x01a4d9,  11, 0x010e60,  24,    -5484 }, /* VERR_DBGC_PARSE_NO_SCRATCH */
    { 0x01be3f,   5, 0x00d05e,  29,    -5483 }, /* VERR_DBGC_PARSE_NO_MEMORY */
    { 0x0159db,  18, 0x00d58f,  28,    -5482 }, /* VERR_DBGC_PARSE_INCORRECT_ARG_TYPE */
    { 0x018847,  14, 0x009860,  36,    -5481 }, /* VERR_DBGC_PARSE_VARIABLE_NOT_FOUND */
    { 0x017b36,  15, 0x0153a1,  19,    -5480 }, /* VERR_DBGC_PARSE_CONVERSION_FAILED */
    { 0x017c08,  15, 0x003bfa,  54,    -5479 }, /* VERR_DBGC_PARSE_NOT_IMPLEMENTED */
    { 0x01a321,  12, 0x005250,  48,    -5478 }, /* VERR_DBGC_PARSE_BAD_RESULT_TYPE */
    { 0x014a6d,  19, 0x00419b,  52,    -5477 }, /* VERR_DBGC_PARSE_WRITEONLY_SYMBOL */
    { 0x0126ce,  22, 0x01582b,  18,    -5476 }, /* VERR_DBGC_PARSE_INVALD_COMMAND_NAME */
    { 0x019784,  13, 0x019019,  14,    -5475 }, /* VERR_DBGC_PARSE_COMMAND_NOT_FOUND */
    { 0x01bd45,   6, 0x0168b3,  17,    -5474 }, /* VERR_DBGC_PARSE_BUG */
    { 0x01be58,   5, 0x01560f,  18,    -5408 }, /* VERR_DBGC_IPE */
    { 0x01a8f9,  11, 0x00f0f1,  26,    -5407 }, /* VERR_DBGC_COMMAND_FAILED */
    { 0x01a741,  11, 0x01ad5c,  10,    -5405 }, /* VERR_DBGC_BP_EXISTS */
    { 0x01bad5,   7, 0x019b65,  12,    -5404 }, /* VERR_DBGC_BP_NOT_FOUND */
    { 0x011e7a,  22, 0x0081fa,  39,    -5403 }, /* VERR_DBGC_COMMANDS_NOT_REGISTERED */
    { 0x01bcc1,   6, 0x00f80d,  26,    -5400 }, /* VERR_DBGC_QUIT */
    { 0x01bef6,   4, 0x01922f,  13,    -5399 }, /* VERR_IEM_IPE_9 */
    { 0x01befa,   4, 0x0192d8,  13,    -5398 }, /* VERR_IEM_IPE_8 */
    { 0x01befe,   4, 0x019854,  13,    -5397 }, /* VERR_IEM_IPE_7 */
    { 0x01bf02,   4, 0x01993e,  13,    -5396 }, /* VERR_IEM_IPE_6 */
    { 0x01bf2e,   4, 0x0192b1,  13,    -5395 }, /* VERR_IEM_IPE_5 */
    { 0x01bf06,   4, 0x0191a0,  13,    -5394 }, /* VERR_IEM_IPE_4 */
    { 0x01bf22,   4, 0x019596,  13,    -5393 }, /* VERR_IEM_IPE_3 */
    { 0x01bf26,   4, 0x0199c0,  13,    -5392 }, /* VERR_IEM_IPE_2 */
    { 0x01bf2a,   4, 0x019a5c,  13,    -5391 }, /* VERR_IEM_IPE_1 */
    { 0x013211,  21, 0x004ee1,  49,    -5390 }, /* VERR_IEM_ASPECT_NOT_IMPLEMENTED */
    { 0x01377b,  21, 0x00cbd6,  29,    -5389 }, /* VERR_IEM_RESTART_INSTRUCTION */
    { 0x014055,  20, 0x018b3b,  14,    -5384 }, /* VERR_IEM_EMIT_UNEXPECTED_VAR_REGISTER */
    { 0x00c966,  30, 0x010c50,  24,    -5383 }, /* VERR_IEM_EMIT_FIXED_JUMP_OUT_OF_RANGE */
    { 0x015501,  18, 0x0132f8,  21,    -5382 }, /* VERR_IEM_EMIT_BAD_SEG_REG_NO */
    { 0x0196e8,  13, 0x00f465,  26,    -5381 }, /* VERR_IEM_EMIT_BAD_MEM_SIZE */
    { 0x00f6bb,  26, 0x0145f5,  20,    -5380 }, /* VERR_IEM_EMIT_CASE_NOT_IMPLEMENTED_1 */
    { 0x01b23c,   9, 0x00dd1b,  28,    -5377 }, /* VERR_IEM_VAR_IPE_13 */
    { 0x01b2d5,   9, 0x00dddf,  28,    -5376 }, /* VERR_IEM_VAR_IPE_12 */
    { 0x01b3ad,   9, 0x00dea3,  28,    -5375 }, /* VERR_IEM_VAR_IPE_11 */
    { 0x01b3e3,   9, 0x00e00f,  28,    -5374 }, /* VERR_IEM_VAR_IPE_10 */
    { 0x01b7f4,   8, 0x00ec1c,  27,    -5373 }, /* VERR_IEM_VAR_IPE_9 */
    { 0x01b904,   8, 0x00ea36,  27,    -5372 }, /* VERR_IEM_VAR_IPE_8 */
    { 0x01b964,   8, 0x00e109,  27,    -5371 }, /* VERR_IEM_VAR_IPE_7 */
    { 0x01b944,   8, 0x00e3e2,  27,    -5370 }, /* VERR_IEM_VAR_IPE_6 */
    { 0x01b94c,   8, 0x00e55c,  27,    -5369 }, /* VERR_IEM_VAR_IPE_5 */
    { 0x01b954,   8, 0x00ed2a,  27,    -5368 }, /* VERR_IEM_VAR_IPE_4 */
    { 0x01b484,   8, 0x00e190,  27,    -5367 }, /* VERR_IEM_VAR_IPE_3 */
    { 0x01b494,   8, 0x00e3c7,  27,    -5366 }, /* VERR_IEM_VAR_IPE_2 */
    { 0x01b23c,   8, 0x00e5ad,  27,    -5365 }, /* VERR_IEM_VAR_IPE_1 */
    { 0x0156b1,  18, 0x010d28,  24,    -5364 }, /* VERR_IEM_VAR_NOT_INITIALIZED */
    { 0x01a90f,  11, 0x016b28,  17,    -5363 }, /* VERR_IEM_VAR_UNEXPECTED_KIND */
    { 0x010818,  24, 0x01595d,  18,    -5362 }, /* VERR_IEM_VAR_OUT_OF_STACK_SLOTS */
    { 0x01720a,  16, 0x009644,  36,    -5361 }, /* VERR_IEM_VAR_DUP_ARG_NO */
    { 0x017afa,  15, 0x0170da,  16,    -5360 }, /* VERR_IEM_VAR_EXHAUSTED */
    { 0x01b34a,   9, 0x00eaa2,  27,    -5355 }, /* VERR_IEM_REG_IPE_13 */
    { 0x01b32f,   9, 0x00e685,  27,    -5354 }, /* VERR_IEM_REG_IPE_12 */
    { 0x01b338,   9, 0x00e793,  27,    -5353 }, /* VERR_IEM_REG_IPE_11 */
    { 0x01b341,   9, 0x00e9ca,  27,    -5352 }, /* VERR_IEM_REG_IPE_10 */
    { 0x01b57c,   8, 0x00f20f,  26,    -5351 }, /* VERR_IEM_REG_IPE_9 */
    { 0x01b734,   8, 0x00f771,  26,    -5350 }, /* VERR_IEM_REG_IPE_8 */
    { 0x01b594,   8, 0x00f7bf,  26,    -5349 }, /* VERR_IEM_REG_IPE_7 */
    { 0x01b59c,   8, 0x00f431,  26,    -5348 }, /* VERR_IEM_REG_IPE_6 */
    { 0x01b5a4,   8, 0x00f18d,  26,    -5347 }, /* VERR_IEM_REG_IPE_5 */
    { 0x01b5ac,   8, 0x00f6a1,  26,    -5346 }, /* VERR_IEM_REG_IPE_4 */
    { 0x01b714,   8, 0x00f5b7,  26,    -5345 }, /* VERR_IEM_REG_IPE_3 */
    { 0x01b724,   8, 0x00f4b3,  26,    -5344 }, /* VERR_IEM_REG_IPE_2 */
    { 0x01b32f,   8, 0x00f1a7,  26,    -5343 }, /* VERR_IEM_REG_IPE_1 */
    { 0x00fbc9,  25, 0x00d4e5,  29,    -5341 }, /* VERR_IEM_REG_ALLOCATOR_NO_FREE_VAR */
    { 0x00fb33,  25, 0x00db23,  28,    -5340 }, /* VERR_IEM_REG_ALLOCATOR_NO_FREE_TMP */
    { 0x01aaa0,  10, 0x019a9d,  13,    -5339 }, /* VERR_IEM_LABEL_IPE_6 */
    { 0x01aaaa,  10, 0x019931,  13,    -5338 }, /* VERR_IEM_LABEL_IPE_5 */
    { 0x01aab4,  10, 0x0197ec,  13,    -5337 }, /* VERR_IEM_LABEL_IPE_4 */
    { 0x01aad2,  10, 0x0195fe,  13,    -5336 }, /* VERR_IEM_LABEL_IPE_3 */
    { 0x01aabe,  10, 0x0191d4,  13,    -5335 }, /* VERR_IEM_LABEL_IPE_2 */
    { 0x01aac8,  10, 0x0199da,  13,    -5334 }, /* VERR_IEM_LABEL_IPE_1 */
    { 0x0178fa,  16, 0x017d8e,  15,    -5333 }, /* VERR_IEM_LABEL_OUT_OF_MEMORY */
    { 0x0193a8,  13, 0x01949f,  13,    -5332 }, /* VERR_IEM_LABEL_TOO_MANY */
    { 0x013939,  20, 0x00b6aa,  32,    -5331 }, /* VERR_IEM_INSTR_BUF_OUT_OF_MEMORY */
    { 0x015993,  18, 0x010e30,  24,    -5330 }, /* VERR_IEM_INSTR_BUF_TOO_LARGE */
    { 0x00be7d,  31, 0x007e44,  40,    -5329 }, /* VERR_IEM_FIXUP_SHORT_JMP_TO_TAIL_LABEL */
    { 0x01743a,  16, 0x0182b6,  15,    -5328 }, /* VERR_IEM_FIXUP_OUT_OF_MEMORY */
    { 0x019297,  13, 0x019374,  13,    -5327 }, /* VERR_IEM_FIXUP_TOO_MANY */
    { 0x01af50,  10, 0x019333,  13,    -5326 }, /* VERR_IEM_FIXUP_IPE_1 */
    { 0x019ded,  12, 0x015c51,  18,    -5325 }, /* VERR_IEM_DBGINFO_IPE_2 */
    { 0x019de1,  12, 0x015da7,  18,    -5324 }, /* VERR_IEM_DBGINFO_IPE_1 */
    { 0x015eb5,  18, 0x00c3e4,  30,    -5323 }, /* VERR_IEM_DBGINFO_OUT_OF_MEMORY */
    { 0x00d10c,  29, 0x007029,  42,    -5322 }, /* VERR_IEM_COND_ENDIF_RECONCILIATION_FAILED */
    { 0x01299e,  21, 0x00b56a,  32,    -5321 }, /* VERR_IEM_COND_TOO_DEEPLY_NESTED */
    { 0x01a2f1,  12, 0x00c108,  31,    -5320 }, /* VERR_IEM_TB_ALLOC_FAILED */
    { 0x01834c,  15, 0x00b9c4,  31,    -5304 }, /* VERR_IEM_INVALID_INSTR_LENGTH */
    { 0x01ae60,  10, 0x006baa,  43,    -5303 }, /* VERR_IEM_INVALID_EFF_SEG */
    { 0x0181c6,  15, 0x009404,  36,    -5302 }, /* VERR_IEM_INVALID_ADDRESS_MODE */
    { 0x01a405,  12, 0x009788,  36,    -5301 }, /* VERR_IEM_INVALID_OPERAND_SIZE */
    { 0x014325,  20, 0x0105bf,  25,    -5300 }, /* VERR_IEM_INSTR_NOT_IMPLEMENTED */
    { 0x00d787,  28, 0x00440b,  52,    -5205 }, /* VERR_GVMM_NOT_ALL_EMTS_DEREGISTERED */
    { 0x01b61c,   8, 0x018d87,  14,    -5204 }, /* VERR_GVMM_IPE_2 */
    { 0x01b614,   8, 0x0189c1,  14,    -5203 }, /* VERR_GVMM_IPE_1 */
    { 0x0162a8,  17, 0x00b2ea,  32,    -5202 }, /* VERR_GVMM_BROKEN_IPRT */
    { 0x013de9,  20, 0x00580f,  47,    -5201 }, /* VERR_GVMM_HOST_CPU_RANGE */
    { 0x018d5d,  14, 0x00ed0f,  27,    -5200 }, /* VERR_GVMM_INSTANCE */
    { 0x00c02f,  31, 0x011e64,  22,    -5102 }, /* VERR_PCI_PASSTHROUGH_NO_NESTED_PAGING */
    { 0x013f51,  20, 0x015297,  19,    -5101 }, /* VERR_PCI_PASSTHROUGH_NO_HM */
    { 0x00c63c,  30, 0x016bd2,  17,    -5100 }, /* VERR_PCI_PASSTHROUGH_NO_RAM_PREALLOC */
    { 0x013835,  20, 0x00c1a3,  31,    -5003 }, /* VERR_FAM_CONNECTION_LOST */
    { 0x010e90,  24, 0x00b4ca,  32,    -5002 }, /* VERR_FAM_MONITOR_DIRECTORY_FAILED */
    { 0x01835b,  15, 0x00b8c8,  32,    -5001 }, /* VERR_FAM_MONITOR_FILE_FAILED */
    { 0x01a9eb,  11, 0x010f1f,  24,    -5000 }, /* VERR_FAM_OPEN_FAILED */
    { 0x017c35,  15, 0x0167d6,  17,    -4904 }, /* VERR_VSCSI_LUN_BUSY */
    { 0x013d71,  20, 0x0102b8,  25,    -4903 }, /* VERR_VSCSI_LUN_NOT_ATTACHED */
    { 0x015ac5,  18, 0x01854a,  15,    -4902 }, /* VERR_VSCSI_LUN_INVALID */
    { 0x00d146,  29, 0x008984,  38,    -4901 }, /* VERR_VSCSI_LUN_ATTACHED_TO_DEVICE */
    { 0x0183d3,  15, 0x01b92c,   8,    -4900 }, /* VERR_VSCSI_LUN_TYPE_NOT_SUPPORTED */
    { 0x0083f5,  39, 0x003c9c,  54,    -4700 }, /* VERR_VMMDEV_CPU_HOTPLUG_NOT_MONITORED_BY_GUEST */
    { 0x018943,  14, 0x004c2a,  50,    -4698 }, /* VERR_COM_OBJECT_NOT_FOUND */
    { 0x01b2de,   9, 0x0093bc,  36,    -4697 }, /* VERR_COM_INVALID_VM_STATE */
    { 0x01b7ec,   8, 0x008332,  39,    -4696 }, /* VERR_COM_VM_ERROR */
    { 0x01bb06,   7, 0x008b26,  38,    -4695 }, /* VERR_COM_FILE_ERROR */
    { 0x01a573,  11, 0x01bd33,   6,    -4694 }, /* VERR_COM_IPRT_ERROR */
    { 0x01ba9d,   7, 0x00f875,  26,    -4693 }, /* VERR_COM_PDM_ERROR */
    { 0x018721,  14, 0x012f71,  21,    -4692 }, /* VERR_COM_INVALID_OBJECT_STATE */
    { 0x01a8ee,  11, 0x00bb38,  31,    -4691 }, /* VERR_COM_HOST_ERROR */
    { 0x01bbb5,   7, 0x018e4b,  14,    -4690 }, /* VERR_COM_NOT_SUPPORTED */
    { 0x01afe6,  10, 0x01bcaf,   6,    -4689 }, /* VERR_COM_XML_ERROR */
    { 0x017fe6,  15, 0x00da5f,  28,    -4688 }, /* VERR_COM_INVALID_SESSION_STATE */
    { 0x015bf7,  18, 0x00cb28,  29,    -4687 }, /* VERR_COM_OBJECT_IN_USE */
    { 0x013af1,  20, 0x000a16,  85,    -4686 }, /* VERR_COM_DONT_CALL_AGAIN */
    { 0x017d70,  15, 0x018ca7,  14,    -4600 }, /* VERR_COM_UNEXPECTED */
    { 0x017f5f,  15, 0x00bb76,  31,    -4304 }, /* VERR_WEB_UNSUPPORTED_INTERFACE */
    { 0x018397,  15, 0x00fe53,  25,    -4303 }, /* VERR_WEB_INVALID_OBJECT_ID */
    { 0x0172da,  16, 0x00b46a,  32,    -4302 }, /* VERR_WEB_INVALID_SESSION_ID */
    { 0x00c9fc,  30, 0x00d653,  28,    -4301 }, /* VERR_WEB_INVALID_MANAGED_OBJECT_REFERENCE */
    { 0x0146b7,  19, 0x006b7f,  43,    -4300 }, /* VERR_WEB_NOT_AUTHENTICATED */
    { 0x0178aa,  16, 0x01b0c2,   9,    -4206 }, /* VERR_DIS_TOO_LONG_INSTR */
    { 0x0185c2,  15, 0x016ce2,  17,    -4204 }, /* VERR_DIS_INVALID_PARAMETER */
    { 0x01a60d,  11, 0x01b514,   8,    -4203 }, /* VERR_DIS_INVALID_MODRM */
    { 0x015167,  19, 0x017dd9,  15,    -4202 }, /* VERR_DIS_NO_READ_CALLBACK */
    { 0x017a5a,  16, 0x00dc03,  28,    -4201 }, /* VERR_DIS_GEN_FAILURE */
    { 0x019bb9,  12, 0x0173aa,  16,    -4200 }, /* VERR_DIS_INVALID_OPCODE */
    { 0x0185ef,  15, 0x019743,  13,    -4116 }, /* VERR_HM_INVALID_HM64ON32OP */
    { 0x01bcd9,   6, 0x019f85,  12,    -4115 }, /* VERR_HM_IPE_5 */
    { 0x01bcdf,   6, 0x019e4d,  12,    -4114 }, /* VERR_HM_IPE_4 */
    { 0x01bce5,   6, 0x019e89,  12,    -4113 }, /* VERR_HM_IPE_3 */
    { 0x0124a8,  22, 0x00fb01,  25,    -4112 }, /* VERR_HM_UNSUPPORTED_CPU_FEATURE_COMBO */
    { 0x015225,  19, 0x0161ee,  17,    -4111 }, /* VERR_HM_UNKNOWN_IO_INSTRUCTION */
    { 0x015db9,  18, 0x0103cb,  25,    -4110 }, /* VERR_HM_WRONG_SWITCHER */
    { 0x01bceb,   6, 0x019d21,  12,    -4109 }, /* VERR_HM_IPE_2 */
    { 0x01bcf1,   6, 0x019b59,  12,    -4108 }, /* VERR_HM_IPE_1 */
    { 0x019aeb,  13, 0x00af8a,  32,    -4107 }, /* VERR_HM_WRONG_CPU */
    { 0x012349,  22, 0x00b7a9,  32,    -4106 }, /* VERR_HM_NO_32_TO_64_SWITCHER */
    { 0x018acb,  14, 0x00d99b,  28,    -4105 }, /* VERR_HM_UNEXPECTED_LD_ST_MSR */
    { 0x016d9c,  16, 0x019089,  14,    -4104 }, /* VERR_HM_ALREADY_ENABLED_IPE */
    { 0x019fe5,  12, 0x0106b0,  24,    -4103 }, /* VERR_HM_CONFIG_MISMATCH */
    { 0x0147d4,  19, 0x00a5f8,  34,    -4100 }, /* VERR_HM_SUSPEND_PENDING */
    { 0x00ddc3,  28, 0x0042d3,  52,    -4075 }, /* VERR_SVM_HOST_VM_HSAVE_PA_INVALID */
    { 0x0111b8,  23, 0x008cc8,  38,    -4074 }, /* VERR_SVM_HOST_SVME_NOT_ENABLED */
    { 0x0145b9,  20, 0x00ae0a,  32,    -4073 }, /* VERR_SVM_VMRUN_PRECOND_3 */
    { 0x0144b5,  20, 0x00b5aa,  32,    -4072 }, /* VERR_SVM_VMRUN_PRECOND_2 */
    { 0x014505,  20, 0x00b908,  32,    -4071 }, /* VERR_SVM_VMRUN_PRECOND_1 */
    { 0x0144f1,  20, 0x00b62a,  32,    -4070 }, /* VERR_SVM_VMRUN_PRECOND_0 */
    { 0x0194c6,  13, 0x00679e,  44,    -4066 }, /* VERR_SVM_VMEXIT_FAILED */
    { 0x01b9e0,   7, 0x01a1f5,  12,    -4065 }, /* VERR_SVM_IPE_5 */
    { 0x01bb53,   7, 0x019d99,  12,    -4064 }, /* VERR_SVM_IPE_4 */
    { 0x01ba03,   7, 0x019bad,  12,    -4063 }, /* VERR_SVM_IPE_3 */
    { 0x01bb30,   7, 0x019c61,  12,    -4062 }, /* VERR_SVM_IPE_2 */
    { 0x01bb45,   7, 0x01a17d,  12,    -4061 }, /* VERR_SVM_IPE_1 */
    { 0x01aeba,  10, 0x010f07,  24,    -4060 }, /* VERR_SVM_UNKNOWN_EXIT */
    { 0x019263,  13, 0x00a61a,  34,    -4059 }, /* VERR_SVM_INVALID_GUEST_STATE */
    { 0x0192cb,  13, 0x01715a,  16,    -4058 }, /* VERR_SVM_UNEXPECTED_PATCH_TYPE */
    { 0x01842d,  15, 0x0140cd,  20,    -4057 }, /* VERR_SVM_UNEXPECTED_XCPT_EXIT */
    { 0x01aeb0,  10, 0x01ad8e,  10,    -4056 }, /* VERR_SVM_UNEXPECTED_EXIT */
    { 0x01aa4e,  11, 0x01bb92,   7,    -4055 }, /* VERR_SVM_INVALID_PVMCB */
    { 0x01a8cd,  11, 0x00ed96,  27,    -4054 }, /* VERR_SVM_IN_USE */
    { 0x01956f,  13, 0x0081d3,  39,    -4053 }, /* VERR_SVM_DISABLED */
    { 0x01b0f8,   9, 0x00bccb,  31,    -4052 }, /* VERR_SVM_NO_SVM */
    { 0x01302e,  21, 0x00db77,  28,    -4051 }, /* VERR_SVM_ILLEGAL_EFER_MSR */
    { 0x0127aa,  22, 0x014195,  20,    -4050 }, /* VERR_SVM_UNABLE_TO_START_VM */
    { 0x014fc5,  19, 0x00a680,  34,    -4042 }, /* VERR_VMX_STARTVM_PRECOND_3 */
    { 0x014ee1,  19, 0x00a83a,  34,    -4041 }, /* VERR_VMX_STARTVM_PRECOND_2 */
    { 0x014f40,  19, 0x00a63c,  34,    -4040 }, /* VERR_VMX_STARTVM_PRECOND_1 */
    { 0x014f07,  19, 0x00a1b8,  34,    -4039 }, /* VERR_VMX_STARTVM_PRECOND_0 */
    { 0x0176ca,  16, 0x00efed,  26,    -4038 }, /* VERR_VMX_INVALID_VMCS_LAUNCH_STATE */
    { 0x01b0ae,  10, 0x016ddc,  16,    -4034 }, /* VERR_VMX_VMEXIT_FAILED */
    { 0x01aa22,  11, 0x019f91,  12,    -4033 }, /* VERR_VMX_VMENTRY_FAILED */
    { 0x015011,  19, 0x002b94,  59,    -4032 }, /* VERR_VMX_MSR_SMX_VMX_ENABLE_FAILED */
    { 0x01822f,  15, 0x00370e,  56,    -4031 }, /* VERR_VMX_MSR_VMX_ENABLE_FAILED */
    { 0x00ee9b,  26, 0x00c54c,  30,    -4030 }, /* VERR_VMX_VMCS_FIELD_CACHE_INVALID */
    { 0x017dca,  15, 0x00c5e2,  30,    -4029 }, /* VERR_VMX_MSR_VMX_DISABLED */
    { 0x0150f5,  19, 0x003746,  56,    -4028 }, /* VERR_VMX_MSR_ALL_VMX_DISABLED */
    { 0x01bee2,   4, 0x019e71,  12,    -4027 }, /* VERR_VMX_IPE_5 */
    { 0x01bee6,   4, 0x01a3e1,  12,    -4026 }, /* VERR_VMX_IPE_4 */
    { 0x01beea,   4, 0x01a2b5,  12,    -4025 }, /* VERR_VMX_IPE_3 */
    { 0x01bf5a,   4, 0x019b11,  12,    -4024 }, /* VERR_VMX_IPE_2 */
    { 0x01bf5e,   4, 0x019b89,  12,    -4023 }, /* VERR_VMX_IPE_1 */
    { 0x0121e9,  22, 0x007bc4,  40,    -4022 }, /* VERR_VMX_INVALID_VMCS_PTR_TO_START_VM */
    { 0x01a526,  11, 0x005cf8,  46,    -4021 }, /* VERR_VMX_VMPTRLD_FAILED */
    { 0x012b57,  21, 0x016089,  18,    -4019 }, /* VERR_VMX_UNDEFINED_EXIT_CODE */
    { 0x0177ea,  16, 0x004029,  53,    -4018 }, /* VERR_VMX_NOT_IN_VMX_ROOT_MODE */
    { 0x012425,  22, 0x010728,  24,    -4017 }, /* VERR_VMX_UNEXPECTED_INTERRUPTION_EXIT_TYPE */
    { 0x01a315,  12, 0x019ad1,  13,    -4016 }, /* VERR_VMX_UNEXPECTED_EXCEPTION */
    { 0x01bb14,   7, 0x01b584,   8,    -4015 }, /* VERR_VMX_UNEXPECTED_EXIT */
    { 0x01adca,  10, 0x012005,  22,    -4014 }, /* VERR_VMX_INVALID_GUEST_STATE */
    { 0x017c9e,  15, 0x00d0d2,  29,    -4013 }, /* VERR_VMX_MSR_LOCKING_FAILED */
    { 0x0124be,  22, 0x005e67,  45,    -4012 }, /* VERR_VMX_X86_CR4_VMXE_CLEARED */
    { 0x018400,  15, 0x00228f,  63,    -4011 }, /* VERR_VMX_IN_VMX_ROOT_MODE */
    { 0x01bcf7,   6, 0x0084df,  39,    -4009 }, /* VERR_VMX_NO_VMX */
    { 0x01b3c8,   9, 0x00efd3,  26,    -4006 }, /* VERR_VMX_INVALID_HOST_STATE */
    { 0x0151d9,  19, 0x014195,  20,    -4005 }, /* VERR_VMX_UNABLE_TO_START_VM */
    { 0x019b29,  12, 0x017fc8,  15,    -4004 }, /* VERR_VMX_INVALID_VMXON_PTR */
    { 0x01ad0c,  10, 0x001464,  70,    -4003 }, /* VERR_VMX_RESERVED */
    { 0x00149c,  13, 0x0088ec,  38,    -4002 }, /* VERR_VMX_INVALID_VMCS_FIELD */
    { 0x00148f,  11, 0x018a77,  14,    -4001 }, /* VERR_VMX_INVALID_VMCS_PTR */
    { 0x01b140,   9, 0x007b74,  40,    -4000 }, /* VERR_VMX_VMXON_FAILED */
    { 0x018bab,  14, 0x0050cb,  49,    -3907 }, /* VERR_GVM_MISMATCH_SVN_REV */
    { 0x015284,  19, 0x00846a,  39,    -3906 }, /* VERR_GVM_MISMATCH_VM_STRUCT_VER */
    { 0x018759,  14, 0x005639,  47,    -3905 }, /* VERR_GVM_MISMATCH_VMCPU_SIZE */
    { 0x01ab7c,  10, 0x006e04,  43,    -3904 }, /* VERR_GVM_MISMATCH_VM_SIZE */
    { 0x01ab40,  10, 0x00eee9,  26,    -3900 }, /* VERR_GVM_TOO_MANY_VMS */
    { 0x00d38a,  29, 0x003d08,  54,    -3831 }, /* VERR_GMM_SHARED_MODULE_BAD_REGIONS_SIZE */
    { 0x01351a,  21, 0x00a50a,  34,    -3830 }, /* VERR_GMM_BAD_SHARED_MODULE_SIZE */
    { 0x0133df,  21, 0x015c1b,  18,    -3829 }, /* VERR_GMM_SHARED_MODULE_NOT_FOUND */
    { 0x00b5ca,  32, 0x0016d4,  68,    -3828 }, /* VERR_GMM_SHARED_MODULE_ADDRESS_CLASH */
    { 0x0134b1,  21, 0x011d5c,  22,    -3826 }, /* VERR_GMM_TOO_MANY_GLOBAL_MODULES */
    { 0x013ed9,  20, 0x011d5c,  22,    -3825 }, /* VERR_GMM_TOO_MANY_PER_VM_MODULES */
    { 0x018e67,  14, 0x00f7d9,  26,    -3824 }, /* VERR_GMM_TOO_MANY_REGIONS */
    { 0x01524b,  19, 0x010668,  24,    -3823 }, /* VERR_GMM_MODULE_VERSION_TOO_LONG */
    { 0x011d04,  22, 0x00e2d4,  27,    -3822 }, /* VERR_GMM_MODULE_NAME_TOO_LONG */
    { 0x01306d,  21, 0x009305,  37,    -3821 }, /* VERR_GMM_ACTUAL_PAGES_IPE */
    { 0x013f79,  20, 0x01768a,  16,    -3820 }, /* VERR_GMM_ALLOC_PAGES_IPE */
    { 0x019035,  14, 0x011732,  23,    -3819 }, /* VERR_GMM_MTX_FLAGS */
    { 0x0191c7,  13, 0x0118fe,  23,    -3818 }, /* VERR_GMM_INSTANCE */
    { 0x016d6a,  17, 0x01139b,  23,    -3817 }, /* VERR_GMM_CHUNK_INSERT */
    { 0x0197f9,  13, 0x014339,  20,    -3816 }, /* VERR_GMM_IS_NOT_SANE */
    { 0x00ecbe,  27, 0x0004b9,  98,    -3815 }, /* VERR_GMM_MEMORY_RESERVATION_DECLINED */
    { 0x013322,  21, 0x0087bc,  38,    -3814 }, /* VERR_GMM_TOO_MANY_CHUNK_MAPPINGS */
    { 0x015537,  18, 0x003d3e,  54,    -3813 }, /* VERR_GMM_CHUNK_NOT_MAPPED */
    { 0x015591,  18, 0x00bc30,  31,    -3812 }, /* VERR_GMM_CHUNK_ALREADY_MAPPED */
    { 0x01953b,  13, 0x01a849,  11,    -3811 }, /* VERR_GMM_CHUNK_NOT_FOUND */
    { 0x01a369,  12, 0x0079b5,  41,    -3810 }, /* VERR_GMM_NOT_PAGE_OWNER */
    { 0x01a623,  11, 0x0156e7,  18,    -3809 }, /* VERR_GMM_PAGE_ALREADY_FREE */
    { 0x019888,  13, 0x00dc8f,  28,    -3808 }, /* VERR_GMM_PAGE_NOT_SHARED */
    { 0x018c45,  14, 0x00d007,  29,    -3807 }, /* VERR_GMM_PAGE_NOT_PRIVATE */
    { 0x01b8d4,   8, 0x011fc3,  22,    -3806 }, /* VERR_GMM_PAGE_NOT_FOUND */
    { 0x00ccbe,  29, 0x008724,  38,    -3805 }, /* VERR_GMM_ATTEMPT_TO_DEFLATE_TOO_MUCH */
    { 0x00ee4d,  26, 0x00436f,  52,    -3804 }, /* VERR_GMM_ATTEMPT_TO_FREE_TOO_MUCH */
    { 0x010ea8,  24, 0x0112fa,  23,    -3803 }, /* VERR_GMM_HIT_VM_ACCOUNT_LIMIT */
    { 0x012f5c,  21, 0x00d41b,  29,    -3802 }, /* VERR_GMM_HIT_GLOBAL_LIMIT */
    { 0x019af8,  13, 0x007ad4,  40,    -3801 }, /* VERR_GMM_OUT_OF_MEMORY */
    { 0x0190f9,  14, 0x0069a6,  43,    -3778 }, /* VERR_SUPLIB_UNEXPECTED_INSTRUCTION */
    { 0x018b1f,  14, 0x004bc6,  50,    -3777 }, /* VERR_SUPLIB_TEXT_NOT_SEALED */
    { 0x016440,  17, 0x010770,  24,    -3776 }, /* VERR_SUPLIB_TEXT_NOT_WRITEABLE */
    { 0x010dd0,  24, 0x00df2f,  28,    -3775 }, /* VERR_SUPLIB_NT_PROCESS_UNTRUSTED_5 */
    { 0x010ab8,  24, 0x00dcff,  28,    -3774 }, /* VERR_SUPLIB_NT_PROCESS_UNTRUSTED_4 */
    { 0x010db8,  24, 0x00d74f,  28,    -3773 }, /* VERR_SUPLIB_NT_PROCESS_UNTRUSTED_3 */
    { 0x010c08,  24, 0x00db93,  28,    -3772 }, /* VERR_SUPLIB_NT_PROCESS_UNTRUSTED_2 */
    { 0x010b48,  24, 0x00d9ef,  28,    -3771 }, /* VERR_SUPLIB_NT_PROCESS_UNTRUSTED_1 */
    { 0x010b18,  24, 0x00df83,  28,    -3770 }, /* VERR_SUPLIB_NT_PROCESS_UNTRUSTED_0 */
    { 0x01a946,  11, 0x007fd4,  40,    -3769 }, /* VERR_SUPLIB_INVALID_INTERNAL_APP_DIR */
    { 0x016b06,  17, 0x00551f,  47,    -3768 }, /* VERR_SUPLIB_INVALID_ARGV0_INTERNAL */
    { 0x01727a,  16, 0x012c68,  21,    -3767 }, /* VERR_SUPLIB_WORLD_WRITABLE */
    { 0x01349c,  21, 0x005d54,  46,    -3766 }, /* VERR_SUPLIB_WRITE_NON_SYS_GROUP */
    { 0x01982d,  13, 0x018694,  15,    -3765 }, /* VERR_SUPLIB_OWNER_NOT_ROOT */
    { 0x018c99,  14, 0x00c588,  30,    -3764 }, /* VERR_SUPLIB_NOT_SAME_OBJECT */
    { 0x01b20f,   9, 0x0193e9,  13,    -3763 }, /* VERR_SUPLIB_IS_FILE */
    { 0x0189a5,  14, 0x019895,  13,    -3762 }, /* VERR_SUPLIB_IS_DIRECTORY */
    { 0x019fc1,  12, 0x00a1da,  34,    -3761 }, /* VERR_SUPLIB_NOT_DIR_NOT_FILE */
    { 0x00f9bc,  25, 0x00c786,  30,    -3760 }, /* VERR_SUPLIB_SYMLINKS_ARE_NOT_PERMITTED */
    { 0x01b419,   9, 0x010128,  25,    -3759 }, /* VERR_SUPLIB_FSTAT_FAILED */
    { 0x01b7d4,   8, 0x0153da,  19,    -3758 }, /* VERR_SUPLIB_STAT_FAILED */
    { 0x019478,  13, 0x0089d0,  38,    -3757 }, /* VERR_SUPLIB_STAT_ENUM_FAILED */
    { 0x01a3a5,  12, 0x018ed7,  14,    -3756 }, /* VERR_SUPLIB_DIR_ENUM_FAILED */
    { 0x018db1,  14, 0x019777,  13,    -3755 }, /* VERR_SUPLIB_PATH_IS_ROOT */
    { 0x014e6f,  19, 0x015819,  18,    -3754 }, /* VERR_SUPLIB_PATH_TOO_MANY_COMPONENTS */
    { 0x019485,  13, 0x01a0ed,  12,    -3753 }, /* VERR_SUPLIB_PATH_TOO_SHORT */
    { 0x01a201,  12, 0x01a967,  11,    -3752 }, /* VERR_SUPLIB_PATH_TOO_LONG */
    { 0x0196b4,  13, 0x019dbd,  12,    -3751 }, /* VERR_SUPLIB_PATH_NOT_CLEAN */
    { 0x01707b,  16, 0x017dbb,  15,    -3750 }, /* VERR_SUPLIB_PATH_NOT_ABSOLUTE */
    { 0x01285a,  22, 0x006fab,  42,    -3749 }, /* VERR_SUPDRV_NOT_BUDDING_VM_PROCESS_2 */
    { 0x012844,  22, 0x0070a7,  42,    -3748 }, /* VERR_SUPDRV_NOT_BUDDING_VM_PROCESS_1 */
    { 0x00da97,  28, 0x004675,  51,    -3747 }, /* VERR_SUPDRV_TSC_DELTA_MEASUREMENT_BUSY */
    { 0x019ff1,  12, 0x00e124,  27,    -3745 }, /* VERR_SUPDRV_TSC_READ_FAILED */
    { 0x010d70,  24, 0x00e9af,  27,    -3744 }, /* VERR_SUPDRV_TSC_FREQ_MEASUREMENT_FAILED */
    { 0x0100ab,  25, 0x008c7c,  38,    -3743 }, /* VERR_SUPDRV_TSC_DELTA_MEASUREMENT_FAILED */
    { 0x01556d,  18, 0x00a2ea,  34,    -3742 }, /* VERR_SUPDRV_APIPORT_OPEN_ERROR_TYPE */
    { 0x01ad70,  10, 0x00405e,  53,    -3741 }, /* VERR_SUPDRV_CSRSS_NOT_FOUND */
    { 0x010f7f,  24, 0x008ffc,  37,    -3740 }, /* VERR_SUPDRV_SESSION_PROCESS_ENUM_ERROR */
    { 0x01556d,  16, 0x00d1d7,  29,    -3739 }, /* VERR_SUPDRV_APIPORT_OPEN_ERROR */
    { 0x0111a1,  23, 0x00057c,  97,    -3738 }, /* VERR_SUPDRV_HARDENING_EVIL_HANDLE */
    { 0x00dc1f,  28, 0x0061be,  45,    -3737 }, /* VERR_SUPDRV_TRACER_UMOD_STRTAB_OFF_BAD */
    { 0x0100c4,  25, 0x007539,  41,    -3736 }, /* VERR_SUPDRV_TRACER_UMOD_STRTAB_TOO_BIG */
    { 0x0125f2,  22, 0x002fef,  58,    -3735 }, /* VERR_SUPDRV_TRACER_UMOD_TOO_MANY_PROBES */
    { 0x011481,  23, 0x002e93,  58,    -3734 }, /* VERR_SUPDRV_TRACER_UMOD_NOT_ADJACENT */
    { 0x01852c,  15, 0x00c6f0,  30,    -3733 }, /* VERR_SUPDRV_TRACER_TOO_LARGE */
    { 0x013e9d,  20, 0x005a14,  47,    -3732 }, /* VERR_SUPDRV_TRACER_TOO_MANY_PROVIDERS */
    { 0x01479b,  19, 0x01704b,  16,    -3731 }, /* VERR_SUPDRV_TRACER_BAD_ARG_FLAGS */
    { 0x00fee9,  25, 0x00924c,  37,    -3730 }, /* VERR_SUPDRV_TRACER_CANNOT_OPEN_SELF */
    { 0x012aaf,  21, 0x006b54,  43,    -3729 }, /* VERR_SUPDRV_TRACER_SESSION_BUSY */
    { 0x015939,  18, 0x0149c2,  19,    -3728 }, /* VERR_SUPDRV_TRACER_UNLOADING */
    { 0x0167a3,  17, 0x00f93f,  25,    -3727 }, /* VERR_SUPDRV_TRACER_NOT_PRESENT */
    { 0x01792a,  16, 0x016041,  18,    -3726 }, /* VERR_SUPDRV_TRACER_NOT_OPENED */
    { 0x01798a,  16, 0x00abfa,  33,    -3725 }, /* VERR_SUPDRV_TRACER_ALREADY_OPENED */
    { 0x013eed,  20, 0x009b73,  35,    -3724 }, /* VERR_SUPDRV_TRACER_NOT_REGISTERED */
    { 0x013d0d,  20, 0x0117ea,  23,    -3723 }, /* VERR_SUPDRV_TRACER_ALREADY_REGISTERED */
    { 0x00e850,  27, 0x00a4a4,  34,    -3722 }, /* VERR_SUPDRV_VTG_ONLY_ONCE_PER_SESSION */
    { 0x0161ff,  17, 0x00b828,  32,    -3721 }, /* VERR_SUPDRV_VTG_ALREADY_REGISTERED */
    { 0x01763a,  16, 0x00e727,  27,    -3720 }, /* VERR_SUPDRV_VTG_BAD_PROBE_LOC */
    { 0x01439d,  20, 0x0108f0,  24,    -3719 }, /* VERR_SUPDRV_VTG_BAD_PROBE_ENABLED */
    { 0x018a4d,  14, 0x00c52e,  30,    -3718 }, /* VERR_SUPDRV_VTG_BAD_ARGLIST */
    { 0x01439d,  12, 0x011f81,  22,    -3717 }, /* VERR_SUPDRV_VTG_BAD_PROBE */
    { 0x017b72,  15, 0x00fc2d,  25,    -3716 }, /* VERR_SUPDRV_VTG_BAD_PROVIDER */
    { 0x01a4e4,  11, 0x016e4c,  16,    -3715 }, /* VERR_SUPDRV_VTG_BAD_ATTR */
    { 0x01952e,  13, 0x019cf1,  12,    -3714 }, /* VERR_SUPDRV_VTG_STRING_TOO_LONG */
    { 0x01b844,   8, 0x019d81,  12,    -3713 }, /* VERR_SUPDRV_VTG_BAD_STRING */
    { 0x0177ca,  16, 0x018871,  14,    -3712 }, /* VERR_SUPDRV_VTG_STRTAB_OFF */
    { 0x0141f9,  20, 0x00a0a5,  35,    -3711 }, /* VERR_SUPDRV_VTG_BAD_HDR_NOT_MULTIPLE */
    { 0x0173ca,  16, 0x017e60,  15,    -3710 }, /* VERR_SUPDRV_VTG_BAD_HDR_TOO_MUCH */
    { 0x0184ff,  15, 0x018d79,  14,    -3709 }, /* VERR_SUPDRV_VTG_BAD_HDR_TOO_FEW */
    { 0x018da3,  14, 0x017f05,  15,    -3708 }, /* VERR_SUPDRV_VTG_BAD_HDR_PTR */
    { 0x01889b,  14, 0x017f05,  15,    -3707 }, /* VERR_SUPDRV_VTG_BAD_HDR_OFF */
    { 0x017bdb,  15, 0x01968d,  13,    -3706 }, /* VERR_SUPDRV_VTG_BAD_HDR_MISC */
    { 0x01aec4,  10, 0x01702b,  16,    -3705 }, /* VERR_SUPDRV_VTG_BITS */
    { 0x01a799,  11, 0x01a3bd,  12,    -3704 }, /* VERR_SUPDRV_VTG_MAGIC */
    { 0x012d10,  21, 0x014691,  19,    -3703 }, /* VERR_SUPDRV_KERNEL_TOO_OLD_FOR_VTX */
    { 0x019fa9,  12, 0x014b64,  19,    -3702 }, /* VERR_SUPDRV_SERVICE_NOT_FOUND */
    { 0x01890b,  14, 0x0086d8,  38,    -3701 }, /* VERR_SUPDRV_INTERFACE_NOT_SUPPORTED */
    { 0x0190b3,  14, 0x011cee,  22,    -3700 }, /* VERR_SUPDRV_COMPONENT_NOT_FOUND */
    { 0x00d947,  28, 0x00fb65,  25,    -3611 }, /* VERR_INTNET_FLT_LOWER_LINK_ID_NOT_FOUND */
    { 0x00d129,  29, 0x00aeea,  32,    -3610 }, /* VERR_INTNET_FLT_LOWER_LINK_OPEN_FAILED */
    { 0x00c6d2,  30, 0x0080c2,  39,    -3609 }, /* VERR_INTNET_FLT_LOWER_LINK_INFO_NOT_FOUND */
    { 0x0116bf,  23, 0x00642e,  44,    -3608 }, /* VERR_INTNET_FLT_VNIC_OPEN_FAILED */
    { 0x011a85,  23, 0x0049a0,  50,    -3607 }, /* VERR_INTNET_FLT_VNIC_INIT_FAILED */
    { 0x00ec01,  27, 0x00554e,  47,    -3606 }, /* VERR_INTNET_FLT_VNIC_LINK_ID_NOT_FOUND */
    { 0x0103e4,  25, 0x005ad0,  46,    -3605 }, /* VERR_INTNET_FLT_VNIC_CREATE_FAILED */
    { 0x00f61f,  26, 0x0015c0,  69,    -3604 }, /* VERR_INTNET_INCOMPATIBLE_FLAGS */
    { 0x00ef85,  26, 0x004a36,  50,    -3603 }, /* VERR_INTNET_INCOMPATIBLE_TRUNK */
    { 0x016f2b,  16, 0x004fa5,  49,    -3602 }, /* VERR_INTNET_FLT_IF_FAILED */
    { 0x014aa6,  19, 0x0044db,  52,    -3601 }, /* VERR_INTNET_FLT_IF_BUSY */
    { 0x016473,  17, 0x00ab13,  33,    -3600 }, /* VERR_INTNET_FLT_IF_NOT_FOUND */
    { 0x016770,  17, 0x00c21f,  31,    -3504 }, /* VERR_VGA_GL_SYMBOL_NOT_FOUND */
    { 0x014569,  20, 0x008a1c,  38,    -3503 }, /* VERR_VGA_GL_LOAD_FAILURE */
    { 0x00dff3,  28, 0x006083,  45,    -3502 }, /* VERR_VGA_UNEXPECTED_PCI_REGION_LOAD_CHANGE */
    { 0x01660b,  17, 0x00c38a,  30,    -3500 }, /* VERR_VGA_INVALID_CUSTOM_MODE */
    { 0x00e4d5,  27, 0x00b04a,  32,    -3408 }, /* VERR_VUSB_USB_DEVICE_PERMISSION */
    { 0x0101f0,  25, 0x008491,  39,    -3407 }, /* VERR_VUSB_DEVICE_IS_SUSPENDED */
    { 0x0104f7,  25, 0x007510,  41,    -3406 }, /* VERR_VUSB_DEVICE_IS_RESETTING */
    { 0x0124d4,  22, 0x00b04a,  32,    -3405 }, /* VERR_VUSB_USBFS_PERMISSION */
    { 0x013bcd,  20, 0x00b769,  32,    -3404 }, /* VERR_VUSB_DEVICE_NAME_NOT_FOUND */
    { 0x013fc9,  20, 0x009c68,  35,    -3403 }, /* VERR_VUSB_FAILED_TO_QUEUE_URB */
    { 0x019b71,  12, 0x0150a9,  19,    -3402 }, /* VERR_VUSB_NO_URB_MEMORY */
    { 0x012375,  22, 0x007d7c,  40,    -3401 }, /* VERR_VUSB_DEVICE_NOT_ATTACHED */
    { 0x01a069,  12, 0x010173,  25,    -3400 }, /* VERR_VUSB_NO_PORTS */
    { 0x019ac4,  13, 0x0153c7,  19,    -3302 }, /* VERR_VBGL_IOCTL_FAILED */
    { 0x01a568,  11, 0x008a68,  38,    -3301 }, /* VERR_VBGL_INVALID_ADDR */
    { 0x015b9d,  18, 0x0120f7,  22,    -3300 }, /* VERR_VBGL_NOT_INITIALIZED */
    { 0x01a875,  11, 0x015765,  18,    -3290 }, /* VERR_VD_SHRINK_NOT_SUPPORTED */
    { 0x014859,  19, 0x00c7a4,  30,    -3289 }, /* VERR_VD_RAW_SIZE_FLOPPY_TOO_BIG */
    { 0x012818,  22, 0x008d60,  38,    -3288 }, /* VERR_VD_RAW_SIZE_OPTICAL_TOO_SMALL */
    { 0x015271,  19, 0x00c184,  31,    -3287 }, /* VERR_VD_RAW_SIZE_MODULO_2048 */
    { 0x015e01,  18, 0x00c90c,  30,    -3286 }, /* VERR_VD_RAW_SIZE_MODULO_512 */
    { 0x014b9d,  19, 0x006c00,  43,    -3285 }, /* VERR_VD_DMG_NOT_FOUND_INSIDE_XAR */
    { 0x019eb9,  12, 0x011801,  23,    -3284 }, /* VERR_VD_DMG_XML_PARSE_ERROR */
    { 0x014ccd,  19, 0x00512d,  49,    -3282 }, /* VERR_VD_READ_OUT_OF_RANGE */
    { 0x010399,  25, 0x006218,  45,    -3281 }, /* VERR_VD_IMAGE_REPAIR_IMPOSSIBLE */
    { 0x016c5a,  17, 0x0181f3,  15,    -3280 }, /* VERR_VD_IMAGE_REPAIR_NOT_SUPPORTED */
    { 0x0164fb,  17, 0x00a6c4,  34,    -3279 }, /* VERR_VD_IMAGE_CORRUPTED */
    { 0x01a291,  12, 0x00a5b4,  34,    -3278 }, /* VERR_VD_DISCARD_NOT_SUPPORTED */
    { 0x010cf8,  24, 0x007f84,  40,    -3277 }, /* VERR_VD_DISCARD_ALIGNMENT_NOT_MET */
    { 0x014ca7,  19, 0x00f583,  26,    -3276 }, /* VERR_VD_CACHE_NOT_UP_TO_DATE */
    { 0x01ae4c,  10, 0x00aeca,  32,    -3275 }, /* VERR_VD_CACHE_NOT_FOUND */
    { 0x01841e,  15, 0x00b44a,  32,    -3274 }, /* VERR_VD_CACHE_ALREADY_EXISTS */
    { 0x01a171,  12, 0x001a01,  67,    -3273 }, /* VERR_VD_IOCTX_HALT */
    { 0x015657,  18, 0x004237,  52,    -3272 }, /* VERR_VD_NOT_ENOUGH_METADATA */
    { 0x01b934,   8, 0x019ade,  13,    -3271 }, /* VERR_VD_RAW_INVALID_TYPE */
    { 0x0197df,  13, 0x0180e5,  15,    -3270 }, /* VERR_VD_RAW_INVALID_HEADER */
    { 0x0195e4,  13, 0x017c80,  15,    -3267 }, /* VERR_VD_DMG_INVALID_HEADER */
    { 0x015024,  19, 0x00ffb1,  25,    -3265 }, /* VERR_VD_PARALLELS_INVALID_HEADER */
    { 0x0198c9,  13, 0x017c26,  15,    -3260 }, /* VERR_VD_VHD_INVALID_HEADER */
    { 0x010e18,  24, 0x009d80,  35,    -3253 }, /* VERR_VD_ISCSI_SECRET_ENCRYPTED */
    { 0x01aafa,  10, 0x0114dd,  23,    -3252 }, /* VERR_VD_ISCSI_INVALID_TYPE */
    { 0x01ab72,  10, 0x006029,  45,    -3251 }, /* VERR_VD_ISCSI_INVALID_STATE */
    { 0x01808b,  15, 0x016053,  18,    -3250 }, /* VERR_VD_ISCSI_INVALID_HEADER */
    { 0x01945e,  13, 0x01259a,  22,    -3245 }, /* VERR_VD_VMDK_INVALID_WRITE */
    { 0x018e3d,  14, 0x00a03c,  35,    -3244 }, /* VERR_VD_VMDK_INVALID_FORMAT */
    { 0x01b1b5,   9, 0x0066c2,  44,    -3243 }, /* VERR_VD_VMDK_INVALID_STATE */
    { 0x017de8,  15, 0x0117d3,  23,    -3242 }, /* VERR_VD_VMDK_VALUE_NOT_FOUND */
    { 0x01b296,   9, 0x00f1c1,  26,    -3241 }, /* VERR_VD_VMDK_UNSUPPORTED_VERSION */
    { 0x018fe1,  14, 0x01737a,  16,    -3240 }, /* VERR_VD_VMDK_INVALID_HEADER */
    { 0x014ece,  19, 0x01799a,  16,    -3233 }, /* VERR_VD_VDI_COMMENT_TOO_LONG */
    { 0x01b75c,   8, 0x010448,  25,    -3232 }, /* VERR_VD_VDI_UNSUPPORTED_VERSION */
    { 0x016f6b,  16, 0x00e90d,  27,    -3231 }, /* VERR_VD_VDI_INVALID_SIGNATURE */
    { 0x019680,  13, 0x018130,  15,    -3230 }, /* VERR_VD_VDI_INVALID_HEADER */
    { 0x019917,  13, 0x014775,  19,    -3220 }, /* VERR_VD_GEN_INVALID_HEADER */
    { 0x013961,  20, 0x006352,  44,    -3215 }, /* VERR_VD_PASSWORD_INCORRECT */
    { 0x01ba2d,   7, 0x00c23e,  31,    -3214 }, /* VERR_VD_DEK_MISSING */
    { 0x019f31,  12, 0x014f8c,  19,    -3213 }, /* VERR_VD_UNKNOWN_INTERFACE */
    { 0x0196db,  13, 0x0109c8,  24,    -3212 }, /* VERR_VD_UNKNOWN_CFG_VALUES */
    { 0x01bf0e,   4, 0x00bc4f,  31,    -3211 }, /* VERR_VD_INVALID_SIZE */
    { 0x012558,  22, 0x00b749,  32,    -3210 }, /* VERR_VD_ASYNC_IO_IN_PROGRESS */
    { 0x01b774,   8, 0x0029f7,  59,    -3208 }, /* VERR_VD_UUID_MISMATCH */
    { 0x01a2e5,  12, 0x012a70,  21,    -3207 }, /* VERR_VD_BLOCK_FREE */
    { 0x01807c,  15, 0x012d4f,  21,    -3206 }, /* VERR_VD_GEOMETRY_NOT_SET */
    { 0x016c38,  17, 0x016c9e,  17,    -3205 }, /* VERR_VD_IMAGE_READ_ONLY */
    { 0x01ae9c,  10, 0x0137f9,  20,    -3204 }, /* VERR_VD_IMAGE_NOT_FOUND */
    { 0x01b272,   9, 0x01330d,  21,    -3203 }, /* VERR_VD_NOT_OPENED */
    { 0x01af78,  10, 0x016550,  17,    -3202 }, /* VERR_VD_VALUE_NOT_FOUND */
    { 0x01bf12,   4, 0x004774,  51,    -3201 }, /* VERR_VD_INVALID_STATE */
    { 0x01bf16,   4, 0x01bae3,   7,    -3200 }, /* VERR_VD_INVALID_TYPE */
    { 0x018f8d,  14, 0x005b88,  46,    -3105 }, /* VERR_HOSTIF_TERM_FAILED */
    { 0x010e00,  24, 0x0008b9,  88,    -3104 }, /* VERR_HOSTIF_FD_AND_INIT_TERM */
    { 0x0173fa,  16, 0x003bc4,  54,    -3103 }, /* VERR_HOSTIF_BLOCKING */
    { 0x019256,  13, 0x00480d,  51,    -3102 }, /* VERR_HOSTIF_IOCTL */
    { 0x00fdef,  25, 0x007c3c,  40,    -3101 }, /* VERR_HOSTIF_DEVICE_NAME_TOO_LONG */
    { 0x018a85,  14, 0x00774e,  41,    -3100 }, /* VERR_HOSTIF_INIT_FAILED */
    { 0x016e9c,  16, 0x009590,  36,    -3002 }, /* VERR_NAT_REDIR_SETUP */
    { 0x0147fa,  19, 0x0072f3,  42,    -3001 }, /* VERR_NAT_REDIR_GUEST_IP */
    { 0x013a29,  20, 0x009f6a,  35,    -2909 }, /* VERR_HGCM_TOO_MANY_CLIENT_CALLS */
    { 0x017faa,  15, 0x01157d,  23,    -2908 }, /* VERR_HGCM_TOO_MANY_CLIENTS */
    { 0x013ab5,  20, 0x00f37b,  26,    -2907 }, /* VERR_HGCM_SERVICE_EXISTS */
    { 0x017a6a,  16, 0x01711a,  16,    -2905 }, /* VERR_HGCM_INVALID_CLIENT_ID */
    { 0x018b73,  14, 0x00e484,  27,    -2904 }, /* VERR_HGCM_INTERNAL */
    { 0x015e37,  18, 0x0103fd,  25,    -2902 }, /* VERR_HGCM_INVALID_CMD_ADDRESS */
    { 0x01775a,  16, 0x00ef1d,  26,    -2900 }, /* VERR_HGCM_SERVICE_NOT_FOUND */
    { 0x015d95,  18, 0x015d05,  18,    -2899 }, /* VERR_PDM_MEDIAEX_IOREQ_INVALID_STATE */
    { 0x01399d,  20, 0x019ead,  12,    -2897 }, /* VERR_PDM_MEDIAEX_IOREQID_NOT_FOUND */
    { 0x00f3af,  26, 0x014221,  20,    -2896 }, /* VERR_PDM_MEDIAEX_IOREQID_CONFLICT */
    { 0x010f37,  24, 0x00a284,  34,    -2895 }, /* VERR_PDM_MEDIAEX_IOBUF_UNDERRUN */
    { 0x0106c8,  24, 0x00ab55,  33,    -2894 }, /* VERR_PDM_MEDIAEX_IOBUF_OVERFLOW */
    { 0x010a28,  24, 0x016efb,  16,    -2893 }, /* VERR_PDM_MEDIAEX_IOREQ_CANCELED */
    { 0x01b4d4,   8, 0x002a6d,  59,    -2892 }, /* VERR_PDM_HM_IPE */
    { 0x0163fc,  17, 0x001c93,  65,    -2891 }, /* VERR_PDM_NOT_PCI_BUS_MASTER */
    { 0x00aa2c,  33, 0x0033f9,  57,    -2890 }, /* VERR_PDM_CANNOT_TRANSFORM_REMOVED_DRIVER */
    { 0x00a30c,  34, 0x00c0e9,  31,    -2889 }, /* VERR_PDM_MISCONFIGURED_DRV_TRANSFORMATION */
    { 0x01b7a4,   8, 0x01971c,  13,    -2888 }, /* VERR_PDM_DEV_IPE_1 */
    { 0x019410,  13, 0x014c22,  19,    -2887 }, /* VERR_PDM_BAD_PCI_CONFIG */
    { 0x00ce8e,  29, 0x0051c0,  48,    -2886 }, /* VERR_PDM_ONE_PCI_FUNCTION_PER_DEVICE */
    { 0x01a6de,  11, 0x014609,  20,    -2885 }, /* VERR_PDM_THREAD_IPE_2 */
    { 0x01a6e9,  11, 0x01416d,  20,    -2884 }, /* VERR_PDM_THREAD_IPE_1 */
    { 0x01796a,  16, 0x00841c,  39,    -2883 }, /* VERR_PDM_THREAD_INVALID_CALLER */
    { 0x019a69,  13, 0x00d92b,  28,    -2882 }, /* VERR_PDM_CRITSECT_NOT_FOUND */
    { 0x01872f,  14, 0x01700b,  16,    -2881 }, /* VERR_PDM_CRITSECT_IPE */
    { 0x012794,  22, 0x00314b,  58,    -2880 }, /* VERR_PDM_HPET_LEGACY_NOTIFY_MISSING */
    { 0x01150b,  23, 0x00b16a,  32,    -2879 }, /* VERR_PDM_DEV_HEAP_R3_TO_GCPHYS */
    { 0x01a2c1,  12, 0x0194fa,  13,    -2878 }, /* VERR_PDM_DRIVER_VERSION_MISMATCH */
    { 0x01a1a1,  12, 0x016a5c,  17,    -2877 }, /* VERR_PDM_USBDEV_VERSION_MISMATCH */
    { 0x019bdd,  12, 0x019736,  13,    -2876 }, /* VERR_PDM_DEVICE_VERSION_MISMATCH */
    { 0x018989,  14, 0x013aa1,  20,    -2875 }, /* VERR_PDM_DRVHLPR3_VERSION_MISMATCH */
    { 0x01a105,  12, 0x0126b8,  22,    -2874 }, /* VERR_PDM_DRVINS_VERSION_MISMATCH */
    { 0x018d33,  14, 0x010740,  24,    -2873 }, /* VERR_PDM_USBHLPR3_VERSION_MISMATCH */
    { 0x01a375,  12, 0x00f313,  26,    -2872 }, /* VERR_PDM_USBINS_VERSION_MISMATCH */
    { 0x01a0f9,  12, 0x013b69,  20,    -2871 }, /* VERR_PDM_DEVHLP_VERSION_MISMATCH */
    { 0x019d51,  12, 0x01240f,  22,    -2870 }, /* VERR_PDM_DEVINS_VERSION_MISMATCH */
    { 0x010950,  24, 0x00cb7f,  29,    -2869 }, /* VERR_PDM_TOO_MANY_USB_DEVICE_INSTANCES */
    { 0x01457d,  20, 0x00fdbd,  25,    -2868 }, /* VERR_PDM_TOO_MANY_DRIVER_INSTANCES */
    { 0x013c6d,  20, 0x0100f6,  25,    -2867 }, /* VERR_PDM_TOO_MANY_DEVICE_INSTANCES */
    { 0x0140a5,  20, 0x002c80,  59,    -2866 }, /* VERR_PDM_DRIVER_INVALID_PROPERTIES */
    { 0x00d1f4,  29, 0x00a0eb,  35,    -2865 }, /* VERR_PDM_ASYNC_COMPLETION_NOT_SUSPENDED */
    { 0x00cdc3,  29, 0x009e0c,  35,    -2864 }, /* VERR_PDM_ASYNC_COMPLETION_ALREADY_SUSPENDED */
    { 0x012ad9,  21, 0x008554,  39,    -2863 }, /* VERR_PDM_ASYNC_TEMPLATE_BUSY */
    { 0x01a5aa,  11, 0x00b60a,  32,    -2862 }, /* VERR_PDM_NO_USBPROXY */
    { 0x019c9d,  12, 0x005d26,  46,    -2861 }, /* VERR_PDM_NO_USB_PORTS */
    { 0x01a8d8,  11, 0x007ee4,  40,    -2860 }, /* VERR_PDM_NO_USB_HUBS */
    { 0x01752a,  16, 0x012542,  22,    -2859 }, /* VERR_PDM_USB_HUB_EXISTS */
    { 0x01726a,  16, 0x015c2d,  18,    -2858 }, /* VERR_PDM_USB_NAME_CLASH */
    { 0x0152aa,  19, 0x00d637,  28,    -2857 }, /* VERR_PDM_INVALID_USB_REGISTRATION */
    { 0x01a7f1,  11, 0x00470e,  51,    -2856 }, /* VERR_PDM_UNKNOWN_USBREG_VERSION */
    { 0x01b89c,   8, 0x010de8,  24,    -2855 }, /* VERR_PDM_HIF_INVALID_VERSION */
    { 0x015439,  19, 0x011aca,  23,    -2854 }, /* VERR_PDM_DRIVER_NO_RT_ATTACH */
    { 0x014cba,  19, 0x0119b6,  23,    -2853 }, /* VERR_PDM_DEVICE_NO_RT_ATTACH */
    { 0x019cfd,  12, 0x01178e,  23,    -2852 }, /* VERR_PDM_HIF_OPEN_FAILED */
    { 0x01122b,  23, 0x004e4e,  49,    -2851 }, /* VERR_PDM_HIF_SHARING_VIOLATION */
    { 0x017cf8,  15, 0x00168f,  69,    -2850 }, /* VERR_PDM_NO_RTC_INSTANCE */
    { 0x01787a,  16, 0x001f58,  64,    -2849 }, /* VERR_PDM_NO_DMAC_INSTANCE */
    { 0x01755a,  16, 0x001c52,  65,    -2848 }, /* VERR_PDM_NO_APIC_INSTANCE */
    { 0x018649,  15, 0x002058,  63,    -2847 }, /* VERR_PDM_NO_PIC_INSTANCE */
    { 0x00fa07,  25, 0x004cf2,  50,    -2846 }, /* VERR_PDM_NO_DRIVER_ATTACHED_TO_LUN */
    { 0x01b7ac,   8, 0x016f7b,  16,    -2845 }, /* VERR_PDM_LUN_NOT_FOUND */
    { 0x014311,  20, 0x014109,  20,    -2844 }, /* VERR_PDM_DRIVER_INSTANCE_NOT_FOUND */
    { 0x0107b8,  24, 0x009202,  37,    -2843 }, /* VERR_PDM_DEVICE_INSTANCE_LUN_NOT_FOUND */
    { 0x010bd8,  24, 0x00a41c,  34,    -2842 }, /* VERR_PDM_DEVICE_INSTANCE_NO_IBASE */
    { 0x013be1,  20, 0x018ae7,  14,    -2841 }, /* VERR_PDM_DEVICE_INSTANCE_NOT_FOUND */
    { 0x01a930,  11, 0x01adde,  10,    -2840 }, /* VERR_PDM_DEVICE_NOT_FOUND */
    { 0x01504a,  19, 0x015c87,  18,    -2839 }, /* VERR_PDM_DEVICE_NAME_CLASH */
    { 0x01511b,  19, 0x008380,  39,    -2838 }, /* VERR_PDM_INVALID_DEVICE_HOST_BITS */
    { 0x014005,  20, 0x017ccb,  15,    -2837 }, /* VERR_PDM_INVALID_DEVICE_GUEST_BITS */
    { 0x011fad,  22, 0x00d637,  28,    -2836 }, /* VERR_PDM_INVALID_DEVICE_REGISTRATION */
    { 0x01a6bd,  11, 0x0059e5,  47,    -2835 }, /* VERR_PDM_UNKNOWN_DEVREG_VERSION */
    { 0x01957c,  13, 0x0037b6,  56,    -2834 }, /* VERR_PDM_NOT_PCI_DEVICE */
    { 0x01ac3a,  10, 0x00d285,  29,    -2833 }, /* VERR_PDM_NO_PCI_BUS */
    { 0x010493,  25, 0x0045a9,  51,    -2832 }, /* VERR_PDM_DRIVER_DETACH_NOT_POSSIBLE */
    { 0x0147c1,  19, 0x017ccb,  15,    -2831 }, /* VERR_PDM_INVALID_DRIVER_HOST_BITS */
    { 0x01238b,  22, 0x00d84b,  28,    -2830 }, /* VERR_PDM_INVALID_DRIVER_REGISTRATION */
    { 0x01a7d0,  11, 0x0058cb,  47,    -2829 }, /* VERR_PDM_UNKNOWN_DRVREG_VERSION */
    { 0x0148f1,  19, 0x015c2d,  18,    -2828 }, /* VERR_PDM_DRIVER_NAME_CLASH */
    { 0x014af2,  19, 0x0133b5,  21,    -2827 }, /* VERR_PDM_MODULE_NAME_TOO_LONG */
    { 0x01210d,  22, 0x0035f6,  56,    -2826 }, /* VERR_PDM_NO_REGISTRATION_EXPORT */
    { 0x014d8b,  19, 0x0078e8,  41,    -2825 }, /* VERR_PDM_MODULE_NAME_CLASH */
    { 0x01a6ff,  11, 0x013058,  21,    -2823 }, /* VERR_PDM_DRIVER_NOT_FOUND */
    { 0x0152f6,  19, 0x003d74,  54,    -2822 }, /* VERR_PDM_CFG_MISSING_DRIVER_NAME */
    { 0x00fa07,  18, 0x00030f, 110,    -2821 }, /* VERR_PDM_NO_DRIVER_ATTACHED */
    { 0x0154a7,  18, 0x004bf8,  50,    -2820 }, /* VERR_PDM_DRIVER_ALREADY_ATTACHED */
    { 0x01aee2,  10, 0x016a07,  17,    -2819 }, /* VERR_PDM_UNSUPPORTED_BLOCK_TYPE */
    { 0x013a51,  20, 0x001e98,  64,    -2818 }, /* VERR_PDM_BLOCK_UNKNOWN_TRANSLATION */
    { 0x01aca8,  10, 0x00334e,  57,    -2817 }, /* VERR_PDM_BLOCK_UNKNOWN_TYPE */
    { 0x01ac26,  10, 0x006d58,  43,    -2816 }, /* VERR_PDM_BLOCK_NO_TYPE */
    { 0x018f01,  14, 0x00d9b7,  28,    -2815 }, /* VERR_PDM_MEDIA_LOCKED */
    { 0x0183c4,  15, 0x00f653,  26,    -2814 }, /* VERR_PDM_MEDIA_MOUNTED */
    { 0x01732a,  16, 0x0064b2,  44,    -2813 }, /* VERR_PDM_MEDIA_NOT_MOUNTED */
    { 0x01557f,  18, 0x003ff4,  53,    -2812 }, /* VERR_PDM_TRANSLATION_NOT_SET */
    { 0x017ee7,  15, 0x004b30,  50,    -2811 }, /* VERR_PDM_GEOMETRY_NOT_SET */
    { 0x01594b,  18, 0x01675f,  17,    -2810 }, /* VERR_PDM_NO_ATTACHED_DRIVER */
    { 0x01738a,  16, 0x008cee,  38,    -2809 }, /* VERR_PDM_DEVINS_NO_ATTACH */
    { 0x01760a,  16, 0x005d82,  46,    -2808 }, /* VERR_PDM_DRVINS_NO_ATTACH */
    { 0x018b2d,  14, 0x008d86,  38,    -2807 }, /* VERR_PDM_NO_QUEUE_ITEMS */
    { 0x018388,  15, 0x006ad3,  43,    -2806 }, /* VERR_PDM_TOO_PCI_MANY_DEVICES */
    { 0x0142fd,  20, 0x00db07,  28,    -2805 }, /* VERR_PDM_DRVINS_UNKNOWN_CFG_VALUES */
    { 0x0149d5,  13, 0x003c30,  54,    -2804 }, /* VERR_PDM_MISSING_INTERFACE */
    { 0x014c94,  19, 0x001e58,  64,    -2803 }, /* VERR_PDM_MISSING_INTERFACE_BELOW */
    { 0x0149d5,  19, 0x002907,  60,    -2802 }, /* VERR_PDM_MISSING_INTERFACE_ABOVE */
    { 0x013849,  20, 0x00dacf,  28,    -2801 }, /* VERR_PDM_DEVINS_UNKNOWN_CFG_VALUES */
    { 0x01a639,  11, 0x00d3fe,  29,    -2800 }, /* VERR_PDM_NO_SUCH_LUN */
    { 0x0117bc,  23, 0x00658e,  44,    -2721 }, /* VERR_VMM_FN_NOT_SUPPORTED_FOR_VMTARGET */
    { 0x01693b,  17, 0x013337,  21,    -2720 }, /* VERR_VMM_CANNOT_BLOCK */
    { 0x00b948,  31, 0x002018,  64,    -2719 }, /* VERR_VMM_CONTEXT_HOOK_STILL_ENABLED */
    { 0x0139c5,  20, 0x0102ea,  25,    -2718 }, /* VERR_VMM_WRONG_NEM_VMCPU_STATE */
    { 0x01282e,  22, 0x001301,  71,    -2717 }, /* VERR_VMM_SMAP_BUT_AC_CLEAR */
    { 0x0131d2,  21, 0x00f0d7,  26,    -2716 }, /* VERR_VMM_WRONG_HM_VMCPU_STATE */
    { 0x015b8b,  18, 0x00d2a2,  29,    -2715 }, /* VERR_VMM_SWITCHER_STUB */
    { 0x01767a,  16, 0x015e49,  18,    -2713 }, /* VERR_VMM_SWITCHER_IPE_1 */
    { 0x017f23,  15, 0x017d61,  15,    -2709 }, /* VERR_VMM_LONG_JMP_ERROR */
    { 0x01a951,  11, 0x01ba5e,   7,    -2705 }, /* VERR_VMM_RC_VERSION_MISMATCH */
    { 0x01a57e,  11, 0x01b99a,   7,    -2704 }, /* VERR_VMM_R0_VERSION_MISMATCH */
    { 0x010a10,  24, 0x00dc73,  28,    -2703 }, /* VERR_VMM_RING3_CALL_DISABLED */
    { 0x01759a,  16, 0x0090da,  37,    -2702 }, /* VERR_VMM_HYPER_CR3_MISMATCH */
    { 0x0142d5,  20, 0x00932a,  37,    -2701 }, /* VERR_VMM_RING0_ASSERTION */
    { 0x013154,  21, 0x01584f,  18,    -2663 }, /* VERR_IOM_MMIO_REGION_NOT_MAPPED */
    { 0x013100,  21, 0x01571d,  18,    -2662 }, /* VERR_IOM_MMIO_REGION_ALREADY_MAPPED */
    { 0x018bb9,  14, 0x01ac58,  10,    -2661 }, /* VERR_IOM_INVALID_MMIO_HANDLE */
    { 0x0126e4,  22, 0x012e0c,  21,    -2660 }, /* VERR_IOM_TOO_MANY_MMIO_REGISTRATIONS */
    { 0x013c59,  20, 0x012283,  22,    -2653 }, /* VERR_IOM_IOPORTS_NOT_MAPPED */
    { 0x013cbd,  20, 0x011e4e,  22,    -2652 }, /* VERR_IOM_IOPORTS_ALREADY_MAPPED */
    { 0x01537b,  19, 0x0161bb,  17,    -2651 }, /* VERR_IOM_INVALID_IOPORT_HANDLE */
    { 0x00e0ee,  27, 0x00d61b,  28,    -2650 }, /* VERR_IOM_TOO_MANY_IOPORT_REGISTRATIONS */
    { 0x015def,  18, 0x00c47a,  30,    -2638 }, /* VERR_IOM_FF_STATUS_IPE */
    { 0x01a99e,  11, 0x002b59,  59,    -2637 }, /* VERR_IOM_HM_IPE */
    { 0x01b24e,   9, 0x01a757,  11,    -2636 }, /* VERR_IOM_MMIO_IPE_3 */
    { 0x01b257,   9, 0x01a5d6,  11,    -2635 }, /* VERR_IOM_MMIO_IPE_2 */
    { 0x01b260,   9, 0x01a4c3,  11,    -2634 }, /* VERR_IOM_MMIO_IPE_1 */
    { 0x018ebb,  14, 0x016077,  18,    -2633 }, /* VERR_IOM_IOPORT_IPE_3 */
    { 0x018f0f,  14, 0x015a7d,  18,    -2632 }, /* VERR_IOM_IOPORT_IPE_2 */
    { 0x018ec9,  14, 0x015d17,  18,    -2631 }, /* VERR_IOM_IOPORT_IPE_1 */
    { 0x014a47,  19, 0x005ffc,  45,    -2630 }, /* VERR_IOM_IOPORT_UNKNOWN_OPCODE */
    { 0x01579b,  18, 0x001078,  73,    -2614 }, /* VERR_IOM_IOPORT_UNUSED */
    { 0x011af8,  23, 0x005310,  48,    -2613 }, /* VERR_IOM_MMIO_HANDLER_DISASM_ERROR */
    { 0x010416,  25, 0x009524,  36,    -2612 }, /* VERR_IOM_MMIO_HANDLER_BOGUS_CALL */
    { 0x019192,  14, 0x0097f4,  36,    -2611 }, /* VERR_IOM_INVALID_IOPORT_SIZE */
    { 0x011c95,  23, 0x00d6a7,  28,    -2610 }, /* VERR_IOM_INCOMPLETE_MMIO_RANGE */
    { 0x0180b8,  15, 0x012031,  22,    -2609 }, /* VERR_IOM_MMIO_RANGE_NOT_FOUND */
    { 0x013043,  21, 0x0086fe,  38,    -2608 }, /* VERR_IOM_MMIO_RANGE_CONFLICT */
    { 0x01538e,  19, 0x008617,  39,    -2607 }, /* VERR_IOM_NOT_MMIO_RANGE_OWNER */
    { 0x01712a,  16, 0x003c66,  54,    -2606 }, /* VERR_IOM_NO_R3_MMIO_RANGE */
    { 0x019847,  13, 0x01512e,  19,    -2605 }, /* VERR_IOM_INVALID_MMIO_RANGE */
    { 0x010ad0,  24, 0x005afe,  46,    -2604 }, /* VERR_IOM_NOT_IOPORT_RANGE_OWNER */
    { 0x01420d,  20, 0x002726,  61,    -2603 }, /* VERR_IOM_IOPORT_RANGE_NOT_FOUND */
    { 0x00f535,  26, 0x006191,  45,    -2602 }, /* VERR_IOM_IOPORT_RANGE_CONFLICT */
    { 0x0129f2,  21, 0x00266f,  61,    -2601 }, /* VERR_IOM_NO_R3_IOPORT_RANGE */
    { 0x015471,  18, 0x00f277,  26,    -2600 }, /* VERR_IOM_INVALID_IOPORT_RANGE */
    { 0x019b4d,  12, 0x002763,  60,    -2509 }, /* VERR_SELM_HM_IPE */
    { 0x018310,  15, 0x003ab6,  54,    -2508 }, /* VERR_SELM_GDT_TOO_FULL */
    { 0x016e7c,  16, 0x005dde,  46,    -2507 }, /* VERR_SELM_GDT_READ_ERROR */
    { 0x01161e,  23, 0x00d53b,  28,    -2506 }, /* VERR_SELM_LDT_OUT_OF_BOUNDS */
    { 0x01aaf0,  10, 0x0180f4,  15,    -2505 }, /* VERR_SELM_INVALID_LDT */
    { 0x01ad3e,  10, 0x0149af,  19,    -2504 }, /* VERR_SELM_NO_TSS */
    { 0x0121d3,  22, 0x00684e,  43,    -2502 }, /* VERR_SELM_SHADOW_TSS_WRITE */
    { 0x01222b,  22, 0x006d83,  43,    -2501 }, /* VERR_SELM_SHADOW_LDT_WRITE */
    { 0x012451,  22, 0x006950,  43,    -2500 }, /* VERR_SELM_SHADOW_GDT_WRITE */
    { 0x01a129,  12, 0x0028cb,  60,    -2409 }, /* VERR_TRPM_HM_IPE */
    { 0x01b5b4,   8, 0x019ed1,  12,    -2408 }, /* VERR_TRPM_IPE_3 */
    { 0x01b5bc,   8, 0x01a075,  12,    -2407 }, /* VERR_TRPM_IPE_2 */
    { 0x01b634,   8, 0x019c79,  12,    -2406 }, /* VERR_TRPM_IPE_1 */
    { 0x0163b8,  17, 0x016d7b,  17,    -2405 }, /* VERR_TRPM_BAD_TRAP_IN_OP */
    { 0x01a76d,  11, 0x013d5d,  20,    -2404 }, /* VERR_TRPM_PANIC */
    { 0x016fbb,  16, 0x00c6b4,  30,    -2403 }, /* VERR_TRPM_DONT_PANIC */
    { 0x0120e1,  22, 0x0069fc,  43,    -2402 }, /* VERR_TRPM_SHADOW_IDT_WRITE */
    { 0x016cd1,  17, 0x019cb5,  12,    -2401 }, /* VERR_TRPM_ACTIVE_TRAP */
    { 0x0161a9,  18, 0x0198a2,  13,    -2400 }, /* VERR_TRPM_NO_ACTIVE_TRAP */
    { 0x01bbfb,   6, 0x01b176,   9,    -2299 }, /* VERR_TM_IPE_9 */
    { 0x01bc01,   6, 0x01b1eb,   9,    -2298 }, /* VERR_TM_IPE_8 */
    { 0x01bc07,   6, 0x01b2b1,   9,    -2297 }, /* VERR_TM_IPE_7 */
    { 0x01bc0d,   6, 0x01b125,   9,    -2296 }, /* VERR_TM_IPE_6 */
    { 0x01bc13,   6, 0x01b434,   9,    -2295 }, /* VERR_TM_IPE_5 */
    { 0x01bc2b,   6, 0x01b1d9,   9,    -2294 }, /* VERR_TM_IPE_4 */
    { 0x01bc31,   6, 0x01b245,   9,    -2293 }, /* VERR_TM_IPE_3 */
    { 0x01bc3d,   6, 0x01b11c,   9,    -2292 }, /* VERR_TM_IPE_2 */
    { 0x01bc5b,   6, 0x01b191,   9,    -2291 }, /* VERR_TM_IPE_1 */
    { 0x00e6bb,  27, 0x0094dc,  36,    -2214 }, /* VERR_TM_TIMER_QUEUE_CANNOT_GROW */
    { 0x0170fa,  16, 0x0144a1,  20,    -2213 }, /* VERR_TM_INVALID_TIMER_QUEUE */
    { 0x01a2cd,  12, 0x010650,  24,    -2212 }, /* VERR_TM_TOO_MANY_TIMERS */
    { 0x0112b5,  23, 0x014f1a,  19,    -2211 }, /* VERR_TM_VIRTUAL_TICKING_IPE */
    { 0x017b9f,  15, 0x00dd53,  28,    -2210 }, /* VERR_TM_TSC_ALREADY_PAUSED */
    { 0x016edb,  16, 0x00cace,  30,    -2209 }, /* VERR_TM_TSC_ALREADY_TICKING */
    { 0x01443d,  20, 0x00c510,  30,    -2208 }, /* VERR_TM_TIMER_UNSTABLE_STATE */
    { 0x016dac,  16, 0x00443f,  52,    -2207 }, /* VERR_TM_TIMER_BAD_CLOCK */
    { 0x00de4f,  28, 0x00d2f9,  29,    -2206 }, /* VERR_TM_GIP_UPDATE_INTERVAL_TOO_BIG */
    { 0x01b2cc,   9, 0x014c81,  19,    -2205 }, /* VERR_TM_GIP_VERSION */
    { 0x01779a,  16, 0x0170ca,  16,    -2204 }, /* VERR_TM_GIP_REQUIRED */
    { 0x0190a5,  14, 0x00297f,  60,    -2203 }, /* VERR_TM_UNSTABLE_STATE */
    { 0x01bc61,   6, 0x0101a5,  25,    -2202 }, /* VERR_TM_UNKNOWN_STATE */
    { 0x01bd39,   6, 0x01100f,  24,    -2201 }, /* VERR_TM_INVALID_STATE */
    { 0x01ab90,  10, 0x00f85b,  26,    -2200 }, /* VERR_TM_LOAD_STATE */
    { 0x01b90c,   8, 0x019d8d,  12,    -2165 }, /* VERR_CFGM_IPE_1 */
    { 0x015b43,  18, 0x00731d,  42,    -2164 }, /* VERR_CFGM_CONFIG_UNKNOWN_NODE */
    { 0x015426,  19, 0x00b3aa,  32,    -2163 }, /* VERR_CFGM_CONFIG_UNKNOWN_VALUE */
    { 0x016b7d,  17, 0x003de0,  54,    -2162 }, /* VERR_CFGM_LEAF_EXISTS */
    { 0x016484,  17, 0x003a4a,  54,    -2161 }, /* VERR_CFGM_NODE_EXISTS */
    { 0x01713a,  16, 0x00804c,  40,    -2160 }, /* VERR_CFGM_INVALID_NODE_PATH */
    { 0x017ff5,  15, 0x008c56,  38,    -2110 }, /* VERR_CFGM_NOT_PASSWORD */
    { 0x014976,  19, 0x00ef37,  26,    -2109 }, /* VERR_CFGM_NOT_ENOUGH_SPACE */
    { 0x01a14d,  12, 0x01545f,  18,    -2108 }, /* VERR_CFGM_NOT_BYTES */
    { 0x01b784,   8, 0x00826f,  39,    -2107 }, /* VERR_CFGM_NOT_STRING */
    { 0x018cd1,  14, 0x019451,  13,    -2106 }, /* VERR_CFGM_NOT_INTEGER */
    { 0x01a455,  11, 0x01684d,  17,    -2105 }, /* VERR_CFGM_NO_NODE */
    { 0x019222,  13, 0x0114af,  23,    -2104 }, /* VERR_CFGM_NO_PARENT */
    { 0x018e21,  14, 0x01b5f4,   8,    -2103 }, /* VERR_CFGM_VALUE_NOT_FOUND */
    { 0x01663e,  17, 0x01231d,  22,    -2102 }, /* VERR_CFGM_INVALID_CHILD_PATH */
    { 0x018f47,  14, 0x018cdf,  14,    -2101 }, /* VERR_CFGM_CHILD_NOT_FOUND */
    { 0x015f8d,  18, 0x00a240,  34,    -2100 }, /* VERR_CFGM_INTEGER_TOO_BIG */
    { 0x0152e3,  19, 0x0159a5,  18,    -2007 }, /* VERR_VRDP_ACCESS_DENIED */
    { 0x01b8c4,   8, 0x014950,  19,    -2006 }, /* VERR_VRDP_NO_MEMORY */
    { 0x01a53c,  11, 0x00a6e6,  34,    -2005 }, /* VERR_VRDP_INVALID_MODE */
    { 0x011287,  23, 0x002f7b,  58,    -2004 }, /* VERR_VRDP_INSUFFICIENT_DATA */
    { 0x01b4ec,   8, 0x011b81,  23,    -2003 }, /* VERR_VRDP_NOT_SUPPORTED */
    { 0x01770a,  16, 0x010830,  24,    -2002 }, /* VERR_VRDP_PROTOCOL_ERROR */
    { 0x012fef,  21, 0x00a945,  33,    -2001 }, /* VERR_VRDP_SEC_ENGINE_FAIL */
    { 0x014ebb,  19, 0x013dc1,  20,    -2000 }, /* VERR_VRDP_ISO_UNSUPPORTED */
    { 0x0165d8,  17, 0x00cf02,  29,    -1919 }, /* VERR_VM_REQUEST_KILLED */
    { 0x0181d5,  15, 0x01718a,  16,    -1918 }, /* VERR_VM_FATAL_WAIT_ERROR */
    { 0x012a1c,  21, 0x007221,  42,    -1917 }, /* VERR_VM_REQUEST_TOO_MANY_ARGS_IPE */
    { 0x0190eb,  14, 0x015903,  18,    -1916 }, /* VERR_VM_UNEXPECTED_UNSTABLE_STATE */
    { 0x01baf8,   7, 0x013472,  21,    -1915 }, /* VERR_VM_UNEXPECTED_VM_STATE */
    { 0x01750a,  16, 0x005be4,  46,    -1914 }, /* VERR_VM_THREAD_IS_EMT */
    { 0x0160ad,  18, 0x00aad1,  33,    -1913 }, /* VERR_VM_SAVE_STATE_NOT_ALLOWED */
    { 0x0198f0,  13, 0x00cde0,  29,    -1912 }, /* VERR_VM_DRIVER_VERSION_MISMATCH */
    { 0x016d8c,  16, 0x00fe21,  25,    -1911 }, /* VERR_VM_DRIVER_OPEN_ERROR */
    { 0x01745a,  16, 0x00ff1b,  25,    -1910 }, /* VERR_VM_DRIVER_LOAD_ERROR */
    { 0x012b42,  21, 0x01703b,  16,    -1909 }, /* VERR_VM_DRIVER_NOT_ACCESSIBLE */
    { 0x0141e5,  20, 0x018112,  15,    -1908 }, /* VERR_VM_DRIVER_NOT_INSTALLED */
    { 0x01ba26,   7, 0x01ad02,  10,    -1907 }, /* VERR_VM_INVALID_VM_STATE */
    { 0x01895f,  14, 0x0048a6,  50,    -1906 }, /* VERR_VM_THREAD_NOT_EMT */
    { 0x011270,  23, 0x00a7f6,  34,    -1905 }, /* VERR_VM_REQUEST_STATUS_FREED */
    { 0x00c165,  31, 0x00279f,  60,    -1904 }, /* VERR_VM_REQUEST_STATUS_STILL_PENDING */
    { 0x0151ec,  19, 0x01a5cb,  11,    -1903 }, /* VERR_VM_REQUEST_INVALID_PACKAGE */
    { 0x019d5d,  12, 0x01ab4a,  10,    -1902 }, /* VERR_VM_REQUEST_STATE */
    { 0x019972,  13, 0x01b3f5,   9,    -1901 }, /* VERR_VM_REQUEST_INVALID_TYPE */
    { 0x019215,  13, 0x00eb7a,  27,    -1900 }, /* VERR_VM_ATRESET_NOT_FOUND */
    { 0x00fcaa,  25, 0x01650c,  17,    -1880 }, /* VERR_SSM_ENUM_VALUE_OUT_OF_RANGE */
    { 0x00ae2a,  32, 0x000d8d,  77,    -1879 }, /* VERR_SSM_FIELD_LOAD_ONLY_TRANSFORMATION */
    { 0x01bf3e,   4, 0x01a219,  12,    -1878 }, /* VERR_SSM_IPE_3 */
    { 0x01bf46,   4, 0x01a345,  12,    -1877 }, /* VERR_SSM_IPE_2 */
    { 0x01bf52,   4, 0x019c85,  12,    -1876 }, /* VERR_SSM_IPE_1 */
    { 0x01b544,   8, 0x00cda6,  29,    -1875 }, /* VERR_SSM_BAD_REC_TYPE */
    { 0x01af82,  10, 0x005668,  47,    -1874 }, /* VERR_SSM_MEM_TOO_BIG */
    { 0x017a4a,  16, 0x006dd9,  43,    -1873 }, /* VERR_SSM_SKIP_BACKWARDS */
    { 0x01b9fc,   7, 0x00671a,  44,    -1872 }, /* VERR_SSM_UNEXPECTED_PASS */
    { 0x01ab68,  10, 0x01b137,   9,    -1871 }, /* VERR_SSM_STREAM_ERROR */
    { 0x018705,  14, 0x010d40,  24,    -1870 }, /* VERR_SSM_FIELD_INVALID_VALUE */
    { 0x015915,  18, 0x0113b2,  23,    -1869 }, /* VERR_SSM_FIELD_INVALID_PADDING_SIZE */
    { 0x0167b4,  17, 0x0078bf,  41,    -1868 }, /* VERR_SSM_FIELD_INVALID_CALLBACK */
    { 0x014235,  20, 0x007275,  42,    -1867 }, /* VERR_SSM_FIELD_NOT_CONSECUTIVE */
    { 0x0136be,  21, 0x00db5b,  28,    -1866 }, /* VERR_SSM_FIELD_OUT_OF_BOUNDS */
    { 0x01acda,  10, 0x009193,  37,    -1865 }, /* VERR_SSM_FIELD_INVALID_SIZE */
    { 0x01861c,  15, 0x003a80,  54,    -1864 }, /* VERR_SSM_FIELD_COMPLEX */
    { 0x01907b,  14, 0x002f07,  58,    -1863 }, /* VERR_SSM_LIVE_FATAL_ERROR */
    { 0x01226d,  22, 0x002c0a,  59,    -1862 }, /* VERR_SSM_LIVE_GURU_MEDITATION */
    { 0x0154ef,  18, 0x009c8b,  35,    -1861 }, /* VERR_SSM_LIVE_POWERED_OFF */
    { 0x019ee9,  12, 0x017cda,  15,    -1860 }, /* VERR_SSM_ALREADY_CANCELLED */
    { 0x013f65,  20, 0x01106f,  24,    -1859 }, /* VERR_SSM_NO_PENDING_OPERATION */
    { 0x01a95c,  11, 0x01986e,  13,    -1858 }, /* VERR_SSM_CANCELLED */
    { 0x014892,  19, 0x002b1e,  59,    -1857 }, /* VERR_SSM_LOW_ON_DISK_SPACE */
    { 0x0194ac,  13, 0x0026e9,  61,    -1856 }, /* VERR_SSM_STATE_GREW_TOO_BIG */
    { 0x01ad52,  10, 0x002d6c,  59,    -1855 }, /* VERR_SSM_TOO_MANY_PASSES */
    { 0x014159,  20, 0x0175ea,  16,    -1853 }, /* VERR_SSM_VOTE_FOR_GIVING_UP */
    { 0x01785a,  16, 0x00257a,  62,    -1850 }, /* VERR_SSM_GCPTR_OVERFLOW */
    { 0x016b17,  17, 0x002154,  63,    -1849 }, /* VERR_SSM_GCPHYS_OVERFLOW */
    { 0x01b9ee,   7, 0x00a3b6,  34,    -1848 }, /* VERR_SSM_UNEXPECTED_DATA */
    { 0x016d48,  17, 0x013487,  21,    -1847 }, /* VERR_SSM_STRUCTURE_MAGIC */
    { 0x014762,  19, 0x002097,  63,    -1846 }, /* VERR_SSM_IDE_ASYNC_TIMEOUT */
    { 0x015ad7,  18, 0x0085a2,  39,    -1845 }, /* VERR_SSM_VIRTUAL_CLOCK_HZ */
    { 0x017f50,  15, 0x006696,  44,    -1844 }, /* VERR_SSM_LOAD_CONFIG_MISMATCH */
    { 0x019ba1,  12, 0x00610a,  45,    -1843 }, /* VERR_SSM_LOAD_MEMORY_SIZE_MISMATCH */
    { 0x018ced,  14, 0x0019be,  67,    -1842 }, /* VERR_SSM_LOAD_CPUID_MISMATCH */
    { 0x00f3c9,  26, 0x00f361,  26,    -1841 }, /* VERR_SSM_DATA_UNIT_FORMAT_CHANGED */
    { 0x018b65,  14, 0x017f7d,  15,    -1840 }, /* VERR_SSM_UNSUPPORTED_DATA_UNIT_VERSION */
    { 0x01782a,  16, 0x00dda7,  28,    -1833 }, /* VERR_SSM_LOADED_TOO_LITTLE */
    { 0x01bf76,   4, 0x00dda7,  28,    -1832 }, /* VERR_SSM_INVALID_STATE */
    { 0x018a69,  14, 0x0025b8,  61,    -1831 }, /* VERR_SSM_LOADED_TOO_MUCH */
    { 0x01a1e9,  12, 0x003938,  55,    -1830 }, /* VERR_SSM_NO_LOAD_EXEC */
    { 0x01939b,  13, 0x011fd9,  22,    -1827 }, /* VERR_SSM_INTEGRITY_DIR_MAGIC */
    { 0x01939b,   7, 0x013097,  21,    -1826 }, /* VERR_SSM_INTEGRITY_DIR */
    { 0x016a18,  17, 0x0101be,  25,    -1825 }, /* VERR_SSM_INTEGRITY_DECOMPRESSION */
    { 0x01794a,  16, 0x00af2a,  32,    -1824 }, /* VERR_SSM_INTEGRITY_REC_TERM_CRC */
    { 0x01794a,  12, 0x00c696,  30,    -1823 }, /* VERR_SSM_INTEGRITY_REC_TERM */
    { 0x01aa01,  11, 0x014ffe,  19,    -1822 }, /* VERR_SSM_INTEGRITY_REC_HDR */
    { 0x01b072,  10, 0x0155d9,  18,    -1821 }, /* VERR_SSM_INTEGRITY_FOOTER */
    { 0x01ad7a,  10, 0x00d7bf,  28,    -1820 }, /* VERR_SSM_INTEGRITY_VBOX_VERSION */
    { 0x01a72b,  11, 0x00a74c,  34,    -1819 }, /* VERR_SSM_INTEGRITY_UNIT_NOT_FOUND */
    { 0x018863,  14, 0x00da27,  28,    -1818 }, /* VERR_SSM_INTEGRITY_UNIT_MAGIC */
    { 0x018863,   8, 0x016243,  17,    -1817 }, /* VERR_SSM_INTEGRITY_UNIT */
    { 0x01ae42,  10, 0x014b18,  19,    -1816 }, /* VERR_SSM_INTEGRITY_HEADER */
    { 0x018783,  14, 0x00b789,  32,    -1815 }, /* VERR_SMM_INTEGRITY_MACHINE */
    { 0x01bb61,   7, 0x00ef6b,  26,    -1814 }, /* VERR_SSM_INTEGRITY_CRC */
    { 0x01bdcc,   5, 0x00762f,  41,    -1813 }, /* VERR_SSM_INTEGRITY_SIZE */
    { 0x01bdd6,   5, 0x0193f6,  13,    -1812 }, /* VERR_SSM_INTEGRITY_VERSION */
    { 0x01b284,   9, 0x00dce3,  28,    -1811 }, /* VERR_SSM_INTEGRITY_MAGIC */
    { 0x016a18,   3, 0x00e433,  27,    -1810 }, /* VERR_SSM_INTEGRITY */
    { 0x01930c,  13, 0x00d0b5,  29,    -1802 }, /* VERR_SSM_UNIT_NOT_OWNER */
    { 0x01b410,   9, 0x016dbc,  16,    -1801 }, /* VERR_SSM_UNIT_NOT_FOUND */
    { 0x019791,  13, 0x017ce9,  15,    -1800 }, /* VERR_SSM_UNIT_EXISTS */
    { 0x01525e,  19, 0x01affa,  10,    -1771 }, /* VERR_CPUM_UNSUPPORTED_ID_REG_VALUE */
    { 0x0160f5,  18, 0x0169a1,  17,    -1770 }, /* VERR_CPUM_UNSUPPORTED_ID_REGISTER */
    { 0x010ae8,  24, 0x0043d7,  52,    -1768 }, /* VERR_CPUM_INVALID_HWVIRT_FEAT_COMBO */
    { 0x014631,  20, 0x001d97,  65,    -1767 }, /* VERR_CPUM_INVALID_HWVIRT_CONFIG */
    { 0x01a83e,  11, 0x011691,  23,    -1765 }, /* VERR_CPUM_INVALID_XCR0 */
    { 0x016f9b,  16, 0x011818,  23,    -1764 }, /* VERR_CPUM_INVALID_XSAVE_HDR */
    { 0x0121a7,  22, 0x009021,  37,    -1763 }, /* VERR_CPUM_INVALID_XSAVE_COMP_MASK */
    { 0x00a54e,  34, 0x001605,  69,    -1762 }, /* VERR_CPUM_INCOMPATIBLE_XSAVE_COMP_MASK */
    { 0x0146ca,  19, 0x01b2c3,   9,    -1761 }, /* VERR_CPUM_INVALID_CONFIG_VALUE */
    { 0x018202,  15, 0x015b79,  18,    -1760 }, /* VERR_TOO_MANY_CPUID_LEAVES */
    { 0x00feb7,  25, 0x00eb0e,  27,    -1757 }, /* VERR_CPUM_MSR_BAD_CPUMCPU_OFFSET */
    { 0x0182a7,  15, 0x00cb9c,  29,    -1756 }, /* VERR_CPUM_DB_CPU_NOT_FOUND */
    { 0x01b814,   8, 0x01a4ef,  11,    -1755 }, /* VERR_CPUM_IPE_2 */
    { 0x01b8cc,   8, 0x01a828,  11,    -1754 }, /* VERR_CPUM_IPE_1 */
    { 0x0115d9,  23, 0x008ed4,  37,    -1753 }, /* VERR_CPUM_TOO_MANY_CPUID_SUBLEAVES */
    { 0x0127c0,  22, 0x000f07,  74,    -1752 }, /* VERR_CPUM_HIDDEN_CS_LOAD_ERROR */
    { 0x01042f,  25, 0x00b3ea,  32,    -1751 }, /* VERR_CPUM_INCOMPATIBLE_CONFIG */
    { 0x0176ba,  16, 0x008938,  38,    -1750 }, /* VERR_CPUM_RAISE_GP_0 */
    { 0x01815d,  15, 0x006cac,  43,    -1702 }, /* VERR_MM_BAD_TRAP_TYPE_IPE */
    { 0x019b41,  12, 0x010ff7,  24,    -1701 }, /* VERR_MM_HYPER_NO_MEMORY */
    { 0x01766a,  16, 0x001ed8,  64,    -1700 }, /* VERR_MM_RAM_CONFLICT */
    { 0x018801,  14, 0x01761a,  16,    -1692 }, /* VERR_PGM_TOO_MANY_ROM_RANGES */
    { 0x013376,  21, 0x009938,  36,    -1691 }, /* VERR_PGM_PHYS_RAM_LOOKUP_IPE */
    { 0x018c8b,  14, 0x01733a,  16,    -1690 }, /* VERR_PGM_TOO_MANY_RAM_RANGES */
    { 0x0184b4,  15, 0x005697,  47,    -1689 }, /* VERR_PGM_NOT_SUPPORTED_FOR_NEM_MODE */
    { 0x017d43,  15, 0x003a14,  54,    -1688 }, /* VERR_PGM_PAE_PDPE_RSVD */
    { 0x0188b7,  14, 0x0132e3,  21,    -1687 }, /* VERR_PGM_SHW_NONE_IPE */
    { 0x01abea,  10, 0x01b78c,   8,    -1686 }, /* VERR_PGM_MODE_IPE */
    { 0x0182e3,  15, 0x004307,  52,    -1685 }, /* VERR_PGM_PHYS_MMIO_EX_IPE */
    { 0x012b6c,  21, 0x003eeb,  53,    -1684 }, /* VERR_PGM_PHYS_PAGE_MAP_MMIO2_IPE */
    { 0x01722a,  16, 0x015981,  18,    -1683 }, /* VERR_PGM_TOO_MANY_MMIO2_RANGES */
    { 0x011087,  24, 0x008e1b,  37,    -1682 }, /* VERR_PGM_PCI_PASSTHRU_MISCONFIG */
    { 0x01613d,  18, 0x008e65,  37,    -1681 }, /* VERR_PGM_PHYS_NULL_PAGE_PARAM */
    { 0x017f9b,  15, 0x0112e3,  23,    -1680 }, /* VERR_PGM_PHYS_PAGE_GET_IPE */
    { 0x011c67,  23, 0x0102d1,  25,    -1679 }, /* VERR_PGM_WRITE_MONITOR_ENGAGED */
    { 0x01af64,  10, 0x01a3b1,  12,    -1678 }, /* VERR_PGM_POOL_IPE */
    { 0x010a70,  24, 0x007911,  41,    -1677 }, /* VERR_PGM_POOL_MAXED_OUT_ALREADY */
    { 0x0192ff,  13, 0x012467,  22,    -1676 }, /* VERR_PGM_MAPPING_IPE */
    { 0x018fef,  14, 0x00c948,  30,    -1675 }, /* VERR_PGM_POOL_TOO_MANY_LOOPS */
    { 0x018c0d,  14, 0x00c5c4,  30,    -1674 }, /* VERR_PGM_PHYS_PAGE_MAP_IPE_4 */
    { 0x018bff,  14, 0x00c2b8,  30,    -1673 }, /* VERR_PGM_PHYS_PAGE_MAP_IPE_3 */
    { 0x018c6f,  14, 0x00c9c0,  30,    -1672 }, /* VERR_PGM_PHYS_PAGE_MAP_IPE_2 */
    { 0x018c61,  14, 0x00c312,  30,    -1671 }, /* VERR_PGM_PHYS_PAGE_MAP_IPE_1 */
    { 0x0160bf,  18, 0x00e35b,  27,    -1670 }, /* VERR_PGM_PHYS_HANDLER_IPE */
    { 0x019db1,  12, 0x00a10e,  34,    -1669 }, /* VERR_PGM_INVALID_PDPE_ADDR */
    { 0x01a67b,  11, 0x009ae7,  35,    -1668 }, /* VERR_PGM_INVALID_CR3_ADDR */
    { 0x018103,  15, 0x002406,  62,    -1667 }, /* VERR_PGM_NOT_USED_IN_MODE */
    { 0x01990a,  13, 0x01352f,  21,    -1666 }, /* VERR_PGM_POOL_GET_PAGE_FAILED */
    { 0x018997,  14, 0x019750,  13,    -1665 }, /* VERR_PGM_PML4_MAPPING */
    { 0x019c91,  12, 0x00f569,  26,    -1664 }, /* VERR_PGM_HANDY_PAGE_IPE */
    { 0x019f0d,  12, 0x010bc0,  24,    -1663 }, /* VERR_PGM_DYNMAP_IPE */
    { 0x019208,  13, 0x01853b,  15,    -1662 }, /* VERR_PGM_SAVED_REC_TYPE */
    { 0x016594,  17, 0x00a21e,  34,    -1661 }, /* VERR_PGM_SAVED_ROM_PAGE_PROT */
    { 0x017bae,  15, 0x009764,  36,    -1660 }, /* VERR_PGM_SAVED_ROM_PAGE_NOT_FOUND */
    { 0x0143ed,  20, 0x0076fc,  41,    -1659 }, /* VERR_PGM_SAVED_ROM_RANGE_NOT_FOUND */
    { 0x01685e,  17, 0x008c30,  38,    -1658 }, /* VERR_PGM_SAVED_MMIO2_PAGE_NOT_FOUND */
    { 0x011d9e,  22, 0x006e5a,  43,    -1657 }, /* VERR_PGM_SAVED_MMIO2_RANGE_NOT_FOUND */
    { 0x01bed5,   5, 0x00cbb9,  29,    -1656 }, /* VERR_PGM_UNEXPECTED_PAGE_STATE */
    { 0x01b090,  10, 0x00cd6c,  29,    -1655 }, /* VERR_PGM_LOAD_UNEXPECTED_PAGE_TYPE */
    { 0x01a547,  11, 0x019131,  14,    -1654 }, /* VERR_PGM_INVALID_SAVED_PAGE_STATE */
    { 0x018c7d,  14, 0x00cc4a,  29,    -1653 }, /* VERR_PGM_MAPPINGS_SMP */
    { 0x014e36,  19, 0x00d5c7,  28,    -1652 }, /* VERR_PGM_MAPPINGS_DISABLED */
    { 0x014b77,  19, 0x0047da,  51,    -1651 }, /* VERR_PGM_MAP_MMIO2_ALIAS_MMIO */
    { 0x01a3c9,  12, 0x0107d0,  24,    -1647 }, /* VERR_PGM_HANDLER_IPE_1 */
    { 0x016b8e,  17, 0x009dc6,  35,    -1646 }, /* VERR_PGM_PHYS_PAGE_BALLOONED */
    { 0x01824d,  15, 0x00e2b9,  27,    -1645 }, /* VERR_PGM_INVALID_LARGE_PAGE_RANGE */
    { 0x015e6d,  18, 0x00a174,  34,    -1643 }, /* VERR_PGM_HANDLER_ALREADY_ALIASED */
    { 0x0199a6,  13, 0x0182f2,  15,    -1642 }, /* VERR_PGM_PHYS_NOT_MMIO2 */
    { 0x01b39b,   9, 0x01a62e,  11,    -1641 }, /* VERR_PGM_PHYS_NOT_MMIO */
    { 0x01a429,  11, 0x0197ab,  13,    -1640 }, /* VERR_PGM_PHYS_NOT_ROM */
    { 0x01a783,  11, 0x00eca3,  27,    -1639 }, /* VERR_PGM_PHYS_NOT_RAM */
    { 0x01295f,  21, 0x003063,  58,    -1638 }, /* VERR_PGM_PHYS_WR_HIT_HANDLER */
    { 0x01a5b5,  11, 0x00e44e,  27,    -1637 }, /* VERR_PGM_PHYS_INVALID_PAGE_ID */
    { 0x015483,  18, 0x010fdf,  24,    -1636 }, /* VERR_PGM_NO_CR3_SHADOW_ROOT */
    { 0x0121bd,  22, 0x008be4,  38,    -1635 }, /* VERR_PGM_PHYS_TLB_CATCH_WRITE */
    { 0x0144dd,  20, 0x0097ac,  36,    -1634 }, /* VERR_PGM_PHYS_TLB_CATCH_ALL */
    { 0x012974,  21, 0x006164,  45,    -1633 }, /* VERR_PGM_PHYS_TLB_UNASSIGNED */
    { 0x016a6d,  17, 0x009500,  36,    -1632 }, /* VERR_PGM_DYNMAP_EXPAND_ERROR */
    { 0x01741a,  16, 0x0077f2,  41,    -1631 }, /* VERR_PGM_DYNMAP_SETUP_ERROR */
    { 0x016c05,  17, 0x005c12,  46,    -1630 }, /* VERR_PGM_DYNMAP_FULL_SET */
    { 0x01ae24,  10, 0x009f24,  35,    -1629 }, /* VERR_PGM_DYNMAP_FAILED */
    { 0x0135ec,  21, 0x009a10,  36,    -1628 }, /* VERR_PGM_UNSUPPORTED_SHADOW_PAGING_MODE */
    { 0x00c600,  30, 0x001b8f,  65,    -1627 }, /* VERR_PGM_INTERMEDIATE_PAGING_CONFLICT */
    { 0x00c04e,  31, 0x000d40,  77,    -1626 }, /* VERR_PGM_GCPHYS_RANGE_CROSSES_BOUNDARY */
    { 0x012b96,  21, 0x00f2c5,  26,    -1619 }, /* VERR_PGM_NO_HYPERVISOR_ADDRESS */
    { 0x016e3c,  16, 0x004cc0,  50,    -1618 }, /* VERR_PGM_PHYS_PAGE_RESERVED */
    { 0x01487f,  19, 0x009428,  36,    -1617 }, /* VERR_PGM_UNSUPPORTED_HOST_PAGING_MODE */
    { 0x012ef3,  21, 0x007b4c,  40,    -1612 }, /* VERR_PGM_MAPPINGS_FIX_TOO_SMALL */
    { 0x0118a2,  23, 0x00650a,  44,    -1611 }, /* VERR_PGM_MAPPINGS_FIX_REJECTED */
    { 0x0119e4,  23, 0x0067ca,  44,    -1610 }, /* VERR_PGM_MAPPINGS_FIX_CONFLICT */
    { 0x016e0c,  16, 0x002853,  60,    -1609 }, /* VERR_PGM_MAPPINGS_FIXED */
    { 0x018e05,  14, 0x001ed8,  64,    -1608 }, /* VERR_PGM_RAM_CONFLICT */
    { 0x01a039,  12, 0x00dcc7,  28,    -1607 }, /* VERR_PGM_HANDLER_NOT_FOUND */
    { 0x013e4d,  20, 0x01492a,  19,    -1606 }, /* VERR_PGM_INVALID_GC_PHYSICAL_RANGE */
    { 0x006179,  22, 0x01334c,  21,    -1605 }, /* VERR_PGM_INVALID_GC_PHYSICAL_ADDRESS */
    { 0x0198bc,  13, 0x01b0cb,   9,    -1604 }, /* VERR_PGM_INVALID_PAGE_DIRECTORY */
    { 0x00e86b,  27, 0x002115,  63,    -1603 }, /* VERR_PGM_HANDLER_PHYSICAL_CONFLICT */
    { 0x00f3fd,  26, 0x00234c,  62,    -1602 }, /* VERR_PGM_HANDLER_VIRTUAL_CONFLICT */
    { 0x00cf93,  29, 0x00429f,  52,    -1601 }, /* VERR_PGM_HANDLER_PHYSICAL_NO_RAM_RANGE */
    { 0x015baf,  18, 0x002cbb,  59,    -1600 }, /* VERR_PGM_MAPPING_CONFLICT */
    { 0x019f3d,  12, 0x0074e7,  41,    -1504 }, /* VERR_CSAM_HM_IPE */
    { 0x0100dd,  25, 0x018b03,  14,    -1432 }, /* VERR_PATM_IPE_TRAP_IN_PATCH_CODE */
    { 0x019e41,  12, 0x004d88,  50,    -1431 }, /* VERR_PATM_HM_IPE */
    { 0x018a15,  14, 0x016e2c,  16,    -1428 }, /* VERR_PATM_ALREADY_PATCHED */
    { 0x016c27,  17, 0x00bbb4,  31,    -1426 }, /* VERR_PATM_UNSAFE_CODE */
    { 0x0179ea,  16, 0x013f01,  20,    -1425 }, /* VERR_PATCH_NO_CONFLICT */
    { 0x018013,  15, 0x016eab,  16,    -1406 }, /* VERR_PATCH_ALREADY_ENABLED */
    { 0x0172ea,  16, 0x0164b7,  17,    -1405 }, /* VERR_PATCH_ALREADY_DISABLED */
    { 0x0183b5,  15, 0x017ec9,  15,    -1403 }, /* VERR_PATCH_DISABLED */
    { 0x01b16d,   9, 0x019548,  13,    -1402 }, /* VERR_PATCH_NOT_FOUND */
    { 0x0168e6,  17, 0x001348,  71,    -1401 }, /* VERR_PATCHING_REFUSED */
    { 0x01a41d,  12, 0x01986e,  13,    -1241 }, /* VERR_DBGF_CANCELLED */
    { 0x00a8e2,  33, 0x0095b4,  36,    -1240 }, /* VERR_DBGF_BP_OWNER_CALLBACK_WRONG_STATUS */
    { 0x010461,  25, 0x00b0aa,  32,    -1238 }, /* VERR_DBGF_BP_OWNER_NO_MORE_HANDLES */
    { 0x016cc0,  17, 0x007c8c,  40,    -1237 }, /* VERR_DBGF_BP_L2_LOOKUP_FAILED */
    { 0x0169d4,  17, 0x007b9c,  40,    -1236 }, /* VERR_DBGF_BP_L1_LOOKUP_FAILED */
    { 0x01b624,   8, 0x013925,  20,    -1235 }, /* VERR_DBGF_BP_IPE_9 */
    { 0x01b644,   8, 0x0138c1,  20,    -1234 }, /* VERR_DBGF_BP_IPE_8 */
    { 0x01b64c,   8, 0x013b91,  20,    -1233 }, /* VERR_DBGF_BP_IPE_7 */
    { 0x01b654,   8, 0x013ce5,  20,    -1232 }, /* VERR_DBGF_BP_IPE_6 */
    { 0x01b6b4,   8, 0x0145e1,  20,    -1231 }, /* VERR_DBGF_BP_IPE_5 */
    { 0x01b6d4,   8, 0x014479,  20,    -1230 }, /* VERR_DBGF_BP_IPE_4 */
    { 0x01b6fc,   8, 0x01402d,  20,    -1229 }, /* VERR_DBGF_BP_IPE_3 */
    { 0x01b6ec,   8, 0x014181,  20,    -1228 }, /* VERR_DBGF_BP_IPE_2 */
    { 0x01b6f4,   8, 0x013d49,  20,    -1227 }, /* VERR_DBGF_BP_IPE_1 */
    { 0x00d76b,  28, 0x004840,  51,    -1226 }, /* VERR_DBGF_BP_INT3_ADD_TRIES_REACHED */
    { 0x019a28,  13, 0x004b62,  50,    -1225 }, /* VERR_DBGF_OWNER_BUSY */
    { 0x01be12,   5, 0x01786a,  16,    -1223 }, /* VERR_DBGF_IPE_1 */
    { 0x01a691,  11, 0x007afc,  40,    -1222 }, /* VWRN_DBGF_ALREADY_RUNNING */
    { 0x01a38d,  12, 0x00fcdc,  25,    -1221 }, /* VERR_DBGF_TRACER_IPE_1 */
    { 0x01774a,  16, 0x00515e,  49,    -1220 }, /* VERR_DBGF_NO_TRACE_BUFFER */
    { 0x01a497,  11, 0x016495,  17,    -1219 }, /* VERR_DBGF_STACK_IPE_2 */
    { 0x01a4ad,  11, 0x016b9f,  17,    -1218 }, /* VERR_DBGF_STACK_IPE_1 */
    { 0x0175fa,  16, 0x00ea00,  27,    -1217 }, /* VERR_DBGF_HYPER_DB_XCPT */
    { 0x01b29f,   9, 0x01a1b9,  12,    -1216 }, /* VERR_DBGF_REG_IPE_2 */
    { 0x01b2a8,   9, 0x01a0b1,  12,    -1215 }, /* VERR_DBGF_REG_IPE_1 */
    { 0x01345d,  21, 0x00fa9d,  25,    -1214 }, /* VERR_DBGF_READ_ONLY_REGISTER */
    { 0x01b67c,   8, 0x016d26,  17,    -1213 }, /* VERR_DBGF_UNSUPPORTED_CAST */
    { 0x018b8f,  14, 0x01bbef,   6,    -1210 }, /* VERR_DBGF_REGISTER_NOT_FOUND */
    { 0x0186cd,  14, 0x018220,  15,    -1209 }, /* VERR_DBGF_OS_NOT_DETCTED */
    { 0x01b407,   9, 0x01ac30,  10,    -1208 }, /* VERR_DBGF_MEM_NOT_FOUND */
    { 0x01b864,   8, 0x00ca74,  30,    -1204 }, /* VERR_DBGF_BP_NOT_FOUND */
    { 0x016c49,  17, 0x01109f,  24,    -1203 }, /* VERR_DBGF_NO_MORE_BP_SLOTS */
    { 0x01a32d,  12, 0x00377e,  56,    -1201 }, /* VERR_DBGF_ALREADY_ATTACHED */
    { 0x019c25,  12, 0x001f98,  64,    -1200 }, /* VERR_DBGF_NOT_ATTACHED */
    { 0x015be5,  18, 0x00b808,  32,    -1158 }, /* VERR_EM_GUEST_CPU_HANG */
    { 0x0134f0,  21, 0x004a68,  50,    -1156 }, /* VERR_EM_CANNOT_EXEC_GUEST */
    { 0x013616,  21, 0x00e047,  28,    -1154 }, /* VERR_EM_UNEXPECTED_MAPPING_CONFLICT */
    { 0x01bc37,   6, 0x0040fd,  53,    -1149 }, /* VERR_EM_INTERNAL_ERROR */
    { 0x017d25,  15, 0x008c0a,  38,    -1148 }, /* VERR_EM_INTERPRETER */
    { 0x01217b,  22, 0x007cdc,  40,    -1133 }, /* VERR_EM_RAW_PATCH_CONFLICT */
    { 0x01bc6d,   6, 0x00de6b,  28,    -1114 }, /* VERR_EM_NO_MEMORY */
    { 0x012e75,  21, 0x00589c,  47,    -1028 }, /* VERR_DRIVER_REBOOT_NEEDED */
    { 0x013433,  21, 0x014429,  20,    -1027 }, /* VERR_RESERVED_PAGE_TABLE_BITS */
    { 0x01ba0a,   7, 0x00eb29,  27,    -1026 }, /* VERR_NOT_SUP_BY_NEM */
    { 0x01a460,  11, 0x018e13,  14,    -1025 }, /* VERR_VM_RESTORED */
    { 0x012768,  22, 0x005430,  48,    -1024 }, /* VERR_INCONSISTENT_VM_HANDLE */
    { 0x01a2fd,  12, 0x00a1fc,  34,    -1023 }, /* VERR_RAW_MODE_NOT_SUPPORTED */
    { 0x01aa38,  11, 0x01a6a7,  11,    -1022 }, /* VERR_INVALID_CPU_INDEX */
    { 0x018775,  14, 0x00afea,  32,    -1021 }, /* VERR_NOT_SUP_IN_RAW_MODE */
    { 0x016be3,  17, 0x00daeb,  28,    -1020 }, /* VERR_SERVICE_DISABLED */
    { 0x01ba50,   7, 0x01a4fa,  11,    -1019 }, /* VERR_TOO_MANY_CPUS */
    { 0x01b95c,   8, 0x016fab,  16,    -1018 }, /* VERR_INVALID_CPU_ID */
    { 0x018f2b,  14, 0x01b02c,  10,    -1017 }, /* VERR_INVALID_VMCPU_HANDLE */
    { 0x01af00,  10, 0x01b02c,  10,    -1016 }, /* VERR_INVALID_VM_HANDLE */
    { 0x01906d,  14, 0x017c17,  15,    -1015 }, /* VERR_RAW_MODE_INVALID_SMP */
    { 0x010878,  24, 0x01192c,  23,    -1014 }, /* VERR_PAGE_DIRECTORY_PTR_NOT_PRESENT */
    { 0x013265,  21, 0x017bf9,  15,    -1013 }, /* VERR_PAGE_MAP_LEVEL4_NOT_PRESENT */
    { 0x01bdea,   5, 0x015f0f,  18,    -1012 }, /* VERR_INVALID_RPL */
    { 0x01af14,  10, 0x01af96,  10,    -1011 }, /* VERR_INVALID_SELECTOR */
    { 0x011749,  23, 0x012c53,  21,    -1010 }, /* VERR_OUT_OF_SELECTOR_BOUNDS */
    { 0x017b18,  15, 0x0188fd,  14,    -1009 }, /* VERR_NOT_DATA_SELECTOR */
    { 0x017bcc,  15, 0x015c3f,  18,    -1008 }, /* VERR_NOT_CODE_SELECTOR */
    { 0x015f33,  18, 0x015c99,  18,    -1007 }, /* VERR_SELECTOR_NOT_PRESENT */
    { 0x01a715,  11, 0x011bdd,  23,    -1006 }, /* VERR_CFG_NO_VALUE */
    { 0x01a231,  12, 0x008f68,  37,    -1005 }, /* VERR_CFG_INVALID_FORMAT */
    { 0x01aff0,  10, 0x018e91,  14,    -1004 }, /* VERR_PAGE_NOT_PRESENT */
    { 0x01ad34,  10, 0x01ac80,  10,    -1003 }, /* VERR_UNSUPPORTED_CPU_MODE */
    { 0x01ad34,   5, 0x01bd81,   5,    -1002 }, /* VERR_UNSUPPORTED_CPU */
    { 0x01a925,  11, 0x000ca4,  78,    -1001 }, /* VERR_DONT_PANIC */
    { 0x01be03,   5, 0x013e75,  20,    -1000 }, /* VERR_NO_VM_MEMORY */
    { 0x0117a5,  23, 0x004473,  52,     -965 }, /* VERR_PKZIP_ZIP64EX_IN_ZIP32 */
    { 0x019097,  14, 0x016e5c,  16,     -964 }, /* VERR_PKZIP_UNKNOWN_TYPE_FLAG */
    { 0x015fc3,  18, 0x01499c,  19,     -963 }, /* VERR_PKZIP_BAD_CDF_HEADER */
    { 0x016891,  17, 0x0177fa,  16,     -962 }, /* VERR_PKZIP_BAD_LF_HEADER */
    { 0x016809,  17, 0x01366a,  21,     -961 }, /* VERR_PKZIP_NAME_TOO_LONG */
    { 0x019dd5,  12, 0x011635,  23,     -960 }, /* VERR_PKZIP_NO_EOCB */
    { 0x0166c6,  17, 0x01789a,  16,     -953 }, /* VERR_POLL_SET_IS_FULL */
    { 0x016173,  18, 0x00f9ee,  25,     -952 }, /* VERR_POLL_HANDLE_ID_NOT_FOUND */
    { 0x0122f1,  22, 0x00b06a,  32,     -951 }, /* VERR_POLL_HANDLE_ID_EXISTS */
    { 0x0126fa,  22, 0x014cf3,  19,     -950 }, /* VERR_POLL_HANDLE_NOT_POLLABLE */
    { 0x017ef6,  15, 0x00e30a,  27,     -947 }, /* VERR_TAR_NAME_TOO_LONG */
    { 0x00e8d7,  27, 0x008bbe,  38,     -946 }, /* VERR_TAR_MALFORMED_GNU_LONGXXXX */
    { 0x01596f,  18, 0x008bbe,  38,     -945 }, /* VERR_TAR_BAD_CHKSUM_FIELD */
    { 0x017e06,  15, 0x00b32a,  32,     -944 }, /* VERR_TAR_UNSUPPORTED_GNU_HDR_TYPE */
    { 0x0148cb,  19, 0x009494,  36,     -943 }, /* VERR_TAR_UNSUPPORTED_SOLARIS_HDR_TYPE */
    { 0x01a6f4,  11, 0x003e81,  53,     -942 }, /* VERR_TAR_UNSUPPORTED_PAX_TYPE */
    { 0x00d883,  28, 0x00b729,  32,     -941 }, /* VERR_TAR_NON_DIR_ENDS_WITH_SLASH */
    { 0x017b27,  15, 0x01997f,  13,     -940 }, /* VERR_TAR_EMPTY_NAME */
    { 0x01827a,  15, 0x00bef9,  31,     -939 }, /* VERR_TAR_NOT_USTAR_V00 */
    { 0x017a7a,  16, 0x016374,  17,     -938 }, /* VERR_TAR_ZERO_HEADER */
    { 0x019c6d,  12, 0x016e5c,  16,     -937 }, /* VERR_TAR_UNKNOWN_TYPE_FLAG */
    { 0x019ea1,  12, 0x006e85,  42,     -936 }, /* VERR_TAR_SIZE_NOT_ZERO */
    { 0x01756a,  16, 0x00a482,  34,     -935 }, /* VERR_TAR_MODE_WITH_TYPE */
    { 0x01705b,  16, 0x010303,  25,     -934 }, /* VERR_TAR_BAD_MODE_FIELD */
    { 0x0131a8,  21, 0x002482,  62,     -933 }, /* VERR_TAR_DEV_VALUE_TOO_LARGE */
    { 0x012f86,  21, 0x0024c0,  62,     -932 }, /* VERR_TAR_NUM_VALUE_TOO_LARGE */
    { 0x0174ba,  16, 0x000abf,  83,     -931 }, /* VERR_TAR_BASE_256_NOT_SUPPORTED */
    { 0x013e89,  20, 0x006486,  44,     -930 }, /* VERR_TAR_BAD_NUM_FIELD_TERM */
    { 0x013e89,  15, 0x00fd27,  25,     -929 }, /* VERR_TAR_BAD_NUM_FIELD */
    { 0x014d06,  19, 0x001f18,  64,     -928 }, /* VERR_TAR_EOS_MORE_INPUT */
    { 0x01b43d,   9, 0x00facf,  25,     -927 }, /* VERR_TAR_UNEXPECTED_EOS */
    { 0x0175aa,  16, 0x010620,  24,     -926 }, /* VERR_TAR_END_OF_FILE */
    { 0x019249,  13, 0x00b08a,  32,     -925 }, /* VERR_TAR_CHKSUM_MISMATCH */
    { 0x01518d,  19, 0x012634,  22,     -906 }, /* VERR_MANIFEST_ATTR_TYPE_NOT_FOUND */
    { 0x015ce1,  18, 0x011242,  23,     -905 }, /* VERR_MANIFEST_ATTR_TYPE_MISMATCH */
    { 0x01630e,  17, 0x0088a0,  38,     -904 }, /* VERR_MANIFEST_ATTR_NOT_FOUND */
    { 0x019c3d,  12, 0x00abb8,  33,     -903 }, /* VERR_MANIFEST_FILE_MISMATCH */
    { 0x01a1c5,  12, 0x00c2d6,  30,     -902 }, /* VERR_MANIFEST_DIGEST_MISMATCH */
    { 0x01118a,  23, 0x0052e0,  48,     -901 }, /* VERR_MANIFEST_WRONG_FILE_FORMAT */
    { 0x019a01,  13, 0x00db3f,  28,     -900 }, /* VERR_MANIFEST_UNSUPPORTED_DIGEST_TYPE */
    { 0x019d09,  12, 0x01bab9,   7,     -899 }, /* VERR_HTTP_CURL_ERROR */
    { 0x01b6c4,   8, 0x012726,  22,     -898 }, /* VERR_HTTP_NOT_SUPPORTED */
    { 0x011a6e,  23, 0x010f67,  24,     -897 }, /* VERR_HTTP_CURL_PROXY_CONFIG */
    { 0x0195ca,  13, 0x00b3ca,  32,     -896 }, /* VERR_HTTP_HOST_NOT_FOUND */
    { 0x018b57,  14, 0x010047,  25,     -895 }, /* VERR_HTTP_PROXY_NOT_FOUND */
    { 0x01725a,  16, 0x014401,  20,     -894 }, /* VERR_HTTP_REDIRECTED */
    { 0x019965,  13, 0x009de9,  35,     -893 }, /* VERR_HTTP_ABORTED */
    { 0x00b40a,  32, 0x007844,  41,     -892 }, /* VERR_HTTP_CACERT_CANNOT_AUTHENTICATE */
    { 0x00fe3a,  25, 0x00b02a,  32,     -891 }, /* VERR_HTTP_CACERT_WRONG_FORMAT */
    { 0x014fd8,  19, 0x01749a,  16,     -890 }, /* VERR_HTTP_SSL_CONNECT_ERROR */
    { 0x012d3a,  21, 0x00ada7,  33,     -889 }, /* VERR_HTTP_COULDNT_CONNECT */
    { 0x018bd5,  14, 0x00707d,  42,     -888 }, /* VERR_HTTP_BAD_REQUEST */
    { 0x014be9,  19, 0x010f4f,  24,     -887 }, /* VERR_HTTP_ACCESS_DENIED */
    { 0x01b65c,   8, 0x0060b0,  45,     -886 }, /* VERR_HTTP_NOT_FOUND */
    { 0x019fcd,  12, 0x012b2d,  21,     -885 }, /* VERR_HTTP_INIT_FAILED */
    { 0x012ede,  21, 0x01480d,  19,     -884 }, /* VERR_HTTP_STATUS_SERVER_ERROR */
    { 0x019ef5,  12, 0x013821,  20,     -879 }, /* VERR_S3_CANCELED */
    { 0x01673d,  17, 0x00f501,  26,     -878 }, /* VERR_S3_BUCKET_NOT_EMPTY */
    { 0x0158df,  18, 0x017c8f,  15,     -877 }, /* VERR_S3_BUCKET_ALREADY_EXISTS */
    { 0x01bd6f,   6, 0x0144c9,  20,     -876 }, /* VERR_S3_NOT_FOUND */
    { 0x0162ec,  17, 0x017f8c,  15,     -875 }, /* VERR_S3_ACCESS_DENIED */
    { 0x016f4b,  16, 0x010c68,  24,     -855 }, /* VERR_MEM_CACHE_MAX_SIZE */
    { 0x01a189,  12, 0x0125dc,  22,     -851 }, /* VERR_CACHE_EMPTY */
    { 0x01a510,  11, 0x0136d3,  21,     -850 }, /* VERR_CACHE_FULL */
    { 0x0181b7,  15, 0x006d2d,  43,     -829 }, /* VERR_GETOPT_INDEX_MISSING */
    { 0x0107e8,  24, 0x004167,  52,     -827 }, /* VERR_GETOPT_INVALID_ARGUMENT_FORMAT */
    { 0x00e2ef,  27, 0x006245,  45,     -826 }, /* VERR_GETOPT_REQUIRED_ARGUMENT_MISSING */
    { 0x017eab,  15, 0x0070fb,  42,     -825 }, /* VERR_GETOPT_UNKNOWN_OPTION */
    { 0x01bba0,   7, 0x01a85f,  11,     -803 }, /* VERR_CPU_IPE_1 */
    { 0x0165a5,  17, 0x006eaf,  42,     -802 }, /* VERR_NOT_ALL_CPUS_SHOWED */
    { 0x01bac0,   7, 0x01b218,   9,     -801 }, /* VERR_CPU_NOT_FOUND */
    { 0x01a08d,  12, 0x0184d2,  15,     -800 }, /* VERR_CPU_OFFLINE */
    { 0x018855,  14, 0x005280,  48,     -753 }, /* VERR_ENV_VAR_UNSET */
    { 0x018fd3,  14, 0x00eb95,  27,     -752 }, /* VERR_ENV_INVALID_VAR_NAME */
    { 0x01a778,  11, 0x00f827,  26,     -750 }, /* VERR_ENV_VAR_NOT_FOUND */
    { 0x010d58,  24, 0x00a7f6,  34,     -704 }, /* VERR_RT_REQUEST_STATUS_FREED */
    { 0x00b18a,  32, 0x00279f,  60,     -703 }, /* VERR_RT_REQUEST_STATUS_STILL_PENDING */
    { 0x01407d,  20, 0x019e65,  12,     -702 }, /* VERR_RT_REQUEST_INVALID_PACKAGE */
    { 0x01970f,  13, 0x01a88b,  11,     -701 }, /* VERR_RT_REQUEST_STATE */
    { 0x018cb5,  14, 0x01b040,  10,     -700 }, /* VERR_RT_REQUEST_INVALID_TYPE */
    { 0x00f6d5,  26, 0x00d316,  29,     -696 }, /* VERR_DBG_MALFORMED_UNWIND_INFO */
    { 0x014a21,  19, 0x00b5ea,  32,     -695 }, /* VERR_DBG_UNWIND_INFO_NOT_FOUND */
    { 0x01672c,  17, 0x011ea5,  22,     -694 }, /* VERR_DBG_NO_UNWIND_INFO */
    { 0x01bb3e,   7, 0x008808,  38,     -693 }, /* VERR_CV_IPE */
    { 0x01b53c,   8, 0x005b5a,  46,     -692 }, /* VERR_CV_TODO */
    { 0x01a602,  11, 0x009470,  36,     -691 }, /* VERR_CV_BAD_FORMAT */
    { 0x01a3ed,  12, 0x00eecf,  26,     -689 }, /* VERR_DBG_MOD_IPE */
    { 0x01ba57,   7, 0x004f74,  49,     -688 }, /* VERR_DBG_FILE_MISMATCH */
    { 0x01b3bf,   9, 0x00c92a,  30,     -687 }, /* VERR_DBG_TODO */
    { 0x01461d,  20, 0x00bf18,  31,     -686 }, /* VERR_DBG_DEFERRED_LOAD_FAILED */
    { 0x0153b4,  19, 0x01214f,  22,     -685 }, /* VERR_DBG_CFG_NOT_UINT_PROP */
    { 0x0185d1,  15, 0x01026d,  25,     -684 }, /* VERR_DBG_CFG_INVALID_VALUE */
    { 0x01ac9e,  10, 0x019d75,  12,     -683 }, /* VERR_DWARF_IPE */
    { 0x01247d,  22, 0x00e634,  27,     -682 }, /* VERR_DWARF_STACK_UNDERFLOW */
    { 0x01362b,  21, 0x00f347,  26,     -681 }, /* VERR_DWARF_STACK_OVERFLOW */
    { 0x0159c9,  18, 0x01662d,  17,     -680 }, /* VERR_DWARF_UNKNOWN_LOC_OPCODE */
    { 0x01a505,  11, 0x019c01,  12,     -679 }, /* VERR_DWARF_TODO */
    { 0x01a381,  12, 0x00e02b,  28,     -678 }, /* VERR_DWARF_UNEXPECTED_FORM */
    { 0x01a3f9,  12, 0x00f926,  25,     -677 }, /* VERR_DWARF_UNKNOWN_FORM */
    { 0x01724a,  16, 0x010fc7,  24,     -676 }, /* VERR_DWARF_ABBREV_NOT_FOUND */
    { 0x018d09,  14, 0x00fdd6,  25,     -675 }, /* VERR_DWARF_BAD_ABBREV */
    { 0x019d69,  12, 0x01a051,  12,     -674 }, /* VERR_DWARF_BAD_INFO */
    { 0x01a434,  11, 0x01753a,  16,     -673 }, /* VERR_DWARF_BAD_POS */
    { 0x01b101,   9, 0x0187ad,  14,     -672 }, /* VERR_DWARF_BAD_STRING */
    { 0x01a9b4,  11, 0x00cb45,  29,     -671 }, /* VERR_DWARF_BAD_LNE */
    { 0x014e10,  19, 0x009ff6,  35,     -670 }, /* VERR_DWARF_LEB_OVERFLOW */
    { 0x01a589,  11, 0x016682,  17,     -669 }, /* VERR_DWARF_UNEXPECTED_END */
    { 0x00f125,  26, 0x013d21,  20,     -668 }, /* VERR_DWARF_BAD_LINE_NUMBER_HEADER */
    { 0x00f291,  26, 0x0059b6,  47,     -667 }, /* VERR_DBG_NO_MATCHING_INTERPRETER */
    { 0x013975,  20, 0x00b48a,  32,     -666 }, /* VERR_DBG_NOT_LINUX_KALLSYMS */
    { 0x0163c9,  17, 0x010ce0,  24,     -665 }, /* VERR_DBG_NOT_NM_MAP_FILE */
    { 0x0162b9,  17, 0x00d438,  29,     -664 }, /* VERR_DBG_ADDRESS_WRAP */
    { 0x00c9a2,  30, 0x00a082,  35,     -663 }, /* VERR_DBG_SEGMENT_NAME_OUT_OF_RANGE */
    { 0x011453,  23, 0x00d7a3,  28,     -662 }, /* VERR_DBG_FILE_NAME_OUT_OF_RANGE */
    { 0x00cfb0,  29, 0x00a7b2,  34,     -661 }, /* VERR_DBG_SYMBOL_NAME_OUT_OF_RANGE */
    { 0x01a20d,  12, 0x0072c9,  42,     -660 }, /* VERR_DBG_LINE_NOT_FOUND */
    { 0x00e1fc,  27, 0x004fd6,  49,     -659 }, /* VERR_DBG_SEGMENT_INDEX_CONFLICT */
    { 0x013712,  21, 0x00b709,  32,     -658 }, /* VERR_DBG_DUPLICATE_SYMBOL */
    { 0x013169,  21, 0x007606,  41,     -657 }, /* VERR_DBG_ADDRESS_CONFLICT */
    { 0x014555,  20, 0x00ead8,  27,     -656 }, /* VERR_DBG_SPECIAL_SEGMENT */
    { 0x01b326,   9, 0x00ead8,  27,     -655 }, /* VERR_DBG_INVALID_RVA */
    { 0x014541,  20, 0x016fdb,  16,     -654 }, /* VERR_DBG_INVALID_SEGMENT_OFFSET */
    { 0x014703,  19, 0x018667,  15,     -653 }, /* VERR_DBG_INVALID_SEGMENT_INDEX */
    { 0x019326,  13, 0x00a65e,  34,     -652 }, /* VERR_DBG_INVALID_ADDRESS */
    { 0x0191e1,  13, 0x00ba40,  31,     -651 }, /* VERR_DBG_NO_SYMBOLS */
    { 0x015ccf,  18, 0x00c768,  30,     -650 }, /* VERR_DBG_NO_LINE_NUMBERS */
    { 0x01708b,  16, 0x010d88,  24,     -649 }, /* VERR_LDR_INVALID_SEG_OFFSET */
    { 0x01b233,   9, 0x00ead8,  27,     -648 }, /* VERR_LDR_INVALID_RVA */
    { 0x015f57,  18, 0x019123,  14,     -647 }, /* VERR_LDR_INVALID_LINK_ADDRESS */
    { 0x00f06f,  26, 0x00dfbb,  28,     -641 }, /* VERR_LDRELF_UNTERMINATED_STRING_TAB */
    { 0x00ef51,  26, 0x007053,  42,     -640 }, /* VERR_LDRELF_NO_SYMBOL_OR_NO_STRING_TABS */
    { 0x00f089,  26, 0x00e778,  27,     -639 }, /* VERR_LDRELF_INVALID_RELOCATION_OFFSET */
    { 0x00eabd,  27, 0x00dd6f,  28,     -638 }, /* VERR_LDRELF_INVALID_SYMBOL_NAME_OFFSET */
    { 0x012fc5,  21, 0x00f5eb,  26,     -637 }, /* VERR_LDRELF_INVALID_SYMBOL_INDEX */
    { 0x01317e,  21, 0x00956c,  36,     -636 }, /* VERR_LDRELF_RELOCATION_NOT_SUPPORTED */
    { 0x010938,  24, 0x008296,  39,     -635 }, /* VERR_LDRELF_MULTIPLE_SYMTABS */
    { 0x01b3b6,   9, 0x01b2ba,   9,     -634 }, /* VERR_LDRELF_VERSION */
    { 0x018040,  15, 0x004f12,  49,     -633 }, /* VERR_LDRELF_MACHINE */
    { 0x019ffd,  12, 0x000fe5,  74,     -632 }, /* VERR_LDRELF_EXEC */
    { 0x01a807,  11, 0x00141d,  71,     -631 }, /* VERR_LDRELF_DYN */
    { 0x0160e3,  18, 0x00ab76,  33,     -630 }, /* VERR_LDRELF_ODD_ENDIAN */
    { 0x0136a9,  21, 0x007f5c,  40,     -628 }, /* VERR_LDRPE_GUARD_CF_STUFF */
    { 0x010ec0,  24, 0x00238a,  62,     -627 }, /* VERR_LDRPE_LOCK_PREFIX_TABLE */
    { 0x013b2d,  20, 0x004dec,  49,     -626 }, /* VERR_LDRPE_LOAD_CONFIG_SIZE */
    { 0x012935,  21, 0x00fcc3,  25,     -625 }, /* VERR_LDRPE_COM_DESCRIPTOR */
    { 0x01abfe,  10, 0x015f21,  18,     -624 }, /* VERR_LDRPE_TLS */
    { 0x016dcc,  16, 0x005ec1,  45,     -623 }, /* VERR_LDRPE_GLOBALPTR */
    { 0x011539,  23, 0x009c22,  35,     -622 }, /* VERR_LDRPE_CERT_UNSUPPORTED */
    { 0x0135d7,  21, 0x00c36c,  30,     -621 }, /* VERR_LDRPE_CERT_MALFORMED */
    { 0x0149e8,  19, 0x002f41,  58,     -620 }, /* VERR_LDRPE_DELAY_IMPORT */
    { 0x01809a,  15, 0x018abd,  14,     -619 }, /* VERR_LDR_IMAGE_HASH */
    { 0x013e61,  20, 0x01ac62,  10,     -618 }, /* VERR_LDR_GENERAL_FAILURE */
    { 0x011214,  23, 0x008ca2,  38,     -617 }, /* VERR_LDR_IMPORTED_SYMBOL_NOT_FOUND */
    { 0x019861,  13, 0x009296,  37,     -616 }, /* VERR_LDR_MISMATCH_NATIVE */
    { 0x01a7db,  11, 0x010254,  25,     -615 }, /* VERR_LDR_ARCH_MISMATCH */
    { 0x016b6c,  17, 0x00a2a6,  34,     -614 }, /* VERR_IMAGE_BASE_TOO_HIGH */
    { 0x01a476,  11, 0x01b6ac,   8,     -612 }, /* VERR_IMAGE_TOO_BIG */
    { 0x015a6b,  18, 0x003f20,  53,     -611 }, /* VERR_SYMBOL_VALUE_TOO_BIG */
    { 0x01ace4,  10, 0x01b2f9,   9,     -610 }, /* VERR_MODULE_NOT_FOUND */
    { 0x01ab54,  10, 0x01555b,  18,     -609 }, /* VERR_SYMBOL_NOT_FOUND */
    { 0x019f9d,  12, 0x019f19,  12,     -608 }, /* VERR_BAD_EXE_FORMAT */
    { 0x019f01,  12, 0x0129dd,  21,     -607 }, /* VERR_AOUT_EXE_NOT_SUPPORTED */
    { 0x01adc0,  10, 0x0056c6,  47,     -606 }, /* VERR_MZ_EXE_NOT_SUPPORTED */
    { 0x01ac08,  10, 0x0056f5,  47,     -605 }, /* VERR_NE_EXE_NOT_SUPPORTED */
    { 0x01aadc,  10, 0x00557d,  47,     -604 }, /* VERR_LE_EXE_NOT_SUPPORTED */
    { 0x01b04a,  10, 0x005724,  47,     -603 }, /* VERR_LX_EXE_NOT_SUPPORTED */
    { 0x01ae56,  10, 0x0055db,  47,     -602 }, /* VERR_PE_EXE_NOT_SUPPORTED */
    { 0x01a7af,  11, 0x0053d0,  48,     -601 }, /* VERR_ELF_EXE_NOT_SUPPORTED */
    { 0x017e24,  15, 0x012139,  22,     -600 }, /* VERR_INVALID_EXE_SIGNATURE */
    { 0x01671b,  17, 0x00e391,  27,     -566 }, /* VERR_L4_DS_MANAGER_NOT_FOUND */
    { 0x01023b,  25, 0x00d3c4,  29,     -563 }, /* VERR_IPC_SEND_SEND_PF_TIMEOUT */
    { 0x00dedb,  28, 0x00b10a,  32,     -562 }, /* VERR_IPC_RECEIVE_SEND_PF_TIMEOUT */
    { 0x017c71,  15, 0x00c200,  31,     -561 }, /* VERR_IPC_SEND_MAP_FAILED */
    { 0x016161,  18, 0x00a372,  34,     -560 }, /* VERR_IPC_RECEIVE_MAP_FAILED */
    { 0x0162db,  17, 0x01975d,  13,     -559 }, /* VERR_IPC_SEND_ABORTED */
    { 0x013a15,  20, 0x0171da,  16,     -558 }, /* VERR_IPC_RECEIVE_ABORTED */
    { 0x0153ed,  19, 0x017eba,  15,     -557 }, /* VERR_IPC_SEND_CANCELLED */
    { 0x0128de,  22, 0x015d5f,  18,     -556 }, /* VERR_IPC_RECEIVE_CANCELLED */
    { 0x0166f9,  17, 0x019aaa,  13,     -555 }, /* VERR_IPC_SEND_TIMEOUT */
    { 0x013a01,  20, 0x017aaa,  16,     -554 }, /* VERR_IPC_RECEIVE_TIMEOUT */
    { 0x0182d4,  15, 0x012f47,  21,     -553 }, /* VERR_IPC_PROCESS_NOT_FOUND */
    { 0x01790a,  16, 0x01a4a2,  11,     -552 }, /* VERR_RESOURCE_IN_USE */
    { 0x00dedb,   4, 0x01be80,   5,     -551 }, /* VERR_IPC */
    { 0x018839,  14, 0x01195a,  23,     -550 }, /* VERR_L4_INVALID_DS_OFFSET */
    { 0x0135ad,  21, 0x01136d,  23,     -522 }, /* VERR_UDP_SERVER_DESTROYED */
    { 0x013a79,  20, 0x005007,  49,     -521 }, /* VERR_UDP_SERVER_SHUTDOWN */
    { 0x016f1b,  16, 0x016af5,  17,     -520 }, /* VERR_UDP_SERVER_STOP */
    { 0x012eb4,  21, 0x011173,  23,     -502 }, /* VERR_TCP_SERVER_DESTROYED */
    { 0x013eb1,  20, 0x004e7f,  49,     -501 }, /* VERR_TCP_SERVER_SHUTDOWN */
    { 0x0170aa,  16, 0x016363,  17,     -500 }, /* VERR_TCP_SERVER_STOP */
    { 0x0166e8,  17, 0x00cf1f,  29,     -469 }, /* VERR_NET_NOT_UNSUPPORTED */
    { 0x01a670,  11, 0x018bc7,  14,     -468 }, /* VERR_NET_INIT_FAILED */
    { 0x01018c,  25, 0x009980,  36,     -467 }, /* VERR_NET_INCOMPLETE_TX_PACKET */
    { 0x017cad,  15, 0x01b00e,  10,     -466 }, /* VERR_NET_PROTOCOL_ERROR */
    { 0x013640,  21, 0x0195bd,  13,     -465 }, /* VERR_NET_HOST_UNREACHABLE */
    { 0x0188d3,  14, 0x01a904,  11,     -464 }, /* VERR_NET_HOST_DOWN */
    { 0x011915,  23, 0x015368,  19,     -461 }, /* VERR_NET_CONNECTION_REFUSED */
    { 0x0104ac,  25, 0x00c70e,  30,     -460 }, /* VERR_NET_CONNECTION_TIMED_OUT */
    { 0x016254,  17, 0x00c70e,  30,     -459 }, /* VERR_NET_TOO_MANY_REFERENCES */
    { 0x019340,  13, 0x00aa0b,  33,     -458 }, /* VERR_NET_SHUTDOWN */
    { 0x017e51,  15, 0x014db1,  19,     -457 }, /* VERR_NET_NOT_CONNECTED */
    { 0x01840f,  15, 0x0152d0,  19,     -456 }, /* VERR_NET_ALREADY_CONNECTED */
    { 0x015eeb,  18, 0x010faf,  24,     -455 }, /* VERR_NET_NO_BUFFER_SPACE */
    { 0x00ccdb,  29, 0x011a12,  23,     -454 }, /* VERR_NET_CONNECTION_RESET_BY_PEER */
    { 0x011566,  23, 0x00ad44,  33,     -453 }, /* VERR_NET_CONNECTION_ABORTED */
    { 0x00ccdb,  21, 0x009a34,  36,     -452 }, /* VERR_NET_CONNECTION_RESET */
    { 0x016e8c,  16, 0x012c14,  21,     -451 }, /* VERR_NET_UNREACHABLE */
    { 0x01b164,   9, 0x01905f,  14,     -450 }, /* VERR_NET_DOWN */
    { 0x011704,  23, 0x01235f,  22,     -449 }, /* VERR_NET_ADDRESS_NOT_AVAILABLE */
    { 0x01467e,  19, 0x018aa1,  14,     -448 }, /* VERR_NET_ADDRESS_IN_USE */
    { 0x011d72,  22, 0x0069d1,  43,     -447 }, /* VERR_NET_ADDRESS_FAMILY_NOT_SUPPORTED */
    { 0x0116d6,  23, 0x015e25,  18,     -446 }, /* VERR_NET_PROTOCOL_FAMILY_NOT_SUPPORTED */
    { 0x016c6b,  17, 0x01a009,  12,     -445 }, /* VERR_NET_OPERATION_NOT_SUPPORTED */
    { 0x0170ea,  16, 0x01b09a,  10,     -444 }, /* VERR_NET_SOCKET_TYPE_NOT_SUPPORTED */
    { 0x01717a,  16, 0x01a81d,  11,     -443 }, /* VERR_NET_PROTOCOL_NOT_SUPPORTED */
    { 0x010da0,  24, 0x0140b9,  20,     -442 }, /* VERR_NET_PROTOCOL_NOT_AVAILABLE */
    { 0x017d07,  15, 0x0109f8,  24,     -441 }, /* VERR_NET_PROTOCOL_TYPE */
    { 0x01aa64,  10, 0x018d17,  14,     -440 }, /* VERR_NET_MSG_SIZE */
    { 0x00eeb5,  26, 0x00d4ab,  29,     -439 }, /* VERR_NET_DEST_ADDRESS_REQUIRED */
    { 0x019ccd,  12, 0x008359,  39,     -438 }, /* VERR_NET_NOT_SOCKET */
    { 0x0164a6,  17, 0x0137ba,  21,     -437 }, /* VERR_NET_ALREADY_IN_PROGRESS */
    { 0x0174da,  16, 0x01452d,  20,     -436 }, /* VERR_NET_IN_PROGRESS */
    { 0x01692a,  17, 0x00f03b,  26,     -406 }, /* VERR_NET_NOT_UNIQUE_NAME */
    { 0x019444,  13, 0x01129e,  23,     -405 }, /* VERR_NET_NO_NETWORK */
    { 0x019df9,  12, 0x00f2f9,  26,     -404 }, /* VERR_NET_PRINT_ERROR */
    { 0x019e11,  12, 0x01a9f6,  11,     -403 }, /* VERR_NET_PATH_NOT_FOUND */
    { 0x01a249,  12, 0x01731a,  16,     -402 }, /* VERR_NET_HOST_NOT_FOUND */
    { 0x012fda,  21, 0x00b54a,  32,     -401 }, /* VERR_NET_OUT_OF_RESOURCES */
    { 0x01b380,   9, 0x00c43e,  30,     -400 }, /* VERR_NET_IO_ERROR */
    { 0x01afbe,  10, 0x0081ac,  39,     -377 }, /* VERR_SEM_LV_INTERNAL_ERROR */
    { 0x01567b,  18, 0x00944c,  36,     -376 }, /* VERR_SEM_LV_NOT_SIGNALLER */
    { 0x0118d0,  23, 0x009c45,  35,     -375 }, /* VERR_SEM_LV_ILLEGAL_UPGRADE */
    { 0x0190dd,  14, 0x008770,  38,     -374 }, /* VERR_SEM_LV_NOT_OWNER */
    { 0x010542,  25, 0x006326,  44,     -373 }, /* VERR_SEM_LV_EXISTING_DEADLOCK */
    { 0x0173ba,  16, 0x009548,  36,     -372 }, /* VERR_SEM_LV_DEADLOCK */
    { 0x015495,  18, 0x009a7c,  36,     -371 }, /* VERR_SEM_LV_INVALID_PARAMETER */
    { 0x018a07,  14, 0x005400,  48,     -370 }, /* VERR_SEM_LV_NESTED */
    { 0x00e283,  27, 0x00d024,  29,     -369 }, /* VERR_SEM_LV_WRONG_RELEASE_ORDER */
    { 0x014d19,  19, 0x00d0ef,  29,     -368 }, /* VERR_SEM_LV_WRONG_ORDER */
    { 0x0192a4,  13, 0x0085f0,  39,     -367 }, /* VERR_SEM_BAD_CONTEXT */
    { 0x01762a,  16, 0x009b50,  35,     -366 }, /* VERR_SEM_OUT_OF_TURN */
    { 0x01b422,   9, 0x0159b7,  18,     -365 }, /* VERR_DEADLOCK */
    { 0x01a91a,  11, 0x0024fe,  62,     -364 }, /* VERR_SEM_NESTED */
    { 0x01914d,  14, 0x00a3fa,  34,     -363 }, /* VERR_SEM_DESTROYED */
    { 0x01ba73,   7, 0x00e418,  27,     -362 }, /* VERR_SEM_NOT_FOUND */
    { 0x018595,  15, 0x006c56,  43,     -361 }, /* VERR_SEM_OWNER_DIED */
    { 0x01b17f,   9, 0x016462,  17,     -360 }, /* VERR_SEM_BUSY */
    { 0x01bb1b,   7, 0x00f605,  26,     -359 }, /* VERR_ALREADY_RESET */
    { 0x01b71c,   8, 0x00e325,  27,     -358 }, /* VERR_ALREADY_POSTED */
    { 0x01b6a4,   8, 0x0068a4,  43,     -357 }, /* VERR_TOO_MANY_POSTS */
    { 0x01b5cc,   8, 0x00df67,  28,     -356 }, /* VERR_TOO_MANY_OPENS */
    { 0x01b9e7,   7, 0x0089aa,  38,     -355 }, /* VERR_NOT_OWNER */
    { 0x018568,  15, 0x0111e6,  23,     -354 }, /* VERR_TOO_MANY_SEM_REQUESTS */
    { 0x01a720,  11, 0x00f32d,  26,     -353 }, /* VERR_SEM_IS_SET */
    { 0x0179ca,  16, 0x006822,  44,     -352 }, /* VERR_EXCL_SEM_ALREADY_OWNED */
    { 0x019a0e,  13, 0x0174ea,  16,     -351 }, /* VERR_TOO_MANY_SEMAPHORES */
    { 0x01bd27,   6, 0x00b22a,  32,     -350 }, /* VERR_SEM_ERROR */
    { 0x019e29,  12, 0x008f8d,  37,     -308 }, /* VERR_PIPE_NOT_WRITE */
    { 0x01a64f,  11, 0x008e8a,  37,     -307 }, /* VERR_PIPE_NOT_READ */
    { 0x01afa0,  10, 0x0121ff,  22,     -306 }, /* VERR_MORE_DATA */
    { 0x0170ba,  16, 0x016221,  17,     -305 }, /* VERR_PIPE_NOT_CONNECTED */
    { 0x01bc79,   6, 0x01b684,   8,     -304 }, /* VERR_NO_DATA */
    { 0x01af8c,  10, 0x01a5e1,  11,     -303 }, /* VERR_PIPE_BUSY */
    { 0x01bcbb,   6, 0x01bca3,   6,     -302 }, /* VERR_BAD_PIPE */
    { 0x019fb5,  12, 0x019e35,  12,     -301 }, /* VERR_BROKEN_PIPE */
    { 0x01ae1a,  10, 0x00bc6e,  31,     -300 }, /* VERR_PIPE_IO_ERROR */
    { 0x01851d,  15, 0x00dcab,  28,     -257 }, /* VERR_IO_GEN_FAILURE */
    { 0x01964c,  13, 0x012e4b,  21,     -256 }, /* VERR_IO_SECTOR_NOT_FOUND */
    { 0x01a44a,  11, 0x013c09,  20,     -255 }, /* VERR_IO_BAD_LENGTH */
    { 0x01baf1,   7, 0x01674e,  17,     -254 }, /* VERR_IO_CRC */
    { 0x019e7d,  12, 0x0133a0,  21,     -253 }, /* VERR_IO_BAD_COMMAND */
    { 0x01aa78,  10, 0x011e8f,  22,     -252 }, /* VERR_IO_NOT_READY */
    { 0x01b392,   9, 0x01602f,  18,     -251 }, /* VERR_IO_BAD_UNIT */
    { 0x01b36e,   9, 0x00eb44,  27,     -250 }, /* VERR_DEV_IO_ERROR */
    { 0x011760,  23, 0x005220,  48,     -234 }, /* VERR_IPE_NOT_REACHED_DEFAULT_CASE */
    { 0x011e38,  22, 0x011117,  24,     -233 }, /* VERR_IPE_UNINITIALIZED_STATUS */
    { 0x01a48c,  11, 0x01a97d,  11,     -232 }, /* VERR_IPE_UNEXPECTED_ERROR_STATUS */
    { 0x0186b1,  14, 0x01a97d,  11,     -231 }, /* VERR_IPE_UNEXPECTED_INFO_STATUS */
    { 0x01b3ec,   9, 0x01a97d,  11,     -230 }, /* VERR_IPE_UNEXPECTED_STATUS */
    { 0x01be2b,   5, 0x01bde0,   5,     -229 }, /* VERR_INTERNAL_ERROR_5 */
    { 0x01be30,   5, 0x01bde0,   5,     -228 }, /* VERR_INTERNAL_ERROR_4 */
    { 0x01be35,   5, 0x01bde0,   5,     -227 }, /* VERR_INTERNAL_ERROR_3 */
    { 0x01be3a,   5, 0x01bde0,   5,     -226 }, /* VERR_INTERNAL_ERROR_2 */
    { 0x01be2b,   3, 0x00cd32,  29,     -225 }, /* VERR_INTERNAL_ERROR */
    { 0x012f1d,  21, 0x00bf75,  31,     -202 }, /* VERR_NO_MORE_SEARCH_HANDLES */
    { 0x019f49,  12, 0x019ab7,  13,     -201 }, /* VERR_NO_MORE_FILES */
    { 0x01b2e7,   9, 0x00d041,  29,     -200 }, /* VERR_SEARCH_ERROR */
    { 0x0183a6,  15, 0x018ee5,  14,     -165 }, /* VERR_DRIVE_IS_EMPTY */
    { 0x01640d,  17, 0x011ee7,  22,     -164 }, /* VERR_IS_A_CHAR_DEVICE */
    { 0x0157e3,  18, 0x0157ad,  18,     -163 }, /* VERR_IS_A_BLOCK_DEVICE */
    { 0x01a159,  12, 0x01a261,  12,     -162 }, /* VERR_IS_A_SOCKET */
    { 0x01aece,  10, 0x01ada2,  10,     -161 }, /* VERR_IS_A_FIFO */
    { 0x01942a,  13, 0x014dea,  19,     -160 }, /* VERR_IS_A_SYMLINK */
    { 0x016bb0,  17, 0x011425,  23,     -159 }, /* VERR_SYMLINK_NOT_ALLOWED */
    { 0x0108d8,  24, 0x007da4,  40,     -158 }, /* VERR_NS_SYMLINK_CHANGE_OWNER */
    { 0x014389,  20, 0x005958,  47,     -157 }, /* VERR_NS_SYMLINK_SET_TIME */
    { 0x01a4ce,  11, 0x013885,  20,     -156 }, /* VERR_TOO_MANY_SYMLINKS */
    { 0x0199cd,  13, 0x00d68b,  28,     -155 }, /* VERR_DISK_INVALID_FORMAT */
    { 0x0194b9,  13, 0x0189f9,  14,     -154 }, /* VERR_DRIVE_LOCKED */
    { 0x019f79,  12, 0x019168,  14,     -153 }, /* VERR_DISK_CHANGE */
    { 0x01af5a,  10, 0x01a7c5,  11,     -152 }, /* VERR_DISK_FULL */
    { 0x01bab2,   7, 0x019043,  14,     -151 }, /* VERR_INVALID_DRIVE */
    { 0x01aed8,  10, 0x00bfd2,  31,     -150 }, /* VERR_DISK_IO_ERROR */
    { 0x01874b,  14, 0x007a59,  41,     -147 }, /* VERR_STALE_FILE_HANDLE */
    { 0x01010f,  25, 0x001bd0,  65,     -146 }, /* VERR_FILE_AIO_INSUFFICIENT_EVENTS */
    { 0x016908,  17, 0x016396,  17,     -145 }, /* VERR_PATH_ZERO_LENGTH */
    { 0x015afb,  18, 0x005fa2,  45,     -144 }, /* VERR_PATH_IS_NOT_RELATIVE */
    { 0x0161cc,  17, 0x00c678,  30,     -143 }, /* VERR_PATH_IS_RELATIVE */
    { 0x00e835,  27, 0x00a8a0,  33,     -142 }, /* VERR_PATH_DOES_NOT_START_WITH_ROOT */
    { 0x01ae92,  10, 0x015a35,  18,     -141 }, /* VERR_UNEXPECTED_FS_OBJ_TYPE */
    { 0x01acf8,  10, 0x00b0ca,  32,     -140 }, /* VERR_IS_A_FILE */
    { 0x01b79c,   8, 0x00afaa,  32,     -139 }, /* VERR_NOT_A_FILE */
    { 0x018e83,  14, 0x011663,  23,     -138 }, /* VERR_RESOURCE_BUSY */
    { 0x00d211,  29, 0x0032dc,  57,     -137 }, /* VERR_FILE_AIO_INSUFFICIENT_RESSOURCES */
    { 0x0184c3,  15, 0x00868c,  38,     -136 }, /* VERR_FILE_AIO_NOT_PREPARED */
    { 0x01730a,  16, 0x007681,  41,     -135 }, /* VERR_FILE_AIO_NOT_SUBMITTED */
    { 0x0187f3,  14, 0x01a021,  12,     -134 }, /* VERR_FILE_AIO_CANCELED */
    { 0x013f8d,  20, 0x001c11,  65,     -133 }, /* VERR_FILE_AIO_LIMIT_EXCEEDED */
    { 0x01b054,  10, 0x001a44,  67,     -132 }, /* VERR_FILE_AIO_BUSY */
    { 0x017bea,  15, 0x00a52c,  34,     -131 }, /* VERR_FILE_AIO_COMPLETED */
    { 0x0166b5,  17, 0x001828,  68,     -130 }, /* VERR_FILE_AIO_IN_PROGRESS */
    { 0x01896d,  14, 0x0073c5,  42,     -129 }, /* VERR_FILE_AIO_NO_REQUEST */
    { 0x01bd1b,   6, 0x003f8a,  53,     -128 }, /* VERR_FILE_TOO_BIG */
    { 0x0181a8,  15, 0x00af6a,  32,     -127 }, /* VERR_IS_A_DIRECTORY */
    { 0x01938e,  13, 0x00b30a,  32,     -126 }, /* VERR_NOT_A_DIRECTORY */
    { 0x01a972,  11, 0x012db8,  21,     -125 }, /* VERR_DIR_NOT_EMPTY */
    { 0x01aa43,  11, 0x00ee81,  26,     -124 }, /* VERR_FILE_LOCK_LOST */
    { 0x01b1a3,   9, 0x00bde2,  31,     -123 }, /* VERR_FILE_NOT_LOCKED */
    { 0x015ddd,  18, 0x01209f,  22,     -122 }, /* VERR_MEDIA_NOT_RECOGNIZED */
    { 0x01818a,  15, 0x0123e3,  22,     -121 }, /* VERR_MEDIA_NOT_PRESENT */
    { 0x01806d,  15, 0x00d89f,  28,     -120 }, /* VERR_FILENAME_TOO_LONG */
    { 0x019270,  13, 0x00f1db,  26,     -119 }, /* VERR_NOT_SAME_DEVICE */
    { 0x01252c,  22, 0x0105a6,  25,     -118 }, /* VERR_CANT_DELETE_DIRECTORY */
    { 0x01a3d5,  12, 0x011db4,  22,     -117 }, /* VERR_CANT_CREATE */
    { 0x016f0b,  16, 0x004132,  53,     -116 }, /* VERR_FILE_LOCK_VIOLATION */
    { 0x01b4dc,   8, 0x0109b0,  24,     -115 }, /* VERR_FILE_LOCK_FAILED */
    { 0x015ff9,  18, 0x0050fc,  49,     -114 }, /* VERR_SHARING_VIOLATION */
    { 0x0189dd,  14, 0x0185fe,  15,     -113 }, /* VERR_WRITE_PROTECT */
    { 0x01b504,   8, 0x01b1be,   9,     -112 }, /* VERR_WRITE_ERROR */
    { 0x01b993,   7, 0x01b6e4,   8,     -111 }, /* VERR_READ_ERROR */
    { 0x01beee,   4, 0x01385d,  20,     -110 }, /* VERR_EOF */
    { 0x01826b,  15, 0x011c50,  23,     -109 }, /* VERR_SEEK_ON_DEVICE */
    { 0x018a93,  14, 0x0158a9,  18,     -108 }, /* VERR_NEGATIVE_SEEK */
    { 0x01826b,   5, 0x01bd09,   6,     -107 }, /* VERR_SEEK */
    { 0x0197c5,  13, 0x017a1a,  16,     -106 }, /* VERR_TOO_MANY_OPEN_FILES */
    { 0x01b764,   8, 0x013ec5,  20,     -105 }, /* VERR_ALREADY_EXISTS */
    { 0x01bc7f,   6, 0x00de17,  28,     -104 }, /* VERR_INVALID_NAME */
    { 0x01b8dc,   8, 0x01b9af,   7,     -103 }, /* VERR_PATH_NOT_FOUND */
    { 0x01bf6a,   4, 0x01ba8f,   7,     -102 }, /* VERR_FILE_NOT_FOUND */
    { 0x01b9a1,   7, 0x0156c3,  18,     -101 }, /* VERR_OPEN_FAILED */
    { 0x01bd69,   6, 0x00e70c,  27,     -100 }, /* VERR_FILE_IO_ERROR */
    { 0x01bfd4,   2, 0x014dc4,  19,      -99 }, /* VERR_MISSING */
    { 0x01abc2,  10, 0x013f29,  20,      -98 }, /* VERR_DUPLICATE */
    { 0x01a5c0,  11, 0x0187c9,  14,      -97 }, /* VERR_UNSUPPORTED_ALIGNMENT */
    { 0x01b82c,   8, 0x004afe,  50,      -96 }, /* VERR_NO_EXEC_MEMORY */
    { 0x01b77c,   8, 0x019b7d,  12,      -95 }, /* VERR_NO_CHANGE */
    { 0x0159ed,  18, 0x009740,  36,      -93 }, /* VERR_CALLER_NO_REFERENCE */
    { 0x015885,  18, 0x00bbf2,  31,      -92 }, /* VERR_CONCURRENT_ACCESS */
    { 0x01b8b4,   8, 0x00186c,  68,      -91 }, /* VERR_IGNORED */
    { 0x018be3,  14, 0x0165fa,  17,      -90 }, /* VERR_NOT_POWER_OF_TWO */
    { 0x01133f,  23, 0x0116a8,  23,      -89 }, /* VERR_AUTHENTICATION_FAILURE */
    { 0x01764a,  16, 0x0084b8,  39,      -88 }, /* VERR_CALLBACK_RETURN */
    { 0x01af1e,  10, 0x016ae4,  17,      -87 }, /* VERR_INVALID_BASE64_ENCODING */
    { 0x016572,  17, 0x00f98a,  25,      -86 }, /* VERR_DANGLING_OBJECTS */
    { 0x016330,  17, 0x015083,  19,      -85 }, /* VERR_OBJECT_DESTROYED */
    { 0x014591,  20, 0x013115,  21,      -84 }, /* VERR_PAGE_COUNT_OUT_OF_RANGE */
    { 0x01b42b,   9, 0x019c55,  12,      -83 }, /* VERR_END_OF_STRING */
    { 0x0169b2,  17, 0x012f32,  21,      -82 }, /* VERR_PREEMPT_DISABLED */
    { 0x018df7,  14, 0x007ebc,  40,      -81 }, /* VERR_NO_MORE_HANDLES */
    { 0x0161dd,  17, 0x016d37,  17,      -80 }, /* VERR_OUT_OF_RESOURCES */
    { 0x01bfb5,   3, 0x01bf86,   4,      -79 }, /* VERR_INVALID_STATE */
    { 0x01bfa9,   3, 0x01b458,   9,      -78 }, /* VERR_NOT_FOUND */
    { 0x01765a,  16, 0x01709a,  16,      -77 }, /* VERR_TRAILING_SPACES */
    { 0x0185b3,  15, 0x0142e9,  20,      -76 }, /* VERR_TRAILING_CHARS */
    { 0x01bc43,   6, 0x01780a,  16,      -75 }, /* VERR_MAP_FAILED */
    { 0x0194e0,  13, 0x00a05f,  35,      -74 }, /* VERR_ADDRESS_TOO_BIG */
    { 0x01b8bc,   8, 0x002943,  60,      -73 }, /* VERR_NO_PHYS_MEMORY */
    { 0x01bbca,   7, 0x003901,  55,      -72 }, /* VERR_NO_LOW_MEMORY */
    { 0x018aaf,  14, 0x011ae1,  23,      -71 }, /* VERR_MEMOBJ_INIT_FAILED */
    { 0x01ae06,  10, 0x003893,  55,      -70 }, /* VERR_CANCELLED */
    { 0x0176aa,  16, 0x0080e9,  39,      -69 }, /* VERR_TIMER_SUSPENDED */
    { 0x0198d6,  13, 0x0096b0,  36,      -68 }, /* VERR_TIMER_ACTIVE */
    { 0x01b9d9,   7, 0x00a9c9,  33,      -67 }, /* VERR_MEMORY_BUSY */
    { 0x018de9,  14, 0x003432,  57,      -66 }, /* VERR_NO_CODE_POINT_MEMORY */
    { 0x01b0dd,   9, 0x002193,  63,      -65 }, /* VERR_NO_UTF16_MEMORY */
    { 0x01ba34,   7, 0x005753,  47,      -64 }, /* VERR_NO_STR_MEMORY */
    { 0x01294a,  21, 0x0057b1,  47,      -63 }, /* VERR_CANT_RECODE_AS_UTF16 */
    { 0x01b446,   9, 0x006c81,  43,      -62 }, /* VERR_INVALID_UTF16_ENCODING */
    { 0x01b4c4,   8, 0x007a82,  41,      -61 }, /* VERR_INVALID_UTF8_ENCODING */
    { 0x012fb0,  21, 0x0039dd,  55,      -60 }, /* VERR_CODE_POINT_SURROGATE */
    { 0x00e09b,  28, 0x00102f,  73,      -59 }, /* VERR_CODE_POINT_ENDIAN_INDICATOR */
    { 0x0195f1,  13, 0x006562,  44,      -58 }, /* VERR_NO_TRANSLATION */
    { 0x015753,  18, 0x0092bb,  37,      -57 }, /* VERR_NEGATIVE_UNSIGNED */
    { 0x01b754,   8, 0x0055ac,  47,      -56 }, /* VERR_NO_DIGITS */
    { 0x01a099,  12, 0x007725,  41,      -55 }, /* VERR_NUMBER_TOO_BIG */
    { 0x019958,  13, 0x01652e,  17,      -54 }, /* VERR_OUT_OF_RANGE */
    { 0x01bfbe,   3, 0x01b5c4,   8,      -53 }, /* VERR_PARSE_ERROR */
    { 0x01afaa,  10, 0x01b54c,   8,      -52 }, /* VERR_TRY_AGAIN */
    { 0x01734a,  16, 0x00a903,  33,      -51 }, /* VERR_PROCESS_RUNNING */
    { 0x01a9e0,  11, 0x01bbe9,   6,      -50 }, /* VERR_PROCESS_NOT_FOUND */
    { 0x019381,  13, 0x00ec52,  27,      -49 }, /* VERR_INVALID_UUID_FORMAT */
    { 0x01abf4,  10, 0x01adb6,  10,      -48 }, /* VERR_STATE_CHANGED */
    { 0x0183e2,  15, 0x00bd28,  31,      -47 }, /* VERR_SIGNAL_INVALID */
    { 0x0180a9,  15, 0x0148b8,  19,      -46 }, /* VERR_SIGNAL_PENDING */
    { 0x017cbc,  15, 0x00d22e,  29,      -45 }, /* VERR_SIGNAL_REFUSED */
    { 0x015ab3,  18, 0x018e59,  14,      -44 }, /* VERR_MAX_PROCS_REACHED */
    { 0x015b31,  18, 0x01341e,  21,      -43 }, /* VERR_MAX_THRDS_REACHED */
    { 0x01a594,  11, 0x014c5b,  19,      -42 }, /* VERR_TOO_MUCH_DATA */
    { 0x01701b,  16, 0x00ec37,  27,      -41 }, /* VERR_BUFFER_OVERFLOW */
    { 0x01b674,   8, 0x01b4f4,   8,      -40 }, /* VERR_TIMEOUT */
    { 0x01a045,  12, 0x016a3a,  17,      -39 }, /* VERR_INTERRUPTED */
    { 0x018767,  14, 0x018a3f,  14,      -38 }, /* VERR_ACCESS_DENIED */
    { 0x01bfa6,   3, 0x01bddb,   5,      -37 }, /* VERR_NOT_SUPPORTED */
    { 0x01aa6e,  10, 0x01aa82,  10,      -36 }, /* VERR_INVALID_FUNCTION */
    { 0x01928a,  13, 0x00995c,  36,      -35 }, /* VERR_UNRESOLVED_ERROR */
    { 0x016a7e,  17, 0x016c16,  17,      -34 }, /* VERR_ADDRESS_CONFLICT */
    { 0x01a9a9,  11, 0x015efd,  18,      -33 }, /* VERR_TIMER_BUSY */
    { 0x01b15b,   9, 0x01b1ac,   9,      -32 }, /* VERR_INVALID_CONTEXT */
    { 0x0172fa,  16, 0x015413,  19,      -31 }, /* VERR_PAGE_TABLE_NOT_PRESENT */
    { 0x016287,  17, 0x014131,  20,      -30 }, /* VERR_THREAD_NOT_WAITABLE */
    { 0x01814e,  15, 0x017d34,  15,      -29 }, /* VERR_THREAD_IS_DEAD */
    { 0x019403,  13, 0x013dad,  20,      -28 }, /* VERR_ALREADY_INITIALIZED */
    { 0x01bf6e,   4, 0x00e886,  27,      -27 }, /* VERR_NO_PAGE_MEMORY */
    { 0x01b4cc,   8, 0x009227,  37,      -26 }, /* VERR_NO_CONT_MEMORY */
    { 0x015f45,  18, 0x001d15,  65,      -24 }, /* VERR_FAILED_TO_SET_SELF_TLS */
    { 0x018c37,  14, 0x001152,  72,      -23 }, /* VERR_NO_TLS_FOR_SELF */
    { 0x01a2a9,  12, 0x013790,  21,      -22 }, /* VERR_WRONG_ORDER */
    { 0x01b9bd,   7, 0x0124ea,  22,      -21 }, /* VERR_INVALID_FMODE */
    { 0x01b9b6,   7, 0x00d9d3,  28,      -20 }, /* VERR_NO_TMP_MEMORY */
    { 0x01b302,   9, 0x00c498,  30,      -19 }, /* VERR_NOT_SYMLINK */
    { 0x01bbae,   7, 0x01ad98,  10,      -18 }, /* VERR_NOT_EQUAL */
    { 0x01bb37,   7, 0x018fc5,  14,      -13 }, /* VERR_INVALID_FLAGS */
    { 0x0194d3,  13, 0x01058d,  25,      -12 }, /* VERR_NOT_IMPLEMENTED */
    { 0x01bf36,   4, 0x01670a,  17,      -11 }, /* VERR_VERSION_MISMATCH */
    { 0x015ed9,  18, 0x0155a3,  18,      -10 }, /* VERR_PERMISSION_DENIED */
    { 0x01b984,   8, 0x017bbd,  15,       -9 }, /* VERR_ALREADY_LOADED */
    { 0x01bfa3,   3, 0x014950,  19,       -8 }, /* VERR_NO_MEMORY */
    { 0x01bc1f,   6, 0x0199b3,  13,       -7 }, /* VERR_IDT_FAILED */
    { 0x01b377,   9, 0x01aba4,  10,       -6 }, /* VERR_INVALID_POINTER */
    { 0x01bb99,   7, 0x01264a,  22,       -5 }, /* VERR_LOCK_FAILED */
    { 0x01b96c,   8, 0x01b8f4,   8,       -4 }, /* VERR_INVALID_HANDLE */
    { 0x01baff,   7, 0x01844b,  15,       -3 }, /* VERR_INVALID_MAGIC */
    { 0x01a833,  11, 0x01aa2d,  11,       -2 }, /* VERR_INVALID_PARAMETER */
    { 0x01791a,  16, 0x00971c,  36,       -1 }, /* VERR_GENERAL_FAILURE */
    { 0x01b924,   8, 0x01b5dc,   8,        0 }, /* VINF_SUCCESS */
    { 0x01aa17,  11, 0x01aa2d,  11,        2 }, /* VWRN_INVALID_PARAMETER */
    { 0x01baea,   7, 0x01844b,  15,        3 }, /* VWRN_INVALID_MAGIC */
    { 0x01b7dc,   8, 0x01b8f4,   8,        4 }, /* VWRN_INVALID_HANDLE */
    { 0x01583d,  18, 0x0155a3,  18,       10 }, /* VINF_PERMISSION_DENIED */
    { 0x019562,  13, 0x01058d,  25,       12 }, /* VINF_NOT_IMPLEMENTED */
    { 0x01960b,  13, 0x013dad,  20,       28 }, /* VINF_ALREADY_INITIALIZED */
    { 0x01bfc1,   3, 0x01bddb,   5,       37 }, /* VINF_NOT_SUPPORTED */
    { 0x01a1ad,  12, 0x016a3a,  17,       39 }, /* VINF_INTERRUPTED */
    { 0x01b52c,   8, 0x01b4f4,   8,       40 }, /* VINF_TIMEOUT */
    { 0x016e1c,  16, 0x00ec37,  27,       41 }, /* VINF_BUFFER_OVERFLOW */
    { 0x01adf2,  10, 0x014e82,  19,       48 }, /* VWRN_STATE_CHANGED */
    { 0x01aef6,  10, 0x01b54c,   8,       52 }, /* VINF_TRY_AGAIN */
    { 0x019e59,  12, 0x007725,  41,       55 }, /* VWRN_NUMBER_TOO_BIG */
    { 0x01b4a4,   8, 0x0055ac,  47,       56 }, /* VWRN_NO_DIGITS */
    { 0x0158f1,  18, 0x0092bb,  37,       57 }, /* VWRN_NEGATIVE_UNSIGNED */
    { 0x0195a3,  13, 0x006562,  44,       58 }, /* VWRN_NO_TRANSLATION */
    { 0x017e15,  15, 0x0142e9,  20,       76 }, /* VWRN_TRAILING_CHARS */
    { 0x01736a,  16, 0x01709a,  16,       77 }, /* VWRN_TRAILING_SPACES */
    { 0x01bfaf,   3, 0x01769a,  16,       78 }, /* VWRN_NOT_FOUND */
    { 0x01bfca,   3, 0x01a665,  11,       79 }, /* VWRN_INVALID_STATE */
    { 0x01683c,  17, 0x010848,  24,       80 }, /* VWRN_OUT_OF_RESOURCES */
    { 0x01b149,   9, 0x019c55,  12,       83 }, /* VINF_END_OF_STRING */
    { 0x01641e,  17, 0x00ed45,  27,       85 }, /* VINF_OBJECT_DESTROYED */
    { 0x016880,  17, 0x00f98a,  25,       86 }, /* VWRN_DANGLING_OBJECTS */
    { 0x017aea,  16, 0x0084b8,  39,       88 }, /* VINF_CALLBACK_RETURN */
    { 0x01b704,   8, 0x01784a,  16,       95 }, /* VINF_NO_CHANGE */
    { 0x01a481,  11, 0x00164a,  69,       97 }, /* VINF_UNSUPPORTED_ALIGNMENT */
    { 0x01b60c,   8, 0x013ec5,  20,      105 }, /* VWRN_ALREADY_EXISTS */
    { 0x01bf66,   4, 0x01385d,  20,      110 }, /* VINF_EOF */
    { 0x01987b,  13, 0x005f48,  45,      203 }, /* VWRN_NO_DIRENT_INFO */
    { 0x01b72c,   8, 0x00e325,  27,      358 }, /* VINF_ALREADY_POSTED */
    { 0x01a9ca,  11, 0x004dba,  50,      364 }, /* VINF_SEM_NESTED */
    { 0x019625,  13, 0x004a9a,  50,      367 }, /* VINF_SEM_BAD_CONTEXT */
    { 0x016ecb,  16, 0x01681a,  17,      500 }, /* VINF_TCP_SERVER_STOP */
    { 0x014989,  19, 0x0089f6,  38,      503 }, /* VINF_TCP_SERVER_NO_CLIENT */
    { 0x01754a,  16, 0x01681a,  17,      520 }, /* VINF_UDP_SERVER_STOP */
    { 0x014b51,  19, 0x008ab4,  38,      523 }, /* VINF_UDP_SERVER_NO_CLIENT */
    { 0x0138e9,  20, 0x0065e6,  44,      564 }, /* VINF_IPC_RECEIVE_MSG_CUT */
    { 0x016671,  17, 0x0079de,  41,      565 }, /* VINF_IPC_SEND_MSG_CUT */
    { 0x014a5a,  19, 0x008506,  39,      690 }, /* VINF_DBG_ADJUSTED_SYM_SIZE */
    { 0x01a531,  11, 0x00f827,  26,      750 }, /* VINF_ENV_VAR_NOT_FOUND */
    { 0x011ebb,  22, 0x0005dd,  96,      751 }, /* VWRN_ENV_NOT_FULLY_TRANSLATED */
    { 0x019027,  14, 0x008ef9,  37,      753 }, /* VINF_ENV_VAR_UNSET */
    { 0x017ed8,  15, 0x011fef,  22,      828 }, /* VINF_GETOPT_NOT_OPTION */
    { 0x019659,  13, 0x019184,  14,      948 }, /* VINF_TAR_DIR_PATH */
    { 0x01be76,   5, 0x01bd81,   5,     1002 }, /* VWRN_UNSUPPORTED_CPU */
    { 0x013448,  21, 0x00589c,  47,     1028 }, /* VINF_DRIVER_REBOOT_NEEDED */
    { 0x0192f2,  13, 0x003315,  57,     1100 }, /* VINF_EM_TERMINATE */
    { 0x012df7,  21, 0x00f971,  25,     1101 }, /* VINF_EM_DBG_HYPER_STEPPED */
    { 0x0110e7,  24, 0x00021a, 124,     1102 }, /* VINF_EM_DBG_HYPER_BREAKPOINT */
    { 0x01146a,  23, 00000000, 142,     1103 }, /* VINF_EM_DBG_HYPER_ASSERTION */
    { 0x01963f,  13, 0x009620,  36,     1104 }, /* VINF_EM_DBG_EVENT */
    { 0x019cd9,  12, 0x000b64,  80,     1105 }, /* VINF_EM_DBG_STOP */
    { 0x018298,  15, 0x00122a,  72,     1106 }, /* VINF_EM_DBG_STEPPED */
    { 0x01568d,  18, 0x0007ac,  90,     1107 }, /* VINF_EM_DBG_BREAKPOINT */
    { 0x018298,  12, 0x0058fa,  47,     1108 }, /* VINF_EM_DBG_STEP */
    { 0x01bb68,   7, 0x0009c1,  85,     1109 }, /* VINF_EM_OFF */
    { 0x01a9bf,  11, 0x000e26,  76,     1110 }, /* VINF_EM_SUSPEND */
    { 0x01b221,   9, 0x001fd8,  64,     1111 }, /* VINF_EM_RESET */
    { 0x01b824,   8, 0x000452, 103,     1112 }, /* VINF_EM_HALT */
    { 0x00f44b,  10, 0x003185,  58,     1113 }, /* VINF_EM_RESUME */
    { 0x01bd57,   6, 0x000752,  90,     1114 }, /* VINF_EM_NO_MEMORY */
    { 0x015e91,  18, 0x00396f,  55,     1115 }, /* VINF_EM_RESCHEDULE_REM */
    { 0x00f73d,  26, 0x0034dd,  57,     1116 }, /* VINF_EM_RESCHEDULE_EXEC_ENGINE */
    { 0x00f73d,  14, 0x0074be,  41,     1118 }, /* VINF_EM_RESCHEDULE */
    { 0x0193cf,  13, 0x00cf59,  29,     1120 }, /* VINF_EM_WAIT_SIPI */
    { 0x015f9f,  18, 0x007562,  41,     1121 }, /* VINF_EM_RAW_GUEST_TRAP */
    { 0x01031c,  17, 0x008248,  39,     1122 }, /* VINF_EM_RAW_INTERRUPT */
    { 0x011259,  23, 0x003111,  58,     1123 }, /* VINF_EM_RAW_INTERRUPT_HYPER */
    { 0x011498,  19, 0x00afca,  32,     1124 }, /* VINF_EM_RAW_RING_SWITCH */
    { 0x011498,  23, 0x00326a,  57,     1125 }, /* VINF_EM_RAW_RING_SWITCH_INT */
    { 0x00e07f,  28, 0x007a30,  41,     1126 }, /* VINF_EM_RAW_EXCEPTION_PRIVILEGED */
    { 0x00b9e3,  21, 0x00e943,  27,     1127 }, /* VINF_EM_RAW_EMULATE_INSTR */
    { 0x00bf56,  31, 0x00e5c8,  27,     1128 }, /* VINF_EM_RAW_EMULATE_INSTR_TSS_FAULT */
    { 0x00c08c,  31, 0x00e6d6,  27,     1129 }, /* VINF_EM_RAW_EMULATE_INSTR_LDT_FAULT */
    { 0x00bfb3,  31, 0x00e75d,  27,     1130 }, /* VINF_EM_RAW_EMULATE_INSTR_IDT_FAULT */
    { 0x00b9e3,  31, 0x00b68a,  32,     1131 }, /* VINF_EM_RAW_EMULATE_INSTR_GDT_FAULT */
    { 0x019a83,  13, 0x01188b,  23,     1135 }, /* VINF_EM_RAW_TO_R3 */
    { 0x0129c8,  21, 0x012c92,  21,     1136 }, /* VINF_EM_RAW_TIMER_PENDING */
    { 0x01031c,  25, 0x00a987,  33,     1137 }, /* VINF_EM_RAW_INTERRUPT_PENDING */
    { 0x011f3f,  22, 0x00fa84,  25,     1138 }, /* VINF_EM_RAW_STALE_SELECTOR */
    { 0x016c7c,  17, 0x009398,  36,     1139 }, /* VINF_EM_RAW_IRET_TRAP */
    { 0x01505d,  19, 0x0160d1,  18,     1150 }, /* VINF_EM_PENDING_REQUEST */
    { 0x010890,  24, 0x00d24b,  29,     1151 }, /* VINF_EM_RAW_EMULATE_DBG_STEP */
    { 0x012073,  22, 0x00d350,  29,     1152 }, /* VINF_EM_HM_PATCH_TPR_INSTR */
    { 0x01778a,  16, 0x00b868,  32,     1155 }, /* VINF_EM_TRIPLE_FAULT */
    { 0x00ff7f,  25, 0x00ed60,  27,     1157 }, /* VINF_EM_RAW_INJECT_TRPM_EVENT */
    { 0x00f2ab,  26, 0x009046,  37,     1159 }, /* VINF_EM_PENDING_R3_IOPORT_READ */
    { 0x00e0d3,  27, 0x008854,  38,     1160 }, /* VINF_EM_PENDING_R3_IOPORT_WRITE */
    { 0x00f44b,  26, 0x00288f,  60,     1161 }, /* VINF_EM_RESUME_R3_HISTORY_EXEC */
    { 0x0128f4,  22, 0x00ac7e,  33,     1162 }, /* VINF_EM_EMULATE_SPLIT_LOCK */
    { 0x01af28,  10, 0x00babc,  31,     1202 }, /* VWRN_DBGF_ALREADY_HALTED */
    { 0x01881d,  14, 0x00ab97,  33,     1205 }, /* VINF_DBGF_BP_ALREADY_ENABLED */
    { 0x01823e,  15, 0x009b96,  35,     1206 }, /* VINF_DBGF_BP_ALREADY_DISABLED */
    { 0x01a165,  12, 0x01ad5c,  10,     1207 }, /* VINF_DBGF_BP_ALREADY_EXIST */
    { 0x01915b,  14, 0x018220,  15,     1209 }, /* VINF_DBGF_OS_NOT_DETCTED */
    { 0x012ce6,  21, 0x015645,  18,     1211 }, /* VINF_DBGF_TRUNCATED_REGISTER */
    { 0x00fe85,  25, 0x012089,  22,     1212 }, /* VINF_DBGF_ZERO_EXTENDED_REGISTER */
    { 0x01af32,  10, 0x0006f7,  91,     1224 }, /* VINF_DBGF_BP_HALT */
    { 0x013ff1,  20, 0x0051f0,  48,     1239 }, /* VINF_DBGF_R3_BP_OWNER_DEFER */
    { 0x015927,  18, 0x00583e,  47,     1400 }, /* VWRN_CONTINUE_ANALYSIS */
    { 0x01888d,  14, 0x01913f,  14,     1404 }, /* VWRN_PATCH_ENABLED */
    { 0x018bf1,  14, 0x018004,  15,     1407 }, /* VWRN_PATCH_REMOVED */
    { 0x014917,  19, 0x00aa6e,  33,     1408 }, /* VINF_PATM_PATCH_TRAP_GP */
    { 0x014d65,  19, 0x00ac9f,  33,     1409 }, /* VINF_PATM_PATCH_TRAP_PF */
    { 0x01719a,  16, 0x00a196,  34,     1410 }, /* VINF_PATM_PATCH_INT3 */
    { 0x0122c5,  22, 0x00aa4d,  33,     1411 }, /* VINF_PATM_CHECK_PATCH_PAGE */
    { 0x010aa0,  24, 0x007df4,  40,     1412 }, /* VINF_PATM_DUPLICATE_FUNCTION */
    { 0x013cf9,  20, 0x00f173,  26,     1413 }, /* VINF_PATCH_EMULATE_INSTR */
    { 0x012215,  22, 0x00c5a6,  30,     1414 }, /* VINF_PATM_HC_MMIO_PATCH_WRITE */
    { 0x013694,  21, 0x00cc2d,  29,     1415 }, /* VINF_PATM_HC_MMIO_PATCH_READ */
    { 0x00df13,  28, 0x0083a7,  39,     1416 }, /* VINF_PATM_PENDING_IRQ_AFTER_IRET */
    { 0x016583,  17, 0x010968,  24,     1427 }, /* VWRN_PATCH_END_BRANCH */
    { 0x016ebb,  16, 0x013a8d,  20,     1429 }, /* VINF_PATM_SPINLOCK_FAILED */
    { 0x0185a4,  15, 0x009818,  36,     1430 }, /* VINF_PATCH_CONTINUE */
    { 0x0151b3,  19, 0x01873d,  14,     1500 }, /* VWRN_CSAM_TRAP_NOT_HANDLED */
    { 0x00fd72,  25, 0x016eeb,  16,     1501 }, /* VWRN_CSAM_INSTRUCTION_PATCHED */
    { 0x01b0e6,   9, 0x018e2f,  14,     1502 }, /* VWRN_CSAM_PAGE_NOT_FOUND */
    { 0x013fb5,  20, 0x007896,  41,     1503 }, /* VINF_CSAM_PENDING_ACTION */
    { 0x01add4,  10, 0x00f51b,  26,     1613 }, /* VINF_PGM_SYNC_CR3 */
    { 0x0133f4,  21, 0x00ac5d,  33,     1614 }, /* VINF_PGM_NO_DIRTY_BIT_TRACKING */
    { 0x010209,  25, 0x004f43,  49,     1615 }, /* VINF_PGM_HANDLED_DIRTY_BIT_FAULT */
    { 0x014519,  20, 0x00badb,  31,     1616 }, /* VINF_PGM_HANDLER_DO_DEFAULT */
    { 0x0192be,  13, 0x00f499,  26,     1622 }, /* VINF_PGM_CACHED_PAGE */
    { 0x016dec,  16, 0x000118, 133,     1623 }, /* VINF_PGM_GCPHYS_ALIASED */
    { 0x011baf,  23, 0x011b25,  23,     1625 }, /* VINF_PGM_SYNCPAGE_MODIFIED_PDE */
    { 0x0120cb,  22, 0x008be4,  38,     1635 }, /* VINF_PGM_PHYS_TLB_CATCH_WRITE */
    { 0x015d83,  18, 0x00dbe7,  28,     1643 }, /* VINF_PGM_HANDLER_ALREADY_ALIASED */
    { 0x013a65,  20, 0x007f0c,  40,     1644 }, /* VINF_PGM_POOL_FLUSH_PENDING */
    { 0x0163a7,  17, 0x00b42a,  32,     1758 }, /* VINF_CPUM_R3_MSR_READ */
    { 0x01569f,  18, 0x00a8c1,  33,     1759 }, /* VINF_CPUM_R3_MSR_WRITE */
    { 0x01167a,  23, 0x0054f0,  47,     1766 }, /* VINF_CPUM_HOST_CR0_MODIFIED */
    { 0x0134c6,  21, 0x009f01,  35,     1769 }, /* VINF_CPUM_MATCHED_BY_NAME */
    { 0x011b0f,  23, 0x015108,  19,     1851 }, /* VINF_SSM_VOTE_FOR_ANOTHER_PASS */
    { 0x00e49f,  27, 0x0046a8,  51,     1852 }, /* VINF_SSM_VOTE_DONE_DONT_CALL_AGAIN */
    { 0x016352,  17, 0x009f8d,  35,     1854 }, /* VINF_SSM_DONT_CALL_AGAIN */
    { 0x017aca,  16, 0x002e58,  59,     1864 }, /* VINF_SSM_LIVE_SUSPENDED */
    { 0x019bf5,  12, 0x00ebcb,  27,     2008 }, /* VWRN_VRDP_PDU_NOT_SUPPORTED */
    { 0x01653f,  17, 0x0054c0,  48,     2009 }, /* VINF_VRDP_PROCESS_PDU */
    { 0x00fa52,  25, 0x00b64a,  32,     2010 }, /* VINF_VRDP_OPERATION_COMPLETED */
    { 0x0142ad,  20, 0x00a7d4,  34,     2011 }, /* VINF_VRDP_THREAD_STARTED */
    { 0x012257,  22, 0x003b8e,  54,     2012 }, /* VINF_VRDP_RESIZE_REQUESTED */
    { 0x014716,  19, 0x00d163,  29,     2013 }, /* VINF_VRDP_OUTPUT_ENABLE */
    { 0x0188a9,  14, 0x0095fc,  36,     2503 }, /* VINF_SELM_SYNC_GDT */
    { 0x01746a,  16, 0x00fd59,  25,     2615 }, /* VINF_IOM_MMIO_UNUSED_00 */
    { 0x01781a,  16, 0x00f9d5,  25,     2616 }, /* VINF_IOM_MMIO_UNUSED_FF */
    { 0x01517a,  19, 0x0137e4,  21,     2620 }, /* VINF_IOM_R3_IOPORT_READ */
    { 0x0138d5,  20, 0x012886,  22,     2621 }, /* VINF_IOM_R3_IOPORT_WRITE */
    { 0x00e50b,  27, 0x00c7c2,  30,     2622 }, /* VINF_IOM_R3_IOPORT_COMMIT_WRITE */
    { 0x014465,  14, 0x0189eb,  14,     2623 }, /* VINF_IOM_R3_MMIO_READ */
    { 0x017f6e,  15, 0x017f14,  15,     2624 }, /* VINF_IOM_R3_MMIO_WRITE */
    { 0x014465,  20, 0x01380d,  20,     2625 }, /* VINF_IOM_R3_MMIO_READ_WRITE */
    { 0x01273c,  22, 0x0113c9,  23,     2626 }, /* VINF_IOM_R3_MMIO_COMMIT_WRITE */
    { 0x0178ba,  16, 0x00c29a,  30,     2712 }, /* VINF_VMM_CALL_TRACER */
    { 0x01723a,  16, 0x012bd5,  21,     2714 }, /* VINF_VMM_UNKNOWN_RING3_CALL */
    { 0x01b27b,   9, 0x0108a8,  24,     2824 }, /* VINF_PDM_ALREADY_LOADED */
    { 0x010574,  25, 0x004cf2,  50,     2846 }, /* VINF_PDM_NO_DRIVER_ATTACHED_TO_LUN */
    { 0x00ecd9,  27, 0x016a29,  17,     2898 }, /* VINF_PDM_MEDIAEX_IOREQ_IN_PROGRESS */
    { 0x012e8a,  21, 0x009ebb,  35,     2901 }, /* VINF_HGCM_CLIENT_REJECTED */
    { 0x014c6e,  19, 0x006f2d,  42,     2903 }, /* VINF_HGCM_ASYNC_EXECUTE */
    { 0x01a255,  12, 0x013899,  20,     2906 }, /* VINF_HGCM_SAVE_STATE */
    { 0x014658,  19, 0x00e9e5,  27,     3209 }, /* VINF_VD_ASYNC_IO_FINISHED */
    { 0x01572f,  18, 0x00362e,  56,     3283 }, /* VINF_VD_NEW_ZEROED_BLOCK */
    { 0x01185d,  23, 0x00cc84,  29,     3501 }, /* VINF_VGA_RESIZE_IN_PROGRESS */
    { 0x00fb4c,  25, 0x0014f0,  70,     3746 }, /* VWRN_SUPDRV_TSC_DELTA_MEASUREMENT_FAILED */
    { 0x00c81c,  30, 0x00df4b,  28,     3827 }, /* VINF_GMM_SHARED_MODULE_ALREADY_REGISTERED */
    { 0x019514,  13, 0x00b967,  31,     3901 }, /* VINF_GVM_NOT_BLOCKED */
    { 0x016fcb,  16, 0x0071a3,  42,     3902 }, /* VINF_GVM_NOT_BUSY_IN_GC */
    { 0x019e05,  12, 0x00433b,  52,     3903 }, /* VINF_GVM_YIELDED */
    { 0x01b73c,   8, 0x00d867,  28,     4033 }, /* VINF_VMX_VMEXIT */
    { 0x014e23,  19, 0x002d31,  59,     4035 }, /* VINF_VMX_INTERCEPT_NOT_ACTIVE */
    { 0x014a80,  19, 0x000b12,  82,     4036 }, /* VINF_VMX_MODIFIES_BEHAVIOR */
    { 0x0147e7,  19, 0x0031f8,  57,     4037 }, /* VINF_VMX_VMLAUNCH_VMRESUME */
    { 0x01a812,  11, 0x00ace1,  33,     4067 }, /* VINF_SVM_VMEXIT */
    { 0x01acc6,  10, 0x001b0b,  66,     4068 }, /* VINF_SVM_VMRUN */
    { 0x0120b5,  22, 0x002cf6,  59,     4069 }, /* VINF_SVM_INTERCEPT_NOT_ACTIVE */
    { 0x016f5b,  16, 0x005038,  49,     4117 }, /* VINF_HM_DOUBLE_FAULT */
    { 0x0176da,  16, 0x008221,  39,     4118 }, /* VINF_HM_PENDING_XCPT */
    { 0x0130eb,  21, 0x015741,  18,     4400 }, /* VINF_PARAV_SWITCH_TO_HOST */
    { 0x016d04,  17, 0x0040c8,  53,     4500 }, /* VINF_VHWA_CMD_PENDING */
    { 0x016c8d,  17, 0x002bcf,  59,     4800 }, /* VINF_AIO_TASK_PENDING */
    { 0x01642f,  17, 0x00051b,  97,     5150 }, /* VINF_PCI_MAPPING_DONE */
    { 0x018b81,  14, 0x00110a,  72,     5305 }, /* VINF_IEM_SELECTOR_NOT_OK */
    { 0x0155eb,  18, 0x0044a7,  52,     5306 }, /* VINF_IEM_YIELD_PENDING_FF */
    { 0x016919,  14, 0x003daa,  54,     5310 }, /* VINF_IEM_REEXEC_BREAK */
    { 0x016919,  17, 0x004093,  53,     5311 }, /* VINF_IEM_REEXEC_BREAK_FF */
    { 0x00ef9f,  26, 0x000dda,  76,     5312 }, /* VINF_IEM_REEXEC_FINISH_WITH_FLAGS */
    { 0x01946b,  13, 0x007347,  42,     5313 }, /* VINF_IEM_REEXEC_JUMP */
    { 0x015fd5,  18, 0x008eaf,  37,     5319 }, /* VINF_IEM_RECOMPILE_END_TB */
    { 0x0197b8,  13, 0x011f55,  22,     5401 }, /* VWRN_DBGC_CMD_PENDING */
    { 0x0196ce,  13, 0x0111fd,  23,     5402 }, /* VWRN_DBGC_ALREADY_REGISTERED */
    { 0x01935a,  13, 0x0186a3,  14,     5406 }, /* VINF_DBGC_BP_NO_COMMAND */
    { 0x01a411,  12, 0x011057,  24,     5699 }, /* VINF_SUP_DRIVERLESS */
    { 0x00ec6d,  27, 0x007cb4,  40,     6220 }, /* VWRN_GSTCTL_OBJECTSTATE_CHANGED */
    { 0x016341,  17, 0x0075b4,  41,     6316 }, /* VINF_GIM_R3_HYPERCALL */
    { 0x0104c5,  25, 0x0039a6,  55,     6317 }, /* VINF_GIM_HYPERCALL_CONTINUING */
    { 0x00f0bd,  26, 0x011a9c,  23,     6605 }, /* VINF_AUDIO_MORE_DATA_AVAILABLE */
    { 0x00bbd3,  31, 0x000296, 121,     6609 }, /* VINF_AUDIO_STREAM_ASYNC_INIT_NEEDED */
    { 0x019d15,  12, 0x00d6fb,  28,     6810 }, /* VINF_NEM_FLUSH_TLB */
    { 0x010998,  24, 0x00ae8a,  32,     6906 }, /* VINF_RECORDING_LIMIT_REACHED */
    { 0x01394d,  20, 0x0066ee,  44,     6907 }, /* VINF_RECORDING_THROTTLED */
    { 0x0142c1,  20, 0x016385,  17,     6908 }, /* VWRN_RECORDING_ENCODING_SKIPPED */
    { 0x0174fa,  16, 0x001536,  69,     7200 }, /* VINF_PDM_PCI_DO_DEFAULT */
    { 0x00d5ab,  28, 0x0032a3,  57,     7311 }, /* VINF_IOMMU_ADDR_TRANSLATION_DISABLED */
    { 0x010e48,  12, 0x002211,  63,     7600 }, /* VINF_GCM_HANDLED */
    { 0x010e48,  24, 0x0038ca,  55,     7601 }, /* VINF_GCM_HANDLED_ADVANCE_RIP */
    { 0x019507,  13, 0x004642,  51,    22301 }, /* VINF_LOG_DISABLED */
    { 0x019fd9,  12, 0x0167f8,  17,    22302 }, /* VINF_LOG_NO_LOGGER */
    { 0x01661c,  17, 0x016792,  17,    22401 }, /* VINF_BUFFER_UNDERFLOW */
    { 0x014820,  19, 0x008912,  38,    22405 }, /* VINF_ACCOUNT_RESTRICTED */
    { 0x00bb95,  31, 0x005e3a,  45,    22406 }, /* VWRN_UNABLE_TO_SATISFY_REQUIREMENTS */
    { 0x01b8fc,   8, 0x01a93b,  11,    22409 }, /* VWRN_WRONG_TYPE */
    { 0x012191,  22, 0x000969,  88,    22424 }, /* VINF_THREAD_IS_TERMINATING */
    { 0x01714a,  16, 0x00e66a,  27,    22426 }, /* VWRN_FLOAT_UNDERFLOW */
    { 0x017dac,  15, 0x00f639,  26,    22427 }, /* VWRN_FLOAT_OVERFLOW */
    { 0x018a31,  14, 0x016d15,  17,    22428 }, /* VINF_REBOOT_NEEDED */
    { 0x015549,  18, 0x001cd4,  65,    22501 }, /* VINF_SYS_MAY_POWER_OFF */
    { 0x01a6d3,  11, 0x00e3ac,  27,    22821 }, /* VINF_ASN1_MORE_DATA */
    { 0x01af46,  10, 0x00069c,  91,    22822 }, /* VINF_ASN1_NOT_ENCODED */
    { 0x01b473,   9, 0x002fb5,  58,    22900 }, /* VINF_LDRVI_NOT_SIGNED */
    { 0x01047a,  25, 0x00b26a,  32,    23109 }, /* VINF_X509_NOT_SELFSIGNED_CERTIFICATE */
    { 0x014b2b,  19, 0x0173ea,  16,    23814 }, /* VINF_CR_KEY_WAS_DECRYPTED */
    { 0x01941d,  13, 0x015ae9,  18,    24202 }, /* VINF_CR_DIGEST_DEPRECATED */
    { 0x0190c1,  14, 0x01474f,  19,    24203 }, /* VINF_CR_DIGEST_COMPROMISED */
    { 0x011777,  23, 0x00d573,  28,    24204 }, /* VINF_CR_DIGEST_SEVERELY_COMPROMISED */
    { 0x010710,  24, 0x0041cf,  52,    25007 }, /* VINF_ISOMK_SYMLINK_REQ_ROCK_RIDGE */
    { 0x00e232,  27, 0x01863a,  15,    25704 }, /* VWRN_REST_UNABLE_TO_DECODE_DATE */
};

#include <iprt/bldprog-strtab.h>

static const char g_achStrTabStatusMsgStrTab[] =
{
/* 0x00000 = "Hit a possible assertion in the hypervisor code, EM will first send this to the debugger, and if the issue isn\'t resolved there it will enter guru meditation." */
    'H','i','t',' ','a',' ','p','o','s','s','i','b','l','e',' ','a','s','s','e','r','t','i','o','n',' ','\x0f','\x02','h','y','p','e','r','v','i','s','o','r',' ','c','o','d','e',',',' ','E','M',' ','w','i','l','l',' ','f','i','r','s','t',' ','s','e','n','d',' ','t','h','i','s',' ','\x0a','\x02','d','e','b','u','g','g','e','r',',',' ','\x9a','i','f',' ','\x02','i','s','s','u','e',' ','i','s','n','\'','t',' ','r','e','s','o','l','v','e','d',' ','t','h','e','r','e',' ','i','t',' ','w','i','l','l',' ','e','n','t','e','r',' ','g','u','r','u',' ','m','e','d','i','t','a','t','i','o','n','.',
/* 0x0008e = "Process Verification Failure: Image mapping is bogus as the first region has different AllocationBase and BaseAddress values, indicating that a section was unmapped or otherwise tampered with." */
    '\x1e','\x0d','\x12','I','m','a','g','e',' ','m','a','p','p','i','n','g',' ','\x0b','b','o','g','u','s',' ','a','s',' ','\x02','f','i','r','s','t',' ','r','e','g','i','o','n',' ','\x5e','d','i','f','f','e','r','e','n','t',' ','A','l','l','o','c','a','t','i','o','n','B','a','s','e',' ','\x9a','B','a','s','e','A','d','d','r','e','s','s',' ','v','a','l','u','e','s',',',' ','i','n','d','i','c','a','t','i','n','g',' ','\xad','a',' ','\xdb','\x11','u','n','m','a','p','p','e','d',' ','\xa9','o','t','h','e','r','w','i','s','e',' ','t','a','m','p','e','r','e','d',' ','w','i','t','h','.',
/* 0x00118 = "Returned by handler registration, modification and deregistration when the shadow PTs could be updated because the guest page aliased or/and mapped by multiple PTs." */
    'R','e','t','u','r','n','e','d',' ','\xe1','h','a','n','d','l','e','r',' ','r','e','g','i','s','t','r','a','t','i','o','n',',',' ','m','o','d','i','f','i','c','a','t','i','o','n',' ','\x9a','d','e','r','e','g','i','s','t','r','a','t','i','o','n',' ','w','h','e','n',' ','\x02','s','h','a','d','o','w',' ','P','T','s',' ','c','o','u','l','d',' ','\xa7','u','p','d','a','t','e','d',' ','\x40','\x02','\xbb','\xcc','a','l','i','a','s','e','d',' ','o','r','/','a','n','d',' ','m','a','p','p','e','d',' ','\xe1','m','u','l','t','i','p','l','e',' ','P','T','s','.',
/* 0x0019d = "Process Purification Failure: NtAllocateVirtualMemory failed to get us suitable replacement memory for a chunk of executable memory that shouldn\'t be present in our process." */
    '\x1e','P','u','r','i','f','i','c','a','t','i','o','n',' ','\x12','N','t','A','l','l','o','c','a','t','e','V','i','r','t','u','a','l','M','e','m','o','r','y',' ','\x99','\x0a','g','e','t',' ','u','s',' ','s','u','i','t','a','b','l','e',' ','r','e','p','l','a','c','e','m','e','n','t',' ','\x86','\x10','a',' ','c','h','u','n','k',' ','\x15','e','x','e','c','u','t','a','b','l','e',' ','\x86','\xad','s','h','o','u','l','d','n','\'','t',' ','\xa7','p','r','e','s','e','n','t',' ','\x0f','o','u','r',' ','p','r','o','c','e','s','s','.',
/* 0x0021a = "Hit a breakpoint in the hypervisor code, EM will first send this to the debugger, and if the issue isn\'t resolved there it will enter guru meditation." */
    'H','i','t',' ','a',' ','\xbf','\x0f','\x02','h','y','p','e','r','v','i','s','o','r',' ','c','o','d','e',',',' ','E','M',' ','w','i','l','l',' ','f','i','r','s','t',' ','s','e','n','d',' ','t','h','i','s',' ','\x0a','\x02','d','e','b','u','g','g','e','r',',',' ','\x9a','i','f',' ','\x02','i','s','s','u','e',' ','i','s','n','\'','t',' ','r','e','s','o','l','v','e','d',' ','t','h','e','r','e',' ','i','t',' ','w','i','l','l',' ','e','n','t','e','r',' ','g','u','r','u',' ','m','e','d','i','t','a','t','i','o','n','.',
/* 0x00296 = "Special PDMIHOSTAUDIO::pfnStreamCreate return value for triggering calling of PDMIHOSTAUDIO::pfnStreamInitAsync on a worker thread." */
    'S','p','e','c','i','a','l',' ','P','D','M','I','H','O','S','T','A','U','D','I','O',':',':','p','f','n','S','t','r','e','a','m','C','r','e','a','t','e',' ','r','e','t','u','r','n',' ','\xf5','\x10','t','r','i','g','g','e','r','i','n','g',' ','c','a','l','l','i','n','g',' ','\x15','P','D','M','I','H','O','S','T','A','U','D','I','O',':',':','p','f','n','S','t','r','e','a','m','I','n','i','t','A','s','y','n','c',' ','o','n',' ','a',' ','w','o','r','k','e','r',' ','t','h','r','e','a','d','.',
/* 0x0030f = "An attempt on detaching a driver without anyone actually being attached, or performing any other operation on an attached driver." */
    'A','n',' ','a','t','t','e','m','p','t',' ','o','n',' ','d','e','t','a','c','h','i','n','g',' ','a',' ','\xc5','w','i','t','h','o','u','t',' ','a','n','y','o','n','e',' ','a','c','t','u','a','l','l','y',' ','b','e','i','n','g',' ','a','t','t','a','c','h','e','d',',',' ','\xa9','p','e','r','f','o','r','m','i','n','g',' ','a','n','y',' ','o','t','h','e','r',' ','\x96','o','n',' ','\x87','a','t','t','a','c','h','e','d',' ','d','r','i','v','e','r','.',
/* 0x0037d = "Process Purification Failure: Both NtUnmapViewOfSetion and NtProtectVirtualMemory failed to get rid of or passify an non-image executable mapping." */
    '\x1e','P','u','r','i','f','i','c','a','t','i','o','n',' ','\x12','B','o','t','h',' ','N','t','U','n','m','a','p','V','i','e','w','O','f','S','e','t','i','o','n',' ','\x9a','N','t','P','r','o','t','e','c','t','V','i','r','t','u','a','l','M','e','m','o','r','y',' ','\x99','\x0a','g','e','t',' ','r','i','d',' ','\x15','\xa9','p','a','s','s','i','f','y',' ','\x87','n','o','n','-','\x26','e','x','e','c','u','t','a','b','l','e',' ','m','a','p','p','i','n','g','.',
/* 0x003ea = "Process does not have the trusted code base (TCB) privilege needed for user authentication or/and process creation as a given user." */
    '\x1e','\xb2','\x08','h','a','v','e',' ','\x02','t','r','u','s','t','e','d',' ','c','o','d','e',' ','b','a','s','e',' ','(','T','C','B',')',' ','p','r','i','v','i','l','e','g','e',' ','n','e','e','d','e','d',' ','\x10','u','s','e','r',' ','a','u','t','h','e','n','t','i','c','a','t','i','o','n',' ','o','r','/','a','n','d',' ','\x92','c','r','e','a','t','i','o','n',' ','a','s',' ','a',' ','g','i','v','e','n',' ','u','s','e','r','.',
/* 0x00452 = "Indicating that the VM has executed a halt instruction and that the emulation thread should wait for an interrupt before resuming execution." */
    'I','n','d','i','c','a','t','i','n','g',' ','\xad','\x02','\xcd',' ','\x5e','e','x','e','c','u','t','e','d',' ','a',' ','h','a','l','t',' ','\xda','\x9a','\xad','\x02','e','m','u','l','a','t','i','o','n',' ','t','h','r','e','a','d',' ','s','h','o','u','l','d',' ','w','a','i','t',' ','\x10','\x87','i','n','t','e','r','r','u','p','t',' ','b','e','f','o','r','e',' ','r','e','s','u','m','i','n','g',' ','e','x','e','c','u','t','i','o','n','.',
/* 0x004b9 = "The reservation or reservation update was declined - too many VMs, too little memory, and/or too low GMM configuration." */
    '\x03','r','e','s','e','r','v','a','t','i','o','n',' ','\xa9','r','e','s','e','r','v','a','t','i','o','n',' ','u','p','d','a','t','e',' ','\x11','d','e','c','l','i','n','e','d',' ','-',' ','\x9e','\xb4','V','M','s',',',' ','\x9e','l','i','t','t','l','e',' ','m','e','m','o','r','y',',',' ','a','n','d','/','o','r',' ','\x9e','l','o','w',' ','G','M','M',' ','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x0051b = "Special return code from a PCI I/O region mapping handler that tells the BUS that it has done the mapping already." */
    'S','p','e','c','i','a','l',' ','r','e','t','u','r','n',' ','c','o','d','e',' ','f','r','o','m',' ','a',' ','P','C','I',' ','I','/','O',' ','r','e','g','i','o','n',' ','m','a','p','p','i','n','g',' ','h','a','n','d','l','e','r',' ','\xad','t','e','l','l','s',' ','\x02','B','U','S',' ','\xad','i','t',' ','\x5e','d','o','n','e',' ','\x02','m','a','p','p','i','n','g',' ','a','l','r','e','a','d','y','.',
/* 0x0057c = "The VM process was denied access to vboxdrv because someone have managed to open the process or its main thread with too broad access rights." */
    '\x03','\xcd',' ','\x92','\x11','d','e','n','i','e','d',' ','a','c','c','e','s','s',' ','\x0a','v','b','o','x','d','r','v',' ','\x40','s','o','m','e','o','n','e',' ','h','a','v','e',' ','m','a','n','a','g','e','d',' ','\x0a','o','p','e','n',' ','\x02','\x92','\xa9','i','t','s',' ','m','a','i','n',' ','t','h','r','e','a','d',' ','\x80','\x9e','b','r','o','a','d',' ','a','c','c','e','s','s',' ','r','i','g','h','t','s','.',
/* 0x005dd = "Unable to translate all the variables in the default environment due to codeset issues (LANG / LC_ALL / LC_CTYPE)." */
    '\xe0','\x0a','t','r','a','n','s','l','a','t','e',' ','a','l','l',' ','\x02','v','a','r','i','a','b','l','e','s',' ','\x0f','\x02','d','e','f','a','u','l','t',' ','e','n','v','i','r','o','n','m','e','n','t',' ','d','u','e',' ','\x0a','c','o','d','e','s','e','t',' ','i','s','s','u','e','s',' ','(','L','A','N','G',' ','/',' ','L','C','_','A','L','L',' ','/',' ','L','C','_','C','T','Y','P','E',')','.',
/* 0x0063d = "The image is required to be signed with the same certificate as the rest of VirtualBox or one of the special trusted (Oracle) certificates." */
    '\x03','\x26','\x0b','r','e','q','u','i','r','e','d',' ','\x0a','\xa7','s','i','g','n','e','d',' ','\x80','\x02','s','a','m','e',' ','\xa0','a','s',' ','\x02','r','e','s','t',' ','\x15','V','i','r','t','u','a','l','B','o','x',' ','\xa9','o','n','e',' ','\x15','\x02','s','p','e','c','i','a','l',' ','t','r','u','s','t','e','d',' ','(','O','r','a','c','l','e',')',' ','c','e','r','t','i','f','i','c','a','t','e','s','.',
/* 0x0069c = "RTAsnEncodeWriteHeader return code indicating that nothing was written and the content should be skipped as well." */
    'R','T','A','s','n','E','n','c','o','d','e','W','r','i','t','e','H','e','a','d','e','r',' ','r','e','t','u','r','n',' ','c','o','d','e',' ','i','n','d','i','c','a','t','i','n','g',' ','\xad','n','o','t','h','i','n','g',' ','\x11','w','r','i','t','t','e','n',' ','\x9a','\x02','\xf0','s','h','o','u','l','d',' ','\xa7','s','k','i','p','p','e','d',' ','a','s',' ','w','e','l','l','.',
/* 0x006f7 = "Returned by a breakpoint callback when guest execution should be suspended and the VM should be dropped into the debugger." */
    'R','e','t','u','r','n','e','d',' ','\xe1','a',' ','\xbf','c','a','l','l','b','a','c','k',' ','w','h','e','n',' ','\xbb','e','x','e','c','u','t','i','o','n',' ','s','h','o','u','l','d',' ','\xa7','s','u','s','p','e','n','d','e','d',' ','\x9a','\x02','\xcd',' ','s','h','o','u','l','d',' ','\xa7','d','r','o','p','p','e','d',' ','i','n','t','o',' ','\x02','d','e','b','u','g','g','e','r','.',
/* 0x00752 = "Indicating that we\'ve got an out-of-memory condition and that we need to take the appropriate actions to deal with this." */
    'I','n','d','i','c','a','t','i','n','g',' ','\xad','w','e','\'','v','e',' ','g','o','t',' ','\x87','o','u','t','-','o','f','-','\x86','c','o','n','d','i','t','i','o','n',' ','\x9a','\xad','w','e',' ','n','e','e','d',' ','\x0a','t','a','k','e',' ','\x02','a','p','p','r','o','p','r','i','a','t','e',' ','a','c','t','i','o','n','s',' ','\x0a','d','e','a','l',' ','\x80','t','h','i','s','.',
/* 0x007ac = "Indicating that a breakpoint was hit and that EM should notify the debugger and in the event there is no debugger fail fatally." */
    'I','n','d','i','c','a','t','i','n','g',' ','\xad','a',' ','\xbf','\x11','h','i','t',' ','\x9a','\xad','E','M',' ','s','h','o','u','l','d',' ','n','o','t','i','f','y',' ','\x02','d','e','b','u','g','g','e','r',' ','\x9a','\x0f','\x02','e','v','e','n','t',' ','t','h','e','r','e',' ','\x0b','n','o',' ','d','e','b','u','g','g','e','r',' ','f','a','i','l',' ','f','a','t','a','l','l','y','.',
/* 0x00806 = "Process Purification Failure: NtFreeVirtualMemory failed on a chunk of executable memory which shouldn\'t be present in the process." */
    '\x1e','P','u','r','i','f','i','c','a','t','i','o','n',' ','\x12','N','t','F','r','e','e','V','i','r','t','u','a','l','M','e','m','o','r','y',' ','\x99','o','n',' ','a',' ','c','h','u','n','k',' ','\x15','e','x','e','c','u','t','a','b','l','e',' ','\x86','\xed','s','h','o','u','l','d','n','\'','t',' ','\xa7','p','r','e','s','e','n','t',' ','\x0f','\x02','p','r','o','c','e','s','s','.',
/* 0x00860 = "A boot catalog extension entry in the import ISO indicates more entries when we reached the end of the boot catalog sector." */
    'A',' ','b','o','o','t',' ','\xe7','e','x','t','e','n','s','i','o','n',' ','\xc8','\x0f','\x02','i','m','p','o','r','t',' ','\xc1',' ','i','n','d','i','c','a','t','e','s',' ','m','o','r','e',' ','e','n','t','r','i','e','s',' ','w','h','e','n',' ','w','e',' ','r','e','a','c','h','e','d',' ','\x02','e','n','d',' ','\x15','\x02','b','o','o','t',' ','\xe7','s','e','c','t','o','r','.',
/* 0x008b9 = "If a Host Interface Networking filehandle was specified it\'s not allowed to have any init or term programs." */
    'I','f',' ','a',' ','H','o','s','t',' ','I','n','t','e','r','f','a','c','e',' ','N','e','t','w','o','r','k','i','n','g',' ','f','i','l','e','h','a','n','d','l','e',' ','\x11','\x18','i','t','\'','s',' ','\x08','a','l','l','o','w','e','d',' ','\x0a','h','a','v','e',' ','a','n','y',' ','i','n','i','t',' ','\xa9','t','e','r','m',' ','p','r','o','g','r','a','m','s','.',
/* 0x00911 = "A boot catalog entry in the import ISO sets the continuation flag when using NONE as the selection criteria type." */
    'A',' ','b','o','o','t',' ','\xe7','\xc8','\x0f','\x02','i','m','p','o','r','t',' ','\xc1',' ','s','e','t','s',' ','\x02','c','o','n','t','i','n','u','a','t','i','o','n',' ','f','l','a','g',' ','w','h','e','n',' ','u','s','i','n','g',' ','N','O','N','E',' ','a','s',' ','\x02','s','e','l','e','c','t','i','o','n',' ','c','r','i','t','e','r','i','a',' ','t','y','p','e','.',
/* 0x00969 = "Returned by RTThreadQueryTerminationStatus to indicate that the thread is (or should be) terminating." */
    'R','e','t','u','r','n','e','d',' ','\xe1','R','T','T','h','r','e','a','d','Q','u','e','r','y','T','e','r','m','i','n','a','t','i','o','n','S','t','a','t','u','s',' ','\x0a','i','n','d','i','c','a','t','e',' ','\xad','\x02','t','h','r','e','a','d',' ','\x0b','(','o','r',' ','s','h','o','u','l','d',' ','b','e',')',' ','t','e','r','m','i','n','a','t','i','n','g','.',
/* 0x009c1 = "Indicating that the VM is being turned off and that the EM should exit to the VM awaiting the destruction request." */
    'I','n','d','i','c','a','t','i','n','g',' ','\xad','\x02','\xcd',' ','\x0b','b','e','i','n','g',' ','t','u','r','n','e','d',' ','o','f','f',' ','\x9a','\xad','\x02','E','M',' ','s','h','o','u','l','d',' ','e','x','i','t',' ','\x0a','\x02','\xcd',' ','a','w','a','i','t','i','n','g',' ','\x02','d','e','s','t','r','u','c','t','i','o','n',' ','r','e','q','u','e','s','t','.',
/* 0x00a16 = "Returned by callback methods which does not need to be called again because the client does not actually make use of them." */
    'R','e','t','u','r','n','e','d',' ','\xe1','c','a','l','l','b','a','c','k',' ','m','e','t','h','o','d','s',' ','\xed','\xb2','\x08','n','e','e','d',' ','\x0a','\xa7','c','a','l','l','e','d',' ','a','g','a','i','n',' ','\x40','\x02','c','l','i','e','n','t',' ','\xb2','\x08','a','c','t','u','a','l','l','y',' ','m','a','k','e',' ','u','s','e',' ','\x15','t','h','e','m','.',
/* 0x00a6b = "The DTB being parsed has no terminating memory reservation block entry before the start of the structs block." */
    '\x03','D','T','B',' ','b','e','i','n','g',' ','p','a','r','s','e','d',' ','\x5e','n','o',' ','t','e','r','m','i','n','a','t','i','n','g',' ','\x86','r','e','s','e','r','v','a','t','i','o','n',' ','b','l','o','c','k',' ','\xc8','b','e','f','o','r','e',' ','\x02','s','t','a','r','t',' ','\x15','\x02','s','t','r','u','c','t','s',' ','b','l','o','c','k','.',
/* 0x00abf = "A number tar header field was encoded using base-256 which this tar implementation currently does not support." */
    'A',' ','\xfb','t','a','r',' ','\xb3','f','i','e','l','d',' ','\x11','e','n','c','o','d','e','d',' ','u','s','i','n','g',' ','b','a','s','e','-','2','5','6',' ','\xed','t','h','i','s',' ','t','a','r',' ','i','m','p','l','e','m','e','n','t','a','t','i','o','n',' ','c','u','r','r','e','n','t','l','y',' ','\xb2','\x08','s','u','p','p','o','r','t','.',
/* 0x00b12 = "The behavior of the instruction/operation is modified/needs modification in VMX non-root mode." */
    '\x03','b','e','h','a','v','i','o','r',' ','\x15','\x02','i','n','s','t','r','u','c','t','i','o','n','/','o','p','e','r','a','t','i','o','n',' ','\x0b','m','o','d','i','f','i','e','d','/','n','e','e','d','s',' ','m','o','d','i','f','i','c','a','t','i','o','n',' ','\x0f','V','M','X',' ','n','o','n','-','r','o','o','t',' ','m','o','d','e','.',
/* 0x00b64 = "Indicating that the VM should be suspended for debugging because the developer wants to inspect the VM state." */
    'I','n','d','i','c','a','t','i','n','g',' ','\xad','\x02','\xcd',' ','s','h','o','u','l','d',' ','\xa7','s','u','s','p','e','n','d','e','d',' ','\x10','d','e','b','u','g','g','i','n','g',' ','\x40','\x02','d','e','v','e','l','o','p','e','r',' ','w','a','n','t','s',' ','\x0a','i','n','s','p','e','c','t',' ','\x02','\xcd',' ','s','t','a','t','e','.',
/* 0x00bb4 = "VFS chain only has a single element and it is just a path, need to be treated as a normal file system request." */
    '\x8d',' ','\xa1','o','n','l','y',' ','\x5e','a',' ','s','i','n','g','l','e',' ','\x5c','\x9a','i','t',' ','\x0b','j','u','s','t',' ','a',' ','p','a','t','h',',',' ','n','e','e','d',' ','\x0a','\xa7','t','r','e','a','t','e','d',' ','a','s',' ','a',' ','n','o','r','m','a','l',' ','\x1f','s','y','s','t','e','m',' ','r','e','q','u','e','s','t','.',
/* 0x00c04 = "A boot catalog entry in the import ISO sets the continuation flag when we reached the ned of the boot catalog secotr." */
    'A',' ','b','o','o','t',' ','\xe7','\xc8','\x0f','\x02','i','m','p','o','r','t',' ','\xc1',' ','s','e','t','s',' ','\x02','c','o','n','t','i','n','u','a','t','i','o','n',' ','f','l','a','g',' ','w','h','e','n',' ','w','e',' ','r','e','a','c','h','e','d',' ','\x02','n','e','d',' ','\x15','\x02','b','o','o','t',' ','\xe7','s','e','c','o','t','r','.',
/* 0x00c54 = "Process does not have the assign primary token (APT) privilege needed for creating process as a given user." */
    '\x1e','\xb2','\x08','h','a','v','e',' ','\x02','a','s','s','i','g','n',' ','p','r','i','m','a','r','y',' ','t','o','k','e','n',' ','(','A','P','T',')',' ','p','r','i','v','i','l','e','g','e',' ','n','e','e','d','e','d',' ','\x10','c','r','e','a','t','i','n','g',' ','\x92','a','s',' ','a',' ','g','i','v','e','n',' ','u','s','e','r','.',
/* 0x00ca4 = "RC is toasted and the VMM should be terminated at once, but no need to panic about it :-)." */
    'R','C',' ','\x0b','t','o','a','s','t','e','d',' ','\x9a','\x02','V','M','M',' ','s','h','o','u','l','d',' ','\xa7','t','e','r','m','i','n','a','t','e','d',' ','a','t',' ','o','n','c','e',',',' ','b','u','t',' ','n','o',' ','n','e','e','d',' ','\x0a','p','a','n','i','c',' ','a','b','o','u','t',' ','i','t',' ',':','-',')','.',
/* 0x00cf2 = "A boot catalog extension entry in the import ISO was either flagged incorrectly in the previous entry or has an invalid header ID." */
    'A',' ','b','o','o','t',' ','\xe7','e','x','t','e','n','s','i','o','n',' ','\xc8','\x0f','\x02','i','m','p','o','r','t',' ','\xc1',' ','\x11','e','i','t','h','e','r',' ','f','l','a','g','g','e','d',' ','i','n','c','o','r','r','e','c','t','l','y',' ','\x0f','\x02','p','r','e','v','i','o','u','s',' ','\xc8','\xa9','\x5e','\x87','\x8f','\xb3','I','D','.',
/* 0x00d40 = "Physical range crosses dynamic ram chunk boundary; translation to HC ptr not safe." */
    'P','h','y','s','i','c','a','l',' ','r','a','n','g','e',' ','c','r','o','s','s','e','s',' ','d','y','n','a','m','i','c',' ','r','a','m',' ','c','h','u','n','k',' ','b','o','u','n','d','a','r','y',';',' ','t','r','a','n','s','l','a','t','i','o','n',' ','\x0a','H','C',' ','p','t','r',' ','\x08','s','a','f','e','.',
/* 0x00d8d = "A field contained an transformation that should only be used when loading old states." */
    'A',' ','f','i','e','l','d',' ','c','o','n','t','a','i','n','e','d',' ','\x87','t','r','a','n','s','f','o','r','m','a','t','i','o','n',' ','\xad','s','h','o','u','l','d',' ','o','n','l','y',' ','\xa7','u','s','e','d',' ','w','h','e','n',' ','l','o','a','d','i','n','g',' ','o','l','d',' ','s','t','a','t','e','s','.',
/* 0x00dda = "Recompiled execution: Debug related (hidden) EFLAGS are set and needs handling." */
    'R','e','c','o','m','p','i','l','e','d',' ','e','x','e','c','u','t','i','o','n',':',' ','D','e','b','u','g',' ','r','e','l','a','t','e','d',' ','(','h','i','d','d','e','n',')',' ','E','F','L','A','G','S',' ','a','r','e',' ','s','e','t',' ','\x9a','n','e','e','d','s',' ','h','a','n','d','l','i','n','g','.',
/* 0x00e26 = "Indicating that the VM has been suspended and that the thread should wait for request telling it what to do next." */
    'I','n','d','i','c','a','t','i','n','g',' ','\xad','\x02','\xcd',' ','\x5e','\xcb','s','u','s','p','e','n','d','e','d',' ','\x9a','\xad','\x02','t','h','r','e','a','d',' ','s','h','o','u','l','d',' ','w','a','i','t',' ','\x10','\xaa','t','e','l','l','i','n','g',' ','i','t',' ','w','h','a','t',' ','\x0a','d','o',' ','n','e','x','t','.',
/* 0x00e72 = "Process does not have the increase quota (IQ) privilege needed for creating a process as a given user." */
    '\x1e','\xb2','\x08','h','a','v','e',' ','\x02','i','n','c','r','e','a','s','e',' ','q','u','o','t','a',' ','(','I','Q',')',' ','p','r','i','v','i','l','e','g','e',' ','n','e','e','d','e','d',' ','\x10','c','r','e','a','t','i','n','g',' ','a',' ','\x92','a','s',' ','a',' ','g','i','v','e','n',' ','u','s','e','r','.',
/* 0x00ebd = "Process Verification Failure: Expected the process and exe to have forced integrity checking enabled (verifying signatures)." */
    '\x1e','\x0d','\x12','\xb8','\x02','\x92','\x9a','e','x','e',' ','\x0a','h','a','v','e',' ','f','o','r','c','e','d',' ','i','n','t','e','g','r','i','t','y',' ','c','h','e','c','k','i','n','g',' ','e','n','a','b','l','e','d',' ','(','v','e','r','i','f','y','i','n','g',' ','s','i','g','n','a','t','u','r','e','s',')','.',
/* 0x00f07 = "CPUMR3DisasmInstrCPU unexpectedly failed to determine the hidden parts of the CS register." */
    'C','P','U','M','R','3','D','i','s','a','s','m','I','n','s','t','r','C','P','U',' ','u','n','e','x','p','e','c','t','e','d','l','y',' ','\x99','\x0a','d','e','t','e','r','m','i','n','e',' ','\x02','h','i','d','d','e','n',' ','p','a','r','t','s',' ','\x15','\x02','C','S',' ','r','e','g','i','s','t','e','r','.',
/* 0x00f51 = "UDF file cannot be import as it has discontiguous allocation descriptors or is a sparse file." */
    'U','D','F',' ','\x1f','\xd1','\xa7','i','m','p','o','r','t',' ','a','s',' ','i','t',' ','\x5e','d','i','s','c','o','n','t','i','g','u','o','u','s',' ','a','l','l','o','c','a','t','i','o','n',' ','d','e','s','c','r','i','p','t','o','r','s',' ','\xa9','\x0b','a',' ','s','p','a','r','s','e',' ','f','i','l','e','.',
/* 0x00f9b = "IOMMU instance cannot call itself (for remapping interrupts or translating addresses)." */
    '\xfd',' ','i','n','s','t','a','n','c','e',' ','\xd1','c','a','l','l',' ','i','t','s','e','l','f',' ','(','f','o','r',' ','r','e','m','a','p','p','i','n','g',' ','i','n','t','e','r','r','u','p','t','s',' ','\xa9','t','r','a','n','s','l','a','t','i','n','g',' ','a','d','d','r','e','s','s','e','s',')','.',
/* 0x00fe5 = "The ELF image is \'executable\', the ELF loader can only deal with \'relocatable\' images at present." */
    '\x03','E','L','F',' ','\x26','\x0b','\'','e','x','e','c','u','t','a','b','l','e','\'',',',' ','\x02','E','L','F',' ','\xd9','c','a','n',' ','o','n','l','y',' ','d','e','a','l',' ','\x80','\'','r','e','l','o','c','a','t','a','b','l','e','\'',' ','i','m','a','g','e','s',' ','a','t',' ','p','r','e','s','e','n','t','.',
/* 0x0102f = "Encountered unicode code point which is reserved for use as endian indicator (0xffff or 0xfffe)." */
    '\xa5','u','n','i','c','o','d','e',' ','c','o','d','e',' ','p','o','i','n','t',' ','\xed','\x0b','r','e','s','e','r','v','e','d',' ','\x10','u','s','e',' ','a','s',' ','e','n','d','i','a','n',' ','i','n','d','i','c','a','t','o','r',' ','(','0','x','f','f','f','f',' ','\xa9','0','x','f','f','f','e',')','.',
/* 0x01078 = "The port being read was not present(/unused) and IOM shall return ~0 according to size." */
    '\x03','p','o','r','t',' ','b','e','i','n','g',' ','r','e','a','d',' ','\x11','\x08','p','r','e','s','e','n','t','(','/','u','n','u','s','e','d',')',' ','\x9a','I','O','M',' ','s','h','a','l','l',' ','r','e','t','u','r','n',' ','~','0',' ','a','c','c','o','r','d','i','n','g',' ','\x0a','s','i','z','e','.',
/* 0x010c1 = "Stub process thread not found during revalidation upon vboxdrv opening by the VM process." */
    'S','t','u','b',' ','\x92','t','h','r','e','a','d',' ','\x08','f','o','u','n','d',' ','d','u','r','i','n','g',' ','r','e','v','a','l','i','d','a','t','i','o','n',' ','u','p','o','n',' ','v','b','o','x','d','r','v',' ','o','p','e','n','i','n','g',' ','\xe1','\x02','\xcd',' ','p','r','o','c','e','s','s','.',
/* 0x0110a = "Internal status code for indicating that a selector isn\'t valid (LAR, LSL, VERR, VERW)." */
    '\x07','s','t','a','t','u','s',' ','c','o','d','e',' ','\x10','i','n','d','i','c','a','t','i','n','g',' ','\xad','a',' ','s','e','l','e','c','t','o','r',' ','i','s','n','\'','t',' ','v','a','l','i','d',' ','(','L','A','R',',',' ','L','S','L',',',' ','V','E','R','R',',',' ','V','E','R','W',')','.',
/* 0x01152 = "There is no TLS (thread local storage) available for storing the current thread." */
    'T','h','e','r','e',' ','\x0b','n','o',' ','T','L','S',' ','(','t','h','r','e','a','d',' ','l','o','c','a','l',' ','s','t','o','r','a','g','e',')',' ','a','v','a','i','l','a','b','l','e',' ','\x10','s','t','o','r','i','n','g',' ','\x02','c','u','r','r','e','n','t',' ','t','h','r','e','a','d','.',
/* 0x0119a = "VFS chain element only provides a read-only I/O stream, while the chain requires write access." */
    '\x8d',' ','\xa1','\x5c','o','n','l','y',' ','p','r','o','v','i','d','e','s',' ','a',' ','r','e','a','d','-','o','n','l','y',' ','I','/','O',' ','s','t','r','e','a','m',',',' ','w','h','i','l','e',' ','\x02','\xa1','r','e','q','u','i','r','e','s',' ','w','r','i','t','e',' ','a','c','c','e','s','s','.',
/* 0x011e2 = "Expected the signed data content to be the object ID of SpcIndirectDataContent, found something else instead." */
    '\xb8','\x02','s','i','g','n','e','d',' ','\x9d','\xf0','\x0a','\xa7','\x02','\xa8','I','D',' ','\x15','S','p','c','I','n','d','i','r','e','c','t','D','a','t','a','C','o','n','t','e','n','t',',',' ','f','o','u','n','d',' ','s','o','m','e','t','h','i','n','g',' ','e','l','s','e',' ','i','n','s','t','e','a','d','.',
/* 0x0122a = "Indicating success single stepping and that EM should report that event to the debugger." */
    'I','n','d','i','c','a','t','i','n','g',' ','s','u','c','c','e','s','s',' ','s','i','n','g','l','e',' ','s','t','e','p','p','i','n','g',' ','\x9a','\xad','E','M',' ','s','h','o','u','l','d',' ','r','e','p','o','r','t',' ','\xad','e','v','e','n','t',' ','\x0a','\x02','d','e','b','u','g','g','e','r','.',
/* 0x01272 = "Process Verification Failure: Symantec Endpoint Protection must be disabled for the VirtualBox VM processes." */
    '\x1e','\x0d','\x12','S','y','m','a','n','t','e','c',' ','E','n','d','p','o','i','n','t',' ','P','r','o','t','e','c','t','i','o','n',' ','m','u','s','t',' ','\xa7','d','i','s','a','b','l','e','d',' ','\x10','\x02','V','i','r','t','u','a','l','B','o','x',' ','\xcd',' ','p','r','o','c','e','s','s','e','s','.',
/* 0x012ba = "The order of elements in the XAR file does not lend it self to expansion from via an I/O stream." */
    '\x03','o','r','d','e','r',' ','\x15','e','l','e','m','e','n','t','s',' ','\x0f','\x02','X','A','R',' ','\x1f','\xb2','\x08','l','e','n','d',' ','i','t',' ','s','e','l','f',' ','\x0a','e','x','p','a','n','s','i','o','n',' ','f','r','o','m',' ','v','i','a',' ','\x87','I','/','O',' ','s','t','r','e','a','m','.',
/* 0x01301 = "SMAP enabled, but the AC flag was found to be clear - check the kernel log for details." */
    'S','M','A','P',' ','e','n','a','b','l','e','d',',',' ','b','u','t',' ','\x02','A','C',' ','f','l','a','g',' ','\x11','f','o','u','n','d',' ','\x0a','\xa7','c','l','e','a','r',' ','-',' ','c','h','e','c','k',' ','\x02','k','e','r','n','e','l',' ','l','o','g',' ','\x10','d','e','t','a','i','l','s','.',
/* 0x01348 = "Patch installation refused (patch too complex or unsupported instructions )." */
    'P','a','t','c','h',' ','i','n','s','t','a','l','l','a','t','i','o','n',' ','r','e','f','u','s','e','d',' ','(','p','a','t','c','h',' ','\x9e','c','o','m','p','l','e','x',' ','\xa9','u','n','s','u','p','p','o','r','t','e','d',' ','i','n','s','t','r','u','c','t','i','o','n','s',' ',')','.',
/* 0x0138f = "The key was marked as encrypted by no DEK-Info field with the encryption algortihms was found." */
    '\x03','k','e','y',' ','\x11','m','a','r','k','e','d',' ','a','s',' ','e','n','c','r','y','p','t','e','d',' ','\xe1','n','o',' ','D','E','K','-','I','n','f','o',' ','f','i','e','l','d',' ','\x80','\x02','e','n','c','r','y','p','t','i','o','n',' ','a','l','g','o','r','t','i','h','m','s',' ','\x11','\x89',
/* 0x013d6 = "WinVerifyTrust failed with an unexpected status code when using the catalog-file approach." */
    'W','i','n','V','e','r','i','f','y','T','r','u','s','t',' ','\x99','\x80','\x87','u','n','e','x','p','e','c','t','e','d',' ','s','t','a','t','u','s',' ','c','o','d','e',' ','w','h','e','n',' ','u','s','i','n','g',' ','\x02','c','a','t','a','l','o','g','-','\x1f','a','p','p','r','o','a','c','h','.',
/* 0x0141d = "The ELF image is \'dynamic\', the ELF loader can only deal with \'relocatable\' images at present." */
    '\x03','E','L','F',' ','\x26','\x0b','\'','d','y','n','a','m','i','c','\'',',',' ','\x02','E','L','F',' ','\xd9','c','a','n',' ','o','n','l','y',' ','d','e','a','l',' ','\x80','\'','r','e','l','o','c','a','t','a','b','l','e','\'',' ','i','m','a','g','e','s',' ','a','t',' ','p','r','e','s','e','n','t','.',
/* 0x01464 = "Reserved for future status code that we wish to OR with VERR_VMX_INVALID_VMCS_PTR and VERR_VMX_INVALID_VMCS_FIELD." */
    'R','e','s','e','r','v','e','d',' ','\x10','f','u','t','u','r','e',' ','s','t','a','t','u','s',' ','c','o','d','e',' ','\xad','w','e',' ','w','i','s','h',' ','\x0a','O','R',' ','\x80','\x01','\xe2','\x05','V','M','C','S','_','P','T','R',' ','\x9a','\x01','\xe2','\x05','V','M','C','S','_','F','I','E','L','D','.',
/* 0x014aa = "Error opening the stub process thread for revalidation when vboxdrv is opened by the VM process." */
    '\xc0','o','p','e','n','i','n','g',' ','\x02','s','t','u','b',' ','\x92','t','h','r','e','a','d',' ','\x10','r','e','v','a','l','i','d','a','t','i','o','n',' ','w','h','e','n',' ','v','b','o','x','d','r','v',' ','\x0b','o','p','e','n','e','d',' ','\xe1','\x02','\xcd',' ','p','r','o','c','e','s','s','.',
/* 0x014f0 = "Failed to measure the TSC delta between two CPUs, continue without any TSC-delta." */
    '\x8b','\x0a','m','e','a','s','u','r','e',' ','\x02','T','S','C',' ','d','e','l','t','a',' ','b','e','t','w','e','e','n',' ','t','w','o',' ','C','P','U','s',',',' ','c','o','n','t','i','n','u','e',' ','w','i','t','h','o','u','t',' ','a','n','y',' ','T','S','C','-','d','e','l','t','a','.',
/* 0x01536 = "Returned by PCI config space callbacks to indicate taking default action." */
    'R','e','t','u','r','n','e','d',' ','\xe1','P','C','I',' ','c','o','n','f','i','g',' ','s','p','a','c','e',' ','c','a','l','l','b','a','c','k','s',' ','\x0a','i','n','d','i','c','a','t','e',' ','t','a','k','i','n','g',' ','d','e','f','a','u','l','t',' ','a','c','t','i','o','n','.',
/* 0x0157b = "The signature algorithm in the to-be-signed certificate part does not match the one associated with the signature." */
    '\x03','s','i','g','n','a','t','u','r','e',' ','\xd4','\x0f','\x02','t','o','-','b','e','-','s','i','g','n','e','d',' ','\xa0','p','a','r','t',' ','\xb2','\x08','m','a','t','c','h',' ','\x02','o','n','e',' ','a','s','s','o','c','i','a','t','e','d',' ','\x80','\x02','s','i','g','n','a','t','u','r','e','.',
/* 0x015c0 = "The network already exists with a different security profile (restricted / public)." */
    '\x03','n','e','t','w','o','r','k',' ','\x7f','e','x','i','s','t','s',' ','\x80','a',' ','d','i','f','f','e','r','e','n','t',' ','s','e','c','u','r','i','t','y',' ','p','r','o','f','i','l','e',' ','(','r','e','s','t','r','i','c','t','e','d',' ','/',' ','p','u','b','l','i','c',')','.',
/* 0x01605 = "The loaded XSAVE component mask is not compatible with the host CPU or/and VM config." */
    '\x03','l','o','a','d','e','d',' ','X','S','A','V','E',' ','c','o','m','p','o','n','e','n','t',' ','m','a','s','k',' ','\x0b','\x08','c','o','m','p','a','t','i','b','l','e',' ','\x80','\x02','h','o','s','t',' ','C','P','U',' ','o','r','/','a','n','d',' ','\xcd',' ','c','o','n','f','i','g','.',
/* 0x0164a = "The alignment is not really supported, however we got lucky with this allocation." */
    '\x03','a','l','i','g','n','m','e','n','t',' ','\x0b','\x08','r','e','a','l','l','y',' ','s','u','p','p','o','r','t','e','d',',',' ','h','o','w','e','v','e','r',' ','w','e',' ','g','o','t',' ','l','u','c','k','y',' ','\x80','t','h','i','s',' ','a','l','l','o','c','a','t','i','o','n','.',
/* 0x0168f = "No RTC device instance is registered with the current VM and thus the RTC or CMOS operation cannot be performed." */
    '\xdf','R','T','C',' ','\xa3','i','n','s','t','a','n','c','e',' ','\x0b','r','e','g','i','s','t','e','r','e','d',' ','\x80','\x02','c','u','r','r','e','n','t',' ','\xcd',' ','\x9a','t','h','u','s',' ','\x02','R','T','C',' ','\xa9','C','M','O','S',' ','\x96','\xd1','\xa7','p','e','r','f','o','r','m','e','d','.',
/* 0x016d4 = "The shared module clashed address wise with a previously registered module." */
    '\x03','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','c','l','a','s','h','e','d',' ','a','d','d','r','e','s','s',' ','w','i','s','e',' ','\x80','a',' ','p','r','e','v','i','o','u','s','l','y',' ','r','e','g','i','s','t','e','r','e','d',' ','m','o','d','u','l','e','.',
/* 0x01718 = "Signed data verification failed because of missing (or duplicate) authenticated message-digest attribute." */
    'S','i','g','n','e','d',' ','\x9d','\xf8','\x99','\x40','\x15','m','i','s','s','i','n','g',' ','(','o','r',' ','d','u','p','l','i','c','a','t','e',')',' ','a','u','t','h','e','n','t','i','c','a','t','e','d',' ','m','e','s','s','a','g','e','-','\xd7','a','t','t','r','i','b','u','t','e','.',
/* 0x0175c = "The I/O queue doesn't contain any prepared requests to commit or wait for completion." */
    '\x03','I','/','O',' ','q','u','e','u','e',' ','\xc7','c','o','n','t','a','i','n',' ','a','n','y',' ','p','r','e','p','a','r','e','d',' ','r','e','q','u','e','s','t','s',' ','\x0a','c','o','m','m','i','t',' ','\xa9','w','a','i','t',' ','\x10','c','o','m','p','l','e','t','i','o','n','.',
/* 0x017a0 = "Import ISO contains a multi-extent directory record that differs significantly from first record." */
    '\xc3','\xc1',' ','\x8a','a',' ','m','u','l','t','i','-','e','x','t','e','n','t',' ','\x25','r','e','c','o','r','d',' ','\xad','d','i','f','f','e','r','s',' ','s','i','g','n','i','f','i','c','a','n','t','l','y',' ','f','r','o','m',' ','f','i','r','s','t',' ','r','e','c','o','r','d','.',
/* 0x017e4 = "Remapping denied for the interrupt (might have caused a PCI target abort)." */
    'R','e','m','a','p','p','i','n','g',' ','d','e','n','i','e','d',' ','\x10','\x02','i','n','t','e','r','r','u','p','t',' ','(','m','i','g','h','t',' ','h','a','v','e',' ','c','a','u','s','e','d',' ','a',' ','P','C','I',' ','t','a','r','g','e','t',' ','a','b','o','r','t',')','.',
/* 0x01828 = "The request could not be canceled or prepared for another transfer because it is still in progress." */
    '\x03','\xaa','c','o','u','l','d',' ','\x08','\xa7','c','a','n','c','e','l','e','d',' ','\xa9','p','r','e','p','a','r','e','d',' ','\x10','a','n','o','t','h','e','r',' ','t','r','a','n','s','f','e','r',' ','\x40','i','t',' ','\x0b','s','t','i','l','l',' ','\x0f','p','r','o','g','r','e','s','s','.',
/* 0x0186c = "Status code, typically given as a parameter, that isn\'t supposed to be used." */
    'S','t','a','t','u','s',' ','c','o','d','e',',',' ','t','y','p','i','c','a','l','l','y',' ','g','i','v','e','n',' ','a','s',' ','a',' ','p','a','r','a','m','e','t','e','r',',',' ','\xad','i','s','n','\'','t',' ','s','u','p','p','o','s','e','d',' ','\x0a','\xa7','u','s','e','d','.',
/* 0x018b0 = "Signed data verification failed because of missing (or duplicate) authenticated content-type attribute." */
    'S','i','g','n','e','d',' ','\x9d','\xf8','\x99','\x40','\x15','m','i','s','s','i','n','g',' ','(','o','r',' ','d','u','p','l','i','c','a','t','e',')',' ','a','u','t','h','e','n','t','i','c','a','t','e','d',' ','c','o','n','t','e','n','t','-','\xf3','a','t','t','r','i','b','u','t','e','.',
/* 0x018f4 = "The boot catalog in the import ISO is larger than a sector or it is missing the final section header entry." */
    '\x03','b','o','o','t',' ','\xe7','\x0f','\x02','i','m','p','o','r','t',' ','\xc1',' ','\x0b','l','a','r','g','e','r',' ','t','h','a','n',' ','a',' ','s','e','c','t','o','r',' ','\xa9','i','t',' ','\x0b','m','i','s','s','i','n','g',' ','\x02','f','i','n','a','l',' ','\xdb','\xb3','e','n','t','r','y','.',
/* 0x01938 = "VFS chain element takes a directory (dir), file system stream (fss), or file system (vfs) object as input." */
    '\x8d',' ','\xa1','\x5c','t','a','k','e','s',' ','a',' ','\x25','(','d','i','r',')',',',' ','\x1f','s','y','s','t','e','m',' ','s','t','r','e','a','m',' ','(','f','s','s',')',',',' ','\xa9','\x1f','s','y','s','t','e','m',' ','(','v','f','s',')',' ','\xa8','a','s',' ','i','n','p','u','t','.',
/* 0x0197b = "VFS chain element preceding the final path needs to be a directory, file system or file system stream." */
    '\x8d',' ','\xa1','\x5c','p','r','e','c','e','d','i','n','g',' ','\x02','f','i','n','a','l',' ','\xd0','n','e','e','d','s',' ','\x0a','\xa7','a',' ','d','i','r','e','c','t','o','r','y',',',' ','\x1f','s','y','s','t','e','m',' ','\xa9','\x1f','s','y','s','t','e','m',' ','s','t','r','e','a','m','.',
/* 0x019be = "The CPUID instruction returns different information when loading than when saved." */
    '\x03','C','P','U','I','D',' ','\xda','r','e','t','u','r','n','s',' ','d','i','f','f','e','r','e','n','t',' ','i','n','f','o','r','m','a','t','i','o','n',' ','w','h','e','n',' ','l','o','a','d','i','n','g',' ','t','h','a','n',' ','w','h','e','n',' ','s','a','v','e','d','.',
/* 0x01a01 = "Halt the current I/O context until further notification from the backend." */
    'H','a','l','t',' ','\x02','c','u','r','r','e','n','t',' ','I','/','O',' ','c','o','n','t','e','x','t',' ','u','n','t','i','l',' ','f','u','r','t','h','e','r',' ','n','o','t','i','f','i','c','a','t','i','o','n',' ','f','r','o','m',' ','\x02','b','a','c','k','e','n','d','.',
/* 0x01a44 = "The I/O context couldn\'t be destroyed because there are still pending requests." */
    '\x03','I','/','O',' ','c','o','n','t','e','x','t',' ','c','o','u','l','d','n','\'','t',' ','\xa7','d','e','s','t','r','o','y','e','d',' ','\x40','t','h','e','r','e',' ','a','r','e',' ','s','t','i','l','l',' ','p','e','n','d','i','n','g',' ','r','e','q','u','e','s','t','s','.',
/* 0x01a87 = "Import ISO contains a non-final multi-extent directory record with a size that isn\'t block aligned." */
    '\xc3','\xc1',' ','\x8a','a',' ','n','o','n','-','f','i','n','a','l',' ','m','u','l','t','i','-','e','x','t','e','n','t',' ','\x25','r','e','c','o','r','d',' ','\x80','a',' ','s','i','z','e',' ','\xad','i','s','n','\'','t',' ','b','l','o','c','k',' ','a','l','i','g','n','e','d','.',
/* 0x01ac9 = "Stub process not found so it cannot be revalidated when vboxdrv is opened by the VM process." */
    'S','t','u','b',' ','\x92','\x08','f','o','u','n','d',' ','s','o',' ','i','t',' ','\xd1','\xa7','r','e','v','a','l','i','d','a','t','e','d',' ','w','h','e','n',' ','v','b','o','x','d','r','v',' ','\x0b','o','p','e','n','e','d',' ','\xe1','\x02','\xcd',' ','p','r','o','c','e','s','s','.',
/* 0x01b0b = "VMRUN emulation succeeded, ready to immediately enter the nested-guest." */
    'V','M','R','U','N',' ','e','m','u','l','a','t','i','o','n',' ','s','u','c','c','e','e','d','e','d',',',' ','r','e','a','d','y',' ','\x0a','i','m','m','e','d','i','a','t','e','l','y',' ','e','n','t','e','r',' ','\x02','n','e','s','t','e','d','-','g','u','e','s','t','.',
/* 0x01b4d = "There shall be exactly one digest algorithm to go with the single SingerInfo entry required by SPC." */
    'T','h','e','r','e',' ','s','h','a','l','l',' ','\xa7','e','x','a','c','t','l','y',' ','o','n','e',' ','\xd7','\xd4','\x0a','g','o',' ','\x80','\x02','s','i','n','g','l','e',' ','S','i','n','g','e','r','I','n','f','o',' ','\xc8','r','e','q','u','i','r','e','d',' ','\xe1','S','P','C','.',
/* 0x01b8f = "Conflict between the core memory and the intermediate paging context, try again." */
    'C','o','n','f','l','i','c','t',' ','b','e','t','w','e','e','n',' ','\x02','c','o','r','e',' ','\x86','\x9a','\x02','i','n','t','e','r','m','e','d','i','a','t','e',' ','p','a','g','i','n','g',' ','c','o','n','t','e','x','t',',',' ','t','r','y',' ','a','g','a','i','n','.',
/* 0x01bd0 = "There are not enough events available on the host to create the I/O context." */
    'T','h','e','r','e',' ','a','r','e',' ','\x08','e','n','o','u','g','h',' ','e','v','e','n','t','s',' ','a','v','a','i','l','a','b','l','e',' ','o','n',' ','\x02','h','o','s','t',' ','\x0a','c','r','e','a','t','e',' ','\x02','I','/','O',' ','c','o','n','t','e','x','t','.',
/* 0x01c11 = "The requests couldn\'t be submitted because that would exceed the capacity of the context." */
    '\x03','r','e','q','u','e','s','t','s',' ','c','o','u','l','d','n','\'','t',' ','\xa7','s','u','b','m','i','t','t','e','d',' ','\x40','\xad','w','o','u','l','d',' ','e','x','c','e','e','d',' ','\x02','c','a','p','a','c','i','t','y',' ','\x15','\x02','c','o','n','t','e','x','t','.',
/* 0x01c52 = "No APIC device instance is registered with the current VM and thus the APIC operation cannot be performed." */
    '\xdf','A','P','I','C',' ','\xa3','i','n','s','t','a','n','c','e',' ','\x0b','r','e','g','i','s','t','e','r','e','d',' ','\x80','\x02','c','u','r','r','e','n','t',' ','\xcd',' ','\x9a','t','h','u','s',' ','\x02','A','P','I','C',' ','\x96','\xd1','\xa7','p','e','r','f','o','r','m','e','d','.',
/* 0x01c93 = "The PCI device isn\'t configured as a busmaster, physical memory access rejected." */
    '\x03','P','C','I',' ','\xa3','i','s','n','\'','t',' ','c','o','n','f','i','g','u','r','e','d',' ','a','s',' ','a',' ','b','u','s','m','a','s','t','e','r',',',' ','p','h','y','s','i','c','a','l',' ','\x86','a','c','c','e','s','s',' ','r','e','j','e','c','t','e','d','.',
/* 0x01cd4 = "The halt action was requested, but the OS may actually power off the machine." */
    '\x03','h','a','l','t',' ','a','c','t','i','o','n',' ','\x11','r','e','q','u','e','s','t','e','d',',',' ','b','u','t',' ','\x02','O','S',' ','m','a','y',' ','a','c','t','u','a','l','l','y',' ','p','o','w','e','r',' ','o','f','f',' ','\x02','m','a','c','h','i','n','e','.',
/* 0x01d15 = "Failed to set the TLS (thread local storage) entry which points to our thread structure." */
    '\x8b','\x0a','s','e','t',' ','\x02','T','L','S',' ','(','t','h','r','e','a','d',' ','l','o','c','a','l',' ','s','t','o','r','a','g','e',')',' ','\xc8','\xed','p','o','i','n','t','s',' ','\x0a','o','u','r',' ','t','h','r','e','a','d',' ','s','t','r','u','c','t','u','r','e','.',
/* 0x01d56 = "Too many write or write/read recursions on read/write critical section." */
    'T','o','o',' ','\xb4','w','r','i','t','e',' ','\xa9','w','r','i','t','e','/','r','e','a','d',' ','r','e','c','u','r','s','i','o','n','s',' ','o','n',' ','r','e','a','d','/','w','r','i','t','e',' ','c','r','i','t','i','c','a','l',' ','s','e','c','t','i','o','n','.',
/* 0x01d97 = "Invalid/unsupported nested hardware virtualization configuration." */
    'I','n','v','a','l','i','d','/','u','n','s','u','p','p','o','r','t','e','d',' ','n','e','s','t','e','d',' ','h','a','r','d','w','a','r','e',' ','v','i','r','t','u','a','l','i','z','a','t','i','o','n',' ','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x01dd8 = "The file is too big for the current ISO level (4GB+ sized files requires ISO level 3)." */
    '\x03','\x1f','\x0b','\x9e','b','i','g',' ','\x10','\x02','c','u','r','r','e','n','t',' ','\xc1',' ','l','e','v','e','l',' ','(','4','G','B','+',' ','s','i','z','e','d',' ','f','i','l','e','s',' ','r','e','q','u','i','r','e','s',' ','\xc1',' ','l','e','v','e','l',' ','3',')','.',
/* 0x01e18 = "Import ISO has different volume space sizes of primary and supplementary volume descriptors." */
    '\xc3','\xc1',' ','\x5e','d','i','f','f','e','r','e','n','t',' ','\xd2','s','p','a','c','e',' ','s','i','z','e','s',' ','\x15','p','r','i','m','a','r','y',' ','\x9a','s','u','p','p','l','e','m','e','n','t','a','r','y',' ','\xd2','d','e','s','c','r','i','p','t','o','r','s','.',
/* 0x01e58 = "The below driver doesn't export a interface required by the drive having attached it." */
    '\x03','b','e','l','o','w',' ','\xc5','\xc7','e','x','p','o','r','t',' ','a',' ','i','n','t','e','r','f','a','c','e',' ','r','e','q','u','i','r','e','d',' ','\xe1','\x02','d','r','i','v','e',' ','h','a','v','i','n','g',' ','a','t','t','a','c','h','e','d',' ','i','t','.',
/* 0x01e98 = "The \'Translation\' attribute in the DrvBlock configuration had an unknown value." */
    '\x03','\'','T','r','a','n','s','l','a','t','i','o','n','\'',' ','a','t','t','r','i','b','u','t','e',' ','\x0f','\x02','D','r','v','B','l','o','c','k',' ','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','h','a','d',' ','\x87','u','n','k','n','o','w','n',' ','\xe8',
/* 0x01ed8 = "Attempt to register a RAM range of which parts are already covered by existing RAM ranges." */
    'A','t','t','e','m','p','t',' ','\x0a','\xeb','a',' ','R','A','M',' ','r','a','n','g','e',' ','\x15','\xed','p','a','r','t','s',' ','a','r','e',' ','\x7f','c','o','v','e','r','e','d',' ','\xe1','e','x','i','s','t','i','n','g',' ','R','A','M',' ','r','a','n','g','e','s','.',
/* 0x01f18 = "The tar termination records was encountered without reaching the end of the input stream." */
    '\x03','t','a','r',' ','t','e','r','m','i','n','a','t','i','o','n',' ','r','e','c','o','r','d','s',' ','\x11','\xaf','w','i','t','h','o','u','t',' ','r','e','a','c','h','i','n','g',' ','\x02','e','n','d',' ','\x15','\x02','i','n','p','u','t',' ','s','t','r','e','a','m','.',
/* 0x01f58 = "No DMAC device instance is registered with the current VM and thus the DMA operation cannot be performed." */
    '\xdf','D','M','A','C',' ','\xa3','i','n','s','t','a','n','c','e',' ','\x0b','r','e','g','i','s','t','e','r','e','d',' ','\x80','\x02','c','u','r','r','e','n','t',' ','\xcd',' ','\x9a','t','h','u','s',' ','\x02','D','M','A',' ','\x96','\xd1','\xa7','p','e','r','f','o','r','m','e','d','.',
/* 0x01f98 = "The function called requires the caller to be attached as a debugger to the VM." */
    '\x03','f','u','n','c','t','i','o','n',' ','c','a','l','l','e','d',' ','r','e','q','u','i','r','e','s',' ','\x02','c','a','l','l','e','r',' ','\x0a','\xa7','a','t','t','a','c','h','e','d',' ','a','s',' ','a',' ','d','e','b','u','g','g','e','r',' ','\x0a','\x02','V','M','.',
/* 0x01fd8 = "Indicating that the VM has been reset and that scheduling goes back to startup defaults." */
    'I','n','d','i','c','a','t','i','n','g',' ','\xad','\x02','\xcd',' ','\x5e','\xcb','r','e','s','e','t',' ','\x9a','\xad','s','c','h','e','d','u','l','i','n','g',' ','g','o','e','s',' ','b','a','c','k',' ','\x0a','s','t','a','r','t','u','p',' ','d','e','f','a','u','l','t','s','.',
/* 0x02018 = "Got back from vmmR0CallRing3SetJmp with the context hook still enabled." */
    'G','o','t',' ','b','a','c','k',' ','f','r','o','m',' ','v','m','m','R','0','C','a','l','l','R','i','n','g','3','S','e','t','J','m','p',' ','\x80','\x02','c','o','n','t','e','x','t',' ','h','o','o','k',' ','s','t','i','l','l',' ','e','n','a','b','l','e','d','.',
/* 0x02058 = "No PIC device instance is registered with the current VM and thus the PIC operation cannot be performed." */
    '\xdf','P','I','C',' ','\xa3','i','n','s','t','a','n','c','e',' ','\x0b','r','e','g','i','s','t','e','r','e','d',' ','\x80','\x02','c','u','r','r','e','n','t',' ','\xcd',' ','\x9a','t','h','u','s',' ','\x02','P','I','C',' ','\x96','\xd1','\xa7','p','e','r','f','o','r','m','e','d','.',
/* 0x02097 = "A timeout occurred while waiting for async IDE operations to finish." */
    'A',' ','t','i','m','e','o','u','t',' ','o','c','c','u','r','r','e','d',' ','w','h','i','l','e',' ','w','a','i','t','i','n','g',' ','\x10','a','s','y','n','c',' ','I','D','E',' ','o','p','e','r','a','t','i','o','n','s',' ','\x0a','f','i','n','i','s','h','.',
/* 0x020d6 = "Error opening the stub process for revalidation when vboxdrv is opened by the VM process." */
    '\xc0','o','p','e','n','i','n','g',' ','\x02','s','t','u','b',' ','\x92','\x10','r','e','v','a','l','i','d','a','t','i','o','n',' ','w','h','e','n',' ','v','b','o','x','d','r','v',' ','\x0b','o','p','e','n','e','d',' ','\xe1','\x02','\xcd',' ','p','r','o','c','e','s','s','.',
/* 0x02115 = "Attempt to register an access handler for a physical range of which a part was already handled." */
    'A','t','t','e','m','p','t',' ','\x0a','\xeb','\x87','a','c','c','e','s','s',' ','h','a','n','d','l','e','r',' ','\x10','a',' ','p','h','y','s','i','c','a','l',' ','r','a','n','g','e',' ','\x15','\xed','a',' ','p','a','r','t',' ','\x11','\x7f','h','a','n','d','l','e','d','.',
/* 0x02154 = "Trying to read a 64-bit guest physical address into a 32-bit variable." */
    'T','r','y','i','n','g',' ','\x0a','r','e','a','d',' ','a',' ','6','4','-','b','i','t',' ','\xbb','p','h','y','s','i','c','a','l',' ','a','d','d','r','e','s','s',' ','i','n','t','o',' ','a',' ','3','2','-','b','i','t',' ','v','a','r','i','a','b','l','e','.',
/* 0x02193 = "Got an out of memory condition trying to allocate a UTF-16 (/UCS-2) string." */
    'G','o','t',' ','\x87','o','u','t',' ','\x15','\x86','c','o','n','d','i','t','i','o','n',' ','t','r','y','i','n','g',' ','\x0a','a','l','l','o','c','a','t','e',' ','a',' ','U','T','F','-','1','6',' ','(','/','U','C','S','-','2',')',' ','s','t','r','i','n','g','.',
/* 0x021d2 = "Sensitive input requires the result(s) to be initialized as sensitive." */
    'S','e','n','s','i','t','i','v','e',' ','i','n','p','u','t',' ','r','e','q','u','i','r','e','s',' ','\x02','r','e','s','u','l','t','(','s',')',' ','\x0a','\xa7','i','n','i','t','i','a','l','i','z','e','d',' ','a','s',' ','s','e','n','s','i','t','i','v','e','.',
/* 0x02211 = "The intercepted situation was completely handled, continue execution." */
    '\x03','i','n','t','e','r','c','e','p','t','e','d',' ','s','i','t','u','a','t','i','o','n',' ','\x11','c','o','m','p','l','e','t','e','l','y',' ','h','a','n','d','l','e','d',',',' ','c','o','n','t','i','n','u','e',' ','e','x','e','c','u','t','i','o','n','.',
/* 0x02250 = "The digest algorithm in the indirect data was not found in the list of digest algorithms in the signed data structure." */
    '\x03','\xd7','\xd4','\x0f','\x02','i','n','d','i','r','e','c','t',' ','\x9d','\x11','\x08','f','o','u','n','d',' ','\x0f','\x02','l','i','s','t',' ','\x15','\xd7','a','l','g','o','r','i','t','h','m','s',' ','\x0f','\x02','s','i','g','n','e','d',' ','\x9d','s','t','r','u','c','t','u','r','e','.',
/* 0x0228f = "CPU was incorrectly left in VMX root mode; incompatible with VirtualBox." */
    'C','P','U',' ','\x11','i','n','c','o','r','r','e','c','t','l','y',' ','l','e','f','t',' ','\x0f','V','M','X',' ','r','o','o','t',' ','m','o','d','e',';',' ','i','n','c','o','m','p','a','t','i','b','l','e',' ','\x80','V','i','r','t','u','a','l','B','o','x','.',
/* 0x022ce = "Bogus allocation descriptor length field value in an allocation extent descriptor." */
    'B','o','g','u','s',' ','a','l','l','o','c','a','t','i','o','n',' ','\xe3','l','e','n','g','t','h',' ','f','i','e','l','d',' ','\xf5','\x0f','\x87','a','l','l','o','c','a','t','i','o','n',' ','e','x','t','e','n','t',' ','d','e','s','c','r','i','p','t','o','r','.',
/* 0x0230d = "A boot catalog extension entry in the import ISO uses undefined flags which will be lost." */
    'A',' ','b','o','o','t',' ','\xe7','e','x','t','e','n','s','i','o','n',' ','\xc8','\x0f','\x02','i','m','p','o','r','t',' ','\xc1',' ','u','s','e','s',' ','u','n','d','e','f','i','n','e','d',' ','f','l','a','g','s',' ','\xed','w','i','l','l',' ','\xa7','l','o','s','t','.',
/* 0x0234c = "Attempt to register an access handler for a virtual range of which a part was already handled." */
    'A','t','t','e','m','p','t',' ','\x0a','\xeb','\x87','a','c','c','e','s','s',' ','h','a','n','d','l','e','r',' ','\x10','a',' ','v','i','r','t','u','a','l',' ','r','a','n','g','e',' ','\x15','\xed','a',' ','p','a','r','t',' ','\x11','\x7f','h','a','n','d','l','e','d','.',
/* 0x0238a = "The PE loader encountered a lock prefix table, a feature which hasn\'t been implemented yet." */
    '\x03','P','E',' ','\xd9','\xaf','a',' ','l','o','c','k',' ','p','r','e','f','i','x',' ','t','a','b','l','e',',',' ','a',' ','f','e','a','t','u','r','e',' ','\xed','h','a','s','n','\'','t',' ','\xcb','i','m','p','l','e','m','e','n','t','e','d',' ','y','e','t','.',
/* 0x023c8 = "VFS chain element only provides a read-only I/O stream, while the chain read access." */
    '\x8d',' ','\xa1','\x5c','o','n','l','y',' ','p','r','o','v','i','d','e','s',' ','a',' ','r','e','a','d','-','o','n','l','y',' ','I','/','O',' ','s','t','r','e','a','m',',',' ','w','h','i','l','e',' ','\x02','\xa1','r','e','a','d',' ','a','c','c','e','s','s','.',
/* 0x02406 = "A PGM function was called in a mode where it isn\'t supposed to be used." */
    'A',' ','P','G','M',' ','f','u','n','c','t','i','o','n',' ','\x11','c','a','l','l','e','d',' ','\x0f','a',' ','m','o','d','e',' ','w','h','e','r','e',' ','i','t',' ','i','s','n','\'','t',' ','s','u','p','p','o','s','e','d',' ','\x0a','\xa7','u','s','e','d','.',
/* 0x02444 = "Process Verification Failure: There is more than one known executable mapped into the process." */
    '\x1e','\x0d','\x12','T','h','e','r','e',' ','\x0b','m','o','r','e',' ','t','h','a','n',' ','o','n','e',' ','k','n','o','w','n',' ','e','x','e','c','u','t','a','b','l','e',' ','m','a','p','p','e','d',' ','i','n','t','o',' ','\x02','p','r','o','c','e','s','s','.',
/* 0x02482 = "The combined minor and major device number type is too small to hold the value stored in the tar header." */
    '\x03','c','o','m','b','i','n','e','d',' ','m','i','n','o','r',' ','\x9a','m','a','j','o','r',' ','\xa3','\xfb','\xf3','\x0b','\x9e','s','m','a','l','l',' ','\x0a','h','o','l','d',' ','\x02','\xf5','s','t','o','r','e','d',' ','\x0f','\x02','t','a','r',' ','h','e','a','d','e','r','.',
/* 0x024c0 = "A number tar header field yielded a value too large for the internal variable of the tar interpreter." */
    'A',' ','\xfb','t','a','r',' ','\xb3','f','i','e','l','d',' ','y','i','e','l','d','e','d',' ','a',' ','\xf5','\x9e','l','a','r','g','e',' ','\x10','\x02','\x16','v','a','r','i','a','b','l','e',' ','\x15','\x02','t','a','r',' ','i','n','t','e','r','p','r','e','t','e','r','.',
/* 0x024fe = "Nested ownership requests are not permitted for this semaphore type." */
    'N','e','s','t','e','d',' ','o','w','n','e','r','s','h','i','p',' ','r','e','q','u','e','s','t','s',' ','a','r','e',' ','\x08','p','e','r','m','i','t','t','e','d',' ','\x10','t','h','i','s',' ','s','e','m','a','p','h','o','r','e',' ','t','y','p','e','.',
/* 0x0253c = "Import ISO has different volume set sizes of primary and supplementary volume descriptors." */
    '\xc3','\xc1',' ','\x5e','d','i','f','f','e','r','e','n','t',' ','\xd2','s','e','t',' ','s','i','z','e','s',' ','\x15','p','r','i','m','a','r','y',' ','\x9a','s','u','p','p','l','e','m','e','n','t','a','r','y',' ','\xd2','d','e','s','c','r','i','p','t','o','r','s','.',
/* 0x0257a = "Trying to read a 64-bit guest virtual address into a 32-bit variable." */
    'T','r','y','i','n','g',' ','\x0a','r','e','a','d',' ','a',' ','6','4','-','b','i','t',' ','\xbb','v','i','r','t','u','a','l',' ','a','d','d','r','e','s','s',' ','i','n','t','o',' ','a',' ','3','2','-','b','i','t',' ','v','a','r','i','a','b','l','e','.',
/* 0x025b8 = "A restore routine attempted to load more data then the unit contained." */
    'A',' ','r','e','s','t','o','r','e',' ','r','o','u','t','i','n','e',' ','a','t','t','e','m','p','t','e','d',' ','\x0a','l','o','a','d',' ','m','o','r','e',' ','\x9d','t','h','e','n',' ','\x02','u','n','i','t',' ','c','o','n','t','a','i','n','e','d','.',
/* 0x025f5 = "A boot catalog entry in the import ISO points to a block after the end of the image input file." */
    'A',' ','b','o','o','t',' ','\xe7','\xc8','\x0f','\x02','i','m','p','o','r','t',' ','\xc1',' ','p','o','i','n','t','s',' ','\x0a','a',' ','b','l','o','c','k',' ','a','f','t','e','r',' ','\x02','e','n','d',' ','\x15','\x02','\x26','i','n','p','u','t',' ','f','i','l','e','.',
/* 0x02632 = "The table of content XML element (toc) has siblings, we expected it to be an only child or the root element (xar)." */
    '\x03','\xb1','\x15','\xf0','X','M','L',' ','\x5c','(','t','o','c',')',' ','\x5e','s','i','b','l','i','n','g','s',',',' ','w','e',' ','\xc9','i','t',' ','\x0a','\xa7','\x87','o','n','l','y',' ','c','h','i','l','d',' ','\xa9','\x02','r','o','o','t',' ','\x5c','(','x','a','r',')','.',
/* 0x0266f = "The specified R0 or RC I/O port range didn\'t have a corresponding R3 range." */
    '\x03','\x18','R','0',' ','\xa9','R','C',' ','I','/','O',' ','p','o','r','t',' ','r','a','n','g','e',' ','d','i','d','n','\'','t',' ','h','a','v','e',' ','a',' ','c','o','r','r','e','s','p','o','n','d','i','n','g',' ','R','3',' ','r','a','n','g','e','.',
/* 0x026ac = "The digest algorithm of a signer info entry was not found in the list of digest algorithms in the signed data." */
    '\x03','\xd7','\xd4','\x15','a',' ','s','i','g','n','e','r',' ','i','n','f','o',' ','\xc8','\x11','\x08','f','o','u','n','d',' ','\x0f','\x02','l','i','s','t',' ','\x15','\xd7','a','l','g','o','r','i','t','h','m','s',' ','\x0f','\x02','s','i','g','n','e','d',' ','d','a','t','a','.',
/* 0x026e9 = "Giving up a live snapshot/teleportation attempt because the state grew to big." */
    'G','i','v','i','n','g',' ','u','p',' ','a',' ','l','i','v','e',' ','s','n','a','p','s','h','o','t','/','t','e','l','e','p','o','r','t','a','t','i','o','n',' ','a','t','t','e','m','p','t',' ','\x40','\x02','\xca','g','r','e','w',' ','\x0a','b','i','g','.',
/* 0x02726 = "The I/O port range specified for removal wasn\'t found or it wasn\'t contiguous." */
    '\x03','I','/','O',' ','p','o','r','t',' ','r','a','n','g','e',' ','\x18','\x10','r','e','m','o','v','a','l',' ','w','a','s','n','\'','t',' ','f','o','u','n','d',' ','\xa9','i','t',' ','w','a','s','n','\'','t',' ','c','o','n','t','i','g','u','o','u','s','.',
/* 0x02763 = "Got into a part of SELM that is not used when HM (VT-x/AMD-V) is enabled." */
    'G','o','t',' ','i','n','t','o',' ','a',' ','p','a','r','t',' ','\x15','S','E','L','M',' ','\xad','\x0b','\x08','u','s','e','d',' ','w','h','e','n',' ','H','M',' ','(','V','T','-','x','/','A','M','D','-','V',')',' ','\x0b','e','n','a','b','l','e','d','.',
/* 0x0279f = "The status field has not been updated yet as the request is still pending completion." */
    '\x03','s','t','a','t','u','s',' ','f','i','e','l','d',' ','\x5e','\x08','\xcb','u','p','d','a','t','e','d',' ','y','e','t',' ','a','s',' ','\x02','\xaa','\x0b','s','t','i','l','l',' ','p','e','n','d','i','n','g',' ','c','o','m','p','l','e','t','i','o','n','.',
/* 0x027db = "Can\'t finalize the node as the FDT cursor is at the root level already." */
    'C','a','n','\'','t',' ','f','i','n','a','l','i','z','e',' ','\x02','n','o','d','e',' ','a','s',' ','\x02','F','D','T',' ','c','u','r','s','o','r',' ','\x0b','a','t',' ','\x02','r','o','o','t',' ','l','e','v','e','l',' ','a','l','r','e','a','d','y','.',
/* 0x02817 = "Expected the archived and extracted XAR data sizes to be the same for uncompressed data." */
    '\xb8','\x02','a','r','c','h','i','v','e','d',' ','\x9a','e','x','t','r','a','c','t','e','d',' ','X','A','R',' ','\x9d','s','i','z','e','s',' ','\x0a','\xa7','\x02','s','a','m','e',' ','\x10','u','n','c','o','m','p','r','e','s','s','e','d',' ','d','a','t','a','.',
/* 0x02853 = "Failed to add new mappings because the current mappings are fixed in guest os memory." */
    '\x8b','\x0a','a','d','d',' ','n','e','w',' ','m','a','p','p','i','n','g','s',' ','\x40','\x02','c','u','r','r','e','n','t',' ','m','a','p','p','i','n','g','s',' ','a','r','e',' ','f','i','x','e','d',' ','\x0f','\xbb','o','s',' ','m','e','m','o','r','y','.',
/* 0x0288f = "Trick for resuming EMHistoryExec after a VMCPU_FF_IOM is handled." */
    'T','r','i','c','k',' ','\x10','r','e','s','u','m','i','n','g',' ','E','M','H','i','s','t','o','r','y','E','x','e','c',' ','a','f','t','e','r',' ','a',' ','V','M','C','P','U','_','F','F','_','I','O','M',' ','\x0b','h','a','n','d','l','e','d','.',
/* 0x028cb = "Got into a part of TRPM that is not used when HM (VT-x/AMD-V) is enabled." */
    'G','o','t',' ','i','n','t','o',' ','a',' ','p','a','r','t',' ','\x15','T','R','P','M',' ','\xad','\x0b','\x08','u','s','e','d',' ','w','h','e','n',' ','H','M',' ','(','V','T','-','x','/','A','M','D','-','V',')',' ','\x0b','e','n','a','b','l','e','d','.',
/* 0x02907 = "The above driver doesn't export a interface required by a driver being attached to it." */
    '\x03','a','b','o','v','e',' ','\xc5','\xc7','e','x','p','o','r','t',' ','a',' ','i','n','t','e','r','f','a','c','e',' ','r','e','q','u','i','r','e','d',' ','\xe1','a',' ','\xc5','b','e','i','n','g',' ','a','t','t','a','c','h','e','d',' ','\x0a','i','t','.',
/* 0x02943 = "Out of memory condition when allocating physical memory (without mapping)." */
    'O','u','t',' ','\x15','\x86','c','o','n','d','i','t','i','o','n',' ','w','h','e','n',' ','a','l','l','o','c','a','t','i','n','g',' ','p','h','y','s','i','c','a','l',' ','\x86','(','w','i','t','h','o','u','t',' ','m','a','p','p','i','n','g',')','.',
/* 0x0297f = "The timer was stuck in an unstable state until we grew impatient and returned." */
    '\x03','t','i','m','e','r',' ','\x11','s','t','u','c','k',' ','\x0f','\x87','u','n','s','t','a','b','l','e',' ','\xca','u','n','t','i','l',' ','w','e',' ','g','r','e','w',' ','i','m','p','a','t','i','e','n','t',' ','\x9a','r','e','t','u','r','n','e','d','.',
/* 0x029bb = "Missing UTF-8 continutation in escaped URI character sequence." */
    'M','i','s','s','i','n','g',' ','U','T','F','-','8',' ','c','o','n','t','i','n','u','t','a','t','i','o','n',' ','\x0f','e','s','c','a','p','e','d',' ','U','R','I',' ','c','h','a','r','a','c','t','e','r',' ','s','e','q','u','e','n','c','e','.',
/* 0x029f7 = "Differencing and parent images can\'t be used together due to UUID." */
    'D','i','f','f','e','r','e','n','c','i','n','g',' ','\x9a','p','a','r','e','n','t',' ','i','m','a','g','e','s',' ','c','a','n','\'','t',' ','\xa7','u','s','e','d',' ','t','o','g','e','t','h','e','r',' ','d','u','e',' ','\x0a','U','U','I','D','.',
/* 0x02a32 = "Multiple primary volume descriptors found, we can only deal with one." */
    'M','u','l','t','i','p','l','e',' ','p','r','i','m','a','r','y',' ','\xd2','d','e','s','c','r','i','p','t','o','r','s',' ','f','o','u','n','d',',',' ','w','e',' ','c','a','n',' ','o','n','l','y',' ','d','e','a','l',' ','\x80','o','n','e','.',
/* 0x02a6d = "Got into a part of PDM that is not used when HM (VT-x/AMD-V) is enabled." */
    'G','o','t',' ','i','n','t','o',' ','a',' ','p','a','r','t',' ','\x15','P','D','M',' ','\xad','\x0b','\x08','u','s','e','d',' ','w','h','e','n',' ','H','M',' ','(','V','T','-','x','/','A','M','D','-','V',')',' ','\x0b','e','n','a','b','l','e','d','.',
/* 0x02aa8 = "Multiple logical volume descriptors found, we can only deal with one." */
    'M','u','l','t','i','p','l','e',' ','l','o','g','i','c','a','l',' ','\xd2','d','e','s','c','r','i','p','t','o','r','s',' ','f','o','u','n','d',',',' ','w','e',' ','c','a','n',' ','o','n','l','y',' ','d','e','a','l',' ','\x80','o','n','e','.',
/* 0x02ae3 = "Cannot add symbolic link to namespace which isn\'t configured to support it." */
    'C','a','n','n','o','t',' ','a','d','d',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k',' ','\x0a','n','a','m','e','s','p','a','c','e',' ','\xed','i','s','n','\'','t',' ','c','o','n','f','i','g','u','r','e','d',' ','\x0a','\xce','i','t','.',
/* 0x02b1e = "Giving up a live snapshot attempt because we\'re low on disk space." */
    'G','i','v','i','n','g',' ','u','p',' ','a',' ','l','i','v','e',' ','s','n','a','p','s','h','o','t',' ','a','t','t','e','m','p','t',' ','\x40','w','e','\'','r','e',' ','l','o','w',' ','o','n',' ','d','i','s','k',' ','s','p','a','c','e','.',
/* 0x02b59 = "Got into a part of IOM that is not used when HM (VT-x/AMD-V) is enabled." */
    'G','o','t',' ','i','n','t','o',' ','a',' ','p','a','r','t',' ','\x15','I','O','M',' ','\xad','\x0b','\x08','u','s','e','d',' ','w','h','e','n',' ','H','M',' ','(','V','T','-','x','/','A','M','D','-','V',')',' ','\x0b','e','n','a','b','l','e','d','.',
/* 0x02b94 = "Failed to enable VMXON-in-SMX bit while enabling VT-x through the MSR." */
    '\x8b','\x0a','e','n','a','b','l','e',' ','V','M','X','O','N','-','i','n','-','S','M','X',' ','b','i','t',' ','w','h','i','l','e',' ','e','n','a','b','l','i','n','g',' ','V','T','-','x',' ','t','h','r','o','u','g','h',' ','\x02','M','S','R','.',
/* 0x02bcf = "Async I/O task is pending, a completion handler will be called." */
    'A','s','y','n','c',' ','I','/','O',' ','t','a','s','k',' ','\x0b','p','e','n','d','i','n','g',',',' ','a',' ','c','o','m','p','l','e','t','i','o','n',' ','h','a','n','d','l','e','r',' ','w','i','l','l',' ','\xa7','c','a','l','l','e','d','.',
/* 0x02c0a = "The live snapshot/teleportation operation was aborted because of a guru meditation." */
    '\x03','l','i','v','e',' ','s','n','a','p','s','h','o','t','/','t','e','l','e','p','o','r','t','a','t','i','o','n',' ','\x96','\x11','a','b','o','r','t','e','d',' ','\x40','\x15','a',' ','g','u','r','u',' ','m','e','d','i','t','a','t','i','o','n','.',
/* 0x02c45 = "Process Verification Failure: The DllCharacteristics of the process does not match the value in the optional header in the exe file." */
    '\x1e','\x0d','\x12','\x03','D','l','l','C','h','a','r','a','c','t','e','r','i','s','t','i','c','s',' ','\x15','\x02','\x92','\xb2','\x08','m','a','t','c','h',' ','\x02','\xf5','\x0f','\x02','o','p','t','i','o','n','a','l',' ','\xb3','\x0f','\x02','e','x','e',' ','f','i','l','e','.',
/* 0x02c80 = "The driver properties were invalid, and as a consequence construction failed." */
    '\x03','\xc5','p','r','o','p','e','r','t','i','e','s',' ','w','e','r','e',' ','i','n','v','a','l','i','d',',',' ','\x9a','a','s',' ','a',' ','c','o','n','s','e','q','u','e','n','c','e',' ','c','o','n','s','t','r','u','c','t','i','o','n',' ','\x7b',
/* 0x02cbb = "Attempt to create a GC mapping which conflicts with an existing mapping." */
    'A','t','t','e','m','p','t',' ','\x0a','c','r','e','a','t','e',' ','a',' ','G','C',' ','m','a','p','p','i','n','g',' ','\xed','c','o','n','f','l','i','c','t','s',' ','\x80','\x87','e','x','i','s','t','i','n','g',' ','m','a','p','p','i','n','g','.',
/* 0x02cf6 = "The requested nested-guest SVM intercept is not active or not in nested-guest execution mode." */
    '\x03','\xde','n','e','s','t','e','d','-','\xbb','S','V','M',' ','i','n','t','e','r','c','e','p','t',' ','\x0b','\x08','a','c','t','i','v','e',' ','\xa9','\x08','\x0f','n','e','s','t','e','d','-','\xbb','e','x','e','c','u','t','i','o','n',' ','m','o','d','e','.',
/* 0x02d31 = "The requested nested-guest VMX intercept is not active or not in nested-guest execution mode." */
    '\x03','\xde','n','e','s','t','e','d','-','\xbb','V','M','X',' ','i','n','t','e','r','c','e','p','t',' ','\x0b','\x08','a','c','t','i','v','e',' ','\xa9','\x08','\x0f','n','e','s','t','e','d','-','\xbb','e','x','e','c','u','t','i','o','n',' ','m','o','d','e','.',
/* 0x02d6c = "Giving up a live snapshot/teleportation attempt because of too many passes." */
    'G','i','v','i','n','g',' ','u','p',' ','a',' ','l','i','v','e',' ','s','n','a','p','s','h','o','t','/','t','e','l','e','p','o','r','t','a','t','i','o','n',' ','a','t','t','e','m','p','t',' ','\x40','\x15','\x9e','\xb4','p','a','s','s','e','s','.',
/* 0x02da7 = "Maximum number of Shared Clipboard events for an event source has been reached." */
    'M','a','x','i','m','u','m',' ','\xfb','\x15','S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','e','v','e','n','t','s',' ','\x10','\x87','e','v','e','n','t',' ','s','o','u','r','c','e',' ','\x5e','\xcb','r','e','a','c','h','e','d','.',
/* 0x02de2 = "Unable to translate one or more of the arguments to the codeset the child process is expected to use." */
    '\xe0','\x0a','t','r','a','n','s','l','a','t','e',' ','o','n','e',' ','\xa9','m','o','r','e',' ','\x15','\x02','a','r','g','u','m','e','n','t','s',' ','\x0a','\x02','c','o','d','e','s','e','t',' ','\x02','c','h','i','l','d',' ','\x92','\x0b','\xc9','\x0a','u','s','e','.',
/* 0x02e1d = "Import ISO contains a non-contigiuous multi-extent data, this is currently not supported." */
    '\xc3','\xc1',' ','\x8a','a',' ','n','o','n','-','c','o','n','t','i','g','i','u','o','u','s',' ','m','u','l','t','i','-','e','x','t','e','n','t',' ','d','a','t','a',',',' ','t','h','i','s',' ','\x0b','c','u','r','r','e','n','t','l','y',' ','\x08','\xa4',
/* 0x02e58 = "The VM was suspended before or while saving, don\'t resume execution." */
    '\x03','\xcd',' ','\x11','s','u','s','p','e','n','d','e','d',' ','b','e','f','o','r','e',' ','\xa9','w','h','i','l','e',' ','s','a','v','i','n','g',',',' ','d','o','n','\'','t',' ','r','e','s','u','m','e',' ','e','x','e','c','u','t','i','o','n','.',
/* 0x02e93 = "The probe location array isn\'t adjacent to the probe enable array." */
    '\x03','p','r','o','b','e',' ','l','o','c','a','t','i','o','n',' ','a','r','r','a','y',' ','i','s','n','\'','t',' ','a','d','j','a','c','e','n','t',' ','\x0a','\x02','p','r','o','b','e',' ','e','n','a','b','l','e',' ','a','r','r','a','y','.',
/* 0x02ecd = "VFS chain element only provides file, I/O stream (ios), or directory (dir) objects." */
    '\x8d',' ','\xa1','\x5c','o','n','l','y',' ','p','r','o','v','i','d','e','s',' ','f','i','l','e',',',' ','I','/','O',' ','s','t','r','e','a','m',' ','(','i','o','s',')',',',' ','\xa9','\x25','(','d','i','r',')',' ','o','b','j','e','c','t','s','.',
/* 0x02f07 = "The live snapshot/teleportation operation was aborted because of a fatal runtime error." */
    '\x03','l','i','v','e',' ','s','n','a','p','s','h','o','t','/','t','e','l','e','p','o','r','t','a','t','i','o','n',' ','\x96','\x11','a','b','o','r','t','e','d',' ','\x40','\x15','a',' ','f','a','t','a','l',' ','r','u','n','t','i','m','e',' ','\x85',
/* 0x02f41 = "The PE loader encountered delayed imports, a feature which hasn\'t been implemented yet." */
    '\x03','P','E',' ','\xd9','\xaf','d','e','l','a','y','e','d',' ','i','m','p','o','r','t','s',',',' ','a',' ','f','e','a','t','u','r','e',' ','\xed','h','a','s','n','\'','t',' ','\xcb','i','m','p','l','e','m','e','n','t','e','d',' ','y','e','t','.',
/* 0x02f7b = "VRDP protocol violation, client sends less data than expected." */
    'V','R','D','P',' ','p','r','o','t','o','c','o','l',' ','v','i','o','l','a','t','i','o','n',',',' ','c','l','i','e','n','t',' ','s','e','n','d','s',' ','l','e','s','s',' ','\x9d','t','h','a','n',' ','e','x','p','e','c','t','e','d','.',
/* 0x02fb5 = "Image Verification Warning: No Authenticode Signature, but on whitelist." */
    'I','m','a','g','e',' ','\x0d','W','a','r','n','i','n','g',':',' ','\xdf','A','u','t','h','e','n','t','i','c','o','d','e',' ','S','i','g','n','a','t','u','r','e',',',' ','b','u','t',' ','o','n',' ','w','h','i','t','e','l','i','s','t','.',
/* 0x02fef = "The user mode tracepoint provider has too many probe locations and probes." */
    '\x03','u','s','e','r',' ','m','o','d','e',' ','t','r','a','c','e','p','o','i','n','t',' ','p','r','o','v','i','d','e','r',' ','\x5e','\x9e','\xb4','p','r','o','b','e',' ','l','o','c','a','t','i','o','n','s',' ','\x9a','p','r','o','b','e','s','.',
/* 0x03029 = "This indicates that the process does not have sufficient privileges to perform the operation." */
    'T','h','i','s',' ','i','n','d','i','c','a','t','e','s',' ','\xad','\x02','\x92','\xb2','\x08','h','a','v','e',' ','s','u','f','f','i','c','i','e','n','t',' ','p','r','i','v','i','l','e','g','e','s',' ','\x0a','p','e','r','f','o','r','m',' ','\x02','\xea',
/* 0x03063 = "PGMPhysWrite/Read hit a handler in Ring-0 or raw-mode context." */
    'P','G','M','P','h','y','s','W','r','i','t','e','/','R','e','a','d',' ','h','i','t',' ','a',' ','h','a','n','d','l','e','r',' ','\x0f','R','i','n','g','-','0',' ','\xa9','r','a','w','-','m','o','d','e',' ','c','o','n','t','e','x','t','.',
/* 0x0309d = "Hypercall cannot be enabled/performed due to access/permissions/CPL." */
    'H','y','p','e','r','c','a','l','l',' ','\xd1','\xa7','e','n','a','b','l','e','d','/','p','e','r','f','o','r','m','e','d',' ','d','u','e',' ','\x0a','a','c','c','e','s','s','/','p','e','r','m','i','s','s','i','o','n','s','/','C','P','L','.',
/* 0x030d7 = "Escaped URI character sequence with invalid UTF-8 continutation byte." */
    'E','s','c','a','p','e','d',' ','U','R','I',' ','c','h','a','r','a','c','t','e','r',' ','s','e','q','u','e','n','c','e',' ','\x80','\x8f','U','T','F','-','8',' ','c','o','n','t','i','n','u','t','a','t','i','o','n',' ','b','y','t','e','.',
/* 0x03111 = "Reason for leaving RC: Interrupted by external interrupt while in hypervisor code." */
    '\x93','\x10','\x81','R','C',':',' ','I','n','t','e','r','r','u','p','t','e','d',' ','\xe1','e','x','t','e','r','n','a','l',' ','i','n','t','e','r','r','u','p','t',' ','w','h','i','l','e',' ','\x0f','h','y','p','e','r','v','i','s','o','r',' ','\x84',
/* 0x0314b = "A legacy device isn\'t implementing the HPET notification interface." */
    'A',' ','l','e','g','a','c','y',' ','\xa3','i','s','n','\'','t',' ','i','m','p','l','e','m','e','n','t','i','n','g',' ','\x02','H','P','E','T',' ','n','o','t','i','f','i','c','a','t','i','o','n',' ','i','n','t','e','r','f','a','c','e','.',
/* 0x03185 = "Indicating that the VM has been resumed and that the thread should start executing." */
    'I','n','d','i','c','a','t','i','n','g',' ','\xad','\x02','\xcd',' ','\x5e','\xcb','r','e','s','u','m','e','d',' ','\x9a','\xad','\x02','t','h','r','e','a','d',' ','s','h','o','u','l','d',' ','s','t','a','r','t',' ','e','x','e','c','u','t','i','n','g','.',
/* 0x031bf = "Signed data verification failed because of the authenticated content-type attribute did not match." */
    'S','i','g','n','e','d',' ','\x9d','\xf8','\x99','\x40','\x15','\x02','a','u','t','h','e','n','t','i','c','a','t','e','d',' ','c','o','n','t','e','n','t','-','\xf3','a','t','t','r','i','b','u','t','e',' ','d','i','d',' ','\x08','m','a','t','c','h','.',
/* 0x031f8 = "VMLAUNCH/VMRESUME succeeded, can enter nested-guest execution." */
    'V','M','L','A','U','N','C','H','/','V','M','R','E','S','U','M','E',' ','s','u','c','c','e','e','d','e','d',',',' ','c','a','n',' ','e','n','t','e','r',' ','n','e','s','t','e','d','-','\xbb','e','x','e','c','u','t','i','o','n','.',
/* 0x03231 = "The path only element at the end of the VFS chain is too short to make out the parent directory." */
    '\x03','\xd0','o','n','l','y',' ','\x5c','a','t',' ','\x02','e','n','d',' ','\x15','\x02','\x8d',' ','\xa1','\x0b','\x9e','s','h','o','r','t',' ','\x0a','m','a','k','e',' ','o','u','t',' ','\x02','p','a','r','e','n','t',' ','d','i','r','e','c','t','o','r','y','.',
/* 0x0326a = "Reason for leaving RC: A Ring switch was attempted using software interrupt." */
    '\x93','\x10','\x81','R','C',':',' ','A',' ','R','i','n','g',' ','s','w','i','t','c','h',' ','\x11','a','t','t','e','m','p','t','e','d',' ','u','s','i','n','g',' ','s','o','f','t','w','a','r','e',' ','i','n','t','e','r','r','u','p','t','.',
/* 0x032a3 = "Address translation disabled (but permission bits apply)." */
    'A','d','d','r','e','s','s',' ','t','r','a','n','s','l','a','t','i','o','n',' ','d','i','s','a','b','l','e','d',' ','(','b','u','t',' ','p','e','r','m','i','s','s','i','o','n',' ','b','i','t','s',' ','a','p','p','l','y',')','.',
/* 0x032dc = "Not all requests could be submitted due to resource shortage." */
    'N','o','t',' ','a','l','l',' ','r','e','q','u','e','s','t','s',' ','c','o','u','l','d',' ','\xa7','s','u','b','m','i','t','t','e','d',' ','d','u','e',' ','\x0a','r','e','s','o','u','r','c','e',' ','s','h','o','r','t','a','g','e','.',
/* 0x03315 = "Indicating that the VM is being terminated and that the execution shall stop." */
    'I','n','d','i','c','a','t','i','n','g',' ','\xad','\x02','\xcd',' ','\x0b','b','e','i','n','g',' ','t','e','r','m','i','n','a','t','e','d',' ','\x9a','\xad','\x02','e','x','e','c','u','t','i','o','n',' ','s','h','a','l','l',' ','s','t','o','p','.',
/* 0x0334e = "The \'Type\' attribute in the DrvBlock configuration had an unknown value." */
    '\x03','\'','T','y','p','e','\'',' ','a','t','t','r','i','b','u','t','e',' ','\x0f','\x02','D','r','v','B','l','o','c','k',' ','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','h','a','d',' ','\x87','u','n','k','n','o','w','n',' ','\xe8',
/* 0x03387 = "Signed data verification failed because of a malformed authenticated message-digest attribute." */
    'S','i','g','n','e','d',' ','\x9d','\xf8','\x99','\x40','\x15','a',' ','m','a','l','f','o','r','m','e','d',' ','a','u','t','h','e','n','t','i','c','a','t','e','d',' ','m','e','s','s','a','g','e','-','\xd7','a','t','t','r','i','b','u','t','e','.',
/* 0x033c0 = "The uncompressed table of content size in the header didn\'t match what ZLib returned." */
    '\x03','u','n','c','o','m','p','r','e','s','s','e','d',' ','\xb1','\x15','\xf0','s','i','z','e',' ','\x0f','\x02','\xb3','d','i','d','n','\'','t',' ','m','a','t','c','h',' ','w','h','a','t',' ','Z','L','i','b',' ','r','e','t','u','r','n','e','d','.',
/* 0x033f9 = "The driver is already removed, not more transformations possible (at present)." */
    '\x03','\xc5','\x0b','\x7f','r','e','m','o','v','e','d',',',' ','\x08','m','o','r','e',' ','t','r','a','n','s','f','o','r','m','a','t','i','o','n','s',' ','p','o','s','s','i','b','l','e',' ','(','a','t',' ','p','r','e','s','e','n','t',')','.',
/* 0x03432 = "Get an out of memory condition trying to allocate a code point array." */
    'G','e','t',' ','\x87','o','u','t',' ','\x15','\x86','c','o','n','d','i','t','i','o','n',' ','t','r','y','i','n','g',' ','\x0a','a','l','l','o','c','a','t','e',' ','a',' ','c','o','d','e',' ','p','o','i','n','t',' ','a','r','r','a','y','.',
/* 0x0346b = "Windows system integrity policy violation (device guard)." */
    'W','i','n','d','o','w','s',' ','s','y','s','t','e','m',' ','i','n','t','e','g','r','i','t','y',' ','p','o','l','i','c','y',' ','v','i','o','l','a','t','i','o','n',' ','(','d','e','v','i','c','e',' ','g','u','a','r','d',')','.',
/* 0x034a4 = "Signed data verification failed because of a malformed authenticated content-type attribute." */
    'S','i','g','n','e','d',' ','\x9d','\xf8','\x99','\x40','\x15','a',' ','m','a','l','f','o','r','m','e','d',' ','a','u','t','h','e','n','t','i','c','a','t','e','d',' ','c','o','n','t','e','n','t','-','\xf3','a','t','t','r','i','b','u','t','e','.',
/* 0x034dd = "Indicating that we should reschedule to the main execution engine." */
    'I','n','d','i','c','a','t','i','n','g',' ','\xad','w','e',' ','s','h','o','u','l','d',' ','r','e','s','c','h','e','d','u','l','e',' ','\x0a','\x02','m','a','i','n',' ','e','x','e','c','u','t','i','o','n',' ','e','n','g','i','n','e','.',
/* 0x03516 = "Signed data verification failed because the authenticated message-digest attribute did not match." */
    'S','i','g','n','e','d',' ','\x9d','\xf8','\x99','\x40','\x02','a','u','t','h','e','n','t','i','c','a','t','e','d',' ','m','e','s','s','a','g','e','-','\xd7','a','t','t','r','i','b','u','t','e',' ','d','i','d',' ','\x08','m','a','t','c','h','.',
/* 0x0354e = "Process Verification Failure: An unknown and unwanted DLL was found loaded into the process." */
    '\x1e','\x0d','\x12','A','n',' ','u','n','k','n','o','w','n',' ','\x9a','u','n','w','a','n','t','e','d',' ','D','L','L',' ','\x11','f','o','u','n','d',' ','l','o','a','d','e','d',' ','i','n','t','o',' ','\x02','p','r','o','c','e','s','s','.',
/* 0x03586 = "Cannot add symbolic link because no namespace is configured to support it." */
    'C','a','n','n','o','t',' ','a','d','d',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k',' ','\x40','n','o',' ','n','a','m','e','s','p','a','c','e',' ','\x0b','c','o','n','f','i','g','u','r','e','d',' ','\x0a','\xce','i','t','.',
/* 0x035be = "Certificate path validator: Unexpected minimum value found in general subtree object (name constraints)." */
    '\xba','\xd0','\xfe','\x94','m','i','n','i','m','u','m',' ','\xf5','f','o','u','n','d',' ','\x0f','g','e','n','e','r','a','l',' ','s','u','b','t','r','e','e',' ','\xa8','(','n','a','m','e',' ','c','o','n','s','t','r','a','i','n','t','s',')','.',
/* 0x035f6 = "Couldn\'t find any export for registration of drivers/devices." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','a','n','y',' ','e','x','p','o','r','t',' ','\x10','r','e','g','i','s','t','r','a','t','i','o','n',' ','\x15','d','r','i','v','e','r','s','/','d','e','v','i','c','e','s','.',
/* 0x0362e = "Block read was marked as free in the image and returned as a zero block." */
    'B','l','o','c','k',' ','r','e','a','d',' ','\x11','m','a','r','k','e','d',' ','a','s',' ','f','r','e','e',' ','\x0f','\x02','\x26','\x9a','r','e','t','u','r','n','e','d',' ','a','s',' ','a',' ','z','e','r','o',' ','b','l','o','c','k','.',
/* 0x03666 = "Certificate path validator: Unexpected maximum value found in general subtree object (name constraints)." */
    '\xba','\xd0','\xfe','\x94','m','a','x','i','m','u','m',' ','\xf5','f','o','u','n','d',' ','\x0f','g','e','n','e','r','a','l',' ','s','u','b','t','r','e','e',' ','\xa8','(','n','a','m','e',' ','c','o','n','s','t','r','a','i','n','t','s',')','.',
/* 0x0369e = "The DTB being parsed has an invalid size set in the header compared to the actual size." */
    '\x03','D','T','B',' ','b','e','i','n','g',' ','p','a','r','s','e','d',' ','\x5e','\x87','\x8f','s','i','z','e',' ','s','e','t',' ','\x0f','\x02','\xb3','c','o','m','p','a','r','e','d',' ','\x0a','\x02','a','c','t','u','a','l',' ','s','i','z','e','.',
/* 0x036d6 = "Key decryption failed, perhaps due to an incorrect password." */
    'K','e','y',' ','d','e','c','r','y','p','t','i','o','n',' ','f','a','i','l','e','d',',',' ','p','e','r','h','a','p','s',' ','d','u','e',' ','\x0a','\x87','i','n','c','o','r','r','e','c','t',' ','p','a','s','s','w','o','r','d','.',
/* 0x0370e = "Failed to set VMXON enable bit while enabling VT-x through the MSR." */
    '\x8b','\x0a','s','e','t',' ','V','M','X','O','N',' ','e','n','a','b','l','e',' ','b','i','t',' ','w','h','i','l','e',' ','e','n','a','b','l','i','n','g',' ','V','T','-','x',' ','t','h','r','o','u','g','h',' ','\x02','M','S','R','.',
/* 0x03746 = "VT-x features for all modes (SMX and non-SMX) disabled by the BIOS." */
    'V','T','-','x',' ','f','e','a','t','u','r','e','s',' ','\x10','a','l','l',' ','m','o','d','e','s',' ','(','S','M','X',' ','\x9a','n','o','n','-','S','M','X',')',' ','d','i','s','a','b','l','e','d',' ','\xe1','\x02','B','I','O','S','.',
/* 0x0377e = "Someone (including the caller) was already attached as debugger to the VM." */
    'S','o','m','e','o','n','e',' ','(','i','n','c','l','u','d','i','n','g',' ','\x02','c','a','l','l','e','r',')',' ','\x11','\x7f','a','t','t','a','c','h','e','d',' ','a','s',' ','d','e','b','u','g','g','e','r',' ','\x0a','\x02','V','M','.',
/* 0x037b6 = "The device is not a registered PCI device and thus cannot perform any PCI operations." */
    '\x03','\xa3','\x0b','\x08','a',' ','r','e','g','i','s','t','e','r','e','d',' ','P','C','I',' ','\xa3','\x9a','t','h','u','s',' ','\xd1','p','e','r','f','o','r','m',' ','a','n','y',' ','P','C','I',' ','o','p','e','r','a','t','i','o','n','s','.',
/* 0x037ee = "The image requires to be signed using the kernel-code signing process." */
    '\x03','\x26','r','e','q','u','i','r','e','s',' ','\x0a','\xa7','s','i','g','n','e','d',' ','u','s','i','n','g',' ','\x02','k','e','r','n','e','l','-','c','o','d','e',' ','s','i','g','n','i','n','g',' ','p','r','o','c','e','s','s','.',
/* 0x03825 = "Instruction that triggers the hypercall is invalid/unrecognized." */
    'I','n','s','t','r','u','c','t','i','o','n',' ','\xad','t','r','i','g','g','e','r','s',' ','\x02','h','y','p','e','r','c','a','l','l',' ','\x0b','i','n','v','a','l','i','d','/','u','n','r','e','c','o','g','n','i','z','e','d','.',
/* 0x0385c = "Certificate path validator: Intermediate certificate subject does not match child issuer property." */
    '\xba','\xd0','\xfe','I','n','t','e','r','m','e','d','i','a','t','e',' ','\xa0','s','u','b','j','e','c','t',' ','\xb2','\x08','m','a','t','c','h',' ','c','h','i','l','d',' ','i','s','s','u','e','r',' ','p','r','o','p','e','r','t','y','.',
/* 0x03893 = "The operation was cancelled by the user (copy) or another thread (local ipc)." */
    '\x03','\x96','\x11','c','a','n','c','e','l','l','e','d',' ','\xe1','\x02','u','s','e','r',' ','(','c','o','p','y',')',' ','\xa9','a','n','o','t','h','e','r',' ','t','h','r','e','a','d',' ','(','l','o','c','a','l',' ','i','p','c',')','.',
/* 0x038ca = "The intercepted instruction handled, advance RIP and continue execution." */
    '\x03','i','n','t','e','r','c','e','p','t','e','d',' ','\xda','h','a','n','d','l','e','d',',',' ','a','d','v','a','n','c','e',' ','R','I','P',' ','\x9a','c','o','n','t','i','n','u','e',' ','e','x','e','c','u','t','i','o','n','.',
/* 0x03901 = "Out of memory condition when allocating memory with low physical backing." */
    'O','u','t',' ','\x15','\x86','c','o','n','d','i','t','i','o','n',' ','w','h','e','n',' ','a','l','l','o','c','a','t','i','n','g',' ','\x86','\x80','l','o','w',' ','p','h','y','s','i','c','a','l',' ','b','a','c','k','i','n','g','.',
/* 0x03938 = "A data unit in the saved state file was defined but didn\'t any routine for processing it." */
    'A',' ','\x9d','u','n','i','t',' ','\x0f','\x02','s','a','v','e','d',' ','\xca','\x1f','\x11','d','e','f','i','n','e','d',' ','b','u','t',' ','d','i','d','n','\'','t',' ','a','n','y',' ','r','o','u','t','i','n','e',' ','\x10','\x04','i','t','.',
/* 0x0396f = "Indicating that we should reschedule to recompiled execution." */
    'I','n','d','i','c','a','t','i','n','g',' ','\xad','w','e',' ','s','h','o','u','l','d',' ','r','e','s','c','h','e','d','u','l','e',' ','\x0a','r','e','c','o','m','p','i','l','e','d',' ','e','x','e','c','u','t','i','o','n','.',
/* 0x039a6 = "Continuing hypercall at the same RIP, continue guest execution." */
    'C','o','n','t','i','n','u','i','n','g',' ','h','y','p','e','r','c','a','l','l',' ','a','t',' ','\x02','s','a','m','e',' ','R','I','P',',',' ','c','o','n','t','i','n','u','e',' ','\xbb','e','x','e','c','u','t','i','o','n','.',
/* 0x039dd = "Encountered unicode code point in the surrogate range (0xd800 to 0xdfff)." */
    '\xa5','u','n','i','c','o','d','e',' ','c','o','d','e',' ','p','o','i','n','t',' ','\x0f','\x02','s','u','r','r','o','g','a','t','e',' ','r','a','n','g','e',' ','(','0','x','d','8','0','0',' ','\x0a','0','x','d','f','f','f',')','.',
/* 0x03a14 = "One or more PAE PDPEs are invalid due to reserved bits being set." */
    'O','n','e',' ','\xa9','m','o','r','e',' ','P','A','E',' ','P','D','P','E','s',' ','a','r','e',' ','\x8f','d','u','e',' ','\x0a','r','e','s','e','r','v','e','d',' ','b','i','t','s',' ','b','e','i','n','g',' ','s','e','t','.',
/* 0x03a4a = "A new node couldn\'t be inserted because one with the same name exists." */
    'A',' ','n','e','w',' ','n','o','d','e',' ','c','o','u','l','d','n','\'','t',' ','\xa7','i','n','s','e','r','t','e','d',' ','\x40','o','n','e',' ','\x80','\x02','s','a','m','e',' ','n','a','m','e',' ','e','x','i','s','t','s','.',
/* 0x03a80 = "Complex SSM field fed to SSMR3PutStruct or SSMR3GetStruct." */
    'C','o','m','p','l','e','x',' ','S','S','M',' ','f','i','e','l','d',' ','f','e','d',' ','\x0a','S','S','M','R','3','P','u','t','S','t','r','u','c','t',' ','\xa9','S','S','M','R','3','G','e','t','S','t','r','u','c','t','.',
/* 0x03ab6 = "The guest GDT so full that we cannot find free space for our own selectors." */
    '\x03','\xbb','G','D','T',' ','s','o',' ','f','u','l','l',' ','\xad','w','e',' ','\xd1','f','i','n','d',' ','f','r','e','e',' ','s','p','a','c','e',' ','\x10','o','u','r',' ','o','w','n',' ','s','e','l','e','c','t','o','r','s','.',
/* 0x03aec = "Parameters was presented to a signature schema that does not take any." */
    'P','a','r','a','m','e','t','e','r','s',' ','\x11','p','r','e','s','e','n','t','e','d',' ','\x0a','a',' ','s','i','g','n','a','t','u','r','e',' ','s','c','h','e','m','a',' ','\xad','\xb2','\x08','t','a','k','e',' ','a','n','y','.',
/* 0x03b22 = "Tree traversal encountered more nodes than available in the allocator." */
    'T','r','e','e',' ','t','r','a','v','e','r','s','a','l',' ','\xaf','m','o','r','e',' ','n','o','d','e','s',' ','t','h','a','n',' ','a','v','a','i','l','a','b','l','e',' ','\x0f','\x02','a','l','l','o','c','a','t','o','r','.',
/* 0x03b58 = "The decompressor completed without using all the input data." */
    '\x03','d','e','c','o','m','p','r','e','s','s','o','r',' ','c','o','m','p','l','e','t','e','d',' ','w','i','t','h','o','u','t',' ','u','s','i','n','g',' ','a','l','l',' ','\x02','i','n','p','u','t',' ','d','a','t','a','.',
/* 0x03b8e = "Framebuffer is resized, terminate send bitmap procedure." */
    'F','r','a','m','e','b','u','f','f','e','r',' ','\x0b','r','e','s','i','z','e','d',',',' ','t','e','r','m','i','n','a','t','e',' ','s','e','n','d',' ','b','i','t','m','a','p',' ','p','r','o','c','e','d','u','r','e','.',
/* 0x03bc4 = "Failed to make the Host Interface Networking handle non-blocking." */
    '\x8b','\x0a','m','a','k','e',' ','\x02','H','o','s','t',' ','I','n','t','e','r','f','a','c','e',' ','N','e','t','w','o','r','k','i','n','g',' ','h','a','n','d','l','e',' ','n','o','n','-','b','l','o','c','k','i','n','g','.',
/* 0x03bfa = "Syntax error - you hit a debugger feature which isn\'t implemented yet." */
    '\xfa','\x09','-',' ','y','o','u',' ','h','i','t',' ','a',' ','d','e','b','u','g','g','e','r',' ','f','e','a','t','u','r','e',' ','\xed','i','s','n','\'','t',' ','i','m','p','l','e','m','e','n','t','e','d',' ','y','e','t','.',
/* 0x03c30 = "A device didn\'t find a required interface with an attached driver." */
    'A',' ','\xa3','d','i','d','n','\'','t',' ','f','i','n','d',' ','a',' ','r','e','q','u','i','r','e','d',' ','i','n','t','e','r','f','a','c','e',' ','\x80','\x87','a','t','t','a','c','h','e','d',' ','d','r','i','v','e','r','.',
/* 0x03c66 = "The specified R0 or RC MMIO range didn\'t have a corresponding R3 range." */
    '\x03','\x18','R','0',' ','\xa9','R','C',' ','\xd3',' ','r','a','n','g','e',' ','d','i','d','n','\'','t',' ','h','a','v','e',' ','a',' ','c','o','r','r','e','s','p','o','n','d','i','n','g',' ','R','3',' ','r','a','n','g','e','.',
/* 0x03c9c = "CPU hotplug events from VMMDev are not monitored by the guest." */
    'C','P','U',' ','h','o','t','p','l','u','g',' ','e','v','e','n','t','s',' ','f','r','o','m',' ','V','M','M','D','e','v',' ','a','r','e',' ','\x08','m','o','n','i','t','o','r','e','d',' ','\xe1','\x02','g','u','e','s','t','.',
/* 0x03cd2 = "Certificate path validator: Unexpected choice found in general subtree object (name constraints)." */
    '\xba','\xd0','\xfe','\x94','c','h','o','i','c','e',' ','f','o','u','n','d',' ','\x0f','g','e','n','e','r','a','l',' ','s','u','b','t','r','e','e',' ','\xa8','(','n','a','m','e',' ','c','o','n','s','t','r','a','i','n','t','s',')','.',
/* 0x03d08 = "The size of the one or more regions in the shared module was out of range." */
    '\x03','s','i','z','e',' ','\x15','\x02','o','n','e',' ','\xa9','m','o','r','e',' ','r','e','g','i','o','n','s',' ','\x0f','\x02','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','\x11','o','u','t',' ','\x15','r','a','n','g','e','.',
/* 0x03d3e = "The chunk to be unmapped isn\'t actually mapped into the process." */
    '\x03','c','h','u','n','k',' ','\x0a','\xa7','u','n','m','a','p','p','e','d',' ','i','s','n','\'','t',' ','a','c','t','u','a','l','l','y',' ','m','a','p','p','e','d',' ','i','n','t','o',' ','\x02','p','r','o','c','e','s','s','.',
/* 0x03d74 = "The attached driver configuration is missing the \'Driver\' attribute." */
    '\x03','a','t','t','a','c','h','e','d',' ','\xc5','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','\x0b','m','i','s','s','i','n','g',' ','\x02','\'','D','r','i','v','e','r','\'',' ','a','t','t','r','i','b','u','t','e','.',
/* 0x03daa = "Recompiled execution: Break out of current TB execution." */
    'R','e','c','o','m','p','i','l','e','d',' ','e','x','e','c','u','t','i','o','n',':',' ','B','r','e','a','k',' ','o','u','t',' ','\x15','c','u','r','r','e','n','t',' ','T','B',' ','e','x','e','c','u','t','i','o','n','.',
/* 0x03de0 = "A new leaf couldn\'t be inserted because one with the same name exists." */
    'A',' ','n','e','w',' ','l','e','a','f',' ','c','o','u','l','d','n','\'','t',' ','\xa7','i','n','s','e','r','t','e','d',' ','\x40','o','n','e',' ','\x80','\x02','s','a','m','e',' ','n','a','m','e',' ','e','x','i','s','t','s','.',
/* 0x03e16 = "The configuration constructor in main failed due to an internal consistency error." */
    '\x03','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','c','o','n','s','t','r','u','c','t','o','r',' ','\x0f','m','a','i','n',' ','\x99','d','u','e',' ','\x0a','\x87','\x16','c','o','n','s','i','s','t','e','n','c','y',' ','\x85',
/* 0x03e4c = "Error creating an event semaphore for used with asynchronous reads." */
    '\xc0','c','r','e','a','t','i','n','g',' ','\x87','e','v','e','n','t',' ','s','e','m','a','p','h','o','r','e',' ','\x10','u','s','e','d',' ','\x80','a','s','y','n','c','h','r','o','n','o','u','s',' ','r','e','a','d','s','.',
/* 0x03e81 = "Encountered an unsupported portable archive exchange (pax) header." */
    '\xa5','\x87','u','n','s','u','p','p','o','r','t','e','d',' ','p','o','r','t','a','b','l','e',' ','a','r','c','h','i','v','e',' ','e','x','c','h','a','n','g','e',' ','(','p','a','x',')',' ','h','e','a','d','e','r','.',
/* 0x03eb6 = "Malformed initialization vector for encrypted key ciper." */
    'M','a','l','f','o','r','m','e','d',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','v','e','c','t','o','r',' ','\x10','e','n','c','r','y','p','t','e','d',' ','k','e','y',' ','c','i','p','e','r','.',
/* 0x03eeb = "Internal processing error in the PGM physical page mapping code dealing with MMIO2 pages." */
    '\x07','\x04','\x09','\x0f','\x02','P','G','M',' ','p','h','y','s','i','c','a','l',' ','\xcc','m','a','p','p','i','n','g',' ','c','o','d','e',' ','d','e','a','l','i','n','g',' ','\x80','M','M','I','O','2',' ','p','a','g','e','s','.',
/* 0x03f20 = "The loader resolved an external symbol to an address to big for the image format." */
    '\x03','\xd9','r','e','s','o','l','v','e','d',' ','\x87','e','x','t','e','r','n','a','l',' ','s','y','m','b','o','l',' ','\x0a','\x87','a','d','d','r','e','s','s',' ','\x0a','b','i','g',' ','\x10','\x02','\x26','f','o','r','m','a','t','.',
/* 0x03f55 = "Process Verification Failure: The ImageCharacteristics of the process does not match the value in the file header in the exe file." */
    '\x1e','\x0d','\x12','\x03','I','m','a','g','e','C','h','a','r','a','c','t','e','r','i','s','t','i','c','s',' ','\x15','\x02','\x92','\xb2','\x08','m','a','t','c','h',' ','\x02','\xf5','\x0f','\x02','\x1f','\xb3','\x0f','\x02','e','x','e',' ','f','i','l','e','.',
/* 0x03f8a = "Tried to grow a file beyond the limit imposed by the process or the filesystem." */
    'T','r','i','e','d',' ','\x0a','g','r','o','w',' ','a',' ','\x1f','b','e','y','o','n','d',' ','\x02','l','i','m','i','t',' ','i','m','p','o','s','e','d',' ','\xe1','\x02','\x92','\xa9','\x02','f','i','l','e','s','y','s','t','e','m','.',
/* 0x03fbf = "The trace log reader iterator reached the end of the event list." */
    '\x03','t','r','a','c','e',' ','l','o','g',' ','r','e','a','d','e','r',' ','i','t','e','r','a','t','o','r',' ','r','e','a','c','h','e','d',' ','\x02','e','n','d',' ','\x15','\x02','e','v','e','n','t',' ','l','i','s','t','.',
/* 0x03ff4 = "The media translation hasn\'t been set yet, so it cannot be obtained." */
    '\x03','m','e','d','i','a',' ','t','r','a','n','s','l','a','t','i','o','n',' ','h','a','s','n','\'','t',' ','\xcb','s','e','t',' ','y','e','t',',',' ','s','o',' ','i','t',' ','\xd1','\xa7','o','b','t','a','i','n','e','d','.',
/* 0x04029 = "CPU is not in VMX root mode; unexpected when leaving VMX root mode." */
    'C','P','U',' ','\x0b','\x08','\x0f','V','M','X',' ','r','o','o','t',' ','m','o','d','e',';',' ','u','n','e','x','p','e','c','t','e','d',' ','w','h','e','n',' ','\x81','V','M','X',' ','r','o','o','t',' ','m','o','d','e','.',
/* 0x0405e = "The CSRSS instance associated with the client process could not be located." */
    '\x03','C','S','R','S','S',' ','i','n','s','t','a','n','c','e',' ','a','s','s','o','c','i','a','t','e','d',' ','\x80','\x02','c','l','i','e','n','t',' ','\x92','c','o','u','l','d',' ','\x08','\xa7','l','o','c','a','t','e','d','.',
/* 0x04093 = "Recompiled execution: Breaking out because of FFs or/and IRQs." */
    'R','e','c','o','m','p','i','l','e','d',' ','e','x','e','c','u','t','i','o','n',':',' ','B','r','e','a','k','i','n','g',' ','o','u','t',' ','\x40','\x15','F','F','s',' ','o','r','/','a','n','d',' ','I','R','Q','s','.',
/* 0x040c8 = "command processing is pending, a completion handler will be called." */
    'c','o','m','m','a','n','d',' ','\x04','\x0b','p','e','n','d','i','n','g',',',' ','a',' ','c','o','m','p','l','e','t','i','o','n',' ','h','a','n','d','l','e','r',' ','w','i','l','l',' ','\xa7','c','a','l','l','e','d','.',
/* 0x040fd = "Internal EM error caused by an unknown warning or informational status code." */
    '\x07','E','M',' ','\x09','c','a','u','s','e','d',' ','\xe1','\x87','u','n','k','n','o','w','n',' ','w','a','r','n','i','n','g',' ','\xa9','i','n','f','o','r','m','a','t','i','o','n','a','l',' ','s','t','a','t','u','s',' ','\x84',
/* 0x04132 = "File access error, another process has locked a portion of the file." */
    'F','i','l','e',' ','a','c','c','e','s','s',' ','e','r','r','o','r',',',' ','a','n','o','t','h','e','r',' ','\x92','\x5e','l','o','c','k','e','d',' ','a',' ','p','o','r','t','i','o','n',' ','\x15','\x02','f','i','l','e','.',
/* 0x04167 = "RTGetOpt: Command line option has argument with bad format." */
    'R','T','G','e','t','O','p','t',':',' ','C','o','m','m','a','n','d',' ','l','i','n','e',' ','o','p','t','i','o','n',' ','\x5e','a','r','g','u','m','e','n','t',' ','\x80','b','a','d',' ','f','o','r','m','a','t','.',
/* 0x0419b = "Syntax error - Cannot read symbol value, it is a set-only symbol." */
    '\xfa','\x09','-',' ','C','a','n','n','o','t',' ','r','e','a','d',' ','s','y','m','b','o','l',' ','v','a','l','u','e',',',' ','i','t',' ','\x0b','a',' ','s','e','t','-','o','n','l','y',' ','s','y','m','b','o','l','.',
/* 0x041cf = "Cannot add symbolic link to one of the selected namespaces." */
    'C','a','n','n','o','t',' ','a','d','d',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k',' ','\x0a','o','n','e',' ','\x15','\x02','s','e','l','e','c','t','e','d',' ','n','a','m','e','s','p','a','c','e','s','.',
/* 0x04203 = "The page hash table hashes data outside the defined and implicit sections." */
    '\x03','\xcc','h','a','s','h',' ','\xb1','h','a','s','h','e','s',' ','\x9d','o','u','t','s','i','d','e',' ','\x02','d','e','f','i','n','e','d',' ','\x9a','i','m','p','l','i','c','i','t',' ','s','e','c','t','i','o','n','s','.',
/* 0x04237 = "The backend needs more metadata before it can continue." */
    '\x03','b','a','c','k','e','n','d',' ','n','e','e','d','s',' ','m','o','r','e',' ','m','e','t','a','d','a','t','a',' ','b','e','f','o','r','e',' ','i','t',' ','c','a','n',' ','c','o','n','t','i','n','u','e','.',
/* 0x0426b = "To short initialization vector for encrypted key ciper." */
    'T','o',' ','s','h','o','r','t',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','v','e','c','t','o','r',' ','\x10','e','n','c','r','y','p','t','e','d',' ','k','e','y',' ','c','i','p','e','r','.',
/* 0x0429f = "The physical handler range has no corresponding RAM range." */
    '\x03','p','h','y','s','i','c','a','l',' ','h','a','n','d','l','e','r',' ','r','a','n','g','e',' ','\x5e','n','o',' ','c','o','r','r','e','s','p','o','n','d','i','n','g',' ','R','A','M',' ','r','a','n','g','e','.',
/* 0x042d3 = "Host API has not set a valid physical address of host-state area." */
    'H','o','s','t',' ','A','P','I',' ','\x5e','\x08','s','e','t',' ','a',' ','v','a','l','i','d',' ','p','h','y','s','i','c','a','l',' ','a','d','d','r','e','s','s',' ','\x15','h','o','s','t','-','\xca','a','r','e','a','.',
/* 0x04307 = "Internal processing error in the PGM physcal page handling code related to MMIO/MMIO2." */
    '\x07','\x04','\x09','\x0f','\x02','P','G','M',' ','p','h','y','s','c','a','l',' ','\xcc','h','a','n','d','l','i','n','g',' ','c','o','d','e',' ','r','e','l','a','t','e','d',' ','\x0a','M','M','I','O','/','M','M','I','O','2','.',
/* 0x0433b = "RTThreadYield was called during a GVMMR0SchedPoll call." */
    'R','T','T','h','r','e','a','d','Y','i','e','l','d',' ','\x11','c','a','l','l','e','d',' ','d','u','r','i','n','g',' ','a',' ','G','V','M','M','R','0','S','c','h','e','d','P','o','l','l',' ','c','a','l','l','.',
/* 0x0436f = "Attempt to free more memory than what was previously allocated." */
    'A','t','t','e','m','p','t',' ','\x0a','f','r','e','e',' ','m','o','r','e',' ','\x86','t','h','a','n',' ','w','h','a','t',' ','\x11','p','r','e','v','i','o','u','s','l','y',' ','a','l','l','o','c','a','t','e','d','.',
/* 0x043a3 = "Process Verification Failure: A DLL residing outside System32 was found in the process." */
    '\x1e','\x0d','\x12','A',' ','D','L','L',' ','r','e','s','i','d','i','n','g',' ','o','u','t','s','i','d','e',' ','S','y','s','t','e','m','3','2',' ','\x11','f','o','u','n','d',' ','\x0f','\x02','p','r','o','c','e','s','s','.',
/* 0x043d7 = "Invalid nested hardware virtualization feature combination." */
    '\x0c','n','e','s','t','e','d',' ','h','a','r','d','w','a','r','e',' ','v','i','r','t','u','a','l','i','z','a','t','i','o','n',' ','f','e','a','t','u','r','e',' ','c','o','m','b','i','n','a','t','i','o','n','.',
/* 0x0440b = "Cannot destroy VM because not all other EMTs have deregistered." */
    'C','a','n','n','o','t',' ','d','e','s','t','r','o','y',' ','\xcd',' ','\x40','\x08','a','l','l',' ','o','t','h','e','r',' ','E','M','T','s',' ','h','a','v','e',' ','d','e','r','e','g','i','s','t','e','r','e','d','.',
/* 0x0443f = "The timer has a bad clock enum value, probably corruption." */
    '\x03','t','i','m','e','r',' ','\x5e','a',' ','b','a','d',' ','c','l','o','c','k',' ','e','n','u','m',' ','v','a','l','u','e',',',' ','p','r','o','b','a','b','l','y',' ','c','o','r','r','u','p','t','i','o','n','.',
/* 0x04473 = "Found a ZIP64 Extra Information Field in a ZIP32 file." */
    'F','o','u','n','d',' ','a',' ','Z','I','P','6','4',' ','E','x','t','r','a',' ','I','n','f','o','r','m','a','t','i','o','n',' ','F','i','e','l','d',' ','\x0f','a',' ','Z','I','P','3','2',' ','f','i','l','e','.',
/* 0x044a7 = "Returns by rep-prefixed string instruction if they yield because of pending FFs." */
    'R','e','t','u','r','n','s',' ','\xe1','r','e','p','-','p','r','e','f','i','x','e','d',' ','\xf2','\xda','i','f',' ','t','h','e','y',' ','y','i','e','l','d',' ','\x40','\x15','p','e','n','d','i','n','g',' ','F','F','s','.',
/* 0x044db = "The networking interface to filter was busy (used by someone)." */
    '\x03','n','e','t','w','o','r','k','i','n','g',' ','i','n','t','e','r','f','a','c','e',' ','\x0a','f','i','l','t','e','r',' ','\x11','b','u','s','y',' ','(','u','s','e','d',' ','\xe1','s','o','m','e','o','n','e',')','.',
/* 0x0450f = "Escape URI char decodes as zero (the C string terminator)." */
    'E','s','c','a','p','e',' ','U','R','I',' ','c','h','a','r',' ','d','e','c','o','d','e','s',' ','a','s',' ','z','e','r','o',' ','(','t','h','e',' ','C',' ','\xf2','t','e','r','m','i','n','a','t','o','r',')','.',
/* 0x04543 = "The boot catalog validation entry in the import ISO has an incorrect checksum." */
    '\x03','b','o','o','t',' ','\xe7','v','a','l','i','d','a','t','i','o','n',' ','\xc8','\x0f','\x02','i','m','p','o','r','t',' ','\xc1',' ','\x5e','\x87','i','n','c','o','r','r','e','c','t',' ','c','h','e','c','k','s','u','m','.',
/* 0x04576 = "The machine (cputype / cpusubtype combination) isn\'t supported." */
    '\x03','m','a','c','h','i','n','e',' ','(','c','p','u','t','y','p','e',' ','/',' ','c','p','u','s','u','b','t','y','p','e',' ','c','o','m','b','i','n','a','t','i','o','n',')',' ','i','s','n','\'','t',' ','\xa4',
/* 0x045a9 = "Not possible to detach a driver because the above driver/device doesn't support it." */
    'N','o','t',' ','p','o','s','s','i','b','l','e',' ','\x0a','d','e','t','a','c','h',' ','a',' ','\xc5','\x40','\x02','a','b','o','v','e',' ','d','r','i','v','e','r','/','d','e','v','i','c','e',' ','\xc7','\xce','i','t','.',
/* 0x045dc = "Process Verification Failure: Found no executable mapped into the process address space." */
    '\x1e','\x0d','\x12','F','o','u','n','d',' ','n','o',' ','e','x','e','c','u','t','a','b','l','e',' ','m','a','p','p','e','d',' ','i','n','t','o',' ','\x02','\x92','a','d','d','r','e','s','s',' ','s','p','a','c','e','.',
/* 0x0460f = "Import ISO contains a directory with a more than one extent, that\'s currently not supported." */
    '\xc3','\xc1',' ','\x8a','a',' ','\x25','\x80','a',' ','m','o','r','e',' ','t','h','a','n',' ','o','n','e',' ','e','x','t','e','n','t',',',' ','t','h','a','t','\'','s',' ','c','u','r','r','e','n','t','l','y',' ','\x08','\xa4',
/* 0x04642 = "Logging is disabled or logger instance could not be created." */
    'L','o','g','g','i','n','g',' ','\x0b','d','i','s','a','b','l','e','d',' ','\xa9','l','o','g','g','e','r',' ','i','n','s','t','a','n','c','e',' ','c','o','u','l','d',' ','\x08','\xa7','c','r','e','a','t','e','d','.',
/* 0x04675 = "A TSC-delta measurement request is currently being serviced." */
    'A',' ','T','S','C','-','d','e','l','t','a',' ','m','e','a','s','u','r','e','m','e','n','t',' ','\xaa','\x0b','c','u','r','r','e','n','t','l','y',' ','b','e','i','n','g',' ','s','e','r','v','i','c','e','d','.',
/* 0x046a8 = "Vote for done tell SSM not to call again until the final pass." */
    'V','o','t','e',' ','\x10','d','o','n','e',' ','t','e','l','l',' ','S','S','M',' ','\x08','\x0a','c','a','l','l',' ','a','g','a','i','n',' ','u','n','t','i','l',' ','\x02','f','i','n','a','l',' ','p','a','s','s','.',
/* 0x046db = "The boot catalog block in the import ISO has an incorrect validation header ID." */
    '\x03','b','o','o','t',' ','\xe7','b','l','o','c','k',' ','\x0f','\x02','i','m','p','o','r','t',' ','\xc1',' ','\x5e','\x87','i','n','c','o','r','r','e','c','t',' ','v','a','l','i','d','a','t','i','o','n',' ','\xb3','I','D','.',
/* 0x0470e = "The version of the USB device registration structure is unknown to this VBox version." */
    '\x03','\xcf','\x15','\x02','U','S','B',' ','\xa3','r','e','g','i','s','t','r','a','t','i','o','n',' ','\xec','\x0b','u','n','k','n','o','w','n',' ','\x0a','t','h','i','s',' ','V','B','o','x',' ','v','e','r','s','i','o','n','.',
/* 0x04741 = "Import ISO starts with supplementary volume descriptor before any primary ones." */
    '\xc3','\xc1',' ','s','t','a','r','t','s',' ','\x80','s','u','p','p','l','e','m','e','n','t','a','r','y',' ','\xd2','\xe3','b','e','f','o','r','e',' ','a','n','y',' ','p','r','i','m','a','r','y',' ','o','n','e','s','.',
/* 0x04774 = "Operation can\'t be done in current HDD container state." */
    'O','p','e','r','a','t','i','o','n',' ','c','a','n','\'','t',' ','\xa7','d','o','n','e',' ','\x0f','c','u','r','r','e','n','t',' ','H','D','D',' ','c','o','n','t','a','i','n','e','r',' ','s','t','a','t','e','.',
/* 0x047a7 = "The chosen baudrate is invalid or not supported by the given serial port." */
    '\x03','c','h','o','s','e','n',' ','b','a','u','d','r','a','t','e',' ','\x0b','\x8f','\xa9','\x08','s','u','p','p','o','r','t','e','d',' ','\xe1','\x02','g','i','v','e','n',' ','s','e','r','i','a','l',' ','p','o','r','t','.',
/* 0x047da = "pgmPhysPageMapCommon encountered PGMPAGETYPE_MMIO2_ALIAS_MMIO." */
    'p','g','m','P','h','y','s','P','a','g','e','M','a','p','C','o','m','m','o','n',' ','\xaf','P','G','M','P','A','G','E','T','Y','P','E','_','M','M','I','O','2','_','A','L','I','A','S','_','M','M','I','O','.',
/* 0x0480d = "The Host Interface Networking name config IOCTL call failed." */
    '\x03','H','o','s','t',' ','I','n','t','e','r','f','a','c','e',' ','N','e','t','w','o','r','k','i','n','g',' ','n','a','m','e',' ','c','o','n','f','i','g',' ','I','O','C','T','L',' ','c','a','l','l',' ','\x7b',
/* 0x04840 = "Number of tries to add an int3 breakpoint table to the lookup tables reached." */
    'N','u','m','b','e','r',' ','\x15','t','r','i','e','s',' ','\x0a','a','d','d',' ','\x87','i','n','t','3',' ','\xbf','\xb1','\x0a','\x02','l','o','o','k','u','p',' ','t','a','b','l','e','s',' ','r','e','a','c','h','e','d','.',
/* 0x04873 = "No allocation descriptors for non-zero sized UDF object." */
    '\xdf','a','l','l','o','c','a','t','i','o','n',' ','d','e','s','c','r','i','p','t','o','r','s',' ','\x10','n','o','n','-','z','e','r','o',' ','s','i','z','e','d',' ','U','D','F',' ','o','b','j','e','c','t','.',
/* 0x048a6 = "A VM api requiring EMT was called from another thread." */
    'A',' ','\xcd',' ','a','p','i',' ','r','e','q','u','i','r','i','n','g',' ','E','M','T',' ','\x11','c','a','l','l','e','d',' ','f','r','o','m',' ','a','n','o','t','h','e','r',' ','t','h','r','e','a','d','.',
/* 0x048d8 = "Certificate path validator: Hit the max certificate path length before reaching trust anchor." */
    '\xba','\xd0','\xfe','H','i','t',' ','\x02','m','a','x',' ','\xa0','\xd0','l','e','n','g','t','h',' ','b','e','f','o','r','e',' ','r','e','a','c','h','i','n','g',' ','t','r','u','s','t',' ','a','n','c','h','o','r','.',
/* 0x0490a = "Asynchronous stream initialization still on-going." */
    'A','s','y','n','c','h','r','o','n','o','u','s',' ','s','t','r','e','a','m',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','s','t','i','l','l',' ','o','n','-','g','o','i','n','g','.',
/* 0x0493c = "The I/O queue has requests pending which need complete first." */
    '\x03','I','/','O',' ','q','u','e','u','e',' ','\x5e','r','e','q','u','e','s','t','s',' ','p','e','n','d','i','n','g',' ','\xed','n','e','e','d',' ','c','o','m','p','l','e','t','e',' ','f','i','r','s','t','.',
/* 0x0496e = "Maximum of concurrent clipboard transfers has been reached." */
    'M','a','x','i','m','u','m',' ','\x15','c','o','n','c','u','r','r','e','n','t',' ','c','l','i','p','b','o','a','r','d',' ','t','r','a','n','s','f','e','r','s',' ','\x5e','\xcb','r','e','a','c','h','e','d','.',
/* 0x049a0 = "Failed to initialize a virtual network interface instance." */
    '\x8b','\x0a','i','n','i','t','i','a','l','i','z','e',' ','a',' ','v','i','r','t','u','a','l',' ','n','e','t','w','o','r','k',' ','i','n','t','e','r','f','a','c','e',' ','i','n','s','t','a','n','c','e','.',
/* 0x049d2 = "Found unexpected cipher parameters for encrypted key." */
    'F','o','u','n','d',' ','u','n','e','x','p','e','c','t','e','d',' ','c','i','p','h','e','r',' ','p','a','r','a','m','e','t','e','r','s',' ','\x10','e','n','c','r','y','p','t','e','d',' ','k','e','y','.',
/* 0x04a04 = "Support for sparable partitions as not yet been implemented." */
    'S','u','p','p','o','r','t',' ','\x10','s','p','a','r','a','b','l','e',' ','p','a','r','t','i','t','i','o','n','s',' ','a','s',' ','\x08','y','e','t',' ','\xcb','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x04a36 = "The network already exists with a different trunk configuration." */
    '\x03','n','e','t','w','o','r','k',' ','\x7f','e','x','i','s','t','s',' ','\x80','a',' ','d','i','f','f','e','r','e','n','t',' ','t','r','u','n','k',' ','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x04a68 = "The specified execution engine cannot execute guest code in the current state." */
    '\x03','\x18','e','x','e','c','u','t','i','o','n',' ','e','n','g','i','n','e',' ','\xd1','e','x','e','c','u','t','e',' ','\xbb','c','o','d','e',' ','\x0f','\x02','c','u','r','r','e','n','t',' ','s','t','a','t','e','.',
/* 0x04a9a = "Don\'t spin for the semaphore, but it is safe to try grab it." */
    'D','o','n','\'','t',' ','s','p','i','n',' ','\x10','\x02','s','e','m','a','p','h','o','r','e',',',' ','b','u','t',' ','i','t',' ','\x0b','s','a','f','e',' ','\x0a','t','r','y',' ','g','r','a','b',' ','i','t','.',
/* 0x04acc = "Image Verification Failure: Error allocating memory for authenticode signature data." */
    'I','m','a','g','e',' ','\x0d','\x12','\xc0','a','l','l','o','c','a','t','i','n','g',' ','\x86','\x10','a','u','t','h','e','n','t','i','c','o','d','e',' ','s','i','g','n','a','t','u','r','e',' ','d','a','t','a','.',
/* 0x04afe = "Out of memory condition when allocating executable memory." */
    'O','u','t',' ','\x15','\x86','c','o','n','d','i','t','i','o','n',' ','w','h','e','n',' ','a','l','l','o','c','a','t','i','n','g',' ','e','x','e','c','u','t','a','b','l','e',' ','m','e','m','o','r','y','.',
/* 0x04b30 = "The media geometry hasn\'t been set yet, so it cannot be obtained." */
    '\x03','m','e','d','i','a',' ','g','e','o','m','e','t','r','y',' ','h','a','s','n','\'','t',' ','\xcb','s','e','t',' ','y','e','t',',',' ','s','o',' ','i','t',' ','\xd1','\xa7','o','b','t','a','i','n','e','d','.',
/* 0x04b62 = "The breakpoint owner handle is still used by one or more breakpoints." */
    '\x03','\xbf','o','w','n','e','r',' ','h','a','n','d','l','e',' ','\x0b','s','t','i','l','l',' ','u','s','e','d',' ','\xe1','o','n','e',' ','\xa9','m','o','r','e',' ','b','r','e','a','k','p','o','i','n','t','s','.',
/* 0x04b94 = "Non-standard descriptor character set in the logical volume descriptor." */
    'N','o','n','-','s','t','a','n','d','a','r','d',' ','\xe3','c','h','a','r','a','c','t','e','r',' ','s','e','t',' ','\x0f','\x02','l','o','g','i','c','a','l',' ','\xd2','d','e','s','c','r','i','p','t','o','r','.',
/* 0x04bc6 = "Unable to seal text memory again to protect against write access (hardening)." */
    '\xe0','\x0a','s','e','a','l',' ','t','e','x','t',' ','\x86','a','g','a','i','n',' ','\x0a','p','r','o','t','e','c','t',' ','a','g','a','i','n','s','t',' ','w','r','i','t','e',' ','a','c','c','e','s','s',' ','\xae',
/* 0x04bf8 = "A attach or prepare mount call failed because the driver already had a driver attached." */
    'A',' ','a','t','t','a','c','h',' ','\xa9','p','r','e','p','a','r','e',' ','m','o','u','n','t',' ','c','a','l','l',' ','\x99','\x40','\x02','\xc5','\x7f','h','a','d',' ','a',' ','\xc5','a','t','t','a','c','h','e','d','.',
/* 0x04c2a = "Object corresponding to the supplied arguments does not exist." */
    'O','b','j','e','c','t',' ','c','o','r','r','e','s','p','o','n','d','i','n','g',' ','\x0a','\x02','s','u','p','p','l','i','e','d',' ','a','r','g','u','m','e','n','t','s',' ','\xb2','\x08','e','x','i','s','t','.',
/* 0x04c5c = "Certificate path validator: Intermediate certificate is missing the KeyCertSign usage flag." */
    '\xba','\xd0','\xfe','I','n','t','e','r','m','e','d','i','a','t','e',' ','\xa0','\x0b','m','i','s','s','i','n','g',' ','\x02','K','e','y','C','e','r','t','S','i','g','n',' ','u','s','a','g','e',' ','f','l','a','g','.',
/* 0x04c8e = "Support for metadata partitions as not yet been implemented." */
    'S','u','p','p','o','r','t',' ','\x10','m','e','t','a','d','a','t','a',' ','p','a','r','t','i','t','i','o','n','s',' ','a','s',' ','\x08','y','e','t',' ','\xcb','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x04cc0 = "The physical guest page is a reserved/MMIO page and does not have any HC address." */
    '\x03','p','h','y','s','i','c','a','l',' ','\xbb','\xcc','\x0b','a',' ','r','e','s','e','r','v','e','d','/','\xd3',' ','\xcc','\x9a','\xb2','\x08','h','a','v','e',' ','a','n','y',' ','H','C',' ','a','d','d','r','e','s','s','.',
/* 0x04cf2 = "The Logical Unit was found, but it had no driver attached to it." */
    '\x03','L','o','g','i','c','a','l',' ','U','n','i','t',' ','\x11','f','o','u','n','d',',',' ','b','u','t',' ','i','t',' ','h','a','d',' ','n','o',' ','\xc5','a','t','t','a','c','h','e','d',' ','\x0a','i','t','.',
/* 0x04d24 = "SPC requires there to be exactly one SignerInfo entry." */
    'S','P','C',' ','r','e','q','u','i','r','e','s',' ','t','h','e','r','e',' ','\x0a','\xa7','e','x','a','c','t','l','y',' ','o','n','e',' ','S','i','g','n','e','r','I','n','f','o',' ','e','n','t','r','y','.',
/* 0x04d56 = "The image is required to be signed with the same certificate as the rest of VirtualBox." */
    '\x03','\x26','\x0b','r','e','q','u','i','r','e','d',' ','\x0a','\xa7','s','i','g','n','e','d',' ','\x80','\x02','s','a','m','e',' ','\xa0','a','s',' ','\x02','r','e','s','t',' ','\x15','V','i','r','t','u','a','l','B','o','x','.',
/* 0x04d88 = "The patch manager is not used because we\'re using HM and VT-x/AMD-V." */
    '\x03','p','a','t','c','h',' ','m','a','n','a','g','e','r',' ','\x0b','\x08','u','s','e','d',' ','\x40','w','e','\'','r','e',' ','u','s','i','n','g',' ','H','M',' ','\x9a','V','T','-','x','/','A','M','D','-','V','.',
/* 0x04dba = "The release call only release a semaphore nesting, i." */
    '\x03','r','e','l','e','a','s','e',' ','c','a','l','l',' ','o','n','l','y',' ','r','e','l','e','a','s','e',' ','a',' ','s','e','m','a','p','h','o','r','e',' ','n','e','s','t','i','n','g',',',' ','i','.',
/* 0x04dec = "The PE loader encountered an unknown load config directory/header size." */
    '\x03','P','E',' ','\xd9','\xaf','\x87','u','n','k','n','o','w','n',' ','l','o','a','d',' ','c','o','n','f','i','g',' ','d','i','r','e','c','t','o','r','y','/','h','e','a','d','e','r',' ','s','i','z','e','.',
/* 0x04e1d = "Bogus length for continuation allocation descriptor." */
    'B','o','g','u','s',' ','l','e','n','g','t','h',' ','\x10','c','o','n','t','i','n','u','a','t','i','o','n',' ','a','l','l','o','c','a','t','i','o','n',' ','d','e','s','c','r','i','p','t','o','r','.',
/* 0x04e4e = "Unable to open the host interface due to a sharing violation ." */
    '\xe0','\x0a','o','p','e','n',' ','\x02','h','o','s','t',' ','i','n','t','e','r','f','a','c','e',' ','d','u','e',' ','\x0a','a',' ','s','h','a','r','i','n','g',' ','v','i','o','l','a','t','i','o','n',' ','.',
/* 0x04e7f = "The TCP server was shut down using RTTcpServerShutdown." */
    '\x03','T','C','P',' ','s','e','r','v','e','r',' ','\x11','s','h','u','t',' ','d','o','w','n',' ','u','s','i','n','g',' ','R','T','T','c','p','S','e','r','v','e','r','S','h','u','t','d','o','w','n','.',
/* 0x04eb0 = "Support for virtual partitions as not yet been implemented." */
    'S','u','p','p','o','r','t',' ','\x10','v','i','r','t','u','a','l',' ','p','a','r','t','i','t','i','o','n','s',' ','a','s',' ','\x08','y','e','t',' ','\xcb','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x04ee1 = "This particular aspect of the instruction is not yet implemented by IEM." */
    'T','h','i','s',' ','p','a','r','t','i','c','u','l','a','r',' ','a','s','p','e','c','t',' ','\x15','\x02','\xda','\x0b','\x08','y','e','t',' ','i','m','p','l','e','m','e','n','t','e','d',' ','\xe1','I','E','M','.',
/* 0x04f12 = "The ELF image was created for an unsupported target machine type." */
    '\x03','E','L','F',' ','\x26','\x11','c','r','e','a','t','e','d',' ','\x10','\x87','u','n','s','u','p','p','o','r','t','e','d',' ','t','a','r','g','e','t',' ','m','a','c','h','i','n','e',' ','t','y','p','e','.',
/* 0x04f43 = "Page fault caused by dirty bit tracking; corrected." */
    'P','a','g','e',' ','f','a','u','l','t',' ','c','a','u','s','e','d',' ','\xe1','d','i','r','t','y',' ','b','i','t',' ','t','r','a','c','k','i','n','g',';',' ','c','o','r','r','e','c','t','e','d','.',
/* 0x04f74 = "Found file, but it didn\'t match the search criteria." */
    'F','o','u','n','d',' ','f','i','l','e',',',' ','b','u','t',' ','i','t',' ','d','i','d','n','\'','t',' ','m','a','t','c','h',' ','\x02','s','e','a','r','c','h',' ','c','r','i','t','e','r','i','a','.',
/* 0x04fa5 = "Failed to create or connect to a networking interface filter." */
    '\x8b','\x0a','c','r','e','a','t','e',' ','\xa9','c','o','n','n','e','c','t',' ','\x0a','a',' ','n','e','t','w','o','r','k','i','n','g',' ','i','n','t','e','r','f','a','c','e',' ','f','i','l','t','e','r','.',
/* 0x04fd6 = "The segment index specified when adding a new segment is already in use." */
    '\x03','s','e','g','m','e','n','t',' ','i','n','d','e','x',' ','\x18','w','h','e','n',' ','a','d','d','i','n','g',' ','a',' ','n','e','w',' ','s','e','g','m','e','n','t',' ','\x0b','\x7f','\x0f','u','s','e','.',
/* 0x05007 = "The UDP server was shut down using RTUdpServerShutdown." */
    '\x03','U','D','P',' ','s','e','r','v','e','r',' ','\x11','s','h','u','t',' ','d','o','w','n',' ','u','s','i','n','g',' ','R','T','U','d','p','S','e','r','v','e','r','S','h','u','t','d','o','w','n','.',
/* 0x05038 = "Resume guest execution after injecting a double-fault." */
    'R','e','s','u','m','e',' ','\xbb','e','x','e','c','u','t','i','o','n',' ','a','f','t','e','r',' ','i','n','j','e','c','t','i','n','g',' ','a',' ','d','o','u','b','l','e','-','f','a','u','l','t','.',
/* 0x05069 = "The DTB property payload size does not match the expectations." */
    '\x03','D','T','B',' ','p','r','o','p','e','r','t','y',' ','p','a','y','l','o','a','d',' ','s','i','z','e',' ','\xb2','\x08','m','a','t','c','h',' ','\x02','e','x','p','e','c','t','a','t','i','o','n','s','.',
/* 0x0509a = "Certificate path validator: Name constraints does not permits the alternative certificate name." */
    '\xba','\xd0','\xfe','N','a','m','e',' ','c','o','n','s','t','r','a','i','n','t','s',' ','\xb2','\x08','p','e','r','m','i','t','s',' ','\x02','a','l','t','e','r','n','a','t','i','v','e',' ','\xa0','n','a','m','e','.',
/* 0x050cb = "Mismatching SVN revision number between VMMR0 and VBoxVMM." */
    'M','i','s','m','a','t','c','h','i','n','g',' ','S','V','N',' ','r','e','v','i','s','i','o','n',' ','\xfb','b','e','t','w','e','e','n',' ','V','M','M','R','0',' ','\x9a','V','B','o','x','V','M','M','.',
/* 0x050fc = "Sharing violation, file is being used by another process." */
    'S','h','a','r','i','n','g',' ','v','i','o','l','a','t','i','o','n',',',' ','\x1f','\x0b','b','e','i','n','g',' ','u','s','e','d',' ','\xe1','a','n','o','t','h','e','r',' ','p','r','o','c','e','s','s','.',
/* 0x0512d = "Reading from the image was not possible because the offset is out of the image range." */
    'R','e','a','d','i','n','g',' ','f','r','o','m',' ','\x02','\x26','\x11','\x08','p','o','s','s','i','b','l','e',' ','\x40','\x02','o','f','f','s','e','t',' ','\x0b','o','u','t',' ','\x15','\x02','\x26','r','a','n','g','e','.',
/* 0x0515e = "No trace buffer available, please change the VM config." */
    '\xdf','t','r','a','c','e',' ','b','u','f','f','e','r',' ','a','v','a','i','l','a','b','l','e',',',' ','p','l','e','a','s','e',' ','c','h','a','n','g','e',' ','\x02','\xcd',' ','c','o','n','f','i','g','.',
/* 0x0518f = "Process Verification Failure: The memory protection of a image file section does not match what the section header prescribes." */
    '\x1e','\x0d','\x12','\x03','\x86','p','r','o','t','e','c','t','i','o','n',' ','\x15','a',' ','\x26','\x1f','\xdb','\xb2','\x08','m','a','t','c','h',' ','w','h','a','t',' ','\x02','\xdb','\xb3','p','r','e','s','c','r','i','b','e','s','.',
/* 0x051c0 = "Only one PCI function is supported per PDM device." */
    'O','n','l','y',' ','o','n','e',' ','P','C','I',' ','f','u','n','c','t','i','o','n',' ','\x0b','s','u','p','p','o','r','t','e','d',' ','p','e','r',' ','P','D','M',' ','d','e','v','i','c','e','.',
/* 0x051f0 = "Reason for leaving RZ: Defer the owner callback invocation to Ring-3." */
    '\x93','\x10','\x81','R','Z',':',' ','D','e','f','e','r',' ','\x02','o','w','n','e','r',' ','c','a','l','l','b','a','c','k',' ','i','n','v','o','c','a','t','i','o','n',' ','\x0a','R','i','n','g','-','3','.',
/* 0x05220 = "Internal error: Supposedly unreachable default case in a switch." */
    '\x07','\xd8','S','u','p','p','o','s','e','d','l','y',' ','u','n','r','e','a','c','h','a','b','l','e',' ','d','e','f','a','u','l','t',' ','c','a','s','e',' ','\x0f','a',' ','s','w','i','t','c','h','.',
/* 0x05250 = "Syntax error - Couldn\'t satisfy a request for a specific result type." */
    '\xfa','\x09','-',' ','C','o','u','l','d','n','\'','t',' ','s','a','t','i','s','f','y',' ','a',' ','\xaa','\x10','a',' ','s','p','e','c','i','f','i','c',' ','r','e','s','u','l','t',' ','t','y','p','e','.',
/* 0x05280 = "The environment variable has been recorded as being unset." */
    '\x03','e','n','v','i','r','o','n','m','e','n','t',' ','v','a','r','i','a','b','l','e',' ','\x5e','\xcb','r','e','c','o','r','d','e','d',' ','a','s',' ','b','e','i','n','g',' ','u','n','s','e','t','.',
/* 0x052b0 = "Escaped URI character is not a valid UTF-8 lead byte." */
    'E','s','c','a','p','e','d',' ','U','R','I',' ','c','h','a','r','a','c','t','e','r',' ','\x0b','\x08','a',' ','v','a','l','i','d',' ','U','T','F','-','8',' ','l','e','a','d',' ','b','y','t','e','.',
/* 0x052e0 = "An entry in the manifest file couldn\'t be interpreted correctly." */
    'A','n',' ','\xc8','\x0f','\x02','m','a','n','i','f','e','s','t',' ','\x1f','c','o','u','l','d','n','\'','t',' ','\xa7','i','n','t','e','r','p','r','e','t','e','d',' ','c','o','r','r','e','c','t','l','y','.',
/* 0x05310 = "The MMIO handler experienced a problem with the disassembler." */
    '\x03','\xd3',' ','h','a','n','d','l','e','r',' ','e','x','p','e','r','i','e','n','c','e','d',' ','a',' ','p','r','o','b','l','e','m',' ','\x80','\x02','d','i','s','a','s','s','e','m','b','l','e','r','.',
/* 0x05340 = "Hit unimplemented glob pattern matching feature." */
    'H','i','t',' ','u','n','i','m','p','l','e','m','e','n','t','e','d',' ','g','l','o','b',' ','p','a','t','t','e','r','n',' ','m','a','t','c','h','i','n','g',' ','f','e','a','t','u','r','e','.',
/* 0x05370 = "Expected PKCS #7 object to contain exactly on signer info entry." */
    '\xb8','P','K','C','S',' ','#','7',' ','\xa8','\x0a','c','o','n','t','a','i','n',' ','e','x','a','c','t','l','y',' ','o','n',' ','s','i','g','n','e','r',' ','i','n','f','o',' ','e','n','t','r','y','.',
/* 0x053a0 = "Failed to write to a memory region while performing a hypercall." */
    '\x8b','\x0a','w','r','i','t','e',' ','\x0a','a',' ','\x86','r','e','g','i','o','n',' ','w','h','i','l','e',' ','p','e','r','f','o','r','m','i','n','g',' ','a',' ','h','y','p','e','r','c','a','l','l','.',
/* 0x053d0 = "The iprt loader recognized a ELF image, but doesn't support loading it." */
    '\x03','i','p','r','t',' ','\xd9','r','e','c','o','g','n','i','z','e','d',' ','a',' ','E','L','F',' ','i','m','a','g','e',',',' ','b','u','t',' ','\xc7','\xce','l','o','a','d','i','n','g',' ','i','t','.',
/* 0x05400 = "Attempt to recursively enter a non-recursive lock." */
    'A','t','t','e','m','p','t',' ','\x0a','r','e','c','u','r','s','i','v','e','l','y',' ','e','n','t','e','r',' ','a',' ','n','o','n','-','r','e','c','u','r','s','i','v','e',' ','l','o','c','k','.',
/* 0x05430 = "Essential fields in the shared VM structure doesn't match the global one." */
    'E','s','s','e','n','t','i','a','l',' ','f','i','e','l','d','s',' ','\x0f','\x02','s','h','a','r','e','d',' ','\xcd',' ','\xec','\xc7','m','a','t','c','h',' ','\x02','g','l','o','b','a','l',' ','o','n','e','.',
/* 0x05460 = "The DTB structs block contains a malformed padding at the end." */
    '\x03','D','T','B',' ','s','t','r','u','c','t','s',' ','b','l','o','c','k',' ','\x8a','a',' ','m','a','l','f','o','r','m','e','d',' ','p','a','d','d','i','n','g',' ','a','t',' ','\x02','e','n','d','.',
/* 0x05490 = "The VirtualBox version is not supported by one of the extension packs." */
    '\x03','V','i','r','t','u','a','l','B','o','x',' ','\xcf','\x0b','\x08','s','u','p','p','o','r','t','e','d',' ','\xe1','o','n','e',' ','\x15','\x02','e','x','t','e','n','s','i','o','n',' ','p','a','c','k','s','.',
/* 0x054c0 = "VRDP script allowed the packet to be processed further." */
    'V','R','D','P',' ','s','c','r','i','p','t',' ','a','l','l','o','w','e','d',' ','\x02','p','a','c','k','e','t',' ','\x0a','\xa7','p','r','o','c','e','s','s','e','d',' ','f','u','r','t','h','e','r','.',
/* 0x054f0 = "Indicates that we modified the host CR0 (FPU related)." */
    'I','n','d','i','c','a','t','e','s',' ','\xad','w','e',' ','m','o','d','i','f','i','e','d',' ','\x02','h','o','s','t',' ','C','R','0',' ','(','F','P','U',' ','r','e','l','a','t','e','d',')','.',
/* 0x0551f = "The argv[0] of an internal application does not match the executable image path (hardening)." */
    '\x03','a','r','g','v','[','0',']',' ','\x15','\x87','\x16','a','p','p','l','i','c','a','t','i','o','n',' ','\xb2','\x08','m','a','t','c','h',' ','\x02','e','x','e','c','u','t','a','b','l','e',' ','\x26','\xd0','\xae',
/* 0x0554e = "Failed to retrieve a virtual network interface link ID." */
    '\x8b','\x0a','r','e','t','r','i','e','v','e',' ','a',' ','v','i','r','t','u','a','l',' ','n','e','t','w','o','r','k',' ','i','n','t','e','r','f','a','c','e',' ','l','i','n','k',' ','I','D','.',
/* 0x0557d = "The iprt loader recognized a LE image, but doesn't support loading it." */
    '\x03','i','p','r','t',' ','\xd9','r','e','c','o','g','n','i','z','e','d',' ','a',' ','L','E',' ','i','m','a','g','e',',',' ','b','u','t',' ','\xc7','\xce','l','o','a','d','i','n','g',' ','i','t','.',
/* 0x055ac = "The number being converted (string) contained no digits." */
    '\x03','\xfb','b','e','i','n','g',' ','c','o','n','v','e','r','t','e','d',' ','(','s','t','r','i','n','g',')',' ','c','o','n','t','a','i','n','e','d',' ','n','o',' ','d','i','g','i','t','s','.',
/* 0x055db = "The iprt loader recognized a PE image, but doesn't support loading it." */
    '\x03','i','p','r','t',' ','\xd9','r','e','c','o','g','n','i','z','e','d',' ','a',' ','P','E',' ','i','m','a','g','e',',',' ','b','u','t',' ','\xc7','\xce','l','o','a','d','i','n','g',' ','i','t','.',
/* 0x0560a = "The DTB being parsed has an invalid memory reservation block offset." */
    '\x03','D','T','B',' ','b','e','i','n','g',' ','p','a','r','s','e','d',' ','\x5e','\x87','\x8f','\x86','r','e','s','e','r','v','a','t','i','o','n',' ','b','l','o','c','k',' ','o','f','f','s','e','t','.',
/* 0x05639 = "Mismatching VMCPU structure size between VMMR0 and VBoxVMM." */
    'M','i','s','m','a','t','c','h','i','n','g',' ','V','M','C','P','U',' ','\xec','s','i','z','e',' ','b','e','t','w','e','e','n',' ','V','M','M','R','0',' ','\x9a','V','B','o','x','V','M','M','.',
/* 0x05668 = "Someone is trying to write a memory block which is too big to encode." */
    'S','o','m','e','o','n','e',' ','\x0b','t','r','y','i','n','g',' ','\x0a','w','r','i','t','e',' ','a',' ','\x86','b','l','o','c','k',' ','\xed','\x0b','\x9e','b','i','g',' ','\x0a','e','n','c','o','d','e','.',
/* 0x05697 = "Attemted illegal operation in simplified memory management mode." */
    'A','t','t','e','m','t','e','d',' ','i','l','l','e','g','a','l',' ','\x96','\x0f','s','i','m','p','l','i','f','i','e','d',' ','\x86','m','a','n','a','g','e','m','e','n','t',' ','m','o','d','e','.',
/* 0x056c6 = "The iprt loader recognized a MZ image, but doesn't support loading it." */
    '\x03','i','p','r','t',' ','\xd9','r','e','c','o','g','n','i','z','e','d',' ','a',' ','M','Z',' ','i','m','a','g','e',',',' ','b','u','t',' ','\xc7','\xce','l','o','a','d','i','n','g',' ','i','t','.',
/* 0x056f5 = "The iprt loader recognized a NE image, but doesn't support loading it." */
    '\x03','i','p','r','t',' ','\xd9','r','e','c','o','g','n','i','z','e','d',' ','a',' ','N','E',' ','i','m','a','g','e',',',' ','b','u','t',' ','\xc7','\xce','l','o','a','d','i','n','g',' ','i','t','.',
/* 0x05724 = "The iprt loader recognized a LX image, but doesn't support loading it." */
    '\x03','i','p','r','t',' ','\xd9','r','e','c','o','g','n','i','z','e','d',' ','a',' ','L','X',' ','i','m','a','g','e',',',' ','b','u','t',' ','\xc7','\xce','l','o','a','d','i','n','g',' ','i','t','.',
/* 0x05753 = "Got an out of memory condition trying to allocate a string." */
    'G','o','t',' ','\x87','o','u','t',' ','\x15','\x86','c','o','n','d','i','t','i','o','n',' ','t','r','y','i','n','g',' ','\x0a','a','l','l','o','c','a','t','e',' ','a',' ','s','t','r','i','n','g','.',
/* 0x05782 = "VFS chain element only provides file system stream (fss) objects." */
    '\x8d',' ','\xa1','\x5c','o','n','l','y',' ','p','r','o','v','i','d','e','s',' ','\x1f','s','y','s','t','e','m',' ','s','t','r','e','a','m',' ','(','f','s','s',')',' ','o','b','j','e','c','t','s','.',
/* 0x057b1 = "Encountered a unicode code point which cannot be represented as UTF-16." */
    '\xa5','a',' ','u','n','i','c','o','d','e',' ','c','o','d','e',' ','p','o','i','n','t',' ','\xed','\xd1','\xa7','r','e','p','r','e','s','e','n','t','e','d',' ','a','s',' ','U','T','F','-','1','6','.',
/* 0x057e0 = "Certificate path validator: Intermediate certificate is not marked as a certificate authority (CA)." */
    '\xba','\xd0','\xfe','I','n','t','e','r','m','e','d','i','a','t','e',' ','\xa0','\x0b','\x08','m','a','r','k','e','d',' ','a','s',' ','a',' ','\xa0','a','u','t','h','o','r','i','t','y',' ','(','C','A',')','.',
/* 0x0580f = "GVMM does not support the range of CPUs present/possible on the host." */
    'G','V','M','M',' ','\xb2','\x08','\xce','\x02','r','a','n','g','e',' ','\x15','C','P','U','s',' ','p','r','e','s','e','n','t','/','p','o','s','s','i','b','l','e',' ','o','n',' ','\x02','h','o','s','t','.',
/* 0x0583e = "Non fatal Patch Manager analysis phase warning." */
    'N','o','n',' ','f','a','t','a','l',' ','P','a','t','c','h',' ','M','a','n','a','g','e','r',' ','a','n','a','l','y','s','i','s',' ','p','h','a','s','e',' ','w','a','r','n','i','n','g','.',
/* 0x0586d = "Failed to read to a memory region while performing a hypercall." */
    '\x8b','\x0a','r','e','a','d',' ','\x0a','a',' ','\x86','r','e','g','i','o','n',' ','w','h','i','l','e',' ','p','e','r','f','o','r','m','i','n','g',' ','a',' ','h','y','p','e','r','c','a','l','l','.',
/* 0x0589c = "A reboot is needed for completing driver (un)installation." */
    'A',' ','r','e','b','o','o','t',' ','\x0b','n','e','e','d','e','d',' ','\x10','c','o','m','p','l','e','t','i','n','g',' ','\xc5','(','u','n',')','i','n','s','t','a','l','l','a','t','i','o','n','.',
/* 0x058cb = "The version of the driver registration structure is unknown to this VBox version." */
    '\x03','\xcf','\x15','\x02','\xc5','r','e','g','i','s','t','r','a','t','i','o','n',' ','\xec','\x0b','u','n','k','n','o','w','n',' ','\x0a','t','h','i','s',' ','V','B','o','x',' ','v','e','r','s','i','o','n','.',
/* 0x058fa = "Indicating that EM should single step an instruction." */
    'I','n','d','i','c','a','t','i','n','g',' ','\xad','E','M',' ','s','h','o','u','l','d',' ','s','i','n','g','l','e',' ','s','t','e','p',' ','\x87','i','n','s','t','r','u','c','t','i','o','n','.',
/* 0x05929 = "Failed getting cryptographically strong random bytes." */
    '\x8b','g','e','t','t','i','n','g',' ','c','r','y','p','t','o','g','r','a','p','h','i','c','a','l','l','y',' ','s','t','r','o','n','g',' ','r','a','n','d','o','m',' ','b','y','t','e','s','.',
/* 0x05958 = "The OS does not support setting the time stamps on a symbolic link." */
    '\x03','O','S',' ','\xb2','\x08','\xce','s','e','t','t','i','n','g',' ','\x02','t','i','m','e',' ','s','t','a','m','p','s',' ','o','n',' ','a',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k','.',
/* 0x05987 = "The sections aren\'t ordered by segment as expected by the loader." */
    '\x03','s','e','c','t','i','o','n','s',' ','a','r','e','n','\'','t',' ','o','r','d','e','r','e','d',' ','\xe1','s','e','g','m','e','n','t',' ','a','s',' ','\xc9','\xe1','\x02','l','o','a','d','e','r','.',
/* 0x059b6 = "No debug module interpreter matching the debug info." */
    '\xdf','d','e','b','u','g',' ','m','o','d','u','l','e',' ','i','n','t','e','r','p','r','e','t','e','r',' ','m','a','t','c','h','i','n','g',' ','\x02','d','e','b','u','g',' ','i','n','f','o','.',
/* 0x059e5 = "The version of the device registration structure is unknown to this VBox version." */
    '\x03','\xcf','\x15','\x02','\xa3','r','e','g','i','s','t','r','a','t','i','o','n',' ','\xec','\x0b','u','n','k','n','o','w','n',' ','\x0a','t','h','i','s',' ','V','B','o','x',' ','v','e','r','s','i','o','n','.',
/* 0x05a14 = "The session has reached the max number of (user mode) providers." */
    '\x03','s','e','s','s','i','o','n',' ','\x5e','r','e','a','c','h','e','d',' ','\x02','m','a','x',' ','\xfb','\x15','(','u','s','e','r',' ','m','o','d','e',')',' ','p','r','o','v','i','d','e','r','s','.',
/* 0x05a43 = "Malformed partition map table in the logical volume descriptor." */
    'M','a','l','f','o','r','m','e','d',' ','p','a','r','t','i','t','i','o','n',' ','m','a','p',' ','\xb1','\x0f','\x02','l','o','g','i','c','a','l',' ','\xd2','d','e','s','c','r','i','p','t','o','r','.',
/* 0x05a72 = "The hash is too long for the key used when signing/verifying." */
    '\x03','h','a','s','h',' ','\x0b','\x9e','l','o','n','g',' ','\x10','\x02','k','e','y',' ','u','s','e','d',' ','w','h','e','n',' ','s','i','g','n','i','n','g','/','v','e','r','i','f','y','i','n','g','.',
/* 0x05aa1 = "Negative exponent makes no sense to integer math." */
    'N','e','g','a','t','i','v','e',' ','e','x','p','o','n','e','n','t',' ','m','a','k','e','s',' ','n','o',' ','s','e','n','s','e',' ','\x0a','i','n','t','e','g','e','r',' ','m','a','t','h','.',
/* 0x05ad0 = "Failed to create a virtual network interface instance." */
    '\x8b','\x0a','c','r','e','a','t','e',' ','a',' ','v','i','r','t','u','a','l',' ','n','e','t','w','o','r','k',' ','i','n','t','e','r','f','a','c','e',' ','i','n','s','t','a','n','c','e','.',
/* 0x05afe = "The specified I/O port range was owned by some other device(s)." */
    '\x03','\x18','I','/','O',' ','p','o','r','t',' ','r','a','n','g','e',' ','\x11','o','w','n','e','d',' ','\xe1','s','o','m','e',' ','o','t','h','e','r',' ','d','e','v','i','c','e','(','s',')','.',
/* 0x05b2c = "A break was detected until all requested data could be received." */
    'A',' ','b','r','e','a','k',' ','\x11','d','e','t','e','c','t','e','d',' ','u','n','t','i','l',' ','a','l','l',' ','\xde','\x9d','c','o','u','l','d',' ','\xa7','r','e','c','e','i','v','e','d','.',
/* 0x05b5a = "Unfinished CodeView debug information feature." */
    'U','n','f','i','n','i','s','h','e','d',' ','C','o','d','e','V','i','e','w',' ','d','e','b','u','g',' ','i','n','f','o','r','m','a','t','i','o','n',' ','f','e','a','t','u','r','e','.',
/* 0x05b88 = "The Host Interface Networking terminate program failed." */
    '\x03','H','o','s','t',' ','I','n','t','e','r','f','a','c','e',' ','N','e','t','w','o','r','k','i','n','g',' ','t','e','r','m','i','n','a','t','e',' ','p','r','o','g','r','a','m',' ','\x7b',
/* 0x05bb6 = "Import ISO contains a directory record with a mismatching volume sequence number." */
    '\xc3','\xc1',' ','\x8a','a',' ','\x25','r','e','c','o','r','d',' ','\x80','a',' ','m','i','s','m','a','t','c','h','i','n','g',' ','\xd2','s','e','q','u','e','n','c','e',' ','n','u','m','b','e','r','.',
/* 0x05be4 = "An EMT called an API which cannot be called on such a thread." */
    'A','n',' ','E','M','T',' ','c','a','l','l','e','d',' ','\x87','A','P','I',' ','\xed','\xd1','\xa7','c','a','l','l','e','d',' ','o','n',' ','s','u','c','h',' ','a',' ','t','h','r','e','a','d','.',
/* 0x05c12 = "The auto usage cache for the dynamic mapping set is full." */
    '\x03','a','u','t','o',' ','u','s','a','g','e',' ','c','a','c','h','e',' ','\x10','\x02','d','y','n','a','m','i','c',' ','m','a','p','p','i','n','g',' ','s','e','t',' ','\x0b','f','u','l','l','.',
/* 0x05c40 = "The DTB property name offset points past the string block." */
    '\x03','D','T','B',' ','p','r','o','p','e','r','t','y',' ','n','a','m','e',' ','o','f','f','s','e','t',' ','p','o','i','n','t','s',' ','p','a','s','t',' ','\x02','\xf2','b','l','o','c','k','.',
/* 0x05c6e = "Missing relative distinguished name map entry." */
    'M','i','s','s','i','n','g',' ','r','e','l','a','t','i','v','e',' ','d','i','s','t','i','n','g','u','i','s','h','e','d',' ','n','a','m','e',' ','m','a','p',' ','e','n','t','r','y','.',
/* 0x05c9c = "Unsupported create type in an RTVfsObjOpen or RTVfsDirOpenObj call." */
    '\x98','c','r','e','a','t','e',' ','\xf3','\x0f','\x87','R','T','V','f','s','O','b','j','O','p','e','n',' ','\xa9','R','T','V','f','s','D','i','r','O','p','e','n','O','b','j',' ','c','a','l','l','.',
/* 0x05cca = "The boot catalog validation entry in the import ISO has incorrect keys." */
    '\x03','b','o','o','t',' ','\xe7','v','a','l','i','d','a','t','i','o','n',' ','\xc8','\x0f','\x02','i','m','p','o','r','t',' ','\xc1',' ','\x5e','i','n','c','o','r','r','e','c','t',' ','k','e','y','s','.',
/* 0x05cf8 = "VMPTRLD failed; possibly because of invalid VMCS launch-state." */
    'V','M','P','T','R','L','D',' ','f','a','i','l','e','d',';',' ','p','o','s','s','i','b','l','y',' ','\x40','\x15','\x8f','V','M','C','S',' ','l','a','u','n','c','h','-','s','t','a','t','e','.',
/* 0x05d26 = "Couldn\'t find any free USB ports to attach the device to." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','a','n','y',' ','f','r','e','e',' ','U','S','B',' ','p','o','r','t','s',' ','\x0a','a','t','t','a','c','h',' ','\x02','\xa3','t','o','.',
/* 0x05d54 = "The group is a non-system group and it has write access (hardening)." */
    '\x03','g','r','o','u','p',' ','\x0b','a',' ','n','o','n','-','s','y','s','t','e','m',' ','g','r','o','u','p',' ','\x9a','i','t',' ','\x5e','w','r','i','t','e',' ','a','c','c','e','s','s',' ','\xae',
/* 0x05d82 = "Not possible to attach further drivers to the driver." */
    'N','o','t',' ','p','o','s','s','i','b','l','e',' ','\x0a','a','t','t','a','c','h',' ','f','u','r','t','h','e','r',' ','d','r','i','v','e','r','s',' ','\x0a','\x02','d','r','i','v','e','r','.',
/* 0x05db0 = "Server response contains unexpected repetitive header field." */
    'S','e','r','v','e','r',' ','r','e','s','p','o','n','s','e',' ','\x8a','u','n','e','x','p','e','c','t','e','d',' ','r','e','p','e','t','i','t','i','v','e',' ','\xb3','f','i','e','l','d','.',
/* 0x05dde = "Unknown error while reading the guest GDT during shadow table updating." */
    '\xef','\x09','w','h','i','l','e',' ','r','e','a','d','i','n','g',' ','\x02','\xbb','G','D','T',' ','d','u','r','i','n','g',' ','s','h','a','d','o','w',' ','\xb1','u','p','d','a','t','i','n','g','.',
/* 0x05e0c = "The configuration constructor in main failed due to a COM error." */
    '\x03','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','c','o','n','s','t','r','u','c','t','o','r',' ','\x0f','m','a','i','n',' ','\x99','d','u','e',' ','\x0a','a',' ','C','O','M',' ','\x85',
/* 0x05e3a = "Not able satisfy all the requirements of the request." */
    'N','o','t',' ','a','b','l','e',' ','s','a','t','i','s','f','y',' ','a','l','l',' ','\x02','r','e','q','u','i','r','e','m','e','n','t','s',' ','\x15','\x02','r','e','q','u','e','s','t','.',
/* 0x05e67 = "Somebody cleared X86_CR4_VMXE in the CR4 register." */
    'S','o','m','e','b','o','d','y',' ','c','l','e','a','r','e','d',' ','X','8','6','_','C','R','4','_','V','M','X','E',' ','\x0f','\x02','C','R','4',' ','r','e','g','i','s','t','e','r','.',
/* 0x05e94 = "The message digest of the extracted data does not match the one supplied." */
    '\x03','m','e','s','s','a','g','e',' ','\xd7','\x15','\x02','e','x','t','r','a','c','t','e','d',' ','\x9d','\xb2','\x08','m','a','t','c','h',' ','\x02','o','n','e',' ','s','u','p','p','l','i','e','d','.',
/* 0x05ec1 = "The PE loader doesn't know how to deal with the global pointer data directory entry yet." */
    '\x03','P','E',' ','\xd9','\xc7','k','n','o','w',' ','h','o','w',' ','\x0a','d','e','a','l',' ','\x80','\x02','g','l','o','b','a','l',' ','p','o','i','n','t','e','r',' ','\x9d','\x25','\xc8','y','e','t','.',
/* 0x05eee = "The digest algorithm in the SignerInfo does not match the one in the indirect data." */
    '\x03','\xd7','\xd4','\x0f','\x02','S','i','g','n','e','r','I','n','f','o',' ','\xb2','\x08','m','a','t','c','h',' ','\x02','o','n','e',' ','\x0f','\x02','i','n','d','i','r','e','c','t',' ','d','a','t','a','.',
/* 0x05f1b = "Image Verification Failure: Error reading authenticode signature data." */
    'I','m','a','g','e',' ','\x0d','\x12','\xc0','r','e','a','d','i','n','g',' ','a','u','t','h','e','n','t','i','c','o','d','e',' ','s','i','g','n','a','t','u','r','e',' ','d','a','t','a','.',
/* 0x05f48 = "RTDirReadEx() failed to retrieve the extra data which was requested." */
    'R','T','D','i','r','R','e','a','d','E','x','(',')',' ','\x99','\x0a','r','e','t','r','i','e','v','e',' ','\x02','e','x','t','r','a',' ','\x9d','\xed','\x11','r','e','q','u','e','s','t','e','d','.',
/* 0x05f75 = "Maximum number of Shared Clipboard objects has been reached." */
    'M','a','x','i','m','u','m',' ','\xfb','\x15','S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','o','b','j','e','c','t','s',' ','\x5e','\xcb','r','e','a','c','h','e','d','.',
/* 0x05fa2 = "A path is not relative (start with root), expected an relative path." */
    'A',' ','\xd0','\x0b','\x08','r','e','l','a','t','i','v','e',' ','(','s','t','a','r','t',' ','\x80','r','o','o','t',')',',',' ','\xc9','\x87','r','e','l','a','t','i','v','e',' ','p','a','t','h','.',
/* 0x05fcf = "PKCS #7 singer info contains no issuer serial number." */
    'P','K','C','S',' ','#','7',' ','s','i','n','g','e','r',' ','i','n','f','o',' ','\x8a','n','o',' ','i','s','s','u','e','r',' ','s','e','r','i','a','l',' ','n','u','m','b','e','r','.',
/* 0x05ffc = "IOMGCIOPortHandler was given an unexpected opcode." */
    'I','O','M','G','C','I','O','P','o','r','t','H','a','n','d','l','e','r',' ','\x11','g','i','v','e','n',' ','\x87','u','n','e','x','p','e','c','t','e','d',' ','o','p','c','o','d','e','.',
/* 0x06029 = "iSCSI: Operation can\'t be done in current image state." */
    'i','S','C','S','I',':',' ','O','p','e','r','a','t','i','o','n',' ','c','a','n','\'','t',' ','\xa7','d','o','n','e',' ','\x0f','c','u','r','r','e','n','t',' ','\x26','s','t','a','t','e','.',
/* 0x06056 = "The image is 32-bit and contains 64-bit load commands or vise versa." */
    '\x03','\x26','\x0b','3','2','-','b','i','t',' ','\x9a','\x8a','6','4','-','b','i','t',' ','l','o','a','d',' ','c','o','m','m','a','n','d','s',' ','\xa9','v','i','s','e',' ','v','e','r','s','a','.',
/* 0x06083 = "Unexpected PCI region change during VGA saved state loading." */
    '\x94','P','C','I',' ','r','e','g','i','o','n',' ','c','h','a','n','g','e',' ','d','u','r','i','n','g',' ','V','G','A',' ','s','a','v','e','d',' ','\xca','l','o','a','d','i','n','g','.',
/* 0x060b0 = "The server has not found anything matching the URI given." */
    '\x03','s','e','r','v','e','r',' ','\x5e','\x08','f','o','u','n','d',' ','a','n','y','t','h','i','n','g',' ','m','a','t','c','h','i','n','g',' ','\x02','U','R','I',' ','g','i','v','e','n','.',
/* 0x060dd = "Escaped URI characters does not decode to valid UTF-8." */
    'E','s','c','a','p','e','d',' ','U','R','I',' ','c','h','a','r','a','c','t','e','r','s',' ','\xb2','\x08','d','e','c','o','d','e',' ','\x0a','v','a','l','i','d',' ','U','T','F','-','8','.',
/* 0x0610a = "The RAM size differs between the saved state and the VM config." */
    '\x03','R','A','M',' ','s','i','z','e',' ','d','i','f','f','e','r','s',' ','b','e','t','w','e','e','n',' ','\x02','s','a','v','e','d',' ','\xca','\x9a','\x02','\xcd',' ','c','o','n','f','i','g','.',
/* 0x06137 = "Process Verification Failure: The name of an image file changes between mapping regions." */
    '\x1e','\x0d','\x12','\x03','n','a','m','e',' ','\x15','\x87','\x26','\x1f','c','h','a','n','g','e','s',' ','b','e','t','w','e','e','n',' ','m','a','p','p','i','n','g',' ','r','e','g','i','o','n','s','.',
/* 0x06164 = "The page is unassigned (akin to VERR_PGM_INVALID_GC_PHYSICAL_ADDRESS)." */
    '\x03','\xcc','\x0b','u','n','a','s','s','i','g','n','e','d',' ','(','a','k','i','n',' ','\x0a','\x01','\x8c','\x05','G','C','_','P','H','Y','S','I','C','A','L','_','A','D','D','R','E','S','S',')','.',
/* 0x06191 = "The specified I/O port range intruded on an existing range." */
    '\x03','\x18','I','/','O',' ','p','o','r','t',' ','r','a','n','g','e',' ','i','n','t','r','u','d','e','d',' ','o','n',' ','\x87','e','x','i','s','t','i','n','g',' ','r','a','n','g','e','.',
/* 0x061be = "The user mode tracepoint provider string table offset is bad." */
    '\x03','u','s','e','r',' ','m','o','d','e',' ','t','r','a','c','e','p','o','i','n','t',' ','p','r','o','v','i','d','e','r',' ','\xf2','\xb1','o','f','f','s','e','t',' ','\x0b','b','a','d','.',
/* 0x061eb = "The I/O queue is full and can\'t accept more requests." */
    '\x03','I','/','O',' ','q','u','e','u','e',' ','\x0b','f','u','l','l',' ','\x9a','c','a','n','\'','t',' ','a','c','c','e','p','t',' ','m','o','r','e',' ','r','e','q','u','e','s','t','s','.',
/* 0x06218 = "Repairing the image is not possible because the corruption is to severe." */
    'R','e','p','a','i','r','i','n','g',' ','\x02','\x26','\x0b','\x08','p','o','s','s','i','b','l','e',' ','\x40','\x02','c','o','r','r','u','p','t','i','o','n',' ','\x0b','\x0a','s','e','v','e','r','e','.',
/* 0x06245 = "RTGetOpt: Command line option needs argument." */
    'R','T','G','e','t','O','p','t',':',' ','C','o','m','m','a','n','d',' ','l','i','n','e',' ','o','p','t','i','o','n',' ','n','e','e','d','s',' ','a','r','g','u','m','e','n','t','.',
/* 0x06272 = "VFS chain element only provides file and I/O stream (ios) objects." */
    '\x8d',' ','\xa1','\x5c','o','n','l','y',' ','p','r','o','v','i','d','e','s',' ','\x1f','\x9a','I','/','O',' ','s','t','r','e','a','m',' ','(','i','o','s',')',' ','o','b','j','e','c','t','s','.',
/* 0x0629f = "Digest algorithm parameters are not supported by the PKCS #7 code." */
    'D','i','g','e','s','t',' ','\xd4','p','a','r','a','m','e','t','e','r','s',' ','a','r','e',' ','\x08','s','u','p','p','o','r','t','e','d',' ','\xe1','\x02','P','K','C','S',' ','#','7',' ','\x84',
/* 0x062cc = "The default boot catalog entry in the import ISO an invalid boot indicator value." */
    '\x03','d','e','f','a','u','l','t',' ','b','o','o','t',' ','\xe7','\xc8','\x0f','\x02','i','m','p','o','r','t',' ','\xc1',' ','\x87','\x8f','b','o','o','t',' ','i','n','d','i','c','a','t','o','r',' ','\xe8',
/* 0x062f9 = "The intercepted operation was not handled, take default action." */
    '\x03','i','n','t','e','r','c','e','p','t','e','d',' ','\x96','\x11','\x08','h','a','n','d','l','e','d',',',' ','t','a','k','e',' ','d','e','f','a','u','l','t',' ','a','c','t','i','o','n','.',
/* 0x06326 = "The lock validator detected an existing deadlock." */
    '\x03','l','o','c','k',' ','v','a','l','i','d','a','t','o','r',' ','d','e','t','e','c','t','e','d',' ','\x87','e','x','i','s','t','i','n','g',' ','d','e','a','d','l','o','c','k','.',
/* 0x06352 = "The provided password to decrypt the DEK was incorrect." */
    '\x03','p','r','o','v','i','d','e','d',' ','p','a','s','s','w','o','r','d',' ','\x0a','d','e','c','r','y','p','t',' ','\x02','D','E','K',' ','\x11','i','n','c','o','r','r','e','c','t','.',
/* 0x0637e = "The EVP_PKEY_CTX_set_rsa_padding API in OpenSSL failed." */
    '\x03','E','V','P','_','P','K','E','Y','_','C','T','X','_','s','e','t','_','r','s','a','_','p','a','d','d','i','n','g',' ','A','P','I',' ','\x0f','O','p','e','n','S','S','L',' ','\x7b',
/* 0x063aa = "PKIX signature no does not match up to the current data." */
    'P','K','I','X',' ','s','i','g','n','a','t','u','r','e',' ','n','o',' ','\xb2','\x08','m','a','t','c','h',' ','u','p',' ','\x0a','\x02','c','u','r','r','e','n','t',' ','d','a','t','a','.',
/* 0x063d6 = "Maximum (context ID object) count has been reached." */
    'M','a','x','i','m','u','m',' ','(','c','o','n','t','e','x','t',' ','I','D',' ','o','b','j','e','c','t',')',' ','c','o','u','n','t',' ','\x5e','\xcb','r','e','a','c','h','e','d','.',
/* 0x06402 = "Page hash table is too long (covers signature data, i." */
    'P','a','g','e',' ','h','a','s','h',' ','\xb1','\x0b','\x9e','l','o','n','g',' ','(','c','o','v','e','r','s',' ','s','i','g','n','a','t','u','r','e',' ','d','a','t','a',',',' ','i','.',
/* 0x0642e = "Failed to open a virtual network interface instance." */
    '\x8b','\x0a','o','p','e','n',' ','a',' ','v','i','r','t','u','a','l',' ','n','e','t','w','o','r','k',' ','i','n','t','e','r','f','a','c','e',' ','i','n','s','t','a','n','c','e','.',
/* 0x0645a = "Import ISO contains a root directory with a mismatching volume sequence number." */
    '\xc3','\xc1',' ','\x8a','a',' ','r','o','o','t',' ','\x25','\x80','a',' ','m','i','s','m','a','t','c','h','i','n','g',' ','\xd2','s','e','q','u','e','n','c','e',' ','n','u','m','b','e','r','.',
/* 0x06486 = "A numeric tar header field was not terminated correctly." */
    'A',' ','n','u','m','e','r','i','c',' ','t','a','r',' ','\xb3','f','i','e','l','d',' ','\x11','\x08','t','e','r','m','i','n','a','t','e','d',' ','c','o','r','r','e','c','t','l','y','.',
/* 0x064b2 = "The media is not mounted, operation requires a mounted media." */
    '\x03','m','e','d','i','a',' ','\x0b','\x08','m','o','u','n','t','e','d',',',' ','\x96','r','e','q','u','i','r','e','s',' ','a',' ','m','o','u','n','t','e','d',' ','m','e','d','i','a','.',
/* 0x064de = "A boot catalog entry in the import ISO has an image with an indeterminate size." */
    'A',' ','b','o','o','t',' ','\xe7','\xc8','\x0f','\x02','i','m','p','o','r','t',' ','\xc1',' ','\x5e','\x87','\x26','\x80','\x87','i','n','d','e','t','e','r','m','i','n','a','t','e',' ','s','i','z','e','.',
/* 0x0650a = "Failed to fix mappings because a mapping rejected the address." */
    '\x8b','\x0a','f','i','x',' ','m','a','p','p','i','n','g','s',' ','\x40','a',' ','m','a','p','p','i','n','g',' ','r','e','j','e','c','t','e','d',' ','\x02','a','d','d','r','e','s','s','.',
/* 0x06536 = "Maximum (context ID) sessions have been reached." */
    'M','a','x','i','m','u','m',' ','(','c','o','n','t','e','x','t',' ','I','D',')',' ','s','e','s','s','i','o','n','s',' ','h','a','v','e',' ','\xcb','r','e','a','c','h','e','d','.',
/* 0x06562 = "Error while characters translation (unicode and so)." */
    '\xc0','w','h','i','l','e',' ','c','h','a','r','a','c','t','e','r','s',' ','t','r','a','n','s','l','a','t','i','o','n',' ','(','u','n','i','c','o','d','e',' ','\x9a','s','o',')','.',
/* 0x0658e = "The ring-0 function is not supported for this VM target." */
    '\x03','r','i','n','g','-','0',' ','f','u','n','c','t','i','o','n',' ','\x0b','\x08','s','u','p','p','o','r','t','e','d',' ','\x10','t','h','i','s',' ','\xcd',' ','t','a','r','g','e','t','.',
/* 0x065ba = "There are unconsumed bytes after decoding an ASN." */
    'T','h','e','r','e',' ','a','r','e',' ','u','n','c','o','n','s','u','m','e','d',' ','b','y','t','e','s',' ','a','f','t','e','r',' ','d','e','c','o','d','i','n','g',' ','\x87','\xf6',
/* 0x065e6 = "(One) receive buffer was too small, or too few buffers." */
    '(','O','n','e',')',' ','r','e','c','e','i','v','e',' ','b','u','f','f','e','r',' ','\x11','\x9e','s','m','a','l','l',',',' ','\xa9','\x9e','f','e','w',' ','b','u','f','f','e','r','s','.',
/* 0x06612 = "Server response contains embedded zero character(s)." */
    'S','e','r','v','e','r',' ','r','e','s','p','o','n','s','e',' ','\x8a','e','m','b','e','d','d','e','d',' ','z','e','r','o',' ','c','h','a','r','a','c','t','e','r','(','s',')','.',
/* 0x0663e = "Too many readers on read/write critical section." */
    'T','o','o',' ','\xb4','r','e','a','d','e','r','s',' ','o','n',' ','r','e','a','d','/','w','r','i','t','e',' ','c','r','i','t','i','c','a','l',' ','s','e','c','t','i','o','n','.',
/* 0x0666a = "VFS chain element takes a directory (dir) or file system (vfs) object as input." */
    '\x8d',' ','\xa1','\x5c','t','a','k','e','s',' ','a',' ','\x25','(','d','i','r',')',' ','\xa9','\x1f','s','y','s','t','e','m',' ','(','v','f','s',')',' ','\xa8','a','s',' ','i','n','p','u','t','.',
/* 0x06696 = "The state doesn't match the VM configuration in one or another way." */
    '\x03','\xca','\xc7','m','a','t','c','h',' ','\x02','\xcd',' ','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','\x0f','o','n','e',' ','\xa9','a','n','o','t','h','e','r',' ','w','a','y','.',
/* 0x066c2 = "VMDK: Operation can\'t be done in current image state." */
    'V','M','D','K',':',' ','O','p','e','r','a','t','i','o','n',' ','c','a','n','\'','t',' ','\xa7','d','o','n','e',' ','\x0f','c','u','r','r','e','n','t',' ','\x26','s','t','a','t','e','.',
/* 0x066ee = "Recording has been throttled due to current settings." */
    'R','e','c','o','r','d','i','n','g',' ','\x5e','\xcb','t','h','r','o','t','t','l','e','d',' ','d','u','e',' ','\x0a','c','u','r','r','e','n','t',' ','s','e','t','t','i','n','g','s','.',
/* 0x0671a = "SSM did a callback for a pass we didn\'t expect." */
    'S','S','M',' ','d','i','d',' ','a',' ','c','a','l','l','b','a','c','k',' ','\x10','a',' ','p','a','s','s',' ','w','e',' ','d','i','d','n','\'','t',' ','e','x','p','e','c','t','.',
/* 0x06746 = "Recording is not possible due to a set restriction." */
    'R','e','c','o','r','d','i','n','g',' ','\x0b','\x08','p','o','s','s','i','b','l','e',' ','d','u','e',' ','\x0a','a',' ','s','e','t',' ','r','e','s','t','r','i','c','t','i','o','n','.',
/* 0x06772 = "The message digest of the archived data does not match the one supplied." */
    '\x03','m','e','s','s','a','g','e',' ','\xd7','\x15','\x02','a','r','c','h','i','v','e','d',' ','\x9d','\xb2','\x08','m','a','t','c','h',' ','\x02','o','n','e',' ','s','u','p','p','l','i','e','d','.',
/* 0x0679e = "The nested-guest #VMEXIT processing failed, initiate shutdown." */
    '\x03','n','e','s','t','e','d','-','\xbb','#','V','M','E','X','I','T',' ','\x04','f','a','i','l','e','d',',',' ','i','n','i','t','i','a','t','e',' ','s','h','u','t','d','o','w','n','.',
/* 0x067ca = "Failed to fix mappings because of a conflict with the intermediate code." */
    '\x8b','\x0a','f','i','x',' ','m','a','p','p','i','n','g','s',' ','\x40','\x15','a',' ','c','o','n','f','l','i','c','t',' ','\x80','\x02','i','n','t','e','r','m','e','d','i','a','t','e',' ','\x84',
/* 0x067f6 = "Import ISO uses a logical block size other than 2KB." */
    '\xc3','\xc1',' ','u','s','e','s',' ','a',' ','l','o','g','i','c','a','l',' ','b','l','o','c','k',' ','s','i','z','e',' ','o','t','h','e','r',' ','t','h','a','n',' ','2','K','B','.',
/* 0x06822 = "Exclusive semaphore is owned by another process." */
    'E','x','c','l','u','s','i','v','e',' ','s','e','m','a','p','h','o','r','e',' ','\x0b','o','w','n','e','d',' ','\xe1','a','n','o','t','h','e','r',' ','p','r','o','c','e','s','s','.',
/* 0x0684e = "Reason for leaving RC: Guest tried to write to our TSS - fatal." */
    '\x93','\x10','\x81','R','C',':',' ','G','u','e','s','t',' ','t','r','i','e','d',' ','\x0a','w','r','i','t','e',' ','\x0a','o','u','r',' ','T','S','S',' ','-',' ','f','a','t','a','l','.',
/* 0x06879 = "Error extracting a public key from the certificate." */
    '\xc0','e','x','t','r','a','c','t','i','n','g',' ','a',' ','p','u','b','l','i','c',' ','k','e','y',' ','f','r','o','m',' ','\x02','c','e','r','t','i','f','i','c','a','t','e','.',
/* 0x068a4 = "The maximum posts for the event semaphore has been reached." */
    '\x03','m','a','x','i','m','u','m',' ','p','o','s','t','s',' ','\x10','\x02','e','v','e','n','t',' ','s','e','m','a','p','h','o','r','e',' ','\x5e','\xcb','r','e','a','c','h','e','d','.',
/* 0x068cf = "EVP_CIPHER_CTX_ctrl EVP_CTRL_AEAD_GET_TAG failed." */
    'E','V','P','_','C','I','P','H','E','R','_','C','T','X','_','c','t','r','l',' ','E','V','P','_','C','T','R','L','_','A','E','A','D','_','G','E','T','_','T','A','G',' ','\x7b',
/* 0x068fa = "Too many writes on read/write critical section." */
    'T','o','o',' ','\xb4','w','r','i','t','e','s',' ','o','n',' ','r','e','a','d','/','w','r','i','t','e',' ','c','r','i','t','i','c','a','l',' ','s','e','c','t','i','o','n','.',
/* 0x06925 = "Ran out of memory while compressing or uncompressing." */
    'R','a','n',' ','o','u','t',' ','\x15','\x86','w','h','i','l','e',' ','c','o','m','p','r','e','s','s','i','n','g',' ','\xa9','u','n','c','o','m','p','r','e','s','s','i','n','g','.',
/* 0x06950 = "Reason for leaving RC: Guest tried to write to our GDT - fatal." */
    '\x93','\x10','\x81','R','C',':',' ','G','u','e','s','t',' ','t','r','i','e','d',' ','\x0a','w','r','i','t','e',' ','\x0a','o','u','r',' ','G','D','T',' ','-',' ','f','a','t','a','l','.',
/* 0x0697b = "Maximum (context ID) objects have been reached." */
    'M','a','x','i','m','u','m',' ','(','c','o','n','t','e','x','t',' ','I','D',')',' ','o','b','j','e','c','t','s',' ','h','a','v','e',' ','\xcb','r','e','a','c','h','e','d','.',
/* 0x069a6 = "Unexpected instruction encountered for which there is no patch strategy implemented (hardening)." */
    '\x94','\xda','\xaf','\x10','\xed','t','h','e','r','e',' ','\x0b','n','o',' ','p','a','t','c','h',' ','s','t','r','a','t','e','g','y',' ','i','m','p','l','e','m','e','n','t','e','d',' ','\xae',
/* 0x069d1 = "Address family not supported by protocol family." */
    'A','d','d','r','e','s','s',' ','f','a','m','i','l','y',' ','\x08','s','u','p','p','o','r','t','e','d',' ','\xe1','p','r','o','t','o','c','o','l',' ','f','a','m','i','l','y','.',
/* 0x069fc = "Reason for leaving RC: Guest tried to write to our IDT - fatal." */
    '\x93','\x10','\x81','R','C',':',' ','G','u','e','s','t',' ','t','r','i','e','d',' ','\x0a','w','r','i','t','e',' ','\x0a','o','u','r',' ','I','D','T',' ','-',' ','f','a','t','a','l','.',
/* 0x06a27 = "Too many digest algorithms used by PKCS #7 signed data." */
    'T','o','o',' ','\xb4','\xd7','a','l','g','o','r','i','t','h','m','s',' ','u','s','e','d',' ','\xe1','P','K','C','S',' ','#','7',' ','s','i','g','n','e','d',' ','d','a','t','a','.',
/* 0x06a52 = "Partition mapping table is shorted than described." */
    'P','a','r','t','i','t','i','o','n',' ','m','a','p','p','i','n','g',' ','\xb1','\x0b','s','h','o','r','t','e','d',' ','t','h','a','n',' ','d','e','s','c','r','i','b','e','d','.',
/* 0x06a7d = "EVP_CIPHER_CTX_ctrl EVP_CTRL_AEAD_SET_TAG failed." */
    'E','V','P','_','C','I','P','H','E','R','_','C','T','X','_','c','t','r','l',' ','E','V','P','_','C','T','R','L','_','A','E','A','D','_','S','E','T','_','T','A','G',' ','\x7b',
/* 0x06aa8 = "Syntax error - an argument or subargument contains nothing useful." */
    '\xfa','\x09','-',' ','\x87','a','r','g','u','m','e','n','t',' ','\xa9','s','u','b','a','r','g','u','m','e','n','t',' ','\x8a','n','o','t','h','i','n','g',' ','u','s','e','f','u','l','.',
/* 0x06ad3 = "The PCI bus assigned to a device didn\'t have room for it." */
    '\x03','P','C','I',' ','b','u','s',' ','a','s','s','i','g','n','e','d',' ','\x0a','a',' ','\xa3','d','i','d','n','\'','t',' ','h','a','v','e',' ','r','o','o','m',' ','\x10','i','t','.',
/* 0x06afe = "Unknown paritition ID found in the partition map table." */
    '\xef','p','a','r','i','t','i','t','i','o','n',' ','I','D',' ','f','o','u','n','d',' ','\x0f','\x02','p','a','r','t','i','t','i','o','n',' ','m','a','p',' ','t','a','b','l','e','.',
/* 0x06b29 = "VFS chain element only provides I/O stream (ios) objects." */
    '\x8d',' ','\xa1','\x5c','o','n','l','y',' ','p','r','o','v','i','d','e','s',' ','I','/','O',' ','s','t','r','e','a','m',' ','(','i','o','s',')',' ','o','b','j','e','c','t','s','.',
/* 0x06b54 = "Another thread in the session is talking to the tracer." */
    'A','n','o','t','h','e','r',' ','t','h','r','e','a','d',' ','\x0f','\x02','s','e','s','s','i','o','n',' ','\x0b','t','a','l','k','i','n','g',' ','\x0a','\x02','t','r','a','c','e','r','.',
/* 0x06b7f = "Authentication failed (ISessionManager::logon())." */
    'A','u','t','h','e','n','t','i','c','a','t','i','o','n',' ','\x99','(','I','S','e','s','s','i','o','n','M','a','n','a','g','e','r',':',':','l','o','g','o','n','(',')',')','.',
/* 0x06baa = "Invalid effective segment register number passed to an IEM function." */
    '\x0c','e','f','f','e','c','t','i','v','e',' ','s','e','g','m','e','n','t',' ','\xeb','\xfb','p','a','s','s','e','d',' ','\x0a','\x87','I','E','M',' ','f','u','n','c','t','i','o','n','.',
/* 0x06bd5 = "Maximum number of Shared Clipboard lists has been reached." */
    'M','a','x','i','m','u','m',' ','\xfb','\x15','S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','l','i','s','t','s',' ','\x5e','\xcb','r','e','a','c','h','e','d','.',
/* 0x06c00 = "Unable to locate a usable DMG file within the XAR archive." */
    '\xe0','\x0a','l','o','c','a','t','e',' ','a',' ','u','s','a','b','l','e',' ','D','M','G',' ','\x1f','w','i','t','h','i','n',' ','\x02','X','A','R',' ','a','r','c','h','i','v','e','.',
/* 0x06c2b = "The image file is not owned by TrustedInstaller is it should be." */
    '\x03','\x26','\x1f','\x0b','\x08','o','w','n','e','d',' ','\xe1','T','r','u','s','t','e','d','I','n','s','t','a','l','l','e','r',' ','\x0b','i','t',' ','s','h','o','u','l','d',' ','b','e','.',
/* 0x06c56 = "The previous ownership of this semaphore has ended." */
    '\x03','p','r','e','v','i','o','u','s',' ','o','w','n','e','r','s','h','i','p',' ','\x15','t','h','i','s',' ','s','e','m','a','p','h','o','r','e',' ','\x5e','e','n','d','e','d','.',
/* 0x06c81 = "A string claiming to be in UTF-16 is incorrectly encoded." */
    'A',' ','\xf2','c','l','a','i','m','i','n','g',' ','\x0a','\xa7','\x0f','U','T','F','-','1','6',' ','\x0b','i','n','c','o','r','r','e','c','t','l','y',' ','e','n','c','o','d','e','d','.',
/* 0x06cac = "A bad trap type ended up in mmGCRamTrap0eHandler." */
    'A',' ','b','a','d',' ','t','r','a','p',' ','\xf3','e','n','d','e','d',' ','u','p',' ','\x0f','m','m','G','C','R','a','m','T','r','a','p','0','e','H','a','n','d','l','e','r','.',
/* 0x06cd7 = "VFS chain element takes a file system stream (fss) object as input." */
    '\x8d',' ','\xa1','\x5c','t','a','k','e','s',' ','a',' ','\x1f','s','y','s','t','e','m',' ','s','t','r','e','a','m',' ','(','f','s','s',')',' ','\xa8','a','s',' ','i','n','p','u','t','.',
/* 0x06d02 = "A Shared Clipboard objects handle is invalid." */
    'A',' ','S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','o','b','j','e','c','t','s',' ','h','a','n','d','l','e',' ','\x0b','i','n','v','a','l','i','d','.',
/* 0x06d2d = "RTGetOpt: Command line option needs an index." */
    'R','T','G','e','t','O','p','t',':',' ','C','o','m','m','a','n','d',' ','l','i','n','e',' ','o','p','t','i','o','n',' ','n','e','e','d','s',' ','\x87','i','n','d','e','x','.',
/* 0x06d58 = "No \'Type\' attribute in the DrvBlock configuration." */
    '\xdf','\'','T','y','p','e','\'',' ','a','t','t','r','i','b','u','t','e',' ','\x0f','\x02','D','r','v','B','l','o','c','k',' ','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x06d83 = "Reason for leaving RC: Guest tried to write to our LDT - fatal." */
    '\x93','\x10','\x81','R','C',':',' ','G','u','e','s','t',' ','t','r','i','e','d',' ','\x0a','w','r','i','t','e',' ','\x0a','o','u','r',' ','L','D','T',' ','-',' ','f','a','t','a','l','.',
/* 0x06dae = "Image Verification Failure: Raw data offsets and sizes are out of range." */
    'I','m','a','g','e',' ','\x0d','\x12','R','a','w',' ','\x9d','o','f','f','s','e','t','s',' ','\x9a','s','i','z','e','s',' ','a','r','e',' ','o','u','t',' ','\x15','r','a','n','g','e','.',
/* 0x06dd9 = "Someone is trying to skip backwards in the stream..." */
    'S','o','m','e','o','n','e',' ','\x0b','t','r','y','i','n','g',' ','\x0a','s','k','i','p',' ','b','a','c','k','w','a','r','d','s',' ','\x0f','\x02','s','t','r','e','a','m','.','.','.',
/* 0x06e04 = "Mismatching VM structure size between VMMR0 and VBoxVMM." */
    'M','i','s','m','a','t','c','h','i','n','g',' ','\xcd',' ','\xec','s','i','z','e',' ','b','e','t','w','e','e','n',' ','V','M','M','R','0',' ','\x9a','V','B','o','x','V','M','M','.',
/* 0x06e2f = "An unexpected (/unknown) exception was caught." */
    'A','n',' ','u','n','e','x','p','e','c','t','e','d',' ','(','/','u','n','k','n','o','w','n',')',' ','e','x','c','e','p','t','i','o','n',' ','\x11','c','a','u','g','h','t','.',
/* 0x06e5a = "Couldn\'t find MMIO2 range from saved state." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','M','M','I','O','2',' ','r','a','n','g','e',' ','f','r','o','m',' ','s','a','v','e','d',' ','s','t','a','t','e','.',
/* 0x06e85 = "The size field should be zero for links and symlinks." */
    '\x03','s','i','z','e',' ','f','i','e','l','d',' ','s','h','o','u','l','d',' ','\xa7','z','e','r','o',' ','\x10','l','i','n','k','s',' ','\x9a','s','y','m','l','i','n','k','s','.',
/* 0x06eaf = "Not all of the requested CPUs showed up in the PFNRTMPWORKER." */
    'N','o','t',' ','a','l','l',' ','\x15','\x02','\xde','C','P','U','s',' ','s','h','o','w','e','d',' ','u','p',' ','\x0f','\x02','P','F','N','R','T','M','P','W','O','R','K','E','R','.',
/* 0x06ed9 = "The provider is only allowed as the first element." */
    '\x03','p','r','o','v','i','d','e','r',' ','\x0b','o','n','l','y',' ','a','l','l','o','w','e','d',' ','a','s',' ','\x02','f','i','r','s','t',' ','e','l','e','m','e','n','t','.',
/* 0x06f03 = "The DTB being parsed has an invalid strings block offset." */
    '\x03','D','T','B',' ','b','e','i','n','g',' ','p','a','r','s','e','d',' ','\x5e','\x87','\x8f','s','t','r','i','n','g','s',' ','b','l','o','c','k',' ','o','f','f','s','e','t','.',
/* 0x06f2d = "Service will execute the command in background." */
    'S','e','r','v','i','c','e',' ','w','i','l','l',' ','e','x','e','c','u','t','e',' ','\x02','c','o','m','m','a','n','d',' ','\x0f','b','a','c','k','g','r','o','u','n','d','.',
/* 0x06f57 = "The Mach-O header is bad or contains new and unsupported features." */
    '\x03','M','a','c','h','-','O',' ','\xb3','\x0b','b','a','d',' ','\xa9','\x8a','n','e','w',' ','\x9a','u','n','s','u','p','p','o','r','t','e','d',' ','f','e','a','t','u','r','e','s','.',
/* 0x06f81 = "Command format (or reserved bits) invalid." */
    'C','o','m','m','a','n','d',' ','f','o','r','m','a','t',' ','(','o','r',' ','r','e','s','e','r','v','e','d',' ','b','i','t','s',')',' ','i','n','v','a','l','i','d','.',
/* 0x06fab = "The process trying to open VBoxDrv is not a budding VM process (2)." */
    '\x03','\x92','t','r','y','i','n','g',' ','\x0a','o','p','e','n',' ','V','B','o','x','D','r','v',' ','\x0b','\x08','a',' ','b','u','d','d','i','n','g',' ','\xcd',' ','\x92','(','2',')','.',
/* 0x06fd5 = "Do not know how to handle the content type in the server response." */
    'D','o',' ','\x08','k','n','o','w',' ','h','o','w',' ','\x0a','h','a','n','d','l','e',' ','\x02','\xf0','\xf3','\x0f','\x02','s','e','r','v','e','r',' ','r','e','s','p','o','n','s','e','.',
/* 0x06fff = "Constructed string is not according to the encoding rules." */
    'C','o','n','s','t','r','u','c','t','e','d',' ','\xf2','\x0b','\x08','a','c','c','o','r','d','i','n','g',' ','\x0a','\x02','e','n','c','o','d','i','n','g',' ','r','u','l','e','s','.',
/* 0x07029 = "Recompiler: Failed to reconcile the register/variable state on endif." */
    '\x13','\x8b','\x0a','r','e','c','o','n','c','i','l','e',' ','\x02','r','e','g','i','s','t','e','r','/','v','a','r','i','a','b','l','e',' ','\xca','o','n',' ','e','n','d','i','f','.',
/* 0x07053 = "The ELF loader didn\'t find the symbol/string table for the image." */
    '\x03','E','L','F',' ','\xd9','d','i','d','n','\'','t',' ','f','i','n','d',' ','\x02','s','y','m','b','o','l','/','s','t','r','i','n','g',' ','\xb1','\x10','\x02','i','m','a','g','e','.',
/* 0x0707d = "The server did not understand the request due to bad syntax." */
    '\x03','s','e','r','v','e','r',' ','d','i','d',' ','\x08','u','n','d','e','r','s','t','a','n','d',' ','\x02','\xaa','d','u','e',' ','\x0a','b','a','d',' ','s','y','n','t','a','x','.',
/* 0x070a7 = "The process trying to open VBoxDrv is not a budding VM process (1)." */
    '\x03','\x92','t','r','y','i','n','g',' ','\x0a','o','p','e','n',' ','V','B','o','x','D','r','v',' ','\x0b','\x08','a',' ','b','u','d','d','i','n','g',' ','\xcd',' ','\x92','(','1',')','.',
/* 0x070d1 = "Process Verification Failure: Error allocating state memory or querying the system32 path." */
    '\x1e','\x0d','\x12','\xc0','a','l','l','o','c','a','t','i','n','g',' ','\xca','\x86','\xa9','q','u','e','r','y','i','n','g',' ','\x02','s','y','s','t','e','m','3','2',' ','p','a','t','h','.',
/* 0x070fb = "RTGetOpt: Command line option not recognized." */
    'R','T','G','e','t','O','p','t',':',' ','C','o','m','m','a','n','d',' ','l','i','n','e',' ','o','p','t','i','o','n',' ','\x08','r','e','c','o','g','n','i','z','e','d','.',
/* 0x07125 = "Too many partition maps in the logical volume descriptor." */
    'T','o','o',' ','\xb4','p','a','r','t','i','t','i','o','n',' ','m','a','p','s',' ','\x0f','\x02','l','o','g','i','c','a','l',' ','\xd2','d','e','s','c','r','i','p','t','o','r','.',
/* 0x0714f = "OpenSSL and IPRT disagree on the signature size." */
    'O','p','e','n','S','S','L',' ','\x9a','I','P','R','T',' ','d','i','s','a','g','r','e','e',' ','o','n',' ','\x02','s','i','g','n','a','t','u','r','e',' ','s','i','z','e','.',
/* 0x07179 = "Syntax error - the argument does not allow a range to be specified." */
    '\xfa','\x09','-',' ','\x02','a','r','g','u','m','e','n','t',' ','\xb2','\x08','a','l','l','o','w',' ','a',' ','r','a','n','g','e',' ','\x0a','\xa7','s','p','e','c','i','f','i','e','d','.',
/* 0x071a3 = "The EMT was not busy running guest code at the time of the call." */
    '\x03','E','M','T',' ','\x11','\x08','b','u','s','y',' ','r','u','n','n','i','n','g',' ','\xbb','c','o','d','e',' ','a','t',' ','\x02','t','i','m','e',' ','\x15','\x02','c','a','l','l','.',
/* 0x071cd = "The DTB being parsed has an invalid last compatible version set." */
    '\x03','D','T','B',' ','b','e','i','n','g',' ','p','a','r','s','e','d',' ','\x5e','\x87','\x8f','l','a','s','t',' ','c','o','m','p','a','t','i','b','l','e',' ','\xcf','s','e','t','.',
/* 0x071f7 = "The GIM device is not registered with GIM when it ought to be." */
    '\x03','G','I','M',' ','\xa3','\x0b','\x08','r','e','g','i','s','t','e','r','e','d',' ','\x80','G','I','M',' ','w','h','e','n',' ','i','t',' ','o','u','g','h','t',' ','\x0a','b','e','.',
/* 0x07221 = "Too many arguments passed to a VM request / request corruption." */
    'T','o','o',' ','\xb4','a','r','g','u','m','e','n','t','s',' ','p','a','s','s','e','d',' ','\x0a','a',' ','\xcd',' ','\xaa','/',' ','\xaa','c','o','r','r','u','p','t','i','o','n','.',
/* 0x0724b = "The hash function in the header doesn't match the one in the table of content." */
    '\x03','h','a','s','h',' ','f','u','n','c','t','i','o','n',' ','\x0f','\x02','\xb3','\xc7','m','a','t','c','h',' ','\x02','o','n','e',' ','\x0f','\x02','\xb1','\x15','c','o','n','t','e','n','t','.',
/* 0x07275 = "The field does not follow immediately the previous one." */
    '\x03','f','i','e','l','d',' ','\xb2','\x08','f','o','l','l','o','w',' ','i','m','m','e','d','i','a','t','e','l','y',' ','\x02','p','r','e','v','i','o','u','s',' ','o','n','e','.',
/* 0x0729f = "The table of content (TOC) is too small and therefore can\'t be valid." */
    '\x03','\xb1','\x15','\xf0','(','T','O','C',')',' ','\x0b','\x9e','s','m','a','l','l',' ','\x9a','t','h','e','r','e','f','o','r','e',' ','c','a','n','\'','t',' ','\xa7','v','a','l','i','d','.',
/* 0x072c9 = "No line number was found for the specified address/ordinal/whatever." */
    '\xdf','l','i','n','e',' ','\xfb','\x11','f','o','u','n','d',' ','\x10','\x02','\x18','a','d','d','r','e','s','s','/','o','r','d','i','n','a','l','/','w','h','a','t','e','v','e','r','.',
/* 0x072f3 = "Failed to convert the specified Guest IP to a binary IP address." */
    '\x8b','\x0a','c','o','n','v','e','r','t',' ','\x02','\x18','G','u','e','s','t',' ','I','P',' ','\x0a','a',' ','b','i','n','a','r','y',' ','I','P',' ','a','d','d','r','e','s','s','.',
/* 0x0731d = "An unknown config node (key) was encountered." */
    'A','n',' ','u','n','k','n','o','w','n',' ','c','o','n','f','i','g',' ','n','o','d','e',' ','(','k','e','y',')',' ','\x11','e','n','c','o','u','n','t','e','r','e','d','.',
/* 0x07347 = "Recompiled execution: Jump back in the same TB." */
    'R','e','c','o','m','p','i','l','e','d',' ','e','x','e','c','u','t','i','o','n',':',' ','J','u','m','p',' ','b','a','c','k',' ','\x0f','\x02','s','a','m','e',' ','T','B','.',
/* 0x07371 = "File set descriptor has an zero length or invalid root dir extent." */
    'F','i','l','e',' ','s','e','t',' ','\xe3','\x5e','\x87','z','e','r','o',' ','l','e','n','g','t','h',' ','\xa9','\x8f','r','o','o','t',' ','d','i','r',' ','e','x','t','e','n','t','.',
/* 0x0739b = "Process Verification Failure: An image is targeting an unexpected machine/CPU." */
    '\x1e','\x0d','\x12','A','n',' ','\x26','\x0b','t','a','r','g','e','t','i','n','g',' ','\x87','u','n','e','x','p','e','c','t','e','d',' ','m','a','c','h','i','n','e','/','C','P','U','.',
/* 0x073c5 = "No pending request the aio context has to wait for completion." */
    '\xdf','p','e','n','d','i','n','g',' ','\xaa','\x02','a','i','o',' ','c','o','n','t','e','x','t',' ','\x5e','\x0a','w','a','i','t',' ','\x10','c','o','m','p','l','e','t','i','o','n','.',
/* 0x073ef = "String is not terminated within the buffer bounds." */
    'S','t','r','i','n','g',' ','\x0b','\x08','t','e','r','m','i','n','a','t','e','d',' ','w','i','t','h','i','n',' ','\x02','b','u','f','f','e','r',' ','b','o','u','n','d','s','.',
/* 0x07419 = "Unable to find partition descriptor for a partition map table entry." */
    '\xe0','\x0a','f','i','n','d',' ','p','a','r','t','i','t','i','o','n',' ','\xe3','\x10','a',' ','p','a','r','t','i','t','i','o','n',' ','m','a','p',' ','\xb1','e','n','t','r','y','.',
/* 0x07443 = "The DTB being parsed has an invalid struct block offset." */
    '\x03','D','T','B',' ','b','e','i','n','g',' ','p','a','r','s','e','d',' ','\x5e','\x87','\x8f','s','t','r','u','c','t',' ','b','l','o','c','k',' ','o','f','f','s','e','t','.',
/* 0x0746c = "Expected PKCS #7 object to ship at least one certificate." */
    '\xb8','P','K','C','S',' ','#','7',' ','\xa8','\x0a','s','h','i','p',' ','a','t',' ','l','e','a','s','t',' ','o','n','e',' ','c','e','r','t','i','f','i','c','a','t','e','.',
/* 0x07495 = "Something is not available or not working properly." */
    'S','o','m','e','t','h','i','n','g',' ','\x0b','\x08','a','v','a','i','l','a','b','l','e',' ','\xa9','\x08','w','o','r','k','i','n','g',' ','p','r','o','p','e','r','l','y','.',
/* 0x074be = "Indicating that a rescheduling now is required." */
    'I','n','d','i','c','a','t','i','n','g',' ','\xad','a',' ','r','e','s','c','h','e','d','u','l','i','n','g',' ','n','o','w',' ','\x0b','r','e','q','u','i','r','e','d','.',
/* 0x074e7 = "The CSAM is not used because we\'re using HM and VT-x/AMD-V." */
    '\x03','C','S','A','M',' ','\x0b','\x08','u','s','e','d',' ','\x40','w','e','\'','r','e',' ','u','s','i','n','g',' ','H','M',' ','\x9a','V','T','-','x','/','A','M','D','-','V','.',
/* 0x07510 = "The requested operation cannot be performed because the device is currently being reset." */
    '\x03','\xde','\x96','\xd1','\xa7','p','e','r','f','o','r','m','e','d',' ','\x40','\x02','\xa3','\x0b','c','u','r','r','e','n','t','l','y',' ','b','e','i','n','g',' ','r','e','s','e','t','.',
/* 0x07539 = "The user mode tracepoint provider string table is too large." */
    '\x03','u','s','e','r',' ','m','o','d','e',' ','t','r','a','c','e','p','o','i','n','t',' ','p','r','o','v','i','d','e','r',' ','\xf2','\xb1','\x0b','\x9e','l','a','r','g','e','.',
/* 0x07562 = "Reason for leaving RC: Guest trap which couldn\'t be handled in RC." */
    '\x93','\x10','\x81','R','C',':',' ','G','u','e','s','t',' ','t','r','a','p',' ','\xed','c','o','u','l','d','n','\'','t',' ','\xa7','h','a','n','d','l','e','d',' ','\x0f','R','C','.',
/* 0x0758b = "Key algorithm parameters are required but missing." */
    'K','e','y',' ','\xd4','p','a','r','a','m','e','t','e','r','s',' ','a','r','e',' ','r','e','q','u','i','r','e','d',' ','b','u','t',' ','m','i','s','s','i','n','g','.',
/* 0x075b4 = "Return to ring-3 to perform the hypercall there." */
    'R','e','t','u','r','n',' ','\x0a','r','i','n','g','-','3',' ','\x0a','p','e','r','f','o','r','m',' ','\x02','h','y','p','e','r','c','a','l','l',' ','t','h','e','r','e','.',
/* 0x075dd = "No digest algorithms listed in PKCS #7 signed data." */
    '\xdf','\xd7','a','l','g','o','r','i','t','h','m','s',' ','l','i','s','t','e','d',' ','\x0f','P','K','C','S',' ','#','7',' ','s','i','g','n','e','d',' ','d','a','t','a','.',
/* 0x07606 = "Address conflict within a module/segment." */
    'A','d','d','r','e','s','s',' ','c','o','n','f','l','i','c','t',' ','w','i','t','h','i','n',' ','a',' ','m','o','d','u','l','e','/','s','e','g','m','e','n','t','.',
/* 0x0762f = "The saved state file size didn\'t match the one in the header." */
    '\x03','s','a','v','e','d',' ','\xca','\x1f','s','i','z','e',' ','d','i','d','n','\'','t',' ','m','a','t','c','h',' ','\x02','o','n','e',' ','\x0f','\x02','h','e','a','d','e','r','.',
/* 0x07658 = "The DTB structs block contains an unterminated string." */
    '\x03','D','T','B',' ','s','t','r','u','c','t','s',' ','b','l','o','c','k',' ','\x8a','\x87','u','n','t','e','r','m','i','n','a','t','e','d',' ','s','t','r','i','n','g','.',
/* 0x07681 = "The request wasn\'t submitted so it can\'t be canceled." */
    '\x03','\xaa','w','a','s','n','\'','t',' ','s','u','b','m','i','t','t','e','d',' ','s','o',' ','i','t',' ','c','a','n','\'','t',' ','\xa7','c','a','n','c','e','l','e','d','.',
/* 0x076aa = "Process Verification Failure: Found executable memory allocated in the process." */
    '\x1e','\x0d','\x12','F','o','u','n','d',' ','e','x','e','c','u','t','a','b','l','e',' ','\x86','a','l','l','o','c','a','t','e','d',' ','\x0f','\x02','p','r','o','c','e','s','s','.',
/* 0x076d3 = "Get register caller must flush the TLB (not an error)." */
    'G','e','t',' ','\xeb','c','a','l','l','e','r',' ','m','u','s','t',' ','f','l','u','s','h',' ','\x02','T','L','B',' ','(','n','o','t',' ','\x87','e','r','r','o','r',')','.',
/* 0x076fc = "Couldn\'t find ROM range from saved state." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','R','O','M',' ','r','a','n','g','e',' ','f','r','o','m',' ','s','a','v','e','d',' ','s','t','a','t','e','.',
/* 0x07725 = "A numeric conversion encountered a value which was too big for the target." */
    'A',' ','n','u','m','e','r','i','c',' ','c','o','n','v','e','r','s','i','o','n',' ','\xaf','a',' ','\xf5','\xed','\x11','\x9e','b','i','g',' ','\x10','\x02','t','a','r','g','e','t','.',
/* 0x0774e = "The Host Interface Networking init program failed." */
    '\x03','H','o','s','t',' ','I','n','t','e','r','f','a','c','e',' ','N','e','t','w','o','r','k','i','n','g',' ','i','n','i','t',' ','p','r','o','g','r','a','m',' ','\x7b',
/* 0x07777 = "Process Verification Failure: One of the section in the image file is not fully mapped into memory." */
    '\x1e','\x0d','\x12','O','n','e',' ','\x15','\x02','\xdb','\x0f','\x02','\x26','\x1f','\x0b','\x08','f','u','l','l','y',' ','m','a','p','p','e','d',' ','i','n','t','o',' ','m','e','m','o','r','y','.',
/* 0x077a0 = "Node pointer is not within the memory allocated for nodes." */
    'N','o','d','e',' ','p','o','i','n','t','e','r',' ','\x0b','\x08','w','i','t','h','i','n',' ','\x02','\x86','a','l','l','o','c','a','t','e','d',' ','\x10','n','o','d','e','s','.',
/* 0x077c9 = "VFS chain element takes a file or I/O stream (ios) object as input." */
    '\x8d',' ','\xa1','\x5c','t','a','k','e','s',' ','a',' ','\x1f','\xa9','I','/','O',' ','s','t','r','e','a','m',' ','(','i','o','s',')',' ','\xa8','a','s',' ','i','n','p','u','t','.',
/* 0x077f2 = "The initialization of the dynamic mapping cache failed." */
    '\x03','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','\x15','\x02','d','y','n','a','m','i','c',' ','m','a','p','p','i','n','g',' ','c','a','c','h','e',' ','\x7b',
/* 0x0781b = "The GIM provider does not support any paravirtualized TSC." */
    '\x03','G','I','M',' ','p','r','o','v','i','d','e','r',' ','\xb2','\x08','\xce','a','n','y',' ','p','a','r','a','v','i','r','t','u','a','l','i','z','e','d',' ','T','S','C','.',
/* 0x07844 = "Certificate cannot be authenticated with the given CA certificates." */
    '\xba','\xd1','\xa7','a','u','t','h','e','n','t','i','c','a','t','e','d',' ','\x80','\x02','g','i','v','e','n',' ','C','A',' ','c','e','r','t','i','f','i','c','a','t','e','s','.',
/* 0x0786d = "The algorithms part of the DEK-Info field is too long." */
    '\x03','a','l','g','o','r','i','t','h','m','s',' ','p','a','r','t',' ','\x15','\x02','D','E','K','-','I','n','f','o',' ','f','i','e','l','d',' ','\x0b','\x9e','l','o','n','g','.',
/* 0x07896 = "Reason for leaving RC: CSAM wants perform a task in ring-3." */
    '\x93','\x10','\x81','R','C',':',' ','C','S','A','M',' ','w','a','n','t','s',' ','p','e','r','f','o','r','m',' ','a',' ','t','a','s','k',' ','\x0f','r','i','n','g','-','3','.',
/* 0x078bf = "The field contains an invalid callback or transformation index." */
    '\x03','f','i','e','l','d',' ','\x8a','\x87','\x8f','c','a','l','l','b','a','c','k',' ','\xa9','t','r','a','n','s','f','o','r','m','a','t','i','o','n',' ','i','n','d','e','x','.',
/* 0x078e8 = "The name of the module clashed with an existing module." */
    '\x03','n','a','m','e',' ','\x15','\x02','m','o','d','u','l','e',' ','c','l','a','s','h','e','d',' ','\x80','\x87','e','x','i','s','t','i','n','g',' ','m','o','d','u','l','e','.',
/* 0x07911 = "An attempt was made to grow an already maxed out page pool." */
    'A','n',' ','a','t','t','e','m','p','t',' ','\x11','m','a','d','e',' ','\x0a','g','r','o','w',' ','\x87','\x7f','m','a','x','e','d',' ','o','u','t',' ','\xcc','p','o','o','l','.',
/* 0x0793a = "PKIX cipher algorithm parameters are not implemented." */
    'P','K','I','X',' ','c','i','p','h','e','r',' ','\xd4','p','a','r','a','m','e','t','e','r','s',' ','a','r','e',' ','\x08','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x07963 = "Import ISO contains an unsupported supplementary volume descriptor version." */
    '\xc3','\xc1',' ','\x8a','\x87','u','n','s','u','p','p','o','r','t','e','d',' ','s','u','p','p','l','e','m','e','n','t','a','r','y',' ','\xd2','\xe3','v','e','r','s','i','o','n','.',
/* 0x0798c = "A boot catalog entry in the import ISO is using the unused field." */
    'A',' ','b','o','o','t',' ','\xe7','\xc8','\x0f','\x02','i','m','p','o','r','t',' ','\xc1',' ','\x0b','u','s','i','n','g',' ','\x02','u','n','u','s','e','d',' ','f','i','e','l','d','.',
/* 0x079b5 = "The page to be updated or freed was noted owned by the caller." */
    '\x03','\xcc','\x0a','\xa7','u','p','d','a','t','e','d',' ','\xa9','f','r','e','e','d',' ','\x11','n','o','t','e','d',' ','o','w','n','e','d',' ','\xe1','\x02','c','a','l','l','e','r','.',
/* 0x079de = "(One) send buffer was too small, or too few buffers." */
    '(','O','n','e',')',' ','s','e','n','d',' ','b','u','f','f','e','r',' ','\x11','\x9e','s','m','a','l','l',',',' ','\xa9','\x9e','f','e','w',' ','b','u','f','f','e','r','s','.',
/* 0x07a07 = "The table of content string length didn\'t match the size specified in the header." */
    '\x03','\xb1','\x15','\xf0','\xf2','l','e','n','g','t','h',' ','d','i','d','n','\'','t',' ','m','a','t','c','h',' ','\x02','s','i','z','e',' ','\x18','\x0f','\x02','h','e','a','d','e','r','.',
/* 0x07a30 = "Reason for leaving RC: A privileged instruction was attempted executed." */
    '\x93','\x10','\x81','R','C',':',' ','A',' ','p','r','i','v','i','l','e','g','e','d',' ','\xda','\x11','a','t','t','e','m','p','t','e','d',' ','e','x','e','c','u','t','e','d','.',
/* 0x07a59 = "The native file handle got stale while it was open." */
    '\x03','n','a','t','i','v','e',' ','\x1f','h','a','n','d','l','e',' ','g','o','t',' ','s','t','a','l','e',' ','w','h','i','l','e',' ','i','t',' ','\x11','o','p','e','n','.',
/* 0x07a82 = "A string claiming to be UTF-8 is incorrectly encoded." */
    'A',' ','\xf2','c','l','a','i','m','i','n','g',' ','\x0a','\xa7','U','T','F','-','8',' ','\x0b','i','n','c','o','r','r','e','c','t','l','y',' ','e','n','c','o','d','e','d','.',
/* 0x07aab = "Malformed extended allocation descriptor." */
    'M','a','l','f','o','r','m','e','d',' ','e','x','t','e','n','d','e','d',' ','a','l','l','o','c','a','t','i','o','n',' ','d','e','s','c','r','i','p','t','o','r','.',
/* 0x07ad4 = "Unable to allocate more pages from the host system." */
    '\xe0','\x0a','a','l','l','o','c','a','t','e',' ','m','o','r','e',' ','p','a','g','e','s',' ','f','r','o','m',' ','\x02','h','o','s','t',' ','s','y','s','t','e','m','.',
/* 0x07afc = "Tried to resume a VM or CPU that is already fully running." */
    'T','r','i','e','d',' ','\x0a','r','e','s','u','m','e',' ','a',' ','\xcd',' ','\xa9','C','P','U',' ','\xad','\x0b','\x7f','f','u','l','l','y',' ','r','u','n','n','i','n','g','.',
/* 0x07b24 = "VFS chain element only provides file system (vfs) objects." */
    '\x8d',' ','\xa1','\x5c','o','n','l','y',' ','p','r','o','v','i','d','e','s',' ','\x1f','s','y','s','t','e','m',' ','(','v','f','s',')',' ','o','b','j','e','c','t','s','.',
/* 0x07b4c = "Failed to fix mappings because the proposed memory area was to small." */
    '\x8b','\x0a','f','i','x',' ','m','a','p','p','i','n','g','s',' ','\x40','\x02','p','r','o','p','o','s','e','d',' ','\x86','a','r','e','a',' ','\x11','\x0a','s','m','a','l','l','.',
/* 0x07b74 = "VMXON failed; possibly because it was already run before." */
    'V','M','X','O','N',' ','f','a','i','l','e','d',';',' ','p','o','s','s','i','b','l','y',' ','\x40','i','t',' ','\x11','\x7f','r','u','n',' ','b','e','f','o','r','e','.',
/* 0x07b9c = "Level 2 lookup failed because the L1 lookup table is corrupted." */
    'L','e','v','e','l',' ','2',' ','l','o','o','k','u','p',' ','\x99','\x40','\x02','L','1',' ','l','o','o','k','u','p',' ','\xb1','\x0b','c','o','r','r','u','p','t','e','d','.',
/* 0x07bc4 = "Invalid VMCS pointer passed to VMLAUNCH/VMRESUME." */
    '\x0c','V','M','C','S',' ','p','o','i','n','t','e','r',' ','p','a','s','s','e','d',' ','\x0a','V','M','L','A','U','N','C','H','/','V','M','R','E','S','U','M','E','.',
/* 0x07bec = "VERR_FDT_DTB_STRUCTS_BLOCK_NODE_NAME_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','S','T','R','U','C','T','S','_','B','L','O','C','K','_','N','O','D','E','_','N','A','M','E','_','I','N','V','A','L','I','D',
/* 0x07c14 = "VERR_FDT_DTB_STRUCTS_BLOCK_MALFORMED_PADDING" */
    '\x01','F','D','T','_','D','T','B','_','S','T','R','U','C','T','S','_','B','L','O','C','K','_','M','A','L','F','O','R','M','E','D','_','P','A','D','D','I','N','G',
/* 0x07c3c = "The Host Interface Networking device name is too long." */
    '\x03','H','o','s','t',' ','I','n','t','e','r','f','a','c','e',' ','N','e','t','w','o','r','k','i','n','g',' ','\xa3','n','a','m','e',' ','\x0b','\x9e','l','o','n','g','.',
/* 0x07c64 = "The encrypted digest algorithm does not match the one in the certificate." */
    '\x03','e','n','c','r','y','p','t','e','d',' ','\xd7','\xd4','\xb2','\x08','m','a','t','c','h',' ','\x02','o','n','e',' ','\x0f','\x02','c','e','r','t','i','f','i','c','a','t','e','.',
/* 0x07c8c = "Level 2 lookup failed because the L2 lookup table is corrupted." */
    'L','e','v','e','l',' ','2',' ','l','o','o','k','u','p',' ','\x99','\x40','\x02','L','2',' ','l','o','o','k','u','p',' ','\xb1','\x0b','c','o','r','r','u','p','t','e','d','.',
/* 0x07cb4 = "A guest control object has changed its overall status." */
    'A',' ','\xbb','c','o','n','t','r','o','l',' ','\xa8','\x5e','c','h','a','n','g','e','d',' ','i','t','s',' ','o','v','e','r','a','l','l',' ','s','t','a','t','u','s','.',
/* 0x07cdc = "Reason for leaving RC: jump inside generated patch jump." */
    '\x93','\x10','\x81','R','C',':',' ','j','u','m','p',' ','i','n','s','i','d','e',' ','g','e','n','e','r','a','t','e','d',' ','p','a','t','c','h',' ','j','u','m','p','.',
/* 0x07d04 = "The VFS chain specification does not have a valid prefix." */
    '\x03','\x8d',' ','\xa1','s','p','e','c','i','f','i','c','a','t','i','o','n',' ','\xb2','\x08','h','a','v','e',' ','a',' ','v','a','l','i','d',' ','p','r','e','f','i','x','.',
/* 0x07d2c = "Both debug and non-debug sections in segment." */
    'B','o','t','h',' ','d','e','b','u','g',' ','\x9a','n','o','n','-','d','e','b','u','g',' ','s','e','c','t','i','o','n','s',' ','\x0f','s','e','g','m','e','n','t','.',
/* 0x07d54 = "VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_CONTINUATION_WITH_NONE" */
    '\x01','\x22','\x83','B','O','O','T','_','C','A','T','_','E','N','T','R','Y','_','C','O','N','T','I','N','U','A','T','I','O','N','_','W','I','T','H','_','N','O','N','E',
/* 0x07d7c = "The requested operation cannot be performed on a detached USB device." */
    '\x03','\xde','\x96','\xd1','\xa7','p','e','r','f','o','r','m','e','d',' ','o','n',' ','a',' ','d','e','t','a','c','h','e','d',' ','U','S','B',' ','d','e','v','i','c','e','.',
/* 0x07da4 = "The OS does not support changing the owner of a symbolic link." */
    '\x03','O','S',' ','\xb2','\x08','\xce','c','h','a','n','g','i','n','g',' ','\x02','o','w','n','e','r',' ','\x15','a',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k','.',
/* 0x07dcc = "NEM is missing a require feature in the host API." */
    '\xee',' ','\x0b','m','i','s','s','i','n','g',' ','a',' ','r','e','q','u','i','r','e',' ','f','e','a','t','u','r','e',' ','\x0f','\x02','h','o','s','t',' ','A','P','I','.',
/* 0x07df4 = "Reason for leaving RC: duplicate instruction called at current eip." */
    '\x93','\x10','\x81','R','C',':',' ','d','u','p','l','i','c','a','t','e',' ','\xda','c','a','l','l','e','d',' ','a','t',' ','c','u','r','r','e','n','t',' ','e','i','p','.',
/* 0x07e1c = "Raw-mode is unavailable courtesy of Hyper-V." */
    'R','a','w','-','m','o','d','e',' ','\x0b','u','n','a','v','a','i','l','a','b','l','e',' ','c','o','u','r','t','e','s','y',' ','\x15','H','y','p','e','r','-','V','.',
/* 0x07e44 = "Recompiler: Wrong jump instruction targeting label at end of TB." */
    '\x13','W','r','o','n','g',' ','j','u','m','p',' ','\xda','t','a','r','g','e','t','i','n','g',' ','l','a','b','e','l',' ','a','t',' ','e','n','d',' ','\x15','T','B','.',
/* 0x07e6c = "The called method does not work with the value type of the given JSON value." */
    '\x03','c','a','l','l','e','d',' ','m','e','t','h','o','d',' ','\xb2','\x08','w','o','r','k',' ','\x80','\x02','\xf5','\xf3','\x15','\x02','g','i','v','e','n',' ','J','S','O','N',' ','\xe8',
/* 0x07e94 = "A Shared Clipboard list handle is invalid." */
    'A',' ','S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','l','i','s','t',' ','h','a','n','d','l','e',' ','\x0b','i','n','v','a','l','i','d','.',
/* 0x07ebc = "No more handles available, too many open handles." */
    '\xdf','m','o','r','e',' ','h','a','n','d','l','e','s',' ','a','v','a','i','l','a','b','l','e',',',' ','\x9e','\xb4','o','p','e','n',' ','h','a','n','d','l','e','s','.',
/* 0x07ee4 = "Couldn\'t find any USB hubs to attach the device to." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','a','n','y',' ','U','S','B',' ','h','u','b','s',' ','\x0a','a','t','t','a','c','h',' ','\x02','\xa3','t','o','.',
/* 0x07f0c = "PGM pool flush pending - return to ring 3." */
    'P','G','M',' ','p','o','o','l',' ','f','l','u','s','h',' ','p','e','n','d','i','n','g',' ','-',' ','r','e','t','u','r','n',' ','\x0a','r','i','n','g',' ','3','.',
/* 0x07f34 = "The segment bits are non-contiguous in the file." */
    '\x03','s','e','g','m','e','n','t',' ','b','i','t','s',' ','a','r','e',' ','n','o','n','-','c','o','n','t','i','g','u','o','u','s',' ','\x0f','\x02','f','i','l','e','.',
/* 0x07f5c = "The PE loader encountered some Guard CF stuff in the load config." */
    '\x03','P','E',' ','\xd9','\xaf','s','o','m','e',' ','G','u','a','r','d',' ','C','F',' ','s','t','u','f','f',' ','\x0f','\x02','l','o','a','d',' ','c','o','n','f','i','g','.',
/* 0x07f84 = "The given range does not meet the required alignment." */
    '\x03','g','i','v','e','n',' ','r','a','n','g','e',' ','\xb2','\x08','m','e','e','t',' ','\x02','r','e','q','u','i','r','e','d',' ','a','l','i','g','n','m','e','n','t','.',
/* 0x07fac = "Missing ciper parameters for encrypted key." */
    'M','i','s','s','i','n','g',' ','c','i','p','e','r',' ','p','a','r','a','m','e','t','e','r','s',' ','\x10','e','n','c','r','y','p','t','e','d',' ','k','e','y','.',
/* 0x07fd4 = "The internal application does not reside in the correct place (hardening)." */
    '\x03','\x16','a','p','p','l','i','c','a','t','i','o','n',' ','\xb2','\x08','r','e','s','i','d','e',' ','\x0f','\x02','c','o','r','r','e','c','t',' ','p','l','a','c','e',' ','\xae',
/* 0x07ffc = "Cannot resolve symbol because it\'s a forwarder." */
    'C','a','n','n','o','t',' ','r','e','s','o','l','v','e',' ','s','y','m','b','o','l',' ','\x40','i','t','\'','s',' ','a',' ','f','o','r','w','a','r','d','e','r','.',
/* 0x08024 = "Optional header magic and target machine does not match." */
    'O','p','t','i','o','n','a','l',' ','\xb3','m','a','g','i','c',' ','\x9a','t','a','r','g','e','t',' ','m','a','c','h','i','n','e',' ','\xb2','\x08','m','a','t','c','h','.',
/* 0x0804c = "The path of a new node contained slashes or was empty." */
    '\x03','\xd0','\x15','a',' ','n','e','w',' ','n','o','d','e',' ','c','o','n','t','a','i','n','e','d',' ','s','l','a','s','h','e','s',' ','\xa9','\x11','e','m','p','t','y','.',
/* 0x08074 = "No allocation descriptors for UDF directory." */
    '\xdf','a','l','l','o','c','a','t','i','o','n',' ','d','e','s','c','r','i','p','t','o','r','s',' ','\x10','U','D','F',' ','d','i','r','e','c','t','o','r','y','.',
/* 0x0809b = "Too many ICB indirections, possibly a loop." */
    'T','o','o',' ','\xb4','I','C','B',' ','i','n','d','i','r','e','c','t','i','o','n','s',',',' ','p','o','s','s','i','b','l','y',' ','a',' ','l','o','o','p','.',
/* 0x080c2 = "Failed to retrieve underlying (lower mac) link." */
    '\x8b','\x0a','r','e','t','r','i','e','v','e',' ','u','n','d','e','r','l','y','i','n','g',' ','(','l','o','w','e','r',' ','m','a','c',')',' ','l','i','n','k','.',
/* 0x080e9 = "The timer can\'t be stopped because it\'s already suspended." */
    '\x03','t','i','m','e','r',' ','c','a','n','\'','t',' ','\xa7','s','t','o','p','p','e','d',' ','\x40','i','t','\'','s',' ','\x7f','s','u','s','p','e','n','d','e','d','.',
/* 0x08110 = "A boot catalog entry in the import ISO has an invalid boot media type." */
    'A',' ','b','o','o','t',' ','\xe7','\xc8','\x0f','\x02','i','m','p','o','r','t',' ','\xc1',' ','\x5e','\x87','\x8f','b','o','o','t',' ','m','e','d','i','a',' ','t','y','p','e','.',
/* 0x08137 = "Signed data verification failed because there are zero signer infos." */
    'S','i','g','n','e','d',' ','\x9d','\xf8','\x99','\x40','t','h','e','r','e',' ','a','r','e',' ','z','e','r','o',' ','s','i','g','n','e','r',' ','i','n','f','o','s','.',
/* 0x0815e = "Process Verification Failure: Executable file name and process image name does not match up." */
    '\x1e','\x0d','\x12','E','x','e','c','u','t','a','b','l','e',' ','\x1f','n','a','m','e',' ','\x9a','\x92','\x26','n','a','m','e',' ','\xb2','\x08','m','a','t','c','h',' ','u','p','.',
/* 0x08185 = "Process Verification Failure: Expected the process and exe to advertise NX compatibility." */
    '\x1e','\x0d','\x12','\xb8','\x02','\x92','\x9a','e','x','e',' ','\x0a','a','d','v','e','r','t','i','s','e',' ','N','X',' ','c','o','m','p','a','t','i','b','i','l','i','t','y','.',
/* 0x081ac = "Internal error in the lock validator or related components." */
    '\x07','\x09','\x0f','\x02','l','o','c','k',' ','v','a','l','i','d','a','t','o','r',' ','\xa9','r','e','l','a','t','e','d',' ','c','o','m','p','o','n','e','n','t','s','.',
/* 0x081d3 = "AMD-V CPU extension disabled (by BIOS)." */
    'A','M','D','-','V',' ','C','P','U',' ','e','x','t','e','n','s','i','o','n',' ','d','i','s','a','b','l','e','d',' ','(','b','y',' ','B','I','O','S',')','.',
/* 0x081fa = "The command cannot be deregistered because has not been registered." */
    '\x03','c','o','m','m','a','n','d',' ','\xd1','\xa7','d','e','r','e','g','i','s','t','e','r','e','d',' ','\x40','\x5e','\x08','\xcb','r','e','g','i','s','t','e','r','e','d','.',
/* 0x08221 = "Pending exception; continue guest execution." */
    'P','e','n','d','i','n','g',' ','e','x','c','e','p','t','i','o','n',';',' ','c','o','n','t','i','n','u','e',' ','\xbb','e','x','e','c','u','t','i','o','n','.',
/* 0x08248 = "Reason for leaving RC: Interrupted by external interrupt." */
    '\x93','\x10','\x81','R','C',':',' ','I','n','t','e','r','r','u','p','t','e','d',' ','\xe1','e','x','t','e','r','n','a','l',' ','i','n','t','e','r','r','u','p','t','.',
/* 0x0826f = "The value is not a zero terminated character string." */
    '\x03','\xf5','\x0b','\x08','a',' ','z','e','r','o',' ','t','e','r','m','i','n','a','t','e','d',' ','c','h','a','r','a','c','t','e','r',' ','s','t','r','i','n','g','.',
/* 0x08296 = "The ELF loader cannot handle multiple SYMTAB sections." */
    '\x03','E','L','F',' ','\xd9','\xd1','h','a','n','d','l','e',' ','m','u','l','t','i','p','l','e',' ','S','Y','M','T','A','B',' ','s','e','c','t','i','o','n','s','.',
/* 0x082bd = "Certificate path validator: Invalid policy mapping (to/from anyPolicy)." */
    '\xba','\xd0','\xfe','\x0c','p','o','l','i','c','y',' ','m','a','p','p','i','n','g',' ','(','t','o','/','f','r','o','m',' ','a','n','y','P','o','l','i','c','y',')','.',
/* 0x082e4 = "Unique issuer and subject IDs require version certificate 2." */
    'U','n','i','q','u','e',' ','i','s','s','u','e','r',' ','\x9a','s','u','b','j','e','c','t',' ','I','D','s',' ','r','e','q','u','i','r','e',' ','\xcf','\xa0','2','.',
/* 0x0830b = "PKCS #7 signed data has no digest algorithms listed." */
    'P','K','C','S',' ','#','7',' ','s','i','g','n','e','d',' ','\x9d','\x5e','n','o',' ','\xd7','a','l','g','o','r','i','t','h','m','s',' ','l','i','s','t','e','d','.',
/* 0x08332 = "Virtual machine error occurred attempting the operation." */
    'V','i','r','t','u','a','l',' ','m','a','c','h','i','n','e',' ','\x09','o','c','c','u','r','r','e','d',' ','a','t','t','e','m','p','t','i','n','g',' ','\x02','\xea',
/* 0x08359 = "Attempted socket operation with a non-socket handle." */
    'A','t','t','e','m','p','t','e','d',' ','s','o','c','k','e','t',' ','\x96','\x80','a',' ','n','o','n','-','s','o','c','k','e','t',' ','h','a','n','d','l','e','.',
/* 0x08380 = "The guest bit mask didn\'t match the guest being loaded." */
    '\x03','\xbb','b','i','t',' ','m','a','s','k',' ','d','i','d','n','\'','t',' ','m','a','t','c','h',' ','\x02','\xbb','b','e','i','n','g',' ','l','o','a','d','e','d','.',
/* 0x083a7 = "Reason for leaving RC: pending irq after iret that sets IF." */
    '\x93','\x10','\x81','R','C',':',' ','p','e','n','d','i','n','g',' ','i','r','q',' ','a','f','t','e','r',' ','i','r','e','t',' ','\xad','s','e','t','s',' ','I','F','.',
/* 0x083ce = "Misaligned read/write critical section." */
    'M','i','s','a','l','i','g','n','e','d',' ','r','e','a','d','/','w','r','i','t','e',' ','c','r','i','t','i','c','a','l',' ','s','e','c','t','i','o','n','.',
/* 0x083f5 = "VERR_VMMDEV_CPU_HOTPLUG_NOT_MONITORED_BY_GUEST" */
    '\x01','V','M','M','D','E','V','_','C','P','U','_','H','O','T','P','L','U','G','_','\x06','M','O','N','I','T','O','R','E','D','_','B','Y','_','G','U','E','S','T',
/* 0x0841c = "A PDMThread API was called by the wrong thread." */
    'A',' ','P','D','M','T','h','r','e','a','d',' ','A','P','I',' ','\x11','c','a','l','l','e','d',' ','\xe1','\x02','w','r','o','n','g',' ','t','h','r','e','a','d','.',
/* 0x08443 = "Import ISO contains more than one el torito descriptor." */
    '\xc3','\xc1',' ','\x8a','m','o','r','e',' ','t','h','a','n',' ','o','n','e',' ','e','l',' ','t','o','r','i','t','o',' ','d','e','s','c','r','i','p','t','o','r','.',
/* 0x0846a = "Mismatching VM structure version between VMMR0 and VBoxVMM." */
    'M','i','s','m','a','t','c','h','i','n','g',' ','\xcd',' ','\xec','\xcf','b','e','t','w','e','e','n',' ','V','M','M','R','0',' ','\x9a','V','B','o','x','V','M','M','.',
/* 0x08491 = "The requested operation cannot be performed because the device is currently suspended." */
    '\x03','\xde','\x96','\xd1','\xa7','p','e','r','f','o','r','m','e','d',' ','\x40','\x02','\xa3','\x0b','c','u','r','r','e','n','t','l','y',' ','s','u','s','p','e','n','d','e','d','.',
/* 0x084b8 = "Return instigated by a callback or similar." */
    'R','e','t','u','r','n',' ','i','n','s','t','i','g','a','t','e','d',' ','\xe1','a',' ','c','a','l','l','b','a','c','k',' ','\xa9','s','i','m','i','l','a','r','.',
/* 0x084df = "VMX CPU extension not available in hardware." */
    'V','M','X',' ','C','P','U',' ','e','x','t','e','n','s','i','o','n',' ','\x08','a','v','a','i','l','a','b','l','e',' ','\x0f','h','a','r','d','w','a','r','e','.',
/* 0x08506 = "The symbol size was adjusted while adding it." */
    '\x03','s','y','m','b','o','l',' ','s','i','z','e',' ','\x11','a','d','j','u','s','t','e','d',' ','w','h','i','l','e',' ','a','d','d','i','n','g',' ','i','t','.',
/* 0x0852d = "Indefinite length form is against the rules." */
    'I','n','d','e','f','i','n','i','t','e',' ','l','e','n','g','t','h',' ','f','o','r','m',' ','\x0b','a','g','a','i','n','s','t',' ','\x02','r','u','l','e','s','.',
/* 0x08554 = "The async completion template is still used." */
    '\x03','a','s','y','n','c',' ','c','o','m','p','l','e','t','i','o','n',' ','t','e','m','p','l','a','t','e',' ','\x0b','s','t','i','l','l',' ','u','s','e','d','.',
/* 0x0857b = "Expected PKCS #7 object to ship the signer certificate(s)." */
    '\xb8','P','K','C','S',' ','#','7',' ','\xa8','\x0a','s','h','i','p',' ','\x02','s','i','g','n','e','r',' ','c','e','r','t','i','f','i','c','a','t','e','(','s',')','.',
/* 0x085a2 = "The virtual clock frequency differs too much." */
    '\x03','v','i','r','t','u','a','l',' ','c','l','o','c','k',' ','f','r','e','q','u','e','n','c','y',' ','d','i','f','f','e','r','s',' ','\x9e','m','u','c','h','.',
/* 0x085c9 = "A boot catalog entry in the import ISO has reserved flag set." */
    'A',' ','b','o','o','t',' ','\xe7','\xc8','\x0f','\x02','i','m','p','o','r','t',' ','\xc1',' ','\x5e','r','e','s','e','r','v','e','d',' ','f','l','a','g',' ','s','e','t','.',
/* 0x085f0 = "Tried to take a semaphore in a bad context." */
    'T','r','i','e','d',' ','\x0a','t','a','k','e',' ','a',' ','s','e','m','a','p','h','o','r','e',' ','\x0f','a',' ','b','a','d',' ','c','o','n','t','e','x','t','.',
/* 0x08617 = "The specified MMIO range was owned by some other device(s)." */
    '\x03','\x18','\xd3',' ','r','a','n','g','e',' ','\x11','o','w','n','e','d',' ','\xe1','s','o','m','e',' ','o','t','h','e','r',' ','d','e','v','i','c','e','(','s',')','.',
/* 0x0863e = "Internal ISO maker error: Inconsistency produing trans." */
    '\x07','\xc1',' ','m','a','k','e','r',' ','\xd8','I','n','c','o','n','s','i','s','t','e','n','c','y',' ','p','r','o','d','u','i','n','g',' ','t','r','a','n','s','.',
/* 0x08665 = "The default boot catalog entry in the import ISO has invalid flags set." */
    '\x03','d','e','f','a','u','l','t',' ','b','o','o','t',' ','\xe7','\xc8','\x0f','\x02','i','m','p','o','r','t',' ','\xc1',' ','\x5e','\x8f','f','l','a','g','s',' ','s','e','t','.',
/* 0x0868c = "A request was not prepared and thus could not be submitted." */
    'A',' ','\xaa','\x11','\x08','p','r','e','p','a','r','e','d',' ','\x9a','t','h','u','s',' ','c','o','u','l','d',' ','\x08','\xa7','s','u','b','m','i','t','t','e','d','.',
/* 0x086b2 = "Started guest process terminated with an exit code <> 0." */
    'S','t','a','r','t','e','d',' ','\xbb','\x92','t','e','r','m','i','n','a','t','e','d',' ','\x80','\x87','e','x','i','t',' ','c','o','d','e',' ','<','>',' ','0','.',
/* 0x086d8 = "The component factories do not support the requested interface." */
    '\x03','c','o','m','p','o','n','e','n','t',' ','f','a','c','t','o','r','i','e','s',' ','d','o',' ','\x08','\xce','\x02','\xde','i','n','t','e','r','f','a','c','e','.',
/* 0x086fe = "The specified MMIO range intruded on an existing range." */
    '\x03','\x18','\xd3',' ','r','a','n','g','e',' ','i','n','t','r','u','d','e','d',' ','o','n',' ','\x87','e','x','i','s','t','i','n','g',' ','r','a','n','g','e','.',
/* 0x08724 = "Attempted to report too many pages as deflated." */
    'A','t','t','e','m','p','t','e','d',' ','\x0a','r','e','p','o','r','t',' ','\x9e','\xb4','p','a','g','e','s',' ','a','s',' ','d','e','f','l','a','t','e','d','.',
/* 0x0874a = "VERR_FDT_DTB_HDR_STRINGS_BLOCK_OFF_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','H','D','R','_','S','T','R','I','N','G','S','_','B','L','O','C','K','_','O','F','F','_','I','N','V','A','L','I','D',
/* 0x08770 = "Not the lock owner according our records." */
    'N','o','t',' ','\x02','l','o','c','k',' ','o','w','n','e','r',' ','a','c','c','o','r','d','i','n','g',' ','o','u','r',' ','r','e','c','o','r','d','s','.',
/* 0x08796 = "VERR_SUP_VP_NOT_SIGNED_WITH_SPECIALLY_TRUSTED_CERT" */
    '\x01','\x95','\xbd','\x06','S','I','G','N','E','D','_','W','I','T','H','_','S','P','E','C','I','A','L','L','Y','_','T','R','U','S','T','E','D','_','C','E','R','T',
/* 0x087bc = "The chunk has been mapped too many times already (impossible)." */
    '\x03','c','h','u','n','k',' ','\x5e','\xcb','m','a','p','p','e','d',' ','\x9e','\xb4','t','i','m','e','s',' ','\x7f','(','i','m','p','o','s','s','i','b','l','e',')','.',
/* 0x087e2 = "Power off is not supported by the hardware or the OS." */
    'P','o','w','e','r',' ','o','f','f',' ','\x0b','\x08','s','u','p','p','o','r','t','e','d',' ','\xe1','\x02','h','a','r','d','w','a','r','e',' ','\xa9','\x02','O','S','.',
/* 0x08808 = "Internal processing error the CodeView debug information reader." */
    '\x07','\x04','\x09','\x02','C','o','d','e','V','i','e','w',' ','d','e','b','u','g',' ','i','n','f','o','r','m','a','t','i','o','n',' ','r','e','a','d','e','r','.',
/* 0x0882e = "Process Verification Failure: Expected the process and exe to have dynamic base enabled." */
    '\x1e','\x0d','\x12','\xb8','\x02','\x92','\x9a','e','x','e',' ','\x0a','h','a','v','e',' ','d','y','n','a','m','i','c',' ','b','a','s','e',' ','e','n','a','b','l','e','d','.',
/* 0x08854 = "Reason for leaving RZ: Pending ring-3 OUT instruction." */
    '\x93','\x10','\x81','R','Z',':',' ','P','e','n','d','i','n','g',' ','r','i','n','g','-','3',' ','O','U','T',' ','i','n','s','t','r','u','c','t','i','o','n','.',
/* 0x0887a = "VERR_FDT_DTB_HDR_MEM_RSV_BLOCK_OFF_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','H','D','R','_','M','E','M','_','R','S','V','_','B','L','O','C','K','_','O','F','F','_','I','N','V','A','L','I','D',
/* 0x088a0 = "The specified attribute (name) was not found in the manifest." */
    '\x03','\x18','a','t','t','r','i','b','u','t','e',' ','(','n','a','m','e',')',' ','\x11','\x08','f','o','u','n','d',' ','\x0f','\x02','m','a','n','i','f','e','s','t','.',
/* 0x088c6 = "VERR_CR_CIPHER_INVALID_INITIALIZATION_VECTOR_LENGTH" */
    '\x01','\x24','C','I','P','H','E','R','_','\x05','I','N','I','T','I','A','L','I','Z','A','T','I','O','N','_','V','E','C','T','O','R','_','L','E','N','G','T','H',
/* 0x088ec = "Invalid VMCS index or write to read-only element." */
    '\x0c','V','M','C','S',' ','i','n','d','e','x',' ','\xa9','w','r','i','t','e',' ','\x0a','r','e','a','d','-','o','n','l','y',' ','e','l','e','m','e','n','t','.',
/* 0x08912 = "An account is restricted in a certain way." */
    'A','n',' ','a','c','c','o','u','n','t',' ','\x0b','r','e','s','t','r','i','c','t','e','d',' ','\x0f','a',' ','c','e','r','t','a','i','n',' ','w','a','y','.',
/* 0x08938 = "The caller shall raise an #GP(0) exception." */
    '\x03','c','a','l','l','e','r',' ','s','h','a','l','l',' ','r','a','i','s','e',' ','\x87','#','G','P','(','0',')',' ','e','x','c','e','p','t','i','o','n','.',
/* 0x0895e = "The signature is greater than or equal to the key." */
    '\x03','s','i','g','n','a','t','u','r','e',' ','\x0b','g','r','e','a','t','e','r',' ','t','h','a','n',' ','\xa9','e','q','u','a','l',' ','\x0a','\x02','k','e','y','.',
/* 0x08984 = "LUN is already/still attached to a device." */
    'L','U','N',' ','\x0b','a','l','r','e','a','d','y','/','s','t','i','l','l',' ','a','t','t','a','c','h','e','d',' ','\x0a','a',' ','d','e','v','i','c','e','.',
/* 0x089aa = "Attempt to release mutex not owned by caller." */
    'A','t','t','e','m','p','t',' ','\x0a','r','e','l','e','a','s','e',' ','m','u','t','e','x',' ','\x08','o','w','n','e','d',' ','\xe1','c','a','l','l','e','r','.',
/* 0x089d0 = "Failed to stat a file/dir during enumeration (hardening)." */
    '\x8b','\x0a','s','t','a','t',' ','a',' ','f','i','l','e','/','d','i','r',' ','d','u','r','i','n','g',' ','e','n','u','m','e','r','a','t','i','o','n',' ','\xae',
/* 0x089f6 = "The TCP server has no client associated with it." */
    '\x03','T','C','P',' ','s','e','r','v','e','r',' ','\x5e','n','o',' ','c','l','i','e','n','t',' ','a','s','s','o','c','i','a','t','e','d',' ','\x80','i','t','.',
/* 0x08a1c = "Unabled to locate or load the OpenGL library." */
    'U','n','a','b','l','e','d',' ','\x0a','l','o','c','a','t','e',' ','\xa9','l','o','a','d',' ','\x02','O','p','e','n','G','L',' ','l','i','b','r','a','r','y','.',
/* 0x08a42 = "Error getting extensions from the certificate." */
    '\xc0','g','e','t','t','i','n','g',' ','e','x','t','e','n','s','i','o','n','s',' ','f','r','o','m',' ','\x02','c','e','r','t','i','f','i','c','a','t','e','.',
/* 0x08a68 = "Virtual address was not allocated by the library." */
    'V','i','r','t','u','a','l',' ','a','d','d','r','e','s','s',' ','\x11','\x08','a','l','l','o','c','a','t','e','d',' ','\xe1','\x02','l','i','b','r','a','r','y','.',
/* 0x08a8e = "PKIX cipher algorithm is not known to OpenSSL EVP API." */
    'P','K','I','X',' ','c','i','p','h','e','r',' ','\xd4','\x0b','\x08','k','n','o','w','n',' ','\x0a','O','p','e','n','S','S','L',' ','E','V','P',' ','A','P','I','.',
/* 0x08ab4 = "The UDP server has no client associated with it." */
    '\x03','U','D','P',' ','s','e','r','v','e','r',' ','\x5e','n','o',' ','c','l','i','e','n','t',' ','a','s','s','o','c','i','a','t','e','d',' ','\x80','i','t','.',
/* 0x08ada = "VERR_CR_X509_TBSCERT_SERIAL_NUMBER_OUT_OF_BOUNDS" */
    '\x01','\x24','\xb7','T','B','S','C','E','R','T','_','S','E','R','I','A','L','_','N','U','M','B','E','R','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x08b00 = "UDF file cannot be import sparse files at present." */
    'U','D','F',' ','\x1f','\xd1','\xa7','i','m','p','o','r','t',' ','s','p','a','r','s','e',' ','f','i','l','e','s',' ','a','t',' ','p','r','e','s','e','n','t','.',
/* 0x08b26 = "File not accessible or erroneous file contents." */
    'F','i','l','e',' ','\x08','a','c','c','e','s','s','i','b','l','e',' ','\xa9','e','r','r','o','n','e','o','u','s',' ','\x1f','c','o','n','t','e','n','t','s','.',
/* 0x08b4c = "The table of content XML document does not have a toc element." */
    '\x03','\xb1','\x15','\xf0','X','M','L',' ','d','o','c','u','m','e','n','t',' ','\xb2','\x08','h','a','v','e',' ','a',' ','t','o','c',' ','e','l','e','m','e','n','t','.',
/* 0x08b72 = "The handle was not registered for use with the I/O queue." */
    '\x03','h','a','n','d','l','e',' ','\x11','\x08','r','e','g','i','s','t','e','r','e','d',' ','\x10','u','s','e',' ','\x80','\x02','I','/','O',' ','q','u','e','u','e','.',
/* 0x08b98 = "Import ISO contains more than one primary volume descriptor." */
    '\xc3','\xc1',' ','\x8a','m','o','r','e',' ','t','h','a','n',' ','o','n','e',' ','p','r','i','m','a','r','y',' ','\xd2','d','e','s','c','r','i','p','t','o','r','.',
/* 0x08bbe = "Malformed checksum field in the tar header." */
    'M','a','l','f','o','r','m','e','d',' ','c','h','e','c','k','s','u','m',' ','f','i','e','l','d',' ','\x0f','\x02','t','a','r',' ','h','e','a','d','e','r','.',
/* 0x08be4 = "Catch write access and route it thru PGM." */
    'C','a','t','c','h',' ','w','r','i','t','e',' ','a','c','c','e','s','s',' ','\x9a','r','o','u','t','e',' ','i','t',' ','t','h','r','u',' ','P','G','M','.',
/* 0x08c0a = "The interpreter was unable to deal with the instruction at hand." */
    '\x03','i','n','t','e','r','p','r','e','t','e','r',' ','\x11','u','n','a','b','l','e',' ','\x0a','d','e','a','l',' ','\x80','\x02','\xda','a','t',' ','h','a','n','d','.',
/* 0x08c30 = "Couldn\'t find MMIO2 page from saved state." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','M','M','I','O','2',' ','\xcc','f','r','o','m',' ','s','a','v','e','d',' ','s','t','a','t','e','.',
/* 0x08c56 = "The value is not a zero terminated password string." */
    '\x03','\xf5','\x0b','\x08','a',' ','z','e','r','o',' ','t','e','r','m','i','n','a','t','e','d',' ','p','a','s','s','w','o','r','d',' ','s','t','r','i','n','g','.',
/* 0x08c7c = "Failed to measure the TSC delta between two CPUs." */
    '\x8b','\x0a','m','e','a','s','u','r','e',' ','\x02','T','S','C',' ','d','e','l','t','a',' ','b','e','t','w','e','e','n',' ','t','w','o',' ','C','P','U','s','.',
/* 0x08ca2 = "Failed to resolve an imported (external) symbol." */
    '\x8b','\x0a','r','e','s','o','l','v','e',' ','\x87','i','m','p','o','r','t','e','d',' ','(','e','x','t','e','r','n','a','l',')',' ','s','y','m','b','o','l','.',
/* 0x08cc8 = "Host API has not enabled SVME bit in EFER MSR." */
    'H','o','s','t',' ','A','P','I',' ','\x5e','\x08','e','n','a','b','l','e','d',' ','S','V','M','E',' ','b','i','t',' ','\x0f','E','F','E','R',' ','M','S','R','.',
/* 0x08cee = "Not possible to attach drivers to the device." */
    'N','o','t',' ','p','o','s','s','i','b','l','e',' ','\x0a','a','t','t','a','c','h',' ','d','r','i','v','e','r','s',' ','\x0a','\x02','d','e','v','i','c','e','.',
/* 0x08d14 = "Filesystem can\'t be opened because it is corrupt." */
    'F','i','l','e','s','y','s','t','e','m',' ','c','a','n','\'','t',' ','\xa7','o','p','e','n','e','d',' ','\x40','i','t',' ','\x0b','c','o','r','r','u','p','t','.',
/* 0x08d3a = "Malformed or failed to parse PEM formatted data." */
    'M','a','l','f','o','r','m','e','d',' ','\xa9','\x99','\x0a','p','a','r','s','e',' ','P','E','M',' ','f','o','r','m','a','t','t','e','d',' ','d','a','t','a','.',
/* 0x08d60 = "The size of the raw optical image is too small (<= 32K)." */
    '\x03','s','i','z','e',' ','\x15','\x02','r','a','w',' ','o','p','t','i','c','a','l',' ','\x26','\x0b','\x9e','s','m','a','l','l',' ','(','<','=',' ','3','2','K',')','.',
/* 0x08d86 = "A queue is out of free items, the queueing operation failed." */
    'A',' ','q','u','e','u','e',' ','\x0b','o','u','t',' ','\x15','f','r','e','e',' ','i','t','e','m','s',',',' ','\x02','q','u','e','u','e','i','n','g',' ','\x96','\x7b',
/* 0x08dac = "Key encrypted but no password was given." */
    'K','e','y',' ','e','n','c','r','y','p','t','e','d',' ','b','u','t',' ','n','o',' ','p','a','s','s','w','o','r','d',' ','\x11','g','i','v','e','n','.',
/* 0x08dd1 = "Import ISO contains more than one joliet volume descriptor." */
    '\xc3','\xc1',' ','\x8a','m','o','r','e',' ','t','h','a','n',' ','o','n','e',' ','j','o','l','i','e','t',' ','\xd2','d','e','s','c','r','i','p','t','o','r','.',
/* 0x08df6 = "The DTB structs block ended prematurely." */
    '\x03','D','T','B',' ','s','t','r','u','c','t','s',' ','b','l','o','c','k',' ','e','n','d','e','d',' ','p','r','e','m','a','t','u','r','e','l','y','.',
/* 0x08e1b = "PCI passthru is not supported by this build." */
    'P','C','I',' ','p','a','s','s','t','h','r','u',' ','\x0b','\x08','s','u','p','p','o','r','t','e','d',' ','\xe1','t','h','i','s',' ','b','u','i','l','d','.',
/* 0x08e40 = "Failed to abort entering a critical section in ring-0." */
    '\x8b','\x0a','a','b','o','r','t',' ','e','n','t','e','r','i','n','g',' ','a',' ','c','r','i','t','i','c','a','l',' ','\xdb','\x0f','r','i','n','g','-','0','.',
/* 0x08e65 = "We were given a NULL pPage parameter." */
    'W','e',' ','w','e','r','e',' ','g','i','v','e','n',' ','a',' ','N','U','L','L',' ','p','P','a','g','e',' ','p','a','r','a','m','e','t','e','r','.',
/* 0x08e8a = "Expected read pipe, got a write pipe instead." */
    '\xb8','r','e','a','d',' ','p','i','p','e',',',' ','g','o','t',' ','a',' ','w','r','i','t','e',' ','p','i','p','e',' ','i','n','s','t','e','a','d','.',
/* 0x08eaf = "Recompilation: End translation block." */
    'R','e','c','o','m','p','i','l','a','t','i','o','n',':',' ','E','n','d',' ','t','r','a','n','s','l','a','t','i','o','n',' ','b','l','o','c','k','.',
/* 0x08ed4 = "Couldn\'t find the end of CPUID sub-leaves." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','\x02','e','n','d',' ','\x15','C','P','U','I','D',' ','s','u','b','-','l','e','a','v','e','s','.',
/* 0x08ef9 = "The environment variable is an unset record." */
    '\x03','e','n','v','i','r','o','n','m','e','n','t',' ','v','a','r','i','a','b','l','e',' ','\x0b','\x87','u','n','s','e','t',' ','r','e','c','o','r','d','.',
/* 0x08f1e = "Incompatible configuration requested." */
    'I','n','c','o','m','p','a','t','i','b','l','e',' ','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','r','e','q','u','e','s','t','e','d','.',
/* 0x08f43 = "Certificate path validator: Name constraints permits no names." */
    '\xba','\xd0','\xfe','N','a','m','e',' ','c','o','n','s','t','r','a','i','n','t','s',' ','p','e','r','m','i','t','s',' ','n','o',' ','n','a','m','e','s','.',
/* 0x08f68 = "Invalid/Corrupted configuration file." */
    'I','n','v','a','l','i','d','/','C','o','r','r','u','p','t','e','d',' ','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','f','i','l','e','.',
/* 0x08f8d = "Expected write pipe, got a read pipe instead." */
    '\xb8','w','r','i','t','e',' ','p','i','p','e',',',' ','g','o','t',' ','a',' ','r','e','a','d',' ','p','i','p','e',' ','i','n','s','t','e','a','d','.',
/* 0x08fb2 = "The boot catalog block in the import ISO is out of bounds." */
    '\x03','b','o','o','t',' ','\xe7','b','l','o','c','k',' ','\x0f','\x02','i','m','p','o','r','t',' ','\xc1',' ','\x0b','o','u','t',' ','\x15','b','o','u','n','d','s','.',
/* 0x08fd7 = "VERR_FDT_DTB_HDR_STRUCT_BLOCK_OFF_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','H','D','R','_','S','T','R','U','C','T','_','B','L','O','C','K','_','O','F','F','_','I','N','V','A','L','I','D',
/* 0x08ffc = "Error enumerating all processes in the session." */
    '\xc0','e','n','u','m','e','r','a','t','i','n','g',' ','a','l','l',' ','p','r','o','c','e','s','s','e','s',' ','\x0f','\x02','s','e','s','s','i','o','n','.',
/* 0x09021 = "The loaded XSAVE component mask is not valid." */
    '\x03','l','o','a','d','e','d',' ','X','S','A','V','E',' ','c','o','m','p','o','n','e','n','t',' ','m','a','s','k',' ','\x0b','\x08','v','a','l','i','d','.',
/* 0x09046 = "Reason for leaving RZ: Pending ring-3 IN instruction." */
    '\x93','\x10','\x81','R','Z',':',' ','P','e','n','d','i','n','g',' ','r','i','n','g','-','3',' ','I','N',' ','i','n','s','t','r','u','c','t','i','o','n','.',
/* 0x0906b = "Malformed indefinite length encoding." */
    'M','a','l','f','o','r','m','e','d',' ','i','n','d','e','f','i','n','i','t','e',' ','l','e','n','g','t','h',' ','e','n','c','o','d','i','n','g','.',
/* 0x09090 = "Node pointer does not point to the start of a node." */
    'N','o','d','e',' ','p','o','i','n','t','e','r',' ','\xb2','\x08','p','o','i','n','t',' ','\x0a','\x02','s','t','a','r','t',' ','\x15','a',' ','n','o','d','e','.',
/* 0x090b5 = "Only native endian Mach-O files are supported." */
    'O','n','l','y',' ','n','a','t','i','v','e',' ','e','n','d','i','a','n',' ','M','a','c','h','-','O',' ','f','i','l','e','s',' ','a','r','e',' ','\xa4',
/* 0x090da = "The hyper CR3 differs between PGM and CPUM." */
    '\x03','h','y','p','e','r',' ','C','R','3',' ','d','i','f','f','e','r','s',' ','b','e','t','w','e','e','n',' ','P','G','M',' ','\x9a','C','P','U','M','.',
/* 0x090ff = "VERR_ISOMK_IMPORT_BOOT_CAT_EXT_ENTRY_UNDEFINED_FLAGS" */
    '\x01','\x22','\x83','B','O','O','T','_','C','A','T','_','E','X','T','_','E','N','T','R','Y','_','U','N','D','E','F','I','N','E','D','_','F','L','A','G','S',
/* 0x09124 = "Key algorithm parameters are not known/supported." */
    'K','e','y',' ','\xd4','p','a','r','a','m','e','t','e','r','s',' ','a','r','e',' ','\x08','k','n','o','w','n','/','s','u','p','p','o','r','t','e','d','.',
/* 0x09149 = "VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_IMAGE_OUT_OF_BOUNDS" */
    '\x01','\x22','\x83','B','O','O','T','_','C','A','T','_','E','N','T','R','Y','_','I','M','A','G','E','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x0916e = "OpenSSL and IPRT disagree on the signature." */
    'O','p','e','n','S','S','L',' ','\x9a','I','P','R','T',' ','d','i','s','a','g','r','e','e',' ','o','n',' ','\x02','s','i','g','n','a','t','u','r','e','.',
/* 0x09193 = "Invalid size of a SSM field with the specified transformation." */
    '\x0c','s','i','z','e',' ','\x15','a',' ','S','S','M',' ','f','i','e','l','d',' ','\x80','\x02','\x18','t','r','a','n','s','f','o','r','m','a','t','i','o','n','.',
/* 0x091b8 = "ICB is too small to contain anything useful." */
    'I','C','B',' ','\x0b','\x9e','s','m','a','l','l',' ','\x0a','c','o','n','t','a','i','n',' ','a','n','y','t','h','i','n','g',' ','u','s','e','f','u','l','.',
/* 0x091dd = "Process Purification Failure: Unknown memory type of executable memory." */
    '\x1e','P','u','r','i','f','i','c','a','t','i','o','n',' ','\x12','\xef','\x86','\xf3','\x15','e','x','e','c','u','t','a','b','l','e',' ','m','e','m','o','r','y','.',
/* 0x09202 = "The device instance have no such logical unit." */
    '\x03','\xa3','i','n','s','t','a','n','c','e',' ','h','a','v','e',' ','n','o',' ','s','u','c','h',' ','l','o','g','i','c','a','l',' ','u','n','i','t','.',
/* 0x09227 = "Not able to allocate contiguous memory." */
    'N','o','t',' ','a','b','l','e',' ','\x0a','a','l','l','o','c','a','t','e',' ','c','o','n','t','i','g','u','o','u','s',' ','m','e','m','o','r','y','.',
/* 0x0924c = "The tracer cannot open it self in the same session." */
    '\x03','t','r','a','c','e','r',' ','\xd1','o','p','e','n',' ','i','t',' ','s','e','l','f',' ','\x0f','\x02','s','a','m','e',' ','s','e','s','s','i','o','n','.',
/* 0x09271 = "Certificate path validator: Name constraints does not permits the certificate name." */
    '\xba','\xd0','\xfe','N','a','m','e',' ','c','o','n','s','t','r','a','i','n','t','s',' ','\xb2','\x08','p','e','r','m','i','t','s',' ','\x02','\xa0','n','a','m','e','.',
/* 0x09296 = "Mismatch between IPRT and native loader." */
    'M','i','s','m','a','t','c','h',' ','b','e','t','w','e','e','n',' ','I','P','R','T',' ','\x9a','n','a','t','i','v','e',' ','l','o','a','d','e','r','.',
/* 0x092bb = "Encountered a \'-\' during conversion to an unsigned value." */
    '\xa5','a',' ','\'','-','\'',' ','d','u','r','i','n','g',' ','c','o','n','v','e','r','s','i','o','n',' ','\x0a','\x87','u','n','s','i','g','n','e','d',' ','\xe8',
/* 0x092e0 = "validation of the fixup section (in the LX header) failed." */
    'v','a','l','i','d','a','t','i','o','n',' ','\x15','\x02','f','i','x','u','p',' ','\xdb','(','i','n',' ','\x02','L','X',' ','h','e','a','d','e','r',')',' ','\x7b',
/* 0x09305 = "Invalid page count given to GMMR3FreePagesPerform." */
    '\x0c','\xcc','c','o','u','n','t',' ','g','i','v','e','n',' ','\x0a','G','M','M','R','3','F','r','e','e','P','a','g','e','s','P','e','r','f','o','r','m','.',
/* 0x0932a = "Reason for leaving R0: Hit a ring-0 assertion on EMT." */
    '\x93','\x10','\x81','R','0',':',' ','H','i','t',' ','a',' ','r','i','n','g','-','0',' ','a','s','s','e','r','t','i','o','n',' ','o','n',' ','E','M','T','.',
/* 0x0934f = "The indirect data digest size does not match the digest algorithm." */
    '\x03','i','n','d','i','r','e','c','t',' ','\x9d','\xd7','s','i','z','e',' ','\xb2','\x08','m','a','t','c','h',' ','\x02','\xd7','a','l','g','o','r','i','t','h','m','.',
/* 0x09374 = "Certificate path validator: Intermediate certificate is not a version 3 certificate." */
    '\xba','\xd0','\xfe','I','n','t','e','r','m','e','d','i','a','t','e',' ','\xa0','\x0b','\x08','a',' ','\xcf','3',' ','c','e','r','t','i','f','i','c','a','t','e','.',
/* 0x09398 = "Reason for leaving RC: The IRET resuming guest code trapped." */
    '\x93','\x10','\x81','R','C',':',' ','\x03','I','R','E','T',' ','r','e','s','u','m','i','n','g',' ','\xbb','c','o','d','e',' ','t','r','a','p','p','e','d','.',
/* 0x093bc = "Current virtual machine state prevents the operation." */
    'C','u','r','r','e','n','t',' ','v','i','r','t','u','a','l',' ','m','a','c','h','i','n','e',' ','\xca','p','r','e','v','e','n','t','s',' ','\x02','\xea',
/* 0x093e0 = "Unexpected/unknown/bad descriptor in volume descriptor sequence." */
    'U','n','e','x','p','e','c','t','e','d','/','u','n','k','n','o','w','n','/','b','a','d',' ','\xe3','\x0f','\xd2','\xe3','s','e','q','u','e','n','c','e','.',
/* 0x09404 = "Invalid address mode passed to an IEM function." */
    '\x0c','a','d','d','r','e','s','s',' ','m','o','d','e',' ','p','a','s','s','e','d',' ','\x0a','\x87','I','E','M',' ','f','u','n','c','t','i','o','n','.',
/* 0x09428 = "The paging mode of the host is not supported yet." */
    '\x03','p','a','g','i','n','g',' ','m','o','d','e',' ','\x15','\x02','h','o','s','t',' ','\x0b','\x08','s','u','p','p','o','r','t','e','d',' ','y','e','t','.',
/* 0x0944c = "The thread is not a valid signaller of the event." */
    '\x03','t','h','r','e','a','d',' ','\x0b','\x08','a',' ','v','a','l','i','d',' ','s','i','g','n','a','l','l','e','r',' ','\x15','\x02','e','v','e','n','t','.',
/* 0x09470 = "Unable to parse the CodeView debug information." */
    '\xe0','\x0a','p','a','r','s','e',' ','\x02','C','o','d','e','V','i','e','w',' ','d','e','b','u','g',' ','i','n','f','o','r','m','a','t','i','o','n','.',
/* 0x09494 = "Encountered an unsupported Solaris Tar extension." */
    '\xa5','\x87','u','n','s','u','p','p','o','r','t','e','d',' ','S','o','l','a','r','i','s',' ','T','a','r',' ','e','x','t','e','n','s','i','o','n','.',
/* 0x094b8 = "The image is required to force integrity checks." */
    '\x03','\x26','\x0b','r','e','q','u','i','r','e','d',' ','\x0a','f','o','r','c','e',' ','i','n','t','e','g','r','i','t','y',' ','c','h','e','c','k','s','.',
/* 0x094dc = "The timer queue is not longer allowed to grow." */
    '\x03','t','i','m','e','r',' ','q','u','e','u','e',' ','\x0b','\x08','l','o','n','g','e','r',' ','a','l','l','o','w','e','d',' ','\x0a','g','r','o','w','.',
/* 0x09500 = "The expanding of the dynamic mapping cache failed." */
    '\x03','e','x','p','a','n','d','i','n','g',' ','\x15','\x02','d','y','n','a','m','i','c',' ','m','a','p','p','i','n','g',' ','c','a','c','h','e',' ','\x7b',
/* 0x09524 = "The MMIO handler was called for a bogus address!" */
    '\x03','\xd3',' ','h','a','n','d','l','e','r',' ','\x11','c','a','l','l','e','d',' ','\x10','a',' ','b','o','g','u','s',' ','a','d','d','r','e','s','s','!',
/* 0x09548 = "The lock validator detected a deadlock." */
    '\x03','l','o','c','k',' ','v','a','l','i','d','a','t','o','r',' ','d','e','t','e','c','t','e','d',' ','a',' ','d','e','a','d','l','o','c','k','.',
/* 0x0956c = "The ELF loader encountered a relocation type which is not implemented." */
    '\x03','E','L','F',' ','\xd9','\xaf','a',' ','r','e','l','o','c','a','t','i','o','n',' ','\xf3','\xed','\x0b','\x08','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x09590 = "Failed while setting up a redirector rule." */
    '\x8b','w','h','i','l','e',' ','s','e','t','t','i','n','g',' ','u','p',' ','a',' ','r','e','d','i','r','e','c','t','o','r',' ','r','u','l','e','.',
/* 0x095b4 = "The breakpoint owner callback returned an invalid status code." */
    '\x03','\xbf','o','w','n','e','r',' ','c','a','l','l','b','a','c','k',' ','r','e','t','u','r','n','e','d',' ','\x87','\x8f','s','t','a','t','u','s',' ','\x84',
/* 0x095d8 = "VERR_FDT_DTB_STRUCTS_BLOCK_PREMATURE_END" */
    '\x01','F','D','T','_','D','T','B','_','S','T','R','U','C','T','S','_','B','L','O','C','K','_','P','R','E','M','A','T','U','R','E','_','E','N','D',
/* 0x095fc = "Reason for leaving RC: Sync the GDT table to solve a conflict." */
    '\x93','\x10','\x81','R','C',':',' ','S','y','n','c',' ','\x02','G','D','T',' ','\xb1','\x0a','s','o','l','v','e',' ','a',' ','c','o','n','f','l','i','c','t','.',
/* 0x09620 = "Generic debug event, suspend the VM for debugging." */
    '\xa6','d','e','b','u','g',' ','e','v','e','n','t',',',' ','s','u','s','p','e','n','d',' ','\x02','\xcd',' ','\x10','d','e','b','u','g','g','i','n','g','.',
/* 0x09644 = "Recompiler: Duplicate argument variable number." */
    '\x13','D','u','p','l','i','c','a','t','e',' ','a','r','g','u','m','e','n','t',' ','v','a','r','i','a','b','l','e',' ','n','u','m','b','e','r','.',
/* 0x09668 = "The guest has not setup use of the paravirtualized TSC." */
    '\x03','\xbb','\x5e','\x08','s','e','t','u','p',' ','u','s','e',' ','\x15','\x02','p','a','r','a','v','i','r','t','u','a','l','i','z','e','d',' ','T','S','C','.',
/* 0x0968c = "Encountered a load command that\'s not implemented." */
    '\xa5','a',' ','l','o','a','d',' ','c','o','m','m','a','n','d',' ','t','h','a','t','\'','s',' ','\x08','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x096b0 = "The timer can\'t be started because it\'s already active." */
    '\x03','t','i','m','e','r',' ','c','a','n','\'','t',' ','\xa7','s','t','a','r','t','e','d',' ','\x40','i','t','\'','s',' ','\x7f','a','c','t','i','v','e','.',
/* 0x096d4 = "The DTB property payload string is not terminated." */
    '\x03','D','T','B',' ','p','r','o','p','e','r','t','y',' ','p','a','y','l','o','a','d',' ','\xf2','\x0b','\x08','t','e','r','m','i','n','a','t','e','d','.',
/* 0x096f8 = "OpenSSL failed to init PKIX cipher algorithm context." */
    'O','p','e','n','S','S','L',' ','\x99','\x0a','i','n','i','t',' ','P','K','I','X',' ','c','i','p','h','e','r',' ','\xd4','c','o','n','t','e','x','t','.',
/* 0x0971c = "General failure - DON\'T USE THIS!!!." */
    'G','e','n','e','r','a','l',' ','f','a','i','l','u','r','e',' ','-',' ','D','O','N','\'','T',' ','U','S','E',' ','T','H','I','S','!','!','!','.',
/* 0x09740 = "The caller does not have a reference to the object." */
    '\x03','c','a','l','l','e','r',' ','\xb2','\x08','h','a','v','e',' ','a',' ','r','e','f','e','r','e','n','c','e',' ','\x0a','\x02','o','b','j','e','c','t','.',
/* 0x09764 = "Couldn\'t find ROM page from saved state." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','R','O','M',' ','\xcc','f','r','o','m',' ','s','a','v','e','d',' ','s','t','a','t','e','.',
/* 0x09788 = "Invalid operand size passed to an IEM function." */
    '\x0c','o','p','e','r','a','n','d',' ','s','i','z','e',' ','p','a','s','s','e','d',' ','\x0a','\x87','I','E','M',' ','f','u','n','c','t','i','o','n','.',
/* 0x097ac = "Catch any access and route it thru PGM." */
    'C','a','t','c','h',' ','a','n','y',' ','a','c','c','e','s','s',' ','\x9a','r','o','u','t','e',' ','i','t',' ','t','h','r','u',' ','P','G','M','.',
/* 0x097d0 = "Image Verification Failure: Authenticode parsing output." */
    'I','m','a','g','e',' ','\x0d','\x12','A','u','t','h','e','n','t','i','c','o','d','e',' ','p','a','r','s','i','n','g',' ','o','u','t','p','u','t','.',
/* 0x097f4 = "An invalid I/O port size was specified for a read or write operation." */
    'A','n',' ','\x8f','I','/','O',' ','p','o','r','t',' ','s','i','z','e',' ','\x11','\x18','\x10','a',' ','r','e','a','d',' ','\xa9','w','r','i','t','e',' ','\xea',
/* 0x09818 = "Continue execution after patch trap." */
    'C','o','n','t','i','n','u','e',' ','e','x','e','c','u','t','i','o','n',' ','a','f','t','e','r',' ','p','a','t','c','h',' ','t','r','a','p','.',
/* 0x0983c = "VFS chain element takes a file system (vfs) object as input." */
    '\x8d',' ','\xa1','\x5c','t','a','k','e','s',' ','a',' ','\x1f','s','y','s','t','e','m',' ','(','v','f','s',')',' ','\xa8','a','s',' ','i','n','p','u','t','.',
/* 0x09860 = "Syntax error - an undefined variable was referenced." */
    '\xfa','\x09','-',' ','\x87','u','n','d','e','f','i','n','e','d',' ','v','a','r','i','a','b','l','e',' ','\x11','r','e','f','e','r','e','n','c','e','d','.',
/* 0x09884 = "VERR_LDRVI_EXPECTED_INDIRECT_DATA_CONTENT_OID" */
    '\x01','\xf4','E','X','P','E','C','T','E','D','_','I','N','D','I','R','E','C','T','_','D','A','T','A','_','C','O','N','T','E','N','T','_','O','I','D',
/* 0x098a8 = "Requested to import an unknown ISO format." */
    'R','e','q','u','e','s','t','e','d',' ','\x0a','i','m','p','o','r','t',' ','\x87','u','n','k','n','o','w','n',' ','\xc1',' ','f','o','r','m','a','t','.',
/* 0x098cc = "Error encoding the password for key decryption." */
    '\xc0','e','n','c','o','d','i','n','g',' ','\x02','p','a','s','s','w','o','r','d',' ','\x10','k','e','y',' ','d','e','c','r','y','p','t','i','o','n','.',
/* 0x098f0 = "VERR_URI_INVALID_ESCAPED_UTF8_CONTINUATION_BYTE" */
    '\x01','U','R','I','_','\x05','E','S','C','A','P','E','D','_','U','T','F','8','_','C','O','N','T','I','N','U','A','T','I','O','N','_','B','Y','T','E',
/* 0x09914 = "Specified digest not supported in this context." */
    'S','p','e','c','i','f','i','e','d',' ','\xd7','\x08','s','u','p','p','o','r','t','e','d',' ','\x0f','t','h','i','s',' ','c','o','n','t','e','x','t','.',
/* 0x09938 = "Internal processing error in the PGM physical RAM range lookup code." */
    '\x07','\x04','\x09','\x0f','\x02','P','G','M',' ','p','h','y','s','i','c','a','l',' ','R','A','M',' ','r','a','n','g','e',' ','l','o','o','k','u','p',' ','\x84',
/* 0x0995c = "Unresolved (unknown) host platform error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','h','o','s','t',' ','p','l','a','t','f','o','r','m',' ','\x85',
/* 0x09980 = "Incomplete packet was submitted by guest." */
    'I','n','c','o','m','p','l','e','t','e',' ','p','a','c','k','e','t',' ','\x11','s','u','b','m','i','t','t','e','d',' ','\xe1','g','u','e','s','t','.',
/* 0x099a4 = "VERR_FDT_DTB_STRUCTS_BLOCK_TOKEN_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','S','T','R','U','C','T','S','_','B','L','O','C','K','_','T','O','K','E','N','_','I','N','V','A','L','I','D',
/* 0x099c8 = "VERR_REST_REQUIRED_HEADER_PARAMETER_NOT_SET" */
    '\x01','R','E','S','T','_','R','E','Q','U','I','R','E','D','_','H','E','A','D','E','R','_','P','A','R','A','M','E','T','E','R','_','\x06','S','E','T',
/* 0x099ec = "Process Verification Failure: Error reading process memory for comparing with disk data." */
    '\x1e','\x0d','\x12','\xc0','r','e','a','d','i','n','g',' ','\x92','\x86','\x10','c','o','m','p','a','r','i','n','g',' ','\x80','d','i','s','k',' ','d','a','t','a','.',
/* 0x09a10 = "The shadow paging mode is not supported yet." */
    '\x03','s','h','a','d','o','w',' ','p','a','g','i','n','g',' ','m','o','d','e',' ','\x0b','\x08','s','u','p','p','o','r','t','e','d',' ','y','e','t','.',
/* 0x09a34 = "Network dropped connection on reset." */
    'N','e','t','w','o','r','k',' ','d','r','o','p','p','e','d',' ','c','o','n','n','e','c','t','i','o','n',' ','o','n',' ','r','e','s','e','t','.',
/* 0x09a58 = "Import ISO contains a bad supplementary volume descriptor." */
    '\xc3','\xc1',' ','\x8a','a',' ','b','a','d',' ','s','u','p','p','l','e','m','e','n','t','a','r','y',' ','\xd2','d','e','s','c','r','i','p','t','o','r','.',
/* 0x09a7c = "Invalid parameters passed to the lock validator." */
    '\x0c','p','a','r','a','m','e','t','e','r','s',' ','p','a','s','s','e','d',' ','\x0a','\x02','l','o','c','k',' ','v','a','l','i','d','a','t','o','r','.',
/* 0x09aa0 = "VERR_FDT_DTB_STRUCTS_BLOCK_STRING_NOT_TERMINATED" */
    '\x01','F','D','T','_','D','T','B','_','S','T','R','U','C','T','S','_','B','L','O','C','K','_','\xd5','_','\x06','T','E','R','M','I','N','A','T','E','D',
/* 0x09ac4 = "No host backend attached / available." */
    '\xdf','h','o','s','t',' ','b','a','c','k','e','n','d',' ','a','t','t','a','c','h','e','d',' ','/',' ','a','v','a','i','l','a','b','l','e','.',
/* 0x09ae7 = "The CR3 address specified memory we don\'t know about." */
    '\x03','C','R','3',' ','a','d','d','r','e','s','s',' ','\x18','\x86','w','e',' ','d','o','n','\'','t',' ','k','n','o','w',' ','a','b','o','u','t','.',
/* 0x09b0a = "VERR_FDT_DTB_MEM_RSV_BLOCK_TERMINATOR_MISSING" */
    '\x01','F','D','T','_','D','T','B','_','M','E','M','_','R','S','V','_','B','L','O','C','K','_','T','E','R','M','I','N','A','T','O','R','_','\xc4',
/* 0x09b2d = "VERR_CR_X509_CPV_UNEXP_GENERAL_SUBTREE_CHOICE" */
    '\x01','\x24','\xb7','C','P','V','_','U','N','E','X','P','_','G','E','N','E','R','A','L','_','S','U','B','T','R','E','E','_','C','H','O','I','C','E',
/* 0x09b50 = "Ping-Pong listen or speak out of turn error." */
    'P','i','n','g','-','P','o','n','g',' ','l','i','s','t','e','n',' ','\xa9','s','p','e','a','k',' ','o','u','t',' ','\x15','t','u','r','n',' ','\x85',
/* 0x09b73 = "The session has no tracer associated with it." */
    '\x03','s','e','s','s','i','o','n',' ','\x5e','n','o',' ','t','r','a','c','e','r',' ','a','s','s','o','c','i','a','t','e','d',' ','\x80','i','t','.',
/* 0x09b96 = "Attempted to disabled a breakpoint which was already disabled." */
    'A','t','t','e','m','p','t','e','d',' ','\x0a','d','i','s','a','b','l','e','d',' ','a',' ','\xbf','\xed','\x11','\x7f','d','i','s','a','b','l','e','d','.',
/* 0x09bb9 = "VERR_REST_REQUIRED_QUERY_PARAMETER_NOT_SET" */
    '\x01','R','E','S','T','_','R','E','Q','U','I','R','E','D','_','Q','U','E','R','Y','_','P','A','R','A','M','E','T','E','R','_','\x06','S','E','T',
/* 0x09bdc = "Attempted to insert mode with invalid key range." */
    'A','t','t','e','m','p','t','e','d',' ','\x0a','i','n','s','e','r','t',' ','m','o','d','e',' ','\x80','\x8f','k','e','y',' ','r','a','n','g','e','.',
/* 0x09bff = "The page hash table is not strictly ordered by offset." */
    '\x03','\xcc','h','a','s','h',' ','\xb1','\x0b','\x08','s','t','r','i','c','t','l','y',' ','o','r','d','e','r','e','d',' ','\xe1','o','f','f','s','e','t','.',
/* 0x09c22 = "The PE loader encountered a certificate with an unsupported type or structure revision." */
    '\x03','P','E',' ','\xd9','\xaf','a',' ','\xa0','\x80','\x87','u','n','s','u','p','p','o','r','t','e','d',' ','\xf3','\xa9','\xec','r','e','v','i','s','i','o','n','.',
/* 0x09c45 = "An illegal lock upgrade was attempted." */
    'A','n',' ','i','l','l','e','g','a','l',' ','l','o','c','k',' ','u','p','g','r','a','d','e',' ','\x11','a','t','t','e','m','p','t','e','d','.',
/* 0x09c68 = "General failure during URB queuing." */
    'G','e','n','e','r','a','l',' ','f','a','i','l','u','r','e',' ','d','u','r','i','n','g',' ','U','R','B',' ','q','u','e','u','i','n','g','.',
/* 0x09c8b = "The machine was powered off while saving." */
    '\x03','m','a','c','h','i','n','e',' ','\x11','p','o','w','e','r','e','d',' ','o','f','f',' ','w','h','i','l','e',' ','s','a','v','i','n','g','.',
/* 0x09cae = "Host backend couldn\'t be initialized." */
    'H','o','s','t',' ','b','a','c','k','e','n','d',' ','c','o','u','l','d','n','\'','t',' ','\xa7','i','n','i','t','i','a','l','i','z','e','d','.',
/* 0x09cd1 = "Error while calculating a digest for a PKCS #7 verification operation." */
    '\xc0','w','h','i','l','e',' ','c','a','l','c','u','l','a','t','i','n','g',' ','a',' ','\xd7','\x10','a',' ','P','K','C','S',' ','#','7',' ','\xf8','\xea',
/* 0x09cf4 = "PE image data without any valid content was not expected." */
    'P','E',' ','\x26','\x9d','w','i','t','h','o','u','t',' ','a','n','y',' ','v','a','l','i','d',' ','\xf0','\x11','\x08','e','x','p','e','c','t','e','d','.',
/* 0x09d17 = "The RTPROC_FLAGS_DETACHED flag isn\'t supported." */
    '\x03','R','T','P','R','O','C','_','F','L','A','G','S','_','D','E','T','A','C','H','E','D',' ','f','l','a','g',' ','i','s','n','\'','t',' ','\xa4',
/* 0x09d3a = "Process Verification Failure: One of the section in the image file is not mapped into memory." */
    '\x1e','\x0d','\x12','O','n','e',' ','\x15','\x02','\xdb','\x0f','\x02','\x26','\x1f','\x0b','\x08','m','a','p','p','e','d',' ','i','n','t','o',' ','m','e','m','o','r','y','.',
/* 0x09d5d = "The DTB structs block starts with an invalid token." */
    '\x03','D','T','B',' ','s','t','r','u','c','t','s',' ','b','l','o','c','k',' ','s','t','a','r','t','s',' ','\x80','\x87','\x8f','t','o','k','e','n','.',
/* 0x09d80 = "iSCSI: Initiator secret not decrypted." */
    'i','S','C','S','I',':',' ','I','n','i','t','i','a','t','o','r',' ','s','e','c','r','e','t',' ','\x08','d','e','c','r','y','p','t','e','d','.',
/* 0x09da3 = "VERR_XAR_ARCHIVED_AND_EXTRACTED_SIZES_MISMATCH" */
    '\x01','X','A','R','_','A','R','C','H','I','V','E','D','_','A','N','D','_','E','X','T','R','A','C','T','E','D','_','S','I','Z','E','S','_','\x19',
/* 0x09dc6 = "Don\'t mess around with ballooned pages." */
    'D','o','n','\'','t',' ','m','e','s','s',' ','a','r','o','u','n','d',' ','\x80','b','a','l','l','o','o','n','e','d',' ','p','a','g','e','s','.',
/* 0x09de9 = "The current HTTP request was forcefully aborted." */
    '\x03','c','u','r','r','e','n','t',' ','H','T','T','P',' ','\xaa','\x11','f','o','r','c','e','f','u','l','l','y',' ','a','b','o','r','t','e','d','.',
/* 0x09e0c = "The async completion task is already suspended." */
    '\x03','a','s','y','n','c',' ','c','o','m','p','l','e','t','i','o','n',' ','t','a','s','k',' ','\x0b','\x7f','s','u','s','p','e','n','d','e','d','.',
/* 0x09e2f = "Import ISO contains an unsupported primary volume descriptor version." */
    '\xc3','\xc1',' ','\x8a','\x87','u','n','s','u','p','p','o','r','t','e','d',' ','p','r','i','m','a','r','y',' ','\xd2','\xe3','v','e','r','s','i','o','n','.',
/* 0x09e52 = "VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_USES_UNUSED_FIELD" */
    '\x01','\x22','\x83','B','O','O','T','_','C','A','T','_','E','N','T','R','Y','_','U','S','E','S','_','U','N','U','S','E','D','_','F','I','E','L','D',
/* 0x09e75 = "Too long forwarder chain or there is a loop." */
    'T','o','o',' ','l','o','n','g',' ','f','o','r','w','a','r','d','e','r',' ','\xa1','\xa9','t','h','e','r','e',' ','\x0b','a',' ','l','o','o','p','.',
/* 0x09e98 = "VERR_ISOMK_IMPORT_BOOT_CAT_EXT_ENTRY_END_OF_SECTOR" */
    '\x01','\x22','\x83','B','O','O','T','_','C','A','T','_','E','X','T','_','E','N','T','R','Y','_','E','N','D','_','O','F','_','S','E','C','T','O','R',
/* 0x09ebb = "Service rejected client connection." */
    'S','e','r','v','i','c','e',' ','r','e','j','e','c','t','e','d',' ','c','l','i','e','n','t',' ','c','o','n','n','e','c','t','i','o','n','.',
/* 0x09ede = "The compressed data started with a bad header." */
    '\x03','c','o','m','p','r','e','s','s','e','d',' ','\x9d','s','t','a','r','t','e','d',' ','\x80','a',' ','b','a','d',' ','h','e','a','d','e','r','.',
/* 0x09f01 = "CPU microarch lookup matched by name." */
    'C','P','U',' ','m','i','c','r','o','a','r','c','h',' ','l','o','o','k','u','p',' ','m','a','t','c','h','e','d',' ','\xe1','n','a','m','e','.',
/* 0x09f24 = "The dynamic mapping cache for physical memory failed." */
    '\x03','d','y','n','a','m','i','c',' ','m','a','p','p','i','n','g',' ','c','a','c','h','e',' ','\x10','p','h','y','s','i','c','a','l',' ','\x86','\x7b',
/* 0x09f47 = "A boot catalog entry in the import ISO has an unknown type." */
    'A',' ','b','o','o','t',' ','\xe7','\xc8','\x0f','\x02','i','m','p','o','r','t',' ','\xc1',' ','\x5e','\x87','u','n','k','n','o','w','n',' ','t','y','p','e','.',
/* 0x09f6a = "Too many calls to the service from a client." */
    'T','o','o',' ','\xb4','c','a','l','l','s',' ','\x0a','\x02','s','e','r','v','i','c','e',' ','f','r','o','m',' ','a',' ','c','l','i','e','n','t','.',
/* 0x09f8d = "Don\'t call again until the final pass." */
    'D','o','n','\'','t',' ','c','a','l','l',' ','a','g','a','i','n',' ','u','n','t','i','l',' ','\x02','f','i','n','a','l',' ','p','a','s','s','.',
/* 0x09fb0 = "The selected platform architecture is not supported." */
    '\x03','s','e','l','e','c','t','e','d',' ','p','l','a','t','f','o','r','m',' ','a','r','c','h','i','t','e','c','t','u','r','e',' ','\x0b','\x08','\xa4',
/* 0x09fd3 = "No GIM provider is configured for this VM." */
    '\xdf','G','I','M',' ','p','r','o','v','i','d','e','r',' ','\x0b','c','o','n','f','i','g','u','r','e','d',' ','\x10','t','h','i','s',' ','V','M','.',
/* 0x09ff6 = "DWARF LEB value overflows the decoder type." */
    'D','W','A','R','F',' ','L','E','B',' ','\xf5','o','v','e','r','f','l','o','w','s',' ','\x02','d','e','c','o','d','e','r',' ','t','y','p','e','.',
/* 0x0a019 = "Support for forwarders has not been implemented." */
    'S','u','p','p','o','r','t',' ','\x10','f','o','r','w','a','r','d','e','r','s',' ','\x5e','\x08','\xcb','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x0a03c = "VMDK: Format is invalid/inconsistent." */
    'V','M','D','K',':',' ','F','o','r','m','a','t',' ','\x0b','i','n','v','a','l','i','d','/','i','n','c','o','n','s','i','s','t','e','n','t','.',
/* 0x0a05f = "The address (virtual or physical) is too big." */
    '\x03','a','d','d','r','e','s','s',' ','(','v','i','r','t','u','a','l',' ','\xa9','p','h','y','s','i','c','a','l',')',' ','\x0b','\x9e','b','i','g','.',
/* 0x0a082 = "The length of the segment name is out of range." */
    '\x03','l','e','n','g','t','h',' ','\x15','\x02','s','e','g','m','e','n','t',' ','n','a','m','e',' ','\x0b','o','u','t',' ','\x15','r','a','n','g','e','.',
/* 0x0a0a5 = "Bad VTG header - size value is not a multiple of the structure size." */
    '\x9f','V','T','G',' ','\xb3','-',' ','s','i','z','e',' ','\xf5','\x0b','\x08','a',' ','m','u','l','t','i','p','l','e',' ','\x15','\x02','\xec','s','i','z','e','.',
/* 0x0a0c8 = "The signature is too long for the scratch buffer." */
    '\x03','s','i','g','n','a','t','u','r','e',' ','\x0b','\x9e','l','o','n','g',' ','\x10','\x02','s','c','r','a','t','c','h',' ','b','u','f','f','e','r','.',
/* 0x0a0eb = "The async completion task is not suspended." */
    '\x03','a','s','y','n','c',' ','c','o','m','p','l','e','t','i','o','n',' ','t','a','s','k',' ','\x0b','\x08','s','u','s','p','e','n','d','e','d','.',
/* 0x0a10e = "One or the PDPEs specified memory we don\'t know about." */
    'O','n','e',' ','\xa9','\x02','P','D','P','E','s',' ','\x18','\x86','w','e',' ','d','o','n','\'','t',' ','k','n','o','w',' ','a','b','o','u','t','.',
/* 0x0a130 = "NEM init failed because of missing kernel API (#2)." */
    '\xee',' ','i','n','i','t',' ','\x99','\x40','\x15','m','i','s','s','i','n','g',' ','k','e','r','n','e','l',' ','A','P','I',' ','(','#','2',')','.',
/* 0x0a152 = "VERR_FDT_DTB_HDR_LAST_COMPAT_VERSION_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','H','D','R','_','L','A','S','T','_','C','O','M','P','A','T','_','\xbc','_','I','N','V','A','L','I','D',
/* 0x0a174 = "Already aliased to a different page." */
    'A','l','r','e','a','d','y',' ','a','l','i','a','s','e','d',' ','\x0a','a',' ','d','i','f','f','e','r','e','n','t',' ','p','a','g','e','.',
/* 0x0a196 = "Reason for leaving RC: int3 with EIP pointing to patch code." */
    '\x93','\x10','\x81','R','C',':',' ','i','n','t','3',' ','\x80','E','I','P',' ','p','o','i','n','t','i','n','g',' ','\x0a','p','a','t','c','h',' ','\x84',
/* 0x0a1b8 = "Precodition no 0 in hmR0VMXStartVm failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','n','o',' ','0',' ','\x0f','h','m','R','0','V','M','X','S','t','a','r','t','V','m',' ','\x7b',
/* 0x0a1da = "Found something which isn\'t a file nor a directory (hardening)." */
    'F','o','u','n','d',' ','s','o','m','e','t','h','i','n','g',' ','\xed','i','s','n','\'','t',' ','a',' ','\x1f','n','o','r',' ','a',' ','\x25','\xae',
/* 0x0a1fc = "This VirtualBox build does not support raw-mode." */
    'T','h','i','s',' ','V','i','r','t','u','a','l','B','o','x',' ','b','u','i','l','d',' ','\xb2','\x08','\xce','r','a','w','-','m','o','d','e','.',
/* 0x0a21e = "ROM page mismatch between saved state and the VM." */
    'R','O','M',' ','\xcc','m','i','s','m','a','t','c','h',' ','b','e','t','w','e','e','n',' ','s','a','v','e','d',' ','\xca','\x9a','\x02','V','M','.',
/* 0x0a240 = "The integer value was too big for the requested representation." */
    '\x03','i','n','t','e','g','e','r',' ','\xf5','\x11','\x9e','b','i','g',' ','\x10','\x02','\xde','r','e','p','r','e','s','e','n','t','a','t','i','o','n','.',
/* 0x0a262 = "VERR_PAGE_HASH_TAB_HASHES_NON_SECTION_DATA" */
    '\x01','\xdc','H','A','S','H','_','T','A','B','_','H','A','S','H','E','S','_','N','O','N','_','S','E','C','T','I','O','N','_','D','A','T','A',
/* 0x0a284 = "There is not enough data to satisfy the request." */
    'T','h','e','r','e',' ','\x0b','\x08','e','n','o','u','g','h',' ','\x9d','\x0a','s','a','t','i','s','f','y',' ','\x02','r','e','q','u','e','s','t','.',
/* 0x0a2a6 = "The image base address is to high for this image type." */
    '\x03','\x26','b','a','s','e',' ','a','d','d','r','e','s','s',' ','\x0b','\x0a','h','i','g','h',' ','\x10','t','h','i','s',' ','\x26','t','y','p','e','.',
/* 0x0a2c8 = "VERR_ISOMK_BOOT_CAT_EXPECTED_SECTION_HEADER" */
    '\x01','\x22','B','O','O','T','_','C','A','T','_','E','X','P','E','C','T','E','D','_','S','E','C','T','I','O','N','_','H','E','A','D','E','R',
/* 0x0a2ea = "Type error opening the ApiPort LPC object." */
    'T','y','p','e',' ','\x09','o','p','e','n','i','n','g',' ','\x02','A','p','i','P','o','r','t',' ','L','P','C',' ','o','b','j','e','c','t','.',
/* 0x0a30c = "VERR_PDM_MISCONFIGURED_DRV_TRANSFORMATION" */
    '\x01','\x7d','M','I','S','C','O','N','F','I','G','U','R','E','D','_','D','R','V','_','T','R','A','N','S','F','O','R','M','A','T','I','O','N',
/* 0x0a32e = "NEM init failed because of missing kernel API (#4)." */
    '\xee',' ','i','n','i','t',' ','\x99','\x40','\x15','m','i','s','s','i','n','g',' ','k','e','r','n','e','l',' ','A','P','I',' ','(','#','4',')','.',
/* 0x0a350 = "VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_CONTINUATION_EOS" */
    '\x01','\x22','\x83','B','O','O','T','_','C','A','T','_','E','N','T','R','Y','_','C','O','N','T','I','N','U','A','T','I','O','N','_','E','O','S',
/* 0x0a372 = "Couldn\'t map pages during receive." */
    'C','o','u','l','d','n','\'','t',' ','m','a','p',' ','p','a','g','e','s',' ','d','u','r','i','n','g',' ','r','e','c','e','i','v','e','.',
/* 0x0a394 = "NEM init failed because of missing kernel API (#3)." */
    '\xee',' ','i','n','i','t',' ','\x99','\x40','\x15','m','i','s','s','i','n','g',' ','k','e','r','n','e','l',' ','A','P','I',' ','(','#','3',')','.',
/* 0x0a3b6 = "The data in the saved state doesn't conform to expectations." */
    '\x03','\x9d','\x0f','\x02','s','a','v','e','d',' ','\xca','\xc7','c','o','n','f','o','r','m',' ','\x0a','e','x','p','e','c','t','a','t','i','o','n','s','.',
/* 0x0a3d8 = "VERR_CR_PKIX_OSSL_CIPHER_ALGO_NOT_KNOWN_EVP" */
    '\x01','\x24','P','K','I','X','_','O','S','S','L','_','C','I','P','H','E','R','_','A','L','G','O','_','\x06','K','N','O','W','N','_','E','V','P',
/* 0x0a3fa = "Semaphore destroyed while waiting." */
    'S','e','m','a','p','h','o','r','e',' ','d','e','s','t','r','o','y','e','d',' ','w','h','i','l','e',' ','w','a','i','t','i','n','g','.',
/* 0x0a41c = "The device instance have no base interface." */
    '\x03','\xa3','i','n','s','t','a','n','c','e',' ','h','a','v','e',' ','n','o',' ','b','a','s','e',' ','i','n','t','e','r','f','a','c','e','.',
/* 0x0a43e = "The compression format version is unsupported." */
    '\x03','c','o','m','p','r','e','s','s','i','o','n',' ','f','o','r','m','a','t',' ','\xcf','\x0b','u','n','s','u','p','p','o','r','t','e','d','.',
/* 0x0a460 = "Internal ISO maker error: Rock ridge read problem." */
    '\x07','\xc1',' ','m','a','k','e','r',' ','\xd8','R','o','c','k',' ','r','i','d','g','e',' ','r','e','a','d',' ','p','r','o','b','l','e','m','.',
/* 0x0a482 = "The mode field should not include the type." */
    '\x03','m','o','d','e',' ','f','i','e','l','d',' ','s','h','o','u','l','d',' ','\x08','i','n','c','l','u','d','e',' ','\x02','t','y','p','e','.',
/* 0x0a4a4 = "A driver may only register one VTG object per session." */
    'A',' ','\xc5','m','a','y',' ','o','n','l','y',' ','\xeb','o','n','e',' ','V','T','G',' ','\xa8','p','e','r',' ','s','e','s','s','i','o','n','.',
/* 0x0a4c6 = "NtSetInformationObject/NoInherit failed." */
    'N','t','S','e','t','I','n','f','o','r','m','a','t','i','o','n','O','b','j','e','c','t','/','N','o','I','n','h','e','r','i','t',' ','\x7b',
/* 0x0a4e8 = "VERR_REST_RESPONSE_REPEAT_HEADER_FIELD" */
    '\x01','R','E','S','T','_','R','E','S','P','O','N','S','E','_','R','E','P','E','A','T','_','H','E','A','D','E','R','_','F','I','E','L','D',
/* 0x0a50a = "The size of the shared module was out of range." */
    '\x03','s','i','z','e',' ','\x15','\x02','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','\x11','o','u','t',' ','\x15','r','a','n','g','e','.',
/* 0x0a52c = "The request could not be canceled because it already completed." */
    '\x03','\xaa','c','o','u','l','d',' ','\x08','\xa7','c','a','n','c','e','l','e','d',' ','\x40','i','t',' ','\x7f','c','o','m','p','l','e','t','e','d','.',
/* 0x0a54e = "VERR_CPUM_INCOMPATIBLE_XSAVE_COMP_MASK" */
    '\x01','C','P','U','M','_','I','N','C','O','M','P','A','T','I','B','L','E','_','X','S','A','V','E','_','C','O','M','P','_','M','A','S','K',
/* 0x0a570 = "VERR_ASN1_CURSOR_ILLEGAL_INDEFINITE_LENGTH" */
    '\x01','\xa2','C','U','R','S','O','R','_','I','L','L','E','G','A','L','_','I','N','D','E','F','I','N','I','T','E','_','L','E','N','G','T','H',
/* 0x0a592 = "Pending stream disable operation in progress." */
    'P','e','n','d','i','n','g',' ','s','t','r','e','a','m',' ','d','i','s','a','b','l','e',' ','\x96','\x0f','p','r','o','g','r','e','s','s','.',
/* 0x0a5b4 = "The discard operation is not supported for this image." */
    '\x03','d','i','s','c','a','r','d',' ','\x96','\x0b','\x08','s','u','p','p','o','r','t','e','d',' ','\x10','t','h','i','s',' ','i','m','a','g','e','.',
/* 0x0a5d6 = "Algorithm parameters does not match the key." */
    'A','l','g','o','r','i','t','h','m',' ','p','a','r','a','m','e','t','e','r','s',' ','\xb2','\x08','m','a','t','c','h',' ','\x02','k','e','y','.',
/* 0x0a5f8 = "Host is about to go into suspend mode." */
    'H','o','s','t',' ','\x0b','a','b','o','u','t',' ','\x0a','g','o',' ','i','n','t','o',' ','s','u','s','p','e','n','d',' ','m','o','d','e','.',
/* 0x0a61a = "Unable to start VM execution due to an invalid guest state." */
    '\xe0','\x0a','s','t','a','r','t',' ','\xcd',' ','e','x','e','c','u','t','i','o','n',' ','d','u','e',' ','\x0a','\x87','\x8f','\xbb','s','t','a','t','e','.',
/* 0x0a63c = "Precodition no 1 in hmR0VMXStartVm failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','n','o',' ','1',' ','\x0f','h','m','R','0','V','M','X','S','t','a','r','t','V','m',' ','\x7b',
/* 0x0a65e = "The specified segment:offset address was invalid." */
    '\x03','\x18','s','e','g','m','e','n','t',':','o','f','f','s','e','t',' ','a','d','d','r','e','s','s',' ','\x11','i','n','v','a','l','i','d','.',
/* 0x0a680 = "Precodition no 3 in hmR0VMXStartVm failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','n','o',' ','3',' ','\x0f','h','m','R','0','V','M','X','S','t','a','r','t','V','m',' ','\x7b',
/* 0x0a6a2 = "NEM init failed because of missing kernel API (#5)." */
    '\xee',' ','i','n','i','t',' ','\x99','\x40','\x15','m','i','s','s','i','n','g',' ','k','e','r','n','e','l',' ','A','P','I',' ','(','#','5',')','.',
/* 0x0a6c4 = "The image is the correct format but is corrupted." */
    '\x03','\x26','\x0b','\x02','c','o','r','r','e','c','t',' ','f','o','r','m','a','t',' ','b','u','t',' ','\x0b','c','o','r','r','u','p','t','e','d','.',
/* 0x0a6e6 = "Internal error, VRDP packet is in wrong operation mode." */
    '\x07','e','r','r','o','r',',',' ','V','R','D','P',' ','p','a','c','k','e','t',' ','\x0b','\x0f','w','r','o','n','g',' ','\x96','m','o','d','e','.',
/* 0x0a708 = "VERR_X509_CERTIFICATE_VERIFICATION_FAILURE" */
    '\x01','\xb7','C','E','R','T','I','F','I','C','A','T','E','_','V','E','R','I','F','I','C','A','T','I','O','N','_','F','A','I','L','U','R','E',
/* 0x0a72a = "VERR_CR_PKIX_SIGNATURE_TAKES_NO_PARAMETERS" */
    '\x01','\x24','P','K','I','X','_','S','I','G','N','A','T','U','R','E','_','T','A','K','E','S','_','\x60','P','A','R','A','M','E','T','E','R','S',
/* 0x0a74c = "The file contained a data unit which no-one wants." */
    '\x03','\x1f','c','o','n','t','a','i','n','e','d',' ','a',' ','\x9d','u','n','i','t',' ','\xed','n','o','-','o','n','e',' ','w','a','n','t','s','.',
/* 0x0a76e = "Internal ISO maker error: Finalization problem #1." */
    '\x07','\xc1',' ','m','a','k','e','r',' ','\xd8','F','i','n','a','l','i','z','a','t','i','o','n',' ','p','r','o','b','l','e','m',' ','#','1','.',
/* 0x0a790 = "Import ISO contains a root directory with an out of bounds data extent." */
    '\xc3','\xc1',' ','\x8a','a',' ','r','o','o','t',' ','\x25','\x80','\x87','o','u','t',' ','\x15','b','o','u','n','d','s',' ','\x9d','e','x','t','e','n','t','.',
/* 0x0a7b2 = "The length of the symbol name is out of range." */
    '\x03','l','e','n','g','t','h',' ','\x15','\x02','s','y','m','b','o','l',' ','n','a','m','e',' ','\x0b','o','u','t',' ','\x15','r','a','n','g','e','.',
/* 0x0a7d4 = "VRDP thread has started OK and will run." */
    'V','R','D','P',' ','t','h','r','e','a','d',' ','\x5e','s','t','a','r','t','e','d',' ','O','K',' ','\x9a','w','i','l','l',' ','r','u','n','.',
/* 0x0a7f6 = "The request has been freed, don\'t read the status now." */
    '\x03','\xaa','\x5e','\xcb','f','r','e','e','d',',',' ','d','o','n','\'','t',' ','r','e','a','d',' ','\x02','s','t','a','t','u','s',' ','n','o','w','.',
/* 0x0a818 = "VERR_FDT_DTB_STRINGS_BLOCK_NOT_TERMINATED" */
    '\x01','F','D','T','_','D','T','B','_','S','T','R','I','N','G','S','_','B','L','O','C','K','_','\x06','T','E','R','M','I','N','A','T','E','D',
/* 0x0a83a = "Precodition no 2 in hmR0VMXStartVm failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','n','o',' ','2',' ','\x0f','h','m','R','0','V','M','X','S','t','a','r','t','V','m',' ','\x7b',
/* 0x0a85c = "NEM init failed because of missing kernel API (#1)." */
    '\xee',' ','i','n','i','t',' ','\x99','\x40','\x15','m','i','s','s','i','n','g',' ','k','e','r','n','e','l',' ','A','P','I',' ','(','#','1',')','.',
/* 0x0a87e = "No space for rock ridge \'CE\' entry in directory record." */
    '\xdf','s','p','a','c','e',' ','\x10','r','o','c','k',' ','r','i','d','g','e',' ','\'','C','E','\'',' ','\xc8','\x0f','\x25','r','e','c','o','r','d','.',
/* 0x0a8a0 = "A path does not start with a root specification." */
    'A',' ','\xd0','\xb2','\x08','s','t','a','r','t',' ','\x80','a',' ','r','o','o','t',' ','s','p','e','c','i','f','i','c','a','t','i','o','n','.',
/* 0x0a8c1 = "Return to ring-3 to write the MSR there." */
    'R','e','t','u','r','n',' ','\x0a','r','i','n','g','-','3',' ','\x0a','w','r','i','t','e',' ','\x02','M','S','R',' ','t','h','e','r','e','.',
/* 0x0a8e2 = "VERR_DBGF_BP_OWNER_CALLBACK_WRONG_STATUS" */
    '\x01','\xb9','_','B','P','_','O','W','N','E','R','_','C','A','L','L','B','A','C','K','_','W','R','O','N','G','_','S','T','A','T','U','S',
/* 0x0a903 = "The process specified to a non-block wait had not exited." */
    '\x03','\x92','\x18','\x0a','a',' ','n','o','n','-','b','l','o','c','k',' ','w','a','i','t',' ','h','a','d',' ','\x08','e','x','i','t','e','d','.',
/* 0x0a924 = "A required query parameter was not set." */
    'A',' ','r','e','q','u','i','r','e','d',' ','q','u','e','r','y',' ','p','a','r','a','m','e','t','e','r',' ','\x11','\x08','s','e','t','.',
/* 0x0a945 = "Security (en/decryption) engine error." */
    'S','e','c','u','r','i','t','y',' ','(','e','n','/','d','e','c','r','y','p','t','i','o','n',')',' ','e','n','g','i','n','e',' ','\x85',
/* 0x0a966 = "Import ISO contains a root directory with a bad record length." */
    '\xc3','\xc1',' ','\x8a','a',' ','r','o','o','t',' ','\x25','\x80','a',' ','b','a','d',' ','r','e','c','o','r','d',' ','l','e','n','g','t','h','.',
/* 0x0a987 = "Reason for leaving RC: Interrupt pending (guest)." */
    '\x93','\x10','\x81','R','C',':',' ','I','n','t','e','r','r','u','p','t',' ','p','e','n','d','i','n','g',' ','(','g','u','e','s','t',')','.',
/* 0x0a9a8 = "The logical volume descriptor has a too big partition map." */
    '\x03','l','o','g','i','c','a','l',' ','\xd2','\xe3','\x5e','a',' ','\x9e','b','i','g',' ','p','a','r','t','i','t','i','o','n',' ','m','a','p','.',
/* 0x0a9c9 = "Can\'t free the memory because it\'s used in mapping." */
    'C','a','n','\'','t',' ','f','r','e','e',' ','\x02','\x86','\x40','i','t','\'','s',' ','u','s','e','d',' ','\x0f','m','a','p','p','i','n','g','.',
/* 0x0a9ea = "VERR_REST_RESPONSE_EMBEDDED_ZERO_CHAR" */
    '\x01','R','E','S','T','_','R','E','S','P','O','N','S','E','_','E','M','B','E','D','D','E','D','_','Z','E','R','O','_','C','H','A','R',
/* 0x0aa0b = "Can\'t send after socket shutdown." */
    'C','a','n','\'','t',' ','s','e','n','d',' ','a','f','t','e','r',' ','s','o','c','k','e','t',' ','s','h','u','t','d','o','w','n','.',
/* 0x0aa2c = "VERR_PDM_CANNOT_TRANSFORM_REMOVED_DRIVER" */
    '\x01','\x7d','C','A','N','N','O','T','_','T','R','A','N','S','F','O','R','M','_','R','E','M','O','V','E','D','_','D','R','I','V','E','R',
/* 0x0aa4d = "Reason for leaving RC: #PF for monitored patch page." */
    '\x93','\x10','\x81','R','C',':',' ','#','P','F',' ','\x10','m','o','n','i','t','o','r','e','d',' ','p','a','t','c','h',' ','p','a','g','e','.',
/* 0x0aa6e = "Reason for leaving RC: #GP with EIP pointing to patch code." */
    '\x93','\x10','\x81','R','C',':',' ','#','G','P',' ','\x80','E','I','P',' ','p','o','i','n','t','i','n','g',' ','\x0a','p','a','t','c','h',' ','\x84',
/* 0x0aa8f = "VFS chain element only provides directory (dir) objects." */
    '\x8d',' ','\xa1','\x5c','o','n','l','y',' ','p','r','o','v','i','d','e','s',' ','\x25','(','d','i','r',')',' ','o','b','j','e','c','t','s','.',
/* 0x0aab0 = "Error reading a certificate in PEM format from BIO." */
    '\xc0','r','e','a','d','i','n','g',' ','a',' ','\xa0','\x0f','P','E','M',' ','f','o','r','m','a','t',' ','f','r','o','m',' ','B','I','O','.',
/* 0x0aad1 = "Saving the VM state is temporarily not allowed." */
    'S','a','v','i','n','g',' ','\x02','\xcd',' ','\xca','\x0b','t','e','m','p','o','r','a','r','i','l','y',' ','\x08','a','l','l','o','w','e','d','.',
/* 0x0aaf2 = "Process Verification Failure: Unexpected section protection flag combination." */
    '\x1e','\x0d','\x12','\x94','\xdb','p','r','o','t','e','c','t','i','o','n',' ','f','l','a','g',' ','c','o','m','b','i','n','a','t','i','o','n','.',
/* 0x0ab13 = "The networking interface to filter was not found." */
    '\x03','n','e','t','w','o','r','k','i','n','g',' ','i','n','t','e','r','f','a','c','e',' ','\x0a','f','i','l','t','e','r',' ','\x11','\x08','\x89',
/* 0x0ab34 = "Error extracting RSA from the public key." */
    '\xc0','e','x','t','r','a','c','t','i','n','g',' ','R','S','A',' ','f','r','o','m',' ','\x02','p','u','b','l','i','c',' ','k','e','y','.',
/* 0x0ab55 = "There is not enough room to store the data." */
    'T','h','e','r','e',' ','\x0b','\x08','e','n','o','u','g','h',' ','r','o','o','m',' ','\x0a','s','t','o','r','e',' ','\x02','d','a','t','a','.',
/* 0x0ab76 = "The ELF loader doesn't handle foreign endianness." */
    '\x03','E','L','F',' ','\xd9','\xc7','h','a','n','d','l','e',' ','f','o','r','e','i','g','n',' ','e','n','d','i','a','n','n','e','s','s','.',
/* 0x0ab97 = "Attempted to enabled a breakpoint which was already enabled." */
    'A','t','t','e','m','p','t','e','d',' ','\x0a','e','n','a','b','l','e','d',' ','a',' ','\xbf','\xed','\x11','\x7f','e','n','a','b','l','e','d','.',
/* 0x0abb8 = "The file list doesn't match to the content of the manifest file." */
    '\x03','\x1f','l','i','s','t',' ','\xc7','m','a','t','c','h',' ','\x0a','\x02','\xf0','\x15','\x02','m','a','n','i','f','e','s','t',' ','f','i','l','e','.',
/* 0x0abd9 = "Unknown escape sequence encountered in TeletexString." */
    '\xef','e','s','c','a','p','e',' ','s','e','q','u','e','n','c','e',' ','\xaf','\x0f','T','e','l','e','t','e','x','S','t','r','i','n','g','.',
/* 0x0abfa = "The tracer has already been opened in this sesssion." */
    '\x03','t','r','a','c','e','r',' ','\x5e','\x7f','\xcb','o','p','e','n','e','d',' ','\x0f','t','h','i','s',' ','s','e','s','s','s','i','o','n','.',
/* 0x0ac1b = "Internal ISO maker error: Descriptor miscounting." */
    '\x07','\xc1',' ','m','a','k','e','r',' ','\xd8','D','e','s','c','r','i','p','t','o','r',' ','m','i','s','c','o','u','n','t','i','n','g','.',
/* 0x0ac3c = "VERR_ISOMK_IMPORT_BOOT_CAT_BAD_VALIDATION_HEADER_ID" */
    '\x01','\x22','\x83','B','O','O','T','_','C','A','T','_','\x1d','V','A','L','I','D','A','T','I','O','N','_','H','E','A','D','E','R','_','I','D',
/* 0x0ac5d = "Page not marked for dirty bit tracking." */
    'P','a','g','e',' ','\x08','m','a','r','k','e','d',' ','\x10','d','i','r','t','y',' ','b','i','t',' ','t','r','a','c','k','i','n','g','.',
/* 0x0ac7e = "Emulate split-lock access on SMP." */
    'E','m','u','l','a','t','e',' ','s','p','l','i','t','-','l','o','c','k',' ','a','c','c','e','s','s',' ','o','n',' ','S','M','P','.',
/* 0x0ac9f = "Reason for leaving RC: #PF with EIP pointing to patch code." */
    '\x93','\x10','\x81','R','C',':',' ','#','P','F',' ','\x80','E','I','P',' ','p','o','i','n','t','i','n','g',' ','\x0a','p','a','t','c','h',' ','\x84',
/* 0x0acc0 = "The compression method is unsupported." */
    '\x03','c','o','m','p','r','e','s','s','i','o','n',' ','m','e','t','h','o','d',' ','\x0b','u','n','s','u','p','p','o','r','t','e','d','.',
/* 0x0ace1 = "An operation caused a nested-guest SVM #VMEXIT." */
    'A','n',' ','\x96','c','a','u','s','e','d',' ','a',' ','n','e','s','t','e','d','-','\xbb','S','V','M',' ','#','V','M','E','X','I','T','.',
/* 0x0ad02 = "Entry in a boot catalog section is another section." */
    'E','n','t','r','y',' ','\x0f','a',' ','b','o','o','t',' ','\xe7','\xdb','\x0b','a','n','o','t','h','e','r',' ','s','e','c','t','i','o','n','.',
/* 0x0ad23 = "Process Verification Failure: Error determining the full path of System32." */
    '\x1e','\x0d','\x12','\xc0','d','e','t','e','r','m','i','n','i','n','g',' ','\x02','f','u','l','l',' ','\xd0','\x15','S','y','s','t','e','m','3','2','.',
/* 0x0ad44 = "Software caused connection abort." */
    'S','o','f','t','w','a','r','e',' ','c','a','u','s','e','d',' ','c','o','n','n','e','c','t','i','o','n',' ','a','b','o','r','t','.',
/* 0x0ad65 = "OpenSSL failed to decode the key parameters." */
    'O','p','e','n','S','S','L',' ','\x99','\x0a','d','e','c','o','d','e',' ','\x02','k','e','y',' ','p','a','r','a','m','e','t','e','r','s','.',
/* 0x0ad86 = "Malformed code signing structure." */
    'M','a','l','f','o','r','m','e','d',' ','c','o','d','e',' ','s','i','g','n','i','n','g',' ','s','t','r','u','c','t','u','r','e','.',
/* 0x0ada7 = "Couldn\'t connect to the server (proxy?" */
    'C','o','u','l','d','n','\'','t',' ','c','o','n','n','e','c','t',' ','\x0a','\x02','s','e','r','v','e','r',' ','(','p','r','o','x','y','?',
/* 0x0adc8 = "Invalid or unsupported logical block size." */
    '\x0c','\xa9','u','n','s','u','p','p','o','r','t','e','d',' ','l','o','g','i','c','a','l',' ','b','l','o','c','k',' ','s','i','z','e','.',
/* 0x0ade9 = "Unsupported escape sequence encountered in TeletexString." */
    '\x98','e','s','c','a','p','e',' ','s','e','q','u','e','n','c','e',' ','\xaf','\x0f','T','e','l','e','t','e','x','S','t','r','i','n','g','.',
/* 0x0ae0a = "Precodition no 3 in hmR0SvmVmRun failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','n','o',' ','3',' ','\x0f','h','m','R','0','S','v','m','V','m','R','u','n',' ','\x7b',
/* 0x0ae2a = "VERR_SSM_FIELD_LOAD_ONLY_TRANSFORMATION" */
    '\x01','\xb0','F','I','E','L','D','_','L','O','A','D','_','O','N','L','Y','_','T','R','A','N','S','F','O','R','M','A','T','I','O','N',
/* 0x0ae4a = "The volume map doesn't contain any valid volume." */
    '\x03','\xd2','m','a','p',' ','\xc7','c','o','n','t','a','i','n',' ','a','n','y',' ','v','a','l','i','d',' ','v','o','l','u','m','e','.',
/* 0x0ae6a = "VERR_ISOMK_IMPORT_BOOT_CAT_BAD_VALIDATION_CHECKSUM" */
    '\x01','\x22','\x83','B','O','O','T','_','C','A','T','_','\x1d','V','A','L','I','D','A','T','I','O','N','_','C','H','E','C','K','S','U','M',
/* 0x0ae8a = "Recording limit (time, size, ..." */
    'R','e','c','o','r','d','i','n','g',' ','l','i','m','i','t',' ','(','t','i','m','e',',',' ','s','i','z','e',',',' ','.','.','.',
/* 0x0aeaa = "The NotBefore and NotAfter values of an X." */
    '\x03','N','o','t','B','e','f','o','r','e',' ','\x9a','N','o','t','A','f','t','e','r',' ','v','a','l','u','e','s',' ','\x15','\x87','X','.',
/* 0x0aeca = "There is no cache attached to the disk." */
    'T','h','e','r','e',' ','\x0b','n','o',' ','c','a','c','h','e',' ','a','t','t','a','c','h','e','d',' ','\x0a','\x02','d','i','s','k','.',
/* 0x0aeea = "Failed to open underlying link instance." */
    '\x8b','\x0a','o','p','e','n',' ','u','n','d','e','r','l','y','i','n','g',' ','l','i','n','k',' ','i','n','s','t','a','n','c','e','.',
/* 0x0af0a = "Stack overflow during AVL tree operation." */
    'S','t','a','c','k',' ','o','v','e','r','f','l','o','w',' ','d','u','r','i','n','g',' ','A','V','L',' ','t','r','e','e',' ','\xea',
/* 0x0af2a = "Termination record CRC mismatch." */
    'T','e','r','m','i','n','a','t','i','o','n',' ','r','e','c','o','r','d',' ','C','R','C',' ','m','i','s','m','a','t','c','h','.',
/* 0x0af4a = "VERR_CR_X509_CPV_UNEXP_GENERAL_SUBTREE_MIN" */
    '\x01','\x24','\xb7','C','P','V','_','U','N','E','X','P','_','G','E','N','E','R','A','L','_','S','U','B','T','R','E','E','_','M','I','N',
/* 0x0af6a = "A non-directory operation was attempted on a directory object." */
    'A',' ','n','o','n','-','\x25','\x96','\x11','a','t','t','e','m','p','t','e','d',' ','o','n',' ','a',' ','\x25','o','b','j','e','c','t','.',
/* 0x0af8a = "HMR0Leave was called on the wrong CPU." */
    'H','M','R','0','L','e','a','v','e',' ','\x11','c','a','l','l','e','d',' ','o','n',' ','\x02','w','r','o','n','g',' ','C','P','U','.',
/* 0x0afaa = "A file operation was attempted on a non-file object." */
    'A',' ','\x1f','\x96','\x11','a','t','t','e','m','p','t','e','d',' ','o','n',' ','a',' ','n','o','n','-','\x1f','o','b','j','e','c','t','.',
/* 0x0afca = "Reason for leaving RC: A Ring switch was attempted." */
    '\x93','\x10','\x81','R','C',':',' ','A',' ','R','i','n','g',' ','s','w','i','t','c','h',' ','\x11','a','t','t','e','m','p','t','e','d','.',
/* 0x0afea = "The requested feature is not supported in raw-mode." */
    '\x03','\xde','f','e','a','t','u','r','e',' ','\x0b','\x08','s','u','p','p','o','r','t','e','d',' ','\x0f','r','a','w','-','m','o','d','e','.',
/* 0x0b00a = "Syntax error - too many arguments for static storage." */
    '\xfa','\x09','-',' ','\x9e','\xb4','a','r','g','u','m','e','n','t','s',' ','\x10','s','t','a','t','i','c',' ','s','t','o','r','a','g','e','.',
/* 0x0b02a = "CAcert is missing or has the wrong format." */
    'C','A','c','e','r','t',' ','\x0b','m','i','s','s','i','n','g',' ','\xa9','\x5e','\x02','w','r','o','n','g',' ','f','o','r','m','a','t','.',
/* 0x0b04a = "Not permitted to open the USB device." */
    'N','o','t',' ','p','e','r','m','i','t','t','e','d',' ','\x0a','o','p','e','n',' ','\x02','U','S','B',' ','d','e','v','i','c','e','.',
/* 0x0b06a = "The handle ID is already present in the poll set." */
    '\x03','h','a','n','d','l','e',' ','I','D',' ','\x0b','\x7f','p','r','e','s','e','n','t',' ','\x0f','\x02','p','o','l','l',' ','s','e','t','.',
/* 0x0b08a = "The checksum of a tar header record doesn't match." */
    '\x03','c','h','e','c','k','s','u','m',' ','\x15','a',' ','t','a','r',' ','\xb3','r','e','c','o','r','d',' ','\xc7','m','a','t','c','h','.',
/* 0x0b0aa = "The DBGF has no more free breakpoint owner handles." */
    '\x03','\xb9',' ','\x5e','n','o',' ','m','o','r','e',' ','f','r','e','e',' ','\xbf','o','w','n','e','r',' ','h','a','n','d','l','e','s','.',
/* 0x0b0ca = "A non-file operation was attempted on a file object." */
    'A',' ','n','o','n','-','\x1f','\x96','\x11','a','t','t','e','m','p','t','e','d',' ','o','n',' ','a',' ','\x1f','o','b','j','e','c','t','.',
/* 0x0b0ea = "VERR_ISOFS_BOGUS_ALLOCATION_EXTENT_LENGTH" */
    '\x01','\x97','B','O','G','U','S','_','A','L','L','O','C','A','T','I','O','N','_','E','X','T','E','N','T','_','L','E','N','G','T','H',
/* 0x0b10a = "Send pagefault timeout in receive." */
    'S','e','n','d',' ','p','a','g','e','f','a','u','l','t',' ','t','i','m','e','o','u','t',' ','\x0f','r','e','c','e','i','v','e','.',
/* 0x0b12a = "Bad UTF-16 surrogate pair sequence." */
    '\x9f','U','T','F','-','1','6',' ','s','u','r','r','o','g','a','t','e',' ','p','a','i','r',' ','s','e','q','u','e','n','c','e','.',
/* 0x0b14a = "Missing offset element in table of content sub-element." */
    'M','i','s','s','i','n','g',' ','o','f','f','s','e','t',' ','\x5c','\x0f','\xb1','\x15','\xf0','s','u','b','-','e','l','e','m','e','n','t','.',
/* 0x0b16a = "PDMVMMDevHeapR3ToGCPhys failure." */
    'P','D','M','V','M','M','D','e','v','H','e','a','p','R','3','T','o','G','C','P','h','y','s',' ','f','a','i','l','u','r','e','.',
/* 0x0b18a = "VERR_RT_REQUEST_STATUS_STILL_PENDING" */
    '\x01','R','T','_','R','E','Q','U','E','S','T','_','S','T','A','T','U','S','_','S','T','I','L','L','_','P','E','N','D','I','N','G',
/* 0x0b1aa = "Signed data verification failed due to key usage issues." */
    'S','i','g','n','e','d',' ','\x9d','\xf8','\x99','d','u','e',' ','\x0a','k','e','y',' ','u','s','a','g','e',' ','i','s','s','u','e','s','.',
/* 0x0b1ca = "Data connection limit has been reached." */
    'D','a','t','a',' ','c','o','n','n','e','c','t','i','o','n',' ','l','i','m','i','t',' ','\x5e','\xcb','r','e','a','c','h','e','d','.',
/* 0x0b1ea = "VERR_CR_X509_CPV_UNEXP_GENERAL_SUBTREE_MAX" */
    '\x01','\x24','\xb7','C','P','V','_','U','N','E','X','P','_','G','E','N','E','R','A','L','_','S','U','B','T','R','E','E','_','M','A','X',
/* 0x0b20a = "VERR_CR_PKCS7_SIGNER_INFO_NO_ISSUER_SERIAL_NO" */
    '\x01','\x24','\xe5','S','I','G','N','E','R','_','I','N','F','O','_','\x60','I','S','S','U','E','R','_','S','E','R','I','A','L','_','N','O',
/* 0x0b22a = "Unresolved (unknown) semaphore error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','s','e','m','a','p','h','o','r','e',' ','\x85',
/* 0x0b24a = "VERR_CR_SPC_PEIMAGE_MULTIPLE_HASH_TABS" */
    '\x01','\x24','S','P','C','_','P','E','I','M','A','G','E','_','M','U','L','T','I','P','L','E','_','H','A','S','H','_','T','A','B','S',
/* 0x0b26a = "Warning X509 certificate isn\'t self signed." */
    'W','a','r','n','i','n','g',' ','X','5','0','9',' ','\xa0','i','s','n','\'','t',' ','s','e','l','f',' ','s','i','g','n','e','d','.',
/* 0x0b28a = "Process Verification Failure: Error query virtual memory mapping name." */
    '\x1e','\x0d','\x12','\xc0','q','u','e','r','y',' ','v','i','r','t','u','a','l',' ','\x86','m','a','p','p','i','n','g',' ','n','a','m','e','.',
/* 0x0b2aa = "VERR_ISOFS_INSUFFICIENT_DATA_FOR_DESC_CRC" */
    '\x01','\x97','I','N','S','U','F','F','I','C','I','E','N','T','_','D','A','T','A','_','F','O','R','_','D','E','S','C','_','C','R','C',
/* 0x0b2ca = "The DTB structs block contains an invalid node name." */
    '\x03','D','T','B',' ','s','t','r','u','c','t','s',' ','b','l','o','c','k',' ','\x8a','\x87','\x8f','n','o','d','e',' ','n','a','m','e','.',
/* 0x0b2ea = "GVMM ran into some broken IPRT code." */
    'G','V','M','M',' ','r','a','n',' ','i','n','t','o',' ','s','o','m','e',' ','b','r','o','k','e','n',' ','I','P','R','T',' ','\x84',
/* 0x0b30a = "A directory operation was attempted on a non-directory object." */
    'A',' ','\x25','\x96','\x11','a','t','t','e','m','p','t','e','d',' ','o','n',' ','a',' ','n','o','n','-','\x25','o','b','j','e','c','t','.',
/* 0x0b32a = "Encountered an unsupported GNU Tar extension." */
    '\xa5','\x87','u','n','s','u','p','p','o','r','t','e','d',' ','G','N','U',' ','T','a','r',' ','e','x','t','e','n','s','i','o','n','.',
/* 0x0b34a = "Import ISO contains a zero sized root directory." */
    '\xc3','\xc1',' ','\x8a','a',' ','z','e','r','o',' ','s','i','z','e','d',' ','r','o','o','t',' ','d','i','r','e','c','t','o','r','y','.',
/* 0x0b36a = "APIC register/MSR write invalid." */
    'A','P','I','C',' ','r','e','g','i','s','t','e','r','/','M','S','R',' ','w','r','i','t','e',' ','i','n','v','a','l','i','d','.',
/* 0x0b38a = "Process Verification Failure: Error querying thread information." */
    '\x1e','\x0d','\x12','\xc0','q','u','e','r','y','i','n','g',' ','t','h','r','e','a','d',' ','i','n','f','o','r','m','a','t','i','o','n','.',
/* 0x0b3aa = "An unknown config value was encountered." */
    'A','n',' ','u','n','k','n','o','w','n',' ','c','o','n','f','i','g',' ','\xf5','\x11','e','n','c','o','u','n','t','e','r','e','d','.',
/* 0x0b3ca = "The remote host couldn\'t be resolved." */
    '\x03','r','e','m','o','t','e',' ','h','o','s','t',' ','c','o','u','l','d','n','\'','t',' ','\xa7','r','e','s','o','l','v','e','d','.',
/* 0x0b3ea = "Incompatible CPUM configuration." */
    'I','n','c','o','m','p','a','t','i','b','l','e',' ','C','P','U','M',' ','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x0b40a = "VERR_HTTP_CACERT_CANNOT_AUTHENTICATE" */
    '\x01','H','T','T','P','_','C','A','C','E','R','T','_','C','A','N','N','O','T','_','A','U','T','H','E','N','T','I','C','A','T','E',
/* 0x0b42a = "Return to ring-3 to read the MSR there." */
    'R','e','t','u','r','n',' ','\x0a','r','i','n','g','-','3',' ','\x0a','r','e','a','d',' ','\x02','M','S','R',' ','t','h','e','r','e','.',
/* 0x0b44a = "The disk has a cache attached already." */
    '\x03','d','i','s','k',' ','\x5e','a',' ','c','a','c','h','e',' ','a','t','t','a','c','h','e','d',' ','a','l','r','e','a','d','y','.',
/* 0x0b46a = "Invalid session ID in managed object reference." */
    '\x0c','s','e','s','s','i','o','n',' ','I','D',' ','\x0f','m','a','n','a','g','e','d',' ','\xa8','r','e','f','e','r','e','n','c','e','.',
/* 0x0b48a = "The file is not a valid /proc/kallsyms file." */
    '\x03','\x1f','\x0b','\x08','a',' ','v','a','l','i','d',' ','/','p','r','o','c','/','k','a','l','l','s','y','m','s',' ','f','i','l','e','.',
/* 0x0b4aa = "OpenSSL failed to initialize the digest algorithm context." */
    'O','p','e','n','S','S','L',' ','\x99','\x0a','i','n','i','t','i','a','l','i','z','e',' ','\x02','\xd7','\xd4','c','o','n','t','e','x','t','.',
/* 0x0b4ca = "FAM failed to add a directory to the list to be monitored." */
    'F','A','M',' ','\x99','\x0a','a','d','d',' ','a',' ','\x25','\x0a','\x02','l','i','s','t',' ','\x0a','\xa7','m','o','n','i','t','o','r','e','d','.',
/* 0x0b4ea = "Image Verification Failure: No Authenticode Signature." */
    'I','m','a','g','e',' ','\x0d','\x12','\xdf','A','u','t','h','e','n','t','i','c','o','d','e',' ','S','i','g','n','a','t','u','r','e','.',
/* 0x0b50a = "Certificate extensions requires certificate version 3 or later." */
    '\xba','e','x','t','e','n','s','i','o','n','s',' ','r','e','q','u','i','r','e','s',' ','\xa0','\xcf','3',' ','\xa9','l','a','t','e','r','.',
/* 0x0b52a = "validation of the loader section (in the LX header) failed." */
    'v','a','l','i','d','a','t','i','o','n',' ','\x15','\x02','\xd9','\xdb','(','i','n',' ','\x02','L','X',' ','h','e','a','d','e','r',')',' ','\x7b',
/* 0x0b54a = "The network is busy or is out of resources." */
    '\x03','n','e','t','w','o','r','k',' ','\x0b','b','u','s','y',' ','\xa9','\x0b','o','u','t',' ','\x15','r','e','s','o','u','r','c','e','s','.',
/* 0x0b56a = "Recompiler: Too deeply nested conditionals." */
    '\x13','T','o','o',' ','d','e','e','p','l','y',' ','n','e','s','t','e','d',' ','c','o','n','d','i','t','i','o','n','a','l','s','.',
/* 0x0b58a = "Unsupported domain ID in logical volume descriptor." */
    '\x98','d','o','m','a','i','n',' ','I','D',' ','\x0f','l','o','g','i','c','a','l',' ','\xd2','d','e','s','c','r','i','p','t','o','r','.',
/* 0x0b5aa = "Precodition no 2 in hmR0SvmVmRun failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','n','o',' ','2',' ','\x0f','h','m','R','0','S','v','m','V','m','R','u','n',' ','\x7b',
/* 0x0b5ca = "VERR_GMM_SHARED_MODULE_ADDRESS_CLASH" */
    '\x01','G','M','M','_','S','H','A','R','E','D','_','M','O','D','U','L','E','_','A','D','D','R','E','S','S','_','C','L','A','S','H',
/* 0x0b5ea = "No unwind information for the specified location." */
    '\xdf','u','n','w','i','n','d',' ','i','n','f','o','r','m','a','t','i','o','n',' ','\x10','\x02','\x18','l','o','c','a','t','i','o','n','.',
/* 0x0b60a = "Couldn\'t find the USB Proxy device." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','\x02','U','S','B',' ','P','r','o','x','y',' ','d','e','v','i','c','e','.',
/* 0x0b62a = "Precodition no 0 in hmR0SvmVmRun failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','n','o',' ','0',' ','\x0f','h','m','R','0','S','v','m','V','m','R','u','n',' ','\x7b',
/* 0x0b64a = "VRDP script has completed its task." */
    'V','R','D','P',' ','s','c','r','i','p','t',' ','\x5e','c','o','m','p','l','e','t','e','d',' ','i','t','s',' ','t','a','s','k','.',
/* 0x0b66a = "VERR_PATH_MATCH_FEATURE_NOT_IMPLEMENTED" */
    '\x01','P','A','T','H','_','M','A','T','C','H','_','F','E','A','T','U','R','E','_','\x06','I','M','P','L','E','M','E','N','T','E','D',
/* 0x0b68a = "Reason for leaving RC: Partly handled GDT write." */
    '\x93','\x10','\x81','R','C',':',' ','P','a','r','t','l','y',' ','h','a','n','d','l','e','d',' ','G','D','T',' ','w','r','i','t','e','.',
/* 0x0b6aa = "Recompiler: Out of memory for the instruction buffer (regular heap)." */
    '\x13','O','u','t',' ','\x15','\x86','\x10','\x02','\xda','b','u','f','f','e','r',' ','(','r','e','g','u','l','a','r',' ','h','e','a','p',')','.',
/* 0x0b6ca = "File set descriptor has a next extent member." */
    'F','i','l','e',' ','s','e','t',' ','\xe3','\x5e','a',' ','n','e','x','t',' ','e','x','t','e','n','t',' ','m','e','m','b','e','r','.',
/* 0x0b6ea = "VERR_GSTCTL_MAX_CID_SESSIONS_REACHED" */
    '\x01','G','S','T','C','T','L','_','M','A','X','_','C','I','D','_','S','E','S','S','I','O','N','S','_','R','E','A','C','H','E','D',
/* 0X0b70a = "Duplicate symbol within the module." */
    'u','p','l','i','c','a','t','e',' ','s','y','m','b','o','l',' ','w','i','t','h','i','n',' ','\x02','m','o','d','u','l','e','.',
/* 0x0b729 = "A non-directory entry has a name ending with a slash." */
    'A',' ','n','o','n','-','\x25','\xc8','\x5e','a',' ','n','a','m','e',' ','e','n','d','i','n','g',' ','\x80','a',' ','s','l','a','s','h','.',
/* 0x0b749 = "Asynchronous I/O is not finished yet." */
    'A','s','y','n','c','h','r','o','n','o','u','s',' ','I','/','O',' ','\x0b','\x08','f','i','n','i','s','h','e','d',' ','y','e','t','.',
/* 0x0b769 = "Device creation failed because the USB device name was not found." */
    'D','e','v','i','c','e',' ','c','r','e','a','t','i','o','n',' ','\x99','\x40','\x02','U','S','B',' ','\xa3','n','a','m','e',' ','\x11','\x08','\x89',
/* 0x0b789 = "The machine uuid field wasn\'t null." */
    '\x03','m','a','c','h','i','n','e',' ','u','u','i','d',' ','f','i','e','l','d',' ','w','a','s','n','\'','t',' ','n','u','l','l','.',
/* 0x0b7a9 = "No 32-bit to 64-bit switcher in place." */
    '\xdf','3','2','-','b','i','t',' ','\x0a','6','4','-','b','i','t',' ','s','w','i','t','c','h','e','r',' ','\x0f','p','l','a','c','e','.',
/* 0x0b7c9 = "VERR_TRACELOG_READER_LOG_UNSUPPORTED" */
    '\x01','T','R','A','C','E','L','O','G','_','R','E','A','D','E','R','_','L','O','G','_','U','N','S','U','P','P','O','R','T','E','D',
/* 0X0b7e9 = "Descriptor tag sector number mismatch." */
    'e','s','c','r','i','p','t','o','r',' ','t','a','g',' ','s','e','c','t','o','r',' ','\xfb','m','i','s','m','a','t','c','h','.',
/* 0x0b808 = "Guest tried to trigger a CPU hang." */
    'G','u','e','s','t',' ','t','r','i','e','d',' ','\x0a','t','r','i','g','g','e','r',' ','a',' ','C','P','U',' ','h','a','n','g','.',
/* 0x0b828 = "The VTG object for the session or image has already been registered." */
    '\x03','V','T','G',' ','\xa8','\x10','\x02','s','e','s','s','i','o','n',' ','\xa9','\x26','\x5e','\x7f','\xcb','r','e','g','i','s','t','e','r','e','d','.',
/* 0x0b848 = "The GIM provider does not support any hypercalls." */
    '\x03','G','I','M',' ','p','r','o','v','i','d','e','r',' ','\xb2','\x08','\xce','a','n','y',' ','h','y','p','e','r','c','a','l','l','s','.',
/* 0x0b868 = "Reason for leaving RC: A triple-fault condition." */
    '\x93','\x10','\x81','R','C',':',' ','A',' ','t','r','i','p','l','e','-','f','a','u','l','t',' ','c','o','n','d','i','t','i','o','n','.',
/* 0x0b888 = "VERR_ISOMK_IMPORT_ROOT_DIR_EXTENT_OUT_OF_BOUNDS" */
    '\x01','\x22','\x83','R','O','O','T','_','D','I','R','_','E','X','T','E','N','T','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x0b8a8 = "Internal ISO maker error: Boot catalog file handle problem." */
    '\x07','\xc1',' ','m','a','k','e','r',' ','\xd8','B','o','o','t',' ','\xe7','\x1f','h','a','n','d','l','e',' ','p','r','o','b','l','e','m','.',
/* 0x0b8c8 = "FAM failed to add a file to the list to be monitored." */
    'F','A','M',' ','\x99','\x0a','a','d','d',' ','a',' ','\x1f','\x0a','\x02','l','i','s','t',' ','\x0a','\xa7','m','o','n','i','t','o','r','e','d','.',
/* 0x0b8e8 = "Internal ISO maker error: Buggy namespace table." */
    '\x07','\xc1',' ','m','a','k','e','r',' ','\xd8','B','u','g','g','y',' ','n','a','m','e','s','p','a','c','e',' ','t','a','b','l','e','.',
/* 0x0b908 = "Precodition no 1 in hmR0SvmVmRun failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','n','o',' ','1',' ','\x0f','h','m','R','0','S','v','m','V','m','R','u','n',' ','\x7b',
/* 0x0b928 = "Missing length element in table of content sub-element." */
    'M','i','s','s','i','n','g',' ','l','e','n','g','t','h',' ','\x5c','\x0f','\xb1','\x15','\xf0','s','u','b','-','e','l','e','m','e','n','t','.',
/* 0x0b948 = "VERR_VMM_CONTEXT_HOOK_STILL_ENABLED" */
    '\x01','V','M','M','_','C','O','N','T','E','X','T','_','H','O','O','K','_','S','T','I','L','L','_','E','N','A','B','L','E','D',
/* 0x0b967 = "The EMT was not blocked at the time of the call." */
    '\x03','E','M','T',' ','\x11','\x08','b','l','o','c','k','e','d',' ','a','t',' ','\x02','t','i','m','e',' ','\x15','\x02','c','a','l','l','.',
/* 0x0b986 = "VERR_ISOMK_IMPORT_DIR_REC_EXTENT_OUT_OF_BOUNDS" */
    '\x01','\x22','\x83','D','I','R','_','R','E','C','_','E','X','T','E','N','T','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x0b9a5 = "VERR_ISOMK_IMPORT_BOOT_CAT_DEF_ENTRY_INVALID_BOOT_IND" */
    '\x01','\x22','\x83','B','O','O','T','_','C','A','T','_','D','E','F','_','E','N','T','R','Y','_','\x05','B','O','O','T','_','I','N','D',
/* 0x0b9c4 = "Invalid instruction length passed to an IEM function." */
    '\x0c','\xda','l','e','n','g','t','h',' ','p','a','s','s','e','d',' ','\x0a','\x87','I','E','M',' ','f','u','n','c','t','i','o','n','.',
/* 0x0b9e3 = "VINF_EM_RAW_EMULATE_INSTR_GDT_FAULT" */
    '\x0e','E','M','_','R','A','W','_','E','M','U','L','A','T','E','_','I','N','S','T','R','_','G','D','T','_','F','A','U','L','T',
/* 0x0ba02 = "NEM failed to create a native VM instance." */
    '\xee',' ','\x99','\x0a','c','r','e','a','t','e',' ','a',' ','n','a','t','i','v','e',' ','\xcd',' ','i','n','s','t','a','n','c','e','.',
/* 0x0ba21 = "NEM can only operate from ring-3." */
    '\xee',' ','c','a','n',' ','o','n','l','y',' ','o','p','e','r','a','t','e',' ','f','r','o','m',' ','r','i','n','g','-','3','.',
/* 0x0ba40 = "The module contains no symbol information." */
    '\x03','m','o','d','u','l','e',' ','\x8a','n','o',' ','s','y','m','b','o','l',' ','i','n','f','o','r','m','a','t','i','o','n','.',
/* 0x0ba5f = "Process Verification Failure: A DLL was found more than once." */
    '\x1e','\x0d','\x12','A',' ','D','L','L',' ','\x11','f','o','u','n','d',' ','m','o','r','e',' ','t','h','a','n',' ','o','n','c','e','.',
/* 0x0ba7e = "Import ISO contains a root directory without the directory flag set." */
    '\xc3','\xc1',' ','\x8a','a',' ','r','o','o','t',' ','\x25','w','i','t','h','o','u','t',' ','\x02','\x25','f','l','a','g',' ','s','e','t','.',
/* 0x0ba9d = "Internal ISO maker error: Namespace problem #1." */
    '\x07','\xc1',' ','m','a','k','e','r',' ','\xd8','N','a','m','e','s','p','a','c','e',' ','p','r','o','b','l','e','m',' ','#','1','.',
/* 0x0babc = "Tried to halt a VM or CPU that was already halted." */
    'T','r','i','e','d',' ','\x0a','h','a','l','t',' ','a',' ','\xcd',' ','\xa9','C','P','U',' ','\xad','\x11','\x7f','h','a','l','t','e','d','.',
/* 0x0badb = "Go ahead with the default Read/Write operation." */
    'G','o',' ','a','h','e','a','d',' ','\x80','\x02','d','e','f','a','u','l','t',' ','R','e','a','d','/','W','r','i','t','e',' ','\xea',
/* 0x0bafa = "Unknown character class in glob pattern." */
    '\xef','c','h','a','r','a','c','t','e','r',' ','c','l','a','s','s',' ','\x0f','g','l','o','b',' ','p','a','t','t','e','r','n','.',
/* 0x0bb19 = "Internal ISO maker error: Namespace problem #5." */
    '\x07','\xc1',' ','m','a','k','e','r',' ','\xd8','N','a','m','e','s','p','a','c','e',' ','p','r','o','b','l','e','m',' ','#','5','.',
/* 0x0bb38 = "Host operating system related error." */
    'H','o','s','t',' ','o','p','e','r','a','t','i','n','g',' ','s','y','s','t','e','m',' ','r','e','l','a','t','e','d',' ','\x85',
/* 0x0bb57 = "Internal ISO maker error: Namespace problem #3." */
    '\x07','\xc1',' ','m','a','k','e','r',' ','\xd8','N','a','m','e','s','p','a','c','e',' ','p','r','o','b','l','e','m',' ','#','3','.',
/* 0x0bb76 = "Unsupported interface for managed object reference." */
    '\x98','i','n','t','e','r','f','a','c','e',' ','\x10','m','a','n','a','g','e','d',' ','\xa8','r','e','f','e','r','e','n','c','e','.',
/* 0x0bb95 = "VWRN_UNABLE_TO_SATISFY_REQUIREMENTS" */
    '\xe6','U','N','A','B','L','E','_','T','O','_','S','A','T','I','S','F','Y','_','R','E','Q','U','I','R','E','M','E','N','T','S',
/* 0x0bbb4 = "Detected unsafe code for patching." */
    'D','e','t','e','c','t','e','d',' ','u','n','s','a','f','e',' ','c','o','d','e',' ','\x10','p','a','t','c','h','i','n','g','.',
/* 0x0bbd3 = "VINF_AUDIO_STREAM_ASYNC_INIT_NEEDED" */
    '\x0e','A','U','D','I','O','_','S','T','R','E','A','M','_','A','S','Y','N','C','_','I','N','I','T','_','N','E','E','D','E','D',
/* 0x0bbf2 = "Concurrent access to the object is not allowed." */
    'C','o','n','c','u','r','r','e','n','t',' ','a','c','c','e','s','s',' ','\x0a','\x02','\xa8','\x0b','\x08','a','l','l','o','w','e','d','.',
/* 0x0bc11 = "VERR_CR_SPC_IND_DATA_DIGEST_ALGO_NOT_IN_DIGEST_ALGOS" */
    '\x01','\x24','S','P','C','_','I','N','D','_','D','A','T','A','_','\xbe','A','L','G','O','_','\x06','I','N','_','\xbe','A','L','G','O','S',
/* 0x0bc30 = "The chunk has already been mapped into the process." */
    '\x03','c','h','u','n','k',' ','\x5e','\x7f','\xcb','m','a','p','p','e','d',' ','i','n','t','o',' ','\x02','p','r','o','c','e','s','s','.',
/* 0x0bc4f = "The image is too small or too large for this format." */
    '\x03','\x26','\x0b','\x9e','s','m','a','l','l',' ','\xa9','\x9e','l','a','r','g','e',' ','\x10','t','h','i','s',' ','f','o','r','m','a','t','.',
/* 0x0bc6e = "Unresolved (unknown) pipe i/o error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','p','i','p','e',' ','i','/','o',' ','\x85',
/* 0x0bc8d = "Shared Clipboard transfer ID not found." */
    'S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','t','r','a','n','s','f','e','r',' ','I','D',' ','\x08','\x89',
/* 0x0bcac = "Trailing element separator not permitted." */
    'T','r','a','i','l','i','n','g',' ','\x5c','s','e','p','a','r','a','t','o','r',' ','\x08','p','e','r','m','i','t','t','e','d','.',
/* 0x0bccb = "AMD-V CPU extension not available." */
    'A','M','D','-','V',' ','C','P','U',' ','e','x','t','e','n','s','i','o','n',' ','\x08','a','v','a','i','l','a','b','l','e','.',
/* 0x0bcea = "VERR_CR_PKIX_CIPHER_ALGO_PARAMS_NOT_IMPL" */
    '\x01','\x24','P','K','I','X','_','C','I','P','H','E','R','_','A','L','G','O','_','P','A','R','A','M','S','_','\x06','I','M','P','L',
/* 0x0bd09 = "There is no volume behind the current one." */
    'T','h','e','r','e',' ','\x0b','n','o',' ','\xd2','b','e','h','i','n','d',' ','\x02','c','u','r','r','e','n','t',' ','o','n','e','.',
/* 0x0bd28 = "The signal being posted is not correct." */
    '\x03','s','i','g','n','a','l',' ','b','e','i','n','g',' ','p','o','s','t','e','d',' ','\x0b','\x08','c','o','r','r','e','c','t','.',
/* 0x0bd47 = "Image Verification Failure: Error allocating memory for section headers." */
    'I','m','a','g','e',' ','\x0d','\x12','\xc0','a','l','l','o','c','a','t','i','n','g',' ','\x86','\x10','\xdb','h','e','a','d','e','r','s','.',
/* 0x0bd66 = "VERR_CR_PKIX_OSSL_VS_IPRT_SIGNATURE_SIZE" */
    '\x01','\x24','P','K','I','X','_','O','S','S','L','_','V','S','_','I','P','R','T','_','S','I','G','N','A','T','U','R','E','_','\xf9',
/* 0x0bd85 = "VERR_SUP_VP_NOT_VALID_KERNEL_CODE_SIGNATURE" */
    '\x01','\x95','\xbd','\x06','V','A','L','I','D','_','K','E','R','N','E','L','_','C','O','D','E','_','S','I','G','N','A','T','U','R','E',
/* 0x0bda4 = "VFS chain element takes exactly one argument." */
    '\x8d',' ','\xa1','\x5c','t','a','k','e','s',' ','e','x','a','c','t','l','y',' ','o','n','e',' ','a','r','g','u','m','e','n','t','.',
/* 0x0bdc3 = "Too many volume descriptors in the import ISO." */
    'T','o','o',' ','\xb4','\xd2','d','e','s','c','r','i','p','t','o','r','s',' ','\x0f','\x02','i','m','p','o','r','t',' ','I','S','O','.',
/* 0x0bde2 = "Can\'t unlock - region was not locked." */
    'C','a','n','\'','t',' ','u','n','l','o','c','k',' ','-',' ','r','e','g','i','o','n',' ','\x11','\x08','l','o','c','k','e','d','.',
/* 0x0be01 = "Bad or missing XAR checksum element." */
    '\x9f','\xa9','m','i','s','s','i','n','g',' ','X','A','R',' ','c','h','e','c','k','s','u','m',' ','e','l','e','m','e','n','t','.',
/* 0x0be20 = "VERR_UNABLE_TO_SATISFY_REQUIREMENTS" */
    '\x01','U','N','A','B','L','E','_','T','O','_','S','A','T','I','S','F','Y','_','R','E','Q','U','I','R','E','M','E','N','T','S',
/* 0x0be3f = "VERR_CR_SPC_NOT_EXACTLY_ONE_SIGNER_INFOS" */
    '\x01','\x24','S','P','C','_','\x06','E','X','A','C','T','L','Y','_','O','N','E','_','S','I','G','N','E','R','_','I','N','F','O','S',
/* 0x0be5e = "Process Verification Failure: Error query virtual memory information." */
    '\x1e','\x0d','\x12','\xc0','q','u','e','r','y',' ','v','i','r','t','u','a','l',' ','\x86','i','n','f','o','r','m','a','t','i','o','n','.',
/* 0x0be7d = "VERR_IEM_FIXUP_SHORT_JMP_TO_TAIL_LABEL" */
    '\x01','\x9c','F','I','X','U','P','_','S','H','O','R','T','_','J','M','P','_','T','O','_','T','A','I','L','_','L','A','B','E','L',
/* 0x0be9c = "Missing encoding element for XAR data stream." */
    'M','i','s','s','i','n','g',' ','e','n','c','o','d','i','n','g',' ','\x5c','\x10','X','A','R',' ','\x9d','s','t','r','e','a','m','.',
/* 0x0bebb = "VERR_SHMEM_MAXIMUM_MAPPINGS_REACHED" */
    '\x01','S','H','M','E','M','_','M','A','X','I','M','U','M','_','M','A','P','P','I','N','G','S','_','R','E','A','C','H','E','D',
/* 0x0beda = "Process Verification Failure: An image mapping failed to report a name." */
    '\x1e','\x0d','\x12','A','n',' ','\x26','m','a','p','p','i','n','g',' ','\x99','\x0a','r','e','p','o','r','t',' ','a',' ','n','a','m','e','.',
/* 0x0bef9 = "Not a uniform standard tape v0." */
    'N','o','t',' ','a',' ','u','n','i','f','o','r','m',' ','s','t','a','n','d','a','r','d',' ','t','a','p','e',' ','v','0','.',
/* 0x0bf18 = "Deferred loading of information failed." */
    'D','e','f','e','r','r','e','d',' ','l','o','a','d','i','n','g',' ','\x15','i','n','f','o','r','m','a','t','i','o','n',' ','\x7b',
/* 0x0bf37 = "Internal ISO maker error: Namespace problem #6." */
    '\x07','\xc1',' ','m','a','k','e','r',' ','\xd8','N','a','m','e','s','p','a','c','e',' ','p','r','o','b','l','e','m',' ','#','6','.',
/* 0x0bf56 = "VINF_EM_RAW_EMULATE_INSTR_TSS_FAULT" */
    '\x0e','E','M','_','R','A','W','_','E','M','U','L','A','T','E','_','I','N','S','T','R','_','T','S','S','_','F','A','U','L','T',
/* 0x0bf75 = "No more search handles available." */
    '\xdf','m','o','r','e',' ','s','e','a','r','c','h',' ','h','a','n','d','l','e','s',' ','a','v','a','i','l','a','b','l','e','.',
/* 0x0bf94 = "Internal error in read-write critical section." */
    '\x07','\x09','\x0f','r','e','a','d','-','w','r','i','t','e',' ','c','r','i','t','i','c','a','l',' ','s','e','c','t','i','o','n','.',
/* 0x0bfb3 = "VINF_EM_RAW_EMULATE_INSTR_IDT_FAULT" */
    '\x0e','E','M','_','R','A','W','_','E','M','U','L','A','T','E','_','I','N','S','T','R','_','I','D','T','_','F','A','U','L','T',
/* 0x0bfd2 = "Unresolved (unknown) disk i/o error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','d','i','s','k',' ','i','/','o',' ','\x85',
/* 0x0bff1 = "VERR_GSTCTL_MAX_CID_OBJECTS_REACHED" */
    '\x01','G','S','T','C','T','L','_','M','A','X','_','C','I','D','_','O','B','J','E','C','T','S','_','R','E','A','C','H','E','D',
/* 0x0c010 = "Pending interrupt is masked by TPR." */
    'P','e','n','d','i','n','g',' ','i','n','t','e','r','r','u','p','t',' ','\x0b','m','a','s','k','e','d',' ','\xe1','T','P','R','.',
/* 0x0c02f = "VERR_PCI_PASSTHROUGH_NO_NESTED_PAGING" */
    '\x01','P','C','I','_','P','A','S','S','T','H','R','O','U','G','H','_','\x60','N','E','S','T','E','D','_','P','A','G','I','N','G',
/* 0x0c04e = "VERR_PGM_GCPHYS_RANGE_CROSSES_BOUNDARY" */
    '\x01','\x8c','G','C','P','H','Y','S','_','R','A','N','G','E','_','C','R','O','S','S','E','S','_','B','O','U','N','D','A','R','Y',
/* 0x0c06d = "No clipboard data available for requested format." */
    '\xdf','c','l','i','p','b','o','a','r','d',' ','\x9d','a','v','a','i','l','a','b','l','e',' ','\x10','\xde','f','o','r','m','a','t','.',
/* 0x0c08c = "VINF_EM_RAW_EMULATE_INSTR_LDT_FAULT" */
    '\x0e','E','M','_','R','A','W','_','E','M','U','L','A','T','E','_','I','N','S','T','R','_','L','D','T','_','F','A','U','L','T',
/* 0x0c0ab = "Internal ISO maker error: Namespace problem #4." */
    '\x07','\xc1',' ','m','a','k','e','r',' ','\xd8','N','a','m','e','s','p','a','c','e',' ','p','r','o','b','l','e','m',' ','#','4','.',
/* 0x0c0ca = "VERR_ISOMK_IMPORT_SUPPLEMENTARY_BEFORE_PRIMARY" */
    '\x01','\x22','\x83','S','U','P','P','L','E','M','E','N','T','A','R','Y','_','B','E','F','O','R','E','_','P','R','I','M','A','R','Y',
/* 0x0c0e9 = "Misconfigured driver chain transformation." */
    'M','i','s','c','o','n','f','i','g','u','r','e','d',' ','\xc5','\xa1','t','r','a','n','s','f','o','r','m','a','t','i','o','n','.',
/* 0x0c108 = "Recompiler: Translation block allocation failed." */
    '\x13','T','r','a','n','s','l','a','t','i','o','n',' ','b','l','o','c','k',' ','a','l','l','o','c','a','t','i','o','n',' ','\x7b',
/* 0x0c127 = "VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_RESERVED_FLAG" */
    '\x01','\x22','\x83','B','O','O','T','_','C','A','T','_','E','N','T','R','Y','_','R','E','S','E','R','V','E','D','_','F','L','A','G',
/* 0x0c146 = "VERR_ISOMK_IMPORT_MISMATCHING_MULTI_EXTENT_REC" */
    '\x01','\x22','\x83','M','I','S','M','A','T','C','H','I','N','G','_','M','U','L','T','I','_','E','X','T','E','N','T','_','R','E','C',
/* 0x0c165 = "VERR_VM_REQUEST_STATUS_STILL_PENDING" */
    '\x01','\xcd','_','R','E','Q','U','E','S','T','_','S','T','A','T','U','S','_','S','T','I','L','L','_','P','E','N','D','I','N','G',
/* 0x0c184 = "The size of the raw image is not dividable by 2048." */
    '\x03','s','i','z','e',' ','\x15','\x02','r','a','w',' ','\x26','\x0b','\x08','d','i','v','i','d','a','b','l','e',' ','\xe1','2','0','4','8','.',
/* 0x0c1a3 = "The connection to the FAM daemon was lost." */
    '\x03','c','o','n','n','e','c','t','i','o','n',' ','\x0a','\x02','F','A','M',' ','d','a','e','m','o','n',' ','\x11','l','o','s','t','.',
/* 0x0c1c2 = "Internal ISO maker error: Namespace problem #2." */
    '\x07','\xc1',' ','m','a','k','e','r',' ','\xd8','N','a','m','e','s','p','a','c','e',' ','p','r','o','b','l','e','m',' ','#','2','.',
/* 0x0c1e1 = "VFS chain does not terminate with the desired object type." */
    '\x8d',' ','\xa1','\xb2','\x08','t','e','r','m','i','n','a','t','e',' ','\x80','\x02','d','e','s','i','r','e','d',' ','\xa8','t','y','p','e','.',
/* 0x0c200 = "Couldn\'t map pages during send." */
    'C','o','u','l','d','n','\'','t',' ','m','a','p',' ','p','a','g','e','s',' ','d','u','r','i','n','g',' ','s','e','n','d','.',
/* 0x0c21f = "Unabled to locate an OpenGL symbol." */
    'U','n','a','b','l','e','d',' ','\x0a','l','o','c','a','t','e',' ','\x87','O','p','e','n','G','L',' ','s','y','m','b','o','l','.',
/* 0x0c23e = "The DEK for disk encryption is missing." */
    '\x03','D','E','K',' ','\x10','d','i','s','k',' ','e','n','c','r','y','p','t','i','o','n',' ','\x0b','m','i','s','s','i','n','g','.',
/* 0x0c25d = "Internal ISO maker error: Expected path to start with root slash." */
    '\x07','\xc1',' ','m','a','k','e','r',' ','\xd8','\xb8','\xd0','\x0a','s','t','a','r','t',' ','\x80','r','o','o','t',' ','s','l','a','s','h','.',
/* 0x0c27c = "VERR_AUDIO_STREAM_INIT_IN_PROGRESS" */
    '\x01','A','U','D','I','O','_','S','T','R','E','A','M','_','I','N','I','T','_','I','N','_','P','R','O','G','R','E','S','S',
/* 0x0c29a = "Reason for leaving RC: Caller the tracer in ring-0." */
    '\x93','\x10','\x81','R','C',':',' ','C','a','l','l','e','r',' ','\x02','t','r','a','c','e','r',' ','\x0f','r','i','n','g','-','0','.',
/* 0x0c2b8 = "Internal processing error #3 in the PGM physial page mapping code." */
    '\x07','\x04','\x09','#','3',' ','\x0f','\x02','P','G','M',' ','p','h','y','s','i','a','l',' ','\xcc','m','a','p','p','i','n','g',' ','\x84',
/* 0x0c2d6 = "A digest doesn't match the corresponding file." */
    'A',' ','\xd7','\xc7','m','a','t','c','h',' ','\x02','c','o','r','r','e','s','p','o','n','d','i','n','g',' ','f','i','l','e','.',
/* 0x0c2f4 = "Import ISO contains a directory with an extent that is out of bounds." */
    '\xc3','\xc1',' ','\x8a','a',' ','\x25','\x80','\x87','e','x','t','e','n','t',' ','\xad','\x0b','o','u','t',' ','\x15','b','o','u','n','d','s','.',
/* 0x0c312 = "Internal processing error #1 in the PGM physial page mapping code." */
    '\x07','\x04','\x09','#','1',' ','\x0f','\x02','P','G','M',' ','p','h','y','s','i','a','l',' ','\xcc','m','a','p','p','i','n','g',' ','\x84',
/* 0x0c330 = "VERR_JSON_BAD_SURROGATE_PAIR_SEQUENCE" */
    '\x01','J','S','O','N','_','\x1d','S','U','R','R','O','G','A','T','E','_','P','A','I','R','_','S','E','Q','U','E','N','C','E',
/* 0x0c34e = "Missing size element in table of content sub-element." */
    'M','i','s','s','i','n','g',' ','s','i','z','e',' ','\x5c','\x0f','\xb1','\x15','\xf0','s','u','b','-','e','l','e','m','e','n','t','.',
/* 0x0c36c = "The PE loader encountered a malformed certificate." */
    '\x03','P','E',' ','\xd9','\xaf','a',' ','m','a','l','f','o','r','m','e','d',' ','c','e','r','t','i','f','i','c','a','t','e','.',
/* 0x0c38a = "One of the custom modes was incorrect." */
    'O','n','e',' ','\x15','\x02','c','u','s','t','o','m',' ','m','o','d','e','s',' ','\x11','i','n','c','o','r','r','e','c','t','.',
/* 0x0c3a8 = "VERR_CR_CIPHER_OSSL_ENCRYPT_UPDATE_FAILED" */
    '\x01','\x24','C','I','P','H','E','R','_','O','S','S','L','_','E','N','C','R','Y','P','T','_','U','P','D','A','T','E','_','\x17',
/* 0x0c3c6 = "VERR_ISOMK_IMPORT_MORE_THAN_ONE_VOLUME_IN_SET" */
    '\x01','\x22','\x83','M','O','R','E','_','T','H','A','N','_','O','N','E','_','V','O','L','U','M','E','_','I','N','_','S','E','T',
/* 0x0c3e4 = "Recompiler: Failed to allocate more memory for debug info." */
    '\x13','\x8b','\x0a','a','l','l','o','c','a','t','e',' ','m','o','r','e',' ','\x86','\x10','d','e','b','u','g',' ','i','n','f','o','.',
/* 0x0c402 = "VERR_URI_ESCAPED_CHARS_NOT_VALID_UTF8" */
    '\x01','U','R','I','_','E','S','C','A','P','E','D','_','C','H','A','R','S','_','\x06','V','A','L','I','D','_','U','T','F','8',
/* 0x0c420 = "VERR_SUP_VP_FOUND_MORE_THAN_ONE_EXE_MAPPING" */
    '\x01','\x95','\xbd','\x2a','_','M','O','R','E','_','T','H','A','N','_','O','N','E','_','E','X','E','_','M','A','P','P','I','N','G',
/* 0x0c43e = "Unresolved (unknown) network error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','n','e','t','w','o','r','k',' ','\x85',
/* 0x0c45c = "Leading element separator not permitted." */
    'L','e','a','d','i','n','g',' ','\x5c','s','e','p','a','r','a','t','o','r',' ','\x08','p','e','r','m','i','t','t','e','d','.',
/* 0x0c47a = "Internal processing error while merging status codes." */
    '\x07','\x04','\x09','w','h','i','l','e',' ','m','e','r','g','i','n','g',' ','s','t','a','t','u','s',' ','c','o','d','e','s','.',
/* 0x0c498 = "The specified path does not point at a symbolic link." */
    '\x03','\x18','\xd0','\xb2','\x08','p','o','i','n','t',' ','a','t',' ','a',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k','.',
/* 0x0c4b6 = "VERR_CR_PASSWORD_2_KEY_DERIVIATION_FAILED" */
    '\x01','\x24','P','A','S','S','W','O','R','D','_','2','_','K','E','Y','_','D','E','R','I','V','I','A','T','I','O','N','_','\x17',
/* 0x0c4d4 = "Missing UTF-16 surrogate pair." */
    'M','i','s','s','i','n','g',' ','U','T','F','-','1','6',' ','s','u','r','r','o','g','a','t','e',' ','p','a','i','r','.',
/* 0x0c4f2 = "VERR_MAIN_CONFIG_CONSTRUCTOR_COM_ERROR" */
    '\x01','M','A','I','N','_','C','O','N','F','I','G','_','C','O','N','S','T','R','U','C','T','O','R','_','C','O','M','_','\x1b',
/* 0x0c510 = "The timer failed to reach a stable state." */
    '\x03','t','i','m','e','r',' ','\x99','\x0a','r','e','a','c','h',' ','a',' ','s','t','a','b','l','e',' ','s','t','a','t','e','.',
/* 0x0c52e = "Bad VTG argument list descriptor." */
    '\x9f','V','T','G',' ','a','r','g','u','m','e','n','t',' ','l','i','s','t',' ','d','e','s','c','r','i','p','t','o','r','.',
/* 0x0c54c = "VT-x VMCS field cache invalid." */
    'V','T','-','x',' ','V','M','C','S',' ','f','i','e','l','d',' ','c','a','c','h','e',' ','i','n','v','a','l','i','d','.',
/* 0x0c56a = "VERR_CR_X509_TBSCERT_DUPLICATE_EXTENSION" */
    '\x01','\x24','\xb7','T','B','S','C','E','R','T','_','D','U','P','L','I','C','A','T','E','_','E','X','T','E','N','S','I','O','N',
/* 0x0c588 = "The path is not the same object as the native handle (hardening)." */
    '\x03','\xd0','\x0b','\x08','\x02','s','a','m','e',' ','\xa8','a','s',' ','\x02','n','a','t','i','v','e',' ','h','a','n','d','l','e',' ','\xae',
/* 0x0c5a6 = "Reason for leaving RC: attempt to patch MMIO write." */
    '\x93','\x10','\x81','R','C',':',' ','a','t','t','e','m','p','t',' ','\x0a','p','a','t','c','h',' ','\xd3',' ','w','r','i','t','e','.',
/* 0x0c5c4 = "Internal processing error #4 in the PGM physial page mapping code." */
    '\x07','\x04','\x09','#','4',' ','\x0f','\x02','P','G','M',' ','p','h','y','s','i','a','l',' ','\xcc','m','a','p','p','i','n','g',' ','\x84',
/* 0x0c5e2 = "VT-x features disabled by the BIOS." */
    'V','T','-','x',' ','f','e','a','t','u','r','e','s',' ','d','i','s','a','b','l','e','d',' ','\xe1','\x02','B','I','O','S','.',
/* 0x0c600 = "VERR_PGM_INTERMEDIATE_PAGING_CONFLICT" */
    '\x01','\x8c','I','N','T','E','R','M','E','D','I','A','T','E','_','P','A','G','I','N','G','_','C','O','N','F','L','I','C','T',
/* 0x0c61e = "Import ISO contains a bad primary volume descriptor." */
    '\xc3','\xc1',' ','\x8a','a',' ','b','a','d',' ','p','r','i','m','a','r','y',' ','\xd2','d','e','s','c','r','i','p','t','o','r','.',
/* 0x0c63c = "VERR_PCI_PASSTHROUGH_NO_RAM_PREALLOC" */
    '\x01','P','C','I','_','P','A','S','S','T','H','R','O','U','G','H','_','\x60','R','A','M','_','P','R','E','A','L','L','O','C',
/* 0x0c65a = "VERR_CR_CIPHER_OSSL_DECRYPT_UPDATE_FAILED" */
    '\x01','\x24','C','I','P','H','E','R','_','O','S','S','L','_','D','E','C','R','Y','P','T','_','U','P','D','A','T','E','_','\x17',
/* 0x0c678 = "A path is relative, expected an absolute path." */
    'A',' ','\xd0','\x0b','r','e','l','a','t','i','v','e',',',' ','\xc9','\x87','a','b','s','o','l','u','t','e',' ','p','a','t','h','.',
/* 0x0c696 = "Termination record integrity error." */
    'T','e','r','m','i','n','a','t','i','o','n',' ','r','e','c','o','r','d',' ','i','n','t','e','g','r','i','t','y',' ','\x85',
/* 0x0c6b4 = "Reason for leaving RC: Fatal trap in hypervisor." */
    '\x93','\x10','\x81','R','C',':',' ','F','a','t','a','l',' ','t','r','a','p',' ','\x0f','h','y','p','e','r','v','i','s','o','r','.',
/* 0x0c6d2 = "VERR_INTNET_FLT_LOWER_LINK_INFO_NOT_FOUND" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','L','O','W','E','R','_','L','I','N','K','_','I','N','F','O','_','\x06','\x2a',
/* 0x0c6f0 = "The tracepoint provider object is too large." */
    '\x03','t','r','a','c','e','p','o','i','n','t',' ','p','r','o','v','i','d','e','r',' ','\xa8','\x0b','\x9e','l','a','r','g','e','.',
/* 0x0c70e = "Too many references: can\'t splice." */
    'T','o','o',' ','\xb4','r','e','f','e','r','e','n','c','e','s',':',' ','c','a','n','\'','t',' ','s','p','l','i','c','e','.',
/* 0x0c72c = "Image Verification Failure: More than one certificate table entry." */
    'I','m','a','g','e',' ','\x0d','\x12','M','o','r','e',' ','t','h','a','n',' ','o','n','e',' ','\xa0','\xb1','e','n','t','r','y','.',
/* 0x0c74a = "PKIX cipher algorithm is not known to OpenSSL." */
    'P','K','I','X',' ','c','i','p','h','e','r',' ','\xd4','\x0b','\x08','k','n','o','w','n',' ','\x0a','O','p','e','n','S','S','L','.',
/* 0x0c768 = "The module contains no line number information." */
    '\x03','m','o','d','u','l','e',' ','\x8a','n','o',' ','l','i','n','e',' ','\xfb','i','n','f','o','r','m','a','t','i','o','n','.',
/* 0x0c786 = "Found an illegal symbolic link (hardening)." */
    'F','o','u','n','d',' ','\x87','i','l','l','e','g','a','l',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k',' ','\xae',
/* 0x0c7a4 = "The size of the raw floppy image is too big (>2." */
    '\x03','s','i','z','e',' ','\x15','\x02','r','a','w',' ','f','l','o','p','p','y',' ','\x26','\x0b','\x9e','b','i','g',' ','(','>','2','.',
/* 0x0c7c2 = "Reason for leaving RZ: Pending I/O port write." */
    '\x93','\x10','\x81','R','Z',':',' ','P','e','n','d','i','n','g',' ','I','/','O',' ','p','o','r','t',' ','w','r','i','t','e','.',
/* 0x0c7e0 = "Image Verification Failure: Error determining the file length." */
    'I','m','a','g','e',' ','\x0d','\x12','\xc0','d','e','t','e','r','m','i','n','i','n','g',' ','\x02','\x1f','l','e','n','g','t','h','.',
/* 0x0c7fe = "VERR_ASN1_CURSOR_ILLEGAL_CONSTRUCTED_STRING" */
    '\x01','\xa2','C','U','R','S','O','R','_','I','L','L','E','G','A','L','_','C','O','N','S','T','R','U','C','T','E','D','_','\xd5',
/* 0x0c81c = "VINF_GMM_SHARED_MODULE_ALREADY_REGISTERED" */
    '\x0e','G','M','M','_','S','H','A','R','E','D','_','M','O','D','U','L','E','_','\x9b','R','E','G','I','S','T','E','R','E','D',
/* 0x0c83a = "XML error while parsing the table of content." */
    'X','M','L',' ','\x09','w','h','i','l','e',' ','p','a','r','s','i','n','g',' ','\x02','\xb1','\x15','c','o','n','t','e','n','t','.',
/* 0x0c858 = "Import ISO contains a root directory with multiple extents." */
    '\xc3','\xc1',' ','\x8a','a',' ','r','o','o','t',' ','\x25','\x80','m','u','l','t','i','p','l','e',' ','e','x','t','e','n','t','s','.',
/* 0x0c876 = "Process Verification Failure: The image mapping is too large (>= 2GB)." */
    '\x1e','\x0d','\x12','\x03','\x26','m','a','p','p','i','n','g',' ','\x0b','\x9e','l','a','r','g','e',' ','(','>','=',' ','2','G','B',')','.',
/* 0x0c894 = "VERR_REST_WRONG_JSON_TYPE_FOR_INTEGER" */
    '\x01','R','E','S','T','_','W','R','O','N','G','_','J','S','O','N','_','\xb5','_','F','O','R','_','I','N','T','E','G','E','R',
/* 0x0c8b2 = "VERR_ISOMK_IMPORT_NON_CONTIGUOUS_MULTI_EXTENT" */
    '\x01','\x22','\x83','N','O','N','_','C','O','N','T','I','G','U','O','U','S','_','M','U','L','T','I','_','E','X','T','E','N','T',
/* 0x0c8d0 = "Expected PE image data inside indirect data object." */
    '\xb8','P','E',' ','\x26','\x9d','i','n','s','i','d','e',' ','i','n','d','i','r','e','c','t',' ','\x9d','o','b','j','e','c','t','.',
/* 0x0c8ee = "The DTB being parsed has a version set which is not supported." */
    '\x03','D','T','B',' ','b','e','i','n','g',' ','p','a','r','s','e','d',' ','\x5e','a',' ','\xcf','s','e','t',' ','\xed','\x0b','\x08','\xa4',
/* 0x0c90c = "The size of the raw image is not dividable by 512." */
    '\x03','s','i','z','e',' ','\x15','\x02','r','a','w',' ','\x26','\x0b','\x08','d','i','v','i','d','a','b','l','e',' ','\xe1','5','1','2','.',
/* 0x0c92a = "Unfinished debug info reader code." */
    'U','n','f','i','n','i','s','h','e','d',' ','d','e','b','u','g',' ','i','n','f','o',' ','r','e','a','d','e','r',' ','\x84',
/* 0x0c948 = "Too many loops looking for a page to reuse." */
    'T','o','o',' ','\xb4','l','o','o','p','s',' ','l','o','o','k','i','n','g',' ','\x10','a',' ','\xcc','\x0a','r','e','u','s','e','.',
/* 0x0c966 = "VERR_IEM_EMIT_FIXED_JUMP_OUT_OF_RANGE" */
    '\x01','\x9c','E','M','I','T','_','F','I','X','E','D','_','J','U','M','P','_','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x0c984 = "Invalid initialization vector length." */
    '\x0c','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','v','e','c','t','o','r',' ','l','e','n','g','t','h','.',
/* 0x0c9a2 = "VERR_DBG_SEGMENT_NAME_OUT_OF_RANGE" */
    '\x01','D','B','G','_','S','E','G','M','E','N','T','_','N','A','M','E','_','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x0c9c0 = "Internal processing error #2 in the PGM physial page mapping code." */
    '\x07','\x04','\x09','#','2',' ','\x0f','\x02','P','G','M',' ','p','h','y','s','i','a','l',' ','\xcc','m','a','p','p','i','n','g',' ','\x84',
/* 0x0c9de = "VERR_CR_PKIX_OSSL_CIPHER_ALOG_INIT_FAILED" */
    '\x01','\x24','P','K','I','X','_','O','S','S','L','_','C','I','P','H','E','R','_','A','L','O','G','_','I','N','I','T','_','\x17',
/* 0x0c9fc = "VERR_WEB_INVALID_MANAGED_OBJECT_REFERENCE" */
    '\x01','W','E','B','_','\x05','M','A','N','A','G','E','D','_','O','B','J','E','C','T','_','R','E','F','E','R','E','N','C','E',
/* 0x0ca1a = "VERR_SUP_VP_NOT_OWNED_BY_TRUSTED_INSTALLER" */
    '\x01','\x95','\xbd','\x06','O','W','N','E','D','_','B','Y','_','T','R','U','S','T','E','D','_','I','N','S','T','A','L','L','E','R',
/* 0x0ca38 = "OpenSSL failed to decode the private key." */
    'O','p','e','n','S','S','L',' ','\x99','\x0a','d','e','c','o','d','e',' ','\x02','p','r','i','v','a','t','e',' ','k','e','y','.',
/* 0x0ca56 = "VERR_CR_PKIX_OSSL_EVP_PKEY_RSA_PAD_ERROR" */
    '\x01','\x24','P','K','I','X','_','O','S','S','L','_','E','V','P','_','P','K','E','Y','_','R','S','A','_','P','A','D','_','\x1b',
/* 0x0ca74 = "The DBGF couldn\'t find the specified breakpoint." */
    '\x03','\xb9',' ','c','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','\x02','\x18','b','r','e','a','k','p','o','i','n','t','.',
/* 0x0ca92 = "VERR_TRACELOG_READER_MALFORMED_LOG" */
    '\x01','T','R','A','C','E','L','O','G','_','R','E','A','D','E','R','_','M','A','L','F','O','R','M','E','D','_','L','O','G',
/* 0x0cab0 = "VERR_HARDAVL_POINTER_OUT_OF_BOUNDS" */
    '\x01','H','A','R','D','A','V','L','_','P','O','I','N','T','E','R','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x0cace = "Attempt to resume a running TSC." */
    'A','t','t','e','m','p','t',' ','\x0a','r','e','s','u','m','e',' ','a',' ','r','u','n','n','i','n','g',' ','T','S','C','.',
/* 0x0caec = "internal fixup chain isn\'t implemented yet." */
    '\x16','f','i','x','u','p',' ','\xa1','i','s','n','\'','t',' ','i','m','p','l','e','m','e','n','t','e','d',' ','y','e','t','.',
/* 0x0cb0a = "VERR_VFS_CHAIN_EXPECTED_RIGHT_PARENTHESES" */
    '\x01','\x8d','_','\x8e','E','X','P','E','C','T','E','D','_','R','I','G','H','T','_','P','A','R','E','N','T','H','E','S','E','S',
/* 0x0cb28 = "Object being in use prohibits operation." */
    'O','b','j','e','c','t',' ','b','e','i','n','g',' ','\x0f','u','s','e',' ','p','r','o','h','i','b','i','t','s',' ','\xea',
/* 0x0cb45 = "Bad DWARF extended line number opcode." */
    '\x9f','D','W','A','R','F',' ','e','x','t','e','n','d','e','d',' ','l','i','n','e',' ','\xfb','o','p','c','o','d','e','.',
/* 0x0cb62 = "Failed to derivate key from password." */
    '\x8b','\x0a','d','e','r','i','v','a','t','e',' ','k','e','y',' ','f','r','o','m',' ','p','a','s','s','w','o','r','d','.',
/* 0x0cb7f = "Too many instances of a usb device." */
    'T','o','o',' ','\xb4','i','n','s','t','a','n','c','e','s',' ','\x15','a',' ','u','s','b',' ','d','e','v','i','c','e','.',
/* 0x0cb9c = "The specified CPU cannot be found in the CPU database." */
    '\x03','\x18','C','P','U',' ','\xd1','\xa7','f','o','u','n','d',' ','\x0f','\x02','C','P','U',' ','d','a','t','a','b','a','s','e','.',
/* 0x0cbb9 = "Encountered an unexpected page state in the saved state." */
    '\xa5','\x87','u','n','e','x','p','e','c','t','e','d',' ','\xcc','\xca','\x0f','\x02','s','a','v','e','d',' ','s','t','a','t','e','.',
/* 0x0cbd6 = "Restart the current instruction." */
    'R','e','s','t','a','r','t',' ','\x02','c','u','r','r','e','n','t',' ','i','n','s','t','r','u','c','t','i','o','n','.',
/* 0x0cbf3 = "Expected PKCS #7 object to not contain any CRLs." */
    '\xb8','P','K','C','S',' ','#','7',' ','\xa8','\x0a','\x08','c','o','n','t','a','i','n',' ','a','n','y',' ','C','R','L','s','.',
/* 0x0cc10 = "VERR_XML_TOC_ELEMENT_HAS_SIBLINGS" */
    '\x01','X','M','L','_','T','O','C','_','E','L','E','M','E','N','T','_','H','A','S','_','S','I','B','L','I','N','G','S',
/* 0x0cc2d = "Reason for leaving RC: attempt to patch MMIO read." */
    '\x93','\x10','\x81','R','C',':',' ','a','t','t','e','m','p','t',' ','\x0a','p','a','t','c','h',' ','\xd3',' ','r','e','a','d','.',
/* 0x0cc4a = "No guest mappings when SMP is enabled." */
    '\xdf','\xbb','m','a','p','p','i','n','g','s',' ','w','h','e','n',' ','S','M','P',' ','\x0b','e','n','a','b','l','e','d','.',
/* 0x0cc67 = "Invalid partition index in a location." */
    '\x0c','p','a','r','t','i','t','i','o','n',' ','i','n','d','e','x',' ','\x0f','a',' ','l','o','c','a','t','i','o','n','.',
/* 0x0cc84 = "The display connector is resizing." */
    '\x03','d','i','s','p','l','a','y',' ','c','o','n','n','e','c','t','o','r',' ','\x0b','r','e','s','i','z','i','n','g','.',
/* 0x0cca1 = "VERR_CR_CIPHER_OSSL_DECRYPT_FINAL_FAILED" */
    '\x01','\x24','C','I','P','H','E','R','_','O','S','S','L','_','D','E','C','R','Y','P','T','_','F','I','N','A','L','_','\x17',
/* 0x0ccbe = "VERR_GMM_ATTEMPT_TO_DEFLATE_TOO_MUCH" */
    '\x01','G','M','M','_','A','T','T','E','M','P','T','_','T','O','_','D','E','F','L','A','T','E','_','\x1a','M','U','C','H',
/* 0x0ccdb = "VERR_NET_CONNECTION_RESET_BY_PEER" */
    '\x01','N','E','T','_','C','O','N','N','E','C','T','I','O','N','_','R','E','S','E','T','_','B','Y','_','P','E','E','R',
/* 0x0ccf8 = "VERR_X509_EXTRACT_RSA_FROM_PUBLIC_KEY" */
    '\x01','\xb7','E','X','T','R','A','C','T','_','R','S','A','_','F','R','O','M','_','P','U','B','L','I','C','_','K','E','Y',
/* 0x0cd15 = "The DTB being parsed is malformed." */
    '\x03','D','T','B',' ','b','e','i','n','g',' ','p','a','r','s','e','d',' ','\x0b','m','a','l','f','o','r','m','e','d','.',
/* 0x0cd32 = "Internal error - this should never happen." */
    '\x07','\x09','-',' ','t','h','i','s',' ','s','h','o','u','l','d',' ','n','e','v','e','r',' ','h','a','p','p','e','n','.',
/* 0x0cd4f = "Unexpected NULL pointer to right subtree." */
    '\x94','N','U','L','L',' ','p','o','i','n','t','e','r',' ','\x0a','r','i','g','h','t',' ','s','u','b','t','r','e','e','.',
/* 0x0cd6c = "Encountered an unexpected page type in the saved state." */
    '\xa5','\x87','u','n','e','x','p','e','c','t','e','d',' ','\xcc','\xf3','\x0f','\x02','s','a','v','e','d',' ','s','t','a','t','e','.',
/* 0x0cd89 = "VERR_TRACELOG_READER_ITERATOR_END" */
    '\x01','T','R','A','C','E','L','O','G','_','R','E','A','D','E','R','_','I','T','E','R','A','T','O','R','_','E','N','D',
/* 0x0cda6 = "Encountered an bad (/unknown) record type." */
    '\xa5','\x87','b','a','d',' ','(','/','u','n','k','n','o','w','n',')',' ','r','e','c','o','r','d',' ','t','y','p','e','.',
/* 0x0cdc3 = "VERR_PDM_ASYNC_COMPLETION_ALREADY_SUSPENDED" */
    '\x01','\x7d','A','S','Y','N','C','_','C','O','M','P','L','E','T','I','O','N','_','\x9b','S','U','S','P','E','N','D','E','D',
/* 0x0cde0 = "The installed support driver doesn't match the version of the user." */
    '\x03','i','n','s','t','a','l','l','e','d',' ','\xce','\xc5','\xc7','m','a','t','c','h',' ','\x02','\xcf','\x15','\x02','u','s','e','r','.',
/* 0x0cdfd = "VERR_X509_GETTING_DATA_FROM_EXTENSION" */
    '\x01','\xb7','G','E','T','T','I','N','G','_','D','A','T','A','_','F','R','O','M','_','E','X','T','E','N','S','I','O','N',
/* 0x0ce1a = "VERR_SUP_VP_SIGNATURE_CHECKS_NOT_ENFORCED" */
    '\x01','\x95','\xbd','S','I','G','N','A','T','U','R','E','_','C','H','E','C','K','S','_','\x06','E','N','F','O','R','C','E','D',
/* 0x0ce37 = "VERR_REST_WRONG_JSON_TYPE_FOR_DOUBLE" */
    '\x01','R','E','S','T','_','W','R','O','N','G','_','J','S','O','N','_','\xb5','_','F','O','R','_','D','O','U','B','L','E',
/* 0x0ce54 = "The OpenSSL version is too old for the attempted operation." */
    '\x03','O','p','e','n','S','S','L',' ','\xcf','\x0b','\x9e','o','l','d',' ','\x10','\x02','a','t','t','e','m','p','t','e','d',' ','\xea',
/* 0x0ce71 = "Process Verification Failure: The memory region is too large (>= 2GB)." */
    '\x1e','\x0d','\x12','\x03','\x86','r','e','g','i','o','n',' ','\x0b','\x9e','l','a','r','g','e',' ','(','>','=',' ','2','G','B',')','.',
/* 0x0ce8e = "VERR_PDM_ONE_PCI_FUNCTION_PER_DEVICE" */
    '\x01','\x7d','O','N','E','_','P','C','I','_','F','U','N','C','T','I','O','N','_','P','E','R','_','D','E','V','I','C','E',
/* 0x0ceab = "Certificate serial number length is out of bounds." */
    '\xba','s','e','r','i','a','l',' ','\xfb','l','e','n','g','t','h',' ','\x0b','o','u','t',' ','\x15','b','o','u','n','d','s','.',
/* 0x0cec8 = "VERR_URI_MISSING_UTF8_CONTINUATION_BYTE" */
    '\x01','U','R','I','_','\xc4','_','U','T','F','8','_','C','O','N','T','I','N','U','A','T','I','O','N','_','B','Y','T','E',
/* 0x0cee5 = "VERR_CR_SPC_SIGNED_IND_DATA_DIGEST_ALGO_MISMATCH" */
    '\x01','\x24','S','P','C','_','S','I','G','N','E','D','_','I','N','D','_','D','A','T','A','_','\xbe','A','L','G','O','_','\x19',
/* 0x0cf02 = "The VM request was killed at VM termination." */
    '\x03','\xcd',' ','\xaa','\x11','k','i','l','l','e','d',' ','a','t',' ','\xcd',' ','t','e','r','m','i','n','a','t','i','o','n','.',
/* 0x0cf1f = "Trying to use too new winsock API." */
    'T','r','y','i','n','g',' ','\x0a','u','s','e',' ','\x9e','n','e','w',' ','w','i','n','s','o','c','k',' ','A','P','I','.',
/* 0x0cf3c = "VERR_CR_PKIX_OSSL_D2I_PRIVATE_KEY_FAILED" */
    '\x01','\x24','P','K','I','X','_','O','S','S','L','_','D','2','I','_','P','R','I','V','A','T','E','_','K','E','Y','_','\x17',
/* 0x0cf59 = "Go back into wait for SIPI mode." */
    'G','o',' ','b','a','c','k',' ','i','n','t','o',' ','w','a','i','t',' ','\x10','S','I','P','I',' ','m','o','d','e','.',
/* 0x0cf76 = "VERR_ISOMK_IMPORT_MULTIPLE_PRIMARY_VOL_DESCS" */
    '\x01','\x22','\x83','M','U','L','T','I','P','L','E','_','P','R','I','M','A','R','Y','_','V','O','L','_','D','E','S','C','S',
/* 0x0cf93 = "VERR_PGM_HANDLER_PHYSICAL_NO_RAM_RANGE" */
    '\x01','\x8c','H','A','N','D','L','E','R','_','P','H','Y','S','I','C','A','L','_','\x60','R','A','M','_','R','A','N','G','E',
/* 0x0cfb0 = "VERR_DBG_SYMBOL_NAME_OUT_OF_RANGE" */
    '\x01','D','B','G','_','S','Y','M','B','O','L','_','N','A','M','E','_','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x0cfcd = "VERR_AUDIO_STREAM_PENDING_DISABLE" */
    '\x01','A','U','D','I','O','_','S','T','R','E','A','M','_','P','E','N','D','I','N','G','_','D','I','S','A','B','L','E',
/* 0x0cfea = "VERR_LDRLX_IMPORT_ORDINAL_OUT_OF_BOUNDS" */
    '\x01','L','D','R','L','X','_','\x83','O','R','D','I','N','A','L','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x0d007 = "The specified shared page was not actually private." */
    '\x03','\x18','s','h','a','r','e','d',' ','\xcc','\x11','\x08','a','c','t','u','a','l','l','y',' ','p','r','i','v','a','t','e','.',
/* 0x0d024 = "Wrong release order detected." */
    'W','r','o','n','g',' ','r','e','l','e','a','s','e',' ','o','r','d','e','r',' ','d','e','t','e','c','t','e','d','.',
/* 0x0d041 = "Unresolved (unknown) search error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','s','e','a','r','c','h',' ','\x85',
/* 0x0d05e = "Syntax error - out of regular heap memory." */
    '\xfa','\x09','-',' ','o','u','t',' ','\x15','r','e','g','u','l','a','r',' ','h','e','a','p',' ','m','e','m','o','r','y','.',
/* 0x0d07b = "VERR_CR_CIPHER_OSSL_ENCRYPT_FINAL_FAILED" */
    '\x01','\x24','C','I','P','H','E','R','_','O','S','S','L','_','E','N','C','R','Y','P','T','_','F','I','N','A','L','_','\x17',
/* 0x0d098 = "Found bogus values in the file system." */
    'F','o','u','n','d',' ','b','o','g','u','s',' ','v','a','l','u','e','s',' ','\x0f','\x02','\x1f','s','y','s','t','e','m','.',
/* 0x0d0b5 = "The specified data unit wasn\'t owned by caller." */
    '\x03','\x18','\x9d','u','n','i','t',' ','w','a','s','n','\'','t',' ','o','w','n','e','d',' ','\xe1','c','a','l','l','e','r','.',
/* 0x0d0d2 = "Failed to enable and lock VT-x features." */
    '\x8b','\x0a','e','n','a','b','l','e',' ','\x9a','l','o','c','k',' ','V','T','-','x',' ','f','e','a','t','u','r','e','s','.',
/* 0x0d0ef = "Wrong locking order detected." */
    'W','r','o','n','g',' ','l','o','c','k','i','n','g',' ','o','r','d','e','r',' ','d','e','t','e','c','t','e','d','.',
/* 0x0d10c = "VERR_IEM_COND_ENDIF_RECONCILIATION_FAILED" */
    '\x01','\x9c','C','O','N','D','_','E','N','D','I','F','_','R','E','C','O','N','C','I','L','I','A','T','I','O','N','_','\x17',
/* 0x0d129 = "VERR_INTNET_FLT_LOWER_LINK_OPEN_FAILED" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','L','O','W','E','R','_','L','I','N','K','_','O','P','E','N','_','\x17',
/* 0x0d146 = "VERR_VSCSI_LUN_ATTACHED_TO_DEVICE" */
    '\x01','V','S','C','S','I','_','L','U','N','_','A','T','T','A','C','H','E','D','_','T','O','_','D','E','V','I','C','E',
/* 0x0d163 = "Output can be enabled for the client." */
    'O','u','t','p','u','t',' ','c','a','n',' ','\xa7','e','n','a','b','l','e','d',' ','\x10','\x02','c','l','i','e','n','t','.',
/* 0x0d180 = "VERR_VFS_CHAIN_EXPECTED_LEFT_PARENTHESES" */
    '\x01','\x8d','_','\x8e','E','X','P','E','C','T','E','D','_','L','E','F','T','_','P','A','R','E','N','T','H','E','S','E','S',
/* 0x0d19d = "The extracted data has exceeded the expected size." */
    '\x03','e','x','t','r','a','c','t','e','d',' ','\x9d','\x5e','e','x','c','e','e','d','e','d',' ','\x02','\xc9','s','i','z','e','.',
/* 0x0d1ba = "The internal logger revision did not match." */
    '\x03','\x16','l','o','g','g','e','r',' ','r','e','v','i','s','i','o','n',' ','d','i','d',' ','\x08','m','a','t','c','h','.',
/* 0x0d1d7 = "Error opening the ApiPort LPC object." */
    '\xc0','o','p','e','n','i','n','g',' ','\x02','A','p','i','P','o','r','t',' ','L','P','C',' ','o','b','j','e','c','t','.',
/* 0x0d1f4 = "VERR_PDM_ASYNC_COMPLETION_NOT_SUSPENDED" */
    '\x01','\x7d','A','S','Y','N','C','_','C','O','M','P','L','E','T','I','O','N','_','\x06','S','U','S','P','E','N','D','E','D',
/* 0x0d211 = "VERR_FILE_AIO_INSUFFICIENT_RESSOURCES" */
    '\x01','\xab','A','I','O','_','I','N','S','U','F','F','I','C','I','E','N','T','_','R','E','S','S','O','U','R','C','E','S',
/* 0x0d22e = "The recipient process has refused the signal." */
    '\x03','r','e','c','i','p','i','e','n','t',' ','\x92','\x5e','r','e','f','u','s','e','d',' ','\x02','s','i','g','n','a','l','.',
/* 0x0d24b = "Start instruction stepping (debug only)." */
    'S','t','a','r','t',' ','\xda','s','t','e','p','p','i','n','g',' ','(','d','e','b','u','g',' ','o','n','l','y',')','.',
/* 0x0d268 = "No debug connection configured." */
    '\xdf','d','e','b','u','g',' ','c','o','n','n','e','c','t','i','o','n',' ','c','o','n','f','i','g','u','r','e','d','.',
/* 0x0d285 = "No PCI Bus is available to register the device with." */
    '\xdf','P','C','I',' ','B','u','s',' ','\x0b','a','v','a','i','l','a','b','l','e',' ','\x0a','\xeb','\x02','\xa3','w','i','t','h','.',
/* 0x0d2a2 = "Attempted to use stub switcher." */
    'A','t','t','e','m','p','t','e','d',' ','\x0a','u','s','e',' ','s','t','u','b',' ','s','w','i','t','c','h','e','r','.',
/* 0x0d2bf = "VERR_FDT_DTB_PROP_NAME_OFF_TOO_LARGE" */
    '\x01','F','D','T','_','D','T','B','_','P','R','O','P','_','N','A','M','E','_','O','F','F','_','\x1a','L','A','R','G','E',
/* 0x0d2dc = "VERR_GSTCTL_MAX_CID_COUNT_REACHED" */
    '\x01','G','S','T','C','T','L','_','M','A','X','_','C','I','D','_','C','O','U','N','T','_','R','E','A','C','H','E','D',
/* 0x0d2f9 = "The GIP update interval is too large." */
    '\x03','G','I','P',' ','u','p','d','a','t','e',' ','i','n','t','e','r','v','a','l',' ','\x0b','\x9e','l','a','r','g','e','.',
/* 0x0d316 = "Malformed unwind information." */
    'M','a','l','f','o','r','m','e','d',' ','u','n','w','i','n','d',' ','i','n','f','o','r','m','a','t','i','o','n','.',
/* 0x0d333 = "Unsupported PKCS #7 signer info version." */
    '\x98','P','K','C','S',' ','#','7',' ','s','i','g','n','e','r',' ','i','n','f','o',' ','v','e','r','s','i','o','n','.',
/* 0x0d350 = "Patch TPR access instruction." */
    'P','a','t','c','h',' ','T','P','R',' ','a','c','c','e','s','s',' ','i','n','s','t','r','u','c','t','i','o','n','.',
/* 0x0d36d = "Found bogus offset in the file system." */
    'F','o','u','n','d',' ','b','o','g','u','s',' ','o','f','f','s','e','t',' ','\x0f','\x02','\x1f','s','y','s','t','e','m','.',
/* 0x0d38a = "VERR_GMM_SHARED_MODULE_BAD_REGIONS_SIZE" */
    '\x01','G','M','M','_','S','H','A','R','E','D','_','M','O','D','U','L','E','_','\x1d','R','E','G','I','O','N','S','_','\xf9',
/* 0x0d3a7 = "OpenSSL failed to decode the public key." */
    'O','p','e','n','S','S','L',' ','\x99','\x0a','d','e','c','o','d','e',' ','\x02','p','u','b','l','i','c',' ','k','e','y','.',
/* 0x0d3c4 = "Send pagefault timeout in send." */
    'S','e','n','d',' ','p','a','g','e','f','a','u','l','t',' ','t','i','m','e','o','u','t',' ','\x0f','s','e','n','d','.',
/* 0x0d3e1 = "VERR_X509_GETTING_EXTENSION_FROM_CERT" */
    '\x01','\xb7','G','E','T','T','I','N','G','_','E','X','T','E','N','S','I','O','N','_','F','R','O','M','_','C','E','R','T',
/* 0x0d3fe = "An invalid LUN specification was given." */
    'A','n',' ','\x8f','L','U','N',' ','s','p','e','c','i','f','i','c','a','t','i','o','n',' ','\x11','g','i','v','e','n','.',
/* 0x0d41b = "Hit the global allocation limit." */
    'H','i','t',' ','\x02','g','l','o','b','a','l',' ','a','l','l','o','c','a','t','i','o','n',' ','l','i','m','i','t','.',
/* 0x0d438 = "The specified address range wraps around." */
    '\x03','\x18','a','d','d','r','e','s','s',' ','r','a','n','g','e',' ','w','r','a','p','s',' ','a','r','o','u','n','d','.',
/* 0x0d455 = "Import module ordinal is out of bounds." */
    '\xc3','m','o','d','u','l','e',' ','o','r','d','i','n','a','l',' ','\x0b','o','u','t',' ','\x15','b','o','u','n','d','s','.',
/* 0x0d472 = "VERR_XAR_NOT_STREAMBLE_ELEMENT_ORDER" */
    '\x01','X','A','R','_','\x06','S','T','R','E','A','M','B','L','E','_','E','L','E','M','E','N','T','_','O','R','D','E','R',
/* 0x0d48f = "VERR_SHCLPB_MAX_TRANSFERS_REACHED" */
    '\x01','S','H','C','L','P','B','_','M','A','X','_','T','R','A','N','S','F','E','R','S','_','R','E','A','C','H','E','D',
/* 0X0d4ac = "Destination address required." */
    'e','s','t','i','n','a','t','i','o','n',' ','a','d','d','r','e','s','s',' ','r','e','q','u','i','r','e','d','.',
/* 0x0d4c8 = "VFS chain element takes a directory (dir) object as input." */
    '\x8d',' ','\xa1','\x5c','t','a','k','e','s',' ','a',' ','\x25','(','d','i','r',')',' ','\xa8','a','s',' ','i','n','p','u','t','.',
/* 0x0d4e5 = "Recompiler: No host register available for variables." */
    '\x13','\xdf','h','o','s','t',' ','\xeb','a','v','a','i','l','a','b','l','e',' ','\x10','v','a','r','i','a','b','l','e','s','.',
/* 0x0d502 = "The spill file grew larger than 4GB." */
    '\x03','s','p','i','l','l',' ','\x1f','g','r','e','w',' ','l','a','r','g','e','r',' ','t','h','a','n',' ','4','G','B','.',
/* 0x0d51f = "Final OpenSSL PKIX signing failed." */
    'F','i','n','a','l',' ','O','p','e','n','S','S','L',' ','P','K','I','X',' ','s','i','g','n','i','n','g',' ','\x7b',
/* 0x0d53b = "The guest LDT selector is out of bounds." */
    '\x03','\xbb','L','D','T',' ','s','e','l','e','c','t','o','r',' ','\x0b','o','u','t',' ','\x15','b','o','u','n','d','s','.',
/* 0x0d557 = "Image Verification Failure: Error allocating memory for state data." */
    'I','m','a','g','e',' ','\x0d','\x12','\xc0','a','l','l','o','c','a','t','i','n','g',' ','\x86','\x10','\xca','d','a','t','a','.',
/* 0x0d573 = "Severely compromised digest." */
    'S','e','v','e','r','e','l','y',' ','c','o','m','p','r','o','m','i','s','e','d',' ','d','i','g','e','s','t','.',
/* 0x0d58f = "Syntax error - incorrect argument type." */
    '\xfa','\x09','-',' ','i','n','c','o','r','r','e','c','t',' ','a','r','g','u','m','e','n','t',' ','t','y','p','e','.',
/* 0x0d5ab = "VINF_IOMMU_ADDR_TRANSLATION_DISABLED" */
    '\x0e','\xfd','_','A','D','D','R','_','T','R','A','N','S','L','A','T','I','O','N','_','D','I','S','A','B','L','E','D',
/* 0x0d5c7 = "Guest mappings are disabled." */
    'G','u','e','s','t',' ','m','a','p','p','i','n','g','s',' ','a','r','e',' ','d','i','s','a','b','l','e','d','.',
/* 0x0d5e3 = "VERR_CR_SPC_EXPECTED_PE_IMAGE_DATA" */
    '\x01','\x24','S','P','C','_','E','X','P','E','C','T','E','D','_','P','E','_','I','M','A','G','E','_','D','A','T','A',
/* 0x0d5ff = "VERR_CR_CIPHER_OSSL_ENCRYPT_INIT_FAILED" */
    '\x01','\x24','C','I','P','H','E','R','_','O','S','S','L','_','E','N','C','R','Y','P','T','_','I','N','I','T','_','\x17',
/* 0x0d61b = "Too many I/O port registrations." */
    'T','o','o',' ','\xb4','I','/','O',' ','p','o','r','t',' ','r','e','g','i','s','t','r','a','t','i','o','n','s','.',
/* 0x0d637 = "Invalid entry in the device registration structure." */
    '\x0c','\xc8','\x0f','\x02','\xa3','r','e','g','i','s','t','r','a','t','i','o','n',' ','s','t','r','u','c','t','u','r','e','.',
/* 0x0d653 = "Invalid format of managed object reference." */
    '\x0c','f','o','r','m','a','t',' ','\x15','m','a','n','a','g','e','d',' ','\xa8','r','e','f','e','r','e','n','c','e','.',
/* 0x0d66f = "No validation entry in the boot catalog." */
    '\xdf','v','a','l','i','d','a','t','i','o','n',' ','\xc8','\x0f','\x02','b','o','o','t',' ','c','a','t','a','l','o','g','.',
/* 0x0d68b = "The specified disk or diskette cannot be accessed." */
    '\x03','\x18','d','i','s','k',' ','\xa9','d','i','s','k','e','t','t','e',' ','\xd1','\xa7','a','c','c','e','s','s','e','d','.',
/* 0x0d6a7 = "The MMIO range specified for removal was invalid." */
    '\x03','\xd3',' ','r','a','n','g','e',' ','\x18','\x10','r','e','m','o','v','a','l',' ','\x11','i','n','v','a','l','i','d','.',
/* 0x0d6c3 = "The DTB being parsed has an invalid header magic." */
    '\x03','D','T','B',' ','b','e','i','n','g',' ','p','a','r','s','e','d',' ','\x5e','\x87','\x8f','\xb3','m','a','g','i','c','.',
/* 0x0d6df = "Unexpected NULL pointer to left subtree." */
    '\x94','N','U','L','L',' ','p','o','i','n','t','e','r',' ','\x0a','l','e','f','t',' ','s','u','b','t','r','e','e','.',
/* 0x0d6fb = "Get register caller must flush the TLB." */
    'G','e','t',' ','\xeb','c','a','l','l','e','r',' ','m','u','s','t',' ','f','l','u','s','h',' ','\x02','T','L','B','.',
/* 0x0d717 = "Image Verification Failure: Internal error in signature parser." */
    'I','m','a','g','e',' ','\x0d','\x12','\x07','\x09','\x0f','s','i','g','n','a','t','u','r','e',' ','p','a','r','s','e','r','.',
/* 0x0d733 = "APIC did not accept the interrupt." */
    'A','P','I','C',' ','d','i','d',' ','\x08','a','c','c','e','p','t',' ','\x02','i','n','t','e','r','r','u','p','t','.',
/* 0x0d74f = "Unable to establish trusted of VM process (3)." */
    '\xe0','\x0a','e','s','t','a','b','l','i','s','h',' ','t','r','u','s','t','e','d',' ','\x15','\xcd',' ','\x92','(','3',')','.',
/* 0x0d76b = "VERR_DBGF_BP_INT3_ADD_TRIES_REACHED" */
    '\x01','\xb9','_','B','P','_','I','N','T','3','_','A','D','D','_','T','R','I','E','S','_','R','E','A','C','H','E','D',
/* 0x0d787 = "VERR_GVMM_NOT_ALL_EMTS_DEREGISTERED" */
    '\x01','G','V','M','M','_','\x06','A','L','L','_','E','M','T','S','_','D','E','R','E','G','I','S','T','E','R','E','D',
/* 0x0d7a3 = "The length of the file name is out of range." */
    '\x03','l','e','n','g','t','h',' ','\x15','\x02','\x1f','n','a','m','e',' ','\x0b','o','u','t',' ','\x15','r','a','n','g','e','.',
/* 0x0d7bf = "Incorrect version numbers in the header." */
    'I','n','c','o','r','r','e','c','t',' ','\xcf','n','u','m','b','e','r','s',' ','\x0f','\x02','h','e','a','d','e','r','.',
/* 0x0d7db = "Bogus reference to freed node." */
    'B','o','g','u','s',' ','r','e','f','e','r','e','n','c','e',' ','\x0a','f','r','e','e','d',' ','n','o','d','e','.',
/* 0x0d7f7 = "VERR_ISOMK_BOOT_CAT_NO_VALIDATION_ENTRY" */
    '\x01','\x22','B','O','O','T','_','C','A','T','_','\x60','V','A','L','I','D','A','T','I','O','N','_','E','N','T','R','Y',
/* 0x0d813 = "Too deep walk during lookup." */
    'T','o','o',' ','d','e','e','p',' ','w','a','l','k',' ','d','u','r','i','n','g',' ','l','o','o','k','u','p','.',
/* 0x0d82f = "VERR_LDRVI_PAGE_HASH_TAB_NOT_STRICTLY_SORTED" */
    '\x01','\xf4','\xdc','H','A','S','H','_','T','A','B','_','\x06','S','T','R','I','C','T','L','Y','_','S','O','R','T','E','D',
/* 0x0d84b = "Invalid entry in the driver registration structure." */
    '\x0c','\xc8','\x0f','\x02','\xc5','r','e','g','i','s','t','r','a','t','i','o','n',' ','s','t','r','u','c','t','u','r','e','.',
/* 0x0d867 = "An operation caused a nested-guest VM-exit." */
    'A','n',' ','\x96','c','a','u','s','e','d',' ','a',' ','n','e','s','t','e','d','-','\xbb','\xcd','-','e','x','i','t','.',
/* 0x0d883 = "VERR_TAR_NON_DIR_ENDS_WITH_SLASH" */
    '\x01','T','A','R','_','N','O','N','_','D','I','R','_','E','N','D','S','_','W','I','T','H','_','S','L','A','S','H',
/* 0x0d89f = "The filename or extension is too long." */
    '\x03','f','i','l','e','n','a','m','e',' ','\xa9','e','x','t','e','n','s','i','o','n',' ','\x0b','\x9e','l','o','n','g','.',
/* 0x0d8bb = "VERR_ISOMK_IMPORT_BOOT_CAT_DEF_ENTRY_INVALID_FLAGS" */
    '\x01','\x22','\x83','B','O','O','T','_','C','A','T','_','D','E','F','_','E','N','T','R','Y','_','\x05','F','L','A','G','S',
/* 0x0d8d7 = "Encountered a section type that\'s not known to the loader." */
    '\xa5','a',' ','\xdb','\xf3','t','h','a','t','\'','s',' ','\x08','k','n','o','w','n',' ','\x0a','\x02','l','o','a','d','e','r','.',
/* 0x0d8f3 = "Import ISO contains a directory with a bad record length." */
    '\xc3','\xc1',' ','\x8a','a',' ','\x25','\x80','a',' ','b','a','d',' ','r','e','c','o','r','d',' ','l','e','n','g','t','h','.',
/* 0x0d90f = "VERR_MAIN_CONFIG_CONSTRUCTOR_IPE" */
    '\x01','M','A','I','N','_','C','O','N','F','I','G','_','C','O','N','S','T','R','U','C','T','O','R','_','I','P','E',
/* 0x0d92b = "The critical section being deleted was not found." */
    '\x03','c','r','i','t','i','c','a','l',' ','\xdb','b','e','i','n','g',' ','d','e','l','e','t','e','d',' ','\x11','\x08','\x89',
/* 0x0d947 = "VERR_INTNET_FLT_LOWER_LINK_ID_NOT_FOUND" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','L','O','W','E','R','_','L','I','N','K','_','I','D','_','\x06','\x2a',
/* 0x0d963 = "VERR_IOSMK_IMPORT_PRIMARY_VOL_DESC_VER" */
    '\x01','I','O','S','M','K','_','\x83','P','R','I','M','A','R','Y','_','V','O','L','_','D','E','S','C','_','V','E','R',
/* 0x0d97f = "VERR_HARDAVL_INDEX_OUT_OF_BOUNDS" */
    '\x01','H','A','R','D','A','V','L','_','I','N','D','E','X','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x0d99b = "Unexpected MSR in the auto-load/store area." */
    '\x94','M','S','R',' ','\x0f','\x02','a','u','t','o','-','l','o','a','d','/','s','t','o','r','e',' ','a','r','e','a','.',
/* 0x0d9b7 = "The media is locked and cannot be unmounted." */
    '\x03','m','e','d','i','a',' ','\x0b','l','o','c','k','e','d',' ','\x9a','\xd1','\xa7','u','n','m','o','u','n','t','e','d','.',
/* 0x0d9d3 = "Failed to allocate temporary memory." */
    '\x8b','\x0a','a','l','l','o','c','a','t','e',' ','t','e','m','p','o','r','a','r','y',' ','m','e','m','o','r','y','.',
/* 0x0d9ef = "Unable to establish trusted of VM process (1)." */
    '\xe0','\x0a','e','s','t','a','b','l','i','s','h',' ','t','r','u','s','t','e','d',' ','\x15','\xcd',' ','\x92','(','1',')','.',
/* 0x0da0b = "VERR_URI_INVALID_ESCAPED_UTF8_LEAD_BYTE" */
    '\x01','U','R','I','_','\x05','E','S','C','A','P','E','D','_','U','T','F','8','_','L','E','A','D','_','B','Y','T','E',
/* 0x0da27 = "Invalid unit magic (internal data tag)." */
    '\x0c','u','n','i','t',' ','m','a','g','i','c',' ','(','i','n','t','e','r','n','a','l',' ','\x9d','t','a','g',')','.',
/* 0x0da43 = "Bad symbol table size in Mach-O image." */
    '\x9f','s','y','m','b','o','l',' ','\xb1','s','i','z','e',' ','\x0f','M','a','c','h','-','O',' ','i','m','a','g','e','.',
/* 0x0da5f = "Current session state prohibits operation." */
    'C','u','r','r','e','n','t',' ','s','e','s','s','i','o','n',' ','\xca','p','r','o','h','i','b','i','t','s',' ','\xea',
/* 0x0da7b = "A required header parmaeter was not set." */
    'A',' ','r','e','q','u','i','r','e','d',' ','\xb3','p','a','r','m','a','e','t','e','r',' ','\x11','\x08','s','e','t','.',
/* 0x0da97 = "VERR_SUPDRV_TSC_DELTA_MEASUREMENT_BUSY" */
    '\x01','\x90','T','S','C','_','D','E','L','T','A','_','M','E','A','S','U','R','E','M','E','N','T','_','B','U','S','Y',
/* 0x0dab3 = "VERR_ISOMK_IMPORT_MULTIPLE_JOLIET_VOL_DESCS" */
    '\x01','\x22','\x83','M','U','L','T','I','P','L','E','_','J','O','L','I','E','T','_','V','O','L','_','D','E','S','C','S',
/* 0x0dacf = "A device encountered an unknown configuration value." */
    'A',' ','\xa3','\xaf','\x87','u','n','k','n','o','w','n',' ','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','\xe8',
/* 0x0daeb = "The service was disabled on the host." */
    '\x03','s','e','r','v','i','c','e',' ','\x11','d','i','s','a','b','l','e','d',' ','o','n',' ','\x02','h','o','s','t','.',
/* 0x0db07 = "A driver encountered an unknown configuration value." */
    'A',' ','\xc5','\xaf','\x87','u','n','k','n','o','w','n',' ','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','\xe8',
/* 0x0db23 = "Recompiler: No temporary host register available." */
    '\x13','\xdf','t','e','m','p','o','r','a','r','y',' ','h','o','s','t',' ','\xeb','a','v','a','i','l','a','b','l','e','.',
/* 0x0db3f = "A digest type used in the manifest file isn\'t supported." */
    'A',' ','\xd7','\xf3','u','s','e','d',' ','\x0f','\x02','m','a','n','i','f','e','s','t',' ','\x1f','i','s','n','\'','t',' ','\xa4',
/* 0x0db5b = "The specified field is outside the structure." */
    '\x03','\x18','f','i','e','l','d',' ','\x0b','o','u','t','s','i','d','e',' ','\x02','s','t','r','u','c','t','u','r','e','.',
/* 0x0db77 = "AMD-V bit not set in K6_EFER MSR." */
    'A','M','D','-','V',' ','b','i','t',' ','\x08','s','e','t',' ','\x0f','K','6','_','E','F','E','R',' ','M','S','R','.',
/* 0x0db93 = "Unable to establish trusted of VM process (2)." */
    '\xe0','\x0a','e','s','t','a','b','l','i','s','h',' ','t','r','u','s','t','e','d',' ','\x15','\xcd',' ','\x92','(','2',')','.',
/* 0x0dbaf = "VERR_CR_PKIX_OSSL_D2I_PUBLIC_KEY_FAILED" */
    '\x01','\x24','P','K','I','X','_','O','S','S','L','_','D','2','I','_','P','U','B','L','I','C','_','K','E','Y','_','\x17',
/* 0x0dbcb = "VERR_ISOMK_IMPORT_ROOT_DIR_WITHOUT_DIR_FLAG" */
    '\x01','\x22','\x83','R','O','O','T','_','D','I','R','_','W','I','T','H','O','U','T','_','D','I','R','_','F','L','A','G',
/* 0x0dbe7 = "Already aliased to the same page." */
    'A','l','r','e','a','d','y',' ','a','l','i','a','s','e','d',' ','\x0a','\x02','s','a','m','e',' ','p','a','g','e','.',
/* 0x0dc03 = "Generic failure during disassembly." */
    '\xa6','f','a','i','l','u','r','e',' ','d','u','r','i','n','g',' ','d','i','s','a','s','s','e','m','b','l','y','.',
/* 0x0dc1f = "VERR_SUPDRV_TRACER_UMOD_STRTAB_OFF_BAD" */
    '\x01','\x90','T','R','A','C','E','R','_','U','M','O','D','_','S','T','R','T','A','B','_','O','F','F','_','B','A','D',
/* 0x0dc3b = "Shared Clipboard event ID not found." */
    'S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','e','v','e','n','t',' ','I','D',' ','\x08','\x89',
/* 0x0dc57 = "Syntax error - the specified function is not a function." */
    '\xfa','\x09','-',' ','\x02','\x18','f','u','n','c','t','i','o','n',' ','\x0b','\x08','a',' ','f','u','n','c','t','i','o','n','.',
/* 0x0dc73 = "Reason for leaving RZ: Illegal call to ring-3." */
    '\x93','\x10','\x81','R','Z',':',' ','I','l','l','e','g','a','l',' ','c','a','l','l',' ','\x0a','r','i','n','g','-','3','.',
/* 0x0dc8f = "The specified shared page was not actually shared." */
    '\x03','\x18','s','h','a','r','e','d',' ','\xcc','\x11','\x08','a','c','t','u','a','l','l','y',' ','s','h','a','r','e','d','.',
/* 0x0dcab = "Device i/o: General failure." */
    'D','e','v','i','c','e',' ','i','/','o',':',' ','G','e','n','e','r','a','l',' ','f','a','i','l','u','r','e','.',
/* 0x0dcc7 = "Specified access handler was not found." */
    'S','p','e','c','i','f','i','e','d',' ','a','c','c','e','s','s',' ','h','a','n','d','l','e','r',' ','\x11','\x08','\x89',
/* 0x0dce3 = "The saved state file magic was not recognized." */
    '\x03','s','a','v','e','d',' ','\xca','\x1f','m','a','g','i','c',' ','\x11','\x08','r','e','c','o','g','n','i','z','e','d','.',
/* 0x0dcff = "Unable to establish trusted of VM process (4)." */
    '\xe0','\x0a','e','s','t','a','b','l','i','s','h',' ','t','r','u','s','t','e','d',' ','\x15','\xcd',' ','\x92','(','4',')','.',
/* 0x0dd1b = "Recompiler: Variable management internal processing error #13." */
    '\x13','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x16','\x04','\x09','#','1','3','.',
/* 0x0dd37 = "Process Verification Failure: Bad new-header offset in the MZ header." */
    '\x1e','\x0d','\x12','\x9f','n','e','w','-','\xb3','o','f','f','s','e','t',' ','\x0f','\x02','M','Z',' ','h','e','a','d','e','r','.',
/* 0x0dd53 = "Attempt to pause a paused TSC." */
    'A','t','t','e','m','p','t',' ','\x0a','p','a','u','s','e',' ','a',' ','p','a','u','s','e','d',' ','T','S','C','.',
/* 0x0dd6f = "The ELF loader encountered an invalid symbol name offset." */
    '\x03','E','L','F',' ','\xd9','\xaf','\x87','\x8f','s','y','m','b','o','l',' ','n','a','m','e',' ','o','f','f','s','e','t','.',
/* 0x0dd8b = "VERR_FTP_DATA_CONN_LIMIT_REACHED" */
    '\x01','F','T','P','_','D','A','T','A','_','C','O','N','N','_','L','I','M','I','T','_','R','E','A','C','H','E','D',
/* 0x0dda7 = "Not in the correct state for the attempted operation." */
    'N','o','t',' ','\x0f','\x02','c','o','r','r','e','c','t',' ','\xca','\x10','\x02','a','t','t','e','m','p','t','e','d',' ','\xea',
/* 0x0ddc3 = "VERR_SVM_HOST_VM_HSAVE_PA_INVALID" */
    '\x01','S','V','M','_','H','O','S','T','_','\xcd','_','H','S','A','V','E','_','P','A','_','I','N','V','A','L','I','D',
/* 0x0dddf = "Recompiler: Variable management internal processing error #12." */
    '\x13','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x16','\x04','\x09','#','1','2','.',
/* 0x0ddfb = "VERR_CR_CIPHER_OSSL_DECRYPT_INIT_FAILED" */
    '\x01','\x24','C','I','P','H','E','R','_','O','S','S','L','_','D','E','C','R','Y','P','T','_','I','N','I','T','_','\x17',
/* 0x0de17 = "Invalid (malformed) file/path name." */
    '\x0c','(','m','a','l','f','o','r','m','e','d',')',' ','f','i','l','e','/','p','a','t','h',' ','n','a','m','e','.',
/* 0x0de33 = "VERR_JSON_INVALID_UTF16_ESCAPE_SEQUENCE" */
    '\x01','J','S','O','N','_','\x05','U','T','F','1','6','_','E','S','C','A','P','E','_','S','E','Q','U','E','N','C','E',
/* 0x0de4f = "VERR_TM_GIP_UPDATE_INTERVAL_TOO_BIG" */
    '\x01','T','M','_','G','I','P','_','U','P','D','A','T','E','_','I','N','T','E','R','V','A','L','_','\x1a','B','I','G',
/* 0x0de6b = "The fatal variant of VINF_EM_NO_MEMORY." */
    '\x03','f','a','t','a','l',' ','v','a','r','i','a','n','t',' ','\x15','\x0e','E','M','_','\x60','M','E','M','O','R','Y','.',
/* 0x0de87 = "VERR_ISOMK_IMPORT_BOOT_CAT_BAD_VALIDATION_KEYS" */
    '\x01','\x22','\x83','B','O','O','T','_','C','A','T','_','\x1d','V','A','L','I','D','A','T','I','O','N','_','K','E','Y','S',
/* 0x0dea3 = "Recompiler: Variable management internal processing error #11." */
    '\x13','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x16','\x04','\x09','#','1','1','.',
/* 0x0debf = "VERR_CR_X509_TBSCERT_UNIQUE_IDS_REQ_V2" */
    '\x01','\x24','\xb7','T','B','S','C','E','R','T','_','U','N','I','Q','U','E','_','I','D','S','_','R','E','Q','_','V','2',
/* 0x0dedb = "VERR_IPC_RECEIVE_SEND_PF_TIMEOUT" */
    '\x01','I','P','C','_','R','E','C','E','I','V','E','_','S','E','N','D','_','P','F','_','T','I','M','E','O','U','T',
/* 0x0def7 = "VERR_GIM_HYPERCALL_ACCESS_DENIED" */
    '\x01','G','I','M','_','H','Y','P','E','R','C','A','L','L','_','A','C','C','E','S','S','_','D','E','N','I','E','D',
/* 0x0df13 = "VINF_PATM_PENDING_IRQ_AFTER_IRET" */
    '\x0e','P','A','T','M','_','P','E','N','D','I','N','G','_','I','R','Q','_','A','F','T','E','R','_','I','R','E','T',
/* 0x0df2f = "Unable to establish trusted of VM process (5)." */
    '\xe0','\x0a','e','s','t','a','b','l','i','s','h',' ','t','r','u','s','t','e','d',' ','\x15','\xcd',' ','\x92','(','5',')','.',
/* 0x0df4b = "The shared module is already registered." */
    '\x03','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','\x0b','\x7f','r','e','g','i','s','t','e','r','e','d','.',
/* 0x0df67 = "The semaphore has been opened too many times." */
    '\x03','s','e','m','a','p','h','o','r','e',' ','\x5e','\xcb','o','p','e','n','e','d',' ','\x9e','\xb4','t','i','m','e','s','.',
/* 0x0df83 = "Unable to establish trusted of VM process (0)." */
    '\xe0','\x0a','e','s','t','a','b','l','i','s','h',' ','t','r','u','s','t','e','d',' ','\x15','\xcd',' ','\x92','(','0',')','.',
/* 0x0df9f = "VERR_CR_PKIX_OSSL_D2I_KEY_PARAMS_FAILED" */
    '\x01','\x24','P','K','I','X','_','O','S','S','L','_','D','2','I','_','K','E','Y','_','P','A','R','A','M','S','_','\x17',
/* 0x0dfbb = "The ELF loader encountered an unterminated string table." */
    '\x03','E','L','F',' ','\xd9','\xaf','\x87','u','n','t','e','r','m','i','n','a','t','e','d',' ','\xf2','t','a','b','l','e','.',
/* 0x0dfd7 = "VERR_CR_SPC_PEIMAGE_URL_UNEXPECTED" */
    '\x01','\x24','S','P','C','_','P','E','I','M','A','G','E','_','U','R','L','_','U','N','E','X','P','E','C','T','E','D',
/* 0x0dff3 = "VERR_VGA_UNEXPECTED_PCI_REGION_LOAD_CHANGE" */
    '\x01','V','G','A','_','\x88','P','C','I','_','R','E','G','I','O','N','_','L','O','A','D','_','C','H','A','N','G','E',
/* 0x0e00f = "Recompiler: Variable management internal processing error #10." */
    '\x13','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x16','\x04','\x09','#','1','0','.',
/* 0x0e02b = "Encountered an unexpected attribute form." */
    '\xa5','\x87','u','n','e','x','p','e','c','t','e','d',' ','a','t','t','r','i','b','u','t','e',' ','f','o','r','m','.',
/* 0x0e047 = "Unexpected guest mapping conflict detected." */
    '\x94','\xbb','m','a','p','p','i','n','g',' ','c','o','n','f','l','i','c','t',' ','d','e','t','e','c','t','e','d','.',
/* 0x0e063 = "VERR_CR_KEY_ALGO_PARAMS_UNEXPECTED" */
    '\x01','\x24','K','E','Y','_','A','L','G','O','_','P','A','R','A','M','S','_','U','N','E','X','P','E','C','T','E','D',
/* 0x0e07f = "VINF_EM_RAW_EXCEPTION_PRIVILEGED" */
    '\x0e','E','M','_','R','A','W','_','E','X','C','E','P','T','I','O','N','_','P','R','I','V','I','L','E','G','E','D',
/* 0x0e09b = "VERR_CODE_POINT_ENDIAN_INDICATOR" */
    '\x01','C','O','D','E','_','P','O','I','N','T','_','E','N','D','I','A','N','_','I','N','D','I','C','A','T','O','R',
/* 0x0e0b7 = "Error getting a data from the extension." */
    '\xc0','g','e','t','t','i','n','g',' ','a',' ','\x9d','f','r','o','m',' ','\x02','e','x','t','e','n','s','i','o','n','.',
/* 0x0e0d3 = "VINF_EM_PENDING_R3_IOPORT_WRITE" */
    '\x0e','E','M','_','P','E','N','D','I','N','G','_','R','3','_','I','O','P','O','R','T','_','W','R','I','T','E',
/* 0x0e0ee = "VERR_IOM_TOO_MANY_IOPORT_REGISTRATIONS" */
    '\x01','I','O','M','_','\x1a','\xac','I','O','P','O','R','T','_','R','E','G','I','S','T','R','A','T','I','O','N','S',
/* 0x0e109 = "Recompiler: Variable management internal processing error #7." */
    '\x13','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x16','\x04','\x09','#','7','.',
/* 0x0e124 = "Failed to get the delta-adjusted TSC value." */
    '\x8b','\x0a','g','e','t',' ','\x02','d','e','l','t','a','-','a','d','j','u','s','t','e','d',' ','T','S','C',' ','\xe8',
/* 0x0e13f = "VFS chain element expected at least one argument." */
    '\x8d',' ','\xa1','\x5c','\xc9','a','t',' ','l','e','a','s','t',' ','o','n','e',' ','a','r','g','u','m','e','n','t','.',
/* 0x0e15a = "Malformed or invalid file set descriptor location." */
    'M','a','l','f','o','r','m','e','d',' ','\xa9','\x8f','\x1f','s','e','t',' ','\xe3','l','o','c','a','t','i','o','n','.',
/* 0x0e175 = "The provider cannot be the first element." */
    '\x03','p','r','o','v','i','d','e','r',' ','\xd1','\xa7','\x02','f','i','r','s','t',' ','e','l','e','m','e','n','t','.',
/* 0x0e190 = "Recompiler: Variable management internal processing error #3." */
    '\x13','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x16','\x04','\x09','#','3','.',
/* 0x0e1ab = "The URI is too short to be a valid URI." */
    '\x03','U','R','I',' ','\x0b','\x9e','s','h','o','r','t',' ','\x0a','\xa7','a',' ','v','a','l','i','d',' ','U','R','I','.',
/* 0x0e1c6 = "Internal ISO maker error: Read file data probem #3." */
    '\x07','\xc1',' ','m','a','k','e','r',' ','\xd8','R','e','a','d',' ','\x1f','\x9d','p','r','o','b','e','m',' ','#','3','.',
/* 0x0e1e1 = "VERR_HARDAVL_MISALIGNED_POINTER" */
    '\x01','H','A','R','D','A','V','L','_','M','I','S','A','L','I','G','N','E','D','_','P','O','I','N','T','E','R',
/* 0x0e1fc = "VERR_DBG_SEGMENT_INDEX_CONFLICT" */
    '\x01','D','B','G','_','S','E','G','M','E','N','T','_','I','N','D','E','X','_','C','O','N','F','L','I','C','T',
/* 0x0e217 = "Could not recognize the key type." */
    'C','o','u','l','d',' ','\x08','r','e','c','o','g','n','i','z','e',' ','\x02','k','e','y',' ','t','y','p','e','.',
/* 0x0e232 = "VWRN_REST_UNABLE_TO_DECODE_DATE" */
    '\xe6','R','E','S','T','_','U','N','A','B','L','E','_','T','O','_','D','E','C','O','D','E','_','D','A','T','E',
/* 0x0e24d = "VERR_SHCLPB_MAX_OBJECTS_REACHED" */
    '\x01','S','H','C','L','P','B','_','M','A','X','_','O','B','J','E','C','T','S','_','R','E','A','C','H','E','D',
/* 0x0e268 = "Process Verification Failure: There are too many DLLs loaded." */
    '\x1e','\x0d','\x12','T','h','e','r','e',' ','a','r','e',' ','\x9e','\xb4','D','L','L','s',' ','l','o','a','d','e','d','.',
/* 0x0e283 = "VERR_SEM_LV_WRONG_RELEASE_ORDER" */
    '\x01','S','E','M','_','L','V','_','W','R','O','N','G','_','R','E','L','E','A','S','E','_','O','R','D','E','R',
/* 0x0e29e = "VERR_CR_PKCS7_SIGNATURE_VERIFICATION_FAILED" */
    '\x01','\x24','\xe5','S','I','G','N','A','T','U','R','E','_','V','E','R','I','F','I','C','A','T','I','O','N','_','\x17',
/* 0x0e2b9 = "Unable to use the range for a large page." */
    '\xe0','\x0a','u','s','e',' ','\x02','r','a','n','g','e',' ','\x10','a',' ','l','a','r','g','e',' ','p','a','g','e','.',
/* 0x0e2d4 = "The shared module name is too long." */
    '\x03','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','n','a','m','e',' ','\x0b','\x9e','l','o','n','g','.',
/* 0x0e2ef = "VERR_GETOPT_REQUIRED_ARGUMENT_MISSING" */
    '\x01','G','E','T','O','P','T','_','R','E','Q','U','I','R','E','D','_','A','R','G','U','M','E','N','T','_','\xc4',
/* 0x0e30a = "Too long name or link string." */
    'T','o','o',' ','l','o','n','g',' ','n','a','m','e',' ','\xa9','l','i','n','k',' ','s','t','r','i','n','g','.',
/* 0x0e325 = "The event semaphore has already been posted." */
    '\x03','e','v','e','n','t',' ','s','e','m','a','p','h','o','r','e',' ','\x5e','\x7f','\xcb','p','o','s','t','e','d','.',
/* 0x0e340 = "VERR_ISOMK_IMPORT_ROOT_DIR_IS_MULTI_EXTENT" */
    '\x01','\x22','\x83','R','O','O','T','_','D','I','R','_','I','S','_','M','U','L','T','I','_','E','X','T','E','N','T',
/* 0x0e35b = "Internal processing error in the PGM physical handler code." */
    '\x07','\x04','\x09','\x0f','\x02','P','G','M',' ','p','h','y','s','i','c','a','l',' ','h','a','n','d','l','e','r',' ','\x84',
/* 0x0e376 = "The dotted-string representation of an ASN." */
    '\x03','d','o','t','t','e','d','-','\xf2','r','e','p','r','e','s','e','n','t','a','t','i','o','n',' ','\x15','\x87','\xf6',
/* 0x0e391 = "Dataspace manager server not found." */
    'D','a','t','a','s','p','a','c','e',' ','m','a','n','a','g','e','r',' ','s','e','r','v','e','r',' ','\x08','\x89',
/* 0x0e3ac = "More unconsumed data available." */
    'M','o','r','e',' ','u','n','c','o','n','s','u','m','e','d',' ','\x9d','a','v','a','i','l','a','b','l','e','.',
/* 0x0e3c7 = "Recompiler: Variable management internal processing error #2." */
    '\x13','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x16','\x04','\x09','#','2','.',
/* 0x0e3e2 = "Recompiler: Variable management internal processing error #6." */
    '\x13','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x16','\x04','\x09','#','6','.',
/* 0x0e3fd = "Hit a todo in the mach-o loader." */
    'H','i','t',' ','a',' ','t','o','d','o',' ','\x0f','\x02','m','a','c','h','-','o',' ','l','o','a','d','e','r','.',
/* 0x0e418 = "Failed to open semaphore by name - not found." */
    '\x8b','\x0a','o','p','e','n',' ','s','e','m','a','p','h','o','r','e',' ','\xe1','n','a','m','e',' ','-',' ','\x08','\x89',
/* 0x0e433 = "General saved state file integrity error." */
    'G','e','n','e','r','a','l',' ','s','a','v','e','d',' ','\xca','\x1f','i','n','t','e','g','r','i','t','y',' ','\x85',
/* 0x0e44e = "Trying to free a page with an invalid Page ID." */
    'T','r','y','i','n','g',' ','\x0a','f','r','e','e',' ','a',' ','\xcc','\x80','\x87','\x8f','P','a','g','e',' ','I','D','.',
/* 0x0e469 = "VERR_REST_UNABLE_TO_DECODE_DATE" */
    '\x01','R','E','S','T','_','U','N','A','B','L','E','_','T','O','_','D','E','C','O','D','E','_','D','A','T','E',
/* 0x0e484 = "HGCM could not perform requested operation because of an internal error." */
    'H','G','C','M',' ','c','o','u','l','d',' ','\x08','p','e','r','f','o','r','m',' ','\xde','\x96','\x40','\x15','\x87','\x16','\x85',
/* 0x0e49f = "VINF_SSM_VOTE_DONE_DONT_CALL_AGAIN" */
    '\x0e','\xb0','V','O','T','E','_','D','O','N','E','_','D','O','N','T','_','C','A','L','L','_','A','G','A','I','N',
/* 0x0e4ba = "VERR_ISOMK_IMPORT_BOOT_CAT_MISSING_FINAL_OR_TOO_BIG" */
    '\x01','\x22','\x83','B','O','O','T','_','C','A','T','_','\xc4','_','F','I','N','A','L','_','O','R','_','\x1a','B','I','G',
/* 0x0e4d5 = "VERR_VUSB_USB_DEVICE_PERMISSION" */
    '\x01','V','U','S','B','_','U','S','B','_','D','E','V','I','C','E','_','P','E','R','M','I','S','S','I','O','N',
/* 0x0e4f0 = "VERR_AUDIO_STREAM_COULD_NOT_CREATE" */
    '\x01','A','U','D','I','O','_','S','T','R','E','A','M','_','C','O','U','L','D','_','\x06','C','R','E','A','T','E',
/* 0x0e50b = "VINF_IOM_R3_IOPORT_COMMIT_WRITE" */
    '\x0e','I','O','M','_','R','3','_','I','O','P','O','R','T','_','C','O','M','M','I','T','_','W','R','I','T','E',
/* 0x0e526 = "The guest has not setup use of the hypercalls." */
    '\x03','\xbb','\x5e','\x08','s','e','t','u','p',' ','u','s','e',' ','\x15','\x02','h','y','p','e','r','c','a','l','l','s','.',
/* 0x0e541 = "VERR_ISOMK_IMPORT_DOT_DIR_REC_BAD_NAME_LENGTH" */
    '\x01','\x22','\x83','D','O','T','_','D','I','R','_','R','E','C','_','\x1d','N','A','M','E','_','L','E','N','G','T','H',
/* 0x0e55c = "Recompiler: Variable management internal processing error #5." */
    '\x13','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x16','\x04','\x09','#','5','.',
/* 0x0e577 = "VERR_CR_PKCS7_EXPECTED_ONE_SIGNER_INFO" */
    '\x01','\x24','\xe5','E','X','P','E','C','T','E','D','_','O','N','E','_','S','I','G','N','E','R','_','I','N','F','O',
/* 0x0e592 = "Bad iterdata2 (EXEPACK2) data." */
    '\x9f','i','t','e','r','d','a','t','a','2',' ','(','E','X','E','P','A','C','K','2',')',' ','d','a','t','a','.',
/* 0x0e5ad = "Recompiler: Variable management internal processing error #1." */
    '\x13','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x16','\x04','\x09','#','1','.',
/* 0x0e5c8 = "Reason for leaving RC: Unhandled TSS write." */
    '\x93','\x10','\x81','R','C',':',' ','U','n','h','a','n','d','l','e','d',' ','T','S','S',' ','w','r','i','t','e','.',
/* 0x0e5e3 = "VERR_SUP_VP_BAD_SECTION_ALIGNMENT_VALUE" */
    '\x01','\x95','\xbd','\x1d','S','E','C','T','I','O','N','_','A','L','I','G','N','M','E','N','T','_','V','A','L','U','E',
/* 0x0e5fe = "Syntax error - unbalanced parenthesis." */
    '\xfa','\x09','-',' ','u','n','b','a','l','a','n','c','e','d',' ','p','a','r','e','n','t','h','e','s','i','s','.',
/* 0x0e619 = "VERR_VFS_CHAIN_CANNOT_BE_FIRST_ELEMENT" */
    '\x01','\x8d','_','\x8e','C','A','N','N','O','T','_','B','E','_','F','I','R','S','T','_','E','L','E','M','E','N','T',
/* 0x0e634 = "Expression stack underflow." */
    'E','x','p','r','e','s','s','i','o','n',' ','s','t','a','c','k',' ','u','n','d','e','r','f','l','o','w','.',
/* 0x0e64f = "VERR_FDT_DTB_PROP_STRING_NOT_TERMINATED" */
    '\x01','F','D','T','_','D','T','B','_','P','R','O','P','_','\xd5','_','\x06','T','E','R','M','I','N','A','T','E','D',
/* 0x0e66a = "Floating pointer underflow." */
    'F','l','o','a','t','i','n','g',' ','p','o','i','n','t','e','r',' ','u','n','d','e','r','f','l','o','w','.',
/* 0x0e685 = "Recompiler: Register allocator internal processing error #12." */
    '\x13','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x16','\x04','\x09','#','1','2','.',
/* 0x0e6a0 = "VERR_ISOMK_IMPORT_MULTIPLE_EL_TORITO_DESCS" */
    '\x01','\x22','\x83','M','U','L','T','I','P','L','E','_','E','L','_','T','O','R','I','T','O','_','D','E','S','C','S',
/* 0x0e6bb = "VERR_TM_TIMER_QUEUE_CANNOT_GROW" */
    '\x01','T','M','_','T','I','M','E','R','_','Q','U','E','U','E','_','C','A','N','N','O','T','_','G','R','O','W',
/* 0x0e6d6 = "Reason for leaving RC: Unhandled LDT write." */
    '\x93','\x10','\x81','R','C',':',' ','U','n','h','a','n','d','l','e','d',' ','L','D','T',' ','w','r','i','t','e','.',
/* 0x0e6f1 = "Too many partition descriptors." */
    'T','o','o',' ','\xb4','p','a','r','t','i','t','i','o','n',' ','d','e','s','c','r','i','p','t','o','r','s','.',
/* 0x0e70c = "Unresolved (unknown) file i/o error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','\x1f','i','/','o',' ','\x85',
/* 0x0e727 = "Bad VTG probe location record." */
    '\x9f','V','T','G',' ','p','r','o','b','e',' ','l','o','c','a','t','i','o','n',' ','r','e','c','o','r','d','.',
/* 0x0e742 = "VERR_AUDIO_NO_FREE_OUTPUT_STREAMS" */
    '\x01','A','U','D','I','O','_','\x60','F','R','E','E','_','O','U','T','P','U','T','_','S','T','R','E','A','M','S',
/* 0x0e75d = "Reason for leaving RC: Unhandled IDT write." */
    '\x93','\x10','\x81','R','C',':',' ','U','n','h','a','n','d','l','e','d',' ','I','D','T',' ','w','r','i','t','e','.',
/* 0x0e778 = "The ELF loader encountered an invalid relocation offset." */
    '\x03','E','L','F',' ','\xd9','\xaf','\x87','\x8f','r','e','l','o','c','a','t','i','o','n',' ','o','f','f','s','e','t','.',
/* 0x0e793 = "Recompiler: Register allocator internal processing error #11." */
    '\x13','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x16','\x04','\x09','#','1','1','.',
/* 0x0e7ae = "VERR_ISOFS_INCOMPLETE_PART_MAP_TABLE" */
    '\x01','\x97','I','N','C','O','M','P','L','E','T','E','_','P','A','R','T','_','M','A','P','_','T','A','B','L','E',
/* 0x0e7c9 = "Process Verification Failure: The process has more than one thread." */
    '\x1e','\x0d','\x12','\x03','\x92','\x5e','m','o','r','e',' ','t','h','a','n',' ','o','n','e',' ','t','h','r','e','a','d','.',
/* 0x0e7e4 = "VERR_REST_WRONG_JSON_TYPE_FOR_DATE" */
    '\x01','R','E','S','T','_','W','R','O','N','G','_','J','S','O','N','_','\xb5','_','F','O','R','_','D','A','T','E',
/* 0x0e7ff = "Internal ISO maker error: Read file data probem #2." */
    '\x07','\xc1',' ','m','a','k','e','r',' ','\xd8','R','e','a','d',' ','\x1f','\x9d','p','r','o','b','e','m',' ','#','2','.',
/* 0x0e81a = "Internal ISO maker error: Unexpected empty component." */
    '\x07','\xc1',' ','m','a','k','e','r',' ','\xd8','\x94','e','m','p','t','y',' ','c','o','m','p','o','n','e','n','t','.',
/* 0x0e835 = "VERR_PATH_DOES_NOT_START_WITH_ROOT" */
    '\x01','P','A','T','H','_','D','O','E','S','_','\x06','S','T','A','R','T','_','W','I','T','H','_','R','O','O','T',
/* 0x0e850 = "VERR_SUPDRV_VTG_ONLY_ONCE_PER_SESSION" */
    '\x01','\x90','V','T','G','_','O','N','L','Y','_','O','N','C','E','_','P','E','R','_','S','E','S','S','I','O','N',
/* 0x0e86b = "VERR_PGM_HANDLER_PHYSICAL_CONFLICT" */
    '\x01','\x8c','H','A','N','D','L','E','R','_','P','H','Y','S','I','C','A','L','_','C','O','N','F','L','I','C','T',
/* 0x0e886 = "No memory available for page table or page directory." */
    '\xdf','\x86','a','v','a','i','l','a','b','l','e',' ','\x10','\xcc','\xb1','\xa9','\xcc','d','i','r','e','c','t','o','r','y','.',
/* 0x0e8a1 = "VERR_SUP_VP_NT_QI_PROCESS_DBG_PORT_ERROR" */
    '\x01','\x95','\xbd','N','T','_','Q','I','_','P','R','O','C','E','S','S','_','D','B','G','_','P','O','R','T','_','\x1b',
/* 0x0e8bc = "VERR_IOQUEUE_HANDLE_NOT_REGISTERED" */
    '\x01','I','O','Q','U','E','U','E','_','H','A','N','D','L','E','_','\x06','R','E','G','I','S','T','E','R','E','D',
/* 0x0e8d7 = "VERR_TAR_MALFORMED_GNU_LONGXXXX" */
    '\x01','T','A','R','_','M','A','L','F','O','R','M','E','D','_','G','N','U','_','L','O','N','G','X','X','X','X',
/* 0x0e8f2 = "VERR_SUP_VP_NT_QI_PROCESS_IMG_INFO_ERROR" */
    '\x01','\x95','\xbd','N','T','_','Q','I','_','P','R','O','C','E','S','S','_','I','M','G','_','I','N','F','O','_','\x1b',
/* 0x0e90d = "VDI: Invalid image file header: invalid signature." */
    'V','D','I',':',' ','\x0c','\x26','\x1f','h','e','a','d','e','r',':',' ','\x8f','s','i','g','n','a','t','u','r','e','.',
/* 0x0e928 = "Constructed string type not implemented." */
    'C','o','n','s','t','r','u','c','t','e','d',' ','\xf2','\xf3','\x08','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x0e943 = "Reason for leaving RZ: Emulate instruction." */
    '\x93','\x10','\x81','R','Z',':',' ','E','m','u','l','a','t','e',' ','i','n','s','t','r','u','c','t','i','o','n','.',
/* 0x0e95e = "Expected URI using the \'file:\' scheme." */
    '\xb8','U','R','I',' ','u','s','i','n','g',' ','\x02','\'','f','i','l','e',':','\'',' ','s','c','h','e','m','e','.',
/* 0x0e979 = "Image Verification Failure: Error reading file for hashing." */
    'I','m','a','g','e',' ','\x0d','\x12','\xc0','r','e','a','d','i','n','g',' ','\x1f','\x10','h','a','s','h','i','n','g','.',
/* 0x0e994 = "VERR_SHCLPB_LIST_HANDLE_INVALID" */
    '\x01','S','H','C','L','P','B','_','L','I','S','T','_','H','A','N','D','L','E','_','I','N','V','A','L','I','D',
/* 0x0e9af = "Failed to calculate the TSC frequency." */
    '\x8b','\x0a','c','a','l','c','u','l','a','t','e',' ','\x02','T','S','C',' ','f','r','e','q','u','e','n','c','y','.',
/* 0x0e9ca = "Recompiler: Register allocator internal processing error #10." */
    '\x13','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x16','\x04','\x09','#','1','0','.',
/* 0x0e9e5 = "Asynchronous I/O request finished." */
    'A','s','y','n','c','h','r','o','n','o','u','s',' ','I','/','O',' ','\xaa','f','i','n','i','s','h','e','d','.',
/* 0x0ea00 = "Unhandled #DB in hypervisor code." */
    'U','n','h','a','n','d','l','e','d',' ','#','D','B',' ','\x0f','h','y','p','e','r','v','i','s','o','r',' ','\x84',
/* 0x0ea1b = "VERR_CR_SPC_PEIMAGE_DATA_NOT_PRESENT" */
    '\x01','\x24','S','P','C','_','P','E','I','M','A','G','E','_','D','A','T','A','_','\x06','P','R','E','S','E','N','T',
/* 0x0ea36 = "Recompiler: Variable management internal processing error #8." */
    '\x13','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x16','\x04','\x09','#','8','.',
/* 0x0ea51 = "Maximum number of mappings reached." */
    'M','a','x','i','m','u','m',' ','\xfb','\x15','m','a','p','p','i','n','g','s',' ','r','e','a','c','h','e','d','.',
/* 0x0ea6c = "OpenSSL failed to clone the digest algorithm context." */
    'O','p','e','n','S','S','L',' ','\x99','\x0a','c','l','o','n','e',' ','\x02','\xd7','\xd4','c','o','n','t','e','x','t','.',
/* 0x0ea87 = "VERR_REST_RESPONSE_CONTENT_TYPE_NOT_SUPPORTED" */
    '\x01','R','E','S','T','_','R','E','S','P','O','N','S','E','_','C','O','N','T','E','N','T','_','\xb5','_','\x06','\x82',
/* 0x0eaa2 = "Recompiler: Register allocator internal processing error #13." */
    '\x13','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x16','\x04','\x09','#','1','3','.',
/* 0x0eabd = "VERR_LDRELF_INVALID_SYMBOL_NAME_OFFSET" */
    '\x01','L','D','R','E','L','F','_','\x05','S','Y','M','B','O','L','_','N','A','M','E','_','O','F','F','S','E','T',
/* 0x0ead8 = "Invalid image relative virtual address." */
    '\x0c','\x26','r','e','l','a','t','i','v','e',' ','v','i','r','t','u','a','l',' ','a','d','d','r','e','s','s','.',
/* 0x0eaf3 = "VERR_LDR_DUPLICATE_SEGMENT_NAME" */
    '\x01','L','D','R','_','D','U','P','L','I','C','A','T','E','_','S','E','G','M','E','N','T','_','N','A','M','E',
/* 0x0eb0e = "Invalid CPUMCPU offset in MSR range." */
    '\x0c','C','P','U','M','C','P','U',' ','o','f','f','s','e','t',' ','\x0f','M','S','R',' ','r','a','n','g','e','.',
/* 0x0eb29 = "The requested feature is not supported by NEM." */
    '\x03','\xde','f','e','a','t','u','r','e',' ','\x0b','\x08','s','u','p','p','o','r','t','e','d',' ','\xe1','N','E','M','.',
/* 0x0eb44 = "Unresolved (unknown) device i/o error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','\xa3','i','/','o',' ','\x85',
/* 0x0eb5f = "NEM failed to unmap page(s) into the VM." */
    '\xee',' ','\x99','\x0a','u','n','m','a','p',' ','p','a','g','e','(','s',')',' ','i','n','t','o',' ','\x02','V','M','.',
/* 0x0eb7a = "The specified at reset handler wasn\'t found." */
    '\x03','\x18','a','t',' ','r','e','s','e','t',' ','h','a','n','d','l','e','r',' ','w','a','s','n','\'','t',' ','\x89',
/* 0x0eb95 = "Invalid environment variable name." */
    '\x0c','e','n','v','i','r','o','n','m','e','n','t',' ','v','a','r','i','a','b','l','e',' ','n','a','m','e','.',
/* 0x0ebb0 = "VERR_LDRMACHO_MIXED_DEBUG_SECTION_FLAGS" */
    '\x01','\xe9','M','I','X','E','D','_','D','E','B','U','G','_','S','E','C','T','I','O','N','_','F','L','A','G','S',
/* 0x0ebcb = "VRPD receives a packet that is not supported." */
    'V','R','P','D',' ','r','e','c','e','i','v','e','s',' ','a',' ','p','a','c','k','e','t',' ','\xad','\x0b','\x08','\xa4',
/* 0x0ebe6 = "Invalid UTF-8 encoding in the response." */
    '\x0c','U','T','F','-','8',' ','e','n','c','o','d','i','n','g',' ','\x0f','\x02','r','e','s','p','o','n','s','e','.',
/* 0x0ec01 = "VERR_INTNET_FLT_VNIC_LINK_ID_NOT_FOUND" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','V','N','I','C','_','L','I','N','K','_','I','D','_','\x06','\x2a',
/* 0x0ec1c = "Recompiler: Variable management internal processing error #9." */
    '\x13','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x16','\x04','\x09','#','9','.',
/* 0x0ec37 = "Buffer too small to save result." */
    'B','u','f','f','e','r',' ','\x9e','s','m','a','l','l',' ','\x0a','s','a','v','e',' ','r','e','s','u','l','t','.',
/* 0x0ec52 = "Error while parsing UUID string." */
    '\xc0','w','h','i','l','e',' ','p','a','r','s','i','n','g',' ','U','U','I','D',' ','s','t','r','i','n','g','.',
/* 0x0ec6d = "VWRN_GSTCTL_OBJECTSTATE_CHANGED" */
    '\xe6','G','S','T','C','T','L','_','O','B','J','E','C','T','S','T','A','T','E','_','C','H','A','N','G','E','D',
/* 0x0ec88 = "VERR_ASN1_CURSOR_BAD_INDEFINITE_LENGTH" */
    '\x01','\xa2','C','U','R','S','O','R','_','\x1d','I','N','D','E','F','I','N','I','T','E','_','L','E','N','G','T','H',
/* 0x0eca3 = "Trying to free a page that isn\'t RAM." */
    'T','r','y','i','n','g',' ','\x0a','f','r','e','e',' ','a',' ','\xcc','\xad','i','s','n','\'','t',' ','R','A','M','.',
/* 0x0ecbe = "VERR_GMM_MEMORY_RESERVATION_DECLINED" */
    '\x01','G','M','M','_','\xb6','_','R','E','S','E','R','V','A','T','I','O','N','_','D','E','C','L','I','N','E','D',
/* 0x0ecd9 = "VINF_PDM_MEDIAEX_IOREQ_IN_PROGRESS" */
    '\x0e','\x7d','M','E','D','I','A','E','X','_','I','O','R','E','Q','_','I','N','_','P','R','O','G','R','E','S','S',
/* 0x0ecf4 = "Internal ISO maker error: Read file data probem #1." */
    '\x07','\xc1',' ','m','a','k','e','r',' ','\xd8','R','e','a','d',' ','\x1f','\x9d','p','r','o','b','e','m',' ','#','1','.',
/* 0x0ed0f = "Internal error obtaining the GVMM instance." */
    '\x07','\x09','o','b','t','a','i','n','i','n','g',' ','\x02','G','V','M','M',' ','i','n','s','t','a','n','c','e','.',
/* 0x0ed2a = "Recompiler: Variable management internal processing error #4." */
    '\x13','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x16','\x04','\x09','#','4','.',
/* 0x0ed45 = "Generic object was destroyed by the call status." */
    '\xa6','\xa8','\x11','d','e','s','t','r','o','y','e','d',' ','\xe1','\x02','c','a','l','l',' ','s','t','a','t','u','s','.',
/* 0x0ed60 = "Reason for leaving RC: Inject a TRPM event." */
    '\x93','\x10','\x81','R','C',':',' ','I','n','j','e','c','t',' ','a',' ','T','R','P','M',' ','e','v','e','n','t','.',
/* 0x0ed7b = "VERR_REST_WRONG_JSON_TYPE_FOR_BOOL" */
    '\x01','R','E','S','T','_','W','R','O','N','G','_','J','S','O','N','_','\xb5','_','F','O','R','_','B','O','O','L',
/* 0x0ed96 = "AMD-V CPU extension in-use." */
    'A','M','D','-','V',' ','C','P','U',' ','e','x','t','e','n','s','i','o','n',' ','i','n','-','u','s','e','.',
/* 0x0edb1 = "VERR_ISOMK_IMPORT_MISALIGNED_MULTI_EXTENT" */
    '\x01','\x22','\x83','M','I','S','A','L','I','G','N','E','D','_','M','U','L','T','I','_','E','X','T','E','N','T',
/* 0x0edcb = "VERR_CR_X509_CPV_UNKNOWN_CRITICAL_EXTENSION" */
    '\x01','\x24','\xb7','C','P','V','_','\x91','C','R','I','T','I','C','A','L','_','E','X','T','E','N','S','I','O','N',
/* 0x0ede5 = "Requires process elevation (UAC)." */
    'R','e','q','u','i','r','e','s',' ','\x92','e','l','e','v','a','t','i','o','n',' ','(','U','A','C',')','.',
/* 0x0edff = "Image Verification Failure: Error reading image headers." */
    'I','m','a','g','e',' ','\x0d','\x12','\xc0','r','e','a','d','i','n','g',' ','\x26','h','e','a','d','e','r','s','.',
/* 0x0ee19 = "Image Verification Failure: Error reading section headers." */
    'I','m','a','g','e',' ','\x0d','\x12','\xc0','r','e','a','d','i','n','g',' ','\xdb','h','e','a','d','e','r','s','.',
/* 0x0ee33 = "VERR_FDT_DTB_HDR_MAGIC_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','H','D','R','_','M','A','G','I','C','_','I','N','V','A','L','I','D',
/* 0x0ee4d = "VERR_GMM_ATTEMPT_TO_FREE_TOO_MUCH" */
    '\x01','G','M','M','_','A','T','T','E','M','P','T','_','T','O','_','F','R','E','E','_','\x1a','M','U','C','H',
/* 0x0ee67 = "VERR_HARDAVL_TRAVERSED_TOO_MANY_NODES" */
    '\x01','H','A','R','D','A','V','L','_','T','R','A','V','E','R','S','E','D','_','\x1a','\xac','N','O','D','E','S',
/* 0x0ee81 = "Unrecoverable error: lock was lost." */
    'U','n','r','e','c','o','v','e','r','a','b','l','e',' ','\xd8','l','o','c','k',' ','\x11','l','o','s','t','.',
/* 0x0ee9b = "VERR_VMX_VMCS_FIELD_CACHE_INVALID" */
    '\x01','\xe2','V','M','C','S','_','F','I','E','L','D','_','C','A','C','H','E','_','I','N','V','A','L','I','D',
/* 0x0eeb5 = "VERR_NET_DEST_ADDRESS_REQUIRED" */
    '\x01','N','E','T','_','D','E','S','T','_','A','D','D','R','E','S','S','_','R','E','Q','U','I','R','E','D',
/* 0x0eecf = "Internal processing error in the debug module reader code." */
    '\x07','\x04','\x09','\x0f','\x02','d','e','b','u','g',' ','m','o','d','u','l','e',' ','r','e','a','d','e','r',' ','\x84',
/* 0x0eee9 = "The GVM is out of VM handle space." */
    '\x03','G','V','M',' ','\x0b','o','u','t',' ','\x15','\xcd',' ','h','a','n','d','l','e',' ','s','p','a','c','e','.',
/* 0x0ef03 = "VERR_SUP_VP_NOT_SIGNED_WITH_BUILD_CERT" */
    '\x01','\x95','\xbd','\x06','S','I','G','N','E','D','_','W','I','T','H','_','B','U','I','L','D','_','C','E','R','T',
/* 0x0ef1d = "Requested service does not exist." */
    'R','e','q','u','e','s','t','e','d',' ','s','e','r','v','i','c','e',' ','\xb2','\x08','e','x','i','s','t','.',
/* 0x0ef37 = "The specified string / bytes buffer was to small." */
    '\x03','\x18','\xf2','/',' ','b','y','t','e','s',' ','b','u','f','f','e','r',' ','\x11','\x0a','s','m','a','l','l','.',
/* 0x0ef51 = "VERR_LDRELF_NO_SYMBOL_OR_NO_STRING_TABS" */
    '\x01','L','D','R','E','L','F','_','\x60','S','Y','M','B','O','L','_','O','R','_','\x60','\xd5','_','T','A','B','S',
/* 0x0ef6b = "The CRC of the saved state file did not match." */
    '\x03','C','R','C',' ','\x15','\x02','s','a','v','e','d',' ','\xca','\x1f','d','i','d',' ','\x08','m','a','t','c','h','.',
/* 0x0ef85 = "VERR_INTNET_INCOMPATIBLE_TRUNK" */
    '\x01','I','N','T','N','E','T','_','I','N','C','O','M','P','A','T','I','B','L','E','_','T','R','U','N','K',
/* 0x0ef9f = "VINF_IEM_REEXEC_FINISH_WITH_FLAGS" */
    '\x0e','\x9c','R','E','E','X','E','C','_','F','I','N','I','S','H','_','W','I','T','H','_','F','L','A','G','S',
/* 0x0efb9 = "VERR_CR_PKIX_OSSL_VERIFY_FINAL_FAILED" */
    '\x01','\x24','P','K','I','X','_','O','S','S','L','_','V','E','R','I','F','Y','_','F','I','N','A','L','_','\x17',
/* 0x0efd3 = "Unable to switch due to invalid host state." */
    '\xe0','\x0a','s','w','i','t','c','h',' ','d','u','e',' ','\x0a','\x8f','h','o','s','t',' ','s','t','a','t','e','.',
/* 0x0efed = "VT-x VMCS launch state invalid." */
    'V','T','-','x',' ','V','M','C','S',' ','l','a','u','n','c','h',' ','\xca','i','n','v','a','l','i','d','.',
/* 0x0f007 = "Recording initialization failed." */
    'R','e','c','o','r','d','i','n','g',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','\x7b',
/* 0x0f021 = "VERR_VFS_CHAIN_EXPECTED_PROVIDER_NAME" */
    '\x01','\x8d','_','\x8e','E','X','P','E','C','T','E','D','_','P','R','O','V','I','D','E','R','_','N','A','M','E',
/* 0x0f03b = "Name is not unique on the network." */
    'N','a','m','e',' ','\x0b','\x08','u','n','i','q','u','e',' ','o','n',' ','\x02','n','e','t','w','o','r','k','.',
/* 0x0f055 = "VERR_SUP_VP_IMAGE_CHARECTERISTICS_MISMATCH" */
    '\x01','\x95','\xbd','I','M','A','G','E','_','C','H','A','R','E','C','T','E','R','I','S','T','I','C','S','_','\x19',
/* 0x0f06f = "VERR_LDRELF_UNTERMINATED_STRING_TAB" */
    '\x01','L','D','R','E','L','F','_','U','N','T','E','R','M','I','N','A','T','E','D','_','\xd5','_','T','A','B',
/* 0x0f089 = "VERR_LDRELF_INVALID_RELOCATION_OFFSET" */
    '\x01','L','D','R','E','L','F','_','\x05','R','E','L','O','C','A','T','I','O','N','_','O','F','F','S','E','T',
/* 0x0f0a3 = "Multiple PE image page hash tables." */
    'M','u','l','t','i','p','l','e',' ','P','E',' ','\x26','\xcc','h','a','s','h',' ','t','a','b','l','e','s','.',
/* 0x0f0bd = "VINF_AUDIO_MORE_DATA_AVAILABLE" */
    '\x0e','A','U','D','I','O','_','M','O','R','E','_','D','A','T','A','_','A','V','A','I','L','A','B','L','E',
/* 0x0f0d7 = "HM returned in the wrong state." */
    'H','M',' ','r','e','t','u','r','n','e','d',' ','\x0f','\x02','w','r','o','n','g',' ','s','t','a','t','e','.',
/* 0x0f0f1 = "Generic debugger command failure." */
    '\xa6','d','e','b','u','g','g','e','r',' ','c','o','m','m','a','n','d',' ','f','a','i','l','u','r','e','.',
/* 0x0f10b = "VERR_SERIALPORT_BREAK_DETECTED" */
    '\x01','S','E','R','I','A','L','P','O','R','T','_','B','R','E','A','K','_','D','E','T','E','C','T','E','D',
/* 0x0f125 = "VERR_DWARF_BAD_LINE_NUMBER_HEADER" */
    '\x01','D','W','A','R','F','_','\x1d','L','I','N','E','_','N','U','M','B','E','R','_','H','E','A','D','E','R',
/* 0x0f13f = "Descriptor tag is all zeros." */
    'D','e','s','c','r','i','p','t','o','r',' ','t','a','g',' ','\x0b','a','l','l',' ','z','e','r','o','s','.',
/* 0x0f159 = "VERR_ISOMK_SYMLINK_SUPPORT_DISABLED" */
    '\x01','\x22','S','Y','M','L','I','N','K','_','S','U','P','P','O','R','T','_','D','I','S','A','B','L','E','D',
/* 0x0f173 = "Execute one instruction with the recompiler." */
    'E','x','e','c','u','t','e',' ','o','n','e',' ','\xda','\x80','\x02','r','e','c','o','m','p','i','l','e','r','.',
/* 0x0f18d = "Recompiler: Register allocator internal processing error #5." */
    '\x13','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x16','\x04','\x09','#','5','.',
/* 0x0f1a7 = "Recompiler: Register allocator internal processing error #1." */
    '\x13','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x16','\x04','\x09','#','1','.',
/* 0x0f1c1 = "VMDK: Invalid image file header: invalid version." */
    'V','M','D','K',':',' ','\x0c','\x26','\x1f','h','e','a','d','e','r',':',' ','\x8f','v','e','r','s','i','o','n','.',
/* 0x0f1db = "Can\'t move file to another disk." */
    'C','a','n','\'','t',' ','m','o','v','e',' ','\x1f','\x0a','a','n','o','t','h','e','r',' ','d','i','s','k','.',
/* 0x0f1f5 = "VERR_ASN1_CURSOR_TOO_LITTLE_DATA_LEFT" */
    '\x01','\xa2','C','U','R','S','O','R','_','\x1a','L','I','T','T','L','E','_','D','A','T','A','_','L','E','F','T',
/* 0x0f20f = "Recompiler: Register allocator internal processing error #9." */
    '\x13','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x16','\x04','\x09','#','9','.',
/* 0x0f229 = "VERR_SUP_VP_NT_MAPPING_NAME_CHANGED" */
    '\x01','\x95','\xbd','N','T','_','M','A','P','P','I','N','G','_','N','A','M','E','_','C','H','A','N','G','E','D',
/* 0x0f243 = "Key algorithm parameters not expected." */
    'K','e','y',' ','\xd4','p','a','r','a','m','e','t','e','r','s',' ','\x08','e','x','p','e','c','t','e','d','.',
/* 0x0f25d = "Format not supported by the codec." */
    'F','o','r','m','a','t',' ','\x08','s','u','p','p','o','r','t','e','d',' ','\xe1','\x02','c','o','d','e','c','.',
/* 0x0f277 = "The specified I/O port range was invalid." */
    '\x03','\x18','I','/','O',' ','p','o','r','t',' ','r','a','n','g','e',' ','\x11','i','n','v','a','l','i','d','.',
/* 0x0f291 = "VERR_DBG_NO_MATCHING_INTERPRETER" */
    '\x01','D','B','G','_','\x60','M','A','T','C','H','I','N','G','_','I','N','T','E','R','P','R','E','T','E','R',
/* 0x0f2ab = "VINF_EM_PENDING_R3_IOPORT_READ" */
    '\x0e','E','M','_','P','E','N','D','I','N','G','_','R','3','_','I','O','P','O','R','T','_','R','E','A','D',
/* 0x0f2c5 = "No page directory available for the hypervisor." */
    '\xdf','\xcc','\x25','a','v','a','i','l','a','b','l','e',' ','\x10','\x02','h','y','p','e','r','v','i','s','o','r','.',
/* 0x0f2df = "VERR_HARDAVL_INSERT_INVALID_KEY_RANGE" */
    '\x01','H','A','R','D','A','V','L','_','I','N','S','E','R','T','_','\x05','K','E','Y','_','R','A','N','G','E',
/* 0x0f2f9 = "General network printing error." */
    'G','e','n','e','r','a','l',' ','n','e','t','w','o','r','k',' ','p','r','i','n','t','i','n','g',' ','\x85',
/* 0x0f313 = "The USB device instance structure version has changed." */
    '\x03','U','S','B',' ','\xa3','i','n','s','t','a','n','c','e',' ','\xec','\xcf','\x5e','c','h','a','n','g','e','d','.',
/* 0x0f32d = "The semaphore is set and cannot be closed." */
    '\x03','s','e','m','a','p','h','o','r','e',' ','\x0b','s','e','t',' ','\x9a','\xd1','\xa7','c','l','o','s','e','d','.',
/* 0x0f347 = "Expression stack overflow." */
    'E','x','p','r','e','s','s','i','o','n',' ','s','t','a','c','k',' ','o','v','e','r','f','l','o','w','.',
/* 0x0f361 = "The format of a data unit has changed." */
    '\x03','f','o','r','m','a','t',' ','\x15','a',' ','\x9d','u','n','i','t',' ','\x5e','c','h','a','n','g','e','d','.',
/* 0x0f37b = "Requested service already exists." */
    'R','e','q','u','e','s','t','e','d',' ','s','e','r','v','i','c','e',' ','\x7f','e','x','i','s','t','s','.',
/* 0x0f395 = "Process Verification Failure: Error querying image information." */
    '\x1e','\x0d','\x12','\xc0','q','u','e','r','y','i','n','g',' ','\x26','i','n','f','o','r','m','a','t','i','o','n','.',
/* 0x0f3af = "VERR_PDM_MEDIAEX_IOREQID_CONFLICT" */
    '\x01','\x7d','M','E','D','I','A','E','X','_','I','O','R','E','Q','I','D','_','C','O','N','F','L','I','C','T',
/* 0x0f3c9 = "VERR_SSM_DATA_UNIT_FORMAT_CHANGED" */
    '\x01','\xb0','D','A','T','A','_','U','N','I','T','_','F','O','R','M','A','T','_','C','H','A','N','G','E','D',
/* 0x0f3e3 = "VERR_ISOMK_IMPORT_BOOT_CAT_BAD_OUT_OF_BOUNDS" */
    '\x01','\x22','\x83','B','O','O','T','_','C','A','T','_','\x1d','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x0f3fd = "VERR_PGM_HANDLER_VIRTUAL_CONFLICT" */
    '\x01','\x8c','H','A','N','D','L','E','R','_','V','I','R','T','U','A','L','_','C','O','N','F','L','I','C','T',
/* 0x0f417 = "VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_UNKNOWN_IMAGE_SIZE" */
    '\x01','\x22','\x83','B','O','O','T','_','C','A','T','_','E','N','T','R','Y','_','\x91','I','M','A','G','E','_','\xf9',
/* 0x0f431 = "Recompiler: Register allocator internal processing error #6." */
    '\x13','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x16','\x04','\x09','#','6','.',
/* 0x0f44b = "VINF_EM_RESUME_R3_HISTORY_EXEC" */
    '\x0e','E','M','_','R','E','S','U','M','E','_','R','3','_','H','I','S','T','O','R','Y','_','E','X','E','C',
/* 0x0f465 = "Recompiler: Totally unexpected memory size." */
    '\x13','T','o','t','a','l','l','y',' ','u','n','e','x','p','e','c','t','e','d',' ','\x86','s','i','z','e','.',
/* 0x0f47f = "VERR_CR_X509_CPV_ALT_NAME_NOT_PERMITTED" */
    '\x01','\x24','\xb7','C','P','V','_','A','L','T','_','N','A','M','E','_','\x06','P','E','R','M','I','T','T','E','D',
/* 0x0f499 = "The returned shadow page is cached." */
    '\x03','r','e','t','u','r','n','e','d',' ','s','h','a','d','o','w',' ','\xcc','\x0b','c','a','c','h','e','d','.',
/* 0x0f4b3 = "Recompiler: Register allocator internal processing error #2." */
    '\x13','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x16','\x04','\x09','#','2','.',
/* 0x0f4cd = "Malformed forwarder entry." */
    'M','a','l','f','o','r','m','e','d',' ','f','o','r','w','a','r','d','e','r',' ','e','n','t','r','y','.',
/* 0x0f4e7 = "Import ISO uses invalid volume sequence number." */
    '\xc3','\xc1',' ','u','s','e','s',' ','\x8f','\xd2','s','e','q','u','e','n','c','e',' ','n','u','m','b','e','r','.',
/* 0x0f501 = "Can\'t delete bucket with keys." */
    'C','a','n','\'','t',' ','d','e','l','e','t','e',' ','b','u','c','k','e','t',' ','\x80','k','e','y','s','.',
/* 0x0f51b = "Reason for leaving RZ: The urge to syncing CR3." */
    '\x93','\x10','\x81','R','Z',':',' ','\x03','u','r','g','e',' ','\x0a','s','y','n','c','i','n','g',' ','C','R','3','.',
/* 0x0f535 = "VERR_IOM_IOPORT_RANGE_CONFLICT" */
    '\x01','I','O','M','_','I','O','P','O','R','T','_','R','A','N','G','E','_','C','O','N','F','L','I','C','T',
/* 0x0f54f = "VERR_SHCLPB_OBJ_HANDLE_INVALID" */
    '\x01','S','H','C','L','P','B','_','O','B','J','_','H','A','N','D','L','E','_','I','N','V','A','L','I','D',
/* 0x0f569 = "Internal processing error in the PGM handy page allocator." */
    '\x07','\x04','\x09','\x0f','\x02','P','G','M',' ','h','a','n','d','y',' ','\xcc','a','l','l','o','c','a','t','o','r','.',
/* 0x0f583 = "The cache is not up to date with the image." */
    '\x03','c','a','c','h','e',' ','\x0b','\x08','u','p',' ','\x0a','d','a','t','e',' ','\x80','\x02','i','m','a','g','e','.',
/* 0x0f59d = "VERR_REST_UNABLE_TO_PARSE_STRING_AS_BOOL" */
    '\x01','R','E','S','T','_','U','N','A','B','L','E','_','T','O','_','\xe4','\xd5','_','A','S','_','B','O','O','L',
/* 0x0f5b7 = "Recompiler: Register allocator internal processing error #3." */
    '\x13','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x16','\x04','\x09','#','3','.',
/* 0x0f5d1 = "VERR_SHCLPB_MAX_EVENTS_REACHED" */
    '\x01','S','H','C','L','P','B','_','M','A','X','_','E','V','E','N','T','S','_','R','E','A','C','H','E','D',
/* 0x0f5eb = "The ELF loader encountered a bad symbol index." */
    '\x03','E','L','F',' ','\xd9','\xaf','a',' ','b','a','d',' ','s','y','m','b','o','l',' ','i','n','d','e','x','.',
/* 0x0f605 = "The event semaphore has already been reset." */
    '\x03','e','v','e','n','t',' ','s','e','m','a','p','h','o','r','e',' ','\x5e','\x7f','\xcb','r','e','s','e','t','.',
/* 0x0f61f = "VERR_INTNET_INCOMPATIBLE_FLAGS" */
    '\x01','I','N','T','N','E','T','_','I','N','C','O','M','P','A','T','I','B','L','E','_','F','L','A','G','S',
/* 0x0f639 = "Floating pointer overflow." */
    'F','l','o','a','t','i','n','g',' ','p','o','i','n','t','e','r',' ','o','v','e','r','f','l','o','w','.',
/* 0x0f653 = "Mount failed because a media was already mounted." */
    'M','o','u','n','t',' ','\x99','\x40','a',' ','m','e','d','i','a',' ','\x11','\x7f','m','o','u','n','t','e','d','.',
/* 0x0f66d = "VERR_X509_EXTRACT_PUBKEY_FROM_CERT" */
    '\x01','\xb7','E','X','T','R','A','C','T','_','P','U','B','K','E','Y','_','F','R','O','M','_','C','E','R','T',
/* 0x0f687 = "VERR_GIM_HYPERCALLS_NOT_AVAILABLE" */
    '\x01','G','I','M','_','H','Y','P','E','R','C','A','L','L','S','_','\x06','A','V','A','I','L','A','B','L','E',
/* 0x0f6a1 = "Recompiler: Register allocator internal processing error #4." */
    '\x13','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x16','\x04','\x09','#','4','.',
/* 0x0f6bb = "VERR_IEM_EMIT_CASE_NOT_IMPLEMENTED_1" */
    '\x01','\x9c','E','M','I','T','_','C','A','S','E','_','\x06','I','M','P','L','E','M','E','N','T','E','D','_','1',
/* 0x0f6d5 = "VERR_DBG_MALFORMED_UNWIND_INFO" */
    '\x01','D','B','G','_','M','A','L','F','O','R','M','E','D','_','U','N','W','I','N','D','_','I','N','F','O',
/* 0x0f6ef = "Too many logical volume descriptors." */
    'T','o','o',' ','\xb4','l','o','g','i','c','a','l',' ','\xd2','d','e','s','c','r','i','p','t','o','r','s','.',
/* 0x0f709 = "The JSON document is malformed." */
    '\x03','J','S','O','N',' ','d','o','c','u','m','e','n','t',' ','\x0b','m','a','l','f','o','r','m','e','d','.',
/* 0x0f723 = "VERR_AUDIO_NO_FREE_INPUT_STREAMS" */
    '\x01','A','U','D','I','O','_','\x60','F','R','E','E','_','I','N','P','U','T','_','S','T','R','E','A','M','S',
/* 0x0f73d = "VINF_EM_RESCHEDULE_EXEC_ENGINE" */
    '\x0e','E','M','_','R','E','S','C','H','E','D','U','L','E','_','E','X','E','C','_','E','N','G','I','N','E',
/* 0x0f757 = "VERR_X509_RSA_VERIFICATION_FUILURE" */
    '\x01','\xb7','R','S','A','_','V','E','R','I','F','I','C','A','T','I','O','N','_','F','U','I','L','U','R','E',
/* 0x0f771 = "Recompiler: Register allocator internal processing error #8." */
    '\x13','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x16','\x04','\x09','#','8','.',
/* 0x0f78b = "VERR_ISOFS_MALFORMED_PART_MAP_TABLE" */
    '\x01','\x97','M','A','L','F','O','R','M','E','D','_','P','A','R','T','_','M','A','P','_','T','A','B','L','E',
/* 0x0f7a5 = "Too many primary volume descriptors." */
    'T','o','o',' ','\xb4','p','r','i','m','a','r','y',' ','\xd2','d','e','s','c','r','i','p','t','o','r','s','.',
/* 0x0f7bf = "Recompiler: Register allocator internal processing error #7." */
    '\x13','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x16','\x04','\x09','#','7','.',
/* 0x0f7d9 = "The shared module has too many regions." */
    '\x03','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','\x5e','\x9e','\xb4','r','e','g','i','o','n','s','.',
/* 0x0f7f3 = "Insufficient data to check descriptor CRC." */
    'I','n','s','u','f','f','i','c','i','e','n','t',' ','\x9d','\x0a','c','h','e','c','k',' ','\xe3','C','R','C','.',
/* 0x0f80d = "Status that causes DBGC to quit." */
    'S','t','a','t','u','s',' ','\xad','c','a','u','s','e','s',' ','D','B','G','C',' ','\x0a','q','u','i','t','.',
/* 0x0f827 = "The specified environment variable was not found." */
    '\x03','\x18','e','n','v','i','r','o','n','m','e','n','t',' ','v','a','r','i','a','b','l','e',' ','\x11','\x08','\x89',
/* 0x0f841 = "VERR_SYSTEM_INTEGRITY_POLICY_VIOLATION" */
    '\x01','S','Y','S','T','E','M','_','\xf7','_','P','O','L','I','C','Y','_','V','I','O','L','A','T','I','O','N',
/* 0x0f85b = "The loaded timer state was incorrect." */
    '\x03','l','o','a','d','e','d',' ','t','i','m','e','r',' ','\xca','\x11','i','n','c','o','r','r','e','c','t','.',
/* 0x0f875 = "Pluggable Device Manager error." */
    'P','l','u','g','g','a','b','l','e',' ','D','e','v','i','c','e',' ','M','a','n','a','g','e','r',' ','\x85',
/* 0x0f88f = "VFS chain element expected at most one argument." */
    '\x8d',' ','\xa1','\x5c','\xc9','a','t',' ','m','o','s','t',' ','o','n','e',' ','a','r','g','u','m','e','n','t','.',
/* 0x0f8a9 = "VERR_PDM_CRITSECTRW_TOO_MANY_RECURSIONS" */
    '\x01','\x7d','C','R','I','T','S','E','C','T','R','W','_','\x1a','\xac','R','E','C','U','R','S','I','O','N','S',
/* 0x0f8c2 = "VERR_FDT_DTB_PROP_SIZE_MALFORMED" */
    '\x01','F','D','T','_','D','T','B','_','P','R','O','P','_','\xf9','_','M','A','L','F','O','R','M','E','D',
/* 0x0f8db = "VERR_CR_PKIX_CIPHER_ALGO_NOT_KNOWN" */
    '\x01','\x24','P','K','I','X','_','C','I','P','H','E','R','_','A','L','G','O','_','\x06','K','N','O','W','N',
/* 0x0f8f4 = "VERR_ISOMK_BOOT_CAT_NO_DEFAULT_ENTRY" */
    '\x01','\x22','B','O','O','T','_','C','A','T','_','\x60','D','E','F','A','U','L','T','_','E','N','T','R','Y',
/* 0x0f90d = "VERR_ISOMK_IMPORT_BOOT_CAT_INVALID_BOOT_MEDIA_TYPE" */
    '\x01','\x22','\x83','B','O','O','T','_','C','A','T','_','\x05','B','O','O','T','_','M','E','D','I','A','_','\xb5',
/* 0x0f926 = "Encountered an unknown attribute form." */
    '\xa5','\x87','u','n','k','n','o','w','n',' ','a','t','t','r','i','b','u','t','e',' ','f','o','r','m','.',
/* 0x0f93f = "There is no tracer present." */
    'T','h','e','r','e',' ','\x0b','n','o',' ','t','r','a','c','e','r',' ','p','r','e','s','e','n','t','.',
/* 0x0f958 = "VERR_CR_PKIX_NOT_ECDSA_PRIVATE_KEY" */
    '\x01','\x24','P','K','I','X','_','\x06','E','C','D','S','A','_','P','R','I','V','A','T','E','_','K','E','Y',
/* 0x0f971 = "Hypervisor code was stepped." */
    'H','y','p','e','r','v','i','s','o','r',' ','c','o','d','e',' ','\x11','s','t','e','p','p','e','d','.',
/* 0x0f98a = "Generic dangling objects status." */
    '\xa6','d','a','n','g','l','i','n','g',' ','o','b','j','e','c','t','s',' ','s','t','a','t','u','s','.',
/* 0x0f9a3 = "A bad page map entry was encountered." */
    'A',' ','b','a','d',' ','\xcc','m','a','p',' ','\xc8','\x11','e','n','c','o','u','n','t','e','r','e','d','.',
/* 0x0f9bc = "VERR_SUPLIB_SYMLINKS_ARE_NOT_PERMITTED" */
    '\x01','\xd6','S','Y','M','L','I','N','K','S','_','A','R','E','_','\x06','P','E','R','M','I','T','T','E','D',
/* 0x0f9d5 = "Unused MMIO register read, fill with FF." */
    'U','n','u','s','e','d',' ','\xd3',' ','\xeb','r','e','a','d',',',' ','f','i','l','l',' ','\x80','F','F','.',
/* 0x0f9ee = "The handle ID was not found in the set." */
    '\x03','h','a','n','d','l','e',' ','I','D',' ','\x11','\x08','f','o','u','n','d',' ','\x0f','\x02','s','e','t','.',
/* 0x0fa07 = "VERR_PDM_NO_DRIVER_ATTACHED_TO_LUN" */
    '\x01','\x7d','\x60','D','R','I','V','E','R','_','A','T','T','A','C','H','E','D','_','T','O','_','L','U','N',
/* 0x0fa20 = "No default entry in the boot catalog." */
    '\xdf','d','e','f','a','u','l','t',' ','\xc8','\x0f','\x02','b','o','o','t',' ','c','a','t','a','l','o','g','.',
/* 0x0fa39 = "VERR_ISOMK_IMPORT_BOOT_CAT_EXT_ENTRY_INVALID_ID" */
    '\x01','\x22','\x83','B','O','O','T','_','C','A','T','_','E','X','T','_','E','N','T','R','Y','_','\x05','I','D',
/* 0x0fa52 = "VINF_VRDP_OPERATION_COMPLETED" */
    '\x0e','V','R','D','P','_','O','P','E','R','A','T','I','O','N','_','C','O','M','P','L','E','T','E','D',
/* 0x0fa6b = "VERR_VFS_CHAIN_TAKES_DIR_OR_FSS_OR_VFS" */
    '\x01','\x8d','_','\x8e','T','A','K','E','S','_','D','I','R','_','O','R','_','F','S','S','_','O','R','_','\x8d',
/* 0x0fa84 = "Reason for leaving RC: Encountered a stale selector." */
    '\x93','\x10','\x81','R','C',':',' ','\xa5','a',' ','s','t','a','l','e',' ','s','e','l','e','c','t','o','r','.',
/* 0x0fa9d = "The register is read-only and cannot be modified." */
    '\x03','\xeb','\x0b','r','e','a','d','-','o','n','l','y',' ','\x9a','\xd1','\xa7','m','o','d','i','f','i','e','d','.',
/* 0x0fab6 = "VERR_XAR_EXTRACTED_SIZE_EXCEEDED" */
    '\x01','X','A','R','_','E','X','T','R','A','C','T','E','D','_','\xf9','_','E','X','C','E','E','D','E','D',
/* 0x0facf = "The tar file ended unexpectedly." */
    '\x03','t','a','r',' ','\x1f','e','n','d','e','d',' ','u','n','e','x','p','e','c','t','e','d','l','y','.',
/* 0x0fae8 = "Process Verification Failure: Bad file alignment value in image header." */
    '\x1e','\x0d','\x12','\x9f','\x1f','a','l','i','g','n','m','e','n','t',' ','\xf5','\x0f','\x26','h','e','a','d','e','r','.',
/* 0x0fb01 = "Unsupported CPU feature combination." */
    '\x98','C','P','U',' ','f','e','a','t','u','r','e',' ','c','o','m','b','i','n','a','t','i','o','n','.',
/* 0x0fb1a = "Certificate path builder: Encountered bad certificate context." */
    '\xba','\xd0','b','u','i','l','d','e','r',':',' ','\xa5','b','a','d',' ','\xa0','c','o','n','t','e','x','t','.',
/* 0x0fb33 = "VERR_IEM_REG_ALLOCATOR_NO_FREE_TMP" */
    '\x01','\x9c','R','E','G','_','A','L','L','O','C','A','T','O','R','_','\x60','F','R','E','E','_','T','M','P',
/* 0x0fb4c = "VWRN_SUPDRV_TSC_DELTA_MEASUREMENT_FAILED" */
    '\xe6','\x90','T','S','C','_','D','E','L','T','A','_','M','E','A','S','U','R','E','M','E','N','T','_','\x17',
/* 0x0fb65 = "Failed to get underlying link ID." */
    '\x8b','\x0a','g','e','t',' ','u','n','d','e','r','l','y','i','n','g',' ','l','i','n','k',' ','I','D','.',
/* 0x0fb7e = "VERR_XAR_UNUSED_ARCHIVED_DATA" */
    '\x01','X','A','R','_','U','N','U','S','E','D','_','A','R','C','H','I','V','E','D','_','D','A','T','A',
/* 0x0fb97 = "Internal SPC error: Bad object moniker data pointer." */
    '\x07','S','P','C',' ','\xd8','\x9f','\xa8','m','o','n','i','k','e','r',' ','\x9d','p','o','i','n','t','e','r','.',
/* 0x0fbb0 = "VERR_LDRVI_SECTION_RAW_DATA_VALUES" */
    '\x01','\xf4','S','E','C','T','I','O','N','_','R','A','W','_','D','A','T','A','_','V','A','L','U','E','S',
/* 0x0fbc9 = "VERR_IEM_REG_ALLOCATOR_NO_FREE_VAR" */
    '\x01','\x9c','R','E','G','_','A','L','L','O','C','A','T','O','R','_','\x60','F','R','E','E','_','V','A','R',
/* 0x0fbe2 = "VERR_LDRVI_MACHINE_OPT_HDR_MAGIC_MISMATCH" */
    '\x01','\xf4','M','A','C','H','I','N','E','_','O','P','T','_','H','D','R','_','M','A','G','I','C','_','\x19',
/* 0x0fbfb = "VERR_SHCLPB_MAX_LISTS_REACHED" */
    '\x01','S','H','C','L','P','B','_','M','A','X','_','L','I','S','T','S','_','R','E','A','C','H','E','D',
/* 0x0fc14 = "Command hardware failure." */
    'C','o','m','m','a','n','d',' ','h','a','r','d','w','a','r','e',' ','f','a','i','l','u','r','e','.',
/* 0x0fc2d = "Bad VTG provider descriptor." */
    '\x9f','V','T','G',' ','p','r','o','v','i','d','e','r',' ','d','e','s','c','r','i','p','t','o','r','.',
/* 0x0fc46 = "VERR_VFS_CHAIN_MUST_BE_FIRST_ELEMENT" */
    '\x01','\x8d','_','\x8e','M','U','S','T','_','B','E','_','F','I','R','S','T','_','E','L','E','M','E','N','T',
/* 0x0fc5f = "Bogus UDF dstring field value." */
    'B','o','g','u','s',' ','U','D','F',' ','d','s','t','r','i','n','g',' ','f','i','e','l','d',' ','\xe8',
/* 0x0fc78 = "NEM failed to map page(s) into the VM." */
    '\xee',' ','\x99','\x0a','m','a','p',' ','p','a','g','e','(','s',')',' ','i','n','t','o',' ','\x02','V','M','.',
/* 0x0fc91 = "Page hash table size overflow." */
    'P','a','g','e',' ','h','a','s','h',' ','\xb1','s','i','z','e',' ','o','v','e','r','f','l','o','w','.',
/* 0x0fcaa = "VERR_SSM_ENUM_VALUE_OUT_OF_RANGE" */
    '\x01','\xb0','E','N','U','M','_','V','A','L','U','E','_','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x0fcc3 = "The PE loader doesn't grok the COM descriptor data directory entry." */
    '\x03','P','E',' ','\xd9','\xc7','g','r','o','k',' ','\x02','C','O','M',' ','\xe3','\x9d','\x25','e','n','t','r','y','.',
/* 0x0fcdc = "Internal processing error #1 in the DBGF event tracing code." */
    '\x07','\x04','\x09','#','1',' ','\x0f','\x02','\xb9',' ','e','v','e','n','t',' ','t','r','a','c','i','n','g',' ','\x84',
/* 0x0fcf5 = "VERR_CR_KEY_MALFORMED_CIPHER_IV" */
    '\x01','\x24','K','E','Y','_','M','A','L','F','O','R','M','E','D','_','C','I','P','H','E','R','_','I','V',
/* 0x0fd0e = "Bad SPC object moniker UUID field." */
    '\x9f','S','P','C',' ','\xa8','m','o','n','i','k','e','r',' ','U','U','I','D',' ','f','i','e','l','d','.',
/* 0x0fd27 = "A number tar header field was malformed." */
    'A',' ','\xfb','t','a','r',' ','\xb3','f','i','e','l','d',' ','\x11','m','a','l','f','o','r','m','e','d','.',
/* 0x0fd40 = "VERR_CR_KEY_ALGO_PARAMS_UNKNOWN" */
    '\x01','\x24','K','E','Y','_','A','L','G','O','_','P','A','R','A','M','S','_','U','N','K','N','O','W','N',
/* 0x0fd59 = "Unused MMIO register read, fill with 00." */
    'U','n','u','s','e','d',' ','\xd3',' ','\xeb','r','e','a','d',',',' ','f','i','l','l',' ','\x80','0','0','.',
/* 0x0fd72 = "VWRN_CSAM_INSTRUCTION_PATCHED" */
    '\xe6','C','S','A','M','_','I','N','S','T','R','U','C','T','I','O','N','_','P','A','T','C','H','E','D',
/* 0x0fd8b = "VERR_ISOFS_BOGUS_UDF_DSTRING_FIELD" */
    '\x01','\x97','B','O','G','U','S','_','U','D','F','_','D','S','T','R','I','N','G','_','F','I','E','L','D',
/* 0x0fda4 = "Unsupported PKCS #7 signed data version." */
    '\x98','P','K','C','S',' ','#','7',' ','s','i','g','n','e','d',' ','\x9d','v','e','r','s','i','o','n','.',
/* 0x0fdbd = "Too many instances of a driver." */
    'T','o','o',' ','\xb4','i','n','s','t','a','n','c','e','s',' ','\x15','a',' ','d','r','i','v','e','r','.',
/* 0x0fdd6 = "Bad DWARF abbreviation data." */
    '\x9f','D','W','A','R','F',' ','a','b','b','r','e','v','i','a','t','i','o','n',' ','d','a','t','a','.',
/* 0x0fdef = "VERR_HOSTIF_DEVICE_NAME_TOO_LONG" */
    '\x01','H','O','S','T','I','F','_','D','E','V','I','C','E','_','N','A','M','E','_','\x1a','L','O','N','G',
/* 0x0fe08 = "Encountered a term function section." */
    '\xa5','a',' ','t','e','r','m',' ','f','u','n','c','t','i','o','n',' ','s','e','c','t','i','o','n','.',
/* 0x0fe21 = "Was not able to open the support driver." */
    'W','a','s',' ','\x08','a','b','l','e',' ','\x0a','o','p','e','n',' ','\x02','\xce','d','r','i','v','e','r','.',
/* 0x0fe3a = "VERR_HTTP_CACERT_WRONG_FORMAT" */
    '\x01','H','T','T','P','_','C','A','C','E','R','T','_','W','R','O','N','G','_','F','O','R','M','A','T',
/* 0x0fe53 = "Invalid object ID in managed object reference." */
    '\x0c','\xa8','I','D',' ','\x0f','m','a','n','a','g','e','d',' ','\xa8','r','e','f','e','r','e','n','c','e','.',
/* 0x0fe6c = "VERR_X509_NOT_SELFSIGNED_CERTIFICATE" */
    '\x01','\xb7','\x06','S','E','L','F','S','I','G','N','E','D','_','C','E','R','T','I','F','I','C','A','T','E',
/* 0x0fe85 = "VINF_DBGF_ZERO_EXTENDED_REGISTER" */
    '\x0e','\xb9','_','Z','E','R','O','_','E','X','T','E','N','D','E','D','_','R','E','G','I','S','T','E','R',
/* 0x0fe9e = "VERR_CR_KEY_OSSL_DECRYPT_INIT_ERROR" */
    '\x01','\x24','K','E','Y','_','O','S','S','L','_','D','E','C','R','Y','P','T','_','I','N','I','T','_','\x1b',
/* 0x0feb7 = "VERR_CPUM_MSR_BAD_CPUMCPU_OFFSET" */
    '\x01','C','P','U','M','_','M','S','R','_','\x1d','C','P','U','M','C','P','U','_','O','F','F','S','E','T',
/* 0x0fed0 = "VERR_ISOFS_BAD_LVD_FILE_SET_DESC_LOCATION" */
    '\x01','\x97','\x1d','L','V','D','_','\xab','S','E','T','_','D','E','S','C','_','L','O','C','A','T','I','O','N',
/* 0x0fee9 = "VERR_SUPDRV_TRACER_CANNOT_OPEN_SELF" */
    '\x01','\x90','T','R','A','C','E','R','_','C','A','N','N','O','T','_','O','P','E','N','_','S','E','L','F',
/* 0x0ff02 = "VERR_CR_PKIX_SIGNATURE_NEGATIVE" */
    '\x01','\x24','P','K','I','X','_','S','I','G','N','A','T','U','R','E','_','N','E','G','A','T','I','V','E',
/* 0x0ff1b = "Was not able to load the support driver." */
    'W','a','s',' ','\x08','a','b','l','e',' ','\x0a','l','o','a','d',' ','\x02','\xce','d','r','i','v','e','r','.',
/* 0x0ff34 = "VERR_DBGC_PARSE_UNBALANCED_PARENTHESIS" */
    '\x01','\xfc','\xe4','U','N','B','A','L','A','N','C','E','D','_','P','A','R','E','N','T','H','E','S','I','S',
/* 0x0ff4d = "VERR_GSTCTL_PROCESS_EXIT_CODE" */
    '\x01','G','S','T','C','T','L','_','P','R','O','C','E','S','S','_','E','X','I','T','_','C','O','D','E',
/* 0x0ff66 = "VFS chain doesn't end with a path only element." */
    '\x8d',' ','\xa1','\xc7','e','n','d',' ','\x80','a',' ','\xd0','o','n','l','y',' ','e','l','e','m','e','n','t','.',
/* 0x0ff7f = "VINF_EM_RAW_INJECT_TRPM_EVENT" */
    '\x0e','E','M','_','R','A','W','_','I','N','J','E','C','T','_','T','R','P','M','_','E','V','E','N','T',
/* 0x0ff98 = "Image Verification Failure: Invalid security directory entry." */
    'I','m','a','g','e',' ','\x0d','\x12','\x0c','s','e','c','u','r','i','t','y',' ','\x25','e','n','t','r','y','.',
/* 0x0ffb1 = "Parallels HDD: Invalid image file header." */
    'P','a','r','a','l','l','e','l','s',' ','H','D','D',':',' ','\x0c','\x26','\x1f','h','e','a','d','e','r','.',
/* 0x0ffca = "VERR_ASN1_CURSOR_TAG_FLAG_CLASS_MISMATCH" */
    '\x01','\xa2','C','U','R','S','O','R','_','T','A','G','_','F','L','A','G','_','C','L','A','S','S','_','\x19',
/* 0x0ffe3 = "VERR_CR_PKCS7_SIGNER_INFO_DIGEST_ENCRYPT_MISMATCH" */
    '\x01','\x24','\xe5','S','I','G','N','E','R','_','I','N','F','O','_','\xbe','E','N','C','R','Y','P','T','_','\x19',
/* 0x0fffc = "Process Verification Failure: The process has too many virtual memory regions." */
    '\x1e','\x0d','\x12','\x03','\x92','\x5e','\x9e','\xb4','v','i','r','t','u','a','l',' ','\x86','r','e','g','i','o','n','s','.',
/* 0x10015 = "VERR_REST_PATH_PARAMETER_NOT_SET" */
    '\x01','R','E','S','T','_','P','A','T','H','_','P','A','R','A','M','E','T','E','R','_','\x06','S','E','T',
/* 0x1002e = "Failed to read the device table entry due to an invalid offset." */
    '\x8b','\x0a','r','e','a','d',' ','\x02','\xa3','\xb1','\xc8','d','u','e',' ','\x0a','\x87','\x8f','o','f','f','s','e','t','.',
/* 0x10047 = "Proxy couldn\'t be resolved." */
    'P','r','o','x','y',' ','c','o','u','l','d','n','\'','t',' ','\xa7','r','e','s','o','l','v','e','d','.',
/* 0x10060 = "Process Verification Failure: Image section region is too large." */
    '\x1e','\x0d','\x12','I','m','a','g','e',' ','\xdb','r','e','g','i','o','n',' ','\x0b','\x9e','l','a','r','g','e','.',
/* 0x10079 = "Bad length element in table of content sub-element." */
    '\x9f','l','e','n','g','t','h',' ','\x5c','\x0f','\xb1','\x15','\xf0','s','u','b','-','e','l','e','m','e','n','t','.',
/* 0x10092 = "The VFS chain specification is empty." */
    '\x03','\x8d',' ','\xa1','s','p','e','c','i','f','i','c','a','t','i','o','n',' ','\x0b','e','m','p','t','y','.',
/* 0x100ab = "VERR_SUPDRV_TSC_DELTA_MEASUREMENT_FAILED" */
    '\x01','\x90','T','S','C','_','D','E','L','T','A','_','M','E','A','S','U','R','E','M','E','N','T','_','\x17',
/* 0x100c4 = "VERR_SUPDRV_TRACER_UMOD_STRTAB_TOO_BIG" */
    '\x01','\x90','T','R','A','C','E','R','_','U','M','O','D','_','S','T','R','T','A','B','_','\x1a','B','I','G',
/* 0x100dd = "VERR_PATM_IPE_TRAP_IN_PATCH_CODE" */
    '\x01','P','A','T','M','_','\x14','T','R','A','P','_','I','N','_','P','A','T','C','H','_','C','O','D','E',
/* 0x100f6 = "Too many instances of a device." */
    'T','o','o',' ','\xb4','i','n','s','t','a','n','c','e','s',' ','\x15','a',' ','d','e','v','i','c','e','.',
/* 0x1010f = "VERR_FILE_AIO_INSUFFICIENT_EVENTS" */
    '\x01','\xab','A','I','O','_','I','N','S','U','F','F','I','C','I','E','N','T','_','E','V','E','N','T','S',
/* 0x10128 = "Failed to fstat a native handle (hardening)." */
    '\x8b','\x0a','f','s','t','a','t',' ','a',' ','n','a','t','i','v','e',' ','h','a','n','d','l','e',' ','\xae',
/* 0x10141 = "Shared Clipboard event failed error." */
    'S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','e','v','e','n','t',' ','\x99','\x85',
/* 0x1015a = "VFS chain element takes exactly three arguments." */
    '\x8d',' ','\xa1','\x5c','t','a','k','e','s',' ','e','x','a','c','t','l','y',' ','t','h','r','e','e',' ','\xdd',
/* 0x10173 = "No available ports on the hub." */
    '\xdf','a','v','a','i','l','a','b','l','e',' ','p','o','r','t','s',' ','o','n',' ','\x02','h','u','b','.',
/* 0x1018c = "VERR_NET_INCOMPLETE_TX_PACKET" */
    '\x01','N','E','T','_','I','N','C','O','M','P','L','E','T','E','_','T','X','_','P','A','C','K','E','T',
/* 0x101a5 = "The timer was in a unknown state." */
    '\x03','t','i','m','e','r',' ','\x11','\x0f','a',' ','u','n','k','n','o','w','n',' ','s','t','a','t','e','.',
/* 0x101be = "Decompression integrity error." */
    'D','e','c','o','m','p','r','e','s','s','i','o','n',' ','i','n','t','e','g','r','i','t','y',' ','\x85',
/* 0x101d7 = "Encountered a init function section." */
    '\xa5','a',' ','i','n','i','t',' ','f','u','n','c','t','i','o','n',' ','s','e','c','t','i','o','n','.',
/* 0x101f0 = "VERR_VUSB_DEVICE_IS_SUSPENDED" */
    '\x01','V','U','S','B','_','D','E','V','I','C','E','_','I','S','_','S','U','S','P','E','N','D','E','D',
/* 0x10209 = "VINF_PGM_HANDLED_DIRTY_BIT_FAULT" */
    '\x0e','\x8c','H','A','N','D','L','E','D','_','D','I','R','T','Y','_','B','I','T','_','F','A','U','L','T',
/* 0x10222 = "VERR_BIGNUM_NEGATIVE_EXPONENT" */
    '\x01','B','I','G','N','U','M','_','N','E','G','A','T','I','V','E','_','E','X','P','O','N','E','N','T',
/* 0x1023b = "VERR_IPC_SEND_SEND_PF_TIMEOUT" */
    '\x01','I','P','C','_','S','E','N','D','_','S','E','N','D','_','P','F','_','T','I','M','E','O','U','T',
/* 0x10254 = "Mismatching architecture." */
    'M','i','s','m','a','t','c','h','i','n','g',' ','a','r','c','h','i','t','e','c','t','u','r','e','.',
/* 0x1026d = "Invalid configuration property value." */
    '\x0c','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','p','r','o','p','e','r','t','y',' ','\xe8',
/* 0x10286 = "VERR_ASN1_BITSTRING_OUT_OF_BOUNDS" */
    '\x01','\xa2','B','I','T','S','T','R','I','N','G','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x1029f = "The EVP_PKEY_type API in OpenSSL failed." */
    '\x03','E','V','P','_','P','K','E','Y','_','\xf3','A','P','I',' ','\x0f','O','p','e','n','S','S','L',' ','\x7b',
/* 0x102b8 = "The LUN is not attached to the device." */
    '\x03','L','U','N',' ','\x0b','\x08','a','t','t','a','c','h','e','d',' ','\x0a','\x02','d','e','v','i','c','e','.',
/* 0x102d1 = "The write monitor is already engaged." */
    '\x03','w','r','i','t','e',' ','m','o','n','i','t','o','r',' ','\x0b','\x7f','e','n','g','a','g','e','d','.',
/* 0x102ea = "NEM returned in the wrong state." */
    '\xee',' ','r','e','t','u','r','n','e','d',' ','\x0f','\x02','w','r','o','n','g',' ','s','t','a','t','e','.',
/* 0x10303 = "The mode field in a tar header is bad." */
    '\x03','m','o','d','e',' ','f','i','e','l','d',' ','\x0f','a',' ','t','a','r',' ','\xb3','\x0b','b','a','d','.',
/* 0x1031c = "VINF_EM_RAW_INTERRUPT_PENDING" */
    '\x0e','E','M','_','R','A','W','_','I','N','T','E','R','R','U','P','T','_','P','E','N','D','I','N','G',
/* 0x10335 = "Process Verification Failure: Bad section alignment value in image header." */
    '\x1e','\x0d','\x12','\x9f','\xdb','a','l','i','g','n','m','e','n','t',' ','\xf5','\x0f','\x26','h','e','a','d','e','r','.',
/* 0x1034e = "VERR_FTP_CLIENT_LIMIT_REACHED" */
    '\x01','F','T','P','_','C','L','I','E','N','T','_','L','I','M','I','T','_','R','E','A','C','H','E','D',
/* 0x10367 = "Basic constraints were not found." */
    'B','a','s','i','c',' ','c','o','n','s','t','r','a','i','n','t','s',' ','w','e','r','e',' ','\x08','\x89',
/* 0x10380 = "VERR_CR_PKIX_HASH_TOO_LONG_FOR_KEY" */
    '\x01','\x24','P','K','I','X','_','H','A','S','H','_','\x1a','L','O','N','G','_','F','O','R','_','K','E','Y',
/* 0x10399 = "VERR_VD_IMAGE_REPAIR_IMPOSSIBLE" */
    '\x01','\xff','I','M','A','G','E','_','R','E','P','A','I','R','_','I','M','P','O','S','S','I','B','L','E',
/* 0x103b2 = "Bad iterdata (EXEPACK) data." */
    '\x9f','i','t','e','r','d','a','t','a',' ','(','E','X','E','P','A','C','K',')',' ','d','a','t','a','.',
/* 0x103cb = "Wrong 32/64-bit switcher." */
    'W','r','o','n','g',' ','3','2','/','6','4','-','b','i','t',' ','s','w','i','t','c','h','e','r','.',
/* 0x103e4 = "VERR_INTNET_FLT_VNIC_CREATE_FAILED" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','V','N','I','C','_','C','R','E','A','T','E','_','\x17',
/* 0x103fd = "Command address is invalid." */
    'C','o','m','m','a','n','d',' ','a','d','d','r','e','s','s',' ','\x0b','i','n','v','a','l','i','d','.',
/* 0x10416 = "VERR_IOM_MMIO_HANDLER_BOGUS_CALL" */
    '\x01','I','O','M','_','\xd3','_','H','A','N','D','L','E','R','_','B','O','G','U','S','_','C','A','L','L',
/* 0x1042f = "VERR_CPUM_INCOMPATIBLE_CONFIG" */
    '\x01','C','P','U','M','_','I','N','C','O','M','P','A','T','I','B','L','E','_','C','O','N','F','I','G',
/* 0x10448 = "VDI: Invalid image file header: invalid version." */
    'V','D','I',':',' ','\x0c','\x26','\x1f','h','e','a','d','e','r',':',' ','\x8f','v','e','r','s','i','o','n','.',
/* 0x10461 = "VERR_DBGF_BP_OWNER_NO_MORE_HANDLES" */
    '\x01','\xb9','_','B','P','_','O','W','N','E','R','_','\x60','M','O','R','E','_','H','A','N','D','L','E','S',
/* 0x1047a = "VINF_X509_NOT_SELFSIGNED_CERTIFICATE" */
    '\x0e','\xb7','\x06','S','E','L','F','S','I','G','N','E','D','_','C','E','R','T','I','F','I','C','A','T','E',
/* 0x10493 = "VERR_PDM_DRIVER_DETACH_NOT_POSSIBLE" */
    '\x01','\x7d','D','R','I','V','E','R','_','D','E','T','A','C','H','_','\x06','P','O','S','S','I','B','L','E',
/* 0x104ac = "VERR_NET_CONNECTION_TIMED_OUT" */
    '\x01','N','E','T','_','C','O','N','N','E','C','T','I','O','N','_','T','I','M','E','D','_','O','U','T',
/* 0x104c5 = "VINF_GIM_HYPERCALL_CONTINUING" */
    '\x0e','G','I','M','_','H','Y','P','E','R','C','A','L','L','_','C','O','N','T','I','N','U','I','N','G',
/* 0x104de = "Encountered a section type that\'s not implemented." */
    '\xa5','a',' ','\xdb','\xf3','t','h','a','t','\'','s',' ','\x08','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x104f7 = "VERR_VUSB_DEVICE_IS_RESETTING" */
    '\x01','V','U','S','B','_','D','E','V','I','C','E','_','I','S','_','R','E','S','E','T','T','I','N','G',
/* 0x10510 = "Bad offset element in table of content sub-element." */
    '\x9f','o','f','f','s','e','t',' ','\x5c','\x0f','\xb1','\x15','\xf0','s','u','b','-','e','l','e','m','e','n','t','.',
/* 0x10529 = "Too many references to an object." */
    'T','o','o',' ','\xb4','r','e','f','e','r','e','n','c','e','s',' ','\x0a','\x87','o','b','j','e','c','t','.',
/* 0x10542 = "VERR_SEM_LV_EXISTING_DEADLOCK" */
    '\x01','S','E','M','_','L','V','_','E','X','I','S','T','I','N','G','_','D','E','A','D','L','O','C','K',
/* 0x1055b = "Internal processing error: Not build certificate." */
    '\x07','\x04','\xd8','N','o','t',' ','b','u','i','l','d',' ','c','e','r','t','i','f','i','c','a','t','e','.',
/* 0x10574 = "VINF_PDM_NO_DRIVER_ATTACHED_TO_LUN" */
    '\x0e','\x7d','\x60','D','R','I','V','E','R','_','A','T','T','A','C','H','E','D','_','T','O','_','L','U','N',
/* 0x1058d = "The request function is not implemented." */
    '\x03','\xaa','f','u','n','c','t','i','o','n',' ','\x0b','\x08','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x105a6 = "Directory can\'t be deleted." */
    'D','i','r','e','c','t','o','r','y',' ','c','a','n','\'','t',' ','\xa7','d','e','l','e','t','e','d','.',
/* 0x105bf = "The instruction is not yet implemented by IEM." */
    '\x03','\xda','\x0b','\x08','y','e','t',' ','i','m','p','l','e','m','e','n','t','e','d',' ','\xe1','I','E','M','.',
/* 0x105d8 = "VERR_CR_PKIX_NOT_ECDSA_PUBLIC_KEY" */
    '\x01','\x24','P','K','I','X','_','\x06','E','C','D','S','A','_','P','U','B','L','I','C','_','K','E','Y',
/* 0x105f0 = "VERR_X509_PRINT_EXTENSION_TO_BIO" */
    '\x01','\xb7','P','R','I','N','T','_','E','X','T','E','N','S','I','O','N','_','T','O','_','B','I','O',
/* 0x10608 = "Node index is out of bounds." */
    'N','o','d','e',' ','i','n','d','e','x',' ','\x0b','o','u','t',' ','\x15','b','o','u','n','d','s','.',
/* 0x10620 = "The tar end of file record was read." */
    '\x03','t','a','r',' ','e','n','d',' ','\x15','\x1f','r','e','c','o','r','d',' ','\x11','r','e','a','d','.',
/* 0x10638 = "VERR_ISOMK_SYMLINK_REQ_ROCK_RIDGE" */
    '\x01','\x22','S','Y','M','L','I','N','K','_','R','E','Q','_','R','O','C','K','_','R','I','D','G','E',
/* 0x10650 = "Max timer limit reached." */
    'M','a','x',' ','t','i','m','e','r',' ','l','i','m','i','t',' ','r','e','a','c','h','e','d','.',
/* 0x10668 = "The shared module version string is too long." */
    '\x03','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','\xcf','\xf2','\x0b','\x9e','l','o','n','g','.',
/* 0x10680 = "The compressed data was corrupted." */
    '\x03','c','o','m','p','r','e','s','s','e','d',' ','\x9d','\x11','c','o','r','r','u','p','t','e','d','.',
/* 0x10698 = "Invalid UTF-16 escape sequence." */
    '\x0c','U','T','F','-','1','6',' ','e','s','c','a','p','e',' ','s','e','q','u','e','n','c','e','.',
/* 0x106b0 = "Conflicting CFGM values." */
    'C','o','n','f','l','i','c','t','i','n','g',' ','C','F','G','M',' ','v','a','l','u','e','s','.',
/* 0x106c8 = "VERR_PDM_MEDIAEX_IOBUF_OVERFLOW" */
    '\x01','\x7d','M','E','D','I','A','E','X','_','I','O','B','U','F','_','O','V','E','R','F','L','O','W',
/* 0x106e0 = "Access denied for the address." */
    'A','c','c','e','s','s',' ','d','e','n','i','e','d',' ','\x10','\x02','a','d','d','r','e','s','s','.',
/* 0x106f8 = "VERR_REST_WRONG_JSON_TYPE_FOR_STRING" */
    '\x01','R','E','S','T','_','W','R','O','N','G','_','J','S','O','N','_','\xb5','_','F','O','R','_','\xd5',
/* 0x10710 = "VINF_ISOMK_SYMLINK_REQ_ROCK_RIDGE" */
    '\x0e','\x22','S','Y','M','L','I','N','K','_','R','E','Q','_','R','O','C','K','_','R','I','D','G','E',
/* 0x10728 = "Unexpected interruption exit type." */
    '\x94','i','n','t','e','r','r','u','p','t','i','o','n',' ','e','x','i','t',' ','t','y','p','e','.',
/* 0x10740 = "The USB device helper structure version has changed." */
    '\x03','U','S','B',' ','\xa3','h','e','l','p','e','r',' ','\xec','\xcf','\x5e','c','h','a','n','g','e','d','.',
/* 0x10758 = "VERR_APIC_INTR_MASKED_BY_TPR" */
    '\x01','A','P','I','C','_','I','N','T','R','_','M','A','S','K','E','D','_','B','Y','_','T','P','R',
/* 0x10770 = "Unable to make text memory writeable (hardening)." */
    '\xe0','\x0a','m','a','k','e',' ','t','e','x','t',' ','\x86','w','r','i','t','e','a','b','l','e',' ','\xae',
/* 0x10788 = "VFS chain element expected non-empty argument." */
    '\x8d',' ','\xa1','\x5c','\xc9','n','o','n','-','e','m','p','t','y',' ','a','r','g','u','m','e','n','t','.',
/* 0x107a0 = "VERR_CR_SPC_PEIMAGE_UNKNOWN_ATTRIBUTE" */
    '\x01','\x24','S','P','C','_','P','E','I','M','A','G','E','_','\x91','A','T','T','R','I','B','U','T','E',
/* 0x107b8 = "VERR_PDM_DEVICE_INSTANCE_LUN_NOT_FOUND" */
    '\x01','\x7d','D','E','V','I','C','E','_','I','N','S','T','A','N','C','E','_','L','U','N','_','\x06','\x2a',
/* 0x107d0 = "Internal processing error #1 in page access handler code." */
    '\x07','\x04','\x09','#','1',' ','\x0f','\xcc','a','c','c','e','s','s',' ','h','a','n','d','l','e','r',' ','\x84',
/* 0x107e8 = "VERR_GETOPT_INVALID_ARGUMENT_FORMAT" */
    '\x01','G','E','T','O','P','T','_','\x05','A','R','G','U','M','E','N','T','_','F','O','R','M','A','T',
/* 0x10800 = "VERR_CR_PKIX_OSSL_EVP_PKEY_TYPE_ERROR" */
    '\x01','\x24','P','K','I','X','_','O','S','S','L','_','E','V','P','_','P','K','E','Y','_','\xb5','_','\x1b',
/* 0x10818 = "VERR_IEM_VAR_OUT_OF_STACK_SLOTS" */
    '\x01','\x9c','V','A','R','_','O','U','T','_','O','F','_','S','T','A','C','K','_','S','L','O','T','S',
/* 0x10830 = "VRDP protocol violation." */
    'V','R','D','P',' ','p','r','o','t','o','c','o','l',' ','v','i','o','l','a','t','i','o','n','.',
/* 0x10848 = "Generic out of resources warning." */
    '\xa6','o','u','t',' ','\x15','r','e','s','o','u','r','c','e','s',' ','w','a','r','n','i','n','g','.',
/* 0x10860 = "Unsectioned boot catalog entry." */
    'U','n','s','e','c','t','i','o','n','e','d',' ','b','o','o','t',' ','\xe7','e','n','t','r','y','.',
/* 0x10878 = "VERR_PAGE_DIRECTORY_PTR_NOT_PRESENT" */
    '\x01','\xdc','D','I','R','E','C','T','O','R','Y','_','P','T','R','_','\x06','P','R','E','S','E','N','T',
/* 0x10890 = "VINF_EM_RAW_EMULATE_DBG_STEP" */
    '\x0e','E','M','_','R','A','W','_','E','M','U','L','A','T','E','_','D','B','G','_','S','T','E','P',
/* 0x108a8 = "The Ring-3 module was already loaded." */
    '\x03','R','i','n','g','-','3',' ','m','o','d','u','l','e',' ','\x11','\x7f','l','o','a','d','e','d','.',
/* 0x108c0 = "Process Verification Failure: Error querying debug port." */
    '\x1e','\x0d','\x12','\xc0','q','u','e','r','y','i','n','g',' ','d','e','b','u','g',' ','p','o','r','t','.',
/* 0x108d8 = "VERR_NS_SYMLINK_CHANGE_OWNER" */
    '\x01','N','S','_','S','Y','M','L','I','N','K','_','C','H','A','N','G','E','_','O','W','N','E','R',
/* 0x108f0 = "Bad VTG probe enabled data." */
    '\x9f','V','T','G',' ','p','r','o','b','e',' ','e','n','a','b','l','e','d',' ','d','a','t','a','.',
/* 0x10908 = "VERR_SUP_VP_DUPLICATE_DLL_MAPPING" */
    '\x01','\x95','\xbd','D','U','P','L','I','C','A','T','E','_','D','L','L','_','M','A','P','P','I','N','G',
/* 0x10920 = "VERR_ISOMK_IMPORT_DIR_WITH_MORE_EXTENTS" */
    '\x01','\x22','\x83','D','I','R','_','W','I','T','H','_','M','O','R','E','_','E','X','T','E','N','T','S',
/* 0x10938 = "VERR_LDRELF_MULTIPLE_SYMTABS" */
    '\x01','L','D','R','E','L','F','_','M','U','L','T','I','P','L','E','_','S','Y','M','T','A','B','S',
/* 0x10950 = "VERR_PDM_TOO_MANY_USB_DEVICE_INSTANCES" */
    '\x01','\x7d','\x1a','\xac','U','S','B','_','D','E','V','I','C','E','_','I','N','S','T','A','N','C','E','S',
/* 0x10968 = "Terminate search branch." */
    'T','e','r','m','i','n','a','t','e',' ','s','e','a','r','c','h',' ','b','r','a','n','c','h','.',
/* 0x10980 = "The PKCS #7 content is not signed data." */
    '\x03','P','K','C','S',' ','#','7',' ','\xf0','\x0b','\x08','s','i','g','n','e','d',' ','d','a','t','a','.',
/* 0x10998 = "VINF_RECORDING_LIMIT_REACHED" */
    '\x0e','R','E','C','O','R','D','I','N','G','_','L','I','M','I','T','_','R','E','A','C','H','E','D',
/* 0x109b0 = "Unable to lock a region of a file." */
    '\xe0','\x0a','l','o','c','k',' ','a',' ','r','e','g','i','o','n',' ','\x15','a',' ','f','i','l','e','.',
/* 0x109c8 = "Configuration value is unknown." */
    'C','o','n','f','i','g','u','r','a','t','i','o','n',' ','\xf5','\x0b','u','n','k','n','o','w','n','.',
/* 0x109e0 = "NEM failed to query dirty page bitmap." */
    '\xee',' ','\x99','\x0a','q','u','e','r','y',' ','d','i','r','t','y',' ','\xcc','b','i','t','m','a','p','.',
/* 0x109f8 = "Protocol wrong type for socket." */
    'P','r','o','t','o','c','o','l',' ','w','r','o','n','g',' ','\xf3','\x10','s','o','c','k','e','t','.',
/* 0x10a10 = "VERR_VMM_RING3_CALL_DISABLED" */
    '\x01','V','M','M','_','R','I','N','G','3','_','C','A','L','L','_','D','I','S','A','B','L','E','D',
/* 0x10a28 = "VERR_PDM_MEDIAEX_IOREQ_CANCELED" */
    '\x01','\x7d','M','E','D','I','A','E','X','_','I','O','R','E','Q','_','C','A','N','C','E','L','E','D',
/* 0x10a40 = "VERR_AUDIO_BACKEND_NOT_ATTACHED" */
    '\x01','A','U','D','I','O','_','B','A','C','K','E','N','D','_','\x06','A','T','T','A','C','H','E','D',
/* 0x10a58 = "VERR_RECORDING_LIMIT_REACHED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','L','I','M','I','T','_','R','E','A','C','H','E','D',
/* 0x10a70 = "VERR_PGM_POOL_MAXED_OUT_ALREADY" */
    '\x01','\x8c','P','O','O','L','_','M','A','X','E','D','_','O','U','T','_','A','L','R','E','A','D','Y',
/* 0x10a88 = "VERR_ISOMK_BOOT_CAT_ERRATIC_ENTRY" */
    '\x01','\x22','B','O','O','T','_','C','A','T','_','E','R','R','A','T','I','C','_','E','N','T','R','Y',
/* 0x10aa0 = "VINF_PATM_DUPLICATE_FUNCTION" */
    '\x0e','P','A','T','M','_','D','U','P','L','I','C','A','T','E','_','F','U','N','C','T','I','O','N',
/* 0x10ab8 = "VERR_SUPLIB_NT_PROCESS_UNTRUSTED_4" */
    '\x01','\xd6','N','T','_','P','R','O','C','E','S','S','_','U','N','T','R','U','S','T','E','D','_','4',
/* 0x10ad0 = "VERR_IOM_NOT_IOPORT_RANGE_OWNER" */
    '\x01','I','O','M','_','\x06','I','O','P','O','R','T','_','R','A','N','G','E','_','O','W','N','E','R',
/* 0x10ae8 = "VERR_CPUM_INVALID_HWVIRT_FEAT_COMBO" */
    '\x01','C','P','U','M','_','\x05','H','W','V','I','R','T','_','F','E','A','T','_','C','O','M','B','O',
/* 0x10b00 = "Unknown digest algorithm used by PKCS #7 object." */
    '\xef','\xd7','\xd4','u','s','e','d',' ','\xe1','P','K','C','S',' ','#','7',' ','o','b','j','e','c','t','.',
/* 0x10b18 = "VERR_SUPLIB_NT_PROCESS_UNTRUSTED_0" */
    '\x01','\xd6','N','T','_','P','R','O','C','E','S','S','_','U','N','T','R','U','S','T','E','D','_','0',
/* 0x10b30 = "VERR_CR_PKIX_OSSL_SIGN_FINAL_FAILED" */
    '\x01','\x24','P','K','I','X','_','O','S','S','L','_','S','I','G','N','_','F','I','N','A','L','_','\x17',
/* 0x10b48 = "VERR_SUPLIB_NT_PROCESS_UNTRUSTED_1" */
    '\x01','\xd6','N','T','_','P','R','O','C','E','S','S','_','U','N','T','R','U','S','T','E','D','_','1',
/* 0x10b60 = "VERR_CR_PKIX_INVALID_SIGNATURE_LENGTH" */
    '\x01','\x24','P','K','I','X','_','\x05','S','I','G','N','A','T','U','R','E','_','L','E','N','G','T','H',
/* 0x10b78 = "VERR_ISOMK_IMPORT_UDF_DISCONTIGUOUS_ADS" */
    '\x01','\x22','\x83','U','D','F','_','D','I','S','C','O','N','T','I','G','U','O','U','S','_','A','D','S',
/* 0x10b90 = "Internal SPC error: Bad object moniker choice value." */
    '\x07','S','P','C',' ','\xd8','\x9f','\xa8','m','o','n','i','k','e','r',' ','c','h','o','i','c','e',' ','\xe8',
/* 0x10ba8 = "VERR_XAR_TOC_TOO_BIG_COMPRESSED" */
    '\x01','X','A','R','_','T','O','C','_','\x1a','B','I','G','_','C','O','M','P','R','E','S','S','E','D',
/* 0x10bc0 = "Internal processing error in the PGM dynmap (r0/rc)." */
    '\x07','\x04','\x09','\x0f','\x02','P','G','M',' ','d','y','n','m','a','p',' ','(','r','0','/','r','c',')','.',
/* 0x10bd8 = "VERR_PDM_DEVICE_INSTANCE_NO_IBASE" */
    '\x01','\x7d','D','E','V','I','C','E','_','I','N','S','T','A','N','C','E','_','\x60','I','B','A','S','E',
/* 0x10bf0 = "VERR_SUP_VP_CREATE_READ_EVT_SEM_FAILED" */
    '\x01','\x95','\xbd','C','R','E','A','T','E','_','R','E','A','D','_','E','V','T','_','S','E','M','_','\x17',
/* 0x10c08 = "VERR_SUPLIB_NT_PROCESS_UNTRUSTED_2" */
    '\x01','\xd6','N','T','_','P','R','O','C','E','S','S','_','U','N','T','R','U','S','T','E','D','_','2',
/* 0x10c20 = "VERR_EXTPACK_UNSUPPORTED_HOST_UNINSTALL" */
    '\x01','E','X','T','P','A','C','K','_','\x1c','H','O','S','T','_','U','N','I','N','S','T','A','L','L',
/* 0x10c38 = "VERR_CR_SPC_NOT_EXACTLY_ONE_DIGEST_ALGO" */
    '\x01','\x24','S','P','C','_','\x06','E','X','A','C','T','L','Y','_','O','N','E','_','\xbe','A','L','G','O',
/* 0x10c50 = "Recompiler: Fixed jump is out of range." */
    '\x13','F','i','x','e','d',' ','j','u','m','p',' ','\x0b','o','u','t',' ','\x15','r','a','n','g','e','.',
/* 0x10c68 = "Reached the max cache size." */
    'R','e','a','c','h','e','d',' ','\x02','m','a','x',' ','c','a','c','h','e',' ','s','i','z','e','.',
/* 0x10c80 = "VERR_GIM_HYPERCALL_MEMORY_WRITE_FAILED" */
    '\x01','G','I','M','_','H','Y','P','E','R','C','A','L','L','_','\xb6','_','W','R','I','T','E','_','\x17',
/* 0x10c98 = "VERR_SUP_VP_SECTION_NOT_FULLY_MAPPED" */
    '\x01','\x95','\xbd','S','E','C','T','I','O','N','_','\x06','F','U','L','L','Y','_','M','A','P','P','E','D',
/* 0x10cb0 = "No partition descriptors found." */
    '\xdf','p','a','r','t','i','t','i','o','n',' ','d','e','s','c','r','i','p','t','o','r','s',' ','\x89',
/* 0x10cc8 = "VERR_SUP_VP_DLL_CHARECTERISTICS_MISMATCH" */
    '\x01','\x95','\xbd','D','L','L','_','C','H','A','R','E','C','T','E','R','I','S','T','I','C','S','_','\x19',
/* 0x10ce0 = "The file is not a valid NM map file." */
    '\x03','\x1f','\x0b','\x08','a',' ','v','a','l','i','d',' ','N','M',' ','m','a','p',' ','f','i','l','e','.',
/* 0x10cf8 = "VERR_VD_DISCARD_ALIGNMENT_NOT_MET" */
    '\x01','\xff','D','I','S','C','A','R','D','_','A','L','I','G','N','M','E','N','T','_','\x06','M','E','T',
/* 0x10d10 = "Descriptor CRC mismatch." */
    'D','e','s','c','r','i','p','t','o','r',' ','C','R','C',' ','m','i','s','m','a','t','c','h','.',
/* 0x10d28 = "Recompiler: Uninitialized variable." */
    '\x13','U','n','i','n','i','t','i','a','l','i','z','e','d',' ','v','a','r','i','a','b','l','e','.',
/* 0x10d40 = "The field contains a value that is out of range." */
    '\x03','f','i','e','l','d',' ','\x8a','a',' ','\xf5','\xad','\x0b','o','u','t',' ','\x15','r','a','n','g','e','.',
/* 0x10d58 = "VERR_RT_REQUEST_STATUS_FREED" */
    '\x01','R','T','_','R','E','Q','U','E','S','T','_','S','T','A','T','U','S','_','F','R','E','E','D',
/* 0x10d70 = "VERR_SUPDRV_TSC_FREQ_MEASUREMENT_FAILED" */
    '\x01','\x90','T','S','C','_','F','R','E','Q','_','M','E','A','S','U','R','E','M','E','N','T','_','\x17',
/* 0x10d88 = "Invalid segment:offset address." */
    '\x0c','s','e','g','m','e','n','t',':','o','f','f','s','e','t',' ','a','d','d','r','e','s','s','.',
/* 0x10da0 = "VERR_NET_PROTOCOL_NOT_AVAILABLE" */
    '\x01','N','E','T','_','P','R','O','T','O','C','O','L','_','\x06','A','V','A','I','L','A','B','L','E',
/* 0x10db8 = "VERR_SUPLIB_NT_PROCESS_UNTRUSTED_3" */
    '\x01','\xd6','N','T','_','P','R','O','C','E','S','S','_','U','N','T','R','U','S','T','E','D','_','3',
/* 0x10dd0 = "VERR_SUPLIB_NT_PROCESS_UNTRUSTED_5" */
    '\x01','\xd6','N','T','_','P','R','O','C','E','S','S','_','U','N','T','R','U','S','T','E','D','_','5',
/* 0x10de8 = "Invalid host interface version." */
    '\x0c','h','o','s','t',' ','i','n','t','e','r','f','a','c','e',' ','v','e','r','s','i','o','n','.',
/* 0x10e00 = "VERR_HOSTIF_FD_AND_INIT_TERM" */
    '\x01','H','O','S','T','I','F','_','F','D','_','A','N','D','_','I','N','I','T','_','T','E','R','M',
/* 0x10e18 = "VERR_VD_ISCSI_SECRET_ENCRYPTED" */
    '\x01','\xff','I','S','C','S','I','_','S','E','C','R','E','T','_','E','N','C','R','Y','P','T','E','D',
/* 0x10e30 = "Recompiler: Hit instruction buffer size limit." */
    '\x13','H','i','t',' ','\xda','b','u','f','f','e','r',' ','s','i','z','e',' ','l','i','m','i','t','.',
/* 0x10e48 = "VINF_GCM_HANDLED_ADVANCE_RIP" */
    '\x0e','G','C','M','_','H','A','N','D','L','E','D','_','A','D','V','A','N','C','E','_','R','I','P',
/* 0x10e60 = "Syntax error - out of scratch memory." */
    '\xfa','\x09','-',' ','o','u','t',' ','\x15','s','c','r','a','t','c','h',' ','m','e','m','o','r','y','.',
/* 0x10e78 = "VERR_PROC_ELEVATION_REQUIRED" */
    '\x01','P','R','O','C','_','E','L','E','V','A','T','I','O','N','_','R','E','Q','U','I','R','E','D',
/* 0x10e90 = "VERR_FAM_MONITOR_DIRECTORY_FAILED" */
    '\x01','F','A','M','_','M','O','N','I','T','O','R','_','D','I','R','E','C','T','O','R','Y','_','\x17',
/* 0x10ea8 = "VERR_GMM_HIT_VM_ACCOUNT_LIMIT" */
    '\x01','G','M','M','_','H','I','T','_','\xcd','_','A','C','C','O','U','N','T','_','L','I','M','I','T',
/* 0x10ec0 = "VERR_LDRPE_LOCK_PREFIX_TABLE" */
    '\x01','L','D','R','P','E','_','L','O','C','K','_','P','R','E','F','I','X','_','T','A','B','L','E',
/* 0X10ed8 = "Empty sub-string set inside X." */
    'm','p','t','y',' ','s','u','b','-','\xf2','s','e','t',' ','i','n','s','i','d','e',' ','X','.',
/* 0x10eef = "Certificate path validator: Unknown critical certificate extension." */
    '\xba','\xd0','\xfe','\xef','c','r','i','t','i','c','a','l',' ','\xa0','e','x','t','e','n','s','i','o','n','.',
/* 0x10f07 = "Unknown or unrecognized SVM exit." */
    '\xef','\xa9','u','n','r','e','c','o','g','n','i','z','e','d',' ','S','V','M',' ','e','x','i','t','.',
/* 0x10f1f = "FAM failed to open a connection." */
    'F','A','M',' ','\x99','\x0a','o','p','e','n',' ','a',' ','c','o','n','n','e','c','t','i','o','n','.',
/* 0x10f37 = "VERR_PDM_MEDIAEX_IOBUF_UNDERRUN" */
    '\x01','\x7d','M','E','D','I','A','E','X','_','I','O','B','U','F','_','U','N','D','E','R','R','U','N',
/* 0x10f4f = "The request is for something forbidden." */
    '\x03','\xaa','\x0b','\x10','s','o','m','e','t','h','i','n','g',' ','f','o','r','b','i','d','d','e','n','.',
/* 0x10f67 = "Unexpected cURL error configure the proxy." */
    '\x94','c','U','R','L',' ','\x09','c','o','n','f','i','g','u','r','e',' ','\x02','p','r','o','x','y','.',
/* 0x10f7f = "VERR_SUPDRV_SESSION_PROCESS_ENUM_ERROR" */
    '\x01','\x90','S','E','S','S','I','O','N','_','P','R','O','C','E','S','S','_','E','N','U','M','_','\x1b',
/* 0x10f97 = "VFS chain element takes exactly five arguments." */
    '\x8d',' ','\xa1','\x5c','t','a','k','e','s',' ','e','x','a','c','t','l','y',' ','f','i','v','e',' ','\xdd',
/* 0x10faf = "No buffer space available." */
    '\xdf','b','u','f','f','e','r',' ','s','p','a','c','e',' ','a','v','a','i','l','a','b','l','e','.',
/* 0x10fc7 = "A DWARF abbreviation was not found." */
    'A',' ','D','W','A','R','F',' ','a','b','b','r','e','v','i','a','t','i','o','n',' ','\x11','\x08','\x89',
/* 0x10fdf = "No CR3 root shadow page table." */
    '\xdf','C','R','3',' ','r','o','o','t',' ','s','h','a','d','o','w',' ','\xcc','t','a','b','l','e','.',
/* 0x10ff7 = "Hypervisor memory allocation failed." */
    'H','y','p','e','r','v','i','s','o','r',' ','\x86','a','l','l','o','c','a','t','i','o','n',' ','\x7b',
/* 0x1100f = "The timer was not in the correct state for the request operation." */
    '\x03','t','i','m','e','r',' ','\x11','\x08','\x0f','\x02','c','o','r','r','e','c','t',' ','\xca','\x10','\x02','\xaa','\xea',
/* 0x11027 = "VERR_SUPDRV_NO_RAW_MODE_HYPER_V_ROOT" */
    '\x01','\x90','\x60','R','A','W','_','M','O','D','E','_','H','Y','P','E','R','_','V','_','R','O','O','T',
/* 0x1103f = "VFS chain element takes exactly four arguments." */
    '\x8d',' ','\xa1','\x5c','t','a','k','e','s',' ','e','x','a','c','t','l','y',' ','f','o','u','r',' ','\xdd',
/* 0x11057 = "We are in driverless mode." */
    'W','e',' ','a','r','e',' ','\x0f','d','r','i','v','e','r','l','e','s','s',' ','m','o','d','e','.',
/* 0x1106f = "Nothing that can be cancelled." */
    'N','o','t','h','i','n','g',' ','\xad','c','a','n',' ','\xa7','c','a','n','c','e','l','l','e','d','.',
/* 0x11087 = "VERR_PGM_PCI_PASSTHRU_MISCONFIG" */
    '\x01','\x8c','P','C','I','_','P','A','S','S','T','H','R','U','_','M','I','S','C','O','N','F','I','G',
/* 0x1109f = "The DBGF has no more free breakpoint slots." */
    '\x03','\xb9',' ','\x5e','n','o',' ','m','o','r','e',' ','f','r','e','e',' ','\xbf','s','l','o','t','s','.',
/* 0x110b7 = "VERR_GIM_HYPERCALLS_NOT_ENABLED" */
    '\x01','G','I','M','_','H','Y','P','E','R','C','A','L','L','S','_','\x06','E','N','A','B','L','E','D',
/* 0x110cf = "VERR_ISOMK_IMPORT_DIR_REC_VOLUME_SEQ_NO" */
    '\x01','\x22','\x83','D','I','R','_','R','E','C','_','V','O','L','U','M','E','_','S','E','Q','_','N','O',
/* 0x110e7 = "VINF_EM_DBG_HYPER_BREAKPOINT" */
    '\x0e','E','M','_','D','B','G','_','H','Y','P','E','R','_','B','R','E','A','K','P','O','I','N','T',
/* 0x110ff = "Failed to read the device table entry from guest memory." */
    '\x8b','\x0a','r','e','a','d',' ','\x02','\xa3','\xb1','\xc8','f','r','o','m',' ','\xbb','m','e','m','o','r','y','.',
/* 0x11117 = "Internal error: Uninitialized status code." */
    '\x07','\xd8','U','n','i','n','i','t','i','a','l','i','z','e','d',' ','s','t','a','t','u','s',' ','\x84',
/* 0x1112f = "VERR_CR_PKIX_SIGNATURE_GE_KEY" */
    '\x01','\x24','P','K','I','X','_','S','I','G','N','A','T','U','R','E','_','G','E','_','K','E','Y',
/* 0x11146 = "VERR_VFS_CHAIN_AT_LEAST_THREE_ARGS" */
    '\x01','\x8d','_','\x8e','A','T','_','L','E','A','S','T','_','T','H','R','E','E','_','A','R','G','S',
/* 0X1115d = "Stream could not be created." */
    't','r','e','a','m',' ','c','o','u','l','d',' ','\x08','\xa7','c','r','e','a','t','e','d','.',
/* 0x11173 = "The TCP server was destroyed." */
    '\x03','T','C','P',' ','s','e','r','v','e','r',' ','\x11','d','e','s','t','r','o','y','e','d','.',
/* 0x1118a = "VERR_MANIFEST_WRONG_FILE_FORMAT" */
    '\x01','M','A','N','I','F','E','S','T','_','W','R','O','N','G','_','\xab','F','O','R','M','A','T',
/* 0x111a1 = "VERR_SUPDRV_HARDENING_EVIL_HANDLE" */
    '\x01','\x90','H','A','R','D','E','N','I','N','G','_','E','V','I','L','_','H','A','N','D','L','E',
/* 0x111b8 = "VERR_SVM_HOST_SVME_NOT_ENABLED" */
    '\x01','S','V','M','_','H','O','S','T','_','S','V','M','E','_','\x06','E','N','A','B','L','E','D',
/* 0x111cf = "VFS chain element takes exactly two arguments." */
    '\x8d',' ','\xa1','\x5c','t','a','k','e','s',' ','e','x','a','c','t','l','y',' ','t','w','o',' ','\xdd',
/* 0x111e6 = "The semaphore cannot be set again." */
    '\x03','s','e','m','a','p','h','o','r','e',' ','\xd1','\xa7','s','e','t',' ','a','g','a','i','n','.',
/* 0x111fd = "The command has already been registered." */
    '\x03','c','o','m','m','a','n','d',' ','\x5e','\x7f','\xcb','r','e','g','i','s','t','e','r','e','d','.',
/* 0x11214 = "VERR_LDR_IMPORTED_SYMBOL_NOT_FOUND" */
    '\x01','L','D','R','_','I','M','P','O','R','T','E','D','_','S','Y','M','B','O','L','_','\x06','\x2a',
/* 0x1122b = "VERR_PDM_HIF_SHARING_VIOLATION" */
    '\x01','\x7d','H','I','F','_','S','H','A','R','I','N','G','_','V','I','O','L','A','T','I','O','N',
/* 0x11242 = "The attribute type did not match." */
    '\x03','a','t','t','r','i','b','u','t','e',' ','\xf3','d','i','d',' ','\x08','m','a','t','c','h','.',
/* 0x11259 = "VINF_EM_RAW_INTERRUPT_HYPER" */
    '\x0e','E','M','_','R','A','W','_','I','N','T','E','R','R','U','P','T','_','H','Y','P','E','R',
/* 0x11270 = "VERR_VM_REQUEST_STATUS_FREED" */
    '\x01','\xcd','_','R','E','Q','U','E','S','T','_','S','T','A','T','U','S','_','F','R','E','E','D',
/* 0x11287 = "VERR_VRDP_INSUFFICIENT_DATA" */
    '\x01','V','R','D','P','_','I','N','S','U','F','F','I','C','I','E','N','T','_','D','A','T','A',
/* 0x1129e = "The machine is not on the network." */
    '\x03','m','a','c','h','i','n','e',' ','\x0b','\x08','o','n',' ','\x02','n','e','t','w','o','r','k','.',
/* 0x112b5 = "VERR_TM_VIRTUAL_TICKING_IPE" */
    '\x01','T','M','_','V','I','R','T','U','A','L','_','T','I','C','K','I','N','G','_','I','P','E',
/* 0x112cc = "VERR_CR_CIPHER_OSSL_GET_TAG_FAILED" */
    '\x01','\x24','C','I','P','H','E','R','_','O','S','S','L','_','G','E','T','_','T','A','G','_','\x17',
/* 0x112e3 = "Failed to get a guest page which is expected to be present." */
    '\x8b','\x0a','g','e','t',' ','a',' ','\xbb','\xcc','\xed','\x0b','\xc9','\x0a','\xa7','p','r','e','s','e','n','t','.',
/* 0x112fa = "Hit the a VM account limit." */
    'H','i','t',' ','\x02','a',' ','\xcd',' ','a','c','c','o','u','n','t',' ','l','i','m','i','t','.',
/* 0x11311 = "Unsupported key encryption cipher." */
    '\x98','k','e','y',' ','e','n','c','r','y','p','t','i','o','n',' ','c','i','p','h','e','r','.',
/* 0x11328 = "VERR_CR_X509_CPV_NO_PERMITTED_NAMES" */
    '\x01','\x24','\xb7','C','P','V','_','\x60','P','E','R','M','I','T','T','E','D','_','N','A','M','E','S',
/* 0x1133f = "VERR_AUTHENTICATION_FAILURE" */
    '\x01','A','U','T','H','E','N','T','I','C','A','T','I','O','N','_','F','A','I','L','U','R','E',
/* 0x11356 = "VERR_CR_X509_NAME_MISSING_RDN_MAP_ENTRY" */
    '\x01','\x24','\xb7','N','A','M','E','_','\xc4','_','R','D','N','_','M','A','P','_','E','N','T','R','Y',
/* 0x1136d = "The UDP server was destroyed." */
    '\x03','U','D','P',' ','s','e','r','v','e','r',' ','\x11','d','e','s','t','r','o','y','e','d','.',
/* 0x11384 = "The iterator reached the end." */
    '\x03','i','t','e','r','a','t','o','r',' ','r','e','a','c','h','e','d',' ','\x02','e','n','d','.',
/* 0x1139b = "Inserting a new chunk failed." */
    'I','n','s','e','r','t','i','n','g',' ','a',' ','n','e','w',' ','c','h','u','n','k',' ','\x7b',
/* 0x113b2 = "The field contains an invalid padding size." */
    '\x03','f','i','e','l','d',' ','\x8a','\x87','\x8f','p','a','d','d','i','n','g',' ','s','i','z','e','.',
/* 0x113c9 = "Reason for leaving RZ: Pending MMIO write." */
    '\x93','\x10','\x81','R','Z',':',' ','P','e','n','d','i','n','g',' ','\xd3',' ','w','r','i','t','e','.',
/* 0x113e0 = "VERR_CR_PKCS7_SIGNER_CERT_NOT_SHIPPED" */
    '\x01','\x24','\xe5','S','I','G','N','E','R','_','C','E','R','T','_','\x06','S','H','I','P','P','E','D',
/* 0x113f7 = "Remapping failed for the interrupt." */
    'R','e','m','a','p','p','i','n','g',' ','\x99','\x10','\x02','i','n','t','e','r','r','u','p','t','.',
/* 0x1140e = "Import ISO contains a bad root directory record." */
    '\xc3','\xc1',' ','\x8a','a',' ','b','a','d',' ','r','o','o','t',' ','\x25','r','e','c','o','r','d','.',
/* 0x11425 = "Symbolic link not allowed." */
    'S','y','m','b','o','l','i','c',' ','l','i','n','k',' ','\x08','a','l','l','o','w','e','d','.',
/* 0x1143c = "Certificate path validator: The certificate is not valid at the specified time." */
    '\xba','\xd0','\xfe','\x03','\xa0','\x0b','\x08','v','a','l','i','d',' ','a','t',' ','\x02','\x18','t','i','m','e','.',
/* 0x11453 = "VERR_DBG_FILE_NAME_OUT_OF_RANGE" */
    '\x01','D','B','G','_','\xab','N','A','M','E','_','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x1146a = "VINF_EM_DBG_HYPER_ASSERTION" */
    '\x0e','E','M','_','D','B','G','_','H','Y','P','E','R','_','A','S','S','E','R','T','I','O','N',
/* 0x11481 = "VERR_SUPDRV_TRACER_UMOD_NOT_ADJACENT" */
    '\x01','\x90','T','R','A','C','E','R','_','U','M','O','D','_','\x06','A','D','J','A','C','E','N','T',
/* 0x11498 = "VINF_EM_RAW_RING_SWITCH_INT" */
    '\x0e','E','M','_','R','A','W','_','R','I','N','G','_','S','W','I','T','C','H','_','I','N','T',
/* 0x114af = "No parent node specified." */
    '\xdf','p','a','r','e','n','t',' ','n','o','d','e',' ','s','p','e','c','i','f','i','e','d','.',
/* 0x114c6 = "VERR_GIM_HYPERCALL_MEMORY_READ_FAILED" */
    '\x01','G','I','M','_','H','Y','P','E','R','C','A','L','L','_','\xb6','_','R','E','A','D','_','\x17',
/* 0x114dd = "iSCSI: Invalid device type (not a disk)." */
    'i','S','C','S','I',':',' ','\x0c','\xa3','\xf3','(','n','o','t',' ','a',' ','d','i','s','k',')','.',
/* 0x114f4 = "Error creating digest algorithm calculator." */
    '\xc0','c','r','e','a','t','i','n','g',' ','\xd7','\xd4','c','a','l','c','u','l','a','t','o','r','.',
/* 0x1150b = "VERR_PDM_DEV_HEAP_R3_TO_GCPHYS" */
    '\x01','\x7d','D','E','V','_','H','E','A','P','_','R','3','_','T','O','_','G','C','P','H','Y','S',
/* 0x11522 = "VERR_SUP_VP_NT_QI_VIRTUAL_MEMORY_NM_ERROR" */
    '\x01','\x95','\xbd','N','T','_','Q','I','_','V','I','R','T','U','A','L','_','\xb6','_','N','M','_','\x1b',
/* 0x11539 = "VERR_LDRPE_CERT_UNSUPPORTED" */
    '\x01','L','D','R','P','E','_','C','E','R','T','_','U','N','S','U','P','P','O','R','T','E','D',
/* 0X11550 = "Duplicate segment name." */
    'u','p','l','i','c','a','t','e',' ','s','e','g','m','e','n','t',' ','n','a','m','e','.',
/* 0x11566 = "VERR_NET_CONNECTION_ABORTED" */
    '\x01','N','E','T','_','C','O','N','N','E','C','T','I','O','N','_','A','B','O','R','T','E','D',
/* 0x1157d = "Too many clients for the service." */
    'T','o','o',' ','\xb4','c','l','i','e','n','t','s',' ','\x10','\x02','s','e','r','v','i','c','e','.',
/* 0x11594 = "VERR_RECORDING_CODEC_INIT_FAILED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','C','O','D','E','C','_','I','N','I','T','_','\x17',
/* 0x115ab = "Temporary place holder." */
    'T','e','m','p','o','r','a','r','y',' ','p','l','a','c','e',' ','h','o','l','d','e','r','.',
/* 0x115c2 = "VERR_PDM_CRITSECTRW_MISALIGNED" */
    '\x01','\x7d','C','R','I','T','S','E','C','T','R','W','_','M','I','S','A','L','I','G','N','E','D',
/* 0x115d9 = "VERR_CPUM_TOO_MANY_CPUID_SUBLEAVES" */
    '\x01','C','P','U','M','_','\x1a','\xac','C','P','U','I','D','_','S','U','B','L','E','A','V','E','S',
/* 0x115f0 = "No logical volume descriptors found." */
    '\xdf','l','o','g','i','c','a','l',' ','\xd2','d','e','s','c','r','i','p','t','o','r','s',' ','\x89',
/* 0x11607 = "VERR_CR_PKIX_NOT_RSA_PRIVATE_KEY" */
    '\x01','\x24','P','K','I','X','_','\x06','R','S','A','_','P','R','I','V','A','T','E','_','K','E','Y',
/* 0x1161e = "VERR_SELM_LDT_OUT_OF_BOUNDS" */
    '\x01','S','E','L','M','_','L','D','T','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x11635 = "No end of central directory record found." */
    '\xdf','e','n','d',' ','\x15','c','e','n','t','r','a','l',' ','\x25','r','e','c','o','r','d',' ','\x89',
/* 0x1164c = "Client limit has been reached." */
    'C','l','i','e','n','t',' ','l','i','m','i','t',' ','\x5e','\xcb','r','e','a','c','h','e','d','.',
/* 0x11663 = "Device or resource is busy." */
    'D','e','v','i','c','e',' ','\xa9','r','e','s','o','u','r','c','e',' ','\x0b','b','u','s','y','.',
/* 0x1167a = "VINF_CPUM_HOST_CR0_MODIFIED" */
    '\x0e','C','P','U','M','_','H','O','S','T','_','C','R','0','_','M','O','D','I','F','I','E','D',
/* 0x11691 = "The loaded XCR0 register value is not valid." */
    '\x03','l','o','a','d','e','d',' ','X','C','R','0',' ','\xeb','\xf5','\x0b','\x08','v','a','l','i','d','.',
/* 0x116a8 = "Authentication failure." */
    'A','u','t','h','e','n','t','i','c','a','t','i','o','n',' ','f','a','i','l','u','r','e','.',
/* 0x116bf = "VERR_INTNET_FLT_VNIC_OPEN_FAILED" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','V','N','I','C','_','O','P','E','N','_','\x17',
/* 0x116d6 = "VERR_NET_PROTOCOL_FAMILY_NOT_SUPPORTED" */
    '\x01','N','E','T','_','P','R','O','T','O','C','O','L','_','F','A','M','I','L','Y','_','\x06','\x82',
/* 0x116ed = "VERR_VFS_CHAIN_ONLY_FILE_OR_IOS_OR_DIR" */
    '\x01','\x8d','_','\x8e','O','N','L','Y','_','\xab','O','R','_','I','O','S','_','O','R','_','D','I','R',
/* 0x11704 = "VERR_NET_ADDRESS_NOT_AVAILABLE" */
    '\x01','N','E','T','_','A','D','D','R','E','S','S','_','\x06','A','V','A','I','L','A','B','L','E',
/* 0x1171b = "No primary volume descriptors found." */
    '\xdf','p','r','i','m','a','r','y',' ','\xd2','d','e','s','c','r','i','p','t','o','r','s',' ','\x89',
/* 0x11732 = "Bad mutex semaphore flags." */
    '\x9f','m','u','t','e','x',' ','s','e','m','a','p','h','o','r','e',' ','f','l','a','g','s','.',
/* 0x11749 = "VERR_OUT_OF_SELECTOR_BOUNDS" */
    '\x01','O','U','T','_','O','F','_','S','E','L','E','C','T','O','R','_','B','O','U','N','D','S',
/* 0x11760 = "VERR_IPE_NOT_REACHED_DEFAULT_CASE" */
    '\x01','\x14','\x06','R','E','A','C','H','E','D','_','D','E','F','A','U','L','T','_','C','A','S','E',
/* 0x11777 = "VINF_CR_DIGEST_SEVERELY_COMPROMISED" */
    '\x0e','\x24','\xbe','S','E','V','E','R','E','L','Y','_','C','O','M','P','R','O','M','I','S','E','D',
/* 0x1178e = "Unable to open the host interface." */
    '\xe0','\x0a','o','p','e','n',' ','\x02','h','o','s','t',' ','i','n','t','e','r','f','a','c','e','.',
/* 0x117a5 = "VERR_PKZIP_ZIP64EX_IN_ZIP32" */
    '\x01','P','K','Z','I','P','_','Z','I','P','6','4','E','X','_','I','N','_','Z','I','P','3','2',
/* 0x117bc = "VERR_VMM_FN_NOT_SUPPORTED_FOR_VMTARGET" */
    '\x01','V','M','M','_','F','N','_','\x06','\x82','_','F','O','R','_','V','M','T','A','R','G','E','T',
/* 0x117d3 = "VMDK: Image property not found." */
    'V','M','D','K',':',' ','I','m','a','g','e',' ','p','r','o','p','e','r','t','y',' ','\x08','\x89',
/* 0x117ea = "A tracer has already been registered." */
    'A',' ','t','r','a','c','e','r',' ','\x5e','\x7f','\xcb','r','e','g','i','s','t','e','r','e','d','.',
/* 0x11801 = "Unable to parse the XML in DMG file." */
    '\xe0','\x0a','p','a','r','s','e',' ','\x02','X','M','L',' ','\x0f','D','M','G',' ','f','i','l','e','.',
/* 0x11818 = "The loaded XSAVE header is not valid." */
    '\x03','l','o','a','d','e','d',' ','X','S','A','V','E',' ','\xb3','\x0b','\x08','v','a','l','i','d','.',
/* 0x1182f = "Bad size element in table of content sub-element." */
    '\x9f','s','i','z','e',' ','\x5c','\x0f','\xb1','\x15','\xf0','s','u','b','-','e','l','e','m','e','n','t','.',
/* 0x11846 = "VFS chain element takes exactly six arguments." */
    '\x8d',' ','\xa1','\x5c','t','a','k','e','s',' ','e','x','a','c','t','l','y',' ','s','i','x',' ','\xdd',
/* 0x1185d = "VINF_VGA_RESIZE_IN_PROGRESS" */
    '\x0e','V','G','A','_','R','E','S','I','Z','E','_','I','N','_','P','R','O','G','R','E','S','S',
/* 0x11874 = "VERR_X509_READING_CERT_FROM_BIO" */
    '\x01','\xb7','R','E','A','D','I','N','G','_','C','E','R','T','_','F','R','O','M','_','B','I','O',
/* 0x1188b = "Reason for leaving RZ: Ring-3 operation pending." */
    '\x93','\x10','\x81','R','Z',':',' ','R','i','n','g','-','3',' ','\x96','p','e','n','d','i','n','g','.',
/* 0x118a2 = "VERR_PGM_MAPPINGS_FIX_REJECTED" */
    '\x01','\x8c','M','A','P','P','I','N','G','S','_','F','I','X','_','R','E','J','E','C','T','E','D',
/* 0x118b9 = "VERR_ISOMK_IMPORT_LOGICAL_BLOCK_SIZE_NOT_2KB" */
    '\x01','\x22','\x83','L','O','G','I','C','A','L','_','B','L','O','C','K','_','\xf9','_','\x06','2','K','B',
/* 0x118d0 = "VERR_SEM_LV_ILLEGAL_UPGRADE" */
    '\x01','S','E','M','_','L','V','_','I','L','L','E','G','A','L','_','U','P','G','R','A','D','E',
/* 0x118e7 = "VERR_ASN1_TIME_BAD_NORMALIZE_INPUT" */
    '\x01','\xa2','T','I','M','E','_','\x1d','N','O','R','M','A','L','I','Z','E','_','I','N','P','U','T',
/* 0x118fe = "Failed to obtain the GMM instance." */
    '\x8b','\x0a','o','b','t','a','i','n',' ','\x02','G','M','M',' ','i','n','s','t','a','n','c','e','.',
/* 0x11915 = "VERR_NET_CONNECTION_REFUSED" */
    '\x01','N','E','T','_','C','O','N','N','E','C','T','I','O','N','_','R','E','F','U','S','E','D',
/* 0x1192c = "Page directory pointer not present." */
    'P','a','g','e',' ','\x25','p','o','i','n','t','e','r',' ','\x08','p','r','e','s','e','n','t','.',
/* 0x11943 = "VERR_SUP_VP_SET_HANDLE_NOINHERIT" */
    '\x01','\x95','\xbd','S','E','T','_','H','A','N','D','L','E','_','N','O','I','N','H','E','R','I','T',
/* 0x1195a = "Invalid offset in an L4 dataspace." */
    '\x0c','o','f','f','s','e','t',' ','\x0f','\x87','L','4',' ','d','a','t','a','s','p','a','c','e','.',
/* 0x11971 = "VERR_GSTCTL_PROCESS_WRONG_STATE" */
    '\x01','G','S','T','C','T','L','_','P','R','O','C','E','S','S','_','W','R','O','N','G','_','\xf1',
/* 0x11988 = "VERR_NEM_QUERY_DIRTY_BITMAP_FAILED" */
    '\x01','\xee','_','Q','U','E','R','Y','_','D','I','R','T','Y','_','B','I','T','M','A','P','_','\x17',
/* 0x1199f = "VERR_SYS_UNSUPPORTED_FIRMWARE_PROPERTY" */
    '\x01','S','Y','S','_','\x1c','F','I','R','M','W','A','R','E','_','P','R','O','P','E','R','T','Y',
/* 0x119b6 = "The device doesn't support runtime driver attaching." */
    '\x03','\xa3','\xc7','\xce','r','u','n','t','i','m','e',' ','\xc5','a','t','t','a','c','h','i','n','g','.',
/* 0x119cd = "VERR_CR_X509_CERT_TBS_SIGN_ALGO_MISMATCH" */
    '\x01','\x24','\xb7','C','E','R','T','_','T','B','S','_','S','I','G','N','_','A','L','G','O','_','\x19',
/* 0x119e4 = "VERR_PGM_MAPPINGS_FIX_CONFLICT" */
    '\x01','\x8c','M','A','P','P','I','N','G','S','_','F','I','X','_','C','O','N','F','L','I','C','T',
/* 0x119fb = "VFS chain element takes a file object as input." */
    '\x8d',' ','\xa1','\x5c','t','a','k','e','s',' ','a',' ','\x1f','\xa8','a','s',' ','i','n','p','u','t','.',
/* 0x11a12 = "Connection reset by peer." */
    'C','o','n','n','e','c','t','i','o','n',' ','r','e','s','e','t',' ','\xe1','p','e','e','r','.',
/* 0x11a29 = "VERR_SUP_VP_WINTRUST_CAT_FAILURE" */
    '\x01','\x95','\xbd','W','I','N','T','R','U','S','T','_','C','A','T','_','F','A','I','L','U','R','E',
/* 0x11a40 = "VERR_SUP_VP_IMAGE_MAPPING_BASE_ERROR" */
    '\x01','\x95','\xbd','I','M','A','G','E','_','M','A','P','P','I','N','G','_','B','A','S','E','_','\x1b',
/* 0x11a57 = "Process Purification Failure: KERNE32." */
    '\x1e','P','u','r','i','f','i','c','a','t','i','o','n',' ','\x12','K','E','R','N','E','3','2','.',
/* 0x11a6e = "VERR_HTTP_CURL_PROXY_CONFIG" */
    '\x01','H','T','T','P','_','C','U','R','L','_','P','R','O','X','Y','_','C','O','N','F','I','G',
/* 0x11a85 = "VERR_INTNET_FLT_VNIC_INIT_FAILED" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','V','N','I','C','_','I','N','I','T','_','\x17',
/* 0x11a9c = "There is more data available." */
    'T','h','e','r','e',' ','\x0b','m','o','r','e',' ','\x9d','a','v','a','i','l','a','b','l','e','.',
/* 0x11ab3 = "VERR_SUP_VP_SECTION_PROTECTION_MISMATCH" */
    '\x01','\x95','\xbd','S','E','C','T','I','O','N','_','P','R','O','T','E','C','T','I','O','N','_','\x19',
/* 0x11aca = "The driver doesn't support runtime driver attaching." */
    '\x03','\xc5','\xc7','\xce','r','u','n','t','i','m','e',' ','\xc5','a','t','t','a','c','h','i','n','g','.',
/* 0x11ae1 = "Failed to initialize a memory object." */
    '\x8b','\x0a','i','n','i','t','i','a','l','i','z','e',' ','a',' ','\x86','o','b','j','e','c','t','.',
/* 0x11af8 = "VERR_IOM_MMIO_HANDLER_DISASM_ERROR" */
    '\x01','I','O','M','_','\xd3','_','H','A','N','D','L','E','R','_','D','I','S','A','S','M','_','\x1b',
/* 0x11b0f = "VINF_SSM_VOTE_FOR_ANOTHER_PASS" */
    '\x0e','\xb0','V','O','T','E','_','F','O','R','_','A','N','O','T','H','E','R','_','P','A','S','S',
/* 0X11b26 = "SyncPage modified the PDE." */
    'y','n','c','P','a','g','e',' ','m','o','d','i','f','i','e','d',' ','\x02','P','D','E','.',
/* 0x11b3c = "Error formatting an extension." */
    '\xc0','f','o','r','m','a','t','t','i','n','g',' ','\x87','e','x','t','e','n','s','i','o','n','.',
/* 0x11b53 = "VERR_BIGNUM_SENSITIVE_INPUT" */
    '\x01','B','I','G','N','U','M','_','S','E','N','S','I','T','I','V','E','_','I','N','P','U','T',
/* 0x11b6a = "VERR_GIM_DEVICE_NOT_REGISTERED" */
    '\x01','G','I','M','_','D','E','V','I','C','E','_','\x06','R','E','G','I','S','T','E','R','E','D',
/* 0x11b81 = "Unsupported VRDP protocol feature." */
    '\x98','V','R','D','P',' ','p','r','o','t','o','c','o','l',' ','f','e','a','t','u','r','e','.',
/* 0x11b98 = "Encountered an unknown load command." */
    '\xa5','\x87','u','n','k','n','o','w','n',' ','l','o','a','d',' ','c','o','m','m','a','n','d','.',
/* 0x11baf = "VINF_PGM_SYNCPAGE_MODIFIED_PDE" */
    '\x0e','\x8c','S','Y','N','C','P','A','G','E','_','M','O','D','I','F','I','E','D','_','P','D','E',
/* 0x11bc6 = "Too deep ICB recursion." */
    'T','o','o',' ','d','e','e','p',' ','I','C','B',' ','r','e','c','u','r','s','i','o','n','.',
/* 0x11bdd = "No configuration value exists." */
    '\xdf','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','\xf5','e','x','i','s','t','s','.',
/* 0x11bf4 = "VERR_CR_DIGEST_SEVERELY_COMPROMISED" */
    '\x01','\x24','\xbe','S','E','V','E','R','E','L','Y','_','C','O','M','P','R','O','M','I','S','E','D',
/* 0x11c0b = "VERR_HARDAVL_STACK_OVERFLOW" */
    '\x01','H','A','R','D','A','V','L','_','S','T','A','C','K','_','O','V','E','R','F','L','O','W',
/* 0x11c22 = "VERR_ISOMK_IMPORT_BAD_ROOT_DIR_REC_LENGTH" */
    '\x01','\x22','\x83','\x1d','R','O','O','T','_','D','I','R','_','R','E','C','_','L','E','N','G','T','H',
/* 0x11c39 = "Guest process is in a wrong state." */
    'G','u','e','s','t',' ','\x92','\x0b','\x0f','a',' ','w','r','o','n','g',' ','s','t','a','t','e','.',
/* 0x11c50 = "Trying to seek on device." */
    'T','r','y','i','n','g',' ','\x0a','s','e','e','k',' ','o','n',' ','d','e','v','i','c','e','.',
/* 0x11c67 = "VERR_PGM_WRITE_MONITOR_ENGAGED" */
    '\x01','\x8c','W','R','I','T','E','_','M','O','N','I','T','O','R','_','E','N','G','A','G','E','D',
/* 0x11c7e = "VERR_CR_CIPHER_OSSL_SET_TAG_FAILED" */
    '\x01','\x24','C','I','P','H','E','R','_','O','S','S','L','_','S','E','T','_','T','A','G','_','\x17',
/* 0x11c95 = "VERR_IOM_INCOMPLETE_MMIO_RANGE" */
    '\x01','I','O','M','_','I','N','C','O','M','P','L','E','T','E','_','\xd3','_','R','A','N','G','E',
/* 0X11cac = "Entry in a boot catalog section is empty." */
    'n','t','r','y',' ','\x0f','a',' ','b','o','o','t',' ','\xe7','\xdb','\x0b','e','m','p','t','y','.',
/* 0x11cc2 = "VERR_CR_PKCS7_SIGNED_DATA_NO_DIGEST_ALGOS" */
    '\x01','\x24','\xe5','S','I','G','N','E','D','_','D','A','T','A','_','\x60','\xbe','A','L','G','O','S',
/* 0x11cd8 = "VERR_CR_PKCS7_SIGNED_DATA_CERT_NOT_FOUND" */
    '\x01','\x24','\xe5','S','I','G','N','E','D','_','D','A','T','A','_','C','E','R','T','_','\x06','\x2a',
/* 0x11cee = "The component factory was not found." */
    '\x03','c','o','m','p','o','n','e','n','t',' ','f','a','c','t','o','r','y',' ','\x11','\x08','\x89',
/* 0x11d04 = "VERR_GMM_MODULE_NAME_TOO_LONG" */
    '\x01','G','M','M','_','M','O','D','U','L','E','_','N','A','M','E','_','\x1a','L','O','N','G',
/* 0x11d1a = "VERR_VFS_CHAIN_TRAILING_SEPARATOR" */
    '\x01','\x8d','_','\x8e','T','R','A','I','L','I','N','G','_','S','E','P','A','R','A','T','O','R',
/* 0x11d30 = "VERR_REST_RESPONSE_INVALID_UTF8_ENCODING" */
    '\x01','R','E','S','T','_','R','E','S','P','O','N','S','E','_','\x05','U','T','F','8','_','\xc6',
/* 0x11d46 = "Expected a different time tag." */
    '\xb8','a',' ','d','i','f','f','e','r','e','n','t',' ','t','i','m','e',' ','t','a','g','.',
/* 0x11d5c = "The guest has reported too many modules." */
    '\x03','\xbb','\x5e','r','e','p','o','r','t','e','d',' ','\x9e','\xb4','m','o','d','u','l','e','s','.',
/* 0x11d72 = "VERR_NET_ADDRESS_FAMILY_NOT_SUPPORTED" */
    '\x01','N','E','T','_','A','D','D','R','E','S','S','_','F','A','M','I','L','Y','_','\x06','\x82',
/* 0x11d88 = "VERR_SUP_VP_NO_IMAGE_MAPPING_NAME" */
    '\x01','\x95','\xbd','\x60','I','M','A','G','E','_','M','A','P','P','I','N','G','_','N','A','M','E',
/* 0x11d9e = "VERR_PGM_SAVED_MMIO2_RANGE_NOT_FOUND" */
    '\x01','\x8c','S','A','V','E','D','_','M','M','I','O','2','_','R','A','N','G','E','_','\x06','\x2a',
/* 0x11db4 = "File or directory can\'t be created." */
    'F','i','l','e',' ','\xa9','\x25','c','a','n','\'','t',' ','\xa7','c','r','e','a','t','e','d','.',
/* 0x11dca = "VERR_GIM_NO_DEBUG_CONNECTION" */
    '\x01','G','I','M','_','\x60','D','E','B','U','G','_','C','O','N','N','E','C','T','I','O','N',
/* 0x11de0 = "Guest side reported an error." */
    'G','u','e','s','t',' ','s','i','d','e',' ','r','e','p','o','r','t','e','d',' ','\x87','\x85',
/* 0x11df6 = "Wrong parameter count." */
    'W','r','o','n','g',' ','p','a','r','a','m','e','t','e','r',' ','c','o','u','n','t','.',
/* 0x11e0c = "VERR_PDM_CRITSECTRW_TOO_MANY_WRITERS" */
    '\x01','\x7d','C','R','I','T','S','E','C','T','R','W','_','\x1a','\xac','W','R','I','T','E','R','S',
/* 0x11e22 = "Process Verification Failure: Error allocating memory." */
    '\x1e','\x0d','\x12','\xc0','a','l','l','o','c','a','t','i','n','g',' ','m','e','m','o','r','y','.',
/* 0x11e38 = "VERR_IPE_UNINITIALIZED_STATUS" */
    '\x01','\x14','U','N','I','N','I','T','I','A','L','I','Z','E','D','_','S','T','A','T','U','S',
/* 0x11e4e = "I/O ports are already mapped." */
    'I','/','O',' ','p','o','r','t','s',' ','a','r','e',' ','\x7f','m','a','p','p','e','d','.',
/* 0x11e64 = "Nested paging not active." */
    'N','e','s','t','e','d',' ','p','a','g','i','n','g',' ','\x08','a','c','t','i','v','e','.',
/* 0x11e7a = "VERR_DBGC_COMMANDS_NOT_REGISTERED" */
    '\x01','\xfc','C','O','M','M','A','N','D','S','_','\x06','R','E','G','I','S','T','E','R','E','D',
/* 0X11e90 = "Device i/o: Not ready." */
    'e','v','i','c','e',' ','i','/','o',':',' ','N','o','t',' ','r','e','a','d','y','.',
/* 0x11ea5 = "No unwind information was found." */
    '\xdf','u','n','w','i','n','d',' ','i','n','f','o','r','m','a','t','i','o','n',' ','\x11','\x89',
/* 0x11ebb = "VWRN_ENV_NOT_FULLY_TRANSLATED" */
    '\xe6','E','N','V','_','\x06','F','U','L','L','Y','_','T','R','A','N','S','L','A','T','E','D',
/* 0x11ed1 = "VERR_WRONG_PARAMETER_COUNT" */
    '\x01','W','R','O','N','G','_','P','A','R','A','M','E','T','E','R','_','C','O','U','N','T',
/* 0x11ee7 = "Is a character device." */
    'I','s',' ','a',' ','c','h','a','r','a','c','t','e','r',' ','d','e','v','i','c','e','.',
/* 0x11efd = "VERR_PDM_CRITSECTRW_TOO_MANY_READERS" */
    '\x01','\x7d','C','R','I','T','S','E','C','T','R','W','_','\x1a','\xac','R','E','A','D','E','R','S',
/* 0x11f13 = "VERR_FDT_DTB_HDR_SIZE_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','H','D','R','_','\xf9','_','I','N','V','A','L','I','D',
/* 0x11f29 = "Codec initialization failed." */
    'C','o','d','e','c',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','\x7b',
/* 0x11f3f = "VINF_EM_RAW_STALE_SELECTOR" */
    '\x0e','E','M','_','R','A','W','_','S','T','A','L','E','_','S','E','L','E','C','T','O','R',
/* 0x11f55 = "Async command pending." */
    'A','s','y','n','c',' ','c','o','m','m','a','n','d',' ','p','e','n','d','i','n','g','.',
/* 0x11f6b = "VERR_ISOFS_BOGUS_NEXT_AD_LENGTH" */
    '\x01','\x97','B','O','G','U','S','_','N','E','X','T','_','A','D','_','L','E','N','G','T','H',
/* 0x11f81 = "Bad VTG probe descriptor." */
    '\x9f','V','T','G',' ','p','r','o','b','e',' ','d','e','s','c','r','i','p','t','o','r','.',
/* 0x11f97 = "VERR_LDRLX_BAD_LOADER_SECTION" */
    '\x01','L','D','R','L','X','_','\x1d','L','O','A','D','E','R','_','S','E','C','T','I','O','N',
/* 0x11fad = "VERR_PDM_INVALID_DEVICE_REGISTRATION" */
    '\x01','\x7d','\x05','D','E','V','I','C','E','_','R','E','G','I','S','T','R','A','T','I','O','N',
/* 0x11fc3 = "The page to be freed or updated was not found." */
    '\x03','\xcc','\x0a','\xa7','f','r','e','e','d',' ','\xa9','u','p','d','a','t','e','d',' ','\x11','\x08','\x89',
/* 0x11fd9 = "The saved state directory magic is wrong." */
    '\x03','s','a','v','e','d',' ','\xca','\x25','m','a','g','i','c',' ','\x0b','w','r','o','n','g','.',
/* 0x11fef = "RTGetOpt: Not an option." */
    'R','T','G','e','t','O','p','t',':',' ','N','o','t',' ','\x87','o','p','t','i','o','n','.',
/* 0x12005 = "Unable to switch due to invalid guest state." */
    '\xe0','\x0a','s','w','i','t','c','h',' ','d','u','e',' ','\x0a','\x8f','\xbb','s','t','a','t','e','.',
/* 0x1201b = "VERR_CR_SPC_PEIMAGE_NO_CONTENT" */
    '\x01','\x24','S','P','C','_','P','E','I','M','A','G','E','_','\x60','C','O','N','T','E','N','T',
/* 0x12031 = "The MMIO range specified for removal was not found." */
    '\x03','\xd3',' ','r','a','n','g','e',' ','\x18','\x10','r','e','m','o','v','a','l',' ','\x11','\x08','\x89',
/* 0x12047 = "VERR_CR_PKIX_NOT_RSA_PUBLIC_KEY" */
    '\x01','\x24','P','K','I','X','_','\x06','R','S','A','_','P','U','B','L','I','C','_','K','E','Y',
/* 0x1205d = "Attempt to divide by zero." */
    'A','t','t','e','m','p','t',' ','\x0a','d','i','v','i','d','e',' ','\xe1','z','e','r','o','.',
/* 0x12073 = "VINF_EM_HM_PATCH_TPR_INSTR" */
    '\x0e','E','M','_','H','M','_','P','A','T','C','H','_','T','P','R','_','I','N','S','T','R',
/* 0x12089 = "The value was zero extended to fit." */
    '\x03','\xf5','\x11','z','e','r','o',' ','e','x','t','e','n','d','e','d',' ','\x0a','f','i','t','.',
/* 0x1209f = "The type of media was not recognized." */
    '\x03','\xf3','\x15','m','e','d','i','a',' ','\x11','\x08','r','e','c','o','g','n','i','z','e','d','.',
/* 0x120b5 = "VINF_SVM_INTERCEPT_NOT_ACTIVE" */
    '\x0e','S','V','M','_','I','N','T','E','R','C','E','P','T','_','\x06','A','C','T','I','V','E',
/* 0x120cb = "VINF_PGM_PHYS_TLB_CATCH_WRITE" */
    '\x0e','\x8c','P','H','Y','S','_','T','L','B','_','C','A','T','C','H','_','W','R','I','T','E',
/* 0x120e1 = "VERR_TRPM_SHADOW_IDT_WRITE" */
    '\x01','T','R','P','M','_','S','H','A','D','O','W','_','I','D','T','_','W','R','I','T','E',
/* 0x120f7 = "Library was not initialized." */
    'L','i','b','r','a','r','y',' ','\x11','\x08','i','n','i','t','i','a','l','i','z','e','d','.',
/* 0x1210d = "VERR_PDM_NO_REGISTRATION_EXPORT" */
    '\x01','\x7d','\x60','R','E','G','I','S','T','R','A','T','I','O','N','_','E','X','P','O','R','T',
/* 0x12123 = "VERR_THREAD_IS_TERMINATING" */
    '\x01','T','H','R','E','A','D','_','I','S','_','T','E','R','M','I','N','A','T','I','N','G',
/* 0x12139 = "Invalid executable signature." */
    '\x0c','e','x','e','c','u','t','a','b','l','e',' ','s','i','g','n','a','t','u','r','e','.',
/* 0x1214f = "Not an integer property." */
    'N','o','t',' ','\x87','i','n','t','e','g','e','r',' ','p','r','o','p','e','r','t','y','.',
/* 0x12165 = "Invalid argument to VFS chain element." */
    '\x0c','a','r','g','u','m','e','n','t',' ','\x0a','\x8d',' ','\xa1','e','l','e','m','e','n','t','.',
/* 0x1217b = "VERR_EM_RAW_PATCH_CONFLICT" */
    '\x01','E','M','_','R','A','W','_','P','A','T','C','H','_','C','O','N','F','L','I','C','T',
/* 0x12191 = "VINF_THREAD_IS_TERMINATING" */
    '\x0e','T','H','R','E','A','D','_','I','S','_','T','E','R','M','I','N','A','T','I','N','G',
/* 0x121a7 = "VERR_CPUM_INVALID_XSAVE_COMP_MASK" */
    '\x01','C','P','U','M','_','\x05','X','S','A','V','E','_','C','O','M','P','_','M','A','S','K',
/* 0x121bd = "VERR_PGM_PHYS_TLB_CATCH_WRITE" */
    '\x01','\x8c','P','H','Y','S','_','T','L','B','_','C','A','T','C','H','_','W','R','I','T','E',
/* 0x121d3 = "VERR_SELM_SHADOW_TSS_WRITE" */
    '\x01','S','E','L','M','_','S','H','A','D','O','W','_','T','S','S','_','W','R','I','T','E',
/* 0x121e9 = "VERR_VMX_INVALID_VMCS_PTR_TO_START_VM" */
    '\x01','\xe2','\x05','V','M','C','S','_','P','T','R','_','T','O','_','S','T','A','R','T','_','\xcd',
/* 0x121ff = "More data available in pipe." */
    'M','o','r','e',' ','\x9d','a','v','a','i','l','a','b','l','e',' ','\x0f','p','i','p','e','.',
/* 0x12215 = "VINF_PATM_HC_MMIO_PATCH_WRITE" */
    '\x0e','P','A','T','M','_','H','C','_','\xd3','_','P','A','T','C','H','_','W','R','I','T','E',
/* 0x1222b = "VERR_SELM_SHADOW_LDT_WRITE" */
    '\x01','S','E','L','M','_','S','H','A','D','O','W','_','L','D','T','_','W','R','I','T','E',
/* 0x12241 = "VERR_SUP_VP_EMPTY_REGION_TOO_LARGE" */
    '\x01','\x95','\xbd','E','M','P','T','Y','_','R','E','G','I','O','N','_','\x1a','L','A','R','G','E',
/* 0x12257 = "VINF_VRDP_RESIZE_REQUESTED" */
    '\x0e','V','R','D','P','_','R','E','S','I','Z','E','_','R','E','Q','U','E','S','T','E','D',
/* 0x1226d = "VERR_SSM_LIVE_GURU_MEDITATION" */
    '\x01','\xb0','L','I','V','E','_','G','U','R','U','_','M','E','D','I','T','A','T','I','O','N',
/* 0x12283 = "I/O ports are not mapped." */
    'I','/','O',' ','p','o','r','t','s',' ','a','r','e',' ','\x08','m','a','p','p','e','d','.',
/* 0x12299 = "Internal ISO maker error: Buffer size." */
    '\x07','\xc1',' ','m','a','k','e','r',' ','\xd8','B','u','f','f','e','r',' ','s','i','z','e','.',
/* 0x122af = "Unsupported image target architecture." */
    '\x98','\x26','t','a','r','g','e','t',' ','a','r','c','h','i','t','e','c','t','u','r','e','.',
/* 0x122c5 = "VINF_PATM_CHECK_PATCH_PAGE" */
    '\x0e','P','A','T','M','_','C','H','E','C','K','_','P','A','T','C','H','_','P','A','G','E',
/* 0x122db = "VERR_CR_X509_CPV_NAME_NOT_PERMITTED" */
    '\x01','\x24','\xb7','C','P','V','_','N','A','M','E','_','\x06','P','E','R','M','I','T','T','E','D',
/* 0x122f1 = "VERR_POLL_HANDLE_ID_EXISTS" */
    '\x01','P','O','L','L','_','H','A','N','D','L','E','_','I','D','_','E','X','I','S','T','S',
/* 0x12307 = "VERR_SHCLPB_TRANSFER_ID_NOT_FOUND" */
    '\x01','S','H','C','L','P','B','_','T','R','A','N','S','F','E','R','_','I','D','_','\x06','\x2a',
/* 0x1231d = "Path to child node was invalid (i." */
    'P','a','t','h',' ','\x0a','c','h','i','l','d',' ','n','o','d','e',' ','\x11','\x8f','(','i','.',
/* 0x12333 = "The table of content isn\'t valid UTF-8." */
    '\x03','\xb1','\x15','\xf0','i','s','n','\'','t',' ','v','a','l','i','d',' ','U','T','F','-','8','.',
/* 0x12349 = "VERR_HM_NO_32_TO_64_SWITCHER" */
    '\x01','H','M','_','\x60','3','2','_','T','O','_','6','4','_','S','W','I','T','C','H','E','R',
/* 0x1235f = "Can\'t assign requested address." */
    'C','a','n','\'','t',' ','a','s','s','i','g','n',' ','\xde','a','d','d','r','e','s','s','.',
/* 0x12375 = "VERR_VUSB_DEVICE_NOT_ATTACHED" */
    '\x01','V','U','S','B','_','D','E','V','I','C','E','_','\x06','A','T','T','A','C','H','E','D',
/* 0x1238b = "VERR_PDM_INVALID_DRIVER_REGISTRATION" */
    '\x01','\x7d','\x05','D','R','I','V','E','R','_','R','E','G','I','S','T','R','A','T','I','O','N',
/* 0x123a1 = "VERR_CR_PKIX_SIGNATURE_TOO_LONG" */
    '\x01','\x24','P','K','I','X','_','S','I','G','N','A','T','U','R','E','_','\x1a','L','O','N','G',
/* 0x123b7 = "VERR_ASN1_OBJID_COMPONENT_TOO_BIG" */
    '\x01','\xa2','O','B','J','I','D','_','C','O','M','P','O','N','E','N','T','_','\x1a','B','I','G',
/* 0x123cd = "VERR_CR_X509_CPV_MISSING_KEY_CERT_SIGN" */
    '\x01','\x24','\xb7','C','P','V','_','\xc4','_','K','E','Y','_','C','E','R','T','_','S','I','G','N',
/* 0x123e3 = "Media not present in drive." */
    'M','e','d','i','a',' ','\x08','p','r','e','s','e','n','t',' ','\x0f','d','r','i','v','e','.',
/* 0x123f9 = "VERR_PROC_NO_ARG_TRANSLATION" */
    '\x01','P','R','O','C','_','\x60','A','R','G','_','T','R','A','N','S','L','A','T','I','O','N',
/* 0x1240f = "The device instance structure version has changed." */
    '\x03','\xa3','i','n','s','t','a','n','c','e',' ','\xec','\xcf','\x5e','c','h','a','n','g','e','d','.',
/* 0x12425 = "VERR_VMX_UNEXPECTED_INTERRUPTION_EXIT_TYPE" */
    '\x01','\xe2','\x88','I','N','T','E','R','R','U','P','T','I','O','N','_','E','X','I','T','_','\xb5',
/* 0x1243b = "VERR_ISOMK_IMPORT_ZERO_SIZED_ROOT_DIR" */
    '\x01','\x22','\x83','Z','E','R','O','_','S','I','Z','E','D','_','R','O','O','T','_','D','I','R',
/* 0x12451 = "VERR_SELM_SHADOW_GDT_WRITE" */
    '\x01','S','E','L','M','_','S','H','A','D','O','W','_','G','D','T','_','W','R','I','T','E',
/* 0x12467 = "Internal processing error related to guest mappings." */
    '\x07','\x04','\x09','r','e','l','a','t','e','d',' ','\x0a','\xbb','m','a','p','p','i','n','g','s','.',
/* 0x1247d = "VERR_DWARF_STACK_UNDERFLOW" */
    '\x01','D','W','A','R','F','_','S','T','A','C','K','_','U','N','D','E','R','F','L','O','W',
/* 0X12493 = "Wrong JSON type for integer value." */
    'r','o','n','g',' ','J','S','O','N',' ','\xf3','\x10','i','n','t','e','g','e','r',' ','\xe8',
/* 0x124a8 = "VERR_HM_UNSUPPORTED_CPU_FEATURE_COMBO" */
    '\x01','H','M','_','\x1c','C','P','U','_','F','E','A','T','U','R','E','_','C','O','M','B','O',
/* 0x124be = "VERR_VMX_X86_CR4_VMXE_CLEARED" */
    '\x01','\xe2','X','8','6','_','C','R','4','_','V','M','X','E','_','C','L','E','A','R','E','D',
/* 0x124d4 = "VERR_VUSB_USBFS_PERMISSION" */
    '\x01','V','U','S','B','_','U','S','B','F','S','_','P','E','R','M','I','S','S','I','O','N',
/* 0x124ea = "Invalid file mode mask (RTFMODE)." */
    '\x0c','\x1f','m','o','d','e',' ','m','a','s','k',' ','(','R','T','F','M','O','D','E',')','.',
/* 0x12500 = "VERR_CR_MALFORMED_PEM_HEADER" */
    '\x01','\x24','M','A','L','F','O','R','M','E','D','_','P','E','M','_','H','E','A','D','E','R',
/* 0x12516 = "VERR_PATH_GLOB_UNKNOWN_CHAR_CLASS" */
    '\x01','P','A','T','H','_','G','L','O','B','_','\x91','C','H','A','R','_','C','L','A','S','S',
/* 0x1252c = "VERR_CANT_DELETE_DIRECTORY" */
    '\x01','C','A','N','T','_','D','E','L','E','T','E','_','D','I','R','E','C','T','O','R','Y',
/* 0x12542 = "The USB hub is already registered." */
    '\x03','U','S','B',' ','h','u','b',' ','\x0b','\x7f','r','e','g','i','s','t','e','r','e','d','.',
/* 0x12558 = "VERR_VD_ASYNC_IO_IN_PROGRESS" */
    '\x01','\xff','A','S','Y','N','C','_','I','O','_','I','N','_','P','R','O','G','R','E','S','S',
/* 0x1256e = "VERR_CR_X509_CPV_INVALID_POLICY_MAPPING" */
    '\x01','\x24','\xb7','C','P','V','_','\x05','P','O','L','I','C','Y','_','M','A','P','P','I','N','G',
/* 0x12584 = "VERR_XAR_BAD_CHECKSUM_ELEMENT" */
    '\x01','X','A','R','_','\x1d','C','H','E','C','K','S','U','M','_','E','L','E','M','E','N','T',
/* 0x1259a = "VMDK: Invalid write position." */
    'V','M','D','K',':',' ','\x0c','w','r','i','t','e',' ','p','o','s','i','t','i','o','n','.',
/* 0x125b0 = "VERR_JSON_MISSING_SURROGATE_PAIR" */
    '\x01','J','S','O','N','_','\xc4','_','S','U','R','R','O','G','A','T','E','_','P','A','I','R',
/* 0x125c6 = "VERR_ASN1_NO_CHECK_SANITY_METHOD" */
    '\x01','\xa2','\x60','C','H','E','C','K','_','S','A','N','I','T','Y','_','M','E','T','H','O','D',
/* 0x125dc = "RTCache: cache is empty." */
    'R','T','C','a','c','h','e',':',' ','c','a','c','h','e',' ','\x0b','e','m','p','t','y','.',
/* 0x125f2 = "VERR_SUPDRV_TRACER_UMOD_TOO_MANY_PROBES" */
    '\x01','\x90','T','R','A','C','E','R','_','U','M','O','D','_','\x1a','\xac','P','R','O','B','E','S',
/* 0x12608 = "VERR_VFS_CHAIN_AT_LEAST_FIVE_ARGS" */
    '\x01','\x8d','_','\x8e','A','T','_','L','E','A','S','T','_','F','I','V','E','_','A','R','G','S',
/* 0x1261e = "Bad digest length encountered in the table of content." */
    '\x9f','\xd7','l','e','n','g','t','h',' ','\xaf','\x0f','\x02','\xb1','\x15','c','o','n','t','e','n','t','.',
/* 0x12634 = "No attribute of the specified types was found." */
    '\xdf','a','t','t','r','i','b','u','t','e',' ','\x15','\x02','\x18','t','y','p','e','s',' ','\x11','\x89',
/* 0x1264a = "Failed to lock the address range." */
    '\x8b','\x0a','l','o','c','k',' ','\x02','a','d','d','r','e','s','s',' ','r','a','n','g','e','.',
/* 0x12660 = "VERR_HARDAVL_BAD_RIGHT_HEIGHT" */
    '\x01','H','A','R','D','A','V','L','_','\x1d','R','I','G','H','T','_','H','E','I','G','H','T',
/* 0x12676 = "VERR_CR_X509_CPV_MAX_PATH_LENGTH" */
    '\x01','\x24','\xb7','C','P','V','_','M','A','X','_','P','A','T','H','_','L','E','N','G','T','H',
/* 0x1268c = "VERR_ISOMK_BOOT_CAT_EMPTY_ENTRY" */
    '\x01','\x22','B','O','O','T','_','C','A','T','_','E','M','P','T','Y','_','E','N','T','R','Y',
/* 0x126a2 = "VERR_VFS_CHAIN_AT_LEAST_FOUR_ARGS" */
    '\x01','\x8d','_','\x8e','A','T','_','L','E','A','S','T','_','F','O','U','R','_','A','R','G','S',
/* 0x126b8 = "The driver instance structure version has changed." */
    '\x03','\xc5','i','n','s','t','a','n','c','e',' ','\xec','\xcf','\x5e','c','h','a','n','g','e','d','.',
/* 0x126ce = "VERR_DBGC_PARSE_INVALD_COMMAND_NAME" */
    '\x01','\xfc','\xe4','I','N','V','A','L','D','_','C','O','M','M','A','N','D','_','N','A','M','E',
/* 0x126e4 = "VERR_IOM_TOO_MANY_MMIO_REGISTRATIONS" */
    '\x01','I','O','M','_','\x1a','\xac','\xd3','_','R','E','G','I','S','T','R','A','T','I','O','N','S',
/* 0x126fa = "VERR_POLL_HANDLE_NOT_POLLABLE" */
    '\x01','P','O','L','L','_','H','A','N','D','L','E','_','\x06','P','O','L','L','A','B','L','E',
/* 0x12710 = "Syntax error - unbalanced quotes." */
    '\xfa','\x09','-',' ','u','n','b','a','l','a','n','c','e','d',' ','q','u','o','t','e','s','.',
/* 0x12726 = "The server does not support the requested function." */
    '\x03','s','e','r','v','e','r',' ','\xb2','\x08','\xce','\x02','\xde','f','u','n','c','t','i','o','n','.',
/* 0x1273c = "VINF_IOM_R3_MMIO_COMMIT_WRITE" */
    '\x0e','I','O','M','_','R','3','_','\xd3','_','C','O','M','M','I','T','_','W','R','I','T','E',
/* 0x12752 = "The trace log is malformed." */
    '\x03','t','r','a','c','e',' ','l','o','g',' ','\x0b','m','a','l','f','o','r','m','e','d','.',
/* 0x12768 = "VERR_INCONSISTENT_VM_HANDLE" */
    '\x01','I','N','C','O','N','S','I','S','T','E','N','T','_','\xcd','_','H','A','N','D','L','E',
/* 0x1277e = "VERR_VFS_CHAIN_EXPECTED_SEPARATOR" */
    '\x01','\x8d','_','\x8e','E','X','P','E','C','T','E','D','_','S','E','P','A','R','A','T','O','R',
/* 0x12794 = "VERR_PDM_HPET_LEGACY_NOTIFY_MISSING" */
    '\x01','\x7d','H','P','E','T','_','L','E','G','A','C','Y','_','N','O','T','I','F','Y','_','\xc4',
/* 0x127aa = "VERR_SVM_UNABLE_TO_START_VM" */
    '\x01','S','V','M','_','U','N','A','B','L','E','_','T','O','_','S','T','A','R','T','_','\xcd',
/* 0x127c0 = "VERR_CPUM_HIDDEN_CS_LOAD_ERROR" */
    '\x01','C','P','U','M','_','H','I','D','D','E','N','_','C','S','_','L','O','A','D','_','\x1b',
/* 0x127d6 = "VERR_LDRVI_PAGE_HASH_TAB_SIZE_OVERFLOW" */
    '\x01','\xf4','\xdc','H','A','S','H','_','T','A','B','_','\xf9','_','O','V','E','R','F','L','O','W',
/* 0x127ec = "The symbol is not a forwarder." */
    '\x03','s','y','m','b','o','l',' ','\x0b','\x08','a',' ','f','o','r','w','a','r','d','e','r','.',
/* 0x12802 = "VERR_ISOMK_IMPORT_BOOT_CAT_UNKNOWN_HEADER_ID" */
    '\x01','\x22','\x83','B','O','O','T','_','C','A','T','_','\x91','H','E','A','D','E','R','_','I','D',
/* 0x12818 = "VERR_VD_RAW_SIZE_OPTICAL_TOO_SMALL" */
    '\x01','\xff','R','A','W','_','\xf9','_','O','P','T','I','C','A','L','_','\x1a','S','M','A','L','L',
/* 0x1282e = "VERR_VMM_SMAP_BUT_AC_CLEAR" */
    '\x01','V','M','M','_','S','M','A','P','_','B','U','T','_','A','C','_','C','L','E','A','R',
/* 0x12844 = "VERR_SUPDRV_NOT_BUDDING_VM_PROCESS_1" */
    '\x01','\x90','\x06','B','U','D','D','I','N','G','_','\xcd','_','P','R','O','C','E','S','S','_','1',
/* 0x1285a = "VERR_SUPDRV_NOT_BUDDING_VM_PROCESS_2" */
    '\x01','\x90','\x06','B','U','D','D','I','N','G','_','\xcd','_','P','R','O','C','E','S','S','_','2',
/* 0x12870 = "VERR_VFS_CHAIN_AT_MOST_THREE_ARGS" */
    '\x01','\x8d','_','\x8e','A','T','_','M','O','S','T','_','T','H','R','E','E','_','A','R','G','S',
/* 0x12886 = "Reason for leaving RZ: I/O port write." */
    '\x93','\x10','\x81','R','Z',':',' ','I','/','O',' ','p','o','r','t',' ','w','r','i','t','e','.',
/* 0x1289c = "VERR_SUP_VP_REPLACE_VIRTUAL_MEMORY_FAILED" */
    '\x01','\x95','\xbd','R','E','P','L','A','C','E','_','V','I','R','T','U','A','L','_','\xb6','_','\x17',
/* 0x128b2 = "VERR_SUP_VP_UNMAP_AND_PROTECT_FAILED" */
    '\x01','\x95','\xbd','U','N','M','A','P','_','A','N','D','_','P','R','O','T','E','C','T','_','\x17',
/* 0x128c8 = "VERR_CR_X509_TBSCERT_EXTS_REQ_V3" */
    '\x01','\x24','\xb7','T','B','S','C','E','R','T','_','E','X','T','S','_','R','E','Q','_','V','3',
/* 0x128de = "VERR_IPC_RECEIVE_CANCELLED" */
    '\x01','I','P','C','_','R','E','C','E','I','V','E','_','C','A','N','C','E','L','L','E','D',
/* 0x128f4 = "VINF_EM_EMULATE_SPLIT_LOCK" */
    '\x0e','E','M','_','E','M','U','L','A','T','E','_','S','P','L','I','T','_','L','O','C','K',
/* 0x1290a = "VERR_CR_KEY_TOO_SHORT_CIPHER_IV" */
    '\x01','\x24','K','E','Y','_','\x1a','S','H','O','R','T','_','C','I','P','H','E','R','_','I','V',
/* 0x12920 = "VERR_CR_X509_CPV_NO_TRUSTED_PATHS" */
    '\x01','\x24','\xb7','C','P','V','_','\x60','T','R','U','S','T','E','D','_','P','A','T','H','S',
/* 0x12935 = "VERR_LDRPE_COM_DESCRIPTOR" */
    '\x01','L','D','R','P','E','_','C','O','M','_','D','E','S','C','R','I','P','T','O','R',
/* 0x1294a = "VERR_CANT_RECODE_AS_UTF16" */
    '\x01','C','A','N','T','_','R','E','C','O','D','E','_','A','S','_','U','T','F','1','6',
/* 0x1295f = "VERR_PGM_PHYS_WR_HIT_HANDLER" */
    '\x01','\x8c','P','H','Y','S','_','W','R','_','H','I','T','_','H','A','N','D','L','E','R',
/* 0x12974 = "VERR_PGM_PHYS_TLB_UNASSIGNED" */
    '\x01','\x8c','P','H','Y','S','_','T','L','B','_','U','N','A','S','S','I','G','N','E','D',
/* 0x12989 = "VERR_IOSMK_IMPORT_SUP_VOL_DESC_VER" */
    '\x01','I','O','S','M','K','_','\x83','\x95','V','O','L','_','D','E','S','C','_','V','E','R',
/* 0x1299e = "VERR_IEM_COND_TOO_DEEPLY_NESTED" */
    '\x01','\x9c','C','O','N','D','_','\x1a','D','E','E','P','L','Y','_','N','E','S','T','E','D',
/* 0x129b3 = "VERR_ISOFS_TOO_DEEP_ICB_RECURSION" */
    '\x01','\x97','\x1a','D','E','E','P','_','I','C','B','_','R','E','C','U','R','S','I','O','N',
/* 0x129c8 = "VINF_EM_RAW_TIMER_PENDING" */
    '\x0e','E','M','_','R','A','W','_','T','I','M','E','R','_','P','E','N','D','I','N','G',
/* 0x129dd = "The iprt loader recognized an a." */
    '\x03','i','p','r','t',' ','\xd9','r','e','c','o','g','n','i','z','e','d',' ','\x87','a','.',
/* 0x129f2 = "VERR_IOM_NO_R3_IOPORT_RANGE" */
    '\x01','I','O','M','_','\x60','R','3','_','I','O','P','O','R','T','_','R','A','N','G','E',
/* 0x12a07 = "VERR_ASN1_CONSTRUCTED_STRING_NOT_IMPL" */
    '\x01','\xa2','C','O','N','S','T','R','U','C','T','E','D','_','\xd5','_','\x06','I','M','P','L',
/* 0x12a1c = "VERR_VM_REQUEST_TOO_MANY_ARGS_IPE" */
    '\x01','\xcd','_','R','E','Q','U','E','S','T','_','\x1a','\xac','A','R','G','S','_','I','P','E',
/* 0x12a31 = "VERR_CR_KEY_MISSING_CIPHER_PARAMS" */
    '\x01','\x24','K','E','Y','_','\xc4','_','C','I','P','H','E','R','_','P','A','R','A','M','S',
/* 0x12a46 = "VERR_IOMMU_ADDR_ACCESS_DENIED" */
    '\x01','\xfd','_','A','D','D','R','_','A','C','C','E','S','S','_','D','E','N','I','E','D',
/* 0x12a5b = "VERR_XAR_MISSING_OFFSET_ELEMENT" */
    '\x01','X','A','R','_','\xc4','_','O','F','F','S','E','T','_','E','L','E','M','E','N','T',
/* 0x12a70 = "No data for this block in image." */
    '\xdf','\x9d','\x10','t','h','i','s',' ','b','l','o','c','k',' ','\x0f','i','m','a','g','e','.',
/* 0x12a85 = "Import ISO contains a too deep directory subtree." */
    '\xc3','\xc1',' ','\x8a','a',' ','\x9e','d','e','e','p',' ','\x25','s','u','b','t','r','e','e','.',
/* 0x12a9a = "VERR_X509_NO_BASIC_CONSTARAINTS" */
    '\x01','\xb7','\x60','B','A','S','I','C','_','C','O','N','S','T','A','R','A','I','N','T','S',
/* 0x12aaf = "VERR_SUPDRV_TRACER_SESSION_BUSY" */
    '\x01','\x90','T','R','A','C','E','R','_','S','E','S','S','I','O','N','_','B','U','S','Y',
/* 0x12ac4 = "VERR_AUDIO_BACKEND_INIT_FAILED" */
    '\x01','A','U','D','I','O','_','B','A','C','K','E','N','D','_','I','N','I','T','_','\x17',
/* 0x12ad9 = "VERR_PDM_ASYNC_TEMPLATE_BUSY" */
    '\x01','\x7d','A','S','Y','N','C','_','T','E','M','P','L','A','T','E','_','B','U','S','Y',
/* 0x12aee = "VERR_RECORDING_RESTRICTED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','R','E','S','T','R','I','C','T','E','D',
/* 0x12b03 = "VERR_ISOFS_NO_DIRECT_ICB_ENTRIES" */
    '\x01','\x97','\x60','D','I','R','E','C','T','_','I','C','B','_','E','N','T','R','I','E','S',
/* 0x12b18 = "No free output streams." */
    '\xdf','f','r','e','e',' ','o','u','t','p','u','t',' ','s','t','r','e','a','m','s','.',
/* 0x12b2d = "HTTP initialization failed." */
    'H','T','T','P',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','\x7b',
/* 0x12b42 = "VERR_VM_DRIVER_NOT_ACCESSIBLE" */
    '\x01','\xcd','_','D','R','I','V','E','R','_','\x06','A','C','C','E','S','S','I','B','L','E',
/* 0x12b57 = "VERR_VMX_UNDEFINED_EXIT_CODE" */
    '\x01','\xe2','U','N','D','E','F','I','N','E','D','_','E','X','I','T','_','C','O','D','E',
/* 0x12b6c = "VERR_PGM_PHYS_PAGE_MAP_MMIO2_IPE" */
    '\x01','\x8c','P','H','Y','S','_','\xdc','M','A','P','_','M','M','I','O','2','_','I','P','E',
/* 0x12b81 = "VERR_SYS_CANNOT_POWER_OFF" */
    '\x01','S','Y','S','_','C','A','N','N','O','T','_','P','O','W','E','R','_','O','F','F',
/* 0x12b96 = "VERR_PGM_NO_HYPERVISOR_ADDRESS" */
    '\x01','\x8c','\x60','H','Y','P','E','R','V','I','S','O','R','_','A','D','D','R','E','S','S',
/* 0x12bab = "Import ISO contains more than volume." */
    '\xc3','\xc1',' ','\x8a','m','o','r','e',' ','t','h','a','n',' ','v','o','l','u','m','e','.',
/* 0x12bc0 = "VERR_LDRLX_BAD_FIXUP_SECTION" */
    '\x01','L','D','R','L','X','_','\x1d','F','I','X','U','P','_','S','E','C','T','I','O','N',
/* 0x12bd5 = "Reason for leaving RZ: Unknown call to ring-3." */
    '\x93','\x10','\x81','R','Z',':',' ','\xef','c','a','l','l',' ','\x0a','r','i','n','g','-','3','.',
/* 0x12bea = "VERR_CR_X509_CPV_NOT_VALID_AT_TIME" */
    '\x01','\x24','\xb7','C','P','V','_','\x06','V','A','L','I','D','_','A','T','_','T','I','M','E',
/* 0x12bff = "Internal SPC error: The PE image data is missing." */
    '\x07','S','P','C',' ','\xd8','\x03','P','E',' ','\x26','\x9d','\x0b','m','i','s','s','i','n','g','.',
/* 0x12c14 = "Network is unreachable." */
    'N','e','t','w','o','r','k',' ','\x0b','u','n','r','e','a','c','h','a','b','l','e','.',
/* 0x12c29 = "VERR_VFS_CHAIN_AT_MOST_FOUR_ARGS" */
    '\x01','\x8d','_','\x8e','A','T','_','M','O','S','T','_','F','O','U','R','_','A','R','G','S',
/* 0x12c3e = "Process Verification Failure: Bad virtual section address." */
    '\x1e','\x0d','\x12','\x9f','v','i','r','t','u','a','l',' ','\xdb','a','d','d','r','e','s','s','.',
/* 0x12c53 = "Out of selector bounds." */
    'O','u','t',' ','\x15','s','e','l','e','c','t','o','r',' ','b','o','u','n','d','s','.',
/* 0x12c68 = "The file or directory is world writable (hardening)." */
    '\x03','\x1f','\xa9','\x25','\x0b','w','o','r','l','d',' ','w','r','i','t','a','b','l','e',' ','\xae',
/* 0x12c7d = "VERR_VFS_CHAIN_AT_MOST_FIVE_ARGS" */
    '\x01','\x8d','_','\x8e','A','T','_','M','O','S','T','_','F','I','V','E','_','A','R','G','S',
/* 0x12c92 = "Reason for leaving RZ: Timer pending." */
    '\x93','\x10','\x81','R','Z',':',' ','T','i','m','e','r',' ','p','e','n','d','i','n','g','.',
/* 0x12ca7 = "Object or array is empty." */
    'O','b','j','e','c','t',' ','\xa9','a','r','r','a','y',' ','\x0b','e','m','p','t','y','.',
/* 0x12cbc = "VERR_DBGC_PARSE_EXPECTED_BINARY_OP" */
    '\x01','\xfc','\xe4','E','X','P','E','C','T','E','D','_','B','I','N','A','R','Y','_','O','P',
/* 0x12cd1 = "Process Verification Failure: The process is being debugged." */
    '\x1e','\x0d','\x12','\x03','\x92','\x0b','b','e','i','n','g',' ','d','e','b','u','g','g','e','d','.',
/* 0x12ce6 = "VINF_DBGF_TRUNCATED_REGISTER" */
    '\x0e','\xb9','_','T','R','U','N','C','A','T','E','D','_','R','E','G','I','S','T','E','R',
/* 0x12cfb = "VERR_VFS_CHAIN_AT_LEAST_SIX_ARGS" */
    '\x01','\x8d','_','\x8e','A','T','_','L','E','A','S','T','_','S','I','X','_','A','R','G','S',
/* 0x12d10 = "VERR_SUPDRV_KERNEL_TOO_OLD_FOR_VTX" */
    '\x01','\x90','K','E','R','N','E','L','_','\x1a','O','L','D','_','F','O','R','_','V','T','X',
/* 0x12d25 = "VERR_ISOFS_NO_ADS_FOR_UDF_OBJECT" */
    '\x01','\x97','\x60','A','D','S','_','F','O','R','_','U','D','F','_','O','B','J','E','C','T',
/* 0x12d3a = "VERR_HTTP_COULDNT_CONNECT" */
    '\x01','H','T','T','P','_','C','O','U','L','D','N','T','_','C','O','N','N','E','C','T',
/* 0x12d4f = "Geometry hasn\'t been set." */
    'G','e','o','m','e','t','r','y',' ','h','a','s','n','\'','t',' ','\xcb','s','e','t','.',
/* 0x12d64 = "APIC initialization failed." */
    'A','P','I','C',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','\x7b',
/* 0x12d79 = "VERR_ISOFS_TOO_BIG_PARTMAP_IN_LVD" */
    '\x01','\x97','\x1a','B','I','G','_','P','A','R','T','M','A','P','_','I','N','_','L','V','D',
/* 0x12d8e = "VERR_GIM_PVTSC_NOT_AVAILABLE" */
    '\x01','G','I','M','_','P','V','T','S','C','_','\x06','A','V','A','I','L','A','B','L','E',
/* 0x12da3 = "VERR_VFS_CHAIN_AT_LEAST_TWO_ARGS" */
    '\x01','\x8d','_','\x8e','A','T','_','L','E','A','S','T','_','T','W','O','_','A','R','G','S',
/* 0x12db8 = "Can\'t delete directory with files." */
    'C','a','n','\'','t',' ','d','e','l','e','t','e',' ','\x25','\x80','f','i','l','e','s','.',
/* 0x12dcd = "VERR_GIM_INVALID_HYPERCALL_INSTR" */
    '\x01','G','I','M','_','\x05','H','Y','P','E','R','C','A','L','L','_','I','N','S','T','R',
/* 0x12de2 = "VERR_ISOMK_BOOT_CAT_INVALID_SECTION_SIZE" */
    '\x01','\x22','B','O','O','T','_','C','A','T','_','\x05','S','E','C','T','I','O','N','_','\xf9',
/* 0x12df7 = "VINF_EM_DBG_HYPER_STEPPED" */
    '\x0e','E','M','_','D','B','G','_','H','Y','P','E','R','_','S','T','E','P','P','E','D',
/* 0x12e0c = "Too many MMIO registrations." */
    'T','o','o',' ','\xb4','\xd3',' ','r','e','g','i','s','t','r','a','t','i','o','n','s','.',
/* 0x12e21 = "VERR_VFS_CHAIN_LEADING_SEPARATOR" */
    '\x01','\x8d','_','\x8e','L','E','A','D','I','N','G','_','S','E','P','A','R','A','T','O','R',
/* 0x12e36 = "VERR_SERIALPORT_INVALID_BAUDRATE" */
    '\x01','S','E','R','I','A','L','P','O','R','T','_','\x05','B','A','U','D','R','A','T','E',
/* 0x12e4b = "Device i/o: Sector not found." */
    'D','e','v','i','c','e',' ','i','/','o',':',' ','S','e','c','t','o','r',' ','\x08','\x89',
/* 0x12e60 = "VERR_CR_SPC_BAD_MONIKER_CHOICE" */
    '\x01','\x24','S','P','C','_','\x1d','M','O','N','I','K','E','R','_','C','H','O','I','C','E',
/* 0x12e75 = "VERR_DRIVER_REBOOT_NEEDED" */
    '\x01','D','R','I','V','E','R','_','R','E','B','O','O','T','_','N','E','E','D','E','D',
/* 0x12e8a = "VINF_HGCM_CLIENT_REJECTED" */
    '\x0e','H','G','C','M','_','C','L','I','E','N','T','_','R','E','J','E','C','T','E','D',
/* 0x12e9f = "VERR_XAR_EXTRACTED_HASH_MISMATCH" */
    '\x01','X','A','R','_','E','X','T','R','A','C','T','E','D','_','H','A','S','H','_','\x19',
/* 0x12eb4 = "VERR_TCP_SERVER_DESTROYED" */
    '\x01','T','C','P','_','S','E','R','V','E','R','_','D','E','S','T','R','O','Y','E','D',
/* 0x12ec9 = "Unknown partition map entry type." */
    '\xef','p','a','r','t','i','t','i','o','n',' ','m','a','p',' ','\xc8','t','y','p','e','.',
/* 0x12ede = "VERR_HTTP_STATUS_SERVER_ERROR" */
    '\x01','H','T','T','P','_','S','T','A','T','U','S','_','S','E','R','V','E','R','_','\x1b',
/* 0x12ef3 = "VERR_PGM_MAPPINGS_FIX_TOO_SMALL" */
    '\x01','\x8c','M','A','P','P','I','N','G','S','_','F','I','X','_','\x1a','S','M','A','L','L',
/* 0x12f08 = "The compressed table of content is too big." */
    '\x03','c','o','m','p','r','e','s','s','e','d',' ','\xb1','\x15','\xf0','\x0b','\x9e','b','i','g','.',
/* 0x12f1d = "VERR_NO_MORE_SEARCH_HANDLES" */
    '\x01','\x60','M','O','R','E','_','S','E','A','R','C','H','_','H','A','N','D','L','E','S',
/* 0x12f32 = "Preemption is disabled." */
    'P','r','e','e','m','p','t','i','o','n',' ','\x0b','d','i','s','a','b','l','e','d','.',
/* 0x12f47 = "Source/destination not found." */
    'S','o','u','r','c','e','/','d','e','s','t','i','n','a','t','i','o','n',' ','\x08','\x89',
/* 0x12f5c = "VERR_GMM_HIT_GLOBAL_LIMIT" */
    '\x01','G','M','M','_','H','I','T','_','G','L','O','B','A','L','_','L','I','M','I','T',
/* 0x12f71 = "Current object state prohibits operation." */
    'C','u','r','r','e','n','t',' ','\xa8','\xca','p','r','o','h','i','b','i','t','s',' ','\xea',
/* 0x12f86 = "VERR_TAR_NUM_VALUE_TOO_LARGE" */
    '\x01','T','A','R','_','N','U','M','_','V','A','L','U','E','_','\x1a','L','A','R','G','E',
/* 0x12f9b = "VERR_ISOMK_FILE_TOO_BIG_REQ_ISO_LEVEL_3" */
    '\x01','\x22','\xab','\x1a','B','I','G','_','R','E','Q','_','\xc1','_','L','E','V','E','L','_','3',
/* 0x12fb0 = "VERR_CODE_POINT_SURROGATE" */
    '\x01','C','O','D','E','_','P','O','I','N','T','_','S','U','R','R','O','G','A','T','E',
/* 0x12fc5 = "VERR_LDRELF_INVALID_SYMBOL_INDEX" */
    '\x01','L','D','R','E','L','F','_','\x05','S','Y','M','B','O','L','_','I','N','D','E','X',
/* 0x12fda = "VERR_NET_OUT_OF_RESOURCES" */
    '\x01','N','E','T','_','O','U','T','_','O','F','_','R','E','S','O','U','R','C','E','S',
/* 0x12fef = "VERR_VRDP_SEC_ENGINE_FAIL" */
    '\x01','V','R','D','P','_','S','E','C','_','E','N','G','I','N','E','_','F','A','I','L',
/* 0x13004 = "Syntax error - numeric overflow." */
    '\xfa','\x09','-',' ','n','u','m','e','r','i','c',' ','o','v','e','r','f','l','o','w','.',
/* 0x13019 = "Duplicate certificate extension." */
    'D','u','p','l','i','c','a','t','e',' ','\xa0','e','x','t','e','n','s','i','o','n','.',
/* 0x1302e = "VERR_SVM_ILLEGAL_EFER_MSR" */
    '\x01','S','V','M','_','I','L','L','E','G','A','L','_','E','F','E','R','_','M','S','R',
/* 0x13043 = "VERR_IOM_MMIO_RANGE_CONFLICT" */
    '\x01','I','O','M','_','\xd3','_','R','A','N','G','E','_','C','O','N','F','L','I','C','T',
/* 0x13058 = "The configured driver wasn\'t found." */
    '\x03','c','o','n','f','i','g','u','r','e','d',' ','\xc5','w','a','s','n','\'','t',' ','\x89',
/* 0x1306d = "VERR_GMM_ACTUAL_PAGES_IPE" */
    '\x01','G','M','M','_','A','C','T','U','A','L','_','P','A','G','E','S','_','I','P','E',
/* 0x13082 = "Address translation failed." */
    'A','d','d','r','e','s','s',' ','t','r','a','n','s','l','a','t','i','o','n',' ','\x7b',
/* 0x13097 = "Saved state directory wintertides error." */
    'S','a','v','e','d',' ','\xca','\x25','w','i','n','t','e','r','t','i','d','e','s',' ','\x85',
/* 0x130ac = "VERR_ASN1_INVALID_GENERALIZED_TIME_ENCODING" */
    '\x01','\xa2','\x05','G','E','N','E','R','A','L','I','Z','E','D','_','T','I','M','E','_','\xc6',
/* 0x130c1 = "Bad file group id for XAR file." */
    '\x9f','\x1f','g','r','o','u','p',' ','i','d',' ','\x10','X','A','R',' ','f','i','l','e','.',
/* 0x130d6 = "VERR_VFS_CHAIN_TOO_SHORT_FOR_PARENT" */
    '\x01','\x8d','_','\x8e','\x1a','S','H','O','R','T','_','F','O','R','_','P','A','R','E','N','T',
/* 0x130eb = "VINF_PARAV_SWITCH_TO_HOST" */
    '\x0e','P','A','R','A','V','_','S','W','I','T','C','H','_','T','O','_','H','O','S','T',
/* 0x13100 = "VERR_IOM_MMIO_REGION_ALREADY_MAPPED" */
    '\x01','I','O','M','_','\xd3','_','R','E','G','I','O','N','_','\x9b','M','A','P','P','E','D',
/* 0x13115 = "A page count is out of range." */
    'A',' ','\xcc','c','o','u','n','t',' ','\x0b','o','u','t',' ','\x15','r','a','n','g','e','.',
/* 0x1312a = "VERR_SUP_VP_STUB_THREAD_OPEN_ERROR" */
    '\x01','\x95','\xbd','S','T','U','B','_','T','H','R','E','A','D','_','O','P','E','N','_','\x1b',
/* 0x1313f = "VERR_HARDAVL_BAD_LEFT_HEIGHT" */
    '\x01','H','A','R','D','A','V','L','_','\x1d','L','E','F','T','_','H','E','I','G','H','T',
/* 0x13154 = "VERR_IOM_MMIO_REGION_NOT_MAPPED" */
    '\x01','I','O','M','_','\xd3','_','R','E','G','I','O','N','_','\x06','M','A','P','P','E','D',
/* 0x13169 = "VERR_DBG_ADDRESS_CONFLICT" */
    '\x01','D','B','G','_','A','D','D','R','E','S','S','_','C','O','N','F','L','I','C','T',
/* 0x1317e = "VERR_LDRELF_RELOCATION_NOT_SUPPORTED" */
    '\x01','L','D','R','E','L','F','_','R','E','L','O','C','A','T','I','O','N','_','\x06','\x82',
/* 0x13193 = "Internal ISO maker error: Empty path." */
    '\x07','\xc1',' ','m','a','k','e','r',' ','\xd8','E','m','p','t','y',' ','p','a','t','h','.',
/* 0x131a8 = "VERR_TAR_DEV_VALUE_TOO_LARGE" */
    '\x01','T','A','R','_','D','E','V','_','V','A','L','U','E','_','\x1a','L','A','R','G','E',
/* 0x131bd = "Process Verification Failure: Error reading image file header." */
    '\x1e','\x0d','\x12','\xc0','r','e','a','d','i','n','g',' ','\x26','\x1f','h','e','a','d','e','r','.',
/* 0x131d2 = "VERR_VMM_WRONG_HM_VMCPU_STATE" */
    '\x01','V','M','M','_','W','R','O','N','G','_','H','M','_','V','M','C','P','U','_','\xf1',
/* 0x131e7 = "VERR_CR_PKCS7_CONTENT_TYPE_ATTRIB_MISMATCH" */
    '\x01','\x24','\xe5','C','O','N','T','E','N','T','_','\xb5','_','A','T','T','R','I','B','_','\x19',
/* 0x131fc = "Bad timestamp for XAR file." */
    '\x9f','t','i','m','e','s','t','a','m','p',' ','\x10','X','A','R',' ','f','i','l','e','.',
/* 0x13211 = "VERR_IEM_ASPECT_NOT_IMPLEMENTED" */
    '\x01','\x9c','A','S','P','E','C','T','_','\x06','I','M','P','L','E','M','E','N','T','E','D',
/* 0x13226 = "VERR_SUP_VP_EXE_VS_PROC_NAME_MISMATCH" */
    '\x01','\x95','\xbd','E','X','E','_','V','S','_','P','R','O','C','_','N','A','M','E','_','\x19',
/* 0x1323b = "The signature is negative." */
    '\x03','s','i','g','n','a','t','u','r','e',' ','\x0b','n','e','g','a','t','i','v','e','.',
/* 0x13250 = "VERR_IOMMU_ADDR_TRANSLATION_FAILED" */
    '\x01','\xfd','_','A','D','D','R','_','T','R','A','N','S','L','A','T','I','O','N','_','\x17',
/* 0x13265 = "VERR_PAGE_MAP_LEVEL4_NOT_PRESENT" */
    '\x01','\xdc','M','A','P','_','L','E','V','E','L','4','_','\x06','P','R','E','S','E','N','T',
/* 0x1327a = "VERR_LDR_ADDRESS_OVERFLOW" */
    '\x01','L','D','R','_','A','D','D','R','E','S','S','_','O','V','E','R','F','L','O','W',
/* 0x1328f = "VERR_HARDAVL_NODE_IS_FREE" */
    '\x01','H','A','R','D','A','V','L','_','N','O','D','E','_','I','S','_','F','R','E','E',
/* 0x132a4 = "No direct ICB entries found." */
    '\xdf','d','i','r','e','c','t',' ','I','C','B',' ','e','n','t','r','i','e','s',' ','\x89',
/* 0x132b9 = "Process Verification Failure: Error closing image file handle." */
    '\x1e','\x0d','\x12','\xc0','c','l','o','s','i','n','g',' ','\x26','\x1f','h','a','n','d','l','e','.',
/* 0x132ce = "VERR_HARDAVL_LOOKUP_TOO_DEEP" */
    '\x01','H','A','R','D','A','V','L','_','L','O','O','K','U','P','_','\x1a','D','E','E','P',
/* 0x132e3 = "Shadow mode \'none\' internal error." */
    'S','h','a','d','o','w',' ','m','o','d','e',' ','\'','n','o','n','e','\'',' ','\x16','\x85',
/* 0x132f8 = "Recompiler: Bad segment register number for memory access." */
    '\x13','\x9f','s','e','g','m','e','n','t',' ','\xeb','\xfb','\x10','\x86','a','c','c','e','s','s','.',
/* 0x1330d = "Virtual HDD is not opened." */
    'V','i','r','t','u','a','l',' ','H','D','D',' ','\x0b','\x08','o','p','e','n','e','d','.',
/* 0x13322 = "VERR_GMM_TOO_MANY_CHUNK_MAPPINGS" */
    '\x01','G','M','M','_','\x1a','\xac','C','H','U','N','K','_','M','A','P','P','I','N','G','S',
/* 0x13337 = "Cannot block in ring-0." */
    'C','a','n','n','o','t',' ','b','l','o','c','k',' ','\x0f','r','i','n','g','-','0','.',
/* 0x1334c = "Invalid GC physical address." */
    '\x0c','G','C',' ','p','h','y','s','i','c','a','l',' ','a','d','d','r','e','s','s','.',
/* 0x13361 = "Certificate signature algorithm mismatch." */
    '\xba','s','i','g','n','a','t','u','r','e',' ','\xd4','m','i','s','m','a','t','c','h','.',
/* 0x13376 = "VERR_PGM_PHYS_RAM_LOOKUP_IPE" */
    '\x01','\x8c','P','H','Y','S','_','R','A','M','_','L','O','O','K','U','P','_','I','P','E',
/* 0x1338b = "VERR_SUP_VP_EXE_MISSING_DYNAMIC_BASE" */
    '\x01','\x95','\xbd','E','X','E','_','\xc4','_','D','Y','N','A','M','I','C','_','B','A','S','E',
/* 0x133a0 = "Device i/o: Bad command." */
    'D','e','v','i','c','e',' ','i','/','o',':',' ','\x9f','c','o','m','m','a','n','d','.',
/* 0x133b5 = "A module name is too long." */
    'A',' ','m','o','d','u','l','e',' ','n','a','m','e',' ','\x0b','\x9e','l','o','n','g','.',
/* 0x133ca = "VERR_CR_PKCS7_MISSING_CONTENT_TYPE_ATTRIB" */
    '\x01','\x24','\xe5','\xc4','_','C','O','N','T','E','N','T','_','\xb5','_','A','T','T','R','I','B',
/* 0x133df = "VERR_GMM_SHARED_MODULE_NOT_FOUND" */
    '\x01','G','M','M','_','S','H','A','R','E','D','_','M','O','D','U','L','E','_','\x06','\x2a',
/* 0x133f4 = "VINF_PGM_NO_DIRTY_BIT_TRACKING" */
    '\x0e','\x8c','\x60','D','I','R','T','Y','_','B','I','T','_','T','R','A','C','K','I','N','G',
/* 0x13409 = "VFS chain element expected at least three arguments." */
    '\x8d',' ','\xa1','\x5c','\xc9','a','t',' ','l','e','a','s','t',' ','t','h','r','e','e',' ','\xdd',
/* 0x1341e = "Max threads number reached." */
    'M','a','x',' ','t','h','r','e','a','d','s',' ','\xfb','r','e','a','c','h','e','d','.',
/* 0x13433 = "VERR_RESERVED_PAGE_TABLE_BITS" */
    '\x01','R','E','S','E','R','V','E','D','_','\xdc','T','A','B','L','E','_','B','I','T','S',
/* 0x13448 = "VINF_DRIVER_REBOOT_NEEDED" */
    '\x0e','D','R','I','V','E','R','_','R','E','B','O','O','T','_','N','E','E','D','E','D',
/* 0x1345d = "VERR_DBGF_READ_ONLY_REGISTER" */
    '\x01','\xb9','_','R','E','A','D','_','O','N','L','Y','_','R','E','G','I','S','T','E','R',
/* 0x13472 = "Encountered an unexpected VM state." */
    '\xa5','\x87','u','n','e','x','p','e','c','t','e','d',' ','\xcd',' ','s','t','a','t','e','.',
/* 0x13487 = "One of the structure magics was wrong." */
    'O','n','e',' ','\x15','\x02','\xec','m','a','g','i','c','s',' ','\x11','w','r','o','n','g','.',
/* 0x1349c = "VERR_SUPLIB_WRITE_NON_SYS_GROUP" */
    '\x01','\xd6','W','R','I','T','E','_','N','O','N','_','S','Y','S','_','G','R','O','U','P',
/* 0x134b1 = "VERR_GMM_TOO_MANY_GLOBAL_MODULES" */
    '\x01','G','M','M','_','\x1a','\xac','G','L','O','B','A','L','_','M','O','D','U','L','E','S',
/* 0x134c6 = "VINF_CPUM_MATCHED_BY_NAME" */
    '\x0e','C','P','U','M','_','M','A','T','C','H','E','D','_','B','Y','_','N','A','M','E',
/* 0x134db = "VERR_LDRVI_INVALID_SECURITY_DIR_ENTRY" */
    '\x01','\xf4','\x05','S','E','C','U','R','I','T','Y','_','D','I','R','_','E','N','T','R','Y',
/* 0x134f0 = "VERR_EM_CANNOT_EXEC_GUEST" */
    '\x01','E','M','_','C','A','N','N','O','T','_','E','X','E','C','_','G','U','E','S','T',
/* 0x13505 = "VERR_LDR_FORWARDER_CHAIN_TOO_LONG" */
    '\x01','L','D','R','_','F','O','R','W','A','R','D','E','R','_','\x8e','\x1a','L','O','N','G',
/* 0x1351a = "VERR_GMM_BAD_SHARED_MODULE_SIZE" */
    '\x01','G','M','M','_','\x1d','S','H','A','R','E','D','_','M','O','D','U','L','E','_','\xf9',
/* 0x1352f = "Failed to obtain a pool page." */
    '\x8b','\x0a','o','b','t','a','i','n',' ','a',' ','p','o','o','l',' ','p','a','g','e','.',
/* 0x13544 = "VERR_XAR_MISSING_LENGTH_ELEMENT" */
    '\x01','X','A','R','_','\xc4','_','L','E','N','G','T','H','_','E','L','E','M','E','N','T',
/* 0x13559 = "Process Verification Failure: The memory content does not match the image file." */
    '\x1e','\x0d','\x12','\x03','\x86','\xf0','\xb2','\x08','m','a','t','c','h',' ','\x02','\x26','f','i','l','e','.',
/* 0x1356e = "VERR_CR_X509_NAME_EMPTY_SUB_SET" */
    '\x01','\x24','\xb7','N','A','M','E','_','E','M','P','T','Y','_','S','U','B','_','S','E','T',
/* 0x13583 = "The thread is terminating." */
    '\x03','t','h','r','e','a','d',' ','\x0b','t','e','r','m','i','n','a','t','i','n','g','.',
/* 0x13598 = "Wrong parameter type." */
    'W','r','o','n','g',' ','p','a','r','a','m','e','t','e','r',' ','t','y','p','e','.',
/* 0x135ad = "VERR_UDP_SERVER_DESTROYED" */
    '\x01','U','D','P','_','S','E','R','V','E','R','_','D','E','S','T','R','O','Y','E','D',
/* 0x135c2 = "Wrong JSON type for double value." */
    'W','r','o','n','g',' ','J','S','O','N',' ','\xf3','\x10','d','o','u','b','l','e',' ','\xe8',
/* 0x135d7 = "VERR_LDRPE_CERT_MALFORMED" */
    '\x01','L','D','R','P','E','_','C','E','R','T','_','M','A','L','F','O','R','M','E','D',
/* 0x135ec = "VERR_PGM_UNSUPPORTED_SHADOW_PAGING_MODE" */
    '\x01','\x8c','\x1c','S','H','A','D','O','W','_','P','A','G','I','N','G','_','M','O','D','E',
/* 0x13601 = "VERR_SUP_VP_NT_QI_PROCESS_NM_ERROR" */
    '\x01','\x95','\xbd','N','T','_','Q','I','_','P','R','O','C','E','S','S','_','N','M','_','\x1b',
/* 0x13616 = "VERR_EM_UNEXPECTED_MAPPING_CONFLICT" */
    '\x01','E','M','_','\x88','M','A','P','P','I','N','G','_','C','O','N','F','L','I','C','T',
/* 0x1362b = "VERR_DWARF_STACK_OVERFLOW" */
    '\x01','D','W','A','R','F','_','S','T','A','C','K','_','O','V','E','R','F','L','O','W',
/* 0x13640 = "VERR_NET_HOST_UNREACHABLE" */
    '\x01','N','E','T','_','H','O','S','T','_','U','N','R','E','A','C','H','A','B','L','E',
/* 0x13655 = "VERR_SUP_VP_UNDESIRABLE_MODULE" */
    '\x01','\x95','\xbd','U','N','D','E','S','I','R','A','B','L','E','_','M','O','D','U','L','E',
/* 0x1366a = "Too long name string." */
    'T','o','o',' ','l','o','n','g',' ','n','a','m','e',' ','s','t','r','i','n','g','.',
/* 0x1367f = "Generic audio device enumeration error." */
    '\xa6','a','u','d','i','o',' ','\xa3','e','n','u','m','e','r','a','t','i','o','n',' ','\x85',
/* 0x13694 = "VINF_PATM_HC_MMIO_PATCH_READ" */
    '\x0e','P','A','T','M','_','H','C','_','\xd3','_','P','A','T','C','H','_','R','E','A','D',
/* 0x136a9 = "VERR_LDRPE_GUARD_CF_STUFF" */
    '\x01','L','D','R','P','E','_','G','U','A','R','D','_','C','F','_','S','T','U','F','F',
/* 0x136be = "VERR_SSM_FIELD_OUT_OF_BOUNDS" */
    '\x01','\xb0','F','I','E','L','D','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x136d3 = "RTCache: cache is full." */
    'R','T','C','a','c','h','e',':',' ','c','a','c','h','e',' ','\x0b','f','u','l','l','.',
/* 0x136e8 = "Syntax error - expected binary operator." */
    '\xfa','\x09','-',' ','\xc9','b','i','n','a','r','y',' ','o','p','e','r','a','t','o','r','.',
/* 0x136fd = "Final OpenSSL PKIX verification failed." */
    'F','i','n','a','l',' ','O','p','e','n','S','S','L',' ','P','K','I','X',' ','\xf8','\x7b',
/* 0x13712 = "VERR_DBG_DUPLICATE_SYMBOL" */
    '\x01','D','B','G','_','D','U','P','L','I','C','A','T','E','_','S','Y','M','B','O','L',
/* 0x13727 = "VERR_ISOMK_IMPORT_ROOT_VOLUME_SEQ_NO" */
    '\x01','\x22','\x83','R','O','O','T','_','V','O','L','U','M','E','_','S','E','Q','_','N','O',
/* 0x1373c = "VERR_PATH_MATCH_UNKNOWN_VARIABLE" */
    '\x01','P','A','T','H','_','M','A','T','C','H','_','\x91','V','A','R','I','A','B','L','E',
/* 0x13751 = "VERR_SUP_VP_BAD_SECTION_VIRTUAL_SIZE" */
    '\x01','\x95','\xbd','\x1d','S','E','C','T','I','O','N','_','V','I','R','T','U','A','L','_','\xf9',
/* 0x13766 = "Not implemented for UDF." */
    'N','o','t',' ','i','m','p','l','e','m','e','n','t','e','d',' ','\x10','U','D','F','.',
/* 0x1377b = "VERR_IEM_RESTART_INSTRUCTION" */
    '\x01','\x9c','R','E','S','T','A','R','T','_','I','N','S','T','R','U','C','T','I','O','N',
/* 0x13790 = "Incorrect call order." */
    'I','n','c','o','r','r','e','c','t',' ','c','a','l','l',' ','o','r','d','e','r','.',
/* 0x137a5 = "Expected a right parentheses." */
    '\xb8','a',' ','r','i','g','h','t',' ','p','a','r','e','n','t','h','e','s','e','s','.',
/* 0x137ba = "Operation already in progress." */
    'O','p','e','r','a','t','i','o','n',' ','\x7f','\x0f','p','r','o','g','r','e','s','s','.',
/* 0x137cf = "VERR_FTP_DATA_CONN_INIT_FAILED" */
    '\x01','F','T','P','_','D','A','T','A','_','C','O','N','N','_','I','N','I','T','_','\x17',
/* 0x137e4 = "Reason for leaving RZ: I/O port read." */
    '\x93','\x10','\x81','R','Z',':',' ','I','/','O',' ','p','o','r','t',' ','r','e','a','d','.',
/* 0x137f9 = "Requested image is not opened." */
    'R','e','q','u','e','s','t','e','d',' ','\x26','\x0b','\x08','o','p','e','n','e','d','.',
/* 0x1380d = "Reason for leaving RZ: MMIO read/write." */
    '\x93','\x10','\x81','R','Z',':',' ','\xd3',' ','r','e','a','d','/','w','r','i','t','e','.',
/* 0x13821 = "The current operation was canceled." */
    '\x03','c','u','r','r','e','n','t',' ','\x96','\x11','c','a','n','c','e','l','e','d','.',
/* 0x13835 = "VERR_FAM_CONNECTION_LOST" */
    '\x01','F','A','M','_','C','O','N','N','E','C','T','I','O','N','_','L','O','S','T',
/* 0x13849 = "VERR_PDM_DEVINS_UNKNOWN_CFG_VALUES" */
    '\x01','\x7d','D','E','V','I','N','S','_','\x91','C','F','G','_','V','A','L','U','E','S',
/* 0x1385d = "Reached the end of the file." */
    'R','e','a','c','h','e','d',' ','\x02','e','n','d',' ','\x15','\x02','f','i','l','e','.',
/* 0x13871 = "EVP_DecryptInit_ex failed." */
    'E','V','P','_','D','e','c','r','y','p','t','I','n','i','t','_','e','x',' ','\x7b',
/* 0x13885 = "Too many symbolic links." */
    'T','o','o',' ','\xb4','s','y','m','b','o','l','i','c',' ','l','i','n','k','s','.',
/* 0x13899 = "The HGCM is saving state." */
    '\x03','H','G','C','M',' ','\x0b','s','a','v','i','n','g',' ','s','t','a','t','e','.',
/* 0x138ad = "VERR_XAR_BAD_OFFSET_ELEMENT" */
    '\x01','X','A','R','_','\x1d','O','F','F','S','E','T','_','E','L','E','M','E','N','T',
/* 0x138c1 = "Internal processing error #8 in the DBGF breakpoint manager code." */
    '\x07','\x04','\x09','#','8',' ','\x0f','\x02','\xb9',' ','\xbf','m','a','n','a','g','e','r',' ','\x84',
/* 0x138d5 = "VINF_IOM_R3_IOPORT_WRITE" */
    '\x0e','I','O','M','_','R','3','_','I','O','P','O','R','T','_','W','R','I','T','E',
/* 0x138e9 = "VINF_IPC_RECEIVE_MSG_CUT" */
    '\x0e','I','P','C','_','R','E','C','E','I','V','E','_','M','S','G','_','C','U','T',
/* 0x138fd = "Bad file user id for XAR file." */
    '\x9f','\x1f','u','s','e','r',' ','i','d',' ','\x10','X','A','R',' ','f','i','l','e','.',
/* 0x13911 = "URL not expected in SPC PE image data." */
    'U','R','L',' ','\x08','\xc9','\x0f','S','P','C',' ','P','E',' ','\x26','d','a','t','a','.',
/* 0x13925 = "Internal processing error #9 in the DBGF breakpoint manager code." */
    '\x07','\x04','\x09','#','9',' ','\x0f','\x02','\xb9',' ','\xbf','m','a','n','a','g','e','r',' ','\x84',
/* 0x13939 = "VERR_IEM_INSTR_BUF_OUT_OF_MEMORY" */
    '\x01','\x9c','I','N','S','T','R','_','B','U','F','_','O','U','T','_','O','F','_','\xb6',
/* 0x1394d = "VINF_RECORDING_THROTTLED" */
    '\x0e','R','E','C','O','R','D','I','N','G','_','T','H','R','O','T','T','L','E','D',
/* 0x13961 = "VERR_VD_PASSWORD_INCORRECT" */
    '\x01','\xff','P','A','S','S','W','O','R','D','_','I','N','C','O','R','R','E','C','T',
/* 0x13975 = "VERR_DBG_NOT_LINUX_KALLSYMS" */
    '\x01','D','B','G','_','\x06','L','I','N','U','X','_','K','A','L','L','S','Y','M','S',
/* 0x13989 = "VERR_HARDAVL_BAD_NEW_HEIGHT" */
    '\x01','H','A','R','D','A','V','L','_','\x1d','N','E','W','_','H','E','I','G','H','T',
/* 0x1399d = "VERR_PDM_MEDIAEX_IOREQID_NOT_FOUND" */
    '\x01','\x7d','M','E','D','I','A','E','X','_','I','O','R','E','Q','I','D','_','\x06','\x2a',
/* 0x139b1 = "Expected an element separator (| or :)." */
    '\xb8','\x87','\x5c','s','e','p','a','r','a','t','o','r',' ','(','|',' ','\xa9',':',')','.',
/* 0x139c5 = "VERR_VMM_WRONG_NEM_VMCPU_STATE" */
    '\x01','V','M','M','_','W','R','O','N','G','_','\xee','_','V','M','C','P','U','_','\xf1',
/* 0x139d9 = "VERR_SUP_VP_NO_KERNEL32_MAPPING" */
    '\x01','\x95','\xbd','\x60','K','E','R','N','E','L','3','2','_','M','A','P','P','I','N','G',
/* 0x139ed = "VERR_ASN1_OBJID_TOO_MANY_COMPONENTS" */
    '\x01','\xa2','O','B','J','I','D','_','\x1a','\xac','C','O','M','P','O','N','E','N','T','S',
/* 0x13a01 = "VERR_IPC_RECEIVE_TIMEOUT" */
    '\x01','I','P','C','_','R','E','C','E','I','V','E','_','T','I','M','E','O','U','T',
/* 0x13a15 = "VERR_IPC_RECEIVE_ABORTED" */
    '\x01','I','P','C','_','R','E','C','E','I','V','E','_','A','B','O','R','T','E','D',
/* 0x13a29 = "VERR_HGCM_TOO_MANY_CLIENT_CALLS" */
    '\x01','H','G','C','M','_','\x1a','\xac','C','L','I','E','N','T','_','C','A','L','L','S',
/* 0x13a3d = "VERR_CR_X509_CPV_NO_VALID_POLICY" */
    '\x01','\x24','\xb7','C','P','V','_','\x60','V','A','L','I','D','_','P','O','L','I','C','Y',
/* 0x13a51 = "VERR_PDM_BLOCK_UNKNOWN_TRANSLATION" */
    '\x01','\x7d','B','L','O','C','K','_','\x91','T','R','A','N','S','L','A','T','I','O','N',
/* 0x13a65 = "VINF_PGM_POOL_FLUSH_PENDING" */
    '\x0e','\x8c','P','O','O','L','_','F','L','U','S','H','_','P','E','N','D','I','N','G',
/* 0x13a79 = "VERR_UDP_SERVER_SHUTDOWN" */
    '\x01','U','D','P','_','S','E','R','V','E','R','_','S','H','U','T','D','O','W','N',
/* 0x13a8d = "Spinlock detection failed." */
    'S','p','i','n','l','o','c','k',' ','d','e','t','e','c','t','i','o','n',' ','\x7b',
/* 0x13aa1 = "The driver helper structure version has changed." */
    '\x03','\xc5','h','e','l','p','e','r',' ','\xec','\xcf','\x5e','c','h','a','n','g','e','d','.',
/* 0x13ab5 = "VERR_HGCM_SERVICE_EXISTS" */
    '\x01','H','G','C','M','_','S','E','R','V','I','C','E','_','E','X','I','S','T','S',
/* 0x13ac9 = "VERR_PROC_TCB_PRIV_NOT_HELD" */
    '\x01','P','R','O','C','_','T','C','B','_','P','R','I','V','_','\x06','H','E','L','D',
/* 0x13add = "VERR_FTP_STATUS_SERVER_ERROR" */
    '\x01','F','T','P','_','S','T','A','T','U','S','_','S','E','R','V','E','R','_','\x1b',
/* 0x13af1 = "VERR_COM_DONT_CALL_AGAIN" */
    '\x01','C','O','M','_','D','O','N','T','_','C','A','L','L','_','A','G','A','I','N',
/* 0x13b05 = "VERR_LDRLX_BAD_OBJECT_TABLE" */
    '\x01','L','D','R','L','X','_','\x1d','O','B','J','E','C','T','_','T','A','B','L','E',
/* 0x13b19 = "VERR_HARDAVL_UNEXPECTED_NULL_RIGHT" */
    '\x01','H','A','R','D','A','V','L','_','\x88','N','U','L','L','_','R','I','G','H','T',
/* 0x13b2d = "VERR_LDRPE_LOAD_CONFIG_SIZE" */
    '\x01','L','D','R','P','E','_','L','O','A','D','_','C','O','N','F','I','G','_','\xf9',
/* 0x13b41 = "VERR_XAR_ARCHIVED_HASH_MISMATCH" */
    '\x01','X','A','R','_','A','R','C','H','I','V','E','D','_','H','A','S','H','_','\x19',
/* 0x13b55 = "VERR_SUP_VP_UNEXPECTED_VALID_PATH_COUNT" */
    '\x01','\x95','\xbd','\x88','V','A','L','I','D','_','P','A','T','H','_','C','O','U','N','T',
/* 0x13b69 = "The device helper structure version has changed." */
    '\x03','\xa3','h','e','l','p','e','r',' ','\xec','\xcf','\x5e','c','h','a','n','g','e','d','.',
/* 0x13b7d = "VERR_CR_KEY_UNEXPECTED_CIPHER_PARAMS" */
    '\x01','\x24','K','E','Y','_','\x88','C','I','P','H','E','R','_','P','A','R','A','M','S',
/* 0x13b91 = "Internal processing error #7 in the DBGF breakpoint manager code." */
    '\x07','\x04','\x09','#','7',' ','\x0f','\x02','\xb9',' ','\xbf','m','a','n','a','g','e','r',' ','\x84',
/* 0x13ba5 = "Generic hypercall operation failure." */
    '\xa6','h','y','p','e','r','c','a','l','l',' ','\x96','f','a','i','l','u','r','e','.',
/* 0x13bb9 = "VERR_CR_PKCS7_MISSING_MESSAGE_DIGEST_ATTRIB" */
    '\x01','\x24','\xe5','\xc4','_','M','E','S','S','A','G','E','_','\xbe','A','T','T','R','I','B',
/* 0x13bcd = "VERR_VUSB_DEVICE_NAME_NOT_FOUND" */
    '\x01','V','U','S','B','_','D','E','V','I','C','E','_','N','A','M','E','_','\x06','\x2a',
/* 0x13be1 = "VERR_PDM_DEVICE_INSTANCE_NOT_FOUND" */
    '\x01','\x7d','D','E','V','I','C','E','_','I','N','S','T','A','N','C','E','_','\x06','\x2a',
/* 0x13bf5 = "VERR_CR_CIPHER_INVALID_KEY_LENGTH" */
    '\x01','\x24','C','I','P','H','E','R','_','\x05','K','E','Y','_','L','E','N','G','T','H',
/* 0x13c09 = "Device i/o: Bad length." */
    'D','e','v','i','c','e',' ','i','/','o',':',' ','\x9f','l','e','n','g','t','h','.',
/* 0x13c1d = "VERR_AUDIO_STREAM_NOT_READY" */
    '\x01','A','U','D','I','O','_','S','T','R','E','A','M','_','\x06','R','E','A','D','Y',
/* 0x13c31 = "No free input streams." */
    '\xdf','f','r','e','e',' ','i','n','p','u','t',' ','s','t','r','e','a','m','s','.',
/* 0x13c45 = "FTP initialization failed." */
    'F','T','P',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','\x7b',
/* 0x13c59 = "VERR_IOM_IOPORTS_NOT_MAPPED" */
    '\x01','I','O','M','_','I','O','P','O','R','T','S','_','\x06','M','A','P','P','E','D',
/* 0x13c6d = "VERR_PDM_TOO_MANY_DEVICE_INSTANCES" */
    '\x01','\x7d','\x1a','\xac','D','E','V','I','C','E','_','I','N','S','T','A','N','C','E','S',
/* 0x13c81 = "Expected a left parentheses." */
    '\xb8','a',' ','l','e','f','t',' ','p','a','r','e','n','t','h','e','s','e','s','.',
/* 0x13c95 = "VERR_VFS_CHAIN_EXPECTED_ELEMENT" */
    '\x01','\x8d','_','\x8e','E','X','P','E','C','T','E','D','_','E','L','E','M','E','N','T',
/* 0x13ca9 = "VERR_XAR_HASH_FUNCTION_MISMATCH" */
    '\x01','X','A','R','_','H','A','S','H','_','F','U','N','C','T','I','O','N','_','\x19',
/* 0x13cbd = "VERR_IOM_IOPORTS_ALREADY_MAPPED" */
    '\x01','I','O','M','_','I','O','P','O','R','T','S','_','\x9b','M','A','P','P','E','D',
/* 0x13cd1 = "VERR_SUP_VP_NOT_KNOWN_DLL_OR_EXE" */
    '\x01','\x95','\xbd','\x06','K','N','O','W','N','_','D','L','L','_','O','R','_','E','X','E',
/* 0x13ce5 = "Internal processing error #6 in the DBGF breakpoint manager code." */
    '\x07','\x04','\x09','#','6',' ','\x0f','\x02','\xb9',' ','\xbf','m','a','n','a','g','e','r',' ','\x84',
/* 0x13cf9 = "VINF_PATCH_EMULATE_INSTR" */
    '\x0e','P','A','T','C','H','_','E','M','U','L','A','T','E','_','I','N','S','T','R',
/* 0x13d0d = "VERR_SUPDRV_TRACER_ALREADY_REGISTERED" */
    '\x01','\x90','T','R','A','C','E','R','_','\x9b','R','E','G','I','S','T','E','R','E','D',
/* 0x13d21 = "Bad DWARF line number header." */
    '\x9f','D','W','A','R','F',' ','l','i','n','e',' ','\xfb','h','e','a','d','e','r','.',
/* 0x13d35 = "VERR_SUP_VP_BAD_FILE_ALIGNMENT_VALUE" */
    '\x01','\x95','\xbd','\x1d','\xab','A','L','I','G','N','M','E','N','T','_','V','A','L','U','E',
/* 0x13d49 = "Internal processing error #1 in the DBGF breakpoint manager code." */
    '\x07','\x04','\x09','#','1',' ','\x0f','\x02','\xb9',' ','\xbf','m','a','n','a','g','e','r',' ','\x84',
/* 0x13d5d = "Reason for leaving RC: Double Fault." */
    '\x93','\x10','\x81','R','C',':',' ','D','o','u','b','l','e',' ','F','a','u','l','t','.',
/* 0x13d71 = "VERR_VSCSI_LUN_NOT_ATTACHED" */
    '\x01','V','S','C','S','I','_','L','U','N','_','\x06','A','T','T','A','C','H','E','D',
/* 0x13d85 = "Process Verification Failure: Bad optional header field." */
    '\x1e','\x0d','\x12','\x9f','o','p','t','i','o','n','a','l',' ','\xb3','f','i','e','l','d','.',
/* 0x13d99 = "Too fragmented file." */
    'T','o','o',' ','f','r','a','g','m','e','n','t','e','d',' ','f','i','l','e','.',
/* 0x13dad = "Already initialized." */
    'A','l','r','e','a','d','y',' ','i','n','i','t','i','a','l','i','z','e','d','.',
/* 0x13dc1 = "Unsupported ISO protocol feature." */
    '\x98','\xc1',' ','p','r','o','t','o','c','o','l',' ','f','e','a','t','u','r','e','.',
/* 0x13dd5 = "VERR_ISOMK_IMPORT_BAD_PRIMARY_VOL_DESC" */
    '\x01','\x22','\x83','\x1d','P','R','I','M','A','R','Y','_','V','O','L','_','D','E','S','C',
/* 0x13de9 = "VERR_GVMM_HOST_CPU_RANGE" */
    '\x01','G','V','M','M','_','H','O','S','T','_','C','P','U','_','R','A','N','G','E',
/* 0x13dfd = "VERR_IOMMU_INTR_REMAP_DENIED" */
    '\x01','\xfd','_','I','N','T','R','_','R','E','M','A','P','_','D','E','N','I','E','D',
/* 0x13e11 = "VERR_INCOMPATIBLE_CONFIG" */
    '\x01','I','N','C','O','M','P','A','T','I','B','L','E','_','C','O','N','F','I','G',
/* 0x13e25 = "Missing data element for XAR file." */
    'M','i','s','s','i','n','g',' ','\x9d','\x5c','\x10','X','A','R',' ','f','i','l','e','.',
/* 0x13e39 = "VERR_SUP_VP_NT_QI_VIRTUAL_MEMORY_ERROR" */
    '\x01','\x95','\xbd','N','T','_','Q','I','_','V','I','R','T','U','A','L','_','\xb6','_','\x1b',
/* 0x13e4d = "VERR_PGM_INVALID_GC_PHYSICAL_RANGE" */
    '\x01','\x8c','\x05','G','C','_','P','H','Y','S','I','C','A','L','_','R','A','N','G','E',
/* 0x13e61 = "VERR_LDR_GENERAL_FAILURE" */
    '\x01','L','D','R','_','G','E','N','E','R','A','L','_','F','A','I','L','U','R','E',
/* 0x13e75 = "Failed to allocate VM memory." */
    '\x8b','\x0a','a','l','l','o','c','a','t','e',' ','\xcd',' ','m','e','m','o','r','y','.',
/* 0x13e89 = "VERR_TAR_BAD_NUM_FIELD_TERM" */
    '\x01','T','A','R','_','\x1d','N','U','M','_','F','I','E','L','D','_','T','E','R','M',
/* 0x13e9d = "VERR_SUPDRV_TRACER_TOO_MANY_PROVIDERS" */
    '\x01','\x90','T','R','A','C','E','R','_','\x1a','\xac','P','R','O','V','I','D','E','R','S',
/* 0x13eb1 = "VERR_TCP_SERVER_SHUTDOWN" */
    '\x01','T','C','P','_','S','E','R','V','E','R','_','S','H','U','T','D','O','W','N',
/* 0x13ec5 = "The object in question already exists." */
    '\x03','\xa8','\x0f','q','u','e','s','t','i','o','n',' ','\x7f','e','x','i','s','t','s','.',
/* 0x13ed9 = "VERR_GMM_TOO_MANY_PER_VM_MODULES" */
    '\x01','G','M','M','_','\x1a','\xac','P','E','R','_','\xcd','_','M','O','D','U','L','E','S',
/* 0x13eed = "VERR_SUPDRV_TRACER_NOT_REGISTERED" */
    '\x01','\x90','T','R','A','C','E','R','_','\x06','R','E','G','I','S','T','E','R','E','D',
/* 0x13f01 = "No conflicts to resolve." */
    '\xdf','c','o','n','f','l','i','c','t','s',' ','\x0a','r','e','s','o','l','v','e','.',
/* 0x13f15 = "VERR_ASN1_EXPECTED_PRIMITIVE" */
    '\x01','\xa2','E','X','P','E','C','T','E','D','_','P','R','I','M','I','T','I','V','E',
/* 0x13f29 = "Duplicate something." */
    'D','u','p','l','i','c','a','t','e',' ','s','o','m','e','t','h','i','n','g','.',
/* 0x13f3d = "VERR_DBGC_PARSE_ARGUMENT_OVERFLOW" */
    '\x01','\xfc','\xe4','A','R','G','U','M','E','N','T','_','O','V','E','R','F','L','O','W',
/* 0x13f51 = "VERR_PCI_PASSTHROUGH_NO_HM" */
    '\x01','P','C','I','_','P','A','S','S','T','H','R','O','U','G','H','_','\x60','H','M',
/* 0x13f65 = "VERR_SSM_NO_PENDING_OPERATION" */
    '\x01','\xb0','\x60','P','E','N','D','I','N','G','_','O','P','E','R','A','T','I','O','N',
/* 0x13f79 = "VERR_GMM_ALLOC_PAGES_IPE" */
    '\x01','G','M','M','_','A','L','L','O','C','_','P','A','G','E','S','_','I','P','E',
/* 0x13f8d = "VERR_FILE_AIO_LIMIT_EXCEEDED" */
    '\x01','\xab','A','I','O','_','L','I','M','I','T','_','E','X','C','E','E','D','E','D',
/* 0x13fa1 = "UDF directory too large for import." */
    'U','D','F',' ','\x25','\x9e','l','a','r','g','e',' ','\x10','i','m','p','o','r','t','.',
/* 0x13fb5 = "VINF_CSAM_PENDING_ACTION" */
    '\x0e','C','S','A','M','_','P','E','N','D','I','N','G','_','A','C','T','I','O','N',
/* 0x13fc9 = "VERR_VUSB_FAILED_TO_QUEUE_URB" */
    '\x01','V','U','S','B','_','\x17','_','T','O','_','Q','U','E','U','E','_','U','R','B',
/* 0x13fdd = "VFS chain element expected at most three arguments." */
    '\x8d',' ','\xa1','\x5c','\xc9','a','t',' ','m','o','s','t',' ','t','h','r','e','e',' ','\xdd',
/* 0x13ff1 = "VINF_DBGF_R3_BP_OWNER_DEFER" */
    '\x0e','\xb9','_','R','3','_','B','P','_','O','W','N','E','R','_','D','E','F','E','R',
/* 0x14005 = "VERR_PDM_INVALID_DEVICE_GUEST_BITS" */
    '\x01','\x7d','\x05','D','E','V','I','C','E','_','G','U','E','S','T','_','B','I','T','S',
/* 0x14019 = "VFS chain element expected at least five arguments." */
    '\x8d',' ','\xa1','\x5c','\xc9','a','t',' ','l','e','a','s','t',' ','f','i','v','e',' ','\xdd',
/* 0x1402d = "Internal processing error #3 in the DBGF breakpoint manager code." */
    '\x07','\x04','\x09','#','3',' ','\x0f','\x02','\xb9',' ','\xbf','m','a','n','a','g','e','r',' ','\x84',
/* 0x14041 = "The certificate path has no trust anchor." */
    '\x03','\xa0','\xd0','\x5e','n','o',' ','t','r','u','s','t',' ','a','n','c','h','o','r','.',
/* 0x14055 = "VERR_IEM_EMIT_UNEXPECTED_VAR_REGISTER" */
    '\x01','\x9c','E','M','I','T','_','\x88','V','A','R','_','R','E','G','I','S','T','E','R',
/* 0x14069 = "VERR_RECORDING_FORMAT_NOT_SUPPORTED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','F','O','R','M','A','T','_','\x06','\x82',
/* 0x1407d = "VERR_RT_REQUEST_INVALID_PACKAGE" */
    '\x01','R','T','_','R','E','Q','U','E','S','T','_','\x05','P','A','C','K','A','G','E',
/* 0x14091 = "VERR_VFS_CHAIN_AT_LEAST_ONE_ARG" */
    '\x01','\x8d','_','\x8e','A','T','_','L','E','A','S','T','_','O','N','E','_','A','R','G',
/* 0x140a5 = "VERR_PDM_DRIVER_INVALID_PROPERTIES" */
    '\x01','\x7d','D','R','I','V','E','R','_','\x05','P','R','O','P','E','R','T','I','E','S',
/* 0x140b9 = "Protocol not available." */
    'P','r','o','t','o','c','o','l',' ','\x08','a','v','a','i','l','a','b','l','e','.',
/* 0x140cd = "Unexpected SVM exception exit." */
    '\x94','S','V','M',' ','e','x','c','e','p','t','i','o','n',' ','e','x','i','t','.',
/* 0x140e1 = "VERR_ISOFS_TOO_MANY_ICB_INDIRECTIONS" */
    '\x01','\x97','\x1a','\xac','I','C','B','_','I','N','D','I','R','E','C','T','I','O','N','S',
/* 0x140f5 = "VERR_CR_PKCS7_MESSAGE_DIGEST_ATTRIB_MISMATCH" */
    '\x01','\x24','\xe5','M','E','S','S','A','G','E','_','\xbe','A','T','T','R','I','B','_','\x19',
/* 0x14109 = "The driver instance could not be found." */
    '\x03','\xc5','i','n','s','t','a','n','c','e',' ','c','o','u','l','d',' ','\x08','\xa7','\x89',
/* 0x1411d = "VERR_CR_KEY_DEK_INFO_TOO_LONG" */
    '\x01','\x24','K','E','Y','_','D','E','K','_','I','N','F','O','_','\x1a','L','O','N','G',
/* 0x14131 = "The specified thread is not waitable." */
    '\x03','\x18','t','h','r','e','a','d',' ','\x0b','\x08','w','a','i','t','a','b','l','e','.',
/* 0x14145 = "VFS chain element expected at least four arguments." */
    '\x8d',' ','\xa1','\x5c','\xc9','a','t',' ','l','e','a','s','t',' ','f','o','u','r',' ','\xdd',
/* 0x14159 = "VERR_SSM_VOTE_FOR_GIVING_UP" */
    '\x01','\xb0','V','O','T','E','_','F','O','R','_','G','I','V','I','N','G','_','U','P',
/* 0x1416d = "Internal processing error #1 in the PDM Thread code." */
    '\x07','\x04','\x09','#','1',' ','\x0f','\x02','P','D','M',' ','T','h','r','e','a','d',' ','\x84',
/* 0x14181 = "Internal processing error #2 in the DBGF breakpoint manager code." */
    '\x07','\x04','\x09','#','2',' ','\x0f','\x02','\xb9',' ','\xbf','m','a','n','a','g','e','r',' ','\x84',
/* 0x14195 = "Unable to start VM execution." */
    '\xe0','\x0a','s','t','a','r','t',' ','\xcd',' ','e','x','e','c','u','t','i','o','n','.',
/* 0x141a9 = "VERR_VFS_CHAIN_AT_MOST_TWO_ARGS" */
    '\x01','\x8d','_','\x8e','A','T','_','M','O','S','T','_','T','W','O','_','A','R','G','S',
/* 0x141bd = "VERR_APIC_INTR_DISCARDED" */
    '\x01','A','P','I','C','_','I','N','T','R','_','D','I','S','C','A','R','D','E','D',
/* 0x141d1 = "VERR_VFS_CHAIN_AT_MOST_SIX_ARGS" */
    '\x01','\x8d','_','\x8e','A','T','_','M','O','S','T','_','S','I','X','_','A','R','G','S',
/* 0x141e5 = "VERR_VM_DRIVER_NOT_INSTALLED" */
    '\x01','\xcd','_','D','R','I','V','E','R','_','\x06','I','N','S','T','A','L','L','E','D',
/* 0x141f9 = "VERR_SUPDRV_VTG_BAD_HDR_NOT_MULTIPLE" */
    '\x01','\x90','V','T','G','_','\x1d','H','D','R','_','\x06','M','U','L','T','I','P','L','E',
/* 0x1420d = "VERR_IOM_IOPORT_RANGE_NOT_FOUND" */
    '\x01','I','O','M','_','I','O','P','O','R','T','_','R','A','N','G','E','_','\x06','\x2a',
/* 0x14221 = "The I/O request ID is already existing." */
    '\x03','I','/','O',' ','\xaa','I','D',' ','\x0b','\x7f','e','x','i','s','t','i','n','g','.',
/* 0x14235 = "VERR_SSM_FIELD_NOT_CONSECUTIVE" */
    '\x01','\xb0','F','I','E','L','D','_','\x06','C','O','N','S','E','C','U','T','I','V','E',
/* 0x14249 = "VERR_ISOFS_BAD_LVD_DESC_CHAR_SET" */
    '\x01','\x97','\x1d','L','V','D','_','D','E','S','C','_','C','H','A','R','_','S','E','T',
/* 0x1425d = "VERR_RECORDING_THROTTLED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','T','H','R','O','T','T','L','E','D',
/* 0x14271 = "VERR_CR_CIPHER_INVALID_TAG_LENGTH" */
    '\x01','\x24','C','I','P','H','E','R','_','\x05','T','A','G','_','L','E','N','G','T','H',
/* 0x14285 = "VERR_LDRVI_BAD_CERT_HDR_REVISION" */
    '\x01','\xf4','\x1d','C','E','R','T','_','H','D','R','_','R','E','V','I','S','I','O','N',
/* 0x14299 = "Image hash mismatch." */
    'I','m','a','g','e',' ','h','a','s','h',' ','m','i','s','m','a','t','c','h','.',
/* 0x142ad = "VINF_VRDP_THREAD_STARTED" */
    '\x0e','V','R','D','P','_','T','H','R','E','A','D','_','S','T','A','R','T','E','D',
/* 0x142c1 = "VWRN_RECORDING_ENCODING_SKIPPED" */
    '\xe6','R','E','C','O','R','D','I','N','G','_','\xc6','_','S','K','I','P','P','E','D',
/* 0x142d5 = "VERR_VMM_RING0_ASSERTION" */
    '\x01','V','M','M','_','R','I','N','G','0','_','A','S','S','E','R','T','I','O','N',
/* 0x142e9 = "Trailing characters." */
    'T','r','a','i','l','i','n','g',' ','c','h','a','r','a','c','t','e','r','s','.',
/* 0x142fd = "VERR_PDM_DRVINS_UNKNOWN_CFG_VALUES" */
    '\x01','\x7d','D','R','V','I','N','S','_','\x91','C','F','G','_','V','A','L','U','E','S',
/* 0x14311 = "VERR_PDM_DRIVER_INSTANCE_NOT_FOUND" */
    '\x01','\x7d','D','R','I','V','E','R','_','I','N','S','T','A','N','C','E','_','\x06','\x2a',
/* 0x14325 = "VERR_IEM_INSTR_NOT_IMPLEMENTED" */
    '\x01','\x9c','I','N','S','T','R','_','\x06','I','M','P','L','E','M','E','N','T','E','D',
/* 0x14339 = "A GMM sanity check failed." */
    'A',' ','G','M','M',' ','s','a','n','i','t','y',' ','c','h','e','c','k',' ','\x7b',
/* 0x1434d = "NtQueryObject/Type failed." */
    'N','t','Q','u','e','r','y','O','b','j','e','c','t','/','T','y','p','e',' ','\x7b',
/* 0x14361 = "VERR_XAR_BAD_LENGTH_ELEMENT" */
    '\x01','X','A','R','_','\x1d','L','E','N','G','T','H','_','E','L','E','M','E','N','T',
/* 0x14375 = "VERR_ASN1_OBJID_TOO_LONG_STRING_FORM" */
    '\x01','\xa2','O','B','J','I','D','_','\x1a','L','O','N','G','_','\xd5','_','F','O','R','M',
/* 0x14389 = "VERR_NS_SYMLINK_SET_TIME" */
    '\x01','N','S','_','S','Y','M','L','I','N','K','_','S','E','T','_','T','I','M','E',
/* 0x1439d = "VERR_SUPDRV_VTG_BAD_PROBE_ENABLED" */
    '\x01','\x90','V','T','G','_','\x1d','P','R','O','B','E','_','E','N','A','B','L','E','D',
/* 0x143b1 = "Bad file inode device number for XAR file." */
    '\x9f','\x1f','i','n','o','d','e',' ','\xa3','\xfb','\x10','X','A','R',' ','f','i','l','e','.',
/* 0x143c5 = "Syntax error - invalid operator usage." */
    '\xfa','\x09','-',' ','\x8f','o','p','e','r','a','t','o','r',' ','u','s','a','g','e','.',
/* 0x143d9 = "VERR_CR_X509_PUBLIC_KEY_TOO_SMALL" */
    '\x01','\x24','\xb7','P','U','B','L','I','C','_','K','E','Y','_','\x1a','S','M','A','L','L',
/* 0x143ed = "VERR_PGM_SAVED_ROM_RANGE_NOT_FOUND" */
    '\x01','\x8c','S','A','V','E','D','_','R','O','M','_','R','A','N','G','E','_','\x06','\x2a',
/* 0x14401 = "Request was redirected." */
    'R','e','q','u','e','s','t',' ','\x11','r','e','d','i','r','e','c','t','e','d','.',
/* 0x14415 = "VERR_PROC_APT_PRIV_NOT_HELD" */
    '\x01','P','R','O','C','_','A','P','T','_','P','R','I','V','_','\x06','H','E','L','D',
/* 0x14429 = "Reserved page table bits set." */
    'R','e','s','e','r','v','e','d',' ','\xcc','\xb1','b','i','t','s',' ','s','e','t','.',
/* 0x1443d = "VERR_TM_TIMER_UNSTABLE_STATE" */
    '\x01','T','M','_','T','I','M','E','R','_','U','N','S','T','A','B','L','E','_','\xf1',
/* 0x14451 = "VERR_ISOMK_IPE_PRODUCE_TRANS_TBL" */
    '\x01','\x22','\x14','P','R','O','D','U','C','E','_','T','R','A','N','S','_','T','B','L',
/* 0x14465 = "VINF_IOM_R3_MMIO_READ_WRITE" */
    '\x0e','I','O','M','_','R','3','_','\xd3','_','R','E','A','D','_','W','R','I','T','E',
/* 0x14479 = "Internal processing error #4 in the DBGF breakpoint manager code." */
    '\x07','\x04','\x09','#','4',' ','\x0f','\x02','\xb9',' ','\xbf','m','a','n','a','g','e','r',' ','\x84',
/* 0x1448d = "VERR_CR_PKCS7_BAD_CONTENT_TYPE_ATTRIB" */
    '\x01','\x24','\xe5','\x1d','C','O','N','T','E','N','T','_','\xb5','_','A','T','T','R','I','B',
/* 0x144a1 = "Invalid timer queue number." */
    '\x0c','t','i','m','e','r',' ','q','u','e','u','e',' ','n','u','m','b','e','r','.',
/* 0x144b5 = "VERR_SVM_VMRUN_PRECOND_2" */
    '\x01','S','V','M','_','V','M','R','U','N','_','P','R','E','C','O','N','D','_','2',
/* 0x144c9 = "The bucket/key wasn\'t found." */
    '\x03','b','u','c','k','e','t','/','k','e','y',' ','w','a','s','n','\'','t',' ','\x89',
/* 0x144dd = "VERR_PGM_PHYS_TLB_CATCH_ALL" */
    '\x01','\x8c','P','H','Y','S','_','T','L','B','_','C','A','T','C','H','_','A','L','L',
/* 0x144f1 = "VERR_SVM_VMRUN_PRECOND_0" */
    '\x01','S','V','M','_','V','M','R','U','N','_','P','R','E','C','O','N','D','_','0',
/* 0x14505 = "VERR_SVM_VMRUN_PRECOND_1" */
    '\x01','S','V','M','_','V','M','R','U','N','_','P','R','E','C','O','N','D','_','1',
/* 0x14519 = "VINF_PGM_HANDLER_DO_DEFAULT" */
    '\x0e','\x8c','H','A','N','D','L','E','R','_','D','O','_','D','E','F','A','U','L','T',
/* 0x1452d = "Operation in progress." */
    'O','p','e','r','a','t','i','o','n',' ','\x0f','p','r','o','g','r','e','s','s','.',
/* 0x14541 = "VERR_DBG_INVALID_SEGMENT_OFFSET" */
    '\x01','D','B','G','_','\x05','S','E','G','M','E','N','T','_','O','F','F','S','E','T',
/* 0x14555 = "VERR_DBG_SPECIAL_SEGMENT" */
    '\x01','D','B','G','_','S','P','E','C','I','A','L','_','S','E','G','M','E','N','T',
/* 0x14569 = "VERR_VGA_GL_LOAD_FAILURE" */
    '\x01','V','G','A','_','G','L','_','L','O','A','D','_','F','A','I','L','U','R','E',
/* 0x1457d = "VERR_PDM_TOO_MANY_DRIVER_INSTANCES" */
    '\x01','\x7d','\x1a','\xac','D','R','I','V','E','R','_','I','N','S','T','A','N','C','E','S',
/* 0x14591 = "VERR_PAGE_COUNT_OUT_OF_RANGE" */
    '\x01','\xdc','C','O','U','N','T','_','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x145a5 = "Cipher algorithm is not known to us." */
    'C','i','p','h','e','r',' ','\xd4','\x0b','\x08','k','n','o','w','n',' ','\x0a','u','s','.',
/* 0x145b9 = "VERR_SVM_VMRUN_PRECOND_3" */
    '\x01','S','V','M','_','V','M','R','U','N','_','P','R','E','C','O','N','D','_','3',
/* 0x145cd = "VERR_AUDIO_ENUMERATION_FAILED" */
    '\x01','A','U','D','I','O','_','E','N','U','M','E','R','A','T','I','O','N','_','\x17',
/* 0x145e1 = "Internal processing error #5 in the DBGF breakpoint manager code." */
    '\x07','\x04','\x09','#','5',' ','\x0f','\x02','\xb9',' ','\xbf','m','a','n','a','g','e','r',' ','\x84',
/* 0x145f5 = "Recompiler: Unimplemented case." */
    '\x13','U','n','i','m','p','l','e','m','e','n','t','e','d',' ','c','a','s','e','.',
/* 0x14609 = "Internal processing error #2 in the PDM Thread code." */
    '\x07','\x04','\x09','#','2',' ','\x0f','\x02','P','D','M',' ','T','h','r','e','a','d',' ','\x84',
/* 0x1461d = "VERR_DBG_DEFERRED_LOAD_FAILED" */
    '\x01','D','B','G','_','D','E','F','E','R','R','E','D','_','L','O','A','D','_','\x17',
/* 0x14631 = "VERR_CPUM_INVALID_HWVIRT_CONFIG" */
    '\x01','C','P','U','M','_','\x05','H','W','V','I','R','T','_','C','O','N','F','I','G',
/* 0x14645 = "Undesirable module." */
    'U','n','d','e','s','i','r','a','b','l','e',' ','m','o','d','u','l','e','.',
/* 0x14658 = "VINF_VD_ASYNC_IO_FINISHED" */
    '\x0e','\xff','A','S','Y','N','C','_','I','O','_','F','I','N','I','S','H','E','D',
/* 0x1466b = "Too many components in an ASN." */
    'T','o','o',' ','\xb4','c','o','m','p','o','n','e','n','t','s',' ','\x0f','\x87','\xf6',
/* 0x1467e = "VERR_NET_ADDRESS_IN_USE" */
    '\x01','N','E','T','_','A','D','D','R','E','S','S','_','I','N','_','U','S','E',
/* 0x14691 = "The host kernel is too old." */
    '\x03','h','o','s','t',' ','k','e','r','n','e','l',' ','\x0b','\x9e','o','l','d','.',
/* 0x146a4 = "Process Verification Failure: Error querying process name." */
    '\x1e','\x0d','\x12','\xc0','q','u','e','r','y','i','n','g',' ','\x92','n','a','m','e','.',
/* 0x146b7 = "VERR_WEB_NOT_AUTHENTICATED" */
    '\x01','W','E','B','_','\x06','A','U','T','H','E','N','T','I','C','A','T','E','D',
/* 0x146ca = "VERR_CPUM_INVALID_CONFIG_VALUE" */
    '\x01','C','P','U','M','_','\x05','C','O','N','F','I','G','_','V','A','L','U','E',
/* 0x146dd = "VERR_XAR_UNSUPPORTED_HASH_FUNCTION" */
    '\x01','X','A','R','_','\x1c','H','A','S','H','_','F','U','N','C','T','I','O','N',
/* 0x146f0 = "Shared Clipboard guest error." */
    'S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','\xbb','\x85',
/* 0x14703 = "VERR_DBG_INVALID_SEGMENT_INDEX" */
    '\x01','D','B','G','_','\x05','S','E','G','M','E','N','T','_','I','N','D','E','X',
/* 0x14716 = "VINF_VRDP_OUTPUT_ENABLE" */
    '\x0e','V','R','D','P','_','O','U','T','P','U','T','_','E','N','A','B','L','E',
/* 0x14729 = "VERR_CR_PKCS7_DIGEST_ALGO_NOT_FOUND_IN_LIST" */
    '\x01','\x24','\xe5','\xbe','A','L','G','O','_','\x06','\x2a','_','I','N','_','L','I','S','T',
/* 0x1473c = "Bad left right height." */
    '\x9f','l','e','f','t',' ','r','i','g','h','t',' ','h','e','i','g','h','t','.',
/* 0x1474f = "Compromised digest." */
    'C','o','m','p','r','o','m','i','s','e','d',' ','d','i','g','e','s','t','.',
/* 0x14762 = "VERR_SSM_IDE_ASYNC_TIMEOUT" */
    '\x01','\xb0','I','D','E','_','A','S','Y','N','C','_','T','I','M','E','O','U','T',
/* 0x14775 = "Generic: Invalid image file header." */
    'G','e','n','e','r','i','c',':',' ','\x0c','\x26','\x1f','h','e','a','d','e','r','.',
/* 0x14788 = "VERR_SHCLPB_EVENT_ID_NOT_FOUND" */
    '\x01','S','H','C','L','P','B','_','E','V','E','N','T','_','I','D','_','\x06','\x2a',
/* 0x1479b = "VERR_SUPDRV_TRACER_BAD_ARG_FLAGS" */
    '\x01','\x90','T','R','A','C','E','R','_','\x1d','A','R','G','_','F','L','A','G','S',
/* 0x147ae = "Certificate path validator: No trusted certificate paths." */
    '\xba','\xd0','\xfe','\xdf','t','r','u','s','t','e','d',' ','\xa0','p','a','t','h','s','.',
/* 0x147c1 = "VERR_PDM_INVALID_DRIVER_HOST_BITS" */
    '\x01','\x7d','\x05','D','R','I','V','E','R','_','H','O','S','T','_','B','I','T','S',
/* 0x147d4 = "VERR_HM_SUSPEND_PENDING" */
    '\x01','H','M','_','S','U','S','P','E','N','D','_','P','E','N','D','I','N','G',
/* 0x147e7 = "VINF_VMX_VMLAUNCH_VMRESUME" */
    '\x0e','\xe2','V','M','L','A','U','N','C','H','_','V','M','R','E','S','U','M','E',
/* 0x147fa = "VERR_NAT_REDIR_GUEST_IP" */
    '\x01','N','A','T','_','R','E','D','I','R','_','G','U','E','S','T','_','I','P',
/* 0x1480d = "HTTP Internal Server Error." */
    'H','T','T','P',' ','\x07','S','e','r','v','e','r',' ','E','r','r','o','r','.',
/* 0x14820 = "VINF_ACCOUNT_RESTRICTED" */
    '\x0e','A','C','C','O','U','N','T','_','R','E','S','T','R','I','C','T','E','D',
/* 0x14833 = "VERR_ASN1_CURSOR_NO_MORE_DATA" */
    '\x01','\xa2','C','U','R','S','O','R','_','\x60','M','O','R','E','_','D','A','T','A',
/* 0x14846 = "Bad file inode number for XAR file." */
    '\x9f','\x1f','i','n','o','d','e',' ','\xfb','\x10','X','A','R',' ','f','i','l','e','.',
/* 0x14859 = "VERR_VD_RAW_SIZE_FLOPPY_TOO_BIG" */
    '\x01','\xff','R','A','W','_','\xf9','_','F','L','O','P','P','Y','_','\x1a','B','I','G',
/* 0x1486c = "Failed to generate RSA key." */
    '\x8b','\x0a','g','e','n','e','r','a','t','e',' ','R','S','A',' ','k','e','y','.',
/* 0x1487f = "VERR_PGM_UNSUPPORTED_HOST_PAGING_MODE" */
    '\x01','\x8c','\x1c','H','O','S','T','_','P','A','G','I','N','G','_','M','O','D','E',
/* 0x14892 = "VERR_SSM_LOW_ON_DISK_SPACE" */
    '\x01','\xb0','L','O','W','_','O','N','_','D','I','S','K','_','S','P','A','C','E',
/* 0x148a5 = "VERR_CR_DIGEST_OSSL_DIGEST_CTX_COPY_ERROR" */
    '\x01','\x24','\xbe','O','S','S','L','_','\xbe','C','T','X','_','C','O','P','Y','_','\x1b',
/* 0x148b8 = "A signal is already pending." */
    'A',' ','s','i','g','n','a','l',' ','\x0b','\x7f','p','e','n','d','i','n','g','.',
/* 0x148cb = "VERR_TAR_UNSUPPORTED_SOLARIS_HDR_TYPE" */
    '\x01','T','A','R','_','\x1c','S','O','L','A','R','I','S','_','H','D','R','_','\xb5',
/* 0x148de = "The requested allocation is too big." */
    '\x03','\xde','a','l','l','o','c','a','t','i','o','n',' ','\x0b','\x9e','b','i','g','.',
/* 0x148f1 = "VERR_PDM_DRIVER_NAME_CLASH" */
    '\x01','\x7d','D','R','I','V','E','R','_','N','A','M','E','_','C','L','A','S','H',
/* 0x14904 = "VERR_SUP_VP_NON_SYSTEM32_DLL" */
    '\x01','\x95','\xbd','N','O','N','_','S','Y','S','T','E','M','3','2','_','D','L','L',
/* 0x14917 = "VINF_PATM_PATCH_TRAP_GP" */
    '\x0e','P','A','T','M','_','P','A','T','C','H','_','T','R','A','P','_','G','P',
/* 0x1492a = "Invalid GC physical range." */
    '\x0c','G','C',' ','p','h','y','s','i','c','a','l',' ','r','a','n','g','e','.',
/* 0x1493d = "Process Verification Failure: An image has too many sections." */
    '\x1e','\x0d','\x12','A','n',' ','\x26','\x5e','\x9e','\xb4','s','e','c','t','i','o','n','s','.',
/* 0x14950 = "Memory allocation failed." */
    'M','e','m','o','r','y',' ','a','l','l','o','c','a','t','i','o','n',' ','\x7b',
/* 0x14963 = "Import ISO contains a bad volume descriptor header." */
    '\xc3','\xc1',' ','\x8a','a',' ','b','a','d',' ','\xd2','\xe3','h','e','a','d','e','r','.',
/* 0x14976 = "VERR_CFGM_NOT_ENOUGH_SPACE" */
    '\x01','C','F','G','M','_','\x06','E','N','O','U','G','H','_','S','P','A','C','E',
/* 0x14989 = "VINF_TCP_SERVER_NO_CLIENT" */
    '\x0e','T','C','P','_','S','E','R','V','E','R','_','\x60','C','L','I','E','N','T',
/* 0x1499c = "Central directory file header corrupt." */
    'C','e','n','t','r','a','l',' ','\x25','\x1f','\xb3','c','o','r','r','u','p','t','.',
/* 0x149af = "No valid TSS present." */
    '\xdf','v','a','l','i','d',' ','T','S','S',' ','p','r','e','s','e','n','t','.',
/* 0x149c2 = "The tracer is unloading." */
    '\x03','t','r','a','c','e','r',' ','\x0b','u','n','l','o','a','d','i','n','g','.',
/* 0x149d5 = "VERR_PDM_MISSING_INTERFACE_ABOVE" */
    '\x01','\x7d','\xc4','_','I','N','T','E','R','F','A','C','E','_','A','B','O','V','E',
/* 0x149e8 = "VERR_LDRPE_DELAY_IMPORT" */
    '\x01','L','D','R','P','E','_','D','E','L','A','Y','_','I','M','P','O','R','T',
/* 0x149fb = "VERR_CR_SPC_BAD_MONIKER_UUID" */
    '\x01','\x24','S','P','C','_','\x1d','M','O','N','I','K','E','R','_','U','U','I','D',
/* 0x14a0e = "VERR_XAR_MISSING_DATA_ELEMENT" */
    '\x01','X','A','R','_','\xc4','_','D','A','T','A','_','E','L','E','M','E','N','T',
/* 0x14a21 = "VERR_DBG_UNWIND_INFO_NOT_FOUND" */
    '\x01','D','B','G','_','U','N','W','I','N','D','_','I','N','F','O','_','\x06','\x2a',
/* 0x14a34 = "Path not verified yet." */
    'P','a','t','h',' ','\x08','v','e','r','i','f','i','e','d',' ','y','e','t','.',
/* 0x14a47 = "VERR_IOM_IOPORT_UNKNOWN_OPCODE" */
    '\x01','I','O','M','_','I','O','P','O','R','T','_','\x91','O','P','C','O','D','E',
/* 0x14a5a = "VINF_DBG_ADJUSTED_SYM_SIZE" */
    '\x0e','D','B','G','_','A','D','J','U','S','T','E','D','_','S','Y','M','_','\xf9',
/* 0x14a6d = "VERR_DBGC_PARSE_WRITEONLY_SYMBOL" */
    '\x01','\xfc','\xe4','W','R','I','T','E','O','N','L','Y','_','S','Y','M','B','O','L',
/* 0x14a80 = "VINF_VMX_MODIFIES_BEHAVIOR" */
    '\x0e','\xe2','M','O','D','I','F','I','E','S','_','B','E','H','A','V','I','O','R',
/* 0x14a93 = "Unknown SPC object moniker UUID." */
    '\xef','S','P','C',' ','\xa8','m','o','n','i','k','e','r',' ','U','U','I','D','.',
/* 0x14aa6 = "VERR_INTNET_FLT_IF_BUSY" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','I','F','_','B','U','S','Y',
/* 0x14ab9 = "Wrong JSON type for date value." */
    'W','r','o','n','g',' ','J','S','O','N',' ','\xf3','\x10','d','a','t','e',' ','\xe8',
/* 0x14acc = "VERR_HARDAVL_UNEXPECTED_NULL_LEFT" */
    '\x01','H','A','R','D','A','V','L','_','\x88','N','U','L','L','_','L','E','F','T',
/* 0x14adf = "The image is outside the expected range." */
    '\x03','\x26','\x0b','o','u','t','s','i','d','e',' ','\x02','\xc9','r','a','n','g','e','.',
/* 0x14af2 = "VERR_PDM_MODULE_NAME_TOO_LONG" */
    '\x01','\x7d','M','O','D','U','L','E','_','N','A','M','E','_','\x1a','L','O','N','G',
/* 0x14b05 = "VERR_IOMMU_CANNOT_CALL_SELF" */
    '\x01','\xfd','_','C','A','N','N','O','T','_','C','A','L','L','_','S','E','L','F',
/* 0x14b18 = "Saved state header integrity error." */
    'S','a','v','e','d',' ','\xca','\xb3','i','n','t','e','g','r','i','t','y',' ','\x85',
/* 0x14b2b = "VINF_CR_KEY_WAS_DECRYPTED" */
    '\x0e','\x24','K','E','Y','_','W','A','S','_','D','E','C','R','Y','P','T','E','D',
/* 0x14b3e = "VERR_LDRMACHO_NON_CONT_SEG_BITS" */
    '\x01','\xe9','N','O','N','_','C','O','N','T','_','S','E','G','_','B','I','T','S',
/* 0x14b51 = "VINF_UDP_SERVER_NO_CLIENT" */
    '\x0e','U','D','P','_','S','E','R','V','E','R','_','\x60','C','L','I','E','N','T',
/* 0x14b64 = "The service module was not found." */
    '\x03','s','e','r','v','i','c','e',' ','m','o','d','u','l','e',' ','\x11','\x08','\x89',
/* 0x14b77 = "VERR_PGM_MAP_MMIO2_ALIAS_MMIO" */
    '\x01','\x8c','M','A','P','_','M','M','I','O','2','_','A','L','I','A','S','_','\xd3',
/* 0x14b8a = "VERR_CR_PKCS7_BAD_MESSAGE_DIGEST_ATTRIB" */
    '\x01','\x24','\xe5','\x1d','M','E','S','S','A','G','E','_','\xbe','A','T','T','R','I','B',
/* 0x14b9d = "VERR_VD_DMG_NOT_FOUND_INSIDE_XAR" */
    '\x01','\xff','D','M','G','_','\x06','\x2a','_','I','N','S','I','D','E','_','X','A','R',
/* 0x14bb0 = "Wrong JSON type for bool value." */
    'W','r','o','n','g',' ','J','S','O','N',' ','\xf3','\x10','b','o','o','l',' ','\xe8',
/* 0x14bc3 = "VERR_APIC_INTR_NOT_PENDING" */
    '\x01','A','P','I','C','_','I','N','T','R','_','\x06','P','E','N','D','I','N','G',
/* 0x14bd6 = "VERR_PROC_IQ_PRIV_NOT_HELD" */
    '\x01','P','R','O','C','_','I','Q','_','P','R','I','V','_','\x06','H','E','L','D',
/* 0x14be9 = "VERR_HTTP_ACCESS_DENIED" */
    '\x01','H','T','T','P','_','A','C','C','E','S','S','_','D','E','N','I','E','D',
/* 0x14bfc = "VERR_HARDAVL_UNBALANCED" */
    '\x01','H','A','R','D','A','V','L','_','U','N','B','A','L','A','N','C','E','D',
/* 0x14c0f = "VERR_SUP_VP_FREE_VIRTUAL_MEMORY_FAILED" */
    '\x01','\x95','\xbd','F','R','E','E','_','V','I','R','T','U','A','L','_','\xb6','_','\x17',
/* 0x14c22 = "Bad PCI configuration." */
    '\x9f','P','C','I',' ','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x14c35 = "VERR_SUP_VP_BAD_IMAGE_SIGNATURE" */
    '\x01','\x95','\xbd','\x1d','I','M','A','G','E','_','S','I','G','N','A','T','U','R','E',
/* 0x14c48 = "VERR_CR_X509_CERT_SIGN_ALGO_MISMATCH" */
    '\x01','\x24','\xb7','C','E','R','T','_','S','I','G','N','_','A','L','G','O','_','\x19',
/* 0x14c5b = "Data size overflow." */
    'D','a','t','a',' ','s','i','z','e',' ','o','v','e','r','f','l','o','w','.',
/* 0x14c6e = "VINF_HGCM_ASYNC_EXECUTE" */
    '\x0e','H','G','C','M','_','A','S','Y','N','C','_','E','X','E','C','U','T','E',
/* 0x14c81 = "TM does not support the GIP version." */
    'T','M',' ','\xb2','\x08','\xce','\x02','G','I','P',' ','v','e','r','s','i','o','n','.',
/* 0x14c94 = "VERR_PDM_MISSING_INTERFACE_BELOW" */
    '\x01','\x7d','\xc4','_','I','N','T','E','R','F','A','C','E','_','B','E','L','O','W',
/* 0x14ca7 = "VERR_VD_CACHE_NOT_UP_TO_DATE" */
    '\x01','\xff','C','A','C','H','E','_','\x06','U','P','_','T','O','_','D','A','T','E',
/* 0x14cba = "VERR_PDM_DEVICE_NO_RT_ATTACH" */
    '\x01','\x7d','D','E','V','I','C','E','_','\x60','R','T','_','A','T','T','A','C','H',
/* 0x14ccd = "VERR_VD_READ_OUT_OF_RANGE" */
    '\x01','\xff','R','E','A','D','_','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x14ce0 = "VERR_RECORDING_CODEC_NOT_SUPPORTED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','C','O','D','E','C','_','\x06','\x82',
/* 0x14cf3 = "The handle is not pollable." */
    '\x03','h','a','n','d','l','e',' ','\x0b','\x08','p','o','l','l','a','b','l','e','.',
/* 0x14d06 = "VERR_TAR_EOS_MORE_INPUT" */
    '\x01','T','A','R','_','E','O','S','_','M','O','R','E','_','I','N','P','U','T',
/* 0x14d19 = "VERR_SEM_LV_WRONG_ORDER" */
    '\x01','S','E','M','_','L','V','_','W','R','O','N','G','_','O','R','D','E','R',
/* 0x14d2c = "VERR_CR_KEY_ALGO_PARAMS_MISSING" */
    '\x01','\x24','K','E','Y','_','A','L','G','O','_','P','A','R','A','M','S','_','\xc4',
/* 0x14d3f = "Page hash mismatch." */
    'P','a','g','e',' ','h','a','s','h',' ','m','i','s','m','a','t','c','h','.',
/* 0x14d52 = "Expected ECDSA private key." */
    '\xb8','E','C','D','S','A',' ','p','r','i','v','a','t','e',' ','k','e','y','.',
/* 0x14d65 = "VINF_PATM_PATCH_TRAP_PF" */
    '\x0e','P','A','T','M','_','P','A','T','C','H','_','T','R','A','P','_','P','F',
/* 0x14d78 = "VERR_CR_KEY_ALGO_PARAMS_MISMATCH" */
    '\x01','\x24','K','E','Y','_','A','L','G','O','_','P','A','R','A','M','S','_','\x19',
/* 0x14d8b = "VERR_PDM_MODULE_NAME_CLASH" */
    '\x01','\x7d','M','O','D','U','L','E','_','N','A','M','E','_','C','L','A','S','H',
/* 0x14d9e = "EVP_DecryptUpdate failed." */
    'E','V','P','_','D','e','c','r','y','p','t','U','p','d','a','t','e',' ','\x7b',
/* 0x14db1 = "Socket is not connected." */
    'S','o','c','k','e','t',' ','\x0b','\x08','c','o','n','n','e','c','t','e','d','.',
/* 0x14dc4 = "Something is missing." */
    'S','o','m','e','t','h','i','n','g',' ','\x0b','m','i','s','s','i','n','g','.',
/* 0x14dd7 = "VFS chain element expected at least two arguments." */
    '\x8d',' ','\xa1','\x5c','\xc9','a','t',' ','l','e','a','s','t',' ','t','w','o',' ','\xdd',
/* 0x14dea = "Is a symbolic link." */
    'I','s',' ','a',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k','.',
/* 0x14dfd = "VERR_CR_KEY_DECRYPTION_NOT_SUPPORTED" */
    '\x01','\x24','K','E','Y','_','D','E','C','R','Y','P','T','I','O','N','_','\x06','\x82',
/* 0x14e10 = "VERR_DWARF_LEB_OVERFLOW" */
    '\x01','D','W','A','R','F','_','L','E','B','_','O','V','E','R','F','L','O','W',
/* 0x14e23 = "VINF_VMX_INTERCEPT_NOT_ACTIVE" */
    '\x0e','\xe2','I','N','T','E','R','C','E','P','T','_','\x06','A','C','T','I','V','E',
/* 0x14e36 = "VERR_PGM_MAPPINGS_DISABLED" */
    '\x01','\x8c','M','A','P','P','I','N','G','S','_','D','I','S','A','B','L','E','D',
/* 0x14e49 = "No pending interrupt." */
    '\xdf','p','e','n','d','i','n','g',' ','i','n','t','e','r','r','u','p','t','.',
/* 0x14e5c = "Public key is too small." */
    'P','u','b','l','i','c',' ','k','e','y',' ','\x0b','\x9e','s','m','a','l','l','.',
/* 0x14e6f = "VERR_SUPLIB_PATH_TOO_MANY_COMPONENTS" */
    '\x01','\xd6','P','A','T','H','_','\x1a','\xac','C','O','M','P','O','N','E','N','T','S',
/* 0x14e82 = "Warning, the state changed." */
    'W','a','r','n','i','n','g',',',' ','\x02','\xca','c','h','a','n','g','e','d','.',
/* 0x14e95 = "VERR_SUP_VP_BAD_OPTIONAL_HEADER" */
    '\x01','\x95','\xbd','\x1d','O','P','T','I','O','N','A','L','_','H','E','A','D','E','R',
/* 0x14ea8 = "VERR_ACCOUNT_RESTRICTED" */
    '\x01','A','C','C','O','U','N','T','_','R','E','S','T','R','I','C','T','E','D',
/* 0x14ebb = "VERR_VRDP_ISO_UNSUPPORTED" */
    '\x01','V','R','D','P','_','\xc1','_','U','N','S','U','P','P','O','R','T','E','D',
/* 0x14ece = "VERR_VD_VDI_COMMENT_TOO_LONG" */
    '\x01','\xff','V','D','I','_','C','O','M','M','E','N','T','_','\x1a','L','O','N','G',
/* 0x14ee1 = "VERR_VMX_STARTVM_PRECOND_2" */
    '\x01','\xe2','S','T','A','R','T','V','M','_','P','R','E','C','O','N','D','_','2',
/* 0x14ef4 = "VERR_SUP_VP_TOO_HIGH_REGION_RVA" */
    '\x01','\x95','\xbd','\x1a','H','I','G','H','_','R','E','G','I','O','N','_','R','V','A',
/* 0x14f07 = "VERR_VMX_STARTVM_PRECOND_0" */
    '\x01','\xe2','S','T','A','R','T','V','M','_','P','R','E','C','O','N','D','_','0',
/* 0x14f1a = "Invalid value for cVirtualTicking." */
    '\x0c','\xf5','\x10','c','V','i','r','t','u','a','l','T','i','c','k','i','n','g','.',
/* 0x14f2d = "A path parameter was not set." */
    'A',' ','\xd0','p','a','r','a','m','e','t','e','r',' ','\x11','\x08','s','e','t','.',
/* 0x14f40 = "VERR_VMX_STARTVM_PRECOND_1" */
    '\x01','\xe2','S','T','A','R','T','V','M','_','P','R','E','C','O','N','D','_','1',
/* 0x14f53 = "VERR_CR_SPC_UNKNOWN_MONIKER_UUID" */
    '\x01','\x24','S','P','C','_','\x91','M','O','N','I','K','E','R','_','U','U','I','D',
/* 0x14f66 = "VERR_SUP_VP_IMAGE_HDR_READ_ERROR" */
    '\x01','\x95','\xbd','I','M','A','G','E','_','H','D','R','_','R','E','A','D','_','\x1b',
/* 0x14f79 = "VERR_APIC_WRITE_INVALID" */
    '\x01','A','P','I','C','_','W','R','I','T','E','_','I','N','V','A','L','I','D',
/* 0x14f8c = "Interface is unknown." */
    'I','n','t','e','r','f','a','c','e',' ','\x0b','u','n','k','n','o','w','n','.',
/* 0x14f9f = "VERR_SUP_VP_KERNEL32_ALREADY_MAPPED" */
    '\x01','\x95','\xbd','K','E','R','N','E','L','3','2','_','\x9b','M','A','P','P','E','D',
/* 0x14fb2 = "VERR_CR_SPC_IND_DATA_DIGEST_SIZE_MISMATCH" */
    '\x01','\x24','S','P','C','_','I','N','D','_','D','A','T','A','_','\xbe','\xf9','_','\x19',
/* 0x14fc5 = "VERR_VMX_STARTVM_PRECOND_3" */
    '\x01','\xe2','S','T','A','R','T','V','M','_','P','R','E','C','O','N','D','_','3',
/* 0x14fd8 = "VERR_HTTP_SSL_CONNECT_ERROR" */
    '\x01','H','T','T','P','_','S','S','L','_','C','O','N','N','E','C','T','_','\x1b',
/* 0x14feb = "VERR_ISOMK_IMPORT_VOLUME_SPACE_SIZE_MISMATCH" */
    '\x01','\x22','\x83','V','O','L','U','M','E','_','S','P','A','C','E','_','\xf9','_','\x19',
/* 0x14ffe = "Record header integrity error." */
    'R','e','c','o','r','d',' ','\xb3','i','n','t','e','g','r','i','t','y',' ','\x85',
/* 0x15011 = "VERR_VMX_MSR_SMX_VMX_ENABLE_FAILED" */
    '\x01','\xe2','M','S','R','_','S','M','X','_','\xe2','E','N','A','B','L','E','_','\x17',
/* 0x15024 = "VERR_VD_PARALLELS_INVALID_HEADER" */
    '\x01','\xff','P','A','R','A','L','L','E','L','S','_','\x05','H','E','A','D','E','R',
/* 0x15037 = "VERR_XAR_TOC_UNCOMP_SIZE_MISMATCH" */
    '\x01','X','A','R','_','T','O','C','_','U','N','C','O','M','P','_','\xf9','_','\x19',
/* 0x1504a = "VERR_PDM_DEVICE_NAME_CLASH" */
    '\x01','\x7d','D','E','V','I','C','E','_','N','A','M','E','_','C','L','A','S','H',
/* 0x1505d = "VINF_EM_PENDING_REQUEST" */
    '\x0e','E','M','_','P','E','N','D','I','N','G','_','R','E','Q','U','E','S','T',
/* 0x15070 = "VERR_DBGC_PARSE_UNBALANCED_QUOTE" */
    '\x01','\xfc','\xe4','U','N','B','A','L','A','N','C','E','D','_','Q','U','O','T','E',
/* 0x15083 = "Generic object destroyed status." */
    '\xa6','\xa8','d','e','s','t','r','o','y','e','d',' ','s','t','a','t','u','s','.',
/* 0x15096 = "VERR_RECORDING_CODEC_NOT_FOUND" */
    '\x01','R','E','C','O','R','D','I','N','G','_','C','O','D','E','C','_','\x06','\x2a',
/* 0x150a9 = "Failed to allocate memory for a URB." */
    '\x8b','\x0a','a','l','l','o','c','a','t','e',' ','\x86','\x10','a',' ','U','R','B','.',
/* 0x150bc = "VERR_ISOFS_FSD_ZERO_ROOT_DIR" */
    '\x01','\x97','F','S','D','_','Z','E','R','O','_','R','O','O','T','_','D','I','R',
/* 0x150cf = "VERR_FILESYSTEM_CORRUPT" */
    '\x01','F','I','L','E','S','Y','S','T','E','M','_','C','O','R','R','U','P','T',
/* 0x150e2 = "VERR_ASN1_DYNTYPE_TAG_NOT_IMPL" */
    '\x01','\xa2','D','Y','N','T','Y','P','E','_','T','A','G','_','\x06','I','M','P','L',
/* 0x150f5 = "VERR_VMX_MSR_ALL_VMX_DISABLED" */
    '\x01','\xe2','M','S','R','_','A','L','L','_','\xe2','D','I','S','A','B','L','E','D',
/* 0x15108 = "Vote for another pass." */
    'V','o','t','e',' ','\x10','a','n','o','t','h','e','r',' ','p','a','s','s','.',
/* 0x1511b = "VERR_PDM_INVALID_DEVICE_HOST_BITS" */
    '\x01','\x7d','\x05','D','E','V','I','C','E','_','H','O','S','T','_','B','I','T','S',
/* 0x1512e = "The specified MMIO range was invalid." */
    '\x03','\x18','\xd3',' ','r','a','n','g','e',' ','\x11','i','n','v','a','l','i','d','.',
/* 0x15141 = "Empty set inside X." */
    'E','m','p','t','y',' ','s','e','t',' ','i','n','s','i','d','e',' ','X','.',
/* 0x15154 = "OpenSSL d2i_PKCS7 failed." */
    'O','p','e','n','S','S','L',' ','d','2','i','_','P','K','C','S','7',' ','\x7b',
/* 0x15167 = "VERR_DIS_NO_READ_CALLBACK" */
    '\x01','D','I','S','_','\x60','R','E','A','D','_','C','A','L','L','B','A','C','K',
/* 0x1517a = "VINF_IOM_R3_IOPORT_READ" */
    '\x0e','I','O','M','_','R','3','_','I','O','P','O','R','T','_','R','E','A','D',
/* 0x1518d = "VERR_MANIFEST_ATTR_TYPE_NOT_FOUND" */
    '\x01','M','A','N','I','F','E','S','T','_','A','T','T','R','_','\xb5','_','\x06','\x2a',
/* 0x151a0 = "VERR_VFS_CHAIN_AT_MOST_ONE_ARG" */
    '\x01','\x8d','_','\x8e','A','T','_','M','O','S','T','_','O','N','E','_','A','R','G',
/* 0x151b3 = "VWRN_CSAM_TRAP_NOT_HANDLED" */
    '\xe6','C','S','A','M','_','T','R','A','P','_','\x06','H','A','N','D','L','E','D',
/* 0x151c6 = "VFS chain element expected at most four arguments." */
    '\x8d',' ','\xa1','\x5c','\xc9','a','t',' ','m','o','s','t',' ','f','o','u','r',' ','\xdd',
/* 0x151d9 = "VERR_VMX_UNABLE_TO_START_VM" */
    '\x01','\xe2','U','N','A','B','L','E','_','T','O','_','S','T','A','R','T','_','\xcd',
/* 0x151ec = "VERR_VM_REQUEST_INVALID_PACKAGE" */
    '\x01','\xcd','_','R','E','Q','U','E','S','T','_','\x05','P','A','C','K','A','G','E',
/* 0x151ff = "VERR_CR_X509_VALIDITY_SWAPPED" */
    '\x01','\x24','\xb7','V','A','L','I','D','I','T','Y','_','S','W','A','P','P','E','D',
/* 0x15212 = "EVP_EncryptUpdate failed." */
    'E','V','P','_','E','n','c','r','y','p','t','U','p','d','a','t','e',' ','\x7b',
/* 0x15225 = "VERR_HM_UNKNOWN_IO_INSTRUCTION" */
    '\x01','H','M','_','\x91','I','O','_','I','N','S','T','R','U','C','T','I','O','N',
/* 0x15238 = "VERR_BIGNUM_DIV_BY_ZERO" */
    '\x01','B','I','G','N','U','M','_','D','I','V','_','B','Y','_','Z','E','R','O',
/* 0x1524b = "VERR_GMM_MODULE_VERSION_TOO_LONG" */
    '\x01','G','M','M','_','M','O','D','U','L','E','_','\xbc','_','\x1a','L','O','N','G',
/* 0x1525e = "VERR_CPUM_UNSUPPORTED_ID_REG_VALUE" */
    '\x01','C','P','U','M','_','\x1c','I','D','_','R','E','G','_','V','A','L','U','E',
/* 0x15271 = "VERR_VD_RAW_SIZE_MODULO_2048" */
    '\x01','\xff','R','A','W','_','\xf9','_','M','O','D','U','L','O','_','2','0','4','8',
/* 0x15284 = "VERR_GVM_MISMATCH_VM_STRUCT_VER" */
    '\x01','G','V','M','_','\x19','_','\xcd','_','S','T','R','U','C','T','_','V','E','R',
/* 0x15297 = "VT-x/AMD-V not active." */
    'V','T','-','x','/','A','M','D','-','V',' ','\x08','a','c','t','i','v','e','.',
/* 0x152aa = "VERR_PDM_INVALID_USB_REGISTRATION" */
    '\x01','\x7d','\x05','U','S','B','_','R','E','G','I','S','T','R','A','T','I','O','N',
/* 0x152bd = "VERR_ISOFS_UNKNOWN_PART_MAP_ENTRY_TYPE" */
    '\x01','\x97','\x91','P','A','R','T','_','M','A','P','_','E','N','T','R','Y','_','\xb5',
/* 0x152d0 = "Socket is already connected." */
    'S','o','c','k','e','t',' ','\x0b','\x7f','c','o','n','n','e','c','t','e','d','.',
/* 0x152e3 = "VERR_VRDP_ACCESS_DENIED" */
    '\x01','V','R','D','P','_','A','C','C','E','S','S','_','D','E','N','I','E','D',
/* 0x152f6 = "VERR_PDM_CFG_MISSING_DRIVER_NAME" */
    '\x01','\x7d','C','F','G','_','\xc4','_','D','R','I','V','E','R','_','N','A','M','E',
/* 0x15309 = "VERR_CR_SPC_MONIKER_BAD_DATA" */
    '\x01','\x24','S','P','C','_','M','O','N','I','K','E','R','_','\x1d','D','A','T','A',
/* 0x1531c = "Unsupported firmware property." */
    '\x98','f','i','r','m','w','a','r','e',' ','p','r','o','p','e','r','t','y','.',
/* 0x1532f = "Unknown SPC PE image attribute." */
    '\xef','S','P','C',' ','P','E',' ','\x26','a','t','t','r','i','b','u','t','e','.',
/* 0x15342 = "VFS chain element expected at least six arguments." */
    '\x8d',' ','\xa1','\x5c','\xc9','a','t',' ','l','e','a','s','t',' ','s','i','x',' ','\xdd',
/* 0x15355 = "VFS chain element expected at most five arguments." */
    '\x8d',' ','\xa1','\x5c','\xc9','a','t',' ','m','o','s','t',' ','f','i','v','e',' ','\xdd',
/* 0x15368 = "Connection refused." */
    'C','o','n','n','e','c','t','i','o','n',' ','r','e','f','u','s','e','d','.',
/* 0x1537b = "VERR_IOM_INVALID_IOPORT_HANDLE" */
    '\x01','I','O','M','_','\x05','I','O','P','O','R','T','_','H','A','N','D','L','E',
/* 0x1538e = "VERR_IOM_NOT_MMIO_RANGE_OWNER" */
    '\x01','I','O','M','_','\x06','\xd3','_','R','A','N','G','E','_','O','W','N','E','R',
/* 0x153a1 = "Syntax error - a type conversion failed." */
    '\xfa','\x09','-',' ','a',' ','\xf3','c','o','n','v','e','r','s','i','o','n',' ','\x7b',
/* 0x153b4 = "VERR_DBG_CFG_NOT_UINT_PROP" */
    '\x01','D','B','G','_','C','F','G','_','\x06','U','I','N','T','_','P','R','O','P',
/* 0x153c7 = "IOCtl to VBoxGuest driver failed." */
    'I','O','C','t','l',' ','\x0a','V','B','o','x','G','u','e','s','t',' ','\xc5','\x7b',
/* 0x153da = "Failed to stat a file/dir (hardening)." */
    '\x8b','\x0a','s','t','a','t',' ','a',' ','f','i','l','e','/','d','i','r',' ','\xae',
/* 0x153ed = "VERR_IPC_SEND_CANCELLED" */
    '\x01','I','P','C','_','S','E','N','D','_','C','A','N','C','E','L','L','E','D',
/* 0x15400 = "validation of the LX object table failed." */
    'v','a','l','i','d','a','t','i','o','n',' ','\x15','\x02','L','X',' ','\xa8','\xb1','\x7b',
/* 0x15413 = "Pagetable not present." */
    'P','a','g','e','t','a','b','l','e',' ','\x08','p','r','e','s','e','n','t','.',
/* 0x15426 = "VERR_CFGM_CONFIG_UNKNOWN_VALUE" */
    '\x01','C','F','G','M','_','C','O','N','F','I','G','_','\x91','V','A','L','U','E',
/* 0x15439 = "VERR_PDM_DRIVER_NO_RT_ATTACH" */
    '\x01','\x7d','D','R','I','V','E','R','_','\x60','R','T','_','A','T','T','A','C','H',
/* 0x1544c = "VERR_GIM_PVTSC_NOT_ENABLED" */
    '\x01','G','I','M','_','P','V','T','S','C','_','\x06','E','N','A','B','L','E','D',
/* 0x1545f = "The value is not a byte string." */
    '\x03','\xf5','\x0b','\x08','a',' ','b','y','t','e',' ','s','t','r','i','n','g','.',
/* 0x15471 = "VERR_IOM_INVALID_IOPORT_RANGE" */
    '\x01','I','O','M','_','\x05','I','O','P','O','R','T','_','R','A','N','G','E',
/* 0x15483 = "VERR_PGM_NO_CR3_SHADOW_ROOT" */
    '\x01','\x8c','\x60','C','R','3','_','S','H','A','D','O','W','_','R','O','O','T',
/* 0x15495 = "VERR_SEM_LV_INVALID_PARAMETER" */
    '\x01','S','E','M','_','L','V','_','\x05','P','A','R','A','M','E','T','E','R',
/* 0x154a7 = "VERR_PDM_DRIVER_ALREADY_ATTACHED" */
    '\x01','\x7d','D','R','I','V','E','R','_','\x9b','A','T','T','A','C','H','E','D',
/* 0x154b9 = "EVP_DecryptFinal failed." */
    'E','V','P','_','D','e','c','r','y','p','t','F','i','n','a','l',' ','\x7b',
/* 0x154cb = "VERR_ASN1_TELETEX_UNKNOWN_ESC_SEQ" */
    '\x01','\xa2','T','E','L','E','T','E','X','_','\x91','E','S','C','_','S','E','Q',
/* 0x154dd = "VERR_ISOFS_UNSUPPORTED_LOGICAL_BLOCK_SIZE" */
    '\x01','\x97','\x1c','L','O','G','I','C','A','L','_','B','L','O','C','K','_','\xf9',
/* 0x154ef = "VERR_SSM_LIVE_POWERED_OFF" */
    '\x01','\xb0','L','I','V','E','_','P','O','W','E','R','E','D','_','O','F','F',
/* 0x15501 = "VERR_IEM_EMIT_BAD_SEG_REG_NO" */
    '\x01','\x9c','E','M','I','T','_','\x1d','S','E','G','_','R','E','G','_','N','O',
/* 0x15513 = "VERR_SUP_VP_TOO_MANY_IMAGE_REGIONS" */
    '\x01','\x95','\xbd','\x1a','\xac','I','M','A','G','E','_','R','E','G','I','O','N','S',
/* 0x15525 = "VERR_ASN1_TELETEX_UNSUPPORTED_CHARSET" */
    '\x01','\xa2','T','E','L','E','T','E','X','_','\x1c','C','H','A','R','S','E','T',
/* 0x15537 = "VERR_GMM_CHUNK_NOT_MAPPED" */
    '\x01','G','M','M','_','C','H','U','N','K','_','\x06','M','A','P','P','E','D',
/* 0x15549 = "VINF_SYS_MAY_POWER_OFF" */
    '\x0e','S','Y','S','_','M','A','Y','_','P','O','W','E','R','_','O','F','F',
/* 0x1555b = "Symbol (export) not found." */
    'S','y','m','b','o','l',' ','(','e','x','p','o','r','t',')',' ','\x08','\x89',
/* 0x1556d = "VERR_SUPDRV_APIPORT_OPEN_ERROR_TYPE" */
    '\x01','\x90','A','P','I','P','O','R','T','_','O','P','E','N','_','\x1b','_','\xb5',
/* 0x1557f = "VERR_PDM_TRANSLATION_NOT_SET" */
    '\x01','\x7d','T','R','A','N','S','L','A','T','I','O','N','_','\x06','S','E','T',
/* 0x15591 = "VERR_GMM_CHUNK_ALREADY_MAPPED" */
    '\x01','G','M','M','_','C','H','U','N','K','_','\x9b','M','A','P','P','E','D',
/* 0x155a3 = "Permission denied." */
    'P','e','r','m','i','s','s','i','o','n',' ','d','e','n','i','e','d','.',
/* 0x155b5 = "Expected a different string tag." */
    '\xb8','a',' ','d','i','f','f','e','r','e','n','t',' ','\xf2','t','a','g','.',
/* 0x155c7 = "VERR_FDT_DTB_MALFORMED" */
    '\x01','F','D','T','_','D','T','B','_','M','A','L','F','O','R','M','E','D',
/* 0x155d9 = "Footer integrity error." */
    'F','o','o','t','e','r',' ','i','n','t','e','g','r','i','t','y',' ','\x85',
/* 0x155eb = "VINF_IEM_YIELD_PENDING_FF" */
    '\x0e','\x9c','Y','I','E','L','D','_','P','E','N','D','I','N','G','_','F','F',
/* 0x155fd = "VERR_PDM_CRITSECT_ABORT_FAILED" */
    '\x01','\x7d','C','R','I','T','S','E','C','T','_','A','B','O','R','T','_','\x17',
/* 0x1560f = "Logic bug in the DBGC code." */
    'L','o','g','i','c',' ','b','u','g',' ','\x0f','\x02','D','B','G','C',' ','\x84',
/* 0x15621 = "VERR_WRONG_PARAMETER_TYPE" */
    '\x01','W','R','O','N','G','_','P','A','R','A','M','E','T','E','R','_','\xb5',
/* 0x15633 = "Expected valid data pointer for ASN." */
    '\xb8','v','a','l','i','d',' ','\x9d','p','o','i','n','t','e','r',' ','\x10','\xf6',
/* 0x15645 = "The value was truncated to fit." */
    '\x03','\xf5','\x11','t','r','u','n','c','a','t','e','d',' ','\x0a','f','i','t','.',
/* 0x15657 = "VERR_VD_NOT_ENOUGH_METADATA" */
    '\x01','\xff','\x06','E','N','O','U','G','H','_','M','E','T','A','D','A','T','A',
/* 0x15669 = "VERR_ISOFS_TAG_IS_ALL_ZEROS" */
    '\x01','\x97','T','A','G','_','I','S','_','A','L','L','_','Z','E','R','O','S',
/* 0x1567b = "VERR_SEM_LV_NOT_SIGNALLER" */
    '\x01','S','E','M','_','L','V','_','\x06','S','I','G','N','A','L','L','E','R',
/* 0x1568d = "VINF_EM_DBG_BREAKPOINT" */
    '\x0e','E','M','_','D','B','G','_','B','R','E','A','K','P','O','I','N','T',
/* 0x1569f = "VINF_CPUM_R3_MSR_WRITE" */
    '\x0e','C','P','U','M','_','R','3','_','M','S','R','_','W','R','I','T','E',
/* 0x156b1 = "VERR_IEM_VAR_NOT_INITIALIZED" */
    '\x01','\x9c','V','A','R','_','\x06','I','N','I','T','I','A','L','I','Z','E','D',
/* 0x156c3 = "File/Device open failed." */
    'F','i','l','e','/','D','e','v','i','c','e',' ','o','p','e','n',' ','\x7b',
/* 0x156d5 = "Import ISO contains a bad directory record." */
    '\xc3','\xc1',' ','\x8a','a',' ','b','a','d',' ','\x25','r','e','c','o','r','d','.',
/* 0x156e7 = "The page to be freed was already freed." */
    '\x03','\xcc','\x0a','\xa7','f','r','e','e','d',' ','\x11','\x7f','f','r','e','e','d','.',
/* 0x156f9 = "VERR_ISOMK_IMPORT_VOLUME_IN_SET_MISMATCH" */
    '\x01','\x22','\x83','V','O','L','U','M','E','_','I','N','_','S','E','T','_','\x19',
/* 0x1570b = "VERR_LDRLX_NRICHAIN_NOT_SUPPORTED" */
    '\x01','L','D','R','L','X','_','N','R','I','C','H','A','I','N','_','\x06','\x82',
/* 0x1571d = "MMIO region is already mapped." */
    '\xd3',' ','r','e','g','i','o','n',' ','\x0b','\x7f','m','a','p','p','e','d','.',
/* 0x1572f = "VINF_VD_NEW_ZEROED_BLOCK" */
    '\x0e','\xff','N','E','W','_','Z','E','R','O','E','D','_','B','L','O','C','K',
/* 0x15741 = "Switch back to host." */
    'S','w','i','t','c','h',' ','b','a','c','k',' ','\x0a','h','o','s','t','.',
/* 0x15753 = "VERR_NEGATIVE_UNSIGNED" */
    '\x01','N','E','G','A','T','I','V','E','_','U','N','S','I','G','N','E','D',
/* 0x15765 = "Reducing the size is not supported." */
    'R','e','d','u','c','i','n','g',' ','\x02','s','i','z','e',' ','\x0b','\x08','\xa4',
/* 0x15777 = "VERR_NEM_SET_REGISTERS_FAILED" */
    '\x01','\xee','_','S','E','T','_','R','E','G','I','S','T','E','R','S','_','\x17',
/* 0x15789 = "VERR_ASN1_TELETEX_UNSUPPORTED_ESC_SEQ" */
    '\x01','\xa2','T','E','L','E','T','E','X','_','\x1c','E','S','C','_','S','E','Q',
/* 0x1579b = "VERR_IOM_IOPORT_UNUSED" */
    '\x01','I','O','M','_','I','O','P','O','R','T','_','U','N','U','S','E','D',
/* 0x157ad = "Is a block device." */
    'I','s',' ','a',' ','b','l','o','c','k',' ','d','e','v','i','c','e','.',
/* 0x157bf = "Unsupported hashing function." */
    '\x98','h','a','s','h','i','n','g',' ','f','u','n','c','t','i','o','n','.',
/* 0x157d1 = "VERR_ISOMK_RR_NO_SPACE_FOR_CE" */
    '\x01','\x22','R','R','_','\x60','S','P','A','C','E','_','F','O','R','_','C','E',
/* 0x157e3 = "VERR_IS_A_BLOCK_DEVICE" */
    '\x01','I','S','_','A','_','B','L','O','C','K','_','D','E','V','I','C','E',
/* 0x157f5 = "Expected ECDSA public key." */
    '\xb8','E','C','D','S','A',' ','p','u','b','l','i','c',' ','k','e','y','.',
/* 0x15807 = "VERR_VFS_CHAIN_TAKES_DIR_OR_VFS" */
    '\x01','\x8d','_','\x8e','T','A','K','E','S','_','D','I','R','_','O','R','_','\x8d',
/* 0x15819 = "The specified path has too many components (hardening)." */
    '\x03','\x18','\xd0','\x5e','\x9e','\xb4','c','o','m','p','o','n','e','n','t','s',' ','\xae',
/* 0x1582b = "Syntax error - Invalid command name." */
    '\xfa','\x09','-',' ','\x0c','c','o','m','m','a','n','d',' ','n','a','m','e','.',
/* 0x1583d = "VINF_PERMISSION_DENIED" */
    '\x0e','P','E','R','M','I','S','S','I','O','N','_','D','E','N','I','E','D',
/* 0x1584f = "MMIO region is not mapped." */
    '\xd3',' ','r','e','g','i','o','n',' ','\x0b','\x08','m','a','p','p','e','d','.',
/* 0x15861 = "Certificate path validator: No valid certificate policy." */
    '\xba','\xd0','\xfe','\xdf','v','a','l','i','d',' ','\xa0','p','o','l','i','c','y','.',
/* 0x15873 = "VERR_ASN1_TIME_NORMALIZE_ERROR" */
    '\x01','\xa2','T','I','M','E','_','N','O','R','M','A','L','I','Z','E','_','\x1b',
/* 0x15885 = "VERR_CONCURRENT_ACCESS" */
    '\x01','C','O','N','C','U','R','R','E','N','T','_','A','C','C','E','S','S',
/* 0x15897 = "NEM failed to get registers." */
    '\xee',' ','\x99','\x0a','g','e','t',' ','r','e','g','i','s','t','e','r','s','.',
/* 0x158a9 = "Seek below file start." */
    'S','e','e','k',' ','b','e','l','o','w',' ','\x1f','s','t','a','r','t','.',
/* 0x158bb = "VERR_ASN1_TIME_NORMALIZE_MISMATCH" */
    '\x01','\xa2','T','I','M','E','_','N','O','R','M','A','L','I','Z','E','_','\x19',
/* 0x158cd = "VERR_CR_X509_UNKNOWN_CERT_SIGN_ALGO" */
    '\x01','\x24','\xb7','\x91','C','E','R','T','_','S','I','G','N','_','A','L','G','O',
/* 0x158df = "VERR_S3_BUCKET_ALREADY_EXISTS" */
    '\x01','S','3','_','B','U','C','K','E','T','_','\x9b','E','X','I','S','T','S',
/* 0x158f1 = "VWRN_NEGATIVE_UNSIGNED" */
    '\xe6','N','E','G','A','T','I','V','E','_','U','N','S','I','G','N','E','D',
/* 0x15903 = "Unexpected unstable VM state." */
    '\x94','u','n','s','t','a','b','l','e',' ','\xcd',' ','s','t','a','t','e','.',
/* 0x15915 = "VERR_SSM_FIELD_INVALID_PADDING_SIZE" */
    '\x01','\xb0','F','I','E','L','D','_','\x05','P','A','D','D','I','N','G','_','\xf9',
/* 0x15927 = "VWRN_CONTINUE_ANALYSIS" */
    '\xe6','C','O','N','T','I','N','U','E','_','A','N','A','L','Y','S','I','S',
/* 0x15939 = "VERR_SUPDRV_TRACER_UNLOADING" */
    '\x01','\x90','T','R','A','C','E','R','_','U','N','L','O','A','D','I','N','G',
/* 0x1594b = "VERR_PDM_NO_ATTACHED_DRIVER" */
    '\x01','\x7d','\x60','A','T','T','A','C','H','E','D','_','D','R','I','V','E','R',
/* 0x1595d = "Recompiler: Out of stack slots." */
    '\x13','O','u','t',' ','\x15','s','t','a','c','k',' ','s','l','o','t','s','.',
/* 0x1596f = "VERR_TAR_BAD_CHKSUM_FIELD" */
    '\x01','T','A','R','_','\x1d','C','H','K','S','U','M','_','F','I','E','L','D',
/* 0x15981 = "Too many MMIO2 ranges." */
    'T','o','o',' ','\xb4','M','M','I','O','2',' ','r','a','n','g','e','s','.',
/* 0x15993 = "VERR_IEM_INSTR_BUF_TOO_LARGE" */
    '\x01','\x9c','I','N','S','T','R','_','B','U','F','_','\x1a','L','A','R','G','E',
/* 0x159a5 = "Client has been rejected." */
    'C','l','i','e','n','t',' ','\x5e','\xcb','r','e','j','e','c','t','e','d','.',
/* 0x159b7 = "Deadlock detected." */
    'D','e','a','d','l','o','c','k',' ','d','e','t','e','c','t','e','d','.',
/* 0x159c9 = "VERR_DWARF_UNKNOWN_LOC_OPCODE" */
    '\x01','D','W','A','R','F','_','\x91','L','O','C','_','O','P','C','O','D','E',
/* 0x159db = "VERR_DBGC_PARSE_INCORRECT_ARG_TYPE" */
    '\x01','\xfc','\xe4','I','N','C','O','R','R','E','C','T','_','A','R','G','_','\xb5',
/* 0x159ed = "VERR_CALLER_NO_REFERENCE" */
    '\x01','C','A','L','L','E','R','_','\x60','R','E','F','E','R','E','N','C','E',
/* 0x159ff = "VERR_LDRVI_READ_ERROR_SIGNATURE" */
    '\x01','\xf4','R','E','A','D','_','\x1b','_','S','I','G','N','A','T','U','R','E',
/* 0x15a11 = "Process Verification Failure: Bad virtual section size." */
    '\x1e','\x0d','\x12','\x9f','v','i','r','t','u','a','l',' ','\xdb','s','i','z','e','.',
/* 0x15a23 = "Key decryption is not supported." */
    'K','e','y',' ','d','e','c','r','y','p','t','i','o','n',' ','\x0b','\x08','\xa4',
/* 0x15a35 = "Unexpected filesystem object type." */
    '\x94','f','i','l','e','s','y','s','t','e','m',' ','\xa8','t','y','p','e','.',
/* 0x15a47 = "VERR_NEM_GET_REGISTERS_FAILED" */
    '\x01','\xee','_','G','E','T','_','R','E','G','I','S','T','E','R','S','_','\x17',
/* 0x15a59 = "Data connection not found." */
    'D','a','t','a',' ','c','o','n','n','e','c','t','i','o','n',' ','\x08','\x89',
/* 0x15a6b = "VERR_SYMBOL_VALUE_TOO_BIG" */
    '\x01','S','Y','M','B','O','L','_','V','A','L','U','E','_','\x1a','B','I','G',
/* 0x15a7d = "Internal processing error #2 in the I/O port code." */
    '\x07','\x04','\x09','#','2',' ','\x0f','\x02','I','/','O',' ','p','o','r','t',' ','\x84',
/* 0x15a8f = "VFS chain element expected at most two arguments." */
    '\x8d',' ','\xa1','\x5c','\xc9','a','t',' ','m','o','s','t',' ','t','w','o',' ','\xdd',
/* 0x15aa1 = "VERR_JSON_ITERATOR_END" */
    '\x01','J','S','O','N','_','I','T','E','R','A','T','O','R','_','E','N','D',
/* 0x15ab3 = "VERR_MAX_PROCS_REACHED" */
    '\x01','M','A','X','_','P','R','O','C','S','_','R','E','A','C','H','E','D',
/* 0x15ac5 = "VERR_VSCSI_LUN_INVALID" */
    '\x01','V','S','C','S','I','_','L','U','N','_','I','N','V','A','L','I','D',
/* 0x15ad7 = "VERR_SSM_VIRTUAL_CLOCK_HZ" */
    '\x01','\xb0','V','I','R','T','U','A','L','_','C','L','O','C','K','_','H','Z',
/* 0x15ae9 = "Deprecated digest." */
    'D','e','p','r','e','c','a','t','e','d',' ','d','i','g','e','s','t','.',
/* 0x15afb = "VERR_PATH_IS_NOT_RELATIVE" */
    '\x01','P','A','T','H','_','I','S','_','\x06','R','E','L','A','T','I','V','E',
/* 0x15b0d = "VERR_ASN1_STRING_TYPE_NOT_IMPLEMENTED" */
    '\x01','\xa2','\xd5','_','\xb5','_','\x06','I','M','P','L','E','M','E','N','T','E','D',
/* 0x15b1f = "VERR_LDRVI_BAD_CERT_HDR_LENGTH" */
    '\x01','\xf4','\x1d','C','E','R','T','_','H','D','R','_','L','E','N','G','T','H',
/* 0x15b31 = "VERR_MAX_THRDS_REACHED" */
    '\x01','M','A','X','_','T','H','R','D','S','_','R','E','A','C','H','E','D',
/* 0x15b43 = "VERR_CFGM_CONFIG_UNKNOWN_NODE" */
    '\x01','C','F','G','M','_','C','O','N','F','I','G','_','\x91','N','O','D','E',
/* 0x15b55 = "VERR_FDT_AT_ROOT_LEVEL" */
    '\x01','F','D','T','_','A','T','_','R','O','O','T','_','L','E','V','E','L',
/* 0x15b67 = "VERR_ISOFS_ICB_ENTRY_TOO_SMALL" */
    '\x01','\x97','I','C','B','_','E','N','T','R','Y','_','\x1a','S','M','A','L','L',
/* 0x15b79 = "Too many CPUID leaves." */
    'T','o','o',' ','\xb4','C','P','U','I','D',' ','l','e','a','v','e','s','.',
/* 0x15b8b = "VERR_VMM_SWITCHER_STUB" */
    '\x01','V','M','M','_','S','W','I','T','C','H','E','R','_','S','T','U','B',
/* 0x15b9d = "VERR_VBGL_NOT_INITIALIZED" */
    '\x01','V','B','G','L','_','\x06','I','N','I','T','I','A','L','I','Z','E','D',
/* 0x15baf = "VERR_PGM_MAPPING_CONFLICT" */
    '\x01','\x8c','M','A','P','P','I','N','G','_','C','O','N','F','L','I','C','T',
/* 0x15bc1 = "VERR_SUP_VP_EXE_MISSING_NX_COMPAT" */
    '\x01','\x95','\xbd','E','X','E','_','\xc4','_','N','X','_','C','O','M','P','A','T',
/* 0x15bd3 = "EVP_EncryptFinal failed." */
    'E','V','P','_','E','n','c','r','y','p','t','F','i','n','a','l',' ','\x7b',
/* 0x15be5 = "VERR_EM_GUEST_CPU_HANG" */
    '\x01','E','M','_','G','U','E','S','T','_','C','P','U','_','H','A','N','G',
/* 0x15bf7 = "VERR_COM_OBJECT_IN_USE" */
    '\x01','C','O','M','_','O','B','J','E','C','T','_','I','N','_','U','S','E',
/* 0x15c09 = "OpenSSL d2i_X509 failed." */
    'O','p','e','n','S','S','L',' ','d','2','i','_','X','5','0','9',' ','\x7b',
/* 0x15c1b = "The shared module was not found." */
    '\x03','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','\x11','\x08','\x89',
/* 0x15c2d = "Driver name clash." */
    'D','r','i','v','e','r',' ','n','a','m','e',' ','c','l','a','s','h','.',
/* 0x15c3f = "Not code selector." */
    'N','o','t',' ','c','o','d','e',' ','s','e','l','e','c','t','o','r','.',
/* 0x15c51 = "Recompiler: Debug info internal processing error #2." */
    '\x13','D','e','b','u','g',' ','i','n','f','o',' ','\x16','\x04','\x09','#','2','.',
/* 0x15c63 = "VERR_VFS_CHAIN_WRITE_ONLY_IOS" */
    '\x01','\x8d','_','\x8e','W','R','I','T','E','_','O','N','L','Y','_','I','O','S',
/* 0x15c75 = "VFS chain element expected at most six arguments." */
    '\x8d',' ','\xa1','\x5c','\xc9','a','t',' ','m','o','s','t',' ','s','i','x',' ','\xdd',
/* 0x15c87 = "Device name clash." */
    'D','e','v','i','c','e',' ','n','a','m','e',' ','c','l','a','s','h','.',
/* 0x15c99 = "Selector not present." */
    'S','e','l','e','c','t','o','r',' ','\x08','p','r','e','s','e','n','t','.',
/* 0x15cab = "OpenSSL PKCS #7 verification failed." */
    'O','p','e','n','S','S','L',' ','P','K','C','S',' ','#','7',' ','\xf8','\x7b',
/* 0x15cbd = "Process Verification Failure: An image has too many regions." */
    '\x1e','\x0d','\x12','A','n',' ','\x26','\x5e','\x9e','\xb4','r','e','g','i','o','n','s','.',
/* 0x15ccf = "VERR_DBG_NO_LINE_NUMBERS" */
    '\x01','D','B','G','_','\x60','L','I','N','E','_','N','U','M','B','E','R','S',
/* 0x15ce1 = "VERR_MANIFEST_ATTR_TYPE_MISMATCH" */
    '\x01','M','A','N','I','F','E','S','T','_','A','T','T','R','_','\xb5','_','\x19',
/* 0x15cf3 = "VERR_SUP_VP_NOT_BUILD_CERT_IPE" */
    '\x01','\x95','\xbd','\x06','B','U','I','L','D','_','C','E','R','T','_','I','P','E',
/* 0x15d05 = "The I/O request is in an invalid state for this operation." */
    '\x03','I','/','O',' ','\xaa','\x0b','\x0f','\x87','\x8f','\xca','\x10','t','h','i','s',' ','\xea',
/* 0x15d17 = "Internal processing error #1 in the I/O port code." */
    '\x07','\x04','\x09','#','1',' ','\x0f','\x02','I','/','O',' ','p','o','r','t',' ','\x84',
/* 0x15d29 = "VERR_SUP_VP_SECTION_NOT_MAPPED" */
    '\x01','\x95','\xbd','S','E','C','T','I','O','N','_','\x06','M','A','P','P','E','D',
/* 0x15d3b = "NEM failed to set registers." */
    '\xee',' ','\x99','\x0a','s','e','t',' ','r','e','g','i','s','t','e','r','s','.',
/* 0x15d4d = "VERR_ISOFS_INVALID_PARTITION_INDEX" */
    '\x01','\x97','\x05','P','A','R','T','I','T','I','O','N','_','I','N','D','E','X',
/* 0x15d5f = "Receive cancelled." */
    'R','e','c','e','i','v','e',' ','c','a','n','c','e','l','l','e','d','.',
/* 0x15d71 = "VERR_ISOFS_UDF_NOT_IMPLEMENTED" */
    '\x01','\x97','U','D','F','_','\x06','I','M','P','L','E','M','E','N','T','E','D',
/* 0x15d83 = "VINF_PGM_HANDLER_ALREADY_ALIASED" */
    '\x0e','\x8c','H','A','N','D','L','E','R','_','\x9b','A','L','I','A','S','E','D',
/* 0x15d95 = "VERR_PDM_MEDIAEX_IOREQ_INVALID_STATE" */
    '\x01','\x7d','M','E','D','I','A','E','X','_','I','O','R','E','Q','_','\x05','\xf1',
/* 0x15da7 = "Recompiler: Debug info internal processing error #1." */
    '\x13','D','e','b','u','g',' ','i','n','f','o',' ','\x16','\x04','\x09','#','1','.',
/* 0x15db9 = "VERR_HM_WRONG_SWITCHER" */
    '\x01','H','M','_','W','R','O','N','G','_','S','W','I','T','C','H','E','R',
/* 0x15dcb = "VERR_ISOMK_IMPORT_BAD_DIR_REC_LENGTH" */
    '\x01','\x22','\x83','\x1d','D','I','R','_','R','E','C','_','L','E','N','G','T','H',
/* 0x15ddd = "VERR_MEDIA_NOT_RECOGNIZED" */
    '\x01','M','E','D','I','A','_','\x06','R','E','C','O','G','N','I','Z','E','D',
/* 0x15def = "VERR_IOM_FF_STATUS_IPE" */
    '\x01','I','O','M','_','F','F','_','S','T','A','T','U','S','_','I','P','E',
/* 0x15e01 = "VERR_VD_RAW_SIZE_MODULO_512" */
    '\x01','\xff','R','A','W','_','\xf9','_','M','O','D','U','L','O','_','5','1','2',
/* 0x15e13 = "VERR_ASN1_CURSOR_BAD_LENGTH_ENCODING" */
    '\x01','\xa2','C','U','R','S','O','R','_','\x1d','L','E','N','G','T','H','_','\xc6',
/* 0x15e25 = "Protocol family not supported." */
    'P','r','o','t','o','c','o','l',' ','f','a','m','i','l','y',' ','\x08','\xa4',
/* 0x15e37 = "VERR_HGCM_INVALID_CMD_ADDRESS" */
    '\x01','H','G','C','M','_','\x05','C','M','D','_','A','D','D','R','E','S','S',
/* 0x15e49 = "Internal processing error #1 in the switcher code." */
    '\x07','\x04','\x09','#','1',' ','\x0f','\x02','s','w','i','t','c','h','e','r',' ','\x84',
/* 0x15e5b = "Process Verification Failure: Error opening image file." */
    '\x1e','\x0d','\x12','\xc0','o','p','e','n','i','n','g',' ','\x26','f','i','l','e','.',
/* 0x15e6d = "VERR_PGM_HANDLER_ALREADY_ALIASED" */
    '\x01','\x8c','H','A','N','D','L','E','R','_','\x9b','A','L','I','A','S','E','D',
/* 0x15e7f = "VERR_SUP_VP_NO_FOUND_NO_EXE_MAPPING" */
    '\x01','\x95','\xbd','\x60','\x2a','_','\x60','E','X','E','_','M','A','P','P','I','N','G',
/* 0x15e91 = "VINF_EM_RESCHEDULE_REM" */
    '\x0e','E','M','_','R','E','S','C','H','E','D','U','L','E','_','R','E','M',
/* 0x15ea3 = "VERR_ISOMK_IPE_EMPTY_COMPONENT" */
    '\x01','\x22','\x14','E','M','P','T','Y','_','C','O','M','P','O','N','E','N','T',
/* 0x15eb5 = "VERR_IEM_DBGINFO_OUT_OF_MEMORY" */
    '\x01','\x9c','D','B','G','I','N','F','O','_','O','U','T','_','O','F','_','\xb6',
/* 0x15ec7 = "Bad left tree height." */
    '\x9f','l','e','f','t',' ','t','r','e','e',' ','h','e','i','g','h','t','.',
/* 0x15ed9 = "VERR_PERMISSION_DENIED" */
    '\x01','P','E','R','M','I','S','S','I','O','N','_','D','E','N','I','E','D',
/* 0x15eeb = "VERR_NET_NO_BUFFER_SPACE" */
    '\x01','N','E','T','_','\x60','B','U','F','F','E','R','_','S','P','A','C','E',
/* 0x15efd = "The per process timer is busy." */
    '\x03','p','e','r',' ','\x92','t','i','m','e','r',' ','\x0b','b','u','s','y','.',
/* 0x15f0f = "Invalid requested privilege level." */
    '\x0c','\xde','p','r','i','v','i','l','e','g','e',' ','l','e','v','e','l','.',
/* 0x15f21 = "The PE loader doesn't support the TLS data directory yet." */
    '\x03','P','E',' ','\xd9','\xc7','\xce','\x02','T','L','S',' ','\x9d','\x25','y','e','t','.',
/* 0x15f33 = "VERR_SELECTOR_NOT_PRESENT" */
    '\x01','S','E','L','E','C','T','O','R','_','\x06','P','R','E','S','E','N','T',
/* 0x15f45 = "VERR_FAILED_TO_SET_SELF_TLS" */
    '\x01','\x17','_','T','O','_','S','E','T','_','S','E','L','F','_','T','L','S',
/* 0x15f57 = "VERR_LDR_INVALID_LINK_ADDRESS" */
    '\x01','L','D','R','_','\x05','L','I','N','K','_','A','D','D','R','E','S','S',
/* 0x15f69 = "VERR_ISOMK_IMPORT_INVALID_VOLUMNE_SEQ_NO" */
    '\x01','\x22','\x83','\x05','V','O','L','U','M','N','E','_','S','E','Q','_','N','O',
/* 0x15f7b = "VERR_ISOMK_IMPORT_UDF_SPARSE_FILE" */
    '\x01','\x22','\x83','U','D','F','_','S','P','A','R','S','E','_','F','I','L','E',
/* 0x15f8d = "VERR_CFGM_INTEGER_TOO_BIG" */
    '\x01','C','F','G','M','_','I','N','T','E','G','E','R','_','\x1a','B','I','G',
/* 0x15f9f = "VINF_EM_RAW_GUEST_TRAP" */
    '\x0e','E','M','_','R','A','W','_','G','U','E','S','T','_','T','R','A','P',
/* 0x15fb1 = "Unknown allocation descriptor type." */
    '\xef','a','l','l','o','c','a','t','i','o','n',' ','\xe3','t','y','p','e','.',
/* 0x15fc3 = "VERR_PKZIP_BAD_CDF_HEADER" */
    '\x01','P','K','Z','I','P','_','\x1d','C','D','F','_','H','E','A','D','E','R',
/* 0x15fd5 = "VINF_IEM_RECOMPILE_END_TB" */
    '\x0e','\x9c','R','E','C','O','M','P','I','L','E','_','E','N','D','_','T','B',
/* 0x15fe7 = "VERR_CR_KEY_DECRYPTION_FAILED" */
    '\x01','\x24','K','E','Y','_','D','E','C','R','Y','P','T','I','O','N','_','\x17',
/* 0x15ff9 = "VERR_SHARING_VIOLATION" */
    '\x01','S','H','A','R','I','N','G','_','V','I','O','L','A','T','I','O','N',
/* 0x1600b = "Bad file element in XAR table of content." */
    '\x9f','\x1f','\x5c','\x0f','X','A','R',' ','\xb1','\x15','c','o','n','t','e','n','t','.',
/* 0x1601d = "Process Verification Failure: Bad size of image header." */
    '\x1e','\x0d','\x12','\x9f','s','i','z','e',' ','\x15','\x26','h','e','a','d','e','r','.',
/* 0x1602f = "Device i/o: Bad unit." */
    'D','e','v','i','c','e',' ','i','/','o',':',' ','\x9f','u','n','i','t','.',
/* 0x16041 = "The tracer has not been opened." */
    '\x03','t','r','a','c','e','r',' ','\x5e','\x08','\xcb','o','p','e','n','e','d','.',
/* 0x16053 = "iSCSI: Invalid header, i." */
    'i','S','C','S','I',':',' ','\x0c','h','e','a','d','e','r',',',' ','i','.',
/* 0x16065 = "Invalid signature length." */
    '\x0c','s','i','g','n','a','t','u','r','e',' ','l','e','n','g','t','h','.',
/* 0x16077 = "Internal processing error #3 in the I/O port code." */
    '\x07','\x04','\x09','#','3',' ','\x0f','\x02','I','/','O',' ','p','o','r','t',' ','\x84',
/* 0x16089 = "Undefined VM exit code." */
    'U','n','d','e','f','i','n','e','d',' ','\xcd',' ','e','x','i','t',' ','\x84',
/* 0x1609b = "Stream is not ready for requested operation." */
    'S','t','r','e','a','m',' ','\x0b','\x08','r','e','a','d','y',' ','\x10','\xde','\xea',
/* 0x160ad = "VERR_VM_SAVE_STATE_NOT_ALLOWED" */
    '\x01','\xcd','_','S','A','V','E','_','\xf1','_','\x06','A','L','L','O','W','E','D',
/* 0x160bf = "VERR_PGM_PHYS_HANDLER_IPE" */
    '\x01','\x8c','P','H','Y','S','_','H','A','N','D','L','E','R','_','I','P','E',
/* 0x160d1 = "Pending VM request packet." */
    'P','e','n','d','i','n','g',' ','\xcd',' ','\xaa','p','a','c','k','e','t','.',
/* 0x160e3 = "VERR_LDRELF_ODD_ENDIAN" */
    '\x01','L','D','R','E','L','F','_','O','D','D','_','E','N','D','I','A','N',
/* 0x160f5 = "VERR_CPUM_UNSUPPORTED_ID_REGISTER" */
    '\x01','C','P','U','M','_','\x1c','I','D','_','R','E','G','I','S','T','E','R',
/* 0x16107 = "VERR_CR_PKIX_SIGNATURE_MISMATCH" */
    '\x01','\x24','P','K','I','X','_','S','I','G','N','A','T','U','R','E','_','\x19',
/* 0x16119 = "Process Verification Failure: Bad image base in header." */
    '\x1e','\x0d','\x12','\x9f','\x26','b','a','s','e',' ','\x0f','h','e','a','d','e','r','.',
/* 0x1612b = "VERR_ISOFS_NO_ADS_FOR_UDF_DIR" */
    '\x01','\x97','\x60','A','D','S','_','F','O','R','_','U','D','F','_','D','I','R',
/* 0x1613d = "VERR_PGM_PHYS_NULL_PAGE_PARAM" */
    '\x01','\x8c','P','H','Y','S','_','N','U','L','L','_','\xdc','P','A','R','A','M',
/* 0x1614f = "FTP Internal Server Error." */
    'F','T','P',' ','\x07','S','e','r','v','e','r',' ','E','r','r','o','r','.',
/* 0x16161 = "VERR_IPC_RECEIVE_MAP_FAILED" */
    '\x01','I','P','C','_','R','E','C','E','I','V','E','_','M','A','P','_','\x17',
/* 0x16173 = "VERR_POLL_HANDLE_ID_NOT_FOUND" */
    '\x01','P','O','L','L','_','H','A','N','D','L','E','_','I','D','_','\x06','\x2a',
/* 0x16185 = "VERR_LDR_FORWARDERS_NOT_SUPPORTED" */
    '\x01','L','D','R','_','F','O','R','W','A','R','D','E','R','S','_','\x06','\x82',
/* 0x16197 = "VERR_XML_TOC_ELEMENT_MISSING" */
    '\x01','X','M','L','_','T','O','C','_','E','L','E','M','E','N','T','_','\xc4',
/* 0x161a9 = "VERR_TRPM_NO_ACTIVE_TRAP" */
    '\x01','T','R','P','M','_','\x60','A','C','T','I','V','E','_','T','R','A','P',
/* 0x161bb = "Invalid I/O port handle." */
    '\x0c','I','/','O',' ','p','o','r','t',' ','h','a','n','d','l','e','.',
/* 0x161cc = "VERR_PATH_IS_RELATIVE" */
    '\x01','P','A','T','H','_','I','S','_','R','E','L','A','T','I','V','E',
/* 0x161dd = "VERR_OUT_OF_RESOURCES" */
    '\x01','O','U','T','_','O','F','_','R','E','S','O','U','R','C','E','S',
/* 0x161ee = "Unknown I/O instruction." */
    '\xef','I','/','O',' ','i','n','s','t','r','u','c','t','i','o','n','.',
/* 0x161ff = "VERR_SUPDRV_VTG_ALREADY_REGISTERED" */
    '\x01','\x90','V','T','G','_','\x9b','R','E','G','I','S','T','E','R','E','D',
/* 0x16210 = "Bad load command(s)." */
    '\x9f','l','o','a','d',' ','c','o','m','m','a','n','d','(','s',')','.',
/* 0x16221 = "Pipe is not connected." */
    'P','i','p','e',' ','\x0b','\x08','c','o','n','n','e','c','t','e','d','.',
/* 0x16232 = "VERR_ISOFS_FSD_NEXT_EXTENT" */
    '\x01','\x97','F','S','D','_','N','E','X','T','_','E','X','T','E','N','T',
/* 0x16243 = "Unit header integrity error." */
    'U','n','i','t',' ','\xb3','i','n','t','e','g','r','i','t','y',' ','\x85',
/* 0x16254 = "VERR_NET_TOO_MANY_REFERENCES" */
    '\x01','N','E','T','_','\x1a','\xac','R','E','F','E','R','E','N','C','E','S',
/* 0x16265 = "Expected a provider name." */
    '\xb8','a',' ','p','r','o','v','i','d','e','r',' ','n','a','m','e','.',
/* 0x16276 = "Invalid escape sequence." */
    '\x0c','e','s','c','a','p','e',' ','s','e','q','u','e','n','c','e','.',
/* 0x16287 = "VERR_THREAD_NOT_WAITABLE" */
    '\x01','T','H','R','E','A','D','_','\x06','W','A','I','T','A','B','L','E',
/* 0X16298 = "EVP_DecryptInit failed." */
    'V','P','_','D','e','c','r','y','p','t','I','n','i','t',' ','\x7b',
/* 0x162a8 = "VERR_GVMM_BROKEN_IPRT" */
    '\x01','G','V','M','M','_','B','R','O','K','E','N','_','I','P','R','T',
/* 0x162b9 = "VERR_DBG_ADDRESS_WRAP" */
    '\x01','D','B','G','_','A','D','D','R','E','S','S','_','W','R','A','P',
/* 0x162ca = "VERR_SUP_VP_STUB_THREAD_NOT_FOUND" */
    '\x01','\x95','\xbd','S','T','U','B','_','T','H','R','E','A','D','_','\x06','\x2a',
/* 0x162db = "VERR_IPC_SEND_ABORTED" */
    '\x01','I','P','C','_','S','E','N','D','_','A','B','O','R','T','E','D',
/* 0x162ec = "VERR_S3_ACCESS_DENIED" */
    '\x01','S','3','_','A','C','C','E','S','S','_','D','E','N','I','E','D',
/* 0x162fd = "VERR_CR_PKCS7_EXPECTED_NO_CRLS" */
    '\x01','\x24','\xe5','E','X','P','E','C','T','E','D','_','\x60','C','R','L','S',
/* 0x1630e = "VERR_MANIFEST_ATTR_NOT_FOUND" */
    '\x01','M','A','N','I','F','E','S','T','_','A','T','T','R','_','\x06','\x2a',
/* 0x1631f = "VERR_EXTPACK_VBOX_VERSION_MISMATCH" */
    '\x01','E','X','T','P','A','C','K','_','V','B','O','X','_','\xbc','_','\x19',
/* 0x16330 = "VERR_OBJECT_DESTROYED" */
    '\x01','O','B','J','E','C','T','_','D','E','S','T','R','O','Y','E','D',
/* 0x16341 = "VINF_GIM_R3_HYPERCALL" */
    '\x0e','G','I','M','_','R','3','_','H','Y','P','E','R','C','A','L','L',
/* 0x16352 = "VINF_SSM_DONT_CALL_AGAIN" */
    '\x0e','\xb0','D','O','N','T','_','C','A','L','L','_','A','G','A','I','N',
/* 0x16363 = "Stop the TCP server." */
    'S','t','o','p',' ','\x02','T','C','P',' ','s','e','r','v','e','r','.',
/* 0x16374 = "The tar header is all zeros." */
    '\x03','t','a','r',' ','\xb3','\x0b','a','l','l',' ','z','e','r','o','s','.',
/* 0x16385 = "Encoding skipped." */
    'E','n','c','o','d','i','n','g',' ','s','k','i','p','p','e','d','.',
/* 0x16396 = "Zero length path." */
    'Z','e','r','o',' ','l','e','n','g','t','h',' ','p','a','t','h','.',
/* 0x163a7 = "VINF_CPUM_R3_MSR_READ" */
    '\x0e','C','P','U','M','_','R','3','_','M','S','R','_','R','E','A','D',
/* 0x163b8 = "VERR_TRPM_BAD_TRAP_IN_OP" */
    '\x01','T','R','P','M','_','\x1d','T','R','A','P','_','I','N','_','O','P',
/* 0x163c9 = "VERR_DBG_NOT_NM_MAP_FILE" */
    '\x01','D','B','G','_','\x06','N','M','_','M','A','P','_','F','I','L','E',
/* 0x163da = "VERR_PLATFORM_ARCH_NOT_SUPPORTED" */
    '\x01','P','L','A','T','F','O','R','M','_','A','R','C','H','_','\x06','\x82',
/* 0x163eb = "VERR_VFS_CHAIN_READ_ONLY_IOS" */
    '\x01','\x8d','_','\x8e','R','E','A','D','_','O','N','L','Y','_','I','O','S',
/* 0x163fc = "VERR_PDM_NOT_PCI_BUS_MASTER" */
    '\x01','\x7d','\x06','P','C','I','_','B','U','S','_','M','A','S','T','E','R',
/* 0x1640d = "VERR_IS_A_CHAR_DEVICE" */
    '\x01','I','S','_','A','_','C','H','A','R','_','D','E','V','I','C','E',
/* 0x1641e = "VINF_OBJECT_DESTROYED" */
    '\x0e','O','B','J','E','C','T','_','D','E','S','T','R','O','Y','E','D',
/* 0x1642f = "VINF_PCI_MAPPING_DONE" */
    '\x0e','P','C','I','_','M','A','P','P','I','N','G','_','D','O','N','E',
/* 0x16440 = "VERR_SUPLIB_TEXT_NOT_WRITEABLE" */
    '\x01','\xd6','T','E','X','T','_','\x06','W','R','I','T','E','A','B','L','E',
/* 0x16451 = "VERR_VFS_CHAIN_TAKES_FILE_OR_IOS" */
    '\x01','\x8d','_','\x8e','T','A','K','E','S','_','\xab','O','R','_','I','O','S',
/* 0x16462 = "The semaphore is in use." */
    '\x03','s','e','m','a','p','h','o','r','e',' ','\x0b','\x0f','u','s','e','.',
/* 0x16473 = "VERR_INTNET_FLT_IF_NOT_FOUND" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','I','F','_','\x06','\x2a',
/* 0x16484 = "VERR_CFGM_NODE_EXISTS" */
    '\x01','C','F','G','M','_','N','O','D','E','_','E','X','I','S','T','S',
/* 0x16495 = "Internal processing error #2 in the DBGF stack code." */
    '\x07','\x04','\x09','#','2',' ','\x0f','\x02','\xb9',' ','s','t','a','c','k',' ','\x84',
/* 0x164a6 = "VERR_NET_ALREADY_IN_PROGRESS" */
    '\x01','N','E','T','_','\x9b','I','N','_','P','R','O','G','R','E','S','S',
/* 0x164b7 = "Patch was already disabled." */
    'P','a','t','c','h',' ','\x11','\x7f','d','i','s','a','b','l','e','d','.',
/* 0x164c8 = "VERR_DBGC_PARSE_TOO_FEW_ARGUMENTS" */
    '\x01','\xfc','\xe4','\x1a','F','E','W','_','A','R','G','U','M','E','N','T','S',
/* 0x164d9 = "VERR_LDRMACHO_OTHER_ENDIAN_NOT_SUPPORTED" */
    '\x01','\xe9','O','T','H','E','R','_','E','N','D','I','A','N','_','\x06','\x82',
/* 0x164ea = "VERR_SUP_VP_UNEXPECTED_SECTION_FLAGS" */
    '\x01','\x95','\xbd','\x88','S','E','C','T','I','O','N','_','F','L','A','G','S',
/* 0x164fb = "VERR_VD_IMAGE_CORRUPTED" */
    '\x01','\xff','I','M','A','G','E','_','C','O','R','R','U','P','T','E','D',
/* 0x1650c = "Out of range enum value." */
    'O','u','t',' ','\x15','r','a','n','g','e',' ','e','n','u','m',' ','\xe8',
/* 0x1651d = "Address overflow." */
    'A','d','d','r','e','s','s',' ','o','v','e','r','f','l','o','w','.',
/* 0x1652e = "Value out of range." */
    'V','a','l','u','e',' ','o','u','t',' ','\x15','r','a','n','g','e','.',
/* 0x1653f = "VINF_VRDP_PROCESS_PDU" */
    '\x0e','V','R','D','P','_','P','R','O','C','E','S','S','_','P','D','U',
/* 0x16550 = "Configuration value not found." */
    'C','o','n','f','i','g','u','r','a','t','i','o','n',' ','\xf5','\x08','\x89',
/* 0x16561 = "VERR_BUFFER_UNDERFLOW" */
    '\x01','B','U','F','F','E','R','_','U','N','D','E','R','F','L','O','W',
/* 0x16572 = "VERR_DANGLING_OBJECTS" */
    '\x01','D','A','N','G','L','I','N','G','_','O','B','J','E','C','T','S',
/* 0x16583 = "VWRN_PATCH_END_BRANCH" */
    '\xe6','P','A','T','C','H','_','E','N','D','_','B','R','A','N','C','H',
/* 0x16594 = "VERR_PGM_SAVED_ROM_PAGE_PROT" */
    '\x01','\x8c','S','A','V','E','D','_','R','O','M','_','\xdc','P','R','O','T',
/* 0x165a5 = "VERR_NOT_ALL_CPUS_SHOWED" */
    '\x01','\x06','A','L','L','_','C','P','U','S','_','S','H','O','W','E','D',
/* 0x165b6 = "VERR_SUP_VP_UNEXPECTED_IMAGE_MACHINE" */
    '\x01','\x95','\xbd','\x88','I','M','A','G','E','_','M','A','C','H','I','N','E',
/* 0x165c7 = "VERR_VFS_CHAIN_TYPE_MISMATCH_PATH_ONLY" */
    '\x01','\x8d','_','\x8e','\xb5','_','\x19','_','P','A','T','H','_','O','N','L','Y',
/* 0x165d8 = "VERR_VM_REQUEST_KILLED" */
    '\x01','\xcd','_','R','E','Q','U','E','S','T','_','K','I','L','L','E','D',
/* 0x165e9 = "VERR_CR_X509_NAME_EMPTY_SET" */
    '\x01','\x24','\xb7','N','A','M','E','_','E','M','P','T','Y','_','S','E','T',
/* 0x165fa = "Not a power of two." */
    'N','o','t',' ','a',' ','p','o','w','e','r',' ','\x15','t','w','o','.',
/* 0x1660b = "VERR_VGA_INVALID_CUSTOM_MODE" */
    '\x01','V','G','A','_','\x05','C','U','S','T','O','M','_','M','O','D','E',
/* 0x1661c = "VINF_BUFFER_UNDERFLOW" */
    '\x0e','B','U','F','F','E','R','_','U','N','D','E','R','F','L','O','W',
/* 0x1662d = "Unknown location opcode." */
    '\xef','l','o','c','a','t','i','o','n',' ','o','p','c','o','d','e','.',
/* 0x1663e = "VERR_CFGM_INVALID_CHILD_PATH" */
    '\x01','C','F','G','M','_','\x05','C','H','I','L','D','_','P','A','T','H',
/* 0x1664f = "VERR_SUP_VP_QUERY_HANDLE_TYPE" */
    '\x01','\x95','\xbd','Q','U','E','R','Y','_','H','A','N','D','L','E','_','\xb5',
/* 0x16660 = "VERR_LDRLX_BAD_FORWARDER" */
    '\x01','L','D','R','L','X','_','\x1d','F','O','R','W','A','R','D','E','R',
/* 0x16671 = "VINF_IPC_SEND_MSG_CUT" */
    '\x0e','I','P','C','_','S','E','N','D','_','M','S','G','_','C','U','T',
/* 0x16682 = "Unexpected end of DWARF unit." */
    '\x94','e','n','d',' ','\x15','D','W','A','R','F',' ','u','n','i','t','.',
/* 0x16693 = "VERR_CR_STORE_GENERIC_ERROR" */
    '\x01','\x24','S','T','O','R','E','_','G','E','N','E','R','I','C','_','\x1b',
/* 0x166a4 = "Unable to parse string as bool." */
    '\xe0','\x0a','p','a','r','s','e',' ','\xf2','a','s',' ','b','o','o','l','.',
/* 0x166b5 = "VERR_FILE_AIO_IN_PROGRESS" */
    '\x01','\xab','A','I','O','_','I','N','_','P','R','O','G','R','E','S','S',
/* 0x166c6 = "VERR_POLL_SET_IS_FULL" */
    '\x01','P','O','L','L','_','S','E','T','_','I','S','_','F','U','L','L',
/* 0x166d7 = "VERR_ASN1_OBJID_INVALID_DOTTED_STRING" */
    '\x01','\xa2','O','B','J','I','D','_','\x05','D','O','T','T','E','D','_','\xd5',
/* 0x166e8 = "VERR_NET_NOT_UNSUPPORTED" */
    '\x01','N','E','T','_','\x06','U','N','S','U','P','P','O','R','T','E','D',
/* 0x166f9 = "VERR_IPC_SEND_TIMEOUT" */
    '\x01','I','P','C','_','S','E','N','D','_','T','I','M','E','O','U','T',
/* 0x1670a = "Version mismatch." */
    'V','e','r','s','i','o','n',' ','m','i','s','m','a','t','c','h','.',
/* 0x1671b = "VERR_L4_DS_MANAGER_NOT_FOUND" */
    '\x01','L','4','_','D','S','_','M','A','N','A','G','E','R','_','\x06','\x2a',
/* 0x1672c = "VERR_DBG_NO_UNWIND_INFO" */
    '\x01','D','B','G','_','\x60','U','N','W','I','N','D','_','I','N','F','O',
/* 0x1673d = "VERR_S3_BUCKET_NOT_EMPTY" */
    '\x01','S','3','_','B','U','C','K','E','T','_','\x06','E','M','P','T','Y',
/* 0x1674e = "Device i/o: CRC error." */
    'D','e','v','i','c','e',' ','i','/','o',':',' ','C','R','C',' ','\x85',
/* 0x1675f = "No attached driver." */
    '\xdf','a','t','t','a','c','h','e','d',' ','d','r','i','v','e','r','.',
/* 0x16770 = "VERR_VGA_GL_SYMBOL_NOT_FOUND" */
    '\x01','V','G','A','_','G','L','_','S','Y','M','B','O','L','_','\x06','\x2a',
/* 0x16781 = "Unsupported file system charset." */
    '\x98','\x1f','s','y','s','t','e','m',' ','c','h','a','r','s','e','t','.',
/* 0x16792 = "Buffer underflow." */
    'B','u','f','f','e','r',' ','u','n','d','e','r','f','l','o','w','.',
/* 0x167a3 = "VERR_SUPDRV_TRACER_NOT_PRESENT" */
    '\x01','\x90','T','R','A','C','E','R','_','\x06','P','R','E','S','E','N','T',
/* 0x167b4 = "VERR_SSM_FIELD_INVALID_CALLBACK" */
    '\x01','\xb0','F','I','E','L','D','_','\x05','C','A','L','L','B','A','C','K',
/* 0x167c5 = "VERR_VFS_CHAIN_ONLY_DIR_OR_VFS" */
    '\x01','\x8d','_','\x8e','O','N','L','Y','_','D','I','R','_','O','R','_','\x8d',
/* 0x167d6 = "The LUN is still busy." */
    '\x03','L','U','N',' ','\x0b','s','t','i','l','l',' ','b','u','s','y','.',
/* 0x167e7 = "Bad new tree height." */
    '\x9f','n','e','w',' ','t','r','e','e',' ','h','e','i','g','h','t','.',
/* 0x167f8 = "No logger instance." */
    '\xdf','l','o','g','g','e','r',' ','i','n','s','t','a','n','c','e','.',
/* 0x16809 = "VERR_PKZIP_NAME_TOO_LONG" */
    '\x01','P','K','Z','I','P','_','N','A','M','E','_','\x1a','L','O','N','G',
/* 0x1681a = "The server was stopped." */
    '\x03','s','e','r','v','e','r',' ','\x11','s','t','o','p','p','e','d','.',
/* 0x1682b = "VERR_LDRVI_PAGE_HASH_TAB_TOO_LONG" */
    '\x01','\xf4','\xdc','H','A','S','H','_','T','A','B','_','\x1a','L','O','N','G',
/* 0x1683c = "VWRN_OUT_OF_RESOURCES" */
    '\xe6','O','U','T','_','O','F','_','R','E','S','O','U','R','C','E','S',
/* 0x1684d = "No node was specified." */
    '\xdf','n','o','d','e',' ','\x11','s','p','e','c','i','f','i','e','d','.',
/* 0x1685e = "VERR_PGM_SAVED_MMIO2_PAGE_NOT_FOUND" */
    '\x01','\x8c','S','A','V','E','D','_','M','M','I','O','2','_','\xdc','\x06','\x2a',
/* 0x1686f = "VERR_FDT_DTB_HDR_VERSION_NOT_SUPPORTED" */
    '\x01','F','D','T','_','D','T','B','_','H','D','R','_','\xbc','_','\x06','\x82',
/* 0x16880 = "VWRN_DANGLING_OBJECTS" */
    '\xe6','D','A','N','G','L','I','N','G','_','O','B','J','E','C','T','S',
/* 0x16891 = "VERR_PKZIP_BAD_LF_HEADER" */
    '\x01','P','K','Z','I','P','_','\x1d','L','F','_','H','E','A','D','E','R',
/* 0x168a2 = "VERR_URI_INVALID_PORT_NUMBER" */
    '\x01','U','R','I','_','\x05','P','O','R','T','_','N','U','M','B','E','R',
/* 0x168b3 = "Syntax error - buggy parser." */
    '\xfa','\x09','-',' ','b','u','g','g','y',' ','p','a','r','s','e','r','.',
/* 0x168c4 = "VERR_ASN1_CURSOR_LONG_TAG" */
    '\x01','\xa2','C','U','R','S','O','R','_','L','O','N','G','_','T','A','G',
/* 0x168d5 = "validation of LX header failed." */
    'v','a','l','i','d','a','t','i','o','n',' ','\x15','L','X',' ','\xb3','\x7b',
/* 0x168e6 = "VERR_PATCHING_REFUSED" */
    '\x01','P','A','T','C','H','I','N','G','_','R','E','F','U','S','E','D',
/* 0x168f7 = "VERR_NEM_MISSING_KERNEL_API_5" */
    '\x01','\xee','_','\xc4','_','K','E','R','N','E','L','_','A','P','I','_','5',
/* 0x16908 = "VERR_PATH_ZERO_LENGTH" */
    '\x01','P','A','T','H','_','Z','E','R','O','_','L','E','N','G','T','H',
/* 0x16919 = "VINF_IEM_REEXEC_BREAK_FF" */
    '\x0e','\x9c','R','E','E','X','E','C','_','B','R','E','A','K','_','F','F',
/* 0x1692a = "VERR_NET_NOT_UNIQUE_NAME" */
    '\x01','N','E','T','_','\x06','U','N','I','Q','U','E','_','N','A','M','E',
/* 0x1693b = "VERR_VMM_CANNOT_BLOCK" */
    '\x01','V','M','M','_','C','A','N','N','O','T','_','B','L','O','C','K',
/* 0x1694c = "VERR_DBGC_PARSE_EMPTY_ARGUMENT" */
    '\x01','\xfc','\xe4','E','M','P','T','Y','_','A','R','G','U','M','E','N','T',
/* 0x1695d = "VERR_NEM_MISSING_KERNEL_API_4" */
    '\x01','\xee','_','\xc4','_','K','E','R','N','E','L','_','A','P','I','_','4',
/* 0x1696e = "VERR_NEM_MISSING_KERNEL_API_2" */
    '\x01','\xee','_','\xc4','_','K','E','R','N','E','L','_','A','P','I','_','2',
/* 0x1697f = "VERR_NEM_MISSING_KERNEL_API_1" */
    '\x01','\xee','_','\xc4','_','K','E','R','N','E','L','_','A','P','I','_','1',
/* 0x16990 = "VERR_NEM_MISSING_KERNEL_API_3" */
    '\x01','\xee','_','\xc4','_','K','E','R','N','E','L','_','A','P','I','_','3',
/* 0x169a1 = "Unsupported CPU ID register." */
    '\x98','C','P','U',' ','I','D',' ','r','e','g','i','s','t','e','r','.',
/* 0x169b2 = "VERR_PREEMPT_DISABLED" */
    '\x01','P','R','E','E','M','P','T','_','D','I','S','A','B','L','E','D',
/* 0x169c3 = "VERR_SUP_VP_NO_NTDLL_MAPPING" */
    '\x01','\x95','\xbd','\x60','N','T','D','L','L','_','M','A','P','P','I','N','G',
/* 0x169d4 = "VERR_DBGF_BP_L1_LOOKUP_FAILED" */
    '\x01','\xb9','_','B','P','_','L','1','_','L','O','O','K','U','P','_','\x17',
/* 0x169e5 = "VERR_SUP_VP_NT_QI_THREAD_ERROR" */
    '\x01','\x95','\xbd','N','T','_','Q','I','_','T','H','R','E','A','D','_','\x1b',
/* 0x169f6 = "Bad file mode for XAR file." */
    '\x9f','\x1f','m','o','d','e',' ','\x10','X','A','R',' ','f','i','l','e','.',
/* 0x16a07 = "The block driver type wasn\'t supported." */
    '\x03','b','l','o','c','k',' ','\xc5','\xf3','w','a','s','n','\'','t',' ','\xa4',
/* 0x16a18 = "VERR_SSM_INTEGRITY_DECOMPRESSION" */
    '\x01','\xb0','\xf7','_','D','E','C','O','M','P','R','E','S','S','I','O','N',
/* 0x16a29 = "The I/O request is in progress." */
    '\x03','I','/','O',' ','\xaa','\x0b','\x0f','p','r','o','g','r','e','s','s','.',
/* 0x16a3a = "Call interrupted." */
    'C','a','l','l',' ','i','n','t','e','r','r','u','p','t','e','d','.',
/* 0x16a4b = "VERR_LDRLX_BAD_ITERDATA2" */
    '\x01','L','D','R','L','X','_','\x1d','I','T','E','R','D','A','T','A','2',
/* 0x16a5c = "Generic USB device structure version mismatch." */
    '\xa6','U','S','B',' ','\xa3','\xec','\xcf','m','i','s','m','a','t','c','h','.',
/* 0x16a6d = "VERR_PGM_DYNMAP_EXPAND_ERROR" */
    '\x01','\x8c','D','Y','N','M','A','P','_','E','X','P','A','N','D','_','\x1b',
/* 0x16a7e = "VERR_ADDRESS_CONFLICT" */
    '\x01','A','D','D','R','E','S','S','_','C','O','N','F','L','I','C','T',
/* 0x16a8f = "VERR_ISOMK_IMPORT_TOO_DEEP_DIR_TREE" */
    '\x01','\x22','\x83','\x1a','D','E','E','P','_','D','I','R','_','T','R','E','E',
/* 0x16aa0 = "VERR_XAR_TOC_STRLEN_MISMATCH" */
    '\x01','X','A','R','_','T','O','C','_','S','T','R','L','E','N','_','\x19',
/* 0x16ab1 = "Bad forwarder entry." */
    '\x9f','f','o','r','w','a','r','d','e','r',' ','e','n','t','r','y','.',
/* 0x16ac2 = "VERR_RECORDING_INIT_FAILED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','I','N','I','T','_','\x17',
/* 0x16ad3 = "VERR_DBGC_PARSE_NO_RANGE_ALLOWED" */
    '\x01','\xfc','\xe4','\x60','R','A','N','G','E','_','A','L','L','O','W','E','D',
/* 0x16ae4 = "Invalid Base64 encoding." */
    '\x0c','B','a','s','e','6','4',' ','e','n','c','o','d','i','n','g','.',
/* 0x16af5 = "Stop the UDP server." */
    'S','t','o','p',' ','\x02','U','D','P',' ','s','e','r','v','e','r','.',
/* 0x16b06 = "VERR_SUPLIB_INVALID_ARGV0_INTERNAL" */
    '\x01','\xd6','\x05','A','R','G','V','0','_','I','N','T','E','R','N','A','L',
/* 0x16b17 = "VERR_SSM_GCPHYS_OVERFLOW" */
    '\x01','\xb0','G','C','P','H','Y','S','_','O','V','E','R','F','L','O','W',
/* 0x16b28 = "Recompiler: Unexpected kind of variable." */
    '\x13','\x94','k','i','n','d',' ','\x15','v','a','r','i','a','b','l','e','.',
/* 0x16b39 = "Generic unexpected object ID error." */
    '\xa6','u','n','e','x','p','e','c','t','e','d',' ','\xa8','I','D',' ','\x85',
/* 0x16b4a = "VERR_SUP_VP_IMAGE_FILE_CLOSE_ERROR" */
    '\x01','\x95','\xbd','I','M','A','G','E','_','\xab','C','L','O','S','E','_','\x1b',
/* 0x16b5b = "VERR_FTP_DATA_CONN_NOT_FOUND" */
    '\x01','F','T','P','_','D','A','T','A','_','C','O','N','N','_','\x06','\x2a',
/* 0x16b6c = "VERR_IMAGE_BASE_TOO_HIGH" */
    '\x01','I','M','A','G','E','_','B','A','S','E','_','\x1a','H','I','G','H',
/* 0x16b7d = "VERR_CFGM_LEAF_EXISTS" */
    '\x01','C','F','G','M','_','L','E','A','F','_','E','X','I','S','T','S',
/* 0x16b8e = "VERR_PGM_PHYS_PAGE_BALLOONED" */
    '\x01','\x8c','P','H','Y','S','_','\xdc','B','A','L','L','O','O','N','E','D',
/* 0x16b9f = "Internal processing error #1 in the DBGF stack code." */
    '\x07','\x04','\x09','#','1',' ','\x0f','\x02','\xb9',' ','s','t','a','c','k',' ','\x84',
/* 0x16bb0 = "VERR_SYMLINK_NOT_ALLOWED" */
    '\x01','S','Y','M','L','I','N','K','_','\x06','A','L','L','O','W','E','D',
/* 0x16bc1 = "VERR_ISOFS_BOGUS_UDF_DIR_SIZE" */
    '\x01','\x97','B','O','G','U','S','_','U','D','F','_','D','I','R','_','\xf9',
/* 0x16bd2 = "RamPreAlloc not set." */
    'R','a','m','P','r','e','A','l','l','o','c',' ','\x08','s','e','t','.',
/* 0x16be3 = "VERR_SERVICE_DISABLED" */
    '\x01','S','E','R','V','I','C','E','_','D','I','S','A','B','L','E','D',
/* 0x16bf4 = "VERR_URI_ESCAPED_ZERO" */
    '\x01','U','R','I','_','E','S','C','A','P','E','D','_','Z','E','R','O',
/* 0x16c05 = "VERR_PGM_DYNMAP_FULL_SET" */
    '\x01','\x8c','D','Y','N','M','A','P','_','F','U','L','L','_','S','E','T',
/* 0x16c16 = "Address conflict." */
    'A','d','d','r','e','s','s',' ','c','o','n','f','l','i','c','t','.',
/* 0x16c27 = "VERR_PATM_UNSAFE_CODE" */
    '\x01','P','A','T','M','_','U','N','S','A','F','E','_','C','O','D','E',
/* 0x16c38 = "VERR_VD_IMAGE_READ_ONLY" */
    '\x01','\xff','I','M','A','G','E','_','R','E','A','D','_','O','N','L','Y',
/* 0x16c49 = "VERR_DBGF_NO_MORE_BP_SLOTS" */
    '\x01','\xb9','_','\x60','M','O','R','E','_','B','P','_','S','L','O','T','S',
/* 0x16c5a = "VERR_VD_IMAGE_REPAIR_NOT_SUPPORTED" */
    '\x01','\xff','I','M','A','G','E','_','R','E','P','A','I','R','_','\x06','\x82',
/* 0x16c6b = "VERR_NET_OPERATION_NOT_SUPPORTED" */
    '\x01','N','E','T','_','O','P','E','R','A','T','I','O','N','_','\x06','\x82',
/* 0x16c7c = "VINF_EM_RAW_IRET_TRAP" */
    '\x0e','E','M','_','R','A','W','_','I','R','E','T','_','T','R','A','P',
/* 0x16c8d = "VINF_AIO_TASK_PENDING" */
    '\x0e','A','I','O','_','T','A','S','K','_','P','E','N','D','I','N','G',
/* 0x16c9e = "Image is read-only." */
    'I','m','a','g','e',' ','\x0b','r','e','a','d','-','o','n','l','y','.',
/* 0x16caf = "Expected RSA private key." */
    '\xb8','R','S','A',' ','p','r','i','v','a','t','e',' ','k','e','y','.',
/* 0x16cc0 = "VERR_DBGF_BP_L2_LOOKUP_FAILED" */
    '\x01','\xb9','_','B','P','_','L','2','_','L','O','O','K','U','P','_','\x17',
/* 0x16cd1 = "VERR_TRPM_ACTIVE_TRAP" */
    '\x01','T','R','P','M','_','A','C','T','I','V','E','_','T','R','A','P',
/* 0x16ce2 = "Invalid parameter index." */
    '\x0c','p','a','r','a','m','e','t','e','r',' ','i','n','d','e','x','.',
/* 0x16cf3 = "The PKCS #7 content is not data." */
    '\x03','P','K','C','S',' ','#','7',' ','\xf0','\x0b','\x08','d','a','t','a','.',
/* 0x16d04 = "VINF_VHWA_CMD_PENDING" */
    '\x0e','V','H','W','A','_','C','M','D','_','P','E','N','D','I','N','G',
/* 0x16d15 = "A reboot is needed." */
    'A',' ','r','e','b','o','o','t',' ','\x0b','n','e','e','d','e','d','.',
/* 0x16d26 = "The requested type conversion was not supported." */
    '\x03','\xde','\xf3','c','o','n','v','e','r','s','i','o','n',' ','\x11','\x08','\xa4',
/* 0x16d37 = "Generic out of resources error." */
    '\xa6','o','u','t',' ','\x15','r','e','s','o','u','r','c','e','s',' ','\x85',
/* 0x16d48 = "VERR_SSM_STRUCTURE_MAGIC" */
    '\x01','\xb0','S','T','R','U','C','T','U','R','E','_','M','A','G','I','C',
/* 0x16d59 = "EVP_EncryptInit failed." */
    'E','V','P','_','E','n','c','r','y','p','t','I','n','i','t',' ','\x7b',
/* 0x16d6a = "VERR_GMM_CHUNK_INSERT" */
    '\x01','G','M','M','_','C','H','U','N','K','_','I','N','S','E','R','T',
/* 0x16d7b = "Bad TRPM_TRAP_IN_OP." */
    '\x9f','T','R','P','M','_','T','R','A','P','_','I','N','_','O','P','.',
/* 0x16d8c = "VERR_VM_DRIVER_OPEN_ERROR" */
    '\x01','\xcd','_','D','R','I','V','E','R','_','O','P','E','N','_','\x1b',
/* 0x16d9c = "VERR_HM_ALREADY_ENABLED_IPE" */
    '\x01','H','M','_','\x9b','E','N','A','B','L','E','D','_','I','P','E',
/* 0x16dac = "VERR_TM_TIMER_BAD_CLOCK" */
    '\x01','T','M','_','T','I','M','E','R','_','\x1d','C','L','O','C','K',
/* 0x16dbc = "The specified data unit wasn\'t found." */
    '\x03','\x18','\x9d','u','n','i','t',' ','w','a','s','n','\'','t',' ','\x89',
/* 0x16dcc = "VERR_LDRPE_GLOBALPTR" */
    '\x01','L','D','R','P','E','_','G','L','O','B','A','L','P','T','R',
/* 0x16ddc = "Generic VM-exit failure." */
    '\xa6','\xcd','-','e','x','i','t',' ','f','a','i','l','u','r','e','.',
/* 0x16dec = "VINF_PGM_GCPHYS_ALIASED" */
    '\x0e','\x8c','G','C','P','H','Y','S','_','A','L','I','A','S','E','D',
/* 0x16dfc = "VERR_ASN1_INVALID_UNIVERSAL_STRING_ENCODING" */
    '\x01','\xa2','\x05','U','N','I','V','E','R','S','A','L','_','\xd5','_','\xc6',
/* 0x16e0c = "VERR_PGM_MAPPINGS_FIXED" */
    '\x01','\x8c','M','A','P','P','I','N','G','S','_','F','I','X','E','D',
/* 0x16e1c = "VINF_BUFFER_OVERFLOW" */
    '\x0e','B','U','F','F','E','R','_','O','V','E','R','F','L','O','W',
/* 0x16e2c = "Already patched." */
    'A','l','r','e','a','d','y',' ','p','a','t','c','h','e','d','.',
/* 0x16e3c = "VERR_PGM_PHYS_PAGE_RESERVED" */
    '\x01','\x8c','P','H','Y','S','_','\xdc','R','E','S','E','R','V','E','D',
/* 0x16e4c = "Bad VTG attribute value." */
    '\x9f','V','T','G',' ','a','t','t','r','i','b','u','t','e',' ','\xe8',
/* 0x16e5c = "Encountered an unknown type flag." */
    '\xa5','\x87','u','n','k','n','o','w','n',' ','\xf3','f','l','a','g','.',
/* 0x16e6c = "VERR_HARDAVL_BAD_HEIGHT" */
    '\x01','H','A','R','D','A','V','L','_','\x1d','H','E','I','G','H','T',
/* 0x16e7c = "VERR_SELM_GDT_READ_ERROR" */
    '\x01','S','E','L','M','_','G','D','T','_','R','E','A','D','_','\x1b',
/* 0x16e8c = "VERR_NET_UNREACHABLE" */
    '\x01','N','E','T','_','U','N','R','E','A','C','H','A','B','L','E',
/* 0x16e9c = "VERR_NAT_REDIR_SETUP" */
    '\x01','N','A','T','_','R','E','D','I','R','_','S','E','T','U','P',
/* 0X16eac = "Patch was already enabled." */
    'a','t','c','h',' ','\x11','\x7f','e','n','a','b','l','e','d','.',
/* 0x16ebb = "VINF_PATM_SPINLOCK_FAILED" */
    '\x0e','P','A','T','M','_','S','P','I','N','L','O','C','K','_','\x17',
/* 0x16ecb = "VINF_TCP_SERVER_STOP" */
    '\x0e','T','C','P','_','S','E','R','V','E','R','_','S','T','O','P',
/* 0x16edb = "VERR_TM_TSC_ALREADY_TICKING" */
    '\x01','T','M','_','T','S','C','_','\x9b','T','I','C','K','I','N','G',
/* 0x16eeb = "Patch installed." */
    'P','a','t','c','h',' ','i','n','s','t','a','l','l','e','d','.',
/* 0x16efb = "The I/O request was canceled." */
    '\x03','I','/','O',' ','\xaa','\x11','c','a','n','c','e','l','e','d','.',
/* 0x16f0b = "VERR_FILE_LOCK_VIOLATION" */
    '\x01','\xab','L','O','C','K','_','V','I','O','L','A','T','I','O','N',
/* 0x16f1b = "VERR_UDP_SERVER_STOP" */
    '\x01','U','D','P','_','S','E','R','V','E','R','_','S','T','O','P',
/* 0x16f2b = "VERR_INTNET_FLT_IF_FAILED" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','I','F','_','\x17',
/* 0x16f3b = "VERR_SUP_VP_TOO_LARGE_REGION" */
    '\x01','\x95','\xbd','\x1a','L','A','R','G','E','_','R','E','G','I','O','N',
/* 0x16f4b = "VERR_MEM_CACHE_MAX_SIZE" */
    '\x01','M','E','M','_','C','A','C','H','E','_','M','A','X','_','\xf9',
/* 0x16f5b = "VINF_HM_DOUBLE_FAULT" */
    '\x0e','H','M','_','D','O','U','B','L','E','_','F','A','U','L','T',
/* 0x16f6b = "VERR_VD_VDI_INVALID_SIGNATURE" */
    '\x01','\xff','V','D','I','_','\x05','S','I','G','N','A','T','U','R','E',
/* 0x16f7b = "Logical Unit was not found." */
    'L','o','g','i','c','a','l',' ','U','n','i','t',' ','\x11','\x08','\x89',
/* 0x16f8b = "VERR_LDRVI_INVALID_SECTION_COUNT" */
    '\x01','\xf4','\x05','S','E','C','T','I','O','N','_','C','O','U','N','T',
/* 0x16f9b = "VERR_CPUM_INVALID_XSAVE_HDR" */
    '\x01','C','P','U','M','_','\x05','X','S','A','V','E','_','H','D','R',
/* 0x16fab = "Invalid Virtual CPU ID." */
    '\x0c','V','i','r','t','u','a','l',' ','C','P','U',' ','I','D','.',
/* 0x16fbb = "VERR_TRPM_DONT_PANIC" */
    '\x01','T','R','P','M','_','D','O','N','T','_','P','A','N','I','C',
/* 0x16fcb = "VINF_GVM_NOT_BUSY_IN_GC" */
    '\x0e','G','V','M','_','\x06','B','U','S','Y','_','I','N','_','G','C',
/* 0x16fdb = "Invalid segment offset." */
    '\x0c','s','e','g','m','e','n','t',' ','o','f','f','s','e','t','.',
/* 0x16feb = "VERR_CR_PKCS7_SIGNED_DATA_VERSION" */
    '\x01','\x24','\xe5','S','I','G','N','E','D','_','D','A','T','A','_','\xbc',
/* 0x16ffb = "VERR_XAR_BAD_FILE_DEVICE_NO" */
    '\x01','X','A','R','_','\x1d','\xab','D','E','V','I','C','E','_','N','O',
/* 0x1700b = "Internal processing error in the critical section code." */
    '\x07','\x04','\x09','\x0f','\x02','c','r','i','t','i','c','a','l',' ','\xdb','\x84',
/* 0x1701b = "VERR_BUFFER_OVERFLOW" */
    '\x01','B','U','F','F','E','R','_','O','V','E','R','F','L','O','W',
/* 0x1702b = "Bad VTG bit count value." */
    '\x9f','V','T','G',' ','b','i','t',' ','c','o','u','n','t',' ','\xe8',
/* 0x1703b = "The support driver is not accessible." */
    '\x03','\xce','\xc5','\x0b','\x08','a','c','c','e','s','s','i','b','l','e','.',
/* 0x1704b = "Bad argument flags." */
    '\x9f','a','r','g','u','m','e','n','t',' ','f','l','a','g','s','.',
/* 0x1705b = "VERR_TAR_BAD_MODE_FIELD" */
    '\x01','T','A','R','_','\x1d','M','O','D','E','_','F','I','E','L','D',
/* 0x1706b = "Bad MH_OBJECT file." */
    '\x9f','M','H','_','O','B','J','E','C','T',' ','f','i','l','e','.',
/* 0x1707b = "VERR_SUPLIB_PATH_NOT_ABSOLUTE" */
    '\x01','\xd6','P','A','T','H','_','\x06','A','B','S','O','L','U','T','E',
/* 0x1708b = "VERR_LDR_INVALID_SEG_OFFSET" */
    '\x01','L','D','R','_','\x05','S','E','G','_','O','F','F','S','E','T',
/* 0X1709b = "Trailing spaces." */
    'r','a','i','l','i','n','g',' ','s','p','a','c','e','s','.',
/* 0x170aa = "VERR_TCP_SERVER_STOP" */
    '\x01','T','C','P','_','S','E','R','V','E','R','_','S','T','O','P',
/* 0x170ba = "VERR_PIPE_NOT_CONNECTED" */
    '\x01','P','I','P','E','_','\x06','C','O','N','N','E','C','T','E','D',
/* 0x170ca = "TM requires GIP." */
    'T','M',' ','r','e','q','u','i','r','e','s',' ','G','I','P','.',
/* 0x170da = "Recompiler: Out of variables." */
    '\x13','O','u','t',' ','\x15','v','a','r','i','a','b','l','e','s','.',
/* 0x170ea = "VERR_NET_SOCKET_TYPE_NOT_SUPPORTED" */
    '\x01','N','E','T','_','S','O','C','K','E','T','_','\xb5','_','\x06','\x82',
/* 0x170fa = "VERR_TM_INVALID_TIMER_QUEUE" */
    '\x01','T','M','_','\x05','T','I','M','E','R','_','Q','U','E','U','E',
/* 0x1710a = "Normalization of ASN." */
    'N','o','r','m','a','l','i','z','a','t','i','o','n',' ','\x15','\xf6',
/* 0x1711a = "Invalid HGCM client id." */
    '\x0c','H','G','C','M',' ','c','l','i','e','n','t',' ','i','d','.',
/* 0x1712a = "VERR_IOM_NO_R3_MMIO_RANGE" */
    '\x01','I','O','M','_','\x60','R','3','_','\xd3','_','R','A','N','G','E',
/* 0x1713a = "VERR_CFGM_INVALID_NODE_PATH" */
    '\x01','C','F','G','M','_','\x05','N','O','D','E','_','P','A','T','H',
/* 0x1714a = "VWRN_FLOAT_UNDERFLOW" */
    '\xe6','F','L','O','A','T','_','U','N','D','E','R','F','L','O','W',
/* 0x1715a = "Unexpected SVM patch type." */
    '\x94','S','V','M',' ','p','a','t','c','h',' ','t','y','p','e','.',
/* 0x1716a = "VERR_NEM_UNMAP_PAGES_FAILED" */
    '\x01','\xee','_','U','N','M','A','P','_','P','A','G','E','S','_','\x17',
/* 0x1717a = "VERR_NET_PROTOCOL_NOT_SUPPORTED" */
    '\x01','N','E','T','_','P','R','O','T','O','C','O','L','_','\x06','\x82',
/* 0x1718a = "Fatal EMT wait error." */
    'F','a','t','a','l',' ','E','M','T',' ','w','a','i','t',' ','\x85',
/* 0x1719a = "VINF_PATM_PATCH_INT3" */
    '\x0e','P','A','T','M','_','P','A','T','C','H','_','I','N','T','3',
/* 0x171aa = "VERR_ISOFS_UNKNOWN_PART_MAP_TYPE_ID" */
    '\x01','\x97','\x91','P','A','R','T','_','M','A','P','_','\xb5','_','I','D',
/* 0x171ba = "Syntax error - invalid operation attempted." */
    '\xfa','\x09','-',' ','\x8f','\x96','a','t','t','e','m','p','t','e','d','.',
/* 0x171ca = "VERR_JSON_INVALID_CODEPOINT" */
    '\x01','J','S','O','N','_','\x05','C','O','D','E','P','O','I','N','T',
/* 0x171da = "Receive aborted." */
    'R','e','c','e','i','v','e',' ','a','b','o','r','t','e','d','.',
/* 0x171ea = "VERR_CR_KEY_PASSWORD_ENCODING" */
    '\x01','\x24','K','E','Y','_','P','A','S','S','W','O','R','D','_','\xc6',
/* 0x171fa = "Error getting the file mode." */
    '\xc0','g','e','t','t','i','n','g',' ','\x02','\x1f','m','o','d','e','.',
/* 0x1720a = "VERR_IEM_VAR_DUP_ARG_NO" */
    '\x01','\x9c','V','A','R','_','D','U','P','_','A','R','G','_','N','O',
/* 0x1721a = "VERR_CR_PKCS7_NO_CERTIFICATES" */
    '\x01','\x24','\xe5','\x60','C','E','R','T','I','F','I','C','A','T','E','S',
/* 0x1722a = "VERR_PGM_TOO_MANY_MMIO2_RANGES" */
    '\x01','\x8c','\x1a','\xac','M','M','I','O','2','_','R','A','N','G','E','S',
/* 0x1723a = "VINF_VMM_UNKNOWN_RING3_CALL" */
    '\x0e','V','M','M','_','\x91','R','I','N','G','3','_','C','A','L','L',
/* 0x1724a = "VERR_DWARF_ABBREV_NOT_FOUND" */
    '\x01','D','W','A','R','F','_','A','B','B','R','E','V','_','\x06','\x2a',
/* 0x1725a = "VERR_HTTP_REDIRECTED" */
    '\x01','H','T','T','P','_','R','E','D','I','R','E','C','T','E','D',
/* 0x1726a = "VERR_PDM_USB_NAME_CLASH" */
    '\x01','\x7d','U','S','B','_','N','A','M','E','_','C','L','A','S','H',
/* 0x1727a = "VERR_SUPLIB_WORLD_WRITABLE" */
    '\x01','\xd6','W','O','R','L','D','_','W','R','I','T','A','B','L','E',
/* 0x1728a = "Bogus UDF directory size." */
    'B','o','g','u','s',' ','U','D','F',' ','\x25','s','i','z','e','.',
/* 0x1729a = "VERR_LDRVI_BAD_CERT_MULTIPLE" */
    '\x01','\xf4','\x1d','C','E','R','T','_','M','U','L','T','I','P','L','E',
/* 0x172aa = "Invalid name for XAR file." */
    '\x0c','n','a','m','e',' ','\x10','X','A','R',' ','f','i','l','e','.',
/* 0x172ba = "VERR_GIM_OPERATION_FAILED" */
    '\x01','G','I','M','_','O','P','E','R','A','T','I','O','N','_','\x17',
/* 0x172ca = "Unsupported file system format." */
    '\x98','\x1f','s','y','s','t','e','m',' ','f','o','r','m','a','t','.',
/* 0x172da = "VERR_WEB_INVALID_SESSION_ID" */
    '\x01','W','E','B','_','\x05','S','E','S','S','I','O','N','_','I','D',
/* 0x172ea = "VERR_PATCH_ALREADY_DISABLED" */
    '\x01','P','A','T','C','H','_','\x9b','D','I','S','A','B','L','E','D',
/* 0x172fa = "VERR_PAGE_TABLE_NOT_PRESENT" */
    '\x01','\xdc','T','A','B','L','E','_','\x06','P','R','E','S','E','N','T',
/* 0x1730a = "VERR_FILE_AIO_NOT_SUBMITTED" */
    '\x01','\xab','A','I','O','_','\x06','S','U','B','M','I','T','T','E','D',
/* 0x1731a = "Net host name not found." */
    'N','e','t',' ','h','o','s','t',' ','n','a','m','e',' ','\x08','\x89',
/* 0x1732a = "VERR_PDM_MEDIA_NOT_MOUNTED" */
    '\x01','\x7d','M','E','D','I','A','_','\x06','M','O','U','N','T','E','D',
/* 0x1733a = "Too many RAM ranges." */
    'T','o','o',' ','\xb4','R','A','M',' ','r','a','n','g','e','s','.',
/* 0x1734a = "VERR_PROCESS_RUNNING" */
    '\x01','P','R','O','C','E','S','S','_','R','U','N','N','I','N','G',
/* 0x1735a = "VERR_SUP_VP_BAD_SIZE_OF_HEADERS" */
    '\x01','\x95','\xbd','\x1d','\xf9','_','O','F','_','H','E','A','D','E','R','S',
/* 0x1736a = "VWRN_TRAILING_SPACES" */
    '\xe6','T','R','A','I','L','I','N','G','_','S','P','A','C','E','S',
/* 0x1737a = "VMDK: Invalid image file header." */
    'V','M','D','K',':',' ','\x0c','\x26','\x1f','h','e','a','d','e','r','.',
/* 0x1738a = "VERR_PDM_DEVINS_NO_ATTACH" */
    '\x01','\x7d','D','E','V','I','N','S','_','\x60','A','T','T','A','C','H',
/* 0x1739a = "Unknown file system format." */
    '\xef','\x1f','s','y','s','t','e','m',' ','f','o','r','m','a','t','.',
/* 0x173aa = "Invalid opcode byte(s)." */
    '\x0c','o','p','c','o','d','e',' ','b','y','t','e','(','s',')','.',
/* 0x173ba = "VERR_SEM_LV_DEADLOCK" */
    '\x01','S','E','M','_','L','V','_','D','E','A','D','L','O','C','K',
/* 0x173ca = "VERR_SUPDRV_VTG_BAD_HDR_TOO_MUCH" */
    '\x01','\x90','V','T','G','_','\x1d','H','D','R','_','\x1a','M','U','C','H',
/* 0x173da = "VERR_CR_PKCS7_OSSL_VERIFY_FAILED" */
    '\x01','\x24','\xe5','O','S','S','L','_','V','E','R','I','F','Y','_','\x17',
/* 0x173ea = "The key was decrypted." */
    '\x03','k','e','y',' ','\x11','d','e','c','r','y','p','t','e','d','.',
/* 0x173fa = "VERR_HOSTIF_BLOCKING" */
    '\x01','H','O','S','T','I','F','_','B','L','O','C','K','I','N','G',
/* 0x1740a = "Unknown or invalid GIM provider." */
    '\xef','\xa9','\x8f','G','I','M',' ','p','r','o','v','i','d','e','r','.',
/* 0x1741a = "VERR_PGM_DYNMAP_SETUP_ERROR" */
    '\x01','\x8c','D','Y','N','M','A','P','_','S','E','T','U','P','_','\x1b',
/* 0x1742a = "VERR_ISOMK_IMPORT_INVALID_VOL_DESC_HDR" */
    '\x01','\x22','\x83','\x05','V','O','L','_','D','E','S','C','_','H','D','R',
/* 0x1743a = "VERR_IEM_FIXUP_OUT_OF_MEMORY" */
    '\x01','\x9c','F','I','X','U','P','_','O','U','T','_','O','F','_','\xb6',
/* 0x1744a = "Expected RSA public key." */
    '\xb8','R','S','A',' ','p','u','b','l','i','c',' ','k','e','y','.',
/* 0x1745a = "VERR_VM_DRIVER_LOAD_ERROR" */
    '\x01','\xcd','_','D','R','I','V','E','R','_','L','O','A','D','_','\x1b',
/* 0x1746a = "VINF_IOM_MMIO_UNUSED_00" */
    '\x0e','I','O','M','_','\xd3','_','U','N','U','S','E','D','_','0','0',
/* 0x1747a = "VERR_CR_PKCS7_TOO_MANY_DIGEST_ALGORITHMS" */
    '\x01','\x24','\xe5','\x1a','\xac','\xbe','A','L','G','O','R','I','T','H','M','S',
/* 0x1748a = "The system has too many CPUs." */
    '\x03','s','y','s','t','e','m',' ','\x5e','\x9e','\xb4','C','P','U','s','.',
/* 0x1749a = "SSL connection error." */
    'S','S','L',' ','c','o','n','n','e','c','t','i','o','n',' ','\x85',
/* 0x174aa = "A component value of an ASN." */
    'A',' ','c','o','m','p','o','n','e','n','t',' ','\xf5','\x15','\x87','\xf6',
/* 0x174ba = "VERR_TAR_BASE_256_NOT_SUPPORTED" */
    '\x01','T','A','R','_','B','A','S','E','_','2','5','6','_','\x06','\x82',
/* 0x174ca = "VERR_CR_PKCS7_NO_SIGNER_INFOS" */
    '\x01','\x24','\xe5','\x60','S','I','G','N','E','R','_','I','N','F','O','S',
/* 0x174da = "VERR_NET_IN_PROGRESS" */
    '\x01','N','E','T','_','I','N','_','P','R','O','G','R','E','S','S',
/* 0x174ea = "Too many semaphores." */
    'T','o','o',' ','\xb4','s','e','m','a','p','h','o','r','e','s','.',
/* 0x174fa = "VINF_PDM_PCI_DO_DEFAULT" */
    '\x0e','\x7d','P','C','I','_','D','O','_','D','E','F','A','U','L','T',
/* 0x1750a = "VERR_VM_THREAD_IS_EMT" */
    '\x01','\xcd','_','T','H','R','E','A','D','_','I','S','_','E','M','T',
/* 0x1751a = "VERR_ISOMK_IPE_BOOT_CAT_FILE" */
    '\x01','\x22','\x14','B','O','O','T','_','C','A','T','_','F','I','L','E',
/* 0x1752a = "VERR_PDM_USB_HUB_EXISTS" */
    '\x01','\x7d','U','S','B','_','H','U','B','_','E','X','I','S','T','S',
/* 0x1753a = "Bad DWARF position." */
    '\x9f','D','W','A','R','F',' ','p','o','s','i','t','i','o','n','.',
/* 0x1754a = "VINF_UDP_SERVER_STOP" */
    '\x0e','U','D','P','_','S','E','R','V','E','R','_','S','T','O','P',
/* 0x1755a = "VERR_PDM_NO_APIC_INSTANCE" */
    '\x01','\x7d','\x60','A','P','I','C','_','I','N','S','T','A','N','C','E',
/* 0x1756a = "VERR_TAR_MODE_WITH_TYPE" */
    '\x01','T','A','R','_','M','O','D','E','_','W','I','T','H','_','\xb5',
/* 0x1757a = "VERR_ISOMK_RR_SPILL_FILE_FULL" */
    '\x01','\x22','R','R','_','S','P','I','L','L','_','\xab','F','U','L','L',
/* 0x1758a = "VERR_LDRMACHO_BAD_SECTION_ORDER" */
    '\x01','\xe9','\x1d','S','E','C','T','I','O','N','_','O','R','D','E','R',
/* 0x1759a = "VERR_VMM_HYPER_CR3_MISMATCH" */
    '\x01','V','M','M','_','H','Y','P','E','R','_','C','R','3','_','\x19',
/* 0x175aa = "VERR_TAR_END_OF_FILE" */
    '\x01','T','A','R','_','E','N','D','_','O','F','_','F','I','L','E',
/* 0x175ba = "VERR_ASN1_CURSOR_NOT_AT_END" */
    '\x01','\xa2','C','U','R','S','O','R','_','\x06','A','T','_','E','N','D',
/* 0x175ca = "VERR_SUP_VP_EXE_MISSING_FORCE_INTEGRITY" */
    '\x01','\x95','\xbd','E','X','E','_','\xc4','_','F','O','R','C','E','_','\xf7',
/* 0x175da = "VERR_CR_X509_CPB_BAD_CERT_CTX" */
    '\x01','\x24','\xb7','C','P','B','_','\x1d','C','E','R','T','_','C','T','X',
/* 0x175ea = "Vote for giving up." */
    'V','o','t','e',' ','\x10','g','i','v','i','n','g',' ','u','p','.',
/* 0x175fa = "VERR_DBGF_HYPER_DB_XCPT" */
    '\x01','\xb9','_','H','Y','P','E','R','_','D','B','_','X','C','P','T',
/* 0x1760a = "VERR_PDM_DRVINS_NO_ATTACH" */
    '\x01','\x7d','D','R','V','I','N','S','_','\x60','A','T','T','A','C','H',
/* 0x1761a = "Too many ROM ranges." */
    'T','o','o',' ','\xb4','R','O','M',' ','r','a','n','g','e','s','.',
/* 0x1762a = "VERR_SEM_OUT_OF_TURN" */
    '\x01','S','E','M','_','O','U','T','_','O','F','_','T','U','R','N',
/* 0x1763a = "VERR_SUPDRV_VTG_BAD_PROBE_LOC" */
    '\x01','\x90','V','T','G','_','\x1d','P','R','O','B','E','_','L','O','C',
/* 0x1764a = "VERR_CALLBACK_RETURN" */
    '\x01','C','A','L','L','B','A','C','K','_','R','E','T','U','R','N',
/* 0x1765a = "VERR_TRAILING_SPACES" */
    '\x01','T','R','A','I','L','I','N','G','_','S','P','A','C','E','S',
/* 0x1766a = "VERR_MM_RAM_CONFLICT" */
    '\x01','M','M','_','R','A','M','_','C','O','N','F','L','I','C','T',
/* 0x1767a = "VERR_VMM_SWITCHER_IPE_1" */
    '\x01','V','M','M','_','S','W','I','T','C','H','E','R','_','\x14','1',
/* 0x1768a = "Internal processing error in the page allocator." */
    '\x07','\x04','\x09','\x0f','\x02','\xcc','a','l','l','o','c','a','t','o','r','.',
/* 0x1769a = "Generic not found warning." */
    '\xa6','\x08','f','o','u','n','d',' ','w','a','r','n','i','n','g','.',
/* 0x176aa = "VERR_TIMER_SUSPENDED" */
    '\x01','T','I','M','E','R','_','S','U','S','P','E','N','D','E','D',
/* 0x176ba = "VERR_CPUM_RAISE_GP_0" */
    '\x01','C','P','U','M','_','R','A','I','S','E','_','G','P','_','0',
/* 0x176ca = "VERR_VMX_INVALID_VMCS_LAUNCH_STATE" */
    '\x01','\xe2','\x05','V','M','C','S','_','L','A','U','N','C','H','_','\xf1',
/* 0x176da = "VINF_HM_PENDING_XCPT" */
    '\x0e','H','M','_','P','E','N','D','I','N','G','_','X','C','P','T',
/* 0x176ea = "VERR_SUP_VP_SYSTEM32_PATH" */
    '\x01','\x95','\xbd','S','Y','S','T','E','M','3','2','_','P','A','T','H',
/* 0x176fa = "The XAR table of content digest doesn't match." */
    '\x03','X','A','R',' ','\xb1','\x15','\xf0','\xd7','\xc7','m','a','t','c','h','.',
/* 0x1770a = "VERR_VRDP_PROTOCOL_ERROR" */
    '\x01','V','R','D','P','_','P','R','O','T','O','C','O','L','_','\x1b',
/* 0x1771a = "Unbalanced tree." */
    'U','n','b','a','l','a','n','c','e','d',' ','t','r','e','e','.',
/* 0x1772a = "VERR_XAR_WRONG_MAGIC" */
    '\x01','X','A','R','_','W','R','O','N','G','_','M','A','G','I','C',
/* 0x1773a = "VERR_GIM_HYPERCALL_FAILED" */
    '\x01','G','I','M','_','H','Y','P','E','R','C','A','L','L','_','\x17',
/* 0x1774a = "VERR_DBGF_NO_TRACE_BUFFER" */
    '\x01','\xb9','_','\x60','T','R','A','C','E','_','B','U','F','F','E','R',
/* 0x1775a = "VERR_HGCM_SERVICE_NOT_FOUND" */
    '\x01','H','G','C','M','_','S','E','R','V','I','C','E','_','\x06','\x2a',
/* 0x1776a = "VERR_XAR_BAD_FILE_TIMESTAMP" */
    '\x01','X','A','R','_','\x1d','\xab','T','I','M','E','S','T','A','M','P',
/* 0x1777a = "VERR_URI_INVALID_ESCAPE_SEQ" */
    '\x01','U','R','I','_','\x05','E','S','C','A','P','E','_','S','E','Q',
/* 0x1778a = "VINF_EM_TRIPLE_FAULT" */
    '\x0e','E','M','_','T','R','I','P','L','E','_','F','A','U','L','T',
/* 0x1779a = "VERR_TM_GIP_REQUIRED" */
    '\x01','T','M','_','G','I','P','_','R','E','Q','U','I','R','E','D',
/* 0x177aa = "VERR_CR_RANDOM_SETUP_FAILED" */
    '\x01','\x24','R','A','N','D','O','M','_','S','E','T','U','P','_','\x17',
/* 0x177ba = "VERR_XAR_MISSING_SIZE_ELEMENT" */
    '\x01','X','A','R','_','\xc4','_','\xf9','_','E','L','E','M','E','N','T',
/* 0x177ca = "VERR_SUPDRV_VTG_STRTAB_OFF" */
    '\x01','\x90','V','T','G','_','S','T','R','T','A','B','_','O','F','F',
/* 0x177da = "VERR_DVM_MAP_NO_VOLUME" */
    '\x01','D','V','M','_','M','A','P','_','\x60','V','O','L','U','M','E',
/* 0x177ea = "VERR_VMX_NOT_IN_VMX_ROOT_MODE" */
    '\x01','\xe2','\x06','I','N','_','\xe2','R','O','O','T','_','M','O','D','E',
/* 0x177fa = "Local file header corrupt." */
    'L','o','c','a','l',' ','\x1f','\xb3','c','o','r','r','u','p','t','.',
/* 0x1780a = "Failed to map a memory object." */
    '\x8b','\x0a','m','a','p',' ','a',' ','\x86','o','b','j','e','c','t','.',
/* 0x1781a = "VINF_IOM_MMIO_UNUSED_FF" */
    '\x0e','I','O','M','_','\xd3','_','U','N','U','S','E','D','_','F','F',
/* 0x1782a = "VERR_SSM_LOADED_TOO_LITTLE" */
    '\x01','\xb0','L','O','A','D','E','D','_','\x1a','L','I','T','T','L','E',
/* 0x1783a = "VERR_SUP_VP_IMAGE_FILE_OPEN_ERROR" */
    '\x01','\x95','\xbd','I','M','A','G','E','_','\xab','O','P','E','N','_','\x1b',
/* 0x1784a = "Generic no change info." */
    '\xa6','n','o',' ','c','h','a','n','g','e',' ','i','n','f','o','.',
/* 0x1785a = "VERR_SSM_GCPTR_OVERFLOW" */
    '\x01','\xb0','G','C','P','T','R','_','O','V','E','R','F','L','O','W',
/* 0x1786a = "Internal processing error #1 in the DBGF core code." */
    '\x07','\x04','\x09','#','1',' ','\x0f','\x02','\xb9',' ','c','o','r','e',' ','\x84',
/* 0x1787a = "VERR_PDM_NO_DMAC_INSTANCE" */
    '\x01','\x7d','\x60','D','M','A','C','_','I','N','S','T','A','N','C','E',
/* 0x1788a = "VERR_SUP_VP_TOO_MANY_DLLS_LOADED" */
    '\x01','\x95','\xbd','\x1a','\xac','D','L','L','S','_','L','O','A','D','E','D',
/* 0x1789a = "The poll set is full." */
    '\x03','p','o','l','l',' ','s','e','t',' ','\x0b','f','u','l','l','.',
/* 0x178aa = "VERR_DIS_TOO_LONG_INSTR" */
    '\x01','D','I','S','_','\x1a','L','O','N','G','_','I','N','S','T','R',
/* 0x178ba = "VINF_VMM_CALL_TRACER" */
    '\x0e','V','M','M','_','C','A','L','L','_','T','R','A','C','E','R',
/* 0x178ca = "VERR_SUP_VP_THREAD_NOT_ALONE" */
    '\x01','\x95','\xbd','T','H','R','E','A','D','_','\x06','A','L','O','N','E',
/* 0x178da = "VERR_FLOAT_UNDERFLOW" */
    '\x01','F','L','O','A','T','_','U','N','D','E','R','F','L','O','W',
/* 0x178ea = "VERR_CR_PKIX_GENERIC_ERROR" */
    '\x01','\x24','P','K','I','X','_','G','E','N','E','R','I','C','_','\x1b',
/* 0x178fa = "VERR_IEM_LABEL_OUT_OF_MEMORY" */
    '\x01','\x9c','L','A','B','E','L','_','O','U','T','_','O','F','_','\xb6',
/* 0x1790a = "VERR_RESOURCE_IN_USE" */
    '\x01','R','E','S','O','U','R','C','E','_','I','N','_','U','S','E',
/* 0x1791a = "VERR_GENERAL_FAILURE" */
    '\x01','G','E','N','E','R','A','L','_','F','A','I','L','U','R','E',
/* 0x1792a = "VERR_SUPDRV_TRACER_NOT_OPENED" */
    '\x01','\x90','T','R','A','C','E','R','_','\x06','O','P','E','N','E','D',
/* 0x1793a = "VERR_CR_PKCS7_SIGNER_INFO_VERSION" */
    '\x01','\x24','\xe5','S','I','G','N','E','R','_','I','N','F','O','_','\xbc',
/* 0x1794a = "VERR_SSM_INTEGRITY_REC_TERM_CRC" */
    '\x01','\xb0','\xf7','_','R','E','C','_','T','E','R','M','_','C','R','C',
/* 0x1795a = "VERR_PDM_CRITSECTRW_IPE" */
    '\x01','\x7d','C','R','I','T','S','E','C','T','R','W','_','I','P','E',
/* 0x1796a = "VERR_PDM_THREAD_INVALID_CALLER" */
    '\x01','\x7d','T','H','R','E','A','D','_','\x05','C','A','L','L','E','R',
/* 0x1797a = "VERR_ASN1_TOO_DEEPLY_NESTED" */
    '\x01','\xa2','\x1a','D','E','E','P','L','Y','_','N','E','S','T','E','D',
/* 0x1798a = "VERR_SUPDRV_TRACER_ALREADY_OPENED" */
    '\x01','\x90','T','R','A','C','E','R','_','\x9b','O','P','E','N','E','D',
/* 0x1799a = "Comment string is too long." */
    'C','o','m','m','e','n','t',' ','\xf2','\x0b','\x9e','l','o','n','g','.',
/* 0x179aa = "VERR_LDR_NO_IMAGE_UUID" */
    '\x01','L','D','R','_','\x60','I','M','A','G','E','_','U','U','I','D',
/* 0x179ba = "VERR_CR_X509_NO_TRUST_ANCHOR" */
    '\x01','\x24','\xb7','\x60','T','R','U','S','T','_','A','N','C','H','O','R',
/* 0x179ca = "VERR_EXCL_SEM_ALREADY_OWNED" */
    '\x01','E','X','C','L','_','S','E','M','_','\x9b','O','W','N','E','D',
/* 0x179da = "VERR_ISOFS_BAD_LVD_DOMAIN_ID" */
    '\x01','\x97','\x1d','L','V','D','_','D','O','M','A','I','N','_','I','D',
/* 0x179ea = "VERR_PATCH_NO_CONFLICT" */
    '\x01','P','A','T','C','H','_','\x60','C','O','N','F','L','I','C','T',
/* 0x179fa = "The table of content (TOC) is too big." */
    '\x03','\xb1','\x15','\xf0','(','T','O','C',')',' ','\x0b','\x9e','b','i','g','.',
/* 0x17a0a = "VERR_ALLOCATION_TOO_BIG" */
    '\x01','A','L','L','O','C','A','T','I','O','N','_','\x1a','B','I','G',
/* 0x17a1a = "Too many open files." */
    'T','o','o',' ','\xb4','o','p','e','n',' ','f','i','l','e','s','.',
/* 0x17a2a = "VERR_CR_PKCS7_DIGEST_PARAMS_NOT_IMPL" */
    '\x01','\x24','\xe5','\xbe','P','A','R','A','M','S','_','\x06','I','M','P','L',
/* 0x17a3a = "Image Verification Failure:." */
    'I','m','a','g','e',' ','\x0d','F','a','i','l','u','r','e',':','.',
/* 0x17a4a = "VERR_SSM_SKIP_BACKWARDS" */
    '\x01','\xb0','S','K','I','P','_','B','A','C','K','W','A','R','D','S',
/* 0x17a5a = "VERR_DIS_GEN_FAILURE" */
    '\x01','D','I','S','_','G','E','N','_','F','A','I','L','U','R','E',
/* 0x17a6a = "VERR_HGCM_INVALID_CLIENT_ID" */
    '\x01','H','G','C','M','_','\x05','C','L','I','E','N','T','_','I','D',
/* 0x17a7a = "VERR_TAR_ZERO_HEADER" */
    '\x01','T','A','R','_','Z','E','R','O','_','H','E','A','D','E','R',
/* 0x17a8a = "Image Verification Failure: Invalid section count." */
    'I','m','a','g','e',' ','\x0d','\x12','\x0c','\xdb','c','o','u','n','t','.',
/* 0x17a9a = "VERR_CR_OPENSSL_VERSION_TOO_OLD" */
    '\x01','\x24','O','P','E','N','S','S','L','_','\xbc','_','\x1a','O','L','D',
/* 0x17aaa = "Receive timeout." */
    'R','e','c','e','i','v','e',' ','t','i','m','e','o','u','t','.',
/* 0x17aba = "VERR_PRIVILEGE_NOT_HELD" */
    '\x01','P','R','I','V','I','L','E','G','E','_','\x06','H','E','L','D',
/* 0x17aca = "VINF_SSM_LIVE_SUSPENDED" */
    '\x0e','\xb0','L','I','V','E','_','S','U','S','P','E','N','D','E','D',
/* 0x17ada = "VERR_ASN1_INVALID_PRINTABLE_STRING_ENCODING" */
    '\x01','\xa2','\x05','P','R','I','N','T','A','B','L','E','_','\xd5','_','\xc6',
/* 0x17aea = "VINF_CALLBACK_RETURN" */
    '\x0e','C','A','L','L','B','A','C','K','_','R','E','T','U','R','N',
/* 0x17afa = "VERR_IEM_VAR_EXHAUSTED" */
    '\x01','\x9c','V','A','R','_','E','X','H','A','U','S','T','E','D',
/* 0x17b09 = "VERR_ISOFS_MULTIPLE_LVDS" */
    '\x01','\x97','M','U','L','T','I','P','L','E','_','L','V','D','S',
/* 0x17b18 = "VERR_NOT_DATA_SELECTOR" */
    '\x01','\x06','D','A','T','A','_','S','E','L','E','C','T','O','R',
/* 0x17b27 = "VERR_TAR_EMPTY_NAME" */
    '\x01','T','A','R','_','E','M','P','T','Y','_','N','A','M','E',
/* 0x17b36 = "VERR_DBGC_PARSE_CONVERSION_FAILED" */
    '\x01','\xfc','\xe4','C','O','N','V','E','R','S','I','O','N','_','\x17',
/* 0x17b45 = "VERR_CR_X509_CPV_NOT_CA_CERT" */
    '\x01','\x24','\xb7','C','P','V','_','\x06','C','A','_','C','E','R','T',
/* 0x17b54 = "The digest algorithm is not known to us." */
    '\x03','\xd7','\xd4','\x0b','\x08','k','n','o','w','n',' ','\x0a','u','s','.',
/* 0x17b63 = "VERR_SUP_VP_BAD_SECTION_RVA" */
    '\x01','\x95','\xbd','\x1d','S','E','C','T','I','O','N','_','R','V','A',
/* 0x17b72 = "VERR_SUPDRV_VTG_BAD_PROVIDER" */
    '\x01','\x90','V','T','G','_','\x1d','P','R','O','V','I','D','E','R',
/* 0x17b81 = "VERR_ISOMK_IMPORT_UDF_DIR_TOO_BIG" */
    '\x01','\x22','\x83','U','D','F','_','D','I','R','_','\x1a','B','I','G',
/* 0x17b90 = "VERR_CR_X509_CPV_NOT_V3_CERT" */
    '\x01','\x24','\xb7','C','P','V','_','\x06','V','3','_','C','E','R','T',
/* 0x17b9f = "VERR_TM_TSC_ALREADY_PAUSED" */
    '\x01','T','M','_','T','S','C','_','\x9b','P','A','U','S','E','D',
/* 0x17bae = "VERR_PGM_SAVED_ROM_PAGE_NOT_FOUND" */
    '\x01','\x8c','S','A','V','E','D','_','R','O','M','_','\xdc','\x06','\x2a',
/* 0x17bbd = "Already loaded." */
    'A','l','r','e','a','d','y',' ','l','o','a','d','e','d','.',
/* 0x17bcc = "VERR_NOT_CODE_SELECTOR" */
    '\x01','\x06','C','O','D','E','_','S','E','L','E','C','T','O','R',
/* 0x17bdb = "VERR_SUPDRV_VTG_BAD_HDR_MISC" */
    '\x01','\x90','V','T','G','_','\x1d','H','D','R','_','M','I','S','C',
/* 0x17bea = "VERR_FILE_AIO_COMPLETED" */
    '\x01','\xab','A','I','O','_','C','O','M','P','L','E','T','E','D',
/* 0x17bf9 = "PML4 entry not present." */
    'P','M','L','4',' ','\xc8','\x08','p','r','e','s','e','n','t','.',
/* 0x17c08 = "VERR_DBGC_PARSE_NOT_IMPLEMENTED" */
    '\x01','\xfc','\xe4','\x06','I','M','P','L','E','M','E','N','T','E','D',
/* 0x17c17 = "Raw mode doesn't support SMP." */
    'R','a','w',' ','m','o','d','e',' ','\xc7','\xce','S','M','P','.',
/* 0x17c26 = "VHD: Invalid image file header." */
    'V','H','D',':',' ','\x0c','\x26','\x1f','h','e','a','d','e','r','.',
/* 0x17c35 = "VERR_VSCSI_LUN_BUSY" */
    '\x01','V','S','C','S','I','_','L','U','N','_','B','U','S','Y',
/* 0x17c44 = "VERR_LDRMACHO_UNKNOWN_LOAD_COMMAND" */
    '\x01','\xe9','\x91','L','O','A','D','_','C','O','M','M','A','N','D',
/* 0x17c53 = "VERR_JSON_MALFORMED" */
    '\x01','J','S','O','N','_','M','A','L','F','O','R','M','E','D',
/* 0x17c62 = "VERR_VFS_BOGUS_FORMAT" */
    '\x01','\x8d','_','B','O','G','U','S','_','F','O','R','M','A','T',
/* 0x17c71 = "VERR_IPC_SEND_MAP_FAILED" */
    '\x01','I','P','C','_','S','E','N','D','_','M','A','P','_','\x17',
/* 0x17c80 = "DMG: Invalid image file header." */
    'D','M','G',':',' ','\x0c','\x26','\x1f','h','e','a','d','e','r','.',
/* 0x17c8f = "Bucket already exists." */
    'B','u','c','k','e','t',' ','\x7f','e','x','i','s','t','s','.',
/* 0x17c9e = "VERR_VMX_MSR_LOCKING_FAILED" */
    '\x01','\xe2','M','S','R','_','L','O','C','K','I','N','G','_','\x17',
/* 0x17cad = "VERR_NET_PROTOCOL_ERROR" */
    '\x01','N','E','T','_','P','R','O','T','O','C','O','L','_','\x1b',
/* 0x17cbc = "VERR_SIGNAL_REFUSED" */
    '\x01','S','I','G','N','A','L','_','R','E','F','U','S','E','D',
/* 0x17ccb = "Invalid host bit mask." */
    '\x0c','h','o','s','t',' ','b','i','t',' ','m','a','s','k','.',
/* 0x17cda = "The operation has already been cancelled." */
    '\x03','\x96','\x5e','\x7f','\xcb','c','a','n','c','e','l','l','e','d','.',
/* 0x17ce9 = "The specified data unit already exist." */
    '\x03','\x18','\x9d','u','n','i','t',' ','\x7f','e','x','i','s','t','.',
/* 0x17cf8 = "VERR_PDM_NO_RTC_INSTANCE" */
    '\x01','\x7d','\x60','R','T','C','_','I','N','S','T','A','N','C','E',
/* 0x17d07 = "VERR_NET_PROTOCOL_TYPE" */
    '\x01','N','E','T','_','P','R','O','T','O','C','O','L','_','\xb5',
/* 0x17d16 = "VERR_SUP_VP_UNKOWN_MEM_TYPE" */
    '\x01','\x95','\xbd','U','N','K','O','W','N','_','M','E','M','_','\xb5',
/* 0x17d25 = "VERR_EM_INTERPRETER" */
    '\x01','E','M','_','I','N','T','E','R','P','R','E','T','E','R',
/* 0x17d34 = "The specified thread is dead." */
    '\x03','\x18','t','h','r','e','a','d',' ','\x0b','d','e','a','d','.',
/* 0x17d43 = "VERR_PGM_PAE_PDPE_RSVD" */
    '\x01','\x8c','P','A','E','_','P','D','P','E','_','R','S','V','D',
/* 0x17d52 = "VERR_XAR_BAD_SIZE_ELEMENT" */
    '\x01','X','A','R','_','\x1d','\xf9','_','E','L','E','M','E','N','T',
/* 0x17d61 = "VMM long jump error." */
    'V','M','M',' ','l','o','n','g',' ','j','u','m','p',' ','\x85',
/* 0x17d70 = "VERR_COM_UNEXPECTED" */
    '\x01','C','O','M','_','U','N','E','X','P','E','C','T','E','D',
/* 0x17d7f = "VERR_CR_RSA_GENERIC_ERROR" */
    '\x01','\x24','R','S','A','_','G','E','N','E','R','I','C','_','\x1b',
/* 0x17d8e = "Recompiler: Out of memory for labels." */
    '\x13','O','u','t',' ','\x15','\x86','\x10','l','a','b','e','l','s','.',
/* 0x17d9d = "Unexpected number of valid paths." */
    '\x94','\xfb','\x15','v','a','l','i','d',' ','p','a','t','h','s','.',
/* 0x17dac = "VWRN_FLOAT_OVERFLOW" */
    '\xe6','F','L','O','A','T','_','O','V','E','R','F','L','O','W',
/* 0x17dbb = "The specified path was not absolute (hardening)." */
    '\x03','\x18','\xd0','\x11','\x08','a','b','s','o','l','u','t','e',' ','\xae',
/* 0x17dca = "VERR_VMX_MSR_VMX_DISABLED" */
    '\x01','\xe2','M','S','R','_','\xe2','D','I','S','A','B','L','E','D',
/* 0x17dd9 = "No read callback." */
    '\xdf','r','e','a','d',' ','c','a','l','l','b','a','c','k','.',
/* 0x17de8 = "VERR_VD_VMDK_VALUE_NOT_FOUND" */
    '\x01','\xff','V','M','D','K','_','V','A','L','U','E','_','\x06','\x2a',
/* 0x17df7 = "VERR_LDR_NOT_FORWARDER" */
    '\x01','L','D','R','_','\x06','F','O','R','W','A','R','D','E','R',
/* 0x17e06 = "VERR_TAR_UNSUPPORTED_GNU_HDR_TYPE" */
    '\x01','T','A','R','_','\x1c','G','N','U','_','H','D','R','_','\xb5',
/* 0x17e15 = "VWRN_TRAILING_CHARS" */
    '\xe6','T','R','A','I','L','I','N','G','_','C','H','A','R','S',
/* 0x17e24 = "VERR_INVALID_EXE_SIGNATURE" */
    '\x01','\x05','E','X','E','_','S','I','G','N','A','T','U','R','E',
/* 0x17e33 = "VERR_XAR_TOC_UTF8_ENCODING" */
    '\x01','X','A','R','_','T','O','C','_','U','T','F','8','_','\xc6',
/* 0x17e42 = "Unimplemented ASN." */
    'U','n','i','m','p','l','e','m','e','n','t','e','d',' ','\xf6',
/* 0x17e51 = "VERR_NET_NOT_CONNECTED" */
    '\x01','N','E','T','_','\x06','C','O','N','N','E','C','T','E','D',
/* 0x17e60 = "Bad VTG header - to high value." */
    '\x9f','V','T','G',' ','\xb3','-',' ','\x0a','h','i','g','h',' ','\xe8',
/* 0x17e6f = "Unknown glob variable." */
    '\xef','g','l','o','b',' ','v','a','r','i','a','b','l','e','.',
/* 0x17e7e = "VERR_INSTALLATION_FAILED" */
    '\x01','I','N','S','T','A','L','L','A','T','I','O','N','_','\x17',
/* 0x17e8d = "VERR_LDR_BAD_FORWARDER" */
    '\x01','L','D','R','_','\x1d','F','O','R','W','A','R','D','E','R',
/* 0x17e9c = "VERR_XAR_TOC_TOO_SMALL" */
    '\x01','X','A','R','_','T','O','C','_','\x1a','S','M','A','L','L',
/* 0x17eab = "VERR_GETOPT_UNKNOWN_OPTION" */
    '\x01','G','E','T','O','P','T','_','\x91','O','P','T','I','O','N',
/* 0x17eba = "Send cancelled." */
    'S','e','n','d',' ','c','a','n','c','e','l','l','e','d','.',
/* 0x17ec9 = "Patch disabled." */
    'P','a','t','c','h',' ','d','i','s','a','b','l','e','d','.',
/* 0x17ed8 = "VINF_GETOPT_NOT_OPTION" */
    '\x0e','G','E','T','O','P','T','_','\x06','O','P','T','I','O','N',
/* 0x17ee7 = "VERR_PDM_GEOMETRY_NOT_SET" */
    '\x01','\x7d','G','E','O','M','E','T','R','Y','_','\x06','S','E','T',
/* 0x17ef6 = "VERR_TAR_NAME_TOO_LONG" */
    '\x01','T','A','R','_','N','A','M','E','_','\x1a','L','O','N','G',
/* 0x17f05 = "Bad VTG header - offset." */
    '\x9f','V','T','G',' ','\xb3','-',' ','o','f','f','s','e','t','.',
/* 0x17f14 = "Reason for leaving RZ: MMIO write." */
    '\x93','\x10','\x81','R','Z',':',' ','\xd3',' ','w','r','i','t','e','.',
/* 0x17f23 = "VERR_VMM_LONG_JMP_ERROR" */
    '\x01','V','M','M','_','L','O','N','G','_','J','M','P','_','\x1b',
/* 0x17f32 = "VERR_FLOAT_OVERFLOW" */
    '\x01','F','L','O','A','T','_','O','V','E','R','F','L','O','W',
/* 0x17f41 = "The trace log version is not supported." */
    '\x03','t','r','a','c','e',' ','l','o','g',' ','\xcf','\x0b','\x08','\xa4',
/* 0x17f50 = "VERR_SSM_LOAD_CONFIG_MISMATCH" */
    '\x01','\xb0','L','O','A','D','_','C','O','N','F','I','G','_','\x19',
/* 0x17f5f = "VERR_WEB_UNSUPPORTED_INTERFACE" */
    '\x01','W','E','B','_','\x1c','I','N','T','E','R','F','A','C','E',
/* 0x17f6e = "VINF_IOM_R3_MMIO_WRITE" */
    '\x0e','I','O','M','_','R','3','_','\xd3','_','W','R','I','T','E',
/* 0x17f7d = "Unsupported data unit version." */
    '\x98','\x9d','u','n','i','t',' ','v','e','r','s','i','o','n','.',
/* 0x17f8c = "Access denied error." */
    'A','c','c','e','s','s',' ','d','e','n','i','e','d',' ','\x85',
/* 0x17f9b = "VERR_PGM_PHYS_PAGE_GET_IPE" */
    '\x01','\x8c','P','H','Y','S','_','\xdc','G','E','T','_','I','P','E',
/* 0x17faa = "VERR_HGCM_TOO_MANY_CLIENTS" */
    '\x01','H','G','C','M','_','\x1a','\xac','C','L','I','E','N','T','S',
/* 0x17fb9 = "VERR_VFS_BOGUS_OFFSET" */
    '\x01','\x8d','_','B','O','G','U','S','_','O','F','F','S','E','T',
/* 0x17fc8 = "Invalid VMXON pointer." */
    '\x0c','V','M','X','O','N',' ','p','o','i','n','t','e','r','.',
/* 0x17fd7 = "Process Verification Failure: Bad section raw data size." */
    '\x1e','\x0d','\x12','\x9f','\xdb','r','a','w',' ','\x9d','s','i','z','e','.',
/* 0x17fe6 = "VERR_COM_INVALID_SESSION_STATE" */
    '\x01','C','O','M','_','\x05','S','E','S','S','I','O','N','_','\xf1',
/* 0x17ff5 = "VERR_CFGM_NOT_PASSWORD" */
    '\x01','C','F','G','M','_','\x06','P','A','S','S','W','O','R','D',
/* 0x18004 = "Patch was removed." */
    'P','a','t','c','h',' ','\x11','r','e','m','o','v','e','d','.',
/* 0x18013 = "VERR_PATCH_ALREADY_ENABLED" */
    '\x01','P','A','T','C','H','_','\x9b','E','N','A','B','L','E','D',
/* 0x18022 = "Syntax error - function not found." */
    '\xfa','\x09','-',' ','f','u','n','c','t','i','o','n',' ','\x08','\x89',
/* 0x18031 = "VERR_ISOFS_BAD_TAG_CHECKSUM" */
    '\x01','\x97','\x1d','T','A','G','_','C','H','E','C','K','S','U','M',
/* 0x18040 = "VERR_LDRELF_MACHINE" */
    '\x01','L','D','R','E','L','F','_','M','A','C','H','I','N','E',
/* 0x1804f = "VERR_ASN1_INVALID_VIDEOTEX_STRING_ENCODING" */
    '\x01','\xa2','\x05','V','I','D','E','O','T','E','X','_','\xd5','_','\xc6',
/* 0x1805e = "VERR_CR_X509_CPV_ISSUER_MISMATCH" */
    '\x01','\x24','\xb7','C','P','V','_','I','S','S','U','E','R','_','\x19',
/* 0x1806d = "VERR_FILENAME_TOO_LONG" */
    '\x01','F','I','L','E','N','A','M','E','_','\x1a','L','O','N','G',
/* 0x1807c = "VERR_VD_GEOMETRY_NOT_SET" */
    '\x01','\xff','G','E','O','M','E','T','R','Y','_','\x06','S','E','T',
/* 0x1808b = "VERR_VD_ISCSI_INVALID_HEADER" */
    '\x01','\xff','I','S','C','S','I','_','\x05','H','E','A','D','E','R',
/* 0x1809a = "VERR_LDR_IMAGE_HASH" */
    '\x01','L','D','R','_','I','M','A','G','E','_','H','A','S','H',
/* 0x180a9 = "VERR_SIGNAL_PENDING" */
    '\x01','S','I','G','N','A','L','_','P','E','N','D','I','N','G',
/* 0x180b8 = "VERR_IOM_MMIO_RANGE_NOT_FOUND" */
    '\x01','I','O','M','_','\xd3','_','R','A','N','G','E','_','\x06','\x2a',
/* 0x180c7 = "VERR_CR_PKCS7_NO_DIGEST_ALGORITHMS" */
    '\x01','\x24','\xe5','\x60','\xbe','A','L','G','O','R','I','T','H','M','S',
/* 0x180d6 = "VERR_LDRMACHO_UNSUPPORTED_INIT_SECTION" */
    '\x01','\xe9','\x1c','I','N','I','T','_','S','E','C','T','I','O','N',
/* 0x180e5 = "Raw: Invalid image file header." */
    'R','a','w',':',' ','\x0c','\x26','\x1f','h','e','a','d','e','r','.',
/* 0x180f4 = "Invalid guest LDT selector." */
    '\x0c','\xbb','L','D','T',' ','s','e','l','e','c','t','o','r','.',
/* 0x18103 = "VERR_PGM_NOT_USED_IN_MODE" */
    '\x01','\x8c','\x06','U','S','E','D','_','I','N','_','M','O','D','E',
/* 0x18112 = "The support driver is not installed." */
    '\x03','\xce','\xc5','\x0b','\x08','i','n','s','t','a','l','l','e','d','.',
/* 0x18121 = "VERR_XAR_TOC_XML_PARSE_ERROR" */
    '\x01','X','A','R','_','T','O','C','_','X','M','L','_','\xe4','\x1b',
/* 0x18130 = "VDI: Invalid image file header." */
    'V','D','I',':',' ','\x0c','\x26','\x1f','h','e','a','d','e','r','.',
/* 0x1813f = "VERR_GSTCTL_GUEST_ERROR" */
    '\x01','G','S','T','C','T','L','_','G','U','E','S','T','_','\x1b',
/* 0x1814e = "VERR_THREAD_IS_DEAD" */
    '\x01','T','H','R','E','A','D','_','I','S','_','D','E','A','D',
/* 0x1815d = "VERR_MM_BAD_TRAP_TYPE_IPE" */
    '\x01','M','M','_','\x1d','T','R','A','P','_','\xb5','_','I','P','E',
/* 0x1816c = "Invalid dotted string." */
    '\x0c','d','o','t','t','e','d',' ','s','t','r','i','n','g','.',
/* 0x1817b = "VERR_LOG_REVISION_MISMATCH" */
    '\x01','L','O','G','_','R','E','V','I','S','I','O','N','_','\x19',
/* 0x1818a = "VERR_MEDIA_NOT_PRESENT" */
    '\x01','M','E','D','I','A','_','\x06','P','R','E','S','E','N','T',
/* 0x18199 = "VERR_CR_KEY_ENCRYPTED" */
    '\x01','\x24','K','E','Y','_','E','N','C','R','Y','P','T','E','D',
/* 0x181a8 = "VERR_IS_A_DIRECTORY" */
    '\x01','I','S','_','A','_','D','I','R','E','C','T','O','R','Y',
/* 0x181b7 = "VERR_GETOPT_INDEX_MISSING" */
    '\x01','G','E','T','O','P','T','_','I','N','D','E','X','_','\xc4',
/* 0x181c6 = "VERR_IEM_INVALID_ADDRESS_MODE" */
    '\x01','\x9c','\x05','A','D','D','R','E','S','S','_','M','O','D','E',
/* 0x181d5 = "VERR_VM_FATAL_WAIT_ERROR" */
    '\x01','\xcd','_','F','A','T','A','L','_','W','A','I','T','_','\x1b',
/* 0x181e4 = "VERR_CR_X509_NAME_EMPTY_STRING" */
    '\x01','\x24','\xb7','N','A','M','E','_','E','M','P','T','Y','_','\xd5',
/* 0x181f3 = "Repairing the image is not supported." */
    'R','e','p','a','i','r','i','n','g',' ','\x02','\x26','\x0b','\x08','\xa4',
/* 0x18202 = "VERR_TOO_MANY_CPUID_LEAVES" */
    '\x01','\x1a','\xac','C','P','U','I','D','_','L','E','A','V','E','S',
/* 0x18211 = "VERR_CR_KEY_FORMAT_NOT_SUPPORTED" */
    '\x01','\x24','K','E','Y','_','F','O','R','M','A','T','_','\x06','\x82',
/* 0x18220 = "The OS was not detected." */
    '\x03','O','S',' ','\x11','\x08','d','e','t','e','c','t','e','d','.',
/* 0x1822f = "VERR_VMX_MSR_VMX_ENABLE_FAILED" */
    '\x01','\xe2','M','S','R','_','\xe2','E','N','A','B','L','E','_','\x17',
/* 0x1823e = "VINF_DBGF_BP_ALREADY_DISABLED" */
    '\x0e','\xb9','_','B','P','_','\x9b','D','I','S','A','B','L','E','D',
/* 0x1824d = "VERR_PGM_INVALID_LARGE_PAGE_RANGE" */
    '\x01','\x8c','\x05','L','A','R','G','E','_','\xdc','R','A','N','G','E',
/* 0x1825c = "VERR_ASN1_INVALID_DATA_POINTER" */
    '\x01','\xa2','\x05','D','A','T','A','_','P','O','I','N','T','E','R',
/* 0x1826b = "VERR_SEEK_ON_DEVICE" */
    '\x01','S','E','E','K','_','O','N','_','D','E','V','I','C','E',
/* 0x1827a = "VERR_TAR_NOT_USTAR_V00" */
    '\x01','T','A','R','_','\x06','U','S','T','A','R','_','V','0','0',
/* 0x18289 = "Bad descriptor tag checksum." */
    '\x9f','\xe3','t','a','g',' ','c','h','e','c','k','s','u','m','.',
/* 0x18298 = "VINF_EM_DBG_STEPPED" */
    '\x0e','E','M','_','D','B','G','_','S','T','E','P','P','E','D',
/* 0x182a7 = "VERR_CPUM_DB_CPU_NOT_FOUND" */
    '\x01','C','P','U','M','_','D','B','_','C','P','U','_','\x06','\x2a',
/* 0x182b6 = "Recompiler: Out of memory for fixups." */
    '\x13','O','u','t',' ','\x15','\x86','\x10','f','i','x','u','p','s','.',
/* 0x182c5 = "VERR_ISOFS_FSD_UNSUPPORTED_CHAR_SET" */
    '\x01','\x97','F','S','D','_','\x1c','C','H','A','R','_','S','E','T',
/* 0x182d4 = "VERR_IPC_PROCESS_NOT_FOUND" */
    '\x01','I','P','C','_','P','R','O','C','E','S','S','_','\x06','\x2a',
/* 0x182e3 = "VERR_PGM_PHYS_MMIO_EX_IPE" */
    '\x01','\x8c','P','H','Y','S','_','\xd3','_','E','X','_','I','P','E',
/* 0x182f2 = "Not MMIO2 page." */
    'N','o','t',' ','M','M','I','O','2',' ','p','a','g','e','.',
/* 0x18301 = "VERR_CR_PKCS7_NOT_SIGNED_DATA" */
    '\x01','\x24','\xe5','\x06','S','I','G','N','E','D','_','D','A','T','A',
/* 0x18310 = "VERR_SELM_GDT_TOO_FULL" */
    '\x01','S','E','L','M','_','G','D','T','_','\x1a','F','U','L','L',
/* 0x1831f = "Wrong JSON type for string value." */
    'W','r','o','n','g',' ','J','S','O','N',' ','\xf3','\x10','\xf2','\xe8',
/* 0x1832e = "VERR_CR_DIGEST_OSSL_DIGEST_INIT_ERROR" */
    '\x01','\x24','\xbe','O','S','S','L','_','\xbe','I','N','I','T','_','\x1b',
/* 0x1833d = "VERR_LDRMACHO_UNSUPPORTED_LOAD_COMMAND" */
    '\x01','\xe9','\x1c','L','O','A','D','_','C','O','M','M','A','N','D',
/* 0x1834c = "VERR_IEM_INVALID_INSTR_LENGTH" */
    '\x01','\x9c','\x05','I','N','S','T','R','_','L','E','N','G','T','H',
/* 0x1835b = "VERR_FAM_MONITOR_FILE_FAILED" */
    '\x01','F','A','M','_','M','O','N','I','T','O','R','_','\xab','\x17',
/* 0x1836a = "Non-string object inside X." */
    'N','o','n','-','\xf2','\xa8','i','n','s','i','d','e',' ','X','.',
/* 0x18379 = "VERR_SHCLPB_GUEST_ERROR" */
    '\x01','S','H','C','L','P','B','_','G','U','E','S','T','_','\x1b',
/* 0x18388 = "VERR_PDM_TOO_PCI_MANY_DEVICES" */
    '\x01','\x7d','\x1a','P','C','I','_','\xac','D','E','V','I','C','E','S',
/* 0x18397 = "VERR_WEB_INVALID_OBJECT_ID" */
    '\x01','W','E','B','_','\x05','O','B','J','E','C','T','_','I','D',
/* 0x183a6 = "VERR_DRIVE_IS_EMPTY" */
    '\x01','D','R','I','V','E','_','I','S','_','E','M','P','T','Y',
/* 0x183b5 = "VERR_PATCH_DISABLED" */
    '\x01','P','A','T','C','H','_','D','I','S','A','B','L','E','D',
/* 0x183c4 = "VERR_PDM_MEDIA_MOUNTED" */
    '\x01','\x7d','M','E','D','I','A','_','M','O','U','N','T','E','D',
/* 0x183d3 = "VERR_VSCSI_LUN_TYPE_NOT_SUPPORTED" */
    '\x01','V','S','C','S','I','_','L','U','N','_','\xb5','_','\x06','\x82',
/* 0x183e2 = "VERR_SIGNAL_INVALID" */
    '\x01','S','I','G','N','A','L','_','I','N','V','A','L','I','D',
/* 0x183f1 = "VERR_LDRMACHO_UNSUPPORTED_TERM_SECTION" */
    '\x01','\xe9','\x1c','T','E','R','M','_','S','E','C','T','I','O','N',
/* 0x18400 = "VERR_VMX_IN_VMX_ROOT_MODE" */
    '\x01','\xe2','I','N','_','\xe2','R','O','O','T','_','M','O','D','E',
/* 0x1840f = "VERR_NET_ALREADY_CONNECTED" */
    '\x01','N','E','T','_','\x9b','C','O','N','N','E','C','T','E','D',
/* 0x1841e = "VERR_VD_CACHE_ALREADY_EXISTS" */
    '\x01','\xff','C','A','C','H','E','_','\x9b','E','X','I','S','T','S',
/* 0x1842d = "VERR_SVM_UNEXPECTED_XCPT_EXIT" */
    '\x01','S','V','M','_','\x88','X','C','P','T','_','E','X','I','T',
/* 0x1843c = "VERR_CR_X509_CERTPATHS_INTERNAL_ERROR" */
    '\x01','\x24','\xb7','C','E','R','T','P','A','T','H','S','_','\xc2','\x1b',
/* 0x1844b = "Invalid magic or cookie." */
    '\x0c','m','a','g','i','c',' ','\xa9','c','o','o','k','i','e','.',
/* 0x1845a = "VERR_ISOMK_IPE_READ_FILE_DATA_2" */
    '\x01','\x22','\x14','R','E','A','D','_','\xab','D','A','T','A','_','2',
/* 0x18469 = "VERR_ISOFS_MULTIPLE_PVDS" */
    '\x01','\x97','M','U','L','T','I','P','L','E','_','P','V','D','S',
/* 0x18478 = "Installation has failed." */
    'I','n','s','t','a','l','l','a','t','i','o','n',' ','\x5e','\x7b',
/* 0x18487 = "VFS chain element provider not found." */
    '\x8d',' ','\xa1','\x5c','p','r','o','v','i','d','e','r',' ','\x08','\x89',
/* 0x18496 = "VERR_VFS_CHAIN_PROVIDER_NOT_FOUND" */
    '\x01','\x8d','_','\x8e','P','R','O','V','I','D','E','R','_','\x06','\x2a',
/* 0x184a5 = "VERR_CR_KEY_NO_DEK_INFO" */
    '\x01','\x24','K','E','Y','_','\x60','D','E','K','_','I','N','F','O',
/* 0x184b4 = "VERR_PGM_NOT_SUPPORTED_FOR_NEM_MODE" */
    '\x01','\x8c','\x06','\x82','_','F','O','R','_','\xee','_','M','O','D','E',
/* 0x184c3 = "VERR_FILE_AIO_NOT_PREPARED" */
    '\x01','\xab','A','I','O','_','\x06','P','R','E','P','A','R','E','D',
/* 0x184d2 = "The specified cpu is offline." */
    '\x03','\x18','c','p','u',' ','\x0b','o','f','f','l','i','n','e','.',
/* 0x184e1 = "Unsupported character set." */
    '\x98','c','h','a','r','a','c','t','e','r',' ','s','e','t','.',
/* 0x184f0 = "Bad symbol table entry." */
    '\x9f','s','y','m','b','o','l',' ','\xb1','e','n','t','r','y','.',
/* 0x184ff = "VERR_SUPDRV_VTG_BAD_HDR_TOO_FEW" */
    '\x01','\x90','V','T','G','_','\x1d','H','D','R','_','\x1a','F','E','W',
/* 0x1850e = "VERR_ISOMK_IPE_READ_FILE_DATA_1" */
    '\x01','\x22','\x14','R','E','A','D','_','\xab','D','A','T','A','_','1',
/* 0x1851d = "VERR_IO_GEN_FAILURE" */
    '\x01','I','O','_','G','E','N','_','F','A','I','L','U','R','E',
/* 0x1852c = "VERR_SUPDRV_TRACER_TOO_LARGE" */
    '\x01','\x90','T','R','A','C','E','R','_','\x1a','L','A','R','G','E',
/* 0x1853b = "Unknown saved state record." */
    '\xef','s','a','v','e','d',' ','\xca','r','e','c','o','r','d','.',
/* 0x1854a = "The specified LUN is invalid." */
    '\x03','\x18','L','U','N',' ','\x0b','i','n','v','a','l','i','d','.',
/* 0x18559 = "VERR_ISOMK_IPE_READ_FILE_DATA_3" */
    '\x01','\x22','\x14','R','E','A','D','_','\xab','D','A','T','A','_','3',
/* 0x18568 = "VERR_TOO_MANY_SEM_REQUESTS" */
    '\x01','\x1a','\xac','S','E','M','_','R','E','Q','U','E','S','T','S',
/* 0x18577 = "VERR_SYS_SHUTDOWN_FAILED" */
    '\x01','S','Y','S','_','S','H','U','T','D','O','W','N','_','\x17',
/* 0x18586 = "Process Verification Failure: Bad image signature." */
    '\x1e','\x0d','\x12','\x9f','\x26','s','i','g','n','a','t','u','r','e','.',
/* 0x18595 = "VERR_SEM_OWNER_DIED" */
    '\x01','S','E','M','_','O','W','N','E','R','_','D','I','E','D',
/* 0x185a4 = "VINF_PATCH_CONTINUE" */
    '\x0e','P','A','T','C','H','_','C','O','N','T','I','N','U','E',
/* 0x185b3 = "VERR_TRAILING_CHARS" */
    '\x01','T','R','A','I','L','I','N','G','_','C','H','A','R','S',
/* 0x185c2 = "VERR_DIS_INVALID_PARAMETER" */
    '\x01','D','I','S','_','\x05','P','A','R','A','M','E','T','E','R',
/* 0x185d1 = "VERR_DBG_CFG_INVALID_VALUE" */
    '\x01','D','B','G','_','C','F','G','_','\x05','V','A','L','U','E',
/* 0x185e0 = "VERR_IOMMU_INTR_REMAP_FAILED" */
    '\x01','\xfd','_','I','N','T','R','_','R','E','M','A','P','_','\x17',
/* 0x185ef = "VERR_HM_INVALID_HM64ON32OP" */
    '\x01','H','M','_','\x05','H','M','6','4','O','N','3','2','O','P',
/* 0x185fe = "Write protect error." */
    'W','r','i','t','e',' ','p','r','o','t','e','c','t',' ','\x85',
/* 0x1860d = "VERR_CR_KEY_GEN_FAILED_RSA" */
    '\x01','\x24','K','E','Y','_','G','E','N','_','\x17','_','R','S','A',
/* 0x1861c = "VERR_SSM_FIELD_COMPLEX" */
    '\x01','\xb0','F','I','E','L','D','_','C','O','M','P','L','E','X',
/* 0x1862b = "VERR_PROC_DETACH_NOT_SUPPORTED" */
    '\x01','P','R','O','C','_','D','E','T','A','C','H','_','\x06','\x82',
/* 0x1863a = "Unable to decode date value." */
    '\xe0','\x0a','d','e','c','o','d','e',' ','d','a','t','e',' ','\xe8',
/* 0x18649 = "VERR_PDM_NO_PIC_INSTANCE" */
    '\x01','\x7d','\x60','P','I','C','_','I','N','S','T','A','N','C','E',
/* 0x18658 = "VERR_LDRMACHO_BAD_LOAD_COMMAND" */
    '\x01','\xe9','\x1d','L','O','A','D','_','C','O','M','M','A','N','D',
/* 0x18667 = "Invalid segment index." */
    '\x0c','s','e','g','m','e','n','t',' ','i','n','d','e','x','.',
/* 0x18676 = "VERR_SHCLPB_EVENT_FAILED" */
    '\x01','S','H','C','L','P','B','_','E','V','E','N','T','_','\x17',
/* 0x18685 = "VERR_CR_SPC_GENERIC_ERROR" */
    '\x01','\x24','S','P','C','_','G','E','N','E','R','I','C','_','\x1b',
/* 0x18694 = "The owner is not root (hardening)." */
    '\x03','o','w','n','e','r',' ','\x0b','\x08','r','o','o','t',' ','\xae',
/* 0x186a3 = "The breakpoint has no command." */
    '\x03','\xbf','\x5e','n','o',' ','c','o','m','m','a','n','d','.',
/* 0x186b1 = "VERR_IPE_UNEXPECTED_INFO_STATUS" */
    '\x01','\x14','\x88','I','N','F','O','_','S','T','A','T','U','S',
/* 0x186bf = "VERR_ASN1_INVALID_NUMERIC_STRING_ENCODING" */
    '\x01','\xa2','\x05','N','U','M','E','R','I','C','_','\xd5','_','\xc6',
/* 0x186cd = "VERR_DBGF_OS_NOT_DETCTED" */
    '\x01','\xb9','_','O','S','_','\x06','D','E','T','C','T','E','D',
/* 0x186db = "VERR_ISOMK_IPE_NAMESPACE_2" */
    '\x01','\x22','\x14','N','A','M','E','S','P','A','C','E','_','2',
/* 0x186e9 = "VERR_ISOMK_IPE_NAMESPACE_1" */
    '\x01','\x22','\x14','N','A','M','E','S','P','A','C','E','_','1',
/* 0x186f7 = "VERR_ASN1_INVALID_BITSTRING_ENCODING" */
    '\x01','\xa2','\x05','B','I','T','S','T','R','I','N','G','_','\xc6',
/* 0x18705 = "VERR_SSM_FIELD_INVALID_VALUE" */
    '\x01','\xb0','F','I','E','L','D','_','\x05','V','A','L','U','E',
/* 0x18713 = "VERR_LDRLX_BAD_HEADER" */
    '\x01','L','D','R','L','X','_','\x1d','H','E','A','D','E','R',
/* 0x18721 = "VERR_COM_INVALID_OBJECT_STATE" */
    '\x01','C','O','M','_','\x05','O','B','J','E','C','T','_','\xf1',
/* 0x1872f = "VERR_PDM_CRITSECT_IPE" */
    '\x01','\x7d','C','R','I','T','S','E','C','T','_','I','P','E',
/* 0x1873d = "Trap not handled." */
    'T','r','a','p',' ','\x08','h','a','n','d','l','e','d','.',
/* 0x1874b = "VERR_STALE_FILE_HANDLE" */
    '\x01','S','T','A','L','E','_','\xab','H','A','N','D','L','E',
/* 0x18759 = "VERR_GVM_MISMATCH_VMCPU_SIZE" */
    '\x01','G','V','M','_','\x19','_','V','M','C','P','U','_','\xf9',
/* 0x18767 = "VERR_ACCESS_DENIED" */
    '\x01','A','C','C','E','S','S','_','D','E','N','I','E','D',
/* 0x18775 = "VERR_NOT_SUP_IN_RAW_MODE" */
    '\x01','\x06','\x95','I','N','_','R','A','W','_','M','O','D','E',
/* 0x18783 = "VERR_SMM_INTEGRITY_MACHINE" */
    '\x01','S','M','M','_','\xf7','_','M','A','C','H','I','N','E',
/* 0x18791 = "VERR_IOQUEUE_EMPTY" */
    '\x01','I','O','Q','U','E','U','E','_','E','M','P','T','Y',
/* 0x1879f = "VERR_CR_X509_INVALID_NAME_STRING_TAG" */
    '\x01','\x24','\xb7','\x05','N','A','M','E','_','\xd5','_','T','A','G',
/* 0x187ad = "Bad DWARF string." */
    '\x9f','D','W','A','R','F',' ','s','t','r','i','n','g','.',
/* 0x187bb = "VERR_IOMMU_CMD_INVALID_FORMAT" */
    '\x01','\xfd','_','C','M','D','_','\x05','F','O','R','M','A','T',
/* 0x187c9 = "The alignment is not supported." */
    '\x03','a','l','i','g','n','m','e','n','t',' ','\x0b','\x08','\xa4',
/* 0x187d7 = "VERR_VFS_CHAIN_THREE_ARGS" */
    '\x01','\x8d','_','\x8e','T','H','R','E','E','_','A','R','G','S',
/* 0x187e5 = "VERR_SUP_VP_BAD_IMAGE_BASE" */
    '\x01','\x95','\xbd','\x1d','I','M','A','G','E','_','B','A','S','E',
/* 0x187f3 = "VERR_FILE_AIO_CANCELED" */
    '\x01','\xab','A','I','O','_','C','A','N','C','E','L','E','D',
/* 0x18801 = "VERR_PGM_TOO_MANY_ROM_RANGES" */
    '\x01','\x8c','\x1a','\xac','R','O','M','_','R','A','N','G','E','S',
/* 0x1880f = "VERR_ZIP_CORRUPTED" */
    '\x01','Z','I','P','_','C','O','R','R','U','P','T','E','D',
/* 0x1881d = "VINF_DBGF_BP_ALREADY_ENABLED" */
    '\x0e','\xb9','_','B','P','_','\x9b','E','N','A','B','L','E','D',
/* 0x1882b = "VERR_IOMMU_DTE_BAD_OFFSET" */
    '\x01','\xfd','_','D','T','E','_','\x1d','O','F','F','S','E','T',
/* 0x18839 = "VERR_L4_INVALID_DS_OFFSET" */
    '\x01','L','4','_','\x05','D','S','_','O','F','F','S','E','T',
/* 0x18847 = "VERR_DBGC_PARSE_VARIABLE_NOT_FOUND" */
    '\x01','\xfc','\xe4','V','A','R','I','A','B','L','E','_','\x06','\x2a',
/* 0x18855 = "VERR_ENV_VAR_UNSET" */
    '\x01','E','N','V','_','V','A','R','_','U','N','S','E','T',
/* 0x18863 = "VERR_SSM_INTEGRITY_UNIT_MAGIC" */
    '\x01','\xb0','\xf7','_','U','N','I','T','_','M','A','G','I','C',
/* 0x18871 = "Bad VTG string table offset." */
    '\x9f','V','T','G',' ','\xf2','\xb1','o','f','f','s','e','t','.',
/* 0x1887f = "VERR_ISOFS_TOO_MANY_FILE_FRAGMENTS" */
    '\x01','\x97','\x1a','\xac','\xab','F','R','A','G','M','E','N','T','S',
/* 0x1888d = "VWRN_PATCH_ENABLED" */
    '\xe6','P','A','T','C','H','_','E','N','A','B','L','E','D',
/* 0x1889b = "VERR_SUPDRV_VTG_BAD_HDR_OFF" */
    '\x01','\x90','V','T','G','_','\x1d','H','D','R','_','O','F','F',
/* 0x188a9 = "VINF_SELM_SYNC_GDT" */
    '\x0e','S','E','L','M','_','S','Y','N','C','_','G','D','T',
/* 0x188b7 = "VERR_PGM_SHW_NONE_IPE" */
    '\x01','\x8c','S','H','W','_','N','O','N','E','_','I','P','E',
/* 0x188c5 = "VERR_ISOFS_TAG_SECTOR_MISMATCH" */
    '\x01','\x97','T','A','G','_','S','E','C','T','O','R','_','\x19',
/* 0x188d3 = "VERR_NET_HOST_DOWN" */
    '\x01','N','E','T','_','H','O','S','T','_','D','O','W','N',
/* 0x188e1 = "VERR_NO_STRING_TERMINATOR" */
    '\x01','\x60','\xd5','_','T','E','R','M','I','N','A','T','O','R',
/* 0x188ef = "VERR_DBGC_PARSE_FUNCTION_NOT_FOUND" */
    '\x01','\xfc','\xe4','F','U','N','C','T','I','O','N','_','\x06','\x2a',
/* 0x188fd = "Not data selector." */
    'N','o','t',' ','\x9d','s','e','l','e','c','t','o','r','.',
/* 0x1890b = "VERR_SUPDRV_INTERFACE_NOT_SUPPORTED" */
    '\x01','\x90','I','N','T','E','R','F','A','C','E','_','\x06','\x82',
/* 0x18919 = "VERR_VFS_CHAIN_TAKES_FILE" */
    '\x01','\x8d','_','\x8e','T','A','K','E','S','_','F','I','L','E',
/* 0x18927 = "VERR_ASN1_INVALID_VISIBLE_STRING_ENCODING" */
    '\x01','\xa2','\x05','V','I','S','I','B','L','E','_','\xd5','_','\xc6',
/* 0x18935 = "VERR_SUP_VP_STUB_OPEN_ERROR" */
    '\x01','\x95','\xbd','S','T','U','B','_','O','P','E','N','_','\x1b',
/* 0x18943 = "VERR_COM_OBJECT_NOT_FOUND" */
    '\x01','C','O','M','_','O','B','J','E','C','T','_','\x06','\x2a',
/* 0x18951 = "VFS chain element takes no arguments." */
    '\x8d',' ','\xa1','\x5c','t','a','k','e','s',' ','n','o',' ','\xdd',
/* 0x1895f = "VERR_VM_THREAD_NOT_EMT" */
    '\x01','\xcd','_','T','H','R','E','A','D','_','\x06','E','M','T',
/* 0x1896d = "VERR_FILE_AIO_NO_REQUEST" */
    '\x01','\xab','A','I','O','_','\x60','R','E','Q','U','E','S','T',
/* 0x1897b = "VERR_DBGC_PARSE_NUMBER_TOO_BIG" */
    '\x01','\xfc','\xe4','N','U','M','B','E','R','_','\x1a','B','I','G',
/* 0x18989 = "VERR_PDM_DRVHLPR3_VERSION_MISMATCH" */
    '\x01','\x7d','D','R','V','H','L','P','R','3','_','\xbc','_','\x19',
/* 0x18997 = "VERR_PGM_PML4_MAPPING" */
    '\x01','\x8c','P','M','L','4','_','M','A','P','P','I','N','G',
/* 0x189a5 = "VERR_SUPLIB_IS_DIRECTORY" */
    '\x01','\xd6','I','S','_','D','I','R','E','C','T','O','R','Y',
/* 0x189b3 = "VERR_LDRVI_BAD_CERT_FORMAT" */
    '\x01','\xf4','\x1d','C','E','R','T','_','F','O','R','M','A','T',
/* 0x189c1 = "Internal processing error #1 in the GVMM code." */
    '\x07','\x04','\x09','#','1',' ','\x0f','\x02','G','V','M','M',' ','\x84',
/* 0x189cf = "VERR_CR_PKCS7_KEY_USAGE_MISMATCH" */
    '\x01','\x24','\xe5','K','E','Y','_','U','S','A','G','E','_','\x19',
/* 0x189dd = "VERR_WRITE_PROTECT" */
    '\x01','W','R','I','T','E','_','P','R','O','T','E','C','T',
/* 0x189eb = "Reason for leaving RZ: MMIO read." */
    '\x93','\x10','\x81','R','Z',':',' ','\xd3',' ','r','e','a','d','.',
/* 0x189f9 = "Drive is locked." */
    'D','r','i','v','e',' ','\x0b','l','o','c','k','e','d','.',
/* 0x18a07 = "VERR_SEM_LV_NESTED" */
    '\x01','S','E','M','_','L','V','_','N','E','S','T','E','D',
/* 0x18a15 = "VERR_PATM_ALREADY_PATCHED" */
    '\x01','P','A','T','M','_','\x9b','P','A','T','C','H','E','D',
/* 0x18a23 = "VERR_ASN1_CURSOR_TAG_MISMATCH" */
    '\x01','\xa2','C','U','R','S','O','R','_','T','A','G','_','\x19',
/* 0x18a31 = "VINF_REBOOT_NEEDED" */
    '\x0e','R','E','B','O','O','T','_','N','E','E','D','E','D',
/* 0x18a3f = "Access denied." */
    'A','c','c','e','s','s',' ','d','e','n','i','e','d','.',
/* 0x18a4d = "VERR_SUPDRV_VTG_BAD_ARGLIST" */
    '\x01','\x90','V','T','G','_','\x1d','A','R','G','L','I','S','T',
/* 0x18a5b = "VERR_XAR_BAD_FILE_ELEMENT" */
    '\x01','X','A','R','_','\x1d','\xab','E','L','E','M','E','N','T',
/* 0x18a69 = "VERR_SSM_LOADED_TOO_MUCH" */
    '\x01','\xb0','L','O','A','D','E','D','_','\x1a','M','U','C','H',
/* 0x18a77 = "Invalid VMCS pointer." */
    '\x0c','V','M','C','S',' ','p','o','i','n','t','e','r','.',
/* 0x18a85 = "VERR_HOSTIF_INIT_FAILED" */
    '\x01','H','O','S','T','I','F','_','I','N','I','T','_','\x17',
/* 0x18a93 = "VERR_NEGATIVE_SEEK" */
    '\x01','N','E','G','A','T','I','V','E','_','S','E','E','K',
/* 0x18aa1 = "Address already in use." */
    'A','d','d','r','e','s','s',' ','\x7f','\x0f','u','s','e','.',
/* 0x18aaf = "VERR_MEMOBJ_INIT_FAILED" */
    '\x01','M','E','M','O','B','J','_','I','N','I','T','_','\x17',
/* 0x18abd = "Code signing error." */
    'C','o','d','e',' ','s','i','g','n','i','n','g',' ','\x85',
/* 0x18acb = "VERR_HM_UNEXPECTED_LD_ST_MSR" */
    '\x01','H','M','_','\x88','L','D','_','S','T','_','M','S','R',
/* 0x18ad9 = "The ICB for is too small." */
    '\x03','I','C','B',' ','\x10','\x0b','\x9e','s','m','a','l','l','.',
/* 0x18ae7 = "The device instance was not found." */
    '\x03','\xa3','i','n','s','t','a','n','c','e',' ','\x11','\x08','\x89',
/* 0x18af5 = "VERR_ASN1_INVALID_GRAPHIC_STRING_ENCODING" */
    '\x01','\xa2','\x05','G','R','A','P','H','I','C','_','\xd5','_','\xc6',
/* 0x18b03 = "Unexpected trap in patch code." */
    '\x94','t','r','a','p',' ','\x0f','p','a','t','c','h',' ','\x84',
/* 0x18b11 = "Unsupported descriptor tag version." */
    '\x98','\xe3','t','a','g',' ','v','e','r','s','i','o','n','.',
/* 0x18b1f = "VERR_SUPLIB_TEXT_NOT_SEALED" */
    '\x01','\xd6','T','E','X','T','_','\x06','S','E','A','L','E','D',
/* 0x18b2d = "VERR_PDM_NO_QUEUE_ITEMS" */
    '\x01','\x7d','\x60','Q','U','E','U','E','_','I','T','E','M','S',
/* 0x18b3b = "Recompiler: Unexpected register assignment." */
    '\x13','\x94','\xeb','a','s','s','i','g','n','m','e','n','t','.',
/* 0x18b49 = "VERR_DBGC_PARSE_NOT_A_FUNCTION" */
    '\x01','\xfc','\xe4','\x06','A','_','F','U','N','C','T','I','O','N',
/* 0x18b57 = "VERR_HTTP_PROXY_NOT_FOUND" */
    '\x01','H','T','T','P','_','P','R','O','X','Y','_','\x06','\x2a',
/* 0x18b65 = "VERR_SSM_UNSUPPORTED_DATA_UNIT_VERSION" */
    '\x01','\xb0','\x1c','D','A','T','A','_','U','N','I','T','_','\xbc',
/* 0x18b73 = "VERR_HGCM_INTERNAL" */
    '\x01','H','G','C','M','_','I','N','T','E','R','N','A','L',
/* 0x18b81 = "VINF_IEM_SELECTOR_NOT_OK" */
    '\x0e','\x9c','S','E','L','E','C','T','O','R','_','\x06','O','K',
/* 0x18b8f = "VERR_DBGF_REGISTER_NOT_FOUND" */
    '\x01','\xb9','_','R','E','G','I','S','T','E','R','_','\x06','\x2a',
/* 0x18b9d = "VERR_LDRVI_NO_MEMORY_SIGNATURE" */
    '\x01','\xf4','\x60','\xb6','_','S','I','G','N','A','T','U','R','E',
/* 0x18bab = "VERR_GVM_MISMATCH_SVN_REV" */
    '\x01','G','V','M','_','\x19','_','S','V','N','_','R','E','V',
/* 0x18bb9 = "VERR_IOM_INVALID_MMIO_HANDLE" */
    '\x01','I','O','M','_','\x05','\xd3','_','H','A','N','D','L','E',
/* 0x18bc7 = "Winsock init error." */
    'W','i','n','s','o','c','k',' ','i','n','i','t',' ','\x85',
/* 0x18bd5 = "VERR_HTTP_BAD_REQUEST" */
    '\x01','H','T','T','P','_','\x1d','R','E','Q','U','E','S','T',
/* 0x18be3 = "VERR_NOT_POWER_OF_TWO" */
    '\x01','\x06','P','O','W','E','R','_','O','F','_','T','W','O',
/* 0x18bf1 = "VWRN_PATCH_REMOVED" */
    '\xe6','P','A','T','C','H','_','R','E','M','O','V','E','D',
/* 0x18bff = "VERR_PGM_PHYS_PAGE_MAP_IPE_3" */
    '\x01','\x8c','P','H','Y','S','_','\xdc','M','A','P','_','\x14','3',
/* 0x18c0d = "VERR_PGM_PHYS_PAGE_MAP_IPE_4" */
    '\x01','\x8c','P','H','Y','S','_','\xdc','M','A','P','_','\x14','4',
/* 0x18c1b = "VERR_DBGC_PARSE_TOO_MANY_ARGUMENTS" */
    '\x01','\xfc','\xe4','\x1a','\xac','A','R','G','U','M','E','N','T','S',
/* 0x18c29 = "VERR_SUP_VP_BAD_SECTION_FILE_SIZE" */
    '\x01','\x95','\xbd','\x1d','S','E','C','T','I','O','N','_','\xab','\xf9',
/* 0x18c37 = "VERR_NO_TLS_FOR_SELF" */
    '\x01','\x60','T','L','S','_','F','O','R','_','S','E','L','F',
/* 0x18c45 = "VERR_GMM_PAGE_NOT_PRIVATE" */
    '\x01','G','M','M','_','\xdc','\x06','P','R','I','V','A','T','E',
/* 0x18c53 = "VERR_LDRVI_READ_ERROR_SHDRS" */
    '\x01','\xf4','R','E','A','D','_','\x1b','_','S','H','D','R','S',
/* 0x18c61 = "VERR_PGM_PHYS_PAGE_MAP_IPE_1" */
    '\x01','\x8c','P','H','Y','S','_','\xdc','M','A','P','_','\x14','1',
/* 0x18c6f = "VERR_PGM_PHYS_PAGE_MAP_IPE_2" */
    '\x01','\x8c','P','H','Y','S','_','\xdc','M','A','P','_','\x14','2',
/* 0x18c7d = "VERR_PGM_MAPPINGS_SMP" */
    '\x01','\x8c','M','A','P','P','I','N','G','S','_','S','M','P',
/* 0x18c8b = "VERR_PGM_TOO_MANY_RAM_RANGES" */
    '\x01','\x8c','\x1a','\xac','R','A','M','_','R','A','N','G','E','S',
/* 0x18c99 = "VERR_SUPLIB_NOT_SAME_OBJECT" */
    '\x01','\xd6','\x06','S','A','M','E','_','O','B','J','E','C','T',
/* 0x18ca7 = "Unexpected turn of events." */
    '\x94','t','u','r','n',' ','\x15','e','v','e','n','t','s','.',
/* 0x18cb5 = "VERR_RT_REQUEST_INVALID_TYPE" */
    '\x01','R','T','_','R','E','Q','U','E','S','T','_','\x05','\xb5',
/* 0x18cc3 = "VERR_ISOFS_PARTITION_NOT_FOUND" */
    '\x01','\x97','P','A','R','T','I','T','I','O','N','_','\x06','\x2a',
/* 0x18cd1 = "VERR_CFGM_NOT_INTEGER" */
    '\x01','C','F','G','M','_','\x06','I','N','T','E','G','E','R',
/* 0x18cdf = "Child node was not found." */
    'C','h','i','l','d',' ','n','o','d','e',' ','\x11','\x08','\x89',
/* 0x18ced = "VERR_SSM_LOAD_CPUID_MISMATCH" */
    '\x01','\xb0','L','O','A','D','_','C','P','U','I','D','_','\x19',
/* 0x18cfb = "Syntax error - invalid numeric value." */
    '\xfa','\x09','-',' ','\x8f','n','u','m','e','r','i','c',' ','\xe8',
/* 0x18d09 = "VERR_DWARF_BAD_ABBREV" */
    '\x01','D','W','A','R','F','_','\x1d','A','B','B','R','E','V',
/* 0x18d17 = "Message too long." */
    'M','e','s','s','a','g','e',' ','\x9e','l','o','n','g','.',
/* 0x18d25 = "VERR_DVM_MAP_EMPTY" */
    '\x01','D','V','M','_','M','A','P','_','E','M','P','T','Y',
/* 0x18d33 = "VERR_PDM_USBHLPR3_VERSION_MISMATCH" */
    '\x01','\x7d','U','S','B','H','L','P','R','3','_','\xbc','_','\x19',
/* 0x18d41 = "VERR_LDRLX_NO_SONAME" */
    '\x01','L','D','R','L','X','_','\x60','S','O','N','A','M','E',
/* 0x18d4f = "VERR_SUP_VP_TOO_MANY_MEMORY_REGIONS" */
    '\x01','\x95','\xbd','\x1a','\xac','\xb6','_','R','E','G','I','O','N','S',
/* 0x18d5d = "VERR_GVMM_INSTANCE" */
    '\x01','G','V','M','M','_','I','N','S','T','A','N','C','E',
/* 0x18d6b = "VERR_RECORDING_ENCODING_FAILED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','\xc6','_','\x17',
/* 0x18d79 = "Bad VTG header - to low value." */
    '\x9f','V','T','G',' ','\xb3','-',' ','\x0a','l','o','w',' ','\xe8',
/* 0x18d87 = "Internal processing error #2 in the GVMM code." */
    '\x07','\x04','\x09','#','2',' ','\x0f','\x02','G','V','M','M',' ','\x84',
/* 0x18d95 = "VERR_NEM_MAP_PAGES_FAILED" */
    '\x01','\xee','_','M','A','P','_','P','A','G','E','S','_','\x17',
/* 0x18da3 = "VERR_SUPDRV_VTG_BAD_HDR_PTR" */
    '\x01','\x90','V','T','G','_','\x1d','H','D','R','_','P','T','R',
/* 0x18db1 = "VERR_SUPLIB_PATH_IS_ROOT" */
    '\x01','\xd6','P','A','T','H','_','I','S','_','R','O','O','T',
/* 0x18dbf = "VERR_VFS_CHAIN_NOT_PATH_ONLY" */
    '\x01','\x8d','_','\x8e','\x06','P','A','T','H','_','O','N','L','Y',
/* 0x18dcd = "VERR_ASN1_INVALID_GENERAL_STRING_ENCODING" */
    '\x01','\xa2','\x05','G','E','N','E','R','A','L','_','\xd5','_','\xc6',
/* 0x18ddb = "VERR_JSON_IS_EMPTY" */
    '\x01','J','S','O','N','_','I','S','_','E','M','P','T','Y',
/* 0x18de9 = "VERR_NO_CODE_POINT_MEMORY" */
    '\x01','\x60','C','O','D','E','_','P','O','I','N','T','_','\xb6',
/* 0x18df7 = "VERR_NO_MORE_HANDLES" */
    '\x01','\x60','M','O','R','E','_','H','A','N','D','L','E','S',
/* 0x18e05 = "VERR_PGM_RAM_CONFLICT" */
    '\x01','\x8c','R','A','M','_','C','O','N','F','L','I','C','T',
/* 0x18e13 = "The VM has been restored." */
    '\x03','\xcd',' ','\x5e','\xcb','r','e','s','t','o','r','e','d','.',
/* 0x18e21 = "VERR_CFGM_VALUE_NOT_FOUND" */
    '\x01','C','F','G','M','_','V','A','L','U','E','_','\x06','\x2a',
/* 0x18e2f = "Page record not found." */
    'P','a','g','e',' ','r','e','c','o','r','d',' ','\x08','\x89',
/* 0x18e3d = "VERR_VD_VMDK_INVALID_FORMAT" */
    '\x01','\xff','V','M','D','K','_','\x05','F','O','R','M','A','T',
/* 0x18e4b = "Requested operation is not supported." */
    'R','e','q','u','e','s','t','e','d',' ','\x96','\x0b','\x08','\xa4',
/* 0x18e59 = "Max process number reached." */
    'M','a','x',' ','\x92','\xfb','r','e','a','c','h','e','d','.',
/* 0x18e67 = "VERR_GMM_TOO_MANY_REGIONS" */
    '\x01','G','M','M','_','\x1a','\xac','R','E','G','I','O','N','S',
/* 0x18e75 = "VERR_LDRLX_BAD_BUNDLE" */
    '\x01','L','D','R','L','X','_','\x1d','B','U','N','D','L','E',
/* 0x18e83 = "VERR_RESOURCE_BUSY" */
    '\x01','R','E','S','O','U','R','C','E','_','B','U','S','Y',
/* 0x18e91 = "Page not present." */
    'P','a','g','e',' ','\x08','p','r','e','s','e','n','t','.',
/* 0x18e9f = "VERR_REBOOT_NEEDED" */
    '\x01','R','E','B','O','O','T','_','N','E','E','D','E','D',
/* 0x18ead = "NEM is not available." */
    '\xee',' ','\x0b','\x08','a','v','a','i','l','a','b','l','e','.',
/* 0x18ebb = "VERR_IOM_IOPORT_IPE_3" */
    '\x01','I','O','M','_','I','O','P','O','R','T','_','\x14','3',
/* 0x18ec9 = "VERR_IOM_IOPORT_IPE_1" */
    '\x01','I','O','M','_','I','O','P','O','R','T','_','\x14','1',
/* 0x18ed7 = "Failed to enumerate directory (hardening)." */
    '\x8b','\x0a','e','n','u','m','e','r','a','t','e',' ','\x25','\xae',
/* 0x18ee5 = "No media in drive." */
    '\xdf','m','e','d','i','a',' ','\x0f','d','r','i','v','e','.',
/* 0x18ef3 = "VERR_CR_DIGEST_COMPROMISED" */
    '\x01','\x24','\xbe','C','O','M','P','R','O','M','I','S','E','D',
/* 0x18f01 = "VERR_PDM_MEDIA_LOCKED" */
    '\x01','\x7d','M','E','D','I','A','_','L','O','C','K','E','D',
/* 0x18f0f = "VERR_IOM_IOPORT_IPE_2" */
    '\x01','I','O','M','_','I','O','P','O','R','T','_','\x14','2',
/* 0x18f1d = "VERR_ISOMK_IMPORT_TOO_MANY_VOL_DESCS" */
    '\x01','\x22','\x83','\x1a','\xac','V','O','L','_','D','E','S','C','S',
/* 0x18f2b = "VERR_INVALID_VMCPU_HANDLE" */
    '\x01','\x05','V','M','C','P','U','_','H','A','N','D','L','E',
/* 0x18f39 = "VERR_ISOMK_IPE_NAMESPACE_6" */
    '\x01','\x22','\x14','N','A','M','E','S','P','A','C','E','_','6',
/* 0x18f47 = "VERR_CFGM_CHILD_NOT_FOUND" */
    '\x01','C','F','G','M','_','C','H','I','L','D','_','\x06','\x2a',
/* 0x18f55 = "VERR_ISOMK_IPE_NAMESPACE_5" */
    '\x01','\x22','\x14','N','A','M','E','S','P','A','C','E','_','5',
/* 0x18f63 = "VERR_ISOMK_IPE_NAMESPACE_3" */
    '\x01','\x22','\x14','N','A','M','E','S','P','A','C','E','_','3',
/* 0x18f71 = "VERR_ISOMK_IPE_NAMESPACE_4" */
    '\x01','\x22','\x14','N','A','M','E','S','P','A','C','E','_','4',
/* 0x18f7f = "VERR_CR_PKCS7_UNKNOWN_DIGEST_ALGORITHM" */
    '\x01','\x24','\xe5','\x91','\xbe','A','L','G','O','R','I','T','H','M',
/* 0x18f8d = "VERR_HOSTIF_TERM_FAILED" */
    '\x01','H','O','S','T','I','F','_','T','E','R','M','_','\x17',
/* 0x18f9b = "GIM generic operation failed." */
    'G','I','M',' ','g','e','n','e','r','i','c',' ','\x96','\x7b',
/* 0x18fa9 = "VERR_LDRVI_IMAGE_HASH_MISMATCH" */
    '\x01','\xf4','I','M','A','G','E','_','H','A','S','H','_','\x19',
/* 0x18fb7 = "VERR_ASN1_DUMMY_OBJECT" */
    '\x01','\xa2','D','U','M','M','Y','_','O','B','J','E','C','T',
/* 0x18fc5 = "Invalid flags was given." */
    '\x0c','f','l','a','g','s',' ','\x11','g','i','v','e','n','.',
/* 0x18fd3 = "VERR_ENV_INVALID_VAR_NAME" */
    '\x01','E','N','V','_','\x05','V','A','R','_','N','A','M','E',
/* 0x18fe1 = "VERR_VD_VMDK_INVALID_HEADER" */
    '\x01','\xff','V','M','D','K','_','\x05','H','E','A','D','E','R',
/* 0x18fef = "VERR_PGM_POOL_TOO_MANY_LOOPS" */
    '\x01','\x8c','P','O','O','L','_','\x1a','\xac','L','O','O','P','S',
/* 0x18ffd = "Too little data in ASN." */
    'T','o','o',' ','l','i','t','t','l','e',' ','\x9d','\x0f','\xf6',
/* 0x1900b = "VERR_FTP_CLIENT_NOT_FOUND" */
    '\x01','F','T','P','_','C','L','I','E','N','T','_','\x06','\x2a',
/* 0x19019 = "Syntax error - Command not found." */
    '\xfa','\x09','-',' ','C','o','m','m','a','n','d',' ','\x08','\x89',
/* 0x19027 = "VINF_ENV_VAR_UNSET" */
    '\x0e','E','N','V','_','V','A','R','_','U','N','S','E','T',
/* 0x19035 = "VERR_GMM_MTX_FLAGS" */
    '\x01','G','M','M','_','M','T','X','_','F','L','A','G','S',
/* 0x19043 = "Invalid drive number." */
    '\x0c','d','r','i','v','e',' ','n','u','m','b','e','r','.',
/* 0x19051 = "VERR_LDRLX_BAD_SONAME" */
    '\x01','L','D','R','L','X','_','\x1d','S','O','N','A','M','E',
/* 0x1905f = "Network is down." */
    'N','e','t','w','o','r','k',' ','\x0b','d','o','w','n','.',
/* 0x1906d = "VERR_RAW_MODE_INVALID_SMP" */
    '\x01','R','A','W','_','M','O','D','E','_','\x05','S','M','P',
/* 0x1907b = "VERR_SSM_LIVE_FATAL_ERROR" */
    '\x01','\xb0','L','I','V','E','_','F','A','T','A','L','_','\x1b',
/* 0x19089 = "Internal processing error in the HM init code." */
    '\x07','\x04','\x09','\x0f','\x02','H','M',' ','i','n','i','t',' ','\x84',
/* 0x19097 = "VERR_PKZIP_UNKNOWN_TYPE_FLAG" */
    '\x01','P','K','Z','I','P','_','\x91','\xb5','_','F','L','A','G',
/* 0x190a5 = "VERR_TM_UNSTABLE_STATE" */
    '\x01','T','M','_','U','N','S','T','A','B','L','E','_','\xf1',
/* 0x190b3 = "VERR_SUPDRV_COMPONENT_NOT_FOUND" */
    '\x01','\x90','C','O','M','P','O','N','E','N','T','_','\x06','\x2a',
/* 0x190c1 = "VINF_CR_DIGEST_COMPROMISED" */
    '\x0e','\x24','\xbe','C','O','M','P','R','O','M','I','S','E','D',
/* 0x190cf = "VERR_GIM_INVALID_PROVIDER" */
    '\x01','G','I','M','_','\x05','P','R','O','V','I','D','E','R',
/* 0x190dd = "VERR_SEM_LV_NOT_OWNER" */
    '\x01','S','E','M','_','L','V','_','\x06','O','W','N','E','R',
/* 0x190eb = "VERR_VM_UNEXPECTED_UNSTABLE_STATE" */
    '\x01','\xcd','_','\x88','U','N','S','T','A','B','L','E','_','\xf1',
/* 0x190f9 = "VERR_SUPLIB_UNEXPECTED_INSTRUCTION" */
    '\x01','\xd6','\x88','I','N','S','T','R','U','C','T','I','O','N',
/* 0x19107 = "VERR_JSON_VALUE_INVALID_TYPE" */
    '\x01','J','S','O','N','_','V','A','L','U','E','_','\x05','\xb5',
/* 0x19115 = "VERR_LDRMACHO_BAD_OBJECT_FILE" */
    '\x01','\xe9','\x1d','O','B','J','E','C','T','_','F','I','L','E',
/* 0x19123 = "Invalid link address." */
    '\x0c','l','i','n','k',' ','a','d','d','r','e','s','s','.',
/* 0x19131 = "Invalid saved page state." */
    '\x0c','s','a','v','e','d',' ','\xcc','s','t','a','t','e','.',
/* 0x1913f = "Patch enabled." */
    'P','a','t','c','h',' ','e','n','a','b','l','e','d','.',
/* 0x1914d = "VERR_SEM_DESTROYED" */
    '\x01','S','E','M','_','D','E','S','T','R','O','Y','E','D',
/* 0x1915b = "VINF_DBGF_OS_NOT_DETCTED" */
    '\x0e','\xb9','_','O','S','_','\x06','D','E','T','C','T','E','D',
/* 0X19169 = "Disk was changed." */
    'i','s','k',' ','\x11','c','h','a','n','g','e','d','.',
/* 0x19176 = "VERR_ASN1_DYNTYPE_BAD_TAG" */
    '\x01','\xa2','D','Y','N','T','Y','P','E','_','\x1d','T','A','G',
/* 0x19184 = "A directory entry in the archive." */
    'A',' ','\x25','\xc8','\x0f','\x02','a','r','c','h','i','v','e','.',
/* 0x19192 = "VERR_IOM_INVALID_IOPORT_SIZE" */
    '\x01','I','O','M','_','\x05','I','O','P','O','R','T','_','\xf9',
/* 0x191a0 = "Internal processing error #4 in the IEM code." */
    '\x07','\x04','\x09','#','4',' ','\x0f','\x02','I','E','M',' ','\x84',
/* 0x191ad = "VERR_VFS_CHAIN_PATH_ONLY" */
    '\x01','\x8d','_','\x8e','P','A','T','H','_','O','N','L','Y',
/* 0x191ba = "VERR_ASN1_INVALID_UTC_TIME_ENCODING" */
    '\x01','\xa2','\x05','U','T','C','_','T','I','M','E','_','\xc6',
/* 0x191c7 = "VERR_GMM_INSTANCE" */
    '\x01','G','M','M','_','I','N','S','T','A','N','C','E',
/* 0x191d4 = "Recompiler: Label internal processing error #2." */
    '\x13','L','a','b','e','l',' ','\x16','\x04','\x09','#','2','.',
/* 0x191e1 = "VERR_DBG_NO_SYMBOLS" */
    '\x01','D','B','G','_','\x60','S','Y','M','B','O','L','S',
/* 0x191ee = "VERR_TOO_MANY_REFERENCES" */
    '\x01','\x1a','\xac','R','E','F','E','R','E','N','C','E','S',
/* 0x191fb = "Wrong magic value." */
    'W','r','o','n','g',' ','m','a','g','i','c',' ','\xe8',
/* 0x19208 = "VERR_PGM_SAVED_REC_TYPE" */
    '\x01','\x8c','S','A','V','E','D','_','R','E','C','_','\xb5',
/* 0x19215 = "VERR_VM_ATRESET_NOT_FOUND" */
    '\x01','\xcd','_','A','T','R','E','S','E','T','_','\x06','\x2a',
/* 0x19222 = "VERR_CFGM_NO_PARENT" */
    '\x01','C','F','G','M','_','\x60','P','A','R','E','N','T',
/* 0x1922f = "Internal processing error #9 in the IEM code." */
    '\x07','\x04','\x09','#','9',' ','\x0f','\x02','I','E','M',' ','\x84',
/* 0x1923c = "VERR_LDRVI_BAD_CERT_HDR_TYPE" */
    '\x01','\xf4','\x1d','C','E','R','T','_','H','D','R','_','\xb5',
/* 0x19249 = "VERR_TAR_CHKSUM_MISMATCH" */
    '\x01','T','A','R','_','C','H','K','S','U','M','_','\x19',
/* 0x19256 = "VERR_HOSTIF_IOCTL" */
    '\x01','H','O','S','T','I','F','_','I','O','C','T','L',
/* 0x19263 = "VERR_SVM_INVALID_GUEST_STATE" */
    '\x01','S','V','M','_','\x05','G','U','E','S','T','_','\xf1',
/* 0x19270 = "VERR_NOT_SAME_DEVICE" */
    '\x01','\x06','S','A','M','E','_','D','E','V','I','C','E',
/* 0x1927d = "VERR_SUP_VP_BAD_MZ_OFFSET" */
    '\x01','\x95','\xbd','\x1d','M','Z','_','O','F','F','S','E','T',
/* 0x1928a = "VERR_UNRESOLVED_ERROR" */
    '\x01','U','N','R','E','S','O','L','V','E','D','_','\x1b',
/* 0x19297 = "VERR_IEM_FIXUP_TOO_MANY" */
    '\x01','\x9c','F','I','X','U','P','_','\x1a','M','A','N','Y',
/* 0x192a4 = "VERR_SEM_BAD_CONTEXT" */
    '\x01','S','E','M','_','\x1d','C','O','N','T','E','X','T',
/* 0x192b1 = "Internal processing error #5 in the IEM code." */
    '\x07','\x04','\x09','#','5',' ','\x0f','\x02','I','E','M',' ','\x84',
/* 0x192be = "VINF_PGM_CACHED_PAGE" */
    '\x0e','\x8c','C','A','C','H','E','D','_','P','A','G','E',
/* 0x192cb = "VERR_SVM_UNEXPECTED_PATCH_TYPE" */
    '\x01','S','V','M','_','\x88','P','A','T','C','H','_','\xb5',
/* 0x192d8 = "Internal processing error #8 in the IEM code." */
    '\x07','\x04','\x09','#','8',' ','\x0f','\x02','I','E','M',' ','\x84',
/* 0x192e5 = "VERR_GCM_NOT_HANDLED" */
    '\x01','G','C','M','_','\x06','H','A','N','D','L','E','D',
/* 0x192f2 = "VINF_EM_TERMINATE" */
    '\x0e','E','M','_','T','E','R','M','I','N','A','T','E',
/* 0x192ff = "VERR_PGM_MAPPING_IPE" */
    '\x01','\x8c','M','A','P','P','I','N','G','_','I','P','E',
/* 0x1930c = "VERR_SSM_UNIT_NOT_OWNER" */
    '\x01','\xb0','U','N','I','T','_','\x06','O','W','N','E','R',
/* 0x19319 = "Bad image relocation." */
    '\x9f','\x26','r','e','l','o','c','a','t','i','o','n','.',
/* 0x19326 = "VERR_DBG_INVALID_ADDRESS" */
    '\x01','D','B','G','_','\x05','A','D','D','R','E','S','S',
/* 0x19333 = "Recompiler: Fixup internal processing error #1." */
    '\x13','F','i','x','u','p',' ','\x16','\x04','\x09','#','1','.',
/* 0x19340 = "VERR_NET_SHUTDOWN" */
    '\x01','N','E','T','_','S','H','U','T','D','O','W','N',
/* 0x1934d = "VERR_ISOMK_IPE_EMPTY_PATH" */
    '\x01','\x22','\x14','E','M','P','T','Y','_','P','A','T','H',
/* 0x1935a = "VINF_DBGC_BP_NO_COMMAND" */
    '\x0e','\xfc','B','P','_','\x60','C','O','M','M','A','N','D',
/* 0x19367 = "VERR_VFS_CHAIN_INVALID_ARGUMENT" */
    '\x01','\x8d','_','\x8e','\x05','A','R','G','U','M','E','N','T',
/* 0x19374 = "Recompiler: Too many fixups." */
    '\x13','T','o','o',' ','\xb4','f','i','x','u','p','s','.',
/* 0x19381 = "VERR_INVALID_UUID_FORMAT" */
    '\x01','\x05','U','U','I','D','_','F','O','R','M','A','T',
/* 0x1938e = "VERR_NOT_A_DIRECTORY" */
    '\x01','\x06','A','_','D','I','R','E','C','T','O','R','Y',
/* 0x1939b = "VERR_SSM_INTEGRITY_DIR_MAGIC" */
    '\x01','\xb0','\xf7','_','D','I','R','_','M','A','G','I','C',
/* 0x193a8 = "VERR_IEM_LABEL_TOO_MANY" */
    '\x01','\x9c','L','A','B','E','L','_','\x1a','M','A','N','Y',
/* 0x193b5 = "VERR_SUP_VP_IMAGE_TOO_BIG" */
    '\x01','\x95','\xbd','I','M','A','G','E','_','\x1a','B','I','G',
/* 0x193c2 = "VERR_NEM_VM_CREATE_FAILED" */
    '\x01','\xee','_','\xcd','_','C','R','E','A','T','E','_','\x17',
/* 0x193cf = "VINF_EM_WAIT_SIPI" */
    '\x0e','E','M','_','W','A','I','T','_','S','I','P','I',
/* 0x193dc = "VERR_VFS_CHAIN_FINAL_TYPE_MISMATCH" */
    '\x01','\x8d','_','\x8e','F','I','N','A','L','_','\xb5','_','\x19',
/* 0x193e9 = "The specified path is a file and not a directory (hardening)." */
    '\x03','\x18','\xd0','\x0b','a',' ','\x1f','\x9a','\x08','a',' ','\x25','\xae',
/* 0x193f6 = "The saved state file version is not supported." */
    '\x03','s','a','v','e','d',' ','\xca','\x1f','\xcf','\x0b','\x08','\xa4',
/* 0x19403 = "VERR_ALREADY_INITIALIZED" */
    '\x01','\x9b','I','N','I','T','I','A','L','I','Z','E','D',
/* 0x19410 = "VERR_PDM_BAD_PCI_CONFIG" */
    '\x01','\x7d','\x1d','P','C','I','_','C','O','N','F','I','G',
/* 0x1941d = "VINF_CR_DIGEST_DEPRECATED" */
    '\x0e','\x24','\xbe','D','E','P','R','E','C','A','T','E','D',
/* 0x1942a = "VERR_IS_A_SYMLINK" */
    '\x01','I','S','_','A','_','S','Y','M','L','I','N','K',
/* 0x19437 = "VERR_SHCLPB_NO_DATA" */
    '\x01','S','H','C','L','P','B','_','\x60','D','A','T','A',
/* 0x19444 = "VERR_NET_NO_NETWORK" */
    '\x01','N','E','T','_','\x60','N','E','T','W','O','R','K',
/* 0x19451 = "The value is not an integer." */
    '\x03','\xf5','\x0b','\x08','\x87','i','n','t','e','g','e','r','.',
/* 0x1945e = "VERR_VD_VMDK_INVALID_WRITE" */
    '\x01','\xff','V','M','D','K','_','\x05','W','R','I','T','E',
/* 0x1946b = "VINF_IEM_REEXEC_JUMP" */
    '\x0e','\x9c','R','E','E','X','E','C','_','J','U','M','P',
/* 0x19478 = "VERR_SUPLIB_STAT_ENUM_FAILED" */
    '\x01','\xd6','S','T','A','T','_','E','N','U','M','_','\x17',
/* 0x19485 = "VERR_SUPLIB_PATH_TOO_SHORT" */
    '\x01','\xd6','P','A','T','H','_','\x1a','S','H','O','R','T',
/* 0x19492 = "VERR_ISOMK_IPE_DESC_COUNT" */
    '\x01','\x22','\x14','D','E','S','C','_','C','O','U','N','T',
/* 0x1949f = "Recompiler: Too many labels." */
    '\x13','T','o','o',' ','\xb4','l','a','b','e','l','s','.',
/* 0x194ac = "VERR_SSM_STATE_GREW_TOO_BIG" */
    '\x01','\xb0','\xf1','_','G','R','E','W','_','\x1a','B','I','G',
/* 0x194b9 = "VERR_DRIVE_LOCKED" */
    '\x01','D','R','I','V','E','_','L','O','C','K','E','D',
/* 0x194c6 = "VERR_SVM_VMEXIT_FAILED" */
    '\x01','S','V','M','_','V','M','E','X','I','T','_','\x17',
/* 0x194d3 = "VERR_NOT_IMPLEMENTED" */
    '\x01','\x06','I','M','P','L','E','M','E','N','T','E','D',
/* 0x194e0 = "VERR_ADDRESS_TOO_BIG" */
    '\x01','A','D','D','R','E','S','S','_','\x1a','B','I','G',
/* 0x194ed = "VERR_GIM_NOT_ENABLED" */
    '\x01','G','I','M','_','\x06','E','N','A','B','L','E','D',
/* 0x194fa = "Generic driver structure version mismatch." */
    '\xa6','\xc5','\xec','\xcf','m','i','s','m','a','t','c','h','.',
/* 0x19507 = "VINF_LOG_DISABLED" */
    '\x0e','L','O','G','_','D','I','S','A','B','L','E','D',
/* 0x19514 = "VINF_GVM_NOT_BLOCKED" */
    '\x0e','G','V','M','_','\x06','B','L','O','C','K','E','D',
/* 0x19521 = "The VFS object type is not known." */
    '\x03','\x8d',' ','\xa8','\xf3','\x0b','\x08','k','n','o','w','n','.',
/* 0x1952e = "VERR_SUPDRV_VTG_STRING_TOO_LONG" */
    '\x01','\x90','V','T','G','_','\xd5','_','\x1a','L','O','N','G',
/* 0x1953b = "VERR_GMM_CHUNK_NOT_FOUND" */
    '\x01','G','M','M','_','C','H','U','N','K','_','\x06','\x2a',
/* 0x19548 = "Unable to find patch." */
    '\xe0','\x0a','f','i','n','d',' ','p','a','t','c','h','.',
/* 0x19555 = "VERR_XAR_BAD_DIGEST_LENGTH" */
    '\x01','X','A','R','_','\x1d','\xbe','L','E','N','G','T','H',
/* 0x19562 = "VINF_NOT_IMPLEMENTED" */
    '\x0e','\x06','I','M','P','L','E','M','E','N','T','E','D',
/* 0x1956f = "VERR_SVM_DISABLED" */
    '\x01','S','V','M','_','D','I','S','A','B','L','E','D',
/* 0x1957c = "VERR_PDM_NOT_PCI_DEVICE" */
    '\x01','\x7d','\x06','P','C','I','_','D','E','V','I','C','E',
/* 0x19589 = "verification " */
    'v','e','r','i','f','i','c','a','t','i','o','n',' ',
/* 0x19596 = "Internal processing error #3 in the IEM code." */
    '\x07','\x04','\x09','#','3',' ','\x0f','\x02','I','E','M',' ','\x84',
/* 0x195a3 = "VWRN_NO_TRANSLATION" */
    '\xe6','\x60','T','R','A','N','S','L','A','T','I','O','N',
/* 0x195b0 = "VERR_URI_NOT_FILE_SCHEME" */
    '\x01','U','R','I','_','\x06','\xab','S','C','H','E','M','E',
/* 0x195bd = "No route to host." */
    '\xdf','r','o','u','t','e',' ','\x0a','h','o','s','t','.',
/* 0x195ca = "VERR_HTTP_HOST_NOT_FOUND" */
    '\x01','H','T','T','P','_','H','O','S','T','_','\x06','\x2a',
/* 0x195d7 = "Bad tree height." */
    '\x9f','t','r','e','e',' ','h','e','i','g','h','t','.',
/* 0x195e4 = "VERR_VD_DMG_INVALID_HEADER" */
    '\x01','\xff','D','M','G','_','\x05','H','E','A','D','E','R',
/* 0x195f1 = "VERR_NO_TRANSLATION" */
    '\x01','\x60','T','R','A','N','S','L','A','T','I','O','N',
/* 0x195fe = "Recompiler: Label internal processing error #3." */
    '\x13','L','a','b','e','l',' ','\x16','\x04','\x09','#','3','.',
/* 0x1960b = "VINF_ALREADY_INITIALIZED" */
    '\x0e','\x9b','I','N','I','T','I','A','L','I','Z','E','D',
/* 0x19618 = "Empty string." */
    'E','m','p','t','y',' ','s','t','r','i','n','g','.',
/* 0x19625 = "VINF_SEM_BAD_CONTEXT" */
    '\x0e','S','E','M','_','\x1d','C','O','N','T','E','X','T',
/* 0x19632 = "Verification " */
    'V','e','r','i','f','i','c','a','t','i','o','n',' ',
/* 0x1963f = "VINF_EM_DBG_EVENT" */
    '\x0e','E','M','_','D','B','G','_','E','V','E','N','T',
/* 0x1964c = "VERR_IO_SECTOR_NOT_FOUND" */
    '\x01','I','O','_','S','E','C','T','O','R','_','\x06','\x2a',
/* 0x19659 = "VINF_TAR_DIR_PATH" */
    '\x0e','T','A','R','_','D','I','R','_','P','A','T','H',
/* 0x19666 = "VERR_VFS_CHAIN_FOUR_ARGS" */
    '\x01','\x8d','_','\x8e','F','O','U','R','_','A','R','G','S',
/* 0x19673 = "VERR_NEM_NOT_AVAILABLE" */
    '\x01','\xee','_','\x06','A','V','A','I','L','A','B','L','E',
/* 0x19680 = "VERR_VD_VDI_INVALID_HEADER" */
    '\x01','\xff','V','D','I','_','\x05','H','E','A','D','E','R',
/* 0x1968d = "Bad VTG header - misc." */
    '\x9f','V','T','G',' ','\xb3','-',' ','m','i','s','c','.',
/* 0x1969a = "VERR_VFS_CHAIN_EMPTY_ARG" */
    '\x01','\x8d','_','\x8e','E','M','P','T','Y','_','A','R','G',
/* 0x196a7 = "IOMMU device is not present." */
    '\xfd',' ','\xa3','\x0b','\x08','p','r','e','s','e','n','t','.',
/* 0x196b4 = "VERR_SUPLIB_PATH_NOT_CLEAN" */
    '\x01','\xd6','P','A','T','H','_','\x06','C','L','E','A','N',
/* 0x196c1 = "VERR_SUP_VP_TOO_MANY_SECTIONS" */
    '\x01','\x95','\xbd','\x1a','\xac','S','E','C','T','I','O','N','S',
/* 0x196ce = "VWRN_DBGC_ALREADY_REGISTERED" */
    '\xe6','\xfc','\x9b','R','E','G','I','S','T','E','R','E','D',
/* 0x196db = "VERR_VD_UNKNOWN_CFG_VALUES" */
    '\x01','\xff','\x91','C','F','G','_','V','A','L','U','E','S',
/* 0x196e8 = "VERR_IEM_EMIT_BAD_MEM_SIZE" */
    '\x01','\x9c','E','M','I','T','_','\x1d','M','E','M','_','\xf9',
/* 0x196f5 = "VERR_VFS_CHAIN_FIVE_ARGS" */
    '\x01','\x8d','_','\x8e','F','I','V','E','_','A','R','G','S',
/* 0x19702 = "VERR_IOMMU_DTE_READ_FAILED" */
    '\x01','\xfd','_','D','T','E','_','R','E','A','D','_','\x17',
/* 0x1970f = "VERR_RT_REQUEST_STATE" */
    '\x01','R','T','_','R','E','Q','U','E','S','T','_','\xf1',
/* 0x1971c = "Internal processing error # in the PDM device code." */
    '\x07','\x04','\x09','#',' ','\x0f','\x02','P','D','M',' ','\xa3','\x84',
/* 0x19729 = "VERR_ISOFS_TOO_MANY_PART_MAPS" */
    '\x01','\x97','\x1a','\xac','P','A','R','T','_','M','A','P','S',
/* 0x19736 = "Generic device structure version mismatch." */
    '\xa6','\xa3','\xec','\xcf','m','i','s','m','a','t','c','h','.',
/* 0x19743 = "Invalid HM64ON32OP value." */
    '\x0c','H','M','6','4','O','N','3','2','O','P',' ','\xe8',
/* 0x19750 = "Failed to map the guest PML4." */
    '\x8b','\x0a','m','a','p',' ','\x02','\xbb','P','M','L','4','.',
/* 0x1975d = "Send aborted." */
    'S','e','n','d',' ','a','b','o','r','t','e','d','.',
/* 0x1976a = "VERR_ISOMK_IMPORT_BAD_SUP_VOL_DESC" */
    '\x01','\x22','\x83','\x1d','\x95','V','O','L','_','D','E','S','C',
/* 0x19777 = "The specified path is a root path (hardening)." */
    '\x03','\x18','\xd0','\x0b','a',' ','r','o','o','t',' ','\xd0','\xae',
/* 0x19784 = "VERR_DBGC_PARSE_COMMAND_NOT_FOUND" */
    '\x01','\xfc','\xe4','C','O','M','M','A','N','D','_','\x06','\x2a',
/* 0x19791 = "VERR_SSM_UNIT_EXISTS" */
    '\x01','\xb0','U','N','I','T','_','E','X','I','S','T','S',
/* 0x1979e = "VERR_LDRVI_READ_ERROR_HASH" */
    '\x01','\xf4','R','E','A','D','_','\x1b','_','H','A','S','H',
/* 0x197ab = "Not ROM page." */
    'N','o','t',' ','R','O','M',' ','p','a','g','e','.',
/* 0x197b8 = "VWRN_DBGC_CMD_PENDING" */
    '\xe6','\xfc','C','M','D','_','P','E','N','D','I','N','G',
/* 0x197c5 = "VERR_TOO_MANY_OPEN_FILES" */
    '\x01','\x1a','\xac','O','P','E','N','_','F','I','L','E','S',
/* 0x197d2 = "Uneven input." */
    'U','n','e','v','e','n',' ','i','n','p','u','t','.',
/* 0x197df = "VERR_VD_RAW_INVALID_HEADER" */
    '\x01','\xff','R','A','W','_','\x05','H','E','A','D','E','R',
/* 0x197ec = "Recompiler: Label internal processing error #4." */
    '\x13','L','a','b','e','l',' ','\x16','\x04','\x09','#','4','.',
/* 0x197f9 = "VERR_GMM_IS_NOT_SANE" */
    '\x01','G','M','M','_','I','S','_','\x06','S','A','N','E',
/* 0x19806 = "VERR_VFS_CHAIN_TAKES_FSS" */
    '\x01','\x8d','_','\x8e','T','A','K','E','S','_','F','S','S',
/* 0x19813 = "VERR_CR_PKCS7_OSSL_D2I_FAILED" */
    '\x01','\x24','\xe5','O','S','S','L','_','D','2','I','_','\x17',
/* 0x19820 = "VERR_CR_KEY_UNSUPPORTED_CIPHER" */
    '\x01','\x24','K','E','Y','_','\x1c','C','I','P','H','E','R',
/* 0x1982d = "VERR_SUPLIB_OWNER_NOT_ROOT" */
    '\x01','\xd6','O','W','N','E','R','_','\x06','R','O','O','T',
/* 0x1983a = "VERR_DBGC_PARSE_INVALID_OPERATION" */
    '\x01','\xfc','\xe4','\x05','O','P','E','R','A','T','I','O','N',
/* 0x19847 = "VERR_IOM_INVALID_MMIO_RANGE" */
    '\x01','I','O','M','_','\x05','\xd3','_','R','A','N','G','E',
/* 0x19854 = "Internal processing error #7 in the IEM code." */
    '\x07','\x04','\x09','#','7',' ','\x0f','\x02','I','E','M',' ','\x84',
/* 0x19861 = "VERR_LDR_MISMATCH_NATIVE" */
    '\x01','L','D','R','_','\x19','_','N','A','T','I','V','E',
/* 0x1986e = "The operation was cancelled." */
    '\x03','\x96','\x11','c','a','n','c','e','l','l','e','d','.',
/* 0x1987b = "VWRN_NO_DIRENT_INFO" */
    '\xe6','\x60','D','I','R','E','N','T','_','I','N','F','O',
/* 0x19888 = "VERR_GMM_PAGE_NOT_SHARED" */
    '\x01','G','M','M','_','\xdc','\x06','S','H','A','R','E','D',
/* 0x19895 = "The specified path is a directory and not a file (hardening)." */
    '\x03','\x18','\xd0','\x0b','a',' ','\x25','\x9a','\x08','a',' ','\x1f','\xae',
/* 0x198a2 = "No active trap." */
    '\xdf','a','c','t','i','v','e',' ','t','r','a','p','.',
/* 0x198af = "VERR_CR_DIGEST_DEPRECATED" */
    '\x01','\x24','\xbe','D','E','P','R','E','C','A','T','E','D',
/* 0x198bc = "VERR_PGM_INVALID_PAGE_DIRECTORY" */
    '\x01','\x8c','\x05','\xdc','D','I','R','E','C','T','O','R','Y',
/* 0x198c9 = "VERR_VD_VHD_INVALID_HEADER" */
    '\x01','\xff','V','H','D','_','\x05','H','E','A','D','E','R',
/* 0x198d6 = "VERR_TIMER_ACTIVE" */
    '\x01','T','I','M','E','R','_','A','C','T','I','V','E',
/* 0x198e3 = "VERR_UNEVEN_INPUT" */
    '\x01','U','N','E','V','E','N','_','I','N','P','U','T',
/* 0x198f0 = "VERR_VM_DRIVER_VERSION_MISMATCH" */
    '\x01','\xcd','_','D','R','I','V','E','R','_','\xbc','_','\x19',
/* 0x198fd = "Unknow file type." */
    'U','n','k','n','o','w',' ','\x1f','t','y','p','e','.',
/* 0x1990a = "VERR_PGM_POOL_GET_PAGE_FAILED" */
    '\x01','\x8c','P','O','O','L','_','G','E','T','_','\xdc','\x17',
/* 0x19917 = "VERR_VD_GEN_INVALID_HEADER" */
    '\x01','\xff','G','E','N','_','\x05','H','E','A','D','E','R',
/* 0x19924 = "Failed to normalize ASN." */
    '\x8b','\x0a','n','o','r','m','a','l','i','z','e',' ','\xf6',
/* 0x19931 = "Recompiler: Label internal processing error #5." */
    '\x13','L','a','b','e','l',' ','\x16','\x04','\x09','#','5','.',
/* 0x1993e = "Internal processing error #6 in the IEM code." */
    '\x07','\x04','\x09','#','6',' ','\x0f','\x02','I','E','M',' ','\x84',
/* 0x1994b = "VERR_NEM_RING3_ONLY" */
    '\x01','\xee','_','R','I','N','G','3','_','O','N','L','Y',
/* 0x19958 = "VERR_OUT_OF_RANGE" */
    '\x01','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x19965 = "VERR_HTTP_ABORTED" */
    '\x01','H','T','T','P','_','A','B','O','R','T','E','D',
/* 0x19972 = "VERR_VM_REQUEST_INVALID_TYPE" */
    '\x01','\xcd','_','R','E','Q','U','E','S','T','_','\x05','\xb5',
/* 0x1997f = "The name is empty." */
    '\x03','n','a','m','e',' ','\x0b','e','m','p','t','y','.',
/* 0x1998c = "VERR_VFS_CHAIN_TOO_FEW_ARGS" */
    '\x01','\x8d','_','\x8e','\x1a','F','E','W','_','A','R','G','S',
/* 0x19999 = "VERR_CR_X509_TBSCERT_UNSUPPORTED_VERSION" */
    '\x01','\x24','\xb7','T','B','S','C','E','R','T','_','\x1c','\xbc',
/* 0x199a6 = "VERR_PGM_PHYS_NOT_MMIO2" */
    '\x01','\x8c','P','H','Y','S','_','\x06','M','M','I','O','2',
/* 0x199b3 = "Failed to patch the IDT." */
    '\x8b','\x0a','p','a','t','c','h',' ','\x02','I','D','T','.',
/* 0x199c0 = "Internal processing error #2 in the IEM code." */
    '\x07','\x04','\x09','#','2',' ','\x0f','\x02','I','E','M',' ','\x84',
/* 0x199cd = "VERR_DISK_INVALID_FORMAT" */
    '\x01','D','I','S','K','_','\x05','F','O','R','M','A','T',
/* 0x199da = "Recompiler: Label internal processing error #1." */
    '\x13','L','a','b','e','l',' ','\x16','\x04','\x09','#','1','.',
/* 0x199e7 = "VERR_ISOMK_IPE_FINALIZE_1" */
    '\x01','\x22','\x14','F','I','N','A','L','I','Z','E','_','1',
/* 0x199f4 = "Bad bundle data." */
    '\x9f','b','u','n','d','l','e',' ','d','a','t','a','.',
/* 0x19a01 = "VERR_MANIFEST_UNSUPPORTED_DIGEST_TYPE" */
    '\x01','M','A','N','I','F','E','S','T','_','\x1c','\xbe','\xb5',
/* 0x19a0e = "VERR_TOO_MANY_SEMAPHORES" */
    '\x01','\x1a','\xac','S','E','M','A','P','H','O','R','E','S',
/* 0x19a1b = "VERR_CR_X509_OSSL_D2I_FAILED" */
    '\x01','\x24','\xb7','O','S','S','L','_','D','2','I','_','\x17',
/* 0x19a28 = "VERR_DBGF_OWNER_BUSY" */
    '\x01','\xb9','_','O','W','N','E','R','_','B','U','S','Y',
/* 0x19a35 = "VERR_ISOMK_IPE_ROOT_SLASH" */
    '\x01','\x22','\x14','R','O','O','T','_','S','L','A','S','H',
/* 0x19a42 = "VERR_IOQUEUE_FULL" */
    '\x01','I','O','Q','U','E','U','E','_','F','U','L','L',
/* 0x19a4f = "Invalid port number." */
    '\x0c','p','o','r','t',' ','n','u','m','b','e','r','.',
/* 0x19a5c = "Internal processing error #1 in the IEM code." */
    '\x07','\x04','\x09','#','1',' ','\x0f','\x02','I','E','M',' ','\x84',
/* 0x19a69 = "VERR_PDM_CRITSECT_NOT_FOUND" */
    '\x01','\x7d','C','R','I','T','S','E','C','T','_','\x06','\x2a',
/* 0x19a76 = "VERR_IOQUEUE_BUSY" */
    '\x01','I','O','Q','U','E','U','E','_','B','U','S','Y',
/* 0x19a83 = "VINF_EM_RAW_TO_R3" */
    '\x0e','E','M','_','R','A','W','_','T','O','_','R','3',
/* 0x19a90 = "VERR_SUP_VP_SYSFER_DLL" */
    '\x01','\x95','\xbd','S','Y','S','F','E','R','_','D','L','L',
/* 0x19a9d = "Recompiler: Label internal processing error #6." */
    '\x13','L','a','b','e','l',' ','\x16','\x04','\x09','#','6','.',
/* 0x19aaa = "Send timeout." */
    'S','e','n','d',' ','t','i','m','e','o','u','t','.',
/* 0x19ab7 = "No more files found." */
    '\xdf','m','o','r','e',' ','f','i','l','e','s',' ','\x89',
/* 0x19ac4 = "VERR_VBGL_IOCTL_FAILED" */
    '\x01','V','B','G','L','_','I','O','C','T','L','_','\x17',
/* 0x19ad1 = "Unexpected VM exception." */
    '\x94','\xcd',' ','e','x','c','e','p','t','i','o','n','.',
/* 0x19ade = "Raw: Invalid image file type." */
    'R','a','w',':',' ','\x0c','\x26','\x1f','t','y','p','e','.',
/* 0x19aeb = "VERR_HM_WRONG_CPU" */
    '\x01','H','M','_','W','R','O','N','G','_','C','P','U',
/* 0x19af8 = "VERR_GMM_OUT_OF_MEMORY" */
    '\x01','G','M','M','_','O','U','T','_','O','F','_','\xb6',
/* 0x19b05 = "VERR_ASN1_INVALID_INTEGER_ENCODING" */
    '\x01','\xa2','\x05','I','N','T','E','G','E','R','_','\xc6',
/* 0x19b11 = "Internal VMX processing error no 2." */
    '\x07','V','M','X',' ','\x04','\x09','n','o',' ','2','.',
/* 0x19b1d = "encountered " */
    'e','n','c','o','u','n','t','e','r','e','d',' ',
/* 0x19b29 = "VERR_VMX_INVALID_VMXON_PTR" */
    '\x01','\xe2','\x05','V','M','X','O','N','_','P','T','R',
/* 0x19b35 = "Wrong file type." */
    'W','r','o','n','g',' ','\x1f','t','y','p','e','.',
/* 0x19b41 = "VERR_MM_HYPER_NO_MEMORY" */
    '\x01','M','M','_','H','Y','P','E','R','_','\x60','\xb6',
/* 0x19b4d = "VERR_SELM_HM_IPE" */
    '\x01','S','E','L','M','_','H','M','_','I','P','E',
/* 0x19b59 = "Internal processing error #1 in the HM code." */
    '\x07','\x04','\x09','#','1',' ','\x0f','\x02','H','M',' ','\x84',
/* 0x19b65 = "Unknown breakpoint." */
    '\xef','b','r','e','a','k','p','o','i','n','t','.',
/* 0x19b71 = "VERR_VUSB_NO_URB_MEMORY" */
    '\x01','V','U','S','B','_','\x60','U','R','B','_','\xb6',
/* 0x19b7d = "Generic no change error." */
    '\xa6','n','o',' ','c','h','a','n','g','e',' ','\x85',
/* 0x19b89 = "Internal VMX processing error no 1." */
    '\x07','V','M','X',' ','\x04','\x09','n','o',' ','1','.',
/* 0x19b95 = "Invalid tag length." */
    '\x0c','t','a','g',' ','l','e','n','g','t','h','.',
/* 0x19ba1 = "VERR_SSM_LOAD_MEMORY_SIZE_MISMATCH" */
    '\x01','\xb0','L','O','A','D','_','\xb6','_','\xf9','_','\x19',
/* 0x19bad = "Internal SVM processing error no 3." */
    '\x07','S','V','M',' ','\x04','\x09','n','o',' ','3','.',
/* 0x19bb9 = "VERR_DIS_INVALID_OPCODE" */
    '\x01','D','I','S','_','\x05','O','P','C','O','D','E',
/* 0x19bc5 = "VERR_LDRVI_READ_ERROR_HDR" */
    '\x01','\xf4','R','E','A','D','_','\x1b','_','H','D','R',
/* 0x19bd1 = "Not more data in ASN." */
    'N','o','t',' ','m','o','r','e',' ','\x9d','\x0f','\xf6',
/* 0x19bdd = "VERR_PDM_DEVICE_VERSION_MISMATCH" */
    '\x01','\x7d','D','E','V','I','C','E','_','\xbc','_','\x19',
/* 0x19be9 = "VERR_ISOFS_ICB_TOO_SMALL" */
    '\x01','\x97','I','C','B','_','\x1a','S','M','A','L','L',
/* 0x19bf5 = "VWRN_VRDP_PDU_NOT_SUPPORTED" */
    '\xe6','V','R','D','P','_','P','D','U','_','\x06','\x82',
/* 0x19c01 = "Unfinished code." */
    'U','n','f','i','n','i','s','h','e','d',' ','\x84',
/* 0x19c0d = "Unsupported key format." */
    '\x98','k','e','y',' ','f','o','r','m','a','t','.',
/* 0x19c19 = "VERR_ZIP_UNSUPPORTED_METHOD" */
    '\x01','Z','I','P','_','\x1c','M','E','T','H','O','D',
/* 0x19c25 = "VERR_DBGF_NOT_ATTACHED" */
    '\x01','\xb9','_','\x06','A','T','T','A','C','H','E','D',
/* 0x19c31 = "Unsupported fixup type." */
    '\x98','f','i','x','u','p',' ','t','y','p','e','.',
/* 0x19c3d = "VERR_MANIFEST_FILE_MISMATCH" */
    '\x01','M','A','N','I','F','E','S','T','_','\xab','\x19',
/* 0x19c49 = "VERR_ASN1_INVALID_BOOLEAN_ENCODING" */
    '\x01','\xa2','\x05','B','O','O','L','E','A','N','_','\xc6',
/* 0x19c55 = "End of string." */
    'E','n','d',' ','\x15','s','t','r','i','n','g','.',
/* 0x19c61 = "Internal SVM processing error no 2." */
    '\x07','S','V','M',' ','\x04','\x09','n','o',' ','2','.',
/* 0x19c6d = "VERR_TAR_UNKNOWN_TYPE_FLAG" */
    '\x01','T','A','R','_','\x91','\xb5','_','F','L','A','G',
/* 0x19c79 = "Internal processing error #1 in TRPM." */
    '\x07','\x04','\x09','#','1',' ','\x0f','T','R','P','M','.',
/* 0x19c85 = "Internal processing error #1 in SSM code." */
    '\x07','\x04','\x09','#','1',' ','\x0f','S','S','M',' ','\x84',
/* 0x19c91 = "VERR_PGM_HANDY_PAGE_IPE" */
    '\x01','\x8c','H','A','N','D','Y','_','\xdc','I','P','E',
/* 0x19c9d = "VERR_PDM_NO_USB_PORTS" */
    '\x01','\x7d','\x60','U','S','B','_','P','O','R','T','S',
/* 0x19ca9 = "VERR_ISOFS_DESC_CRC_MISMATCH" */
    '\x01','\x97','D','E','S','C','_','C','R','C','_','\x19',
/* 0x19cb5 = "Active trap." */
    'A','c','t','i','v','e',' ','t','r','a','p','.',
/* 0x19cc1 = "Unsupported " */
    'U','n','s','u','p','p','o','r','t','e','d',' ',
/* 0x19ccd = "VERR_NET_NOT_SOCKET" */
    '\x01','N','E','T','_','\x06','S','O','C','K','E','T',
/* 0x19cd9 = "VINF_EM_DBG_STOP" */
    '\x0e','E','M','_','D','B','G','_','S','T','O','P',
/* 0x19ce5 = "VERR_VFS_CHAIN_SIX_ARGS" */
    '\x01','\x8d','_','\x8e','S','I','X','_','A','R','G','S',
/* 0x19cf1 = "VTG string is too long." */
    'V','T','G',' ','\xf2','\x0b','\x9e','l','o','n','g','.',
/* 0x19cfd = "VERR_PDM_HIF_OPEN_FAILED" */
    '\x01','\x7d','H','I','F','_','O','P','E','N','_','\x17',
/* 0x19d09 = "VERR_HTTP_CURL_ERROR" */
    '\x01','H','T','T','P','_','C','U','R','L','_','\x1b',
/* 0x19d15 = "VINF_NEM_FLUSH_TLB" */
    '\x0e','\xee','_','F','L','U','S','H','_','T','L','B',
/* 0x19d21 = "Internal processing error #2 in the HM code." */
    '\x07','\x04','\x09','#','2',' ','\x0f','\x02','H','M',' ','\x84',
/* 0x19d2d = "Unknown hash digest type." */
    '\xef','h','a','s','h',' ','\xd7','t','y','p','e','.',
/* 0x19d39 = "NEM failed to set TSC." */
    '\xee',' ','\x99','\x0a','s','e','t',' ','T','S','C','.',
/* 0x19d45 = "Encountered " */
    'E','n','c','o','u','n','t','e','r','e','d',' ',
/* 0x19d51 = "VERR_PDM_DEVINS_VERSION_MISMATCH" */
    '\x01','\x7d','D','E','V','I','N','S','_','\xbc','_','\x19',
/* 0x19d5d = "VERR_VM_REQUEST_STATE" */
    '\x01','\xcd','_','R','E','Q','U','E','S','T','_','\xf1',
/* 0x19d69 = "VERR_DWARF_BAD_INFO" */
    '\x01','D','W','A','R','F','_','\x1d','I','N','F','O',
/* 0x19d75 = "Internal processing error in the DWARF code." */
    '\x07','\x04','\x09','\x0f','\x02','D','W','A','R','F',' ','\x84',
/* 0x19d81 = "Bad VTG string." */
    '\x9f','V','T','G',' ','s','t','r','i','n','g','.',
/* 0x19d8d = "Internal processing error #1 in CFGM." */
    '\x07','\x04','\x09','#','1',' ','\x0f','C','F','G','M','.',
/* 0x19d99 = "Internal SVM processing error no 4." */
    '\x07','S','V','M',' ','\x04','\x09','n','o',' ','4','.',
/* 0x19da5 = "Recompiler: " */
    'R','e','c','o','m','p','i','l','e','r',':',' ',
/* 0x19db1 = "VERR_PGM_INVALID_PDPE_ADDR" */
    '\x01','\x8c','\x05','P','D','P','E','_','A','D','D','R',
/* 0x19dbd = "The specified path was not clean (hardening)." */
    '\x03','\x18','\xd0','\x11','\x08','c','l','e','a','n',' ','\xae',
/* 0x19dc9 = "Invalid session ID." */
    '\x0c','s','e','s','s','i','o','n',' ','I','D','.',
/* 0x19dd5 = "VERR_PKZIP_NO_EOCB" */
    '\x01','P','K','Z','I','P','_','\x60','E','O','C','B',
/* 0x19de1 = "VERR_IEM_DBGINFO_IPE_1" */
    '\x01','\x9c','D','B','G','I','N','F','O','_','\x14','1',
/* 0x19ded = "VERR_IEM_DBGINFO_IPE_2" */
    '\x01','\x9c','D','B','G','I','N','F','O','_','\x14','2',
/* 0x19df9 = "VERR_NET_PRINT_ERROR" */
    '\x01','N','E','T','_','P','R','I','N','T','_','\x1b',
/* 0x19e05 = "VINF_GVM_YIELDED" */
    '\x0e','G','V','M','_','Y','I','E','L','D','E','D',
/* 0x19e11 = "VERR_NET_PATH_NOT_FOUND" */
    '\x01','N','E','T','_','P','A','T','H','_','\x06','\x2a',
/* 0x19e1d = "VERR_CR_PKCS7_DIGEST_CREATE_ERROR" */
    '\x01','\x24','\xe5','\xbe','C','R','E','A','T','E','_','\x1b',
/* 0x19e29 = "VERR_PIPE_NOT_WRITE" */
    '\x01','P','I','P','E','_','\x06','W','R','I','T','E',
/* 0x19e35 = "Broken pipe." */
    'B','r','o','k','e','n',' ','p','i','p','e','.',
/* 0x19e41 = "VERR_PATM_HM_IPE" */
    '\x01','P','A','T','M','_','H','M','_','I','P','E',
/* 0x19e4d = "Internal processing error #4 in the HM code." */
    '\x07','\x04','\x09','#','4',' ','\x0f','\x02','H','M',' ','\x84',
/* 0x19e59 = "VWRN_NUMBER_TOO_BIG" */
    '\xe6','N','U','M','B','E','R','_','\x1a','B','I','G',
/* 0x19e65 = "Invalid RT request packet." */
    '\x0c','R','T',' ','\xaa','p','a','c','k','e','t','.',
/* 0x19e71 = "Internal VMX processing error no 5." */
    '\x07','V','M','X',' ','\x04','\x09','n','o',' ','5','.',
/* 0x19e7d = "VERR_IO_BAD_COMMAND" */
    '\x01','I','O','_','\x1d','C','O','M','M','A','N','D',
/* 0x19e89 = "Internal processing error #3 in the HM code." */
    '\x07','\x04','\x09','#','3',' ','\x0f','\x02','H','M',' ','\x84',
/* 0x19e95 = "VERR_CR_X509_NOT_VERIFIED" */
    '\x01','\x24','\xb7','\x06','V','E','R','I','F','I','E','D',
/* 0x19ea1 = "VERR_TAR_SIZE_NOT_ZERO" */
    '\x01','T','A','R','_','\xf9','_','\x06','Z','E','R','O',
/* 0x19ead = "The I/O request ID was not found." */
    '\x03','I','/','O',' ','\xaa','I','D',' ','\x11','\x08','\x89',
/* 0x19eb9 = "VERR_VD_DMG_XML_PARSE_ERROR" */
    '\x01','\xff','D','M','G','_','X','M','L','_','\xe4','\x1b',
/* 0x19ec5 = "VERR_LDRVI_BAD_MZ_OFFSET" */
    '\x01','\xf4','\x1d','M','Z','_','O','F','F','S','E','T',
/* 0x19ed1 = "Internal processing error #3 in TRPM." */
    '\x07','\x04','\x09','#','3',' ','\x0f','T','R','P','M','.',
/* 0x19edd = "Invalid key length." */
    '\x0c','k','e','y',' ','l','e','n','g','t','h','.',
/* 0x19ee9 = "VERR_SSM_ALREADY_CANCELLED" */
    '\x01','\xb0','\x9b','C','A','N','C','E','L','L','E','D',
/* 0x19ef5 = "VERR_S3_CANCELED" */
    '\x01','S','3','_','C','A','N','C','E','L','E','D',
/* 0x19f01 = "VERR_AOUT_EXE_NOT_SUPPORTED" */
    '\x01','A','O','U','T','_','E','X','E','_','\x06','\x82',
/* 0x19f0d = "VERR_PGM_DYNMAP_IPE" */
    '\x01','\x8c','D','Y','N','M','A','P','_','I','P','E',
/* 0x19f19 = "Bad executable." */
    '\x9f','e','x','e','c','u','t','a','b','l','e','.',
/* 0x19f25 = "Signature verification failed." */
    'S','i','g','n','a','t','u','r','e',' ','\xf8','\x7b',
/* 0x19f31 = "VERR_VD_UNKNOWN_INTERFACE" */
    '\x01','\xff','\x91','I','N','T','E','R','F','A','C','E',
/* 0x19f3d = "VERR_CSAM_HM_IPE" */
    '\x01','C','S','A','M','_','H','M','_','I','P','E',
/* 0x19f49 = "VERR_NO_MORE_FILES" */
    '\x01','\x60','M','O','R','E','_','F','I','L','E','S',
/* 0x19f55 = "VERR_LDRVI_NO_MEMORY_PARSE_OUTPUT" */
    '\x01','\xf4','\x60','\xb6','_','\xe4','O','U','T','P','U','T',
/* 0x19f61 = "VERR_NEM_FLUSH_TLB" */
    '\x01','\xee','_','F','L','U','S','H','_','T','L','B',
/* 0x19f6d = "Process Verification Failure: No KERNE32." */
    '\x1e','\x0d','\x12','\xdf','K','E','R','N','E','3','2','.',
/* 0x19f79 = "VERR_DISK_CHANGE" */
    '\x01','D','I','S','K','_','C','H','A','N','G','E',
/* 0x19f85 = "Internal processing error #5 in the HM code." */
    '\x07','\x04','\x09','#','5',' ','\x0f','\x02','H','M',' ','\x84',
/* 0x19f91 = "Generic VM-entry failure." */
    '\xa6','\xcd','-','\xc8','f','a','i','l','u','r','e','.',
/* 0x19f9d = "VERR_BAD_EXE_FORMAT" */
    '\x01','\x1d','E','X','E','_','F','O','R','M','A','T',
/* 0x19fa9 = "VERR_SUPDRV_SERVICE_NOT_FOUND" */
    '\x01','\x90','S','E','R','V','I','C','E','_','\x06','\x2a',
/* 0x19fb5 = "VERR_BROKEN_PIPE" */
    '\x01','B','R','O','K','E','N','_','P','I','P','E',
/* 0x19fc1 = "VERR_SUPLIB_NOT_DIR_NOT_FILE" */
    '\x01','\xd6','\x06','D','I','R','_','\x06','F','I','L','E',
/* 0x19fcd = "VERR_HTTP_INIT_FAILED" */
    '\x01','H','T','T','P','_','I','N','I','T','_','\x17',
/* 0x19fd9 = "VINF_LOG_NO_LOGGER" */
    '\x0e','L','O','G','_','\x60','L','O','G','G','E','R',
/* 0x19fe5 = "VERR_HM_CONFIG_MISMATCH" */
    '\x01','H','M','_','C','O','N','F','I','G','_','\x19',
/* 0x19ff1 = "VERR_SUPDRV_TSC_READ_FAILED" */
    '\x01','\x90','T','S','C','_','R','E','A','D','_','\x17',
/* 0x19ffd = "VERR_LDRELF_EXEC" */
    '\x01','L','D','R','E','L','F','_','E','X','E','C',
/* 0x1a009 = "Operation not supported." */
    'O','p','e','r','a','t','i','o','n',' ','\x08','\xa4',
/* 0x1a015 = "VERR_VFS_UNSUPPORTED_CREATE_TYPE" */
    '\x01','\x8d','_','\x1c','C','R','E','A','T','E','_','\xb5',
/* 0x1a021 = "The request was canceled." */
    '\x03','\xaa','\x11','c','a','n','c','e','l','e','d','.',
/* 0x1a02d = "NEM is not enabled." */
    '\xee',' ','\x0b','\x08','e','n','a','b','l','e','d','.',
/* 0x1a039 = "VERR_PGM_HANDLER_NOT_FOUND" */
    '\x01','\x8c','H','A','N','D','L','E','R','_','\x06','\x2a',
/* 0x1a045 = "VERR_INTERRUPTED" */
    '\x01','I','N','T','E','R','R','U','P','T','E','D',
/* 0x1a051 = "Bad DWARF info." */
    '\x9f','D','W','A','R','F',' ','i','n','f','o','.',
/* 0x1a05d = "The ICB for is too big." */
    '\x03','I','C','B',' ','\x10','\x0b','\x9e','b','i','g','.',
/* 0x1a069 = "VERR_VUSB_NO_PORTS" */
    '\x01','V','U','S','B','_','\x60','P','O','R','T','S',
/* 0x1a075 = "Internal processing error #2 in TRPM." */
    '\x07','\x04','\x09','#','2',' ','\x0f','T','R','P','M','.',
/* 0x1a081 = "VERR_CR_SPC_UNKNOWN_DIGEST_ALGO" */
    '\x01','\x24','S','P','C','_','\x91','\xbe','A','L','G','O',
/* 0x1a08d = "VERR_CPU_OFFLINE" */
    '\x01','C','P','U','_','O','F','F','L','I','N','E',
/* 0x1a099 = "VERR_NUMBER_TOO_BIG" */
    '\x01','N','U','M','B','E','R','_','\x1a','B','I','G',
/* 0x1a0a5 = "VERR_DND_GUEST_ERROR" */
    '\x01','D','N','D','_','G','U','E','S','T','_','\x1b',
/* 0x1a0b1 = "Internal processing error #1 in the DBGF register code." */
    '\x07','\x04','\x09','#','1',' ','\x0f','\x02','\xb9',' ','\xeb','\x84',
/* 0x1a0bd = "VERR_DBGC_PARSE_UNEXPECTED_OPERATOR" */
    '\x01','\xfc','\xe4','\x88','O','P','E','R','A','T','O','R',
/* 0x1a0c9 = "Generic BER parse error." */
    '\xa6','B','E','R',' ','p','a','r','s','e',' ','\x85',
/* 0x1a0d5 = "VERR_NEM_MISSING_FEATURE" */
    '\x01','\xee','_','\xc4','_','F','E','A','T','U','R','E',
/* 0x1a0e1 = "VERR_VFS_CHAIN_TWO_ARGS" */
    '\x01','\x8d','_','\x8e','T','W','O','_','A','R','G','S',
/* 0x1a0ed = "The specified path is too short (hardening)." */
    '\x03','\x18','\xd0','\x0b','\x9e','s','h','o','r','t',' ','\xae',
/* 0x1a0f9 = "VERR_PDM_DEVHLP_VERSION_MISMATCH" */
    '\x01','\x7d','D','E','V','H','L','P','_','\xbc','_','\x19',
/* 0x1a105 = "VERR_PDM_DRVINS_VERSION_MISMATCH" */
    '\x01','\x7d','D','R','V','I','N','S','_','\xbc','_','\x19',
/* 0x1a111 = "UNSUPPORTED_" */
    'U','N','S','U','P','P','O','R','T','E','D','_',
/* 0x1a11d = "VERR_CR_PKCS7_GENERIC_ERROR" */
    '\x01','\x24','\xe5','G','E','N','E','R','I','C','_','\x1b',
/* 0x1a129 = "VERR_TRPM_HM_IPE" */
    '\x01','T','R','P','M','_','H','M','_','I','P','E',
/* 0x1a135 = "instruction " */
    'i','n','s','t','r','u','c','t','i','o','n',' ',
/* 0x1a141 = "certificate " */
    'c','e','r','t','i','f','i','c','a','t','e',' ',
/* 0x1a14d = "VERR_CFGM_NOT_BYTES" */
    '\x01','C','F','G','M','_','\x06','B','Y','T','E','S',
/* 0x1a159 = "VERR_IS_A_SOCKET" */
    '\x01','I','S','_','A','_','S','O','C','K','E','T',
/* 0x1a165 = "VINF_DBGF_BP_ALREADY_EXIST" */
    '\x0e','\xb9','_','B','P','_','\x9b','E','X','I','S','T',
/* 0x1a171 = "VERR_VD_IOCTX_HALT" */
    '\x01','\xff','I','O','C','T','X','_','H','A','L','T',
/* 0x1a17d = "Internal SVM processing error no 1." */
    '\x07','S','V','M',' ','\x04','\x09','n','o',' ','1','.',
/* 0x1a189 = "VERR_CACHE_EMPTY" */
    '\x01','C','A','C','H','E','_','E','M','P','T','Y',
/* 0x1a195 = "(hardening)." */
    '(','h','a','r','d','e','n','i','n','g',')','.',
/* 0x1a1a1 = "VERR_PDM_USBDEV_VERSION_MISMATCH" */
    '\x01','\x7d','U','S','B','D','E','V','_','\xbc','_','\x19',
/* 0x1a1ad = "VINF_INTERRUPTED" */
    '\x0e','I','N','T','E','R','R','U','P','T','E','D',
/* 0x1a1b9 = "Internal processing error #2 in the DBGF register code." */
    '\x07','\x04','\x09','#','2',' ','\x0f','\x02','\xb9',' ','\xeb','\x84',
/* 0x1a1c5 = "VERR_MANIFEST_DIGEST_MISMATCH" */
    '\x01','M','A','N','I','F','E','S','T','_','\xbe','\x19',
/* 0x1a1d1 = "The URI is empty." */
    '\x03','U','R','I',' ','\x0b','e','m','p','t','y','.',
/* 0x1a1dd = "Expected primitive ASN." */
    '\xb8','p','r','i','m','i','t','i','v','e',' ','\xf6',
/* 0x1a1e9 = "VERR_SSM_NO_LOAD_EXEC" */
    '\x01','\xb0','\x60','L','O','A','D','_','E','X','E','C',
/* 0x1a1f5 = "Internal SVM processing error no 5." */
    '\x07','S','V','M',' ','\x04','\x09','n','o',' ','5','.',
/* 0x1a201 = "VERR_SUPLIB_PATH_TOO_LONG" */
    '\x01','\xd6','P','A','T','H','_','\x1a','L','O','N','G',
/* 0x1a20d = "VERR_DBG_LINE_NOT_FOUND" */
    '\x01','D','B','G','_','L','I','N','E','_','\x06','\x2a',
/* 0x1a219 = "Internal processing error #3 in SSM code." */
    '\x07','\x04','\x09','#','3',' ','\x0f','S','S','M',' ','\x84',
/* 0x1a225 = "Certificate " */
    'C','e','r','t','i','f','i','c','a','t','e',' ',
/* 0x1a231 = "VERR_CFG_INVALID_FORMAT" */
    '\x01','C','F','G','_','\x05','F','O','R','M','A','T',
/* 0x1a23d = "VERR_CR_X509_GENERIC_ERROR" */
    '\x01','\x24','\xb7','G','E','N','E','R','I','C','_','\x1b',
/* 0x1a249 = "VERR_NET_HOST_NOT_FOUND" */
    '\x01','N','E','T','_','H','O','S','T','_','\x06','\x2a',
/* 0x1a255 = "VINF_HGCM_SAVE_STATE" */
    '\x0e','H','G','C','M','_','S','A','V','E','_','\xf1',
/* 0x1a261 = "Is a socket." */
    'I','s',' ','a',' ','s','o','c','k','e','t','.',
/* 0x1a26d = "VERR_APIC_INIT_FAILED" */
    '\x01','A','P','I','C','_','I','N','I','T','_','\x17',
/* 0x1a279 = "VERR_INVALID_SESSION_ID" */
    '\x01','\x05','S','E','S','S','I','O','N','_','I','D',
/* 0x1a285 = "VERR_URI_INVALID_SCHEME" */
    '\x01','U','R','I','_','\x05','S','C','H','E','M','E',
/* 0x1a291 = "VERR_VD_DISCARD_NOT_SUPPORTED" */
    '\x01','\xff','D','I','S','C','A','R','D','_','\x06','\x82',
/* 0x1a29d = "VERR_XAR_BAD_FILE_INODE" */
    '\x01','X','A','R','_','\x1d','\xab','I','N','O','D','E',
/* 0x1a2a9 = "VERR_WRONG_ORDER" */
    '\x01','W','R','O','N','G','_','O','R','D','E','R',
/* 0x1a2b5 = "Internal VMX processing error no 3." */
    '\x07','V','M','X',' ','\x04','\x09','n','o',' ','3','.',
/* 0x1a2c1 = "VERR_PDM_DRIVER_VERSION_MISMATCH" */
    '\x01','\x7d','D','R','I','V','E','R','_','\xbc','_','\x19',
/* 0x1a2cd = "VERR_TM_TOO_MANY_TIMERS" */
    '\x01','T','M','_','\x1a','\xac','T','I','M','E','R','S',
/* 0x1a2d9 = "VERR_SUP_DRIVERLESS" */
    '\x01','\x95','D','R','I','V','E','R','L','E','S','S',
/* 0x1a2e5 = "VERR_VD_BLOCK_FREE" */
    '\x01','\xff','B','L','O','C','K','_','F','R','E','E',
/* 0x1a2f1 = "VERR_IEM_TB_ALLOC_FAILED" */
    '\x01','\x9c','T','B','_','A','L','L','O','C','_','\x17',
/* 0x1a2fd = "VERR_RAW_MODE_NOT_SUPPORTED" */
    '\x01','R','A','W','_','M','O','D','E','_','\x06','\x82',
/* 0x1a309 = "VERR_ASN1_TIME_TAG_MISMATCH" */
    '\x01','\xa2','T','I','M','E','_','T','A','G','_','\x19',
/* 0x1a315 = "VERR_VMX_UNEXPECTED_EXCEPTION" */
    '\x01','\xe2','\x88','E','X','C','E','P','T','I','O','N',
/* 0x1a321 = "VERR_DBGC_PARSE_BAD_RESULT_TYPE" */
    '\x01','\xfc','\xe4','\x1d','R','E','S','U','L','T','_','\xb5',
/* 0x1a32d = "VERR_DBGF_ALREADY_ATTACHED" */
    '\x01','\xb9','_','\x9b','A','T','T','A','C','H','E','D',
/* 0x1a339 = "VERR_VFS_CHAIN_ONLY_FSS" */
    '\x01','\x8d','_','\x8e','O','N','L','Y','_','F','S','S',
/* 0x1a345 = "Internal processing error #2 in SSM code." */
    '\x07','\x04','\x09','#','2',' ','\x0f','S','S','M',' ','\x84',
/* 0x1a351 = "VERR_ZIP_BAD_HEADER" */
    '\x01','Z','I','P','_','\x1d','H','E','A','D','E','R',
/* 0x1a35d = "VERR_VFS_CHAIN_ONLY_IOS" */
    '\x01','\x8d','_','\x8e','O','N','L','Y','_','I','O','S',
/* 0x1a369 = "VERR_GMM_NOT_PAGE_OWNER" */
    '\x01','G','M','M','_','\x06','\xdc','O','W','N','E','R',
/* 0x1a375 = "VERR_PDM_USBINS_VERSION_MISMATCH" */
    '\x01','\x7d','U','S','B','I','N','S','_','\xbc','_','\x19',
/* 0x1a381 = "VERR_DWARF_UNEXPECTED_FORM" */
    '\x01','D','W','A','R','F','_','\x88','F','O','R','M',
/* 0x1a38d = "VERR_DBGF_TRACER_IPE_1" */
    '\x01','\xb9','_','T','R','A','C','E','R','_','\x14','1',
/* 0x1a399 = "VERR_LDRLX_BAD_PAGE_MAP" */
    '\x01','L','D','R','L','X','_','\x1d','\xdc','M','A','P',
/* 0x1a3a5 = "VERR_SUPLIB_DIR_ENUM_FAILED" */
    '\x01','\xd6','D','I','R','_','E','N','U','M','_','\x17',
/* 0x1a3b1 = "Internal processing error in the page pool code." */
    '\x07','\x04','\x09','\x0f','\x02','\xcc','p','o','o','l',' ','\x84',
/* 0x1a3bd = "Bad VTG magic value." */
    '\x9f','V','T','G',' ','m','a','g','i','c',' ','\xe8',
/* 0x1a3c9 = "VERR_PGM_HANDLER_IPE_1" */
    '\x01','\x8c','H','A','N','D','L','E','R','_','\x14','1',
/* 0x1a3d5 = "VERR_CANT_CREATE" */
    '\x01','C','A','N','T','_','C','R','E','A','T','E',
/* 0x1a3e1 = "Internal VMX processing error no 4." */
    '\x07','V','M','X',' ','\x04','\x09','n','o',' ','4','.',
/* 0x1a3ed = "VERR_DBG_MOD_IPE" */
    '\x01','D','B','G','_','M','O','D','_','I','P','E',
/* 0x1a3f9 = "VERR_DWARF_UNKNOWN_FORM" */
    '\x01','D','W','A','R','F','_','\x91','F','O','R','M',
/* 0x1a405 = "VERR_IEM_INVALID_OPERAND_SIZE" */
    '\x01','\x9c','\x05','O','P','E','R','A','N','D','_','\xf9',
/* 0x1a411 = "VINF_SUP_DRIVERLESS" */
    '\x0e','\x95','D','R','I','V','E','R','L','E','S','S',
/* 0x1a41d = "VERR_DBGF_CANCELLED" */
    '\x01','\xb9','_','C','A','N','C','E','L','L','E','D',
/* 0x1a429 = "VERR_PGM_PHYS_NOT_ROM" */
    '\x01','\x8c','P','H','Y','S','_','\x06','R','O','M',
/* 0x1a434 = "VERR_DWARF_BAD_POS" */
    '\x01','D','W','A','R','F','_','\x1d','P','O','S',
/* 0x1a43f = "Invalid string tag for a X." */
    '\x0c','\xf2','t','a','g',' ','\x10','a',' ','X','.',
/* 0x1a44a = "VERR_IO_BAD_LENGTH" */
    '\x01','I','O','_','\x1d','L','E','N','G','T','H',
/* 0x1a455 = "VERR_CFGM_NO_NODE" */
    '\x01','C','F','G','M','_','\x60','N','O','D','E',
/* 0x1a460 = "VERR_VM_RESTORED" */
    '\x01','\xcd','_','R','E','S','T','O','R','E','D',
/* 0x1a46b = "Invalid client ID." */
    '\x0c','c','l','i','e','n','t',' ','I','D','.',
/* 0x1a476 = "VERR_IMAGE_TOO_BIG" */
    '\x01','I','M','A','G','E','_','\x1a','B','I','G',
/* 0x1a481 = "VINF_UNSUPPORTED_ALIGNMENT" */
    '\x0e','\x1c','A','L','I','G','N','M','E','N','T',
/* 0x1a48c = "VERR_IPE_UNEXPECTED_ERROR_STATUS" */
    '\x01','\x14','\x88','\x1b','_','S','T','A','T','U','S',
/* 0x1a497 = "VERR_DBGF_STACK_IPE_2" */
    '\x01','\xb9','_','S','T','A','C','K','_','\x14','2',
/* 0x1a4a2 = "Item already used." */
    'I','t','e','m',' ','\x7f','u','s','e','d','.',
/* 0x1a4ad = "VERR_DBGF_STACK_IPE_1" */
    '\x01','\xb9','_','S','T','A','C','K','_','\x14','1',
/* 0x1a4b8 = "VERR_IOMMU_CMD_HW_ERROR" */
    '\x01','\xfd','_','C','M','D','_','H','W','_','\x1b',
/* 0x1a4c3 = "Internal processing error #1 in the MMIO code." */
    '\x07','\x04','\x09','#','1',' ','\x0f','\x02','\xd3',' ','\x84',
/* 0x1a4ce = "VERR_TOO_MANY_SYMLINKS" */
    '\x01','\x1a','\xac','S','Y','M','L','I','N','K','S',
/* 0x1a4d9 = "VERR_DBGC_PARSE_NO_SCRATCH" */
    '\x01','\xfc','\xe4','\x60','S','C','R','A','T','C','H',
/* 0x1a4e4 = "VERR_SUPDRV_VTG_BAD_ATTR" */
    '\x01','\x90','V','T','G','_','\x1d','A','T','T','R',
/* 0x1a4ef = "CPUM internal processing error #2." */
    'C','P','U','M',' ','\x16','\x04','\x09','#','2','.',
/* 0x1a4fa = "Too many VCPUs." */
    'T','o','o',' ','\xb4','V','C','P','U','s','.',
/* 0x1a505 = "VERR_DWARF_TODO" */
    '\x01','D','W','A','R','F','_','T','O','D','O',
/* 0x1a510 = "VERR_CACHE_FULL" */
    '\x01','C','A','C','H','E','_','F','U','L','L',
/* 0x1a51b = "VERR_NOT_AVAILABLE" */
    '\x01','\x06','A','V','A','I','L','A','B','L','E',
/* 0x1a526 = "VERR_VMX_VMPTRLD_FAILED" */
    '\x01','\xe2','V','M','P','T','R','L','D','_','\x17',
/* 0x1a531 = "VINF_ENV_VAR_NOT_FOUND" */
    '\x0e','E','N','V','_','V','A','R','_','\x06','\x2a',
/* 0x1a53c = "VERR_VRDP_INVALID_MODE" */
    '\x01','V','R','D','P','_','\x05','M','O','D','E',
/* 0x1a547 = "VERR_PGM_INVALID_SAVED_PAGE_STATE" */
    '\x01','\x8c','\x05','S','A','V','E','D','_','\xdc','\xf1',
/* 0x1a552 = "Signed data certificate not found." */
    'S','i','g','n','e','d',' ','\x9d','\xa0','\x08','\x89',
/* 0x1a55d = "VERR_XAR_TOC_DIGEST_MISMATCH" */
    '\x01','X','A','R','_','T','O','C','_','\xbe','\x19',
/* 0x1a568 = "VERR_VBGL_INVALID_ADDR" */
    '\x01','V','B','G','L','_','\x05','A','D','D','R',
/* 0x1a573 = "VERR_COM_IPRT_ERROR" */
    '\x01','C','O','M','_','I','P','R','T','_','\x1b',
/* 0x1a57e = "VERR_VMM_R0_VERSION_MISMATCH" */
    '\x01','V','M','M','_','R','0','_','\xbc','_','\x19',
/* 0x1a589 = "VERR_DWARF_UNEXPECTED_END" */
    '\x01','D','W','A','R','F','_','\x88','E','N','D',
/* 0x1a594 = "VERR_TOO_MUCH_DATA" */
    '\x01','\x1a','M','U','C','H','_','D','A','T','A',
/* 0x1a59f = "VERR_UNEXPECTED_EXCEPTION" */
    '\x01','\x88','E','X','C','E','P','T','I','O','N',
/* 0x1a5aa = "VERR_PDM_NO_USBPROXY" */
    '\x01','\x7d','\x60','U','S','B','P','R','O','X','Y',
/* 0x1a5b5 = "VERR_PGM_PHYS_INVALID_PAGE_ID" */
    '\x01','\x8c','P','H','Y','S','_','\x05','\xdc','I','D',
/* 0x1a5c0 = "VERR_UNSUPPORTED_ALIGNMENT" */
    '\x01','\x1c','A','L','I','G','N','M','E','N','T',
/* 0x1a5cb = "Invalid VM request packet." */
    '\x0c','\xcd',' ','\xaa','p','a','c','k','e','t','.',
/* 0x1a5d6 = "Internal processing error #2 in the MMIO code." */
    '\x07','\x04','\x09','#','2',' ','\x0f','\x02','\xd3',' ','\x84',
/* 0x1a5e1 = "Pipe is busy." */
    'P','i','p','e',' ','\x0b','b','u','s','y','.',
/* 0x1a5ec = "VERR_SUP_VP_DEBUGGED" */
    '\x01','\x95','\xbd','D','E','B','U','G','G','E','D',
/* 0x1a5f7 = "VERR_ISOFS_UNEXPECTED_VDS_DESC" */
    '\x01','\x97','\x88','V','D','S','_','D','E','S','C',
/* 0x1a602 = "VERR_CV_BAD_FORMAT" */
    '\x01','C','V','_','\x1d','F','O','R','M','A','T',
/* 0x1a60d = "VERR_DIS_INVALID_MODRM" */
    '\x01','D','I','S','_','\x05','M','O','D','R','M',
/* 0x1a618 = "VERR_VFS_CHAIN_TAKES_VFS" */
    '\x01','\x8d','_','\x8e','T','A','K','E','S','_','\x8d',
/* 0x1a623 = "VERR_GMM_PAGE_ALREADY_FREE" */
    '\x01','G','M','M','_','\xdc','\x9b','F','R','E','E',
/* 0x1a62e = "Not MMIO page." */
    'N','o','t',' ','\xd3',' ','p','a','g','e','.',
/* 0x1a639 = "VERR_PDM_NO_SUCH_LUN" */
    '\x01','\x7d','\x60','S','U','C','H','_','L','U','N',
/* 0x1a644 = "VERR_XAR_BAD_HDR_SIZE" */
    '\x01','X','A','R','_','\x1d','H','D','R','_','\xf9',
/* 0x1a64f = "VERR_PIPE_NOT_READ" */
    '\x01','P','I','P','E','_','\x06','R','E','A','D',
/* 0x1a65a = "VERR_LDR_BAD_FIXUP" */
    '\x01','L','D','R','_','\x1d','F','I','X','U','P',
/* 0x1a665 = "Generic invalid state warning." */
    '\xa6','\x8f','\xca','w','a','r','n','i','n','g','.',
/* 0x1a670 = "VERR_NET_INIT_FAILED" */
    '\x01','N','E','T','_','I','N','I','T','_','\x17',
/* 0x1a67b = "VERR_PGM_INVALID_CR3_ADDR" */
    '\x01','\x8c','\x05','C','R','3','_','A','D','D','R',
/* 0x1a686 = "VERR_VFS_CHAIN_ONE_ARG" */
    '\x01','\x8d','_','\x8e','O','N','E','_','A','R','G',
/* 0x1a691 = "VWRN_DBGF_ALREADY_RUNNING" */
    '\xe6','\xb9','_','\x9b','R','U','N','N','I','N','G',
/* 0x1a69c = "breakpoint " */
    'b','r','e','a','k','p','o','i','n','t',' ',
/* 0x1a6a7 = "Invalid CPU index." */
    '\x0c','C','P','U',' ','i','n','d','e','x','.',
/* 0x1a6b2 = "Unsupported tag encountered in ICB." */
    '\x98','t','a','g',' ','\xaf','\x0f','I','C','B','.',
/* 0x1a6bd = "VERR_PDM_UNKNOWN_DEVREG_VERSION" */
    '\x01','\x7d','\x91','D','E','V','R','E','G','_','\xbc',
/* 0x1a6c8 = "VERR_ISOMK_IPE_BUFFER_SIZE" */
    '\x01','\x22','\x14','B','U','F','F','E','R','_','\xf9',
/* 0x1a6d3 = "VINF_ASN1_MORE_DATA" */
    '\x0e','\xa2','M','O','R','E','_','D','A','T','A',
/* 0x1a6de = "VERR_PDM_THREAD_IPE_2" */
    '\x01','\x7d','T','H','R','E','A','D','_','\x14','2',
/* 0x1a6e9 = "VERR_PDM_THREAD_IPE_1" */
    '\x01','\x7d','T','H','R','E','A','D','_','\x14','1',
/* 0x1a6f4 = "VERR_TAR_UNSUPPORTED_PAX_TYPE" */
    '\x01','T','A','R','_','\x1c','P','A','X','_','\xb5',
/* 0x1a6ff = "VERR_PDM_DRIVER_NOT_FOUND" */
    '\x01','\x7d','D','R','I','V','E','R','_','\x06','\x2a',
/* 0x1a70a = "Encoding data failed." */
    'E','n','c','o','d','i','n','g',' ','\x9d','\x7b',
/* 0x1a715 = "VERR_CFG_NO_VALUE" */
    '\x01','C','F','G','_','\x60','V','A','L','U','E',
/* 0x1a720 = "VERR_SEM_IS_SET" */
    '\x01','S','E','M','_','I','S','_','S','E','T',
/* 0x1a72b = "VERR_SSM_INTEGRITY_UNIT_NOT_FOUND" */
    '\x01','\xb0','\xf7','_','U','N','I','T','_','\x06','\x2a',
/* 0x1a736 = "Unexpected " */
    'U','n','e','x','p','e','c','t','e','d',' ',
/* 0x1a741 = "VERR_DBGC_BP_EXISTS" */
    '\x01','\xfc','B','P','_','E','X','I','S','T','S',
/* 0x1a74c = "UNEXPECTED_" */
    'U','N','E','X','P','E','C','T','E','D','_',
/* 0x1a757 = "Internal processing error #3 in the MMIO code." */
    '\x07','\x04','\x09','#','3',' ','\x0f','\x02','\xd3',' ','\x84',
/* 0x1a762 = "VERR_ISO_FS_UNKNOWN_AD_TYPE" */
    '\x01','\xc1','_','F','S','_','\x91','A','D','_','\xb5',
/* 0x1a76d = "VERR_TRPM_PANIC" */
    '\x01','T','R','P','M','_','P','A','N','I','C',
/* 0x1a778 = "VERR_ENV_VAR_NOT_FOUND" */
    '\x01','E','N','V','_','V','A','R','_','\x06','\x2a',
/* 0x1a783 = "VERR_PGM_PHYS_NOT_RAM" */
    '\x01','\x8c','P','H','Y','S','_','\x06','R','A','M',
/* 0x1a78e = "descriptor " */
    'd','e','s','c','r','i','p','t','o','r',' ',
/* 0x1a799 = "VERR_SUPDRV_VTG_MAGIC" */
    '\x01','\x90','V','T','G','_','M','A','G','I','C',
/* 0x1a7a4 = "VERR_LDRVI_FILE_LENGTH_ERROR" */
    '\x01','\xf4','\xab','L','E','N','G','T','H','_','\x1b',
/* 0x1a7af = "VERR_ELF_EXE_NOT_SUPPORTED" */
    '\x01','E','L','F','_','E','X','E','_','\x06','\x82',
/* 0x1a7ba = "VERR_XAR_INVALID_FILE_NAME" */
    '\x01','X','A','R','_','\x05','\xab','N','A','M','E',
/* 0x1a7c5 = "Disk is full." */
    'D','i','s','k',' ','\x0b','f','u','l','l','.',
/* 0x1a7d0 = "VERR_PDM_UNKNOWN_DRVREG_VERSION" */
    '\x01','\x7d','\x91','D','R','V','R','E','G','_','\xbc',
/* 0x1a7db = "VERR_LDR_ARCH_MISMATCH" */
    '\x01','L','D','R','_','A','R','C','H','_','\x19',
/* 0x1a7e6 = "VERR_NEM_NOT_ENABLED" */
    '\x01','\xee','_','\x06','E','N','A','B','L','E','D',
/* 0x1a7f1 = "VERR_PDM_UNKNOWN_USBREG_VERSION" */
    '\x01','\x7d','\x91','U','S','B','R','E','G','_','\xbc',
/* 0x1a7fc = "VERR_IOMMU_NOT_PRESENT" */
    '\x01','\xfd','_','\x06','P','R','E','S','E','N','T',
/* 0x1a807 = "VERR_LDRELF_DYN" */
    '\x01','L','D','R','E','L','F','_','D','Y','N',
/* 0x1a812 = "VINF_SVM_VMEXIT" */
    '\x0e','S','V','M','_','V','M','E','X','I','T',
/* 0x1a81d = "Protocol not supported." */
    'P','r','o','t','o','c','o','l',' ','\x08','\xa4',
/* 0x1a828 = "CPUM internal processing error #1." */
    'C','P','U','M',' ','\x16','\x04','\x09','#','1','.',
/* 0x1a833 = "VERR_INVALID_PARAMETER" */
    '\x01','\x05','P','A','R','A','M','E','T','E','R',
/* 0x1a83e = "VERR_CPUM_INVALID_XCR0" */
    '\x01','C','P','U','M','_','\x05','X','C','R','0',
/* 0x1a849 = "The specified chunk was not found." */
    '\x03','\x18','c','h','u','n','k',' ','\x11','\x08','\x89',
/* 0x1a854 = "Invalid codepoint." */
    '\x0c','c','o','d','e','p','o','i','n','t','.',
/* 0x1a85f = "Internal processing error in the RTMp code." */
    '\x07','\x04','\x09','\x0f','\x02','R','T','M','p',' ','\x84',
/* 0x1a86a = "VERR_SUP_VP_FOUND_EXEC_MEMORY" */
    '\x01','\x95','\xbd','\x2a','_','E','X','E','C','_','\xb6',
/* 0x1a875 = "VERR_VD_SHRINK_NOT_SUPPORTED" */
    '\x01','\xff','S','H','R','I','N','K','_','\x06','\x82',
/* 0x1a880 = "VERR_LDRMACHO_BAD_SYMTAB_SIZE" */
    '\x01','\xe9','\x1d','S','Y','M','T','A','B','_','\xf9',
/* 0x1a88b = "Invalid RT request state." */
    '\x0c','R','T',' ','\xaa','s','t','a','t','e','.',
/* 0x1a896 = "VERR_CR_CIPHER_NOT_SUPPORTED" */
    '\x01','\x24','C','I','P','H','E','R','_','\x06','\x82',
/* 0x1a8a1 = "validator: " */
    'v','a','l','i','d','a','t','o','r',':',' ',
/* 0x1a8ac = "VERR_SUP_VP_BAD_IMAGE_SIZE" */
    '\x01','\x95','\xbd','\x1d','I','M','A','G','E','_','\xf9',
/* 0x1a8b7 = "VERR_FTP_INIT_FAILED" */
    '\x01','F','T','P','_','I','N','I','T','_','\x17',
/* 0x1a8c2 = "processing " */
    'p','r','o','c','e','s','s','i','n','g',' ',
/* 0x1a8cd = "VERR_SVM_IN_USE" */
    '\x01','S','V','M','_','I','N','_','U','S','E',
/* 0x1a8d8 = "VERR_PDM_NO_USB_HUBS" */
    '\x01','\x7d','\x60','U','S','B','_','H','U','B','S',
/* 0x1a8e3 = "VERR_VFS_CHAIN_NO_PREFIX" */
    '\x01','\x8d','_','\x8e','\x60','P','R','E','F','I','X',
/* 0x1a8ee = "VERR_COM_HOST_ERROR" */
    '\x01','C','O','M','_','H','O','S','T','_','\x1b',
/* 0x1a8f9 = "VERR_DBGC_COMMAND_FAILED" */
    '\x01','\xfc','C','O','M','M','A','N','D','_','\x17',
/* 0x1a904 = "Host is down." */
    'H','o','s','t',' ','\x0b','d','o','w','n','.',
/* 0x1a90f = "VERR_IEM_VAR_UNEXPECTED_KIND" */
    '\x01','\x9c','V','A','R','_','\x88','K','I','N','D',
/* 0x1a91a = "VERR_SEM_NESTED" */
    '\x01','S','E','M','_','N','E','S','T','E','D',
/* 0x1a925 = "VERR_DONT_PANIC" */
    '\x01','D','O','N','T','_','P','A','N','I','C',
/* 0x1a930 = "VERR_PDM_DEVICE_NOT_FOUND" */
    '\x01','\x7d','D','E','V','I','C','E','_','\x06','\x2a',
/* 0x1a93b = "Wrong type." */
    'W','r','o','n','g',' ','t','y','p','e','.',
/* 0x1a946 = "VERR_SUPLIB_INVALID_INTERNAL_APP_DIR" */
    '\x01','\xd6','\x05','\xc2','A','P','P','_','D','I','R',
/* 0x1a951 = "VERR_VMM_RC_VERSION_MISMATCH" */
    '\x01','V','M','M','_','R','C','_','\xbc','_','\x19',
/* 0x1a95c = "VERR_SSM_CANCELLED" */
    '\x01','\xb0','C','A','N','C','E','L','L','E','D',
/* 0x1a967 = "The specified path is too long (hardening)." */
    '\x03','\x18','\xd0','\x0b','\x9e','l','o','n','g',' ','\xae',
/* 0x1a972 = "VERR_DIR_NOT_EMPTY" */
    '\x01','D','I','R','_','\x06','E','M','P','T','Y',
/* 0x1a97d = "Internal error: Unexpected status code." */
    '\x07','\xd8','\x94','s','t','a','t','u','s',' ','\x84',
/* 0x1a988 = "VERR_INVALID_CLIENT_ID" */
    '\x01','\x05','C','L','I','E','N','T','_','I','D',
/* 0x1a993 = "VERR_XAR_BAD_FILE_MODE" */
    '\x01','X','A','R','_','\x1d','\xab','M','O','D','E',
/* 0x1a99e = "VERR_IOM_HM_IPE" */
    '\x01','I','O','M','_','H','M','_','I','P','E',
/* 0x1a9a9 = "VERR_TIMER_BUSY" */
    '\x01','T','I','M','E','R','_','B','U','S','Y',
/* 0x1a9b4 = "VERR_DWARF_BAD_LNE" */
    '\x01','D','W','A','R','F','_','\x1d','L','N','E',
/* 0x1a9bf = "VINF_EM_SUSPEND" */
    '\x0e','E','M','_','S','U','S','P','E','N','D',
/* 0x1a9ca = "VINF_SEM_NESTED" */
    '\x0e','S','E','M','_','N','E','S','T','E','D',
/* 0x1a9d5 = "VERR_SUP_VP_MEMORY_READ_ERROR" */
    '\x01','\x95','\xbd','\xb6','_','R','E','A','D','_','\x1b',
/* 0x1a9e0 = "VERR_PROCESS_NOT_FOUND" */
    '\x01','P','R','O','C','E','S','S','_','\x06','\x2a',
/* 0x1a9eb = "VERR_FAM_OPEN_FAILED" */
    '\x01','F','A','M','_','O','P','E','N','_','\x17',
/* 0x1a9f6 = "Network path not found." */
    'N','e','t','w','o','r','k',' ','\xd0','\x08','\x89',
/* 0x1aa01 = "VERR_SSM_INTEGRITY_REC_HDR" */
    '\x01','\xb0','\xf7','_','R','E','C','_','H','D','R',
/* 0x1aa0c = "VERR_URI_TOO_SHORT" */
    '\x01','U','R','I','_','\x1a','S','H','O','R','T',
/* 0x1aa17 = "VWRN_INVALID_PARAMETER" */
    '\xe6','\x05','P','A','R','A','M','E','T','E','R',
/* 0x1aa22 = "VERR_VMX_VMENTRY_FAILED" */
    '\x01','\xe2','V','M','E','N','T','R','Y','_','\x17',
/* 0x1aa2d = "Invalid parameter." */
    '\x0c','p','a','r','a','m','e','t','e','r','.',
/* 0x1aa38 = "VERR_INVALID_CPU_INDEX" */
    '\x01','\x05','C','P','U','_','I','N','D','E','X',
/* 0x1aa43 = "VERR_FILE_LOCK_LOST" */
    '\x01','\xab','L','O','C','K','_','L','O','S','T',
/* 0x1aa4e = "VERR_SVM_INVALID_PVMCB" */
    '\x01','S','V','M','_','\x05','P','V','M','C','B',
/* 0x1aa59 = "VERR_ASN1_INVALID_UTF8_STRING_ENCODING" */
    '\x01','\xa2','\x05','U','T','F','8','_','\xd5','_','\xc6',
/* 0x1aa64 = "VERR_NET_MSG_SIZE" */
    '\x01','N','E','T','_','M','S','G','_','\xf9',
/* 0x1aa6e = "VERR_INVALID_FUNCTION" */
    '\x01','\x05','F','U','N','C','T','I','O','N',
/* 0x1aa78 = "VERR_IO_NOT_READY" */
    '\x01','I','O','_','\x06','R','E','A','D','Y',
/* 0x1aa82 = "Invalid function." */
    '\x0c','f','u','n','c','t','i','o','n','.',
/* 0x1aa8c = "directory " */
    'd','i','r','e','c','t','o','r','y',' ',
/* 0x1aa96 = "VERR_VFS_UNSUPPORTED_FORMAT" */
    '\x01','\x8d','_','\x1c','F','O','R','M','A','T',
/* 0x1aaa0 = "VERR_IEM_LABEL_IPE_6" */
    '\x01','\x9c','L','A','B','E','L','_','\x14','6',
/* 0x1aaaa = "VERR_IEM_LABEL_IPE_5" */
    '\x01','\x9c','L','A','B','E','L','_','\x14','5',
/* 0x1aab4 = "VERR_IEM_LABEL_IPE_4" */
    '\x01','\x9c','L','A','B','E','L','_','\x14','4',
/* 0x1aabe = "VERR_IEM_LABEL_IPE_2" */
    '\x01','\x9c','L','A','B','E','L','_','\x14','2',
/* 0x1aac8 = "VERR_IEM_LABEL_IPE_1" */
    '\x01','\x9c','L','A','B','E','L','_','\x14','1',
/* 0x1aad2 = "VERR_IEM_LABEL_IPE_3" */
    '\x01','\x9c','L','A','B','E','L','_','\x14','3',
/* 0x1aadc = "VERR_LE_EXE_NOT_SUPPORTED" */
    '\x01','L','E','_','E','X','E','_','\x06','\x82',
/* 0x1aae6 = "VERR_REST_INTERNAL_ERROR_9" */
    '\x01','R','E','S','T','_','\xc2','\x1b','_','9',
/* 0x1aaf0 = "VERR_SELM_INVALID_LDT" */
    '\x01','S','E','L','M','_','\x05','L','D','T',
/* 0x1aafa = "VERR_VD_ISCSI_INVALID_TYPE" */
    '\x01','\xff','I','S','C','S','I','_','\x05','\xb5',
/* 0x1ab04 = "VERR_ASN1_INVALID_BMP_STRING_ENCODING" */
    '\x01','\xa2','\x05','B','M','P','_','\xd5','_','\xc6',
/* 0x1ab0e = "VERR_CR_RANDOM_FAILED" */
    '\x01','\x24','R','A','N','D','O','M','_','\x17',
/* 0x1ab18 = "VERR_LDRMACHO_UNKNOWN_SECTION" */
    '\x01','\xe9','\x91','S','E','C','T','I','O','N',
/* 0x1ab22 = "requested " */
    'r','e','q','u','e','s','t','e','d',' ',
/* 0x1ab2c = "VERR_LDRMACHO_UNSUPPORTED_FIXUP_TYPE" */
    '\x01','\xe9','\x1c','F','I','X','U','P','_','\xb5',
/* 0x1ab36 = "VERR_VFS_UNKNOWN_FORMAT" */
    '\x01','\x8d','_','\x91','F','O','R','M','A','T',
/* 0x1ab40 = "VERR_GVM_TOO_MANY_VMS" */
    '\x01','G','V','M','_','\x1a','\xac','V','M','S',
/* 0x1ab4a = "Invalid VM request state." */
    '\x0c','\xcd',' ','\xaa','s','t','a','t','e','.',
/* 0x1ab54 = "VERR_SYMBOL_NOT_FOUND" */
    '\x01','S','Y','M','B','O','L','_','\x06','\x2a',
/* 0x1ab5e = "algorithm " */
    'a','l','g','o','r','i','t','h','m',' ',
/* 0x1ab68 = "VERR_SSM_STREAM_ERROR" */
    '\x01','\xb0','S','T','R','E','A','M','_','\x1b',
/* 0x1ab72 = "VERR_VD_ISCSI_INVALID_STATE" */
    '\x01','\xff','I','S','C','S','I','_','\x05','\xf1',
/* 0x1ab7c = "VERR_GVM_MISMATCH_VM_SIZE" */
    '\x01','G','V','M','_','\x19','_','\xcd','_','\xf9',
/* 0x1ab86 = "Process Verification Failure: Bad image size." */
    '\x1e','\x0d','\x12','\x9f','\x26','s','i','z','e','.',
/* 0x1ab90 = "VERR_TM_LOAD_STATE" */
    '\x01','T','M','_','L','O','A','D','_','\xf1',
/* 0x1ab9a = "VERR_REST_INTERNAL_ERROR_8" */
    '\x01','R','E','S','T','_','\xc2','\x1b','_','8',
/* 0x1aba4 = "Invalid memory pointer." */
    '\x0c','\x86','p','o','i','n','t','e','r','.',
/* 0x1abae = "VERR_REST_INTERNAL_ERROR_6" */
    '\x01','R','E','S','T','_','\xc2','\x1b','_','6',
/* 0x1abb8 = "VERR_REST_INTERNAL_ERROR_5" */
    '\x01','R','E','S','T','_','\xc2','\x1b','_','5',
/* 0x1abc2 = "VERR_DUPLICATE" */
    '\x01','D','U','P','L','I','C','A','T','E',
/* 0x1abcc = "VERR_ISOFS_WRONG_FILE_TYPE" */
    '\x01','\x97','W','R','O','N','G','_','\xab','\xb5',
/* 0x1abd6 = "VERR_ISOMK_IMPORT_UNKNOWN_FORMAT" */
    '\x01','\x22','\x83','\x91','F','O','R','M','A','T',
/* 0x1abe0 = "VERR_REST_INTERNAL_ERROR_4" */
    '\x01','R','E','S','T','_','\xc2','\x1b','_','4',
/* 0x1abea = "VERR_PGM_MODE_IPE" */
    '\x01','\x8c','M','O','D','E','_','I','P','E',
/* 0x1abf4 = "VERR_STATE_CHANGED" */
    '\x01','\xf1','_','C','H','A','N','G','E','D',
/* 0x1abfe = "VERR_LDRPE_TLS" */
    '\x01','L','D','R','P','E','_','T','L','S',
/* 0x1ac08 = "VERR_NE_EXE_NOT_SUPPORTED" */
    '\x01','N','E','_','E','X','E','_','\x06','\x82',
/* 0x1ac12 = "VERR_REST_INTERNAL_ERROR_3" */
    '\x01','R','E','S','T','_','\xc2','\x1b','_','3',
/* 0x1ac1c = "VERR_REST_INTERNAL_ERROR_2" */
    '\x01','R','E','S','T','_','\xc2','\x1b','_','2',
/* 0x1ac26 = "VERR_PDM_BLOCK_NO_TYPE" */
    '\x01','\x7d','B','L','O','C','K','_','\x60','\xb5',
/* 0x1ac30 = "The byte string was not found." */
    '\x03','b','y','t','e',' ','\xf2','\x11','\x08','\x89',
/* 0x1ac3a = "VERR_PDM_NO_PCI_BUS" */
    '\x01','\x7d','\x60','P','C','I','_','B','U','S',
/* 0x1ac44 = "VERR_ASN1_INVALID_OBJID_ENCODING" */
    '\x01','\xa2','\x05','O','B','J','I','D','_','\xc6',
/* 0x1ac4e = "VERR_URI_EMPTY" */
    '\x01','U','R','I','_','E','M','P','T','Y',
/* 0x1ac58 = "Invalid MMIO handle." */
    '\x0c','\xd3',' ','h','a','n','d','l','e','.',
/* 0x1ac62 = "Generic loader failure." */
    '\xa6','\xd9','f','a','i','l','u','r','e','.',
/* 0x1ac6c = "VERR_REST_INTERNAL_ERROR_1" */
    '\x01','R','E','S','T','_','\xc2','\x1b','_','1',
/* 0x1ac76 = "VERR_REST_INTERNAL_ERROR_7" */
    '\x01','R','E','S','T','_','\xc2','\x1b','_','7',
/* 0x1ac80 = "Unsupported CPU mode." */
    '\x98','C','P','U',' ','m','o','d','e','.',
/* 0x1ac8a = "Syntax error - too few arguments." */
    '\xfa','\x09','-',' ','\x9e','f','e','w',' ','\xdd',
/* 0x1ac94 = "VERR_SUP_VP_STUB_NOT_FOUND" */
    '\x01','\x95','\xbd','S','T','U','B','_','\x06','\x2a',
/* 0x1ac9e = "VERR_DWARF_IPE" */
    '\x01','D','W','A','R','F','_','I','P','E',
/* 0x1aca8 = "VERR_PDM_BLOCK_UNKNOWN_TYPE" */
    '\x01','\x7d','B','L','O','C','K','_','\x91','\xb5',
/* 0x1acb2 = "Expected an element." */
    '\xb8','\x87','e','l','e','m','e','n','t','.',
/* 0x1acbc = "VERR_ISOFS_ICB_TOO_BIG" */
    '\x01','\x97','I','C','B','_','\x1a','B','I','G',
/* 0x1acc6 = "VINF_SVM_VMRUN" */
    '\x0e','S','V','M','_','V','M','R','U','N',
/* 0x1acd0 = "GIM internal processing error #3." */
    'G','I','M',' ','\x16','\x04','\x09','#','3','.',
/* 0x1acda = "VERR_SSM_FIELD_INVALID_SIZE" */
    '\x01','\xb0','F','I','E','L','D','_','\x05','\xf9',
/* 0x1ace4 = "VERR_MODULE_NOT_FOUND" */
    '\x01','M','O','D','U','L','E','_','\x06','\x2a',
/* 0x1acee = "arguments." */
    'a','r','g','u','m','e','n','t','s','.',
/* 0x1acf8 = "VERR_IS_A_FILE" */
    '\x01','I','S','_','A','_','F','I','L','E',
/* 0x1ad02 = "The VM state was invalid for the requested operation." */
    '\x03','\xcd',' ','\xca','\x11','\x8f','\x10','\x02','\xde','\xea',
/* 0x1ad0c = "VERR_VMX_RESERVED" */
    '\x01','\xe2','R','E','S','E','R','V','E','D',
/* 0x1ad16 = "APIC internal error #1." */
    'A','P','I','C',' ','\x16','\x09','#','1','.',
/* 0x1ad20 = "Internal PKCS #7 error." */
    '\x07','P','K','C','S',' ','#','7',' ','\x85',
/* 0x1ad2a = "VERR_MP_TOO_MANY_CPUS" */
    '\x01','M','P','_','\x1a','\xac','C','P','U','S',
/* 0x1ad34 = "VERR_UNSUPPORTED_CPU_MODE" */
    '\x01','\x1c','C','P','U','_','M','O','D','E',
/* 0x1ad3e = "VERR_SELM_NO_TSS" */
    '\x01','S','E','L','M','_','\x60','T','S','S',
/* 0x1ad48 = "VERR_LDRMACHO_UNSUPPORTED_SECTION" */
    '\x01','\xe9','\x1c','S','E','C','T','I','O','N',
/* 0x1ad52 = "VERR_SSM_TOO_MANY_PASSES" */
    '\x01','\xb0','\x1a','\xac','P','A','S','S','E','S',
/* 0x1ad5c = "The breakpoint already exists." */
    '\x03','\xbf','\x7f','e','x','i','s','t','s','.',
/* 0x1ad66 = "Command not supported." */
    'C','o','m','m','a','n','d',' ','\x08','\xa4',
/* 0x1ad70 = "VERR_SUPDRV_CSRSS_NOT_FOUND" */
    '\x01','\x90','C','S','R','S','S','_','\x06','\x2a',
/* 0x1ad7a = "VERR_SSM_INTEGRITY_VBOX_VERSION" */
    '\x01','\xb0','\xf7','_','V','B','O','X','_','\xbc',
/* 0x1ad84 = "VERR_VFS_CHAIN_CAST_FAILED" */
    '\x01','\x8d','_','\x8e','C','A','S','T','_','\x17',
/* 0x1ad8e = "Unexpected SVM exit." */
    '\x94','S','V','M',' ','e','x','i','t','.',
/* 0x1ad98 = "Not equal." */
    'N','o','t',' ','e','q','u','a','l','.',
/* 0x1ada2 = "Is a FIFO." */
    'I','s',' ','a',' ','F','I','F','O','.',
/* 0x1adac = "VERR_XAR_BAD_FILE_GID" */
    '\x01','X','A','R','_','\x1d','\xab','G','I','D',
/* 0x1adb6 = "The state changed." */
    '\x03','\xca','c','h','a','n','g','e','d','.',
/* 0x1adc0 = "VERR_MZ_EXE_NOT_SUPPORTED" */
    '\x01','M','Z','_','E','X','E','_','\x06','\x82',
/* 0x1adca = "VERR_VMX_INVALID_GUEST_STATE" */
    '\x01','\xe2','\x05','G','U','E','S','T','_','\xf1',
/* 0x1add4 = "VINF_PGM_SYNC_CR3" */
    '\x0e','\x8c','S','Y','N','C','_','C','R','3',
/* 0x1adde = "The device wasn\'t found." */
    '\x03','\xa3','w','a','s','n','\'','t',' ','\x89',
/* 0x1ade8 = "VERR_CR_X509_NAME_NOT_STRING" */
    '\x01','\x24','\xb7','N','A','M','E','_','\x06','\xd5',
/* 0x1adf2 = "VWRN_STATE_CHANGED" */
    '\xe6','\xf1','_','C','H','A','N','G','E','D',
/* 0x1adfc = "structure " */
    's','t','r','u','c','t','u','r','e',' ',
/* 0x1ae06 = "VERR_CANCELLED" */
    '\x01','C','A','N','C','E','L','L','E','D',
/* 0x1ae10 = "VERR_LDRVI_NO_MEMORY_SHDRS" */
    '\x01','\xf4','\x60','\xb6','_','S','H','D','R','S',
/* 0x1ae1a = "VERR_PIPE_IO_ERROR" */
    '\x01','P','I','P','E','_','I','O','_','\x1b',
/* 0x1ae24 = "VERR_PGM_DYNMAP_FAILED" */
    '\x01','\x8c','D','Y','N','M','A','P','_','\x17',
/* 0x1ae2e = "VERR_ISOMK_IPE_RR_READ" */
    '\x01','\x22','\x14','R','R','_','R','E','A','D',
/* 0x1ae38 = "VERR_DBGC_PARSE_INVALID_NUMBER" */
    '\x01','\xfc','\xe4','\x05','N','U','M','B','E','R',
/* 0x1ae42 = "VERR_SSM_INTEGRITY_HEADER" */
    '\x01','\xb0','\xf7','_','H','E','A','D','E','R',
/* 0x1ae4c = "VERR_VD_CACHE_NOT_FOUND" */
    '\x01','\xff','C','A','C','H','E','_','\x06','\x2a',
/* 0x1ae56 = "VERR_PE_EXE_NOT_SUPPORTED" */
    '\x01','P','E','_','E','X','E','_','\x06','\x82',
/* 0x1ae60 = "VERR_IEM_INVALID_EFF_SEG" */
    '\x01','\x9c','\x05','E','F','F','_','S','E','G',
/* 0x1ae6a = "VERR_VFS_CHAIN_ONLY_VFS" */
    '\x01','\x8d','_','\x8e','O','N','L','Y','_','\x8d',
/* 0x1ae74 = "GIM internal processing error #2." */
    'G','I','M',' ','\x16','\x04','\x09','#','2','.',
/* 0x1ae7e = "The file type isn\'t supported." */
    '\x03','\x1f','\xf3','i','s','n','\'','t',' ','\xa4',
/* 0x1ae88 = "APIC internal error #0." */
    'A','P','I','C',' ','\x16','\x09','#','0','.',
/* 0x1ae92 = "VERR_UNEXPECTED_FS_OBJ_TYPE" */
    '\x01','\x88','F','S','_','O','B','J','_','\xb5',
/* 0x1ae9c = "VERR_VD_IMAGE_NOT_FOUND" */
    '\x01','\xff','I','M','A','G','E','_','\x06','\x2a',
/* 0x1aea6 = "VERR_NEM_SET_TSC" */
    '\x01','\xee','_','S','E','T','_','T','S','C',
/* 0x1aeb0 = "VERR_SVM_UNEXPECTED_EXIT" */
    '\x01','S','V','M','_','\x88','E','X','I','T',
/* 0x1aeba = "VERR_SVM_UNKNOWN_EXIT" */
    '\x01','S','V','M','_','\x91','E','X','I','T',
/* 0x1aec4 = "VERR_SUPDRV_VTG_BITS" */
    '\x01','\x90','V','T','G','_','B','I','T','S',
/* 0x1aece = "VERR_IS_A_FIFO" */
    '\x01','I','S','_','A','_','F','I','F','O',
/* 0x1aed8 = "VERR_DISK_IO_ERROR" */
    '\x01','D','I','S','K','_','I','O','_','\x1b',
/* 0x1aee2 = "VERR_PDM_UNSUPPORTED_BLOCK_TYPE" */
    '\x01','\x7d','\x1c','B','L','O','C','K','_','\xb5',
/* 0x1aeec = "operation." */
    'o','p','e','r','a','t','i','o','n','.',
/* 0x1aef6 = "VINF_TRY_AGAIN" */
    '\x0e','T','R','Y','_','A','G','A','I','N',
/* 0x1af00 = "VERR_INVALID_VM_HANDLE" */
    '\x01','\x05','\xcd','_','H','A','N','D','L','E',
/* 0x1af0a = "VERR_CR_PKCS7_DIGEST_CALC_ERROR" */
    '\x01','\x24','\xe5','\xbe','C','A','L','C','_','\x1b',
/* 0x1af14 = "VERR_INVALID_SELECTOR" */
    '\x01','\x05','S','E','L','E','C','T','O','R',
/* 0x1af1e = "VERR_INVALID_BASE64_ENCODING" */
    '\x01','\x05','B','A','S','E','6','4','_','\xc6',
/* 0x1af28 = "VWRN_DBGF_ALREADY_HALTED" */
    '\xe6','\xb9','_','\x9b','H','A','L','T','E','D',
/* 0x1af32 = "VINF_DBGF_BP_HALT" */
    '\x0e','\xb9','_','B','P','_','H','A','L','T',
/* 0x1af3c = "VERR_VFS_CHAIN_TOO_MANY_ARGS" */
    '\x01','\x8d','_','\x8e','\x1a','\xac','A','R','G','S',
/* 0x1af46 = "VINF_ASN1_NOT_ENCODED" */
    '\x0e','\xa2','\x06','E','N','C','O','D','E','D',
/* 0x1af50 = "VERR_IEM_FIXUP_IPE_1" */
    '\x01','\x9c','F','I','X','U','P','_','\x14','1',
/* 0x1af5a = "VERR_DISK_FULL" */
    '\x01','D','I','S','K','_','F','U','L','L',
/* 0x1af64 = "VERR_PGM_POOL_IPE" */
    '\x01','\x8c','P','O','O','L','_','I','P','E',
/* 0x1af6e = "GIM internal processing error #1." */
    'G','I','M',' ','\x16','\x04','\x09','#','1','.',
/* 0x1af78 = "VERR_VD_VALUE_NOT_FOUND" */
    '\x01','\xff','V','A','L','U','E','_','\x06','\x2a',
/* 0x1af82 = "VERR_SSM_MEM_TOO_BIG" */
    '\x01','\xb0','M','E','M','_','\x1a','B','I','G',
/* 0x1af8c = "VERR_PIPE_BUSY" */
    '\x01','P','I','P','E','_','B','U','S','Y',
/* 0x1af96 = "Invalid selector." */
    '\x0c','s','e','l','e','c','t','o','r','.',
/* 0x1afa0 = "VERR_MORE_DATA" */
    '\x01','M','O','R','E','_','D','A','T','A',
/* 0x1afaa = "VERR_TRY_AGAIN" */
    '\x01','T','R','Y','_','A','G','A','I','N',
/* 0x1afb4 = "VERR_XAR_BAD_FILE_UID" */
    '\x01','X','A','R','_','\x1d','\xab','U','I','D',
/* 0x1afbe = "VERR_SEM_LV_INTERNAL_ERROR" */
    '\x01','S','E','M','_','L','V','_','\xc2','\x1b',
/* 0x1afc8 = "VERR_SUP_VP_MEMORY_VS_FILE_MISMATCH" */
    '\x01','\x95','\xbd','\xb6','_','V','S','_','\xab','\x19',
/* 0x1afd2 = "Process Verification Failure: No NTDLL." */
    '\x1e','\x0d','\x12','\xdf','N','T','D','L','L','.',
/* 0x1afdc = "VERR_LDRMACHO_UNSUPPORTED_MACHINE" */
    '\x01','\xe9','\x1c','M','A','C','H','I','N','E',
/* 0x1afe6 = "VERR_COM_XML_ERROR" */
    '\x01','C','O','M','_','X','M','L','_','\x1b',
/* 0x1aff0 = "VERR_PAGE_NOT_PRESENT" */
    '\x01','\xdc','\x06','P','R','E','S','E','N','T',
/* 0x1affa = "Unsupported CPU ID register value." */
    '\x98','C','P','U',' ','I','D',' ','\xeb','\xe8',
/* 0x1b004 = "VERR_SUP_VP_FILE_MODE_ERROR" */
    '\x01','\x95','\xbd','\xab','M','O','D','E','_','\x1b',
/* 0x1b00e = "Protocol error." */
    'P','r','o','t','o','c','o','l',' ','\x85',
/* 0x1b018 = "VERR_CR_PKIX_UNKNOWN_DIGEST_TYPE" */
    '\x01','\x24','P','K','I','X','_','\x91','\xbe','\xb5',
/* 0x1b022 = "Generic PKCS #7 error." */
    '\xa6','P','K','C','S',' ','#','7',' ','\x85',
/* 0x1b02c = "Invalid VM handle." */
    '\x0c','\xcd',' ','h','a','n','d','l','e','.',
/* 0x1b036 = "Shutdown failed." */
    'S','h','u','t','d','o','w','n',' ','\x7b',
/* 0x1b040 = "Invalid RT request type." */
    '\x0c','R','T',' ','\xaa','t','y','p','e','.',
/* 0x1b04a = "VERR_LX_EXE_NOT_SUPPORTED" */
    '\x01','L','X','_','E','X','E','_','\x06','\x82',
/* 0x1b054 = "VERR_FILE_AIO_BUSY" */
    '\x01','\xab','A','I','O','_','B','U','S','Y',
/* 0x1b05e = "Empty string in X." */
    'E','m','p','t','y',' ','\xf2','\x0f','X','.',
/* 0x1b068 = "VERR_ASN1_NOT_PRESENT" */
    '\x01','\xa2','\x06','P','R','E','S','E','N','T',
/* 0x1b072 = "VERR_SSM_INTEGRITY_FOOTER" */
    '\x01','\xb0','\xf7','_','F','O','O','T','E','R',
/* 0x1b07c = "APIC internal error #2." */
    'A','P','I','C',' ','\x16','\x09','#','2','.',
/* 0x1b086 = "VERR_ASN1_INVALID_T61_STRING_ENCODING" */
    '\x01','\xa2','\x05','T','6','1','_','\xd5','_','\xc6',
/* 0x1b090 = "VERR_PGM_LOAD_UNEXPECTED_PAGE_TYPE" */
    '\x01','\x8c','L','O','A','D','_','\x88','\xdc','\xb5',
/* 0x1b09a = "Socket type not supported." */
    'S','o','c','k','e','t',' ','\xf3','\x08','\xa4',
/* 0x1b0a4 = "specified " */
    's','p','e','c','i','f','i','e','d',' ',
/* 0x1b0ae = "VERR_VMX_VMEXIT_FAILED" */
    '\x01','\xe2','V','M','E','X','I','T','_','\x17',
/* 0x1b0b8 = "VERR_ASN1_INVALID_IA5_STRING_ENCODING" */
    '\x01','\xa2','\x05','I','A','5','_','\xd5','_','\xc6',
/* 0x1b0c2 = "The instruction is too long." */
    '\x03','\xda','\x0b','\x9e','l','o','n','g','.',
/* 0x1b0cb = "Invalid page directory specified to PGM." */
    '\x0c','\xcc','\x25','\x18','\x0a','P','G','M','.',
/* 0x1b0d4 = "VERR_ASN1_NO_VTABLE" */
    '\x01','\xa2','\x60','V','T','A','B','L','E',
/* 0x1b0dd = "VERR_NO_UTF16_MEMORY" */
    '\x01','\x60','U','T','F','1','6','_','\xb6',
/* 0x1b0e6 = "VWRN_CSAM_PAGE_NOT_FOUND" */
    '\xe6','C','S','A','M','_','\xdc','\x06','\x2a',
/* 0x1b0ef = "Codec was not found." */
    'C','o','d','e','c',' ','\x11','\x08','\x89',
/* 0x1b0f8 = "VERR_SVM_NO_SVM" */
    '\x01','S','V','M','_','\x60','S','V','M',
/* 0x1b101 = "VERR_DWARF_BAD_STRING" */
    '\x01','D','W','A','R','F','_','\x1d','\xd5',
/* 0x1b10a = "Mismatch." */
    'M','i','s','m','a','t','c','h','.',
/* 0x1b113 = "register " */
    'r','e','g','i','s','t','e','r',' ',
/* 0x1b11c = "TM internal processing error #2." */
    'T','M',' ','\x16','\x04','\x09','#','2','.',
/* 0x1b125 = "TM internal processing error #6." */
    'T','M',' ','\x16','\x04','\x09','#','6','.',
/* 0x1b12e = "Codec is not supported." */
    'C','o','d','e','c',' ','\x0b','\x08','\xa4',
/* 0x1b137 = "Generic stream error." */
    '\xa6','s','t','r','e','a','m',' ','\x85',
/* 0x1b140 = "VERR_VMX_VMXON_FAILED" */
    '\x01','\xe2','V','M','X','O','N','_','\x17',
/* 0x1b149 = "VINF_END_OF_STRING" */
    '\x0e','E','N','D','_','O','F','_','\xd5',
/* 0x1b152 = "VERR_LDRMACHO_BIT_MIX" */
    '\x01','\xe9','B','I','T','_','M','I','X',
/* 0x1b15b = "VERR_INVALID_CONTEXT" */
    '\x01','\x05','C','O','N','T','E','X','T',
/* 0x1b164 = "VERR_NET_DOWN" */
    '\x01','N','E','T','_','D','O','W','N',
/* 0x1b16d = "VERR_PATCH_NOT_FOUND" */
    '\x01','P','A','T','C','H','_','\x06','\x2a',
/* 0x1b176 = "TM internal processing error #9." */
    'T','M',' ','\x16','\x04','\x09','#','9','.',
/* 0x1b17f = "VERR_SEM_BUSY" */
    '\x01','S','E','M','_','B','U','S','Y',
/* 0x1b188 = "Expected " */
    'E','x','p','e','c','t','e','d',' ',
/* 0x1b191 = "TM internal processing error #1." */
    'T','M',' ','\x16','\x04','\x09','#','1','.',
/* 0x1b19a = "VERR_VFS_CHAIN_NO_ARGS" */
    '\x01','\x8d','_','\x8e','\x60','A','R','G','S',
/* 0x1b1a3 = "VERR_FILE_NOT_LOCKED" */
    '\x01','\xab','\x06','L','O','C','K','E','D',
/* 0x1b1ac = "Invalid context." */
    '\x0c','c','o','n','t','e','x','t','.',
/* 0x1b1b5 = "VERR_VD_VMDK_INVALID_STATE" */
    '\x01','\xff','V','M','D','K','_','\x05','\xf1',
/* 0x1b1be = "Generic file write error." */
    '\xa6','\x1f','w','r','i','t','e',' ','\x85',
/* 0x1b1c7 = "VERR_CR_PKIX_INTERNAL_ERROR" */
    '\x01','\x24','P','K','I','X','_','\xc2','\x1b',
/* 0x1b1d0 = "VERR_LDRVI_NOT_SIGNED" */
    '\x01','\xf4','\x06','S','I','G','N','E','D',
/* 0x1b1d9 = "TM internal processing error #4." */
    'T','M',' ','\x16','\x04','\x09','#','4','.',
/* 0x1b1e2 = "VERR_ASN1_INVALID_NULL_ENCODING" */
    '\x01','\xa2','\x05','N','U','L','L','_','\xc6',
/* 0x1b1eb = "TM internal processing error #8." */
    'T','M',' ','\x16','\x04','\x09','#','8','.',
/* 0x1b1f4 = "Unsupported version." */
    '\x98','v','e','r','s','i','o','n','.',
/* 0x1b1fd = "Failure: " */
    'F','a','i','l','u','r','e',':',' ',
/* 0x1b206 = "VERR_LDRMACHO_BAD_SYMBOL" */
    '\x01','\xe9','\x1d','S','Y','M','B','O','L',
/* 0x1b20f = "VERR_SUPLIB_IS_FILE" */
    '\x01','\xd6','I','S','_','F','I','L','E',
/* 0x1b218 = "The specified cpu was not found." */
    '\x03','\x18','c','p','u',' ','\x11','\x08','\x89',
/* 0x1b221 = "VINF_EM_RESET" */
    '\x0e','E','M','_','R','E','S','E','T',
/* 0x1b22a = "The host is not supported." */
    '\x03','h','o','s','t',' ','\x0b','\x08','\xa4',
/* 0x1b233 = "VERR_LDR_INVALID_RVA" */
    '\x01','L','D','R','_','\x05','R','V','A',
/* 0x1b23c = "VERR_IEM_VAR_IPE_13" */
    '\x01','\x9c','V','A','R','_','\x14','1','3',
/* 0x1b245 = "TM internal processing error #3." */
    'T','M',' ','\x16','\x04','\x09','#','3','.',
/* 0x1b24e = "VERR_IOM_MMIO_IPE_3" */
    '\x01','I','O','M','_','\xd3','_','\x14','3',
/* 0x1b257 = "VERR_IOM_MMIO_IPE_2" */
    '\x01','I','O','M','_','\xd3','_','\x14','2',
/* 0x1b260 = "VERR_IOM_MMIO_IPE_1" */
    '\x01','I','O','M','_','\xd3','_','\x14','1',
/* 0x1b269 = "VFS object cast failed." */
    '\x8d',' ','\xa8','c','a','s','t',' ','\x7b',
/* 0x1b272 = "VERR_VD_NOT_OPENED" */
    '\x01','\xff','\x06','O','P','E','N','E','D',
/* 0x1b27b = "VINF_PDM_ALREADY_LOADED" */
    '\x0e','\x7d','\x9b','L','O','A','D','E','D',
/* 0x1b284 = "VERR_SSM_INTEGRITY_MAGIC" */
    '\x01','\xb0','\xf7','_','M','A','G','I','C',
/* 0x1b28d = "Internal " */
    'I','n','t','e','r','n','a','l',' ',
/* 0x1b296 = "VERR_VD_VMDK_UNSUPPORTED_VERSION" */
    '\x01','\xff','V','M','D','K','_','\x1c','\xbc',
/* 0x1b29f = "VERR_DBGF_REG_IPE_2" */
    '\x01','\xb9','_','R','E','G','_','\x14','2',
/* 0x1b2a8 = "VERR_DBGF_REG_IPE_1" */
    '\x01','\xb9','_','R','E','G','_','\x14','1',
/* 0x1b2b1 = "TM internal processing error #7." */
    'T','M',' ','\x16','\x04','\x09','#','7','.',
/* 0x1b2ba = "The ELF version is not supported." */
    '\x03','E','L','F',' ','\xcf','\x0b','\x08','\xa4',
/* 0x1b2c3 = "Invalid config value." */
    '\x0c','c','o','n','f','i','g',' ','\xe8',
/* 0x1b2cc = "VERR_TM_GIP_VERSION" */
    '\x01','T','M','_','G','I','P','_','\xbc',
/* 0x1b2d5 = "VERR_IEM_VAR_IPE_12" */
    '\x01','\x9c','V','A','R','_','\x14','1','2',
/* 0x1b2de = "VERR_COM_INVALID_VM_STATE" */
    '\x01','C','O','M','_','\x05','\xcd','_','\xf1',
/* 0x1b2e7 = "VERR_SEARCH_ERROR" */
    '\x01','S','E','A','R','C','H','_','\x1b',
/* 0x1b2f0 = "VERR_ISOFS_BAD_FILE_ENTRY" */
    '\x01','\x97','\x1d','\xab','E','N','T','R','Y',
/* 0x1b2f9 = "Module not found." */
    'M','o','d','u','l','e',' ','\x08','\x89',
/* 0x1b302 = "VERR_NOT_SYMLINK" */
    '\x01','\x06','S','Y','M','L','I','N','K',
/* 0x1b30b = "VERR_ASN1_STRING_TAG_MISMATCH" */
    '\x01','\xa2','\xd5','_','T','A','G','_','\x19',
/* 0x1b314 = "Bad file entry (ICB)." */
    '\x9f','\x1f','\xc8','(','I','C','B',')','.',
/* 0x1b31d = "Bad section." */
    '\x9f','s','e','c','t','i','o','n','.',
/* 0x1b326 = "VERR_DBG_INVALID_RVA" */
    '\x01','D','B','G','_','\x05','R','V','A',
/* 0x1b32f = "VERR_IEM_REG_IPE_12" */
    '\x01','\x9c','R','E','G','_','\x14','1','2',
/* 0x1b338 = "VERR_IEM_REG_IPE_11" */
    '\x01','\x9c','R','E','G','_','\x14','1','1',
/* 0x1b341 = "VERR_IEM_REG_IPE_10" */
    '\x01','\x9c','R','E','G','_','\x14','1','0',
/* 0x1b34a = "VERR_IEM_REG_IPE_13" */
    '\x01','\x9c','R','E','G','_','\x14','1','3',
/* 0x1b353 = "Client not found." */
    'C','l','i','e','n','t',' ','\x08','\x89',
/* 0x1b35c = "VERR_IOMMU_CMD_NOT_SUPPORTED" */
    '\x01','\xfd','_','C','M','D','_','\x06','\x82',
/* 0x1b365 = "VERR_NEM_INIT_FAILED" */
    '\x01','\xee','_','I','N','I','T','_','\x17',
/* 0x1b36e = "VERR_DEV_IO_ERROR" */
    '\x01','D','E','V','_','I','O','_','\x1b',
/* 0x1b377 = "VERR_INVALID_POINTER" */
    '\x01','\x05','P','O','I','N','T','E','R',
/* 0x1b380 = "VERR_NET_IO_ERROR" */
    '\x01','N','E','T','_','I','O','_','\x1b',
/* 0x1b389 = "VERR_ASN1_UNEXPECTED_OBJ_ID" */
    '\x01','\xa2','\x88','O','B','J','_','I','D',
/* 0x1b392 = "VERR_IO_BAD_UNIT" */
    '\x01','I','O','_','\x1d','U','N','I','T',
/* 0x1b39b = "VERR_PGM_PHYS_NOT_MMIO" */
    '\x01','\x8c','P','H','Y','S','_','\x06','\xd3',
/* 0x1b3a4 = "INTEGRITY" */
    'I','N','T','E','G','R','I','T','Y',
/* 0x1b3ad = "VERR_IEM_VAR_IPE_11" */
    '\x01','\x9c','V','A','R','_','\x14','1','1',
/* 0x1b3b6 = "VERR_LDRELF_VERSION" */
    '\x01','L','D','R','E','L','F','_','\xbc',
/* 0x1b3bf = "VERR_DBG_TODO" */
    '\x01','D','B','G','_','T','O','D','O',
/* 0x1b3c8 = "VERR_VMX_INVALID_HOST_STATE" */
    '\x01','\xe2','\x05','H','O','S','T','_','\xf1',
/* 0x1b3d1 = "Expected section header." */
    '\xb8','\xdb','h','e','a','d','e','r','.',
/* 0x1b3da = "VERR_LDRVI_PAGE_HASH_MISMATCH" */
    '\x01','\xf4','\xdc','H','A','S','H','_','\x19',
/* 0x1b3e3 = "VERR_IEM_VAR_IPE_10" */
    '\x01','\x9c','V','A','R','_','\x14','1','0',
/* 0x1b3ec = "VERR_IPE_UNEXPECTED_STATUS" */
    '\x01','\x14','\x88','S','T','A','T','U','S',
/* 0x1b3f5 = "Invalid VM request type." */
    '\x0c','\xcd',' ','\xaa','t','y','p','e','.',
/* 0x1b3fe = "INTERNAL_" */
    'I','N','T','E','R','N','A','L','_',
/* 0x1b407 = "VERR_DBGF_MEM_NOT_FOUND" */
    '\x01','\xb9','_','M','E','M','_','\x06','\x2a',
/* 0x1b410 = "VERR_SSM_UNIT_NOT_FOUND" */
    '\x01','\xb0','U','N','I','T','_','\x06','\x2a',
/* 0x1b419 = "VERR_SUPLIB_FSTAT_FAILED" */
    '\x01','\xd6','F','S','T','A','T','_','\x17',
/* 0x1b422 = "VERR_DEADLOCK" */
    '\x01','D','E','A','D','L','O','C','K',
/* 0x1b42b = "VERR_END_OF_STRING" */
    '\x01','E','N','D','_','O','F','_','\xd5',
/* 0x1b434 = "TM internal processing error #5." */
    'T','M',' ','\x16','\x04','\x09','#','5','.',
/* 0x1b43d = "VERR_TAR_UNEXPECTED_EOS" */
    '\x01','T','A','R','_','\x88','E','O','S',
/* 0x1b446 = "VERR_INVALID_UTF16_ENCODING" */
    '\x01','\x05','U','T','F','1','6','_','\xc6',
/* 0x1b44f = "VERR_LDRMACHO_BAD_HEADER" */
    '\x01','\xe9','\x1d','H','E','A','D','E','R',
/* 0x1b458 = "Generic not found error." */
    '\xa6','\x08','f','o','u','n','d',' ','\x85',
/* 0x1b461 = "contains " */
    'c','o','n','t','a','i','n','s',' ',
/* 0x1b46a = "LDRMACHO_" */
    'L','D','R','M','A','C','H','O','_',
/* 0x1b473 = "VINF_LDRVI_NOT_SIGNED" */
    '\x0e','\xf4','\x06','S','I','G','N','E','D',
/* 0x1b47c = "VERR_ISOFS_TOO_MANY_PVDS" */
    '\x01','\x97','\x1a','\xac','P','V','D','S',
/* 0x1b484 = "VERR_IEM_VAR_IPE_3" */
    '\x01','\x9c','V','A','R','_','\x14','3',
/* 0x1b48c = "element " */
    'e','l','e','m','e','n','t',' ',
/* 0x1b494 = "VERR_IEM_VAR_IPE_2" */
    '\x01','\x9c','V','A','R','_','\x14','2',
/* 0x1b49c = "VERR_ISOFS_BAD_EXTAD" */
    '\x01','\x97','\x1d','E','X','T','A','D',
/* 0x1b4a4 = "VWRN_NO_DIGITS" */
    '\xe6','\x60','D','I','G','I','T','S',
/* 0x1b4ac = "Invalid scheme." */
    '\x0c','s','c','h','e','m','e','.',
/* 0x1b4b4 = "section " */
    's','e','c','t','i','o','n',' ',
/* 0x1b4bc = "Unknown " */
    'U','n','k','n','o','w','n',' ',
/* 0x1b4c4 = "VERR_INVALID_UTF8_ENCODING" */
    '\x01','\x05','U','T','F','8','_','\xc6',
/* 0x1b4cc = "VERR_NO_CONT_MEMORY" */
    '\x01','\x60','C','O','N','T','_','\xb6',
/* 0x1b4d4 = "VERR_PDM_HM_IPE" */
    '\x01','\x7d','H','M','_','I','P','E',
/* 0x1b4dc = "VERR_FILE_LOCK_FAILED" */
    '\x01','\xab','L','O','C','K','_','\x17',
/* 0x1b4e4 = "catalog " */
    'c','a','t','a','l','o','g',' ',
/* 0x1b4ec = "VERR_VRDP_NOT_SUPPORTED" */
    '\x01','V','R','D','P','_','\x06','\x82',
/* 0x1b4f4 = "Timeout." */
    'T','i','m','e','o','u','t','.',
/* 0x1b4fc = "NEM internal processing error #6." */
    '\xee',' ','\x16','\x04','\x09','#','6','.',
/* 0x1b504 = "VERR_WRITE_ERROR" */
    '\x01','W','R','I','T','E','_','\x1b',
/* 0x1b50c = "INVALID_" */
    'I','N','V','A','L','I','D','_',
/* 0x1b514 = "Invalid Mod/RM." */
    '\x0c','M','o','d','/','R','M','.',
/* 0x1b51c = "NEM internal processing error #2." */
    '\xee',' ','\x16','\x04','\x09','#','2','.',
/* 0x1b524 = "X509 certificate verification error." */
    'X','5','0','9',' ','\xa0','\xf8','\x85',
/* 0x1b52c = "VINF_TIMEOUT" */
    '\x0e','T','I','M','E','O','U','T',
/* 0x1b534 = "VERR_ISOFS_TOO_MANY_LVDS" */
    '\x01','\x97','\x1a','\xac','L','V','D','S',
/* 0x1b53c = "VERR_CV_TODO" */
    '\x01','C','V','_','T','O','D','O',
/* 0x1b544 = "VERR_SSM_BAD_REC_TYPE" */
    '\x01','\xb0','\x1d','R','E','C','_','\xb5',
/* 0x1b54c = "Retry the operation." */
    'R','e','t','r','y',' ','\x02','\xea',
/* 0x1b554 = "VERR_APIC_IPE_2" */
    '\x01','A','P','I','C','_','\x14','2',
/* 0x1b55c = "VERR_APIC_IPE_1" */
    '\x01','A','P','I','C','_','\x14','1',
/* 0x1b564 = "VERR_APIC_IPE_0" */
    '\x01','A','P','I','C','_','\x14','0',
/* 0x1b56c = "support " */
    's','u','p','p','o','r','t',' ',
/* 0x1b574 = "doesn\'t " */
    'd','o','e','s','n','\'','t',' ',
/* 0x1b57c = "VERR_IEM_REG_IPE_9" */
    '\x01','\x9c','R','E','G','_','\x14','9',
/* 0x1b584 = "Unexpected VM exit." */
    '\x94','\xcd',' ','e','x','i','t','.',
/* 0x1b58c = "NEM init failed." */
    '\xee',' ','i','n','i','t',' ','\x7b',
/* 0x1b594 = "VERR_IEM_REG_IPE_7" */
    '\x01','\x9c','R','E','G','_','\x14','7',
/* 0x1b59c = "VERR_IEM_REG_IPE_6" */
    '\x01','\x9c','R','E','G','_','\x14','6',
/* 0x1b5a4 = "VERR_IEM_REG_IPE_5" */
    '\x01','\x9c','R','E','G','_','\x14','5',
/* 0x1b5ac = "VERR_IEM_REG_IPE_4" */
    '\x01','\x9c','R','E','G','_','\x14','4',
/* 0x1b5b4 = "VERR_TRPM_IPE_3" */
    '\x01','T','R','P','M','_','\x14','3',
/* 0x1b5bc = "VERR_TRPM_IPE_2" */
    '\x01','T','R','P','M','_','\x14','2',
/* 0x1b5c4 = "Generic parse error." */
    '\xa6','p','a','r','s','e',' ','\x85',
/* 0x1b5cc = "VERR_TOO_MANY_OPENS" */
    '\x01','\x1a','\xac','O','P','E','N','S',
/* 0x1b5d4 = "Bad soname." */
    '\x9f','s','o','n','a','m','e','.',
/* 0x1b5dc = "Success." */
    'S','u','c','c','e','s','s','.',
/* 0x1b5e4 = "VERR_ISOFS_VPM_NOT_SUPPORTED" */
    '\x01','\x97','V','P','M','_','\x06','\x82',
/* 0x1b5ec = "invalid " */
    'i','n','v','a','l','i','d',' ',
/* 0x1b5f4 = "Value not found." */
    'V','a','l','u','e',' ','\x08','\x89',
/* 0x1b5fc = "VERR_ISOMK_IPE_TABLE" */
    '\x01','\x22','\x14','T','A','B','L','E',
/* 0x1b604 = "Process " */
    'P','r','o','c','e','s','s',' ',
/* 0x1b60c = "VWRN_ALREADY_EXISTS" */
    '\xe6','\x9b','E','X','I','S','T','S',
/* 0x1b614 = "VERR_GVMM_IPE_1" */
    '\x01','G','V','M','M','_','\x14','1',
/* 0x1b61c = "VERR_GVMM_IPE_2" */
    '\x01','G','V','M','M','_','\x14','2',
/* 0x1b624 = "VERR_DBGF_BP_IPE_9" */
    '\x01','\xb9','_','B','P','_','\x14','9',
/* 0x1b62c = "Import ISO contains a \'." */
    '\xc3','\xc1',' ','\x8a','a',' ','\'','.',
/* 0x1b634 = "VERR_TRPM_IPE_1" */
    '\x01','T','R','P','M','_','\x14','1',
/* 0x1b63c = "UNKNOWN_" */
    'U','N','K','N','O','W','N','_',
/* 0x1b644 = "VERR_DBGF_BP_IPE_8" */
    '\x01','\xb9','_','B','P','_','\x14','8',
/* 0x1b64c = "VERR_DBGF_BP_IPE_7" */
    '\x01','\xb9','_','B','P','_','\x14','7',
/* 0x1b654 = "VERR_DBGF_BP_IPE_6" */
    '\x01','\xb9','_','B','P','_','\x14','6',
/* 0x1b65c = "VERR_HTTP_NOT_FOUND" */
    '\x01','H','T','T','P','_','\x06','\x2a',
/* 0x1b664 = "IOMMU Internal processing error #9." */
    '\xfd',' ','\x07','\x04','\x09','#','9','.',
/* 0x1b66c = "NEM internal processing error #1." */
    '\xee',' ','\x16','\x04','\x09','#','1','.',
/* 0x1b674 = "VERR_TIMEOUT" */
    '\x01','T','I','M','E','O','U','T',
/* 0x1b67c = "VERR_DBGF_UNSUPPORTED_CAST" */
    '\x01','\xb9','_','\x1c','C','A','S','T',
/* 0x1b684 = "No data in pipe." */
    '\xdf','\x9d','\x0f','p','i','p','e','.',
/* 0x1b68c = "NEM internal processing error #9." */
    '\xee',' ','\x16','\x04','\x09','#','9','.',
/* 0x1b694 = "NEM internal processing error #5." */
    '\xee',' ','\x16','\x04','\x09','#','5','.',
/* 0x1b69c = "Internal error in the VFS chain code." */
    '\x07','\x09','\x0f','\x02','\x8d',' ','\xa1','\x84',
/* 0x1b6a4 = "VERR_TOO_MANY_POSTS" */
    '\x01','\x1a','\xac','P','O','S','T','S',
/* 0x1b6ac = "The image is too big." */
    '\x03','\x26','\x0b','\x9e','b','i','g','.',
/* 0x1b6b4 = "VERR_DBGF_BP_IPE_5" */
    '\x01','\xb9','_','B','P','_','\x14','5',
/* 0x1b6bc = "VERR_XAR_UNKNOWN_FILE_TYPE" */
    '\x01','X','A','R','_','\x91','\xab','\xb5',
/* 0x1b6c4 = "VERR_HTTP_NOT_SUPPORTED" */
    '\x01','H','T','T','P','_','\x06','\x82',
/* 0x1b6cc = "IOMMU Internal processing error #1." */
    '\xfd',' ','\x07','\x04','\x09','#','1','.',
/* 0x1b6d4 = "VERR_DBGF_BP_IPE_4" */
    '\x01','\xb9','_','B','P','_','\x14','4',
/* 0x1b6dc = "IOMMU Internal processing error #5." */
    '\xfd',' ','\x07','\x04','\x09','#','5','.',
/* 0x1b6e4 = "Generic file read error." */
    '\xa6','\x1f','r','e','a','d',' ','\x85',
/* 0x1b6ec = "VERR_DBGF_BP_IPE_2" */
    '\x01','\xb9','_','B','P','_','\x14','2',
/* 0x1b6f4 = "VERR_DBGF_BP_IPE_1" */
    '\x01','\xb9','_','B','P','_','\x14','1',
/* 0x1b6fc = "VERR_DBGF_BP_IPE_3" */
    '\x01','\xb9','_','B','P','_','\x14','3',
/* 0x1b704 = "VINF_NO_CHANGE" */
    '\x0e','\x60','C','H','A','N','G','E',
/* 0x1b70c = "Unknown XAR file type value." */
    '\xef','X','A','R',' ','\x1f','\xf3','\xe8',
/* 0x1b714 = "VERR_IEM_REG_IPE_3" */
    '\x01','\x9c','R','E','G','_','\x14','3',
/* 0x1b71c = "VERR_ALREADY_POSTED" */
    '\x01','\x9b','P','O','S','T','E','D',
/* 0x1b724 = "VERR_IEM_REG_IPE_2" */
    '\x01','\x9c','R','E','G','_','\x14','2',
/* 0x1b72c = "VINF_ALREADY_POSTED" */
    '\x0e','\x9b','P','O','S','T','E','D',
/* 0x1b734 = "VERR_IEM_REG_IPE_8" */
    '\x01','\x9c','R','E','G','_','\x14','8',
/* 0x1b73c = "VINF_VMX_VMEXIT" */
    '\x0e','\xe2','V','M','E','X','I','T',
/* 0x1b744 = "No soname." */
    '\xdf','s','o','n','a','m','e','.',
/* 0x1b74c = "IOMMU Internal processing error #6." */
    '\xfd',' ','\x07','\x04','\x09','#','6','.',
/* 0x1b754 = "VERR_NO_DIGITS" */
    '\x01','\x60','D','I','G','I','T','S',
/* 0x1b75c = "VERR_VD_VDI_UNSUPPORTED_VERSION" */
    '\x01','\xff','V','D','I','_','\x1c','\xbc',
/* 0x1b764 = "VERR_ALREADY_EXISTS" */
    '\x01','\x9b','E','X','I','S','T','S',
/* 0x1b76c = "IOMMU Internal processing error #2." */
    '\xfd',' ','\x07','\x04','\x09','#','2','.',
/* 0x1b774 = "VERR_VD_UUID_MISMATCH" */
    '\x01','\xff','U','U','I','D','_','\x19',
/* 0x1b77c = "VERR_NO_CHANGE" */
    '\x01','\x60','C','H','A','N','G','E',
/* 0x1b784 = "VERR_CFGM_NOT_STRING" */
    '\x01','C','F','G','M','_','\x06','\xd5',
/* 0x1b78c = "Mode table internal error." */
    'M','o','d','e',' ','\xb1','\x16','\x85',
/* 0x1b794 = "already " */
    'a','l','r','e','a','d','y',' ',
/* 0x1b79c = "VERR_NOT_A_FILE" */
    '\x01','\x06','A','_','F','I','L','E',
/* 0x1b7a4 = "VERR_PDM_DEV_IPE_1" */
    '\x01','\x7d','D','E','V','_','\x14','1',
/* 0x1b7ac = "VERR_PDM_LUN_NOT_FOUND" */
    '\x01','\x7d','L','U','N','_','\x06','\x2a',
/* 0x1b7b4 = "VERR_EMPTY_STRING" */
    '\x01','E','M','P','T','Y','_','\xd5',
/* 0x1b7bc = "because " */
    'b','e','c','a','u','s','e',' ',
/* 0x1b7c4 = "NEM internal processing error #7." */
    '\xee',' ','\x16','\x04','\x09','#','7','.',
/* 0x1b7cc = "ENCODING" */
    'E','N','C','O','D','I','N','G',
/* 0x1b7d4 = "VERR_SUPLIB_STAT_FAILED" */
    '\x01','\xd6','S','T','A','T','_','\x17',
/* 0x1b7dc = "VWRN_INVALID_HANDLE" */
    '\xe6','\x05','H','A','N','D','L','E',
/* 0x1b7e4 = "NEM internal processing error #3." */
    '\xee',' ','\x16','\x04','\x09','#','3','.',
/* 0x1b7ec = "VERR_COM_VM_ERROR" */
    '\x01','C','O','M','_','\xcd','_','\x1b',
/* 0x1b7f4 = "VERR_IEM_VAR_IPE_9" */
    '\x01','\x9c','V','A','R','_','\x14','9',
/* 0x1b7fc = "Unsupported cipher." */
    '\x98','c','i','p','h','e','r','.',
/* 0x1b804 = "Generic " */
    'G','e','n','e','r','i','c',' ',
/* 0x1b80c = "leaving " */
    'l','e','a','v','i','n','g',' ',
/* 0x1b814 = "VERR_CPUM_IPE_2" */
    '\x01','C','P','U','M','_','\x14','2',
/* 0x1b81c = "VERR_ISOFS_MPM_NOT_SUPPORTED" */
    '\x01','\x97','M','P','M','_','\x06','\x82',
/* 0x1b824 = "VINF_EM_HALT" */
    '\x0e','E','M','_','H','A','L','T',
/* 0x1b82c = "VERR_NO_EXEC_MEMORY" */
    '\x01','\x60','E','X','E','C','_','\xb6',
/* 0x1b834 = "VERR_LDRVI_PARSE_BER_ERROR" */
    '\x01','\xf4','\xe4','B','E','R','_','\x1b',
/* 0x1b83c = "IOMMU Internal processing error #7." */
    '\xfd',' ','\x07','\x04','\x09','#','7','.',
/* 0x1b844 = "VERR_SUPDRV_VTG_BAD_STRING" */
    '\x01','\x90','V','T','G','_','\x1d','\xd5',
/* 0x1b84c = "request " */
    'r','e','q','u','e','s','t',' ',
/* 0x1b854 = "content " */
    'c','o','n','t','e','n','t',' ',
/* 0x1b85c = "IOMMU Internal processing error #3." */
    '\xfd',' ','\x07','\x04','\x09','#','3','.',
/* 0x1b864 = "VERR_DBGF_BP_NOT_FOUND" */
    '\x01','\xb9','_','B','P','_','\x06','\x2a',
/* 0x1b86c = "process " */
    'p','r','o','c','e','s','s',' ',
/* 0x1b874 = "NEM internal processing error #0." */
    '\xee',' ','\x16','\x04','\x09','#','0','.',
/* 0x1b87c = "VERR_CR_PKCS7_NOT_DATA" */
    '\x01','\x24','\xe5','\x06','D','A','T','A',
/* 0x1b884 = "IOMMU Internal processing error #0." */
    '\xfd',' ','\x07','\x04','\x09','#','0','.',
/* 0x1b88c = "Invalid " */
    'I','n','v','a','l','i','d',' ',
/* 0x1b894 = "Generic store error." */
    '\xa6','s','t','o','r','e',' ','\x85',
/* 0x1b89c = "VERR_PDM_HIF_INVALID_VERSION" */
    '\x01','\x7d','H','I','F','_','\x05','\xbc',
/* 0x1b8a4 = "NEM internal processing error #8." */
    '\xee',' ','\x16','\x04','\x09','#','8','.',
/* 0x1b8ac = "VERR_CR_KEY_UNKNOWN_TYPE" */
    '\x01','\x24','K','E','Y','_','\x91','\xb5',
/* 0x1b8b4 = "VERR_IGNORED" */
    '\x01','I','G','N','O','R','E','D',
/* 0x1b8bc = "VERR_NO_PHYS_MEMORY" */
    '\x01','\x60','P','H','Y','S','_','\xb6',
/* 0x1b8c4 = "VERR_VRDP_NO_MEMORY" */
    '\x01','V','R','D','P','_','\x60','\xb6',
/* 0x1b8cc = "VERR_CPUM_IPE_1" */
    '\x01','C','P','U','M','_','\x14','1',
/* 0x1b8d4 = "VERR_GMM_PAGE_NOT_FOUND" */
    '\x01','G','M','M','_','\xdc','\x06','\x2a',
/* 0x1b8dc = "VERR_PATH_NOT_FOUND" */
    '\x01','P','A','T','H','_','\x06','\x2a',
/* 0x1b8e4 = "NEM internal processing error #4." */
    '\xee',' ','\x16','\x04','\x09','#','4','.',
/* 0x1b8ec = "VERR_ISOFS_SPM_NOT_SUPPORTED" */
    '\x01','\x97','S','P','M','_','\x06','\x82',
/* 0x1b8f4 = "Invalid handle." */
    '\x0c','h','a','n','d','l','e','.',
/* 0x1b8fc = "VWRN_WRONG_TYPE" */
    '\xe6','W','R','O','N','G','_','\xb5',
/* 0x1b904 = "VERR_IEM_VAR_IPE_8" */
    '\x01','\x9c','V','A','R','_','\x14','8',
/* 0x1b90c = "VERR_CFGM_IPE_1" */
    '\x01','C','F','G','M','_','\x14','1',
/* 0x1b914 = "VERR_ISOFS_UNSUPPORTED_TAG_VERSION" */
    '\x01','\x97','\x1c','T','A','G','_','\xbc',
/* 0x1b91c = "IOMMU Internal processing error #4." */
    '\xfd',' ','\x07','\x04','\x09','#','4','.',
/* 0x1b924 = "VINF_SUCCESS" */
    '\x0e','S','U','C','C','E','S','S',
/* 0x1b92c = "LUN type is not supported." */
    'L','U','N',' ','\xf3','\x0b','\x08','\xa4',
/* 0x1b934 = "VERR_VD_RAW_INVALID_TYPE" */
    '\x01','\xff','R','A','W','_','\x05','\xb5',
/* 0x1b93c = "IOMMU Internal processing error #8." */
    '\xfd',' ','\x07','\x04','\x09','#','8','.',
/* 0x1b944 = "VERR_IEM_VAR_IPE_6" */
    '\x01','\x9c','V','A','R','_','\x14','6',
/* 0x1b94c = "VERR_IEM_VAR_IPE_5" */
    '\x01','\x9c','V','A','R','_','\x14','5',
/* 0x1b954 = "VERR_IEM_VAR_IPE_4" */
    '\x01','\x9c','V','A','R','_','\x14','4',
/* 0x1b95c = "VERR_INVALID_CPU_ID" */
    '\x01','\x05','C','P','U','_','I','D',
/* 0x1b964 = "VERR_IEM_VAR_IPE_7" */
    '\x01','\x9c','V','A','R','_','\x14','7',
/* 0x1b96c = "VERR_INVALID_HANDLE" */
    '\x01','\x05','H','A','N','D','L','E',
/* 0x1b974 = "ALREADY_" */
    'A','L','R','E','A','D','Y','_',
/* 0x1b97c = "VERR_WRONG_TYPE" */
    '\x01','W','R','O','N','G','_','\xb5',
/* 0x1b984 = "VERR_ALREADY_LOADED" */
    '\x01','\x9b','L','O','A','D','E','D',
/* 0x1b98c = "VERR_ISOFS_TOO_MANY_PDS" */
    '\x01','\x97','\x1a','\xac','P','D','S',
/* 0x1b993 = "VERR_READ_ERROR" */
    '\x01','R','E','A','D','_','\x1b',
/* 0x1b99a = "The VMMR0." */
    '\x03','V','M','M','R','0','.',
/* 0x1b9a1 = "VERR_OPEN_FAILED" */
    '\x01','O','P','E','N','_','\x17',
/* 0x1b9a8 = "VERR_VFS_CHAIN_IPE" */
    '\x01','\x8d','_','\x8e','I','P','E',
/* 0x1b9af = "Path not found." */
    'P','a','t','h',' ','\x08','\x89',
/* 0x1b9b6 = "VERR_NO_TMP_MEMORY" */
    '\x01','\x60','T','M','P','_','\xb6',
/* 0x1b9bd = "VERR_INVALID_FMODE" */
    '\x01','\x05','F','M','O','D','E',
/* 0x1b9c4 = "cannot " */
    'c','a','n','n','o','t',' ',
/* 0x1b9cb = "VERR_XAR_NO_ENCODING" */
    '\x01','X','A','R','_','\x60','\xc6',
/* 0x1b9d2 = "Bad header size." */
    '\x9f','\xb3','s','i','z','e','.',
/* 0x1b9d9 = "VERR_MEMORY_BUSY" */
    '\x01','\xb6','_','B','U','S','Y',
/* 0x1b9e0 = "VERR_SVM_IPE_5" */
    '\x01','S','V','M','_','\x14','5',
/* 0x1b9e7 = "VERR_NOT_OWNER" */
    '\x01','\x06','O','W','N','E','R',
/* 0x1b9ee = "VERR_SSM_UNEXPECTED_DATA" */
    '\x01','\xb0','\x88','D','A','T','A',
/* 0x1b9f5 = "Reason " */
    'R','e','a','s','o','n',' ',
/* 0x1b9fc = "VERR_SSM_UNEXPECTED_PASS" */
    '\x01','\xb0','\x88','P','A','S','S',
/* 0x1ba03 = "VERR_SVM_IPE_3" */
    '\x01','S','V','M','_','\x14','3',
/* 0x1ba0a = "VERR_NOT_SUP_BY_NEM" */
    '\x01','\x06','\x95','B','Y','_','\xee',
/* 0x1ba11 = "VERR_GIM_IPE_3" */
    '\x01','G','I','M','_','\x14','3',
/* 0x1ba18 = "VERR_GIM_IPE_2" */
    '\x01','G','I','M','_','\x14','2',
/* 0x1ba1f = "VERR_GIM_IPE_1" */
    '\x01','G','I','M','_','\x14','1',
/* 0x1ba26 = "VERR_VM_INVALID_VM_STATE" */
    '\x01','\xcd','_','\x05','\xcd','_','\xf1',
/* 0x1ba2d = "VERR_VD_DEK_MISSING" */
    '\x01','\xff','D','E','K','_','\xc4',
/* 0x1ba34 = "VERR_NO_STR_MEMORY" */
    '\x01','\x60','S','T','R','_','\xb6',
/* 0x1ba3b = "memory " */
    'm','e','m','o','r','y',' ',
/* 0x1ba42 = "Unable " */
    'U','n','a','b','l','e',' ',
/* 0x1ba49 = "VERR_SUP_VP_NO_MEMORY_STATE" */
    '\x01','\x95','\xbd','\x60','\xb6','_','\xf1',
/* 0x1ba50 = "VERR_TOO_MANY_CPUS" */
    '\x01','\x1a','\xac','C','P','U','S',
/* 0x1ba57 = "VERR_DBG_FILE_MISMATCH" */
    '\x01','D','B','G','_','\xab','\x19',
/* 0x1ba5e = "The VMMRC." */
    '\x03','V','M','M','R','C','.',
/* 0x1ba65 = "driver " */
    'd','r','i','v','e','r',' ',
/* 0x1ba6c = "failed " */
    'f','a','i','l','e','d',' ',
/* 0x1ba73 = "VERR_SEM_NOT_FOUND" */
    '\x01','S','E','M','_','\x06','\x2a',
/* 0x1ba7a = "volume " */
    'v','o','l','u','m','e',' ',
/* 0x1ba81 = "number " */
    'n','u','m','b','e','r',' ',
/* 0x1ba88 = "IMPORT_" */
    'I','M','P','O','R','T','_',
/* 0x1ba8f = "File not found." */
    'F','i','l','e',' ','\x08','\x89',
/* 0x1ba96 = "VERR_ZIP_UNSUPPORTED_VERSION" */
    '\x01','Z','I','P','_','\x1c','\xbc',
/* 0x1ba9d = "VERR_COM_PDM_ERROR" */
    '\x01','C','O','M','_','\x7d','\x1b',
/* 0x1baa4 = "Syntax " */
    'S','y','n','t','a','x',' ',
/* 0x1baab = "failed." */
    'f','a','i','l','e','d','.',
/* 0x1bab2 = "VERR_INVALID_DRIVE" */
    '\x01','\x05','D','R','I','V','E',
/* 0x1bab9 = "Generic CURL error." */
    '\xa6','C','U','R','L',' ','\x85',
/* 0x1bac0 = "VERR_CPU_NOT_FOUND" */
    '\x01','C','P','U','_','\x06','\x2a',
/* 0x1bac7 = "error: " */
    'e','r','r','o','r',':',' ',
/* 0x1bace = "DIGEST_" */
    'D','I','G','E','S','T','_',
/* 0x1bad5 = "VERR_DBGC_BP_NOT_FOUND" */
    '\x01','\xfc','B','P','_','\x06','\x2a',
/* 0x1badc = "Failed " */
    'F','a','i','l','e','d',' ',
/* 0x1bae3 = "Invalid image type." */
    '\x0c','\x26','t','y','p','e','.',
/* 0x1baea = "VWRN_INVALID_MAGIC" */
    '\xe6','\x05','M','A','G','I','C',
/* 0x1baf1 = "VERR_IO_CRC" */
    '\x01','I','O','_','C','R','C',
/* 0x1baf8 = "VERR_VM_UNEXPECTED_VM_STATE" */
    '\x01','\xcd','_','\x88','\xcd','_','\xf1',
/* 0x1baff = "VERR_INVALID_MAGIC" */
    '\x01','\x05','M','A','G','I','C',
/* 0x1bb06 = "VERR_COM_FILE_ERROR" */
    '\x01','C','O','M','_','\xab','\x1b',
/* 0x1bb0d = "Import " */
    'I','m','p','o','r','t',' ',
/* 0x1bb14 = "VERR_VMX_UNEXPECTED_EXIT" */
    '\x01','\xe2','\x88','E','X','I','T',
/* 0x1bb1b = "VERR_ALREADY_RESET" */
    '\x01','\x9b','R','E','S','E','T',
/* 0x1bb22 = "digest " */
    'd','i','g','e','s','t',' ',
/* 0x1bb29 = "VERR_LDRVI_UNSUPPORTED_ARCH" */
    '\x01','\xf4','\x1c','A','R','C','H',
/* 0x1bb30 = "VERR_SVM_IPE_2" */
    '\x01','S','V','M','_','\x14','2',
/* 0x1bb37 = "VERR_INVALID_FLAGS" */
    '\x01','\x05','F','L','A','G','S',
/* 0x1bb3e = "VERR_CV_IPE" */
    '\x01','C','V','_','I','P','E',
/* 0x1bb45 = "VERR_SVM_IPE_1" */
    '\x01','S','V','M','_','\x14','1',
/* 0x1bb4c = "object " */
    'o','b','j','e','c','t',' ',
/* 0x1bb53 = "VERR_SVM_IPE_4" */
    '\x01','S','V','M','_','\x14','4',
/* 0x1bb5a = "SUPDRV_" */
    'S','U','P','D','R','V','_',
/* 0x1bb61 = "VERR_SSM_INTEGRITY_CRC" */
    '\x01','\xb0','\xf7','_','C','R','C',
/* 0x1bb68 = "VINF_EM_OFF" */
    '\x0e','E','M','_','O','F','F',
/* 0x1bb6f = "VERR_ZIP_NO_MEMORY" */
    '\x01','Z','I','P','_','\x60','\xb6',
/* 0x1bb76 = "VERR_ASN1_TOO_LONG" */
    '\x01','\xa2','\x1a','L','O','N','G',
/* 0x1bb7d = "loader " */
    'l','o','a','d','e','r',' ',
/* 0x1bb84 = "Syntax error - too many arguments." */
    '\xfa','\x09','-',' ','\x9e','\xb4','\xdd',
/* 0x1bb8b = "SUPLIB_" */
    'S','U','P','L','I','B','_',
/* 0x1bb92 = "Invalid pVMCB." */
    '\x0c','p','V','M','C','B','.',
/* 0x1bb99 = "VERR_LOCK_FAILED" */
    '\x01','L','O','C','K','_','\x17',
/* 0x1bba0 = "VERR_CPU_IPE_1" */
    '\x01','C','P','U','_','\x14','1',
/* 0x1bba7 = "MISSING" */
    'M','I','S','S','I','N','G',
/* 0x1bbae = "VERR_NOT_EQUAL" */
    '\x01','\x06','E','Q','U','A','L',
/* 0x1bbb5 = "VERR_COM_NOT_SUPPORTED" */
    '\x01','C','O','M','_','\x06','\x82',
/* 0x1bbbc = "VERR_XAR_UNSUPPORTED_VERSION" */
    '\x01','X','A','R','_','\x1c','\xbc',
/* 0x1bbc3 = "No image UUID." */
    '\xdf','\x26','U','U','I','D','.',
/* 0x1bbca = "VERR_NO_LOW_MEMORY" */
    '\x01','\x60','L','O','W','_','\xb6',
/* 0x1bbd1 = "VERR_ASN1_INTERNAL_ERROR_2" */
    '\x01','\xa2','\xc2','\x1b','_','2',
/* 0x1bbd7 = "VERR_ASN1_INTERNAL_ERROR_1" */
    '\x01','\xa2','\xc2','\x1b','_','1',
/* 0x1bbdd = "PKCS7_" */
    'P','K','C','S','7','_',
/* 0x1bbe3 = "found." */
    'f','o','u','n','d','.',
/* 0x1bbe9 = "The specified process was not found." */
    '\x03','\x18','\x92','\x11','\x08','\x89',
/* 0x1bbef = "The specified register was not found." */
    '\x03','\x18','\xeb','\x11','\x08','\x89',
/* 0x1bbf5 = "guest " */
    'g','u','e','s','t',' ',
/* 0x1bbfb = "VERR_TM_IPE_9" */
    '\x01','T','M','_','\x14','9',
/* 0x1bc01 = "VERR_TM_IPE_8" */
    '\x01','T','M','_','\x14','8',
/* 0x1bc07 = "VERR_TM_IPE_7" */
    '\x01','T','M','_','\x14','7',
/* 0x1bc0d = "VERR_TM_IPE_6" */
    '\x01','T','M','_','\x14','6',
/* 0x1bc13 = "VERR_TM_IPE_5" */
    '\x01','T','M','_','\x14','5',
/* 0x1bc19 = "VERR_ZIP_ERROR" */
    '\x01','Z','I','P','_','\x1b',
/* 0x1bc1f = "VERR_IDT_FAILED" */
    '\x01','I','D','T','_','\x17',
/* 0x1bc25 = "chain " */
    'c','h','a','i','n',' ',
/* 0x1bc2b = "VERR_TM_IPE_4" */
    '\x01','T','M','_','\x14','4',
/* 0x1bc31 = "VERR_TM_IPE_3" */
    '\x01','T','M','_','\x14','3',
/* 0x1bc37 = "VERR_EM_INTERNAL_ERROR" */
    '\x01','E','M','_','\xc2','\x1b',
/* 0x1bc3d = "VERR_TM_IPE_2" */
    '\x01','T','M','_','\x14','2',
/* 0x1bc43 = "VERR_MAP_FAILED" */
    '\x01','M','A','P','_','\x17',
/* 0x1bc49 = "VERR_ISOFS_UNSUPPORTED_ICB" */
    '\x01','\x97','\x1c','I','C','B',
/* 0x1bc4f = "which " */
    'w','h','i','c','h',' ',
/* 0x1bc55 = "Error " */
    'E','r','r','o','r',' ',
/* 0x1bc5b = "VERR_TM_IPE_1" */
    '\x01','T','M','_','\x14','1',
/* 0x1bc61 = "VERR_TM_UNKNOWN_STATE" */
    '\x01','T','M','_','\x91','\xf1',
/* 0x1bc67 = "entry " */
    'e','n','t','r','y',' ',
/* 0x1bc6d = "VERR_EM_NO_MEMORY" */
    '\x01','E','M','_','\x60','\xb6',
/* 0x1bc73 = "LDRVI_" */
    'L','D','R','V','I','_',
/* 0x1bc79 = "VERR_NO_DATA" */
    '\x01','\x60','D','A','T','A',
/* 0x1bc7f = "VERR_INVALID_NAME" */
    '\x01','\x05','N','A','M','E',
/* 0x1bc85 = "VERR_VFS_CHAIN_UNKNOWN_TYPE" */
    '\x01','\x8d','_','\x8e','\x91','\xb5',
/* 0x1bc8b = "error." */
    'e','r','r','o','r','.',
/* 0x1bc91 = "error " */
    'e','r','r','o','r',' ',
/* 0x1bc97 = "VERR_LDRMACHO_TODO" */
    '\x01','\xe9','T','O','D','O',
/* 0x1bc9d = "VERR_ISOFS_NO_LVD" */
    '\x01','\x97','\x60','L','V','D',
/* 0x1bca3 = "Bad pipe." */
    '\x9f','p','i','p','e','.',
/* 0x1bca9 = "Long ASN." */
    'L','o','n','g',' ','\xf6',
/* 0x1bcaf = "Invalid XML found." */
    '\x0c','X','M','L',' ','\x89',
/* 0x1bcb5 = "Generic SPC error." */
    '\xa6','S','P','C',' ','\x85',
/* 0x1bcbb = "VERR_BAD_PIPE" */
    '\x01','\x1d','P','I','P','E',
/* 0x1bcc1 = "VERR_DBGC_QUIT" */
    '\x01','\xfc','Q','U','I','T',
/* 0x1bcc7 = "VERR_ASN1_INTERNAL_ERROR_5" */
    '\x01','\xa2','\xc2','\x1b','_','5',
/* 0x1bccd = "VERR_ASN1_INTERNAL_ERROR_4" */
    '\x01','\xa2','\xc2','\x1b','_','4',
/* 0x1bcd3 = "VERR_ASN1_INTERNAL_ERROR_3" */
    '\x01','\xa2','\xc2','\x1b','_','3',
/* 0x1bcd9 = "VERR_HM_IPE_5" */
    '\x01','H','M','_','\x14','5',
/* 0x1bcdf = "VERR_HM_IPE_4" */
    '\x01','H','M','_','\x14','4',
/* 0x1bce5 = "VERR_HM_IPE_3" */
    '\x01','H','M','_','\x14','3',
/* 0x1bceb = "VERR_HM_IPE_2" */
    '\x01','H','M','_','\x14','2',
/* 0x1bcf1 = "VERR_HM_IPE_1" */
    '\x01','H','M','_','\x14','1',
/* 0x1bcf7 = "VERR_VMX_NO_VMX" */
    '\x01','\xe2','\x60','V','M','X',
/* 0x1bcfd = "Internal error in the X." */
    '\x07','\x09','\x0f','\x02','X','.',
/* 0x1bd03 = "VERR_LDRVI_NO_MEMORY_STATE" */
    '\x01','\xf4','\x60','\xb6','_','\xf1',
/* 0x1bd09 = "Seek error." */
    'S','e','e','k',' ','\x85',
/* 0x1bd0f = "value " */
    'v','a','l','u','e',' ',
/* 0x1bd15 = "value." */
    'v','a','l','u','e','.',
/* 0x1bd1b = "VERR_FILE_TOO_BIG" */
    '\x01','\xab','\x1a','B','I','G',
/* 0x1bd21 = "ISOMK_" */
    'I','S','O','M','K','_',
/* 0x1bd27 = "VERR_SEM_ERROR" */
    '\x01','S','E','M','_','\x1b',
/* 0x1bd2d = "state " */
    's','t','a','t','e',' ',
/* 0x1bd33 = "IPRT error." */
    'I','P','R','T',' ','\x85',
/* 0x1bd39 = "VERR_TM_INVALID_STATE" */
    '\x01','T','M','_','\x05','\xf1',
/* 0x1bd3f = "image " */
    'i','m','a','g','e',' ',
/* 0x1bd45 = "VERR_DBGC_PARSE_BUG" */
    '\x01','\xfc','\xe4','B','U','G',
/* 0x1bd4b = "Generic RSA error." */
    '\xa6','R','S','A',' ','\x85',
/* 0x1bd51 = "ISOFS_" */
    'I','S','O','F','S','_',
/* 0x1bd57 = "VINF_EM_NO_MEMORY" */
    '\x0e','E','M','_','\x60','\xb6',
/* 0x1bd5d = "VERR_LDRVI_PARSE_IPE" */
    '\x01','\xf4','\xe4','I','P','E',
/* 0x1bd63 = "FAILED" */
    'F','A','I','L','E','D',
/* 0x1bd69 = "VERR_FILE_IO_ERROR" */
    '\x01','\xab','I','O','_','\x1b',
/* 0x1bd6f = "VERR_S3_NOT_FOUND" */
    '\x01','S','3','_','\x06','\x2a',
/* 0x1bd75 = "VERR_ISOFS_NO_PVD" */
    '\x01','\x97','\x60','P','V','D',
/* 0x1bd7b = "Generic zip error." */
    '\xa6','z','i','p',' ','\x85',
/* 0x1bd81 = "Unsupported CPU." */
    '\x98','C','P','U','.',
/* 0x1bd86 = "FILE_" */
    'F','I','L','E','_',
/* 0x1bd8b = "that " */
    't','h','a','t',' ',
/* 0x1bd90 = "VERR_IOMMU_IPE_9" */
    '\x01','\xfd','_','\x14','9',
/* 0x1bd95 = "VERR_IOMMU_IPE_8" */
    '\x01','\xfd','_','\x14','8',
/* 0x1bd9a = "VERR_IOMMU_IPE_7" */
    '\x01','\xfd','_','\x14','7',
/* 0x1bd9f = "VERR_IOMMU_IPE_6" */
    '\x01','\xfd','_','\x14','6',
/* 0x1bda4 = "VERR_IOMMU_IPE_5" */
    '\x01','\xfd','_','\x14','5',
/* 0x1bda9 = "VERR_IOMMU_IPE_4" */
    '\x01','\xfd','_','\x14','4',
/* 0x1bdae = "VERR_IOMMU_IPE_3" */
    '\x01','\xfd','_','\x14','3',
/* 0x1bdb3 = "VERR_IOMMU_IPE_2" */
    '\x01','\xfd','_','\x14','2',
/* 0x1bdb8 = "VERR_IOMMU_IPE_1" */
    '\x01','\xfd','_','\x14','1',
/* 0x1bdbd = "VWRN_" */
    'V','W','R','N','_',
/* 0x1bdc2 = "many " */
    'm','a','n','y',' ',
/* 0x1bdc7 = "Internal error #1." */
    '\x07','\x09','#','1','.',
/* 0x1bdcc = "VERR_SSM_INTEGRITY_SIZE" */
    '\x01','\xb0','\xf7','_','\xf9',
/* 0x1bdd1 = "VERR_CR_DIGEST_NOT_SUPPORTED" */
    '\x01','\x24','\xbe','\x06','\x82',
/* 0x1bdd6 = "VERR_SSM_INTEGRITY_VERSION" */
    '\x01','\xb0','\xf7','_','\xbc',
/* 0x1bddb = "Not supported." */
    'N','o','t',' ','\xa4',
/* 0x1bde0 = "Internal error no." */
    '\x07','\x09','n','o','.',
/* 0x1bde5 = "Internal error #9." */
    '\x07','\x09','#','9','.',
/* 0x1bdea = "VERR_INVALID_RPL" */
    '\x01','\x05','R','P','L',
/* 0x1bdef = "been " */
    'b','e','e','n',' ',
/* 0x1bdf4 = "Internal error #5." */
    '\x07','\x09','#','5','.',
/* 0x1bdf9 = "VINF_" */
    'V','I','N','F','_',
/* 0x1bdfe = "VERR_IOMMU_IPE_0" */
    '\x01','\xfd','_','\x14','0',
/* 0x1be03 = "VERR_NO_VM_MEMORY" */
    '\x01','\x60','\xcd','_','\xb6',
/* 0x1be08 = "Internal error #6." */
    '\x07','\x09','#','6','.',
/* 0x1be0d = "VERR_CR_PKCS7_INTERNAL_ERROR" */
    '\x01','\x24','\xe5','\xc2','\x1b',
/* 0x1be12 = "VERR_DBGF_IPE_1" */
    '\x01','\xb9','_','\x14','1',
/* 0x1be17 = "VERR_NEM_IPE_1" */
    '\x01','\xee','_','\x14','1',
/* 0x1be1c = "Internal error #2." */
    '\x07','\x09','#','2','.',
/* 0x1be21 = "X509_" */
    'X','5','0','9','_',
/* 0x1be26 = "ASN1_" */
    'A','S','N','1','_',
/* 0x1be2b = "VERR_INTERNAL_ERROR_5" */
    '\x01','\xc2','\x1b','_','5',
/* 0x1be30 = "VERR_INTERNAL_ERROR_4" */
    '\x01','\xc2','\x1b','_','4',
/* 0x1be35 = "VERR_INTERNAL_ERROR_3" */
    '\x01','\xc2','\x1b','_','3',
/* 0x1be3a = "VERR_INTERNAL_ERROR_2" */
    '\x01','\xc2','\x1b','_','2',
/* 0x1be3f = "VERR_DBGC_PARSE_NO_MEMORY" */
    '\x01','\xfc','\xe4','\x60','\xb6',
/* 0x1be44 = "IOMMU" */
    'I','O','M','M','U',
/* 0x1be49 = "VERR_NEM_IPE_0" */
    '\x01','\xee','_','\x14','0',
/* 0x1be4e = "VERR_" */
    'V','E','R','R','_',
/* 0x1be53 = "Internal error #7." */
    '\x07','\x09','#','7','.',
/* 0x1be58 = "VERR_DBGC_IPE" */
    '\x01','\xfc','I','P','E',
/* 0x1be5d = "does " */
    'd','o','e','s',' ',
/* 0x1be62 = "VERR_CR_X509_INTERNAL_ERROR" */
    '\x01','\x24','\xb7','\xc2','\x1b',
/* 0x1be67 = "MANY_" */
    'M','A','N','Y','_',
/* 0x1be6c = "VERR_ISOFS_NO_PD" */
    '\x01','\x97','\x60','P','D',
/* 0x1be71 = "page " */
    'p','a','g','e',' ',
/* 0x1be76 = "VWRN_UNSUPPORTED_CPU" */
    '\xe6','\x1c','C','P','U',
/* 0x1be7b = "FOUND" */
    'F','O','U','N','D',
/* 0x1be80 = "IPC error." */
    'I','P','C',' ','\x85',
/* 0x1be85 = "ERROR" */
    'E','R','R','O','R',
/* 0x1be8a = "DBGC_" */
    'D','B','G','C','_',
/* 0x1be8f = "Internal error #3." */
    '\x07','\x09','#','3','.',
/* 0x1be94 = "VERR_NEM_IPE_9" */
    '\x01','\xee','_','\x14','9',
/* 0x1be99 = "VERR_NEM_IPE_8" */
    '\x01','\xee','_','\x14','8',
/* 0x1be9e = "VERR_NEM_IPE_7" */
    '\x01','\xee','_','\x14','7',
/* 0x1bea3 = "VERR_NEM_IPE_6" */
    '\x01','\xee','_','\x14','6',
/* 0x1bea8 = "VERR_NEM_IPE_4" */
    '\x01','\xee','_','\x14','4',
/* 0x1bead = "VERR_NEM_IPE_3" */
    '\x01','\xee','_','\x14','3',
/* 0x1beb2 = "VERR_NEM_IPE_2" */
    '\x01','\xee','_','\x14','2',
/* 0x1beb7 = "VERR_NEM_IPE_5" */
    '\x01','\xee','_','\x14','5',
/* 0x1bebc = "VERR_ISOFS_UNKNOWN_FILE_TYPE" */
    '\x01','\x97','\x91','\xab','\xb5',
/* 0x1bec1 = "VERR_LDRMACHO_UNSUPPORTED_FILE_TYPE" */
    '\x01','\xe9','\x1c','\xab','\xb5',
/* 0x1bec6 = "with " */
    'w','i','t','h',' ',
/* 0x1becb = "Internal error #4." */
    '\x07','\x09','#','4','.',
/* 0x1bed0 = "Internal error #8." */
    '\x07','\x09','#','8','.',
/* 0x1bed5 = "VERR_PGM_UNEXPECTED_PAGE_STATE" */
    '\x01','\x8c','\x88','\xdc','\xf1',
/* 0x1beda = "VERR_ISOFS_IPE_4" */
    '\x01','\x97','\x14','4',
/* 0x1bede = "VERR_ISOFS_IPE_3" */
    '\x01','\x97','\x14','3',
/* 0x1bee2 = "VERR_VMX_IPE_5" */
    '\x01','\xe2','\x14','5',
/* 0x1bee6 = "VERR_VMX_IPE_4" */
    '\x01','\xe2','\x14','4',
/* 0x1beea = "VERR_VMX_IPE_3" */
    '\x01','\xe2','\x14','3',
/* 0x1beee = "VERR_EOF" */
    '\x01','E','O','F',
/* 0x1bef2 = "DBGF" */
    'D','B','G','F',
/* 0x1bef6 = "VERR_IEM_IPE_9" */
    '\x01','\x9c','\x14','9',
/* 0x1befa = "VERR_IEM_IPE_8" */
    '\x01','\x9c','\x14','8',
/* 0x1befe = "VERR_IEM_IPE_7" */
    '\x01','\x9c','\x14','7',
/* 0x1bf02 = "VERR_IEM_IPE_6" */
    '\x01','\x9c','\x14','6',
/* 0x1bf06 = "VERR_IEM_IPE_4" */
    '\x01','\x9c','\x14','4',
/* 0x1bf0a = "The " */
    'T','h','e',' ',
/* 0x1bf0e = "VERR_VD_INVALID_SIZE" */
    '\x01','\xff','\x05','\xf9',
/* 0x1bf12 = "VERR_VD_INVALID_STATE" */
    '\x01','\xff','\x05','\xf1',
/* 0x1bf16 = "VERR_VD_INVALID_TYPE" */
    '\x01','\xff','\x05','\xb5',
/* 0x1bf1a = "too " */
    't','o','o',' ',
/* 0x1bf1e = "TOO_" */
    'T','O','O','_',
/* 0x1bf22 = "VERR_IEM_IPE_3" */
    '\x01','\x9c','\x14','3',
/* 0x1bf26 = "VERR_IEM_IPE_2" */
    '\x01','\x9c','\x14','2',
/* 0x1bf2a = "VERR_IEM_IPE_1" */
    '\x01','\x9c','\x14','1',
/* 0x1bf2e = "VERR_IEM_IPE_5" */
    '\x01','\x9c','\x14','5',
/* 0x1bf32 = "was " */
    'w','a','s',' ',
/* 0x1bf36 = "VERR_VERSION_MISMATCH" */
    '\x01','\xbc','_','\x19',
/* 0x1bf3a = "PDM_" */
    'P','D','M','_',
/* 0x1bf3e = "VERR_SSM_IPE_3" */
    '\x01','\xb0','\x14','3',
/* 0x1bf42 = "has " */
    'h','a','s',' ',
/* 0x1bf46 = "VERR_SSM_IPE_2" */
    '\x01','\xb0','\x14','2',
/* 0x1bf4a = "SSM_" */
    'S','S','M','_',
/* 0x1bf4e = "Bad " */
    'B','a','d',' ',
/* 0x1bf52 = "VERR_SSM_IPE_1" */
    '\x01','\xb0','\x14','1',
/* 0x1bf56 = "VMX_" */
    'V','M','X','_',
/* 0x1bf5a = "VERR_VMX_IPE_2" */
    '\x01','\xe2','\x14','2',
/* 0x1bf5e = "VERR_VMX_IPE_1" */
    '\x01','\xe2','\x14','1',
/* 0x1bf62 = "VERR_ISOFS_IPE_2" */
    '\x01','\x97','\x14','2',
/* 0x1bf66 = "VINF_EOF" */
    '\x0e','E','O','F',
/* 0x1bf6a = "VERR_FILE_NOT_FOUND" */
    '\x01','\xab','\x06','\x2a',
/* 0x1bf6e = "VERR_NO_PAGE_MEMORY" */
    '\x01','\x60','\xdc','\xb6',
/* 0x1bf72 = "ANS." */
    'A','N','S','.',
/* 0x1bf76 = "VERR_SSM_INVALID_STATE" */
    '\x01','\xb0','\x05','\xf1',
/* 0x1bf7a = "ASN." */
    'A','S','N','.',
/* 0x1bf7e = "IEM_" */
    'I','E','M','_',
/* 0x1bf82 = "VERR_ISOFS_IPE_1" */
    '\x01','\x97','\x14','1',
/* 0x1bf86 = "Generic invalid state error." */
    '\xa6','\x8f','\xca','\x85',
/* 0x1bf8a = "SUP_" */
    'S','U','P','_',
/* 0x1bf8e = "PGM_" */
    'P','G','M','_',
/* 0x1bf92 = "VERR_ISOFS_IPE_5" */
    '\x01','\x97','\x14','5',
/* 0x1bf96 = "BAD_" */
    'B','A','D','_',
/* 0x1bf9a = "Unsupported X." */
    '\x98','X','.',
/* 0x1bf9d = "Encountered an ASN." */
    '\xa5','\x87','\xf6',
/* 0x1bfa0 = "VERR_ASN1_ERROR" */
    '\x01','\xa2','\x1b',
/* 0x1bfa3 = "VERR_NO_MEMORY" */
    '\x01','\x60','\xb6',
/* 0x1bfa6 = "VERR_NOT_SUPPORTED" */
    '\x01','\x06','\x82',
/* 0x1bfa9 = "VERR_NOT_FOUND" */
    '\x01','\x06','\x2a',
/* 0x1bfac = "Unknown X." */
    '\xef','X','.',
/*