/** @file
 * VirtualBox API class wrapper code for IHostUSBDeviceFilter.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_HOSTUSBDEVICEFILTER

#include "HostUSBDeviceFilterWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(HostUSBDeviceFilterWrap)

//
// IUSBDeviceFilter properties
//

STDMETHODIMP HostUSBDeviceFilterWrap::COMGETTER(Name)(BSTR *aName)
{
    LogRelFlow(("{%p} %s: enter aName=%p\n", this, "HostUSBDeviceFilter::getName", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aName);
        BSTROutConverter TmpName(aName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_NAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getName(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_NAME_RETURN(this, hrc, 0 /*normal*/,TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_NAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_NAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aName=%ls hrc=%Rhrc\n", this, "HostUSBDeviceFilter::getName", *aName, hrc));
    return hrc;
}

STDMETHODIMP HostUSBDeviceFilterWrap::COMSETTER(Name)(IN_BSTR aName)
{
    LogRelFlow(("{%p} %s: enter aName=%ls\n", this, "HostUSBDeviceFilter::setName", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpName(aName);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_NAME_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setName(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_NAME_RETURN(this, hrc, 0 /*normal*/,TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_NAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_NAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "HostUSBDeviceFilter::setName", hrc));
    return hrc;
}

STDMETHODIMP HostUSBDeviceFilterWrap::COMGETTER(Active)(BOOL *aActive)
{
    LogRelFlow(("{%p} %s: enter aActive=%p\n", this, "HostUSBDeviceFilter::getActive", aActive));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aActive);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_ACTIVE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getActive(aActive);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_ACTIVE_RETURN(this, hrc, 0 /*normal*/,*aActive != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_ACTIVE_RETURN(this, hrc, 1 /*hrc exception*/,*aActive != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_ACTIVE_RETURN(this, hrc, 9 /*unhandled exception*/,*aActive != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aActive=%RTbool hrc=%Rhrc\n", this, "HostUSBDeviceFilter::getActive", *aActive, hrc));
    return hrc;
}

STDMETHODIMP HostUSBDeviceFilterWrap::COMSETTER(Active)(BOOL aActive)
{
    LogRelFlow(("{%p} %s: enter aActive=%RTbool\n", this, "HostUSBDeviceFilter::setActive", aActive));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_ACTIVE_ENTER(this, aActive != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setActive(aActive != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_ACTIVE_RETURN(this, hrc, 0 /*normal*/,aActive != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_ACTIVE_RETURN(this, hrc, 1 /*hrc exception*/,aActive != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_ACTIVE_RETURN(this, hrc, 9 /*unhandled exception*/,aActive != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "HostUSBDeviceFilter::setActive", hrc));
    return hrc;
}

STDMETHODIMP HostUSBDeviceFilterWrap::COMGETTER(VendorId)(BSTR *aVendorId)
{
    LogRelFlow(("{%p} %s: enter aVendorId=%p\n", this, "HostUSBDeviceFilter::getVendorId", aVendorId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVendorId);
        BSTROutConverter TmpVendorId(aVendorId);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_VENDORID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVendorId(TmpVendorId.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_VENDORID_RETURN(this, hrc, 0 /*normal*/,TmpVendorId.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_VENDORID_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_VENDORID_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aVendorId=%ls hrc=%Rhrc\n", this, "HostUSBDeviceFilter::getVendorId", *aVendorId, hrc));
    return hrc;
}

STDMETHODIMP HostUSBDeviceFilterWrap::COMSETTER(VendorId)(IN_BSTR aVendorId)
{
    LogRelFlow(("{%p} %s: enter aVendorId=%ls\n", this, "HostUSBDeviceFilter::setVendorId", aVendorId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpVendorId(aVendorId);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_VENDORID_ENTER(this, TmpVendorId.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setVendorId(TmpVendorId.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_VENDORID_RETURN(this, hrc, 0 /*normal*/,TmpVendorId.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_VENDORID_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_VENDORID_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "HostUSBDeviceFilter::setVendorId", hrc));
    return hrc;
}

STDMETHODIMP HostUSBDeviceFilterWrap::COMGETTER(ProductId)(BSTR *aProductId)
{
    LogRelFlow(("{%p} %s: enter aProductId=%p\n", this, "HostUSBDeviceFilter::getProductId", aProductId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProductId);
        BSTROutConverter TmpProductId(aProductId);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_PRODUCTID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProductId(TmpProductId.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_PRODUCTID_RETURN(this, hrc, 0 /*normal*/,TmpProductId.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_PRODUCTID_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_PRODUCTID_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aProductId=%ls hrc=%Rhrc\n", this, "HostUSBDeviceFilter::getProductId", *aProductId, hrc));
    return hrc;
}

STDMETHODIMP HostUSBDeviceFilterWrap::COMSETTER(ProductId)(IN_BSTR aProductId)
{
    LogRelFlow(("{%p} %s: enter aProductId=%ls\n", this, "HostUSBDeviceFilter::setProductId", aProductId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpProductId(aProductId);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_PRODUCTID_ENTER(this, TmpProductId.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setProductId(TmpProductId.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_PRODUCTID_RETURN(this, hrc, 0 /*normal*/,TmpProductId.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_PRODUCTID_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_PRODUCTID_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "HostUSBDeviceFilter::setProductId", hrc));
    return hrc;
}

STDMETHODIMP HostUSBDeviceFilterWrap::COMGETTER(Revision)(BSTR *aRevision)
{
    LogRelFlow(("{%p} %s: enter aRevision=%p\n", this, "HostUSBDeviceFilter::getRevision", aRevision));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRevision);
        BSTROutConverter TmpRevision(aRevision);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_REVISION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRevision(TmpRevision.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_REVISION_RETURN(this, hrc, 0 /*normal*/,TmpRevision.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_REVISION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_REVISION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRevision=%ls hrc=%Rhrc\n", this, "HostUSBDeviceFilter::getRevision", *aRevision, hrc));
    return hrc;
}

STDMETHODIMP HostUSBDeviceFilterWrap::COMSETTER(Revision)(IN_BSTR aRevision)
{
    LogRelFlow(("{%p} %s: enter aRevision=%ls\n", this, "HostUSBDeviceFilter::setRevision", aRevision));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpRevision(aRevision);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_REVISION_ENTER(this, TmpRevision.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setRevision(TmpRevision.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_REVISION_RETURN(this, hrc, 0 /*normal*/,TmpRevision.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_REVISION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_REVISION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "HostUSBDeviceFilter::setRevision", hrc));
    return hrc;
}

STDMETHODIMP HostUSBDeviceFilterWrap::COMGETTER(Manufacturer)(BSTR *aManufacturer)
{
    LogRelFlow(("{%p} %s: enter aManufacturer=%p\n", this, "HostUSBDeviceFilter::getManufacturer", aManufacturer));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aManufacturer);
        BSTROutConverter TmpManufacturer(aManufacturer);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_MANUFACTURER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getManufacturer(TmpManufacturer.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_MANUFACTURER_RETURN(this, hrc, 0 /*normal*/,TmpManufacturer.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_MANUFACTURER_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_MANUFACTURER_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aManufacturer=%ls hrc=%Rhrc\n", this, "HostUSBDeviceFilter::getManufacturer", *aManufacturer, hrc));
    return hrc;
}

STDMETHODIMP HostUSBDeviceFilterWrap::COMSETTER(Manufacturer)(IN_BSTR aManufacturer)
{
    LogRelFlow(("{%p} %s: enter aManufacturer=%ls\n", this, "HostUSBDeviceFilter::setManufacturer", aManufacturer));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpManufacturer(aManufacturer);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_MANUFACTURER_ENTER(this, TmpManufacturer.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setManufacturer(TmpManufacturer.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_MANUFACTURER_RETURN(this, hrc, 0 /*normal*/,TmpManufacturer.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_MANUFACTURER_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_MANUFACTURER_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "HostUSBDeviceFilter::setManufacturer", hrc));
    return hrc;
}

STDMETHODIMP HostUSBDeviceFilterWrap::COMGETTER(Product)(BSTR *aProduct)
{
    LogRelFlow(("{%p} %s: enter aProduct=%p\n", this, "HostUSBDeviceFilter::getProduct", aProduct));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProduct);
        BSTROutConverter TmpProduct(aProduct);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_PRODUCT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProduct(TmpProduct.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_PRODUCT_RETURN(this, hrc, 0 /*normal*/,TmpProduct.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_PRODUCT_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_PRODUCT_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aProduct=%ls hrc=%Rhrc\n", this, "HostUSBDeviceFilter::getProduct", *aProduct, hrc));
    return hrc;
}

STDMETHODIMP HostUSBDeviceFilterWrap::COMSETTER(Product)(IN_BSTR aProduct)
{
    LogRelFlow(("{%p} %s: enter aProduct=%ls\n", this, "HostUSBDeviceFilter::setProduct", aProduct));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpProduct(aProduct);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_PRODUCT_ENTER(this, TmpProduct.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setProduct(TmpProduct.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_PRODUCT_RETURN(this, hrc, 0 /*normal*/,TmpProduct.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_PRODUCT_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_PRODUCT_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "HostUSBDeviceFilter::setProduct", hrc));
    return hrc;
}

STDMETHODIMP HostUSBDeviceFilterWrap::COMGETTER(SerialNumber)(BSTR *aSerialNumber)
{
    LogRelFlow(("{%p} %s: enter aSerialNumber=%p\n", this, "HostUSBDeviceFilter::getSerialNumber", aSerialNumber));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSerialNumber);
        BSTROutConverter TmpSerialNumber(aSerialNumber);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_SERIALNUMBER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSerialNumber(TmpSerialNumber.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_SERIALNUMBER_RETURN(this, hrc, 0 /*normal*/,TmpSerialNumber.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_SERIALNUMBER_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_SERIALNUMBER_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSerialNumber=%ls hrc=%Rhrc\n", this, "HostUSBDeviceFilter::getSerialNumber", *aSerialNumber, hrc));
    return hrc;
}

STDMETHODIMP HostUSBDeviceFilterWrap::COMSETTER(SerialNumber)(IN_BSTR aSerialNumber)
{
    LogRelFlow(("{%p} %s: enter aSerialNumber=%ls\n", this, "HostUSBDeviceFilter::setSerialNumber", aSerialNumber));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpSerialNumber(aSerialNumber);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_SERIALNUMBER_ENTER(this, TmpSerialNumber.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setSerialNumber(TmpSerialNumber.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_SERIALNUMBER_RETURN(this, hrc, 0 /*normal*/,TmpSerialNumber.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_SERIALNUMBER_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_SERIALNUMBER_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "HostUSBDeviceFilter::setSerialNumber", hrc));
    return hrc;
}

STDMETHODIMP HostUSBDeviceFilterWrap::COMGETTER(Port)(BSTR *aPort)
{
    LogRelFlow(("{%p} %s: enter aPort=%p\n", this, "HostUSBDeviceFilter::getPort", aPort));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPort);
        BSTROutConverter TmpPort(aPort);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_PORT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPort(TmpPort.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_PORT_RETURN(this, hrc, 0 /*normal*/,TmpPort.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_PORT_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_PORT_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPort=%ls hrc=%Rhrc\n", this, "HostUSBDeviceFilter::getPort", *aPort, hrc));
    return hrc;
}

STDMETHODIMP HostUSBDeviceFilterWrap::COMSETTER(Port)(IN_BSTR aPort)
{
    LogRelFlow(("{%p} %s: enter aPort=%ls\n", this, "HostUSBDeviceFilter::setPort", aPort));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpPort(aPort);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_PORT_ENTER(this, TmpPort.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setPort(TmpPort.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_PORT_RETURN(this, hrc, 0 /*normal*/,TmpPort.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_PORT_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_PORT_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "HostUSBDeviceFilter::setPort", hrc));
    return hrc;
}

STDMETHODIMP HostUSBDeviceFilterWrap::COMGETTER(Remote)(BSTR *aRemote)
{
    LogRelFlow(("{%p} %s: enter aRemote=%p\n", this, "HostUSBDeviceFilter::getRemote", aRemote));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRemote);
        BSTROutConverter TmpRemote(aRemote);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_REMOTE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRemote(TmpRemote.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_REMOTE_RETURN(this, hrc, 0 /*normal*/,TmpRemote.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_REMOTE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_REMOTE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRemote=%ls hrc=%Rhrc\n", this, "HostUSBDeviceFilter::getRemote", *aRemote, hrc));
    return hrc;
}

STDMETHODIMP HostUSBDeviceFilterWrap::COMSETTER(Remote)(IN_BSTR aRemote)
{
    LogRelFlow(("{%p} %s: enter aRemote=%ls\n", this, "HostUSBDeviceFilter::setRemote", aRemote));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpRemote(aRemote);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_REMOTE_ENTER(this, TmpRemote.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setRemote(TmpRemote.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_REMOTE_RETURN(this, hrc, 0 /*normal*/,TmpRemote.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_REMOTE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_REMOTE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "HostUSBDeviceFilter::setRemote", hrc));
    return hrc;
}

STDMETHODIMP HostUSBDeviceFilterWrap::COMGETTER(MaskedInterfaces)(ULONG *aMaskedInterfaces)
{
    LogRelFlow(("{%p} %s: enter aMaskedInterfaces=%p\n", this, "HostUSBDeviceFilter::getMaskedInterfaces", aMaskedInterfaces));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMaskedInterfaces);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_MASKEDINTERFACES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMaskedInterfaces(aMaskedInterfaces);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_MASKEDINTERFACES_RETURN(this, hrc, 0 /*normal*/,*aMaskedInterfaces);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_MASKEDINTERFACES_RETURN(this, hrc, 1 /*hrc exception*/,*aMaskedInterfaces);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_MASKEDINTERFACES_RETURN(this, hrc, 9 /*unhandled exception*/,*aMaskedInterfaces);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMaskedInterfaces=%RU32 hrc=%Rhrc\n", this, "HostUSBDeviceFilter::getMaskedInterfaces", *aMaskedInterfaces, hrc));
    return hrc;
}

STDMETHODIMP HostUSBDeviceFilterWrap::COMSETTER(MaskedInterfaces)(ULONG aMaskedInterfaces)
{
    LogRelFlow(("{%p} %s: enter aMaskedInterfaces=%RU32\n", this, "HostUSBDeviceFilter::setMaskedInterfaces", aMaskedInterfaces));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_MASKEDINTERFACES_ENTER(this, aMaskedInterfaces);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setMaskedInterfaces(aMaskedInterfaces);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_MASKEDINTERFACES_RETURN(this, hrc, 0 /*normal*/,aMaskedInterfaces);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_MASKEDINTERFACES_RETURN(this, hrc, 1 /*hrc exception*/,aMaskedInterfaces);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_MASKEDINTERFACES_RETURN(this, hrc, 9 /*unhandled exception*/,aMaskedInterfaces);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "HostUSBDeviceFilter::setMaskedInterfaces", hrc));
    return hrc;
}

STDMETHODIMP HostUSBDeviceFilterWrap::COMGETTER(InternalAndReservedAttribute1IUSBDeviceFilter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostUSBDeviceFilterWrap::COMGETTER(InternalAndReservedAttribute2IUSBDeviceFilter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostUSBDeviceFilterWrap::COMGETTER(InternalAndReservedAttribute3IUSBDeviceFilter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostUSBDeviceFilterWrap::COMGETTER(InternalAndReservedAttribute4IUSBDeviceFilter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostUSBDeviceFilterWrap::COMGETTER(InternalAndReservedAttribute5IUSBDeviceFilter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostUSBDeviceFilterWrap::COMGETTER(InternalAndReservedAttribute6IUSBDeviceFilter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostUSBDeviceFilterWrap::COMGETTER(InternalAndReservedAttribute7IUSBDeviceFilter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostUSBDeviceFilterWrap::COMGETTER(InternalAndReservedAttribute8IUSBDeviceFilter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

//
// IHostUSBDeviceFilter properties
//

STDMETHODIMP HostUSBDeviceFilterWrap::COMGETTER(Action)(USBDeviceFilterAction_T *aAction)
{
    LogRelFlow(("{%p} %s: enter aAction=%p\n", this, "HostUSBDeviceFilter::getAction", aAction));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAction);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_ACTION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAction(aAction);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_ACTION_RETURN(this, hrc, 0 /*normal*/,*aAction);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_ACTION_RETURN(this, hrc, 1 /*hrc exception*/,*aAction);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_GET_ACTION_RETURN(this, hrc, 9 /*unhandled exception*/,*aAction);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAction=%RU32 hrc=%Rhrc\n", this, "HostUSBDeviceFilter::getAction", *aAction, hrc));
    return hrc;
}

STDMETHODIMP HostUSBDeviceFilterWrap::COMSETTER(Action)(USBDeviceFilterAction_T aAction)
{
    LogRelFlow(("{%p} %s: enter aAction=%RU32\n", this, "HostUSBDeviceFilter::setAction", aAction));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_ACTION_ENTER(this, aAction);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setAction(aAction);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_ACTION_RETURN(this, hrc, 0 /*normal*/,aAction);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_ACTION_RETURN(this, hrc, 1 /*hrc exception*/,aAction);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTUSBDEVICEFILTER_SET_ACTION_RETURN(this, hrc, 9 /*unhandled exception*/,aAction);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "HostUSBDeviceFilter::setAction", hrc));
    return hrc;
}

STDMETHODIMP HostUSBDeviceFilterWrap::COMGETTER(InternalAndReservedAttribute1IHostUSBDeviceFilter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostUSBDeviceFilterWrap::COMGETTER(InternalAndReservedAttribute2IHostUSBDeviceFilter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostUSBDeviceFilterWrap::COMGETTER(InternalAndReservedAttribute3IHostUSBDeviceFilter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostUSBDeviceFilterWrap::COMGETTER(InternalAndReservedAttribute4IHostUSBDeviceFilter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostUSBDeviceFilterWrap::COMGETTER(InternalAndReservedAttribute5IHostUSBDeviceFilter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostUSBDeviceFilterWrap::COMGETTER(InternalAndReservedAttribute6IHostUSBDeviceFilter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostUSBDeviceFilterWrap::COMGETTER(InternalAndReservedAttribute7IHostUSBDeviceFilter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostUSBDeviceFilterWrap::COMGETTER(InternalAndReservedAttribute8IHostUSBDeviceFilter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IUSBDeviceFilter methods
//

//
// IHostUSBDeviceFilter methods
//

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(HostUSBDeviceFilterWrap)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(HostUSBDeviceFilterWrap, IHostUSBDeviceFilter, IUSBDeviceFilter)
#endif // VBOX_WITH_XPCOM
