// A Bison parser, made by GNU Bison 3.8.2.

// Skeleton implementation for Bison LALR(1) parsers in C++

// Copyright (C) 2002-2015, 2018-2021 Free Software Foundation, Inc.

// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

// As a special exception, you may create a larger work that contains
// part or all of the Bison parser skeleton and distribute that work
// under terms of your choice, so long as that work isn't itself a
// parser generator using the skeleton or a modified version thereof
// as a parser skeleton.  Alternatively, if you modify or redistribute
// the parser skeleton itself, you may (at your option) remove this
// special exception, which will cause the skeleton and the resulting
// Bison output files to be licensed under the GNU General Public
// License without this special exception.

// This special exception was added by the Free Software Foundation in
// version 2.2 of Bison.

// DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
// especially those whose name start with YY_ or yy_.  They are
// private implementation details that can be changed or removed.

// "%code top" blocks.
#line 74 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"

    #include "blif_lexer.hpp"
    //Bison calls blifparse_lex() to get the next token.
    //We use the Lexer class as the interface to the lexer, so we
    //re-defined the function to tell Bison how to get the next token.
    static blifparse::Parser::symbol_type blifparse_lex(blifparse::Lexer& lexer) {
        return lexer.next_token();
    }

#line 49 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"

// Take the name prefix into account.
#define yylex   blifparse_lex

// First part of user prologue.
#line 84 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"


#include <stdio.h>
#include "assert.h"

#include "blifparse.hpp"
#include "blif_common.hpp"
#include "blif_error.hpp"

using namespace blifparse;


#line 68 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"


#include "blif_parser.gen.hpp"




#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> // FIXME: INFRINGES ON USER NAME SPACE.
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif


// Whether we are compiled with exception support.
#ifndef YY_EXCEPTIONS
# if defined __GNUC__ && !defined __EXCEPTIONS
#  define YY_EXCEPTIONS 0
# else
#  define YY_EXCEPTIONS 1
# endif
#endif



// Enable debugging if requested.
#if BLIFPARSE_DEBUG

// A pseudo ostream that takes yydebug_ into account.
# define YYCDEBUG if (yydebug_) (*yycdebug_)

# define YY_SYMBOL_PRINT(Title, Symbol)         \
  do {                                          \
    if (yydebug_)                               \
    {                                           \
      *yycdebug_ << Title << ' ';               \
      yy_print_ (*yycdebug_, Symbol);           \
      *yycdebug_ << '\n';                       \
    }                                           \
  } while (false)

# define YY_REDUCE_PRINT(Rule)          \
  do {                                  \
    if (yydebug_)                       \
      yy_reduce_print_ (Rule);          \
  } while (false)

# define YY_STACK_PRINT()               \
  do {                                  \
    if (yydebug_)                       \
      yy_stack_print_ ();                \
  } while (false)

#else // !BLIFPARSE_DEBUG

# define YYCDEBUG if (false) std::cerr
# define YY_SYMBOL_PRINT(Title, Symbol)  YY_USE (Symbol)
# define YY_REDUCE_PRINT(Rule)           static_cast<void> (0)
# define YY_STACK_PRINT()                static_cast<void> (0)

#endif // !BLIFPARSE_DEBUG

#define yyerrok         (yyerrstatus_ = 0)
#define yyclearin       (yyla.clear ())

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYRECOVERING()  (!!yyerrstatus_)

#line 34 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
namespace blifparse {
#line 147 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"

  /// Build a parser object.
  Parser::Parser (Lexer& lexer_yyarg, Callback& callback_yyarg)
#if BLIFPARSE_DEBUG
    : yydebug_ (false),
      yycdebug_ (&std::cerr),
#else
    :
#endif
      lexer (lexer_yyarg),
      callback (callback_yyarg)
  {}

  Parser::~Parser ()
  {}

  Parser::syntax_error::~syntax_error () YY_NOEXCEPT YY_NOTHROW
  {}

  /*---------.
  | symbol.  |
  `---------*/



  // by_state.
  Parser::by_state::by_state () YY_NOEXCEPT
    : state (empty_state)
  {}

  Parser::by_state::by_state (const by_state& that) YY_NOEXCEPT
    : state (that.state)
  {}

  void
  Parser::by_state::clear () YY_NOEXCEPT
  {
    state = empty_state;
  }

  void
  Parser::by_state::move (by_state& that)
  {
    state = that.state;
    that.clear ();
  }

  Parser::by_state::by_state (state_type s) YY_NOEXCEPT
    : state (s)
  {}

  Parser::symbol_kind_type
  Parser::by_state::kind () const YY_NOEXCEPT
  {
    if (state == empty_state)
      return symbol_kind::S_YYEMPTY;
    else
      return YY_CAST (symbol_kind_type, yystos_[+state]);
  }

  Parser::stack_symbol_type::stack_symbol_type ()
  {}

  Parser::stack_symbol_type::stack_symbol_type (YY_RVREF (stack_symbol_type) that)
    : super_type (YY_MOVE (that.state))
  {
    switch (that.kind ())
    {
      case symbol_kind::S_attr: // attr
        value.YY_MOVE_OR_COPY< Attr > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_cname: // cname
        value.YY_MOVE_OR_COPY< Cname > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_conn: // conn
        value.YY_MOVE_OR_COPY< Conn > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_latch_type: // latch_type
        value.YY_MOVE_OR_COPY< LatchType > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_latch_init: // latch_init
      case symbol_kind::S_logic_value: // logic_value
        value.YY_MOVE_OR_COPY< LogicValue > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_names: // names
        value.YY_MOVE_OR_COPY< Names > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_param: // param
        value.YY_MOVE_OR_COPY< Param > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_subckt: // subckt
        value.YY_MOVE_OR_COPY< SubCkt > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_STRING: // STRING
      case symbol_kind::S_latch_control: // latch_control
        value.YY_MOVE_OR_COPY< std::string > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_so_cover_row: // so_cover_row
        value.YY_MOVE_OR_COPY< std::vector<LogicValue> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_string_list: // string_list
        value.YY_MOVE_OR_COPY< std::vector<std::string> > (YY_MOVE (that.value));
        break;

      default:
        break;
    }

#if 201103L <= YY_CPLUSPLUS
    // that is emptied.
    that.state = empty_state;
#endif
  }

  Parser::stack_symbol_type::stack_symbol_type (state_type s, YY_MOVE_REF (symbol_type) that)
    : super_type (s)
  {
    switch (that.kind ())
    {
      case symbol_kind::S_attr: // attr
        value.move< Attr > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_cname: // cname
        value.move< Cname > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_conn: // conn
        value.move< Conn > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_latch_type: // latch_type
        value.move< LatchType > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_latch_init: // latch_init
      case symbol_kind::S_logic_value: // logic_value
        value.move< LogicValue > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_names: // names
        value.move< Names > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_param: // param
        value.move< Param > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_subckt: // subckt
        value.move< SubCkt > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_STRING: // STRING
      case symbol_kind::S_latch_control: // latch_control
        value.move< std::string > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_so_cover_row: // so_cover_row
        value.move< std::vector<LogicValue> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_string_list: // string_list
        value.move< std::vector<std::string> > (YY_MOVE (that.value));
        break;

      default:
        break;
    }

    // that is emptied.
    that.kind_ = symbol_kind::S_YYEMPTY;
  }

#if YY_CPLUSPLUS < 201103L
  Parser::stack_symbol_type&
  Parser::stack_symbol_type::operator= (const stack_symbol_type& that)
  {
    state = that.state;
    switch (that.kind ())
    {
      case symbol_kind::S_attr: // attr
        value.copy< Attr > (that.value);
        break;

      case symbol_kind::S_cname: // cname
        value.copy< Cname > (that.value);
        break;

      case symbol_kind::S_conn: // conn
        value.copy< Conn > (that.value);
        break;

      case symbol_kind::S_latch_type: // latch_type
        value.copy< LatchType > (that.value);
        break;

      case symbol_kind::S_latch_init: // latch_init
      case symbol_kind::S_logic_value: // logic_value
        value.copy< LogicValue > (that.value);
        break;

      case symbol_kind::S_names: // names
        value.copy< Names > (that.value);
        break;

      case symbol_kind::S_param: // param
        value.copy< Param > (that.value);
        break;

      case symbol_kind::S_subckt: // subckt
        value.copy< SubCkt > (that.value);
        break;

      case symbol_kind::S_STRING: // STRING
      case symbol_kind::S_latch_control: // latch_control
        value.copy< std::string > (that.value);
        break;

      case symbol_kind::S_so_cover_row: // so_cover_row
        value.copy< std::vector<LogicValue> > (that.value);
        break;

      case symbol_kind::S_string_list: // string_list
        value.copy< std::vector<std::string> > (that.value);
        break;

      default:
        break;
    }

    return *this;
  }

  Parser::stack_symbol_type&
  Parser::stack_symbol_type::operator= (stack_symbol_type& that)
  {
    state = that.state;
    switch (that.kind ())
    {
      case symbol_kind::S_attr: // attr
        value.move< Attr > (that.value);
        break;

      case symbol_kind::S_cname: // cname
        value.move< Cname > (that.value);
        break;

      case symbol_kind::S_conn: // conn
        value.move< Conn > (that.value);
        break;

      case symbol_kind::S_latch_type: // latch_type
        value.move< LatchType > (that.value);
        break;

      case symbol_kind::S_latch_init: // latch_init
      case symbol_kind::S_logic_value: // logic_value
        value.move< LogicValue > (that.value);
        break;

      case symbol_kind::S_names: // names
        value.move< Names > (that.value);
        break;

      case symbol_kind::S_param: // param
        value.move< Param > (that.value);
        break;

      case symbol_kind::S_subckt: // subckt
        value.move< SubCkt > (that.value);
        break;

      case symbol_kind::S_STRING: // STRING
      case symbol_kind::S_latch_control: // latch_control
        value.move< std::string > (that.value);
        break;

      case symbol_kind::S_so_cover_row: // so_cover_row
        value.move< std::vector<LogicValue> > (that.value);
        break;

      case symbol_kind::S_string_list: // string_list
        value.move< std::vector<std::string> > (that.value);
        break;

      default:
        break;
    }

    // that is emptied.
    that.state = empty_state;
    return *this;
  }
#endif

  template <typename Base>
  void
  Parser::yy_destroy_ (const char* yymsg, basic_symbol<Base>& yysym) const
  {
    if (yymsg)
      YY_SYMBOL_PRINT (yymsg, yysym);
  }

#if BLIFPARSE_DEBUG
  template <typename Base>
  void
  Parser::yy_print_ (std::ostream& yyo, const basic_symbol<Base>& yysym) const
  {
    std::ostream& yyoutput = yyo;
    YY_USE (yyoutput);
    if (yysym.empty ())
      yyo << "empty symbol";
    else
      {
        symbol_kind_type yykind = yysym.kind ();
        yyo << (yykind < YYNTOKENS ? "token" : "nterm")
            << ' ' << yysym.name () << " (";
        YY_USE (yykind);
        yyo << ')';
      }
  }
#endif

  void
  Parser::yypush_ (const char* m, YY_MOVE_REF (stack_symbol_type) sym)
  {
    if (m)
      YY_SYMBOL_PRINT (m, sym);
    yystack_.push (YY_MOVE (sym));
  }

  void
  Parser::yypush_ (const char* m, state_type s, YY_MOVE_REF (symbol_type) sym)
  {
#if 201103L <= YY_CPLUSPLUS
    yypush_ (m, stack_symbol_type (s, std::move (sym)));
#else
    stack_symbol_type ss (s, sym);
    yypush_ (m, ss);
#endif
  }

  void
  Parser::yypop_ (int n) YY_NOEXCEPT
  {
    yystack_.pop (n);
  }

#if BLIFPARSE_DEBUG
  std::ostream&
  Parser::debug_stream () const
  {
    return *yycdebug_;
  }

  void
  Parser::set_debug_stream (std::ostream& o)
  {
    yycdebug_ = &o;
  }


  Parser::debug_level_type
  Parser::debug_level () const
  {
    return yydebug_;
  }

  void
  Parser::set_debug_level (debug_level_type l)
  {
    yydebug_ = l;
  }
#endif // BLIFPARSE_DEBUG

  Parser::state_type
  Parser::yy_lr_goto_state_ (state_type yystate, int yysym)
  {
    int yyr = yypgoto_[yysym - YYNTOKENS] + yystate;
    if (0 <= yyr && yyr <= yylast_ && yycheck_[yyr] == yystate)
      return yytable_[yyr];
    else
      return yydefgoto_[yysym - YYNTOKENS];
  }

  bool
  Parser::yy_pact_value_is_default_ (int yyvalue) YY_NOEXCEPT
  {
    return yyvalue == yypact_ninf_;
  }

  bool
  Parser::yy_table_value_is_error_ (int yyvalue) YY_NOEXCEPT
  {
    return yyvalue == yytable_ninf_;
  }

  int
  Parser::operator() ()
  {
    return parse ();
  }

  int
  Parser::parse ()
  {
    int yyn;
    /// Length of the RHS of the rule being reduced.
    int yylen = 0;

    // Error handling.
    int yynerrs_ = 0;
    int yyerrstatus_ = 0;

    /// The lookahead symbol.
    symbol_type yyla;

    /// The return value of parse ().
    int yyresult;

#if YY_EXCEPTIONS
    try
#endif // YY_EXCEPTIONS
      {
    YYCDEBUG << "Starting parse\n";


    /* Initialize the stack.  The initial state will be set in
       yynewstate, since the latter expects the semantical and the
       location values to have been already stored, initialize these
       stacks with a primary value.  */
    yystack_.clear ();
    yypush_ (YY_NULLPTR, 0, YY_MOVE (yyla));

  /*-----------------------------------------------.
  | yynewstate -- push a new symbol on the stack.  |
  `-----------------------------------------------*/
  yynewstate:
    YYCDEBUG << "Entering state " << int (yystack_[0].state) << '\n';
    YY_STACK_PRINT ();

    // Accept?
    if (yystack_[0].state == yyfinal_)
      YYACCEPT;

    goto yybackup;


  /*-----------.
  | yybackup.  |
  `-----------*/
  yybackup:
    // Try to take a decision without lookahead.
    yyn = yypact_[+yystack_[0].state];
    if (yy_pact_value_is_default_ (yyn))
      goto yydefault;

    // Read a lookahead token.
    if (yyla.empty ())
      {
        YYCDEBUG << "Reading a token\n";
#if YY_EXCEPTIONS
        try
#endif // YY_EXCEPTIONS
          {
            symbol_type yylookahead (yylex (lexer));
            yyla.move (yylookahead);
          }
#if YY_EXCEPTIONS
        catch (const syntax_error& yyexc)
          {
            YYCDEBUG << "Caught exception: " << yyexc.what() << '\n';
            error (yyexc);
            goto yyerrlab1;
          }
#endif // YY_EXCEPTIONS
      }
    YY_SYMBOL_PRINT ("Next token is", yyla);

    if (yyla.kind () == symbol_kind::S_YYerror)
    {
      // The scanner already issued an error message, process directly
      // to error recovery.  But do not keep the error token as
      // lookahead, it is too special and may lead us to an endless
      // loop in error recovery. */
      yyla.kind_ = symbol_kind::S_YYUNDEF;
      goto yyerrlab1;
    }

    /* If the proper action on seeing token YYLA.TYPE is to reduce or
       to detect an error, take that action.  */
    yyn += yyla.kind ();
    if (yyn < 0 || yylast_ < yyn || yycheck_[yyn] != yyla.kind ())
      {
        goto yydefault;
      }

    // Reduce or error.
    yyn = yytable_[yyn];
    if (yyn <= 0)
      {
        if (yy_table_value_is_error_ (yyn))
          goto yyerrlab;
        yyn = -yyn;
        goto yyreduce;
      }

    // Count tokens shifted since error; after three, turn off error status.
    if (yyerrstatus_)
      --yyerrstatus_;

    // Shift the lookahead token.
    yypush_ ("Shifting", state_type (yyn), YY_MOVE (yyla));
    goto yynewstate;


  /*-----------------------------------------------------------.
  | yydefault -- do the default action for the current state.  |
  `-----------------------------------------------------------*/
  yydefault:
    yyn = yydefact_[+yystack_[0].state];
    if (yyn == 0)
      goto yyerrlab;
    goto yyreduce;


  /*-----------------------------.
  | yyreduce -- do a reduction.  |
  `-----------------------------*/
  yyreduce:
    yylen = yyr2_[yyn];
    {
      stack_symbol_type yylhs;
      yylhs.state = yy_lr_goto_state_ (yystack_[yylen].state, yyr1_[yyn]);
      /* Variants are always initialized to an empty instance of the
         correct type. The default '$$ = $1' action is NOT applied
         when using variants.  */
      switch (yyr1_[yyn])
    {
      case symbol_kind::S_attr: // attr
        yylhs.value.emplace< Attr > ();
        break;

      case symbol_kind::S_cname: // cname
        yylhs.value.emplace< Cname > ();
        break;

      case symbol_kind::S_conn: // conn
        yylhs.value.emplace< Conn > ();
        break;

      case symbol_kind::S_latch_type: // latch_type
        yylhs.value.emplace< LatchType > ();
        break;

      case symbol_kind::S_latch_init: // latch_init
      case symbol_kind::S_logic_value: // logic_value
        yylhs.value.emplace< LogicValue > ();
        break;

      case symbol_kind::S_names: // names
        yylhs.value.emplace< Names > ();
        break;

      case symbol_kind::S_param: // param
        yylhs.value.emplace< Param > ();
        break;

      case symbol_kind::S_subckt: // subckt
        yylhs.value.emplace< SubCkt > ();
        break;

      case symbol_kind::S_STRING: // STRING
      case symbol_kind::S_latch_control: // latch_control
        yylhs.value.emplace< std::string > ();
        break;

      case symbol_kind::S_so_cover_row: // so_cover_row
        yylhs.value.emplace< std::vector<LogicValue> > ();
        break;

      case symbol_kind::S_string_list: // string_list
        yylhs.value.emplace< std::vector<std::string> > ();
        break;

      default:
        break;
    }



      // Perform the reduction.
      YY_REDUCE_PRINT (yyn);
#if YY_EXCEPTIONS
      try
#endif // YY_EXCEPTIONS
        {
          switch (yyn)
            {
  case 2: // blif_data: %empty
#line 152 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
                     { }
#line 760 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 3: // blif_data: blif_data ".model" STRING "end-of-line"
#line 153 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
                                            { callback.lineno(lexer.lineno()-1); callback.begin_model(yystack_[1].value.as < std::string > ()); }
#line 766 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 4: // blif_data: blif_data ".inputs" string_list "end-of-line"
#line 154 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
                                            { callback.lineno(lexer.lineno()-1); callback.inputs(yystack_[1].value.as < std::vector<std::string> > ()); }
#line 772 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 5: // blif_data: blif_data ".outputs" string_list "end-of-line"
#line 155 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
                                            { callback.lineno(lexer.lineno()-1); callback.outputs(yystack_[1].value.as < std::vector<std::string> > ()); }
#line 778 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 6: // blif_data: blif_data names
#line 156 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
                                            { callback.lineno(lexer.lineno()-1); callback.names(yystack_[0].value.as < Names > ().nets, yystack_[0].value.as < Names > ().so_cover); }
#line 784 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 7: // blif_data: blif_data subckt "end-of-line"
#line 157 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
                                            { 
                                              if(yystack_[1].value.as < SubCkt > ().ports.size() != yystack_[1].value.as < SubCkt > ().nets.size()) {
                                                  blif_error_wrap(callback ,lexer.lineno()-1, lexer.text(), 
                                                    "Mismatched subckt port and net connection(s) size do not match"
                                                    " (%zu ports, %zu nets)", yystack_[1].value.as < SubCkt > ().ports.size(), yystack_[1].value.as < SubCkt > ().nets.size());
                                              }
                                              callback.lineno(lexer.lineno()-1); 
                                              callback.subckt(yystack_[1].value.as < SubCkt > ().model, yystack_[1].value.as < SubCkt > ().ports, yystack_[1].value.as < SubCkt > ().nets);
                                            }
#line 798 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 8: // blif_data: blif_data latch "end-of-line"
#line 166 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
                                            { /*callback already called */ }
#line 804 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 9: // blif_data: blif_data ".blackbox" "end-of-line"
#line 167 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
                                            { callback.lineno(lexer.lineno()-1); callback.blackbox(); }
#line 810 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 10: // blif_data: blif_data ".end" "end-of-line"
#line 168 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
                                            { callback.lineno(lexer.lineno()-1); callback.end_model(); }
#line 816 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 11: // blif_data: blif_data conn "end-of-line"
#line 169 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
                                            { callback.lineno(lexer.lineno()-1); callback.conn(yystack_[1].value.as < Conn > ().src, yystack_[1].value.as < Conn > ().dst); }
#line 822 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 12: // blif_data: blif_data cname "end-of-line"
#line 170 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
                                            { callback.lineno(lexer.lineno()-1); callback.cname(yystack_[1].value.as < Cname > ().name); }
#line 828 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 13: // blif_data: blif_data attr "end-of-line"
#line 171 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
                                            { callback.lineno(lexer.lineno()-1); callback.attr(yystack_[1].value.as < Attr > ().name, yystack_[1].value.as < Attr > ().value); }
#line 834 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 14: // blif_data: blif_data param "end-of-line"
#line 172 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
                                            { callback.lineno(lexer.lineno()-1); callback.param(yystack_[1].value.as < Param > ().name, yystack_[1].value.as < Param > ().value); }
#line 840 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 15: // blif_data: blif_data "end-of-line"
#line 173 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
                                            { /* eat end-of-lines */}
#line 846 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 16: // names: ".names" string_list "end-of-line"
#line 176 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
                                 { yylhs.value.as < Names > () = Names(); yylhs.value.as < Names > ().nets = yystack_[1].value.as < std::vector<std::string> > (); }
#line 852 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 17: // names: names so_cover_row "end-of-line"
#line 177 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
                             { 
                                yylhs.value.as < Names > () = std::move(yystack_[2].value.as < Names > ()); 
                                if(yylhs.value.as < Names > ().nets.size() != yystack_[1].value.as < std::vector<LogicValue> > ().size()) {
                                    blif_error_wrap(callback, lexer.lineno()-1, lexer.text(),
                                        "Mismatched .names single-output cover row."
                                        " names connected to %zu net(s), but cover row has %zu element(s)",
                                        yylhs.value.as < Names > ().nets.size(), yystack_[1].value.as < std::vector<LogicValue> > ().size());
                                }
                                yylhs.value.as < Names > ().so_cover.push_back(yystack_[1].value.as < std::vector<LogicValue> > ()); 
                             }
#line 867 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 18: // subckt: ".subckt" STRING
#line 189 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
                                { yylhs.value.as < SubCkt > () = SubCkt(); yylhs.value.as < SubCkt > ().model = yystack_[0].value.as < std::string > (); }
#line 873 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 19: // subckt: subckt STRING "=" STRING
#line 190 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
                                { yylhs.value.as < SubCkt > () = std::move(yystack_[3].value.as < SubCkt > ()); yylhs.value.as < SubCkt > ().ports.push_back(yystack_[2].value.as < std::string > ()); yylhs.value.as < SubCkt > ().nets.push_back(yystack_[0].value.as < std::string > ()); }
#line 879 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 20: // latch: ".latch" STRING STRING
#line 193 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
                               {
                                    //Input and output only
                                    callback.lineno(lexer.lineno()); 
                                    callback.latch(yystack_[1].value.as < std::string > (), yystack_[0].value.as < std::string > (), LatchType::UNSPECIFIED, "", LogicValue::UNKOWN);
                               }
#line 889 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 21: // latch: ".latch" STRING STRING latch_type latch_control
#line 198 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
                                                       {
                                    //Input, output, type and control
                                    callback.lineno(lexer.lineno()); 
                                    callback.latch(yystack_[3].value.as < std::string > (), yystack_[2].value.as < std::string > (), yystack_[1].value.as < LatchType > (), yystack_[0].value.as < std::string > (), LogicValue::UNKOWN);
                               }
#line 899 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 22: // latch: ".latch" STRING STRING latch_type latch_control latch_init
#line 203 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
                                                                  {
                                    //Input, output, type, control and init-value
                                    callback.lineno(lexer.lineno()); 
                                    callback.latch(yystack_[4].value.as < std::string > (), yystack_[3].value.as < std::string > (), yystack_[2].value.as < LatchType > (), yystack_[1].value.as < std::string > (), yystack_[0].value.as < LogicValue > ());
                               }
#line 909 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 23: // latch: ".latch" STRING STRING latch_init
#line 208 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
                                         {
                                    //Input, output, and init-value
                                    callback.lineno(lexer.lineno());
                                    callback.latch(yystack_[2].value.as < std::string > (), yystack_[1].value.as < std::string > (), LatchType::UNSPECIFIED, "", yystack_[0].value.as < LogicValue > ());
                               }
#line 919 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 24: // latch_init: "1"
#line 215 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
                       { yylhs.value.as < LogicValue > () = LogicValue::TRUE; }
#line 925 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 25: // latch_init: "0"
#line 216 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
                  { yylhs.value.as < LogicValue > () = LogicValue::FALSE; }
#line 931 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 26: // latch_init: "2"
#line 217 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
                   { yylhs.value.as < LogicValue > () = LogicValue::DONT_CARE; }
#line 937 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 27: // latch_init: "3"
#line 218 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
                   { yylhs.value.as < LogicValue > () = LogicValue::UNKOWN; }
#line 943 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 28: // latch_control: STRING
#line 221 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
                      { yylhs.value.as < std::string > () = yystack_[0].value.as < std::string > ();}
#line 949 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 29: // latch_control: "NIL"
#line 222 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
          { yylhs.value.as < std::string > () = ""; }
#line 955 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 30: // latch_type: "fe"
#line 225 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
                     { yylhs.value.as < LatchType > () = LatchType::FALLING_EDGE; }
#line 961 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 31: // latch_type: "re"
#line 226 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
               { yylhs.value.as < LatchType > () = LatchType::RISING_EDGE; }
#line 967 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 32: // latch_type: "ah"
#line 227 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
               { yylhs.value.as < LatchType > () = LatchType::ACTIVE_HIGH; }
#line 973 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 33: // latch_type: "al"
#line 228 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
               { yylhs.value.as < LatchType > () = LatchType::ACTIVE_LOW; }
#line 979 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 34: // latch_type: "as"
#line 229 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
               { yylhs.value.as < LatchType > () = LatchType::ASYNCHRONOUS; }
#line 985 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 35: // so_cover_row: logic_value
#line 232 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
                          { yylhs.value.as < std::vector<LogicValue> > () = std::vector<LogicValue>(); yylhs.value.as < std::vector<LogicValue> > ().push_back(yystack_[0].value.as < LogicValue > ()); }
#line 991 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 36: // so_cover_row: so_cover_row logic_value
#line 233 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
                               { yylhs.value.as < std::vector<LogicValue> > () = std::move(yystack_[1].value.as < std::vector<LogicValue> > ()); yylhs.value.as < std::vector<LogicValue> > ().push_back(yystack_[0].value.as < LogicValue > ()); }
#line 997 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 37: // logic_value: "1"
#line 236 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
                        { yylhs.value.as < LogicValue > () = LogicValue::TRUE; }
#line 1003 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 38: // logic_value: "0"
#line 237 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
                  { yylhs.value.as < LogicValue > () = LogicValue::FALSE; }
#line 1009 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 39: // logic_value: "-"
#line 238 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
                      { yylhs.value.as < LogicValue > () = LogicValue::DONT_CARE; }
#line 1015 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 40: // string_list: %empty
#line 241 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
                       { yylhs.value.as < std::vector<std::string> > () = std::vector<std::string>(); }
#line 1021 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 41: // string_list: string_list STRING
#line 242 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
                         { yylhs.value.as < std::vector<std::string> > () = std::move(yystack_[1].value.as < std::vector<std::string> > ()); yylhs.value.as < std::vector<std::string> > ().push_back(yystack_[0].value.as < std::string > ()); }
#line 1027 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 42: // conn: ".conn" STRING STRING
#line 248 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
                             { yylhs.value.as < Conn > () = Conn(); yylhs.value.as < Conn > ().src = yystack_[1].value.as < std::string > (); yylhs.value.as < Conn > ().dst = yystack_[0].value.as < std::string > (); }
#line 1033 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 43: // cname: ".cname" STRING
#line 249 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
                        { yylhs.value.as < Cname > () = Cname(); yylhs.value.as < Cname > ().name = yystack_[0].value.as < std::string > (); }
#line 1039 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 44: // attr: ".attr" STRING STRING
#line 250 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
                             { yylhs.value.as < Attr > () = Attr(); yylhs.value.as < Attr > ().name = yystack_[1].value.as < std::string > (); yylhs.value.as < Attr > ().value = yystack_[0].value.as < std::string > (); }
#line 1045 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 45: // attr: ".attr" STRING
#line 251 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
                      { yylhs.value.as < Attr > () = Attr(); yylhs.value.as < Attr > ().name = yystack_[0].value.as < std::string > (); yylhs.value.as < Attr > ().value = ""; }
#line 1051 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 46: // param: ".param" STRING STRING
#line 252 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
                               { yylhs.value.as < Param > () = Param(); yylhs.value.as < Param > ().name = yystack_[1].value.as < std::string > (); yylhs.value.as < Param > ().value = yystack_[0].value.as < std::string > (); }
#line 1057 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;

  case 47: // param: ".param" STRING
#line 253 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
                       { yylhs.value.as < Param > () = Param(); yylhs.value.as < Param > ().name = yystack_[0].value.as < std::string > (); yylhs.value.as < Param > ().value = ""; }
#line 1063 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"
    break;


#line 1067 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"

            default:
              break;
            }
        }
#if YY_EXCEPTIONS
      catch (const syntax_error& yyexc)
        {
          YYCDEBUG << "Caught exception: " << yyexc.what() << '\n';
          error (yyexc);
          YYERROR;
        }
#endif // YY_EXCEPTIONS
      YY_SYMBOL_PRINT ("-> $$ =", yylhs);
      yypop_ (yylen);
      yylen = 0;

      // Shift the result of the reduction.
      yypush_ (YY_NULLPTR, YY_MOVE (yylhs));
    }
    goto yynewstate;


  /*--------------------------------------.
  | yyerrlab -- here on detecting error.  |
  `--------------------------------------*/
  yyerrlab:
    // If not already recovering from an error, report this error.
    if (!yyerrstatus_)
      {
        ++yynerrs_;
        context yyctx (*this, yyla);
        std::string msg = yysyntax_error_ (yyctx);
        error (YY_MOVE (msg));
      }


    if (yyerrstatus_ == 3)
      {
        /* If just tried and failed to reuse lookahead token after an
           error, discard it.  */

        // Return failure if at end of input.
        if (yyla.kind () == symbol_kind::S_YYEOF)
          YYABORT;
        else if (!yyla.empty ())
          {
            yy_destroy_ ("Error: discarding", yyla);
            yyla.clear ();
          }
      }

    // Else will try to reuse lookahead token after shifting the error token.
    goto yyerrlab1;


  /*---------------------------------------------------.
  | yyerrorlab -- error raised explicitly by YYERROR.  |
  `---------------------------------------------------*/
  yyerrorlab:
    /* Pacify compilers when the user code never invokes YYERROR and
       the label yyerrorlab therefore never appears in user code.  */
    if (false)
      YYERROR;

    /* Do not reclaim the symbols of the rule whose action triggered
       this YYERROR.  */
    yypop_ (yylen);
    yylen = 0;
    YY_STACK_PRINT ();
    goto yyerrlab1;


  /*-------------------------------------------------------------.
  | yyerrlab1 -- common code for both syntax error and YYERROR.  |
  `-------------------------------------------------------------*/
  yyerrlab1:
    yyerrstatus_ = 3;   // Each real token shifted decrements this.
    // Pop stack until we find a state that shifts the error token.
    for (;;)
      {
        yyn = yypact_[+yystack_[0].state];
        if (!yy_pact_value_is_default_ (yyn))
          {
            yyn += symbol_kind::S_YYerror;
            if (0 <= yyn && yyn <= yylast_
                && yycheck_[yyn] == symbol_kind::S_YYerror)
              {
                yyn = yytable_[yyn];
                if (0 < yyn)
                  break;
              }
          }

        // Pop the current state because it cannot handle the error token.
        if (yystack_.size () == 1)
          YYABORT;

        yy_destroy_ ("Error: popping", yystack_[0]);
        yypop_ ();
        YY_STACK_PRINT ();
      }
    {
      stack_symbol_type error_token;


      // Shift the error token.
      error_token.state = state_type (yyn);
      yypush_ ("Shifting", YY_MOVE (error_token));
    }
    goto yynewstate;


  /*-------------------------------------.
  | yyacceptlab -- YYACCEPT comes here.  |
  `-------------------------------------*/
  yyacceptlab:
    yyresult = 0;
    goto yyreturn;


  /*-----------------------------------.
  | yyabortlab -- YYABORT comes here.  |
  `-----------------------------------*/
  yyabortlab:
    yyresult = 1;
    goto yyreturn;


  /*-----------------------------------------------------.
  | yyreturn -- parsing is finished, return the result.  |
  `-----------------------------------------------------*/
  yyreturn:
    if (!yyla.empty ())
      yy_destroy_ ("Cleanup: discarding lookahead", yyla);

    /* Do not reclaim the symbols of the rule whose action triggered
       this YYABORT or YYACCEPT.  */
    yypop_ (yylen);
    YY_STACK_PRINT ();
    while (1 < yystack_.size ())
      {
        yy_destroy_ ("Cleanup: popping", yystack_[0]);
        yypop_ ();
      }

    return yyresult;
  }
#if YY_EXCEPTIONS
    catch (...)
      {
        YYCDEBUG << "Exception caught: cleaning lookahead and stack\n";
        // Do not try to display the values of the reclaimed symbols,
        // as their printers might throw an exception.
        if (!yyla.empty ())
          yy_destroy_ (YY_NULLPTR, yyla);

        while (1 < yystack_.size ())
          {
            yy_destroy_ (YY_NULLPTR, yystack_[0]);
            yypop_ ();
          }
        throw;
      }
#endif // YY_EXCEPTIONS
  }

  void
  Parser::error (const syntax_error& yyexc)
  {
    error (yyexc.what ());
  }

  /* Return YYSTR after stripping away unnecessary quotes and
     backslashes, so that it's suitable for yyerror.  The heuristic is
     that double-quoting is unnecessary unless the string contains an
     apostrophe, a comma, or backslash (other than backslash-backslash).
     YYSTR is taken from yytname.  */
  std::string
  Parser::yytnamerr_ (const char *yystr)
  {
    if (*yystr == '"')
      {
        std::string yyr;
        char const *yyp = yystr;

        for (;;)
          switch (*++yyp)
            {
            case '\'':
            case ',':
              goto do_not_strip_quotes;

            case '\\':
              if (*++yyp != '\\')
                goto do_not_strip_quotes;
              else
                goto append;

            append:
            default:
              yyr += *yyp;
              break;

            case '"':
              return yyr;
            }
      do_not_strip_quotes: ;
      }

    return yystr;
  }

  std::string
  Parser::symbol_name (symbol_kind_type yysymbol)
  {
    return yytnamerr_ (yytname_[yysymbol]);
  }



  // Parser::context.
  Parser::context::context (const Parser& yyparser, const symbol_type& yyla)
    : yyparser_ (yyparser)
    , yyla_ (yyla)
  {}

  int
  Parser::context::expected_tokens (symbol_kind_type yyarg[], int yyargn) const
  {
    // Actual number of expected tokens
    int yycount = 0;

    const int yyn = yypact_[+yyparser_.yystack_[0].state];
    if (!yy_pact_value_is_default_ (yyn))
      {
        /* Start YYX at -YYN if negative to avoid negative indexes in
           YYCHECK.  In other words, skip the first -YYN actions for
           this state because they are default actions.  */
        const int yyxbegin = yyn < 0 ? -yyn : 0;
        // Stay within bounds of both yycheck and yytname.
        const int yychecklim = yylast_ - yyn + 1;
        const int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
        for (int yyx = yyxbegin; yyx < yyxend; ++yyx)
          if (yycheck_[yyx + yyn] == yyx && yyx != symbol_kind::S_YYerror
              && !yy_table_value_is_error_ (yytable_[yyx + yyn]))
            {
              if (!yyarg)
                ++yycount;
              else if (yycount == yyargn)
                return 0;
              else
                yyarg[yycount++] = YY_CAST (symbol_kind_type, yyx);
            }
      }

    if (yyarg && yycount == 0 && 0 < yyargn)
      yyarg[0] = symbol_kind::S_YYEMPTY;
    return yycount;
  }






  int
  Parser::yy_syntax_error_arguments_ (const context& yyctx,
                                                 symbol_kind_type yyarg[], int yyargn) const
  {
    /* There are many possibilities here to consider:
       - If this state is a consistent state with a default action, then
         the only way this function was invoked is if the default action
         is an error action.  In that case, don't check for expected
         tokens because there are none.
       - The only way there can be no lookahead present (in yyla) is
         if this state is a consistent state with a default action.
         Thus, detecting the absence of a lookahead is sufficient to
         determine that there is no unexpected or expected token to
         report.  In that case, just report a simple "syntax error".
       - Don't assume there isn't a lookahead just because this state is
         a consistent state with a default action.  There might have
         been a previous inconsistent state, consistent state with a
         non-default action, or user semantic action that manipulated
         yyla.  (However, yyla is currently not documented for users.)
       - Of course, the expected token list depends on states to have
         correct lookahead information, and it depends on the parser not
         to perform extra reductions after fetching a lookahead from the
         scanner and before detecting a syntax error.  Thus, state merging
         (from LALR or IELR) and default reductions corrupt the expected
         token list.  However, the list is correct for canonical LR with
         one exception: it will still contain any token that will not be
         accepted due to an error action in a later state.
    */

    if (!yyctx.lookahead ().empty ())
      {
        if (yyarg)
          yyarg[0] = yyctx.token ();
        int yyn = yyctx.expected_tokens (yyarg ? yyarg + 1 : yyarg, yyargn - 1);
        return yyn + 1;
      }
    return 0;
  }

  // Generate an error message.
  std::string
  Parser::yysyntax_error_ (const context& yyctx) const
  {
    // Its maximum.
    enum { YYARGS_MAX = 5 };
    // Arguments of yyformat.
    symbol_kind_type yyarg[YYARGS_MAX];
    int yycount = yy_syntax_error_arguments_ (yyctx, yyarg, YYARGS_MAX);

    char const* yyformat = YY_NULLPTR;
    switch (yycount)
      {
#define YYCASE_(N, S)                         \
        case N:                               \
          yyformat = S;                       \
        break
      default: // Avoid compiler warnings.
        YYCASE_ (0, YY_("syntax error"));
        YYCASE_ (1, YY_("syntax error, unexpected %s"));
        YYCASE_ (2, YY_("syntax error, unexpected %s, expecting %s"));
        YYCASE_ (3, YY_("syntax error, unexpected %s, expecting %s or %s"));
        YYCASE_ (4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
        YYCASE_ (5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
      }

    std::string yyres;
    // Argument number.
    std::ptrdiff_t yyi = 0;
    for (char const* yyp = yyformat; *yyp; ++yyp)
      if (yyp[0] == '%' && yyp[1] == 's' && yyi < yycount)
        {
          yyres += symbol_name (yyarg[yyi++]);
          ++yyp;
        }
      else
        yyres += *yyp;
    return yyres;
  }


  const signed char Parser::yypact_ninf_ = -28;

  const signed char Parser::yytable_ninf_ = -1;

  const signed char
  Parser::yypact_[] =
  {
     -28,     0,   -28,   -28,   -27,   -20,   -17,   -28,   -28,    -5,
       9,   -28,    12,    23,    24,    26,    27,     5,    30,    32,
      33,    34,    35,     6,    31,    37,   -28,     7,     8,   -28,
     -28,    36,    38,    39,   -28,   -28,   -28,   -28,    18,   -28,
     -28,    40,   -28,   -28,   -28,   -28,   -28,   -28,   -28,     2,
     -28,   -28,   -28,   -28,   -28,   -28,   -28,   -28,    41,   -28,
     -28,   -28,   -28,   -28,   -28,   -28,   -28,   -28,   -28,   -16,
     -28,   -28,   -28,    25,   -28
  };

  const signed char
  Parser::yydefact_[] =
  {
       2,     0,     1,    40,     0,     0,     0,    40,    40,     0,
       0,    15,     0,     0,     0,     0,     6,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    18,     0,     0,    10,
       9,     0,    45,    47,    43,    38,    37,    39,     0,    35,
       7,     0,     8,    11,    12,    13,    14,    16,    41,    20,
       3,     4,     5,    42,    44,    46,    17,    36,     0,    30,
      31,    32,    33,    34,    26,    27,    25,    24,    23,     0,
      19,    29,    28,    21,    22
  };

  const signed char
  Parser::yypgoto_[] =
  {
     -28,   -28,   -28,   -28,   -28,   -11,   -28,   -28,   -28,    28,
      43,   -28,   -28,   -28,   -28
  };

  const signed char
  Parser::yydefgoto_[] =
  {
       0,     1,    16,    17,    18,    68,    73,    69,    38,    39,
      23,    19,    20,    21,    22
  };

  const signed char
  Parser::yytable_[] =
  {
       2,    71,    24,     3,     4,     5,     6,     7,     8,    25,
       9,    10,    26,    72,    59,    60,    61,    62,    63,    29,
      64,    65,    66,    67,    11,    12,    13,    14,    15,    40,
      47,    51,    52,    30,    41,    48,    48,    48,    35,    36,
      37,    31,    56,    64,    65,    66,    67,    35,    36,    37,
      27,    28,    32,    33,    42,    34,    43,    44,    45,    46,
      49,    50,    74,    58,     0,    53,    57,    54,    55,     0,
      70
  };

  const signed char
  Parser::yycheck_[] =
  {
       0,    17,    29,     3,     4,     5,     6,     7,     8,    29,
      10,    11,    29,    29,    12,    13,    14,    15,    16,    24,
      18,    19,    20,    21,    24,    25,    26,    27,    28,    24,
      24,    24,    24,    24,    29,    29,    29,    29,    20,    21,
      22,    29,    24,    18,    19,    20,    21,    20,    21,    22,
       7,     8,    29,    29,    24,    29,    24,    24,    24,    24,
      29,    24,    73,    23,    -1,    29,    38,    29,    29,    -1,
      29
  };

  const signed char
  Parser::yystos_[] =
  {
       0,    31,     0,     3,     4,     5,     6,     7,     8,    10,
      11,    24,    25,    26,    27,    28,    32,    33,    34,    41,
      42,    43,    44,    40,    29,    29,    29,    40,    40,    24,
      24,    29,    29,    29,    29,    20,    21,    22,    38,    39,
      24,    29,    24,    24,    24,    24,    24,    24,    29,    29,
      24,    24,    24,    29,    29,    29,    24,    39,    23,    12,
      13,    14,    15,    16,    18,    19,    20,    21,    35,    37,
      29,    17,    29,    36,    35
  };

  const signed char
  Parser::yyr1_[] =
  {
       0,    30,    31,    31,    31,    31,    31,    31,    31,    31,
      31,    31,    31,    31,    31,    31,    32,    32,    33,    33,
      34,    34,    34,    34,    35,    35,    35,    35,    36,    36,
      37,    37,    37,    37,    37,    38,    38,    39,    39,    39,
      40,    40,    41,    42,    43,    43,    44,    44
  };

  const signed char
  Parser::yyr2_[] =
  {
       0,     2,     0,     4,     4,     4,     2,     3,     3,     3,
       3,     3,     3,     3,     3,     2,     3,     3,     2,     4,
       3,     5,     6,     4,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     1,     1,     1,
       0,     2,     3,     2,     3,     2,     3,     2
  };


#if BLIFPARSE_DEBUG || 1
  // YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
  // First, the terminals, then, starting at \a YYNTOKENS, nonterminals.
  const char*
  const Parser::yytname_[] =
  {
  "\"end-of-file\"", "error", "\"invalid token\"", "\".names\"",
  "\".latch\"", "\".model\"", "\".subckt\"", "\".inputs\"", "\".outputs\"",
  "\".clock\"", "\".end\"", "\".blackbox\"", "\"fe\"", "\"re\"", "\"ah\"",
  "\"al\"", "\"as\"", "\"NIL\"", "\"2\"", "\"3\"", "\"0\"", "\"1\"",
  "\"-\"", "\"=\"", "\"end-of-line\"", "\".conn\"", "\".attr\"",
  "\".param\"", "\".cname\"", "STRING", "$accept", "blif_data", "names",
  "subckt", "latch", "latch_init", "latch_control", "latch_type",
  "so_cover_row", "logic_value", "string_list", "conn", "cname", "attr",
  "param", YY_NULLPTR
  };
#endif


#if BLIFPARSE_DEBUG
  const unsigned char
  Parser::yyrline_[] =
  {
       0,   152,   152,   153,   154,   155,   156,   157,   166,   167,
     168,   169,   170,   171,   172,   173,   176,   177,   189,   190,
     193,   198,   203,   208,   215,   216,   217,   218,   221,   222,
     225,   226,   227,   228,   229,   232,   233,   236,   237,   238,
     241,   242,   248,   249,   250,   251,   252,   253
  };

  void
  Parser::yy_stack_print_ () const
  {
    *yycdebug_ << "Stack now";
    for (stack_type::const_iterator
           i = yystack_.begin (),
           i_end = yystack_.end ();
         i != i_end; ++i)
      *yycdebug_ << ' ' << int (i->state);
    *yycdebug_ << '\n';
  }

  void
  Parser::yy_reduce_print_ (int yyrule) const
  {
    int yylno = yyrline_[yyrule];
    int yynrhs = yyr2_[yyrule];
    // Print the symbols being reduced, and their result.
    *yycdebug_ << "Reducing stack by rule " << yyrule - 1
               << " (line " << yylno << "):\n";
    // The symbols being reduced.
    for (int yyi = 0; yyi < yynrhs; yyi++)
      YY_SYMBOL_PRINT ("   $" << yyi + 1 << " =",
                       yystack_[(yynrhs) - (yyi + 1)]);
  }
#endif // BLIFPARSE_DEBUG


#line 34 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"
} // blifparse
#line 1579 "/build/vtr/src/build/libs/EXTERNAL/libblifparse/blif_parser.gen.cpp"

#line 255 "/build/vtr/src/vtr-verilog-to-routing/libs/EXTERNAL/libblifparse/src/blif_parser.y"


void blifparse::Parser::error(const std::string& msg) {
    blif_error_wrap(callback, lexer.lineno(), lexer.text(), msg.c_str());
}
