/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

public class HeapProportionalCacheSizer {
    public static final String CACHE_RESERVED_SYSTEM_PROPERTY = "org.gradle.cache.reserved.mb";
    private static final int DEFAULT_SIZES_MAX_HEAP_MB = 910;
    private static final int ASSUMED_USED_HEAP = 150;
    private static final double MIN_RATIO = 0.2;
    private final int maxHeapMB;
    private final double sizingRatio;
    private final int reservedHeap;

    public HeapProportionalCacheSizer(int maxHeapMB) {
        this.maxHeapMB = maxHeapMB;
        this.reservedHeap = 150 + Integer.getInteger(CACHE_RESERVED_SYSTEM_PROPERTY, 0);
        this.sizingRatio = this.calculateRatioToDefaultAvailableHeap();
    }

    public HeapProportionalCacheSizer() {
        this(HeapProportionalCacheSizer.calculateMaxHeapMB());
    }

    private static int calculateMaxHeapMB() {
        return (int)(Runtime.getRuntime().maxMemory() / 0x100000L);
    }

    private double calculateRatioToDefaultAvailableHeap() {
        double defaultAvailableHeapSpace = 760.0;
        double availableHeapSpace = this.maxHeapMB - this.reservedHeap;
        double ratioToDefaultAvailableHeap = availableHeapSpace / defaultAvailableHeapSpace;
        return Math.max(ratioToDefaultAvailableHeap, 0.2);
    }

    public int scaleCacheSize(int referenceValue) {
        return this.scaleCacheSize(referenceValue, 100);
    }

    private int scaleCacheSize(int referenceValue, int granularity) {
        if (referenceValue < granularity) {
            throw new IllegalArgumentException("reference value must be larger than granularity");
        }
        int scaledValue = (int)((double)referenceValue * this.sizingRatio) / granularity * granularity;
        return Math.max(scaledValue, granularity);
    }
}

