/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Map;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.menubuilders.generic.BuildPhaseListener;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.EntryAccessor;
import org.freeplane.core.ui.menubuilders.generic.EntryNavigator;
import org.freeplane.core.ui.menubuilders.generic.EntryVisitor;
import org.freeplane.core.ui.menubuilders.generic.PhaseProcessor;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.mode.ModeController;
import org.freeplane.plugin.script.ExecuteScriptAction;
import org.freeplane.plugin.script.ScriptingGuiConfiguration;
import org.freeplane.plugin.script.ScriptingMenuUtils;

public class ScriptingMenuEntryVisitor
implements EntryVisitor,
BuildPhaseListener {
    private ScriptingGuiConfiguration configuration;
    private final HashSet<String> registeredLocations = new HashSet();
    private ModeController modeController;

    public ScriptingMenuEntryVisitor(ScriptingGuiConfiguration configuration, ModeController modeController) {
        this.configuration = configuration;
        this.modeController = modeController;
    }

    public void visit(Entry target) {
        for (Map.Entry<String, String> entry : this.configuration.getMenuTitleToPathMap().entrySet()) {
            String scriptName = entry.getKey();
            ScriptingGuiConfiguration.ScriptMetaData metaData = (ScriptingGuiConfiguration.ScriptMetaData)this.configuration.getMenuTitleToMetaDataMap().get(scriptName);
            if (metaData.hasMenuLocation()) continue;
            for (ExecuteScriptAction.ExecutionMode executionMode : metaData.getExecutionModes()) {
                target.addChild(this.createEntry(scriptName, entry.getValue(), executionMode));
            }
        }
        if (target.isLeaf()) {
            target.addChild(this.createNoScriptsAvailableAction());
        }
    }

    public void buildPhaseFinished(PhaseProcessor.Phase actions, Entry target) {
        if (target.getParent() == null && actions == PhaseProcessor.Phase.ACTIONS) {
            this.buildEntriesWithSpecialMenuLocation(target);
        }
    }

    private void buildEntriesWithSpecialMenuLocation(Entry target) {
        for (Map.Entry<String, String> entry : this.configuration.getMenuTitleToPathMap().entrySet()) {
            ScriptingGuiConfiguration.ScriptMetaData metaData = (ScriptingGuiConfiguration.ScriptMetaData)this.configuration.getMenuTitleToMetaDataMap().get(entry.getKey());
            if (!metaData.hasMenuLocation()) continue;
            this.addEntryForGivenLocation(target.getRoot(), metaData, entry.getValue());
        }
    }

    private void addEntryForGivenLocation(Entry rootEntry, ScriptingGuiConfiguration.ScriptMetaData metaData, String scriptPath) {
        for (ExecuteScriptAction.ExecutionMode executionMode : metaData.getExecutionModes()) {
            String location = metaData.getMenuLocation(executionMode);
            if (!this.registeredLocations.add(location + "/" + metaData.getScriptName())) continue;
            Entry parentEntry = this.findOrCreateEntry(rootEntry, location);
            if (parentEntry == null) {
                throw new RuntimeException("internal error: cannot add entry for " + location);
            }
            Entry entry = this.createEntry(metaData.getScriptName(), scriptPath, executionMode);
            parentEntry.addChild(entry);
        }
    }

    private Entry findOrCreateEntry(Entry rootEntry, String path) {
        EntryNavigator entryNavigator = EntryNavigator.instance();
        Entry entry = entryNavigator.findChildByPath(rootEntry, path);
        if (entry == null) {
            Entry parent = this.findOrCreateEntry(rootEntry, ScriptingMenuUtils.parentLocation(path));
            Entry menuEntry = new Entry();
            menuEntry.setName(this.lastPathElement(path));
            menuEntry.setAttribute("text", (Object)ScriptingMenuUtils.scriptNameToMenuItemTitle(this.lastPathElement(path)));
            parent.addChild(menuEntry);
            return menuEntry;
        }
        return entry;
    }

    private String lastPathElement(String path) {
        int indexOfSlash = path.lastIndexOf(47);
        return path.substring(indexOfSlash + 1);
    }

    private Entry createNoScriptsAvailableAction() {
        Entry entry = new Entry();
        entry.setName("NoScriptsAvailableAction");
        AFreeplaneAction noScriptsAvailableAction = new AFreeplaneAction("NoScriptsAvailableAction", ScriptingMenuUtils.noScriptsAvailableMessage(), null){

            public void actionPerformed(ActionEvent e) {
            }
        };
        new EntryAccessor().setAction(entry, noScriptsAvailableAction);
        return entry;
    }

    private Entry createEntry(String scriptName, String scriptPath, ExecuteScriptAction.ExecutionMode executionMode) {
        ScriptingGuiConfiguration.ScriptMetaData metaData = (ScriptingGuiConfiguration.ScriptMetaData)this.configuration.getMenuTitleToMetaDataMap().get(scriptName);
        String title = ScriptingMenuUtils.getMenuItemTitle(metaData, executionMode);
        return this.createEntry(this.createAction(scriptName, scriptPath, executionMode, metaData, title));
    }

    private Entry createEntry(AFreeplaneAction action) {
        EntryAccessor entryAccessor = new EntryAccessor();
        Entry scriptEntry = new Entry();
        scriptEntry.setName(action.getKey());
        entryAccessor.setAction(scriptEntry, action);
        return scriptEntry;
    }

    private AFreeplaneAction createAction(String scriptName, String scriptPath, ExecuteScriptAction.ExecutionMode executionMode, ScriptingGuiConfiguration.ScriptMetaData metaData, String title) {
        String key = ExecuteScriptAction.makeMenuItemKey(scriptName, executionMode);
        AFreeplaneAction alreadyRegisteredAction = this.modeController.getAction(key);
        if (alreadyRegisteredAction == null) {
            String longTitle = this.createTooltip(title, executionMode);
            String menuItemTitle = this.hasMultipleExcecutionModes(metaData) ? longTitle : title;
            ExecuteScriptAction action = new ExecuteScriptAction(scriptName, menuItemTitle, scriptPath, executionMode, metaData.getPermissions());
            action.putValue("ShortDescription", longTitle);
            action.putValue("LongDescription", longTitle);
            this.modeController.addAction((AFreeplaneAction)action);
            return action;
        }
        return alreadyRegisteredAction;
    }

    private boolean hasMultipleExcecutionModes(ScriptingGuiConfiguration.ScriptMetaData metaData) {
        return metaData.getExecutionModes().size() > 1;
    }

    private String createTooltip(String title, ExecuteScriptAction.ExecutionMode mode) {
        return TextUtils.format((String)this.executionMode2TranslationProperty(mode), (Object[])new Object[]{title});
    }

    private String executionMode2TranslationProperty(ExecuteScriptAction.ExecutionMode mode) {
        switch (mode) {
            case ON_SINGLE_NODE: {
                return "ExecuteScriptOnSingleNode.text";
            }
            case ON_SELECTED_NODE_RECURSIVELY: {
                return "ExecuteScriptOnSelectedNodeRecursively.text";
            }
        }
        return "ExecuteScriptOnSelectedNode.text";
    }

    public boolean shouldSkipChildren(Entry entry) {
        return true;
    }
}

