/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter.condition;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import org.freeplane.core.resources.TranslatedObject;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.ConjunctConditions;
import org.freeplane.features.filter.condition.DecoratedConditionFactory;
import org.freeplane.features.filter.condition.DisjunctConditions;
import org.freeplane.features.filter.condition.IElementaryConditionController;
import org.freeplane.n3.nanoxml.XMLElement;

public class ConditionFactory {
    public static final String FILTER_CONTAINS = ConditionOperator.FILTER_CONTAINS.getPersistedValue();
    public static final String FILTER_CONTAINS_WORDWISE = ConditionOperator.FILTER_CONTAINS_WORDWISE.getPersistedValue();
    public static final String FILTER_DOES_NOT_EXIST = ConditionOperator.FILTER_DOES_NOT_EXIST.getPersistedValue();
    public static final String FILTER_EXIST = ConditionOperator.FILTER_EXIST.getPersistedValue();
    public static final String FILTER_GE = ConditionOperator.FILTER_GE.getPersistedValue();
    public static final String FILTER_GT = ConditionOperator.FILTER_GT.getPersistedValue();
    public static final String FILTER_IS_EQUAL_TO = ConditionOperator.FILTER_IS_EQUAL_TO.getPersistedValue();
    public static final String FILTER_STARTS_WITH = ConditionOperator.FILTER_STARTS_WITH.getPersistedValue();
    public static final String FILTER_IS_NOT_EQUAL_TO = ConditionOperator.FILTER_IS_NOT_EQUAL_TO.getPersistedValue();
    public static final String FILTER_LE = ConditionOperator.FILTER_LE.getPersistedValue();
    public static final String FILTER_LT = ConditionOperator.FILTER_LT.getPersistedValue();
    public static final String FILTER_REGEXP = ConditionOperator.FILTER_REGEXP.getPersistedValue();
    public static final String FILTER_MATCH_CASE = ConditionOption.FILTER_MATCH_CASE.getPersistedValue();
    public static final String FILTER_MATCH_APPROX = ConditionOption.FILTER_MATCH_APPROX.getPersistedValue();
    public static final String FILTER_IGNORE_DIACRITICS = ConditionOption.FILTER_IGNORE_DIACRITICS.getPersistedValue();
    private static final DecoratedConditionFactory DECORATED_CONDITION_FACTORY = new DecoratedConditionFactory();
    private final SortedMap<Integer, IElementaryConditionController> conditionControllers = new TreeMap<Integer, IElementaryConditionController>();

    public void addConditionController(int position, IElementaryConditionController controller) {
        IElementaryConditionController old = this.conditionControllers.put(new Integer(position), controller);
        assert (old == null);
    }

    public Iterator<IElementaryConditionController> conditionIterator() {
        Iterator<IElementaryConditionController> iterator = this.conditionControllers.values().iterator();
        return iterator;
    }

    public ASelectableCondition createCondition(Object selectedItem, TranslatedObject simpleCond, Object value, boolean matchCase, boolean matchApproximately, boolean ignoreDiacritics) {
        return this.getConditionController(selectedItem).createCondition(selectedItem, simpleCond, value, matchCase, matchApproximately, ignoreDiacritics);
    }

    public IElementaryConditionController getConditionController(Object item) {
        Iterator<IElementaryConditionController> iterator = this.conditionIterator();
        while (iterator.hasNext()) {
            IElementaryConditionController next = iterator.next();
            if (!next.canHandle(item)) continue;
            return next;
        }
        throw new NoSuchElementException();
    }

    public ASelectableCondition loadCondition(XMLElement element) {
        ASelectableCondition condition = this.loadAnonymousCondition(element);
        if (condition != null) {
            String userName = element.getAttribute("user_name", null);
            condition.setUserName(userName);
        }
        return condition;
    }

    private ASelectableCondition loadAnonymousCondition(XMLElement element) {
        ASelectableCondition decoratorCondition = DECORATED_CONDITION_FACTORY.createRelativeCondition(this, element);
        if (decoratorCondition != null) {
            return decoratorCondition;
        }
        if (element.getName().equalsIgnoreCase("conjunct_condition")) {
            return ConjunctConditions.load(this, element);
        }
        if (element.getName().equalsIgnoreCase("disjunct_condition")) {
            return DisjunctConditions.load(this, element);
        }
        Iterator<IElementaryConditionController> conditionIterator = this.conditionIterator();
        while (conditionIterator.hasNext()) {
            ASelectableCondition condition = conditionIterator.next().loadCondition(element);
            if (condition == null) continue;
            return condition;
        }
        return null;
    }

    public static enum ConditionOperator {
        FILTER_CONTAINS("filter_contains", "\u22ef", "\u22ef"),
        FILTER_CONTAINS_WORDWISE("filter_contains_wordwise", "\u22c5", "\u22c5"),
        FILTER_DOES_NOT_EXIST("filter_does_not_exist", "!"),
        FILTER_EXIST("filter_exist", ""),
        FILTER_GE(">=", "\u2265"),
        FILTER_GT(">", ">"),
        FILTER_IS_EQUAL_TO("filter_is_equal_to", "="),
        FILTER_STARTS_WITH("filter_starts_with", "", "*"),
        FILTER_IS_NOT_EQUAL_TO("filter_is_not_equal_to", "\u2260"),
        FILTER_LE("<=", "\u2264"),
        FILTER_LT("<", "<"),
        FILTER_REGEXP("filter_regexp_matches", "/", "/"),
        EMPTY("", "", "", "");

        private final String persistedValue;
        private final String operator;
        private final String openingValueDelimiter;
        private final String closingValueDelimiter;

        private ConditionOperator(String persistedValue, String operator) {
            this(persistedValue, operator, "", "");
        }

        private ConditionOperator(String persistedValue, String openingValueDelimiter, String closingValueDelimiter) {
            this(persistedValue, " ", openingValueDelimiter, closingValueDelimiter);
        }

        private ConditionOperator(String persistedValue, String operator, String openingValueDelimiter, String closingValueDelimiter) {
            this.persistedValue = persistedValue;
            this.operator = operator;
            this.openingValueDelimiter = openingValueDelimiter;
            this.closingValueDelimiter = closingValueDelimiter;
        }

        public String getPersistedValue() {
            return this.persistedValue;
        }

        public String getOperator() {
            return this.operator;
        }

        public String getOpeningValueDelimiter() {
            return this.openingValueDelimiter;
        }

        public String getClosingValueDelimiter() {
            return this.closingValueDelimiter;
        }
    }

    public static enum ConditionOption {
        FILTER_MATCH_CASE("filter_match_case", "Aa"),
        FILTER_IGNORE_DIACRITICS("filter_ignore_diacritics", "\u00c3"),
        FILTER_MATCH_APPROX("filter_match_approximately", "\u2248");

        private final String persistedValue;
        private final String displayedOption;

        private ConditionOption(String persistedValue, String displayedOption) {
            this.persistedValue = persistedValue;
            this.displayedOption = displayedOption;
        }

        String getPersistedValue() {
            return this.persistedValue;
        }

        public String getDisplayedOption() {
            return this.displayedOption;
        }
    }
}

