/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.parser;

import io.sf.carte.doc.style.css.CSSExpressionValue;
import io.sf.carte.doc.style.css.CSSMathFunctionValue;
import io.sf.carte.doc.style.css.CSSNumberValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.property.Evaluator;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.echosvg.parser.LengthHandler;
import io.sf.carte.echosvg.parser.ParseException;
import org.w3c.css.om.unit.CSSUnit;
import org.w3c.dom.DOMException;

public class DefaultLengthHandler
implements LengthHandler {
    @Override
    public void startLength() throws ParseException {
    }

    @Override
    public void lengthValue(float v) throws ParseException {
    }

    @Override
    public void em() throws ParseException {
        this.setUnit((short)20);
    }

    @Override
    public void ex() throws ParseException {
        this.setUnit((short)21);
    }

    @Override
    public void lh() throws ParseException {
        this.setUnit((short)25);
    }

    @Override
    public void in() throws ParseException {
        this.setUnit((short)4);
    }

    @Override
    public void cm() throws ParseException {
        this.setUnit((short)7);
    }

    @Override
    public void mm() throws ParseException {
        this.setUnit((short)8);
    }

    @Override
    public void q() throws ParseException {
        this.setUnit((short)9);
    }

    @Override
    public void pc() throws ParseException {
        this.setUnit((short)5);
    }

    @Override
    public void pt() throws ParseException {
        this.setUnit((short)6);
    }

    @Override
    public void px() throws ParseException {
        this.setUnit((short)3);
    }

    @Override
    public void percentage() throws ParseException {
        this.setUnit((short)2);
    }

    @Override
    public void rem() throws ParseException {
        this.setUnit((short)26);
    }

    @Override
    public void rex() throws ParseException {
        this.setUnit((short)28);
    }

    @Override
    public void rlh() throws ParseException {
        this.setUnit((short)27);
    }

    @Override
    public void vh() throws ParseException {
        this.setUnit((short)41);
    }

    @Override
    public void vw() throws ParseException {
        this.setUnit((short)45);
    }

    @Override
    public void vmax() throws ParseException {
        this.setUnit((short)43);
    }

    @Override
    public void vmin() throws ParseException {
        this.setUnit((short)44);
    }

    @Override
    public void mathExpression(CSSExpressionValue value, short pcInterp) throws ParseException {
        float floatValue;
        short unitType;
        LengthEvaluator eval = new LengthEvaluator(pcInterp);
        try {
            CSSTypedValue typed = eval.evaluateExpression(value);
            unitType = typed.getUnitType();
            if (unitType != 0) {
                unitType = 3;
            }
            floatValue = typed.getFloatValue(unitType);
        }
        catch (RuntimeException e) {
            throw new ParseException(e);
        }
        this.lengthValue(floatValue);
        this.setUnit(unitType);
    }

    @Override
    public void mathFunction(CSSMathFunctionValue value, short pcInterp) throws ParseException {
        float floatValue;
        short unitType;
        LengthEvaluator eval = new LengthEvaluator(pcInterp);
        try {
            CSSNumberValue typed = eval.evaluateFunction(value);
            unitType = typed.getUnitType();
            if (unitType != 0) {
                unitType = 3;
            }
            floatValue = typed.getFloatValue(unitType);
        }
        catch (RuntimeException e) {
            throw new ParseException(e);
        }
        this.lengthValue(floatValue);
        this.setUnit(unitType);
    }

    protected float unitToPixels(short unitType, float floatValue, short percentageInterpretation) {
        throw new ParseException("Do not know how to convert to " + CSSUnit.dimensionUnitString((short)unitType), -1, -1);
    }

    protected void setUnit(short unit) {
    }

    @Override
    public void endLength() throws ParseException {
    }

    protected class LengthEvaluator
    extends Evaluator {
        private short percentageInterpretation;

        public LengthEvaluator(short pcInterp) {
            super((short)3);
            this.percentageInterpretation = pcInterp;
        }

        protected CSSTypedValue absoluteTypedValue(CSSTypedValue typed) {
            short unitType = typed.getUnitType();
            if (CSSUnit.isRelativeLengthUnitType((short)unitType)) {
                float f = DefaultLengthHandler.this.unitToPixels(unitType, typed.getFloatValue(unitType), this.percentageInterpretation);
                return NumberValue.createCSSNumberValue((short)3, (float)f);
            }
            return typed;
        }

        protected float percentage(CSSTypedValue typed, short resultType) throws DOMException {
            float f = DefaultLengthHandler.this.unitToPixels((short)2, typed.getFloatValue((short)2), this.percentageInterpretation);
            return NumberValue.floatValueConversion((float)f, (short)3, (short)resultType);
        }

        protected short getPercentageInterpretation() {
            return this.percentageInterpretation;
        }
    }
}

