/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datawindow;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DiscoverableTableUtils;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.app.plugin.core.datawindow.DataRowObject;
import ghidra.app.plugin.core.datawindow.DataWindowPlugin;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressMapImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.DataIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.util.ProgramSelection;
import ghidra.util.LongIterator;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.table.field.AbstractProgramBasedDynamicTableColumn;
import ghidra.util.table.field.AddressTableColumn;
import ghidra.util.task.TaskMonitor;

class DataTableModel
extends AddressBasedTableModel<DataRowObject> {
    static final int ADDRESS_COL_WIDTH = 50;
    static final int SIZE_COL_WIDTH = 30;
    static final int DATA_COL = 0;
    static final int LOCATION_COL = 1;
    static final int TYPE_COL = 2;
    static final int SIZE_COL = 3;
    private DataWindowPlugin plugin;
    private AddressMapImpl addressMap;
    private Listing listing;
    private AddressSet restrictedAddresses;

    DataTableModel(DataWindowPlugin plugin) {
        super("Data", (ServiceProvider)plugin.getTool(), null, null);
        this.plugin = plugin;
    }

    @Override
    protected TableColumnDescriptor<DataRowObject> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new DataValueTableColumn());
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new AddressTableColumn()), 1, true);
        descriptor.addVisibleColumn((DynamicTableColumn)new TypeTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new SizeTableColumn());
        return descriptor;
    }

    void reload(Program newProgram) {
        this.setProgram(newProgram);
        this.restrictedAddresses = this.plugin.getLimitedAddresses();
        if (newProgram != null) {
            this.addressMap = new AddressMapImpl();
            this.listing = newProgram.getListing();
        } else {
            this.addressMap = null;
            this.listing = null;
        }
        this.reload();
    }

    private int getKeyCount() {
        if (this.listing == null) {
            return 0;
        }
        return (int)this.listing.getNumDefinedData();
    }

    protected void doLoad(Accumulator<DataRowObject> accumulator, TaskMonitor monitor) throws CancelledException {
        if (this.listing == null) {
            return;
        }
        monitor.initialize((long)this.getKeyCount());
        int progress = 0;
        DataKeyIterator it = new DataKeyIterator();
        while (it.hasNext()) {
            monitor.setProgress((long)progress++);
            monitor.checkCancelled();
            long key = it.next();
            if (!this.filterAccepts(key)) continue;
            accumulator.add((Object)new DataRowObject(key, this.addressMap));
        }
    }

    private boolean filterAccepts(long key) {
        if (this.listing == null || this.addressMap == null) {
            return false;
        }
        Data data = this.listing.getDataAt(this.addressMap.decodeAddress(key));
        String displayName = data.getDataType().getDisplayName();
        if (this.restrictedAddresses != null) {
            Address minAddress = data.getMinAddress();
            return this.plugin.isTypeEnabled(displayName) && this.restrictedAddresses.contains(minAddress);
        }
        return this.plugin.isTypeEnabled(displayName);
    }

    void dataAdded(Address addr) {
        long key;
        Data data = this.listing.getDataAt(addr);
        if (data != null && this.filterAccepts(key = this.addressMap.getKey(addr))) {
            this.addObject(new DataRowObject(key, this.addressMap));
        }
    }

    void dataRemoved(Address addr) {
        this.removeObject(new DataRowObject(this.addressMap.getKey(addr), this.addressMap));
    }

    @Override
    public ProgramSelection getProgramSelection(int[] rows) {
        AddressSet set = new AddressSet();
        for (int element : rows) {
            DataRowObject rowObject = (DataRowObject)this.getRowObject(element);
            Data data = this.listing.getDataAt(rowObject.getAddress());
            if (data == null) continue;
            set.addRange(data.getMinAddress(), data.getMaxAddress());
        }
        return new ProgramSelection((AddressSetView)set);
    }

    @Override
    public Address getAddress(int row) {
        return ((DataRowObject)this.getRowObject(row)).getAddress();
    }

    private Data getDataForRowObject(DataRowObject t) {
        return this.listing.getDataAt(t.getAddress());
    }

    private class DataValueTableColumn
    extends AbstractProgramBasedDynamicTableColumn<DataRowObject, String> {
        private DataValueTableColumn() {
        }

        public String getColumnName() {
            return "Data";
        }

        public String getValue(DataRowObject rowObject, Settings settings, Program p, ServiceProvider provider) throws IllegalArgumentException {
            Data data = DataTableModel.this.getDataForRowObject(rowObject);
            if (data == null) {
                return null;
            }
            DataType dt = data.getDataType();
            return dt.getRepresentation((MemBuffer)data, settings, data.getLength());
        }
    }

    private class TypeTableColumn
    extends AbstractProgramBasedDynamicTableColumn<DataRowObject, String> {
        private TypeTableColumn() {
        }

        public String getColumnName() {
            return "Type";
        }

        public String getValue(DataRowObject rowObject, Settings settings, Program p, ServiceProvider provider) throws IllegalArgumentException {
            Data data = DataTableModel.this.getDataForRowObject(rowObject);
            if (data == null) {
                return null;
            }
            return data.getDataType().getDisplayName();
        }
    }

    private class SizeTableColumn
    extends AbstractProgramBasedDynamicTableColumn<DataRowObject, Integer> {
        private SizeTableColumn() {
        }

        public String getColumnName() {
            return "Size";
        }

        public Integer getValue(DataRowObject rowObject, Settings settings, Program p, ServiceProvider provider) throws IllegalArgumentException {
            Data data = DataTableModel.this.getDataForRowObject(rowObject);
            if (data == null) {
                return null;
            }
            return data.getLength();
        }
    }

    private class DataKeyIterator
    implements LongIterator {
        private DataIterator it;

        DataKeyIterator() {
            this.it = DataTableModel.this.listing.getDefinedData((AddressSetView)DataTableModel.this.getProgram().getMemory(), true);
        }

        public boolean hasNext() {
            if (this.it == null || DataTableModel.this.getProgram() == null) {
                return false;
            }
            return this.it.hasNext();
        }

        public long next() {
            Data data = this.it.next();
            if (DataTableModel.this.addressMap != null) {
                return DataTableModel.this.addressMap.getKey(data.getMinAddress());
            }
            return 0L;
        }

        public boolean hasPrevious() {
            return false;
        }

        public long previous() {
            return -1L;
        }
    }
}

